WATCOM binary patch file format

mpprint.c z/  _?  +&             ~    i  !  =    $       %       &    z  -  "  >   $.  '#    /  $     53  '  p   ?  1/  I   `?  {/       53  5   Y.  This allows Multipad to print *
 *               0     
 *          0.       else
         $.     ;
    } .     ABORTDOC !     har    far *fpch g      *******/

VOID    	        *
                           ,                                                  C    : Prints the contents of the edit control.                   *
 * ~       *
 *  PURPOSE      ~  /***************************************************************************
 *                                                                         *
 *  MODULE      : MpPrint()                                                *
 *                                                                         *
 *  PURPOSE     : Printing code for MultiPad.                              *
 *                                                                         *
 *  FUNCTIONS   : GetPrinterDC ()          -  Creates a printer DC for the *
 *                                            default device.              *
 *                                                                         *
 *                AbortProc ()             -  Export proc. for GDI to check*
 *                                            print abort.                 *
 *                                                                         *
 *                PrintDlgProc ()          -  Dialog function for the print*
 *                                            cancel dialog.               *
 *                                                                         *
 *                PrintFile ()             -  Prints the contents of the   *
 *                                            edit control.                *
 *                                                                         *
 *                GetInitializationData () -  Gets DC initialisation data  *
 *                                            from a DC supporting         *
 *                                            ExtDeviceMode().             *
 *                                                                         *
 ***************************************************************************/
#include "multipad.h"
#include <malloc.h>

BOOL fAbort;            /* TRUE if the user has aborted the print job    */
HWND hwndPDlg;          /* Handle to the cancel print dialog             */
char szDevice[160];     /* Contains the device, the driver, and the port */
char *szDriver;          /* Pointer to the driver name                    */
PSTR szPort;            /* Port, ie, LPT1                                */
PSTR szTitle;           /* Global pointer to job title                   */
int iPrinter = 0;       /* level of available printer support.           */
                        /* 0 - no printer available                      */
                        /* 1 - printer available                         */
                        /* 2 - driver supports 3.0 device initialization */
HANDLE hInitData=NULL;  /* handle to initialization data                 */
short hInitSize=0;
char *InitData=NULL;

char szExtDeviceMode[] = "EXTDEVICEMODE";

/****************************************************************************
 *                                                                          *
 *  FUNCTION   : GetPrinterDC ()                                            *
 *                                                                          *
 *  PURPOSE    : Creates a printer display context for the default device.  *
 *               As a side effect, it sets the szDevice and szPort variables*
 *               It also sets iPrinter to the supported level of printing.  *
 *                                                                          *
 *  RETURNS    : HDC   - A handle to printer DC.                            *
 *                                                                          *
 ****************************************************************************/
HDC PASCAL GetPrinterDC(void)
{
    char     szT[32];
    HDC      hdc;
    LPSTR    lpdevmode = NULL;
    char far *fpdevmode;
    char     tmp[256];

    iPrinter = 0;

    /* Get the printer information from win.ini into a buffer and
     * null terminate it.
     */
    GetProfileString ( "windows", "device", "" ,szDevice, sizeof(szDevice));
    for (szDriver = szDevice; *szDriver && *szDriver != ','; szDriver++)
        ;
    if (*szDriver)
        *szDriver++ = 0;

    /* From the current position in the buffer, null teminate the
     * list of ports
     */
    for (szPort = szDriver; *szPort && *szPort != ','; szPort++)
        ;
    if (*szPort)
        *szPort++ = 0;

    /* if the device, driver and port buffers all contain meaningful data,
     * proceed.
     */
    if (!*szDevice || !*szDriver || !*szPort){
        *szDevice = 0;
        return NULL;
    }

    /* Create the printer display context */
    if (InitData){
        /* Get a pointer to the initialization data */

        if (strcmp (szDevice, InitData)){
            /* User has changed the device... cancel this setup, as it is
             * invalid (although if we worked harder we could retain some
             * of it).
             */
            lpdevmode = NULL;
            free (InitData);
            InitData = NULL;
        }
    }
    hdc = CreateDC (szDriver, szDevice, szPort, lpdevmode);

    /* Unlock initialization data */

    if (!hdc)
        return NULL;


    iPrinter = 1;

    /* Find out if ExtDeviceMode() is supported and set flag appropriately */
    if (GetProcAddress (GetModuleHandle (szDriver), szExtDeviceMode))
        iPrinter = 2;

    return hdc;

}

/****************************************************************************
 *                                                                          *
 *  FUNCTION   : AbortProc()                                                *
 *                                                                          *
 *  PURPOSE    : To be called by GDI print code to check for user abort.    *
 *                                                                          *
 ****************************************************************************/
int FAR PASCAL AbortProc ( hdc, reserved )
HDC hdc;
WORD reserved;
{
    MSG msg;

    /* Allow other apps to run, or get abort messages */
    while (!fAbort && PeekMessage (&msg, NULL, NULL, NULL, TRUE))
        if (!hwndPDlg || !IsDialogMessage (hwndPDlg, &msg)){
            TranslateMessage (&msg);
            DispatchMessage  (&msg);
        }
    return !fAbort;
}

/****************************************************************************
 *                                                                          *
 *  FUNCTION   : PrintDlgProc ()                                            *
 *                                                                          *
 *  PURPOSE    : Dialog function for the print cancel dialog box.           *
 *                                                                          *
 *  RETURNS    : TRUE  - OK to abort/ not OK to abort                       *
 *               FALSE - otherwise.                                         *
 *                                                                          *
 ****************************************************************************/
BOOL FAR PASCAL PrintDlgProc(HWND hwnd, WORD msg, WORD wParam, LONG lParam)
{
    switch (msg){
        case WM_INITDIALOG:
            /* Set up information in dialog box */
            SetDlgItemText (hwnd, IDD_PRINTDEVICE, (LPSTR)szDevice);
            SetDlgItemText (hwnd, IDD_PRINTPORT, (LPSTR)szPort);
            SetDlgItemText (hwnd, IDD_PRINTTITLE, (LPSTR)szTitle);
            break;

        case WM_COMMAND:
            /* abort printing if the only button gets hit */
            fAbort = TRUE;
            break;

        default:
            return FALSE;
    }
    return TRUE;
}

/****************************************************************************
 *                                                                          *
 *  FUNCTION   : PrintFile ()                                               *
 *                                                                         !     HWND    hwndEdit;
    c #             goto getout;
    lpfnPDlg = MakeProcInstance (PrintDlgProc, hInst);
    if (!lpfnPDlg)
        goto getout4;

    /* Initialize the printer */
    hdc = GetPrinterDC();
    if (!hdc)
         w%              ^&  {           goto getout1;

    /* Initialize the document */
    if (Escape (hdc, STARTDOC, cch, (LPSTR)sz, NULL) < 0)
     S(     = (HANDLE)SendMessage (hwndEdit, EM_GETHANDLE, 0, 0L);

    /* While more lines print out the text */
    while (iLine < nLinesEc){
        if (yExtSoFar + dy > yExtPage){
            /* Reached the end of a page. Tell the device driver to eject a
             * page
             */
            if (Escape (hdc, NEWFRAME, 0, NULL, NULL) < 0 || fAbort)
                goto getout2;
            yExtSoFar = 0;
        }

        /* Get the length and position of the line in the buffer
         * and lock from that offset into the buffer */
        ich = (WORD)SendMessage (hwndEdit, EM_LINEINDEX, iLine, 0L);
        cch = (WORD)SendMessage (hwndEdit, EM_LINELENGTH, ich, 0L);
        fpch = MK_LOCAL32( LocalLock(hT) ) ;
        pch = alloca( cch );
        _fmemcpy( pch, fpch + ich, cch );

        /* Print the line and unlock the text handle */
        TextOut (hdc, 0, yExtSoFar, (LPSTR)pch, cch);
        LocalUnlock (hT);

        /* Test and see if the Abort flag has been set. If yes, exit. */
        if (fAbort)
            goto getout2;

        /* Move down the page */
        yExtSoFar += dy;
        iLine++;
    }

    /* Eject the last page. */
    if (Escape (hdc, NEWFRAME, 0, NULL, NULL) < 0)
        goto getout2;

    /* Complete the document. */
    if (Escape (hdc, ENDDOC, 0, NULL, NULL) < 0){
getout2:
        /* Ran into a problem before NEWFRAME? Abort  $.       /              0                                                                 *
 *  FUNCTION   : GetInitializationData()                                    *
 *                                                                          *
 *  PURPOSE    : Gets DC initialization data from a printer driver          *
 *               supporting ExtDeviceMode(). Called in response to the      *
 *               File/Printer setup menu selection.                         *
 *                                                                          *
 *               This function allows the user to change the printer        *
 *               settings FOR MULTIPAD ONL 3  q   *
 *               applications. In a more sophisticated application, this    *
 *               setup could even be saved on a document-by-document basis. *
 *                                                                          *
 ****************************************************************************/
BOOL PASCAL GetInitializationData( hwnd )
HWND hwnd ;
{
    LPSTR     lpOld;
    LPSTR     lpNew;
    LPSTR     hT;
    FARPROC   lpfn;
    HANDLE    hDrv;
    char      sz[32];
    WORD      cb;
    short     flag;
    HINDIR    hIndir;
    
    /* Pop up dialog for user and retain data in app buffer */
    flag = DM_PROMPT | DM_COPY;

    /* Load the device driver and find the ExtDeviceMode() function */
    wsprintf (sz, "%s.drv", (LPSTR)szDriver);
    if ((hDrv = LoadLibrary (sz)) < 32)
        return FALSE;
    if (!(lpfn = GetProcAddress (hDrv, szExtDeviceMode)))
        return FALSE;

    if (InitData){
        /* We have some old data... we want to modify the previously specified
         * setup rather than starting with the default setup.
         */
        lpOld = InitData;
        flag |= DM_MODIFY;
    }
    else
        lpOld = NULL;

    /* Get the number of bytes needed for the init data */
#ifdef __WINDOWS_386__
    hIndir = GetIndirectFunctionHandle( lpfn, INDIR_WORD, 
        INDIR_WORD, INDIR_DWORD, INDIR_PTR, INDIR_PTR, INDIR_DWORD, 
        INDIR_DWORD, INDIR_WORD, INDIR_ENDLIST );
    cb = (WORD) InvokeIndirectFunction( hIndir, hwnd, hDrv, NULL, szDevice,
        szPort, NULL, NULL, 0 );
#else
    cb = (WORD) lpfn( hwnd, hDrv, NULL, szDevice, szPort, NULL, NULL, 0 );
#endif

    /* Grab some memory for the new data and lock it. */
    hT = malloc( cb );

    /* Post the device mode dialog. 0 flag iff user hits OK button */
#ifdef __WINDOWS_386__
    hIndir = GetIndirectFunctionHandle( lpfn, INDIR_WORD, 
        INDIR_WORD, INDIR_PTR, INDIR_PTR, INDIR_PTR, INDIR_PTR, 
        INDIR_DWORD, INDIR_WORD, INDIR_ENDLIST );
    if ((WORD)InvokeIndirectFunction ( hIndir,
                hwnd,
                 hDrv,
                 (LPDEVMODE)hT,
                 (LPSTR)szDevice,
                 (LPSTR)szPort,
                 (LPDEVMODE)lpOld,
                 (LPSTR)NULL,
                 flag)==IDOK)
        flag = 0;
#else
    if ((WORD)lpfn ( hwnd,
                 hDrv,
                 (LPDEVMODE)hT,
                 (LPSTR)szDevice,
                 (LPSTR)szPort,
                 (LPDEVMODE)lpOld,
                 (LPSTR)NULL,
                 flag)==IDOK)
        flag = 0;
#endif

    /* Unlock the input structures */

    /* If the user hit OK and everything worked, free the original init.
     * data and retain the new one.  Otherwise, toss the new buffer.
     */
    if (flag)
        free (hT);
    else{
        if (InitData) free (InitData);
        -  B I(     T &   -  F -  H -   .     