WATCOM binary patch file format

wstdio.c ?  C  }             +   !                  $  -         S  }  9    	  ]         ;    #  -!    %  =#    )  '  X   *  |'     +  (  |   ,  o)    0  `-    l5  H2    ZB  ->    C  ?     C  ?       )     \\

BO     +   //

//      FILE:    WSTDIO.c

//                        .h"
#include <string *               // Index of first line on TTY in the array
short nLastLine;                // Index of last line on TTY in the array

short nCurrPos;                 // Current TTY line output position
short nStdioCharWidth,
      nStdioCharHeight;  '     ;
char _class[64] 
  S            GetClientRect(hWnd,&rcRect);
         rcRect.bottom -= nStdioCharHeight;
 ]  #	          switch(lParam[i]) {

        case '\r': // return
            // move to the start of the line
            nCurrPos = 0;   // reset the current position in the line
            break;

        case '\n': // new line

            // "scroll" the window
            ++iLinesOut;    // increment lines to scroll
            nCurrPos = 0;   // reset the current position in the line

            ++nLastLine;
            if(nLastLine > MaxLine) nLastLine = 0;

            // clear the new line
            sBuffer = sScrBuff[nLastLine];
            for(j=0; j<80; j++) sBuffer[j] = '\0';
            break;

        case '\b': // backspace

            // move back one space
            if(nCurrPos > 0) {

                --nCurrPos;
                sBuffer[nCurrPos] = '\0';
                rcInvalid.top = MaxLine; rcInvalid.bottom = MaxLine + 1;
                rcInvalid.left = nCurrPos;
                rcInvalid.right = nCurrPos + 1;
                LPtoDP(hDC,(POINT *) &rcInvalid, 2);

                // invalidate the area so that it gets redrawn
                InvalidateRect(hWnd,&rcInvalid, TRUE);

            }
            break;

        case '\t':
            // ignore tabs for now
            break;

        default:
            //add char to buffer
            if(nCurrPos < 80){

                // put the character in the screen buffer
                sBuffer[nCurrPos] = lParam[i]; // add char to screen line

                // calculate area to invalidate
                rcInvalid.top = MaxLine; rcInvalid.bottom = MaxLine + 1;
                rcInvalid.left = nCurrPos;
                ++nCurrPos;
                rcInvalid.right = nCurrPos;

                // only need to invalidate the area if it is on the last line
                if(iLinesOut == 0) {
                    LPtoDP(hDC,(POINT *) &rcInvalid, 2);
                    // invalidate the area so that it gets redrawn
                    InvalidateRect(hWnd,&rcInvalid, FALSE);
                }
            }
            break;
        }
        // force scroll after 2 lines. you will scroll faster if you increase
        // this, but it may not look good.

        if(iLinesOut > 2) {
            StdioUpdate(hWnd, hDC, iLinesOut);
            iLinesOut = 0;
     #             psLine = GetStdioLine(i) + nHPaintBeg;
        TextOut(hDC,
                nHPaintBeg,
                i,
                psLine,
                 %  !           for(j=0; j<81; j++)
     )     ) )  <   L stdioInit(HANDLE hInstance)
{

    WNDCLASS StdioClass; *         memset( &StdioClass,0, sizeof( WNDCLASS ) );
    pStdioClass = &StdioClass;

    pStdioClass->hCursor        = LoadCursor( NULL, IDC_ARROW );
    sprintf( _class,"Stdio%d", hInstance );
    pStdioClass->lpszClassName  = _class E,  P             = CS_HREDRAW | CS_VREDRAW;
    pStdioClass->lpfnWndProc    = (void *) N0  >   _class,
                    (LPSTR)"STDIO",
                 f5     _class X:    lpStr);

    ResetStdioDC(hDC);
    ReleaseDC(hWndStdio,hDC);

    return TRUE;
}


//========================================================================\\

// FUNCTION: StdioWndProc(HWND, unsigned, WORD, LONG)

// PURPOSE:  Process messages for the I/O window. This function should 
//           be exported in the application's .DEF file. 

//========================================================================\\

long FAR PASCAL StdioWndProc( hWnd, message, wParam, lParam )
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{
    PAINTSTRUCT ps;
    HDC hDC;
//  LPPOINT ptMinMaxInfo;
    POINT far * ptMinMaxInfo;


    switch (message)
    {

    case WM_CREATE:

        // initialize stdio variables
        InitStdio(hWnd);
        break;


    case WM_SYSCOLORCHANGE:

        // if the colors have been changed in the control panel,
        // we need to change also.

        StdiobkRGB = GetSysColor(COLOR_WINDOW); // background color
        StdiotextRGB = GetSysColor(COLOR_WINDOWTEXT); // text color
        return DefWindowProc( hWnd, message, wParam, lParam );
        break;

    case WM_GETMINMAXINFO:
        if(!bInited) InitStdio(hWnd);

        // constrain the sizing of the window to 80 by 25 characters.

        ptMinMaxInfo = MK_FP32( (void *) lParam );

        ptMinMaxInfo[1].x = nStdioCharWidth * 80
                             + 2 * GetSystemMetrics(SM_CXFRAME);
        ptMinMaxInfo[1].y = nStdioCharHeight * 26
                             + 2 * GetSystemMetrics(SM_CYFRAME);

        ptMinMaxInfo[4].x = nStdioCharWidth * 80
                             + 2 * GetSystemMetrics(SM_CXFRAME);
        ptMinMaxInfo[4].y = nStdioCharHeight * 26
                             + 2 * GetSystemMetrics(SM_CYFRAME);
        break;

    case WM_PAINT:

        // repaint the Stdio window
        StdioPaint(hWnd);
        break;

    case WM_DESTROY:

        // if specified when created, PostQuitMessage should be called
         C      )   )  $  *     a            U    %   h    ]           ױ          