//#define UNICODE
//#define _UNICODE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <dlgs.h>
#include <mmsystem.h>
#include <shellapi.h>
#ifndef UNDER_CE
#include <shlwapi.h>
#endif
#include <tchar.h>

#include "resource.h"

#include "TTSAPI.H"
#include "SMITTC.C"

#define NUM_BUTTONS 12

#define NOTIFY_ID 1
#define STATUS_BAR_ID 1
#ifdef UNDER_CE
#define COMMAND_BAR_ID 1
#endif

#define HK_CONFIG 1001
#define HK_ABOUT 1002
#define HK_WND 1003
#define HK_TIME 1004
#define HK_READCLIP 1005

#define AppName _T("NWSClock")
#define AppRegKeyName _T("SOFTWARE\\Datajake\\NWSClock")
#define CompanyRegKeyName _T("SOFTWARE\\Datajake")

#define DefaultBackground GetStockObject(WHITE_BRUSH)

static HINSTANCE hInst = NULL;
static HWND hWndTime = NULL;
static HWND hWndTB = NULL;
static HWND hWndSB = NULL;
#ifdef UNDER_CE
static HWND hWndCB = NULL;
#endif
#ifndef UNDER_CE
static HMENU hMenuApp = NULL;
#endif
static HFONT hFont = NULL;
static HBRUSH hBrush = NULL;
static COLORREF TextColor = 0;
static COLORREF BackgroundColor = 0;
static MMRESULT TimerID = 0;
static UINT ErrorMessage = 0;
static BOOL ClockRunning = FALSE;
static BOOL RestartSpeech = FALSE;
static BOOL SetupSpeech = FALSE;
static BOOL SpeakClipboard = FALSE;
static BOOL SpeakCurTime = FALSE;
static BOOL UseReg = FALSE;
#ifndef UNDER_CE
static WINDOWPLACEMENT WPDefault;
#endif
static _TCHAR inifile[MAX_PATH];

static BOOL WritePrivateProfileStringReg(_TCHAR *SubKeyName, _TCHAR *ValueName, _TCHAR *ValueString)
{
	HKEY hKey = NULL;
	_TCHAR regkey[MAX_PATH];
	ZeroMemory(regkey, sizeof(regkey));
	_tcscpy(regkey, AppRegKeyName);
	_tcscat(regkey, _T("\\"));
	_tcscat(regkey, SubKeyName);
	if (RegCreateKeyEx(HKEY_CURRENT_USER, regkey, 0, NULL, 0, KEY_ALL_ACCESS, NULL, &hKey, NULL) == ERROR_SUCCESS)
	{
		DWORD type = REG_SZ;
		DWORD len = _tcslen(ValueString)*sizeof(_TCHAR);
		RegSetValueEx(hKey, ValueName, 0, type, (LPBYTE)ValueString, len);
		RegCloseKey(hKey);
		hKey = NULL;
		return TRUE;
	}
	return FALSE;
}

static DWORD GetPrivateProfileStringReg(_TCHAR *SubKeyName, _TCHAR *ValueName, _TCHAR *DefaultString, _TCHAR *ReturnString, DWORD StringSize)
{
	HKEY hKey = NULL;
	_TCHAR regkey[MAX_PATH];
	ZeroMemory(regkey, sizeof(regkey));
	_tcscpy(regkey, AppRegKeyName);
	_tcscat(regkey, _T("\\"));
	_tcscat(regkey, SubKeyName);
	if (RegOpenKeyEx(HKEY_CURRENT_USER, regkey, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
	{
		DWORD type = REG_SZ;
		DWORD len = StringSize*sizeof(_TCHAR);
		if (RegQueryValueEx(hKey, ValueName, NULL, &type, (LPBYTE)ReturnString, &len) == ERROR_FILE_NOT_FOUND)
		{
			if (DefaultString)
			{
				_tcscpy(ReturnString, DefaultString);
			}
		}
		RegCloseKey(hKey);
		hKey = NULL;
	}
	else
	{
		if (DefaultString)
		{
			_tcscpy(ReturnString, DefaultString);
		}
	}
	return _tcslen(ReturnString);
}

static UINT GetPrivateProfileIntReg(_TCHAR *SubKeyName, _TCHAR *ValueName, INT DefaultInt)
{
	HKEY hKey = NULL;
	UINT ReturnValue = 0;
	_TCHAR regkey[MAX_PATH];
	ZeroMemory(regkey, sizeof(regkey));
	_tcscpy(regkey, AppRegKeyName);
	_tcscat(regkey, _T("\\"));
	_tcscat(regkey, SubKeyName);
	if (RegOpenKeyEx(HKEY_CURRENT_USER, regkey, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
	{
		_TCHAR temp[MAX_PATH];
		DWORD type = REG_SZ;
		DWORD len = sizeof(temp);
		ZeroMemory(temp, sizeof(temp));
		if (RegQueryValueEx(hKey, ValueName, NULL, &type, (LPBYTE)temp, &len) == ERROR_FILE_NOT_FOUND)
		{
			ReturnValue = DefaultInt;
		}
		else
		{
			ReturnValue = _ttoi(temp);
		}
		RegCloseKey(hKey);
		hKey = NULL;
	}
	else
	{
		ReturnValue = DefaultInt;
	}
	return ReturnValue;
}

static BOOL WritePrivateProfileStructReg(_TCHAR *SubKeyName, _TCHAR *ValueName, void *data, DWORD size)
{
	HKEY hKey = NULL;
	_TCHAR regkey[MAX_PATH];
	ZeroMemory(regkey, sizeof(regkey));
	_tcscpy(regkey, AppRegKeyName);
	_tcscat(regkey, _T("\\"));
	_tcscat(regkey, SubKeyName);
	if (RegCreateKeyEx(HKEY_CURRENT_USER, regkey, 0, NULL, 0, KEY_ALL_ACCESS, NULL, &hKey, NULL) == ERROR_SUCCESS)
	{
		DWORD type = REG_BINARY;
		RegSetValueEx(hKey, ValueName, 0, type, (LPBYTE)data, size);
		RegCloseKey(hKey);
		hKey = NULL;
		return TRUE;
	}
	return FALSE;
}

static BOOL GetPrivateProfileStructReg(_TCHAR *SubKeyName, _TCHAR *ValueName, void *data, DWORD size)
{
	HKEY hKey = NULL;
	BOOL ReturnValue = FALSE;
	_TCHAR regkey[MAX_PATH];
	ZeroMemory(regkey, sizeof(regkey));
	_tcscpy(regkey, AppRegKeyName);
	_tcscat(regkey, _T("\\"));
	_tcscat(regkey, SubKeyName);
	if (RegOpenKeyEx(HKEY_CURRENT_USER, regkey, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
	{
		DWORD type = REG_BINARY;
		if (RegQueryValueEx(hKey, ValueName, NULL, &type, (LPBYTE)data, &size) == ERROR_SUCCESS)
		{
			ReturnValue = TRUE;
		}
		RegCloseKey(hKey);
		hKey = NULL;
	}
	return ReturnValue;
}

static BOOL WritePrivateProfileStringWrapper(_TCHAR *SubKeyName, _TCHAR *ValueName, _TCHAR *ValueString, _TCHAR *FileName)
{
#ifdef UNDER_CE
	return WritePrivateProfileStringReg(SubKeyName, ValueName, ValueString);
#else
	if (UseReg)
	{
		return WritePrivateProfileStringReg(SubKeyName, ValueName, ValueString);
	}
	else
	{
		return WritePrivateProfileString(SubKeyName, ValueName, ValueString, FileName);
	}
#endif
}

static DWORD GetPrivateProfileStringWrapper(_TCHAR *SubKeyName, _TCHAR *ValueName, _TCHAR *DefaultString, _TCHAR *ReturnString, DWORD StringSize, _TCHAR *FileName)
{
#ifdef UNDER_CE
	return GetPrivateProfileStringReg(SubKeyName, ValueName, DefaultString, ReturnString, StringSize);
#else
	if (UseReg)
	{
		return GetPrivateProfileStringReg(SubKeyName, ValueName, DefaultString, ReturnString, StringSize);
	}
	else
	{
		return GetPrivateProfileString(SubKeyName, ValueName, DefaultString, ReturnString, StringSize, FileName);
	}
#endif
}

static UINT GetPrivateProfileIntWrapper(_TCHAR *SubKeyName, _TCHAR *ValueName, INT DefaultInt, _TCHAR *FileName)
{
#ifdef UNDER_CE
	return GetPrivateProfileIntReg(SubKeyName, ValueName, DefaultInt);
#else
	if (UseReg)
	{
		return GetPrivateProfileIntReg(SubKeyName, ValueName, DefaultInt);
	}
	else
	{
		return GetPrivateProfileInt(SubKeyName, ValueName, DefaultInt, FileName);
	}
#endif
}

static BOOL WritePrivateProfileStructWrapper(_TCHAR *SubKeyName, _TCHAR *ValueName, void *data, DWORD size, _TCHAR *FileName)
{
#ifdef UNDER_CE
	return WritePrivateProfileStructReg(SubKeyName, ValueName, data, size);
#else
	if (UseReg)
	{
		return WritePrivateProfileStructReg(SubKeyName, ValueName, data, size);
	}
	else
	{
		return WritePrivateProfileStruct(SubKeyName, ValueName, data, size, FileName);
	}
#endif
}

static BOOL GetPrivateProfileStructWrapper(_TCHAR *SubKeyName, _TCHAR *ValueName, void *data, DWORD size, _TCHAR *FileName)
{
#ifdef UNDER_CE
	return GetPrivateProfileStructReg(SubKeyName, ValueName, data, size);
#else
	if (UseReg)
	{
		return GetPrivateProfileStructReg(SubKeyName, ValueName, data, size);
	}
	else
	{
		return GetPrivateProfileStruct(SubKeyName, ValueName, data, size, FileName);
	}
#endif
}

static void DeleteSubKeys()
{
	_TCHAR regkey[MAX_PATH];
	ZeroMemory(regkey, sizeof(regkey));
	_tcscpy(regkey, AppRegKeyName);
	_tcscat(regkey, _T("\\"));
	_tcscat(regkey, _T("Settings"));
	RegDeleteKey(HKEY_CURRENT_USER, regkey);
	ZeroMemory(regkey, sizeof(regkey));
	_tcscpy(regkey, AppRegKeyName);
	_tcscat(regkey, _T("\\"));
	_tcscat(regkey, _T("Appearance"));
	RegDeleteKey(HKEY_CURRENT_USER, regkey);
}

static void DeleteCompanyKey()
{
	HKEY hKey = NULL;
	if (RegOpenKeyEx(HKEY_CURRENT_USER, CompanyRegKeyName, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
	{
		DWORD NumKeys = 0;
		DWORD NumValues = 0;
		RegQueryInfoKey(hKey, NULL, NULL, NULL, &NumKeys, NULL, NULL, &NumValues, NULL, NULL, NULL, NULL);
		if (NumKeys == 0 && NumValues == 0)
		{
			RegDeleteKey(HKEY_CURRENT_USER, CompanyRegKeyName);
		}
		RegCloseKey(hKey);
		hKey = NULL;
	}
}

static LONG DeleteConfig()
{
#ifdef UNDER_CE
	LONG RegError = 0;
	DeleteSubKeys();
	RegError = RegDeleteKey(HKEY_CURRENT_USER, AppRegKeyName);
	DeleteCompanyKey();
	return RegError;
#else
	if (UseReg)
	{
		LONG RegError = 0;
		DeleteSubKeys();
		RegError = RegDeleteKey(HKEY_CURRENT_USER, AppRegKeyName);
		DeleteCompanyKey();
		return RegError;
	}
	else
	{
		DeleteFile(inifile);
		return GetLastError();
	}
#endif
}

static HMENU GetAppMenu(HWND hWnd)
{
	HMENU hMenu = NULL;
#ifdef UNDER_CE
	if (hWndCB)
	{
		hMenu = CommandBar_GetMenu(hWndCB, 0);
	}
#else
	hMenu = GetMenu(hWnd);
	if (!hMenu && hMenuApp)
	{
		hMenu = hMenuApp;
	}
#endif
	return hMenu;
}

static UINT WINAPI HookProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	return 0;
}

static UINT WINAPI WAVHookProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	_TCHAR testbutton[MAX_PATH];
	_TCHAR wavfile[MAX_PATH];
	ZeroMemory(testbutton, sizeof(testbutton));
	ZeroMemory(wavfile, sizeof(wavfile));
	switch (message)
	{
	case WM_INITDIALOG:
		LoadString(hInst, IDS_TESTBUTTON, testbutton, MAX_PATH);
		CommDlg_OpenSave_SetControlText(GetParent(hWnd), pshHelp, testbutton);
		return 1;
	case WM_NOTIFY:
		switch (((OFNOTIFY *)lParam)->hdr.code)
		{
		case CDN_HELP:
			CommDlg_OpenSave_GetFilePath(GetParent(hWnd), wavfile, MAX_PATH);
			PlaySound(wavfile, NULL, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
			return 1;
		}
	}
	return 0;
}

static BOOL WINAPI ConfigDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	UINT i = 0;
	TTS_CAPS_T caps;
	OPENFILENAME ofn;
	_TCHAR defintro[MAX_PATH];
	_TCHAR filter[MAX_PATH];
	_TCHAR filename[MAX_PATH];
	_TCHAR title[MAX_PATH];
	_TCHAR caption[MAX_PATH];
	_TCHAR text[MAX_PATH];
	ZeroMemory(&caps, sizeof(caps));
	ZeroMemory(&ofn, sizeof(ofn));
	ZeroMemory(defintro, sizeof(defintro));
	ZeroMemory(filter, sizeof(filter));
	ZeroMemory(filename, sizeof(filename));
	ZeroMemory(title, sizeof(title));
	ZeroMemory(caption, sizeof(caption));
	ZeroMemory(text, sizeof(text));
	switch (message)
	{
	case WM_INITDIALOG:
		SendDlgItemMessage(hWnd, IDC_TIMEINTRO, EM_LIMITTEXT, MAX_PATH-1, 0);
		SendDlgItemMessage(hWnd, IDC_INTERVALS, UDM_SETRANGE32, 1, 60);
		SendDlgItemMessage(hWnd, IDC_DATEINTRO, EM_LIMITTEXT, MAX_PATH-1, 0);
		for (i = 0; i < waveOutGetNumDevs(); i++)
		{
			WAVEOUTCAPS waveoutcaps;
			ZeroMemory(&waveoutcaps, sizeof(waveoutcaps));
			waveOutGetDevCaps(i, &waveoutcaps, sizeof(waveoutcaps));
			SendDlgItemMessage(hWnd, IDC_DEVICE, CB_INSERTSTRING, i, (LPARAM)waveoutcaps.szPname);
		}
		SendDlgItemMessage(hWnd, IDC_VOLUME, TBM_SETRANGE, 0, MAKELONG(0, 100));
		SendDlgItemMessage(hWnd, IDC_VOLUME, TBM_SETPAGESIZE, 0, 10);
		for (i = 0; i < WENDY + 1; i++)
		{
			ZeroMemory(text, sizeof(text));
			LoadString(hInst, IDS_SPEAKER1 + i, text, MAX_PATH);
			SendDlgItemMessage(hWnd, IDC_SPEAKER, CB_INSERTSTRING, i, (LPARAM)text);
		}
		TextToSpeechGetCaps(&caps);
		SendDlgItemMessage(hWnd, IDC_RATES, UDM_SETRANGE32, caps.dwMinimumSpeakingRate, caps.dwMaximumSpeakingRate);
		SendDlgItemMessage(hWnd, IDC_USERDICT, EM_LIMITTEXT, MAX_PATH-1, 0);
		SendDlgItemMessage(hWnd, IDC_GREETING, EM_LIMITTEXT, MAX_PATH-1, 0);
		SendDlgItemMessage(hWnd, IDC_CLOSING, EM_LIMITTEXT, MAX_PATH-1, 0);
		SendDlgItemMessage(hWnd, IDC_ALARMHOURS, UDM_SETRANGE32, 0, 23);
		SendDlgItemMessage(hWnd, IDC_ALARMMINUTES, UDM_SETRANGE32, 0, 59);
		SendDlgItemMessage(hWnd, IDC_ALARMSECONDS, UDM_SETRANGE32, 0, 59);
		SendDlgItemMessage(hWnd, IDC_ALARMFILE, EM_LIMITTEXT, MAX_PATH-1, 0);
		SendDlgItemMessage(hWnd, IDC_ALARMMESSAGE, EM_LIMITTEXT, MAX_PATH-1, 0);
		SendDlgItemMessage(hWnd, IDC_QUIETAFTERHOURS, UDM_SETRANGE32, 0, 23);
		SendDlgItemMessage(hWnd, IDC_QUIETBEFOREHOURS, UDM_SETRANGE32, 0, 23);
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("StartHidden"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_STARTHIDDEN, BST_CHECKED);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("RegisterHotkeys"), 1, inifile))
		{
			CheckDlgButton(hWnd, IDC_HOTKEY, BST_CHECKED);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("24Hour"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_24HR, BST_CHECKED);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("UniversalTime"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_UTC, BST_CHECKED);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("BypassMarker"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_NOMARKER, BST_CHECKED);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("IncludeZone"), 1, inifile))
		{
			CheckDlgButton(hWnd, IDC_TIMEZONE, BST_CHECKED);
		}
		ZeroMemory(defintro, sizeof(defintro));
		LoadString(hInst, IDS_DEFTIMEINTRO, defintro, MAX_PATH);
		ZeroMemory(text, sizeof(text));
		GetPrivateProfileStringWrapper(_T("Settings"), _T("TimeIntro"), defintro, text, MAX_PATH, inifile);
		SetDlgItemText(hWnd, IDC_TIMEINTRO, text);
		SendDlgItemMessage(hWnd, IDC_INTERVALS, UDM_SETPOS, 0, GetPrivateProfileIntWrapper(_T("Settings"), _T("CheckInterval"), 15, inifile));
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("StartupAnnounce"), 1, inifile))
		{
			CheckDlgButton(hWnd, IDC_STARTUP, BST_CHECKED);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("EndComma"), 1, inifile))
		{
			CheckDlgButton(hWnd, IDC_ENDCOMMA, BST_CHECKED);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("AnnounceDate"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_DATE, BST_CHECKED);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("ShortDate"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_SHORTDATE, BST_CHECKED);
		}
		ZeroMemory(defintro, sizeof(defintro));
		LoadString(hInst, IDS_DEFDATEINTRO, defintro, MAX_PATH);
		ZeroMemory(text, sizeof(text));
		GetPrivateProfileStringWrapper(_T("Settings"), _T("DateIntro"), defintro, text, MAX_PATH, inifile);
		SetDlgItemText(hWnd, IDC_DATEINTRO, text);
		SendDlgItemMessage(hWnd, IDC_DEVICE, CB_SETCURSEL, GetPrivateProfileIntWrapper(_T("Settings"), _T("AudioDevice"), 0, inifile), 0);
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("OwnDevice"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_OWN, BST_CHECKED);
		}
		SendDlgItemMessage(hWnd, IDC_VOLUME, TBM_SETPOS, 0, GetPrivateProfileIntWrapper(_T("Settings"), _T("Volume"), 100, inifile));
		SendDlgItemMessage(hWnd, IDC_SPEAKER, CB_SETCURSEL, GetPrivateProfileIntWrapper(_T("Settings"), _T("Speaker"), PAUL, inifile), 0);
		SendDlgItemMessage(hWnd, IDC_RATES, UDM_SETPOS, 0, GetPrivateProfileIntWrapper(_T("Settings"), _T("Rate"), 180, inifile));
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("ResetSpeech"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_RESET, BST_CHECKED);
		}
		ZeroMemory(text, sizeof(text));
		GetPrivateProfileStringWrapper(_T("Settings"), _T("UserDictionary"), NULL, text, MAX_PATH, inifile);
		SetDlgItemText(hWnd, IDC_USERDICT, text);
		ZeroMemory(text, sizeof(text));
		GetPrivateProfileStringWrapper(_T("Settings"), _T("Greeting"), NULL, text, MAX_PATH, inifile);
		SetDlgItemText(hWnd, IDC_GREETING, text);
		ZeroMemory(text, sizeof(text));
		GetPrivateProfileStringWrapper(_T("Settings"), _T("Closing"), NULL, text, MAX_PATH, inifile);
		SetDlgItemText(hWnd, IDC_CLOSING, text);
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("BeepInterval"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_BEEPINTERVAL, BST_CHECKED);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("Interruptability"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_INTERRUPTABILITY, BST_CHECKED);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("AlarmEnabled"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_ALARMENABLED, BST_CHECKED);
		}
		SendDlgItemMessage(hWnd, IDC_ALARMHOURS, UDM_SETPOS, 0, GetPrivateProfileIntWrapper(_T("Settings"), _T("AlarmHour"), 0, inifile));
		SendDlgItemMessage(hWnd, IDC_ALARMMINUTES, UDM_SETPOS, 0, GetPrivateProfileIntWrapper(_T("Settings"), _T("AlarmMinute"), 0, inifile));
		SendDlgItemMessage(hWnd, IDC_ALARMSECONDS, UDM_SETPOS, 0, GetPrivateProfileIntWrapper(_T("Settings"), _T("AlarmSecond"), 0, inifile));
		ZeroMemory(text, sizeof(text));
		GetPrivateProfileStringWrapper(_T("Settings"), _T("AlarmFile"), NULL, text, MAX_PATH, inifile);
		SetDlgItemText(hWnd, IDC_ALARMFILE, text);
		ZeroMemory(text, sizeof(text));
		GetPrivateProfileStringWrapper(_T("Settings"), _T("AlarmMessage"), NULL, text, MAX_PATH, inifile);
		SetDlgItemText(hWnd, IDC_ALARMMESSAGE, text);
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("QuietMode"), 0, inifile))
		{
			CheckDlgButton(hWnd, IDC_QUIETMODE, BST_CHECKED);
		}
		SendDlgItemMessage(hWnd, IDC_QUIETAFTERHOURS, UDM_SETPOS, 0, GetPrivateProfileIntWrapper(_T("Settings"), _T("QuietAfterHour"), 0, inifile));
		SendDlgItemMessage(hWnd, IDC_QUIETBEFOREHOURS, UDM_SETPOS, 0, GetPrivateProfileIntWrapper(_T("Settings"), _T("QuietBeforeHour"), 0, inifile));
		if (!IsDlgButtonChecked(hWnd, IDC_ALARMENABLED))
		{
			for (i = IDC_ALARMHOUR; i <= IDC_ALARMMESSAGE; i++)
			{
				EnableWindow(GetDlgItem(hWnd, i), FALSE);
			}
		}
		if (!IsDlgButtonChecked(hWnd, IDC_QUIETMODE))
		{
			for (i = IDC_QUIETAFTERHOUR; i <= IDC_QUIETBEFOREHOURS; i++)
			{
				EnableWindow(GetDlgItem(hWnd, i), FALSE);
			}
		}
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDC_USERDICTB:
			LoadString(hInst, IDS_DICFLT, filter, MAX_PATH);
			LoadString(hInst, IDS_DICCAP, caption, MAX_PATH);
			ofn.lStructSize = sizeof(ofn);
			ofn.hwndOwner = hWnd;
			ofn.hInstance = hInst;
			ofn.lpstrFilter = filter;
			ofn.nFilterIndex = 1;
			ofn.lpstrDefExt = _T("DIC");
			ofn.lpstrFile = filename;
			ofn.nMaxFile = MAX_PATH;
			ofn.lpstrFileTitle = title;
			ofn.nMaxFileTitle = MAX_PATH;
			ofn.lpstrTitle = caption;
			ofn.Flags = OFN_ENABLEHOOK | OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
#ifdef OFN_ENABLESIZING
			ofn.Flags |= OFN_ENABLESIZING;
#endif
#ifdef OFN_DONTADDTORECENT
			ofn.Flags |= OFN_DONTADDTORECENT;
#endif
			ofn.lpfnHook = (LPOFNHOOKPROC)HookProc;
			GetDlgItemText(hWnd, IDC_USERDICT, filename, MAX_PATH);
			if (GetOpenFileName(&ofn))
			{
				SetDlgItemText(hWnd, IDC_USERDICT, filename);
			}
			return TRUE;
		case IDC_ALARMENABLED:
			if (IsDlgButtonChecked(hWnd, IDC_ALARMENABLED))
			{
				for (i = IDC_ALARMHOUR; i <= IDC_ALARMMESSAGE; i++)
				{
					EnableWindow(GetDlgItem(hWnd, i), TRUE);
				}
			}
			else
			{
				for (i = IDC_ALARMHOUR; i <= IDC_ALARMMESSAGE; i++)
				{
					EnableWindow(GetDlgItem(hWnd, i), FALSE);
				}
			}
			return TRUE;
		case IDC_ALARMFILEB:
			LoadString(hInst, IDS_WAVFLT, filter, MAX_PATH);
			LoadString(hInst, IDS_WAVCAP, caption, MAX_PATH);
			ofn.lStructSize = sizeof(ofn);
			ofn.hwndOwner = hWnd;
			ofn.hInstance = hInst;
			ofn.lpstrFilter = filter;
			ofn.nFilterIndex = 1;
			ofn.lpstrDefExt = _T("WAV");
			ofn.lpstrFile = filename;
			ofn.nMaxFile = MAX_PATH;
			ofn.lpstrFileTitle = title;
			ofn.nMaxFileTitle = MAX_PATH;
			ofn.lpstrTitle = caption;
			ofn.Flags = OFN_ENABLEHOOK | OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR | OFN_SHOWHELP;
#ifdef OFN_ENABLESIZING
			ofn.Flags |= OFN_ENABLESIZING;
#endif
#ifdef OFN_DONTADDTORECENT
			ofn.Flags |= OFN_DONTADDTORECENT;
#endif
			ofn.lpfnHook = (LPOFNHOOKPROC)WAVHookProc;
			GetDlgItemText(hWnd, IDC_ALARMFILE, filename, MAX_PATH);
			if (GetOpenFileName(&ofn))
			{
				SetDlgItemText(hWnd, IDC_ALARMFILE, filename);
			}
			PlaySound(NULL, NULL, SND_ASYNC);
			return TRUE;
		case IDC_QUIETMODE:
			if (IsDlgButtonChecked(hWnd, IDC_QUIETMODE))
			{
				for (i = IDC_QUIETAFTERHOUR; i <= IDC_QUIETBEFOREHOURS; i++)
				{
					EnableWindow(GetDlgItem(hWnd, i), TRUE);
				}
			}
			else
			{
				for (i = IDC_QUIETAFTERHOUR; i <= IDC_QUIETBEFOREHOURS; i++)
				{
					EnableWindow(GetDlgItem(hWnd, i), FALSE);
				}
			}
			return TRUE;
		case IDOK:
		case IDC_APPLY:
			if (IsDlgButtonChecked(hWnd, IDC_STARTHIDDEN))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("StartHidden"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("StartHidden"), _T("0"), inifile);
			}
			if (IsDlgButtonChecked(hWnd, IDC_HOTKEY))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("RegisterHotkeys"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("RegisterHotkeys"), _T("0"), inifile);
			}
			if (IsDlgButtonChecked(hWnd, IDC_24HR))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("24Hour"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("24Hour"), _T("0"), inifile);
			}
			if (IsDlgButtonChecked(hWnd, IDC_UTC))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("UniversalTime"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("UniversalTime"), _T("0"), inifile);
			}
			if (IsDlgButtonChecked(hWnd, IDC_NOMARKER))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("BypassMarker"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("BypassMarker"), _T("0"), inifile);
			}
			if (IsDlgButtonChecked(hWnd, IDC_TIMEZONE))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("IncludeZone"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("IncludeZone"), _T("0"), inifile);
			}
			ZeroMemory(text, sizeof(text));
			GetDlgItemText(hWnd, IDC_TIMEINTRO, text, MAX_PATH);
			WritePrivateProfileStringWrapper(_T("Settings"), _T("TimeIntro"), text, inifile);
			ZeroMemory(text, sizeof(text));
			_stprintf(text, _T("%d"), SendDlgItemMessage(hWnd, IDC_INTERVALS, UDM_GETPOS, 0, 0));
			WritePrivateProfileStringWrapper(_T("Settings"), _T("CheckInterval"), text, inifile);
			if (IsDlgButtonChecked(hWnd, IDC_STARTUP))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("StartupAnnounce"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("StartupAnnounce"), _T("0"), inifile);
			}
			if (IsDlgButtonChecked(hWnd, IDC_ENDCOMMA))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("EndComma"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("EndComma"), _T("0"), inifile);
			}
			if (IsDlgButtonChecked(hWnd, IDC_DATE))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("AnnounceDate"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("AnnounceDate"), _T("0"), inifile);
			}
			if (IsDlgButtonChecked(hWnd, IDC_SHORTDATE))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("ShortDate"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("ShortDate"), _T("0"), inifile);
			}
			ZeroMemory(text, sizeof(text));
			GetDlgItemText(hWnd, IDC_DATEINTRO, text, MAX_PATH);
			WritePrivateProfileStringWrapper(_T("Settings"), _T("DateIntro"), text, inifile);
			ZeroMemory(text, sizeof(text));
			_stprintf(text, _T("%d"), SendDlgItemMessage(hWnd, IDC_DEVICE, CB_GETCURSEL, 0, 0));
			WritePrivateProfileStringWrapper(_T("Settings"), _T("AudioDevice"), text, inifile);
			if (IsDlgButtonChecked(hWnd, IDC_OWN))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("OwnDevice"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("OwnDevice"), _T("0"), inifile);
			}
			ZeroMemory(text, sizeof(text));
			_stprintf(text, _T("%d"), SendDlgItemMessage(hWnd, IDC_VOLUME, TBM_GETPOS, 0, 0));
			WritePrivateProfileStringWrapper(_T("Settings"), _T("Volume"), text, inifile);
			ZeroMemory(text, sizeof(text));
			_stprintf(text, _T("%d"), SendDlgItemMessage(hWnd, IDC_SPEAKER, CB_GETCURSEL, 0, 0));
			WritePrivateProfileStringWrapper(_T("Settings"), _T("Speaker"), text, inifile);
			ZeroMemory(text, sizeof(text));
			_stprintf(text, _T("%d"), SendDlgItemMessage(hWnd, IDC_RATES, UDM_GETPOS, 0, 0));
			WritePrivateProfileStringWrapper(_T("Settings"), _T("Rate"), text, inifile);
			if (IsDlgButtonChecked(hWnd, IDC_RESET))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("ResetSpeech"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("ResetSpeech"), _T("0"), inifile);
			}
			ZeroMemory(text, sizeof(text));
			GetDlgItemText(hWnd, IDC_USERDICT, text, MAX_PATH);
			WritePrivateProfileStringWrapper(_T("Settings"), _T("UserDictionary"), text, inifile);
			ZeroMemory(text, sizeof(text));
			GetDlgItemText(hWnd, IDC_GREETING, text, MAX_PATH);
			WritePrivateProfileStringWrapper(_T("Settings"), _T("Greeting"), text, inifile);
			ZeroMemory(text, sizeof(text));
			GetDlgItemText(hWnd, IDC_CLOSING, text, MAX_PATH);
			WritePrivateProfileStringWrapper(_T("Settings"), _T("Closing"), text, inifile);
			if (IsDlgButtonChecked(hWnd, IDC_BEEPINTERVAL))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("BeepInterval"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("BeepInterval"), _T("0"), inifile);
			}
			if (IsDlgButtonChecked(hWnd, IDC_INTERRUPTABILITY))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("Interruptability"), _T("1"), inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("Interruptability"), _T("0"), inifile);
			}
			if (IsDlgButtonChecked(hWnd, IDC_ALARMENABLED))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("AlarmEnabled"), _T("1"), inifile);
				ZeroMemory(text, sizeof(text));
				_stprintf(text, _T("%d"), SendDlgItemMessage(hWnd, IDC_ALARMHOURS, UDM_GETPOS, 0, 0));
				WritePrivateProfileStringWrapper(_T("Settings"), _T("AlarmHour"), text, inifile);
				ZeroMemory(text, sizeof(text));
				_stprintf(text, _T("%d"), SendDlgItemMessage(hWnd, IDC_ALARMMINUTES, UDM_GETPOS, 0, 0));
				WritePrivateProfileStringWrapper(_T("Settings"), _T("AlarmMinute"), text, inifile);
				ZeroMemory(text, sizeof(text));
				_stprintf(text, _T("%d"), SendDlgItemMessage(hWnd, IDC_ALARMSECONDS, UDM_GETPOS, 0, 0));
				WritePrivateProfileStringWrapper(_T("Settings"), _T("AlarmSecond"), text, inifile);
				ZeroMemory(text, sizeof(text));
				GetDlgItemText(hWnd, IDC_ALARMFILE, text, MAX_PATH);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("AlarmFile"), text, inifile);
				ZeroMemory(text, sizeof(text));
				GetDlgItemText(hWnd, IDC_ALARMMESSAGE, text, MAX_PATH);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("AlarmMessage"), text, inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("AlarmEnabled"), _T("0"), inifile);
			}
			if (IsDlgButtonChecked(hWnd, IDC_QUIETMODE))
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("QuietMode"), _T("1"), inifile);
				ZeroMemory(text, sizeof(text));
				_stprintf(text, _T("%d"), SendDlgItemMessage(hWnd, IDC_QUIETAFTERHOURS, UDM_GETPOS, 0, 0));
				WritePrivateProfileStringWrapper(_T("Settings"), _T("QuietAfterHour"), text, inifile);
				ZeroMemory(text, sizeof(text));
				_stprintf(text, _T("%d"), SendDlgItemMessage(hWnd, IDC_QUIETBEFOREHOURS, UDM_GETPOS, 0, 0));
				WritePrivateProfileStringWrapper(_T("Settings"), _T("QuietBeforeHour"), text, inifile);
			}
			else
			{
				WritePrivateProfileStringWrapper(_T("Settings"), _T("QuietMode"), _T("0"), inifile);
			}
			if (LOWORD(wParam) == IDOK)
			{
				EndDialog(hWnd, TRUE);
			}
			return TRUE;
		case IDCANCEL:
			EndDialog(hWnd, FALSE);
			return TRUE;
		}
	}
	return FALSE;
}

static BOOL WINAPI INIDialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	HKEY hKey = NULL;
	LONG RegError = 0;
	OPENFILENAME ofn;
	_TCHAR filter[MAX_PATH];
	_TCHAR filename[MAX_PATH];
	_TCHAR title[MAX_PATH];
	_TCHAR caption[MAX_PATH];
	_TCHAR text[MAX_PATH];
	ZeroMemory(&ofn, sizeof(ofn));
	ZeroMemory(filter, sizeof(filter));
	ZeroMemory(filename, sizeof(filename));
	ZeroMemory(title, sizeof(title));
	ZeroMemory(caption, sizeof(caption));
	ZeroMemory(text, sizeof(text));
	switch (message)
	{
	case WM_INITDIALOG:
		SendDlgItemMessage(hWnd, IDC_INIFILE, EM_LIMITTEXT, MAX_PATH-1, 0);
		RegError = RegOpenKeyEx(HKEY_CURRENT_USER, AppRegKeyName, 0, KEY_READ, &hKey);
		if (RegError == ERROR_SUCCESS)
		{
			DWORD type = REG_SZ;
			DWORD len = sizeof(text);
			DWORD usereg = 0;
			if (RegQueryValueEx(hKey, _T("ConfigFile"), NULL, &type, (LPBYTE)text, &len) == ERROR_FILE_NOT_FOUND)
			{
				_tcscpy(text, inifile);
			}
			SetDlgItemText(hWnd, IDC_INIFILE, text);
			type = REG_DWORD;
			len = sizeof(DWORD);
			RegQueryValueEx(hKey, _T("UseRegistry"), NULL, &type, (LPBYTE)&usereg, &len);
			if (usereg)
			{
				CheckDlgButton(hWnd, IDC_USEREG, BST_CHECKED);
			}
			RegCloseKey(hKey);
			hKey = NULL;
		}
		else
		{
			_tcscpy(text, inifile);
			SetDlgItemText(hWnd, IDC_INIFILE, text);
			if (RegError != ERROR_FILE_NOT_FOUND)
			{
				LoadString(hInst, IDS_ERRCAP, caption, MAX_PATH);
				LoadString(hInst, IDS_ERRREG, text, MAX_PATH);
				MessageBox(hWnd, text, caption, MB_ICONERROR);
			}
		}
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDC_INIFILEB:
			LoadString(hInst, IDS_INIFLT, filter, MAX_PATH);
			LoadString(hInst, IDS_INICAP, caption, MAX_PATH);
			ofn.lStructSize = sizeof(ofn);
			ofn.hwndOwner = hWnd;
			ofn.hInstance = hInst;
			ofn.lpstrFilter = filter;
			ofn.nFilterIndex = 1;
			ofn.lpstrDefExt = _T("INI");
			ofn.lpstrFile = filename;
			ofn.nMaxFile = MAX_PATH;
			ofn.lpstrFileTitle = title;
			ofn.nMaxFileTitle = MAX_PATH;
			ofn.lpstrTitle = caption;
			ofn.Flags = OFN_ENABLEHOOK | OFN_HIDEREADONLY | OFN_LONGNAMES | OFN_NOCHANGEDIR | OFN_OVERWRITEPROMPT;
			ofn.lpfnHook = (LPOFNHOOKPROC)HookProc;
			if (GetSaveFileName(&ofn))
			{
				SetDlgItemText(hWnd, IDC_INIFILE, filename);
			}
			return TRUE;
		case IDOK:
			if (RegCreateKeyEx(HKEY_CURRENT_USER, AppRegKeyName, 0, NULL, 0, KEY_ALL_ACCESS, NULL, &hKey, NULL) == ERROR_SUCCESS)
			{
				DWORD type = REG_SZ;
				DWORD len = sizeof(text);
				DWORD NumKeys = 0;
				DWORD NumValues = 0;
				if (GetDlgItemText(hWnd, IDC_INIFILE, text, MAX_PATH))
				{
					RegSetValueEx(hKey, _T("ConfigFile"), 0, type, (LPBYTE)text, len);
				}
				else
				{
					RegDeleteValue(hKey, _T("ConfigFile"));
				}
				type = REG_DWORD;
				len = sizeof(DWORD);
				if (IsDlgButtonChecked(hWnd, IDC_USEREG))
				{
					DWORD usereg = 1;
					RegSetValueEx(hKey, _T("UseRegistry"), 0, type, (LPBYTE)&usereg, len);
				}
				else
				{
					RegDeleteValue(hKey, _T("UseRegistry"));
				}
				RegQueryInfoKey(hKey, NULL, NULL, NULL, &NumKeys, NULL, NULL, &NumValues, NULL, NULL, NULL, NULL);
				if (NumKeys == 0 && NumValues == 0)
				{
					RegDeleteKey(HKEY_CURRENT_USER, AppRegKeyName);
				}
				RegCloseKey(hKey);
				hKey = NULL;
				DeleteCompanyKey();
				if (GetParent(hWnd))
				{
					LoadString(hInst, IDS_INFOCAP, caption, MAX_PATH);
					LoadString(hInst, IDS_INFORESTART, text, MAX_PATH);
					MessageBox(hWnd, text, caption, MB_ICONINFORMATION);
				}
			}
			else
			{
				LoadString(hInst, IDS_ERRCAP, caption, MAX_PATH);
				LoadString(hInst, IDS_ERRREG, text, MAX_PATH);
				MessageBox(hWnd, text, caption, MB_ICONERROR);
			}
			EndDialog(hWnd, TRUE);
			return TRUE;
		case IDCANCEL:
			EndDialog(hWnd, FALSE);
			return TRUE;
		}
	}
	return FALSE;
}

static HWND CreateTimeDisplay(HWND hWndParent)
{
	return CreateWindow(_T("Static"), NULL, SS_CENTER | WS_CHILD | WS_VISIBLE, 0, 0, 0, 0, hWndParent, NULL, hInst, NULL);
}

static HWND CreateToolBar(HWND hWndParent)
{
	HWND hWnd = NULL;
	int TBString = 0;
	TBBUTTON TBButtons[NUM_BUTTONS];
	ZeroMemory(TBButtons, sizeof(TBButtons));
	hWnd = CreateWindow(TOOLBARCLASSNAME, NULL, TBSTYLE_WRAPABLE | WS_CHILD, 0, 0, 0, 0, hWndParent, NULL, hInst, NULL);
	if (!hWnd)
	{
		return NULL;
	}
	TBString = SendMessage(hWnd, TB_ADDSTRING, (WPARAM)hInst, (LPARAM)IDS_TOOLBAR);
	TBButtons[0].idCommand = IDM_SPEAKTIME;
	TBButtons[0].fsState = TBSTATE_ENABLED;
	TBButtons[0].fsStyle = TBSTYLE_AUTOSIZE;
	TBButtons[0].iString = TBString;
	TBButtons[1].fsStyle = TBSTYLE_SEP;
	TBButtons[2].idCommand = IDM_CONFIGURE;
	TBButtons[2].fsState = TBSTATE_ENABLED;
	TBButtons[2].fsStyle = TBSTYLE_AUTOSIZE;
	TBButtons[2].iString = TBString + 1;
	TBButtons[3].idCommand = IDM_DELETE;
	TBButtons[3].fsState = TBSTATE_ENABLED;
	TBButtons[3].fsStyle = TBSTYLE_AUTOSIZE;
	TBButtons[3].iString = TBString + 2;
	TBButtons[4].idCommand = IDM_SETPATH;
	TBButtons[4].fsState = TBSTATE_ENABLED;
	TBButtons[4].fsStyle = TBSTYLE_AUTOSIZE;
	TBButtons[4].iString = TBString + 3;
	TBButtons[5].fsStyle = TBSTYLE_SEP;
	TBButtons[6].idCommand = IDM_RESTARTSPEECH;
	TBButtons[6].fsState = TBSTATE_ENABLED;
	TBButtons[6].fsStyle = TBSTYLE_AUTOSIZE;
	TBButtons[6].iString = TBString + 4;
	TBButtons[7].fsStyle = TBSTYLE_SEP;
	TBButtons[8].idCommand = IDM_READCLIP;
	TBButtons[8].fsState = TBSTATE_ENABLED;
	TBButtons[8].fsStyle = TBSTYLE_AUTOSIZE;
	TBButtons[8].iString = TBString + 5;
	TBButtons[9].idCommand = IDM_EMPTYCLIP;
	TBButtons[9].fsState = TBSTATE_ENABLED;
	TBButtons[9].fsStyle = TBSTYLE_AUTOSIZE;
	TBButtons[9].iString = TBString + 6;
	TBButtons[10].fsStyle = TBSTYLE_SEP;
	TBButtons[11].idCommand = IDM_ABOUT;
	TBButtons[11].fsState = TBSTATE_ENABLED;
	TBButtons[11].fsStyle = TBSTYLE_AUTOSIZE;
	TBButtons[11].iString = TBString + 7;
	SendMessage(hWnd, TB_BUTTONSTRUCTSIZE, sizeof(TBBUTTON), 0);
	SendMessage(hWnd, TB_ADDBUTTONS, NUM_BUTTONS, (LPARAM)&TBButtons);
	SendMessage(hWnd, TB_AUTOSIZE, 0, 0);
	ShowWindow(hWnd, SW_SHOW);
	return hWnd;
}

static void CenterStaticText(HWND hWndParent, HWND hStatic, _TCHAR *text)
{
	HDC hDCParent = NULL;
	HFONT hFontStatic = NULL;
	RECT ParentRect;
	RECT TextRect;
	int width = 0;
	int height = 0;
	int x = 0;
	int y = 0;
	ZeroMemory(&ParentRect, sizeof(ParentRect));
	ZeroMemory(&TextRect, sizeof(TextRect));
	GetClientRect(hWndParent, &ParentRect);
	hDCParent = GetDC(hWndParent);
	hFontStatic = (HFONT)SendMessage(hStatic, WM_GETFONT, 0, 0);
	if (hDCParent && hFontStatic)
	{
		SelectObject(hDCParent, hFontStatic);
		hFontStatic = NULL;
	}
	if (hDCParent)
	{
		DrawText(hDCParent, text, -1, &TextRect, DT_CALCRECT);
		ReleaseDC(hWndParent, hDCParent);
		hDCParent = NULL;
	}
	width = TextRect.right - TextRect.left;
	height = TextRect.bottom - TextRect.top;
	x = (ParentRect.right - width) / 2;
	y = (ParentRect.bottom - height) / 2;
	if (MoveWindow(hStatic, x, y, width, height, TRUE))
	{
		if (InvalidateRect(hWndParent, &ParentRect, TRUE))
		{
			SetWindowText(hStatic, text);
		}
	}
}

static void RegisterTrayIcon(HWND hWnd, BOOL Register)
{
	NOTIFYICONDATA niData;
	ZeroMemory(&niData, sizeof(niData));
	niData.cbSize = sizeof(niData);
	niData.uID = NOTIFY_ID;
	niData.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
	niData.hWnd = hWnd;
	niData.hIcon = LoadIcon(hInst, MAKEINTRESOURCE(IDI_ICON));
	niData.uCallbackMessage = WM_APP;
	_tcscpy(niData.szTip, AppName);
	if (Register)
	{
#ifndef UNDER_CE
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("SavePosition"), 0, inifile))
		{
			WINDOWPLACEMENT wp;
			ZeroMemory(&wp, sizeof(wp));
			wp.length = sizeof(wp);
			if (GetWindowPlacement(hWnd, &wp))
			{
				WritePrivateProfileStructWrapper(_T("Appearance"), _T("WindowPlacement"), &wp, sizeof(wp), inifile);
			}
		}
#endif
		ShowWindow(hWnd, SW_HIDE);
		Shell_NotifyIcon(NIM_ADD,&niData);
	}
	else
	{
		Shell_NotifyIcon(NIM_DELETE,&niData);
		ShowWindow(hWnd, SW_RESTORE);
		SetForegroundWindow(hWnd);
#ifndef UNDER_CE
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("SavePosition"), 0, inifile))
		{
			WINDOWPLACEMENT wp;
			ZeroMemory(&wp, sizeof(wp));
			if (GetPrivateProfileStructWrapper(_T("Appearance"), _T("WindowPlacement"), &wp, sizeof(wp), inifile))
			{
				SetWindowPlacement(hWnd, &wp);
			}
		}
#endif
	}
}

static BOOL WINAPI EnumChildProc(HWND hWnd, LPARAM lParam)
{
	if (MoveWindow(hWnd, 0, 0, LOWORD(lParam), HIWORD(lParam), FALSE))
	{
		return TRUE;
	}
	return FALSE;
}

static void WINAPI TimerProc(UINT uTimerID, UINT uMsg, DWORD dwUser, DWORD dw1, DWORD dw2)
{
	SYSTEMTIME curtime;
	_TCHAR picture[MAX_PATH];
	_TCHAR format[MAX_PATH];
	ZeroMemory(&curtime, sizeof(curtime));
	ZeroMemory(picture, sizeof(picture));
	ZeroMemory(format, sizeof(format));
	if (hWndTime && uTimerID == TimerID)
	{
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("UniversalTime"), 0, inifile))
		{
			GetSystemTime(&curtime);
		}
		else
		{
			GetLocalTime(&curtime);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("24Hour"), 0, inifile))
		{
			if (GetPrivateProfileIntWrapper(_T("Settings"), _T("IncludeSeconds"), 1, inifile))
			{
				LoadString(hInst, IDS_PICTURE24S, picture, MAX_PATH);
			}
			else
			{
				LoadString(hInst, IDS_PICTURE24, picture, MAX_PATH);
			}
		}
		else
		{
			if (GetPrivateProfileIntWrapper(_T("Settings"), _T("IncludeSeconds"), 1, inifile))
			{
				LoadString(hInst, IDS_PICTURE12S, picture, MAX_PATH);
			}
			else
			{
				LoadString(hInst, IDS_PICTURE12, picture, MAX_PATH);
			}
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("BypassMarker"), 0, inifile))
		{
			if (GetPrivateProfileIntWrapper(_T("Settings"), _T("IncludeSeconds"), 1, inifile))
			{
				GetTimeFormat(LOCALE_SYSTEM_DEFAULT, TIME_NOTIMEMARKER, &curtime, picture, format, MAX_PATH);
			}
			else
			{
				GetTimeFormat(LOCALE_SYSTEM_DEFAULT, TIME_NOSECONDS | TIME_NOTIMEMARKER, &curtime, picture, format, MAX_PATH);
			}
		}
		else
		{
			if (GetPrivateProfileIntWrapper(_T("Settings"), _T("IncludeSeconds"), 1, inifile))
			{
				GetTimeFormat(LOCALE_SYSTEM_DEFAULT, 0, &curtime, picture, format, MAX_PATH);
			}
			else
			{
				GetTimeFormat(LOCALE_SYSTEM_DEFAULT, TIME_NOSECONDS, &curtime, picture, format, MAX_PATH);
			}
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("UniversalTime"), 0, inifile))
		{
			_tcscat(format, _T(" UTC"));
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("AnnounceDate"), 0, inifile))
		{
			_TCHAR dateformat[MAX_PATH];
			ZeroMemory(dateformat, sizeof(dateformat));
			if (GetPrivateProfileIntWrapper(_T("Settings"), _T("ShortDate"), 0, inifile))
			{
				GetDateFormat(LOCALE_SYSTEM_DEFAULT, DATE_SHORTDATE, &curtime, NULL, dateformat, MAX_PATH);
			}
			else
			{
				GetDateFormat(LOCALE_SYSTEM_DEFAULT, DATE_LONGDATE, &curtime, NULL, dateformat, MAX_PATH);
			}
			_tcscat(format, _T("\n"));
			_tcscat(format, dateformat);
		}
		CenterStaticText((HWND)dwUser, hWndTime, format);
	}
}

static LRESULT WINAPI WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	HMENU hMenu = NULL;
	HMENU hMenuSub = NULL;
	HDC hDC = NULL;
	LONG WindowStyle = 0;
	MENUITEMINFO MenuInfo;
	RECT rect;
	TIMECAPS tc;
	POINT pt;
	CHOOSEFONT cf;
	LOGFONT lf;
	CHOOSECOLOR cc;
	COLORREF cr[16];
	_TCHAR caption[MAX_PATH];
	_TCHAR text[MAX_PATH];
	ZeroMemory(&MenuInfo, sizeof(MenuInfo));
	ZeroMemory(&rect, sizeof(rect));
	ZeroMemory(&tc, sizeof(tc));
	ZeroMemory(&pt, sizeof(pt));
	ZeroMemory(&cf, sizeof(cf));
	ZeroMemory(&lf, sizeof(lf));
	ZeroMemory(&cc, sizeof(cc));
	ZeroMemory(cr, sizeof(cr));
	ZeroMemory(caption, sizeof(caption));
	ZeroMemory(text, sizeof(text));
	MenuInfo.cbSize = sizeof(MenuInfo);
	MenuInfo.fMask = MIIM_STATE;
	switch (message)
	{
	case WM_CREATE:
#ifndef UNDER_CE
		WPDefault.length = sizeof(WPDefault);
		GetWindowPlacement(hWnd, &WPDefault);
#endif
		timeGetDevCaps(&tc, sizeof(tc));
		timeBeginPeriod(tc.wPeriodMin);
#ifdef UNDER_CE
		hWndCB = CommandBar_Create(hInst, hWnd, COMMAND_BAR_ID);
		if (hWndCB)
		{
			CommandBar_InsertMenubar(hWndCB, hInst, IDR_MENU, 0);
		}
#endif
		hMenu = GetAppMenu(hWnd);
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("PaintTime"), 1, inifile))
		{
			CheckMenuItem(hMenu, IDM_PAINTTIME, MF_CHECKED);
			hWndTime = CreateTimeDisplay(hWnd);
			TimerID = timeSetEvent(1000, tc.wPeriodMin, (LPTIMECALLBACK)TimerProc, (DWORD)hWnd, TIME_PERIODIC);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("IncludeSeconds"), 1, inifile))
		{
			CheckMenuItem(hMenu, IDM_SECONDS, MF_CHECKED);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("ToolBar"), 1, inifile))
		{
			CheckMenuItem(hMenu, IDM_TOOLBAR, MF_CHECKED);
			hWndTB = CreateToolBar(hWnd);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("StatusBar"), 1, inifile))
		{
			CheckMenuItem(hMenu, IDM_STATUSBAR, MF_CHECKED);
			LoadString(hInst, IDS_DEFSTATUSTEXT, text, MAX_PATH);
			hWndSB = CreateStatusWindow(WS_CHILD | WS_VISIBLE, text, hWnd, STATUS_BAR_ID);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("OnTop"), 0, inifile))
		{
			CheckMenuItem(hMenu, IDM_ONTOP, MF_CHECKED);
			SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("ShowTitle"), 1, inifile))
		{
			CheckMenuItem(hMenu, IDM_TITLE, MF_CHECKED);
		}
		else
		{
			WindowStyle = GetWindowLong(hWnd, GWL_STYLE);
			WindowStyle &= ~WS_CAPTION;
			SetWindowLong(hWnd, GWL_STYLE, WindowStyle);
			SetWindowPos(hWnd, NULL, 0, 0, 0, 0, SWP_FRAMECHANGED | SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER);
		}
		TextColor = GetPrivateProfileIntWrapper(_T("Appearance"), _T("FontColor"), 0, inifile);
		if (GetPrivateProfileStructWrapper(_T("Appearance"), _T("LogFont"), &lf, sizeof(lf), inifile))
		{
			hFont = CreateFontIndirect(&lf);
			if (hWndTime && hFont)
			{
				SendMessage(hWndTime, WM_SETFONT, (WPARAM)hFont, TRUE);
			}
		}
		BackgroundColor = GetPrivateProfileIntWrapper(_T("Appearance"), _T("BackgroundColor"), RGB(0xff, 0xff, 0xff), inifile);
		hBrush = CreateSolidBrush(BackgroundColor);
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("RegisterHotkeys"), 1, inifile))
		{
			RegisterHotKey(hWnd, HK_CONFIG, MOD_ALT, VK_F7);
			RegisterHotKey(hWnd, HK_ABOUT, MOD_ALT, VK_F8);
			RegisterHotKey(hWnd, HK_WND, MOD_ALT, VK_F11);
			RegisterHotKey(hWnd, HK_TIME, MOD_ALT, VK_F12);
			RegisterHotKey(hWnd, HK_READCLIP, MOD_CONTROL | MOD_ALT | MOD_SHIFT, 0x52);
		}
#ifndef UNDER_CE
		hMenu = GetSystemMenu(hWnd, FALSE);
		AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);
		ZeroMemory(text, sizeof(text));
		LoadString(hInst, IDS_MENUBAR, text, MAX_PATH);
		AppendMenu(hMenu, MF_STRING, IDM_HIDEMENU, text);
		ZeroMemory(text, sizeof(text));
		LoadString(hInst, IDS_WINDOWPOS, text, MAX_PATH);
		AppendMenu(hMenu, MF_STRING, IDM_SAVEPOS, text);
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("HideMenu"), 0, inifile))
		{
			CheckMenuItem(hMenu, IDM_HIDEMENU, MF_CHECKED);
			hMenuApp = GetMenu(hWnd);
			SetMenu(hWnd, NULL);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("SavePosition"), 0, inifile))
		{
			CheckMenuItem(hMenu, IDM_SAVEPOS, MF_CHECKED);
		}
#endif
		PostMessage(hWnd, WM_TIMER, 0, 0);
		return 0;
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDM_CONFIGURE:
			if (DialogBox(hInst, MAKEINTRESOURCE(IDD_CONFIGDIALOG), hWnd, (DLGPROC)ConfigDialogProc))
			{
				SetupSpeech = TRUE;
				PostMessage(hWnd, WM_TIMER, 0, 0);
				if (GetPrivateProfileIntWrapper(_T("Settings"), _T("RegisterHotkeys"), 1, inifile))
				{
					RegisterHotKey(hWnd, HK_CONFIG, MOD_ALT, VK_F7);
					RegisterHotKey(hWnd, HK_ABOUT, MOD_ALT, VK_F8);
					RegisterHotKey(hWnd, HK_WND, MOD_ALT, VK_F11);
					RegisterHotKey(hWnd, HK_TIME, MOD_ALT, VK_F12);
					RegisterHotKey(hWnd, HK_READCLIP, MOD_CONTROL | MOD_ALT | MOD_SHIFT, 0x52);
				}
				else
				{
					UnregisterHotKey(hWnd, HK_CONFIG);
					UnregisterHotKey(hWnd, HK_ABOUT);
					UnregisterHotKey(hWnd, HK_WND);
					UnregisterHotKey(hWnd, HK_TIME);
					UnregisterHotKey(hWnd, HK_READCLIP);
				}
			}
			return 0;
		case IDM_DELETE:
			LoadString(hInst, IDS_QUESTCAP, caption, MAX_PATH);
			LoadString(hInst, IDS_QUESTCONF, text, MAX_PATH);
			if (MessageBox(hWnd, text, caption, MB_ICONQUESTION | MB_YESNO) == IDYES)
			{
				LONG ErrorCode = DeleteConfig();
				if (ErrorCode == ERROR_SUCCESS)
				{
					RestartSpeech = TRUE;
					LoadString(hInst, IDS_INFOCAP, caption, MAX_PATH);
					LoadString(hInst, IDS_INFOCONF, text, MAX_PATH);
					MessageBox(hWnd, text, caption, MB_ICONINFORMATION);
				}
				else
				{
					LoadString(hInst, IDS_ERRCAP, caption, MAX_PATH);
					if (ErrorCode == ERROR_FILE_NOT_FOUND)
					{
						LoadString(hInst, IDS_ERRNOCONF, text, MAX_PATH);
					}
					else
					{
						LoadString(hInst, IDS_ERRCONF, text, MAX_PATH);
					}
					MessageBox(hWnd, text, caption, MB_ICONERROR);
				}
				RegisterHotKey(hWnd, HK_CONFIG, MOD_ALT, VK_F7);
				RegisterHotKey(hWnd, HK_ABOUT, MOD_ALT, VK_F8);
				RegisterHotKey(hWnd, HK_WND, MOD_ALT, VK_F11);
				RegisterHotKey(hWnd, HK_TIME, MOD_ALT, VK_F12);
				RegisterHotKey(hWnd, HK_READCLIP, MOD_CONTROL | MOD_ALT | MOD_SHIFT, 0x52);
				if (hBrush)
				{
					DeleteObject(hBrush);
					hBrush = NULL;
				}
				BackgroundColor = RGB(0xff, 0xff, 0xff);
				hBrush = CreateSolidBrush(BackgroundColor);
				if (hWndTime && hFont)
				{
					SendMessage(hWndTime, WM_SETFONT, 0, TRUE);
				}
				if (hFont)
				{
					DeleteObject(hFont);
					hFont = NULL;
				}
				TextColor = 0;
				hMenu = GetAppMenu(hWnd);
#ifdef UNDER_CE
				WindowStyle = WS_CAPTION | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_OVERLAPPED | WS_SYSMENU | WS_THICKFRAME;
#else
				WindowStyle = WS_OVERLAPPEDWINDOW;
#endif
				SetWindowLong(hWnd, GWL_STYLE, WindowStyle);
				SetWindowPos(hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_FRAMECHANGED | SWP_NOMOVE | SWP_NOSIZE);
				CheckMenuItem(hMenu, IDM_ONTOP, MF_UNCHECKED);
				CheckMenuItem(hMenu, IDM_TITLE, MF_CHECKED);
				if (hWndSB)
				{
					DestroyWindow(hWndSB);
					hWndSB = NULL;
				}
				ZeroMemory(text, sizeof(text));
				LoadString(hInst, IDS_DEFSTATUSTEXT, text, MAX_PATH);
				hWndSB = CreateStatusWindow(WS_CHILD | WS_VISIBLE, text, hWnd, STATUS_BAR_ID);
				CheckMenuItem(hMenu, IDM_STATUSBAR, MF_CHECKED);
				if (hWndTB)
				{
					DestroyWindow(hWndTB);
					hWndTB = NULL;
				}
				hWndTB = CreateToolBar(hWnd);
				CheckMenuItem(hMenu, IDM_TOOLBAR, MF_CHECKED);
				if (TimerID)
				{
					timeKillEvent(TimerID);
					TimerID = 0;
				}
				if (hWndTime)
				{
					DestroyWindow(hWndTime);
					hWndTime = NULL;
				}
				hWndTime = CreateTimeDisplay(hWnd);
				TimerID = timeSetEvent(1000, tc.wPeriodMin, (LPTIMECALLBACK)TimerProc, (DWORD)hWnd, TIME_PERIODIC);
				CheckMenuItem(hMenu, IDM_PAINTTIME, MF_CHECKED);
				CheckMenuItem(hMenu, IDM_SECONDS, MF_CHECKED);
#ifndef UNDER_CE
				hMenuApp = NULL;
				SetMenu(hWnd, hMenu);
				hMenu = GetSystemMenu(hWnd, FALSE);
				CheckMenuItem(hMenu, IDM_HIDEMENU, MF_UNCHECKED);
				CheckMenuItem(hMenu, IDM_SAVEPOS, MF_UNCHECKED);
				SetWindowPlacement(hWnd, &WPDefault);
#endif
				PostMessage(hWnd, WM_TIMER, 0, 0);
			}
			return 0;
		case IDM_SETPATH:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_INIDIALOG), hWnd, (DLGPROC)INIDialogProc);
			return 0;
		case IDM_SPEAKTIME:
			SpeakCurTime = TRUE;
			return 0;
		case IDM_MINIMIZE:
			RegisterTrayIcon(hWnd, TRUE);
			return 0;
		case IDM_RESTORE:
			RegisterTrayIcon(hWnd, FALSE);
			return 0;
		case IDM_PAINTTIME:
			hMenu = GetAppMenu(hWnd);
			GetMenuItemInfo(hMenu, IDM_PAINTTIME, FALSE, &MenuInfo);
			if ((MenuInfo.fState & MFS_CHECKED) && hWndTime)
			{
				CheckMenuItem(hMenu, IDM_PAINTTIME, MF_UNCHECKED);
				if (TimerID)
				{
					timeKillEvent(TimerID);
					TimerID = 0;
				}
				DestroyWindow(hWndTime);
				hWndTime = NULL;
				WritePrivateProfileStringWrapper(_T("Settings"), _T("PaintTime"), _T("0"), inifile);
			}
			else
			{
				CheckMenuItem(hMenu, IDM_PAINTTIME, MF_CHECKED);
				hWndTime = CreateTimeDisplay(hWnd);
				if (hWndTime && hFont)
				{
					SendMessage(hWndTime, WM_SETFONT, (WPARAM)hFont, TRUE);
				}
				TimerID = timeSetEvent(1000, tc.wPeriodMin, (LPTIMECALLBACK)TimerProc, (DWORD)hWnd, TIME_PERIODIC);
				PostMessage(hWnd, WM_TIMER, 0, 0);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("PaintTime"), _T("1"), inifile);
			}
			return 0;
		case IDM_SECONDS:
			hMenu = GetAppMenu(hWnd);
			GetMenuItemInfo(hMenu, IDM_SECONDS, FALSE, &MenuInfo);
			if (MenuInfo.fState & MFS_CHECKED)
			{
				CheckMenuItem(hMenu, IDM_SECONDS, MF_UNCHECKED);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("IncludeSeconds"), _T("0"), inifile);
			}
			else
			{
				CheckMenuItem(hMenu, IDM_SECONDS, MF_CHECKED);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("IncludeSeconds"), _T("1"), inifile);
			}
			PostMessage(hWnd, WM_TIMER, 0, 0);
			return 0;
		case IDM_RESTARTSPEECH:
			RestartSpeech = TRUE;
			return 0;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			if (!IsWindowVisible(hWnd))
			{
				RegisterTrayIcon(hWnd, FALSE);
			}
			return 0;
		case IDM_READCLIP:
			SpeakClipboard = TRUE;
			return 0;
		case IDM_EMPTYCLIP:
			LoadString(hInst, IDS_QUESTCAP, caption, MAX_PATH);
			LoadString(hInst, IDS_QUESTCLIP, text, MAX_PATH);
			if (MessageBox(hWnd, text, caption, MB_ICONQUESTION | MB_YESNO) == IDYES)
			{
				if (OpenClipboard(hWnd))
				{
					if (EmptyClipboard())
					{
						LoadString(hInst, IDS_INFOCAP, caption, MAX_PATH);
						LoadString(hInst, IDS_INFOCLIP, text, MAX_PATH);
						MessageBox(hWnd, text, caption, MB_ICONINFORMATION);
					}
					else
					{
						LoadString(hInst, IDS_ERRCAP, caption, MAX_PATH);
						LoadString(hInst, IDS_ERRCLIP, text, MAX_PATH);
						MessageBox(hWnd, text, caption, MB_ICONERROR);
					}
					CloseClipboard();
				}
				else
				{
					LoadString(hInst, IDS_ERRCAP, caption, MAX_PATH);
					LoadString(hInst, IDS_ERRCLIP2, text, MAX_PATH);
					MessageBox(hWnd, text, caption, MB_ICONERROR);
				}
			}
			return 0;
		case IDM_TOOLBAR:
			hMenu = GetAppMenu(hWnd);
			GetMenuItemInfo(hMenu, IDM_TOOLBAR, FALSE, &MenuInfo);
			if ((MenuInfo.fState & MFS_CHECKED) && hWndTB)
			{
				CheckMenuItem(hMenu, IDM_TOOLBAR, MF_UNCHECKED);
				DestroyWindow(hWndTB);
				hWndTB = NULL;
				WritePrivateProfileStringWrapper(_T("Settings"), _T("ToolBar"), _T("0"), inifile);
			}
			else
			{
				CheckMenuItem(hMenu, IDM_TOOLBAR, MF_CHECKED);
				hWndTB = CreateToolBar(hWnd);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("ToolBar"), _T("1"), inifile);
			}
			return 0;
		case IDM_STATUSBAR:
			hMenu = GetAppMenu(hWnd);
			GetMenuItemInfo(hMenu, IDM_STATUSBAR, FALSE, &MenuInfo);
			if ((MenuInfo.fState & MFS_CHECKED) && hWndSB)
			{
				CheckMenuItem(hMenu, IDM_STATUSBAR, MF_UNCHECKED);
				DestroyWindow(hWndSB);
				hWndSB = NULL;
				WritePrivateProfileStringWrapper(_T("Settings"), _T("StatusBar"), _T("0"), inifile);
			}
			else
			{
				CheckMenuItem(hMenu, IDM_STATUSBAR, MF_CHECKED);
				LoadString(hInst, IDS_DEFSTATUSTEXT, text, MAX_PATH);
				hWndSB = CreateStatusWindow(WS_CHILD | WS_VISIBLE, text, hWnd, STATUS_BAR_ID);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("StatusBar"), _T("1"), inifile);
			}
			return 0;
		case IDM_ONTOP:
			hMenu = GetAppMenu(hWnd);
			GetMenuItemInfo(hMenu, IDM_ONTOP, FALSE, &MenuInfo);
			if (MenuInfo.fState & MFS_CHECKED)
			{
				CheckMenuItem(hMenu, IDM_ONTOP, MF_UNCHECKED);
				SetWindowPos(hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("OnTop"), _T("0"), inifile);
			}
			else
			{
				CheckMenuItem(hMenu, IDM_ONTOP, MF_CHECKED);
				SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("OnTop"), _T("1"), inifile);
			}
			return 0;
		case IDM_TITLE:
			hMenu = GetAppMenu(hWnd);
			GetMenuItemInfo(hMenu, IDM_TITLE, FALSE, &MenuInfo);
			if (MenuInfo.fState & MFS_CHECKED)
			{
				CheckMenuItem(hMenu, IDM_TITLE, MF_UNCHECKED);
				WindowStyle = GetWindowLong(hWnd, GWL_STYLE);
				WindowStyle &= ~WS_CAPTION;
				SetWindowLong(hWnd, GWL_STYLE, WindowStyle);
				SetWindowPos(hWnd, NULL, 0, 0, 0, 0, SWP_FRAMECHANGED | SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("ShowTitle"), _T("0"), inifile);
			}
			else
			{
				CheckMenuItem(hMenu, IDM_TITLE, MF_CHECKED);
				WindowStyle = GetWindowLong(hWnd, GWL_STYLE);
				WindowStyle |= WS_CAPTION;
				SetWindowLong(hWnd, GWL_STYLE, WindowStyle);
				SetWindowPos(hWnd, NULL, 0, 0, 0, 0, SWP_FRAMECHANGED | SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("ShowTitle"), _T("1"), inifile);
			}
			return 0;
		case IDM_FONT:
			cf.lStructSize = sizeof(cf);
			cf.hwndOwner = hWnd;
			cf.hInstance = hInst;
			cf.lpLogFont = &lf;
			cf.Flags = CF_BOTH | CF_EFFECTS | CF_FORCEFONTEXIST | CF_INITTOLOGFONTSTRUCT;
			if (hFont)
			{
				GetObject(hFont, sizeof(lf), &lf);
			}
			else
			{
				GetObject(GetStockObject(SYSTEM_FONT), sizeof(lf), &lf);
			}
			cf.rgbColors = TextColor;
			if (ChooseFont(&cf))
			{
				TextColor = cf.rgbColors;
				ZeroMemory(text, sizeof(text));
				_stprintf(text, _T("%d"), TextColor);
				WritePrivateProfileStringWrapper(_T("Appearance"), _T("FontColor"), text, inifile);
				WritePrivateProfileStructWrapper(_T("Appearance"), _T("LogFont"), &lf, sizeof(lf), inifile);
				if (hWndTime && hFont)
				{
					SendMessage(hWndTime, WM_SETFONT, 0, TRUE);
				}
				if (hFont)
				{
					DeleteObject(hFont);
					hFont = NULL;
				}
				hFont = CreateFontIndirect(&lf);
				if (hWndTime && hFont)
				{
					SendMessage(hWndTime, WM_SETFONT, (WPARAM)hFont, TRUE);
				}
			}
			return 0;
		case IDM_COLOR:
			cc.lStructSize = sizeof(cc);
			cc.hwndOwner = hWnd;
#ifdef UNDER_CE
			cc.hInstance = hInst;
#else
			cc.hInstance = (HWND)hInst;
#endif
			cc.lpCustColors = cr;
			cc.Flags = CC_ANYCOLOR | CC_RGBINIT;
			cc.rgbResult = BackgroundColor;
			GetPrivateProfileStructWrapper(_T("Appearance"), _T("CustomColors"), cr, sizeof(cr), inifile);
			if (ChooseColor(&cc))
			{
				BackgroundColor = cc.rgbResult;
				ZeroMemory(text, sizeof(text));
				_stprintf(text, _T("%d"), BackgroundColor);
				WritePrivateProfileStringWrapper(_T("Appearance"), _T("BackgroundColor"), text, inifile);
				WritePrivateProfileStructWrapper(_T("Appearance"), _T("CustomColors"), cr, sizeof(cr), inifile);
				if (hBrush)
				{
					DeleteObject(hBrush);
					hBrush = NULL;
				}
				hBrush = CreateSolidBrush(BackgroundColor);
			}
			return 0;
		case IDM_ABOUT:
			LoadString(hInst, IDS_ABOUTCAP, caption, MAX_PATH);
			LoadString(hInst, IDS_ABOUTTXT, text, MAX_PATH);
			MessageBox(hWnd, text, caption, MB_ICONINFORMATION);
			return 0;
		}
		break;
	case WM_HOTKEY:
		switch (LOWORD(wParam))
		{
		case HK_CONFIG:
			if (DialogBox(hInst, MAKEINTRESOURCE(IDD_CONFIGDIALOG), NULL, (DLGPROC)ConfigDialogProc))
			{
				SetupSpeech = TRUE;
				if (GetPrivateProfileIntWrapper(_T("Settings"), _T("RegisterHotkeys"), 1, inifile))
				{
					RegisterHotKey(hWnd, HK_CONFIG, MOD_ALT, VK_F7);
					RegisterHotKey(hWnd, HK_ABOUT, MOD_ALT, VK_F8);
					RegisterHotKey(hWnd, HK_WND, MOD_ALT, VK_F11);
					RegisterHotKey(hWnd, HK_TIME, MOD_ALT, VK_F12);
					RegisterHotKey(hWnd, HK_READCLIP, MOD_CONTROL | MOD_ALT | MOD_SHIFT, 0x52);
				}
				else
				{
					UnregisterHotKey(hWnd, HK_CONFIG);
					UnregisterHotKey(hWnd, HK_ABOUT);
					UnregisterHotKey(hWnd, HK_WND);
					UnregisterHotKey(hWnd, HK_TIME);
					UnregisterHotKey(hWnd, HK_READCLIP);
				}
			}
			return 0;
		case HK_ABOUT:
			LoadString(hInst, IDS_ABOUTCAP, caption, MAX_PATH);
			LoadString(hInst, IDS_ABOUTTXT, text, MAX_PATH);
			MessageBox(NULL, text, caption, MB_ICONINFORMATION | MB_SETFOREGROUND);
			return 0;
		case HK_WND:
			if (IsWindowVisible(hWnd))
			{
				RegisterTrayIcon(hWnd, TRUE);
			}
			else
			{
				RegisterTrayIcon(hWnd, FALSE);
			}
			return 0;
		case HK_TIME:
			SpeakCurTime = TRUE;
			return 0;
		case HK_READCLIP:
			SpeakClipboard = TRUE;
			return 0;
		}
		break;
	case WM_APP:
		switch (lParam)
		{
		case WM_LBUTTONUP:
			RegisterTrayIcon(hWnd, FALSE);
			return 0;
		case WM_RBUTTONUP:
			hMenu = LoadMenu(hInst, MAKEINTRESOURCE(IDR_POPUP));
			if (hMenu)
			{
				hMenuSub = GetSubMenu(hMenu, 0);
				if (hMenuSub)
				{
					GetCursorPos(&pt);
					SetForegroundWindow(hWnd);
					TrackPopupMenu(hMenuSub, TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, 0, hWnd, NULL);
				}
				DestroyMenu(hMenu);
				hMenu = NULL;
			}
			return 0;
		}
		break;
	case WM_ERASEBKGND:
		hDC = (HDC)wParam;
		GetClientRect(hWnd, &rect);
		if (hBrush)
		{
			FillRect(hDC, &rect, hBrush);
		}
		else
		{
			FillRect(hDC, &rect, (HBRUSH)DefaultBackground);
		}
		return 1;
	case WM_CTLCOLORSTATIC:
		if ((HWND)lParam == hWndTime)
		{
			hDC = (HDC)wParam;
			SetBkMode(hDC, TRANSPARENT);
			SetTextColor(hDC, TextColor);
			if (hBrush)
			{
				return (LRESULT)hBrush;
			}
			else
			{
				return (LRESULT)DefaultBackground;
			}
		}
		return 0;
	case WM_TIMER:
		TimerProc(TimerID, 0, (DWORD)hWnd, 0, 0);
		return 0;
	case WM_INITMENUPOPUP:
		hMenu = GetAppMenu(hWnd);
#ifdef UNDER_CE
		if (IsClipboardFormatAvailable(CF_UNICODETEXT))
#else
		if (IsClipboardFormatAvailable(CF_TEXT))
#endif
		{
			EnableMenuItem(hMenu, IDM_READCLIP, MF_ENABLED);
			EnableMenuItem(hMenu, IDM_EMPTYCLIP, MF_ENABLED);
		}
		else
		{
			EnableMenuItem(hMenu, IDM_READCLIP, MF_GRAYED);
			EnableMenuItem(hMenu, IDM_EMPTYCLIP, MF_GRAYED);
		}
		return 0;
#ifndef UNDER_CE
	case WM_SYSCOMMAND:
		switch (LOWORD(wParam))
		{
		case IDM_HIDEMENU:
			hMenu = GetSystemMenu(hWnd, FALSE);
			GetMenuItemInfo(hMenu, IDM_HIDEMENU, FALSE, &MenuInfo);
			if ((MenuInfo.fState & MFS_CHECKED) && hMenuApp)
			{
				CheckMenuItem(hMenu, IDM_HIDEMENU, MF_UNCHECKED);
				SetMenu(hWnd, hMenuApp);
				hMenuApp = NULL;
				WritePrivateProfileStringWrapper(_T("Settings"), _T("HideMenu"), _T("0"), inifile);
			}
			else
			{
				CheckMenuItem(hMenu, IDM_HIDEMENU, MF_CHECKED);
				hMenuApp = GetMenu(hWnd);
				SetMenu(hWnd, NULL);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("HideMenu"), _T("1"), inifile);
			}
			return 0;
		case IDM_SAVEPOS:
			hMenu = GetSystemMenu(hWnd, FALSE);
			GetMenuItemInfo(hMenu, IDM_SAVEPOS, FALSE, &MenuInfo);
			if (MenuInfo.fState & MFS_CHECKED)
			{
				CheckMenuItem(hMenu, IDM_SAVEPOS, MF_UNCHECKED);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("SavePosition"), _T("0"), inifile);
			}
			else
			{
				CheckMenuItem(hMenu, IDM_SAVEPOS, MF_CHECKED);
				WritePrivateProfileStringWrapper(_T("Settings"), _T("SavePosition"), _T("1"), inifile);
			}
			return 0;
		}
		break;
	case WM_MENUSELECT:
		hMenu = GetAppMenu(hWnd);
		GetMenuItemInfo(hMenu, IDM_STATUSBAR, FALSE, &MenuInfo);
		if ((MenuInfo.fState & MFS_CHECKED) && hWndSB)
		{
			if (lParam)
			{
				LoadString(hInst, LOWORD(wParam), text, MAX_PATH);
			}
			else
			{
				LoadString(hInst, IDS_DEFSTATUSTEXT, text, MAX_PATH);
			}
			SetWindowText(hWndSB, text);
		}
		return 0;
	case WM_SIZE:
		EnumChildWindows(hWnd, (WNDENUMPROC)EnumChildProc, lParam);
		return 0;
#endif
	case WM_DESTROY:
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("RegisterHotkeys"), 1, inifile))
		{
			UnregisterHotKey(hWnd, HK_CONFIG);
			UnregisterHotKey(hWnd, HK_ABOUT);
			UnregisterHotKey(hWnd, HK_WND);
			UnregisterHotKey(hWnd, HK_TIME);
			UnregisterHotKey(hWnd, HK_READCLIP);
		}
		if (hBrush)
		{
			DeleteObject(hBrush);
			hBrush = NULL;
		}
		BackgroundColor = 0;
		if (hWndTime && hFont)
		{
			SendMessage(hWndTime, WM_SETFONT, 0, TRUE);
		}
		if (hFont)
		{
			DeleteObject(hFont);
			hFont = NULL;
		}
		TextColor = 0;
		hMenu = GetAppMenu(hWnd);
		GetMenuItemInfo(hMenu, IDM_STATUSBAR, FALSE, &MenuInfo);
		if ((MenuInfo.fState & MFS_CHECKED) && hWndSB)
		{
			CheckMenuItem(hMenu, IDM_STATUSBAR, MF_UNCHECKED);
			DestroyWindow(hWndSB);
			hWndSB = NULL;
		}
		GetMenuItemInfo(hMenu, IDM_TOOLBAR, FALSE, &MenuInfo);
		if ((MenuInfo.fState & MFS_CHECKED) && hWndTB)
		{
			CheckMenuItem(hMenu, IDM_TOOLBAR, MF_UNCHECKED);
			DestroyWindow(hWndTB);
			hWndTB = NULL;
		}
		GetMenuItemInfo(hMenu, IDM_PAINTTIME, FALSE, &MenuInfo);
		if ((MenuInfo.fState & MFS_CHECKED) && hWndTime)
		{
			CheckMenuItem(hMenu, IDM_PAINTTIME, MF_UNCHECKED);
			if (TimerID)
			{
				timeKillEvent(TimerID);
				TimerID = 0;
			}
			DestroyWindow(hWndTime);
			hWndTime = NULL;
		}
#ifdef UNDER_CE
		if (hWndCB)
		{
			CommandBar_Destroy(hWndCB);
			hWndCB = NULL;
		}
#else
		hMenuApp = NULL;
#endif
		timeGetDevCaps(&tc, sizeof(tc));
		timeEndPeriod(tc.wPeriodMin);
#ifndef UNDER_CE
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("SavePosition"), 0, inifile))
		{
			WINDOWPLACEMENT wp;
			ZeroMemory(&wp, sizeof(wp));
			wp.length = sizeof(wp);
			if (GetWindowPlacement(hWnd, &wp))
			{
				WritePrivateProfileStructWrapper(_T("Appearance"), _T("WindowPlacement"), &wp, sizeof(wp), inifile);
			}
		}
#endif
		PostQuitMessage(0);
		return 0;
	}
	return DefWindowProc(hWnd, message, wParam, lParam);
}

static void TTSCallback(LONG lParam1, LONG lParam2, DWORD user, UINT msg)
{
	_TCHAR caption[MAX_PATH];
	_TCHAR text[MAX_PATH];
	ZeroMemory(caption, sizeof(caption));
	ZeroMemory(text, sizeof(text));
	if (!IsWindowVisible((HWND)user))
	{
		user = 0;
	}
	LoadString(hInst, IDS_ERRCAP, caption, MAX_PATH);
	if (msg == ErrorMessage)
	{
		switch (lParam1)
		{
		case ERROR_IN_AUDIO_WRITE:
			LoadString(hInst, IDS_ERRAUD1, text, MAX_PATH);
			MessageBox((HWND)user, text, caption, MB_ICONERROR | MB_SETFOREGROUND);
			break;
		case ERROR_OPENING_WAVE_OUTPUT_DEVICE:
			LoadString(hInst, IDS_ERRAUD2, text, MAX_PATH);
			MessageBox((HWND)user, text, caption, MB_ICONERROR | MB_SETFOREGROUND);
			break;
		case ERROR_GETTING_DEVICE_CAPABILITIES:
			LoadString(hInst, IDS_ERRAUD3, text, MAX_PATH);
			MessageBox((HWND)user, text, caption, MB_ICONERROR | MB_SETFOREGROUND);
			break;
		}
	}
}

static DWORD WINAPI ClockThreadProc(void *data)
{
	LPTTS_HANDLE_T engine = NULL;
	MMRESULT EngineError = 0;
	UINT device = 0;
	DWORD flags = 0;
	WORD interval = 0;
	WORD SpokenHour = 0xffff;
	WORD SpokenMinute = 0xffff;
	BOOL SpeakStartup = FALSE;
	SYSTEMTIME curtime;
	TIME_ZONE_INFORMATION curzone;
	_TCHAR utc[MAX_PATH];
	_TCHAR deftimeintro[MAX_PATH];
	_TCHAR defdateintro[MAX_PATH];
	_TCHAR intro[MAX_PATH];
	_TCHAR picture12[MAX_PATH];
	_TCHAR picture24[MAX_PATH];
	_TCHAR format[MAX_PATH];
	_TCHAR laststatustext[MAX_PATH];
	_TCHAR defstatustext[MAX_PATH];
	_TCHAR speakstatustext[MAX_PATH];
	_TCHAR caption[MAX_PATH];
	_TCHAR text[MAX_PATH];
	char speaktext[MAX_PATH];
	ZeroMemory(&curtime, sizeof(curtime));
	ZeroMemory(&curzone, sizeof(curzone));
	ZeroMemory(utc, sizeof(utc));
	ZeroMemory(deftimeintro, sizeof(deftimeintro));
	ZeroMemory(defdateintro, sizeof(defdateintro));
	ZeroMemory(intro, sizeof(intro));
	ZeroMemory(picture12, sizeof(picture12));
	ZeroMemory(picture24, sizeof(picture24));
	ZeroMemory(format, sizeof(format));
	ZeroMemory(laststatustext, sizeof(laststatustext));
	ZeroMemory(defstatustext, sizeof(defstatustext));
	ZeroMemory(speakstatustext, sizeof(speakstatustext));
	ZeroMemory(caption, sizeof(caption));
	ZeroMemory(text, sizeof(text));
	ZeroMemory(speaktext, sizeof(speaktext));
	LoadString(hInst, IDS_UTC, utc, MAX_PATH);
	LoadString(hInst, IDS_DEFTIMEINTRO, deftimeintro, MAX_PATH);
	LoadString(hInst, IDS_DEFDATEINTRO, defdateintro, MAX_PATH);
	LoadString(hInst, IDS_PICTURE12, picture12, MAX_PATH);
	LoadString(hInst, IDS_PICTURE24, picture24, MAX_PATH);
	LoadString(hInst, IDS_DEFSTATUSTEXT, defstatustext, MAX_PATH);
	LoadString(hInst, IDS_SPEAKSTATUSTEXT, speakstatustext, MAX_PATH);
	LoadString(hInst, IDS_ERRCAP, caption, MAX_PATH);
	DT$OpenMem();
	device = GetPrivateProfileIntWrapper(_T("Settings"), _T("AudioDevice"), WAVE_MAPPER, inifile);
	flags = REPORT_OPEN_ERROR;
	if (GetPrivateProfileIntWrapper(_T("Settings"), _T("OwnDevice"), 0, inifile))
	{
		flags |= OWN_AUDIO_DEVICE;
	}
	EngineError = TextToSpeechStartupEx(&engine, device, flags, TTSCallback, (LONG)data);
	if (EngineError)
	{
		HWND hWnd = NULL;
		_TCHAR temp[MAX_PATH];
		ZeroMemory(temp, sizeof(temp));
		if (IsWindowVisible((HWND)data))
		{
			hWnd = (HWND)data;
		}
		LoadString(hInst, IDS_ERRDTINIT, temp, MAX_PATH);
		_stprintf(text, temp, EngineError);
		MessageBox(hWnd, text, caption, MB_ICONERROR);
		DT$CloseMem();
		PostMessage((HWND)data, WM_DESTROY, 0, 0);
		return 0;
	}
	ErrorMessage = RegisterWindowMessage(_T("DECtalkErrorMessage"));
	if (!ErrorMessage)
	{
		HWND hWnd = NULL;
		if (IsWindowVisible((HWND)data))
		{
			hWnd = (HWND)data;
		}
		LoadString(hInst, IDS_ERRDTMSG, text, MAX_PATH);
		MessageBox(hWnd, text, caption, MB_ICONERROR);
		TextToSpeechShutdown(engine);
		engine = NULL;
		DT$CloseMem();
		PostMessage((HWND)data, WM_DESTROY, 0, 0);
		return 0;
	}
	if (GetPrivateProfileIntWrapper(_T("Settings"), _T("StartupAnnounce"), 1, inifile))
	{
		SpeakStartup = TRUE;
	}
	SetupSpeech = TRUE;
	while (ClockRunning)
	{
		Sleep(5);
		if (RestartSpeech)
		{
			TextToSpeechReset(engine, TRUE);
			TextToSpeechUnloadUserDictionary(engine);
			TextToSpeechShutdown(engine);
			engine = NULL;
			device = GetPrivateProfileIntWrapper(_T("Settings"), _T("AudioDevice"), WAVE_MAPPER, inifile);
			flags = REPORT_OPEN_ERROR;
			if (GetPrivateProfileIntWrapper(_T("Settings"), _T("OwnDevice"), 0, inifile))
			{
				flags |= OWN_AUDIO_DEVICE;
			}
			EngineError = TextToSpeechStartupEx(&engine, device, flags, TTSCallback, (LONG)data);
			if (EngineError)
			{
				HWND hWnd = NULL;
				_TCHAR temp[MAX_PATH];
				ZeroMemory(temp, sizeof(temp));
				if (IsWindowVisible((HWND)data))
				{
					hWnd = (HWND)data;
				}
				LoadString(hInst, IDS_ERRDTINIT, temp, MAX_PATH);
				_stprintf(text, temp, EngineError);
				MessageBox(hWnd, text, caption, MB_ICONERROR);
				DT$CloseMem();
				PostMessage((HWND)data, WM_DESTROY, 0, 0);
				return 0;
			}
			ErrorMessage = RegisterWindowMessage(_T("DECtalkErrorMessage"));
			if (!ErrorMessage)
			{
				HWND hWnd = NULL;
				if (IsWindowVisible((HWND)data))
				{
					hWnd = (HWND)data;
				}
				LoadString(hInst, IDS_ERRDTMSG, text, MAX_PATH);
				MessageBox(hWnd, text, caption, MB_ICONERROR);
				TextToSpeechShutdown(engine);
				engine = NULL;
				DT$CloseMem();
				PostMessage((HWND)data, WM_DESTROY, 0, 0);
				return 0;
			}
			RestartSpeech = FALSE;
			SetupSpeech = TRUE;
		}
		if (SetupSpeech)
		{
			if (GetPrivateProfileIntWrapper(_T("Settings"), _T("ResetSpeech"), 0, inifile))
			{
				TextToSpeechReset(engine, TRUE);
			}
			TextToSpeechSetSpeaker(engine, GetPrivateProfileIntWrapper(_T("Settings"), _T("Speaker"), PAUL, inifile));
			TextToSpeechSetRate(engine, GetPrivateProfileIntWrapper(_T("Settings"), _T("Rate"), 180, inifile));
			ZeroMemory(text, sizeof(text));
			_stprintf(text, _T("[:volume set %d]"), GetPrivateProfileIntWrapper(_T("Settings"), _T("Volume"), 100, inifile));
#ifdef UNDER_CE
			TextToSpeechSpeak(engine, text, TTS_FORCE);
#else
			ZeroMemory(speaktext, sizeof(speaktext));
#ifdef UNICODE
			WideCharToMultiByte(CP_ACP, 0, text, -1, speaktext, MAX_PATH, NULL, NULL);
#else
			_tcscpy(speaktext, text);
#endif
			TextToSpeechSpeak(engine, speaktext, TTS_FORCE);
#endif
			ZeroMemory(text, sizeof(text));
			GetPrivateProfileStringWrapper(_T("Settings"), _T("UserDictionary"), NULL, text, MAX_PATH, inifile);
			TextToSpeechUnloadUserDictionary(engine);
			if (_tcslen(text))
			{
				ZeroMemory(speaktext, sizeof(speaktext));
#ifdef UNICODE
				WideCharToMultiByte(CP_ACP, 0, text, -1, speaktext, MAX_PATH, NULL, NULL);
#else
				_tcscpy(speaktext, text);
#endif
				TextToSpeechLoadUserDictionary(engine, speaktext);
			}
			SetupSpeech = FALSE;
		}
		if (SpeakClipboard)
		{
			if (OpenClipboard(NULL))
			{
				HGLOBAL hGlobal = NULL;
#ifdef UNDER_CE
				hGlobal = GetClipboardData(CF_UNICODETEXT);
#else
				hGlobal = GetClipboardData(CF_TEXT);
#endif
				if (hGlobal)
				{
					void *pText = NULL;
					if (GetPrivateProfileIntWrapper(_T("Settings"), _T("Interruptability"), 0, inifile))
					{
						TextToSpeechReset(engine, FALSE);
					}
					pText = GlobalLock(hGlobal);
#ifdef UNDER_CE
					TextToSpeechSpeak(engine, (LPTSTR)pText, TTS_FORCE);
#else
					TextToSpeechSpeak(engine, (LPSTR)pText, TTS_FORCE);
#endif
					GlobalUnlock(hGlobal);
					CloseClipboard();
					if (!GetPrivateProfileIntWrapper(_T("Settings"), _T("Interruptability"), 0, inifile))
					{
						if (hWndSB)
						{
							ZeroMemory(laststatustext, sizeof(laststatustext));
							GetWindowText(hWndSB, laststatustext, MAX_PATH);
							if (_tcscmp(laststatustext, defstatustext) == 0)
							{
								SetWindowText(hWndSB, speakstatustext);
							}
						}
						TextToSpeechSync(engine);
						if (hWndSB)
						{
							ZeroMemory(laststatustext, sizeof(laststatustext));
							GetWindowText(hWndSB, laststatustext, MAX_PATH);
							if (_tcscmp(laststatustext, speakstatustext) == 0)
							{
								SetWindowText(hWndSB, defstatustext);
							}
						}
					}
				}
				else
				{
					CloseClipboard();
				}
			}
			SpeakClipboard = FALSE;
		}
		interval = GetPrivateProfileIntWrapper(_T("Settings"), _T("CheckInterval"), 15, inifile);
		if (interval > 60)
		{
			interval = 60;
		}
		else if (interval < 1)
		{
			interval = 1;
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("UniversalTime"), 0, inifile))
		{
			GetSystemTime(&curtime);
		}
		else
		{
			GetLocalTime(&curtime);
		}
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("AlarmEnabled"), 0, inifile))
		{
			WORD AlarmHour = GetPrivateProfileIntWrapper(_T("Settings"), _T("AlarmHour"), 0, inifile);
			WORD AlarmMinute = GetPrivateProfileIntWrapper(_T("Settings"), _T("AlarmMinute"), 0, inifile);
			WORD AlarmSecond = GetPrivateProfileIntWrapper(_T("Settings"), _T("AlarmSecond"), 0, inifile);
			if (curtime.wHour == AlarmHour && curtime.wMinute == AlarmMinute && curtime.wSecond == AlarmSecond)
			{
				_TCHAR wavfile[MAX_PATH];
				ZeroMemory(wavfile, sizeof(wavfile));
				if (GetPrivateProfileIntWrapper(_T("Settings"), _T("Interruptability"), 0, inifile))
				{
					TextToSpeechReset(engine, FALSE);
				}
				GetPrivateProfileStringWrapper(_T("Settings"), _T("AlarmFile"), NULL, wavfile, MAX_PATH, inifile);
				if (_tcslen(wavfile))
				{
					ZeroMemory(text, sizeof(text));
					_stprintf(text, _T("[:play \"%s\"]"), wavfile);
#ifdef UNDER_CE
					TextToSpeechSpeak(engine, text, TTS_FORCE);
#else
					ZeroMemory(speaktext, sizeof(speaktext));
#ifdef UNICODE
					WideCharToMultiByte(CP_ACP, 0, text, -1, speaktext, MAX_PATH, NULL, NULL);
#else
					_tcscpy(speaktext, text);
#endif
					TextToSpeechSpeak(engine, speaktext, TTS_FORCE);
#endif
				}
				ZeroMemory(text, sizeof(text));
				GetPrivateProfileStringWrapper(_T("Settings"), _T("AlarmMessage"), NULL, text, MAX_PATH, inifile);
				if (_tcslen(text))
				{
#ifdef UNDER_CE
					TextToSpeechSpeak(engine, text, TTS_FORCE);
#else
					ZeroMemory(speaktext, sizeof(speaktext));
#ifdef UNICODE
					WideCharToMultiByte(CP_ACP, 0, text, -1, speaktext, MAX_PATH, NULL, NULL);
#else
					_tcscpy(speaktext, text);
#endif
					TextToSpeechSpeak(engine, speaktext, TTS_FORCE);
#endif
				}
				if (hWndSB)
				{
					ZeroMemory(laststatustext, sizeof(laststatustext));
					GetWindowText(hWndSB, laststatustext, MAX_PATH);
					if (_tcscmp(laststatustext, defstatustext) == 0)
					{
						SetWindowText(hWndSB, speakstatustext);
					}
				}
				TextToSpeechSync(engine);
				if (hWndSB)
				{
					ZeroMemory(laststatustext, sizeof(laststatustext));
					GetWindowText(hWndSB, laststatustext, MAX_PATH);
					if (_tcscmp(laststatustext, speakstatustext) == 0)
					{
						SetWindowText(hWndSB, defstatustext);
					}
				}
			}
		}
		if (curtime.wHour != SpokenHour || curtime.wMinute != SpokenMinute || SpeakCurTime || SpeakStartup)
		{
			if (((curtime.wMinute % interval) == 0 && curtime.wSecond == 0) || SpeakCurTime || SpeakStartup)
			{
				if (!SpeakCurTime)
				{
					if (GetPrivateProfileIntWrapper(_T("Settings"), _T("QuietMode"), 0, inifile))
					{
						WORD AfterHour = GetPrivateProfileIntWrapper(_T("Settings"), _T("QuietAfterHour"), 0, inifile);
						WORD BeforeHour = GetPrivateProfileIntWrapper(_T("Settings"), _T("QuietBeforeHour"), 0, inifile);
						if (SpeakStartup)
						{
							SpeakStartup = FALSE;
						}
						if (AfterHour > BeforeHour)
						{
							if (curtime.wHour >= AfterHour || curtime.wHour < BeforeHour)
							{
								continue;
							}
						}
						else if (AfterHour < BeforeHour)
						{
							if (curtime.wHour >= AfterHour && curtime.wHour < BeforeHour)
							{
								continue;
							}
						}
						else if (AfterHour == BeforeHour)
						{
							continue;
						}
					}
					if (GetPrivateProfileIntWrapper(_T("Settings"), _T("BeepInterval"), 0, inifile))
					{
						if ((curtime.wMinute % interval) == 0)
						{
							MessageBeep(0xffffffff);
						}
					}
				}
				if (GetPrivateProfileIntWrapper(_T("Settings"), _T("Interruptability"), 0, inifile))
				{
					TextToSpeechReset(engine, FALSE);
				}
				ZeroMemory(text, sizeof(text));
				GetPrivateProfileStringWrapper(_T("Settings"), _T("Greeting"), NULL, text, MAX_PATH, inifile);
				if (_tcslen(text))
				{
#ifdef UNDER_CE
					TextToSpeechSpeak(engine, text, TTS_FORCE);
#else
					ZeroMemory(speaktext, sizeof(speaktext));
#ifdef UNICODE
					WideCharToMultiByte(CP_ACP, 0, text, -1, speaktext, MAX_PATH, NULL, NULL);
#else
					_tcscpy(speaktext, text);
#endif
					TextToSpeechSpeak(engine, speaktext, TTS_FORCE);
#endif
				}
				ZeroMemory(intro, sizeof(intro));
				GetPrivateProfileStringWrapper(_T("Settings"), _T("TimeIntro"), deftimeintro, intro, MAX_PATH, inifile);
				ZeroMemory(format, sizeof(format));
				if (GetPrivateProfileIntWrapper(_T("Settings"), _T("24Hour"), 0, inifile))
				{
					GetTimeFormat(LOCALE_SYSTEM_DEFAULT, TIME_NOSECONDS, &curtime, picture24, format, MAX_PATH);
				}
				else
				{
					if (GetPrivateProfileIntWrapper(_T("Settings"), _T("BypassMarker"), 0, inifile))
					{
						GetTimeFormat(LOCALE_SYSTEM_DEFAULT, TIME_NOSECONDS | TIME_NOTIMEMARKER, &curtime, picture12, format, MAX_PATH);
					}
					else
					{
						GetTimeFormat(LOCALE_SYSTEM_DEFAULT, TIME_NOSECONDS, &curtime, picture12, format, MAX_PATH);
					}
				}
				ZeroMemory(text, sizeof(text));
				if (GetPrivateProfileIntWrapper(_T("Settings"), _T("UniversalTime"), 0, inifile))
				{
					_stprintf(text, _T("%s %s %s"), intro, format, utc);
				}
				else
				{
					if (GetPrivateProfileIntWrapper(_T("Settings"), _T("IncludeZone"), 1, inifile))
					{
						switch (GetTimeZoneInformation(&curzone))
						{
						case TIME_ZONE_ID_UNKNOWN:
							_stprintf(text, _T("%s %s"), intro, format);
							break;
						case TIME_ZONE_ID_STANDARD:
							_stprintf(text, _T("%s %s %ls"), intro, format, curzone.StandardName);
							break;
						case TIME_ZONE_ID_DAYLIGHT:
							_stprintf(text, _T("%s %s %ls"), intro, format, curzone.DaylightName);
							break;
						}
					}
					else
					{
						_stprintf(text, _T("%s %s"), intro, format);
					}
				}
#ifdef UNDER_CE
				TextToSpeechSpeak(engine, text, TTS_NORMAL);
#else
				ZeroMemory(speaktext, sizeof(speaktext));
#ifdef UNICODE
				WideCharToMultiByte(CP_ACP, 0, text, -1, speaktext, MAX_PATH, NULL, NULL);
#else
				_tcscpy(speaktext, text);
#endif
				TextToSpeechSpeak(engine, speaktext, TTS_NORMAL);
#endif
				if (GetPrivateProfileIntWrapper(_T("Settings"), _T("EndComma"), 1, inifile))
				{
#ifdef UNDER_CE
					TextToSpeechSpeak(engine, L",", TTS_FORCE);
#else
					TextToSpeechSpeak(engine, ",", TTS_FORCE);
#endif
				}
				else
				{
#ifdef UNDER_CE
					TextToSpeechSpeak(engine, L".", TTS_FORCE);
#else
					TextToSpeechSpeak(engine, ".", TTS_FORCE);
#endif
				}
				if (hWndTime && !SpeakStartup)
				{
					PostMessage((HWND)data, WM_TIMER, 0, 0);
				}
				if (GetPrivateProfileIntWrapper(_T("Settings"), _T("AnnounceDate"), 0, inifile))
				{
					ZeroMemory(intro, sizeof(intro));
					GetPrivateProfileStringWrapper(_T("Settings"), _T("DateIntro"), defdateintro, intro, MAX_PATH, inifile);
					ZeroMemory(format, sizeof(format));
					if (GetPrivateProfileIntWrapper(_T("Settings"), _T("ShortDate"), 0, inifile))
					{
						GetDateFormat(LOCALE_SYSTEM_DEFAULT, DATE_SHORTDATE, &curtime, NULL, format, MAX_PATH);
					}
					else
					{
						GetDateFormat(LOCALE_SYSTEM_DEFAULT, DATE_LONGDATE, &curtime, NULL, format, MAX_PATH);
					}
					ZeroMemory(text, sizeof(text));
					_stprintf(text, _T("%s %s"), intro, format);
#ifdef UNDER_CE
					TextToSpeechSpeak(engine, text, TTS_FORCE);
#else
					ZeroMemory(speaktext, sizeof(speaktext));
#ifdef UNICODE
					WideCharToMultiByte(CP_ACP, 0, text, -1, speaktext, MAX_PATH, NULL, NULL);
#else
					_tcscpy(speaktext, text);
#endif
					TextToSpeechSpeak(engine, speaktext, TTS_FORCE);
#endif
				}
				ZeroMemory(text, sizeof(text));
				GetPrivateProfileStringWrapper(_T("Settings"), _T("Closing"), NULL, text, MAX_PATH, inifile);
				if (_tcslen(text))
				{
#ifdef UNDER_CE
					TextToSpeechSpeak(engine, text, TTS_FORCE);
#else
					ZeroMemory(speaktext, sizeof(speaktext));
#ifdef UNICODE
					WideCharToMultiByte(CP_ACP, 0, text, -1, speaktext, MAX_PATH, NULL, NULL);
#else
					_tcscpy(speaktext, text);
#endif
					TextToSpeechSpeak(engine, speaktext, TTS_FORCE);
#endif
				}
				if (!GetPrivateProfileIntWrapper(_T("Settings"), _T("Interruptability"), 0, inifile))
				{
					if (hWndSB)
					{
						ZeroMemory(laststatustext, sizeof(laststatustext));
						GetWindowText(hWndSB, laststatustext, MAX_PATH);
						if (_tcscmp(laststatustext, defstatustext) == 0)
						{
							SetWindowText(hWndSB, speakstatustext);
						}
					}
					TextToSpeechSync(engine);
					if (hWndSB)
					{
						ZeroMemory(laststatustext, sizeof(laststatustext));
						GetWindowText(hWndSB, laststatustext, MAX_PATH);
						if (_tcscmp(laststatustext, speakstatustext) == 0)
						{
							SetWindowText(hWndSB, defstatustext);
						}
					}
				}
				SpokenHour = curtime.wHour;
				SpokenMinute = curtime.wMinute;
				SpeakCurTime = FALSE;
				SpeakStartup = FALSE;
			}
		}
	}
	TextToSpeechReset(engine, TRUE);
	TextToSpeechUnloadUserDictionary(engine);
	TextToSpeechShutdown(engine);
	engine = NULL;
	DT$CloseMem();
	return 0;
}

#if defined (UNICODE) && !defined (UNDER_CE)
int WINAPI wWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR szCmdLine, int iCmdShow)
#else
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR szCmdLine, int iCmdShow)
#endif
{
	HANDLE hMutex = NULL;
	HKEY hKey = NULL;
	HWND hWnd = NULL;
	HACCEL hAccel = NULL;
	HANDLE hThread = NULL;
	LONG RegError = 0;
	DWORD WindowStyle = 0;
	DWORD ThreadID = 0;
	OSVERSIONINFO VersionInfo;
	WNDCLASS WindowClass;
	MSG message;
	_TCHAR ExecutiblePath[MAX_PATH];
	_TCHAR caption[MAX_PATH];
	_TCHAR text[MAX_PATH];
#ifndef UNDER_CE
	ZeroMemory(&WPDefault, sizeof(WPDefault));
#endif
	ZeroMemory(inifile, sizeof(inifile));
	ZeroMemory(&VersionInfo, sizeof(VersionInfo));
	ZeroMemory(&WindowClass, sizeof(WindowClass));
	ZeroMemory(&message, sizeof(message));
	ZeroMemory(ExecutiblePath, sizeof(ExecutiblePath));
	ZeroMemory(caption, sizeof(caption));
	ZeroMemory(text, sizeof(text));
	hInst = hInstance;
	VersionInfo.dwOSVersionInfoSize = sizeof(VersionInfo);
	GetVersionEx(&VersionInfo);
	if (VersionInfo.dwMajorVersion < 4)
	{
		LoadString(hInst, IDS_WARNCAP, caption, MAX_PATH);
		LoadString(hInst, IDS_WARNVERSION, text, MAX_PATH);
		if (MessageBox(NULL, text, caption, MB_ICONEXCLAMATION | MB_YESNO) == IDNO)
		{
			return 0;
		}
	}
	LoadString(hInst, IDS_ERRCAP, caption, MAX_PATH);
	hMutex = CreateMutex(NULL, FALSE, AppName);
	if (hMutex)
	{
		if (GetLastError() == ERROR_ALREADY_EXISTS)
		{
			hWnd = FindWindow(AppName, AppName);
			if (hWnd)
			{
				if (IsWindowVisible(hWnd))
				{
					ShowWindow(hWnd, SW_RESTORE);
					SetForegroundWindow(hWnd);
				}
				else
				{
					LoadString(hInst, IDS_INFOCAP, caption, MAX_PATH);
					LoadString(hInst, IDS_INFORUNNING, text, MAX_PATH);
					if (MessageBox(NULL, text, caption, MB_ICONINFORMATION | MB_YESNO) == IDYES)
					{
						RegisterTrayIcon(hWnd, FALSE);
					}
				}
			}
			return 0;
		}
	}
	else
	{
		LoadString(hInst, IDS_ERRMUTEX, text, MAX_PATH);
		MessageBox(NULL, text, caption, MB_ICONERROR);
		return 0;
	}
#ifndef UNDER_CE
	if (GetModuleFileName(NULL, ExecutiblePath, MAX_PATH))
	{
		if (PathRemoveFileSpec(ExecutiblePath))
		{
			if (!SetCurrentDirectory(ExecutiblePath))
			{
				LoadString(hInst, IDS_ERRSETDIR, text, MAX_PATH);
				MessageBox(NULL, text, caption, MB_ICONERROR);
				ReleaseMutex(hMutex);
				hMutex = NULL;
				return 0;
			}
		}
	}
	if (GetCurrentDirectory(MAX_PATH, inifile))
	{
		_tcscat(inifile, _T("\\NWSClock.ini"));
	}
	else
	{
		LoadString(hInst, IDS_ERRGETDIR, text, MAX_PATH);
		MessageBox(NULL, text, caption, MB_ICONERROR);
		ReleaseMutex(hMutex);
		hMutex = NULL;
		return 0;
	}
#endif
	if (_tcsstr(szCmdLine, _T("/i")))
	{
		DialogBox(hInst, MAKEINTRESOURCE(IDD_INIDIALOG), NULL, (DLGPROC)INIDialogProc);
	}
	RegError = RegOpenKeyEx(HKEY_CURRENT_USER, AppRegKeyName, 0, KEY_READ, &hKey);
	if (RegError == ERROR_SUCCESS)
	{
		_TCHAR temp[MAX_PATH];
		DWORD type = REG_SZ;
		DWORD len = sizeof(temp);
		ZeroMemory(temp, sizeof(temp));
		RegQueryValueEx(hKey, _T("ConfigFile"), NULL, &type, (LPBYTE)temp, &len);
		type = REG_DWORD;
		len = sizeof(DWORD);
		RegQueryValueEx(hKey, _T("UseRegistry"), NULL, &type, (LPBYTE)&UseReg, &len);
		RegCloseKey(hKey);
		hKey = NULL;
		if (_tcslen(temp))
		{
			ZeroMemory(inifile, sizeof(inifile));
			_tcscpy(inifile, temp);
		}
	}
	else
	{
		if (RegError != ERROR_FILE_NOT_FOUND)
		{
			LoadString(hInst, IDS_ERRREG, text, MAX_PATH);
			MessageBox(NULL, text, caption, MB_ICONERROR);
			ReleaseMutex(hMutex);
			hMutex = NULL;
			return 0;
		}
	}
	InitCommonControls();
	if (_tcsstr(szCmdLine, _T("/c")))
	{
		DialogBox(hInst, MAKEINTRESOURCE(IDD_CONFIGDIALOG), NULL, (DLGPROC)ConfigDialogProc);
	}
	WindowClass.style = CS_HREDRAW | CS_VREDRAW;
	WindowClass.lpfnWndProc = (WNDPROC)WindowProc;
	WindowClass.hInstance = hInst;
	WindowClass.hIcon = LoadIcon(hInst, MAKEINTRESOURCE(IDI_ICON));
	WindowClass.hCursor = LoadCursor(NULL, IDC_ARROW);
	WindowClass.hbrBackground = (HBRUSH)DefaultBackground;
#ifndef UNDER_CE
	WindowClass.lpszMenuName = MAKEINTRESOURCE(IDR_MENU);
#endif
	WindowClass.lpszClassName = AppName;
	if (!RegisterClass(&WindowClass))
	{
		LoadString(hInst, IDS_ERRCLASS, text, MAX_PATH);
		MessageBox(NULL, text, caption, MB_ICONERROR);
		ReleaseMutex(hMutex);
		hMutex = NULL;
		return 0;
	}
#ifdef UNDER_CE
	WindowStyle = WS_CAPTION | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_OVERLAPPED | WS_SYSMENU | WS_THICKFRAME;
#else
	WindowStyle = WS_OVERLAPPEDWINDOW;
#endif
	hWnd = CreateWindow(AppName, AppName, WindowStyle, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInst, NULL);
	if (!hWnd)
	{
		LoadString(hInst, IDS_ERRWND, text, MAX_PATH);
		MessageBox(NULL, text, caption, MB_ICONERROR);
		UnregisterClass(AppName, hInst);
		ReleaseMutex(hMutex);
		hMutex = NULL;
		return 0;
	}
	hAccel = LoadAccelerators(hInst, MAKEINTRESOURCE(IDR_ACCELERATOR));
	if (!hAccel)
	{
		LoadString(hInst, IDS_ERRACCEL, text, MAX_PATH);
		MessageBox(NULL, text, caption, MB_ICONERROR);
		DestroyWindow(hWnd);
		hWnd = NULL;
		UnregisterClass(AppName, hInst);
		ReleaseMutex(hMutex);
		hMutex = NULL;
		return 0;
	}
	hThread = CreateThread(NULL, 0, ClockThreadProc, hWnd, CREATE_SUSPENDED, &ThreadID);
	if (!hThread)
	{
		LoadString(hInst, IDS_ERRTHREAD, text, MAX_PATH);
		MessageBox(NULL, text, caption, MB_ICONERROR);
		DestroyAcceleratorTable(hAccel);
		hAccel = NULL;
		DestroyWindow(hWnd);
		hWnd = NULL;
		UnregisterClass(AppName, hInst);
		ReleaseMutex(hMutex);
		hMutex = NULL;
		return 0;
	}
	if (_tcsstr(szCmdLine, _T("/h")) || GetPrivateProfileIntWrapper(_T("Settings"), _T("StartHidden"), 0, inifile))
	{
		RegisterTrayIcon(hWnd, TRUE);
	}
	else
	{
		ShowWindow(hWnd, iCmdShow);
		UpdateWindow(hWnd);
#ifndef UNDER_CE
		if (GetPrivateProfileIntWrapper(_T("Settings"), _T("SavePosition"), 0, inifile))
		{
			WINDOWPLACEMENT wp;
			ZeroMemory(&wp, sizeof(wp));
			if (GetPrivateProfileStructWrapper(_T("Appearance"), _T("WindowPlacement"), &wp, sizeof(wp), inifile))
			{
				SetWindowPlacement(hWnd, &wp);
			}
		}
#endif
	}
	ClockRunning = TRUE;
	ResumeThread(hThread);
	while (GetMessage(&message, NULL, 0, 0))
	{
		if (!TranslateAccelerator(hWnd, hAccel, &message))
		{
			TranslateMessage(&message);
			DispatchMessage(&message);
		}
	}
	ClockRunning = FALSE;
	WaitForSingleObject(hThread, 60000);
	CloseHandle(hThread);
	hThread = NULL;
	DestroyAcceleratorTable(hAccel);
	hAccel = NULL;
	DestroyWindow(hWnd);
	hWnd = NULL;
	UnregisterClass(AppName, hInst);
	ReleaseMutex(hMutex);
	hMutex = NULL;
	return message.wParam;
}
