/* Rexx program to install the DECTalk PC drivers to the specified address
   and path
   1.  Modify the CONFIG.SYS appropriately:

       a.  Edit CONFIG.SYS to add line:
           DEVICE=C:\DECPC\DTPCDRV.SYS 240 C:\DECPC
           Remove string ",LAUNCHPAD" from SET AUTOSTART= line

       b.  Add string ";C:\DECTALK" to SET LIBPATH= line

   2.  XCOPY all of the files to the specified drive and path.

   3.  Terminate.

*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* get boot drive letter from environment */
BootDrive=left(value('COMSPEC',,'OS2ENVIRONMENT'),2)
bLIBPATH=0 /* LIBPATH line found */

parse source osname cmdname ourname
parse upper arg parm1 parm2

if parm1 = '?' then     /* give help information */
  signal help_info
if parm1 = '' then      /* If address blank, use default address */
  do
    decaddr='340'
    drivepath=BootDrive||'\DECTALK'
  end
else
  do
    if pos(":", parm1) > 0 then
      do
        decaddr='340'
        if length(parm1) < 4 then  /* user supplied drive only */
           drivepath=substr(parm1, 1, 1)||':\DECTALK'
        else
          do
           if length(parm1) = lastpos("\", parm1) then  /* if path ends in \ */
              drivepath=substr(parm1, 1, length(parm1)-1)
           else
              drivepath=parm1
          end
      end
    else
      do
        decaddr=parm1
        if parm2 = '' then
          drivepath=BootDrive||'\DECTALK'
        else
          do
            if length(parm2) < 4 then  /* user supplied drive only */
               drivepath=substr(parm2, 1, 1)||':\DECTALK'
            else
              do
                if length(parm2) = lastpos("\", parm2) then
                   drivepath=substr(parm2, 1, length(parm2)-1)
                else
                   drivepath=parm2
              end
          end
      end
  end

say ''
say 'Installing with the hardware address of 'decaddr
say 'Installing drivers to 'drivepath
say ''
say 'Making CONFIG.SYS changes:'

/* make temp file name and copy CONFIG.SYS to it */
BackupConfig=SysTempFileName(BootDrive || '\config.???')

/*ProdConfig=BootDrive || '\CONFIG.SYS'*/
ProdConfig=BootDrive || '\CONFIG.SYS'
Call Stream BackupConfig,'c','open write'
bLIBPATH=0 /* LIBPATH line found */
bDEVICE=0  /* DEVICE= line found */
do while lines(ProdConfig)
   xstr=linein(ProdConfig)
   if 0 < pos("LIBPATH=",translate(xstr)) then
      do
         xstr=translate(xstr)
         if 0 = pos(drivepath||';',xstr) then
            do
               bLIBPATH=1
               if substr(xstr, length(xstr), 1) = ';' then
                  xstr=xstr||drivepath||';'
               else
                  xstr=xstr||';'||drivepath||';'
            end
         say ' '
         if bLIBPATH then
           say '   ' drivepath 'added to the LIBPATH'
         else
           say '   ' drivepath 'was already in the LIBPATH'
      end
   if 0 < pos("DTPCDRV.SYS",translate(xstr)) then
      do
         bDEVICE=1   /* so won't add it again, will just modify it */
         If 0 = pos(drivepath, translate(xstr)) then
            do
               /* get old drivepath information from DEVICE statement */
               /* so it can be removed from the LIBPATH               */
               xstr=translate(xstr)
               pathpos=lastpos(":",xstr)-1
               pathlen=length(xstr)-pathpos+1
               olddpath=substr(xstr, pathpos, pathlen)
            end
         say '    Changed DEVICE= statement in CONFIG.SYS file'
         xstr='DEVICE='||drivepath||'\DTPCDRV.SYS' decaddr drivepath
      end
   Call Lineout BackupConfig,xstr
end

Call Stream BackupConfig,'c','close'
Call Stream ProdConfig,'c','close'
if bDEVICE=0 then
   do
      xstr='DEVICE='||drivepath||'\DTPCDRV.SYS' decaddr drivepath
      '@echo' xstr '>>' BackupConfig
      say ' '
      say '    Added DEVICE= statement to load device driver'
   end
else /* need to make sure old drivepath removed from LIBPATH */
   do
      /* synchronize both files if we edited CONFIG.SYS during copy */
      '@copy' BackupConfig ProdConfig '> NUL'
      '@erase' BackupConfig
      Call Stream BackupConfig,'c','open write'
      do while lines(ProdConfig)
         xstr=linein(ProdConfig)
         if 0 < pos("LIBPATH=",translate(xstr)) then
            do
               xstr=translate(xstr)
               if 0 < pos(olddpath,xstr) then
                  do
                     loff=pos(olddpath,xstr)-1
                     roff=loff+length(olddpath)+2
                     xstr=substr(xstr,1,loff)||substr(xstr,roff)
                     say '    Old installation path' olddpath 'was removed from the LIBPATH'
                  end
            end
         Call Lineout BackupConfig,xstr
      end
      Call Stream BackupConfig,'c','close'
      Call Stream ProdConfig,'c','close'
   end

/* synchronize both files if we edited CONFIG.SYS during copy */
'@copy' BackupConfig ProdConfig '> NUL'
'@erase' BackupConfig

say ' '
say 'Copying DECtalk PC device drivers to' drivepath
'@xcopy a:\dectalk\*.*' drivepath||'\*.*' '/s /e > NUL'
say ' '
say 'Installation is complete.'
say 'Remove the diskette, shut down and reboot your computer.'
exit

help_info:
  say 'INSTDEC installation utility for installing DECtalk PC drivers  '
  say '                                                                '
  say 'Usage: INSTDEC [decaddr] [drivepath]                            '
  say '                                                                '
  say ' decaddr is the hardware address used for your DECtalk PC card. '
  say '   The default address is 340. You can specify a different      '
  say '   address in the format xxx.                                   '
  say '                                                                '
  say ' drivepath is the location where you want the DECtalk support   '
  say '   files to be installed.  The default is 'BootDrive||'\DECTALK '
  say '   If you specify a drive and path it must be in the format     '
  say '   drive:\path.                                                 '
  exit

