H 	%TITLE "DECTALK-BANK_DEMO.BAS  --  BASIC APPLICATION GUIDELINE PROGRAM"  !  !			  BANK_DEMO.BAS  !  7  !	NOTE:  This program was written with VAX BASIC V3.0.   !E  !  The following file contains a "modifiable" demonstration program  F  !  to be included in the DECtalk Application Development Guide.  ThisF  !  demonstration program typifies most telephone application programsI  !  written for DECtalk.  It is written in VAX BASIC and uses Version 4.5 G  !  or later of the VMS/MicroVMS Run-Time Library Support provided for    !  DECtalk.  !C  !	Program description:  In the "MENU" subroutine there is a SELECT =  !		statement where the code determines which of 5 menu items :  !		are chosen.  The menu choices and menu message must be9  !		modified to reflect the menu items being implemented.   !		The menu choices are:   !  !			1) RETAIL BANKING!  !			2) MORTGAGE RATE INFORMATION   !			3) ATM LOCATIONS   !			4) CREDIT-CARD INFORMATION   !*  !		        ************ NOTE ************5  !		ERROR MESSAGES WILL NOT BE LOGGED TO THE OPERATOR 6  !		TERMINAL (AS DESCRIBED BELOW) FOR THE NOAC BANKING6  !		DEMO BECAUSE NO TERMINAL WILL BE AVAILABLE (I.E. A8  !		CONSOLE OR OTHER SPARE TERMINAL) TO RECEIVE OPERATOR4  !		MESSAGES.  THEREFORE, IGNORE THE TEXT BELOW THAT5  !		DESCRIBES HOW TO ENABLE THE OPERATOR TERMINAL TO  6  !		RECEIVE ERROR MESSAGES FOR THIS DEMO.  IF AN ERROR;  !		OCCURS, THE DEMO WILL BE TERMINATED AND THE APPROPRIATE 8  !		MESSAGE ENTERED IN THE TXAx.ERR file WHERE x IS THE 7  !		NUMBER OF THE TERMINAL LINE THE FAILED DEMO PROGRAM   !		IS CONNECTED TO.,  !		        *********** END NOTE ***********  !@  !		All error messages are logged only to the operator terminals>  !		that have specified that the "OPER11" type of message will>  !		be handled. These messages give the error message, and the;  !		terminal line connected to that process.  To have error C  !		messages logged to the console terminal, or any other terminal, :  !		at the DCL prompt ($), enter the REPLY/ENABLE command:  !  !			$ reply/enable=oper11  !A  !		To enter this command, you must have the OPER user privelege.   !    %INCLUDE "DTKDEF"  (  EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 			SS$_NORMAL,   & 			SS$_TIMEOUT  !8  !  EXTERNAL Run-time Library Routines (DECtalk support)  !  EXTERNAL LONG FUNCTION & 0 			DTK$ANSWER_PHONE,	! Wait for phone to ring !&2 			DTK$INITIALIZE, 	! Initialize DECtalk device !&3 			DTK$TERMINATE, 		! End initialized DECtalk use!&  			initialize_dectalk   !  !  Prompts and demo text   !5   COMMON (MESSAGE_TEXT) STRING  msg_access   = 100, &  				msg_invalid  = 40, & 				msg_bad_command   = 40, &  				msg_no_terminator  = 100, &  				msg_timeout  = 50, & 				customer_service = 160, &  				dispatch_desk = 160   N    msg_access   = "Please enter your access code followed by the pound-key." &* 		+ " You may enter any number as a test."6    msg_invalid  = "Invalid entry.  Please try again. "C    msg_timeout  = "No key pressed in the timeout period specified." <    msg_bad_command  = "Invalid command.  Please try again. "J    msg_no_terminator= "Please remember to terminate your entry with the "&% 		+ "pound-key.  Command accepted.  " M   customer_service = "In an actual application, DECtalk would now transfer "& I 	+ "your call to a customer service representative. This demonstration "& ) 	+ "just returns to the selection menu. " J   dispatch_desk = "In an actual application, DECtalk would now transfer "&9 	+ "your call to the dispatch-desk. This demonstration "& ) 	+ "just returns to the selection menu. "   P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &7 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND, & # 					T30SECOND, T5MINUTE, T15MINUTE   I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, & P         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode  1   COMMON (application_specific)	LONG		voice_id, &  						num_hold_keys, & 						num_input_keys, &  					BYTE	hold_key_buf(80) , & 						input_key_buf(80), &( 					STRING	dictionary_file_name = 80, & 						terminal_line  	MAX_ENTRY = 3
 	T1SECOND = 1 
 	T2SECOND = 2  	T20SECOND = 20  	T30SECOND = 30  	T5MINUTE = 300  	T15MINUTE = 900 	TIME_45_SEC = "0 00:00:45"  	TIME_90_SEC = "0 00:01:30"  	TIME_6_MIN  = "0 00:06:00"  	TIME_16_MIN = "0 00:16:00"  	voice = DTK$K_VOICE_MALE  	speaking_rate = 180 	comma_pause_duration = 0  	period_pause_duration = 0 	speech_on = DTK$K_SPEAK 	new_mode = DTK$M_SQUARE  	keypad_mode = DTK$K_KEYPAD_AUTO  N    msg_welcome$  = "Welcome to the Digital Telephone Banking Demonstration.  "    %page  ! main   -  DECLARE LONG	version, init_dtk, need_to_init   init_dtk = 0%  need_to_init = 0% 	!A 	! Get the name of the physical device that the DECtalk module is B 	! connected to and the name of the dictionary file (if specified)A 	! that contains DECtalk's user dictionary words. If the call to  - 	! DTK$INITIALIZE is unsuccessful, then exit.  	!9 	CALL get_cli_params(terminal_line, dictionary_file_name)    	call set_timer(Time_45_sec)9 	stat% = DTK$INITIALIZE(voice_id, terminal_line, version)  	call cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IF     WHILE_LOOP: 	WHILE 1% = 1%			! do always   	num_hold_keys = 0%  	num_input_keys = 0%  9 	 !  Check to see if the DECtalk needs to be initialized. < 	 !  (init_dtk = need_to_init = 0).  If so, reinitialize theC  	 !  application specific parameters.  Then, set a watchdog timer  B 	 !  for 16 minutes in the future in case the DECtalk module fails@ 	 !  and no response to the DTK$ANSWER_PHONE command is received> 	 !  from DECtalk.  ** NOTE:  MAKE SURE THE WATCHDOG TIMER IS : 	 !  ALWAYS SET TO A VALUE LARGER THAN THE TIMEOUT PERIOD C 	 !  SPECIFIED IN THE DTK$ANSWER_PHONE COMMAND.  THE WATCHDOG TIMER / 	 !  CAN BE LARGER THAN 16 MINUTES.  Next, wait B 	 !  for the phone connected to the DECtalk to ring.  If the phone? 	 !  does not ring in "timeout" seconds (or the watchdog timer  B 	 !  times out), normally, the status of the DECtalk unit would beA 	 !  checked.  This is not possible in the current version (V4.5) A 	 !  of the VMS Run-Time Library Support for DECtalk.  Therefore, H 	 !  instead of reinitializing DECtalk every time the unit power cycled,C 	 !  it is reinitialized every time no phone calls are received in  G 	 !  "timeout" seconds. Then, a greeting message is spoken to the user. 
          ! 	IF init_dtk = need_to_init @ 	THEN  stat% = initialize_dectalk		! Reinitialize DECtalk paramS# 		IF (STAT% AND STS$M_SUCCESS) = 0%  		THEN- 			!  Initialization failed.  It appears that 0 			!  the DECtalk module may be dead.  For now,  			!  I will exit.    			GO TO out			! End the program 		END IF9 	    init_dtk = NOT need_to_init			! Appl. init. complete  	END IF ; 	CALL set_timer(time_16_min)		! Set system (watchdog) timer  	!G 	! The greeting message DECtalk speaks upon answering the telephone can ; 	! be modified by changing the text in the character string A 	! "msg_welcome". The number of rings DECtalk waits to answer the F 	! telephone ("number_of_rings"), can be changed but it is recommended7 	! that the phone is always answered on the first ring.  	!K         stat% = DTK$ANSWER_PHONE(voice_id, number_of_rings, msg_welcome$, &  								T15MINUTE) 	CALL cancel_timer 	IF (stat% = SS$_NORMAL) 	THEN  		! ' 		!  The telephone has been answered.    		! A 		!  NOTE: DTK$ANSWER_PHONE automatically enables autostop keypad 6 		!	 mode, and wink detection on the telephone keypad. 		!  		CALL menu  		CALL end_call 9 	ELSE IF (stat% = SS$_TIMEOUT)			! Timeout period expired 
 	     THEN2 		init_dtk = need_to_init			! Have to reinitialize
 	     ELSE 		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	     END IF 	END IF      NEXT    out:A     !  some fatal error has occured... Terminate DECtalk and exit      !      CALL set_timer(Time_45_sec) C     stat% = DTK$TERMINATE(VOICE_ID)     ! End use of DECtalk device      CALL cancel_timer%%     IF (stat% AND STS$M_SUCCESS) = 0%      THEN 		CALL error_log(stat%) 
     END IF  O  END  N  !********************* END OF PROGRAM ***************************************  !C  ! Gets the parameters from the command line using LIB$GET_FOREIGN.dC  ! If a fatal error occurs, it is reported and the demo is stopped.tK  ! Otherwise, the parameters specified are returned in terminal_line_stringtP  ! for the device name, and dictionary_name for the name of the dictionary file.  !A  SUB  get_cli_params (STRING device_name, STRING dictionary_name)o  % 	EXTERNAL LONG CONSTANT STS$M_SUCCESSn' 	EXTERNAL LONG FUNCTION LIB$GET_FOREIGN    	DECLARE STRING get_param_bufn0 	DECLARE LONG device_length, diction_name_length  * 	stat% = LIB$GET_FOREIGN(get_param_buf,,,)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENe 		CALL error_log(stat%)	5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IFT+ 	device_length = POS(get_param_buf, " ", 1) ) 	diction_name_length = LEN(get_param_buf)*   	IF device_length = 0% 	THEN : 		device_name = SEG$(get_param_buf,1, diction_name_length) 	ELSEH9 		device_name = SEG$(get_param_buf, 1, device_length - 1)B9 		dictionary_name = SEG$(get_param_buf, device_length+1,&  						 diction_name_length)E 	END IFO	   END SUB     K  !*************************************************************************R?  !  Initializes the application specific parameters of DECtalk.LD  !  First, left square bracket ('[') and right square bracket (']') M  !  are enabled as phonemic delimiters. To specify other modes, the bit masksAM  !  for the modes to be set should be OR'd together with the DTK$M_SQUARE bit	M  !  mask and assigned to the varible "NEW_MODE".  Next, the default speaking cH  !  voice and speaking rate are selected for the application.  The commaE  !  pause and period pause are set to DECtalk defaults.  Other voices I  !  can selected for the default speaking voice by modifying the variablenB  !  "voice".  Likewise, a different speaking rate can be specifiedG  !  by changing the static variable "speaking_rate".  Finally, the user,F  !  dictionary is loaded (by invoking "load_dictionary").  Note, otherF  !  application specific parameters should also be initialized in this"  !  subroutine if the need arises.  !  #  FUNCTION LONG initialize_dectalk()   &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS(   EXTERNAL LONG FUNCTION	DTK$SET_MODE, & 				DTK$SET_VOICE, & 				load_dictionaryT  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minm  I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, & - 		 period_pause_duration, speech_on, new_mode -   COMMON (application_specific)	LONG	voice_id	   	CALL set_timer(Time_45_sec)+ 	stat% = DTK$SET_MODE(voice_id, new_mode, )6 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IFd 	!A 	!  Indicate the type of voice and the speaking rate for DECtalk.t 	CALL set_timer(Time_45_sec)7 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate &"1 				,comma_pause_duration, period_pause_duration)t 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%)n5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IFc 	!8 	! load user dictionary using "load_dictionary" function 	!% 	initialize_dectalk = load_dictionary  	EXIT FUNCTION
  END FUNCTIONt  K  !  -----------------------------------------------------------------------eO  !  Gets a series of touch tone keys entered on the telephone keypad terminatedNM  !  by a pound sign (#) or an asterisk (*).  Returns SUCCESS if the series of O  !  touch tone keys was received successfully.  Otherwise, FAILURE is returned.M  N  FUNCTION LONG get_key_string(STRING prompt,LONG timeout,LONG terminator_code)    %INCLUDE "DTKDEF"  +   EXTERNAL LONG FUNCTION	DTK$READ_KEYSTROKEg'   EXTERNAL LONG CONSTANT	SS$_TIMEOUT, &p 				SS$_NORMAL, &_
 				DTK$_WINKu  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &) 		     LONG	MAX_ENTRY, T1SECOND, T2SECONDl  1    COMMON (application_specific)	LONG	voice_id, &  						num_hold_keys, & 						num_input_keys, &  					BYTE	hold_key_buf(80), &0 						input_key_buf(80)M  C   DECLARE LONG  read_key_buf, hold_buf_ptr, ad_timeout, loc_timeout"   	loc_timeout = timeout   	IF num_hold_keys > 0% 	THENV 	!E 	!  There are Touch Tone keys in the typeahead buffer (hold_key_buf)._B 	!  The routine "read_advance_keys" is called here to read any newA 	!  keys pressed.  This is used mainly to read and process winks.eF 	!  The "keys" stored in the typeahead buffer are moved into the input? 	!  buffer "input_key_buf" up to any terminator character.  The_H 	!  terminator character is put in "terminator_value", and any remainingG 	!  characters left in the typeahead buffer are copied to the front of f 	!  the buffer.t 	! 		ad_timeout = 1%t 		GOSUB read_advance_keyso" 		hold_key_buf(num_hold_keys) = 0% 		hold_buf_ptr = 0%CA 		WHILE hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_NUMBER_SIGN AND &e8 		      hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_ASTERISK  % 			IF hold_key_buf(hold_buf_ptr) = 0%r 			THENa 				num_hold_keys = 0% 				GO TO read_key	 			END IFa% 				input_key_buf(num_input_keys) = &  					hold_key_buf(hold_buf_ptr)   ' 			num_input_keys = num_input_keys + 1% # 			hold_buf_ptr = hold_buf_ptr + 1%y 		NEXT. 		terminator_code = hold_key_buf(hold_buf_ptr)" 		hold_buf_ptr = hold_buf_ptr + 1% 		num_hold_keys = 0% 		!t9 		!  Recopy the remaining keys in the typeahead buffer toeA 		!  the beginning of the buffer.  If the terminating keycode was A 		!  a "#" or "*", skip over it and start recopying with the nextc
 		!  keycode.v 	 ' 		UNTIL hold_key_buf(hold_buf_ptr) = 0%H9 			hold_key_buf(num_hold_keys)=hold_key_buf(hold_buf_ptr)N% 			num_hold_keys = num_hold_keys + 1% % 			hold_buf_ptr  = hold_buf_ptr  + 1%H 		NEXT 		GO TO process_entryT 	END IFN 	IF LEN(prompt) > 1% 	THENtB 	!  this test assumes that no 1 character prompts will be sent to 9 	!  dectalk.  Prompts of 1 char will be passed over here.  	!% 		CALL speak_text(DTK$K_WAIT, prompt)C 	END IF 
  read_key: 	WHILE 1% = 1% 		!n? 		!  Read all keys entered on the touch tone keypad by the useriA 		!  and store them in the typeahead buffer "hold_key_buf". Firstt> 		!  a watchdog timer must be set before any keys can be read.	          d 		CALL set_timer(Time_45_sec)rC 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , loc_timeout)k 		CALL cancel_timer  		IF stat% = SS$_NORMALe 		THEN0 			IF (read_key_buf = DTK$K_TRM_NUMBER_SIGN OR &) 			    read_key_buf = DTK$K_TRM_ASTERISK)U 			THEN0 				!H+ 				!  Received key string terminator ("#")t2 				!  so reception of keystring is completed. Use1 				!  a short timeout to gather up any remainingp+ 				!  touch tone keys entered by the user._  " 				terminator_code = read_key_buf 				ad_timeout = 2%i 				GOSUB read_advance_keysc 				GO TO process_entryg 			ELSEe0 				input_key_buf(num_input_keys) = read_key_buf( 				num_input_keys = num_input_keys + 1% 				loc_timeout = 10% 	 			END IFe 		ELSE	IF stat% = SS$_TIMEOUTt 			THEN  				EXIT read_keyt 			ELSE	IF stat% = DTK$_WINK 				THEN 				!t. 				!  DECtalk detected a wink which sometimes0 				!  indicates that the user has hungup.  This0 				!  demonstration program assumes that a WINK, 				!  does indicate the a user has hungup. 2 				!  Therefore, return so DECtalk can hangup its3 				!  phone.  If for any reason it is noticed thatD3 				!  spontaneous winks are occurring and the user 0 				!  at the other end of the telephone did not0 				!  hangup, then DO NOT return. Just continue! 				!  receiving touch tone keys.o   				    CALL error_log(stat%)	 				    get_key_string = 0%a  				    EXIT FUNCTION 				ELSE 				    CALL error_log(stat%)L3 		                    CALL LIB$STOP(stat% BY VALUE) 
 				END IF	 			END IFE 		END IF 	NEXT 	         !aN         !  No keystring terminator ("#" or "*") entered so set the terminatingJ         !  keycode to DTK$K_TRM_TIMEOUT.  Otherwise, return all touch toneF 	!  keys entered. Finally, recopy any remaining touch tone keys in the= 	!  typeahead buffer (ttkeys) to the beginning of the buffer.*	          *$ 	terminator_code = DTK$K_TRM_TIMEOUT    PROCESS_ENTRY:*! 	hold_key_buf(num_hold_keys) = 0%o
 	CALL restarti 	get_key_string = 1% 	EXIT FUNCTION    READ_ADVANCE_KEYS:  	!G 	!  Read any keys from DECtalk into the typeahead buffer "hold_key_buf"e 	!
 	WHILE 1=1 		CALL set_timer(Time_45_sec)dB 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , ad_timeout) 		CALL cancel_timera 		IF stat% = SS$_NORMAL  		THEN- 			hold_key_buf(num_hold_keys) = read_key_bufo% 			num_hold_keys = num_hold_keys + 1%  		ELSE	IF stat% = SS$_TIMEOUTM# 			THEN				! no key pressed: returne
 				RETURN 			ELSE	IF stat% = DTK$_WINK 				THEN			! Hung up?  exit  					CALL error_log(stat%) 					get_key_string = 0%  					EXIT FUNCTIONh 				ELSE 					CALL error_log(stat%)7 		                        CALL LIB$STOP(stat% BY VALUE)T
 				END IF	 			END IFi 		END IF 	NEXT,  
  END FUNCTIONA    M  !***************************************************************************GL  ! Verifies the access code received from the customer.  This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realP  ! application, the code would be verified against access codes in the database.    FUNCTION LONG access_verify ()	   	access_verify = 1%  	EXIT FUNCTION  
  END FUNCTION   M  !***************************************************************************NH  ! Verifies the password received from the customer. This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realL  ! application, the password would be verified against their password in the  ! database.  !  FUNCTION LONG password_verify ()D   	password_verify = 1%* 	EXIT FUNCTION
  END FUNCTION*  M  !***************************************************************************cG  !  Prompts the user for a command and receives the command (touch tonesJ  !  key) from the user.  Note, the command will be accepted whether or notE  !  it is terminated with the pound key "#".  However, if the commandgG  !  is not followed by the pound key, the command will not be processedEO  !  until the timeout period has expired and a warning message has been spoken.fM  !  When commands are received, the routine "process_menu_entry" is performede!  !  to implement the menu choice.e  !  SUB menu()u    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT STS$M_SUCCESS*   EXTERNAL LONG FUNCTION	get_key_string, & 				banking, &
 				atm, & 				credit_card, & 				DTK$SET_VOICE,  5   COMMON (MESSAGE_TEXT) STRING  msg_access   = 100, &i 				msg_invalid  = 40, & 				msg_bad_command   = 40, &t 				msg_no_terminator  = 100, &  				msg_timeout  = 50, & 				customer_service = 160  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &4 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND  I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &  				 period_pause_duration  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &  					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80)  M   main_menu_msg$ = "Please enter a command.  For help, press 0 followed by "& 1 		+ "the pound-key. To exit, press the star-key."S  K   main_menu$	= "For retail banking information, press 1, followed by the "&LI 	+ "pound-key. For Mortgage-rate information, press 2, followed by the "&dH 	+ "pound-key.  For ['eyt`iy'ehm] locations, press 3, followed by the "&G 	+ "pound-key. For credit-card information, press 4, followed by the "&,B 	+ "pound-key. To repeat this message, press 0, followed by the "&: 	+ "pound-key. To exit this section, press the star-key. "  M   mortgage$  =    "Welcome to [hx'aemdaxn] National Bank's Mortgage-Line.  "& K                 + "All of the following rates are subject to change. The "& ? 		+ "application fee is $250. 30 year rates with 10% [']down "&-< 		+ "are 8.9% with 3 [aen ax] half [p`oynts], 9.2% with 3 "&A 		+ "[p`oynts], 9.5% with 2 [aen ax] half [p`oynts], 9.8% with "&!= 		+ "no [p`oynts]. 15 year rates with 10% [']down are 8.9% "&hB 		+ "with 2 [aen ax] half [p`oynts], 9.1% with 2 [p`oynts], and "&= 		+ " 9.5% with no [p`oynts]. Adjustable rates are at 8.5% "&I> 		+ "fixed for 3 years, with 2% a year and 6% lifetime caps "& 		+ "thereafter. "    4   DECLARE	LONG	terminator_value, illegal_entry_count  	null_char$ = X'00'C_ 	terminator_value = 0% 	illegal_entry_count = 0%S  $ 	WHILE (input_key_buf(0) <> 0% OR  &* 				terminator_value <> DTK$K_TRM_TIMEOUT) 	!> 	! Keep getting commands from the user until the exit key "*",A 	! is entered, a wink is detected, or the timeout period expires.oG 	! First, check if there are any keys in the typeahead buffer (done by bD 	! "get_key_string" with a 1 second timeout).  If so, process them. F 	! Otherwise, prompt the user for a command and wait for his response. 	!  GET_SHORT_READ: 	num_input_keys = 0% 	input_key_buf(0) = 0%F         stat% = get_key_string(null_char$, T1SECOND, terminator_value)  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENy
 		EXIT SUB 	END IFa) 	IF terminator_value = DTK$K_TRM_ASTERISKu 	THENn
 		EXIT SUB3 	ELSE	IF (terminator_value = DTK$K_TRM_NUMBER_SIGN)r 		THEN: 			GOSUB process_menu_entry	! Valid command so process it	) 			IF (input_key_buf(0) = DTK$K_TRM_ZERO)i 			THEN  				GO TO get_long_readr 			ELSE	 				GO TO get_short_read	 			END IFe7 		ELSE IF ((terminator_value <> DTK$K_TRM_TIMEOUT) OR	&r6 	        	 (terminator_value = DTK$K_TRM_TIMEOUT AND	& 				input_key_buf(0) = 0%))o 			!: 			!  No keys in typeahead buffer so prompt for a command. 			! 		     THEN0+ 				CALL speak_text(DTK$K_WAIT, main_menu$)T
 		     END IFE 	         END IF 	     END IF 	!A 	!  Any new keys received should be processed after the keys read B 	!  from the typeahead buffer.  Start storing touch tone keys intoF 	!  into the buffer following the keys read from the typeahead buffer. 	!  GET_LONG_READ:d 	num_input_keys = 0%G         stat% = get_key_string(null_char$, T20SECOND, terminator_value)g  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENa
 		EXIT SUB 	END IF,) 	IF terminator_value = DTK$K_TRM_ASTERISKn 	THEN	
 		EXIT SUB4 	ELSE	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) <> 0%)_ 		THEN) 			CALL speak_all_text(msg_no_terminator)_: 			GOSUB process_menu_entry	! Valid command so process it	  6 		ELSE 	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) = 0%) 			THEN $ 				CALL speak_all_text(msg_timeout) 				EXIT SUB 			ELSE1 				GOSUB  process_menu_entry 	 			END IFL 		END IF 	END IFA    NEXTt	 	EXIT SUB   PROCESS_MENU_ENTRY:  !?  !  Processes the touch tone key string received from the user.t  ! 	IF num_input_keys > 1%  	THENt 	!< 	!  Only single key commands are valid in this menu.  Inform< 	!  the user that an invalid command was entered and return. 	!& 		CALL speak_all_text(msg_bad_command)0 		illegal_entry_count = illegal_entry_count + 1% 	ELSEe 	    SELECT	input_key_buf(0)0 		CASE = 	DTK$K_TRM_ZERO			! Speak menu help msg* 			CALL speak_text(DTK$K_WAIT, main_menu$) 			illegal_entry_count = 0%H  ( 		CASE = 	DTK$K_TRM_ONE			! banking demo 			stat% = banking$ 			IF (stat% AND STS$M_SUCCESS) = 0% 			THENo 				EXIT SUB	 			END IFn 			illegal_entry_count = 0%n  . 		CASE = 	DTK$K_TRM_TWO			! mortgage rate info: 			stat% = DTK$SET_VOICE(voice_id, DTK$K_VOICE_DEEP_MALE,& 						speaking_rate, & 						comma_pause_duration,& 						period_pause_duration)  ) 			CALL speak_text(DTK$K_WAIT, mortgage$)y 			illegal_entry_count = 0%   + 		CASE = 	DTK$K_TRM_THREE			! atm locations	 			stat% = atm$ 			IF (stat% AND STS$M_SUCCESS) = 0% 			THENH 				EXIT SUB	 			END IFk 			illegal_entry_count = 0%m  - 		CASE = 	DTK$K_TRM_FOUR			! credit card infoh 			stat% = credit_card$ 			IF (stat% AND STS$M_SUCCESS) = 0% 			THENa 				EXIT SUB	 			END IF  			illegal_entry_count = 0%    		CASE ELSEg+ 			CALL speak_text(DTK$K_WAIT, msg_invalid)s1 			illegal_entry_count = illegal_entry_count + 1%i 	   END SELECT 	END IFa 	num_input_keys = 0% 	!B 	! If user enters 3 illegal/incorrect commands, speak help message 	! 	IF illegal_entry_count >= 3 	THEN ) 		CALL speak_text(DTK$K_WAIT, main_menu$)t 		illegal_entry_count = 0% 	END IF	 	RETURN	    END SUB  ?  ! -----------------  ATM locations -------------------------- E  !I  !  This section will give the ATM locations in the greater maynard area.nI  !  The demo asks for a zip code, then speaks a canned message containingeM  !  atm locations.   To tailor this section to a different region, the stringa%  !  "atm_locations$" can be modified.h  !  FUNCTION LONG atm()    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT STS$M_SUCCESS'   EXTERNAL LONG FUNCTION	get_key_string   P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &4 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND     DECLARE LONG term_code  J    zip_code$ = "Enter your zip code followed by the pound-key.  You may "&! 	+ "enter any number as a test. "	  M    atm_locations$ = "There are ['ey*t`iy'ehm] machines in your local area, "&*I 	+ "located at 25 [n'eysxn] [str`iyt], Maynard.  1 18 Great Road, Stow."& ' 	+ " 86 [p'awdrrm`ihl] Road, Maynard. "       input_key_buf(0) = 0%    num_input_keys = 0%  :    stat% = get_key_string(zip_code$, T20SECOND, term_code)  $    IF (stat% AND STS$M_SUCCESS) = 0%    THENF	 	atm = 0%G 	EXIT FUNCTION	    END IFs  .    CALL speak_text(DTK$K_WAIT, atm_locations$)    atm = 1%*
  END FUNCTION*  B  ! --------------------  credit card menu ------------------------  !=  !  This section contains the credit card information demo.  S  !  The menu choices are:h  !  !	1) BILLING INFORMATION!  !	2) AVAILABLE CREDIT LINEu  !	3) LOST CARD INFORMATIONp  !  FUNCTION LONG credit_card()    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT STS$M_SUCCESS'   EXTERNAL LONG FUNCTION	get_key_string*  5   COMMON (MESSAGE_TEXT) STRING  msg_access   = 100, &* 				msg_invalid  = 40, & 				msg_bad_command   = 40, &  				msg_no_terminator  = 100, &) 				msg_timeout  = 50, & 				customer_service = 160  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &4 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &g 					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80)  8    credit_menu$ =  "For billing-information, press 1. "&+ 		+ "For available credit-line, press 2. "& + 		+ "For lost card-information, press 3. "&X? 		+ "To exit, press the star-key.  Terminate your entry with "&&6 		+ "the pound-key. To repeat this message, press 0. "  H    billing$ = "Your minimum payment is $40.  Total balance is $1000.  "&? 	+ "Date of last payment is January 23, 1987.  Total payment "&s 	+ "made was $65. "	  H    cred_line$ = "You have $500 available on your credit-line of $1500. "  L    lost_card$ = "Please call immediately. 1, 800, 2 3 5,  6000, to report "& 	+ "your lost card. "f  N    account_no$ = "enter your account number followed by the pound-key.  You "&% 	+ "may enter any number as a test. "c  4   DECLARE	LONG	terminator_value, illegal_entry_count  	null_char$ = X'00'Cl 	illegal_entry_count = 0%t 	num_input_keys = 0% 	input_key_buf(0) = 0%  H         stat% = get_key_string(account_no$, T20SECOND, terminator_value)  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENo 		credit_card = 0% 		EXIT FUNCTION, 	END IF    	terminator_value = 0%$ 	WHILE (input_key_buf(0) <> 0% OR  &* 				terminator_value <> DTK$K_TRM_TIMEOUT) 	!> 	! Keep getting commands from the user until the exit key "*",A 	! is entered, a wink is detected, or the timeout period expires.nG 	! First, check if there are any keys in the typeahead buffer (done by .D 	! "get_key_string" with a 1 second timeout).  If so, process them. F 	! Otherwise, prompt the user for a command and wait for his response. 	!  GET_SHORT_READ: 	num_input_keys = 0% 	input_key_buf(0) = 0%F         stat% = get_key_string(null_char$, T1SECOND, terminator_value)  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		credit_card = 0% 		EXIT FUNCTIONn 	END IF ) 	IF terminator_value = DTK$K_TRM_ASTERISK. 	THENr 		credit_card = 1% 		EXIT FUNCTION 3 	ELSE	IF (terminator_value = DTK$K_TRM_NUMBER_SIGN)y 		THEN: 			GOSUB process_menu_entry	! Valid command so process it	) 			IF (input_key_buf(0) = DTK$K_TRM_ZERO)  			THEN6 				GO TO get_long_readt 			ELSE. 				GO TO get_short_read	 			END IFu7 		ELSE IF ((terminator_value <> DTK$K_TRM_TIMEOUT) OR	&o6 	        	 (terminator_value = DTK$K_TRM_TIMEOUT AND	& 				input_key_buf(0) = 0%))	 			!: 			!  No keys in typeahead buffer so prompt for a command. 			! 		     THENt- 				CALL speak_text(DTK$K_WAIT, credit_menu$)d
 		     END IF  	         END IF 	     END IF 	!A 	!  Any new keys received should be processed after the keys read"B 	!  from the typeahead buffer.  Start storing touch tone keys intoF 	!  into the buffer following the keys read from the typeahead buffer. 	!  GET_LONG_READ:n 	num_input_keys = 0%G         stat% = get_key_string(null_char$, T20SECOND, terminator_value),  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENC 		credit_card = 0% 		EXIT FUNCTIONI 	END IFe) 	IF terminator_value = DTK$K_TRM_ASTERISKn 	THENT 		credit_card = 1% 		EXIT FUNCTIONK4 	ELSE	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) <> 0%)s 		THEN) 			CALL speak_all_text(msg_no_terminator)	: 			GOSUB process_menu_entry	! Valid command so process it	  6 		ELSE 	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) = 0%) 			THENm$ 				CALL speak_all_text(msg_timeout) 				credit_card = 0% 				EXIT FUNCTION! 			ELSE  				GOSUB  process_menu_entryo	 			END IF. 		END IF 	END IF0    NEXTL    credit_card = 0%T    EXIT FUNCTION  PROCESS_MENU_ENTRY:  !?  !  Processes the touch tone key string received from the user.s  ! 	IF num_input_keys > 1%  	THENe 	!< 	!  Only single key commands are valid in this menu.  Inform< 	!  the user that an invalid command was entered and return. 	!& 		CALL speak_all_text(msg_bad_command)0 		illegal_entry_count = illegal_entry_count + 1% 	ELSEm 	    SELECT	input_key_buf(0)0 		CASE = 	DTK$K_TRM_ZERO			! Speak menu help msg, 			CALL speak_text(DTK$K_WAIT, credit_menu$) 			illegal_entry_count = 0%F 		CASE = 	DTK$K_TRM_ONEK( 			CALL speak_text(DTK$K_WAIT, billing$) 			illegal_entry_count = 0%_ 		CASE = 	DTK$K_TRM_TWOr* 			CALL speak_text(DTK$K_WAIT, cred_line$) 			illegal_entry_count = 0%	 		CASE = 	DTK$K_TRM_THREEK* 			CALL speak_text(DTK$K_WAIT, lost_card$) 			illegal_entry_count = 0%a 		CASE ELSEi+ 			CALL speak_text(DTK$K_WAIT, msg_invalid)o1 			illegal_entry_count = illegal_entry_count + 1%  	   END SELECT 	END IFE 	num_input_keys = 0% 	!B 	! If user enters 3 illegal/incorrect commands, speak help message 	! 	IF illegal_entry_count >= 3 	THENy+ 		CALL speak_text(DTK$K_WAIT, credit_menu$)  		illegal_entry_count = 0% 	END IFc 	RETURNs  
  END FUNCTIONr  M  !***************************************************************************nG  !  Load the user dictionary with the words and phonemic pronunciations_G  !  stored in the sequential file specified in the foreign command line I  !  invoking the program.  Each line of this file contains the word to be	G  !  defined in the user dictionary followed by a space, followed by theTI  !  phonemic pronunciation of the word.  The entry is parsed to find the 	N  !  start and finnish of the word and it's replacement.  The word and phonemicM  !  pronunciation are loaded into the user dictionary. If the load dictionarytN  !  command fails, the user is notified and processing is terminated.  ReturnsM  !  SUCCESS if the dictionary is loaded successfully or if no user dictionaryA<  !  file name is specified.  Otherwise, FAILURE is returned.     FUNCTION LONG load_dictionary()    %INCLUDE "DTKDEF"  ,   EXTERNAL LONG FUNCTION	DTK$LOAD_DICTIONARY&   EXTERNAL LONG CONSTANT	SS$_NORMAL, & 				DTK$_TOOLONG, DTK$_NOROOM	@   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &  					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80), &n$ 				STRING	dictionary_file_name = 80  / 	MAP (dictionary) STRING dictionary_entry = 256e( 	DECLARE STRING		diction_word,  phonetic% 	DECLARE LONG		word_count, phonem_end   
 	sp$ = X'20'C- 	tab$ = X'09'C  	null_char$ = X'00'C- 	ON ERROR GOTO ERROR_CHECKG 	IF LEFT$(dictionary_file_name,1) = null_char$	! No dictionary filename  	THEN 6 	  !  No dictionary was specified in the command line.# 	  !  Return to initialize_dectalk a 		load_dictionary = 1% 		exit functiont 	END IFa  A 	OPEN dictionary_file_name AS FILE #1,	ORGANIZATION SEQUENTIAL, & ! 						ACCESS READ, MAP DICTIONARYN 	!E 	! Since there is no timeout associated with the DTK$LOAD_DICTIONARY MC 	! command, it is possible for an application to hang waiting for aiF 	! response after issuing the DTK$LOAD_DICTIONARY command.  Therefore,G 	! arm a watchdog timer (6 minutes in this case) to time the loading ofnG 	! the entire user dictionary.  If all the entries are not loaded into sA 	! the user dictionary before the timer expires, then assume thata7 	! something is wrong with the DECtalk module and exit.R 	!: 	CALL set_timer(time_6_min)		! Set system (watchdog) timer        WHILE 1% = 1% 	GET #1M 	! c3 	!  Read in all of the words and substitutions fromt8 	!  the sequential file specified in the command string. 	!+ 	word_count = POS(dictionary_entry, sp$, 1)  	IF word_count = 0%s2 	THEN		word_count = POS(dictionary_entry, tab$, 1) 	END IFf2 	phonem_end = POS(dictionary_entry, null_char$, 1)  7 	diction_word =	SEG$(dictionary_entry, 1, word_count-1)e> 	phonetic =	SEG$(dictionary_entry, word_count+1, phonem_end-1)  > 	stat% = DTK$LOAD_DICTIONARY(voice_id, DICTION_WORD, phonetic)1 	IF (stat% = DTK$_TOOLONG OR stat% = DTK$_NOROOM)s 	THENi 	     !T9 	     !  These are not generally fatal errors.  However, %: 	     !  they will be treated as such.  In creating a demo9 	     !  program, if words cannot be loaded into the userD> 	     !  dictionary, the programmer should be notified so that@ 	     !  the appropriate action can be taken.  By treating these? 	     !  errors as fatal, the programmer will at least know the 7 	     !  point in the program where the error occurred.R 	     !T
 		CLOSE #1 		CALL error_log(stat%)) 		load_dictionary = 0%' 		EXIT FUNCTION			! Fatal error so exit / 	ELSE IF (stat% <> SS$_NORMAL) 	! Fatal failureM
 	     THEN- 			CALL cancel_timer		! Cancel watchdog timern 			CLOSE #1& 			CALL error_log(stat%)= 		        CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit, 	     END IF 	END IFe	      NEXT   	!N7 	!  Entire dictionary is loaded so cancel system timer.  	!  DONE:4 	CALL cancel_timer			! Cancel system(watchdog) timer$ 	CLOSE #1				! Close dictionary file 	load_dictionary = 1%n  EXIT FUNCTION  
  ERROR_CHECK:k( 	IF ERR = 11%		! IF End of File is found 	THENk
 		RESUME DONE  	ELSE_ 	   CALL error_log(VMSSTATUS)o 	   RESUME HERE	 HERE:a 	   load_dictionary = 0% 	   EXIT FUNCTIONl 	END IFi
  END FUNCTIONs  M  !***************************************************************************tH  !  DECtalk stopped speaking because it was in autostop keypad mode whenG  !  it received a Touch Tone Key from the user.  First, send DECtalk a eK  !  right square bracket "]" just in case speech was stopped while speakingiM  !  phonemic text. Then, restart speech (using DTK$SET_SPEECH_MODE) and reset 6  !  the speaking voice and rate (using DTK$SET_VOICE).  !  SUB restart()    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS/   EXTERNAL LONG FUNCTION	DTK$SET_SPEECH_MODE, &u 				DTK$SET_VOICE   M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_miniI   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, & # 		 period_pause_duration, speech_onn-   COMMON (application_specific)	LONG	voice_idA      rsbracket$    = "]"  6   DECLARE LONG old_mode				! Current mode before reset  ) 	CALL speak_text( DTK$K_WAIT, rsbracket$)) 	! 	!  Set speakig on 	! 	CALL set_timer(Time_45_sec); 	stat% = DTK$SET_SPEECH_MODE(voice_id, speech_on, old_mode)  	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENe 		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit. 	END IF_ 	!% 	!  Reset the voice and speaking rateo 	CALL set_timer(Time_45_sec)8 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate, &0 				comma_pause_duration, period_pause_duration) 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENT 		CALL error_log(stat%))5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitt 	END IF%    END SUB  M  !***************************************************************************rE  !  End the current user session.  Since the DTK$HANGUP_PHONE command_C  !  does not set a timeout, and it requests DECtalk to send a phonesG  !  status, a watchdog timer is set to insure that the application does_G  !  not hang (if DECtalk fails).  If a longer timeout period is needed,eH  !  adjust the value of the parameter moved into SET_TIMER_STRING beforeM  !  performing "set_timer".  After the watchdog timer is set, speak a goodbyetI  !  message to the caller and then hangup the phone.  The goodbye messagekB  !  spoken can be changed by modifying the text in "msg_goodbye".   !  SUB end_call ()  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &e 				SS$_TIMEOUT, & 				DTK$_ONHOOKe  -   EXTERNAL LONG FUNCTION 	DTK$HANGUP_PHONE, &! 				DTK$READ_KEYSTROKE  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_miny-   COMMON (application_specific)	LONG	voice_idr  G   msg_goodbye$  = "Thank you for calling the DECtalk-demonstration.  "&E@ 		+ "For more information, please call 1, 800, 8 3 2, 6 2 7 7. "  : 	CALL set_timer(time_6_min)		! Set system (watchdog) timer 	!$ 	!  Say goodbye and hangup the phone 	!1 	stat% = DTK$HANGUP_PHONE(voice_id, msg_goodbye$) * 	CALL cancel_timer			! Cancel system timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IF_ 	!B 	! Get rid of any winks that may have been generated by the caller? 	! hanging up in the middle of the goodbye message.  This worksm( 	! around clears the internal WINK flag. 	! 	timeout% = 1% 	WHILE 1% = 1%, 	    CALL set_timer(Time_45_sec)		        		: 	    stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%) 	    CALL cancel_timer4 	    IF (stat% = DTK$_ONHOOK OR stat% = SS$_TIMEOUT)	 	    THENs 		!.- 		!  Clear remaining winks that may have beenw2 		!  detected before DECtalk hungup the telephone. 		!_$ 	        CALL set_timer(Time_45_sec)> 	        stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%) 	        CALL cancel_timer# 		IF (stat% AND STS$M_SUCCESS) = 0%D
 	        THENi 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	        END IFl 	        EXIT SUBe+ 	    ELSE IF (stat% AND STS$M_SUCCESS) = 0%	 	         THEN 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	         END IF 	    END IF, 	NEXTa  END SUB  J  !  ----------------------------------------------------------------------J  !  Speak all text -- disable autostop keypad, speak text in prompt using :  !  "speak_text". If autostop was set, re-enable autostop.  !#  SUB speak_all_text (STRING prompt)e    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS,   EXTERNAL LONG FUNCTION	DTK$SET_KEYPAD_MODE  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min*I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &wP         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode-   COMMON (application_specific)	LONG	voice_idg     DECLARE LONG	keypad_on     keypad_on = DTK$K_KEYPAD_ON	 	!F 	!  If autostop keypad mode is enabled (keymode = DTK$K_KEYPAD_AUTO), 1 	!  then enable the keypad without autostop mode.i 	!C 	IF (keypad_mode = DTK$K_KEYPAD_AUTO)	! Keypad is in autostop mode	e 	THENT7 		CALL set_timer(Time_45_sec)	! Set the watchdog timer	h2 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_on)1 		CALL cancel_timer		! Cancel the watchdog timer	e# 		IF (stat% AND STS$M_SUCCESS) = 0%e 		THEN 			CALL error_log(stat%)= 		        CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exiti 		END IF 	END IFr  ( 	!  Send text to DECtalk to be spoken.  = 	!  Specify the mode as DTK$K_WAIT so that text is completelyA< 	!  spoken before the keypad is re-enabled in autostop mode.  $ 	CALL speak_text(DTK$K_WAIT, prompt)  ' 	!  If autostop keypad mode was enabled 9 	!  (keypad_mode = DTK$K_KEYPAD_AUTO), then re-enable it.l 	!D 	IF (keypad_mode = DTK$K_KEYPAD_AUTO) ! Keypad was in autostop mode	 	THENb4 		CALL set_timer(Time_45_sec)	! Set watchdog timer		4 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_mode)1 		CALL cancel_timer		! Cancel the watchdog timer	w# 		IF (stat% AND STS$M_SUCCESS) = 0%' 		THEN 			CALL error_log(stat%)= 		        CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit_ 		END IF 	END IF$  END SUB  M  !*************************************************************************** .  !  Sends the prompt (specified by prompt) to 1  !  the DECtalk to be spoken.  Returns SUCCESS ift>  !  everything is spoken o.k.  Otherwise, FAILURE is returned.  !  7  !  NOTE:  If DTK$SPEAK_TEXT is called with mode set toh8  !	   DTK$K_WAIT or DTK$K_STATUS, a phone status requestA  !	   is sent from DECtalk.  Since there is no timeout associatedl>  !	   with this request, a system timer should be set (to someG  !	   exteremely long value (16 minutes) to insure that the applicationo  !	   does not hang.  !8  SUB speak_text (LONG return_status_mode, STRING prompt)    %INCLUDE "DTKDEF"  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &i 				SS$_NORMAL'   EXTERNAL LONG FUNCTION	DTK$SPEAK_TEXT   M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min_  -   COMMON (application_specific)	LONG	voice_idT 	! 	!  Speak the text: 	CALL set_timer(time_16_min)	! Set system (watchdog) timer= 	stat% = DTK$SPEAK_TEXT(voice_id, prompt, return_status_mode)s) 	CALL cancel_timer		! Cancel system timerd 	IF (stat% <> SS$_NORMAL)h 	THEN  		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exite 	END IF   END SUB  I  ! ********************************************************************** /  !	Log error to the operator console  "OPER11".   !N  !  Take the error number, input to SYS$GETMSG to get the system message text.P  !  Format the message text with the specific terminal line for that applicationL  !  "process" (using SYS$FAO), and call SYS$SENOPR with the error structure.  !H  !  NOTE:  the DTK$ errors that occur will have the %DTK- facility name,B  !	  but not the error message text, just the error number.  It isG  !	  anticipated that these messages will be included in future VMS/RTL)  !	  releases.  !*  !		        ************ NOTE ************5  !		ERROR MESSAGES WILL NOT BE LOGGED TO THE OPERATOR!;  !		TERMINAL FOR THE NOAC BANKING DEMO BECAUSE NO TERMINAL  F  ! 	        WILL BE AVAILABLE (I.E. A CONSOLE OR OTHER SPARE TERMINAL):  !		TO RECEIVE OPERATOR MESSAGES.  THEREFORE, ALL THE CODE8  !		IN THIS SUBROUTINE THAT DEALS WITH LOGGING A MESSAGE:  !		TO AN OPERATOR TERMINAL HAS BEEN COMMENTED OUT.  IF AN6  !		ERROR OCCURS, THE DEMO WILL BE TERMINATED AND THE :  !		APPROPRIATE MESSAGE ENTERED IN THE TXAx.ERR FILE WHERE8  !		x IS THE NUMBER OF THE TERMINAL LINE THE FAILED DEMO  !		PROGRAM IS CONNECTED TO.,  !		        *********** END NOTE ***********  !  !  SUB error_log(LONG error_number)r  B  %INCLUDE "$OPCDEF" %FROM %LIBRARY "SYS$LIBRARY:BASIC$STARLET.TLB"  #   EXTERNAL LONG CONSTANT	SS$_NORMALS#   EXTERNAL LONG FUNCTION	SYS$FAO, &E 				SYS$SNDOPR, &T 				SYS$GETMSG  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &i 					num_input_keys, & 				BYTE	hold_key_buf(80) , &o 					input_key_buf(80), &p' 				STRING	dictionary_file_name = 80, &N 					terminal_line  B   MAP	(error_struct) LONG opc$type_target, LONG OPC$L_MS_RQSTID, & 			STRING error_text = 120+   MAP	(error_struct) STRING error_msg = 128e%   MAP   (temp)  STRING error_buf = 80   +   DECLARE STRING CONSTANT filler = "  ON  "_3   DECLARE STRING CONSTANT control_str = "!AD!AS!AD"m   DECLARE LONG buf_len  P     temp% = SYS$GETMSG(error_number by value, buf_len, error_buf, 15% by value,)  !A  ! Set message target to OPER11, and the message type to RQ_RQST.tD  ! For more information on sending messages to an operators terminal"  ! see the System Services manual.  !?  !   opc$type_target = (OPC$M_NM_OPER11 * 256%) OR OPC$_RQ_RQSTD7  !	temp% = SYS$FAO(control_str, buf_len, error_text,		&	+  !				buf_len by value, error_buf by ref,	&o0  !				filler, 5% by value, terminal_line by ref)3  !	WHILE MID$(error_text, buf_len + 1, 1) <> X"00"C*-  !		MID$(error_text, buf_len + 1, 1) = X"00"Ce  !		buf_len = buf_len + 1n  !	NEXTo-  !	stat% = SYS$SNDOPR(error_msg, 0% by value)o  !	IF (stat% <> SS$_NORMAL)   !	THENt!  !		CALL LIB$STOP(stat% BY VALUE)i
  !	END IF   END SUB  M  !***************************************************************************vJ  !  Sets the system (watchdog) timer to expire "sec" seconds in the futureI  !  by invoking the "SYS$SETIMR" system service.  SYS$BINTIM is passed a oL  !  character string in the format "D HH:MM:SS", where D is Days, H is HoursH  !  M is minutes etc.  The output of BINTIM is the quadword delta_time ,/  !  which gets passed as input to SYS$SETIMR.  	  !"  SUB set_timer(STRING time_string)  ( 	EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 				SS$_TIMEOUTT% 	EXTERNAL LONG FUNCTION	SYS$SETIMR, &e 				SYS$BINTIM: 	EXTERNAL LONG		LIB$SIGNAL 	! Indicate exception condition% 	MAP (quadword) LONG delta_time, FILL   , 	stat% = SYS$BINTIM(time_string, delta_time)# 	IF (stat% AND STS$M_SUCCESS)  = 0%e 	THENl 		CALL error_log(stat%)"5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit) 	END IF!  K 	stat%= SYS$SETIMR( ,delta_time, LIB$SIGNAL BY VALUE, SS$_TIMEOUT BY VALUE) # 	IF (stat% AND STS$M_SUCCESS)  = 0%! 	THEN  		CALL error_log(stat%)A5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IFL  END SUB  J  !  ----------------------------------------------------------------------$  !  Cancel the system watchdog timer  !  SUB cancel_timer()m  %  EXTERNAL LONG CONSTANT	STS$M_SUCCESSm?  EXTERNAL LONG FUNCTION	SYS$CANTIM		! Cancel SYS$SETIMR requestW  6 	stat% = SYS$CANTIM(SS$_TIMEOUT BY VALUE, 0% BY VALUE)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%)L5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IFU  END SUB