 /*  *  *			    c_dtdemo.c   *  E  *  The following file contains a "modifiable" demonstration program  F  *  to be included in the DECtalk Application Development Guide.  ThisF  *  demonstration program typifies most telephone application programsG  *  written for DECtalk.  It is written in VAX11-C and uses Version 4.5 G  *  or later of the VMS/MicroVMS Run-Time Library Support provided for    *  DECtalk.  *D  *  Description:  This program provides a framework to develop otherD  *                demonstration programs.  Currently, it provides anF  *                information services demonstration giving the BostonC  *                weather forecast, transportation information, ski B  *                conditions, and mortgage rate information.  The E  *                program provides dial-in access only.  When a user  H  *                calls in, DECtalk answers the phone and speaks a shortI  *                greeting message.  Then, the customer is asked to enter G  *                his access code and password.  The customer is given  D  *                three attempts to enter his access code and three F  *                attempts to enter his password.  Once access to the E  *                system has been gained, DECtalk prompts the user to K  *                enter a command.  The six valid commands are given below:   *;  *                   Key 1 for the Boston weather forecast. :  *                   Key 2 for transportation information.9  *                   Key 3 for mortgage rate information. :  *                   Key 4 for the current ski conditions.$  *                   Key 0 for help.#  *                   Key * to exit.   *  I  *                Note, the user's access code, password and all commands J  *                except exit must be terminated by the number sign key.  ;  * 		  When a valid command is entered, DECtalk speaks the  H  *                appropriate message to the user.  Once the exit key isI  *                entered, a wink is detected, or a user fails to enter a K  *                command in the specified time period, the user session is J  *                ended.  DECtalk speaks a goodbye message to the user andJ  *                hangs up the telephone.  Then, DECtalk is re-enabled for@  *                autoanswer and waits for a new telephone call.  *B  *		  All error messages are logged only to the operator terminals@  *		  that have specified that the "OPER11" type of message will?  *		  be handled.  To have error messages logged to the console =  *		  terminal, or any other terminal, at the DCL prompt ($), %  *		  enter the REPLY/ENABLE command:   *+  *                    $ reply/enable=oper11   *O  *                To enter this command, you must have the OPER user privelege.   *  *  *F  *  VMS VERSION 4.5 RUN-TIME LIBRARY RESTRICTIONS FOR DECtalk SUPPORT:  *  *E  *  Before the application program is run, the terminal line that the J  *  DECtalk is connected to should be allocated.  On some machines runningJ  *  VMS, if the terminal line is running at high speed (9600 baud) and theE  *  terminal line is not allocated, the program fails on the call to  K  *  DTK$INITIALIZE with a device timeout error.  Note, the program also may I  *  fail with a device timeout error the first time you run it after the  O  *  terminal line has been allocated.  It should run the second time.  If not,  I  *  lower the baud rate on both the terminal line and the DECtalk module.   *D  *  There is a problem with the DTKDEF module in STARLET.OLB.  When E  *  calling DTK$READ_KEYSTROKE, the return values for touch tone keys H  *  0-9 do not match the definitions in DTKDEF.  The current definitionsE  *  are currently found in "dtkdef.h".  Note, it is anticipated that  C  *  this will be fixed in the Version 4.6 release of VMS.  Consult  &  *  the release notes for Version 4.6.  *F  *  The current version of the RTL does not provide a command to checkF  *  the status of DECtalk.  With this command, an application program E  *  can determine whether or not the DECtalk module has power cycled  H  *  since the last time its status has been observed.  If it is detectedC  *  that the DECtalk module has power cycled, application specific  J  *  parameters (speaking voice, speaking rate, words loaded into the user I  *  loadable dictionary) can be reinitialized.  By periodically checking  D  *  the status of the DECtalk module, and reinitializing if the unitB  *  has power cycled, an application may not have to be terminatedH  *  to replace failed DECtalk modules.  An alternative solution (used inD  *  this demonstration program) re-initializes application specific K  *  parameters every time a phone call has not been received in 15 minutes. D  *  While these parameters may not need to be reinitialized every 15F  *  minutes, using this alternative, DECtalk modules can still be "hotK  *  swapped" without terminating the application.  However, the application H  *  will have to be terminated if the DECtalk module failed at some time3  *  other than when it is waiting for a phone call.   *J  *  Most of the DTK$ RTL functions that read and return a status conditionH  *  from the DECtalk do not have a timeout specified on their read from A  *  DECtalk.  These DTK$ RTL functions include DTK$ANSWER_PHONE,  N  *  DTK$DIAL_PHONE, DTK$HANGUP_PHONE, DTK$LOAD_DICTIONARY, DTK$READ_KEYSTROKE,A  *  DTK$READ_STRING, DTK$RETURN_LAST_INDEX, DTK$SET_KEYPAD_MODE,  @  *  DTK$SPEAK_FILE, DTK$SPEAK_PHONEMIC_TEXT, and DTK$SPEAK_TEXT.9  *  Without a timeout, it is possible for the application C  *  program to hang if the DECtalk module fails, the power cord is  I  *  disconnected or the RS232 cable is disconnected.  In this situation,  I  *  the operator would not be aware that the application program is hung. I  *  However, when a user tried to call the system, either the phone would E  *  ring indefinitely or the user would always get a busy signal.  To O  *  prevent the application program from hanging without notifying the operator M  *  of the problem, a system timer (using SYS$SETIMR) is set before ALL calls G  *  made to the DTK$ facility of the Run-Time Library.  This is done by N  *  calling the subroutine "set_timer()",  At present, the MAXIMUM value that N  *  a system timer can be set to is 86400 seconds or 24 hours.  If a response N  *  is received from the DECtalk within the time period specified, the system C  *  timer is canceled (using SYS$CANTIM) by calling the subroutine  N  *  "cancel_timer()".  Otherwise, if the timer expires, the following warning 2  *  message is written to the operator's terminal:  *  *			FATAL ERROR 556 on TXyy  *M  *  where 556 is the decimal value of the timeout error status returned from  I  *  the RTL routine and TXyy is the name of the physical device that the  M  *  DECtalk is connected to.  This warning message informs the operator that  K  *  there is something wrong with the connection between the DECtalk module M  *  and the physical device (failed DECtalk module, RS232 cable disconnected, I  *  power cord disconnected, etc) and that the error should be corrected. D  *  To correct any error that may occur in the communication betweenE  *  the DECtalk module and the physical device, terminate the current A  *  job, correct the error, and then restart the job.  Note, the  G  *  application program will hang until the problem has been corrected.   *G  *  The current version of DTK$READ_STRING does not work correctly.  If G  *  a series of touch tone keys is entered on the touch tone keypad and I  *  a terminating character (number sign key or asterisk) is not entered, G  *  the series of touch tone keys entered is returned after the timeout G  *  period specified along with a terminator code of DTK$K_TRM_TIMEOUT. F  *  On the next call to DTK$READ_STRING, when the series of touch toneI  *  keys is returned, it always includes the last touch tone key returned J  *  in the previous call to DTK$READ_STRING as the first touch tone key inC  *  the series of keys returned.  The subroutine "get_key_string()" G  *  in this demonstration program can be used to read a series of touch H  *  tone keys terminated by the number sign key or the asterisk key.  It?  *  is similar in functionality to the DTK$READ_STRING routine.l  *I  *  DTK$ANSWER_PHONE automatically enables autostop mode on the telephone G  *  keypad and wink detection.  If it is not desirable to have autostopnG  *  mode enabled for your application, it can be disabled by turning on =  *  the keypad without autostop (DTK$K_KEYPAD_ON), using the oI  *  DTK$SET_KEYPAD_MODE command.  Wink detection cannot be disabled usingeF  *  an RTL routine.  However, if it is observed that spontaneous winksH  *  are being detected that DO NOT indicate that the caller has hung up,C  *  the wink status returned from the DTK$ routines can be ignored.t  *  */  #include <stdio.h> #include <ctype.h> #include <descrip.h> #include <opcdef.h>  #include <signal.h>  #include <ssdef.h> #include <stsdef.h>r #include "dtkdef.h"s  $ #define LF		  0x0A		/* Linefeed			*/* #define CR		  0x0D		/* Carriage return		*/9 #define MAX_ENTRY	  3		/* Max number of tries to login	*/o7 #define MAXKEYS		  80		/* Max length of keypad input	*/ 8 #define BUFLEN		  80		/* Max len command string param	*/: #define MAXSIZE		  257		/* Max size of dictionary entry	*/9 #define ERRMAX		  120		/* Max size of error msg buffer	*/ 3 #define T1SECOND	  1		/* 1 second timeout period	*/a3 #define T2SECOND	  2		/* 2 second timeout period	*/t6 #define T20SECOND	  20		/* 20 second timeout period	*/6 #define T30SECOND	  30		/* 30 second timeout period	*/5 #define T5MINUTE	  300		/* 5 minute watchdog timer	*/ 7 #define T15MINUTE	  900		/* 15 minute watchdog timer	*/ < #define T429SECOND	  429		/* 429 second timer (ca. 7 min) */= #define T24HOUR		  86400         /* 24 hour timeout period	*/d8 #define NUMRINGS	  0		/* Number of rings before answer*/? #define DEF_COMMA_PAUSE   0		/* Use default comma pause time */e? #define DEF_PERIOD_PAUSE  0		/* Use default period pause time*/g8 #define NOT_INIT	  0		/* DECtalk & appl. not initial'd*/9 #define APPL_INIT	  1		/* Appl. parameters initialized */    /*7  *  Defines the structure for the message buffer to logsA  *  errors to the operator's terminal (using the $SNDOPR command)e  */h typedef struct msg_to_oper {!     unsigned int	opc$b_ms_type:8;a$     unsigned int	opc$b_ms_target:24;     long 		opc$l_ms_rqstid;n      char		opc$l_ms_text[ERRMAX]; } OPER_REQ;s   /*0  *  Define variables used to set various DECtalk1  *  features (modes) for the current application.l  */	B static int           nrings=0;		        /* # rings before answer*/? static long	     voice=DTK$K_VOICE_MALE;    /* Type of voice	*/n9 static long  	     rate=180;		        /* Speaking rate	*/ B static unsigned long cp=DEF_COMMA_PAUSE;	/* Default comma pause	*/D static unsigned long pp=DEF_PERIOD_PAUSE;	/* Default period pause	*/E static unsigned long speechon=DTK$K_SPEAK;	/* Start speaking	*/     	e@ static unsigned long mode=DTK$M_SQUARE;   	/* Enable "[" mode	*/I static unsigned long keymode=DTK$K_KEYPAD_AUTO; /* Default keypad mode	*/    /*+  *  Static (application specific) variables(  */			@ static int    init_dtk = NOT_INIT;	/* DECtalk not initialized	*/< static char   dict_file[BUFLEN];	/* Dictionary file name		*/; static char   device[BUFLEN]; 		/* DECtalk output device	*/o: static char   errbuf[ERRMAX];		/* Error message buffer		*/B static char   ttkeys[MAXSIZE];		/* Touch tone keys typeahead buf*/= static char   term_set[] = "#*";	/* Key string terminators	*/t:        int    bad_entry_count;		/* counter for bad entries) 					    3 bad entries, speak help msg */$ /*%  *  String descriptors for RTL calls.   */kG static struct dsc$descriptor_vs vdesc;	/* Variable string descriptor	*/tF static struct dsc$descriptor_s  s1desc; /* Static string descriptor	*/F static struct dsc$descriptor_s  s2desc; /* Static string descriptor	*/   /*  *  Prompts and demo texto  */.! static char rsbracket[]    = "]";e  K static char msg_welcome[]  = "Welcome to the DECtalk information services \  demonstration.  ";  M static char msg_access[]   = "Please enter your access code followed by the \d3 pound key.  You may enter any number as a test.  ";v  J static char msg_password[] = "Please enter your password followed by the \3 pound key.  You may enter any number as a test.  ";i  C static char msg_invalid[]  = "Invalid entry.  Please try again.  ";e  M static char msg_noaccess[] = "Access denied.  Please check your access code \n and password and try again.  ";   O static char msg_goodbye[]  = "Thank you for calling the DECtalk demonstration \e program.  Have a nice day.  ";  P static char msg_timeout[]  = "No key pressed in the timeout period specified. ";  E static char bad_command[]  = "Invalid command.  Please try again.  ";5  I static char no_terminator[]  = "Please remember to terminate your entry \ * with the pound key.  Command accepted.  ";  N static char menu_prompt[]  = "Please enter a command.  For help, press key 0 \< followed by the pound key.  To exit, press the star key.  ";  L static char msg_help[]     = "To hear the current Boston weather forecast, \I press key 1.  To hear transportation information, press key 2.  To hear \ N mortgage rate information, press key 3.  To hear the current ski conditions, \O press key 4.  To repeat this message, press key 0.  Terminate your entry with \*0 the pound key.  To exit, press the star key.  ";  L static char msg_weather[]  = "Welcome to the Boston Area Weather Service.  \L April 1st.  Today will be a day [\"]more like early May.  Current downtown \H Boston temperature is 58 degrees Fahrenheit, 14 Celsius.  It will be a \E [\"]beautiful sunny day, breezy and mild, with a high of 76 degrees \eN Fahrenheit.  Humidity will be 76 per cent.  Barometric pressure is currently \G 32.5.  Tomorrow will be cooler, with a high of fifty on the coast and \wM sixty inland.  Fair weather is expected to continue throughout the week.  " ;t 		J static char msg_MBTA[]     = "Welcome to the MBTA Information Line.  All \M MBTA lines are on time.  The B and M line from the North Shore is running a \yK limited service, with trains running from Ipswich and Rockport, at 8 A.M. \fM and 9 A.M. only.  There will be no red line service between Park Street and \"M Harvard, Monday from 9 P.M. to 1 [`ey*'ehm].  Substitute bus transportation \e will be provided.  ";r  J static char msg_mortgage[] = "Welcome to Hamden National Bank's Mortgage \O Line.  All of the following rates are subject to change.  The application fee \ I is $250.  30 year rate with 10 % [']down are 9.9 % with 3 [aen ax] half \hO points, 10.2 % with 3 points, 10.5 % with 2 [aen ax] half points, 10.8 % with \	L no points.  15 year rates with 10 % [']down are 9.9 % with 2 [aen ax] half \O points, 10.1 % with 2 points, and 10.5% with no points.  Adjustable rates are \hP at 8.5 % fixed for 3 years with 2 % a year and 6 % lifetime caps thereafter.  ";  G static char msg_ski[]      = "Welcome to the New England Ski Report.  \tO January 31st.  Skiing is excellent in Vermont because of yesterday's snowfall \3H of 10 inches.  All ski trails are open at Stowe, Sugar-bush, Mt. Snow, \G Stratton, Jay Peak, and Smuggler's Notch, with packed powder and full \cM snow-making in operation.  All cross country ski trails are also open, with \ N many groomed trails.  Skiing in Maine and [nuw] Hampshire is good, with cold \N temperatures allowing for constant snow-making.  Gun-stock has 15 [aatax] 25 \O trails open, Mt. Cranmore has 15 [aatax] 20 trails open, Attitash and Wildcat \eO have all trails open.  Sugar-loaf and Sunday River also have all trails open, \nN with packed powder and loose granular.  Expected snowfall in Maine and [nuw] \4 Hampshire should improve weekend ski conditions.  ";   /*8  *  External Run-time Library Routines (DECtalk support)  */TA extern int	DTK$ANSWER_PHONE();	/* Wait for phone to ring & ans */c5 extern int	DTK$HANGUP();		/* Hangup the telephone		*/s< extern int	DTK$INITIALIZE();	/* Initialize DECtalk device	*/D extern int	DTK$LOAD_DICTIONARY();	/* Load word in user dictionary	*/B extern int	DTK$READ_KEYSTROKE();	/* Reads a single keypad entry	*/@ extern int	DTK$READ_STRING();	/* Read series of keypad entries*/> extern int	DTK$SET_MODE();		/* Set mode settings for DECtalk*/D extern int	DTK$SET_SPEECH_MODE();	/* Stop or start DECtalk speech	*/= extern int	DTK$SET_VOICE();	/* Change DECtalk voice chars.	*/n? extern int	DTK$SPEAK_TEXT();	/* DECtalk speaks specified text*/e= extern int	DTK$TERMINATE();	/* End initialized DECtalk use	*/s   /*H  *  Run-time Library Routines (LIB$) and system service routines (SYS$).  */ < extern int	LIB$SIGNAL();		/* Indicate exception condition	*/B extern int      LIB$GET_FOREIGN();	/* Gets foreign command line	*/9 extern int	SYS$CANTIM();		/* Cancel SYS$SETIMR request	*/_; extern int	SYS$SETIMR();		/* Schedule AST at future time	*/T I main(argc, argv). int		argc;			/* Number of command line args	*/, char		*argv[];		/* Command line arguments	*/ {i;     unsigned long 	vid;		/* Voice I.D. of DECtalk device	*/ 9     unsigned long       stat;		/* Status of RTL calls		*/t=     long 	        timeout;	/* Waiting time for phone answer*/t<     long		watch_timeout;  /* Watchdog timer for phone ans	*/2     long 		version;	/* DECtalk I or DECtalk III	*/       /*F      *  Get the name of the physical device that the DECtalk module isG      *  connected to and the name of the dictionary file (if specified)iG      *  that is used to load DECtalk's user loadable dictionary.  AftercF      *  the device name has been retrieved, create a string descriptorI      *  with this device name and invoke the RTL routine that initializesrF      *  the communication channel between the DECtalk and the physicalJ      *  device.  If the call to DTK$INITIALIZE is unsuccessful, then exit.      */	D     get_param(device, dict_file);	/* Get device & dictionary file	*/$     make_sdesc(&s1desc, device);    <     set_timer(T30SECOND);		/* Set system (watchdog) timer	*/3     stat = DTK$INITIALIZE(&vid, &s1desc, &version);O1     cancel_timer();			/* Cancel system timer		*/	S"     if (!(stat & STS$M_SUCCESS)) {9 	sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);	6 	log_error(errbuf);		/* Log error to operator term.	*/) 	exit(stat);			/* Fatal error so exit		*/a     }t<     timeout = T15MINUTE;		/* Set answer timeout to 15 min	*/     stat = SS$_NORMAL;9     while (stat == SS$_NORMAL || stat == SS$_TIMEOUT) {		U
         /*3          *  Main loop of the demonstration program._I          *  First, check to see if the application specific parameters of	L          *  the DECtalk need to be initialized ((init_dtk & APPL_INIT) = 0).K          *  If so, reinitialize them by calling init_dectalk().  Next, set  P          *  a watchdog timer for the DTK$ANSWER_PHONE command.  Then, enable theI          *  DECtalk for autoanswer (by calling DTK$ANSWER_PHONE).  If thetI          *  phone does not ring in the timeout period specified, (or the gK          *  watchdog timer expires), reinitialize the application specific RL          *  parameters of DECtalk.  Normally, these parameters would not be K          *  reinitialized everytime a phone call has not been received, but K          *  ONLY when the DECtalk module had power cycled.  However, in the K          *  current version of the VMS Run-Time Library Support for DECtalk*L          *  (Version 4.5), it is not possible to check the status of DECtalkJ          *  (detect if it has power cycled).  If a phone call is received M          *  within the timeout period, the phone is answered, autostop keypadgJ          *  mode and wink detection are enabled, and a greeting message isK          *  spoken to the user.  Next, the user must be verified as a validpL          *  user of the system.  As soon as the user has successfully gainedK          *  access to the system, he can start entering main menu commands. L          *  The code in this loop is continuely executed until a fatal error-          *  occurs or the process is stopped.t          */e# 	if ((init_dtk & APPL_INIT) == 0) {aG             if (!init_dectalk(vid)) {	/* Reinitialize DECtalk params	*/t 		/*- 		 *  Initialization failed.  It appears thate, 		 *  the DECtalk module may be dead so exit 		 */*! 		break;			/* End the program		*/l 	    }> 	    init_dtk |= APPL_INIT;	/* Appl. initialization complete*/ 	}	t         /*  E          *  Set the watchdog timer and enable DECtalk for autoanswer.cN          *  The watchdog timer is set by calling the subroutine "set_timer()".O          *  The watchdog timer is always set to a value 30 seconds larger than _J          *  than the timeout parameter passed to the DTK$ANSWER_PHONE RTL P          *  routine ("timeout").  To change the amount of time DECtalk waits forI          *  a phone call, the value of the parameter "timeout" passed to sL          *  DTK$ANSWER_PHONE must be modified.  The greeting message DECtalkO          *  speaks upon answering the telephone can be modified by changing therM          *  text in the static character string "msg_welcome".  The number ofaJ          *  rings DECtalk waits to answer the telephone ("nrings"), can beK          *  changed but it is recommended that the phone is always answereda          *  on the first ring.          */i,         watch_timeout = timeout + T30SECOND;=  	set_timer(watch_timeout);	/* Set system (watchdog) timer	*/n)         make_sdesc(&s1desc, msg_welcome);oB         stat = DTK$ANSWER_PHONE(&vid, &nrings, &s1desc, &timeout);>         if (stat == SS$_NORMAL) {	/* Timeout period expired	*/ 	    /*a= 	     *  The telephone has been answered so cancel the systemo> 	     *  timer.  Then, verify that the caller is a valid user E              *  of the system.  If the caller fails to enter a valid .E              *  access code and password in three attempts, access toeE              *  the system is denied.  A warning message is spoken to H              *  the user and the current phone call is ended by invoking              *  "end_call()"., 	     *eF 	     *  NOTE: DTK$_ANSWER_PHONE automatically enables autostop keypadE 	     *	      mode, and wink detection on the telephone keypad.  ThisaE 	     *        may not be suitable for all applications.  See note iniG 	     *        the initial header comment for disabling autostop keypad I              *        mode and ignoring winks received on the phone line.a              */				c:             cancel_timer();		/* Cancel the system timer	*/A             if (!verify_user(vid)) {	/* Deny access and hangup	*/o. 		speak_text(vid, DTK$K_WAIT, msg_noaccess);		.                 end_call(vid, msg_goodbye);	  
             }A             else {			  		/*< 		 *  The user has successfully gained access to the system.H                  *  Start processing commands from the user.  Note, the K                  *  menu prompt spoken prior to receiving commands from the L                  *  user, can be modified by changing the text in the static2                  *  character string "menu_prompt" 		 */e          	menu(vid, menu_prompt);.                 end_call(vid, msg_goodbye);	  
     	    } 	}D         else if (stat == SS$_TIMEOUT) {	/* Timeout period expired	*/8 	    init_dtk &= ~APPL_INIT;	/* Have to reinitialize		*/ 	}         else {:             cancel_timer();		/* Cancel the system timer	*/= 	    sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device); : 	    log_error(errbuf);		/* Log error to operator term.	*/- 	    exit(stat);			/* Fatal error so exit		*/  	}     }d     /*D      *  Operator specified to end the current application process.        */E     set_timer(T30SECOND);uG     stat = DTK$TERMINATE(&vid);         /* End use of DECtalk device	*/      cancel_timer();l"     if (!(stat & STS$M_SUCCESS)) {@         sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);=         log_error(errbuf);		/* Log error to operator term.	*/s) 	exit(stat);			/* Fatal error so exit		*/      }o }d     /*=  *  Sends an error message to the operator (console) terminalp>  *  using the $SNDOPR system service.  Note, this routine only>  *  sends a message to an operator terminal that has specified?  *  the OPER11 type of message.  Other types of messages can ben<  *  specified by changing the value of "msg.opc$b_ms_target"  */d inte log_error(buf)( char	*buf;					/* Text to log to oper	*/ { 4     unsigned long	stat;			/* System service status*//     OPER_REQ		msg;			/* Msg to send to oper  */r     @     msg.opc$b_ms_type = OPC$_RQ_RQST;		/* Request to operator	*/E     msg.opc$b_ms_target =  OPC$M_NM_OPER11;	/* Oper11 type message	*/t?     sprintf(msg.opc$l_ms_text, "%s", buf);	/* Text to output	*/K"     make_opr_sdesc(&s1desc, &msg);#     stat = SYS$SNDOPR(&s1desc, 0);	A9     if (stat != SS$_NORMAL) {			/* Send to oper failed	*/t) 	exit(stat);				/* Fatal error so exit	*/_     }( }/   	s /*=  *  Gets the parameters from the foreign command string that EA  *  invoked the program.  If a fatal error occurs, it is reportedrE  *  and the demo is exitted.  Otherwise, the parameters specified aree&  *  returned in "p1name" and "p2name".  */u int	 get_param(p1name, p2name)v/ char			*p1name;	/* Param 1 from command line	*/i/ char			*p2name;	/* Param 2 from command line	*/t { 4     unsigned long	stat;		/* Status from RTL calls	*/7     short int		len;		/* Actual length of device name	*/h6     short int		outlen;		/* Length of command string	*/6     char   		cmd[MAXSIZE];	/* Foreign command line		*/     register char	*tp;  F     make_vdesc(&vdesc, cmd, MAXSIZE);  /* String desc for parameter	*/     /*,      *  Get contents of the foreign command %      *  line that activated the imageh      */n8     stat = LIB$GET_FOREIGN(&vdesc, NULL, &outlen, NULL);"     if (!(stat & STS$M_SUCCESS)) {@         sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);=         log_error(errbuf);		/* Log error to operator term.	*/ ) 	exit(stat);			/* Fatal error so exit		*/n     }      /*K      *  Get the command string from the variable string descriptor.  First,aG      *  get the length of the parameter from the first two bytes of the(K      *  string.  Then, recopy the parameter to the beginning of the buffer.       */m,     len = (short int)vdesc.dsc$a_pointer[0];4     len += (short int)(vdesc.dsc$a_pointer[1] << 8);     /*A      *  Extract the first parameter from the foreign command linea      */	J     for (tp = vdesc.dsc$a_pointer+2; tp < vdesc.dsc$a_pointer+(len+2); ) {,         if ((isspace(*tp)) || (*tp == NULL))1     	    break;			/* At end of first parameter	*/| 	else= 	    *p1name++ = *tp++;	     } 5     *p1name = NULL;			/* Terminate first parameter	*/      /*-      *  Skip over any intermediate whitespace       */s.     while (tp < vdesc.dsc$a_pointer+(len+2)) {         if (!isspace(*tp))             break;			s 	elsei
 	    tp++;     }l     /*B      *  Extract the second parameter from the foreign command line      */N.     while (tp < vdesc.dsc$a_pointer+(len+2)) {,         if ((isspace(*tp)) || (*tp == NULL)). 	    break;			/* At end of second parameter	*/         else 	    *p2name++ = *tp++;	     } 6     *p2name = NULL;			/* Terminate second parameter	*/ }p   /*?  *  Initializes the application specific parameters of DECtalk.sD  *  First, left square bracket ('[') and right square bracket (']') C  *  are enabled as phonemic delimiters.  All other modes are reset.pE  *  To specify other modes to be set, the bit masks for the modes to RE  *  be set should be OR'd together with the DTK$M_SQUARE bit mask andnG  *  assigned to the static varible "mode".  Next, the default speaking  H  *  voice and speaking rate are selected for the application.  The commaE  *  pause and period pause are set to DECtalk defaults.  Other voicesdG  *  can selected for the default speaking voice by modifying the staticnK  *  variable "voice".  Likewise, a different speaking rate can be specifiedoI  *  by changing the static variable "rate".  Finally, the user dictionaryeL  *  is loaded (by invoking "load_dict()").  Note, other application specificP  *  parameters should also be initialized in this subroutine if the need arises.  */  ints init_dectalk(vid) 3 unsigned long		vid;		/* DECtalk voice identifier	*/  { 4     unsigned long	stat;		/* Status from RTL calls	*/       /*?      *  Set square bracket mode on.  All other modes are reset.E      */u     set_timer(T30SECOND);*%     stat = DTK$SET_MODE(&vid, &mode);      cancel_timer(); "     if (!(stat & STS$M_SUCCESS)) {@         sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);=         log_error(errbuf);		/* Log error to operator term.	*/g) 	exit(stat);			/* Fatal error so exit		*/t     })     /*;      *  Select type of voice and speaking rate for DECtalk.s      */h     set_timer(T30SECOND);t8     stat = DTK$SET_VOICE(&vid, &voice, &rate, &cp, &pp);     cancel_timer();e"     if (!(stat & STS$M_SUCCESS)) {@         sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);=         log_error(errbuf);		/* Log error to operator term.	*/ ) 	exit(stat);			/* Fatal error so exit		*/      } ;     return(load_dict(vid));		/* Load the user dictionary	*/a }n     /*;  *  Verifies that the caller is a valid user of the system..G  *  The caller is given three attempts to enter a valid access code and G  *  three attempts to enter his password.  If the caller fails to enteroL  *  a valid access code or a valid password in the timeout period specified,4  *  FALSE is returned.  Otherwise, TRUE is returned.  *F  *  NOTE: In this demonstration, almost all access codes and passwords?  *	  are detected as valid.  The only ways an access code or a 1H  *        password are rejected are if the user fails to enter an accessI  *        code or a password in the time period specified, or if the usersH  *        terminates his access code or password with the star key ("*")J  *        rather than the pound key ("#").  All access codes and passwordsD  *        that are entered correctly (terminated with the pound key)J  *        are verified by calling a dummy access code verification routineE  *        "access_verify()" and a dummy password verification routine J  *        "password_verify()".  Both of these routines always return TRUE.  */e ints verify_user(vid)7 unsigned long		vid;		/* Voice I.D. of DECtalk device	*/e {d@     long 	        illegal_entry;	/* Number of illegal entries	*/6     long 		term_code;	/* Key string terminator code	*/@     char                acode[MAXKEYS]; /* Access code array		*/6     char	        pcode[MAXKEYS]; /* Passcode array		*/  3     illegal_entry = 0;			/* No bad attempts yet		*/s     do {
         /*I          *  Gets the user's access code entered on the touch tone keypad.dH          *  The entered access code is returned in the character buffer F          *  "acode".  Currently, the maximum size of the buffer is 80 G          *  characters.  If a larger or smaller buffer is required, thesJ          *  definition of MAXKEYS should be changed.  The user is promptedF          *  for his access code by the text specified in "msg_access".J          *  To have a different prompt spoken, the static character stringH          *  "msg_access" should be modified.  Currently, the applicationM          *  waits 30 seconds for a touch tone key to be entered.  If a longer L          *  or shorter timeout period is desired, the new timeout value (in D          *  seconds) should be passed to "get_key_string" instead ofK          *  "T30SECOND".  The final parameter, "term_code" will contain the H          *  character used to terminate the key string or a timeout upon:          *  return from the "get_key_string" routine.               */ P         if (get_key_string(vid,acode,MAXKEYS,msg_access,T30SECOND,&term_code)) {             /*J              *  Check if an invalid key string termination character ("*")M              *  was entered, if the key string was not entered in the timeoutpJ              *  period specified or if an invalid access code was entered.C 	     *  If any of these conditions occured, increment the count ofrM              *  invalid access code entry attempts.  If this count is greaterrP              *  than the maximum allowed (specified by MAX_ENTRY), return FALSE.L              *  Otherwise, notify the user and prompt him again.  If a validN              *  access code is entered, then prompt the user for his password.              */sN             if (term_code==DTK$K_TRM_ASTERISK || term_code==DTK$K_TRM_TIMEOUT ; 			                  || (access_verify(acode) == FALSE)) { t+ 	        if (++illegal_entry >= MAX_ENTRY) o0 		    return(FALSE);		/* 3 strikes you're out	*/ 		else {/ 		    speak_text(vid, DTK$K_WAIT, msg_invalid);O 		}N 	    }   	    else - 	        break;			/* Access code is valid		*/" 	} 	else/1 	    return(FALSE);		/* No key string received	*/m(     } while (illegal_entry < MAX_ENTRY);     /*0      *  Access code has been entered correctly. -      *  Now prompt the user for his password.       *//3     illegal_entry = 0;			/* No bad attempts yet		*/c     do {
         /*F          *  Gets the user's password entered on the touch tone keypad.E          *  The entered password is returned in the character buffer  F          *  "pcode".  Currently, the maximum size of the buffer is 80 G          *  characters.  If a larger or smaller buffer is required, thePJ          *  definition of MAXKEYS should be changed.  The user is promptedE          *  for his password by the text specified in "msg_password". J          *  To have a different prompt spoken, the static character stringJ          *  "msg_password" should be modified.  Currently, the applicationM          *  waits 30 seconds for a touch tone key to be entered.  If a longer L          *  or shorter timeout period is desired, the new timeout value (in D          *  seconds) should be passed to "get_key_string" instead ofK          *  "T30SECOND".  The final parameter, "term_code" will contain the F          *  character used to terminate the key string or timeout upon:          *  return from the "get_key_string" routine.               */ R         if (get_key_string(vid,pcode,MAXKEYS,msg_password,T30SECOND,&term_code)) {             /*J              *  Check if an invalid key string termination character ("*")M              *  was entered, if the key string was not entered in the timeoutNG              *  period specified or if an invalid password was entered.(C 	     *  If any of these conditions occured, increment the count ofrJ              *  invalid password entry attempts.  If this count is greaterP              *  than the maximum allowed (specified by MAX_ENTRY), return FALSE.L              *  Otherwise, notify the user and prompt him again.  If a valid6              *  password is entered, then return TRUE.              */gN             if (term_code==DTK$K_TRM_ASTERISK || term_code==DTK$K_TRM_TIMEOUT >            			        || (password_verify(pcode) == FALSE)) { + 	        if (++illegal_entry >= MAX_ENTRY) r0 		    return(FALSE);		/* 3 strikes you're out	*/ 		else {/ 		    speak_text(vid, DTK$K_WAIT, msg_invalid);  		}f 	    }   	    else * 	        break;			/* Password is valid		*/ 	} 	elsem1 	    return(FALSE);		/* No key string received	*/ (     } while (illegal_entry < MAX_ENTRY);     return(TRUE);* }    /* kD  *  Gets a string of touch tone keys entered on the telephone keypad8  *  terminated by the pound key "#" or the star key "*".L  *  Returns TRUE if the string of touch tone keys was received successfully.!  *  Otherwise, FALSE is returned.m  */i int ? get_key_string(vid, keybuf, buflen, prompt, timeout, term_code)f7 unsigned long	vid;			/* Voice identifier for DECtalk	*/n4 char	        *keybuf;		/* Buffer for keypad input	*/5 long    	buflen;			/* Maximum length of key buffer	*/s2 char		*prompt;		/* Prompt spoken prior to input	*/4 long    	timeout;		/* # of secs to wait for input	*/? long            *term_code;		/* Terminating code - key input */r {n8     unsigned long	stat;		/* Status code from RTL call	*/0     long		keycode;	/* Code for touch tone key	*/1     long		watch_time;	/* Watch dog timer value	*/o2     int			len;		/* Buffer len before terminator */4     char		*ttkp;		/* Touch tone key buffer pointer*/  7     stat = SS$_NORMAL;			/* Status is initially o.k.	*/eA     if (strlen(ttkeys) > 0) {		/* Keys in typeahead buffer ???	*/t 	/*e: 	 *  There are Touch Tone keys in the typeahead buffer so 2 	 *  check if there is a pound key "#" or an star E          *  key "*" (both are key string terminators).  If so, returnc< 	 *  the string of touch tone keys up to the "#" or "*" key. 	 */! 	len = strcspn(ttkeys, term_set);c+ 	if ((ttkeys[len] == DTK$K_TRM_ASTERISK) || 4             (ttkeys[len] == DTK$K_TRM_NUMBER_SIGN)) . 	    goto ret_string;		/* Found "#" or "*"		*/     } /     else {				/* No keys in typeahead buffer	*/*2 	if (prompt != NULL) 		/* Prompt for a command		*/0             speak_text(vid, DTK$K_WAIT, prompt);     }AD     ttkp = &ttkeys[strlen(ttkeys)];	/* Pt to next available space	*/!     while (stat != SS$_TIMEOUT) {  	/*a? 	 *  Read all keys entered on the touch tone keypad by the usert? 	 *  and store them in the typeahead buffer "ttkeys".  First a r< 	 *  watchdog timer must be set before any keys can be read.          */r)         watch_time = timeout + T30SECOND;eA         set_timer(watch_time);		/* Set system (watchdog) timer	*/e8 	stat = DTK$READ_KEYSTROKE(&vid, &keycode, 0, &timeout);         cancel_timer(); 8 	if (stat == SS$_NORMAL) {	/* Received touch tone key	*/, 	    if ((keycode == DTK$K_TRM_ASTERISK) || ( 	 	(keycode == DTK$K_TRM_NUMBER_SIGN)) { 		/*> 		 *  Received key string terminator ("#" or "*") so reception? 		 *  of keystring is completed.  Use a short timeout to gather ; 		 *  up any remaining touch tone keys entered by the user.  		 */s 		timeout = T2SECOND;  	    } 	    /*eC 	     *  If there is room in the typeahead buffer ("ttkeys"), storesB 	     *  the key.  Otherwise, indicate the buffer is full and stop 	     *  receiving keys. 	     */# 	    if (ttkp < &ttkeys[MAXSIZE-1])S 		*ttkp++ = keycode; 	    else {r& 	 	*term_code = DTK$K_TRM_BUFFER_FULL; 		break; 	    }	         }s%         else if (stat == SS$_TIMEOUT)l- 	    break;			/* No keys available so exit	*/  	else if (stat == DTK$_WINK) { 	    /* C 	     *  DECtalk detected a wink which sometimes indicates that therD 	     *  user has hungup.  This demonstration program assumes that aE 	     *  WINK does indicate the a user has hungup.  Therefore, return B 	     *  so DECtalk can hangup its phone.  If for any reason it isB 	     *  noticed that spontaneous winks are occurring and the userF 	     *  at the other end of the telephone did not hangup, then DO NOT9 	     *  return. Just continue receiving touch tone keys.  	     */O             sprintf(errbuf, "ERROR--DECtalk on %s detected a wink.\n", device);iA             log_error(errbuf);		/* Log error to operator term.	*/  	    return(FALSE);a 	}3         else {				/* FATAL error so exit program	*/_D             sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);A             log_error(errbuf);		/* Log error to operator term.	*/; 	    exit(stat); 	}     } /     *ttkp = NULL;			/* Terminate key string		*/ >     if (strlen(ttkeys) <= 0) {		/* No keys received so exit	*/! 	*term_code = DTK$K_TRM_TIMEOUT;   	return(TRUE);     }c     /*K      *  There are Touch Tone keys in the typeahead buffer so check if therem?      *  is a pound key "#" or an star key "*" (both are string a3      *  terminators).  If so, return the keystring.       */n%     len = strcspn(ttkeys, term_set); r ret_string: /     if ((ttkeys[len] == DTK$K_TRM_ASTERISK) || f1         (ttkeys[len] == DTK$K_TRM_NUMBER_SIGN)) {n
         /*B          *  Got a keystring terminator ("#" or "*").  Check if the> 	 *  keystring will fit in the buffer to be returned.  If not,= 	 *  return as many keys as possible (buflen - 1) and set the A 	 *  terminating keycode to DTK$K_TRM_TIMEOUT.  Otherwise, return D 	 *  the entire keystring up to the terminating keycode and set the : 	 *  terminating code to the keycode entered ("#" or "*").          */ E         if (len >= (buflen - 1)) {	/* Can't return whole keystring	*/u 	    len = buflen - 1;$ 	    *term_code = DTK$K_TRM_TIMEOUT; 	}+ 	else {				/* Can return whole keystring	*/dA 	    *term_code = ttkeys[len];	/* Return terminating character	*/  	}F         strncpy(keybuf, ttkeys, len);	/* Copy into string to return	*/8         keybuf[len] = NULL;		/* Terminate the string		*/ 	/*iB 	 *  Recopy the remaining keys in the typeahead buffer (ttkeys) toC 	 *  the beginning of the buffer.  If the terminating keycode was aiH 	 *  "#" or "*", skip over it and start recopying with the next keycode. 	 *//         if (*term_code != DTK$K_TRM_TIMEOUT) { m5 	    len = len + 1;		/* "#" or "*" so skip over it	*/ 	         } )         strcpy(&ttkeys[0], &ttkeys[len]);i     }.
     else {
         /*O          *  No keystring terminator ("#" or "*") entered so set the terminating M          *  keycode to DTK$K_TRM_TIMEOUT.  Check if the keystring will fit inEH 	 *  the buffer to be returned.  If not, return as many keys as possibleC 	 *  (buflen - 1).  Otherwise, return all touch tone keys entered. rC 	 *  Finally, recopy any remaining touch tone keys in the typeaheadn4 	 *  buffer (ttkeys) to the beginning of the buffer.          */o'         *term_code = DTK$K_TRM_TIMEOUT;(! 	if (strlen(ttkeys) < (buflen-1))*7 	    len = strlen(ttkeys);	/* Not larger than buffer	*/  	elsee 	    len = buflen - 1;		D         strncpy(keybuf, ttkeys, len);	/* String of keys to return	*/- 	keybuf[len] = NULL;		/* Terminate string		*/,)         strcpy(&ttkeys[0], &ttkeys[len]);m     }w)     restart(vid);			/* Restart speech		*/p     return(TRUE);* }a     /*8  *  Verifies the access code received from the customer.7  *  This routine always returns TRUE for the purpose of 8  *  this demonstration.  In a real application, the code>  *  would be verified against the access code in the database.  */a inte access_verify(acode)3 register char	*acode;			/* Access code to verify	*/h {e     return(TRUE);  }n     /*5  *  Verifies the password received from the customer. 7  *  This routine always returns TRUE for the purpose ofm8  *  this demonstration.  In a real application, the code;  *  would be verified against the password in the database.t  */* int  password_verify(pcode)1 register char	*pcode;			/* Password to verify		*/N {      return(TRUE);d }e     /*G  *  Prompts the user for a command and receives the command (touch tonenJ  *  key) from the user.  Note, the command will be accepted whether or notE  *  it is terminated with the pound key "#".  However, if the commandlG  *  is not followed by the pound key, the command will not be processednO  *  until the timeout period has expired and a warning message has been spoken.eO  *  Returns TRUE if the exit key is received or if no response is received fromTI  *  the user in the timeout period specified.  Returns FALSE if a wink isv  *  detected by the DECtalk.  */  int+ menu(vid, prompt)A6 unsigned long		vid;		/* Voice identifier of DECtalk	*/& char			*prompt;	/* Prompt to speak		*/ {_;     unsigned long	stat;		/* Get_key_string status return */e6     long 	        term;		/* Command terminator code	*/6     long 		timeout;	/* Time to wait for a keystroke	*/0     long		len;		/* Length of typeahead buffer	*/3     char		buf[MAXKEYS];	/* Touch tone key buffer	*/o       bad_entry_count = 0;     do { 	/*h@ 	 *  Keep getting commands from the user until the exit key "*",C 	 *  is entered, a wink is detected, or the timeout period expires.E@ 	 *  First, check if there are any keys in the typeahead buffer.C 	 *  If so, process them.  Otherwise, prompt the user for a commandf 	 *  and wait for his response.b 	 */3 	buf[0] = NULL;			/* No touch tone keys received	*/aH         stat = get_key_string(vid, buf, MAXKEYS, NULL, T1SECOND, &term);         if (stat == FALSE) /2 	    return(FALSE);		/* Detected wink so exit	*/  (         if (term == DTK$K_TRM_ASTERISK) / 	    return(TRUE);		/* Exit key so exit menu	*/ * 	else if (term == DTK$K_TRM_NUMBER_SIGN) {D 	    process_menu_entry(vid, buf);	/* Valid command so process it	*/ 	    continue; 	}( 	else if ((term != DTK$K_TRM_TIMEOUT) ||: 	         (term == DTK$K_TRM_TIMEOUT && buf[0] == NULL)) { 	    /*R= 	     *  No keys in typeahead buffer so prompt for a command.> 	     */) 	    speak_text(vid, DTK$K_WAIT, prompt);  	} 	/*eB 	 *  Any new keys received should be processed after the keys readC 	 *  from the typeahead buffer.  Start storing touch tone keys intogG 	 *  into the buffer following the keys read from the typeahead buffer.t 	 */7 	len = strlen(buf);		/* Get number of typeahead keys	*/iN         stat=get_key_string(vid,&buf[len],(MAXKEYS-len),NULL,T20SECOND,&term);         if (stat == FALSE) e0 	    return(FALSE);		/* Detected wink so exit	*/'         if (term == DTK$K_TRM_ASTERISK)*+ 	    return(TRUE);		/* Exit key so exit		*/a8 	else if (term == DTK$K_TRM_TIMEOUT && buf[0] != NULL) { 	    /* @ 	     *  Touch tone keys entered but no command terminator ("#")A 	     *  entered.  Warn the user that commands must be terminatedr? 	     *  by the pound key and then process the entered command.t 	     */' 	    speakall_text(vid, no_terminator);h" 	    process_menu_entry(vid, buf); 	}?         else if (term == DTK$K_TRM_TIMEOUT && buf[0] == NULL) {D 	    /* @ 	     *  No touch tone keys received.  Inform the user and exit. 	     */% 	    speakall_text(vid, msg_timeout);t 	    return(TRUE); 	} 	elsei> 	    process_menu_entry(vid, buf);	/* Command so process it	*/<     } while ((buf[0] != NULL || term != DTK$K_TRM_TIMEOUT));     return(TRUE);	 }    /*;  *  Processes the touch tone key string (pointed to by buf)*  *  received from the user.   */  int  process_menu_entry(vid, buf)- unsigned long		vid;			/* DECtalk voice id.	*/r) char			*buf;			/* Touch tone key buffer*/  {      if (strlen(buf) > 1) { 	/*n= 	 *  Only single key commands are valid in this menu.  Informh= 	 *  the user that an invalid command was entered and return.g 	 */(         speakall_text(vid, bad_command); 	bad_entry_count++;e     } E     else if (buf[0]==DTK$K_TRM_ZERO) {	/* Speak help text for menu	*/ .         speak_text(vid, DTK$K_WAIT, msg_help); 	bad_entry_count = 0;      }aH     else if (buf[0]==DTK$K_TRM_ONE) {	/* Give Boston weather forecast	*/J         speak_text(vid, DTK$K_WAIT, msg_weather); /* Speak weather info */ 	bad_entry_count = 0;t     }gD     else if (buf[0]==DTK$K_TRM_TWO) {	/* Give transportation info	*/.         speak_text(vid, DTK$K_WAIT, msg_MBTA); 	bad_entry_count = 0;      }sE     else if (buf[0]==DTK$K_TRM_THREE) {	/* Give mortgage rate info	*/ 2         speak_text(vid, DTK$K_WAIT, msg_mortgage); 	bad_entry_count = 0;T     } D     else if (buf[0]==DTK$K_TRM_FOUR) {	/* Give ski condition info	*/& 	speak_text(vid, DTK$K_WAIT, msg_ski); 	bad_entry_count = 0;,     })"     else {				/* Invalid entry		*/1         speak_text(vid, DTK$K_WAIT, msg_invalid);S 	bad_entry_count++;e     }*       if (bad_entry_count >= 3) { .         speak_text(vid, DTK$K_WAIT, msg_help); 	bad_entry_count = 0;      }  }_     /*G  *  Load the user dictionary with the words and phonemic pronunciations G  *  stored in the sequential file specified in the foreign command line<I  *  invoking the program.  Each line of this file contains the word to be G  *  defined in the user dictionary followed by a space, followed by thetL  *  phonemic pronunciation of the word.  As each line is read from the file,M  *  the word and phonemic pronunciation are stored in separate arrays.  Then, L  *  the word and phonemic pronunciation are loaded into the user dictionary.M  *  If the load dictionary command fails, the user is notified and processing)L  *  is terminated.  Returns TRUE if the dictionary is loaded successfully orP  *  if no user dictionary file name is specified.  Otherwise, FALSE is returned.  */m inte load_dict(vid)7 unsigned long		vid;		/* Voice identifier for DECtalk	*/$ {R2     unsigned long	stat;		/* Status of RTL call		*/9     char	        word[MAXSIZE];	/* Word to be defined		*/i;     char		defn[MAXSIZE];	/* Susstitution (defn) for word	*/ ?     char	        buf[MAXSIZE];	/* Entry has 256 char maximum	*/i9     char	        *bp;		/* Ptr to word/subtitution pair	*/_/     char	        *tp;		/* Temporary pointer		*/t4     FILE		*fldp;		/* File ptr to word/definitions	*/       if (dict_file[0] == NULL) 3 	return(TRUE);			/* No dictionary file specified	*/o1     if ((fldp = fopen(dict_file, "r")) == NULL) {t?         sprintf(errbuf, "Could not open file %s\n", dict_file);e=         log_error(errbuf);		/* Log error to operator term.	*/          return(FALSE);     }      /*J      *  Since there is no timeout associated with the DTK$LOAD_DICTIONARY H      *  command, it is possible for an application to hang waiting for aK      *  response after issuing the DTK$LOAD_DICTIONARY command.  Therefore,nL      *  arm a watchdog timer (5 minutes in this case) to time the loading ofL      *  the entire user dictionary.  If all the entries are not loaded into F      *  the user dictionary before the timer expires, then assume that<      *  something is wrong with the DECtalk module and exit.      */w;     set_timer(T5MINUTE);		/* Set system (watchdog) timer	*/o1     while ((fgets(buf, MAXSIZE, fldp)) != NULL) {  	/* C 	 *  Read in all of the words and substitutions from the sequential D 	 *  file specified in the command string.  First, get the word fromD 	 *  the word/substitution pair and store it in the character bufferC 	 *  "word".  Then, get the phonemic pronunciation for the word and 4          *  store it in the character buffer "defn". 	 */> 	for (bp = &buf[0], tp = &word[0]; bp < &buf[MAXSIZE]; bp++) {) 	    if ((isspace(*bp)) || (*bp == NULL)) ) 		break;			/* At end of word to define	*/t	 	    elseo7 	        *tp++ = *bp;		/* Save character of the word	*/e 	}- 	*tp = NULL;			/* Terminate word to define	*/i 	while (isspace(*++bp))n) 	    ;				/* Skip over any white space	*/h 	/*e4 	 *  Now get the phonemic substitution for the word. 	 */0 	for (tp = &defn[0]; bp < &buf[MAXSIZE]; bp++) {A 	    if (*bp == CR || *bp == LF) /* Skip over carriage returns	*/u! 		continue;		/* and linefeeds		*/I 	    else if (*bp == NULL), 		break;			/* At end of substitution text	*/	 	    elsed1 		*tp++ = *bp;		/* Save character of phonemics	*// 	}) 	*tp = NULL;			/* Terminate phonemics		*/L
         /*G          *  Create the string descriptors for the word and its phonemicrC 	 *  pronunciation and then load the word into the user dictionary.r  	 */r< 	make_sdesc(&s1desc, word);	/* String descriptor for word	*/< 	make_sdesc(&s2desc, defn);	/* String descriptor for defn	*/;         stat = DTK$LOAD_DICTIONARY(&vid, &s1desc, &s2desc); 3 	if (stat == DTK$_TOOLONG || stat == DTK$_NOROOM) {  	    /*pH              *  Dictionary entry too long or no room in user dictionary.@ 	     *  These are not generally fatal errors.  However, in thisM              *  demonstration program, they are treated as such.  In creatinghG              *  a demo program, if words cannot be loaded into the user I              *  dictionary, the programmer should be notified so that themH              *  appropriate corrections can be made.  By treating these N              *  errors as fatal, the programmer will at least know what words &              *  will be mispronounced.	  	     */p 	    cancel_timer();> 	    sprintf(errbuf, "ERROR -- Loading user dictionary.  \n");A             log_error(errbuf);		/* Log error to operator term.	*/ ) 	    sprintf(errbuf, "WORD: %s\n", word);*A             log_error(errbuf);		/* Log error to operator term.	*/i: 	    sprintf(errbuf, "PHONEMIC SUBSTITUTION: %s\n", defn);A             log_error(errbuf);		/* Log error to operator term.	*/  	    fclose(fldp);= 	    sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);wA             log_error(errbuf);		/* Log error to operator term.	*/e- 	    exit(stat);				/* Fatal error so exit	*/  	} 	else if (stat != SS$_NORMAL) {; 	    cancel_timer(); 	    fclose(fldp);D             sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);A             log_error(errbuf);		/* Log error to operator term.	*/e- 	    exit(stat);				/* Fatal error so exit	*/ 	         }      }O     /*1      *  Entire dictionary is loaded successfully. @      *  Cancel the watchdog timer and close the dictionary file.      */ 8     cancel_timer();			/* Cancel system(watchdog) timer*//     fclose(fldp);			/* Close dictionary file	*/      return(TRUE);  }e   /*H  *  DECtalk stopped speaking because it was in autostop keypad mode whenG  *  it received a Touch Tone Key from the user.  First, send DECtalk a GH  *  right square bracket "]" just in case speech was stopped in phonemicL  *  send DECtalk a right sqaure bracket (]) just in case speech was stopped F  *  mode.  Then, restart speech and reset the speaking voice and rate.  */y inta restart(vid)0 unsigned long		vid;		/* Voice ID for DECtalk		*/ {D2     unsigned long	stat;		/* Status of RTL call		*/;     unsigned long	old_mode;	/* Current mode before reset	*/        /*8      *  Send right square bracket to exit phonemic mode.      */f+     speak_text(vid, DTK$K_WAIT, rsbracket);f     /*      *  Set speaking on/      */b     set_timer(T30SECOND); ;     stat = DTK$SET_SPEECH_MODE(&vid, &speechon, &old_mode);0     cancel_timer(); "     if (!(stat & STS$M_SUCCESS)) {@         sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);=         log_error(errbuf);		/* Log error to operator term.	*/s) 	exit(stat);			/* Fatal error so exit		*/=     }{     /*)      *  Reset the voice and speaking rate       */e     set_timer(T30SECOND);t8     stat = DTK$SET_VOICE(&vid, &voice, &rate, &cp, &pp);     cancel_timer();e"     if (!(stat & STS$M_SUCCESS)) {@         sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);=         log_error(errbuf);		/* Log error to operator term.	*/T) 	exit(stat);			/* Fatal error so exit		*/      }  }    /*E  *  End the current user session.  Since the DTK$HANGUP_PHONE command_C  *  does not set a timeout, and it requests DECtalk to send a phonesG  *  status, a watchdog timer is set to insure that the application does!G  *  not hang (if DECtalk fails).  If a longer timeout period is needed, I  *  change the value of the parameter passed to "set_timer()".  After the I  *  watchdog timer is set, speak a goodbye message to the caller and then	K  *  hangup the phone.  The goodbye message spoken can be changed by passing J  *  a different prompt as the second parameter in the call to "end_call()"  */u intf end_call(vid, prompt)t7 unsigned long		vid;		/* Voice id for DECtalk channel	*/ - char		        *prompt;	/* Prompt to speak		*/c {t2     unsigned long	stat;		/* Status of RTL call		*/     long		temp;x     long		timeout;        make_sdesc(&s1desc, prompt);;     set_timer(T5MINUTE);		/* Set system (watchdog) timer	*/D     /*(      *  Say goodbye and hangup the phone      */ +     stat = DTK$HANGUP_PHONE(&vid, &s1desc);S0     cancel_timer();			/* Cancel system timer		*/"     if (!(stat & STS$M_SUCCESS)) {@         sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);=         log_error(errbuf);		/* Log error to operator term.	*/ ) 	exit(stat);			/* Fatal error so exit		*/e     }n     /*A      *  Get rid of any winks that may have been generated by the tB      *  caller by hanging up in the middle of the goodbye message.C      *  This workaround clears the internal WINK flag so that winksc2      *  are not propagated to the next phone call.      */      timeout = 1;     for (;;) {?         set_timer(T5MINUTE);		/* Set system (watchdog) timer	*/n5 	stat = DTK$READ_KEYSTROKE(&vid, &temp, 0, &timeout);p- 	cancel_timer();			/* Cancel system timer		*/ 2 	if (stat == DTK$_ONHOOK || stat == SS$_TIMEOUT) { 	    /*u2 	     *  Clear remaining winks that may have been 7 	     *  detected before DECtalk hung up the telephone.m 	     */C             set_timer(T30SECOND);	/* Set system (watchdog) timer	*/t9 	    stat = DTK$READ_KEYSTROKE(&vid, &temp, 0, &timeout);p0 	    cancel_timer();		/* Cancel system timer		*/# 	    if (!(stat & STS$M_SUCCESS)) {i: 		sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);6 		log_error(errbuf);	/* Log error to operator term.	*/) 		exit(stat);		/* Fatal error so exit		*/y 	    } 	    break;s 	}$ 	else if (!(stat & STS$M_SUCCESS)) {= 	    sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device); = 	    log_error(errbuf);	    /* Log error to operator term.	*/e0 	    exit(stat);		    /* Fatal error so exit		*/ 	}     }n }v     /*F  *  Sends the prompt specified by parameter "prompt" to the DECtalk toC  *  be spoken.  However, before the prompt is sent to the DECtalk, eE  *  autostop keypad mode is disabled (if it is enabled) so that it is F  *  guarenteed that the user hears the entire prompt.  Once the prompt:  *  has been spoken, autostop keypad mode is re-enabled.    */  intp speakall_text(vid, prompt)3 unsigned long	vid;			/* DECtalk voice identifier	*//$ char		*prompt;		/* Text to speak		*/ {r3     unsigned long	kmode;		/* Keypad mode to set		*/f8     unsigned long	stat;		/* Status code from RTL call	*/       /*J      *  If autostop keypad mode is enabled (keymode = DTK$K_KEYPAD_AUTO), 5      *  then enable the keypad without autostop mode.       */ H     if (keymode == DTK$K_KEYPAD_AUTO) {	/* Keypad is in autostop mode	*/; 	kmode = DTK$K_KEYPAD_ON;	/* Just enable "normal" keypad	*/ 4 	set_timer(T30SECOND);		/* Set the watchdog timer	*/* 	stat = DTK$SET_KEYPAD_MODE(&vid, &kmode);2 	cancel_timer();			/* Cancel the watchdog timer	*/&         if (!(stat & STS$M_SUCCESS)) {D             sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);A             log_error(errbuf);		/* Log error to operator term.	*/              exit(stat);w	         }t     }u     /*,      *  Send text to DECtalk to be spoken.  A      *  Specify the mode as DTK$K_WAIT so that text is completelyp@      *  spoken before the keypad is re-enabled in autostop mode.      */t(     speak_text(vid, DTK$K_WAIT, prompt);     /*+      *  If autostop keypad mode was enabledw9      *  (keymode = DTK$K_KEYPAD_AUTO), then re-enable it.       */dI     if (keymode == DTK$K_KEYPAD_AUTO) {	/* Keypad was in autostop mode	*/  	kmode = DTK$K_KEYPAD_AUTO;k1 	set_timer(T30SECOND);		/* Set watchdog timer		*/i* 	stat = DTK$SET_KEYPAD_MODE(&vid, &kmode);2 	cancel_timer();			/* Cancel the watchdog timer	*/&         if (!(stat & STS$M_SUCCESS)) {D             sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);A             log_error(errbuf);		/* Log error to operator term.	*/s             exit(stat);a	         }e     }t }w     /*I  *  Sends the prompt specified by parameter "prompt" to the DECtalk to beiF  *  spoken.  If an error occurs, a warning message is displayed on the  *  console terminal.DH  *  NOTE: The watchdog timer (set by calling "set_timer()") is set to a F  *        fairly large value (15 minutes) because there is no accurateD  *        way to detemine how long it will take to speak the prompt.  */l intr speak_text(vid, mode, prompt) 3 unsigned long	vid;			/* DECtalk voice identifier	*/.8 unsigned long	mode;			/* When to return from speaking	*/$ char		*prompt;		/* Text to speak		*/ {      unsigned long	stat;g     long        	timer;         make_sdesc(&s1desc, prompt);<     set_timer(T15MINUTE);		/* Set system (watchdog) timer	*/0     stat = DTK$SPEAK_TEXT(&vid, &s1desc, &mode);1     cancel_timer();			/* Cancel system timer		*/	o     if (stat != SS$_NORMAL) {_@         sprintf(errbuf, "FATAL ERROR %d on %s\n", stat, device);=         log_error(errbuf);		/* Log error to operator term.	*/r0         exit(stat);			/* Fatal error so exit		*/     }  }      /*J  *  Sets the system (watchdog) timer to expire "sec" seconds in the futureE  *  by invoking the "SYS$SETIMR" system service.  The time passed to *I  *  "SYS$SETIMR" is expressed in a unique  64 bit format.  It is a binary"I  *  number expressed in 100 nanosecond units offset from the system base *H  *  date and time.  To represent a time value in terms of 100 nanosecond  *  units, use the conversion:  *3  *          1 second = 10,000,000 * 100 nanoseconds   *F  *  The time must also be specified as a delta time, that is, it is anG  *  offset from the current time to a time in the future.  Delta times t,  *  are always expressed as negative values.  */O int  set_timer(sec)/ long    	sec;			/* Number of seconds to wait	*/a {		t 			t     unsigned long	stat;      long 		delta[2];     long 		op1[2];       /*M      *  Check if time to wait is more than 86400 seconds (24 hours).  If so, *K      *  print an error message on the screen and exit.  Otherwise, convert  H      *  the number of seconds to a delta time to be passed to the system      *  service "SYS$SETIMR"      */ 9     if (sec > T24HOUR) {		/* Timeout period > 24 hours	*/mC 	sprintf(errbuf, "ERROR: Timer specified greater than 24 hours\n");a=         log_error(errbuf);		/* Log error to operator term.	*/i         exit(SS$_ABORT);     }e     /*A      *  Convert the number of seconds (passed as parameter "sec")nA      *  to a delta time.  In VAX C, the maximum size integer thateB      *  arithmetic can be performed on is 32 bits long.  With thisD      *  limitation, the maximum timeout period that could be allowedF      *  is 429 seconds (a little more than 7 minutes).  Since the timeD      *  passed to the "SYS$SETIMR" routine is specified in a 64 bit D      *  format, it is possible to specify longer timeout periods (upI      *  to 24 hours for this demonstration program).  However, to compute E      *  the delta time is a bit more complicated.  The algorithm used/F      *  loops continuously until the time specified in seconds ("sec")H      *  is less than or equal to zero.  If the time specified in secondsE      *  ("sec") is less than or equal to 429 seconds (that is, it cantH      *  be expressed in a longword), convert this time to 100 nanosecondI      *  units by multiplying the number of seconds ("sec") by 10 million.*G      *  Then, subtract 429 from "sec".  Finally add the converted time  J      *  value to the computed delta time ("delta").  If the time specifiedI      *  in seconds ("sec") is larger than 429, multiply 429 by 10 millioncJ      *  to convert time to 100 nanosecond units.  Again, 429 is subtractedH      *  from "sec" and the converted time value is added to the computedD      *  delta time "delta".  Note, the additions are performed usingO      *  LIB$ADDX since the two values being added are quadwords (64 bits long).e      */o3     delta[0] = 0;			/* Initialize converted time	*/      delta[1] = 0;		h9     while (sec > 0) {			/*  Convert "seconds" to delta	*/ < 	if (sec <= T429SECOND) {	/* Time * 10000000 fits in long	*/ 	    /*a? 	     *  Value specified by "sec" will fit into longword after  E              *  conversion to 100 nanosecond units occurs. (That is, oE              *  after the multiplication by 10,000,000 is performed).E              */ @ 	    op1[0] = sec * 10000000;	/* Converted value in low order	*/5 	    op1[1] = 0;			/* Nothing in high order longwrd*/s 	} 	else {	 	    /*)= 	     *  Value specified by "sec" will not fit into longword )E              *  after conversion to 100 nanosecond units occurs. So,  C              *  convert the maximum number of seconds that will fitt.              *  in a longword (429 seconds).                */iC 	    op1[0] = T429SECOND * 10000000;   /* Max value in long word	*/b 	    op1[1] = 0;	         } >         sec -= T429SECOND;		/* Decrement timeout by 429 secs*/ 	/*K: 	 *  Add the converted time (in "op1") to the computed sumD          *  for the delta time ("delta").    Use LIB$ADDX to performC          *  this addition because the sum of two quadwords (64 bit D(          *  integers) is being computed.          */;D         if ((stat = LIB$ADDX(&op1, &delta, &delta)) != SS$_NORMAL) {H             sprintf(errbuf, "ERROR failed computation of delta time\n");A             log_error(errbuf);		/* Log error to operator term.	*//             exit(stat);3 	}     }*     op1[0] = op1[1] = 0;     /*G      *  Delta times must be expressed as negative values.  Subtract theiJ      *  computed time (in variable "delta") from zero to obtain the actualF      *  delta time.  Use LIB$SUBX to perform the subtraction since theH      *  difference between two quadword (64 bit integers) must be found.      */y@     if ((stat = LIB$SUBX(&op1, &delta, &delta)) != SS$_NORMAL) {> 	sprintf(errbuf, "ERROR: failed computation of delta time\n");=         log_error(errbuf);		/* Log error to operator term.	*/          exit(stat);      }l:     stat = SYS$SETIMR(0, delta, &LIB$SIGNAL, SS$_TIMEOUT);"     if (!(stat & STS$M_SUCCESS)) {D 	sprintf(errbuf, "ERROR: failed setting system (watchdog) timer\n");=         log_error(errbuf);		/* Log error to operator term.	*/ ) 	exit(stat);			/* Fatal error so exit		*/t     }  }r   /*&  *  Cancel the system (watchdog) timer  */  ints cancel_timer() {p     unsigned long	stat;   &     stat = SYS$CANTIM(SS$_TIMEOUT, 0);"     if (!(stat & STS$M_SUCCESS)) {F 	sprintf(errbuf, "ERROR: failed canceling system (watchdog) timer\n");=         log_error(errbuf);		/* Log error to operator term.	*/	) 	exit(stat);			/* Fatal error so exit		*/      }  }a 	      /*'  *  Create the static string descriptorD   *  "desc" for the string "text"  */d into make_sdesc(desc, text)> struct dsc$descriptor_s *desc;		/* Static string descriptor	*/$ char			*text;		/* String of text		*/ {	B     desc->dsc$w_length = strlen(text);	/* Length of text string	*/8     desc->dsc$b_dtype = DSC$K_DTYPE_T;	/* Data type			*/B     desc->dsc$b_class = DSC$K_CLASS_S;	/* Descriptor class code	*/=     desc->dsc$a_pointer = text;		/* String of text pointer	*/T }E     /*)  *  Create the variable string descriptorr   *  "desc" for the string "text"  */t int*  make_vdesc(desc, buffer, maxlen)A struct dsc$descriptor_vs *desc;		/* Variable string descriptor	*/ + char			*buffer;	/* String buffer pointer	*/h. long			maxlen;		/* Maximum length of string	*/ {eB     desc->dsc$w_maxstrlen = maxlen;	/* Maximum length of string	*/9     desc->dsc$b_dtype = DSC$K_DTYPE_VT;	/* Data type			*/dC     desc->dsc$b_class = DSC$K_CLASS_VS;	/* Descriptor class code	*/ =     desc->dsc$a_pointer = buffer;	/* String buffer pointer	*/a }a     /*>  *  Create the static string descriptor "desc" for the messageG  *  buffer "msgbuf" used to send a user request to an operator terminale  */c int_ make_opr_sdesc(desc, msgbuf)> struct dsc$descriptor_s *desc;		/* Static string descriptor	*/5 OPER_REQ		*msgbuf;	/* Request to send to oper term	*/e {      register int	len;r     register int	maxlen;  J     maxlen=sizeof(msgbuf->opc$l_ms_text);  /* Max length of text buffer	*/I     len=strlen(msgbuf->opc$l_ms_text);	   /* Actual len of text string	*/ I     desc->dsc$w_length = sizeof(OPER_REQ); /* Max length of entire buf	*/u?     desc->dsc$w_length -= (maxlen - len);  /* Actual length		*/e8     desc->dsc$b_dtype = DSC$K_DTYPE_T;		/* Data type		*/I     desc->dsc$b_class = DSC$K_CLASS_S;	        /* Descriptor class code*/uB     desc->dsc$a_pointer = msgbuf;	        /* String of text ptr	*/ }i  