 IDENTIFICATION DIVISION. PROGRAM-ID.	DECTALK-DEMO.    AUTHOR.    *  *			 COBOL_DTDEMO.COB  * D *  The following file contains a "modifiable" demonstration program K *  to be included in the DECtalk Voice Application Development Guide.  This E *  demonstration program typifies most telephone application programs H *  written for DECtalk.  It is written in VAX-COBOL and uses Version 4.5F *  or later of the VMS/MicroVMS Run-Time Library Support provided for  *  DECtalk.  * B *  Description:	This program provides a framework to develop other5 *		demonstration programs.  Currently, it provides an 7 *		information services demonstration giving the Boston 4 *		weather forecast, transportation information, ski8 *		conditions, and mortgage rate information in a single: *		menu system.  The program provides dial-in access only.? *		When a user calls in, DECtalk answers the phone and speaks a @ *		short greeting message.  Then, the customer is asked to enter8 *		his access code and password.  The customer is given 5 *		three attempts to enter his access code and three  7 *		attempts to enter his password.  Once access to the  6 *		system has been gained, DECtalk prompts the user to< *		enter a command.  The six valid commands are given below: * , *		   Key 1 for the Boston weather forecast.+ *		   Key 2 for transportation information. * *		   Key 3 for mortgage rate information.+ *		   Key 4 for the current ski conditions.  *		   Key 0 for help.  *		   Key * to exit. * 9 *	NOTE:	the user's access code, password and all commands 8 *		except exit must be terminated by the pound sign key,9 *		although the application will accept input without the < *		pound sign key after a timeout.  When a valid command is ? *		entered, DECtalk speaks the appropriate message to the user. > *		Once the exit key is entered, a wink is detected, or a user> *		fails to enter a command in the specified time period, the > *		user session is ended.  DECtalk speaks a goodbye message to9 *		the user and hangs up the telephone.  Then, DECtalk is @ *		re-enabled for autoanswer and waits for a new telephone call. * ? *		All error messages are logged only to the operator terminals = *		that have specified that the "OPER11" type of message will = *		be handled. These messages give the error message, and the : *		terminal line connected to that process.  To have errorB *		messages logged to the console terminal, or any other terminal,9 *		at the DCL prompt ($), enter the REPLY/ENABLE command:  *  *			$ reply/enable=oper11  * @ *		To enter this command, you must have the OPER user privelege. *  * # *  VAX COBOL LANGUAGE RESTRICTIONS:  * @ *	If running a COBOL program on a MicroVAX you should be careful@ *	to use only the COMPUTATIONAL data type for integer variables.? *	This is because the MicroVAX only emulates the COBOL commands C *	that deal with packed decimal variables, causeing the application B *	to run VERY slow.  All integer variables being passed to the RTL$ *	routines must also be type COMP.   * E *  VMS VERSION 4.5 RUN-TIME LIBRARY RESTRICTIONS FOR DECtalk SUPPORT:  * ; *	There is a problem with the DTKDEF module in STARLET.OLB. E *	The definitions of the touch tone key constants DTK$K_TRM_ZERO thru A *	DTK$K_TRM_NINE should be set to the ASCII valies of the digits. E *	The correct definitions are currently found in "dtkdef.lib".  Note, F *	it is anticipated that this will be fixed in the Version 4.6 release5 *	of VMS.  Consult the release notes for Version 4.6.  * D *	The current version of the RTL does not provide a command to checkD *	the status of DECtalk.  With this command, an application program C *	can determine whether or not the DECtalk module has power cycled  F *	since the last time its status has been observed.  If it is detectedE *	that the DECtalk module has power cycled, the application specific  H *	parameters (speaking voice, speaking rate, words loaded into the user J *	loadable dictionary) should be reinitialized.  By periodically checking B *	the status of the DECtalk module, and reinitializing if the unit@ *	has power cycled, an application may not have to be terminatedF *	to replace failed DECtalk modules.  An alternative solution (used inB *	this demonstration program) re-initializes application specific I *	parameters every time a phone call has not been received in 15 minutes.  * H *	Most of the DTK$ RTL functions that read and return a status conditionF *	from the DECtalk do not have a timeout specified on their read from > *	DECtalk.  These DTK$ RTL functions include DTK$HANGUP_PHONE,C *	DTK$LOAD_DICTIONARY, DTK$RETURN_LAST_INDEX, DTK$SET_KEYPAD_MODE,  E *	DTK$SPEAK_FILE, DTK$SPEAK_PHONEMIC_TEXT, DTK$SPEAK_TEXT.  Without a E *	timeout, it is possible for the application program to hang if the  I *	DECtalk module fails, the power cord is disconnected or the RS232 cable B *	is disconnected. To prevent the application program from hanging@ *	without notifying the operator of the problem, a system timer F *	(using SYS$SETIMR) is set before ALL calls made to the DTK$ facilityB *	of the Run-Time Library.  This is done by performing the routineH *	SET_TIMER.  If a response is received from the DECtalk within the timeF *	period specified, the system timer is canceled (using SYS$CANTIM) byG *	performing the routine CANCEL_TIMER. Otherwise, if the timer expires, G *	the timeout value 556 will be returned. To correct any error that may H *	occur in the communication between the DECtalk module and the physicalH *	device, terminate the current job, correct the error, and then restartE *	the job.  Note, the application program will hang until the problem  *	has been corrected.  * E *	The current version of DTK$READ_STRING does not work correctly.  If E *	a series of touch tone keys is entered on the touch tone keypad and G *	a terminating character (number sign key or asterisk) is not entered, E *	the series of touch tone keys entered is returned after the timeout E *	period specified along with a terminator code of DTK$K_TRM_TIMEOUT. D *	On the next call to DTK$READ_STRING, when the series of touch toneG *	keys is returned, it always includes the last touch tone key returned H *	in the previous call to DTK$READ_STRING as the first touch tone key in< *	the series of keys returned.  The routine "GET_KEY_STRING"E *	in this demonstration program can be used to read a series of touch F *	tone keys terminated by the number sign key or the asterisk key.  It= *	is similar in functionality to the DTK$READ_STRING routine.  *    DATE-WRITTEN.	OCT-86.  DATE-COMPILED.   ENVIRONMENT DIVISION.  CONFIGURATION SECTION. SOURCE-COMPUTER.	VAX.  OBJECT-COMPUTER.	VAX.    INPUT-OUTPUT SECTION. 
 FILE-CONTROL. = 	SELECT OPTIONAL USER-DICTIONARY ASSIGN TO "DICTIONARY.USER"   				FILE STATUS IS file_stat.    DATA DIVISION.
 FILE SECTION.  FD	USER-DICTIONARY  	VALUE OF ID IS DICTIONARY_NAME. 01	ENTRY	PIC X(257).   WORKING-STORAGE SECTION. COPY DTKDEF.7 01	SS$_NORMAL	PIC S9(9) COMP VALUE EXTERNAL SS$_NORMAL. 9 01	SS$_TIMEOUT	PIC S9(9) COMP VALUE EXTERNAL SS$_TIMEOUT. = 01	STS$M_SUCCESS	PIC S9(9) COMP VALUE EXTERNAL STS$M_SUCCESS. 9 01	LIB$SIGNAL	USAGE IS POINTER VALUE EXTERNAL	LIB$SIGNAL.    01 RSBRACKET	PIC X VALUE "]".     01 MSG_WELCOME	PIC X(80)  VALUE > 	"Welcome to the Dectalk information services demonstration.".  G 01 MSG_ACCESS	PIC X(120)  VALUE "Please enter your Access Code followed ? -    " by the Pound-key. You may enter any number as a test. ".   F 01 MSG_PASSWORD	PIC X(120)  VALUE "Please enter your Password followed? -    " by the Pound-key. You may enter any number as a test. ".   ! 01 MSG_NOACCESS	PIC X(80)  VALUE  Q      "Access denied. Please check your access code and password and try again. ".   D 01 MSG_GOODBYE	PIC X(100)  VALUE "Thank you for calling the Dectalk = -    " application demonstration program. Have a nice day. ".     01 MSG_TIMEOUT	PIC X(80)  VALUE 4 	"No key pressed in the timeout period specified. ".  K 01 MSG_BAD_COMMAND  PIC X(80) VALUE "Invalid command. Please try again. ".    F 01 MSG_NO_TERMINATOR  PIC X(100)  VALUE "Please remember to terminate < -    " your entry with the pound-key.  Command accepted.  ".  ! 01 MENU_PROMPT	PIC X(150)  VALUE TA 	"Please enter a command. For help, press 0 followed by the poundl+ -    "-key. To exit, press the star-key. ".t   01 MSG_HELP."    03 MSG_HELP_1	PIC X(256) VALUE 9 	" To hear the current Boston weather forecast, press 1. o1 -	" To hear transportation information, press 2.  / -	" To hear mortgage rate information, press 3.O2 -	" To hear the current ski conditions, press 4.".  !    03 MSG_HELP_2	PIC X(256) VALUE # 	" To repeat this message, press 0.n, -	" Terminate your entry with the pound-key." -	" To exit, press the star-key.".   01 MSG_WEATHER.d%    03 MSG_WEATHER_1	PIC X(256) VALUE rL      " Welcome to the Boston area weather service. April 1st.  Today will beM -    " a day [\""]more like early May. Current downtown Boston temperature iseP -    " 58 degrees Fahrenheit, 14 Celsius. It will be a [\""]beautiful sunny day, -    " breezy and mild, ". o%    03 MSG_WEATHER_2	PIC X(256) VALUE rC      " with a high of 76 degrees Fahrenheit.  Humidity will be 76%. N -    " Barometric pressure is currently 32.5.  Tomorrow will be cooler, with aM -    " high of fifty on the coast and sixty inland.  Fair weather is expectedo* -    " to continue throughout the week." .   01 MSG_MBTA.!    03 MSG_MBTA_1	PIC X(256) VALUE M      " Welcome to the MBTA information line.  All MBTA lines are on time. The K -    " B and M line from the north shore is running a limited service, withoL -    " trains running from Ipswich and Rockport at 8 A.M. and 9 A.M. only.".#    03 MSG_MBTA_2	PIC X(256)  VALUE aI      " There will be no red line service between Park Street and Harvard, K -    " Monday from 9 P.M. to 1 A.M..  Substitute bus transportation will bee -    " provided.".   01 MSG_MORTGAGE.&    03 MSG_MORTGAGE_1	PIC X(256) VALUE L      " Welcome to Hamden National Bank's mortgage line. All of the followingM -    " rates are subject to change. The application fee is $250. 30 year ratesJ -    " with 10% [']down are 9.9% with 3 [aen ax] half points, 10.2% with 33 -    " points, 10.5% with 2 [aen ax] half points,". &    03 MSG_MORTGAGE_2	PIC X(256) VALUE K      " 10.8% with no points. 15 year rates with 10% [']down are 9.9% with 2 K -    " [aen ax] half points, 10.1% with 2 points, and 10.5% with no points..K -    " Adjustable rates are at 8.5% fixed for 3 years with 2% a year and 6%t" -    " lifetime caps thereafter.".   01 MSG_SKI.t!   03 MSG_SKI_1		PIC X(256) VALUE rO      " Welcome to the New England ski report. January 31st. skiing is excellent O -    " in Vermont because of yesterday's snowfall of 10 inches.  All ski trailsrG -    " are open at Stowe, Sugar-Bush, Mt. Snow, Stratton, Jay peak, anda -    " Smuggler's Notch, ".y!   03 MSG_SKI_2		PIC X(256) VALUE  O      " with packed powder and full snow-making in operation.  All cross countryXO -    " ski trails are also open, with many groomed trails.  Skiing in Maine anduL -    " [nuw] Hampshire is good, with cold temperatures allowing for constant -    " snow-making. ".!   03 MSG_SKI_3		PIC X(256) VALUE VN      " Gun-stock has 15 [aatax] 25 trails open, Mt. Cranmore has 15 [aatax] 20N -    " trails open, Attitash and Wildcat have all trails open.  Sugar-loaf andK -    " Sunday River also have all trails open, with packed powder and looset -    " granular. ".    03 MSG_SKI_4		PIC X(90) VALUEiL      " Expected snowfall in Maine and [nuw] Hampshire should improve weekend -    " ski conditions. ".r   *  constants, 01	MAX_ENTRY	PIC 9(9) VALUE 3	USAGE IS COMP.. 01	T15MINUTE	PIC 9(9) VALUE 900	USAGE IS COMP.+ 01	TS45SECOND	PIC X(10) VALUE "0 00:00:45".t* 01	TS1MINUTE	PIC X(10) VALUE "0 00:01:00".+ 01	TS2MINUTES	PIC X(10) VALUE "0 00:02:00".n+ 01	TS6MINUTES	PIC X(10) VALUE "0 00:06:00".i, 01	TS11MINUTES	PIC X(10) VALUE "0 00:11:00"., 01	TS16MINUTES	PIC X(10) VALUE "0 00:16:00". *a *   DECtalk specific variables *c$ 01	voice_id	PIC 9(9)  USAGE IS COMP.- 01	return_status_mode PIC 9(9) USAGE IS COMP.o+ 01	terminator_value PIC 9(9) USAGE IS COMP.B& 01	keypad_mode	PIC 9(9) USAGE IS COMP.$ 01	keypad_on	PIC 9(9) USAGE IS COMP.2 01	number_of_rings	PIC 9(9) USAGE IS COMP VALUE 0.! 01	voice		PIC 9(9) USAGE IS COMP.r2 01	speaking_rate	PIC 9(9) USAGE IS COMP VALUE 180.7 01	comma_pause_duration	PIC 9(9) USAGE IS COMP VALUE 0.s8 01	period_pause_duration	PIC 9(9) USAGE IS COMP VALUE 0.$ 01	speech_on	PIC 9(9) USAGE IS COMP.# 01	new_mode	PIC 9(9) USAGE IS COMP.o *t *   Return status variablesc *i) 01	return_status	PIC S9(9) USAGE IS COMP.o$ 01	ret_stat	PIC S9(9) USAGE IS COMP. *l *   Timer variablesn *o 01	set_timer_string PIC X(10).$ 01	delta_time	PIC S9(18) USAGE COMP. *X% *   Dictionary file related variablesI * $ 01	word-cnt		PIC 9(9) USAGE IS COMP.& 01	phonem-cnt		PIC 9(9) USAGE IS COMP.. 01	more-data-remains-flag	PIC XXX VALUE 'YES'.%    88	more-data-remains		VALUE 'YES'.i'    88	no-more-data-remains		VALUE 'NO'.d 01	dictionary_name		PIC X(20). 01	file_stat		PIC XX.n *g& *   General user buffers and variables *r' 01	menu_choice		pic 9(9) usage is comp.M! 01	keypad_input_buffer	pic X(80).t+ 01	read_key_buffer		PIC 9(9) usage is comp. 6 01	read_key_string REDEFINES read_key_buffer PIC XXXX. 01	temp_char		PIC X.7 01	temp_int	REDEFINES temp_char PIC 9(9) USAGE IS COMP.h 01	access_code		pic X(80). 01	password_code		pic X(80).  01	speak_text_buffer	pic X(860). 01	xx			pic 9(9).r2 01	num_input_keys		pic 9(9) usage is comp value 0.1 01	num_hold_keys		pic 9(9) usage is comp value 0.m/ 01	buf_pointer		pic 9(9) usage is comp value 0.s 01	hold_key_buf		pic X(80). 1 01	d_name_length		pic 9(9) usage is comp value 0.	1 01	device_length		pic 9(9) usage is comp value 0.n 01	get_param_buf		pic X(80)." 01	abort			PIC X(5) VALUE "FALSE". *f" *   Application specific variables *y% 01	timeout			PIC 9(9)  USAGE IS COMP.s, 01	advance_timeout		PIC 9(9)  USAGE IS COMP.% 01	version			PIC S9(9) USAGE IS COMP. ) 01	terminal_line_string	PIC X(16) GLOBAL. 6 01	illegal_entry_count	PIC 9(9) USAGE IS COMP VALUE 0.( 01	initialize_flag		PIC XXX VALUE 'YES'.&    88	need_to_initialize		VALUE 'YES'.&    88	already_initialized		VALUE 'NO'. *s *   Error processing variables *  01	error_msg	PIC X(130).' 01	error_structure REDEFINES error_msg.i$    03	OPC$type_target	PIC 9(9) COMP.$    03	OPC$L_MS_RQSTID	PIC 9(9) COMP.    03	error_text	PIC X(120). 01	error_number	PIC 9(9) COMP. 01	error_buf	PIC X(80).e$ 01	on_text		PIC X(6) VALUE "  ON  ".* 01	control_str	PIC X(9) VALUE "!AD!AS!AD". 01	buf_len		PIC 9(9) COMP.   *%page   PROCEDURE DIVISION.R MAIN-PROGRAM-SPACE.   + *	initialization of the DECtalk parameters.  *I  	MOVE DTK$K_VOICE_MALE TO voice.' 	MOVE DTK$K_KEYPAD_AUTO TO keypad_mode.C# 	MOVE DTK$K_KEYPAD_ON TO keypad_on.N 	MOVE DTK$K_SPEAK TO speech_on.N 	MOVE DTK$M_SQUARE TO new_mode.T' 	MOVE DTK$K_WAIT TO return_status_mode.t * @ *	Get the name of the physical device that the DECtalk module isA *	connected to and the name of the dictionary file (if specified)T@ *	that contains DECtalk's user dictionary words. If the call to , *	DTK$INITIALIZE is unsuccessful, then exit. *X 	PERFORM GET_CLI_PARAMS.% 	move TS45SECOND to set_timer_string.N 	perform set_timer.13 	CALL "DTK$INITIALIZE" USING	BY REFERENCE	VOICE_ID,L( 					BY DESCRIPTOR	TERMINAL_LINE_STRING, 					BY REFERENCE	VERSIONU 			      GIVING RETURN_STATUS. 	perform cancel_timer. 	IF RETURN_STATUS IS failure$ 		MOVE return_status to error_number 		PERFORM error_log  		STOP RUN.o   	PERFORM 		NORMAL-OPERATION-PARAGRAPH 			UNTIL ABORT IS = "TRUE".  ABORT_PROGRAM. *s< *	some fatal error has occured... Terminate DECtalk and exit *e% 	move TS45SECOND to set_timer_string.G 	perform set_timer.V% 	CALL "DTK$TERMINATE" USING  VOICE_IDc 			     GIVING RETURN_STATUS.  	perform cancel_timer.  	IF return_status IS NOT SUCCESS$ 		MOVE return_status TO error_number 		PERFORM error_log.
 	STOP RUN.   NORMAL-OPERATION-PARAGRAPH.M *T* *  Main loop of the demonstration program.@ *  First, check to see if the application specific parameters ofK *  the DECtalk need to be initialized (initialize_flag=need_to_initialize). F *  If so, reinitialize them by calling INITIALIZE_DECTALK.  Next, set < *  a watchdog timer for the DTK$ANSWER_PHONE command. If the@ *  phone does not ring in the timeout period specified, (or the B *  watchdog timer expires), reinitialize the application specific C *  parameters of DECtalk.  Normally, these parameters would not be sB *  reinitialized everytime a phone call has not been received, butB *  ONLY when the DECtalk module had power cycled.  However, in theB *  current version of the VMS Run-Time Library Support for DECtalkC *  (Version 4.5), it is not possible to check the status of DECtalknA *  (detect if it has power cycled).  If a phone call is received iD *  within the timeout period, the phone is answered, autostop keypadD *  mode and wink detection are enabled (the default), and a greetingG *  message is spoken to the user.  Next, the user must be verified as aaI *  valid user of the system.  As soon as the user has successfully gained B *  access to the system, he can start entering main menu commands.C *  The code in this loop is continuely executed until a fatal errort$ *  occurs or the process is stopped. *o 	IF need_to_initialize 		PERFORM initialize_dectalk! 		IF return_status IS NOT SUCCESS  *5+ *			Initialization failed.  It appears that * *			the DECtalk module may be dead so exit *  			GO TO abort_program.a 		MOVE 'NO' TO initialize_flag.t 	MOVE spaces TO hold_key_buf.e *  rF *	The greeting message DECtalk speaks upon answering the telephone canI *	be modified by changing the text in the character string "msg_welcome".h; *	The number of rings DECtalk waits to answer the telephonerD *	("number_of_rings"), can be changed but it is recommended that the- *	phone is always answered on the first ring.a *  	MOVE 0 TO num_hold_keys.  	MOVE 0 TO num_input_keys.& 	MOVE TS16MINUTES TO set_timer_string. 	PERFORM set_timer.A4 	CALL "DTK$ANSWER_PHONE" USING BY REFERENCE	voice_id 				      			number_of_rings# 				      BY DESCRIPTOR	msg_welcomes  				      BY REFERENCE	T15MINUTE 				GIVING return_status.n 	PERFORM cancel_timer.( 	IF return_status IS EQUAL TO SS$_NORMAL  C *	The telephone has been answered. Next verify that the caller is abB *	valid user of the system.  If the caller fails to enter a valid B *	access code and password in three attempts, access to the systemE *	is denied.  A warning message is spoken to the user and the currentt- *	phone call is ended by invoking "end_call".t *f+ 		PERFORM verify_user THRU exit_verify_user ! 		IF return_status IS NOT SUCCESSr) 			MOVE msg_noaccess TO speak_text_buffert 			PERFORM speak_texts 			PERFORM end_call" 		ELSE *.: *			The user has successfully gained access to the system.8 *			Start processing commands from the user.  Note, the ; *			menu prompt spoken prior to receiving commands from thet5 *			user, can be modified by changing the text in the " *			character string "menu_prompt" *o   			PERFORM menu THRU exit_menu& 			PERFORM end_call THRU exit_end_call. 	ELSE IF return_status IS EQUAL TO SS$_TIMEOUT 		MOVE 'YES' TO initialize_flag  	ELSE $ 		MOVE return_status TO error_number 		PERFORM error_loge 		STOP RUN.eJ *  --------------------  END OF MAIN PROGRAM  ---------------------------- GET_CLI_PARAMS.w *tC *  Gets the parameters from the command line using LIB$GET_FOREIGN.	C *  If a fatal error occurs, it is reported and the demo is stopped. K *  Otherwise, the parameters specified are returned in terminal_line_stringoP *  for the device name, and dictionary_name for the name of the dictionary file. *t  B 	INSPECT get_param_buf REPLACING CHARACTERS BY X"00" BEFORE X"00".  : 	CALL "LIB$GET_FOREIGN" USING BY DESCRIPTOR get_param_buf, 						   OMITTED,s 						   OMITTED,  						   OMITTED 			     GIVING return_status.i  	IF return_status IS NOT SUCCESS$ 		MOVE return_status TO error_number 		PERFORM error_logn 		STOP RUN.   H 	INSPECT get_param_buf TALLYING device_length FOR CHARACTERS BEFORE " ",7 			d_name_length FOR CHARACTERS AFTER " " BEFORE X"00".  	s= 	MOVE get_param_buf(1:device_length) TO terminal_line_string. I 	MOVE get_param_buf(device_length + 2: d_name_length) TO dictionary_name.C  I *  **********************************************************************. INITIALIZE_DECTALK.( * > *  Initializes the application specific parameters of DECtalk.C *  First, left square bracket ('[') and right square bracket (']') XL *  are enabled as phonemic delimiters. To specify other modes, the bit masksL *  for the modes to be set should be OR'd together with the DTK$M_SQUARE bitL *  mask and assigned to the varible "NEW_MODE".  Next, the default speaking G *  voice and speaking rate are selected for the application.  The commaGD *  pause and period pause are set to DECtalk defaults.  Other voicesH *  can selected for the default speaking voice by modifying the variableA *  "voice".  Likewise, a different speaking rate can be specifiedMF *  by changing the static variable "speaking_rate".  Finally, the userE *  dictionary is loaded (by invoking "load_dictionary").  Note, otherPE *  application specific parameters should also be initialized in this ! *  subroutine if the need arises.s *n% 	MOVE TS45SECOND TO set_timer_string.U 	PERFORM set_timer.i2 	CALL "DTK$SET_MODE" USING  BY REFERENCE voice_id, 				   BY REFERENCE new_mode 			    GIVING return_status. 	PERFORM cancel_timer.  	IF return_status IS NOT SUCCESS$ 		MOVE return_status TO error_number 		PERFORM error_logs 		STOP RUN.d 	PERFORM set_timer.	3 	CALL "DTK$SET_VOICE" USING  BY REFERENCE voice_id,s
 						 voice,v 						 speaking_rate,h 						 comma_pause_duration, 						 period_pause_duration 			     GIVING return_status.  	PERFORM cancel_timer.  	IF return_status IS NOT SUCCESS$ 		MOVE return_status TO error_number 		PERFORM error_logI 		STOP RUN.   3 	PERFORM load_dictionary THRU exit_load_dictionary.1I *  ----------------------------------------------------------------------( VERIFY_USER. *t: *  Verifies that the caller is a valid user of the system.F *  The caller is given three attempts to enter a valid access code andF *  three attempts to enter his password.  If the caller fails to enterK *  a valid access code or a valid password in the timeout period specified,t3 *  FALSE is returned.  Otherwise, TRUE is returned.L *.E *  NOTE: In this demonstration, almost all access codes and passwordsA= *	 are detected as valid.  The only ways an access code or a vA *	 password are rejected are if the user fails to enter an access6B *	 code or a password in the time period specified, or if the userA *	 terminates his access code or password with the star key ("*")	I *	 rather than the pound key ("#").  All valid access codes and passwordsiG *	 (terminated with the pound key) are verified by performing the dummye? *	 verification routines "access_verify" and "password_verify".R- *	 Both of these routines always return TRUE.0 *  	MOVE 0 TO illegal_entry_count.1 	PERFORM 		get-access-code_( 	UNTIL illegal_entry_count =  max_entry. exit_verify_user.    GET-ACCESS-CODE. *nM *  Gets the user's access code entered on the touch tone keypad.  The enterednM *  access code is returned in the character buffer "access_code".  Currently, L *  the maximum size of the buffer is 80 characters. The user is prompted forM *  his access code by the text specified in "msg_access". To have a different$G *  prompt spoken, the character string "msg_access" should be modified. I *  Currently, the application waits 30 seconds for a touch tone key to beiN *  entered.  If a longer or shorter timeout period is desired, the new timeoutE *  value (in seconds) should be moved into timeout before the call toIF *  "get_key_string". The parameter "terminator_value" will contain theK *  character used to terminate the key string or a timeout upon return fromI% *  the "get_key_string" routine.     S *U 	MOVE 0 TO num_input_keys. 	MOVE 30 TO timeout.& 	MOVE msg_access TO speak_text_buffer.1 	PERFORM get_key_string THRU exit_get_key_string._) 	MOVE keypad_input_buffer TO access_code.E   *NG *	If an invalid code was entered, increment the count of invalid accesslI *	code entry attempts.  If this count is greater than the maximum allowedeE *	(specified by MAX_ENTRY), return FALSE.  Otherwise, notify the userIG *	and prompt him again.  If a valid access code is entered, then promptn *	the user for his password. *t 	IF return_status IS SUCCESS 		PERFORM access_verify 7 		IF terminator_value IS EQUAL TO DTK$K_TRM_ASTERISK OR 7 		   terminator_value IS EQUAL TO DTK$K_TRM_TIMEOUT  OR  		   return_status IS FAILURE  			ADD 1 TO illegal_entry_countt% 			IF illegal_entry_count = max_entryl  				SET return_status TO FAILURE 				GO TO exit_verify_user 			ELSEt1 			     MOVE msg_bad_command TO speak_text_buffert 			     PERFORM speak_text* 			     MOVE spaces TO keypad_input_buffer 		ELSE% 			MOVE spaces TO keypad_input_bufferd  			MOVE 0 TO illegal_entry_count 			PERFORM get-password-code) 				UNTIL illegal_entry_count = max_entryN 	ELSEe 		SET return_status TO FAILURE 		GO TO exit_verify_user.    GET-PASSWORD-CODE. *uI *  Gets the user's password entered on the touch tone keypad. The entereduL *  password is returned in the character buffer "password_code".  Currently,M *  the maximum size of the buffer is 80 characters.  The user is prompted for M *  his password by the text specified in "msg_password".  To have a differentfI *  prompt spoken, the character string "msg_password" should be modified.	I *  Currently, the application waits 30 seconds for a touch tone key to beoN *  entered.  If a longer or shorter timeout period is desired, the new timeoutO *  value (in seconds) should be moved into TIMEOUT before "get_key_string". ThemM *  parameter, "terminator_value" will contain the character used to terminateoP *  the key string or timeout upon return from the "get_key_string" routine.      *o 	MOVE 0 TO num_input_keys. 	MOVE 30 TO timeout.( 	MOVE msg_password TO speak_text_buffer.1 	PERFORM get_key_string THRU exit_get_key_string.C+ 	MOVE keypad_input_buffer TO password_code.c *dI *	If an invalid password code was entered, increment the count of invalid D *	entry attempts.  If this count is greater than the maximum allowedE *	(specified by MAX_ENTRY), return FALSE.  Otherwise, notify the useraI *	and prompt him again. If a valid password is entered, then return TRUE.t *  	IF return_status IS SUCCESS 		PERFORM password_verify 7 		IF terminator_value IS EQUAL TO DTK$K_TRM_ASTERISK ORn7 		   terminator_value IS EQUAL TO DTK$K_TRM_TIMEOUT  ORr 		   return_status IS FAILUREi 			ADD 1 TO illegal_entry_countR% 			IF illegal_entry_count = max_entry	  				SET return_status TO FAILURE 				GO TO exit_verify_user 			ELSEf- 				MOVE msg_bad_command TO speak_text_bufferl 				PERFORM speak_text& 				MOVE spaces TO keypad_input_buffer 		ELSE 			SET return_status TO SUCCESS  			GO TO exit_verify_user  	ELSEu 		SET return_status TO FAILURE 		GO TO exit_verify_user.s  I *  ----------------------------------------------------------------------p GET_KEY_STRING.P * N *  Gets a string of touch tone keys entered on the telephone keypad terminatedK *  by the pound key "#" or the star key "*".  Returns TRUE if the string ofOK *  touch tone keys was received successfully. Otherwise, FALSE is returned.- *-# 	IF num_hold_keys IS GREATER THAN 0- *-? *		read any characters waiting in typeahead buffer.  We alreadys= *		have "keys" in "hold_key_buf" (num_hold_keys > 0), but therC *		user could have hung up the phone with several commands pending.h> *		This call to "read_advance_keys" is mainly used to read any> *		winks that are detected by DECtalk.  If a wink is detected,C *		the program should hangup the phone, and reset for a new caller.X *" 		MOVE 1 TO advance_timeoutG 		PERFORM read_advance_keysO; 		   TEST AFTER UNTIL return_status IS EQUAL TO SS$_TIMEOUT	 		MOVE 1 TO buf_pointerI 		PERFORM hold_buf_to_key_bufs7 		UNTIL (hold_key_buf(buf_pointer:1) IS EQUAL TO "#" ORr5 		       hold_key_buf(buf_pointer:1) IS EQUAL TO "*")r *bH *	The terminator code needs to be moved to "terminator_value" which is aB *	longword.  To get the terminator character into the longword, itA *	is moved into the character variable "temp_char" which has beennC *	redefined as an integer "temp_int".  "temp_int" can then be moved*" *	correctly into terminator_value. **/ 		MOVE hold_key_buf(buf_pointer:1) TO temp_charl# 		MOVE temp_int TO terminator_valuee 		MOVE 0 TO num_hold_keyse 		ADD 1 TO buf_pointer" 		PERFORM copy_to_start_of_holdbuf, 			UNTIL hold_key_buf(buf_pointer:1) = X"20"1 		MOVE space TO hold_key_buf(num_hold_keys + 1:1)e 		GO TO process_entry.  0 	IF speak_text_buffer(1:1) IS NOT EQUAL TO X"00"( 		MOVE DTK$K_IMMED TO return_status_mode 		PERFORM speak_text.e' 		MOVE DTK$K_WAIT TO return_status_modep   	PERFORM read_keys/ 			UNTIL return_status IS EQUAL TO SS$_TIMEOUT.f
 read_keys. *o *  Read keys from DECtalk. *e% 	MOVE TS45SECOND TO set_timer_string.a 	PERFORM set_timer.L7 	CALL "DTK$READ_KEYSTROKE" USING BY REFERENCE voice_id,b" 					BY REFERENCE read_key_buffer, 						     OMITTED,  					BY REFERENCE timeoutl 			       GIVING return_status.r 	PERFORM cancel_timer. 	EVALUATE TRUE * @ *	It is important that the check for WINK comes before the checkA *	for SUCCESS, because WINK is a successful status. The test for O@ *	SUCCESS only tests the bottom 3 bits, not the entire longword. *	) 	WHEN return_status IS EQUAL TO DTK$_WINKe$ 		MOVE return_status TO error_number 		PERFORM error_logN 		MOVE 0 TO return_statust 		GO TO exit_get_key_stringR   	WHEN return_status IS SUCCESS *sB *		SUCCESS:  if a terminator is read, set the timeout to 2 seconds8 *			  and read any advance keys pressed.  Otherwise copy; *			  the key to input buffer.  The timeout is shortened to_* *			  10 seconds to read any further keys. *a7 		IF (read_key_buffer IS EQUAL TO DTK$K_TRM_ASTERISK OR 8 		    read_key_buffer IS EQUAL TO DTK$K_TRM_NUMBER_SIGN)+ 			MOVE read_key_buffer TO terminator_value- 			MOVE 2 TO advance_timeout 			PERFORM read_advance_keys (; 			  TEST AFTER UNTIL return_status IS EQUAL TO SS$_TIMEOUTe 			GO TO process_entry 		ELSE 			MOVE read_key_string(1:1) TOa- 				keypad_input_buffer(num_input_keys + 1:1)t 			ADD 1 TO num_input_keys 			MOVE 10 TO timeouta 		END-IF  + 	WHEN return_status IS EQUAL TO SS$_TIMEOUTi, 		MOVE DTK$K_TRM_TIMEOUT TO terminator_value 		GO TO process_entry 	.   	WHEN OTHERh$ 		MOVE return_status TO error_number 		PERFORM error_log	
 		STOP RUN 	END-EVALUATE. 		 PROCESS_entry.	c 	PERFORM restart.w   EXIT_GET_KEY_STRING.   read_advance_keys. *nA *	read any advance keys pressed in "timeout" seconds and put into $ *	"hold_key_buf".  Return when done. *r% 	MOVE TS45SECOND TO set_timer_string.r 	PERFORM set_timer.k7 	CALL "DTK$READ_KEYSTROKE" USING BY REFERENCE voice_id,m" 					BY REFERENCE read_key_buffer, 						     OMITTED, ! 					BY REFERENCE advance_timeoutc 			       GIVING return_status." 	PERFORM cancel_timer. 	EVALUATE TRUE * = *		wink must be checked first because COBOL will interpret itc *		as a SUCCESS status.l *t) 	WHEN return_status IS EQUAL TO DTK$_WINK $ 		MOVE return_status TO error_number 		PERFORM error_logr 		MOVE 0 TO return_status. 		GO TO exit_get_key_stringe   	WHEN return_status IS SUCCESS@ 		MOVE read_key_string(1:1) TO hold_key_buf(num_hold_keys + 1:1) 		ADD 1 TO num_hold_keys  + 	WHEN return_status IS EQUAL TO SS$_TIMEOUTt1 		MOVE space TO hold_key_buf(num_hold_keys + 1:1)  *oB *		Move space to end of hold key string.  This space marks the end% *		of advance keys in "hold_key_buf".s *n 	WHEN OTHERh$ 		MOVE return_status TO error_number 		PERFORM error_logu
 		STOP RUN 	END-EVALUATE.   hold_buf_to_key_buf. *nE *	Copy keys from "hold_key_buf" to "input_key_buf" up to a terminatorg *	("*", "#", or space).t *v1 	IF hold_key_buf(buf_pointer:1) IS EQUAL TO X"20"a 		MOVE 0 TO num_hold_keyso 		MOVE spaces TO hold_key_bufe 		GO TO read_keysn 	ELSES% 		MOVE hold_key_buf(buf_pointer:1) TO / 				 keypad_input_buffer(num_input_keys + 1:1) f( 		ADD 1 TO num_input_keys   buf_pointer.   copy_to_start_of_holdbuf.i *t> *	Copy any remaining keys in "hold_key_buf" to the begining of *	"hold_key_buf".n *fH 	MOVE hold_key_buf(buf_pointer:1) TO  hold_key_buf(num_hold_keys + 1:1).$ 	ADD 1 TO num_hold_keys buf_pointer.  I *  ----------------------------------------------------------------------  ACCESS_VERIFY. *cH *  Verifies the access code received from the user.  This routine alwaysN *  returns TRUE for the purpose of this demonstration.  In a real application,D *  the entry would be verified against access codes in the database. *U 	SET RETURN_STATUS TO SUCCESS.  I *  **********************************************************************r PASSWORD_VERIFY. *aL *  Verifies the password received from the user. This routine always returnsJ *  TRUE for the purpose of this demonstration.  In a real application, theB *  entry would be verified against their password in the database. *  	SET RETURN_STATUS TO SUCCESS.  I *  **********************************************************************E MENU.	 * F *  Prompts the user for a command and receives the command (touch toneI *  key) from the user.  Note, the command will be accepted whether or notnD *  it is terminated with the pound key "#".  However, if the commandF *  is not followed by the pound key, the command will not be processedN *  until the timeout period has expired and a warning message has been spoken.L *  When commands are received, the routine "process_menu_entry" is performed  *  to implement the menu choice. ** 	MOVE 0 TO num_input_keys. 	MOVE 0 TO illegal_entry_count.  	PERFORM/ 	   get_keypad_entry THRU exit_get_keypad_entry.8 		UNTIL (keypad_input_buffer(1:1) IS EQUAL TO X"20"  AND2 			terminator_value IS EQUAL TO DTK$K_TRM_TIMEOUT) 	SET return_status TO SUCCESS.
 EXIT_MENU.  I *  ----------------------------------------------------------------------r GET_KEYPAD_ENTRY.f * > *  Keep getting commands from the user until the exit key "*",A *  is entered, a wink is detected, or the timeout period expires. G *  First, check if there are any keys in the typeahead buffer (done by  D *  "get_key_string" with a 1 second timeout).  If so, process them. F *  Otherwise, prompt the user for a command and wait for his response. *h$ 	MOVE spaces TO keypad_input_buffer. 	MOVE 1 TO timeout.c" 	MOVE X"00" TO speak_text_buffer.	1 	PERFORM get_key_string THRU exit_get_key_string.n   	IF return_status IS FAILURE 		GO TO exit_menu. 	EVALUATE TRUE: 	  WHEN terminator_value IS EQUAL TO DTK$K_TRM_NUMBER_SIGN 		PERFORM process_menu_entry 		GO TO exit_get_keypad_entrye7 	  WHEN terminator_value IS EQUAL TO DTK$K_TRM_ASTERISKa 		SET return_status to SUCCESS 		GO TO exit_menu > 	  WHEN (terminator_value IS NOT EQUAL TO DTK$K_TRM_TIMEOUT OR5 		(terminator_value is equal to DTK$K_TRM_TIMEOUT ANDi/ 			keypad_input_buffer(1:1) IS EQUAL TO X"20"))p' 		MOVE menu_prompt TO speak_text_buffer  		PERFORM speak_text: 	  WHEN terminator_value IS EQUAL TO DTK$K_TRM_TIMEOUT AND. 			keypad_input_buffer(1:1) IS NOT EQUAL X"20" *_: *		Touch tone keys entered but no command terminator ("#"); *		entered.  Warn the user that commands must be terminated_9 *		by the pound key and then process the entered command.  *	- 		MOVE msg_no_terminator TO speak_text_bufferb 		PERFORM speak_all_text 		PERFORM process_menu_entry 		GO TO exit_get_keypad_entryu7 	  WHEN terminator_value IS EQUAL TO DTK$K_TRM_ASTERISK  		SET return_status TO SUCCESS 		GO TO exit_menuO   	END-EVALUATE. *t= *	Read any new keys from keypad, and take appropriate action.- *- 	MOVE 20 TO timeout.! 	MOVE X"00" TO speak_text_buffer. 1 	PERFORM get_key_string THRU exit_get_key_string.k 	IF return_status IS FAILURE 		GO TO exit_menu.   	EVALUATE TRUE: 	  WHEN terminator_value IS EQUAL TO DTK$K_TRM_NUMBER_SIGN 		PERFORM process_menu_entry: 	  WHEN terminator_value IS EQUAL TO DTK$K_TRM_TIMEOUT AND. 			keypad_input_buffer(1:1) IS NOT EQUAL X"20" *r: *		Touch tone keys entered but no command terminator ("#"); *		entered.  Warn the user that commands must be terminated 9 *		by the pound key and then process the entered command.e * - 		MOVE msg_no_terminator TO speak_text_buffere 		PERFORM speak_all_text 		PERFORM process_menu_entry: 	  WHEN terminator_value IS EQUAL TO DTK$K_TRM_TIMEOUT AND* 			keypad_input_buffer(1:1) IS EQUAL X"20"' 		MOVE msg_timeout TO speak_text_buffere 		PERFORM speak_all_text 		SET return_status TO SUCCESS 		GO TO exit_menud7 	  WHEN terminator_value IS EQUAL TO DTK$K_TRM_ASTERISK  		SET return_status to SUCCESS 		GO TO exit_menu:   	END-EVALUATE. EXIT_GET_KEYPAD_ENTRY.I *  ----------------------------------------------------------------------e PROCESS_MENU_ENTRY.a *r> *  Processes the touch tone key string received from the user. *p  	IF num_input_keys IS EQUAL TO 1. 		MOVE keypad_input_buffer(1:1) TO menu_choice * > *		-- Make the menu choice an ascii value to match dtk$k codes *( 		ADD 48 TO menu_choice.   	EVALUATE TRUE) 	   WHEN num_input_keys IS NOT EQUAL TO 1d *y; *		Only single key commands are valid in this menu.  Informf; *		the user that an invalid command was entered and return.T *o+ 		MOVE msg_bad_command TO speak_text_bufferc 		PERFORM speak_all_text 		ADD 1 TO illegal_entry_count  / 	   WHEN menu_choice IS EQUAL TO DTK$K_TRM_ZEROE$ 		MOVE MSG_HELP TO speak_text_buffer 		PERFORM speak_text 		MOVE 0 TO illegal_entry_countr  . 	   WHEN menu_choice IS EQUAL TO DTK$K_TRM_ONE' 		MOVE MSG_WEATHER TO speak_text_bufferV 		PERFORM speak_text 		MOVE 0 TO illegal_entry_countL  . 	   WHEN menu_choice IS EQUAL TO DTK$K_TRM_TWO$ 		MOVE MSG_MBTA TO speak_text_buffer 		PERFORM speak_text 		MOVE 0 TO illegal_entry_countl  0 	   WHEN menu_choice IS EQUAL TO DTK$K_TRM_THREE( 		MOVE MSG_MORTGAGE TO speak_text_buffer 		PERFORM speak_text 		MOVE 0 TO illegal_entry_counto  / 	   WHEN menu_choice IS EQUAL TO DTK$K_TRM_FOUR # 		MOVE MSG_SKI TO SPEAK_TEXT_BUFFERb 		PERFORM speak_text 		MOVE 0 TO illegal_entry_countn   	   WHEN OTHER+ 		MOVE msg_bad_command TO speak_text_bufferu 		PERFORM speak_text 		ADD 1 TO illegal_entry_count 	END-EVALUATE.   	MOVE 0 TO num_input_keys. *aA *	If user enters 3 illegal/incorrect commands, speak help messagei *u) 	IF illegal_entry_count IS GREATER THAN 2k$ 		MOVE MSG_HELP TO speak_text_buffer 		PERFORM speak_text  		MOVE 0 TO illegal_entry_count. EXIT_PROCESS_MENU_ENTRY.I *  ----------------------------------------------------------------------  LOAD_DICTIONARY. *eF *  Load the user dictionary with the words and phonemic pronunciationsF *  stored in the sequential file specified in the foreign command lineH *  invoking the program.  Each line of this file contains the word to beF *  defined in the user dictionary followed by a space, followed by theH *  phonemic pronunciation of the word.  The entry is parsed to find the M *  start and finnish of the word and it's replacement.  The word and phonemicKL *  pronunciation are loaded into the user dictionary. If the load dictionaryM *  command fails, the user is notified and processing is terminated.  ReturnsUN *  TRUE if the dictionary is loaded successfully or if no user dictionary file4 *  name is specified.  Otherwise, FALSE is returned. *e+ 		IF dictionary_name(1:1) IS EQUAL TO X"20"  			SET return_status TO SUCCESS5 			GO TO exit_load_dictionaryP	 		END-IF.t 	OPEN INPUT user-dictionary. 	EVALUATE TRUE! 		WHEN file_stat IS EQUAL TO "05"C! 		WHEN file_stat IS EQUAL TO "97"T * 6 *			This is not the best way to do this, but these two4 *			conditions indicate "FILE NOT OPENED CORRECTLY"., *			98962 is the error number for the RMS - 4 *			File Not Found message.  This is used because we0 *			need to pass ERROR_LOG the VMS error number. *t 			MOVE 98962 TO error_numberE 			PERFORM error_log 			STOP RUNn 	END-EVALUATE. *xD *	Since there is no timeout associated with the DTK$LOAD_DICTIONARY B *	command, it is possible for an application to hang waiting for aE *	response after issuing the DTK$LOAD_DICTIONARY command.  Therefore, F *	arm a watchdog timer (6 minutes in this case) to time the loading ofF *	the entire user dictionary.  If all the entries are not loaded into @ *	the user dictionary before the timer expires, then assume that6 *	something is wrong with the DECtalk module and exit. *e% 	MOVE TS6MINUTES TO set_timer_string.b 	PERFORM set_timer." 	PERFORM  load-dictionary-entry, 		UNTIL no-more-data-remains.b *b, *	Entire dictionary has loaded successfully.B *	Cancel the watchdog timer, close the dictionary file and return. *S 	PERFORM cancel_timer. 	CLOSE user-dictionary.k 	SET return_status TO SUCCESS. EXIT_LOAD_DICTIONARY.n  I *  ----------------------------------------------------------------------m LOAD-DICTIONARY-ENTRY.: 	INSPECT entry REPLACING CHARACTERS BY X"00" BEFORE X"00". 	MOVE ZERO TO word-cnt.O 	MOVE ZERO TO phonem-cnt.s * @ *	Read in all of the words and substitutions from the sequentialC *	file specified in the command string.  The positions of each word.A *	are located with the INSPECT command, and then these fields aretJ *	defined using REFERENCE MODIFICATION in the DTK$LOAD_DICTIONARY routine. *p 	READ user-dictionaryy- 		AT END MOVE 'NO' TO more-data-remains-flag.d 	IF more-data-remainsR *TC *	   This inspect isn't necessary if the words and substitution are* *	   separated by spaces only. *V9 	   INSPECT entry REPLACING ALL X"09" BY " " BEFORE X"00".> 	   INSPECT entry TALLYING word-cnt FOR CHARACTERS BEFORE " ",: 			       phonem-cnt FOR CHARACTERS AFTER " " BEFORE X"00"  < 	   CALL "DTK$LOAD_DICTIONARY" USING BY REFERENCE  voice_id,* 					    BY DESCRIPTOR entry (1:word-cnt),3 				  BY DESCRIPTOR entry (word-cnt + 2:phonem-cnt)n 				GIVING return_status0 	   IF return_status IS EQUAL TO DTK$_TOOLONG OR, 	      return_status IS EQUAL TO DTK$_NOROOM *_; *		Dictionary entry too long or no room in user dictionary. : *		These are not generally fatal errors.  However, in this@ *		demonstration program, they are treated as such.  In creating: *		a demo program, if words cannot be loaded into the user< *		dictionary, the programmer should be notified so that the' *		appropriate corrections can be made.u *e 		CLOSE user-dictionary $ 		MOVE return_status TO error_number 		PERFORM error_logy
 		STOP RUN( 	   ELSE IF return_status IS NOT SUCCESS 		CLOSE user-dictionaryh 		GO TO exit_load_dictionary.o  I *  ----------------------------------------------------------------------M RESTART. *oG *  DECtalk stopped speaking because it was in autostop keypad mode wheniF *  it received a Touch Tone Key from the user.  First, send DECtalk a J *  right square bracket "]" just in case speech was stopped while speakingL *  phonemic text. Then, restart speech (using DTK$SET_SPEECH_MODE) and reset5 *  the speaking voice and rate (using DTK$SET_VOICE).s *u$ 	MOVE rsbracket TO speak_text_buffer 	PERFORM speak_text.% 	MOVE TS45SECOND TO set_timer_string.	 	PERFORM set_timer.e* 	CALL "DTK$SET_SPEECH_MODE" USING voice_id 					 speech_on  				   GIVING return_status. 	PERFORM cancel_timer.  	IF return_status IS NOT SUCCESS$ 		MOVE return_status TO error_number 		PERFORM error_logk 		STOP RUN.u 	PERFORM set_timer.L2 	CALL "DTK$SET_VOICE" USING  BY REFERENCE voice_id 						 voice 						 speaking_rate 						 comma_pause_duration  						 period_pause_duration 			     GIVING return_status.r 	PERFORM cancel_timer.  	IF return_status IS NOT SUCCESS$ 		MOVE return_status TO error_number 		PERFORM error_logt 		STOP RUN.x 	SET return_status TO SUCCESS.I *  ----------------------------------------------------------------------E	 END_CALL.  *tD *  End the current user session.  Since the DTK$HANGUP_PHONE commandB *  does not set a timeout, and it requests DECtalk to send a phoneF *  status, a watchdog timer is set to insure that the application doesF *  not hang (if DECtalk fails).  If a longer timeout period is needed,G *  adjust the value of the parameter moved into SET_TIMER_STRING beforeeL *  performing "set_timer".  After the watchdog timer is set, speak a goodbyeH *  message to the caller and then hangup the phone.  The goodbye messageA *  spoken can be changed by modifying the text in "msg_goodbye". n *m% 	MOVE TS6MINUTES TO set_timer_string.  	PERFORM set_timer.e4 	CALL "DTK$HANGUP_PHONE" USING BY REFERENCE voice_id# 				      BY DESCRIPTOR msg_goodbyee 				GIVING return_status.e 	PERFORM cancel_timer.  	IF return_status IS NOT SUCCESS$ 		MOVE return_status TO error_number 		PERFORM error_logm 		STOP RUN.    	MOVE 1 TO timeout.E% 	MOVE TS45SECOND TO set_timer_string.u   *  PERFORM FOREVER.x3 	PERFORM CLEAR_WINK UNTIL ABORT IS EQUAL TO "TRUE".T   exit_end_call.  < * ----------------- clear winks routine -------------------- CLEAR_WINK.Y *_E *  This section of code has been added as a workaround for processing-D *  WINKS at the end of a phone session.  These will be taken care of  *  by the RTL in later releases. *I 	PERFORM set_timer.Q7 	CALL "DTK$READ_KEYSTROKE" USING BY REFERENCE voice_id,  					BY REFERENCE xx,  						     OMITTED,  					BY REFERENCE timeout	 			       GIVING return_status.T 	PERFORM cancel_timer., 	IF return_status IS EQUAL TO DTK$_ONHOOK OR) 	   return_status IS EQUAL TO SS$_TIMEOUTr 		PERFORM set_timera8 		CALL "DTK$READ_KEYSTROKE" USING BY REFERENCE voice_id, 						BY REFERENCE xx, 							     OMITTED, 						BY REFERENCE timeout 				       GIVING return_statusn 		PERFORM cancel_timer! 		IF return_status IS NOT SUCCESSe% 			MOVE return_status TO error_number	 			PERFORM error_log 			STOP RUN  		END-IF 		GO TO exit_end_callK  % 	ELSE IF return_status IS NOT SUCCESSe$ 		MOVE return_status TO error_number 		PERFORM error_log_ 		STOP RUN.     I *  ----------------------------------------------------------------------r SPEAK_ALL_TEXT._ *tF *  Sends the prompt contained in "speak_text_buffer" to the DECtalk toB *  be spoken.  However, before the prompt is sent to the DECtalk, D *  autostop keypad mode is disabled (if it is enabled) so that it isE *  guarenteed that the user hears the entire prompt.  Once the promptF9 *  has been spoken, autostop keypad mode is re-enabled.  N *H- 	IF keypad_mode IS EQUAL TO DTK$K_KEYPAD_AUTOu% 		MOVE TS45SECOND TO set_timer_stringg 		PERFORM set_timerE8 		CALL "DTK$SET_KEYPAD_MODE" USING BY REFERENCE voice_id 							 keypad_one 			      GIVING return_statusi 		PERFORM cancel_timer! 		IF return_status IS NOT SUCCESSG% 			MOVE return_status TO error_numberp 			PERFORM error_log 			STOP RUN. 	PERFORM speak_text.- 	IF keypad_mode IS EQUAL TO DTK$K_KEYPAD_AUTO- *-D *	If autostop keypad mode was enabled (keymode = DTK$K_KEYPAD_AUTO), *	then re-enable it. *w 		PERFORM set_timern8 		CALL "DTK$SET_KEYPAD_MODE" USING BY REFERENCE voice_id 							keypad_mode 			      GIVING return_status  		PERFORM cancel_timer! 		IF return_status IS NOT SUCCESSi% 			MOVE return_status TO error_numberc 			PERFORM error_log 			STOP RUN. 	SET return_status TO SUCCESS.  I *  ----------------------------------------------------------------------n SPEAK_TEXT.a *pI *  Sends the prompt contained in "speak_text_buffer" to the DECtalk to be E *  spoken.  If an error occurs, a warning message is displayed on ther *  console terminal.E *  NOTE: The watchdog timer (set by performing "set_timer") is set to B *	 6 minutes because the longest message in this demo is about 900B *	 characters.  This value should be modified based on the longestD *	 message thats to be spoken.  The timeout should be long enough to; *	 allow ample time to completly finnish speaking all text.C *	$ 	MOVE TS6MINUTES TO set_timer_string 	PERFORM set_timer2 	CALL "DTK$SPEAK_TEXT" USING BY REFERENCE voice_id' 				    BY DESCRIPTOR speak_text_buffer	' 				    BY REFERENCE return_status_mode  			      GIVING return_statusi 	PERFORM cancel_timer.  	IF return_status IS NOT SUCCESS$ 		MOVE return_status TO error_number 		PERFORM error_logM 		STOP RUN.	 	SET return_status TO SUCCESS.  I *  ----------------------------------------------------------------------n
 ERROR_LOG. *lM *  Take the error number, input to SYS$GETMSG to get the system message text.AO *  Format the message text with the specific terminal line for that applicationeK *  "process" (using SYS$FAO), and call SYS$SENOPR with the error structure.r *oG *  NOTE:  the DTK$ errors that occur will have the %DTK- facility name,mA *	  but not the error message text, just the error number.  It is F *	  anticipated that these messages will be included in future VMS/RTL
 *	  releases.- *r/ 	CALL "SYS$GETMSG" USING BY VALUE	error_number,d 				BY REFERENCE	buf_len,s 				BY DESCRIPTOR	error_buf, 				BY VALUE	15, 						OMITTED. *r@ *	Set message target to OPER11, and the message type to RQ_RQST.C *	For more information on sending messages to an operators terminal-! *	see the System Services manual.- *-# 	MOVE 1073741827 TO opc$type_targetN  1 	CALL "SYS$FAO" USING BY DESCRIPTOR	control_str, F 				BY REFERENCE	buf_len,o 				BY DESCRIPTOR	error_text,c 				BY VALUE	buf_len,  				BY REFERENCE	error_buf,s 				BY DESCRIPTOR	on_text, 				BY VALUE	5, & 				BY REFERENCE	terminal_line_string.  1 	CALL "SYS$SNDOPR" USING BY DESCRIPTOR error_msg,n 					      OMITTED 			GIVING ret_stat.E 	IF ret_stat IS NOT SUCCESSO 		STOP RUN. I *  ----------------------------------------------------------------------n
 SET_TIMER. *oI *  Sets the system (watchdog) timer to expire "sec" seconds in the futurebH *  by invoking the "SYS$SETIMR" system service.  SYS$BINTIM is passed a K *  character string in the format "D HH:MM:SS", where D is Days, H is Hours G *  M is minutes etc.  The output of BINTIM is the quadword delta_time ,O. *  which gets passed as input to SYS$SETIMR.   *   8 	CALL "SYS$BINTIM" USING	BY DESCRIPTOR	set_timer_string, 				BY REFERENCE	delta_timer 			GIVING ret_stat.m 	IF ret_stat IS NOT SUCCESSt 		MOVE ret_stat TO error_number  		PERFORM error_log  		STOP RUN.t' 	CALL "SYS$SETIMR" USING 	     OMITTED,i 				BY REFERENCE delta_time, 				BY VALUE     LIB$SIGNAL, 				BY VALUE     SS$_TIMEOUT 			  GIVING ret_stat.  	IF ret_stat IS NOT SUCCESSi 		MOVE ret_stat TO error_numberi 		PERFORM error_logt 		STOP RUN.iI *  ---------------------------------------------------------------------- 
 CANCEL_TIMER.t *r% *  Cancel the system (watchdog) timer  *G  . 	CALL "SYS$CANTIM" USING BY VALUE SS$_TIMEOUT,
 					 OMITTEDO 			  GIVING ret_stat.R 	IF ret_stat IS NOT SUCCESSC 		MOVE ret_stat TO error_numberT 		PERFORM error_logE 		STOP RUN.    END PROGRAM DECTALK-DEMO. 