! 	%TITLE "DECTALK-HEALTH_CARE.BAS"   !  !				HEALTH_CARE.BAS   !  7  !	NOTE:  This program was written with VAX BASIC V3.0.   !=  !  The following file contains a version of the "modifiable" E  !  demonstration program that is included in the DECtalk Application A  !  Development Guide.  This version of the demonstration program C  !  shows how DECtalk can be used in the heath care industry.  The  F  !  demonstration program typifies most telephone application programsI  !  written for DECtalk.  It is written in VAX BASIC and uses Version 4.5 G  !  or later of the VMS/MicroVMS Run-Time Library Support provided for    !  DECtalk.  !C  !	Program description:  In the "MENU" subroutine there is a SELECT =  !		statement where the code determines which of 4 menu items :  !		are chosen.  The menu choices and menu message must be9  !		modified to reflect the menu items being implemented.   !		The menu choices are:   !1  !			A) Health Insurance Eligibility Verification    !			B) Claim Status Information(  !			C) Participating Physician Location#  !			D) DECtalk Product Information   !@  !		All error messages are logged only to the operator terminals>  !		that have specified that the "OPER11" type of message will>  !		be handled. These messages give the error message, and the;  !		terminal line connected to that process.  To have error C  !		messages logged to the console terminal, or any other terminal, :  !		at the DCL prompt ($), enter the REPLY/ENABLE command:  !  !			$ reply/enable=oper11  !A  !		To enter this command, you must have the OPER user privelege.   !    %INCLUDE "DTKDEF"  (  EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 			SS$_NORMAL,   & 			SS$_TIMEOUT  !8  !  EXTERNAL Run-time Library Routines (DECtalk support)  !  EXTERNAL LONG FUNCTION & 0 			DTK$ANSWER_PHONE,	! Wait for phone to ring !&2 			DTK$INITIALIZE, 	! Initialize DECtalk device !&3 			DTK$TERMINATE, 		! End initialized DECtalk use!&  			initialize_dectalk   !  !  Prompts and demo text   !5   COMMON (MESSAGE_TEXT) STRING  msg_access   = 100, &  				msg_invalid  = 40, & 				msg_bad_command   = 40, &  				msg_no_terminator  = 100, &  				msg_timeout  = 50, & 				customer_service = 160, &  				dispatch_desk = 160   N    msg_policyid$ = "Please enter your policy I.D. followed by the pound-key."&, 		+ " You may enter any number as a test."		P    msg_security$ = "Please enter your security code followed by the pound-key."&* 		+ " You may enter any number as a test."6    msg_invalid  = "Invalid entry.  Please try again. "C    msg_timeout  = "No key pressed in the timeout period specified." <    msg_bad_command  = "Invalid command.  Please try again. "J    msg_no_terminator= "Please remember to terminate your entry with the "&% 		+ "pound-key.  Command accepted.  " M   customer_service = "In an actual application, DECtalk would now transfer "& I 	+ "your call to a customer service representative. This demonstration "& ) 	+ "just returns to the selection menu. "   P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &7 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND, & # 					T30SECOND, T5MINUTE, T15MINUTE   I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, & P         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode  1   COMMON (application_specific)	LONG		voice_id, &  						num_hold_keys, & 						num_input_keys, &  					BYTE	hold_key_buf(80) , & 						input_key_buf(80), &( 					STRING	dictionary_file_name = 80, & 						terminal_line   (   COMMON (health_care) LONG			call_count   	MAX_ENTRY = 3
 	T1SECOND = 1 
 	T2SECOND = 2  	T20SECOND = 20  	T30SECOND = 30  	T5MINUTE = 300  	T15MINUTE = 900 	TIME_45_SEC = "0 00:00:45"  	TIME_90_SEC = "0 00:01:30"  	TIME_6_MIN  = "0 00:06:00"  	TIME_16_MIN = "0 00:16:00"  	voice = DTK$K_VOICE_MALE  	speaking_rate = 180 	comma_pause_duration = 0  	period_pause_duration = 0 	speech_on = DTK$K_SPEAK 	new_mode = DTK$M_SQUARE  	keypad_mode = DTK$K_KEYPAD_AUTO 	call_count = 0%  I    msg_welcome$  = "Welcome to Digital's Health-care Voice Information "&  	+ "Demonstration. "    %page  ! main   -  DECLARE LONG	version, init_dtk, need_to_init   init_dtk = 0%  need_to_init = 0% 	!A 	! Get the name of the physical device that the DECtalk module is B 	! connected to and the name of the dictionary file (if specified)A 	! that contains DECtalk's user dictionary words. If the call to  - 	! DTK$INITIALIZE is unsuccessful, then exit.  	!9 	CALL get_cli_params(terminal_line, dictionary_file_name)    	call set_timer(Time_45_sec)9 	stat% = DTK$INITIALIZE(voice_id, terminal_line, version)  	call cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IF     WHILE_LOOP: 	WHILE 1% = 1%			! do always   	num_hold_keys = 0%  	num_input_keys = 0%  9 	 !  Check to see if the DECtalk needs to be initialized. < 	 !  (init_dtk = need_to_init = 0).  If so, reinitialize theC  	 !  application specific parameters.  Then, set a watchdog timer  B 	 !  for 16 minutes in the future in case the DECtalk module fails@ 	 !  and no response to the DTK$ANSWER_PHONE command is received> 	 !  from DECtalk.  ** NOTE:  MAKE SURE THE WATCHDOG TIMER IS : 	 !  ALWAYS SET TO A VALUE LARGER THAN THE TIMEOUT PERIOD C 	 !  SPECIFIED IN THE DTK$ANSWER_PHONE COMMAND.  THE WATCHDOG TIMER / 	 !  CAN BE LARGER THAN 16 MINUTES.  Next, wait B 	 !  for the phone connected to the DECtalk to ring.  If the phone? 	 !  does not ring in "timeout" seconds (or the watchdog timer  B 	 !  times out), normally, the status of the DECtalk unit would beA 	 !  checked.  This is not possible in the current version (V4.5) A 	 !  of the VMS Run-Time Library Support for DECtalk.  Therefore, H 	 !  instead of reinitializing DECtalk every time the unit power cycled,C 	 !  it is reinitialized every time no phone calls are received in  G 	 !  "timeout" seconds. Then, a greeting message is spoken to the user. 
          ! 	IF init_dtk = need_to_init @ 	THEN  stat% = initialize_dectalk		! Reinitialize DECtalk paramS# 		IF (STAT% AND STS$M_SUCCESS) = 0%  		THEN- 			!  Initialization failed.  It appears that 0 			!  the DECtalk module may be dead.  For now,  			!  I will exit.    			GO TO out			! End the program 		END IF9 	    init_dtk = NOT need_to_init			! Appl. init. complete  	END IF ; 	CALL set_timer(time_16_min)		! Set system (watchdog) timer  	!G 	! The greeting message DECtalk speaks upon answering the telephone can ; 	! be modified by changing the text in the character string A 	! "msg_welcome". The number of rings DECtalk waits to answer the F 	! telephone ("number_of_rings"), can be changed but it is recommended7 	! that the phone is always answered on the first ring.  	!K         stat% = DTK$ANSWER_PHONE(voice_id, number_of_rings, msg_welcome$, &  								T15MINUTE) 	CALL cancel_timer 	IF (stat% = SS$_NORMAL) 	THEN  		! ' 		!  The telephone has been answered.    		! A 		!  NOTE: DTK$ANSWER_PHONE automatically enables autostop keypad 6 		!	 mode, and wink detection on the telephone keypad. 		!  		CALL menu  		CALL end_call 9 	ELSE IF (stat% = SS$_TIMEOUT)			! Timeout period expired 
 	     THEN2 		init_dtk = need_to_init			! Have to reinitialize
 	     ELSE 		CALL error_log(stat%) 6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	     END IF 	END IF      NEXT    out:A     !  some fatal error has occured... Terminate DECtalk and exit      !      CALL set_timer(Time_45_sec) C     stat% = DTK$TERMINATE(VOICE_ID)     ! End use of DECtalk device      CALL cancel_timer %     IF (stat% AND STS$M_SUCCESS) = 0%      THEN 		CALL error_log(stat%) 
     END IF     END  N  !********************* END OF PROGRAM ***************************************  !C  ! Gets the parameters from the command line using LIB$GET_FOREIGN. C  ! If a fatal error occurs, it is reported and the demo is stopped. K  ! Otherwise, the parameters specified are returned in terminal_line_string P  ! for the device name, and dictionary_name for the name of the dictionary file.  !A  SUB  get_cli_params (STRING device_name, STRING dictionary_name)	  % 	EXTERNAL LONG CONSTANT STS$M_SUCCESSp' 	EXTERNAL LONG FUNCTION LIB$GET_FOREIGN    	DECLARE STRING get_param_bufn0 	DECLARE LONG device_length, diction_name_length  * 	stat% = LIB$GET_FOREIGN(get_param_buf,,,)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENi 		CALL error_log(stat%)r6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IFt+ 	device_length = POS(get_param_buf, " ", 1)s) 	diction_name_length = LEN(get_param_buf)r   	IF device_length = 0% 	THEN : 		device_name = SEG$(get_param_buf,1, diction_name_length) 	ELSES9 		device_name = SEG$(get_param_buf, 1, device_length - 1) 9 		dictionary_name = SEG$(get_param_buf, device_length+1,&a 						 diction_name_length)  	END IFd	   END SUBh    K  !************************************************************************* ?  !  Initializes the application specific parameters of DECtalk.hD  !  First, left square bracket ('[') and right square bracket (']') M  !  are enabled as phonemic delimiters. To specify other modes, the bit masksiM  !  for the modes to be set should be OR'd together with the DTK$M_SQUARE bit M  !  mask and assigned to the varible "NEW_MODE".  Next, the default speaking oH  !  voice and speaking rate are selected for the application.  The commaE  !  pause and period pause are set to DECtalk defaults.  Other voices	I  !  can selected for the default speaking voice by modifying the variableeB  !  "voice".  Likewise, a different speaking rate can be specifiedG  !  by changing the static variable "speaking_rate".  Finally, the userpF  !  dictionary is loaded (by invoking "load_dictionary").  Note, otherF  !  application specific parameters should also be initialized in this"  !  subroutine if the need arises.  !  #  FUNCTION LONG initialize_dectalk()E  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS(   EXTERNAL LONG FUNCTION	DTK$SET_MODE, & 				DTK$SET_VOICE, & 				load_dictionary   M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minM  I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &	- 		 period_pause_duration, speech_on, new_modea  -   COMMON (application_specific)	LONG	voice_idt   	CALL set_timer(Time_45_sec)+ 	stat% = DTK$SET_MODE(voice_id, new_mode, )e 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%) 6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IFl 	!A 	!  Indicate the type of voice and the speaking rate for DECtalk.  	CALL set_timer(Time_45_sec)7 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate & 1 				,comma_pause_duration, period_pause_duration)a 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENt 		CALL error_log(stat%)e6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IF. 	!8 	! load user dictionary using "load_dictionary" function 	!% 	initialize_dectalk = load_dictionaryc 	EXIT FUNCTION
  END FUNCTION   K  !  -----------------------------------------------------------------------(O  !  Gets a series of touch tone keys entered on the telephone keypad terminatedNM  !  by a pound sign (#) or an asterisk (*).  Returns SUCCESS if the series ofNO  !  touch tone keys was received successfully.  Otherwise, FAILURE is returned.   N  FUNCTION LONG get_key_string(STRING prompt,LONG timeout,LONG terminator_code)    %INCLUDE "DTKDEF"  +   EXTERNAL LONG FUNCTION	DTK$READ_KEYSTROKEd'   EXTERNAL LONG CONSTANT	SS$_TIMEOUT, &B 				SS$_NORMAL, &)
 				DTK$_WINKu  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &) 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND   1    COMMON (application_specific)	LONG	voice_id, &E 						num_hold_keys, & 						num_input_keys, &T 					BYTE	hold_key_buf(80), &" 						input_key_buf(80)C  C   DECLARE LONG  read_key_buf, hold_buf_ptr, ad_timeout, loc_timeout:   	loc_timeout = timeout   	IF num_hold_keys > 0% 	THENm 	!E 	!  There are Touch Tone keys in the typeahead buffer (hold_key_buf).KB 	!  The routine "read_advance_keys" is called here to read any newA 	!  keys pressed.  This is used mainly to read and process winks.VF 	!  The "keys" stored in the typeahead buffer are moved into the input? 	!  buffer "input_key_buf" up to any terminator character.  TheoH 	!  terminator character is put in "terminator_value", and any remainingG 	!  characters left in the typeahead buffer are copied to the front of e 	!  the buffer.i 	! 		ad_timeout = 1%o 		GOSUB read_advance_keys " 		hold_key_buf(num_hold_keys) = 0% 		hold_buf_ptr = 0%LA 		WHILE hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_NUMBER_SIGN AND &_8 		      hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_ASTERISK  % 			IF hold_key_buf(hold_buf_ptr) = 0%  			THEN% 				num_hold_keys = 0% 				GO TO read_key	 			END IF%% 				input_key_buf(num_input_keys) = &a 					hold_key_buf(hold_buf_ptr)W  ' 			num_input_keys = num_input_keys + 1% # 			hold_buf_ptr = hold_buf_ptr + 1%  		NEXT. 		terminator_code = hold_key_buf(hold_buf_ptr)" 		hold_buf_ptr = hold_buf_ptr + 1% 		num_hold_keys = 0% 		!a9 		!  Recopy the remaining keys in the typeahead buffer to A 		!  the beginning of the buffer.  If the terminating keycode wasEA 		!  a "#" or "*", skip over it and start recopying with the nextm
 		!  keycode.d 	 ' 		UNTIL hold_key_buf(hold_buf_ptr) = 0% 9 			hold_key_buf(num_hold_keys)=hold_key_buf(hold_buf_ptr)T% 			num_hold_keys = num_hold_keys + 1%H% 			hold_buf_ptr  = hold_buf_ptr  + 1%O 		NEXT 		GO TO process_entryA 	END IFT 	IF LEN(prompt) > 1% 	THENeB 	!  this test assumes that no 1 character prompts will be sent to 9 	!  dectalk.  Prompts of 1 char will be passed over here.t 	!% 		CALL speak_text(DTK$K_WAIT, prompt)a 	END IFo
  read_key: 	WHILE 1% = 1% 		!t? 		!  Read all keys entered on the touch tone keypad by the usereA 		!  and store them in the typeahead buffer "hold_key_buf". Firsta> 		!  a watchdog timer must be set before any keys can be read.	          e 		CALL set_timer(Time_45_sec)cC 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , loc_timeout)n 		CALL cancel_timer  		IF stat% = SS$_NORMAL_ 		THEN0 			IF (read_key_buf = DTK$K_TRM_NUMBER_SIGN OR &) 			    read_key_buf = DTK$K_TRM_ASTERISK)C 			THEN  				!N+ 				!  Received key string terminator ("#")a2 				!  so reception of keystring is completed. Use1 				!  a short timeout to gather up any remainingo+ 				!  touch tone keys entered by the user.n  " 				terminator_code = read_key_buf 				ad_timeout = 2%e 				GOSUB read_advance_keysd 				GO TO process_entrye 			ELSEs0 				input_key_buf(num_input_keys) = read_key_buf( 				num_input_keys = num_input_keys + 1% 				loc_timeout = 10% 	 			END IFc 		ELSE	IF stat% = SS$_TIMEOUTl 			THENo 				EXIT read_keyl 			ELSE	IF stat% = DTK$_WINK 				THEN 				!i. 				!  DECtalk detected a wink which sometimes0 				!  indicates that the user has hungup.  This0 				!  demonstration program assumes that a WINK, 				!  does indicate the a user has hungup. 2 				!  Therefore, return so DECtalk can hangup its3 				!  phone.  If for any reason it is noticed thatK3 				!  spontaneous winks are occurring and the user 0 				!  at the other end of the telephone did not0 				!  hangup, then DO NOT return. Just continue! 				!  receiving touch tone keys.t   				    CALL error_log(stat%)n 				    get_key_string = 0%e  				    EXIT FUNCTION 				ELSE 				    CALL error_log(stat%)B% 				    CALL LIB$STOP(stat% BY VALUE) 
 				END IF	 			END IFD 		END IF 	NEXT 	         ! N         !  No keystring terminator ("#" or "*") entered so set the terminatingJ         !  keycode to DTK$K_TRM_TIMEOUT.  Otherwise, return all touch toneF 	!  keys entered. Finally, recopy any remaining touch tone keys in the= 	!  typeahead buffer (ttkeys) to the beginning of the buffer. 	          *$ 	terminator_code = DTK$K_TRM_TIMEOUT    PROCESS_ENTRY:*! 	hold_key_buf(num_hold_keys) = 0%a
 	CALL restarth 	get_key_string = 1% 	EXIT FUNCTION    READ_ADVANCE_KEYS:c 	!G 	!  Read any keys from DECtalk into the typeahead buffer "hold_key_buf"s 	!
 	WHILE 1=1 		CALL set_timer(Time_45_sec) B 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , ad_timeout) 		CALL cancel_timerB 		IF stat% = SS$_NORMALd 		THEN- 			hold_key_buf(num_hold_keys) = read_key_bufC% 			num_hold_keys = num_hold_keys + 1%F 		ELSE	IF stat% = SS$_TIMEOUTC# 			THEN				! no key pressed: returnL
 				RETURN 			ELSE	IF stat% = DTK$_WINK 				THEN			! Hung up?  exitp 					CALL error_log(stat%) 					get_key_string = 0%  					EXIT FUNCTIONs 				ELSE 					CALL error_log(stat%)" 					CALL LIB$STOP(stat% BY VALUE)
 				END IF	 			END IFt 		END IF 	NEXT1  
  END FUNCTION_    M  !***************************************************************************eL  ! Verifies the access code received from the customer.  This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realP  ! application, the code would be verified against access codes in the database.    FUNCTION LONG access_verify ()n   	access_verify = 1%T 	EXIT FUNCTION  
  END FUNCTIONo  M  !***************************************************************************NH  ! Verifies the password received from the customer. This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realL  ! application, the password would be verified against their password in the  ! database.  !  FUNCTION LONG password_verify ()    	password_verify = 1%h 	EXIT FUNCTION
  END FUNCTION!  M  !***************************************************************************nG  !  Prompts the user for a command and receives the command (touch tonefJ  !  key) from the user.  Note, the command will be accepted whether or notE  !  it is terminated with the pound key "#".  However, if the command G  !  is not followed by the pound key, the command will not be processedaO  !  until the timeout period has expired and a warning message has been spoken.cM  !  When commands are received, the routine "process_menu_entry" is performed !  !  to implement the menu choice.a  !  SUB menu()e    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT STS$M_SUCCESS*   EXTERNAL LONG FUNCTION	get_key_string, & 				insurance_verification, &e 				claim_status, &n 				physician_location, &k 				DTK$SET_VOICE,  5   COMMON (MESSAGE_TEXT) STRING  msg_access   = 100, &i 				msg_invalid  = 40, & 				msg_bad_command   = 40, &t 				msg_no_terminator  = 100, &  				msg_timeout  = 50, & 				customer_service = 160  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &4 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND  I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &  				 period_pause_duration  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &  					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80)  J   main_menu$	= "For health insurance eligibility verification, press 1, "&I 	+ "followed by the pound-key.  For claim status information, press 2, "& > 	+ "followed by the pound-key.  For participating physician "&G 	+ "[lowk'eyshaxnz] press 3, followed by the pound-key.  For DECtalk "&dC 	+ "product information, press 4, followed by the pound-key.  To "&%I 	+ "repeat this message, press 0, followed by the pound-key.  To exit, "&o 	+ "press the star key.  "  L   dtcfamily$	= "[+] The [`]DECtalk [`]Voice Response-System is the latest "&I 	+ "addition to Digital's Voice solutions. It features the performance "& D 	+ "of the MicroVAX 2, plus the flexibility of the foremost voice "&F 	+ "synthesis product on the market today.  The [`]DECtalk [`]Voice "&F 	+ "Response-System is sized to support from 2 to 32 DEctalk lines. "&H 	+ "It is ideally suited to front end large data-bases. Packaged with "&I 	+ "the [`]DECtalk [`]Voice Response-System is the DECtalk Application "& E 	+ "Development-Guide.  This guide consists of a user's manual and "&sC 	+ "sample application-software. It is designed to significantly "&pG 	+ "reduce the time required to develop a voice response application "&LI 	+ "for any of the DEctalk products. DECtalk component products include"& H 	+ " Dual-Line DECtalk, a two-line subsystem, and Multi-line DECtalk, "&D 	+ "an eight-line subsystem, both of which are rack mountable. In "&F 	+ "addition, the DECtalk board can be used to expand the number of "&H 	+ "lines needed.  [+] Single line DECtalk is a table-top unit with a "&> 	+ "built-in loud-speaker. It is best for [st'aend#axl`own] "&I 	+ "applications, such as aids for the handicapped. It is also commonly"& I 	+ " used in manufacturing, for [m'aonaxtaxrixnx] status on the factory"&eH 	+ " floor. [+] All DECtalk products appropriately pronounce commonly "&E 	+ "occurring forms, such as numbers, money, abbreviations, dates, "&d& 	+ "times, and [paxnxkchuw'eyshaxn]. "     4   DECLARE	LONG	terminator_value, illegal_entry_count  	null_char$ = X'00'Ca 	terminator_value = 0% 	illegal_entry_count = 0%a  $ 	WHILE (input_key_buf(0) <> 0% OR  &* 				terminator_value <> DTK$K_TRM_TIMEOUT) 	!> 	! Keep getting commands from the user until the exit key "*",A 	! is entered, a wink is detected, or the timeout period expires.lG 	! First, check if there are any keys in the typeahead buffer (done by  D 	! "get_key_string" with a 1 second timeout).  If so, process them. F 	! Otherwise, prompt the user for a command and wait for his response. 	!  GET_SHORT_READ: 	num_input_keys = 0% 	input_key_buf(0) = 0%F         stat% = get_key_string(null_char$, T1SECOND, terminator_value)  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENt
 		EXIT SUB 	END IF ) 	IF terminator_value = DTK$K_TRM_ASTERISKh 	THEN_
 		EXIT SUB3 	ELSE	IF (terminator_value = DTK$K_TRM_NUMBER_SIGN)	 		THEN: 			GOSUB process_menu_entry	! Valid command so process it	) 			IF (input_key_buf(0) = DTK$K_TRM_ZERO)n 			THENc 				GO TO get_long_read* 			ELSEv 				GO TO get_short_read	 			END IFx7 		ELSE IF ((terminator_value <> DTK$K_TRM_TIMEOUT) OR	&)6 	        	 (terminator_value = DTK$K_TRM_TIMEOUT AND	& 				input_key_buf(0) = 0%))= 			!: 			!  No keys in typeahead buffer so prompt for a command. 			! 		     THEN_+ 				CALL speak_text(DTK$K_WAIT, main_menu$)e
 		     END IF  	         END IF 	     END IF 	!A 	!  Any new keys received should be processed after the keys readeB 	!  from the typeahead buffer.  Start storing touch tone keys intoF 	!  into the buffer following the keys read from the typeahead buffer. 	!  GET_LONG_READ:e 	num_input_keys = 0%G         stat% = get_key_string(null_char$, T20SECOND, terminator_value)t  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN 
 		EXIT SUB 	END IFT) 	IF terminator_value = DTK$K_TRM_ASTERISKv 	THEN,
 		EXIT SUB4 	ELSE	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) <> 0%)r 		THEN) 			CALL speak_all_text(msg_no_terminator)a: 			GOSUB process_menu_entry	! Valid command so process it	  6 		ELSE 	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) = 0%) 			THEN $ 				CALL speak_all_text(msg_timeout) 				EXIT SUB 			ELSEn 				GOSUB  process_menu_entry 	 			END IFt 		END IF 	END IFb    NEXTd	 	EXIT SUB2  PROCESS_MENU_ENTRY:  !?  !  Processes the touch tone key string received from the user._  ! 	IF num_input_keys > 1%	 	THENn 	!< 	!  Only single key commands are valid in this menu.  Inform< 	!  the user that an invalid command was entered and return. 	!& 		CALL speak_all_text(msg_bad_command)0 		illegal_entry_count = illegal_entry_count + 1% 	ELSE	 	    SELECT	input_key_buf(0)0 		CASE = 	DTK$K_TRM_ZERO			! Speak menu help msg* 			CALL speak_text(DTK$K_WAIT, main_menu$) 			illegal_entry_count = 0%e  2 		CASE = 	DTK$K_TRM_ONE			! insurance verification" 			stat% =  insurance_verification$ 			if (stat% AND STS$M_SUCCESS) = 0% 			THENt 				EXIT SUB	 			END IFt 			illegal_entry_count = 0%n  ( 		CASE = 	DTK$K_TRM_TWO			! claim status 			stat% = claim_statusg$ 			if (stat% AND STS$M_SUCCESS) = 0% 			THENa 				EXIT SUB	 			END IFi 			illegal_entry_count = 0%I  2 		CASE = 	DTK$K_TRM_THREE			! doctor location demo 			stat% = physician_location $ 			if (stat% AND STS$M_SUCCESS) = 0% 			THEN  				EXIT SUB	 			END IFr 			illegal_entry_count = 0%n  1 		CASE = 	DTK$K_TRM_FOUR			! dectalk product infoT* 			CALL speak_text(DTK$K_WAIT, dtcfamily$) 			illegal_entry_count = 0%a   		CASE ELSE + 			CALL speak_text(DTK$K_WAIT, msg_invalid)a1 			illegal_entry_count = illegal_entry_count + 1%  	   END SELECT 	END IFo 	num_input_keys = 0% 	!B 	! If user enters 3 illegal/incorrect commands, speak help message 	! 	IF illegal_entry_count >= 3 	THEN ) 		CALL speak_text(DTK$K_WAIT, main_menu$)  		illegal_entry_count = 0% 	END IFr 	RETURNy    END SUB  M  !***************************************************************************,G  !  Load the user dictionary with the words and phonemic pronunciations*G  !  stored in the sequential file specified in the foreign command linetI  !  invoking the program.  Each line of this file contains the word to benG  !  defined in the user dictionary followed by a space, followed by theaI  !  phonemic pronunciation of the word.  The entry is parsed to find the _N  !  start and finnish of the word and it's replacement.  The word and phonemicM  !  pronunciation are loaded into the user dictionary. If the load dictionaryiN  !  command fails, the user is notified and processing is terminated.  ReturnsM  !  SUCCESS if the dictionary is loaded successfully or if no user dictionaryd<  !  file name is specified.  Otherwise, FAILURE is returned.     FUNCTION LONG load_dictionary()    %INCLUDE "DTKDEF"  ,   EXTERNAL LONG FUNCTION	DTK$LOAD_DICTIONARY&   EXTERNAL LONG CONSTANT	SS$_NORMAL, & 				DTK$_TOOLONG, DTK$_NOROOM @   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &i 					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80), &e$ 				STRING	dictionary_file_name = 80  / 	MAP (dictionary) STRING dictionary_entry = 256e( 	DECLARE STRING		diction_word,  phonetic% 	DECLARE LONG		word_count, phonem_endh  
 	sp$ = X'20'Cs 	tab$ = X'09'C  	null_char$ = X'00'Ce 	ON ERROR GOTO ERROR_CHECKG 	IF LEFT$(dictionary_file_name,1) = null_char$	! No dictionary filenameE 	THENX6 	  !  No dictionary was specified in the command line.# 	  !  Return to initialize_dectalk   		load_dictionary = 1% 		exit functionO 	END IF   A 	OPEN dictionary_file_name AS FILE #1,	ORGANIZATION SEQUENTIAL, & ! 						ACCESS READ, MAP DICTIONARY0 	!E 	! Since there is no timeout associated with the DTK$LOAD_DICTIONARY mC 	! command, it is possible for an application to hang waiting for asF 	! response after issuing the DTK$LOAD_DICTIONARY command.  Therefore,G 	! arm a watchdog timer (6 minutes in this case) to time the loading ofaG 	! the entire user dictionary.  If all the entries are not loaded into cA 	! the user dictionary before the timer expires, then assume that,7 	! something is wrong with the DECtalk module and exit.  	!: 	CALL set_timer(time_6_min)		! Set system (watchdog) timer        WHILE 1% = 1% 	GET #1h 	! n3 	!  Read in all of the words and substitutions from+8 	!  the sequential file specified in the command string. 	!+ 	word_count = POS(dictionary_entry, sp$, 1)p 	IF word_count = 0%k2 	THEN		word_count = POS(dictionary_entry, tab$, 1) 	END IF-2 	phonem_end = POS(dictionary_entry, null_char$, 1)  7 	diction_word =	SEG$(dictionary_entry, 1, word_count-1)y> 	phonetic =	SEG$(dictionary_entry, word_count+1, phonem_end-1)  > 	stat% = DTK$LOAD_DICTIONARY(voice_id, DICTION_WORD, phonetic)1 	IF (stat% = DTK$_TOOLONG OR stat% = DTK$_NOROOM)  	THEN  	     !b9 	     !  These are not generally fatal errors.  However, e: 	     !  they will be treated as such.  In creating a demo9 	     !  program, if words cannot be loaded into the user"> 	     !  dictionary, the programmer should be notified so that@ 	     !  the appropriate action can be taken.  By treating these? 	     !  errors as fatal, the programmer will at least know theu7 	     !  point in the program where the error occurred.  	     !e
 		CLOSE #1 		CALL error_log(stat%)e 		load_dictionary = 0%' 		EXIT FUNCTION			! Fatal error so exito/ 	ELSE IF (stat% <> SS$_NORMAL) 	! Fatal failurep
 	     THEN- 			CALL cancel_timer		! Cancel watchdog timery 			CLOSE #1t 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	     END IF 	END IFh	      NEXTo  	!a7 	!  Entire dictionary is loaded so cancel system timer.[ 	!  DONE:4 	CALL cancel_timer			! Cancel system(watchdog) timer$ 	CLOSE #1				! Close dictionary file 	load_dictionary = 1%c  EXIT FUNCTION  
  ERROR_CHECK:i( 	IF ERR = 11%		! IF End of File is found 	THENf
 		RESUME DONEm 	ELSEa 	   CALL error_log(VMSSTATUS)e 	   RESUME HERE  HERE:t 	   load_dictionary = 0% 	   EXIT FUNCTION  	END IFc
  END FUNCTIONs  M  !***************************************************************************aH  !  DECtalk stopped speaking because it was in autostop keypad mode whenG  !  it received a Touch Tone Key from the user.  First, send DECtalk a WK  !  right square bracket "]" just in case speech was stopped while speaking)M  !  phonemic text. Then, restart speech (using DTK$SET_SPEECH_MODE) and resete6  !  the speaking voice and rate (using DTK$SET_VOICE).  !  SUB restart()    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS/   EXTERNAL LONG FUNCTION	DTK$SET_SPEECH_MODE, &c 				DTK$SET_VOICEr  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minAI   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &t# 		 period_pause_duration, speech_on_-   COMMON (application_specific)	LONG	voice_idT      rsbracket$    = "]"  6   DECLARE LONG old_mode				! Current mode before reset  ) 	CALL speak_text( DTK$K_WAIT, rsbracket$)M 	! 	!  Set speakig on 	! 	CALL set_timer(Time_45_sec); 	stat% = DTK$SET_SPEECH_MODE(voice_id, speech_on, old_mode)_ 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%)x5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit	 	END IF  	!% 	!  Reset the voice and speaking rateA 	CALL set_timer(Time_45_sec)8 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate, &0 				comma_pause_duration, period_pause_duration) 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exita 	END IFr    END SUB  M  !***************************************************************************hE  !  End the current user session.  Since the DTK$HANGUP_PHONE commandtC  !  does not set a timeout, and it requests DECtalk to send a phonemG  !  status, a watchdog timer is set to insure that the application does G  !  not hang (if DECtalk fails).  If a longer timeout period is needed, H  !  adjust the value of the parameter moved into SET_TIMER_STRING beforeM  !  performing "set_timer".  After the watchdog timer is set, speak a goodbyemI  !  message to the caller and then hangup the phone.  The goodbye messageDB  !  spoken can be changed by modifying the text in "msg_goodbye".   !  SUB end_call ()  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &p 				SS$_TIMEOUT, & 				DTK$_ONHOOK   -   EXTERNAL LONG FUNCTION 	DTK$HANGUP_PHONE, &_ 				DTK$READ_KEYSTROKE, &h 				DTK$SPEAK_TEXT  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_mins-   COMMON (application_specific)	LONG	voice_ido  G   msg_goodbye$  = "Thank you for calling Digital's Health-care Voice "&LD 	+ "Information Demonstration.  For more information, please call "& 	+ "1, 800, 8 3 2, 6 2 7 7.  "  : 	CALL set_timer(time_6_min)		! Set system (watchdog) timer 	!$ 	!  Say goodbye and hangup the phone 	!1 	stat% = DTK$HANGUP_PHONE(voice_id, msg_goodbye$)$* 	CALL cancel_timer			! Cancel system timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENA 		CALL error_log(stat%)	5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitt 	END IF  	!B 	! Get rid of any winks that may have been generated by the caller? 	! hanging up in the middle of the goodbye message.  This worksI( 	! around clears the internal WINK flag. 	!         timeout% = 1%t 	WHILE 1% = 1%  	    CALL set_timer(Time_45_sec): 	    stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%) 	    CALL cancel_timer4 	    IF (stat% = DTK$_ONHOOK OR stat% = SS$_TIMEOUT)	 	    THENt 		!T/ 	  	!  Clear remaining winks that may have beeni3 		!  detected before DECtalk hung up the telephone.a 		!t$ 	        CALL set_timer(Time_45_sec)> 	        stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%) 	        CALL cancel_timer# 		IF (stat% AND STS$M_SUCCESS) = 0%c
 	        THENa 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	        END IF  	        EXIT SUBo+ 	    ELSE IF (stat% AND STS$M_SUCCESS) = 0%! 	         THEN 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	         END IF 	    END IFn 	NEXTo  END SUB  J  !  ----------------------------------------------------------------------J  !  Speak all text -- disable autostop keypad, speak text in prompt using :  !  "speak_text". If autostop was set, re-enable autostop.  !#  SUB speak_all_text (STRING prompt)o    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS,   EXTERNAL LONG FUNCTION	DTK$SET_KEYPAD_MODE  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minoI   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &-P         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode-   COMMON (application_specific)	LONG	voice_idp     DECLARE LONG	keypad_on     keypad_on = DTK$K_KEYPAD_ONe 	!F 	!  If autostop keypad mode is enabled (keymode = DTK$K_KEYPAD_AUTO), 1 	!  then enable the keypad without autostop mode.L 	!C 	IF (keypad_mode = DTK$K_KEYPAD_AUTO)	! Keypad is in autostop mode	_ 	THENm7 		CALL set_timer(Time_45_sec)	! Set the watchdog timer	)2 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_on)1 		CALL cancel_timer		! Cancel the watchdog timer	s# 		IF (stat% AND STS$M_SUCCESS) = 0%c 		THEN 			CALL error_log(stat%)  			CALL LIB$STOP(stat% BY VALUE) 		END IF 	END IFG  ( 	!  Send text to DECtalk to be spoken.  = 	!  Specify the mode as DTK$K_WAIT so that text is completelyO< 	!  spoken before the keypad is re-enabled in autostop mode.  $ 	CALL speak_text(DTK$K_WAIT, prompt)  ' 	!  If autostop keypad mode was enabledp9 	!  (keypad_mode = DTK$K_KEYPAD_AUTO), then re-enable it.i 	!D 	IF (keypad_mode = DTK$K_KEYPAD_AUTO) ! Keypad was in autostop mode	 	THENG4 		CALL set_timer(Time_45_sec)	! Set watchdog timer		4 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_mode)1 		CALL cancel_timer		! Cancel the watchdog timer	h# 		IF (stat% AND STS$M_SUCCESS) = 0%	 		THEN 			CALL error_log(stat%)  			CALL LIB$STOP(stat% BY VALUE) 		END IF 	END IFu  END SUB  M  !***************************************************************************d.  !  Sends the prompt (specified by prompt) to 1  !  the DECtalk to be spoken.  Returns SUCCESS if >  !  everything is spoken o.k.  Otherwise, FAILURE is returned.  !  7  !  NOTE:  If DTK$SPEAK_TEXT is called with mode set too8  !	   DTK$K_WAIT or DTK$K_STATUS, a phone status requestA  !	   is sent from DECtalk.  Since there is no timeout associatedr>  !	   with this request, a system timer should be set (to someG  !	   exteremely long value (16 minutes) to insure that the applicationo  !	   does not hang.  !8  SUB speak_text (LONG return_status_mode, STRING prompt)    %INCLUDE "DTKDEF"  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &m 				SS$_NORMAL'   EXTERNAL LONG FUNCTION	DTK$SPEAK_TEXTC  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minG  -   COMMON (application_specific)	LONG	voice_idb 	! 	!  Speak the text: 	CALL set_timer(time_16_min)	! Set system (watchdog) timer= 	stat% = DTK$SPEAK_TEXT(voice_id, prompt, return_status_mode) ) 	CALL cancel_timer		! Cancel system timera 	IF (stat% <> SS$_NORMAL)n 	THEN( 		CALL error_log(stat%)a5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitd 	END IFy  END SUB  I  ! **********************************************************************I/  !	Log error to the operator console  "OPER11".s  !N  !  Take the error number, input to SYS$GETMSG to get the system message text.P  !  Format the message text with the specific terminal line for that applicationL  !  "process" (using SYS$FAO), and call SYS$SENOPR with the error structure.  !H  !  NOTE:  the DTK$ errors that occur will have the %DTK- facility name,B  !	  but not the error message text, just the error number.  It isG  !	  anticipated that these messages will be included in future VMS/RTLr  !	  releases.  !!  SUB error_log(LONG error_number)   B  %INCLUDE "$OPCDEF" %FROM %LIBRARY "SYS$LIBRARY:BASIC$STARLET.TLB"  #   EXTERNAL LONG CONSTANT	SS$_NORMAL>#   EXTERNAL LONG FUNCTION	SYS$FAO, &  				SYS$SNDOPR, &l 				SYS$GETMSG  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &s 					num_input_keys, & 				BYTE	hold_key_buf(80) , &D 					input_key_buf(80), & ' 				STRING	dictionary_file_name = 80, &t 					terminal_line  B   MAP	(error_struct) LONG opc$type_target, LONG OPC$L_MS_RQSTID, & 			STRING error_text = 120+   MAP	(error_struct) STRING error_msg = 128R%   MAP   (temp)  STRING error_buf = 80l  +   DECLARE STRING CONSTANT filler = "  ON  " 3   DECLARE STRING CONSTANT control_str = "!AD!AS!AD"    DECLARE LONG buf_len  Q      temp% = SYS$GETMSG(error_number by value, buf_len, error_buf, 15% by value,)*  !A  ! Set message target to OPER11, and the message type to RQ_RQST.gD  ! For more information on sending messages to an operators terminal"  ! see the System Services manual.  !>     opc$type_target = (OPC$M_NM_OPER11 * 256%) OR OPC$_RQ_RQST  6  	temp% = SYS$FAO(control_str, buf_len, error_text,		&*  				buf_len by value, error_buf by ref,	&/  				filler, 5% by value, terminal_line by ref)V2  	WHILE MID$(error_text, buf_len + 1, 1) <> X"00"C,  		MID$(error_text, buf_len + 1, 1) = X"00"C  		buf_len = buf_len + 1  	NEXT,  	stat% = SYS$SNDOPR(error_msg, 0% by value)3   	IF (stat% <> SS$_NORMAL)		! Send to oper failed	i  	THEN5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exito	  	END IF u  END SUB  M  !***************************************************************************eJ  !  Sets the system (watchdog) timer to expire "sec" seconds in the futureI  !  by invoking the "SYS$SETIMR" system service.  SYS$BINTIM is passed a aL  !  character string in the format "D HH:MM:SS", where D is Days, H is HoursH  !  M is minutes etc.  The output of BINTIM is the quadword delta_time ,/  !  which gets passed as input to SYS$SETIMR.  L  !"  SUB set_timer(STRING time_string)  ( 	EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 				SS$_TIMEOUT % 	EXTERNAL LONG FUNCTION	SYS$SETIMR, &D 				SYS$BINTIM: 	EXTERNAL LONG		LIB$SIGNAL 	! Indicate exception condition% 	MAP (quadword) LONG delta_time, FILLr  , 	stat% = SYS$BINTIM(time_string, delta_time)# 	IF (stat% AND STS$M_SUCCESS)  = 0%O 	THEN  		CALL error_log(stat%)o5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit* 	END IF*  K 	stat%= SYS$SETIMR( ,delta_time, LIB$SIGNAL BY VALUE, SS$_TIMEOUT BY VALUE) # 	IF (stat% AND STS$M_SUCCESS)  = 0%  	THENs 		CALL error_log(stat%)t5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitd 	END IFi  END SUB  J  !  ----------------------------------------------------------------------$  !  Cancel the system watchdog timer  !  SUB cancel_timer()e  %  EXTERNAL LONG CONSTANT	STS$M_SUCCESS!?  EXTERNAL LONG FUNCTION	SYS$CANTIM		! Cancel SYS$SETIMR request   6 	stat% = SYS$CANTIM(SS$_TIMEOUT BY VALUE, 0% BY VALUE)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENn 		CALL error_log(stat%)t5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitX 	END IFN  END SUB