$ 	%TITLE "DECTALK-DEMO_INSURANCE.BAS"  !  !				DEMO_INSURANCE.BAS  !  7  !	NOTE:  This program was written with VAX BASIC V3.0.   !=  !  The following file contains a version of the "modifiable" E  !  demonstration program that is included in the DECtalk Application A  !  Development Guide.  This version of the demonstration program B  !  shows how DECtalk can be used in the insurance industry.  The F  !  demonstration program typifies most telephone application programsI  !  written for DECtalk.  It is written in VAX BASIC and uses Version 4.5 G  !  or later of the VMS/MicroVMS Run-Time Library Support provided for    !  DECtalk.  !C  !	Program description:  In the "MENU" subroutine there is a SELECT =  !		statement where the code determines which of 5 menu items :  !		are chosen.  The menu choices and menu message must be9  !		modified to reflect the menu items being implemented.   !		The menu choices are:   !$  !			A) Insurance Policy Information(  !			B) Participating Physician Location1  !			C) Health Insurance Eligibility Verification   !			D) Auto Insurance Claims #  !			E) DECtalk Product Information   !@  !		All error messages are logged only to the operator terminals>  !		that have specified that the "OPER11" type of message will>  !		be handled. These messages give the error message, and the;  !		terminal line connected to that process.  To have error C  !		messages logged to the console terminal, or any other terminal, :  !		at the DCL prompt ($), enter the REPLY/ENABLE command:  !  !			$ reply/enable=oper11  !A  !		To enter this command, you must have the OPER user privelege.   !    %INCLUDE "DTKDEF"  (  EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 			SS$_NORMAL,   & 			SS$_TIMEOUT  !8  !  EXTERNAL Run-time Library Routines (DECtalk support)  !  EXTERNAL LONG FUNCTION & 0 			DTK$ANSWER_PHONE,	! Wait for phone to ring !&2 			DTK$INITIALIZE, 	! Initialize DECtalk device !&3 			DTK$TERMINATE, 		! End initialized DECtalk use!&  			initialize_dectalk   !  !  Prompts and demo text   !5   COMMON (MESSAGE_TEXT) STRING  msg_access   = 100, &  				msg_invalid  = 40, & 				msg_bad_command   = 40, &  				msg_no_terminator  = 100, &  				msg_timeout  = 50, & 				customer_service = 160, &  				dispatch_desk = 160   N    msg_policyid$ = "Please enter your policy I.D. followed by the pound-key."&, 		+ " You may enter any number as a test."		P    msg_security$ = "Please enter your security code followed by the pound-key."&* 		+ " You may enter any number as a test."6    msg_invalid  = "Invalid entry.  Please try again. "C    msg_timeout  = "No key pressed in the timeout period specified." <    msg_bad_command  = "Invalid command.  Please try again. "J    msg_no_terminator= "Please remember to terminate your entry with the "&% 		+ "pound-key.  Command accepted.  " M   customer_service = "In an actual application, DECtalk would now transfer "& I 	+ "your call to a customer service representative. This demonstration "& ) 	+ "just returns to the selection menu. "   P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &7 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND, & # 					T30SECOND, T5MINUTE, T15MINUTE   I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, & P         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode  1   COMMON (application_specific)	LONG		voice_id, &  						num_hold_keys, & 						num_input_keys, &  					BYTE	hold_key_buf(80) , & 						input_key_buf(80), &( 					STRING	dictionary_file_name = 80, & 						terminal_line  	MAX_ENTRY = 3
 	T1SECOND = 1 
 	T2SECOND = 2  	T20SECOND = 20  	T30SECOND = 30  	T5MINUTE = 300  	T15MINUTE = 900 	TIME_45_SEC = "0 00:00:45"  	TIME_90_SEC = "0 00:01:30"  	TIME_6_MIN  = "0 00:06:00"  	TIME_16_MIN = "0 00:16:00"  	voice = DTK$K_VOICE_MALE  	speaking_rate = 180 	comma_pause_duration = 0  	period_pause_duration = 0 	speech_on = DTK$K_SPEAK 	new_mode = DTK$M_SQUARE  	keypad_mode = DTK$K_KEYPAD_AUTO  F    msg_welcome$  = "Welcome to the DECtalk insurance demonstration.  "    %page  ! main   -  DECLARE LONG	version, init_dtk, need_to_init   init_dtk = 0%  need_to_init = 0% 	!A 	! Get the name of the physical device that the DECtalk module is B 	! connected to and the name of the dictionary file (if specified)A 	! that contains DECtalk's user dictionary words. If the call to  - 	! DTK$INITIALIZE is unsuccessful, then exit.  	!9 	CALL get_cli_params(terminal_line, dictionary_file_name)    	call set_timer(Time_45_sec)9 	stat% = DTK$INITIALIZE(voice_id, terminal_line, version)  	call cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IF     WHILE_LOOP: 	WHILE 1% = 1%			! do always   	num_hold_keys = 0%  	num_input_keys = 0%  9 	 !  Check to see if the DECtalk needs to be initialized. < 	 !  (init_dtk = need_to_init = 0).  If so, reinitialize theC  	 !  application specific parameters.  Then, set a watchdog timer  B 	 !  for 16 minutes in the future in case the DECtalk module fails@ 	 !  and no response to the DTK$ANSWER_PHONE command is received> 	 !  from DECtalk.  ** NOTE:  MAKE SURE THE WATCHDOG TIMER IS : 	 !  ALWAYS SET TO A VALUE LARGER THAN THE TIMEOUT PERIOD C 	 !  SPECIFIED IN THE DTK$ANSWER_PHONE COMMAND.  THE WATCHDOG TIMER / 	 !  CAN BE LARGER THAN 16 MINUTES.  Next, wait B 	 !  for the phone connected to the DECtalk to ring.  If the phone? 	 !  does not ring in "timeout" seconds (or the watchdog timer  B 	 !  times out), normally, the status of the DECtalk unit would beA 	 !  checked.  This is not possible in the current version (V4.5) A 	 !  of the VMS Run-Time Library Support for DECtalk.  Therefore, H 	 !  instead of reinitializing DECtalk every time the unit power cycled,C 	 !  it is reinitialized every time no phone calls are received in  G 	 !  "timeout" seconds. Then, a greeting message is spoken to the user. 
          ! 	IF init_dtk = need_to_init @ 	THEN  stat% = initialize_dectalk		! Reinitialize DECtalk paramS# 		IF (STAT% AND STS$M_SUCCESS) = 0%  		THEN- 			!  Initialization failed.  It appears that 0 			!  the DECtalk module may be dead.  For now,  			!  I will exit.    			GO TO out			! End the program 		END IF9 	    init_dtk = NOT need_to_init			! Appl. init. complete  	END IF ; 	CALL set_timer(time_16_min)		! Set system (watchdog) timer  	!G 	! The greeting message DECtalk speaks upon answering the telephone can ; 	! be modified by changing the text in the character string A 	! "msg_welcome". The number of rings DECtalk waits to answer the F 	! telephone ("number_of_rings"), can be changed but it is recommended7 	! that the phone is always answered on the first ring.  	!K         stat% = DTK$ANSWER_PHONE(voice_id, number_of_rings, msg_welcome$, &  								T15MINUTE) 	CALL cancel_timer 	IF (stat% = SS$_NORMAL) 	THEN  		! ' 		!  The telephone has been answered.    		! A 		!  NOTE: DTK$ANSWER_PHONE automatically enables autostop keypad 6 		!	 mode, and wink detection on the telephone keypad. 		!  		CALL menu  		CALL end_call 9 	ELSE IF (stat% = SS$_TIMEOUT)			! Timeout period expired 
 	     THEN2 		init_dtk = need_to_init			! Have to reinitialize
 	     ELSE 		CALL error_log(stat%) 6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	     END IF 	END IF      NEXT    out:A     !  some fatal error has occured... Terminate DECtalk and exit      !      CALL set_timer(Time_45_sec) C     stat% = DTK$TERMINATE(VOICE_ID)     ! End use of DECtalk device      CALL cancel_timer %     IF (stat% AND STS$M_SUCCESS) = 0%      THEN 		CALL error_log(stat%) 
     END IF     END  N  !********************* END OF PROGRAM ***************************************  !C  ! Gets the parameters from the command line using LIB$GET_FOREIGN. C  ! If a fatal error occurs, it is reported and the demo is stopped. K  ! Otherwise, the parameters specified are returned in terminal_line_string P  ! for the device name, and dictionary_name for the name of the dictionary file.  !A  SUB  get_cli_params (STRING device_name, STRING dictionary_name)   % 	EXTERNAL LONG CONSTANT STS$M_SUCCESSA' 	EXTERNAL LONG FUNCTION LIB$GET_FOREIGN!   	DECLARE STRING get_param_bufw0 	DECLARE LONG device_length, diction_name_length  * 	stat% = LIB$GET_FOREIGN(get_param_buf,,,)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%) 6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IF!+ 	device_length = POS(get_param_buf, " ", 1)n) 	diction_name_length = LEN(get_param_buf)a   	IF device_length = 0% 	THENt: 		device_name = SEG$(get_param_buf,1, diction_name_length) 	ELSEa9 		device_name = SEG$(get_param_buf, 1, device_length - 1)T9 		dictionary_name = SEG$(get_param_buf, device_length+1,&o 						 diction_name_length)N 	END IFt	   END SUBs    K  !*************************************************************************r?  !  Initializes the application specific parameters of DECtalk.dD  !  First, left square bracket ('[') and right square bracket (']') M  !  are enabled as phonemic delimiters. To specify other modes, the bit masks M  !  for the modes to be set should be OR'd together with the DTK$M_SQUARE bitrM  !  mask and assigned to the varible "NEW_MODE".  Next, the default speaking aH  !  voice and speaking rate are selected for the application.  The commaE  !  pause and period pause are set to DECtalk defaults.  Other voices I  !  can selected for the default speaking voice by modifying the variablevB  !  "voice".  Likewise, a different speaking rate can be specifiedG  !  by changing the static variable "speaking_rate".  Finally, the user!F  !  dictionary is loaded (by invoking "load_dictionary").  Note, otherF  !  application specific parameters should also be initialized in this"  !  subroutine if the need arises.  !  #  FUNCTION LONG initialize_dectalk()L  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS(   EXTERNAL LONG FUNCTION	DTK$SET_MODE, & 				DTK$SET_VOICE, & 				load_dictionary   M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_mint  I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, & - 		 period_pause_duration, speech_on, new_modes-   COMMON (application_specific)	LONG	voice_id_   	CALL set_timer(Time_45_sec)+ 	stat% = DTK$SET_MODE(voice_id, new_mode, )5 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%)a6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IF  	!A 	!  Indicate the type of voice and the speaking rate for DECtalk.u 	CALL set_timer(Time_45_sec)7 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate &"1 				,comma_pause_duration, period_pause_duration)i 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENp 		CALL error_log(stat%)m6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IFt 	!8 	! load user dictionary using "load_dictionary" function 	!% 	initialize_dectalk = load_dictionarym 	EXIT FUNCTION
  END FUNCTIONi  K  !  -----------------------------------------------------------------------rO  !  Gets a series of touch tone keys entered on the telephone keypad terminated M  !  by a pound sign (#) or an asterisk (*).  Returns SUCCESS if the series of&O  !  touch tone keys was received successfully.  Otherwise, FAILURE is returned.U  N  FUNCTION LONG get_key_string(STRING prompt,LONG timeout,LONG terminator_code)    %INCLUDE "DTKDEF"  +   EXTERNAL LONG FUNCTION	DTK$READ_KEYSTROKEr'   EXTERNAL LONG CONSTANT	SS$_TIMEOUT, &c 				SS$_NORMAL, &G
 				DTK$_WINK   P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &) 		     LONG	MAX_ENTRY, T1SECOND, T2SECONDo  1    COMMON (application_specific)	LONG	voice_id, &T 						num_hold_keys, & 						num_input_keys, &D 					BYTE	hold_key_buf(80), &N 						input_key_buf(80)9  C   DECLARE LONG  read_key_buf, hold_buf_ptr, ad_timeout, loc_timeout_   	loc_timeout = timeout   	IF num_hold_keys > 0% 	THEN= 	!E 	!  There are Touch Tone keys in the typeahead buffer (hold_key_buf).oB 	!  The routine "read_advance_keys" is called here to read any newA 	!  keys pressed.  This is used mainly to read and process winks.mF 	!  The "keys" stored in the typeahead buffer are moved into the input? 	!  buffer "input_key_buf" up to any terminator character.  The_H 	!  terminator character is put in "terminator_value", and any remainingG 	!  characters left in the typeahead buffer are copied to the front of f 	!  the buffer.t 	! 		ad_timeout = 1%t 		GOSUB read_advance_keyso" 		hold_key_buf(num_hold_keys) = 0% 		hold_buf_ptr = 0%CA 		WHILE hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_NUMBER_SIGN AND &e8 		      hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_ASTERISK  % 			IF hold_key_buf(hold_buf_ptr) = 0%r 			THENa 				num_hold_keys = 0% 				GO TO read_key	 			END IFa% 				input_key_buf(num_input_keys) = &  					hold_key_buf(hold_buf_ptr)   ' 			num_input_keys = num_input_keys + 1% # 			hold_buf_ptr = hold_buf_ptr + 1%y 		NEXT. 		terminator_code = hold_key_buf(hold_buf_ptr)" 		hold_buf_ptr = hold_buf_ptr + 1% 		num_hold_keys = 0% 		!t9 		!  Recopy the remaining keys in the typeahead buffer toeA 		!  the beginning of the buffer.  If the terminating keycode was A 		!  a "#" or "*", skip over it and start recopying with the nextc
 		!  keycode.v 	 ' 		UNTIL hold_key_buf(hold_buf_ptr) = 0%H9 			hold_key_buf(num_hold_keys)=hold_key_buf(hold_buf_ptr)N% 			num_hold_keys = num_hold_keys + 1% % 			hold_buf_ptr  = hold_buf_ptr  + 1%H 		NEXT 		GO TO process_entryT 	END IFN 	IF LEN(prompt) > 1% 	THENtB 	!  this test assumes that no 1 character prompts will be sent to 9 	!  dectalk.  Prompts of 1 char will be passed over here.  	!% 		CALL speak_text(DTK$K_WAIT, prompt)C 	END IF 
  read_key: 	WHILE 1% = 1% 		!n? 		!  Read all keys entered on the touch tone keypad by the useriA 		!  and store them in the typeahead buffer "hold_key_buf". Firstt> 		!  a watchdog timer must be set before any keys can be read.	          d 		CALL set_timer(Time_45_sec)rC 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , loc_timeout)k 		CALL cancel_timer  		IF stat% = SS$_NORMALe 		THEN0 			IF (read_key_buf = DTK$K_TRM_NUMBER_SIGN OR &) 			    read_key_buf = DTK$K_TRM_ASTERISK)U 			THEN0 				!H+ 				!  Received key string terminator ("#")t2 				!  so reception of keystring is completed. Use1 				!  a short timeout to gather up any remainingp+ 				!  touch tone keys entered by the user._  " 				terminator_code = read_key_buf 				ad_timeout = 2%i 				GOSUB read_advance_keysc 				GO TO process_entryg 			ELSEe0 				input_key_buf(num_input_keys) = read_key_buf( 				num_input_keys = num_input_keys + 1% 				loc_timeout = 10% 	 			END IFe 		ELSE	IF stat% = SS$_TIMEOUTt 			THEN  				EXIT read_keyt 			ELSE	IF stat% = DTK$_WINK 				THEN 				!t. 				!  DECtalk detected a wink which sometimes0 				!  indicates that the user has hungup.  This0 				!  demonstration program assumes that a WINK, 				!  does indicate the a user has hungup. 2 				!  Therefore, return so DECtalk can hangup its3 				!  phone.  If for any reason it is noticed thatD3 				!  spontaneous winks are occurring and the user 0 				!  at the other end of the telephone did not0 				!  hangup, then DO NOT return. Just continue! 				!  receiving touch tone keys.o   				    CALL error_log(stat%)	 				    get_key_string = 0%a  				    EXIT FUNCTION 				ELSE 				    CALL error_log(stat%)L% 				    CALL LIB$STOP(stat% BY VALUE)s
 				END IF	 			END IFE 		END IF 	NEXT 	         ! N         !  No keystring terminator ("#" or "*") entered so set the terminatingJ         !  keycode to DTK$K_TRM_TIMEOUT.  Otherwise, return all touch toneF 	!  keys entered. Finally, recopy any remaining touch tone keys in the= 	!  typeahead buffer (ttkeys) to the beginning of the buffer. 	          !$ 	terminator_code = DTK$K_TRM_TIMEOUT    PROCESS_ENTRY:*! 	hold_key_buf(num_hold_keys) = 0% 
 	CALL restart  	get_key_string = 1% 	EXIT FUNCTION    READ_ADVANCE_KEYS:  	!G 	!  Read any keys from DECtalk into the typeahead buffer "hold_key_buf"s 	!
 	WHILE 1=1 		CALL set_timer(Time_45_sec) B 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , ad_timeout) 		CALL cancel_timerS 		IF stat% = SS$_NORMALG 		THEN- 			hold_key_buf(num_hold_keys) = read_key_bufG% 			num_hold_keys = num_hold_keys + 1%G 		ELSE	IF stat% = SS$_TIMEOUTD# 			THEN				! no key pressed: returnE
 				RETURN 			ELSE	IF stat% = DTK$_WINK 				THEN			! Hung up?  exitt 					CALL error_log(stat%) 					get_key_string = 0%  					EXIT FUNCTIONg 				ELSE 					CALL error_log(stat%)" 					CALL LIB$STOP(stat% BY VALUE)
 				END IF	 			END IFg 		END IF 	NEXT,  
  END FUNCTIONm    M  !***************************************************************************EL  ! Verifies the access code received from the customer.  This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realP  ! application, the code would be verified against access codes in the database.    FUNCTION LONG access_verify ()n   	access_verify = 1%T 	EXIT FUNCTION  
  END FUNCTIONo  M  !***************************************************************************NH  ! Verifies the password received from the customer. This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realL  ! application, the password would be verified against their password in the  ! database.  !  FUNCTION LONG password_verify ()o   	password_verify = 1%g 	EXIT FUNCTION
  END FUNCTION   M  !*************************************************************************** G  !  Prompts the user for a command and receives the command (touch tonelJ  !  key) from the user.  Note, the command will be accepted whether or notE  !  it is terminated with the pound key "#".  However, if the commandhG  !  is not followed by the pound key, the command will not be processed O  !  until the timeout period has expired and a warning message has been spoken.oM  !  When commands are received, the routine "process_menu_entry" is performedn!  !  to implement the menu choice.e  !  SUB menu()i    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT STS$M_SUCCESS*   EXTERNAL LONG FUNCTION	get_key_string, & 				policy_info, & 				physician_location, &y 				insurance_verification, &s
 				claims, &  				DTK$SET_VOICE   5   COMMON (MESSAGE_TEXT) STRING  msg_access   = 100, &  				msg_invalid  = 40, & 				msg_bad_command   = 40, &a 				msg_no_terminator  = 100, &u 				msg_timeout  = 50, & 				customer_service = 160  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &4 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND  I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &  				 period_pause_duration  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &a 					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80)  I   main_menu$	= "For insurance policy information, press 1, followed by "&eF 	+ "the pound-key.  For participating physician locations, press 2, "&D  	+ "followed by the pound-key.  For health insurance eligibility "&B 	+ "verification, press 3, followed by the pound-key.  For auto "&A 	+ "insurance claims, press 4, followed by the pound-key.  For "&SH 	+ "DECtalk product information, press 5, followed by the pound-key.  "&F 	+ "To repeat this message, press 0, followed by the pound-key.  To "&  	+ "exit, press the star key.  "  L   dtcfamily$	= "[+] The [`]DECtalk [`]Voice Response-System is the latest "&I 	+ "addition to Digital's Voice solutions. It features the performance "&lD 	+ "of the MicroVAX 2, plus the flexibility of the foremost voice "&F 	+ "synthesis product on the market today.  The [`]DECtalk [`]Voice "&F 	+ "Response-System is sized to support from 2 to 32 DEctalk lines. "&H 	+ "It is ideally suited to front end large data-bases. Packaged with "&I 	+ "the [`]DECtalk [`]Voice Response-System is the DECtalk Application "&iE 	+ "Development-Guide.  This guide consists of a user's manual and "&tC 	+ "sample application-software. It is designed to significantly "&IG 	+ "reduce the time required to develop a voice response application "&_I 	+ "for any of the DEctalk products. DECtalk component products include"&_H 	+ " Dual-Line DECtalk, a two-line subsystem, and Multi-line DECtalk, "&D 	+ "an eight-line subsystem, both of which are rack mountable. In "&F 	+ "addition, the DECtalk board can be used to expand the number of "&H 	+ "lines needed.  [+] Single line DECtalk is a table-top unit with a "&> 	+ "built-in loud-speaker. It is best for [st'aend#axl`own] "&I 	+ "applications, such as aids for the handicapped. It is also commonly"&eI 	+ " used in manufacturing, for [m'aonaxtaxrixnx] status on the factory"&eH 	+ " floor. [+] All DECtalk products appropriately pronounce commonly "&E 	+ "occurring forms, such as numbers, money, abbreviations, dates, "&i& 	+ "times, and [paxnxkchuw'eyshaxn]. "     4   DECLARE	LONG	terminator_value, illegal_entry_count  	null_char$ = X'00'Ce 	terminator_value = 0% 	illegal_entry_count = 0%p  $ 	WHILE (input_key_buf(0) <> 0% OR  &* 				terminator_value <> DTK$K_TRM_TIMEOUT) 	!> 	! Keep getting commands from the user until the exit key "*",A 	! is entered, a wink is detected, or the timeout period expires._G 	! First, check if there are any keys in the typeahead buffer (done by ID 	! "get_key_string" with a 1 second timeout).  If so, process them. F 	! Otherwise, prompt the user for a command and wait for his response. 	!  GET_SHORT_READ: 	num_input_keys = 0% 	input_key_buf(0) = 0%F         stat% = get_key_string(null_char$, T1SECOND, terminator_value)  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENo
 		EXIT SUB 	END IF_) 	IF terminator_value = DTK$K_TRM_ASTERISKR 	THENh
 		EXIT SUB3 	ELSE	IF (terminator_value = DTK$K_TRM_NUMBER_SIGN)o 		THEN: 			GOSUB process_menu_entry	! Valid command so process it	) 			IF (input_key_buf(0) = DTK$K_TRM_ZERO)x 			THENk 				GO TO get_long_readd 			ELSEh 				GO TO get_short_read	 			END IFu7 		ELSE IF ((terminator_value <> DTK$K_TRM_TIMEOUT) OR	&s6 	        	 (terminator_value = DTK$K_TRM_TIMEOUT AND	& 				input_key_buf(0) = 0%))s 			!: 			!  No keys in typeahead buffer so prompt for a command. 			! 		     THENr+ 				CALL speak_text(DTK$K_WAIT, main_menu$) 
 		     END IFa 	         END IF 	     END IF 	!A 	!  Any new keys received should be processed after the keys read1B 	!  from the typeahead buffer.  Start storing touch tone keys intoF 	!  into the buffer following the keys read from the typeahead buffer. 	!  GET_LONG_READ:o 	num_input_keys = 0%G         stat% = get_key_string(null_char$, T20SECOND, terminator_value)	  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN_
 		EXIT SUB 	END IF ) 	IF terminator_value = DTK$K_TRM_ASTERISKA 	THENH
 		EXIT SUB4 	ELSE	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) <> 0%)U 		THEN) 			CALL speak_all_text(msg_no_terminator)i: 			GOSUB process_menu_entry	! Valid command so process it	  6 		ELSE 	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) = 0%) 			THEN $ 				CALL speak_all_text(msg_timeout) 				EXIT SUB 			ELSE= 				GOSUB  process_menu_entryy	 			END IFT 		END IF 	END IF	    NEXT		 	EXIT SUB_  PROCESS_MENU_ENTRY:  !?  !  Processes the touch tone key string received from the user.u  ! 	IF num_input_keys > 1%I 	THEN  	!< 	!  Only single key commands are valid in this menu.  Inform< 	!  the user that an invalid command was entered and return. 	!& 		CALL speak_all_text(msg_bad_command)0 		illegal_entry_count = illegal_entry_count + 1% 	ELSEt 	    SELECT	input_key_buf(0)0 		CASE = 	DTK$K_TRM_ZERO			! Speak menu help msg* 			CALL speak_text(DTK$K_WAIT, main_menu$) 			illegal_entry_count = 0%c  , 		CASE = 	DTK$K_TRM_ONE			! policy info demo 			stat% =  policy_info $ 			if (stat% AND STS$M_SUCCESS) = 0% 			THENh 				EXIT SUB	 			END IF. 			illegal_entry_count = 0%i  0 		CASE = 	DTK$K_TRM_TWO			! doctor location demo 			stat% = physician_locationa$ 			if (stat% AND STS$M_SUCCESS) = 0% 			THENL 				EXIT SUB	 			END IF  			illegal_entry_count = 0%E  4 		CASE = 	DTK$K_TRM_THREE			! insurance verification! 			stat% = insurance_verificationr$ 			if (stat% AND STS$M_SUCCESS) = 0% 			THEN  				EXIT SUB	 			END IF_ 			illegal_entry_count = 0%r  # 		CASE = 	DTK$K_TRM_FOUR			! claimsa 			stat% = claimsa$ 			if (stat% AND STS$M_SUCCESS) = 0% 			THENf 				EXIT SUB	 			END IFi 			illegal_entry_count = 0%!  1 		CASE = 	DTK$K_TRM_FIVE			! dectalk product infoT* 			CALL speak_text(DTK$K_WAIT, dtcfamily$) 			illegal_entry_count = 0%    		CASE ELSEC+ 			CALL speak_text(DTK$K_WAIT, msg_invalid)y1 			illegal_entry_count = illegal_entry_count + 1%k 	   END SELECT 	END IF  	num_input_keys = 0% 	!B 	! If user enters 3 illegal/incorrect commands, speak help message 	! 	IF illegal_entry_count >= 3 	THENS) 		CALL speak_text(DTK$K_WAIT, main_menu$)d 		illegal_entry_count = 0% 	END IFt 	RETURNi    END SUB  M  !***************************************************************************pG  !  Load the user dictionary with the words and phonemic pronunciations.G  !  stored in the sequential file specified in the foreign command lineII  !  invoking the program.  Each line of this file contains the word to be*G  !  defined in the user dictionary followed by a space, followed by thesI  !  phonemic pronunciation of the word.  The entry is parsed to find the nN  !  start and finnish of the word and it's replacement.  The word and phonemicM  !  pronunciation are loaded into the user dictionary. If the load dictionarywN  !  command fails, the user is notified and processing is terminated.  ReturnsM  !  SUCCESS if the dictionary is loaded successfully or if no user dictionaryc<  !  file name is specified.  Otherwise, FAILURE is returned.     FUNCTION LONG load_dictionary()    %INCLUDE "DTKDEF"  ,   EXTERNAL LONG FUNCTION	DTK$LOAD_DICTIONARY&   EXTERNAL LONG CONSTANT	SS$_NORMAL, & 				DTK$_TOOLONG, DTK$_NOROOMm@   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &  					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80), &e$ 				STRING	dictionary_file_name = 80  / 	MAP (dictionary) STRING dictionary_entry = 256E( 	DECLARE STRING		diction_word,  phonetic% 	DECLARE LONG		word_count, phonem_end   
 	sp$ = X'20'C_ 	tab$ = X'09'C  	null_char$ = X'00'CT 	ON ERROR GOTO ERROR_CHECKG 	IF LEFT$(dictionary_file_name,1) = null_char$	! No dictionary filename	 	THEN_6 	  !  No dictionary was specified in the command line.# 	  !  Return to initialize_dectalk s 		load_dictionary = 1% 		exit functionN 	END IF_  A 	OPEN dictionary_file_name AS FILE #1,	ORGANIZATION SEQUENTIAL, &T! 						ACCESS READ, MAP DICTIONARYO 	!E 	! Since there is no timeout associated with the DTK$LOAD_DICTIONARY 	C 	! command, it is possible for an application to hang waiting for aiF 	! response after issuing the DTK$LOAD_DICTIONARY command.  Therefore,G 	! arm a watchdog timer (6 minutes in this case) to time the loading ofyG 	! the entire user dictionary.  If all the entries are not loaded into tA 	! the user dictionary before the timer expires, then assume thaty7 	! something is wrong with the DECtalk module and exit.  	!: 	CALL set_timer(time_6_min)		! Set system (watchdog) timer        WHILE 1% = 1% 	GET #1e 	! d3 	!  Read in all of the words and substitutions froms8 	!  the sequential file specified in the command string. 	!+ 	word_count = POS(dictionary_entry, sp$, 1)  	IF word_count = 0%t2 	THEN		word_count = POS(dictionary_entry, tab$, 1) 	END IFp2 	phonem_end = POS(dictionary_entry, null_char$, 1)  7 	diction_word =	SEG$(dictionary_entry, 1, word_count-1)f> 	phonetic =	SEG$(dictionary_entry, word_count+1, phonem_end-1)  > 	stat% = DTK$LOAD_DICTIONARY(voice_id, DICTION_WORD, phonetic)1 	IF (stat% = DTK$_TOOLONG OR stat% = DTK$_NOROOM)2 	THEND 	     !n9 	     !  These are not generally fatal errors.  However, s: 	     !  they will be treated as such.  In creating a demo9 	     !  program, if words cannot be loaded into the user.> 	     !  dictionary, the programmer should be notified so that@ 	     !  the appropriate action can be taken.  By treating these? 	     !  errors as fatal, the programmer will at least know the+7 	     !  point in the program where the error occurred.u 	     !d
 		CLOSE #1 		CALL error_log(stat%)i 		load_dictionary = 0%' 		EXIT FUNCTION			! Fatal error so exits/ 	ELSE IF (stat% <> SS$_NORMAL) 	! Fatal failure"
 	     THEN- 			CALL cancel_timer		! Cancel watchdog timerr 			CLOSE #1i 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	     END IF 	END IF 	      NEXTd  	!o7 	!  Entire dictionary is loaded so cancel system timer.d 	!  DONE:4 	CALL cancel_timer			! Cancel system(watchdog) timer$ 	CLOSE #1				! Close dictionary file 	load_dictionary = 1%l  EXIT FUNCTION  
  ERROR_CHECK:e( 	IF ERR = 11%		! IF End of File is found 	THENs
 		RESUME DONEi 	ELSE  	   CALL error_log(VMSSTATUS)n 	   RESUME HERE" HERE:  	   load_dictionary = 0% 	   EXIT FUNCTIONy 	END IF	
  END FUNCTION0  M  !***************************************************************************(H  !  DECtalk stopped speaking because it was in autostop keypad mode whenG  !  it received a Touch Tone Key from the user.  First, send DECtalk a nK  !  right square bracket "]" just in case speech was stopped while speakingaM  !  phonemic text. Then, restart speech (using DTK$SET_SPEECH_MODE) and reset 6  !  the speaking voice and rate (using DTK$SET_VOICE).  !  SUB restart()    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS/   EXTERNAL LONG FUNCTION	DTK$SET_SPEECH_MODE, &  				DTK$SET_VOICE_  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &	# 		 period_pause_duration, speech_on=-   COMMON (application_specific)	LONG	voice_ide      rsbracket$    = "]"  6   DECLARE LONG old_mode				! Current mode before reset  ) 	CALL speak_text( DTK$K_WAIT, rsbracket$)E 	! 	!  Set speakig on 	! 	CALL set_timer(Time_45_sec); 	stat% = DTK$SET_SPEECH_MODE(voice_id, speech_on, old_mode)n 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN) 		CALL error_log(stat%)n5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IF	 	!% 	!  Reset the voice and speaking rate  	CALL set_timer(Time_45_sec)8 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate, &0 				comma_pause_duration, period_pause_duration) 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENb 		CALL error_log(stat%)r5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitn 	END IFk    END SUB  M  !***************************************************************************aE  !  End the current user session.  Since the DTK$HANGUP_PHONE commandrC  !  does not set a timeout, and it requests DECtalk to send a phonerG  !  status, a watchdog timer is set to insure that the application does	G  !  not hang (if DECtalk fails).  If a longer timeout period is needed,aH  !  adjust the value of the parameter moved into SET_TIMER_STRING beforeM  !  performing "set_timer".  After the watchdog timer is set, speak a goodbyeiI  !  message to the caller and then hangup the phone.  The goodbye message B  !  spoken can be changed by modifying the text in "msg_goodbye".   !  SUB end_call ()  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &! 				SS$_TIMEOUT, & 				DTK$_ONHOOK!  -   EXTERNAL LONG FUNCTION 	DTK$HANGUP_PHONE, &m 				DTK$READ_KEYSTROKE, &t 				DTK$SPEAK_TEXT  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min_-   COMMON (application_specific)	LONG	voice_id   G   msg_goodbye$  = "Thank you for calling the DECtalk-demonstration.  "&m@ 		+ "For more information, please call 1, 800, 8 3 2, 6 2 7 7. "  : 	CALL set_timer(time_6_min)		! Set system (watchdog) timer 	!$ 	!  Say goodbye and hangup the phone 	!1 	stat% = DTK$HANGUP_PHONE(voice_id, msg_goodbye$) * 	CALL cancel_timer			! Cancel system timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENa 		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitT 	END IFE 	!B 	! Get rid of any winks that may have been generated by the caller? 	! hanging up in the middle of the goodbye message.  This workss( 	! around clears the internal WINK flag. 	!         timeout% = 1%i 	WHILE 1% = 1%  	    CALL set_timer(Time_45_sec): 	    stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%) 	    CALL cancel_timer4 	    IF (stat% = DTK$_ONHOOK OR stat% = SS$_TIMEOUT)	 	    THEN= 		!$/ 	  	!  Clear remaining winks that may have beena3 		!  detected before DECtalk hung up the telephone.t 		! $ 	        CALL set_timer(Time_45_sec)> 	        stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%) 	        CALL cancel_timer# 		IF (stat% AND STS$M_SUCCESS) = 0% 
 	        THENr 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	        END IFL 	        EXIT SUBA+ 	    ELSE IF (stat% AND STS$M_SUCCESS) = 0%  	         THEN 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	         END IF 	    END IFe 	NEXTo  END SUB  J  !  ----------------------------------------------------------------------J  !  Speak all text -- disable autostop keypad, speak text in prompt using :  !  "speak_text". If autostop was set, re-enable autostop.  !#  SUB speak_all_text (STRING prompt)b    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS,   EXTERNAL LONG FUNCTION	DTK$SET_KEYPAD_MODE  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minlI   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &-P         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode-   COMMON (application_specific)	LONG	voice_idp     DECLARE LONG	keypad_on     keypad_on = DTK$K_KEYPAD_ONe 	!F 	!  If autostop keypad mode is enabled (keymode = DTK$K_KEYPAD_AUTO), 1 	!  then enable the keypad without autostop mode.L 	!C 	IF (keypad_mode = DTK$K_KEYPAD_AUTO)	! Keypad is in autostop mode	  	THENn7 		CALL set_timer(Time_45_sec)	! Set the watchdog timer	r2 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_on)1 		CALL cancel_timer		! Cancel the watchdog timer	r# 		IF (stat% AND STS$M_SUCCESS) = 0%l 		THEN 			CALL error_log(stat%)  			CALL LIB$STOP(stat% BY VALUE) 		END IF 	END IFA  ( 	!  Send text to DECtalk to be spoken.  = 	!  Specify the mode as DTK$K_WAIT so that text is completelyK< 	!  spoken before the keypad is re-enabled in autostop mode.  $ 	CALL speak_text(DTK$K_WAIT, prompt)  ' 	!  If autostop keypad mode was enabledi9 	!  (keypad_mode = DTK$K_KEYPAD_AUTO), then re-enable it.& 	!D 	IF (keypad_mode = DTK$K_KEYPAD_AUTO) ! Keypad was in autostop mode	 	THEN	4 		CALL set_timer(Time_45_sec)	! Set watchdog timer		4 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_mode)1 		CALL cancel_timer		! Cancel the watchdog timer	D# 		IF (stat% AND STS$M_SUCCESS) = 0%  		THEN 			CALL error_log(stat%)  			CALL LIB$STOP(stat% BY VALUE) 		END IF 	END IFI  END SUB  M  !***************************************************************************c.  !  Sends the prompt (specified by prompt) to 1  !  the DECtalk to be spoken.  Returns SUCCESS if >  !  everything is spoken o.k.  Otherwise, FAILURE is returned.  !  7  !  NOTE:  If DTK$SPEAK_TEXT is called with mode set toD8  !	   DTK$K_WAIT or DTK$K_STATUS, a phone status requestA  !	   is sent from DECtalk.  Since there is no timeout associatedl>  !	   with this request, a system timer should be set (to someG  !	   exteremely long value (16 minutes) to insure that the applications  !	   does not hang.  !8  SUB speak_text (LONG return_status_mode, STRING prompt)    %INCLUDE "DTKDEF"  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &e 				SS$_NORMAL'   EXTERNAL LONG FUNCTION	DTK$SPEAK_TEXTt  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minh  -   COMMON (application_specific)	LONG	voice_id  	! 	!  Speak the text: 	CALL set_timer(time_16_min)	! Set system (watchdog) timer= 	stat% = DTK$SPEAK_TEXT(voice_id, prompt, return_status_mode)t) 	CALL cancel_timer		! Cancel system timerw 	IF (stat% <> SS$_NORMAL)e 	THENa 		CALL error_log(stat%)_5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitw 	END IF$  END SUB  I  ! **********************************************************************p/  !	Log error to the operator console  "OPER11".e  !N  !  Take the error number, input to SYS$GETMSG to get the system message text.P  !  Format the message text with the specific terminal line for that applicationL  !  "process" (using SYS$FAO), and call SYS$SENOPR with the error structure.  !H  !  NOTE:  the DTK$ errors that occur will have the %DTK- facility name,B  !	  but not the error message text, just the error number.  It isG  !	  anticipated that these messages will be included in future VMS/RTLt  !	  releases.  !!  SUB error_log(LONG error_number)o  B  %INCLUDE "$OPCDEF" %FROM %LIBRARY "SYS$LIBRARY:BASIC$STARLET.TLB"  #   EXTERNAL LONG CONSTANT	SS$_NORMALa#   EXTERNAL LONG FUNCTION	SYS$FAO, &S 				SYS$SNDOPR, &  				SYS$GETMSG  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &  					num_input_keys, & 				BYTE	hold_key_buf(80) , &t 					input_key_buf(80), & ' 				STRING	dictionary_file_name = 80, &e 					terminal_line  B   MAP	(error_struct) LONG opc$type_target, LONG OPC$L_MS_RQSTID, & 			STRING error_text = 120+   MAP	(error_struct) STRING error_msg = 128o%   MAP   (temp)  STRING error_buf = 80E  +   DECLARE STRING CONSTANT filler = "  ON  " 3   DECLARE STRING CONSTANT control_str = "!AD!AS!AD"S   DECLARE LONG buf_len  Q      temp% = SYS$GETMSG(error_number by value, buf_len, error_buf, 15% by value,)   !A  ! Set message target to OPER11, and the message type to RQ_RQST.*D  ! For more information on sending messages to an operators terminal"  ! see the System Services manual.  !>     opc$type_target = (OPC$M_NM_OPER11 * 256%) OR OPC$_RQ_RQST  6  	temp% = SYS$FAO(control_str, buf_len, error_text,		&*  				buf_len by value, error_buf by ref,	&/  				filler, 5% by value, terminal_line by ref)a2  	WHILE MID$(error_text, buf_len + 1, 1) <> X"00"C,  		MID$(error_text, buf_len + 1, 1) = X"00"C  		buf_len = buf_len + 1  	NEXT,  	stat% = SYS$SNDOPR(error_msg, 0% by value)3   	IF (stat% <> SS$_NORMAL)		! Send to oper failed	e  	THEN5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exita	  	END IF    END SUB  M  !***************************************************************************MJ  !  Sets the system (watchdog) timer to expire "sec" seconds in the futureI  !  by invoking the "SYS$SETIMR" system service.  SYS$BINTIM is passed a _L  !  character string in the format "D HH:MM:SS", where D is Days, H is HoursH  !  M is minutes etc.  The output of BINTIM is the quadword delta_time ,/  !  which gets passed as input to SYS$SETIMR.  )  !"  SUB set_timer(STRING time_string)  ( 	EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 				SS$_TIMEOUT % 	EXTERNAL LONG FUNCTION	SYS$SETIMR, &L 				SYS$BINTIM: 	EXTERNAL LONG		LIB$SIGNAL 	! Indicate exception condition% 	MAP (quadword) LONG delta_time, FILLd  , 	stat% = SYS$BINTIM(time_string, delta_time)# 	IF (stat% AND STS$M_SUCCESS)  = 0%A 	THENr 		CALL error_log(stat%)S5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IF   K 	stat%= SYS$SETIMR( ,delta_time, LIB$SIGNAL BY VALUE, SS$_TIMEOUT BY VALUE)a# 	IF (stat% AND STS$M_SUCCESS)  = 0%S 	THENe 		CALL error_log(stat%)r5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exito 	END IFh  END SUB  J  !  ----------------------------------------------------------------------$  !  Cancel the system watchdog timer  !  SUB cancel_timer()a  %  EXTERNAL LONG CONSTANT	STS$M_SUCCESSo?  EXTERNAL LONG FUNCTION	SYS$CANTIM		! Cancel SYS$SETIMR requestt  6 	stat% = SYS$CANTIM(SS$_TIMEOUT BY VALUE, 0% BY VALUE)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitd 	END IF!  END SUB