G 	%TITLE "DECTALK-TELECOMM.BAS  --  BASIC APPLICATION GUIDELINE PROGRAM"  !  !			  	TELECOMM.BAS  ! 6 !	NOTE:  This program was written with VAX BASIC V3.0. ! B !  The following file contain a "modifiable" demonstratoin programC !  for the telecommunications industry.  This demonstration program C !  typifies most telepone application programs written for DECtalk. B !  It is written in VAX BASIC and user Version 4.5 or later of the> !  VMS/MicroVMS Run-Time Library Support provided for DECtalk. ! D !  Program description:  In the "MENU" subroutine, there is a SELECT1 !			 statement where the code determines which of 3 !			 5 menu items are chosen.  The menu choices and 2 !			 menu message must be modified to reflect the $ !			 menu items being implemented.   !	 		 The menu choices are:  ! & !				1) Selecting Long Distance Vendor' !				2) Ordering Custom Calling Service  !				3) Field Service Dispatch !				4) Order Entry/Status# !				5) DECtalk Product Information  ! J !  NOTE:  For this demonstration, logging to an operator terminal WILL NOTD !	  be done since not all systems (especially MicroVMS systems) have !	  OPCOM running. ! F !	  All error messages are logged only to the operator terminals that @ !	  have specified the "OPER11" type of message will be handled.A !	  These messages give the error message, and the terminal line  D !	  connected to that process.  To have error messages logged to theC !	  console terminal, or any other terminal, at the DCL prompt ($), # !	  enter the REPLY/ENABLE command:  !  !				$ reply/enable=oper11 ! A !	  To enter this command, you must have the OPER user privelege. / !	  Also, OPCOM must be running on your system.  !    %INCLUDE "DTKDEF"   ' EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &  			SS$_NORMAL,   & 			SS$_TIMEOUT ! 7 !  EXTERNAL Run-time Library Routines (DECtalk support)  !  EXTERNAL LONG FUNCTION &0 			DTK$ANSWER_PHONE,	! Wait for phone to ring !&2 			DTK$INITIALIZE, 	! Initialize DECtalk device !&3 			DTK$TERMINATE, 		! End initialized DECtalk use!&  			initialize_dectalk  !  !  Prompts and demo text ! 4 COMMON (MESSAGE_TEXT) STRING    msg_invalid  = 40, & 				msg_bad_command   = 40, &  				msg_no_terminator  = 100, &  				msg_timeout  = 50, & 				customer_service = 160, &  				dispatch_desk = 160, & 				msg_access   = 100       ;     msg_invalid       = "Invalid entry.  Please reenter.  " I     msg_timeout       = "No key pressed in the timeout period specified." =     msg_bad_command   = "Invalid command.  Please reenter.  " L     msg_no_terminator = "Please remember to terminate your entry with the "&+ 		      + "pound-key.  Command accepted.  " G     customer_service  = "In an actual application, DECtalk would now "& 6 		      + "transfer your call to a customer service "&= 		      + "representative. This demonstration just returns "& # 		      + "to the selection menu. " G     dispatch_desk     = "In an actual application, DECtalk would now "& ; 		      + "transfer your call to the dispatch-desk. This "& > 		      + "demonstration just returns to the selection menu. "I     msg_access        = "Please enter your access code followed by the "& ; 		      + "pound-key.  You may enter any number as a test."   =     COMMON (constants)		    STRING time_45_sec, time_6_min, &  					   time_16_min, &% 				    LONG   MAX_ENTRY, T1SECOND, & ' 					   T20SECOND, T30SECOND, T15MINUTE   ;     COMMON (dt_features)	    LONG   voice, speaking_rate, &  					   comma_pause_duration, & + 					   period_pause_duration, speech_on, & $ 					   new_mode, number_of_rings, & 					   keypad_mode   6     COMMON (application_specific)   LONG   voice_id, & 					   num_hold_keys, & 					   num_input_keys, & # 				    BYTE   hold_key_buf(80) , &  					   input_key_buf(80), &+ 				    STRING dictionary_file_name = 80, &  					   terminal_line      time_45_sec = "0 00:00:45"     time_6_min  = "0 00:06:00"     time_16_min = "0 00:16:00"     MAX_ENTRY = 3      T1SECOND = 1     T20SECOND = 20     T30SECOND = 30     T15MINUTE = 900      voice = DTK$K_VOICE_MALE     speaking_rate = 180      comma_pause_duration = 0     period_pause_duration = 0      speech_on = DTK$K_SPEAK      new_mode = DTK$M_SQUARE #     keypad_mode = DTK$K_KEYPAD_AUTO   H     msg_welcome$  = "Welcome to DECtalk.  Digital Voice Solutions can "&6 		  + "increase your business [prowdaxkt'ihvixtiy].  "   %page  ! main  0     DECLARE LONG	version, init_dtk, need_to_init       init_dtk = 0%      need_to_init = 0%      ! D     ! Get the name of the physical device that the DECtalk module isE     ! connected to and the name of the dictionary file (if specified) D     ! that contains DECtalk's user dictionary words. If the call to 0     ! DTK$INITIALIZE is unsuccessful, then exit.     ! <     CALL get_cli_params(terminal_line, dictionary_file_name)     call set_timer(Time_45_sec) <     stat% = DTK$INITIALIZE(voice_id, terminal_line, version)     call cancel_timer %     IF (stat% AND STS$M_SUCCESS) = 0%      THEN 	CALL error_log(stat%)9 	CALL LIB$STOP(stat% BY VALUE)		    ! Fatal error so exit 
     END IF    WHILE_LOOP:$     WHILE 1% = 1%				    ! do always 	num_hold_keys = 0%  	num_input_keys = 0%8 	!  Check to see if the DECtalk needs to be initialized.; 	!  (init_dtk = need_to_init = 0).  If so, reinitialize the B  	!  application specific parameters.  Then, set a watchdog timer A 	!  for 16 minutes in the future in case the DECtalk module fails ? 	!  and no response to the DTK$ANSWER_PHONE command is received = 	!  from DECtalk.  ** NOTE:  MAKE SURE THE WATCHDOG TIMER IS  9 	!  ALWAYS SET TO A VALUE LARGER THAN THE TIMEOUT PERIOD  B 	!  SPECIFIED IN THE DTK$ANSWER_PHONE COMMAND.  THE WATCHDOG TIMERF 	!  CAN BE LARGER THAN 16 MINUTES.  Next, wait for the phone connectedD 	!  to the DECtalk to ring.  If the phone does not ring in "timeout"C 	!  seconds (or the watchdog timer times out), normally, the status B 	!  of the DECtalk unit would be checked.  This is not possible inC 	!  the current version (v4.5) of the VMS Run-Time Library Support  ? 	!  for DECtalk.  Therefore, instead of reinitializing DECtalk  D 	!  every time the unit power cycled, it is reinitialized every timeF         !  no phone calls are received in "timeout" seconds.  Then, a + 	!  greeting message is spoken to the user. 	         !  	IF init_dtk = need_to_init  	THEN   > 	    stat% = initialize_dectalk		! Reinitialize DECtalk params& 	    IF (STAT% AND STS$M_SUCCESS) = 0%	 	    THEN  		! 8 		!  Initialization failed.  It appears that the DECtalk/ 		!  module may be dead.  For now, I will exit.  		!  		GO TO out			! End the program  	    END IF 8 	    init_dtk = NOT need_to_init		! Appl. init. complete 	END IF ; 	CALL set_timer(time_16_min)		! Set system (watchdog) timer  	!: 	! The greeting message DECtalk speaks upon answering the 9 	! the telephone can be modified by changing the text in  < 	! the character string "msg_welcome".  The number of rings = 	! DECtalk waits to answer the telephone ("number_of_rings"), ; 	! can be changed, but it is recommended that the phone is  % 	! always answered on the first ring.  	!K         stat% = DTK$ANSWER_PHONE(voice_id, number_of_rings, msg_welcome$, &  								T15MINUTE) 	CALL cancel_timer 	IF (stat% = SS$_NORMAL) 	THEN  	    !* 	    !  The telephone has been answered.  4 	    !  NOTE: DTK$ANSWER_PHONE automatically enables4 	    !	     autostop keypad mode and wink detection. 	    ! 	    CALL menu 	    CALL end_call< 	ELSE IF (stat% = SS$_TIMEOUT)		    ! Timeout period expired	 	    THEN 5 		init_dtk = need_to_init		    ! Have to reinitialize 	 	    ELSE  		CALL error_log(stat%) 9 		CALL LIB$STOP(stat% BY VALUE)	    ! Fatal error so exit  	    END IF  	END IF           NEXT out:     ! A     !  some fatal error has occured... Terminate DECtalk and exit      !      CALL set_timer(Time_45_sec) D     stat% = DTK$TERMINATE(voice_id)		    ! End use of DECtalk device     CALL cancel_timer %     IF (stat% AND STS$M_SUCCESS) = 0%      THEN 	CALL error_log(stat%)
     END IF  END  J !--------------------------- get_param ----------------------------------- ! B ! Gets the parameters from the command line using LIB$GET_FOREIGN.B ! If a fatal error occurs, it is reported and the demo is stopped.J ! Otherwise, the parameters specified are returned in terminal_line_stringK ! for device name, and dictionary_name for the name of the dictionary file.t ! @ SUB  get_cli_params (STRING device_name, STRING dictionary_name)  )     EXTERNAL LONG CONSTANT  STS$M_SUCCESSn+     EXTERNAL LONG FUNCTION  LIB$GET_FOREIGNc  $     DECLARE STRING	    get_param_buf7     DECLARE LONG	    device_length, diction_name_lengths  -     stat% = LIB$GET_FOREIGN(get_param_buf,,,)e%     IF (stat% AND STS$M_SUCCESS) = 0%m     THEN 	CALL error_log(stat%)9 	CALL LIB$STOP(stat% BY VALUE)		    ! Fatal error so exith
     END IF.     device_length = POS(get_param_buf, " ", 1),     diction_name_length = LEN(get_param_buf)     IF device_length = 0%C     THEN9 	device_name = SEG$(get_param_buf,1, diction_name_length)      ELSE8 	device_name = SEG$(get_param_buf, 1, device_length - 1)8 	dictionary_name = SEG$(get_param_buf, device_length+1,&  					       diction_name_length)
     END IF END SUBr    O !------------------------- initialize_dectalk --------------------------------- > !  Initializes the application specific parameters of DECtalk.C !  First, left square bracket ('[') and right square bracket (']') sC !  are enabled as phonemic delimiters. To specify other modes, the  E !  bit masks for the modes to be set should be OR'd together with theaH !  DTK$M_SQUARE bit mask and assigned to the variable "NEW_MODE".  Next,E !  the default speaking voice and speaking rate are selected for the eN !  application.  The comma pause and period pause are set to DECtalk defaults.J !  Other voice can be selected for the default speaking voice by modifyingE !  the variable "voice".  Likewise, a different speaking rate can be aL !  specified by changing the static variable "speaking_rate".  Finally, the J !  user dictionary is loaded (by invoking "load_dictionary").  Note, otherE !  application specific parameters should also be initialized in this ! !  subroutine if the need arises.M !(  " FUNCTION LONG initialize_dectalk()  ,     EXTERNAL LONG CONSTANT	    STS$M_SUCCESS.     EXTERNAL LONG FUNCTION	    DTK$SET_MODE, & 				    DTK$SET_VOICE, & 				    load_dictionarys  .     COMMON (constants)		    STRING time_45_sec  ;     COMMON (dt_features)	    LONG   voice, speaking_rate, &_ 					   comma_pause_duration, &n  					   period_pause_duration, & 					   speech_on, new_model3     COMMON (application_specific)   LONG   voice_ido       CALL set_timer(Time_45_sec)o.     stat% = DTK$SET_MODE(voice_id, new_mode, )     CALL cancel_timer %     IF (stat% AND STS$M_SUCCESS) = 0%c     THEN 	CALL error_log(stat%)5 	CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 
     END IF     !v3     !  Indicate the type of voice and speaking rate      !e     CALL set_timer(Time_45_sec) :     stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate &1 				,comma_pause_duration, period_pause_duration)s     CALL cancel_timert%     IF (stat% AND STS$M_SUCCESS) = 0%n     THEN 	CALL error_log(stat%)5 	CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 
     END IF     !m;     ! load user dictionary using "load_dictionary" function      !G(     initialize_dectalk = load_dictionary     EXIT FUNCTION  END FUNCTION  M !------------------------------ get_key_string ------------------------------uN !  Gets a series of touch tone keys entered on the telephone keypad terminatedL !  by a pound sign (#) or an asterisk (*).  Returns SUCCESS if the series ofN !  touch tone keys was received successfully.  Otherwise, FAILURE is returned. !	M FUNCTION LONG get_key_string(STRING prompt,LONG timeout,LONG terminator_code)(   %INCLUDE "DTKDEF"u  /     EXTERNAL LONG FUNCTION	  DTK$READ_KEYSTROKEm+     EXTERNAL LONG CONSTANT	  SS$_TIMEOUT, &4 				  SS$_NORMAL, &  				  DTK$_WINK   H     COMMON (constants)		  STRING time_45_sec, time_6_min, time_16_min, & 				  LONG	 MAX_ENTRY, T1SECOND3  3     COMMON (application_specific) LONG	 voice_id, &O 					 num_hold_keys, & 					 num_input_keys, &s 				  BYTE	 hold_key_buf(80), &d 					 input_key_buf(80)o  E     DECLARE LONG  read_key_buf, hold_buf_ptr, ad_timeout, loc_timeoutE       loc_timeout = timeout$     IF num_hold_keys > 0%i     THEN 	!E 	!  There are Touch Tone keys in the typeahead buffer (hold_key_buf). B 	!  The routine "read_advance_keys" is called here to read any newA 	!  keys pressed.  This is used mainly to read and process winks.hF 	!  The "keys" stored in the typeahead buffer are moved into the input? 	!  buffer "input_key_buf" up to any terminator character.  ThehH 	!  terminator character is put in "terminator_value", and any remainingG 	!  characters left in the typeahead buffer are copied to the front of m 	!  the buffer.n 	! 	ad_timeout = 1% 	GOSUB read_advance_keys! 	hold_key_buf(num_hold_keys) = 0%i 	hold_buf_ptr = 0%@ 	WHILE hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_NUMBER_SIGN AND &8 		      hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_ASTERISK  ' 	    IF hold_key_buf(hold_buf_ptr) = 0% 	 	    THEN  		num_hold_keys = 0% 		GO TO read_key 	    END IFn? 	    input_key_buf(num_input_keys) = hold_key_buf(hold_buf_ptr) ) 	    num_input_keys = num_input_keys + 1%_% 	    hold_buf_ptr = hold_buf_ptr + 1%i 	NEXTh- 	terminator_code = hold_key_buf(hold_buf_ptr),! 	hold_buf_ptr = hold_buf_ptr + 1%m 	num_hold_keys = 0%i 	!< 	!  Recopy the remaining keys in the typeahead buffer to theB 	!  beginning of the buffer.  If the terminating keycode was a "#"B 	!  or "*", skip over it and start recopying with the next keycode 	!& 	UNTIL hold_key_buf(hold_buf_ptr) = 0%; 	    hold_key_buf(num_hold_keys)=hold_key_buf(hold_buf_ptr)E' 	    num_hold_keys = num_hold_keys + 1%o' 	    hold_buf_ptr  = hold_buf_ptr  + 1%  	NEXT  	GO TO process_entry
     END IF     IF LEN(prompt) > 1%d     THEN 	!8 	!  This test assumes no 1 character prompts are sent to9 	!  DECtalk.  Prompts of 1 char will be passed over here.s 	!$ 	CALL speak_text(DTK$K_WAIT, prompt)
     END IF
  read_key:     WHILE 1% = 1%d 	!> 	!  Read all keys entered on the touch tone keypad by the user@ 	!  and store them in the typeahead buffer "hold_key_buf". First= 	!  a watchdog timer must be set before any keys can be read.p 	!         s 	CALL set_timer(Time_45_sec)B 	stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , loc_timeout) 	CALL cancel_timer 	IF stat% = SS$_NORMAL 	THENC2 	    IF (read_key_buf = DTK$K_TRM_NUMBER_SIGN OR &, 			       read_key_buf = DTK$K_TRM_ASTERISK)	 	    THENa 		!o) 		!  Received key string terminator ("#") 0 		!  so reception of keystring is completed. Use/ 		!  a short timeout to gather up any remaining ) 		!  touch tone keys entered by the user.( 		!d  		terminator_code = read_key_buf 		ad_timeout = 2%s 		GOSUB read_advance_keyse 		GO TO process_entryi	 	    ELSEi. 		input_key_buf(num_input_keys) = read_key_buf& 		num_input_keys = num_input_keys + 1% 		loc_timeout = 10%e 	    END IFn 	ELSE IF stat% = SS$_TIMEOUT	 	    THENt 		EXIT read_keyd 	    ELSE IF stat% = DTK$_WINK 		THEN 		    !i0 		    !  DECtalk detected a wink which sometimes2 		    !  indicates that the user has hungup.  This2 		    !  demonstration program assumes that a WINK. 		    !  does indicate the a user has hungup. 4 		    !  Therefore, return so DECtalk can hangup its5 		    !  phone.  If for any reason it is noticed thatw5 		    !  spontaneous winks are occurring and the usera2 		    !  at the other end of the telephone did not2 		    !  hangup, then DO NOT return. Just continue# 		    !  receiving touch tone keys.S 		    !L 		    CALL error_log(stat%)B 		    get_key_string = 0%   		    EXIT FUNCTION 		ELSE 		    CALL error_log(stat%)T# 		    CALL LIB$STOP(stat% BY VALUE)o 		END IF 	    END IFa 	END IFk     NEXT     ! J     !  No keystring terminator ("#" or "*") entered so set the terminatingF     !  keycode to DTK$K_TRM_TIMEOUT.  Otherwise, return all touch toneH     ! keys entered. Finally, recopy any remaining touch tone keys in the@     !  typeahead buffer (ttkeys) to the beginning of the buffer.
     !     '     terminator_code = DTK$K_TRM_TIMEOUTd    PROCESS_ENTRY:_$     hold_key_buf(num_hold_keys) = 0%     CALL restart     get_key_string = 1%t     EXIT FUNCTIONt    READ_ADVANCE_KEYS:n     !eJ     !  Read any keys from DECtalk into the typeahead buffer "hold_key_buf"     !i
     WHILE 1=1  	CALL set_timer(Time_45_sec)A 	stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , ad_timeout)  	CALL cancel_timer 	IF stat% = SS$_NORMAL 	THEN_/ 	    hold_key_buf(num_hold_keys) = read_key_buf ' 	    num_hold_keys = num_hold_keys + 1%T 	ELSE IF stat% = SS$_TIMEOUT% 	    THEN				! no key pressed: return  		RETURN 	    ELSE IF stat% = DTK$_WINK 		THEN				! Hung up?  exit 		    CALL error_log(stat%)e 		    get_key_string = 0%  		    EXIT FUNCTIONa 		ELSE 		    CALL error_log(stat%) # 		    CALL LIB$STOP(stat% BY VALUE)_ 		END IF 	    END IF_ 	END IF(     NEXT END FUNCTION      K !------------------------------ menu --------------------------------------uF !  Prompts the user for a command and receives the command (touch toneI !  key) from the user.  Note, the command will be accepted whether or not(D !  it is terminated with the pound key "#".  However, if the commandF !  is not followed by the pound key, the command will not be processedN !  until the timeout period has expired and a warning message has been spoken.L !  When commands are received, the routine "process_menu_entry" is performed  !  to implement the menu choice. !E
 SUB menu()   %INCLUDE "DTKDEF"u  *     EXTERNAL LONG CONSTANT	  STS$M_SUCCESS-     EXTERNAL LONG FUNCTION	  DTK$SET_VOICE, &  				  get_key_string, &  				  vendor_change, & 				  custom_service, &- 				  field_service, & 				  distribution  7     COMMON (MESSAGE_TEXT)	  STRING msg_invalid  = 40, &e 					 msg_bad_command   = 40, &u! 					 msg_no_terminator  = 100, &b 					 msg_timeout  = 50, & 					 customer_service = 160  H     COMMON (constants)		  STRING time_45_sec, time_6_min, time_16_min, &* 				  LONG	 MAX_ENTRY, T1SECOND, T20SECOND  8     COMMON (dt_features)	  LONG	 voice, speaking_rate, & 					 comma_pause_duration, &a 					 period_pause_duratione  3     COMMON (application_specific) LONG	 voice_id, &r 					 num_hold_keys, & 					 num_input_keys, &  				  BYTE	 hold_key_buf(80), &  					 input_key_buf(80)e    K     main_menu$  = "To select your primary long distance vendor, press 1, "& = 		+ "followed by the pound-key.  To order a custom-calling "& = 		+ "service, press 2, followed by the pound-key.  To hear "&t= 		+ "a field-service application, press 3, followed by the "&t8 		+ "pound-key.  To hear a distribution-demostration, "&< 		+ "press 4, followed by the pound-key.  To hear DECtalk "&A 		+ "product-information, press 5, followed by the pound-key.  "&,8 		+ "To repeat this message, Press 0, followed by the "&/ 		+ "pound-key.  To exit, Press the star-key. "   N     dtcfamily$	= "[+] The [`]DECtalk [`]Voice Response-System is the latest "&> 		+ "addition to Digital's Voice solutions. It features the "&> 		+ "performance of the MicroVAX 2, plus the flexibility of "&A 		+ "the foremost voice synthesis product on the market today. "&i; 		+ "The [`]DECtalk [`]Voice Response-System is sized to "& : 		+ "support from 2 to 32 DEctalk lines.  It is ideally "&; 		+ "suited to front end large data-bases. Packaged with "&F> 		+ "the [`]DECtalk [`]Voice Response-System is the DECtalk "&@ 		+ "Application Development-Guide.  This guide consists of a "&< 		+ "user's manual and sample application-software. It is "&= 		+ "designed to significantly reduce the time required to "& ; 		+ "develop a voice response application for any of the "&C< 		+ "DECtalk products. DECtalk component products include "&? 		+ "Dual-Line DECtalk, a two-line subsystem, and Multi-line "&n@ 		+ "DECtalk, an eight-line subsystem, both of which are rack "&@ 		+ "mountable. In addition, the DECtalk board can be used to "&; 		+ "expand the number of lines needed.  [+] Single line "& A 		+ "DECtalk is a table-top unit with a built-in loud-speaker. "& > 		+ "It is best for [st'aend#axl`own] applications, such as "&= 		+ "aids for the handicapped. It is also commonly used in "& : 		+ "manufacturing, for [m'aonaxtaxrixnx] status on the "&= 		+ "factory floor. [+] All DECtalk products appropriately "&F< 		+ "pronounce commonly occurring forms, such as numbers, "&/ 		+ "money, abbreviations, dates, times, and "&_ 		+ "[paxnxkchuw'eyshaxn]. "  6     DECLARE	LONG	terminator_value, illegal_entry_count       null_char$ = X'00'CG     terminator_value = 0%      illegal_entry_count = 0%K     WHILE (input_key_buf(0) <> 0% OR terminator_value <> DTK$K_TRM_TIMEOUT)  	!> 	! Keep getting commands from the user until the exit key "*",A 	! is entered, a wink is detected, or the timeout period expires.oG 	! First, check if there are any keys in the typeahead buffer (done by  D 	! "get_key_string" with a 1 second timeout).  If so, process them. F 	! Otherwise, prompt the user for a command and wait for his response. 	! GET_SHORT_READ:a 	num_input_keys = 0% 	input_key_buf(0) = 0%F         stat% = get_key_string(null_char$, T1SECOND, terminator_value)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENe* 	    EXIT SUB				    ! Fatal error so exit 	END IFt) 	IF terminator_value = DTK$K_TRM_ASTERISKs 	THENn' 	    EXIT SUB				    ! User said hangupr3 	ELSE IF (terminator_value = DTK$K_TRM_NUMBER_SIGN)S	 	    THENa9 		GOSUB process_menu_entry	    ! Valid command so process ( 		IF (input_key_buf(0) = DTK$K_TRM_ZERO) 		THEN 		    GO TO get_long_read  		ELSE 		    GO TO get_short_read 		END IF: 	    ELSE IF ((terminator_value <> DTK$K_TRM_TIMEOUT) OR	&6 	        	 (terminator_value = DTK$K_TRM_TIMEOUT AND &$ 					        input_key_buf(0) = 0%)) 		!e9 		!  No keys in typeahead buffer so prompt for a command.+ 		!  		THEN- 		    CALL speak_text(DTK$K_WAIT, main_menu$)a 		END IF 	    END IF( 	END IFp 	!A 	!  Any new keys received should be processed after the keys read B 	!  from the typeahead buffer.  Start storing touch tone keys intoF 	!  into the buffer following the keys read from the typeahead buffer. 	! GET_LONG_READ: 	num_input_keys = 0%G         stat% = get_key_string(null_char$, T20SECOND, terminator_value)(" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN & 	    EXIT SUB				! Fatal error so exit 	END IFl) 	IF terminator_value = DTK$K_TRM_ASTERISKG 	THENo# 	    EXIT SUB				! User said hangupo4 	ELSE IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				    input_key_buf(0) <> 0%) 	 	    THENr( 		CALL speak_all_text(msg_no_terminator)9 		GOSUB process_menu_entry	! Valid command so process it	a8 	    ELSE IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) = 0%) 		THEN& 		    CALL speak_all_text(msg_timeout) 		    EXIT SUB 		ELSE 		    GOSUB  process_menu_entrys 		END IF 	    END IFb 	END IF     NEXT      EXIT SUB PROCESS_MENU_ENTRY:s !%> !  Processes the touch tone key string received from the user. !      IF num_input_keys > 1%     THEN 	!< 	!  Only single key commands are valid in this menu.  Inform< 	!  the user that an invalid command was entered and return. 	!% 	CALL speak_all_text(msg_bad_command) / 	illegal_entry_count = illegal_entry_count + 1%      ELSE         SELECT	input_key_buf(0) 5 	    CASE = DTK$K_TRM_ZERO		    ! Speak menu help msge) 		CALL speak_text(DTK$K_WAIT, main_menu$)= 		illegal_entry_count = 0%  8 	    CASE = DTK$K_TRM_ONE		    ! Select long dist vendor 		stat% = vendor_changeb# 		IF (stat% AND STS$M_SUCCESS) = 0%  		THEN 		    EXIT SUB 		END IF 		illegal_entry_count = 0%  5 	    CASE = DTK$K_TRM_TWO		    ! Order custom service% 		stat% = custom_service# 		IF (stat% AND STS$M_SUCCESS) = 0%k 		THEN 		    EXIT SUB 		END IF 		illegal_entry_count = 0%  5 	    CASE = DTK$K_TRM_THREE		    ! Field service demoK 		stat% = field_servicet# 		IF (stat% AND STS$M_SUCCESS) = 0%e 		THEN 		    EXIT SUB 		END IF 		illegal_entry_count = 0%  4 	    CASE = DTK$K_TRM_FOUR		    ! distribution demo	 		stat% = distribution# 		IF (stat% AND STS$M_SUCCESS) = 0%f 		THEN 		    EXIT SUB 		END IF 		illegal_entry_count = 0%  6 	    CASE = DTK$K_TRM_FIVE		    ! dectalk product info) 		CALL speak_text(DTK$K_WAIT, dtcfamily$)_ 		illegal_entry_count = 0%   	    CASE ELSE* 		CALL speak_text(DTK$K_WAIT, msg_invalid)0 		illegal_entry_count = illegal_entry_count + 1% 	END SELECT 
     END IF     ! I     !  check status from menu fuctions -- If bad status (wink) exit menu.      !e%     IF (stat% AND STS$M_SUCCESS) = 0%r     THEN	 	EXIT SUB 
     END IF     num_input_keys = 0%e     ! E     ! If user enters 3 illegal/incorrect commands, speak help messagen     !e     IF illegal_entry_count >= 3l     THEN( 	CALL speak_text(DTK$K_WAIT, main_menu$) 	illegal_entry_count = 0%r
     END IF
     RETURN END SUB=  M !---------------------------- load_dictionary -------------------------------eF !  Load the user dictionary with the words and phonemic pronunciationsF !  stored in the sequential file specified in the foreign command lineH !  invoking the program.  Each line of this file contains the word to beF !  defined in the user dictionary followed by a space, followed by theH !  phonemic pronunciation of the word.  The entry is parsed to find the M !  start and finnish of the word and it's replacement.  The word and phonemic"L !  pronunciation are loaded into the user dictionary. If the load dictionaryM !  command fails, the user is notified and processing is terminated.  ReturnseL !  SUCCESS if the dictionary is loaded successfully or if no user dictionary; !  file name is specified.  Otherwise, FAILURE is returned.    FUNCTION LONG load_dictionary()    %INCLUDE "DTKDEF"S  0     EXTERNAL LONG FUNCTION	  DTK$LOAD_DICTIONARY*     EXTERNAL LONG CONSTANT	  SS$_NORMAL, & 				  DTK$_TOOLONG, &  				  DTK$_NOROOMe  8     COMMON (constants)		  STRING time_45_sec, time_6_min  3     COMMON (application_specific) LONG	 voice_id, &  					 num_hold_keys, & 					 num_input_keys, &o 				  BYTE	 hold_key_buf(80), &= 					 input_key_buf(80), && 				  STRING dictionary_file_name = 80  5     MAP (dictionary)		  STRING dictionary_entry = 256 .     DECLARE			  STRING diction_word,  phonetic-     DECLARE			  LONG   word_count, phonem_end	       sp$ = X'20'C     tab$ = X'09'Cd     null_char$ = X'00'CO     ON ERROR GOTO ERROR_CHECKGJ     IF LEFT$(dictionary_file_name,1) = null_char$	! No dictionary filename     THEN 	!4 	!  No dictionary was specified in the command line.! 	!  Return to initialize_dectalk s 	! 	load_dictionary = 1%  	exit function
     END IFD     OPEN dictionary_file_name AS FILE #1,	ORGANIZATION SEQUENTIAL, &! 						ACCESS READ, MAP DICTIONARYa     !sH     ! Since there is no timeout associated with the DTK$LOAD_DICTIONARY F     ! command, it is possible for an application to hang waiting for aI     ! response after issuing the DTK$LOAD_DICTIONARY command.  Therefore,pJ     ! arm a watchdog timer (6 minutes in this case) to time the loading ofJ     ! the entire user dictionary.  If all the entries are not loaded into D     ! the user dictionary before the timer expires, then assume that:     ! something is wrong with the DECtalk module and exit.     ! >     CALL set_timer(time_6_min)			! Set system (watchdog) timer     WHILE 1% = 1%c 	GET #1m 	!  3 	!  Read in all of the words and substitutions fromt8 	!  the sequential file specified in the command string. 	!+ 	word_count = POS(dictionary_entry, sp$, 1)r 	IF word_count = 0%e 	THEN		F0 	    word_count = POS(dictionary_entry, tab$, 1) 	END IFl2 	phonem_end = POS(dictionary_entry, null_char$, 1)7 	diction_word = SEG$(dictionary_entry, 1, word_count-1)t> 	phonetic = SEG$(dictionary_entry, word_count+1, phonem_end-1)> 	stat% = DTK$LOAD_DICTIONARY(voice_id, DICTION_WORD, phonetic)1 	IF (stat% = DTK$_TOOLONG OR stat% = DTK$_NOROOM)k 	THENe 	     !t9 	     !  These are not generally fatal errors.  However,  : 	     !  they will be treated as such.  In creating a demo9 	     !  program, if words cannot be loaded into the userD> 	     !  dictionary, the programmer should be notified so that@ 	     !  the appropriate action can be taken.  By treating these? 	     !  errors as fatal, the programmer will at least know theo7 	     !  point in the program where the error occurred.e 	     !a
 	    CLOSE #1e 	    CALL error_log(stat%) 	    load_dictionary = 0%t* 	    EXIT FUNCTION			! Fatal error so exit/ 	ELSE IF (stat% <> SS$_NORMAL)		! Fatal failurec	 	    THENu, 		CALL cancel_timer		! Cancel watchdog timer
 		CLOSE #1 		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exita 	    END IFl 	END IFy     NEXT     !l:     !  Entire dictionary is loaded so cancel system timer.     !n DONE: 2     CALL cancel_timer				! Cancel (watchdog) timer(     CLOSE #1					! Close dictionary file     load_dictionary = 1%
 EXIT FUNCTION    ERROR_CHECK:-     IF ERR = 11%				! IF End of File is foundi     THEN 	RESUME DONE     ELSE 	CALL error_log(VMSSTATUS) 	RESUME HERE HERE:y 	load_dictionary = 0%  	EXIT FUNCTION
     END IF END FUNCTION  K !------------------------------- restart ---------------------------------- G !  DECtalk stopped speaking because it was in autostop keypad mode when F !  it received a Touch Tone Key from the user.  First, send DECtalk a J !  right square bracket "]" just in case speech was stopped while speakingL !  phonemic text. Then, restart speech (using DTK$SET_SPEECH_MODE) and reset5 !  the speaking voice and rate (using DTK$SET_VOICE).l !=
 SUB restart()E   %INCLUDE "DTKDEF"   *     EXTERNAL LONG CONSTANT	  STS$M_SUCCESS3     EXTERNAL LONG FUNCTION	  DTK$SET_SPEECH_MODE, &) 				  DTK$SET_VOICE   M     COMMON (constants)            STRING time_45_sec, time_6_min, time_16_mini9     COMMON (dt_features)	  LONG   voice, speaking_rate, &t 					 comma_pause_duration, &D* 			    		 period_pause_duration, speech_on0     COMMON (application_specific) LONG	 voice_id       rsbracket$    = "]"   ;     DECLARE LONG old_mode			    ! Current mode before resetE  ,     CALL speak_text( DTK$K_WAIT, rsbracket$)     !b     !  Set speaking on     !      CALL set_timer(Time_45_sec) >     stat% = DTK$SET_SPEECH_MODE(voice_id, speech_on, old_mode)     CALL cancel_timere%     IF (stat% AND STS$M_SUCCESS) = 0%      THEN 	CALL error_log(stat%)5 	CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exitl
     END IF     !D(     !  Reset the voice and speaking rate     !F     CALL set_timer(Time_45_sec) ;     stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate, &	0 				comma_pause_duration, period_pause_duration)     CALL cancel_timerD%     IF (stat% AND STS$M_SUCCESS) = 0%      THEN     	CALL error_log(stat%)5 	CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exitd
     END IF END SUB   M !------------------------------ end_call ------------------------------------ D !  End the current user session.  Since the DTK$HANGUP_PHONE commandB !  does not set a timeout, and it requests DECtalk to send a phoneF !  status, a watchdog timer is set to insure that the application doesF !  not hang (if DECtalk fails).  If a longer timeout period is needed,G !  adjust the value of the parameter moved into SET_TIMER_STRING beforenL !  performing "set_timer".  After the watchdog timer is set, speak a goodbyeH !  message to the caller and then hangup the phone.  The goodbye messageA !  spoken can be changed by modifying the text in "msg_goodbye". T !_ SUB end_call ()p  -     EXTERNAL LONG CONSTANT	  STS$M_SUCCESS, &  				  SS$_TIMEOUT, & 				  DTK$_ONHOOK   1     EXTERNAL LONG FUNCTION 	  DTK$HANGUP_PHONE, &e 				  DTK$READ_KEYSTROKE  M     COMMON (constants)            STRING time_45_sec, time_6_min, time_16_minl0     COMMON (application_specific) LONG	 voice_id  I     msg_goodbye$  = "Thank you for calling the DECtalk-demonstration.  "&$B 		  + "For more information, please call 1, 800, 8 3 2, 6 2 7 7. "  >     CALL set_timer(time_6_min)			! Set system (watchdog) timer     !t'     !  Say goodbye and hangup the phone$     !S4     stat% = DTK$HANGUP_PHONE(voice_id, msg_goodbye$).     CALL cancel_timer				! Cancel system timer%     IF (stat% AND STS$M_SUCCESS) = 0%t     THEN 	CALL error_log(stat%)5 	CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exita
     END IF     ! 1     !  Workaround to clear the internal WINK flag      !	     timeout% = 1%$     WHILE 1% = 1%_B         CALL set_timer(time_45_sec)		! Set system (watchdog) timer=         stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%)o1         CALL cancel_timer			! Cancel system timerc9         IF (stat% = DTK$_ONHOOK) OR (stat% = SS$_TIMEOUT)          THEN9 	    CALL set_timer(time_45_sec)		! Set system (watchdog)U: 	    stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%). 	    CALL cancel_timer			! Cancel system timer& 	    IF (stat% AND STS$M_SUCCESS) = 0%	 	    THEN  	        CALL error_log(stat%)< 	        CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	    END IF  	    EXIT SUB		-  ' 	ELSE IF (stat% AND STS$M_SUCCESS) = 0%-	 	    THEN- 	        CALL error_log(stat%)< 	        CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	    END IFs 	END IF      NEXT END SUBh  J !----------------------------- speak_all_text ----------------------------I !  Speak all text -- disable autostop keypad, speak text in prompt using f9 !  "speak_text". If autostop was set, re-enable autostop._ !(" SUB speak_all_text (STRING prompt)   %INCLUDE "DTKDEF"r  *     EXTERNAL LONG CONSTANT	  STS$M_SUCCESS0     EXTERNAL LONG FUNCTION	  DTK$SET_KEYPAD_MODE  M     COMMON (constants)            STRING time_45_sec, time_6_min, time_16_minl9     COMMON (dt_features)	  LONG   voice, speaking_rate, & $ 				         comma_pause_duration, & 					 period_pause_duration, &, 					 speech_on, new_mode, number_of_rings,& 					 keypad_modei0     COMMON (application_specific) LONG	 voice_id       DECLARE			  LONG	 keypad_onp       keypad_on = DTK$K_KEYPAD_ONn     ! I     !  If autostop keypad mode is enabled (keymode = DTK$K_KEYPAD_AUTO), e4     !  then enable the keypad without autostop mode.     !cF     IF (keypad_mode = DTK$K_KEYPAD_AUTO)	! Keypad is in autostop mode	     THEN7 	CALL set_timer(Time_45_sec)		! Set the watchdog timer	e5     	stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_on)I5     	CALL cancel_timer			! Cancel the watchdog timer	 " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENU 	    CALL error_log(stat%)" 	    CALL LIB$STOP(stat% BY VALUE) 	END IF 
     END IF     ! +     !  Send text to DECtalk to be spoken.  t@     !  Specify the mode as DTK$K_WAIT so that text is completely?     !  spoken before the keypad is re-enabled in autostop mode.u     ! '     CALL speak_text(DTK$K_WAIT, prompt)	     !_*     !  If autostop keypad mode was enabled<     !  (keypad_mode = DTK$K_KEYPAD_AUTO), then re-enable it.     ! G     IF (keypad_mode = DTK$K_KEYPAD_AUTO)	! Keypad was in autostop mode	r     THEN4 	CALL set_timer(Time_45_sec)		! Set watchdog timer		3 	stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_mode)G1 	CALL cancel_timer			! Cancel the watchdog timer		" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  	    CALL error_log(stat%)" 	    CALL LIB$STOP(stat% BY VALUE) 	END IFe
     END IF END SUB_  N !--------------------------- speak_text --------------------------------------- !  Sends the prompt (specified by prompt) to R0 !  the DECtalk to be spoken.  Returns SUCCESS if= !  everything is spoken o.k.  Otherwise, FAILURE is returned.m !  i6 !  NOTE:  If DTK$SPEAK_TEXT is called with mode set to7 !	   DTK$K_WAIT or DTK$K_STATUS, a phone status requesta@ !	   is sent from DECtalk.  Since there is no timeout associated= !	   with this request, a system timer should be set (to someIF !	   exteremely long value (16 minutes) to insure that the application !	   does not hang.h !a7 SUB speak_text (LONG return_status_mode, STRING prompt)u   %INCLUDE "DTKDEF"   -     EXTERNAL LONG CONSTANT	  STS$M_SUCCESS, &t 				  SS$_NORMAL+     EXTERNAL LONG FUNCTION	  DTK$SPEAK_TEXTl  E     COMMON (constants)		  STRING time_45_sec, time_6_min, time_16_min   0     COMMON (application_specific) LONG	 voice_id       !y     !  Speak the textu     !e?     CALL set_timer(time_16_min)			! Set system (watchdog) timerD@     stat% = DTK$SPEAK_TEXT(voice_id, prompt, return_status_mode).     CALL cancel_timer				! Cancel system timer     IF (stat% <> SS$_NORMAL)     THEN 	CALL error_log(stat%)5 	CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exitp
     END IF END SUB=  N !----------------------------- log_error -------------------------------------. !	Log error to the operator console  "OPER11". !iM !  Take the error number, input to SYS$GETMSG to get the system message text.eO !  Format the message text with the specific terminal line for that application K !  "process" (using SYS$FAO), and call SYS$SENOPR with the error structure.  !eG !  NOTE:  the DTK$ errors that occur will have the %DTK- facility name, A !	  but not the error message text, just the error number.  It is F !	  anticipated that these messages will be included in future VMS/RTLE !	  releases.  Also, for this demo, error message WILL NOT be writtenrB !	  to the operator terminal since OPCOM is not always running on - !	  all systems, especially MicroVMS systems.( !t  SUB error_log(LONG error_number)  A %INCLUDE "$OPCDEF" %FROM %LIBRARY "SYS$LIBRARY:BASIC$STARLET.TLB"i  '     EXTERNAL LONG CONSTANT	  SS$_NORMALO'     EXTERNAL LONG FUNCTION	  SYS$FAO, &w 				  SYS$SNDOPR, &L 				  SYS$GETMSG  3     COMMON (application_specific) LONG	 voice_id, &O 					 num_hold_keys, & 					 num_input_keys, &o  				  BYTE	 hold_key_buf(80) , & 					 input_key_buf(80), &) 				  STRING dictionary_file_name = 80, &a 					 terminal_lineE  H     MAP	(error_struct)		  LONG   opc$type_target,LONG OPC$L_MS_RQSTID, & 				  STRING error_text = 120-0     MAP	(error_struct)		  STRING error_msg = 128(     MAP (temp)			  STRING error_buf = 80  -     DECLARE STRING CONSTANT filler = "  ON  "s5     DECLARE STRING CONSTANT control_str = "!AD!AS!AD"e     DECLARE LONG	    buf_len       P     temp% = SYS$GETMSG(error_number by value, buf_len, error_buf, 15% by value,)     !nD     ! Set message target to OPER11, and the message type to RQ_RQST.G     ! For more information on sending messages to an operators terminalL%     ! see the System Services manual.      !T>     opc$type_target = (OPC$M_NM_OPER11 * 256%) OR OPC$_RQ_RQST7     temp% = SYS$FAO(control_str, buf_len, error_text,	& ,  		    buf_len by value, error_buf by ref,	&1  		    filler, 5% by value, terminal_line by ref),4     WHILE MID$(error_text, buf_len + 1, 1) <> X"00"C+  	MID$(error_text, buf_len + 1, 1) = X"00"CL  	buf_len = buf_len + 1      NEXT. !   stat% = SYS$SNDOPR(error_msg, 0% by value) !   IF (stat% <> SS$_NORMAL)		 !   THEN  !	CALL LIB$STOP(stat% BY VALUE)	 !    END IF  END SUBt  K !----------------------------- set_timer ---------------------------------- I !  Sets the system (watchdog) timer to expire "sec" seconds in the futureCH !  by invoking the "SYS$SETIMR" system service.  SYS$BINTIM is passed a K !  character string in the format "D HH:MM:SS", where D is Days, H is HourssG !  M is minutes etc.  The output of BINTIM is the quadword delta_time ,o. !  which gets passed as input to SYS$SETIMR.   !L! SUB set_timer(STRING time_string)T  +     EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &o 				SS$_TIMEOUTI(     EXTERNAL LONG FUNCTION	SYS$SETIMR, & 				SYS$BINTIM=     EXTERNAL LONG		LIB$SIGNAL 	! Indicate exception condition-  )     MAP (quadword) LONG		delta_time, FILLe  /     stat% = SYS$BINTIM(time_string, delta_time)d&     IF (stat% AND STS$M_SUCCESS)  = 0%     THEN 	CALL error_log(stat%)4 	CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit
     END IFN     stat%= SYS$SETIMR( ,delta_time, LIB$SIGNAL BY VALUE, SS$_TIMEOUT BY VALUE)&     IF (stat% AND STS$M_SUCCESS)  = 0%     THEN 	CALL error_log(stat%)4 	CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit
     END IF END SUBm  O !---------------------------- cancel_timer ------------------------------------ # !  Cancel the system watchdog timerm !g SUB cancel_timer()  (     EXTERNAL LONG CONSTANT	STS$M_SUCCESS'     EXTERNAL LONG FUNCTION	SYS$CANTIM		   9     stat% = SYS$CANTIM(SS$_TIMEOUT BY VALUE, 0% BY VALUE)P%     IF (stat% AND STS$M_SUCCESS) = 0%      THEN     	CALL error_log(stat%)4 	CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit
     END IF END SUB 