                               1       INTRODUCTION   B               This manual describes how to use DECtalk with a hostJ               computer. The text explains the escape sequences you can use               with DECtalk.   J               Terminals display information from a computer on a screen orJ               paper; they provide communication with computers through theH               sense of sight. DECtalk speaks information from a computerJ               in an English-language voice; it provides communication with5               computers through the sense of hearing.   J               The DECtalk DTC01 Owner's Manual (EK-DTC01-OM) describes howA               to use DECtalk connected to a terminal. This manual H               describes how to use DECtalk connected to a host computer.  I               Chapter 1 describes how DECtalk can communicate with a host I               computer through computer application programs. The chapter F               also describes some guidelines for writing applications.  A               Chapter 2 describes the setup escape sequences that =               initialize and control the DECtalk environment. K                                                                          1                  J               Chapter 3 describes how to use voice commands, send phonemic<               text to DECtalk, and load the user dictionary.  G               Chapter 4 describes how DECtalk works when connected to a                 telephone network.  H               Chapter 5 describes the maintenance and debugging commands#               used to test DECtalk.   J               Chapter 6 provides a detailed application program written in@               C programming language. You can copy this program.  G               Chapter 7 provides a sample program written in BASIC-PLUS >               programming language. You can copy this program.  H               The appendices summarize the DECtalk escape sequences, theE               phonemic alphabet used, and the other available DECtalk                documentation.          
            2                              1       HOW DECtalk&                    PROGRAMMING WORKS 1  H               This chapter gives you an overview of DECtalk programming.2               The chapter has four major sections.  I               o  "Communicating with DECtalk" describes the types of data J                  DECtalk can receive and the operation modes DECtalk uses.  F               o  "Escape Sequenes and Control Characters" explains theJ                  basic format for entering commands with escape sequences.H                  This section includes a table of the control characters)                  that DECtalk recognizes.   J               o  "DECtalk-Computer Communication" lists some special rulesC                  DECtalk follows when processing text. This section B                  describes how escape sequences affect the flow ofE                  information between DECtalk, a local terminal, and a :                  computer. The section also describes data!                  synchronization.     K                                                                          3                  H               o  "Developing Your Application" provides sonme guidelinesJ                  for writing application dialog and encoding your program.  (               COMMUNICATING WITH DECtalk  A               DECtalk is an intelligent peripheral device, so the )               following guidelines apply.   G               o  You cannot program DECtalk directly. After the initial E                  power-up operations, DECtalk is controlled through a +                  terminal or host computer.   I               o  DECtalk is easy to control, because the internal DECtalk E                  processor is sophisticated enough to process complex 1                  operations with simple commands.   G               o  You can select DECtalk's operation characteristics and G                  have DECtalk answer questions (from the host computer) C                  about its status. DECtalk can also inform the host J                  computer of status changes. For example, DECtalk can tellE                  the host computer if a connected telephone has rung.     
            4                  H               o  DECtalk memory can store some information. For example,@                  DECtalk has an extensive built-in pronunciationI                  dictionary. You can load a user-defined dictionary under "                  computer control.  E               The following paragraphs describe how DECtalk sends and :               receives information from the host computer.                 Types of Data   ?               DECtalk can receive two types of data through its :               communications connector, text and commands.  D               Text is data that DECtalk will speak. Text consists ofI               English-language sentences, phonemically spelled text, or a "               combination of both.  J               Commands are instructions to perform an action. Commands are$               not spoken by DECtalk.      K                                                                          5                  K               There are two ways to send commands--with escape sequences or F               with square brackets []. Some commands you can only sendH               with escape sequences, and some commands you can send both               ways.   I               Escape sequences start with an ESC character, followed by a J               string of ASCII characters. DECtalk interprets the string asJ               a special command. This manual describes the escape sequence)               method of sending commands.   G               Square bracket[] commands let you include speech commands H               and phonemic text with text information, if MODE SQUARE isJ               on. The "Mode Selection" section in Chapter 2 describes MODEG               SQUARE. The DECtalk DTC01 Owner's Manual describes square *               bracket commands and syntax.  J               Appendix B summarizes both command methods. Figure 1-1 showsA               the relationship between terminal commands and host H               commands. This chapter provides more information on escape.               sequence conventions and format.    
            6                                 Operating Modes   E               DECtalk has three operating modes: setup, off-line, and                on-line.  F               You use setup mode to select the operation parameters ofE               DECtalk, such as communication line characteristics and &               phonemic representation.  B               You use off-line mode when DECtalk is connected to aB               terminal. The DECtalk DTC01 Owner's Manual describes               off-line mode.  F               You use on-line mode when DECtalk is connected to a hostJ               computer. Commands must be sent as escape sequences from the               host computer.  I               DECtalk powers up in on-line mode. When you connect DECtalk E               to a terminal for local use, you must switch DECtalk to J               off-line mode; press the BREAK key to enter setup mode, then*               select the off-line setting.    K                                                                          7                  ;               USING ESCAPE SEQUENCES AND CONTROL CHARACTERS   A               This section describes the general syntax of escape :               sequences, and how to use them with DECtalk.                 Escape Sequences  G               In setup mode, you can enter commands directly to DECtalk #               through the terminal.   H               When DECtalk is on-line, you can enter most setup commandsI               plus other on-line commands; however the commands come from H               the computer instead of the terminal. For example, you canB               only load the user-defined dictionary while on-line.  D               On-line and setup commands act the same, but they have>               different formats. For example, the user command  +                    SETUP>SET LOG PHONEME ON   ;               is sent from a computer as an escape sequence   '               ESC P O ; 8 1 ; 2 z ESC \   
            8                  D               You can omit parameters with a value of 0 (ASCII). ForI               example, you could send the above sequence as ESC P ; 8 1 ; I               2 z ESC \. DECtalk does not send parameters with a value of '               0 in its reply sequences.   J               NOTE: Escape sequences in this manual are spaced for clarityG               only. Spaces are not part of the actual escape sequences.   J               DECtalk escape sequences have the following characteristics.  2               1  They begin with an ESC character.  G               2  The ESC character is followed by ASCII characters that $                  define the command.  F               3  Every character in the command is important. You mustF                  enter the exact characters shown. For exalmpl, in theG                  command above, the semicolons are part of the command. D                  The letter z is in lowercase; an uppercase Z has no$                  meaning to DECtalk.      K                                                                          9                  I               4  Programming standards require that you end some commands H                  with a sequence terminator -ESC \. This manual includes9                  ESC \ with all commands that require it.   J               5  Escape sequences only work on the DECtalk host line. ThisF                  is different from most terminals, which can interpret(                  typed escape sequences.  D               The ESC character plus the ASCII characters are like aE               compressed version of the off-line commands. Figure 1-2 J               shows the meaning of each part of a typical escape sequence.  =               DECtalk ignores invalid sequences and commands.   $               Escape Sequence Format  A               The following chapters describe the specific escape C               sequences used with DECtalk. This manual includes the E               following information with all escape sequences (Figure                1-3).                        Mnemonic              10                 $                     ASCII characters                     Parameters!                     Decimal value   J               NOTE: since DECtalk suppresses parameters with a value of 0,J               DECtalk would send ESC P ; 31 P3 Z ESC \ for the sequence inJ               Figure 1-3 (assuming P3 is not 0). If P3 is 0, DECtalk would(               send ESC P ; 31 ; z ESC \.  F               The mnemonic is a unique name (such as DT_INDEX) used toE               identify the escape sequence. Mnemonics do not have any H               direct programming significance; that is, DECtalk does notC               recognize a mnemonic name as a valid escape sequence. H               However, when you refer to escape sequences by mnemonic inH               program documentation and program variables, it simplifies$               editing and debugging.  E               The program examples in Chapter 6 use mnemonics for the G               appropriate escape sequences. The header file DECTLK.H in >               Chapter 6 defines all DECtalk command mnemonics.    K                                                                         11                  H               The ASCII characters are the actual characters to use. TheI               "Escape Sequences" section in this chapter gives an example I               of an escape sequence in ASCII format. The escape character F               is represented by ESC in all sequences. The numbers thatE               appear are actual ASCII characters, not numeric values.   J               Parameters appear in escape sequences that can cause severalJ               DECtalk actions. These different actions depend on parameter               values.   F               Parameters are represented in this manual by a capital PH               followed by a number or letter. Parameters are always sent>               to DECtalk as a decimal number, in ASCII format.  I               An empty parameter is treated like a parameter with a value A               of 0. The sequences ESC P ; z and ESC P 0 ; 0 z are G               identical. DECtalk always sends a 0 parameter as an empty C               string. However, the 0 parameters are always shown as )               explicit zeros in examples.                   12                 J               This manual lists possible parameter values in tables. There<               are two methods used to show parameter values.  I               1  Usually the ASCII character(s) appears (with the decimal I                  value underneath as a check). Use the ASCII character(s) (                  in the escape sequence.  I               2  Sometimes only a numeric value appears. You must convert H                  the numeric value to a sequence of ASCII characters for%                  the escape sequence.   I               The decimal value of each escape sequence character appears J               directly under the character, so you can verify the sequenceD               character. Parameters are marked with asterisks (***),4               indicating that the value is variable.  H               Chapter 2 provides complete tables of all ASCII charactersD               and their decimal, octal, and hexidecimal equivalents.  C               Figure 1-3 shows all the parts of an escape sequence.       K                                                                         13                                  Control Characters  B               Some control characters (such as carriage return andC               backspace) have special meanings. Table 1-1 lists the I               control characters that DECtalk recognizes. DECtalk ignores +               any other control characters.   C               Table 1-1  Control Characters and Host Communications   +                                     Decimal 5               Character   Mnemonic  Value    Function   J               Backspace   BS        008      See "Effect of Backspace (BS)D                                              Character" (Chapter 1).  =               Horizontal  HT        009      Same as a space.                tab   =               Line feed   LF        010      Same as a space.                 14                 <               Table 1-1 (Cont.)  Control Characters and Host/                                  Communications   +                                     Decimal 5               Character   Mnemonic  Value    Function ?               Vertical    VT        011      Clause terminator.                tab   =               Form feed   FF        012      Same as a space.   =               Carriage    CR        013      Same as a space.                return  B               Shift out   SO        014      Used in character setF                                              selection. See "SelectingF                                              Alternate Character Sets"9                                              (Chapter 2).       K                                                                         15                  <               Table 1-1 (Cont.)  Control Characters and Host/                                  Communications   +                                     Decimal 5               Character   Mnemonic  Value    Function B               Shift in    SI        015      Used in character setF                                              selection. See "SelectingF                                              Alternate Character Sets"9                                              (Chapter 2).                                   16                 <               Table 1-1 (Cont.)  Control Characters and Host/                                  Communications   +                                     Decimal 5               Character   Mnemonic  Value    Function E               Substitute  SUB       026      If a communication erroroI                                              occurs, DECtalk replaces theaE                                              bad character with a SUB I                                              character. The SUB character I                                              acts as a clause terminator. B                                              See "DECtalk-ComputerG                                              Communication" (Chapter 1) F                                              for information on clause9                                              terminators.c  H               Escape      ESC       027      Introduces escape sequence.               character       K                                                                         17                  <               Table 1-1 (Cont.)  Control Characters and Host/                                  Communications   +                                     Decimals5               Character   Mnemonic  Value    FunctionhD               Space       SP        032      Normal word terminator.  '               Control Character Logging   H               Version 2.0 of DECtalk firmware improves control characterG               logging. Before version 2.0, some control characters wereEE               not correctly logged. In particular, the CTRL-K (clausefH               flush) control character sequence (generated internally byH               DECtalk), was not logged unless DECtalk received text fromH               the host in 5 seconds. If a heavily loaded system was slowB               to respond, DECtalk might not log the current event.                    18                 J               For example, suppose the host system stopped sending data inI               the middle of a phonemic text string or an escape sequence.rJ               DECtalk woul execute a time-out, exit phonemic text mode (orI               ignore the escape sequence), and fail to log the event. ThenB               result was problems for the application developer in.               tracking control character logs.  I               NOTE: You should enable LOG_INHOST or LOG_RAWHOST to ensuredJ               the proper logging of all characters. See "Local Log ControlD               (DT_LOG)" in Chapter 5 for more information on control                character logging.  4               Effect of the Backspace (BS) Character  I               If DECtalk finds the backspace character in a word, DECtalk A               modifies the word according to the hierarchy of thee.               characters involved, as follows.  #               1  letters and digitsl                 2  punctuation    K                                                                         19                  $               3  underline character  H               The BS character allows DECtalk to process text containing*               overstrikes and underlining.  G               Here are several examples of DECtalk's processing (spaced                for clarity).E(               Input        Pronounced as                 a BS _       a                 _ BS a       a                 a BS b       b                 ab BS BS de  de                  a BS "       a                 a BS " BS _  a                20  e              ,               DECtalk-COMPUTER COMMUNICATION  C               Programming DECtalk is similar to programming a smart G               terminal (such as a VT220). That is, DECtalk and the hostoJ               computer must exchange information according to fixed rules.  I               DECtalk does not process text until reaching a valid clause D               boundary. Clause boundaries mark the end of phrases or@               sentences. DECtalk recognizes the following clause               boundaries.   J               o  A period, comma, exclamation point, or question mark is aH                  valid boundary. If a period is used, DECtalk checks theD                  characters after the period (because periods do not4                  always mean the end of a sentence).  D               o  A full buffer also acts as a boundary. If DECtalk'sG                  temporary buffer begins to approach its fill limit (at H                  about 12 words), DECtalk begins speaking what is in theF                  buffer and treats the last word as a clause boundary.    K                                                                         21d  e              E               o  A timeout is another boundary. If nothing is sent toaI                  DECtak within 5 seconds and there is text in the buffer,uG                  then DECtalk speaks all text in the buffer as though a 3                  comma had been sent with the text.e  H               Escape sequences represent (1) commands sent from the hostI               to DECtalk, and (2) status replies sent from DECtalk to theDH               host. All escape sequences begin with the ESC character; aE               sequence ends when the last character required for thatsI               sequence is sent. Do not use a carriage return or any othermA               normal terminating character to terminate an escape                sequence.   E               Figure 1-4 shows the data paths in DECtalk, as follows.   E               1  The DECtalk unit is in the center of the figure. The.E                  speech processor is part of the DECtalk unit, but is ,                  shown as a seperate module.                    22  r              F               2  Arrows show the direction of information flow. NoticeH                  that information flows from the terminal (or telephone)C                  to the host, and from the host to the terminal (orcI                  telephone). However, information only goes to the speechrJ                  processor from the host or terminal. Information from theF                  speech processor is sent to the telephone or speaker.  A               3  Each DECtalk escape sequence affects the flow ofiG                  information within particular data paths. The switchescH                  within the data paths represent the points at which theF                  escape sequences act. For example, the DT_STOP escapeD                  sequence affects the data flow form the host to the"                  speech processor.  ?               4  Since there are a large number of commands andcI                  parameters, they are grouped in boxes under the diagram.t  @               5  Some commands have parameters (sometimes called@                  arguments). Figure 1-4 shows commands and theirI                  parameters. The parameters (if any) appear after a colon                   (:) mark.  K                                                                         23C  a              A               There are many ways to control and use DECtalk wheneH               connected to a host computer. The rest of this chapter and@               the sample program in Chapter 6 describe a generalJ               programming method for DECtalk. If you are writing a controlE               program for DECtalk, remember that your application and G               needs may not match the descriptions that follow exactly.t                 DECtalk Setups  H               The controlling program first configures DECtalk to ensureG               that all parameters are set correctly. Use these steps inS               your program.   H               1  Programs may wish to send a "What are you?" sequence toG                  make sure DECtalk is available. DECtalk replies with ag4                  code correctly identifying DECtalk.  D                  The "Device Attribute Request" section in Chapter 55                  describes "What are you?" sequences.                   24                 J               2  Send setup commands to configure DECtalk for host-DECtalkE                  communication. The required setup commands vary from J                  computer to computer and from application to application;=                  however, here are some commands to consider.a  H                  a. Include any required commuunication command (such asC                  7-bit or 8-bit codes, and code interpretation. Seer?                  "Selecting ASCII Character Sets" in Chapter 2.   I                  b. Set MODE SQUARE on (if desired). This command ensures B                  that phonemic code values are accepted. See "Mode)                  Selection" in Chapter 2.   B                  c. If you connect DECtalk to the public telephone?                  network, select the correct telephone handlingo@                  parameters. See Chapter 4 for these parameters.  E               3  You may have to set up the host computer (or DECtalk J                  communication line) for DECtalk commands. You must set upJ                  the computer for single-character, unsolicited input, and6                  operating system XON/XOFF processing.  K                                                                         25   e              I                  Setting up computers is beyond the scope of this manual; F                  however, Chapter 6 has examples of setting up certainE                  Digital Equipment Corporation computers for DECtalk.   F                  If your host computer cannot support single-characterG                  processing, you can use the DT_MASK escape sequence to C                  permit line-at-a-time processing. See "Keypad Mask 1                  Command (DT_MASK)" in Chapter 5.i  J               4  Other commands depend on the DECtalk environment, such asG                  debugging commands or special text-to-speech commands.                  Program Control   H               DECtalk is primarily a speech device; its internal code isC               directed towards producing artificial speech. DECtalk I               assumes the host computer will handle most of the necessarypI               control operations (such as waiting for task completion andh#               requests for status).                   26  c              H               The host is responsible for control and cooordination, butJ               this is not a major task. The rest of this chapter describesJ               areas you should consider when designing the DECtalk program               application.  "               Data Synchronization  F               DECtalk's speech rate is much lower than the (potential)H               data transfer rate on the host communication line. DECtalkI               sends an XOFF character (CTRL-S) to the host when its input J               buffer is almost full, to signal that any more input will beH               discarded. When DECtalk's input buffer is almost empty, itJ               sends an XON character (CTRL-Q); XON tells the host to start!               sending data again.o  G               The DECtalk input buffer is large enough so that the hostCH               can continue sending data at the highest speed (9600 baud)D               for up to 250 milliseconds after it receives the XOFF,"               without losing data.  J               Figure 1-5 shows how DECtalk synchronizes data transfer with/               the host through XON/OFF signals.lK                                                                         27e  e              G               If the host does not stop sending data in time, the input J               buffer may overflow and characters may be lost. DECtalk doesJ               not give an audible warning of this overflow, except for theE               obvious garbling of partial words. The host can issue aiJ               device status request (DSR) command to determine if an input'               buffer overflow occurred.   C               Most operation systems have a HOSTSYNC option (or its H               equivalent) in the terminal setup characteristics. If thisG               characyeristic is set on the DECtalk communications line,gH               the host computer handles XON and XOFF signals. If XON/OFFH               coordination is not available, the application program mayC               be able to avoid buffer overflow by using the DT_SYNCgI               command and controlling the program's output rate; however,aF               Digital does not recommend this method because it causesE               errors. The "Data Synchronization" section in chapter 3o                discussed DT_SYNC.                    28  s              +               DECtalk-Host Program Sequence   H               After you set up a parsing method so data can pass betweenG               the host computer and DECtalk, you should set up the hostcJ               for the kinds of data to receive. How you set up informationF               handling depends on the needs of the user. The followingB               section provides some guidelines for developing your#               application's dialog.   )               DEVELOPING YOUR APPLICATIONc  F               DECtalk lets people use your computer-based applicationsH               from any keypad telephone. DECtalk speaks your messages inI               an understandable voice. When the user presses keypad keys,aA               DECtalk sends those characters to your program. The I               following guidelines should help you adapt your application #               to your unique needs.m          K                                                                         29                                  General Guidelines  I               o  Keep the user's point of view, not the programmer's. UseaI                  commands that are logically related to the way users seen                  the task.  J               o  Most people will not carry a large user guide around with                  them.  7               o  Frequent users become experts quickly.o                 Writing Dialog  4               o  Keep dialog simple, but meaningful.  2               o  Organize each message as follows.  >                  1. Put the hardest element to remember first.  G                  2. Put the easiest elements to remember in the middle.r  D                  3. Put information for immediate recall at the end.  C               o  Tell users only what they need to know in order toe!                  continue a task.q            30  a              J               o  Do not use humor or threats. Keep dialog strictly factual!                  and informative.   '               Help Messages and Replies   H               o  Make help messages optional. Let users decide when they'                  want more information.m  =               o  Repeat significant phrases in help messages.a  H               o  Let users know that DECtalk is acting on their specificI                  commands. For example, say "Sending reply to Ms. Jones,"f-                  rather than "Sending reply."e                  K                                                                         31                  &               Entering Keypad Commands  J               o  Remember, there are only 12 keys on the telephone keypad.  8               o  Keep the same function on the same key.  D               o  Refer to keypad numbers, not letters. People do notH                  remember which letter is on which key. Use "Press 1 forG                  next, 2 for previous, 3 to exit," rather than "Press N 7                  for next, P for previous, E for exit."l  J               o  Create a standard method for users to exit from a subtask$                  to the main dialog.  8               Names, Part Numbers, and Alphanumeric Text  I               In many DECtalk applications, you use the 12 keypad keys toiI               enter a person's name or an alphanumeric part number. Since;F               the application program only receives a string of digitsD               (and the # and * characters), the program must use the9               digits as an index to the actual data item.                 32  C              J               If you are designing a new system, you could specify numericI               part numbers only. However, in the real world, a company is I               not going to change its existing warehouse methods to matchaI               DECtalk. So the user will have to enter something that your @               application can translate into the current system.  %               Direct Numeric Encodingh  H               Using this method, the user simply presses the key labeledG               with the desired letter. For example, to select "DIGITAL"cJ               the user would press 3444825. You could assign the letters QD               and Z to the 7 (PQRS) and 9 (WXYZ) keys, respectively.  A               Numeric encoding is a simple method to describe and H               implement. Since users can recall more than one item for aH               given digit string, your application must provide a way to>               select alternatives. You could have users selectI               alternatives by number. Or you could have them step througho7               a list, using next and previous commands.       K                                                                         33c  e              G               Numeric encoding is probably the best method for lists of.G               names and for many part number applications. You can even 7               use this method for ID or password entry.d  $               Two-Character Encoding  H               Some applications use specific letters in their codes (forE               example, three-character airport codes). You cannot use G               direct numeric encoding to select specific letters on the                keypad.r  J               One possible solution is two-character encoding. This methodH               matches the three letters on each key to the three columnsJ               of keys on the keypad. The user presses two keys to select a               letter.a  6                     1. the key with the desired letterG                     2. The 1,2 or 3 key (to select the specific letter)S                    34                 G               For example, to select "DEC" the user would press 313223.hD               You could have users enter numbers together with the 0H               (OPER) key. And you could assign the missing Q and Z (plus0               the space character) to the 1 key.  H               The United States Federal Aviation Administration used theF               above method to provide a voice response weather system.H               (The USFAA used stored segments of speech--DECtalk was not%               available at the time.)u  &               Ending Commands and Data  I               You can use single-character commands and fixed-length datadH               fields for many applications. But for complex applicationsH               or variable-length data you may find it simpler to ask theI               user to end all commands and data by pressing a special keyiJ               (such as #). Pressing # lets the program know that the right5               number of characters have been entered.u        K                                                                         35e  t              B               You could also use DECtalk's flexible keypad timeoutI               facility. If the user is entering a variable-length numerictJ               field, use a long timeout for the first digit and (possibly)6               a shorter timeout for successive digits.  *               Application Development Tips  E               Here are some tips for encoding the application itself.(  F               o  Use timeouts for everything. Assume that the user mayE                  hang up the phone at any time. Also assume that datasJ                  entry will be quite slow. This is important when planning?                  data base entry and record-locking strategies.   G               o  The DECtalk applications support library may return anhG                  error code due to transient problems (such as a systemmH                  overload). The simplest recovery is to hang up the callE                  and reinitialize DECtalk. Log the problem for futureb                  action.                  36                 B               o  People can recall about 5 seconds of text withoutJ                  difficulty. You can use entries such as "1 for yes, 2 forF                  no, 3 for maybe," but do not ask an untrained user to0                  remember anything more complex.  F               o  DECtalk tends to spell out text that may be ambiguousJ                  (for example, part numbers). You can write a small filterJ                  subroutine that recognizes certain strings and pronounces?                  them in a form more suitable for your specific                   application.r  C               o  If your appliation accepts data from the telephonedB                  keypad, make sure the operating system can bufferE                  type-ahead characters. Also, make sure the operating 4                  system responds to DECtalk's XOFFs.  E               o  DECtalk speaks pending text if the host system stopsgE                  delivering text for 5 seconds. This feature may be aEH                  problem on an overloaded system. You may need help fromF                  the system manager to obtain more resources or adjust$                  program priorities.  K                                                                         37   p              J               o  When you have DECtalk speak information from a data base,F                  remember that the listener hears the information onlyE                  once. You should offer a repeat function for complexuG                  subject matter. If you have DECtalk read mail or otherEB                  unstructured text, you should offer a back up oneI                  sentence function, using the Index Test command (Chaptero2                  3) to signal what has been heard.  +            1       SETUP ESCAPE SEQUENCES 2   H               DECtalk has several features you can change to control theA               operating environment. These parameters include the                following.  :               o  line characteristics (such as line speed)  A               o  character sets (to send and receive information)r  F               o  modes (to control DECtalk's interpretation of special.                  characters and phonemic text)                38                 B               There are also several testing and inquiry commands,%               described in Chapter 5.   ,               SELECTING ASCII CHARACTER SETS  H               DECtalk is a computer terminal device, and conforms to the/               standards for computer terminals.e  @               DECtalk speech does not include much of the visualJ               information of character sets. For example, DECtalk uses the5               following rules for all character sets.r  I               1  Uppercase and lowercase letters are considered the same. G                  For example, DECtalk speaks the letter G as "gee," note!                  "uppercase gee."h  I               2  Foreign letters (as found in the multinational characterfH                  set) are spoken as English. For example, DECtalk speaks5                  the letter # as "a," not "a umlaut."m        K                                                                         39"  d              G               3  You can translate or map 7-bit codes into 8-bit codes, D                  and 8-bit codes into 7-bit codes (Figure-2-1). thisJ                  mapping has no effect on spoken text. Table 2-1 gives theG                  escape sequences that change DECtalk to 7-bit or 8-bit                   modes.   F               The following paragraphs describe how DECtalk interpretsB               certain keyboard (or host computer) generated codes.  6               Table 2-1  Selecting 7-Bit or 8-Bit Mode  '                         Escape Sequencei3               Mnemonic  Decimal Value      Function                  Transmit  D               S7C1T     ESC   SP    F      Select 7-bit C1 character7                         027   032   070    transmissiont                  40                 >               Table 2-1 (Cont.)  Selecting 7-Bit or 8-Bit Mode  '                         Escape Sequencel3               Mnemonic  Decimal Value      Function B               S8C1T     ESC   SP    G      Select 8-bit C1 controlB                         027   032   071    character transmission.                 Receive   A               DECTC1    ESC   SP    6      Select 7-bit characternD                         027   032   054    reception. The high-orderI                                            (eighth) bit is ignored in alloJ                                            received C1 control characters.  I               DECAC1    ESC   SP    7      Select 8-bit control character.E                         021   032   055    reception. The high- ordermJ                                            (eighth) bit is accepted in allJ                                            received C1 control characters.    K                                                                         41                                 CODING STANDARDS  E               The DTC01 uses an 8-bit character encoding scheme and amI               7-bit code extension technique that are compatible with theiG               following ANSI and ISO standards. ANSI (American NationalaJ               Standards Institute) and ISO (International Organization forJ               Standardization) specify the current standards for character;               encoding used in the communications industry.a+               Standard          Description   F               ANSI X3.32--1973   Graphic Representation of the controlH                                 characters of American National Code for8                                 Information Interchange.  J               ANSI X3.4--1977    American Code for Information Interchange'                                 (ASCII)a  J               ISO 646--1977      7-Bit Coded Character Set for Information6                                 Processing Interchange                42  v              +               Standard          DescriptionvK               ANSI X3.41--1974   Code Extension Techniques for Use with thehE                                 7-Bit coded Character Set of American E                                 National Code Information Interchange   I               ISO Draft         7-Bit and 8-Bit Coded Character Sets-Code 4               International     Extension Techniques               Standard 2022.2e  F               ANSI X3.32--1973   Graphic Representation of the controlH                                 characters of American National Code for6                                 Infomation Interchange  J               ANSI X3.64--1979   Additional Controls for Use with AmericanA                                 National Standard for Information +                                 Interchange           K                                                                         43r                 +               Standard          Description J               ISO Draft         Additional Control Functions for Character/               International     Imaging Devicesl               Standard 6429.2s                 CODE TABLE  E               A code table is a convenient way to represent 7-bit and @               8-bit characters, because you can see groupings of:               characters and their relative codes clearly.  $               7-Bit ASCII Code Table  E               Figure 2-2 is the 7-bit ASCII code table. There are 128pJ               positions corresponding to 128 character codes arranged in a.               matrix of 8 columns and 16 rows.  D               Each row represents a possible value of the four leastH               significant bits of a 7-bit code (Figure 2-3). Each columnG               represents a possible value of the three most significant                bits.O              44                 G               Figure 2-2 shows the octal, decimal, and hexadecimal codeeB               for each ASCII character. You can also represent anyF               character by its position in the table. For example, theF               character H (column 4, row 8) can be represented as 4/8.  J               DECtalk processes received characters based on two characterC               types defined by ANSI, graphic characters and control                characters.   J               Graphic characters are characters you can display on a videoG               screen. The ASCII graphic characters are in positions 2/1 C               through 7/14 of Figure 2-2. They include alphanumeric I               characters plus punctuation marks and various text symbols.a,               Examples are C, n, ", !, +, $.  H               Control characters are not displayed. They are single-byteJ               codes that perform specific functions in data communicationsF               and text processing. The ASCII control characters are inI               positions 0/0 through 1/15 (columns 0 and 1) of Figure 2-2. F               The SP character (space, 2/0) can be considered either a    K                                                                         45f  u              G               graphic character or a control character depending on the H               context. DEL (7/15) is always used as a control character.  H               Control character codes and functions are standfardized byC               ANSI. Examples of ASCII control characters with theirsH               ANSI-standard mnemonics are CR (carriage return), FF (form&               feed), and CAN (cancel).                 8-Bit Code Table  C               The above conventions can be generalized to the 8-bitrF               character encoding used on DECtalk. Figure 2-4 shows theI               8-bit code table. It has twice as many columns as the 7-bit D               table, because it contains 256 versus 128 code values.  E               As with the 7-bit table, each row represents a possible G               value of the four least significant bits of an 8-bit code J               (Figure 2-5). Each column represents a possible value of the)               four most significant bits.l                  46                 E               All codes on the left half of the 8-bit table (colums 0 J               through 7) are 7-bit compatible: their eighth bit is not setF               and can be ignored or assumed to be 0. You can use theseH               codes in either a 7-bit or an 8-bit environment. All codesG               on the right half of the table (colums 8 through 15) have F               their eighth bit set. You can use these codes only in an+               8-bit compatible environment.t  G               The 8-bit code table (Figure 2-4) has two sets of control E               characters, CO (control zero) and C1 (control one). ThemH               table also has two sets of graphic characters, GL (graphic+               left) and GR (graphic right).c  H               On DECtalk, the basic functions of the C0 and C1 codes areF               as defined by ANSI. C0 codes represent the ASCII controlB               characters described earlier. The C0 codes are 7-bitI               compatible. The C1 codes represent 8-bit control characters J               that let you perform more functions than those possible withJ               the C0 codes. C1 codes can be used directly only in an 8-bitH               environment. Some C1 code positions are left blank because7               their functions are not yet standardized.aK                                                                         47d  r              J               NOTE: DECtalk only recognized the SS2, SS3, DCS, CSI, and ST4               control codes. The others are ignored.  B               The GL and GR sets of codes are reserved for graphicH               characters. There are 94 GL codes in positions 2/1 throughF               7/14 and 94 GR codes in positions 10/1 through 15/14. ByH               ANSI standards, positions 10/0 and 15/15 are not used. YouJ               can use GL codes in 7-bit or 8-bit environments. You can use4               GR codes only in an 8-bit environment.                 CHARACTER SETS  D               You cannot change the functions of the C0 or C1 codes.G               However, you can map different sets of graphic characters E               into the GL and/or GR codes. The sets are stored in thefG               terminal. But they are not available for use until mappedr&               into the GL or GR codes.                      48  n              9               Selecting Alternate Character Sets (G0--G3)m  I               DECtalk has four alternate character set areas: G0, G1, G2,cJ               and G3. When DECtalk powers up, it loads the ASCII_G (7-bit)C               character set in alternate buffers G0 and G1. The DECnH               multinational (8-bit) character set is loaded in alternate                buffers G2 and G3.  I               DECtalk does not call the alternate character sets directlynF               from G0, G1, G2, or G3. The selected set is first mappedF               into the GL or GR areas, then used to interpret the nextD               received (or transmitted) character. So, three factors1               determine the active character set.a  9               o  Which character area is active: GL or GR   H               o  Which alternate set is mapped into the active area: G0,                  G1, G2, or G3  J               o  Which character set is loaded in the alternate (G0 or G1).                  set: ASCII_G or multinational    K                                                                         49                  >               Figure 2-6 shows how you can map the ASCII_G andJ               multinational sets into the alternate character set buffers.H               Figure 2-7 shows how you can select active character sets.  I               Table 2-2 gives the escape sequences and control charactersrF               that load and select alternate character sets. Table 2-3F               gives the escape sequences to load active character sets!               into G0 through G3.   ;               Table 2-2  Selecting the Active Character SetR  E                                        Escape      Graphics     TableoH               Command        Mnemonic  Sequence    Set          Position                 Locking shift  LS0       SI          G0           GL
                                                         --
                                                            >               0n                 Locking shift  LS1       SO          G1           GL
                                                         --
                                                            >               1w                50                 C               Table 2-2 (Cont.)  Selecting the Active Character Set   E                                        Escape      Graphics     Table H               Command        Mnemonic  Sequence    Set          Position*                                        014  B               Single shift   SS2       ESC    N    G2[1]        GL}               2
                                                   --
                                                      >   0                                        027   078  B               Single shift   SS3       ESC    O    G3[1]        GL               3                        027   079
                                                   --
                                                      >    J               [1]SS2 (single shift 2) and SS3 (single shift 3) are specialH               cases. These commands select the next character value fromJ               the G2 or G3 set, respectively, regardless of the setting of               the eighth bit.O    K                                                                         51                  C               Table 2-2 (Cont.)  Selecting the Active Character Setc  E                                        Escape      Graphics     TableTH               Command        Mnemonic  Sequence    Set          Position               Locking shift  LS2       ESC    n    G2           GL
                                                         --
                                                            >0               2                        027   110                 Locking shift  LS3       ESC    o    G3           GL
                                                         --
                                                            >0               3                        027   111                 Locking shift  LS1R      ESC    ~    G1           GR
                                                         --
                                                            >0               1 right                  027   126                 Locking shift  LS2R      ESC    }    G2           GR
                                                         --
                                                            >0               2 right                  027   125                      52  e              C               Table 2-2 (Cont.)  Selecting the Active Character Setp  E                                        Escape      Graphics     TableeH               Command        Mnemonic  Sequence    Set          Position                 Locking shift  LS3R      ESC    |    G3           GR
                                                         --
                                                            >0               3 right                  027   124  1            Table 2-3  Selecting the Character Set   C            Character Set  G0           G1           G2           G3   J            ASCII_G        ESC  (  B    ESC  )   B   ESC  *  B    ESC  +  B  L                           027 040 066  027 041 066  027 042 066  027 043 066  J            Multinational  ESC  (  <    ESC  )  <    ESC  *  <    ESC  +  <      K                                                                         53                  9            Table 2-3 (Cont.)  Selecting the Character Set   C            Character Set  G0           G1           G2           G3 L                           027 040 060  027 041 060  027 042 060  027 043 060  ,               DECMultinational Character Set  I               By factory default, when you power up or reset DECtalk, theeF               DEC multinational character set is mapped into the 8-bitJ               code matrix (columns 0 through 15). Figure 2-8 shows the DEC*               multinational character set.  E               The 7-bit compatible left half of the DEC multinationalfG               character set is the ASCII graphics set; the C0 codes arerI               the ASCII control characters and the GL codes are the ASCII                graphics set.                       54  o              F               The 8-bit compatible right half of the DEC multinationalG               character set includes the C1 8-bit control characters indD               columns 8 and 9. The GR codes are the DEC supplementalC               graphics character set. The DEC supplemental graphicstF               character set has alphabetic characters with accents andI               diacritical marks that appear in the major Western EuropeanbF               alphabets. It also has other symbols not included in the+               ASCII graphics character set.s  ?               DECtalk removes the accent from characters in the E               supplemental graphics character set, which are accentedtI               versions of characters in the ASCII graphics set. (Na#ve is G               the same as naive.) Other supplemental graphic charactersp               are ignored.  7               WORKING WITH 7-BIT AND 8-BIT ENVIRONMENTS7  F               To take advantage of DECtalk's 8-bit character set, yourA               program and communication environment must be 8-bite               compatible.     K                                                                         55i  m              ?               Conventions for Codes Transmitted to the Terminaln  B               DECtalk expects to receive character codes in a formG               consistent with 8-bit coding. Your application can freelyEI               use the 8-bit codes as well as the 7-bit code extensions ift,               it has enabled 8-bit controls.  H               When your program sends GL or GR codes, DECtalk interpretsH               these according to the graphic character mapping currentlyH               being used. The factory default mapping, which is set whenE               you power up or reset DECtalk, is the DEC multinationala               character set.  &               Mode Selection (DT_MODE)  I               This sequence acts like the SET MODE command in setup mode. H               DT_MODE controls how DECtalk handles particular charactersG               in spoken text. The general DT_MODE escape sequence is as                follows.  ;                  ESC  P   0   ;   8   0   ;  P3   z  ESC  \l                56  l              =                  027 080 048 059 056 048 059 *** 122 027  092   >               Use the following method to obtain the P3 value.  J               1  Add up the values of the MODE flags in Table 2-4 that you                  want to use.   E               2  Convert the sum to ASCII digits. Use these digits in 4                  place of P3 in the escape sequence.  A               For example, assume you want to set MODE_SQUARE anda.               MODE_MINUS, and clear MODE_ASKY.  %                      MODE_SQUARE  = 1 %                      MODE_MINUS   = 4   %                 Desired P3 value  = 5   ;                  ESC  P   0   ;   8   0   ;   5   z  ESC  \r        K                                                                         57e  S              =                  027 080 048 059 056 048 059 053 122 027  092   (            Table 2-4  DT_MODE Parameters  )            Mnemonic       Value  Functions  I            MODE_SQUARE    1      DECtalk interprets the following graphic 8                                  characters as commands.F                                  []     Delimit phonemic text strings.  G                                  )word  You can use a right parenthesis D                                         immediately before a word toI                                         select an alternate pronunciation H                                         for certain words, such as read,F                                         whose pronunciation depends on.                                         usage.                      58  S              0            Table 2-4 (Cont.)  DT_MODE Parameters  )            Mnemonic       Value  Function1D            MODE_ASKY      2      DECtalk interprets phonemic text inH                                  single-character "asky" (ASCII) insteadE                                  of multicharacter "arpabet" phonemic F                                  mode. This flag also determines whichC                                  phonemic representation is used by J                                  DECtalk phonemic logging. See the DECtalk>                                  DTC01 Owner's Manual for more-                                  information.a  B            MODE_MINUS     4      DECtalk pronounces the hyphen (-)E                                  character as "minus." Usually, it isg3                                  pronounced "dash."           K                                                                         59s  .              "            1       VOICE COMMANDS,!                    PHONEMIC TEXT,h,                    AND THE USER DICTIONARY 3  F               The DECtalk DTC01 Owner's Manual describes how to modifyH               theDECtalk voice (using phonemic commands and the phonemicI               alphabet) from a terminal. This chapter describes a special C               series of escape sequences that gives a host computerlH               slightly greater control over DECtalk. For example, escapeI               sequences can turn the DECtalk voice on or off and load thed               user dictionary.                 SPEECH CONTROL  =               There are three ways to control DECtalk speech.t  D               1  Through English text (sentences in standard EnglishB                  format and spelling). DECtalk speaks this text as                  written.o                  60                 H               2  Through phonemic spelling (sentences or phrases writtenI                  in phonemic symbols). Phonemic spelling is closer to thee2                  actual pronunciation of the text.  E               3  Through phonemic commands. Phonemic commands control I                  features of speech that are not obvious from the visible F                  text, such as rate of speech, sex of the speaker, and"                  excitement level.                 SPEECH TIMEOUT  E               Usually, DECtalk does not begin speaking until the host @               computer sends a clause terminator (period, comma,G               exclamation point, or question mark); however, there is axD               5-second timeout limit. If the host does not send dataF               within 5 seconds, DECtalk speaks the pending text in its8               input buffer, as if a comma had been sent.  J               Programs with long interruptions (such as pauses to search aH               database) should collect complete sentences before sendingD               anything to DECtalk. Otherwise, this timeout may causeF               unnatural breaks in sentences and jerky-sounding speech.K                                                                         61                                 ENGLISH TEXT  J               DECtalk speaks sentences written in standard English, if the'               text follows three rules.e  C               1  Sentences end with a period, exclamation point, orp                  question mark.   F               2  All commas, periods, exclamation points, and questionJ                  marks are followed by a space (or an equivalent character!                  from Table 1-1).e  H               3  A period must be followed by enough text to distinguishA                  between abbreviations and the end of a sentence.I  J               The host computer can send English text in paragraph format;H               that is, sentences can be broken in the middle by carriage               returns.                      62  o              J               If a sentence is too long to store in DECtalk's buffers, theC               sentence is spoken in sections. DECtalk breaks up the J               sentence and speaks it as if clause boundaries were present;F               the effect is similar to a person trying to speak a longJ               sentence and running out of breath. Keep sentences down to a5               reasonable length to avoid this effect.o  J               See the DECtalk DTC01 Owner's Manual for more information onF               speech phrasing and emphasis. The "Data Synchronization"F               section in this chapter also describes how to coordinate@               speech and interaction commands to prevent loss of               information.  .               SPEAK PHONEMIC TEXT (DT_PHOTEXT)  D               When MODE SQUARE is on, you can embed phonemic text inJ               normal text with square brackets. When sending data from theJ               host computer, you can use the DT_PHOTEXT escape sequence asJ               well as the square brackets; MODE SQUARE does not have to be?               on. The DT_PHOTEXT escape sequence is as follows.e  8                  ESC  P   0   ;    0   z    text  ESC  \K                                                                         63                  ;                  027 080 048 059 048 122   ......  027  092   H               ESC P 0 ; 0 z is the same as a left bracket ([), and ESC \F               is the ame as a right bracket (]). DECtalk uses phoneticF               speech for all text between the command terminator z and(               sequence terminator ESC \.  I               Appendix C lists the phonemic alphabet used by DECtalk. The1D               DECtalk DTC01 Owner's Manual describes the alphabet in               detail.   D               Within the phonemic text string, the host computer canH               transmit comments (for program maintenance) enclosed in /*J               and */ sequences. (An ESC \ can also terminate any comment.)  H               For example, in the following sequence the word Hello is a               comment.  ;                    ESC P 0 ; 0 z hx'ehlow /* Hello */ ESC \                   64  r              I               DECtalk processes a phonemic text escape sequence as though B               the introducer and terminator were spaces.This means:               phonemic text cannot replace part of a word.  G               In addition to transmitting the proper pronunciation, thePF               phonemic text escape sequence can send control phonemes.C               This example changes the speech rate to 250 words per                minute.   B                    ESC P 0 ; 0 z :ra250 /* Rate + 250 wpm */ ESC \  C               NOTE: You cannot use STX (CTRL-B) and ETX (CTRL-C) to G               delimit phonemic text. Use the DT_PHOTEXT escape sequence                instead.                K                                                                         65                  %               STOP SPEAKING (DT_STOP)   D               This escape sequence immediately stops speech, even ifG               DECtalk is in the middle of a sentence. DT_STOP is usefulcH               for stopping speech to perform other actions. For example,J               the user may press a key to get more instructions, warnings,I               or shortened versions of explanations (such as lengthy HELPu               information).e  8               The DT_STOP escape sequence is as follows.  4                  ESC  P   0   ;    1   0   z  ESC  \4                  027 080 048 059 049 048 122 027 092  C               Speech stops immediately and all internal buffers are.               reinitialized.                        66  a              ,               DATA SYNCHRONIZATION (DT_SYNC)  J               The application program can send data to DECtalk faster thanH               DECtalk can speak it. If the user must carry on a dialogueJ               with the application program (through the telephone keypad),H               the application program should know whether or not DECtalkI               has finished speaking the text sent to it. DT_SYNC providessC               this coordination between the application program andt               DECtalk speech.   H               When the host sends DT_SYNC, DECtalk finishes speaking anyF               pending text before processing the next command from theI               host. This ensures that the user hears a message before any B               other action starts, such as hanging up the phone orI               starting the phone timeout clock. Note that DT_SYNC acts as I               a clause boundary, the same as a comma, period, exclamation &               point, or question mark.        K                                                                         67   C              I               DECtalk considers a section of text to be spoken as soon as"J               the parameters for that section are successfully sent to itsJ               signal processing section. Audio output runs approximately 6E               milliseconds behind the transmission of the parameters.sC               Applications that switch the audio output of a singleeF               DECtalk to a number of sites may need to take this delay               into account.   8               The DT_SYNC escape sequence is as follows.  4                  ESC  P   0   ;    1   1   z  ESC  \4                  027 080 048 059 049 049 122 027 092  C               DT_SYNC does not reply to the host when processing is I               complete. However, you can do this by following the DT_SYNC 4               command with a DT_INDEX_QUERY command.                        68                 3               ENABLE OR DISABLE SPEAKING (DT_SPEAK)   I               The DT_STOP sequence stops speech in progress. The DT_SPEAK(J               sequence turns speech processing off or on, so received textF               is either spoken or discarded. DT_SPEAK is useful if theH               host computer can recognize such things as electronic mailG               letterheads and discard them as unnecessary. The host cant:               act as a filter, removing extraneous speech.  9               The DT_SPEAK escape sequence is as follows.   >                  ESC  P   0   ;    1   2   ;   P3   z   ESC  \=                  027 080 048 059 049 050 059 ***  122 027 092   H               If P3 is 0, DEctalk stops speaking text; that is, it stops>               passing characters received from the host to theH               text-to-speech processing section. If P# is not 0, DECtalk               resumes speaking.i  F               DECtalk also resumes speaking if the host sends DT_SYNC,:               DT_STOP, RIS, DECSTR, or DT_PHONE:ph_answer.    K                                                                         69o  h                             INDEXING  C               Text sent to DECtalk can contain index marks. DECtalknB               remembers these marks when they are spoken. The hostG               application can listen to the spoken text (by reading thenH               value of the last index) to determine how much transmitted'               text was actually spoken.   H               Index markers affect the way numbers and abbreviations areI               spoken. For example, DECtalk says $12.45 as "twelve dollars I               and forty-five cents." (The space after the $ is optional.) I               If an index marker separates the $ and 1, then DECtalk saysu.               "dollar twelve point four five."  D               The following paragraphs describe how to mark text and=               return their values to the application program.c                        70                 #               Index Text (DT_INDEX)   G               This sequence inserts and index marker (flag) in the texts%               stream sent to DECtalk.f  9               The DT_INDEX escape sequence is as follows.   =                  ESC  P   0    ;   2   0   ;   P3   z  ESC  \ <                  027 080 048 059 050 048 059 *** 122 027 092  E               The P3 parameter may range from 0 to 32767, sent as the H               ASCII characters for the number. Numbers outside the rangeF               are brought into range by masking off the overflow bits.  E               For example, the host computer sends the following data H               stream to DECtalk and marks the second word with the index               15.h  :                    Hello ESC P 0 ; 2 0 ; 15 Z ESC \ there.  H               After speaking the text before DT_INDEX, DECtalk remembersF               the value 15. The host may use DT_INDEX_QUERY (described>               later in this chapter) to get this stored value.K                                                                         71                  *               Index Reply (DT_INDEX_REPLY)  J               DT_INDEX simply marks a position in the text. DT_INDEX_REPLYI               marks a position, but also has DECtalk inform the host when "               the index is spoken.  ?               The DT_INDEX_REPLY escape sequence is as follows.s  =                  ESC  P   0   ;    2   1    ;  P3   z  ESC  \e<                  027 080 048 059 050 049 059 *** 122 027 092  F               The P3 parameter is in the range 0 to 32767, using ASCII1               characters for the selected number.   I               When DECtalk speaks the DT_INDEX_REPLY sequence, it sends a E               reply (containing the P3 parameter of the index) to the C               host. The escape sequence reply format is as follows.   =                  ESC  P   0   ;    3   1    ;  P3   z  ESC  \t<                  027 080 048 059 051 049 059 *** 122 027 092  D               P3 has the original value specified in DT_INDEX_REPLY.              72                 *               Index Query (DT_INDEX_QUERY)  G               DT_INDEX_QUERY requests DECtalk to reply to the host with H               the last index marker spoken (that is, the last portion ofG               spoken text that had an index marker). The DT_INDEX_QUERY ,               escape sequence is as follows.  5                  ESC  P   0   ;    2   2    z  ESC  \o4                  027 080 048 059 050 050 122 027 092  I               DECtalk immediately returns a DECtalk reply escape sequenced2               to the host in the following format.  =                  ESC  P   0   ;    3   2    ;  P3   z  ESC  \c<                  027 080 048 059 051 050 059 *** 122 027 092  H               P3 contains the last index spoken. The P3 value is ASCII 04               under any of the following conditions.  3               o  The last index passed was ASCII 0.m  .               o  No index has been passed yet.  K                                                                         73l  r              H               o  No index has been marked in the text; that is, the hostD                  has not sent a DT_INDEX or DT_INDEX_REPLY sequence.  A               Figure 3-1 shows how DT_SYNC and DT_INDEX_QUERY can 5               coordinate host-DECtalk communications.   '               LOAD DICTIONARY (DT_DICT)   G               The user dictionary is used for processing abbreviations, J               and for providing phonemic equivalents of unusual words. The4               DT_DICT escape sequence is as follows.  F                  ESC  P   0   ;    4   0   z  name substitution ESC  \8                  027 080 048 059 052 048 122 ...........(                  ...........    027  092  J               Whenever the word represented by "name" appears in the inputI               text, the phonemic pronunciation given by "substitution" isy               used.f                  74  s              G               Any uppercase characters in the name only match uppercasepG               characters in the input text. Lowercase characters in theyG               name both uppercase and lowercase characters in the input E               text. DECtalk always seraches dictionary entries in the                order entered.  H               If a name ends with a period (.), a period must follow theI               word in running input text. This period is included as part J               of the word, and is not recognized as a sentence terminator.  ;               Here are some examples of dictionary entries.   3                    ESC P 0 ; 4 0 ; z ms m'ihz ESC \l4                    ESC P 0 ; 4 0 ; z ms. m'ihz ESC \4                    ESC P 0 ; 4 0 ; z DEC d'ehk ESC \:                    ESC P 0 ; 4 0 ; z dec d'iysehmber ESC \<                    ESC P 0 ; 4 0 ; z Goethe g'owth `iy ESC \9                    ESC P 0 ; 4 0 ; z GOSLOW :ra 120 ESC \         K                                                                         75                  F               DECtalk does not recognize an error in phonemic spellingA               until the word is used. You can use comments in the I               substitution, but they are not recommended. Note the use ofwD               capitalization in the previous examples to distinguish;               between abbreviations with the same spelling.   J               If you do not enter a substitution, DECtalk removes the wordI               from the user text dictionary. You cannot remove words from &               the built-in dictionary.  H               After loading the word and its definition, DECtalk replies.               with a dictionary status report.  =                  ESC  P   0   ;    5   0   ;   P3   z   ESC \ =                  027 080 048 059 053 048 059 *** 122  027 092t                          76                 6               P3 may have one of the following values.  ,                0     Word entered correctly.               048   +                1     No room in dictionary.                049t  =                2     Entry too long (256 characters maximum.)e               050t                      K                                                                         77n  f              -            1       TELEPHONE COMMUNICATIONS 4   G               You can connect DECtalk to the public telephone system to G               provide a dial-up link between remote users on telephones C               and a computer application program. DECtalk sends and J               receives information as a link between a remote user and the               host computer.  C               DECtalk communicates with the phone through the voice G               circuits, passing on spoken data to the listener. DECtalk H               passes information back to the host both as ordinary ASCII?               characters, and as escape sequences. The user can F               communicate with the host (through DECtalk) by using the.               Touch-Tone keypad, if available.  J               The DT_PHONE escape sequence is the controlling sequence for'               all telephone operations.                     78                 -               TELEPHONE MANAGEMENT (DT_PHONE)   C               This escape sequence takes one or more parameters and C               controls the attached telephone and Touch-Tone keypad D               interface. The DT_PHONE escape sequence is as follows.  O                  ESC  P   0   ;    6   0    ;  Pn   ;  Pn    z   text   ESC   \ R                  027 080 048 059 054 048 059 *** 059 ***  122   ........  027  092  E               The Pn parameters act as a list of telephone management I               commands and execute in sequence. Table 4-1 lists the valid                Pn parameters.  F               A single DT_PHONE sequence can perform several commands.;               Some commands can take additional parameters.   I               All DT_PHONE commands return a status report to the host in I               the following escape sequence. Table 4-2 lists the valid P3n               values.   >                  ESC  P   0   ;    7   0   ;   P3   z   ESC  \>                  027 080 048 059 055 048 059 *** 122  027  092  K                                                                         79                  G               All telephone management commands return a reply sequence H               back to the host upon command execution. PH_STATUS is onlyJ               needed to check the telephone status when a DT_PHONE commandI               is not pending. Note that PH_ANSWER generates an additional 7               status report when the phone is answered.1  F               Telephone keypad characters are sent as text, not escape               sequences.  H               Note that the R3_PH_TIMEOUT replay sequence is sent when aG               timeout occurs; that is, the reply sequence may arrive asmJ               unrequested input, and the application program must be ready               to receive it.                            80                 ,               Table 4-1  DT_PHONE Parameters  '                              ASCII Coder$                              Decimal3               Mnemonic       Value         Function   J               PH_STATUS       0            Send a telephone status report.                               048  C               PH_ANSWER       1    0       Enable autoanswer of theo5                              049  048      telephone.e  D               PH_HANGUP       1    1       Hang up the telephone and>                              049   049     disable the keypad.  G               PH_KEYPAD       2    0       Enable the keypad and selecthB                              050   048     direct keypad decoding.            `      K                                                                         81                  4               Table 4-1 (Cont.)  DT_PHONE Parameters  '                              ASCII Codei$                              Decimal3               Mnemonic       Value         Function F               PH_NOKEYPAD     2    1       Disable the keypad (withoutE                              050   049     hanging up the telephone.)8  G               PH_TIMEOUT      3    0       Enable timeouts on telephoneaJ                              051   048     keypad input. Timeout equals P4;                                            parameter value.   F               PH_TONE_DIAL    4    0       Dial an outgoing phone call=                              052   048     using Touch-Tones.a  F               PH_PULSE_DIAL   4    1       Dial an outgoing phone call?                              052   049     using pulse dialing.f                  82                 1               Table 4-2  Phone Status Reply Codes   (                               ASCII Code5               Mnemonic        Decimal Value  Functionl  G               R3_PH_ONHOOK     0             Telephone is on-hook (hungg1                               048            up).e  B               R3_PH_OFFHOOK    1             Telephone is off-hook6                               049            (active).  F               R3_PH_TIMEOUT    2             No response after TIMEOUT5                               050            command.   I               R3_PH_TOOLONG    3             Number dialed is longer than <                               051            256 characters.                 PH_ANSWERw  C               DECtalk is set up to answer incoming phone calls. The G               parameter that follows the PH_ANSWER parameters indicates8K                                                                         83e                 I               the number of rings to wait before answering the telephone. H               A parameter of 0 or 1 means answer the telephone after theB               first ring; 2 means answer after 2 rings, and so on.  J               If the telephone is off-hook when the host sends a PH_ANSWERH               parameter, DECtalk hangs up the telephone (disconnects anyB               active call) before executing the PH_ANSWER command.  J               DECtalk sends two status replies to a PH_ANSWER request. TheC               first status reply informs the host that the DT_PHONEaJ               command was correctly received. The second reply informs theA               host that the telephone has actually been answered.n  H               DECtalk stops waiting for incoming calls whenever the hostG               sends PH_HANGUP, PH_TONE, PH_DIAL, PH_PULSE_DIAL, RIS, orn               DECSTR.D                        84                                PH_HANGUPo  F               This command hangs up the telephone. The status reply isI               delayed until the telephone is back on-hook (disconnected).hD               The host should wait for the R3_PH_ONHOOK reply before0               sending other commands to DECtalk.                 PH_KEYPAD   G               This command enables the telephone keypad. The request is J               ignored if the phone is inactive (on-hook); however, DECtalk3               returns an R3_PH_ONHOOK status reply.                  PH_NOKEYPADi  G               This command disables the telephone keypad, but maintains H               the phone connection. This request is ignored if the phone@               is inactive (on-hook); however, DECtalk returns an(               R3_PH_ONHOOK status reply.      K                                                                         85z  S                             PH_TIMEOUT  J               This command starts (or restarts) an internal DECtalk timer.I               If the user does not press a telephone keypad button withingG               the timeout interval, an R3_PH_TIMEOUT status is returned                (Table 4-2).  D               The application program should set PH_KEYPAD on beforeF               sending a PH_TIMEOUT command; otherwise, the user cannot4               respond to DECtalk requests for input.  I               The parameter following PH_TIMEOUT is the number of secondseF               to wait for a response from the caller. A parameter of 0H               cancels any active timeouts. After a timeout, the timer isI               stopped. The application program must send a new PH_TIMEOUT +               command to restart the timer.P  J               Timeouts are the only way to detect that the caller has hung               up the telephone.                   86                 J               The public telephone system in your country may have anotherE               timeout requirement, independent of DECtalk. If this is J               true, a phone call may be automatically terminated (hung up)J               if a response is not given in a certain lenght of time. YourH               application program should accept unsolicited R3_PH_ONHOOK               replies.  ,               PH_TONE_DIAL and PH_PULSE_DIAL  B               DECtalk can dial an outgoing call by using these twoF               commands. If DECtalk is connected to a Touch-Tone publicE               telephone network, then use the PH_TONE_DIAL parameter;vG               otherwise, use PH_PULSE_DIAL. PH_PULSE_DIAL works like ant$               old rotary phone dial.  G               If the telephone is on-hook when the host sends a dialingnC               command, DECtalk picks up the telephone and inserts ar               2-second delay.         K                                                                         87                  E               The text between the command terminator z and the ESC \oH               sequence is the number to dial. For the Touch-Tone dialingH               system, the characters 0123456789*#ABCD!^ are reconginzed.G               For the pulse dialing system, the characters 0123456789!^T               are recognized.h  G               The ! character inserts a 1-second delay into the dialingsF               stream. DECtalk pauses during the dialing sequence every*               time it finds a ! character.  I               On some telephone systems, a user can press the switch hookSI               to transfer calls or otherwise interrupt a phone call. This.C               signal is called a switch-hook flash. The ^ characterlI               inserts a 250-millisecond switch-hook flash signal into the-D               dialing stream. You can use successive ^ characters to&               generate longer flashes.  G               With Touch-Tone dialing, the characters ABCD generate the J               extra four tones of the military handset. A is the characterH               to the right of the 3, B is the character below it, and so               on.a              88                 I               Figure 4-1 shows a complete phone call session, including a0E               timeout sequence initiated because a user disconnected.               1       MAINTENANCE+                    AND DEBUGGING COMMANDS 5   F               DECtalk has a set of commands that set DECtalk operatingJ               features, test DECtalk, and help debug application programs.E               Most of these commands have an inquiry-response format.iF               DECtalk returns an answer to the host computer after theD               action is complete (or in response to a pure inquiry).  &               DEVICE ATTRIBUTE REQUEST  H               DECtalk responds to device identity requests from the hostH               computer. For compatibility with an older escape sequence,A               DEctalk recognizes two different request sequences,p4               described in the following paragraphs.      K                                                                         89D  H              3               Device Attribute Request (DA Primary)   J               The preferred device attribute request escape sequence is as               follows.  #                  ESC   [    0     ch#                  027  091  048  099   J               DECtalk identifies itself by sending the following sequence.  -                  ESC   [    ?     1    9    c -                  027  091  063  049  057  099   D               DECtalk does not respond to secondary device attributeJ               requests, since its product identification code is less than               50.a                        90                 '               Identify Terminal (DECID)   D               DECtalk responds to the old identify terminal sequenceG               (DECID) exactly as it responds to the DA Primary request.H  6               The old identify sequence is as follows.                    ESC   Z                  027  090n  J               DECtalk identifies itself by sending the following sequence.  .                  ESC   [    ?     1     9    c-                  027  091  063  049  057  099n  A               This is the same sequence as the DA Primary answer.   $               DEVICE TEST AND STATUS  E               A special set of escape sequences runs DECtalk hardware H               self-tests. Another set of escape sequences forces DECtalkI               to return status reports. The following paragraphs describe                these sequences.K                                                                         91                  %               DECtalk Power-Up Status   I               You can reset DECtalk to its power-up state. The method youlJ               use to reset DECtalk may affect the operating features (suchB               as baud rate). You can reset DECtalk with any of theI               following methods. This chapter describes methods 2 through                4.  J               1  Power-up (PUP) is the state that DECtalk is in when first                  turned on.   J               2  Return to initial state (RIS) is a hard reset you can set)                  with an escape sequence.   F               3  soft reset (DECSTR) partially restores DECtalk to its                   power-up state.  E               4  Nonvolatile memory reset (DECNVR) lets you reset the E                  operating features in permanent memory. At power-up,cH                  DECtalk restores the feature settings that you reset in                  this memory.                 92                 F               Table 5-1 lists the DECtalk operating features and theirI               factory default settings; the reset methods in column three :               restore the feature to its power-up setting.  E               The power-up setting is the factory default, unless youlG               changed the setting and stored it with a DECNVR sequence.e8               See the section on DECNVR in this chapter.  E               Table 5-2 lists some other DECtalk actions performed by $               certain reset methods.  =               Table 5-1  Restoring DECtalk Operating Featuresr  )                                   Factory @               Feature             Default   Restored from NVR by  7               Local line speed    9600      PUP, DECNVRd&                                   baud        K                                                                         93A  P              E               Table 5-1 (Cont.)  Restoring DECtalk Operating Features   )                                   Factory @               Feature             Default   Restored from NVR by7               Local line format   No        PUP, DECNVR (                                   parity  7               Host line speed     1200      PUP, DECNVRs&                                   baud  7               Host line format    No        PUP, DECNVR (                                   parity  7               Host C1 transmit    7 bit     PUP, DECNVRu               mode  7               Host C1 receive     7 bit     PUP, DECNVRi               mode                94                 E               Table 5-1 (Cont.)  Restoring DECtalk Operating FeaturesE  )                                   Factoryn@               Feature             Default   Restored from NVR by<               Local log flags     0         PUP, DECNVR, RIS  <               Local terminal      6         PUP, DECNVR, RIS               flagsi  <               Table 5-2  DECtalk Actions Performed at Resets  1               DECtalk Action         Performed Byo  5               Implied DT_SPEAK.      PUP, RIS, DECSTR   5               Hang up telephone.     PUP, RIS, DECSTRq        K                                                                         95                  D               Table 5-2 (Cont.)  DECtalk Actions Performed at Resets  1               DECtalk Action         Performed By -               Delete user            PUP, RISN               dictionary.i  -               Flush all pending      PUP, RIS                text.   -               Turn host speech on.   PUP, RISS  '               Device Self-Test (DECTST)e  B               This sequence initiates local self-tests. The escape%               sequence is as follows.e  .                  ESC   [    5     ;    Pn    y-                  027  091  053  059  ***  121t  I               The Pn parameter specifies the test to perform (Table 5-3).e              96  a              G               The TEST_POWER parameter (Pn = 1) causes DECtalk to rerun.I               its power-up initialization and test sequences. ALL DECtalk B               operating features return to the power-up state; theG               telephone is hung up, the user dictionary is deleted, ands>               all features are reset to their power-up values.  A               The loopback tests require the appropriate loopbackt               connectors.o  H               The built-in message provides a quick check of the DECtalkD               system. The message includes the version number of the               DECtalk firmware.H                  K                                                                         97o  h              *            Table 5-3  Self-Test Parameters  $                           ASCII Code!                           Decimalr0            Mnemonic       Value         Function  =            TEST_POWER      1            Rerun power-up tests.h                           049l  I            TEST_HDATA      2            Run host port data loopback test.                            050   F            TEST_HCONTROL   3            Run host port control loopback-                           051           test.o  J            TEST_DATA       4            Run local port data loopback test.                           052                     98  1              2            Table 5-3 (Cont.)  Self-Test Parameters  $                           ASCII Code!                           Decimal 0            Mnemonic       Value         FunctionA            TEST_SPEAK      5            Speak a built-in message.                            053   8               Device Status Request (DSR) (Brief Report)  :               The brief DSR escape sequence is as follows.  "                  ESC   [    5    n#                  027  091  053  110C  G               If no malfunctions are detected, DECtalk replies with the9!               following sequence.   "                  ESC   [    0    n#                  027  091  048  110     K                                                                         99r  r              D               If a malfunction is detected, DECtalk replies with the!               following sequence.d  "                  ESC   [    3    n#                  027  091  051  110d  G               Applications can use this brief DSR format in most cases, E               because a brief request does not reset any of DECtalk'saH               internal error flags. The following extended DSR format is4               useful when a malfunction is detected.  ;               Device Status Request (DSR) (Extended Report)   J               The extended DSR escape sequence lets an application programJ               determine when DECtalk was first powered on. The application@               sends the extended DSR escape sequence as follows.                    ESC   [    n                   027  091  110                  100T  D              J               If no malfunctions are detected, DECtalk replies with one ofD               two sequences. If this is the first extended DSR sinceH               DECtalk was powered on, DECtalk replies with the following               sequence.h  B                  ESC   [    0    n   ESC   [     ?     2    1    nA                  027  091  048  110  027  091  063  050  049  110n  D               For later requests, DECtalk replies with the following               sequence.m  B                  ESC   [    0    n   ESC   [     ?    2     0    nA                  027  091  048  110  027  091  063  050  049  1102  G               If a malfunction is detected, DEctalk sends the followingE               sequence.   J                  ESC   [    3    n   ESC   [     ?   Pn   ;    ...  Pn   nJ                  027  091  051  110  027  091  063 ***  059  ...  ***  110      K                                                                        101h  h              B               Each Pn parameter specifies an error as follows. TheF               extended status request sequence resets the error flags.  2                2    2       Communication failure.               050  050  2                2    3       Input buffer overflow.               050  051  6                2    4       Last NVR operation failed.               050  052  <                2    5       Error in phonemic transcription.               050  053  F                2    6       Error in DECtalk private control sequence.               050  054                      102   e              /                2    7       Last DECTST failed.a               050  055  *               Reset to Initial State (RIS)  D               Table 5-1 shows how the reset to initial state affects=               DECtalk. The RIS escape sequence is as follows.                     ESC   c                  027  099   I               This sequence resets DECtalk to its power-up state, without F               changing the speeds or data formats used on the host andF               local communication lines. All pending, unspoken text isH               lost. All user-defined dictionary entries are deleted. TheH               telephone is returned to the on-hook state. Some operatingB               features are restored from nonvolatile memory (NVR).  H               The RIS sequence always turns host speech on, even if host9               speech is turned off by the setup commands.r    K                                                                        103n  c              I               This NVR recall is almost identical to a DECNVR recall fromsF               user memory. (See "NVR Parameters" in this chapter.) RISG               does not change the line characteristics, and RIS updateseE               the "status of the last NVR operation" flag reported byo,               device status reply sequences.  D               Digital recommends always using the DT_PHONE:ph_hangupG               sequence to hang up the telephone. If DECtalk receives anaH               RIS sequence when the telephone is off-hook, and reads theG               telephone status during the hangup, DECtalk may report an_G               off-hook status (instead of the expected on-hook status).   *               Soft Terminal Reset (DECSTR)  J               Table 5-2 shows how the soft terminal reset affects DECtalk.7               The DECSTR escape sequence is as follows.o  #                  ESC   [    !     pd#                  027  091  033  112a                  104                  I               This sequence resets DECtalk to its power-up state, without F               changing the speeds or data formats used on the host andF               local communication lines, or resetting user convenienceG               features on the local terminal. Pending, unspoken text is C               not lost. The telephone returns to the on-hook state.   D               Digital recommends always using the DT_PHONE:ph_hangupF               sequence to hang up the telephone. If DECtalk receives aG               DECSTR sequence when the telephone is off-hook, and readsmH               the telephone status during the hangup, DECtalk may reportJ               an off-hook status (instead of the expected on-hook status).  F               The DECSTR sequence always turns host speech on, even if>               host speech is turned off by the setup commands.              K                                                                        105g                 +               NVR Feature Settings (DECNVR)l  E               You can store operating feature settings permanently inaJ               nonvolatile memory (NVR). DECtalk restores these settings atH               the next power-up. To save or restore the current settings?               in NVR, use the following DECNVR escape sequence.   1                  ESC   [   Pn    ;   Pm   !     r 2                  027  091  ***  059  ***  033  114  I               If Pn is 0, this sequence restores all feature settings fom J               NVR. This action may change the speeds or data format of theC               serial lines, so communication with the host or local G               terminal may be lost. The user dictionary is not deleted.p+               The telephone is not hung up.S  B               If Pn is 1, this sequence stores all current featureJ               settings in NVR. DECtalk stops processing host line commands;               until the feature settings are safely stored.0                  106                  J               The Pm parameter specifies which NVR memory to use. Memory 0A               is a read/write memory you can use to store featuresJ               settings. DECtalk normally uses memory 0 at power-up. MemoryG               1 is a read-only memory, and always contains the factory-rH               default DECtalk feature settings. DECtalk uses memory 1 atF               power-up if memory 0 cannot be used. Diagnostics may useE               memory 1 to force DECtalk back to its factory settings.b  I               DECtalk remembers the success or failure status of the lasteB               NVR operation command. A device status request (DSR)-               sequence can check this status.   ,               TRACING AND DEBUGGING COMMANDS  E               You can set DECtalk to log its actions and reactions to H               various commands on the local terminal. These commands areI               useful for testing and debugging during application programi               development.        K                                                                        107                  (               Local Log Control (DT_LOG)  G               This sequence controls the logging of trace and debugging J               information on the local terminal. DT_LOG works like the SETG               LOG command in setup mode. (See the DECtalk DTC01 Owner's ?               Manual. The DT_LOG escape sequence is as follows.   F                  ESC   P    0     ;    8     1    ;    P3   z   ESC  \F                  027  080  048  059  056  049  059  ***  122  027  092  >               Use the following method to obtain the P3 value.  H               1  Add up the values of the DT_LOG parameters in Table 5-4&                  that you want to use.  E               2  Convert the sum to ASCII digits. Use these digits in 4                  place of P3 in the escape sequence.                        108                  '            Table 5-4  DT_LOG Parameters   *            Mnemonic        Value  Function  (            LOG_TEXT          1    Enable  ?            LOG_PHONEME       2    Enable phonemic text logging.8  J            LOG_RAWHOST       4    Send all characters from the host to the>                                   terminal without inspection.  F            LOG_INHOST        8    Enable logging of text read from the'                                   host.   J            LOG_OUTHOST      16    Enable logging of text sent to the host.  E            LOG_ERROR        32    Enable the display of DECtalk errorn+                                   messages.e      K                                                                        109   f              /            Table 5-4 (Cont.)  DT_LOG ParametersR  *            Mnemonic        Value  FunctionA            LOG_TRACE        64    Symbolically display all escape ?                                   sequences that affect DECtalk -                                   operations.e  D            LOG_DEBUG       128    Reserved for Digital internal use.  >               For example, assume you want to set LOG_TEXT and               LOG_RAWHOST.  *                      LOG_TEXT           =1*                      LOG_RAWHOST        =4+                                        ____   *                      Desired P3 value   =5  I                  ESC   P    0    ;     8    1     ;     5    z    ESC   \2F                  027  080  048  059  056  049  059  053  122  027  092              110                  J               Table 5-4 lists the P3 parameters. Figure 5-1 shows the data.               paths for logging and debugging.                 LOG_TEXT  I               This command logs all spoken text. The text source does notmI               matter; text is logged from both the host and the terminal.e                 LOG_PHONEME[  ?               This command logs all spoken text in its phonemic B               transcription. LOG_PHONEME is useful for testing the1               phonemic form of words and phrases.                  LOG_RAWHOST   B               This command logs all control and text characters asH               received, except NUL characters (which are always deleted)G               and XON/XOFF characters (which still perform flow control                functions).     K                                                                        111                                 LOG_INHOST  F               this command logs all characters received from the host.,               Control characters also print.                 LOG_OUTHOSTa  H               This command logs all characters sent to the host. Control$               characters also print.                 LOG_ERRORa  I               This command logs all error messages. Usually DECtalk error D               messages are returned as escape sequences. Setting theE               LOG_ERROR flag causes error messages to be logged also.   H               LOG_ERROR is useful during the early stages of application"               program development.                      112   h                             LOG_TRACEo  E               This command displays all escape sequences symbolicallypF               rather than as escape sequences. If you use LOG_TRACE inI               debugging, you do not have to look up the meaning of escapeo               sequences.  2               LOCAL TERMINAL COMMAND (DT_TERMINAL)  I               This escape sequence controls the destination of characters E               typed on the local terminal when the terminal is not in G               setup mode. (The TERM_FILTER parameter affects characters J               sent to the local terminal when the terminal is not in setupF               mode.) Figure 5-2 shows the data paths in local terminal               operations.   A               The format of the DT_TERMINAL escape sequence is as                follows.  G                  ESC   P    0    ;     8    2     ;    P3    z   ESC  \uF                  027  080  048  059  056  050  059  ***  122  027  092    K                                                                        113                  >               Use the following method to obtain the P3 value.  I               1  Add up the values of the DT_TERMINAL parameters in Table *                  5-5 that you want to use.  E               2  Convert the sum to ASCII digits. Use those digits in 4                  place of P3 in the escape sequence.  ?               For example, assume you want to set TERM_HOST andE               TERM_EDITED.  '                      TERM_HOST      = 1 '                      TERM_EDITED    = 4 (                                    -----  '                 Desired P3 value    = 5   H                  ESC   P    0    ;     8    2     ;     5    z   ESC   \F                  027  080  048  059  056  050  059  053  122  027  092  5               Table 5-5 lists the possible P3 values.r                114   T              G               NOTE: If LOG_RAW and TERM_HOST are in effect and the host D               sends a device attribute request, both DECtalk and theE               terminal will respond. The application progam sample in <               Chapter 6 turns off TERM_HOST for this reason.  ,            Table 5-5  DT_TERMINAL Parameters  (            Mnemonic      Value  Function  H            TERM_HOST      1     Send all characters typed on terminal to*                                 host line.  G            TERM_SPEAK     2     Speak all characters typed on terminal.s  A            TERM_EDITED    4     Line edit all characters typed onpH                                 terminal. (See the DECtalk DTC01 Owner's(                                 Manual.)        K                                                                        115i                 4            Table 5-5 (Cont.)  DT_TERMINAL Parameters  (            Mnemonic      Value  FunctionD            TERM_HARD      8     Do local terminal echo operations in9                                 hardcopy terminal format.e  E            TERM_SETUP    16     Speak all characters displayed on theE<                                 terminal when in setup mode.  D            TERM_FILTER   32     Do not send DECtalk-specific escapes:                                 sequences to the terminal.  G               NOTE: When you set TERM_FILTER, DECtalk also ignores non- I               DECtalk escape sequences (except those needed for characternG               set and communications setup). You still need to set LOG_sI               RAWHOST on to have DECtalk send text to the local terminal.                     116                  J               TERM_FILTER is useful when you use DECtalk as a link betweenD               a general-purpose operating system and an applicationsI               terminal. TERM_FILTER modifies the operation of LOG_RAWHOST I               to prevent sending DECtalk-specific escape sequences to the                local terminal.0  F               When you set TERM_FILTER, the following escape sequencesH               usually processed by DECtalk are now only processed by the               local terminal.e  1               o  Device self-test (ESC [ 5 ;Ps y)e  8               o  Brief device status request (ESC ] 5 n)  9               o  Extended device status request (ESC [ n)r  /               o  Reset to initial state (ESC c)i  0               o  Soft terminal reset (ESC [ ! p)  3               o  NVR parameters (ESC [ Pn ; Pn ! r)l  6               o  Device attributes inquiry (ESC [ 0 c)  K                                                                        117                  *               o  Identify terminal (ESC z)  I               The following escape sequences are acted on by both DECtalka%               and the local terminal.   @               o  Select active character set (several sequences)  @               o  Select graphics repertory (ESC i B and ESC i <)  8               o  Select 7-bit C1 transmission (ESC SP F)  8               o  Select 8-bit C1 transmission (ESC SP G)  9               o  Truncate high-order bit in C1 (ESC SP 6)D  7               o  Accept high-order bit in C1 (ESC SP 7)t  B               Because TERM_FILTER must parse and understand escapeD               sequences, you can only use TERM_FILTER when the localJ               terminal supports ANSI escape sequences. Digital's VT100 andE               VT200 series terminals and the terminals communicationseI               programs available for Digital's personal computers support $               ANSI escape sequences.              118   t              +               KEYPAD MASK COMMAND (DT_MASK)s  J               This command controls how DECtalk sends escape sequences and?               keypad characters to the host. DT_MASK simplifies I               application development when DECtalk is connected to a hostDF               via a packet-switched network or a network using the SNAJ               (systems network architecture) protocol. These networks haveE               a significant overhead associated with each message, so A               sending a line of text (several characters) is mores9               economical than sending a single character.   D               DT_MASK is also useful when DECtalk is connected to anH               operating system that prefers to communicate line-by-line,C               rather than character-by-character. For example, when F               DT_MASK is on, you can use BASIC's INPUT LINE command to%               read text from DECtalk.   H               The command takes one parameter, which is interpreted as aE               16-bit value. If a bit is set, DECtalk sends a carriageqJ               return after sending the associated keypad character. If anyJ               bit is set, DECtalk sends a carriage return after its escape  K                                                                        119                  F               sequence replies. (The carriage return follows the ESC \C               string terminator.) The DT_MASK escape sequence is asT               follows.  G                  ESC   P    0    ;     8     3     ;   P3   z   ESC   \ F                  027  080  048  059  056  051  059  ***  122  027  092  D               The P3 parameter is bit-encoded. Specified values haveH               associated characters (Table 5-6). If you specify a value,B               DECtalk sends a carriage return after the associated8               characters (when a user presses that key).  +               Table 5-6  DT_MASK Parameters   $               Value   Bit  Character                     1   0    0                     2   1    1                120                  3               Table 5-6 (Cont.)  DT_MASK Parametersh  $               Value   Bit  Character                   4   2    2                     8   3    3                    16   4    4                    32   5    5                    64   6    6                   128   7    7                   256   8    8                   512   9    9      K                                                                        121                  3               Table 5-6 (Cont.)  DT_MASK Parameters   $               Value   Bit  Character                1024   10   *                  2048   11    #h                  4096   12   A                  8192   13   B                 16384   14   C                 32768   15   D  J               For example, to have DECtalk treat the # and * characters asH               response terminators (but not the digits), a program would*               send the following sequence.  Q                  ESC   P    ;    8     3     ;    3    0    7    2    z    ESC  \eP                  027  080  059  056  057  059  051  048  055  050  122  027  092            122i  h              %                  (3072 = 1024 + 2048)C  I               If the person calling the application presses 123# followed)D               by a keypad timeout, DECtalk would send the following.  *                  1 2 3 # <carriage return>F                  ESC   P   ;   7   0    ;    2    z  ESC  \  <carriage                  return>8                  027 080 059 055 048 059 050 122 027 092  A               This allows the application program to use standardDJ               line-oriented input routines, rather than character-orientedH               routines. If you specify a P3 parameter of 0 with DT_MASK,B               DECtalk will not send a carriage return after keypad-               characters or escape sequences.   A               NOTE: DECtalk will send a carriage return after all8D               sequences, including responses to non-DECtalk-specificE               sequences such as device status request. Only responses J               generated within DECtalk are affected. Characters and escape    K                                                                        123                  F               sequences generated by a local terminal are sent without               interpretation.   E               The DECtalk support library does not interpret carriagemJ               return characters. You have to process carriage returns withJ               an application program. (Usually, an application will ignore               them.)  1               DETERMINING FIRMWARE REVISION LEVEL   D               If your application environment has DECtalk units withJ               different versions of firmware (1.8 and 2.0) you may need toH               determine the revision level of a particular unit. You canH               use the following steps to determine the firmware revision               level.  H               1  Use the extended DSR escape sequence in this chapter toH                  clear all DECtalk errors. (Remember to note the DECtalk                  reply.)  I               2  Use the following escape sequence to send a [+] phoneme.e  4                     ESC   P    ;     z    +   ESC  \            124                  5                     027  080  059  122  043  027  092   F                     This is silent and new to revision level 2.0 only.  I               3  Send another extended DSR escape sequence. If DECtalk iscJ                  a firmware revision level 1.8, it will report an error inI                  the phonemic transcription. If DECtalk is revision level 4                  2.0, it will not report any errors.  G                     ESC   [    0     n    ESC  [     ?     2    0     naD                     027  091  048  110  027  091  063  050  048  110)                     (firmware 2.0 report)i  F                     ESC   [    3     n    ESC  [     ?    2    5     nD                     027  091  051  110  027  091  063  050  053  110)                     (firmware 1.8 report)                  Phonemic AlphabetI  F               Appendix A lists all phonemes you can use in the DECtalk                phonemic alphabet.    K                                                                        125                  &            1       C PROGRAM EXAMPLE 6  C               This chapter provides the source listings of a samplenH               DECtalk application written in C programming language. TheD               program uses DEctalk, a host computer, and a telephoneG               connection to the United States public telephone network.   I               You can copy and use this application program; however, the D               program is only a model, and connot cover all possibleE               DECtalk applications. You will find many algorithms and J               sections within the application that you can use in your ownF               program; however, you will probably have to modify largeI               sections of this program for your own needs. Also, there is H               no guarantee that this application program will run in theJ               same way on your computer or on your public telephone systemC               (especially if you do not live in the United States).                       126r  t              F               The source programs are available from the DECUS LibraryH               (Digital Equipment Corporation User's Society) as 11-SP-58B               (for PDP-11s) or V-SP-20 (for VAX/VMS). RSX and RSTSJ               operating systems need a system services library distributedJ               with DECUS C (DECUS 11-SP-18). All operating systems requireJ               a C compiler to compile the programs. The DECUS library alsoJ               has versions of the library written in BASIC-PLUS and COBOL.  E               To order the latest version of source programs from thel2               DECUS Library, mail your request to:  $               DECUS Order Processing               MR02-1/C11               One Iron Way                Marlboro, MA 01752  I               For general information before placing an order, call (617)u               480-3422.         K                                                                        1270  d              ,               PROGRAM LANGUAGE AND STRUCTURE  B               This application program is written in C, a languageF               originally written for the UNIX operating system. C is aG               highly structured language, similar to Pascal, ALGOL, and <               COBOL in form and syntax. C is also reasonablyJ               transportable: the application program shown here can run onE               RSTS/E, RSX, UNIX, or VAX/VMS operating systems (if theh6               correct compilers are on those systems).  I               The application is written in many small modules, which areTJ               called according to a tree structure (Figure 6-1). There areC               many modules, because each module has only one or twoeI               functions within the program. The small, tight structure of G               each module means that their function is easy to read and                grasp.  D               All variables, constants, and other special values areG               listed in one module: DECTLK.H. You must include DECTLK.H,8               with the compilation of all other modules.                128k                 #               HOW THE PROGRAM WORKSi  D               The application program waits for a caller to dial theG               DECtalk phone number. DECtalk then acts as a link between H               the host computer and the caller, passing a canned messageJ               to the caller and informing the host when the caller pressesE               any keypad buttons. DECtalk releases the phone line (1)eI               when the caller hangs up, or (2) if no response is receivedi-               after a certain length of time.   +               The program works as follows.   :               1  When started, the program establishes theI                  DECtalk-telephone-host operating environment. DECtalk ish2                  set to wait for an incoming call.  H               2  When a phone call is received, DECtalk answers the call<                  and informs the host that a call is active.  J               3  The host then sends a message for DECtalk to speak to theH                  caller. This message informs the caller that the keypad                  can be used.   K                                                                        129                  H               4  At the end of the host message, the telephone keypad isF                  enabled and the caller can send responses back to the                  host.  I               5  The host responds with a "you pressed button..." message G                  when the caller presses a keypad button. If the caller F                  doesn't press a button for 15 seconds, the host tells.                  DECtalk to hang up the phone.  ,               VARIABLE NAMES AND DEFINITIONS  J               All global variables and constants are defined in the moduleI               DECTLK.H. The function of an escape sequence or coded replyBG               from DECtalk is not clear when embedded within a program; H               therefore, all escape sequences and status codes are givenJ               their mnemonic names in DECTLK.H. The program then refers toB               these names rather than the escape codes themselves.  H               What follows is a list of the global variables, mnemonics,8               and codes used in the application program.                130                                 Flags2  H               Two flags are used throughout the application program. TheA               flags control certain critical actions, as follows.d  E               dt_abort   This flag is normally FALSE. If dt_trap() is C                          called, the library will trap a CTRL-C (or J                          INTERRUPT on UNIX). If the user types CTRL-C, theI                          flag is set to TRUE and all library modules exit 0                          as quickly as possible.  G               dt_debug   This flag can be set nonzero by an applicationeI                          program to enable debug printouts. Note that thesF                          library must have been compiled with dt_debugE                          defined in order to compile in the necessarya%                          print calls.p            K                                                                        131                                 Error Codesf  I               The library may return the following error codes. The errortH               codes are all less than zero, so they cannot be defined as.               part of the ASCII character set.  =               DT_ERROR    An operating system error occurred.e  D               DT_TIMEOUT  An input operation did not complete in the;                           required (operating system) time.   C               IO_ERROR    This is an error exit code for the exit() H                           library routine. The value selected depends on:                           the particular operating system.                            132w  u              )               DECtalk-Specific Parameters   I               Certain codes apply only to DECtalk (and not other devices,[=               such as terminals). These codes are as follows.   H               CSI_DA_PRODUCT          The DECtalk product identification+                                       code.i  I               DCS_F_DECTALK           The DECtalk specific device controloE                                       sequence (DCS) final character.o  J               P1_DECTALK              All DTC01-AA DCS sequences send thisE                                       for their first (P1) parameter.f  H               R1_DECTALK              All DTC01-AA DCS replies send thisJ                                       for the first (R10) reply parameter.            K                                                                        133m                                DECtalk Commands  J               The DECtalk commands that do not require specific parameters#               are coded as follows.   0               P2_PHOTEXT    Speak phonemic text.  *               P2_STOP       Stop speaking.  (               P2_SYNC       Synchronize.  4               P2_SPEAK      Enable/disable speaking.  '               P2_INDEX      Index text.1  -               P2_IX_REPLY   Index with reply.   5               P2_IX_QUERY   Return last spoken index.s  1               P2_DICT       Load user dictionary.n                  134e  (              E               P2_PHONE      Telephone control (See "Telephone ControlU)                             Parameters.")   3               P2_MODE       Synthesis mode control.   7               P2_LOG        Local terminal log control.a  3               P2_TERMINAL   Local terminal control.n  *               Telephone Control Parameters  H               The telephone control command P2_PHONE takes an additionalA               parameter to specify the specific telephone action.D                K                                                                        135                  ;               P3_PH_STATUS            Send a status report.   9               P3_PH_ANSWER            Answer on P4 rings.   8               P3_PH_HANGUP            Hang up the phone.  ?               P3_PH_KEYPAD            Enable keypad data entry.   @               P3_PH_NOKEYPAD          Disable keypad data entry.  F               P3_PH_TIMEOUT           Send a timeout report if no dataD                                       entered in P4 seconds if P4 isI                                       greater than zero; disable timeoutse4                                       if P4 is zero.  A               P3_PH_TONE              Dial out using Touch-Tones.   <               P3_PH_PULSE             Dial out using pulses.                  136o                                DECtalk Replies   >               Several P2_commands return messages to the host.  F               R2_IX_REPLY   Reply to P2_IX_REPLY. R3 contains the last,                             index processed.  F               R2_IX_QUERY   Reply to P2_IX_QUERY. R3 contains the last,                             index processed.  H               R2_DICT       Reply to P2_DICT. R3 contains the dictionary.                             entry status code.  H               R2_PHONE      Reply to P2_PHONE. R3 contains the telephone#                             status.e  J               DECtalk returns the following R3 parameters after a P2_PHONE               command.        K                                                                        137e  u              F               R3_PH_ONHOOK            Telephone is hung up (inactive).  E               R3_PH_OFFHOOK           Telephone is answered (active).   J               R3_PH_TIMEOUT           No data was entered by the telephoneH                                       user within the required number of.                                       seconds.  G               R3_PH_TOOLONG           A telephone number to dial is too +                                       long.   I               DECtalk returns the following R3 parameters after a P2_DICTC               command.  B               R3_DI_LOADED            Dictionary entry was loaded.  B               R3_DI_NOROOM            The user dictionary is full.  G               R3_DI_TOOLONG           The dictionary entry is too long.a                  138o  o              "               Self-Test Parameters  D               The following parameters control the DECtalk self-test               (DECTST).   :               TEST_POWER              Rerun power-up test.  G               TEST_HDATA              Run host data link loopback test.i  A               TEST_HCONTROL           Run host line control test.t  ?               TEST_LDATA              Run local line data test.   =               TEST_SPEAK              Speak a canned message.o  I               The following status codes are returned by the extended DSRw               sequence.           K                                                                        139   c              9               DSR_OK                  No errors detected.   <               DSR_COMFAIL             Communication failure.  <               DSR_INBUFOVER           Input buffer overflow.  J               DSR_DECNVRFAIL          Last restore from nonvolatile memory-                                       failed.r  @               DSR_PHONEME             Incorrect phoneme entered.  B               DSR_PRIVATE             DECtalk DCS parameter error.  C               DSR_DECTSTFAIL          Last DECTST self-test failed.r                          140g  e              (               Logging Command Parameters  D               The following parameters configure the P2_LOG command.  6               LOG_TEXT                Log spoken text.  =               LOG_PHONEME             Log generated phonemes.R  F               LOG_RAWHOST             Log all characters received from:                                       host without change.  F               LOG_INHOST              Log all characters received from=                                       host in visible format.O  G               LOG_OUTHOST             Log all output to host in visiblen-                                       format.   9               LOG_ERROR               Log error messages.   D               LOG_TRACE               Log commands in mnemonic form.    K                                                                        141                  G               The following parameters are for the P2_TERMINAL command.s  F               TERM_HOST               Send text entered from the local;                                       terminal to the host.   G               TERM_SPEAK              Speak text entered from the local /                                       terminal.p  E               TERM_EDITED             Line-edit text entered from then5                                       local terminal.e  D               TERM_HARD               Use hardcopy edit conventions.  9               TERM_SETUP              Speak setup dialog.   H               TERM_FILTER             Filter sequences sent to the local/                                       terminal.                       142                  C               The following parameters are for the P2_MODE command.T  F               MODE_SQUARE             Accept [] bracket phonemic text.  J               MODE_ASKY               Use single-letter phonemic alphabet.  H               MODE_MINUS              Pronounce a hyphen (-) as "minus."  )               THE SEQUENCE DATA STRUCTURE   H               The C language uses a powerful form of information controlG               called a data structure. Data structures closely resembledE               Pascal records and can pass and hold multiple pieces ofp               information.  A               All information needed to generate and parse escape1F               sequences is in the SEQUENCE data structure. SEQUENCE is9               configured by the following size constants.         K                                                                        143   t              D               SEQ_INTMAX              Maximum number of intermediate1                                       characters.e  C               SEQ_PARMAX              Maximum number of parameters.r  @               The SEQUENCE data structure contains the following               components.   D               short state             Processing state or introducer8                                       character to send.  B               char final              final character in sequence.  H               char private            Private introducer character (or X<                                       to indicate an error).  D               short param[]           Private parameters (unsigned);E                                       param[0] contains the number of 1                                       parameters.h                144v                 F               char inter[]            Intermediate character; inter[0]<                                       contains the number of4                                       intermediates.  H               All information needed by the application progam is in theF               DECTALK data structure which is created by dt_open() and@               freed by dt_close(). The DECtalk data structure is5               configured by the following parameters.m  I               PEND_SIZE               Maximum number of keypad characterslI                                       that may be typed ahead. Additional ?                                       characters are discarded.   H               IN_BUFLEN               Size of the operating system input-                                       buffer.b  I               OUT_BUFLEN              Size of the operating system output -                                       buffer.       K                                                                        145u                 A               The data buffer contains the following information.   G               DECTALK *link           Chains together all active units.a  C               int unit                Operating system I/O channel.   ?               short timeout           TRUE if timeouts enabled.   >               short pend_fc           Bytes in pending buffer.  C               short pend_fp           Index to free byte in pending -                                       buffer.a  G               short pend_ep           Index to next byte to return from 5                                       pending buffer.   ;               char *in_ptr            Input buffer pointer.   7               char *in_end            Input buffer end.                   146n                 A               char *out_ptr           Output buffer free pointer.P  =               SEQUENCE send           Last DCS sequence sent.3  B               SEQUENCE reply          Last DECtalk reply received.  F               SEQUENCE seq            Look-ahead for string terminator1                                       processing.   H               char *device            Remember dt_open() device name for6                                       debug printouts.  8               char pend[]             Type-ahead buffer.  3               char in_buff[]          Input buffer.u  4               char out_buff[]         Output buffer.        K                                                                        147o  e              J               struct sgtty stty_save  Terminal characteristics block (UNIX,                                       only).  A               FILE *fildes            File descriptor (RSX only).   B               struct iosb iosb        I/O status block (RSX only).  E               struct qioparm parm     QIO parameter block (RSX only).   "               APPLICATION PROGRAMS  J               The rest of this chapter lists the modules used to build theJ               complete application program. All modules with the indicator               comment.                 /*)LIBRARY  G               should be compiled and loaded into an object library. The7C               main program, DEMO.C, is compiled and linked with the 9               DECtalk library and the C standard library.                 148e                 D               The modules appear in the following order (Table 6-1).  4               Table 6-1  Application Program Modules  *               Module     Brief Description  G               DECTLK.H   This file must be included in all modules thatnG                          use the DECtalk applications library. Contains I                          common definitions (for example, escape sequence %                          parameters).   @               DEMO.C     This is the main module of the program.  C               DTANSW.C   Hangs up the phone and answers on n rings.   J               DTCLOS.C   Closes the DECtalk channel and frees all buffers.  E               DTCMD.C    Sends a DCS command to the DECtalk terminal.       K                                                                        149                  <               Table 6-1 (Cont.)  Application Program Modules  *               Module     Brief DescriptionJ               DTDCHA.C   Formats characters into a visible ASCII datascopeJ                          format and writes the text to the indicated file.  >               DTDCS.C    Sends a DECtalk DCS control sequence.  5               DTDIAL.C   Dials the DECtalk telephone.t  ;               DTDRAI.C   Absorbs any type-ahead characters.   I               DTDUMP.C   Writes an escape sequence buffer to the standard 5                          output file (for debugging).   :               DTEOL.C    Writes an end of line to DECtalk.  F               DTGESC.C   Reads an escape sequence or keypad character.                  150_  N              <               Table 6-1 (Cont.)  Application Program Modules  *               Module     Brief DescriptionJ               DTGET.C    Reads a character from the DECtalk terminal line.  E               DTHANG.C   Hangs up the telephone connected to DECtalk.   H               DTINIT.C   Initializes the DECtalk terminal on the channel&                          opened on dt.  9               DTINKE.C   Reads a telephone keypad button.i  F               DTIOGE.C   Reads one character from the DECtalk terminal                          line.  H               DTIOPU.C   Either writes the output buffer contents to theJ                          DECtalk device or stores the character in a local                           buffer.      K                                                                        151                  <               Table 6-1 (Cont.)  Application Program Modules  *               Module     Brief DescriptionB               DTISKE.C   Indicates if the telephone user typed any$                          characters.  E               DTISTI.C   Tests the result of a dtphone () message for (                          keypad timeout.  F               DTISVA.C   Indicates if the argument character is one of*                          0123456789#*ABCD.  B               DTKEYP.C   Enables or disables the telephone keypad.  I               DTMSG.C    Sends a DECtalk DCS control sequence and reads a #                          DCS reply.                     152                  <               Table 6-1 (Cont.)  Application Program Modules  *               Module     Brief DescriptionE               DTOFFH.C   Tests the result of a dt_phone() message for !                          OFFHOOK.s  F               DTONHO.C   Tests the result of a dt_phone () message for                           ONHOOK.  I               DTOPEN.C   Initiates communications by performing operating 9                          system specific initializations.r  F               DTPEEK.C   Tests if a character is pending from DECtalk.  I               DTPESC.C   Compiles an appropriate escape sequence from then*                          parameter buffer.  7               DTPHON.C   Sends a DECtalk phone message.       K                                                                        153e  o              <               Table 6-1 (Cont.)  Application Program Modules  *               Module     Brief Description-               DTPTES.C   Tests a phone reply.e  J               DTPUT.C    Sends one character to the DECtalk terminal line..                          No value is returned.  7               DTREAD.C   Reads a sequence or character.e  <               DTRESE.C   Sends a soft-reset escape sequence.  :               DTSAVE.C   Saves user type-ahead characters.  A               DTSPLICE.C Lets you control a terminal connected to .                          DECtalk's local port.                      154                  <               Table 6-1 (Cont.)  Application Program Modules  *               Module     Brief DescriptionI               DTST.C     Sends a string terminator (for phonemic text ando=                          telephone dial commands) to DECtalk.   B               DTSYNC.C   Synchronizes DECtalk and the application.  1               DTTALK.C   Speaks one line of text.   /               DTTEST.C   Tests a DECtalk reply.   H               DTTIME.C   Enables or disables a telephone keypad timeout.  D               DTTONE.C   Sends the msg text string as a tone dialing"                          sequence.          K                                                                        155.  e              <               Table 6-1 (Cont.)  Application Program Modules  *               Module     Brief Description  1               DTTRAP.C   Traps CTRL-C interrupts.   :               DTVISI.C   Generates visible ASCII character)                          representations.E  B               HELLO.C    Tests that DECtak is operating correctly.                 DECTLK.H  C               DECTLK.H must be included in all modules that use the I               DECtalk applications library. this file also defines commonnC               ASCII characters, DECtalk escape sequence parameters, H               library globals, and the DECtalk buffer structure. You canD               edit this file to enable debugging code defined by the               DTDEBUG flag.                 156t                                  /*F                  *       D e f i n i t i o n s   a n d   G l o b a l s                  *L                  * This file contains symbolic definitions of the structuresF                  * and characters used by DECtalk application progams,D                  * including all DECtalk escape sequence parameters.                  *O                  * Note: on RSX-11M, your program must first #include <stdio.h>                   */                       K                                                                        157                                   /*H                  * Select a UNIX "flavor" (bizarre code as DECUS C lacks                 "defined"()")                   */y                 #ifdef   unixb                 #ifndef  BSD_42i                 #ifndef  UNIX_Vo                 #define  UNIX_V                  #endif                 #endif                 #endif  &                 #ifdef   DOCUMENTATION  E                 title    dectlk.h         DECtalk Library Header File E                 index                     DECtalk library header fileq                   synopsis  +                         #include "dectlk.h"                    description               158   0              G                         This file is included in the compilation of all J                         modules that use the DECtalk applications library.C                         It defines common ASCII characters, DECtalkAD                         escape sequence parameters, library globals,9                         and the DECTALK buffer structure.f                   configurations  F                         You can edit dectlk.h to enable debugging code@                         by defining the DT_DEBUG flag as follow.  .                             #define DT_DEBUG 1  J                         This changes the primary input and output routinesM                         so that they become capable of logging all characters C                         transmitted to and from the DECtalk device.r                   globalsc  L                         The library provides two global flags which are used#                         as follows.w    K                                                                        159                  E                           dt_abort         This is set non-zero by ansJ                                            intercepted CTRL-C trap (if youL                                            have called dt_trap()). When set,H                                            no I/O will be performed, andK                                            library subroutines will exit as ?                                            quickly as possible.   H                           dt_debug         This may be set nonzero by anI                                            applications program to enabletI                                            debug printouts. Note that the J                                            library must have been compiledL                                            with DT_DEBUG defined in order toI                                            compile in the necessary print 1                                            calls.s                   error codest  I                         The library may return the following error codes.tF                         These are all less than zero, and consequentlyB                         cannot be part of the ASCII character set.  F                           DT_ERROR          An operating-system error.            160   t              F                           DT_TIMEOUT        An input operation did notD                                             complete in the requiredD                                             (operating-system) time.  F                           IO_ERROR          An error exit code for theH                                             exit () library routine. TheL                                             value is selected as appropriateH                                             for the particular operating3                                             system.c  .                 Routines implemented as macros  R                           Certain frequently routines may be implemented as macrosA                           (if macro expansion is supported by the G                           particular C compiler). These are as follows.   G                             dt_iskey(dt)      TRUE if data is currently M                                               stored in the keypad type-ahead 5                                               buffer.r      K                                                                        161                  U                             dt_isvalid(c)     TRUE if the character is a valid keypadlY                                               character. Note: evaluation of the argument O                                               must not have side-effects. I.e.,ER                                               you must not write dt_isvalid(*p++).  M                             dt_ptest(dt,r3)   Phone test, TRUE if the current D                                               reply is R2_PHONE, R3.  M                             dt_offhook(dt)    Phone test, TRUE if the currentEN                                               reply is R2_PHONE, R3_PH_ONHOOK.  M                             dt_onhook(dt)     Phone test, TRUE if the currentEN                                               reply is R2_PHONE, R3_PH_ONHOOK.  M                             dt_istimeout(dt)  Phone test, TRUE if the current O                                               reply is R2_PHONE, R3_PH_TIMEOUT.   D                             dt_phone(dt,p3,p4) Send a phone message.  J                             dt_eol(dt)        Send "end of line" and force@                                               output to DECtalk.                162f  d              #                 general definitionsH<                         The following variables are defined.  9                           EOS               End of stringcB                           FALSE             For TRUE/FALSE testingB                           TRUE              For TRUE/FALSE testing                    ascii characters  H                         The following C0 control characters are defined.  @                           NUL   STX  ETX   BEL    BS   VT    LS1  @                           LSO   XON  XOFF  CAN    SUB  ESC   DEL  H                         The following C1 control characters are defined.  @                           SS2   SS3  DCS   OLDID  CSI   ST   OSC  )                           PM    APC  RDELa  S                         The following DECtalk-specific parameters are also defined.   ?                           CSI_DA_PRODUCT    The DECtalk product @                                             identification code.K                                                                        163L                 G                           DCS_F_DECTALK     The DECtalk specific device H                                             control sequence (DCS) final6                                             character.  L                           P1_DECTALK        All DCT01 DCS sequences transmit@                                             this for their first;                                             (P1) parameter.l  J                           R1_DECTALK        All DCT01 DCS replies transmitG                                             this for the first R1 replyE6                                             parameter.  W                           The P2 and P3 parameters select the specific DECtalk command.                               164                  B                            P2_PHOTEXT         Speak phonemic text.<                            P2_STOP            Stop speaking.:                            P2_SYNC            Synchronize.D                            P2_SPEAK           Enable/disable speech.9                            P2_INDEX           Index text.e?                            P2_IX__REPLY       Index with reply.rG                            P2_IX_QUERY        Return last spoken index. C                            P2_DICT            Load user dictionary.c@                            P2_PHONE           Telephone control.E                            P2_MODE            Synthesis mode control.rI                            P2_LOG             Local terminal log control.iE                            P2_TERMINAL        Local terminal control.lB                            P2_MASK            Keypad mask control.  J                          The telephone control command takes an additionalL                          parameter to specify the specific telephone action.          K                                                                        165                  E                            P3_PH_STATUS       Return a status report. A                            P3_PH_ANSWER       Answer on P4 rings.s?                            P3_PH_HANGUP       Hangup the phone. G                            P3_PH_KEYPAD       Enable keypad data entry. H                            P3_PH_NOKEYPAD     Disable keypad data entry.F                            P3_PH_TIMEOUT      Send a timeout report ifK                                               no data entered in P4 seconds I                                               if P4 is greater than zero; M                                               disable timeouts if P4 is zero. C                            P3_PH_TONE         Dial out using tones. D                            P3_PH_PULSE        Dial out using pulses.  I                          Several P2 commands return messages to the host.   F                            R2_IX_REPLY        Reply to P2_IX_REPLY. R3E                                               contains the last index 8                                               processed.  F                            R2_IX_QUERY        Reply to P2_IX_QUERY. R3E                                               contains the last indexe8                                               processed.            166T                 B                            R2_DICT            Reply to P2_DICT. R3K                                               contains the dictionary entryn:                                               status code.  C                            R2_PHONE           Reply to P2_PHONE. R3aL                                               contains the telephone status.  I                          The following R3 parameters are returned after ao*                          P2_PHONE command.  N                            R3_PH_ONHOOK       Telephone is hung up (inactive).  M                            R3_PH_OFFHOOK      Telephone is answered (active). H                            R3_PH_TIMEOUT      No data was entered by theP                                               telephone user within the required@                                               number of seconds.  K                            R3_PH_TOOLONG      A telephone number to dial is 7                                               too long.d  Q                          The following R3 parameters are returned after a P2_DICT !                          command.   K                                                                        167e  t              J                            R3_DI_LOADED       Dictionary entry was loaded.J                            R3_DI_NOROOM       The user dictionary is full.O                            R3_DI_TOOLONG      The dictionary entry is too long.   O                          The following codes are used to control host-requested ,                          self test (DECTST).  C                            TEST_POWER          Rerun power-up test.   P                            TEST_HDATA          Run host data link loopback test.  J                            TEST_HCONTROL       Run host line control test.  H                            TEST_LDATA          Run local line data test.  F                            TEST_SPEAK          Speak a canned message.  P                          The following status codes are returned by the extended&                          DSR sequence.                    168                  A                            DSR_OK             No errors detected.oD                            DSR_COMFAIL        Communication failure.D                            DSR_INBUFOVER      Input buffer overflow.K                            DSR_DECNVRFAIL     Last restore from nonvolatilea<                                               memory failed.H                            DSR_PHONEME        Incorrect phoneme entered.J                            DSR_PRIVATE        DECtalk DCS parameter error.K                            DSR_DECTSTFAIL     Last DECTST self-test failed.a  J                          The following flags configure the P2_LOG command.  =                            LOG_TEXT          Log spoken text.s  D                            LOG_PHONEME       Log generated phonemes.  G                            LOG_RAWHOST       Log all charcters receivedtF                                              from host without change.  H                            LOG_INHOST        Log all characters receivedJ                                              from host in "visible" format    K                                                                        169h  c              F                            LOG_OUTHOST       Log all output to host in<                                              visible format.  @                            LOG_ERROR         Log error messages.  K                            LOG_TRACE         Log commands in mnemonic form.   M                          The following flags are for the P2_TERMINAL command.   G                            TERM_HOST         Send text entered from the H                                              local terminal to the host.  H                            TERM_SPEAK        Speak text entered from the<                                              local terminal.H                            TERM_EDITED       Line-edit text entered from@                                              the local terminal.  L                            TERM_HARD         Use hard-copy edit conventions.  @                            TERM_SETUSPEAK    Speak SETUP dialog.  I                            TERM_FILTER       Filter escape sequences sentrC                                              to the local terminal.               170                  I                          The following flags are for the P2_MODE command.i  G                            MODE_SQUARE       [ ] bracket phonemic text.s  G                            MODE_ASKY         Use single-letter phonemic 6                                              alphabet.  F                            MODE_MINUS        Pronounce '-' as "minus."  N                          The following flags are for the dt_splice() function.  H                            SPLIT_SPEAK       DECtalk speaks text if set.  P                            SPLICE_LOG        Text sent to DECtalk is sent to theL                                              terminal (P2_LOG, LOG_RAWHOST).  J                            SPLICE_TERM       The terminal may send text toJ                                              DECtalk (P2_TERM, TERM_HOST).  +                 Escape sequence data buffer       K                                                                        171e  ]              D                         All information needed to generate and parseE                         escape sequences is contained in the SEQUENCEdI                         data structure. It is configured by the followingw'                         size constants.   K                            SEQ_INTMAX        Maximum number of intermediater8                                              characters.  I                            SEQ_PARMAX        Maximum number of parameters   <                        It contains the following components.  K                            short state       Processing state or introducer ?                                              character to send.   I                            char final        Final character in sequence.o  I                            char private      Private introducer character I                                              or 'X' to indicate an error.   K                            short param[]     Private parameters (unsigned);gL                                              param[0] contains the number of8                                              parameters.            172c  n              E                            char inter[]      Intermediate characters; L                                              inter[0] contains the number of;                                              intermediates.   .                 DECTALK data buffer definition  M                            All information needed by the DECtalk applications M                            library is contained in the DECTALK data structure Q                            which is created by dt_open() and freed by dt_close(). H                            It is configured by the following parameters.  E                            PEND_SIZE         Maximum number of keypadtP                                              characters that may be typed-ahead.Q                                              Additional characters are discarded.   O                            IN_BULFEN         Size of the operating system input 4                                              buffer.  P                            OUT_BULFEN        Size of the operating system output4                                              buffer.  N                            The data buffer contains the following information.  K                                                                        1737                 N                            DECTALK *link     Chains together all active units.  J                            short unit        Operating system I/O channel.  C                            short timeout     Current timeout value.   H                            short flag        Speech and dt_splice flags.  E                            short pend_fc     Bytes in pending buffer.   R                            short pend_fp     Index to free byte in pending buffer.  I                            short pend_ep     Index to next byte to return A                                              from pending buffer.o  B                            char *in_ptr      Input buffer pointer.  >                            char *in_end      Input buffer end.  H                            char *out_ptr     Output buffer free pointer.  D                            SEQUENCE send     Last DCS sequence sent.  I                            SEQUENCE reply    Last DECtalk reply received.o                174p  n              M                            SEQUENCE seq      Look-ahead for string terminator 8                                              processing.  K                            char *device      Remember dt_open() device name A                                              for debug printouts.   ?                            char pend[]       Type-ahead buffer.s  :                            char in_buff[]    Input buffer.  ;                            char out_buff[]   Output buffer.   M                            struct termio stty_save   Terminal characteristics K                                                      block (UNIX System V).   M                            struct sgtty stty_save    Terminal characteristics J                                                      block (UNIX 4.2 BSD).  C                            FILE *fildes      File descriptor (RSX).r  D                            struct iosb iosb  I/O status block (RSX).  G                            QIOPARM parm      QIO parameter block (RSX).k8                                              (RSX only).K                                                                        175e  o              C                            int#pos_xk        TRUE if POS XK: driver 8                                              (RSX only).  I                          The flag entry controls library internal states.   H                            _FLAG_SPEAK       Set if DECtalk is speaking.G                            _FLAG_LOG         Set if LOG RAWHOST is set. E                            _FLAG_TERM        Set if TERM HOST is set. L                            _FLAG_EIGHTBIT    Set to read and write eight-bitH                                              data and control sequences.  R                          FLAG_SPEAK, FLAG_LOG, and FLAG_TERM should not be changed1                          by application programs.r  P                          FLAG_EIGHTBIT must be set by the application program ifP                          DECtalk send and receives C1 control sequences in theirK                          8-bit form. Note that the application program must.K                          ensure that the operating system passes 8-bit data R                          correctly and DECtalk setup must set HOST FORMAT to NONE.                  176u                                  UNIX NotesF                         On UNIX System V, the DECtalk terminal line isC                         forced to 9600 Baud. This may be changed toe^                         retain the current Baud rate. Also, you should be aware that there areO                         numerious subtle differences between operating systems.                    Note  S                         UNIX and System V are trademarks of AT&T Bell Laboratories.                    #endif                    /*hK                  * Define DT_DEBUG to enable debug printouts of transmittedR                  * characters.                  */e  "                  # define DT_DEBUG  #                  #define FALSE    0 #                  #define TRUE     1 &                  #indef  EOS      '\0'                  #endif K                                                                        177                                    #ifdef  unix                   #ifdef  BSD_42r+                  #include         <sgtty.h>G                  #else                  #ifdef  UNIX_V ,                  #include         <termio.h>                  #endif                   #endif                   #endif                     /* D                   * These error codes may not be in the ASCII range.                   */  .                 #define DT_ERROR         ( -1).                 #define DT_TIMEOUT       ( -2)                   /*(                  * CO control characters                  */e                178                  X                 #define NUL              0x00     /* NUL code                         */X                 #define STX              0x02     /* Start of text                    */X                 #define ETX              0x03     /* End of text                      */X                 #define BEL              0x07     /* Bell                             */X                 #define BS               0x08     /* Backspace                        */X                 #define VT               0x0B     /* Vertical tab ('\013')            */X                 #define LS1              0x0E     /* LS1 (SO)                         */X                 #define LS0              0x0F     /* LS0 (SI)                         */X                 #define XON              0x11     /* DC1                              */X                 #define XOFF             0x13     /* DC3                              */X                 #define CAN              0x18     /* Cancel <CTRL/X>                  */X                 #define SUB              0x1A     /* Substitute                       */X                 #define NUL              0x00     /* Null code                        */X                 #define ESC              0x1B     /* Escape                           */X                 #define DEL              0x7F     /* Delete                           */                 /*(                  * C1 control characters                  */     K                                                                        179   a              X                 #define SS2              0x8E     /* Single shift 2                   */X                 #define SS3              0x8F     /* Single shift 3                   */X                 #define DCS              0x90     /* Device control sequence          */X                 #define OLDID            0x9A     /* ESC Z                            */X                 #define CSI              0x9B     /* Control Sequence Introducer      */X                 #define ST               0x9C     /* String terminator                */X                 #define OSC              0x9D     /* Operating System sequence        */X                 #define PM               0x9E     /* Privacy Message                  */X                 #define APC              0x9F     /* Application Program Control      */X                 #define RDEL             0xFF     /* Delete in right side             */X                 #define CSI_DA_PRODUCT     19     /* Dectalk DA product code          */                   /*?                  * Basic definitions for DEctalk device control K                  * strings. All DECtalk sequences have a first parameter of M                  * P1_DECTALK. This provides an easy place for future DECtalke=                  * products to fit into the scheme of things.e                  */iW                  # define DCS_F_DECTALK  'z'       /* DECtalk final                  */ W                  # define P1_DECTALK     0         /* DECtalk param 1                */               180                  W                  # define R1_DECTALK     0         /* DECtalk reply param 1          */e                 /*B                  * The second parameter selects the basic command.                  */   W                 #define P2_PHOTEXT          0     /* Speak phonemic text             */ W                 #define P2_STOP            10     /* Stop speaking                   */ W                 #define P2_SYNC            11     /* Synchronize                     */aW                 #define P2_SPEAK           12     /* Enable or disable speaking      */ W                 #define P2_INDEX           20     /* INDEX                           */ W                 #define P2_IX_REPLY        21     /* INDEX_REPLY                     */ W                 #define P2_IX_QUERY        22     /* INDEX_QUERY                     */ W                 #define P2_DICT            40     /* Dictionary control              */mW                 #define P2_PHONE           60     /* Phone control                   */nW                 #define P2_MODE            80     /* Synthesis mode control          */rW                 #define P2_LOG             81     /* LOG information on local tty    */ W                 #define P2_TERMINAL        82     /* Local terminal control          */ W                 #define P2_MASK            83     /* Set keypad mask                 */       K                                                                        181I  t                               /*?                  * Additional parameters for the phone command.                   */QW                 #define P3_PH_STATUS       0     /* Send a status report             */sW                 #define P3_PH_ANSWER       10    /* Answer (P4 has ring number)      */ W                 #define P3_PH_HANGUP       11    /* Hangup                           */ W                 #define P3_PH_KEYPAD       20    /* Raw keypad                       */(W                 #define P3_PH_NOKEYPAD     21    /* Disable keypad                   */ W                 #define P3_PH_TIMEOUT      30    /* Status report on timeout         */ W                 #define P3_PH_TONE         40    /* Send a status report             */uW                 #define P3_PH_PULSE        41    /* Send a status report             */                    /*N                  * The second parameter in a reply specifies the general class)                  * of the reply sequence.r                  */                     182                  Y                 #define R2_IX_REPLY        31     /* Sent after INDEX_REPLY            */)Y                 #define R2_IX_QUERY        32     /* Sent after INDEX_QUERY            */ Y                 #define R2_DICT            50     /* Sent after DICT                   */ Y                 #define R2_PHONE           70     /* Telephone status report           */                  /*Q                  * Additional reply information is passed in the third parameter.                   */   Y                 #define R3_PH_ONHOOK       0      /* Hung up                           */tY                 #define R3_PH_OFFHOOK      1      /* Phone is lifted                   */ Y                 #define R3_PH_TIMEOUT      2      /* No reply in N seconds             */ Y                 #define R3_PH_TOOLONG      3      /* Telephone # text too long         */TY                 #define R3_PH_LOADED       0      /* Dictionary entry loaded ok        */nY                 #define R3_PH_NOROOM       1      /* No room in dictionary             */ Y                 #define R3_PH_TOOLONG      2      /* String too long                   */                    /*E                  * Test specification codes for the request self tests%                  * (DECTST) sequence.n                  */   K                                                                        183                  Z                 #define TEST_POWER        1      /* Rerun power up tests                */Z                 #define TEST_HDATA        2      /* Host line data loopback test        */Z                 #define TEST_HCONTROL     3      /* Host line control test              */Z                 #define TEST_LDATA        4      /* Local line data test                */Z                 #define TEST_SPEAK        5      /* Speak a canned message              */                   /*K                  * Error (and success) codes for the extended DSR sequence.                   */e  [                 #define DSR_OK            20     /* All OK                               */h[                 #define DSR_COMMFAIL      22     /* Communication failure                */ [                 #define DSR_INBUFOVER     23     /* Input buffer overflow                */ [                 #define DSR_DECNVRFAIL    24     /* Last DECNVR failed                   */ [                 #define DSR_PHONEME       25     /* Error in phonemic text               */ [                 #define DSR_PRIVATE       26     /* Error in DECtalk private DCS         */ [                 #define DSR_DECTSTFAIL    27     /* Last DECTST failed                   */E                   /*>                  * Local logging flags for the P2_LOG command.                  */               184                  [                 #define LOG_TEXT          0x0001 /* Log text that is spoken              */ [                 #define LOG_PHONEME       0x0002 /* Log generated phonemes               */ [                 #define LOG_RAWHOST       0x0004 /* Log raw host input                   */ [                 #define LOG_INHOST        0x0008 /* Log host input                       */ [                 #define LOG_OUTHOST       0x0010 /* Log host output                      */ [                 #define LOG_ERROR         0x0020 /* Log errors                           */ [                 #define LOG_TRACE         0x0040 /* Log sequence trace info.             */                    /*D                  * Local terminal flags for the P2_TERMINAL command.                  */   [                 #define TERM_HOST         0x0001 /* Send text to host                    */ [                 #define TERM_SPEAK        0x0002 /* Speak local terminal input           */u[                 #define TERM_EDITED       0x0004 /* Edited                               */ [                 #define TERM_HARD         0x0008 /* Local terminal is hardcopy           */ [                 #define TERM_SETUSPEAK    0x0010 /* Spoken setup mode                    */r[                 #define TERM_FILTER       0x0020 /* Filter logged esc. sequences         */       K                                                                        185                                   /*6                  * Mode flags for the P2_MODE command.                  */   [                 #define MODE_SQUARE       0x0001 /* [] are phonemic brackets             */ [                 #define MODE_ASKY         0x0002 /* Use ASKY alphabet                    */ [                 #define MODE_MINUS        0x0004 /* "_" is pronounced minus              */                    /*B                  * Flags for dt_splice() and ((DECTALK *)dt)->flag                  */   [                 #define SPLICE_SPEAK      0x0001 /* Speak text if set                    */ [                 #define SPLICE_LOG        0x0002 /* Log rawhost if set                   */l[                 #define SPLICE_TERM       0x0004 /* Local host if set                    */ [                 #define _FLAG_SPEAK       0x0001 /* Speaking, set by dt_splice()         */ [                 #define _FLAG_LOG         0x0002 /* Log rawhost from dt_splice()         */s[                 #define _FLAG_TERM        0x0004 /* Term host from dt_splice()           */ [                 #define _FLAG_EIGHTBIT    0x0008 /* Read eight-bit C1 controls           */                   186                                   /*P                  * These macros and structure definitions are used by the escape#                    sequence parser._                  */p  [                 #define SEQ_INTMAX        2      /* Max # of intermediates               */ [                 #define SEQ_PARMAX        16     /* Max # of parameters                  */P                 /*L                  * dt_gesc() (get escape sequence) and dt_pesc() (put escapeC                  * sequence) use this structure for all processing.                   */                     K                                                                        187                  #                 typedef struct    {s[                     short         state;         /* Processing state or intro            */ [                     char          final;         /* Final chapter in seq.                */R[                     char          private;       /* Private introducer                   */t                 #ifdef  decus ?                     unsigned             param[SEQ_PARMAX + 1];                  #else ?                     unsigned short       param[SEQ_PARMAX + 1];                  #endif[                                                  /* Intermediate count, values           */   7                     char         inter[SEQ_PARMAX + 1];                  } SEQUENCE;                    /*L                  * The DECTALK structure is used to maintain all informationI                  * needed to process a DECtalk device. It is allocated bylJ                  * dt_open(), freed by dt_close() and a required parameter/                  * by essentially all routines.T                  */e              188f                                  #ifdef  rsxn                 /*L                  *The qio parameter block controls all RSX11-M I/O requests.                  */H[                 typedef struct qioparm {         /* QIO parameter block                  */ [                     char        *buffer;         /* Buffer location                      */i[                     int         size;            /* Bytes to transfer                    */ [                     char        *p3;             /* For ctrl/c ast                       */ [                     char        *table           /* Terminator table                     */t[                     int         unused[2];       /* Not used here                        */                  }QIOPARM;                   K                                                                        189t  w                               /*P                  * The I/O status block receives the status of all I/O requests.                  */ \                 typedef struct iosb   {          /* I/O status block                      */\                     char        status;          /* Operation status                      */\                     char        terminator;      /* Input terminator byte                 */\                     int         count;           /* bytes read from device                */                 } IOSB;                  #endif                                  190t  .              !                 #ifndef PEND_SIZE \                 #define PEND_SIZE          32                     /* Pending buffer size  */                 #endif!                 #ifndef IN_BUFLEN -                 #define IN_BUFLEN          32                  #endif"                 #ifndef OUT_BUFLEN.                 #define OUT_BUFLEN         128                 #endifJ                 #if     (IN_BUFLEN < 1 :: OUT_BUFLEN < 1 :: PEND_SIZE < 1)G                         <<error, mandatory parameters aren't correct >>                  #endif                K                                                                        191n                 (                 typedef struct DECtalk {]                     struct DECtalk *link;         /* Chain all units together              */s]                     short       unit;             /* I/O channel                           */ ]                     short       timeout;          /* For dt_timeout ()                     */O]                     short       flag;             /* Speech and "splice" flags             */c]                     short       pend_fc;          /* Bytes in pending buffer               */ ]                     short       pend_fp;          /* Pending buffer fill index             */ ]                     short       pend_ep;          /* Pending buffer empty index            */ ]                     char        *in_ptr;          /* I/O input buffer pointer              */ ]                     char        *in_end;          /* -> end of input buffer                */ ]                     char        *out_ptr;         /* -> free spot in output buff.          */ ]                     SEQUENCE    send;             /* Last sequence sent                    */r]                     SEQUENCE    reply;            /* Last sequence read                    */ ]                     SEQUENCE    seq;              /* Sequence look-ahead                   */ ]                     char        *device;          /* DECtalk hardware device               */ ]                     char        pend [PEND_SIZE];  /*Type_ahead ring buffer                */ ]                     char        in_buff[IN-BUFLEN];         /* I/O input buffer            */ ]                     char        out_buff[OUT-BUFLEN];       /* I/O output buffer           */                 192                                        /* L                       * The following entries are operating-system specific.                       */                 #ifdef   unix*                 #ifdef   BSD_42R]                     struct sgttyb stty_save       /* Terminal flags                        */T                 #elset                 #ifdef   UNIX_V*]                     struct termio stty_save;      /* Terminal flags (UNIX V7)              */                  #endif                 #endif                 #endif                 #ifdef  rsx1]                     FILE       *fildes;           /* File descriptor                       *//]                     IOSB       iosb;              /* I/O status block                      */ ]                     QIOPARM    parm;              /* QIO parameter block                   */o]                     short      pos_xk;            /* Device characteristics word           */                  #endif                 } DECTALK;  K                                                                        193                                   /*K                  * Certain short routines and common tests are expressed as M                  * macros. In all instances, 'dd' is a DECtalk I/O descriptor K                  * as returned by dt_open(). Note that the arguments shouldo+                  * not have "side-effects".                   *R                  *    dt_iskey(dd)         TRUE if something in type-ahead buffer.R                  *    dt_isvalid(c)        TRUE if argument is a valid keypad key.                  *L                  * The following are only useful after executing dt_phone().                  *H                  *    dt_ptest(dd,  r3)    TRUE if specific phone reply.Q                  *    dt_offhook(dd)       TRUE if last DECtalk reply is OFFHOOK. P                  *    dt_onhook(dd)        TRUE if last DECtalk reply is ONHOOK.Q                  *    dt_istimeout(dd)     TRUE if last DECtalk reply is TIMEOUT..                  *J                  * The following simple commands may be written as macros:                  *@                  *    dt_phone(dd,p3,p4)   Send a phone message.J                  *    dt_get(dd, sec)      Read a character (with timeout)            194o  n              F                  *    dt_put(dd, c)        Send a character to DECtalkT                  *    dt_eol(dd, c)         Send "end of line", flush output buffers                  *O                  * If DT_DEBUG is #defined, dt_get() and dt_put() are functions N                  * which may log all characters to the standard output stream.                  */0                            K                                                                        195i                                   #ifndef DT_DEBUG2                 #define dt_get            dt_ioget2                 #define dt_put            dt_ioput                 #endif                  #ifndef nomacarg<                 #define dt_iskey(dd)      (dd->pend_fc != 0)L                 #define dt_isvalid(c)     ((  (c >='0' && c <= '9')        \L                                            :: c == '#' :: c == '*'         \F                                            :: (c >= 'A' && c <= 'D')))D                 #define dt_ptest(dd,r3)  (dt_test(dd, R2_PHONE, r3))F                 #define dt_offhook(dd)   (dt_ptest(dd, R3_PH_OFFHOOK))E                 #define dt_onhook(dd)    (dt_ptest(dd, R3_PH_ONHOOK)) F                 #define dt_istimeout(dd) (dt_ptest(dd, R3_PH_TIMEOUT))9                 #define dt_phone(dd,p3,p4) (dt_msg(dd,  \t@                                 P2_PHONE, p3, p4, R2_PHONE, -1))                 #ifdef  unixJ                 #define dt_eol(dd)       (dt_put(dd, '\n'), dt_put(dd, 0))                 #elseu>                 #define dt_eol(dd)       (dt_put(dd, '\r'),  \?                                 dt_put(dd, 'n'), dt_put(dd, 0))             196                                   #endif                 #endif                 #ifdef  decus                   #ifdef  DT_DEBUG                 /*<                  * This forces traceback on Decus C systems.                  */ ,                 #define exit           error@                 #define IO_ERROR       "fatal DECtalk I/O error"                 #endif                 #endif                  K                                                                        197S  P                                #ifndef IO_ERROR                 #ifdef vms0                 #include               <ssdef.h>0                 #define IO_ERROR       SS$_ABORT                 #elseI(                 #define IO_ERROR       2                 #endif                 #endifG                 /* dt_abort may be set by a user program at any time to*G                  * stop DECtalk. Typicaly, it would be set by dt_trap() Y                  *when a <CNTL/C> (UNIX INTERRUPT signals) is typed by the terminal user.t                  */*S                 extern int       dt_abort;              /* Set TRUE to stop      */ S                 extern DECTALK   *dt_root;              /* Root of device chain  */                  #ifdef DT_DEBUG S                 extern int       dt_debug;              /* TRUE if debug log     */                  #endif                  198o  t                             DEMO.C  F               The executable program's name is DEMO, derived from this@               program. DEMO.C is the main module of the program.  '                 #include      <stdio.h>*(                 #include      "dectlk.h"                    main(argc, argv)%                 int             argc; (                 char            *argv[];                 { ^                        register DECTALK       *dt;      /* Dectalk device                   */^                        register int    retries;         /* Initializations                  */^                        register int    ncalls;          /* completed calls                  */,                        char            *dev;2                        extern DECTALK  *dt_open();          K                                                                        199                  $                        dev = "TT2:";&                        if (argc  >  1)+                            dev  =  argv[1]; %                        retries  =  0; $                        ncalls  =  0;)                        dt_debug  =  TRUE; ;                        if ((dt  =  dt_open(dev)) == NULL) { '                            perror(dev); "                            return;                        }^                        dt_trap();                       /* Catch CTRL-C abort               */^                        while (dt_init(dt)) {            /* One-time setup                   */B                            dt_dcs(dt,  P2_MODE, MODE_SQUARE, - 1);^                            retries++;                   /* Count attempts                   */^                            while (dt_answer(dt, 1)) {   /* Answer the phone                 */^                                if (process(dt)) {       /* Do user process                  */^                                    ncalls++;            /* User ran ok,                     */^                                    retries = 0;         /* Clear retry count                */                                 }^                                dt_hangup(dt);           /* Hangup the phone                 */            200;                 ^                                if (dt_abort)            /* Check interrupt                  */^                                    goto finis;          /* Error exit                       */                        }$                        if (dt_abort)^                            goto finis;                  /* Error exit                       */^                        if (retries > 2) {               /* Got lost?                        */8                            printf("Too many retries\n");!                            break;U                        }                    }D                    fprintf(stderr, "Couldn't initialize DECtalk\n");                  K                                                                        201                  ^                    finis:  dt_abort  =  FALSE;                    /* Restart output         */^                            dt_reset(dt);                          /* Hangup DECtalk         */^                            dt_put(dt, 0);                         /* Force out buffer       */^                            dt_close(dt);                          /* Close up DECtalk       */                    }                    process(dt)0                    register DECTALK         *dt;                    {^                            register char    c;                    /* Keypad character       */^                            char             work[30];             /* For echo message       */                                202                  =                            dt_talk(dt, "Welcome to DECtalk"); ^                            if (!dt_keypad(dt, TRUE))              /* Enable keypad          */^                                return (FALSE);                    /* Error occurred         */^                            for (;;)}                              /* Do forever . . .       */^                                c  =  dt_inkey(dt, 15);            /* Key with timeout       */^                                if  (!dt_isvalid(c))               /* Check for timeout      */^                                     break;                        /* Exit if so             */B                                sprintf(work, "You pressed %c", c);1                                dt_talk(dt, work); ^                                if (c == '*') {                    /* Make '*' special       */^                                    dt_timeout(dt, 0);             /* No timeouts now        */E                                    dt_talk(dt, "Long message . . .");                                  }                            }                            /* C                             * Timeout is normal, others are errors.o                             */B                            return ((c == 'T')  ?  TRUE  :  FALSE);                 }   K                                                                        203                                 DTANSW.C  E               This routine hangs up the phone and answers on n rings.n                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   ;                 title   dt_answer      Answer the Telephone/;                 index                  Answer the telephonea                   synopsis  0                         #include       <stdio.h>1                         #include       "dectlk.h"                          int -                         dt_answer(dt, nrings) N                         DECTALK         *dt;       /* Device descriptor     */N                         int             nrings;    /* Number of rings       */                   descriptionT                204   y              E                        Hang up the phone (by calling dt_hangup()) andnB                        answer the phone after the specified number                         of rings.  D                        Return TRUE if successful, FALSE if in error.                 #endif  '                 #include      <stdio.h> (                 #include      "dectlk.h"                   int %                 dt_answer(dt, nrings) ,                 register DECTALK        *dt;/                 int                     nrings;                  /*:                  * Hang up the phone and answer on nrings.                  */                  {S,                         register  int  code;      K                                                                        205                  S                 again:  if (!dt_hangup(dt))            /* Make sure it's         */ S                             return (FALSE);            /* on-hook.               */ C                         dt_dcs(dt, P2_PHONE, P3_PH_ANSWER, nrings);XB                         while (dt_read(dt,  0),  dt_onhook(dt))  {)                             if (dt_abort) /                                 return (FALSE);                          }t*                         if (dt_onhook(dt))'                             goto again;rS                         if (!dt_offhook(dt))           /* Did it answer ok?      */s+                             return (FALSE);                          /*J                          * OK, clear timeout flag and type-ahead counters.                          */t*                         dt->timeout  =  0;I                         dt->pend_fc  =  dt->pend_fp  =  dt->pend_ep  = 0; &                         return (TRUE);                  206                                 DTCLOS.C  C               This routine closes the DECtalk channel and frees allc               buffers.                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   A                 title   dt_close      Terminate DECtalk OperationhA                 index                 Terminate DECtalk Operation                    synopsis/                         #include      <stdio.h>_0                         #include      "dectlk.h"  $                         dt_close(dt)H                         DECTALK       *dt;    /* DECtalk device       */                   description   G                         Close the DECtalk channel and free all buffers.O-                         No error is returned. K                                                                        207e  t                               #endif  )                 #include        <stdio.h>a*                 #include        "dectlk.h"                   #ifdef  rsxe&                 #include        <cx.h>*                 #include        <qiofun.h>*                 #include        <qioret.h>*                 #include        <qiottd.h>!                 #define QIO_EFN 1   S                 static QIOPARM noparm;                   /* QIO parm (all zero)  */                  #endif                          208                                   dt_close(dt)+                 register DECTALK       *dt;                  /*-                  * Close the DECtalk channel.e                  */t                 { :                         register DECTALK          **linkp;                 #ifdef  unix                 #ifdef  BSD_42\                         stty(dt->unit, &dt->stty_save);           /* Restore tty flags    */                 #else                  #ifdef  UNIX_V\                         ioctl(dt->unit, TCSETA, &dt->stty_save);  /* Restore tty flags    */                 #endif                 #endif(                         close(dt->unit);                 #endif                 #ifdef  vms -                         sys$dassgn(dt->unit);*                 #endifK                                                                        209                                   #ifdef  rt11+                         rs_close(dt->unit);                  #endif                 #ifdef  rsx M                         qiow(IO_DET, dt->unit, QIO_EFN, NULL, NULL, &noparm); +                         fclose(dt->fildes);E                 #endif                                      210                                           /*<                          * Unlink the device from the chain.                          */ A                         for (*linkp  =  &dt_root; *linkp != NULL; =                              *linkp  == &((*linkp)->link))  { /                             if (*linkp == dt) { 2                                 *linkp = dt->link;&                                 break;                             }t                         } )                         free(dt->device);])                         free((char *)dt);*&                         return (NULL);                 }             K                                                                        211E                                DTCMD.C*  G               This routine sends a DCS command to the DECtalk terminal.                    /*)LIBRARY                 */  &                 #ifdef   DOCUMENTATION  N                 title    dt_cmd                 Send DCS w/o String TerminatorN                 index                           Send DCS w/o string terminator                   synopsis9                          #include               <stdio.h>(:                          #include               "dectlk.h"                            int+                          dt_cmd(dt, p2, p3)dM                          DECTALK         *dt;    /* Device descriptor      */ M                          int             p2;     /* P2_. . . parameter     */ M                          int             p3;     /* P3_. . . parameter     */                    description               212                  G                         This routine sends a DCS command to the DECtalk D                         terminal. The string terminator is not sent.I                         This is needed to send phonemic text or telephone &                         dial commands.  G                         The p2 or p3 parameter may be -1 if it is to be                          omitted   J                         A phonemic text sequence would be sent as follows.  /                             dt_cmd(dt, p2, p3);35                             dt_talk(dt, "hh'ehlow."); &                             dt_st(dt);                   #endif  (                 #include       <stdio.h>)                 #include       "dectlk.h"t  +                 static SEQUENCE command = { B                     DCS, DCS_F_DECTALK, 0, { 3, P1_DECTALK, 0, 0 }                 };  K                                                                        213*                 "                 dt_cmd(dt, p2, p3)S                 register DECTALK         *dt;            /* Device descriptor    */ S                 int                      p2;             /* P2_command or -1     */ S                 int                      p3;             /* P3_command or -1     */                                             214"                                  /*;                  * Send a DCS command, no string terminator                   */                  {*$                        if (p2 == -1)0                           command.param [0] = 1;                        else { 0                            command.param[2] = 2;(                            if (p3 == -1)3                               command.param[0] = 2;                         else { 3                               command.param[0] = 3; 4                               command.param[3] = p3;                            }                        }-                        dt_pesc(dt, &command);                  }       K                                                                        215                                 DTDCHA.C  B               This routine formats characters into a visible ASCIIC               datascope format and writes the resulting text to the F               indicated file. Note that this routine is independent ofH               DECtalk definitions. Output is via the C standard library.0               Dumps to terminals are unbuffered.                   /*)LIBRARY                 */  &                 #ifdef   DOCUMENTATION  D                 title    dt_dchar         Dump One Character VisiblyD                 index                     Dump one character visibly                   synopsis  3                          #include         <stdio.h>   )                          dt_dchar(c, iov) J                          int             c;     /* Character to dump    */J                          FILE            *lov;  /* File to write to     */              216                                   description   G                         The character is formatted into a visible ASCII G                         Datascope format and the resulting text written .                         to the indicated file.  H                         Note that this routine is independent of DECtalk$                         definitions.  I                         Output is via the C standard library. If the dump ;                         is to a terminal, it is unbuffered.                    #endif(                 #include       <stdio.h>                K                                                                        217r  t                                dt_dchar(c, iov)(                 register int          c;+                 register FILE         *iov;,                 /*$                  * Dump a character.                  */                  { /                        char           work[12];   +                        dt_visible(c, work); 0                        fprintf(iov, "%s", work);/                        if (isatty(fileno(iov))) '                            fflush(iov);(                 }                           218   s                             DTDCS.C(  I               This routine sends a DECtalk DCS control sequence using themJ               p2, p3, and p4 parameters. Pn parameters are -1 if not sent.%               No errors are possible.                    /*)LIBRARY                 */  (                 #ifdef     DOCUMENTATION  E                 title      dt_dcs          Send a DECtalk DCS CommandTE                 index                      Send a DECtalk DCS commande                   synopsis  4                            #include        <stdio.h>5                            #include        "dectlk.h"           K                                                                        219                  1                            dt_dcs(dt, p2, p3, p4) O                            DECTALK         *dt;     /* Device descriptor     */dO                            int             p2;      /* P2_xxx parameter      */ O                            int             p3;      /* P3_PH_xxxx parameter  */ O                            int             p4;      /* timeout or rings      */                    description   I                         This routine sends a DECtalk DCS control sequencee<                         using the p2, p3, and p4 parameters.  B                         Note that the Pn parameters are -1 if they%                         are not sent.   /                         No errors are possible.i                 #endif  )                 #include        <stdio.h> *                 #include        "dectlk.h"  8                 static SEQUENCE DT_string_terminator = {P                     ST                                  /* String terminator  */                 };            220                  &                 dt_dcs(dt, p2, p3, p4)P                 register DECTALK       *dt;     /* Dectalk device             */P                 int            p2, p3, p4;      /* Parameters to send         */                                  K                                                                        221                                   /*C                  * Load the parameter buffer and send the sequence. R                  * dt->send.param[0] contains the number of additional parameters.                  */s                 {/,                        dt->send.state = DCS;6                        dt->send.final = DCS_F_DECTALK;,                        dt->send.private = 0;-                        dt->send.inter[0] = 0; -                        dt->send.param[0] = 1; %                        if (p2 >= 0) { /                            dt->send.param[0]++;d2                            dt->send.param[2] = p2;                        }%                        if (p3 >= 0) { .                            dt->send.param[0]++2                            dt->send.param[3] = p3;                        }%                        if (p4 >= 0) { .                            dt->send.param[0]++            222                  2                            dt->send.param[4] = p4;                        }2                            dt_pesc(dt, &dt->send);>                            dt_pesc(dt, &DT_string_terminator);                 }                  DTDIAL.C  D               This routine dials the DECtalk telephone, depending onE               whether the telephone used is Touch-Tone or pulse type.                     *LIBRARY                   */e  '                 #ifdef    DOCUMENTATIONe  ;                 title     dt_dial        Dial the Telephone ;                 index                    Dial the telephone                    synopsis    K                                                                        223e  n              2                         #include         <stdio.h>3                         #include         "dectlk.h"                            int 8                         dt_dial(dt, p3, numb, wait, msg)K                         DECTALK         *dt;    /* Device descriptor     */ K                         int             p3;     /* P3_PH_xxxx parameter  */ K                         char            *numb;  /* Number to dial        */ K                         int             wait;   /* See below             */eK                         char            *msg;   /* Announcement          */                    description   G                        This routine dials the DECtalk telephone. The P3II                        parameter must be either P3_PH_TONE (tone dial) orr0                        P3_PH_PULSE (pulse dial).  H                        For tone dialing, the number text may contain anyG                        valid touch-tone characters ("0123456789*#ABCD") E                        or the characters '!' (for a one second delay) J                        or the '^' for a 250 millisecond switch-hook flash.8                        All other characters are ignored.            224*  c              M                        If pulse dialing is selected, only the digits, '!' andt+                        '^' are interpreted.   I                        Note that the telephone will not be hung up before K                        dialing if it is offhook when the command is issued.   '                 Call Progress Detectiong  I                        DECtalk cannot tell if or when someone answers theoL                        phone. The only way to do this is to speak a message,H                        such as "This is DECtalk, please press any buttonI                        on the keypad." and wait some limited time for the C                        person to press the button. The wait and msg :                        parameters provide this capability.  M                        If wait is less than or equal to zero, DECtalk returnslM                        without attempting to verify that someone has answered I                        the phone. The return will be TRUE if the phone is                         offhook.r      K                                                                        225p  d              L                        If wait is greater than zero, it specifies the numberH                        of seconds to wait for a response, and msg is theI                        message to speak. (If msg is NULL, the sample text I                        shown above will be used.) The message is repeated E                        continuously until either the alloted time has N                        elapsed or a button is received. dt_dial() then returns>                        TRUE if the phone is offhook, as above.  K                        To cause DECtalk to silently wait for a message, usedI                        a zero-length string ("""). Note, however, that an K                        audible message is required by some public telephone'                        systems.   J                        When DECtalk returns after call progress detection,M                        keypad data entry and keypad timeout will be disabled.d                   #endif  )                 #include        <stdio.h>f*                 #include        "dectlk.h"  P                 #define ANNOUNCEMENT    "This is DECtalk, please press any key."            226n  t                               intT6                 dt_dial(dt, p3, number, wait, message)R                 register DECTALK        *dt;            /* Device descriptor    */R                 int                     p3;             /* P3_PH_PULSE or tone  */R                 register char           *number;        /* Number to dial       */R                 int                     wait;           /* Call progress delay  */R                 char                    *message;       /* Announcement         */                   /*(                  * Send a phone message.                  */                  { .                         register int     code;X                         int              dialtime;       /* Time to dial phone        */1                         long             endtime; 0                         extern long      time();          K                                                                        227                  X                         if (number == NULL)              /* Paranoia,                 */X                             number ="";                  /* Ahhh, paranoia            */1                         dt_cmd(dt, P2_PHONE, p3); 2                         dialtime = strlen(number);.                         if (p3 == P3_PH_PULSE)*                             dialtime *= 2;X                         while (*number  != EOS)          /* Send the number           */2                             dt_put(dt, *number++);"                         dt_st(dt);                         do {=                            code = dt_read(dt, dialtime + 30);AB                         } while (code == ST :: dt_save(dt, code));&                         if (wait <= 0)5                             return (dt_offhook (dt));g                         /*3                          * Call progress detection.                           */ D                         if (!dt_offhook(dt) :: !dt_keypad(dt, TRUE))+                             return (FALSE); 8                         endtime = time(NULL) + wait + 1;            228i  u              ,                         if (message == NULL)3                             message = ANNOUNCEMENT;h                         do {Y                            dt_talk(dt, message);         /* Speak announcement         */ Y                            dt_put(dt, VT);               /* Make sure it's heard       */s<                         } while ((code = dt_read(dt, 5)) < 09                               && time(NULL) < = endtime); Y                         dt_dcs(dt, P2_STOP, -1, -1);     /* Enough already             */;Y                         if (dt_isvalid(code)) {          /* User key?                  */ Y                             dt_keypad(dt, FALSE);        /* Turn off keypad and        */)Y                             dt_drain(dt);                /* Drop pending text          */ Y                             return (TRUE);               /* Normal return              */                          }nF                         else if (dt_phone(dt, -1, -1), dt_offhook(dt))Y                             dt_hangup(dt);              /* No response, hangup         */   '                         return (FALSE);                  }       K                                                                        229                                 DTDRAI.C  G               This routine absorbs any type-ahead characters. No errors                are possible.                    /*)LIBRARY                  */e  (                 #ifdef     DOCUMENTATION>                 title      dt_drain        Drain Pending Input>                 index                      Drain pending input                   synopsis  4                        #include            <stdio.h>5                        #include            "dectlk.h"   #                        dt_drain(dt) N                        DECTALK             *dt;    /* Device descriptor     */                   description   9                         Absorb any type-ahead characters. /                         No errors are possible.*            230                                   note  L                         On UNIX systems, dt_drain() will also cancel pendingF                         output. This may cause DECtalk to receive word>                         fragments or partial escape sequences.  L                         The code is conditionally compiled for two varietiesJ                         of UNIX: Ultrix-32 (or 4.2 bsd) and UNIX System V.J                         Other varieties of UNIX  and UNIX-like systems may/                         need to edit this file.2                   #endif  -                 #include            <stdio.h>o.                 #include            "dectlk.h"                   #ifdef unixt          K                                                                        231   d                               dt_drain(dt)4                 register DECTALK                *dt;                 /*@                  * dt_drain() tosses out any pending type-ahead.                  */                  { D                         dt->pend_fc = dt->pend_fp = dt->pend_ep = 0;                 #ifdef  BSD_429                         ioctl(dt->unit, TIOCFLUSH, NULL);                  #else                  #ifdef  UNIX_VP                         ioctl(dt->unit, TCFLSH, 0);        /*UNIX V7          */                 #endif                 #endif>                         dt->in_ptr = dt->in_end = dt->in_buff;                 }                  #endif                  232                                   #ifdef vms)                 #include        <iodef.h>                  dt_drain(dt),                 register DECTALK        *dt;                 /*@                  * dt_drain() tosses out any pending type-ahead.                  */                  {tD                         dt->pend_fc = dt->pend_fp = dt->pend_ep = 0;                         /*N                          * This is probably sub-optimal. It should be possible.                          * to do "sys$qiow(...F                          *      IO$_READLBLK : IO$M_PURGE : IO$M_TIMEDM                          * with a zero-length timeout, but I sure don't know.t                          */ -                         while (dt_vmsread(dt, X                                 IO$_READLBLK : IO$M_NONECHO : IO$M_NOFILTR : IO$M_TIMED,;                                 IN_BUFLEN, 0) >= IN_BUFLEN)t>                         dt->in_ptr = dt->in_end = dt->in_buff;                 } K                                                                        233                                   #endif                   #ifdef  rt11'                 #include       <rsts.h>                    dt_drain(dt)-                 register DECTALK         *dt;g                 /*@                  * dt_drain() tosses out any pending type-ahead.                  */                  {oD                         dt->pend_fc = dt->pend_fp = dt->pend_ep = 0;                          clrxb();T                         xrb.xrlen = 7;                  /* Cancel type-ahead      */0                         xrb.xrci = dt->unit * 2;,                         xrb.xrblkm = TTYHND;&                         rstsys(_SPEC);>                         dt->in_ptr = dt->in_end = dt->in_buff;                 }                  #endif              234                                   #ifdef   rsx                 dt_drain(dt)0                 register DECTALK            *dt;                 /*@                  * dt_drain() tosses out any pending type-ahead.                  */                  {aD                         dt->pend_fc = dt->pend_fp = dt->pend_ep = 0;                         do {B                             dt->in_ptr = dt->in_end = dt->in_buff;4                         } while (dt_get(dt, 1) > 0);>                         dt->in_ptr = dt->in_end = dt->in_buff;                 }f                 #endif            K                                                                        235                                 DTDUMP.C    ^                 This routine writes an escap sequence buffer to the standard output file. This&                 mode is for debugging.                   /*)LIBRARY                  */   '                 #ifdef    DOCUMENTATION F                 title     dt_dump          Dump Escape Sequence BufferF                 index                      Dump escape sequence buffer                   synopsis  4                           #include         <stdio.h>5                           #include         "dectlk.h"n                             int ,                           dt_dump(what, seq)N                           char            *what;     /* Explanation         */N                           SEQUENCE        *seq;      /* Buffer to dump      */              236e  /                               descriptionn  G                         The requested escape sequence buffer is written >                         (visibly) to the standard output file.  M                         If what is not NULL,  it is written as an identifier.   =                         Output is via the C standard library.   $                         For example,  .                             #include <stdio.h>/                             #include "dectlk.h"e                    K                                                                        237                  (                             DECTALK *dt;6                             extern DECTALK *dt_open();!                             . . . #                                  /* :                                   * Open a DECtalk device,<                                   * request phone status andB                                   * dump returned status sequence.$                                   */5                                  dt = dt_open("kb2"); @                                  dt_phone(dt, P2_PH_STATUS, -1);?                                  dt_dump("status", &dt->reply);                    #endif  )                 #include        <stdio.h> *                 #include        "dectlk.h"                      238d                 "                 dt_dump(what, seq)+                 char                 *what;;*                 register SEQUENCE    *seq;                 { 3                         register int             i; 5                         register char            *wp;i:                         char                     work[81];?                         extern char              *dt_visible();                         K                                                                        239                  (                         if (what !=NULL)2                            printf("%s: \"", what);:                         wp = dt_visible(seq->state, work);,                         switch (seq->state {!                         case ESC: !                         case DSI: !                         case DCS: 1                            if (seq->private != 0)eA                                wp = dt_visible(seq->private, wp);t?                            for (i = 1; i <= seq->param[0];i++){/)                                if (i > 1) .                                    *wp++ =';';8                                if (seq->param[i] != 0) {B                                   sprintf(wp, "%", seq->param[i]);3                                   wp += strlen(wp);                                  }                            }B                            for (i = 1; i <= seq-> inter [0]; i ++)C                                wp = dt_visible(seq-> inter[i], up);t!                            break;             240   t                                        default:"                             break;                         } ,                         if (seq->final != 0);                            wp = dt_visible(seq->final, wp); "                         *wp = EOS;K                         printf("%s%s", work, (what == NULL) ? "" : "\"\n");                  }e                 DTEOL.CL  I               This routine writes an end of line to DECtalk and calls the J               operating system executive service to write the local output;               buffer to the terminal. No value is returned.   J               You need this routine on operating systems that enforce lineC               wraparound on the terminal. DTEOL.C also improves the /               appearance of the debugging logs.         K                                                                        241                                   /*)LIBRARY                 */  &                 #ifdef   DOCUMENTATION  E                 title    dt_eol          Write End of Line to DECtalk E                 index                    Write End of Line to DECtalk                    synopsis  2                        #include          <stdio.h>3                        #include          "dectlk.h"   !                        dt_eol(dt)aR                        DECTALK           *dt;     /* Device descriptor          */                   description   F                         An "end of line" is written to DECtalk and theG                         operating system executive service is called to F                         cause the local output buffer to be written to%                         the terminal.               242                  -                         No value is returned.p  H                         This routine is needed on operating systems thatG                         enforce "line wrap-around" on terminal devices.hJ                         It also imporves the appearance of debugging logs.                 #endif  &                 #include     <stdio.h>'                 #include     "dectlk.h"i                   #ifdef   dt_eol                  #undef   dt_eol                  #endif                  K                                                                        243a  o                               dt_eol(dt)Q                 register DECTALK         *dt;    /* Device descriptor          */                  {t                 #ifndef unix(                        dt_put(dt, '\r');                 #endif(                        dt_put(dt, '\n');%                        dt_put(dt, 0);                  }D                 DTGESC.C  H               This routine reads an escape sequence or keypad character.                   /*)LIBRARY                 */  &                 #ifdef   DOCUMENTATION  J                 title    dt_gesc         Read Escape Sequence or CharacterJ                 index                    Read escape sequence or character              244                                   synopsis  2                        #include          <stdio.h>3                        #include          "dectlk.h"                           int'                        dt_gesc(dt, sec)tK                        DECTALK        *dt;    /* Device descriptor       */iK                        char           sec;    /* O.S. timeout value      */                    description   D                         Read an escape sequence or keypad character.  O                         dt_gesc() interprets a stream of 7- or 8-bit characterseX                         including escape sequences adhering to the coded representationsU                         of ISO 646, ISO 2022, and ISO 6429 with extensions to the DCS C                         introducer as required by DEC Standard 138.           K                                                                        245                  L                         The function dt_gesc() recognized ESC, CSI, and DCS.T                         and processes characters following each of these introducersU                         until a complete sequence is encountered. In the case of DCS,iR                         control returns to the caller after the final character ofR                         the DEC Standard 138 introduction sequence, but before theJ                         first data character of the device control string.  S                         When sandwiched between the application and a get character K                         function (dt_get()), dt_gesc() transforms the inputhW                         stream from a character stream to a stream of tokens consisting S                         of characters, escape sequences, control sequences, and DCS*S                         introduction sequences. When any of the recognized sequenceiT                         types is encountered, the function value returned is that ofS                         ESC, CSI, or DCS, and the interpretted body of the sequence N                         is returned in the seq structure. The caller may treatO                         dt_gesc() similarly to getchar(), ignoring the returned V                         structure in all cases except when the returned function value,                         is ESC, CSI, or DCS.                  246                  Q                         An additional function performed by dt_gesc() is that all V                         C1 control functions received in their 7-bit form are returnedT                         to the caller in their 8-bit form, thus eliminating the needW                         for the caller to process C1 control functions in their (7-bit) W                         escape sequence form and enforcing the equivalence of the 7-bit(Q                         and 8-bit forms of the C1 control functions. The function U                         also enforces the sequence cancellation effect of the SUB and .                         CAN control charcters.  O                         The dt_gesc() function calls the user-supplied dt_get()lR                         (read one character) function as many times as required toQ                         complete an escape sequence, control sequence, or Digital N                         standard DCS introduction sequence. In the passed dataO                         structure, it returns the final character, intermediate 9                         characters, and parameter values.             K                                                                        247                  M                         Since 7-bit operation is a compatible subset of 8-bit P                         operation, there is -- normally -- no distinction in theH                         dt_gesc() function between the two environments.N                         The application program may set the _FLAG_EIGHTBIT bitM                         in dt->flag to receive C1 control characters in their*H                         eight-bit form. If _FLAG_EIGHTBIT is set on, theJ                         application program must also ensure that the hostJ                         operating system communication line receives eightT                         data bits, and that DECtalk setup has set HOST FORMAT EIGHT.  E                         Also, dt_get() may return two special values,eR                         DT_ERR and DT_TIMEOUT, to indicate operating-system errorsE                         and communication line timeouts respectively.   S                         Because C0 control characters may be embedded in sequences, O                         and must be interpretted as if they occurred before the F                         sequence in the stream, the dt_gesc() functionO                         retains internal state information in the sequence data P                         structure from call to call. The seq.state value is zeroV                         on return to indicate a complete escape sequence. If non-zero,<                         it contains the sequence introducer.            248                  M                         If the "seq.state" element is zero, dt_gesc() assumes[T                         that the remainder of the data structure is invalid and thatU                         there is no data being retained from a prior call. A non-zeroaP                         value for the "seq.state" element indicates a particularW                         internal state (ESC, CSI, or DCS) that the parser should assume )                         on the next call. T                         Intermediate characters and parameter values interpretted upT                         to the occurrence of the embedded control character are alsoT                         stored in the returned data structure and also should not be.                         altered by the caller.  R                         Escape sequence syntax errors are indicated by setting theM                         seq.private parameter to 'X' (which is not a possible +                         private parameter).d  J                         If the dt_gesc() function encounters more than theN                         allowed maximum number of intermediate characters, theT                         returned data structure indicates that one more intermediateR                         character was received than allowed. Of course, characters9                         after the maximum are not stored.)  K                                                                        249                  J                         If the dt_gesc() function encounters more than theR                         allowed maximum number of parameters, the extra parametersR                         are ignored and the returned data structure indicates thatN                         the allowed maximum number of parameters was received.  I                         After each call to dt_gesc() the dt->seq SEQUENCEa;                         contains the following information.   J                           seq.state     Zero to indicate complete sequence  D                           seq. final    The sequence final character  D                           seq.private   Private parameter character:H                                         EOS, <, =, >, ?, or X for errors  F                           seq.param[0]  The number of parameter values8                                         (0 : SEQ_PARMAX)  J                           seq.param[n]  (unsigned)The n'th parameter value  E                           seq.inter[0] The number of parameter valuesa9                                        (0 : SEQ_INTMAX+1)   N                           seq.inter[n] (char) The n'th intermediate character.            250                  S                         In general, the intermediate and final characters should be O                         taken as a whole to determine the action. It is easy to T                         ignore sequences with too many intermediate characters sinceU                         the returned number of intermediate characters will not match ,                         any action function.  Q                         to simplify the code, this module doesn't test for overly S                         large parameter values and assumes that all overflow errorsh<                         are due to invalid escape sequences.                   #endif  '                 #include      <stdio.h>f(                 #include      "dectlk.h"                   int                   dt_gesc(dt, sec)V                 register DECTALK      *dt;   /* Dectalk device                      */V                 int                   sec;   /* O.S. timeout                        */      K                                                                        251                                   /*1                  * Return a character or sequence                   */                  {i+                           register int   c;                  #ifdef    decus 5                           register unsigned       *p;                  #elsec5                           register unsigned short *p;s                 #endif                                252                  "                 #ifdef    DT_DEBUG)                           if (dt_debug) { ,                               dt_put(dt, 0);0                               printf("get: \"");9                               if (isatty(fileno(stdout))) 1                                   fflush(stdout);                            }                  #endif$                           for (;;) {                                /*K                                * Loop until end of sequence forces an exit. N                                * Get the next character from the input stream.I                                * Note: we assume that negative values are 7                                * "out of band" signals.8                                 *Y                                * Note that DT_TIMEOUT and DT_ERR must be negative values. !                                */w>                               if ((c = dt_get(dt, sec)) > 0) {G                                   if ((dt->flag & _FLAG_EIGHTBIT) == 0) W                                       c &= 0x7F;          /* Enforce 7-bit input     */ K                                                                        253                                                 }h7                               if (c == NUL :: c == DEL)eW                                   continue;               /* Ignore NUL, DEL         */D                                /*L                                * Branch to c1_continue when changing <ESC> [-                                * to CSI, etc.(!                                */t                 c1_continue:X                               if (c == ESC                 /* ESC, CSI, DCS           */X                                :: c == CSI                 /* Introduce control       */X                                :: c == DCS) {              /* sequences               */?                                   dt->seq.state            = c; ?                                   dt->seq.inter[0]         = 0;n?                                   dt->seq.private          = 0; ?                                   dt->seq.param[0]         = 0;s?                                   dt->seq.param[1]         = 0; +                                   continue;C                                 }Y                                else if (dt->seq.state == 0) /* No pending sequence     */ Y                                    goto exit;              /* Return the character     */i            254-  p              Y                                else if ((c >= 0x80 && c <= 0x9F)   /* C1 control       */ Y                                      :: (c == CAN)                 /* or sequence      */ Y                                      :: (c == SUB)) {              /* resetter.        */t5                                    dt->seq.state = 0; -                                    goto exit;e                                 }Y                                else if (c < 0x20)          /* C0 control or error      */ -                                    goto exit;mY                                else if (c <= 0x2F) {       /* Intermediate             */t6                                    dt->seq.inter[0]++;E                                    if (dt->seq.inter[0] < SEQ_INTMAX)oK                                        dt->seq.inter[dt->seq.inter[0]] = c;                                  }Y                                else if (dt->seq.state == ESC) {   /* ESC final         */ X                                    if (dt->seq.inter[0] == 0 && (c & 0x3F) < 0x20      {)                                        /*vP                                         * This is the 7-bit form of a C1 controlM                                         * character. Convert it to the actualaN                                         * C1 control character and restart theR                                         * parse without getting another character.K                                                                        255q  c              *                                         */=                                        c = (c & 0x3F) + 0x80;i8                                        goto c1_continue;$                                    })                                    else { Z                                        break;               /* Ordinary ESC ending      */$                                    }                                 }Z                                else if (c <= 0x3F) {        /* Parameter                */Z                                    if (c >= 0x3F{           /* Private introducer?      */Z                                        if (dt->seq.param[0] > 0)   /* Is it first?      */Z                                            dt->seq. private = 'X'; /* error if not      */-                                        else {lZ                                            dt->seq.private = c;    /* Store it          */Z                                            dt->seq.param[0]++;     /* Flag seen         */(                                        }$                                    }Z                                    else {                    /*Not private              */A                                        if (dt->seq.param[0] == 0)eZ                                            dt->seq.param[0] ++;     /* Record first     */            256                  C                                        if (dt->seq.inter[0] != 0) { Z                                            dt->seq.inter[0] = 0;    /* Syntax error     */A                                            dt->seq.private = 'X';o(                                        }Z                                              if (c <= 'g') {     /* 0..9                */V                                                  if (dt->seq.param[0] <= SEQ_PARMAX) {7                                                      /* O                                                       * There is room. Store it 7                                                       *sV                                                       * p points to current parameter.S                                                       * This should check for valueaA                                                       * overflow. 8                                                       */\                                                      p = &(dt->seq.param[dt->seq.param[0]]);P                                                      *p = (*p * 10) + (c - '0');2                                                  }7                                                  else {dK                                                      dt->seq.private = 'X'; 2                                                  }.                                              }K                                                                        257e  f              Z                                              else if (c == ';') {      /* Separator     */T                                                  if (dt->seq.param[0] >= SEQ_PARMAX)W                                                      dt->seq.param[0] = SEQ-PARMAX + 1; 7                                                  else { 7                                                      /*rQ                                                       * There's room to setup forRP                                                       * another parameter value.8                                                       */H                                                      dt->seq.param[0]++;Y                                                      dt->seq.param[dt->seq.param[0]] = 0;f2                                                  }.                                              }\                                              else {              /* colon is invalid      */G                                                  dt->seq.private = 'X'; .                                              }*                                          }&                                      }\                                      else {                    /* CSI/DCS terminator      */\                                          if (dt->seq.param[0] == 0)  /* No parameters;    */\                                              dt->seq.param[0]++; /* want one zero-value   */            258                  \                                          break;                  /* Exit parser           */&                                      }"                                  }#                                  /* X                                   * Control transfers to here as result of either of theV                                   * two break statements. Character is the final char.8                                   * of ESC, CSI, or DCS.$                                   */E                                  if (dt->seq.param[0] > SEQ_PARMAX) {f]                                      dt->seq.param[0] = SEQ_PARMAX; /* Set count to max.   */ ]                                      dt->seq.private = 'X';         /* Flag an error       */w"                                  }]                                  dt->seq.final = c;                 /* Store final char.   */A&                          # ifdef decus]                                  c = dt->seq.state;                 /* Fetch return value  */u                          # else D                                  c = (unsigned short) dt->seq.state;                          #endifc]                                  dt->seq.state = 0;                 /* No sequence pending */ ]                          exit:                                      /* Here to return char */ K                                                                        259U  E              )                          #ifdef  DT_DEBUG .                                  if (dt_debug)4                                      printf("\"\n");                          #endif ]                                  return (c);                        /* and return          */s                          }                 DTGET.C   F               This routine reads a character from the DECtalk terminal               line.,                   /*)LIBRARY                 */  &                 #ifdef   DOCUMENTATION  G                 title    dt_get         Read one Character from DECtalk H                 index                    Read one character from DECtalk                   synopsis                260e  D              2                        #include          <stdio.h>3                        #include          "dectlk.h"                           int&                        dt_get(dt, sec)P                        DECTALK             *dt;    /* Device descriptor       */P                        int                 sec;    /* O.S. timeout param      */                   description   L                        One character is read from the DECtalk terminal line.K                        The sec parameter eneables operating-system timeout; :                        it is zero if no timeout is needed.  G                        dt_get() returns the character or an error code.   A                          DT_ERROR       An operating system errortM                                         (or <CTRL-C> interrupt) was received. L                          DT_TIMEOUT     The sec parameter was nonzero and noN                                         character was received in sec seconds.      K                                                                        261                  K                        If DT_DEBUG is #defined when the library is compiled E                        and the global dt_debug is set nonzero (by the :                        application program), the characterH                        received is logged to the standard output device.                   #endif  (                 #include       <stdio.h>)                 #include       "dectlk.h"                    #ifdef  dt_get                 #undef  dt_get                 #endif                    int     dt_debug                   int                  dt_get(dt, sec) O                 register DECTALK     *dt;     /* Device descriptor           */=O                 int                  sec;     /* Operating system timeout    */                    {t)                         register int   c;             262   +              0                         extern int     dt_debug;  .                         c = dt_ioget(dt, sec);*                         if (dt_debug != 0)0                             dt_dchar(c, stdout);#                         return (c);b                 }2                 DTHANG.C  9               Hang up the telephone connected to DECtalk.r                   /*)LIBRARY                 */  &                 #ifdef   DOCUMENTATION  =                 title    dt_hangup       Hangup the telephone =                 index                    Hangup the telephone,                   synopsis    K                                                                        263w  e              2                        #include          <stdio.h>3                        #include          "dectlk.h"   $                        dt_hangup(dt)K                        DECTALK        *dt;    /* Device descriptor       */e                   description   C                         Hang up the telephone connected to DECtalk. E                         Return TRUE if successful, FALSE if an error.                    #endif  +                 #include          <stdio.h> ,                 #include          "dectlk.h"                          264N  I                               into                 dt_hangup(dt) ,                 register DECTALK        *dt;                 /*1                  * dt_hangup() hangs up the phone                   */l                 {e-                         register int    code;e                        K                                                                        265a  n              W                         dt_drain(dt);                   /* Drain pending text        */ W                         if (!dt_phone(dt, P3_PH_STATUS, -1)) /* check state          */ W                             return (FALSE);             /* Oops                      */oW                         if (dt_offhook(dt)) {           /* If its not hung up        */ @                             if (!dt_phone(dt, P3_PH_HANGUP, -1))W                                 return (FALSE);         /* Couldn't hangup?          */ W                             while (dt_offhook(dt)) {    /* While still off-hook      */ W                                 if (dt_abort)           /* Exit if interrupt         */eW                                     return (FALSE);     /* Signal sets               */ W                                 sleep(5);               /* Wait and poll again       */ D                                 if (!dt_phone(dt, P3_PH_STATUS, -1))W                                     return (FALSE);     /* Poll failed               */                              }                           }W                          if (!dt_onhook(dt))            /* Did it hang up ok?        */ ,                              return (FALSE);                 }d                  266                                 DTINIT.C  J               This routine initializes the DECtalk terminal on the channel               opened on dt.                    /*)LIBRARY                 */  &                 #ifdef   DOCUMENTATION  G                 title    dt_init         DECtalk Initialization Routine G                 index                    DECtalk initialization routine                    synopsis  2                        #include          <stdio.h>3                        #include          "dectlk.h"                           int"                        dt_init(dt)K                        DECTALK        *dt;    /* Device descriptor       */                    description   K                                                                        267                  M                         Initialize the DECtalk terminal on the channel opened                          on dt.  K                         Return TRUE if the device initialized successfully. 0                         Return FALSE on failure.                   note  Q                         This routine turns off "local mode" so a logging terminaldS                         does not inadvertently send a response to the "who are you" (                         escape sequence.                 #endif  )                 #include        <stdio.h> *                 #include        "dectlk.h"  2                 static SEQUENCE DT_who_are_you = {                     CSI, 'c'                 };                   int0                 dt_init(dt) +                 register DECTALK       *dt;             2680  ;                               /*=                  * dt_init() is called to initialize DECtalk.                   */                  {p.                         register int     code;W                         dt_drain(dt);                   /* Ignore pending input      */ W                         dt_dcs(dt, P2_TERMINAL, 0, -1); /* No local->host stuff      */ W                         dt->flag &= ~_FLAG_TERM;        /* Remember this fact        */                          /*O                          * Read device attributes and fail if it isn't DECtalk. H                          * Expected reply is <ESC>[?19c for the DTC01-AA                          */05                         dt_pesc(dt, &DT_who_are_you); 2                         if (dt_read(dt, 15) == CSI2                          && dt->reply.final == 'c'3                          && dt->reply.private =='?'s3                          && dt->reply.inter[0] == 0*3                          && dt->reply.param[0] == 1 N                          && ((code = dt->reply.param[1]) == CSI_DA_PRODUCT)) {Y                             dt_reset(dt);                       /* Reset device        */tK                                                                        269                  Y                             return (TRUE);                      /* Hang up and restart */                          } '                         return (FALSE);                  DTINKE.C  ;               This routine reads a telephone keypad button.                    /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   I                 title   dt_inkey        Read a Telephone Keypad Character I                 index                   Read a Telephone Keypad Characterd                   synopsis  1                         #include        <stdio.h> 2                         #include        "dectlk.h"                  270                                           int )                         dt_inkey(dt, sec)DM                         DECTALK         *dt;    /* Device descriptor       */ M                         int             sec;    /* Seconds to wait         */a                   description   E                         This routine reads a telephone keypad button. F                         The application program has previously enabledD                         the keypad (by calling dt_keypad(dt, TRUE)).C                         dt_inkey() will call dt_timeout() to enableo,                         or disable timeouts.  I                         If sec is nonzero, it will indicate the number of G                         seconds to wait for a keypad response. If zero,l9                         it will turn off keypad timeouts.pE                         The operating-system timeout (needed to catchuH                         hardware or communication line problems) will beD                         set to four times the timeout value, plus anE                         operating-system specific additional timeout.t  B                         dt_inkey() returns a character as follows.K                                                                        271c                 D                           0123456789*#ABCD     A valid keypad buttonG                                                (Note that "ABCD" may be C                                                generated by certain >                                                keypad phones.)  H                           E                    An operating-system error  =                           T                    Keypad timeout   L                           X                    Badly parsed escape sequence.  K                           H                    Unexpected telephone hangup.t  N                           The 'H' code is received if the DECtalk device hangsP                           up the phone (as may be required by specific telephone/                           system requirements).                    #endif  )                 #include        <stdio.h> *                 #include        "dectlk.h"                  272                                   /*G                  * Fudge is needed because of terminal output buffering C                  * capacities and strategies. It should be tuned by                   * inspection.                  *J                  * The RSTS/E values is large because RSTS/E will resume aK                  * program when less than 80 bytes remain to be transmitted L                  * to DECtalk. DECtalk may have about 100 bytes in its inputE                  * buffers and two phrases in the letter to sound and I                  * synthesizer sections. If the value is set too low, theyJ                  * application program may incorrectly assume that DECtalk7                  * or the communication line is broken.n                  */.                   #ifdef rt11lV                 #define FUDGE  60              /* RSTS/E needs extra time           */                 #else V                 #define FUDGE  15              /* This is just a guess              */                 #endif    K                                                                        273i  n                                dt_inkey(dt,sec)V                 register DECTALK      *dt;     /* DECtalk device                    */V                 int                   sec;     /* Keypad timeout                    */                 { ,                         register int   code;2                         register int   os_timeout;  V                         dt_timeout(dt, sec);            /* Set/clear timeout        */+                         if (dt_iskey(dt)) { 9                             code = dt->pend[dt->pend_ep];2;                             if (++dt->pend_ep >= PEND_SIZE) 0                                 dt->pend_ep = 0;*                             dt->pend_fc--;                         }                          else {                        274)                 3                             if ((code = dt_read(dt, N                                     (sec == 0) ? 0 : (sec * 4 + FUDGE))) <= 0)*                                code = 'E';8                             else if (dt_istimeout(dt)) {*                                code = 'T';/                                dt->timeout = 0;                              } 3                             else if (dt_onhook(dt)) *                                code = 'H';=                             else if (dt->reply.private == 'X' 2                              :: !dt_isvalid(code))'                             code = 'X';a                         } '                          return (code);                  }q          K                                                                        275d  m                             DTIOGE.C  H               This routine reads one character from the DECtalk terminal9               line. DTIOGE.C is maximized for efficiency.e                   /*)LIBRARY                 */                 /*                  * Edit History E                  * 84.04.10     MM      HNGTTY incorrectly specified.d                 */  &                 #ifdef   DOCUMENTATION  I                 title    dt_ioget         Read one Character from DECtalktH                 index                    Read one character from DECtalk                   synopsis  4                          #include          <stdio.h>5                          #include          "dectlk.h"                 276                                            int*                          dt_ioget(dt, sec)M                          DECTALK        *dt;    /* Device descriptor       */ M                          int            sec;    /* O.S. timeout param      */                    descriptiong  M                         One character is read form the DECtalk terminal line.eK                         The sec parameter enables operating-system timeout; ;                         it is zero if no timeout is needed.   J                         dt_ioget() returns the character or an error code.  A                           DT_ERROR      An operating system error M                                         (or <CTRL-C> interrupt) was received.u  I                           DT_TIMEOUT    The sec parameter was nonzero and H                                         no character was received in sec0                                         seconds.  I                         dt_ioget() is the operating-system specific inputtI                         routine. It is the only routine to read data froma2                         the DECtalk terminal line.K                                                                        277                                   note  I                         On vms, an internally-used routine, dt_vmsread(), D                         is also defined. Application programs should.                         not call this routine.  N                         This module contains specific code for Ultrix-32 (UNIXO                         4.2BSD) and UNIX System V. The makefile for the library C                         should #define one of these as appropriate.                      #endif  2                        #include          <stdio.h>3                        #include          "dectlk.h"                    /*E                  * Define all DECtalk library globals in this module.n                  */>V                 int     dt_abort;                    /* TRUE on interrupt           */V                 DECTALK *dt_root;                    /* Chain of all open units     */              278                                   #ifdef   unix=)                 #include        <errno.h>                  #ifdef  BSD_42-                 #include        <sys/types.h> (                 #include        <time.h>                 #else                  #ifdef  UNIX_V*                 #include        <signal.h>  W                 static ignore()  {}       /* Dummy function for signals              */                  #endif                 #endif                   int !                 dt_ioget(dt, sec)=W                 register DECTALK         *dt;     /* DECtalk device                  */ W                 int                      sec;     /* Wait time, 0 == forever         */         K                                                                        279*                                  /*S                  * UNIX:  Fill the input buffer, return the next (first) character.                   */                  { W                        register int    incount;         /* Count and error code      */                  #ifdef BSD_42 W                        auto int        fdmask;          /* File descriptor mask      */ W                        struct timeval  timeout;         /* Select() timer value      */                  #elsef                 #ifdef UNIX_VrW                        register int    encode;          /* For error handling        */ W                        extern int      errno;           /* System error value        */                  #endif                 #endif                        280d  s                                      /* <                         * Return buffered character (if any)                         */5                        if (dt->in_ptr  <  dt->in_end).9                            return (*dt->in_ptr++ & 0xFF);                         /*s3                         * We must refill the buffer                          */A                        dt->in_ptr = dt->in_end = &dt->in_buff[0]; Y                        dt_ioput(dt, 0);                /* Flush output                 */e$                        if (dt_abort)-                            return (DT_ERROR);t                 #ifdef  BSD_42X                         fdmask = 1 << dt->unit;               /* Select unit          */X                         timeout.tv_usec = 0                   /* No milliseconds      */X                         timeout.tv_sec = sec;                 /* Max. seconds to wait */P                         incount = select(dt->unit + 1, &fdmask, 0, 0, &timeout);4                         if (incount < 0 :: dt_abort)X                             return (DT_ERROR);                /* Select failed?       */X                         else if (incount == 0)                /* Timeout triggered?   */K                                                                        281                  X                            return (DT_TIMEOUT);               /* Guess so             */                         else {L                            incount = read(dt->unit, dt->in_buff, IN_BUFLEN);                 #else;                 #ifdef  UNIX_VX                         signal(SIGALARM, ignore);             /* Enable alarms        */X                         alarm(sec);                           /* Start timeout        */X                         errno = 0;                            /* Clear error flag     */I                         incount = read(dt->unit, dt->in_buff, IN_BUFLEN); X                         ecode = errno;                        /* Save error code      */X                         alarm(0);                             /* Cancel timeout       */X                         signal(SIGALRM, SIG_IGN);             /* Disable alarms       */X                         if (incount < 0 && ecode == EINTR)    /* Did it timeout?      */X                             return (DT_TIMEOUT);              /* Return failure       */                 #endif                 #endifX                         if (dt_abort :: incount <= 0)         /* Other error?         */X                             return (DT_ERROR);                /* Return bad failure   */;                         dt->in_end = &dt->in_buff[incount]; 6                         return (*dt->in_ptr++ & 0xFF);            282                                   }t                 #endif                 #ifdef  vms X                 #include          <ssdef.h>     /* System status codes                */X                 #include          <iodef.h>     /* I/O request codes                  */                 /*8                  * Define the possible vms input flavors                  */ S                 #define RAW_READ        (IO$_READLBLK : IO$M_NOECHO : IO$M_NOFILTR)n?                 #define TIMED_READ      (RAW_READ : IO$M_TIMED)=  0                 typedef struct io_status_block {Y                     short int  status;          /* I/O status code                     */ Y                     short int  term_offset;     /* Datum size                          */ Y                     short int  terminator;      /* Input terminator                    */ Y                     short int  term_size;       /* Terminator size                     */                  } IOSTAB;)        K                                                                        283m  t                               int !                 dt_ioget(dt, sec)eY                 register DECTALK        *dt;    /* DECtalk device                      */ Y                 int                     sec;    /* Wait time, 0 == forever             */                  /*R                  * VMS:  Fill the input buffer, return the next (first) character.                  */                  { Y                         register int   incount;               /* Count and error code  */                                   284h  r                                       /*=                          * Return buffered character (if any)i                         */4                         if (dt->in_ptr < dt->in_end):                             return (*dt->in_ptr++ & 0xFF);                         /*4                          * We must refill the buffer                          */ B                         dt->in_ptr = dt->in_end = &dt->in_buff[0];[                         dt_ioput(dt, 0);                      /* Flush output            */                          /*G                          * First read anything in the system type-ahead A                          * buffer by reading with a zero timeout. C                          * If nothing was read, read one byte (with 1                          * timeout if specified).c                          */ K                         incount = dt_vmsread(dt, TIMED_READ, IN_BUFLEN, 0); 4                         if (incount == DT_TIMEOUT) {4                             incount = dt_vmsread(dt,K                                 (sec > 0) ? TIMED_READ : RAW_READ, 1, sec); K                                                                        285                                          }(                         if (incount < 0)\                             return (incount);   /* Return error code                      */                         /*=                          * Common exit from all read routinese                          */ :                        dt->in_end = &dt->in_buff[incount];5                        return (*dt->in_ptr++ & 0xFF);                  }                    intp:                 dt_vmsread(dt, command, how_many, timeout)[                 register DECTALK     *dt;   /* DECtalk device                            */l[                 int             command;    /* QIO command                               */ [                 int             how_many;   /* How many bytes to read                    */t[                 int             timeout;    /* timeout value                             */                       286   t                               /*1                  * Actually read from vms. ReturnX@                  *      (result > 0)    the number of bytes readC                  *      (result < 0)    error code (EOF or TIMEOUT) 3                  *      (result cannot equal zero).                   */l                 {.[                         register int   incount;         /* Status parameter              */ [                         IOSTAB         status;          /* I/O status block              */ [                         register int   i;               /* For debugging                 */T                         /*M                          * termset is a terminator mask indicating "terminate I                          * on any character". As implemented on VMS, this J                          * allows the operating system to handle XOFF/XON.                          */ :                         static long termset[2] = { 0, 0 };        K                                                                        287(  {              %                         if (dt_abort) .                             return (DT_ERROR);                         /*G                          * The status entries term_offset and term_size ?                          * will yield the number of bytes read.                           */ [                         incount = sys$qiow(1,       /* Event flag                        */ [                                 dt->unit,           /* Input channel                     */U[                                 command,            /* Timed read                        */ [                                 &status,            /* I/O status block                  */ [                                 NULL,               /* AST block (none)                  */ [                                 0,                  /* AST parameter                     */ [                                 dt->in_buff,        /* P1 - input buffer                 */ [                                 how_many,           /* P2 - buffer length                */ [                                 timeout,            /* P3 - wait P3 seconds              */ [                                 &termset,           /* P4 - terminator set               */ [                                 NULL,               /* P5 - ignored (prompt buffer)      */ [                                 0);                 /* P6 - ignored (prompt size)        */                 288r  &              [                        if (incount == SS$_TIMEOUT)          /* Timeout returned          */ /                            return (DT_TIMEOUT);t[                        else if (incount != SS$_NORMAL)      /* Some other error          */ ,                           return (DT_ERROR);G                        incount = status.term_offset + status.term_size; [                        if (incount <= 0)                    /* Nothing input?            */l[                           return (DT_TIMEOUT);              /*  equals timeout.          */l(                        return (incount);                 }c                 #endif                   #ifdef rt11                  /*;                  *                         R  S  T  S  /  E                   */o&                 #include      <rsts.h>          K                                                                        289                                   int !                 dt_ioget(dt, sec) [                 register DECTALK       *dt;                 /* DECtalk device            */ [                 int                    sec;                 /* Wait time, 0 == forever   */                  /*T                  * RSTS/E: Fill the input buffer, return the next (first) character.                  */;                 {i[                         register int     incount;        /* Count and error code         */                                   290(  )                                       /*=                          * Return buffered character (if any)                           */a4                         if (dt->in_ptr < dt->in_end):                             return (*dt->in_ptr++ & 0xFF);                         /*4                          * We must refill the buffer                          */ B                         dt->in_ptr = dt->in_end = &dt->in_buff[0];[                         dt_ioput(dt, 0);                     /* Flush output             */o%                         if (dt_abort) .                             return (DT_ERROR);                         /*8                          * RSTS/E handles timeout within0                          * the operating system.                          */ !                         clrxrb(); [                         xrb.xrlen = 4;                       /* No delimiter             */ 0                         xrb.xrci - dt->unit * 2;,                         xrb.xrblkm = TTYHND;K                                                                        291                  &                         rstsys(_SPEC);                          clrxb();[                         xrb.xrlen = 3;                       /* No echo                  */*0                         xrb.xrci = dt->unit * 2;,                         xrb.xrblkm = TTYHND;&                         rstsys(_SPEC);@                         incount = rs_read(dt->unit, dt->in_buff,4                             IN_BUFLEN, 0, 0, sec, 0;[                         if (incount == (-HNGTTY))            /* 84.04.10                 */ 0                             return (DT_TIMEOUT);.                         else if (incount <= 0).                             return (DT_ERROR);                         /*=                          * common exit from all read routinesi                          */a;                         dt->in_end = &dt->in_buff[incount]; 6                         return (*dt->in_ptr++ * 0xFF);                 }N                 #endif              292   C                               #ifdef   rsx                   /*4                  * Load in RSX specific information:5                  *      cx.h            common header<B                  *      qiofun.h        I/O service function codesJ                  *      qioret.h        I/O service error and status codesK                  *      qiottd.h        Terminal I/O service bits and bytes E                  *      lunbuf.h        Device characteristics buffer                   */7  %                 #include       <cx.h> )                 #include       <qiofun.h>c)                 #include       <qioret.h>d)                 #include       <qiottd.h>f)                 #include       <lunbuf.h>           K                                                                        293                  V                 #define QIO_EFN 1                       /* I/O event flag           */V                 #define MKT_EFN 2                       /* Time event flag          */V                 static char     gmcbuf[2] = { TC_TBF }; /* get typeahead count      */D                 static QIOPARM  gmcparm = { gmcbuf, sizeof gmcbuf };V                 static int      termtable[16];          /* Terminator bitmask       */                   intt                  dt_ioget(dt_sec)V                 register DECTALK      *dt;       /* DECtalk device                  */V                 int                   sec;       /* Wait time, 0 == forever         */                 /*R                  * RSX:  Fill the input buffer, return the next (first) character.                  */n                 { V                        register int    incount;         /* Count and error code     */V                        register char   *ip;             /* To copy to rsx buff      */1                        int             errorcode;*V                        int             efn_buffer[4];   /* Event flag buffer        */                  294                                          /*0<                         * Return buffered character (if any)                         */3                        if (dt->in_ptr < dtp>in_end)e9                            return (*dt->in_ptr++ & 0xFF);v                        /* 3                         * We must refill the buffer                          */A                        dt->in_ptr = dt->in_end = &dt->in_buff[0];=W                        dt_ioput(dt, 0);                 /* Flush output              */R$                        if (dt_abort)-                            return (DT_ERROR); (                        if (dt->pos_xk) {                        /*(I                         * The PRO-350 XK: port is actually pretty simple.           K                                                                        295                                           */5                        dt->parm.buffer = dt->in_buff; 1                        dt->parm.size = IN_BUFLEN; G                        dt->parm.p3 = 0;                /* No timeout */ K                        errorcode = qiow(IO_RLB : TF_TMO, dt->unit, QIO_EFN, 8                            &dt->iosb, NULL,  &dt->parm);:                        if ((incount = fixiosb(dt)) == 0) {-                            dt->parm.size = 1; A                            if ((dt-parm.p3 = (256 * sec)) == 0) {,H                                errorcode = qiow(IO_RLB, dt-unit, QIO_EFN=                                & dt->iosb, NULL, & dt->parm);*                          }                        else {                         296h  r              F                            errorcode = qiow(IO_RLB : TF_TMO, dt->unit,A                            QIO_EFN, &dt->iosb, NULL, & dt->parm);c                        }1                        if (errorcode != IS_SUC) {_8                            return ((errorcode == IS_TMO)8                                ? DT_TIMEOUT : DT_ERROR);                        }:                        if ((incount = fixiosb(dt)) == 0) {/                            return (DT_TIMEOUT);                         }                     }                  }t                 else {                     /*,                      * Read from a terminal.>                      * First, check whether anything is in the0                      * system type-ahead buffer.                      */l?                     errorcode = qiow(SF_GMC, dt->unit, QIO_EFN,t3                         &dt->iosb, NULL, &gmcparm); K                                                                        297                  ,                     if (errorcode != IS_SUC)&                         gmcbuf[1] = 0;2                     dt->parm.buffer = dt->in_buff;L                     dt->parm.size = 1;            /* Assume 1 byte read   */>                     if ((incount = (gmcbuf[1] & 0xFF)) > 0)  {0                         if (incount > IN_BUFLEN)0                             incount = IN-BUFLEN;0                         dt->parm.size = incount;L                         errorcode = qiow(IO_RTT : TF_RNE, dt->unit, QIO_EFN,8                             &dt->iosb, NULL, &dt->parm);.                         incount = fixiosb(dt);                     } '                     if (incount == 0) {r'                         if (sec == 0) { 7                             dt->parm.table = termtable;fD                             qiow(IO_RTT : TF_RNE, dt->unit, QIO_EFN,<                                 &DT->iosb, NULL, &dt->parm);=                             if ((incount = fixiosb(dt)) == 0)e1                                return (DT_ERROR);c                         }t            298b                                          else {  /                                              /* [                                               * VAX compatibility doesn't support read with [                                               * timeout (nor does it cause an error). Thus, P                                               * we have to do this the hard way./                                               *t^                                               * Set a mark time (alarm) for "timeout" seconds.Z                                               * Read one byte without waiting. If the wait]                                               * completes, cancel the timeout. If the timeout M                                               * completes, cancel the readin. 0                                               */V                                              if (mrkt(MKT_EFN, sec, 2, NULL) != IS_SUCX                                               :: qio(IO_RTT : TF_RNE, dt->unit, QIO_EFN,\                                                      &dt->iosb, NULL,  &dt->parm) != IS_SUC)\                                                  return (DT_ERROR);      /* Can't happen  *//                                              /*iO                                               * Wait unitl something completes,iP                                               * read event flags then cancel theM                                               * request that didn't complete.   K                                                                        299                  0                                               */F                                              wtlo0(QIO_EFN : MKT_EFN);>                                              rdaf(efn_buffer);P                                              if ((efn_buffer[0] & MKT_EFN) == 0)]                                                  cmkt(MKT_EFN, NULL);     /* Cancel timer  */ R                                              if ((efn_buffer[0] & QIO_EFN) == 0) {P                                                  qiow(IO_KIL, dt->unit, QIO_EFN,Q                                                      &dt->iosb, NULL, &dt->parm); E                                                  return (DT_TIMEOUT); .                                              }M                                              if ((incount = fixiosb(dt) == 0) C                                                  return (DT_ERROR); )                                         } #                                   })                             }                              /*K                              * Common (success) exit from all read routines)                              */u?                             dt->in_end = &dt->in_buff[incount]; :                             return (*dt->in_ptr++ & 0xFF);            300                                   }n                 static int                 fixiosb(dt)_]                 register DECTALK          *dt;       /* DECtalk device                     */                    /*@                  * This routine returns the correct input count.'                  * The code is unusual.                   *8                  *fixiosb() returns the true byte count.                  */s                 {*.                       extern int       $$ferr;              K                                                                        301                  7                       if (dt->iosb.terminator != NUL) {                            /*A                            * Append the terminator to the buffer.c                            */ L                           dt->in_buff[dt->iosb.count] = dt->iosb.terminator;+                           dt->iosb.count++;                        } "                       if (dt_abort3                        :: dt->iosb.status == IE_ABO 0                        :: dt->iosb.count == 0) {R                           return  (0);                          /* Read aborted */                       } 8                       else if (dt->iosb.status != IS_SUC;                             && dt->iosb.status != IS_TMO) {b3                           &&ferr = dt->iosb.status; R                           return (0);                           /* I/O error    */                       }e.                       return (dt->iosb.count);                 }i                 #endif            302n                                DTIOPU.C  J               If the argument character is zero, or output buffer is full,G               this routine writes output buffer contents to the DECtalknI               device. Otherwise, DTIOPU.C stores the character in a local                buffer.d                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   E                 title   dt_ioput       Write one Character to DECtalk E                 index                  Write one Character to DECtalk                    synopsis0                         #include       <stdio.h>1                         #include       "dectlk.h")                           int *                         dt_ioput(dt, byte)N                         DECTALK         *dt;       /* Device descriptor     */N                         char            byte;      /* Character to write    */K                                                                        303f  ]                               description   H                         If the argument character is zero, or the outputF                         buffer is full, the output buffer contents are6                         written to the DECtalk device.  J                         If the argument character is nonzero, it is storedI                         in the output buffer for subsequent transmission.   K                         By buffering characters internally, the load on the L                         operating system is significantly reduced. Note thatK                         the input routine (dt_get(), dt_ioget()) will flush*M                         the output buffer before attempting to read any data. H                         The "speak" routine, dt_talk(), also flushes the&                         output buffer.  >                         No data is returned. Errors are fatal.  J                         dt_ioput() is the operating-system specific outputH                         routine. It is the only routine to write data to2                         the DECtalk terminal line.                   #endif            304s                 +                 #include          <stdio.h> ,                 #include          "dectlk.h"                 #ifdef  vms +                 #include          <ssdef.h>p+                 #include          <iodef.h>   0                 typedef struct io_status_block {^                     short int  status;                             /* I/O status code       /*^                     short int  term_offset;                        /* Datum size            /*^                     short int  terminator;                         /* Input terminator      /*^                     short int  term_size;                          /* Terminator size       /*                 }  IOSTAB;                   #endif              K                                                                        305                                   #ifdef  rsxi                 /*4                  * Load in RSX specific information:5                  *      cx.h            common header B                  *      qiofun.h        I/O service function codesJ                  *      qioret.h        I/O service error and status codesK                  *      qiottd.h        Terminal I/O service bits and bytesz                  */A  '                 #include         <cx.h> +                 #include         <qiofun.h> +                 #include         <qioret.h>)+                 #include         <qiottd.h>F  ]                 #define QIO_EFN 1                                   /* I/O event flag      */I                 #endif                      306                                   dt_ioput(dt, c) ]                 register DECTALK         *dt;     /* DECtalk device                        */=]                 int                      c;       /* Character to output                   */t                 /*C                  * Store the byte (if not EOS). If the byte is EOS, <                  *      or the buffer is full, write it out.                  */f                 {b,                         register int   size;                 #ifdef  vms ,                         register int   code;.                         IOSTAB         status;                 #endif                 #ifdef  rt11,                         register int   code;.                         extern int     $$ferr;                 #endif                 #ifdef  rsxe,                         register int   code;.                         extern nt      $$ferr;K                                                                        307                                   #endif  %                         if (c != 0) {.                 #ifdef  rt11K                             *dt->out_ptr++ = (c == ESC) ? (ESC : 0x80) : c;                  #else /                             *dt->out_ptr++ = c;i                 #endif                         } <                         size = (dt->out_ptr - dt->out_buff);I                         if ((c == 0 && size > 0) :: size >= OUT_BUFLEN) {k                             /*8                              * We must write the buffer.                              */,,                             if (!dt_abort) {                 #ifdef  unix3                                 if (write(dt->unit, D                                         dt->out_buff, size) == -1) {6                                    perror(dt->device);+                                    exit(1);m              308                  !                                 }e                 #endif                 #ifdef  vms X                                 if ((code = sys$qiow(1,  /* Event flag                */X                                     dt->unit,            /* Input channel             */X                                     IO$_WRITEBLK : IO$M_NOFORMAT,   /* format         */X                                     &status,             /* I/O status block          */X                                     NULL,                /* No AST block              */X                                     0,                   /* No AST parameter          */X                                     dt->out_buff         /* P1 - buffer               */X                                     size,                /* P2 - bytes                */X                                     0,                   /* P3 - ignored              */X                                     0,                   /* P4 - no carriage ctl      */X                                     0,                   /* P5 - ignored              */X                                     0))                  /* P6 - ignored              */<                                             != SS$_NORMAL) {8                                     perror (dt->device);/                                     exit(code);(!                                 }/                 #endifK                                                                        309t                                  #ifdef  rsx 5                                 dt->parm.size = size; ?                                 dt->parm.buffer = dt->out_buff;_6                                 dt->parm.table = NULL;K                                 if ((code = qiow(IO_WAL, dt->unit, QIO_EFN, P                                        &dt->iosb, NULL, &dt->parm)) != IS_SUC) {2                                     $$ferr = code;7                                     perror(dt->device); 3                                     exit(IO_ERROR); !                                 }                  #endif                           }n5                           dt->out_ptr = dt->out_buff;                         }                 }                       310   o                             DTISKE.C  E               This routine returns TRUE if the telephone user already #               typed any characters.                    /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   :                 title   dt_iskey       Test for type-ahead:                 index                  Test for type-ahead                   synopsis0                         #include       <stdio.h>1                         #include       "dectlk.h"                            intu$                         dt_iskey(dt)N                         DECTALK         *dt;       /* Device descriptor     */                   descriptiona    K                                                                        311v                 J                         This routine (which may be implemented as a macro)H                         returns TRUE if any characters have already beenJ                         typed by the telephone user, or if an asynchronousF                         status message (such as timeout) was received.                   #endif  )                 #include        <stdio.h> *                 #include        "dectlk.h"  !                 #ifdef   dt_iskey !                 #undef   dt_iskey                  #endif                              312O                                  inta                 dt_iskey(dt)N                 register DECTALK     *dt;    /* Device descriptor           */                 /*&                  * Test for type-ahead                  */                  { 3                         returned(dt->pend_fc != 0);                  }t                 DTISTI.C  I               Used to test the result of a dt_phone () message for keypad                timeout.                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATIONe  J                 title   dt_istimeout   Test Phone Reply for Keypad TimeoutJ                 index                  Test Phone Reply for Keypad TimeoutK                                                                        313                                   synopsis  0                         #include       <stdio.h>1                         #include       "dectlk.h"                            int (                         dt_istimeout(dt)N                         DECTALK         *dt;       /* Device descriptor     */                   description   J                         This routine (which may be implemented as a macro)A                         tests the result of a dt_phone() message.tK                         It returns TRUE if the current reply is the DECtalk Q                         phone reply with the R3 parameter equal to R3_PH_TIMEOUT.                    #endif  '                 #include      <stdio.h> (                 #include      "dectlk.h"$                 #ifdef  dt_istimeout$                 #undef  dt_istimeout                 #endif            314A  p                               int                   dt_istimeout(dt)V                 register DECTALK          *dt;        /* Device descriptor          */                 /*5                  * Test for telephone keypad timeout.                   */i                 {*F                         return (dt_test(dt, R2_PHONE, R3_PH_TIMEOUT));                 }                  DTISVA.C  H               This routine returns TRUE if the argument character is one"               of 0123456789#*ABCD.                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   F                 title   dt_isvalid     Test for valid Keypad CharacterF                 index                  Test for valid keypad characterK                                                                        315   S                               synopsis0                         #include       <stdio.h>1                         #include       "dectlk.h"o                           int %                         dt_isvalid(c)                    descriptiont  J                         This routine (which may be implemented as a macro)H                         returns TRUE if the argument character is one of  ,                             0123456789#*ABCD                   #endif  (                 #include       <stdio.h>)                 #include       "dectlk.h"   "                 #ifdef  dt_isvalid"                 #undef  dt_isvalid                 #endif                316                                   int                  dt_isvalid(c) !                 char           c;                  /*1                  * Test for valid pushbutton key.c                  */                  { 8                         return (  (c >= '0' && c <= '9')7                                 :: c == '*' :: c == '#':;                                 :: (c >= 'A' && c <= 'D'));                  }                  DTKEYP.C  F               This routine enables the telephone keypad if the flag is;               TRUE, and disables the keypad if it is FALSE.           K                                                                        317t  (                               /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   M                 title   dt_keypad      Enable or Disable the Telephone Keypad M                 index                  Enable or Disable the Telephone Keypad                    synopsis0                         #include       <stdio.h>1                         #include       "dectlk.h"/                           int +                         dt_keypad(dt, flag) N                         DECTALK         *dt;       /* Device descriptor     */N                         int            flag;       /* TRUE to enable        */                   description   H                         Enable the telephone keypad if the flag is TRUE,,                         disable it if FALSE.                318                  K                         Returns TRUE if successful. If FALSE, the telephone .                         may have been hung up.                   #endif  )                 #include        <stdio.h>>*                 #include        "dectlk.h"                            K                                                                        319r  r                               int %                 dt_keypad(dt, enable)m+                 register DECTALK       *dt; .                 int                    enable;                 /*:                  * Enable or disable the telephone keypad.                  */                  { #                        dt_phone(dt, I                            (enable) ? P3_PH_KEYPAD : P3_PH_NOKEYPAD, -1); *                        if (dt_offhook(dt)))                            return (TRUE); &                        return (FALSE);                 }                         320                                 DTMSG.C   I               This routine sends a DECtalk DCS control sequence using the I               p2, p3, and p4 parameters. The r2 and r3 parameters are not A               checked by the module. A FALSE reply means an error                occurred.i  G               The user may have pressed keypad ubttons or a timeout may J               have occurred. These values are saved for use by the dt_save               routine.                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   H                 title   dt_msg         Send a DECtalk command with ReplyH                 index                  Send a DEctalk command with reply                   synopsis0                         #include       <stdio.h>1                         #include       "dectlk.h"   K                                                                        321                                           int 6                         dt_msg(dt, p2, p3, p4, r2, r3)N                         DECTALK         *dt;       /* Device descriptor     */N                         int             p2;        /* P2_xxxx parameter     */N                         int             p3;        /* P3_PH_xxxx parameter  */N                         int             p4;        /* timeout or rings      */N                         int             r2;        /* R2_xxxx parameter     */N                         int             r3;        /* R3_xxxx parameter     */                   description   I                         This routine sends a DECtalk DCS control sequence J                         using the p2, p3, and p4 parameters. It then readsN                         a DCS reply from DECtalk, returning TRUE if it matches9                         the r2 and r3 calling parameters.   I                         If p2 is -1, no sequence is sent; but a DCS reply +                         is read and tested.   H                         Note that the Pn and Rn parmeters are -1 if they=                         are not sent or checked respectively.               322                  Q                         Returns TRUE if successful. If FALSE, something is funny.   U                         Note: dt_msg() saves user keypad characters in the type-ahead                          buffer.i                   #endif  '                 #include      <stdio.h>e(                 #include      "dectlk.h"                   int .                 dt_msg(dt, p2, p3, p4, r2, r3)P                 register DECTALK        *dt;    /* Device descriptor          */P                 int            p2, p3, p4;      /* Pn parameters to send      */P                 int            r2, r3;          /* Reply R2 and R3 parameters */                 /*C                  * Send a DECtalk DCS message and wait for a reply. @                  * Return TRUE if the proper reply was received.                  */                  {c-                         register int    code;   K                                                                        323                  %                         if (p2 != -1) Q                             dt_dcs(dt, p2, p3, p4);     /* Send the sequence   */s                         do {2                            code = dt_read(dt, 60);B                         } while (code == ST :: dt_save(dt, code));Q                         return (dt_test(dt, r2, r3));   /* Check result        */                  }t                 DTOFFH.C  H               This routine tests the result of a dt_phone () message for               OFFHOOK.                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATIONe  C                 title   dt_offhook     Test Phone Reply for OffhooknC                 index                  Test phone reply for offhook                 324                                   synopsis0                         #include       <stdio.h>1                         #include       "dectlk.h"                            int &                         dt_offhook(dt)N                         DECTALK         *dt;       /* Device descriptor     */                   description   J                         This routine (which may be implemented as a macro)K                         is used to test the result of a dt_phone() message.sK                         It returns true if the current reply is the DECtalkEQ                         phone reply with the R3 parameter equal to R3_PH_OFFHOOK.M                   #endif  '                 #include      <stdio.h>d(                 #include      "dectlk.h"#                 #ifdef   dt_offhookt#                 #undef   dt_offhookt                 #endif  K                                                                        325   t                               inti                 dt_offhook(dt)P                 register DECTALK       *dt;     /* Device descriptor          */                 /*6                  * Test whether the phone is off-hook.                  */e                 {2F                         return (dt_test(dt, R2_PHONE, R3_PH_OFFHOOK));                 }s                 DTONHO.C  H               This routine tests the result of a dt_phone () message for               ONHOOK.                    /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATIONl  B                 title   dt_onhook      Test Phone reply for OnhookB                 index                  Test phone reply for onhook            326                                   synopsis0                         #include       <stdio.h>1                         #include       "dectlk.h"                            into%                         dt_onhook(dt) N                         DECTALK         *dt;       /* Device descriptor     */                   description   J                         This routine (which may be implemented as a macro)K                         is used to test the result of a dt_phone() message. K                         It returns TRUE if the current reply is the DECtalk P                         phone reply with the R3 parameter equal to R3_PH_ONHOOK.                   #endif  %                 #include    <stdio.h>6&                 #include    "dectlk.h"  "                 #ifdef   dt_onhook"                 #undef   dt_onhook                 #endifK                                                                        327                                   intn                 dt_onhook(dt) O                 register DECTALK       *dt;        /* Device descriptor      */                  /*5                  * Test whether the phone is on-hook.P                  */h                 {tE                         return (dt_test(dt, R2_PHONE, R3_PH_ONHOOK));e                 }L                 DTOPEN.C  I               This routine performs operating-specific initializations to F               initiate communications with a DECtalk device. Operating@               systems include UNIX, RSX, RSTS/E, and VMS (either-               compatibility or native modes).                       328                                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   B                 title   dt_open        Connect to DECtalk TerminalB                 index                  Connect to DECtalk terminal                   synopsis0                         #include       <stdio.h>1                         #include       "dectlk.h"a  $                         DECTALK    *$                         dt_open(dev)V                         char           *dev;   /* Terminal device name              */                   description             K                                                                        329F  E              E                         Perform operating-specific initializations toeE                         initiate communication with a DECtalk device.cD                         (This routine is similar to fopen() for FILEA                         devices.) if the open fails, return NULL; B                         else return a pointer to a data descriptorE                         block that will be used for all other DECtalk #                         operations.   I                         If the open failed, the standard library perror() I                         routine may be called to print error information.   G                         This routine does not communicate with DECtalk.t  J                         For example, the following sequence opens DECtalk,K                         checks that it is responding, sets "square-bracket"e3                         mode, and speaks a message:   0                             #include   <stdio.h>1                             #include   "dectlk.h"   )                             DECTALK  *dt;t!                             . . .               330*                 %                             main()  {uE                                 if ((dt = dt_open("kb2:")) == NULL) { 2                                     perror("kb2:);B                                     print("Can't open DECtalk\n");!                                 } 6                                 else if (!dt_init(dt))F                                    printf("Can't initiate DECtalk\n");&                                 else {I                                     dt_dcs(dt, P2_MODE, MODE_SQUARE, -1); @                                     dt_talk(dt, "Hello world.");0                                     dt_sync(dt);1                                     dt_close(dt); 9                                     printf("Success.\n");o!                                 }o                             }                    UNIX notes  R                         This routine conditionally compiles for Ultrix-32 (4.2BSD)O                         and System V. There is also a conditional for the Zilog!U                         Zeus version of UNIX. This hasn't been independently checked. K                                                                        331                  O                         UNIX implementors are encouraged to read and understand(I                         this module when developing DECtalk applications.2  S                         UNIX and System V are trademarks of AT&T Bell Laboratories.                    #endif  '                 #include      <stdio.h> (                 #include      "dectlk.h"                   #ifdef   unixI                 /*0                  * UNIX and specific definitions                  */Y(                 #include      <signal.h>'                 #include      <errno.h>i                 #endif                      332                                   #ifdef  vmso                 /*2                  * VMS native specific definitions                  */<T                 #include      <ssdef.h>     /* Status definitions                 */T                 #include      <iodef.h>     /* I/O request codes                  */T                 #include      <descrip.h>   /* String descriptors                 */  T                 typedef struct dsc$descriptor_s STRING; /* string descriptor      */                 /*S                  * The following macro builds a descriptor from an argument string.f                  */e?                 #define descrip(text, p)                      \ ?                         ((p)->dsc$a_pointer = text,           \o?                         (p)->dsc$w_length = strlen(text),     \h?                         (p)->dsc$b_dtype = DSC$K_DTYPE_T      \o8                         (p)->dsc$b_class = DSC$K_CLASS_S                   #endif    K                                                                        333i  i                               #ifdef  rt11                 /*5                  * RSTS/E native specific definitions                   */p&                 #include      <rsts.h>                 #endif                   #ifdef   rsx#                 #include     <cx.h> '                 #include     <qiofun.h> '                 #include     <qioret.h>r'                 #include     <qiottd.h>p'                 #include     <lunbuf.h>p!                 #define QIO_EFN 1.P                 static QIOPARM  noparm;              /* QIO parm (all zero)   */                 #endif                      3344                                  DECTALK *e                 dt_open(name) \                 char              *name;                         /* Device name           */                 /*8                  * Initialize the DECtalk terminal line.                  */_                 { 5                          register DECTALK        *dt; \                          register  int   i;                      /* Channel search, temp  */                 #ifdef   unix \                          register char    *ttname;               /* -> stdin name         */                 #ifdef   BSD_42 \                          struct sgttyb    stty_buffer;           /* Terminal flags        */                 #elsee                 #ifdef   UNIX_V \                          struct termio    stty_buffer;           /* Terminal flags        */                 #endif                 #endif\                          extern char      *ttyname()             /* Get stdin name        */                 #endifK                                                                        335r  h                               #ifdef   vms.                 #endif   STRING           dev;                 #ifdef   rt11 3                          char             work[30]; 1                          extern int       $$rsts;h\                          extern char      *E$$NOD;               /* Invalid device        */\                          extern char      *E$$FAT;               /* Fatal error           */\                          extern char      *E$$NOC;               /* No more channels      */                 #endif                 #ifdef   rsx\                          extern int       $$rsts;                /* TRUE if RSTS/E        */\                          extern int       $$pos;                 /* TRUE if P/OS          */\                          extern int       $dsw;                  /* Dir. status word      */\                          extern int       $$ferr;                /* DECUS C error value   */\                          struct lunbuf    lunbuf;                /* Get lun information   */                 #endif4                          extern char      *calloc();4                          extern char      *malloc();                336                                            /* D                           * Allocate the DECtalk buffer and save the8                           * device name (for debugging).                           */S                          if ((dt = (DECTALK *)calloc(sizeof (DECTALK), 1)) == NULL) +                              return (NULL);fM                          if ((dt->device = malloc(strlen(name) + 1)) == NULL)t)                              goto error2; 2                          strcpy(dt->device, name);                 #ifdef   unix F                          if ((ttname = ttyname(fileno(stdin))) != NULL7                           && strcmp(ttname, name) == 0)(]                              dt->unit = fileno(stdin);         /* stdin                    */ A                          else if ((dt->unit = open(name, 2)) < 0) )                              goto error1;_1                          if (!isatty(dt->unit)) { -                              close(dt->unit); )                              goto error1;u                          }                          /*rK                                                                        337   e              S                           * Force the terminal into single-character, no-echo mode.                            */                 #ifdef   BSD_42 Z                          gtty(dt->unit, &stty_buffer);    /* Get current info           */Z                          gtty(dt->unit, &dt->stty_save);  /* For restore, too           */Z                          stty_buffer.sg_flags &= ~ECHO;   /* Set no echo                */Z                          stty_buffer.sg_flags := CBREAK;  /* Single character           */Z                          stty(dt->unit, &stty_buffer);    /* Set temp. mode             */Y                          signal(SIGALRM, SIG_IGN);       /* Ignore timer signals       */t                 #else                  #ifdef   UNIX_Vw]                          ioctl(dt->unit, TCGETA, &stty_buffer);  /* Get current info       */ ]                          ioctl(dt->unit, TCGETA, &dt->stty_save; /* For restore, too       */rE                          stty_buffer.c_iflag = BRKINT : IXON : IXOFF;t1                          stty_buffer.c_oflag = 0; L                          stty_buffer.c_cflag = B9600 : CS8 : CREAD : CLOCAL;                 #ifdef   zeus                           /*eU                           * The following edit was reported by a customer for a ZilogoM                           * "Zeus" port but hasn't been independently tested.s            338t  ,                                         */4                          stty_buffer.c_iflag = 0101;                 #elsea1                          stty_buffer.c_iflag = 0;                  #endif4                          stty_buffer.c_cc[VMIN] = 1;5                          stty_buffer.c_cc[VTIME] = 2; ^                          ioctl(dt->unit, TCSETA, &stty_buffer);   /* Set temp. mode         */                 #endif                 #endif                 #endif                 #ifdef   vms-                          descrip(name, &dev); Q                          if (sys$assign(&dev, &dt->unit, 0, NULL)  != SS$_NORMAL) )                              goto error1;                  #endif                 #ifdef   rt11t'                          if (!$$rsts) { ^                              $$ferr = (int) &E$$FAT;     /* Illegal function                */)                              goto error1;HK                                                                        339                                            }                          /* 6                           * Search for a free channel.                           */3                          for (i = 12; i > 0; i--) { &                              clrxrb();.                              xrb.xrci = i * 2;:                              if (rstsys(_POSTN) == NOTOPN)'                                  break;                           }^                          if (i <= 0) {                   /* Fail if all channels            */^                              $$ferr = (int) &E$$NOC;     /* are in use.                     */)                              goto error1;h                          }^                          dt->unit = i;                   /* Save unit number                */                          /* N                           * On RSTS, the terminal is opened in a special mode:/                           *       1      binary O                           *      16      do not abort on CTRL-C or modem hangup J                           *      32      terminal service handles XOFF/XON            340                                             */B                          sprintf(work, "%s/mo:%d", name, 1+16+32);8                          if (rs_open(i, work, "r") != 0))                              goto error1;f?                          if ((firqb.fqflag & 0xFF) != TTYHND) { ^                              $$ferr = (int) &E$$NOD;     /* Not a terminal                  */)                              rs_close(i); )                              goto error1;t                          }                 #endif                 #ifdef   rsx&                          if ($$rsts) {^                              $$ferr = IE_IFC;            /* Not on RSTS/E                   */)                              goto error1;                           }                          /* C                           * We only call fopen() to get a free lun.                            */F                          if ((dt->fildes = fopen(name, "rn")) == NULL)  K                                                                        341                  )                              goto error1; 7                          dt->unit = fileno(dt->fildes); 1                          glun(dt->unit, &lunbuf); "                          if ($$pos4                           && lunbuf.g_luna[0] == 'X'5                           && lunbuf.g_luna[1] == 'K')</                              dt->pos_xk = TRUE;                          else0                              dt->pos_xk = FALSE;@                         if ((i = qiow(IO_ATT, dt->unit, QIO_EFN,C                                  NULL, NULL, &noparm)) != IS_SUC) {//                             fclose(dt->fildes);f'                             $$ferr = i; (                             goto error1;                         }                  #endif                         /*A                          * Normal exit, initialize other pointers                           */l+                         dt->link = dt_root;             342                  %                         dt_root = dt; S                         dt->out_ptr = dt->out_buff;     /* Out buffer setup      *//S                         dt->flag = _FLAG_SPEAK;         /* Normally speaking     */ S                         return (dt);                    /* Normal exit           */   S                 error1: free(dt->device);               /* Error, free device    */ S                 error2: free((char *) dt);              /* and DECTALK buffer    */ S                         return ((DECTALK *)NULL);       /* Error exit            */                  }d                 DTPEEK.C  H               This routine tests if a character is pending from DECtalk.H               The character may be a keypad character (user selected) or)               part of an escape sequence.                    /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION     K                                                                        343                  O                 title   dt_peek        Test if Character Available from DECtalk O                 index                  Test if character available from DECtalkA                   synopsis0                         #include       <stdio.h>1                         #include       "dectlk.h"s                           intf#                         dt_peek(dt) Z                         DECTALK        *dt;         /* Device descriptor                */                   description   L                         Returns TRUE if a character is pending from DECtalk.J                         Note that this may be a keypad input character (asK                         entered by the user) or part of an escape sequence.   L                         dt_peek() does not flush pending output. It contains7                         operating-system specific code.                    note                344                  C                         This module contains specific code for UNIX C                         4.2BSD. The makefile for the library shoulda'                         #define BSD_42.                    bugs  +                         Tested only on VMS.                    #endif  &                 #include     <stdio.h>'                 #include     "dectlk.h"                    /*E                  * Define all DECtalk library globals in this module.)                  */                    #ifdef   unixo)                 #include        <errno.h>e                 #ifdef   BSD_42d-                 #include        <sys/types.h>e(                 #include        <time.h>                 #endifK                                                                        345d  ;                               int                   dt_peek(dt, sec)[                 register DECTALK           *dt;    /* DECtalk device                     */                  /*                  * UNIX.                  */                  { [                         register int   incount;      /* Count and error code             */                  #ifdef  BSD_42[                         auto long      pending;      /* Number pending                   */                  #elsen[                         register int   ecode;        /* For error handling               */f[                         extern int     errno;        /* System error value               */                  #endif                        346-  t                                       /*-                          * Anything buffered?                           */ G                         if (dt->pend_fc > 0 :: dt->in_ptr < dt->in_end) *                             return (TRUE);                 #ifdef BSD_42k                        /* 1                         * Works for 4.1 BSD, too.rE                         * Won't work for Unix V7 or system N (N >= 3)L                         */;                       ioctl(dt->unit, FIONREAD,  &pending);s*                       return(pending > 0);                   #elsee              K                                                                        347B  Y              @                       dt->in_ptr = dt->in_end = &dt->in_buff[0];R                       alarm(1);                       /* Start timeout          */R                       errno = 0;                      /* Clear error flag       */F                       incount = read(dt->unit, dt->in_buf, IN_BUFLEN);R                       ecode = errno;                  /* Save error code        */R                       alarm(0);                       /* Cancel timeout         */R                       if (incount < 0 && ecode == EINTR)  /* Did it timeout     */H                       return (FALSE);         /* Return failure       */R                       if (dt_abort :: incount <= 0    /* Other error            */R                           return (FALSE);             /* Return bad failure     */9                       dt->in_end = &dt->in_buff[incount];n$                       return (TRUE);                 #endif                 {                  #endif                      348                                   #ifdef  vms R                 #include      <sdef.h>                /* System status codes    */R                 #include      <iodef.h>               /* I/O request codes      */0                 typedef struct io_status_block {R                     short int   status;               /* I/O status code        */R                     short int   term_offset;          /* Datum size             */R                     short int   terminator;           /* Input terminator       */R                     short int   term_size;            /* Terminator size        */                 } IOSTAB;                       K                                                                        349                                   intd                 dt_peek(dt) R                 register DECTALK       *dt;           /* DECtalk device         */                 /*3                  * VMS: Fill the input buffer, too.                   */                  {p2                        register  int      incount;*                        struct type_ahead {5                            short       pending count;*7                            char        first_character; 5                            char        char-reserved; 5                            int         long_reserved;C$                        } type_ahead;S                        IOSTAB          status;        /* I/O status block        */                       350                  E                        if (dt->pend_fc > 0 :: dt->in_ptr < dt->in_end )                            return (TRUE); S                        incount = sys$qiow(1,   /* Event flag                     */pS                                dt->unit,       /* Input channel                  */ ?                                IO$_SENSEMODE : IO$M_TYPEAHDCNT,lS                                &status,        /* I/O status block               */ S                                NULL,           /* AST block (none)               */ S                                0,              /* AST parameter                  */ S                                &type_ahead     /* P1 - buffer                    */ S                                sizeof  type_ahead,  /* P2 - buffer length        */nS                                0,              /* P3 -                           */ S                                NULL,           /* P4 -                           */ S                                NULL,           /* P5 - ignored (prompt buffer)   */ S                                0);             /* P6 - ignored (prompt size)     */ V                        return (incount == SS$_NORMAL && type_ahead.pending_count > 0);                 }h                 #endif      K                                                                        351t  o                               #ifdef  rt11                 /*@                  *                              R  S  T  S  /  E                  */ '                 #include       <rsts.h>                    int                  dt_peek(dt) S                 register DECTALK          *dt;     /* DECtalk device             */                    /*T                  * RSTS/E: Fill the input buffer, return the next (first) character.                  */3                 { S                         register int    incount;      /* Count and error code    */C                        352   c              G                         if (dt->pend_fc > 0 :: dt->in_ptr < dt->in_end)f*                             return (TRUE);                         /*4                          * We must refill the buffer                          */ B                         dt->in_ptr = dt->in_end = &dt->in_buff[0];!                         clrxrb();NT                         xrb.xrlen = 4;                   /* No delimiter          */0                         xrb.xrci = dt->unit * 2;,                         xrb.xrblkm = TTYHND;&                         rstsys(_SPEC);!                         clrxrb(); T                         xrb.xrlen = 3;                   /* No echo               */0                         xrb.xrci = dt->unit * 2;,                         xrb.xrblkm = TTYHND;&                         rstsys(_SPEC);@                         incount = rs_read(dt->unit, dt->in_buff,6                             IN_BUFLEN, 0, 0, 0, 8192);1                         if (incount == -(HNGTTY)) +                             return (FALSE);tK                                                                        353T                 .                         else if (incount <= 0)+                             return (FALSE);_;                         dt->in_end = &dt->in_buff[incount];u&                         return (TRUE);                 }                  #endif                   #ifdef  rsxd                 /*4                  * Load in RSX specific information:5                  *      cx.h            common header B                  *      qiofun.h        I/O service function codesJ                  *      qioret.h        I/O service error and status codesK                  *      qiottd.h        Terminal I/O service bits and bytes E                  *      lunbuf.h        Device characteristics buffert                  */3                      354                  #                 #include     <cx.h>r'                 #include     <qiofun.h>l'                 #include     <qioret.h>u'                 #include     <qiottd.h>g'                 #include     <lunbuf.h>,  T                 #define QIO_EFN 1                          /* I/O event flag      */T                 #define MKT_EFN 2                          /* Time event flag     */T                 #static char    gmcbuf[2] = { TC_TBF };    /* get typeahead count */D                 #static QIOPARM gmcparm = { gmcbuf, sizeof gmcbuf };T                 #static int     termtable[16];             /* Terminator bitmask  */                    K                                                                        355                                   int)                 dt_peek(dt)rT                 register DECTALK         *dt;              /* DECtalk device      */                 /*                  * RSX:r                  */d                 { T                          register int     incount;       /* Count and error code  */T                          register char    *ip;           /* To copy to rsx buff   */4                          int              errorcode;                          /* >                           * Return buffered character (if any)                           */H                          if (dt->pend_fc > 0 :: dt->in_ptr < dt->in_end)*                             return (TRUE);                           /*5                           * We must refill the buffer                            */B                          dt->in_ptr = dt->in_ptr < dt->in_buff[0];*                          if (dt->pos_xk) {            356                                                /* O                               * The PRO-350 XK: port is actually pretty simple.                                 */;                              dt->parm.buffer = dt->in_buff; 7                              dt->parm.size = IN_BUFLEN; T                              dt->parm.p3 = 0;                    /* No timeout    */Q                              errorcode = qiow(IO_RLB : TF_TMO, dt->unit, QIO_EFN, =                                  &dt->iosb, NULL, &dt->parm); @                              if ((incount = fixiosb(dt)) == 0) {0                                  return (FALSE);                              }@                              dt->in_end = &dt->in_buff[incount];+                              return (TRUE);                           }                          else {                               /* @                               * Check whether anything is in the9                               * system type-ahead buffer.                                 */G                             errorcode = qiow(SF_GMC, dt->unit, QIO_EFN, K                                                                        357                  ;                                 &dt->iosb, NULL, &gmcparm);(J                             return (errorcode == IS_SUC & gmcbuf [1] > 0);                          }                 }                  static int                 fixiosb(dt) P                 register DECTALK       *dt;      /* DECtalk device            */                 /*@                  * This routine returns the correct input count.'                  * The code is unusual.                   *9                  * fixiosb() returns the true byte count.i                  */                  {s1                         extern int        $$ferr;   9                         if (dt->iosb.terminator != NUL) {                              /*                  358                  C                              * Append the terminator to the buffer.                               */ N                             dt->in_buff[dt->iosb.count] = dt->iosb.terminator;-                             dt->iosb.count++;                          }s$                         if (dt_abort5                          :: dt->iosb.status == IE_ABO 2                          :: dt->iosb.count == 0) {P                             return (0);                    /* Read aborted    */                         } :                         else if (dt->iosb.status != IS_SUC=                               && dt->iosb.status != IS_TMO) {e5                             $$ferr = dt->iosb.status; P                             return (0);                    /* I/O error       */                         } 0                         return (dt->iosb.count);                 }                  #endif    K                                                                        359                                 DTPESC.C  G               This routine compiles an appropriate escape sequence from #               the parameter buffer.                    /*)LIBRARY                  */   %                 #ifdef  DOCUMENTATION_  @                 title   dt_pesc         Transmit Escape SequenceC                 index                      Transmit escape sequencel                   synopsis  5                         #include            <stdio.h>h6                         #include            "dectlk.h"  (                         dt_pesc(dt, seq)O                         DECTALK             *dt;    /* Device descriptor     */ O                         SEQUENCE            *seq;   /* What to transmit      */                    description               360                  G                         Compile an appropriate escape sequence from thebF                         parameter buffer. this is similar to putchar()F                         except when seq->state is ESC, CSI, or DCS. InJ                         these cases, the function generates an appropriateJ                         sequence from the passed data structure. dt_pesc()G                         calls the user-supplied dt_put() to output each*"                         character.  H                         C1 control sequences are sent in their eight-bitE                         form if _FLAG_EIGHTBIT is set in dt->flag. If F                         this bit is off, they are sent in theri <ESC>XL                         form. If the application program sets _FLAG_EIGHTBITD                         it must also ensure that the operting systemC                         transmits eight data bits, and that DECtalk 7                         was setup as HOST FORMAT EIGHT.   -                         No value is returned.r                 #endif(                 #include       <stdio.h>)                 #include       "dectlk.h":  K                                                                        3613                                   dt_pesc(dt, seq)R                 register DECTALK        *dt;    /* Dectalk device               */R                 register SEQUENCE       *seq;   /* Sequence buffer              */                 /*R                  * Output the character (in seq->state) and maybe a sequence, too.                  */h                 { R                         register unsigned i;    /* Index into inter[], param[]. */R                         unsigned        max;    /* max for inter[] and param[]. */                                  362/                                   #ifdef  DT_DEBUG'                         if (dt_debug) {N.                             printf("put: \"");7                             if (isatty(fileno(stdout)))r/                                 fflush(stdout);                          }                  #endif'                         i = seq->state;m<                         if ((dt->flag & _FLAG_EIGHTBIT) == 05                          && i >= 0x80 && i <= 0x9F) {                              /*K                              * Output is in 7-bit mode and the character is B                              * a C1 control character. Convert it.                              */ ,                             dt_put(dt, ESC);1                             dt_put(dt, i - 0x40);                          }S                         else {                             /*J                              * Not the special case; output the character.K                                                                        363   *                                            */ *                             dt_put(dt, i);                         }f$                         switch (i) {!                         case ESC: !                         case CSI:c!                         case DCS:d                             /*P                              * Here is a sequence. Output all of its components.                              *5                              * First, the parameters. =                              *  i       counts the parameterslA                              *  max     stores the parameter max.eH                              *  val     working copy of parameter value.                              */ 2                             if (seq->private != 0)9                                 dt_put(dt, seq->private);t0                             max = seq->param[0];1                             if (max > SEQ_PARMAX) R                                 max = SEQ_PARMAX;      /* Too many, use limit   */            364e  a              8                             for (i = 1; i <= max; i++) {*                                 if (i > 1)4                                     dt_put(dt, ';');8                                  if (seq->param[i] != 0)?                                      intout(dt, seq->param[i]);                              }                              /*4                              * Output intermediates.=                              *  i       counts intermediates. >                              * max stores the number to output                              */ 0                             max = seq->inter[0];1                             if (max > SEQ_INTMAX)eV                                 max = SEQ_INTMAX;          /* Too many, use limit   */4                             for (i = 1; i <= max;) {<                                 dt_put(dt, seq->inter[i++]);                             }:[                             dt_put(dt, seq->final);            /* Output the final       */ "                             break;  K                                                                        365u  a              !                          default:t#                              break;                           }!                 #ifdef   DT_DEBUG;&                          if (dt_debug)+                              print("\"\n");                  #endif                 }t                 #ifndef  INT_32                  #ifdef   vax                 #define  INT_32                  #endif                   #ifdef   M68000m                 #define  INT_32                  #endif                 #endif                    366   d              +                 static unsigned power10[] =                  { /*,                    * Powers of 10 for intout                    */                  #ifdef   INT_32                      10000000,                       1000000,                        100000,                  #endif                        10000,                          1000,                           100,                            10,                             1,                  };  J                 #define NPOWERS ((sizeof power10)  /  (sizeof (unsigned)))        K                                                                        367                                   static!                 intout(dt, value) O                 DECTALK                *dt;     /* DECtalk device            */ O                 register unsigned      value;   /* Value to convert          */                  /*K                  * Convert an unsigned number to ASCII and call dt_put() on K                  * each character.  Note, as implemented here, a zero value ,                  * does not output anything.                  */                  { 7                        register unsigned        *power; 9                        int                      out_char;b8                        int                      nonzero;                          368t  t              Q                        power = power10;         /* Pointer to power table      */ Q                        nonzero = FALSE;         /* Don't output leading zeros  */                         do {t                            /*NG                             * Loop until all places except digits place -                             * have been done.m                             */J                            for (out_char = 0; value >= *power; out_char++)Q                                value -= *power;        /* Subtract a power     */ 9                            if (nonzero :: out_char > 0) {mQ                                nonzero = TRUE;         /* Not leading zero     */ :                                dt_put(dt, out_char + '0');                            }=                        } while (++power < &power10[NPOWERS]);                  }           K                                                                        369                                 DTPHON.C  9               This routine sends a DECtalk phone message.                    /*)LIBRARY                  */   %                 #ifdef  DOCUMENTATION   <                 title   dt_phone        Send a Phone Message<                 index                   Send a phone message                   synopsis  1                         #include        <stdio.h> 2                         #include        "dectlk.h"                           int(,                         dt_phone(dt, p3, p4)K                         DECTALK         *dt;    /* Device descriptor     */ K                         int             p3;     /* P3_PH_xxxx parameter  */pK                         int             p4;     /* timeout or rings      */-                   description             370=  o              J                         This routine (which may be implemented as a macro)M                         sends a DECtalk phone message (i.e., the p2 parameter %                         is P2_PHONE).   M                         p3 and p4 should be given as -1 if no parameter is to                           be sent.  G                         It then reads the status reply and returns TRUE F                         if the r1 and r2 parameters are R1_DECTALK andF                         R2_PHONE respectively. The application programK                         should then test for offhook/onhook as appropriate.   Q                         Returns TRUE if successful. If FALSE, something is funny.                    #endif  %                 #include    <stdio.h> &                 #include    "dectlk.h"  !                 #ifdef   dt_phoner!                 #undef   dt_phone                  #endif  K                                                                        371n  D                               int $                 dt_phone(dt, p3, p4)K                 register DECTALK    *dt;     /* Device descriptor        */p'                 int                 p3;h'                 int                 p4;e                 /*(                  * Send a phone message.                  */Y                 {/L                         return (dt_msg(dt, P2_PHONE, p3, p4, R2_PHONE, -1));                 }                               372                                 DTPTES.C  /               This routine tests a phone reply.                    /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   8                 title   dt_ptest        Test Phone Reply8                 index                   Test phone reply                   synopsis  1                         #include        <stdio.h> 2                         #include        "dectlk.h"                           int (                         dt_ptest(dt, r3)K                         DECTALK         *dt;    /* Device descriptor     */ K                         int             *r3;    /* R3_PH_xxxx parameter  */                    descriptiono  K                                                                        373u  p              J                         This routine (which may be implemented as a macro)K                         is used to test the result of a dt_phone() message. A                         The parameter is a R3_PH_... reply value. I                         It returns TRUE if the current reply is a DECtalk D                         phone reply with the specified R3 parameter.                   #endif  +                 #include          <stdio.h>e,                 #include          "dectlk.h"  "                 #ifdef    dt_ptest"                 #undef    dt_ptest                 #endif                            374                                   int                   dt_ptest(dt, r3)O                 register DECTALK      *dt;     /* Device descriptor          */                  intu                 /*(                  * Test a phone message.                  */                  { ;                         return (dt_test(dt, R2_PHONE, r3));                  }(                 DTPUT.C   F               This routine sends one character to the DECtalk terminal)               line. No value is returned.U            K                                                                        375c  t                               /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   F                 title   dt_put          Write one Character to DECtalkF                 index                   Write one character to DECtalk                   synopsis  1                         #include        <stdio.h> 2                         #include        "dectlk.h"  %                         dt_put(dt, c)-K                         DECTALK         *dt;    /* Device descriptor     *//K                         int             c;      /* Character to write    */i                   description   N                         One character is written to the DECtalk terminal line.-                         No value is returned.                   376O  u              L                         If DT_DEBUG is #defined when the library is compiledF                         and the global dt_debug is set nonzero (by the;                         application program), the character0H                         written is logged to the standard output device.                   #endif  (                 #include       <stdio.h>)                 #include       "dectlk.h"=                   #ifdef   dt_put                  #undef   dt_put;                 #endif                   dt_put(dt, c) P                 register DECTALK       *dt;      /* Device descriptor         */P                 register int           c;        /* Character to write        */                 {u0                         extern int     dt_debug;      K                                                                        377                  (                         dt_ioput(dt, c);                  #ifdef  DT_DEBUG*                         if (dt_debug != 0)0                             dt_dchar(c, stdout);                 #endif                 }                  DTREAD.C  9               This routine reads a sequence or character.                    /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   B                 title   dt_read         Read Sequence or CharacterB                 index                   Read sequence or character                   synopsis  1                         #include        <stdio.h>02                         #include        "dectlk.h"            3780                                          int (                         dt_read(dt, sec)K                         DECTALK         *dt;    /* Device descriptor     */ K                         char            *sec;   /* O.S. timeout value    */i                   descriptiong  K                         Read an escape sequence or keypad character. Ignore H                         any characters between the DECtalk final and theG                         string terminator. Return the character read ora0                         the sequence introducer.                 #endif  &                 #include     <stdio.h>'                 #include     "dectlk.h"               K                                                                        379s  p                               int                   dt_read(dt, sec)O                 register DECTALK       *dt;    /* Dectalk device             */nO                 int                    sec;    /* Operating system timeout   */b                 { ,                        register int    code;)                        register int    i;                           /*=O                         * Read another sequence (or continue reading this one).eQ                         * Copy the sequence read into the working "reply" buffer.tM                         * Note, this code is not quite general enough for allpJ                         * escape sequence parsing. Specifically, it cannotK                         * properly deal with C0 control characters embedded L                         * inside of escape sequences (as is necessary if theM                         * operating system cannot process XOFF/XON controls).u                         */                    380o  T              *                         dt->seq.state = 0;B                 again:  dt->reply.state = code = dt_gesc(dt, sec);'                         switch (code) {o!                         case CAN: !                         case SUB: '                             go to again                           case ESC                          case CSI                          case DCS<                             dt->reply.final = dt->seq.final;A                             dt->reply. private = dt->seq.private; C                             for (i = 0; i <= dt->seq.inter[0]; ++i)nF                                 dt->reply.inter[i] = dt->seq.inter[i];C                             for (i = 0; i <= dt->seq.param[0]; ++i) F                                 dt->reply.param[i] = dt->seq.param[i];"                             break;        K                                                                        381                                            default:A                             dt->reply.final = dt->reply.private = H                             dt->reply.inter[0] = dt->reply.param[0] = 0;"                             break;                         }e5                         if (dt->reply.state == DCS) {                              /*C                              * Ignore test between DCS final and ST                               */d.                             dt->seq.state = 0;                              do {6                                 code = dt_gesc(dt, 1);>                             } while (code > 0 && code < 0x80);                         }d1                         return (dt->reply.state);e                 }m                    382   u                             DTRESE.C  >               This routine sends a soft-reset escape sequence.                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATIONd  :                 title   dt_reset        DECtalk Soft Reset:                 index                   DECtalk soft reset                   synopsis  0                        #include        <stdio.h>1                        #include        "dectlk.h"   #                        dt_reset(dt),J                        DECTALK         *dt;    /* Device descriptor     */                   description   ;                        Send a "soft reset" escape sequence. .                        No errors are possible.  K                                                                        383   u                               #endif  %                 #include    <stdio.h> &                 #include    "dectlk.h"  .                 static SEQUENCE soft_reset = {2                     CSI, 'p', 0, { 0 }, { 1, '!' }                 };                   dt_reset(dt)*                 register DECTALK      *dt;                 /*A                  * dt_reset() sends a soft-reset escape sequence.p                  */                  { 0                        dt_pesc(dt, &soft_reset);U                        dt->flag := _FLAG_SPEAK;                 /* Speaking now    */ U                        dt->timeout = 0;                         /* No timeout now  */c                 }                   384   n                             DTSAVE.C  <               This routine saves user type-ahead characters.                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   <                 title   dt_save         Save User Type-ahead<                 index                   Save user type-ahead                   synopsis  1                         #include        <stdio.h> 2                         #include        "dectlk.h"                           int &                         dt_save(dt, c)K                         DECTALK         *dt;    /* Device descriptor     */ K                         char            c;      /* character to save     */                    description   K                                                                        385   4              B                         If c is a keypad character, save it in theF                         type-ahead buffer and return TRUE, else return                         FALSE.  E                         If the current reply is a timeout and nothing D                         is stored in the type-ahead buffer, save 'T'E                         and clear the timeout flag. This is necessary @                         as a timeout sequence may be returned in?                         the middle of a message/reply sequence.   H                         This routine should not be called by application!                         programs.Y                   #endif  (                 #include       <stdio.h>)                 #include       "dectlk.h"n                      386                                   intt                 dt_save(dt, c)T                 register DECTALK        *dt;      /* Dectalk device               */T                 int                     c;        /* Character to test            */                 { T                        register int     timeout;          /* Current value        */                            K                                                                        387                  T                        if (!dt_isvalid(c)) {              /* Not a keypad button? */T                            if (!dt_istimeout(dt))         /* If it isn't timeout, */T                                return (FALSE);            /* it's not for us.     */T                            else {                         /* Timeout is funny     */!                                /* K                                 * Ignore timeout if timer is set to zero or P                                 * something is already in the type-ahead buffer."                                 */T                                timeout = dt->timeout;     /* Get old value        */T                                dt->timeout = 0;           /* Clear timer          */@                                if (timeout == 0 :: dt_iskey(dt))T                                    return (TRUE);         /* Toss it away         */T                                c = 'T'                    /* Save it in typeahead */                            }                        }T                        if (dt->pend_fc < PEND_SIZE) {     /* Save it if there's   */T                            dt->pend_fc++;                 /* enough room, else    */T                            dt->pend[dt->pend_fp] = c;     /* throw it away.       */:                            if (++dt->pend_fp >= PEND_SIZE)/                                dt->pend_fp = 0;             388                                          }%                        return (TRUE);t                 }c                 DTSPLICE.C  C               This routine lets you control a terminal connected to #               DECtalk's local port.o                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   =                 title   dt_splice       Manage Local Terminalh=                 index                   Manage Local Terminal                    synopsis  1                         #include        <stdio.h> 2                         #include        "dectlk.h"    K                                                                        389a                 +                         dt_splice(dt, flag))K                         DECTALK         *dt;    /* Device descriptor     */dK                         int             flag;   /* Required state        */.                   description   B                         dt_splice() allows control over a terminalD                         connected to DECtalk's local port. Note thatG                         the terminal must correctly process ANSI escape C                         sequences. Specifically, it must ignore any C                         escape sequence that it doesn't understand.   A                         The flag parameter may have the following -                         (bit-encoded) values.   B                           SPLICE_SPEAK      Speak subsequent text,E                                             if set. Do not speak text G                                             if not set. Initially zero.n                    390                  H                           SPLICE_LOG        Text sent to DECtalk is sentF                                             (in raw mode) to the localF                                             terminal if set. Initially4                                             not set.  C                           SPLICE_TERM       Text typed on the localUG                                             terminal is sent to DECtalkeF                                             if set. Initially not set.  R                         The bits would normally be set and cleared in combination.$                         For example:  8                             dt_splice(dt, SPLICE_SPEAK);  P                         Speak text, don't log it, ignore text typed on the host.  D                             dt_splice(dt, SPLICE_LOG : SPLICE_TERM);  N                         Stop speaking text, transmit text from/to the attached!                         terminal.                  #endif    K                                                                        391i  F              )                 #include        <stdio.h> *                 #include        "dectlk.h"  #                 dt_splice(dt, flag)f,                 register DECTALK        *dt;-                 register int            flag;t                 /*,                  * Manage line-splice modes.                  */l                 { D                         splice(dt, flag & SPLICE_SPEAK, _FLAG_SPEAK,=                                                 P2_SPEAK, 1);iB                         splice(dt, flag & SPLICE_LOG,   _FLAG_LOG,E                                                 P2_LOG, LOG_RAWHOST); C                         splice(dt, flag & SPLICE_TERM,  _FLAG_TERM, H                                                 P2_TERMINAL, TERM_HOST);                 }i                    392   *                               static-                 splice(dt, flag, bit, p2, p3)h,                 register DECTALK        *dt;O                 int                     flag;       /* TRUE to set bit       */uO                 int                     bit;        /* dt->flag bit to do    */d>                 int                     p2, p3;     /* For DCS                 /*P                  * Do the dt_splice() work. If dt->flag doesn't agree with flag,1                  * send the appropriate dt_dcs().n                  */                  { D                        if (((dt->flag & bit) != 0) != (flag != 0)) {P                            if (flag != 0) {            /* Turn mode on,       */P                                dt->flag := bit;        /* Set flag bit and    */P                                dt_dcs(dt, p2, p3, -1); /* Sends the p2/p3     */                            }P                            else {                      /* Turn mode off,      */P                                dt->flag &= ~bit;       /* Clear flag bit and  */P                                dt_dcs(dt, p2, 0, -1);  /* Send "mode off"     */                            }K                                                                        393                                          }                 }r                 DTST.C  E               This routine sends a string terminator to DECtalk. This I               string terminates phonemic text or telephone dial commands.d                   /*)LIBRARY                 */%                 #ifdef  DOCUMENTATION   >                 title   dt_st           Send String Terminator>                 index                   Send string terminator                   synopsis  0                         #include       <stdio.h>1                         #include       "dectlk.h"                            int !                         dt_st(dt) H                         DECTALK       *dt;    /* Device descriptor    */            394x                                  descriptionk  J                         This routine sends a string terminator to DECtalk.N                         this is needed to terminate phonemic text or telephone&                         dial commands.  J                         A phonemic text sequence would be sent as follows.  0                              dt_cmd(dt, p2, p3);6                              dt_talk(dt, "hh'ehlow.");'                              dt_st(dt);                    #endif  &                 #include     <stdio.h>'                 #include     "dectlk.h"   5                 static SEQUENCE string_terminator = {q                     ST                 };      K                                                                        395                                   dt_st(dt) Q                 DECTALK                 *dt;           /* Device descriptor    */l                 /*+                  * Send a string terminatoru                  */t                 { 8                         dt_pesc(dt, &string_terminator);                 }                  DTSYNC.C  E               This routine synchronizes the application with DECtalk.                    /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION   @                 title   dt_sync         Synchronize with DECtalk@                 index                   Synchronize with DECtalk                   synopsis              396   ;              1                        #include         <stdio.h> 2                        #include         "dectlk.h"                          int"                        dt_sync(dt)K                        DECTALK          *dt;    /* Device descriptor     */                    description   I                         The program delays until all text sent to DECtalk (                         has been spoken.  Q                         Returns TRUE is successful. If FALSE, something is funny.                    #endif  (                 #include       <stdio.h>)                 #include       "dectlk.h"           K                                                                        397t                                  int                  dt_sync(dt)hR                 register DECTALK        *dt;    /* Device descriptor            */                 /*;                  * Synchronize DECtalk and the application.                   */                  {=R                         dt_dcs(dt, P2_SYNC, -1, -1);     /* Synchronize         */R                         dt->flag := _FLAG_SPEAK;         /* Now speaking        */R                         return (dt_msg(dt, P2_IX_QUERY, -1, -1, R2_IX_QUERY, -1));                 }h                              398}                                DTTALK.C  3               This routine speaks one line of text.i                   /*)LIBRARY                 */  (                 #ifdef     DOCUMENTATION  A                 title      dt_talk         Speak One Line of TexttA                 index                      Speak one line of textp                   synopsis  4                            #include        <stdio.h>5                            #include        "dectlk.h"   ,                            dt_talk(dt, text)N                            DECTALK         *dt;    /* Device descriptor     */N                            char            *text;  /* What to say           */                   description   I                            This function sends a line of text to DECtalk.   K                                                                        399T  i              G                            dt_talk(dt, NULL) flushes DECtalk by sending 3                            a vertical-tab sequence.                    #endif  )                 #include        <stdio.h> *                 #include        "dectlk.h"  5                 static char     vtline[] = { VT, 0 };L  !                 dt_talk(dt, text)rM                 register DECTALK         *dt;   /* Device descriptor       */ M                 register char            *text; /* Text pointer            */l                 { )                         if (text == NULL) *                             text = vtline;*                         while (*text != 0)/                            dt_put(dt, *text++);u#                         dt_eol(dt);n                 }                 400c  h                             DTTEST.C  1               This routine tests a DECtalk reply.w                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATIONE  <                 title   dt_test         Test a DECtalk Reply<                 index                   Test a DECtalk reply                   synopsis  1                         #include        <stdio.h> 2                         #include        "dectlk.h"                           inte+                         dt_test(dt, r2, r3) K                         DECTALK         *dt;    /* Device descriptor     */mK                         int             r2;     /* R2_xxx parameter      */ K                         int             r3;     /* R3_xxx parameter      */                    description K                                                                        401   f              H                         This routine checks the last reply received fromI                         DECtalk against the model. r3 is -1 to ignore it. I                         It returns TRUE if the reply is a properly parsedaH                         DECtalk reply sequence, or FALSE on any failure.                   #endif  )                 #include        <stdio.h> *                 #include        "dectlk.h"                                    402   m                               int #                 dt_test(dt, r2, r3) N                 register DECTALK        *dt;   /* Device descriptor         */+                 int                     r2;e+                 int                     r3;c                 /*D                  * Test the current returned sequence for the proper8                  * DECtalk reply. r3 is -1 to ignore it.                  */e                 { 2                         if (dt->reply.state == DCS=                           && dt->reply.final == DCS_F_DECTALK 4                           && dt->reply.inter[0] == 06                           && dt->reply.private == 0) {@                             if (dt->reply.param[1] == R1_DECTALK8                              && dt->reply.param[2] == r2G                              && (r3 == -1 :: dt->reply.param[3] == r3))R.                                 return (TRUE);                        }&                        return (FALSE);K                                                                        403                                   }                  DTTIME.C  H               This routine enables or disables telephone keypad timeout.                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATIONr  H                 title   dt_timeout      Enable or Disable Keypad TimeoutH                 index                   Enable or disable keypad timeout                   synopsis  1                         #include        <stdio.h>d2                         #include        "dectlk.h"                           int +                         dt_timeout(dt, sec) K                         DECTALK         *dt;    /* Device descriptor     */ K                         int             sec;    /* Timeout in seconds    */               404                                   description   F                         If sec is nonzero, timeouts are being enabled;9                         if zero, they are being disabled.   J                         Enable keypad timeouts if sec is nonzero and thereI                         is no data in the type-ahead buffer (and timeouts 1                         are not already enabled).   M                         Disable timeouts if they are enabled and sec is zero,hH                         or any data is in the type-ahead buffer (even if(                         sec is nonzero).  J                         Before enabling timeouts, DECtalk is synchronized.  K                         Returns TRUE if successful. If FALSE, the telephonen.                         may have been hung up.                   #endif  )                 #include        <stdio.h> *                 #include        "dectlk.h"    K                                                                        405                                   int #                 dt_timeout(dt, sec) O                 register DECTALK        *dt;     /* Device descriptor        /*eO                 register int            sec;     /* Timeout in sec seconds   /*E                 /*E                  * Enable or disable timeout. No errors are possible. F                  * Note that timeout(dt, 15) looks at the state of theD                  * type-ahead buffer before deciding whether to turn6                  * timeouts on, off, or to do nothing.                  */;                 { T                         if (sec != 0) {                 /* If enabling,           */T                             if (dt_iskey(dt))           /* Disable if typeahead   */(                                 sec = 0;T                             if (sec != 0) {             /* Still enabling?        */T                                 dt_sync(dt);            /* Synchronize and        */T                                 if (dt_iskey(dt))       /* check again.           */,                                     sec = 0;                             }                          }             406s  n              T                         if (dt->timeout == sec)         /* Don't set to the       */T                             return (TRUE);              /* same value             */9                         dt_phone(dt, P3_PH_TIMEOUT, sec);d*                         dt->timeout = sec;<                         if (dt_onhook(dt) :: dt_offhook(dt))*                             return (TRUE);&                         return (FALSE)                 }r                 DTTONE.C  F               This routine sends the msg test string as a tone dialing               sequence.                    /*  %                 #ifdef  DOCUMENTATION   7                 title   dt_tone         Send DTMF Tones 7                 index                   Send DTMF tonesb                   synopsis  K                                                                        407                  1                         #include        <stdio.h>r2                         #include        "dectlk.h"                           inti(                         dt_tone(dt, msg)K                         DECTALK         *dt;    /* Device descriptor     */ K                         char            *msg;   /* Announcement          */                    description   H                         This routine sends the msg text string as a toneF                         dialing sequence. If the telephone was on-hookE                         when dttone() was called, it will be returned D                         to the on-hook condition. Note, this routineF                         may not work to your satisfaction in countriesF                         which require automatic annnouncement messagesG                         on automatically dialed calls. See your DECtalkdA                         programmer's manual for more information.e                    408                  I                         For message text may contain any valid touch-tonetI                         characters ("0123456789*#ABCD") or the characters I                         '!' (for a one second delay) or the '^' for a 250 K                         millisecond switch-hook flash. All other characters $                         are ignored.  J                         Note that the telephone will not be hung up beforeL                         dialing if it is offhook when the command is issued.                   #endif  )                 #include        <stdio.h> *                 #include        "dectlk.h"                  K                                                                        409e  q                               int $                 dt_tone(dt, message)R                 register DECTALK        *dt;           /* Device descriptor     */R                 char                    *message;      /* Announcement          */                 /*                  * Send tones                   */                  {s.                         register int    state;-                         register int    code;l                                410                  -                         dt_phone(dt, -1, -1);t.                         state = dt_onhook(dt);9                         dt_cmd(dt, P2_PHONE, P3_PH_TONE); -                         dt_talk(dt, message);e"                         dt_st(dt);                         do {3                             code = dt_read(dt, 30); B                         } while (code == ST :: dt_save(dt, code));#                         if  (state).+                              dt_hangup(dt);                  }i                  K                                                                        411                                 DTTRAP.C  3               This routine traps CTRL-C interrupts.                    /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATION[  @                 title   dt_trap         Trap <CTRL-C> Interrupts@                 index                   Trap <CTRL-C> Interrupts                   synopsis  1                         #include        <stdio.h> 2                         #include        "dectlk.h"                           dt_trap.                   description                     412                  F                         Set the global dt_abort flag if the user typesC                         <CTRL-C> at the command terminal. (On UNIX,*E                         this is interpreted as catching the INTERRUPTdF                         signal, which is not necessarily <CTRL-C>, andD                         which may be generated by running the "kill"'                         system program.   C                         When the interrupt is received, pending I/O F                         is cancelled (on those operating systems where*                         this makes sense).  O                         If dt_abort is set TRUE when the interrupt is received, +                         the program aborts.   -                         No error is returned.l                   #endif  )                 #include        <stdio.h> *                 #include        "dectlk.h"                   #ifdef  unix*                 #include        <signal.h>K                                                                        413,                                  static                 catch()o                 { %                         if (dt_abort) %                             _exit(2);n(                         dt_abort = TRUE;                 }                    dt_trap()                  /**                  * Trap CTRL-C interrupts.                  */                  {c.                         signal(SIGINT, catch);/                         signal(SIGTERM, catch);t                 }                  #endif                   #ifdef  vms )                 #include        <ssdef.h> *                 #include        <signal.h>            414                                   static                 catch()                  {   5                          register DECTALK        *dt;o  &                          if (dt_abort).                              _exit(SS$_ABORT);)                          dt_abort = TRUE;tF                          for (dt = dt_root; dt != NULL; dt = dt->link)2                              sys$cancel(dt->unit);                 }                    dt_trap()s                 /**                  * Trap CTRL-C interrupts.                  */                  { .                         signal(SIGINT, catch);                 }                  #endif  K                                                                        415                                   #ifdef  rsxh&                 #include        <cx.h>*                 #include        <qiofun.h>*                 #include        <qioret.h>*                 #include        <qiottd.h>!                 #define QIO_EFN 1                    static                 catch()a                 {*2                         register DECTALK      *dt;                                416                  X                         astset();                       /* AST entry                  */%                         if (dt_abort)b%                             $$fail(); (                         dt_abort = TRUE;                         /*7                          * Kill all pending DECtalk I/Os                          */fG                         for (dt = dt_root; dt != NULL; dt = dt->link) { ;                             qiow(IO_KIL, dt->unit, QIO_EFN, <                                 &dt->iosb, NULL, &dt->parm);                         } Y                         astx(1);                        /* AST exit                    */                  } ;                 static QIOPARM astparm = { NULL, 0, catch};             K                                                                        417                                   dt_trap()r                 /**                  * Trap CTRL-C interrupts.                  */                  {y<                        qiow(IO_ATA, fileno(stderr), QIO_EFN,1                            NULL, NULL, &astparm);                  }                  #endif                 #ifdef   rt11                                 418                                   static                 catch()=                 /*F                  * Executed by the operating system if an interrupt is                  * detected.                  */                  { &                          if (dt_abort)&                              $$fail();)                          dt_abort = TRUE;                  }                    dt_trap()4                 /**                  * Trap CTRL-C interrupts.                  */n                 { %                         setcc(catch);(                 }                  #endif  K                                                                        419                                 DTVISI.C  H               This routine generates a visible ASCII representation of a2               character stored in the work buffer.                   /*)LIBRARY                 */  %                 #ifdef  DOCUMENTATIONm  G                 title   dt_visible      Generate Visible Representation G                 index                   Generate visible representation                    synopsis  J                         char            work[12]  /* Output buffer      */                           char  * +                         dt_visible(c, work) J                         int             c;        /* Character to dump  */J                         char            work[]    /* Work buffer        */                   description               420s                 G                         A visible ASCII representation of the character F                         is stored in the work buffer. A pointer to the=                         end of the output string is returned.i  H                         Note that this routine is independent of DECtalkL                         definitions (except that it knows about the DT_ERROR4                         and DT_TIMEOUT error codes).                   #endif  )                 #include        <stdio.h>a*                 #include        "dectlk.h"                    K                                                                        421   a                               char   *%                 dt_visible(c, buffer)rT                 register int    c;              /* Character to convert           */T                 register char   *buffr;         /* Where to store conversion      */                 /*4                  * Make a character "visible" ASCII.8                  * Return a pointer to the trailing EOS.                  */                  {t-                         register int    flag;   $                         switch (c) {!                         case NUL:n4                             strcpy(buffer, "<NUL>");"                             break;  &                         case DT_ERROR:6                             strcpy(buffer, "<ERROR>");"                             break;                422                  (                         case DT_TIMEOUT:8                             strcpy(buffer, "<TIMEOUT>");"                             break;  !                         case ESC: 4                             strcpy(buffer, "<ESC>");"                             break;  !                         case DCS: 4                             strcpy(buffer, "<DCS>");"                             break;  !                         case CSI:i4                             strcpy(buffer, "<CSI>");"                             break;              K                                                                        423                                            case ST:3                             strcpy(buffer, "<ST>"); "                             break;                          default:-                             flag = (c >= 0x7F H                                 :: (c < ' ' && c != '\n' && c != '\r'));%                             if (flag) 0                                 *buffer++ = '<';6                             if ((c &= 0xFF) >= 0x80) {*                                 c -= 0x80;0                                 *buffer++ = '~';                             } 2                             if (flag && c < ' ') {0                                 *buffer++ = '^';3                                 *buffer++ = c + 64;                              } C                             else if (flag :: c == '\n' :: c >= ' ')r.                                 *buffer++ = c;%                             if (flag) 0                                 *buffer++ = '>';            424"                 *                             *buffer = EOS;,                             return (buffer);                          }:                          return (buffer + strlen(buffer));                 }-                 HELLO.Cl  I               This is a very simple test program, to show that DECtalk isE"               operating correctly.                   /*)BUILD1                         $(INCLUDE) = { dectlk.h }e<                         $(RTLIB) = { dtlib,c:rstslb,c:clib }>                         $(RXLIB) = { dtlib/lb,c:cx/lb,c:c/lb }                   /*          K                                                                        425                  "                 #include <stdio.h>#                 #include "dectlk.h"r                 #ifdef  vms 0                 extern int                errno;/                 #define  IO_ERROR         errno                  #endif                 #ifdef   unix +                 #define  IO_ERROR         1                  #endif                   DECTALK *dt;                    main(argc, argv)%                 int             argc; (                 char            *argv[];                 {c/                         char              *dev;                     426(  a              &                         dev = "ttg7:";%                         if (argc > 1) *                             dev = argv[1];:                         if ((dt = dt_open(dev)) == NULL) {(                             perror(dev);;                             printf("Can't open DECtalk\n"); +                             exit(IO_ERROR);                          { R                         dt_debug = TRUE;                /* Log text             */R                         dt_trap();                      /* CTRL-C trap enabled  */1                         printf("calling init\n"); )                         if (!dt_init(dt)) ?                             printf("Can't initiate DECtalk\n");_                         else {4                             printf("Initialized\n");A                             dt_dcs(dt, P2_MODE, MODE_SQUARE, -1);L8                             dt_talk(dt, "Hello world.");(                             dt_sync(dt);>                             dt_dump("after sync", &dt->reply);)                             dt_close(dt); K                                                                        427                  1                             printf("Success.\n");                          }                  }               1       BASIC-PLUSf$                    PROGRAM EXAMPLE 7  C               This chapter provides the source listings of a simpleiH               DECtalk telephone answering program, written in BASIC-PLUSI               for RSTS/E. You can copy and use this program; however, theaD               program is only a model, and cannot cover all possible#               DECtalk applications.                               428                                 RSTS/E SYSTEMS  A               On some RSTS/E systems, you may need system managertA               privileges to run this program. Please refer to the >               appropriate RSTS/E manuals for more information.              10    EXTENDEP            20    !*                                                            &P                  !* DECtalk function library and a sample application.         &P                  !* The function library generally duplicated the C            &P                  !* library, with some minor simplifications.                  &                  !* P                  !* The sample program reads a string of numbers from          &P                  !* the keypad and speaks them as a number, and as a           &P                  !* string of digits. The '*' key functions as a dollar        &P                  !* sign, and the '#' key functions as a decimal point.        &P                  !* The program also illustrates how an application            &P                  !* might manage keypad timeouts.                              &P                  !*                                                            &    K                                                                        429                  P            100   !*                                                            &P                  !* Defaults                                                   &P                  !*                                                            &  P                  DEF.kb$ = "KB2:"                  ! DECtalk device            &P                  \ DEF.log$ = "yes"                ! Assume log?               &P            1000  !*                                                            &P                  !* Main program                                               &P                  !*                                                            &P                  !* Initialize DECtalk and start the DEMO                      &P                  !* Channel 1     Console keyboard for parameters              &P                  !* Channel 2     Log file                                     &                              430h                 P            1010  open "kb:" for input as file 1%                               &P                  \ kb$ = FNprompt$("Dectalk terminal", DEF.kb$)                &P                  \ DT.log% = (FNyesno%("Enable logging", DEF.log%))            &P                  \ debug% = FNyesno%("Enable debug printouts", "yes")          &P                  \ retries%, ncalls% = 0%        ! Clear counters              &P                  \ error.count% = 0%             ! No errors yet               &P                  \ if (debug% or DT.log%) then   ! Need a log file.            &P                      logfile$ = FNprompt$("Debug log file", "kb:"              &P                      \ open logfile$ for output as file 2%                     &  P            1100  while (FNinit%(kb$))            ! Initialize DECtalk          &P                      \ q% = FNlog%("Initialization")                           &P                      \ retries% = retries% + 1%  ! Count initializations       &P                      \ while (FNanswer%)         ! Answer the phone            &P                          \ if (FNprocess%) then  ! Do this call                &P                              ncalls% = ncalls% + 1%      ! Got a call          &P                              \ retries% = 0%             ! Clear retry         &        K                                                                        431   l              P            1200          goto 1800 if (debug% and error.count% > 0%)           &P                          \ if (retries% > 2%) then       ! Trouble?            &P                              q% = FNlog%("Too many retries")                   &P                              \ goto 1800                 ! Fatal.              &  P            1300      next                        ! For all calls               &P                  \ next                          ! For all restarts            &  P            1800  q% = FNlog%("finished after " + num1$(ncalls%))               &P                  \ close 2% if DT.log%                                         &  P            1900  goto 32767                      ! All done                    &  P            2000  def* FNprocess%                                               &P                  !                                                             &P                  !       F N p r o c e s s %                                   &P                  !                                                             &P                  ! User process. Read a number from the keypad and             &P                  ! speak it out. Return when phone is to be hung up.           &P                  ! Return TRUE% if ok, FALSE% on error.                        &P                  !                                                             &              432   u              P            2010  FNprocess% = FALSE%             ! Assume failure              &P                  \ nkeys% = 0%                   ! Count button presses        &P                  \ q% = FNlog%("answered")                                     &P                  \ q% = FNspeak%("[:np :ra 180] Welcome to DECtalk.")          &P                  \ q% = FNspeak%("It is now " + time$(0%)                      &P                          + " on " + date$(0%) + ".")                           &P                  \ q% = FNspeak%("Enter a number, the star key means")         &P                  \ q% = FNspeak%("dollar sign, while the number-sign")         &P                  \ q% = FNspeak%("key means decimal point.")                   &P                  \ if (not FNphone%("20")) then  ! turn the keypad on          &P                      q% = FNlog%("error enabling keypad")                      &P                      \ goto 2080                 ! Error exit                  &P            2020  if (not FNptest%(R3.PH.OFFHOOK%)) then                        &P                      q% = FNlog%("enable keypad, state: " + num1$(R3%))        &P                      \ goto 2080                   ! Error exit                &          K                                                                        433r  i              P            2030  while TRUE%                       ! For all numbers           &P                      \ timer% = 10%                ! For first character       &P                      \ work$ = ""                  ! Input buffer              &P                      \ while TRUE%                 ! Get the number            &P                          \ c% = FNkey%(timer%)     ! Read a character          &P                          \ c$ = chr$(c%)           ! Get both flavors          &P                          \ goto 2080 if c$ = 'H'   ! Hangup                    &P                          \ goto 2080 if c$ = 'E'   ! Error from RSTS/E         &P                          \ goto 2080 if c$ = 'X'   ! Escape sequence error     &P                          \ goto 2080 if c$ = 'T'   ! Timeout                   &P                          \ c$ = '$'  if c$ = '*'   ! Fix funny                 &P                          \ c$ = '.'  if c$ = '#'   ! buttons                   &P                          \ work$ = work$ + c$      ! Stuff it                  &P                          \ timer% = 2%             ! Short prompt now          &P                      \ next                        ! Read a number loop        &                      434                  P            2050      goto 2060 if (works$ = "")   ! Did we read anything?      &P                      \ q% = FNspeak%("You entered " + work$ + ".")             &P                      \ q% = FNspeak%("that is" + FNexpand$(work$) + ".")       &P                  \ next                            ! Read all numbers          &  P            2060  FNprocess% = TRUE%                ! Normal completion         &  P            2080  q% = FNphone%("21")               ! Turn off keypad           &P                  \ q% = FNhangup%                  ! And hang up the phone     &P                  \ q% = FNlog%("process exit after " + num1$(nkeys%))          &  N            2090  fnend                                                       &                    K                                                                        435w  h              N            3000  !*                                                          &N                  !*             F N e x p a n d $ ( t e x t $ )              &N                  !*                                                          &N                  !* Expand a number string into its component bytes.         &N                  !* Note that this would be useful in a "bank by phone"      &N                  !* application to speak a number, digit by digit, so        &N                  !* the caller could copy it down. If the input is           &N                  !* "12.3", the output will be " 1 2 point 3". Note          &N                  !* the leading blank.                                       &N                  !*                                                          &N                  def* FNexpand$(text$)                                       &N                  \ q$ = ""                                                   &N                  \ for q% = 1% to len(text$)             ! Output work       &N                      \ q1$ = mid(text$, q%, 1%)          ! For each byte     &N                      \ q1$ = "point" if q1$ = '.'        ! Locate it         &N                      \ q1$ = "minus" if q1$ = '_'        ! Fix the           &N                      \ q1$ = "dollar sign" if q1$ = '$'  !   special         &N                      \ q$ = q$ + " " + q1$               !      cases        &N                  \ next q%                               ! and stuff it      &N                  \ FNexpand$ = q$                        ! Do 'em all        &            436                  N                                                          ! That's it         &  N            3090  fnend                                                       &  N            10000   !*                                                        &N                    !* Basic-Plus Support functions for DECtalk               &N                    !* Note that the code is not particularly fast and some   &N                    !* of the error conditions that are handled by the C      &N                    !* version of the Escape Sequence parser are ignored.     &                        K                                                                        437                  N                    !*                                                        &N                    ! Note: the following channels are used:                  &N                    !         8      DECtalk input                            &N                    !         9      DECtalk output                           &N                    !         2      Log file                                 &N                    !                If DT.log% is TRUE, a log file is open   &N                                     on channel 2                             &N                    !*                                                        &N                    !* Application programs call the following routines       &N                    !*                                                        &N                    ! FNinit%(kb$)          Initialize DECtalk on kb:         &N                    ! FNanswer%             Finish last call, answer next     &N                    ! FNhangup%             Hangup the call                   &N                    ! FNkey%(timeout%)      Read a character with timeout     &N                    !                       Returns the character, or         &N                    !                         E     Error (from RSTS)         &N                    !                         H     Phone hung up             &N                    !                         T     Timeout                   &N                    !                         X     Bad Escape sequence       &N                    ! FNtimeout%(sec%)      Set specified timeout, 0 = none   &            438T  b              N                    ! FNtest%(R2%, R3%)     Test current reply, true if ok    &N                    !                         R3% is -1 to ignore it.         &N                    !                         FNtest%() checks character,     &N                    !                         intermediates, and finals       &N                    ! FNptest%(R3%)         Test phone reply (R2% checked)    &N                    ! FNsend%(text$)        Send text to DECtalk.             &N                    ! FNspeak%(text$)       Send text followed by <CR><LF>    &N                    ! FNlog%(text$)         Log text message                  &N                    ! FNvisible$(char%)     Make character printable for      &N                    !                         logging and debugging msgs.     &N                    ! FNmessage%(text$, R2%, R3%)                             &N                    !                       Send DCS seq. test reply.         &N                    !                         text is "P2;P3..."              &N                    !                         return TRUE if ok.              &N                    !                         Note: FNmessage%() ignores      &N                    !                         R3.PH.TIMEOUT replies.          &N                    ! FNphone%(text$)       Send DCS sequence, test reply     &N                    !                         text is "P3;P4..."              &N                    !                         R2% must be R2.PHONE%           &N                    !                         R3% not tested                  &K                                                                        439                  N                    !                         FNfunny% called if error        &N                    !                         returns as FNmessage%()         &N                    ! FNfunny%(text$)       Print bad sequence on the log     &N                    ! FNdump%(text$)        Dump the current reply            &N            10010   !*                                                        &N                    !* The application program generally doesn't call the     &N                    !* following routines.                                    &N                    !*                                                        &N                    ! FNsave%(char)         Save type-ahead character,        &N                    !                         return TRUE if saved.           &N                    ! FNdcs%(text$)         Send DECtalk DCS message          &N                    !                         text is "P2;P3...",             &N                    ! FNcsi%(text$)         Send DECtalk CSI message          &N                    !                         text has parm, inter, final.    &N                    ! FNfromdectalk%(time%) Read key or escape sequence.      &N                    ! FNgetseq%(time%)      Read key or escape sequence.      &N                    ! FNget%(timeout%)      Read one character.               &N                    !                         parity is stripped.             &N                    !                         <NUL> and <DEL> are ignored.    &N                    !                         Return 0% on timeout.           &            440$  '              N                    !                         Other errors are fatal.         &N                    !                       NOTE: do nt use fnget%() to       &N                    !                       read from the telephone keypad.   &N                    ! FNread%(timeout%)     Read a record from DECtalk        &N                    !                                                         &N                    !*                                                        &N                    !* Globals:                                               &N                    !*                                                        &N                    ! R1%, R2%, R3% current reply parameters                  &N                    !               set by FNgetsequence%()                   &N                    ! DT.timeout%   TRUE if keypad timeouts are               &N                    !               currently enabled.                        &N                    ! error.count%  Incremented on serious errors             &N                    ! ESC%          ESC character (parity bit cleared)        &N                    ! CAN%          CTRL-U character (cancel sequence)        &N                    ! SUB%          CTRL-Z character                          &N                    ! CSI%          CSI character                             &N                    ! DCS%          DCS character                             &N                    ! ST%           ST character                              &N                    ! ESC$          An escape to send chr$(155%)              &K                                                                        441   a              N                    ! CRLF$         Carriage-return, Line-feed                &N                    ! VT$           Vertical Tab (DECtalk flush)              &N                    ! R2.PHONE%       R2% phone reply                         &N                    ! R3.PH.ONHOOK    R3% (phone hung up)                     &N                    ! R3.PH.OFFHOOK   R3% (phone is alive)                    &N                    ! R3.PH.TIMEOUT%  R3% (keypad timeout)                    &N                    !                                                         &N                    ! DT.anything   reserved for local buffers                &N                    ! SEQ.anything  reserved for sequence parser              &N                    ! q[anything]   general temporaries                       &N                    !                                                         &N            10100   ! def*  FNinit%(kb$)                                      &N                    !                                                         &N                    ! F N i n i t % ( k b $ )                                 &N                    !                                                         &N                    ! Initialize the DECtalk device                           &N                    ! Return TRUE% if ok, FALSE% if error                     &N                    !                                                         &                442                  N            10110   !*                                                        &N                    !* Open the terminal in "binary" mode.                    &N                    !* Then initialize all constants.                         &N                    !*                                                        &N                    open kb$ for input as file 8%, mode 32%+16%+4%+1%         &N                    \ open kb$ for input as file 9%, mode 32%++16%+4%=1%      &N                    \ DT.incount%, DT.inend% = 0%   ! Clear input buffer      &N                    \ SEQ.state% = 0%               ! Clear input state       &N                    \ DIM DT.p%(3), SEQ.p%(3)       ! 3 parameters            &N                    \ DIM q%(256)                   ! For debugging           &N                    \ TRUE% = (1% = 1%)             ! TRUE                    &N                    \ FALSE% = not TRUE%            ! FALSE                   &N                    \ ESC% = 27%                    ! Escape                  &N                    \ ESC$ p chr$(ESC% + 128%)      ! Define escape char      &N                    \ VT$ = chr$(ascii('K') - 64%)  ! DECtalk flush char      &N                    \ CRLF$ = chr$(13%) + chr$(10%) ! <CR><LF> string         &N                    \ CAN% = ascii('U') - 64%)      ! CANcel (CTRL-U)         &N                    \ SUB% = ascii('Z') - 64%       ! SUBstitute (CTRL-Z)     &N                    \ CSI% = ascii('[') - 64% + 128%        ! Define          &N                    \ DCS% = ascii('P') - 64% + 128%        ! C1 control      &K                                                                        443y  f              N                    \ ST%  = ascii('\') - 64% + 128%        ! characters      &N                    \ R2.PHONE% = 70%                                         &N                    \ R3.PH.ONHOOK% = 0%                                      &N                    \ R3.PH.OFFHOOK% = 1%                                     &N                    \ R3.PH.TIMEOUT% = 2%                                     &  N            10120   q% = FNsend%(chr$(ascii('Q') - 64% + 128%)) ! CTRL-Q      &N                    \ q% = FNget%(2%) while (q% > 0%) ! Drain text            &N                    \ q% = FNdcs%("82")             ! No local->host          &N                    \ q% = FNcsi%("c")              ! "Who are you"           &N                    \ q% = FNfromdectalk%(5%)       ! Read escape sequence    &N                    \ if (DT.char%     <> CSI%      ! Check                   &N                       or DT.final$    <> 'c'       !   for                   &N                       or DT.private$  <> '?'       !     DECtalk             &N                       or R1%          <> 19%) then !       reply             &N                        q% = FNfunny%("initialization")                       &N                        \ FNinit% = FALSE%          ! Return failure          &N                        \ goto 10190                ! from Fninit%()          &                  444                  N            10130   q% = FNsend%(ESC$ + "!p")       ! Soft Terminal Reset     &N                    \ q% = FNdcs%("80;1")           ! Set MODE SQUARE         &N                    \ DT.timeout% = 0%              ! No timeouts now         &N                    \ FNinit% = TRUE%               ! Return TRUE             &  N            10190   fnend                                                     &  N            10200   def* FNanswer%                                            &N                    !                                                         &N                    !      F N a n s w e r %                                  &N                    ! Finish off any current call (hanging up the phone)      &N                    ! Then setup and answer the next call.                    &N                    ! Return TRUE% if the call was answered.                  &N                    ! Return FALSE% if there's serious problems.              &N                    !                                                         &  N            10210   FNanswer% = FALSE%                      ! Assume error    &N                    \ q% = FNget%(2%) while (q% > 0%)       ! Drain text      &N                    \ goto 10290 if (not FNphone%(""))      ! poll status     &N                    \ if (R3% = R3.PH.OFFHOOK%) then        ! if alive,       &N                        goto 10290 if (not fNhangup%)       ! hangup phone    &  K                                                                        445C  k              N            10220   if (R3% <> R3.PH.ONHOOK%) then          ! still alive?    &N                        q% = FNfunny%("hangup/poll")        ! Urk.            &N                        \ goto 10290                        ! exit this       &  N            10230   goto 10290 if (not FNphone%("10;1"))    ! answer 1 ring   &N                    \ if (R3% <> R3.PH.ONHOOK%) then        ! ok?             &N                        q% = FNfunny%("enable answer")      ! Urk.            &N                        \ goto 10290                        ! exit this       &  N            10240   q% = FNfromdectalk%(0%)                 ! wait for ring   &N                    \ if (q% <> DCS%) then                  ! ok?             &N                        q% = FNfunny%("waiting for ring")   ! oops.           &N                        \ goto 10290                        ! exit this       &  N            10250   if (not FNptest%(R3.PH.OFFHOOK%)) then                    &N                        q% = FNfunny%("expecting offhook")                    &N                        \ goto 10290                                          &  N            10260   DT.timeout% = 0%                 ! No timeouts now        &N                    \ DT.pending$ = ""               ! Nothing pending now    &N                    \ FNanswer% = TRUE%              ! ok.                    &              4464                 N            10290   fnend                                                     &  N            10300   def* FNtimeout%(seconds%)                                 &N                    !                                                         &N                    !     F N t i m e o u t % ( s e c o n d s % )             &N                    !                                                         &N                    ! Enable or disable keypad timeout. Note that             &N                    ! FNtimeout%(non-zero%) will examine the state of the     &N                    ! type-ahead buffer before actually enabling timeouts     &N                    !                                                         &                      K                                                                        447                  N            10310   if (seconds% > 0%) then                                   &N                        seconds% = 0% if (len(DT.pending$)  >  0%)            &N                        \ if (seconds% > 0%) then                             &N                            q% = FNsync%          ! make sure all heard       &N                            \ seconds% = 0% if (len(DT.pending$) > 0%)        &N                        ! If the pro0gram requests that timeouts be turned    &N                        ! on, perform some special checks that the user       &N                        ! hasn't already entered any text (which would be     &N                        ! stored in one of the type-ahead buffers. If         &N                        ! something is pending, turn timeouts off. This is    &M                        ! needed because RSTS allows a program to run even   & N                        ! if all output has been sent to the device.          &  N            10320   goto 10390 if (seconds% = DT.timeout%)  !  Don't resend   &N                    \ print #2%, "timeouts set"; seconds% if (DT.log%)        &N                    \ q% = FNphone%("30;" + num1$(seconds%))                  &  N            10330   fnend                                                     &                  448                  N            10400   def* FNsync%                                              &N                    !                                                         &N                    !      F N s y n c %                                      &N                    !                                                         &N                    ! Synchronize with DECtalk. This function returns         &N                    ! when all text sent to DECtalk has been spoken.          &N                    ! Warning: if you have sent much text to DECtalk and      &N                    ! the moon is in the wrong phase, there is a very         &N                    ! slight chance that this code could get an operating     &N                    ! system timeout, even though there are no errors.        &N                    !                                                         &  N            10410   q% = FNsend%(VT$)               ! Flush speech            &N                    \ q% = FNdcs%("11")             ! Send sync               &N                    \ if (not FNmessage%("22", 32, -1)) then                  &N                        q% = FNfunny%("sync")                                 &  N            10490   fnend                                                     &      K                                                                        449&                 N            10500   def* FNhangup%                                            &N                    !                                                         &N                    !     F N h a n g u p %                                   &N                    !                                                         &N                    ! Hangup the telephone. Returns when the phone is         &N                    ! properly on-hook (TRUE%) or an error is detected.       &N                    !                                                         &  N            10510   FNhangup% = FALSE%              ! Assume problems         &N                    \ goto 10590 if (not FNphone%(""))    ! send hangup       &N                    \ while (R3% = R3.PH.OFFHOOK%)  ! wait until              &N                        \ sleep 5%                  ! it's hung up            &N                        \ goto 10590 if (not FNphone%(""))                    &N                    \ next                          ! loop forever            &N                    \ FNhangup% = TRUE%             ! OK now.                 &  N            10590   fnend                                                     &                    450e  (              N            10600   def* FNphone%(text$)                                      &N                    !                                                         &N                    !     F N p h o n e % ( t e x t $ )                       &N                    !                                                         &N                    ! Send a phone message, return the FNmessage% code.       &N                    ! You should then call FNtest% to see just what the       &N                    ! phone state actually is.                                &N                    !                                                         &  N            10610   if (text$ <> "")                ! If extra parameters     &N                        then text$ = "60;" + text$  ! tack them on, else      &N                        else text$ = "60"           ! just do status report   &  N            10620   FNphone% = FNmessage%(text$, R2.PHONE%, -1%)              &  N            10690   fnend                                                     &            K                                                                        451\  .              N            10700   def* FNsave%(char%)                                       &N                    !                                                         &N                    !      F N s a v e % ( c h a r % )                        &N                    !                                                         &N                    ! If the char% came from a user data entry, save it in    &N                    ! the DT.pending$ buffer and return TRUE%, otherwise,     &N                    ! return FALSE%. note that FNsave%() watches for          &N                    ! asynchronous keypad timeouts.                           &N                    !                                                         &N                    ! Note that unreasonable amounts of type-ahead may        &N                    ! cause the program to overflow memory.                   &N                    !                                                         &  N            10710   FNsave% = TRUE%                                           &N                    \ if FNptest%(R3.PH>TIMEOUT%) then      ! Timeout?        &N                        goto 10790 if (DT.timeout% = 0%)    ! Disabled?       &N                        \ DT.timeout% = 0%                  ! None now        &N                        \ goto 10790 if (len(DT.pending$) > 0%)               &N                        \ char% = ascii('T')                ! Save 'T'        &                452"  g              N            10720   if (instr(0%, "0123456789*#ABCDT", chr$char%)) = 0%)      &N                        then FNsave% = FALSE%                                 &N                        else DT.pending$ = DT.pending$ + chr$(char%)          &              10790   fnend  N            10800   def* FNkey%(timeout%)                                     &N                    !                                                         &N                    !      F N k e y % ( t i m e o u t % )                    &N                    !                                                         &N                    ! Read a keypad character (in there is one in the         &N                    ! type-ahead buffer, or read a character or escape        &N                    ! sequence from DECtalk. The timeout% parameter is        &N                    ! non-zero to enable timeouts.                            &N                    !                                                         &N                    ! Note that the timeout parameter, if non-zero, will be   &N                    ! extended to compensate for RSTS/E output buffering.     &N                    !                                                         &N                    ! FNkey% ignores user timeout if timeout was disabled.    &N                    !                                                         &  K                                                                        453                  N            10810   q% = FNtimeout%(timeout%)        ! Set/clear  timeouts    &N                    \ if (len(DT.pending$ > 0%) then                          &N                        FNkey% = ascii(DT.pending$)                           &N                       \ DT.pending$ = right(DT.pending$, 2%)                 &N                       \ goto 10890                                           &  N            10820   timeout% = (timeout% * 4%) + 60% if timeout% > 0%         &N                    \ q% = FNfromdectalk%(timeout%)                           &N                    \ q% = ascii('T')            if FNptest%(R3.PH.TIMEOUT%)  &N                    \ DT.timeout% = 0%           if (q% = ascii('T'))         &N                    \ q% = ascii('H')            if FNptest%(R3.PH.ONHOOK%)   &N                    \ q% = ascii('E')            if (q% <= 0%) ! O.S. error   &N                    \ FNkey% = q%                                             &  N            10890   fnend                                                     &                        454   a              N            12000   def* FNmessage%(text$, t2%, t3%)                          &N                    !                                                         &N                    ! F N m e s s a g e $ ( t e x t $ , t 2 % , t 3 %)        &N                    !                                                         &N                    ! Send a DECtalk DCS sequence to DECtalk and wait         &N                    ! for a reply. Make sure the reply matches the t2%        &N                    ! and t3% parameters. Return TRUE% if ok, else FALSE%.    &N                    !                                                         &N                    ! A keypad timeout (escape sequence) may be read when     &N                    ! we are expecting some other reply. In this case,        &N                    ! the timeout is ignored, the timeout status flag is      &N                    ! set FALSE and we read another sequence.                 &N                    !                                                         &  N            12010   q% = FNdcs%(text$)                ! Send the sequence     &N                    \ FNmessage% = TRUE%              ! Assume success        &          K                                                                        455                  N            12020   q% = FNfromdectalk%(60%)          ! get something         &N                    \ goto 12020 if (q% = ST%)        ! ignore string term.   &N                    \ goto 12020 if FNsave%(q%)       ! save type-ahead       &N                    \ if not (FNtest%(t2%, t3%)) then         \ Check seq.    &N                        q% = FNfunny%("message test error")                   &N                        \ FNmessage% = FALSE%                                 &  N            12090   fnend                                                     &  N            12100   def. FNfromdectalk%(timeout%)                             &N                    !                                                         &N                    !       F N f r o m d e c t a l k % ( t i m e o u t % )   &N                    !                                                         &N                    ! Read an escape sequence or keypad character. Dump       &N                    ! junk between DCS final and string terminator.           &N                    !                                                         &  N            12110   if (SEQ.state% <> 0% and SEQ.state% <> ST%) then          &N                        gosub 12200                   ! Grab the sequence     &N                        \ goto 12180                  ! And return char value &                456!                 N            12120   SEQ.state% = 0%                   ! Nothing pending now   &N                    \ q% = FNgetsequence%(timeout%)   ! Get something         &N                    \ gosub 12200                     ! Make it current       &N                    \ q% = FNtoss% if (q% = DCS%)     ! Toss junk until ST    &  N            12180   FNfromdectalk% = DT.char%         ! Return character      &  N            12190   fnend                                                     &  N            12200   !                                                         &N                    ! Subroutine called from FNfromdectalk% to copy the       &N                    ! last escape sequence read into the "current sequence"   &N                    ! buffer. This is needed to skip over junk between        &N                    ! the DCS fiunal and the string terminator.               &                K                                                                        457a  (              N            12210   DT.char% = SEQ.char%              ! Sequence type         &N                    \ DT.final$ = SEQ.final$          ! Sequence terminator   &N                    \ DT.private$ = SEQ.private$      ! private characters    &N                    \ DT.inter$ = SEQ.inter$          ! Intermediates         &N                    \ DT.parm% = SEQ.parm%            ! Parameter count       &N                    \ R1%, DT.p%(1%) = SEQ.p%(1%)     ! Param's               &N                    \ R2%, DT.p%(2%) = SEQ.p%(2%)     !                       &N                    \ R3%, DT.p%(3%) = SEQ.p%(3%)     !                       &N                    ! \ print #2%, dt.parm%; "parms: "; R1%; R2%; R3%         &              12290   return   N            12300   def* FNtoss%                                              &N                    !                                                         &N                    !      F N t o s s %                                      &N                    !                                                         &N                    ! Called after reading a DCS, this function reads         &N                    ! text to the terminating string terminator.              &  N            12310   SEQ.state% = 0%                                           &                458                  N            12320   q% = FNgetsequence%(5%)                                   &N                    \ if (q% <= 0% or (q% >= 128% and q% <= 159%))            &N                     then FNtoss% = q%                                        &N                     else goto 12320                                          &  N            12390   fnend                                                     &                              K                                                                        459                  N            13000   def* FNgetsequence%(timeout%)                             &N                    !                                                         &N                    !        F N g e t s e q u e n c e % ( t i m e o u t % )  &N                    !                                                         &N                    ! Read the next charcter or the next ANSI standard        &N                    ! Escape Sequence.                                        &N                    !                                                         &N                    ! Initialize by setting SEQ.state% to zero. Returns:      &N                    ! SEQ.state%            sequence final character          &N                    !                                                         &N                    ! Note the following goto's:                              &N                    ! goto 13010 to read the next character in a sequence.    &N                    ! goto 13020 to continue processing (needed when escape   &N                    !               followed by a second character turns      &N                    !               into a C1 control character).             &N                    ! goto 13120 to exit an ESC sequence                      &N                    ! goto 13130 to exit after reading a DCS/CSI sequence.    &N                    ! goto 13140 to exit a C0 control within a sequence.      &N                    !                                                         &N                    ! The following is set by this module:                    &            460                  N                    ! SEQ.char%     the character or sequence type            &N                    ! SEQ.final$    the sequence final for CSI/DCS/ESC        &N                    ! SEQ.state%    zero when sequence ends.                  &N                    ! SEQ.parm%     number of parameters                      &N                    ! SEQ.p%[]      each parameter as read                    &N                    ! SEQ.inter$    intermediates                             &N                    ! SEQ.private$  private introducer, 'X' if error seen     &N                    !                                                         &  N            13010   DT.c% = fnget%(timeout%)        ! Get a character         &  N            13020   if (DT.c% = ESC%                ! If the character        &N                     or DT.c% = CSI%                ! introduces a new        &N                     or DT.c% = DCS% then           ! sequence, initialize    &N                        SEQ.state% = DT.c%          ! all work areas.         &N                        ! \ print #2%, "seq start: "; fnvisible$(dt.c%)       &N                        \ SEQ.inter$ = ""                                     &N                        \ SEQ.private$ = ""                                   &N                        \ SEQ.parm% = 0%                                      &N                        \ SEQ.p%(1%), SEQ.p%(2%), SEQ.p%(3%) = 0%             &N                        \ goto 13010                ! go read another byte    &K                                                                        461                  N            13030   goto 13140 if (SEQ.state% = 0%) ! done if no sequence     &N                    !                                                         &N                    ! Continue processing the current sequence                &N                    !                                                         &N                    \ if ((DT.c% >= 128% and DT.c% < 160%)  ! C1 control      &N                       or (DT.c% = CAN%)            ! or CTRL-U               &N                       or (DT.c% = SUB%)            ! or CTRL-Z               &N                        SEQ.state% = 0%             ! force sequence exit     &N                        ! \ print #2%, "c0 control: "; fnvisible$(dt.c%)      &N                        ! goto 13140                ! and return C0 control   &  N            13040   goto 13140 if (DT.c% < 32%)     ! Exit if C0 control      &N                    !                                                         &N                    ! Process C1 introducers, intermediates, parameters,      &N                    ! sequence terminators and other strange stuff            &N                    !                                                         &N                    \ if (DT.c% < 48%) then         ! Intermediate            &N                        SEQ.inter$ = SEQ.inter$ + chr$(DT.c%)                 &N                        ! \ print #2%, "intermediate: "; fnvisible$(dt.c%)    &N                        \ goto 13020                ! Go get another          &              462)                 N            13050   if (SEQ.state% = ESC%) then     ! <ESC> -> C1 control?    &N                        q% = DT.c% < and 63%        ! Mask out lower 6 bits   &N                        \ goto 13130 if (SEQ.inter$ <> "" or q% >= 32%)       &N                        \ DT.c% = q% + 128%         ! Make it a C1 control    &N                        ! \ print #2%, "c0 -> c1: "; fnvisible$(dt.c%)        &N                        \ goto 13020                ! Process C1 control      &  N            13060   goto 13120 if (DT.c% >= 64%     ! Sequence terminator     &N                    ! \ print #2%, "not terminator" ; fnvisible$(dt.c%)       &N                    \ goto 13080 if (DT.c% < 60%)   ! private introducer?     &N                    ! \ print #2%, "private introducer"; fnvisible$(dt.c%)    &N                    \ if (SEQ.parm% > 0%)           ! maybe, but illegal      &N                            then SEQ.private$ = "X" ! after first param.      &N                            else SEQ.private$ = chr$(DT.c%)                   &N                               \ SEQ.parm% = 1%     ! Mark "param"            &  N            13070           goto 13010              ! Read another char.      &        K                                                                        463%  D              N            13080   !                                                         &N                    ! We know the character is in the range '0'..'9' or       &N                    ! ';' (separator) or ':' (illegal separator)              &N                    !                                                         &  N                    SEQ.parm% = 1% if (SEQ.parm% = 0%)                        &N                    ! \ print #2%, "param or sep: "; fnvisible$(dt.c%)        &N                    \ if (SEQ.inter$ <> "") then    ! No param's after        &N                       SEQ.inter$ = ""              ! intermediates.          &N                       \ SEQ.private$ = "X"         ! Mark it invalid.        &N                       !  \ print #2%, "parm or separator after inter"        &  N            13090   if (DT.c% <= ascii('9')) then   ! Parameter digit         &N                        SEQ.p%(SEQ.parm%) =         ! Make it a number        &N                          (SEQ.p%(SEQ.parm%) * 10%) + (DT.c% - ascii('0'))    &N                        ! \ print #2%, "digit, param :=" seq.p%(SEQ.parm%)    &N                        \ goto 13010                ! and read another byte   &  N            13100   if (DT.c% = ascii(';')) then    ! parameter separator     &N                        SEQ.parm% = SEQ.parm% + 1%                            &N                        \ goto 13010                ! and read another byte   &              4643                 N            13110   SEQ.private$ = "X"              ! ':' isn't a separator   &N                    ! \ print #2%, "bad separator"; fnvisible$(dt.c%)         &N                    \ goto 13010                    ! read another byte       &  N            13120   !                                                         &N                    ! Character is a sequence terminator. If no parameters    &N                    ! were read, return a single zero-valued parameter.       &N                    !                                                         &N                    SEQ.parm% = 1% if (SEQ.parm% = 0%)                        &N                    ! \ print #2%, "terminator: "; fnvisible$(dt.c%)          &  N            13130   !                                                         &N                    ! Jump here at the end of the sequence.                   &N                    !                                                         &N                    SEQ.final$ = chr$(DT.c%)        ! Set the final           &N                    \ DT.c% = SEQ.state%            ! Get return value        &N                    \ SEQ.state% = 0%               ! Not in a sequence       &  N            13140   SEQ.char% = DT.c%               ! Character code          &  N            13180   FNgetsequence% = SEQ.char%      ! Return value            &  K                                                                        465   t              N            13190   fnend                           ! That's all, folks       &  N            14100   def* FNsend%(text$)                                       &N                    !                                                         &N                    !     F N s e n d % ( t e x t $ )                         &N                    !                                                         &N                    ! Send a string of text to DECtalk. Note, the text        &N                    ! length must be less than the DECtalk terminal buffer    &N                    ! size.                                                   &N                    !                                                         &  N            14110   field #9%, len(text$) as q$                               &N                    \ lset q$ = text$                                         &N                    \ put #9%, record 4096%, count len(text$)                 &N                    \ if (debug% and DT.log%) then                            &N                        print #2%, using 'sent: ### "', len(text$);           &N                        \ change text$ to q%                                  &N                        \ print #2%, FNvisible$(q%(q%));                      &N                            for q% = 1% to q%(0%)                             &N                        \ print #2%, '"'                                      &              466z                 N            14190   fnend                                                     &  N            14200   def* FNcsi%(text$) = FNsend%(ESC$ + "[" + text$)          &N                    !                                                         &N                    !      F N c s i % ( t e x t $ )                          &N                    !                                                         &N                    ! Send a Control Sequence to DECtalk.                     &N                    !                                                         &  N            14300   def* FNdcs%(text$) =                                      &N                        FNsend%(ESC$ + "PO;" + text$ + "z" + ESC$ + "\")      &N                    !                                                         &N                    !      F N d c s % ( t e x t $ )                          &N                    ! Send a DECtalk Device Control Sequence.                 &N                    ! Note that the DECtalk P1 parameter, final, and          &N                    ! string terminator are automatically included.           &N                    !                                                         &        K                                                                        467                  N            14400   def* FNspeak%(text$) = FNsend%(text$ + CRLF$)             &N                    !                                                         &N                    !      F N l i n e % (t e x t $ )                         &N                    !                                                         &N                    ! Send a line of text to DECtalk, followed by <CR><LF>    &N                    !                                                         &  N            15000   def* FNget%(timeout%)                                     &N                    !                                                         &N                    !      F N g e t % ( t i m e o u t % )                    &N                    !                                                         &N                    ! Read the next character from DECtalk.                   &N                    ! timeout% =    0%      means none                        &N                    ! timeout% >    0%      wait timeout% seconds             &N                    ! timeout% =   -1%      return immediately if none        &N                    ! return 0% on timeout, fatal exit on other errors        &N                    ! The character is forced into the range 000 to 127       &N                    ! and <NUL> (000) and <DEL> (127) are ignored             &N                    !                                                         &                468                  N            15010   while (DT.incount% >= DT.inend%)         ! None saved?    &N                        \ goto 15080 if (not FNread%(timeout%))               &  N            15020   next                                                      &  N            15030   field #8%, DT.incount% as q$, 1% as q$   ! get char       &N                    \ DT.incount% = DT.incount% + 1%         ! step index     &N                    \ q% = ascii(q$) and 127%                ! drop parity    &N                    \ goto 15010 if (q% = 0% or q% = 127%)   ! ignore nulls   &N                    \ FNget% = q%                            ! return char    &N                    \ goto 15090                             ! exit           &  N            15080   FNget% = 0%                              ! got timeout    &  N            15090   fnend                                                     &              K                                                                        469                  N            15100   def* FNread%(timeout%)                                    &N                    !                                                         &N                    !      F N r e a d % ( t i m e o u t % )                  &N                    !                                                         &N                    ! Read a record from DECtalk.                             &N                    ! timeout% =    0%      means none                        &N                    ! timeout% >    0%      wait timeout% seconds             &N                    ! timeout% =   -1%      return immediately if none        &N                    ! return FALSE% on timeout, fatal exit on other errors    &N                    ! return TRUE% on success.                                &N                    !                                                         &                              4706                 N            15110    goto 15120 if DT.incount% < DT.inend%    ! Still stuff   &N                     \ on error goto 15150                    ! grab error    &N                     \ q$ = sys(chr$(3%) + chr$(9%))          ! no echo       &N                         + sys(chr$(4%) + chr$(9%))           ! odt mode      &N                    \ wait timeout% if timeout% > 0%          ! timeout       &N                    \ get #8% if timeout% >= 0%               ! read buffer   &N                    \ get #8%, record 8192% if timeout% < 0%                  &N                    \ DT.inend% = recount                     ! got it        &N                    \ wait 0%                                 ! no timeout    &N                    \ DT.incount% = 0%                        ! clear index   &N                    \ on error goto 19000                     ! common exit   &N                    \ if (debug% and DT.log%) then                            &N                        print #2%, using "read: ### '", DT.inend%;            &N                        \ field #8%, DT.inend% as q$                          &N                        \ change q$ to q%                                     &N                        \ print #2%, FNvisible$(q%(q%));                      &N                            for q% = 1% to q%(0%)                             &N                        \ print #2%, "'"                                      &    K                                                                        471                  N            15120   FNread% = TRUE%                                           &N                    \ goto 15190                                              &  N            15150   resume 15180                                              &N                      if ((err = 15% and timeout% > 0%)                       &N                       or (err = 13% and timeout% < 0%))                      &N                    \ goto 19000                                              &  N            15180   FNread% = FALSE%                                          &  N            15190   fnend                                                     &                                472                  N            16000   def* FNtest%(t2%, t3%) =                                  &N                            (DT.char% = DCS%)       ! Make                    &N                        and (DT.final$ = 'z')       !   sure                  &N                        and (len(DT.inter$) = 0%)   !     it's                &N                        and (len(DT.private$) = 0%) !       from              &N                        and (R1% = 0%)              !         DECtalk         &N                        and (t2% = R2%)             ! Check R2%               &N                        and (t3% = R3% or t3% = -1%) ! maybe check R3%        &N                    !                                                         &N                    !       F N t e s t % ( t 2 % , t 3 % )                   &N                    !                                                         &N                    ! Return TRUE% if the current reply is a properly-        &N                    ! formed DECtalk reply sequence whose R2% and R3%         &N                    ! parameters match T2% and T3%. T3% is ignored if         &N                    ! it is -1%.                                              &N                    !                                                         &  N            16100   def* FNptest%(t3%) =            ! Test phone reply        &N                        FNtest%(R2.PHONE%, t3%)                               &    K                                                                        473w                 N                    !      F N p t e s t % ( t 3 % )                          &N                    !                                                         &N                    ! Return TRUE% if the current reply R2% parameter         &N                    ! is R2.PHONE% and the T3% matches R3%                    &N                    !                                                         &  N            17000   def* FNfunny%(text%)                                      &N                    !                                                         &N                    !      F N f u n n y % ( t e x t $ )                      &N                    !                                                         &N                    ! Log an error message and dump the current reply.        &N                    !                                                         &  N            17010   error.count% = error.count% + 1%                          &N                    \ if (DT.log%) then                                       &N                        print #2% if (ccpos(2%) <> 0%)                        &N                        \ print #2%, "Illegal reply at "; text$; "."          &N                        \ FNfunny% = FNdump%("")                              &  N            17090   fnend                                                     &              474                  N            17100   def* FNdump%(text$)                                       &N                    !                                                         &N                    !      F N d u m p % ( t e x t $ )                        &N                    !                                                         &N                    ! Dump the current reply.                                 &N                    !                                                         &                            K                                                                        475                  N            17110   if (DT.log%) then                                         &N                        print #2%, "Last sequence read";                      &N                        \ print #2%, " at "; text$; if (text$ <> "")          &N                        \ print #2%, ": ";                                    &N                        \ if (DT.char% = 0%)                                  &N                            then print #2%, "<TIMEOUT>"                       &N                            else print #2%, FNvisible$(DT.char%);             &N                                \ print #2%, DT.private$; DT.inter$;          &N                                \ for q% = 1% to DT.parm%                     &N                                    \ print #2%, num1$(DT.p%(q%));            &N                                        if (DT.p%(q%) <> 0%)                  &N                                    \ print #2%, ";";                         &N                                        if ((q% + 1%) < DT.parm%)             &N                                \ next q%                                     &N                                \ print #2%, DT.final$;                       &N                                \ print #2%, "<ST>"; if (DT.char% = DCS%)     &N                                \ print #2%                                   &  N            17190   fnend                                                     &                476&                 N            17200   def* FNvisible$(c%)                                       &N                    !                                                         &N                    !       F N v i s i b l e $ ( c % )                       &N                    !                                                         &N                    ! Return "datascope" version of c%                        &N                    !                                                         &                            K                                                                        477                  N            17210   if (c% = ESC%)          then FNvisible$ = "<ESC>"         &N                    else if (c% = DCS%)     then FNvisible$ = "<DCS>"         &N                    else if (c% = CSI%)     then FNvisible$ = "<CSI>"         &N                    else if (c% = ST%)      then FNvisible$ = "<ST>"          &N                    else if (c% = 10%)      then FNvisible$ = CRLF$           &N                    else if (c% = 11%)      then FNvisible$ = "<VT>"          &N                    else if (c% = 13%)      then FNvisible$ = ""              &N                    else q.vis% = (c% >= 127% or c% < 32%)                    &N                        \ q$ = ""                                             &N                        \ q$ = "<~" if (c% >= 128%)                           &N                        \ q$ = "<"  if (c% <   32%)                           &N                        \ q$ = c% and 127%                                    &N                        \ q$ = q$ + "^" + chr$(c% + 64%) if (c% < 32%)        &N                        \ q$ = q$ + chr$(c%) if (c% >= 32%)                   &N                        \ q$ = q$ + ">" if q.vis%                             &N                        \ FNvisible$ = q$                                     &  N            17290   fnend                                                     &  N            17300   def* FNlog%(text$)                                        &              478                  N                    !                                                         &N                    ! F N l o g % ( t e x t $ )                               &N                    !                                                         &N                    ! Log a text message                                      &N                    !                                                         &  N            17310   if (DT.log%) then                                         &N                        print #2%, date$(0%); " "; time$(0%); " "; text$      &  N            17390   fnend                                                     &  N            17400   def* FNyesno%(prompt$, default$)                          &N                    !                                                         &N                    ! F N y e s n o % ( p r o m p t $ , d e f a u l t $ )     &N                    !                                                         &N                    ! Prompt and get a yes/no answer                          &N                    !                                                         &          K                                                                        479                  N            17410   q% = 0%                                                   &N                    \ until (q% = 1% or q% = 5%)                              &N                        \ q$ = FNprompt$(prompt$ + "(Yes/No)", default$)      &N                        \ q% = instr(1%, "YES NO", cvt$$(q$, -1%))            &N                    \ next                                                    &N                    \ fnyesno% = (q% = 1%)                                    &  N            17490   fnend                                                     &  4            17500   def* FNprompt$(prompt$, default$)N                    !                                                         &N                    ! F N p r o m p t % ( p r o m p t $ , d e f a u l t $ )   &N                    !                                                         &N                    ! Prompt and get a response                               &N                    !                                                         &  N            17510   print #1%, prompt$; "<"; default$; ">? ";                 &N                    \ input line #1%, q$                                      &N                    \ FNprompt$, q$ = cvt$$(q$, 397%)                         &N                    \ FNprompt$ = cvt$$(default$, 397%) fi len(q$) = 0%       &              17590   fnend            480                  N            19000   !                                                         &N                    !        F a t a l  E r r o r  T r a p                    &N                    !                                                         &  N            19010   error% = err                   ! save error number        &N                    \ error.line% = erl            ! and error line           &N                    \ resume 19100                 ! and take fatal exit      &  N            19100   print                          ! force new line           &N                    \ print 'Fatal Error "';       ! print error message      &N                        cvt$$(right(sys(chr$(6%) + chr$(9%)                   &N                            + chr$(error%)), 3%), 4%);                        &  N            19180   stop                                                      &              19190   goto 32767\              32767   end          K                                                                        481                  -            1       DECtalk ESCAPE SEQUENCES A4  F               This appendix summarizes the escape sequences (and theirH               parameters) described in this manual. The following tables<               list escape sequence mnemonics and their ASCII               representations.  I               You can verify each ASCII character by checking the decimalT5               value that appears below the character.   %            Table A-1  Escape Commands   +                             Escape Sequence )            Mnemonic         Decimal ValueT  -            DA Primary       ESC   [    0    cs  .                             027  091  048  099                  482   \              -            Table A-1 (Cont.)  Escape Commands   +                             Escape Sequenced)            Mnemonic         Decimal Value I                             Request DECtalk to identify itself. See Table *                             A-2 for reply.  (            DECAC1           ESC  SP    7  )                             027  032  055e  G                             Select 8-bit C1 control character receptionf8                             (accept the high-order bit).  -            DECSTR           ESC   [    !    p   .                             027  091  033  112        K                                                                        483                  -            Table A-1 (Cont.)  Escape Commands"  +                             Escape Sequence )            Mnemonic         Decimal Valuee4                             Reset to power-up state.  '            DECTC1           ESC  SP   6n  )                             027  032  054   G                             Select 7-bit C1 control character reception :                             (truncate the high-order bit).  5            DECTST           ESC   [    5    ;  Pn   y   8                             027  091  053  059  ***  121                      484n  i              -            Table A-1 (Cont.)  Escape Commands   +                             Escape Sequence )            Mnemonic         Decimal Value H                             Initiate local self-tests. See Table A-6 for*                             Pn parameters.  -            DSR Brief        ESC   [    5    na  .                             027  091  053  110  I                             Give a brief status report. See Table A-2 forS$                             replies.  (            DSR EXtended     ESC   [    n  )                             027  091  110         K                                                                        485                  -            Table A-1 (Cont.)  Escape Commands   +                             Escape Sequence )            Mnemonic         Decimal Value F                             Give an extended device status report. See2                             Table A-2 for replies.  J            DT_DICT          ESC   P    0   ;    4   0    z name sub ESC  \  P                             027  080  048  059  052  048 122 ....   ... 027  092  C                             Load user dictionary. See Table A-2 for $                             replies.  N            DT_INDEX         ESC   P   0    ;    2    0    ;   P3    z   ESC  \  R                             027  080  048  059  050  048  059  ***   122  027  092                    486                  -            Table A-1 (Cont.)  Escape Commandsf  +                             Escape Sequence=)            Mnemonic         Decimal Value&G                             Insert index flag in text. P3 range is 0 to =                             32767 (sent as ASCII characters).r  D            DT_INDEX_QUERY   ESC   p   0    ;    2    2    z   ESC  \  G                             027  080  048  059  050  050  122  027  092=  G                             Request DECtalk to return last index markerp<                             spoken. See Table A-2 for reply.  L            DT_INDEX_REPLY   ESC   P    0   ;    2    1    ;  P3   z   ESC  \  P                             027  080  048  059  050  049  059 ***  122  027  092        K                                                                        487p  %              -            Table A-1 (Cont.)  Escape Commands   +                             Escape Sequence )            Mnemonic         Decimal Value I                             Insert index flag in text and inform host. P3aH                             range is same as for DT_INDEX. See Table A-2&                             for reply.  M            DT_LOG           ESC   P   0    ;    8    1    ;  P3    z  ESC   \   Q                             027  080  048  059  056  049  059 ***   122  027  092a  F                             Set trace and debugging log functions. See8                             Table A-7 for P3 parameters.  M            DT_MASK          ESC   P    0    ;   8    3    ;  P3    z   ESC  \&  Q                             027  080  048  059  056  051  059  ***  122  027  092                   488t  %              -            Table A-1 (Cont.)  Escape Commands1  +                             Escape Sequence )            Mnemonic         Decimal ValuemG                             Controls how DECtalk sends escape sequences H                             and keypad characters to the host. See Table2                             A-8 for P3 parameters.  L            DT_MODE          ESC   P    0    ;   8    0    ;   P3  z  ESC   \  P                             027  080  048  059  056  048  059  *** 122  027  092  B                             Set DECtalk mode. See Table A-3 for P3'                             parameters.0  J            DT_PHONE         ESC   P   0    ;    6    0   ;   Pn   ;  Pn  z*                             text    ESC  \      K                                                                        489                  -            Table A-1 (Cont.)  Escape Commandse  +                             Escape Sequence )            Mnemonic         Decimal Value ^                             027  080  048  059  054  048  059 ***  059  ***  122...   027  092  D                             Control attached telephone and telephoneB                             keypad interface. See Table A-5 for Pn'                             parameters.&  D            DT_PHOTEXT       ESC   P   0    ;    0    z  text  ESC  \  G                             027  080  048  059  048  122  ***  027  092   0                             Speak phonemic text.  M            DT_SPEAK         ESC   P   0    ;    1    2    ;   P3  z   ESC   \t                    490                  -            Table A-1 (Cont.)  Escape Commands   +                             Escape Sequence )            Mnemonic         Decimal Value Q                             027  080  048  059  049  050  059  ***  122  027  092   E                             Enable (P3=1) or disable (P3=0) speaking.t  D            DT_STOP          ESC   P   0    ;    1    0    z   ESC  \  G                             027  080  048  059  049  048  122  027  092q  G                             Stop speaking and dump any pending unspoken%!                             text.   E            DT_SYNC          ESC   P   0    ;    1    1    z   ESC   \   G                             027  080  048  059  049  049  122  027  092       K                                                                        491x                 -            Table A-1 (Cont.)  Escape Commands   +                             Escape SequenceN)            Mnemonic         Decimal Value J                             Finish speaking current text before processing)                             next command.   N            DT_TERMINAL      ESC   P   0    ;    8    2    ;   P3    z   ESC  \  R                             027  080  048  059  056  050  059   ***  122  027  092  I                             Set local terminal mode. See Table A-4 for P3 '                             parameters.r  "            DECID            ESC  Z  $                             027  099                    492   n              -            Table A-1 (Cont.)  Escape Commands   +                             Escape Sequence )            Mnemonic         Decimal Value >                             Old identify terminal request. Not(                             recommended.  #            RIS              ESC   cr  $                             027  099  4                             Reset to power-up state.  '            S7C1T            ESC  SP   F   )                             027  040  070e          K                                                                        4931                 -            Table A-1 (Cont.)  Escape Commands   +                             Escape Sequencee)            Mnemonic         Decimal Value =                             Select 7-bit C1 control character )                             transmission.d  '            S8C1T            ESC  SP   G.  )                             027  040  071h  =                             Select 8-bit C1 control characters)                             transmission.A                          494                  ,            Table A-2  DECtalk Status Replies  +                             Escape Sequence )            Mnemonic         Decimal Value   M            DT_DICT_Reply    ESC   P   0    ;    5    0    ;   P3   z  ESC   \b  Q                             027  080  048  059  052  048  059  ***  122  027  092   9                             P3 parameters are as follows.   7                              0  Word entered correctly.                                048.  6                              1  No room in dictionary.                               049       K                                                                        495                  4            Table A-2 (Cont.)  DECtalk Status Replies  +                             Escape Sequence )            Mnemonic         Decimal Value /                              2  Entry too long.                                050   7            DA Primary       ESC   [    ?    0    9    c 8            Reply            027  091  063  049  057  099  F                             Reply from DECtalk to DA primary sequence.  -            DSR Brief        ESC   [    0    n .            Replies          027  091  048  110  ,                             No malfunctions.                    496                  4            Table A-2 (Cont.)  DECtalk Status Replies  +                             Escape Sequence )            Mnemonic         Decimal Value9-                             ESC   [    3    n   .                             027  091  051  110  1                             Malfunction occurred.   J            DSR Extended     ESC   [    0    n   ESC  [    ?    2    1    nL            Replies          027  091  048  110  027  091  063  050  049  110  9                             No malfunctions, first reply.   I                             ESC   [    0    n  ESC   [    ?    2   0    ni  L                             027  091  048  110  027  091  063  050  048  110      K                                                                        4970                 4            Table A-2 (Cont.)  DECtalk Status Replies  +                             Escape Sequence )            Mnemonic         Decimal Value C                             No malfunctions, second or later reply.   S                             ESC   [    3    n   ESC   [    ?   Pn   ;  ...   Pn   nS  T                             027  091  051  110  027  091  063  ***  059     ***  110  I                             Malfunction occurred. Pn parameter values are2'                             as follows.   ;                              2    2  Communication failure.e  $                             050  050  ;                              2    3  Input buffer overflow.                   498   S              4            Table A-2 (Cont.)  DECtalk Status Replies  +                             Escape Sequence )            Mnemonic         Decimal Valueo$                             050  051  ?                              2    4  Last NVR operation failed.a  $                             050  052  E                              2    5  Error in phonemic transcription.2  $                             050  053  E                              2    6  Error in DECtalk private control %                             sequence.9  $                             050  054      K                                                                        499                  4            Table A-2 (Cont.)  DECtalk Status Replies  +                             Escape Sequence\)            Mnemonic         Decimal Value48                              2    7  Last DECTST failed.  $                             050  055  M            DT_INDEX_QUERY   ESC   P    0    ;   3    2    ;  P3   z   ESC   \a            ReplyQ                             027  080  048  059  051  050  059 ***   122  027  092u  C                             P3 is the ASCII value of the last indexs#                             spoken.a  M            DT_INDEX_REPLY   ESC   P    0    ;   3    1    ;  P3   z   ESC   \.            ReplyQ                             027  080  048  059  051  049  059 ***   122  027  092                 500                  4            Table A-2 (Cont.)  DECtalk Status Replies  +                             Escape Sequence )            Mnemonic         Decimal Value3H                             Reply sent by DECtalk after speaking indexedI                             text. P3 is the ASCII value of the last index #                             spoken.   +               Table A-3  DT_MODE ParametersT  ,               Mnemonic       Value  Function  7               MODE_SQUARE    1      Set MODE SQUARE on.   E               MODE_ASKY      2      Use the single-character phonemics-                                     alphabet.   =               MODE_MINUS     4      Speak hyphen--as "minus."     K                                                                        501                  /               Table A-4  DT_TERMINAL Parameters0  *               Mnemonic     Value  Function  G               TERM_HOST     1     Send all local terminal characters to ,                                   host line.  E               TERM_SPEAK    2     Speak all characters typed on local +                                   terminal.   E               TERM_EDITED   4     Line edit all local terminal input.   G               TERM_HARD     8     Do local terminal editing in hardcopy )                                   format.   J               TERM-SETUP   16     Speak all characters when terminal is in.                                   set-up mode.                    502                  7               Table A-4 (Cont.)  DT_TERMINAL Parameters   *               Mnemonic     Value  FunctionE               TERM_FILTER  32     Do not send DECtalk-specific escape <                                   sequences to the terminal.  ,               Table A-5  DT_PHONE Parameters  (                               ASCII Code5               Mnemonic        Decimal Value  Function   D               PH_STATUS        0             Send a telephone status4                               048            report.  I               PH_ANSWER        1     0       Enable telephone autoanswer.   '                               049   048       K                                                                        503                  4               Table A-5 (Cont.)  DT_PHONE Parameters  (                               ASCII Code5               Mnemonic        Decimal Value  Function0F               PH_HANGUP        1     1       Hang up the telephone and@                               049   049      disable the keypad.  I               PH_KEYPAD        2     0       Enable the telephone keypad.   '                               050   048   J               PH_NOKEYPAD      2     1       Disable the telephone keypad.  '                               050   049   J               PH_TIMEOUT       3     0       Send telephone status messageI                               051   048      after n seconds (Chapter 4).                     504   i              4               Table A-5 (Cont.)  DT_PHONE Parameters  (                               ASCII Code5               Mnemonic        Decimal Value  Function\H               PH_TONE_DIAL     4     0       Dial the telephone by using@                               052   048      Touch-Tone dialing.  H               PH_PULSE_DIAL    4     1       Dial the telephone by using;                               052   049      pulse dialing.   *               Table A-6  DECTST Parameters  '                              ASCII Code&4               Mnemonic       Decimal Value  Function  A               TEST_POWER      1             Rerun power-up tests.g                               049      K                                                                        505                  2               Table A-6 (Cont.)  DECTST Parameters  '                              ASCII Code 4               Mnemonic       Decimal Value  FunctionG               TEST_HDATA      2             Run host port data loopback 1                              050            test.   J               TEST_HCONTROL   3             Run host port control loopback1                              051            test.   H               TEST_LDATA      4             Run local port data loopback1                              052            test.   E               TEST_SPEAK      5             Speak a built-in message.                                053                      506                  *               Table A-7  DT_LOG Parameters  -               Mnemonic        Value  Function   :               LOG_TEXT          1    Speak all ASCII text.  D               LOG_PHONEME       2    Log all spoken text in phonemic,                                      format.  G               LOG_RAWHOST       4    Log all text read from the host on 8                                      the local terminal.  G               LOG_INHOST        8    Log all text read from the host on 8                                      the local terminal.  I               LOG_OUTHOST      16    Log all text sent to the host on the%4                                      local terminal.        K                                                                        507                  2               Table A-7 (Cont.)  DT_LOG Parameters  -               Mnemonic        Value  Function B               LOG_ERROR        32    Log all error messages on the.                                      terminal.  I               LOG_TRACE        64    Log all escape sequences as readable @                                      text on the local terminal.  G               LOG_DEBUG       128    Reserved for DECtalk internal use.&                                508i  #              +               Table A-8  DT_MASK Parameters   $               Value   Bit  Character                     1    0   0                     2    1   1                     4    2   2                     8    3   3                    16    4   4                    32    5   5                    64    6   6                   128    7   7    K                                                                        509s  b              3               Table A-8 (Cont.)  DT_MASK Parameters   $               Value   Bit  Character                 256    8   8                   512    9   9                  1024   10   *                  2048   11   #                  4096   12   A                  8192   13   B                 16384   14   C                 32768   15   D                  510                  &            1       PHONEMIC ALPHABET B  H               This appendix summarizes the phonemic symbols that DECtalkC               uses. DECtalk recognizes all 17 vowel phonemes and 24fE               consonant phonemes in the English language (Table B-1).   J               DECtalk uses two-character symbols for each English phoneme.?               DECtalk also recognizes a one-character system of G               representing phonemes. Use of the one-character system is B               discouraged, as it is not in wide use and may not beG               supported on future releases of DECtalk. However, DECtalk H               can be set to the one-character system. Refer to Chapter 42               of the DECtalk DTC01 Owner's Manual.  G               Table B-2 lists emphasis character, for adding stress and 2               suggesting proper phrasing (syntax).          K                                                                        511                  (            Table B-1  Phonemic Inventory  ?            2-Char.       1-Char.            2-Char.     1-Char.(I            Symbol        Symbol   Example   Symbol      Symbol    Example.              Vowels   E            ey            e        bake      ah          ^         but   F            aa            a        Bob       aw          W         bout  F            iy            i        beat      yu          Y         cute  F            eh            E        bet       rr          R         bird  H            ay            A        bite      ao          c         bought  E            ih            l        bit       ae          @         bat                   512                  0            Table B-1 (Cont.)  Phonemic Inventory  ?            2-Char.       1-Char.            2-Char.     1-Char. I            Symbol        Symbol   Example   Symbol      Symbol    Example F            oy            O        boy       uh          U         book  H            ow            o        boat      ix          |         kisses  G            uw            u        lute      ax          x         about   F            ir                     beer      er                    bear  F            ar                     bar       or                    bore  &            ur                     poor              Consonants!        K                                                                        513                  0            Table B-1 (Cont.)  Phonemic Inventory  ?            2-Char.       1-Char.            2-Char.     1-Char. I            Symbol        Symbol   Example   Symbol      Symbol    Example&E            p             p        pet       b           b         bet   F            t             t        test      d           d         debt  G            k             k        Ken       g           g         guess1  F            f             f        fin       v           v         vest  F            th            T        thin      dh          D         this  E            s             s        sit       z           z         zoo   G            sh            S        shin      zh          Z         azure                     514                  0            Table B-1 (Cont.)  Phonemic Inventory  ?            2-Char.       1-Char.            2-Char.     1-Char. I            Symbol        Symbol   Example   Symbol      Symbol    Example E            ch            C        chin      jh          J         ginN  E            w             w        wet       m           m         met   E            yx            y        yet       n           n         net   F            hx            h        head      nx          G         sing  H            l             l        let       en          N         button  I            r             r        red                             silence&  (            el            L        bottle        K                                                                        5153  )              0            Table B-1 (Cont.)  Phonemic Inventory  ?            2-Char.       1-Char.            2-Char.     1-Char.eI            Symbol        Symbol   Example   Symbol      Symbol    Example (            em            M        ransom9            Allophones (Override DECtalk internal values.)   7            rx            r-       oration   postvocalic -                                             r   7            lx            l-       electric  postvocalicn-                                             l   3            q             q        we eat    glottal 6                                             stop (w'iy3                                             qx'iyt)   5            dx            &        rider     flapped d                 516i                 0            Table B-1 (Cont.)  Phonemic Inventory  ?            2-Char.       1-Char.            2-Char.     1-Char. I            Symbol        Symbol   Example   Symbol      Symbol    Example 7            tx            Q        Latin     glottalizede-                                             t   /            Table B-2  Phonemic Emphasis Markers   *            2-Character         1-Character3            Symbol              Symbol       Meaning     -            Stress and Syntax Phonemic Symbols   B            '                   '            Primary lexical stress        K                                                                        517                  7            Table B-2 (Cont.)  Phonemic Emphasis Markers   *            2-Character         1-Character3            Symbol              Symbol       Meaning D            '                   '            Seocndary lexical stress  ;            "                   "            Emphatic stressn  6            \                   \            Pitch fall  6            /                   /            Pitch rise  ;            /\                  /\           Pitch rise/fall &            Syntactic Structure Symbols  D            -                   -            Syllable boundary (dash)  =            *                   *            Morpheme boundary                 518A                 7            Table B-2 (Cont.)  Phonemic Emphasis Markers   *            2-Character         1-Character3            Symbol              Symbol       MeaningpB            #                   #            Compound noun boundary  A                                             Word boundary (space)   H            (                   (            Beginning of relative clause  F            )                   )            End relative clause, begin7                                             verb phrase   9            '                   '            End of clausec  ;            .                   .            End of sentence   ;            ?                   ?            End of questionL      K                                                                        519                  7            Table B-2 (Cont.)  Phonemic Emphasis Markers   *            2-Character         1-Character3            Symbol              Symbol       Meaningt>            !                   !            End of exclamation  @            +                   +            Paragraph introducer  "            1       DOCUMENTATION C  #               RELATED DOCUMENTATIONr  I               You can order the following DECtalk documents from Digital.                             520                  0               Title                  Description  E               DECtalk DTC01          This manual gives an overview ofgF               Owner's Manual         DECtalk operations and a detailedD               (EK-DTC01-OM)          description of DECtalk off-lineH                                      (local) operations, phonemic codes,B                                      and spoken text conventions.)  :               DECtalk DTC01          This manual describesJ               Programmer             DECtalk-computer connections, DECtalkF               Reference Manual       escape sequences, and programmingI               (EK-DTC01-RM)          methods for interfacing DECtalk with C                                      a host computer and telephone.   J               DECtalk DTC01          This card summarizes DECtalk phonemic@               Programmer             codes, commands, and escape/               Reference Card         sequences.K               (EK-DTC01-RC)       K                                                                        5219                 0               Title                  DescriptionH               DECtalk DTC01          This manual explains how to install9               Installation Manual    and operate DECtalk.                (EK-DTC01-IN)   "               ORDERING INFORMATION  H               You can obtain ordering information by telephone from 8:30G               a.m. to 6:00 p.m. Eastern Standard Time (EST) or by mail.f                 By phone  /               Continental U.S.A and Puerto Rico                  1-800-258-1710  +               New Hampshire, Alaska, Hawaii                  1-603-884-6660                 By mail   +               In the U.S.A. and Puerto Ricoh              522t  i              +               Digital Equipment Corporation                PO Box CS2008p)               Nashua, New Hampshire 03061r  0               Outside the U.S.A. and Puerto Rico  +               Digital Equipment Corporation =               Attn: Accessories and Supplies Business Manager B               c/o Local Subsidiary or Digital-Approved Distributor                        J                                                                        523