//#define DEBUG_IO
#include <stdio.h>
#include <string.h>
#include <windows.h>
#include "ttsapi.h"
#include "SMITEE.C"

//This Is for Indexing
LONG IndexMessage = 0;

static void callback(LONG LParam1, LONG lParam2, DWORD user, UINT msg)
{
	HANDLE port = (HANDLE)user;
	if (msg == IndexMessage)
	{
		short data = lParam2;
		unsigned short temp = 0x8000 | 0x80 | 0x40 | 0x08 | 0x04;
		char buffer[64];
		memset(buffer, 0, sizeof(buffer));
		sprintf(buffer, "[:index %d]", lParam2);
		WriteFile(port, buffer, strlen(buffer), NULL, NULL);
		buffer[0] = 0x10;
		buffer[1] = 0x50;
		buffer[1] |= (data>>12)&0xF;
		buffer[2] = (data>>6)&0x3F;
		if (buffer[2] < 0x20)
		buffer[2] += 0x40;
		buffer[3] = data&0x3F;
		if (buffer[3] < 0x20)
		buffer[3] += 0x40;
		buffer[4] = 0x10;
		buffer[5] = 0x40 | ((temp>>12)&0xf);
		buffer[6] = ((temp>>6)&0x3f);
		if (buffer[6] < 0x20)
		buffer[6] += 0x40;
		buffer[7] = (temp&0x3f);
		if (buffer[7] < 0x20)
		buffer[7] += 0x40;
		buffer[8] = 0;
		WriteFile(port, buffer, 8, NULL, NULL);
	}
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCommandLine, int cmdShow)
{
	//Handles to the serial port and TTS engine
	HANDLE port = NULL;
	LPTTS_HANDLE_T engine = NULL;
	//Just for a bit of novelty
	SYSTEM_POWER_STATUS status;
	//Text buffer
	char text[65536];
	//Amount of characters to skip
	int skip = 0;
	//Serial parameters and timeouts
	DCB SerialParams;
	COMMTIMEOUTS timeouts;
	#ifdef DEBUG_IO
	FILE *fp;
	#endif
	//Zero out a bunch of stuff
	memset(&status, 0, sizeof(status));
	memset(text, 0, sizeof(text));
	memset(&SerialParams, 0, sizeof(SerialParams));
	memset(&timeouts, 0, sizeof(timeouts));
	//Try to ensure the user can only open a serial port
	if (!strstr(lpszCommandLine, "COM"))
	{
		MessageBox(NULL, "Please specify a COM port on the command line, such as COM8.", "Error", MB_ICONERROR);
		return 0;
	}
	//Open a serial port for read/write access
	port = CreateFile(lpszCommandLine, GENERIC_READ|GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
	if (port == INVALID_HANDLE_VALUE)
	{
		MessageBox(NULL, "Failed to open COM port!", "Error", MB_ICONERROR);
		return 0;
	}
	//Set Serial parameters, although we probably don't nede these for a virtual port
	SerialParams.DCBlength = sizeof(SerialParams);
	GetCommState(port, &SerialParams);
	SerialParams.BaudRate = CBR_9600;
	SerialParams.ByteSize = 8;
	SerialParams.StopBits = ONESTOPBIT;
	SerialParams.Parity = NOPARITY;
	SetCommState(port, &SerialParams);
	//Set timeouts
	timeouts.ReadIntervalTimeout = MAXDWORD;
	SetCommTimeouts(port, &timeouts);
	//Initialize the TTS engine with a callback that can access the serial port
	DT$OpenMem();
	if (TextToSpeechStartupEx(&engine, WAVE_MAPPER, OWN_AUDIO_DEVICE, callback, (LONG)port))
	{
		MessageBox(NULL, "Failed to initialize DECtalk!", "Error", MB_ICONERROR);
		return 0;
	}
	//Set up Indexing
	IndexMessage = RegisterWindowMessage("DECtalkIndexMessage");
	if (!IndexMessage)
	{
		MessageBox(NULL, "Failed to set index message!", "Error", MB_ICONERROR);
		return 0;
	}
	//play a tone, pause, and speak a startup message, because after all, we are emulating a DECtalk express!
	sprintf(text, "[:tone 800,30]");
	TextToSpeechSpeak(engine, text, TTS_FORCE);
	Sleep(7000);
	sprintf(text, "DECtalk Express is running. ");
	GetSystemPowerStatus(&status);
	if (status.BatteryFlag & 128 || status.ACLineStatus & 1)
	{
		strcat(text, "External power on.");
	}
	else
	{
		if (status.BatteryLifePercent > 10)
		{
			strcat(text, "Battery okay.");
		}
		else
		{
			strcat(text, "Battery is low.");
		}
	}
	TextToSpeechSpeak(engine, text, TTS_FORCE);
	//Wait for startup message to finish
	TextToSpeechSync(engine);
	#ifdef DEBUG_IO
	fp = fopen("debug.out", "wb");
	#endif
	//Main loop
	while(1)
	{
		char dlebuf[4];
		char buffer[2];
		int i = 0;
		DWORD BytesRead = 0;
		//Just so I don't eat your processor
		Sleep(5);
		//Clear text buffer
		memset(text, 0, sizeof(text));
		//Read data from serial port Into text buffer
		ReadFile(port, text, sizeof(text), &BytesRead, NULL);
		#ifdef DEBUG_IO
		fwrite(text, BytesRead, 1, fp);
		fflush(fp);
		#endif
		//Loop through each character that was read, and parse any control characters
		for (i = 0; i < BytesRead; i++)
		{
			//Skip a character
			if (skip > 0)
			{
				skip--;
				continue;
			}
			switch(text[i])
			{
				//Interrupt speech
			case 0x03:
			case 0x15:
				TextToSpeechReset(engine, FALSE);
				WriteFile(port, "\001", 1, NULL, NULL);
				break;
				//Write a DLE sequence to the serial port
			case 0x05:
				dlebuf[0] = 0x10;
				dlebuf[1] = 0x48;
				dlebuf[2] = 0x42;
				dlebuf[3] = 0x48;
				WriteFile(port, dlebuf, 4, NULL, NULL);
				break;
				//Skip the next 3 characters
			case 0x10:
				skip = 3;
				break;
				//Ignore this one
			case 0x11:
				break;
				//Send the character to the synth
			default:
				buffer[0] = text[i];
				buffer[1] = '\0';
				TextToSpeechSpeak(engine, buffer, TTS_NORMAL);
				break;
			}
		}
	}
	//Clean up, although I don't think this code is ever reached
	CloseHandle(port);
	port = NULL;
	TextToSpeechShutdown(engine);
	engine = NULL;
	DT$CloseMem();
	return 0;
}

