/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import hhapplet.IndexPane;
import java.awt.Color;
import java.awt.Event;
import java.awt.TextComponent;
import treeview.TreeView;
import treeview.TreeViewNode;

public class IndexTree
extends TreeView {
    IndexPane m_ip;
    private IndexTreeNode m_root = new IndexTreeNode();
    int m_nVisibleIndex = -1;
    int m_nCountCache = -1;

    public String getItem(int n) {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.m_root.getChild();
        int n2 = 0;
        while (n2 < n) {
            indexTreeNode = (IndexTreeNode)indexTreeNode.getSibling();
            ++n2;
        }
        return indexTreeNode.getLabel();
    }

    public IndexTree(IndexPane indexPane) {
        this.m_ip = indexPane;
        this.setRoot(this.m_root);
        this.setBackground(new Color(255, 255, 255));
    }

    public int getVisibleIndex() {
        return this.m_nVisibleIndex;
    }

    public int countItems() {
        if (this.m_nCountCache == -1) {
            IndexTreeNode indexTreeNode = (IndexTreeNode)this.m_root.getChild();
            this.m_nCountCache = 0;
            while (indexTreeNode != null) {
                ++this.m_nCountCache;
                indexTreeNode = (IndexTreeNode)indexTreeNode.getSibling();
            }
        }
        return this.m_nCountCache;
    }

    public String getSelectedItem() {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.m_root.getChild();
        while (indexTreeNode != null) {
            if (indexTreeNode.isSelected()) {
                return indexTreeNode.getLabel();
            }
            indexTreeNode = (IndexTreeNode)indexTreeNode.getSibling();
        }
        return "";
    }

    public void select(int n) {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.m_root.getChild();
        int n2 = 0;
        while (indexTreeNode != null) {
            if (n2 == n) {
                indexTreeNode.select(true);
                this.m_tvnCurrentSelection = indexTreeNode;
            } else {
                indexTreeNode.select(false);
            }
            indexTreeNode = (IndexTreeNode)indexTreeNode.getSibling();
            ++n2;
        }
        this.paintAll(this.getGraphics());
    }

    protected void InternalSelectionHasChanged() {
        ((TextComponent)this.m_ip.getEditBox()).setText(this.getSelectedItem());
    }

    public void addItem(String string) {
        IndexTreeNode indexTreeNode = new IndexTreeNode();
        indexTreeNode.setLabel(string);
        this.m_root.addChild(indexTreeNode);
        this.m_nCountCache = -1;
        this.repaint();
    }

    public void makeVisible(int n) {
        this.m_nVisibleIndex = n;
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.m_root.getChild();
        int n2 = 0;
        while (n2 <= n) {
            indexTreeNode = (IndexTreeNode)indexTreeNode.getSibling();
            ++n2;
        }
        this.EnsureDisplayed(indexTreeNode);
        this.paintAll(this.getGraphics());
    }

    public int getSelectedIndex() {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.m_root.getChild();
        int n = 0;
        while (indexTreeNode != null) {
            if (indexTreeNode.isSelected()) {
                return n;
            }
            indexTreeNode = (IndexTreeNode)indexTreeNode.getSibling();
            ++n;
        }
        return -1;
    }

    public void clear() {
        this.m_root = new IndexTreeNode();
        this.setRoot(this.m_root);
        this.m_nCountCache = -1;
        this.paintAll(this.getGraphics());
    }

    public boolean handleEvent(Event event) {
        if (event.id == 403) {
            switch (event.key) {
                case 1006: {
                    this.ScrollLeft();
                    break;
                }
                case 1007: {
                    this.ScrollRight();
                }
            }
        }
        return super.handleEvent(event);
    }

    class IndexTreeNode
    extends TreeViewNode {
        public void doDblClick() {
            IndexTree.this.m_ip.gotoSelectedIndex();
        }

        IndexTreeNode() {
            IndexTree.this.getClass();
        }
    }
}

