/*C_HEADER_FILE****************************************************************
FILE			:	CJK2PinyinTable.c
DESC			:	This file contains the tables used to convert Chinese Hanzi
					characters to pinyin+tone
TABS			:	4
OWNER			:	Fonix
DATE CREATED	:	Feb  9 2006
(C) Copyright 2005 All rights reserved.
This is an unpublished work, and is confidential and proprietary: 
technology and information of fonix corporation.  No part of this
code may be reproduced, used or disclosed without written consent of 
fonix corporation in each and every instance.
*END_HEADER*******************************************************************/


/****************************************************************************
** All possible pinyins with tones
** 414 pronunciations x 5 tones  + 1? = 2071
** If this table is modified you must recompile the project BuildCJK2PinyinTables
** and run it to re-create this file with the correct offsets in 
** CJKUnicodeOffsetToPinyinTable
*****************************************************************************/
char *PinyinTableWithTones[] =
{
	"?",
	"a1", "a2", "a3", "a4", "a5",
	"ai1", "ai2", "ai3", "ai4", "ai5",
	"an1", "an2", "an3", "an4", "an5",
	"ang1", "ang2", "ang3", "ang4", "ang5",
	"ao1", "ao2", "ao3", "ao4", "ao5",
	"ba1", "ba2", "ba3", "ba4", "ba5",
	"bai1", "bai2", "bai3", "bai4", "bai5",
	"ban1", "ban2", "ban3", "ban4", "ban5",
	"bang1", "bang2", "bang3", "bang4", "bang5",
	"bao1", "bao2", "bao3", "bao4", "bao5",
	"bei1", "bei2", "bei3", "bei4", "bei5",
	"ben1", "ben2", "ben3", "ben4", "ben5",
	"beng1", "beng2", "beng3", "beng4", "beng5",
	"bi1", "bi2", "bi3", "bi4", "bi5",
	"bian1", "bian2", "bian3", "bian4", "bian5",
	"biao1", "biao2", "biao3", "biao4", "biao5",
	"bie1", "bie2", "bie3", "bie4", "bie5",
	"bin1", "bin2", "bin3", "bin4", "bin5",
	"bing1", "bing2", "bing3", "bing4", "bing5",
	"bo1", "bo2", "bo3", "bo4", "bo5",
	"bu1", "bu2", "bu3", "bu4", "bu5",
	"ca1", "ca2", "ca3", "ca4", "ca5",
	"cai1", "cai2", "cai3", "cai4", "cai5",
	"can1", "can2", "can3", "can4", "can5",
	"cang1", "cang2", "cang3", "cang4", "cang5",
	"cao1", "cao2", "cao3", "cao4", "cao5",
	"ce1", "ce2", "ce3", "ce4", "ce5",
	"cen1", "cen2", "cen3", "cen4", "cen5",
	"ceng1", "ceng2", "ceng3", "ceng4", "ceng5",
	"cha1", "cha2", "cha3", "cha4", "cha5",
	"chai1", "chai2", "chai3", "chai4", "chai5",
	"chan1", "chan2", "chan3", "chan4", "chan5",
	"chang1", "chang2", "chang3", "chang4", "chang5",
	"chao1", "chao2", "chao3", "chao4", "chao5",
	"che1", "che2", "che3", "che4", "che5",
	"chen1", "chen2", "chen3", "chen4", "chen5",
	"cheng1", "cheng2", "cheng3", "cheng4", "cheng5",
	"chi1", "chi2", "chi3", "chi4", "chi5",
	"chong1", "chong2", "chong3", "chong4", "chong5",
	"chou1", "chou2", "chou3", "chou4", "chou5",
	"chu1", "chu2", "chu3", "chu4", "chu5",
	"chuai1", "chuai2", "chuai3", "chuai4", "chuai5",
	"chuan1", "chuan2", "chuan3", "chuan4", "chuan5",
	"chuang1", "chuang2", "chuang3", "chuang4", "chuang5",
	"chui1", "chui2", "chui3", "chui4", "chui5",
	"chun1", "chun2", "chun3", "chun4", "chun5",
	"chuo1", "chuo2", "chuo3", "chuo4", "chuo5",
	"ci1", "ci2", "ci3", "ci4", "ci5",
	"cong1", "cong2", "cong3", "cong4", "cong5",
	"cou1", "cou2", "cou3", "cou4", "cou5",
	"cu1", "cu2", "cu3", "cu4", "cu5",
	"cuan1", "cuan2", "cuan3", "cuan4", "cuan5",
	"cui1", "cui2", "cui3", "cui4", "cui5",
	"cun1", "cun2", "cun3", "cun4", "cun5",
	"cuo1", "cuo2", "cuo3", "cuo4", "cuo5",
	"da1", "da2", "da3", "da4", "da5",
	"dai1", "dai2", "dai3", "dai4", "dai5",
	"dan1", "dan2", "dan3", "dan4", "dan5",
	"dang1", "dang2", "dang3", "dang4", "dang5",
	"dao1", "dao2", "dao3", "dao4", "dao5",
	"de1", "de2", "de3", "de4", "de5",
	"dei1", "dei2", "dei3", "dei4", "dei5",
	"deng1", "deng2", "deng3", "deng4", "deng5",
	"di1", "di2", "di3", "di4", "di5",
	"dia1", "dia2", "dia3", "dia4", "dia5",
	"dian1", "dian2", "dian3", "dian4", "dian5",
	"diao1", "diao2", "diao3", "diao4", "diao5",
	"die1", "die2", "die3", "die4", "die5",
	"ding1", "ding2", "ding3", "ding4", "ding5",
	"diu1", "diu2", "diu3", "diu4", "diu5",
	"dong1", "dong2", "dong3", "dong4", "dong5",
	"dou1", "dou2", "dou3", "dou4", "dou5",
	"du1", "du2", "du3", "du4", "du5",
	"duan1", "duan2", "duan3", "duan4", "duan5",
	"dui1", "dui2", "dui3", "dui4", "dui5",
	"dun1", "dun2", "dun3", "dun4", "dun5",
	"duo1", "duo2", "duo3", "duo4", "duo5",
	"e1", "e2", "e3", "e4", "e5",
	"ei1", "ei2", "ei3", "ei4", "ei5",
	"en1", "en2", "en3", "en4", "en5",
	"er1", "er2", "er3", "er4", "er5",
	"fa1", "fa2", "fa3", "fa4", "fa5",
	"fan1", "fan2", "fan3", "fan4", "fan5",
	"fang1", "fang2", "fang3", "fang4", "fang5",
	"fei1", "fei2", "fei3", "fei4", "fei5",
	"fen1", "fen2", "fen3", "fen4", "fen5",
	"feng1", "feng2", "feng3", "feng4", "feng5",
	"fo1", "fo2", "fo3", "fo4", "fo5",
	"fou1", "fou2", "fou3", "fou4", "fou5",
	"fu1", "fu2", "fu3", "fu4", "fu5",
	"ga1", "ga2", "ga3", "ga4", "ga5",
	"gai1", "gai2", "gai3", "gai4", "gai5",
	"gan1", "gan2", "gan3", "gan4", "gan5",
	"gang1", "gang2", "gang3", "gang4", "gang5",
	"gao1", "gao2", "gao3", "gao4", "gao5",
	"ge1", "ge2", "ge3", "ge4", "ge5",
	"gei1", "gei2", "gei3", "gei4", "gei5",
	"gen1", "gen2", "gen3", "gen4", "gen5",
	"geng1", "geng2", "geng3", "geng4", "geng5",
	"gong1", "gong2", "gong3", "gong4", "gong5",
	"gou1", "gou2", "gou3", "gou4", "gou5",
	"gu1", "gu2", "gu3", "gu4", "gu5",
	"gua1", "gua2", "gua3", "gua4", "gua5",
	"guai1", "guai2", "guai3", "guai4", "guai5",
	"guan1", "guan2", "guan3", "guan4", "guan5",
	"guang1", "guang2", "guang3", "guang4", "guang5",
	"gui1", "gui2", "gui3", "gui4", "gui5",
	"gun1", "gun2", "gun3", "gun4", "gun5",
	"guo1", "guo2", "guo3", "guo4", "guo5",
	"ha1", "ha2", "ha3", "ha4", "ha5",
	"hai1", "hai2", "hai3", "hai4", "hai5",
	"han1", "han2", "han3", "han4", "han5",
	"hang1", "hang2", "hang3", "hang4", "hang5",
	"hao1", "hao2", "hao3", "hao4", "hao5",
	"he1", "he2", "he3", "he4", "he5",
	"hei1", "hei2", "hei3", "hei4", "hei5",
	"hen1", "hen2", "hen3", "hen4", "hen5",
	"heng1", "heng2", "heng3", "heng4", "heng5",
	"hong1", "hong2", "hong3", "hong4", "hong5",
	"hou1", "hou2", "hou3", "hou4", "hou5",
	"hu1", "hu2", "hu3", "hu4", "hu5",
	"hua1", "hua2", "hua3", "hua4", "hua5",
	"huai1", "huai2", "huai3", "huai4", "huai5",
	"huan1", "huan2", "huan3", "huan4", "huan5",
	"huang1", "huang2", "huang3", "huang4", "huang5",
	"hui1", "hui2", "hui3", "hui4", "hui5",
	"hun1", "hun2", "hun3", "hun4", "hun5",
	"huo1", "huo2", "huo3", "huo4", "huo5",
	"ji1", "ji2", "ji3", "ji4", "ji5",
	"jia1", "jia2", "jia3", "jia4", "jia5",
	"jian1", "jian2", "jian3", "jian4", "jian5",
	"jiang1", "jiang2", "jiang3", "jiang4", "jiang5",
	"jiao1", "jiao2", "jiao3", "jiao4", "jiao5",
	"jie1", "jie2", "jie3", "jie4", "jie5",
	"jin1", "jin2", "jin3", "jin4", "jin5",
	"jing1", "jing2", "jing3", "jing4", "jing5",
	"jiong1", "jiong2", "jiong3", "jiong4", "jiong5",
	"jiu1", "jiu2", "jiu3", "jiu4", "jiu5",
	"ju1", "ju2", "ju3", "ju4", "ju5",
	"juan1", "juan2", "juan3", "juan4", "juan5",
	"jue1", "jue2", "jue3", "jue4", "jue5",
	"jun1", "jun2", "jun3", "jun4", "jun5",
	"ka1", "ka2", "ka3", "ka4", "ka5",
	"kai1", "kai2", "kai3", "kai4", "kai5",
	"kan1", "kan2", "kan3", "kan4", "kan5",
	"kang1", "kang2", "kang3", "kang4", "kang5",
	"kao1", "kao2", "kao3", "kao4", "kao5",
	"ke1", "ke2", "ke3", "ke4", "ke5",
	"ken1", "ken2", "ken3", "ken4", "ken5",
	"keng1", "keng2", "keng3", "keng4", "keng5",
	"kong1", "kong2", "kong3", "kong4", "kong5",
	"kou1", "kou2", "kou3", "kou4", "kou5",
	"ku1", "ku2", "ku3", "ku4", "ku5",
	"kua1", "kua2", "kua3", "kua4", "kua5",
	"kuai1", "kuai2", "kuai3", "kuai4", "kuai5",
	"kuan1", "kuan2", "kuan3", "kuan4", "kuan5",
	"kuang1", "kuang2", "kuang3", "kuang4", "kuang5",
	"kui1", "kui2", "kui3", "kui4", "kui5",
	"kun1", "kun2", "kun3", "kun4", "kun5",
	"kuo1", "kuo2", "kuo3", "kuo4", "kuo5",
	"la1", "la2", "la3", "la4", "la5",
	"lai1", "lai2", "lai3", "lai4", "lai5",
	"lan1", "lan2", "lan3", "lan4", "lan5",
	"lang1", "lang2", "lang3", "lang4", "lang5",
	"lao1", "lao2", "lao3", "lao4", "lao5",
	"le1", "le2", "le3", "le4", "le5",
	"lei1", "lei2", "lei3", "lei4", "lei5",
	"leng1", "leng2", "leng3", "leng4", "leng5",
	"li1", "li2", "li3", "li4", "li5",
	"lia1", "lia2", "lia3", "lia4", "lia5",
	"lian1", "lian2", "lian3", "lian4", "lian5",
	"liang1", "liang2", "liang3", "liang4", "liang5",
	"liao1", "liao2", "liao3", "liao4", "liao5",
	"lie1", "lie2", "lie3", "lie4", "lie5",
	"lin1", "lin2", "lin3", "lin4", "lin5",
	"ling1", "ling2", "ling3", "ling4", "ling5",
	"liu1", "liu2", "liu3", "liu4", "liu5",
	"long1", "long2", "long3", "long4", "long5",
	"lou1", "lou2", "lou3", "lou4", "lou5",
	"lu1", "lu2", "lu3", "lu4", "lu5",
	"luan1", "luan2", "luan3", "luan4", "luan5",
	"lue1", "lue2", "lue3", "lue4", "lue5",
	"lun1", "lun2", "lun3", "lun4", "lun5",
	"luo1", "luo2", "luo3", "luo4", "luo5",
	"lv1", "lv2", "lv3", "lv4", "lv5",
	"lve1", "lve2", "lve3", "lve4", "lve5",
	"l1", "l2", "l3", "l4", "l5",
	"le1", "le2", "le3", "le4", "le5",
	"m1", "m2", "m3", "m4", "m5",
	"ma1", "ma2", "ma3", "ma4", "ma5",
	"mai1", "mai2", "mai3", "mai4", "mai5",
	"man1", "man2", "man3", "man4", "man5",
	"mang1", "mang2", "mang3", "mang4", "mang5",
	"mao1", "mao2", "mao3", "mao4", "mao5",
	"me1", "me2", "me3", "me4", "me5",
	"mei1", "mei2", "mei3", "mei4", "mei5",
	"men1", "men2", "men3", "men4", "men5",
	"meng1", "meng2", "meng3", "meng4", "meng5",
	"mi1", "mi2", "mi3", "mi4", "mi5",
	"mian1", "mian2", "mian3", "mian4", "mian5",
	"miao1", "miao2", "miao3", "miao4", "miao5",
	"mie1", "mie2", "mie3", "mie4", "mie5",
	"min1", "min2", "min3", "min4", "min5",
	"ming1", "ming2", "ming3", "ming4", "ming5",
	"miu1", "miu2", "miu3", "miu4", "miu5",
	"mo1", "mo2", "mo3", "mo4", "mo5",
	"mou1", "mou2", "mou3", "mou4", "mou5",
	"mu1", "mu2", "mu3", "mu4", "mu5",
	"n1", "n2", "n3", "n4", "n5",
	"na1", "na2", "na3", "na4", "na5",
	"nai1", "nai2", "nai3", "nai4", "nai5",
	"nan1", "nan2", "nan3", "nan4", "nan5",
	"nang1", "nang2", "nang3", "nang4", "nang5",
	"nao1", "nao2", "nao3", "nao4", "nao5",
	"ne1", "ne2", "ne3", "ne4", "ne5",
	"nei1", "nei2", "nei3", "nei4", "nei5",
	"nen1", "nen2", "nen3", "nen4", "nen5",
	"neng1", "neng2", "neng3", "neng4", "neng5",
	"ng1", "ng2", "ng3", "ng4", "ng5",
	"ni1", "ni2", "ni3", "ni4", "ni5",
	"nian1", "nian2", "nian3", "nian4", "nian5",
	"niang1", "niang2", "niang3", "niang4", "niang5",
	"niao1", "niao2", "niao3", "niao4", "niao5",
	"nie1", "nie2", "nie3", "nie4", "nie5",
	"nin1", "nin2", "nin3", "nin4", "nin5",
	"ning1", "ning2", "ning3", "ning4", "ning5",
	"niu1", "niu2", "niu3", "niu4", "niu5",
	"nong1", "nong2", "nong3", "nong4", "nong5",
	"nou1", "nou2", "nou3", "nou4", "nou5",
	"nu1", "nu2", "nu3", "nu4", "nu5",
	"nuan1", "nuan2", "nuan3", "nuan4", "nuan5",
	"nue1", "nue2", "nue3", "nue4", "nue5",
	"nuo1", "nuo2", "nuo3", "nuo4", "nuo5",
	"nv1", "nv2", "nv3", "nv4", "nv5",
	"nve1", "nve2", "nve3", "nve4", "nve5",
	"n1", "n2", "n3", "n4", "n5",
	"ne1", "ne2", "ne3", "ne4", "ne5",
	"o1", "o2", "o3", "o4", "o5",
	"ou1", "ou2", "ou3", "ou4", "ou5",
	"pa1", "pa2", "pa3", "pa4", "pa5",
	"pai1", "pai2", "pai3", "pai4", "pai5",
	"pan1", "pan2", "pan3", "pan4", "pan5",
	"pang1", "pang2", "pang3", "pang4", "pang5",
	"pao1", "pao2", "pao3", "pao4", "pao5",
	"pei1", "pei2", "pei3", "pei4", "pei5",
	"pen1", "pen2", "pen3", "pen4", "pen5",
	"peng1", "peng2", "peng3", "peng4", "peng5",
	"pi1", "pi2", "pi3", "pi4", "pi5",
	"pian1", "pian2", "pian3", "pian4", "pian5",
	"piao1", "piao2", "piao3", "piao4", "piao5",
	"pie1", "pie2", "pie3", "pie4", "pie5",
	"pin1", "pin2", "pin3", "pin4", "pin5",
	"ping1", "ping2", "ping3", "ping4", "ping5",
	"po1", "po2", "po3", "po4", "po5",
	"pou1", "pou2", "pou3", "pou4", "pou5",
	"pu1", "pu2", "pu3", "pu4", "pu5",
	"qi1", "qi2", "qi3", "qi4", "qi5",
	"qia1", "qia2", "qia3", "qia4", "qia5",
	"qian1", "qian2", "qian3", "qian4", "qian5",
	"qiang1", "qiang2", "qiang3", "qiang4", "qiang5",
	"qiao1", "qiao2", "qiao3", "qiao4", "qiao5",
	"qie1", "qie2", "qie3", "qie4", "qie5",
	"qin1", "qin2", "qin3", "qin4", "qin5",
	"qing1", "qing2", "qing3", "qing4", "qing5",
	"qiong1", "qiong2", "qiong3", "qiong4", "qiong5",
	"qiu1", "qiu2", "qiu3", "qiu4", "qiu5",
	"qu1", "qu2", "qu3", "qu4", "qu5",
	"quan1", "quan2", "quan3", "quan4", "quan5",
	"que1", "que2", "que3", "que4", "que5",
	"qun1", "qun2", "qun3", "qun4", "qun5",
	"ran1", "ran2", "ran3", "ran4", "ran5",
	"rang1", "rang2", "rang3", "rang4", "rang5",
	"rao1", "rao2", "rao3", "rao4", "rao5",
	"re1", "re2", "re3", "re4", "re5",
	"ren1", "ren2", "ren3", "ren4", "ren5",
	"reng1", "reng2", "reng3", "reng4", "reng5",
	"ri1", "ri2", "ri3", "ri4", "ri5",
	"rong1", "rong2", "rong3", "rong4", "rong5",
	"rou1", "rou2", "rou3", "rou4", "rou5",
	"ru1", "ru2", "ru3", "ru4", "ru5",
	"ruan1", "ruan2", "ruan3", "ruan4", "ruan5",
	"rui1", "rui2", "rui3", "rui4", "rui5",
	"run1", "run2", "run3", "run4", "run5",
	"ruo1", "ruo2", "ruo3", "ruo4", "ruo5",
	"sa1", "sa2", "sa3", "sa4", "sa5",
	"sai1", "sai2", "sai3", "sai4", "sai5",
	"san1", "san2", "san3", "san4", "san5",
	"sang1", "sang2", "sang3", "sang4", "sang5",
	"sao1", "sao2", "sao3", "sao4", "sao5",
	"se1", "se2", "se3", "se4", "se5",
	"sen1", "sen2", "sen3", "sen4", "sen5",
	"seng1", "seng2", "seng3", "seng4", "seng5",
	"sha1", "sha2", "sha3", "sha4", "sha5",
	"shai1", "shai2", "shai3", "shai4", "shai5",
	"shan1", "shan2", "shan3", "shan4", "shan5",
	"shang1", "shang2", "shang3", "shang4", "shang5",
	"shao1", "shao2", "shao3", "shao4", "shao5",
	"she1", "she2", "she3", "she4", "she5",
	"shei1", "shei2", "shei3", "shei4", "shei5",
	"shen1", "shen2", "shen3", "shen4", "shen5",
	"sheng1", "sheng2", "sheng3", "sheng4", "sheng5",
	"shi1", "shi2", "shi3", "shi4", "shi5",
	"shou1", "shou2", "shou3", "shou4", "shou5",
	"shu1", "shu2", "shu3", "shu4", "shu5",
	"shua1", "shua2", "shua3", "shua4", "shua5",
	"shuai1", "shuai2", "shuai3", "shuai4", "shuai5",
	"shuan1", "shuan2", "shuan3", "shuan4", "shuan5",
	"shuang1", "shuang2", "shuang3", "shuang4", "shuang5",
	"shui1", "shui2", "shui3", "shui4", "shui5",
	"shun1", "shun2", "shun3", "shun4", "shun5",
	"shuo1", "shuo2", "shuo3", "shuo4", "shuo5",
	"si1", "si2", "si3", "si4", "si5",
	"song1", "song2", "song3", "song4", "song5",
	"sou1", "sou2", "sou3", "sou4", "sou5",
	"su1", "su2", "su3", "su4", "su5",
	"suan1", "suan2", "suan3", "suan4", "suan5",
	"sui1", "sui2", "sui3", "sui4", "sui5",
	"sun1", "sun2", "sun3", "sun4", "sun5",
	"suo1", "suo2", "suo3", "suo4", "suo5",
	"ta1", "ta2", "ta3", "ta4", "ta5",
	"tai1", "tai2", "tai3", "tai4", "tai5",
	"tan1", "tan2", "tan3", "tan4", "tan5",
	"tang1", "tang2", "tang3", "tang4", "tang5",
	"tao1", "tao2", "tao3", "tao4", "tao5",
	"te1", "te2", "te3", "te4", "te5",
	"tei1", "tei2", "tei3", "tei4", "tei5",
	"teng1", "teng2", "teng3", "teng4", "teng5",
	"ti1", "ti2", "ti3", "ti4", "ti5",
	"tian1", "tian2", "tian3", "tian4", "tian5",
	"tiao1", "tiao2", "tiao3", "tiao4", "tiao5",
	"tie1", "tie2", "tie3", "tie4", "tie5",
	"ting1", "ting2", "ting3", "ting4", "ting5",
	"tong1", "tong2", "tong3", "tong4", "tong5",
	"tou1", "tou2", "tou3", "tou4", "tou5",
	"tu1", "tu2", "tu3", "tu4", "tu5",
	"tuan1", "tuan2", "tuan3", "tuan4", "tuan5",
	"tui1", "tui2", "tui3", "tui4", "tui5",
	"tun1", "tun2", "tun3", "tun4", "tun5",
	"tuo1", "tuo2", "tuo3", "tuo4", "tuo5",
	"wa1", "wa2", "wa3", "wa4", "wa5",
	"wai1", "wai2", "wai3", "wai4", "wai5",
	"wan1", "wan2", "wan3", "wan4", "wan5",
	"wang1", "wang2", "wang3", "wang4", "wang5",
	"wei1", "wei2", "wei3", "wei4", "wei5",
	"wen1", "wen2", "wen3", "wen4", "wen5",
	"weng1", "weng2", "weng3", "weng4", "weng5",
	"wo1", "wo2", "wo3", "wo4", "wo5",
	"wu1", "wu2", "wu3", "wu4", "wu5",
	"xi1", "xi2", "xi3", "xi4", "xi5",
	"xia1", "xia2", "xia3", "xia4", "xia5",
	"xian1", "xian2", "xian3", "xian4", "xian5",
	"xiang1", "xiang2", "xiang3", "xiang4", "xiang5",
	"xiao1", "xiao2", "xiao3", "xiao4", "xiao5",
	"xie1", "xie2", "xie3", "xie4", "xie5",
	"xin1", "xin2", "xin3", "xin4", "xin5",
	"xing1", "xing2", "xing3", "xing4", "xing5",
	"xiong1", "xiong2", "xiong3", "xiong4", "xiong5",
	"xiu1", "xiu2", "xiu3", "xiu4", "xiu5",
	"xu1", "xu2", "xu3", "xu4", "xu5",
	"xuan1", "xuan2", "xuan3", "xuan4", "xuan5",
	"xue1", "xue2", "xue3", "xue4", "xue5",
	"xun1", "xun2", "xun3", "xun4", "xun5",
	"ya1", "ya2", "ya3", "ya4", "ya5",
	"yan1", "yan2", "yan3", "yan4", "yan5",
	"yang1", "yang2", "yang3", "yang4", "yang5",
	"yao1", "yao2", "yao3", "yao4", "yao5",
	"ye1", "ye2", "ye3", "ye4", "ye5",
	"yi1", "yi2", "yi3", "yi4", "yi5",
	"yin1", "yin2", "yin3", "yin4", "yin5",
	"ying1", "ying2", "ying3", "ying4", "ying5",
	"yo1", "yo2", "yo3", "yo4", "yo5",
	"yong1", "yong2", "yong3", "yong4", "yong5",
	"you1", "you2", "you3", "you4", "you5",
	"yu1", "yu2", "yu3", "yu4", "yu5",
	"yuan1", "yuan2", "yuan3", "yuan4", "yuan5",
	"yue1", "yue2", "yue3", "yue4", "yue5",
	"yun1", "yun2", "yun3", "yun4", "yun5",
	"za1", "za2", "za3", "za4", "za5",
	"zai1", "zai2", "zai3", "zai4", "zai5",
	"zan1", "zan2", "zan3", "zan4", "zan5",
	"zang1", "zang2", "zang3", "zang4", "zang5",
	"zao1", "zao2", "zao3", "zao4", "zao5",
	"ze1", "ze2", "ze3", "ze4", "ze5",
	"zei1", "zei2", "zei3", "zei4", "zei5",
	"zen1", "zen2", "zen3", "zen4", "zen5",
	"zeng1", "zeng2", "zeng3", "zeng4", "zeng5",
	"zha1", "zha2", "zha3", "zha4", "zha5",
	"zhai1", "zhai2", "zhai3", "zhai4", "zhai5",
	"zhan1", "zhan2", "zhan3", "zhan4", "zhan5",
	"zhang1", "zhang2", "zhang3", "zhang4", "zhang5",
	"zhao1", "zhao2", "zhao3", "zhao4", "zhao5",
	"zhe1", "zhe2", "zhe3", "zhe4", "zhe5",
	"zhei1", "zhei2", "zhei3", "zhei4", "zhei5",
	"zhen1", "zhen2", "zhen3", "zhen4", "zhen5",
	"zheng1", "zheng2", "zheng3", "zheng4", "zheng5",
	"zhi1", "zhi2", "zhi3", "zhi4", "zhi5",
	"zhong1", "zhong2", "zhong3", "zhong4", "zhong5",
	"zhou1", "zhou2", "zhou3", "zhou4", "zhou5",
	"zhu1", "zhu2", "zhu3", "zhu4", "zhu5",
	"zhua1", "zhua2", "zhua3", "zhua4", "zhua5",
	"zhuai1", "zhuai2", "zhuai3", "zhuai4", "zhuai5",
	"zhuan1", "zhuan2", "zhuan3", "zhuan4", "zhuan5",
	"zhuang1", "zhuang2", "zhuang3", "zhuang4", "zhuang5",
	"zhui1", "zhui2", "zhui3", "zhui4", "zhui5",
	"zhun1", "zhun2", "zhun3", "zhun4", "zhun5",
	"zhuo1", "zhuo2", "zhuo3", "zhuo4", "zhuo5",
	"zi1", "zi2", "zi3", "zi4", "zi5",
	"zong1", "zong2", "zong3", "zong4", "zong5",
	"zou1", "zou2", "zou3", "zou4", "zou5",
	"zu1", "zu2", "zu3", "zu4", "zu5",
	"zuan1", "zuan2", "zuan3", "zuan4", "zuan5",
	"zui1", "zui2", "zui3", "zui4", "zui5",
	"zun1", "zun2", "zun3", "zun4", "zun5",
	"zuo1", "zuo2", "zuo3", "zuo4", "zuo5"
	};


/* -----------------------------------------------------------------
CJKUnicodeOffsetToPinyinTable contains a value for all ideographs in the
Unicode set from 0x4E00 to 0x9FA5.  The value is an index into the above
table PinyinTableWithTones.  Some ideographs may have more than one possible 
pronunciation depending on context.  When this happens 2500 will be added
to the value in CJKUnicodeOffsetToPinyinTable to flag that additional 
context checking needs to happen.

Warning: Do not modify this table by hand.  It must be built using the
project BuildCJK2PinyinTables.
------------------------------------------------------------------ */
const unsigned short CJKUnicodeOffsetToPinyinTable[]= {
	1836, 341, 733, 1281, 1479, 1749, 0, 1709, 1949, 1431, 1479, 1749, 641, 104, 4368, 998,
	459, 198, 198, 2006, 1308, 1236, 1509, 1509, 1326, 93, 1834, 242, 351, 1556, 182, 346,
	1326, 858, 346, 1863, 858, 1817, 94, 3936, 538, 686, 479, 1811, 1297, 4481, 643, 666,
	431, 524, 214, 158, 872, 2027, 1993, 0, 1707, 286, 4217, 1993, 678, 844, 693, 1253,
	447, 1837, 1839, 1053, 1738, 688, 1839, 1957, 3475, 1839, 0, 1976, 1736, 1934, 601, 407,
	3329, 1842, 1261, 1211, 1302, 1509, 516, 182, 182, 1838, 1843, 0, 1119, 688, 1283, 1833,
	1742, 1756, 1327, 346, 0, 0, 1516, 0, 1508, 641, 1062, 646, 0, 1507, 0, 0,
	953, 904, 0, 1398, 1741, 1818, 1278, 1461, 1047, 461, 0, 0, 0, 0, 461, 904,
	531, 461, 904, 872, 1839, 702, 3330, 0, 1867, 1971, 1509, 1509, 404, 204, 1867, 786,
	786, 1882, 604, 1282, 1738, 678, 1559, 1584, 489, 489, 1814, 1766, 1814, 1282, 1814, 642,
	1667, 1712, 729, 1599, 661, 554, 1839, 158, 586, 1038, 0, 1758, 676, 1657, 859, 1758,
	676, 1834, 1311, 97, 1864, 1769, 288, 852, 383, 982, 1372, 1372, 642, 0, 1712, 1839,
	4007, 1372, 829, 341, 1914, 673, 1276, 197, 26, 1948, 671, 669, 91, 1377, 242, 437,
	1433, 912, 0, 121, 4533, 1509, 1596, 1949, 449, 1751, 1796, 1691, 592, 1662, 1374, 1291,
	462, 476, 317, 284, 879, 1838, 169, 162, 1421, 1479, 1837, 1039, 985, 1374, 648, 169,
	1823, 671, 1984, 1238, 1732, 1738, 654, 649, 1828, 431, 121, 1374, 1712, 429, 316, 418,
	1981, 1283, 1224, 1867, 334, 379, 1724, 1839, 1773, 729, 1836, 642, 9, 1738, 644, 447,
	407, 1786, 674, 1221, 177, 446, 1613, 1984, 1861, 638, 3129, 1868, 2047, 212, 1433, 1718,
	2712, 171, 1812, 1754, 1476, 161, 912, 121, 1809, 1774, 1718, 1994, 188, 1752, 1147, 97,
	506, 1098, 1097, 1769, 39, 1794, 877, 1989, 1496, 1331, 1559, 61, 1559, 1307, 1236, 1839,
	1559, 1838, 1971, 329, 557, 954, 289, 1994, 104, 1331, 68, 1484, 238, 1719, 316, 1994,
	2068, 1864, 1821, 1638, 1944, 572, 67, 1692, 1487, 1867, 1839, 437, 2069, 501, 1129, 1662,
	1098, 1751, 1332, 1856, 1698, 1291, 0, 713, 0, 1224, 627, 574, 823, 1757, 572, 1822,
	33, 408, 1017, 646, 404, 94, 642, 583, 637, 533, 1337, 1646, 663, 239, 1839, 1508,
	1777, 1496, 1691, 723, 1977, 456, 807, 1837, 188, 768, 526, 844, 1841, 1509, 993, 1991,
	1794, 1864, 11, 899, 1032, 402, 912, 1662, 149, 189, 1809, 2996, 1986, 1836, 1397, 654,
	1747, 649, 1894, 923, 0, 1827, 1966, 134, 1302, 774, 152, 1129, 1137, 674, 1738, 597,
	683, 183, 1969, 2069, 198, 1311, 923, 692, 1519, 1658, 1497, 1691, 97, 1057, 566, 2574,
	1683, 1868, 1744, 254, 387, 1327, 1792, 529, 764, 1739, 709, 1978, 448, 857, 2048, 1304,
	844, 1858, 634, 679, 1294, 1434, 1222, 1572, 447, 1741, 843, 448, 1261, 48, 1867, 1559,
	1747, 1774, 1786, 1868, 319, 171, 197, 0, 1818, 848, 844, 807, 1556, 653, 1786, 448,
	574, 694, 1764, 1202, 654, 79, 1639, 424, 434, 1814, 13, 54, 1869, 1771, 68, 654,
	161, 187, 94, 1897, 1827, 264, 848, 1708, 807, 121, 2039, 479, 521, 54, 1643, 1516,
	1516, 985, 2798, 1607, 702, 222, 1779, 1232, 1613, 599, 1838, 1281, 1639, 464, 676, 669,
	1581, 164, 667, 418, 1977, 753, 699, 2036, 694, 1294, 1097, 912, 2026, 1731, 918, 1561,
	877, 634, 351, 2034, 59, 1738, 694, 1054, 113, 653, 1939, 1831, 1977, 1464, 1316, 0,
	1846, 181, 651, 1818, 1154, 1984, 228, 3148, 667, 1718, 1868, 93, 1419, 1637, 1716, 1241,
	1819, 431, 1613, 1734, 389, 1767, 173, 1503, 723, 319, 2069, 146, 1657, 54, 1834, 622,
	1828, 1944, 198, 1816, 1862, 654, 1791, 1931, 236, 449, 66, 1979, 2038, 998, 641, 1838,
	1769, 1807, 111, 366, 134, 1966, 1193, 1666, 1666, 54, 1897, 923, 667, 1718, 429, 162,
	788, 1568, 1978, 1574, 1746, 449, 1874, 1387, 844, 1399, 1883, 504, 949, 44, 326, 1612,
	569, 667, 1741, 1474, 1294, 702, 121, 204, 1433, 54, 1764, 1387, 1827, 1599, 1591, 1823,
	406, 94, 646, 283, 1894, 1613, 0, 86, 203, 1162, 116, 833, 261, 1856, 1906, 2038,
	1232, 1563, 24, 212, 1868, 1939, 2047, 1476, 218, 679, 189, 1463, 559, 1946, 1316, 1819,
	319, 1769, 923, 54, 1249, 673, 854, 899, 959, 1291, 1751, 1644, 1847, 354, 2009, 1759,
	1474, 1302, 683, 1682, 2063, 1277, 1741, 822, 163, 526, 862, 1281, 311, 157, 1718, 641,
	411, 629, 213, 1654, 157, 663, 689, 1456, 429, 1754, 1869, 389, 661, 654, 1662, 872,
	97, 509, 0, 1574, 1754, 656, 1013, 1834, 674, 649, 1304, 1239, 431, 1989, 9, 1509,
	1837, 709, 1137, 157, 1839, 291, 678, 1796, 774, 653, 204, 286, 663, 1463, 1894, 0,
	86, 14, 1397, 1602, 197, 152, 811, 1098, 674, 1294, 987, 1738, 1127, 1322, 1098, 162,
	869, 833, 923, 784, 49, 1869, 76, 1898, 1977, 1559, 1861, 567, 179, 179, 844, 1632,
	1717, 887, 203, 157, 1357, 1516, 629, 844, 920, 1898, 1162, 1613, 1818, 833, 1064, 402,
	1739, 1883, 1896, 1872, 1781, 191, 1954, 1781, 1751, 526, 374, 739, 374, 998, 1674, 162,
	402, 374, 402, 1771, 1674, 1559, 1818, 1818, 1508, 1507, 293, 1291, 356, 426, 967, 1496,
	356, 33, 676, 842, 622, 1399, 1712, 1079, 1337, 858, 1867, 26, 496, 884, 1741, 0,
	812, 499, 1641, 521, 4276, 91, 1282, 694, 328, 2031, 0, 1823, 651, 1514, 644, 1839,
	644, 158, 681, 0, 1353, 1079, 1872, 968, 466, 1353, 134, 681, 134, 1894, 513, 683,
	969, 1989, 969, 501, 1791, 998, 994, 1388, 1842, 1768, 714, 706, 1137, 1837, 992, 1509,
	3021, 987, 1983, 694, 1871, 1017, 759, 872, 449, 1768, 994, 91, 351, 1602, 466, 432,
	91, 604, 191, 702, 604, 784, 1833, 838, 1209, 447, 1013, 354, 1753, 869, 1767, 651,
	679, 1519, 978, 1672, 1281, 509, 2023, 1561, 679, 857, 1319, 331, 877, 354, 671, 653,
	1841, 249, 1837, 844, 121, 1018, 2023, 261, 1556, 382, 674, 873, 873, 1127, 1741, 362,
	3143, 412, 412, 412, 434, 691, 204, 671, 431, 1039, 1978, 447, 431, 1262, 431, 718,
	622, 718, 461, 314, 1262, 723, 1781, 774, 1671, 21, 201, 641, 294, 557, 557, 1907,
	296, 331, 296, 1374, 1374, 216, 2926, 3806, 1839, 641, 721, 721, 268, 202, 1723, 641,
	288, 1777, 3107, 1707, 702, 842, 1879, 869, 882, 1912, 466, 2719, 447, 201, 1334, 691,
	1471, 1013, 877, 1981, 1209, 82, 667, 667, 49, 844, 1471, 82, 159, 678, 511, 486,
	299, 217, 786, 761, 384, 404, 1979, 1521, 1339, 149, 2739, 739, 667, 534, 239, 534,
	718, 384, 644, 1639, 678, 892, 917, 1912, 1871, 274, 4261, 739, 804, 1292, 149, 219,
	513, 654, 274, 842, 1636, 424, 1271, 159, 1282, 219, 2034, 466, 1706, 96, 641, 381,
	1317, 1818, 2027, 654, 644, 2596, 1816, 694, 636, 1504, 653, 382, 366, 1736, 513, 449,
	1504, 654, 476, 277, 718, 219, 696, 158, 2006, 899, 842, 447, 1471, 1246, 756, 663,
	511, 1301, 702, 609, 1931, 2029, 852, 694, 3736, 882, 534, 663, 534, 654, 654, 291,
	636, 644, 654, 1839, 654, 1977, 157, 653, 1027, 842, 1992, 844, 1811, 1339, 39, 496,
	646, 1739, 954, 869, 674, 746, 1767, 1978, 354, 1994, 1148, 667, 1332, 1484, 1839, 1991,
	1003, 844, 3174, 822, 822, 699, 758, 1822, 1696, 1764, 1032, 781, 667, 869, 572, 1509,
	739, 674, 566, 97, 1013, 189, 817, 1858, 1858, 998, 739, 1806, 699, 1317, 899, 1273,
	988, 189, 3329, 719, 998, 354, 1794, 1794, 721, 1739, 1839, 1806, 1728, 1504, 822, 1039,
	899, 1249, 1509, 644, 1312, 659, 663, 1339, 1823, 1839, 702, 411, 699, 1662, 694, 286,
	1767, 954, 1806, 1806, 924, 844, 174, 1357, 1339, 46, 1482, 1882, 686, 49, 501, 1739,
	1882, 1723, 69, 459, 459, 46, 241, 0, 1781, 1231, 691, 1617, 477, 1277, 11, 1217,
	447, 496, 276, 689, 1321, 68, 609, 53, 1068, 187, 416, 689, 1837, 1886, 659, 729,
	659, 781, 601, 1747, 1331, 74, 533, 1309, 1901, 781, 423, 601, 1667, 533, 789, 629,
	286, 789, 852, 852, 1578, 362, 689, 1332, 1744, 1238, 1331, 1836, 736, 1818, 73, 1099,
	1331, 1507, 1774, 1291, 1104, 1424, 2047, 1501, 1738, 629, 39, 1509, 1744, 1709, 3107, 1767,
	1709, 51, 2047, 2027, 1767, 286, 954, 1057, 286, 642, 97, 1529, 103, 784, 74, 103,
	1944, 713, 897, 1863, 898, 1741, 514, 1734, 1769, 667, 667, 1719, 17, 1322, 1976, 968,
	1844, 1716, 1484, 642, 1344, 903, 1509, 3199, 1769, 1794, 673, 1344, 1739, 644, 389, 1316,
	1741, 0, 163, 1941, 389, 1656, 844, 1957, 558, 844, 1813, 1811, 1819, 1489, 1978, 1933,
	1212, 0, 1309, 1812, 1979, 134, 962, 1637, 842, 1489, 599, 1656, 2056, 274, 422, 1872,
	134, 1872, 1756, 1818, 844, 702, 3964, 326, 202, 689, 1312, 22, 533, 1819, 1556, 844,
	163, 812, 844, 1817, 1818, 1872, 1556, 496, 872, 1327, 1334, 1334, 0, 833, 361, 1754,
	2006, 1431, 2616, 116, 116, 116, 9, 284, 1864, 146, 642, 1863, 1536, 413, 1511, 519,
	27, 2906, 1419, 1509, 1516, 2027, 1333, 1514, 74, 1794, 648, 1209, 1568, 474, 1719, 1568,
	337, 1409, 242, 758, 508, 694, 879, 513, 1616, 759, 4478, 664, 1954, 26, 341, 738,
	1602, 189, 1508, 1864, 1327, 1268, 1834, 3069, 1556, 1609, 1399, 829, 331, 641, 0, 591,
	1006, 1791, 962, 186, 479, 1796, 1826, 2033, 572, 642, 334, 269, 1662, 1017, 599, 844,
	4173, 1759, 1934, 4249, 1833, 923, 1811, 3450, 1193, 1801, 1836, 706, 198, 874, 1686, 1842,
	424, 1238, 1314, 1314, 669, 104, 443, 2530, 376, 426, 387, 557, 1656, 3062, 1548, 1283,
	592, 1976, 1843, 1737, 1737, 168, 1049, 1804, 1741, 221, 356, 1723, 598, 591, 1737, 474,
	4311, 709, 923, 389, 477, 874, 281, 1283, 182, 1737, 474, 446, 664, 591, 188, 1501,
	1049, 1686, 945, 1839, 281, 1193, 844, 55, 1872, 1731, 0, 1296, 1736, 389, 1506, 1752,
	1226, 1723, 1075, 945, 877, 1352, 1861, 318, 1986, 1509, 1989, 1654, 1744, 1839, 1284, 1262,
	2033, 511, 2031, 1719, 598, 571, 1067, 1746, 1221, 1839, 1761, 1496, 601, 1019, 277, 1331,
	693, 1752, 1886, 1691, 381, 1274, 1217, 67, 447, 1821, 572, 1934, 3072, 551, 689, 1858,
	450, 276, 1989, 1698, 713, 506, 3211, 2068, 104, 887, 351, 1127, 0, 1556, 1754, 639,
	641, 403, 389, 496, 1934, 1744, 1837, 868, 2031, 1006, 991, 1978, 1828, 1741, 1989, 713,
	1807, 1897, 1764, 737, 626, 768, 1509, 1617, 1752, 11, 1798, 1786, 1731, 1816, 823, 1836,
	6, 1258, 1498, 1662, 3091, 1781, 381, 1696, 546, 1891, 1869, 319, 1204, 1758, 6, 487,
	781, 1813, 276, 1761, 69, 1878, 1102, 3106, 562, 774, 383, 0, 1282, 1137, 1031, 4351,
	569, 1872, 889, 359, 962, 476, 1187, 186, 1484, 845, 3548, 2047, 572, 761, 1764, 1754,
	822, 97, 1957, 1931, 857, 26, 1006, 869, 1426, 442, 103, 559, 586, 493, 1551, 646,
	1863, 1819, 508, 508, 55, 557, 1591, 227, 1839, 6, 647, 1673, 1817, 618, 844, 1741,
	1612, 2069, 1498, 171, 1045, 1909, 1813, 356, 1283, 317, 1314, 949, 1029, 499, 358, 0,
	824, 858, 1593, 1909, 619, 838, 1461, 641, 2048, 1731, 433, 1842, 603, 1284, 1514, 1717,
	1521, 164, 402, 844, 1759, 13, 669, 1851, 1104, 1867, 1643, 807, 1464, 1741, 1694, 601,
	1812, 1986, 1144, 743, 2027, 2027, 1476, 317, 586, 872, 2505, 1761, 1296, 2021, 1738, 1724,
	264, 337, 601, 1283, 1283, 1617, 289, 289, 1834, 2033, 68, 264, 234, 572, 1813, 1283,
	1957, 421, 858, 1752, 1237, 1462, 3305, 1912, 1316, 514, 1196, 1958, 1449, 2009, 1119, 541,
	917, 1817, 316, 1337, 1606, 100, 344, 816, 1764, 0, 1612, 189, 1637, 11, 686, 288,
	711, 1857, 1719, 1057, 1474, 1869, 1957, 803, 666, 597, 558, 337, 1986, 152, 1701, 1368,
	1869, 1841, 1897, 1826, 1731, 998, 602, 1883, 213, 629, 619, 619, 1743, 3071, 641, 789,
	1983, 1717, 1464, 1793, 622, 382, 1817, 1796, 859, 1869, 1436, 186, 1302, 1819, 286, 1226,
	1507, 842, 1851, 1931, 1716, 1001, 1847, 3726, 0, 787, 1744, 1869, 642, 895, 764, 1444,
	604, 1637, 1827, 574, 1464, 1789, 1296, 1449, 1856, 1574, 499, 1767, 9, 1591, 950, 146,
	554, 739, 1599, 1438, 176, 1399, 1566, 1696, 641, 1213, 1736, 1752, 1509, 477, 2031, 666,
	919, 1726, 1699, 1559, 186, 567, 1595, 646, 551, 1593, 1312, 1119, 571, 0, 1429, 1045,
	479, 1047, 323, 6, 0, 1661, 69, 22, 22, 852, 1581, 1959, 1029, 1569, 1568, 1608,
	317, 1281, 664, 191, 661, 718, 1609, 1431, 127, 646, 7, 1761, 1249, 895, 451, 508,
	661, 601, 629, 541, 1193, 1751, 1912, 162, 1791, 1267, 302, 950, 949, 604, 835, 361,
	451, 1611, 1833, 61, 1846, 1426, 664, 994, 1764, 606, 953, 1352, 2066, 1231, 824, 1764,
	641, 1993, 167, 789, 2058, 1761, 1556, 567, 945, 862, 1302, 1741, 1789, 158, 289, 576,
	1809, 389, 2063, 411, 186, 626, 1898, 217, 254, 289, 1869, 1686, 141, 664, 1831, 1741,
	1284, 567, 872, 1791, 311, 626, 1842, 1276, 701, 1312, 1807, 188, 896, 1556, 1818, 1849,
	276, 286, 1186, 2027, 674, 1137, 1878, 629, 1284, 389, 1909, 1836, 1509, 664, 1874, 8,
	1856, 702, 774, 1737, 1226, 299, 452, 1771, 376, 291, 1771, 1426, 1236, 1238, 11, 264,
	1127, 317, 814, 1599, 636, 1397, 566, 1749, 1814, 381, 1239, 197, 644, 674, 567, 1639,
	162, 0, 0, 106, 1639, 896, 629, 96, 1861, 1828, 1842, 604, 975, 622, 1957, 842,
	882, 1767, 1062, 1761, 1027, 1819, 844, 897, 887, 447, 289, 179, 1257, 1238, 1759, 639,
	1027, 1744, 383, 764, 1817, 157, 1846, 1358, 328, 1744, 1599, 1761, 662, 234, 616, 689,
	2009, 1119, 1761, 1887, 842, 158, 209, 844, 1839, 917, 1062, 1887, 1571, 1743, 1929, 651,
	1887, 1993, 812, 1119, 1061, 0, 0, 1717, 627, 1841, 1327, 1559, 1122, 653, 627, 1774,
	1841, 1056, 1677, 1677, 379, 729, 1871, 683, 1241, 1884, 241, 602, 627, 1872, 387, 542,
	794, 241, 1717, 1672, 1717, 912, 542, 1346, 1384, 877, 509, 542, 1601, 542, 1672, 1864,
	542, 1842, 634, 1278, 1868, 557, 1872, 912, 3836, 1868, 1316, 542, 1677, 1717, 1872, 1336,
	761, 449, 1872, 1872, 1814, 0, 1672, 1672, 1677, 929, 629, 1839, 617, 902, 902, 1673,
	1814, 1673, 1656, 1504, 1278, 899, 1399, 1811, 1894, 1717, 476, 1869, 1736, 531, 1238, 1837,
	2819, 1291, 1291, 1969, 1959, 294, 1289, 1749, 1471, 784, 2663, 1282, 1119, 1029, 641, 647,
	1978, 1978, 38, 1806, 1667, 1313, 427, 706, 746, 1687, 2916, 429, 59, 1606, 723, 614,
	2069, 746, 69, 1777, 319, 676, 644, 774, 318, 676, 651, 1607, 844, 29, 1739, 427,
	2019, 1266, 1208, 1611, 791, 1331, 1608, 1976, 1692, 461, 1262, 329, 514, 1097, 1221, 1236,
	681, 1821, 447, 24, 884, 1326, 1039, 736, 504, 1804, 27, 318, 174, 877, 1994, 449,
	601, 1979, 222, 801, 888, 888, 897, 24, 284, 49, 0, 1777, 354, 644, 739, 977,
	237, 188, 833, 456, 1841, 599, 371, 1954, 447, 526, 1827, 383, 383, 533, 147, 1822,
	1842, 407, 504, 1872, 337, 1767, 743, 1478, 1513, 389, 94, 329, 592, 1814, 768, 280,
	1479, 294, 718, 562, 1068, 13, 1776, 1754, 1874, 41, 1221, 29, 1839, 1844, 559, 1794,
	222, 137, 493, 6, 1232, 417, 1344, 1858, 1809, 647, 319, 952, 819, 1799, 182, 1817,
	671, 1957, 869, 869, 1278, 182, 606, 104, 1507, 1806, 541, 681, 1833, 1104, 344, 1869,
	104, 1814, 1337, 1584, 1237, 1316, 1708, 694, 913, 1971, 751, 193, 351, 284, 1609, 13,
	113, 1516, 63, 1754, 1977, 383, 1839, 1977, 1839, 1222, 641, 2023, 1282, 1444, 694, 1097,
	761, 739, 1612, 791, 1099, 651, 371, 673, 466, 1869, 389, 1232, 509, 1674, 839, 0,
	1812, 1294, 0, 14, 1609, 384, 1068, 1671, 182, 1841, 632, 69, 854, 541, 337, 2009,
	599, 48, 48, 1867, 316, 1032, 666, 1402, 389, 494, 721, 2036, 1867, 622, 389, 1827,
	1819, 49, 642, 977, 162, 363, 1692, 13, 432, 1984, 669, 1966, 431, 466, 213, 653,
	1262, 833, 1759, 621, 837, 369, 0, 1796, 644, 642, 774, 1847, 1596, 182, 1858, 718,
	1574, 1574, 1507, 994, 1598, 1728, 182, 1672, 1612, 1344, 1983, 844, 1232, 1212, 3926, 1904,
	371, 1642, 1739, 182, 1806, 477, 1969, 9, 496, 1817, 723, 1642, 1872, 1884, 1769, 884,
	553, 818, 162, 1232, 64, 177, 899, 898, 1193, 1294, 977, 1029, 2006, 1538, 1517, 893,
	187, 959, 76, 679, 1281, 1519, 337, 1946, 724, 1856, 329, 178, 1976, 1744, 364, 1298,
	1312, 316, 1476, 1039, 261, 1819, 1598, 1926, 461, 1297, 857, 0, 2019, 1301, 1926, 1791,
	1474, 1474, 27, 1278, 774, 353, 412, 1344, 1029, 376, 376, 2061, 319, 1504, 384, 384,
	1607, 314, 1738, 427, 622, 1607, 280, 1834, 1994, 651, 24, 1297, 641, 1301, 743, 1839,
	1237, 69, 329, 656, 1833, 1856, 702, 1607, 813, 694, 614, 294, 1358, 1294, 1806, 653,
	1743, 574, 459, 1811, 1514, 567, 1402, 674, 833, 784, 897, 1817, 1607, 1717, 614, 888,
	888, 1409, 844, 852, 1358, 576, 1806, 1817, 833, 29, 0, 1509, 1372, 0, 2014, 2014,
	1501, 1836, 954, 737, 1994, 2014, 602, 602, 793, 1836, 602, 1794, 793, 1514, 963, 266,
	1514, 1836, 1978, 506, 2704, 659, 431, 54, 0, 74, 1581, 1346, 877, 449, 274, 1749,
	1784, 0, 1392, 1749, 787, 1741, 1704, 1874, 1874, 1574, 381, 381, 1834, 1317, 0, 504,
	504, 1284, 989, 989, 1842, 638, 179, 2779, 1914, 1641, 1604, 446, 774, 1826, 1821, 561,
	473, 1506, 58, 1604, 1667, 1818, 68, 1837, 766, 646, 382, 0, 783, 1884, 646, 1196,
	396, 852, 619, 319, 1818, 1219, 1338, 3782, 1054, 434, 531, 429, 328, 0, 787, 2044,
	619, 1284, 716, 1934, 2556, 1839, 658, 1619, 1904, 58, 1741, 1758, 421, 331, 1809, 746,
	329, 24, 1486, 1728, 1208, 24, 1739, 24, 658, 852, 382, 1881, 658, 1509, 429, 639,
	54, 902, 173, 1168, 1147, 341, 1053, 1291, 651, 1596, 688, 1152, 149, 3068, 1751, 414,
	644, 1554, 1397, 421, 1714, 592, 2011, 449, 946, 286, 1374, 446, 679, 1817, 1744, 1722,
	1981, 1196, 364, 644, 746, 1984, 1826, 674, 1882, 1004, 1221, 1168, 1879, 2011, 1131, 1819,
	1049, 1771, 427, 68, 1867, 1693, 431, 1707, 417, 1738, 1869, 531, 364, 27, 1096, 1987,
	2027, 1951, 277, 1098, 1708, 1668, 1797, 1977, 386, 979, 1029, 1281, 69, 1496, 1309, 386,
	572, 1793, 407, 1971, 1012, 39, 1038, 447, 877, 2033, 2033, 1508, 1353, 1471, 16, 957,
	668, 506, 1559, 1779, 1718, 2031, 694, 1471, 1256, 1374, 1827, 1662, 656, 1516, 642, 456,
	1478, 637, 696, 661, 504, 1038, 651, 651, 1837, 1102, 1977, 641, 641, 1754, 587, 526,
	706, 766, 11, 1017, 869, 1224, 1744, 1864, 1817, 149, 1751, 1841, 188, 533, 1337, 2031,
	1561, 1716, 592, 1697, 892, 1814, 1363, 661, 902, 1261, 1754, 1484, 843, 182, 1764, 962,
	0, 1591, 1738, 1718, 739, 234, 234, 1657, 1107, 1777, 1057, 1867, 1049, 1221, 1581, 696,
	1496, 1979, 557, 319, 2011, 387, 1257, 1684, 559, 998, 1737, 1817, 1738, 6, 1817, 1867,
	1559, 1867, 1696, 844, 1752, 691, 1333, 2019, 1281, 1752, 2016, 351, 161, 899, 1812, 386,
	386, 892, 997, 242, 1222, 692, 1267, 113, 877, 1708, 78, 1761, 1516, 1283, 626, 449,
	1733, 1733, 1607, 421, 0, 667, 1641, 1097, 699, 679, 631, 676, 1292, 329, 1779, 604,
	1706, 807, 69, 1841, 1986, 234, 449, 679, 912, 14, 812, 791, 1842, 1814, 0, 844,
	328, 1752, 0, 609, 1846, 157, 1498, 1657, 294, 1828, 1739, 1059, 1419, 648, 1666, 1794,
	1867, 1716, 1637, 1392, 978, 286, 1403, 1311, 0, 1736, 1292, 226, 967, 449, 668, 366,
	1741, 1984, 977, 622, 997, 11, 1846, 1796, 0, 1716, 979, 1874, 1966, 1326, 1509, 1769,
	1693, 854, 969, 1353, 1556, 1241, 1719, 1696, 689, 602, 23, 0, 48, 1791, 1666, 531,
	202, 1827, 1239, 1742, 1872, 1849, 1387, 1398, 186, 882, 978, 1207, 23, 946, 504, 789,
	1312, 649, 1443, 1966, 1872, 146, 1387, 1017, 1847, 642, 1574, 1113, 1752, 1616, 1212, 817,
	1068, 47, 9, 1239, 1257, 1839, 1247, 1869, 832, 1797, 959, 1836, 1946, 726, 1856, 1099,
	842, 317, 531, 1816, 674, 2006, 162, 134, 556, 1084, 824, 1027, 1956, 604, 604, 24,
	1084, 1297, 946, 1254, 506, 1738, 1302, 384, 1474, 622, 1752, 1752, 1029, 862, 852, 609,
	531, 311, 1977, 1791, 0, 607, 1741, 789, 1363, 1741, 1819, 157, 661, 978, 414, 411,
	1818, 1839, 1719, 664, 998, 1509, 69, 1474, 1584, 1297, 852, 617, 0, 1113, 353, 1839,
	126, 9, 1107, 1127, 946, 1647, 197, 674, 237, 1867, 1257, 0, 1791, 1053, 1819, 1602,
	1846, 117, 1113, 0, 1847, 997, 67, 1027, 1498, 1779, 1099, 362, 882, 1867, 813, 1819,
	1536, 877, 663, 1107, 813, 1751, 1846, 1536, 1837, 1337, 993, 844, 902, 1817, 1992, 813,
	2035, 667, 702, 702, 753, 1884, 2031, 2034, 267, 1586, 447, 54, 2031, 1764, 1774, 989,
	1559, 1601, 46, 644, 506, 1147, 1802, 0, 2008, 552, 902, 1586, 1066, 1006, 2036, 1291,
	1517, 157, 1814, 2031, 1098, 446, 2031, 842, 1802, 99, 1397, 1052, 1119, 1119, 1846, 902,
	997, 3627, 1388, 1596, 533, 1937, 1322, 1868, 1513, 11, 1672, 1564, 1707, 1394, 1828, 592,
	1837, 678, 967, 994, 1993, 294, 592, 2036, 521, 1989, 344, 1708, 4337, 48, 1507, 1507,
	193, 1498, 739, 1796, 1509, 1864, 619, 1837, 1648, 1508, 1754, 496, 182, 706, 496, 1761,
	1893, 1934, 48, 554, 1819, 1761, 646, 1498, 177, 1387, 623, 994, 759, 776, 86, 1574,
	113, 667, 644, 1871, 644, 1842, 994, 759, 1316, 1344, 1966, 653, 449, 1127, 94, 617,
	979, 1313, 557, 1869, 1507, 1127, 674, 1127, 1979, 1868, 48, 776, 1127, 1313, 1029, 147,
	694, 513, 1313, 604, 1739, 862, 1507, 1127, 1939, 1498, 1718, 1768, 776, 629, 862, 1293,
	617, 1839, 1837, 48, 1314, 193, 48, 431, 269, 374, 1559, 1807, 298, 924, 374, 1514,
	1268, 431, 2006, 446, 1489, 739, 3156, 656, 2006, 1719, 2061, 1807, 1519, 374, 298, 1763,
	869, 3983, 403, 403, 403, 453, 651, 1516, 177, 1479, 1479, 0, 452, 162, 864, 1753,
	1753, 0, 1862, 1711, 1862, 864, 864, 1827, 963, 1711, 1711, 1711, 454, 1827, 384, 789,
	193, 689, 461, 508, 461, 1682, 461, 461, 1506, 1843, 188, 731, 1097, 3174, 4218, 1114,
	692, 1239, 142, 1744, 66, 691, 669, 1642, 1331, 1639, 669, 1736, 333, 1506, 1508, 1262,
	641, 1769, 177, 1744, 1097, 1943, 1741, 0, 1718, 386, 894, 93, 1639, 424, 1518, 1769,
	1672, 923, 923, 1743, 142, 923, 694, 1769, 694, 701, 862, 702, 1518, 1744, 128, 1687,
	1099, 1471, 0, 1751, 844, 1801, 296, 0, 887, 1839, 1283, 1374, 1739, 559, 1471, 1868,
	201, 1584, 1283, 0, 1879, 38, 1828, 17, 1812, 1739, 667, 389, 642, 1291, 426, 1707,
	1282, 137, 137, 1282, 149, 669, 1331, 468, 1754, 24, 812, 298, 26, 2067, 2069, 1823,
	694, 466, 738, 503, 1804, 1266, 844, 1647, 691, 1817, 437, 1789, 648, 878, 1692, 1221,
	23, 284, 784, 1879, 1331, 604, 1201, 1012, 14, 1647, 878, 318, 1262, 351, 1944, 786,
	1862, 968, 1662, 1802, 1839, 1256, 572, 26, 919, 387, 449, 1807, 337, 899, 398, 402,
	456, 1337, 354, 1837, 1038, 1507, 11, 1716, 587, 1979, 994, 843, 641, 1662, 533, 1863,
	1479, 1747, 843, 1827, 664, 1971, 902, 661, 387, 387, 1869, 1832, 101, 1304, 1346, 431,
	431, 1067, 843, 1862, 1754, 592, 298, 1771, 182, 1672, 493, 709, 569, 1747, 1841, 1868,
	819, 723, 822, 807, 1753, 1344, 751, 192, 192, 1599, 0, 607, 691, 807, 1282, 1012,
	791, 791, 2047, 509, 261, 1812, 1812, 468, 912, 912, 877, 702, 381, 1971, 541, 1842,
	351, 557, 1971, 1716, 1762, 69, 1816, 1561, 667, 61, 2047, 702, 351, 1943, 509, 1842,
	2031, 1914, 622, 1867, 1703, 1822, 431, 1327, 378, 1637, 1838, 1979, 1509, 1893, 1828, 389,
	1994, 1944, 924, 1818, 978, 1754, 641, 641, 618, 1657, 1504, 977, 1294, 1739, 1867, 2036,
	812, 667, 1817, 1817, 1718, 2036, 147, 1584, 1387, 736, 1311, 1867, 738, 893, 1672, 371,
	1741, 1726, 121, 294, 592, 667, 7, 882, 1739, 1561, 1301, 2031, 1717, 61, 326, 272,
	1293, 1858, 1119, 236, 642, 0, 1419, 1563, 2036, 1299, 862, 0, 158, 337, 136, 343,
	1671, 893, 1949, 1943, 1943, 22, 127, 1331, 1296, 2056, 2058, 298, 298, 1742, 1869, 97,
	887, 1758, 142, 96, 1311, 661, 1818, 822, 1944, 872, 862, 862, 1312, 314, 384, 2061,
	664, 702, 1827, 1302, 1827, 702, 1941, 1839, 1802, 1067, 1834, 1834, 1838, 389, 1753, 642,
	1769, 738, 1741, 319, 24, 2059, 0, 1837, 1387, 298, 878, 1887, 1868, 1879, 1843, 0,
	1887, 844, 1741, 887, 887, 326, 1387, 1741, 692, 157, 1848, 786, 1817, 1716, 1067, 1337,
	168, 257, 902, 326, 326, 1119, 1817, 1817, 1818, 1067, 1818, 211, 534, 211, 1986, 621,
	676, 1807, 167, 167, 866, 496, 2068, 1303, 694, 498, 0, 1736, 0, 0, 2649, 1327,
	1327, 643, 1838, 1559, 26, 1976, 1951, 1759, 1837, 673, 1809, 1759, 0, 1809, 671, 447,
	1886, 69, 1509, 104, 341, 1529, 411, 1119, 1506, 426, 1199, 1978, 1741, 604, 177, 1717,
	1949, 1613, 284, 949, 1224, 1199, 1651, 447, 852, 1979, 1988, 97, 1979, 319, 1029, 1839,
	1839, 1262, 1289, 699, 1397, 1529, 284, 1974, 1544, 1304, 1966, 1506, 1347, 1742, 41, 284,
	531, 197, 1262, 1949, 651, 1706, 284, 1717, 162, 1464, 1282, 1912, 542, 969, 363, 599,
	1974, 1791, 994, 1717, 1734, 447, 1839, 41, 1262, 0, 496, 1207, 623, 1616, 994, 649,
	1632, 626, 1981, 1496, 959, 1039, 76, 542, 1912, 1039, 41, 1949, 678, 158, 447, 1979,
	601, 411, 217, 69, 69, 0, 994, 1301, 156, 427, 987, 41, 197, 1009, 202, 667,
	1753, 812, 2961, 1262, 1102, 651, 94, 94, 1779, 464, 1826, 619, 1864, 1861, 643, 528,
	1238, 1656, 134, 528, 2011, 1030, 1319, 69, 1312, 1687, 217, 533, 1813, 34, 669, 1794,
	897, 1738, 0, 764, 4349, 318, 1217, 329, 1811, 1004, 491, 239, 448, 1662, 1212, 424,
	1757, 1838, 1979, 1647, 1979, 1786, 2864, 2069, 1764, 1672, 533, 764, 962, 1657, 1862, 101,
	93, 181, 807, 51, 641, 11, 1519, 726, 1856, 1693, 1561, 1519, 1318, 1869, 1868, 1004,
	1566, 134, 1756, 424, 689, 572, 531, 884, 1464, 852, 817, 1566, 1816, 1273, 1318, 689,
	689, 673, 22, 799, 892, 1844, 864, 284, 899, 1839, 202, 157, 1672, 1556, 1771, 1004,
	163, 1738, 424, 528, 0, 774, 69, 1449, 1769, 873, 873, 862, 897, 0, 1848, 1753,
	1656, 1856, 842, 1656, 1843, 1807, 1817, 1657, 317, 1269, 654, 627, 1053, 627, 498, 1104,
	716, 74, 1839, 1284, 3639, 428, 693, 1818, 1839, 2011, 69, 1839, 1836, 404, 1431, 1509,
	404, 1509, 1509, 496, 334, 1843, 496, 447, 592, 1736, 1682, 187, 659, 29, 1498, 319,
	1946, 702, 1616, 448, 318, 992, 1752, 602, 166, 1148, 679, 1968, 1837, 993, 1336, 1706,
	1481, 1419, 1796, 679, 376, 1946, 659, 1297, 1232, 2789, 3797, 69, 69, 1489, 289, 653,
	504, 476, 406, 69, 756, 0, 84, 1761, 289, 541, 1297, 592, 992, 541, 1706, 702,
	644, 1839, 531, 2791, 899, 899, 1679, 629, 1979, 629, 629, 1837, 1837, 1837, 1837, 1876,
	1876, 1471, 1777, 1722, 1662, 1819, 1819, 1869, 186, 113, 76, 331, 86, 1232, 1858, 1246,
	1946, 1848, 186, 189, 2027, 1693, 642, 1212, 1981, 1839, 1712, 174, 68, 318, 878, 437,
	1713, 1971, 252, 1504, 679, 2784, 1741, 1809, 583, 1822, 612, 924, 599, 1696, 183, 1979,
	1792, 679, 1672, 242, 0, 807, 242, 2802, 1202, 1743, 0, 644, 162, 1979, 242, 1986,
	807, 1869, 1769, 669, 654, 1508, 649, 74, 622, 449, 1807, 1718, 1212, 1827, 1716, 1741,
	1971, 1249, 1637, 302, 1971, 1971, 84, 302, 191, 174, 663, 629, 661, 626, 977, 888,
	1756, 49, 1332, 1771, 1771, 69, 1839, 829, 1372, 296, 344, 458, 644, 1373, 1372, 159,
	1608, 1624, 1624, 461, 1284, 1604, 268, 1979, 1714, 962, 1741, 412, 1846, 1643, 1012, 1012,
	1981, 191, 1739, 642, 1738, 1284, 1834, 1861, 1707, 241, 1561, 774, 1869, 74, 1979, 1509,
	264, 177, 1604, 1687, 1292, 1104, 632, 1781, 1133, 1713, 1751, 1771, 726, 601, 719, 429,
	612, 1604, 1563, 1738, 1194, 164, 219, 694, 1839, 48, 166, 1012, 1221, 2069, 1923, 1824,
	504, 39, 1149, 1067, 1971, 1199, 104, 1651, 509, 604, 251, 277, 852, 1556, 196, 319,
	284, 1837, 1671, 1862, 446, 642, 1231, 1779, 1874, 1097, 519, 447, 1744, 69, 1864, 1309,
	1799, 241, 93, 623, 1879, 204, 1236, 1519, 1741, 1606, 1858, 2038, 374, 0, 0, 1839,
	188, 1374, 1807, 1509, 1741, 823, 587, 781, 1037, 1978, 1767, 854, 1646, 623, 337, 568,
	753, 533, 587, 1741, 1764, 1519, 0, 768, 1786, 1824, 629, 627, 189, 647, 1837, 1781,
	519, 874, 626, 2034, 1794, 188, 1758, 1169, 584, 396, 739, 354, 1642, 496, 1337, 4241,
	1289, 1879, 1231, 743, 302, 629, 2889, 1786, 1664, 1816, 718, 134, 1068, 1884, 962, 1858,
	1858, 696, 1236, 793, 1303, 1879, 1869, 1672, 669, 1741, 1957, 872, 1639, 559, 569, 1309,
	1639, 104, 1839, 1294, 628, 1741, 54, 957, 1836, 586, 1563, 1336, 182, 786, 1739, 1739,
	1861, 842, 857, 619, 241, 1839, 1879, 844, 1122, 1068, 389, 1344, 1797, 1291, 1739, 1013,
	242, 423, 51, 302, 264, 164, 984, 844, 644, 523, 524, 1779, 299, 1281, 751, 1643,
	914, 1741, 723, 791, 1099, 1317, 197, 376, 543, 1941, 676, 1708, 1871, 671, 644, 872,
	1869, 639, 572, 1337, 1607, 1639, 1639, 1116, 1713, 234, 601, 631, 1741, 1613, 1771, 1717,
	629, 389, 1408, 2038, 1752, 1858, 329, 694, 118, 182, 302, 54, 1309, 117, 289, 524,
	384, 1068, 1884, 1758, 2019, 337, 622, 228, 1322, 1368, 1776, 134, 73, 1013, 2036, 1637,
	1303, 197, 54, 1796, 1719, 477, 1291, 1718, 1869, 1867, 69, 1872, 619, 1013, 69, 1839,
	998, 1858, 1309, 1476, 1841, 389, 177, 1034, 477, 739, 1867, 9, 1309, 1819, 1164, 463,
	1884, 244, 1426, 839, 429, 0, 789, 789, 1344, 496, 1882, 1574, 1574, 1282, 1827, 1563,
	623, 642, 508, 694, 219, 1099, 1767, 718, 1973, 1858, 128, 1809, 1499, 97, 719, 1874,
	1744, 634, 1858, 1823, 844, 1441, 1616, 1841, 237, 1794, 1294, 1604, 621, 1884, 1499, 1018,
	0, 1489, 1906, 1246, 1039, 1039, 542, 189, 118, 117, 117, 261, 1013, 1624, 1946, 1664,
	24, 1538, 959, 524, 1344, 1909, 689, 629, 718, 852, 1194, 1563, 673, 1844, 924, 1476,
	1719, 1677, 957, 1291, 1489, 1856, 1319, 726, 319, 1977, 892, 699, 1281, 1281, 1869, 1262,
	862, 241, 1861, 191, 1979, 1664, 181, 1284, 1331, 1232, 54, 81, 227, 661, 1926, 189,
	852, 1262, 789, 629, 1302, 182, 1844, 1844, 1743, 1743, 289, 1607, 383, 374, 374, 844,
	702, 134, 1761, 412, 429, 822, 824, 191, 556, 1284, 1752, 1013, 678, 862, 1738, 118,
	702, 254, 1754, 1608, 1502, 69, 1839, 204, 1751, 1067, 289, 1608, 678, 1561, 559, 661,
	1704, 699, 353, 1312, 1312, 694, 128, 743, 1769, 1849, 24, 969, 1839, 873, 1449, 709,
	612, 984, 813, 9, 873, 1816, 799, 1749, 1979, 1868, 1844, 281, 989, 9, 987, 374,
	644, 1028, 812, 984, 197, 1979, 1164, 1164, 1816, 1823, 47, 1979, 784, 783, 1861, 446,
	882, 1009, 182, 0, 159, 988, 813, 612, 1797, 1359, 159, 644, 694, 616, 1489, 1839,
	854, 1058, 992, 1613, 702, 469, 469, 469, 476, 1879, 1739, 651, 1791, 1519, 1387, 1744,
	182, 1733, 669, 476, 651, 1296, 639, 1296, 1944, 354, 1281, 647, 337, 476, 647, 643,
	1977, 721, 642, 787, 459, 313, 1944, 1296, 476, 653, 667, 1869, 653, 1842, 899, 601,
	1944, 1744, 1744, 231, 284, 1332, 604, 604, 604, 389, 1509, 844, 968, 604, 844, 417,
	1593, 73, 329, 681, 1478, 1837, 1838, 3974, 604, 421, 1818, 1513, 1513, 112, 4431, 1327,
	829, 1276, 26, 2778, 1376, 447, 0, 1894, 1691, 1949, 1113, 727, 1866, 761, 559, 1496,
	146, 1691, 1284, 759, 1739, 1691, 1291, 1977, 1374, 799, 982, 1443, 1822, 1133, 39, 173,
	1363, 1741, 1292, 36, 647, 1867, 447, 24, 1741, 1236, 1978, 667, 389, 379, 1953, 182,
	644, 1883, 782, 74, 166, 691, 1723, 602, 1879, 702, 2528, 1314, 1968, 1973, 1883, 1707,
	1149, 1839, 1516, 1996, 1272, 1667, 358, 729, 4457, 1272, 448, 1216, 27, 23, 1912, 1677,
	756, 911, 1298, 0, 604, 49, 93, 1978, 1231, 1352, 101, 1236, 1602, 1828, 1968, 1931,
	1821, 49, 571, 1098, 1834, 318, 189, 1236, 1886, 3528, 979, 176, 1811, 196, 1309, 1013,
	204, 646, 447, 1933, 1993, 2786, 151, 1038, 1101, 801, 448, 1216, 39, 1201, 876, 1047,
	518, 1292, 694, 1694, 27, 1691, 1691, 2523, 691, 2026, 1209, 1951, 34, 34, 318, 1098,
	694, 799, 888, 653, 0, 1856, 812, 3627, 96, 1912, 1291, 582, 799, 1509, 667, 1973,
	1373, 498, 498, 1337, 1531, 267, 1886, 733, 1837, 1767, 134, 626, 1256, 2004, 1507, 1047,
	1119, 187, 514, 1979, 799, 383, 383, 1978, 1309, 14, 1139, 1969, 477, 664, 769, 354,
	1397, 4146, 869, 1931, 923, 337, 1696, 702, 0, 693, 1979, 902, 1814, 1996, 1599, 1767,
	1067, 293, 663, 1974, 643, 626, 1752, 1868, 2506, 1691, 1162, 274, 97, 493, 1638, 1969,
	182, 1591, 1591, 676, 977, 889, 692, 1232, 653, 1839, 1658, 1471, 1417, 1708, 1767, 146,
	431, 663, 1738, 709, 689, 1663, 793, 189, 1672, 2026, 1272, 922, 26, 559, 1481, 1116,
	696, 1489, 1563, 1832, 2027, 103, 1707, 104, 2064, 1839, 843, 923, 1566, 1691, 821, 1588,
	41, 653, 619, 298, 0, 1709, 1312, 1233, 1488, 869, 1012, 982, 448, 33, 694, 297,
	1733, 7, 698, 1879, 2038, 176, 222, 667, 1673, 56, 1049, 1103, 1417, 2067, 1734, 667,
	1751, 1948, 326, 1443, 911, 1319, 466, 381, 1514, 334, 1273, 318, 1948, 634, 643, 1616,
	1286, 1282, 1202, 1517, 1291, 879, 1834, 1814, 702, 1974, 858, 514, 1098, 639, 1474, 1973,
	909, 113, 1609, 174, 91, 666, 1639, 754, 1681, 1818, 274, 2041, 692, 1644, 1292, 744,
	31, 1197, 666, 898, 516, 1019, 0, 1979, 288, 986, 156, 1441, 524, 1234, 1874, 1164,
	653, 1966, 1862, 653, 1867, 1817, 787, 1058, 591, 1392, 66, 1716, 1426, 2044, 1796, 1002,
	1637, 1116, 146, 189, 2038, 1969, 1836, 1549, 622, 74, 1822, 619, 1818, 1898, 13, 1791,
	1814, 1734, 737, 208, 644, 319, 802, 804, 182, 716, 686, 686, 1672, 666, 626, 493,
	193, 1554, 1487, 1766, 1872, 654, 1832, 146, 1931, 54, 1827, 0, 64, 813, 1724, 1314,
	156, 476, 893, 2038, 491, 663, 504, 1314, 1858, 1344, 196, 206, 1943, 1588, 1586, 97,
	204, 1388, 44, 271, 1441, 736, 1827, 298, 1976, 1149, 801, 651, 1566, 1328, 473, 1796,
	1554, 1438, 674, 1009, 389, 222, 1164, 1471, 1694, 667, 1612, 1207, 36, 276, 844, 1616,
	761, 1979, 511, 607, 1291, 1724, 1298, 1642, 1966, 389, 1767, 1164, 1337, 147, 1934, 1099,
	1738, 399, 1489, 498, 1489, 1516, 33, 1827, 89, 1566, 1606, 1424, 158, 1591, 686, 191,
	216, 516, 94, 432, 1526, 319, 1284, 0, 1936, 1103, 1612, 186, 524, 899, 919, 893,
	2038, 1741, 604, 1931, 218, 1614, 609, 261, 1096, 1027, 656, 531, 1849, 1977, 22, 1979,
	1119, 959, 159, 756, 201, 1489, 1677, 1951, 1026, 1027, 1957, 156, 746, 1246, 659, 1827,
	504, 1291, 864, 641, 1846, 701, 1251, 3751, 821, 376, 1754, 1402, 1719, 1898, 1839, 1752,
	181, 181, 3921, 1067, 589, 1556, 559, 622, 276, 2063, 1103, 873, 182, 626, 2014, 663,
	643, 126, 1609, 288, 174, 96, 173, 702, 1761, 861, 59, 448, 1304, 96, 271, 2027,
	2009, 1693, 1276, 1314, 376, 1103, 0, 1767, 898, 663, 256, 1599, 559, 1304, 1996, 653,
	463, 1856, 832, 1163, 898, 1474, 2027, 1912, 1276, 234, 641, 293, 1593, 126, 1317, 1317,
	619, 666, 1312, 773, 286, 1767, 711, 1238, 99, 24, 694, 1834, 0, 986, 1568, 992,
	643, 1602, 2027, 298, 1778, 813, 106, 693, 1834, 1398, 1834, 1834, 1098, 604, 642, 89,
	1127, 476, 1979, 667, 799, 1027, 654, 1767, 804, 1606, 33, 1568, 898, 909, 1363, 1977,
	1206, 1823, 834, 109, 1516, 1898, 1103, 1798, 709, 636, 844, 809, 618, 1847, 897, 888,
	1291, 1291, 1898, 1291, 812, 1751, 1846, 977, 1358, 156, 0, 256, 1767, 1489, 917, 709,
	992, 186, 1898, 902, 1606, 2054, 844, 326, 1696, 293, 663, 702, 813, 844, 1063, 1976,
	1976, 533, 1281, 1807, 1276, 1276, 1511, 733, 1861, 458, 1838, 496, 461, 36, 419, 1974,
	97, 326, 759, 1013, 1739, 509, 477, 134, 1764, 993, 1511, 477, 317, 1794, 664, 1013,
	177, 689, 1969, 1692, 1868, 189, 22, 34, 1794, 3164, 382, 853, 1119, 69, 163, 328,
	382, 1839, 463, 3934, 736, 1819, 376, 641, 1668, 1764, 381, 663, 679, 1822, 1747, 1013,
	4019, 7, 1301, 7, 1973, 317, 1969, 446, 1519, 862, 1331, 1784, 1743, 663, 1474, 663,
	2027, 1839, 853, 69, 1602, 1764, 1764, 1722, 1802, 1282, 1282, 1936, 86, 702, 1936, 0,
	423, 36, 36, 812, 1867, 812, 1718, 2858, 1501, 864, 648, 602, 1767, 648, 1868, 1966,
	664, 1734, 1668, 204, 671, 189, 1842, 448, 1296, 1943, 1332, 2027, 1943, 369, 2027, 1556,
	1771, 2027, 2027, 1312, 872, 2027, 204, 369, 1992, 416, 1769, 562, 1867, 1506, 1224, 1862,
	0, 1212, 1282, 1941, 967, 923, 1224, 1236, 882, 446, 418, 1797, 676, 676, 1098, 2047,
	1954, 1838, 882, 1481, 654, 0, 1838, 1282, 1979, 411, 1246, 411, 1941, 774, 1584, 1867,
	1737, 644, 644, 644, 639, 1384, 289, 689, 1978, 1908, 1767, 1646, 1807, 1794, 451, 802,
	464, 559, 1602, 319, 1867, 158, 1507, 784, 1822, 1507, 1714, 1012, 1012, 1686, 226, 1738,
	1882, 54, 17, 1914, 38, 667, 791, 1501, 604, 418, 569, 534, 161, 1796, 1017, 631,
	426, 1313, 601, 1839, 1741, 1771, 1817, 1914, 418, 1607, 1499, 694, 1822, 1898, 93, 1776,
	1849, 1799, 1269, 1968, 877, 226, 569, 979, 2067, 1029, 74, 1794, 631, 1951, 244, 1509,
	1508, 1869, 424, 337, 968, 1099, 163, 1721, 351, 8, 93, 17, 1989, 887, 1753, 592,
	1648, 167, 1507, 3123, 623, 1798, 787, 766, 663, 674, 1979, 674, 1478, 1662, 593, 1819,
	456, 1759, 1469, 1763, 1834, 4381, 626, 557, 559, 709, 1708, 1754, 791, 1989, 1741, 1504,
	1502, 101, 1957, 1956, 1739, 559, 629, 569, 177, 1708, 1643, 2027, 2059, 1988, 1278, 678,
	1741, 1473, 1098, 1741, 1317, 1283, 676, 533, 1968, 1839, 1979, 13, 1708, 872, 859, 161,
	1714, 1763, 1899, 421, 1796, 1798, 1837, 1747, 1881, 626, 448, 1013, 787, 1831, 1849, 363,
	1718, 1518, 1317, 969, 1057, 653, 1153, 14, 1822, 226, 1827, 1593, 674, 1017, 663, 718,
	569, 1728, 164, 1284, 569, 1819, 844, 9, 644, 534, 983, 1899, 1769, 569, 1039, 1029,
	241, 1099, 1946, 629, 49, 559, 1797, 2006, 862, 1751, 1608, 678, 1253, 872, 1686, 1743,
	1839, 644, 624, 1604, 1834, 1834, 844, 1607, 1662, 1763, 424, 1607, 1954, 569, 1839, 1759,
	1776, 1451, 663, 49, 679, 1819, 9, 1834, 1516, 1518, 987, 1806, 1829, 1279, 844, 177,
	784, 337, 0, 1819, 639, 897, 1741, 1387, 887, 1063, 918, 902, 1469, 1613, 1818, 202,
	1876, 648, 3831, 1834, 2994, 1834, 601, 572, 1516, 127, 127, 0, 959, 142, 2642, 1639,
	2059, 1896, 1794, 629, 1843, 1309, 426, 1237, 1879, 1863, 1403, 1232, 36, 447, 877, 1224,
	1332, 0, 1169, 1648, 1554, 1969, 817, 818, 696, 1017, 621, 1714, 1686, 2667, 1281, 1281,
	1846, 2036, 1714, 1662, 818, 0, 987, 887, 1039, 313, 1719, 1029, 58, 1932, 1519, 1519,
	0, 1991, 1372, 26, 1269, 383, 383, 296, 844, 533, 641, 686, 68, 1788, 1656, 239,
	1461, 1372, 1887, 1337, 1291, 1867, 2963, 1736, 146, 1471, 1807, 412, 1739, 2033, 843, 1779,
	112, 266, 1374, 1482, 1691, 384, 1949, 962, 189, 1839, 508, 496, 364, 1979, 1283, 1519,
	469, 1647, 1039, 1471, 1709, 807, 0, 962, 1822, 948, 1003, 1559, 1872, 562, 424, 51,
	667, 351, 473, 1828, 1751, 203, 226, 1197, 1516, 609, 1771, 1133, 1994, 1513, 1561, 38,
	1561, 642, 1879, 674, 504, 641, 967, 1237, 69, 1713, 19, 416, 427, 1839, 447, 1057,
	1741, 604, 1811, 358, 1772, 1968, 1826, 872, 1409, 389, 977, 1954, 543, 1976, 241, 1882,
	1886, 1501, 1516, 1908, 0, 844, 604, 653, 182, 496, 1296, 431, 1057, 1761, 1966, 761,
	1262, 1837, 1743, 1978, 518, 1761, 649, 646, 501, 447, 1029, 1839, 1834, 1834, 1509, 1119,
	1236, 1692, 384, 877, 93, 1097, 801, 572, 1207, 414, 1981, 284, 237, 1821, 449, 33,
	1033, 461, 1281, 1353, 1392, 969, 1951, 1561, 1959, 1747, 1864, 1496, 534, 1694, 2069, 1057,
	1127, 1858, 318, 1979, 2048, 147, 289, 506, 0, 689, 21, 447, 653, 96, 384, 736,
	1054, 1994, 69, 883, 152, 1934, 1559, 1994, 1222, 1509, 518, 147, 1804, 181, 1974, 1509,
	1976, 883, 1038, 844, 1387, 1934, 0, 76, 1944, 1979, 887, 354, 897, 0, 844, 812,
	1858, 1519, 1807, 1531, 1284, 1966, 1281, 844, 1837, 1757, 1969, 844, 1574, 511, 721, 56,
	1374, 4264, 33, 1373, 94, 2031, 197, 1839, 239, 1793, 1991, 654, 2059, 402, 403, 1863,
	407, 498, 733, 823, 1941, 844, 0, 1824, 572, 486, 1976, 1509, 477, 1891, 902, 447,
	667, 587, 534, 1617, 529, 1717, 3284, 1397, 14, 11, 699, 1837, 2026, 761, 1979, 1322,
	1662, 1436, 1436, 617, 667, 689, 1804, 384, 2019, 461, 1898, 0, 1846, 1548, 0, 1944,
	1811, 1362, 1966, 294, 1281, 1302, 609, 534, 658, 2011, 1807, 1591, 1461, 1966, 51, 1656,
	511, 679, 1270, 59, 447, 1407, 1663, 702, 1741, 817, 883, 431, 1281, 1723, 1761, 463,
	1574, 857, 1327, 1658, 1863, 977, 41, 889, 1231, 2011, 319, 696, 1672, 1909, 21, 509,
	69, 1639, 557, 2033, 1976, 1374, 54, 493, 653, 619, 1708, 1049, 646, 1647, 644, 1761,
	923, 617, 1481, 177, 427, 1561, 989, 1737, 842, 842, 359, 1311, 1848, 1591, 692, 1636,
	1769, 793, 2026, 1516, 1817, 414, 1718, 679, 842, 91, 1749, 0, 1617, 1979, 807, 852,
	653, 2027, 877, 842, 1284, 93, 1687, 241, 1316, 997, 1282, 1282, 113, 539, 157, 1624,
	423, 1202, 44, 1272, 631, 2036, 182, 1908, 642, 844, 1232, 1869, 1869, 509, 632, 354,
	1612, 466, 1713, 319, 1741, 412, 1971, 1944, 1283, 1871, 1818, 1869, 699, 1839, 1451, 1373,
	222, 837, 1281, 2026, 447, 736, 807, 2041, 2041, 1954, 521, 426, 427, 1496, 1322, 1119,
	1708, 543, 899, 567, 666, 1838, 199, 693, 692, 182, 264, 857, 1296, 1977, 2016, 1811,
	691, 51, 661, 2027, 2034, 86, 1232, 344, 203, 161, 982, 606, 653, 531, 1744, 362,
	1294, 299, 542, 328, 917, 1976, 1339, 1019, 448, 0, 94, 1943, 0, 1693, 1451, 366,
	1831, 444, 1718, 1716, 369, 648, 2036, 1752, 1837, 1966, 1742, 1819, 1818, 212, 651, 226,
	1868, 572, 1931, 1734, 1242, 447, 1826, 639, 1791, 1419, 1822, 1834, 1817, 58, 632, 786,
	669, 787, 1556, 431, 1766, 1693, 642, 654, 1039, 969, 203, 763, 601, 854, 837, 1657,
	1057, 1867, 1862, 977, 1563, 1799, 1799, 1846, 1966, 1242, 337, 642, 667, 1834, 203, 1548,
	1867, 249, 1716, 977, 1639, 642, 667, 718, 1326, 1847, 1392, 587, 892, 829, 1337, 0,
	1258, 1509, 459, 1607, 813, 1721, 1867, 179, 922, 693, 1497, 0, 0, 1769, 648, 1839,
	1943, 447, 1054, 994, 817, 1387, 508, 654, 693, 1596, 471, 1966, 43, 1461, 1872, 2033,
	1017, 1574, 649, 1827, 667, 623, 464, 423, 1934, 1292, 948, 1588, 1872, 1769, 1387, 1507,
	1976, 261, 1721, 1657, 882, 1387, 1612, 1344, 1936, 1556, 1504, 1599, 736, 1741, 508, 1281,
	473, 473, 1586, 1207, 1616, 477, 1807, 326, 1144, 642, 1554, 504, 222, 1296, 147, 1294,
	612, 977, 1794, 469, 471, 2027, 1694, 0, 1824, 1966, 648, 654, 2059, 298, 531, 86,
	1991, 0, 1742, 1283, 852, 629, 1856, 1294, 543, 459, 459, 1677, 609, 1281, 1451, 261,
	64, 1863, 602, 658, 604, 619, 534, 1119, 1839, 471, 726, 531, 531, 127, 959, 673,
	317, 2011, 829, 817, 177, 241, 842, 1786, 1317, 1538, 412, 1661, 524, 644, 1591, 833,
	898, 857, 994, 892, 167, 1574, 572, 201, 1612, 76, 899, 686, 1519, 1931, 1516, 1946,
	957, 3527, 1113, 1824, 1647, 1232, 1994, 1461, 1741, 1337, 587, 651, 241, 0, 638, 1297,
	0, 1846, 404, 1772, 1977, 1302, 2056, 242, 1278, 1519, 609, 789, 1311, 2061, 1879, 1474,
	1741, 1807, 329, 406, 463, 1027, 1738, 1301, 1362, 874, 882, 1302, 1754, 1414, 412, 1474,
	1692, 823, 1882, 1549, 376, 181, 1612, 987, 692, 182, 1574, 702, 702, 1607, 629, 641,
	1162, 1759, 1693, 1128, 1408, 1991, 1662, 1926, 427, 1847, 1353, 587, 137, 506, 883, 824,
	471, 202, 1743, 0, 0, 0, 476, 356, 676, 898, 0, 0, 1872, 1599, 1444, 656,
	1607, 873, 1137, 1843, 1742, 1584, 1471, 2059, 1797, 181, 464, 691, 2059, 1839, 1312, 1278,
	1817, 832, 431, 628, 294, 644, 1584, 99, 69, 343, 203, 1996, 534, 642, 668, 648,
	1317, 1937, 653, 1297, 298, 1838, 78, 1561, 1486, 873, 844, 147, 987, 1842, 1617, 1602,
	997, 1282, 0, 86, 639, 644, 1291, 1098, 1127, 1838, 473, 654, 1844, 1164, 1318, 1818,
	1282, 994, 1954, 534, 226, 641, 787, 1266, 314, 202, 0, 997, 1861, 1979, 529, 1291,
	833, 833, 1424, 898, 844, 257, 922, 1009, 629, 1191, 922, 1979, 471, 362, 1872, 844,
	424, 1994, 1568, 852, 0, 202, 0, 1991, 897, 1817, 844, 1991, 179, 667, 389, 1571,
	612, 1119, 1869, 887, 809, 0, 1754, 0, 693, 1761, 877, 1846, 651, 1843, 1862, 1847,
	1756, 1137, 97, 157, 812, 693, 1536, 1489, 1741, 244, 1337, 1332, 122, 0, 1869, 917,
	844, 257, 902, 293, 702, 0, 813, 812, 1992, 832, 843, 29, 1062, 1869, 877, 521,
	1294, 239, 616, 1771, 1867, 1869, 1291, 1191, 1791, 166, 204, 186, 719, 1836, 702, 1741,
	1791, 571, 1869, 789, 857, 778, 1554, 1741, 8, 1281, 1281, 1791, 209, 1311, 778, 723,
	778, 723, 213, 1464, 0, 1841, 1771, 1766, 1867, 1294, 1761, 1837, 476, 1736, 1609, 674,
	1191, 601, 1639, 616, 1791, 1226, 1743, 1764, 1791, 1741, 0, 556, 204, 1839, 1753, 1867,
	234, 616, 1978, 1974, 238, 104, 1738, 1282, 104, 104, 1701, 694, 1292, 1979, 1449, 188,
	1449, 1983, 1584, 1584, 844, 274, 1868, 844, 531, 283, 283, 1558, 651, 1957, 1723, 1029,
	1826, 1029, 252, 1821, 1643, 1501, 284, 1476, 1794, 1809, 1516, 117, 1317, 1248, 1289, 1327,
	1574, 679, 1883, 854, 1839, 443, 1977, 1816, 117, 631, 286, 642, 1834, 0, 1883, 1721,
	199, 89, 1639, 674, 1476, 1842, 1113, 254, 629, 259, 1839, 286, 364, 656, 854, 89,
	362, 1291, 651, 1516, 1191, 369, 1994, 1841, 1319, 1839, 1461, 1304, 737, 1762, 709, 329,
	628, 628, 508, 1344, 641, 1839, 1191, 628, 369, 1836, 1761, 1737, 524, 1038, 978, 978,
	8, 668, 362, 1869, 68, 69, 69, 1237, 1237, 69, 157, 967, 0, 0, 1237, 967,
	646, 1941, 1426, 1039, 1694, 1807, 403, 1387, 1753, 692, 1037, 567, 1327, 359, 0, 1608,
	1222, 692, 384, 264, 66, 1431, 0, 969, 1582, 1516, 1866, 1694, 572, 654, 1599, 1431,
	922, 1027, 967, 1662, 1388, 163, 1278, 900, 1941, 1444, 1941, 987, 900, 1332, 337, 1509,
	318, 1012, 702, 962, 1284, 1251, 1053, 1284, 296, 1751, 211, 426, 1384, 1049, 0, 447,
	1496, 351, 1316, 1284, 1841, 1741, 554, 1823, 11, 1814, 739, 1316, 1814, 351, 289, 924,
	1317, 1823, 1881, 1881, 1543, 1543, 1973, 91, 1858, 294, 0, 829, 1099, 1688, 414, 533,
	1656, 1976, 1327, 26, 1914, 998, 256, 629, 331, 559, 149, 2027, 214, 1707, 414, 1604,
	1741, 1691, 962, 1327, 1284, 1474, 1204, 559, 1291, 1736, 1736, 1809, 1559, 1398, 498, 656,
	187, 1736, 1673, 0, 1611, 1976, 1978, 1291, 994, 508, 1711, 678, 678, 1409, 706, 592,
	1604, 1338, 642, 74, 74, 464, 1724, 1981, 416, 1781, 702, 603, 0, 1284, 427, 1794,
	1794, 1314, 1837, 1734, 1882, 1872, 564, 1818, 177, 177, 328, 1862, 379, 604, 639, 1281,
	1039, 1392, 977, 1599, 998, 1739, 191, 1641, 68, 1461, 1978, 1224, 1209, 2033, 1886, 501,
	882, 3477, 1912, 431, 1194, 844, 912, 121, 431, 1717, 604, 1029, 979, 1519, 693, 1898,
	1694, 1692, 384, 572, 844, 993, 187, 1266, 424, 1862, 1642, 1979, 1953, 506, 1941, 1817,
	1556, 784, 683, 691, 1769, 1327, 1839, 646, 1981, 1337, 2597, 629, 994, 56, 2027, 1992,
	829, 1861, 506, 592, 461, 408, 968, 1559, 601, 1231, 238, 414, 1979, 1574, 1129, 181,
	877, 3719, 96, 1284, 1559, 1097, 692, 1879, 1994, 1501, 834, 1799, 1804, 446, 1209, 1013,
	1604, 1821, 643, 1858, 524, 64, 1777, 887, 897, 289, 919, 1769, 1266, 1912, 676, 1842,
	1986, 667, 1839, 626, 627, 2058, 182, 1841, 533, 599, 654, 1822, 869, 1559, 644, 402,
	562, 447, 1423, 1593, 1978, 1841, 1737, 1743, 733, 1991, 659, 919, 0, 14, 354, 1837,
	1032, 833, 1836, 993, 1337, 671, 1029, 1718, 1762, 1769, 592, 1794, 1574, 781, 1617, 667,
	694, 403, 1986, 1399, 1262, 1807, 1781, 1979, 526, 617, 1017, 637, 1696, 1289, 1204, 1736,
	1331, 882, 1839, 646, 679, 1293, 656, 661, 1966, 1506, 2027, 134, 0, 774, 644, 882,
	158, 632, 603, 1137, 1807, 674, 869, 1327, 1718, 1959, 709, 557, 41, 962, 2027, 1862,
	1741, 97, 359, 619, 592, 1839, 1278, 1848, 813, 569, 819, 558, 843, 491, 447, 1737,
	854, 227, 432, 1839, 1869, 1662, 822, 553, 674, 646, 191, 1858, 978, 1582, 176, 1224,
	1754, 1499, 1672, 794, 1264, 1119, 464, 676, 1761, 1489, 1103, 1671, 1858, 1764, 1752, 1658,
	387, 1574, 1686, 696, 137, 1639, 844, 1544, 1559, 834, 1544, 1616, 737, 824, 807, 852,
	1717, 1731, 1882, 619, 317, 0, 1414, 654, 4448, 1449, 447, 524, 1779, 1514, 1534, 1812,
	234, 1949, 1834, 751, 1734, 557, 1691, 351, 572, 1731, 691, 1489, 857, 631, 1599, 2026,
	329, 1309, 302, 698, 2031, 1741, 1762, 1282, 508, 543, 1816, 872, 1613, 1986, 1233, 569,
	161, 1516, 1281, 416, 1977, 899, 1069, 691, 1617, 242, 834, 1959, 1262, 422, 1561, 1643,
	1239, 289, 1869, 1099, 1866, 899, 464, 994, 679, 877, 912, 1842, 264, 1332, 612, 1869,
	1104, 1496, 601, 227, 601, 1871, 807, 3134, 1316, 1816, 1293, 1641, 1003, 1978, 1843, 994,
	56, 1871, 1724, 1419, 421, 1316, 1871, 738, 644, 1489, 1871, 1449, 899, 2034, 362, 0,
	654, 998, 1239, 1741, 1867, 1871, 1498, 1499, 1392, 619, 1993, 653, 1153, 1867, 1327, 1657,
	1332, 364, 431, 1931, 97, 1734, 1731, 319, 1716, 1721, 1397, 1769, 134, 1719, 572, 468,
	1818, 592, 1799, 993, 738, 967, 1846, 1818, 1862, 591, 1003, 1503, 978, 1891, 632, 1054,
	533, 189, 389, 1204, 977, 854, 1284, 1284, 977, 1642, 249, 1717, 116, 1676, 998, 629,
	1029, 1793, 644, 1227, 651, 654, 602, 434, 1756, 1839, 1844, 1944, 1507, 666, 1966, 622,
	1609, 1867, 66, 1013, 1506, 1671, 1501, 1858, 692, 1984, 0, 1326, 663, 0, 1816, 1611,
	887, 639, 1872, 1057, 39, 1863, 1337, 2016, 859, 842, 48, 227, 1119, 2031, 1706, 1506,
	958, 1847, 239, 789, 0, 654, 1794, 923, 1717, 459, 0, 0, 1266, 674, 1819, 1612,
	1872, 1593, 1872, 852, 1828, 989, 2023, 1504, 739, 1604, 1598, 1696, 3381, 501, 1441, 1017,
	1934, 1507, 1839, 914, 432, 1278, 1716, 844, 112, 1739, 1741, 1721, 1296, 1912, 1506, 1574,
	1837, 1966, 1566, 1882, 1789, 1841, 1387, 634, 1574, 1594, 1099, 1596, 1506, 1399, 1718, 1209,
	204, 202, 1211, 1728, 121, 1009, 477, 326, 569, 624, 1744, 2031, 317, 1979, 1777, 448,
	667, 607, 476, 2033, 1616, 1632, 1581, 69, 664, 629, 538, 1842, 569, 887, 1979, 1819,
	1489, 958, 1847, 227, 924, 814, 902, 0, 86, 1606, 1869, 1786, 604, 69, 76, 1979,
	658, 759, 1499, 1476, 316, 994, 22, 898, 603, 601, 1862, 158, 412, 1856, 538, 958,
	1319, 1867, 3746, 642, 1812, 167, 1281, 1743, 644, 899, 892, 887, 673, 542, 241, 894,
	1977, 459, 1297, 842, 1818, 127, 664, 241, 227, 1676, 1194, 1632, 1833, 1742, 994, 1612,
	1029, 1476, 559, 852, 813, 531, 842, 461, 432, 1797, 1836, 959, 2034, 963, 726, 919,
	1231, 1519, 1948, 1946, 192, 1794, 619, 638, 654, 1816, 1538, 862, 261, 1637, 1824, 656,
	242, 1848, 592, 1788, 1519, 524, 1847, 1761, 0, 0, 1794, 854, 1979, 1717, 1239, 1869,
	664, 1266, 294, 629, 667, 1738, 1197, 642, 1206, 1717, 1574, 1292, 1292, 1744, 899, 1744,
	1809, 1687, 622, 1013, 1414, 1574, 823, 1926, 1981, 1839, 1979, 1706, 289, 1607, 167, 1807,
	789, 0, 1484, 1672, 1991, 1423, 576, 69, 1471, 157, 157, 1518, 1662, 1278, 872, 1717,
	1449, 1449, 182, 684, 182, 609, 661, 824, 174, 463, 266, 678, 1556, 1519, 1232, 559,
	1882, 881, 594, 449, 569, 607, 1752, 654, 1471, 1744, 0, 0, 812, 0, 1867, 873,
	998, 1908, 291, 619, 1912, 1769, 1869, 843, 1509, 1764, 877, 1709, 2031, 1856, 774, 119,
	853, 329, 1834, 24, 617, 1966, 157, 959, 288, 289, 1839, 1584, 1239, 694, 1599, 674,
	641, 2027, 852, 1137, 1731, 674, 427, 1449, 642, 1581, 629, 203, 1599, 1561, 343, 1449,
	1993, 809, 86, 852, 993, 1506, 1519, 994, 1129, 1847, 1847, 987, 674, 1282, 1239, 644,
	567, 1397, 264, 559, 1616, 1844, 1843, 374, 237, 604, 679, 814, 709, 8, 1277, 2027,
	1717, 86, 508, 1896, 1847, 0, 799, 958, 0, 0, 654, 789, 919, 1899, 924, 844,
	1861, 1823, 898, 1559, 667, 1847, 362, 528, 626, 1769, 1207, 1498, 76, 157, 1009, 882,
	651, 1279, 1449, 182, 508, 86, 639, 1754, 897, 1311, 559, 1847, 1387, 844, 679, 1761,
	1847, 1583, 374, 1769, 612, 569, 1991, 887, 809, 374, 412, 602, 809, 0, 0, 1847,
	992, 644, 854, 654, 1848, 429, 872, 1839, 651, 1879, 157, 284, 1357, 653, 812, 412,
	1539, 1871, 2027, 431, 1489, 833, 814, 242, 1332, 1856, 1292, 408, 524, 1344, 1819, 569,
	1847, 1423, 1899, 902, 1819, 842, 993, 289, 1606, 293, 663, 157, 0, 569, 29, 1992,
	813, 814, 1062, 1706, 902, 1337, 1753, 1819, 464, 1819, 1869, 638, 638, 1009, 526, 311,
	626, 1761, 1761, 0, 592, 877, 1909, 2009, 688, 1934, 1769, 189, 2027, 1891, 1891, 119,
	1822, 1284, 496, 428, 1133, 683, 1722, 1269, 1839, 897, 221, 1236, 719, 1209, 1817, 719,
	1214, 1039, 168, 864, 1341, 729, 379, 526, 1771, 1979, 526, 526, 1718, 1299, 0, 277,
	648, 1971, 1992, 738, 1954, 447, 27, 1769, 384, 879, 2027, 1799, 694, 1609, 1219, 683,
	1217, 1602, 1602, 93, 1821, 1661, 556, 1994, 4434, 328, 1717, 1507, 854, 189, 784, 0,
	601, 1554, 814, 1656, 663, 1794, 562, 1337, 869, 619, 1822, 1786, 1786, 1753, 1842, 1736,
	1986, 1827, 1509, 534, 1662, 1804, 1891, 739, 591, 824, 1289, 1992, 1798, 1971, 1278, 1816,
	627, 526, 1937, 626, 733, 0, 412, 1481, 1834, 629, 0, 1614, 674, 1369, 0, 1741,
	447, 683, 174, 1278, 1656, 2027, 1658, 1707, 553, 1231, 818, 1818, 1794, 431, 189, 1387,
	602, 0, 1861, 574, 1806, 764, 702, 1761, 1741, 1816, 559, 2014, 709, 319, 1957, 642,
	1739, 0, 0, 557, 1819, 619, 984, 692, 299, 54, 427, 874, 791, 634, 1687, 1741,
	264, 1737, 591, 168, 448, 1874, 661, 241, 434, 1261, 1321, 1419, 1742, 1322, 1771, 2026,
	1819, 1819, 1839, 702, 1869, 469, 1352, 1237, 508, 0, 1501, 164, 1481, 0, 0, 0,
	0, 177, 477, 787, 1984, 369, 1749, 626, 434, 854, 1796, 1776, 622, 1326, 651, 69,
	1846, 1993, 1718, 1676, 1641, 1741, 1153, 1153, 449, 1816, 683, 683, 1869, 977, 1464, 1719,
	1932, 1774, 1322, 1392, 977, 619, 1794, 1954, 1716, 412, 1327, 1584, 1822, 869, 1993, 0,
	1258, 511, 46, 602, 1881, 1746, 0, 0, 71, 504, 1684, 1612, 168, 1471, 396, 97,
	623, 1767, 1744, 1739, 1741, 1884, 736, 574, 1741, 1883, 1782, 1052, 1474, 0, 1829, 1806,
	1018, 852, 1847, 1738, 1387, 499, 0, 1299, 881, 1741, 69, 76, 241, 899, 651, 4017,
	1839, 892, 432, 1581, 1839, 1631, 702, 2039, 1884, 604, 1837, 1979, 22, 1719, 862, 559,
	1869, 1369, 683, 959, 0, 1476, 259, 1926, 651, 1741, 1743, 1741, 1839, 1761, 189, 622,
	288, 1834, 1292, 1352, 1819, 1751, 1302, 2061, 311, 379, 1496, 661, 427, 1556, 862, 1869,
	872, 1662, 1481, 426, 412, 1819, 1807, 814, 629, 1614, 1839, 678, 984, 0, 0, 1847,
	1869, 1839, 1802, 812, 284, 1909, 119, 1584, 1839, 1344, 241, 852, 628, 1992, 1769, 877,
	1719, 1839, 1767, 1954, 629, 1599, 1137, 812, 1791, 1753, 733, 1806, 674, 197, 299, 1829,
	574, 814, 1002, 1387, 844, 1029, 49, 1419, 922, 804, 22, 1809, 623, 1554, 0, 844,
	897, 702, 864, 1819, 1741, 1769, 887, 1834, 0, 1358, 1879, 814, 242, 664, 192, 524,
	0, 174, 992, 1613, 814, 1992, 813, 877, 259, 1869, 4498, 0, 1197, 1971, 1217, 181,
	1872, 9, 1717, 0, 702, 702, 449, 1832, 29, 336, 1832, 1827, 2048, 1538, 403, 1207,
	217, 476, 1901, 337, 1296, 1857, 1297, 1244, 38, 1209, 1482, 651, 1202, 362, 216, 1867,
	1932, 71, 337, 43, 97, 216, 1863, 0, 362, 1812, 181, 1132, 0, 1259, 687, 1032,
	1596, 1038, 822, 1374, 962, 416, 967, 1039, 466, 1739, 1817, 476, 2033, 1559, 654, 508,
	1789, 476, 1501, 1038, 318, 1291, 1337, 1337, 2034, 1624, 1741, 962, 746, 1291, 1738, 509,
	1741, 842, 842, 1273, 641, 466, 1977, 56, 1337, 1412, 362, 694, 646, 651, 431, 1241,
	736, 1013, 734, 202, 1744, 54, 919, 669, 947, 1431, 1719, 842, 376, 1662, 473, 659,
	1741, 809, 362, 869, 29, 1246, 97, 1741, 196, 1718, 787, 196, 1338, 1338, 27, 414,
	1327, 643, 152, 232, 14, 476, 2014, 528, 948, 1862, 729, 97, 598, 1812, 1842, 616,
	2014, 1883, 782, 1133, 317, 1374, 1981, 1039, 54, 1236, 694, 1337, 1501, 1217, 1747, 1692,
	602, 879, 424, 1236, 1098, 23, 1864, 503, 1804, 691, 289, 97, 509, 1753, 1127, 617,
	583, 663, 572, 1954, 642, 1809, 1474, 1599, 1387, 1514, 1662, 823, 362, 1747, 1506, 774,
	1971, 1869, 1586, 1867, 69, 962, 1742, 699, 842, 1747, 1842, 1576, 817, 54, 1979, 1817,
	1461, 844, 559, 1753, 676, 1202, 421, 1761, 33, 1282, 1097, 76, 807, 807, 869, 651,
	1296, 791, 1819, 543, 2039, 992, 161, 1836, 1979, 1971, 1812, 988, 111, 254, 1486, 869,
	0, 917, 602, 2036, 644, 1718, 431, 1731, 1872, 1776, 1991, 966, 1719, 211, 1754, 1676,
	1814, 1067, 1769, 646, 597, 71, 1862, 1862, 977, 147, 1827, 1586, 97, 1017, 607, 1872,
	1566, 948, 1872, 281, 1869, 1506, 567, 0, 1839, 1966, 1298, 567, 959, 679, 658, 1029,
	1946, 157, 22, 22, 567, 261, 427, 702, 69, 69, 622, 1276, 872, 1794, 1662, 1761,
	862, 1744, 1761, 1514, 0, 664, 477, 699, 362, 629, 774, 1753, 1769, 1598, 1753, 1806,
	1127, 1257, 639, 1397, 987, 869, 1861, 528, 1514, 897, 1598, 1754, 992, 1357, 616, 1067,
	917, 1753, 1282, 702, 1797, 1004, 2031, 3424, 897, 1869, 1574, 1712, 1327, 453, 341, 829,
	26, 641, 592, 319, 211, 461, 688, 1867, 1283, 1868, 1822, 948, 496, 1738, 446, 1012,
	669, 1812, 426, 74, 44, 1879, 702, 1883, 702, 1707, 651, 977, 286, 1257, 1718, 617,
	1754, 1296, 877, 284, 1834, 461, 1262, 329, 49, 1797, 1743, 96, 238, 503, 646, 1951,
	1269, 237, 736, 1352, 1501, 1496, 1602, 2048, 646, 1012, 1471, 883, 69, 1966, 1966, 702,
	409, 887, 671, 664, 654, 844, 526, 1751, 1986, 498, 1816, 1789, 1822, 1793, 919, 1574,
	1991, 1312, 744, 1807, 443, 403, 1758, 1827, 1289, 587, 531, 191, 1794, 36, 1224, 0,
	291, 1779, 632, 1722, 387, 182, 319, 1738, 1737, 182, 709, 977, 54, 1658, 1754, 203,
	557, 1797, 1817, 1327, 1799, 817, 843, 1789, 447, 882, 1812, 1741, 877, 844, 671, 853,
	1593, 0, 0, 1708, 329, 1257, 1943, 264, 1012, 1869, 691, 176, 807, 1722, 1504, 1717,
	328, 204, 2027, 1222, 181, 603, 1282, 389, 791, 161, 1282, 63, 1708, 899, 242, 523,
	1818, 331, 54, 872, 1312, 1237, 1197, 1344, 2027, 1312, 409, 0, 1322, 363, 669, 632,
	1868, 969, 977, 226, 1796, 1637, 1776, 284, 1392, 1012, 651, 1718, 1403, 619, 1767, 211,
	1292, 2009, 1822, 854, 1337, 1747, 369, 1874, 1832, 1068, 602, 1846, 1867, 622, 1409, 1449,
	882, 0, 1387, 1593, 1827, 1884, 1736, 671, 674, 1847, 948, 1616, 882, 1612, 844, 817,
	531, 1644, 1296, 271, 702, 1953, 1827, 9, 86, 1672, 162, 791, 2006, 241, 673, 1836,
	263, 241, 1282, 842, 1848, 167, 1327, 1797, 22, 853, 982, 1946, 1842, 0, 1846, 1979,
	899, 1737, 311, 0, 142, 1807, 1332, 294, 872, 862, 702, 1574, 622, 531, 1277, 678,
	412, 671, 882, 641, 0, 1318, 9, 69, 119, 1332, 1908, 291, 663, 1884, 1608, 774,
	617, 1449, 1584, 1642, 0, 1868, 674, 447, 86, 197, 1724, 264, 812, 1743, 2031, 1797,
	1403, 639, 459, 832, 362, 844, 1979, 1392, 845, 1899, 1322, 1936, 531, 1584, 804, 887,
	897, 844, 1899, 814, 1846, 992, 1756, 1767, 524, 298, 1899, 617, 511, 97, 337, 1217,
	604, 1977, 1247, 39, 1357, 844, 1698, 1507, 656, 1291, 413, 1227, 418, 288, 1729, 1191,
	426, 967, 1687, 602, 877, 1837, 1262, 237, 33, 699, 162, 186, 0, 294, 988, 104,
	222, 1262, 71, 1989, 1966, 842, 237, 1847, 1284, 1752, 893, 319, 1191, 987, 2006, 64,
	874, 1929, 1738, 1239, 286, 1729, 1846, 1818, 461, 284, 1499, 1642, 1642, 556, 162, 1501,
	1317, 1496, 158, 158, 1407, 1501, 1571, 1451, 1859, 1528, 899, 448, 1858, 62, 434, 1127,
	1642, 1862, 648, 1496, 1932, 329, 447, 1057, 329, 1261, 1658, 609, 341, 1969, 1891, 987,
	69, 1282, 884, 1807, 882, 164, 1038, 1882, 414, 447, 491, 1642, 669, 669, 1338, 1719,
	447, 1642, 1038, 1642, 1209, 656, 1696, 277, 1057, 882, 58, 1968, 204, 1038, 1038, 134,
	1642, 456, 69, 277, 1979, 909, 1282, 909, 1206, 1836, 411, 609, 1867, 1867, 1038, 709,
	1839, 882, 1867, 337, 197, 609, 291, 2019, 641, 1708, 656, 1502, 164, 1678, 832, 641,
	146, 882, 337, 1678, 874, 656, 656, 197, 99, 337, 337, 1238, 1119, 289, 1516, 1516,
	1979, 1837, 217, 1053, 341, 68, 666, 862, 496, 476, 689, 1988, 1749, 1474, 1791, 1159,
	844, 1822, 179, 1862, 26, 669, 702, 1282, 1746, 264, 69, 1839, 844, 2039, 216, 431,
	1994, 1219, 1237, 461, 386, 236, 1834, 1282, 288, 1968, 407, 1978, 1632, 691, 642, 424,
	691, 329, 646, 1797, 1934, 94, 1099, 1974, 1856, 679, 1337, 192, 1661, 1837, 666, 1718,
	627, 383, 1823, 189, 1979, 582, 1813, 979, 359, 679, 1761, 1664, 1671, 962, 1238, 1761,
	1576, 1276, 844, 1979, 272, 382, 1739, 1461, 822, 1514, 619, 1752, 1839, 61, 1949, 523,
	1607, 424, 947, 947, 186, 644, 1643, 11, 1979, 69, 69, 631, 509, 371, 386, 1718,
	1866, 264, 1813, 1992, 254, 289, 1499, 1983, 1979, 1869, 597, 431, 804, 1822, 1499, 1672,
	1868, 541, 1722, 619, 764, 648, 1841, 1839, 894, 1444, 702, 189, 1741, 521, 1839, 1721,
	642, 216, 36, 629, 882, 154, 1514, 1159, 326, 277, 83, 1606, 1949, 76, 1499, 254,
	918, 1839, 2039, 196, 1949, 1939, 1569, 1593, 1342, 334, 894, 894, 1029, 1312, 1843, 1848,
	622, 447, 862, 887, 1302, 882, 822, 1752, 424, 289, 1844, 574, 7, 36, 654, 521,
	534, 1137, 1869, 1716, 1839, 1856, 1238, 833, 844, 1518, 286, 873, 329, 873, 809, 83,
	644, 186, 1823, 1798, 666, 1971, 0, 844, 639, 809, 644, 326, 1798, 1848, 1843, 1332,
	1856, 1606, 326, 918, 902, 902, 96, 0, 533, 27, 406, 311, 406, 32, 33, 1307,
	1909, 1909, 1909, 969, 2805, 1196, 666, 622, 531, 238, 877, 471, 1029, 642, 663, 1233,
	471, 7, 387, 569, 559, 69, 1708, 197, 1294, 1741, 7, 1201, 569, 624, 569, 1912,
	263, 569, 1763, 1834, 1267, 569, 663, 9, 1776, 624, 844, 1248, 574, 664, 1237, 463,
	1219, 1989, 706, 1327, 266, 1344, 1931, 508, 706, 706, 1989, 1931, 508, 1943, 362, 1013,
	1283, 1847, 1867, 51, 1951, 1981, 1227, 572, 1847, 572, 1839, 96, 1708, 572, 19, 1943,
	1817, 3151, 572, 1867, 786, 414, 459, 299, 1207, 448, 1327, 4004, 299, 899, 1943, 987,
	843, 674, 1794, 651, 1207, 524, 11, 897, 1518, 1986, 294, 11, 1817, 844, 1039, 341,
	463, 1791, 962, 962, 1977, 1284, 1403, 1797, 4256, 378, 1312, 1744, 1209, 431, 379, 1012,
	1017, 1503, 1509, 633, 999, 1206, 418, 1003, 286, 977, 969, 3224, 1039, 756, 1509, 1821,
	1974, 1863, 1496, 1794, 279, 1968, 784, 691, 1499, 1837, 1503, 979, 1029, 1994, 1966, 1966,
	997, 316, 1871, 1979, 1099, 2034, 2034, 168, 1933, 1799, 93, 993, 887, 1581, 354, 991,
	337, 1837, 403, 1017, 1549, 186, 784, 699, 1032, 1969, 1649, 1822, 1818, 1029, 1984, 954,
	4460, 1971, 977, 1591, 1484, 559, 618, 319, 183, 271, 699, 387, 1708, 1754, 1741, 794,
	809, 653, 1473, 1643, 539, 1709, 839, 1509, 1322, 869, 1812, 676, 1971, 842, 809, 1584,
	699, 1544, 1581, 361, 69, 69, 1039, 631, 1099, 899, 471, 667, 113, 1988, 1866, 631,
	949, 1749, 1778, 1741, 539, 0, 228, 651, 977, 363, 597, 1796, 1644, 787, 471, 1409,
	969, 1794, 406, 379, 1002, 198, 789, 991, 1726, 759, 294, 176, 736, 1568, 1746, 1872,
	969, 1017, 957, 1809, 1912, 1949, 1839, 331, 756, 1029, 1549, 241, 891, 186, 957, 1248,
	181, 531, 987, 619, 1549, 1251, 1741, 1302, 1277, 1993, 314, 1498, 1549, 863, 174, 1752,
	724, 1834, 1804, 1662, 1737, 872, 534, 654, 1834, 9, 629, 1941, 653, 508, 1954, 1332,
	1717, 198, 126, 1128, 1806, 1829, 639, 987, 997, 1257, 997, 844, 784, 702, 1796, 998,
	639, 897, 987, 887, 524, 958, 1743, 204, 1613, 724, 1993, 967, 671, 872, 1869, 1554,
	1912, 702, 1508, 1838, 1498, 1976, 597, 1498, 1848, 693, 1986, 663, 272, 368, 8, 663,
	1926, 1876, 29, 1507, 344, 1284, 641, 2033, 461, 1739, 1691, 761, 466, 1741, 412, 784,
	294, 948, 1461, 286, 702, 844, 446, 1012, 1163, 1791, 729, 1978, 1284, 723, 669, 1256,
	389, 1814, 1236, 1957, 1817, 1584, 2006, 171, 379, 1206, 1819, 0, 431, 408, 1029, 1933,
	2046, 1869, 736, 1596, 1692, 318, 1939, 1966, 9, 424, 1038, 1994, 802, 71, 1148, 1264,
	1231, 877, 1219, 806, 1269, 96, 1269, 1496, 1887, 9, 844, 887, 1662, 0, 844, 784,
	203, 746, 1337, 1991, 781, 531, 389, 1067, 642, 899, 629, 9, 919, 743, 1777, 1817,
	354, 1231, 1741, 0, 592, 1554, 1747, 1301, 0, 1719, 1302, 0, 746, 1761, 764, 159,
	817, 592, 1867, 1761, 1747, 963, 889, 1858, 171, 1639, 1734, 882, 1849, 962, 1344, 1819,
	1461, 793, 508, 0, 606, 898, 178, 653, 1174, 1561, 2027, 1296, 1232, 1818, 222, 751,
	1971, 1282, 2039, 1316, 872, 1862, 96, 344, 1012, 331, 651, 574, 899, 9, 1584, 1344,
	877, 51, 1842, 374, 1738, 1282, 912, 1708, 328, 466, 54, 1284, 178, 1403, 1817, 337,
	341, 1990, 1731, 667, 1846, 73, 739, 69, 1719, 1554, 1966, 369, 1747, 294, 1637, 1068,
	1234, 653, 319, 1609, 147, 1966, 1284, 0, 431, 1796, 1344, 1344, 948, 496, 1103, 1574,
	387, 237, 884, 1559, 1612, 44, 607, 1236, 788, 1438, 833, 271, 1642, 647, 1741, 852,
	1207, 1719, 1883, 371, 1957, 736, 802, 0, 1319, 538, 2006, 654, 1284, 22, 1231, 899,
	898, 724, 218, 178, 1843, 833, 76, 1284, 3527, 1284, 261, 2036, 1319, 234, 0, 641,
	1474, 822, 1332, 1926, 314, 654, 1744, 872, 344, 1607, 622, 1207, 1887, 1301, 316, 844,
	0, 661, 1743, 1948, 1302, 376, 653, 24, 2019, 572, 639, 1937, 832, 738, 203, 642,
	1344, 294, 1839, 656, 1236, 1236, 1867, 86, 1284, 9, 719, 651, 1869, 1403, 987, 1219,
	237, 97, 0, 1009, 108, 1752, 784, 833, 833, 1979, 844, 844, 412, 1344, 1219, 1846,
	844, 887, 887, 1029, 97, 1536, 524, 812, 2054, 1817, 1509, 1282, 843, 1377, 1489, 1829,
	1559, 1282, 1596, 949, 669, 1826, 1751, 1282, 1282, 1978, 61, 374, 1984, 0, 1836, 1507,
	1864, 1977, 1951, 447, 449, 994, 2048, 1976, 1579, 979, 2069, 1331, 604, 1994, 1497, 1584,
	237, 152, 992, 923, 1868, 1757, 1737, 1646, 1249, 1991, 533, 1747, 1976, 644, 474, 1966,
	474, 1544, 671, 1499, 456, 793, 319, 298, 639, 1616, 1282, 509, 524, 2059, 877, 899,
	93, 3174, 298, 1977, 899, 157, 51, 1958, 706, 1863, 1744, 1841, 2031, 639, 1966, 447,
	1872, 1737, 1872, 1476, 1637, 1836, 977, 1556, 319, 0, 2027, 1966, 1847, 644, 474, 1612,
	1556, 949, 1796, 0, 1796, 1282, 1869, 1743, 641, 1559, 157, 289, 629, 1582, 843, 1137,
	1098, 298, 844, 1357, 1879, 1637, 1899, 834, 1392, 1868, 1867, 842, 1769, 1312, 572, 1671,
	1789, 1556, 1372, 1671, 2033, 147, 463, 1839, 1751, 93, 1102, 1326, 1326, 4483, 428, 967,
	1882, 736, 1003, 1976, 676, 68, 1976, 1869, 994, 764, 39, 1236, 1097, 844, 1862, 2046,
	1236, 97, 877, 1029, 184, 1102, 1312, 1821, 2067, 1979, 317, 1517, 694, 2033, 1602, 641,
	2681, 1662, 1979, 637, 572, 1841, 2031, 1979, 666, 1373, 364, 1837, 1991, 629, 1137, 448,
	1741, 733, 817, 446, 709, 1544, 923, 793, 463, 676, 1637, 182, 1672, 1481, 1544, 1814,
	912, 899, 509, 1741, 1373, 2024, 44, 34, 641, 1976, 1979, 793, 837, 1232, 736, 93,
	197, 2047, 1869, 1571, 929, 0, 1836, 1744, 71, 644, 449, 66, 1164, 666, 1983, 2036,
	1791, 181, 299, 1723, 852, 2031, 1869, 644, 1794, 1968, 1979, 299, 649, 641, 473, 473,
	508, 1387, 1584, 1387, 644, 726, 1039, 118, 992, 1979, 644, 899, 1571, 641, 1848, 1723,
	531, 1449, 0, 1839, 622, 1309, 643, 1584, 1302, 1277, 661, 2026, 1662, 0, 923, 1584,
	1137, 1449, 629, 1358, 1164, 1869, 0, 644, 1682, 1723, 181, 639, 784, 923, 76, 0,
	1357, 2026, 842, 1899, 1802, 1696, 686, 1322, 1741, 1322, 3251, 1869, 1451, 678, 1829, 211,
	2021, 1671, 822, 1309, 1938, 1828, 73, 47, 1828, 93, 1696, 2027, 664, 1304, 334, 1736,
	531, 1827, 1979, 216, 1829, 1648, 664, 216, 683, 1764, 182, 759, 259, 1731, 289, 761,
	736, 2019, 639, 1571, 0, 786, 359, 0, 1844, 1731, 1696, 1814, 1867, 694, 1322, 1827,
	1827, 1648, 864, 1868, 1642, 334, 694, 862, 1741, 1739, 786, 216, 1951, 0, 778, 887,
	181, 264, 1247, 531, 259, 1304, 1322, 359, 1909, 888, 1309, 844, 204, 1507, 444, 1291,
	204, 592, 738, 967, 0, 426, 1519, 1484, 1333, 1944, 1994, 877, 887, 94, 679, 679,
	1946, 33, 1559, 709, 592, 1662, 1563, 679, 334, 1839, 1519, 679, 1333, 667, 1264, 366,
	842, 2008, 142, 311, 261, 611, 679, 464, 679, 1992, 1992, 829, 1232, 1867, 187, 461,
	962, 496, 1707, 363, 641, 566, 26, 1579, 642, 1883, 1954, 1588, 1812, 2019, 1872, 604,
	466, 1764, 1312, 69, 68, 653, 1838, 351, 1471, 1501, 647, 317, 1992, 1074, 186, 506,
	844, 1309, 1012, 46, 1647, 1559, 447, 134, 59, 1224, 277, 2033, 319, 877, 1912, 1147,
	447, 503, 412, 646, 738, 414, 1508, 968, 1268, 1509, 651, 1322, 3387, 0, 71, 919,
	531, 1333, 187, 1841, 1829, 1753, 68, 1322, 799, 313, 663, 671, 1337, 1588, 1397, 407,
	781, 4494, 1663, 641, 277, 1777, 134, 1984, 759, 807, 69, 1466, 291, 1971, 134, 446,
	1882, 1672, 1197, 842, 817, 693, 523, 653, 557, 1663, 1747, 1979, 182, 1579, 1509, 1994,
	2067, 1763, 1481, 1657, 134, 1817, 474, 774, 461, 197, 781, 469, 1882, 1737, 1291, 1763,
	653, 1277, 807, 2041, 51, 69, 69, 479, 187, 518, 1866, 651, 299, 506, 187, 1971,
	1319, 1464, 1988, 899, 97, 641, 872, 1579, 709, 447, 1931, 506, 751, 1292, 1336, 683,
	222, 523, 1874, 134, 264, 98, 1912, 1309, 1694, 917, 286, 1761, 1419, 654, 0, 71,
	1588, 1756, 1753, 1262, 1966, 1778, 602, 1837, 1994, 1879, 228, 924, 1736, 353, 1761, 642,
	667, 622, 1776, 977, 414, 212, 2009, 1241, 431, 1994, 592, 1309, 597, 1326, 1776, 1292,
	0, 789, 1507, 893, 1882, 572, 1612, 1879, 196, 471, 423, 1419, 1971, 501, 1119, 1294,
	1763, 259, 496, 1212, 363, 844, 69, 2027, 202, 1466, 187, 1994, 1296, 887, 812, 651,
	104, 842, 629, 69, 317, 241, 1816, 1232, 118, 2009, 1202, 1248, 356, 1868, 1009, 2006,
	1912, 1743, 534, 1837, 604, 158, 759, 254, 1262, 1909, 641, 533, 1574, 893, 274, 899,
	1103, 1591, 259, 331, 1591, 829, 369, 857, 1761, 97, 994, 1556, 294, 862, 286, 329,
	448, 653, 1013, 789, 284, 1302, 311, 622, 1588, 822, 1896, 1761, 899, 1509, 1896, 0,
	1202, 0, 1202, 463, 694, 364, 899, 1817, 98, 291, 1429, 1931, 501, 1291, 852, 104,
	1989, 809, 0, 812, 789, 1867, 1879, 567, 1966, 1602, 1639, 992, 197, 642, 0, 1282,
	1632, 2009, 1989, 411, 1519, 1989, 1291, 639, 1632, 899, 897, 651, 1694, 1847, 1869, 809,
	887, 0, 852, 812, 1291, 1879, 1981, 1332, 852, 71, 369, 1899, 842, 1556, 917, 1847,
	1879, 2027, 1869, 993, 317, 412, 1496, 1957, 1496, 1168, 572, 834, 1751, 2033, 1373, 269,
	1949, 1291, 688, 68, 413, 1739, 1461, 726, 1392, 428, 69, 264, 1843, 967, 188, 0,
	604, 26, 844, 461, 694, 1269, 1029, 251, 3602, 1989, 842, 1574, 1649, 844, 1741, 1574,
	592, 1662, 2031, 134, 1879, 1986, 872, 2011, 33, 0, 429, 402, 1331, 572, 857, 1754,
	447, 857, 119, 676, 843, 1879, 899, 692, 1282, 264, 34, 1946, 872, 2039, 676, 543,
	606, 1496, 1433, 1612, 71, 1392, 999, 597, 1793, 2039, 602, 654, 1896, 237, 842, 1769,
	449, 1986, 54, 508, 1788, 471, 1612, 1328, 646, 126, 2011, 1612, 992, 1496, 429, 1906,
	726, 659, 1027, 1433, 1433, 1164, 1741, 857, 659, 774, 69, 617, 1518, 2039, 813, 1164,
	1677, 1119, 844, 2069, 317, 1119, 1649, 814, 994, 1556, 686, 4244, 496, 341, 686, 1864,
	644, 146, 1989, 1807, 1876, 592, 1866, 572, 1707, 1374, 1723, 1722, 1327, 1049, 1338, 358,
	1133, 441, 644, 1516, 227, 1236, 1969, 1461, 592, 1978, 642, 426, 1882, 1372, 288, 671,
	1574, 418, 1593, 264, 688, 1932, 0, 673, 446, 1979, 238, 2033, 196, 592, 1931, 3334,
	1744, 447, 1769, 1496, 54, 1994, 1334, 877, 1994, 1484, 464, 1821, 447, 1692, 1643, 284,
	204, 1506, 1981, 1752, 2048, 683, 39, 1332, 1029, 1519, 2059, 592, 676, 1374, 562, 1769,
	667, 1991, 197, 514, 33, 702, 784, 602, 239, 491, 491, 1616, 1767, 764, 663, 1336,
	458, 919, 1799, 61, 1754, 447, 483, 1662, 1387, 1954, 1841, 833, 1769, 1339, 1794, 456,
	337, 1663, 1556, 659, 1757, 629, 702, 1977, 653, 699, 186, 998, 1969, 923, 182, 1327,
	1516, 43, 1663, 1761, 617, 1311, 493, 1788, 1637, 1789, 1767, 592, 1744, 447, 1657, 1582,
	374, 793, 446, 676, 604, 1976, 1817, 683, 432, 644, 1794, 1373, 2036, 872, 222, 844,
	924, 857, 197, 1338, 1484, 1284, 1282, 2023, 1282, 1708, 1294, 1754, 1514, 1717, 1283, 1617,
	1708, 466, 1713, 63, 2019, 113, 543, 264, 912, 883, 1283, 1944, 69, 234, 877, 997,
	1284, 1281, 1642, 2036, 538, 2041, 1744, 2031, 1779, 858, 673, 421, 1407, 1012, 1869, 2038,
	412, 924, 1794, 1846, 1479, 644, 1794, 1756, 651, 739, 1754, 1403, 997, 641, 369, 1984,
	319, 1012, 1002, 1872, 337, 48, 1556, 1326, 71, 618, 491, 241, 998, 1719, 449, 1718,
	1667, 501, 1003, 1767, 854, 2036, 74, 1884, 1841, 1637, 511, 1979, 1881, 181, 157, 284,
	1747, 1872, 2038, 1794, 1502, 1716, 491, 0, 1847, 674, 1839, 2019, 1099, 41, 508, 1207,
	1989, 651, 149, 1339, 1436, 1884, 1747, 261, 1741, 1387, 1616, 449, 1882, 1968, 473, 1399,
	602, 1894, 1632, 1754, 1574, 1312, 2039, 1616, 0, 114, 69, 432, 254, 842, 1591, 1818,
	1563, 2039, 832, 2009, 1294, 959, 1977, 923, 1039, 1248, 854, 992, 1797, 2038, 644, 1471,
	1584, 412, 924, 61, 1836, 1301, 1004, 1827, 1298, 632, 1751, 1744, 2036, 1789, 1352, 1799,
	1584, 1301, 1926, 271, 1976, 1474, 1433, 872, 692, 411, 862, 234, 2061, 654, 1364, 158,
	1408, 1789, 629, 609, 2053, 1741, 1298, 1882, 280, 1502, 629, 1744, 1449, 653, 656, 617,
	1301, 241, 669, 663, 69, 157, 1839, 1067, 1584, 1839, 1464, 1791, 644, 86, 1293, 812,
	103, 1806, 2053, 644, 1232, 844, 1029, 834, 1767, 2053, 784, 1861, 1794, 832, 1751, 157,
	663, 897, 157, 1846, 112, 1756, 1751, 1741, 2053, 917, 1423, 299, 813, 832, 854, 994,
	686, 1866, 592, 1989, 1751, 572, 1876, 642, 1707, 784, 644, 1374, 1718, 1882, 592, 227,
	1236, 1461, 466, 1049, 1374, 2039, 912, 426, 1978, 1722, 418, 1994, 1969, 1133, 1516, 1754,
	464, 1769, 447, 854, 2048, 1496, 1744, 1976, 1981, 1989, 39, 447, 204, 1484, 1839, 676,
	284, 43, 1387, 3167, 764, 1364, 337, 562, 629, 2983, 1799, 659, 919, 702, 663, 1663,
	493, 1761, 699, 1789, 1744, 1582, 1616, 644, 1637, 644, 1794, 877, 1846, 1794, 1283, 421,
	234, 1479, 538, 1502, 1717, 997, 1514, 61, 197, 1617, 883, 1338, 2036, 1944, 1708, 924,
	2019, 2031, 739, 1756, 651, 998, 813, 1637, 1003, 641, 1884, 629, 1556, 222, 369, 74,
	1754, 501, 2019, 618, 319, 923, 71, 1012, 1872, 674, 449, 1399, 1968, 2932, 261, 473,
	157, 842, 1839, 651, 86, 1248, 959, 832, 1846, 1591, 1004, 1301, 1767, 862, 1474, 1926,
	656, 1293, 1301, 617, 663, 2053, 443, 1769, 466, 443, 1341, 443, 0, 96, 1262, 1759,
	0, 466, 1846, 1846, 1319, 1749, 524, 2061, 1607, 1948, 1284, 1729, 1846, 832, 1607, 897,
	524, 1713, 1713, 466, 1713, 558, 0, 917, 447, 992, 407, 506, 1993, 691, 967, 508,
	1012, 466, 29, 514, 1637, 699, 447, 1499, 1818, 1954, 2059, 518, 234, 1869, 1979, 13,
	407, 813, 1518, 1556, 1237, 949, 883, 29, 407, 842, 166, 1719, 69, 644, 1926, 1662,
	883, 641, 699, 994, 1954, 917, 1237, 641, 641, 902, 1822, 993, 1296, 277, 978, 1822,
	1863, 1863, 427, 26, 471, 1824, 508, 1296, 1901, 471, 877, 1741, 1994, 316, 1786, 1298,
	1837, 1754, 1387, 1347, 1347, 1298, 617, 1591, 1754, 1839, 0, 1296, 1292, 1867, 491, 667,
	1611, 1872, 1741, 412, 1471, 427, 1471, 653, 832, 491, 1791, 1823, 159, 1868, 499, 1839,
	191, 1726, 426, 592, 189, 189, 264, 449, 1747, 1228, 1839, 804, 1839, 1236, 877, 862,
	1979, 691, 1742, 1767, 1757, 1741, 1744, 421, 1302, 629, 626, 1761, 1464, 592, 656, 317,
	264, 423, 299, 1464, 189, 1994, 653, 1796, 189, 1241, 2036, 1707, 626, 599, 572, 574,
	559, 22, 1246, 1839, 852, 1868, 0, 872, 1226, 1302, 22, 411, 1839, 629, 1796, 299,
	1829, 823, 0, 733, 969, 1958, 1282, 503, 503, 733, 339, 337, 402, 1523, 1403, 402,
	1054, 2006, 833, 1656, 2033, 491, 169, 569, 1882, 29, 1236, 1837, 1559, 202, 646, 694,
	636, 202, 824, 913, 642, 1611, 1193, 892, 1144, 658, 1213, 1912, 892, 641, 824, 639,
	1861, 1029, 612, 403, 1098, 341, 1832, 276, 1563, 1312, 1882, 188, 286, 286, 592, 493,
	1977, 0, 1119, 286, 1968, 174, 877, 1971, 1863, 1696, 862, 887, 1977, 1127, 1646, 402,
	642, 1651, 541, 0, 852, 569, 1504, 869, 1259, 676, 694, 69, 318, 542, 1722, 1794,
	1262, 241, 344, 0, 1657, 1868, 241, 787, 852, 789, 241, 852, 1726, 789, 852, 852,
	241, 22, 1501, 1563, 1656, 789, 1119, 1977, 286, 1127, 0, 641, 1656, 1656, 887, 1869,
	1119, 1954, 1559, 1574, 1839, 1574, 1559, 1954, 1954, 1394, 1839, 834, 641, 1327, 743, 1827,
	476, 319, 619, 621, 1838, 1374, 1764, 1398, 1988, 1871, 364, 466, 1387, 461, 146, 1734,
	162, 508, 1976, 1312, 446, 422, 427, 1221, 1214, 651, 417, 2021, 1862, 1049, 16, 743,
	1352, 496, 1869, 1723, 1827, 1282, 1237, 1293, 1741, 1741, 424, 743, 678, 1604, 1499, 1983,
	1949, 1767, 1499, 1719, 1989, 337, 288, 424, 27, 1269, 1332, 1642, 2554, 511, 1601, 2033,
	761, 1976, 1099, 1262, 2034, 446, 1214, 1966, 1752, 2069, 1221, 648, 1504, 1976, 46, 1038,
	1331, 602, 736, 188, 1844, 1791, 1821, 887, 354, 713, 897, 679, 1148, 1816, 43, 769,
	1837, 526, 553, 476, 354, 186, 661, 1781, 1781, 402, 14, 587, 1242, 1087, 2034, 0,
	1971, 1648, 1976, 264, 977, 1767, 264, 1767, 954, 954, 643, 0, 0, 774, 1424, 4401,
	1282, 1068, 993, 1137, 902, 1709, 97, 1723, 1708, 1327, 663, 679, 1392, 586, 273, 902,
	1471, 1658, 977, 227, 1499, 1767, 305, 2056, 254, 1786, 1774, 1691, 1216, 182, 1078, 448,
	359, 1691, 1114, 1068, 1238, 508, 917, 844, 853, 1949, 264, 667, 858, 1542, 1237, 76,
	912, 1242, 544, 699, 2019, 289, 1643, 1078, 676, 666, 804, 1834, 1816, 1373, 1499, 234,
	448, 448, 691, 422, 1296, 1709, 354, 1237, 542, 2036, 344, 1734, 977, 1403, 2009, 1979,
	249, 917, 1193, 319, 11, 1776, 1068, 1519, 213, 1058, 1884, 1983, 1392, 389, 1426, 1672,
	1826, 654, 1718, 663, 1867, 646, 369, 69, 162, 449, 1754, 1099, 998, 1699, 1632, 1683,
	2543, 1293, 923, 1721, 1569, 1612, 1574, 2019, 477, 1839, 97, 862, 641, 1237, 1767, 471,
	923, 89, 0, 162, 899, 542, 1211, 207, 76, 658, 446, 1612, 1027, 1741, 2006, 924,
	661, 1849, 892, 1979, 1803, 226, 874, 1662, 1232, 1099, 209, 862, 264, 531, 1827, 1631,
	412, 1977, 661, 1474, 601, 264, 1414, 1756, 1582, 429, 1846, 1471, 1996, 288, 774, 1137,
	1687, 852, 69, 1856, 702, 204, 1839, 698, 804, 853, 1441, 1687, 508, 1282, 264, 89,
	1806, 1069, 639, 1904, 1754, 76, 1779, 776, 804, 1816, 897, 604, 1890, 918, 1332, 1904,
	902, 1097, 1890, 177, 1291, 1734, 782, 1901, 872, 529, 2034, 663, 1119, 199, 644, 471,
	199, 997, 1119, 1979, 1979, 477, 654, 337, 1976, 1786, 1602, 1966, 689, 1754, 1867, 146,
	1828, 1867, 191, 1744, 1744, 689, 1867, 1868, 1776, 693, 689, 1774, 1487, 1489, 1489, 688,
	1509, 1606, 1516, 1509, 1643, 1609, 1279, 1279, 523, 609, 1606, 213, 1549, 1747, 1738, 1986,
	296, 212, 1471, 1838, 0, 1196, 1604, 412, 38, 212, 562, 418, 36, 68, 604, 1981,
	654, 121, 877, 1992, 1912, 384, 97, 1752, 478, 212, 1747, 897, 1322, 1212, 1741, 766,
	447, 1909, 432, 842, 1481, 1867, 817, 1658, 0, 1718, 97, 988, 1104, 691, 622, 1513,
	669, 74, 1029, 337, 0, 44, 146, 1839, 1566, 121, 127, 892, 284, 1803, 1829, 191,
	0, 291, 1297, 898, 1838, 669, 654, 639, 987, 1282, 898, 897, 157, 1536, 489, 857,
	651, 651, 1449, 1819, 447, 1261, 1819, 1819, 128, 128, 1839, 829, 343, 661, 9, 1053,
	1647, 661, 667, 1232, 1707, 1839, 151, 997, 993, 461, 1291, 1869, 1869, 1482, 1781, 364,
	1749, 1283, 962, 2033, 629, 1581, 1979, 1756, 1237, 447, 1687, 1588, 1737, 1976, 1281, 1471,
	1722, 1294, 1372, 447, 756, 669, 897, 1994, 641, 1312, 1282, 1872, 426, 26, 1409, 1771,
	644, 606, 606, 416, 1739, 702, 503, 1978, 1882, 1312, 1828, 202, 967, 1812, 424, 1377,
	562, 241, 638, 27, 74, 882, 0, 1718, 844, 1238, 389, 1754, 162, 121, 1994, 1571,
	1837, 1874, 1353, 877, 1602, 1647, 317, 1002, 1318, 844, 1859, 736, 1039, 1224, 46, 503,
	1012, 1838, 1838, 694, 1253, 1419, 763, 1127, 1098, 97, 93, 1471, 1327, 1828, 1751, 58,
	592, 1846, 1933, 351, 691, 337, 1117, 461, 601, 1262, 977, 447, 1501, 506, 69, 1719,
	447, 2027, 969, 414, 1307, 967, 968, 27, 237, 1029, 2031, 318, 187, 503, 676, 887,
	0, 1113, 0, 1802, 1847, 1322, 477, 1017, 844, 1387, 1844, 489, 1294, 153, 153, 1869,
	1786, 2034, 869, 1737, 381, 531, 134, 653, 237, 599, 526, 962, 147, 661, 661, 447,
	1867, 1991, 2031, 656, 627, 1841, 147, 407, 1387, 1397, 191, 963, 1662, 1984, 0, 1994,
	1807, 617, 446, 1337, 456, 277, 676, 1779, 213, 128, 676, 402, 14, 1302, 187, 1373,
	654, 1837, 621, 94, 844, 671, 823, 1519, 2011, 277, 647, 1362, 69, 1912, 1302, 629,
	644, 294, 0, 1387, 631, 1777, 919, 1847, 1292, 674, 1586, 1844, 955, 592, 1989, 1829,
	364, 1718, 204, 359, 446, 1373, 1842, 3072, 67, 104, 1883, 317, 1672, 1581, 1581, 182,
	177, 1737, 82, 1741, 493, 844, 1277, 202, 1029, 844, 2011, 2069, 382, 1327, 1461, 1591,
	177, 431, 693, 977, 987, 1779, 676, 171, 1496, 706, 1817, 1657, 1862, 274, 521, 557,
	1863, 274, 647, 1714, 1574, 1133, 1481, 1754, 817, 447, 387, 1029, 1724, 667, 1057, 1039,
	723, 807, 852, 1509, 1731, 1674, 1751, 639, 1862, 1847, 1846, 0, 227, 963, 963, 239,
	1708, 676, 319, 1332, 351, 651, 2041, 506, 804, 899, 692, 1719, 3209, 1119, 791, 572,
	1277, 2031, 473, 543, 447, 914, 161, 197, 1561, 222, 1944, 982, 114, 27, 842, 1674,
	96, 559, 49, 1347, 698, 1741, 1312, 318, 666, 1277, 294, 673, 1953, 1602, 493, 607,
	506, 877, 421, 671, 11, 1713, 44, 1988, 1816, 2046, 651, 873, 1608, 1516, 1642, 299,
	603, 1282, 572, 264, 1617, 226, 69, 162, 617, 421, 807, 1281, 987, 1262, 1718, 289,
	1464, 617, 1883, 1837, 1647, 1282, 1708, 134, 1054, 0, 1694, 686, 1651, 917, 0, 0,
	987, 0, 1219, 344, 1847, 1847, 1847, 1761, 1424, 1326, 736, 1756, 1709, 1868, 1869, 449,
	854, 1796, 1796, 1057, 134, 1731, 228, 1761, 1867, 71, 969, 11, 389, 919, 1847, 799,
	799, 656, 1708, 2067, 2069, 2046, 48, 1392, 1743, 1834, 11, 1332, 651, 447, 924, 676,
	1227, 431, 592, 592, 597, 1817, 1671, 1994, 2031, 1756, 1499, 477, 1286, 679, 992, 622,
	116, 1277, 459, 353, 1989, 654, 1718, 97, 1719, 1196, 644, 602, 1904, 646, 369, 1829,
	709, 241, 1337, 1716, 1292, 787, 1657, 631, 1743, 1506, 1284, 812, 2036, 1826, 1871, 977,
	1881, 1519, 319, 2009, 521, 0, 498, 158, 718, 789, 0, 658, 892, 1718, 1204, 1294,
	1566, 1841, 1506, 227, 1509, 1881, 1966, 819, 1397, 3487, 844, 1341, 1579, 1872, 844, 693,
	1741, 44, 202, 1792, 1672, 882, 1734, 328, 1291, 2046, 227, 149, 1871, 197, 1869, 773,
	1207, 1277, 1277, 1049, 1554, 1741, 427, 1882, 1971, 651, 642, 1419, 121, 396, 992, 566,
	1586, 1966, 1017, 639, 1794, 882, 1742, 506, 817, 1387, 1728, 459, 274, 1506, 1612, 918,
	1399, 1591, 1796, 54, 471, 534, 69, 1743, 538, 2069, 1647, 1574, 0, 812, 0, 644,
	842, 116, 817, 1869, 0, 1847, 1029, 334, 1647, 968, 1661, 1992, 1232, 11, 852, 241,
	1743, 1262, 1191, 673, 1677, 667, 1717, 1681, 127, 1869, 1839, 1839, 863, 69, 898, 1795,
	1273, 1946, 832, 659, 959, 1817, 877, 644, 76, 538, 558, 1516, 1574, 251, 1489, 1476,
	317, 1009, 706, 959, 103, 319, 132, 1959, 1497, 1799, 1719, 602, 22, 993, 892, 254,
	1981, 114, 1267, 658, 994, 241, 1113, 629, 683, 1842, 654, 1101, 1516, 1844, 542, 177,
	604, 1461, 759, 1294, 947, 122, 0, 1297, 356, 853, 874, 759, 8, 69, 842, 1718,
	642, 1292, 1504, 412, 987, 1193, 158, 328, 1809, 661, 1408, 1408, 833, 1867, 1302, 202,
	607, 651, 955, 1882, 46, 1862, 1332, 899, 1362, 629, 389, 1637, 423, 702, 2059, 409,
	1397, 427, 789, 1549, 1407, 1813, 1791, 449, 702, 294, 1737, 353, 1556, 1761, 1744, 887,
	1884, 1481, 1282, 651, 1884, 1586, 877, 1869, 1747, 1729, 642, 594, 1559, 1137, 833, 1796,
	1884, 1869, 1742, 569, 2547, 566, 9, 1716, 629, 629, 644, 237, 1756, 1709, 1009, 1839,
	837, 656, 119, 1496, 1297, 852, 736, 1872, 277, 1639, 1611, 1801, 69, 1941, 1586, 1751,
	412, 343, 1769, 508, 1769, 1518, 654, 733, 591, 1424, 1771, 1806, 1829, 0, 1568, 1518,
	1806, 374, 1257, 1718, 1127, 197, 952, 1397, 1246, 1602, 644, 1908, 177, 1966, 403, 1838,
	1847, 473, 241, 1761, 1282, 407, 653, 1868, 786, 669, 73, 317, 994, 812, 674, 2622,
	1003, 1322, 666, 1753, 0, 1193, 1752, 1574, 924, 1839, 1794, 1768, 842, 1839, 803, 833,
	664, 317, 1979, 29, 1632, 1829, 1029, 618, 76, 411, 1568, 1607, 1681, 1322, 1302, 1719,
	882, 627, 1516, 473, 1884, 0, 844, 1518, 1991, 8, 874, 1908, 1796, 1311, 809, 639,
	1694, 1739, 1408, 1408, 1282, 587, 897, 1571, 1682, 962, 1884, 1257, 1868, 1806, 644, 681,
	1796, 1027, 0, 1571, 681, 0, 1119, 69, 1357, 1839, 1753, 1869, 691, 854, 853, 1843,
	1297, 1846, 887, 608, 1718, 1879, 877, 1332, 1827, 412, 977, 812, 786, 812, 644, 294,
	959, 834, 833, 608, 431, 1976, 1719, 787, 1944, 612, 844, 644, 992, 833, 614, 917,
	641, 787, 899, 651, 0, 0, 832, 1337, 1761, 1839, 902, 982, 81, 601, 603, 898,
	1159, 924, 1556, 1761, 1292, 204, 601, 1791, 272, 447, 1791, 1791, 898, 603, 1867, 569,
	663, 694, 542, 49, 1817, 1944, 1944, 786, 76, 1744, 1519, 192, 1327, 331, 643, 1327,
	341, 1506, 0, 694, 1957, 1487, 1866, 461, 2033, 592, 628, 987, 479, 1581, 1746, 154,
	1507, 1838, 948, 1756, 416, 389, 1196, 188, 1291, 1722, 1722, 1409, 44, 1237, 1879, 1879,
	706, 1976, 1662, 1843, 1978, 117, 1872, 702, 627, 1312, 1281, 1984, 1812, 567, 1039, 1712,
	427, 427, 562, 496, 1908, 448, 1352, 669, 447, 186, 358, 46, 1753, 1097, 1624, 1326,
	1862, 1934, 1262, 187, 1864, 739, 556, 694, 189, 449, 1352, 1886, 503, 1237, 1266, 1752,
	1994, 331, 82, 93, 506, 1941, 1331, 1487, 1653, 877, 508, 289, 511, 1847, 844, 181,
	1331, 1032, 477, 239, 627, 627, 962, 449, 1822, 1696, 869, 1991, 1836, 1752, 799, 661,
	844, 1839, 94, 667, 477, 1487, 1837, 1713, 1029, 1322, 667, 533, 498, 1979, 957, 823,
	1957, 647, 1067, 1556, 1282, 1316, 916, 1327, 1761, 1858, 647, 1684, 171, 34, 387, 559,
	1518, 1797, 431, 1499, 1969, 448, 1753, 1957, 1737, 447, 842, 817, 69, 202, 1871, 1863,
	667, 289, 1817, 1657, 329, 1684, 627, 1731, 1976, 1561, 421, 691, 994, 1282, 1282, 1869,
	1346, 804, 988, 1296, 1556, 1741, 912, 844, 337, 1647, 1617, 791, 557, 559, 1869, 44,
	422, 1237, 1718, 2021, 1839, 1871, 1574, 1337, 651, 1409, 1097, 1316, 1719, 858, 543, 1706,
	351, 389, 38, 2026, 1713, 117, 1006, 1847, 541, 157, 0, 1859, 736, 642, 1766, 1657,
	979, 1791, 997, 1867, 666, 1507, 1796, 622, 1818, 71, 1392, 1716, 449, 1872, 977, 1719,
	447, 1397, 1834, 1862, 1327, 967, 1746, 1846, 1506, 1984, 1611, 1991, 2036, 1637, 449, 1872,
	787, 987, 804, 362, 602, 1326, 337, 844, 1731, 1884, 1868, 1058, 892, 226, 1387, 1847,
	656, 1683, 817, 1212, 1556, 1741, 239, 1741, 1872, 1726, 852, 1566, 36, 1387, 1387, 642,
	1736, 1789, 559, 1312, 1559, 66, 607, 1612, 1838, 364, 1054, 574, 602, 629, 948, 1017,
	1839, 1722, 1847, 1632, 1867, 121, 0, 0, 958, 0, 1476, 1509, 127, 186, 319, 22,
	899, 1719, 1979, 1612, 177, 1246, 1332, 51, 1867, 654, 917, 892, 673, 1981, 1843, 656,
	1529, 1722, 661, 959, 1957, 1959, 950, 950, 541, 882, 967, 1741, 241, 842, 958, 1761,
	162, 1946, 963, 1759, 1029, 2056, 1556, 1326, 1624, 1977, 1232, 1232, 663, 1332, 1253, 862,
	1207, 533, 1743, 643, 2006, 622, 422, 822, 702, 702, 629, 1842, 157, 661, 1475, 1067,
	1761, 1032, 192, 1807, 1556, 0, 181, 291, 843, 1769, 1474, 1838, 678, 277, 157, 1284,
	236, 1756, 1489, 918, 1312, 1847, 154, 844, 1917, 616, 852, 1992, 1937, 1766, 963, 1769,
	1282, 1387, 653, 988, 567, 1397, 639, 2027, 667, 1257, 571, 1009, 412, 833, 667, 804,
	994, 843, 228, 844, 1327, 1119, 897, 364, 1761, 1991, 887, 1979, 887, 431, 1831, 1237,
	1062, 508, 696, 1846, 0, 1741, 117, 1332, 1337, 364, 117, 957, 1332, 667, 1992, 1886,
	4268, 621, 1169, 1221, 1169, 1774, 1984, 954, 403, 739, 1009, 1744, 4277, 1818, 724, 1874,
	0, 877, 1799, 1519, 1752, 1664, 1139, 666, 1752, 1812, 602, 1719, 299, 191, 1719, 299,
	2021, 587, 1332, 1836, 1836, 103, 463, 1867, 78, 149, 1839, 1471, 179, 446, 538, 426,
	1526, 667, 1049, 1981, 288, 1099, 191, 1981, 1769, 1978, 1767, 1352, 1976, 1374, 1311, 671,
	706, 1872, 979, 1309, 23, 1113, 626, 1352, 646, 1692, 878, 284, 49, 1217, 1829, 2069,
	69, 1484, 1608, 2048, 574, 1802, 1789, 1968, 1839, 1199, 96, 316, 1699, 449, 538, 1979,
	1979, 1352, 1209, 1839, 969, 0, 1049, 756, 1799, 156, 1331, 54, 1869, 1742, 403, 97,
	1038, 447, 1837, 188, 764, 1374, 659, 647, 267, 1029, 667, 402, 476, 1397, 1991, 531,
	1841, 112, 869, 1479, 562, 2011, 291, 0, 791, 744, 1113, 1519, 646, 794, 182, 843,
	696, 1496, 1272, 477, 1839, 1869, 1968, 882, 1327, 1347, 644, 1834, 103, 2011, 1544, 1461,
	1347, 843, 855, 853, 764, 653, 442, 156, 69, 536, 1617, 1871, 877, 188, 161, 1986,
	381, 78, 858, 162, 1222, 1222, 421, 698, 918, 543, 1818, 361, 1741, 1979, 691, 1283,
	644, 543, 514, 744, 1281, 319, 1509, 449, 192, 1284, 73, 337, 791, 366, 1789, 1789,
	574, 1874, 46, 48, 447, 1867, 1679, 1819, 626, 54, 203, 923, 0, 157, 1883, 1596,
	501, 276, 612, 1387, 1874, 1399, 1054, 683, 1593, 1207, 1689, 188, 1438, 1113, 1847, 669,
	1291, 612, 764, 855, 812, 842, 1958, 1506, 923, 1839, 337, 1769, 1751, 1719, 78, 127,
	641, 1298, 1496, 46, 1756, 0, 447, 653, 2009, 654, 2059, 642, 286, 1887, 412, 97,
	1758, 1807, 82, 1362, 958, 812, 23, 1912, 534, 1304, 1584, 1137, 156, 853, 69, 671,
	291, 1518, 1944, 67, 812, 1277, 1397, 1978, 0, 1518, 1699, 1509, 33, 1767, 97, 179,
	809, 887, 1742, 1751, 812, 1958, 284, 693, 1899, 1506, 653, 1209, 1839, 0, 1814, 4241,
	1741, 1829, 407, 1607, 0, 1829, 449, 29, 572, 641, 641, 654, 521, 74, 1819, 531,
	702, 1243, 967, 994, 994, 1009, 1509, 1559, 156, 917, 702, 994, 1649, 852, 1829, 1979,
	706, 1742, 1473, 1716, 1744, 1643, 1867, 813, 389, 363, 1311, 1213, 644, 1017, 994, 504,
	1334, 1944, 674, 521, 311, 654, 917, 1334, 654, 1718, 702, 1334, 917, 813, 1498, 317,
	521, 654, 521, 1819, 531, 994, 1509, 156, 813, 3202, 644, 1742, 317, 1643, 1867, 504,
	674, 1334, 3163, 1327, 671, 251, 702, 1979, 169, 642, 506, 289, 2058, 318, 1476, 1769,
	1337, 477, 1509, 3168, 533, 496, 204, 668, 634, 1327, 1776, 1574, 1097, 1281, 899, 1979,
	1931, 69, 1777, 602, 1476, 496, 1979, 1802, 204, 1741, 1837, 899, 702, 1741, 1819, 1741,
	1817, 0, 344, 449, 1327, 1327, 664, 591, 644, 414, 1809, 334, 594, 149, 1618, 1791,
	667, 1837, 1374, 1809, 1842, 1474, 1284, 1691, 644, 1809, 1842, 387, 426, 1814, 1826, 1564,
	1498, 1842, 1771, 702, 1762, 1074, 177, 1862, 1978, 1781, 418, 1774, 166, 1489, 1751, 1463,
	2023, 1793, 1839, 1839, 1574, 186, 571, 1496, 572, 1794, 1968, 1994, 1974, 504, 2033, 2033,
	1941, 508, 449, 1338, 337, 877, 318, 1824, 844, 1067, 1209, 1989, 464, 1839, 694, 1828,
	1934, 1692, 1837, 1333, 1954, 1262, 69, 1784, 1331, 27, 277, 2048, 1616, 1993, 237, 1957,
	1858, 1793, 1807, 1839, 623, 572, 1509, 147, 1764, 1506, 583, 149, 504, 533, 1337, 629,
	667, 609, 456, 1757, 628, 1496, 197, 354, 992, 1941, 1019, 389, 626, 1817, 1781, 514,
	404, 63, 1648, 1837, 833, 1991, 781, 766, 1737, 1869, 1632, 644, 1979, 1374, 1574, 818,
	387, 782, 386, 1509, 1658, 289, 54, 157, 1864, 746, 1304, 1311, 1524, 11, 1868, 1764,
	182, 669, 1754, 1736, 1739, 474, 1564, 103, 629, 679, 1551, 1969, 1551, 362, 0, 164,
	1492, 667, 739, 1331, 242, 1762, 1584, 1713, 1752, 423, 807, 1599, 1839, 1047, 1842, 334,
	69, 234, 158, 872, 2021, 644, 641, 1607, 2019, 1718, 692, 1318, 352, 1974, 1912, 2041,
	1291, 2027, 859, 654, 204, 567, 914, 1498, 78, 554, 344, 1867, 337, 1791, 1243, 1509,
	1796, 1509, 634, 609, 389, 1984, 319, 1767, 447, 1278, 1657, 654, 1283, 1869, 2031, 1676,
	1743, 629, 1841, 11, 1752, 1057, 177, 433, 1991, 1822, 1819, 622, 1796, 477, 1164, 641,
	1032, 1834, 1719, 0, 1632, 1986, 1474, 653, 1269, 0, 623, 639, 476, 1847, 992, 1566,
	994, 1743, 1296, 176, 1804, 1637, 1574, 44, 187, 1291, 1509, 658, 1872, 1769, 574, 1616,
	1827, 1827, 604, 1867, 1246, 244, 1318, 842, 1027, 1029, 1476, 1957, 1024, 653, 1912, 2048,
	852, 892, 116, 1191, 524, 1742, 2027, 22, 22, 673, 1957, 1837, 601, 1298, 959, 167,
	559, 607, 157, 1791, 1926, 1449, 1743, 1486, 374, 1974, 1067, 654, 387, 1849, 702, 641,
	2063, 663, 96, 629, 2009, 1027, 1924, 277, 1507, 1302, 1607, 1639, 1278, 1502, 1796, 1909,
	1606, 293, 1584, 1751, 641, 664, 678, 852, 1142, 1836, 8, 1941, 1239, 628, 609, 1839,
	1839, 1474, 1359, 1144, 1293, 2019, 1599, 604, 1986, 567, 9, 1846, 654, 1869, 653, 629,
	362, 1957, 1799, 1899, 833, 1498, 1719, 158, 844, 1837, 74, 1957, 1819, 389, 197, 1719,
	197, 1829, 157, 1359, 1843, 812, 179, 639, 1957, 616, 1899, 1839, 293, 1941, 1819, 362,
	1817, 644, 344, 449, 1374, 641, 667, 594, 1618, 1359, 1474, 1284, 1691, 1809, 1839, 1809,
	644, 1374, 658, 629, 1191, 694, 1814, 1074, 1793, 387, 914, 1781, 1564, 433, 1489, 418,
	702, 1974, 508, 571, 1262, 2048, 4007, 1784, 1934, 1574, 1968, 318, 1986, 237, 1331, 1954,
	69, 1839, 1837, 781, 833, 1509, 514, 1506, 667, 626, 182, 1991, 1496, 609, 289, 504,
	1337, 533, 1807, 1839, 1974, 456, 1757, 149, 634, 1793, 1986, 669, 1736, 1868, 1304, 1739,
	474, 1864, 629, 782, 4051, 1564, 386, 1318, 1991, 2041, 1164, 362, 2027, 423, 739, 1718,
	1867, 3992, 1498, 2834, 158, 859, 2021, 1584, 1607, 1498, 1839, 1032, 177, 337, 623, 654,
	1767, 1804, 1834, 1719, 389, 1869, 1796, 157, 2031, 11, 1819, 319, 992, 1243, 1791, 1027,
	293, 1574, 1769, 1827, 44, 1509, 1291, 994, 673, 959, 1957, 653, 1024, 1607, 1924, 1302,
	812, 1278, 702, 1819, 1293, 1941, 179, 508, 1291, 592, 1746, 642, 592, 556, 591, 1741,
	1741, 3136, 862, 724, 362, 887, 359, 656, 1283, 188, 843, 311, 1706, 69, 1519, 1751,
	431, 1979, 1979, 1819, 1819, 1508, 1519, 626, 1687, 1839, 1687, 361, 1819, 26, 599, 1831,
	252, 1759, 619, 651, 743, 554, 694, 446, 1741, 86, 567, 1869, 1991, 646, 427, 1741,
	604, 1721, 617, 86, 317, 2036, 427, 1839, 1979, 49, 152, 464, 1237, 1049, 1236, 503,
	1049, 1864, 331, 1029, 1559, 1786, 617, 791, 572, 572, 1029, 559, 969, 842, 1097, 68,
	1868, 646, 1676, 966, 1237, 1741, 389, 893, 1029, 201, 1607, 616, 702, 54, 1966, 1872,
	449, 112, 499, 1624, 1837, 562, 1709, 1257, 639, 414, 1606, 524, 1912, 1979, 404, 1994,
	1509, 69, 2031, 404, 534, 1243, 73, 953, 284, 1504, 784, 424, 1651, 1837, 187, 969,
	574, 69, 899, 874, 629, 456, 1242, 2031, 648, 1794, 1917, 663, 456, 1901, 654, 1509,
	1809, 1969, 1486, 86, 86, 1327, 1486, 214, 1901, 1986, 809, 1899, 239, 176, 1478, 1643,
	1222, 491, 1752, 954, 654, 1584, 449, 288, 242, 242, 1979, 641, 1949, 363, 674, 1781,
	226, 632, 48, 1891, 809, 434, 124, 641, 1504, 1839, 2009, 449, 504, 1429, 1912, 862,
	1839, 34, 178, 619, 1979, 2019, 1217, 1881, 1929, 289, 1899, 1819, 0, 1474, 1709, 1847,
	674, 464, 1752, 1901, 69, 362, 1517, 1819, 0, 1799, 889, 464, 1901, 54, 1966, 449,
	1872, 499, 112, 1912, 1752, 34, 1949, 639, 1979, 414, 1606, 1257, 73, 504, 1994, 524,
	404, 654, 69, 1509, 1651, 534, 784, 284, 969, 424, 574, 1837, 1917, 1979, 648, 629,
	2031, 874, 899, 1901, 2031, 456, 674, 1327, 1969, 809, 1486, 449, 363, 641, 1517, 1478,
	239, 69, 1986, 491, 1222, 288, 809, 434, 2019, 449, 2009, 1429, 1912, 1819, 1899, 1881,
	1929, 1474, 1847, 464, 189, 1744, 1489, 1058, 1662, 1744, 181, 574, 181, 1958, 1747, 1612,
	2043, 2043, 844, 686, 449, 1954, 463, 1283, 1474, 1322, 1312, 1484, 236, 702, 1313, 187,
	2033, 179, 179, 337, 1309, 166, 316, 1449, 1941, 201, 1879, 1331, 642, 1331, 202, 511,
	1868, 2031, 1647, 383, 869, 463, 1591, 254, 1742, 1954, 1574, 674, 691, 654, 1344, 1614,
	169, 263, 899, 1334, 294, 1326, 2031, 1637, 1331, 189, 622, 1302, 1301, 664, 1909, 1639,
	0, 1898, 1898, 2047, 1196, 49, 1867, 1283, 378, 702, 446, 178, 653, 419, 1978, 1596,
	1879, 29, 1282, 1879, 1299, 1694, 1602, 1839, 1103, 877, 979, 27, 336, 761, 1692, 646,
	238, 1218, 1288, 1994, 691, 328, 1977, 446, 1207, 694, 1471, 98, 1097, 694, 844, 486,
	1837, 644, 384, 1753, 661, 384, 1991, 1337, 769, 2003, 534, 1322, 788, 1757, 189, 899,
	1242, 1979, 647, 1649, 113, 654, 1599, 1301, 69, 1751, 384, 641, 692, 644, 1861, 1672,
	204, 679, 1119, 1761, 104, 1802, 1346, 1038, 1516, 857, 1858, 663, 197, 1764, 1032, 1599,
	654, 1282, 1731, 1717, 231, 667, 642, 1103, 691, 2046, 912, 899, 877, 612, 694, 187,
	1708, 1337, 1636, 97, 2047, 1309, 1838, 254, 2036, 113, 2036, 94, 1979, 1971, 328, 1977,
	1867, 382, 379, 213, 1858, 1983, 1637, 1958, 178, 209, 654, 511, 294, 693, 447, 2047,
	337, 1242, 1392, 1164, 1637, 148, 1683, 653, 298, 271, 1741, 1599, 1299, 1103, 326, 1637,
	642, 1119, 957, 884, 1899, 69, 191, 899, 862, 254, 1611, 284, 1574, 1743, 788, 644,
	1977, 1299, 317, 1207, 2036, 852, 64, 127, 1103, 82, 1682, 692, 311, 144, 1751, 412,
	202, 1981, 376, 96, 254, 254, 702, 702, 872, 1599, 1301, 1301, 1278, 861, 376, 256,
	524, 1909, 1599, 69, 69, 1992, 694, 202, 1304, 378, 197, 641, 1738, 1879, 1103, 874,
	869, 1977, 844, 1979, 157, 202, 369, 1719, 887, 874, 1751, 1719, 2051, 812, 1769, 1358,
	1424, 1119, 1599, 694, 644, 256, 2051, 1743, 787, 702, 874, 1496, 496, 286, 0, 1331,
	1638, 383, 383, 496, 817, 0, 918, 8, 641, 692, 1613, 0, 0, 1819, 978, 726,
	1331, 892, 824, 383, 1977, 1819, 1638, 299, 1849, 48, 171, 1814, 533, 706, 1719, 1879,
	1774, 284, 1796, 414, 1374, 1471, 1297, 1516, 1687, 177, 1604, 389, 1049, 1282, 967, 1403,
	1374, 1312, 2008, 171, 601, 501, 784, 318, 877, 284, 21, 1968, 414, 781, 1823, 1231,
	54, 506, 506, 1217, 1994, 1388, 389, 27, 1987, 1978, 1827, 736, 1839, 1316, 1509, 1262,
	402, 498, 692, 664, 526, 899, 718, 1337, 1986, 1894, 1979, 1486, 859, 1869, 1481, 1862,
	1709, 1347, 1957, 1708, 448, 1316, 1986, 1097, 877, 1957, 1944, 859, 2031, 626, 1713, 234,
	543, 723, 1838, 1232, 1294, 538, 1103, 1262, 523, 54, 912, 1202, 857, 1403, 1392, 642,
	1822, 1752, 212, 249, 226, 574, 1862, 591, 1516, 449, 2031, 447, 1721, 59, 1943, 1867,
	1721, 1616, 508, 1966, 1747, 1872, 899, 661, 167, 2008, 1719, 854, 1803, 1957, 664, 1944,
	102, 862, 427, 411, 872, 478, 1449, 723, 619, 1837, 642, 374, 402, 1867, 654, 591,
	832, 1224, 844, 844, 900, 874, 2671, 4314, 533, 1796, 284, 1374, 4508, 389, 912, 1403,
	591, 506, 736, 900, 1987, 1978, 1839, 601, 1968, 844, 1827, 1316, 1509, 4394, 1979, 664,
	1986, 1337, 899, 664, 1957, 448, 859, 1103, 54, 626, 538, 1713, 857, 234, 2031, 249,
	447, 642, 1721, 1516, 1224, 1872, 1747, 1943, 899, 1957, 872, 1771, 506, 237, 237, 3739,
	2059, 74, 804, 804, 237, 1801, 39, 39, 74, 74, 0, 74, 36, 237, 74, 74,
	177, 1398, 1137, 1137, 1968, 234, 234, 1836, 1377, 71, 71, 1507, 1399, 862, 277, 157,
	461, 1291, 1866, 1866, 1284, 1809, 1838, 3044, 954, 1281, 1886, 529, 0, 2021, 1847, 1639,
	1884, 674, 562, 1814, 413, 1738, 277, 1826, 3052, 4459, 1981, 674, 1873, 1717, 852, 187,
	174, 1097, 1647, 1979, 1838, 683, 646, 177, 284, 403, 317, 1269, 1713, 337, 1912, 1617,
	1519, 1692, 1334, 679, 627, 354, 1864, 992, 64, 644, 1053, 1837, 667, 2016, 869, 1809,
	1684, 1564, 1509, 1617, 1212, 599, 1099, 379, 1758, 1798, 1809, 101, 1862, 1761, 1327, 1669,
	1992, 1327, 319, 319, 1672, 679, 1639, 359, 1838, 1959, 1661, 529, 1739, 1509, 183, 1574,
	1909, 1346, 432, 852, 1461, 627, 843, 508, 807, 56, 274, 702, 64, 619, 2784, 899,
	1862, 1986, 674, 1869, 231, 787, 1716, 1639, 1839, 277, 1873, 917, 66, 1164, 1867, 294,
	1582, 379, 1584, 1818, 212, 187, 1637, 1869, 1507, 1966, 1862, 1884, 389, 74, 544, 389,
	1747, 622, 1327, 299, 277, 1717, 1057, 1837, 504, 1827, 204, 884, 1809, 1599, 319, 187,
	1873, 1574, 1600, 1293, 0, 1827, 524, 1946, 22, 1509, 134, 1574, 1574, 1906, 1956, 379,
	319, 892, 187, 272, 872, 2061, 1364, 1291, 1798, 1869, 1837, 1739, 862, 694, 1509, 69,
	1826, 954, 1769, 1584, 552, 1941, 1632, 403, 1003, 2034, 71, 801, 842, 1872, 1827, 917,
	843, 1839, 1657, 314, 644, 1856, 1471, 557, 1867, 962, 1397, 1322, 0, 784, 446, 726,
	86, 416, 1777, 3549, 0, 1498, 41, 1872, 266, 638, 1767, 41, 1736, 694, 1862, 557,
	1602, 1326, 69, 1236, 93, 1484, 54, 1698, 318, 2041, 1834, 872, 781, 531, 1991, 1506,
	761, 1869, 456, 572, 1309, 1979, 642, 1807, 599, 1777, 661, 1742, 531, 1162, 817, 647,
	774, 1974, 0, 1884, 1817, 182, 359, 1741, 923, 448, 1737, 447, 474, 568, 817, 647,
	493, 709, 1848, 97, 1744, 54, 844, 1882, 104, 1827, 1281, 1237, 1316, 541, 0, 1607,
	2041, 1262, 807, 1097, 176, 1862, 104, 1756, 286, 692, 1839, 1843, 1836, 2856, 1818, 977,
	1419, 54, 389, 1516, 699, 1868, 1884, 597, 787, 1756, 1756, 1566, 1612, 1017, 1741, 1398,
	204, 674, 2041, 692, 1736, 1756, 1882, 569, 1856, 68, 969, 167, 446, 863, 1842, 1677,
	604, 1301, 1816, 1946, 959, 1301, 1793, 314, 69, 1807, 69, 142, 1717, 1974, 969, 1474,
	872, 1267, 286, 987, 1834, 129, 774, 431, 989, 2041, 784, 1103, 1899, 157, 1861, 641,
	1819, 157, 1899, 877, 524, 1741, 431, 1899, 844, 1863, 341, 1327, 2027, 1224, 1989, 1837,
	461, 1868, 688, 1818, 2059, 967, 286, 1794, 359, 1966, 426, 0, 0, 1884, 1604, 1641,
	738, 1692, 2069, 556, 506, 1571, 1266, 197, 1894, 1018, 824, 234, 197, 1864, 1662, 1978,
	1751, 659, 182, 1844, 1672, 664, 977, 764, 1576, 834, 1277, 2059, 553, 1819, 1466, 1109,
	1717, 899, 813, 1816, 1617, 1221, 1943, 227, 1607, 2059, 2019, 254, 791, 1637, 997, 361,
	602, 1793, 1778, 1608, 686, 227, 1884, 1266, 739, 1566, 992, 1337, 198, 271, 1884, 1859,
	19, 1934, 553, 1612, 659, 1248, 1473, 1869, 842, 1907, 822, 1836, 659, 102, 664, 1741,
	1607, 1266, 1137, 1839, 843, 694, 664, 1839, 1109, 1397, 1806, 197, 1819, 877, 992, 992,
	1109, 1774, 661, 1466, 992, 1819, 113, 113, 1509, 1864, 1509, 1509, 843, 4484, 1833, 3359,
	842, 671, 0, 452, 1838, 863, 296, 1951, 341, 1266, 1327, 572, 448, 1966, 1977, 26,
	904, 448, 1053, 334, 1471, 1303, 759, 214, 2033, 412, 1867, 1736, 559, 496, 112, 962,
	1384, 319, 1559, 1744, 1839, 151, 1506, 1673, 1281, 1168, 1291, 0, 1384, 1239, 1812, 671,
	28, 416, 177, 1777, 358, 1879, 1817, 446, 104, 1049, 1771, 387, 702, 379, 501, 1843,
	1292, 38, 1424, 1372, 166, 1133, 426, 1883, 643, 1312, 1236, 541, 592, 1842, 706, 1506,
	1839, 1981, 1116, 459, 1384, 638, 1604, 729, 0, 897, 389, 0, 188, 237, 1097, 1672,
	1509, 1012, 511, 736, 877, 94, 1559, 508, 97, 1237, 1869, 1559, 2067, 104, 1862, 329,
	648, 1966, 1508, 1509, 1653, 694, 1292, 1506, 1596, 1799, 1951, 49, 572, 69, 1501, 202,
	1507, 97, 1994, 189, 1886, 1268, 1661, 1292, 447, 1938, 968, 1291, 447, 844, 1879, 1236,
	1821, 39, 96, 667, 501, 1519, 1971, 1038, 1098, 1116, 319, 646, 1039, 1608, 1496, 1838,
	1556, 784, 713, 53, 654, 1662, 1777, 592, 663, 188, 403, 479, 94, 1507, 1032, 546,
	1842, 706, 1986, 194, 1479, 1662, 33, 834, 531, 1869, 1791, 1373, 267, 1979, 1322, 1474,
	189, 1753, 1777, 1337, 1236, 1653, 1991, 597, 1017, 768, 1827, 1751, 1752, 1786, 706, 146,
	823, 642, 498, 1397, 993, 1836, 1841, 526, 13, 346, 1863, 1449, 734, 1292, 902, 0,
	6, 334, 559, 1409, 1209, 746, 1327, 1761, 1957, 1789, 1904, 1636, 274, 511, 498, 1981,
	359, 923, 977, 817, 959, 1771, 1882, 54, 1739, 1574, 1869, 157, 1658, 97, 559, 647,
	592, 709, 431, 842, 1708, 1979, 1556, 696, 1737, 1737, 1647, 498, 2027, 924, 679, 1313,
	1499, 557, 929, 1832, 202, 1929, 692, 1754, 387, 962, 1276, 842, 1209, 1409, 182, 474,
	843, 1624, 91, 1994, 0, 1671, 883, 2059, 694, 163, 1708, 654, 466, 334, 1617, 162,
	912, 739, 877, 51, 899, 842, 1296, 1222, 698, 1013, 2059, 1232, 14, 51, 1754, 1811,
	2016, 834, 1, 1296, 1599, 791, 363, 1719, 222, 2031, 1971, 56, 1116, 2036, 227, 1607,
	344, 1282, 1292, 2019, 641, 1869, 673, 523, 967, 161, 328, 1741, 854, 1617, 509, 274,
	1519, 1966, 899, 988, 899, 606, 78, 452, 807, 743, 416, 1738, 1054, 1708, 1899, 0,
	302, 1751, 0, 636, 676, 0, 982, 718, 1846, 187, 854, 541, 1753, 364, 1671, 1718,
	2036, 449, 1392, 642, 389, 706, 1966, 1637, 1932, 592, 1822, 369, 1747, 1867, 1966, 1776,
	622, 1718, 449, 1482, 146, 1309, 1487, 591, 787, 1164, 1032, 1301, 1301, 597, 1666, 241,
	617, 1834, 1012, 654, 366, 654, 1556, 531, 602, 1796, 1958, 574, 1966, 71, 1981, 2031,
	1786, 1832, 978, 1204, 6, 669, 0, 977, 146, 1596, 44, 1747, 852, 1593, 1284, 882,
	2047, 1834, 1144, 1726, 1387, 1612, 1593, 1296, 477, 1554, 222, 97, 1207, 276, 66, 1436,
	466, 2031, 1736, 1847, 621, 1647, 882, 718, 1588, 1461, 1566, 1709, 569, 1969, 1969, 817,
	1839, 1872, 1613, 1119, 1741, 646, 476, 948, 696, 1564, 0, 1593, 0, 0, 0, 1047,
	898, 1593, 1194, 2047, 1677, 1786, 524, 1799, 854, 1514, 24, 958, 1029, 833, 69, 1584,
	882, 317, 118, 241, 1843, 899, 22, 746, 1296, 261, 1281, 162, 1611, 959, 1856, 158,
	431, 679, 76, 1519, 894, 1789, 241, 887, 1899, 654, 127, 842, 601, 1741, 726, 0,
	64, 0, 0, 1971, 899, 607, 642, 1277, 629, 1298, 1266, 872, 134, 1789, 1754, 1612,
	534, 1556, 884, 1067, 622, 1253, 1584, 412, 1302, 2009, 1822, 1611, 1759, 702, 661, 2061,
	864, 667, 822, 374, 1607, 1896, 641, 653, 1981, 314, 1739, 1849, 374, 702, 1144, 1639,
	1278, 1653, 0, 0, 343, 1471, 716, 654, 424, 1584, 898, 696, 629, 1869, 852, 2026,
	1301, 1291, 2027, 832, 69, 1653, 617, 1834, 382, 543, 291, 694, 1806, 1599, 54, 1839,
	9, 1463, 1809, 334, 1994, 587, 374, 644, 1119, 1596, 639, 1316, 86, 1846, 789, 1127,
	1791, 654, 654, 1293, 148, 1979, 1009, 842, 832, 641, 2051, 784, 1479, 1232, 804, 362,
	1554, 234, 924, 76, 1217, 898, 0, 0, 887, 389, 897, 1771, 654, 812, 97, 651,
	1829, 157, 1756, 654, 1742, 524, 122, 1119, 833, 256, 1332, 1209, 917, 2051, 902, 1907,
	1119, 702, 1613, 1992, 812, 671, 452, 1838, 1966, 341, 1951, 1266, 863, 1673, 1291, 214,
	1471, 642, 412, 334, 982, 1168, 1822, 151, 1777, 459, 104, 1604, 694, 379, 166, 1981,
	1049, 54, 2966, 38, 1292, 1829, 1311, 706, 1736, 501, 729, 416, 638, 358, 1133, 28,
	1869, 1292, 1971, 1292, 508, 96, 736, 1268, 104, 97, 1879, 4551, 1039, 1608, 648, 329,
	1862, 1653, 97, 877, 1554, 1291, 968, 49, 1509, 1799, 1596, 69, 1097, 1237, 382, 1777,
	734, 823, 403, 962, 1814, 1863, 182, 647, 1832, 1067, 1979, 291, 1662, 923, 334, 1841,
	718, 1932, 1991, 1753, 1658, 346, 1751, 607, 1337, 369, 546, 1827, 479, 1017, 1971, 1449,
	663, 1836, 158, 194, 1611, 11, 1842, 1397, 1994, 822, 3776, 1737, 807, 1624, 854, 746,
	1761, 1593, 843, 1929, 202, 541, 474, 387, 1789, 274, 919, 431, 1771, 883, 716, 654,
	1409, 1636, 817, 1313, 692, 1, 1296, 1958, 1164, 274, 967, 56, 1282, 302, 739, 791,
	161, 1741, 509, 917, 222, 2016, 673, 1979, 1751, 698, 601, 1222, 1607, 344, 654, 694,
	988, 2031, 1309, 1846, 718, 1296, 1556, 389, 146, 1301, 1981, 369, 1566, 622, 617, 6,
	364, 978, 894, 2031, 424, 977, 1029, 1969, 97, 477, 1119, 1613, 696, 1119, 1047, 882,
	569, 44, 1839, 646, 86, 1387, 76, 1611, 959, 833, 64, 1856, 679, 317, 2047, 1799,
	882, 1772, 702, 864, 1277, 898, 374, 812, 1278, 256, 1298, 311, 639, 832, 617, 2027,
	852, 1839, 148, 76, 804, 157, 1756, 162, 162, 688, 23, 337, 1331, 863, 992, 2662,
	982, 949, 1531, 1473, 639, 982, 1817, 69, 559, 69, 1471, 716, 729, 416, 592, 1414,
	967, 1752, 1752, 651, 1013, 1746, 1543, 359, 1932, 1069, 0, 1231, 738, 877, 74, 69,
	1869, 572, 521, 477, 477, 407, 204, 594, 531, 1013, 0, 793, 819, 922, 1657, 1464,
	691, 1879, 1879, 158, 1334, 874, 161, 1461, 793, 1816, 1334, 1817, 1816, 631, 1869, 1722,
	1759, 46, 1759, 1334, 1828, 1722, 38, 14, 1717, 1841, 799, 1344, 812, 361, 0, 0,
	1642, 1119, 1599, 718, 572, 1344, 218, 521, 359, 1283, 786, 1612, 521, 1247, 724, 1741,
	629, 158, 1239, 291, 617, 1599, 1722, 0, 982, 1531, 1473, 1817, 559, 69, 1724, 218,
	1414, 1717, 1752, 592, 3151, 1013, 729, 3484, 1932, 1069, 531, 1722, 1599, 1013, 922, 718,
	407, 477, 572, 793, 686, 1879, 819, 361, 1869, 1816, 161, 1744, 1722, 631, 1817, 1816,
	158, 812, 1334, 629, 799, 1344, 572, 1642, 1599, 1344, 724, 617, 449, 443, 829, 374,
	1774, 1291, 1736, 459, 1979, 1841, 1822, 358, 389, 1501, 38, 1222, 746, 1883, 1403, 1978,
	1237, 678, 417, 1822, 1841, 1969, 666, 181, 389, 1331, 318, 2048, 2069, 329, 878, 2501,
	1692, 1692, 51, 93, 449, 644, 899, 888, 177, 1777, 384, 894, 1029, 3159, 1516, 384,
	1754, 402, 533, 1869, 456, 1473, 1809, 1304, 1777, 227, 449, 69, 1747, 1473, 1501, 1979,
	1276, 358, 1874, 1969, 202, 1754, 197, 1119, 1883, 1753, 1222, 423, 2041, 1836, 373, 912,
	1841, 691, 222, 177, 1237, 877, 1617, 1754, 899, 0, 1753, 1841, 1993, 1822, 1377, 1747,
	192, 1819, 1841, 1867, 316, 1867, 887, 1716, 1716, 1119, 374, 1582, 13, 622, 666, 1582,
	1843, 1282, 1818, 626, 477, 1883, 1739, 1718, 9, 1744, 1612, 644, 1949, 298, 22, 1744,
	1843, 158, 1827, 872, 1682, 314, 1238, 1584, 1582, 24, 1753, 426, 992, 402, 641, 298,
	1742, 1843, 1344, 626, 888, 1741, 844, 844, 844, 2016, 574, 1976, 1588, 699, 3557, 1834,
	1344, 1819, 12, 716, 1782, 1813, 642, 509, 2016, 1979, 504, 699, 237, 1856, 691, 202,
	601, 1887, 919, 1867, 197, 331, 1581, 559, 639, 1536, 524, 202, 1887, 1856, 641, 1741,
	197, 2027, 842, 1057, 1802, 1887, 642, 642, 1868, 1867, 1803, 1749, 443, 1449, 1039, 1722,
	426, 1211, 1882, 844, 844, 1821, 877, 832, 461, 47, 1739, 329, 294, 601, 1739, 1954,
	1791, 644, 1039, 177, 1761, 1934, 1657, 1969, 1224, 977, 877, 1281, 196, 639, 1464, 421,
	592, 1941, 1841, 1097, 1994, 1687, 872, 0, 354, 1846, 1739, 877, 1536, 876, 1747, 592,
	1841, 1029, 954, 1883, 881, 987, 86, 1739, 1719, 799, 1842, 1742, 1839, 8, 289, 311,
	1754, 1869, 3399, 887, 284, 642, 1212, 1822, 29, 1236, 1716, 0, 1743, 644, 952, 987,
	987, 832, 844, 1583, 8, 424, 284, 887, 877, 9, 431, 844, 48, 0, 574, 574,
	94, 1316, 1316, 679, 1641, 1966, 679, 184, 1319, 679, 679, 329, 679, 1641, 421, 421,
	734, 992, 3499, 999, 1219, 1834, 1643, 629, 1834, 477, 341, 147, 651, 1374, 317, 364,
	1739, 1374, 1312, 674, 1801, 1133, 28, 1843, 1423, 1079, 1029, 2048, 277, 39, 1839, 1829,
	1617, 54, 666, 592, 49, 1821, 93, 1841, 477, 1617, 667, 1767, 11, 11, 582, 498,
	1479, 277, 1302, 1656, 957, 1849, 1581, 1647, 1304, 1799, 754, 63, 1599, 1479, 93, 799,
	691, 805, 1767, 1392, 41, 1839, 1326, 1326, 572, 1764, 1039, 691, 651, 71, 316, 651,
	0, 1616, 501, 1599, 54, 1767, 1207, 477, 69, 799, 0, 892, 534, 1302, 1801, 641,
	651, 656, 159, 277, 604, 1753, 1291, 362, 1699, 651, 812, 1717, 1374, 447, 1029, 1339,
	477, 1718, 1304, 557, 164, 227, 1392, 1884, 1489, 1718, 477, 34, 1616, 501, 1884, 22,
	69, 1718, 629, 362, 1699, 362, 1717, 1374, 447, 557, 1718, 1884, 1616, 688, 688, 1751,
	1769, 1751, 641, 1841, 1887, 1884, 1482, 829, 1232, 622, 1846, 1884, 1232, 11, 1841, 1758,
	604, 1834, 343, 1318, 787, 1759, 1549, 556, 1791, 1837, 1791, 509, 1564, 788, 1282, 562,
	1869, 1707, 36, 379, 317, 286, 1209, 1266, 878, 134, 678, 833, 572, 1301, 389, 387,
	1718, 667, 511, 1498, 1837, 1498, 736, 67, 1241, 1262, 834, 448, 647, 1667, 629, 787,
	647, 829, 1658, 181, 1848, 706, 602, 559, 678, 1682, 1682, 1257, 809, 1682, 2031, 2031,
	222, 344, 809, 1819, 559, 651, 736, 264, 683, 1311, 1837, 1426, 1637, 387, 389, 1817,
	634, 723, 1857, 2006, 1817, 1753, 1774, 1838, 1874, 1438, 326, 326, 658, 761, 834, 864,
	1248, 1839, 956, 254, 1304, 569, 1302, 509, 1809, 853, 629, 159, 1397, 591, 86, 1753,
	1257, 897, 873, 1119, 1337, 1834, 343, 1318, 556, 1759, 1549, 1791, 1791, 1707, 509, 379,
	1282, 36, 1564, 562, 1869, 897, 878, 1266, 678, 667, 647, 1658, 477, 1848, 683, 736,
	1837, 1257, 629, 1682, 559, 1848, 1848, 736, 1637, 1857, 389, 2006, 1817, 387, 1119, 956,
	326, 1438, 569, 834, 159, 1397, 1257, 1337, 431, 76, 431, 447, 1746, 1943, 1217, 1424,
	27, 1602, 869, 511, 1799, 1484, 694, 66, 1556, 1718, 1822, 1827, 1566, 718, 1441, 411,
	882, 1742, 862, 1246, 1246, 882, 76, 76, 76, 862, 0, 1449, 431, 76, 431, 1822,
	1943, 1217, 1424, 694, 1556, 1566, 1827, 882, 1246, 76, 76, 421, 411, 421, 421, 4007,
	1507, 116, 641, 344, 1559, 1691, 1941, 1586, 1758, 1687, 1374, 1869, 699, 189, 1843, 414,
	414, 1586, 1843, 1994, 1837, 1938, 69, 668, 1616, 883, 237, 1654, 1559, 48, 1509, 384,
	9, 1374, 1643, 663, 572, 93, 1827, 1662, 237, 1758, 1823, 1823, 403, 1819, 830, 1741,
	116, 96, 1078, 389, 101, 709, 359, 1574, 1867, 1509, 1827, 632, 543, 416, 654, 234,
	93, 1754, 104, 1834, 289, 423, 1946, 1719, 523, 389, 1153, 632, 602, 622, 1654, 1872,
	1941, 597, 9, 1777, 426, 1719, 508, 146, 1564, 1612, 97, 471, 1744, 789, 884, 1566,
	1617, 1834, 1721, 1027, 1612, 957, 69, 1869, 1786, 673, 1433, 789, 2009, 1474, 1743, 289,
	1834, 641, 1362, 1612, 1856, 1616, 1584, 1758, 1941, 426, 554, 987, 1819, 1027, 157, 1758,
	917, 1899, 1063, 1507, 344, 641, 1691, 1777, 4187, 1744, 1374, 1869, 189, 414, 4343, 654,
	1509, 48, 1559, 384, 1837, 403, 1362, 1758, 572, 830, 663, 1741, 93, 96, 359, 389,
	1867, 1078, 709, 543, 632, 1754, 523, 146, 789, 508, 1566, 157, 1834, 1027, 97, 884,
	1786, 673, 957, 1433, 2009, 1062, 1513, 787, 542, 1756, 427, 27, 1097, 69, 97, 1672,
	556, 421, 651, 11, 8, 449, 1291, 1884, 1771, 427, 86, 1779, 948, 1869, 432, 559,
	317, 1692, 1691, 187, 1809, 1994, 1976, 1224, 1774, 1384, 1424, 1883, 1722, 1977, 289, 922,
	1862, 97, 48, 774, 1692, 1839, 1331, 1976, 1331, 681, 98, 1951, 1871, 1231, 1989, 694,
	1994, 1147, 691, 1236, 1903, 649, 877, 1968, 1602, 449, 1823, 1508, 69, 1692, 1692, 1559,
	882, 949, 1242, 1617, 1979, 1387, 1632, 354, 1807, 1337, 1496, 681, 403, 554, 97, 0,
	1841, 919, 1986, 289, 1769, 882, 692, 1563, 1311, 962, 817, 559, 1672, 1796, 1684, 709,
	387, 183, 1776, 7, 899, 2016, 1986, 1489, 1242, 791, 1617, 807, 2036, 739, 1282, 1282,
	1819, 421, 1441, 1819, 1834, 1828, 1739, 1244, 241, 1244, 1292, 421, 622, 654, 636, 1869,
	1637, 1337, 1747, 2036, 787, 1392, 1556, 511, 157, 531, 1566, 1291, 182, 1979, 882, 1212,
	1632, 1741, 128, 362, 11, 1872, 2041, 1441, 1474, 1282, 1979, 1538, 899, 1869, 917, 1946,
	1029, 24, 116, 1249, 241, 1331, 69, 1979, 1869, 1791, 607, 96, 1574, 1761, 872, 158,
	376, 882, 1607, 142, 329, 661, 1653, 1819, 917, 1941, 676, 1839, 1834, 1691, 1256, 1989,
	1819, 1232, 922, 1632, 1756, 644, 1536, 691, 1742, 616, 842, 76, 948, 1869, 1692, 1809,
	187, 1331, 1384, 97, 922, 1903, 1508, 1559, 449, 691, 2041, 1994, 1692, 1147, 649, 1839,
	1602, 1761, 949, 1841, 661, 607, 919, 554, 1242, 76, 842, 183, 1819, 1776, 1311, 709,
	1282, 1282, 739, 2016, 2036, 1574, 116, 1244, 1979, 787, 1441, 1739, 24, 882, 1291, 1474,
	1249, 917, 241, 158, 1989, 644, 1536, 1756, 3008, 1718, 1718, 1718, 1867, 464, 1839, 16,
	1667, 647, 46, 993, 236, 1638, 318, 761, 552, 552, 597, 769, 477, 1683, 493, 1242,
	69, 736, 1289, 1867, 1583, 892, 97, 1761, 1212, 96, 236, 776, 89, 1027, 862, 892,
	1761, 362, 1901, 1583, 1638, 89, 776, 897, 471, 471, 1304, 731, 1301, 824, 1909, 1471,
	791, 791, 317, 418, 1786, 1352, 967, 289, 791, 89, 406, 1647, 1236, 2031, 409, 1352,
	1639, 1217, 69, 967, 437, 402, 1387, 1331, 0, 1786, 799, 644, 1232, 1996, 1481, 1461,
	1639, 844, 89, 2036, 1639, 1232, 1561, 1971, 1337, 2036, 1549, 653, 383, 602, 804, 686,
	1282, 852, 1968, 89, 1232, 949, 1431, 957, 957, 1456, 1791, 869, 1291, 1291, 1137, 617,
	799, 1127, 89, 869, 1127, 359, 359, 1069, 594, 1744, 359, 558, 359, 359, 686, 164,
	1869, 1869, 844, 699, 448, 1772, 531, 2036, 884, 531, 1476, 1869, 533, 979, 644, 1282,
	669, 787, 632, 27, 1269, 979, 1791, 1818, 1761, 858, 1869, 1682, 1281, 1713, 858, 1719,
	651, 186, 1246, 69, 1027, 641, 1791, 198, 1818, 654, 1867, 296, 1372, 644, 0, 496,
	1694, 334, 643, 1794, 387, 389, 1461, 562, 1687, 1029, 669, 1498, 39, 1872, 67, 898,
	1722, 602, 897, 1887, 417, 427, 1049, 1862, 0, 0, 572, 1289, 1331, 556, 1222, 877,
	1692, 29, 1327, 1262, 447, 69, 2031, 1719, 691, 331, 97, 1862, 538, 1237, 1102, 1776,
	1602, 49, 449, 1933, 694, 508, 1507, 351, 0, 1599, 667, 1516, 599, 1758, 402, 11,
	1717, 1954, 1991, 1844, 869, 919, 1662, 1837, 1282, 94, 1718, 661, 104, 531, 1751, 477,
	627, 0, 0, 733, 1786, 382, 706, 1637, 998, 1761, 1933, 1461, 1311, 1867, 1078, 1957,
	538, 493, 0, 1739, 1327, 1657, 1276, 619, 197, 843, 1461, 1461, 474, 987, 0, 844,
	0, 1741, 1858, 1496, 2031, 1282, 1316, 1758, 1078, 227, 644, 331, 1309, 509, 1988, 351,
	807, 421, 1097, 1839, 791, 877, 689, 161, 676, 912, 877, 2041, 842, 988, 2036, 1979,
	1102, 603, 1867, 0, 1506, 116, 619, 1637, 597, 1776, 1991, 804, 2036, 644, 71, 71,
	619, 1337, 1917, 1716, 1716, 1867, 226, 1392, 337, 622, 854, 1818, 1326, 1326, 654, 69,
	389, 1822, 449, 1426, 1752, 1746, 1693, 602, 0, 1419, 0, 1721, 651, 569, 1736, 1212,
	1441, 882, 948, 1507, 1506, 521, 0, 1632, 1598, 1827, 477, 1387, 1292, 1282, 1721, 1419,
	1497, 852, 22, 829, 1867, 1013, 644, 1647, 1331, 651, 1441, 957, 1742, 1327, 79, 644,
	644, 1992, 656, 1326, 2006, 1856, 1946, 726, 1803, 81, 1869, 1331, 1759, 96, 663, 1807,
	1574, 622, 2061, 1474, 1474, 411, 534, 872, 1807, 1304, 1743, 0, 0, 429, 617, 599,
	774, 1917, 1441, 1941, 463, 534, 1502, 843, 162, 0, 0, 0, 1397, 644, 1794, 639,
	0, 844, 869, 1879, 1009, 1966, 1758, 389, 897, 524, 842, 1751, 1867, 296, 643, 1862,
	1687, 898, 417, 26, 572, 29, 1262, 1102, 897, 1862, 1933, 449, 97, 49, 599, 1237,
	1602, 531, 667, 733, 1718, 402, 1662, 1917, 599, 774, 644, 661, 4251, 1933, 1758, 1807,
	493, 842, 852, 651, 843, 1507, 1647, 538, 1461, 619, 706, 644, 1858, 1316, 877, 1282,
	2041, 421, 791, 161, 509, 1097, 1102, 331, 676, 1496, 1506, 2031, 1226, 337, 69, 162,
	1637, 1721, 1716, 1426, 389, 1326, 449, 622, 1337, 656, 71, 1441, 22, 1282, 1598, 521,
	1827, 1212, 651, 829, 79, 1803, 81, 957, 1013, 1856, 1719, 1742, 534, 1474, 872, 2061,
	639, 463, 843, 1941, 523, 1113, 1839, 447, 844, 686, 103, 1819, 447, 296, 641, 434,
	1399, 461, 1506, 434, 1017, 48, 1871, 1976, 604, 1292, 446, 426, 1722, 1817, 1506, 1869,
	104, 1826, 704, 702, 1236, 616, 1969, 48, 1819, 1811, 1974, 416, 434, 1722, 1191, 1624,
	646, 1147, 877, 1009, 407, 1692, 1722, 844, 73, 1979, 476, 1871, 2031, 1332, 1761, 186,
	289, 691, 1828, 506, 1981, 1869, 1821, 1389, 1811, 1839, 1869, 1642, 1846, 371, 1736, 402,
	511, 9, 1976, 1819, 587, 661, 666, 869, 1991, 1372, 1837, 592, 919, 1397, 1032, 476,
	1372, 661, 1786, 1986, 186, 477, 562, 0, 403, 902, 647, 644, 1672, 616, 1693, 103,
	1737, 696, 1869, 97, 1809, 1809, 642, 1741, 706, 692, 1671, 676, 1637, 387, 387, 782,
	602, 1738, 1496, 809, 663, 0, 899, 94, 1516, 447, 11, 2026, 1232, 1312, 1291, 51,
	331, 899, 1344, 651, 692, 1674, 1811, 1871, 1282, 842, 1834, 2016, 751, 384, 791, 1501,
	1282, 676, 1839, 1839, 676, 2031, 807, 351, 1281, 227, 491, 691, 1331, 0, 0, 641,
	1519, 0, 189, 1002, 1392, 11, 1326, 1637, 602, 1637, 389, 666, 967, 447, 226, 1671,
	1818, 572, 1872, 1241, 791, 977, 602, 1846, 1872, 1739, 692, 654, 121, 418, 509, 1846,
	1872, 1751, 1726, 1506, 574, 202, 1612, 1747, 1419, 882, 642, 602, 651, 2023, 557, 237,
	2031, 1839, 1829, 1819, 641, 844, 1642, 759, 1636, 1636, 1099, 1672, 948, 1119, 663, 1966,
	177, 642, 2006, 1959, 22, 1828, 1836, 1191, 189, 1979, 884, 1857, 892, 69, 1536, 2027,
	1867, 1737, 702, 1842, 1637, 1556, 661, 1839, 607, 69, 1846, 1574, 622, 412, 1302, 862,
	1819, 731, 689, 1752, 1752, 1672, 953, 2061, 1869, 1846, 899, 376, 1752, 1802, 1839, 1239,
	2029, 917, 1741, 1837, 641, 1912, 1867, 1941, 1834, 1822, 1239, 1127, 639, 1506, 1846, 987,
	317, 1879, 1869, 833, 1279, 897, 574, 887, 1536, 1879, 1846, 524, 1332, 842, 902, 1113,
	686, 641, 1871, 1017, 1506, 1191, 1811, 121, 48, 1969, 506, 351, 897, 1811, 1761, 1821,
	877, 186, 1332, 1871, 1802, 1692, 1556, 1979, 402, 511, 1786, 587, 1986, 476, 902, 592,
	1737, 97, 842, 696, 602, 387, 1869, 1752, 1637, 1738, 1344, 1002, 11, 791, 51, 1232,
	1291, 227, 491, 1871, 1574, 602, 572, 389, 602, 1326, 237, 977, 1739, 1099, 1829, 1726,
	882, 642, 1839, 651, 574, 1836, 1846, 1959, 884, 862, 661, 689, 1869, 899, 1797, 1941,
	1846, 636, 987, 524, 1536, 898, 671, 877, 653, 1752, 272, 653, 653, 1817, 272, 899,
	1861, 251, 643, 1217, 251, 1217, 1994, 706, 1993, 651, 992, 992, 1868, 882, 177, 706,
	872, 1097, 1282, 899, 689, 706, 676, 844, 1756, 1817, 646, 992, 844, 1489, 1946, 872,
	676, 1282, 877, 1817, 251, 954, 954, 1283, 168, 446, 999, 998, 446, 1219, 1333, 1331,
	1032, 446, 1754, 807, 1331, 999, 842, 431, 446, 1331, 1331, 947, 975, 975, 626, 923,
	2041, 1081, 427, 622, 622, 671, 526, 1641, 1668, 591, 1741, 783, 591, 1518, 842, 1102,
	842, 576, 576, 1839, 1292, 288, 1744, 1678, 1029, 1029, 1292, 284, 204, 1863, 328, 1836,
	1747, 1818, 1331, 978, 1818, 1317, 1879, 842, 293, 362, 118, 1816, 14, 1818, 1608, 14,
	1968, 284, 118, 1836, 977, 1945, 1818, 362, 897, 1978, 428, 447, 448, 1013, 1013, 1872,
	254, 1334, 167, 1696, 1991, 1976, 988, 22, 81, 1692, 69, 1872, 167, 1692, 343, 994,
	1054, 343, 2031, 508, 508, 351, 427, 1617, 1871, 1237, 161, 471, 1284, 1871, 1611, 1631,
	1518, 1859, 427, 424, 1722, 27, 331, 1692, 1981, 1332, 1501, 1507, 1864, 1507, 1657, 1737,
	54, 676, 632, 1334, 1818, 1671, 1556, 1741, 1754, 1818, 832, 67, 1828, 1327, 556, 1736,
	1698, 596, 844, 389, 1931, 1789, 1729, 1931, 1139, 1064, 1282, 1936, 644, 2031, 641, 641,
	1282, 641, 188, 179, 179, 572, 1812, 1842, 1769, 46, 274, 1509, 2031, 186, 1818, 693,
	1647, 877, 877, 201, 1337, 1769, 1842, 1119, 689, 1828, 234, 793, 1868, 203, 1838, 1097,
	1912, 2041, 1333, 1083, 1818, 1192, 389, 1734, 1839, 271, 2041, 326, 203, 674, 1814, 188,
	179, 572, 1842, 693, 877, 46, 1647, 2031, 1842, 1868, 234, 1333, 1734, 887, 1212, 496,
	1212, 1818, 887, 887, 496, 721, 1599, 877, 277, 887, 496, 721, 531, 1326, 81, 531,
	1879, 224, 572, 702, 1767 
};

int gnPinyinPlusTones = sizeof(PinyinTableWithTones) / sizeof(char *);
int gnMaxCJK = sizeof(CJKUnicodeOffsetToPinyinTable)/sizeof(short);
