/*******************************************
	ILE_KANA.C	updated at 19th May 1989
	2-byte kana to internal code conversion
 *******************************************/

#define		EXT		extern

#include	"onsei.h"
#include	"ile_func.h"
#include	"ile_nydh.h"
#include	"ile_shdh.h"

/* JIS codes are in lower 8 bits.*/
/* Long-vowel symbols are processed separately.*/

static const BYTE kana_tbl[]={
	0x22,0x00,	0x00,	/* A */
	0x24,0x00,	0x01,	/* C */
	0x26,0x00,	0x02,	/* E */
	0x28,0x00,	0x03,	/* G */
	0x2A,0x00,	0x04,	/* I */

	0x2B,0x00,	0x08,	/* J */
	0x2D,0x00,	0x09,	/* L */
	0x2F,0x00,	0x0A,	/* N */
	0x31,0x00,	0x0B,	/* P */
	0x33,0x00,	0x0C,	/* R */
	0x2D,0x63,	0x0D,	/* L */
	0x2D,0x65,	0x0E,	/* L */
	0x2D,0x67,	0x0F,	/* L */

	0x35,0x00,	0x10,	/* T */
	0x39,0x23,	0x11,	/* XB */
	0x39,0x00,	0x12,	/* X */
	0x3B,0x00,	0x13,	/* Z */
	0x3D,0x00,	0x14,	/* \ */

	0x37,0x63,	0x18,	/* V */
	0x37,0x00,	0x19,	/* V */
	0x37,0x65,	0x1A,	/* V */
	0x37,0x27,	0x1B,	/* VF */
	0x37,0x67,	0x1C,	/* V */

	0x3F,0x00,	0x20,	/* ^ */
	0x46,0x23,	0x21,	/* eB */
	0x48,0x25,	0x22,	/* gD */
	0x46,0x00,	0x23,	/* e */
	0x48,0x00,	0x24,	/* g */

	0x41,0x63,	0x28,	/* ` */
	0x41,0x00,	0x29,	/* ` */
	0x41,0x65,	0x2A,	/* ` */
	0x41,0x27,	0x2B,	/* `F */
	0x41,0x67,	0x2C,	/* ` */

	0x44,0x21,	0x30,	/* c@ */
	0x44,0x23,	0x31,	/* cB */
	0x44,0x00,	0x32,	/* c */
	0x44,0x27,	0x33,	/* cF */
	0x44,0x29,	0x34,	/* cH */

	0x4A,0x00,	0x38,	/* i */
	0x4B,0x00,	0x39,	/* j */
	0x4C,0x00,	0x3A,	/* k */
	0x4D,0x00,	0x3B,	/* l */
	0x4E,0x00,	0x3C,	/* m */
	0x4B,0x63,	0x3D,	/* j */
	0x4B,0x65,	0x3E,	/* j */
	0x4B,0x67,	0x3F,	/* j */

	0x4F,0x00,	0x40,	/* n */
	0x52,0x00,	0x41,	/* q */
	0x55,0x00,	0x42,	/* t */
	0x58,0x00,	0x43,	/* w */
	0x5B,0x00,	0x44,	/* z */
	0x52,0x63,	0x45,	/* q */
	0x52,0x65,	0x46,	/* q */
	0x52,0x67,	0x47,	/* q */

	0x55,0x21,	0x48,	/* t@ */
	0x55,0x23,	0x49,	/* tB */
	0x55,0x27,	0x4B,	/* tF */
	0x55,0x29,	0x4C,	/* tH */
	0x55,0x63,	0x4D,	/* t */
	0x55,0x65,	0x4E,	/* t */
	0x55,0x67,	0x4F,	/* t */

	0x5E,0x00,	0x50,	/* } */
	0x5F,0x00,	0x51,	/* ~ */
	0x60,0x00,	0x52,	/*  */
	0x61,0x00,	0x53,	/*  */
	0x62,0x00,	0x54,	/*  */
	0x5F,0x63,	0x55,	/* ~ */
	0x5F,0x65,	0x56,	/* ~ */
	0x5F,0x67,	0x57,	/* ~ */

	0x64,0x00,	0x58,	/*  */
	0x66,0x00,	0x5A,	/*  */
	0x68,0x00,	0x5C,	/*  */

	0x69,0x00,	0x60,	/*  */
	0x6A,0x00,	0x61,	/*  */
	0x6B,0x00,	0x62,	/*  */
	0x6C,0x00,	0x63,	/*  */
	0x6D,0x00,	0x64,	/*  */
	0x6A,0x63,	0x65,	/*  */
	0x6A,0x65,	0x66,	/*  */
	0x6A,0x67,	0x67,	/*  */

	0x6F,0x00,	0x68,	/*  */
	0x26,0x23,	0x69,	/* EB */
	0x26,0x27,	0x6B,	/* EF */
	0x26,0x29,	0x6C,	/* EH */

	0x2C,0x00,	0x70,	/* K */
	0x2E,0x00,	0x71,	/* M */
	0x30,0x00,	0x72,	/* O */
	0x32,0x00,	0x73,	/* Q */
	0x34,0x00,	0x74,	/* S */
	0x2E,0x63,	0x75,	/* M */
	0x2E,0x65,	0x76,	/* M */
	0x2E,0x67,	0x77,	/* M */

	0x36,0x00,	0x80,	/* U */
	0x3A,0x23,	0x81,	/* YB */
	0x3A,0x00,	0x82,	/* Y */
	0x45,0x00,	0x82,	/* d */
	0x3C,0x00,	0x83,	/* [ */
	0x3E,0x00,	0x84,	/* ] */

	0x38,0x63,	0x88,	/* W */
	0x38,0x00,	0x89,	/* W */
	0x38,0x65,	0x8A,	/* W */
	0x38,0x27,	0x8B,	/* WF */
	0x38,0x67,	0x8C,	/* W */

	0x42,0x63,	0x88,	/* a */
	0x42,0x00,	0x89,	/* a */
	0x42,0x65,	0x8A,	/* a */
	0x42,0x27,	0x8B,	/* aF */
	0x42,0x67,	0x8C,	/* a */

	0x40,0x00,	0x90,	/* _ */
	0x47,0x23,	0x91,	/* fB */
	0x49,0x25,	0x92,	/* hD */
	0x47,0x00,	0x93,	/* f */
	0x49,0x00,	0x94,	/* h */
	0x47,0x63,	0x95,	/* f */
	0x47,0x65,	0x96,	/* f */
	0x47,0x67,	0x97,	/* f */

	0x50,0x00,	0x98,	/* o */
	0x53,0x00,	0x99,	/* r */
	0x56,0x00,	0x9A,	/* u */
	0x59,0x00,	0x9B,	/* x */
	0x5C,0x00,	0x9C,	/* { */
	0x53,0x63,	0x9D,	/* r */
	0x53,0x65,	0x9E,	/* r */
	0x53,0x67,	0x9F,	/* r */

	0x51,0x00,	0xA0,	/* p */
	0x54,0x00,	0xA1,	/* s */
	0x57,0x00,	0xA2,	/* v */
	0x5A,0x00,	0xA3,	/* y */
	0x5D,0x00,	0xA4,	/* | */
	0x54,0x63,	0xA5,	/* s */
	0x54,0x65,	0xA6,	/* s */
	0x54,0x67,	0xA7,	/* s */

	0x74,0x21,	0xA8,	/* @ */
	0x74,0x23,	0xA9,	/* B */
	0x74,0x00,	0xAA,	/*  */
	0x74,0x27,	0xAB,	/* F */
	0x74,0x29,	0xAC,	/* H */
	0x74,0x63,	0xAD,	/*  */
	0x74,0x65,	0xAE,	/*  */
	0x74,0x67,	0xAF,	/*  */

	0x2F,0x21,	0xB0,	/* N@ */
	0x2F,0x23,	0xB1,	/* NB */
	0x2F,0x27,	0xB3,	/* NF */
	0x2F,0x29,	0xB4,	/* NH */

	0x30,0x21,	0xB8,	/* O@ */
	0x30,0x23,	0xB9,	/* OB */
	0x30,0x27,	0xBB,	/* OF */
	0x30,0x29,	0xBC,	/* OH */

	0x43,0x00,	0xCF,	/* b */
	0x72,0x00,	0x04,	/*  */
	0x73,0x00,	0xD7,	/*  */

	0x21,0x00,	0x00,	/* @ */
	0x23,0x00,	0x01,	/* B */
	0x25,0x00,	0x02,	/* D */
	0x27,0x00,	0x03,	/* F */
	0x29,0x00,	0x04,	/* H */
	0x63,0x00,	0x58,	/*  */
	0x65,0x00,	0x5A,	/*  */
	0x67,0x00,	0x5C,	/*  */
	0x6E,0x00,	0x68,	/*  */
	0x70,0x00,	0x01,	/*  */
	0x71,0x00,	0x03,	/*  */
	0x75,0x00,	0x08,	/*  */
	0x76,0x00,	0x0B,	/*  */
	0					/* STOPPER */
};


/*========== kana_mora() ===========================
	Function:  Convert the 2-byte kana character string into the internal phonetic code.
	Value:	0: Conversion failed.
			1: Conversion succeeded.
  ==================================================*/
BOOL kana_mora() 
{
	integer_16 len,n;
	register BYTE *si,*bp;
	BYTE ch,a[2];
	
	si=ceptr*2+inert;
	len=celen;
	
	/* Offset of the mora data storage area */
	bp=kkana_buf;
	/* Resetting the mora length */
	kkana_len=0;
	
	for(;len>0;)
	{
		if(*si==0x21 && *(si+1)==0x3C)
		{
			if(kkana_len)
			{
				*bp++=0xC0;
			}
			else
			{
				*bp++=0xFF;	/* The long vowel at the top cannot be read.*/
			}
			si+=2; 
			--len; 
			++kkana_len;
		}
		else
		{
			a[0]=(*(si+1));
			if(len>1)
			{ 
				a[1]=(*(si+3)); 
				n=2; 
			}
			else
			{ 
				a[1]=0x00; 
				n=1; 
			}
			for(;n;)
			{
				if(kana_conv(a[0],a[1], &ch))
				{ 
					goto kana_mora100; 
				}
				a[--n]=0x00;
			}
			return 0;
kana_mora100:	
			si += n*2;		// Advance to the next wide character
			len -= n;		// adjust the input length
			*bp++ = ch;		// put the internal character into kana_buf
			++kkana_len;	// adjust the output length
		}
	}
	/*check_X(&kkana_buf,kkana_len);*/
	return 1;
}


/*========== kana_conv(a1,a2, ch) ======================
	Function:  Convert a character of 2-byte kana notation into the internal phonetic code.
	Value:	1 Conversion succeeded	
			O Conversion failed.
  ======================================================*/
BOOL kana_conv(BYTE a1, BYTE a2, BYTE *ch) 
{
	const BYTE* addr;
	addr=(&kana_tbl[0]);
	for(;*addr;addr+=3)
	{
		if(a1==(*addr) && a2==(*(addr+1)))
		{ 
			*ch=(*(addr+2)); 
			return 1; 
		}
	}
	return 0;
}



/***************************** END OF ILE_KANA.C *****************************/

