/*
 ***********************************************************************
 *
 *                           Coryright (c)
 *     Digital Equipment Corporation 1996, 1997. All rights reserved.
 *
 *    Restricted Rights: Use, duplication, or disclosure by the U.S.
 *    Government is subject to restrictions as set forth in subparagraph
 *    (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *    52.227-14 Alt. III, as applicable.
 *
 *    This software is proprietary to and embodies the confidential
 *    technology of Digital Equipment Corporation and other parties.
 *    Possession, use, or copying of this software and media is authorized
 *    only pursuant to a valid written license from Digital or an
 *    authorized sublicensor.
 *
 ***********************************************************************
 *    File Name:    lsa_us.c
 *    Author:
 *    Creation Date:
 *
 *    Functionality:
 *    Trigram frequency tables for english (us).
 *
 ***********************************************************************
 *    Revision History:
  *
 *  Rev Who     Date        	Description
 *  --- -----   -------     	---------------------------------------
 *  001 MGS     02/13/1996 		Renamed file from en.c to lsa_us.c
 *	002	MGS		03/13/1996		Added include <windows.h> for WIN32		
 *  003	GL		04/21/1997	    BATS#357  Add the code for __osf__ build 
 *  004 GL      10/13/1997      For BATS#486 remove English_us only ACNA setting 
 *  005	MGS		02/26/2002		ACNA updates
 *  006	MGS		04/11/2002		ARM7 port
 *
 */

#include "port.h"
#include "dectalkf.h"
#ifndef NEW_ACNA
/* #ifdef ENGLISH_US */
#ifdef ACNA
//moved to port.h for each platform - mlt
//#ifdef WIN32
//#include <windows.h>
//#endif
const unsigned char far english[27][27][27] = {
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x02,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x01,
   0x06,0x01,0x02,0x00,0x01,0x00,0x04,0x01,0x02,0x01,0x01,0x00,0x01,
   0x01,0x00,0x00,0x13,0x00,0x00,0x00,0x0B,0x00,0x00,0x01,0x05,0x00,
   0x00,0x06,0x00,0x00,0x0F,0x00,0x00,0x14,0x00,0x00,0x0C,0x00,0x00,
   0x00,0x03,0x00,0x00,0x11,0x00,0x00,0x00,0x01,0x00,0x00,0x0A,0x01,
   0x00,0x00,0x04,0x00,0x00,0x21,0x00,0x00,0x12,0x00,0x00,0x07,0x00,
   0x01,0x00,0x00,0x00,0x00,0x09,0x00,0x00,0x00,0x0D,0x00,0x00,0x00,
   0x04,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x01,0x00,0x00,0x0D,
   0x00,0x01,0x00,0x01,0x00,0x00,0x06,0x01,0x01,0x04,0x00,0x00,0x01,
   0x00,0x01,0x00,0x01,0x04,0x03,0x02,0x00,0x01,0x00,0x01,0x01,0x01,
   0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x06,0x00,0x00,0x00,0x02,0x00,
   0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x09,0x00,0x00,0x07,0x00,
   0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x06,0x00,0x00,0x01,0x00,0x00,0x0A,0x00,0x00,0x0B,
   0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x1D,0x00,0x00,0x00,
   0x0C,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,
   0x00,0x00,0x00,0x09,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x02,0x00,0x00,
   0x00,0x01,0x01,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x02,0x00,
   0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x05,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x04,
   0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x0D,0x00,0x00,0x01,0x00,0x01,
   0x03,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,
   0x0D,0x00,0x00,0x00,0x09,0x00,0x00,0x00,0x08,0x00,0x00,0x01,0x00,
   0x00,0x0D,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,
   0x00,0x16,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x07,0x00,0x00,0x00,
   0x00,0x00,0x0D,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x01,
   0x00,0x00,0x02,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x02,0x00,0x00,
   0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,
   0x01,0x00,0x00,0x01,0x01,0x00,0x01,0x00,0x00,0x01,0x01,0x01,0x00,
   0x00,0x02,0x01,0x41,0x01,0x00,0x00,0x01,0x02,0x01,0x01,0x01,0x01,
   0x01,0x00,0x01,0x00,0x0A,0x00,0x00,0x00,0x0C,0x00,0x00,0x01,0x04,
   0x00,0x00,0x01,0x00,0x00,0x05,0x00,0x00,0x07,0x00,0x00,0x04,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x0B,0x00,0x00,
   0x01,0x07,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,
   0x05,0x00,0x00,0x00,0x01,0x00,0x00,0x07,0x00,0x04,0x00,0x08,0x00,
   0x00,0x0D,0x06,0x00,0x01,0x01,0x03,0x03,0x04,0x05,0x00,0x00,0x00,
   0x13,0x03,0x00,0x05,0x00,0x01,0x00,0x00,0x03,0x00,0x00,0x00,0x02,
   0x00,0x00,0x07,0x06,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x06,
   0x00,0x00,0x05,0x00,0x02,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x00,0x01,0x00,
   0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x11,0x00,
   0x00,0x00,0x06,0x00,0x00,0x0E,0x0E,0x00,0x00,0x00,0x00,0x00,0x0B,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x81,0x81,0x02,0x81,0x00,0x01,0x00,0x00,0x00,0x81,
   0x00,0x00,0x41,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x41,
   0x00,0x00,0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x81,0x00,
   0x00,0x00,0x00,0x41,0x00,0x03,0x01,0x01,0x00,0x03,0x41,0x01,0x01,
   0x81,0x01,0x00,0x81,0x01,0x01,0x81,0x01,0x00,0x00,0x81,0x01,0x00,
   0x00,0x00,0x01,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x41,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x41,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x41,0x41,0x00,0x41,
   0x43,0x00,0x01,0x00,0x41,0x00,0x00,0x01,0x00,0x81,0x01,0x00,0x00,
   0x00,0x81,0x00,0x41,0x00,0x81,0x00,0x41,0x00,0x00,0x01,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x41,0x00,0x00,0x00,0x00,
   0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x81,0x01,0x00,0x03,0x00,
   0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x41,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x81,0x01,0x00,0x01,0x01,0x00,
   0x00,0x41,0x00,0x00,0x81,0x01,0x00,0x41,0x00,0x81,0x00,0x00,0x00,
   0x01,0x01,0x81,0x81,0x03,0x45,0x81,0x01,0x00,0x01,0x00,0x01,0x12,
   0x01,0x81,0x01,0x41,0x00,0x81,0x01,0x01,0x01,0x81,0x81,0x00,0x41,
   0x00,0x11,0x01,0x02,0x00,0x00,0x02,0x81,0x00,0x00,0x01,0x81,0x81,
   0x01,0x01,0x00,0x01,0x04,0x00,0x00,0x03,0x00,0x81,0x00,0x81,0x00,
   0x00,0x00,0x29,0x01,0x00,0x02,0x0D,0x45,0x01,0x03,0x01,0x01,0x00,
   0x03,0x01,0x00,0x03,0x01,0x00,0x00,0x00,0x08,0x04,0x01,0x00,0x01,
   0x00,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x81,0x01,
   0x01,0x00,0x00,0x01,0x81,0x00,0x01,0x01,0x00,0x81,0x01,0x81,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x01,0x02,0x01,0x0B,0x02,0x01,
   0x81,0x81,0x02,0x01,0x08,0x05,0x81,0x08,0x01,0x01,0x81,0x08,0x05,
   0x08,0x81,0x81,0x81,0x00,0x01,0x81,0x03,0x01,0x00,0x81,0x00,0x03,
   0x00,0x01,0x03,0x01,0x81,0x01,0x01,0x01,0x81,0x02,0x01,0x00,0x00,
   0x05,0x06,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x81,0x00,0x03,0x00,
   0x04,0x01,0x00,0x07,0x01,0x00,0x01,0x01,0x01,0x00,0x42,0x00,0x00,
   0x00,0x01,0x08,0x41,0x00,0x01,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x81,0x81,0x00,0x01,0x00,0x00,0x81,0x00,0x81,0x00,0x01,0x00,0x00,
   0x00,0x81,0x01,0x81,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x81,0x00,0x81,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x01,0x43,
   0x01,0x00,0x81,0x01,0x00,0x00,0x00,0x81,0x00,0x81,0x01,0x00,0x01,
   0x81,0x00,0x00,0x01,0x01,0x81,0x00,0x00,0x00,0x00,0x81,0x00,0x01,
   0x00,0x00,0x81,0x00,0x01,0x81,0x00,0x00,0x01,0x00,0x00,0x81,0x81,
   0x00,0x41,0x00,0x00,0x00,0x81,0x01,0x00,0x00,0x81,0x00,0x00,0x00,
   0x0F,0x81,0x01,0x00,0x01,0x03,0x81,0x81,0x00,0x00,0x00,0x00,0x04,
   0x81,0x03,0x41,0x00,0x00,0x01,0x02,0x01,0x00,0x00,0x81,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,
   0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x81,0x01,0x81,0x01,0x41,0x00,0x81,0x00,0x81,
   0x00,0x01,0x01,0x00,0x03,0x00,0x00,0x00,0x07,0x01,0x01,0x00,0x00,
   0x00,0x81,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x02,0x00,0x00,0x01,0x00,0x00,0x81,0x00,0x00,0x00,0x41,0x41,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x02,0x81,0x00,0x01,0x01,0x01,
   0x00,0x81,0x00,0x00,0x00,0x81,0x02,0x81,0x83,0x00,0x00,0x00,0x09,
   0x01,0x01,0x00,0x81,0x81,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x81,0x81,0x81,0x41,0x00,0x81,0x00,0x00,0x00,0x00,0x01,0x00,0x03,
   0x00,0x00,0x00,0x81,0x01,0x02,0x00,0x81,0x00,0x81,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x84,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x41,0x00,0x81,0x01,
   0x00,0x00,0x41,0x01,0x00,0x01,0x01,0x41,0x00,0x02,0x81,0x01,0x01,
   0x81,0x83,0x41,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x87,0x00,0x00,0x00,0x03,
   0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,
   0x00,0x00,0x81,0x00,0x00,0x00,0x81,0x00,0x02,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,
   0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x81,0x01,0x00,0x81,0x81,0x00,0x00,0x00,0x00,0x81,0x00,0x81,0x00,
   0x00,0x00,0x0B,0x01,0x01,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x0B,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x81,0x00,0x00,
   0x01,0x00,0x01,0x00,0x00,0x00,0x01,0x01,0x81,0x00,0x00,0x81,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x01,0x00,0x00,0x01,0x81,
   0x01,0x00,0x00,0x01,0x01,0x03,0x00,0x01,0x00,0x85,0x03,0x01,0x81,
   0x01,0x81,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x01,0x00,0x41,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,
   0x00,0x01,0x00,0x05,0x01,0x00,0x01,0x04,0x00,0x00,0x01,0x01,0x00,
   0x02,0x01,0x00,0x03,0x01,0x01,0x01,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x00,0x00,0x81,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x0C,0x01,0x01,0x01,0x01,0x04,0x01,0x00,0x01,0x01,0x00,0x81,
   0x02,0x00,0x00,0x41,0x00,0x00,0x01,0x04,0x01,0x41,0x00,0x01,0x00,
   0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,
   0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x41,0x81,0x81,
   0x01,0x00,0x00,0x01,0x05,0x04,0x06,0x02,0x01,0x00,0x83,0x81,0x03,
   0x81,0x81,0x81,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
   0x82,0x00,0x00,0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x88,0x00,0x00,
   0x00,0x00,0x00,0x82,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x01,0x81,
   0x00,0x01,0x00,0x82,0x81,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x41,0x00,0x00,0x81,
   0x81,0x81,0x00,0x01,0x04,0x01,0x02,0x00,0x00,0x00,0x01,0x81,0x01,
   0x81,0x81,0x01,0x00,0x42,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
   0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x01,0x00,0x00,
   0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x42,0x00,0x05,0x01,0x81,0x81,
   0x01,0x01,0x00,0x00,0x41,0x81,0x81,0x81,0x06,0x01,0x07,0x81,0x01,
   0x00,0x0A,0x01,0x01,0x00,0x81,0x01,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x02,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x0F,0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x00,0x00,
   0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x81,0x01,0x02,0x81,0x41,0x00,0x81,0x00,0x00,0x00,0x00,0x01,
   0x00,0x06,0x00,0x00,0x00,0x41,0x02,0x41,0x00,0x00,0x01,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x41,0x00,0x00,0x42,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x02,0x01,0x00,0x00,
   0x00,0x01,0x00,0x00,0x01,0x02,0x01,0x44,0x01,0x00,0x00,0x01,0x00,
   0x01,0x00,0x41,0x82,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x81,0x00,0x08,0x01,0x01,
   0x01,0x00,0x41,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x01,0x00,0x44,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x81,0x01,0x81,0x81,0x01,0x81,0x81,0x81,0x00,0x00,0x41,0x41,0x01,
   0x84,0x00,0x81,0x00,0x82,0x81,0x81,0x00,0x81,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x09,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x01,0x04,0x00,0x01,
   0x81,0x01,0x81,0x00,0x02,0x02,0x01,0x01,0x00,0x01,0x00,0x08,0x06,
   0x09,0x00,0x04,0x01,0x00,0x01,0x81,0x00,0x01,0x01,0x00,0x00,0x01,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x01,0x01,0x00,0x00,0x00,
   0x41,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x01,0x81,0x00,
   0x02,0x01,0x81,0x04,0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x01,0x00,
   0x00,0x01,0x01,0x00,0x41,0x00,0x01,0x00,0x41,0x00,0x02,0x00,0x01,
   0x01,0x04,0x00,0x81,0x81,0x01,0x00,0x00,0x41,0x03,0x01,0x04,0x00,
   0x01,0x00,0x81,0x02,0x41,0x00,0x41,0x00,0x00,0x01,0x01,0x00,0x00,
   0x00,0x00,0x00,0x41,0x01,0x00,0x00,0x01,0x00,0x00,0x81,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x41,0x00,0x00,0x01,0x00,
   0x00,0x01,0x00,0x00,0x81,0x01,0x00,0x00,0x00,0x00,0x00,0x81,0x00,
   0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x41,
   0x81,0x00,0x01,0x00,0x00,0x01,0x41,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x81,0x81,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x07,0x01,0x01,0x01,0x4E,0x03,0x81,0x00,0x00,
   0x01,0x00,0x81,0x2B,0x01,0x81,0x01,0x01,0x00,0x01,0x05,0x02,0x00,
   0x81,0x01,0x00,0x43,0x81,0x00,0x03,0x01,0x00,0x00,0x02,0x00,0x00,
   0x00,0x01,0x00,0x00,0x81,0x01,0x00,0x01,0x81,0x00,0x00,0x01,0x01,
   0x01,0x00,0x01,0x00,0x00,0x00,0x19,0x01,0x01,0x03,0x05,0x03,0x01,
   0x01,0x01,0x01,0x81,0x01,0x01,0x01,0x06,0x01,0x01,0x41,0x01,0x09,
   0x03,0x00,0x00,0x01,0x00,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x41,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
   0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x81,0x00,0x00,0x01,0x01,0x00,
   0x00,0x01,0x41,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2D,0x01,0x02,
   0x01,0x01,0x01,0x01,0x01,0x01,0x05,0x00,0x01,0x07,0x01,0x02,0x01,
   0x81,0x00,0x06,0x18,0x06,0x41,0x01,0x01,0x00,0x41,0x00,0x16,0x41,
   0x01,0x01,0x00,0x41,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x01,0x00,
   0x42,0x00,0x00,0x00,0x04,0x05,0x00,0x00,0x01,0x00,0x01,0x00,0x01,
   0x41,0x00,0x81,0x00,0x01,0x00,0x00,0x03,0x01,0x00,0x00,0x81,0x01,
   0x00,0x42,0x00,0x00,0x81,0x01,0x17,0x81,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x81,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x81,0x81,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x81,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x02,0x00,0x81,
   0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x41,0x00,0x01,0x02,0x81,0x00,0x01,0x02,0x81,0x00,0x01,0x01,0x00,
   0x00,0x81,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x81,0x00,
   0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x01,0x00,0x00,0x41,0x00,0x00,0x81,0x00,0x81,0x00,0x00,
   0x00,0x81,0x41,0x00,0x3F,0x01,0x00,0x01,0x81,0x02,0x81,0x00,0x00,
   0x00,0x00,0x00,0x00,0x81,0x00,0x41,0x00,0x00,0x01,0x01,0x00,0x00,
   0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x81,0x00,0x81,0x00,0x00,0x01,0x00,0x81,0x00,0x00,0x00,0x82,
   0x01,0x41,0x81,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x81,
   0x00,0x00,0x00,0x81,0x00,0x00,0x01,0x00,0x00,0x81,0x01,0x00,0x81,
   0x00,0x00,0x00,0x02,0x41,0x01,0x00,0x00,0x81,0x00,0x41,0x00,0x01,
   0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x01,
   0x00,0x01,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x0C,0x01,0x01,0x00,0x00,0x00,
   0x41,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x81,0x41,0x00,0x41,0x00,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x81,
   0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x02,0x00,0x41,0x41,0x00,0x00,
   0x0C,0x00,0x41,0x00,0x00,0x81,0x01,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,
   0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x01,
   0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x41,0x00,0x00,0x41,
   0x00,0x00,0x41,0x00,0x00,0x00,0x01,0x00,0x41,0x00,0x01,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x81,0x00,0x81,0x00,0x00,0x00,0x01,0x41,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x81,
   0x00,0x00,0x01,0x41,0x00,0x41,0x00,0x01,0x01,0x47,0x00,0x00,0x00,
   0x02,0x02,0x01,0x00,0x81,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x41,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x0C,
   0x81,0x00,0x01,0x41,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x01,
   0x02,0x01,0x00,0x00,0x03,0x01,0x41,0x00,0x00,0x01,0x00,0x41,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x02,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x02,0x00,0x00,
   0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x43,0x00,0x00,0x00,0x00,0x00,
   0x41,0x00,0x01,0x43,0x41,0x00,0x00,0x41,0x01,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x01,0x01,0x00,0x00,0x01,0x41,0x02,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x01,0x41,0x00,0x81,0x81,0x00,
   0x00,0x00,0x04,0x41,0x02,0x00,0x81,0x00,0x00,0x41,0x01,0x00,0x81,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x05,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x41,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,
   0x00,0x41,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,
   0x81,0x00,0x81,0x81,0x41,0x00,0x00,0x00,0x81,0x00,0x41,0x06,0x00,
   0x00,0x01,0x01,0x41,0x01,0x41,0x81,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x04,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x82,0x00,0x00,0x00,0x00,
   0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x07,0x00,0x01,0x00,0x01,0x41,0x01,0x00,0x01,0x00,0x00,0x00,0x01,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x49,0x00,0x00,0x41,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x41,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x01,
   0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x81,
   0x81,0x01,0x01,0x81,0x00,0x01,0x00,0x01,0x06,0x0F,0x07,0x00,0x81,
   0x00,0x0B,0x02,0x82,0x00,0x81,0x03,0x81,0x02,0x81,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x06,0x00,0x00,0x01,0x81,0x81,0x81,0x00,0x00,0x00,0x00,0x04,
   0x81,0x04,0x00,0x81,0x00,0x0E,0x02,0x02,0x00,0x81,0x02,0x00,0x02,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x81,0x81,0x81,0x01,0x81,0x81,0x00,
   0x00,0x00,0x41,0x06,0x41,0x04,0x00,0x01,0x00,0x01,0x01,0x89,0x00,
   0x81,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x01,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x41,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x41,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x81,
   0x81,0x02,0x01,0x01,0x01,0x00,0x81,0x00,0x01,0x09,0x03,0x01,0x01,
   0x01,0x00,0x07,0x81,0x01,0x03,0x01,0x02,0x81,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x04,0x00,0x00,0x01,
   0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x41,0x00,0x00,0x00,0x41,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x41,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x81,0x81,0x81,0x41,0x00,0x81,0x00,0x81,
   0x00,0x00,0x01,0x01,0x81,0x00,0x00,0x00,0x01,0x01,0x81,0x00,0x00,
   0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x01,0x81,0x00,0x01,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x81,
   0x81,0x41,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x01,0x01,0x02,0x00,
   0x00,0x00,0x41,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x02,0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x81,0x02,0x81,0x00,
   0x41,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x01,
   0x01,0x00,0x00,0x00,0x41,0x00,0x00,0x04,0x00,0x00,0x0B,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x41,0x00,0x81,0x04,0x03,0x00,0x07,0x01,0x01,0x00,0x00,0x81,
   0x01,0x81,0x41,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x81,0x00,0x41,
   0x00,0x0A,0x00,0x01,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,
   0x4E,0x00,0x01,0x00,0x00,0x00,0x02,0x01,0x81,0x00,0x00,0x00,0x00,
   0x41,0x00,0x01,0x00,0x00,0x00,0x00,0x41,0x01,0x00,0x81,0x01,0x00,
   0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x41,0x41,0x81,0x00,0x41,0x00,0x05,0x03,0x01,
   0x00,0x00,0x01,0x81,0x41,0x81,0x00,0x00,0x81,0x01,0x81,0x00,0x00,
   0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x01,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
   0x81,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x81,0x03,
   0x45,0x81,0x81,0x00,0x01,0x00,0x02,0x15,0x01,0x00,0x41,0x00,0x00,
   0x00,0x02,0x01,0x00,0x81,0x00,0x00,0x41,0x81,0x01,0x41,0x81,0x81,
   0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x81,0x01,0x01,0x00,0x01,0x81,
   0x00,0x00,0x01,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x01,0x01,
   0x81,0x02,0x05,0x81,0x30,0x81,0x01,0x00,0x02,0x01,0x00,0x01,0x01,
   0x00,0x00,0x81,0x13,0x01,0x81,0x81,0x01,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x41,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x81,0x01,0x00,
   0x81,0x00,0x01,0x00,0x00,0x01,0x81,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x01,0x00,0x01,
   0x00,0x81,0x00,0x01,0x00,0x00,0x01,0x41,0x00,0x00,0x01,0x01,0x00,
   0x00,0x00,0x06,0x01,0x01,0x01,0x81,0x01,0x01,0x00,0x03,0x81,0x00,
   0x01,0x01,0x01,0x00,0x49,0x01,0x00,0x00,0x02,0x04,0x00,0x00,0x01,
   0x00,0x00,0x00,0x01,0x01,0x41,0x02,0x00,0x04,0x01,0x00,0x04,0x01,
   0x00,0x01,0x01,0x01,0x01,0x41,0x01,0x00,0x00,0x02,0x0D,0x41,0x00,
   0x01,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x04,0x00,0x00,
   0x00,0x81,0x00,0x00,0x81,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x41,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x41,0x41,0x00,0x00,0x81,
   0x00,0x00,0x81,0x41,0x00,0x00,0x00,0x81,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x01,0x81,
   0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x81,0x81,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x81,0x00,0x00,0x00,0x00,0x81,0x00,0x41,0x00,0x00,
   0x00,0x81,0x00,0x01,0x00,0x00,0x00,0x81,0x00,0x41,0x00,0x00,0x81,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x81,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x41,0x01,0x00,0x00,0x41,0x00,0x00,0x02,0x81,0x00,0x00,0x81,0x00,
   0x01,0x81,0x81,0x00,0x01,0x81,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x01,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x81,0x00,0x41,0x00,0x00,0x00,0x02,
   0x41,0x00,0x81,0x00,0x02,0x01,0x41,0x00,0x00,0x81,0x00,0x01,0x81,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x05,0x02,0x00,0x00,0x81,0x03,0x01,0x81,0x01,0x81,
   0x00,0x00,0x04,0x81,0x04,0x00,0x81,0x00,0x0B,0x03,0x02,0x00,0x81,
   0x01,0x00,0x43,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x01,0x01,
   0x81,0x81,0x00,0x00,0x00,0x81,0x84,0x01,0x10,0x00,0x81,0x00,0x01,
   0x01,0x01,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,
   0x00,0x00,0x45,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x41,0x01,
   0x01,0x01,0x00,0x00,0x00,0x81,0x41,0x00,0x81,0x81,0x81,0x41,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x81,0x00,
   0x00,0x00,0x00,0x00,0x09,0x01,0x00,0x01,0x01,0x01,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x41,0x01,0x00,0x00,0x00,0x41,0x01,
   0x01,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x81,0x02,0x01,0x00,0x81,0x01,0x41,0x01,0x00,0x02,0x01,
   0x01,0x0D,0x00,0x01,0x00,0x03,0x01,0x01,0x81,0x01,0x02,0x81,0x01,
   0x81,0x01,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x41,
   0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,
   0x41,0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x0D,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,
   0x00,0x00,0x00,0x01,0x00,0x41,0x00,0x00,0x03,0x02,0x00,0x41,0x00,
   0x01,0x00,0x41,0x00,0x13,0x84,0x01,0x01,0x03,0x02,0x01,0x01,0x01,
   0x81,0x01,0x00,0x00,0x04,0x03,0x41,0x41,0x00,0x08,0x08,0x07,0x00,
   0x01,0x01,0x01,0x6B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x81,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,
   0x42,0x01,0x01,0x01,0x00,0x00,0x00,0x81,0x00,0x13,0x01,0x01,0x00,
   0x01,0x04,0x81,0x00,0x02,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x02,
   0x81,0x01,0x01,0x0A,0x00,0x01,0x00,0x0E,0x00,0x01,0x41,0x02,0x00,
   0x04,0x41,0x00,0x81,0x04,0x01,0x00,0x00,0x01,0x00,0x05,0x00,0x01,
   0x44,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x81,0x03,0x01,0x41,0x01,0x01,0x01,0x00,0x00,0x81,
   0x00,0x01,0x04,0x01,0x41,0x00,0x03,0x81,0x01,0x01,0x01,0x05,0x00,
   0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x04,0x41,0x81,0x00,0x00,0x41,0x00,0x00,
   0x01,0x00,0x00,0x00,0x81,0x00,0x00,0x48,0x01,0x00,0x00,0x01,0x01,
   0x41,0x00,0x01,0x00,0x00,0x00,0x01,0x41,0x00,0x00,0x00,0x41,0x00,
   0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x46,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x81,0x01,0x81,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x41,0x81,0x01,0x00,0x01,0x00,0x00,
   0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x11,0x01,
   0x01,0x01,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x81,0x41,0x01,0x01,
   0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x81,0x01,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x01,0x81,0x00,0x00,0x81,0x81,0x81,0x81,0x00,
   0x02,0x00,0x57,0x00,0x81,0x00,0x07,0x02,0x83,0x81,0x00,0x01,0x81,
   0x02,0x41,0x01,0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x41,0x00,
   0x00,0x01,0x00,0x00,0x81,0x00,0x00,0x01,0x41,0x00,0x00,0x00,0x00,
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x02,0x01,0x00,0x00,0x81,0x81,0x00,0x81,
   0x00,0x81,0x00,0x00,0x03,0x00,0x02,0x00,0x00,0x00,0x04,0x02,0x01,
   0x00,0x00,0x00,0x81,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x81,0x01,0x00,0x01,0x00,0x00,0x00,0x81,0x03,0x00,0x05,0x41,0x00,
   0x00,0x41,0x01,0x04,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x81,0x01,0x01,0x01,0x00,0x41,0x01,0x81,0x41,
   0x00,0x01,0x00,0x06,0x02,0x00,0x00,0x05,0x01,0x01,0x01,0x00,0x00,
   0x81,0x01,0x00,0x03,0x41,0x01,0x00,0x00,0x01,0x01,0x00,0x01,0x01,
   0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x41,0x00,0x00,0x01,0x41,0x01,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x41,0x00,0x00,0x00,0x01,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x81,
   0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x81,0x81,0x01,0x00,0x00,0x00,
   0x01,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x81,0x41,0x01,0x00,0x00,0x01,0x00,0x81,0x41,
   0x00,0x01,0x01,0x43,0x00,0x01,0x00,0x41,0x01,0x00,0x01,0x41,0x01,
   0x41,0x01,0x00,0x00,0x41,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x41,0x00,0x01,0x01,0x00,0x00,0x00,0x43,0x00,0x00,0x01,
   0x00,0x00,0x01,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x41,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x09,0x01,0x41,0x00,0x00,0x04,0x01,0x01,
   0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x01,0x00,0x00,0x01,0x05,0x41,
   0x00,0x00,0x00,0x00,0x00,0x01,0x11,0x01,0x01,0x01,0x01,0x01,0x01,
   0x01,0x01,0x81,0x00,0x41,0x05,0x00,0x41,0x00,0x00,0x00,0x06,0x07,
   0x03,0x00,0x01,0x02,0x41,0x46,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x01,0x01,0x01,0x01,
   0x41,0x01,0x00,0x02,0x01,0x00,0x00,0x02,0x01,0x00,0x01,0x00,0x00,
   0x01,0x07,0x09,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x03,0x01,0x01,0x01,0x01,0x81,0x00,0x00,0x81,0x01,0x01,0x05,0x41,
   0x00,0x00,0x00,0x02,0x01,0x00,0x01,0x41,0x41,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x05,0x00,
   0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x41,0x00,0x01,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x81,0x01,0x81,0x00,0x00,0x41,
   0x00,0x41,0x01,0x00,0x42,0x01,0x00,0x00,0x05,0x81,0x01,0x01,0x01,
   0x81,0x01,0x81,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x1A,0x00,0x41,0x00,0x00,0x03,
   0x01,0x00,0x01,0x01,0x00,0x01,0x02,0x01,0x00,0x4B,0x00,0x00,0x00,
   0x01,0x01,0x00,0x01,0x01,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0x00,
   0x01,0x00,0x00,0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x43,0x00,0x00,
   0x01,0x01,0x41,0x00,0x00,0x01,0x00,0x01,0x41,0x00,0x81,0x00,0x01,
   0x00,0x41,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x41,0x81,0x00,0x41,
   0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x81,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x01,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x41,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x81,0x41,0x00,0x00,0x00,0x01,0x41,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x81,0x01,0x00,0x01,0x02,0x00,0x00,0x00,
   0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,
   0x00,0x00,0x00,0x01,0x00,0x00,0x81,0x00,0x00,0x00,0x01,0x00,0x00,
   0x01,0x00,0x00,0x0B,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x81,
   0x41,0x00,0x00,0x00,0x00,0x00,0x0B,0x01,0x01,0x01,0x01,0x02,0x01,
   0x02,0x01,0x01,0x00,0x81,0x01,0x01,0x01,0x01,0x00,0x00,0x01,0x01,
   0x00,0x41,0x01,0x01,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x41,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x01,0x01,0x81,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,
   0x00,0x41,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x81,0x00,
   0x00,0x01,0x00,0x02,0x00,0x00,0x00,0x00,0x01,0x00,0x81,0x81,0x00,
   0x00,0x01,0x01,0x41,0x41,0x81,0x00,0x00,0x00,0x00,0x01,0x01,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x81,0x00,0x00,0x41,0x00,0x03,0x81,
   0x00,0x00,0x01,0x41,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x81,
   0x00,0x00,0x00,0x00,0x81,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x03,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x01,0x01,0x00,0x41,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x41,0x00,
   0x00,0x01,0x01,0x01,0x01,0x03,0x04,0x01,0x81,0x00,0x01,0x00,0x01,
   0x0D,0x02,0x00,0x01,0x01,0x00,0x01,0x03,0x81,0x00,0x01,0x81,0x00,
   0x01,0x00,0x04,0x01,0x03,0x00,0x41,0x02,0x01,0x00,0x00,0x01,0x00,
   0x81,0x01,0x81,0x00,0x41,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x3F,0x01,0x00,0x00,0x03,0x06,0x00,0x05,0x00,0x41,
   0x00,0x01,0x01,0x00,0x02,0x01,0x00,0x00,0x81,0x04,0x01,0x00,0x81,
   0x81,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x15,0x00,0x00,0x81,0x01,
   0x00,0x00,0x06,0x82,0x01,0x02,0x00,0x01,0x00,0x02,0x01,0x01,0x00,
   0x81,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x01,0x41,0x00,0x81,0x81,0x00,0x00,0x00,0x01,0x00,0x00,0x81,0x00,
   0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x01,0x02,0x01,0x0A,0x06,
   0x81,0x01,0x01,0x01,0x81,0x01,0x01,0x01,0x07,0x81,0x01,0x00,0x02,
   0x04,0x0B,0x00,0x81,0x81,0x00,0x41,0x00,0x01,0x00,0x01,0x81,0x00,
   0x03,0x00,0x81,0x81,0x01,0x00,0x81,0x81,0x00,0x00,0x00,0x00,0x00,
   0x00,0x03,0x02,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x41,0x00,0x00,0x01,0x00,0x00,0x00,0x81,0x00,0x00,0x41,0x00,
   0x00,0x00,0x01,0x09,0x00,0x00,0x01,0x41,0x41,0x00,0x00,0x41,0x00,
   0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x81,0x81,0x01,0x00,
   0x01,0x00,0x01,0x02,0x01,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x01,0x01,0x00,0x02,0x08,0x00,0x01,0x00,0x81,0x00,0x81,0x05,0x01,
   0x04,0x01,0x00,0x00,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
   0x02,0x81,0x01,0x00,0x00,0x01,0x00,0x81,0x00,0x41,0x00,0x00,0x81,
   0x00,0x00,0x41,0x81,0x00,0x00,0x01,0x81,0x00,0x00,0x81,0x00,0x00,
   0x00,0x01,0x41,0x00,0x41,0x02,0x41,0x00,0x00,0x81,0x81,0x00,0x00,
   0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x81,0x41,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x81,0x00,0x00,0x41,0x00,
   0x41,0x00,0x00,0x41,0x81,0x01,0x41,0x01,0x00,0x04,0x01,0x02,0x01,
   0x81,0x81,0x81,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x84,0x00,0x00,0x81,
   0x01,0x81,0x01,0x00,0x00,0x00,0x00,0x02,0x01,0x03,0x00,0x01,0x00,
   0x05,0x41,0x82,0x00,0x00,0x01,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
   0x81,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,
   0x00,0x00,0x01,0x81,0x01,0x00,0x81,0x41,0x00,0x00,0x41,0x01,0x00,
   0x01,0x00,0x81,0x00,0x41,0x01,0x01,0x00,0x81,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,
   0x00,0x41,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x41,0x81,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x81,0x01,0x01,0x01,0x00,0x01,0x81,0x01,
   0x81,0x81,0x81,0x00,0x81,0x00,0x01,0x41,0x00,0x00,0x00,0x02,0x00,
   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x02,0x00,0x00,0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,
   0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x81,0x00,0x00,0x01,0x00,0x00,0x81,0x00,0x81,0x81,0x81,
   0x00,0x00,0x00,0x83,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x81,0x00,0x00,0x00,0x81,0x00,0x00,0x01,0x81,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x02,0x00,0x41,
   0x01,0x01,0x01,0x41,0x01,0x02,0x05,0x07,0x00,0x01,0x00,0x01,0x02,
   0x02,0x00,0x81,0x01,0x00,0x03,0x81,0x01,0x01,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x01,0x00,0x00,0x41,0x00,0x00,0x01,0x00,0x00,0x01,
   0x00,0x00,0x01,0x00,0x00,0x00,0x43,0x00,0x00,0x01,0x00,0x00,0x00,
   0x01,0x00,0x00,0x01,0x81,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x01,0x00,0x01,
   0x00,0x01,0x00,0x01,0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,0x00,
   0x00,0x01,0x02,0x41,0x41,0x00,0x01,0x00,0x41,0x00,0x05,0x06,0x81,
   0x01,0x05,0x09,0x01,0x01,0x01,0x01,0x00,0x81,0x04,0x81,0x07,0x00,
   0x00,0x00,0x01,0x04,0x03,0x00,0x81,0x01,0x01,0x43,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x00,0x41,0x00,
   0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x41,0x01,0x07,0x09,0x02,0x01,0x04,0x81,0x00,0x00,0x01,
   0x02,0x01,0x09,0x01,0x81,0x00,0x00,0x09,0x03,0x00,0x81,0x00,0x01,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x02,0x01,0x01,0x00,0x00,0x04,0x00,0x00,0x01,0x02,
   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x01,0x00,
   0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x41,0x04,0x00,0x00,0x00,
   0x02,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x01,0x01,0x00,
   0x00,0x00,0x00,0x44,0x00,0x00,0x02,0x41,0x00,0x00,0x01,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x81,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x01,0x00,0x01,0x00,0x0B,0x00,
   0x00,0x01,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x02,
   0x01,0x01,0x00,0x01,0x00,0x41,0x00,0x00,0x02,0x81,0x02,0x03,0x01,
   0x01,0x01,0x81,0x00,0x41,0x01,0x02,0x01,0x03,0x04,0x01,0x00,0x00,
   0x04,0x01,0x02,0x01,0x05,0x01,0x01,0x81,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x01,0x01,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x03,0x02,0x00,
   0x00,0x00,0x04,0x00,0x81,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x43,0x00,0x0D,0x01,
   0x01,0x00,0x00,0x03,0x01,0x00,0x01,0x00,0x00,0x01,0x01,0x01,0x00,
   0x4C,0x01,0x00,0x00,0x01,0x01,0x00,0x00,0x01,0x00,0x01,0x00,0x04,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x09,0x03,0x01,0x00,0x01,0x00,
   0x01,0x44,0x00,0x00,0x01,0x01,0x41,0x01,0x00,0x01,0x00,0x41,0x00,
   0x00,0x81,0x81,0x41,0x01,0x81,0x41,0x01,0x41,0x81,0x00,0x00,0x41,
   0x03,0x01,0x00,0x01,0x00,0x00,0x02,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x06,0x01,0x00,0x00,0x81,0x01,0x01,0x00,0x00,
   0x00,0x00,0x00,0x81,0x00,0x81,0x41,0x00,0x00,0x00,0x01,0x81,0x00,
   0x00,0x01,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x41,0x01,0x00,
   0x81,0x41,0x00,0x41,0x00,0x00,0x01,0x01,0x81,0x00,0x41,0x00,0x81,
   0x00,0x81,0x81,0x01,0x01,0x81,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x42,0x00,0x00,0x81,0x00,0x00,
   0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,
   0x00,0x81,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x82,
   0x01,0x81,0x01,0x01,0x01,0x81,0x81,0x81,0x00,0x00,0x06,0x00,0x08,
   0x00,0x01,0x00,0x03,0x00,0x02,0x00,0x81,0x01,0x81,0x48,0x00,0x00,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x02,0x06,0x01,0x81,0x00,0x06,0x01,0x00,0x00,0x03,0x00,0x00,
   0x01,0x02,0x01,0x04,0x00,0x00,0x81,0x00,0x01,0x81,0x00,0x01,0x00,
   0x01,0x00,0x00,0x41,0x81,0x00,0x02,0x01,0x00,0x81,0x00,0x00,0x00,
   0x00,0x81,0x81,0x01,0x41,0x01,0x00,0x00,0x01,0x01,0x00,0x81,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x01,0x00,0x00,0x00,0x4A,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x02,0x00,0x00,0x00,0x81,0x00,
   0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x81,0x00,0x00,0x81,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x01,0x00,0x00,
   0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x02,0x7F,0x41,0x01,0x00,
   0x01,0x00,0x00,0x01,0x01,0x81,0x00,0x00,0x00,0x01,0x81,0x00,0x00,
   0x00,0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x81,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,
   0x01,0x00,0x01,0x00,0x05,0x00,0x00,0x81,0x01,0x00,0x00,0x01,0x01,
   0x00,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x41,0x00,
   0x06,0x08,0x01,0x00,0x00,0x05,0x01,0x00,0x01,0x03,0x81,0x00,0x01,
   0x01,0x01,0x0F,0x00,0x00,0x02,0x00,0x00,0x81,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x81,0x00,0x81,0x00,0x00,
   0x81,0x81,0x81,0x00,0x41,0x00,0x81,0x81,0x81,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x82,0x00,0x00,0x00,0x03,0x00,0x00,0x01,0x01,
   0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x81,0x81,0x00,0x00,0x00,0x00,0x81,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x41,0x41,
   0x00,0x81,0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x02,0x00,0x81,0x00,
   0x02,0x00,0x01,0x81,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x06,0x81,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,
   0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,0x00,0x41,0x00,0x01,0x01,
   0x02,0x00,0x01,0x00,0x0A,0x01,0x81,0x00,0x81,0x01,0x41,0x41,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x0E,0x04,0x01,0x01,0x00,0x0A,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x02,
   0x00,0x41,0x00,0x00,0x01,0x81,0x41,0x01,0x41,0x00,0x01,0x00,0x00,
   0x00,0x00,0x81,0x81,0x06,0x00,0x81,0x00,0x00,0x03,0x02,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x09,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x81,
   0x01,0x00,0x01,0x81,0x00,0x00,0x00,0x81,0x01,0x01,0x70,0x01,0x01,
   0x00,0x01,0x00,0x81,0x81,0x81,0x01,0x41,0x41,0x00,0x00,0x41,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x02,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x41,0x00,
   0x04,0x41,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00,0x00,0x01,
   0x01,0x00,0x43,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x41,
   0x00,0x23,0x01,0x00,0x00,0x00,0x07,0x00,0x00,0x01,0x02,0x00,0x00,
   0x04,0x00,0x00,0x43,0x01,0x00,0x01,0x01,0x00,0x41,0x00,0x81,0x00,
   0x41,0x00,0x00,0x81,0x81,0x00,0x81,0x81,0x81,0x81,0x00,0x00,0x00,
   0x00,0x01,0x01,0x01,0x81,0x00,0x00,0x82,0x01,0x01,0x00,0x00,0x00,
   0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x41,0x41,0x00,0x01,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x41,0x81,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x81,0x01,
   0x00,0x00,0x01,0x00,0x00,0x00,0x81,0x00,0x00,0x81,0x00,0x00,0x01,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x41,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x81,0x00,0x00,0x01,0x01,0x00,0x01,0x00,0x81,0x00,0x81,0x01,0x81,
   0x81,0x01,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x01,0x00,0x41,0x00,
   0x01,0x00,0x81,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x81,0x00,0x00,0x00,0x01,0x81,0x41,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x81,0x00,0x01,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x81,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x81,0x01,0x00,0x00,0x00,0x81,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x01,
   0x01,0x81,0x81,0x01,0x00,0x01,0x03,0x00,0x00,0x00,0x81,0x00,0x01,
   0x01,0x01,0x00,0x81,0x00,0x00,0x00,0x00,0x02,0x01,0x01,0x00,0x00,
   0x01,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x01,0x00,0x00,0x01,0x00,
   0x00,0x81,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x01,0x01,0x01,
   0x01,0x41,0x00,0x01,0x81,0x01,0x00,0x01,0x81,0x00,0x83,0x00,0x81,
   0x00,0x00,0x01,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x41,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x41,0x00,0x00,0x81,0x00,0x41,
   0x00,0x01,0x00,0x00,0x81,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x01,0x01,0x01,0x81,0x01,0x81,0x81,0x01,0x01,0x00,0x02,0x02,
   0x00,0x05,0x41,0x01,0x00,0x05,0x02,0x01,0x00,0x81,0x81,0x00,0x41,
   0x00,0x02,0x81,0x01,0x01,0x00,0x43,0x00,0x81,0x02,0x01,0x00,0x41,
   0x01,0x00,0x00,0x41,0x00,0x00,0x00,0x03,0x02,0x00,0x00,0x81,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x03,0x41,0x00,
   0x81,0x81,0x00,0x81,0x41,0x00,0x00,0x00,0x01,0x04,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x41,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x81,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x41,0x01,0x00,0x02,0x00,
   0x00,0x00,0x01,0x00,0x01,0x81,0x00,0x81,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x02,0x81,0x00,0x00,0x41,0x00,0x00,0x81,0x00,0x00,0x01,0x00,
   0x02,0x01,0x04,0x00,0x00,0x00,0x0A,0x01,0x41,0x00,0x00,0x00,0x00,
   0x43,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x06,0x00,0x00,0x00,0x00,0x01,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x01,0x41,0x00,0x00,0x81,0x00,0x41,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x81,0x00,0x81,0x01,0x41,0x02,0x00,0x01,0x06,0x81,0x01,
   0x00,0x00,0x00,0x07,0x81,0x02,0x00,0x00,0x00,0x81,0x49,0x00,0x00,
   0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,
   0x41,0x00,0x00,0x41,0x00,0x00,0x41,0x01,0x00,0x00,0x00,0x00,0x00,
   0x41,0x00,0x02,0x03,0x81,0x41,0x81,0x01,0x00,0x00,0x81,0x00,0x00,
   0x00,0x4F,0x00,0x01,0x00,0x00,0x00,0x43,0x01,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x82,0x00,0x00,
   0x00,0x89,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x81,0x00,0x81,
   0x01,0x00,0x00,0x00,0x41,0x0A,0x81,0x04,0x00,0x00,0x00,0x00,0x01,
   0x01,0x00,0x81,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,
   0x00,0x05,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x41,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x41,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x81,0x81,0x00,0x81,0x00,0x00,0x41,0x00,0x00,0x00,0x01,0x81,
   0x81,0x0F,0x41,0x00,0x07,0x00,0x81,0x00,0x00,0x00,0x00,0x81,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x41,0x00,0x01,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x42,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,
   0x81,0x41,0x00,0x81,0x00,0x00,0x00,0x81,0x81,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,
   0x01,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x01,0x01,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,
   0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x41,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x81,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x81,0x41,
   0x41,0x03,0x00,0x41,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x43,0x00,0x01,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x81,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x02,0x01,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x81,0x00,0x41,0x81,0x00,0x00,0x45,0x01,0x81,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x81,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x81,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,
   0x00,0x00,0x00,0x43,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x81,0x00,0x81,0x81,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x81,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x01,0x00,0x41,0x01,0x44,0x00,0x01,0x01,0x00,0x00,0x00,0x00,
   0x00,0x41,0x41,0x00,0x00,0x00,0x01,0x01,0x41,0x00,0x00,0x00,0x00,
   0x00,0x00,0x81,0x41,0x81,0x00,0x41,0x00,0x00,0x01,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x41,0x00,0x81,0x00,0x00,0x00,
   0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x41,0x01,0x00,0x00,0x00,
   0x81,0x00,0x00,0x00,0x00,0x01,0x41,0x00,0x00,0x00,0x41,0x00,0x41,
   0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x01,0x00,0x00,0x00,0x81,0x81,0x00,0x41,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x81,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x41,0x00,
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x81,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x81,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x41,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x41,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00 };
#endif
#endif
#ifdef NEW_ACNA
/*
 *  Trigram frequency tables for acna.c.
 *  Generated from : *.nam
 *  Written to file : acna.c
 *  Created on : 08/21/01 at 16:43:10
 */
const unsigned char far english[] = {
   0x00,0x2C,0x06,0x00,0x32,0x04,0x00,0x41,0x13,0x00,0x45,0x0B,0x00,0x49,0x05,
   0x00,0x4C,0x06,0x00,0x4F,0x0F,0x00,0x52,0x14,0x00,0x55,0x0C,0x00,0x59,0x03,
   0x00,0x68,0x0A,0x00,0x6F,0x21,0x00,0x72,0x12,0x00,0x75,0x07,0x00,0x81,0x09,
   0x00,0x85,0x0D,0x00,0x8F,0x0A,0x00,0x95,0x0D,0x00,0xA1,0x06,0x00,0xA4,0x04,
   0x00,0xAC,0x04,0x00,0xAD,0x03,0x00,0xC1,0x06,0x00,0xC9,0x03,0x00,0xCF,0x09,
   0x00,0xD2,0x07,0x00,0xE1,0x0A,0x00,0xE9,0x06,0x00,0xEF,0x0A,0x00,0xF2,0x0B,
   0x01,0x01,0x1D,0x01,0x05,0x0C,0x01,0x09,0x0A,0x01,0x0F,0x18,0x01,0x15,0x09,
   0x01,0x4F,0x05,0x01,0x65,0x13,0x01,0x69,0x0D,0x01,0x81,0x0D,0x01,0x85,0x09,
   0x01,0x89,0x08,0x01,0x8F,0x0D,0x01,0xA1,0x16,0x01,0xAF,0x0D,0x01,0xB5,0x04,
   0x01,0xC5,0x06,0x01,0xCF,0x07,0x01,0xEE,0x40,0x02,0x01,0x0A,0x02,0x05,0x0C,
   0x02,0x12,0x07,0x02,0x15,0x04,0x02,0x45,0x0B,0x02,0x49,0x07,0x02,0x4F,0x0F,
   0x02,0x55,0x05,0x02,0x61,0x07,0x02,0x65,0x08,0x02,0x68,0x0D,0x02,0x69,0x06,
   0x02,0x6F,0x04,0x02,0x70,0x05,0x02,0x74,0x13,0x02,0x75,0x03,0x02,0x88,0x07,
   0x02,0x89,0x06,0x02,0x8F,0x06,0x02,0x92,0x06,0x02,0x95,0x05,0x02,0x97,0x02,
   0x02,0xE1,0x11,0x02,0xE5,0x06,0x02,0xE8,0x0E,0x02,0xE9,0x0E,0x02,0xEF,0x0B,
   0x04,0x2C,0x80,0x04,0x40,0x80,0x04,0x41,0x80,0x04,0x49,0x80,0x04,0x4C,0x40,
   0x04,0x65,0x41,0x04,0x68,0x40,0x04,0x74,0x80,0x04,0x80,0x03,0x04,0x84,0x03,
   0x04,0x85,0x41,0x04,0x88,0x80,0x04,0x8E,0x80,0x04,0x92,0x80,0x04,0xB2,0x40,
   0x04,0xC5,0x40,0x04,0xD4,0x40,0x04,0xD7,0x80,0x04,0xE1,0x40,0x04,0xE2,0x40,
   0x04,0xE4,0x40,0x04,0xE5,0x43,0x04,0xE9,0x40,0x04,0xEE,0x80,0x04,0xF5,0x40,
   0x04,0xF7,0x80,0x04,0xF9,0x40,0x05,0x0C,0x41,0x05,0x12,0x80,0x05,0x22,0x80,
   0x05,0x2B,0x80,0x05,0x2E,0x03,0x05,0x65,0x05,0x05,0x6F,0x40,0x05,0x75,0x40,
   0x05,0x77,0x80,0x05,0x82,0x81,0x05,0x83,0x80,0x05,0x85,0x45,0x05,0x8C,0x12,
   0x05,0x8E,0x80,0x05,0x90,0x40,0x05,0x96,0x80,0x05,0xA0,0x11,0x05,0xB0,0x04,
   0x05,0xB3,0x03,0x05,0xB5,0x80,0x05,0xB7,0x80,0x05,0xC0,0x29,0x05,0xC4,0x0D,
   0x05,0xC5,0x45,0x05,0xD3,0x08,0x05,0xD4,0x04,0x05,0xDA,0x40,0x05,0xF2,0x40,
   0x06,0x12,0x80,0x06,0x14,0x80,0x06,0x44,0x0B,0x06,0x47,0x80,0x06,0x4B,0x08,
   0x06,0x4C,0x05,0x06,0x4D,0x81,0x06,0x4E,0x08,0x06,0x53,0x05,0x06,0x54,0x08,
   0x06,0x55,0x80,0x06,0x56,0x81,0x06,0x5A,0x80,0x06,0x63,0x80,0x06,0x65,0x03,
   0x06,0x68,0x03,0x06,0x6E,0x80,0x06,0x73,0x05,0x06,0x74,0x06,0x06,0x81,0x80,
   0x06,0x85,0x04,0x06,0x88,0x07,0x06,0x8F,0x42,0x06,0x94,0x08,0x06,0x95,0x40,
   0x06,0xA4,0x80,0x06,0xA5,0x80,0x06,0xAA,0x80,0x06,0xAC,0x80,0x06,0xB2,0x80,
   0x06,0xB4,0x80,0x06,0xB7,0x40,0x06,0xC5,0x07,0x06,0xE1,0x43,0x06,0xE9,0x80,
   0x06,0xEB,0x81,0x07,0x20,0x0F,0x07,0x21,0x80,0x07,0x2D,0x80,0x07,0x2F,0x40,
   0x08,0x21,0x80,0x08,0x23,0x80,0x08,0x25,0x40,0x08,0x29,0x80,0x08,0x2E,0x03,
   0x08,0x32,0x07,0x08,0x4F,0x80,0x08,0xA1,0x81,0x08,0xAB,0x80,0x08,0xAE,0x83,
   0x08,0xB2,0x09,0x09,0x23,0x80,0x09,0x24,0x80,0x09,0x25,0x41,0x09,0x32,0x81,
   0x09,0x81,0x84,0x09,0x85,0x06,0x09,0x8F,0x81,0x09,0xE5,0x40,0x09,0xF3,0x81,
   0x09,0xF6,0x80,0x09,0xF7,0x83,0x09,0xF8,0x40,0x0A,0x41,0x87,0x0A,0x45,0x03,
   0x0A,0x49,0x06,0x0A,0x4F,0x08,0x0A,0x55,0x81,0x0A,0x59,0x80,0x0A,0xA3,0x80,
   0x0A,0xAC,0x80,0x0A,0xB2,0x0B,0x0C,0x22,0x80,0x0C,0x28,0x80,0x0C,0x32,0x85,
   0x0C,0x35,0x80,0x0C,0x37,0x80,0x0C,0x39,0x80,0x0C,0xA0,0x07,0x0C,0xAE,0x40,
   0x0D,0x00,0x04,0x0D,0x01,0x04,0x0D,0x09,0x04,0x0D,0x25,0x80,0x0D,0x33,0x80,
   0x0D,0x60,0x0C,0x0D,0x6F,0x40,0x0D,0x81,0x81,0x0D,0x85,0x81,0x0D,0x8F,0x80,
   0x0D,0x95,0x80,0x0D,0x99,0x80,0x0D,0xE5,0x41,0x0D,0xEC,0x05,0x0D,0xED,0x04,
   0x0D,0xEE,0x06,0x0D,0xF2,0x83,0x0D,0xF3,0x81,0x0D,0xF4,0x03,0x0D,0xF5,0x81,
   0x0D,0xF6,0x80,0x0D,0xF7,0x80,0x0E,0x45,0x82,0x0E,0x49,0x82,0x0E,0x4F,0x88,
   0x0E,0x55,0x82,0x0E,0xAC,0x80,0x0E,0xAE,0x80,0x0E,0xB2,0x82,0x0E,0xB3,0x81,
   0x0E,0xE9,0x40,0x10,0x28,0x80,0x10,0x29,0x80,0x10,0x2C,0x04,0x10,0x33,0x80,
   0x10,0x35,0x80,0x10,0x36,0x81,0x10,0x85,0x03,0x10,0xA0,0x05,0x10,0xA2,0x80,
   0x10,0xA3,0x80,0x10,0xA8,0x40,0x10,0xA9,0x80,0x10,0xAA,0x80,0x10,0xAB,0x80,
   0x10,0xAC,0x06,0x10,0xAE,0x07,0x10,0xAF,0x80,0x10,0xB2,0x0A,0x11,0x21,0x80,
   0x11,0x25,0x41,0x11,0x2E,0x06,0x11,0x32,0x40,0x11,0x34,0x40,0x11,0x85,0x07,
   0x11,0xA1,0x42,0x11,0xEE,0x44,0x11,0xF6,0x40,0x11,0xF7,0x82,0x12,0x41,0x40,
   0x12,0x49,0x03,0x12,0x59,0x80,0x12,0x60,0x08,0x12,0x65,0x41,0x12,0x6F,0x44,
   0x12,0xA1,0x80,0x12,0xA3,0x80,0x12,0xA7,0x80,0x12,0xAE,0x84,0x12,0xB2,0x82,
   0x12,0xB3,0x80,0x13,0x20,0x09,0x13,0x2B,0x80,0x14,0x24,0x04,0x14,0x27,0x81,
   0x14,0x33,0x06,0x14,0x34,0x09,0x14,0x65,0x40,0x14,0xA6,0x80,0x14,0xA7,0x80,
   0x14,0xAB,0x40,0x14,0xAC,0x03,0x14,0xAE,0x04,0x14,0xB2,0x80,0x14,0xB4,0x40,
   0x14,0xB6,0x40,0x14,0xC5,0x40,0x14,0xE1,0x40,0x14,0xF2,0x80,0x14,0xF9,0x80,
   0x15,0x0C,0x41,0x15,0x0D,0x80,0x15,0x32,0x80,0x15,0x33,0x80,0x15,0x61,0x40,
   0x15,0x80,0x07,0x15,0x84,0x4E,0x15,0x86,0x80,0x15,0x8B,0x81,0x15,0x8C,0x2B,
   0x15,0x8E,0x80,0x15,0x93,0x05,0x15,0x96,0x80,0x15,0x99,0x43,0x15,0xA1,0x03,
   0x15,0xB0,0x81,0x15,0xC0,0x19,0x15,0xC4,0x05,0x15,0xCE,0x06,0x15,0xD3,0x09,
   0x15,0xD4,0x03,0x15,0xDA,0x40,0x15,0xEE,0x40,0x15,0xF2,0x80,0x16,0x0C,0x80,
   0x16,0x40,0x2D,0x16,0x49,0x05,0x16,0x4C,0x07,0x16,0x50,0x80,0x16,0x52,0x06,
   0x16,0x53,0x18,0x16,0x54,0x06,0x16,0x59,0x40,0x16,0x60,0x16,0x16,0x61,0x40,
   0x16,0x65,0x41,0x16,0x6F,0x42,0x16,0x73,0x04,0x16,0x74,0x05,0x16,0x81,0x40,
   0x16,0x83,0x80,0x16,0x8F,0x42,0x16,0x92,0x80,0x16,0x94,0x17,0x16,0x95,0x80,
   0x16,0xB2,0x80,0x16,0xB3,0x80,0x16,0xC1,0x81,0x16,0xC5,0x03,0x16,0xCF,0x80,
   0x17,0x20,0x3F,0x17,0x24,0x80,0x17,0x45,0x40,0x18,0x29,0x80,0x18,0x2E,0x80,
   0x18,0x32,0x82,0x18,0x35,0x80,0x18,0x39,0x40,0x18,0xA5,0x80,0x18,0xAE,0x80,
   0x18,0xB7,0x80,0x19,0x24,0x80,0x19,0x25,0x0C,0x19,0x33,0x80,0x19,0x34,0x40,
   0x19,0x36,0x40,0x19,0x38,0x40,0x19,0x81,0x80,0x19,0xA1,0x40,0x19,0xEE,0x40,
   0x19,0xEF,0x40,0x19,0xF2,0x0C,0x1A,0x41,0x81,0x1A,0x45,0x04,0x1A,0x49,0x81,
   0x1A,0x4F,0x80,0x1A,0x59,0x80,0x1A,0xAC,0x81,0x1A,0xAE,0x80,0x1A,0xB3,0x40,
   0x1C,0x24,0x80,0x1C,0x28,0x40,0x1C,0x2A,0x40,0x1C,0x2E,0x47,0x1C,0xA0,0x0C,
   0x1C,0xA1,0x80,0x1C,0xA4,0x40,0x1C,0xB2,0x03,0x1C,0xB4,0x41,0x1D,0x05,0x40,
   0x1D,0x22,0x80,0x1D,0x25,0x40,0x1D,0x2C,0x04,0x1D,0x2D,0x40,0x1D,0x33,0x40,
   0x1D,0x81,0x80,0x1D,0x8F,0x80,0x1D,0xA1,0x40,0x1D,0xC5,0x40,0x1D,0xCF,0x40,
   0x1D,0xD3,0x40,0x1D,0xE4,0x80,0x1D,0xE6,0x80,0x1D,0xE7,0x80,0x1D,0xEC,0x81,
   0x1D,0xEE,0x40,0x1D,0xEF,0x06,0x1D,0xF4,0x40,0x1D,0xF6,0x40,0x1D,0xF7,0x80,
   0x1E,0x45,0x06,0x1E,0x49,0x82,0x1E,0x4F,0x03,0x1E,0x8F,0x49,0x1E,0x92,0x40,
   0x1E,0xA5,0x40,0x1E,0xB3,0x40,0x20,0x22,0x80,0x20,0x23,0x80,0x20,0x24,0x81,
   0x20,0x27,0x81,0x20,0x2C,0x06,0x20,0x2D,0x0F,0x20,0x2E,0x07,0x20,0x32,0x0B,
   0x20,0x34,0x82,0x20,0x36,0x80,0x20,0x37,0x03,0x20,0x38,0x80,0x20,0xA5,0x80,
   0x20,0xA6,0x80,0x20,0xA7,0x80,0x20,0xAC,0x04,0x20,0xAD,0x80,0x20,0xAE,0x04,
   0x20,0xB2,0x0E,0x20,0xB6,0x80,0x21,0x22,0x80,0x21,0x23,0x81,0x21,0x24,0x80,
   0x21,0x27,0x81,0x21,0x2B,0x40,0x21,0x2C,0x06,0x21,0x2D,0x40,0x21,0x2E,0x04,
   0x21,0x36,0x80,0x21,0x85,0x41,0x21,0xA1,0x41,0x21,0xC5,0x40,0x21,0xEC,0x09,
   0x21,0xED,0x03,0x21,0xF2,0x07,0x21,0xF3,0x80,0x22,0x49,0x04,0x22,0xA2,0x80,
   0x22,0xA3,0x80,0x22,0xA4,0x81,0x22,0xA5,0x40,0x22,0xA7,0x80,0x22,0xA9,0x80,
   0x22,0xAE,0x81,0x22,0xB4,0x80,0x22,0xB8,0x80,0x22,0xC5,0x40,0x24,0x32,0x40,
   0x24,0x34,0x40,0x24,0x4F,0x40,0x24,0x65,0x41,0x24,0x68,0x04,0x24,0x6B,0x0B,
   0x24,0x81,0x41,0x24,0x85,0x03,0x24,0x87,0x07,0x24,0x8C,0x80,0x24,0x8F,0x40,
   0x24,0xA0,0x0A,0x24,0xA7,0x80,0x24,0xAC,0x4E,0x24,0xB4,0x80,0x24,0xC5,0x40,
   0x24,0xE1,0x41,0x24,0xE2,0x40,0x24,0xE3,0x80,0x24,0xE5,0x40,0x24,0xE7,0x05,
   0x24,0xEE,0x40,0x24,0xEF,0x80,0x24,0xF4,0x80,0x25,0x0F,0x80,0x25,0x75,0x80,
   0x25,0x83,0x80,0x25,0x85,0x45,0x25,0x86,0x80,0x25,0x8C,0x15,0x25,0x8F,0x40,
   0x25,0x96,0x80,0x25,0x9A,0x80,0x25,0xA1,0x40,0x25,0xA2,0x81,0x25,0xA3,0x80,
   0x25,0xAB,0x80,0x25,0xC0,0x0D,0x25,0xC3,0x81,0x25,0xC5,0x05,0x25,0xC6,0x80,
   0x25,0xC7,0x30,0x25,0xC8,0x80,0x25,0xD3,0x13,0x25,0xD5,0x80,0x25,0xEE,0x40,
   0x25,0xF4,0x40,0x26,0x05,0x40,0x26,0x53,0x40,0x26,0x69,0x80,0x26,0x6F,0x49,
   0x26,0x74,0x04,0x26,0x85,0x04,0x26,0x88,0x04,0x26,0x8F,0x40,0x26,0x94,0x0D,
   0x26,0xC5,0x04,0x26,0xC9,0x80,0x26,0xCF,0x80,0x26,0xD9,0x40,0x27,0x5A,0x80,
   0x28,0x23,0x81,0x28,0x2E,0x80,0x28,0x33,0x80,0x28,0xA1,0x80,0x28,0xB2,0x80,
   0x28,0xB7,0x80,0x29,0x22,0x80,0x29,0x2E,0x80,0x29,0xEC,0x81,0x29,0xF3,0x80,
   0x2C,0x24,0x40,0x2C,0x27,0x80,0x2C,0x29,0x40,0x2C,0x2E,0x40,0x2C,0x30,0x80,
   0x2C,0x34,0x40,0x2C,0x37,0x80,0x2C,0x3A,0x80,0x2C,0x6F,0x40,0x2C,0xA0,0x05,
   0x2C,0xA1,0x02,0x2C,0xA4,0x80,0x2C,0xA9,0x80,0x2C,0xAC,0x04,0x2C,0xAD,0x81,
   0x2C,0xAE,0x04,0x2C,0xB2,0x0B,0x2C,0xB3,0x03,0x2C,0xB6,0x80,0x2C,0xB9,0x43,
   0x2D,0x22,0x80,0x2D,0x26,0x80,0x2D,0x27,0x80,0x2D,0x2C,0x84,0x2D,0x2E,0x10,
   0x2D,0x30,0x80,0x2D,0x85,0x45,0x2D,0x8F,0x80,0x2D,0xC9,0x80,0x2D,0xF2,0x80,
   0x2D,0xF3,0x40,0x2D,0xF5,0x80,0x2D,0xF6,0x80,0x2D,0xF7,0x80,0x2D,0xF8,0x40,
   0x2E,0x60,0x09,0x2E,0xB2,0x40,0x2E,0xE1,0x40,0x30,0x22,0x80,0x30,0x26,0x80,
   0x30,0x28,0x40,0x30,0x2E,0x0D,0x30,0x32,0x03,0x30,0x35,0x80,0x30,0x3A,0x80,
   0x30,0x80,0x0D,0x30,0x8F,0x40,0x30,0xA0,0x13,0x30,0xA1,0x84,0x30,0xA9,0x80,
   0x30,0xAD,0x04,0x30,0xAF,0x40,0x30,0xB2,0x08,0x30,0xB3,0x08,0x30,0xB4,0x07,
   0x30,0xB9,0x6B,0x31,0x01,0x40,0x31,0x25,0x42,0x31,0x2C,0x80,0x31,0x2E,0x13,
   0x31,0x33,0x04,0x31,0x34,0x81,0x31,0x80,0x33,0x31,0x82,0x80,0x31,0x89,0x0E,
   0x31,0x8C,0x40,0x31,0x93,0x04,0x31,0xA1,0x44,0x31,0xE2,0x80,0x31,0xE5,0x40,
   0x31,0xEB,0x80,0x31,0xEE,0x04,0x31,0xF2,0x03,0x31,0xF3,0x80,0x31,0xF7,0x05,
   0x32,0x60,0x04,0x32,0x62,0x80,0x32,0x81,0x40,0x32,0x85,0x40,0x32,0x8F,0x46,
   0x32,0x99,0x40,0x32,0xA2,0x80,0x32,0xAB,0x40,0x32,0xAD,0x80,0x33,0x20,0x11,
   0x33,0x2B,0x80,0x33,0x2C,0x40,0x34,0x24,0x81,0x34,0x27,0x81,0x34,0x28,0x80,
   0x34,0x29,0x80,0x34,0x2E,0x57,0x34,0x30,0x80,0x34,0x32,0x07,0x34,0x34,0x83,
   0x34,0x35,0x80,0x34,0x3A,0x40,0x34,0x49,0x40,0x34,0x4F,0x80,0x34,0xA4,0x80,
   0x34,0xA5,0x80,0x34,0xA9,0x80,0x34,0xB2,0x04,0x35,0x23,0x81,0x35,0x24,0x81,
   0x35,0x2B,0x80,0x35,0x2E,0x05,0x35,0x2F,0x40,0x35,0x32,0x40,0x35,0x34,0x04,
   0x35,0xE9,0x80,0x35,0xEA,0x40,0x35,0xEE,0x06,0x35,0xF2,0x05,0x36,0x01,0x40,
   0x36,0xA4,0x80,0x37,0x25,0x80,0x37,0x2B,0x80,0x38,0x22,0x80,0x38,0x23,0x40,
   0x38,0x29,0x80,0x38,0x2A,0x40,0x38,0x2E,0x43,0x38,0x32,0x40,0x38,0x36,0x40,
   0x38,0x41,0x40,0x38,0x65,0x43,0x38,0x73,0x40,0x38,0x80,0x09,0x38,0x82,0x40,
   0x38,0x85,0x04,0x38,0x93,0x05,0x38,0x94,0x40,0x38,0xA0,0x11,0x38,0xA9,0x80,
   0x38,0xAC,0x05,0x38,0xAE,0x40,0x38,0xB2,0x06,0x38,0xB3,0x07,0x38,0xB9,0x46,
   0x38,0xE0,0x20,0x38,0xE5,0x41,0x38,0xF3,0x07,0x38,0xF4,0x09,0x39,0x23,0x03,
   0x39,0x2B,0x80,0x39,0x2E,0x05,0x39,0x2F,0x40,0x39,0xA1,0x40,0x39,0xC5,0x05,
   0x39,0xC9,0x05,0x39,0xE4,0x80,0x39,0xE6,0x80,0x39,0xE9,0x40,0x39,0xEE,0x42,
   0x39,0xF2,0x05,0x39,0xF3,0x80,0x39,0xF7,0x81,0x39,0xF9,0x80,0x39,0xFA,0x80,
   0x3A,0x60,0x1A,0x3A,0x65,0x03,0x3A,0x6F,0x4B,0x3A,0x8F,0x43,0x3A,0x9A,0x40,
   0x3A,0xA5,0x40,0x3A,0xA7,0x80,0x3A,0xC5,0x80,0x3C,0x41,0x80,0x3C,0x61,0x80,
   0x3C,0x6B,0x0B,0x3C,0x80,0x0B,0x3C,0xA8,0x40,0x3C,0xB3,0x40,0x3C,0xD3,0x40,
   0x3C,0xD4,0x02,0x3C,0xE1,0x41,0x3C,0xE2,0x80,0x3C,0xEE,0x80,0x3C,0xEF,0x80,
   0x3C,0xF5,0x40,0x3C,0xF6,0x80,0x3D,0x09,0x80,0x3D,0x0C,0x40,0x3D,0x0F,0x80,
   0x3D,0x2C,0x80,0x3D,0x2E,0x80,0x3D,0x33,0x80,0x3D,0x45,0x40,0x3D,0x84,0x03,
   0x3D,0x85,0x04,0x3D,0x87,0x80,0x3D,0x8C,0x0D,0x3D,0x94,0x81,0x3D,0xA2,0x03,
   0x3D,0xA4,0x40,0x3D,0xAB,0x80,0x3D,0xAD,0x81,0x3D,0xAF,0x40,0x3D,0xC0,0x3F,
   0x3D,0xC5,0x06,0x3D,0xC7,0x05,0x3D,0xC9,0x40,0x3D,0xD3,0x04,0x3D,0xEB,0x06,
   0x3D,0xEC,0x82,0x3E,0x09,0x40,0x3E,0x0B,0x80,0x3E,0x0C,0x80,0x3E,0x13,0x80,
   0x3E,0x17,0x80,0x3E,0x40,0x05,0x3E,0x44,0x0A,0x3E,0x45,0x06,0x3E,0x46,0x80,
   0x3E,0x4E,0x07,0x3E,0x4F,0x80,0x3E,0x53,0x04,0x3E,0x54,0x0B,0x3E,0x56,0x80,
   0x3E,0x59,0x40,0x3E,0x63,0x80,0x3E,0x65,0x03,0x3E,0x67,0x80,0x3E,0x68,0x80,
   0x3E,0x6B,0x80,0x3E,0x73,0x03,0x3E,0x85,0x40,0x3E,0x8F,0x40,0x3E,0x94,0x09,
   0x3E,0xA1,0x40,0x3E,0xC5,0x07,0x3E,0xE5,0x08,0x3E,0xE9,0x80,0x3E,0xEB,0x80,
   0x3E,0xEC,0x05,0x3F,0x21,0x40,0x3F,0x25,0x41,0x3F,0x5A,0x80,0x40,0x24,0x80,
   0x40,0x27,0x40,0x40,0x2C,0x40,0x40,0x2F,0x40,0x40,0x32,0x04,0x40,0x37,0x80,
   0x40,0x38,0x80,0x40,0xA1,0x84,0x40,0xA4,0x80,0x40,0xAE,0x03,0x40,0xB2,0x05,
   0x40,0xB3,0x40,0x40,0xB4,0x82,0x40,0xB9,0x40,0x41,0x24,0x80,0x41,0x2B,0x40,
   0x41,0x32,0x40,0x41,0x85,0x04,0x41,0x95,0x80,0x41,0xF3,0x80,0x41,0xF5,0x80,
   0x41,0xF6,0x80,0x41,0xF7,0x80,0x41,0xF9,0x80,0x42,0x01,0x40,0x42,0x13,0x40,
   0x42,0x19,0x40,0x42,0x49,0x82,0x42,0x4F,0x81,0x42,0x55,0x80,0x42,0xAC,0x80,
   0x42,0xAD,0x80,0x42,0xB2,0x83,0x46,0xA1,0x80,0x46,0xA5,0x80,0x46,0xA9,0x80,
   0x48,0x26,0x40,0x48,0x2A,0x40,0x48,0x2D,0x05,0x48,0x2E,0x07,0x48,0x36,0x81,
   0x48,0x39,0x03,0x48,0x3A,0x80,0x48,0x69,0x80,0x48,0x80,0x0D,0x48,0x95,0x40,
   0x48,0xA0,0x05,0x48,0xA1,0x06,0x48,0xA2,0x80,0x48,0xA4,0x05,0x48,0xA5,0x09,
   0x48,0xAB,0x80,0x48,0xAC,0x04,0x48,0xAD,0x80,0x48,0xAE,0x07,0x48,0xB4,0x03,
   0x48,0xB6,0x80,0x48,0xB9,0x43,0x48,0xE9,0x40,0x48,0xEC,0x40,0x49,0x21,0x40,
   0x49,0x23,0x07,0x49,0x24,0x09,0x49,0x27,0x04,0x49,0x28,0x80,0x49,0x2E,0x09,
   0x49,0x30,0x80,0x49,0x33,0x09,0x49,0x34,0x03,0x49,0x36,0x80,0x49,0x65,0x04,
   0x49,0xC5,0x0B,0x49,0xE2,0x81,0x49,0xE4,0x03,0x49,0xE8,0x80,0x49,0xEA,0x40,
   0x49,0xEF,0x04,0x49,0xF7,0x05,0x49,0xFA,0x80,0x4A,0x45,0x04,0x4A,0x47,0x80,
   0x4A,0x49,0x08,0x4A,0x59,0x43,0x4A,0x60,0x0D,0x4A,0x65,0x03,0x4A,0x6F,0x4C,
   0x4A,0x80,0x04,0x4A,0x88,0x09,0x4A,0x8F,0x44,0x4A,0xA1,0x80,0x4A,0xA2,0x80,
   0x4A,0xA3,0x40,0x4A,0xA5,0x80,0x4A,0xA8,0x40,0x4A,0xA9,0x80,0x4A,0xAC,0x40,
   0x4A,0xAD,0x03,0x4A,0xE1,0x40,0x4B,0x20,0x06,0x4B,0x2E,0x80,0x4B,0x2F,0x40,
   0x4B,0x34,0x80,0x4C,0x23,0x40,0x4C,0x27,0x40,0x4C,0x29,0x40,0x4C,0x2E,0x81,
   0x4C,0x32,0x81,0x4C,0x34,0x80,0x4C,0x35,0x80,0x4C,0x61,0x81,0x4C,0x68,0x80,
   0x4C,0x8F,0x40,0x4C,0xA0,0x06,0x4C,0xA1,0x82,0x4C,0xA3,0x80,0x4C,0xA7,0x80,
   0x4C,0xA8,0x80,0x4C,0xA9,0x80,0x4C,0xAC,0x06,0x4C,0xAE,0x08,0x4C,0xB2,0x03,
   0x4C,0xB6,0x80,0x4C,0xB9,0x48,0x4C,0xC1,0x40,0x4D,0x01,0x06,0x4D,0x03,0x80,
   0x4D,0x05,0x06,0x4D,0x0F,0x04,0x4D,0x12,0x80,0x4D,0x15,0x80,0x4D,0x21,0x40,
   0x4D,0x22,0x80,0x4D,0x27,0x80,0x4D,0x2C,0x80,0x4D,0x2D,0x81,0x4D,0x85,0x4A,
   0x4D,0xA5,0x80,0x4D,0xA9,0x04,0x4D,0xC1,0x80,0x4D,0xC5,0x81,0x4D,0xC9,0x80,
   0x4D,0xCF,0x81,0x4D,0xD9,0x80,0x4D,0xEE,0x7F,0x4D,0xF7,0x80,0x4E,0x01,0x80,
   0x4E,0x65,0x05,0x4E,0x68,0x80,0x4E,0x6F,0x44,0x4E,0x80,0x06,0x4E,0x81,0x08,
   0x4E,0x85,0x05,0x4E,0x89,0x03,0x4E,0x8A,0x80,0x4E,0x8F,0x0F,0x4E,0x95,0x80,
   0x4E,0xA4,0x80,0x4E,0xA7,0x80,0x4E,0xA9,0x80,0x4E,0xAD,0x80,0x4E,0xAE,0x80,
   0x4E,0xB2,0x80,0x4E,0xB3,0x80,0x4E,0xB4,0x80,0x4E,0xE1,0x82,0x50,0x23,0x40,
   0x50,0x24,0x40,0x50,0x26,0x80,0x50,0x35,0x80,0x50,0x68,0x06,0x50,0x69,0x80,
   0x50,0xA0,0x05,0x50,0xAA,0x40,0x50,0xB2,0x0A,0x50,0xB4,0x80,0x50,0xB6,0x80,
   0x50,0xB8,0x40,0x51,0x00,0x0E,0x51,0x01,0x04,0x51,0x05,0x0A,0x51,0x0F,0x06,
   0x51,0x23,0x40,0x51,0x25,0x40,0x51,0x2C,0x81,0x51,0x2D,0x81,0x51,0x2E,0x06,
   0x51,0xC5,0x40,0x51,0xE2,0x81,0x51,0xE3,0x81,0x51,0xEB,0x80,0x51,0xEE,0x70,
   0x51,0xF4,0x80,0x51,0xF5,0x80,0x51,0xF9,0x40,0x52,0x01,0x40,0x52,0x45,0x04,
   0x52,0x55,0x80,0x52,0x60,0x04,0x52,0x6F,0x43,0x52,0x80,0x23,0x52,0x85,0x07,
   0x52,0x8F,0x43,0x52,0xA1,0x80,0x52,0xA4,0x80,0x52,0xA5,0x80,0x52,0xA6,0x80,
   0x52,0xB2,0x82,0x53,0x20,0x03,0x53,0x33,0x40,0x54,0x32,0x40,0x54,0x39,0x80,
   0x54,0x41,0x80,0x54,0x49,0x80,0x54,0x4C,0x80,0x54,0x65,0x40,0x54,0x81,0x80,
   0x54,0x89,0x80,0x54,0x8B,0x80,0x54,0xA2,0x80,0x54,0xA5,0x40,0x54,0xAE,0x80,
   0x54,0xB3,0x80,0x54,0xB4,0x40,0x54,0xCF,0x80,0x54,0xE5,0x80,0x55,0x09,0x80,
   0x55,0x0E,0x40,0x55,0x32,0x80,0x55,0x65,0x40,0x55,0x8C,0x03,0x55,0x90,0x80,
   0x55,0xB3,0x80,0x55,0xC5,0x40,0x55,0xCE,0x83,0x55,0xE8,0x40,0x56,0x01,0x40,
   0x56,0x05,0x40,0x56,0x09,0x40,0x56,0x0C,0x80,0x56,0x13,0x80,0x56,0x14,0x80,
   0x56,0x44,0x81,0x56,0x46,0x80,0x56,0x47,0x80,0x56,0x4E,0x05,0x56,0x4F,0x40,
   0x56,0x52,0x05,0x56,0x56,0x80,0x56,0x61,0x80,0x56,0x65,0x43,0x56,0x67,0x80,
   0x56,0x6B,0x40,0x56,0x88,0x03,0x56,0x89,0x40,0x56,0x8B,0x80,0x56,0x8E,0x80,
   0x56,0x8F,0x40,0x56,0x94,0x04,0x56,0xC1,0x80,0x56,0xE5,0x40,0x57,0x02,0x80,
   0x58,0x27,0x40,0x58,0x35,0x80,0x58,0x37,0x80,0x58,0xA1,0x80,0x58,0xA4,0x40,
   0x58,0xA7,0x80,0x58,0xAE,0x04,0x58,0xB2,0x0A,0x58,0xB4,0x40,0x59,0x23,0x40,
   0x59,0x2E,0x06,0x59,0x34,0x40,0x59,0xE9,0x40,0x59,0xF9,0x40,0x5C,0x24,0x81,
   0x5C,0x26,0x80,0x5C,0x28,0x40,0x5C,0x2C,0x06,0x5C,0x2D,0x80,0x5C,0x32,0x07,
   0x5C,0x33,0x81,0x5C,0x39,0x49,0x5C,0xA2,0x80,0x5C,0xA3,0x40,0x5C,0xA4,0x80,
   0x5C,0xA8,0x80,0x5C,0xAC,0x4F,0x5C,0xB2,0x43,0x5D,0x09,0x89,0x5D,0x0F,0x80,
   0x5D,0x26,0x80,0x5D,0x2B,0x40,0x5D,0x2C,0x0A,0x5D,0x2E,0x04,0x5D,0xEE,0x80,
   0x5D,0xF2,0x07,0x5F,0x2B,0x80,0x62,0x85,0x80,0x62,0x8F,0x41,0x63,0x0F,0x40,
   0x64,0x27,0x80,0x64,0x2B,0x80,0x64,0x2D,0x40,0x64,0x85,0x43,0x64,0x92,0x80,
   0x64,0x93,0x40,0x64,0xAC,0x80,0x64,0xB2,0x45,0x65,0x65,0x40,0x65,0x6F,0x80,
   0x65,0x85,0x43,0x65,0x89,0x40,0x65,0xA1,0x40,0x65,0xA5,0x40,0x65,0xA9,0x80,
   0x65,0xC5,0x44,0x65,0xCE,0x40,0x65,0xCF,0x40,0x65,0xD5,0x40,0x65,0xF5,0x81,
   0x66,0x4F,0x40,0x66,0x53,0x40,0x66,0x6F,0x41,0x68,0xAA,0x40,0x69,0x25,0x40,
   0x69,0xEE,0x40,0x69,0xF2,0x40,0x6B,0x49,0x40};
const unsigned int english_entries = 1103;
/*
 *  Trigram frequency tables for acna.c.
 *  Generated from : *.nam
 *  Written to file : acna.c
 *  Created on : 08/21/01 at 16:43:10
 */
const unsigned char far french[] = {
   0x00,0x2C,0x03,0x00,0x32,0x06,0x00,0x41,0x18,0x00,0x45,0x2A,0x00,0x49,0x06,
   0x00,0x4C,0x0A,0x00,0x4F,0x36,0x00,0x52,0x19,0x00,0x55,0x0D,0x00,0x68,0x2A,
   0x00,0x6C,0x06,0x00,0x72,0x05,0x00,0x81,0x13,0x00,0x85,0x30,0x00,0x8F,0x08,
   0x00,0x92,0x05,0x00,0x95,0x11,0x00,0xC1,0x10,0x00,0xCF,0x07,0x00,0xD2,0x09,
   0x00,0xD5,0x03,0x00,0xE1,0x23,0x00,0xE5,0x09,0x00,0xE9,0x0B,0x00,0xEF,0x0F,
   0x00,0xF5,0x10,0x01,0x05,0x03,0x01,0x09,0x05,0x01,0x41,0x07,0x01,0x45,0x04,
   0x01,0x4F,0x06,0x01,0x81,0x3F,0x01,0x85,0x2D,0x01,0x8F,0x08,0x01,0xA1,0x1F,
   0x01,0xAF,0x16,0x02,0x01,0x06,0x02,0x09,0x09,0x02,0x0F,0x09,0x02,0x12,0x0B,
   0x02,0x45,0x0B,0x02,0x49,0x09,0x02,0x4F,0x16,0x02,0x61,0x09,0x02,0x68,0x04,
   0x02,0x69,0x06,0x02,0x85,0x03,0x02,0x88,0x0F,0x02,0x8F,0x06,0x02,0x92,0x06,
   0x02,0xC1,0x08,0x02,0xC5,0x05,0x02,0xC9,0x06,0x04,0x41,0x03,0x04,0x42,0x80,
   0x04,0x45,0x82,0x04,0x49,0x81,0x04,0x4F,0x07,0x04,0x52,0x04,0x04,0x55,0x80,
   0x04,0x59,0x80,0x04,0x61,0x80,0x04,0x65,0x80,0x04,0x71,0x81,0x04,0x72,0x82,
   0x04,0x75,0x80,0x04,0x85,0x05,0x04,0x89,0x81,0x04,0x8F,0x80,0x04,0x92,0x03,
   0x04,0xC5,0x82,0x04,0xCF,0x84,0x04,0xD2,0x83,0x04,0xE5,0x03,0x04,0xE7,0x81,
   0x04,0xEF,0x40,0x05,0x01,0x80,0x05,0x05,0x40,0x05,0x09,0x81,0x05,0x23,0x80,
   0x05,0x2C,0x0D,0x05,0x2E,0x5A,0x05,0x32,0x46,0x05,0x33,0x15,0x05,0x65,0x40,
   0x05,0x6F,0x80,0x05,0x80,0x03,0x05,0x85,0x80,0x05,0x89,0x06,0x05,0x8C,0x0E,
   0x05,0x96,0x80,0x05,0xA2,0x0C,0x05,0xA5,0x81,0x05,0xAD,0x80,0x05,0xAF,0x84,
   0x05,0xB0,0x09,0x05,0xB2,0x40,0x05,0xC0,0x04,0x05,0xC1,0x80,0x05,0xC3,0x09,
   0x05,0xC4,0x0B,0x05,0xCB,0x80,0x05,0xCC,0x80,0x05,0xD3,0x81,0x05,0xD4,0x46,
   0x05,0xD5,0x80,0x05,0xD9,0x80,0x05,0xF5,0x81,0x06,0x09,0x81,0x06,0x0C,0x03,
   0x06,0x0F,0x81,0x06,0x15,0x40,0x06,0x42,0x06,0x06,0x43,0x8C,0x06,0x44,0x7F,
   0x06,0x45,0x03,0x06,0x49,0x09,0x06,0x4E,0x08,0x06,0x4F,0x03,0x06,0x53,0x03,
   0x06,0x54,0x0D,0x06,0x55,0x41,0x06,0x6B,0x80,0x06,0x6E,0x80,0x06,0x6F,0x80,
   0x06,0x71,0x80,0x06,0x73,0x07,0x06,0x81,0x80,0x06,0x83,0x80,0x06,0x88,0x81,
   0x06,0x89,0x80,0x06,0x92,0x40,0x06,0xA0,0x3F,0x06,0xA3,0x09,0x06,0xA4,0x0F,
   0x06,0xAC,0x6D,0x06,0xAD,0x09,0x06,0xAE,0x40,0x06,0xB0,0x02,0x06,0xB2,0x06,
   0x06,0xB3,0x03,0x06,0xB4,0x09,0x06,0xB6,0x06,0x06,0xB8,0x55,0x06,0xC1,0x85,
   0x06,0xC9,0x08,0x06,0xCF,0x03,0x07,0x21,0x80,0x07,0x2E,0x80,0x07,0x41,0x80,
   0x07,0x5A,0x81,0x08,0x24,0x81,0x08,0x29,0x81,0x08,0x2A,0x80,0x08,0x2B,0x80,
   0x08,0x2C,0x06,0x08,0x32,0x11,0x08,0x33,0x81,0x08,0x35,0x08,0x08,0x39,0x40,
   0x08,0xA3,0x80,0x08,0xA4,0x82,0x08,0xA9,0x40,0x08,0xAC,0x8A,0x08,0xAE,0x80,
   0x08,0xB3,0x80,0x08,0xB4,0x82,0x08,0xB5,0x83,0x09,0x2C,0x03,0x09,0x33,0x81,
   0x09,0x81,0x06,0x09,0x85,0x03,0x09,0x89,0x82,0x09,0x95,0x81,0x09,0xE3,0x80,
   0x09,0xE4,0x03,0x09,0xEC,0x81,0x09,0xEE,0x09,0x09,0xEF,0x80,0x09,0xF2,0x05,
   0x09,0xF3,0x03,0x09,0xF4,0x40,0x09,0xF5,0x24,0x09,0xF6,0x81,0x09,0xF9,0x03,
   0x0A,0x41,0x87,0x0A,0x45,0x83,0x0A,0x49,0x09,0x0A,0x4F,0x86,0x0A,0x55,0x84,
   0x0A,0xA4,0x80,0x0A,0xAC,0x80,0x0A,0xB2,0x87,0x0A,0xB3,0x80,0x0A,0xB4,0x80,
   0x0C,0x24,0x81,0x0C,0x29,0x04,0x0C,0x2C,0x80,0x0C,0x2D,0x83,0x0C,0x34,0x80,
   0x0C,0x36,0x81,0x0C,0xAC,0x80,0x0D,0x01,0x37,0x0D,0x05,0x25,0x0D,0x0F,0x03,
   0x0D,0x12,0x80,0x0D,0x15,0x80,0x0D,0x25,0x43,0x0D,0x85,0x40,0x0D,0x89,0x81,
   0x0D,0x8F,0x82,0x0D,0xED,0x03,0x0D,0xF2,0x86,0x0D,0xF3,0x81,0x0D,0xF4,0x03,
   0x0D,0xF5,0x17,0x0E,0x45,0x81,0x0E,0x4F,0x06,0x0E,0xA5,0x81,0x0E,0xB3,0x80,
   0x10,0x2C,0x81,0x10,0x2D,0x81,0x10,0x2E,0x81,0x10,0x2F,0x80,0x10,0x32,0x08,
   0x10,0x35,0x03,0x10,0x36,0x84,0x10,0xA0,0x05,0x10,0xA1,0x12,0x10,0xA3,0x87,
   0x10,0xA7,0x81,0x10,0xAC,0x09,0x10,0xAD,0x85,0x10,0xAE,0x05,0x10,0xB0,0x82,
   0x10,0xB2,0x04,0x10,0xB3,0x8D,0x10,0xB4,0x09,0x10,0xB6,0x86,0x11,0x25,0x03,
   0x11,0x2C,0x80,0x11,0x2E,0x49,0x11,0x2F,0x80,0x11,0x32,0x80,0x11,0x33,0x80,
   0x11,0xE2,0x80,0x11,0xEC,0x80,0x11,0xED,0x80,0x11,0xF2,0x81,0x11,0xF5,0x04,
   0x11,0xF9,0x40,0x11,0xFA,0x81,0x12,0x41,0x81,0x12,0x45,0x0A,0x12,0x49,0x04,
   0x12,0x59,0x40,0x12,0xA3,0x04,0x12,0xAC,0x80,0x12,0xB0,0x83,0x12,0xB3,0x80,
   0x14,0x2C,0x41,0x14,0x2E,0x06,0x14,0x32,0x41,0x14,0x34,0x80,0x14,0x45,0x03,
   0x14,0x4F,0x0A,0x14,0x61,0x83,0x14,0x68,0x03,0x14,0x6B,0x80,0x14,0x6F,0x04,
   0x14,0x81,0x81,0x14,0x87,0x80,0x14,0x89,0x40,0x14,0xB2,0x40,0x14,0xC1,0x81,
   0x14,0xC5,0x80,0x14,0xE1,0x03,0x14,0xE5,0x03,0x14,0xF2,0x80,0x15,0x23,0x80,
   0x15,0x27,0x80,0x15,0x2C,0x04,0x15,0x80,0x0B,0x15,0x81,0x05,0x15,0x85,0x05,
   0x15,0x89,0x09,0x15,0x8C,0x13,0x15,0x8F,0x80,0x15,0x93,0x40,0x15,0xA1,0x04,
   0x15,0xA5,0x03,0x15,0xA9,0x03,0x15,0xC0,0x04,0x15,0xC1,0x0C,0x15,0xC5,0x06,
   0x15,0xC9,0x03,0x16,0x40,0x3F,0x16,0x41,0x03,0x16,0x42,0x40,0x16,0x43,0x80,
   0x16,0x45,0x1E,0x16,0x47,0x03,0x16,0x49,0x04,0x16,0x4C,0x03,0x16,0x4D,0x82,
   0x16,0x4F,0x86,0x16,0x52,0x0F,0x16,0x53,0x45,0x16,0x54,0x03,0x16,0x56,0x82,
   0x16,0x59,0x40,0x16,0x61,0x82,0x16,0x63,0x83,0x16,0x68,0x80,0x16,0x69,0x81,
   0x16,0x6A,0x81,0x16,0x6C,0x80,0x16,0x6D,0x80,0x16,0x70,0x80,0x16,0x73,0x05,
   0x16,0x74,0x03,0x16,0x80,0x19,0x16,0x85,0x03,0x16,0x88,0x80,0x16,0x89,0x04,
   0x16,0x8F,0x82,0x16,0x92,0x82,0x16,0x93,0x40,0x16,0x94,0x79,0x16,0xA0,0x08,
   0x16,0xA3,0x81,0x16,0xAE,0x80,0x16,0xC5,0x08,0x18,0x2C,0x83,0x18,0x2E,0x82,
   0x18,0x33,0x80,0x18,0xC5,0x42,0x19,0x2C,0x80,0x19,0x33,0x80,0x19,0x85,0x03,
   0x19,0x8F,0x80,0x19,0xEE,0x41,0x19,0xF2,0x08,0x1A,0x41,0x06,0x1A,0x45,0x06,
   0x1A,0x55,0x80,0x1A,0x59,0x80,0x1A,0xAC,0x80,0x1A,0xB3,0x80,0x1C,0x22,0x83,
   0x1C,0x23,0x02,0x1C,0x24,0x81,0x1C,0x29,0x82,0x1C,0x2C,0x81,0x1C,0x2D,0x81,
   0x1C,0x32,0x0E,0x1C,0x33,0x83,0x1C,0x34,0x80,0x1C,0x35,0x0D,0x1C,0xB2,0x07,
   0x1D,0x21,0x81,0x1D,0x22,0x80,0x1D,0x25,0x40,0x1D,0x2E,0x80,0x1D,0x32,0x86,
   0x1D,0x34,0x80,0x1D,0x81,0x80,0x1D,0xC5,0x09,0x1D,0xCF,0x40,0x1D,0xF2,0x81,
   0x1D,0xF3,0x80,0x1D,0xF4,0x40,0x1D,0xF5,0x88,0x1E,0x45,0x82,0x1E,0x49,0x81,
   0x1E,0xA9,0x8E,0x1E,0xB4,0x82,0x20,0x22,0x82,0x20,0x23,0x80,0x20,0x24,0x80,
   0x20,0x27,0x80,0x20,0x2C,0x82,0x20,0x2D,0x0E,0x20,0x30,0x83,0x20,0x32,0x1E,
   0x20,0x33,0x83,0x20,0x34,0x80,0x20,0x35,0x03,0x20,0xA0,0x08,0x20,0xA1,0x82,
   0x20,0xA2,0x81,0x20,0xAC,0x03,0x20,0xAE,0x04,0x20,0xB2,0x0F,0x20,0xB3,0x04,
   0x20,0xB4,0x05,0x20,0xB6,0x83,0x21,0x22,0x86,0x21,0x25,0x4A,0x21,0x2C,0x05,
   0x21,0x33,0x80,0x21,0xA9,0x40,0x21,0xEC,0x80,0x21,0xED,0x80,0x21,0xF5,0x81,
   0x22,0x45,0x80,0x22,0xA1,0x80,0x22,0xA9,0x80,0x22,0xB2,0x80,0x24,0x23,0x40,
   0x24,0x2E,0x40,0x24,0x32,0x45,0x24,0x41,0x03,0x24,0x42,0x80,0x24,0x45,0x05,
   0x24,0x61,0x82,0x24,0x65,0x40,0x24,0x68,0x08,0x24,0x6B,0x81,0x24,0x89,0x40,
   0x24,0xA0,0x07,0x24,0xAC,0x48,0x24,0xAE,0x03,0x24,0xB2,0x7F,0x24,0xE5,0x80,
   0x24,0xEE,0x0B,0x25,0x80,0x05,0x25,0x81,0x03,0x25,0x85,0x04,0x25,0x89,0x80,
   0x25,0x8C,0x2D,0x25,0x8F,0x80,0x25,0x99,0x80,0x25,0xA5,0x03,0x25,0xAF,0x82,
   0x25,0xC0,0x3B,0x25,0xC1,0x08,0x25,0xC5,0x13,0x25,0xC7,0x80,0x25,0xCF,0x40,
   0x25,0xD3,0x40,0x25,0xD4,0x43,0x25,0xEC,0x80,0x25,0xF4,0x43,0x25,0xF5,0x41,
   0x26,0x10,0x80,0x26,0x45,0x08,0x26,0x60,0x1F,0x26,0x61,0x80,0x26,0x65,0x06,
   0x26,0x68,0x80,0x26,0x6C,0x42,0x26,0x6F,0x04,0x26,0x73,0x09,0x26,0x7A,0x80,
   0x26,0x83,0x80,0x26,0x93,0x80,0x26,0xC1,0x80,0x26,0xC9,0x05,0x26,0xCF,0x40,
   0x26,0xD2,0x80,0x27,0x45,0x80,0x28,0x23,0x81,0x28,0x29,0x80,0x28,0x2D,0x80,
   0x28,0x2E,0x80,0x28,0xB4,0x80,0x29,0xF5,0x82,0x2C,0x2E,0x80,0x2C,0x32,0x46,
   0x2D,0x22,0x80,0x2D,0x2E,0x80,0x2E,0x69,0x40,0x30,0x22,0x8B,0x30,0x23,0x08,
   0x30,0x24,0x03,0x30,0x26,0x8F,0x30,0x29,0x0F,0x30,0x2D,0x86,0x30,0x2E,0x0F,
   0x30,0x30,0x86,0x30,0x32,0x1E,0x30,0x34,0x03,0x30,0x35,0x05,0x30,0x36,0x85,
   0x30,0x39,0x41,0x30,0x3A,0x81,0x30,0x89,0x40,0x30,0xA0,0x0F,0x30,0xA1,0x47,
   0x30,0xA2,0x8A,0x30,0xA4,0x83,0x30,0xA7,0x86,0x30,0xA9,0x40,0x30,0xAC,0x82,
   0x30,0xAD,0x85,0x30,0xAE,0x82,0x30,0xAF,0x80,0x30,0xB0,0x82,0x30,0xB4,0x1A,
   0x30,0xB6,0x04,0x31,0x21,0x04,0x31,0x25,0x1C,0x31,0x2E,0x09,0x31,0x2F,0x41,
   0x31,0x32,0x80,0x31,0x36,0x03,0x31,0x3A,0x81,0x31,0x81,0x1B,0x31,0x85,0x1A,
   0x31,0x89,0x16,0x31,0xE3,0x81,0x31,0xEE,0x04,0x31,0xF3,0x80,0x31,0xF4,0x43,
   0x31,0xFA,0x81,0x32,0x80,0x28,0x32,0xAD,0x40,0x32,0xB3,0x80,0x34,0x23,0x80,
   0x34,0x24,0x80,0x34,0x27,0x81,0x34,0x28,0x83,0x34,0x29,0x0A,0x34,0x2B,0x80,
   0x34,0x2C,0x03,0x34,0x32,0x0F,0x34,0x33,0x80,0x34,0x34,0x81,0x34,0x35,0x81,
   0x34,0x39,0x81,0x34,0x41,0x06,0x34,0x45,0x05,0x34,0x55,0x80,0x34,0xA0,0x07,
   0x34,0xA9,0x80,0x34,0xAE,0x80,0x34,0xB3,0x80,0x34,0xB4,0x05,0x35,0x23,0x81,
   0x35,0x27,0x80,0x35,0x2C,0x04,0x35,0x2E,0x04,0x35,0xEC,0x83,0x35,0xEE,0x0D,
   0x35,0xF2,0x07,0x35,0xF3,0x80,0x35,0xF4,0x40,0x35,0xF5,0x09,0x36,0x13,0x41,
   0x36,0xA7,0x80,0x36,0xAE,0x80,0x36,0xB3,0x80,0x38,0x24,0x81,0x38,0x29,0x43,
   0x38,0x2E,0x41,0x38,0x30,0x81,0x38,0x32,0x54,0x38,0x34,0x40,0x38,0x35,0x09,
   0x38,0x68,0x06,0x38,0x80,0x06,0x38,0x85,0x06,0x38,0x92,0x04,0x38,0xA0,0x18,
   0x38,0xA1,0x1D,0x38,0xAC,0x03,0x38,0xB4,0x0C,0x38,0xB6,0x81,0x39,0x25,0x14,
   0x39,0x2E,0x43,0x39,0xC1,0x03,0x39,0xC5,0x09,0x39,0xEE,0x40,0x39,0xF2,0x40,
   0x3A,0x80,0x09,0x3A,0x85,0x03,0x3C,0x41,0x80,0x3C,0x42,0x80,0x3C,0x49,0x84,
   0x3C,0x63,0x80,0x3C,0x68,0x06,0x3C,0x81,0x80,0x3C,0x84,0x80,0x3C,0x85,0x06,
   0x3C,0x89,0x80,0x3C,0x8F,0x80,0x3C,0xC6,0x40,0x3D,0x32,0x04,0x3D,0x34,0x81,
   0x3D,0x82,0x80,0x3D,0x84,0x80,0x3D,0x85,0x04,0x3D,0x89,0x05,0x3D,0x8C,0x86,
   0x3D,0x8F,0x80,0x3D,0x99,0x81,0x3D,0xA5,0x82,0x3D,0xA9,0x80,0x3D,0xB0,0x80,
   0x3D,0xC0,0x0D,0x3D,0xC4,0x07,0x3D,0xC5,0x06,0x3D,0xC7,0x81,0x3D,0xC9,0x03,
   0x3D,0xCE,0x07,0x3D,0xD4,0x09,0x3D,0xE3,0x80,0x3E,0x35,0x40,0x3E,0x41,0x03,
   0x3E,0x42,0x83,0x3E,0x43,0x81,0x3E,0x44,0x06,0x3E,0x45,0x06,0x3E,0x4D,0x81,
   0x3E,0x4E,0x85,0x3E,0x4F,0x40,0x3E,0x52,0x80,0x3E,0x63,0x80,0x3E,0x73,0x06,
   0x3E,0x74,0x80,0x3E,0x80,0x13,0x3E,0x85,0x03,0x3E,0x88,0x80,0x3E,0x89,0x80,
   0x3E,0x8E,0x80,0x3E,0x94,0x04,0x3E,0xA0,0x03,0x3E,0xA3,0x09,0x3E,0xA4,0x07,
   0x3E,0xA7,0x82,0x3E,0xA9,0x0E,0x3E,0xAC,0x8E,0x3E,0xAE,0x03,0x3E,0xB2,0x2F,
   0x3E,0xB3,0x0C,0x3E,0xB4,0x0F,0x3E,0xB6,0x83,0x3F,0x20,0x04,0x3F,0x21,0x80,
   0x3F,0x23,0x80,0x3F,0x45,0x80,0x3F,0x4F,0x80,0x40,0x30,0x80,0x40,0x32,0x07,
   0x40,0x35,0x03,0x40,0xA1,0x43,0x40,0xA4,0x80,0x40,0xAC,0x03,0x40,0xB2,0x06,
   0x41,0x23,0x82,0x41,0x25,0x05,0x41,0x2E,0x05,0x41,0x34,0x80,0x41,0x81,0x05,
   0x41,0x85,0x80,0x41,0x89,0x40,0x41,0xEC,0x80,0x41,0xF4,0x80,0x42,0x41,0x80,
   0x42,0x45,0x06,0x42,0x49,0x82,0x42,0x4F,0x85,0x42,0x55,0x80,0x42,0xB3,0x80,
   0x46,0xA5,0x09,0x48,0x22,0x82,0x48,0x29,0x09,0x48,0x2B,0x40,0x48,0x2D,0x03,
   0x48,0x2E,0x09,0x48,0x30,0x80,0x48,0x32,0x45,0x48,0x33,0x84,0x48,0x34,0x80,
   0x48,0x35,0x05,0x48,0x36,0x40,0x48,0x39,0x41,0x48,0x3A,0x82,0x48,0x45,0x04,
   0x48,0x4F,0x05,0x48,0x68,0x07,0x48,0x79,0x41,0x48,0x80,0x3F,0x48,0x85,0x0D,
   0x48,0x89,0x06,0x48,0x8F,0x40,0x48,0xA0,0x32,0x48,0xA1,0x1C,0x48,0xA2,0x80,
   0x48,0xA4,0x82,0x48,0xA5,0x40,0x48,0xA7,0x03,0x48,0xA9,0x81,0x48,0xAA,0x80,
   0x48,0xAC,0x40,0x48,0xAD,0x80,0x48,0xAE,0x08,0x48,0xB4,0x0C,0x48,0xB6,0x81,
   0x48,0xE5,0x04,0x49,0x05,0x81,0x49,0x21,0x05,0x49,0x24,0x80,0x49,0x25,0x22,
   0x49,0x2D,0x81,0x49,0x2E,0x05,0x49,0x30,0x80,0x49,0x31,0x80,0x49,0x33,0x05,
   0x49,0x36,0x03,0x49,0x38,0x40,0x49,0x65,0x40,0x49,0x8F,0x41,0x49,0xAF,0x80,
   0x49,0xC1,0x03,0x49,0xC5,0x0C,0x49,0xC9,0x04,0x49,0xE2,0x83,0x49,0xE3,0x05,
   0x49,0xE9,0x03,0x49,0xEC,0x81,0x49,0xF3,0x05,0x49,0xF4,0x09,0x49,0xF5,0x1F,
   0x49,0xF6,0x03,0x49,0xFA,0x80,0x4A,0x45,0x08,0x4A,0x49,0x0F,0x4A,0x60,0x06,
   0x4A,0x69,0x40,0x4A,0x80,0x09,0x4A,0x85,0x05,0x4A,0x89,0x05,0x4A,0x8F,0x41,
   0x4A,0xAD,0x80,0x4A,0xAE,0x04,0x4A,0xB3,0x80,0x4A,0xB9,0x80,0x4C,0x2D,0x80,
   0x4C,0x2E,0x40,0x4C,0x32,0x45,0x4C,0xA0,0x09,0x4C,0xB4,0x06,0x4D,0x01,0x03,
   0x4D,0x05,0x83,0x4D,0x09,0x80,0x4D,0x23,0x80,0x4D,0x25,0x0D,0x4D,0x2D,0x83,
   0x4D,0x2E,0x04,0x4D,0xC1,0x80,0x4D,0xC5,0x03,0x4D,0xEE,0x08,0x4D,0xF2,0x40,
   0x4D,0xF4,0x42,0x4D,0xF5,0x81,0x4E,0x61,0x0A,0x4E,0x65,0x10,0x4E,0x69,0x06,
   0x4E,0x6F,0x05,0x4E,0x81,0x04,0x4E,0x92,0x80,0x4E,0xC9,0x40,0x4F,0x41,0x80,
   0x50,0x26,0x80,0x50,0x29,0x06,0x50,0x2D,0x40,0x50,0x32,0x42,0x50,0xA0,0x3F,
   0x50,0xA1,0x4C,0x50,0xAC,0x05,0x51,0x05,0x86,0x51,0x09,0x0F,0x51,0x15,0x82,
   0x51,0x25,0x12,0x51,0x2D,0x80,0x51,0x34,0x40,0x51,0xEC,0x80,0x51,0xF4,0x43,
   0x52,0x41,0x04,0x52,0x45,0x05,0x52,0x49,0x80,0x52,0x4F,0x81,0x52,0x55,0x81,
   0x52,0x85,0x7C,0x52,0x8F,0x40,0x52,0xAE,0x40,0x52,0xB2,0x03,0x54,0x29,0x40,
   0x54,0x32,0x03,0x54,0x4F,0x81,0x54,0x68,0x10,0x54,0x80,0x07,0x54,0x81,0x40,
   0x54,0x85,0x08,0x54,0x89,0x41,0x54,0xA0,0x07,0x54,0xAC,0x03,0x54,0xB4,0x04,
   0x54,0xC6,0x03,0x54,0xCF,0x80,0x54,0xEE,0x80,0x55,0x27,0x80,0x55,0x28,0x80,
   0x55,0x2C,0x10,0x55,0x2E,0x06,0x55,0x33,0x40,0x55,0x81,0x05,0x55,0x85,0x05,
   0x55,0x8D,0x80,0x55,0x8F,0x40,0x55,0x94,0x67,0x55,0xA1,0x80,0x55,0xA5,0x08,
   0x55,0xAF,0x03,0x55,0xC3,0x80,0x55,0xC5,0x06,0x55,0xC7,0x80,0x55,0xCE,0x80,
   0x55,0xCF,0x80,0x55,0xD4,0x03,0x56,0x09,0x40,0x56,0x0F,0x80,0x56,0x41,0x40,
   0x56,0x43,0x03,0x56,0x44,0x08,0x56,0x45,0x0B,0x56,0x47,0x04,0x56,0x49,0x05,
   0x56,0x4E,0x06,0x56,0x52,0x04,0x56,0x53,0x40,0x56,0x54,0x06,0x56,0x6B,0x80,
   0x56,0x73,0x0A,0x56,0x85,0x09,0x56,0x88,0x04,0x56,0x89,0x06,0x56,0x94,0x40,
   0x56,0xC1,0x04,0x57,0x41,0x80,0x57,0x5A,0x80,0x58,0x23,0x40,0x58,0x24,0x80,
   0x58,0x29,0x05,0x58,0x2C,0x06,0x58,0x32,0x05,0x58,0x34,0x41,0x58,0xA1,0x06,
   0x59,0x25,0x0C,0x59,0x26,0x80,0x59,0x27,0x06,0x59,0x2C,0x03,0x59,0x2E,0x44,
   0x59,0xF2,0x03,0x5D,0x2C,0x80,0x64,0x32,0x44,0x64,0xB2,0x43,0x68,0x32,0x46,
   0x69,0x25,0x47};
const unsigned int french_entries = 861;
/*
 *  Trigram frequency tables for acna.c.
 *  Generated from : *.nam
 *  Written to file : acna.c
 *  Created on : 08/21/01 at 16:43:10
 */
const unsigned char far german[] = {
   0x00,0x2C,0x03,0x00,0x41,0x09,0x00,0x45,0x15,0x00,0x49,0x05,0x00,0x4C,0x08,
   0x00,0x4F,0x0B,0x00,0x52,0x14,0x00,0x55,0x0A,0x00,0x85,0x0C,0x00,0x89,0x06,
   0x00,0x8F,0x05,0x00,0xAC,0x03,0x00,0xAE,0x04,0x00,0xB2,0x05,0x00,0xC1,0x06,
   0x00,0xC5,0x09,0x00,0xC9,0x04,0x00,0xCF,0x05,0x00,0xD2,0x0B,0x00,0xE1,0x05,
   0x00,0xE5,0x0D,0x00,0xE9,0x03,0x00,0xEF,0x07,0x00,0xF2,0x0E,0x00,0xF5,0x03,
   0x01,0x01,0x19,0x01,0x05,0x1D,0x01,0x09,0x07,0x01,0x0F,0x10,0x01,0x15,0x0A,
   0x01,0x61,0x0E,0x01,0x65,0x08,0x01,0x69,0x0A,0x01,0x6C,0x09,0x01,0x6E,0x05,
   0x01,0x6F,0x0B,0x01,0x72,0x0B,0x01,0x75,0x08,0x01,0x85,0x0F,0x01,0x89,0x0A,
   0x01,0x8F,0x06,0x01,0x95,0x05,0x01,0xA5,0x0D,0x01,0xC5,0x09,0x01,0xC9,0x04,
   0x01,0xCF,0x03,0x02,0x01,0x06,0x02,0x0F,0x06,0x02,0x12,0x04,0x02,0x41,0x0A,
   0x02,0x45,0x0D,0x02,0x49,0x08,0x02,0x4F,0x10,0x02,0x55,0x08,0x02,0x61,0x08,
   0x02,0x63,0x30,0x02,0x65,0x0E,0x02,0x68,0x09,0x02,0x69,0x06,0x02,0x6F,0x04,
   0x02,0x70,0x07,0x02,0x74,0x2A,0x02,0x75,0x06,0x02,0x85,0x06,0x02,0x88,0x05,
   0x02,0x89,0x05,0x02,0x92,0x06,0x02,0xC1,0x14,0x02,0xC5,0x06,0x02,0xCF,0x05,
   0x02,0xE1,0x07,0x02,0xE5,0x1A,0x02,0xE9,0x10,0x02,0xEF,0x07,0x02,0xF5,0x02,
   0x03,0x45,0x04,0x03,0x49,0x05,0x04,0x45,0x03,0x04,0x49,0x40,0x04,0x4E,0x80,
   0x04,0x68,0x0F,0x04,0x6B,0x08,0x04,0x72,0x80,0x04,0x75,0x80,0x04,0x80,0x04,
   0x04,0x81,0x40,0x04,0x85,0x03,0x04,0x8F,0x80,0x04,0x93,0x80,0x04,0xC5,0x40,
   0x04,0xC9,0x80,0x04,0xD4,0x40,0x04,0xE1,0x80,0x04,0xE5,0x06,0x04,0xEF,0x80,
   0x05,0x05,0x40,0x05,0x2B,0x80,0x05,0x2C,0x80,0x05,0x36,0x80,0x05,0x3A,0x80,
   0x05,0x45,0x80,0x05,0x65,0x03,0x05,0x6C,0x40,0x05,0x75,0x40,0x05,0x80,0x03,
   0x05,0x81,0x40,0x05,0x82,0x81,0x05,0x8C,0x06,0x05,0x94,0x04,0x05,0xA5,0x42,
   0x05,0xAD,0x04,0x05,0xB5,0x80,0x05,0xC0,0x2D,0x05,0xC1,0x80,0x05,0xC4,0x17,
   0x05,0xC7,0x0A,0x05,0xC8,0x81,0x05,0xCA,0x40,0x05,0xCE,0x16,0x05,0xCF,0x81,
   0x05,0xD0,0x80,0x05,0xD2,0x80,0x05,0xD5,0x40,0x06,0x09,0x40,0x06,0x10,0x04,
   0x06,0x44,0x05,0x06,0x47,0x03,0x06,0x4B,0x03,0x06,0x4E,0x81,0x06,0x50,0x40,
   0x06,0x54,0x09,0x06,0x60,0x04,0x06,0x69,0x80,0x06,0x70,0x80,0x06,0x73,0x06,
   0x06,0x74,0x03,0x06,0x8B,0x40,0x06,0x8F,0x40,0x06,0x93,0x80,0x06,0x94,0x04,
   0x06,0x95,0x80,0x06,0xA2,0x04,0x06,0xB3,0x07,0x07,0x20,0x80,0x07,0x25,0x41,
   0x07,0x5A,0x80,0x08,0x23,0x09,0x08,0x45,0x03,0x08,0x49,0x40,0x08,0xA3,0x06,
   0x08,0xAC,0x06,0x08,0xAE,0x07,0x08,0xB2,0x3F,0x08,0xB9,0x80,0x09,0x23,0x80,
   0x09,0x24,0x80,0x09,0x2C,0x80,0x09,0x32,0x80,0x09,0x34,0x80,0x09,0x81,0x03,
   0x09,0x85,0x03,0x09,0xEB,0x80,0x09,0xED,0x80,0x09,0xF2,0x03,0x09,0xF5,0x80,
   0x09,0xF9,0x80,0x09,0xFA,0x80,0x0A,0x41,0x07,0x0A,0x45,0x06,0x0A,0x4F,0x06,
   0x0A,0xA5,0x81,0x0A,0xAA,0x80,0x0A,0xB2,0x0A,0x0B,0x2C,0x80,0x0C,0x29,0x40,
   0x0C,0x2D,0x40,0x0C,0x30,0x80,0x0C,0x32,0x80,0x0C,0xA4,0x80,0x0C,0xAC,0x40,
   0x0C,0xB2,0x40,0x0D,0x00,0x21,0x0D,0x01,0x08,0x0D,0x05,0x1B,0x0D,0x09,0x06,
   0x0D,0x0B,0x42,0x0D,0x0C,0x06,0x0D,0x0D,0x08,0x0D,0x0F,0x87,0x0D,0x12,0x84,
   0x0D,0x13,0x02,0x0D,0x15,0x09,0x0D,0x17,0x84,0x0D,0x23,0x40,0x0D,0x34,0x80,
   0x0D,0x60,0x09,0x0D,0x65,0x0B,0x0D,0x81,0x80,0x0D,0x89,0x80,0x0D,0x8F,0x80,
   0x0D,0xC1,0x40,0x0D,0xE2,0x40,0x0D,0xE3,0x40,0x0D,0xEC,0x80,0x0D,0xF0,0x80,
   0x0D,0xF4,0x40,0x0D,0xF6,0x80,0x0E,0x55,0x80,0x0E,0xB0,0x40,0x0F,0x45,0x40,
   0x10,0x2E,0x81,0x10,0x33,0x40,0x10,0x4F,0x40,0x10,0x89,0x40,0x10,0xA5,0x80,
   0x10,0xAA,0x80,0x10,0xAC,0x07,0x10,0xAE,0x0E,0x10,0xB2,0x25,0x10,0xB4,0x80,
   0x10,0xB9,0x80,0x11,0x22,0x80,0x11,0x23,0x80,0x11,0x25,0x82,0x11,0x2C,0x80,
   0x11,0x2D,0x80,0x11,0x85,0x45,0x11,0x8C,0x40,0x11,0x8F,0x40,0x11,0xE2,0x80,
   0x11,0xF2,0x03,0x11,0xF5,0x80,0x12,0xA5,0x80,0x12,0xA7,0x80,0x12,0xB2,0x80,
   0x13,0x49,0x40,0x14,0x24,0x41,0x14,0x26,0x80,0x14,0x27,0x80,0x14,0x2B,0x80,
   0x14,0x2E,0x40,0x14,0x33,0x80,0x14,0x45,0x0A,0x14,0x68,0x06,0x14,0x6F,0x80,
   0x14,0x85,0x09,0x14,0x87,0x80,0x14,0x97,0x80,0x14,0xA8,0x40,0x14,0xB6,0x80,
   0x14,0xC9,0x80,0x14,0xE5,0x08,0x15,0x09,0x80,0x15,0x2A,0x80,0x15,0x2C,0x04,
   0x15,0x2D,0x05,0x15,0x33,0x10,0x15,0x80,0x26,0x15,0x85,0x06,0x15,0x8C,0x10,
   0x15,0x8D,0x06,0x15,0x8F,0x80,0x15,0x93,0x06,0x15,0x94,0x05,0x15,0x96,0x80,
   0x15,0xA1,0x06,0x15,0xA5,0x05,0x15,0xC0,0x2E,0x15,0xC4,0x08,0x15,0xC7,0x08,
   0x15,0xC8,0x08,0x15,0xCF,0x80,0x15,0xD3,0x0D,0x15,0xD4,0x05,0x15,0xDA,0x04,
   0x16,0x01,0x80,0x16,0x05,0x41,0x16,0x0C,0x80,0x16,0x35,0x80,0x16,0x40,0x3F,
   0x16,0x42,0x08,0x16,0x45,0x06,0x16,0x47,0x28,0x16,0x49,0x06,0x16,0x4B,0x04,
   0x16,0x4C,0x0A,0x16,0x4D,0x0D,0x16,0x4E,0x07,0x16,0x53,0x19,0x16,0x54,0x18,
   0x16,0x57,0x03,0x16,0x60,0x07,0x16,0x63,0x04,0x16,0x64,0x80,0x16,0x65,0x03,
   0x16,0x6F,0x40,0x16,0x70,0x40,0x16,0x73,0x0A,0x16,0x74,0x0A,0x16,0x85,0x04,
   0x16,0x94,0x09,0x16,0xA3,0x80,0x16,0xB2,0x80,0x16,0xC1,0x40,0x16,0xC5,0x03,
   0x16,0xEF,0x80,0x16,0xF0,0x80,0x17,0x21,0x80,0x17,0x25,0x45,0x17,0x2E,0x80,
   0x17,0x2F,0x80,0x17,0x32,0x80,0x17,0x45,0x40,0x18,0x24,0x80,0x18,0x25,0x80,
   0x18,0x28,0x81,0x18,0x29,0x80,0x18,0x2D,0x80,0x18,0x35,0x80,0x18,0xA5,0x80,
   0x18,0xA6,0x80,0x18,0xAC,0x09,0x18,0xB2,0x0C,0x18,0xB4,0x80,0x18,0xC0,0x0D,
   0x18,0xC5,0x06,0x19,0x24,0x80,0x19,0x33,0x81,0x19,0x85,0x03,0x19,0xE7,0x80,
   0x19,0xE8,0x80,0x19,0xEE,0x40,0x19,0xF5,0x80,0x1A,0x41,0x82,0x1A,0x45,0x83,
   0x1A,0x49,0x04,0x1A,0xB3,0x40,0x1C,0x29,0x80,0x1C,0x81,0x80,0x1C,0x85,0x40,
   0x1C,0xA0,0x05,0x1C,0xAC,0x07,0x1C,0xAE,0x0C,0x1C,0xB2,0x37,0x1C,0xB3,0x03,
   0x1C,0xE9,0x40,0x1D,0x32,0x80,0x1D,0x33,0x40,0x1D,0x85,0x46,0x1D,0x8F,0x80,
   0x1D,0xC5,0x41,0x1D,0xCF,0x40,0x1D,0xE8,0x80,0x1D,0xED,0x80,0x1E,0x41,0x05,
   0x1E,0x4F,0x83,0x1E,0x55,0x03,0x1E,0x6F,0x40,0x1E,0xA5,0x80,0x1E,0xA7,0x80,
   0x1E,0xA8,0x80,0x1E,0xA9,0x80,0x1E,0xB2,0x40,0x20,0x2C,0x04,0x20,0x2D,0x04,
   0x20,0x32,0x0C,0x20,0x35,0x07,0x20,0x39,0x80,0x20,0xA0,0x03,0x20,0xA3,0x80,
   0x20,0xA4,0x02,0x20,0xA7,0x80,0x20,0xAC,0x0C,0x20,0xAE,0x07,0x20,0xAF,0x80,
   0x20,0xB2,0x1C,0x21,0x22,0x80,0x21,0x23,0x80,0x21,0x24,0x80,0x21,0x2B,0x40,
   0x21,0x2C,0x04,0x21,0x2E,0x04,0x21,0x36,0x80,0x21,0xC0,0x04,0x21,0xC5,0x05,
   0x21,0xE4,0x80,0x21,0xE5,0x05,0x21,0xE7,0x80,0x21,0xEB,0x80,0x21,0xEC,0x09,
   0x22,0x45,0x03,0x22,0x47,0x80,0x22,0x80,0x03,0x22,0xAB,0x80,0x22,0xB2,0x03,
   0x24,0x61,0x80,0x24,0x65,0x40,0x24,0x68,0x12,0x24,0x6F,0x80,0x24,0x85,0x05,
   0x24,0x93,0x80,0x24,0x94,0x40,0x24,0xA3,0x80,0x24,0xA4,0x04,0x24,0xA6,0x02,
   0x24,0xA7,0x04,0x24,0xAC,0x03,0x24,0xB2,0x06,0x24,0xC6,0x03,0x24,0xE0,0x07,
   0x24,0xE9,0x40,0x25,0x81,0x80,0x25,0x93,0x81,0x25,0x96,0x80,0x25,0xAD,0x03,
   0x25,0xAE,0x80,0x25,0xAF,0x80,0x25,0xB5,0x40,0x25,0xC0,0x15,0x25,0xC3,0x80,
   0x25,0xC4,0x09,0x25,0xC5,0x09,0x25,0xC7,0x29,0x25,0xCB,0x0C,0x25,0xD4,0x03,
   0x26,0x10,0x05,0x26,0x4F,0x80,0x26,0x54,0x40,0x26,0x61,0x80,0x26,0x65,0x07,
   0x26,0x67,0x80,0x26,0x73,0x08,0x26,0x74,0x08,0x26,0x81,0x40,0x26,0x85,0x03,
   0x26,0x8B,0x80,0x26,0x94,0x06,0x26,0xE1,0x80,0x28,0x23,0x80,0x28,0x2B,0x80,
   0x28,0x2C,0x80,0x28,0x2D,0x80,0x28,0xB2,0x81,0x28,0xB3,0x80,0x28,0xB4,0x80,
   0x29,0xE8,0x80,0x29,0xEE,0x80,0x29,0xF5,0x80,0x2C,0x25,0x80,0x2C,0x27,0x80,
   0x2C,0x28,0x80,0x2C,0x2B,0x80,0x2C,0x2C,0x03,0x2C,0x32,0x03,0x2C,0xA0,0x0D,
   0x2C,0xA8,0x40,0x2C,0xAC,0x06,0x2C,0xAE,0x05,0x2C,0xB2,0x13,0x2C,0xB9,0x80,
   0x2D,0x24,0x80,0x2D,0x2D,0x80,0x2D,0x34,0x80,0x2D,0x3A,0x80,0x2D,0x45,0x80,
   0x2D,0x85,0x07,0x2D,0xA1,0x46,0x2D,0xC1,0x81,0x2D,0xC9,0x81,0x2D,0xCF,0x82,
   0x2D,0xE2,0x80,0x2D,0xE3,0x80,0x2D,0xE5,0x83,0x2D,0xE7,0x80,0x2D,0xEE,0x81,
   0x2D,0xF5,0x80,0x2D,0xF6,0x80,0x2E,0x45,0x83,0x2E,0x49,0x81,0x2E,0x55,0x82,
   0x2E,0xA2,0x40,0x2E,0xA3,0x80,0x2E,0xA5,0x82,0x2E,0xA7,0x80,0x2E,0xA9,0x80,
   0x2E,0xAB,0x80,0x2E,0xB2,0x80,0x2E,0xB4,0x80,0x30,0x24,0x40,0x30,0x2C,0x80,
   0x30,0x2D,0x03,0x30,0x2E,0x09,0x30,0x30,0x40,0x30,0x35,0x04,0x30,0x36,0x80,
   0x30,0x45,0x05,0x30,0x80,0x09,0x30,0x85,0x08,0x30,0x8F,0x40,0x30,0xA0,0x0F,
   0x30,0xA9,0x0B,0x30,0xAD,0x03,0x30,0xAE,0x08,0x30,0xAF,0x80,0x30,0xB0,0x80,
   0x30,0xB2,0x68,0x30,0xB7,0x80,0x31,0x22,0x80,0x31,0x24,0x80,0x31,0x25,0x03,
   0x31,0x2E,0x1A,0x31,0x30,0x80,0x31,0x37,0x80,0x31,0x65,0x03,0x31,0x80,0x0B,
   0x31,0x85,0x0E,0x31,0x87,0x80,0x31,0x99,0x40,0x31,0xA1,0x06,0x31,0xE2,0x80,
   0x31,0xEE,0x81,0x31,0xF5,0x80,0x31,0xF6,0x80,0x32,0x65,0x43,0x32,0x85,0x05,
   0x32,0xC9,0x40,0x34,0x22,0x80,0x34,0x2D,0x80,0x34,0x2E,0x7F,0x34,0x3A,0x80,
   0x34,0x45,0x06,0x34,0xA1,0x80,0x34,0xA9,0x06,0x34,0xAC,0x05,0x34,0xAF,0x40,
   0x34,0xB2,0x14,0x34,0xB9,0x03,0x35,0x23,0x81,0x35,0x27,0x40,0x35,0x2D,0x40,
   0x35,0x85,0x41,0x35,0xA0,0x02,0x35,0xA5,0x0B,0x35,0xE4,0x80,0x35,0xE8,0x80,
   0x35,0xED,0x80,0x35,0xEF,0x80,0x35,0xF0,0x80,0x35,0xF4,0x81,0x36,0x01,0x40,
   0x38,0x24,0x80,0x38,0x26,0x80,0x38,0x2B,0x40,0x38,0x65,0x40,0x38,0x6B,0x40,
   0x38,0x80,0x09,0x38,0x85,0x1B,0x38,0xAE,0x06,0x38,0xB2,0x64,0x38,0xB5,0x82,
   0x38,0xB7,0x82,0x38,0xE0,0x16,0x38,0xE5,0x1C,0x38,0xEC,0x04,0x39,0x01,0x06,
   0x39,0x34,0x80,0x39,0x65,0x09,0x39,0xC0,0x13,0x39,0xC5,0x06,0x39,0xE2,0x80,
   0x39,0xE3,0x40,0x39,0xF7,0x80,0x3A,0x60,0x06,0x3A,0x65,0x42,0x3A,0x74,0x08,
   0x3A,0x7A,0x80,0x3A,0x81,0x40,0x3A,0x85,0x04,0x3A,0x87,0x40,0x3A,0xA7,0x80,
   0x3A,0xAC,0x80,0x3C,0x41,0x80,0x3C,0x45,0x04,0x3C,0x81,0x80,0x3C,0x87,0x80,
   0x3C,0x8F,0x40,0x3C,0xAC,0x04,0x3C,0xC6,0x0A,0x3C,0xD3,0x80,0x3C,0xE9,0x80,
   0x3C,0xEF,0x80,0x3C,0xF5,0x40,0x3D,0x2B,0x40,0x3D,0x33,0x40,0x3D,0x45,0x80,
   0x3D,0x6F,0x40,0x3D,0x84,0x09,0x3D,0x87,0x80,0x3D,0x88,0x80,0x3D,0x93,0x80,
   0x3D,0x94,0x03,0x3D,0xA5,0x40,0x3D,0xA6,0x80,0x3D,0xAB,0x80,0x3D,0xAF,0x80,
   0x3D,0xB2,0x80,0x3D,0xB3,0x80,0x3D,0xC3,0x80,0x3D,0xC4,0x81,0x3D,0xD5,0x80,
   0x3D,0xE2,0x80,0x3D,0xE4,0x80,0x3D,0xE5,0x80,0x3E,0x01,0x80,0x3E,0x09,0x80,
   0x3E,0x10,0x04,0x3E,0x41,0x80,0x3E,0x47,0x03,0x3E,0x4C,0x80,0x3E,0x4E,0x04,
   0x3E,0x4F,0x40,0x3E,0x51,0x80,0x3E,0x53,0x03,0x3E,0x5A,0x80,0x3E,0x65,0x03,
   0x3E,0x68,0x80,0x3E,0x73,0x06,0x3E,0x74,0x05,0x3E,0x88,0x05,0x3E,0x93,0x80,
   0x3E,0x94,0x05,0x3E,0xA3,0x80,0x3E,0xA7,0x80,0x3E,0xE0,0x80,0x3E,0xE1,0x40,
   0x3E,0xE3,0x80,0x3F,0x25,0x40,0x3F,0x34,0x80,0x40,0x25,0x80,0x40,0x30,0x40,
   0x40,0xA1,0x80,0x40,0xA3,0x80,0x40,0xA4,0x80,0x40,0xAB,0x80,0x40,0xAC,0x03,
   0x40,0xAD,0x80,0x40,0xAE,0x03,0x40,0xB0,0x80,0x40,0xB2,0x07,0x41,0x09,0x80,
   0x41,0x0C,0x80,0x41,0x23,0x80,0x41,0x24,0x80,0x41,0x2B,0x40,0x41,0x2C,0x80,
   0x41,0x33,0x80,0x41,0x34,0x81,0x41,0x81,0x80,0x41,0x85,0x03,0x41,0xEE,0x80,
   0x41,0xEF,0x80,0x41,0xF5,0x80,0x41,0xF7,0x80,0x42,0x05,0x07,0x42,0x41,0x81,
   0x42,0x65,0x40,0x42,0xAC,0x80,0x42,0xB3,0x40,0x42,0xB4,0x80,0x43,0x22,0x80,
   0x48,0x2C,0x40,0x48,0x2E,0x09,0x48,0x33,0x03,0x48,0x35,0x05,0x48,0x36,0x80,
   0x48,0x45,0x07,0x48,0x94,0x43,0x48,0x95,0x40,0x48,0xA9,0x0E,0x48,0xAE,0x0A,
   0x48,0xB2,0x43,0x48,0xB7,0x80,0x48,0xB9,0x81,0x48,0xBA,0x80,0x48,0xC0,0x02,
   0x48,0xC1,0x40,0x48,0xE5,0x12,0x49,0x23,0x08,0x49,0x25,0x07,0x49,0x2E,0x0B,
   0x49,0x34,0x81,0x49,0x3A,0x80,0x49,0x69,0x40,0x49,0x6B,0x80,0x49,0x89,0x05,
   0x49,0xA1,0x0E,0x49,0xA2,0x80,0x49,0xAF,0x40,0x49,0xE6,0x40,0x49,0xE7,0x81,
   0x49,0xED,0x07,0x49,0xF3,0x06,0x49,0xF4,0x04,0x49,0xF7,0x80,0x49,0xF9,0x80,
   0x49,0xFA,0x80,0x4A,0x60,0x0E,0x4A,0x63,0x03,0x4A,0x65,0x41,0x4A,0x66,0x80,
   0x4A,0x74,0x09,0x4A,0x75,0x40,0x4A,0x79,0x40,0x4A,0x80,0x15,0x4A,0x85,0x04,
   0x4A,0xA3,0x81,0x4A,0xA5,0x03,0x4A,0xAC,0x40,0x4A,0xAD,0x03,0x4A,0xAE,0x03,
   0x4A,0xB4,0x80,0x4A,0xB6,0x80,0x4A,0xB9,0x80,0x4B,0x2B,0x80,0x4B,0x2E,0x80,
   0x4B,0x33,0x80,0x4B,0x34,0x80,0x4B,0x49,0x40,0x4B,0x4B,0x40,0x4B,0x4F,0x40,
   0x4B,0x59,0x40,0x4C,0x23,0x81,0x4C,0x24,0x80,0x4C,0x25,0x80,0x4C,0x27,0x80,
   0x4C,0x29,0x80,0x4C,0x2B,0x80,0x4C,0x2C,0x81,0x4C,0x2D,0x80,0x4C,0x35,0x80,
   0x4C,0x68,0x3F,0x4C,0x75,0x80,0x4C,0xA0,0x04,0x4C,0xA1,0x80,0x4C,0xA9,0x83,
   0x4C,0xAC,0x09,0x4C,0xAE,0x12,0x4C,0xB2,0x0E,0x4C,0xB5,0x80,0x4C,0xB6,0x80,
   0x4C,0xB9,0x80,0x4C,0xE5,0x40,0x4D,0x05,0x06,0x4D,0x09,0x81,0x4D,0x15,0x83,
   0x4D,0x17,0x80,0x4D,0x24,0x80,0x4D,0x2E,0x06,0x4D,0x32,0x80,0x4D,0x85,0x46,
   0x4D,0xAF,0x80,0x4D,0xC5,0x43,0x4D,0xC9,0x80,0x4D,0xE2,0x80,0x4D,0xED,0x80,
   0x4D,0xEE,0x04,0x4D,0xF3,0x80,0x4D,0xF5,0x80,0x4D,0xF7,0x80,0x4E,0x01,0x81,
   0x4E,0x60,0x0D,0x4E,0x65,0x0B,0x4E,0x6F,0x40,0x4E,0x80,0x0C,0x4E,0x81,0x0B,
   0x4E,0x85,0x2D,0x4E,0x8F,0x08,0x4E,0x92,0x11,0x4E,0x95,0x85,0x4E,0xA2,0x80,
   0x4E,0xA6,0x80,0x4E,0xA7,0x80,0x4E,0xA8,0x40,0x4E,0xA9,0x80,0x4E,0xAB,0x80,
   0x4E,0xB0,0x80,0x4E,0xB4,0x80,0x4E,0xE1,0x80,0x50,0x23,0x80,0x50,0x28,0x80,
   0x50,0x29,0x80,0x50,0x2B,0x40,0x50,0xA3,0x80,0x50,0xA7,0x81,0x50,0xA9,0x0C,
   0x50,0xAA,0x80,0x50,0xAC,0x06,0x50,0xAE,0x0F,0x50,0xB2,0x2A,0x50,0xB6,0x80,
   0x50,0xB9,0x80,0x51,0x05,0x0A,0x51,0x07,0x40,0x51,0x19,0x80,0x51,0x32,0x80,
   0x51,0x34,0x80,0x51,0x85,0x42,0x51,0xA1,0x07,0x51,0xAF,0x40,0x51,0xC1,0x40,
   0x51,0xC5,0x44,0x51,0xE2,0x80,0x51,0xE8,0x80,0x51,0xE9,0x80,0x51,0xEA,0x80,
   0x51,0xEB,0x40,0x51,0xED,0x80,0x51,0xEE,0x03,0x51,0xEF,0x80,0x52,0x41,0x05,
   0x52,0x45,0x04,0x52,0x49,0x03,0x52,0x4F,0x09,0x52,0x59,0x80,0x52,0x60,0x05,
   0x52,0x63,0x05,0x52,0x75,0x80,0x52,0x85,0x0D,0x52,0x93,0x03,0x52,0xA4,0x80,
   0x52,0xAB,0x80,0x52,0xAC,0x80,0x52,0xB2,0x81,0x53,0x45,0x09,0x54,0x32,0x40,
   0x54,0x45,0x06,0x54,0x61,0x40,0x54,0x68,0x05,0x54,0x89,0x80,0x54,0x8F,0x80,
   0x54,0xA4,0x80,0x54,0xA6,0x80,0x54,0xA8,0x02,0x54,0xAB,0x40,0x54,0xAD,0x80,
   0x54,0xB2,0x06,0x54,0xC6,0x03,0x54,0xCE,0x80,0x54,0xEC,0x80,0x54,0xEF,0x80,
   0x55,0x24,0x80,0x55,0x2E,0x80,0x55,0x30,0x80,0x55,0x32,0x40,0x55,0x33,0x44,
   0x55,0x4F,0x80,0x55,0x81,0x40,0x55,0x85,0x41,0x55,0x8B,0x40,0x55,0xA0,0x05,
   0x55,0xAF,0x80,0x55,0xC4,0x09,0x55,0xC7,0x03,0x56,0x12,0x80,0x56,0x13,0x80,
   0x56,0x43,0x80,0x56,0x47,0x0A,0x56,0x5A,0x80,0x56,0x60,0x07,0x56,0x61,0x80,
   0x56,0x65,0x05,0x56,0x73,0x04,0x56,0x8B,0x80,0x56,0x94,0x03,0x56,0xC9,0x80,
   0x58,0x23,0x80,0x58,0x24,0x80,0x58,0x2E,0x93,0x58,0x32,0x80,0x58,0x33,0x40,
   0x58,0xAE,0x03,0x58,0xB2,0x09,0x58,0xB4,0x80,0x58,0xB5,0x80,0x59,0x25,0x80,
   0x59,0x34,0x40,0x59,0x89,0x80,0x59,0xE5,0x80,0x59,0xEE,0x82,0x59,0xF2,0x80,
   0x59,0xF5,0x80,0x59,0xF9,0x80,0x5A,0x4F,0x80,0x5C,0x28,0x80,0x5C,0x2C,0x04,
   0x5C,0x33,0x80,0x5C,0x85,0x40,0x5C,0xA5,0x80,0x5C,0xAC,0x03,0x5C,0xAD,0x80,
   0x5C,0xAE,0x04,0x5C,0xB2,0x04,0x5C,0xB3,0x84,0x5C,0xB4,0x81,0x5C,0xB5,0x80,
   0x5C,0xB9,0x80,0x5C,0xC5,0x40,0x5D,0x01,0x80,0x5D,0x2B,0x80,0x5D,0x2C,0x84,
   0x5D,0x2E,0x07,0x5D,0xEF,0x80,0x64,0x2E,0x40,0x64,0x41,0x80,0x64,0x6B,0x80,
   0x64,0xB2,0x48,0x64,0xB3,0x80,0x64,0xE1,0x80,0x65,0x2E,0x40,0x65,0x4F,0x80,
   0x65,0x81,0x80,0x65,0xC9,0x80,0x66,0x88,0x80,0x66,0x92,0x80,0x66,0x93,0x80,
   0x68,0x22,0x80,0x68,0x23,0x80,0x68,0x27,0x80,0x68,0xA9,0x80,0x68,0xAC,0x06,
   0x68,0xAE,0x04,0x68,0xB0,0x40,0x68,0xB2,0x47,0x68,0xB4,0x80,0x68,0xB5,0x80,
   0x69,0x23,0x80,0x69,0x25,0x82,0x69,0x2C,0x80,0x69,0x2D,0x81,0x69,0x65,0x40,
   0x69,0xC5,0x40,0x69,0xEC,0x40,0x6A,0xAE,0x40,0x6A,0xB3,0x40,0x6A,0xB7,0x80,
   0x6A,0xE9,0x80,0x6B,0x41,0x40};
const unsigned int german_entries = 947;
/*
 *  Trigram frequency tables for acna.c.
 *  Generated from : *.nam
 *  Written to file : acna.c
 *  Created on : 08/21/01 at 16:43:10
 */
const unsigned char far irish[] = {
   0x00,0x41,0x05,0x00,0x52,0x0D,0x00,0x55,0x06,0x00,0x61,0x21,0x00,0x68,0x04,
   0x00,0x6C,0x12,0x00,0x6F,0x23,0x00,0x72,0x0D,0x00,0x75,0x09,0x00,0x81,0x07,
   0x00,0x85,0x11,0x00,0x8F,0x11,0x00,0x95,0x06,0x00,0xC1,0x0B,0x00,0xC5,0x06,
   0x00,0xC9,0x0D,0x00,0xCC,0x0A,0x00,0xE1,0x0E,0x00,0xE5,0x05,0x00,0xE9,0x0A,
   0x00,0xEC,0x08,0x00,0xEF,0x07,0x00,0xF2,0x08,0x00,0xF5,0x05,0x01,0x01,0x15,
   0x01,0x05,0x0C,0x01,0x09,0x05,0x01,0x0F,0x08,0x01,0x65,0x0B,0x01,0x69,0x0B,
   0x01,0x81,0x12,0x01,0x85,0x0A,0x01,0x8F,0x08,0x01,0x95,0x05,0x01,0xA1,0x2B,
   0x01,0xA3,0x3F,0x01,0xA5,0x0A,0x01,0xA9,0x0A,0x01,0xAF,0x0F,0x01,0xB5,0x13,
   0x01,0xC1,0x06,0x01,0xC5,0x05,0x01,0xCF,0x03,0x01,0xEC,0x03,0x01,0xEE,0x03,
   0x01,0xEF,0x40,0x01,0xF2,0x04,0x02,0x08,0x04,0x02,0x15,0x03,0x02,0x35,0x06,
   0x02,0x41,0x0C,0x02,0x65,0x03,0x02,0x68,0x15,0x02,0x69,0x03,0x02,0x74,0x09,
   0x02,0x75,0x04,0x02,0x81,0x05,0x02,0x85,0x04,0x02,0x89,0x06,0x02,0x95,0x03,
   0x02,0xC1,0x08,0x04,0x4E,0x80,0x04,0x52,0x80,0x04,0x61,0x80,0x04,0x63,0x80,
   0x04,0x64,0x81,0x04,0x69,0x81,0x04,0x6B,0x06,0x04,0x6F,0x40,0x04,0x70,0x80,
   0x04,0x75,0x80,0x04,0x76,0x80,0x04,0x77,0x80,0x04,0x84,0x04,0x04,0x85,0x42,
   0x04,0x89,0x80,0x04,0x8C,0x80,0x04,0x8F,0x40,0x04,0x99,0x45,0x04,0xAC,0x40,
   0x04,0xAD,0x80,0x04,0xC6,0x06,0x04,0xC9,0x40,0x04,0xE1,0x42,0x04,0xE8,0x06,
   0x04,0xEF,0x80,0x04,0xF2,0x80,0x04,0xF5,0x80,0x05,0x00,0x04,0x05,0x0C,0x80,
   0x05,0x12,0x40,0x05,0x23,0x80,0x05,0x24,0x40,0x05,0x27,0x04,0x05,0x2B,0x80,
   0x05,0x2D,0x40,0x05,0x2E,0x06,0x05,0x32,0x05,0x05,0x69,0x40,0x05,0x80,0x06,
   0x05,0x82,0x80,0x05,0x83,0x80,0x05,0x84,0x42,0x05,0x88,0x80,0x05,0x8C,0x22,
   0x05,0x8E,0x80,0x05,0x95,0x40,0x05,0x96,0x80,0x05,0xA0,0x08,0x05,0xAD,0x82,
   0x05,0xC0,0x3F,0x05,0xC1,0x07,0x05,0xC4,0x1D,0x05,0xC5,0x12,0x05,0xCE,0x12,
   0x05,0xCF,0x41,0x05,0xD9,0x42,0x05,0xF5,0x80,0x06,0x12,0x80,0x06,0x40,0x05,
   0x06,0x41,0x04,0x06,0x45,0x43,0x06,0x4C,0x07,0x06,0x4F,0x80,0x06,0x52,0x0C,
   0x06,0x54,0x0C,0x06,0x59,0x4B,0x06,0x61,0x80,0x06,0x65,0x41,0x06,0x81,0x40,
   0x06,0x88,0x08,0x06,0x93,0x40,0x06,0x94,0x05,0x06,0x95,0x80,0x06,0xA2,0x80,
   0x06,0xA4,0x80,0x06,0xA7,0x13,0x06,0xB4,0x80,0x06,0xC9,0x40,0x06,0xE0,0x07,
   0x06,0xE1,0x41,0x06,0xEB,0x80,0x07,0x20,0x18,0x07,0x21,0x40,0x07,0x25,0x40,
   0x07,0x2D,0x80,0x07,0x45,0x40,0x08,0x29,0x40,0x08,0x2E,0x80,0x08,0x32,0x83,
   0x08,0x33,0x80,0x08,0x34,0x80,0x08,0x45,0x40,0x08,0xA1,0x40,0x08,0xA5,0x43,
   0x08,0xA8,0x80,0x08,0xAC,0x81,0x08,0xAE,0x80,0x08,0xB4,0x40,0x09,0x23,0x80,
   0x09,0x25,0x40,0x09,0x2C,0x40,0x09,0x32,0x80,0x09,0x8F,0x80,0x09,0x95,0x80,
   0x09,0xEB,0x80,0x09,0xEC,0x80,0x09,0xEE,0x04,0x09,0xF7,0x40,0x09,0xFA,0x80,
   0x0A,0x41,0x84,0x0A,0x45,0x04,0x0A,0x55,0x80,0x0A,0xA3,0x81,0x0A,0xB4,0x80,
   0x0C,0x2C,0x0C,0x0C,0x2E,0x08,0x0C,0x30,0x80,0x0C,0x32,0x0F,0x0C,0x35,0x04,
   0x0C,0x36,0x81,0x0C,0x61,0x8D,0x0C,0x6C,0x87,0x0C,0x6F,0x87,0x0C,0x72,0x87,
   0x0C,0x75,0x07,0x0C,0x81,0x80,0x0C,0x85,0x80,0x0C,0x8F,0x04,0x0C,0x95,0x80,
   0x0C,0x97,0x80,0x0C,0xAC,0x05,0x0C,0xB2,0x80,0x0C,0xB4,0x80,0x0C,0xB5,0x80,
   0x0C,0xB6,0x80,0x0C,0xB7,0x80,0x0D,0x00,0x05,0x0D,0x01,0x05,0x0D,0x05,0x09,
   0x0D,0x15,0x80,0x0D,0x25,0x80,0x0D,0x27,0x40,0x0D,0x28,0x40,0x0D,0x65,0x1A,
   0x0D,0x69,0x05,0x0D,0x81,0x0E,0x0D,0x8F,0x86,0x0D,0xE2,0x80,0x0D,0xE3,0x80,
   0x0D,0xE5,0x40,0x0D,0xEC,0x08,0x0D,0xEE,0x91,0x0D,0xF0,0x80,0x0D,0xF6,0x80,
   0x0E,0x35,0x84,0x0E,0x41,0x09,0x0E,0x45,0x08,0x0E,0x4F,0x04,0x0E,0xA5,0x40,
   0x0E,0xB4,0x04,0x0E,0xB5,0x40,0x0E,0xC1,0x40,0x0E,0xC5,0x40,0x0E,0xE1,0x80,
   0x0E,0xE5,0x80,0x0F,0x20,0x04,0x10,0x28,0x80,0x10,0x29,0x80,0x10,0x2C,0x80,
   0x10,0x32,0x80,0x10,0x36,0x40,0x10,0x85,0x03,0x10,0xA3,0x82,0x10,0xA7,0x80,
   0x10,0xAC,0x03,0x10,0xAD,0x81,0x10,0xAE,0x06,0x10,0xAF,0x40,0x10,0xB2,0x04,
   0x10,0xB3,0x80,0x10,0xB5,0x80,0x10,0xB6,0x83,0x10,0xB7,0x80,0x11,0x23,0x80,
   0x11,0x25,0x40,0x11,0x33,0x40,0x11,0x85,0x03,0x11,0xE3,0x80,0x11,0xE8,0x80,
   0x11,0xEE,0x12,0x11,0xEF,0x03,0x11,0xF9,0x80,0x12,0x59,0x44,0x12,0xA3,0x80,
   0x12,0xB2,0x80,0x12,0xB3,0x80,0x13,0x20,0x08,0x14,0x20,0x05,0x14,0x2C,0x06,
   0x14,0x2E,0x06,0x14,0x36,0x40,0x14,0x52,0x80,0x14,0x55,0x80,0x14,0x63,0x80,
   0x14,0x65,0x80,0x14,0x6B,0x80,0x14,0x6C,0x80,0x14,0x6F,0x40,0x14,0x8F,0x40,
   0x14,0x90,0x80,0x14,0x92,0x40,0x14,0xA0,0x14,0x14,0xA4,0x40,0x14,0xAC,0x08,
   0x14,0xAE,0x11,0x14,0xB2,0x06,0x14,0xB3,0x04,0x14,0xE1,0x45,0x14,0xE7,0x40,
   0x14,0xEC,0x80,0x14,0xF2,0x80,0x15,0x01,0x44,0x15,0x0E,0x40,0x15,0x19,0x41,
   0x15,0x23,0x40,0x15,0x2C,0x06,0x15,0x2E,0x80,0x15,0x33,0x40,0x15,0x34,0x40,
   0x15,0x80,0x0D,0x15,0x81,0x05,0x15,0x83,0x80,0x15,0x85,0x05,0x15,0x8C,0x1A,
   0x15,0x8F,0x80,0x15,0x93,0x41,0x15,0x94,0x40,0x15,0x99,0x43,0x15,0xA1,0x04,
   0x15,0xB3,0x40,0x15,0xC0,0x29,0x15,0xC1,0x04,0x15,0xC5,0x09,0x15,0xC6,0x80,
   0x15,0xCE,0x10,0x15,0xD9,0x42,0x15,0xE8,0x80,0x15,0xEE,0x42,0x16,0x40,0x2B,
   0x16,0x41,0x03,0x16,0x43,0x40,0x16,0x48,0x80,0x16,0x4E,0x0B,0x16,0x4F,0x41,
   0x16,0x52,0x07,0x16,0x53,0x05,0x16,0x54,0x08,0x16,0x56,0x80,0x16,0x59,0x4C,
   0x16,0x60,0x09,0x16,0x65,0x42,0x16,0x6F,0x40,0x16,0x73,0x45,0x16,0x8F,0x40,
   0x16,0x93,0x40,0x16,0x94,0x07,0x16,0xA5,0x40,0x16,0xAC,0x80,0x16,0xC1,0x80,
   0x16,0xC5,0x03,0x16,0xE1,0x40,0x16,0xE9,0x40,0x16,0xF3,0x40,0x17,0x20,0x3F,
   0x17,0x45,0x40,0x18,0x29,0x80,0x18,0x32,0x07,0x18,0x35,0x80,0x18,0xA0,0x04,
   0x18,0xAC,0x80,0x18,0xAE,0x80,0x18,0xB2,0x06,0x18,0xC0,0x06,0x18,0xC5,0x0B,
   0x19,0x23,0x80,0x19,0x2E,0x08,0x19,0x32,0x80,0x19,0x81,0x87,0x19,0x85,0x80,
   0x19,0x8F,0x80,0x19,0xE7,0x80,0x19,0xEE,0x40,0x19,0xF2,0x80,0x19,0xF3,0x80,
   0x1A,0x41,0x80,0x1A,0x45,0x42,0x1A,0xAC,0x81,0x1A,0xB3,0x40,0x1C,0x24,0x80,
   0x1C,0x29,0x80,0x1C,0x2C,0x06,0x1C,0x2D,0x80,0x1C,0x2E,0x54,0x1C,0x32,0x08,
   0x1C,0x39,0x40,0x1D,0x00,0x17,0x1D,0x01,0x46,0x1D,0x05,0x07,0x1D,0x0C,0x04,
   0x1D,0x0E,0x03,0x1D,0x0F,0x40,0x1D,0x14,0x11,0x1D,0x15,0x40,0x1D,0x19,0x40,
   0x1D,0x25,0x40,0x1D,0x2C,0x0C,0x1D,0x2D,0x40,0x1D,0x2E,0x04,0x1D,0x32,0x80,
   0x1D,0x81,0x09,0x1D,0x85,0x09,0x1D,0x89,0x40,0x1D,0x99,0x80,0x1D,0xC1,0x40,
   0x1D,0xC5,0x40,0x1D,0xE5,0x40,0x1D,0xEF,0x80,0x1D,0xF2,0x06,0x1E,0x41,0x06,
   0x1E,0x45,0x05,0x1E,0x49,0x81,0x1E,0x55,0x40,0x1E,0xA1,0x40,0x1E,0xA9,0x05,
   0x20,0x23,0x80,0x20,0x25,0x40,0x20,0x27,0x80,0x20,0x28,0x80,0x20,0x2C,0x09,
   0x20,0x2D,0x05,0x20,0x2E,0x25,0x20,0x32,0x05,0x20,0x37,0x04,0x20,0x39,0x40,
   0x20,0xA1,0x09,0x20,0xA5,0x0A,0x20,0xA9,0x80,0x20,0xAC,0x03,0x20,0xAE,0x08,
   0x20,0xB2,0x0D,0x20,0xB7,0x40,0x20,0xB9,0x06,0x21,0x21,0x80,0x21,0x23,0x80,
   0x21,0x25,0x40,0x21,0x27,0x81,0x21,0x2C,0x07,0x21,0x2E,0x05,0x21,0x34,0x40,
   0x21,0x85,0x41,0x21,0x89,0x44,0x21,0xA1,0x40,0x21,0xC9,0x40,0x21,0xD3,0x40,
   0x21,0xE1,0x80,0x21,0xEC,0x03,0x21,0xED,0x80,0x21,0xEE,0x06,0x21,0xF0,0x80,
   0x21,0xF6,0x80,0x21,0xF7,0x40,0x22,0x80,0x09,0x22,0x85,0x40,0x22,0x8F,0x43,
   0x22,0x92,0x40,0x22,0x93,0x40,0x22,0x99,0x40,0x22,0xA5,0x44,0x22,0xA6,0x80,
   0x22,0xAC,0x80,0x22,0xAE,0x40,0x22,0xB2,0x40,0x22,0xB3,0x80,0x22,0xB4,0x80,
   0x22,0xE1,0x40,0x23,0x20,0x08,0x24,0x2D,0x41,0x24,0x2E,0x41,0x24,0x61,0x40,
   0x24,0x6B,0x0E,0x24,0x74,0x80,0x24,0x75,0x40,0x24,0x92,0x40,0x24,0xA0,0x07,
   0x24,0xAE,0x40,0x24,0xBA,0x80,0x24,0xC6,0x07,0x24,0xE1,0x48,0x24,0xE8,0x11,
   0x24,0xF5,0x40,0x25,0x01,0x41,0x25,0x61,0x80,0x25,0x65,0x03,0x25,0x69,0x40,
   0x25,0x6D,0x80,0x25,0x75,0x40,0x25,0x80,0x05,0x25,0x82,0x80,0x25,0x83,0x80,
   0x25,0x85,0x40,0x25,0x8C,0x25,0x25,0x93,0x80,0x25,0x94,0x41,0x25,0xA2,0x80,
   0x25,0xC0,0x1B,0x25,0xC3,0x03,0x25,0xC4,0x80,0x25,0xC5,0x08,0x25,0xC7,0x05,
   0x25,0xCB,0x80,0x25,0xCC,0x04,0x25,0xCE,0x11,0x25,0xCF,0x80,0x25,0xD4,0x06,
   0x25,0xD5,0x80,0x25,0xEE,0x45,0x26,0x35,0x80,0x26,0x41,0x40,0x26,0x44,0x80,
   0x26,0x4B,0x41,0x26,0x4F,0x40,0x26,0x68,0x41,0x26,0x6F,0x40,0x26,0x85,0x40,
   0x26,0x88,0x41,0x26,0x89,0x80,0x26,0x93,0x40,0x26,0x94,0x03,0x26,0x9A,0x82,
   0x26,0xC5,0x41,0x28,0x2C,0x80,0x28,0x32,0x80,0x28,0xAE,0x80,0x28,0xB2,0x80,
   0x28,0xB4,0x80,0x29,0xEC,0x80,0x2C,0x22,0x80,0x2C,0x36,0x80,0x2C,0x39,0x40,
   0x2C,0xA0,0x04,0x2C,0xA5,0x08,0x2C,0xA8,0x80,0x2C,0xAC,0x0B,0x2C,0xAE,0x0B,
   0x2C,0xB2,0x06,0x2C,0xB4,0x43,0x2C,0xB9,0x4B,0x2D,0x01,0x40,0x2D,0x21,0x40,
   0x2D,0x24,0x80,0x2D,0x2C,0x86,0x2D,0x2E,0x08,0x2D,0xE3,0x80,0x2D,0xEC,0x40,
   0x2D,0xF2,0x81,0x2D,0xF3,0x80,0x2D,0xF5,0x80,0x2D,0xF9,0x40,0x2E,0xB2,0x80,
   0x2E,0xB3,0x40,0x30,0x23,0x80,0x30,0x24,0x03,0x30,0x26,0x80,0x30,0x27,0x03,
   0x30,0x2D,0x03,0x30,0x2E,0x29,0x30,0x32,0x07,0x30,0x33,0x06,0x30,0x35,0x06,
   0x30,0x39,0x06,0x30,0x3A,0x40,0x30,0x41,0x80,0x30,0x6F,0x40,0x30,0x85,0x40,
   0x30,0x89,0x40,0x30,0x93,0x40,0x30,0xA0,0x11,0x30,0xA5,0x06,0x30,0xA7,0x40,
   0x30,0xAD,0x04,0x30,0xAE,0x14,0x30,0xAF,0x41,0x30,0xB2,0x0B,0x30,0xB3,0x44,
   0x30,0xB6,0x40,0x30,0xB9,0x5E,0x30,0xF5,0x80,0x31,0x24,0x40,0x31,0x25,0x40,
   0x31,0x26,0x04,0x31,0x27,0x06,0x31,0x2E,0x11,0x31,0x2F,0x42,0x31,0x30,0x42,
   0x31,0x31,0x80,0x31,0x33,0x06,0x31,0x65,0x04,0x31,0x69,0x40,0x31,0x80,0x25,
   0x31,0x81,0x0F,0x31,0x82,0x80,0x31,0x85,0x1B,0x31,0x86,0x80,0x31,0x89,0x19,
   0x31,0x8F,0x09,0x31,0x93,0x40,0x31,0x95,0x04,0x31,0x99,0x47,0x31,0xA1,0x41,
   0x31,0xE4,0x80,0x31,0xE7,0x40,0x31,0xE9,0x40,0x31,0xED,0x41,0x31,0xEE,0x05,
   0x31,0xF0,0x80,0x31,0xF2,0x06,0x31,0xF6,0x81,0x31,0xF9,0x40,0x32,0x60,0x03,
   0x32,0x81,0x40,0x32,0x88,0x40,0x32,0x99,0x43,0x32,0xA3,0x81,0x32,0xAD,0x44,
   0x32,0xC9,0x41,0x34,0x22,0x80,0x34,0x23,0x92,0x34,0x27,0x81,0x34,0x2C,0x08,
   0x34,0x2E,0x16,0x34,0x45,0x40,0x34,0x49,0x40,0x34,0x4F,0x40,0x34,0x69,0x85,
   0x34,0x6B,0x8D,0x34,0x6C,0x87,0x34,0x6D,0x8B,0x34,0x6E,0x8A,0x34,0xA5,0x04,
   0x34,0xA8,0x80,0x34,0xA9,0x80,0x34,0xB3,0x40,0x34,0xB9,0x42,0x35,0x23,0x04,
   0x35,0x25,0x40,0x35,0x2B,0x80,0x35,0x2C,0x07,0x35,0x85,0x40,0x35,0x8F,0x40,
   0x35,0xAF,0x07,0x35,0xE4,0x80,0x35,0xEC,0x82,0x35,0xED,0x80,0x35,0xEE,0x0C,
   0x35,0xF2,0x06,0x36,0xA4,0x40,0x36,0xAC,0x8D,0x36,0xB2,0x04,0x36,0xB3,0x40,
   0x36,0xB4,0x80,0x38,0x23,0x40,0x38,0x24,0x40,0x38,0x27,0x06,0x38,0x28,0x06,
   0x38,0x29,0x40,0x38,0x2C,0x05,0x38,0x2E,0x4E,0x38,0x33,0x40,0x38,0x4F,0x40,
   0x38,0x68,0x03,0x38,0x80,0x17,0x38,0x89,0x80,0x38,0x8F,0x43,0x38,0x92,0x05,
   0x38,0xA0,0x0E,0x38,0xA9,0x04,0x38,0xAC,0x0D,0x38,0xAD,0x03,0x38,0xAE,0x41,
   0x38,0xB2,0x0C,0x38,0xB3,0x08,0x38,0xB4,0x42,0x38,0xB9,0x68,0x38,0xD2,0x80,
   0x39,0x23,0x03,0x39,0x2C,0x80,0x39,0x2F,0x42,0x39,0x33,0x43,0x39,0x34,0x40,
   0x39,0x65,0x40,0x39,0x85,0x44,0x39,0x89,0x02,0x39,0x95,0x40,0x39,0xC0,0x06,
   0x39,0xC1,0x0A,0x39,0xC5,0x25,0x39,0xC9,0x06,0x39,0xCF,0x06,0x39,0xD5,0x40,
   0x39,0xD9,0x43,0x39,0xED,0x40,0x39,0xEE,0x45,0x39,0xEF,0x80,0x39,0xF2,0x06,
   0x39,0xF4,0x40,0x39,0xF9,0x40,0x3A,0x4F,0x41,0x3A,0x60,0x0B,0x3A,0x65,0x40,
   0x3A,0x68,0x03,0x3A,0xB3,0x40,0x3A,0xB4,0x40,0x3A,0xE1,0x40,0x3B,0x20,0x0C,
   0x3B,0x49,0x40,0x3C,0x24,0x40,0x3C,0x27,0x80,0x3C,0x28,0x40,0x3C,0x2B,0x80,
   0x3C,0x4C,0x80,0x3C,0x4F,0x80,0x3C,0x55,0x80,0x3C,0x61,0x80,0x3C,0x6F,0x81,
   0x3C,0x75,0x80,0x3C,0x81,0x80,0x3C,0x84,0x40,0x3C,0x89,0x80,0x3C,0x8F,0x83,
   0x3C,0xAE,0x40,0x3C,0xC6,0x03,0x3C,0xCC,0x80,0x3C,0xE1,0x80,0x3C,0xE7,0x80,
   0x3C,0xE9,0x80,0x3C,0xEC,0x80,0x3C,0xEF,0x80,0x3D,0x01,0x03,0x3D,0x24,0x40,
   0x3D,0x27,0x80,0x3D,0x2E,0x40,0x3D,0x32,0x80,0x3D,0x61,0x80,0x3D,0x65,0x81,
   0x3D,0x68,0x80,0x3D,0x6F,0x40,0x3D,0x80,0x04,0x3D,0x81,0x03,0x3D,0x85,0x07,
   0x3D,0x8C,0x0A,0x3D,0x8F,0x82,0x3D,0x94,0x80,0x3D,0x95,0x80,0x3D,0x99,0x40,
   0x3D,0xA1,0x83,0x3D,0xA2,0x80,0x3D,0xA5,0x04,0x3D,0xB0,0x80,0x3D,0xB3,0x40,
   0x3D,0xC0,0x2B,0x3D,0xC1,0x08,0x3D,0xC4,0x04,0x3D,0xC5,0x0C,0x3D,0xCB,0x80,
   0x3D,0xCC,0x83,0x3D,0xCE,0x0E,0x3D,0xCF,0x04,0x3D,0xD3,0x05,0x3D,0xD5,0x40,
   0x3D,0xE4,0x40,0x3D,0xEE,0x08,0x3D,0xF0,0x40,0x3D,0xF2,0x40,0x3E,0x05,0x80,
   0x3E,0x40,0x05,0x3E,0x41,0x44,0x3E,0x42,0x80,0x3E,0x43,0x80,0x3E,0x45,0x07,
   0x3E,0x47,0x82,0x3E,0x48,0x80,0x3E,0x4C,0x81,0x3E,0x4D,0x05,0x3E,0x59,0x45,
   0x3E,0x63,0x80,0x3E,0x74,0x80,0x3E,0x81,0x40,0x3E,0x85,0x40,0x3E,0x89,0x80,
   0x3E,0x93,0x40,0x3E,0xB3,0x40,0x3E,0xC1,0x41,0x3E,0xE1,0x41,0x3F,0x20,0x0C,
   0x3F,0x21,0x80,0x3F,0x41,0x80,0x40,0x24,0x80,0x40,0x29,0x80,0x40,0x2C,0x80,
   0x40,0x2E,0x80,0x40,0x30,0x80,0x40,0xA3,0x80,0x40,0xA4,0x80,0x40,0xA9,0x80,
   0x40,0xAE,0x81,0x40,0xB2,0x81,0x40,0xB4,0x80,0x40,0xB6,0x80,0x41,0x09,0x83,
   0x41,0x23,0x81,0x41,0x32,0x80,0x41,0x33,0x80,0x41,0xEC,0x80,0x41,0xF3,0x80,
   0x41,0xF4,0x40,0x42,0x05,0x40,0x42,0x0C,0x40,0x42,0x41,0x40,0x42,0x49,0x40,
   0x42,0xA3,0x80,0x42,0xAC,0x81,0x42,0xB3,0x80,0x42,0xB4,0x80,0x46,0xA9,0x07,
   0x48,0x24,0x03,0x48,0x25,0x40,0x48,0x26,0x04,0x48,0x27,0x03,0x48,0x28,0x04,
   0x48,0x2B,0x80,0x48,0x2E,0x0D,0x48,0x34,0x04,0x48,0x37,0x03,0x48,0x39,0x09,
   0x48,0x61,0x40,0x48,0x79,0x41,0x48,0x89,0x40,0x48,0x8F,0x40,0x48,0xA0,0x06,
   0x48,0xA1,0x06,0x48,0xA5,0x08,0x48,0xAC,0x03,0x48,0xAD,0x80,0x48,0xB7,0x43,
   0x48,0xB9,0x4C,0x48,0xC5,0x40,0x48,0xE1,0x42,0x48,0xE8,0x40,0x49,0x01,0x80,
   0x49,0x22,0x80,0x49,0x25,0x40,0x49,0x27,0x07,0x49,0x2E,0x04,0x49,0x2F,0x40,
   0x49,0x39,0x40,0x49,0x65,0x43,0x49,0x73,0x40,0x49,0x81,0x04,0x49,0x85,0x47,
   0x49,0x89,0x40,0x49,0xA1,0x06,0x49,0xC0,0x08,0x49,0xC5,0x43,0x49,0xD3,0x40,
   0x49,0xE3,0x80,0x49,0xE5,0x40,0x49,0xE6,0x80,0x49,0xE7,0x80,0x49,0xE8,0x80,
   0x49,0xE9,0x40,0x49,0xED,0x40,0x49,0xEF,0x05,0x49,0xF0,0x40,0x49,0xF5,0x04,
   0x49,0xF6,0x80,0x49,0xF9,0x07,0x4A,0x41,0x05,0x4A,0x45,0x03,0x4A,0x59,0x4A,
   0x4A,0x60,0x05,0x4A,0x6F,0x41,0x4A,0x88,0x04,0x4A,0x8F,0x40,0x4A,0x93,0x41,
   0x4A,0x95,0x40,0x4A,0x99,0x48,0x4A,0xA1,0x80,0x4A,0xA3,0x80,0x4A,0xA5,0x40,
   0x4A,0xA6,0x80,0x4A,0xAE,0x80,0x4A,0xB3,0x80,0x4A,0xC9,0x40,0x4B,0x20,0x32,
   0x4B,0x21,0x40,0x4C,0x23,0x80,0x4C,0x28,0x80,0x4C,0x29,0x80,0x4C,0x2C,0x81,
   0x4C,0x34,0x80,0x4C,0x36,0x81,0x4C,0x37,0x40,0x4C,0x61,0x82,0x4C,0x68,0x80,
   0x4C,0x6F,0x81,0x4C,0x75,0x80,0x4C,0xA0,0x03,0x4C,0xA1,0x80,0x4C,0xA3,0x80,
   0x4C,0xAC,0x40,0x4C,0xB2,0x41,0x4C,0xB6,0x80,0x4D,0x01,0x11,0x4D,0x05,0x09,
   0x4D,0x0F,0x80,0x4D,0x25,0x40,0x4D,0x2E,0x80,0x4D,0x32,0x80,0x4D,0xC5,0x80,
   0x4D,0xEC,0x80,0x4D,0xEE,0x42,0x4D,0xEF,0x80,0x4D,0xF3,0x80,0x4D,0xF5,0x80,
   0x4D,0xF6,0x80,0x4E,0x05,0x80,0x4E,0x09,0x80,0x4E,0x35,0x80,0x4E,0x60,0x06,
   0x4E,0x61,0x40,0x4E,0x6F,0x40,0x4E,0x75,0x40,0x4E,0x85,0x05,0x4E,0x95,0x80,
   0x4E,0xA6,0x80,0x4E,0xAD,0x40,0x4E,0xAE,0x80,0x4E,0xB2,0x80,0x4E,0xB4,0x80,
   0x4E,0xE9,0x80,0x50,0x23,0x80,0x50,0x26,0x40,0x50,0x28,0x80,0x50,0x2C,0x80,
   0x50,0x39,0x40,0x50,0x68,0x06,0x50,0xA1,0x80,0x50,0xAF,0x40,0x50,0xB2,0x4B,
   0x51,0x00,0x0B,0x51,0x01,0x42,0x51,0x09,0x40,0x51,0x2C,0x82,0x51,0x2D,0x80,
   0x51,0x34,0x80,0x51,0x85,0x46,0x51,0xA1,0x40,0x51,0xEC,0x80,0x51,0xED,0x80,
   0x51,0xEE,0x48,0x51,0xF3,0x40,0x51,0xF5,0x80,0x51,0xF7,0x80,0x51,0xF9,0x40,
   0x52,0x49,0x03,0x52,0x59,0x42,0x52,0x60,0x05,0x52,0x80,0x0B,0x52,0x85,0x04,
   0x52,0x89,0x40,0x52,0x8F,0x40,0x52,0x93,0x40,0x52,0xA3,0x80,0x52,0xAE,0x80,
   0x52,0xB4,0x80,0x52,0xE1,0x80,0x52,0xEF,0x80,0x53,0x20,0x14,0x54,0x2C,0x80,
   0x54,0x2E,0x40,0x54,0x6B,0x05,0x54,0xA0,0x05,0x54,0xAE,0x40,0x54,0xB2,0x40,
   0x54,0xC6,0x04,0x54,0xCB,0x80,0x54,0xE7,0x80,0x54,0xE8,0x25,0x54,0xE9,0x40,
   0x54,0xEB,0x40,0x54,0xF5,0x80,0x55,0x01,0x40,0x55,0x2C,0x82,0x55,0x2E,0x05,
   0x55,0x32,0x04,0x55,0x34,0x40,0x55,0x85,0x42,0x55,0x8C,0x16,0x55,0x8D,0x80,
   0x55,0x8F,0x80,0x55,0xA0,0x06,0x55,0xC3,0x40,0x55,0xC4,0x80,0x55,0xC7,0x40,
   0x56,0x41,0x40,0x56,0x45,0x41,0x56,0x50,0x80,0x56,0x54,0x04,0x56,0x56,0x80,
   0x56,0x68,0x81,0x56,0x69,0x80,0x56,0x73,0x40,0x56,0x85,0x40,0x56,0x92,0x80,
   0x56,0x94,0x04,0x56,0x95,0x80,0x56,0xB2,0x80,0x56,0xC5,0x80,0x58,0x23,0x80,
   0x58,0x2E,0x0A,0x58,0x35,0x80,0x58,0xB4,0x40,0x59,0x25,0x40,0x59,0x2C,0x80,
   0x59,0x2E,0x03,0x59,0x34,0x40,0x59,0xE3,0x80,0x59,0xE7,0x80,0x59,0xE9,0x80,
   0x59,0xEC,0x40,0x59,0xF2,0x40,0x59,0xF5,0x80,0x5C,0x2D,0x80,0x5C,0x32,0x80,
   0x5C,0x33,0x80,0x5C,0x34,0x80,0x5C,0x35,0x80,0x5C,0x39,0x44,0x5C,0xAC,0x42,
   0x5C,0xAE,0x40,0x5C,0xB3,0x80,0x5D,0x01,0x40,0x5D,0x23,0x80,0x5D,0x25,0x80,
   0x5D,0x27,0x82,0x5D,0x33,0x40,0x5D,0x34,0x80,0x5D,0x85,0x41,0x5D,0xEF,0x80,
   0x64,0x2B,0x40,0x64,0x2E,0x41,0x64,0x32,0x40,0x64,0xA1,0x40,0x65,0x81,0x40,
   0x65,0x85,0x47,0x65,0x89,0x40,0x65,0x8F,0x80,0x65,0xA1,0x40,0x65,0xC1,0x40,
   0x65,0xCB,0x80,0x65,0xEE,0x40,0x66,0x65,0x80,0x69,0x25,0x40};
const unsigned int irish_entries = 1034;
/*
 *  Trigram frequency tables for acna.c.
 *  Generated from : *.nam
 *  Written to file : acna.c
 *  Created on : 08/21/01 at 16:43:10
 */
const unsigned char far italian[] = {
   0x00,0x2C,0x0A,0x00,0x2D,0x06,0x00,0x2E,0x0C,0x00,0x32,0x08,0x00,0x41,0x19,
   0x00,0x45,0x14,0x00,0x49,0x06,0x00,0x4F,0x0E,0x00,0x52,0x0B,0x00,0x55,0x07,
   0x00,0x61,0x3F,0x00,0x65,0x0B,0x00,0x68,0x0B,0x00,0x69,0x0E,0x00,0x6F,0x1D,
   0x00,0x75,0x04,0x00,0x81,0x0D,0x00,0x85,0x23,0x00,0x89,0x15,0x00,0x8F,0x03,
   0x00,0xC1,0x0B,0x00,0xC5,0x08,0x00,0xC9,0x05,0x00,0xCF,0x07,0x00,0xD2,0x0B,
   0x00,0xE1,0x12,0x00,0xE5,0x05,0x00,0xE9,0x0F,0x00,0xF2,0x0A,0x00,0xF5,0x07,
   0x01,0x2E,0x03,0x01,0x81,0x16,0x01,0x89,0x05,0x01,0x8F,0x0A,0x01,0x95,0x06,
   0x01,0xA1,0x33,0x01,0xA5,0x0E,0x01,0xA9,0x0A,0x01,0xAF,0x17,0x01,0xB5,0x04,
   0x01,0xC1,0x04,0x01,0xF2,0x05,0x02,0x01,0x21,0x02,0x05,0x13,0x02,0x09,0x0F,
   0x02,0x0F,0x09,0x02,0x12,0x06,0x02,0x15,0x05,0x02,0x35,0x03,0x02,0x41,0x0A,
   0x02,0x45,0x08,0x02,0x49,0x09,0x02,0x4F,0x0D,0x02,0x55,0x05,0x02,0x61,0x1B,
   0x02,0x63,0x0C,0x02,0x65,0x0A,0x02,0x69,0x09,0x02,0x6F,0x05,0x02,0x70,0x09,
   0x02,0x74,0x06,0x02,0x81,0x08,0x02,0x85,0x07,0x02,0x8F,0x09,0x02,0x92,0x0A,
   0x02,0x95,0x04,0x02,0xC1,0x08,0x02,0xC5,0x09,0x02,0xC9,0x0C,0x03,0x41,0x08,
   0x04,0x33,0x80,0x04,0x52,0x03,0x04,0x61,0x04,0x04,0x65,0x03,0x04,0x69,0x05,
   0x04,0x6F,0x04,0x04,0x89,0x04,0x04,0xB2,0x80,0x04,0xC1,0x80,0x04,0xEC,0x08,
   0x04,0xEE,0x08,0x04,0xEF,0x04,0x05,0x09,0x40,0x05,0x24,0x80,0x05,0x25,0x81,
   0x05,0x2E,0x03,0x05,0x36,0x80,0x05,0x4F,0x80,0x05,0x81,0x0B,0x05,0x82,0x83,
   0x05,0x84,0x08,0x05,0x85,0x0B,0x05,0x89,0x0A,0x05,0x8C,0x0F,0x05,0x8F,0x06,
   0x05,0xA1,0x08,0x05,0xA2,0x06,0x05,0xA3,0x40,0x05,0xA9,0x04,0x05,0xAF,0x05,
   0x05,0xB0,0x06,0x05,0xC1,0x0A,0x05,0xC3,0x0D,0x05,0xC4,0x10,0x05,0xC5,0x08,
   0x05,0xC7,0x0D,0x05,0xC9,0x17,0x05,0xCE,0x0C,0x05,0xCF,0x5C,0x05,0xD3,0x81,
   0x05,0xD4,0x18,0x05,0xDA,0x07,0x06,0x09,0x03,0x06,0x10,0x05,0x06,0x14,0x80,
   0x06,0x41,0x0F,0x06,0x42,0x04,0x06,0x43,0x08,0x06,0x44,0x13,0x06,0x45,0x0E,
   0x06,0x46,0x40,0x06,0x49,0x1B,0x06,0x4D,0x83,0x06,0x4F,0x13,0x06,0x52,0x0B,
   0x06,0x54,0x08,0x06,0x5A,0x81,0x06,0x61,0x05,0x06,0x63,0x08,0x06,0x68,0x80,
   0x06,0x69,0x07,0x06,0x6E,0x80,0x06,0x70,0x80,0x06,0x73,0x0F,0x06,0x74,0x0B,
   0x06,0x75,0x80,0x06,0x81,0x04,0x06,0x85,0x04,0x06,0x88,0x80,0x06,0x89,0x07,
   0x06,0x8F,0x0C,0x06,0x94,0x0B,0x06,0xA6,0x80,0x06,0xAC,0x80,0x06,0xAE,0x40,
   0x06,0xB2,0x03,0x06,0xC1,0x06,0x06,0xC5,0x04,0x06,0xC9,0x05,0x06,0xCF,0x03,
   0x08,0x24,0x80,0x08,0x28,0x80,0x08,0x2C,0x07,0x08,0x30,0x80,0x08,0x32,0x0C,
   0x08,0x33,0x03,0x08,0x45,0x40,0x08,0xA1,0x80,0x08,0xAC,0x0A,0x08,0xB2,0x0C,
   0x08,0xB3,0x80,0x09,0xE1,0x80,0x09,0xE4,0x80,0x09,0xED,0x80,0x09,0xEE,0x07,
   0x09,0xEF,0x80,0x09,0xF2,0x05,0x09,0xF3,0x81,0x09,0xF5,0x80,0x09,0xFA,0x80,
   0x0A,0x41,0x84,0x0A,0xAF,0x81,0x0C,0x20,0x0E,0x0C,0x22,0x40,0x0C,0x24,0x80,
   0x0C,0x26,0x80,0x0C,0x27,0x02,0x0C,0x2C,0x0A,0x0C,0x2D,0x86,0x0C,0x2E,0x0B,
   0x0C,0x30,0x88,0x0C,0x32,0x1B,0x0C,0x33,0x0D,0x0C,0x34,0x06,0x0C,0xA0,0x0C,
   0x0C,0xA4,0x80,0x0C,0xAC,0x07,0x0C,0xAD,0x40,0x0C,0xAE,0x04,0x0C,0xAF,0x40,
   0x0C,0xB0,0x80,0x0C,0xB2,0x06,0x0D,0x05,0x09,0x0D,0x09,0x24,0x0D,0x0D,0x80,
   0x0D,0x21,0x0F,0x0D,0x23,0x04,0x0D,0x2E,0x06,0x0D,0x81,0x80,0x0D,0x89,0x40,
   0x0D,0xE0,0x1B,0x0D,0xE3,0x82,0x0D,0xE5,0x40,0x0D,0xEC,0x0C,0x0D,0xED,0x03,
   0x0D,0xEE,0x0A,0x0D,0xF2,0x08,0x0D,0xF5,0x80,0x0E,0x49,0x03,0x0E,0x4F,0x80,
   0x10,0x20,0x08,0x10,0x24,0x80,0x10,0x2C,0x04,0x10,0x2E,0x06,0x10,0x36,0x80,
   0x10,0x85,0x40,0x10,0xA2,0x80,0x10,0xA3,0x83,0x10,0xA6,0x83,0x10,0xA7,0x81,
   0x10,0xA9,0x80,0x10,0xAC,0x12,0x10,0xAD,0x83,0x10,0xB0,0x81,0x10,0xB2,0x05,
   0x10,0xB3,0x04,0x10,0xB5,0x80,0x10,0xBA,0x80,0x11,0x20,0x13,0x11,0x22,0x80,
   0x11,0x23,0x04,0x11,0x2D,0x84,0x11,0x2E,0x0B,0x11,0x33,0x03,0x11,0xEE,0x05,
   0x11,0xF2,0x03,0x12,0x4F,0x40,0x12,0x55,0x80,0x12,0xB2,0x80,0x12,0xB3,0x40,
   0x14,0x24,0x80,0x14,0x32,0x40,0x14,0x34,0x40,0x14,0x41,0x80,0x14,0x55,0x80,
   0x14,0x61,0x03,0x14,0x81,0x41,0x14,0x84,0x40,0x14,0x89,0x03,0x14,0x93,0x80,
   0x14,0xB3,0x40,0x14,0xE5,0x80,0x14,0xF2,0x03,0x14,0xF5,0x80,0x15,0x23,0x40,
   0x15,0x2E,0x40,0x15,0x81,0x07,0x15,0x82,0x80,0x15,0x86,0x80,0x15,0x89,0x0A,
   0x15,0x8C,0x3F,0x15,0x8E,0x80,0x15,0x8F,0x05,0x15,0x90,0x80,0x15,0x92,0x80,
   0x15,0x95,0x81,0x15,0x96,0x80,0x15,0xA1,0x04,0x15,0xA2,0x80,0x15,0xAD,0x40,
   0x15,0xC1,0x06,0x15,0xC6,0x80,0x15,0xC9,0x04,0x15,0xCF,0x42,0x15,0xD4,0x10,
   0x15,0xDA,0x04,0x15,0xE0,0x06,0x15,0xE3,0x40,0x16,0x01,0x80,0x16,0x14,0x80,
   0x16,0x41,0x09,0x16,0x45,0x05,0x16,0x49,0x12,0x16,0x4D,0x03,0x16,0x4F,0x0E,
   0x16,0x52,0x0E,0x16,0x54,0x07,0x16,0x55,0x81,0x16,0x61,0x04,0x16,0x63,0x05,
   0x16,0x65,0x47,0x16,0x68,0x80,0x16,0x69,0x03,0x16,0x73,0x05,0x16,0x74,0x04,
   0x16,0x75,0x40,0x16,0x92,0x03,0x16,0x93,0x80,0x16,0x94,0x5A,0x16,0xAC,0x40,
   0x16,0xB2,0x40,0x16,0xD2,0x40,0x17,0x45,0x80,0x18,0x29,0x80,0x18,0x2E,0x03,
   0x18,0x30,0x80,0x18,0x32,0x03,0x18,0x35,0x80,0x18,0xAE,0x80,0x18,0xAF,0x40,
   0x18,0xB2,0x07,0x19,0x2E,0x03,0x19,0x2F,0x02,0x19,0x32,0x80,0x19,0x81,0x80,
   0x19,0x85,0x80,0x19,0xF2,0x05,0x19,0xF5,0x80,0x1A,0x41,0x08,0x1C,0x29,0x80,
   0x1C,0x2C,0x07,0x1C,0x32,0x07,0x1C,0x35,0x80,0x1C,0xAC,0x04,0x1C,0xB2,0x04,
   0x1C,0xE9,0x05,0x1D,0x81,0x80,0x1D,0x89,0x10,0x1D,0x8F,0x80,0x1D,0x95,0x40,
   0x1D,0xC1,0x07,0x1D,0xC9,0x42,0x1D,0xCF,0x08,0x1D,0xE0,0x07,0x1D,0xE4,0x40,
   0x1D,0xEC,0x03,0x1D,0xEF,0x40,0x1D,0xF4,0x80,0x1E,0x4F,0x03,0x1E,0xA1,0x82,
   0x20,0x23,0x40,0x20,0x2D,0x80,0x20,0x2E,0x40,0x20,0xA2,0x80,0x20,0xA3,0x40,
   0x20,0xAC,0x03,0x20,0xAD,0x40,0x20,0xAE,0x40,0x21,0x20,0x0B,0x21,0x21,0x09,
   0x21,0x2D,0x80,0x21,0x2E,0x44,0x21,0x33,0x80,0x21,0x36,0x80,0x21,0xF3,0x80,
   0x22,0x49,0x80,0x22,0x4F,0x40,0x22,0xA7,0x80,0x22,0xB2,0x40,0x24,0x20,0x24,
   0x24,0x21,0x80,0x24,0x23,0x03,0x24,0x2E,0x19,0x24,0x31,0x80,0x24,0x32,0x09,
   0x24,0x42,0x80,0x24,0x4F,0x81,0x24,0x65,0x08,0x24,0x69,0x05,0x24,0x6F,0x09,
   0x24,0x72,0x80,0x24,0x73,0x40,0x24,0x74,0x80,0x24,0x8F,0x03,0x24,0xA3,0x40,
   0x24,0xAC,0x08,0x24,0xAD,0x80,0x24,0xB2,0x0A,0x24,0xB3,0x41,0x24,0xB4,0x03,
   0x24,0xB6,0x40,0x24,0xC1,0x80,0x24,0xC5,0x80,0x24,0xE8,0x40,0x24,0xEE,0x06,
   0x25,0x82,0x80,0x25,0x85,0x04,0x25,0x89,0x04,0x25,0x8C,0x10,0x25,0x95,0x80,
   0x25,0xA1,0x03,0x25,0xAD,0x80,0x25,0xB5,0x80,0x25,0xC1,0x10,0x25,0xC5,0x16,
   0x25,0xC6,0x80,0x25,0xC7,0x06,0x25,0xC9,0x64,0x25,0xCD,0x80,0x25,0xCF,0x5F,
   0x25,0xD3,0x80,0x25,0xD4,0x03,0x25,0xE0,0x2F,0x25,0xEC,0x46,0x25,0xEE,0x46,
   0x25,0xF2,0x06,0x26,0x55,0x80,0x26,0x56,0x80,0x26,0x63,0x06,0x26,0x65,0x03,
   0x26,0x6C,0x40,0x26,0x6E,0x80,0x26,0x74,0x06,0x26,0x8F,0x08,0x26,0x94,0x03,
   0x26,0x95,0x80,0x27,0x55,0x40,0x27,0x5A,0x06,0x28,0x23,0x80,0x2C,0x2C,0x80,
   0x30,0x20,0x2C,0x30,0x23,0x04,0x30,0x27,0x03,0x30,0x2D,0x05,0x30,0x2E,0x10,
   0x30,0x32,0x08,0x30,0x33,0x04,0x30,0x34,0x04,0x30,0x35,0x81,0x30,0x89,0x05,
   0x30,0xA0,0x12,0x30,0xA5,0x40,0x30,0xAE,0x05,0x30,0xB0,0x80,0x30,0xB2,0x04,
   0x30,0xB3,0x04,0x30,0xB4,0x05,0x30,0xBA,0x80,0x31,0x20,0x33,0x31,0x21,0x0D,
   0x31,0x23,0x04,0x31,0x27,0x80,0x31,0x2E,0x0B,0x31,0x35,0x80,0x31,0x81,0x1F,
   0x31,0x89,0x68,0x31,0x8F,0x64,0x31,0xE0,0x2C,0x31,0xE2,0x80,0x31,0xED,0x04,
   0x31,0xEE,0x08,0x31,0xF0,0x80,0x31,0xF2,0x03,0x31,0xF4,0x04,0x32,0xA3,0x06,
   0x32,0xB4,0x40,0x32,0xB5,0x40,0x34,0x22,0x80,0x34,0x23,0x04,0x34,0x24,0x80,
   0x34,0x27,0x04,0x34,0x2C,0x03,0x34,0x2E,0x0E,0x34,0x32,0x17,0x34,0x33,0x0A,
   0x34,0x34,0x03,0x34,0x3A,0x83,0x34,0x4C,0x40,0x34,0xA4,0x81,0x34,0xA9,0x40,
   0x34,0xAC,0x06,0x34,0xAE,0x07,0x35,0x23,0x03,0x35,0x2E,0x08,0x35,0x2F,0x80,
   0x35,0x34,0x40,0x35,0x3A,0x80,0x35,0xA5,0x80,0x35,0xE7,0x80,0x35,0xEC,0x03,
   0x35,0xEE,0x0D,0x35,0xEF,0x80,0x35,0xF2,0x0A,0x35,0xF3,0x82,0x35,0xF4,0x80,
   0x35,0xF6,0x80,0x36,0x0C,0x40,0x36,0xA5,0x80,0x36,0xA7,0x80,0x36,0xB3,0x81,
   0x38,0x20,0x22,0x38,0x2C,0x03,0x38,0x2E,0x05,0x38,0x32,0x07,0x38,0x34,0x05,
   0x38,0x65,0x04,0x38,0x69,0x07,0x38,0x85,0x03,0x38,0x89,0x07,0x38,0x8F,0x06,
   0x38,0x92,0x05,0x38,0xA0,0x33,0x38,0xA1,0x40,0x38,0xAC,0x0B,0x38,0xAD,0x80,
   0x38,0xB3,0x03,0x38,0xE1,0x06,0x38,0xE5,0x05,0x38,0xEC,0x40,0x38,0xEF,0x05,
   0x39,0x20,0x3F,0x39,0x21,0x42,0x39,0x23,0x04,0x39,0x2E,0x06,0x39,0xC1,0x07,
   0x39,0xC9,0x05,0x39,0xE0,0x3F,0x39,0xEC,0x04,0x39,0xED,0x40,0x39,0xEE,0x43,
   0x3A,0x61,0x80,0x3A,0x81,0x0B,0x3A,0x85,0x0B,0x3A,0x89,0x11,0x3A,0x8F,0x09,
   0x3A,0xA5,0x40,0x3B,0x41,0x03,0x3C,0x2C,0x80,0x3C,0x32,0x40,0x3C,0x33,0x80,
   0x3C,0x36,0x40,0x3C,0x75,0x80,0x3C,0x95,0x80,0x3C,0xB2,0x80,0x3C,0xE8,0x80,
   0x3D,0x24,0x80,0x3D,0x2E,0x40,0x3D,0x81,0x12,0x3D,0x82,0x80,0x3D,0x85,0x06,
   0x3D,0x89,0x14,0x3D,0x8C,0x07,0x3D,0x8F,0x0A,0x3D,0x90,0x80,0x3D,0xA1,0x04,
   0x3D,0xA2,0x05,0x3D,0xB3,0x80,0x3D,0xC1,0x09,0x3D,0xC4,0x05,0x3D,0xC5,0x61,
   0x3D,0xC7,0x03,0x3D,0xC9,0x16,0x3D,0xD4,0x0A,0x3D,0xEC,0x40,0x3D,0xF2,0x40,
   0x3D,0xF3,0x80,0x3E,0x12,0x80,0x3E,0x41,0x06,0x3E,0x44,0x04,0x3E,0x45,0x10,
   0x3E,0x46,0x80,0x3E,0x49,0x0C,0x3E,0x4D,0x80,0x3E,0x4F,0x04,0x3E,0x52,0x05,
   0x3E,0x54,0x07,0x3E,0x63,0x03,0x3E,0x73,0x06,0x3E,0x74,0x05,0x3E,0x94,0x0E,
   0x3E,0xAE,0x40,0x3E,0xB4,0x40,0x3E,0xB6,0x80,0x3E,0xC5,0x05,0x40,0x20,0x04,
   0x40,0x21,0x80,0x40,0x27,0x04,0x40,0x29,0x80,0x40,0x2C,0x07,0x40,0x2E,0x05,
   0x40,0x32,0x09,0x40,0x33,0x06,0x40,0x34,0x03,0x40,0x35,0x80,0x40,0x3A,0x80,
   0x40,0xA1,0x80,0x40,0xA5,0x80,0x40,0xAC,0x05,0x40,0xAE,0x03,0x40,0xB2,0x07,
   0x40,0xB4,0x05,0x40,0xB5,0x80,0x41,0x09,0x40,0x41,0x23,0x84,0x41,0x25,0x03,
   0x41,0x2E,0x06,0x41,0x3A,0x81,0x41,0x81,0x80,0x41,0x85,0x40,0x41,0xE0,0x04,
   0x41,0xE9,0x80,0x41,0xEC,0x06,0x41,0xEF,0x80,0x41,0xF2,0x05,0x41,0xF4,0x40,
   0x42,0x45,0x83,0x42,0x49,0x03,0x42,0x55,0x80,0x42,0x81,0x40,0x42,0xA7,0x80,
   0x42,0xA9,0x80,0x48,0x20,0x12,0x48,0x23,0x05,0x48,0x24,0x03,0x48,0x27,0x04,
   0x48,0x2D,0x03,0x48,0x2E,0x14,0x48,0x32,0x03,0x48,0x33,0x04,0x48,0x34,0x04,
   0x48,0x68,0x03,0x48,0x81,0x03,0x48,0x89,0x0D,0x48,0x8F,0x05,0x48,0xA0,0x12,
   0x48,0xA2,0x80,0x48,0xA3,0x04,0x48,0xA5,0x80,0x48,0xA7,0x04,0x48,0xAC,0x11,
   0x48,0xAE,0x09,0x48,0xB4,0x06,0x48,0xB5,0x40,0x48,0xCF,0x40,0x49,0x20,0x1C,
   0x49,0x21,0x0A,0x49,0x23,0x0B,0x49,0x25,0x06,0x49,0x27,0x03,0x49,0x2D,0x80,
   0x49,0x2E,0x13,0x49,0x2F,0x0C,0x49,0x33,0x04,0x49,0x34,0x03,0x49,0x81,0x04,
   0x49,0xCF,0x41,0x49,0xE0,0x25,0x49,0xE1,0x80,0x49,0xE3,0x03,0x49,0xE5,0x80,
   0x49,0xEC,0x05,0x49,0xED,0x81,0x49,0xEE,0x0D,0x49,0xEF,0x40,0x49,0xF2,0x40,
   0x49,0xF3,0x09,0x4A,0x41,0x0A,0x4A,0x45,0x08,0x4A,0x49,0x09,0x4A,0x4F,0x05,
   0x4A,0x6F,0x42,0x4A,0x85,0x04,0x4A,0x89,0x07,0x4A,0x8F,0x07,0x4A,0xA6,0x81,
   0x4A,0xA9,0x80,0x4A,0xB3,0x04,0x4A,0xC5,0x40,0x4C,0x2C,0x09,0x4C,0x2E,0x0E,
   0x4C,0x32,0x08,0x4C,0x35,0x80,0x4C,0x36,0x82,0x4C,0x61,0x0B,0x4C,0x68,0x06,
   0x4C,0x69,0x08,0x4C,0x6F,0x0C,0x4C,0xA0,0x0E,0x4C,0xAC,0x03,0x4C,0xAE,0x03,
   0x4C,0xAF,0x40,0x4C,0xB2,0x06,0x4C,0xB6,0x80,0x4D,0x01,0x80,0x4D,0x05,0x80,
   0x4D,0x15,0x80,0x4D,0x20,0x0E,0x4D,0x22,0x80,0x4D,0x2E,0x09,0x4D,0x2F,0x44,
   0x4D,0x85,0x40,0x4D,0x8F,0x80,0x4D,0xA5,0x80,0x4D,0xC5,0x80,0x4D,0xE0,0x0D,
   0x4D,0xE2,0x80,0x4D,0xEC,0x03,0x4D,0xF0,0x80,0x4D,0xF6,0x80,0x4E,0x01,0x84,
   0x4E,0x05,0x81,0x4E,0x09,0x82,0x4E,0x4F,0x40,0x4E,0x61,0x09,0x4E,0x65,0x05,
   0x4E,0x69,0x09,0x4E,0x6E,0x40,0x4E,0x6F,0x07,0x4E,0x81,0x0A,0x4E,0x85,0x05,
   0x4E,0x89,0x07,0x4E,0x8F,0x05,0x4E,0x92,0x08,0x4E,0xA1,0x80,0x4E,0xA4,0x80,
   0x4E,0xAE,0x80,0x4E,0xB2,0x80,0x4E,0xB4,0x40,0x4E,0xBA,0x80,0x4E,0xC5,0x40,
   0x50,0x20,0x1A,0x50,0x27,0x05,0x50,0x2C,0x06,0x50,0x2E,0x08,0x50,0x2F,0x40,
   0x50,0x32,0x04,0x50,0xA0,0x0C,0x50,0xAC,0x0A,0x50,0xAE,0x03,0x50,0xAF,0x40,
   0x50,0xB2,0x07,0x51,0x12,0x40,0x51,0x20,0x2C,0x51,0x25,0x03,0x51,0x2C,0x04,
   0x51,0x2E,0x10,0x51,0xC1,0x40,0x51,0xC5,0x40,0x51,0xE0,0x25,0x51,0xEC,0x06,
   0x51,0xED,0x03,0x51,0xEE,0x07,0x51,0xF2,0x0C,0x52,0x41,0x07,0x52,0x42,0x80,
   0x52,0x45,0x04,0x52,0x49,0x08,0x52,0x4F,0x08,0x52,0x81,0x0E,0x52,0x89,0x1D,
   0x52,0x8F,0x0C,0x52,0xAD,0x80,0x52,0xB2,0x04,0x52,0xB3,0x40,0x54,0x24,0x80,
   0x54,0x27,0x80,0x54,0x29,0x80,0x54,0x34,0x81,0x54,0x3A,0x80,0x54,0x42,0x80,
   0x54,0x45,0x80,0x54,0x84,0x80,0x54,0xE9,0x40,0x55,0x8C,0x04,0x55,0xA9,0x80,
   0x55,0xAD,0x80,0x55,0xCE,0x40,0x55,0xCF,0x40,0x55,0xD3,0x80,0x55,0xD4,0x40,
   0x56,0x01,0x80,0x56,0x04,0x80,0x56,0x05,0x40,0x56,0x10,0x40,0x56,0x44,0x80,
   0x56,0x49,0x04,0x56,0x4C,0x40,0x56,0x4D,0x80,0x56,0x4F,0x42,0x56,0x50,0x80,
   0x56,0x51,0x80,0x56,0x6F,0x42,0x56,0x75,0x80,0x56,0x8F,0x44,0x57,0x41,0x40,
   0x57,0x49,0x40,0x58,0x2C,0x05,0x58,0x2E,0x04,0x58,0xAC,0x03,0x58,0xAE,0x04,
   0x58,0xAF,0x40,0x58,0xBA,0x80,0x59,0x24,0x80,0x59,0x2E,0x04,0x59,0x33,0x82,
   0x59,0xEC,0x03,0x59,0xF2,0x80,0x59,0xF5,0x80,0x5A,0x41,0x80,0x64,0xAC,0x80,
   0x68,0x20,0x06,0x68,0x29,0x80,0x68,0x2D,0x81,0x68,0x2E,0x04,0x68,0x36,0x80,
   0x68,0xA3,0x80,0x68,0xAE,0x80,0x68,0xAF,0x40,0x68,0xB3,0x40,0x69,0x2E,0x04,
   0x69,0x2F,0x44,0x69,0xE0,0x09,0x69,0xE6,0x80,0x69,0xED,0x80,0x69,0xEE,0x05,
   0x69,0xF0,0x80,0x6A,0xB4,0x40,0x6B,0x41,0x08,0x6B,0x45,0x03};
const unsigned int italian_entries = 819;
/*
 *  Trigram frequency tables for acna.c.
 *  Generated from : *.nam
 *  Written to file : acna.c
 *  Created on : 08/21/01 at 16:43:10
 */
const unsigned char far japan[] = {
   0x00,0x29,0x04,0x00,0x2B,0x07,0x00,0x32,0x07,0x00,0x33,0x04,0x00,0xA4,0x41,
   0x00,0xD5,0x1E,0x00,0xEF,0x08,0x01,0x01,0x1A,0x01,0x09,0x1D,0x01,0x0F,0x12,
   0x01,0x2D,0x06,0x01,0x2E,0x07,0x01,0x33,0x0F,0x01,0x34,0x0A,0x01,0x61,0x3F,
   0x01,0x69,0x1B,0x01,0x6F,0x20,0x01,0x75,0x1F,0x01,0x8F,0x41,0x01,0xA1,0x2D,
   0x01,0xA9,0x1E,0x01,0xAF,0x0A,0x01,0xB5,0x0F,0x01,0xC1,0x29,0x01,0xC5,0x03,
   0x01,0xC9,0x0D,0x01,0xCF,0x0A,0x01,0xE7,0x06,0x01,0xE8,0x14,0x01,0xE9,0x02,
   0x01,0xEB,0x0C,0x01,0xEE,0x07,0x01,0xF3,0x07,0x01,0xF4,0x04,0x02,0x61,0x20,
   0x02,0x65,0x07,0x02,0x68,0x21,0x02,0x6F,0x07,0x02,0x75,0x1B,0x02,0x81,0x3E,
   0x02,0x85,0x0A,0x02,0x8F,0x0A,0x02,0xAE,0x41,0x02,0xE1,0x0E,0x03,0x21,0x20,
   0x03,0x2F,0x0A,0x03,0x41,0x09,0x04,0x41,0x0F,0x04,0x45,0x0A,0x04,0x81,0x55,
   0x04,0x85,0x42,0x04,0xE1,0x1F,0x04,0xE5,0x41,0x04,0xE9,0x09,0x04,0xEF,0x04,
   0x05,0x01,0x0E,0x05,0x09,0x41,0x05,0x20,0x1B,0x05,0x24,0x42,0x05,0x28,0x81,
   0x05,0x2B,0x42,0x05,0x32,0x04,0x05,0x33,0x04,0x05,0x34,0x04,0x05,0x45,0x81,
   0x05,0x65,0x14,0x05,0x69,0x25,0x05,0x6F,0x42,0x05,0xA1,0x3F,0x05,0xA2,0x42,
   0x05,0xA9,0x0F,0x05,0xAF,0x0E,0x05,0xB5,0x08,0x05,0xC1,0x1B,0x05,0xC2,0x42,
   0x05,0xC5,0x07,0x05,0xC7,0x81,0x05,0xC9,0x12,0x05,0xCF,0x0D,0x05,0xDA,0x82,
   0x05,0xE0,0x04,0x05,0xEB,0x47,0x06,0x41,0x33,0x06,0x45,0x03,0x06,0x49,0x0E,
   0x06,0x4F,0x43,0x06,0x55,0x0C,0x06,0x61,0x16,0x06,0x65,0x09,0x06,0x68,0x2B,
   0x06,0x6B,0x41,0x06,0x81,0x27,0x06,0x85,0x0D,0x06,0x89,0x41,0x06,0x8B,0x41,
   0x06,0x8F,0x0D,0x06,0x93,0x20,0x06,0x94,0x81,0x06,0x95,0x81,0x06,0xB3,0x81,
   0x06,0xB4,0x41,0x06,0xE1,0x3F,0x07,0x21,0x14,0x07,0x2F,0x42,0x07,0x4F,0x41,
   0x08,0x20,0x0F,0x08,0x2E,0x04,0x08,0x32,0x44,0x08,0x33,0x03,0x08,0x34,0x49,
   0x08,0x35,0x81,0x08,0x37,0x42,0x08,0x39,0x06,0x08,0xA0,0x10,0x08,0xA9,0x81,
   0x08,0xAB,0x41,0x08,0xB2,0x41,0x09,0x34,0x43,0x09,0xE0,0x07,0x09,0xF4,0x41,
   0x0D,0x09,0x2D,0x10,0x20,0x3F,0x10,0x2D,0x43,0x10,0x2E,0x41,0x10,0x32,0x41,
   0x10,0xA0,0x04,0x10,0xB2,0x43,0x11,0xE0,0x0D,0x11,0xF3,0x81,0x11,0xF5,0x41,
   0x14,0x45,0x41,0x14,0x81,0x4D,0x14,0xE9,0x81,0x14,0xF5,0x81,0x15,0x34,0x41,
   0x15,0x65,0x41,0x15,0x69,0x09,0x15,0xA1,0x04,0x15,0xC1,0x41,0x15,0xC4,0x41,
   0x15,0xC7,0x41,0x15,0xCF,0x42,0x16,0x05,0x81,0x16,0x41,0x0D,0x16,0x49,0x81,
   0x16,0x68,0x03,0x16,0x81,0x04,0x16,0x8F,0x41,0x17,0x55,0x03,0x1A,0xAA,0x8A,
   0x1A,0xAB,0x8F,0x1A,0xB3,0x41,0x1C,0x20,0x12,0x1C,0x24,0x81,0x1C,0x2D,0x06,
   0x1C,0x32,0x82,0x1C,0x34,0x42,0x1C,0x37,0x4A,0x1C,0x3A,0x41,0x1C,0xA0,0x04,
   0x1D,0x20,0x0C,0x1D,0x2E,0x41,0x1D,0xE4,0x41,0x1D,0xE8,0x81,0x1D,0xEA,0x41,
   0x1D,0xEB,0x41,0x1D,0xF2,0x41,0x1D,0xF5,0x03,0x1E,0xA9,0x81,0x1E,0xB3,0x41,
   0x20,0x22,0x41,0x20,0x2B,0x81,0x20,0x2D,0x04,0x20,0x2E,0x82,0x20,0x32,0x1E,
   0x20,0x33,0x0E,0x20,0x34,0x82,0x20,0x39,0x84,0x20,0xA2,0x41,0x21,0x20,0x3F,
   0x21,0x21,0x41,0x21,0x24,0x48,0x21,0x2B,0x0C,0x21,0x2D,0x19,0x21,0x2E,0x0D,
   0x21,0x2F,0x82,0x21,0x32,0x1B,0x21,0x33,0x04,0x21,0x61,0x81,0x21,0x69,0x81,
   0x21,0x75,0x81,0x21,0xED,0x41,0x21,0xEE,0x82,0x21,0xF2,0x86,0x21,0xF3,0x84,
   0x21,0xF5,0x81,0x22,0x49,0x41,0x22,0xA2,0x41,0x22,0xA3,0x81,0x22,0xA4,0x41,
   0x22,0xAD,0x81,0x22,0xE1,0x81,0x24,0x41,0x0F,0x24,0x45,0x42,0x24,0x68,0x04,
   0x24,0x81,0x4D,0x24,0x85,0x41,0x24,0x8F,0x03,0x24,0xA4,0x41,0x24,0xE1,0x07,
   0x24,0xEF,0x41,0x25,0x61,0x12,0x25,0x65,0x09,0x25,0xA1,0x1A,0x25,0xAF,0x0D,
   0x25,0xC1,0x0C,0x25,0xC5,0x41,0x25,0xC7,0x42,0x25,0xCD,0x81,0x25,0xCE,0x41,
   0x25,0xCF,0x0E,0x25,0xF4,0x41,0x26,0x41,0x1A,0x26,0x45,0x41,0x26,0x4F,0x07,
   0x26,0x61,0x09,0x26,0x65,0x04,0x26,0x68,0x27,0x26,0x6F,0x03,0x26,0x81,0x26,
   0x26,0x85,0x41,0x26,0x8F,0x47,0x26,0x93,0x04,0x26,0xE1,0x0C,0x27,0x41,0x0A,
   0x27,0x49,0x81,0x28,0xB2,0x41,0x29,0xE8,0x41,0x29,0xEB,0x81,0x2C,0x20,0x25,
   0x2C,0x2D,0x16,0x2C,0x2E,0x13,0x2C,0x33,0x0F,0x2C,0x34,0x0E,0x2C,0xA0,0x0D,
   0x2C,0xA9,0x41,0x2C,0xAD,0x03,0x2C,0xB7,0x81,0x2C,0xBA,0x81,0x2D,0x2D,0x06,
   0x2D,0x2E,0x81,0x2D,0x33,0x03,0x2D,0x34,0x0C,0x2D,0x35,0x81,0x2D,0xE2,0x81,
   0x2D,0xF3,0x86,0x2D,0xF5,0x81,0x2E,0xA2,0x08,0x2E,0xAD,0x82,0x2E,0xAE,0x04,
   0x2E,0xAF,0x02,0x2E,0xB3,0x07,0x34,0x20,0x3F,0x34,0x24,0x44,0x34,0x25,0x83,
   0x34,0x27,0x07,0x34,0x2B,0x43,0x34,0x2E,0x0A,0x34,0x2F,0x81,0x34,0x32,0x4A,
   0x34,0x33,0x08,0x34,0x34,0x24,0x34,0x39,0x03,0x34,0x41,0x41,0x34,0x4F,0x41,
   0x34,0xA0,0x03,0x34,0xA4,0x41,0x34,0xB3,0x81,0x34,0xB4,0x41,0x35,0x20,0x18,
   0x35,0x24,0x82,0x35,0x25,0x81,0x35,0x2E,0x03,0x35,0x33,0x04,0x35,0xE4,0x41,
   0x35,0xEE,0x41,0x35,0xF2,0x0D,0x35,0xF4,0x53,0x35,0xF9,0x41,0x36,0xB2,0x20,
   0x38,0x20,0x0D,0x38,0x22,0x06,0x38,0x24,0x41,0x38,0x27,0x10,0x38,0x2A,0x81,
   0x38,0x32,0x07,0x38,0x33,0x04,0x38,0x34,0x41,0x38,0x35,0x81,0x38,0x3A,0x03,
   0x38,0x41,0x41,0x38,0x45,0x41,0x38,0x81,0x07,0x38,0x8F,0x49,0x38,0xA0,0x07,
   0x38,0xA7,0x82,0x38,0xBA,0x41,0x38,0xE1,0x42,0x39,0x20,0x0C,0x39,0x2B,0x41,
   0x39,0x2E,0x81,0x39,0x33,0x8A,0x39,0xCF,0x42,0x39,0xE0,0x24,0x39,0xE7,0x83,
   0x39,0xE9,0x81,0x39,0xEA,0x02,0x39,0xEE,0x41,0x39,0xF2,0x41,0x39,0xF3,0x41,
   0x39,0xF4,0x81,0x39,0xF9,0x41,0x39,0xFA,0x81,0x3A,0xAD,0x47,0x3A,0xB4,0x41,
   0x3C,0x41,0x06,0x3C,0x45,0x42,0x3C,0x68,0x06,0x3C,0x81,0x0A,0x3C,0x8F,0x41,
   0x3C,0xE1,0x03,0x3D,0x01,0x0A,0x3D,0x03,0x81,0x3D,0x05,0x41,0x3D,0x0E,0x42,
   0x3D,0x12,0x41,0x3D,0x13,0x82,0x3D,0x14,0x41,0x3D,0x15,0x81,0x3D,0x17,0x81,
   0x3D,0x20,0x03,0x3D,0x2E,0x81,0x3D,0x33,0x83,0x3D,0x65,0x42,0x3D,0x69,0x03,
   0x3D,0xA1,0x03,0x3D,0xA5,0x81,0x3D,0xA9,0x0D,0x3D,0xC4,0x07,0x3D,0xC9,0x81,
   0x3D,0xCF,0x08,0x3D,0xE3,0x81,0x3D,0xEB,0x03,0x3D,0xED,0x81,0x3D,0xF3,0x83,
   0x3D,0xF4,0x83,0x3D,0xF7,0x81,0x3E,0x41,0x03,0x3E,0x45,0x81,0x3E,0x49,0x18,
   0x3E,0x4E,0x41,0x3E,0x4F,0x41,0x3E,0x61,0x8A,0x3E,0x65,0x42,0x3E,0x68,0x10,
   0x3E,0x69,0x81,0x3E,0x73,0x81,0x3E,0x81,0x0C,0x3E,0x85,0x81,0x3E,0x8F,0x56,
   0x3E,0xA0,0x06,0x3E,0xA5,0x41,0x3E,0xAE,0x41,0x3E,0xB2,0x42,0x3E,0xE1,0x03,
   0x3F,0x25,0x41,0x3F,0x2F,0x81,0x3F,0x41,0x04,0x3F,0x45,0x81,0x40,0xB2,0x41,
   0x48,0x20,0x3F,0x48,0x22,0x03,0x48,0x24,0x41,0x48,0x29,0x09,0x48,0x2A,0x41,
   0x48,0x2D,0x07,0x48,0x32,0x41,0x48,0x33,0x07,0x48,0x34,0x0C,0x48,0xA0,0x03,
   0x48,0xB4,0x41,0x49,0x20,0x12,0x49,0x22,0x42,0x49,0x24,0x41,0x49,0x2E,0x42,
   0x49,0x34,0x42,0x49,0xCF,0x41,0x49,0xF3,0x41,0x49,0xF4,0x42,0x4A,0x81,0x41,
   0x4A,0xA9,0x42,0x4A,0xAD,0x41,0x4A,0xAE,0x41,0x4C,0x29,0x08,0x4C,0x2D,0x81,
   0x4C,0x32,0x82,0x4C,0x33,0x06,0x4C,0x34,0x09,0x4C,0xA0,0x0A,0x4C,0xB2,0x81,
   0x4C,0xB4,0x41,0x4D,0x09,0x3F,0x4D,0x0F,0x81,0x4D,0x35,0x81,0x4D,0x61,0x41,
   0x4D,0xE2,0x42,0x4D,0xF4,0x41,0x4E,0x61,0x41,0x4E,0xA3,0x83,0x4E,0xA5,0x83,
   0x4E,0xAE,0x06,0x4E,0xB2,0x04,0x50,0x20,0x3F,0x50,0x23,0x82,0x50,0x24,0x03,
   0x50,0x26,0x81,0x50,0x27,0x03,0x50,0x29,0x81,0x50,0x2B,0x27,0x50,0x2D,0x07,
   0x50,0x2E,0x13,0x50,0x32,0x46,0x50,0x33,0x81,0x50,0xA0,0x0D,0x50,0xAE,0x41,
   0x50,0xAF,0x41,0x50,0xB2,0x86,0x50,0xB3,0x81,0x50,0xBA,0x81,0x51,0x2D,0x81,
   0x51,0xE0,0x24,0x51,0xED,0x06,0x54,0x41,0x03,0x54,0x4F,0x07,0x54,0x68,0x20,
   0x54,0x81,0x0C,0x54,0x85,0x03,0x54,0x8F,0x46,0x54,0xAE,0x41,0x54,0xB3,0x81,
   0x54,0xB4,0x81,0x54,0xE1,0x07,0x55,0x20,0x07,0x55,0x34,0x41,0x55,0x4F,0x41,
   0x55,0x6F,0x81,0x55,0x75,0x0E,0x55,0x77,0x41,0x55,0xA1,0x12,0x55,0xA5,0x03,
   0x55,0xA9,0x06,0x55,0xC1,0x08,0x55,0xC5,0x41,0x55,0xC9,0x83,0x55,0xCF,0x07,
   0x56,0x41,0x33,0x56,0x45,0x81,0x56,0x49,0x84,0x56,0x54,0x41,0x56,0x55,0x06,
   0x56,0x61,0x09,0x56,0x65,0x42,0x56,0x68,0x07,0x56,0x81,0x0C,0x56,0x85,0x41,
   0x57,0x25,0x82,0x5C,0x29,0x43,0x5C,0x2B,0x0A,0x5C,0x2E,0x42,0x5C,0x32,0x04,
   0x5C,0x34,0x06,0x64,0x20,0x0F,0x64,0x2E,0x06,0x64,0x2F,0x42,0x64,0x32,0x81,
   0x65,0xF3,0x86,0x65,0xF4,0x81,0x66,0xA1,0x81,0x68,0x22,0x83,0x68,0x2B,0x46,
   0x68,0x2E,0x41,0x68,0x32,0x06,0x69,0x2E,0x41,0x6A,0xAB,0x07};
const unsigned int japan_entries = 494;
/*
 *  Trigram frequency tables for acna.c.
 *  Generated from : *.nam
 *  Written to file : acna.c
 *  Created on : 08/21/01 at 16:43:10
 */
const unsigned char far slavic[] = {
   0x00,0x41,0x11,0x00,0x45,0x0A,0x00,0x49,0x06,0x00,0x4C,0x05,0x00,0x4F,0x13,
   0x00,0x52,0x0A,0x00,0x55,0x0D,0x00,0x65,0x03,0x00,0x68,0x07,0x00,0x69,0x06,
   0x00,0x8F,0x08,0x00,0x95,0x07,0x00,0x99,0x03,0x00,0x9A,0x06,0x00,0xC5,0x04,
   0x00,0xC9,0x03,0x00,0xD2,0x03,0x00,0xE1,0x0D,0x00,0xEF,0x09,0x00,0xF2,0x0D,
   0x00,0xF5,0x06,0x01,0x01,0x08,0x01,0x0F,0x06,0x01,0x15,0x04,0x01,0x41,0x18,
   0x01,0x45,0x04,0x01,0x55,0x03,0x01,0x61,0x17,0x01,0x69,0x05,0x01,0x6F,0x25,
   0x01,0x72,0x19,0x01,0x75,0x10,0x01,0x77,0x02,0x01,0x89,0x05,0x01,0x95,0x07,
   0x01,0xA1,0x26,0x01,0xA9,0x14,0x01,0xB5,0x04,0x01,0xCF,0x03,0x01,0xEC,0x05,
   0x01,0xF2,0x03,0x01,0xF3,0x06,0x02,0x01,0x16,0x02,0x05,0x0B,0x02,0x09,0x0A,
   0x02,0x0F,0x13,0x02,0x12,0x07,0x02,0x15,0x03,0x02,0x19,0x02,0x02,0x41,0x0A,
   0x02,0x55,0x06,0x02,0x61,0x0A,0x02,0x65,0x06,0x02,0x69,0x0A,0x02,0x6B,0x0A,
   0x02,0x6C,0x06,0x02,0x6F,0x0A,0x02,0x74,0x1C,0x02,0x75,0x06,0x02,0x8F,0x09,
   0x02,0x92,0x06,0x02,0x95,0x04,0x02,0xC1,0x06,0x02,0xCF,0x03,0x02,0xE1,0x0E,
   0x02,0xE5,0x03,0x02,0xE9,0x10,0x02,0xEF,0x0A,0x02,0xF2,0x03,0x03,0x21,0x08,
   0x03,0x41,0x0F,0x03,0x45,0x04,0x03,0x55,0x04,0x04,0x45,0x80,0x04,0x52,0x81,
   0x04,0x65,0x46,0x04,0x68,0x09,0x04,0x6B,0x0A,0x04,0x6F,0x80,0x04,0x75,0x81,
   0x04,0x7A,0x09,0x04,0x81,0x04,0x04,0x85,0x03,0x04,0x88,0x80,0x04,0x8F,0x04,
   0x04,0x92,0x80,0x04,0x97,0x80,0x04,0xC9,0x40,0x04,0xE1,0x80,0x04,0xF5,0x80,
   0x05,0x01,0x80,0x05,0x12,0x81,0x05,0x24,0x80,0x05,0x25,0x80,0x05,0x41,0x40,
   0x05,0x4F,0x80,0x05,0x60,0x3F,0x05,0x61,0x81,0x05,0x75,0x81,0x05,0x81,0x06,
   0x05,0x84,0x40,0x05,0x85,0x11,0x05,0x89,0x09,0x05,0x8B,0x03,0x05,0x90,0x80,
   0x05,0x93,0x06,0x05,0x94,0x80,0x05,0x95,0x03,0x05,0xA1,0x03,0x05,0xA2,0x81,
   0x05,0xB3,0x80,0x05,0xC0,0x03,0x05,0xC3,0x08,0x05,0xC5,0x09,0x05,0xC7,0x80,
   0x05,0xC9,0x0F,0x05,0xCB,0x08,0x05,0xCC,0x80,0x05,0xCE,0x80,0x05,0xCF,0x10,
   0x05,0xD3,0x0F,0x05,0xD5,0x82,0x05,0xD9,0x41,0x06,0x01,0x80,0x06,0x03,0x80,
   0x06,0x0C,0x40,0x06,0x12,0x80,0x06,0x15,0x80,0x06,0x41,0x07,0x06,0x42,0x81,
   0x06,0x43,0x06,0x06,0x45,0x43,0x06,0x47,0x80,0x06,0x49,0x03,0x06,0x4B,0x83,
   0x06,0x4C,0x81,0x06,0x4D,0x81,0x06,0x4F,0x05,0x06,0x50,0x81,0x06,0x52,0x80,
   0x06,0x53,0x08,0x06,0x54,0x83,0x06,0x65,0x08,0x06,0x68,0x03,0x06,0x69,0x06,
   0x06,0x6B,0x11,0x06,0x6C,0x82,0x06,0x70,0x80,0x06,0x74,0x81,0x06,0x81,0x81,
   0x06,0x85,0x04,0x06,0x89,0x80,0x06,0xA5,0x40,0x06,0xAC,0x80,0x06,0xB3,0x03,
   0x06,0xC1,0x80,0x06,0xC9,0x07,0x06,0xCF,0x80,0x06,0xD2,0x80,0x06,0xEC,0x83,
   0x06,0xEE,0x80,0x07,0x21,0x40,0x07,0x23,0x80,0x07,0x25,0x40,0x07,0x2B,0x40,
   0x07,0x41,0x80,0x07,0x4F,0x80,0x07,0x55,0x81,0x07,0x57,0x80,0x08,0x23,0x03,
   0x08,0x24,0x80,0x08,0x2E,0x05,0x08,0x32,0x06,0x08,0x34,0x81,0x08,0x39,0x80,
   0x08,0xA1,0x80,0x08,0xA4,0x82,0x08,0xA8,0x80,0x08,0xAA,0x80,0x08,0xB2,0x81,
   0x09,0x2C,0x82,0x09,0x81,0x83,0x09,0xE3,0x81,0x09,0xE4,0x80,0x09,0xE7,0x83,
   0x09,0xED,0x80,0x09,0xF2,0x05,0x09,0xF3,0x04,0x09,0xF5,0x80,0x09,0xF9,0x80,
   0x0A,0x41,0x84,0x0A,0x49,0x80,0x0A,0x4F,0x06,0x0A,0xA4,0x83,0x0A,0xAA,0x80,
   0x0A,0xAB,0x80,0x0A,0xB2,0x04,0x0A,0xB4,0x80,0x0C,0x2C,0x80,0x0C,0xB0,0x80,
   0x0C,0xB2,0x81,0x0C,0xB3,0x80,0x0D,0x00,0x2D,0x0D,0x01,0x0D,0x0D,0x05,0x0B,
   0x0D,0x09,0x09,0x0D,0x0F,0x07,0x0D,0x14,0x80,0x0D,0x15,0x06,0x0D,0x25,0x05,
   0x0D,0x2B,0x49,0x0D,0x30,0x80,0x0D,0x33,0x80,0x0D,0x35,0x40,0x0D,0x60,0x29,
   0x0D,0x61,0x46,0x0D,0x65,0x42,0x0D,0x69,0x64,0x0D,0xF2,0x80,0x0D,0xF6,0x80,
   0x0E,0x55,0x40,0x0E,0x61,0x40,0x0E,0x65,0x80,0x0E,0xB3,0x80,0x10,0x2D,0x03,
   0x10,0x2E,0x04,0x10,0x33,0x40,0x10,0x36,0x80,0x10,0x37,0x80,0x10,0xAD,0x82,
   0x10,0xB7,0x80,0x10,0xBA,0x80,0x11,0x2D,0x80,0x11,0x32,0x80,0x11,0x34,0x40,
   0x11,0xA5,0x80,0x11,0xC1,0x02,0x11,0xE2,0x83,0x11,0xED,0x03,0x11,0xF2,0x03,
   0x11,0xF7,0x06,0x12,0xAA,0x80,0x12,0xAB,0x80,0x13,0x2D,0x80,0x13,0x2E,0x80,
   0x13,0x32,0x80,0x13,0x33,0x80,0x13,0x45,0x02,0x14,0x2B,0x40,0x14,0x41,0x80,
   0x14,0x45,0x80,0x14,0x52,0x80,0x14,0x68,0x04,0x14,0x6B,0x58,0x14,0x6D,0x80,
   0x14,0x6E,0x40,0x14,0x8C,0x80,0x14,0x92,0x80,0x14,0xAB,0x40,0x14,0xE9,0x80,
   0x14,0xF2,0x80,0x15,0x26,0x80,0x15,0x2B,0x80,0x15,0x33,0x80,0x15,0x60,0x3F,
   0x15,0x85,0x07,0x15,0x89,0x04,0x15,0x93,0x04,0x15,0x97,0x80,0x15,0xC4,0x05,
   0x15,0xC5,0x06,0x15,0xC7,0x40,0x15,0xC9,0x03,0x15,0xCB,0x4D,0x15,0xD3,0x09,
   0x15,0xD5,0x80,0x16,0x0B,0x80,0x16,0x41,0x03,0x16,0x45,0x06,0x16,0x4B,0x03,
   0x16,0x4D,0x81,0x16,0x4F,0x03,0x16,0x56,0x80,0x16,0x57,0x40,0x16,0x61,0x40,
   0x16,0x69,0x03,0x16,0x6B,0x51,0x16,0x6F,0x80,0x16,0x70,0x80,0x16,0x73,0x80,
   0x16,0x85,0x40,0x16,0x89,0x40,0x16,0x8F,0x40,0x16,0x92,0x05,0x16,0xC1,0x82,
   0x16,0xC9,0x0A,0x16,0xE9,0x1F,0x16,0xF3,0x14,0x16,0xF9,0x80,0x17,0x25,0x40,
   0x17,0x2B,0x40,0x17,0x4F,0x80,0x17,0x55,0x80,0x18,0x2C,0x81,0x18,0x35,0x80,
   0x18,0xA9,0x80,0x18,0xAC,0x80,0x18,0xAE,0x80,0x18,0xB2,0x80,0x18,0xB4,0x40,
   0x19,0x21,0x80,0x19,0x23,0x40,0x19,0x24,0x80,0x19,0x2C,0x80,0x19,0x34,0x80,
   0x19,0x61,0x40,0x19,0x85,0x80,0x19,0x8F,0x81,0x1A,0x4F,0x81,0x1A,0x65,0x80,
   0x1A,0x6B,0x46,0x1C,0x24,0x80,0x1C,0x2C,0x84,0x1C,0x32,0x83,0x1C,0x34,0x80,
   0x1C,0x37,0x80,0x1C,0xB2,0x81,0x1D,0x2C,0x80,0x1D,0x81,0x40,0x1D,0x85,0x80,
   0x1D,0xC1,0x81,0x1D,0xC5,0x80,0x1D,0xC9,0x80,0x1D,0xE4,0x81,0x1D,0xEC,0x81,
   0x1D,0xF2,0x04,0x1D,0xF4,0x80,0x1D,0xF5,0x80,0x1D,0xF7,0x03,0x1E,0x41,0x82,
   0x1E,0x45,0x83,0x1E,0x49,0x82,0x1E,0x4F,0x83,0x1E,0x55,0x81,0x1E,0x59,0x80,
   0x1E,0xAC,0x80,0x1E,0xB4,0x80,0x1E,0xBA,0x82,0x1F,0x35,0x80,0x20,0x22,0x80,
   0x20,0x24,0x81,0x20,0x2B,0x42,0x20,0x2C,0x05,0x20,0x32,0x03,0x20,0x34,0x80,
   0x20,0x39,0x80,0x20,0xB2,0x81,0x21,0x2E,0x04,0x21,0x81,0x80,0x21,0x85,0x40,
   0x21,0x89,0x40,0x21,0x8F,0x80,0x21,0x99,0x80,0x21,0xA9,0x81,0x21,0xE4,0x80,
   0x21,0xE6,0x80,0x21,0xEA,0x80,0x21,0xF2,0x83,0x21,0xF7,0x04,0x22,0x59,0x80,
   0x22,0xA2,0x80,0x22,0xAB,0x44,0x22,0xAC,0x80,0x22,0xAD,0x80,0x22,0xB4,0x80,
   0x22,0xC9,0x80,0x22,0xE1,0x80,0x23,0x2E,0x40,0x24,0x2C,0x03,0x24,0x49,0x80,
   0x24,0x61,0x40,0x24,0x65,0x42,0x24,0x68,0x69,0x24,0x6B,0x75,0x24,0x6E,0x40,
   0x24,0x8C,0x40,0x24,0x92,0x80,0x24,0xAC,0x0C,0x24,0xAD,0x82,0x24,0xAE,0x04,
   0x24,0xB0,0x80,0x24,0xB2,0x05,0x24,0xB4,0x03,0x24,0xE1,0x80,0x24,0xEE,0x80,
   0x24,0xF5,0x80,0x25,0x0C,0x80,0x25,0x41,0x40,0x25,0x60,0x2E,0x25,0x65,0x80,
   0x25,0x75,0x81,0x25,0x8B,0x80,0x25,0x8F,0x83,0x25,0x93,0x80,0x25,0x9A,0x80,
   0x25,0xA5,0x40,0x25,0xA9,0x81,0x25,0xC9,0x04,0x25,0xCE,0x80,0x25,0xD3,0x31,
   0x26,0x01,0x40,0x26,0x41,0x40,0x26,0x61,0x40,0x26,0x65,0x40,0x26,0x69,0x83,
   0x26,0x6B,0x07,0x26,0x6E,0x83,0x26,0x6F,0x81,0x26,0x83,0x05,0x26,0x88,0x40,
   0x26,0x8C,0x80,0x26,0x8F,0x80,0x26,0x95,0x80,0x26,0x97,0x80,0x26,0x9A,0x56,
   0x26,0xA3,0x40,0x26,0xAB,0x42,0x27,0x49,0x40,0x27,0x4C,0x40,0x27,0x4F,0x80,
   0x28,0x2C,0x80,0x28,0x2E,0x0E,0x28,0x32,0x83,0x28,0x33,0x82,0x28,0xA4,0x80,
   0x28,0xAE,0x80,0x28,0xBA,0x80,0x2A,0xA4,0x80,0x2C,0x23,0x83,0x2C,0x24,0x82,
   0x2C,0x29,0x80,0x2C,0x2A,0x40,0x2C,0x2C,0x06,0x2C,0x2D,0x82,0x2C,0x2E,0x03,
   0x2C,0x32,0x06,0x2C,0x33,0x04,0x2C,0x34,0x80,0x2C,0x37,0x80,0x2C,0x3A,0x81,
   0x2C,0xA0,0x09,0x2C,0xA3,0x40,0x2C,0xA9,0x80,0x2C,0xAD,0x40,0x2C,0xB3,0x80,
   0x2C,0xBA,0x80,0x2D,0x20,0x3F,0x2D,0x23,0x80,0x2D,0x25,0x15,0x2D,0x2D,0x80,
   0x2D,0x2E,0x43,0x2D,0x3A,0x80,0x2D,0x89,0x83,0x2D,0x95,0x80,0x2D,0xA5,0x80,
   0x2D,0xA9,0x80,0x2D,0xE0,0x2C,0x2D,0xEA,0x80,0x2D,0xEB,0x81,0x2D,0xEE,0x83,
   0x2D,0xEF,0x80,0x2D,0xF0,0x83,0x2D,0xF2,0x86,0x2D,0xF4,0x83,0x2D,0xF5,0x80,
   0x2D,0xFA,0x83,0x2E,0x41,0x87,0x2E,0x45,0x83,0x2E,0x55,0x83,0x2E,0x59,0x85,
   0x2E,0x5A,0x83,0x2E,0xA3,0x82,0x2E,0xAB,0x80,0x2E,0xAC,0x06,0x2E,0xB0,0x80,
   0x2E,0xB2,0x83,0x2E,0xB3,0x03,0x30,0x22,0x81,0x30,0x23,0x05,0x30,0x27,0x80,
   0x30,0x29,0x40,0x30,0x2B,0x07,0x30,0x2D,0x80,0x30,0x30,0x81,0x30,0x33,0x08,
   0x30,0x34,0x82,0x30,0x36,0x04,0x30,0x39,0x40,0x30,0x45,0x40,0x30,0x8F,0x40,
   0x30,0xA1,0x80,0x30,0xA3,0x06,0x30,0xA9,0x80,0x30,0xAA,0x80,0x30,0xAE,0x05,
   0x30,0xB0,0x81,0x30,0xB3,0x0B,0x30,0xB4,0x40,0x30,0xB5,0x80,0x30,0xB6,0x04,
   0x30,0xB7,0x0A,0x30,0xB8,0x80,0x30,0xBA,0x81,0x31,0x22,0x80,0x31,0x23,0x0B,
   0x31,0x2D,0x82,0x31,0x2E,0x10,0x31,0x33,0x05,0x31,0x61,0x43,0x31,0x85,0x40,
   0x31,0x8F,0x80,0x31,0xE7,0x80,0x31,0xF0,0x81,0x31,0xF2,0x82,0x31,0xF3,0x07,
   0x31,0xF4,0x80,0x31,0xF6,0x04,0x31,0xF7,0x0A,0x31,0xFA,0x81,0x32,0x05,0x80,
   0x32,0x68,0x80,0x32,0x6B,0x4F,0x32,0xA7,0x80,0x32,0xB0,0x81,0x32,0xBA,0x80,
   0x32,0xE5,0x80,0x34,0x23,0x86,0x34,0x29,0x80,0x34,0x2C,0x88,0x34,0x2D,0x80,
   0x34,0x2E,0x0A,0x34,0x32,0x0A,0x34,0x33,0x07,0x34,0x34,0x85,0x34,0x35,0x40,
   0x34,0x3A,0x83,0x34,0xA3,0x40,0x34,0xA4,0x80,0x34,0xA9,0x80,0x34,0xAB,0x43,
   0x34,0xB3,0x80,0x34,0xBA,0x80,0x35,0x23,0x05,0x35,0x2B,0x82,0x35,0x2C,0x84,
   0x35,0x2E,0x07,0x35,0x32,0x81,0x35,0x33,0x85,0x35,0x3A,0x80,0x35,0xE4,0x80,
   0x35,0xEA,0x80,0x35,0xEC,0x03,0x35,0xEE,0x80,0x35,0xF2,0x04,0x36,0xB4,0x80,
   0x37,0x32,0x80,0x37,0x33,0x82,0x38,0x22,0x80,0x38,0x24,0x81,0x38,0x25,0x80,
   0x38,0x27,0x80,0x38,0x2B,0x45,0x38,0x2D,0x80,0x38,0x30,0x80,0x38,0x32,0x04,
   0x38,0x36,0x80,0x38,0x3A,0x40,0x38,0x68,0x03,0x38,0x69,0x42,0x38,0x8F,0x03,
   0x38,0x92,0x03,0x38,0x94,0x40,0x38,0xA1,0x40,0x38,0xA2,0x80,0x38,0xA3,0x06,
   0x38,0xA4,0x81,0x38,0xA5,0x40,0x38,0xAB,0x4D,0x38,0xAD,0x80,0x38,0xAE,0x40,
   0x39,0x0F,0x40,0x39,0x21,0x0A,0x39,0x23,0x19,0x39,0x25,0x08,0x39,0x2B,0x4D,
   0x39,0x61,0x42,0x39,0xE3,0x40,0x39,0xE8,0x80,0x39,0xF6,0x08,0x3A,0x6B,0x7F,
   0x3A,0x85,0x40,0x3A,0x9A,0x41,0x3B,0x20,0x08,0x3B,0x21,0x40,0x3B,0x23,0x40,
   0x3B,0x25,0x80,0x3B,0x29,0x40,0x3B,0x2B,0x40,0x3B,0x49,0x40,0x3C,0x24,0x80,
   0x3C,0x4F,0x83,0x3C,0x65,0x40,0x3C,0x68,0x03,0x3C,0x6B,0x44,0x3C,0x75,0x80,
   0x3C,0x81,0x40,0x3C,0x82,0x80,0x3C,0x85,0x40,0x3C,0x87,0x80,0x3C,0x92,0x80,
   0x3C,0xB3,0x80,0x3C,0xEF,0x81,0x3C,0xF5,0x81,0x3D,0x0F,0x80,0x3D,0x49,0x80,
   0x3D,0x4E,0x81,0x3D,0x4F,0x80,0x3D,0x54,0x02,0x3D,0x5A,0x80,0x3D,0x61,0x80,
   0x3D,0x65,0x80,0x3D,0x6C,0x40,0x3D,0x81,0x06,0x3D,0x82,0x81,0x3D,0x84,0x80,
   0x3D,0x85,0x06,0x3D,0x89,0x07,0x3D,0x8F,0x06,0x3D,0x94,0x82,0x3D,0xA1,0x06,
   0x3D,0xAF,0x80,0x3D,0xB9,0x80,0x3D,0xC3,0x03,0x3D,0xC9,0x03,0x3D,0xCF,0x04,
   0x3D,0xD3,0x05,0x3D,0xEC,0x80,0x3D,0xEE,0x80,0x3D,0xF2,0x80,0x3E,0x05,0x03,
   0x3E,0x09,0x80,0x3E,0x10,0x80,0x3E,0x35,0x80,0x3E,0x41,0x05,0x3E,0x45,0x06,
   0x3E,0x4C,0x81,0x3E,0x4D,0x80,0x3E,0x4E,0x83,0x3E,0x4F,0x05,0x3E,0x50,0x80,
   0x3E,0x53,0x07,0x3E,0x65,0x04,0x3E,0x68,0x81,0x3E,0x6B,0x5F,0x3E,0x73,0x80,
   0x3E,0x74,0x07,0x3E,0x89,0x40,0x3E,0x8B,0x40,0x3E,0x94,0x80,0x3E,0xC1,0x05,
   0x3E,0xC9,0x19,0x3E,0xCB,0x40,0x3E,0xE1,0x04,0x3E,0xE2,0x80,0x3E,0xE5,0x40,
   0x3E,0xEE,0x40,0x3E,0xF3,0x3F,0x40,0x2C,0x81,0x40,0x2E,0x04,0x40,0x30,0x80,
   0x40,0x32,0x82,0x40,0x33,0x85,0x40,0x34,0x81,0x40,0x37,0x84,0x40,0x3A,0x80,
   0x40,0xAE,0x82,0x40,0xB0,0x80,0x40,0xB4,0x83,0x40,0xBA,0x80,0x41,0x25,0x85,
   0x41,0x2C,0x80,0x41,0x2E,0x05,0x41,0x2F,0x80,0x41,0x33,0x80,0x41,0x85,0x80,
   0x41,0x95,0x80,0x41,0xE3,0x80,0x41,0xEC,0x06,0x41,0xEE,0x80,0x41,0xF2,0x80,
   0x41,0xF3,0x81,0x41,0xF4,0x80,0x41,0xFA,0x81,0x42,0x45,0x80,0x42,0x49,0x81,
   0x42,0x4F,0x81,0x42,0xA3,0x80,0x48,0x23,0x06,0x48,0x24,0x06,0x48,0x27,0x80,
   0x48,0x28,0x80,0x48,0x2E,0x0A,0x48,0x30,0x80,0x48,0x33,0x07,0x48,0x61,0x40,
   0x48,0x68,0x03,0x48,0x81,0x40,0x48,0x89,0x40,0x48,0xA2,0x80,0x48,0xA3,0x03,
   0x48,0xA9,0x80,0x48,0xAD,0x03,0x48,0xB3,0x06,0x48,0xB5,0x80,0x48,0xB6,0x80,
   0x49,0x22,0x80,0x49,0x25,0x80,0x49,0x2B,0x43,0x49,0x30,0x80,0x49,0x34,0x03,
   0x49,0xC9,0x03,0x49,0xCB,0x40,0x49,0xE3,0x03,0x49,0xE5,0x80,0x49,0xE7,0x80,
   0x49,0xE8,0x80,0x49,0xEC,0x81,0x49,0xED,0x85,0x49,0xEE,0x07,0x49,0xF3,0x08,
   0x49,0xF4,0x81,0x49,0xF6,0x04,0x49,0xF7,0x0E,0x49,0xF9,0x80,0x49,0xFA,0x83,
   0x4A,0x05,0x40,0x4A,0x69,0x40,0x4A,0x6B,0x54,0x4A,0x6E,0x40,0x4A,0x9A,0x40,
   0x4A,0xA2,0x81,0x4A,0xA9,0x80,0x4A,0xAB,0x41,0x4A,0xAD,0x80,0x4A,0xB3,0x04,
   0x4A,0xB4,0x80,0x4B,0x33,0x84,0x4C,0x22,0x80,0x4C,0x24,0x81,0x4C,0x2B,0x47,
   0x4C,0x2D,0x81,0x4C,0x32,0x80,0x4C,0x37,0x80,0x4C,0x61,0x40,0x4C,0x65,0x80,
   0x4C,0x68,0x08,0x4C,0xA2,0x80,0x4C,0xA4,0x80,0x4C,0xAB,0x4E,0x4C,0xAD,0x80,
   0x4C,0xAE,0x04,0x4C,0xB2,0x80,0x4C,0xB3,0x80,0x4C,0xB6,0x03,0x4D,0x15,0x80,
   0x4D,0x21,0x04,0x4D,0x22,0x80,0x4D,0x23,0x07,0x4D,0x24,0x80,0x4D,0x25,0x07,
   0x4D,0x2B,0x07,0x4D,0x2E,0x06,0x4D,0x61,0x4C,0x4D,0x65,0x0A,0x4D,0x69,0x7F,
   0x4D,0x6C,0x81,0x4D,0x6F,0x11,0x4D,0x72,0x82,0x4D,0x79,0x7F,0x4D,0xA1,0x40,
   0x4D,0xA5,0x81,0x4D,0xA9,0x80,0x4D,0xAF,0x81,0x4D,0xE2,0x83,0x4D,0xE6,0x80,
   0x4D,0xED,0x80,0x4D,0xEF,0x80,0x4D,0xF3,0x80,0x4D,0xF5,0x80,0x4E,0x05,0x80,
   0x4E,0x09,0x80,0x4E,0x4F,0x80,0x4E,0x55,0x80,0x4E,0x81,0x8B,0x4E,0x85,0x09,
   0x4E,0x89,0x03,0x4E,0x8B,0x40,0x4E,0x8F,0x09,0x4E,0x92,0x09,0x4E,0xAB,0x81,
   0x4E,0xB0,0x82,0x4E,0xB3,0x80,0x4E,0xB9,0x80,0x4E,0xBA,0x80,0x4E,0xC1,0x80,
   0x4E,0xE1,0x80,0x4E,0xE5,0x80,0x4E,0xE9,0x03,0x50,0x22,0x80,0x50,0x23,0x80,
   0x50,0x24,0x80,0x50,0x2B,0x43,0x50,0x2D,0x80,0x50,0x2E,0x84,0x50,0x32,0x84,
   0x50,0x33,0x04,0x50,0x68,0x06,0x50,0x6B,0x40,0x50,0xA6,0x82,0x50,0xA7,0x80,
   0x50,0xAB,0x44,0x50,0xAD,0x80,0x50,0xB3,0x41,0x51,0x0F,0x80,0x51,0x23,0x43,
   0x51,0x32,0x80,0x51,0x33,0x40,0x51,0xEA,0x80,0x51,0xEC,0x81,0x51,0xED,0x86,
   0x51,0xF5,0x80,0x51,0xF7,0x06,0x52,0x41,0x05,0x52,0x4F,0x08,0x52,0x55,0x03,
   0x52,0x8F,0x80,0x52,0xAD,0x80,0x52,0xB2,0x83,0x52,0xB4,0x80,0x52,0xD2,0x80,
   0x53,0x2C,0x80,0x53,0x2E,0x03,0x53,0x40,0x1A,0x54,0x41,0x03,0x54,0x49,0x03,
   0x54,0x55,0x40,0x54,0x65,0x41,0x54,0x68,0x04,0x54,0x89,0x81,0x54,0x8F,0x80,
   0x54,0x92,0x80,0x54,0xAC,0x80,0x54,0xB2,0x40,0x54,0xE1,0x80,0x54,0xEC,0x80,
   0x55,0x05,0x80,0x55,0x21,0x80,0x55,0x2A,0x40,0x55,0x2E,0x80,0x55,0x34,0x80,
   0x55,0x61,0x80,0x55,0x81,0x03,0x55,0xA1,0x80,0x55,0xB0,0x80,0x55,0xC1,0x80,
   0x55,0xC5,0x40,0x55,0xCB,0x40,0x56,0x0E,0x80,0x56,0x0F,0x80,0x56,0x12,0x80,
   0x56,0x14,0x80,0x56,0x43,0x03,0x56,0x44,0x80,0x56,0x45,0x05,0x56,0x4D,0x80,
   0x56,0x4F,0x81,0x56,0x53,0x04,0x56,0x54,0x40,0x56,0x56,0x80,0x56,0x65,0x03,
   0x56,0x69,0x05,0x56,0x6B,0x0A,0x56,0x6E,0x80,0x56,0x6F,0x80,0x56,0x74,0x81,
   0x56,0x83,0x80,0x56,0x85,0x80,0x56,0x93,0x80,0x56,0x9A,0x80,0x56,0xE1,0x80,
   0x57,0x45,0x80,0x57,0x55,0x80,0x58,0x24,0x80,0x58,0x32,0x40,0x58,0x33,0x03,
   0x58,0xA3,0x03,0x58,0xB2,0x80,0x59,0x21,0x40,0x59,0x23,0x60,0x59,0x2C,0x80,
   0x59,0x2E,0x03,0x59,0x34,0x07,0x59,0xE3,0x81,0x59,0xEC,0x80,0x5C,0x2C,0x06,
   0x5C,0x2E,0x04,0x5C,0x32,0x03,0x5C,0x33,0x87,0x5C,0x34,0x80,0x5C,0x37,0x80,
   0x5C,0xA7,0x80,0x5C,0xB2,0x04,0x5C,0xB3,0x80,0x5D,0x23,0x72,0x5D,0x25,0x08,
   0x5D,0x2E,0x06,0x5D,0x32,0x80,0x5D,0x33,0x86,0x5D,0x34,0x0F,0x5D,0x81,0x40,
   0x5D,0x85,0x80,0x5D,0xEA,0x84,0x5D,0xEC,0x85,0x5F,0x25,0x80,0x64,0x2B,0x41,
   0x64,0x2C,0x80,0x64,0x2D,0x80,0x64,0x2E,0x05,0x64,0x32,0x80,0x64,0x33,0x80,
   0x64,0x34,0x80,0x64,0x36,0x80,0x64,0x37,0x80,0x64,0x49,0x80,0x64,0x53,0x80,
   0x64,0x55,0x81,0x64,0xAE,0x80,0x64,0xB2,0x81,0x65,0x73,0x80,0x65,0xA5,0x40,
   0x65,0xAF,0x80,0x65,0xC0,0x05,0x65,0xE4,0x80,0x65,0xEE,0x80,0x66,0x14,0x80,
   0x66,0x55,0x80,0x66,0x59,0x80,0x66,0x61,0x40,0x66,0xB2,0x83,0x66,0xB9,0x40,
   0x68,0x27,0x80,0x68,0x29,0x80,0x68,0x2A,0x81,0x68,0x2B,0x4F,0x68,0x32,0x08,
   0x68,0x34,0x80,0x68,0x36,0x80,0x68,0x37,0x81,0x68,0x39,0x80,0x68,0xA9,0x80,
   0x68,0xAB,0x4D,0x68,0xAC,0x03,0x68,0xAD,0x81,0x68,0xAE,0x05,0x68,0xB2,0x05,
   0x68,0xB4,0x40,0x69,0x23,0x42,0x69,0x2C,0x80,0x69,0x2D,0x80,0x69,0x2E,0x07,
   0x69,0xEC,0x80,0x6A,0xAD,0x80,0x6A,0xB7,0x80};
const unsigned int slavic_entries = 983;
/*
 *  Trigram frequency tables for acna.c.
 *  Generated from : *.nam
 *  Written to file : acna.c
 *  Created on : 08/21/01 at 16:43:10
 */
const unsigned char far spanish[] = {
   0x00,0x23,0x04,0x00,0x27,0x05,0x00,0x2C,0x22,0x00,0x2E,0x06,0x00,0x32,0x0B,
   0x00,0x41,0x18,0x00,0x45,0x0D,0x00,0x4F,0x0B,0x00,0x61,0x2D,0x00,0x65,0x05,
   0x00,0x68,0x08,0x00,0x75,0x06,0x00,0x81,0x05,0x00,0x85,0x1B,0x00,0x89,0x05,
   0x00,0x8F,0x06,0x00,0x95,0x05,0x00,0xAE,0x03,0x00,0xB3,0x0B,0x00,0xC1,0x04,
   0x00,0xC5,0x0D,0x00,0xC9,0x05,0x00,0xCF,0x04,0x00,0xD2,0x04,0x00,0xD5,0x04,
   0x00,0xE1,0x11,0x00,0xE5,0x04,0x00,0xEF,0x08,0x00,0xF5,0x09,0x01,0x05,0x06,
   0x01,0x0F,0x05,0x01,0x41,0x07,0x01,0x55,0x07,0x01,0x81,0x16,0x01,0x85,0x0B,
   0x01,0x89,0x05,0x01,0x8C,0x04,0x01,0x8F,0x0C,0x01,0x95,0x05,0x01,0xA1,0x32,
   0x01,0xA5,0x18,0x01,0xA9,0x08,0x01,0xAF,0x23,0x01,0xC1,0x0B,0x01,0xC5,0x03,
   0x01,0xEC,0x09,0x01,0xF2,0x06,0x02,0x01,0x15,0x02,0x05,0x0F,0x02,0x09,0x08,
   0x02,0x0F,0x09,0x02,0x12,0x05,0x02,0x35,0x0B,0x02,0x41,0x0D,0x02,0x45,0x09,
   0x02,0x49,0x08,0x02,0x4F,0x14,0x02,0x61,0x20,0x02,0x65,0x0B,0x02,0x69,0x03,
   0x02,0x6F,0x0C,0x02,0x75,0x04,0x02,0x81,0x07,0x02,0x8F,0x0B,0x02,0xC1,0x17,
   0x02,0xC5,0x10,0x02,0xC9,0x0C,0x03,0x41,0x04,0x04,0x41,0x09,0x04,0x49,0x80,
   0x04,0x4F,0x43,0x04,0x52,0x05,0x04,0x55,0x80,0x04,0x65,0x06,0x04,0x80,0x03,
   0x04,0x81,0x0B,0x04,0x85,0x03,0x04,0x88,0x80,0x04,0x89,0x07,0x04,0x8F,0x16,
   0x04,0xAC,0x80,0x04,0xC1,0x04,0x04,0xEE,0x80,0x04,0xEF,0x43,0x04,0xF5,0x07,
   0x05,0x01,0x81,0x05,0x09,0x42,0x05,0x0C,0x80,0x05,0x27,0x80,0x05,0x2B,0x81,
   0x05,0x2F,0x80,0x05,0x32,0x80,0x05,0x34,0x41,0x05,0x49,0x81,0x05,0x4A,0x80,
   0x05,0x4F,0x80,0x05,0x54,0x80,0x05,0x6F,0x42,0x05,0x75,0x40,0x05,0x80,0x1A,
   0x05,0x81,0x14,0x05,0x84,0x0D,0x05,0x85,0x18,0x05,0x89,0x87,0x05,0x8B,0x80,
   0x05,0x8C,0x0D,0x05,0x8D,0x87,0x05,0x8F,0x05,0x05,0x94,0x04,0x05,0x96,0x0D,
   0x05,0x9A,0x80,0x05,0xA1,0x09,0x05,0xA2,0x81,0x05,0xA5,0x04,0x05,0xA9,0x04,
   0x05,0xAF,0x04,0x05,0xB0,0x82,0x05,0xB3,0x40,0x05,0xC0,0x0C,0x05,0xC1,0x08,
   0x05,0xC4,0x0A,0x05,0xC5,0x04,0x05,0xC7,0x81,0x05,0xC9,0x06,0x05,0xCB,0x80,
   0x05,0xCC,0x81,0x05,0xCE,0x81,0x05,0xCF,0x4C,0x05,0xD4,0x16,0x05,0xDA,0x04,
   0x06,0x0C,0x80,0x06,0x10,0x40,0x06,0x40,0x1E,0x06,0x41,0x10,0x06,0x42,0x06,
   0x06,0x43,0x85,0x06,0x44,0x0A,0x06,0x45,0x13,0x06,0x47,0x04,0x06,0x49,0x0A,
   0x06,0x4D,0x03,0x06,0x4F,0x08,0x06,0x52,0x1A,0x06,0x53,0x80,0x06,0x56,0x82,
   0x06,0x59,0x40,0x06,0x5A,0x41,0x06,0x60,0x3F,0x06,0x61,0x03,0x06,0x63,0x80,
   0x06,0x6B,0x81,0x06,0x6F,0x41,0x06,0x74,0x83,0x06,0x85,0x03,0x06,0x8C,0x81,
   0x06,0x8F,0x43,0x06,0xA3,0x81,0x06,0xA4,0x80,0x06,0xA7,0x81,0x06,0xA8,0x80,
   0x06,0xAC,0x41,0x06,0xC1,0x08,0x06,0xC5,0x09,0x06,0xC9,0x07,0x06,0xCB,0x80,
   0x07,0x24,0x80,0x07,0x41,0x48,0x07,0x45,0x80,0x08,0x20,0x04,0x08,0x25,0x40,
   0x08,0x29,0x80,0x08,0x2B,0x80,0x08,0x2C,0x0B,0x08,0x2E,0x04,0x08,0x32,0x0C,
   0x08,0x33,0x03,0x08,0x39,0x80,0x08,0x41,0x41,0x08,0xAC,0x03,0x08,0xAE,0x84,
   0x08,0xB3,0x40,0x08,0xB4,0x80,0x08,0xB9,0x80,0x09,0x24,0x80,0x09,0x25,0x80,
   0x09,0xE0,0x04,0x09,0xE1,0x40,0x09,0xEE,0x05,0x09,0xF2,0x05,0x09,0xF3,0x04,
   0x09,0xF5,0x81,0x09,0xF6,0x40,0x0A,0x45,0x04,0x0A,0x4F,0x41,0x0A,0xA3,0x80,
   0x0A,0xA5,0x80,0x0A,0xB3,0x40,0x0A,0xB4,0x40,0x0A,0xB7,0x80,0x0C,0x22,0x85,
   0x0C,0x23,0x80,0x0C,0x2C,0x07,0x0C,0x2D,0x82,0x0C,0x30,0x83,0x0C,0x32,0x95,
   0x0C,0x33,0x08,0x0C,0x34,0x80,0x0C,0x36,0x81,0x0C,0xAE,0x41,0x0C,0xB3,0x41,
   0x0C,0xB4,0x41,0x0D,0x01,0x08,0x0D,0x09,0x04,0x0D,0x12,0x81,0x0D,0x15,0x80,
   0x0D,0x24,0x80,0x0D,0x2C,0x80,0x0D,0x2E,0x81,0x0D,0x2F,0x44,0x0D,0x30,0x40,
   0x0D,0x33,0x80,0x0D,0x61,0x40,0x0D,0x85,0x80,0x0D,0xEC,0x06,0x0D,0xED,0x80,
   0x0D,0xEE,0x04,0x0D,0xF0,0x80,0x0D,0xF2,0x8D,0x0D,0xF5,0x80,0x0D,0xF6,0x81,
   0x0E,0x41,0x81,0x0E,0x45,0x81,0x0E,0x69,0x80,0x0E,0xA3,0x80,0x0E,0xB4,0x40,
   0x10,0x20,0x12,0x10,0x2C,0x05,0x10,0x2D,0x81,0x10,0x32,0x04,0x10,0x33,0x42,
   0x10,0xA0,0x06,0x10,0xA1,0x03,0x10,0xA2,0x80,0x10,0xA3,0x80,0x10,0xA5,0x80,
   0x10,0xAC,0x89,0x10,0xAD,0x81,0x10,0xAE,0x80,0x10,0xB2,0x05,0x10,0xB3,0x08,
   0x10,0xB4,0x81,0x11,0x21,0x06,0x11,0x2E,0x04,0x11,0x2F,0x04,0x11,0x33,0x40,
   0x11,0x34,0x80,0x11,0xE0,0x1E,0x11,0xE9,0x80,0x11,0xEB,0x80,0x11,0xEC,0x40,
   0x11,0xED,0x81,0x11,0xEE,0x0B,0x11,0xF2,0x0A,0x11,0xF3,0x43,0x11,0xF5,0x40,
   0x11,0xF6,0x04,0x12,0x45,0x03,0x12,0x49,0x04,0x12,0x4F,0x04,0x12,0xA3,0x81,
   0x12,0xB2,0x81,0x12,0xB3,0x41,0x14,0x20,0x06,0x14,0x2C,0x42,0x14,0x32,0x80,
   0x14,0x63,0x80,0x14,0x68,0x83,0x14,0x69,0x40,0x14,0x6F,0x41,0x14,0x81,0x05,
   0x14,0x84,0x40,0x14,0x89,0x04,0x14,0x8F,0x09,0x14,0xB3,0x80,0x14,0xE1,0x45,
   0x14,0xE9,0x80,0x15,0x01,0x80,0x15,0x24,0x41,0x15,0x27,0x40,0x15,0x2C,0x40,
   0x15,0x32,0x08,0x15,0x3A,0x40,0x15,0x41,0x04,0x15,0x45,0x81,0x15,0x46,0x80,
   0x15,0x61,0x40,0x15,0x80,0x0B,0x15,0x81,0x10,0x15,0x83,0x80,0x15,0x85,0x07,
   0x15,0x88,0x40,0x15,0x89,0x08,0x15,0x8C,0x12,0x15,0x8F,0x04,0x15,0x93,0x80,
   0x15,0x94,0x80,0x15,0xA9,0x81,0x15,0xC1,0x05,0x15,0xC4,0x0A,0x15,0xC5,0x05,
   0x15,0xC9,0x03,0x15,0xD2,0x82,0x15,0xD4,0x08,0x15,0xD9,0x40,0x15,0xEE,0x41,
   0x16,0x40,0x08,0x16,0x41,0x21,0x16,0x42,0x80,0x16,0x43,0x04,0x16,0x45,0x0C,
   0x16,0x49,0x04,0x16,0x4B,0x80,0x16,0x4C,0x40,0x16,0x4E,0x07,0x16,0x4F,0x59,
   0x16,0x52,0x0C,0x16,0x53,0x40,0x16,0x55,0x80,0x16,0x57,0x80,0x16,0x59,0x40,
   0x16,0x5A,0x40,0x16,0x60,0x3F,0x16,0x70,0x05,0x16,0x71,0x81,0x16,0x74,0x09,
   0x16,0x80,0x04,0x16,0x81,0x42,0x16,0x8F,0x41,0x16,0xC5,0x08,0x18,0x29,0x40,
   0x18,0x2A,0x80,0x18,0x34,0x80,0x18,0x36,0x40,0x18,0xAC,0x04,0x18,0xB2,0x87,
   0x18,0xB3,0x80,0x18,0xC1,0x40,0x19,0x27,0x83,0x19,0x2E,0x80,0x19,0x34,0x40,
   0x19,0x8F,0x82,0x19,0xF3,0x80,0x1A,0x41,0x82,0x1A,0x49,0x81,0x1A,0xB3,0x80,
   0x1C,0x2C,0x84,0x1C,0x2D,0x82,0x1C,0x2E,0x81,0x1C,0x32,0x0E,0x1C,0x33,0x44,
   0x1C,0x34,0x80,0x1C,0x81,0x40,0x1C,0xA9,0x40,0x1C,0xAC,0x81,0x1C,0xAD,0x40,
   0x1C,0xAE,0x81,0x1C,0xB2,0x81,0x1D,0x2F,0x40,0x1D,0x3A,0x40,0x1D,0x85,0x81,
   0x1D,0x89,0x40,0x1D,0xC1,0x80,0x1D,0xC5,0x40,0x1D,0xE0,0x06,0x1D,0xE7,0x81,
   0x1D,0xEE,0x05,0x1E,0x41,0x85,0x1E,0x45,0x81,0x1E,0x49,0x81,0x1E,0x4F,0x03,
   0x1E,0xA5,0x14,0x1E,0xA9,0x08,0x1E,0xB2,0x41,0x20,0x22,0x80,0x20,0x23,0x40,
   0x20,0x26,0x81,0x20,0x2E,0x41,0x20,0x32,0x04,0x20,0x33,0x80,0x20,0x39,0x80,
   0x20,0xA3,0x40,0x20,0xAD,0x40,0x20,0xAE,0x81,0x20,0xB2,0x85,0x20,0xB3,0x80,
   0x21,0x24,0x80,0x21,0x28,0x40,0x21,0x2E,0x80,0x21,0x33,0x40,0x21,0xE4,0x80,
   0x21,0xEA,0x80,0x21,0xF0,0x81,0x21,0xF2,0x81,0x22,0x49,0x81,0x22,0xA9,0x81,
   0x22,0xAB,0x80,0x22,0xAC,0x80,0x23,0x24,0x80,0x24,0x27,0x41,0x24,0x2B,0x80,
   0x24,0x2C,0x42,0x24,0x2D,0x80,0x24,0x2E,0x04,0x24,0x33,0x4A,0x24,0x34,0x80,
   0x24,0x61,0x41,0x24,0x85,0x43,0x24,0x89,0x40,0x24,0x8F,0x41,0x24,0xA3,0x40,
   0x24,0xA4,0x80,0x24,0xB2,0x09,0x24,0xB3,0x40,0x24,0xE9,0x40,0x25,0x01,0x40,
   0x25,0x45,0x80,0x25,0x61,0x42,0x25,0x69,0x80,0x25,0x6F,0x41,0x25,0x80,0x03,
   0x25,0x81,0x07,0x25,0x82,0x40,0x25,0x85,0x04,0x25,0x8B,0x80,0x25,0x8C,0x18,
   0x25,0xA1,0x41,0x25,0xA5,0x03,0x25,0xA9,0x80,0x25,0xC0,0x0C,0x25,0xC1,0x08,
   0x25,0xC8,0x40,0x25,0xC9,0x44,0x25,0xCA,0x80,0x25,0xCE,0x80,0x25,0xCF,0x0A,
   0x25,0xD4,0x05,0x25,0xEC,0x41,0x25,0xEE,0x04,0x25,0xF0,0x81,0x25,0xF3,0x45,
   0x25,0xF6,0x80,0x26,0x01,0x41,0x26,0x35,0x03,0x26,0x41,0x08,0x26,0x45,0x05,
   0x26,0x4F,0x45,0x26,0x60,0x0F,0x26,0x61,0x40,0x26,0x68,0x40,0x26,0x69,0x40,
   0x26,0x6E,0x81,0x26,0x81,0x41,0x26,0x83,0x80,0x26,0x93,0x80,0x26,0xC1,0x07,
   0x26,0xC5,0x09,0x26,0xCF,0x40,0x27,0x21,0x40,0x27,0x40,0x08,0x27,0x5A,0x40,
   0x28,0x20,0x06,0x28,0x29,0x81,0x29,0x2D,0x81,0x29,0xE0,0x07,0x2A,0xB3,0x83,
   0x2A,0xB4,0x80,0x2C,0x2C,0x41,0x2C,0x33,0x45,0x2C,0x36,0x80,0x2C,0xB3,0x40,
   0x2D,0x25,0x80,0x2D,0x33,0x40,0x2D,0xEF,0x80,0x2D,0xF3,0x43,0x2E,0xB3,0x41,
   0x30,0x20,0x1A,0x30,0x24,0x05,0x30,0x25,0x40,0x30,0x27,0x04,0x30,0x2B,0x80,
   0x30,0x2D,0x05,0x30,0x2E,0x0C,0x30,0x2F,0x41,0x30,0x32,0x0B,0x30,0x33,0x49,
   0x30,0x34,0x03,0x30,0x35,0x81,0x30,0x39,0x41,0x30,0x3A,0x07,0x30,0x45,0x81,
   0x30,0x52,0x40,0x30,0x55,0x80,0x30,0x85,0x05,0x30,0x92,0x80,0x30,0xA1,0x81,
   0x30,0xA2,0x80,0x30,0xA3,0x80,0x30,0xA5,0x40,0x30,0xA9,0x80,0x30,0xAB,0x80,
   0x30,0xAE,0x05,0x30,0xAF,0x41,0x30,0xB2,0x08,0x30,0xB3,0x53,0x30,0xB9,0x81,
   0x31,0x0F,0x41,0x31,0x21,0x04,0x31,0x23,0x04,0x31,0x2F,0x41,0x31,0x32,0x80,
   0x31,0x33,0x43,0x31,0x36,0x08,0x31,0x80,0x08,0x31,0x81,0x1F,0x31,0x8F,0x0C,
   0x31,0x95,0x40,0x31,0xA1,0x03,0x31,0xE0,0x0B,0x31,0xE1,0x40,0x31,0xE4,0x81,
   0x31,0xE7,0x81,0x31,0xEE,0x09,0x31,0xF0,0x84,0x31,0xF2,0x07,0x31,0xF3,0x45,
   0x31,0xF5,0x80,0x31,0xF9,0x41,0x31,0xFA,0x80,0x32,0x61,0x80,0x32,0x85,0x40,
   0x32,0x89,0x81,0x32,0x8D,0x80,0x32,0xA3,0x80,0x32,0xC1,0x0A,0x32,0xC5,0x05,
   0x32,0xC9,0x80,0x34,0x22,0x80,0x34,0x24,0x03,0x34,0x25,0x40,0x34,0x28,0x80,
   0x34,0x29,0x81,0x34,0x2C,0x06,0x34,0x2D,0x80,0x34,0x2E,0x08,0x34,0x32,0x19,
   0x34,0x33,0x07,0x34,0x34,0x06,0x34,0x35,0x80,0x34,0x39,0x03,0x34,0x3A,0x41,
   0x34,0xA1,0x40,0x34,0xA3,0x80,0x34,0xAC,0x06,0x34,0xAD,0x80,0x34,0xAE,0x07,
   0x34,0xAF,0x40,0x34,0xB2,0x09,0x34,0xB3,0x03,0x34,0xB4,0x80,0x34,0xB5,0x40,
   0x35,0x25,0x80,0x35,0x2E,0x03,0x35,0x32,0x05,0x35,0x34,0x80,0x35,0xEC,0x84,
   0x35,0xEE,0x12,0x35,0xF2,0x8B,0x35,0xF3,0x03,0x35,0xF9,0x40,0x36,0xA7,0x80,
   0x36,0xAE,0x03,0x36,0xB2,0x81,0x36,0xB3,0x80,0x38,0x20,0x0C,0x38,0x26,0x40,
   0x38,0x27,0x81,0x38,0x32,0x07,0x38,0x33,0x49,0x38,0x68,0x03,0x38,0x6F,0x41,
   0x38,0x72,0x80,0x38,0x81,0x04,0x38,0x85,0x09,0x38,0x8F,0x08,0x38,0x95,0x81,
   0x38,0xB3,0x48,0x38,0xE1,0x41,0x39,0x0F,0x40,0x39,0x25,0x81,0x39,0x2E,0x40,
   0x39,0x2F,0x41,0x39,0x33,0x43,0x39,0x3A,0x41,0x39,0x61,0x40,0x39,0xC1,0x41,
   0x39,0xE8,0x40,0x39,0xF3,0x47,0x39,0xF4,0x41,0x3A,0x6F,0x41,0x3A,0x81,0x0E,
   0x3A,0x85,0x0F,0x3A,0x89,0x06,0x3A,0x8F,0x0A,0x3A,0x9A,0x40,0x3A,0xB3,0x80,
   0x3B,0x21,0x41,0x3B,0x41,0x07,0x3B,0x45,0x40,0x3B,0x4F,0x40,0x3B,0x55,0x80,
   0x3C,0x20,0x02,0x3C,0x32,0x80,0x3C,0x49,0x80,0x3C,0x4C,0x81,0x3C,0x65,0x40,
   0x3C,0x69,0x80,0x3C,0x85,0x80,0x3C,0x8F,0x05,0x3C,0x92,0x84,0x3C,0xC5,0x80,
   0x3C,0xE1,0x41,0x3C,0xE7,0x40,0x3C,0xEF,0x80,0x3D,0x01,0x40,0x3D,0x05,0x80,
   0x3D,0x21,0x40,0x3D,0x34,0x80,0x3D,0x49,0x80,0x3D,0x4C,0x40,0x3D,0x4F,0x80,
   0x3D,0x61,0x42,0x3D,0x80,0x03,0x3D,0x81,0x44,0x3D,0x89,0x0E,0x3D,0x93,0x40,
   0x3D,0xA1,0x07,0x3D,0xA5,0x44,0x3D,0xA9,0x81,0x3D,0xAF,0x41,0x3D,0xC0,0x22,
   0x3D,0xC1,0x0A,0x3D,0xC4,0x04,0x3D,0xC5,0x0B,0x3D,0xC9,0x06,0x3D,0xCE,0x40,
   0x3D,0xD4,0x12,0x3D,0xD5,0x80,0x3E,0x01,0x80,0x3E,0x05,0x05,0x3E,0x10,0x40,
   0x3E,0x40,0x0D,0x3E,0x41,0x0D,0x3E,0x44,0x84,0x3E,0x45,0x07,0x3E,0x46,0x81,
   0x3E,0x49,0x05,0x3E,0x4F,0x08,0x3E,0x50,0x80,0x3E,0x52,0x0A,0x3E,0x54,0x07,
   0x3E,0x59,0x40,0x3E,0x61,0x0E,0x3E,0x65,0x41,0x3E,0x6B,0x80,0x3E,0x74,0x04,
   0x3E,0x81,0x80,0x3E,0x85,0x03,0x3E,0x89,0x40,0x3E,0xA1,0x41,0x3E,0xA3,0x80,
   0x3E,0xB2,0x82,0x3E,0xB3,0x40,0x3E,0xB4,0x81,0x3E,0xC1,0x48,0x3E,0xC9,0x80,
   0x3E,0xF4,0x80,0x3F,0x21,0x42,0x3F,0x25,0x80,0x3F,0x2E,0x40,0x3F,0x41,0x04,
   0x3F,0x4F,0x81,0x40,0x23,0x81,0x40,0x24,0x04,0x40,0x27,0x81,0x40,0x29,0x80,
   0x40,0x2B,0x80,0x40,0x2C,0x03,0x40,0x2E,0x03,0x40,0x30,0x81,0x40,0x32,0x04,
   0x40,0x35,0x40,0x40,0xA3,0x80,0x40,0xAC,0x06,0x40,0xB2,0x0E,0x40,0xB3,0x41,
   0x40,0xB4,0x80,0x41,0x09,0x80,0x41,0x2C,0x82,0x41,0x2E,0x04,0x41,0x2F,0x80,
   0x41,0x32,0x81,0x41,0x81,0x81,0x41,0xEE,0x03,0x41,0xF2,0x04,0x41,0xF4,0x80,
   0x42,0x01,0x41,0x46,0xA5,0x13,0x46,0xA9,0x0E,0x46,0xB2,0x80,0x48,0x20,0x26,
   0x48,0x23,0x03,0x48,0x24,0x09,0x48,0x28,0x40,0x48,0x29,0x03,0x48,0x2B,0x80,
   0x48,0x2C,0x0D,0x48,0x2D,0x08,0x48,0x2E,0x0A,0x48,0x30,0x81,0x48,0x32,0x40,
   0x48,0x33,0x0D,0x48,0x37,0x80,0x48,0x49,0x40,0x48,0x4F,0x03,0x48,0x61,0x04,
   0x48,0x69,0x03,0x48,0x85,0x03,0x48,0x89,0x40,0x48,0x8F,0x0C,0x48,0xA0,0x09,
   0x48,0xA1,0x06,0x48,0xA3,0x81,0x48,0xA5,0x40,0x48,0xA9,0x04,0x48,0xAC,0x06,
   0x48,0xAF,0x40,0x48,0xB2,0x48,0x48,0xB3,0x18,0x48,0xB4,0x43,0x48,0xB5,0x40,
   0x48,0xB9,0x81,0x48,0xBA,0x4E,0x48,0xE1,0x04,0x48,0xE5,0x40,0x49,0x05,0x80,
   0x49,0x0F,0x80,0x49,0x21,0x47,0x49,0x22,0x40,0x49,0x23,0x80,0x49,0x24,0x40,
   0x49,0x26,0x80,0x49,0x27,0x04,0x49,0x2D,0x80,0x49,0x2E,0x05,0x49,0x2F,0x08,
   0x49,0x35,0x41,0x49,0x36,0x84,0x49,0x3A,0x05,0x49,0x65,0x40,0x49,0x85,0x40,
   0x49,0xA5,0x81,0x49,0xA9,0x40,0x49,0xC1,0x07,0x49,0xCF,0x41,0x49,0xE0,0x1F,
   0x49,0xE1,0x40,0x49,0xE2,0x81,0x49,0xE4,0x86,0x49,0xED,0x83,0x49,0xEE,0x12,
   0x49,0xF3,0x13,0x49,0xF4,0x81,0x49,0xF7,0x80,0x49,0xF9,0x40,0x49,0xFA,0x03,
   0x4A,0x01,0x40,0x4A,0x41,0x0A,0x4A,0x45,0x17,0x4A,0x49,0x07,0x4A,0x4F,0x06,
   0x4A,0x55,0x02,0x4A,0x69,0x80,0x4A,0x6F,0x40,0x4A,0x85,0x47,0x4A,0x89,0x04,
   0x4A,0x8F,0x41,0x4A,0x95,0x41,0x4B,0x41,0x41,0x4C,0x22,0x80,0x4C,0x24,0x43,
   0x4C,0x27,0x80,0x4C,0x2B,0x80,0x4C,0x2C,0x0F,0x4C,0x2D,0x82,0x4C,0x2E,0x11,
   0x4C,0x34,0x40,0x4C,0x35,0x81,0x4C,0x36,0x80,0x4C,0x6F,0x81,0x4C,0xA4,0x81,
   0x4C,0xA7,0x83,0x4C,0xB2,0x84,0x4D,0x05,0x80,0x4D,0x09,0x40,0x4D,0x25,0x80,
   0x4D,0x26,0x80,0x4D,0x2C,0x03,0x4D,0x2E,0x42,0x4D,0x33,0x80,0x4D,0x61,0x03,
   0x4D,0x69,0x80,0x4D,0x6F,0x80,0x4D,0x85,0x40,0x4D,0xE3,0x80,0x4D,0xE6,0x80,
   0x4D,0xE8,0x80,0x4D,0xF5,0x82,0x4E,0x01,0x82,0x4E,0x0F,0x40,0x4E,0x35,0x06,
   0x4E,0x41,0x80,0x4E,0x81,0x07,0x4E,0x85,0x05,0x4E,0x89,0x06,0x4E,0x8F,0x03,
   0x4E,0x92,0x04,0x4E,0x99,0x80,0x4E,0xAF,0x80,0x50,0x22,0x82,0x50,0x24,0x40,
   0x50,0x26,0x40,0x50,0x28,0x40,0x50,0x2C,0x07,0x50,0x2E,0x05,0x50,0x33,0x43,
   0x50,0x34,0x80,0x50,0x36,0x82,0x50,0xA0,0x0B,0x50,0xAA,0x80,0x50,0xAC,0x03,
   0x50,0xB2,0x05,0x50,0xB3,0x4C,0x51,0x01,0x40,0x51,0x0F,0x41,0x51,0x20,0x03,
   0x51,0x25,0x04,0x51,0x27,0x40,0x51,0x2E,0x07,0x51,0x2F,0x40,0x51,0x81,0x40,
   0x51,0xEC,0x82,0x51,0xED,0x03,0x51,0xEE,0x04,0x51,0xF2,0x05,0x51,0xF3,0x47,
   0x51,0xF5,0x81,0x51,0xF9,0x41,0x52,0x41,0x04,0x52,0x45,0x04,0x52,0x49,0x40,
   0x52,0x55,0x80,0x52,0xB3,0x40,0x52,0xE5,0x80,0x53,0x2C,0x80,0x53,0x32,0x80,
   0x54,0x20,0x05,0x54,0x2C,0x41,0x54,0x32,0x03,0x54,0x34,0x40,0x54,0x35,0x40,
   0x54,0x42,0x41,0x54,0x45,0x81,0x54,0x49,0x81,0x54,0x6F,0x40,0x54,0x72,0x80,
   0x54,0x75,0x81,0x54,0x81,0x42,0x54,0x85,0x40,0x54,0x89,0x40,0x54,0xA2,0x80,
   0x54,0xA3,0x80,0x54,0xAC,0x04,0x54,0xAE,0x06,0x54,0xB2,0x0B,0x54,0xE1,0x40,
   0x54,0xF5,0x82,0x55,0x27,0x80,0x55,0x2E,0x09,0x55,0x34,0x80,0x55,0x61,0x80,
   0x55,0x85,0x40,0x55,0xA5,0x81,0x55,0xC1,0x40,0x55,0xC4,0x41,0x55,0xC5,0x41,
   0x55,0xC9,0x40,0x55,0xCF,0x41,0x55,0xD4,0x40,0x55,0xED,0x80,0x56,0x12,0x81,
   0x56,0x35,0x40,0x56,0x41,0x05,0x56,0x45,0x03,0x56,0x47,0x81,0x56,0x4F,0x41,
   0x56,0x52,0x81,0x56,0x60,0x07,0x56,0x73,0x40,0x56,0x74,0x05,0x56,0x81,0x40,
   0x56,0x8F,0x40,0x56,0x92,0x80,0x56,0xC5,0x40,0x56,0xE1,0x80,0x57,0x41,0x41,
   0x58,0x20,0x0E,0x58,0x2C,0x12,0x58,0x32,0x11,0x58,0x33,0x07,0x58,0xA0,0x04,
   0x58,0xA1,0x40,0x58,0xA3,0x81,0x58,0xAC,0x0D,0x58,0xAE,0x04,0x58,0xB2,0x0F,
   0x58,0xB3,0x07,0x58,0xB4,0x40,0x59,0x21,0x80,0x59,0x27,0x40,0x59,0x2C,0x0E,
   0x59,0x33,0x40,0x59,0xF5,0x80,0x64,0x2E,0x40,0x64,0x33,0x41,0x64,0x49,0x80,
   0x64,0xB2,0x80,0x64,0xB6,0x80,0x65,0xA1,0x40,0x65,0xCF,0x40,0x66,0x14,0x80,
   0x68,0x20,0x0E,0x68,0x23,0x80,0x68,0x27,0x80,0x68,0x2D,0x80,0x68,0x32,0x08,
   0x68,0x33,0x42,0x68,0x39,0x80,0x68,0xB2,0x41,0x68,0xB3,0x40,0x68,0xB6,0x80,
   0x69,0xA1,0x40,0x69,0xE0,0x04,0x69,0xEB,0x80,0x69,0xEC,0x40,0x69,0xF2,0x80,
   0x6A,0xA9,0x80,0x6A,0xAB,0x80,0x6B,0x41,0x40};
const unsigned int spanish_entries = 968;


#endif