// PH Rom file
//
// Copyright Information:
// 
//                           Copyright (c)
//    Copyright  2002 Fonix Corporation. All rights reserved.
//    Copyright  2000-2001 Force Computers, a Solectron Company. All rights reserved.
//     Digital Equipment Corporation 1996, 1997, 1998. All rights reserved.
// 
//    Restricted Rights: Use, duplication, or disclosure by the U.S.
//    Government is subject to restrictions as set forth in subparagraph
//    (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
//    52.227-14 Alt. III, as applicable.
// 
// 
//    This software is proprietary to and embodies the confidential
//    technology of Fonix Corporation and other parties.
//    Possession, use, or copying of this software and media is authorized
//    only pursuant to a valid written license from Fonix or an
//    authorized sublicensor.
// 
// Based on Dennis Klatt's PHRom File Format  Copyright (c) 1988 by Dennis Klatt
//
// Compile Type: Compiled from (-1/-1)
// Program: PHEdit(5.x)
//

#define CH_PH_PHONEME_COUNT 64
#define CH_PH_PHONEME_NAMES " _ IY UE EY EH A IF IR AX UW UH UC OW WO AO AA AY AW ER M N NX P PV T TV K KV F S SR ZR TJ CH RF Y W L TS DS JJ JV T1 D1 KH YI WU AH XR AR OR 1R WR 2R UR 3R 4R 5R YR X1 X2 X3 X4 X5 "

// Inherent Duration (milliseconds)
const short ch_inhdr_def[] = {
 -1, 	// _
 120, 	// IY
 180, 	// UE
 170, 	// EY
 128, 	// EH
 160, 	// A
 116, 	// IF
 109, 	// IR
 90, 	// AX
 130, 	// UW
 95, 	// UH
 113, 	// UC
 172, 	// OW
 130, 	// WO
 189, 	// AO
 140, 	// AA
 147, 	// AY
 160, 	// AW
 200, 	// ER
 80, 	// M
 113, 	// N
 150, 	// NX
 80, 	// P
 60, 	// PV
 80, 	// T
 60, 	// TV
 86, 	// K
 60, 	// KV
 100, 	// F
 122, 	// S
 113, 	// SR
 70, 	// ZR
 119, 	// TJ
 98, 	// CH
 92, 	// RF
 75, 	// Y
 60, 	// W
 100, 	// L
 130, 	// TS
 130, 	// DS
 130, 	// JJ
 90, 	// JV
 132, 	// T1
 100, 	// D1
 110, 	// KH
 70, 	// YI
 50, 	// WU
 113, 	// AH
 50, 	// XR
 186, 	// AR
 186, 	// OR
 186, 	// 1R
 186, 	// WR
 186, 	// 2R
 237, 	// UR
 235, 	// 3R
 236, 	// 4R
 233, 	// 5R
 364, 	// YR
 50, 	// X1
 90, 	// X2
 150, 	// X3
 4, 	// X4
 4 }; 	//X5

// Minimum Duration (milliseconds)
const short ch_mindur_def[] = {
 -1, 	// _
 60, 	// IY
 90, 	// UE
 120, 	// EY
 64, 	// EH
 80, 	// A
 70, 	// IF
 70, 	// IR
 65, 	// AX
 114, 	// UW
 65, 	// UH
 70, 	// UC
 150, 	// OW
 71, 	// WO
 127, 	// AO
 94, 	// AA
 98, 	// AY
 100, 	// AW
 134, 	// ER
 60, 	// M
 76, 	// N
 101, 	// NX
 54, 	// P
 50, 	// PV
 60, 	// T
 50, 	// TV
 70, 	// K
 50, 	// KV
 67, 	// F
 82, 	// S
 76, 	// SR
 50, 	// ZR
 80, 	// TJ
 66, 	// CH
 62, 	// RF
 50, 	// Y
 50, 	// W
 67, 	// L
 100, 	// TS
 100, 	// DS
 120, 	// JJ
 75, 	// JV
 100, 	// T1
 90, 	// D1
 74, 	// KH
 47, 	// YI
 20, 	// WU
 76, 	// AH
 30, 	// XR
 125, 	// AR
 125, 	// OR
 125, 	// 1R
 125, 	// WR
 125, 	// 2R
 159, 	// UR
 157, 	// 3R
 158, 	// 4R
 156, 	// 5R
 243, 	// YR
 30, 	// X1
 50, 	// X2
 55, 	// X3
 3, 	// X4
 3 };	//X5

// Burst Duration (milliseconds)
const short ch_burdr_def[] = {
 0, 	//_
 0, 	//IY
 0, 	//UE
 0, 	//EY
 0, 	//EH
 0, 	//A
 0, 	//IF
 0, 	//IR
 0, 	//AX
 0, 	//UW
 0, 	//UH
 0, 	//UC
 0, 	//OW
 0, 	//WO
 0, 	//AO
 0, 	//AA
 0, 	//AY
 0, 	//AW
 0, 	//ER
 0, 	//M
 0, 	//N
 0, 	//NX
 25, 	//P
 7, 	//PV
 25, 	//T
 7, 	//TV
 45, 	//K
 7, 	//KV
 0, 	//F
 0, 	//S
 0, 	//SR
 0, 	//ZR
 0, 	//TJ
 0, 	//CH
 0, 	//RF
 0, 	//Y
 0, 	//W
 0, 	//L
 87, 	//TS
 87, 	//DS
 90, 	//JJ
 45, 	//JV
 75, 	//T1
 45, 	//D1
 0, 	//KH
 0, 	//YI
 0, 	//WU
 0, 	//AH
 0, 	//XR
 0, 	//AR
 0, 	//OR
 0, 	//1R
 0, 	//WR
 0, 	//2R
 0, 	//UR
 0, 	//3R
 0, 	//4R
 0, 	//5R
 0, 	//YR
 0, 	//X1
 0, 	//X2
 0, 	//X3
 2, 	//X4
 2 };	//X5

// Beginning Type (1=Front, 2=Back, 3=Rounded, 4=Null, 5=Beginning Rounded, 6=Opened)
const short ch_begtyp_def[] = {
 4, 	// _
 1, 	// IY
 1, 	// UE
 1, 	// EY
 1, 	// EH
 2, 	// A
 1, 	// IF
 3, 	// IR
 2, 	// AX
 3, 	// UW
 3, 	// UH
 2, 	// UC
 3, 	// OW
 3, 	// WO
 5, 	// AO
 2, 	// AA
 2, 	// AY
 6, 	// AW
 6, 	// ER
 4, 	// M
 4, 	// N
 4, 	// NX
 4, 	// P
 4, 	// PV
 4, 	// T
 4, 	// TV
 4, 	// K
 4, 	// KV
 4, 	// F
 4, 	// S
 4, 	// SR
 4, 	// ZR
 4, 	// TJ
 4, 	// CH
 3, 	// RF
 1, 	// Y
 5, 	// W
 5, 	// L
 4, 	// TS
 4, 	// DS
 4, 	// JJ
 4, 	// JV
 4, 	// T1
 4, 	// D1
 4, 	// KH
 1, 	// YI
 3, 	// WU
 2, 	// AH
 3, 	// XR
 2, 	// AR
 3, 	// OR
 3, 	// 1R
 3, 	// WR
 3, 	// 2R
 3, 	// UR
 1, 	// 3R
 2, 	// 4R
 1, 	// 5R
 1, 	// YR
 4, 	// X1
 2, 	// X2
 2, 	// X3
 1, 	// X4
 1 };	// X5

// Ending Type (1=Front, 2=Back, 3=Rounded, 4=Null, 5=Beginning Rounded, 6=Opened)
const short ch_endtyp_def[] = {
 4, 	// _
 1, 	// IY
 1, 	// UE
 1, 	// EY
 1, 	// EH
 2, 	// A
 1, 	// IF
 3, 	// IR
 2, 	// AX
 2, 	// UW
 3, 	// UH
 2, 	// UC
 3, 	// OW
 3, 	// WO
 5, 	// AO
 2, 	// AA
 1, 	// AY
 3, 	// AW
 6, 	// ER
 4, 	// M
 4, 	// N
 4, 	// NX
 4, 	// P
 4, 	// PV
 4, 	// T
 4, 	// TV
 4, 	// K
 4, 	// KV
 4, 	// F
 4, 	// S
 4, 	// SR
 4, 	// ZR
 4, 	// TJ
 4, 	// CH
 3, 	// RF
 1, 	// Y
 5, 	// W
 4, 	// L
 4, 	// TS
 4, 	// DS
 4, 	// JJ
 4, 	// JV
 4, 	// T1
 4, 	// D1
 4, 	// KH
 1, 	// YI
 2, 	// WU
 2, 	// AH
 3, 	// XR
 2, 	// AR
 3, 	// OR
 3, 	// 1R
 3, 	// WR
 3, 	// 2R
 3, 	// UR
 3, 	// 3R
 3, 	// 4R
 3, 	// 5R
 3, 	// YR
 4, 	// X1
 2, 	// X2
 2, 	// X3
 1, 	// X4
 1 };	// X5

// Place of articulation
// FLABIAL		0x0001
// FDENTAL		0x0002
// FPALATL		0x0004
// FALVEL		0x0008
// FVELAR		0x0010
// FGLOTAL		0x0020
// F2BACKI		0x0040
// F2BACKF		0x0080
// FLABIALDENTAL	0x0100
// FPOSTALVEOLAR	0x0200
// FUVULAR		0x0400
// FPHARYNGEAL	0x0800
// FVELARF		0x1000
// FVELARB		0x2000
// FVELARR		0x4000
const short ch_place_def[] = {
 0x0000, 	// _
 0x0080, 	// IY
 0x0000, 	// UE
 0x0080, 	// EY
 0x0000, 	// EH
 0x0000, 	// A
 0x0000, 	// IF
 0x0000, 	// IR
 0x0000, 	// AX
 0x0000, 	// UW
 0x0000, 	// UH
 0x0000, 	// UC
 0x0000, 	// OW
 0x0000, 	// WO
 0x0000, 	// AO
 0x0000, 	// AA
 0x0000, 	// AY
 0x0000, 	// AW
 0x0000, 	// ER
 0x0001, 	// M
 0x0008, 	// N
 0x0010, 	// NX
 0x0001, 	// P
 0x0001, 	// PV
 0x0008, 	// T
 0x0008, 	// TV
 0x0010, 	// K
 0x0010, 	// KV
 0x0001, 	// F
 0x0008, 	// S
 0x0004, 	// SR
 0x0004, 	// ZR
 0x0004, 	// TJ
 0x0010, 	// CH
 0x0000, 	// RF
 0x0000, 	// Y
 0x0000, 	// W
 0x0000, 	// L
 0x0008, 	// TS
 0x0008, 	// DS
 0x0004, 	// JJ
 0x0004, 	// JV
 0x0004, 	// T1
 0x0004, 	// D1
 0x2000, 	// KH
 0x00c0, 	// YI
 0x0000, 	// WU
 0x0000, 	// AH
 0x0000, 	// XR
 0x0000, 	// AR
 0x0000, 	// OR
 0x0000, 	// 1R
 0x0000, 	// WR
 0x0000, 	// 2R
 0x0000, 	// UR
 0x0000, 	// 3R
 0x0000, 	// 4R
 0x0000, 	// 5R
 0x0000, 	// YR
 0x0020, 	// X1
 0x0000, 	// X2
 0x0000, 	// X3
 0x0000, 	// X4
 0x0000 };	// X5

// Feature bits
// FSYLL		0x00000001
// FVOICD		0x00000002
// FVOWEL		0x00000004
// FSON1		0x00000008
// FSONOR		0x00000010
// FOBST		0x00000020
// FPLOSV		0x00000040
// FNASAL		0x00000080
// FCONSON		0x00000100
// FSONCON		0x00000200
// FSON2		0x00000400
// FBURST		0x00000800
// FSTMARK		0x00001000
// FSTOP		0x00002000
// FFLAP		0x00004000
// FLATERAL		0x00008000
// FRETROFLEX	0x00010000
// FNFI1		0x00020000
// FNFI2		0x00040000
// FNFI3		0x00080000
const int ch_featb_def[] = {
 0x00000000, 	// _
 0x0000001f, 	// IY
 0x0000001f, 	// UE
 0x0000001f, 	// EY
 0x0000001f, 	// EH
 0x0000001f, 	// A
 0x0000001f, 	// IF
 0x0001001f, 	// IR
 0x0000001f, 	// AX
 0x0000001f, 	// UW
 0x0000001f, 	// UH
 0x0000001f, 	// UC
 0x0000001f, 	// OW
 0x0000001f, 	// WO
 0x0000071a, 	// AO
 0x0000001f, 	// AA
 0x0000001f, 	// AY
 0x0000001f, 	// AW
 0x0000001f, 	// ER
 0x0000259a, 	// M
 0x0000259a, 	// N
 0x0000059a, 	// NX
 0x00002960, 	// P
 0x00002922, 	// PV
 0x00002960, 	// T
 0x00002922, 	// TV
 0x00002960, 	// K
 0x00002922, 	// KV
 0x00000120, 	// F
 0x00000120, 	// S
 0x00010120, 	// SR
 0x00010122, 	// ZR
 0x00000120, 	// TJ
 0x00000120, 	// CH
 0x0001001f, 	// RF
 0x0000001f, 	// Y
 0x0000071a, 	// W
 0x0000871a, 	// L
 0x00002960, 	// TS
 0x00002922, 	// DS
 0x00002960, 	// JJ
 0x00002922, 	// JV
 0x00012960, 	// T1
 0x00012922, 	// D1
 0x00000120, 	// KH
 0x0000041a, 	// YI
 0x0000041a, 	// WU
 0x0000001f, 	// AH
 0x0001001f, 	// XR
 0x0000001f, 	// AR
 0x0000001f, 	// OR
 0x0000001f, 	// 1R
 0x0000001f, 	// WR
 0x0000001f, 	// 2R
 0x0000001f, 	// UR
 0x0000001f, 	// 3R
 0x0001001f, 	// 4R
 0x0000001f, 	// 5R
 0x0000001f, 	// YR
 0x00000312, 	// X1
 0x0000001f, 	// X2
 0x0000001f, 	// X3
 0x00000000, 	// X4
 0x00000000, 	// X5
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
0 };

// Male - F1,F2,F3,B1,B2,B3,AV data for each phoneme
//     Negative numbers are offsets into maldip table (multi-part formants)
//     Positive numbers are actual values
const short ch_maltar_def[] = {
// ==== F1 ====
 -1, 	// _
 -2, 	// IY
 -6, 	// UE
 -12, 	// EY
 -16, 	// EH
 -20, 	// A
 -24, 	// IF
 448, 	// IR
 -28, 	// AX
 -34, 	// UW
 -38, 	// UH
 -44, 	// UC
 -50, 	// OW
 -54, 	// WO
 350, 	// AO
 -58, 	// AA
 -64, 	// AY
 -72, 	// AW
 -78, 	// ER
 300, 	// M
 290, 	// N
 250, 	// NX
 350, 	// P
 220, 	// PV
 350, 	// T
 600, 	// TV
 280, 	// K
 300, 	// KV
 340, 	// F
 280, 	// S
 450, 	// SR
 -86, 	// ZR
 443, 	// TJ
 500, 	// CH
 -92, 	// RF
 280, 	// Y
 295, 	// W
 300, 	// L
 733, 	// TS
 491, 	// DS
 321, 	// JJ
 280, 	// JV
 472, 	// T1
 524, 	// D1
 280, 	// KH
 330, 	// YI
 450, 	// WU
 -96, 	// AH
 448, 	// XR
 -100, 	// AR
 -108, 	// OR
 -118, 	// 1R
 -128, 	// WR
 -138, 	// 2R
 -146, 	// UR
 -156, 	// 3R
 -166, 	// 4R
 -176, 	// 5R
 -186, 	// YR
 -1, 	// X1
 772, 	// X2
 632, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== F2 ====
 -1, 	// _
 -196, 	// IY
 -200, 	// UE
 -206, 	// EY
 -210, 	// EH
 -214, 	// A
 -218, 	// IF
 1465, 	// IR
 -222, 	// AX
 -228, 	// UW
 -232, 	// UH
 -238, 	// UC
 -244, 	// OW
 -248, 	// WO
 1050, 	// AO
 -252, 	// AA
 -258, 	// AY
 -266, 	// AW
 -272, 	// ER
 1340, 	// M
 1650, 	// N
 1200, 	// NX
 1051, 	// P
 691, 	// PV
 1700, 	// T
 1595, 	// TV
 1790, 	// K
 1400, 	// KV
 1100, 	// F
 1700, 	// S
 -280, 	// SR
 1600, 	// ZR
 2054, 	// TJ
 -1, 	// CH
 -286, 	// RF
 2070, 	// Y
 810, 	// W
 1400, 	// L
 1799, 	// TS
 1492, 	// DS
 1782, 	// JJ
 1963, 	// JV
 -290, 	// T1
 -296, 	// D1
 1259, 	// KH
 2160, 	// YI
 897, 	// WU
 -300, 	// AH
 1465, 	// XR
 -304, 	// AR
 -312, 	// OR
 -322, 	// 1R
 -332, 	// WR
 -342, 	// 2R
 -350, 	// UR
 -360, 	// 3R
 -370, 	// 4R
 -380, 	// 5R
 -390, 	// YR
 -1, 	// X1
 1088, 	// X2
 1211, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== F3 ====
 -1, 	// _
 -400, 	// IY
 -404, 	// UE
 -410, 	// EY
 -414, 	// EH
 -418, 	// A
 -422, 	// IF
 1912, 	// IR
 -426, 	// AX
 -432, 	// UW
 -436, 	// UH
 -442, 	// UC
 -448, 	// OW
 -452, 	// WO
 1400, 	// AO
 -456, 	// AA
 -462, 	// AY
 -470, 	// AW
 -476, 	// ER
 2500, 	// M
 2600, 	// N
 2600, 	// NX
 2150, 	// P
 2177, 	// PV
 2600, 	// T
 1900, 	// TV
 2200, 	// K
 2300, 	// KV
 2080, 	// F
 2650, 	// S
 -484, 	// SR
 2000, 	// ZR
 2530, 	// TJ
 2256, 	// CH
 -490, 	// RF
 2570, 	// Y
 2177, 	// W
 2550, 	// L
 2350, 	// TS
 2500, 	// DS
 2400, 	// JJ
 3000, 	// JV
 -494, 	// T1
 -500, 	// D1
 2256, 	// KH
 3000, 	// YI
 2290, 	// WU
 -504, 	// AH
 1912, 	// XR
 -508, 	// AR
 -516, 	// OR
 -526, 	// 1R
 -536, 	// WR
 -546, 	// 2R
 -554, 	// UR
 -564, 	// 3R
 -574, 	// 4R
 -584, 	// 5R
 -594, 	// YR
 -1, 	// X1
 2352, 	// X2
 2370, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== B1 ====
 -1, 	// _
 60, 	// IY
 110, 	// UE
 70, 	// EY
 44, 	// EH
 81, 	// A
 74, 	// IF
 176, 	// IR
 90, 	// AX
 90, 	// UW
 71, 	// UH
 82, 	// UC
 104, 	// OW
 161, 	// WO
 70, 	// AO
 160, 	// AA
 130, 	// AY
 85, 	// AW
 183, 	// ER
 130, 	// M
 90, 	// N
 130, 	// NX
 200, 	// P
 90, 	// PV
 200, 	// T
 90, 	// TV
 200, 	// K
 90, 	// KV
 200, 	// F
 300, 	// S
 100, 	// SR
 70, 	// ZR
 200, 	// TJ
 180, 	// CH
 70, 	// RF
 50, 	// Y
 90, 	// W
 120, 	// L
 329, 	// TS
 90, 	// DS
 200, 	// JJ
 70, 	// JV
 200, 	// T1
 200, 	// D1
 180, 	// KH
 90, 	// YI
 50, 	// WU
 317, 	// AH
 176, 	// XR
 110, 	// AR
 110, 	// OR
 110, 	// 1R
 110, 	// WR
 110, 	// 2R
 110, 	// UR
 110, 	// 3R
 110, 	// 4R
 110, 	// 5R
 110, 	// YR
 130, 	// X1
 90, 	// X2
 90, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== B2 ====
 -1, 	// _
 100, 	// IY
 120, 	// UE
 111, 	// EY
 47, 	// EH
 62, 	// A
 71, 	// IF
 158, 	// IR
 80, 	// AX
 90, 	// UW
 75, 	// UH
 100, 	// UC
 187, 	// OW
 212, 	// WO
 120, 	// AO
 170, 	// AA
 100, 	// AY
 90, 	// AW
 115, 	// ER
 340, 	// M
 400, 	// N
 600, 	// NX
 180, 	// P
 80, 	// PV
 150, 	// T
 80, 	// TV
 160, 	// K
 120, 	// KV
 120, 	// F
 150, 	// S
 160, 	// SR
 199, 	// ZR
 240, 	// TJ
 250, 	// CH
 250, 	// RF
 200, 	// Y
 110, 	// W
 150, 	// L
 617, 	// TS
 110, 	// DS
 280, 	// JJ
 170, 	// JV
 280, 	// T1
 280, 	// D1
 100, 	// KH
 150, 	// YI
 80, 	// WU
 196, 	// AH
 158, 	// XR
 120, 	// AR
 120, 	// OR
 120, 	// 1R
 120, 	// WR
 120, 	// 2R
 120, 	// UR
 120, 	// 3R
 -604, 	// 4R
 120, 	// 5R
 120, 	// YR
 240, 	// X1
 90, 	// X2
 80, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== B3 ====
 -1, 	// _
 160, 	// IY
 200, 	// UE
 200, 	// EY
 218, 	// EH
 180, 	// A
 223, 	// IF
 285, 	// IR
 180, 	// AX
 140, 	// UW
 137, 	// UH
 176, 	// UC
 246, 	// OW
 302, 	// WO
 150, 	// AO
 140, 	// AA
 230, 	// AY
 150, 	// AW
 250, 	// ER
 250, 	// M
 550, 	// N
 800, 	// NX
 180, 	// P
 130, 	// PV
 250, 	// T
 240, 	// TV
 280, 	// K
 180, 	// KV
 150, 	// F
 150, 	// S
 300, 	// SR
 197, 	// ZR
 300, 	// TJ
 500, 	// CH
 700, 	// RF
 300, 	// Y
 150, 	// W
 110, 	// L
 276, 	// TS
 200, 	// DS
 250, 	// JJ
 250, 	// JV
 250, 	// T1
 250, 	// D1
 500, 	// KH
 220, 	// YI
 80, 	// WU
 536, 	// AH
 285, 	// XR
 250, 	// AR
 250, 	// OR
 250, 	// 1R
 250, 	// WR
 250, 	// 2R
 250, 	// UR
 250, 	// 3R
 187, 	// 4R
 250, 	// 5R
 250, 	// YR
 260, 	// X1
 250, 	// X2
 180, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== AV ====
 0, 	// _
 64, 	// IY
 64, 	// UE
 65, 	// EY
 63, 	// EH
 64, 	// A
 63, 	// IF
 65, 	// IR
 62, 	// AX
 65, 	// UW
 65, 	// UH
 63, 	// UC
 65, 	// OW
 65, 	// WO
 64, 	// AO
 64, 	// AA
 64, 	// AY
 63, 	// AW
 65, 	// ER
 58, 	// M
 58, 	// N
 60, 	// NX
 0, 	// P
 0, 	// PV
 0, 	// T
 0, 	// TV
 0, 	// K
 0, 	// KV
 0, 	// F
 0, 	// S
 0, 	// SR
 64, 	// ZR
 0, 	// TJ
 0, 	// CH
 65, 	// RF
 64, 	// Y
 60, 	// W
 64, 	// L
 0, 	// TS
 40, 	// DS
 0, 	// JJ
 0, 	// JV
 0, 	// T1
 0, 	// D1
 0, 	// KH
 64, 	// YI
 66, 	// WU
 64, 	// AH
 65, 	// XR
 65, 	// AR
 0, 	// OR
 65, 	// 1R
 65, 	// WR
 65, 	// 2R
 65, 	// UR
 65, 	// 3R
 65, 	// 4R
 65, 	// 5R
 65, 	// YR
 51, 	// X1
 61, 	// X2
 62, 	// X3
 0, 	// X4
 0 };	// X5

// Female - F1,F2,F3,B1,B2,B3,AV data for each phoneme
//     Negative numbers are offsets into femdip table (multi-part formants)
//     Positive numbers are actual values
const short ch_femtar_def[] = {
// ==== F1 ====
 -1, 	// _
 -2, 	// IY
 312, 	// UE
 -6, 	// EY
 -12, 	// EH
 -16, 	// A
 -20, 	// IF
 515, 	// IR
 -24, 	// AX
 -30, 	// UW
 -34, 	// UH
 -40, 	// UC
 -46, 	// OW
 -52, 	// WO
 -56, 	// AO
 762, 	// AA
 -62, 	// AY
 -70, 	// AW
 -76, 	// ER
 300, 	// M
 368, 	// N
 280, 	// NX
 350, 	// P
 220, 	// PV
 350, 	// T
 265, 	// TV
 280, 	// K
 250, 	// KV
 340, 	// F
 352, 	// S
 280, 	// SR
 -84, 	// ZR
 443, 	// TJ
 450, 	// CH
 -90, 	// RF
 280, 	// Y
 295, 	// W
 365, 	// L
 733, 	// TS
 491, 	// DS
 350, 	// JJ
 280, 	// JV
 472, 	// T1
 260, 	// D1
 280, 	// KH
 330, 	// YI
 336, 	// WU
 -94, 	// AH
 515, 	// XR
 -1, 	// AR
 -1, 	// OR
 -1, 	// 1R
 -1, 	// WR
 -1, 	// 2R
 -1, 	// UR
 -1, 	// 3R
 -1, 	// 4R
 -1, 	// 5R
 -1, 	// YR
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== F2 ====
 -1, 	// _
 -98, 	// IY
 -102, 	// UE
 -108, 	// EY
 -114, 	// EH
 -118, 	// A
 -122, 	// IF
 1685, 	// IR
 -126, 	// AX
 -132, 	// UW
 -136, 	// UH
 -142, 	// UC
 -148, 	// OW
 -154, 	// WO
 -158, 	// AO
 1182, 	// AA
 -164, 	// AY
 -170, 	// AW
 -176, 	// ER
 1340, 	// M
 1898, 	// N
 1200, 	// NX
 1051, 	// P
 691, 	// PV
 1700, 	// T
 1834, 	// TV
 1790, 	// K
 1800, 	// KV
 1100, 	// F
 1672, 	// S
 1650, 	// SR
 -184, 	// ZR
 2054, 	// TJ
 1156, 	// CH
 -190, 	// RF
 2070, 	// Y
 -194, 	// W
 1340, 	// L
 1799, 	// TS
 1623, 	// DS
 1700, 	// JJ
 1730, 	// JV
 -198, 	// T1
 1730, 	// D1
 1259, 	// KH
 2160, 	// YI
 732, 	// WU
 -204, 	// AH
 1685, 	// XR
 -1, 	// AR
 -1, 	// OR
 -1, 	// 1R
 -1, 	// WR
 -1, 	// 2R
 -1, 	// UR
 -1, 	// 3R
 -1, 	// 4R
 -1, 	// 5R
 -1, 	// YR
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== F3 ====
 -1, 	// _
 -208, 	// IY
 -212, 	// UE
 -216, 	// EY
 -222, 	// EH
 -226, 	// A
 -230, 	// IF
 2199, 	// IR
 -234, 	// AX
 -240, 	// UW
 -244, 	// UH
 -250, 	// UC
 -256, 	// OW
 -262, 	// WO
 -266, 	// AO
 2990, 	// AA
 -272, 	// AY
 -280, 	// AW
 -286, 	// ER
 2500, 	// M
 2990, 	// N
 2600, 	// NX
 2150, 	// P
 2177, 	// PV
 2600, 	// T
 2928, 	// TV
 2200, 	// K
 2500, 	// KV
 2080, 	// F
 2805, 	// S
 2550, 	// SR
 -294, 	// ZR
 2530, 	// TJ
 2256, 	// CH
 -300, 	// RF
 2570, 	// Y
 2177, 	// W
 2935, 	// L
 2576, 	// TS
 2944, 	// DS
 -304, 	// JJ
 2700, 	// JV
 1900, 	// T1
 2700, 	// D1
 2256, 	// KH
 3000, 	// YI
 2290, 	// WU
 -308, 	// AH
 2199, 	// XR
 -1, 	// AR
 -1, 	// OR
 -1, 	// 1R
 -1, 	// WR
 -1, 	// 2R
 -1, 	// UR
 -1, 	// 3R
 -1, 	// 4R
 -1, 	// 5R
 -1, 	// YR
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== B1 ====
 -1, 	// _
 60, 	// IY
 67, 	// UE
 70, 	// EY
 44, 	// EH
 160, 	// A
 177, 	// IF
 176, 	// IR
 90, 	// AX
 90, 	// UW
 71, 	// UH
 82, 	// UC
 104, 	// OW
 161, 	// WO
 90, 	// AO
 107, 	// AA
 130, 	// AY
 110, 	// AW
 183, 	// ER
 130, 	// M
 90, 	// N
 130, 	// NX
 200, 	// P
 90, 	// PV
 200, 	// T
 90, 	// TV
 200, 	// K
 90, 	// KV
 200, 	// F
 200, 	// S
 100, 	// SR
 70, 	// ZR
 200, 	// TJ
 180, 	// CH
 70, 	// RF
 50, 	// Y
 90, 	// W
 70, 	// L
 329, 	// TS
 90, 	// DS
 200, 	// JJ
 70, 	// JV
 200, 	// T1
 70, 	// D1
 180, 	// KH
 90, 	// YI
 50, 	// WU
 317, 	// AH
 176, 	// XR
 -1, 	// AR
 -1, 	// OR
 -1, 	// 1R
 -1, 	// WR
 -1, 	// 2R
 -1, 	// UR
 -1, 	// 3R
 -1, 	// 4R
 -1, 	// 5R
 -1, 	// YR
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== B2 ====
 -1, 	// _
 100, 	// IY
 67, 	// UE
 111, 	// EY
 47, 	// EH
 125, 	// A
 178, 	// IF
 158, 	// IR
 80, 	// AX
 90, 	// UW
 75, 	// UH
 100, 	// UC
 187, 	// OW
 212, 	// WO
 70, 	// AO
 96, 	// AA
 100, 	// AY
 90, 	// AW
 115, 	// ER
 340, 	// M
 200, 	// N
 400, 	// NX
 180, 	// P
 80, 	// PV
 150, 	// T
 80, 	// TV
 160, 	// K
 120, 	// KV
 120, 	// F
 180, 	// S
 160, 	// SR
 199, 	// ZR
 240, 	// TJ
 100, 	// CH
 250, 	// RF
 200, 	// Y
 110, 	// W
 65, 	// L
 617, 	// TS
 110, 	// DS
 280, 	// JJ
 170, 	// JV
 280, 	// T1
 170, 	// D1
 100, 	// KH
 150, 	// YI
 80, 	// WU
 196, 	// AH
 158, 	// XR
 -1, 	// AR
 -1, 	// OR
 -1, 	// 1R
 -1, 	// WR
 -1, 	// 2R
 -1, 	// UR
 -1, 	// 3R
 -1, 	// 4R
 -1, 	// 5R
 -1, 	// YR
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== B3 ====
 -1, 	// _
 160, 	// IY
 84, 	// UE
 200, 	// EY
 218, 	// EH
 203, 	// A
 120, 	// IF
 285, 	// IR
 180, 	// AX
 140, 	// UW
 137, 	// UH
 176, 	// UC
 246, 	// OW
 302, 	// WO
 180, 	// AO
 387, 	// AA
 230, 	// AY
 200, 	// AW
 49, 	// ER
 250, 	// M
 350, 	// N
 500, 	// NX
 180, 	// P
 130, 	// PV
 250, 	// T
 240, 	// TV
 280, 	// K
 180, 	// KV
 150, 	// F
 300, 	// S
 300, 	// SR
 197, 	// ZR
 300, 	// TJ
 500, 	// CH
 700, 	// RF
 300, 	// Y
 150, 	// W
 120, 	// L
 276, 	// TS
 200, 	// DS
 250, 	// JJ
 250, 	// JV
 250, 	// T1
 350, 	// D1
 500, 	// KH
 220, 	// YI
 80, 	// WU
 536, 	// AH
 285, 	// XR
 -1, 	// AR
 -1, 	// OR
 -1, 	// 1R
 -1, 	// WR
 -1, 	// 2R
 -1, 	// UR
 -1, 	// 3R
 -1, 	// 4R
 -1, 	// 5R
 -1, 	// YR
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
// ==== AV ====
 0, 	// _
 64, 	// IY
 64, 	// UE
 65, 	// EY
 63, 	// EH
 64, 	// A
 63, 	// IF
 65, 	// IR
 62, 	// AX
 65, 	// UW
 65, 	// UH
 63, 	// UC
 65, 	// OW
 65, 	// WO
 64, 	// AO
 64, 	// AA
 64, 	// AY
 64, 	// AW
 65, 	// ER
 58, 	// M
 58, 	// N
 60, 	// NX
 0, 	// P
 0, 	// PV
 0, 	// T
 0, 	// TV
 0, 	// K
 0, 	// KV
 0, 	// F
 0, 	// S
 0, 	// SR
 64, 	// ZR
 0, 	// TJ
 0, 	// CH
 65, 	// RF
 64, 	// Y
 60, 	// W
 64, 	// L
 0, 	// TS
 50, 	// DS
 0, 	// JJ
 0, 	// JV
 0, 	// T1
 0, 	// D1
 0, 	// KH
 64, 	// YI
 66, 	// WU
 64, 	// AH
 65, 	// XR
 0, 	// AR
 0, 	// OR
 0, 	// 1R
 0, 	// WR
 0, 	// 2R
 0, 	// UR
 0, 	// 3R
 0, 	// 4R
 0, 	// 5R
 0, 	// YR
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0 };	// X5

// Male - F1,F1T,F2,F2T,F3,F3T,B1,B1T,B2,B2T,B3,B3T,AV,AVT data for Multi-part formants
const short ch_maldip_def[] = {
// ====== Formants Frequencies and duration ======
 0, 	// _
 0, 	// _
 340, 	// IY F1
 40, 	// IY F1 duration
 330, 	// IY F1
 -1, 	// IY F1 duration
 300, 	// UE F1
 10, 	// UE F1 duration
 300, 	// UE F1
 29, 	// UE F1 duration
 300, 	// UE F1
 -1, 	// UE F1 duration
 445, 	// EY F1
 10, 	// EY F1 duration
 376, 	// EY F1
 -1, 	// EY F1 duration
 577, 	// EH F1
 11, 	// EH F1 duration
 611, 	// EH F1
 -1, 	// EH F1 duration
 696, 	// A F1
 45, 	// A F1 duration
 690, 	// A F1
 -1, 	// A F1 duration
 346, 	// IF F1
 34, 	// IF F1 duration
 349, 	// IF F1
 -1, 	// IF F1 duration
 550, 	// AX F1
 30, 	// AX F1 duration
 550, 	// AX F1
 90, 	// AX F1 duration
 550, 	// AX F1
 -1, 	// AX F1 duration
 370, 	// UW F1
 40, 	// UW F1 duration
 340, 	// UW F1
 -1, 	// UW F1 duration
 383, 	// UH F1
 10, 	// UH F1 duration
 588, 	// UH F1
 38, 	// UH F1 duration
 594, 	// UH F1
 -1, 	// UH F1 duration
 391, 	// UC F1
 10, 	// UC F1 duration
 467, 	// UC F1
 67, 	// UC F1 duration
 496, 	// UC F1
 -1, 	// UC F1 duration
 561, 	// OW F1
 10, 	// OW F1 duration
 331, 	// OW F1
 -1, 	// OW F1 duration
 454, 	// WO F1
 19, 	// WO F1 duration
 455, 	// WO F1
 -1, 	// WO F1 duration
 790, 	// AA F1
 33, 	// AA F1 duration
 772, 	// AA F1
 71, 	// AA F1 duration
 790, 	// AA F1
 -1, 	// AA F1 duration
 650, 	// AY F1
 10, 	// AY F1 duration
 650, 	// AY F1
 19, 	// AY F1 duration
 696, 	// AY F1
 56, 	// AY F1 duration
 474, 	// AY F1
 -1, 	// AY F1 duration
 720, 	// AW F1
 40, 	// AW F1 duration
 480, 	// AW F1
 150, 	// AW F1 duration
 475, 	// AW F1
 -1, 	// AW F1 duration
 640, 	// ER F1
 10, 	// ER F1 duration
 631, 	// ER F1
 100, 	// ER F1 duration
 508, 	// ER F1
 190, 	// ER F1 duration
 515, 	// ER F1
 -1, 	// ER F1 duration
 300, 	// ZR F1
 10, 	// ZR F1 duration
 300, 	// ZR F1
 70, 	// ZR F1 duration
 300, 	// ZR F1
 -1, 	// ZR F1 duration
 455, 	// RF F1
 20, 	// RF F1 duration
 375, 	// RF F1
 -1, 	// RF F1 duration
 579, 	// AH F1
 10, 	// AH F1 duration
 659, 	// AH F1
 -1, 	// AH F1 duration
 587, 	// AR F1
 10, 	// AR F1 duration
 727, 	// AR F1
 60, 	// AR F1 duration
 727, 	// AR F1
 120, 	// AR F1 duration
 512, 	// AR F1
 -1, 	// AR F1 duration
 601, 	// OR F1
 10, 	// OR F1 duration
 663, 	// OR F1
 60, 	// OR F1 duration
 679, 	// OR F1
 120, 	// OR F1 duration
 648, 	// OR F1
 160, 	// OR F1 duration
 617, 	// OR F1
 -1, 	// OR F1 duration
 414, 	// 1R F1
 10, 	// 1R F1 duration
 476, 	// 1R F1
 60, 	// 1R F1 duration
 522, 	// 1R F1
 120, 	// 1R F1 duration
 584, 	// 1R F1
 160, 	// 1R F1 duration
 584, 	// 1R F1
 -1, 	// 1R F1 duration
 534, 	// WR F1
 10, 	// WR F1 duration
 595, 	// WR F1
 110, 	// WR F1 duration
 564, 	// WR F1
 140, 	// WR F1 duration
 534, 	// WR F1
 170, 	// WR F1 duration
 503, 	// WR F1
 -1, 	// WR F1 duration
 494, 	// 2R F1
 10, 	// 2R F1 duration
 539, 	// 2R F1
 60, 	// 2R F1 duration
 584, 	// 2R F1
 149, 	// 2R F1 duration
 600, 	// 2R F1
 -1, 	// 2R F1 duration
 347, 	// UR F1
 10, 	// UR F1 duration
 379, 	// UR F1
 69, 	// UR F1 duration
 543, 	// UR F1
 148, 	// UR F1 duration
 543, 	// UR F1
 184, 	// UR F1 duration
 477, 	// UR F1
 -1, 	// UR F1 duration
 334, 	// 3R F1
 10, 	// 3R F1 duration
 334, 	// 3R F1
 31, 	// 3R F1 duration
 492, 	// 3R F1
 69, 	// 3R F1 duration
 527, 	// 3R F1
 118, 	// 3R F1 duration
 509, 	// 3R F1
 -1, 	// 3R F1 duration
 440, 	// 4R F1
 10, 	// 4R F1 duration
 550, 	// 4R F1
 50, 	// 4R F1 duration
 590, 	// 4R F1
 95, 	// 4R F1 duration
 610, 	// 4R F1
 120, 	// 4R F1 duration
 620, 	// 4R F1
 -1, 	// 4R F1 duration
 334, 	// 5R F1
 5, 	// 5R F1 duration
 334, 	// 5R F1
 33, 	// 5R F1 duration
 316, 	// 5R F1
 51, 	// 5R F1 duration
 579, 	// 5R F1
 171, 	// 5R F1 duration
 474, 	// 5R F1
 -1, 	// 5R F1 duration
 176, 	// YR F1
 10, 	// YR F1 duration
 351, 	// YR F1
 101, 	// YR F1 duration
 600, 	// YR F1
 154, 	// YR F1 duration
 557, 	// YR F1
 270, 	// YR F1 duration
 660, 	// YR F1
 -1, 	// YR F1 duration
 2100, 	// IY F2
 40, 	// IY F2 duration
 2140, 	// IY F2
 -1, 	// IY F2 duration
 1896, 	// UE F2
 10, 	// UE F2 duration
 1900, 	// UE F2
 29, 	// UE F2 duration
 1773, 	// UE F2
 -1, 	// UE F2 duration
 1700, 	// EY F2
 10, 	// EY F2 duration
 1950, 	// EY F2
 -1, 	// EY F2 duration
 1795, 	// EH F2
 10, 	// EH F2 duration
 1589, 	// EH F2
 -1, 	// EH F2 duration
 1122, 	// A F2
 45, 	// A F2 duration
 1115, 	// A F2
 -1, 	// A F2 duration
 1316, 	// IF F2
 34, 	// IF F2 duration
 1320, 	// IF F2
 -1, 	// IF F2 duration
 1260, 	// AX F2
 30, 	// AX F2 duration
 1260, 	// AX F2
 90, 	// AX F2 duration
 1260, 	// AX F2
 -1, 	// AX F2 duration
 1060, 	// UW F2
 40, 	// UW F2 duration
 940, 	// UW F2
 -1, 	// UW F2 duration
 908, 	// UH F2
 10, 	// UH F2 duration
 600, 	// UH F2
 38, 	// UH F2 duration
 594, 	// UH F2
 -1, 	// UH F2 duration
 1280, 	// UC F2
 10, 	// UC F2 duration
 1181, 	// UC F2
 67, 	// UC F2 duration
 1358, 	// UC F2
 -1, 	// UC F2 duration
 981, 	// OW F2
 10, 	// OW F2 duration
 662, 	// OW F2
 -1, 	// OW F2 duration
 745, 	// WO F2
 19, 	// WO F2 duration
 740, 	// WO F2
 -1, 	// WO F2 duration
 1264, 	// AA F2
 33, 	// AA F2 duration
 1106, 	// AA F2
 71, 	// AA F2 duration
 1124, 	// AA F2
 -1, 	// AA F2 duration
 1124, 	// AY F2
 10, 	// AY F2 duration
 1088, 	// AY F2
 19, 	// AY F2 duration
 1289, 	// AY F2
 56, 	// AY F2 duration
 2072, 	// AY F2
 -1, 	// AY F2 duration
 1280, 	// AW F2
 40, 	// AW F2 duration
 820, 	// AW F2
 150, 	// AW F2 duration
 810, 	// AW F2
 -1, 	// AW F2 duration
 1133, 	// ER F2
 10, 	// ER F2 duration
 1187, 	// ER F2
 100, 	// ER F2 duration
 1164, 	// ER F2
 190, 	// ER F2 duration
 1302, 	// ER F2
 -1, 	// ER F2 duration
 1300, 	// SR F2
 30, 	// SR F2 duration
 1200, 	// SR F2
 80, 	// SR F2 duration
 1250, 	// SR F2
 -1, 	// SR F2 duration
 1045, 	// RF F2
 20, 	// RF F2 duration
 915, 	// RF F2
 -1, 	// RF F2 duration
 1600, 	// T1 F2
 30, 	// T1 F2 duration
 1500, 	// T1 F2
 80, 	// T1 F2 duration
 1550, 	// T1 F2
 -1, 	// T1 F2 duration
 1500, 	// D1 F2
 10, 	// D1 F2 duration
 1404, 	// D1 F2
 -1, 	// D1 F2 duration
 1301, 	// AH F2
 10, 	// AH F2 duration
 1542, 	// AH F2
 -1, 	// AH F2 duration
 991, 	// AR F2
 10, 	// AR F2 duration
 928, 	// AR F2
 60, 	// AR F2 duration
 995, 	// AR F2
 120, 	// AR F2 duration
 1182, 	// AR F2
 -1, 	// AR F2 duration
 803, 	// OR F2
 10, 	// OR F2 duration
 741, 	// OR F2
 60, 	// OR F2 duration
 725, 	// OR F2
 120, 	// OR F2 duration
 1112, 	// OR F2
 160, 	// OR F2 duration
 1299, 	// OR F2
 -1, 	// OR F2 duration
 1340, 	// 1R F2
 10, 	// 1R F2 duration
 1279, 	// 1R F2
 60, 	// 1R F2 duration
 1155, 	// 1R F2
 120, 	// 1R F2 duration
 1186, 	// 1R F2
 160, 	// 1R F2 duration
 1217, 	// 1R F2
 -1, 	// 1R F2 duration
 902, 	// WR F2
 10, 	// WR F2 duration
 1040, 	// WR F2
 110, 	// WR F2 duration
 1009, 	// WR F2
 140, 	// WR F2 duration
 1132, 	// WR F2
 170, 	// WR F2 duration
 1132, 	// WR F2
 -1, 	// WR F2 duration
 1159, 	// 2R F2
 10, 	// 2R F2 duration
 857, 	// 2R F2
 60, 	// 2R F2 duration
 962, 	// 2R F2
 149, 	// 2R F2 duration
 1023, 	// 2R F2
 -1, 	// 2R F2 duration
 592, 	// UR F2
 10, 	// UR F2 duration
 641, 	// UR F2
 69, 	// UR F2 duration
 1033, 	// UR F2
 148, 	// UR F2 duration
 1082, 	// UR F2
 184, 	// UR F2 duration
 1196, 	// UR F2
 -1, 	// UR F2 duration
 1966, 	// 3R F2
 10, 	// 3R F2 duration
 1914, 	// 3R F2
 31, 	// 3R F2 duration
 1914, 	// 3R F2
 69, 	// 3R F2 duration
 1518, 	// 3R F2
 118, 	// 3R F2 duration
 1457, 	// 3R F2
 -1, 	// 3R F2 duration
 620, 	// 4R F2
 10, 	// 4R F2 duration
 977, 	// 4R F2
 70, 	// 4R F2 duration
 1050, 	// 4R F2
 95, 	// 4R F2 duration
 1098, 	// 4R F2
 120, 	// 4R F2 duration
 1369, 	// 4R F2
 -1, 	// 4R F2 duration
 1720, 	// 5R F2
 5, 	// 5R F2 duration
 1984, 	// 5R F2
 33, 	// 5R F2 duration
 1308, 	// 5R F2
 168, 	// 5R F2 duration
 1352, 	// 5R F2
 208, 	// 5R F2 duration
 1334, 	// 5R F2
 -1, 	// 5R F2 duration
 1528, 	// YR F2
 33, 	// YR F2 duration
 1615, 	// YR F2
 105, 	// YR F2 duration
 1264, 	// YR F2
 241, 	// YR F2 duration
 1282, 	// YR F2
 268, 	// YR F2 duration
 1159, 	// YR F2
 -1, 	// YR F2 duration
 2720, 	// IY F3
 40, 	// IY F3 duration
 2700, 	// IY F3
 -1, 	// IY F3 duration
 2072, 	// UE F3
 10, 	// UE F3 duration
 2177, 	// UE F3
 29, 	// UE F3 duration
 2633, 	// UE F3
 -1, 	// UE F3 duration
 2300, 	// EY F3
 10, 	// EY F3 duration
 2400, 	// EY F3
 -1, 	// EY F3 duration
 2464, 	// EH F3
 11, 	// EH F3 duration
 2447, 	// EH F3
 -1, 	// EH F3 duration
 1928, 	// A F3
 45, 	// A F3 duration
 1935, 	// A F3
 -1, 	// A F3 duration
 2594, 	// IF F3
 34, 	// IF F3 duration
 2600, 	// IF F3
 -1, 	// IF F3 duration
 2600, 	// AX F3
 30, 	// AX F3 duration
 2600, 	// AX F3
 90, 	// AX F3 duration
 2600, 	// AX F3
 -1, 	// AX F3 duration
 2300, 	// UW F3
 40, 	// UW F3 duration
 2300, 	// UW F3
 -1, 	// UW F3 duration
 2132, 	// UH F3
 10, 	// UH F3 duration
 2464, 	// UH F3
 44, 	// UH F3 duration
 2636, 	// UH F3
 -1, 	// UH F3 duration
 2295, 	// UC F3
 11, 	// UC F3 duration
 2293, 	// UC F3
 67, 	// UC F3 duration
 2298, 	// UC F3
 -1, 	// UC F3 duration
 2395, 	// OW F3
 10, 	// OW F3 duration
 2420, 	// OW F3
 -1, 	// OW F3 duration
 2317, 	// WO F3
 19, 	// WO F3 duration
 2248, 	// WO F3
 -1, 	// WO F3 duration
 2072, 	// AA F3
 33, 	// AA F3 duration
 2036, 	// AA F3
 71, 	// AA F3 duration
 2388, 	// AA F3
 -1, 	// AA F3 duration
 2036, 	// AY F3
 10, 	// AY F3 duration
 2177, 	// AY F3
 19, 	// AY F3 duration
 2212, 	// AY F3
 56, 	// AY F3 duration
 2370, 	// AY F3
 -1, 	// AY F3 duration
 2580, 	// AW F3
 30, 	// AW F3 duration
 2800, 	// AW F3
 150, 	// AW F3 duration
 2830, 	// AW F3
 -1, 	// AW F3 duration
 1998, 	// ER F3
 10, 	// ER F3 duration
 1788, 	// ER F3
 100, 	// ER F3 duration
 1514, 	// ER F3
 190, 	// ER F3 duration
 1695, 	// ER F3
 -1, 	// ER F3 duration
 1600, 	// SR F3
 30, 	// SR F3 duration
 1800, 	// SR F3
 80, 	// SR F3 duration
 1900, 	// SR F3
 -1, 	// SR F3 duration
 1800, 	// RF F3
 20, 	// RF F3 duration
 1600, 	// RF F3
 -1, 	// RF F3 duration
 1900, 	// T1 F3
 30, 	// T1 F3 duration
 2100, 	// T1 F3
 80, 	// T1 F3 duration
 2200, 	// T1 F3
 -1, 	// T1 F3 duration
 1808, 	// D1 F3
 10, 	// D1 F3 duration
 1851, 	// D1 F3
 -1, 	// D1 F3 duration
 2284, 	// AH F3
 10, 	// AH F3 duration
 2525, 	// AH F3
 -1, 	// AH F3 duration
 2277, 	// AR F3
 10, 	// AR F3 duration
 2231, 	// AR F3
 60, 	// AR F3 duration
 1930, 	// AR F3
 120, 	// AR F3 duration
 1550, 	// AR F3
 -1, 	// AR F3 duration
 2568, 	// OR F3
 10, 	// OR F3 duration
 2522, 	// OR F3
 60, 	// OR F3 duration
 2367, 	// OR F3
 120, 	// OR F3 duration
 1716, 	// OR F3
 160, 	// OR F3 duration
 1608, 	// OR F3
 -1, 	// OR F3 duration
 2514, 	// 1R F3
 10, 	// 1R F3 duration
 2467, 	// 1R F3
 60, 	// 1R F3 duration
 2236, 	// 1R F3
 120, 	// 1R F3 duration
 1973, 	// 1R F3
 160, 	// 1R F3 duration
 1788, 	// 1R F3
 -1, 	// 1R F3 duration
 2221, 	// WR F3
 10, 	// WR F3 duration
 1516, 	// WR F3
 110, 	// WR F3 duration
 1454, 	// WR F3
 140, 	// WR F3 duration
 1485, 	// WR F3
 170, 	// WR F3 duration
 1408, 	// WR F3
 -1, 	// WR F3 duration
 1854, 	// 2R F3
 10, 	// 2R F3 duration
 2232, 	// 2R F3
 60, 	// 2R F3 duration
 1658, 	// 2R F3
 149, 	// 2R F3 duration
 1582, 	// 2R F3
 -1, 	// 2R F3 duration
 2290, 	// UR F3
 10, 	// UR F3 duration
 2225, 	// UR F3
 69, 	// UR F3 duration
 1751, 	// UR F3
 148, 	// UR F3 duration
 1621, 	// UR F3
 184, 	// UR F3 duration
 1408, 	// UR F3
 -1, 	// UR F3 duration
 2756, 	// 3R F3
 10, 	// 3R F3 duration
 2844, 	// 3R F3
 31, 	// 3R F3 duration
 2265, 	// 3R F3
 69, 	// 3R F3 duration
 2036, 	// 3R F3
 118, 	// 3R F3 duration
 1931, 	// 3R F3
 -1, 	// 3R F3 duration
 2817, 	// 4R F3
 10, 	// 4R F3 duration
 2780, 	// 4R F3
 40, 	// 4R F3 duration
 2138, 	// 4R F3
 95, 	// 4R F3 duration
 1667, 	// 4R F3
 120, 	// 4R F3 duration
 1576, 	// 4R F3
 -1, 	// 4R F3 duration
 2352, 	// 5R F3
 5, 	// 5R F3 duration
 2159, 	// 5R F3
 33, 	// 5R F3 duration
 2194, 	// 5R F3
 91, 	// 5R F3 duration
 1650, 	// 5R F3
 192, 	// 5R F3 duration
 1615, 	// 5R F3
 -1, 	// 5R F3 duration
 1900, 	// YR F3
 44, 	// YR F3 duration
 1958, 	// YR F3
 51, 	// YR F3 duration
 2176, 	// YR F3
 100, 	// YR F3 duration
 2102, 	// YR F3
 161, 	// YR F3 duration
 1717, 	// YR F3
 -1, 	// YR F3 duration
// ====== Bandwidths and duration ======
 45, 	// 4R B2
 10, 	// 4R B2 duration
 99, 	// 4R B2
 40, 	// 4R B2 duration
 120, 	// 4R B2
 -1, 	// 4R B2 duration
// ====== Amplitude of Voicing ======
 0};

// Female diphthongs
const short ch_femdip_def[] = {
// ====== Formants Frequencies and duration ======
 0, 	// _
 0, 	// _
 391, 	// IY F1
 40, 	// IY F1 duration
 380, 	// IY F1
 -1, 	// IY F1 duration
 598, 	// EY F1
 10, 	// EY F1 duration
 552, 	// EY F1
 160, 	// EY F1 duration
 529, 	// EY F1
 -1, 	// EY F1 duration
 664, 	// EH F1
 11, 	// EH F1 duration
 703, 	// EH F1
 -1, 	// EH F1 duration
 800, 	// A F1
 10, 	// A F1 duration
 794, 	// A F1
 -1, 	// A F1 duration
 398, 	// IF F1
 10, 	// IF F1 duration
 401, 	// IF F1
 -1, 	// IF F1 duration
 633, 	// AX F1
 30, 	// AX F1 duration
 633, 	// AX F1
 90, 	// AX F1 duration
 633, 	// AX F1
 -1, 	// AX F1 duration
 426, 	// UW F1
 40, 	// UW F1 duration
 391, 	// UW F1
 -1, 	// UW F1 duration
 440, 	// UH F1
 10, 	// UH F1 duration
 676, 	// UH F1
 38, 	// UH F1 duration
 683, 	// UH F1
 -1, 	// UH F1 duration
 450, 	// UC F1
 10, 	// UC F1 duration
 537, 	// UC F1
 67, 	// UC F1 duration
 570, 	// UC F1
 -1, 	// UC F1 duration
 588, 	// OW F1
 10, 	// OW F1 duration
 554, 	// OW F1
 105, 	// OW F1 duration
 375, 	// OW F1
 -1, 	// OW F1 duration
 522, 	// WO F1
 19, 	// WO F1 duration
 523, 	// WO F1
 -1, 	// WO F1 duration
 696, 	// AO F1
 10, 	// AO F1 duration
 690, 	// AO F1
 100, 	// AO F1 duration
 620, 	// AO F1
 -1, 	// AO F1 duration
 840, 	// AY F1
 70, 	// AY F1 duration
 886, 	// AY F1
 130, 	// AY F1 duration
 610, 	// AY F1
 210, 	// AY F1 duration
 610, 	// AY F1
 -1, 	// AY F1 duration
 816, 	// AW F1
 110, 	// AW F1 duration
 633, 	// AW F1
 230, 	// AW F1 duration
 633, 	// AW F1
 -1, 	// AW F1 duration
 736, 	// ER F1
 10, 	// ER F1 duration
 726, 	// ER F1
 100, 	// ER F1 duration
 584, 	// ER F1
 269, 	// ER F1 duration
 592, 	// ER F1
 -1, 	// ER F1 duration
 393, 	// ZR F1
 10, 	// ZR F1 duration
 440, 	// ZR F1
 48, 	// ZR F1 duration
 540, 	// ZR F1
 -1, 	// ZR F1 duration
 455, 	// RF F1
 20, 	// RF F1 duration
 375, 	// RF F1
 -1, 	// RF F1 duration
 580, 	// AH F1
 10, 	// AH F1 duration
 660, 	// AH F1
 -1, 	// AH F1 duration
 2415, 	// IY F2
 40, 	// IY F2 duration
 2461, 	// IY F2
 -1, 	// IY F2 duration
 1893, 	// UE F2
 10, 	// UE F2 duration
 2123, 	// UE F2
 133, 	// UE F2 duration
 2123, 	// UE F2
 -1, 	// UE F2 duration
 1978, 	// EY F2
 10, 	// EY F2 duration
 2300, 	// EY F2
 160, 	// EY F2 duration
 2300, 	// EY F2
 -1, 	// EY F2 duration
 2064, 	// EH F2
 10, 	// EH F2 duration
 1827, 	// EH F2
 -1, 	// EH F2 duration
 1290, 	// A F2
 10, 	// A F2 duration
 1282, 	// A F2
 -1, 	// A F2 duration
 1513, 	// IF F2
 10, 	// IF F2 duration
 1518, 	// IF F2
 -1, 	// IF F2 duration
 1449, 	// AX F2
 30, 	// AX F2 duration
 1449, 	// AX F2
 90, 	// AX F2 duration
 1449, 	// AX F2
 -1, 	// AX F2 duration
 1219, 	// UW F2
 40, 	// UW F2 duration
 966, 	// UW F2
 -1, 	// UW F2 duration
 1044, 	// UH F2
 10, 	// UH F2 duration
 690, 	// UH F2
 38, 	// UH F2 duration
 683, 	// UH F2
 -1, 	// UH F2 duration
 1472, 	// UC F2
 10, 	// UC F2 duration
 1358, 	// UC F2
 67, 	// UC F2 duration
 1562, 	// UC F2
 -1, 	// UC F2 duration
 1380, 	// OW F2
 10, 	// OW F2 duration
 1209, 	// OW F2
 105, 	// OW F2 duration
 995, 	// OW F2
 -1, 	// OW F2 duration
 857, 	// WO F2
 19, 	// WO F2 duration
 851, 	// WO F2
 -1, 	// WO F2 duration
 1122, 	// AO F2
 10, 	// AO F2 duration
 1122, 	// AO F2
 100, 	// AO F2 duration
 1170, 	// AO F2
 -1, 	// AO F2 duration
 1380, 	// AY F2
 90, 	// AY F2 duration
 2128, 	// AY F2
 210, 	// AY F2 duration
 2128, 	// AY F2
 -1, 	// AY F2 duration
 1380, 	// AW F2
 110, 	// AW F2 duration
 943, 	// AW F2
 225, 	// AW F2 duration
 943, 	// AW F2
 -1, 	// AW F2 duration
 1303, 	// ER F2
 10, 	// ER F2 duration
 1365, 	// ER F2
 100, 	// ER F2 duration
 1339, 	// ER F2
 269, 	// ER F2 duration
 1497, 	// ER F2
 -1, 	// ER F2 duration
 1528, 	// ZR F2
 10, 	// ZR F2 duration
 1450, 	// ZR F2
 48, 	// ZR F2 duration
 1350, 	// ZR F2
 -1, 	// ZR F2 duration
 1045, 	// RF F2
 20, 	// RF F2 duration
 915, 	// RF F2
 -1, 	// RF F2 duration
 810, 	// W F2
 10, 	// W F2 duration
 -1, 	// W F2
 -1, 	// W F2 duration
 1600, 	// T1 F2
 30, 	// T1 F2 duration
 1500, 	// T1 F2
 80, 	// T1 F2 duration
 1550, 	// T1 F2
 -1, 	// T1 F2 duration
 1305, 	// AH F2
 10, 	// AH F2 duration
 1550, 	// AH F2
 -1, 	// AH F2 duration
 3128, 	// IY F3
 40, 	// IY F3 duration
 3105, 	// IY F3
 -1, 	// IY F3 duration
 2349, 	// UE F3
 23, 	// UE F3 duration
 -1, 	// UE F3
 -1, 	// UE F3 duration
 2783, 	// EY F3
 10, 	// EY F3 duration
 2900, 	// EY F3
 160, 	// EY F3 duration
 2900, 	// EY F3
 -1, 	// EY F3 duration
 2834, 	// EH F3
 11, 	// EH F3 duration
 2814, 	// EH F3
 -1, 	// EH F3 duration
 2217, 	// A F3
 10, 	// A F3 duration
 2225, 	// A F3
 -1, 	// A F3 duration
 2983, 	// IF F3
 10, 	// IF F3 duration
 2990, 	// IF F3
 -1, 	// IF F3 duration
 2990, 	// AX F3
 30, 	// AX F3 duration
 2990, 	// AX F3
 90, 	// AX F3 duration
 2990, 	// AX F3
 -1, 	// AX F3 duration
 2645, 	// UW F3
 40, 	// UW F3 duration
 2645, 	// UW F3
 -1, 	// UW F3 duration
 2452, 	// UH F3
 10, 	// UH F3 duration
 2834, 	// UH F3
 44, 	// UH F3 duration
 3031, 	// UH F3
 -1, 	// UH F3 duration
 2639, 	// UC F3
 11, 	// UC F3 duration
 2637, 	// UC F3
 67, 	// UC F3 duration
 2643, 	// UC F3
 -1, 	// UC F3 duration
 2875, 	// OW F3
 10, 	// OW F3 duration
 2763, 	// OW F3
 105, 	// OW F3 duration
 2735, 	// OW F3
 -1, 	// OW F3 duration
 2665, 	// WO F3
 19, 	// WO F3 duration
 2585, 	// WO F3
 -1, 	// WO F3 duration
 1928, 	// AO F3
 10, 	// AO F3 duration
 1935, 	// AO F3
 100, 	// AO F3 duration
 2600, 	// AO F3
 -1, 	// AO F3 duration
 3082, 	// AY F3
 120, 	// AY F3 duration
 2703, 	// AY F3
 170, 	// AY F3 duration
 2818, 	// AY F3
 210, 	// AY F3 duration
 2818, 	// AY F3
 -1, 	// AY F3 duration
 3048, 	// AW F3
 120, 	// AW F3 duration
 2933, 	// AW F3
 230, 	// AW F3 duration
 2933, 	// AW F3
 -1, 	// AW F3 duration
 2298, 	// ER F3
 10, 	// ER F3 duration
 2056, 	// ER F3
 100, 	// ER F3 duration
 1741, 	// ER F3
 269, 	// ER F3 duration
 1949, 	// ER F3
 -1, 	// ER F3 duration
 1700, 	// ZR F3
 10, 	// ZR F3 duration
 1800, 	// ZR F3
 48, 	// ZR F3 duration
 2200, 	// ZR F3
 -1, 	// ZR F3 duration
 1800, 	// RF F3
 20, 	// RF F3 duration
 1600, 	// RF F3
 -1, 	// RF F3 duration
 2750, 	// JJ F3
 70, 	// JJ F3 duration
 2200, 	// JJ F3
 -1, 	// JJ F3 duration
 2290, 	// AH F3
 10, 	// AH F3 duration
 2525, 	// AH F3
 -1, 	// AH F3 duration
// ====== Bandwidths and duration ======
// ====== Amplitude of Voicing ======
 0};

// Offsets into Amplitude data
const short ch_ptram_def[] = {
 0, 	// _
 0, 	// IY
 0, 	// UE
 0, 	// EY
 0, 	// EH
 0, 	// A
 0, 	// IF
 0, 	// IR
 0, 	// AX
 0, 	// UW
 0, 	// UH
 0, 	// UC
 0, 	// OW
 0, 	// WO
 0, 	// AO
 0, 	// AA
 0, 	// AY
 0, 	// AW
 0, 	// ER
 0, 	// M
 0, 	// N
 0, 	// NX
 0, 	// P
 0, 	// PV
 0, 	// T
 0, 	// TV
 0, 	// K
 0, 	// KV
 0, 	// F
 0, 	// S
 1, 	// SR
 0, 	// ZR
 0, 	// TJ
 0, 	// CH
 0, 	// RF
 0, 	// Y
 0, 	// W
 0, 	// L
 0, 	// TS
 0, 	// DS
 0, 	// JJ
 0, 	// JV
 0, 	// T1
 0, 	// D1
 0, 	// KH
 0, 	// YI
 0, 	// WU
 0, 	// AH
 0, 	// XR
 0, 	// AR
 0, 	// OR
 0, 	// 1R
 0, 	// WR
 0, 	// 2R
 0, 	// UR
 0, 	// 3R
 0, 	// 4R
 0, 	// 5R
 0, 	// YR
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0 };	// X5

// Offsets into Locus data
const short ch_plocu_def[] = {
// ==== Front ====
 0, 	// _
 0, 	// IY
 0, 	// UE
 0, 	// EY
 0, 	// EH
 0, 	// A
 0, 	// IF
 0, 	// IR
 0, 	// AX
 0, 	// UW
 0, 	// UH
 0, 	// UC
 0, 	// OW
 0, 	// WO
 0, 	// AO
 0, 	// AA
 0, 	// AY
 0, 	// AW
 0, 	// ER
 1, 	// M
 10, 	// N
 19, 	// NX
 28, 	// P
 37, 	// PV
 46, 	// T
 55, 	// TV
 64, 	// K
 73, 	// KV
 82, 	// F
 91, 	// S
 100, 	// SR
 109, 	// ZR
 118, 	// TJ
 127, 	// CH
 0, 	// RF
 0, 	// Y
 0, 	// W
 0, 	// L
 136, 	// TS
 145, 	// DS
 154, 	// JJ
 163, 	// JV
 172, 	// T1
 181, 	// D1
 190, 	// KH
 0, 	// YI
 0, 	// WU
 0, 	// AH
 0, 	// XR
 0, 	// AR
 0, 	// OR
 0, 	// 1R
 0, 	// WR
 0, 	// 2R
 0, 	// UR
 0, 	// 3R
 0, 	// 4R
 0, 	// 5R
 0, 	// YR
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
// ==== Back ====
 0, 	// _
 0, 	// IY
 0, 	// UE
 0, 	// EY
 0, 	// EH
 0, 	// A
 0, 	// IF
 0, 	// IR
 0, 	// AX
 0, 	// UW
 0, 	// UH
 0, 	// UC
 0, 	// OW
 0, 	// WO
 0, 	// AO
 0, 	// AA
 0, 	// AY
 0, 	// AW
 0, 	// ER
 199, 	// M
 208, 	// N
 217, 	// NX
 226, 	// P
 235, 	// PV
 244, 	// T
 253, 	// TV
 262, 	// K
 271, 	// KV
 280, 	// F
 289, 	// S
 298, 	// SR
 307, 	// ZR
 316, 	// TJ
 325, 	// CH
 0, 	// RF
 0, 	// Y
 0, 	// W
 0, 	// L
 334, 	// TS
 343, 	// DS
 352, 	// JJ
 361, 	// JV
 370, 	// T1
 379, 	// D1
 388, 	// KH
 0, 	// YI
 0, 	// WU
 0, 	// AH
 0, 	// XR
 0, 	// AR
 0, 	// OR
 0, 	// 1R
 0, 	// WR
 0, 	// 2R
 0, 	// UR
 0, 	// 3R
 0, 	// 4R
 0, 	// 5R
 0, 	// YR
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
// ==== Round ====
 0, 	// _
 0, 	// IY
 0, 	// UE
 0, 	// EY
 0, 	// EH
 0, 	// A
 0, 	// IF
 0, 	// IR
 0, 	// AX
 0, 	// UW
 0, 	// UH
 0, 	// UC
 0, 	// OW
 0, 	// WO
 0, 	// AO
 0, 	// AA
 0, 	// AY
 0, 	// AW
 0, 	// ER
 397, 	// M
 406, 	// N
 415, 	// NX
 424, 	// P
 433, 	// PV
 442, 	// T
 451, 	// TV
 460, 	// K
 469, 	// KV
 478, 	// F
 487, 	// S
 496, 	// SR
 505, 	// ZR
 514, 	// TJ
 523, 	// CH
 0, 	// RF
 0, 	// Y
 0, 	// W
 0, 	// L
 532, 	// TS
 541, 	// DS
 550, 	// JJ
 559, 	// JV
 568, 	// T1
 577, 	// D1
 586, 	// KH
 0, 	// YI
 0, 	// WU
 0, 	// AH
 0, 	// XR
 0, 	// AR
 0, 	// OR
 0, 	// 1R
 0, 	// WR
 0, 	// 2R
 0, 	// UR
 0, 	// 3R
 0, 	// 4R
 0, 	// 5R
 0, 	// YR
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
// ==== Low ====
 0, 	// _
 0, 	// IY
 0, 	// UE
 0, 	// EY
 0, 	// EH
 0, 	// A
 0, 	// IF
 0, 	// IR
 0, 	// AX
 0, 	// UW
 0, 	// UH
 0, 	// UC
 0, 	// OW
 0, 	// WO
 0, 	// AO
 0, 	// AA
 0, 	// AY
 0, 	// AW
 0, 	// ER
 595, 	// M
 604, 	// N
 613, 	// NX
 622, 	// P
 0, 	// PV
 0, 	// T
 631, 	// TV
 640, 	// K
 649, 	// KV
 658, 	// F
 667, 	// S
 676, 	// SR
 685, 	// ZR
 694, 	// TJ
 0, 	// CH
 0, 	// RF
 0, 	// Y
 0, 	// W
 0, 	// L
 0, 	// TS
 703, 	// DS
 0, 	// JJ
 0, 	// JV
 0, 	// T1
 0, 	// D1
 712, 	// KH
 0, 	// YI
 0, 	// WU
 0, 	// AH
 0, 	// XR
 0, 	// AR
 0, 	// OR
 0, 	// 1R
 0, 	// WR
 0, 	// 2R
 0, 	// UR
 0, 	// 3R
 0, 	// 4R
 0, 	// 5R
 0, 	// YR
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0 };	// X5

// Male Locus data
const short ch_maleloc_def[] = {
 0, 
// Front
 470, 	// M F1 locus
 30, 	// M percent
 30, 	// M transition duration
 1200, 	// M F2 locus
 10, 	// M percent
 35, 	// M transition duration
 2100, 	// M F3 locus
 30, 	// M percent
 40, 	// M transition duration
 450, 	// N F1 locus
 20, 	// N percent
 35, 	// N transition duration
 1350, 	// N F2 locus
 75, 	// N percent
 35, 	// N transition duration
 2600, 	// N F3 locus
 40, 	// N percent
 45, 	// N transition duration
 280, 	// NX F1 locus
 25, 	// NX percent
 40, 	// NX transition duration
 1200, 	// NX F2 locus
 15, 	// NX percent
 60, 	// NX transition duration
 3000, 	// NX F3 locus
 105, 	// NX percent
 60, 	// NX transition duration
 350, 	// P F1 locus
 55, 	// P percent
 20, 	// P transition duration
 950, 	// P F2 locus
 56, 	// P percent
 50, 	// P transition duration
 2200, 	// P F3 locus
 25, 	// P percent
 50, 	// P transition duration
 220, 	// PV F1 locus
 55, 	// PV percent
 20, 	// PV transition duration
 700, 	// PV F2 locus
 56, 	// PV percent
 30, 	// PV transition duration
 2200, 	// PV F3 locus
 25, 	// PV percent
 45, 	// PV transition duration
 320, 	// T F1 locus
 43, 	// T percent
 35, 	// T transition duration
 1800, 	// T F2 locus
 60, 	// T percent
 35, 	// T transition duration
 2650, 	// T F3 locus
 30, 	// T percent
 45, 	// T transition duration
 336, 	// TV F1 locus
 80, 	// TV percent
 50, 	// TV transition duration
 1800, 	// TV F2 locus
 66, 	// TV percent
 35, 	// TV transition duration
 2600, 	// TV F3 locus
 30, 	// TV percent
 45, 	// TV transition duration
 280, 	// K F1 locus
 33, 	// K percent
 45, 	// K transition duration
 1980, 	// K F2 locus
 20, 	// K percent
 55, 	// K transition duration
 3000, 	// K F3 locus
 117, 	// K percent
 50, 	// K transition duration
 250, 	// KV F1 locus
 33, 	// KV percent
 45, 	// KV transition duration
 2100, 	// KV F2 locus
 20, 	// KV percent
 50, 	// KV transition duration
 3000, 	// KV F3 locus
 113, 	// KV percent
 50, 	// KV transition duration
 300, 	// F F1 locus
 63, 	// F percent
 30, 	// F transition duration
 1, 	// F F2 locus
 92, 	// F percent
 35, 	// F transition duration
 2080, 	// F F3 locus
 35, 	// F percent
 30, 	// F transition duration
 310, 	// S F1 locus
 40, 	// S percent
 40, 	// S transition duration
 1400, 	// S F2 locus
 40, 	// S percent
 50, 	// S transition duration
 2550, 	// S F3 locus
 0, 	// S percent
 70, 	// S transition duration
 320, 	// SR F1 locus
 60, 	// SR percent
 60, 	// SR transition duration
 1450, 	// SR F2 locus
 60, 	// SR percent
 60, 	// SR transition duration
 1950, 	// SR F3 locus
 60, 	// SR percent
 60, 	// SR transition duration
 400, 	// ZR F1 locus
 32, 	// ZR percent
 55, 	// ZR transition duration
 1450, 	// ZR F2 locus
 30, 	// ZR percent
 70, 	// ZR transition duration
 1980, 	// ZR F3 locus
 51, 	// ZR percent
 70, 	// ZR transition duration
 370, 	// TJ F1 locus
 32, 	// TJ percent
 55, 	// TJ transition duration
 2000, 	// TJ F2 locus
 30, 	// TJ percent
 70, 	// TJ transition duration
 3000, 	// TJ F3 locus
 51, 	// TJ percent
 70, 	// TJ transition duration
 300, 	// CH F1 locus
 72, 	// CH percent
 20, 	// CH transition duration
 1869, 	// CH F2 locus
 10, 	// CH percent
 40, 	// CH transition duration
 2569, 	// CH F3 locus
 63, 	// CH percent
 50, 	// CH transition duration
 245, 	// TS F1 locus
 80, 	// TS percent
 30, 	// TS transition duration
 1900, 	// TS F2 locus
 47, 	// TS percent
 40, 	// TS transition duration
 2400, 	// TS F3 locus
 40, 	// TS percent
 40, 	// TS transition duration
 340, 	// DS F1 locus
 10, 	// DS percent
 45, 	// DS transition duration
 1350, 	// DS F2 locus
 20, 	// DS percent
 50, 	// DS transition duration
 2700, 	// DS F3 locus
 0, 	// DS percent
 50, 	// DS transition duration
 320, 	// JJ F1 locus
 10, 	// JJ percent
 11, 	// JJ transition duration
 1985, 	// JJ F2 locus
 25, 	// JJ percent
 20, 	// JJ transition duration
 2674, 	// JJ F3 locus
 19, 	// JJ percent
 20, 	// JJ transition duration
 289, 	// JV F1 locus
 32, 	// JV percent
 55, 	// JV transition duration
 1896, 	// JV F2 locus
 25, 	// JV percent
 70, 	// JV transition duration
 2879, 	// JV F3 locus
 19, 	// JV percent
 70, 	// JV transition duration
 320, 	// T1 F1 locus
 60, 	// T1 percent
 60, 	// T1 transition duration
 1750, 	// T1 F2 locus
 60, 	// T1 percent
 60, 	// T1 transition duration
 2250, 	// T1 F3 locus
 60, 	// T1 percent
 60, 	// T1 transition duration
 317, 	// D1 F1 locus
 64, 	// D1 percent
 54, 	// D1 transition duration
 1956, 	// D1 F2 locus
 96, 	// D1 percent
 38, 	// D1 transition duration
 1868, 	// D1 F3 locus
 89, 	// D1 percent
 50, 	// D1 transition duration
 300, 	// KH F1 locus
 72, 	// KH percent
 20, 	// KH transition duration
 1869, 	// KH F2 locus
 99, 	// KH percent
 80, 	// KH transition duration
 2569, 	// KH F3 locus
 63, 	// KH percent
 50, 	// KH transition duration
// Back
 450, 	// M F1 locus
 20, 	// M percent
 30, 	// M transition duration
 1, 	// M F2 locus
 88, 	// M percent
 40, 	// M transition duration
 1550, 	// M F3 locus
 80, 	// M percent
 25, 	// M transition duration
 450, 	// N F1 locus
 20, 	// N percent
 30, 	// N transition duration
 1520, 	// N F2 locus
 25, 	// N percent
 75, 	// N transition duration
 2600, 	// N F3 locus
 0, 	// N percent
 60, 	// N transition duration
 280, 	// NX F1 locus
 25, 	// NX percent
 40, 	// NX transition duration
 1200, 	// NX F2 locus
 20, 	// NX percent
 70, 	// NX transition duration
 2150, 	// NX F3 locus
 20, 	// NX percent
 70, 	// NX transition duration
 350, 	// P F1 locus
 45, 	// P percent
 25, 	// P transition duration
 920, 	// P F2 locus
 46, 	// P percent
 50, 	// P transition duration
 1900, 	// P F3 locus
 40, 	// P percent
 50, 	// P transition duration
 220, 	// PV F1 locus
 45, 	// PV percent
 25, 	// PV transition duration
 700, 	// PV F2 locus
 46, 	// PV percent
 30, 	// PV transition duration
 2200, 	// PV F3 locus
 40, 	// PV percent
 50, 	// PV transition duration
 320, 	// T F1 locus
 43, 	// T percent
 50, 	// T transition duration
 1700, 	// T F2 locus
 10, 	// T percent
 75, 	// T transition duration
 2600, 	// T F3 locus
 10, 	// T percent
 50, 	// T transition duration
 332, 	// TV F1 locus
 83, 	// TV percent
 48, 	// TV transition duration
 1800, 	// TV F2 locus
 66, 	// TV percent
 100, 	// TV transition duration
 2800, 	// TV F3 locus
 37, 	// TV percent
 62, 	// TV transition duration
 280, 	// K F1 locus
 33, 	// K percent
 50, 	// K transition duration
 1800, 	// K F2 locus
 16, 	// K percent
 50, 	// K transition duration
 2000, 	// K F3 locus
 20, 	// K percent
 90, 	// K transition duration
 300, 	// KV F1 locus
 33, 	// KV percent
 50, 	// KV transition duration
 1800, 	// KV F2 locus
 16, 	// KV percent
 60, 	// KV transition duration
 2100, 	// KV F3 locus
 0, 	// KV percent
 90, 	// KV transition duration
 320, 	// F F1 locus
 60, 	// F percent
 30, 	// F transition duration
 1, 	// F F2 locus
 91, 	// F percent
 35, 	// F transition duration
 2100, 	// F F3 locus
 65, 	// F percent
 40, 	// F transition duration
 310, 	// S F1 locus
 40, 	// S percent
 40, 	// S transition duration
 1271, 	// S F2 locus
 40, 	// S percent
 50, 	// S transition duration
 2610, 	// S F3 locus
 0, 	// S percent
 60, 	// S transition duration
 320, 	// SR F1 locus
 70, 	// SR percent
 55, 	// SR transition duration
 1380, 	// SR F2 locus
 50, 	// SR percent
 60, 	// SR transition duration
 1850, 	// SR F3 locus
 50, 	// SR percent
 70, 	// SR transition duration
 300, 	// ZR F1 locus
 20, 	// ZR percent
 30, 	// ZR transition duration
 1428, 	// ZR F2 locus
 0, 	// ZR percent
 55, 	// ZR transition duration
 2000, 	// ZR F3 locus
 70, 	// ZR percent
 85, 	// ZR transition duration
 406, 	// TJ F1 locus
 32, 	// TJ percent
 51, 	// TJ transition duration
 1600, 	// TJ F2 locus
 45, 	// TJ percent
 33, 	// TJ transition duration
 2370, 	// TJ F3 locus
 50, 	// TJ percent
 20, 	// TJ transition duration
 500, 	// CH F1 locus
 50, 	// CH percent
 20, 	// CH transition duration
 1300, 	// CH F2 locus
 99, 	// CH percent
 80, 	// CH transition duration
 2570, 	// CH F3 locus
 30, 	// CH percent
 50, 	// CH transition duration
 290, 	// TS F1 locus
 70, 	// TS percent
 35, 	// TS transition duration
 1333, 	// TS F2 locus
 40, 	// TS percent
 26, 	// TS transition duration
 2300, 	// TS F3 locus
 25, 	// TS percent
 26, 	// TS transition duration
 350, 	// DS F1 locus
 10, 	// DS percent
 50, 	// DS transition duration
 1300, 	// DS F2 locus
 12, 	// DS percent
 55, 	// DS transition duration
 2720, 	// DS F3 locus
 11, 	// DS percent
 55, 	// DS transition duration
 320, 	// JJ F1 locus
 54, 	// JJ percent
 55, 	// JJ transition duration
 1680, 	// JJ F2 locus
 10, 	// JJ percent
 40, 	// JJ transition duration
 2450, 	// JJ F3 locus
 10, 	// JJ percent
 70, 	// JJ transition duration
 280, 	// JV F1 locus
 32, 	// JV percent
 55, 	// JV transition duration
 1896, 	// JV F2 locus
 5, 	// JV percent
 120, 	// JV transition duration
 2879, 	// JV F3 locus
 10, 	// JV percent
 70, 	// JV transition duration
 320, 	// T1 F1 locus
 70, 	// T1 percent
 55, 	// T1 transition duration
 1680, 	// T1 F2 locus
 50, 	// T1 percent
 60, 	// T1 transition duration
 2150, 	// T1 F3 locus
 50, 	// T1 percent
 70, 	// T1 transition duration
 391, 	// D1 F1 locus
 61, 	// D1 percent
 55, 	// D1 transition duration
 1588, 	// D1 F2 locus
 61, 	// D1 percent
 77, 	// D1 transition duration
 1770, 	// D1 F3 locus
 39, 	// D1 percent
 113, 	// D1 transition duration
 500, 	// KH F1 locus
 50, 	// KH percent
 20, 	// KH transition duration
 1300, 	// KH F2 locus
 99, 	// KH percent
 80, 	// KH transition duration
 2570, 	// KH F3 locus
 93, 	// KH percent
 50, 	// KH transition duration
// Round
 450, 	// M F1 locus
 20, 	// M percent
 30, 	// M transition duration
 970, 	// M F2 locus
 10, 	// M percent
 40, 	// M transition duration
 1550, 	// M F3 locus
 80, 	// M percent
 25, 	// M transition duration
 450, 	// N F1 locus
 20, 	// N percent
 30, 	// N transition duration
 1500, 	// N F2 locus
 30, 	// N percent
 80, 	// N transition duration
 2420, 	// N F3 locus
 0, 	// N percent
 95, 	// N transition duration
 280, 	// NX F1 locus
 25, 	// NX percent
 40, 	// NX transition duration
 1200, 	// NX F2 locus
 42, 	// NX percent
 70, 	// NX transition duration
 1920, 	// NX F3 locus
 25, 	// NX percent
 70, 	// NX transition duration
 320, 	// P F1 locus
 45, 	// P percent
 25, 	// P transition duration
 920, 	// P F2 locus
 46, 	// P percent
 50, 	// P transition duration
 1900, 	// P F3 locus
 40, 	// P percent
 50, 	// P transition duration
 220, 	// PV F1 locus
 45, 	// PV percent
 25, 	// PV transition duration
 700, 	// PV F2 locus
 36, 	// PV percent
 50, 	// PV transition duration
 2179, 	// PV F3 locus
 40, 	// PV percent
 40, 	// PV transition duration
 320, 	// T F1 locus
 43, 	// T percent
 40, 	// T transition duration
 1700, 	// T F2 locus
 5, 	// T percent
 95, 	// T transition duration
 2300, 	// T F3 locus
 0, 	// T percent
 95, 	// T transition duration
 332, 	// TV F1 locus
 70, 	// TV percent
 40, 	// TV transition duration
 1440, 	// TV F2 locus
 36, 	// TV percent
 30, 	// TV transition duration
 2800, 	// TV F3 locus
 67, 	// TV percent
 25, 	// TV transition duration
 280, 	// K F1 locus
 33, 	// K percent
 40, 	// K transition duration
 1400, 	// K F2 locus
 60, 	// K percent
 75, 	// K transition duration
 2050, 	// K F3 locus
 15, 	// K percent
 80, 	// K transition duration
 290, 	// KV F1 locus
 45, 	// KV percent
 40, 	// KV transition duration
 1400, 	// KV F2 locus
 42, 	// KV percent
 65, 	// KV transition duration
 2300, 	// KV F3 locus
 15, 	// KV percent
 80, 	// KV transition duration
 320, 	// F F1 locus
 60, 	// F percent
 30, 	// F transition duration
 1, 	// F F2 locus
 91, 	// F percent
 35, 	// F transition duration
 2100, 	// F F3 locus
 65, 	// F percent
 40, 	// F transition duration
 310, 	// S F1 locus
 40, 	// S percent
 40, 	// S transition duration
 1250, 	// S F2 locus
 15, 	// S percent
 60, 	// S transition duration
 2384, 	// S F3 locus
 0, 	// S percent
 60, 	// S transition duration
 320, 	// SR F1 locus
 54, 	// SR percent
 55, 	// SR transition duration
 1420, 	// SR F2 locus
 60, 	// SR percent
 60, 	// SR transition duration
 1950, 	// SR F3 locus
 60, 	// SR percent
 60, 	// SR transition duration
 456, 	// ZR F1 locus
 32, 	// ZR percent
 55, 	// ZR transition duration
 1000, 	// ZR F2 locus
 27, 	// ZR percent
 90, 	// ZR transition duration
 1700, 	// ZR F3 locus
 80, 	// ZR percent
 110, 	// ZR transition duration
 406, 	// TJ F1 locus
 20, 	// TJ percent
 40, 	// TJ transition duration
 1558, 	// TJ F2 locus
 80, 	// TJ percent
 90, 	// TJ transition duration
 2200, 	// TJ F3 locus
 60, 	// TJ percent
 60, 	// TJ transition duration
 300, 	// CH F1 locus
 90, 	// CH percent
 20, 	// CH transition duration
 1300, 	// CH F2 locus
 99, 	// CH percent
 80, 	// CH transition duration
 2600, 	// CH F3 locus
 30, 	// CH percent
 40, 	// CH transition duration
 290, 	// TS F1 locus
 45, 	// TS percent
 50, 	// TS transition duration
 1970, 	// TS F2 locus
 71, 	// TS percent
 30, 	// TS transition duration
 2300, 	// TS F3 locus
 31, 	// TS percent
 80, 	// TS transition duration
 350, 	// DS F1 locus
 20, 	// DS percent
 50, 	// DS transition duration
 1300, 	// DS F2 locus
 12, 	// DS percent
 55, 	// DS transition duration
 2720, 	// DS F3 locus
 11, 	// DS percent
 55, 	// DS transition duration
 320, 	// JJ F1 locus
 54, 	// JJ percent
 55, 	// JJ transition duration
 1580, 	// JJ F2 locus
 20, 	// JJ percent
 40, 	// JJ transition duration
 2350, 	// JJ F3 locus
 10, 	// JJ percent
 100, 	// JJ transition duration
 280, 	// JV F1 locus
 32, 	// JV percent
 55, 	// JV transition duration
 1896, 	// JV F2 locus
 10, 	// JV percent
 90, 	// JV transition duration
 2879, 	// JV F3 locus
 10, 	// JV percent
 100, 	// JV transition duration
 320, 	// T1 F1 locus
 54, 	// T1 percent
 55, 	// T1 transition duration
 1720, 	// T1 F2 locus
 60, 	// T1 percent
 60, 	// T1 transition duration
 2250, 	// T1 F3 locus
 60, 	// T1 percent
 60, 	// T1 transition duration
 435, 	// D1 F1 locus
 10, 	// D1 percent
 37, 	// D1 transition duration
 1600, 	// D1 F2 locus
 70, 	// D1 percent
 109, 	// D1 transition duration
 1500, 	// D1 F3 locus
 45, 	// D1 percent
 93, 	// D1 transition duration
 350, 	// KH F1 locus
 90, 	// KH percent
 20, 	// KH transition duration
 1300, 	// KH F2 locus
 99, 	// KH percent
 80, 	// KH transition duration
 2600, 	// KH F3 locus
 60, 	// KH percent
 40, 	// KH transition duration
// Low
 0, 	// M F1 locus
 0, 	// M percent
 0, 	// M transition duration
 0, 	// M F2 locus
 0, 	// M percent
 0, 	// M transition duration
 0, 	// M F3 locus
 0, 	// M percent
 0, 	// M transition duration
 0, 	// N F1 locus
 0, 	// N percent
 0, 	// N transition duration
 0, 	// N F2 locus
 0, 	// N percent
 0, 	// N transition duration
 0, 	// N F3 locus
 0, 	// N percent
 0, 	// N transition duration
 0, 	// NX F1 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// NX F2 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// NX F3 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// P F1 locus
 0, 	// P percent
 0, 	// P transition duration
 0, 	// P F2 locus
 0, 	// P percent
 0, 	// P transition duration
 0, 	// P F3 locus
 0, 	// P percent
 0, 	// P transition duration
 0, 	// TV F1 locus
 0, 	// TV percent
 0, 	// TV transition duration
 0, 	// TV F2 locus
 0, 	// TV percent
 0, 	// TV transition duration
 0, 	// TV F3 locus
 0, 	// TV percent
 0, 	// TV transition duration
 0, 	// K F1 locus
 0, 	// K percent
 0, 	// K transition duration
 0, 	// K F2 locus
 0, 	// K percent
 0, 	// K transition duration
 0, 	// K F3 locus
 0, 	// K percent
 0, 	// K transition duration
 0, 	// KV F1 locus
 0, 	// KV percent
 0, 	// KV transition duration
 0, 	// KV F2 locus
 0, 	// KV percent
 0, 	// KV transition duration
 0, 	// KV F3 locus
 0, 	// KV percent
 0, 	// KV transition duration
 0, 	// F F1 locus
 0, 	// F percent
 0, 	// F transition duration
 0, 	// F F2 locus
 0, 	// F percent
 0, 	// F transition duration
 0, 	// F F3 locus
 0, 	// F percent
 0, 	// F transition duration
 0, 	// S F1 locus
 0, 	// S percent
 0, 	// S transition duration
 0, 	// S F2 locus
 0, 	// S percent
 0, 	// S transition duration
 0, 	// S F3 locus
 0, 	// S percent
 0, 	// S transition duration
 -1, 	// SR F1 locus
 -1, 	// SR percent
 -1, 	// SR transition duration
 -1, 	// SR F2 locus
 -1, 	// SR percent
 -1, 	// SR transition duration
 -1, 	// SR F3 locus
 -1, 	// SR percent
 -1, 	// SR transition duration
 0, 	// ZR F1 locus
 0, 	// ZR percent
 0, 	// ZR transition duration
 0, 	// ZR F2 locus
 0, 	// ZR percent
 0, 	// ZR transition duration
 0, 	// ZR F3 locus
 0, 	// ZR percent
 0, 	// ZR transition duration
 0, 	// TJ F1 locus
 0, 	// TJ percent
 0, 	// TJ transition duration
 0, 	// TJ F2 locus
 0, 	// TJ percent
 0, 	// TJ transition duration
 0, 	// TJ F3 locus
 0, 	// TJ percent
 0, 	// TJ transition duration
 330, 	// DS F1 locus
 30, 	// DS percent
 40, 	// DS transition duration
 1200, 	// DS F2 locus
 30, 	// DS percent
 50, 	// DS transition duration
 2300, 	// DS F3 locus
 30, 	// DS percent
 50, 	// DS transition duration
 350, 	// KH F1 locus
 78, 	// KH percent
 30, 	// KH transition duration
 1000, 	// KH F2 locus
 2, 	// KH percent
 240, 	// KH transition duration
 2800, 	// KH F3 locus
 60, 	// KH percent
 50, 	// KH transition duration
 0};

// Female Locus
const short ch_femloc_def[] = {
 0, 
// Front
 470, 	// M F1 locus
 30, 	// M percent
 30, 	// M transition duration
 1200, 	// M F2 locus
 10, 	// M percent
 35, 	// M transition duration
 2100, 	// M F3 locus
 30, 	// M percent
 40, 	// M transition duration
 450, 	// N F1 locus
 20, 	// N percent
 35, 	// N transition duration
 1350, 	// N F2 locus
 75, 	// N percent
 35, 	// N transition duration
 2600, 	// N F3 locus
 40, 	// N percent
 45, 	// N transition duration
 280, 	// NX F1 locus
 25, 	// NX percent
 40, 	// NX transition duration
 1200, 	// NX F2 locus
 15, 	// NX percent
 60, 	// NX transition duration
 3000, 	// NX F3 locus
 105, 	// NX percent
 60, 	// NX transition duration
 350, 	// P F1 locus
 55, 	// P percent
 20, 	// P transition duration
 950, 	// P F2 locus
 56, 	// P percent
 50, 	// P transition duration
 2200, 	// P F3 locus
 25, 	// P percent
 50, 	// P transition duration
 330, 	// PV F1 locus
 55, 	// PV percent
 20, 	// PV transition duration
 900, 	// PV F2 locus
 56, 	// PV percent
 30, 	// PV transition duration
 2200, 	// PV F3 locus
 25, 	// PV percent
 45, 	// PV transition duration
 320, 	// T F1 locus
 43, 	// T percent
 35, 	// T transition duration
 1800, 	// T F2 locus
 60, 	// T percent
 35, 	// T transition duration
 2650, 	// T F3 locus
 30, 	// T percent
 45, 	// T transition duration
 336, 	// TV F1 locus
 80, 	// TV percent
 50, 	// TV transition duration
 1900, 	// TV F2 locus
 66, 	// TV percent
 35, 	// TV transition duration
 2990, 	// TV F3 locus
 30, 	// TV percent
 45, 	// TV transition duration
 280, 	// K F1 locus
 33, 	// K percent
 45, 	// K transition duration
 1980, 	// K F2 locus
 20, 	// K percent
 55, 	// K transition duration
 3000, 	// K F3 locus
 117, 	// K percent
 50, 	// K transition duration
 250, 	// KV F1 locus
 33, 	// KV percent
 45, 	// KV transition duration
 2100, 	// KV F2 locus
 20, 	// KV percent
 50, 	// KV transition duration
 2100, 	// KV F3 locus
 50, 	// KV percent
 45, 	// KV transition duration
 300, 	// F F1 locus
 63, 	// F percent
 30, 	// F transition duration
 1, 	// F F2 locus
 92, 	// F percent
 35, 	// F transition duration
 2080, 	// F F3 locus
 35, 	// F percent
 30, 	// F transition duration
 310, 	// S F1 locus
 40, 	// S percent
 40, 	// S transition duration
 1440, 	// S F2 locus
 40, 	// S percent
 50, 	// S transition duration
 2550, 	// S F3 locus
 0, 	// S percent
 70, 	// S transition duration
 285, 	// SR F1 locus
 32, 	// SR percent
 55, 	// SR transition duration
 1830, 	// SR F2 locus
 30, 	// SR percent
 70, 	// SR transition duration
 2640, 	// SR F3 locus
 51, 	// SR percent
 70, 	// SR transition duration
 400, 	// ZR F1 locus
 32, 	// ZR percent
 55, 	// ZR transition duration
 1450, 	// ZR F2 locus
 30, 	// ZR percent
 70, 	// ZR transition duration
 1980, 	// ZR F3 locus
 51, 	// ZR percent
 70, 	// ZR transition duration
 370, 	// TJ F1 locus
 32, 	// TJ percent
 55, 	// TJ transition duration
 2000, 	// TJ F2 locus
 30, 	// TJ percent
 70, 	// TJ transition duration
 3000, 	// TJ F3 locus
 51, 	// TJ percent
 70, 	// TJ transition duration
 300, 	// CH F1 locus
 72, 	// CH percent
 20, 	// CH transition duration
 1869, 	// CH F2 locus
 99, 	// CH percent
 80, 	// CH transition duration
 2569, 	// CH F3 locus
 63, 	// CH percent
 50, 	// CH transition duration
 501, 	// TS F1 locus
 50, 	// TS percent
 70, 	// TS transition duration
 1500, 	// TS F2 locus
 20, 	// TS percent
 150, 	// TS transition duration
 2600, 	// TS F3 locus
 50, 	// TS percent
 50, 	// TS transition duration
 340, 	// DS F1 locus
 10, 	// DS percent
 45, 	// DS transition duration
 1350, 	// DS F2 locus
 20, 	// DS percent
 50, 	// DS transition duration
 2700, 	// DS F3 locus
 0, 	// DS percent
 50, 	// DS transition duration
 320, 	// JJ F1 locus
 54, 	// JJ percent
 55, 	// JJ transition duration
 1750, 	// JJ F2 locus
 25, 	// JJ percent
 70, 	// JJ transition duration
 2750, 	// JJ F3 locus
 19, 	// JJ percent
 70, 	// JJ transition duration
 240, 	// JV F1 locus
 32, 	// JV percent
 55, 	// JV transition duration
 1750, 	// JV F2 locus
 25, 	// JV percent
 70, 	// JV transition duration
 2750, 	// JV F3 locus
 19, 	// JV percent
 70, 	// JV transition duration
 320, 	// T1 F1 locus
 60, 	// T1 percent
 60, 	// T1 transition duration
 1750, 	// T1 F2 locus
 60, 	// T1 percent
 60, 	// T1 transition duration
 2250, 	// T1 F3 locus
 60, 	// T1 percent
 60, 	// T1 transition duration
 240, 	// D1 F1 locus
 32, 	// D1 percent
 55, 	// D1 transition duration
 1750, 	// D1 F2 locus
 25, 	// D1 percent
 70, 	// D1 transition duration
 2750, 	// D1 F3 locus
 19, 	// D1 percent
 70, 	// D1 transition duration
 300, 	// KH F1 locus
 72, 	// KH percent
 20, 	// KH transition duration
 1869, 	// KH F2 locus
 99, 	// KH percent
 80, 	// KH transition duration
 2569, 	// KH F3 locus
 63, 	// KH percent
 50, 	// KH transition duration
// Back
 450, 	// M F1 locus
 20, 	// M percent
 30, 	// M transition duration
 1, 	// M F2 locus
 88, 	// M percent
 40, 	// M transition duration
 1550, 	// M F3 locus
 80, 	// M percent
 25, 	// M transition duration
 450, 	// N F1 locus
 20, 	// N percent
 30, 	// N transition duration
 1520, 	// N F2 locus
 25, 	// N percent
 75, 	// N transition duration
 2600, 	// N F3 locus
 0, 	// N percent
 60, 	// N transition duration
 280, 	// NX F1 locus
 25, 	// NX percent
 40, 	// NX transition duration
 1200, 	// NX F2 locus
 20, 	// NX percent
 70, 	// NX transition duration
 2150, 	// NX F3 locus
 20, 	// NX percent
 70, 	// NX transition duration
 350, 	// P F1 locus
 45, 	// P percent
 25, 	// P transition duration
 920, 	// P F2 locus
 46, 	// P percent
 50, 	// P transition duration
 1900, 	// P F3 locus
 40, 	// P percent
 50, 	// P transition duration
 330, 	// PV F1 locus
 45, 	// PV percent
 25, 	// PV transition duration
 920, 	// PV F2 locus
 46, 	// PV percent
 30, 	// PV transition duration
 2250, 	// PV F3 locus
 40, 	// PV percent
 50, 	// PV transition duration
 320, 	// T F1 locus
 43, 	// T percent
 50, 	// T transition duration
 1700, 	// T F2 locus
 10, 	// T percent
 75, 	// T transition duration
 2600, 	// T F3 locus
 10, 	// T percent
 50, 	// T transition duration
 483, 	// TV F1 locus
 10, 	// TV percent
 40, 	// TV transition duration
 1900, 	// TV F2 locus
 40, 	// TV percent
 75, 	// TV transition duration
 3000, 	// TV F3 locus
 0, 	// TV percent
 50, 	// TV transition duration
 280, 	// K F1 locus
 33, 	// K percent
 50, 	// K transition duration
 1800, 	// K F2 locus
 16, 	// K percent
 50, 	// K transition duration
 2000, 	// K F3 locus
 20, 	// K percent
 90, 	// K transition duration
 250, 	// KV F1 locus
 33, 	// KV percent
 50, 	// KV transition duration
 1800, 	// KV F2 locus
 16, 	// KV percent
 60, 	// KV transition duration
 2100, 	// KV F3 locus
 0, 	// KV percent
 90, 	// KV transition duration
 320, 	// F F1 locus
 60, 	// F percent
 30, 	// F transition duration
 1, 	// F F2 locus
 91, 	// F percent
 35, 	// F transition duration
 2100, 	// F F3 locus
 65, 	// F percent
 40, 	// F transition duration
 310, 	// S F1 locus
 40, 	// S percent
 40, 	// S transition duration
 1440, 	// S F2 locus
 40, 	// S percent
 50, 	// S transition duration
 2530, 	// S F3 locus
 0, 	// S percent
 70, 	// S transition duration
 285, 	// SR F1 locus
 32, 	// SR percent
 55, 	// SR transition duration
 1700, 	// SR F2 locus
 27, 	// SR percent
 70, 	// SR transition duration
 2270, 	// SR F3 locus
 0, 	// SR percent
 85, 	// SR transition duration
 398, 	// ZR F1 locus
 32, 	// ZR percent
 55, 	// ZR transition duration
 1428, 	// ZR F2 locus
 27, 	// ZR percent
 70, 	// ZR transition duration
 1589, 	// ZR F3 locus
 0, 	// ZR percent
 85, 	// ZR transition duration
 366, 	// TJ F1 locus
 32, 	// TJ percent
 55, 	// TJ transition duration
 2600, 	// TJ F2 locus
 27, 	// TJ percent
 70, 	// TJ transition duration
 3990, 	// TJ F3 locus
 0, 	// TJ percent
 85, 	// TJ transition duration
 500, 	// CH F1 locus
 50, 	// CH percent
 20, 	// CH transition duration
 1300, 	// CH F2 locus
 99, 	// CH percent
 80, 	// CH transition duration
 2570, 	// CH F3 locus
 93, 	// CH percent
 50, 	// CH transition duration
 290, 	// TS F1 locus
 70, 	// TS percent
 35, 	// TS transition duration
 1500, 	// TS F2 locus
 20, 	// TS percent
 80, 	// TS transition duration
 2600, 	// TS F3 locus
 50, 	// TS percent
 50, 	// TS transition duration
 350, 	// DS F1 locus
 10, 	// DS percent
 50, 	// DS transition duration
 1300, 	// DS F2 locus
 12, 	// DS percent
 55, 	// DS transition duration
 2720, 	// DS F3 locus
 11, 	// DS percent
 55, 	// DS transition duration
 320, 	// JJ F1 locus
 54, 	// JJ percent
 55, 	// JJ transition duration
 1680, 	// JJ F2 locus
 10, 	// JJ percent
 40, 	// JJ transition duration
 2450, 	// JJ F3 locus
 10, 	// JJ percent
 70, 	// JJ transition duration
 245, 	// JV F1 locus
 32, 	// JV percent
 55, 	// JV transition duration
 1680, 	// JV F2 locus
 5, 	// JV percent
 120, 	// JV transition duration
 2450, 	// JV F3 locus
 10, 	// JV percent
 70, 	// JV transition duration
 320, 	// T1 F1 locus
 70, 	// T1 percent
 55, 	// T1 transition duration
 1680, 	// T1 F2 locus
 50, 	// T1 percent
 60, 	// T1 transition duration
 2150, 	// T1 F3 locus
 50, 	// T1 percent
 70, 	// T1 transition duration
 245, 	// D1 F1 locus
 32, 	// D1 percent
 55, 	// D1 transition duration
 1680, 	// D1 F2 locus
 10, 	// D1 percent
 70, 	// D1 transition duration
 2450, 	// D1 F3 locus
 10, 	// D1 percent
 70, 	// D1 transition duration
 500, 	// KH F1 locus
 50, 	// KH percent
 20, 	// KH transition duration
 1300, 	// KH F2 locus
 99, 	// KH percent
 80, 	// KH transition duration
 2570, 	// KH F3 locus
 93, 	// KH percent
 50, 	// KH transition duration
// Round
 450, 	// M F1 locus
 20, 	// M percent
 30, 	// M transition duration
 970, 	// M F2 locus
 10, 	// M percent
 40, 	// M transition duration
 1550, 	// M F3 locus
 80, 	// M percent
 25, 	// M transition duration
 450, 	// N F1 locus
 20, 	// N percent
 30, 	// N transition duration
 1500, 	// N F2 locus
 30, 	// N percent
 80, 	// N transition duration
 2420, 	// N F3 locus
 0, 	// N percent
 95, 	// N transition duration
 280, 	// NX F1 locus
 25, 	// NX percent
 40, 	// NX transition duration
 1200, 	// NX F2 locus
 42, 	// NX percent
 70, 	// NX transition duration
 1920, 	// NX F3 locus
 25, 	// NX percent
 70, 	// NX transition duration
 320, 	// P F1 locus
 45, 	// P percent
 25, 	// P transition duration
 920, 	// P F2 locus
 46, 	// P percent
 50, 	// P transition duration
 1900, 	// P F3 locus
 40, 	// P percent
 50, 	// P transition duration
 330, 	// PV F1 locus
 45, 	// PV percent
 25, 	// PV transition duration
 720, 	// PV F2 locus
 36, 	// PV percent
 50, 	// PV transition duration
 1800, 	// PV F3 locus
 40, 	// PV percent
 40, 	// PV transition duration
 320, 	// T F1 locus
 43, 	// T percent
 40, 	// T transition duration
 1700, 	// T F2 locus
 5, 	// T percent
 95, 	// T transition duration
 2300, 	// T F3 locus
 0, 	// T percent
 95, 	// T transition duration
 426, 	// TV F1 locus
 10, 	// TV percent
 45, 	// TV transition duration
 1900, 	// TV F2 locus
 40, 	// TV percent
 95, 	// TV transition duration
 2999, 	// TV F3 locus
 30, 	// TV percent
 85, 	// TV transition duration
 280, 	// K F1 locus
 33, 	// K percent
 40, 	// K transition duration
 1400, 	// K F2 locus
 60, 	// K percent
 75, 	// K transition duration
 2050, 	// K F3 locus
 15, 	// K percent
 80, 	// K transition duration
 250, 	// KV F1 locus
 45, 	// KV percent
 40, 	// KV transition duration
 1600, 	// KV F2 locus
 42, 	// KV percent
 65, 	// KV transition duration
 1920, 	// KV F3 locus
 15, 	// KV percent
 80, 	// KV transition duration
 320, 	// F F1 locus
 60, 	// F percent
 30, 	// F transition duration
 1, 	// F F2 locus
 91, 	// F percent
 35, 	// F transition duration
 2100, 	// F F3 locus
 65, 	// F percent
 40, 	// F transition duration
 310, 	// S F1 locus
 40, 	// S percent
 40, 	// S transition duration
 1320, 	// S F2 locus
 15, 	// S percent
 60, 	// S transition duration
 2460, 	// S F3 locus
 0, 	// S percent
 65, 	// S transition duration
 340, 	// SR F1 locus
 32, 	// SR percent
 55, 	// SR transition duration
 1630, 	// SR F2 locus
 27, 	// SR percent
 90, 	// SR transition duration
 2100, 	// SR F3 locus
 20, 	// SR percent
 110, 	// SR transition duration
 456, 	// ZR F1 locus
 32, 	// ZR percent
 55, 	// ZR transition duration
 1450, 	// ZR F2 locus
 27, 	// ZR percent
 90, 	// ZR transition duration
 1850, 	// ZR F3 locus
 20, 	// ZR percent
 110, 	// ZR transition duration
 340, 	// TJ F1 locus
 32, 	// TJ percent
 55, 	// TJ transition duration
 2600, 	// TJ F2 locus
 27, 	// TJ percent
 90, 	// TJ transition duration
 3990, 	// TJ F3 locus
 20, 	// TJ percent
 110, 	// TJ transition duration
 1600, 	// CH F1 locus
 90, 	// CH percent
 20, 	// CH transition duration
 1300, 	// CH F2 locus
 99, 	// CH percent
 80, 	// CH transition duration
 2600, 	// CH F3 locus
 60, 	// CH percent
 40, 	// CH transition duration
 501, 	// TS F1 locus
 50, 	// TS percent
 40, 	// TS transition duration
 1600, 	// TS F2 locus
 20, 	// TS percent
 90, 	// TS transition duration
 2600, 	// TS F3 locus
 50, 	// TS percent
 40, 	// TS transition duration
 350, 	// DS F1 locus
 10, 	// DS percent
 50, 	// DS transition duration
 1300, 	// DS F2 locus
 12, 	// DS percent
 55, 	// DS transition duration
 2720, 	// DS F3 locus
 11, 	// DS percent
 55, 	// DS transition duration
 320, 	// JJ F1 locus
 54, 	// JJ percent
 55, 	// JJ transition duration
 1580, 	// JJ F2 locus
 20, 	// JJ percent
 40, 	// JJ transition duration
 2350, 	// JJ F3 locus
 10, 	// JJ percent
 100, 	// JJ transition duration
 245, 	// JV F1 locus
 32, 	// JV percent
 55, 	// JV transition duration
 1680, 	// JV F2 locus
 10, 	// JV percent
 90, 	// JV transition duration
 1970, 	// JV F3 locus
 10, 	// JV percent
 100, 	// JV transition duration
 320, 	// T1 F1 locus
 54, 	// T1 percent
 55, 	// T1 transition duration
 1720, 	// T1 F2 locus
 60, 	// T1 percent
 60, 	// T1 transition duration
 2250, 	// T1 F3 locus
 60, 	// T1 percent
 60, 	// T1 transition duration
 245, 	// D1 F1 locus
 32, 	// D1 percent
 55, 	// D1 transition duration
 1680, 	// D1 F2 locus
 10, 	// D1 percent
 90, 	// D1 transition duration
 2350, 	// D1 F3 locus
 10, 	// D1 percent
 100, 	// D1 transition duration
 1600, 	// KH F1 locus
 90, 	// KH percent
 20, 	// KH transition duration
 1300, 	// KH F2 locus
 99, 	// KH percent
 80, 	// KH transition duration
 2600, 	// KH F3 locus
 60, 	// KH percent
 40, 	// KH transition duration
// Low
 0, 	// M F1 locus
 0, 	// M percent
 0, 	// M transition duration
 0, 	// M F2 locus
 0, 	// M percent
 0, 	// M transition duration
 0, 	// M F3 locus
 0, 	// M percent
 0, 	// M transition duration
 0, 	// N F1 locus
 0, 	// N percent
 0, 	// N transition duration
 0, 	// N F2 locus
 0, 	// N percent
 0, 	// N transition duration
 0, 	// N F3 locus
 0, 	// N percent
 0, 	// N transition duration
 0, 	// NX F1 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// NX F2 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// NX F3 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// P F1 locus
 0, 	// P percent
 0, 	// P transition duration
 0, 	// P F2 locus
 0, 	// P percent
 0, 	// P transition duration
 0, 	// P F3 locus
 0, 	// P percent
 0, 	// P transition duration
 0, 	// TV F1 locus
 0, 	// TV percent
 0, 	// TV transition duration
 0, 	// TV F2 locus
 0, 	// TV percent
 0, 	// TV transition duration
 0, 	// TV F3 locus
 0, 	// TV percent
 0, 	// TV transition duration
 0, 	// K F1 locus
 0, 	// K percent
 0, 	// K transition duration
 0, 	// K F2 locus
 0, 	// K percent
 0, 	// K transition duration
 0, 	// K F3 locus
 0, 	// K percent
 0, 	// K transition duration
 0, 	// KV F1 locus
 0, 	// KV percent
 0, 	// KV transition duration
 0, 	// KV F2 locus
 0, 	// KV percent
 0, 	// KV transition duration
 0, 	// KV F3 locus
 0, 	// KV percent
 0, 	// KV transition duration
 0, 	// F F1 locus
 0, 	// F percent
 0, 	// F transition duration
 0, 	// F F2 locus
 0, 	// F percent
 0, 	// F transition duration
 0, 	// F F3 locus
 0, 	// F percent
 0, 	// F transition duration
 0, 	// S F1 locus
 0, 	// S percent
 0, 	// S transition duration
 0, 	// S F2 locus
 0, 	// S percent
 0, 	// S transition duration
 0, 	// S F3 locus
 0, 	// S percent
 0, 	// S transition duration
 0, 	// SR F1 locus
 0, 	// SR percent
 0, 	// SR transition duration
 0, 	// SR F2 locus
 0, 	// SR percent
 0, 	// SR transition duration
 0, 	// SR F3 locus
 0, 	// SR percent
 0, 	// SR transition duration
 0, 	// ZR F1 locus
 0, 	// ZR percent
 0, 	// ZR transition duration
 0, 	// ZR F2 locus
 0, 	// ZR percent
 0, 	// ZR transition duration
 0, 	// ZR F3 locus
 0, 	// ZR percent
 0, 	// ZR transition duration
 0, 	// TJ F1 locus
 0, 	// TJ percent
 0, 	// TJ transition duration
 0, 	// TJ F2 locus
 0, 	// TJ percent
 0, 	// TJ transition duration
 0, 	// TJ F3 locus
 0, 	// TJ percent
 0, 	// TJ transition duration
 0, 	// DS F1 locus
 0, 	// DS percent
 0, 	// DS transition duration
 0, 	// DS F2 locus
 0, 	// DS percent
 0, 	// DS transition duration
 0, 	// DS F3 locus
 0, 	// DS percent
 0, 	// DS transition duration
 350, 	// KH F1 locus
 78, 	// KH percent
 30, 	// KH transition duration
 1000, 	// KH F2 locus
 2, 	// KH percent
 240, 	// KH transition duration
 2800, 	// KH F3 locus
 60, 	// KH percent
 50, 	// KH transition duration
 0};

const struct rom_data_s ch_rom_data_def = {
ch_inhdr_def,
ch_mindur_def,
ch_burdr_def,
ch_begtyp_def,
ch_endtyp_def,
ch_place_def,
ch_featb_def,
ch_maltar_def,
ch_femtar_def,
ch_maldip_def,
ch_femdip_def,
ch_ptram_def,
ch_plocu_def,
ch_maleloc_def,
ch_femloc_def
};


