/************************************************************************
 *
 *    Copyright  2002 Fonix Coporation. All rights reserved.
 *
 *    This is an unpublished work, and is confidential and proprietary: 
 *    technology and information of Fonix corporation.  No part of this
 *    code may be reproduced, used or disclosed without written consent of 
 *    Fonix corporation in each and every instance.
 *************************************************************************
 *    File Name:        sqrttable.c
 *    Author:
 *    Creation Date:
 *
 *    Functionality:
 *  
 *
 ***********************************************************************
 *    Revision History:
 *
 *	Rev Who     Date        Description
 *	--- ----	----------	--------------------------------------------  
 *	001	CAB		08/08/2002	Added copyright info
 *	002	CAB		08/15/2002	Removed warnings
 */
#include "dectalkf.h"
#include "port.h" //added for platform specific stuff - mlt
#ifdef HLSYN

#ifdef UNDER_CE
#pragma optimize("",off)
#endif


//moved to port.h for each platform - mlt
//#include <math.h>

#ifdef ARM7
#pragma arm section rodata="SQRTRODATA"
#endif

// sqrt values up to 0-4000
const float sqrttable[]= {
0.00000000f, 1.00000000f, 1.41421356f, 1.73205081f, 
2.00000000f, 2.23606798f, 2.44948974f, 2.64575131f, 
2.82842712f, 3.00000000f, 3.16227766f, 3.31662479f, 
3.46410162f, 3.60555128f, 3.74165739f, 3.87298335f, 
4.00000000f, 4.12310563f, 4.24264069f, 4.35889894f, 
4.47213595f, 4.58257569f, 4.69041576f, 4.79583152f, 
4.89897949f, 5.00000000f, 5.09901951f, 5.19615242f, 
5.29150262f, 5.38516481f, 5.47722558f, 5.56776436f, 
5.65685425f, 5.74456265f, 5.83095189f, 5.91607978f, 
6.00000000f, 6.08276253f, 6.16441400f, 6.24499800f, 
6.32455532f, 6.40312424f, 6.48074070f, 6.55743852f, 
6.63324958f, 6.70820393f, 6.78232998f, 6.85565460f, 
6.92820323f, 7.00000000f, 7.07106781f, 7.14142843f, 
7.21110255f, 7.28010989f, 7.34846923f, 7.41619849f, 
7.48331477f, 7.54983444f, 7.61577311f, 7.68114575f, 
7.74596669f, 7.81024968f, 7.87400787f, 7.93725393f, 
8.00000000f, 8.06225775f, 8.12403840f, 8.18535277f, 
8.24621125f, 8.30662386f, 8.36660027f, 8.42614977f, 
8.48528137f, 8.54400375f, 8.60232527f, 8.66025404f, 
8.71779789f, 8.77496439f, 8.83176087f, 8.88819442f, 
8.94427191f, 9.00000000f, 9.05538514f, 9.11043358f, 
9.16515139f, 9.21954446f, 9.27361850f, 9.32737905f, 
9.38083152f, 9.43398113f, 9.48683298f, 9.53939201f, 
9.59166305f, 9.64365076f, 9.69535971f, 9.74679434f, 
9.79795897f, 9.84885780f, 9.89949494f, 9.94987437f, 
10.00000000f, 10.04987562f, 10.09950494f, 10.14889157f, 
10.19803903f, 10.24695077f, 10.29563014f, 10.34408043f, 
10.39230485f, 10.44030651f, 10.48808848f, 10.53565375f, 
10.58300524f, 10.63014581f, 10.67707825f, 10.72380529f, 
10.77032961f, 10.81665383f, 10.86278049f, 10.90871211f, 
10.95445115f, 11.00000000f, 11.04536102f, 11.09053651f, 
11.13552873f, 11.18033989f, 11.22497216f, 11.26942767f, 
11.31370850f, 11.35781669f, 11.40175425f, 11.44552314f, 
11.48912529f, 11.53256259f, 11.57583690f, 11.61895004f, 
11.66190379f, 11.70469991f, 11.74734012f, 11.78982612f, 
11.83215957f, 11.87434209f, 11.91637529f, 11.95826074f, 
12.00000000f, 12.04159458f, 12.08304597f, 12.12435565f, 
12.16552506f, 12.20655562f, 12.24744871f, 12.28820573f, 
12.32882801f, 12.36931688f, 12.40967365f, 12.44989960f, 
12.48999600f, 12.52996409f, 12.56980509f, 12.60952021f, 
12.64911064f, 12.68857754f, 12.72792206f, 12.76714533f, 
12.80624847f, 12.84523258f, 12.88409873f, 12.92284798f, 
12.96148140f, 13.00000000f, 13.03840481f, 13.07669683f, 
13.11487705f, 13.15294644f, 13.19090596f, 13.22875656f, 
13.26649916f, 13.30413470f, 13.34166406f, 13.37908816f, 
13.41640786f, 13.45362405f, 13.49073756f, 13.52774926f, 
13.56465997f, 13.60147051f, 13.63818170f, 13.67479433f, 
13.71130920f, 13.74772708f, 13.78404875f, 13.82027496f, 
13.85640646f, 13.89244399f, 13.92838828f, 13.96424004f, 
14.00000000f, 14.03566885f, 14.07124728f, 14.10673598f, 
14.14213562f, 14.17744688f, 14.21267040f, 14.24780685f, 
14.28285686f, 14.31782106f, 14.35270009f, 14.38749457f, 
14.42220510f, 14.45683229f, 14.49137675f, 14.52583905f, 
14.56021978f, 14.59451952f, 14.62873884f, 14.66287830f, 
14.69693846f, 14.73091986f, 14.76482306f, 14.79864859f, 
14.83239697f, 14.86606875f, 14.89966443f, 14.93318452f, 
14.96662955f, 15.00000000f, 15.03329638f, 15.06651917f, 
15.09966887f, 15.13274595f, 15.16575089f, 15.19868415f, 
15.23154621f, 15.26433752f, 15.29705854f, 15.32970972f, 
15.36229150f, 15.39480432f, 15.42724862f, 15.45962483f, 
15.49193338f, 15.52417470f, 15.55634919f, 15.58845727f, 
15.62049935f, 15.65247584f, 15.68438714f, 15.71623365f, 
15.74801575f, 15.77973384f, 15.81138830f, 15.84297952f, 
15.87450787f, 15.90597372f, 15.93737745f, 15.96871942f, 
16.00000000f, 16.03121954f, 16.06237840f, 16.09347694f, 
16.12451550f, 16.15549442f, 16.18641406f, 16.21727474f, 
16.24807681f, 16.27882060f, 16.30950643f, 16.34013464f, 
16.37070554f, 16.40121947f, 16.43167673f, 16.46207763f, 
16.49242250f, 16.52271164f, 16.55294536f, 16.58312395f, 
16.61324773f, 16.64331698f, 16.67333200f, 16.70329309f, 
16.73320053f, 16.76305461f, 16.79285562f, 16.82260384f, 
16.85229955f, 16.88194302f, 16.91153453f, 16.94107435f, 
16.97056275f, 17.00000000f, 17.02938637f, 17.05872211f, 
17.08800749f, 17.11724277f, 17.14642820f, 17.17556404f, 
17.20465053f, 17.23368794f, 17.26267650f, 17.29161647f, 
17.32050808f, 17.34935157f, 17.37814720f, 17.40689519f, 
17.43559577f, 17.46424920f, 17.49285568f, 17.52141547f, 
17.54992877f, 17.57839583f, 17.60681686f, 17.63519209f, 
17.66352173f, 17.69180601f, 17.72004515f, 17.74823935f, 
17.77638883f, 17.80449381f, 17.83255450f, 17.86057110f, 
17.88854382f, 17.91647287f, 17.94435844f, 17.97220076f, 
18.00000000f, 18.02775638f, 18.05547009f, 18.08314132f, 
18.11077028f, 18.13835715f, 18.16590212f, 18.19340540f, 
18.22086716f, 18.24828759f, 18.27566688f, 18.30300522f, 
18.33030278f, 18.35755975f, 18.38477631f, 18.41195264f, 
18.43908891f, 18.46618531f, 18.49324201f, 18.52025918f, 
18.54723699f, 18.57417562f, 18.60107524f, 18.62793601f, 
18.65475811f, 18.68154169f, 18.70828693f, 18.73499400f, 
18.76166304f, 18.78829423f, 18.81488772f, 18.84144368f, 
18.86796226f, 18.89444363f, 18.92088793f, 18.94729532f, 
18.97366596f, 19.00000000f, 19.02629759f, 19.05255888f, 
19.07878403f, 19.10497317f, 19.13112647f, 19.15724406f, 
19.18332609f, 19.20937271f, 19.23538406f, 19.26136028f, 
19.28730152f, 19.31320792f, 19.33907961f, 19.36491673f, 
19.39071943f, 19.41648784f, 19.44222210f, 19.46792233f, 
19.49358869f, 19.51922130f, 19.54482029f, 19.57038579f, 
19.59591794f, 19.62141687f, 19.64688270f, 19.67231557f, 
19.69771560f, 19.72308292f, 19.74841766f, 19.77371993f, 
19.79898987f, 19.82422760f, 19.84943324f, 19.87460691f, 
19.89974874f, 19.92485885f, 19.94993734f, 19.97498436f, 
20.00000000f, 20.02498439f, 20.04993766f, 20.07485990f
#if 0
20.09975124f, 20.12461180f, 20.14944168f, 20.17424100f, 
20.19900988f, 20.22374842f, 20.24845673f, 20.27313493f, 
20.29778313f, 20.32240143f, 20.34698995f, 20.37154879f, 
20.39607805f, 20.42057786f, 20.44504830f, 20.46948949f, 
20.49390153f, 20.51828453f, 20.54263858f, 20.56696380f, 
20.59126028f, 20.61552813f, 20.63976744f, 20.66397832f, 
20.68816087f, 20.71231518f, 20.73644135f, 20.76053949f, 
20.78460969f, 20.80865205f, 20.83266666f, 20.85665361f, 
20.88061302f, 20.90454496f, 20.92844954f, 20.95232684f, 
20.97617696f, 21.00000000f, 21.02379604f, 21.04756518f, 
21.07130751f, 21.09502311f, 21.11871208f, 21.14237451f, 
21.16601049f, 21.18962010f, 21.21320344f, 21.23676058f, 
21.26029163f, 21.28379665f, 21.30727575f, 21.33072901f, 
21.35415650f, 21.37755833f, 21.40093456f, 21.42428529f, 
21.44761059f, 21.47091055f, 21.49418526f, 21.51743479f, 
21.54065923f, 21.56385865f, 21.58703314f, 21.61018278f, 
21.63330765f, 21.65640783f, 21.67948339f, 21.70253441f, 
21.72556098f, 21.74856317f, 21.77154106f, 21.79449472f, 
21.81742423f, 21.84032967f, 21.86321111f, 21.88606863f, 
21.90890230f, 21.93171220f, 21.95449840f, 21.97726098f, 
22.00000000f, 22.02271555f, 22.04540769f, 22.06807649f, 
22.09072203f, 22.11334439f, 22.13594362f, 22.15851981f, 
22.18107301f, 22.20360331f, 22.22611077f, 22.24859546f, 
22.27105745f, 22.29349681f, 22.31591360f, 22.33830790f, 
22.36067977f, 22.38302929f, 22.40535650f, 22.42766149f, 
22.44994432f, 22.47220505f, 22.49444376f, 22.51666050f, 
22.53885534f, 22.56102835f, 22.58317958f, 22.60530911f, 
22.62741700f, 22.64950331f, 22.67156810f, 22.69361144f, 
22.71563338f, 22.73763400f, 22.75961335f, 22.78157150f, 
22.80350850f, 22.82542442f, 22.84731932f, 22.86919325f, 
22.89104628f, 22.91287847f, 22.93468988f, 22.95648057f, 
22.97825059f, 23.00000000f, 23.02172887f, 23.04343724f, 
23.06512519f, 23.08679276f, 23.10844002f, 23.13006701f, 
23.15167381f, 23.17326045f, 23.19482701f, 23.21637353f, 
23.23790008f, 23.25940670f, 23.28089345f, 23.30236040f, 
23.32380758f, 23.34523506f, 23.36664289f, 23.38803113f, 
23.40939982f, 23.43074903f, 23.45207880f, 23.47338919f, 
23.49468025f, 23.51595203f, 23.53720459f, 23.55843798f, 
23.57965225f, 23.60084744f, 23.62202362f, 23.64318084f, 
23.66431913f, 23.68543856f, 23.70653918f, 23.72762104f, 
23.74868417f, 23.76972865f, 23.79075451f, 23.81176180f, 
23.83275058f, 23.85372088f, 23.87467277f, 23.89560629f, 
23.91652149f, 23.93741841f, 23.95829710f, 23.97915762f, 
24.00000000f, 24.02082430f, 24.04163056f, 24.06241883f, 
24.08318916f, 24.10394159f, 24.12467616f, 24.14539294f, 
24.16609195f, 24.18677324f, 24.20743687f, 24.22808288f, 
24.24871131f, 24.26932220f, 24.28991560f, 24.31049156f, 
24.33105012f, 24.35159132f, 24.37211521f, 24.39262184f, 
24.41311123f, 24.43358345f, 24.45403852f, 24.47447650f, 
24.49489743f, 24.51530134f, 24.53568829f, 24.55605832f, 
24.57641145f, 24.59674775f, 24.61706725f, 24.63736999f, 
24.65765601f, 24.67792536f, 24.69817807f, 24.71841419f, 
24.73863375f, 24.75883681f, 24.77902339f, 24.79919354f, 
24.81934729f, 24.83948470f, 24.85960579f, 24.87971061f, 
24.89979920f, 24.91987159f, 24.93992783f, 24.95996795f, 
24.97999199f, 25.00000000f, 25.01999201f, 25.03996805f, 
25.05992817f, 25.07987241f, 25.09980080f, 25.11971337f, 
25.13961018f, 25.15949125f, 25.17935662f, 25.19920634f, 
25.21904043f, 25.23885893f, 25.25866188f, 25.27844932f, 
25.29822128f, 25.31797780f, 25.33771892f, 25.35744467f, 
25.37715508f, 25.39685020f, 25.41653005f, 25.43619468f, 
25.45584412f, 25.47547841f, 25.49509757f, 25.51470164f, 
25.53429067f, 25.55386468f, 25.57342371f, 25.59296778f, 
25.61249695f, 25.63201124f, 25.65151068f, 25.67099531f, 
25.69046516f, 25.70992026f, 25.72936066f, 25.74878638f, 
25.76819745f, 25.78759392f, 25.80697580f, 25.82634314f, 
25.84569597f, 25.86503431f, 25.88435821f, 25.90366769f, 
25.92296279f, 25.94224354f, 25.96150997f, 25.98076211f, 
26.00000000f, 26.01922366f, 26.03843313f, 26.05762844f, 
26.07680962f, 26.09597670f, 26.11512971f, 26.13426869f, 
26.15339366f, 26.17250466f, 26.19160171f, 26.21068484f, 
26.22975410f, 26.24880950f, 26.26785107f, 26.28687886f, 
26.30589288f, 26.32489316f, 26.34387974f, 26.36285265f, 
26.38181192f, 26.40075756f, 26.41968963f, 26.43860813f, 
26.45751311f, 26.47640459f, 26.49528260f, 26.51414717f, 
26.53299832f, 26.55183609f, 26.57066051f, 26.58947160f, 
26.60826939f, 26.62705391f, 26.64582519f, 26.66458325f, 
26.68332813f, 26.70205985f, 26.72077843f, 26.73948391f, 
26.75817632f, 26.77685568f, 26.79552201f, 26.81417536f, 
26.83281573f, 26.85144316f, 26.87005769f, 26.88865932f, 
26.90724809f, 26.92582404f, 26.94438717f, 26.96293753f, 
26.98147513f, 27.00000000f, 27.01851217f, 27.03701167f, 
27.05549852f, 27.07397274f, 27.09243437f, 27.11088342f, 
27.12931993f, 27.14774392f, 27.16615541f, 27.18455444f, 
27.20294102f, 27.22131518f, 27.23967694f, 27.25802634f, 
27.27636339f, 27.29468813f, 27.31300057f, 27.33130074f, 
27.34958866f, 27.36786437f, 27.38612788f, 27.40437921f, 
27.42261840f, 27.44084547f, 27.45906044f, 27.47726333f, 
27.49545417f, 27.51363298f, 27.53179980f, 27.54995463f, 
27.56809750f, 27.58622845f, 27.60434748f, 27.62245463f, 
27.64054992f, 27.65863337f, 27.67670501f, 27.69476485f, 
27.71281292f, 27.73084925f, 27.74887385f, 27.76688675f, 
27.78488798f, 27.80287755f, 27.82085549f, 27.83882181f, 
27.85677655f, 27.87471973f, 27.89265136f, 27.91057147f, 
27.92848009f, 27.94637722f, 27.96426291f, 27.98213716f, 
28.00000000f, 28.01785145f, 28.03569154f, 28.05352028f, 
28.07133770f, 28.08914381f, 28.10693865f, 28.12472222f, 
28.14249456f, 28.16025568f, 28.17800561f, 28.19574436f, 
28.21347196f, 28.23118843f, 28.24889378f, 28.26658805f, 
28.28427125f, 28.30194340f, 28.31960452f, 28.33725463f, 
28.35489376f, 28.37252192f, 28.39013913f, 28.40774542f, 
28.42534081f, 28.44292531f, 28.46049894f, 28.47806173f, 
28.49561370f, 28.51315486f, 28.53068524f, 28.54820485f, 
28.56571371f, 28.58321186f, 28.60069929f, 28.61817604f, 
28.63564213f, 28.65309756f, 28.67054237f, 28.68797658f, 
28.70540019f, 28.72281323f, 28.74021573f, 28.75760769f, 
28.77498914f, 28.79236010f, 28.80972058f, 28.82707061f, 
28.84441020f, 28.86173938f, 28.87905816f, 28.89636655f, 
28.91366459f, 28.93095228f, 28.94822965f, 28.96549672f, 
28.98275349f, 29.00000000f, 29.01723626f, 29.03446228f, 
29.05167809f, 29.06888371f, 29.08607914f, 29.10326442f, 
29.12043956f, 29.13760457f, 29.15475947f, 29.17190429f, 
29.18903904f, 29.20616373f, 29.22327839f, 29.24038303f, 
29.25747768f, 29.27456234f, 29.29163703f, 29.30870178f, 
29.32575660f, 29.34280150f, 29.35983651f, 29.37686164f, 
29.39387691f, 29.41088234f, 29.42787794f, 29.44486373f, 
29.46183973f, 29.47880595f, 29.49576241f, 29.51270913f, 
29.52964612f, 29.54657341f, 29.56349100f, 29.58039892f, 
29.59729717f, 29.61418579f, 29.63106478f, 29.64793416f, 
29.66479395f, 29.68164416f, 29.69848481f, 29.71531592f, 
29.73213749f, 29.74894956f, 29.76575213f, 29.78254522f, 
29.79932885f, 29.81610303f, 29.83286778f, 29.84962311f, 
29.86636905f, 29.88310559f, 29.89983278f, 29.91655060f, 
29.93325909f, 29.94995826f, 29.96664813f, 29.98332870f, 
30.00000000f, 30.01666204f, 30.03331484f, 30.04995840f, 
30.06659276f, 30.08321791f, 30.09983389f, 30.11644069f, 
30.13303835f, 30.14962686f, 30.16620626f, 30.18277655f, 
30.19933774f, 30.21588986f, 30.23243292f, 30.24896692f, 
30.26549190f, 30.28200786f, 30.29851482f, 30.31501278f, 
30.33150178f, 30.34798181f, 30.36445290f, 30.38091506f, 
30.39736831f, 30.41381265f, 30.43024811f, 30.44667470f, 
30.46309242f, 30.47950131f, 30.49590136f, 30.51229260f, 
30.52867504f, 30.54504870f, 30.56141358f, 30.57776970f, 
30.59411708f, 30.61045573f, 30.62678566f, 30.64310689f, 
30.65941943f, 30.67572330f, 30.69201851f, 30.70830507f, 
30.72458299f, 30.74085230f, 30.75711300f, 30.77336511f, 
30.78960864f, 30.80584360f, 30.82207001f, 30.83828789f, 
30.85449724f, 30.87069808f, 30.88689042f, 30.90307428f, 
30.91924967f, 30.93541660f, 30.95157508f, 30.96772513f, 
30.98386677f, 31.00000000f, 31.01612484f, 31.03224130f, 
31.04834939f, 31.06444913f, 31.08054054f, 31.09662361f, 
31.11269837f, 31.12876483f, 31.14482300f, 31.16087290f, 
31.17691454f, 31.19294792f, 31.20897307f, 31.22498999f, 
31.24099870f, 31.25699922f, 31.27299154f, 31.28897569f, 
31.30495168f, 31.32091953f, 31.33687923f, 31.35283081f, 
31.36877428f, 31.38470965f, 31.40063694f, 31.41655614f, 
31.43246729f, 31.44837039f, 31.46426545f, 31.48015248f, 
31.49603150f, 31.51190251f, 31.52776554f, 31.54362059f, 
31.55946768f, 31.57530681f, 31.59113800f, 31.60696126f, 
31.62277660f, 31.63858404f, 31.65438358f, 31.67017524f, 
31.68595904f, 31.70173497f, 31.71750305f, 31.73326331f, 
31.74901573f, 31.76476035f, 31.78049716f, 31.79622619f, 
31.81194744f, 31.82766093f, 31.84336666f, 31.85906464f, 
31.87475490f, 31.89043744f, 31.90611227f, 31.92177940f, 
31.93743885f, 31.95309062f, 31.96873473f, 31.98437118f, 
32.00000000f, 32.01562119f, 32.03123476f, 32.04684072f, 
32.06243908f, 32.07802986f, 32.09361307f, 32.10918872f, 
32.12475681f, 32.14031736f, 32.15587038f, 32.17141588f, 
32.18695388f, 32.20248438f, 32.21800739f, 32.23352292f, 
32.24903099f, 32.26453161f, 32.28002478f, 32.29551052f, 
32.31098884f, 32.32645975f, 32.34192326f, 32.35737937f, 
32.37282811f, 32.38826948f, 32.40370349f, 32.41913015f, 
32.43454948f, 32.44996148f, 32.46536616f, 32.48076354f, 
32.49615362f, 32.51153641f, 32.52691193f, 32.54228019f, 
32.55764119f, 32.57299495f, 32.58834147f, 32.60368077f, 
32.61901286f, 32.63433774f, 32.64965543f, 32.66496594f, 
32.68026928f, 32.69556545f, 32.71085447f, 32.72613634f, 
32.74141109f, 32.75667871f, 32.77193922f, 32.78719262f, 
32.80243893f, 32.81767816f, 32.83291032f, 32.84813541f, 
32.86335345f, 32.87856445f, 32.89376841f, 32.90896534f, 
32.92415527f, 32.93933818f, 32.95451411f, 32.96968304f, 
32.98484500f, 33.00000000f, 33.01514804f, 33.03028913f, 
33.04542328f, 33.06055051f, 33.07567082f, 33.09078422f, 
33.10589071f, 33.12099032f, 33.13608305f, 33.15116891f, 
33.16624790f, 33.18132005f, 33.19638535f, 33.21144381f, 
33.22649545f, 33.24154028f, 33.25657830f, 33.27160952f, 
33.28663395f, 33.30165161f, 33.31666250f, 33.33166662f, 
33.34666400f, 33.36165464f, 33.37663854f, 33.39161571f, 
33.40658618f, 33.42154993f, 33.43650699f, 33.45145737f, 
33.46640106f, 33.48133809f, 33.49626845f, 33.51119216f, 
33.52610923f, 33.54101966f, 33.55592347f, 33.57082066f, 
33.58571125f, 33.60059523f, 33.61547263f, 33.63034344f, 
33.64520768f, 33.66006536f, 33.67491648f, 33.68976106f, 
33.70459909f, 33.71943060f, 33.73425559f, 33.74907406f, 
33.76388603f, 33.77869151f, 33.79349050f, 33.80828301f, 
33.82306905f, 33.83784863f, 33.85262176f, 33.86738844f, 
33.88214869f, 33.89690251f, 33.91164992f, 33.92639091f, 
33.94112550f, 33.95585369f, 33.97057550f, 33.98529094f, 
34.00000000f, 34.01470270f, 34.02939905f, 34.04408906f, 
34.05877273f, 34.07345007f, 34.08812110f, 34.10278581f, 
34.11744422f, 34.13209633f, 34.14674216f, 34.16138171f, 
34.17601498f, 34.19064199f, 34.20526275f, 34.21987726f, 
34.23448554f, 34.24908758f, 34.26368340f, 34.27827300f, 
34.29285640f, 34.30743360f, 34.32200460f, 34.33656943f, 
34.35112807f, 34.36568055f, 34.38022688f, 34.39476704f, 
34.40930107f, 34.42382896f, 34.43835072f, 34.45286635f, 
34.46737588f, 34.48187930f, 34.49637662f, 34.51086785f, 
34.52535300f, 34.53983208f, 34.55430509f, 34.56877203f, 
34.58323293f, 34.59768778f, 34.61213660f, 34.62657939f, 
34.64101615f, 34.65544690f, 34.66987165f, 34.68429039f, 
34.69870315f, 34.71310992f, 34.72751071f, 34.74190553f, 
34.75629439f, 34.77067730f, 34.78505426f, 34.79942528f, 
34.81379037f, 34.82814953f, 34.84250278f, 34.85685012f, 
34.87119155f, 34.88552709f, 34.89985673f, 34.91418050f, 
34.92849839f, 34.94281042f, 34.95711659f, 34.97141690f, 
34.98571137f, 35.00000000f, 35.01428280f, 35.02855978f, 
35.04283094f, 35.05709629f, 35.07135583f, 35.08560959f, 
35.09985755f, 35.11409973f, 35.12833614f, 35.14256678f, 
35.15679166f, 35.17101079f, 35.18522417f, 35.19943181f, 
35.21363372f, 35.22782991f, 35.24202037f, 35.25620513f, 
35.27038418f, 35.28455753f, 35.29872519f, 35.31288717f, 
35.32704347f, 35.34119409f, 35.35533906f, 35.36947837f, 
35.38361203f, 35.39774004f, 35.41186242f, 35.42597917f, 
35.44009029f, 35.45419580f, 35.46829570f, 35.48239000f, 
35.49647870f, 35.51056181f, 35.52463934f, 35.53871129f, 
35.55277767f, 35.56683849f, 35.58089375f, 35.59494346f, 
35.60898763f, 35.62302626f, 35.63705936f, 35.65108694f, 
35.66510900f, 35.67912555f, 35.69313660f, 35.70714214f, 
35.72114220f, 35.73513677f, 35.74912586f, 35.76310948f, 
35.77708764f, 35.79106034f, 35.80502758f, 35.81898938f, 
35.83294573f, 35.84689666f, 35.86084215f, 35.87478223f, 
35.88871689f, 35.90264614f, 35.91656999f, 35.93048845f, 
35.94440151f, 35.95830919f, 35.97221150f, 35.98610843f, 
36.00000000f, 36.01388621f, 36.02776707f, 36.04164258f, 
36.05551275f, 36.06937759f, 36.08323711f, 36.09709130f, 
36.11094017f, 36.12478374f, 36.13862200f, 36.15245497f, 
36.16628264f, 36.18010503f, 36.19392214f, 36.20773398f, 
36.22154055f, 36.23534186f, 36.24913792f, 36.26292873f, 
36.27671429f, 36.29049462f, 36.30426972f, 36.31803959f, 
36.33180425f, 36.34556369f, 36.35931793f, 36.37306696f, 
36.38681080f, 36.40054945f, 36.41428291f, 36.42801120f, 
36.44173432f, 36.45545227f, 36.46916506f, 36.48287269f, 
36.49657518f, 36.51027253f, 36.52396474f, 36.53765181f, 
36.55133376f, 36.56501060f, 36.57868232f, 36.59234893f, 
36.60601044f, 36.61966685f, 36.63331817f, 36.64696440f, 
36.66060556f, 36.67424164f, 36.68787266f, 36.70149861f, 
36.71511950f, 36.72873534f, 36.74234614f, 36.75595190f, 
36.76955262f, 36.78314832f, 36.79673899f, 36.81032464f, 
36.82390528f, 36.83748091f, 36.85105155f, 36.86461718f, 
36.87817783f, 36.89173349f, 36.90528417f, 36.91882988f, 
36.93237063f, 36.94590640f, 36.95943723f, 36.97296309f, 
36.98648402f, 37.00000000f, 37.01351105f, 37.02701716f, 
37.04051835f, 37.05401463f, 37.06750599f, 37.08099244f, 
37.09447398f, 37.10795063f, 37.12142239f, 37.13488926f, 
37.14835124f, 37.16180835f, 37.17526059f, 37.18870796f, 
37.20215048f, 37.21558813f, 37.22902094f, 37.24244890f, 
37.25587202f, 37.26929031f, 37.28270376f, 37.29611240f, 
37.30951621f, 37.32291521f, 37.33630941f, 37.34969879f, 
37.36308338f, 37.37646318f, 37.38983819f, 37.40320842f, 
37.41657387f, 37.42993454f, 37.44329045f, 37.45664160f, 
37.46998799f, 37.48332963f, 37.49666652f, 37.50999867f, 
37.52332608f, 37.53664876f, 37.54996671f, 37.56327994f, 
37.57658846f, 37.58989226f, 37.60319135f, 37.61648575f, 
37.62977544f, 37.64306045f, 37.65634077f, 37.66961640f, 
37.68288736f, 37.69615365f, 37.70941527f, 37.72267223f, 
37.73592453f, 37.74917218f, 37.76241518f, 37.77565354f, 
37.78888726f, 37.80211634f, 37.81534080f, 37.82856064f, 
37.84177586f, 37.85498646f, 37.86819246f, 37.88139385f, 
37.89459064f, 37.90778284f, 37.92097045f, 37.93415348f, 
37.94733192f, 37.96050579f, 37.97367509f, 37.98683983f, 
38.00000000f, 38.01315562f, 38.02630668f, 38.03945320f, 
38.05259518f, 38.06573262f, 38.07886553f, 38.09199391f, 
38.10511777f, 38.11823711f, 38.13135193f, 38.14446225f, 
38.15756806f, 38.17066937f, 38.18376618f, 38.19685851f, 
38.20994635f, 38.22302971f, 38.23610859f, 38.24918300f, 
38.26225294f, 38.27531842f, 38.28837944f, 38.30143600f, 
38.31448812f, 38.32753579f, 38.34057903f, 38.35361782f, 
38.36665219f, 38.37968212f, 38.39270764f, 38.40572874f, 
38.41874542f, 38.43175770f, 38.44476557f, 38.45776905f, 
38.47076812f, 38.48376281f, 38.49675311f, 38.50973903f, 
38.52272057f, 38.53569774f, 38.54867053f, 38.56163897f, 
38.57460304f, 38.58756276f, 38.60051813f, 38.61346915f, 
38.62641583f, 38.63935817f, 38.65229618f, 38.66522986f, 
38.67815921f, 38.69108424f, 38.70400496f, 38.71692137f, 
38.72983346f, 38.74274126f, 38.75564475f, 38.76854395f, 
38.78143886f, 38.79432948f, 38.80721582f, 38.82009789f, 
38.83297568f, 38.84584920f, 38.85871846f, 38.87158345f, 
38.88444419f, 38.89730068f, 38.91015292f, 38.92300091f, 
38.93584467f, 38.94868419f, 38.96151948f, 38.97435054f, 
38.98717738f, 39.00000000f, 39.01281841f, 39.02563260f, 
39.03844259f, 39.05124838f, 39.06404997f, 39.07684737f, 
39.08964057f, 39.10242959f, 39.11521443f, 39.12799509f, 
39.14077158f, 39.15354390f, 39.16631206f, 39.17907605f, 
39.19183588f, 39.20459157f, 39.21734310f, 39.23009049f, 
39.24283374f, 39.25557285f, 39.26830783f, 39.28103868f, 
39.29376541f, 39.30648801f, 39.31920650f, 39.33192088f, 
39.34463115f, 39.35733731f, 39.37003937f, 39.38273734f, 
39.39543121f, 39.40812099f, 39.42080669f, 39.43348831f, 
39.44616585f, 39.45883931f, 39.47150871f, 39.48417404f, 
39.49683532f, 39.50949253f, 39.52214569f, 39.53479480f, 
39.54743987f, 39.56008089f, 39.57271787f, 39.58535083f, 
39.59797975f, 39.61060464f, 39.62322551f, 39.63584237f, 
39.64845520f, 39.66106403f, 39.67366885f, 39.68626967f, 
39.69886648f, 39.71145930f, 39.72404813f, 39.73663297f, 
39.74921383f, 39.76179070f, 39.77436360f, 39.78693253f, 
39.79949748f, 39.81205847f, 39.82461550f, 39.83716857f, 
39.84971769f, 39.86226286f, 39.87480407f, 39.88734135f, 
39.89987469f, 39.91240409f, 39.92492956f, 39.93745110f, 
39.94996871f, 39.96248241f, 39.97499218f, 39.98749805f, 
40.00000000f, 40.01249805f, 40.02499219f, 40.03748244f, 
40.04996879f, 40.06245125f, 40.07492982f, 40.08740451f, 
40.09987531f, 40.11234224f, 40.12480530f, 40.13726448f, 
40.14971980f, 40.16217126f, 40.17461885f, 40.18706259f, 
40.19950248f, 40.21193853f, 40.22437072f, 40.23679908f, 
40.24922359f, 40.26164428f, 40.27406113f, 40.28647416f, 
40.29888336f, 40.31128874f, 40.32369031f, 40.33608806f, 
40.34848200f, 40.36087214f, 40.37325848f, 40.38564101f, 
40.39801975f, 40.41039470f, 40.42276586f, 40.43513324f, 
40.44749683f, 40.45985665f, 40.47221269f, 40.48456496f, 
40.49691346f, 40.50925820f, 40.52159918f, 40.53393640f, 
40.54626987f, 40.55859958f, 40.57092555f, 40.58324778f, 
40.59556626f, 40.60788101f, 40.62019202f, 40.63249931f, 
40.64480287f, 40.65710270f, 40.66939882f, 40.68169121f, 
40.69397990f, 40.70626487f, 40.71854614f, 40.73082371f, 
40.74309757f, 40.75536774f, 40.76763422f, 40.77989701f, 
40.79215611f, 40.80441153f, 40.81666326f, 40.82891133f, 
40.84115571f, 40.85339643f, 40.86563348f, 40.87786687f, 
40.89009660f, 40.90232267f, 40.91454509f, 40.92676386f, 
40.93897898f, 40.95119046f, 40.96339830f, 40.97560250f, 
40.98780306f, 41.00000000f, 41.01219331f, 41.02438299f, 
41.03656906f, 41.04875150f, 41.06093034f, 41.07310556f, 
41.08527717f, 41.09744518f, 41.10960958f, 41.12177039f, 
41.13392760f, 41.14608122f, 41.15823125f, 41.17037770f, 
41.18252056f, 41.19465985f, 41.20679556f, 41.21892769f, 
41.23105626f, 41.24318125f, 41.25530269f, 41.26742056f, 
41.27953488f, 41.29164564f, 41.30375286f, 41.31585652f, 
41.32795664f, 41.34005322f, 41.35214626f, 41.36423576f, 
41.37632173f, 41.38840417f, 41.40048309f, 41.41255848f, 
41.42463035f, 41.43669871f, 41.44876355f, 41.46082488f, 
41.47288271f, 41.48493703f, 41.49698784f, 41.50903516f, 
41.52107898f, 41.53311931f, 41.54515616f, 41.55718951f, 
41.56921938f, 41.58124577f, 41.59326869f, 41.60528813f, 
41.61730409f, 41.62931659f, 41.64132563f, 41.65333120f, 
41.66533331f, 41.67733197f, 41.68932717f, 41.70131892f, 
41.71330723f, 41.72529209f, 41.73727351f, 41.74925149f, 
41.76122604f, 41.77319715f, 41.78516483f, 41.79712909f, 
41.80908992f, 41.82104733f, 41.83300133f, 41.84495191f, 
41.85689907f, 41.86884283f, 41.88078318f, 41.89272013f, 
41.90465368f, 41.91658383f, 41.92851059f, 41.94043395f, 
41.95235393f, 41.96427052f, 41.97618372f, 41.98809355f, 
42.00000000f, 42.01190308f, 42.02380278f, 42.03569911f, 
42.04759208f, 42.05948169f, 42.07136794f, 42.08325083f, 
42.09513036f, 42.10700654f, 42.11887938f, 42.13074887f, 
42.14261501f, 42.15447782f, 42.16633728f, 42.17819342f, 
42.19004622f, 42.20189569f, 42.21374184f, 42.22558466f, 
42.23742416f, 42.24926035f, 42.26109322f, 42.27292278f, 
42.28474902f, 42.29657197f, 42.30839160f, 42.32020794f, 
42.33202098f, 42.34383072f, 42.35563717f, 42.36744033f, 
42.37924020f, 42.39103679f, 42.40283009f, 42.41462012f, 
42.42640687f, 42.43819035f, 42.44997055f, 42.46174749f, 
42.47352116f, 42.48529157f, 42.49705872f, 42.50882261f, 
42.52058325f, 42.53234064f, 42.54409477f, 42.55584566f, 
42.56759331f, 42.57933771f, 42.59107888f, 42.60281681f, 
42.61455151f, 42.62628297f, 42.63801121f, 42.64973622f, 
42.66145802f, 42.67317659f, 42.68489194f, 42.69660408f, 
42.70831301f, 42.72001873f, 42.73172124f, 42.74342055f, 
42.75511665f, 42.76680956f, 42.77849927f, 42.79018579f, 
42.80186912f, 42.81354926f, 42.82522621f, 42.83689998f, 
42.84857057f, 42.86023798f, 42.87190222f, 42.88356328f, 
42.89522118f, 42.90687591f, 42.91852747f, 42.93017587f, 
42.94182111f, 42.95346319f, 42.96510212f, 42.97673789f, 
42.98837052f, 43.00000000f, 43.01162634f, 43.02324953f, 
43.03486958f, 43.04648650f, 43.05810028f, 43.06971093f, 
43.08131846f, 43.09292285f, 43.10452412f, 43.11612227f, 
43.12771731f, 43.13930922f, 43.15089802f, 43.16248371f, 
43.17406629f, 43.18564576f, 43.19722213f, 43.20879540f, 
43.22036557f, 43.23193264f, 43.24349662f, 43.25505751f, 
43.26661531f, 43.27817002f, 43.28972164f, 43.30127019f, 
43.31281566f, 43.32435804f, 43.33589736f, 43.34743360f, 
43.35896678f, 43.37049688f, 43.38202393f, 43.39354791f, 
43.40506883f, 43.41658669f, 43.42810150f, 43.43961326f, 
43.45112196f, 43.46262762f, 43.47413024f, 43.48562981f, 
43.49712634f, 43.50861984f, 43.52011029f, 43.53159772f, 
43.54308211f, 43.55456348f, 43.56604182f, 43.57751714f, 
43.58898944f, 43.60045871f, 43.61192497f, 43.62338822f, 
43.63484846f, 43.64630569f, 43.65775991f, 43.66921112f, 
43.68065934f, 43.69210455f, 43.70354677f, 43.71498599f, 
43.72642222f, 43.73785546f, 43.74928571f, 43.76071297f, 
43.77213726f, 43.78355856f, 43.79497688f, 43.80639223f, 
43.81780460f, 43.82921400f, 43.84062043f, 43.85202390f, 
43.86342440f, 43.87482194f, 43.88621651f, 43.89760814f, 
43.90899680f, 43.92038251f, 43.93176527f, 43.94314509f, 
43.95452195f, 43.96589587f, 43.97726685f, 43.98863490f, 
44.00000000f, 44.01136217f, 44.02272141f, 44.03407771f, 
44.04543109f, 44.05678154f, 44.06812907f, 44.07947368f, 
44.09081537f, 44.10215414f, 44.11349000f, 44.12482295f, 
44.13615298f, 44.14748011f, 44.15880433f, 44.17012565f, 
44.18144407f, 44.19275959f, 44.20407221f, 44.21538194f, 
44.22668877f, 44.23799272f, 44.24929378f, 44.26059195f, 
44.27188724f, 44.28317965f, 44.29446918f, 44.30575583f, 
44.31703961f, 44.32832052f, 44.33959855f, 44.35087372f, 
44.36214603f, 44.37341546f, 44.38468204f, 44.39594576f, 
44.40720662f, 44.41846463f, 44.42971978f, 44.44097209f, 
44.45222154f, 44.46346815f, 44.47471192f, 44.48595284f, 
44.49719092f, 44.50842617f, 44.51965858f, 44.53088816f, 
44.54211490f, 44.55333882f, 44.56455991f, 44.57577818f, 
44.58699362f, 44.59820624f, 44.60941605f, 44.62062303f, 
44.63182721f, 44.64302857f, 44.65422712f, 44.66542287f, 
44.67661581f, 44.68780594f, 44.69899328f, 44.71017781f, 
44.72135955f, 44.73253849f, 44.74371464f, 44.75488800f, 
44.76605857f, 44.77722635f, 44.78839135f, 44.79955357f, 
44.81071300f, 44.82186966f, 44.83302354f, 44.84417465f, 
44.85532298f, 44.86646855f, 44.87761134f, 44.88875137f, 
44.89988864f, 44.91102315f, 44.92215489f, 44.93328388f, 
44.94441011f, 44.95553359f, 44.96665431f, 44.97777229f, 
44.98888752f, 45.00000000f, 45.01110974f, 45.02221674f, 
45.03332100f, 45.04442252f, 45.05552130f, 45.06661736f, 
45.07771068f, 45.08880127f, 45.09988914f, 45.11097427f, 
45.12205669f, 45.13313639f, 45.14421336f, 45.15528762f, 
45.16635916f, 45.17742799f, 45.18849411f, 45.19955752f, 
45.21061822f, 45.22167622f, 45.23273151f, 45.24378410f, 
45.25483400f, 45.26588119f, 45.27692569f, 45.28796750f, 
45.29900661f, 45.31004304f, 45.32107677f, 45.33210783f, 
45.34313620f, 45.35416188f, 45.36518489f, 45.37620522f, 
45.38722287f, 45.39823785f, 45.40925016f, 45.42025980f, 
45.43126677f, 45.44227107f, 45.45327271f, 45.46427169f, 
45.47526800f, 45.48626166f, 45.49725266f, 45.50824101f, 
45.51922671f, 45.53020975f, 45.54119015f, 45.55216790f, 
45.56314300f, 45.57411546f, 45.58508528f, 45.59605246f, 
45.60701700f, 45.61797891f, 45.62893819f, 45.63989483f, 
45.65084884f, 45.66180023f, 45.67274899f, 45.68369512f, 
45.69463864f, 45.70557953f, 45.71651780f, 45.72745346f, 
45.73838650f, 45.74931693f, 45.76024475f, 45.77116997f, 
45.78209257f, 45.79301257f, 45.80392996f, 45.81484476f, 
45.82575695f, 45.83666655f, 45.84757355f, 45.85847795f, 
45.86937976f, 45.88027899f, 45.89117562f, 45.90206967f, 
45.91296113f, 45.92385001f, 45.93473631f, 45.94562003f, 
45.95650117f, 45.96737974f, 45.97825573f, 45.98912915f, 
46.00000000f, 46.01086828f, 46.02173400f, 46.03259715f, 
46.04345773f, 46.05431576f, 46.06517123f, 46.07602413f, 
46.08687449f, 46.09772229f, 46.10856753f, 46.11941023f, 
46.13025038f, 46.14108798f, 46.15192304f, 46.16275555f, 
46.17358552f, 46.18441296f, 46.19523785f, 46.20606021f, 
46.21688003f, 46.22769733f, 46.23851209f, 46.24932432f, 
46.26013402f, 46.27094121f, 46.28174586f, 46.29254800f, 
46.30334761f, 46.31414471f, 46.32493929f, 46.33573135f, 
46.34652091f, 46.35730795f, 46.36809248f, 46.37887450f, 
46.38965402f, 46.40043103f, 46.41120554f, 46.42197755f, 
46.43274706f, 46.44351408f, 46.45427860f, 46.46504062f, 
46.47580015f, 46.48655720f, 46.49731175f, 46.50806382f, 
46.51881340f, 46.52956050f, 46.54030511f, 46.55104725f, 
46.56178691f, 46.57252409f, 46.58325880f, 46.59399103f, 
46.60472079f, 46.61544808f, 46.62617291f, 46.63689527f, 
46.64761516f, 46.65833259f, 46.66904756f, 46.67976007f, 
46.69047012f, 46.70117772f, 46.71188286f, 46.72258554f, 
46.73328578f, 46.74398357f, 46.75467891f, 46.76537180f, 
46.77606225f, 46.78675026f, 46.79743583f, 46.80811895f, 
46.81879964f, 46.82947790f, 46.84015371f, 46.85082710f, 
46.86149806f, 46.87216658f, 46.88283268f, 46.89349635f, 
46.90415760f, 46.91481642f, 46.92547283f, 46.93612681f, 
46.94677838f, 46.95742753f, 46.96807426f, 46.97871859f, 
46.98936050f, 47.00000000f, 47.01063709f, 47.02127178f, 
47.03190407f, 47.04253395f, 47.05316142f, 47.06378650f, 
47.07440918f, 47.08502947f, 47.09564736f, 47.10626285f, 
47.11687596f, 47.12748667f, 47.13809500f, 47.14870094f, 
47.15930449f, 47.16990566f, 47.18050445f, 47.19110086f, 
47.20169488f, 47.21228654f, 47.22287581f, 47.23346271f, 
47.24404724f, 47.25462940f, 47.26520919f, 47.27578661f, 
47.28636167f, 47.29693436f, 47.30750469f, 47.31807266f, 
47.32863826f, 47.33920151f, 47.34976241f, 47.36032094f, 
47.37087713f, 47.38143096f, 47.39198244f, 47.40253158f, 
47.41307836f, 47.42362281f, 47.43416490f, 47.44470466f, 
47.45524207f, 47.46577715f, 47.47630988f, 47.48684028f, 
47.49736835f, 47.50789408f, 47.51841748f, 47.52893855f, 
47.53945730f, 47.54997371f, 47.56048780f, 47.57099957f, 
47.58150901f, 47.59201614f, 47.60252094f, 47.61302343f, 
47.62352360f, 47.63402146f, 47.64451700f, 47.65501023f, 
47.66550115f, 47.67598976f, 47.68647607f, 47.69696007f, 
47.70744177f, 47.71792116f, 47.72839826f, 47.73887305f, 
47.74934555f, 47.75981575f, 47.77028365f, 47.78074926f, 
47.79121258f, 47.80167361f, 47.81213235f, 47.82258880f, 
47.83304297f, 47.84349486f, 47.85394446f, 47.86439178f, 
47.87483681f, 47.88527958f, 47.89572006f, 47.90615827f, 
47.91659420f, 47.92702787f, 47.93745926f, 47.94788838f, 
47.95831523f, 47.96873982f, 47.97916214f, 47.98958220f, 
48.00000000f, 48.01041554f, 48.02082881f, 48.03123983f, 
48.04164860f, 48.05205511f, 48.06245936f, 48.07286137f, 
48.08326112f, 48.09365863f, 48.10405388f, 48.11444689f, 
48.12483766f, 48.13522619f, 48.14561247f, 48.15599651f, 
48.16637832f, 48.17675788f, 48.18713521f, 48.19751031f, 
48.20788317f, 48.21825380f, 48.22862221f, 48.23898838f, 
48.24935233f, 48.25971405f, 48.27007354f, 48.28043082f, 
48.29078587f, 48.30113870f, 48.31148932f, 48.32183771f, 
48.33218389f, 48.34252786f, 48.35286961f, 48.36320916f, 
48.37354649f, 48.38388161f, 48.39421453f, 48.40454524f, 
48.41487375f, 48.42520005f, 48.43552415f, 48.44584606f, 
48.45616576f, 48.46648326f, 48.47679857f, 48.48711169f, 
48.49742261f, 48.50773134f, 48.51803788f, 48.52834223f, 
48.53864440f, 48.54894438f, 48.55924217f, 48.56953778f, 
48.57983121f, 48.59012245f, 48.60041152f, 48.61069841f, 
48.62098312f, 48.63126566f, 48.64154603f, 48.65182422f, 
48.66210024f, 48.67237409f, 48.68264578f, 48.69291530f, 
48.70318265f, 48.71344784f, 48.72371086f, 48.73397172f, 
48.74423043f, 48.75448697f, 48.76474136f, 48.77499359f, 
48.78524367f, 48.79549160f, 48.80573737f, 48.81598099f, 
48.82622246f, 48.83646179f, 48.84669897f, 48.85693400f, 
48.86716689f, 48.87739764f, 48.88762625f, 48.89785271f, 
48.90807704f, 48.91829923f, 48.92851929f, 48.93873721f, 
48.94895300f, 48.95916666f, 48.96937819f, 48.97958759f, 
48.98979486f, 49.00000000f, 49.01020302f, 49.02040392f, 
49.03060269f, 49.04079934f, 49.05099387f, 49.06118629f, 
49.07137659f, 49.08156477f, 49.09175083f, 49.10193479f, 
49.11211663f, 49.12229636f, 49.13247399f, 49.14264950f, 
49.15282291f, 49.16299421f, 49.17316341f, 49.18333051f, 
49.19349550f, 49.20365840f, 49.21381920f, 49.22397790f, 
49.23413450f, 49.24428901f, 49.25444142f, 49.26459175f, 
49.27473998f, 49.28488612f, 49.29503018f, 49.30517214f, 
49.31531202f, 49.32544982f, 49.33558553f, 49.34571917f, 
49.35585072f, 49.36598019f, 49.37610758f, 49.38623290f, 
49.39635614f, 49.40647731f, 49.41659640f, 49.42671343f, 
49.43682838f, 49.44694126f, 49.45705208f, 49.46716082f, 
49.47726751f, 49.48737213f, 49.49747468f, 49.50757518f, 
49.51767361f, 49.52776999f, 49.53786431f, 49.54795657f, 
49.55804677f, 49.56813493f, 49.57822102f, 49.58830507f, 
49.59838707f, 49.60846702f, 49.61854492f, 49.62862077f, 
49.63869458f, 49.64876635f, 49.65883607f, 49.66890375f, 
49.67896939f, 49.68903300f, 49.69909456f, 49.70915409f, 
49.71921158f, 49.72926704f, 49.73932046f, 49.74937186f, 
49.75942122f, 49.76946855f, 49.77951386f, 49.78955714f, 
49.79959839f, 49.80963762f, 49.81967483f, 49.82971001f, 
49.83974318f, 49.84977432f, 49.85980345f, 49.86983056f, 
49.87985565f, 49.88987873f, 49.89989980f, 49.90991885f, 
49.91993590f, 49.92995093f, 49.93996396f, 49.94997497f, 
49.95998399f, 49.96999099f, 49.97999600f, 49.98999900f, 
50.00000000f, 50.00999900f, 50.01999600f, 50.02999101f, 
50.03998401f, 50.04997502f, 50.05996404f, 50.06995107f, 
50.07993610f, 50.08991915f, 50.09990020f, 50.10987927f, 
50.11985634f, 50.12983144f, 50.13980455f, 50.14977567f, 
50.15974482f, 50.16971198f, 50.17967716f, 50.18964037f, 
50.19960159f, 50.20956084f, 50.21951812f, 50.22947342f, 
50.23942675f, 50.24937811f, 50.25932749f, 50.26927491f, 
50.27922036f, 50.28916384f, 50.29910536f, 50.30904491f, 
50.31898250f, 50.32891813f, 50.33885179f, 50.34878350f, 
50.35871325f, 50.36864104f, 50.37856687f, 50.38849075f, 
50.39841267f, 50.40833264f, 50.41825066f, 50.42816673f, 
50.43808085f, 50.44799302f, 50.45790325f, 50.46781152f, 
50.47771786f, 50.48762225f, 50.49752469f, 50.50742520f, 
50.51732376f, 50.52722039f, 50.53711507f, 50.54700782f, 
50.55689864f, 50.56678752f, 50.57667447f, 50.58655948f, 
50.59644256f, 50.60632372f, 50.61620294f, 50.62608024f, 
50.63595560f, 50.64582905f, 50.65570057f, 50.66557016f, 
50.67543784f, 50.68530359f, 50.69516742f, 50.70502934f, 
50.71488933f, 50.72474741f, 50.73460358f, 50.74445783f, 
50.75431016f, 50.76416059f, 50.77400910f, 50.78385570f, 
50.79370040f, 50.80354318f, 50.81338406f, 50.82322304f, 
50.83306011f, 50.84289528f, 50.85272854f, 50.86255990f, 
50.87238937f, 50.88221693f, 50.89204260f, 50.90186637f, 
50.91168825f, 50.92150823f, 50.93132631f, 50.94114251f, 
50.95095681f, 50.96076922f, 50.97057975f, 50.98038839f, 
50.99019514f, 51.00000000f, 51.00980298f, 51.01960408f, 
51.02940329f, 51.03920062f, 51.04899607f, 51.05878964f, 
51.06858134f, 51.07837116f, 51.08815910f, 51.09794516f, 
51.10772936f, 51.11751168f, 51.12729212f, 51.13707070f, 
51.14684741f, 51.15662225f, 51.16639522f, 51.17616633f, 
51.18593557f, 51.19570294f, 51.20546846f, 51.21523211f, 
51.22499390f, 51.23475383f, 51.24451190f, 51.25426811f, 
51.26402247f, 51.27377497f, 51.28352562f, 51.29327441f, 
51.30302135f, 51.31276644f, 51.32250968f, 51.33225107f, 
51.34199061f, 51.35172831f, 51.36146415f, 51.37119816f, 
51.38093031f, 51.39066063f, 51.40038910f, 51.41011574f, 
51.41984053f, 51.42956348f, 51.43928460f, 51.44900388f, 
51.45872132f, 51.46843693f, 51.47815070f, 51.48786265f, 
51.49757276f, 51.50728104f, 51.51698749f, 51.52669211f, 
51.53639491f, 51.54609588f, 51.55579502f, 51.56549234f, 
51.57518783f, 51.58488151f, 51.59457336f, 51.60426339f, 
51.61395160f, 51.62363800f, 51.63332257f, 51.64300533f, 
51.65268628f, 51.66236541f, 51.67204273f, 51.68171824f, 
51.69139193f, 51.70106382f, 51.71073390f, 51.72040216f, 
51.73006863f, 51.73973328f, 51.74939613f, 51.75905718f, 
51.76871642f, 51.77837386f, 51.78802950f, 51.79768335f, 
51.80733539f, 51.81698563f, 51.82663408f, 51.83628073f, 
51.84592559f, 51.85556865f, 51.86520992f, 51.87484940f, 
51.88448708f, 51.89412298f, 51.90375709f, 51.91338941f, 
51.92301994f, 51.93264869f, 51.94227565f, 51.95190083f, 
51.96152423f, 51.97114584f, 51.98076567f, 51.99038373f, 
52.00000000f, 52.00961450f, 52.01922721f, 52.02883816f, 
52.03844733f, 52.04805472f, 52.05766034f, 52.06726419f, 
52.07686627f, 52.08646657f, 52.09606511f, 52.10566188f, 
52.11525688f, 52.12485012f, 52.13444159f, 52.14403130f, 
52.15361924f, 52.16320542f, 52.17278984f, 52.18237250f, 
52.19195340f, 52.20153254f, 52.21110993f, 52.22068556f, 
52.23025943f, 52.23983155f, 52.24940191f, 52.25897052f, 
52.26853738f, 52.27810249f, 52.28766585f, 52.29722746f, 
52.30678732f, 52.31634544f, 52.32590181f, 52.33545643f, 
52.34500931f, 52.35456045f, 52.36410985f, 52.37365750f, 
52.38320341f, 52.39274759f, 52.40229003f, 52.41183073f, 
52.42136969f, 52.43090692f, 52.44044241f, 52.44997617f, 
52.45950819f, 52.46903849f, 52.47856705f, 52.48809389f, 
52.49761899f, 52.50714237f, 52.51666402f, 52.52618395f, 
52.53570215f, 52.54521862f, 52.55473337f, 52.56424640f, 
52.57375771f, 52.58326730f, 52.59277517f, 52.60228132f, 
52.61178575f, 52.62128847f, 52.63078947f, 52.64028875f, 
52.64978632f, 52.65928218f, 52.66877633f, 52.67826876f, 
52.68775949f, 52.69724851f, 52.70673581f, 52.71622141f, 
52.72570531f, 52.73518749f, 52.74466798f, 52.75414676f, 
52.76362383f, 52.77309921f, 52.78257288f, 52.79204486f, 
52.80151513f, 52.81098371f, 52.82045058f, 52.82991577f, 
52.83937925f, 52.84884105f, 52.85830115f, 52.86775955f, 
52.87721627f, 52.88667129f, 52.89612462f, 52.90557627f, 
52.91502622f, 52.92447449f, 52.93392107f, 52.94336597f, 
52.95280918f, 52.96225071f, 52.97169055f, 52.98112872f, 
52.99056520f, 53.00000000f, 53.00943312f, 53.01886457f, 
53.02829433f, 53.03772242f, 53.04714884f, 53.05657358f, 
53.06599665f, 53.07541804f, 53.08483776f, 53.09425581f, 
53.10367219f, 53.11308690f, 53.12249994f, 53.13191132f, 
53.14132102f, 53.15072906f, 53.16013544f, 53.16954015f, 
53.17894320f, 53.18834459f, 53.19774431f, 53.20714238f, 
53.21653878f, 53.22593353f, 53.23532662f, 53.24471805f, 
53.25410782f, 53.26349594f, 53.27288241f, 53.28226722f, 
53.29165038f, 53.30103188f, 53.31041174f, 53.31978995f, 
53.32916650f, 53.33854141f, 53.34791467f, 53.35728629f, 
53.36665626f, 53.37602458f, 53.38539126f, 53.39475630f, 
53.40411969f, 53.41348144f, 53.42284156f, 53.43220003f, 
53.44155686f, 53.45091206f, 53.46026562f, 53.46961754f, 
53.47896783f, 53.48831648f, 53.49766350f, 53.50700889f, 
53.51635264f, 53.52569476f, 53.53503526f, 53.54437412f, 
53.55371136f, 53.56304696f, 53.57238094f, 53.58171330f, 
53.59104403f, 53.60037313f, 53.60970061f, 53.61902647f, 
53.62835071f, 53.63767333f, 53.64699432f, 53.65631370f, 
53.66563146f, 53.67494760f, 53.68426213f, 53.69357503f, 
53.70288633f, 53.71219601f, 53.72150407f, 53.73081053f, 
53.74011537f, 53.74941860f, 53.75872022f, 53.76802024f, 
53.77731864f, 53.78661544f, 53.79591063f, 53.80520421f, 
53.81449619f, 53.82378656f, 53.83307533f, 53.84236250f, 
53.85164807f, 53.86093204f, 53.87021440f, 53.87949517f, 
53.88877434f, 53.89805191f, 53.90732789f, 53.91660227f, 
53.92587505f, 53.93514624f, 53.94441584f, 53.95368384f, 
53.96295025f, 53.97221507f, 53.98147831f, 53.99073995f, 
54.00000000f, 54.00925847f, 54.01851534f, 54.02777064f, 
54.03702434f, 54.04627647f, 54.05552701f, 54.06477596f, 
54.07402334f, 54.08326913f, 54.09251335f, 54.10175598f, 
54.11099703f, 54.12023651f, 54.12947441f, 54.13871073f, 
54.14794548f, 54.15717866f, 54.16641026f, 54.17564028f, 
54.18486874f, 54.19409562f, 54.20332093f, 54.21254467f, 
54.22176685f, 54.23098745f, 54.24020649f, 54.24942396f, 
54.25863987f, 54.26785420f, 54.27706698f, 54.28627819f, 
54.29548784f, 54.30469593f, 54.31390246f, 54.32310742f, 
54.33231083f, 54.34151268f, 54.35071297f, 54.35991170f, 
54.36910888f, 54.37830450f, 54.38749856f, 54.39669108f, 
54.40588203f, 54.41507144f, 54.42425930f, 54.43344560f, 
54.44263036f, 54.45181356f, 54.46099522f, 54.47017533f, 
54.47935389f, 54.48853090f, 54.49770637f, 54.50688030f, 
54.51605268f, 54.52522352f, 54.53439282f, 54.54356057f, 
54.55272679f, 54.56189146f, 54.57105460f, 54.58021620f, 
54.58937626f, 54.59853478f, 54.60769177f, 54.61684722f, 
54.62600113f, 54.63515352f, 54.64430437f, 54.65345369f, 
54.66260147f, 54.67174773f, 54.68089246f, 54.69003566f, 
54.69917732f, 54.70831747f, 54.71745608f, 54.72659317f, 
54.73572873f, 54.74486277f, 54.75399529f, 54.76312628f, 
54.77225575f, 54.78138370f, 54.79051013f, 54.79963504f, 
54.80875842f, 54.81788029f, 54.82700065f, 54.83611948f, 
54.84523680f, 54.85435261f, 54.86346690f, 54.87257967f, 
54.88169094f, 54.89080069f, 54.89990893f, 54.90901565f, 
54.91812087f, 54.92722458f, 54.93632678f, 54.94542747f, 
54.95452666f, 54.96362433f, 54.97272051f, 54.98181518f, 
54.99090834f, 55.00000000f, 55.00909016f, 55.01817881f, 
55.02726597f, 55.03635162f, 55.04543578f, 55.05451843f, 
55.06359959f, 55.07267925f, 55.08175742f, 55.09083408f, 
55.09990926f, 55.10898293f, 55.11805512f, 55.12712581f, 
55.13619501f, 55.14526272f, 55.15432893f, 55.16339366f, 
55.17245690f, 55.18151865f, 55.19057891f, 55.19963768f, 
55.20869497f, 55.21775077f, 55.22680509f, 55.23585792f, 
55.24490927f, 55.25395913f, 55.26300752f, 55.27205442f, 
55.28109984f, 55.29014379f, 55.29918625f, 55.30822724f, 
55.31726674f, 55.32630477f, 55.33534133f, 55.34437641f, 
55.35341001f, 55.36244214f, 55.37147280f, 55.38050198f, 
55.38952970f, 55.39855594f, 55.40758071f, 55.41660401f, 
55.42562584f, 55.43464621f, 55.44366510f, 55.45268253f, 
55.46169850f, 55.47071299f, 55.47972603f, 55.48873760f, 
55.49774770f, 55.50675635f, 55.51576353f, 55.52476925f, 
55.53377351f, 55.54277631f, 55.55177765f, 55.56077753f, 
55.56977596f, 55.57877293f, 55.58776844f, 55.59676250f, 
55.60575510f, 55.61474625f, 55.62373594f, 55.63272418f, 
55.64171097f, 55.65069631f, 55.65968020f, 55.66866264f, 
55.67764363f, 55.68662317f, 55.69560126f, 55.70457791f, 
55.71355311f, 55.72252686f, 55.73149917f, 55.74047004f, 
55.74943946f, 55.75840744f, 55.76737397f, 55.77633907f, 
55.78530272f, 55.79426494f, 55.80322571f, 55.81218505f, 
55.82114295f, 55.83009941f, 55.83905443f, 55.84800802f, 
55.85696018f, 55.86591089f, 55.87486018f, 55.88380803f, 
55.89275445f, 55.90169944f, 55.91064299f, 55.91958512f, 
55.92852582f, 55.93746508f, 55.94640292f, 55.95533933f, 
55.96427432f, 55.97320788f, 55.98214001f, 55.99107072f, 
56.00000000f, 56.00892786f, 56.01785430f, 56.02677931f, 
56.03570290f, 56.04462508f, 56.05354583f, 56.06246516f, 
56.07138308f, 56.08029957f, 56.08921465f, 56.09812831f, 
56.10704056f, 56.11595139f, 56.12486080f, 56.13376880f, 
56.14267539f, 56.15158057f, 56.16048433f, 56.16938668f, 
56.17828762f, 56.18718715f, 56.19608527f, 56.20498199f, 
56.21387729f, 56.22277119f, 56.23166368f, 56.24055476f, 
56.24944444f, 56.25833272f, 56.26721959f, 56.27610505f, 
56.28498912f, 56.29387178f, 56.30275304f, 56.31163290f, 
56.32051136f, 56.32938842f, 56.33826408f, 56.34713835f, 
56.35601121f, 56.36488268f, 56.37375276f, 56.38262144f, 
56.39148872f, 56.40035461f, 56.40921910f, 56.41808221f, 
56.42694392f, 56.43580424f, 56.44466317f, 56.45352071f, 
56.46237685f, 56.47123161f, 56.48008499f, 56.48893697f, 
56.49778757f, 56.50663678f, 56.51548460f, 56.52433104f, 
56.53317610f, 56.54201977f, 56.55086206f, 56.55970297f, 
56.56854249f, 56.57738064f, 56.58621740f, 56.59505279f, 
56.60388679f, 56.61271942f, 56.62155067f, 56.63038054f, 
56.63920903f, 56.64803615f, 56.65686190f, 56.66568627f, 
56.67450926f, 56.68333088f, 56.69215113f, 56.70097001f, 
56.70978752f, 56.71860365f, 56.72741841f, 56.73623181f, 
56.74504384f, 56.75385449f, 56.76266379f, 56.77147171f, 
56.78027827f, 56.78908346f, 56.79788728f, 56.80668975f, 
56.81549085f, 56.82429058f, 56.83308895f, 56.84188596f, 
56.85068161f, 56.85947590f, 56.86826883f, 56.87706040f, 
56.88585061f, 56.89463947f, 56.90342696f, 56.91221310f, 
56.92099788f, 56.92978131f, 56.93856338f, 56.94734410f, 
56.95612346f, 56.96490147f, 56.97367813f, 56.98245344f, 
56.99122740f, 57.00000000f, 57.00877125f, 57.01754116f, 
57.02630972f, 57.03507693f, 57.04384279f, 57.05260730f, 
57.06137047f, 57.07013229f, 57.07889277f, 57.08765190f, 
57.09640969f, 57.10516614f, 57.11392125f, 57.12267501f, 
57.13142743f, 57.14017851f, 57.14892825f, 57.15767665f, 
57.16642371f, 57.17516944f, 57.18391382f, 57.19265687f, 
57.20139858f, 57.21013896f, 57.21887800f, 57.22761571f, 
57.23635209f, 57.24508713f, 57.25382083f, 57.26255321f, 
57.27128425f, 57.28001397f, 57.28874235f, 57.29746940f, 
57.30619513f, 57.31491952f, 57.32364259f, 57.33236433f, 
57.34108475f, 57.34980384f, 57.35852160f, 57.36723804f, 
57.37595315f, 57.38466694f, 57.39337941f, 57.40209055f, 
57.41080038f, 57.41950888f, 57.42821606f, 57.43692192f, 
57.44562647f, 57.45432969f, 57.46303159f, 57.47173218f, 
57.48043145f, 57.48912941f, 57.49782605f, 57.50652137f, 
57.51521538f, 57.52390807f, 57.53259945f, 57.54128952f, 
57.54997828f, 57.55866572f, 57.56735186f, 57.57603668f, 
57.58472020f, 57.59340240f, 57.60208330f, 57.61076288f, 
57.61944116f, 57.62811814f, 57.63679380f, 57.64546817f, 
57.65414122f, 57.66281297f, 57.67148342f, 57.68015257f, 
57.68882041f, 57.69748695f, 57.70615219f, 57.71481612f, 
57.72347876f, 57.73214010f, 57.74080013f, 57.74945887f, 
57.75811631f, 57.76677246f, 57.77542730f, 57.78408085f, 
57.79273311f, 57.80138407f, 57.81003373f, 57.81868210f, 
57.82732918f, 57.83597496f, 57.84461946f, 57.85326266f, 
57.86190457f, 57.87054518f, 57.87918451f, 57.88782255f, 
57.89645930f, 57.90509477f, 57.91372894f, 57.92236183f, 
57.93099343f, 57.93962375f, 57.94825278f, 57.95688052f, 
57.96550698f, 57.97413216f, 57.98275606f, 57.99137867f, 
58.00000000f, 58.00862005f, 58.01723882f, 58.02585631f, 
58.03447251f, 58.04308744f, 58.05170109f, 58.06031347f, 
58.06892456f, 58.07753438f, 58.08614293f, 58.09475019f, 
58.10335619f, 58.11196090f, 58.12056435f, 58.12916652f, 
58.13776741f, 58.14636704f, 58.15496539f, 58.16356248f, 
58.17215829f, 58.18075283f, 58.18934610f, 58.19793811f, 
58.20652884f, 58.21511831f, 58.22370651f, 58.23229345f, 
58.24087911f, 58.24946352f, 58.25804665f, 58.26662853f, 
58.27520914f, 58.28378848f, 58.29236657f, 58.30094339f, 
58.30951895f, 58.31809325f, 58.32666629f, 58.33523806f, 
58.34380858f, 58.35237784f, 58.36094585f, 58.36951259f, 
58.37807808f, 58.38664231f, 58.39520528f, 58.40376700f, 
58.41232747f, 58.42088668f, 58.42944463f, 58.43800133f, 
58.44655678f, 58.45511098f, 58.46366393f, 58.47221562f, 
58.48076607f, 58.48931526f, 58.49786321f, 58.50640991f, 
58.51495535f, 58.52349955f, 58.53204251f, 58.54058421f, 
58.54912467f, 58.55766389f, 58.56620186f, 58.57473858f, 
58.58327406f, 58.59180830f, 58.60034130f, 58.60887305f, 
58.61740356f, 58.62593283f, 58.63446086f, 58.64298765f, 
58.65151319f, 58.66003750f, 58.66856058f, 58.67708241f, 
58.68560300f, 58.69412236f, 58.70264049f, 58.71115737f, 
58.71967302f, 58.72818744f, 58.73670062f, 58.74521257f, 
58.75372329f, 58.76223277f, 58.77074102f, 58.77924804f, 
58.78775383f, 58.79625838f, 58.80476171f, 58.81326381f, 
58.82176468f, 58.83026432f, 58.83876273f, 58.84725992f, 
58.85575588f, 58.86425061f, 58.87274412f, 58.88123640f, 
58.88972746f, 58.89821729f, 58.90670590f, 58.91519329f, 
58.92367945f, 58.93216439f, 58.94064811f, 58.94913061f, 
58.95761189f, 58.96609195f, 58.97457079f, 58.98304841f, 
58.99152482f, 59.00000000f, 59.00847397f, 59.01694672f, 
59.02541825f, 59.03388857f, 59.04235768f, 59.05082557f, 
59.05929224f, 59.06775770f, 59.07622195f, 59.08468499f, 
59.09314681f, 59.10160742f, 59.11006682f, 59.11852502f, 
59.12698200f, 59.13543777f, 59.14389233f, 59.15234568f, 
59.16079783f, 59.16924877f, 59.17769850f, 59.18614703f, 
59.19459435f, 59.20304046f, 59.21148537f, 59.21992908f, 
59.22837158f, 59.23681288f, 59.24525297f, 59.25369187f, 
59.26212956f, 59.27056605f, 59.27900134f, 59.28743543f, 
59.29586832f, 59.30430001f, 59.31273051f, 59.32115980f, 
59.32958790f, 59.33801480f, 59.34644050f, 59.35486501f, 
59.36328832f, 59.37171044f, 59.38013136f, 59.38855109f, 
59.39696962f, 59.40538696f, 59.41380311f, 59.42221807f, 
59.43063183f, 59.43904441f, 59.44745579f, 59.45586598f, 
59.46427499f, 59.47268280f, 59.48108943f, 59.48949487f, 
59.49789912f, 59.50630219f, 59.51470407f, 59.52310476f, 
59.53150426f, 59.53990259f, 59.54829972f, 59.55669568f, 
59.56509045f, 59.57348403f, 59.58187644f, 59.59026766f, 
59.59865770f, 59.60704656f, 59.61543424f, 59.62382074f, 
59.63220606f, 59.64059020f, 59.64897317f, 59.65735495f, 
59.66573556f, 59.67411499f, 59.68249325f, 59.69087032f, 
59.69924623f, 59.70762095f, 59.71599451f, 59.72436689f, 
59.73273809f, 59.74110812f, 59.74947699f, 59.75784467f, 
59.76621119f, 59.77457654f, 59.78294071f, 59.79130372f, 
59.79966555f, 59.80802622f, 59.81638571f, 59.82474404f, 
59.83310121f, 59.84145720f, 59.84981203f, 59.85816569f, 
59.86651819f, 59.87486952f, 59.88321969f, 59.89156869f, 
59.89991653f, 59.90826320f, 59.91660872f, 59.92495307f, 
59.93329626f, 59.94163828f, 59.94997915f, 59.95831886f, 
59.96665740f, 59.97499479f, 59.98333102f, 59.99166609f, 
60.00000000f, 60.00833275f, 60.01666435f, 60.02499479f, 
60.03332408f, 60.04165221f, 60.04997918f, 60.05830500f, 
60.06662967f, 60.07495318f, 60.08327554f, 60.09159675f, 
60.09991681f, 60.10823571f, 60.11655346f, 60.12487006f, 
60.13318551f, 60.14149982f, 60.14981297f, 60.15812497f, 
60.16643583f, 60.17474553f, 60.18305409f, 60.19136151f, 
60.19966777f, 60.20797289f, 60.21627687f, 60.22457970f, 
60.23288139f, 60.24118193f, 60.24948133f, 60.25777958f, 
60.26607669f, 60.27437266f, 60.28266749f, 60.29096118f, 
60.29925373f, 60.30754513f, 60.31583540f, 60.32412453f, 
60.33241252f, 60.34069937f, 60.34898508f, 60.35726965f, 
60.36555309f, 60.37383539f, 60.38211656f, 60.39039659f, 
60.39867548f, 60.40695324f, 60.41522987f, 60.42350536f, 
60.43177972f, 60.44005295f, 60.44832504f, 60.45659600f, 
60.46486583f, 60.47313453f, 60.48140210f, 60.48966854f, 
60.49793385f, 60.50619803f, 60.51446108f, 60.52272301f, 
60.53098380f, 60.53924347f, 60.54750201f, 60.55575943f, 
60.56401572f, 60.57227088f, 60.58052492f, 60.58877784f, 
60.59702963f, 60.60528030f, 60.61352984f, 60.62177826f, 
60.63002556f, 60.63827174f, 60.64651680f, 60.65476074f, 
60.66300355f, 60.67124525f, 60.67948583f, 60.68772528f, 
60.69596362f, 60.70420084f, 60.71243695f, 60.72067193f, 
60.72890580f, 60.73713856f, 60.74537019f, 60.75360072f, 
60.76183012f, 60.77005842f, 60.77828560f, 60.78651166f, 
60.79473661f, 60.80296045f, 60.81118318f, 60.81940480f, 
60.82762530f, 60.83584470f, 60.84406298f, 60.85228015f, 
60.86049622f, 60.86871117f, 60.87692502f, 60.88513776f, 
60.89334939f, 60.90155991f, 60.90976933f, 60.91797764f, 
60.92618485f, 60.93439095f, 60.94259594f, 60.95079983f, 
60.95900262f, 60.96720430f, 60.97540488f, 60.98360435f, 
60.99180273f, 61.00000000f, 61.00819617f, 61.01639124f, 
61.02458521f, 61.03277808f, 61.04096985f, 61.04916052f, 
61.05735009f, 61.06553856f, 61.07372594f, 61.08191222f, 
61.09009740f, 61.09828148f, 61.10646447f, 61.11464636f, 
61.12282716f, 61.13100686f, 61.13918547f, 61.14736298f, 
61.15553941f, 61.16371473f, 61.17188897f, 61.18006211f, 
61.18823416f, 61.19640512f, 61.20457499f, 61.21274377f, 
61.22091146f, 61.22907806f, 61.23724357f, 61.24540799f, 
61.25357132f, 61.26173357f, 61.26989473f, 61.27805480f, 
61.28621378f, 61.29437168f, 61.30252850f, 61.31068422f, 
61.31883887f, 61.32699243f, 61.33514490f, 61.34329629f, 
61.35144660f, 61.35959583f, 61.36774397f, 61.37589103f, 
61.38403701f, 61.39218191f, 61.40032573f, 61.40846847f, 
61.41661013f, 61.42475071f, 61.43289021f, 61.44102864f, 
61.44916598f, 61.45730225f, 61.46543744f, 61.47357156f, 
61.48170460f, 61.48983656f, 61.49796745f, 61.50609726f, 
61.51422600f, 61.52235366f, 61.53048025f, 61.53860577f, 
61.54673021f, 61.55485359f, 61.56297589f, 61.57109712f, 
61.57921727f, 61.58733636f, 61.59545438f, 61.60357133f, 
61.61168720f, 61.61980201f, 61.62791575f, 61.63602842f, 
61.64414003f, 61.65225057f, 61.66036004f, 61.66846844f, 
61.67657578f, 61.68468205f, 61.69278726f, 61.70089140f, 
61.70899448f, 61.71709650f, 61.72519745f, 61.73329734f, 
61.74139616f, 61.74949393f, 61.75759063f, 61.76568627f, 
61.77378085f, 61.78187436f, 61.78996682f, 61.79805822f, 
61.80614856f, 61.81423784f, 61.82232606f, 61.83041323f, 
61.83849933f, 61.84658438f, 61.85466838f, 61.86275131f, 
61.87083319f, 61.87891402f, 61.88699379f, 61.89507250f, 
61.90315016f, 61.91122677f, 61.91930232f, 61.92737682f, 
61.93545027f, 61.94352266f, 61.95159401f, 61.95966430f, 
61.96773354f, 61.97580173f, 61.98386887f, 61.99193496f, 
62.00000000f, 62.00806399f, 62.01612693f, 62.02418883f, 
62.03224968f, 62.04030948f, 62.04836823f, 62.05642594f, 
62.06448260f, 62.07253821f, 62.08059278f, 62.08864631f, 
62.09669879f, 62.10475022f, 62.11280061f, 62.12084996f, 
62.12889827f, 62.13694553f, 62.14499175f, 62.15303693f, 
62.16108107f, 62.16912417f, 62.17716623f, 62.18520724f, 
62.19324722f, 62.20128616f, 62.20932406f, 62.21736092f, 
62.22539674f, 62.23343153f, 62.24146528f, 62.24949799f, 
62.25752967f, 62.26556030f, 62.27358991f, 62.28161848f, 
62.28964601f, 62.29767251f, 62.30569797f, 62.31372241f, 
62.32174580f, 62.32976817f, 62.33778950f, 62.34580980f, 
62.35382907f, 62.36184731f, 62.36986452f, 62.37788070f, 
62.38589584f, 62.39390996f, 62.40192305f, 62.40993511f, 
62.41794614f, 62.42595614f, 62.43396512f, 62.44197306f, 
62.44997998f, 62.45798588f, 62.46599075f, 62.47399459f, 
62.48199741f, 62.48999920f, 62.49799997f, 62.50599971f, 
62.51399843f, 62.52199613f, 62.52999280f, 62.53798846f, 
62.54598308f, 62.55397669f, 62.56196928f, 62.56996084f, 
62.57795139f, 62.58594091f, 62.59392942f, 62.60191690f, 
62.60990337f, 62.61788882f, 62.62587325f, 62.63385666f, 
62.64183905f, 62.64982043f, 62.65780079f, 62.66578014f, 
62.67375846f, 62.68173578f, 62.68971207f, 62.69768736f, 
62.70566163f, 62.71363488f, 62.72160712f, 62.72957835f, 
62.73754857f, 62.74551777f, 62.75348596f, 62.76145314f, 
62.76941931f, 62.77738446f, 62.78534861f, 62.79331175f, 
62.80127387f, 62.80923499f, 62.81719510f, 62.82515420f, 
62.83311229f, 62.84106937f, 62.84902545f, 62.85698052f, 
62.86493458f, 62.87288764f, 62.88083969f, 62.88879073f, 
62.89674077f, 62.90468981f, 62.91263784f, 62.92058487f, 
62.92853089f, 62.93647591f, 62.94441993f, 62.95236294f, 
62.96030495f, 62.96824597f, 62.97618598f, 62.98412498f, 
62.99206299f, 63.00000000f, 63.00793601f, 63.01587102f, 
63.02380503f, 63.03173804f, 63.03967005f, 63.04760106f, 
63.05553108f, 63.06346010f, 63.07138812f, 63.07931515f, 
63.08724118f, 63.09516622f, 63.10309026f, 63.11101330f, 
63.11893535f, 63.12685641f, 63.13477647f, 63.14269554f, 
63.15061362f, 63.15853070f, 63.16644679f, 63.17436189f, 
63.18227600f, 63.19018911f, 63.19810124f, 63.20601237f, 
63.21392252f, 63.22183167f, 63.22973984f, 63.23764702f, 
63.24555320f 
#endif
};


/* ******************************************************************
 *      Function Name: DT_f_sqrt()
 *
 *      Description: Returns the square root
 *
 *      Arguments: float input	Value to find the square root
 *
 *      Return Value: float
 *
 *      Comments: if value falls with range of data in sqrttable use 
 *				  the array otherwise use sqrt()
 * *****************************************************************/
float DT_f_sqrt(float input)
{	
	int pos = (int)input;
	unsigned int nValues = sizeof(sqrttable) / sizeof(float);

	if( pos > 40000 )
	{	return (float)(sqrt(input));
	}
	if( -pos > 40000 )
	{	return (float)(-sqrt(-input));
	}
	if( pos > 400 )
	{	return (float)(sqrttable[pos/100]*10.0f);
	}
	if( -pos > 400 )
	{	return (float)(-sqrttable[-pos/100]*10.0f);
	}
	if( pos < 0 )
	{	return(-sqrttable[-pos]);
	}
	return(sqrttable[pos]);
}
#endif //HLSYN