#include <string.h>
#include "FonixTtsDtSimple.h"

#ifdef MICRODECTALK
#include "epsonapi.h"
#else
#include "simpleapi.h"
#endif

#ifdef OS_SYMBIAN
#include "GlobalDT.h"
#include "kernel.h"
#include <stdio.h>
#endif

#ifndef OS_SYMBIAN
#ifdef AD_VDSP
section("INTERNAL_DATA") volatile FTTSDTUDATA_T gDECtalkUserData;
#else
volatile FTTSDTUDATA_T gDECtalkUserData;
#endif
volatile FTTSDTUDATA_T *gpDECtalkUserData = NULL;
#else
short *FnxTTSDTSimpleCollectCallback(short *output_buf,long error, void* pUserData);
void CleanupMemory();
void SetGlobalData(GlobalDTPtr data);
#endif //OS_SYMBIAN

void TextToSpeechSetDictPath(char* pDictPath);
void TextToSpeechSetTablePath(char* pTablePath);
#if defined(__cplusplus)
extern "C" {
#endif
/*******************************************************************************
int FnxTTSDtSimpleCallback(short *output_buf,long error)
intilizes the TTS
Accepts a pointer to a array of 'short' and a 'long' error / status flag
     (size is 71 for 11Khz samplerate or 51 for 8Khz)
Returns a pointer to a buffer of shorts to receive the next data generated by 
the engine.  Returning a NULL for the buffer aborts the current synthesis 
operation
*******************************************************************************/
#ifdef AD_VDSP
section("INTERNAL_PROGRAM") short *FnxTTSDtSimpleCallback(short *output_buf,long error)
#elif !defined(OS_SYMBIAN)
short *FnxTTSDtSimpleCallback(short *output_buf,long error)
#else
short *FnxTTSDtSimpleCallback(short *output_buf,long error, void* pUserData)
#endif
{
  int reqLength = 0;
#ifdef OS_SYMBIAN
  GlobalDTPtr vgp = GetGlobalDTPtr();
  FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
#endif

  switch (error)
  {
  	case 0:
	  // Calculate the required buffer length to contain the next buffer
		if (gpDECtalkUserData->gDECtalkFlags > 2)
		  return(NULL);

#ifdef MICRODECTALK
		if( !gpDECtalkUserData->gDECtalkOverflow )
		{
#ifdef SUPPORT_ULAW
			memcpy( (char *)((char *)gpDECtalkUserData->gDECtalkBufPtr + gpDECtalkUserData->gDECtalkBufPos), output_buf, gpDECtalkUserData->gDECtalkPktSize[gpDECtalkUserData->gDECtalkFlags] * sizeof(unsigned char) );
#else
			memcpy( (char *)(gpDECtalkUserData->gDECtalkBufPtr + gpDECtalkUserData->gDECtalkBufPos), output_buf, gpDECtalkUserData->gDECtalkPktSize[gpDECtalkUserData->gDECtalkFlags] * sizeof(short) );
#endif
		}
#endif
		// Increment the buffer position pointer
		gpDECtalkUserData->gDECtalkBufPos += 
			gpDECtalkUserData->gDECtalkPktSize[gpDECtalkUserData->gDECtalkFlags];
			
#if 0
	   // Dump the buffer to the screen for debug 
		int i;
		unsigned long j;
		for (i=0;i<71;i++)
		{
			j=output_buf[i];
			if (i && i%8==0)
			{
				printf("\n");
			}
			printf("0x%04X ",j&0xFFFF);
		}
		printf("\n");
#endif
	
		// See if the buffer has enough room for the next buffer
		reqLength = gpDECtalkUserData->gDECtalkBufPos + gpDECtalkUserData->gDECtalkPktSize[gpDECtalkUserData->gDECtalkFlags];
		if (reqLength > gpDECtalkUserData->gDECtalkBufSize)
		  {
			 // If not, Indicate it and use the dummy buffer
			 gpDECtalkUserData->gDECtalkOverflow = 1;
			 return((short *)gpDECtalkUserData->gDECtalkDmyBuffer);
		  }
	
		return((short *)(gpDECtalkUserData->gDECtalkBufPtr + gpDECtalkUserData->gDECtalkBufPos));
		break;
	case 3:
		gpDECtalkUserData->gDECtalkLastIndex[0] = (short)*(output_buf);
		gpDECtalkUserData->gDECtalkLastIndex[1] = (short)*(output_buf+1);
		return((short *)(gpDECtalkUserData->gDECtalkBufPtr + gpDECtalkUserData->gDECtalkBufPos));
		break;
	default:
		return (NULL);
		break;
  }
	
}

/*******************************************************************************
int FnxTTSDtSimpleOpen(short *(*callback)(short *,long),void * user_dict,
						char *dictname,char *tablename )
initializes the TTS
Accepts a 'callback' function, a user dictionary, a dictionary and table as input
  The callback function is called by the engine whenever there is output data
  (either audio data or index marks) for the user to handle.
  If a NULL is passed in for this callback function, the API uses an internal
  callback function.
For the dictname and tablename, include the path if necessary for your platform.
If using memfiles, no path is necessary. 
Most platforms will use NULL for the tablename.
The dictname will typically be something like dtalk_us.dic.
Returns the completion/error status flag
*******************************************************************************/
#if !defined(OS_SYMBIAN)
int FnxTTSDtSimpleOpen(short *(*callback)(short *,long),void *user_dict, char *dictname,char *tablename)
#else
int FnxTTSDtSimpleOpen(short *(*callback)(short *,long, void*),void *user_dict, void* user_data, char *dictname,char *tablename)
#endif
{
	int retval = -1;
#ifdef OS_SYMBIAN
	GlobalDTPtr vgp = GetGlobalDTPtr();
	FTTSDTUDATA_T* gpDECtalkUserData = (FTTSDTUDATA_T*)calloc(1, sizeof(FTTSDTUDATA_T));
	vgp->gpDECtalkUserData = gpDECtalkUserData;
#else
	gpDECtalkUserData = &gDECtalkUserData;
#endif
	
	gpDECtalkUserData->gDECtalkStatus = DT_IN_USE;

//  if(( !gpDECtalkUserData->gDECtalkInit ) || (gpDECtalkUserData->gDECtalkUserDict != user_dict))
//	 {
		gpDECtalkUserData->gDECtalkPktSize[0] = gpDECtalkUserData->gDECtalkPktSize[1] = 71;
		gpDECtalkUserData->gDECtalkPktSize[2] = 51;
		gpDECtalkUserData->gDECtalkBufPos = 0;
		gpDECtalkUserData->gDECtalkBufPtr = NULL;
		gpDECtalkUserData->gDECtalkUserDict = user_dict;
		gpDECtalkUserData->gDECtalkLastIndex[0] = 0;
		gpDECtalkUserData->gDECtalkLastIndex[1] = 0;

		// these can be called for everyone
		TextToSpeechSetDictPath(dictname);
		TextToSpeechSetTablePath(tablename);

		if (callback == NULL)
		{
#ifndef OS_SYMBIAN
			retval = TextToSpeechInit(FnxTTSDtSimpleCallback,user_dict);
#else
			retval = TextToSpeechInit(FnxTTSDtSimpleCallback,user_dict, user_data);
#endif
			gpDECtalkUserData->gDECtalkUserCallback = 0;
		}
		else
		{
#ifndef OS_SYMBIAN
			retval = TextToSpeechInit(callback,user_dict);
#else
			vgp->simpleData.g_usercallback = callback;
			retval = TextToSpeechInit(FnxTTSDTSimpleCollectCallback,user_dict, user_data);
#endif
			gpDECtalkUserData->gDECtalkUserCallback = 1;
		}

		gpDECtalkUserData->gDECtalkVoiceID = 0;
		if( !retval )
			gpDECtalkUserData->gDECtalkInit = 1;
		else
			gpDECtalkUserData->gDECtalkInit = 0;

//	 }
	gpDECtalkUserData->gDECtalkStatus = DT_AVAILABLE;
	return(retval);
}

/*******************************************************************************
void FnxTTSDtSimpleClose()
closes the TTS core
*******************************************************************************/
void FnxTTSDtSimpleClose()
{
#ifdef OS_SYMBIAN
	GlobalDTPtr vgp = GetGlobalDTPtr();
	FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
#endif
	gpDECtalkUserData->gDECtalkStatus = DT_IN_USE;

// loading the dictionary from an external file uses mallocs
// and USE_NAND closes the dictionary
// so !DICT_IN_MEMORY requires cleanup
#if !defined DICT_IN_MEMORY
	if(gpDECtalkUserData && gpDECtalkUserData->gDECtalkInit)
		TextToSpeechUnloadDictionary();

//#ifdef ALLOC_MEMORY
	// calling this now because of the memory leaks in pDph_t->speaker_rom_ptr
	// will eventually only be called for ALLOC_MEMORY
	CleanupMemory();
//#endif
#else
	TextToSpeechReset( FULL_ENGINE_RESET );
#endif //DICT_IN_MEMORY

#ifndef OS_SYMBIAN
	gpDECtalkUserData->gDECtalkStatus = DT_AVAILABLE;
	gpDECtalkUserData = NULL;
#endif
	return;
}

/*******************************************************************************
void FnxTTSDtSimpleStart(char *String,short *buffer,int buflength,int flags )
creates raw audio output and stores it in the supplied buffer for the input string
Accepts an input string, buffer, length, and format flag as input
Returns the number of samples or a negative value for error status
If the synthesized wave is larger than the buffer, only that portion
which will fit in the buffer is returned and the buffer length required is
returned as a negative number of samples.

*******************************************************************************/
int FnxTTSDtSimpleStart(char *String, short *buffer,int buflength,int flags, char *dictname,char *tablename)
{
	int retval = 0;
#ifdef OS_SYMBIAN
	GlobalDTPtr vgp = GetGlobalDTPtr();
	FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
	if(flags & OUTPUT_QUEUE)
	{
		flags = flags ^ OUTPUT_QUEUE;
		vgp->output_queue = 1;
	}
	else if(flags & OUTPUT_STREAMING)
	{
		flags = flags ^ OUTPUT_STREAMING;
		vgp->output_queue = 0;
	}
#endif

	if(!gpDECtalkUserData || !gpDECtalkUserData->gDECtalkInit || gpDECtalkUserData->gDECtalkStatus == DT_IN_USE)
		return(1);

	if (flags < 1 || flags > 2)
		return(1);

	gpDECtalkUserData->gDECtalkStatus = DT_IN_USE;

#ifdef MICRODECTALK
	if( !gpDECtalkUserData->gDECtalkUserCallback )
	{
		if (buflength < gpDECtalkUserData->gDECtalkPktSize[flags])
			return(1);
		if( !buffer )
			return(1);
	}
#else
#ifdef OS_SYMBIAN // don't check buflength if going to a queue
	if (!vgp->output_queue && (buflength < gpDECtalkUserData->gDECtalkPktSize[flags]))
		return(1);
	else if(vgp->output_queue && !vgp->queueStruct.bFinished) 
	{
		// we must be in the middle of synthesizing, so don't start another thread.
		return(1);
	}
#endif
	if (buflength < gpDECtalkUserData->gDECtalkPktSize[flags])
		return(1);
#endif
	gpDECtalkUserData->gDECtalkBufSize = buflength;
	gpDECtalkUserData->gDECtalkBufPos = 0;
	gpDECtalkUserData->gDECtalkBufPtr = buffer;
	gpDECtalkUserData->gDECtalkFlags = flags;
	gpDECtalkUserData->gDECtalkOverflow = 0;

#ifdef OS_SYMBIAN
	if(vgp->output_queue) // if we're going to a queue, allocate the first buffer
	{
		gpDECtalkUserData->gDECtalkBufPtr = (short*)calloc(1, sizeof(short)*gpDECtalkUserData->gDECtalkPktSize[flags]);
		vgp->queueStruct.bufSize = gpDECtalkUserData->gDECtalkBufSize;
		ResetQueue();
	}
#endif

#ifdef MICRODECTALK
	retval = TextToSpeechStart( String );
#elif defined (OS_SYMBIAN)
	if(vgp->output_queue)
	{
		//retval = TextToSpeechStart( String , (short *)gpDECtalkUserData->gDECtalkBufPtr, gpDECtalkUserData->gDECtalkFlags);	
	// start thread with data?
		StartThread(String);
	}
	else
		retval = TextToSpeechStart( String , (short *)gpDECtalkUserData->gDECtalkBufPtr, gpDECtalkUserData->gDECtalkFlags);
#else
	retval = TextToSpeechStart( String , (short *)gpDECtalkUserData->gDECtalkBufPtr, gpDECtalkUserData->gDECtalkFlags);
#endif
	gpDECtalkUserData->gDECtalkStatus = DT_AVAILABLE;
	if (retval != 0)
		return(retval);
	return ((gpDECtalkUserData->gDECtalkOverflow == 1) ? (0 - gpDECtalkUserData->gDECtalkBufPos) : gpDECtalkUserData->gDECtalkBufPos);
}

/*******************************************************************************
void FnxTTSDtSimpleChangeVoice(FnxDECtalkVoiceId NewVoice, int flags)
creates audio output and plays for the input string
*******************************************************************************/
void FnxTTSDtSimpleChangeVoice( FnxDECtalkVoiceId NewVoice ,int flags )
{
	char Name[18] = "\0";
	int ret_val = 0;
	short NameBuf[213];
#ifdef OS_SYMBIAN
	GlobalDTPtr vgp = GetGlobalDTPtr();
	FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
#endif

	if(!gpDECtalkUserData || !gpDECtalkUserData->gDECtalkInit || gpDECtalkUserData->gDECtalkStatus == DT_IN_USE)
		return;

	gpDECtalkUserData->gDECtalkStatus = DT_IN_USE;
	gpDECtalkUserData->gDECtalkFlags = flags;

	switch(NewVoice)
	{
		case Harry:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nh");		/*harry*/
#else
			strcpy(Name, "[:name harry]");		/*harry*/
#endif
			break;
		}
		case Frank:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nf");		/*frank*/
#else
			strcpy(Name, "[:name frank]");		/*frank*/
#endif
			break;
		}
		case Dennis:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nd");		/*dennis*/
#else
			strcpy(Name, "[:name dennis]");		/*dennis*/
#endif
			break;
		}
		case Kit:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nk");		/*kit*/
#else
			strcpy(Name, "[:name kit]");		/*kit*/
#endif
			break;
		}
		case Betty:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nb");		/*betty*/
#else
			strcpy(Name, "[:name betty]");		/*betty*/
#endif
			break;
		}
		case Ursula:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nu");		/*ursula*/
#else
			strcpy(Name, "[:name ursula]");		/*ursula*/
#endif
			break;
		}
		case Rita:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nr");		/*rita*/
#else
			strcpy(Name, "[:name rita]");		/*rita*/
#endif
			break;
		}
		case Wendy:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nw");		/*wendy*/
#else
			strcpy(Name, "[:name wendy]");		/*wendy*/
#endif
			break;
		}
		case Paul:
		default:
		{
#ifdef MICRODECTALK
			strcpy(Name, "np");
#else
			strcpy(Name, "[:name paul]");
#endif
			break;
		}
	}
	gpDECtalkUserData->gDECtalkStatus = DT_AVAILABLE;	//need to set here so you will go through the TextToSpeechStart
#ifdef MICRODECTALK
	TextToSpeechChangeVoice( Name );
#else
	ret_val = FnxTTSDtSimpleStart(Name, NameBuf, 213, flags, gpDECtalkUserData->gDECtalkDictPath, gpDECtalkUserData->gDECtalkTablePath);
#endif
	gpDECtalkUserData->gDECtalkStatus = DT_AVAILABLE;
	gpDECtalkUserData->gDECtalkVoiceID = NewVoice;
}

/*******************************************************************************
void FnxTTSHaltSpeech()
Stops current TTS string
Returns the completion/error status flag
*******************************************************************************/
#if !defined(OS_SYMBIAN)
int FnxTTSDtSimpleHaltSpeech()
#else
int FnxTTSDtSimpleHaltSpeech(const void* threadData)
#endif
{
	int retval = 0;
#ifdef OS_SYMBIAN
	GlobalDTPtr vgp = NULL;
	FTTSDTUDATA_T* gpDECtalkUserData = NULL;

	if(threadData)
	{
		SetGlobalData((void*)threadData);
	}
	
	vgp = GetGlobalDTPtr();
	if(vgp)
	{
		gpDECtalkUserData = vgp->gpDECtalkUserData;
	}
#endif

	if(!gpDECtalkUserData || !gpDECtalkUserData->gDECtalkInit)
		return(1);

	retval = TextToSpeechReset( HALT_SPEECH_LEAVE_SETTINGS );

#ifdef OS_SYMBIAN
	// if we're going to a queue, we need to signal the thread so it
	// can exit gracefully
	if(vgp->output_queue)
		SignalThread();

	if(!threadData)
#endif
	return(retval);
}

/*******************************************************************************
void FnxTTSResetSpeech()
Resets the TTS Engine to the Default Parameters
Returns the completion/error status flag
*******************************************************************************/
int FnxTTSDtSimpleResetSpeech()
{
	int retval = 0;
#ifdef OS_SYMBIAN
	GlobalDTPtr vgp = GetGlobalDTPtr();
	FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
#endif

	if(!gpDECtalkUserData || !gpDECtalkUserData->gDECtalkInit || gpDECtalkUserData->gDECtalkStatus == DT_IN_USE)
		return(1);

	gpDECtalkUserData->gDECtalkStatus = DT_IN_USE;

	retval = TextToSpeechReset( FULL_ENGINE_RESET );
	gpDECtalkUserData->gDECtalkStatus = DT_AVAILABLE;
	return(retval);
}

/*******************************************************************************
int FnxTTSDtSimpleSetLanguage( FnxDECtalkLanguageId LanguageID, void *user_dict,
								char *dictname,char *tablename ) 
Sets the language.
Accepts a user dictionary, dictionary and table as input
Pass NULL for user_dict, dictname or tablename if unnecessary
Most platforms will pass NULL for the the tablename
Returns the completion/error status flag - if fails language is not changed
*******************************************************************************/
int FnxTTSDtSimpleSetLanguage( FnxDECtalkLanguageId LanguageID, void *user_dict, char *dictname,char *tablename )
{
	int retval = -1;

#ifdef MULTIPLE_LANGUAGES_LOADED
#ifdef OS_SYMBIAN
	GlobalDTPtr vgp = GetGlobalDTPtr();
	FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
#endif

	if(!gpDECtalkUserData || !gpDECtalkUserData->gDECtalkInit || gpDECtalkUserData->gDECtalkStatus == DT_IN_USE)
		return(1);

	gpDECtalkUserData->gDECtalkStatus = DT_IN_USE;
#if !defined USE_51 && defined CASIO_SH3
	if( LanguageID < US_English || ( LanguageID > Castilian_Spanish && LanguageID < UK_English ) || LanguageID > Italian )
#else
		if( LanguageID < US_English || LanguageID > Hebrew )
#endif
		return(-2);

	// call even if dictname/tablename is NULL
	TextToSpeechSetDictPath(dictname);
	TextToSpeechSetTablePath(tablename);

	if( !TextToSpeechChangeLanguage( LanguageID, user_dict ) )
	{
		gpDECtalkUserData->gDECtalkUserDict = user_dict;
		retval = 0;
	}
	else
		retval = -3;
	gpDECtalkUserData->gDECtalkStatus = DT_AVAILABLE;
#endif
	return(retval);
}

// This needs access to gpDECtalkUserData but is not exposed to the user right now
char* TextToSpeechGetDictPath()
{
#ifdef OS_SYMBIAN
	FTTSDTUDATA_T* gpDECtalkUserData = GetGlobalDTPtr()->gpDECtalkUserData;
#endif

	if(!gpDECtalkUserData)
		return NULL;
	else
		return (char*)(gpDECtalkUserData->gDECtalkDictPath);
}

char* TextToSpeechGetTablePath()
{
#ifdef OS_SYMBIAN
	FTTSDTUDATA_T* gpDECtalkUserData = GetGlobalDTPtr()->gpDECtalkUserData;
#endif

	if(!gpDECtalkUserData)
		return NULL;
	else
		return (char*)(gpDECtalkUserData->gDECtalkTablePath);
}

void TextToSpeechSetDictPath(char* pDictPath)
{
#ifdef OS_SYMBIAN
	FTTSDTUDATA_T* gpDECtalkUserData = GetGlobalDTPtr()->gpDECtalkUserData;
#else
	gpDECtalkUserData = &gDECtalkUserData;
#endif

	if(pDictPath)
	{
		strcpy((char*)(gpDECtalkUserData->gDECtalkDictPath), pDictPath);
	}
	else
	{
		strcpy((char*)(gpDECtalkUserData->gDECtalkDictPath), "");
	}
}

void TextToSpeechSetTablePath(char* pTablePath)
{
#ifdef OS_SYMBIAN
	FTTSDTUDATA_T* gpDECtalkUserData = GetGlobalDTPtr()->gpDECtalkUserData;
#else
	gpDECtalkUserData = &gDECtalkUserData;
#endif

	if(pTablePath)
	{
		strcpy((char*)(gpDECtalkUserData->gDECtalkTablePath), pTablePath);
	}
	else
	{
		strcpy((char*)(gpDECtalkUserData->gDECtalkTablePath), "");
	}
}

#ifdef OS_SYMBIAN
/*******************************************************************************
int FnxTTSDtSimpleCallback(short *output_buf,long error)
intilizes the TTS
Accepts a pointer to a array of 'short' and a 'long' error / status flag
     (size is 71 for 11Khz samplerate or 51 for 8Khz)
Returns a pointer to a buffer of shorts to receive the next data generated by 
the engine.  Returning a NULL for the buffer aborts the current synthesis 
operation
*******************************************************************************/
short *FnxTTSDTSimpleCollectCallback(short *output_buf,long error, void* pUserData)
{
  int reqLength = 0;
  GlobalDTPtr vgp = GetGlobalDTPtr();
  FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;

  switch (error)
  {
  	case 0: // NO ERROR
	  // Calculate the required buffer length to contain the next buffer
		if (gpDECtalkUserData->gDECtalkFlags > 2)
		  return(NULL);

		// Increment the buffer position pointer
		gpDECtalkUserData->gDECtalkBufPos += 
			gpDECtalkUserData->gDECtalkPktSize[gpDECtalkUserData->gDECtalkFlags];
	
		// See if the buffer has enough room for the next buffer
		reqLength = gpDECtalkUserData->gDECtalkBufPos + gpDECtalkUserData->gDECtalkPktSize[gpDECtalkUserData->gDECtalkFlags];
		if (reqLength > gpDECtalkUserData->gDECtalkBufSize)
		  {
			// if it doesn't call the user callback and then
			// reset the index
			gpDECtalkUserData->gDECtalkBufPtr = vgp->simpleData.g_usercallback((short*)gpDECtalkUserData->gDECtalkBufPtr, error, pUserData);
			gpDECtalkUserData->gDECtalkBufPos = 0;
		  }
	
		return((short *)(gpDECtalkUserData->gDECtalkBufPtr + gpDECtalkUserData->gDECtalkBufPos));
		break;
	case 3: // Index ??? What does this mean??
		gpDECtalkUserData->gDECtalkLastIndex[0] = (short)*(output_buf);
		gpDECtalkUserData->gDECtalkLastIndex[1] = (short)*(output_buf+1);
		return((short *)(gpDECtalkUserData->gDECtalkBufPtr + gpDECtalkUserData->gDECtalkBufPos));
		break;
	default:
		return (NULL);
		break;
  }
}

/*ifndef SYMBIAN_THREADING
int FnxTTSDtSimpleGetSpeechData(short* buffer, int buflength )
{
	GlobalDTPtr vgp = GetGlobalDTPtr();
	FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
	LPTTS_HANDLE_T phTTS = vgp->simpleData.phTTS;
	int copied = 0;
	short* data = NULL;
	const int pktSize = gpDECtalkUserData->gDECtalkPktSize[gpDECtalkUserData->gDECtalkFlags];

	while(!phTTS->pKernelShareData->halting && copied <= buflength - pktSize)
	{

		WaitForData();
		LockQueue();
		// fill buffer
		data = (short*)GetSpeechData();
		UnlockQueue();

		if(data)
		{
			memcpy(buffer+copied, data, pktSize*2);
			free(data);
			copied += pktSize;

		}
		else
			break;

	}

	return copied;
}
#else*/
int FnxTTSDtSimpleGetSpeechData(short* buffer, int buflength )
{
	GlobalDTPtr vgp = GetGlobalDTPtr();
//	FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
//	LPTTS_HANDLE_T phTTS = vgp->simpleData.phTTS;
	
	int total_copied = 0;
	vgp->queueStruct.bufSize = buflength;
/*	int copied;
	const int pktSize = gpDECtalkUserData->gDECtalkPktSize[gpDECtalkUserData->gDECtalkFlags] * 2;
	short* data = NULL;//[71*2];// = (short*)calloc(1, pktSize * sizeof(short));



	while(!phTTS->pKernelShareData->halting && total_copied <= buflength - (pktSize/2))
	{
		if(GetQueueCount() == 0 && vgp->queueStruct.bFinished)
			break;

		data = GetSpeechData(&copied);

		if(copied > 0)
		{
			memcpy(buffer+total_copied, data, pktSize);
			total_copied += pktSize;
			free(data);
			data = NULL;
		}
		else if(total_copied != 0)
			break;

	} 
	if(!vgp->queueStruct.bFinished)
	{
		SignalThread();
	}*/
	total_copied = GetSpeechData(buffer, buflength);
	//free(data);
	//data = NULL;
	return total_copied;
}

const void* FnxTTSDtSimpleGetThreadData()
{
	return GetThreadData();
}
#endif

#if defined(__cplusplus)
}
#endif
