#ifndef _IT_BUILDER_H_
#define _IT_BUILDER_H_
/* avoid multple inclusions */ 
#if !defined OS_PALM && !defined CASIO_SH3
#include<stdio.h>  
#endif
#include<stdlib.h>

#include "FileSystemDict.h"
#include "ItalianFileSystemDict.h"

#if defined EPSON_ARM7 || defined MULTIPLE_LANGUAGES_LOADED
#include "ltsnames.h"
#endif

#ifndef CONST
#define CONST const
#endif

#ifndef CONSTCONST
#ifdef OS_PALM
#define CONSTCONST
#else
#define CONSTCONST const
#endif
#endif

#ifndef _UNIX_LIKE_
#ifndef U16_DEFINED
#define U16_DEFINED
typedef unsigned short  U16;
#endif
#ifndef SHORT_DEFINED
#define SHORT_DEFINED
typedef short SHORT;
#endif
#endif

#include "bachusdefs.h"

#define BACHUSIT_IN_DECTALK


typedef 
struct  _IT_meta_trie_node
{
  ASCIILETTER *name;          // redundant except for compare strings nodes.
  U16  alt;                
  U16  what;                // for repeatables: pointer to self.
  U16  right;
  U16  index;               // index of symbols (same thing above)
  gnodetype typeinfo;       // 
  gnodeinfo  info;          // type,status, counter, parameter
}
IT_GTrieNode;


typedef 
struct _sorted_compressed_ltrie
{
    unsigned char letter;
    unsigned char c2;
    unsigned char c3;
}
IT_sortcomptrie;

typedef 
struct _associated_table
{
    U16 addr;
    U16 relptr;
//  U16 ruleno;            /* we have no rule numbers in Italian */
}
IT_assoctable;


typedef 
struct _sorted_lettertrie_block
{
	// MGS HELPME relace this with a number for the offset in the nand file
//    CONST IT_sortcomptrie *sarray;
	CONST IT_FS_DICTS 	DictOffsetInFile;
    CONST U16          numblong;
    CONST U16          *dwnlong;
    CONST U16          numassoc;
    CONST IT_assoctable   *assoc_old;
}
IT_SortLtrieBlock;



typedef 
struct _phrase_word
{
    U16 len;
    U16 info;
    ASCIILETTER *word;
    ASCIILETTER *assoc;
    ASCIILETTER *phonemes;
    struct _phrase_word *next;
}
phraseword;


typedef 
struct  _seq_gram_info
{
    CONST int numnodes;
    CONST IT_GTrieNode *GtNodes;
    CONST int numslt;
    CONST IT_SortLtrieBlock *slblock;
    CONST ASCIILETTER *strpool;
}
IT_wordgrammarinfo;



typedef 
struct _Sequence_context
{
    U16 nwords;
    U16 currentword;
    phraseword  *first;
//    seqgram     *sgram;
}
SEQCntxt_t;


#define IT_LONG_MORPH_FIRST 128       // used if multiple morphs match.
#define IT_LONG_MORPH_LAST  256       // used if multiple morphs match.

#define LONG_MORPH_FIRST 128       // used if multiple morphs match.
#define LONG_MORPH_LAST  256       // used if multiple morphs match.

#ifdef CASIO_SH3

#define IT_MAXGNODES 2000          /* for the Gtwalker */
#define IT_MAXRECURSIONS 2000000
#define IT_MAXSTACKDEPTH 100
#define IT_MAXNESTING 300
#define GNODEINCREMENTS 20 
#define IT_MAXMORPHLENGTH 38       /* no phoneme snippets longer than this  */
#define IT_MAXMORPHNUMBER 40       /* no more morphems per word */
#define IT_MAXLETTERBUFLENGTH 80
#define IT_MAXSEQGENCOMMANDS 1000
#else

#define IT_MAXGNODES 2000          /* for the Gtwalker */
#define IT_MAXRECURSIONS 20000000
#define IT_MAXSTACKDEPTH 150
#define IT_MAXNESTING 500
#define GNODEINCREMENTS 20 
#define IT_MAXMORPHLENGTH 40       /* no phoneme snippets longer than this  */
#define IT_MAXMORPHNUMBER 50       /* no more morphems per word */
#define IT_MAXLETTERBUFLENGTH 80
#define IT_MAXSEQGENCOMMANDS 1000
#endif
/* type definitions */ 


#ifndef ARM7
typedef int  BOOL;
#else    
#ifndef BOOL_DEFINED
#define BOOL_DEFINED
typedef unsigned char BOOL;  
#endif
#endif

#ifndef UMLS_DEFINED
#define UMLS_DEFINED
#define UML_A 196
#define UML_O 214
#define UML_U 220
#define UML_a 228
#define UML_o 246
#define UML_u 252
#define UML_sz 223
#endif

// SOME BITS defined for return codes when searching the trie.
// used to signal stop conditions in the search algorithms.
#ifndef NIL
#define NIL 0
#endif 

#define LTRIE_NIL         NIL    // same as NULL but sounds better
#define LTRIE_EMPTY       0      // empty, silch, nix in it, just the epsilon node
#define LTRIE_YES         1      // where there is a no there is also a yes
#define LTRIE_ENDOFLEX    2      // end of lexeme
#define LTRIE_INCOMPLETE  4      // string could be matched but is not a complete Lexeme
#define LTRIE_NOCONTINUE  8      // string could only be matched incompletly or not at all.
#define LTRIE_NORIGHT     16     // last search went to the right  
#define LTRIE_NODOWN      32     // last search went in the downwards direction

#define IT_MAX_NUM_LTRIES  80 
#define IT_MAXLTSTACKDEPTH 10
#define IT_MAX_TOKEN_LENGTH 80     // string length (maybe too short for bandwurms)
#define LTRIE_CHUNK_SIZE 10      // used in realloc for resizing and initial size of trie's
#define LONG_MORPH_FIRST 128       // used if multiple morphs match.
#define LONG_MORPH_LAST  256       // used if multiple morphs match.
#define MORPH_ORDER_MASK 384 

/* New: collect phoneme strings that are hung into the grapheme letter tries. */
#ifndef BACHUSIT_IN_DECTALK
typedef struct _IT_phomeme_string_collection
{
  U16       nstrings;            // number of strings in the pool
  int       buflen;              // size of pool
  ASCIILETTER *bigbuffer;          // pooled phoneme strings
  U16       *ptarray;            // pointer array
} PhonemeWords;
#endif




#ifndef BACHUSIT_IN_DECTALK
typedef 
struct  _IT_trie_node
{
  ASCIILETTER    letter;           // a single letter to compare against
  U16  down;                     // down: alternative node (address of other TrieNode)
  U16  right;                    // right: continuation node (address of other TrieNode)
  tnodeinfo  info;               // see enum above.
  U16    rule;           // things like the hardending rule are numbered. 
  U16    phonemehandle;  // new addition for direct translation into phonemes index into an array of pointers to strings.
}
IT_TrieNode;
#else 
typedef 
struct  _IT_trie_node
{
  CONST ASCIILETTER    letter;           // a single letter to compare against
  CONST tnodeinfo  info;               // see enum above.
  CONST U16  rule;           // things like the hardending rule are numbered. 
  CONST U16  down;                     // down: alternative node (address of other TrieNode)
  CONST U16  right;                    // right: continuation node (address of other TrieNode)
  CONST U16  phonemehandle;  // new addition for direct translation into phonemes index into an array of pointers to strings.
}
IT_TrieNode;
#endif 

#ifndef BACHUSIT_IN_DECTALK

typedef
struct _IT_letter_tree
{
  U16  size;           // number of nodes allocated.
  U16  nempty;         // number of still free nodes
  U16  increments;     // chunk size for allocation
  U16  last;           // next new node
  U16  current;        // so far that's all the state it has.
  U16  stopcondition;  // to signal why something was found or not.
  U16  searchposition; // signal how far in the search string we are proceeded.
  U16  nnodes;         // number of valid nodes.
  U16  type;
  IT_TrieNode  *Nodes;    // array of nodes
} IT_LTrie;
#else
typedef 
struct _IT_letter_tree
{
  CONST U16        nnodes;   // number of valid nodes.
  CONST U16        type;
  CONST IT_TrieNode  *Nodes;    // array of nodes
} IT_LTrie;
#endif  /* BACHUSIT_IN_DECTALK */
 
// U16 Lt_parse_string(ASCIILETTER *, U16, const IT_LTrie *, U16 *,U16 *, U16 *,U16);

 
 
typedef unsigned short int IT_StkToken;   // compatible

typedef 
struct _IT_mini_stack_nodes
{
  IT_StkToken v[IT_MAXSTACKDEPTH];
  IT_StkToken *p;
  U16 ntok;
  U16 sz;
  U16 status;
} IT_Nodestack;



void ITinitNodestack(IT_Nodestack *);
BOOL ITpushNode(IT_Nodestack *, IT_StkToken);
IT_StkToken  ITpopNode(IT_Nodestack *);



ASCIILETTER *gnodetypename(gnodetype);

typedef 
struct _IT_word_part
{
    ASCIILETTER morphname[IT_MAXMORPHLENGTH];     // e.g., "suffix", "prefix" etc,  or special symbols
    ASCIILETTER wordpart[IT_MAXMORPHLENGTH];      // word string snippet
    ASCIILETTER phonemepart[IT_MAXMORPHLENGTH];   // phoneme string snippet
    U16  rulenumber;                         // number of rule, e.g. hardening rule, applied to phonemes in certain context
    U16  type;                               // new: value of enum type parserinfo
    U16  from;                               // column in word
    U16  to;                                 // end of string position
} IT_Morpheme;
  
typedef 
struct _IT_wordcomposition{
  int    nparts;
  IT_Morpheme morph[IT_MAXMORPHNUMBER];      // anything bigger would crash
} IT_MorphemeStruct;



typedef struct _IT_walk_info{
    BOOL succeeded;
    U16  wordpos;
    U16  altnode;
} IT_walkinfo;

typedef struct _IT_walkerstack
{
    const IT_LTrie *Lt;
    int i,j,ii,jj,j1,j2,incr;
    U16 nalt,ntrie,currpos;
    U16 next,alt,what;
	WORD_SEG_LIST word_segs[4];
//    U16 proceed[4];
//    U16 phonemeindex[4];
//    U16 ruleindex[4];
    U16 opcode, opparam, match; // for operator calls.
    ASCIILETTER phonemestring[16];
    U16 rulenumber;
    U16 curr;
    IT_walkinfo newwalki;
    IT_walkinfo oldwalki;
} 
IT_WALKERNESTINGSTACK;

typedef char IT_Jumpstack;

typedef
struct _IT_walker_context {
    int   counter;
    int   level;
    int   maxlevel;
    int   alert;
    int   grammar;                  /* usually zero, but used for syllabification has non zero value */
    BOOL  special;                  /* to check a word's special bit. */
#ifdef GRAMMAR_EVALUATION         /* requires writing counting hit numbers and writing in the grammar structure */
    IT_GTrieNode *Nodes;               /* but may cause some warnings about const versus non const. */
    U16  nnodes;
#else
    CONST IT_GTrieNode *Nodes;
    U16   nnodes;
#endif
    CONST IT_SortLtrieBlock *Ltlist;     // letter trie list.  change
    CONST ASCIILETTER * MorphDict;    // structure to hold all morpheme's phoneme strings. 
    IT_Nodestack nstack;
    ASCIILETTER *theword;                // handle this pointer externally. Who knows how long a word might be?
    ASCIILETTER wordchar[IT_MAXLETTERBUFLENGTH];
    ASCIILETTER workbuffer[IT_MAXLETTERBUFLENGTH];
    IT_MorphemeStruct  Morphstruct;
    U16 wordlength;
    U16 wordpos;
    IT_WALKERNESTINGSTACK STK[IT_MAXNESTING];
    IT_Jumpstack jmpstack[IT_MAXNESTING];
    int       jmptop;
} IT_WalkCNTXT;



#define IT_MAX_BACHUSLETTERS 120

#define IT_MAXRULEBUFLEN 100
#define IT_MAXRULEALLBUFFERLENGTH (6*IT_MAXRULEBUFLEN)          /* do not change the 6 */


U16 sorttrie_parse_string(LPTTS_HANDLE_T phTTS,ASCIILETTER *str,  
		    U16 startposition,       
		    CONST IT_SortLtrieBlock *Lt, 
		    WORD_SEG_LIST *word_segs,
			U16 mode);


void get_associated_string_rule(LPTTS_HANDLE_T phTTS, int index, char *output,
					     CONST IT_SortLtrieBlock *Lt,
					     U16 * CONST rulenumber);

BOOL Seq_analyse_word(LPTTS_HANDLE_T phTTS,CONST ASCIILETTER *word, 
		      ASCIILETTER *outword, 
		      ASCIILETTER *outphonemes,
		      U16         *lastrule,
		      IT_WalkCNTXT *Contxt,
		      CONST IT_wordgrammarinfo *Wt);

#endif /* _IT_BUILDER_H_ */
