// StreamingSample.c  : Fonix Simple API example
//
// This simple example has only enough code to see the required API's.  
// Return codes have not been checked to make this code easier to read.
//

#include <stdio.h>
#include "FonixTtsDtSimple.h"
												
#define SAMPLE_RATE 11025
#define BYTES_PER_SAMPLE 2
int StopOutput = 0;
int AudioOutInitalized = 0;
unsigned int CPU_CLK_RATE = 60000000;			// set to the clock rate of the CPU, used by the microphone and speaker code

#define AUDIO_OUT_BUF_LEN 71*4
short WorkBuffer[71];							// used when TTS engine is using callback to return audio data
short AudioBuffer[AUDIO_OUT_BUF_LEN];			// used to collect 4 buffers from the engine before sending to the audio driver (helps to keep the TTS engine ahead of playback)
int AudioBuffersReceived;

void ResetAudioOutCallback( void );
short *AudioOutStreamCallback(short *output_buf,long error);
void HaltSpeech( void );

int main( int argc, char* argv[] )
{
	char ReceivedString[256];
	int actualSamples;
	int Language = US_English;
	int Voice = Paul;

	ReceivedString[0] = 0;
	AudioOutCreate();		// changes the pins used by the speaker code to outputs and sets them LOW
							// this should eliminate the pops that occur when the speaker is opened or closed

	while(1)
	{
		printf( "\n0: US English (default)" );		// select from languages included in the build
//		printf( "\n1: French" );
//		printf( "\n2: German" );
//		printf( "\n3: Castilian Spanish" );
//		printf( "\n5: UK English" );
		printf( "\n6: Latin American Spanish" );
//		printf( "\n7: Italian");
		printf( "\nSelect a language by number:" );
		gets( ReceivedString );
		Language = (int)(ReceivedString[0] - 0x30);

		printf( "\n0: Paul (default)" );			// select a voice
		printf( "\n1: Harry" );
		printf( "\n2: Frank" );
		printf( "\n3: Dennis" );
		printf( "\n4: Kit" );
		printf( "\n5: Betty" );
		printf( "\n6: Ursula" );
		printf( "\n7: Rita" );
		printf( "\n8: Wendy" );
		printf( "\nSelect a voice by number:" );
		gets( ReceivedString );
		Voice = (int)(ReceivedString[0] - 0x30);

		printf( "\nEnter a text string:" );			// get the text to speak
		gets( ReceivedString );

		FnxTTSDtSimpleOpen( AudioOutStreamCallback, NULL);	// open TTS engine & set to use callback to stream audio
		FnxTTSDtSimpleSetLanguage( Language, NULL );
		FnxTTSDtSimpleChangeVoice( Voice, WAVE_FORMAT_1M16 );
		printf( "\nTTS engine streaming audio through callback" );
		actualSamples = FnxTTSDtSimpleStart( ReceivedString, WorkBuffer, 71, WAVE_FORMAT_1M16);
		if( !StopOutput && actualSamples >= 0 )	// call the audio driver with any remaining data
		{
			if( AudioBuffersReceived != 0 )
			{
				AudioOutPlay( AudioBuffer, AudioBuffersReceived * 71 );
				AudioBuffersReceived = 0;
			}
			AudioOutQuit();						// blocks until all data is played and closes the audio channel
			ResetAudioOutCallback( );
		}
		StopOutput = 0;
	}

	return 0;
}


void ResetAudioOutCallback( void )
{
	AudioOutInitalized = 0;
}

short *AudioOutStreamCallback(short *output_buf,long error)
{	
	if( !AudioOutInitalized )	//make sure to intialize the audio driver
	{
		int samplesEachplay;

		AudioOutInit( &samplesEachplay, SAMPLE_RATE, 2, 2, 0 );
		AudioOutInitalized = 1;
		AudioBuffersReceived = 0;
	}

	// copy the data out of output_buf, so the engine can reuse it
	memcpy( AudioBuffer + (AudioBuffersReceived * 71), output_buf, sizeof(short) * 71 );
	AudioBuffersReceived++;

	if( AudioBuffersReceived == 4 )		// give the audio driver 284 sample at a time
	{
		AudioOutPlay( AudioBuffer, AUDIO_OUT_BUF_LEN );
		AudioBuffersReceived = 0;
	}

	return( output_buf );	// return to the engine a pointer to the buffer it will use
}

// Would call from an interrupt to immediately stop audio output and 
// the signal the TTS engine to quit creating audio data
void HaltSpeech( void )
{
	AudioOutHalt();					// immediately stops the audio driver from playing
	FnxTTSDtSimpleHaltSpeech();		// stops the TTS engine and flushes all text not already synthesised
	StopOutput = 1;
}
