// This example boot file sets up the minimum S1C33 resources
// used by the Fonix ASR 

void TtsDtBoot( void );
void AddressError( void )		__attribute__ ((interrupt_handler));
void DivideByZero( void )		__attribute__ ((interrupt_handler));
void UnusedInterrupt( void )	__attribute__ ((interrupt_handler));

void InitBus( void );
void InitRam( void );
void CacheTtsCode( void );
void Exit( void );
void CopyHalfWords( short * Src, short * Dst, int Length );

extern void _init_lib( void );
extern void _init_sys( void );
extern void main( void );
extern void SpkIntr0( void );				//Speak

extern char StackBegin[ 0x10001 ];
extern char StackEnd[ 0x10001 ];

/* vector table */
const unsigned long vector[] = {
										// #	offset			function
	(unsigned long)TtsDtBoot,			// 0	0/0x0			Reset
	(unsigned long)UnusedInterrupt,		// 1	4/0x4			reserved
	(unsigned long)UnusedInterrupt,		// 2	8/0x8			reserved
	(unsigned long)UnusedInterrupt,		// 3	12/0xC			reserved
	(unsigned long)DivideByZero,		// 4	16/0x10			Zero division
	(unsigned long)UnusedInterrupt,		// 5	20/0x14			reserved
	(unsigned long)AddressError,		// 6	24/0x18			Address error exception
	(unsigned long)UnusedInterrupt,		// 7	(0 or 0x6000)	Debugging exception
	(unsigned long)UnusedInterrupt,		// 8	32/0x1C			NMI
	(unsigned long)UnusedInterrupt,		// 9	36/0x20			reserved
	(unsigned long)UnusedInterrupt,		// 10	40/0x24			reserved
	(unsigned long)UnusedInterrupt,		// 11	44/0x28			reserved
	(unsigned long)UnusedInterrupt,		// 12	48/0x30			Software Exception 0
	(unsigned long)UnusedInterrupt,		// 13	52/0x34			Software Exception 1
	(unsigned long)UnusedInterrupt,		// 14	56/0x38			Software Exception 2
	(unsigned long)UnusedInterrupt,		// 15	60/0x3C			Software Exception 3
	(unsigned long)UnusedInterrupt,		// 16	64/0x40			Port input interrupt 0
	(unsigned long)UnusedInterrupt,		// 17	68/0x44			Port input interrupt 1
	(unsigned long)UnusedInterrupt,		// 18	72/0x48			Port input interrupt 2
	(unsigned long)UnusedInterrupt,		// 19	76/0x4C			Port input interrupt 3
	(unsigned long)UnusedInterrupt,		// 20	80/0x50			Key input interrupt 0
	(unsigned long)UnusedInterrupt,		// 21	84/0x54			Key input interrupt 1
	(unsigned long)UnusedInterrupt,		// 22	88/0x58			High-speed DMA Ch. O
	(unsigned long)UnusedInterrupt,		// 23	92/0x5C			High-speed DMA Ch. 1
	(unsigned long)UnusedInterrupt,		// 24	96/0x60			High-speed DMA Ch. 2
	(unsigned long)UnusedInterrupt,		// 25	100/0x64		High-speed DMA Ch. 3
	(unsigned long)UnusedInterrupt,		// 26	104/0x68		IDMA
	(unsigned long)UnusedInterrupt,		// 27	108/0x6C		reserved
	(unsigned long)UnusedInterrupt,		// 28	112/0x70		reserved
	(unsigned long)UnusedInterrupt,		// 29	116/0x74		reserved
	(unsigned long)UnusedInterrupt,		// 30	120/0x78		16-bit programmable timer 0 - Comparison B
	(unsigned long)UnusedInterrupt,		// 31	124/0x7C		16-bit programmable timer 0 - Comparison A
	(unsigned long)UnusedInterrupt,		// 32	128/0x80		reserved
	(unsigned long)UnusedInterrupt,		// 33	132/0x84		reserved
	(unsigned long)UnusedInterrupt,		// 34	136/0x88		16-bit programmable timer 1 - Comparison B
	(unsigned long)UnusedInterrupt,		// 35	140/0x8C		16-bit programmable timer 1 - Comparison A
	(unsigned long)UnusedInterrupt,		// 36	144/0x90		reserved
	(unsigned long)UnusedInterrupt,		// 37	148/0x94		reserved
	(unsigned long)UnusedInterrupt,		// 38	152/0x98		16-bit programmable timer 2 - Comparison B
	(unsigned long)UnusedInterrupt,		// 39	156/0x9C		16-bit programmable timer 2 - Comparison A
	(unsigned long)UnusedInterrupt,		// 40	160/0xA0		reserved
	(unsigned long)UnusedInterrupt,		// 41	164/0xA4		reserved
	(unsigned long)UnusedInterrupt,		// 42	168/0xA8		16-bit programmable timer 3 - Comparison B
	(unsigned long)UnusedInterrupt,		// 43	172/0xAC		16-bit programmable timer 3 - Comparison A
	(unsigned long)UnusedInterrupt,		// 44	176/0xB0		reserved
	(unsigned long)UnusedInterrupt,		// 45	180/0xB4		reserved
	(unsigned long)UnusedInterrupt,		// 46	184/0xB8		16-bit programmable timer 4 - Comparison B
	(unsigned long)UnusedInterrupt,		// 47	188/0xBC		16-bit programmable timer 4 - Comparison A
	(unsigned long)UnusedInterrupt,		// 48	192/0xC0		reserved
	(unsigned long)UnusedInterrupt,		// 49	196/0xC4		reserved
	(unsigned long)SpkIntr0,			// 50	200/0xC8		16-bit programmable timer 5 - Comparison B
	(unsigned long)UnusedInterrupt,		// 51	204/0xCC		16-bit programmable timer 5 - Comparison A
	(unsigned long)UnusedInterrupt,		// 52	208/0xD0		8-bit programmable timer - Timer 0 underflow
	(unsigned long)UnusedInterrupt,		// 53	212/0xD4		8-bit programmable timer - Timer 1 underflow
	(unsigned long)UnusedInterrupt,		// 54	216/0xD8		8-bit programmable timer - Timer 2 underflow
	(unsigned long)UnusedInterrupt,		// 55	220/0xDC		8-bit programmable timer - Timer 3 underflow
	(unsigned long)UnusedInterrupt,		// 56	224/0xE0		Serial interface Ch.0 - Receive error
	(unsigned long)UnusedInterrupt,		// 57	228/0xE4		Serial interface Ch.0 - Receive buffer full
	(unsigned long)UnusedInterrupt,		// 58	232/0xE8		Serial interface Ch.0 - Transmit buffer empty
	(unsigned long)UnusedInterrupt,		// 59	236/0xEC		reserved
	(unsigned long)UnusedInterrupt,		// 60	240/0xF0		Serial interface Ch.1 - Receive error
	(unsigned long)UnusedInterrupt,		// 61	244/0xF4		Serial interface Ch.1 - Receive buffer full
	(unsigned long)UnusedInterrupt,		// 62	248/0xF8		Serial interface Ch.1 - Transmit buffer empty
	(unsigned long)UnusedInterrupt,		// 63	252/0xFC		reserved
	(unsigned long)UnusedInterrupt,		// 64	256/0x100		A/D converter
	(unsigned long)UnusedInterrupt,		// 65	260/0x104		Clock timer
	(unsigned long)UnusedInterrupt,		// 66	264/0x108		reserved
	(unsigned long)UnusedInterrupt,		// 67	268/0x10C		reserved
	(unsigned long)UnusedInterrupt,		// 68	272/0x110		Port input interrupt 4
	(unsigned long)UnusedInterrupt,		// 69	276/0x114		Port input interrupt 5
	(unsigned long)UnusedInterrupt,		// 70	280/0x118		Port input interrupt 6
	(unsigned long)UnusedInterrupt		// 71	284/0x11C		Port input interrupt 7
};

void TtsDtBoot( void )
{
	asm("xld.w	%r15,StackEnd");		// Set stack pointer to address set by StackEnd in MemoryMap.s
	asm("ld.w	%sp,%r15");
	asm("xld.w	%r15,0x0000110");		// Set program status register (PSR) to enable interrupts
	asm("ld.w	%psr,%r15");
	asm("ld.w	%r15,0x0");				// Set GPR is 0x0 - can't use GPR because sl208.lib uses r15
	InitBus();
	InitRam();

	CacheTtsCode();						// copy ASR code to internal memory
	_init_lib();						// need to call if using printf or Epson's malloc
	_init_sys();						// need to call if using simulated I/O

	main();								// enter main program
	Exit();								// if/when the program exits
}

void AddressError()
{
ADDRESS_ERROR_LOOP:
	goto ADDRESS_ERROR_LOOP;
	asm("reti");
}

void DivideByZero()
{
DIVIDE_BY_ZERO_LOOP:
	goto DIVIDE_BY_ZERO_LOOP;
	asm("reti");
}

void UnusedInterrupt()
{
UNUSED_INTERUPT_LOOP:
	goto UNUSED_INTERUPT_LOOP;
	asm("reti");
}

void Exit()
{
EXIT_LOOP:
	goto EXIT_LOOP;
}

void InitBus( void )
{
	volatile unsigned short * pRegister;

	pRegister = (unsigned short *)0x48130;	// chip enable set up
	*pRegister |= 0x0000;					// default - areas 4-10
	//*pRegister |= 0x0200;					// areas 6,10,11,13-15,17
	//*pRegister |= 0x0400;					// areas 7-18


	pRegister = (unsigned short *)0x48120;	// area 15-18 (when chip enable default) / 0x4000000-0xFFFFFFF
	*pRegister = 0x1313;					// Device 16 bits, output delay 1.5, wait cycles 3

	pRegister = (unsigned short *)0x48122;	// area 13,14 (when chip enable default) / 0x2000000-0x3FFFFFF
	*pRegister = 0x0013;					// Device 16 bits, output delay 1.5, wait cycles 3, SRAM

	pRegister = (unsigned short *)0x48124;	// area 11,12 (when chip enable default) / 0x1000000-0x1FFFFFF
	*pRegister = 0x0013;					// Device 16 bits, output delay 1.5, wait cycles 3

	pRegister = (unsigned short *)0x48126;	// area 9,10 (when chip enable default) / 0x800000-0x0FFFFFF
	*pRegister = 0x0013;					// Device 16 bits, output delay 1.5, wait cycles 3

	pRegister = (unsigned short *)0x48128;	// area 7,8 (when chip enable default) / 0x600000-0x07FFFFF
	*pRegister = 0x0012;					// Device 16 bits, output delay 1.5, wait cycles 2

	pRegister = (unsigned short *)0x4812A;	// area 4,5,6 (when chip enable default) / 0x100000-0x03FFFFF
	*pRegister = 0x1313;					// Device 16 bits, output delay 1.5, wait cycles 3
}

void InitRam( void )
{
	// clear bss section
	// DECtalk assumes that the bss section is initialized to zero
	asm(" xld.w %r6, __START_bss ");		//in order for the linker to generate these symbols the cm file must include the -objsym command
	asm(" xld.w %r7, __END_bss ");
	asm(" sub %r7,%r6 ");					//find size of bss section
	asm(" xld.w %r8, 0 ");
	asm("CLEAR_LOOP: ");
	asm(" ld.b	[%r6]+,%r8 ");
	asm(" sub %r7, 1 ");
	asm(" jrgt CLEAR_LOOP ");

	// copy data section into RAM from ROM
	asm(" xld.w	%r6, __START_data_lma ");			// the beginning address in ROM
	asm(" xld.w	%r7, __START_data ");				// the beginning address in RAM
	asm(" xld.w	%r8, __END_data ");				// the ending address in RAM
	asm(" sub %r8,%r7 ");							// size of block to be copied
	asm(" xcall	CopyHalfWords");

}

void CacheTtsCode( void )
{

	// copy Tts code to internal memory to improve speed of recognition - 
	// only needs to reside in internal memory while doing ASR
	asm(" xld.w	%r6, __START_textu1_lma ");		// the beginning address in ROM
	asm(" xld.w	%r7, __START_textu1 ");			// the beginning address in RAM
	asm(" xld.w	%r8, __END_textu1 ");				// the ending address in RAM
	asm(" sub %r8,%r7 ");							// size of block to be copied
	asm(" xcall	CopyHalfWords");	//code is always half word long

	asm(" xld.w	%r6, __START_textu2_lma ");		// the beginning address in ROM
	asm(" xld.w	%r7, __START_textu2 ");			// the beginning address in RAM
	asm(" xld.w	%r8, __END_textu2 ");				// the ending address in RAM
	asm(" sub %r8,%r7 ");							// size of block to be copied
	asm(" xcall	CopyHalfWords");	//code is always half word long

}

void CopyHalfWords( short * Src, short * Dst, int Length )
{
	asm(" LOOP: ");
	asm(" ld.uh	%r4,[%r6]+ ");	// read half from src addr
	asm(" ld.h	[%r7]+,%r4 ");	// write half to dest addr
	asm(" sub	%r8, 2 ");			// decrement count by 2 bytes
	asm(" jrgt	LOOP ");
	
	return;
}

