// TestTtsDtSimpleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TestTtsDtSimple.h"
#include "TestTtsDtSimpleDlg.h"
#include <process.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

char Fonix_nand_file_name[256] ;
char Fonix_nand_tablename[256] ;

#define US_ENGLISH_FILE_NAME		"dtalk_us.nand.dic"		//Fonix Path test 05.11.18 K.Toriyama
#define US_ENGLISH_TABLE_NAME		"UsEnglish.nand.tab"	//Fonix Path test 05.11.18 K.Toriyama
#define FRENCH_FILE_NAME			"dtalk_fr.nand.dic" 		//Fonix Path test 05.11.18 K.Toriyama
#define FRENCH_TABLE_NAME			"French.nand.tab"		//Fonix Path test 05.11.18 K.Toriyama
#define GERMAN_FILE_NAME			"dtalk_gr.nand.dic"		//Fonix Path test 05.11.18 K.Toriyama
#define GERMAN_TABLE_NAME			"\0"						//Fonix Path test 05.11.18 K.Toriyama
#define SPANISH_FILE_NAME			"dtalk_sp.nand.dic"		//Fonix Path test 05.11.18 K.Toriyama
#define SPANISH_TABLE_NAME			"\0"						//Fonix Path test 05.11.18 K.Toriyama
#define UK_ENGLISH_FILE_NAME		"\0"						//Fonix Path test 05.11.18 K.Toriyama
#define UK_ENGLISH_TABLE_NAME		"\0"						//Fonix Path test 05.11.18 K.Toriyama
#define LATIN_SPANISH_FILE_NAME		"\0"						//Fonix Path test 05.11.18 K.Toriyama
#define LATIN_SPANISH_TABLE_NAME	"\0"						//Fonix Path test 05.11.18 K.Toriyama
#define ITALIAN_FILE_NAME			"dtalk_it.nand.dic"		//Fonix Path test 05.11.18 K.Toriyama
#define ITALIAN_TABLE_NAME			"\0"						//Fonix Path test 05.11.18 K.Toriyama


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestTtsDtSimpleDlg dialog

CTestTtsDtSimpleDlg::CTestTtsDtSimpleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestTtsDtSimpleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestTtsDtSimpleDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTestTtsDtSimpleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestTtsDtSimpleDlg)
	DDX_Control(pDX, IDCreateWav, m_TextInputCreateWav);
	DDX_Control(pDX, IDCreateWavList, m_WordListCreateWav);
	DDX_Control(pDX, IDC_SPEAKLIST, m_WordListSpeakList);
	DDX_Control(pDX, IDC_RESET, m_ResetButton);
	DDX_Control(pDX, IDC_DELETE, m_WordListDelete);
	DDX_Control(pDX, IDC_VOICE, m_Voice);
	DDX_Control(pDX, IDC_LANGUAGE, m_Language);
	DDX_Control(pDX, IDWordListSpeak, m_WordListSpeak);
	DDX_Control(pDX, IDSpeak, m_TextInputSpeak);
	DDX_Control(pDX, IDC_ADD, m_WordListAdd);
	DDX_Control(pDX, IDC_WORDLIST, m_WordList);
	DDX_Control(pDX, IDC_TEXTINPUT, m_TextInput);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestTtsDtSimpleDlg, CDialog)
	//{{AFX_MSG_MAP(CTestTtsDtSimpleDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDOK, OnSpeak)
	ON_BN_CLICKED(IDWordListSpeak, OnWordListSpeak)
	ON_BN_CLICKED(IDC_SPEAKLIST, OnSpeakList)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	ON_LBN_SELCHANGE(IDC_WORDLIST, OnSelchangeWordlist)
	ON_EN_CHANGE(IDC_TEXTINPUT, OnChangeTextinput)
	ON_COMMAND(ID_MENULOADWORDLIST, OnMenuloadwordlist)
	ON_COMMAND(ID_MENUSAVEWORDLIST, OnMenusavewordlist)
	ON_CBN_SELCHANGE(IDC_LANGUAGE, OnSelchangeLanguage)
	ON_CBN_SELCHANGE(IDC_VOICE, OnSelchangeVoice)
	ON_BN_CLICKED(IDC_RESET, OnReset)
	ON_BN_CLICKED(IDCreateWav, OnCreateWav)
	ON_BN_CLICKED(IDCreateWavList, OnCreateWavList)
	ON_BN_CLICKED(IDSpeak, OnSpeak)
	ON_COMMAND(ID_SAMPLERATE11, OnSamplerate11)
	ON_COMMAND(ID_SAMPLERATE8, OnSamplerate8)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestTtsDtSimpleDlg message handlers

BOOL CTestTtsDtSimpleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	// Initial path
	CString csFullPath;
	char sRootDir[256];

	m_csCurrentPath = "\\";

	/*  Get the path and filename of this application  */
	if(GetModuleFileName(AfxGetInstanceHandle(), sRootDir, 256) != 0)
	{
		csFullPath = sRootDir;

		SetWindowText(sRootDir);	// Display the full path to this app in the title bar

		int nIdx = csFullPath.ReverseFind(_T('\\'));
		if (nIdx != -1)
		{
			m_csCurrentPath = csFullPath.Left(nIdx+1);
		}
	}

	m_TextInput.SetLimitText( 256 );
	m_TextInput.SetWindowText("Welcome!");
	m_TextInput.CanUndo();

	m_Language.SetCurSel (0);
	m_Voice.SetCurSel(0);

	DisableButtons();
	EnableButtons();

// default to 11k
//	AudioOutSampleRate = SAMPLE_RATE_11K;
//	WaveFormat = WAVE_FORMAT_1M16;
//	AudioFrameSize = AUDIO_FRAME_SIZE_11K;

	// default to 8k
	AudioOutSampleRate = SAMPLE_RATE_8K;
	WaveFormat = WAVE_FORMAT_08M16;
	AudioFrameSize = AUDIO_FRAME_SIZE_8K;
//	char szMainDict[256] = "dtalk_us.nand.dic";

//	FnxTTSDtSimpleOpen( AudioOutPlayBuffer, NULL);
	//Fonix_nand_file_name[256] ;
	//Fonix_nand_tablename[256] ;

	strcpy(Fonix_nand_file_name,US_ENGLISH_FILE_NAME);
	strcpy(Fonix_nand_tablename,US_ENGLISH_TABLE_NAME);

	FnxTTSDtSimpleOpen( NULL, NULL,Fonix_nand_file_name,Fonix_nand_tablename);

	UpdateData (FALSE);
	
	return FALSE;  // return TRUE  unless you set the focus to a control
}

void CTestTtsDtSimpleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTestTtsDtSimpleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTestTtsDtSimpleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTestTtsDtSimpleDlg::OnSpeak() 
{
	// TODO: Add your control notification handler code here
	CString csText;
	int actualSamples;
//	char szMainDict[256] = "dtalk_us.nand.dic";
	m_TextInput.GetWindowText( csText );

	DisableButtons();

	AudioOutOpen( );
	actualSamples = FnxTTSDtSimpleStart( csText.GetBuffer(csText.GetLength()), AudioBuffer, AUDIO_OUT_BUF_LEN, WaveFormat,Fonix_nand_file_name,Fonix_nand_tablename);
	if( actualSamples > 0 )
//		AudioOutPlayBuffer( AudioBuffer, 0);
		AudioOutPlay(AudioBuffer, actualSamples);
	else if( actualSamples != 0 )
		AudioOutPlay(AudioBuffer, AUDIO_OUT_BUF_LEN);

	AudioOutClose( );

	EnableButtons();
}

void CTestTtsDtSimpleDlg::OnWordListSpeak() 
{
	// TODO: Add your control notification handler code here
	CString csText;
	int nIdx;
	int actualSamples;

	DisableButtons();

	nIdx = m_WordList.GetCurSel();
	if (nIdx != LB_ERR)
	{
		//m_WordList.GetText(nIdx, csText);
		csText = m_cslWordList.GetAt(m_cslWordList.FindIndex(nIdx));
	}

	AudioOutOpen( );
//	FnxTTSDtSimpleResetSpeech();
//	char szMainDict[256] = "dtalk_us.nand.dic";
	actualSamples = FnxTTSDtSimpleStart( csText.GetBuffer(csText.GetLength()), AudioBuffer, AUDIO_OUT_BUF_LEN, WaveFormat,Fonix_nand_file_name,Fonix_nand_tablename);
	if( actualSamples > 0 )
//		AudioOutPlayBuffer(AudioBuffer, 0);
		AudioOutPlay(AudioBuffer, actualSamples);
	else if( actualSamples < 0 )
		AudioOutPlay(AudioBuffer, AUDIO_OUT_BUF_LEN);
	AudioOutClose( );

	EnableButtons();
}

void DTListProc( LPVOID lpParameter )
{
	CTestTtsDtSimpleDlg	* dlg = (CTestTtsDtSimpleDlg*) lpParameter;
	int actualSamples = 0;
	int lineCount;
	int nIdx;
	CString csText;

	dlg->m_WordListSpeakList.EnableWindow(TRUE);

	nIdx = dlg->m_WordList.GetCurSel();
	lineCount = dlg->m_WordList.GetCount();

	for(; nIdx< lineCount; nIdx++ )
	{
		if (nIdx != LB_ERR)
		{
			if( nIdx >= 0 )
				dlg->m_WordList.SetSel(nIdx-1, FALSE);		// Unselect last item

			dlg->m_WordList.SetSel(nIdx, TRUE);			// Select item to be spoken
			//dlg->m_WordList.GetText(nIdx, csText);
			csText = dlg->m_cslWordList.GetAt(dlg->m_cslWordList.FindIndex(nIdx));
		}
		dlg->AudioOutOpen( );
		actualSamples = FnxTTSDtSimpleStart( csText.GetBuffer(csText.GetLength()), dlg->AudioBuffer, AUDIO_OUT_BUF_LEN, dlg->WaveFormat,Fonix_nand_file_name,Fonix_nand_tablename);
		if( actualSamples > 0 )
			dlg->AudioOutPlay(dlg->AudioBuffer, actualSamples);
		dlg->AudioOutClose( );

		if(dlg->m_bStopSpeakingText)
			break;
	}

	dlg->m_WordListSpeakList.SetWindowText("Speak List");
	dlg->EnableButtons();

}

void CTestTtsDtSimpleDlg::OnSpeakList() 
{
	CString csBtnText;

	m_WordListSpeakList.GetWindowText(csBtnText);

	if(csBtnText == "Stop")
	{
		m_bStopSpeakingText = true;
	}
	else
	{
		m_bStopSpeakingText = false;
		DisableButtons();

		m_WordListSpeakList.SetWindowText("Stop");
		_beginthread(DTListProc, 0, this);
	}
}

void CTestTtsDtSimpleDlg::OnAdd() 
{
	// TODO: Add your control notification handler code here
	CString csText;
	int nIdx;

	DisableButtons();
	if (m_WordList.GetCount() < WORDLIST_MAX)
	{
		m_TextInput.GetWindowText(csText);
		if (!csText.IsEmpty())
		{
			nIdx = m_WordList.AddString(csText);
			m_cslWordList.AddTail(csText);

			if (nIdx != LB_ERR && nIdx != LB_ERRSPACE)
			{
				m_WordList.SetCurSel(nIdx);
				OnSelchangeWordlist();
			}
		}
	}
	else
	{
		CWnd wnd;
		wnd.MessageBox(_T("Cannot add phrase. Word Set list is full."));
	}
	EnableButtons();
}

void CTestTtsDtSimpleDlg::OnDelete() 
{
	// TODO: Add your control notification handler code here
	int nIdx;
	int nCnt;
	CString csWordListText, csInputText;
	
	DisableButtons();
	nIdx = m_WordList.GetCurSel();

	if (nIdx != LB_ERR)
	{
		m_WordList.GetText(nIdx, csWordListText);
		m_TextInput.GetWindowText(csInputText);

		nCnt = m_WordList.DeleteString(nIdx);
		m_cslWordList.RemoveAt(m_cslWordList.FindIndex(nIdx));

		if (nCnt != LB_ERR)
		{
			m_WordList.SetCurSel(min(nIdx, nCnt-1));
		}
	}
	EnableButtons();
}

void CTestTtsDtSimpleDlg::OnSelchangeWordlist() 
{
	DisableButtons();
	EnableButtons();
}

void CTestTtsDtSimpleDlg::OnChangeTextinput() 
{
	DisableButtons();
	EnableButtons();
}

void CTestTtsDtSimpleDlg::OnMenuloadwordlist() 
{
	// TODO: Add your command handler code here
	CString csFullPath;
	CString csSavePath;

	CFileDialog filedlg(TRUE, _T("txt"), NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, _T("Word Set Files (*.txt)|*.txt|All Files (*.*)|*.*||"));
	filedlg.m_ofn.lpstrInitialDir = (LPCTSTR)m_csCurrentPath;
	csSavePath = m_csCurrentPath;

	if (filedlg.DoModal() == IDOK)
	{
		csFullPath = filedlg.GetPathName();
		if (!csFullPath.IsEmpty())
		{
			CString csText;
//			int nIdx;
			int i;
			CString csMaxLen;
			CSize size;

			TRY
			{
				CStdioFile file(csFullPath, CFile::modeRead | CFile::typeText);

				m_WordList.ResetContent();
				m_cslWordList.RemoveAll();

				i = 0;
				while (file.ReadString(csText) && i++ < WORDLIST_MAX)
				{
					//nIdx = m_WordList.AddString(csText);
					m_cslWordList.AddTail(csText);
					if(csText.GetLength() > csMaxLen.GetLength())
						csMaxLen = csText;
				}

				// don't save the current path until the dictionary path problem is resolved
				//nIdx = csFullPath.ReverseFind(_T('\\'));
				//if (nIdx != -1)
				//{
				//	m_csCurrentPath = csFullPath.Left(nIdx+1);
				//}

				for(i = 0; i < m_cslWordList.GetCount(); i++)
				{
					m_WordList.AddString(m_cslWordList.GetAt(m_cslWordList.FindIndex(i)));
				}

				m_WordList.SetCurSel(0);
				EnableButtons();
				
				size = GetDC()->GetTextExtent(csMaxLen);
				m_WordList.SetHorizontalExtent(size.cx);

				file.Close();
			}
			CATCH( CFileException, e )
			{
				CWnd wnd;
				wnd.MessageBox(_T("Could not open file"));
				return;
			}
			END_CATCH
		}
	}
	m_csCurrentPath = csSavePath;
	SetCurrentDirectory(csSavePath);
}

void CTestTtsDtSimpleDlg::OnMenusavewordlist() 
{
	// TODO: Add your command handler code here
	CString csFullPath;

	CFileDialog filedlg(FALSE, _T("txt"), NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, _T("Word Set Files (*.txt)|*.txt|All Files (*.*)|*.*||"));
	filedlg.m_ofn.lpstrInitialDir = (LPCTSTR)m_csCurrentPath;
	if (filedlg.DoModal() == IDOK)
	{
		csFullPath = filedlg.GetPathName();
		if (!csFullPath.IsEmpty())
		{
			CString csText;
			int nIdx;

			TRY
			{
				CStdioFile file(csFullPath, CFile::modeCreate | CFile::modeWrite | CFile::typeText);

				//int nCnt = m_WordList.GetCount();
				int nCnt = m_cslWordList.GetCount();

				for (int i=0; i<nCnt; i++)
				{
					//m_WordList.GetText(i, csText);
					csText = m_cslWordList.GetAt(m_cslWordList.FindIndex(i));
					file.WriteString(csText);
					file.WriteString(_T("\n"));
				}

				nIdx = csFullPath.ReverseFind(_T('\\'));
				if (nIdx != -1)
				{
					m_csCurrentPath = csFullPath.Left(nIdx+1);
				}
				file.Close();
			}
			CATCH( CFileException, e )
			{
				CWnd wnd;
				wnd.MessageBox(_T("Could not open file"));
				return;
			}
			END_CATCH
		}
	}
	
}


void CTestTtsDtSimpleDlg::AudioOutOpen( void )
{
//	FnxAudioOut AudioOutPtr;
	int samplesEachPlay;
	
	AudioOutPtr = FnxAudioOutCreate();
	FnxAudioOutOpenStreaming(AudioOutPtr, &samplesEachPlay, AudioOutSampleRate, 2, FNX_AUDIO_OUT_FORMAT_PCM );
}

short * CTestTtsDtSimpleDlg::AudioOutPlayBuffer(short * data, long flag)
{
	switch (flag)
	{
		case 0:
			FnxAudioOutPlayStreaming(AudioOutPtr, data, AudioFrameSize);
			return( data );
			break;
		case 3:
			return( data );
			break;
		default:
			return (NULL);
			break;
	}
}

void CTestTtsDtSimpleDlg::AudioOutPlay(short * data, int samples)
{
	FnxAudioOutPlayStreaming(AudioOutPtr, data, samples);
}

void CTestTtsDtSimpleDlg::AudioOutClose( void )
{
//	FnxAudioOut AudioOutPtr;
	
	FnxAudioOutCloseStreaming(AudioOutPtr);
	FnxAudioOutDestroy( AudioOutPtr );
}

void CTestTtsDtSimpleDlg::OnSelchangeLanguage() 
{
	char sDir[_MAX_PATH];
	int LanguageSel;
	CString text;

	// we took out some of the languages so we can't use a straight
	// enumeration
	// instead we get the text and compare
	// make sure the text below matches what is in the list box data
	LanguageSel = m_Language.GetCurSel();
	m_Language.GetLBText(LanguageSel, text);

	// Get the directory that this app was started in
	if( GetModuleFileName(NULL, sDir, _MAX_PATH) == 0 )
	{
		strcpy(sDir, "\\");
	}
	else
	{
		char *pc;
		
		pc = sDir + strlen(sDir) -1;
		while( pc > sDir && *pc != '\\' )
			pc--;
		if( *pc == '\\' )
			*pc = 0x00;
	}


	if(text == "US English")
	{
		sprintf(Fonix_nand_file_name, "%s\\%s", sDir, US_ENGLISH_FILE_NAME);
		sprintf(Fonix_nand_tablename, "%s\\%s", sDir, US_ENGLISH_TABLE_NAME);
		FnxTTSDtSimpleSetLanguage( US_English, NULL,Fonix_nand_file_name,Fonix_nand_tablename);
	}
	else if(text == "French")
	{
		sprintf(Fonix_nand_file_name, "%s\\%s", sDir, FRENCH_FILE_NAME);
		sprintf(Fonix_nand_tablename, "%s\\%s", sDir, FRENCH_TABLE_NAME);
		FnxTTSDtSimpleSetLanguage( French, NULL,Fonix_nand_file_name,Fonix_nand_tablename);
	}
	else if(text == "German")
	{
		sprintf(Fonix_nand_file_name, "%s\\%s", sDir, GERMAN_FILE_NAME);
		//sprintf(Fonix_nand_tablename, "%s\\%s", sDir, GERMAN_TABLE_NAME);
		FnxTTSDtSimpleSetLanguage( German, NULL,Fonix_nand_file_name,0);
	}
	else if(text == "Castilian Spanish")
	{
		sprintf(Fonix_nand_file_name, "%s\\%s", sDir, SPANISH_FILE_NAME);
		//sprintf(Fonix_nand_tablename, "%s\\%s", sDir, SPANISH_TABLE_NAME);
		FnxTTSDtSimpleSetLanguage( Castilian_Spanish, NULL,Fonix_nand_file_name,0);
	}
	else if(text == "Italian")
	{
		sprintf(Fonix_nand_file_name, "%s\\%s", sDir, ITALIAN_FILE_NAME);
		//sprintf(Fonix_nand_tablename, "%s\\%s", sDir, ITALIAN_TABLE_NAME);
		FnxTTSDtSimpleSetLanguage( Italian, NULL,Fonix_nand_file_name,0);
	}
	else if(text == "UK English")
	{
		sprintf(Fonix_nand_file_name, "%s\\%s", sDir, UK_ENGLISH_FILE_NAME);
		//sprintf(Fonix_nand_tablename, "%s\\%s", sDir, UK_ENGLISH_TABLE_NAME);
		FnxTTSDtSimpleSetLanguage( UK_English, NULL,Fonix_nand_file_name,0);
	}
	else if(text == "Latin American Spanish")
	{
		sprintf(Fonix_nand_file_name, "%s\\%s", sDir, LATIN_SPANISH_FILE_NAME);
		//sprintf(Fonix_nand_tablename, "%s\\%s", sDir, LATIN_SPANISH_TABLE_NAME);
		FnxTTSDtSimpleSetLanguage( Latin_American_Spanish, NULL,Fonix_nand_file_name,0);
	}
	//if( LanguageSel > 3 )
	//	LanguageSel++;

//	FnxTTSDtSimpleSetLanguage( (FnxDECtalkLanguageId)LanguageSel, NULL );
}

void CTestTtsDtSimpleDlg::OnSelchangeVoice() 
{
	// TODO: Add your control notification handler code here
	int VoiceNumber;

	VoiceNumber = m_Voice.GetCurSel();

	FnxTTSDtSimpleChangeVoice( (FnxDECtalkVoiceId)VoiceNumber, WaveFormat,Fonix_nand_file_name,Fonix_nand_tablename);
}

void CTestTtsDtSimpleDlg::OnReset() 
{
	DisableButtons();
	m_Language.SetCurSel (0);
	m_Voice.SetCurSel(0);
	FnxTTSDtSimpleResetSpeech();
	EnableButtons();
}

void CTestTtsDtSimpleDlg::OnCreateWav() 
{
	CString csText;
	CString csFileName;
	int actualSamples;

	m_TextInput.GetWindowText( csText );

	DisableButtons();

	actualSamples = FnxTTSDtSimpleStart( csText.GetBuffer(csText.GetLength()), AudioBuffer, AUDIO_OUT_BUF_LEN, WaveFormat,Fonix_nand_file_name,Fonix_nand_tablename);
	GetFileName();
	WriteWavFile((char *)(LPCTSTR)m_csWavFileName, AudioBuffer, actualSamples, AudioOutSampleRate );
	EnableButtons();
}

void CTestTtsDtSimpleDlg::OnCreateWavList() 
{
	CString 
		csText;
	char
		sText[128];
	int 
		i,
		nIdx, 
		nSelItems,
		*piSelItems;
	int nActualSamples;

	DisableButtons();

	if( (nSelItems = m_WordList.GetSelCount()) == LB_ERR )
	{
		goto OnCreateWavListErr;
	}

	if( (piSelItems = (int *)calloc(nSelItems, sizeof(int))) == NULL )
		goto OnCreateWavListErr;

	if( m_WordList.GetSelItems(nSelItems, piSelItems) != nSelItems )
		goto OnCreateWavListErr;

	GetFileName();
	for( i=0; i < nSelItems; i++ )
	{
		nIdx = piSelItems[i];
		m_WordList.GetText(nIdx, sText);
		nActualSamples = FnxTTSDtSimpleStart( sText, AudioBuffer, AUDIO_OUT_BUF_LEN, WaveFormat,Fonix_nand_file_name,Fonix_nand_tablename);
		if( i== 0 )
			WriteWavFile((char *)(LPCTSTR)m_csWavFileName, AudioBuffer, nActualSamples, AudioOutSampleRate );
		else
			CatWavFile((char *)(LPCTSTR)m_csWavFileName, AudioBuffer, nActualSamples, AudioOutSampleRate );

	}
	free(piSelItems);


OnCreateWavListErr:
	EnableButtons();
	return;
	
}


void CTestTtsDtSimpleDlg::GetFileName() 
{
	CFileDialog filedlg(FALSE, _T("wav"), NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, _T("Wav Files (*.wav)|*.wav|All Files (*.*)|*.*||"));

	filedlg.m_ofn.lpstrInitialDir = (LPCTSTR)m_csCurrentPath;
	
	if (filedlg.DoModal() == IDOK)
	{
		m_csWavFileName = filedlg.GetPathName();

		if( m_csWavFileName.IsEmpty() )
		{
			MessageBox(_T("File name is empty!"));
		}
	}
}
	

void CTestTtsDtSimpleDlg::OnSamplerate11() 
{
	// TODO: Add your command handler code here
	//AudioOutSampleRate = SAMPLE_RATE_11K;
	//WaveFormat = WAVE_FORMAT_1M16;
	//AudioFrameSize = AUDIO_FRAME_SIZE_11K;
	//GetMenu( )->CheckMenuItem(ID_SAMPLERATE11, MF_CHECKED);
	//GetMenu( )->CheckMenuItem(ID_SAMPLERATE8, MF_UNCHECKED );
}

void CTestTtsDtSimpleDlg::OnSamplerate8() 
{
	// TODO: Add your command handler code here
	AudioOutSampleRate = SAMPLE_RATE_8K;
	WaveFormat = WAVE_FORMAT_08M16;
	AudioFrameSize = AUDIO_FRAME_SIZE_8K;

	//GetMenu( )->CheckMenuItem(ID_SAMPLERATE11, MF_UNCHECKED );
	GetMenu( )->CheckMenuItem(ID_SAMPLERATE8, MF_CHECKED );
}

void CTestTtsDtSimpleDlg::DisableButtons( void )
{
	m_TextInputSpeak.EnableWindow(FALSE);
	m_TextInputCreateWav.EnableWindow(FALSE);

	m_WordListSpeak.EnableWindow(FALSE);
	m_WordListAdd.EnableWindow(FALSE);
	m_WordListDelete.EnableWindow(FALSE);
	m_WordListSpeakList.EnableWindow(FALSE);
	m_WordListCreateWav.EnableWindow(FALSE);

	m_ResetButton.EnableWindow(FALSE);
}

void CTestTtsDtSimpleDlg::EnableButtons( void )
{
	int nIdx, ListLength;
	CString csTextInput;
	CString csWordListInput;
	int TextInputLength;

	// Enable Text Input Section buttons if there is text in the text box
	m_TextInput.GetWindowText( csTextInput );
	TextInputLength = csTextInput.GetLength();
	if( TextInputLength )
	{
		m_TextInputSpeak.EnableWindow(TRUE);
		m_TextInputCreateWav.EnableWindow(TRUE);
		m_WordListAdd.EnableWindow(TRUE);
	}
	// Enable Word List Buttons if there are entries in the list box
	ListLength = m_WordList.GetCount();
	if( ListLength )
	{
		nIdx = m_WordList.GetCurSel();
		if (nIdx != LB_ERR)
		{
			m_WordList.GetText(nIdx, csWordListInput);
		}
		if( csWordListInput.GetLength() )
		{
			m_WordListSpeak.EnableWindow(TRUE);
			m_WordListCreateWav.EnableWindow(TRUE);
		}
		m_WordListDelete.EnableWindow(TRUE);
		m_WordListSpeakList.EnableWindow(TRUE);
	}

	// If there is text in the text box that matchs an entry in the word list
	// disable the Add button
	if( TextInputLength && ListLength )
	{
		nIdx = 0;
		while( nIdx < ListLength )
		{
			m_WordList.GetText(nIdx, csWordListInput);
			if ( csWordListInput.Compare( csTextInput ) == 0 )
				break;
			nIdx++;
		}
		if ( nIdx < ListLength )
			m_WordListAdd.EnableWindow(FALSE);
	}

	m_ResetButton.EnableWindow(TRUE);
}
