/*C_HEADER_FILE****************************************************************
FILE			:	Kanji2Kana
DESC			:	
TABS			:	4
OWNER			:	
DATE CREATED:	

(C) Copyright 2005 All rights reserved.
This is an unpublished work, and is confidential and proprietary: 
technology and information of fonix corporation.  No part of this
code may be reproduced, used or disclosed without written consent of 
fonix corporation in each and every instance.

  $Date:  $
  $Revision:  $

*END_HEADER*******************************************************************/

#include "BuildJpDic.h"
#include "CodePageConv.h"

/*FUNCTION_HEADER**********************
 * NAME:	;
 * DESC: 	
 * IN:		
 * OUT:		
 * RETURN:	
 * NOTES:	
 *END_HEADER***************************/
int IsUnicodeHira(unsigned short wHira)
{
	if( (UNI_HIRAGANA_MIN <= wHira && wHira <= UNI_HIRAGANA_MAX)  )
		return 1;
	else
		return 0;
}
int IsEucHira(unsigned short wHira)
{
	if( (EUC_HIRAGANA_MIN <= wHira && wHira <= EUC_HIRAGANA_MAX) ||
		wHira == 0xa1ab || wHira == 0xa1ac || wHira == 0xa1b5 )
		return 1;
	else
		return 0;
}
int IsHira(unsigned short wHira)
{
	if( IsUnicodeHira(wHira) ||
		IsEucHira(wHira) )
		return 1;
	else
		return 0;
}


int IsUnicodeKata(unsigned short wKata)
{
	if( (UNI_KATAKANA_MIN <= wKata && wKata <= UNI_KATAKANA_MAX) )
		return 1;
	else
		return 0;
}
int IsEucKata(unsigned short wKata)
{
	if( ((EUC_KATAKANA_MIN <= wKata && wKata <= EUC_KATAKANA_MAX) || 
		wKata == 0xa1a6 || wKata==0xa1bc || wKata==0xa1b3|| wKata==0xa1b4)  )
		return 1;
	else
		return 0;
}

int IsKata(unsigned short wKata)
{
	if( IsUnicodeKata(wKata) ||
		IsEucKata(wKata) )
		return 1;
	else
		return 0;
}

int IsUnicodeKanji(unsigned short wKanji)
{
	//	CJK		0x4E00 - 0x9FAF
	if( 0x4e00 <= wKanji && wKanji <= 0x0faf )
		return 1;
	else
		return 0;
}

int IsEucKanji(unsigned short wKanji)
{
	unsigned short s1, s2;

	s2 = wKanji & 0x00ff;
	wKanji -= s2;
	s1 = (wKanji & 0xff00) >> 8;

	if( (0xa1 <= s1 && s1 <= 0xfe) &&
		(0xa1 <= s2 && s2 <= 0xfe) )
		return 1;
	else
		return 0;
}

int IsKanji(unsigned short wKanji)
{
	if( IsUnicodeKanji(wKanji) ||
		IsEucKanji(wKanji) )
		return 1;
	else
		return 0;
}

unsigned short Kata2Hira(unsigned short wKata)
{
	
	if( IsUnicodeKata(wKata) )
	{
		return UNI_HIRAGANA_MIN + (wKata - UNI_KATAKANA_MIN);
	}
	else if( IsEucKata(wKata) )
	{
		if( wKata == 0xa1a6 ) return 0xa1ab;
		if( wKata == 0xa1bc ) return 0xa1ac;
		if( wKata == 0xa1b3 ) return 0xa1b5;
		if( wKata == 0xa1b4 ) return 0xa1b6;
		else 
			return EUC_HIRAGANA_MIN + (wKata - EUC_KATAKANA_MIN);
	}
	else
		return wKata;

}

void StrKata2Hira(unsigned short *wsKata)
{
	unsigned short 
		*pwc;

	for( pwc = wsKata; *pwc; pwc++ )
	{
		*pwc = Kata2Hira(*pwc);
	}
}

unsigned short Hira2Kata(unsigned short wHira)
{
	unsigned short
		wKata;

	if( !IsHira(wHira) )
		return wHira;

	wKata = UNI_KATAKANA_MIN + (wHira - UNI_HIRAGANA_MIN);
	return wKata;
}

void StrHira2Kata(unsigned short *wsHira)
{
	unsigned short
		*pwc;

	for( pwc = wsHira; *pwc; pwc++ )
	{
		*pwc = Hira2Kata(*pwc);
	}
}

void WriteKanjiList(char *sKanjiList, KANJIDIC **ppKanji, unsigned int nKanji)
{
	unsigned int
		i;
	wchar_t
		wc,
		wsText[128];
	FILE 
		*fp;

	if( sKanjiList == NULL || ppKanji == NULL )		// Idiot check
		return;

	if( (fp = fopen(sKanjiList, "wb")) == NULL )		// Open output file
		return;

	wc = 0xfeff;
	fwrite(&wc, sizeof(wchar_t), 1, fp);			// Write Unicode header


	for( i=0; i<nKanji; i++ )
	{
		wc = Convert(ppKanji[i]->wcKanji, eEuc, eUtf16);
		wsText[0] = wc;
		wsText[1] = 0x00;
		fwprintf(fp, L"[%d] %x %c\n", i, wc, wc);
	}

	fclose(fp);

}

void WriteKanjiTable(char *sOutFile, KANJIDIC **ppKanji, unsigned int nKanji)
{
	unsigned int
		i;
	wchar_t
		wc,
		wsText[128];
	FILE 
		*fp;
	KANJIREADING 
		*pReading;

	if( sOutFile == NULL || ppKanji == NULL )		// Idiot check
		return;

	if( (fp = fopen(sOutFile, "wb")) == NULL )		// Open output file
		return;

	wc = 0xfeff;
	fwrite(&wc, sizeof(wchar_t), 1, fp);			// Write Unicode header


	for( i=0; i<nKanji; i++ )
	{
		wc = Convert(ppKanji[i]->wcKanji, eEuc, eUtf16);
		wsText[0] = wc;
		wsText[1] = 0x00;
		fwprintf(fp, L"[%d] %c U+0x%x EUC+0x%x\n", i, wc, wc, ppKanji[i]->wcKanji);
		for( pReading=ppKanji[i]->pReading; pReading; pReading=pReading->pNext )
		{
			wcscpy(wsText, pReading->wsReading);
			e2u(wsText);
			fwprintf(fp, L"\t%-6s\n", wsText);
		}
	}

	fclose(fp);
}


/*
			NOTES

  1)  1 Kanji by itself is translated to Kunyomi (Japanese - Hiragana) pronunciation.
  2)  2+ Kanji together are translated to Onyomi (Chinese - Katakana) pronunciation.
  3)  There are no spaces to separate words.
  4)  Kanji and Kanji groups indicate general word locations in sentence.
  5)  

*/