/*H_HEADER_FILE***************************************************************
FILE			: Kana2Rom.h
DESC			: Convert Hiragana or Katakana to Romaji
TABS			: 4
OWNER			: Fonix
DATE CREATED	: 29 Nov 2005

(C) Copyright 2005 All rights reserved.
This is an unpublished work, and is confidential and proprietary: 
technology and information of fonix corporation.  No part of this
code may be reproduced, used or disclosed without written consent of 
fonix corporation in each and every instance.

  $Date:  $
  $Revision:  $

*END_HEADER******************************************************************/
#ifndef	KANA2ROM_H
#define	KANA2ROM_H


/*FUNCTION_HEADER**********************
 * NAME:	;Kana2Rom
 * DESC: 	Convert kana to romaji by calling process_kana
 * IN:		sRaw - raw euc kana text
			ok_mark - okurigana marker . - or (
			bForceEUC - 
 * OUT:		sRom - romaji translation
 * RETURN:	
 * NOTES:	
 *END_HEADER***************************/
extern void Kana2Rom(char *sRaw, char *sRom, char ok_mark, int bForceEUC);

/*FUNCTION_HEADER**********************
 * NAME:	;Kana2RomW
 * DESC: 	Convert kana to romaji by calling process_kana
 * IN:		wsRaw - raw euc kana text in wide character format
			ok_mark - okurigana marker . - or (
			bForceEUC - 
 * OUT:		sRom - romaji translation
 * RETURN:	
 * NOTES:	
 *END_HEADER***************************/
extern void Kana2RomW(wchar_t *wsRaw, char *sRom, char ok_mark, int bForceEUC);

#endif
