%{
#include <stdio.h>
#include <string.h>
#include "sgrammar_tab.h"
#include "sgrammar.h"
%}
%option noyywrap
%%
[\t ]+                    movelexcolumn(yyleng);
[\n]                         {nextlexline();}
"TRIE"|"Trie"|"trie"      {movelexcolumn(yyleng); return TRIE;}
"RTRIE"|"RTrie"|"rtrie"   {movelexcolumn(yyleng); return RTRIE;}
"LTRIE"|"LTrie"|"ltrie"   {movelexcolumn(yyleng); return LTRIE;}
"OR"                    {movelexcolumn(yyleng); return SEQOR;}
"AND"                   {movelexcolumn(yyleng); return SEQAND;}
"NOT"                   {movelexcolumn(yyleng); return SEQNOT;}
"seq"|"SEQ"           {movelexcolumn(yyleng); return SEQ;}
"def"|"DEF"           {movelexcolumn(yyleng); return DEF;}
"PROCESS"|"Process"|"process"   {movelexcolumn(yyleng); return PROCESS;}
"FILE"|"File"|"file"      {movelexcolumn(yyleng); return TRIEFILE;}
"EMPTY"|"NIL"|"LEER"|"empty" {movelexcolumn(yyleng); return EMPTYNODE;}
"SKIP"|"skip"           {movelexcolumn(yyleng); return SKIPWORD;}
"LETTERS"|"Letters"     {movelexcolumn(yyleng); return SKIPLETTER;}
"ENDSIN" |"ends_in"     {movelexcolumn(yyleng); return ENDSIN;}
"$"|"$EOF"|"$END"       {movelexcolumn(yyleng); return ENDTRIE;}
"("                     {movelexcolumn(yyleng); yylval.oper='('; return LBRAK;}
")"                     {movelexcolumn(yyleng); yylval.oper=')'; return RBRAK;}
[0-9]+      {
             yylval.ival = atoi(yytext);
             movelexcolumn(yyleng);
             return INTEGER; 
            }
[A-Za-z][A-Za-z0-9_\-]*    {
                            yylval.sympt = symlook(yytext);
                            movelexcolumn(yyleng);
                            return NAME;
                           }
\*[A-Za-z]*\([^)]{0,50}\)\*      {
                                  yylval.string = strdup(yytext);
                                  movelexcolumn(yyleng); 
                                  return OPERATOR;
                                 }
\"[A-Za-z][A-Za-z0-9\_]*\.[a-z]+\"                {
                                                 yylval.string = strdup(yytext);
                                                 movelexcolumn(yyleng); 
                                                 return FILENAME;
                                                }
\"[^\"]{1,20}\"           {
                           yylval.sympt = symlook(yytext); /* \"[a-z\-]+\" */
                           movelexcolumn(yyleng); 
                           return MORPH;
                          }
\<[^>]{1,20}\>           {
                           yylval.string = strdup(yytext); 
                           movelexcolumn(yyleng); 
                           return BOUND;
                         }
"//".* ;
"//"|#.*\n   {nextlexline(); return COMMENTLINE;}
.       {                         
         movelexcolumn(yyleng);
         return yytext[0];
        }
%%
