/*H_HEADER_FILE***************************************************************
FILE			: CodeConversionTable.h
DESC			: 
TABS			: 4
OWNER			: Fonix
DATE CREATED	: 23 March 2006 

(C) Copyright 2005 All rights reserved.
This is an unpublished work, and is confidential and proprietary: 
technology and information of fonix corporation.  No part of this
code may be reproduced, used or disclosed without written consent of 
fonix corporation in each and every instance.

  $Date:  $
  $Revision:  $

*END_HEADER******************************************************************/
#ifndef	CODECONVERSIONTABLE_H
#define	CODECONVERSIONTABLE_H

typedef struct _tagCodeConv
{
	unsigned short code, utf;
}CODE_CONV;

#ifdef CASIO_SH3
static CONST CODE_CONV ppwSjis2Utf[] = {
#else
static CODE_CONV ppwSjis2Utf[] = {
#endif //CASIO_SH3
	{0x0001, 0x0001},
	{0x0002, 0x0002},
	{0x0003, 0x0003},
	{0x0004, 0x0004},
	{0x0005, 0x0005},
	{0x0006, 0x0006},
	{0x0007, 0x0007},
	{0x0008, 0x0008},
	{0x0009, 0x0009},
	{0x000a, 0x000a},
	{0x000b, 0x000b},
	{0x000c, 0x000c},
	{0x000d, 0x000d},
	{0x000e, 0x000e},
	{0x000f, 0x000f},
	{0x0010, 0x0010},
	{0x0011, 0x0011},
	{0x0012, 0x0012},
	{0x0013, 0x0013},
	{0x0014, 0x0014},
	{0x0015, 0x0015},
	{0x0016, 0x0016},
	{0x0017, 0x0017},
	{0x0018, 0x0018},
	{0x0019, 0x0019},
	{0x001a, 0x001a},
	{0x001b, 0x001b},
	{0x001c, 0x001c},
	{0x001d, 0x001d},
	{0x001e, 0x001e},
	{0x001f, 0x001f},
	{0x0020, 0x0020},
	{0x0021, 0x0021},
	{0x0022, 0x0022},
	{0x0023, 0x0023},
	{0x0024, 0x0024},
	{0x0025, 0x0025},
	{0x0026, 0x0026},
	{0x0027, 0x0027},
	{0x0028, 0x0028},
	{0x0029, 0x0029},
	{0x002a, 0x002a},
	{0x002b, 0x002b},
	{0x002c, 0x002c},
	{0x002d, 0x002d},
	{0x002e, 0x002e},
	{0x002f, 0x002f},
	{0x0030, 0x0030},
	{0x0031, 0x0031},
	{0x0032, 0x0032},
	{0x0033, 0x0033},
	{0x0034, 0x0034},
	{0x0035, 0x0035},
	{0x0036, 0x0036},
	{0x0037, 0x0037},
	{0x0038, 0x0038},
	{0x0039, 0x0039},
	{0x003a, 0x003a},
	{0x003b, 0x003b},
	{0x003c, 0x003c},
	{0x003d, 0x003d},
	{0x003e, 0x003e},
	{0x003f, 0x003f},
	{0x0040, 0x0040},
	{0x0041, 0x0041},
	{0x0042, 0x0042},
	{0x0043, 0x0043},
	{0x0044, 0x0044},
	{0x0045, 0x0045},
	{0x0046, 0x0046},
	{0x0047, 0x0047},
	{0x0048, 0x0048},
	{0x0049, 0x0049},
	{0x004a, 0x004a},
	{0x004b, 0x004b},
	{0x004c, 0x004c},
	{0x004d, 0x004d},
	{0x004e, 0x004e},
	{0x004f, 0x004f},
	{0x0050, 0x0050},
	{0x0051, 0x0051},
	{0x0052, 0x0052},
	{0x0053, 0x0053},
	{0x0054, 0x0054},
	{0x0055, 0x0055},
	{0x0056, 0x0056},
	{0x0057, 0x0057},
	{0x0058, 0x0058},
	{0x0059, 0x0059},
	{0x005a, 0x005a},
	{0x005b, 0x005b},
	{0x005d, 0x005d},
	{0x005e, 0x005e},
	{0x005f, 0x005f},
	{0x0060, 0x0060},
	{0x0061, 0x0061},
	{0x0062, 0x0062},
	{0x0063, 0x0063},
	{0x0064, 0x0064},
	{0x0065, 0x0065},
	{0x0066, 0x0066},
	{0x0067, 0x0067},
	{0x0068, 0x0068},
	{0x0069, 0x0069},
	{0x006a, 0x006a},
	{0x006b, 0x006b},
	{0x006c, 0x006c},
	{0x006d, 0x006d},
	{0x006e, 0x006e},
	{0x006f, 0x006f},
	{0x0070, 0x0070},
	{0x0071, 0x0071},
	{0x0072, 0x0072},
	{0x0073, 0x0073},
	{0x0074, 0x0074},
	{0x0075, 0x0075},
	{0x0076, 0x0076},
	{0x0077, 0x0077},
	{0x0078, 0x0078},
	{0x0079, 0x0079},
	{0x007a, 0x007a},
	{0x007b, 0x007b},
	{0x007c, 0x007c},
	{0x007d, 0x007d},
	{0x007e, 0x007e},
	{0x007f, 0x007f},
	{0x00a1, 0xff61},
	{0x00a2, 0xff62},
	{0x00a3, 0xff63},
	{0x00a4, 0xff64},
	{0x00a5, 0xff65},
	{0x00a6, 0xff66},
	{0x00a7, 0xff67},
	{0x00a8, 0xff68},
	{0x00a9, 0xff69},
	{0x00aa, 0xff6a},
	{0x00ab, 0xff6b},
	{0x00ac, 0xff6c},
	{0x00ad, 0xff6d},
	{0x00ae, 0xff6e},
	{0x00af, 0xff6f},
	{0x00b0, 0xff70},
	{0x00b1, 0xff71},
	{0x00b2, 0xff72},
	{0x00b3, 0xff73},
	{0x00b4, 0xff74},
	{0x00b5, 0xff75},
	{0x00b6, 0xff76},
	{0x00b7, 0xff77},
	{0x00b8, 0xff78},
	{0x00b9, 0xff79},
	{0x00ba, 0xff7a},
	{0x00bb, 0xff7b},
	{0x00bc, 0xff7c},
	{0x00bd, 0xff7d},
	{0x00be, 0xff7e},
	{0x00bf, 0xff7f},
	{0x00c0, 0xff80},
	{0x00c1, 0xff81},
	{0x00c2, 0xff82},
	{0x00c3, 0xff83},
	{0x00c4, 0xff84},
	{0x00c5, 0xff85},
	{0x00c6, 0xff86},
	{0x00c7, 0xff87},
	{0x00c8, 0xff88},
	{0x00c9, 0xff89},
	{0x00ca, 0xff8a},
	{0x00cb, 0xff8b},
	{0x00cc, 0xff8c},
	{0x00cd, 0xff8d},
	{0x00ce, 0xff8e},
	{0x00cf, 0xff8f},
	{0x00d0, 0xff90},
	{0x00d1, 0xff91},
	{0x00d2, 0xff92},
	{0x00d3, 0xff93},
	{0x00d4, 0xff94},
	{0x00d5, 0xff95},
	{0x00d6, 0xff96},
	{0x00d7, 0xff97},
	{0x00d8, 0xff98},
	{0x00d9, 0xff99},
	{0x00da, 0xff9a},
	{0x00db, 0xff9b},
	{0x00dc, 0xff9c},
	{0x00dd, 0xff9d},
	{0x00de, 0xff9e},
	{0x00df, 0xff9f},
	{0x8140, 0x3000},
	{0x8141, 0x3001},
	{0x8142, 0x3002},
	{0x8143, 0xff0c},
	{0x8144, 0xff0e},
	{0x8145, 0x30fb},
	{0x8146, 0xff1a},
	{0x8147, 0xff1b},
	{0x8148, 0xff1f},
	{0x8149, 0xff01},
	{0x814a, 0x309b},
	{0x814b, 0x309c},
	{0x814c, 0x00b4},
	{0x814d, 0xff40},
	{0x814e, 0x00a8},
	{0x814f, 0xff3e},
	{0x8150, 0xffe3},
	{0x8151, 0xff3f},
	{0x8152, 0x30fd},
	{0x8153, 0x30fe},
	{0x8154, 0x309d},
	{0x8155, 0x309e},
	{0x8156, 0x3003},
	{0x8157, 0x4edd},
	{0x8158, 0x3005},
	{0x8159, 0x3006},
	{0x815a, 0x3007},
	{0x815b, 0x30fc},
	{0x815c, 0x2014},
	{0x815c, 0x2015},
	{0x815d, 0x2010},
	{0x815e, 0xff0f},
	{0x815f, 0xff3c},
	{0x815f, 0x005c},
	{0x8160, 0xff5e},
	{0x8160, 0x301c},
	{0x8161, 0x2225},
	{0x8161, 0x2016},
	{0x8162, 0xff5c},
	{0x8163, 0x2026},
	{0x8164, 0x2025},
	{0x8165, 0x2018},
	{0x8166, 0x2019},
	{0x8167, 0x201c},
	{0x8168, 0x201d},
	{0x8169, 0xff08},
	{0x816a, 0xff09},
	{0x816b, 0x3014},
	{0x816c, 0x3015},
	{0x816d, 0xff3b},
	{0x816e, 0xff3d},
	{0x816f, 0xff5b},
	{0x8170, 0xff5d},
	{0x8171, 0x3008},
	{0x8172, 0x3009},
	{0x8173, 0x300a},
	{0x8174, 0x300b},
	{0x8175, 0x300c},
	{0x8176, 0x300d},
	{0x8177, 0x300e},
	{0x8178, 0x300f},
	{0x8179, 0x3010},
	{0x817a, 0x3011},
	{0x817b, 0xff0b},
	{0x817c, 0xff0d},
	{0x817c, 0x2212},
	{0x817d, 0x00b1},
	{0x817e, 0x00d7},
	{0x8180, 0x00f7},
	{0x8181, 0xff1d},
	{0x8182, 0x2260},
	{0x8183, 0xff1c},
	{0x8184, 0xff1e},
	{0x8185, 0x2266},
	{0x8186, 0x2267},
	{0x8187, 0x221e},
	{0x8188, 0x2234},
	{0x8189, 0x2642},
	{0x818a, 0x2640},
	{0x818b, 0x00b0},
	{0x818c, 0x2032},
	{0x818d, 0x2033},
	{0x818e, 0x2103},
	{0x818f, 0xffe5},
	{0x8190, 0xff04},
	{0x8191, 0x00a2},
	{0x8191, 0xffe0},
	{0x8192, 0x00a3},
	{0x8192, 0xffe1},
	{0x8193, 0xff05},
	{0x8194, 0xff03},
	{0x8195, 0xff06},
	{0x8196, 0xff0a},
	{0x8197, 0xff20},
	{0x8198, 0x00a7},
	{0x8199, 0x2606},
	{0x819a, 0x2605},
	{0x819b, 0x25cb},
	{0x819c, 0x25cf},
	{0x819d, 0x25ce},
	{0x819e, 0x25c7},
	{0x819f, 0x25c6},
	{0x81a0, 0x25a1},
	{0x81a1, 0x25a0},
	{0x81a2, 0x25b3},
	{0x81a3, 0x25b2},
	{0x81a4, 0x25bd},
	{0x81a5, 0x25bc},
	{0x81a6, 0x203b},
	{0x81a7, 0x3012},
	{0x81a8, 0x2192},
	{0x81a9, 0x2190},
	{0x81aa, 0x2191},
	{0x81ab, 0x2193},
	{0x81ac, 0x3013},
	{0x81b8, 0x2208},
	{0x81b9, 0x220b},
	{0x81ba, 0x2286},
	{0x81bb, 0x2287},
	{0x81bc, 0x2282},
	{0x81bd, 0x2283},
	{0x81be, 0x222a},
	{0x81bf, 0x2229},
	{0x81c8, 0x2227},
	{0x81c9, 0x2228},
	{0x81ca, 0xffe2},
	{0x81ca, 0x00ac},
	{0x81cb, 0x21d2},
	{0x81cc, 0x21d4},
	{0x81cd, 0x2200},
	{0x81ce, 0x2203},
	{0x81da, 0x2220},
	{0x81db, 0x22a5},
	{0x81dc, 0x2312},
	{0x81dd, 0x2202},
	{0x81de, 0x2207},
	{0x81df, 0x2261},
	{0x81e0, 0x2252},
	{0x81e1, 0x226a},
	{0x81e2, 0x226b},
	{0x81e3, 0x221a},
	{0x81e4, 0x223d},
	{0x81e5, 0x221d},
	{0x81e6, 0x2235},
	{0x81e7, 0x222b},
	{0x81e8, 0x222c},
	{0x81f0, 0x212b},
	{0x81f1, 0x2030},
	{0x81f2, 0x266f},
	{0x81f3, 0x266d},
	{0x81f4, 0x266a},
	{0x81f5, 0x2020},
	{0x81f6, 0x2021},
	{0x81f7, 0x00b6},
	{0x81fc, 0x25ef},
	{0x824f, 0xff10},
	{0x8250, 0xff11},
	{0x8251, 0xff12},
	{0x8252, 0xff13},
	{0x8253, 0xff14},
	{0x8254, 0xff15},
	{0x8255, 0xff16},
	{0x8256, 0xff17},
	{0x8257, 0xff18},
	{0x8258, 0xff19},
	{0x8260, 0xff21},
	{0x8261, 0xff22},
	{0x8262, 0xff23},
	{0x8263, 0xff24},
	{0x8264, 0xff25},
	{0x8265, 0xff26},
	{0x8266, 0xff27},
	{0x8267, 0xff28},
	{0x8268, 0xff29},
	{0x8269, 0xff2a},
	{0x826a, 0xff2b},
	{0x826b, 0xff2c},
	{0x826c, 0xff2d},
	{0x826d, 0xff2e},
	{0x826e, 0xff2f},
	{0x826f, 0xff30},
	{0x8270, 0xff31},
	{0x8271, 0xff32},
	{0x8272, 0xff33},
	{0x8273, 0xff34},
	{0x8274, 0xff35},
	{0x8275, 0xff36},
	{0x8276, 0xff37},
	{0x8277, 0xff38},
	{0x8278, 0xff39},
	{0x8279, 0xff3a},
	{0x8281, 0xff41},
	{0x8282, 0xff42},
	{0x8283, 0xff43},
	{0x8284, 0xff44},
	{0x8285, 0xff45},
	{0x8286, 0xff46},
	{0x8287, 0xff47},
	{0x8288, 0xff48},
	{0x8289, 0xff49},
	{0x828a, 0xff4a},
	{0x828b, 0xff4b},
	{0x828c, 0xff4c},
	{0x828d, 0xff4d},
	{0x828e, 0xff4e},
	{0x828f, 0xff4f},
	{0x8290, 0xff50},
	{0x8291, 0xff51},
	{0x8292, 0xff52},
	{0x8293, 0xff53},
	{0x8294, 0xff54},
	{0x8295, 0xff55},
	{0x8296, 0xff56},
	{0x8297, 0xff57},
	{0x8298, 0xff58},
	{0x8299, 0xff59},
	{0x829a, 0xff5a},
	{0x829f, 0x3041},
	{0x82a0, 0x3042},
	{0x82a1, 0x3043},
	{0x82a2, 0x3044},
	{0x82a3, 0x3045},
	{0x82a4, 0x3046},
	{0x82a5, 0x3047},
	{0x82a6, 0x3048},
	{0x82a7, 0x3049},
	{0x82a8, 0x304a},
	{0x82a9, 0x304b},
	{0x82aa, 0x304c},
	{0x82ab, 0x304d},
	{0x82ac, 0x304e},
	{0x82ad, 0x304f},
	{0x82ae, 0x3050},
	{0x82af, 0x3051},
	{0x82b0, 0x3052},
	{0x82b1, 0x3053},
	{0x82b2, 0x3054},
	{0x82b3, 0x3055},
	{0x82b4, 0x3056},
	{0x82b5, 0x3057},
	{0x82b6, 0x3058},
	{0x82b7, 0x3059},
	{0x82b8, 0x305a},
	{0x82b9, 0x305b},
	{0x82ba, 0x305c},
	{0x82bb, 0x305d},
	{0x82bc, 0x305e},
	{0x82bd, 0x305f},
	{0x82be, 0x3060},
	{0x82bf, 0x3061},
	{0x82c0, 0x3062},
	{0x82c1, 0x3063},
	{0x82c2, 0x3064},
	{0x82c3, 0x3065},
	{0x82c4, 0x3066},
	{0x82c5, 0x3067},
	{0x82c6, 0x3068},
	{0x82c7, 0x3069},
	{0x82c8, 0x306a},
	{0x82c9, 0x306b},
	{0x82ca, 0x306c},
	{0x82cb, 0x306d},
	{0x82cc, 0x306e},
	{0x82cd, 0x306f},
	{0x82ce, 0x3070},
	{0x82cf, 0x3071},
	{0x82d0, 0x3072},
	{0x82d1, 0x3073},
	{0x82d2, 0x3074},
	{0x82d3, 0x3075},
	{0x82d4, 0x3076},
	{0x82d5, 0x3077},
	{0x82d6, 0x3078},
	{0x82d7, 0x3079},
	{0x82d8, 0x307a},
	{0x82d9, 0x307b},
	{0x82da, 0x307c},
	{0x82db, 0x307d},
	{0x82dc, 0x307e},
	{0x82dd, 0x307f},
	{0x82de, 0x3080},
	{0x82df, 0x3081},
	{0x82e0, 0x3082},
	{0x82e1, 0x3083},
	{0x82e2, 0x3084},
	{0x82e3, 0x3085},
	{0x82e4, 0x3086},
	{0x82e5, 0x3087},
	{0x82e6, 0x3088},
	{0x82e7, 0x3089},
	{0x82e8, 0x308a},
	{0x82e9, 0x308b},
	{0x82ea, 0x308c},
	{0x82eb, 0x308d},
	{0x82ec, 0x308e},
	{0x82ed, 0x308f},
	{0x82ee, 0x3090},
	{0x82ef, 0x3091},
	{0x82f0, 0x3092},
	{0x82f1, 0x3093},
	{0x8340, 0x30a1},
	{0x8341, 0x30a2},
	{0x8342, 0x30a3},
	{0x8343, 0x30a4},
	{0x8344, 0x30a5},
	{0x8345, 0x30a6},
	{0x8346, 0x30a7},
	{0x8347, 0x30a8},
	{0x8348, 0x30a9},
	{0x8349, 0x30aa},
	{0x834a, 0x30ab},
	{0x834b, 0x30ac},
	{0x834c, 0x30ad},
	{0x834d, 0x30ae},
	{0x834e, 0x30af},
	{0x834f, 0x30b0},
	{0x8350, 0x30b1},
	{0x8351, 0x30b2},
	{0x8352, 0x30b3},
	{0x8353, 0x30b4},
	{0x8354, 0x30b5},
	{0x8355, 0x30b6},
	{0x8356, 0x30b7},
	{0x8357, 0x30b8},
	{0x8358, 0x30b9},
	{0x8359, 0x30ba},
	{0x835a, 0x30bb},
	{0x835b, 0x30bc},
	{0x835c, 0x30bd},
	{0x835d, 0x30be},
	{0x835e, 0x30bf},
	{0x835f, 0x30c0},
	{0x8360, 0x30c1},
	{0x8361, 0x30c2},
	{0x8362, 0x30c3},
	{0x8363, 0x30c4},
	{0x8364, 0x30c5},
	{0x8365, 0x30c6},
	{0x8366, 0x30c7},
	{0x8367, 0x30c8},
	{0x8368, 0x30c9},
	{0x8369, 0x30ca},
	{0x836a, 0x30cb},
	{0x836b, 0x30cc},
	{0x836c, 0x30cd},
	{0x836d, 0x30ce},
	{0x836e, 0x30cf},
	{0x836f, 0x30d0},
	{0x8370, 0x30d1},
	{0x8371, 0x30d2},
	{0x8372, 0x30d3},
	{0x8373, 0x30d4},
	{0x8374, 0x30d5},
	{0x8375, 0x30d6},
	{0x8376, 0x30d7},
	{0x8377, 0x30d8},
	{0x8378, 0x30d9},
	{0x8379, 0x30da},
	{0x837a, 0x30db},
	{0x837b, 0x30dc},
	{0x837c, 0x30dd},
	{0x837d, 0x30de},
	{0x837e, 0x30df},
	{0x8380, 0x30e0},
	{0x8381, 0x30e1},
	{0x8382, 0x30e2},
	{0x8383, 0x30e3},
	{0x8384, 0x30e4},
	{0x8385, 0x30e5},
	{0x8386, 0x30e6},
	{0x8387, 0x30e7},
	{0x8388, 0x30e8},
	{0x8389, 0x30e9},
	{0x838a, 0x30ea},
	{0x838b, 0x30eb},
	{0x838c, 0x30ec},
	{0x838d, 0x30ed},
	{0x838e, 0x30ee},
	{0x838f, 0x30ef},
	{0x8390, 0x30f0},
	{0x8391, 0x30f1},
	{0x8392, 0x30f2},
	{0x8393, 0x30f3},
	{0x8394, 0x30f4},
	{0x8395, 0x30f5},
	{0x8396, 0x30f6},
	{0x839f, 0x0391},
	{0x83a0, 0x0392},
	{0x83a1, 0x0393},
	{0x83a2, 0x0394},
	{0x83a3, 0x0395},
	{0x83a4, 0x0396},
	{0x83a5, 0x0397},
	{0x83a6, 0x0398},
	{0x83a7, 0x0399},
	{0x83a8, 0x039a},
	{0x83a9, 0x039b},
	{0x83aa, 0x039c},
	{0x83ab, 0x039d},
	{0x83ac, 0x039e},
	{0x83ad, 0x039f},
	{0x83ae, 0x03a0},
	{0x83af, 0x03a1},
	{0x83b0, 0x03a3},
	{0x83b1, 0x03a4},
	{0x83b2, 0x03a5},
	{0x83b3, 0x03a6},
	{0x83b4, 0x03a7},
	{0x83b5, 0x03a8},
	{0x83b6, 0x03a9},
	{0x83bf, 0x03b1},
	{0x83c0, 0x03b2},
	{0x83c1, 0x03b3},
	{0x83c2, 0x03b4},
	{0x83c3, 0x03b5},
	{0x83c4, 0x03b6},
	{0x83c5, 0x03b7},
	{0x83c6, 0x03b8},
	{0x83c7, 0x03b9},
	{0x83c8, 0x03ba},
	{0x83c9, 0x03bb},
	{0x83ca, 0x03bc},
	{0x83cb, 0x03bd},
	{0x83cc, 0x03be},
	{0x83cd, 0x03bf},
	{0x83ce, 0x03c0},
	{0x83cf, 0x03c1},
	{0x83d0, 0x03c3},
	{0x83d1, 0x03c4},
	{0x83d2, 0x03c5},
	{0x83d3, 0x03c6},
	{0x83d4, 0x03c7},
	{0x83d5, 0x03c8},
	{0x83d6, 0x03c9},
	{0x8440, 0x0410},
	{0x8441, 0x0411},
	{0x8442, 0x0412},
	{0x8443, 0x0413},
	{0x8444, 0x0414},
	{0x8445, 0x0415},
	{0x8446, 0x0401},
	{0x8447, 0x0416},
	{0x8448, 0x0417},
	{0x8449, 0x0418},
	{0x844a, 0x0419},
	{0x844b, 0x041a},
	{0x844c, 0x041b},
	{0x844d, 0x041c},
	{0x844e, 0x041d},
	{0x844f, 0x041e},
	{0x8450, 0x041f},
	{0x8451, 0x0420},
	{0x8452, 0x0421},
	{0x8453, 0x0422},
	{0x8454, 0x0423},
	{0x8455, 0x0424},
	{0x8456, 0x0425},
	{0x8457, 0x0426},
	{0x8458, 0x0427},
	{0x8459, 0x0428},
	{0x845a, 0x0429},
	{0x845b, 0x042a},
	{0x845c, 0x042b},
	{0x845d, 0x042c},
	{0x845e, 0x042d},
	{0x845f, 0x042e},
	{0x8460, 0x042f},
	{0x8470, 0x0430},
	{0x8471, 0x0431},
	{0x8472, 0x0432},
	{0x8473, 0x0433},
	{0x8474, 0x0434},
	{0x8475, 0x0435},
	{0x8476, 0x0451},
	{0x8477, 0x0436},
	{0x8478, 0x0437},
	{0x8479, 0x0438},
	{0x847a, 0x0439},
	{0x847b, 0x043a},
	{0x847c, 0x043b},
	{0x847d, 0x043c},
	{0x847e, 0x043d},
	{0x8480, 0x043e},
	{0x8481, 0x043f},
	{0x8482, 0x0440},
	{0x8483, 0x0441},
	{0x8484, 0x0442},
	{0x8485, 0x0443},
	{0x8486, 0x0444},
	{0x8487, 0x0445},
	{0x8488, 0x0446},
	{0x8489, 0x0447},
	{0x848a, 0x0448},
	{0x848b, 0x0449},
	{0x848c, 0x044a},
	{0x848d, 0x044b},
	{0x848e, 0x044c},
	{0x848f, 0x044d},
	{0x8490, 0x044e},
	{0x8491, 0x044f},
	{0x849f, 0x2500},
	{0x84a0, 0x2502},
	{0x84a1, 0x250c},
	{0x84a2, 0x2510},
	{0x84a3, 0x2518},
	{0x84a4, 0x2514},
	{0x84a5, 0x251c},
	{0x84a6, 0x252c},
	{0x84a7, 0x2524},
	{0x84a8, 0x2534},
	{0x84a9, 0x253c},
	{0x84aa, 0x2501},
	{0x84ab, 0x2503},
	{0x84ac, 0x250f},
	{0x84ad, 0x2513},
	{0x84ae, 0x251b},
	{0x84af, 0x2517},
	{0x84b0, 0x2523},
	{0x84b1, 0x2533},
	{0x84b2, 0x252b},
	{0x84b3, 0x253b},
	{0x84b4, 0x254b},
	{0x84b5, 0x2520},
	{0x84b6, 0x252f},
	{0x84b7, 0x2528},
	{0x84b8, 0x2537},
	{0x84b9, 0x253f},
	{0x84ba, 0x251d},
	{0x84bb, 0x2530},
	{0x84bc, 0x2525},
	{0x84bd, 0x2538},
	{0x84be, 0x2542},
	{0x8740, 0x2460},
	{0x8741, 0x2461},
	{0x8742, 0x2462},
	{0x8743, 0x2463},
	{0x8744, 0x2464},
	{0x8745, 0x2465},
	{0x8746, 0x2466},
	{0x8747, 0x2467},
	{0x8748, 0x2468},
	{0x8749, 0x2469},
	{0x874a, 0x246a},
	{0x874b, 0x246b},
	{0x874c, 0x246c},
	{0x874d, 0x246d},
	{0x874e, 0x246e},
	{0x874f, 0x246f},
	{0x8750, 0x2470},
	{0x8751, 0x2471},
	{0x8752, 0x2472},
	{0x8753, 0x2473},
	{0x8754, 0x2160},
	{0x8755, 0x2161},
	{0x8756, 0x2162},
	{0x8757, 0x2163},
	{0x8758, 0x2164},
	{0x8759, 0x2165},
	{0x875a, 0x2166},
	{0x875b, 0x2167},
	{0x875c, 0x2168},
	{0x875d, 0x2169},
	{0x875f, 0x3349},
	{0x8760, 0x3314},
	{0x8761, 0x3322},
	{0x8762, 0x334d},
	{0x8763, 0x3318},
	{0x8764, 0x3327},
	{0x8765, 0x3303},
	{0x8766, 0x3336},
	{0x8767, 0x3351},
	{0x8768, 0x3357},
	{0x8769, 0x330d},
	{0x876a, 0x3326},
	{0x876b, 0x3323},
	{0x876c, 0x332b},
	{0x876d, 0x334a},
	{0x876e, 0x333b},
	{0x876f, 0x339c},
	{0x8770, 0x339d},
	{0x8771, 0x339e},
	{0x8772, 0x338e},
	{0x8773, 0x338f},
	{0x8774, 0x33c4},
	{0x8775, 0x33a1},
	{0x877e, 0x337b},
	{0x8780, 0x301d},
	{0x8781, 0x301f},
	{0x8782, 0x2116},
	{0x8783, 0x33cd},
	{0x8784, 0x2121},
	{0x8785, 0x32a4},
	{0x8786, 0x32a5},
	{0x8787, 0x32a6},
	{0x8788, 0x32a7},
	{0x8789, 0x32a8},
	{0x878a, 0x3231},
	{0x878b, 0x3232},
	{0x878c, 0x3239},
	{0x878d, 0x337e},
	{0x878e, 0x337d},
	{0x878f, 0x337c},
	{0x8793, 0x222e},
	{0x8794, 0x2211},
	{0x8798, 0x221f},
	{0x8799, 0x22bf},
	{0x889f, 0x4e9c},
	{0x88a0, 0x5516},
	{0x88a1, 0x5a03},
	{0x88a2, 0x963f},
	{0x88a3, 0x54c0},
	{0x88a4, 0x611b},
	{0x88a5, 0x6328},
	{0x88a6, 0x59f6},
	{0x88a7, 0x9022},
	{0x88a8, 0x8475},
	{0x88a9, 0x831c},
	{0x88aa, 0x7a50},
	{0x88ab, 0x60aa},
	{0x88ac, 0x63e1},
	{0x88ad, 0x6e25},
	{0x88ae, 0x65ed},
	{0x88af, 0x8466},
	{0x88b0, 0x82a6},
	{0x88b1, 0x9bf5},
	{0x88b2, 0x6893},
	{0x88b3, 0x5727},
	{0x88b4, 0x65a1},
	{0x88b5, 0x6271},
	{0x88b6, 0x5b9b},
	{0x88b7, 0x59d0},
	{0x88b8, 0x867b},
	{0x88b9, 0x98f4},
	{0x88ba, 0x7d62},
	{0x88bb, 0x7dbe},
	{0x88bc, 0x9b8e},
	{0x88bd, 0x6216},
	{0x88be, 0x7c9f},
	{0x88bf, 0x88b7},
	{0x88c0, 0x5b89},
	{0x88c1, 0x5eb5},
	{0x88c2, 0x6309},
	{0x88c3, 0x6697},
	{0x88c4, 0x6848},
	{0x88c5, 0x95c7},
	{0x88c6, 0x978d},
	{0x88c7, 0x674f},
	{0x88c8, 0x4ee5},
	{0x88c9, 0x4f0a},
	{0x88ca, 0x4f4d},
	{0x88cb, 0x4f9d},
	{0x88cc, 0x5049},
	{0x88cd, 0x56f2},
	{0x88ce, 0x5937},
	{0x88cf, 0x59d4},
	{0x88d0, 0x5a01},
	{0x88d1, 0x5c09},
	{0x88d2, 0x60df},
	{0x88d3, 0x610f},
	{0x88d4, 0x6170},
	{0x88d5, 0x6613},
	{0x88d6, 0x6905},
	{0x88d7, 0x70ba},
	{0x88d8, 0x754f},
	{0x88d9, 0x7570},
	{0x88da, 0x79fb},
	{0x88db, 0x7dad},
	{0x88dc, 0x7def},
	{0x88dd, 0x80c3},
	{0x88de, 0x840e},
	{0x88df, 0x8863},
	{0x88e0, 0x8b02},
	{0x88e1, 0x9055},
	{0x88e2, 0x907a},
	{0x88e3, 0x533b},
	{0x88e4, 0x4e95},
	{0x88e5, 0x4ea5},
	{0x88e6, 0x57df},
	{0x88e7, 0x80b2},
	{0x88e8, 0x90c1},
	{0x88e9, 0x78ef},
	{0x88ea, 0x4e00},
	{0x88eb, 0x58f1},
	{0x88ec, 0x6ea2},
	{0x88ed, 0x9038},
	{0x88ee, 0x7a32},
	{0x88ef, 0x8328},
	{0x88f0, 0x828b},
	{0x88f1, 0x9c2f},
	{0x88f2, 0x5141},
	{0x88f3, 0x5370},
	{0x88f4, 0x54bd},
	{0x88f5, 0x54e1},
	{0x88f6, 0x56e0},
	{0x88f7, 0x59fb},
	{0x88f8, 0x5f15},
	{0x88f9, 0x98f2},
	{0x88fa, 0x6deb},
	{0x88fb, 0x80e4},
	{0x88fc, 0x852d},
	{0x8940, 0x9662},
	{0x8941, 0x9670},
	{0x8942, 0x96a0},
	{0x8943, 0x97fb},
	{0x8944, 0x540b},
	{0x8945, 0x53f3},
	{0x8946, 0x5b87},
	{0x8947, 0x70cf},
	{0x8948, 0x7fbd},
	{0x8949, 0x8fc2},
	{0x894a, 0x96e8},
	{0x894b, 0x536f},
	{0x894c, 0x9d5c},
	{0x894d, 0x7aba},
	{0x894e, 0x4e11},
	{0x894f, 0x7893},
	{0x8950, 0x81fc},
	{0x8951, 0x6e26},
	{0x8952, 0x5618},
	{0x8953, 0x5504},
	{0x8954, 0x6b1d},
	{0x8955, 0x851a},
	{0x8956, 0x9c3b},
	{0x8957, 0x59e5},
	{0x8958, 0x53a9},
	{0x8959, 0x6d66},
	{0x895a, 0x74dc},
	{0x895b, 0x958f},
	{0x895c, 0x5642},
	{0x895d, 0x4e91},
	{0x895e, 0x904b},
	{0x895f, 0x96f2},
	{0x8960, 0x834f},
	{0x8961, 0x990c},
	{0x8962, 0x53e1},
	{0x8963, 0x55b6},
	{0x8964, 0x5b30},
	{0x8965, 0x5f71},
	{0x8966, 0x6620},
	{0x8967, 0x66f3},
	{0x8968, 0x6804},
	{0x8969, 0x6c38},
	{0x896a, 0x6cf3},
	{0x896b, 0x6d29},
	{0x896c, 0x745b},
	{0x896d, 0x76c8},
	{0x896e, 0x7a4e},
	{0x896f, 0x9834},
	{0x8970, 0x82f1},
	{0x8971, 0x885b},
	{0x8972, 0x8a60},
	{0x8973, 0x92ed},
	{0x8974, 0x6db2},
	{0x8975, 0x75ab},
	{0x8976, 0x76ca},
	{0x8977, 0x99c5},
	{0x8978, 0x60a6},
	{0x8979, 0x8b01},
	{0x897a, 0x8d8a},
	{0x897b, 0x95b2},
	{0x897c, 0x698e},
	{0x897d, 0x53ad},
	{0x897e, 0x5186},
	{0x8980, 0x5712},
	{0x8981, 0x5830},
	{0x8982, 0x5944},
	{0x8983, 0x5bb4},
	{0x8984, 0x5ef6},
	{0x8985, 0x6028},
	{0x8986, 0x63a9},
	{0x8987, 0x63f4},
	{0x8988, 0x6cbf},
	{0x8989, 0x6f14},
	{0x898a, 0x708e},
	{0x898b, 0x7114},
	{0x898c, 0x7159},
	{0x898d, 0x71d5},
	{0x898e, 0x733f},
	{0x898f, 0x7e01},
	{0x8990, 0x8276},
	{0x8991, 0x82d1},
	{0x8992, 0x8597},
	{0x8993, 0x9060},
	{0x8994, 0x925b},
	{0x8995, 0x9d1b},
	{0x8996, 0x5869},
	{0x8997, 0x65bc},
	{0x8998, 0x6c5a},
	{0x8999, 0x7525},
	{0x899a, 0x51f9},
	{0x899b, 0x592e},
	{0x899c, 0x5965},
	{0x899d, 0x5f80},
	{0x899e, 0x5fdc},
	{0x899f, 0x62bc},
	{0x89a0, 0x65fa},
	{0x89a1, 0x6a2a},
	{0x89a2, 0x6b27},
	{0x89a3, 0x6bb4},
	{0x89a4, 0x738b},
	{0x89a5, 0x7fc1},
	{0x89a6, 0x8956},
	{0x89a7, 0x9d2c},
	{0x89a8, 0x9d0e},
	{0x89a9, 0x9ec4},
	{0x89aa, 0x5ca1},
	{0x89ab, 0x6c96},
	{0x89ac, 0x837b},
	{0x89ad, 0x5104},
	{0x89ae, 0x5c4b},
	{0x89af, 0x61b6},
	{0x89b0, 0x81c6},
	{0x89b1, 0x6876},
	{0x89b2, 0x7261},
	{0x89b3, 0x4e59},
	{0x89b4, 0x4ffa},
	{0x89b5, 0x5378},
	{0x89b6, 0x6069},
	{0x89b7, 0x6e29},
	{0x89b8, 0x7a4f},
	{0x89b9, 0x97f3},
	{0x89ba, 0x4e0b},
	{0x89bb, 0x5316},
	{0x89bc, 0x4eee},
	{0x89bd, 0x4f55},
	{0x89be, 0x4f3d},
	{0x89bf, 0x4fa1},
	{0x89c0, 0x4f73},
	{0x89c1, 0x52a0},
	{0x89c2, 0x53ef},
	{0x89c3, 0x5609},
	{0x89c4, 0x590f},
	{0x89c5, 0x5ac1},
	{0x89c6, 0x5bb6},
	{0x89c7, 0x5be1},
	{0x89c8, 0x79d1},
	{0x89c9, 0x6687},
	{0x89ca, 0x679c},
	{0x89cb, 0x67b6},
	{0x89cc, 0x6b4c},
	{0x89cd, 0x6cb3},
	{0x89ce, 0x706b},
	{0x89cf, 0x73c2},
	{0x89d0, 0x798d},
	{0x89d1, 0x79be},
	{0x89d2, 0x7a3c},
	{0x89d3, 0x7b87},
	{0x89d4, 0x82b1},
	{0x89d5, 0x82db},
	{0x89d6, 0x8304},
	{0x89d7, 0x8377},
	{0x89d8, 0x83ef},
	{0x89d9, 0x83d3},
	{0x89da, 0x8766},
	{0x89db, 0x8ab2},
	{0x89dc, 0x5629},
	{0x89dd, 0x8ca8},
	{0x89de, 0x8fe6},
	{0x89df, 0x904e},
	{0x89e0, 0x971e},
	{0x89e1, 0x868a},
	{0x89e2, 0x4fc4},
	{0x89e3, 0x5ce8},
	{0x89e4, 0x6211},
	{0x89e5, 0x7259},
	{0x89e6, 0x753b},
	{0x89e7, 0x81e5},
	{0x89e8, 0x82bd},
	{0x89e9, 0x86fe},
	{0x89ea, 0x8cc0},
	{0x89eb, 0x96c5},
	{0x89ec, 0x9913},
	{0x89ed, 0x99d5},
	{0x89ee, 0x4ecb},
	{0x89ef, 0x4f1a},
	{0x89f0, 0x89e3},
	{0x89f1, 0x56de},
	{0x89f2, 0x584a},
	{0x89f3, 0x58ca},
	{0x89f4, 0x5efb},
	{0x89f5, 0x5feb},
	{0x89f6, 0x602a},
	{0x89f7, 0x6094},
	{0x89f8, 0x6062},
	{0x89f9, 0x61d0},
	{0x89fa, 0x6212},
	{0x89fb, 0x62d0},
	{0x89fc, 0x6539},
	{0x8a40, 0x9b41},
	{0x8a41, 0x6666},
	{0x8a42, 0x68b0},
	{0x8a43, 0x6d77},
	{0x8a44, 0x7070},
	{0x8a45, 0x754c},
	{0x8a46, 0x7686},
	{0x8a47, 0x7d75},
	{0x8a48, 0x82a5},
	{0x8a49, 0x87f9},
	{0x8a4a, 0x958b},
	{0x8a4b, 0x968e},
	{0x8a4c, 0x8c9d},
	{0x8a4d, 0x51f1},
	{0x8a4e, 0x52be},
	{0x8a4f, 0x5916},
	{0x8a50, 0x54b3},
	{0x8a51, 0x5bb3},
	{0x8a52, 0x5d16},
	{0x8a53, 0x6168},
	{0x8a54, 0x6982},
	{0x8a55, 0x6daf},
	{0x8a56, 0x788d},
	{0x8a57, 0x84cb},
	{0x8a58, 0x8857},
	{0x8a59, 0x8a72},
	{0x8a5a, 0x93a7},
	{0x8a5b, 0x9ab8},
	{0x8a5c, 0x6d6c},
	{0x8a5d, 0x99a8},
	{0x8a5e, 0x86d9},
	{0x8a5f, 0x57a3},
	{0x8a60, 0x67ff},
	{0x8a61, 0x86ce},
	{0x8a62, 0x920e},
	{0x8a63, 0x5283},
	{0x8a64, 0x5687},
	{0x8a65, 0x5404},
	{0x8a66, 0x5ed3},
	{0x8a67, 0x62e1},
	{0x8a68, 0x64b9},
	{0x8a69, 0x683c},
	{0x8a6a, 0x6838},
	{0x8a6b, 0x6bbb},
	{0x8a6c, 0x7372},
	{0x8a6d, 0x78ba},
	{0x8a6e, 0x7a6b},
	{0x8a6f, 0x899a},
	{0x8a70, 0x89d2},
	{0x8a71, 0x8d6b},
	{0x8a72, 0x8f03},
	{0x8a73, 0x90ed},
	{0x8a74, 0x95a3},
	{0x8a75, 0x9694},
	{0x8a76, 0x9769},
	{0x8a77, 0x5b66},
	{0x8a78, 0x5cb3},
	{0x8a79, 0x697d},
	{0x8a7a, 0x984d},
	{0x8a7b, 0x984e},
	{0x8a7c, 0x639b},
	{0x8a7d, 0x7b20},
	{0x8a7e, 0x6a2b},
	{0x8a80, 0x6a7f},
	{0x8a81, 0x68b6},
	{0x8a82, 0x9c0d},
	{0x8a83, 0x6f5f},
	{0x8a84, 0x5272},
	{0x8a85, 0x559d},
	{0x8a86, 0x6070},
	{0x8a87, 0x62ec},
	{0x8a88, 0x6d3b},
	{0x8a89, 0x6e07},
	{0x8a8a, 0x6ed1},
	{0x8a8b, 0x845b},
	{0x8a8c, 0x8910},
	{0x8a8d, 0x8f44},
	{0x8a8e, 0x4e14},
	{0x8a8f, 0x9c39},
	{0x8a90, 0x53f6},
	{0x8a91, 0x691b},
	{0x8a92, 0x6a3a},
	{0x8a93, 0x9784},
	{0x8a94, 0x682a},
	{0x8a95, 0x515c},
	{0x8a96, 0x7ac3},
	{0x8a97, 0x84b2},
	{0x8a98, 0x91dc},
	{0x8a99, 0x938c},
	{0x8a9a, 0x565b},
	{0x8a9b, 0x9d28},
	{0x8a9c, 0x6822},
	{0x8a9d, 0x8305},
	{0x8a9e, 0x8431},
	{0x8a9f, 0x7ca5},
	{0x8aa0, 0x5208},
	{0x8aa1, 0x82c5},
	{0x8aa2, 0x74e6},
	{0x8aa3, 0x4e7e},
	{0x8aa4, 0x4f83},
	{0x8aa5, 0x51a0},
	{0x8aa6, 0x5bd2},
	{0x8aa7, 0x520a},
	{0x8aa8, 0x52d8},
	{0x8aa9, 0x52e7},
	{0x8aaa, 0x5dfb},
	{0x8aab, 0x559a},
	{0x8aac, 0x582a},
	{0x8aad, 0x59e6},
	{0x8aae, 0x5b8c},
	{0x8aaf, 0x5b98},
	{0x8ab0, 0x5bdb},
	{0x8ab1, 0x5e72},
	{0x8ab2, 0x5e79},
	{0x8ab3, 0x60a3},
	{0x8ab4, 0x611f},
	{0x8ab5, 0x6163},
	{0x8ab6, 0x61be},
	{0x8ab7, 0x63db},
	{0x8ab8, 0x6562},
	{0x8ab9, 0x67d1},
	{0x8aba, 0x6853},
	{0x8abb, 0x68fa},
	{0x8abc, 0x6b3e},
	{0x8abd, 0x6b53},
	{0x8abe, 0x6c57},
	{0x8abf, 0x6f22},
	{0x8ac0, 0x6f97},
	{0x8ac1, 0x6f45},
	{0x8ac2, 0x74b0},
	{0x8ac3, 0x7518},
	{0x8ac4, 0x76e3},
	{0x8ac5, 0x770b},
	{0x8ac6, 0x7aff},
	{0x8ac7, 0x7ba1},
	{0x8ac8, 0x7c21},
	{0x8ac9, 0x7de9},
	{0x8aca, 0x7f36},
	{0x8acb, 0x7ff0},
	{0x8acc, 0x809d},
	{0x8acd, 0x8266},
	{0x8ace, 0x839e},
	{0x8acf, 0x89b3},
	{0x8ad0, 0x8acc},
	{0x8ad1, 0x8cab},
	{0x8ad2, 0x9084},
	{0x8ad3, 0x9451},
	{0x8ad4, 0x9593},
	{0x8ad5, 0x9591},
	{0x8ad6, 0x95a2},
	{0x8ad7, 0x9665},
	{0x8ad8, 0x97d3},
	{0x8ad9, 0x9928},
	{0x8ada, 0x8218},
	{0x8adb, 0x4e38},
	{0x8adc, 0x542b},
	{0x8add, 0x5cb8},
	{0x8ade, 0x5dcc},
	{0x8adf, 0x73a9},
	{0x8ae0, 0x764c},
	{0x8ae1, 0x773c},
	{0x8ae2, 0x5ca9},
	{0x8ae3, 0x7feb},
	{0x8ae4, 0x8d0b},
	{0x8ae5, 0x96c1},
	{0x8ae6, 0x9811},
	{0x8ae7, 0x9854},
	{0x8ae8, 0x9858},
	{0x8ae9, 0x4f01},
	{0x8aea, 0x4f0e},
	{0x8aeb, 0x5371},
	{0x8aec, 0x559c},
	{0x8aed, 0x5668},
	{0x8aee, 0x57fa},
	{0x8aef, 0x5947},
	{0x8af0, 0x5b09},
	{0x8af1, 0x5bc4},
	{0x8af2, 0x5c90},
	{0x8af3, 0x5e0c},
	{0x8af4, 0x5e7e},
	{0x8af5, 0x5fcc},
	{0x8af6, 0x63ee},
	{0x8af7, 0x673a},
	{0x8af8, 0x65d7},
	{0x8af9, 0x65e2},
	{0x8afa, 0x671f},
	{0x8afb, 0x68cb},
	{0x8afc, 0x68c4},
	{0x8b40, 0x6a5f},
	{0x8b41, 0x5e30},
	{0x8b42, 0x6bc5},
	{0x8b43, 0x6c17},
	{0x8b44, 0x6c7d},
	{0x8b45, 0x757f},
	{0x8b46, 0x7948},
	{0x8b47, 0x5b63},
	{0x8b48, 0x7a00},
	{0x8b49, 0x7d00},
	{0x8b4a, 0x5fbd},
	{0x8b4b, 0x898f},
	{0x8b4c, 0x8a18},
	{0x8b4d, 0x8cb4},
	{0x8b4e, 0x8d77},
	{0x8b4f, 0x8ecc},
	{0x8b50, 0x8f1d},
	{0x8b51, 0x98e2},
	{0x8b52, 0x9a0e},
	{0x8b53, 0x9b3c},
	{0x8b54, 0x4e80},
	{0x8b55, 0x507d},
	{0x8b56, 0x5100},
	{0x8b57, 0x5993},
	{0x8b58, 0x5b9c},
	{0x8b59, 0x622f},
	{0x8b5a, 0x6280},
	{0x8b5b, 0x64ec},
	{0x8b5c, 0x6b3a},
	{0x8b5d, 0x72a0},
	{0x8b5e, 0x7591},
	{0x8b5f, 0x7947},
	{0x8b60, 0x7fa9},
	{0x8b61, 0x87fb},
	{0x8b62, 0x8abc},
	{0x8b63, 0x8b70},
	{0x8b64, 0x63ac},
	{0x8b65, 0x83ca},
	{0x8b66, 0x97a0},
	{0x8b67, 0x5409},
	{0x8b68, 0x5403},
	{0x8b69, 0x55ab},
	{0x8b6a, 0x6854},
	{0x8b6b, 0x6a58},
	{0x8b6c, 0x8a70},
	{0x8b6d, 0x7827},
	{0x8b6e, 0x6775},
	{0x8b6f, 0x9ecd},
	{0x8b70, 0x5374},
	{0x8b71, 0x5ba2},
	{0x8b72, 0x811a},
	{0x8b73, 0x8650},
	{0x8b74, 0x9006},
	{0x8b75, 0x4e18},
	{0x8b76, 0x4e45},
	{0x8b77, 0x4ec7},
	{0x8b78, 0x4f11},
	{0x8b79, 0x53ca},
	{0x8b7a, 0x5438},
	{0x8b7b, 0x5bae},
	{0x8b7c, 0x5f13},
	{0x8b7d, 0x6025},
	{0x8b7e, 0x6551},
	{0x8b80, 0x673d},
	{0x8b81, 0x6c42},
	{0x8b82, 0x6c72},
	{0x8b83, 0x6ce3},
	{0x8b84, 0x7078},
	{0x8b85, 0x7403},
	{0x8b86, 0x7a76},
	{0x8b87, 0x7aae},
	{0x8b88, 0x7b08},
	{0x8b89, 0x7d1a},
	{0x8b8a, 0x7cfe},
	{0x8b8b, 0x7d66},
	{0x8b8c, 0x65e7},
	{0x8b8d, 0x725b},
	{0x8b8e, 0x53bb},
	{0x8b8f, 0x5c45},
	{0x8b90, 0x5de8},
	{0x8b91, 0x62d2},
	{0x8b92, 0x62e0},
	{0x8b93, 0x6319},
	{0x8b94, 0x6e20},
	{0x8b95, 0x865a},
	{0x8b96, 0x8a31},
	{0x8b97, 0x8ddd},
	{0x8b98, 0x92f8},
	{0x8b99, 0x6f01},
	{0x8b9a, 0x79a6},
	{0x8b9b, 0x9b5a},
	{0x8b9c, 0x4ea8},
	{0x8b9d, 0x4eab},
	{0x8b9e, 0x4eac},
	{0x8b9f, 0x4f9b},
	{0x8ba0, 0x4fa0},
	{0x8ba1, 0x50d1},
	{0x8ba2, 0x5147},
	{0x8ba3, 0x7af6},
	{0x8ba4, 0x5171},
	{0x8ba5, 0x51f6},
	{0x8ba6, 0x5354},
	{0x8ba7, 0x5321},
	{0x8ba8, 0x537f},
	{0x8ba9, 0x53eb},
	{0x8baa, 0x55ac},
	{0x8bab, 0x5883},
	{0x8bac, 0x5ce1},
	{0x8bad, 0x5f37},
	{0x8bae, 0x5f4a},
	{0x8baf, 0x602f},
	{0x8bb0, 0x6050},
	{0x8bb1, 0x606d},
	{0x8bb2, 0x631f},
	{0x8bb3, 0x6559},
	{0x8bb4, 0x6a4b},
	{0x8bb5, 0x6cc1},
	{0x8bb6, 0x72c2},
	{0x8bb7, 0x72ed},
	{0x8bb8, 0x77ef},
	{0x8bb9, 0x80f8},
	{0x8bba, 0x8105},
	{0x8bbb, 0x8208},
	{0x8bbc, 0x854e},
	{0x8bbd, 0x90f7},
	{0x8bbe, 0x93e1},
	{0x8bbf, 0x97ff},
	{0x8bc0, 0x9957},
	{0x8bc1, 0x9a5a},
	{0x8bc2, 0x4ef0},
	{0x8bc3, 0x51dd},
	{0x8bc4, 0x5c2d},
	{0x8bc5, 0x6681},
	{0x8bc6, 0x696d},
	{0x8bc7, 0x5c40},
	{0x8bc8, 0x66f2},
	{0x8bc9, 0x6975},
	{0x8bca, 0x7389},
	{0x8bcb, 0x6850},
	{0x8bcc, 0x7c81},
	{0x8bcd, 0x50c5},
	{0x8bce, 0x52e4},
	{0x8bcf, 0x5747},
	{0x8bd0, 0x5dfe},
	{0x8bd1, 0x9326},
	{0x8bd2, 0x65a4},
	{0x8bd3, 0x6b23},
	{0x8bd4, 0x6b3d},
	{0x8bd5, 0x7434},
	{0x8bd6, 0x7981},
	{0x8bd7, 0x79bd},
	{0x8bd8, 0x7b4b},
	{0x8bd9, 0x7dca},
	{0x8bda, 0x82b9},
	{0x8bdb, 0x83cc},
	{0x8bdc, 0x887f},
	{0x8bdd, 0x895f},
	{0x8bde, 0x8b39},
	{0x8bdf, 0x8fd1},
	{0x8be0, 0x91d1},
	{0x8be1, 0x541f},
	{0x8be2, 0x9280},
	{0x8be3, 0x4e5d},
	{0x8be4, 0x5036},
	{0x8be5, 0x53e5},
	{0x8be6, 0x533a},
	{0x8be7, 0x72d7},
	{0x8be8, 0x7396},
	{0x8be9, 0x77e9},
	{0x8bea, 0x82e6},
	{0x8beb, 0x8eaf},
	{0x8bec, 0x99c6},
	{0x8bed, 0x99c8},
	{0x8bee, 0x99d2},
	{0x8bef, 0x5177},
	{0x8bf0, 0x611a},
	{0x8bf1, 0x865e},
	{0x8bf2, 0x55b0},
	{0x8bf3, 0x7a7a},
	{0x8bf4, 0x5076},
	{0x8bf5, 0x5bd3},
	{0x8bf6, 0x9047},
	{0x8bf7, 0x9685},
	{0x8bf8, 0x4e32},
	{0x8bf9, 0x6adb},
	{0x8bfa, 0x91e7},
	{0x8bfb, 0x5c51},
	{0x8bfc, 0x5c48},
	{0x8c40, 0x6398},
	{0x8c41, 0x7a9f},
	{0x8c42, 0x6c93},
	{0x8c43, 0x9774},
	{0x8c44, 0x8f61},
	{0x8c45, 0x7aaa},
	{0x8c46, 0x718a},
	{0x8c47, 0x9688},
	{0x8c48, 0x7c82},
	{0x8c49, 0x6817},
	{0x8c4a, 0x7e70},
	{0x8c4b, 0x6851},
	{0x8c4c, 0x936c},
	{0x8c4d, 0x52f2},
	{0x8c4e, 0x541b},
	{0x8c4f, 0x85ab},
	{0x8c50, 0x8a13},
	{0x8c51, 0x7fa4},
	{0x8c52, 0x8ecd},
	{0x8c53, 0x90e1},
	{0x8c54, 0x5366},
	{0x8c55, 0x8888},
	{0x8c56, 0x7941},
	{0x8c57, 0x4fc2},
	{0x8c58, 0x50be},
	{0x8c59, 0x5211},
	{0x8c5a, 0x5144},
	{0x8c5b, 0x5553},
	{0x8c5c, 0x572d},
	{0x8c5d, 0x73ea},
	{0x8c5e, 0x578b},
	{0x8c5f, 0x5951},
	{0x8c60, 0x5f62},
	{0x8c61, 0x5f84},
	{0x8c62, 0x6075},
	{0x8c63, 0x6176},
	{0x8c64, 0x6167},
	{0x8c65, 0x61a9},
	{0x8c66, 0x63b2},
	{0x8c67, 0x643a},
	{0x8c68, 0x656c},
	{0x8c69, 0x666f},
	{0x8c6a, 0x6842},
	{0x8c6b, 0x6e13},
	{0x8c6c, 0x7566},
	{0x8c6d, 0x7a3d},
	{0x8c6e, 0x7cfb},
	{0x8c6f, 0x7d4c},
	{0x8c70, 0x7d99},
	{0x8c71, 0x7e4b},
	{0x8c72, 0x7f6b},
	{0x8c73, 0x830e},
	{0x8c74, 0x834a},
	{0x8c75, 0x86cd},
	{0x8c76, 0x8a08},
	{0x8c77, 0x8a63},
	{0x8c78, 0x8b66},
	{0x8c79, 0x8efd},
	{0x8c7a, 0x981a},
	{0x8c7b, 0x9d8f},
	{0x8c7c, 0x82b8},
	{0x8c7d, 0x8fce},
	{0x8c7e, 0x9be8},
	{0x8c80, 0x5287},
	{0x8c81, 0x621f},
	{0x8c82, 0x6483},
	{0x8c83, 0x6fc0},
	{0x8c84, 0x9699},
	{0x8c85, 0x6841},
	{0x8c86, 0x5091},
	{0x8c87, 0x6b20},
	{0x8c88, 0x6c7a},
	{0x8c89, 0x6f54},
	{0x8c8a, 0x7a74},
	{0x8c8b, 0x7d50},
	{0x8c8c, 0x8840},
	{0x8c8d, 0x8a23},
	{0x8c8e, 0x6708},
	{0x8c8f, 0x4ef6},
	{0x8c90, 0x5039},
	{0x8c91, 0x5026},
	{0x8c92, 0x5065},
	{0x8c93, 0x517c},
	{0x8c94, 0x5238},
	{0x8c95, 0x5263},
	{0x8c96, 0x55a7},
	{0x8c97, 0x570f},
	{0x8c98, 0x5805},
	{0x8c99, 0x5acc},
	{0x8c9a, 0x5efa},
	{0x8c9b, 0x61b2},
	{0x8c9c, 0x61f8},
	{0x8c9d, 0x62f3},
	{0x8c9e, 0x6372},
	{0x8c9f, 0x691c},
	{0x8ca0, 0x6a29},
	{0x8ca1, 0x727d},
	{0x8ca2, 0x72ac},
	{0x8ca3, 0x732e},
	{0x8ca4, 0x7814},
	{0x8ca5, 0x786f},
	{0x8ca6, 0x7d79},
	{0x8ca7, 0x770c},
	{0x8ca8, 0x80a9},
	{0x8ca9, 0x898b},
	{0x8caa, 0x8b19},
	{0x8cab, 0x8ce2},
	{0x8cac, 0x8ed2},
	{0x8cad, 0x9063},
	{0x8cae, 0x9375},
	{0x8caf, 0x967a},
	{0x8cb0, 0x9855},
	{0x8cb1, 0x9a13},
	{0x8cb2, 0x9e78},
	{0x8cb3, 0x5143},
	{0x8cb4, 0x539f},
	{0x8cb5, 0x53b3},
	{0x8cb6, 0x5e7b},
	{0x8cb7, 0x5f26},
	{0x8cb8, 0x6e1b},
	{0x8cb9, 0x6e90},
	{0x8cba, 0x7384},
	{0x8cbb, 0x73fe},
	{0x8cbc, 0x7d43},
	{0x8cbd, 0x8237},
	{0x8cbe, 0x8a00},
	{0x8cbf, 0x8afa},
	{0x8cc0, 0x9650},
	{0x8cc1, 0x4e4e},
	{0x8cc2, 0x500b},
	{0x8cc3, 0x53e4},
	{0x8cc4, 0x547c},
	{0x8cc5, 0x56fa},
	{0x8cc6, 0x59d1},
	{0x8cc7, 0x5b64},
	{0x8cc8, 0x5df1},
	{0x8cc9, 0x5eab},
	{0x8cca, 0x5f27},
	{0x8ccb, 0x6238},
	{0x8ccc, 0x6545},
	{0x8ccd, 0x67af},
	{0x8cce, 0x6e56},
	{0x8ccf, 0x72d0},
	{0x8cd0, 0x7cca},
	{0x8cd1, 0x88b4},
	{0x8cd2, 0x80a1},
	{0x8cd3, 0x80e1},
	{0x8cd4, 0x83f0},
	{0x8cd5, 0x864e},
	{0x8cd6, 0x8a87},
	{0x8cd7, 0x8de8},
	{0x8cd8, 0x9237},
	{0x8cd9, 0x96c7},
	{0x8cda, 0x9867},
	{0x8cdb, 0x9f13},
	{0x8cdc, 0x4e94},
	{0x8cdd, 0x4e92},
	{0x8cde, 0x4f0d},
	{0x8cdf, 0x5348},
	{0x8ce0, 0x5449},
	{0x8ce1, 0x543e},
	{0x8ce2, 0x5a2f},
	{0x8ce3, 0x5f8c},
	{0x8ce4, 0x5fa1},
	{0x8ce5, 0x609f},
	{0x8ce6, 0x68a7},
	{0x8ce7, 0x6a8e},
	{0x8ce8, 0x745a},
	{0x8ce9, 0x7881},
	{0x8cea, 0x8a9e},
	{0x8ceb, 0x8aa4},
	{0x8cec, 0x8b77},
	{0x8ced, 0x9190},
	{0x8cee, 0x4e5e},
	{0x8cef, 0x9bc9},
	{0x8cf0, 0x4ea4},
	{0x8cf1, 0x4f7c},
	{0x8cf2, 0x4faf},
	{0x8cf3, 0x5019},
	{0x8cf4, 0x5016},
	{0x8cf5, 0x5149},
	{0x8cf6, 0x516c},
	{0x8cf7, 0x529f},
	{0x8cf8, 0x52b9},
	{0x8cf9, 0x52fe},
	{0x8cfa, 0x539a},
	{0x8cfb, 0x53e3},
	{0x8cfc, 0x5411},
	{0x8d40, 0x540e},
	{0x8d41, 0x5589},
	{0x8d42, 0x5751},
	{0x8d43, 0x57a2},
	{0x8d44, 0x597d},
	{0x8d45, 0x5b54},
	{0x8d46, 0x5b5d},
	{0x8d47, 0x5b8f},
	{0x8d48, 0x5de5},
	{0x8d49, 0x5de7},
	{0x8d4a, 0x5df7},
	{0x8d4b, 0x5e78},
	{0x8d4c, 0x5e83},
	{0x8d4d, 0x5e9a},
	{0x8d4e, 0x5eb7},
	{0x8d4f, 0x5f18},
	{0x8d50, 0x6052},
	{0x8d51, 0x614c},
	{0x8d52, 0x6297},
	{0x8d53, 0x62d8},
	{0x8d54, 0x63a7},
	{0x8d55, 0x653b},
	{0x8d56, 0x6602},
	{0x8d57, 0x6643},
	{0x8d58, 0x66f4},
	{0x8d59, 0x676d},
	{0x8d5a, 0x6821},
	{0x8d5b, 0x6897},
	{0x8d5c, 0x69cb},
	{0x8d5d, 0x6c5f},
	{0x8d5e, 0x6d2a},
	{0x8d5f, 0x6d69},
	{0x8d60, 0x6e2f},
	{0x8d61, 0x6e9d},
	{0x8d62, 0x7532},
	{0x8d63, 0x7687},
	{0x8d64, 0x786c},
	{0x8d65, 0x7a3f},
	{0x8d66, 0x7ce0},
	{0x8d67, 0x7d05},
	{0x8d68, 0x7d18},
	{0x8d69, 0x7d5e},
	{0x8d6a, 0x7db1},
	{0x8d6b, 0x8015},
	{0x8d6c, 0x8003},
	{0x8d6d, 0x80af},
	{0x8d6e, 0x80b1},
	{0x8d6f, 0x8154},
	{0x8d70, 0x818f},
	{0x8d71, 0x822a},
	{0x8d72, 0x8352},
	{0x8d73, 0x884c},
	{0x8d74, 0x8861},
	{0x8d75, 0x8b1b},
	{0x8d76, 0x8ca2},
	{0x8d77, 0x8cfc},
	{0x8d78, 0x90ca},
	{0x8d79, 0x9175},
	{0x8d7a, 0x9271},
	{0x8d7b, 0x783f},
	{0x8d7c, 0x92fc},
	{0x8d7d, 0x95a4},
	{0x8d7e, 0x964d},
	{0x8d80, 0x9805},
	{0x8d81, 0x9999},
	{0x8d82, 0x9ad8},
	{0x8d83, 0x9d3b},
	{0x8d84, 0x525b},
	{0x8d85, 0x52ab},
	{0x8d86, 0x53f7},
	{0x8d87, 0x5408},
	{0x8d88, 0x58d5},
	{0x8d89, 0x62f7},
	{0x8d8a, 0x6fe0},
	{0x8d8b, 0x8c6a},
	{0x8d8c, 0x8f5f},
	{0x8d8d, 0x9eb9},
	{0x8d8e, 0x514b},
	{0x8d8f, 0x523b},
	{0x8d90, 0x544a},
	{0x8d91, 0x56fd},
	{0x8d92, 0x7a40},
	{0x8d93, 0x9177},
	{0x8d94, 0x9d60},
	{0x8d95, 0x9ed2},
	{0x8d96, 0x7344},
	{0x8d97, 0x6f09},
	{0x8d98, 0x8170},
	{0x8d99, 0x7511},
	{0x8d9a, 0x5ffd},
	{0x8d9b, 0x60da},
	{0x8d9c, 0x9aa8},
	{0x8d9d, 0x72db},
	{0x8d9e, 0x8fbc},
	{0x8d9f, 0x6b64},
	{0x8da0, 0x9803},
	{0x8da1, 0x4eca},
	{0x8da2, 0x56f0},
	{0x8da3, 0x5764},
	{0x8da4, 0x58be},
	{0x8da5, 0x5a5a},
	{0x8da6, 0x6068},
	{0x8da7, 0x61c7},
	{0x8da8, 0x660f},
	{0x8da9, 0x6606},
	{0x8daa, 0x6839},
	{0x8dab, 0x68b1},
	{0x8dac, 0x6df7},
	{0x8dad, 0x75d5},
	{0x8dae, 0x7d3a},
	{0x8daf, 0x826e},
	{0x8db0, 0x9b42},
	{0x8db1, 0x4e9b},
	{0x8db2, 0x4f50},
	{0x8db3, 0x53c9},
	{0x8db4, 0x5506},
	{0x8db5, 0x5d6f},
	{0x8db6, 0x5de6},
	{0x8db7, 0x5dee},
	{0x8db8, 0x67fb},
	{0x8db9, 0x6c99},
	{0x8dba, 0x7473},
	{0x8dbb, 0x7802},
	{0x8dbc, 0x8a50},
	{0x8dbd, 0x9396},
	{0x8dbe, 0x88df},
	{0x8dbf, 0x5750},
	{0x8dc0, 0x5ea7},
	{0x8dc1, 0x632b},
	{0x8dc2, 0x50b5},
	{0x8dc3, 0x50ac},
	{0x8dc4, 0x518d},
	{0x8dc5, 0x6700},
	{0x8dc6, 0x54c9},
	{0x8dc7, 0x585e},
	{0x8dc8, 0x59bb},
	{0x8dc9, 0x5bb0},
	{0x8dca, 0x5f69},
	{0x8dcb, 0x624d},
	{0x8dcc, 0x63a1},
	{0x8dcd, 0x683d},
	{0x8dce, 0x6b73},
	{0x8dcf, 0x6e08},
	{0x8dd0, 0x707d},
	{0x8dd1, 0x91c7},
	{0x8dd2, 0x7280},
	{0x8dd3, 0x7815},
	{0x8dd4, 0x7826},
	{0x8dd5, 0x796d},
	{0x8dd6, 0x658e},
	{0x8dd7, 0x7d30},
	{0x8dd8, 0x83dc},
	{0x8dd9, 0x88c1},
	{0x8dda, 0x8f09},
	{0x8ddb, 0x969b},
	{0x8ddc, 0x5264},
	{0x8ddd, 0x5728},
	{0x8dde, 0x6750},
	{0x8ddf, 0x7f6a},
	{0x8de0, 0x8ca1},
	{0x8de1, 0x51b4},
	{0x8de2, 0x5742},
	{0x8de3, 0x962a},
	{0x8de4, 0x583a},
	{0x8de5, 0x698a},
	{0x8de6, 0x80b4},
	{0x8de7, 0x54b2},
	{0x8de8, 0x5d0e},
	{0x8de9, 0x57fc},
	{0x8dea, 0x7895},
	{0x8deb, 0x9dfa},
	{0x8dec, 0x4f5c},
	{0x8ded, 0x524a},
	{0x8dee, 0x548b},
	{0x8def, 0x643e},
	{0x8df0, 0x6628},
	{0x8df1, 0x6714},
	{0x8df2, 0x67f5},
	{0x8df3, 0x7a84},
	{0x8df4, 0x7b56},
	{0x8df5, 0x7d22},
	{0x8df6, 0x932f},
	{0x8df7, 0x685c},
	{0x8df8, 0x9bad},
	{0x8df9, 0x7b39},
	{0x8dfa, 0x5319},
	{0x8dfb, 0x518a},
	{0x8dfc, 0x5237},
	{0x8e40, 0x5bdf},
	{0x8e41, 0x62f6},
	{0x8e42, 0x64ae},
	{0x8e43, 0x64e6},
	{0x8e44, 0x672d},
	{0x8e45, 0x6bba},
	{0x8e46, 0x85a9},
	{0x8e47, 0x96d1},
	{0x8e48, 0x7690},
	{0x8e49, 0x9bd6},
	{0x8e4a, 0x634c},
	{0x8e4b, 0x9306},
	{0x8e4c, 0x9bab},
	{0x8e4d, 0x76bf},
	{0x8e4e, 0x6652},
	{0x8e4f, 0x4e09},
	{0x8e50, 0x5098},
	{0x8e51, 0x53c2},
	{0x8e52, 0x5c71},
	{0x8e53, 0x60e8},
	{0x8e54, 0x6492},
	{0x8e55, 0x6563},
	{0x8e56, 0x685f},
	{0x8e57, 0x71e6},
	{0x8e58, 0x73ca},
	{0x8e59, 0x7523},
	{0x8e5a, 0x7b97},
	{0x8e5b, 0x7e82},
	{0x8e5c, 0x8695},
	{0x8e5d, 0x8b83},
	{0x8e5e, 0x8cdb},
	{0x8e5f, 0x9178},
	{0x8e60, 0x9910},
	{0x8e61, 0x65ac},
	{0x8e62, 0x66ab},
	{0x8e63, 0x6b8b},
	{0x8e64, 0x4ed5},
	{0x8e65, 0x4ed4},
	{0x8e66, 0x4f3a},
	{0x8e67, 0x4f7f},
	{0x8e68, 0x523a},
	{0x8e69, 0x53f8},
	{0x8e6a, 0x53f2},
	{0x8e6b, 0x55e3},
	{0x8e6c, 0x56db},
	{0x8e6d, 0x58eb},
	{0x8e6e, 0x59cb},
	{0x8e6f, 0x59c9},
	{0x8e70, 0x59ff},
	{0x8e71, 0x5b50},
	{0x8e72, 0x5c4d},
	{0x8e73, 0x5e02},
	{0x8e74, 0x5e2b},
	{0x8e75, 0x5fd7},
	{0x8e76, 0x601d},
	{0x8e77, 0x6307},
	{0x8e78, 0x652f},
	{0x8e79, 0x5b5c},
	{0x8e7a, 0x65af},
	{0x8e7b, 0x65bd},
	{0x8e7c, 0x65e8},
	{0x8e7d, 0x679d},
	{0x8e7e, 0x6b62},
	{0x8e80, 0x6b7b},
	{0x8e81, 0x6c0f},
	{0x8e82, 0x7345},
	{0x8e83, 0x7949},
	{0x8e84, 0x79c1},
	{0x8e85, 0x7cf8},
	{0x8e86, 0x7d19},
	{0x8e87, 0x7d2b},
	{0x8e88, 0x80a2},
	{0x8e89, 0x8102},
	{0x8e8a, 0x81f3},
	{0x8e8b, 0x8996},
	{0x8e8c, 0x8a5e},
	{0x8e8d, 0x8a69},
	{0x8e8e, 0x8a66},
	{0x8e8f, 0x8a8c},
	{0x8e90, 0x8aee},
	{0x8e91, 0x8cc7},
	{0x8e92, 0x8cdc},
	{0x8e93, 0x96cc},
	{0x8e94, 0x98fc},
	{0x8e95, 0x6b6f},
	{0x8e96, 0x4e8b},
	{0x8e97, 0x4f3c},
	{0x8e98, 0x4f8d},
	{0x8e99, 0x5150},
	{0x8e9a, 0x5b57},
	{0x8e9b, 0x5bfa},
	{0x8e9c, 0x6148},
	{0x8e9d, 0x6301},
	{0x8e9e, 0x6642},
	{0x8e9f, 0x6b21},
	{0x8ea0, 0x6ecb},
	{0x8ea1, 0x6cbb},
	{0x8ea2, 0x723e},
	{0x8ea3, 0x74bd},
	{0x8ea4, 0x75d4},
	{0x8ea5, 0x78c1},
	{0x8ea6, 0x793a},
	{0x8ea7, 0x800c},
	{0x8ea8, 0x8033},
	{0x8ea9, 0x81ea},
	{0x8eaa, 0x8494},
	{0x8eab, 0x8f9e},
	{0x8eac, 0x6c50},
	{0x8ead, 0x9e7f},
	{0x8eae, 0x5f0f},
	{0x8eaf, 0x8b58},
	{0x8eb0, 0x9d2b},
	{0x8eb1, 0x7afa},
	{0x8eb2, 0x8ef8},
	{0x8eb3, 0x5b8d},
	{0x8eb4, 0x96eb},
	{0x8eb5, 0x4e03},
	{0x8eb6, 0x53f1},
	{0x8eb7, 0x57f7},
	{0x8eb8, 0x5931},
	{0x8eb9, 0x5ac9},
	{0x8eba, 0x5ba4},
	{0x8ebb, 0x6089},
	{0x8ebc, 0x6e7f},
	{0x8ebd, 0x6f06},
	{0x8ebe, 0x75be},
	{0x8ebf, 0x8cea},
	{0x8ec0, 0x5b9f},
	{0x8ec1, 0x8500},
	{0x8ec2, 0x7be0},
	{0x8ec3, 0x5072},
	{0x8ec4, 0x67f4},
	{0x8ec5, 0x829d},
	{0x8ec6, 0x5c61},
	{0x8ec7, 0x854a},
	{0x8ec8, 0x7e1e},
	{0x8ec9, 0x820e},
	{0x8eca, 0x5199},
	{0x8ecb, 0x5c04},
	{0x8ecc, 0x6368},
	{0x8ecd, 0x8d66},
	{0x8ece, 0x659c},
	{0x8ecf, 0x716e},
	{0x8ed0, 0x793e},
	{0x8ed1, 0x7d17},
	{0x8ed2, 0x8005},
	{0x8ed3, 0x8b1d},
	{0x8ed4, 0x8eca},
	{0x8ed5, 0x906e},
	{0x8ed6, 0x86c7},
	{0x8ed7, 0x90aa},
	{0x8ed8, 0x501f},
	{0x8ed9, 0x52fa},
	{0x8eda, 0x5c3a},
	{0x8edb, 0x6753},
	{0x8edc, 0x707c},
	{0x8edd, 0x7235},
	{0x8ede, 0x914c},
	{0x8edf, 0x91c8},
	{0x8ee0, 0x932b},
	{0x8ee1, 0x82e5},
	{0x8ee2, 0x5bc2},
	{0x8ee3, 0x5f31},
	{0x8ee4, 0x60f9},
	{0x8ee5, 0x4e3b},
	{0x8ee6, 0x53d6},
	{0x8ee7, 0x5b88},
	{0x8ee8, 0x624b},
	{0x8ee9, 0x6731},
	{0x8eea, 0x6b8a},
	{0x8eeb, 0x72e9},
	{0x8eec, 0x73e0},
	{0x8eed, 0x7a2e},
	{0x8eee, 0x816b},
	{0x8eef, 0x8da3},
	{0x8ef0, 0x9152},
	{0x8ef1, 0x9996},
	{0x8ef2, 0x5112},
	{0x8ef3, 0x53d7},
	{0x8ef4, 0x546a},
	{0x8ef5, 0x5bff},
	{0x8ef6, 0x6388},
	{0x8ef7, 0x6a39},
	{0x8ef8, 0x7dac},
	{0x8ef9, 0x9700},
	{0x8efa, 0x56da},
	{0x8efb, 0x53ce},
	{0x8efc, 0x5468},
	{0x8f40, 0x5b97},
	{0x8f41, 0x5c31},
	{0x8f42, 0x5dde},
	{0x8f43, 0x4fee},
	{0x8f44, 0x6101},
	{0x8f45, 0x62fe},
	{0x8f46, 0x6d32},
	{0x8f47, 0x79c0},
	{0x8f48, 0x79cb},
	{0x8f49, 0x7d42},
	{0x8f4a, 0x7e4d},
	{0x8f4b, 0x7fd2},
	{0x8f4c, 0x81ed},
	{0x8f4d, 0x821f},
	{0x8f4e, 0x8490},
	{0x8f4f, 0x8846},
	{0x8f50, 0x8972},
	{0x8f51, 0x8b90},
	{0x8f52, 0x8e74},
	{0x8f53, 0x8f2f},
	{0x8f54, 0x9031},
	{0x8f55, 0x914b},
	{0x8f56, 0x916c},
	{0x8f57, 0x96c6},
	{0x8f58, 0x919c},
	{0x8f59, 0x4ec0},
	{0x8f5a, 0x4f4f},
	{0x8f5b, 0x5145},
	{0x8f5c, 0x5341},
	{0x8f5d, 0x5f93},
	{0x8f5e, 0x620e},
	{0x8f5f, 0x67d4},
	{0x8f60, 0x6c41},
	{0x8f61, 0x6e0b},
	{0x8f62, 0x7363},
	{0x8f63, 0x7e26},
	{0x8f64, 0x91cd},
	{0x8f65, 0x9283},
	{0x8f66, 0x53d4},
	{0x8f67, 0x5919},
	{0x8f68, 0x5bbf},
	{0x8f69, 0x6dd1},
	{0x8f6a, 0x795d},
	{0x8f6b, 0x7e2e},
	{0x8f6c, 0x7c9b},
	{0x8f6d, 0x587e},
	{0x8f6e, 0x719f},
	{0x8f6f, 0x51fa},
	{0x8f70, 0x8853},
	{0x8f71, 0x8ff0},
	{0x8f72, 0x4fca},
	{0x8f73, 0x5cfb},
	{0x8f74, 0x6625},
	{0x8f75, 0x77ac},
	{0x8f76, 0x7ae3},
	{0x8f77, 0x821c},
	{0x8f78, 0x99ff},
	{0x8f79, 0x51c6},
	{0x8f7a, 0x5faa},
	{0x8f7b, 0x65ec},
	{0x8f7c, 0x696f},
	{0x8f7d, 0x6b89},
	{0x8f7e, 0x6df3},
	{0x8f80, 0x6e96},
	{0x8f81, 0x6f64},
	{0x8f82, 0x76fe},
	{0x8f83, 0x7d14},
	{0x8f84, 0x5de1},
	{0x8f85, 0x9075},
	{0x8f86, 0x9187},
	{0x8f87, 0x9806},
	{0x8f88, 0x51e6},
	{0x8f89, 0x521d},
	{0x8f8a, 0x6240},
	{0x8f8b, 0x6691},
	{0x8f8c, 0x66d9},
	{0x8f8d, 0x6e1a},
	{0x8f8e, 0x5eb6},
	{0x8f8f, 0x7dd2},
	{0x8f90, 0x7f72},
	{0x8f91, 0x66f8},
	{0x8f92, 0x85af},
	{0x8f93, 0x85f7},
	{0x8f94, 0x8af8},
	{0x8f95, 0x52a9},
	{0x8f96, 0x53d9},
	{0x8f97, 0x5973},
	{0x8f98, 0x5e8f},
	{0x8f99, 0x5f90},
	{0x8f9a, 0x6055},
	{0x8f9b, 0x92e4},
	{0x8f9c, 0x9664},
	{0x8f9d, 0x50b7},
	{0x8f9e, 0x511f},
	{0x8f9f, 0x52dd},
	{0x8fa0, 0x5320},
	{0x8fa1, 0x5347},
	{0x8fa2, 0x53ec},
	{0x8fa3, 0x54e8},
	{0x8fa4, 0x5546},
	{0x8fa5, 0x5531},
	{0x8fa6, 0x5617},
	{0x8fa7, 0x5968},
	{0x8fa8, 0x59be},
	{0x8fa9, 0x5a3c},
	{0x8faa, 0x5bb5},
	{0x8fab, 0x5c06},
	{0x8fac, 0x5c0f},
	{0x8fad, 0x5c11},
	{0x8fae, 0x5c1a},
	{0x8faf, 0x5e84},
	{0x8fb0, 0x5e8a},
	{0x8fb1, 0x5ee0},
	{0x8fb2, 0x5f70},
	{0x8fb3, 0x627f},
	{0x8fb4, 0x6284},
	{0x8fb5, 0x62db},
	{0x8fb6, 0x638c},
	{0x8fb7, 0x6377},
	{0x8fb8, 0x6607},
	{0x8fb9, 0x660c},
	{0x8fba, 0x662d},
	{0x8fbb, 0x6676},
	{0x8fbc, 0x677e},
	{0x8fbd, 0x68a2},
	{0x8fbe, 0x6a1f},
	{0x8fbf, 0x6a35},
	{0x8fc0, 0x6cbc},
	{0x8fc1, 0x6d88},
	{0x8fc2, 0x6e09},
	{0x8fc3, 0x6e58},
	{0x8fc4, 0x713c},
	{0x8fc5, 0x7126},
	{0x8fc6, 0x7167},
	{0x8fc7, 0x75c7},
	{0x8fc8, 0x7701},
	{0x8fc9, 0x785d},
	{0x8fca, 0x7901},
	{0x8fcb, 0x7965},
	{0x8fcc, 0x79f0},
	{0x8fcd, 0x7ae0},
	{0x8fce, 0x7b11},
	{0x8fcf, 0x7ca7},
	{0x8fd0, 0x7d39},
	{0x8fd1, 0x8096},
	{0x8fd2, 0x83d6},
	{0x8fd3, 0x848b},
	{0x8fd4, 0x8549},
	{0x8fd5, 0x885d},
	{0x8fd6, 0x88f3},
	{0x8fd7, 0x8a1f},
	{0x8fd8, 0x8a3c},
	{0x8fd9, 0x8a54},
	{0x8fda, 0x8a73},
	{0x8fdb, 0x8c61},
	{0x8fdc, 0x8cde},
	{0x8fdd, 0x91a4},
	{0x8fde, 0x9266},
	{0x8fdf, 0x937e},
	{0x8fe0, 0x9418},
	{0x8fe1, 0x969c},
	{0x8fe2, 0x9798},
	{0x8fe3, 0x4e0a},
	{0x8fe4, 0x4e08},
	{0x8fe5, 0x4e1e},
	{0x8fe6, 0x4e57},
	{0x8fe7, 0x5197},
	{0x8fe8, 0x5270},
	{0x8fe9, 0x57ce},
	{0x8fea, 0x5834},
	{0x8feb, 0x58cc},
	{0x8fec, 0x5b22},
	{0x8fed, 0x5e38},
	{0x8fee, 0x60c5},
	{0x8fef, 0x64fe},
	{0x8ff0, 0x6761},
	{0x8ff1, 0x6756},
	{0x8ff2, 0x6d44},
	{0x8ff3, 0x72b6},
	{0x8ff4, 0x7573},
	{0x8ff5, 0x7a63},
	{0x8ff6, 0x84b8},
	{0x8ff7, 0x8b72},
	{0x8ff8, 0x91b8},
	{0x8ff9, 0x9320},
	{0x8ffa, 0x5631},
	{0x8ffb, 0x57f4},
	{0x8ffc, 0x98fe},
	{0x9040, 0x62ed},
	{0x9041, 0x690d},
	{0x9042, 0x6b96},
	{0x9043, 0x71ed},
	{0x9044, 0x7e54},
	{0x9045, 0x8077},
	{0x9046, 0x8272},
	{0x9047, 0x89e6},
	{0x9048, 0x98df},
	{0x9049, 0x8755},
	{0x904a, 0x8fb1},
	{0x904b, 0x5c3b},
	{0x904c, 0x4f38},
	{0x904d, 0x4fe1},
	{0x904e, 0x4fb5},
	{0x904f, 0x5507},
	{0x9050, 0x5a20},
	{0x9051, 0x5bdd},
	{0x9052, 0x5be9},
	{0x9053, 0x5fc3},
	{0x9054, 0x614e},
	{0x9055, 0x632f},
	{0x9056, 0x65b0},
	{0x9057, 0x664b},
	{0x9058, 0x68ee},
	{0x9059, 0x699b},
	{0x905a, 0x6d78},
	{0x905b, 0x6df1},
	{0x905c, 0x7533},
	{0x905d, 0x75b9},
	{0x905e, 0x771f},
	{0x905f, 0x795e},
	{0x9060, 0x79e6},
	{0x9061, 0x7d33},
	{0x9062, 0x81e3},
	{0x9063, 0x82af},
	{0x9064, 0x85aa},
	{0x9065, 0x89aa},
	{0x9066, 0x8a3a},
	{0x9067, 0x8eab},
	{0x9068, 0x8f9b},
	{0x9069, 0x9032},
	{0x906a, 0x91dd},
	{0x906b, 0x9707},
	{0x906c, 0x4eba},
	{0x906d, 0x4ec1},
	{0x906e, 0x5203},
	{0x906f, 0x5875},
	{0x9070, 0x58ec},
	{0x9071, 0x5c0b},
	{0x9072, 0x751a},
	{0x9073, 0x5c3d},
	{0x9074, 0x814e},
	{0x9075, 0x8a0a},
	{0x9076, 0x8fc5},
	{0x9077, 0x9663},
	{0x9078, 0x976d},
	{0x9079, 0x7b25},
	{0x907a, 0x8acf},
	{0x907b, 0x9808},
	{0x907c, 0x9162},
	{0x907d, 0x56f3},
	{0x907e, 0x53a8},
	{0x9080, 0x9017},
	{0x9081, 0x5439},
	{0x9082, 0x5782},
	{0x9083, 0x5e25},
	{0x9084, 0x63a8},
	{0x9085, 0x6c34},
	{0x9086, 0x708a},
	{0x9087, 0x7761},
	{0x9088, 0x7c8b},
	{0x9089, 0x7fe0},
	{0x908a, 0x8870},
	{0x908b, 0x9042},
	{0x908c, 0x9154},
	{0x908d, 0x9310},
	{0x908e, 0x9318},
	{0x908f, 0x968f},
	{0x9090, 0x745e},
	{0x9091, 0x9ac4},
	{0x9092, 0x5d07},
	{0x9093, 0x5d69},
	{0x9094, 0x6570},
	{0x9095, 0x67a2},
	{0x9096, 0x8da8},
	{0x9097, 0x96db},
	{0x9098, 0x636e},
	{0x9099, 0x6749},
	{0x909a, 0x6919},
	{0x909b, 0x83c5},
	{0x909c, 0x9817},
	{0x909d, 0x96c0},
	{0x909e, 0x88fe},
	{0x909f, 0x6f84},
	{0x90a0, 0x647a},
	{0x90a1, 0x5bf8},
	{0x90a2, 0x4e16},
	{0x90a3, 0x702c},
	{0x90a4, 0x755d},
	{0x90a5, 0x662f},
	{0x90a6, 0x51c4},
	{0x90a7, 0x5236},
	{0x90a8, 0x52e2},
	{0x90a9, 0x59d3},
	{0x90aa, 0x5f81},
	{0x90ab, 0x6027},
	{0x90ac, 0x6210},
	{0x90ad, 0x653f},
	{0x90ae, 0x6574},
	{0x90af, 0x661f},
	{0x90b0, 0x6674},
	{0x90b1, 0x68f2},
	{0x90b2, 0x6816},
	{0x90b3, 0x6b63},
	{0x90b4, 0x6e05},
	{0x90b5, 0x7272},
	{0x90b6, 0x751f},
	{0x90b7, 0x76db},
	{0x90b8, 0x7cbe},
	{0x90b9, 0x8056},
	{0x90ba, 0x58f0},
	{0x90bb, 0x88fd},
	{0x90bc, 0x897f},
	{0x90bd, 0x8aa0},
	{0x90be, 0x8a93},
	{0x90bf, 0x8acb},
	{0x90c0, 0x901d},
	{0x90c1, 0x9192},
	{0x90c2, 0x9752},
	{0x90c3, 0x9759},
	{0x90c4, 0x6589},
	{0x90c5, 0x7a0e},
	{0x90c6, 0x8106},
	{0x90c7, 0x96bb},
	{0x90c8, 0x5e2d},
	{0x90c9, 0x60dc},
	{0x90ca, 0x621a},
	{0x90cb, 0x65a5},
	{0x90cc, 0x6614},
	{0x90cd, 0x6790},
	{0x90ce, 0x77f3},
	{0x90cf, 0x7a4d},
	{0x90d0, 0x7c4d},
	{0x90d1, 0x7e3e},
	{0x90d2, 0x810a},
	{0x90d3, 0x8cac},
	{0x90d4, 0x8d64},
	{0x90d5, 0x8de1},
	{0x90d6, 0x8e5f},
	{0x90d7, 0x78a9},
	{0x90d8, 0x5207},
	{0x90d9, 0x62d9},
	{0x90da, 0x63a5},
	{0x90db, 0x6442},
	{0x90dc, 0x6298},
	{0x90dd, 0x8a2d},
	{0x90de, 0x7a83},
	{0x90df, 0x7bc0},
	{0x90e0, 0x8aac},
	{0x90e1, 0x96ea},
	{0x90e2, 0x7d76},
	{0x90e3, 0x820c},
	{0x90e4, 0x8749},
	{0x90e5, 0x4ed9},
	{0x90e6, 0x5148},
	{0x90e7, 0x5343},
	{0x90e8, 0x5360},
	{0x90e9, 0x5ba3},
	{0x90ea, 0x5c02},
	{0x90eb, 0x5c16},
	{0x90ec, 0x5ddd},
	{0x90ed, 0x6226},
	{0x90ee, 0x6247},
	{0x90ef, 0x64b0},
	{0x90f0, 0x6813},
	{0x90f1, 0x6834},
	{0x90f2, 0x6cc9},
	{0x90f3, 0x6d45},
	{0x90f4, 0x6d17},
	{0x90f5, 0x67d3},
	{0x90f6, 0x6f5c},
	{0x90f7, 0x714e},
	{0x90f8, 0x717d},
	{0x90f9, 0x65cb},
	{0x90fa, 0x7a7f},
	{0x90fb, 0x7bad},
	{0x90fc, 0x7dda},
	{0x9140, 0x7e4a},
	{0x9141, 0x7fa8},
	{0x9142, 0x817a},
	{0x9143, 0x821b},
	{0x9144, 0x8239},
	{0x9145, 0x85a6},
	{0x9146, 0x8a6e},
	{0x9147, 0x8cce},
	{0x9148, 0x8df5},
	{0x9149, 0x9078},
	{0x914a, 0x9077},
	{0x914b, 0x92ad},
	{0x914c, 0x9291},
	{0x914d, 0x9583},
	{0x914e, 0x9bae},
	{0x914f, 0x524d},
	{0x9150, 0x5584},
	{0x9151, 0x6f38},
	{0x9152, 0x7136},
	{0x9153, 0x5168},
	{0x9154, 0x7985},
	{0x9155, 0x7e55},
	{0x9156, 0x81b3},
	{0x9157, 0x7cce},
	{0x9158, 0x564c},
	{0x9159, 0x5851},
	{0x915a, 0x5ca8},
	{0x915b, 0x63aa},
	{0x915c, 0x66fe},
	{0x915d, 0x66fd},
	{0x915e, 0x695a},
	{0x915f, 0x72d9},
	{0x9160, 0x758f},
	{0x9161, 0x758e},
	{0x9162, 0x790e},
	{0x9163, 0x7956},
	{0x9164, 0x79df},
	{0x9165, 0x7c97},
	{0x9166, 0x7d20},
	{0x9167, 0x7d44},
	{0x9168, 0x8607},
	{0x9169, 0x8a34},
	{0x916a, 0x963b},
	{0x916b, 0x9061},
	{0x916c, 0x9f20},
	{0x916d, 0x50e7},
	{0x916e, 0x5275},
	{0x916f, 0x53cc},
	{0x9170, 0x53e2},
	{0x9171, 0x5009},
	{0x9172, 0x55aa},
	{0x9173, 0x58ee},
	{0x9174, 0x594f},
	{0x9175, 0x723d},
	{0x9176, 0x5b8b},
	{0x9177, 0x5c64},
	{0x9178, 0x531d},
	{0x9179, 0x60e3},
	{0x917a, 0x60f3},
	{0x917b, 0x635c},
	{0x917c, 0x6383},
	{0x917d, 0x633f},
	{0x917e, 0x63bb},
	{0x9180, 0x64cd},
	{0x9181, 0x65e9},
	{0x9182, 0x66f9},
	{0x9183, 0x5de3},
	{0x9184, 0x69cd},
	{0x9185, 0x69fd},
	{0x9186, 0x6f15},
	{0x9187, 0x71e5},
	{0x9188, 0x4e89},
	{0x9189, 0x75e9},
	{0x918a, 0x76f8},
	{0x918b, 0x7a93},
	{0x918c, 0x7cdf},
	{0x918d, 0x7dcf},
	{0x918e, 0x7d9c},
	{0x918f, 0x8061},
	{0x9190, 0x8349},
	{0x9191, 0x8358},
	{0x9192, 0x846c},
	{0x9193, 0x84bc},
	{0x9194, 0x85fb},
	{0x9195, 0x88c5},
	{0x9196, 0x8d70},
	{0x9197, 0x9001},
	{0x9198, 0x906d},
	{0x9199, 0x9397},
	{0x919a, 0x971c},
	{0x919b, 0x9a12},
	{0x919c, 0x50cf},
	{0x919d, 0x5897},
	{0x919e, 0x618e},
	{0x919f, 0x81d3},
	{0x91a0, 0x8535},
	{0x91a1, 0x8d08},
	{0x91a2, 0x9020},
	{0x91a3, 0x4fc3},
	{0x91a4, 0x5074},
	{0x91a5, 0x5247},
	{0x91a6, 0x5373},
	{0x91a7, 0x606f},
	{0x91a8, 0x6349},
	{0x91a9, 0x675f},
	{0x91aa, 0x6e2c},
	{0x91ab, 0x8db3},
	{0x91ac, 0x901f},
	{0x91ad, 0x4fd7},
	{0x91ae, 0x5c5e},
	{0x91af, 0x8cca},
	{0x91b0, 0x65cf},
	{0x91b1, 0x7d9a},
	{0x91b2, 0x5352},
	{0x91b3, 0x8896},
	{0x91b4, 0x5176},
	{0x91b5, 0x63c3},
	{0x91b6, 0x5b58},
	{0x91b7, 0x5b6b},
	{0x91b8, 0x5c0a},
	{0x91b9, 0x640d},
	{0x91ba, 0x6751},
	{0x91bb, 0x905c},
	{0x91bc, 0x4ed6},
	{0x91bd, 0x591a},
	{0x91be, 0x592a},
	{0x91bf, 0x6c70},
	{0x91c0, 0x8a51},
	{0x91c1, 0x553e},
	{0x91c2, 0x5815},
	{0x91c3, 0x59a5},
	{0x91c4, 0x60f0},
	{0x91c5, 0x6253},
	{0x91c6, 0x67c1},
	{0x91c7, 0x8235},
	{0x91c8, 0x6955},
	{0x91c9, 0x9640},
	{0x91ca, 0x99c4},
	{0x91cb, 0x9a28},
	{0x91cc, 0x4f53},
	{0x91cd, 0x5806},
	{0x91ce, 0x5bfe},
	{0x91cf, 0x8010},
	{0x91d0, 0x5cb1},
	{0x91d1, 0x5e2f},
	{0x91d2, 0x5f85},
	{0x91d3, 0x6020},
	{0x91d4, 0x614b},
	{0x91d5, 0x6234},
	{0x91d6, 0x66ff},
	{0x91d7, 0x6cf0},
	{0x91d8, 0x6ede},
	{0x91d9, 0x80ce},
	{0x91da, 0x817f},
	{0x91db, 0x82d4},
	{0x91dc, 0x888b},
	{0x91dd, 0x8cb8},
	{0x91de, 0x9000},
	{0x91df, 0x902e},
	{0x91e0, 0x968a},
	{0x91e1, 0x9edb},
	{0x91e2, 0x9bdb},
	{0x91e3, 0x4ee3},
	{0x91e4, 0x53f0},
	{0x91e5, 0x5927},
	{0x91e6, 0x7b2c},
	{0x91e7, 0x918d},
	{0x91e8, 0x984c},
	{0x91e9, 0x9df9},
	{0x91ea, 0x6edd},
	{0x91eb, 0x7027},
	{0x91ec, 0x5353},
	{0x91ed, 0x5544},
	{0x91ee, 0x5b85},
	{0x91ef, 0x6258},
	{0x91f0, 0x629e},
	{0x91f1, 0x62d3},
	{0x91f2, 0x6ca2},
	{0x91f3, 0x6fef},
	{0x91f4, 0x7422},
	{0x91f5, 0x8a17},
	{0x91f6, 0x9438},
	{0x91f7, 0x6fc1},
	{0x91f8, 0x8afe},
	{0x91f9, 0x8338},
	{0x91fa, 0x51e7},
	{0x91fb, 0x86f8},
	{0x91fc, 0x53ea},
	{0x9240, 0x53e9},
	{0x9241, 0x4f46},
	{0x9242, 0x9054},
	{0x9243, 0x8fb0},
	{0x9244, 0x596a},
	{0x9245, 0x8131},
	{0x9246, 0x5dfd},
	{0x9247, 0x7aea},
	{0x9248, 0x8fbf},
	{0x9249, 0x68da},
	{0x924a, 0x8c37},
	{0x924b, 0x72f8},
	{0x924c, 0x9c48},
	{0x924d, 0x6a3d},
	{0x924e, 0x8ab0},
	{0x924f, 0x4e39},
	{0x9250, 0x5358},
	{0x9251, 0x5606},
	{0x9252, 0x5766},
	{0x9253, 0x62c5},
	{0x9254, 0x63a2},
	{0x9255, 0x65e6},
	{0x9256, 0x6b4e},
	{0x9257, 0x6de1},
	{0x9258, 0x6e5b},
	{0x9259, 0x70ad},
	{0x925a, 0x77ed},
	{0x925b, 0x7aef},
	{0x925c, 0x7baa},
	{0x925d, 0x7dbb},
	{0x925e, 0x803d},
	{0x925f, 0x80c6},
	{0x9260, 0x86cb},
	{0x9261, 0x8a95},
	{0x9262, 0x935b},
	{0x9263, 0x56e3},
	{0x9264, 0x58c7},
	{0x9265, 0x5f3e},
	{0x9266, 0x65ad},
	{0x9267, 0x6696},
	{0x9268, 0x6a80},
	{0x9269, 0x6bb5},
	{0x926a, 0x7537},
	{0x926b, 0x8ac7},
	{0x926c, 0x5024},
	{0x926d, 0x77e5},
	{0x926e, 0x5730},
	{0x926f, 0x5f1b},
	{0x9270, 0x6065},
	{0x9271, 0x667a},
	{0x9272, 0x6c60},
	{0x9273, 0x75f4},
	{0x9274, 0x7a1a},
	{0x9275, 0x7f6e},
	{0x9276, 0x81f4},
	{0x9277, 0x8718},
	{0x9278, 0x9045},
	{0x9279, 0x99b3},
	{0x927a, 0x7bc9},
	{0x927b, 0x755c},
	{0x927c, 0x7af9},
	{0x927d, 0x7b51},
	{0x927e, 0x84c4},
	{0x9280, 0x9010},
	{0x9281, 0x79e9},
	{0x9282, 0x7a92},
	{0x9283, 0x8336},
	{0x9284, 0x5ae1},
	{0x9285, 0x7740},
	{0x9286, 0x4e2d},
	{0x9287, 0x4ef2},
	{0x9288, 0x5b99},
	{0x9289, 0x5fe0},
	{0x928a, 0x62bd},
	{0x928b, 0x663c},
	{0x928c, 0x67f1},
	{0x928d, 0x6ce8},
	{0x928e, 0x866b},
	{0x928f, 0x8877},
	{0x9290, 0x8a3b},
	{0x9291, 0x914e},
	{0x9292, 0x92f3},
	{0x9293, 0x99d0},
	{0x9294, 0x6a17},
	{0x9295, 0x7026},
	{0x9296, 0x732a},
	{0x9297, 0x82e7},
	{0x9298, 0x8457},
	{0x9299, 0x8caf},
	{0x929a, 0x4e01},
	{0x929b, 0x5146},
	{0x929c, 0x51cb},
	{0x929d, 0x558b},
	{0x929e, 0x5bf5},
	{0x929f, 0x5e16},
	{0x92a0, 0x5e33},
	{0x92a1, 0x5e81},
	{0x92a2, 0x5f14},
	{0x92a3, 0x5f35},
	{0x92a4, 0x5f6b},
	{0x92a5, 0x5fb4},
	{0x92a6, 0x61f2},
	{0x92a7, 0x6311},
	{0x92a8, 0x66a2},
	{0x92a9, 0x671d},
	{0x92aa, 0x6f6e},
	{0x92ab, 0x7252},
	{0x92ac, 0x753a},
	{0x92ad, 0x773a},
	{0x92ae, 0x8074},
	{0x92af, 0x8139},
	{0x92b0, 0x8178},
	{0x92b1, 0x8776},
	{0x92b2, 0x8abf},
	{0x92b3, 0x8adc},
	{0x92b4, 0x8d85},
	{0x92b5, 0x8df3},
	{0x92b6, 0x929a},
	{0x92b7, 0x9577},
	{0x92b8, 0x9802},
	{0x92b9, 0x9ce5},
	{0x92ba, 0x52c5},
	{0x92bb, 0x6357},
	{0x92bc, 0x76f4},
	{0x92bd, 0x6715},
	{0x92be, 0x6c88},
	{0x92bf, 0x73cd},
	{0x92c0, 0x8cc3},
	{0x92c1, 0x93ae},
	{0x92c2, 0x9673},
	{0x92c3, 0x6d25},
	{0x92c4, 0x589c},
	{0x92c5, 0x690e},
	{0x92c6, 0x69cc},
	{0x92c7, 0x8ffd},
	{0x92c8, 0x939a},
	{0x92c9, 0x75db},
	{0x92ca, 0x901a},
	{0x92cb, 0x585a},
	{0x92cc, 0x6802},
	{0x92cd, 0x63b4},
	{0x92ce, 0x69fb},
	{0x92cf, 0x4f43},
	{0x92d0, 0x6f2c},
	{0x92d1, 0x67d8},
	{0x92d2, 0x8fbb},
	{0x92d3, 0x8526},
	{0x92d4, 0x7db4},
	{0x92d5, 0x9354},
	{0x92d6, 0x693f},
	{0x92d7, 0x6f70},
	{0x92d8, 0x576a},
	{0x92d9, 0x58f7},
	{0x92da, 0x5b2c},
	{0x92db, 0x7d2c},
	{0x92dc, 0x722a},
	{0x92dd, 0x540a},
	{0x92de, 0x91e3},
	{0x92df, 0x9db4},
	{0x92e0, 0x4ead},
	{0x92e1, 0x4f4e},
	{0x92e2, 0x505c},
	{0x92e3, 0x5075},
	{0x92e4, 0x5243},
	{0x92e5, 0x8c9e},
	{0x92e6, 0x5448},
	{0x92e7, 0x5824},
	{0x92e8, 0x5b9a},
	{0x92e9, 0x5e1d},
	{0x92ea, 0x5e95},
	{0x92eb, 0x5ead},
	{0x92ec, 0x5ef7},
	{0x92ed, 0x5f1f},
	{0x92ee, 0x608c},
	{0x92ef, 0x62b5},
	{0x92f0, 0x633a},
	{0x92f1, 0x63d0},
	{0x92f2, 0x68af},
	{0x92f3, 0x6c40},
	{0x92f4, 0x7887},
	{0x92f5, 0x798e},
	{0x92f6, 0x7a0b},
	{0x92f7, 0x7de0},
	{0x92f8, 0x8247},
	{0x92f9, 0x8a02},
	{0x92fa, 0x8ae6},
	{0x92fb, 0x8e44},
	{0x92fc, 0x9013},
	{0x9340, 0x90b8},
	{0x9341, 0x912d},
	{0x9342, 0x91d8},
	{0x9343, 0x9f0e},
	{0x9344, 0x6ce5},
	{0x9345, 0x6458},
	{0x9346, 0x64e2},
	{0x9347, 0x6575},
	{0x9348, 0x6ef4},
	{0x9349, 0x7684},
	{0x934a, 0x7b1b},
	{0x934b, 0x9069},
	{0x934c, 0x93d1},
	{0x934d, 0x6eba},
	{0x934e, 0x54f2},
	{0x934f, 0x5fb9},
	{0x9350, 0x64a4},
	{0x9351, 0x8f4d},
	{0x9352, 0x8fed},
	{0x9353, 0x9244},
	{0x9354, 0x5178},
	{0x9355, 0x586b},
	{0x9356, 0x5929},
	{0x9357, 0x5c55},
	{0x9358, 0x5e97},
	{0x9359, 0x6dfb},
	{0x935a, 0x7e8f},
	{0x935b, 0x751c},
	{0x935c, 0x8cbc},
	{0x935d, 0x8ee2},
	{0x935e, 0x985b},
	{0x935f, 0x70b9},
	{0x9360, 0x4f1d},
	{0x9361, 0x6bbf},
	{0x9362, 0x6fb1},
	{0x9363, 0x7530},
	{0x9364, 0x96fb},
	{0x9365, 0x514e},
	{0x9366, 0x5410},
	{0x9367, 0x5835},
	{0x9368, 0x5857},
	{0x9369, 0x59ac},
	{0x936a, 0x5c60},
	{0x936b, 0x5f92},
	{0x936c, 0x6597},
	{0x936d, 0x675c},
	{0x936e, 0x6e21},
	{0x936f, 0x767b},
	{0x9370, 0x83df},
	{0x9371, 0x8ced},
	{0x9372, 0x9014},
	{0x9373, 0x90fd},
	{0x9374, 0x934d},
	{0x9375, 0x7825},
	{0x9376, 0x783a},
	{0x9377, 0x52aa},
	{0x9378, 0x5ea6},
	{0x9379, 0x571f},
	{0x937a, 0x5974},
	{0x937b, 0x6012},
	{0x937c, 0x5012},
	{0x937d, 0x515a},
	{0x937e, 0x51ac},
	{0x9380, 0x51cd},
	{0x9381, 0x5200},
	{0x9382, 0x5510},
	{0x9383, 0x5854},
	{0x9384, 0x5858},
	{0x9385, 0x5957},
	{0x9386, 0x5b95},
	{0x9387, 0x5cf6},
	{0x9388, 0x5d8b},
	{0x9389, 0x60bc},
	{0x938a, 0x6295},
	{0x938b, 0x642d},
	{0x938c, 0x6771},
	{0x938d, 0x6843},
	{0x938e, 0x68bc},
	{0x938f, 0x68df},
	{0x9390, 0x76d7},
	{0x9391, 0x6dd8},
	{0x9392, 0x6e6f},
	{0x9393, 0x6d9b},
	{0x9394, 0x706f},
	{0x9395, 0x71c8},
	{0x9396, 0x5f53},
	{0x9397, 0x75d8},
	{0x9398, 0x7977},
	{0x9399, 0x7b49},
	{0x939a, 0x7b54},
	{0x939b, 0x7b52},
	{0x939c, 0x7cd6},
	{0x939d, 0x7d71},
	{0x939e, 0x5230},
	{0x939f, 0x8463},
	{0x93a0, 0x8569},
	{0x93a1, 0x85e4},
	{0x93a2, 0x8a0e},
	{0x93a3, 0x8b04},
	{0x93a4, 0x8c46},
	{0x93a5, 0x8e0f},
	{0x93a6, 0x9003},
	{0x93a7, 0x900f},
	{0x93a8, 0x9419},
	{0x93a9, 0x9676},
	{0x93aa, 0x982d},
	{0x93ab, 0x9a30},
	{0x93ac, 0x95d8},
	{0x93ad, 0x50cd},
	{0x93ae, 0x52d5},
	{0x93af, 0x540c},
	{0x93b0, 0x5802},
	{0x93b1, 0x5c0e},
	{0x93b2, 0x61a7},
	{0x93b3, 0x649e},
	{0x93b4, 0x6d1e},
	{0x93b5, 0x77b3},
	{0x93b6, 0x7ae5},
	{0x93b7, 0x80f4},
	{0x93b8, 0x8404},
	{0x93b9, 0x9053},
	{0x93ba, 0x9285},
	{0x93bb, 0x5ce0},
	{0x93bc, 0x9d07},
	{0x93bd, 0x533f},
	{0x93be, 0x5f97},
	{0x93bf, 0x5fb3},
	{0x93c0, 0x6d9c},
	{0x93c1, 0x7279},
	{0x93c2, 0x7763},
	{0x93c3, 0x79bf},
	{0x93c4, 0x7be4},
	{0x93c5, 0x6bd2},
	{0x93c6, 0x72ec},
	{0x93c7, 0x8aad},
	{0x93c8, 0x6803},
	{0x93c9, 0x6a61},
	{0x93ca, 0x51f8},
	{0x93cb, 0x7a81},
	{0x93cc, 0x6934},
	{0x93cd, 0x5c4a},
	{0x93ce, 0x9cf6},
	{0x93cf, 0x82eb},
	{0x93d0, 0x5bc5},
	{0x93d1, 0x9149},
	{0x93d2, 0x701e},
	{0x93d3, 0x5678},
	{0x93d4, 0x5c6f},
	{0x93d5, 0x60c7},
	{0x93d6, 0x6566},
	{0x93d7, 0x6c8c},
	{0x93d8, 0x8c5a},
	{0x93d9, 0x9041},
	{0x93da, 0x9813},
	{0x93db, 0x5451},
	{0x93dc, 0x66c7},
	{0x93dd, 0x920d},
	{0x93de, 0x5948},
	{0x93df, 0x90a3},
	{0x93e0, 0x5185},
	{0x93e1, 0x4e4d},
	{0x93e2, 0x51ea},
	{0x93e3, 0x8599},
	{0x93e4, 0x8b0e},
	{0x93e5, 0x7058},
	{0x93e6, 0x637a},
	{0x93e7, 0x934b},
	{0x93e8, 0x6962},
	{0x93e9, 0x99b4},
	{0x93ea, 0x7e04},
	{0x93eb, 0x7577},
	{0x93ec, 0x5357},
	{0x93ed, 0x6960},
	{0x93ee, 0x8edf},
	{0x93ef, 0x96e3},
	{0x93f0, 0x6c5d},
	{0x93f1, 0x4e8c},
	{0x93f2, 0x5c3c},
	{0x93f3, 0x5f10},
	{0x93f4, 0x8fe9},
	{0x93f5, 0x5302},
	{0x93f6, 0x8cd1},
	{0x93f7, 0x8089},
	{0x93f8, 0x8679},
	{0x93f9, 0x5eff},
	{0x93fa, 0x65e5},
	{0x93fb, 0x4e73},
	{0x93fc, 0x5165},
	{0x9440, 0x5982},
	{0x9441, 0x5c3f},
	{0x9442, 0x97ee},
	{0x9443, 0x4efb},
	{0x9444, 0x598a},
	{0x9445, 0x5fcd},
	{0x9446, 0x8a8d},
	{0x9447, 0x6fe1},
	{0x9448, 0x79b0},
	{0x9449, 0x7962},
	{0x944a, 0x5be7},
	{0x944b, 0x8471},
	{0x944c, 0x732b},
	{0x944d, 0x71b1},
	{0x944e, 0x5e74},
	{0x944f, 0x5ff5},
	{0x9450, 0x637b},
	{0x9451, 0x649a},
	{0x9452, 0x71c3},
	{0x9453, 0x7c98},
	{0x9454, 0x4e43},
	{0x9455, 0x5efc},
	{0x9456, 0x4e4b},
	{0x9457, 0x57dc},
	{0x9458, 0x56a2},
	{0x9459, 0x60a9},
	{0x945a, 0x6fc3},
	{0x945b, 0x7d0d},
	{0x945c, 0x80fd},
	{0x945d, 0x8133},
	{0x945e, 0x81bf},
	{0x945f, 0x8fb2},
	{0x9460, 0x8997},
	{0x9461, 0x86a4},
	{0x9462, 0x5df4},
	{0x9463, 0x628a},
	{0x9464, 0x64ad},
	{0x9465, 0x8987},
	{0x9466, 0x6777},
	{0x9467, 0x6ce2},
	{0x9468, 0x6d3e},
	{0x9469, 0x7436},
	{0x946a, 0x7834},
	{0x946b, 0x5a46},
	{0x946c, 0x7f75},
	{0x946d, 0x82ad},
	{0x946e, 0x99ac},
	{0x946f, 0x4ff3},
	{0x9470, 0x5ec3},
	{0x9471, 0x62dd},
	{0x9472, 0x6392},
	{0x9473, 0x6557},
	{0x9474, 0x676f},
	{0x9475, 0x76c3},
	{0x9476, 0x724c},
	{0x9477, 0x80cc},
	{0x9478, 0x80ba},
	{0x9479, 0x8f29},
	{0x947a, 0x914d},
	{0x947b, 0x500d},
	{0x947c, 0x57f9},
	{0x947d, 0x5a92},
	{0x947e, 0x6885},
	{0x9480, 0x6973},
	{0x9481, 0x7164},
	{0x9482, 0x72fd},
	{0x9483, 0x8cb7},
	{0x9484, 0x58f2},
	{0x9485, 0x8ce0},
	{0x9486, 0x966a},
	{0x9487, 0x9019},
	{0x9488, 0x877f},
	{0x9489, 0x79e4},
	{0x948a, 0x77e7},
	{0x948b, 0x8429},
	{0x948c, 0x4f2f},
	{0x948d, 0x5265},
	{0x948e, 0x535a},
	{0x948f, 0x62cd},
	{0x9490, 0x67cf},
	{0x9491, 0x6cca},
	{0x9492, 0x767d},
	{0x9493, 0x7b94},
	{0x9494, 0x7c95},
	{0x9495, 0x8236},
	{0x9496, 0x8584},
	{0x9497, 0x8feb},
	{0x9498, 0x66dd},
	{0x9499, 0x6f20},
	{0x949a, 0x7206},
	{0x949b, 0x7e1b},
	{0x949c, 0x83ab},
	{0x949d, 0x99c1},
	{0x949e, 0x9ea6},
	{0x949f, 0x51fd},
	{0x94a0, 0x7bb1},
	{0x94a1, 0x7872},
	{0x94a2, 0x7bb8},
	{0x94a3, 0x8087},
	{0x94a4, 0x7b48},
	{0x94a5, 0x6ae8},
	{0x94a6, 0x5e61},
	{0x94a7, 0x808c},
	{0x94a8, 0x7551},
	{0x94a9, 0x7560},
	{0x94aa, 0x516b},
	{0x94ab, 0x9262},
	{0x94ac, 0x6e8c},
	{0x94ad, 0x767a},
	{0x94ae, 0x9197},
	{0x94af, 0x9aea},
	{0x94b0, 0x4f10},
	{0x94b1, 0x7f70},
	{0x94b2, 0x629c},
	{0x94b3, 0x7b4f},
	{0x94b4, 0x95a5},
	{0x94b5, 0x9ce9},
	{0x94b6, 0x567a},
	{0x94b7, 0x5859},
	{0x94b8, 0x86e4},
	{0x94b9, 0x96bc},
	{0x94ba, 0x4f34},
	{0x94bb, 0x5224},
	{0x94bc, 0x534a},
	{0x94bd, 0x53cd},
	{0x94be, 0x53db},
	{0x94bf, 0x5e06},
	{0x94c0, 0x642c},
	{0x94c1, 0x6591},
	{0x94c2, 0x677f},
	{0x94c3, 0x6c3e},
	{0x94c4, 0x6c4e},
	{0x94c5, 0x7248},
	{0x94c6, 0x72af},
	{0x94c7, 0x73ed},
	{0x94c8, 0x7554},
	{0x94c9, 0x7e41},
	{0x94ca, 0x822c},
	{0x94cb, 0x85e9},
	{0x94cc, 0x8ca9},
	{0x94cd, 0x7bc4},
	{0x94ce, 0x91c6},
	{0x94cf, 0x7169},
	{0x94d0, 0x9812},
	{0x94d1, 0x98ef},
	{0x94d2, 0x633d},
	{0x94d3, 0x6669},
	{0x94d4, 0x756a},
	{0x94d5, 0x76e4},
	{0x94d6, 0x78d0},
	{0x94d7, 0x8543},
	{0x94d8, 0x86ee},
	{0x94d9, 0x532a},
	{0x94da, 0x5351},
	{0x94db, 0x5426},
	{0x94dc, 0x5983},
	{0x94dd, 0x5e87},
	{0x94de, 0x5f7c},
	{0x94df, 0x60b2},
	{0x94e0, 0x6249},
	{0x94e1, 0x6279},
	{0x94e2, 0x62ab},
	{0x94e3, 0x6590},
	{0x94e4, 0x6bd4},
	{0x94e5, 0x6ccc},
	{0x94e6, 0x75b2},
	{0x94e7, 0x76ae},
	{0x94e8, 0x7891},
	{0x94e9, 0x79d8},
	{0x94ea, 0x7dcb},
	{0x94eb, 0x7f77},
	{0x94ec, 0x80a5},
	{0x94ed, 0x88ab},
	{0x94ee, 0x8ab9},
	{0x94ef, 0x8cbb},
	{0x94f0, 0x907f},
	{0x94f1, 0x975e},
	{0x94f2, 0x98db},
	{0x94f3, 0x6a0b},
	{0x94f4, 0x7c38},
	{0x94f5, 0x5099},
	{0x94f6, 0x5c3e},
	{0x94f7, 0x5fae},
	{0x94f8, 0x6787},
	{0x94f9, 0x6bd8},
	{0x94fa, 0x7435},
	{0x94fb, 0x7709},
	{0x94fc, 0x7f8e},
	{0x9540, 0x9f3b},
	{0x9541, 0x67ca},
	{0x9542, 0x7a17},
	{0x9543, 0x5339},
	{0x9544, 0x758b},
	{0x9545, 0x9aed},
	{0x9546, 0x5f66},
	{0x9547, 0x819d},
	{0x9548, 0x83f1},
	{0x9549, 0x8098},
	{0x954a, 0x5f3c},
	{0x954b, 0x5fc5},
	{0x954c, 0x7562},
	{0x954d, 0x7b46},
	{0x954e, 0x903c},
	{0x954f, 0x6867},
	{0x9550, 0x59eb},
	{0x9551, 0x5a9b},
	{0x9552, 0x7d10},
	{0x9553, 0x767e},
	{0x9554, 0x8b2c},
	{0x9555, 0x4ff5},
	{0x9556, 0x5f6a},
	{0x9557, 0x6a19},
	{0x9558, 0x6c37},
	{0x9559, 0x6f02},
	{0x955a, 0x74e2},
	{0x955b, 0x7968},
	{0x955c, 0x8868},
	{0x955d, 0x8a55},
	{0x955e, 0x8c79},
	{0x955f, 0x5edf},
	{0x9560, 0x63cf},
	{0x9561, 0x75c5},
	{0x9562, 0x79d2},
	{0x9563, 0x82d7},
	{0x9564, 0x9328},
	{0x9565, 0x92f2},
	{0x9566, 0x849c},
	{0x9567, 0x86ed},
	{0x9568, 0x9c2d},
	{0x9569, 0x54c1},
	{0x956a, 0x5f6c},
	{0x956b, 0x658c},
	{0x956c, 0x6d5c},
	{0x956d, 0x7015},
	{0x956e, 0x8ca7},
	{0x956f, 0x8cd3},
	{0x9570, 0x983b},
	{0x9571, 0x654f},
	{0x9572, 0x74f6},
	{0x9573, 0x4e0d},
	{0x9574, 0x4ed8},
	{0x9575, 0x57e0},
	{0x9576, 0x592b},
	{0x9577, 0x5a66},
	{0x9578, 0x5bcc},
	{0x9579, 0x51a8},
	{0x957a, 0x5e03},
	{0x957b, 0x5e9c},
	{0x957c, 0x6016},
	{0x957d, 0x6276},
	{0x957e, 0x6577},
	{0x9580, 0x65a7},
	{0x9581, 0x666e},
	{0x9582, 0x6d6e},
	{0x9583, 0x7236},
	{0x9584, 0x7b26},
	{0x9585, 0x8150},
	{0x9586, 0x819a},
	{0x9587, 0x8299},
	{0x9588, 0x8b5c},
	{0x9589, 0x8ca0},
	{0x958a, 0x8ce6},
	{0x958b, 0x8d74},
	{0x958c, 0x961c},
	{0x958d, 0x9644},
	{0x958e, 0x4fae},
	{0x958f, 0x64ab},
	{0x9590, 0x6b66},
	{0x9591, 0x821e},
	{0x9592, 0x8461},
	{0x9593, 0x856a},
	{0x9594, 0x90e8},
	{0x9595, 0x5c01},
	{0x9596, 0x6953},
	{0x9597, 0x98a8},
	{0x9598, 0x847a},
	{0x9599, 0x8557},
	{0x959a, 0x4f0f},
	{0x959b, 0x526f},
	{0x959c, 0x5fa9},
	{0x959d, 0x5e45},
	{0x959e, 0x670d},
	{0x959f, 0x798f},
	{0x95a0, 0x8179},
	{0x95a1, 0x8907},
	{0x95a2, 0x8986},
	{0x95a3, 0x6df5},
	{0x95a4, 0x5f17},
	{0x95a5, 0x6255},
	{0x95a6, 0x6cb8},
	{0x95a7, 0x4ecf},
	{0x95a8, 0x7269},
	{0x95a9, 0x9b92},
	{0x95aa, 0x5206},
	{0x95ab, 0x543b},
	{0x95ac, 0x5674},
	{0x95ad, 0x58b3},
	{0x95ae, 0x61a4},
	{0x95af, 0x626e},
	{0x95b0, 0x711a},
	{0x95b1, 0x596e},
	{0x95b2, 0x7c89},
	{0x95b3, 0x7cde},
	{0x95b4, 0x7d1b},
	{0x95b5, 0x96f0},
	{0x95b6, 0x6587},
	{0x95b7, 0x805e},
	{0x95b8, 0x4e19},
	{0x95b9, 0x4f75},
	{0x95ba, 0x5175},
	{0x95bb, 0x5840},
	{0x95bc, 0x5e63},
	{0x95bd, 0x5e73},
	{0x95be, 0x5f0a},
	{0x95bf, 0x67c4},
	{0x95c0, 0x4e26},
	{0x95c1, 0x853d},
	{0x95c2, 0x9589},
	{0x95c3, 0x965b},
	{0x95c4, 0x7c73},
	{0x95c5, 0x9801},
	{0x95c6, 0x50fb},
	{0x95c7, 0x58c1},
	{0x95c8, 0x7656},
	{0x95c9, 0x78a7},
	{0x95ca, 0x5225},
	{0x95cb, 0x77a5},
	{0x95cc, 0x8511},
	{0x95cd, 0x7b86},
	{0x95ce, 0x504f},
	{0x95cf, 0x5909},
	{0x95d0, 0x7247},
	{0x95d1, 0x7bc7},
	{0x95d2, 0x7de8},
	{0x95d3, 0x8fba},
	{0x95d4, 0x8fd4},
	{0x95d5, 0x904d},
	{0x95d6, 0x4fbf},
	{0x95d7, 0x52c9},
	{0x95d8, 0x5a29},
	{0x95d9, 0x5f01},
	{0x95da, 0x97ad},
	{0x95db, 0x4fdd},
	{0x95dc, 0x8217},
	{0x95dd, 0x92ea},
	{0x95de, 0x5703},
	{0x95df, 0x6355},
	{0x95e0, 0x6b69},
	{0x95e1, 0x752b},
	{0x95e2, 0x88dc},
	{0x95e3, 0x8f14},
	{0x95e4, 0x7a42},
	{0x95e5, 0x52df},
	{0x95e6, 0x5893},
	{0x95e7, 0x6155},
	{0x95e8, 0x620a},
	{0x95e9, 0x66ae},
	{0x95ea, 0x6bcd},
	{0x95eb, 0x7c3f},
	{0x95ec, 0x83e9},
	{0x95ed, 0x5023},
	{0x95ee, 0x4ff8},
	{0x95ef, 0x5305},
	{0x95f0, 0x5446},
	{0x95f1, 0x5831},
	{0x95f2, 0x5949},
	{0x95f3, 0x5b9d},
	{0x95f4, 0x5cf0},
	{0x95f5, 0x5cef},
	{0x95f6, 0x5d29},
	{0x95f7, 0x5e96},
	{0x95f8, 0x62b1},
	{0x95f9, 0x6367},
	{0x95fa, 0x653e},
	{0x95fb, 0x65b9},
	{0x95fc, 0x670b},
	{0x9640, 0x6cd5},
	{0x9641, 0x6ce1},
	{0x9642, 0x70f9},
	{0x9643, 0x7832},
	{0x9644, 0x7e2b},
	{0x9645, 0x80de},
	{0x9646, 0x82b3},
	{0x9647, 0x840c},
	{0x9648, 0x84ec},
	{0x9649, 0x8702},
	{0x964a, 0x8912},
	{0x964b, 0x8a2a},
	{0x964c, 0x8c4a},
	{0x964d, 0x90a6},
	{0x964e, 0x92d2},
	{0x964f, 0x98fd},
	{0x9650, 0x9cf3},
	{0x9651, 0x9d6c},
	{0x9652, 0x4e4f},
	{0x9653, 0x4ea1},
	{0x9654, 0x508d},
	{0x9655, 0x5256},
	{0x9656, 0x574a},
	{0x9657, 0x59a8},
	{0x9658, 0x5e3d},
	{0x9659, 0x5fd8},
	{0x965a, 0x5fd9},
	{0x965b, 0x623f},
	{0x965c, 0x66b4},
	{0x965d, 0x671b},
	{0x965e, 0x67d0},
	{0x965f, 0x68d2},
	{0x9660, 0x5192},
	{0x9661, 0x7d21},
	{0x9662, 0x80aa},
	{0x9663, 0x81a8},
	{0x9664, 0x8b00},
	{0x9665, 0x8c8c},
	{0x9666, 0x8cbf},
	{0x9667, 0x927e},
	{0x9668, 0x9632},
	{0x9669, 0x5420},
	{0x966a, 0x982c},
	{0x966b, 0x5317},
	{0x966c, 0x50d5},
	{0x966d, 0x535c},
	{0x966e, 0x58a8},
	{0x966f, 0x64b2},
	{0x9670, 0x6734},
	{0x9671, 0x7267},
	{0x9672, 0x7766},
	{0x9673, 0x7a46},
	{0x9674, 0x91e6},
	{0x9675, 0x52c3},
	{0x9676, 0x6ca1},
	{0x9677, 0x6b86},
	{0x9678, 0x5800},
	{0x9679, 0x5e4c},
	{0x967a, 0x5954},
	{0x967b, 0x672c},
	{0x967c, 0x7ffb},
	{0x967d, 0x51e1},
	{0x967e, 0x76c6},
	{0x9680, 0x6469},
	{0x9681, 0x78e8},
	{0x9682, 0x9b54},
	{0x9683, 0x9ebb},
	{0x9684, 0x57cb},
	{0x9685, 0x59b9},
	{0x9686, 0x6627},
	{0x9687, 0x679a},
	{0x9688, 0x6bce},
	{0x9689, 0x54e9},
	{0x968a, 0x69d9},
	{0x968b, 0x5e55},
	{0x968c, 0x819c},
	{0x968d, 0x6795},
	{0x968e, 0x9baa},
	{0x968f, 0x67fe},
	{0x9690, 0x9c52},
	{0x9691, 0x685d},
	{0x9692, 0x4ea6},
	{0x9693, 0x4fe3},
	{0x9694, 0x53c8},
	{0x9695, 0x62b9},
	{0x9696, 0x672b},
	{0x9697, 0x6cab},
	{0x9698, 0x8fc4},
	{0x9699, 0x4fad},
	{0x969a, 0x7e6d},
	{0x969b, 0x9ebf},
	{0x969c, 0x4e07},
	{0x969d, 0x6162},
	{0x969e, 0x6e80},
	{0x969f, 0x6f2b},
	{0x96a0, 0x8513},
	{0x96a1, 0x5473},
	{0x96a2, 0x672a},
	{0x96a3, 0x9b45},
	{0x96a4, 0x5df3},
	{0x96a5, 0x7b95},
	{0x96a6, 0x5cac},
	{0x96a7, 0x5bc6},
	{0x96a8, 0x871c},
	{0x96a9, 0x6e4a},
	{0x96aa, 0x84d1},
	{0x96ab, 0x7a14},
	{0x96ac, 0x8108},
	{0x96ad, 0x5999},
	{0x96ae, 0x7c8d},
	{0x96af, 0x6c11},
	{0x96b0, 0x7720},
	{0x96b1, 0x52d9},
	{0x96b2, 0x5922},
	{0x96b3, 0x7121},
	{0x96b4, 0x725f},
	{0x96b5, 0x77db},
	{0x96b6, 0x9727},
	{0x96b7, 0x9d61},
	{0x96b8, 0x690b},
	{0x96b9, 0x5a7f},
	{0x96ba, 0x5a18},
	{0x96bb, 0x51a5},
	{0x96bc, 0x540d},
	{0x96bd, 0x547d},
	{0x96be, 0x660e},
	{0x96bf, 0x76df},
	{0x96c0, 0x8ff7},
	{0x96c1, 0x9298},
	{0x96c2, 0x9cf4},
	{0x96c3, 0x59ea},
	{0x96c4, 0x725d},
	{0x96c5, 0x6ec5},
	{0x96c6, 0x514d},
	{0x96c7, 0x68c9},
	{0x96c8, 0x7dbf},
	{0x96c9, 0x7dec},
	{0x96ca, 0x9762},
	{0x96cb, 0x9eba},
	{0x96cc, 0x6478},
	{0x96cd, 0x6a21},
	{0x96ce, 0x8302},
	{0x96cf, 0x5984},
	{0x96d0, 0x5b5f},
	{0x96d1, 0x6bdb},
	{0x96d2, 0x731b},
	{0x96d3, 0x76f2},
	{0x96d4, 0x7db2},
	{0x96d5, 0x8017},
	{0x96d6, 0x8499},
	{0x96d7, 0x5132},
	{0x96d8, 0x6728},
	{0x96d9, 0x9ed9},
	{0x96da, 0x76ee},
	{0x96db, 0x6762},
	{0x96dc, 0x52ff},
	{0x96dd, 0x9905},
	{0x96de, 0x5c24},
	{0x96df, 0x623b},
	{0x96e0, 0x7c7e},
	{0x96e1, 0x8cb0},
	{0x96e2, 0x554f},
	{0x96e3, 0x60b6},
	{0x96e4, 0x7d0b},
	{0x96e5, 0x9580},
	{0x96e6, 0x5301},
	{0x96e7, 0x4e5f},
	{0x96e8, 0x51b6},
	{0x96e9, 0x591c},
	{0x96ea, 0x723a},
	{0x96eb, 0x8036},
	{0x96ec, 0x91ce},
	{0x96ed, 0x5f25},
	{0x96ee, 0x77e2},
	{0x96ef, 0x5384},
	{0x96f0, 0x5f79},
	{0x96f1, 0x7d04},
	{0x96f2, 0x85ac},
	{0x96f3, 0x8a33},
	{0x96f4, 0x8e8d},
	{0x96f5, 0x9756},
	{0x96f6, 0x67f3},
	{0x96f7, 0x85ae},
	{0x96f8, 0x9453},
	{0x96f9, 0x6109},
	{0x96fa, 0x6108},
	{0x96fb, 0x6cb9},
	{0x96fc, 0x7652},
	{0x9740, 0x8aed},
	{0x9741, 0x8f38},
	{0x9742, 0x552f},
	{0x9743, 0x4f51},
	{0x9744, 0x512a},
	{0x9745, 0x52c7},
	{0x9746, 0x53cb},
	{0x9747, 0x5ba5},
	{0x9748, 0x5e7d},
	{0x9749, 0x60a0},
	{0x974a, 0x6182},
	{0x974b, 0x63d6},
	{0x974c, 0x6709},
	{0x974d, 0x67da},
	{0x974e, 0x6e67},
	{0x974f, 0x6d8c},
	{0x9750, 0x7336},
	{0x9751, 0x7337},
	{0x9752, 0x7531},
	{0x9753, 0x7950},
	{0x9754, 0x88d5},
	{0x9755, 0x8a98},
	{0x9756, 0x904a},
	{0x9757, 0x9091},
	{0x9758, 0x90f5},
	{0x9759, 0x96c4},
	{0x975a, 0x878d},
	{0x975b, 0x5915},
	{0x975c, 0x4e88},
	{0x975d, 0x4f59},
	{0x975e, 0x4e0e},
	{0x975f, 0x8a89},
	{0x9760, 0x8f3f},
	{0x9761, 0x9810},
	{0x9762, 0x50ad},
	{0x9763, 0x5e7c},
	{0x9764, 0x5996},
	{0x9765, 0x5bb9},
	{0x9766, 0x5eb8},
	{0x9767, 0x63da},
	{0x9768, 0x63fa},
	{0x9769, 0x64c1},
	{0x976a, 0x66dc},
	{0x976b, 0x694a},
	{0x976c, 0x69d8},
	{0x976d, 0x6d0b},
	{0x976e, 0x6eb6},
	{0x976f, 0x7194},
	{0x9770, 0x7528},
	{0x9771, 0x7aaf},
	{0x9772, 0x7f8a},
	{0x9773, 0x8000},
	{0x9774, 0x8449},
	{0x9775, 0x84c9},
	{0x9776, 0x8981},
	{0x9777, 0x8b21},
	{0x9778, 0x8e0a},
	{0x9779, 0x9065},
	{0x977a, 0x967d},
	{0x977b, 0x990a},
	{0x977c, 0x617e},
	{0x977d, 0x6291},
	{0x977e, 0x6b32},
	{0x9780, 0x6c83},
	{0x9781, 0x6d74},
	{0x9782, 0x7fcc},
	{0x9783, 0x7ffc},
	{0x9784, 0x6dc0},
	{0x9785, 0x7f85},
	{0x9786, 0x87ba},
	{0x9787, 0x88f8},
	{0x9788, 0x6765},
	{0x9789, 0x83b1},
	{0x978a, 0x983c},
	{0x978b, 0x96f7},
	{0x978c, 0x6d1b},
	{0x978d, 0x7d61},
	{0x978e, 0x843d},
	{0x978f, 0x916a},
	{0x9790, 0x4e71},
	{0x9791, 0x5375},
	{0x9792, 0x5d50},
	{0x9793, 0x6b04},
	{0x9794, 0x6feb},
	{0x9795, 0x85cd},
	{0x9796, 0x862d},
	{0x9797, 0x89a7},
	{0x9798, 0x5229},
	{0x9799, 0x540f},
	{0x979a, 0x5c65},
	{0x979b, 0x674e},
	{0x979c, 0x68a8},
	{0x979d, 0x7406},
	{0x979e, 0x7483},
	{0x979f, 0x75e2},
	{0x97a0, 0x88cf},
	{0x97a1, 0x88e1},
	{0x97a2, 0x91cc},
	{0x97a3, 0x96e2},
	{0x97a4, 0x9678},
	{0x97a5, 0x5f8b},
	{0x97a6, 0x7387},
	{0x97a7, 0x7acb},
	{0x97a8, 0x844e},
	{0x97a9, 0x63a0},
	{0x97aa, 0x7565},
	{0x97ab, 0x5289},
	{0x97ac, 0x6d41},
	{0x97ad, 0x6e9c},
	{0x97ae, 0x7409},
	{0x97af, 0x7559},
	{0x97b0, 0x786b},
	{0x97b1, 0x7c92},
	{0x97b2, 0x9686},
	{0x97b3, 0x7adc},
	{0x97b4, 0x9f8d},
	{0x97b5, 0x4fb6},
	{0x97b6, 0x616e},
	{0x97b7, 0x65c5},
	{0x97b8, 0x865c},
	{0x97b9, 0x4e86},
	{0x97ba, 0x4eae},
	{0x97bb, 0x50da},
	{0x97bc, 0x4e21},
	{0x97bd, 0x51cc},
	{0x97be, 0x5bee},
	{0x97bf, 0x6599},
	{0x97c0, 0x6881},
	{0x97c1, 0x6dbc},
	{0x97c2, 0x731f},
	{0x97c3, 0x7642},
	{0x97c4, 0x77ad},
	{0x97c5, 0x7a1c},
	{0x97c6, 0x7ce7},
	{0x97c7, 0x826f},
	{0x97c8, 0x8ad2},
	{0x97c9, 0x907c},
	{0x97ca, 0x91cf},
	{0x97cb, 0x9675},
	{0x97cc, 0x9818},
	{0x97cd, 0x529b},
	{0x97ce, 0x7dd1},
	{0x97cf, 0x502b},
	{0x97d0, 0x5398},
	{0x97d1, 0x6797},
	{0x97d2, 0x6dcb},
	{0x97d3, 0x71d0},
	{0x97d4, 0x7433},
	{0x97d5, 0x81e8},
	{0x97d6, 0x8f2a},
	{0x97d7, 0x96a3},
	{0x97d8, 0x9c57},
	{0x97d9, 0x9e9f},
	{0x97da, 0x7460},
	{0x97db, 0x5841},
	{0x97dc, 0x6d99},
	{0x97dd, 0x7d2f},
	{0x97de, 0x985e},
	{0x97df, 0x4ee4},
	{0x97e0, 0x4f36},
	{0x97e1, 0x4f8b},
	{0x97e2, 0x51b7},
	{0x97e3, 0x52b1},
	{0x97e4, 0x5dba},
	{0x97e5, 0x601c},
	{0x97e6, 0x73b2},
	{0x97e7, 0x793c},
	{0x97e8, 0x82d3},
	{0x97e9, 0x9234},
	{0x97ea, 0x96b7},
	{0x97eb, 0x96f6},
	{0x97ec, 0x970a},
	{0x97ed, 0x9e97},
	{0x97ee, 0x9f62},
	{0x97ef, 0x66a6},
	{0x97f0, 0x6b74},
	{0x97f1, 0x5217},
	{0x97f2, 0x52a3},
	{0x97f3, 0x70c8},
	{0x97f4, 0x88c2},
	{0x97f5, 0x5ec9},
	{0x97f6, 0x604b},
	{0x97f7, 0x6190},
	{0x97f8, 0x6f23},
	{0x97f9, 0x7149},
	{0x97fa, 0x7c3e},
	{0x97fb, 0x7df4},
	{0x97fc, 0x806f},
	{0x9840, 0x84ee},
	{0x9841, 0x9023},
	{0x9842, 0x932c},
	{0x9843, 0x5442},
	{0x9844, 0x9b6f},
	{0x9845, 0x6ad3},
	{0x9846, 0x7089},
	{0x9847, 0x8cc2},
	{0x9848, 0x8def},
	{0x9849, 0x9732},
	{0x984a, 0x52b4},
	{0x984b, 0x5a41},
	{0x984c, 0x5eca},
	{0x984d, 0x5f04},
	{0x984e, 0x6717},
	{0x984f, 0x697c},
	{0x9850, 0x6994},
	{0x9851, 0x6d6a},
	{0x9852, 0x6f0f},
	{0x9853, 0x7262},
	{0x9854, 0x72fc},
	{0x9855, 0x7bed},
	{0x9856, 0x8001},
	{0x9857, 0x807e},
	{0x9858, 0x874b},
	{0x9859, 0x90ce},
	{0x985a, 0x516d},
	{0x985b, 0x9e93},
	{0x985c, 0x7984},
	{0x985d, 0x808b},
	{0x985e, 0x9332},
	{0x985f, 0x8ad6},
	{0x9860, 0x502d},
	{0x9861, 0x548c},
	{0x9862, 0x8a71},
	{0x9863, 0x6b6a},
	{0x9864, 0x8cc4},
	{0x9865, 0x8107},
	{0x9866, 0x60d1},
	{0x9867, 0x67a0},
	{0x9868, 0x9df2},
	{0x9869, 0x4e99},
	{0x986a, 0x4e98},
	{0x986b, 0x9c10},
	{0x986c, 0x8a6b},
	{0x986d, 0x85c1},
	{0x986e, 0x8568},
	{0x986f, 0x6900},
	{0x9870, 0x6e7e},
	{0x9871, 0x7897},
	{0x9872, 0x8155},
	{0x989f, 0x5f0c},
	{0x98a0, 0x4e10},
	{0x98a1, 0x4e15},
	{0x98a2, 0x4e2a},
	{0x98a3, 0x4e31},
	{0x98a4, 0x4e36},
	{0x98a5, 0x4e3c},
	{0x98a6, 0x4e3f},
	{0x98a7, 0x4e42},
	{0x98a8, 0x4e56},
	{0x98a9, 0x4e58},
	{0x98aa, 0x4e82},
	{0x98ab, 0x4e85},
	{0x98ac, 0x8c6b},
	{0x98ad, 0x4e8a},
	{0x98ae, 0x8212},
	{0x98af, 0x5f0d},
	{0x98b0, 0x4e8e},
	{0x98b1, 0x4e9e},
	{0x98b2, 0x4e9f},
	{0x98b3, 0x4ea0},
	{0x98b4, 0x4ea2},
	{0x98b5, 0x4eb0},
	{0x98b6, 0x4eb3},
	{0x98b7, 0x4eb6},
	{0x98b8, 0x4ece},
	{0x98b9, 0x4ecd},
	{0x98ba, 0x4ec4},
	{0x98bb, 0x4ec6},
	{0x98bc, 0x4ec2},
	{0x98bd, 0x4ed7},
	{0x98be, 0x4ede},
	{0x98bf, 0x4eed},
	{0x98c0, 0x4edf},
	{0x98c1, 0x4ef7},
	{0x98c2, 0x4f09},
	{0x98c3, 0x4f5a},
	{0x98c4, 0x4f30},
	{0x98c5, 0x4f5b},
	{0x98c6, 0x4f5d},
	{0x98c7, 0x4f57},
	{0x98c8, 0x4f47},
	{0x98c9, 0x4f76},
	{0x98ca, 0x4f88},
	{0x98cb, 0x4f8f},
	{0x98cc, 0x4f98},
	{0x98cd, 0x4f7b},
	{0x98ce, 0x4f69},
	{0x98cf, 0x4f70},
	{0x98d0, 0x4f91},
	{0x98d1, 0x4f6f},
	{0x98d2, 0x4f86},
	{0x98d3, 0x4f96},
	{0x98d4, 0x5118},
	{0x98d5, 0x4fd4},
	{0x98d6, 0x4fdf},
	{0x98d7, 0x4fce},
	{0x98d8, 0x4fd8},
	{0x98d9, 0x4fdb},
	{0x98da, 0x4fd1},
	{0x98db, 0x4fda},
	{0x98dc, 0x4fd0},
	{0x98dd, 0x4fe4},
	{0x98de, 0x4fe5},
	{0x98df, 0x501a},
	{0x98e0, 0x5028},
	{0x98e1, 0x5014},
	{0x98e2, 0x502a},
	{0x98e3, 0x5025},
	{0x98e4, 0x5005},
	{0x98e5, 0x4f1c},
	{0x98e6, 0x4ff6},
	{0x98e7, 0x5021},
	{0x98e8, 0x5029},
	{0x98e9, 0x502c},
	{0x98ea, 0x4ffe},
	{0x98eb, 0x4fef},
	{0x98ec, 0x5011},
	{0x98ed, 0x5006},
	{0x98ee, 0x5043},
	{0x98ef, 0x5047},
	{0x98f0, 0x6703},
	{0x98f1, 0x5055},
	{0x98f2, 0x5050},
	{0x98f3, 0x5048},
	{0x98f4, 0x505a},
	{0x98f5, 0x5056},
	{0x98f6, 0x506c},
	{0x98f7, 0x5078},
	{0x98f8, 0x5080},
	{0x98f9, 0x509a},
	{0x98fa, 0x5085},
	{0x98fb, 0x50b4},
	{0x98fc, 0x50b2},
	{0x9940, 0x50c9},
	{0x9941, 0x50ca},
	{0x9942, 0x50b3},
	{0x9943, 0x50c2},
	{0x9944, 0x50d6},
	{0x9945, 0x50de},
	{0x9946, 0x50e5},
	{0x9947, 0x50ed},
	{0x9948, 0x50e3},
	{0x9949, 0x50ee},
	{0x994a, 0x50f9},
	{0x994b, 0x50f5},
	{0x994c, 0x5109},
	{0x994d, 0x5101},
	{0x994e, 0x5102},
	{0x994f, 0x5116},
	{0x9950, 0x5115},
	{0x9951, 0x5114},
	{0x9952, 0x511a},
	{0x9953, 0x5121},
	{0x9954, 0x513a},
	{0x9955, 0x5137},
	{0x9956, 0x513c},
	{0x9957, 0x513b},
	{0x9958, 0x513f},
	{0x9959, 0x5140},
	{0x995a, 0x5152},
	{0x995b, 0x514c},
	{0x995c, 0x5154},
	{0x995d, 0x5162},
	{0x995e, 0x7af8},
	{0x995f, 0x5169},
	{0x9960, 0x516a},
	{0x9961, 0x516e},
	{0x9962, 0x5180},
	{0x9963, 0x5182},
	{0x9964, 0x56d8},
	{0x9965, 0x518c},
	{0x9966, 0x5189},
	{0x9967, 0x518f},
	{0x9968, 0x5191},
	{0x9969, 0x5193},
	{0x996a, 0x5195},
	{0x996b, 0x5196},
	{0x996c, 0x51a4},
	{0x996d, 0x51a6},
	{0x996e, 0x51a2},
	{0x996f, 0x51a9},
	{0x9970, 0x51aa},
	{0x9971, 0x51ab},
	{0x9972, 0x51b3},
	{0x9973, 0x51b1},
	{0x9974, 0x51b2},
	{0x9975, 0x51b0},
	{0x9976, 0x51b5},
	{0x9977, 0x51bd},
	{0x9978, 0x51c5},
	{0x9979, 0x51c9},
	{0x997a, 0x51db},
	{0x997b, 0x51e0},
	{0x997c, 0x8655},
	{0x997d, 0x51e9},
	{0x997e, 0x51ed},
	{0x9980, 0x51f0},
	{0x9981, 0x51f5},
	{0x9982, 0x51fe},
	{0x9983, 0x5204},
	{0x9984, 0x520b},
	{0x9985, 0x5214},
	{0x9986, 0x520e},
	{0x9987, 0x5227},
	{0x9988, 0x522a},
	{0x9989, 0x522e},
	{0x998a, 0x5233},
	{0x998b, 0x5239},
	{0x998c, 0x524f},
	{0x998d, 0x5244},
	{0x998e, 0x524b},
	{0x998f, 0x524c},
	{0x9990, 0x525e},
	{0x9991, 0x5254},
	{0x9992, 0x526a},
	{0x9993, 0x5274},
	{0x9994, 0x5269},
	{0x9995, 0x5273},
	{0x9996, 0x527f},
	{0x9997, 0x527d},
	{0x9998, 0x528d},
	{0x9999, 0x5294},
	{0x999a, 0x5292},
	{0x999b, 0x5271},
	{0x999c, 0x5288},
	{0x999d, 0x5291},
	{0x999e, 0x8fa8},
	{0x999f, 0x8fa7},
	{0x99a0, 0x52ac},
	{0x99a1, 0x52ad},
	{0x99a2, 0x52bc},
	{0x99a3, 0x52b5},
	{0x99a4, 0x52c1},
	{0x99a5, 0x52cd},
	{0x99a6, 0x52d7},
	{0x99a7, 0x52de},
	{0x99a8, 0x52e3},
	{0x99a9, 0x52e6},
	{0x99aa, 0x98ed},
	{0x99ab, 0x52e0},
	{0x99ac, 0x52f3},
	{0x99ad, 0x52f5},
	{0x99ae, 0x52f8},
	{0x99af, 0x52f9},
	{0x99b0, 0x5306},
	{0x99b1, 0x5308},
	{0x99b2, 0x7538},
	{0x99b3, 0x530d},
	{0x99b4, 0x5310},
	{0x99b5, 0x530f},
	{0x99b6, 0x5315},
	{0x99b7, 0x531a},
	{0x99b8, 0x5323},
	{0x99b9, 0x532f},
	{0x99ba, 0x5331},
	{0x99bb, 0x5333},
	{0x99bc, 0x5338},
	{0x99bd, 0x5340},
	{0x99be, 0x5346},
	{0x99bf, 0x5345},
	{0x99c0, 0x4e17},
	{0x99c1, 0x5349},
	{0x99c2, 0x534d},
	{0x99c3, 0x51d6},
	{0x99c4, 0x535e},
	{0x99c5, 0x5369},
	{0x99c6, 0x536e},
	{0x99c7, 0x5918},
	{0x99c8, 0x537b},
	{0x99c9, 0x5377},
	{0x99ca, 0x5382},
	{0x99cb, 0x5396},
	{0x99cc, 0x53a0},
	{0x99cd, 0x53a6},
	{0x99ce, 0x53a5},
	{0x99cf, 0x53ae},
	{0x99d0, 0x53b0},
	{0x99d1, 0x53b6},
	{0x99d2, 0x53c3},
	{0x99d3, 0x7c12},
	{0x99d4, 0x96d9},
	{0x99d5, 0x53df},
	{0x99d6, 0x66fc},
	{0x99d7, 0x71ee},
	{0x99d8, 0x53ee},
	{0x99d9, 0x53e8},
	{0x99da, 0x53ed},
	{0x99db, 0x53fa},
	{0x99dc, 0x5401},
	{0x99dd, 0x543d},
	{0x99de, 0x5440},
	{0x99df, 0x542c},
	{0x99e0, 0x542d},
	{0x99e1, 0x543c},
	{0x99e2, 0x542e},
	{0x99e3, 0x5436},
	{0x99e4, 0x5429},
	{0x99e5, 0x541d},
	{0x99e6, 0x544e},
	{0x99e7, 0x548f},
	{0x99e8, 0x5475},
	{0x99e9, 0x548e},
	{0x99ea, 0x545f},
	{0x99eb, 0x5471},
	{0x99ec, 0x5477},
	{0x99ed, 0x5470},
	{0x99ee, 0x5492},
	{0x99ef, 0x547b},
	{0x99f0, 0x5480},
	{0x99f1, 0x5476},
	{0x99f2, 0x5484},
	{0x99f3, 0x5490},
	{0x99f4, 0x5486},
	{0x99f5, 0x54c7},
	{0x99f6, 0x54a2},
	{0x99f7, 0x54b8},
	{0x99f8, 0x54a5},
	{0x99f9, 0x54ac},
	{0x99fa, 0x54c4},
	{0x99fb, 0x54c8},
	{0x99fc, 0x54a8},
	{0x9a40, 0x54ab},
	{0x9a41, 0x54c2},
	{0x9a42, 0x54a4},
	{0x9a43, 0x54be},
	{0x9a44, 0x54bc},
	{0x9a45, 0x54d8},
	{0x9a46, 0x54e5},
	{0x9a47, 0x54e6},
	{0x9a48, 0x550f},
	{0x9a49, 0x5514},
	{0x9a4a, 0x54fd},
	{0x9a4b, 0x54ee},
	{0x9a4c, 0x54ed},
	{0x9a4d, 0x54fa},
	{0x9a4e, 0x54e2},
	{0x9a4f, 0x5539},
	{0x9a50, 0x5540},
	{0x9a51, 0x5563},
	{0x9a52, 0x554c},
	{0x9a53, 0x552e},
	{0x9a54, 0x555c},
	{0x9a55, 0x5545},
	{0x9a56, 0x5556},
	{0x9a57, 0x5557},
	{0x9a58, 0x5538},
	{0x9a59, 0x5533},
	{0x9a5a, 0x555d},
	{0x9a5b, 0x5599},
	{0x9a5c, 0x5580},
	{0x9a5d, 0x54af},
	{0x9a5e, 0x558a},
	{0x9a5f, 0x559f},
	{0x9a60, 0x557b},
	{0x9a61, 0x557e},
	{0x9a62, 0x5598},
	{0x9a63, 0x559e},
	{0x9a64, 0x55ae},
	{0x9a65, 0x557c},
	{0x9a66, 0x5583},
	{0x9a67, 0x55a9},
	{0x9a68, 0x5587},
	{0x9a69, 0x55a8},
	{0x9a6a, 0x55da},
	{0x9a6b, 0x55c5},
	{0x9a6c, 0x55df},
	{0x9a6d, 0x55c4},
	{0x9a6e, 0x55dc},
	{0x9a6f, 0x55e4},
	{0x9a70, 0x55d4},
	{0x9a71, 0x5614},
	{0x9a72, 0x55f7},
	{0x9a73, 0x5616},
	{0x9a74, 0x55fe},
	{0x9a75, 0x55fd},
	{0x9a76, 0x561b},
	{0x9a77, 0x55f9},
	{0x9a78, 0x564e},
	{0x9a79, 0x5650},
	{0x9a7a, 0x71df},
	{0x9a7b, 0x5634},
	{0x9a7c, 0x5636},
	{0x9a7d, 0x5632},
	{0x9a7e, 0x5638},
	{0x9a80, 0x566b},
	{0x9a81, 0x5664},
	{0x9a82, 0x562f},
	{0x9a83, 0x566c},
	{0x9a84, 0x566a},
	{0x9a85, 0x5686},
	{0x9a86, 0x5680},
	{0x9a87, 0x568a},
	{0x9a88, 0x56a0},
	{0x9a89, 0x5694},
	{0x9a8a, 0x568f},
	{0x9a8b, 0x56a5},
	{0x9a8c, 0x56ae},
	{0x9a8d, 0x56b6},
	{0x9a8e, 0x56b4},
	{0x9a8f, 0x56c2},
	{0x9a90, 0x56bc},
	{0x9a91, 0x56c1},
	{0x9a92, 0x56c3},
	{0x9a93, 0x56c0},
	{0x9a94, 0x56c8},
	{0x9a95, 0x56ce},
	{0x9a96, 0x56d1},
	{0x9a97, 0x56d3},
	{0x9a98, 0x56d7},
	{0x9a99, 0x56ee},
	{0x9a9a, 0x56f9},
	{0x9a9b, 0x5700},
	{0x9a9c, 0x56ff},
	{0x9a9d, 0x5704},
	{0x9a9e, 0x5709},
	{0x9a9f, 0x5708},
	{0x9aa0, 0x570b},
	{0x9aa1, 0x570d},
	{0x9aa2, 0x5713},
	{0x9aa3, 0x5718},
	{0x9aa4, 0x5716},
	{0x9aa5, 0x55c7},
	{0x9aa6, 0x571c},
	{0x9aa7, 0x5726},
	{0x9aa8, 0x5737},
	{0x9aa9, 0x5738},
	{0x9aaa, 0x574e},
	{0x9aab, 0x573b},
	{0x9aac, 0x5740},
	{0x9aad, 0x574f},
	{0x9aae, 0x5769},
	{0x9aaf, 0x57c0},
	{0x9ab0, 0x5788},
	{0x9ab1, 0x5761},
	{0x9ab2, 0x577f},
	{0x9ab3, 0x5789},
	{0x9ab4, 0x5793},
	{0x9ab5, 0x57a0},
	{0x9ab6, 0x57b3},
	{0x9ab7, 0x57a4},
	{0x9ab8, 0x57aa},
	{0x9ab9, 0x57b0},
	{0x9aba, 0x57c3},
	{0x9abb, 0x57c6},
	{0x9abc, 0x57d4},
	{0x9abd, 0x57d2},
	{0x9abe, 0x57d3},
	{0x9abf, 0x580a},
	{0x9ac0, 0x57d6},
	{0x9ac1, 0x57e3},
	{0x9ac2, 0x580b},
	{0x9ac3, 0x5819},
	{0x9ac4, 0x581d},
	{0x9ac5, 0x5872},
	{0x9ac6, 0x5821},
	{0x9ac7, 0x5862},
	{0x9ac8, 0x584b},
	{0x9ac9, 0x5870},
	{0x9aca, 0x6bc0},
	{0x9acb, 0x5852},
	{0x9acc, 0x583d},
	{0x9acd, 0x5879},
	{0x9ace, 0x5885},
	{0x9acf, 0x58b9},
	{0x9ad0, 0x589f},
	{0x9ad1, 0x58ab},
	{0x9ad2, 0x58ba},
	{0x9ad3, 0x58de},
	{0x9ad4, 0x58bb},
	{0x9ad5, 0x58b8},
	{0x9ad6, 0x58ae},
	{0x9ad7, 0x58c5},
	{0x9ad8, 0x58d3},
	{0x9ad9, 0x58d1},
	{0x9ada, 0x58d7},
	{0x9adb, 0x58d9},
	{0x9adc, 0x58d8},
	{0x9add, 0x58e5},
	{0x9ade, 0x58dc},
	{0x9adf, 0x58e4},
	{0x9ae0, 0x58df},
	{0x9ae1, 0x58ef},
	{0x9ae2, 0x58fa},
	{0x9ae3, 0x58f9},
	{0x9ae4, 0x58fb},
	{0x9ae5, 0x58fc},
	{0x9ae6, 0x58fd},
	{0x9ae7, 0x5902},
	{0x9ae8, 0x590a},
	{0x9ae9, 0x5910},
	{0x9aea, 0x591b},
	{0x9aeb, 0x68a6},
	{0x9aec, 0x5925},
	{0x9aed, 0x592c},
	{0x9aee, 0x592d},
	{0x9aef, 0x5932},
	{0x9af0, 0x5938},
	{0x9af1, 0x593e},
	{0x9af2, 0x7ad2},
	{0x9af3, 0x5955},
	{0x9af4, 0x5950},
	{0x9af5, 0x594e},
	{0x9af6, 0x595a},
	{0x9af7, 0x5958},
	{0x9af8, 0x5962},
	{0x9af9, 0x5960},
	{0x9afa, 0x5967},
	{0x9afb, 0x596c},
	{0x9afc, 0x5969},
	{0x9b40, 0x5978},
	{0x9b41, 0x5981},
	{0x9b42, 0x599d},
	{0x9b43, 0x4f5e},
	{0x9b44, 0x4fab},
	{0x9b45, 0x59a3},
	{0x9b46, 0x59b2},
	{0x9b47, 0x59c6},
	{0x9b48, 0x59e8},
	{0x9b49, 0x59dc},
	{0x9b4a, 0x598d},
	{0x9b4b, 0x59d9},
	{0x9b4c, 0x59da},
	{0x9b4d, 0x5a25},
	{0x9b4e, 0x5a1f},
	{0x9b4f, 0x5a11},
	{0x9b50, 0x5a1c},
	{0x9b51, 0x5a09},
	{0x9b52, 0x5a1a},
	{0x9b53, 0x5a40},
	{0x9b54, 0x5a6c},
	{0x9b55, 0x5a49},
	{0x9b56, 0x5a35},
	{0x9b57, 0x5a36},
	{0x9b58, 0x5a62},
	{0x9b59, 0x5a6a},
	{0x9b5a, 0x5a9a},
	{0x9b5b, 0x5abc},
	{0x9b5c, 0x5abe},
	{0x9b5d, 0x5acb},
	{0x9b5e, 0x5ac2},
	{0x9b5f, 0x5abd},
	{0x9b60, 0x5ae3},
	{0x9b61, 0x5ad7},
	{0x9b62, 0x5ae6},
	{0x9b63, 0x5ae9},
	{0x9b64, 0x5ad6},
	{0x9b65, 0x5afa},
	{0x9b66, 0x5afb},
	{0x9b67, 0x5b0c},
	{0x9b68, 0x5b0b},
	{0x9b69, 0x5b16},
	{0x9b6a, 0x5b32},
	{0x9b6b, 0x5ad0},
	{0x9b6c, 0x5b2a},
	{0x9b6d, 0x5b36},
	{0x9b6e, 0x5b3e},
	{0x9b6f, 0x5b43},
	{0x9b70, 0x5b45},
	{0x9b71, 0x5b40},
	{0x9b72, 0x5b51},
	{0x9b73, 0x5b55},
	{0x9b74, 0x5b5a},
	{0x9b75, 0x5b5b},
	{0x9b76, 0x5b65},
	{0x9b77, 0x5b69},
	{0x9b78, 0x5b70},
	{0x9b79, 0x5b73},
	{0x9b7a, 0x5b75},
	{0x9b7b, 0x5b78},
	{0x9b7c, 0x6588},
	{0x9b7d, 0x5b7a},
	{0x9b7e, 0x5b80},
	{0x9b80, 0x5b83},
	{0x9b81, 0x5ba6},
	{0x9b82, 0x5bb8},
	{0x9b83, 0x5bc3},
	{0x9b84, 0x5bc7},
	{0x9b85, 0x5bc9},
	{0x9b86, 0x5bd4},
	{0x9b87, 0x5bd0},
	{0x9b88, 0x5be4},
	{0x9b89, 0x5be6},
	{0x9b8a, 0x5be2},
	{0x9b8b, 0x5bde},
	{0x9b8c, 0x5be5},
	{0x9b8d, 0x5beb},
	{0x9b8e, 0x5bf0},
	{0x9b8f, 0x5bf6},
	{0x9b90, 0x5bf3},
	{0x9b91, 0x5c05},
	{0x9b92, 0x5c07},
	{0x9b93, 0x5c08},
	{0x9b94, 0x5c0d},
	{0x9b95, 0x5c13},
	{0x9b96, 0x5c20},
	{0x9b97, 0x5c22},
	{0x9b98, 0x5c28},
	{0x9b99, 0x5c38},
	{0x9b9a, 0x5c39},
	{0x9b9b, 0x5c41},
	{0x9b9c, 0x5c46},
	{0x9b9d, 0x5c4e},
	{0x9b9e, 0x5c53},
	{0x9b9f, 0x5c50},
	{0x9ba0, 0x5c4f},
	{0x9ba1, 0x5b71},
	{0x9ba2, 0x5c6c},
	{0x9ba3, 0x5c6e},
	{0x9ba4, 0x4e62},
	{0x9ba5, 0x5c76},
	{0x9ba6, 0x5c79},
	{0x9ba7, 0x5c8c},
	{0x9ba8, 0x5c91},
	{0x9ba9, 0x5c94},
	{0x9baa, 0x599b},
	{0x9bab, 0x5cab},
	{0x9bac, 0x5cbb},
	{0x9bad, 0x5cb6},
	{0x9bae, 0x5cbc},
	{0x9baf, 0x5cb7},
	{0x9bb0, 0x5cc5},
	{0x9bb1, 0x5cbe},
	{0x9bb2, 0x5cc7},
	{0x9bb3, 0x5cd9},
	{0x9bb4, 0x5ce9},
	{0x9bb5, 0x5cfd},
	{0x9bb6, 0x5cfa},
	{0x9bb7, 0x5ced},
	{0x9bb8, 0x5d8c},
	{0x9bb9, 0x5cea},
	{0x9bba, 0x5d0b},
	{0x9bbb, 0x5d15},
	{0x9bbc, 0x5d17},
	{0x9bbd, 0x5d5c},
	{0x9bbe, 0x5d1f},
	{0x9bbf, 0x5d1b},
	{0x9bc0, 0x5d11},
	{0x9bc1, 0x5d14},
	{0x9bc2, 0x5d22},
	{0x9bc3, 0x5d1a},
	{0x9bc4, 0x5d19},
	{0x9bc5, 0x5d18},
	{0x9bc6, 0x5d4c},
	{0x9bc7, 0x5d52},
	{0x9bc8, 0x5d4e},
	{0x9bc9, 0x5d4b},
	{0x9bca, 0x5d6c},
	{0x9bcb, 0x5d73},
	{0x9bcc, 0x5d76},
	{0x9bcd, 0x5d87},
	{0x9bce, 0x5d84},
	{0x9bcf, 0x5d82},
	{0x9bd0, 0x5da2},
	{0x9bd1, 0x5d9d},
	{0x9bd2, 0x5dac},
	{0x9bd3, 0x5dae},
	{0x9bd4, 0x5dbd},
	{0x9bd5, 0x5d90},
	{0x9bd6, 0x5db7},
	{0x9bd7, 0x5dbc},
	{0x9bd8, 0x5dc9},
	{0x9bd9, 0x5dcd},
	{0x9bda, 0x5dd3},
	{0x9bdb, 0x5dd2},
	{0x9bdc, 0x5dd6},
	{0x9bdd, 0x5ddb},
	{0x9bde, 0x5deb},
	{0x9bdf, 0x5df2},
	{0x9be0, 0x5df5},
	{0x9be1, 0x5e0b},
	{0x9be2, 0x5e1a},
	{0x9be3, 0x5e19},
	{0x9be4, 0x5e11},
	{0x9be5, 0x5e1b},
	{0x9be6, 0x5e36},
	{0x9be7, 0x5e37},
	{0x9be8, 0x5e44},
	{0x9be9, 0x5e43},
	{0x9bea, 0x5e40},
	{0x9beb, 0x5e4e},
	{0x9bec, 0x5e57},
	{0x9bed, 0x5e54},
	{0x9bee, 0x5e5f},
	{0x9bef, 0x5e62},
	{0x9bf0, 0x5e64},
	{0x9bf1, 0x5e47},
	{0x9bf2, 0x5e75},
	{0x9bf3, 0x5e76},
	{0x9bf4, 0x5e7a},
	{0x9bf5, 0x9ebc},
	{0x9bf6, 0x5e7f},
	{0x9bf7, 0x5ea0},
	{0x9bf8, 0x5ec1},
	{0x9bf9, 0x5ec2},
	{0x9bfa, 0x5ec8},
	{0x9bfb, 0x5ed0},
	{0x9bfc, 0x5ecf},
	{0x9c40, 0x5ed6},
	{0x9c41, 0x5ee3},
	{0x9c42, 0x5edd},
	{0x9c43, 0x5eda},
	{0x9c44, 0x5edb},
	{0x9c45, 0x5ee2},
	{0x9c46, 0x5ee1},
	{0x9c47, 0x5ee8},
	{0x9c48, 0x5ee9},
	{0x9c49, 0x5eec},
	{0x9c4a, 0x5ef1},
	{0x9c4b, 0x5ef3},
	{0x9c4c, 0x5ef0},
	{0x9c4d, 0x5ef4},
	{0x9c4e, 0x5ef8},
	{0x9c4f, 0x5efe},
	{0x9c50, 0x5f03},
	{0x9c51, 0x5f09},
	{0x9c52, 0x5f5d},
	{0x9c53, 0x5f5c},
	{0x9c54, 0x5f0b},
	{0x9c55, 0x5f11},
	{0x9c56, 0x5f16},
	{0x9c57, 0x5f29},
	{0x9c58, 0x5f2d},
	{0x9c59, 0x5f38},
	{0x9c5a, 0x5f41},
	{0x9c5b, 0x5f48},
	{0x9c5c, 0x5f4c},
	{0x9c5d, 0x5f4e},
	{0x9c5e, 0x5f2f},
	{0x9c5f, 0x5f51},
	{0x9c60, 0x5f56},
	{0x9c61, 0x5f57},
	{0x9c62, 0x5f59},
	{0x9c63, 0x5f61},
	{0x9c64, 0x5f6d},
	{0x9c65, 0x5f73},
	{0x9c66, 0x5f77},
	{0x9c67, 0x5f83},
	{0x9c68, 0x5f82},
	{0x9c69, 0x5f7f},
	{0x9c6a, 0x5f8a},
	{0x9c6b, 0x5f88},
	{0x9c6c, 0x5f91},
	{0x9c6d, 0x5f87},
	{0x9c6e, 0x5f9e},
	{0x9c6f, 0x5f99},
	{0x9c70, 0x5f98},
	{0x9c71, 0x5fa0},
	{0x9c72, 0x5fa8},
	{0x9c73, 0x5fad},
	{0x9c74, 0x5fbc},
	{0x9c75, 0x5fd6},
	{0x9c76, 0x5ffb},
	{0x9c77, 0x5fe4},
	{0x9c78, 0x5ff8},
	{0x9c79, 0x5ff1},
	{0x9c7a, 0x5fdd},
	{0x9c7b, 0x60b3},
	{0x9c7c, 0x5fff},
	{0x9c7d, 0x6021},
	{0x9c7e, 0x6060},
	{0x9c80, 0x6019},
	{0x9c81, 0x6010},
	{0x9c82, 0x6029},
	{0x9c83, 0x600e},
	{0x9c84, 0x6031},
	{0x9c85, 0x601b},
	{0x9c86, 0x6015},
	{0x9c87, 0x602b},
	{0x9c88, 0x6026},
	{0x9c89, 0x600f},
	{0x9c8a, 0x603a},
	{0x9c8b, 0x605a},
	{0x9c8c, 0x6041},
	{0x9c8d, 0x606a},
	{0x9c8e, 0x6077},
	{0x9c8f, 0x605f},
	{0x9c90, 0x604a},
	{0x9c91, 0x6046},
	{0x9c92, 0x604d},
	{0x9c93, 0x6063},
	{0x9c94, 0x6043},
	{0x9c95, 0x6064},
	{0x9c96, 0x6042},
	{0x9c97, 0x606c},
	{0x9c98, 0x606b},
	{0x9c99, 0x6059},
	{0x9c9a, 0x6081},
	{0x9c9b, 0x608d},
	{0x9c9c, 0x60e7},
	{0x9c9d, 0x6083},
	{0x9c9e, 0x609a},
	{0x9c9f, 0x6084},
	{0x9ca0, 0x609b},
	{0x9ca1, 0x6096},
	{0x9ca2, 0x6097},
	{0x9ca3, 0x6092},
	{0x9ca4, 0x60a7},
	{0x9ca5, 0x608b},
	{0x9ca6, 0x60e1},
	{0x9ca7, 0x60b8},
	{0x9ca8, 0x60e0},
	{0x9ca9, 0x60d3},
	{0x9caa, 0x60b4},
	{0x9cab, 0x5ff0},
	{0x9cac, 0x60bd},
	{0x9cad, 0x60c6},
	{0x9cae, 0x60b5},
	{0x9caf, 0x60d8},
	{0x9cb0, 0x614d},
	{0x9cb1, 0x6115},
	{0x9cb2, 0x6106},
	{0x9cb3, 0x60f6},
	{0x9cb4, 0x60f7},
	{0x9cb5, 0x6100},
	{0x9cb6, 0x60f4},
	{0x9cb7, 0x60fa},
	{0x9cb8, 0x6103},
	{0x9cb9, 0x6121},
	{0x9cba, 0x60fb},
	{0x9cbb, 0x60f1},
	{0x9cbc, 0x610d},
	{0x9cbd, 0x610e},
	{0x9cbe, 0x6147},
	{0x9cbf, 0x613e},
	{0x9cc0, 0x6128},
	{0x9cc1, 0x6127},
	{0x9cc2, 0x614a},
	{0x9cc3, 0x613f},
	{0x9cc4, 0x613c},
	{0x9cc5, 0x612c},
	{0x9cc6, 0x6134},
	{0x9cc7, 0x613d},
	{0x9cc8, 0x6142},
	{0x9cc9, 0x6144},
	{0x9cca, 0x6173},
	{0x9ccb, 0x6177},
	{0x9ccc, 0x6158},
	{0x9ccd, 0x6159},
	{0x9cce, 0x615a},
	{0x9ccf, 0x616b},
	{0x9cd0, 0x6174},
	{0x9cd1, 0x616f},
	{0x9cd2, 0x6165},
	{0x9cd3, 0x6171},
	{0x9cd4, 0x615f},
	{0x9cd5, 0x615d},
	{0x9cd6, 0x6153},
	{0x9cd7, 0x6175},
	{0x9cd8, 0x6199},
	{0x9cd9, 0x6196},
	{0x9cda, 0x6187},
	{0x9cdb, 0x61ac},
	{0x9cdc, 0x6194},
	{0x9cdd, 0x619a},
	{0x9cde, 0x618a},
	{0x9cdf, 0x6191},
	{0x9ce0, 0x61ab},
	{0x9ce1, 0x61ae},
	{0x9ce2, 0x61cc},
	{0x9ce3, 0x61ca},
	{0x9ce4, 0x61c9},
	{0x9ce5, 0x61f7},
	{0x9ce6, 0x61c8},
	{0x9ce7, 0x61c3},
	{0x9ce8, 0x61c6},
	{0x9ce9, 0x61ba},
	{0x9cea, 0x61cb},
	{0x9ceb, 0x7f79},
	{0x9cec, 0x61cd},
	{0x9ced, 0x61e6},
	{0x9cee, 0x61e3},
	{0x9cef, 0x61f6},
	{0x9cf0, 0x61fa},
	{0x9cf1, 0x61f4},
	{0x9cf2, 0x61ff},
	{0x9cf3, 0x61fd},
	{0x9cf4, 0x61fc},
	{0x9cf5, 0x61fe},
	{0x9cf6, 0x6200},
	{0x9cf7, 0x6208},
	{0x9cf8, 0x6209},
	{0x9cf9, 0x620d},
	{0x9cfa, 0x620c},
	{0x9cfb, 0x6214},
	{0x9cfc, 0x621b},
	{0x9d40, 0x621e},
	{0x9d41, 0x6221},
	{0x9d42, 0x622a},
	{0x9d43, 0x622e},
	{0x9d44, 0x6230},
	{0x9d45, 0x6232},
	{0x9d46, 0x6233},
	{0x9d47, 0x6241},
	{0x9d48, 0x624e},
	{0x9d49, 0x625e},
	{0x9d4a, 0x6263},
	{0x9d4b, 0x625b},
	{0x9d4c, 0x6260},
	{0x9d4d, 0x6268},
	{0x9d4e, 0x627c},
	{0x9d4f, 0x6282},
	{0x9d50, 0x6289},
	{0x9d51, 0x627e},
	{0x9d52, 0x6292},
	{0x9d53, 0x6293},
	{0x9d54, 0x6296},
	{0x9d55, 0x62d4},
	{0x9d56, 0x6283},
	{0x9d57, 0x6294},
	{0x9d58, 0x62d7},
	{0x9d59, 0x62d1},
	{0x9d5a, 0x62bb},
	{0x9d5b, 0x62cf},
	{0x9d5c, 0x62ff},
	{0x9d5d, 0x62c6},
	{0x9d5e, 0x64d4},
	{0x9d5f, 0x62c8},
	{0x9d60, 0x62dc},
	{0x9d61, 0x62cc},
	{0x9d62, 0x62ca},
	{0x9d63, 0x62c2},
	{0x9d64, 0x62c7},
	{0x9d65, 0x629b},
	{0x9d66, 0x62c9},
	{0x9d67, 0x630c},
	{0x9d68, 0x62ee},
	{0x9d69, 0x62f1},
	{0x9d6a, 0x6327},
	{0x9d6b, 0x6302},
	{0x9d6c, 0x6308},
	{0x9d6d, 0x62ef},
	{0x9d6e, 0x62f5},
	{0x9d6f, 0x6350},
	{0x9d70, 0x633e},
	{0x9d71, 0x634d},
	{0x9d72, 0x641c},
	{0x9d73, 0x634f},
	{0x9d74, 0x6396},
	{0x9d75, 0x638e},
	{0x9d76, 0x6380},
	{0x9d77, 0x63ab},
	{0x9d78, 0x6376},
	{0x9d79, 0x63a3},
	{0x9d7a, 0x638f},
	{0x9d7b, 0x6389},
	{0x9d7c, 0x639f},
	{0x9d7d, 0x63b5},
	{0x9d7e, 0x636b},
	{0x9d80, 0x6369},
	{0x9d81, 0x63be},
	{0x9d82, 0x63e9},
	{0x9d83, 0x63c0},
	{0x9d84, 0x63c6},
	{0x9d85, 0x63e3},
	{0x9d86, 0x63c9},
	{0x9d87, 0x63d2},
	{0x9d88, 0x63f6},
	{0x9d89, 0x63c4},
	{0x9d8a, 0x6416},
	{0x9d8b, 0x6434},
	{0x9d8c, 0x6406},
	{0x9d8d, 0x6413},
	{0x9d8e, 0x6426},
	{0x9d8f, 0x6436},
	{0x9d90, 0x651d},
	{0x9d91, 0x6417},
	{0x9d92, 0x6428},
	{0x9d93, 0x640f},
	{0x9d94, 0x6467},
	{0x9d95, 0x646f},
	{0x9d96, 0x6476},
	{0x9d97, 0x644e},
	{0x9d98, 0x652a},
	{0x9d99, 0x6495},
	{0x9d9a, 0x6493},
	{0x9d9b, 0x64a5},
	{0x9d9c, 0x64a9},
	{0x9d9d, 0x6488},
	{0x9d9e, 0x64bc},
	{0x9d9f, 0x64da},
	{0x9da0, 0x64d2},
	{0x9da1, 0x64c5},
	{0x9da2, 0x64c7},
	{0x9da3, 0x64bb},
	{0x9da4, 0x64d8},
	{0x9da5, 0x64c2},
	{0x9da6, 0x64f1},
	{0x9da7, 0x64e7},
	{0x9da8, 0x8209},
	{0x9da9, 0x64e0},
	{0x9daa, 0x64e1},
	{0x9dab, 0x62ac},
	{0x9dac, 0x64e3},
	{0x9dad, 0x64ef},
	{0x9dae, 0x652c},
	{0x9daf, 0x64f6},
	{0x9db0, 0x64f4},
	{0x9db1, 0x64f2},
	{0x9db2, 0x64fa},
	{0x9db3, 0x6500},
	{0x9db4, 0x64fd},
	{0x9db5, 0x6518},
	{0x9db6, 0x651c},
	{0x9db7, 0x6505},
	{0x9db8, 0x6524},
	{0x9db9, 0x6523},
	{0x9dba, 0x652b},
	{0x9dbb, 0x6534},
	{0x9dbc, 0x6535},
	{0x9dbd, 0x6537},
	{0x9dbe, 0x6536},
	{0x9dbf, 0x6538},
	{0x9dc0, 0x754b},
	{0x9dc1, 0x6548},
	{0x9dc2, 0x6556},
	{0x9dc3, 0x6555},
	{0x9dc4, 0x654d},
	{0x9dc5, 0x6558},
	{0x9dc6, 0x655e},
	{0x9dc7, 0x655d},
	{0x9dc8, 0x6572},
	{0x9dc9, 0x6578},
	{0x9dca, 0x6582},
	{0x9dcb, 0x6583},
	{0x9dcc, 0x8b8a},
	{0x9dcd, 0x659b},
	{0x9dce, 0x659f},
	{0x9dcf, 0x65ab},
	{0x9dd0, 0x65b7},
	{0x9dd1, 0x65c3},
	{0x9dd2, 0x65c6},
	{0x9dd3, 0x65c1},
	{0x9dd4, 0x65c4},
	{0x9dd5, 0x65cc},
	{0x9dd6, 0x65d2},
	{0x9dd7, 0x65db},
	{0x9dd8, 0x65d9},
	{0x9dd9, 0x65e0},
	{0x9dda, 0x65e1},
	{0x9ddb, 0x65f1},
	{0x9ddc, 0x6772},
	{0x9ddd, 0x660a},
	{0x9dde, 0x6603},
	{0x9ddf, 0x65fb},
	{0x9de0, 0x6773},
	{0x9de1, 0x6635},
	{0x9de2, 0x6636},
	{0x9de3, 0x6634},
	{0x9de4, 0x661c},
	{0x9de5, 0x664f},
	{0x9de6, 0x6644},
	{0x9de7, 0x6649},
	{0x9de8, 0x6641},
	{0x9de9, 0x665e},
	{0x9dea, 0x665d},
	{0x9deb, 0x6664},
	{0x9dec, 0x6667},
	{0x9ded, 0x6668},
	{0x9dee, 0x665f},
	{0x9def, 0x6662},
	{0x9df0, 0x6670},
	{0x9df1, 0x6683},
	{0x9df2, 0x6688},
	{0x9df3, 0x668e},
	{0x9df4, 0x6689},
	{0x9df5, 0x6684},
	{0x9df6, 0x6698},
	{0x9df7, 0x669d},
	{0x9df8, 0x66c1},
	{0x9df9, 0x66b9},
	{0x9dfa, 0x66c9},
	{0x9dfb, 0x66be},
	{0x9dfc, 0x66bc},
	{0x9e40, 0x66c4},
	{0x9e41, 0x66b8},
	{0x9e42, 0x66d6},
	{0x9e43, 0x66da},
	{0x9e44, 0x66e0},
	{0x9e45, 0x663f},
	{0x9e46, 0x66e6},
	{0x9e47, 0x66e9},
	{0x9e48, 0x66f0},
	{0x9e49, 0x66f5},
	{0x9e4a, 0x66f7},
	{0x9e4b, 0x670f},
	{0x9e4c, 0x6716},
	{0x9e4d, 0x671e},
	{0x9e4e, 0x6726},
	{0x9e4f, 0x6727},
	{0x9e50, 0x9738},
	{0x9e51, 0x672e},
	{0x9e52, 0x673f},
	{0x9e53, 0x6736},
	{0x9e54, 0x6741},
	{0x9e55, 0x6738},
	{0x9e56, 0x6737},
	{0x9e57, 0x6746},
	{0x9e58, 0x675e},
	{0x9e59, 0x6760},
	{0x9e5a, 0x6759},
	{0x9e5b, 0x6763},
	{0x9e5c, 0x6764},
	{0x9e5d, 0x6789},
	{0x9e5e, 0x6770},
	{0x9e5f, 0x67a9},
	{0x9e60, 0x677c},
	{0x9e61, 0x676a},
	{0x9e62, 0x678c},
	{0x9e63, 0x678b},
	{0x9e64, 0x67a6},
	{0x9e65, 0x67a1},
	{0x9e66, 0x6785},
	{0x9e67, 0x67b7},
	{0x9e68, 0x67ef},
	{0x9e69, 0x67b4},
	{0x9e6a, 0x67ec},
	{0x9e6b, 0x67b3},
	{0x9e6c, 0x67e9},
	{0x9e6d, 0x67b8},
	{0x9e6e, 0x67e4},
	{0x9e6f, 0x67de},
	{0x9e70, 0x67dd},
	{0x9e71, 0x67e2},
	{0x9e72, 0x67ee},
	{0x9e73, 0x67b9},
	{0x9e74, 0x67ce},
	{0x9e75, 0x67c6},
	{0x9e76, 0x67e7},
	{0x9e77, 0x6a9c},
	{0x9e78, 0x681e},
	{0x9e79, 0x6846},
	{0x9e7a, 0x6829},
	{0x9e7b, 0x6840},
	{0x9e7c, 0x684d},
	{0x9e7d, 0x6832},
	{0x9e7e, 0x684e},
	{0x9e80, 0x68b3},
	{0x9e81, 0x682b},
	{0x9e82, 0x6859},
	{0x9e83, 0x6863},
	{0x9e84, 0x6877},
	{0x9e85, 0x687f},
	{0x9e86, 0x689f},
	{0x9e87, 0x688f},
	{0x9e88, 0x68ad},
	{0x9e89, 0x6894},
	{0x9e8a, 0x689d},
	{0x9e8b, 0x689b},
	{0x9e8c, 0x6883},
	{0x9e8d, 0x6aae},
	{0x9e8e, 0x68b9},
	{0x9e8f, 0x6874},
	{0x9e90, 0x68b5},
	{0x9e91, 0x68a0},
	{0x9e92, 0x68ba},
	{0x9e93, 0x690f},
	{0x9e94, 0x688d},
	{0x9e95, 0x687e},
	{0x9e96, 0x6901},
	{0x9e97, 0x68ca},
	{0x9e98, 0x6908},
	{0x9e99, 0x68d8},
	{0x9e9a, 0x6922},
	{0x9e9b, 0x6926},
	{0x9e9c, 0x68e1},
	{0x9e9d, 0x690c},
	{0x9e9e, 0x68cd},
	{0x9e9f, 0x68d4},
	{0x9ea0, 0x68e7},
	{0x9ea1, 0x68d5},
	{0x9ea2, 0x6936},
	{0x9ea3, 0x6912},
	{0x9ea4, 0x6904},
	{0x9ea5, 0x68d7},
	{0x9ea6, 0x68e3},
	{0x9ea7, 0x6925},
	{0x9ea8, 0x68f9},
	{0x9ea9, 0x68e0},
	{0x9eaa, 0x68ef},
	{0x9eab, 0x6928},
	{0x9eac, 0x692a},
	{0x9ead, 0x691a},
	{0x9eae, 0x6923},
	{0x9eaf, 0x6921},
	{0x9eb0, 0x68c6},
	{0x9eb1, 0x6979},
	{0x9eb2, 0x6977},
	{0x9eb3, 0x695c},
	{0x9eb4, 0x6978},
	{0x9eb5, 0x696b},
	{0x9eb6, 0x6954},
	{0x9eb7, 0x697e},
	{0x9eb8, 0x696e},
	{0x9eb9, 0x6939},
	{0x9eba, 0x6974},
	{0x9ebb, 0x693d},
	{0x9ebc, 0x6959},
	{0x9ebd, 0x6930},
	{0x9ebe, 0x6961},
	{0x9ebf, 0x695e},
	{0x9ec0, 0x695d},
	{0x9ec1, 0x6981},
	{0x9ec2, 0x696a},
	{0x9ec3, 0x69b2},
	{0x9ec4, 0x69ae},
	{0x9ec5, 0x69d0},
	{0x9ec6, 0x69bf},
	{0x9ec7, 0x69c1},
	{0x9ec8, 0x69d3},
	{0x9ec9, 0x69be},
	{0x9eca, 0x69ce},
	{0x9ecb, 0x5be8},
	{0x9ecc, 0x69ca},
	{0x9ecd, 0x69dd},
	{0x9ece, 0x69bb},
	{0x9ecf, 0x69c3},
	{0x9ed0, 0x69a7},
	{0x9ed1, 0x6a2e},
	{0x9ed2, 0x6991},
	{0x9ed3, 0x69a0},
	{0x9ed4, 0x699c},
	{0x9ed5, 0x6995},
	{0x9ed6, 0x69b4},
	{0x9ed7, 0x69de},
	{0x9ed8, 0x69e8},
	{0x9ed9, 0x6a02},
	{0x9eda, 0x6a1b},
	{0x9edb, 0x69ff},
	{0x9edc, 0x6b0a},
	{0x9edd, 0x69f9},
	{0x9ede, 0x69f2},
	{0x9edf, 0x69e7},
	{0x9ee0, 0x6a05},
	{0x9ee1, 0x69b1},
	{0x9ee2, 0x6a1e},
	{0x9ee3, 0x69ed},
	{0x9ee4, 0x6a14},
	{0x9ee5, 0x69eb},
	{0x9ee6, 0x6a0a},
	{0x9ee7, 0x6a12},
	{0x9ee8, 0x6ac1},
	{0x9ee9, 0x6a23},
	{0x9eea, 0x6a13},
	{0x9eeb, 0x6a44},
	{0x9eec, 0x6a0c},
	{0x9eed, 0x6a72},
	{0x9eee, 0x6a36},
	{0x9eef, 0x6a78},
	{0x9ef0, 0x6a47},
	{0x9ef1, 0x6a62},
	{0x9ef2, 0x6a59},
	{0x9ef3, 0x6a66},
	{0x9ef4, 0x6a48},
	{0x9ef5, 0x6a38},
	{0x9ef6, 0x6a22},
	{0x9ef7, 0x6a90},
	{0x9ef8, 0x6a8d},
	{0x9ef9, 0x6aa0},
	{0x9efa, 0x6a84},
	{0x9efb, 0x6aa2},
	{0x9efc, 0x6aa3},
	{0x9f40, 0x6a97},
	{0x9f41, 0x8617},
	{0x9f42, 0x6abb},
	{0x9f43, 0x6ac3},
	{0x9f44, 0x6ac2},
	{0x9f45, 0x6ab8},
	{0x9f46, 0x6ab3},
	{0x9f47, 0x6aac},
	{0x9f48, 0x6ade},
	{0x9f49, 0x6ad1},
	{0x9f4a, 0x6adf},
	{0x9f4b, 0x6aaa},
	{0x9f4c, 0x6ada},
	{0x9f4d, 0x6aea},
	{0x9f4e, 0x6afb},
	{0x9f4f, 0x6b05},
	{0x9f50, 0x8616},
	{0x9f51, 0x6afa},
	{0x9f52, 0x6b12},
	{0x9f53, 0x6b16},
	{0x9f54, 0x9b31},
	{0x9f55, 0x6b1f},
	{0x9f56, 0x6b38},
	{0x9f57, 0x6b37},
	{0x9f58, 0x76dc},
	{0x9f59, 0x6b39},
	{0x9f5a, 0x98ee},
	{0x9f5b, 0x6b47},
	{0x9f5c, 0x6b43},
	{0x9f5d, 0x6b49},
	{0x9f5e, 0x6b50},
	{0x9f5f, 0x6b59},
	{0x9f60, 0x6b54},
	{0x9f61, 0x6b5b},
	{0x9f62, 0x6b5f},
	{0x9f63, 0x6b61},
	{0x9f64, 0x6b78},
	{0x9f65, 0x6b79},
	{0x9f66, 0x6b7f},
	{0x9f67, 0x6b80},
	{0x9f68, 0x6b84},
	{0x9f69, 0x6b83},
	{0x9f6a, 0x6b8d},
	{0x9f6b, 0x6b98},
	{0x9f6c, 0x6b95},
	{0x9f6d, 0x6b9e},
	{0x9f6e, 0x6ba4},
	{0x9f6f, 0x6baa},
	{0x9f70, 0x6bab},
	{0x9f71, 0x6baf},
	{0x9f72, 0x6bb2},
	{0x9f73, 0x6bb1},
	{0x9f74, 0x6bb3},
	{0x9f75, 0x6bb7},
	{0x9f76, 0x6bbc},
	{0x9f77, 0x6bc6},
	{0x9f78, 0x6bcb},
	{0x9f79, 0x6bd3},
	{0x9f7a, 0x6bdf},
	{0x9f7b, 0x6bec},
	{0x9f7c, 0x6beb},
	{0x9f7d, 0x6bf3},
	{0x9f7e, 0x6bef},
	{0x9f80, 0x9ebe},
	{0x9f81, 0x6c08},
	{0x9f82, 0x6c13},
	{0x9f83, 0x6c14},
	{0x9f84, 0x6c1b},
	{0x9f85, 0x6c24},
	{0x9f86, 0x6c23},
	{0x9f87, 0x6c5e},
	{0x9f88, 0x6c55},
	{0x9f89, 0x6c62},
	{0x9f8a, 0x6c6a},
	{0x9f8b, 0x6c82},
	{0x9f8c, 0x6c8d},
	{0x9f8d, 0x6c9a},
	{0x9f8e, 0x6c81},
	{0x9f8f, 0x6c9b},
	{0x9f90, 0x6c7e},
	{0x9f91, 0x6c68},
	{0x9f92, 0x6c73},
	{0x9f93, 0x6c92},
	{0x9f94, 0x6c90},
	{0x9f95, 0x6cc4},
	{0x9f96, 0x6cf1},
	{0x9f97, 0x6cd3},
	{0x9f98, 0x6cbd},
	{0x9f99, 0x6cd7},
	{0x9f9a, 0x6cc5},
	{0x9f9b, 0x6cdd},
	{0x9f9c, 0x6cae},
	{0x9f9d, 0x6cb1},
	{0x9f9e, 0x6cbe},
	{0x9f9f, 0x6cba},
	{0x9fa0, 0x6cdb},
	{0x9fa1, 0x6cef},
	{0x9fa2, 0x6cd9},
	{0x9fa3, 0x6cea},
	{0x9fa4, 0x6d1f},
	{0x9fa5, 0x884d},
	{0x9fa6, 0x6d36},
	{0x9fa7, 0x6d2b},
	{0x9fa8, 0x6d3d},
	{0x9fa9, 0x6d38},
	{0x9faa, 0x6d19},
	{0x9fab, 0x6d35},
	{0x9fac, 0x6d33},
	{0x9fad, 0x6d12},
	{0x9fae, 0x6d0c},
	{0x9faf, 0x6d63},
	{0x9fb0, 0x6d93},
	{0x9fb1, 0x6d64},
	{0x9fb2, 0x6d5a},
	{0x9fb3, 0x6d79},
	{0x9fb4, 0x6d59},
	{0x9fb5, 0x6d8e},
	{0x9fb6, 0x6d95},
	{0x9fb7, 0x6fe4},
	{0x9fb8, 0x6d85},
	{0x9fb9, 0x6df9},
	{0x9fba, 0x6e15},
	{0x9fbb, 0x6e0a},
	{0x9fbc, 0x6db5},
	{0x9fbd, 0x6dc7},
	{0x9fbe, 0x6de6},
	{0x9fbf, 0x6db8},
	{0x9fc0, 0x6dc6},
	{0x9fc1, 0x6dec},
	{0x9fc2, 0x6dde},
	{0x9fc3, 0x6dcc},
	{0x9fc4, 0x6de8},
	{0x9fc5, 0x6dd2},
	{0x9fc6, 0x6dc5},
	{0x9fc7, 0x6dfa},
	{0x9fc8, 0x6dd9},
	{0x9fc9, 0x6de4},
	{0x9fca, 0x6dd5},
	{0x9fcb, 0x6dea},
	{0x9fcc, 0x6dee},
	{0x9fcd, 0x6e2d},
	{0x9fce, 0x6e6e},
	{0x9fcf, 0x6e2e},
	{0x9fd0, 0x6e19},
	{0x9fd1, 0x6e72},
	{0x9fd2, 0x6e5f},
	{0x9fd3, 0x6e3e},
	{0x9fd4, 0x6e23},
	{0x9fd5, 0x6e6b},
	{0x9fd6, 0x6e2b},
	{0x9fd7, 0x6e76},
	{0x9fd8, 0x6e4d},
	{0x9fd9, 0x6e1f},
	{0x9fda, 0x6e43},
	{0x9fdb, 0x6e3a},
	{0x9fdc, 0x6e4e},
	{0x9fdd, 0x6e24},
	{0x9fde, 0x6eff},
	{0x9fdf, 0x6e1d},
	{0x9fe0, 0x6e38},
	{0x9fe1, 0x6e82},
	{0x9fe2, 0x6eaa},
	{0x9fe3, 0x6e98},
	{0x9fe4, 0x6ec9},
	{0x9fe5, 0x6eb7},
	{0x9fe6, 0x6ed3},
	{0x9fe7, 0x6ebd},
	{0x9fe8, 0x6eaf},
	{0x9fe9, 0x6ec4},
	{0x9fea, 0x6eb2},
	{0x9feb, 0x6ed4},
	{0x9fec, 0x6ed5},
	{0x9fed, 0x6e8f},
	{0x9fee, 0x6ea5},
	{0x9fef, 0x6ec2},
	{0x9ff0, 0x6e9f},
	{0x9ff1, 0x6f41},
	{0x9ff2, 0x6f11},
	{0x9ff3, 0x704c},
	{0x9ff4, 0x6eec},
	{0x9ff5, 0x6ef8},
	{0x9ff6, 0x6efe},
	{0x9ff7, 0x6f3f},
	{0x9ff8, 0x6ef2},
	{0x9ff9, 0x6f31},
	{0x9ffa, 0x6eef},
	{0x9ffb, 0x6f32},
	{0x9ffc, 0x6ecc},
	{0xe040, 0x6f3e},
	{0xe041, 0x6f13},
	{0xe042, 0x6ef7},
	{0xe043, 0x6f86},
	{0xe044, 0x6f7a},
	{0xe045, 0x6f78},
	{0xe046, 0x6f81},
	{0xe047, 0x6f80},
	{0xe048, 0x6f6f},
	{0xe049, 0x6f5b},
	{0xe04a, 0x6ff3},
	{0xe04b, 0x6f6d},
	{0xe04c, 0x6f82},
	{0xe04d, 0x6f7c},
	{0xe04e, 0x6f58},
	{0xe04f, 0x6f8e},
	{0xe050, 0x6f91},
	{0xe051, 0x6fc2},
	{0xe052, 0x6f66},
	{0xe053, 0x6fb3},
	{0xe054, 0x6fa3},
	{0xe055, 0x6fa1},
	{0xe056, 0x6fa4},
	{0xe057, 0x6fb9},
	{0xe058, 0x6fc6},
	{0xe059, 0x6faa},
	{0xe05a, 0x6fdf},
	{0xe05b, 0x6fd5},
	{0xe05c, 0x6fec},
	{0xe05d, 0x6fd4},
	{0xe05e, 0x6fd8},
	{0xe05f, 0x6ff1},
	{0xe060, 0x6fee},
	{0xe061, 0x6fdb},
	{0xe062, 0x7009},
	{0xe063, 0x700b},
	{0xe064, 0x6ffa},
	{0xe065, 0x7011},
	{0xe066, 0x7001},
	{0xe067, 0x700f},
	{0xe068, 0x6ffe},
	{0xe069, 0x701b},
	{0xe06a, 0x701a},
	{0xe06b, 0x6f74},
	{0xe06c, 0x701d},
	{0xe06d, 0x7018},
	{0xe06e, 0x701f},
	{0xe06f, 0x7030},
	{0xe070, 0x703e},
	{0xe071, 0x7032},
	{0xe072, 0x7051},
	{0xe073, 0x7063},
	{0xe074, 0x7099},
	{0xe075, 0x7092},
	{0xe076, 0x70af},
	{0xe077, 0x70f1},
	{0xe078, 0x70ac},
	{0xe079, 0x70b8},
	{0xe07a, 0x70b3},
	{0xe07b, 0x70ae},
	{0xe07c, 0x70df},
	{0xe07d, 0x70cb},
	{0xe07e, 0x70dd},
	{0xe080, 0x70d9},
	{0xe081, 0x7109},
	{0xe082, 0x70fd},
	{0xe083, 0x711c},
	{0xe084, 0x7119},
	{0xe085, 0x7165},
	{0xe086, 0x7155},
	{0xe087, 0x7188},
	{0xe088, 0x7166},
	{0xe089, 0x7162},
	{0xe08a, 0x714c},
	{0xe08b, 0x7156},
	{0xe08c, 0x716c},
	{0xe08d, 0x718f},
	{0xe08e, 0x71fb},
	{0xe08f, 0x7184},
	{0xe090, 0x7195},
	{0xe091, 0x71a8},
	{0xe092, 0x71ac},
	{0xe093, 0x71d7},
	{0xe094, 0x71b9},
	{0xe095, 0x71be},
	{0xe096, 0x71d2},
	{0xe097, 0x71c9},
	{0xe098, 0x71d4},
	{0xe099, 0x71ce},
	{0xe09a, 0x71e0},
	{0xe09b, 0x71ec},
	{0xe09c, 0x71e7},
	{0xe09d, 0x71f5},
	{0xe09e, 0x71fc},
	{0xe09f, 0x71f9},
	{0xe0a0, 0x71ff},
	{0xe0a1, 0x720d},
	{0xe0a2, 0x7210},
	{0xe0a3, 0x721b},
	{0xe0a4, 0x7228},
	{0xe0a5, 0x722d},
	{0xe0a6, 0x722c},
	{0xe0a7, 0x7230},
	{0xe0a8, 0x7232},
	{0xe0a9, 0x723b},
	{0xe0aa, 0x723c},
	{0xe0ab, 0x723f},
	{0xe0ac, 0x7240},
	{0xe0ad, 0x7246},
	{0xe0ae, 0x724b},
	{0xe0af, 0x7258},
	{0xe0b0, 0x7274},
	{0xe0b1, 0x727e},
	{0xe0b2, 0x7282},
	{0xe0b3, 0x7281},
	{0xe0b4, 0x7287},
	{0xe0b5, 0x7292},
	{0xe0b6, 0x7296},
	{0xe0b7, 0x72a2},
	{0xe0b8, 0x72a7},
	{0xe0b9, 0x72b9},
	{0xe0ba, 0x72b2},
	{0xe0bb, 0x72c3},
	{0xe0bc, 0x72c6},
	{0xe0bd, 0x72c4},
	{0xe0be, 0x72ce},
	{0xe0bf, 0x72d2},
	{0xe0c0, 0x72e2},
	{0xe0c1, 0x72e0},
	{0xe0c2, 0x72e1},
	{0xe0c3, 0x72f9},
	{0xe0c4, 0x72f7},
	{0xe0c5, 0x500f},
	{0xe0c6, 0x7317},
	{0xe0c7, 0x730a},
	{0xe0c8, 0x731c},
	{0xe0c9, 0x7316},
	{0xe0ca, 0x731d},
	{0xe0cb, 0x7334},
	{0xe0cc, 0x732f},
	{0xe0cd, 0x7329},
	{0xe0ce, 0x7325},
	{0xe0cf, 0x733e},
	{0xe0d0, 0x734e},
	{0xe0d1, 0x734f},
	{0xe0d2, 0x9ed8},
	{0xe0d3, 0x7357},
	{0xe0d4, 0x736a},
	{0xe0d5, 0x7368},
	{0xe0d6, 0x7370},
	{0xe0d7, 0x7378},
	{0xe0d8, 0x7375},
	{0xe0d9, 0x737b},
	{0xe0da, 0x737a},
	{0xe0db, 0x73c8},
	{0xe0dc, 0x73b3},
	{0xe0dd, 0x73ce},
	{0xe0de, 0x73bb},
	{0xe0df, 0x73c0},
	{0xe0e0, 0x73e5},
	{0xe0e1, 0x73ee},
	{0xe0e2, 0x73de},
	{0xe0e3, 0x74a2},
	{0xe0e4, 0x7405},
	{0xe0e5, 0x746f},
	{0xe0e6, 0x7425},
	{0xe0e7, 0x73f8},
	{0xe0e8, 0x7432},
	{0xe0e9, 0x743a},
	{0xe0ea, 0x7455},
	{0xe0eb, 0x743f},
	{0xe0ec, 0x745f},
	{0xe0ed, 0x7459},
	{0xe0ee, 0x7441},
	{0xe0ef, 0x745c},
	{0xe0f0, 0x7469},
	{0xe0f1, 0x7470},
	{0xe0f2, 0x7463},
	{0xe0f3, 0x746a},
	{0xe0f4, 0x7476},
	{0xe0f5, 0x747e},
	{0xe0f6, 0x748b},
	{0xe0f7, 0x749e},
	{0xe0f8, 0x74a7},
	{0xe0f9, 0x74ca},
	{0xe0fa, 0x74cf},
	{0xe0fb, 0x74d4},
	{0xe0fc, 0x73f1},
	{0xe140, 0x74e0},
	{0xe141, 0x74e3},
	{0xe142, 0x74e7},
	{0xe143, 0x74e9},
	{0xe144, 0x74ee},
	{0xe145, 0x74f2},
	{0xe146, 0x74f0},
	{0xe147, 0x74f1},
	{0xe148, 0x74f8},
	{0xe149, 0x74f7},
	{0xe14a, 0x7504},
	{0xe14b, 0x7503},
	{0xe14c, 0x7505},
	{0xe14d, 0x750c},
	{0xe14e, 0x750e},
	{0xe14f, 0x750d},
	{0xe150, 0x7515},
	{0xe151, 0x7513},
	{0xe152, 0x751e},
	{0xe153, 0x7526},
	{0xe154, 0x752c},
	{0xe155, 0x753c},
	{0xe156, 0x7544},
	{0xe157, 0x754d},
	{0xe158, 0x754a},
	{0xe159, 0x7549},
	{0xe15a, 0x755b},
	{0xe15b, 0x7546},
	{0xe15c, 0x755a},
	{0xe15d, 0x7569},
	{0xe15e, 0x7564},
	{0xe15f, 0x7567},
	{0xe160, 0x756b},
	{0xe161, 0x756d},
	{0xe162, 0x7578},
	{0xe163, 0x7576},
	{0xe164, 0x7586},
	{0xe165, 0x7587},
	{0xe166, 0x7574},
	{0xe167, 0x758a},
	{0xe168, 0x7589},
	{0xe169, 0x7582},
	{0xe16a, 0x7594},
	{0xe16b, 0x759a},
	{0xe16c, 0x759d},
	{0xe16d, 0x75a5},
	{0xe16e, 0x75a3},
	{0xe16f, 0x75c2},
	{0xe170, 0x75b3},
	{0xe171, 0x75c3},
	{0xe172, 0x75b5},
	{0xe173, 0x75bd},
	{0xe174, 0x75b8},
	{0xe175, 0x75bc},
	{0xe176, 0x75b1},
	{0xe177, 0x75cd},
	{0xe178, 0x75ca},
	{0xe179, 0x75d2},
	{0xe17a, 0x75d9},
	{0xe17b, 0x75e3},
	{0xe17c, 0x75de},
	{0xe17d, 0x75fe},
	{0xe17e, 0x75ff},
	{0xe180, 0x75fc},
	{0xe181, 0x7601},
	{0xe182, 0x75f0},
	{0xe183, 0x75fa},
	{0xe184, 0x75f2},
	{0xe185, 0x75f3},
	{0xe186, 0x760b},
	{0xe187, 0x760d},
	{0xe188, 0x7609},
	{0xe189, 0x761f},
	{0xe18a, 0x7627},
	{0xe18b, 0x7620},
	{0xe18c, 0x7621},
	{0xe18d, 0x7622},
	{0xe18e, 0x7624},
	{0xe18f, 0x7634},
	{0xe190, 0x7630},
	{0xe191, 0x763b},
	{0xe192, 0x7647},
	{0xe193, 0x7648},
	{0xe194, 0x7646},
	{0xe195, 0x765c},
	{0xe196, 0x7658},
	{0xe197, 0x7661},
	{0xe198, 0x7662},
	{0xe199, 0x7668},
	{0xe19a, 0x7669},
	{0xe19b, 0x766a},
	{0xe19c, 0x7667},
	{0xe19d, 0x766c},
	{0xe19e, 0x7670},
	{0xe19f, 0x7672},
	{0xe1a0, 0x7676},
	{0xe1a1, 0x7678},
	{0xe1a2, 0x767c},
	{0xe1a3, 0x7680},
	{0xe1a4, 0x7683},
	{0xe1a5, 0x7688},
	{0xe1a6, 0x768b},
	{0xe1a7, 0x768e},
	{0xe1a8, 0x7696},
	{0xe1a9, 0x7693},
	{0xe1aa, 0x7699},
	{0xe1ab, 0x769a},
	{0xe1ac, 0x76b0},
	{0xe1ad, 0x76b4},
	{0xe1ae, 0x76b8},
	{0xe1af, 0x76b9},
	{0xe1b0, 0x76ba},
	{0xe1b1, 0x76c2},
	{0xe1b2, 0x76cd},
	{0xe1b3, 0x76d6},
	{0xe1b4, 0x76d2},
	{0xe1b5, 0x76de},
	{0xe1b6, 0x76e1},
	{0xe1b7, 0x76e5},
	{0xe1b8, 0x76e7},
	{0xe1b9, 0x76ea},
	{0xe1ba, 0x862f},
	{0xe1bb, 0x76fb},
	{0xe1bc, 0x7708},
	{0xe1bd, 0x7707},
	{0xe1be, 0x7704},
	{0xe1bf, 0x7729},
	{0xe1c0, 0x7724},
	{0xe1c1, 0x771e},
	{0xe1c2, 0x7725},
	{0xe1c3, 0x7726},
	{0xe1c4, 0x771b},
	{0xe1c5, 0x7737},
	{0xe1c6, 0x7738},
	{0xe1c7, 0x7747},
	{0xe1c8, 0x775a},
	{0xe1c9, 0x7768},
	{0xe1ca, 0x776b},
	{0xe1cb, 0x775b},
	{0xe1cc, 0x7765},
	{0xe1cd, 0x777f},
	{0xe1ce, 0x777e},
	{0xe1cf, 0x7779},
	{0xe1d0, 0x778e},
	{0xe1d1, 0x778b},
	{0xe1d2, 0x7791},
	{0xe1d3, 0x77a0},
	{0xe1d4, 0x779e},
	{0xe1d5, 0x77b0},
	{0xe1d6, 0x77b6},
	{0xe1d7, 0x77b9},
	{0xe1d8, 0x77bf},
	{0xe1d9, 0x77bc},
	{0xe1da, 0x77bd},
	{0xe1db, 0x77bb},
	{0xe1dc, 0x77c7},
	{0xe1dd, 0x77cd},
	{0xe1de, 0x77d7},
	{0xe1df, 0x77da},
	{0xe1e0, 0x77dc},
	{0xe1e1, 0x77e3},
	{0xe1e2, 0x77ee},
	{0xe1e3, 0x77fc},
	{0xe1e4, 0x780c},
	{0xe1e5, 0x7812},
	{0xe1e6, 0x7926},
	{0xe1e7, 0x7820},
	{0xe1e8, 0x792a},
	{0xe1e9, 0x7845},
	{0xe1ea, 0x788e},
	{0xe1eb, 0x7874},
	{0xe1ec, 0x7886},
	{0xe1ed, 0x787c},
	{0xe1ee, 0x789a},
	{0xe1ef, 0x788c},
	{0xe1f0, 0x78a3},
	{0xe1f1, 0x78b5},
	{0xe1f2, 0x78aa},
	{0xe1f3, 0x78af},
	{0xe1f4, 0x78d1},
	{0xe1f5, 0x78c6},
	{0xe1f6, 0x78cb},
	{0xe1f7, 0x78d4},
	{0xe1f8, 0x78be},
	{0xe1f9, 0x78bc},
	{0xe1fa, 0x78c5},
	{0xe1fb, 0x78ca},
	{0xe1fc, 0x78ec},
	{0xe240, 0x78e7},
	{0xe241, 0x78da},
	{0xe242, 0x78fd},
	{0xe243, 0x78f4},
	{0xe244, 0x7907},
	{0xe245, 0x7912},
	{0xe246, 0x7911},
	{0xe247, 0x7919},
	{0xe248, 0x792c},
	{0xe249, 0x792b},
	{0xe24a, 0x7940},
	{0xe24b, 0x7960},
	{0xe24c, 0x7957},
	{0xe24d, 0x795f},
	{0xe24e, 0x795a},
	{0xe24f, 0x7955},
	{0xe250, 0x7953},
	{0xe251, 0x797a},
	{0xe252, 0x797f},
	{0xe253, 0x798a},
	{0xe254, 0x799d},
	{0xe255, 0x79a7},
	{0xe256, 0x9f4b},
	{0xe257, 0x79aa},
	{0xe258, 0x79ae},
	{0xe259, 0x79b3},
	{0xe25a, 0x79b9},
	{0xe25b, 0x79ba},
	{0xe25c, 0x79c9},
	{0xe25d, 0x79d5},
	{0xe25e, 0x79e7},
	{0xe25f, 0x79ec},
	{0xe260, 0x79e1},
	{0xe261, 0x79e3},
	{0xe262, 0x7a08},
	{0xe263, 0x7a0d},
	{0xe264, 0x7a18},
	{0xe265, 0x7a19},
	{0xe266, 0x7a20},
	{0xe267, 0x7a1f},
	{0xe268, 0x7980},
	{0xe269, 0x7a31},
	{0xe26a, 0x7a3b},
	{0xe26b, 0x7a3e},
	{0xe26c, 0x7a37},
	{0xe26d, 0x7a43},
	{0xe26e, 0x7a57},
	{0xe26f, 0x7a49},
	{0xe270, 0x7a61},
	{0xe271, 0x7a62},
	{0xe272, 0x7a69},
	{0xe273, 0x9f9d},
	{0xe274, 0x7a70},
	{0xe275, 0x7a79},
	{0xe276, 0x7a7d},
	{0xe277, 0x7a88},
	{0xe278, 0x7a97},
	{0xe279, 0x7a95},
	{0xe27a, 0x7a98},
	{0xe27b, 0x7a96},
	{0xe27c, 0x7aa9},
	{0xe27d, 0x7ac8},
	{0xe27e, 0x7ab0},
	{0xe280, 0x7ab6},
	{0xe281, 0x7ac5},
	{0xe282, 0x7ac4},
	{0xe283, 0x7abf},
	{0xe284, 0x9083},
	{0xe285, 0x7ac7},
	{0xe286, 0x7aca},
	{0xe287, 0x7acd},
	{0xe288, 0x7acf},
	{0xe289, 0x7ad5},
	{0xe28a, 0x7ad3},
	{0xe28b, 0x7ad9},
	{0xe28c, 0x7ada},
	{0xe28d, 0x7add},
	{0xe28e, 0x7ae1},
	{0xe28f, 0x7ae2},
	{0xe290, 0x7ae6},
	{0xe291, 0x7aed},
	{0xe292, 0x7af0},
	{0xe293, 0x7b02},
	{0xe294, 0x7b0f},
	{0xe295, 0x7b0a},
	{0xe296, 0x7b06},
	{0xe297, 0x7b33},
	{0xe298, 0x7b18},
	{0xe299, 0x7b19},
	{0xe29a, 0x7b1e},
	{0xe29b, 0x7b35},
	{0xe29c, 0x7b28},
	{0xe29d, 0x7b36},
	{0xe29e, 0x7b50},
	{0xe29f, 0x7b7a},
	{0xe2a0, 0x7b04},
	{0xe2a1, 0x7b4d},
	{0xe2a2, 0x7b0b},
	{0xe2a3, 0x7b4c},
	{0xe2a4, 0x7b45},
	{0xe2a5, 0x7b75},
	{0xe2a6, 0x7b65},
	{0xe2a7, 0x7b74},
	{0xe2a8, 0x7b67},
	{0xe2a9, 0x7b70},
	{0xe2aa, 0x7b71},
	{0xe2ab, 0x7b6c},
	{0xe2ac, 0x7b6e},
	{0xe2ad, 0x7b9d},
	{0xe2ae, 0x7b98},
	{0xe2af, 0x7b9f},
	{0xe2b0, 0x7b8d},
	{0xe2b1, 0x7b9c},
	{0xe2b2, 0x7b9a},
	{0xe2b3, 0x7b8b},
	{0xe2b4, 0x7b92},
	{0xe2b5, 0x7b8f},
	{0xe2b6, 0x7b5d},
	{0xe2b7, 0x7b99},
	{0xe2b8, 0x7bcb},
	{0xe2b9, 0x7bc1},
	{0xe2ba, 0x7bcc},
	{0xe2bb, 0x7bcf},
	{0xe2bc, 0x7bb4},
	{0xe2bd, 0x7bc6},
	{0xe2be, 0x7bdd},
	{0xe2bf, 0x7be9},
	{0xe2c0, 0x7c11},
	{0xe2c1, 0x7c14},
	{0xe2c2, 0x7be6},
	{0xe2c3, 0x7be5},
	{0xe2c4, 0x7c60},
	{0xe2c5, 0x7c00},
	{0xe2c6, 0x7c07},
	{0xe2c7, 0x7c13},
	{0xe2c8, 0x7bf3},
	{0xe2c9, 0x7bf7},
	{0xe2ca, 0x7c17},
	{0xe2cb, 0x7c0d},
	{0xe2cc, 0x7bf6},
	{0xe2cd, 0x7c23},
	{0xe2ce, 0x7c27},
	{0xe2cf, 0x7c2a},
	{0xe2d0, 0x7c1f},
	{0xe2d1, 0x7c37},
	{0xe2d2, 0x7c2b},
	{0xe2d3, 0x7c3d},
	{0xe2d4, 0x7c4c},
	{0xe2d5, 0x7c43},
	{0xe2d6, 0x7c54},
	{0xe2d7, 0x7c4f},
	{0xe2d8, 0x7c40},
	{0xe2d9, 0x7c50},
	{0xe2da, 0x7c58},
	{0xe2db, 0x7c5f},
	{0xe2dc, 0x7c64},
	{0xe2dd, 0x7c56},
	{0xe2de, 0x7c65},
	{0xe2df, 0x7c6c},
	{0xe2e0, 0x7c75},
	{0xe2e1, 0x7c83},
	{0xe2e2, 0x7c90},
	{0xe2e3, 0x7ca4},
	{0xe2e4, 0x7cad},
	{0xe2e5, 0x7ca2},
	{0xe2e6, 0x7cab},
	{0xe2e7, 0x7ca1},
	{0xe2e8, 0x7ca8},
	{0xe2e9, 0x7cb3},
	{0xe2ea, 0x7cb2},
	{0xe2eb, 0x7cb1},
	{0xe2ec, 0x7cae},
	{0xe2ed, 0x7cb9},
	{0xe2ee, 0x7cbd},
	{0xe2ef, 0x7cc0},
	{0xe2f0, 0x7cc5},
	{0xe2f1, 0x7cc2},
	{0xe2f2, 0x7cd8},
	{0xe2f3, 0x7cd2},
	{0xe2f4, 0x7cdc},
	{0xe2f5, 0x7ce2},
	{0xe2f6, 0x9b3b},
	{0xe2f7, 0x7cef},
	{0xe2f8, 0x7cf2},
	{0xe2f9, 0x7cf4},
	{0xe2fa, 0x7cf6},
	{0xe2fb, 0x7cfa},
	{0xe2fc, 0x7d06},
	{0xe340, 0x7d02},
	{0xe341, 0x7d1c},
	{0xe342, 0x7d15},
	{0xe343, 0x7d0a},
	{0xe344, 0x7d45},
	{0xe345, 0x7d4b},
	{0xe346, 0x7d2e},
	{0xe347, 0x7d32},
	{0xe348, 0x7d3f},
	{0xe349, 0x7d35},
	{0xe34a, 0x7d46},
	{0xe34b, 0x7d73},
	{0xe34c, 0x7d56},
	{0xe34d, 0x7d4e},
	{0xe34e, 0x7d72},
	{0xe34f, 0x7d68},
	{0xe350, 0x7d6e},
	{0xe351, 0x7d4f},
	{0xe352, 0x7d63},
	{0xe353, 0x7d93},
	{0xe354, 0x7d89},
	{0xe355, 0x7d5b},
	{0xe356, 0x7d8f},
	{0xe357, 0x7d7d},
	{0xe358, 0x7d9b},
	{0xe359, 0x7dba},
	{0xe35a, 0x7dae},
	{0xe35b, 0x7da3},
	{0xe35c, 0x7db5},
	{0xe35d, 0x7dc7},
	{0xe35e, 0x7dbd},
	{0xe35f, 0x7dab},
	{0xe360, 0x7e3d},
	{0xe361, 0x7da2},
	{0xe362, 0x7daf},
	{0xe363, 0x7ddc},
	{0xe364, 0x7db8},
	{0xe365, 0x7d9f},
	{0xe366, 0x7db0},
	{0xe367, 0x7dd8},
	{0xe368, 0x7ddd},
	{0xe369, 0x7de4},
	{0xe36a, 0x7dde},
	{0xe36b, 0x7dfb},
	{0xe36c, 0x7df2},
	{0xe36d, 0x7de1},
	{0xe36e, 0x7e05},
	{0xe36f, 0x7e0a},
	{0xe370, 0x7e23},
	{0xe371, 0x7e21},
	{0xe372, 0x7e12},
	{0xe373, 0x7e31},
	{0xe374, 0x7e1f},
	{0xe375, 0x7e09},
	{0xe376, 0x7e0b},
	{0xe377, 0x7e22},
	{0xe378, 0x7e46},
	{0xe379, 0x7e66},
	{0xe37a, 0x7e3b},
	{0xe37b, 0x7e35},
	{0xe37c, 0x7e39},
	{0xe37d, 0x7e43},
	{0xe37e, 0x7e37},
	{0xe380, 0x7e32},
	{0xe381, 0x7e3a},
	{0xe382, 0x7e67},
	{0xe383, 0x7e5d},
	{0xe384, 0x7e56},
	{0xe385, 0x7e5e},
	{0xe386, 0x7e59},
	{0xe387, 0x7e5a},
	{0xe388, 0x7e79},
	{0xe389, 0x7e6a},
	{0xe38a, 0x7e69},
	{0xe38b, 0x7e7c},
	{0xe38c, 0x7e7b},
	{0xe38d, 0x7e83},
	{0xe38e, 0x7dd5},
	{0xe38f, 0x7e7d},
	{0xe390, 0x8fae},
	{0xe391, 0x7e7f},
	{0xe392, 0x7e88},
	{0xe393, 0x7e89},
	{0xe394, 0x7e8c},
	{0xe395, 0x7e92},
	{0xe396, 0x7e90},
	{0xe397, 0x7e93},
	{0xe398, 0x7e94},
	{0xe399, 0x7e96},
	{0xe39a, 0x7e8e},
	{0xe39b, 0x7e9b},
	{0xe39c, 0x7e9c},
	{0xe39d, 0x7f38},
	{0xe39e, 0x7f3a},
	{0xe39f, 0x7f45},
	{0xe3a0, 0x7f4c},
	{0xe3a1, 0x7f4d},
	{0xe3a2, 0x7f4e},
	{0xe3a3, 0x7f50},
	{0xe3a4, 0x7f51},
	{0xe3a5, 0x7f55},
	{0xe3a6, 0x7f54},
	{0xe3a7, 0x7f58},
	{0xe3a8, 0x7f5f},
	{0xe3a9, 0x7f60},
	{0xe3aa, 0x7f68},
	{0xe3ab, 0x7f69},
	{0xe3ac, 0x7f67},
	{0xe3ad, 0x7f78},
	{0xe3ae, 0x7f82},
	{0xe3af, 0x7f86},
	{0xe3b0, 0x7f83},
	{0xe3b1, 0x7f88},
	{0xe3b2, 0x7f87},
	{0xe3b3, 0x7f8c},
	{0xe3b4, 0x7f94},
	{0xe3b5, 0x7f9e},
	{0xe3b6, 0x7f9d},
	{0xe3b7, 0x7f9a},
	{0xe3b8, 0x7fa3},
	{0xe3b9, 0x7faf},
	{0xe3ba, 0x7fb2},
	{0xe3bb, 0x7fb9},
	{0xe3bc, 0x7fae},
	{0xe3bd, 0x7fb6},
	{0xe3be, 0x7fb8},
	{0xe3bf, 0x8b71},
	{0xe3c0, 0x7fc5},
	{0xe3c1, 0x7fc6},
	{0xe3c2, 0x7fca},
	{0xe3c3, 0x7fd5},
	{0xe3c4, 0x7fd4},
	{0xe3c5, 0x7fe1},
	{0xe3c6, 0x7fe6},
	{0xe3c7, 0x7fe9},
	{0xe3c8, 0x7ff3},
	{0xe3c9, 0x7ff9},
	{0xe3ca, 0x98dc},
	{0xe3cb, 0x8006},
	{0xe3cc, 0x8004},
	{0xe3cd, 0x800b},
	{0xe3ce, 0x8012},
	{0xe3cf, 0x8018},
	{0xe3d0, 0x8019},
	{0xe3d1, 0x801c},
	{0xe3d2, 0x8021},
	{0xe3d3, 0x8028},
	{0xe3d4, 0x803f},
	{0xe3d5, 0x803b},
	{0xe3d6, 0x804a},
	{0xe3d7, 0x8046},
	{0xe3d8, 0x8052},
	{0xe3d9, 0x8058},
	{0xe3da, 0x805a},
	{0xe3db, 0x805f},
	{0xe3dc, 0x8062},
	{0xe3dd, 0x8068},
	{0xe3de, 0x8073},
	{0xe3df, 0x8072},
	{0xe3e0, 0x8070},
	{0xe3e1, 0x8076},
	{0xe3e2, 0x8079},
	{0xe3e3, 0x807d},
	{0xe3e4, 0x807f},
	{0xe3e5, 0x8084},
	{0xe3e6, 0x8086},
	{0xe3e7, 0x8085},
	{0xe3e8, 0x809b},
	{0xe3e9, 0x8093},
	{0xe3ea, 0x809a},
	{0xe3eb, 0x80ad},
	{0xe3ec, 0x5190},
	{0xe3ed, 0x80ac},
	{0xe3ee, 0x80db},
	{0xe3ef, 0x80e5},
	{0xe3f0, 0x80d9},
	{0xe3f1, 0x80dd},
	{0xe3f2, 0x80c4},
	{0xe3f3, 0x80da},
	{0xe3f4, 0x80d6},
	{0xe3f5, 0x8109},
	{0xe3f6, 0x80ef},
	{0xe3f7, 0x80f1},
	{0xe3f8, 0x811b},
	{0xe3f9, 0x8129},
	{0xe3fa, 0x8123},
	{0xe3fb, 0x812f},
	{0xe3fc, 0x814b},
	{0xe440, 0x968b},
	{0xe441, 0x8146},
	{0xe442, 0x813e},
	{0xe443, 0x8153},
	{0xe444, 0x8151},
	{0xe445, 0x80fc},
	{0xe446, 0x8171},
	{0xe447, 0x816e},
	{0xe448, 0x8165},
	{0xe449, 0x8166},
	{0xe44a, 0x8174},
	{0xe44b, 0x8183},
	{0xe44c, 0x8188},
	{0xe44d, 0x818a},
	{0xe44e, 0x8180},
	{0xe44f, 0x8182},
	{0xe450, 0x81a0},
	{0xe451, 0x8195},
	{0xe452, 0x81a4},
	{0xe453, 0x81a3},
	{0xe454, 0x815f},
	{0xe455, 0x8193},
	{0xe456, 0x81a9},
	{0xe457, 0x81b0},
	{0xe458, 0x81b5},
	{0xe459, 0x81be},
	{0xe45a, 0x81b8},
	{0xe45b, 0x81bd},
	{0xe45c, 0x81c0},
	{0xe45d, 0x81c2},
	{0xe45e, 0x81ba},
	{0xe45f, 0x81c9},
	{0xe460, 0x81cd},
	{0xe461, 0x81d1},
	{0xe462, 0x81d9},
	{0xe463, 0x81d8},
	{0xe464, 0x81c8},
	{0xe465, 0x81da},
	{0xe466, 0x81df},
	{0xe467, 0x81e0},
	{0xe468, 0x81e7},
	{0xe469, 0x81fa},
	{0xe46a, 0x81fb},
	{0xe46b, 0x81fe},
	{0xe46c, 0x8201},
	{0xe46d, 0x8202},
	{0xe46e, 0x8205},
	{0xe46f, 0x8207},
	{0xe470, 0x820a},
	{0xe471, 0x820d},
	{0xe472, 0x8210},
	{0xe473, 0x8216},
	{0xe474, 0x8229},
	{0xe475, 0x822b},
	{0xe476, 0x8238},
	{0xe477, 0x8233},
	{0xe478, 0x8240},
	{0xe479, 0x8259},
	{0xe47a, 0x8258},
	{0xe47b, 0x825d},
	{0xe47c, 0x825a},
	{0xe47d, 0x825f},
	{0xe47e, 0x8264},
	{0xe480, 0x8262},
	{0xe481, 0x8268},
	{0xe482, 0x826a},
	{0xe483, 0x826b},
	{0xe484, 0x822e},
	{0xe485, 0x8271},
	{0xe486, 0x8277},
	{0xe487, 0x8278},
	{0xe488, 0x827e},
	{0xe489, 0x828d},
	{0xe48a, 0x8292},
	{0xe48b, 0x82ab},
	{0xe48c, 0x829f},
	{0xe48d, 0x82bb},
	{0xe48e, 0x82ac},
	{0xe48f, 0x82e1},
	{0xe490, 0x82e3},
	{0xe491, 0x82df},
	{0xe492, 0x82d2},
	{0xe493, 0x82f4},
	{0xe494, 0x82f3},
	{0xe495, 0x82fa},
	{0xe496, 0x8393},
	{0xe497, 0x8303},
	{0xe498, 0x82fb},
	{0xe499, 0x82f9},
	{0xe49a, 0x82de},
	{0xe49b, 0x8306},
	{0xe49c, 0x82dc},
	{0xe49d, 0x8309},
	{0xe49e, 0x82d9},
	{0xe49f, 0x8335},
	{0xe4a0, 0x8334},
	{0xe4a1, 0x8316},
	{0xe4a2, 0x8332},
	{0xe4a3, 0x8331},
	{0xe4a4, 0x8340},
	{0xe4a5, 0x8339},
	{0xe4a6, 0x8350},
	{0xe4a7, 0x8345},
	{0xe4a8, 0x832f},
	{0xe4a9, 0x832b},
	{0xe4aa, 0x8317},
	{0xe4ab, 0x8318},
	{0xe4ac, 0x8385},
	{0xe4ad, 0x839a},
	{0xe4ae, 0x83aa},
	{0xe4af, 0x839f},
	{0xe4b0, 0x83a2},
	{0xe4b1, 0x8396},
	{0xe4b2, 0x8323},
	{0xe4b3, 0x838e},
	{0xe4b4, 0x8387},
	{0xe4b5, 0x838a},
	{0xe4b6, 0x837c},
	{0xe4b7, 0x83b5},
	{0xe4b8, 0x8373},
	{0xe4b9, 0x8375},
	{0xe4ba, 0x83a0},
	{0xe4bb, 0x8389},
	{0xe4bc, 0x83a8},
	{0xe4bd, 0x83f4},
	{0xe4be, 0x8413},
	{0xe4bf, 0x83eb},
	{0xe4c0, 0x83ce},
	{0xe4c1, 0x83fd},
	{0xe4c2, 0x8403},
	{0xe4c3, 0x83d8},
	{0xe4c4, 0x840b},
	{0xe4c5, 0x83c1},
	{0xe4c6, 0x83f7},
	{0xe4c7, 0x8407},
	{0xe4c8, 0x83e0},
	{0xe4c9, 0x83f2},
	{0xe4ca, 0x840d},
	{0xe4cb, 0x8422},
	{0xe4cc, 0x8420},
	{0xe4cd, 0x83bd},
	{0xe4ce, 0x8438},
	{0xe4cf, 0x8506},
	{0xe4d0, 0x83fb},
	{0xe4d1, 0x846d},
	{0xe4d2, 0x842a},
	{0xe4d3, 0x843c},
	{0xe4d4, 0x855a},
	{0xe4d5, 0x8484},
	{0xe4d6, 0x8477},
	{0xe4d7, 0x846b},
	{0xe4d8, 0x84ad},
	{0xe4d9, 0x846e},
	{0xe4da, 0x8482},
	{0xe4db, 0x8469},
	{0xe4dc, 0x8446},
	{0xe4dd, 0x842c},
	{0xe4de, 0x846f},
	{0xe4df, 0x8479},
	{0xe4e0, 0x8435},
	{0xe4e1, 0x84ca},
	{0xe4e2, 0x8462},
	{0xe4e3, 0x84b9},
	{0xe4e4, 0x84bf},
	{0xe4e5, 0x849f},
	{0xe4e6, 0x84d9},
	{0xe4e7, 0x84cd},
	{0xe4e8, 0x84bb},
	{0xe4e9, 0x84da},
	{0xe4ea, 0x84d0},
	{0xe4eb, 0x84c1},
	{0xe4ec, 0x84c6},
	{0xe4ed, 0x84d6},
	{0xe4ee, 0x84a1},
	{0xe4ef, 0x8521},
	{0xe4f0, 0x84ff},
	{0xe4f1, 0x84f4},
	{0xe4f2, 0x8517},
	{0xe4f3, 0x8518},
	{0xe4f4, 0x852c},
	{0xe4f5, 0x851f},
	{0xe4f6, 0x8515},
	{0xe4f7, 0x8514},
	{0xe4f8, 0x84fc},
	{0xe4f9, 0x8540},
	{0xe4fa, 0x8563},
	{0xe4fb, 0x8558},
	{0xe4fc, 0x8548},
	{0xe540, 0x8541},
	{0xe541, 0x8602},
	{0xe542, 0x854b},
	{0xe543, 0x8555},
	{0xe544, 0x8580},
	{0xe545, 0x85a4},
	{0xe546, 0x8588},
	{0xe547, 0x8591},
	{0xe548, 0x858a},
	{0xe549, 0x85a8},
	{0xe54a, 0x856d},
	{0xe54b, 0x8594},
	{0xe54c, 0x859b},
	{0xe54d, 0x85ea},
	{0xe54e, 0x8587},
	{0xe54f, 0x859c},
	{0xe550, 0x8577},
	{0xe551, 0x857e},
	{0xe552, 0x8590},
	{0xe553, 0x85c9},
	{0xe554, 0x85ba},
	{0xe555, 0x85cf},
	{0xe556, 0x85b9},
	{0xe557, 0x85d0},
	{0xe558, 0x85d5},
	{0xe559, 0x85dd},
	{0xe55a, 0x85e5},
	{0xe55b, 0x85dc},
	{0xe55c, 0x85f9},
	{0xe55d, 0x860a},
	{0xe55e, 0x8613},
	{0xe55f, 0x860b},
	{0xe560, 0x85fe},
	{0xe561, 0x85fa},
	{0xe562, 0x8606},
	{0xe563, 0x8622},
	{0xe564, 0x861a},
	{0xe565, 0x8630},
	{0xe566, 0x863f},
	{0xe567, 0x864d},
	{0xe568, 0x4e55},
	{0xe569, 0x8654},
	{0xe56a, 0x865f},
	{0xe56b, 0x8667},
	{0xe56c, 0x8671},
	{0xe56d, 0x8693},
	{0xe56e, 0x86a3},
	{0xe56f, 0x86a9},
	{0xe570, 0x86aa},
	{0xe571, 0x868b},
	{0xe572, 0x868c},
	{0xe573, 0x86b6},
	{0xe574, 0x86af},
	{0xe575, 0x86c4},
	{0xe576, 0x86c6},
	{0xe577, 0x86b0},
	{0xe578, 0x86c9},
	{0xe579, 0x8823},
	{0xe57a, 0x86ab},
	{0xe57b, 0x86d4},
	{0xe57c, 0x86de},
	{0xe57d, 0x86e9},
	{0xe57e, 0x86ec},
	{0xe580, 0x86df},
	{0xe581, 0x86db},
	{0xe582, 0x86ef},
	{0xe583, 0x8712},
	{0xe584, 0x8706},
	{0xe585, 0x8708},
	{0xe586, 0x8700},
	{0xe587, 0x8703},
	{0xe588, 0x86fb},
	{0xe589, 0x8711},
	{0xe58a, 0x8709},
	{0xe58b, 0x870d},
	{0xe58c, 0x86f9},
	{0xe58d, 0x870a},
	{0xe58e, 0x8734},
	{0xe58f, 0x873f},
	{0xe590, 0x8737},
	{0xe591, 0x873b},
	{0xe592, 0x8725},
	{0xe593, 0x8729},
	{0xe594, 0x871a},
	{0xe595, 0x8760},
	{0xe596, 0x875f},
	{0xe597, 0x8778},
	{0xe598, 0x874c},
	{0xe599, 0x874e},
	{0xe59a, 0x8774},
	{0xe59b, 0x8757},
	{0xe59c, 0x8768},
	{0xe59d, 0x876e},
	{0xe59e, 0x8759},
	{0xe59f, 0x8753},
	{0xe5a0, 0x8763},
	{0xe5a1, 0x876a},
	{0xe5a2, 0x8805},
	{0xe5a3, 0x87a2},
	{0xe5a4, 0x879f},
	{0xe5a5, 0x8782},
	{0xe5a6, 0x87af},
	{0xe5a7, 0x87cb},
	{0xe5a8, 0x87bd},
	{0xe5a9, 0x87c0},
	{0xe5aa, 0x87d0},
	{0xe5ab, 0x96d6},
	{0xe5ac, 0x87ab},
	{0xe5ad, 0x87c4},
	{0xe5ae, 0x87b3},
	{0xe5af, 0x87c7},
	{0xe5b0, 0x87c6},
	{0xe5b1, 0x87bb},
	{0xe5b2, 0x87ef},
	{0xe5b3, 0x87f2},
	{0xe5b4, 0x87e0},
	{0xe5b5, 0x880f},
	{0xe5b6, 0x880d},
	{0xe5b7, 0x87fe},
	{0xe5b8, 0x87f6},
	{0xe5b9, 0x87f7},
	{0xe5ba, 0x880e},
	{0xe5bb, 0x87d2},
	{0xe5bc, 0x8811},
	{0xe5bd, 0x8816},
	{0xe5be, 0x8815},
	{0xe5bf, 0x8822},
	{0xe5c0, 0x8821},
	{0xe5c1, 0x8831},
	{0xe5c2, 0x8836},
	{0xe5c3, 0x8839},
	{0xe5c4, 0x8827},
	{0xe5c5, 0x883b},
	{0xe5c6, 0x8844},
	{0xe5c7, 0x8842},
	{0xe5c8, 0x8852},
	{0xe5c9, 0x8859},
	{0xe5ca, 0x885e},
	{0xe5cb, 0x8862},
	{0xe5cc, 0x886b},
	{0xe5cd, 0x8881},
	{0xe5ce, 0x887e},
	{0xe5cf, 0x889e},
	{0xe5d0, 0x8875},
	{0xe5d1, 0x887d},
	{0xe5d2, 0x88b5},
	{0xe5d3, 0x8872},
	{0xe5d4, 0x8882},
	{0xe5d5, 0x8897},
	{0xe5d6, 0x8892},
	{0xe5d7, 0x88ae},
	{0xe5d8, 0x8899},
	{0xe5d9, 0x88a2},
	{0xe5da, 0x888d},
	{0xe5db, 0x88a4},
	{0xe5dc, 0x88b0},
	{0xe5dd, 0x88bf},
	{0xe5de, 0x88b1},
	{0xe5df, 0x88c3},
	{0xe5e0, 0x88c4},
	{0xe5e1, 0x88d4},
	{0xe5e2, 0x88d8},
	{0xe5e3, 0x88d9},
	{0xe5e4, 0x88dd},
	{0xe5e5, 0x88f9},
	{0xe5e6, 0x8902},
	{0xe5e7, 0x88fc},
	{0xe5e8, 0x88f4},
	{0xe5e9, 0x88e8},
	{0xe5ea, 0x88f2},
	{0xe5eb, 0x8904},
	{0xe5ec, 0x890c},
	{0xe5ed, 0x890a},
	{0xe5ee, 0x8913},
	{0xe5ef, 0x8943},
	{0xe5f0, 0x891e},
	{0xe5f1, 0x8925},
	{0xe5f2, 0x892a},
	{0xe5f3, 0x892b},
	{0xe5f4, 0x8941},
	{0xe5f5, 0x8944},
	{0xe5f6, 0x893b},
	{0xe5f7, 0x8936},
	{0xe5f8, 0x8938},
	{0xe5f9, 0x894c},
	{0xe5fa, 0x891d},
	{0xe5fb, 0x8960},
	{0xe5fc, 0x895e},
	{0xe640, 0x8966},
	{0xe641, 0x8964},
	{0xe642, 0x896d},
	{0xe643, 0x896a},
	{0xe644, 0x896f},
	{0xe645, 0x8974},
	{0xe646, 0x8977},
	{0xe647, 0x897e},
	{0xe648, 0x8983},
	{0xe649, 0x8988},
	{0xe64a, 0x898a},
	{0xe64b, 0x8993},
	{0xe64c, 0x8998},
	{0xe64d, 0x89a1},
	{0xe64e, 0x89a9},
	{0xe64f, 0x89a6},
	{0xe650, 0x89ac},
	{0xe651, 0x89af},
	{0xe652, 0x89b2},
	{0xe653, 0x89ba},
	{0xe654, 0x89bd},
	{0xe655, 0x89bf},
	{0xe656, 0x89c0},
	{0xe657, 0x89da},
	{0xe658, 0x89dc},
	{0xe659, 0x89dd},
	{0xe65a, 0x89e7},
	{0xe65b, 0x89f4},
	{0xe65c, 0x89f8},
	{0xe65d, 0x8a03},
	{0xe65e, 0x8a16},
	{0xe65f, 0x8a10},
	{0xe660, 0x8a0c},
	{0xe661, 0x8a1b},
	{0xe662, 0x8a1d},
	{0xe663, 0x8a25},
	{0xe664, 0x8a36},
	{0xe665, 0x8a41},
	{0xe666, 0x8a5b},
	{0xe667, 0x8a52},
	{0xe668, 0x8a46},
	{0xe669, 0x8a48},
	{0xe66a, 0x8a7c},
	{0xe66b, 0x8a6d},
	{0xe66c, 0x8a6c},
	{0xe66d, 0x8a62},
	{0xe66e, 0x8a85},
	{0xe66f, 0x8a82},
	{0xe670, 0x8a84},
	{0xe671, 0x8aa8},
	{0xe672, 0x8aa1},
	{0xe673, 0x8a91},
	{0xe674, 0x8aa5},
	{0xe675, 0x8aa6},
	{0xe676, 0x8a9a},
	{0xe677, 0x8aa3},
	{0xe678, 0x8ac4},
	{0xe679, 0x8acd},
	{0xe67a, 0x8ac2},
	{0xe67b, 0x8ada},
	{0xe67c, 0x8aeb},
	{0xe67d, 0x8af3},
	{0xe67e, 0x8ae7},
	{0xe680, 0x8ae4},
	{0xe681, 0x8af1},
	{0xe682, 0x8b14},
	{0xe683, 0x8ae0},
	{0xe684, 0x8ae2},
	{0xe685, 0x8af7},
	{0xe686, 0x8ade},
	{0xe687, 0x8adb},
	{0xe688, 0x8b0c},
	{0xe689, 0x8b07},
	{0xe68a, 0x8b1a},
	{0xe68b, 0x8ae1},
	{0xe68c, 0x8b16},
	{0xe68d, 0x8b10},
	{0xe68e, 0x8b17},
	{0xe68f, 0x8b20},
	{0xe690, 0x8b33},
	{0xe691, 0x97ab},
	{0xe692, 0x8b26},
	{0xe693, 0x8b2b},
	{0xe694, 0x8b3e},
	{0xe695, 0x8b28},
	{0xe696, 0x8b41},
	{0xe697, 0x8b4c},
	{0xe698, 0x8b4f},
	{0xe699, 0x8b4e},
	{0xe69a, 0x8b49},
	{0xe69b, 0x8b56},
	{0xe69c, 0x8b5b},
	{0xe69d, 0x8b5a},
	{0xe69e, 0x8b6b},
	{0xe69f, 0x8b5f},
	{0xe6a0, 0x8b6c},
	{0xe6a1, 0x8b6f},
	{0xe6a2, 0x8b74},
	{0xe6a3, 0x8b7d},
	{0xe6a4, 0x8b80},
	{0xe6a5, 0x8b8c},
	{0xe6a6, 0x8b8e},
	{0xe6a7, 0x8b92},
	{0xe6a8, 0x8b93},
	{0xe6a9, 0x8b96},
	{0xe6aa, 0x8b99},
	{0xe6ab, 0x8b9a},
	{0xe6ac, 0x8c3a},
	{0xe6ad, 0x8c41},
	{0xe6ae, 0x8c3f},
	{0xe6af, 0x8c48},
	{0xe6b0, 0x8c4c},
	{0xe6b1, 0x8c4e},
	{0xe6b2, 0x8c50},
	{0xe6b3, 0x8c55},
	{0xe6b4, 0x8c62},
	{0xe6b5, 0x8c6c},
	{0xe6b6, 0x8c78},
	{0xe6b7, 0x8c7a},
	{0xe6b8, 0x8c82},
	{0xe6b9, 0x8c89},
	{0xe6ba, 0x8c85},
	{0xe6bb, 0x8c8a},
	{0xe6bc, 0x8c8d},
	{0xe6bd, 0x8c8e},
	{0xe6be, 0x8c94},
	{0xe6bf, 0x8c7c},
	{0xe6c0, 0x8c98},
	{0xe6c1, 0x621d},
	{0xe6c2, 0x8cad},
	{0xe6c3, 0x8caa},
	{0xe6c4, 0x8cbd},
	{0xe6c5, 0x8cb2},
	{0xe6c6, 0x8cb3},
	{0xe6c7, 0x8cae},
	{0xe6c8, 0x8cb6},
	{0xe6c9, 0x8cc8},
	{0xe6ca, 0x8cc1},
	{0xe6cb, 0x8ce4},
	{0xe6cc, 0x8ce3},
	{0xe6cd, 0x8cda},
	{0xe6ce, 0x8cfd},
	{0xe6cf, 0x8cfa},
	{0xe6d0, 0x8cfb},
	{0xe6d1, 0x8d04},
	{0xe6d2, 0x8d05},
	{0xe6d3, 0x8d0a},
	{0xe6d4, 0x8d07},
	{0xe6d5, 0x8d0f},
	{0xe6d6, 0x8d0d},
	{0xe6d7, 0x8d10},
	{0xe6d8, 0x9f4e},
	{0xe6d9, 0x8d13},
	{0xe6da, 0x8ccd},
	{0xe6db, 0x8d14},
	{0xe6dc, 0x8d16},
	{0xe6dd, 0x8d67},
	{0xe6de, 0x8d6d},
	{0xe6df, 0x8d71},
	{0xe6e0, 0x8d73},
	{0xe6e1, 0x8d81},
	{0xe6e2, 0x8d99},
	{0xe6e3, 0x8dc2},
	{0xe6e4, 0x8dbe},
	{0xe6e5, 0x8dba},
	{0xe6e6, 0x8dcf},
	{0xe6e7, 0x8dda},
	{0xe6e8, 0x8dd6},
	{0xe6e9, 0x8dcc},
	{0xe6ea, 0x8ddb},
	{0xe6eb, 0x8dcb},
	{0xe6ec, 0x8dea},
	{0xe6ed, 0x8deb},
	{0xe6ee, 0x8ddf},
	{0xe6ef, 0x8de3},
	{0xe6f0, 0x8dfc},
	{0xe6f1, 0x8e08},
	{0xe6f2, 0x8e09},
	{0xe6f3, 0x8dff},
	{0xe6f4, 0x8e1d},
	{0xe6f5, 0x8e1e},
	{0xe6f6, 0x8e10},
	{0xe6f7, 0x8e1f},
	{0xe6f8, 0x8e42},
	{0xe6f9, 0x8e35},
	{0xe6fa, 0x8e30},
	{0xe6fb, 0x8e34},
	{0xe6fc, 0x8e4a},
	{0xe740, 0x8e47},
	{0xe741, 0x8e49},
	{0xe742, 0x8e4c},
	{0xe743, 0x8e50},
	{0xe744, 0x8e48},
	{0xe745, 0x8e59},
	{0xe746, 0x8e64},
	{0xe747, 0x8e60},
	{0xe748, 0x8e2a},
	{0xe749, 0x8e63},
	{0xe74a, 0x8e55},
	{0xe74b, 0x8e76},
	{0xe74c, 0x8e72},
	{0xe74d, 0x8e7c},
	{0xe74e, 0x8e81},
	{0xe74f, 0x8e87},
	{0xe750, 0x8e85},
	{0xe751, 0x8e84},
	{0xe752, 0x8e8b},
	{0xe753, 0x8e8a},
	{0xe754, 0x8e93},
	{0xe755, 0x8e91},
	{0xe756, 0x8e94},
	{0xe757, 0x8e99},
	{0xe758, 0x8eaa},
	{0xe759, 0x8ea1},
	{0xe75a, 0x8eac},
	{0xe75b, 0x8eb0},
	{0xe75c, 0x8ec6},
	{0xe75d, 0x8eb1},
	{0xe75e, 0x8ebe},
	{0xe75f, 0x8ec5},
	{0xe760, 0x8ec8},
	{0xe761, 0x8ecb},
	{0xe762, 0x8edb},
	{0xe763, 0x8ee3},
	{0xe764, 0x8efc},
	{0xe765, 0x8efb},
	{0xe766, 0x8eeb},
	{0xe767, 0x8efe},
	{0xe768, 0x8f0a},
	{0xe769, 0x8f05},
	{0xe76a, 0x8f15},
	{0xe76b, 0x8f12},
	{0xe76c, 0x8f19},
	{0xe76d, 0x8f13},
	{0xe76e, 0x8f1c},
	{0xe76f, 0x8f1f},
	{0xe770, 0x8f1b},
	{0xe771, 0x8f0c},
	{0xe772, 0x8f26},
	{0xe773, 0x8f33},
	{0xe774, 0x8f3b},
	{0xe775, 0x8f39},
	{0xe776, 0x8f45},
	{0xe777, 0x8f42},
	{0xe778, 0x8f3e},
	{0xe779, 0x8f4c},
	{0xe77a, 0x8f49},
	{0xe77b, 0x8f46},
	{0xe77c, 0x8f4e},
	{0xe77d, 0x8f57},
	{0xe77e, 0x8f5c},
	{0xe780, 0x8f62},
	{0xe781, 0x8f63},
	{0xe782, 0x8f64},
	{0xe783, 0x8f9c},
	{0xe784, 0x8f9f},
	{0xe785, 0x8fa3},
	{0xe786, 0x8fad},
	{0xe787, 0x8faf},
	{0xe788, 0x8fb7},
	{0xe789, 0x8fda},
	{0xe78a, 0x8fe5},
	{0xe78b, 0x8fe2},
	{0xe78c, 0x8fea},
	{0xe78d, 0x8fef},
	{0xe78e, 0x9087},
	{0xe78f, 0x8ff4},
	{0xe790, 0x9005},
	{0xe791, 0x8ff9},
	{0xe792, 0x8ffa},
	{0xe793, 0x9011},
	{0xe794, 0x9015},
	{0xe795, 0x9021},
	{0xe796, 0x900d},
	{0xe797, 0x901e},
	{0xe798, 0x9016},
	{0xe799, 0x900b},
	{0xe79a, 0x9027},
	{0xe79b, 0x9036},
	{0xe79c, 0x9035},
	{0xe79d, 0x9039},
	{0xe79e, 0x8ff8},
	{0xe79f, 0x904f},
	{0xe7a0, 0x9050},
	{0xe7a1, 0x9051},
	{0xe7a2, 0x9052},
	{0xe7a3, 0x900e},
	{0xe7a4, 0x9049},
	{0xe7a5, 0x903e},
	{0xe7a6, 0x9056},
	{0xe7a7, 0x9058},
	{0xe7a8, 0x905e},
	{0xe7a9, 0x9068},
	{0xe7aa, 0x906f},
	{0xe7ab, 0x9076},
	{0xe7ac, 0x96a8},
	{0xe7ad, 0x9072},
	{0xe7ae, 0x9082},
	{0xe7af, 0x907d},
	{0xe7b0, 0x9081},
	{0xe7b1, 0x9080},
	{0xe7b2, 0x908a},
	{0xe7b3, 0x9089},
	{0xe7b4, 0x908f},
	{0xe7b5, 0x90a8},
	{0xe7b6, 0x90af},
	{0xe7b7, 0x90b1},
	{0xe7b8, 0x90b5},
	{0xe7b9, 0x90e2},
	{0xe7ba, 0x90e4},
	{0xe7bb, 0x6248},
	{0xe7bc, 0x90db},
	{0xe7bd, 0x9102},
	{0xe7be, 0x9112},
	{0xe7bf, 0x9119},
	{0xe7c0, 0x9132},
	{0xe7c1, 0x9130},
	{0xe7c2, 0x914a},
	{0xe7c3, 0x9156},
	{0xe7c4, 0x9158},
	{0xe7c5, 0x9163},
	{0xe7c6, 0x9165},
	{0xe7c7, 0x9169},
	{0xe7c8, 0x9173},
	{0xe7c9, 0x9172},
	{0xe7ca, 0x918b},
	{0xe7cb, 0x9189},
	{0xe7cc, 0x9182},
	{0xe7cd, 0x91a2},
	{0xe7ce, 0x91ab},
	{0xe7cf, 0x91af},
	{0xe7d0, 0x91aa},
	{0xe7d1, 0x91b5},
	{0xe7d2, 0x91b4},
	{0xe7d3, 0x91ba},
	{0xe7d4, 0x91c0},
	{0xe7d5, 0x91c1},
	{0xe7d6, 0x91c9},
	{0xe7d7, 0x91cb},
	{0xe7d8, 0x91d0},
	{0xe7d9, 0x91d6},
	{0xe7da, 0x91df},
	{0xe7db, 0x91e1},
	{0xe7dc, 0x91db},
	{0xe7dd, 0x91fc},
	{0xe7de, 0x91f5},
	{0xe7df, 0x91f6},
	{0xe7e0, 0x921e},
	{0xe7e1, 0x91ff},
	{0xe7e2, 0x9214},
	{0xe7e3, 0x922c},
	{0xe7e4, 0x9215},
	{0xe7e5, 0x9211},
	{0xe7e6, 0x925e},
	{0xe7e7, 0x9257},
	{0xe7e8, 0x9245},
	{0xe7e9, 0x9249},
	{0xe7ea, 0x9264},
	{0xe7eb, 0x9248},
	{0xe7ec, 0x9295},
	{0xe7ed, 0x923f},
	{0xe7ee, 0x924b},
	{0xe7ef, 0x9250},
	{0xe7f0, 0x929c},
	{0xe7f1, 0x9296},
	{0xe7f2, 0x9293},
	{0xe7f3, 0x929b},
	{0xe7f4, 0x925a},
	{0xe7f5, 0x92cf},
	{0xe7f6, 0x92b9},
	{0xe7f7, 0x92b7},
	{0xe7f8, 0x92e9},
	{0xe7f9, 0x930f},
	{0xe7fa, 0x92fa},
	{0xe7fb, 0x9344},
	{0xe7fc, 0x932e},
	{0xe840, 0x9319},
	{0xe841, 0x9322},
	{0xe842, 0x931a},
	{0xe843, 0x9323},
	{0xe844, 0x933a},
	{0xe845, 0x9335},
	{0xe846, 0x933b},
	{0xe847, 0x935c},
	{0xe848, 0x9360},
	{0xe849, 0x937c},
	{0xe84a, 0x936e},
	{0xe84b, 0x9356},
	{0xe84c, 0x93b0},
	{0xe84d, 0x93ac},
	{0xe84e, 0x93ad},
	{0xe84f, 0x9394},
	{0xe850, 0x93b9},
	{0xe851, 0x93d6},
	{0xe852, 0x93d7},
	{0xe853, 0x93e8},
	{0xe854, 0x93e5},
	{0xe855, 0x93d8},
	{0xe856, 0x93c3},
	{0xe857, 0x93dd},
	{0xe858, 0x93d0},
	{0xe859, 0x93c8},
	{0xe85a, 0x93e4},
	{0xe85b, 0x941a},
	{0xe85c, 0x9414},
	{0xe85d, 0x9413},
	{0xe85e, 0x9403},
	{0xe85f, 0x9407},
	{0xe860, 0x9410},
	{0xe861, 0x9436},
	{0xe862, 0x942b},
	{0xe863, 0x9435},
	{0xe864, 0x9421},
	{0xe865, 0x943a},
	{0xe866, 0x9441},
	{0xe867, 0x9452},
	{0xe868, 0x9444},
	{0xe869, 0x945b},
	{0xe86a, 0x9460},
	{0xe86b, 0x9462},
	{0xe86c, 0x945e},
	{0xe86d, 0x946a},
	{0xe86e, 0x9229},
	{0xe86f, 0x9470},
	{0xe870, 0x9475},
	{0xe871, 0x9477},
	{0xe872, 0x947d},
	{0xe873, 0x945a},
	{0xe874, 0x947c},
	{0xe875, 0x947e},
	{0xe876, 0x9481},
	{0xe877, 0x947f},
	{0xe878, 0x9582},
	{0xe879, 0x9587},
	{0xe87a, 0x958a},
	{0xe87b, 0x9594},
	{0xe87c, 0x9596},
	{0xe87d, 0x9598},
	{0xe87e, 0x9599},
	{0xe880, 0x95a0},
	{0xe881, 0x95a8},
	{0xe882, 0x95a7},
	{0xe883, 0x95ad},
	{0xe884, 0x95bc},
	{0xe885, 0x95bb},
	{0xe886, 0x95b9},
	{0xe887, 0x95be},
	{0xe888, 0x95ca},
	{0xe889, 0x6ff6},
	{0xe88a, 0x95c3},
	{0xe88b, 0x95cd},
	{0xe88c, 0x95cc},
	{0xe88d, 0x95d5},
	{0xe88e, 0x95d4},
	{0xe88f, 0x95d6},
	{0xe890, 0x95dc},
	{0xe891, 0x95e1},
	{0xe892, 0x95e5},
	{0xe893, 0x95e2},
	{0xe894, 0x9621},
	{0xe895, 0x9628},
	{0xe896, 0x962e},
	{0xe897, 0x962f},
	{0xe898, 0x9642},
	{0xe899, 0x964c},
	{0xe89a, 0x964f},
	{0xe89b, 0x964b},
	{0xe89c, 0x9677},
	{0xe89d, 0x965c},
	{0xe89e, 0x965e},
	{0xe89f, 0x965d},
	{0xe8a0, 0x965f},
	{0xe8a1, 0x9666},
	{0xe8a2, 0x9672},
	{0xe8a3, 0x966c},
	{0xe8a4, 0x968d},
	{0xe8a5, 0x9698},
	{0xe8a6, 0x9695},
	{0xe8a7, 0x9697},
	{0xe8a8, 0x96aa},
	{0xe8a9, 0x96a7},
	{0xe8aa, 0x96b1},
	{0xe8ab, 0x96b2},
	{0xe8ac, 0x96b0},
	{0xe8ad, 0x96b4},
	{0xe8ae, 0x96b6},
	{0xe8af, 0x96b8},
	{0xe8b0, 0x96b9},
	{0xe8b1, 0x96ce},
	{0xe8b2, 0x96cb},
	{0xe8b3, 0x96c9},
	{0xe8b4, 0x96cd},
	{0xe8b5, 0x894d},
	{0xe8b6, 0x96dc},
	{0xe8b7, 0x970d},
	{0xe8b8, 0x96d5},
	{0xe8b9, 0x96f9},
	{0xe8ba, 0x9704},
	{0xe8bb, 0x9706},
	{0xe8bc, 0x9708},
	{0xe8bd, 0x9713},
	{0xe8be, 0x970e},
	{0xe8bf, 0x9711},
	{0xe8c0, 0x970f},
	{0xe8c1, 0x9716},
	{0xe8c2, 0x9719},
	{0xe8c3, 0x9724},
	{0xe8c4, 0x972a},
	{0xe8c5, 0x9730},
	{0xe8c6, 0x9739},
	{0xe8c7, 0x973d},
	{0xe8c8, 0x973e},
	{0xe8c9, 0x9744},
	{0xe8ca, 0x9746},
	{0xe8cb, 0x9748},
	{0xe8cc, 0x9742},
	{0xe8cd, 0x9749},
	{0xe8ce, 0x975c},
	{0xe8cf, 0x9760},
	{0xe8d0, 0x9764},
	{0xe8d1, 0x9766},
	{0xe8d2, 0x9768},
	{0xe8d3, 0x52d2},
	{0xe8d4, 0x976b},
	{0xe8d5, 0x9771},
	{0xe8d6, 0x9779},
	{0xe8d7, 0x9785},
	{0xe8d8, 0x977c},
	{0xe8d9, 0x9781},
	{0xe8da, 0x977a},
	{0xe8db, 0x9786},
	{0xe8dc, 0x978b},
	{0xe8dd, 0x978f},
	{0xe8de, 0x9790},
	{0xe8df, 0x979c},
	{0xe8e0, 0x97a8},
	{0xe8e1, 0x97a6},
	{0xe8e2, 0x97a3},
	{0xe8e3, 0x97b3},
	{0xe8e4, 0x97b4},
	{0xe8e5, 0x97c3},
	{0xe8e6, 0x97c6},
	{0xe8e7, 0x97c8},
	{0xe8e8, 0x97cb},
	{0xe8e9, 0x97dc},
	{0xe8ea, 0x97ed},
	{0xe8eb, 0x9f4f},
	{0xe8ec, 0x97f2},
	{0xe8ed, 0x7adf},
	{0xe8ee, 0x97f6},
	{0xe8ef, 0x97f5},
	{0xe8f0, 0x980f},
	{0xe8f1, 0x980c},
	{0xe8f2, 0x9838},
	{0xe8f3, 0x9824},
	{0xe8f4, 0x9821},
	{0xe8f5, 0x9837},
	{0xe8f6, 0x983d},
	{0xe8f7, 0x9846},
	{0xe8f8, 0x984f},
	{0xe8f9, 0x984b},
	{0xe8fa, 0x986b},
	{0xe8fb, 0x986f},
	{0xe8fc, 0x9870},
	{0xe940, 0x9871},
	{0xe941, 0x9874},
	{0xe942, 0x9873},
	{0xe943, 0x98aa},
	{0xe944, 0x98af},
	{0xe945, 0x98b1},
	{0xe946, 0x98b6},
	{0xe947, 0x98c4},
	{0xe948, 0x98c3},
	{0xe949, 0x98c6},
	{0xe94a, 0x98e9},
	{0xe94b, 0x98eb},
	{0xe94c, 0x9903},
	{0xe94d, 0x9909},
	{0xe94e, 0x9912},
	{0xe94f, 0x9914},
	{0xe950, 0x9918},
	{0xe951, 0x9921},
	{0xe952, 0x991d},
	{0xe953, 0x991e},
	{0xe954, 0x9924},
	{0xe955, 0x9920},
	{0xe956, 0x992c},
	{0xe957, 0x992e},
	{0xe958, 0x993d},
	{0xe959, 0x993e},
	{0xe95a, 0x9942},
	{0xe95b, 0x9949},
	{0xe95c, 0x9945},
	{0xe95d, 0x9950},
	{0xe95e, 0x994b},
	{0xe95f, 0x9951},
	{0xe960, 0x9952},
	{0xe961, 0x994c},
	{0xe962, 0x9955},
	{0xe963, 0x9997},
	{0xe964, 0x9998},
	{0xe965, 0x99a5},
	{0xe966, 0x99ad},
	{0xe967, 0x99ae},
	{0xe968, 0x99bc},
	{0xe969, 0x99df},
	{0xe96a, 0x99db},
	{0xe96b, 0x99dd},
	{0xe96c, 0x99d8},
	{0xe96d, 0x99d1},
	{0xe96e, 0x99ed},
	{0xe96f, 0x99ee},
	{0xe970, 0x99f1},
	{0xe971, 0x99f2},
	{0xe972, 0x99fb},
	{0xe973, 0x99f8},
	{0xe974, 0x9a01},
	{0xe975, 0x9a0f},
	{0xe976, 0x9a05},
	{0xe977, 0x99e2},
	{0xe978, 0x9a19},
	{0xe979, 0x9a2b},
	{0xe97a, 0x9a37},
	{0xe97b, 0x9a45},
	{0xe97c, 0x9a42},
	{0xe97d, 0x9a40},
	{0xe97e, 0x9a43},
	{0xe980, 0x9a3e},
	{0xe981, 0x9a55},
	{0xe982, 0x9a4d},
	{0xe983, 0x9a5b},
	{0xe984, 0x9a57},
	{0xe985, 0x9a5f},
	{0xe986, 0x9a62},
	{0xe987, 0x9a65},
	{0xe988, 0x9a64},
	{0xe989, 0x9a69},
	{0xe98a, 0x9a6b},
	{0xe98b, 0x9a6a},
	{0xe98c, 0x9aad},
	{0xe98d, 0x9ab0},
	{0xe98e, 0x9abc},
	{0xe98f, 0x9ac0},
	{0xe990, 0x9acf},
	{0xe991, 0x9ad1},
	{0xe992, 0x9ad3},
	{0xe993, 0x9ad4},
	{0xe994, 0x9ade},
	{0xe995, 0x9adf},
	{0xe996, 0x9ae2},
	{0xe997, 0x9ae3},
	{0xe998, 0x9ae6},
	{0xe999, 0x9aef},
	{0xe99a, 0x9aeb},
	{0xe99b, 0x9aee},
	{0xe99c, 0x9af4},
	{0xe99d, 0x9af1},
	{0xe99e, 0x9af7},
	{0xe99f, 0x9afb},
	{0xe9a0, 0x9b06},
	{0xe9a1, 0x9b18},
	{0xe9a2, 0x9b1a},
	{0xe9a3, 0x9b1f},
	{0xe9a4, 0x9b22},
	{0xe9a5, 0x9b23},
	{0xe9a6, 0x9b25},
	{0xe9a7, 0x9b27},
	{0xe9a8, 0x9b28},
	{0xe9a9, 0x9b29},
	{0xe9aa, 0x9b2a},
	{0xe9ab, 0x9b2e},
	{0xe9ac, 0x9b2f},
	{0xe9ad, 0x9b32},
	{0xe9ae, 0x9b44},
	{0xe9af, 0x9b43},
	{0xe9b0, 0x9b4f},
	{0xe9b1, 0x9b4d},
	{0xe9b2, 0x9b4e},
	{0xe9b3, 0x9b51},
	{0xe9b4, 0x9b58},
	{0xe9b5, 0x9b74},
	{0xe9b6, 0x9b93},
	{0xe9b7, 0x9b83},
	{0xe9b8, 0x9b91},
	{0xe9b9, 0x9b96},
	{0xe9ba, 0x9b97},
	{0xe9bb, 0x9b9f},
	{0xe9bc, 0x9ba0},
	{0xe9bd, 0x9ba8},
	{0xe9be, 0x9bb4},
	{0xe9bf, 0x9bc0},
	{0xe9c0, 0x9bca},
	{0xe9c1, 0x9bb9},
	{0xe9c2, 0x9bc6},
	{0xe9c3, 0x9bcf},
	{0xe9c4, 0x9bd1},
	{0xe9c5, 0x9bd2},
	{0xe9c6, 0x9be3},
	{0xe9c7, 0x9be2},
	{0xe9c8, 0x9be4},
	{0xe9c9, 0x9bd4},
	{0xe9ca, 0x9be1},
	{0xe9cb, 0x9c3a},
	{0xe9cc, 0x9bf2},
	{0xe9cd, 0x9bf1},
	{0xe9ce, 0x9bf0},
	{0xe9cf, 0x9c15},
	{0xe9d0, 0x9c14},
	{0xe9d1, 0x9c09},
	{0xe9d2, 0x9c13},
	{0xe9d3, 0x9c0c},
	{0xe9d4, 0x9c06},
	{0xe9d5, 0x9c08},
	{0xe9d6, 0x9c12},
	{0xe9d7, 0x9c0a},
	{0xe9d8, 0x9c04},
	{0xe9d9, 0x9c2e},
	{0xe9da, 0x9c1b},
	{0xe9db, 0x9c25},
	{0xe9dc, 0x9c24},
	{0xe9dd, 0x9c21},
	{0xe9de, 0x9c30},
	{0xe9df, 0x9c47},
	{0xe9e0, 0x9c32},
	{0xe9e1, 0x9c46},
	{0xe9e2, 0x9c3e},
	{0xe9e3, 0x9c5a},
	{0xe9e4, 0x9c60},
	{0xe9e5, 0x9c67},
	{0xe9e6, 0x9c76},
	{0xe9e7, 0x9c78},
	{0xe9e8, 0x9ce7},
	{0xe9e9, 0x9cec},
	{0xe9ea, 0x9cf0},
	{0xe9eb, 0x9d09},
	{0xe9ec, 0x9d08},
	{0xe9ed, 0x9ceb},
	{0xe9ee, 0x9d03},
	{0xe9ef, 0x9d06},
	{0xe9f0, 0x9d2a},
	{0xe9f1, 0x9d26},
	{0xe9f2, 0x9daf},
	{0xe9f3, 0x9d23},
	{0xe9f4, 0x9d1f},
	{0xe9f5, 0x9d44},
	{0xe9f6, 0x9d15},
	{0xe9f7, 0x9d12},
	{0xe9f8, 0x9d41},
	{0xe9f9, 0x9d3f},
	{0xe9fa, 0x9d3e},
	{0xe9fb, 0x9d46},
	{0xe9fc, 0x9d48},
	{0xea40, 0x9d5d},
	{0xea41, 0x9d5e},
	{0xea42, 0x9d64},
	{0xea43, 0x9d51},
	{0xea44, 0x9d50},
	{0xea45, 0x9d59},
	{0xea46, 0x9d72},
	{0xea47, 0x9d89},
	{0xea48, 0x9d87},
	{0xea49, 0x9dab},
	{0xea4a, 0x9d6f},
	{0xea4b, 0x9d7a},
	{0xea4c, 0x9d9a},
	{0xea4d, 0x9da4},
	{0xea4e, 0x9da9},
	{0xea4f, 0x9db2},
	{0xea50, 0x9dc4},
	{0xea51, 0x9dc1},
	{0xea52, 0x9dbb},
	{0xea53, 0x9db8},
	{0xea54, 0x9dba},
	{0xea55, 0x9dc6},
	{0xea56, 0x9dcf},
	{0xea57, 0x9dc2},
	{0xea58, 0x9dd9},
	{0xea59, 0x9dd3},
	{0xea5a, 0x9df8},
	{0xea5b, 0x9de6},
	{0xea5c, 0x9ded},
	{0xea5d, 0x9def},
	{0xea5e, 0x9dfd},
	{0xea5f, 0x9e1a},
	{0xea60, 0x9e1b},
	{0xea61, 0x9e1e},
	{0xea62, 0x9e75},
	{0xea63, 0x9e79},
	{0xea64, 0x9e7d},
	{0xea65, 0x9e81},
	{0xea66, 0x9e88},
	{0xea67, 0x9e8b},
	{0xea68, 0x9e8c},
	{0xea69, 0x9e92},
	{0xea6a, 0x9e95},
	{0xea6b, 0x9e91},
	{0xea6c, 0x9e9d},
	{0xea6d, 0x9ea5},
	{0xea6e, 0x9ea9},
	{0xea6f, 0x9eb8},
	{0xea70, 0x9eaa},
	{0xea71, 0x9ead},
	{0xea72, 0x9761},
	{0xea73, 0x9ecc},
	{0xea74, 0x9ece},
	{0xea75, 0x9ecf},
	{0xea76, 0x9ed0},
	{0xea77, 0x9ed4},
	{0xea78, 0x9edc},
	{0xea79, 0x9ede},
	{0xea7a, 0x9edd},
	{0xea7b, 0x9ee0},
	{0xea7c, 0x9ee5},
	{0xea7d, 0x9ee8},
	{0xea7e, 0x9eef},
	{0xea80, 0x9ef4},
	{0xea81, 0x9ef6},
	{0xea82, 0x9ef7},
	{0xea83, 0x9ef9},
	{0xea84, 0x9efb},
	{0xea85, 0x9efc},
	{0xea86, 0x9efd},
	{0xea87, 0x9f07},
	{0xea88, 0x9f08},
	{0xea89, 0x76b7},
	{0xea8a, 0x9f15},
	{0xea8b, 0x9f21},
	{0xea8c, 0x9f2c},
	{0xea8d, 0x9f3e},
	{0xea8e, 0x9f4a},
	{0xea8f, 0x9f52},
	{0xea90, 0x9f54},
	{0xea91, 0x9f63},
	{0xea92, 0x9f5f},
	{0xea93, 0x9f60},
	{0xea94, 0x9f61},
	{0xea95, 0x9f66},
	{0xea96, 0x9f67},
	{0xea97, 0x9f6c},
	{0xea98, 0x9f6a},
	{0xea99, 0x9f77},
	{0xea9a, 0x9f72},
	{0xea9b, 0x9f76},
	{0xea9c, 0x9f95},
	{0xea9d, 0x9f9c},
	{0xea9e, 0x9fa0},
	{0xea9f, 0x582f},
	{0xeaa0, 0x69c7},
	{0xeaa1, 0x9059},
	{0xeaa2, 0x7464},
	{0xeaa3, 0x51dc},
	{0xeaa4, 0x7199},
	{0xed40, 0x7e8a},
	{0xed41, 0x891c},
	{0xed42, 0x9348},
	{0xed43, 0x9288},
	{0xed44, 0x84dc},
	{0xed45, 0x4fc9},
	{0xed46, 0x70bb},
	{0xed47, 0x6631},
	{0xed48, 0x68c8},
	{0xed49, 0x92f9},
	{0xed4a, 0x66fb},
	{0xed4b, 0x5f45},
	{0xed4c, 0x4e28},
	{0xed4d, 0x4ee1},
	{0xed4e, 0x4efc},
	{0xed4f, 0x4f00},
	{0xed50, 0x4f03},
	{0xed51, 0x4f39},
	{0xed52, 0x4f56},
	{0xed53, 0x4f92},
	{0xed54, 0x4f8a},
	{0xed55, 0x4f9a},
	{0xed56, 0x4f94},
	{0xed57, 0x4fcd},
	{0xed58, 0x5040},
	{0xed59, 0x5022},
	{0xed5a, 0x4fff},
	{0xed5b, 0x501e},
	{0xed5c, 0x5046},
	{0xed5d, 0x5070},
	{0xed5e, 0x5042},
	{0xed5f, 0x5094},
	{0xed60, 0x50f4},
	{0xed61, 0x50d8},
	{0xed62, 0x514a},
	{0xed63, 0x5164},
	{0xed64, 0x519d},
	{0xed65, 0x51be},
	{0xed66, 0x51ec},
	{0xed67, 0x5215},
	{0xed68, 0x529c},
	{0xed69, 0x52a6},
	{0xed6a, 0x52c0},
	{0xed6b, 0x52db},
	{0xed6c, 0x5300},
	{0xed6d, 0x5307},
	{0xed6e, 0x5324},
	{0xed6f, 0x5372},
	{0xed70, 0x5393},
	{0xed71, 0x53b2},
	{0xed72, 0x53dd},
	{0xed73, 0xfa0e},
	{0xed74, 0x549c},
	{0xed75, 0x548a},
	{0xed76, 0x54a9},
	{0xed77, 0x54ff},
	{0xed78, 0x5586},
	{0xed79, 0x5759},
	{0xed7a, 0x5765},
	{0xed7b, 0x57ac},
	{0xed7c, 0x57c8},
	{0xed7d, 0x57c7},
	{0xed7e, 0xfa0f},
	{0xed80, 0xfa10},
	{0xed81, 0x589e},
	{0xed82, 0x58b2},
	{0xed83, 0x590b},
	{0xed84, 0x5953},
	{0xed85, 0x595b},
	{0xed86, 0x595d},
	{0xed87, 0x5963},
	{0xed88, 0x59a4},
	{0xed89, 0x59ba},
	{0xed8a, 0x5b56},
	{0xed8b, 0x5bc0},
	{0xed8c, 0x752f},
	{0xed8d, 0x5bd8},
	{0xed8e, 0x5bec},
	{0xed8f, 0x5c1e},
	{0xed90, 0x5ca6},
	{0xed91, 0x5cba},
	{0xed92, 0x5cf5},
	{0xed93, 0x5d27},
	{0xed94, 0x5d53},
	{0xed95, 0xfa11},
	{0xed96, 0x5d42},
	{0xed97, 0x5d6d},
	{0xed98, 0x5db8},
	{0xed99, 0x5db9},
	{0xed9a, 0x5dd0},
	{0xed9b, 0x5f21},
	{0xed9c, 0x5f34},
	{0xed9d, 0x5f67},
	{0xed9e, 0x5fb7},
	{0xed9f, 0x5fde},
	{0xeda0, 0x605d},
	{0xeda1, 0x6085},
	{0xeda2, 0x608a},
	{0xeda3, 0x60de},
	{0xeda4, 0x60d5},
	{0xeda5, 0x6120},
	{0xeda6, 0x60f2},
	{0xeda7, 0x6111},
	{0xeda8, 0x6137},
	{0xeda9, 0x6130},
	{0xedaa, 0x6198},
	{0xedab, 0x6213},
	{0xedac, 0x62a6},
	{0xedad, 0x63f5},
	{0xedae, 0x6460},
	{0xedaf, 0x649d},
	{0xedb0, 0x64ce},
	{0xedb1, 0x654e},
	{0xedb2, 0x6600},
	{0xedb3, 0x6615},
	{0xedb4, 0x663b},
	{0xedb5, 0x6609},
	{0xedb6, 0x662e},
	{0xedb7, 0x661e},
	{0xedb8, 0x6624},
	{0xedb9, 0x6665},
	{0xedba, 0x6657},
	{0xedbb, 0x6659},
	{0xedbc, 0xfa12},
	{0xedbd, 0x6673},
	{0xedbe, 0x6699},
	{0xedbf, 0x66a0},
	{0xedc0, 0x66b2},
	{0xedc1, 0x66bf},
	{0xedc2, 0x66fa},
	{0xedc3, 0x670e},
	{0xedc4, 0xf929},
	{0xedc5, 0x6766},
	{0xedc6, 0x67bb},
	{0xedc7, 0x6852},
	{0xedc8, 0x67c0},
	{0xedc9, 0x6801},
	{0xedca, 0x6844},
	{0xedcb, 0x68cf},
	{0xedcc, 0xfa13},
	{0xedcd, 0x6968},
	{0xedce, 0xfa14},
	{0xedcf, 0x6998},
	{0xedd0, 0x69e2},
	{0xedd1, 0x6a30},
	{0xedd2, 0x6a6b},
	{0xedd3, 0x6a46},
	{0xedd4, 0x6a73},
	{0xedd5, 0x6a7e},
	{0xedd6, 0x6ae2},
	{0xedd7, 0x6ae4},
	{0xedd8, 0x6bd6},
	{0xedd9, 0x6c3f},
	{0xedda, 0x6c5c},
	{0xeddb, 0x6c86},
	{0xeddc, 0x6c6f},
	{0xeddd, 0x6cda},
	{0xedde, 0x6d04},
	{0xeddf, 0x6d87},
	{0xede0, 0x6d6f},
	{0xede1, 0x6d96},
	{0xede2, 0x6dac},
	{0xede3, 0x6dcf},
	{0xede4, 0x6df8},
	{0xede5, 0x6df2},
	{0xede6, 0x6dfc},
	{0xede7, 0x6e39},
	{0xede8, 0x6e5c},
	{0xede9, 0x6e27},
	{0xedea, 0x6e3c},
	{0xedeb, 0x6ebf},
	{0xedec, 0x6f88},
	{0xeded, 0x6fb5},
	{0xedee, 0x6ff5},
	{0xedef, 0x7005},
	{0xedf0, 0x7007},
	{0xedf1, 0x7028},
	{0xedf2, 0x7085},
	{0xedf3, 0x70ab},
	{0xedf4, 0x710f},
	{0xedf5, 0x7104},
	{0xedf6, 0x715c},
	{0xedf7, 0x7146},
	{0xedf8, 0x7147},
	{0xedf9, 0xfa15},
	{0xedfa, 0x71c1},
	{0xedfb, 0x71fe},
	{0xedfc, 0x72b1},
	{0xee40, 0x72be},
	{0xee41, 0x7324},
	{0xee42, 0xfa16},
	{0xee43, 0x7377},
	{0xee44, 0x73bd},
	{0xee45, 0x73c9},
	{0xee46, 0x73d6},
	{0xee47, 0x73e3},
	{0xee48, 0x73d2},
	{0xee49, 0x7407},
	{0xee4a, 0x73f5},
	{0xee4b, 0x7426},
	{0xee4c, 0x742a},
	{0xee4d, 0x7429},
	{0xee4e, 0x742e},
	{0xee4f, 0x7462},
	{0xee50, 0x7489},
	{0xee51, 0x749f},
	{0xee52, 0x7501},
	{0xee53, 0x756f},
	{0xee54, 0x7682},
	{0xee55, 0x769c},
	{0xee56, 0x769e},
	{0xee57, 0x769b},
	{0xee58, 0x76a6},
	{0xee59, 0xfa17},
	{0xee5a, 0x7746},
	{0xee5b, 0x52af},
	{0xee5c, 0x7821},
	{0xee5d, 0x784e},
	{0xee5e, 0x7864},
	{0xee5f, 0x787a},
	{0xee60, 0x7930},
	{0xee61, 0xfa18},
	{0xee62, 0xfa19},
	{0xee63, 0xfa1a},
	{0xee64, 0x7994},
	{0xee65, 0xfa1b},
	{0xee66, 0x799b},
	{0xee67, 0x7ad1},
	{0xee68, 0x7ae7},
	{0xee69, 0xfa1c},
	{0xee6a, 0x7aeb},
	{0xee6b, 0x7b9e},
	{0xee6c, 0xfa1d},
	{0xee6d, 0x7d48},
	{0xee6e, 0x7d5c},
	{0xee6f, 0x7db7},
	{0xee70, 0x7da0},
	{0xee71, 0x7dd6},
	{0xee72, 0x7e52},
	{0xee73, 0x7f47},
	{0xee74, 0x7fa1},
	{0xee75, 0xfa1e},
	{0xee76, 0x8301},
	{0xee77, 0x8362},
	{0xee78, 0x837f},
	{0xee79, 0x83c7},
	{0xee7a, 0x83f6},
	{0xee7b, 0x8448},
	{0xee7c, 0x84b4},
	{0xee7d, 0x8553},
	{0xee7e, 0x8559},
	{0xee80, 0x856b},
	{0xee81, 0xfa1f},
	{0xee82, 0x85b0},
	{0xee83, 0xfa20},
	{0xee84, 0xfa21},
	{0xee85, 0x8807},
	{0xee86, 0x88f5},
	{0xee87, 0x8a12},
	{0xee88, 0x8a37},
	{0xee89, 0x8a79},
	{0xee8a, 0x8aa7},
	{0xee8b, 0x8abe},
	{0xee8c, 0x8adf},
	{0xee8d, 0xfa22},
	{0xee8e, 0x8af6},
	{0xee8f, 0x8b53},
	{0xee90, 0x8b7f},
	{0xee91, 0x8cf0},
	{0xee92, 0x8cf4},
	{0xee93, 0x8d12},
	{0xee94, 0x8d76},
	{0xee95, 0xfa23},
	{0xee96, 0x8ecf},
	{0xee97, 0xfa24},
	{0xee98, 0xfa25},
	{0xee99, 0x9067},
	{0xee9a, 0x90de},
	{0xee9b, 0xfa26},
	{0xee9c, 0x9115},
	{0xee9d, 0x9127},
	{0xee9e, 0x91da},
	{0xee9f, 0x91d7},
	{0xeea0, 0x91de},
	{0xeea1, 0x91ed},
	{0xeea2, 0x91ee},
	{0xeea3, 0x91e4},
	{0xeea4, 0x91e5},
	{0xeea5, 0x9206},
	{0xeea6, 0x9210},
	{0xeea7, 0x920a},
	{0xeea8, 0x923a},
	{0xeea9, 0x9240},
	{0xeeaa, 0x923c},
	{0xeeab, 0x924e},
	{0xeeac, 0x9259},
	{0xeead, 0x9251},
	{0xeeae, 0x9239},
	{0xeeaf, 0x9267},
	{0xeeb0, 0x92a7},
	{0xeeb1, 0x9277},
	{0xeeb2, 0x9278},
	{0xeeb3, 0x92e7},
	{0xeeb4, 0x92d7},
	{0xeeb5, 0x92d9},
	{0xeeb6, 0x92d0},
	{0xeeb7, 0xfa27},
	{0xeeb8, 0x92d5},
	{0xeeb9, 0x92e0},
	{0xeeba, 0x92d3},
	{0xeebb, 0x9325},
	{0xeebc, 0x9321},
	{0xeebd, 0x92fb},
	{0xeebe, 0xfa28},
	{0xeebf, 0x931e},
	{0xeec0, 0x92ff},
	{0xeec1, 0x931d},
	{0xeec2, 0x9302},
	{0xeec3, 0x9370},
	{0xeec4, 0x9357},
	{0xeec5, 0x93a4},
	{0xeec6, 0x93c6},
	{0xeec7, 0x93de},
	{0xeec8, 0x93f8},
	{0xeec9, 0x9431},
	{0xeeca, 0x9445},
	{0xeecb, 0x9448},
	{0xeecc, 0x9592},
	{0xeecd, 0xf9dc},
	{0xeece, 0xfa29},
	{0xeecf, 0x969d},
	{0xeed0, 0x96af},
	{0xeed1, 0x9733},
	{0xeed2, 0x973b},
	{0xeed3, 0x9743},
	{0xeed4, 0x974d},
	{0xeed5, 0x974f},
	{0xeed6, 0x9751},
	{0xeed7, 0x9755},
	{0xeed8, 0x9857},
	{0xeed9, 0x9865},
	{0xeeda, 0xfa2a},
	{0xeedb, 0xfa2b},
	{0xeedc, 0x9927},
	{0xeedd, 0xfa2c},
	{0xeede, 0x999e},
	{0xeedf, 0x9a4e},
	{0xeee0, 0x9ad9},
	{0xeee1, 0x9adc},
	{0xeee2, 0x9b75},
	{0xeee3, 0x9b72},
	{0xeee4, 0x9b8f},
	{0xeee5, 0x9bb1},
	{0xeee6, 0x9bbb},
	{0xeee7, 0x9c00},
	{0xeee8, 0x9d70},
	{0xeee9, 0x9d6b},
	{0xeeea, 0xfa2d},
	{0xeeeb, 0x9e19},
	{0xeeec, 0x9ed1},
	{0xeeef, 0x2170},
	{0xeef0, 0x2171},
	{0xeef1, 0x2172},
	{0xeef2, 0x2173},
	{0xeef3, 0x2174},
	{0xeef4, 0x2175},
	{0xeef5, 0x2176},
	{0xeef6, 0x2177},
	{0xeef7, 0x2178},
	{0xeef8, 0x2179},
	{0xeefa, 0xffe4},
	{0xeefb, 0xff07},
	{0xeefc, 0xff02}
};
//	There were 7523 values

#ifdef CASIO_SH3
static CONST CODE_CONV ppwEuc2Utf[] = {
#else
static CODE_CONV ppwEuc2Utf[] = {
#endif //CASIO_SH3
	{0x0020, 0x0020},		// single byte ascii characters
	{0x0021, 0x0021},
	{0x0022, 0x0022},
	{0x0023, 0x0023},
	{0x0024, 0x0024},
	{0x0025, 0x0025},
	{0x0026, 0x0026},
	{0x0027, 0x0027},
	{0x0028, 0x0028},
	{0x0029, 0x0029},
	{0x002a, 0x002a},
	{0x002b, 0x002b},
	{0x002c, 0x002c},
	{0x002d, 0x002d},
	{0x002e, 0x002e},
	{0x002f, 0x002f},
	{0x0030, 0x0030},
	{0x0031, 0x0031},
	{0x0032, 0x0032},
	{0x0033, 0x0033},
	{0x0034, 0x0034},
	{0x0035, 0x0035},
	{0x0036, 0x0036},
	{0x0037, 0x0037},
	{0x0038, 0x0038},
	{0x0039, 0x0039},
	{0x003a, 0x003a},
	{0x003b, 0x003b},
	{0x003c, 0x003c},
	{0x003d, 0x003d},
	{0x003e, 0x003e},
	{0x003f, 0x003f},
	{0x0040, 0x0040},
	{0x0041, 0x0041},
	{0x0042, 0x0042},
	{0x0043, 0x0043},
	{0x0044, 0x0044},
	{0x0045, 0x0045},
	{0x0046, 0x0046},
	{0x0047, 0x0047},
	{0x0048, 0x0048},
	{0x0049, 0x0049},
	{0x004a, 0x004a},
	{0x004b, 0x004b},
	{0x004c, 0x004c},
	{0x004d, 0x004d},
	{0x004e, 0x004e},
	{0x004f, 0x004f},
	{0x0050, 0x0050},
	{0x0051, 0x0051},
	{0x0052, 0x0052},
	{0x0053, 0x0053},
	{0x0054, 0x0054},
	{0x0055, 0x0055},
	{0x0056, 0x0056},
	{0x0057, 0x0057},
	{0x0058, 0x0058},
	{0x0059, 0x0059},
	{0x005a, 0x005a},
	{0x005b, 0x005b},
	{0x005d, 0x005d},
	{0x005e, 0x005e},
	{0x005f, 0x005f},
	{0x0060, 0x0060},
	{0x0061, 0x0061},
	{0x0062, 0x0062},
	{0x0063, 0x0063},
	{0x0064, 0x0064},
	{0x0065, 0x0065},
	{0x0066, 0x0066},
	{0x0067, 0x0067},
	{0x0068, 0x0068},
	{0x0069, 0x0069},
	{0x006a, 0x006a},
	{0x006b, 0x006b},
	{0x006c, 0x006c},
	{0x006d, 0x006d},
	{0x006e, 0x006e},
	{0x006f, 0x006f},
	{0x0070, 0x0070},
	{0x0071, 0x0071},
	{0x0072, 0x0072},
	{0x0073, 0x0073},
	{0x0074, 0x0074},
	{0x0075, 0x0075},
	{0x0076, 0x0076},
	{0x0077, 0x0077},
	{0x0078, 0x0078},
	{0x0079, 0x0079},
	{0x007a, 0x007a},
	{0x007b, 0x007b},
	{0x007c, 0x007c},
	{0x007d, 0x007d},
	{0x007e, 0x007e},
	{0x007f, 0x007f},
	{0xa1a0, 0x3000},
	{0xa1a1, 0x3000},
	{0xa1a2, 0x3001},
	{0xa1a3, 0x3002},
	{0xa1a4, 0xff0c},
	{0xa1a5, 0xff0e},
	{0xa1a6, 0x30fb},
	{0xa1a7, 0xff1a},
	{0xa1a8, 0xff1b},
	{0xa1a9, 0xff1f},
	{0xa1aa, 0xff01},
	{0xa1ab, 0x309b},
	{0xa1ac, 0x309c},
	{0xa1ad, 0x00b4},
	{0xa1ae, 0xff40},
	{0xa1af, 0x00a8},
	{0xa1b0, 0xff3e},
	{0xA1B1, 0xffe3},		// high bar
	{0xa1b2, 0xff3f},
	{0xa1b3, 0x30fd},
	{0xa1b4, 0x30fe},
	{0xa1b5, 0x309d},
	{0xa1b6, 0x309e},
	{0xa1b7, 0x3003},
	{0xa1b8, 0x4edd},
	{0xa1b9, 0x3005},
	{0xa1ba, 0x3006},
	{0xa1bb, 0x3007},
	{0xa1bc, 0x30fc},
	{0xa1bd, 0x2014},
	{0xa1be, 0x2010},
	{0xa1bf, 0xff0f},
	{0xa1c0, 0x005c},
	{0xa1c1, 0x301c},
	{0xa1c2, 0x2016},
	{0xa1c3, 0xff5c},
	{0xa1c4, 0x2026},
	{0xa1c5, 0x2025},
	{0xa1c6, 0x2018},
	{0xa1c7, 0x2019},
	{0xa1c8, 0x201c},
	{0xa1c9, 0x201d},
	{0xa1ca, 0xff08},
	{0xa1cb, 0xff09},
	{0xa1cc, 0x3014},
	{0xa1cd, 0x3015},
	{0xa1ce, 0xff3b},
	{0xa1cf, 0xff3d},
	{0xa1d0, 0xff5b},
	{0xa1d1, 0xff5d},
	{0xa1d2, 0x3008},
	{0xa1d3, 0x3009},
	{0xa1d4, 0x300a},
	{0xa1d5, 0x300b},
	{0xa1d6, 0x300c},
	{0xa1d7, 0x300d},
	{0xa1d8, 0x300e},
	{0xa1d9, 0x300f},
	{0xa1da, 0x3010},
	{0xa1db, 0x3011},
	{0xa1dc, 0xff0b},
	{0xa1dd, 0x2212},
	{0xa1de, 0x00b1},
	{0xa1df, 0x00d7},
	{0xa1e0, 0x00f7},
	{0xa1e1, 0xff1d},
	{0xa1e2, 0x2260},
	{0xa1e3, 0xff1c},
	{0xa1e4, 0xff1e},
	{0xa1e5, 0x2266},
	{0xa1e6, 0x2267},
	{0xa1e7, 0x221e},
	{0xa1e8, 0x2234},
	{0xa1e9, 0x2642},
	{0xa1ea, 0x2640},
	{0xa1eb, 0x00b0},
	{0xa1ec, 0x2032},
	{0xa1ed, 0x2033},
	{0xa1ee, 0x2103},
	{0xA1EF, 0xffe5},		// yen symbol
	{0xa1f0, 0xff04},
	{0xa1f1, 0x00a2},
	{0xa1f2, 0x00a3},
	{0xa1f3, 0xff05},
	{0xa1f4, 0xff03},
	{0xa1f5, 0xff06},
	{0xa1f6, 0xff0a},
	{0xa1f7, 0xff20},
	{0xa1f8, 0x00a7},
	{0xa1f9, 0x2606},
	{0xa1fa, 0x2605},
	{0xa1fb, 0x25cb},
	{0xa1fc, 0x25cf},
	{0xa1fd, 0x25ce},
	{0xa1fe, 0x25c7},
	{0xa2a1, 0x25c6},
	{0xa2a2, 0x25a1},
	{0xa2a3, 0x25a0},
	{0xa2a4, 0x25b3},
	{0xa2a5, 0x25b2},
	{0xa2a6, 0x25bd},
	{0xa2a7, 0x25bc},
	{0xa2a8, 0x203b},
	{0xa2a9, 0x3012},
	{0xa2aa, 0x2192},
	{0xa2ab, 0x2190},
	{0xa2ac, 0x2191},
	{0xa2ad, 0x2193},
	{0xa2ae, 0x3013},
	{0xa2ba, 0x2208},
	{0xa2bb, 0x220b},
	{0xa2bc, 0x2286},
	{0xa2bd, 0x2287},
	{0xa2be, 0x2282},
	{0xa2bf, 0x2283},
//	{0xa2c0, 0x222a},	// duplicate of EUC 0xADFC
//	{0xa2c1, 0x2229}, // duplicate of EUC 0xADFB
	{0xa2ca, 0x2227},
	{0xa2cb, 0x2228},
	{0xa2cc, 0x00ac},
	{0xa2cd, 0x21d2},
	{0xa2ce, 0x21d4},
	{0xa2cf, 0x2200},
	{0xa2d0, 0x2203},
//	{0xa2dc, 0x2220},	// duplicate of EUC 0xADF7
	{0xa2dd, 0x22a5},
	{0xa2de, 0x2312},
	{0xa2df, 0x2202},
	{0xa2e0, 0x2207},
//	{0xa2e1, 0x2261},	// duplicate of EUC 0xADF1
	{0xa2e2, 0x2252},
	{0xa2e3, 0x226a},
	{0xa2e4, 0x226b},
//	{0xa2e5, 0x221a},	// duplicate of EUC 0xADF5
	{0xa2e6, 0x223d},
	{0xa2e7, 0x221d},
//	{0xa2e8, 0x2235},	// duplicate of EUC 0xADFA
//	{0xa2e9, 0x222b},	// duplicate of EUC 0xADF2
	{0xa2ea, 0x222c},
	{0xa2f2, 0x212b},
	{0xa2f3, 0x2030},
	{0xa2f4, 0x266f},
	{0xa2f5, 0x266d},
	{0xa2f6, 0x266a},
	{0xa2f7, 0x2020},
	{0xa2f8, 0x2021},
	{0xa2f9, 0x00b6},
	{0xa2fe, 0x25ef},
	{0xa3b0, 0xff10},
	{0xa3b1, 0xff11},
	{0xa3b2, 0xff12},
	{0xa3b3, 0xff13},
	{0xa3b4, 0xff14},
	{0xa3b5, 0xff15},
	{0xa3b6, 0xff16},
	{0xa3b7, 0xff17},
	{0xa3b8, 0xff18},
	{0xa3b9, 0xff19},
	{0xa3c1, 0xff21},
	{0xa3c2, 0xff22},
	{0xa3c3, 0xff23},
	{0xa3c4, 0xff24},
	{0xa3c5, 0xff25},
	{0xa3c6, 0xff26},
	{0xa3c7, 0xff27},
	{0xa3c8, 0xff28},
	{0xa3c9, 0xff29},
	{0xa3ca, 0xff2a},
	{0xa3cb, 0xff2b},
	{0xa3cc, 0xff2c},
	{0xa3cd, 0xff2d},
	{0xa3ce, 0xff2e},
	{0xa3cf, 0xff2f},
	{0xa3d0, 0xff30},
	{0xa3d1, 0xff31},
	{0xa3d2, 0xff32},
	{0xa3d3, 0xff33},
	{0xa3d4, 0xff34},
	{0xa3d5, 0xff35},
	{0xa3d6, 0xff36},
	{0xa3d7, 0xff37},
	{0xa3d8, 0xff38},
	{0xa3d9, 0xff39},
	{0xa3da, 0xff3a},
	{0xa3e1, 0xff41},
	{0xa3e2, 0xff42},
	{0xa3e3, 0xff43},
	{0xa3e4, 0xff44},
	{0xa3e5, 0xff45},
	{0xa3e6, 0xff46},
	{0xa3e7, 0xff47},
	{0xa3e8, 0xff48},
	{0xa3e9, 0xff49},
	{0xa3ea, 0xff4a},
	{0xa3eb, 0xff4b},
	{0xa3ec, 0xff4c},
	{0xa3ed, 0xff4d},
	{0xa3ee, 0xff4e},
	{0xa3ef, 0xff4f},
	{0xa3f0, 0xff50},
	{0xa3f1, 0xff51},
	{0xa3f2, 0xff52},
	{0xa3f3, 0xff53},
	{0xa3f4, 0xff54},
	{0xa3f5, 0xff55},
	{0xa3f6, 0xff56},
	{0xa3f7, 0xff57},
	{0xa3f8, 0xff58},
	{0xa3f9, 0xff59},
	{0xa3fa, 0xff5a},
	{0xa4a1, 0x3041},
	{0xa4a2, 0x3042},
	{0xa4a3, 0x3043},
	{0xa4a4, 0x3044},
	{0xa4a5, 0x3045},
	{0xa4a6, 0x3046},
	{0xa4a7, 0x3047},
	{0xa4a8, 0x3048},
	{0xa4a9, 0x3049},
	{0xa4aa, 0x304a},
	{0xa4ab, 0x304b},
	{0xa4ac, 0x304c},
	{0xa4ad, 0x304d},
	{0xa4ae, 0x304e},
	{0xa4af, 0x304f},
	{0xa4b0, 0x3050},
	{0xa4b1, 0x3051},
	{0xa4b2, 0x3052},
	{0xa4b3, 0x3053},
	{0xa4b4, 0x3054},
	{0xa4b5, 0x3055},
	{0xa4b6, 0x3056},
	{0xa4b7, 0x3057},
	{0xa4b8, 0x3058},
	{0xa4b9, 0x3059},
	{0xa4ba, 0x305a},
	{0xa4bb, 0x305b},
	{0xa4bc, 0x305c},
	{0xa4bd, 0x305d},
	{0xa4be, 0x305e},
	{0xa4bf, 0x305f},
	{0xa4c0, 0x3060},
	{0xa4c1, 0x3061},
	{0xa4c2, 0x3062},
	{0xa4c3, 0x3063},
	{0xa4c4, 0x3064},
	{0xa4c5, 0x3065},
	{0xa4c6, 0x3066},
	{0xa4c7, 0x3067},
	{0xa4c8, 0x3068},
	{0xa4c9, 0x3069},
	{0xa4ca, 0x306a},
	{0xa4cb, 0x306b},
	{0xa4cc, 0x306c},
	{0xa4cd, 0x306d},
	{0xa4ce, 0x306e},
	{0xa4cf, 0x306f},
	{0xa4d0, 0x3070},
	{0xa4d1, 0x3071},
	{0xa4d2, 0x3072},
	{0xa4d3, 0x3073},
	{0xa4d4, 0x3074},
	{0xa4d5, 0x3075},
	{0xa4d6, 0x3076},
	{0xa4d7, 0x3077},
	{0xa4d8, 0x3078},
	{0xa4d9, 0x3079},
	{0xa4da, 0x307a},
	{0xa4db, 0x307b},
	{0xa4dc, 0x307c},
	{0xa4dd, 0x307d},
	{0xa4de, 0x307e},
	{0xa4df, 0x307f},
	{0xa4e0, 0x3080},
	{0xa4e1, 0x3081},
	{0xa4e2, 0x3082},
	{0xa4e3, 0x3083},
	{0xa4e4, 0x3084},
	{0xa4e5, 0x3085},
	{0xa4e6, 0x3086},
	{0xa4e7, 0x3087},
	{0xa4e8, 0x3088},
	{0xa4e9, 0x3089},
	{0xa4ea, 0x308a},
	{0xa4eb, 0x308b},
	{0xa4ec, 0x308c},
	{0xa4ed, 0x308d},
	{0xa4ee, 0x308e},
	{0xa4ef, 0x308f},
	{0xa4f0, 0x3090},
	{0xa4f1, 0x3091},
	{0xa4f2, 0x3092},
	{0xa4f3, 0x3093},
	{0xa5a1, 0x30a1},
	{0xa5a2, 0x30a2},
	{0xa5a3, 0x30a3},
	{0xa5a4, 0x30a4},
	{0xa5a5, 0x30a5},
	{0xa5a6, 0x30a6},
	{0xa5a7, 0x30a7},
	{0xa5a8, 0x30a8},
	{0xa5a9, 0x30a9},
	{0xa5aa, 0x30aa},
	{0xa5ab, 0x30ab},
	{0xa5ac, 0x30ac},
	{0xa5ad, 0x30ad},
	{0xa5ae, 0x30ae},
	{0xa5af, 0x30af},
	{0xa5b0, 0x30b0},
	{0xa5b1, 0x30b1},
	{0xa5b2, 0x30b2},
	{0xa5b3, 0x30b3},
	{0xa5b4, 0x30b4},
	{0xa5b5, 0x30b5},
	{0xa5b6, 0x30b6},
	{0xa5b7, 0x30b7},
	{0xa5b8, 0x30b8},
	{0xa5b9, 0x30b9},
	{0xa5ba, 0x30ba},
	{0xa5bb, 0x30bb},
	{0xa5bc, 0x30bc},
	{0xa5bd, 0x30bd},
	{0xa5be, 0x30be},
	{0xa5bf, 0x30bf},
	{0xa5c0, 0x30c0},
	{0xa5c1, 0x30c1},
	{0xa5c2, 0x30c2},
	{0xa5c3, 0x30c3},
	{0xa5c4, 0x30c4},
	{0xa5c5, 0x30c5},
	{0xa5c6, 0x30c6},
	{0xa5c7, 0x30c7},
	{0xa5c8, 0x30c8},
	{0xa5c9, 0x30c9},
	{0xa5ca, 0x30ca},
	{0xa5cb, 0x30cb},
	{0xa5cc, 0x30cc},
	{0xa5cd, 0x30cd},
	{0xa5ce, 0x30ce},
	{0xa5cf, 0x30cf},
	{0xa5d0, 0x30d0},
	{0xa5d1, 0x30d1},
	{0xa5d2, 0x30d2},
	{0xa5d3, 0x30d3},
	{0xa5d4, 0x30d4},
	{0xa5d5, 0x30d5},
	{0xa5d6, 0x30d6},
	{0xa5d7, 0x30d7},
	{0xa5d8, 0x30d8},
	{0xa5d9, 0x30d9},
	{0xa5da, 0x30da},
	{0xa5db, 0x30db},
	{0xa5dc, 0x30dc},
	{0xa5dd, 0x30dd},
	{0xa5de, 0x30de},
	{0xa5df, 0x30df},
	{0xa5e0, 0x30e0},
	{0xa5e1, 0x30e1},
	{0xa5e2, 0x30e2},
	{0xa5e3, 0x30e3},
	{0xa5e4, 0x30e4},
	{0xa5e5, 0x30e5},
	{0xa5e6, 0x30e6},
	{0xa5e7, 0x30e7},
	{0xa5e8, 0x30e8},
	{0xa5e9, 0x30e9},
	{0xa5ea, 0x30ea},
	{0xa5eb, 0x30eb},
	{0xa5ec, 0x30ec},
	{0xa5ed, 0x30ed},
	{0xa5ee, 0x30ee},
	{0xa5ef, 0x30ef},
	{0xa5f0, 0x30f0},
	{0xa5f1, 0x30f1},
	{0xa5f2, 0x30f2},
	{0xa5f3, 0x30f3},
	{0xa5f4, 0x30f4},
	{0xa5f5, 0x30f5},
	{0xa5f6, 0x30f6},
	{0xa6a1, 0x0391},
	{0xa6a2, 0x0392},
	{0xa6a3, 0x0393},
	{0xa6a4, 0x0394},
	{0xa6a5, 0x0395},
	{0xa6a6, 0x0396},
	{0xa6a7, 0x0397},
	{0xa6a8, 0x0398},
	{0xa6a9, 0x0399},
	{0xa6aa, 0x039a},
	{0xa6ab, 0x039b},
	{0xa6ac, 0x039c},
	{0xa6ad, 0x039d},
	{0xa6ae, 0x039e},
	{0xa6af, 0x039f},
	{0xa6b0, 0x03a0},
	{0xa6b1, 0x03a1},
	{0xa6b2, 0x03a3},
	{0xa6b3, 0x03a4},
	{0xa6b4, 0x03a5},
	{0xa6b5, 0x03a6},
	{0xa6b6, 0x03a7},
	{0xa6b7, 0x03a8},
	{0xa6b8, 0x03a9},
	{0xa6c1, 0x03b1},
	{0xa6c2, 0x03b2},
	{0xa6c3, 0x03b3},
	{0xa6c4, 0x03b4},
	{0xa6c5, 0x03b5},
	{0xa6c6, 0x03b6},
	{0xa6c7, 0x03b7},
	{0xa6c8, 0x03b8},
	{0xa6c9, 0x03b9},
	{0xa6ca, 0x03ba},
	{0xa6cb, 0x03bb},
	{0xa6cc, 0x03bc},
	{0xa6cd, 0x03bd},
	{0xa6ce, 0x03be},
	{0xa6cf, 0x03bf},
	{0xa6d0, 0x03c0},
	{0xa6d1, 0x03c1},
	{0xa6d2, 0x03c3},
	{0xa6d3, 0x03c4},
	{0xa6d4, 0x03c5},
	{0xa6d5, 0x03c6},
	{0xa6d6, 0x03c7},
	{0xa6d7, 0x03c8},
	{0xa6d8, 0x03c9},
	{0xa7a1, 0x0410},
	{0xa7a2, 0x0411},
	{0xa7a3, 0x0412},
	{0xa7a4, 0x0413},
	{0xa7a5, 0x0414},
	{0xa7a6, 0x0415},
	{0xa7a7, 0x0401},
	{0xa7a8, 0x0416},
	{0xa7a9, 0x0417},
	{0xa7aa, 0x0418},
	{0xa7ab, 0x0419},
	{0xa7ac, 0x041a},
	{0xa7ad, 0x041b},
	{0xa7ae, 0x041c},
	{0xa7af, 0x041d},
	{0xa7b0, 0x041e},
	{0xa7b1, 0x041f},
	{0xa7b2, 0x0420},
	{0xa7b3, 0x0421},
	{0xa7b4, 0x0422},
	{0xa7b5, 0x0423},
	{0xa7b6, 0x0424},
	{0xa7b7, 0x0425},
	{0xa7b8, 0x0426},
	{0xa7b9, 0x0427},
	{0xa7ba, 0x0428},
	{0xa7bb, 0x0429},
	{0xa7bc, 0x042a},
	{0xa7bd, 0x042b},
	{0xa7be, 0x042c},
	{0xa7bf, 0x042d},
	{0xa7c0, 0x042e},
	{0xa7c1, 0x042f},
	{0xa7d1, 0x0430},
	{0xa7d2, 0x0431},
	{0xa7d3, 0x0432},
	{0xa7d4, 0x0433},
	{0xa7d5, 0x0434},
	{0xa7d6, 0x0435},
	{0xa7d7, 0x0451},
	{0xa7d8, 0x0436},
	{0xa7d9, 0x0437},
	{0xa7da, 0x0438},
	{0xa7db, 0x0439},
	{0xa7dc, 0x043a},
	{0xa7dd, 0x043b},
	{0xa7de, 0x043c},
	{0xa7df, 0x043d},
	{0xa7e0, 0x043e},
	{0xa7e1, 0x043f},
	{0xa7e2, 0x0440},
	{0xa7e3, 0x0441},
	{0xa7e4, 0x0442},
	{0xa7e5, 0x0443},
	{0xa7e6, 0x0444},
	{0xa7e7, 0x0445},
	{0xa7e8, 0x0446},
	{0xa7e9, 0x0447},
	{0xa7ea, 0x0448},
	{0xa7eb, 0x0449},
	{0xa7ec, 0x044a},
	{0xa7ed, 0x044b},
	{0xa7ee, 0x044c},
	{0xa7ef, 0x044d},
	{0xa7f0, 0x044e},
	{0xa7f1, 0x044f},
	{0xa8a1, 0x2500},
	{0xa8a2, 0x2502},
	{0xa8a3, 0x250c},
	{0xa8a4, 0x2510},
	{0xa8a5, 0x2518},
	{0xa8a6, 0x2514},
	{0xa8a7, 0x251c},
	{0xa8a8, 0x252c},
	{0xa8a9, 0x2524},
	{0xa8aa, 0x2534},
	{0xa8ab, 0x253c},
	{0xa8ac, 0x2501},
	{0xa8ad, 0x2503},
	{0xa8ae, 0x250f},
	{0xa8af, 0x2513},
	{0xa8b0, 0x251b},
	{0xa8b1, 0x2517},
	{0xa8b2, 0x2523},
	{0xa8b3, 0x2533},
	{0xa8b4, 0x252b},
	{0xa8b5, 0x253b},
	{0xa8b6, 0x254b},
	{0xa8b7, 0x2520},
	{0xa8b8, 0x252f},
	{0xa8b9, 0x2528},
	{0xa8ba, 0x2537},
	{0xa8bb, 0x253f},
	{0xa8bc, 0x251d},
	{0xa8bd, 0x2530},
	{0xa8be, 0x2525},
	{0xa8bf, 0x2538},
	{0xa8c0, 0x2542},
	{0xADA1, 0x2460},	// enclosed alphanumerics circle-1
	{0xADA2, 0x2461},
	{0xADA3, 0x2462},
	{0xADA4, 0x2463},
	{0xADA5, 0x2464},
	{0xADA6, 0x2465},
	{0xADA7, 0x2466},
	{0xADA8, 0x2467},
	{0xADA9, 0x2468},
	{0xADAA, 0x2469},
	{0xADAB, 0x246a},
	{0xADAC, 0x246b},
	{0xADAD, 0x246c},
	{0xADAE, 0x246d},
	{0xADAF, 0x246e},
	{0xADB0, 0x246f},
	{0xADB1, 0x2470},
	{0xADB2, 0x2471},
	{0xADB3, 0x2472},
	{0xADB4, 0x2473},	// circle-20
	{0xADB5, 0x2160},	// Roman numeral I
	{0xADB6, 0x2161},
	{0xADB7, 0x2162},
	{0xADB8, 0x2163},
	{0xADB9, 0x2164},
	{0xADBA, 0x2165},
	{0xADBB, 0x2166},
	{0xADBC, 0x2167},
	{0xADBD, 0x2168},
	{0xADBE, 0x2169},	// Roman numeral X
	{0xADC0, 0x3349},	// CJK compatibility characters
	{0xADC1, 0x3314},
	{0xADC2, 0x3322},
	{0xADC3, 0x334d},
	{0xADC4, 0x3318},
	{0xADC5, 0x3327},
	{0xADC6, 0x3303},
	{0xADC7, 0x3336},
	{0xADC8, 0x3351},
	{0xADC9, 0x3357},
	{0xADCA, 0x330d},
	{0xADCB, 0x3326},
	{0xADCC, 0x3323},
	{0xADCD, 0x332b},
	{0xADCE, 0x334a},
	{0xADCF, 0x333b},
	{0xADD0, 0x339c},	// mm
	{0xADD1, 0x339d},	// cm
	{0xADD2, 0x339e},	// km
	{0xADD3, 0x338e},	// mg
	{0xADD4, 0x338f},	// kg
	{0xADD5, 0x33c4},	// cc
	{0xADD6, 0x33a1},	// m^2
	{0xADE0, 0x301d},	// left double quote
	{0xADE1, 0x301f},
	{0xADE2, 0x2116},
	{0xADE3, 0x33cd},
	{0xADE4, 0x2121},
	{0xADE5, 0x32a4},	// enclosed letters & months
	{0xADE6, 0x32a5},
	{0xADE7, 0x32a6},
	{0xADE8, 0x32a7}, 
	{0xADE9, 0x32a8},
	{0xADEA, 0x3231},
	{0xADEB, 0x3232},
	{0xADEC, 0x3239},
	{0xADED, 0x337e},	// CJK compatibility characters
	{0xADEE, 0x337d},
	{0xADEF, 0x337c},
	{0xADF0, 0x2252},	// Mathematical operators (nearly equals)
	{0xADF1, 0x2261},	// (identical to)
	{0xADF2, 0x222b},	// (integral)
	{0xADF3, 0x222e},	// (contour integral)
	{0xADF4, 0x2211},	// (summation sign)
	{0xADF5, 0x221a},	// (square root)
	{0xADF6, 0x22a5},	// (perpendicular sign)
	{0xADF7, 0x2220},	// (angle)
	{0xADF8, 0x221f},	// (right angle)
	{0xADF9, 0x22bf},	// (right triangle)
	{0xADFA, 0x2235},	// (BECAUSE)
	{0xADFB, 0x2229},	// (intersection)
	{0xADFC, 0x222a},	// (union)
	{0xb0a1, 0x4e9c},
	{0xb0a2, 0x5516},
	{0xb0a3, 0x5a03},
	{0xb0a4, 0x963f},
	{0xb0a5, 0x54c0},
	{0xb0a6, 0x611b},
	{0xb0a7, 0x6328},
	{0xb0a8, 0x59f6},
	{0xb0a9, 0x9022},
	{0xb0aa, 0x8475},
	{0xb0ab, 0x831c},
	{0xb0ac, 0x7a50},
	{0xb0ad, 0x60aa},
	{0xb0ae, 0x63e1},
	{0xb0af, 0x6e25},
	{0xb0b0, 0x65ed},
	{0xb0b1, 0x8466},
	{0xb0b2, 0x82a6},
	{0xb0b3, 0x9bf5},
	{0xb0b4, 0x6893},
	{0xb0b5, 0x5727},
	{0xb0b6, 0x65a1},
	{0xb0b7, 0x6271},
	{0xb0b8, 0x5b9b},
	{0xb0b9, 0x59d0},
	{0xb0ba, 0x867b},
	{0xb0bb, 0x98f4},
	{0xb0bc, 0x7d62},
	{0xb0bd, 0x7dbe},
	{0xb0be, 0x9b8e},
	{0xb0bf, 0x6216},
	{0xb0c0, 0x7c9f},
	{0xb0c1, 0x88b7},
	{0xb0c2, 0x5b89},
	{0xb0c3, 0x5eb5},
	{0xb0c4, 0x6309},
	{0xb0c5, 0x6697},
	{0xb0c6, 0x6848},
	{0xb0c7, 0x95c7},
	{0xb0c8, 0x978d},
	{0xb0c9, 0x674f},
	{0xb0ca, 0x4ee5},
	{0xb0cb, 0x4f0a},
	{0xb0cc, 0x4f4d},
	{0xb0cd, 0x4f9d},
	{0xb0ce, 0x5049},
	{0xb0cf, 0x56f2},
	{0xb0d0, 0x5937},
	{0xb0d1, 0x59d4},
	{0xb0d2, 0x5a01},
	{0xb0d3, 0x5c09},
	{0xb0d4, 0x60df},
	{0xb0d5, 0x610f},
	{0xb0d6, 0x6170},
	{0xb0d7, 0x6613},
	{0xb0d8, 0x6905},
	{0xb0d9, 0x70ba},
	{0xb0da, 0x754f},
	{0xb0db, 0x7570},
	{0xb0dc, 0x79fb},
	{0xb0dd, 0x7dad},
	{0xb0de, 0x7def},
	{0xb0df, 0x80c3},
	{0xb0e0, 0x840e},
	{0xb0e1, 0x8863},
	{0xb0e2, 0x8b02},
	{0xb0e3, 0x9055},
	{0xb0e4, 0x907a},
	{0xb0e5, 0x533b},
	{0xb0e6, 0x4e95},
	{0xb0e7, 0x4ea5},
	{0xb0e8, 0x57df},
	{0xb0e9, 0x80b2},
	{0xb0ea, 0x90c1},
	{0xb0eb, 0x78ef},
	{0xb0ec, 0x4e00},
	{0xb0ed, 0x58f1},
	{0xb0ee, 0x6ea2},
	{0xb0ef, 0x9038},
	{0xb0f0, 0x7a32},
	{0xb0f1, 0x8328},
	{0xb0f2, 0x828b},
	{0xb0f3, 0x9c2f},
	{0xb0f4, 0x5141},
	{0xb0f5, 0x5370},
	{0xb0f6, 0x54bd},
	{0xb0f7, 0x54e1},
	{0xb0f8, 0x56e0},
	{0xb0f9, 0x59fb},
	{0xb0fa, 0x5f15},
	{0xb0fb, 0x98f2},
	{0xb0fc, 0x6deb},
	{0xb0fd, 0x80e4},
	{0xb0fe, 0x852d},
	{0xb1a1, 0x9662},
	{0xb1a2, 0x9670},
	{0xb1a3, 0x96a0},
	{0xb1a4, 0x97fb},
	{0xb1a5, 0x540b},
	{0xb1a6, 0x53f3},
	{0xb1a7, 0x5b87},
	{0xb1a8, 0x70cf},
	{0xb1a9, 0x7fbd},
	{0xb1aa, 0x8fc2},
	{0xb1ab, 0x96e8},
	{0xb1ac, 0x536f},
	{0xb1ad, 0x9d5c},
	{0xb1ae, 0x7aba},
	{0xb1af, 0x4e11},
	{0xb1b0, 0x7893},
	{0xb1b1, 0x81fc},
	{0xb1b2, 0x6e26},
	{0xb1b3, 0x5618},
	{0xb1b4, 0x5504},
	{0xb1b5, 0x6b1d},
	{0xb1b6, 0x851a},
	{0xb1b7, 0x9c3b},
	{0xb1b8, 0x59e5},
	{0xb1b9, 0x53a9},
	{0xb1ba, 0x6d66},
	{0xb1bb, 0x74dc},
	{0xb1bc, 0x958f},
	{0xb1bd, 0x5642},
	{0xb1be, 0x4e91},
	{0xb1bf, 0x904b},
	{0xb1c0, 0x96f2},
	{0xb1c1, 0x834f},
	{0xb1c2, 0x990c},
	{0xb1c3, 0x53e1},
	{0xb1c4, 0x55b6},
	{0xb1c5, 0x5b30},
	{0xb1c6, 0x5f71},
	{0xb1c7, 0x6620},
	{0xb1c8, 0x66f3},
	{0xb1c9, 0x6804},
	{0xb1ca, 0x6c38},
	{0xb1cb, 0x6cf3},
	{0xb1cc, 0x6d29},
	{0xb1cd, 0x745b},
	{0xb1ce, 0x76c8},
	{0xb1cf, 0x7a4e},
	{0xb1d0, 0x9834},
	{0xb1d1, 0x82f1},
	{0xb1d2, 0x885b},
	{0xb1d3, 0x8a60},
	{0xb1d4, 0x92ed},
	{0xb1d5, 0x6db2},
	{0xb1d6, 0x75ab},
	{0xb1d7, 0x76ca},
	{0xb1d8, 0x99c5},
	{0xb1d9, 0x60a6},
	{0xb1da, 0x8b01},
	{0xb1db, 0x8d8a},
	{0xb1dc, 0x95b2},
	{0xb1dd, 0x698e},
	{0xb1de, 0x53ad},
	{0xb1df, 0x5186},
	{0xb1e0, 0x5712},
	{0xb1e1, 0x5830},
	{0xb1e2, 0x5944},
	{0xb1e3, 0x5bb4},
	{0xb1e4, 0x5ef6},
	{0xb1e5, 0x6028},
	{0xb1e6, 0x63a9},
	{0xb1e7, 0x63f4},
	{0xb1e8, 0x6cbf},
	{0xb1e9, 0x6f14},
	{0xb1ea, 0x708e},
	{0xb1eb, 0x7114},
	{0xb1ec, 0x7159},
	{0xb1ed, 0x71d5},
	{0xb1ee, 0x733f},
	{0xb1ef, 0x7e01},
	{0xb1f0, 0x8276},
	{0xb1f1, 0x82d1},
	{0xb1f2, 0x8597},
	{0xb1f3, 0x9060},
	{0xb1f4, 0x925b},
	{0xb1f5, 0x9d1b},
	{0xb1f6, 0x5869},
	{0xb1f7, 0x65bc},
	{0xb1f8, 0x6c5a},
	{0xb1f9, 0x7525},
	{0xb1fa, 0x51f9},
	{0xb1fb, 0x592e},
	{0xb1fc, 0x5965},
	{0xb1fd, 0x5f80},
	{0xb1fe, 0x5fdc},
	{0xb2a1, 0x62bc},
	{0xb2a2, 0x65fa},
	{0xb2a3, 0x6a2a},
	{0xb2a4, 0x6b27},
	{0xb2a5, 0x6bb4},
	{0xb2a6, 0x738b},
	{0xb2a7, 0x7fc1},
	{0xb2a8, 0x8956},
	{0xb2a9, 0x9d2c},
	{0xb2aa, 0x9d0e},
	{0xb2ab, 0x9ec4},
	{0xb2ac, 0x5ca1},
	{0xb2ad, 0x6c96},
	{0xb2ae, 0x837b},
	{0xb2af, 0x5104},
	{0xb2b0, 0x5c4b},
	{0xb2b1, 0x61b6},
	{0xb2b2, 0x81c6},
	{0xb2b3, 0x6876},
	{0xb2b4, 0x7261},
	{0xb2b5, 0x4e59},
	{0xb2b6, 0x4ffa},
	{0xb2b7, 0x5378},
	{0xb2b8, 0x6069},
	{0xb2b9, 0x6e29},
	{0xb2ba, 0x7a4f},
	{0xb2bb, 0x97f3},
	{0xb2bc, 0x4e0b},
	{0xb2bd, 0x5316},
	{0xb2be, 0x4eee},
	{0xb2bf, 0x4f55},
	{0xb2c0, 0x4f3d},
	{0xb2c1, 0x4fa1},
	{0xb2c2, 0x4f73},
	{0xb2c3, 0x52a0},
	{0xb2c4, 0x53ef},
	{0xb2c5, 0x5609},
	{0xb2c6, 0x590f},
	{0xb2c7, 0x5ac1},
	{0xb2c8, 0x5bb6},
	{0xb2c9, 0x5be1},
	{0xb2ca, 0x79d1},
	{0xb2cb, 0x6687},
	{0xb2cc, 0x679c},
	{0xb2cd, 0x67b6},
	{0xb2ce, 0x6b4c},
	{0xb2cf, 0x6cb3},
	{0xb2d0, 0x706b},
	{0xb2d1, 0x73c2},
	{0xb2d2, 0x798d},
	{0xb2d3, 0x79be},
	{0xb2d4, 0x7a3c},
	{0xb2d5, 0x7b87},
	{0xb2d6, 0x82b1},
	{0xb2d7, 0x82db},
	{0xb2d8, 0x8304},
	{0xb2d9, 0x8377},
	{0xb2da, 0x83ef},
	{0xb2db, 0x83d3},
	{0xb2dc, 0x8766},
	{0xb2dd, 0x8ab2},
	{0xb2de, 0x5629},
	{0xb2df, 0x8ca8},
	{0xb2e0, 0x8fe6},
	{0xb2e1, 0x904e},
	{0xb2e2, 0x971e},
	{0xb2e3, 0x868a},
	{0xb2e4, 0x4fc4},
	{0xb2e5, 0x5ce8},
	{0xb2e6, 0x6211},
	{0xb2e7, 0x7259},
	{0xb2e8, 0x753b},
	{0xb2e9, 0x81e5},
	{0xb2ea, 0x82bd},
	{0xb2eb, 0x86fe},
	{0xb2ec, 0x8cc0},
	{0xb2ed, 0x96c5},
	{0xb2ee, 0x9913},
	{0xb2ef, 0x99d5},
	{0xb2f0, 0x4ecb},
	{0xb2f1, 0x4f1a},
	{0xb2f2, 0x89e3},
	{0xb2f3, 0x56de},
	{0xb2f4, 0x584a},
	{0xb2f5, 0x58ca},
	{0xb2f6, 0x5efb},
	{0xb2f7, 0x5feb},
	{0xb2f8, 0x602a},
	{0xb2f9, 0x6094},
	{0xb2fa, 0x6062},
	{0xb2fb, 0x61d0},
	{0xb2fc, 0x6212},
	{0xb2fd, 0x62d0},
	{0xb2fe, 0x6539},
	{0xb3a1, 0x9b41},
	{0xb3a2, 0x6666},
	{0xb3a3, 0x68b0},
	{0xb3a4, 0x6d77},
	{0xb3a5, 0x7070},
	{0xb3a6, 0x754c},
	{0xb3a7, 0x7686},
	{0xb3a8, 0x7d75},
	{0xb3a9, 0x82a5},
	{0xb3aa, 0x87f9},
	{0xb3ab, 0x958b},
	{0xb3ac, 0x968e},
	{0xb3ad, 0x8c9d},
	{0xb3ae, 0x51f1},
	{0xb3af, 0x52be},
	{0xb3b0, 0x5916},
	{0xb3b1, 0x54b3},
	{0xb3b2, 0x5bb3},
	{0xb3b3, 0x5d16},
	{0xb3b4, 0x6168},
	{0xb3b5, 0x6982},
	{0xb3b6, 0x6daf},
	{0xb3b7, 0x788d},
	{0xb3b8, 0x84cb},
	{0xb3b9, 0x8857},
	{0xb3ba, 0x8a72},
	{0xb3bb, 0x93a7},
	{0xb3bc, 0x9ab8},
	{0xb3bd, 0x6d6c},
	{0xb3be, 0x99a8},
	{0xb3bf, 0x86d9},
	{0xb3c0, 0x57a3},
	{0xb3c1, 0x67ff},
	{0xb3c2, 0x86ce},
	{0xb3c3, 0x920e},
	{0xb3c4, 0x5283},
	{0xb3c5, 0x5687},
	{0xb3c6, 0x5404},
	{0xb3c7, 0x5ed3},
	{0xb3c8, 0x62e1},
	{0xb3c9, 0x64b9},
	{0xb3ca, 0x683c},
	{0xb3cb, 0x6838},
	{0xb3cc, 0x6bbb},
	{0xb3cd, 0x7372},
	{0xb3ce, 0x78ba},
	{0xb3cf, 0x7a6b},
	{0xb3d0, 0x899a},
	{0xb3d1, 0x89d2},
	{0xb3d2, 0x8d6b},
	{0xb3d3, 0x8f03},
	{0xb3d4, 0x90ed},
	{0xb3d5, 0x95a3},
	{0xb3d6, 0x9694},
	{0xb3d7, 0x9769},
	{0xb3d8, 0x5b66},
	{0xb3d9, 0x5cb3},
	{0xb3da, 0x697d},
	{0xb3db, 0x984d},
	{0xb3dc, 0x984e},
	{0xb3dd, 0x639b},
	{0xb3de, 0x7b20},
	{0xb3df, 0x6a2b},
	{0xb3e0, 0x6a7f},
	{0xb3e1, 0x68b6},
	{0xb3e2, 0x9c0d},
	{0xb3e3, 0x6f5f},
	{0xb3e4, 0x5272},
	{0xb3e5, 0x559d},
	{0xb3e6, 0x6070},
	{0xb3e7, 0x62ec},
	{0xb3e8, 0x6d3b},
	{0xb3e9, 0x6e07},
	{0xb3ea, 0x6ed1},
	{0xb3eb, 0x845b},
	{0xb3ec, 0x8910},
	{0xb3ed, 0x8f44},
	{0xb3ee, 0x4e14},
	{0xb3ef, 0x9c39},
	{0xb3f0, 0x53f6},
	{0xb3f1, 0x691b},
	{0xb3f2, 0x6a3a},
	{0xb3f3, 0x9784},
	{0xb3f4, 0x682a},
	{0xb3f5, 0x515c},
	{0xb3f6, 0x7ac3},
	{0xb3f7, 0x84b2},
	{0xb3f8, 0x91dc},
	{0xb3f9, 0x938c},
	{0xb3fa, 0x565b},
	{0xb3fb, 0x9d28},
	{0xb3fc, 0x6822},
	{0xb3fd, 0x8305},
	{0xb3fe, 0x8431},
	{0xb4a1, 0x7ca5},
	{0xb4a2, 0x5208},
	{0xb4a3, 0x82c5},
	{0xb4a4, 0x74e6},
	{0xb4a5, 0x4e7e},
	{0xb4a6, 0x4f83},
	{0xb4a7, 0x51a0},
	{0xb4a8, 0x5bd2},
	{0xb4a9, 0x520a},
	{0xb4aa, 0x52d8},
	{0xb4ab, 0x52e7},
	{0xb4ac, 0x5dfb},
	{0xb4ad, 0x559a},
	{0xb4ae, 0x582a},
	{0xb4af, 0x59e6},
	{0xb4b0, 0x5b8c},
	{0xb4b1, 0x5b98},
	{0xb4b2, 0x5bdb},
	{0xb4b3, 0x5e72},
	{0xb4b4, 0x5e79},
	{0xb4b5, 0x60a3},
	{0xb4b6, 0x611f},
	{0xb4b7, 0x6163},
	{0xb4b8, 0x61be},
	{0xb4b9, 0x63db},
	{0xb4ba, 0x6562},
	{0xb4bb, 0x67d1},
	{0xb4bc, 0x6853},
	{0xb4bd, 0x68fa},
	{0xb4be, 0x6b3e},
	{0xb4bf, 0x6b53},
	{0xb4c0, 0x6c57},
	{0xb4c1, 0x6f22},
	{0xb4c2, 0x6f97},
	{0xb4c3, 0x6f45},
	{0xb4c4, 0x74b0},
	{0xb4c5, 0x7518},
	{0xb4c6, 0x76e3},
	{0xb4c7, 0x770b},
	{0xb4c8, 0x7aff},
	{0xb4c9, 0x7ba1},
	{0xb4ca, 0x7c21},
	{0xb4cb, 0x7de9},
	{0xb4cc, 0x7f36},
	{0xb4cd, 0x7ff0},
	{0xb4ce, 0x809d},
	{0xb4cf, 0x8266},
	{0xb4d0, 0x839e},
	{0xb4d1, 0x89b3},
	{0xb4d2, 0x8acc},
	{0xb4d3, 0x8cab},
	{0xb4d4, 0x9084},
	{0xb4d5, 0x9451},
	{0xb4d6, 0x9593},
	{0xb4d7, 0x9591},
	{0xb4d8, 0x95a2},
	{0xb4d9, 0x9665},
	{0xb4da, 0x97d3},
	{0xb4db, 0x9928},
	{0xb4dc, 0x8218},
	{0xb4dd, 0x4e38},
	{0xb4de, 0x542b},
	{0xb4df, 0x5cb8},
	{0xb4e0, 0x5dcc},
	{0xb4e1, 0x73a9},
	{0xb4e2, 0x764c},
	{0xb4e3, 0x773c},
	{0xb4e4, 0x5ca9},
	{0xb4e5, 0x7feb},
	{0xb4e6, 0x8d0b},
	{0xb4e7, 0x96c1},
	{0xb4e8, 0x9811},
	{0xb4e9, 0x9854},
	{0xb4ea, 0x9858},
	{0xb4eb, 0x4f01},
	{0xb4ec, 0x4f0e},
	{0xb4ed, 0x5371},
	{0xb4ee, 0x559c},
	{0xb4ef, 0x5668},
	{0xb4f0, 0x57fa},
	{0xb4f1, 0x5947},
	{0xb4f2, 0x5b09},
	{0xb4f3, 0x5bc4},
	{0xb4f4, 0x5c90},
	{0xb4f5, 0x5e0c},
	{0xb4f6, 0x5e7e},
	{0xb4f7, 0x5fcc},
	{0xb4f8, 0x63ee},
	{0xb4f9, 0x673a},
	{0xb4fa, 0x65d7},
	{0xb4fb, 0x65e2},
	{0xb4fc, 0x671f},
	{0xb4fd, 0x68cb},
	{0xb4fe, 0x68c4},
	{0xb5a1, 0x6a5f},
	{0xb5a2, 0x5e30},
	{0xb5a3, 0x6bc5},
	{0xb5a4, 0x6c17},
	{0xb5a5, 0x6c7d},
	{0xb5a6, 0x757f},
	{0xb5a7, 0x7948},
	{0xb5a8, 0x5b63},
	{0xb5a9, 0x7a00},
	{0xb5aa, 0x7d00},
	{0xb5ab, 0x5fbd},
	{0xb5ac, 0x898f},
	{0xb5ad, 0x8a18},
	{0xb5ae, 0x8cb4},
	{0xb5af, 0x8d77},
	{0xb5b0, 0x8ecc},
	{0xb5b1, 0x8f1d},
	{0xb5b2, 0x98e2},
	{0xb5b3, 0x9a0e},
	{0xb5b4, 0x9b3c},
	{0xb5b5, 0x4e80},
	{0xb5b6, 0x507d},
	{0xb5b7, 0x5100},
	{0xb5b8, 0x5993},
	{0xb5b9, 0x5b9c},
	{0xb5ba, 0x622f},
	{0xb5bb, 0x6280},
	{0xb5bc, 0x64ec},
	{0xb5bd, 0x6b3a},
	{0xb5be, 0x72a0},
	{0xb5bf, 0x7591},
	{0xb5c0, 0x7947},
	{0xb5c1, 0x7fa9},
	{0xb5c2, 0x87fb},
	{0xb5c3, 0x8abc},
	{0xb5c4, 0x8b70},
	{0xb5c5, 0x63ac},
	{0xb5c6, 0x83ca},
	{0xb5c7, 0x97a0},
	{0xb5c8, 0x5409},
	{0xb5c9, 0x5403},
	{0xb5ca, 0x55ab},
	{0xb5cb, 0x6854},
	{0xb5cc, 0x6a58},
	{0xb5cd, 0x8a70},
	{0xb5ce, 0x7827},
	{0xb5cf, 0x6775},
	{0xb5d0, 0x9ecd},
	{0xb5d1, 0x5374},
	{0xb5d2, 0x5ba2},
	{0xb5d3, 0x811a},
	{0xb5d4, 0x8650},
	{0xb5d5, 0x9006},
	{0xb5d6, 0x4e18},
	{0xb5d7, 0x4e45},
	{0xb5d8, 0x4ec7},
	{0xb5d9, 0x4f11},
	{0xb5da, 0x53ca},
	{0xb5db, 0x5438},
	{0xb5dc, 0x5bae},
	{0xb5dd, 0x5f13},
	{0xb5de, 0x6025},
	{0xb5df, 0x6551},
	{0xb5e0, 0x673d},
	{0xb5e1, 0x6c42},
	{0xb5e2, 0x6c72},
	{0xb5e3, 0x6ce3},
	{0xb5e4, 0x7078},
	{0xb5e5, 0x7403},
	{0xb5e6, 0x7a76},
	{0xb5e7, 0x7aae},
	{0xb5e8, 0x7b08},
	{0xb5e9, 0x7d1a},
	{0xb5ea, 0x7cfe},
	{0xb5eb, 0x7d66},
	{0xb5ec, 0x65e7},
	{0xb5ed, 0x725b},
	{0xb5ee, 0x53bb},
	{0xb5ef, 0x5c45},
	{0xb5f0, 0x5de8},
	{0xb5f1, 0x62d2},
	{0xb5f2, 0x62e0},
	{0xb5f3, 0x6319},
	{0xb5f4, 0x6e20},
	{0xb5f5, 0x865a},
	{0xb5f6, 0x8a31},
	{0xb5f7, 0x8ddd},
	{0xb5f8, 0x92f8},
	{0xb5f9, 0x6f01},
	{0xb5fa, 0x79a6},
	{0xb5fb, 0x9b5a},
	{0xb5fc, 0x4ea8},
	{0xb5fd, 0x4eab},
	{0xb5fe, 0x4eac},
	{0xb6a1, 0x4f9b},
	{0xb6a2, 0x4fa0},
	{0xb6a3, 0x50d1},
	{0xb6a4, 0x5147},
	{0xb6a5, 0x7af6},
	{0xb6a6, 0x5171},
	{0xb6a7, 0x51f6},
	{0xb6a8, 0x5354},
	{0xb6a9, 0x5321},
	{0xb6aa, 0x537f},
	{0xb6ab, 0x53eb},
	{0xb6ac, 0x55ac},
	{0xb6ad, 0x5883},
	{0xb6ae, 0x5ce1},
	{0xb6af, 0x5f37},
	{0xb6b0, 0x5f4a},
	{0xb6b1, 0x602f},
	{0xb6b2, 0x6050},
	{0xb6b3, 0x606d},
	{0xb6b4, 0x631f},
	{0xb6b5, 0x6559},
	{0xb6b6, 0x6a4b},
	{0xb6b7, 0x6cc1},
	{0xb6b8, 0x72c2},
	{0xb6b9, 0x72ed},
	{0xb6ba, 0x77ef},
	{0xb6bb, 0x80f8},
	{0xb6bc, 0x8105},
	{0xb6bd, 0x8208},
	{0xb6be, 0x854e},
	{0xb6bf, 0x90f7},
	{0xb6c0, 0x93e1},
	{0xb6c1, 0x97ff},
	{0xb6c2, 0x9957},
	{0xb6c3, 0x9a5a},
	{0xb6c4, 0x4ef0},
	{0xb6c5, 0x51dd},
	{0xb6c6, 0x5c2d},
	{0xb6c7, 0x6681},
	{0xb6c8, 0x696d},
	{0xb6c9, 0x5c40},
	{0xb6ca, 0x66f2},
	{0xb6cb, 0x6975},
	{0xb6cc, 0x7389},
	{0xb6cd, 0x6850},
	{0xb6ce, 0x7c81},
	{0xb6cf, 0x50c5},
	{0xb6d0, 0x52e4},
	{0xb6d1, 0x5747},
	{0xb6d2, 0x5dfe},
	{0xb6d3, 0x9326},
	{0xb6d4, 0x65a4},
	{0xb6d5, 0x6b23},
	{0xb6d6, 0x6b3d},
	{0xb6d7, 0x7434},
	{0xb6d8, 0x7981},
	{0xb6d9, 0x79bd},
	{0xb6da, 0x7b4b},
	{0xb6db, 0x7dca},
	{0xb6dc, 0x82b9},
	{0xb6dd, 0x83cc},
	{0xb6de, 0x887f},
	{0xb6df, 0x895f},
	{0xb6e0, 0x8b39},
	{0xb6e1, 0x8fd1},
	{0xb6e2, 0x91d1},
	{0xb6e3, 0x541f},
	{0xb6e4, 0x9280},
	{0xb6e5, 0x4e5d},
	{0xb6e6, 0x5036},
	{0xb6e7, 0x53e5},
	{0xb6e8, 0x533a},
	{0xb6e9, 0x72d7},
	{0xb6ea, 0x7396},
	{0xb6eb, 0x77e9},
	{0xb6ec, 0x82e6},
	{0xb6ed, 0x8eaf},
	{0xb6ee, 0x99c6},
	{0xb6ef, 0x99c8},
	{0xb6f0, 0x99d2},
	{0xb6f1, 0x5177},
	{0xb6f2, 0x611a},
	{0xb6f3, 0x865e},
	{0xb6f4, 0x55b0},
	{0xb6f5, 0x7a7a},
	{0xb6f6, 0x5076},
	{0xb6f7, 0x5bd3},
	{0xb6f8, 0x9047},
	{0xb6f9, 0x9685},
	{0xb6fa, 0x4e32},
	{0xb6fb, 0x6adb},
	{0xb6fc, 0x91e7},
	{0xb6fd, 0x5c51},
	{0xb6fe, 0x5c48},
	{0xb7a1, 0x6398},
	{0xb7a2, 0x7a9f},
	{0xb7a3, 0x6c93},
	{0xb7a4, 0x9774},
	{0xb7a5, 0x8f61},
	{0xb7a6, 0x7aaa},
	{0xb7a7, 0x718a},
	{0xb7a8, 0x9688},
	{0xb7a9, 0x7c82},
	{0xb7aa, 0x6817},
	{0xb7ab, 0x7e70},
	{0xb7ac, 0x6851},
	{0xb7ad, 0x936c},
	{0xb7ae, 0x52f2},
	{0xb7af, 0x541b},
	{0xb7b0, 0x85ab},
	{0xb7b1, 0x8a13},
	{0xb7b2, 0x7fa4},
	{0xb7b3, 0x8ecd},
	{0xb7b4, 0x90e1},
	{0xb7b5, 0x5366},
	{0xb7b6, 0x8888},
	{0xb7b7, 0x7941},
	{0xb7b8, 0x4fc2},
	{0xb7b9, 0x50be},
	{0xb7ba, 0x5211},
	{0xb7bb, 0x5144},
	{0xb7bc, 0x5553},
	{0xb7bd, 0x572d},
	{0xb7be, 0x73ea},
	{0xb7bf, 0x578b},
	{0xb7c0, 0x5951},
	{0xb7c1, 0x5f62},
	{0xb7c2, 0x5f84},
	{0xb7c3, 0x6075},
	{0xb7c4, 0x6176},
	{0xb7c5, 0x6167},
	{0xb7c6, 0x61a9},
	{0xb7c7, 0x63b2},
	{0xb7c8, 0x643a},
	{0xb7c9, 0x656c},
	{0xb7ca, 0x666f},
	{0xb7cb, 0x6842},
	{0xb7cc, 0x6e13},
	{0xb7cd, 0x7566},
	{0xb7ce, 0x7a3d},
	{0xb7cf, 0x7cfb},
	{0xb7d0, 0x7d4c},
	{0xb7d1, 0x7d99},
	{0xb7d2, 0x7e4b},
	{0xb7d3, 0x7f6b},
	{0xb7d4, 0x830e},
	{0xb7d5, 0x834a},
	{0xb7d6, 0x86cd},
	{0xb7d7, 0x8a08},
	{0xb7d8, 0x8a63},
	{0xb7d9, 0x8b66},
	{0xb7da, 0x8efd},
	{0xb7db, 0x981a},
	{0xb7dc, 0x9d8f},
	{0xb7dd, 0x82b8},
	{0xb7de, 0x8fce},
	{0xb7df, 0x9be8},
	{0xb7e0, 0x5287},
	{0xb7e1, 0x621f},
	{0xb7e2, 0x6483},
	{0xb7e3, 0x6fc0},
	{0xb7e4, 0x9699},
	{0xb7e5, 0x6841},
	{0xb7e6, 0x5091},
	{0xb7e7, 0x6b20},
	{0xb7e8, 0x6c7a},
	{0xb7e9, 0x6f54},
	{0xb7ea, 0x7a74},
	{0xb7eb, 0x7d50},
	{0xb7ec, 0x8840},
	{0xb7ed, 0x8a23},
	{0xb7ee, 0x6708},
	{0xb7ef, 0x4ef6},
	{0xb7f0, 0x5039},
	{0xb7f1, 0x5026},
	{0xb7f2, 0x5065},
	{0xb7f3, 0x517c},
	{0xb7f4, 0x5238},
	{0xb7f5, 0x5263},
	{0xb7f6, 0x55a7},
	{0xb7f7, 0x570f},
	{0xb7f8, 0x5805},
	{0xb7f9, 0x5acc},
	{0xb7fa, 0x5efa},
	{0xb7fb, 0x61b2},
	{0xb7fc, 0x61f8},
	{0xb7fd, 0x62f3},
	{0xb7fe, 0x6372},
	{0xb8a1, 0x691c},
	{0xb8a2, 0x6a29},
	{0xb8a3, 0x727d},
	{0xb8a4, 0x72ac},
	{0xb8a5, 0x732e},
	{0xb8a6, 0x7814},
	{0xb8a7, 0x786f},
	{0xb8a8, 0x7d79},
	{0xb8a9, 0x770c},
	{0xb8aa, 0x80a9},
	{0xb8ab, 0x898b},
	{0xb8ac, 0x8b19},
	{0xb8ad, 0x8ce2},
	{0xb8ae, 0x8ed2},
	{0xb8af, 0x9063},
	{0xb8b0, 0x9375},
	{0xb8b1, 0x967a},
	{0xb8b2, 0x9855},
	{0xb8b3, 0x9a13},
	{0xb8b4, 0x9e78},
	{0xb8b5, 0x5143},
	{0xb8b6, 0x539f},
	{0xb8b7, 0x53b3},
	{0xb8b8, 0x5e7b},
	{0xb8b9, 0x5f26},
	{0xb8ba, 0x6e1b},
	{0xb8bb, 0x6e90},
	{0xb8bc, 0x7384},
	{0xb8bd, 0x73fe},
	{0xb8be, 0x7d43},
	{0xb8bf, 0x8237},
	{0xb8c0, 0x8a00},
	{0xb8c1, 0x8afa},
	{0xb8c2, 0x9650},
	{0xb8c3, 0x4e4e},
	{0xb8c4, 0x500b},
	{0xb8c5, 0x53e4},
	{0xb8c6, 0x547c},
	{0xb8c7, 0x56fa},
	{0xb8c8, 0x59d1},
	{0xb8c9, 0x5b64},
	{0xb8ca, 0x5df1},
	{0xb8cb, 0x5eab},
	{0xb8cc, 0x5f27},
	{0xb8cd, 0x6238},
	{0xb8ce, 0x6545},
	{0xb8cf, 0x67af},
	{0xb8d0, 0x6e56},
	{0xb8d1, 0x72d0},
	{0xb8d2, 0x7cca},
	{0xb8d3, 0x88b4},
	{0xb8d4, 0x80a1},
	{0xb8d5, 0x80e1},
	{0xb8d6, 0x83f0},
	{0xb8d7, 0x864e},
	{0xb8d8, 0x8a87},
	{0xb8d9, 0x8de8},
	{0xb8da, 0x9237},
	{0xb8db, 0x96c7},
	{0xb8dc, 0x9867},
	{0xb8dd, 0x9f13},
	{0xb8de, 0x4e94},
	{0xb8df, 0x4e92},
	{0xb8e0, 0x4f0d},
	{0xb8e1, 0x5348},
	{0xb8e2, 0x5449},
	{0xb8e3, 0x543e},
	{0xb8e4, 0x5a2f},
	{0xb8e5, 0x5f8c},
	{0xb8e6, 0x5fa1},
	{0xb8e7, 0x609f},
	{0xb8e8, 0x68a7},
	{0xb8e9, 0x6a8e},
	{0xb8ea, 0x745a},
	{0xb8eb, 0x7881},
	{0xb8ec, 0x8a9e},
	{0xb8ed, 0x8aa4},
	{0xb8ee, 0x8b77},
	{0xb8ef, 0x9190},
	{0xb8f0, 0x4e5e},
	{0xb8f1, 0x9bc9},
	{0xb8f2, 0x4ea4},
	{0xb8f3, 0x4f7c},
	{0xb8f4, 0x4faf},
	{0xb8f5, 0x5019},
	{0xb8f6, 0x5016},
	{0xb8f7, 0x5149},
	{0xb8f8, 0x516c},
	{0xb8f9, 0x529f},
	{0xb8fa, 0x52b9},
	{0xb8fb, 0x52fe},
	{0xb8fc, 0x539a},
	{0xb8fd, 0x53e3},
	{0xb8fe, 0x5411},
	{0xb9a1, 0x540e},
	{0xb9a2, 0x5589},
	{0xb9a3, 0x5751},
	{0xb9a4, 0x57a2},
	{0xb9a5, 0x597d},
	{0xb9a6, 0x5b54},
	{0xb9a7, 0x5b5d},
	{0xb9a8, 0x5b8f},
	{0xb9a9, 0x5de5},
	{0xb9aa, 0x5de7},
	{0xb9ab, 0x5df7},
	{0xb9ac, 0x5e78},
	{0xb9ad, 0x5e83},
	{0xb9ae, 0x5e9a},
	{0xb9af, 0x5eb7},
	{0xb9b0, 0x5f18},
	{0xb9b1, 0x6052},
	{0xb9b2, 0x614c},
	{0xb9b3, 0x6297},
	{0xb9b4, 0x62d8},
	{0xb9b5, 0x63a7},
	{0xb9b6, 0x653b},
	{0xb9b7, 0x6602},
	{0xb9b8, 0x6643},
	{0xb9b9, 0x66f4},
	{0xb9ba, 0x676d},
	{0xb9bb, 0x6821},
	{0xb9bc, 0x6897},
	{0xb9bd, 0x69cb},
	{0xb9be, 0x6c5f},
	{0xb9bf, 0x6d2a},
	{0xb9c0, 0x6d69},
	{0xb9c1, 0x6e2f},
	{0xb9c2, 0x6e9d},
	{0xb9c3, 0x7532},
	{0xb9c4, 0x7687},
	{0xb9c5, 0x786c},
	{0xb9c6, 0x7a3f},
	{0xb9c7, 0x7ce0},
	{0xb9c8, 0x7d05},
	{0xb9c9, 0x7d18},
	{0xb9ca, 0x7d5e},
	{0xb9cb, 0x7db1},
	{0xb9cc, 0x8015},
	{0xb9cd, 0x8003},
	{0xb9ce, 0x80af},
	{0xb9cf, 0x80b1},
	{0xb9d0, 0x8154},
	{0xb9d1, 0x818f},
	{0xb9d2, 0x822a},
	{0xb9d3, 0x8352},
	{0xb9d4, 0x884c},
	{0xb9d5, 0x8861},
	{0xb9d6, 0x8b1b},
	{0xb9d7, 0x8ca2},
	{0xb9d8, 0x8cfc},
	{0xb9d9, 0x90ca},
	{0xb9da, 0x9175},
	{0xb9db, 0x9271},
	{0xb9dc, 0x783f},
	{0xb9dd, 0x92fc},
	{0xb9de, 0x95a4},
	{0xb9df, 0x964d},
	{0xb9e0, 0x9805},
	{0xb9e1, 0x9999},
	{0xb9e2, 0x9ad8},
	{0xb9e3, 0x9d3b},
	{0xb9e4, 0x525b},
	{0xb9e5, 0x52ab},
	{0xb9e6, 0x53f7},
	{0xb9e7, 0x5408},
	{0xb9e8, 0x58d5},
	{0xb9e9, 0x62f7},
	{0xb9ea, 0x6fe0},
	{0xb9eb, 0x8c6a},
	{0xb9ec, 0x8f5f},
	{0xb9ed, 0x9eb9},
	{0xb9ee, 0x514b},
	{0xb9ef, 0x523b},
	{0xb9f0, 0x544a},
	{0xb9f1, 0x56fd},
	{0xb9f2, 0x7a40},
	{0xb9f3, 0x9177},
	{0xb9f4, 0x9d60},
	{0xb9f5, 0x9ed2},
	{0xb9f6, 0x7344},
	{0xb9f7, 0x6f09},
	{0xb9f8, 0x8170},
	{0xb9f9, 0x7511},
	{0xb9fa, 0x5ffd},
	{0xb9fb, 0x60da},
	{0xb9fc, 0x9aa8},
	{0xb9fd, 0x72db},
	{0xb9fe, 0x8fbc},
	{0xbaa1, 0x6b64},
	{0xbaa2, 0x9803},
	{0xbaa3, 0x4eca},
	{0xbaa4, 0x56f0},
	{0xbaa5, 0x5764},
	{0xbaa6, 0x58be},
	{0xbaa7, 0x5a5a},
	{0xbaa8, 0x6068},
	{0xbaa9, 0x61c7},
	{0xbaaa, 0x660f},
	{0xbaab, 0x6606},
	{0xbaac, 0x6839},
	{0xbaad, 0x68b1},
	{0xbaae, 0x6df7},
	{0xbaaf, 0x75d5},
	{0xbab0, 0x7d3a},
	{0xbab1, 0x826e},
	{0xbab2, 0x9b42},
	{0xbab3, 0x4e9b},
	{0xbab4, 0x4f50},
	{0xbab5, 0x53c9},
	{0xbab6, 0x5506},
	{0xbab7, 0x5d6f},
	{0xbab8, 0x5de6},
	{0xbab9, 0x5dee},
	{0xbaba, 0x67fb},
	{0xbabb, 0x6c99},
	{0xbabc, 0x7473},
	{0xbabd, 0x7802},
	{0xbabe, 0x8a50},
	{0xbabf, 0x9396},
	{0xbac0, 0x88df},
	{0xbac1, 0x5750},
	{0xbac2, 0x5ea7},
	{0xbac3, 0x632b},
	{0xbac4, 0x50b5},
	{0xbac5, 0x50ac},
	{0xbac6, 0x518d},
	{0xbac7, 0x6700},
	{0xbac8, 0x54c9},
	{0xbac9, 0x585e},
	{0xbaca, 0x59bb},
	{0xbacb, 0x5bb0},
	{0xbacc, 0x5f69},
	{0xbacd, 0x624d},
	{0xbace, 0x63a1},
	{0xbacf, 0x683d},
	{0xbad0, 0x6b73},
	{0xbad1, 0x6e08},
	{0xbad2, 0x707d},
	{0xbad3, 0x91c7},
	{0xbad4, 0x7280},
	{0xbad5, 0x7815},
	{0xbad6, 0x7826},
	{0xbad7, 0x796d},
	{0xbad8, 0x658e},
	{0xbad9, 0x7d30},
	{0xbada, 0x83dc},
	{0xbadb, 0x88c1},
	{0xbadc, 0x8f09},
	{0xbadd, 0x969b},
	{0xbade, 0x5264},
	{0xbadf, 0x5728},
	{0xbae0, 0x6750},
	{0xbae1, 0x7f6a},
	{0xbae2, 0x8ca1},
	{0xbae3, 0x51b4},
	{0xbae4, 0x5742},
	{0xbae5, 0x962a},
	{0xbae6, 0x583a},
	{0xbae7, 0x698a},
	{0xbae8, 0x80b4},
	{0xbae9, 0x54b2},
	{0xbaea, 0x5d0e},
	{0xbaeb, 0x57fc},
	{0xbaec, 0x7895},
	{0xbaed, 0x9dfa},
	{0xbaee, 0x4f5c},
	{0xbaef, 0x524a},
	{0xbaf0, 0x548b},
	{0xbaf1, 0x643e},
	{0xbaf2, 0x6628},
	{0xbaf3, 0x6714},
	{0xbaf4, 0x67f5},
	{0xbaf5, 0x7a84},
	{0xbaf6, 0x7b56},
	{0xbaf7, 0x7d22},
	{0xbaf8, 0x932f},
	{0xbaf9, 0x685c},
	{0xbafa, 0x9bad},
	{0xbafb, 0x7b39},
	{0xbafc, 0x5319},
	{0xbafd, 0x518a},
	{0xbafe, 0x5237},
	{0xbba1, 0x5bdf},
	{0xbba2, 0x62f6},
	{0xbba3, 0x64ae},
	{0xbba4, 0x64e6},
	{0xbba5, 0x672d},
	{0xbba6, 0x6bba},
	{0xbba7, 0x85a9},
	{0xbba8, 0x96d1},
	{0xbba9, 0x7690},
	{0xbbaa, 0x9bd6},
	{0xbbab, 0x634c},
	{0xbbac, 0x9306},
	{0xbbad, 0x9bab},
	{0xbbae, 0x76bf},
	{0xbbaf, 0x6652},
	{0xbbb0, 0x4e09},
	{0xbbb1, 0x5098},
	{0xbbb2, 0x53c2},
	{0xbbb3, 0x5c71},
	{0xbbb4, 0x60e8},
	{0xbbb5, 0x6492},
	{0xbbb6, 0x6563},
	{0xbbb7, 0x685f},
	{0xbbb8, 0x71e6},
	{0xbbb9, 0x73ca},
	{0xbbba, 0x7523},
	{0xbbbb, 0x7b97},
	{0xbbbc, 0x7e82},
	{0xbbbd, 0x8695},
	{0xbbbe, 0x8b83},
	{0xbbbf, 0x8cdb},
	{0xbbc0, 0x9178},
	{0xbbc1, 0x9910},
	{0xbbc2, 0x65ac},
	{0xbbc3, 0x66ab},
	{0xbbc4, 0x6b8b},
	{0xbbc5, 0x4ed5},
	{0xbbc6, 0x4ed4},
	{0xbbc7, 0x4f3a},
	{0xbbc8, 0x4f7f},
	{0xbbc9, 0x523a},
	{0xbbca, 0x53f8},
	{0xbbcb, 0x53f2},
	{0xbbcc, 0x55e3},
	{0xbbcd, 0x56db},
	{0xbbce, 0x58eb},
	{0xbbcf, 0x59cb},
	{0xbbd0, 0x59c9},
	{0xbbd1, 0x59ff},
	{0xbbd2, 0x5b50},
	{0xbbd3, 0x5c4d},
	{0xbbd4, 0x5e02},
	{0xbbd5, 0x5e2b},
	{0xbbd6, 0x5fd7},
	{0xbbd7, 0x601d},
	{0xbbd8, 0x6307},
	{0xbbd9, 0x652f},
	{0xbbda, 0x5b5c},
	{0xbbdb, 0x65af},
	{0xbbdc, 0x65bd},
	{0xbbdd, 0x65e8},
	{0xbbde, 0x679d},
	{0xbbdf, 0x6b62},
	{0xbbe0, 0x6b7b},
	{0xbbe1, 0x6c0f},
	{0xbbe2, 0x7345},
	{0xbbe3, 0x7949},
	{0xbbe4, 0x79c1},
	{0xbbe5, 0x7cf8},
	{0xbbe6, 0x7d19},
	{0xbbe7, 0x7d2b},
	{0xbbe8, 0x80a2},
	{0xbbe9, 0x8102},
	{0xbbea, 0x81f3},
	{0xbbeb, 0x8996},
	{0xbbec, 0x8a5e},
	{0xbbed, 0x8a69},
	{0xbbee, 0x8a66},
	{0xbbef, 0x8a8c},
	{0xbbf0, 0x8aee},
	{0xbbf1, 0x8cc7},
	{0xbbf2, 0x8cdc},
	{0xbbf3, 0x96cc},
	{0xbbf4, 0x98fc},
	{0xbbf5, 0x6b6f},
	{0xbbf6, 0x4e8b},
	{0xbbf7, 0x4f3c},
	{0xbbf8, 0x4f8d},
	{0xbbf9, 0x5150},
	{0xbbfa, 0x5b57},
	{0xbbfb, 0x5bfa},
	{0xbbfc, 0x6148},
	{0xbbfd, 0x6301},
	{0xbbfe, 0x6642},
	{0xbca1, 0x6b21},
	{0xbca2, 0x6ecb},
	{0xbca3, 0x6cbb},
	{0xbca4, 0x723e},
	{0xbca5, 0x74bd},
	{0xbca6, 0x75d4},
	{0xbca7, 0x78c1},
	{0xbca8, 0x793a},
	{0xbca9, 0x800c},
	{0xbcaa, 0x8033},
	{0xbcab, 0x81ea},
	{0xbcac, 0x8494},
	{0xbcad, 0x8f9e},
	{0xbcae, 0x6c50},
	{0xbcaf, 0x9e7f},
	{0xbcb0, 0x5f0f},
	{0xbcb1, 0x8b58},
	{0xbcb2, 0x9d2b},
	{0xbcb3, 0x7afa},
	{0xbcb4, 0x8ef8},
	{0xbcb5, 0x5b8d},
	{0xbcb6, 0x96eb},
	{0xbcb7, 0x4e03},
	{0xbcb8, 0x53f1},
	{0xbcb9, 0x57f7},
	{0xbcba, 0x5931},
	{0xbcbb, 0x5ac9},
	{0xbcbc, 0x5ba4},
	{0xbcbd, 0x6089},
	{0xbcbe, 0x6e7f},
	{0xbcbf, 0x6f06},
	{0xbcc0, 0x75be},
	{0xbcc1, 0x8cea},
	{0xbcc2, 0x5b9f},
	{0xbcc3, 0x8500},
	{0xbcc4, 0x7be0},
	{0xbcc5, 0x5072},
	{0xbcc6, 0x67f4},
	{0xbcc7, 0x829d},
	{0xbcc8, 0x5c61},
	{0xbcc9, 0x854a},
	{0xbcca, 0x7e1e},
	{0xbccb, 0x820e},
	{0xbccc, 0x5199},
	{0xbccd, 0x5c04},
	{0xbcce, 0x6368},
	{0xbccf, 0x8d66},
	{0xbcd0, 0x659c},
	{0xbcd1, 0x716e},
	{0xbcd2, 0x793e},
	{0xbcd3, 0x7d17},
	{0xbcd4, 0x8005},
	{0xbcd5, 0x8b1d},
	{0xbcd6, 0x8eca},
	{0xbcd7, 0x906e},
	{0xbcd8, 0x86c7},
	{0xbcd9, 0x90aa},
	{0xbcda, 0x501f},
	{0xbcdb, 0x52fa},
	{0xbcdc, 0x5c3a},
	{0xbcdd, 0x6753},
	{0xbcde, 0x707c},
	{0xbcdf, 0x7235},
	{0xbce0, 0x914c},
	{0xbce1, 0x91c8},
	{0xbce2, 0x932b},
	{0xbce3, 0x82e5},
	{0xbce4, 0x5bc2},
	{0xbce5, 0x5f31},
	{0xbce6, 0x60f9},
	{0xbce7, 0x4e3b},
	{0xbce8, 0x53d6},
	{0xbce9, 0x5b88},
	{0xbcea, 0x624b},
	{0xbceb, 0x6731},
	{0xbcec, 0x6b8a},
	{0xbced, 0x72e9},
	{0xbcee, 0x73e0},
	{0xbcef, 0x7a2e},
	{0xbcf0, 0x816b},
	{0xbcf1, 0x8da3},
	{0xbcf2, 0x9152},
	{0xbcf3, 0x9996},
	{0xbcf4, 0x5112},
	{0xbcf5, 0x53d7},
	{0xbcf6, 0x546a},
	{0xbcf7, 0x5bff},
	{0xbcf8, 0x6388},
	{0xbcf9, 0x6a39},
	{0xbcfa, 0x7dac},
	{0xbcfb, 0x9700},
	{0xbcfc, 0x56da},
	{0xbcfd, 0x53ce},
	{0xbcfe, 0x5468},
	{0xbda1, 0x5b97},
	{0xbda2, 0x5c31},
	{0xbda3, 0x5dde},
	{0xbda4, 0x4fee},
	{0xbda5, 0x6101},
	{0xbda6, 0x62fe},
	{0xbda7, 0x6d32},
	{0xbda8, 0x79c0},
	{0xbda9, 0x79cb},
	{0xbdaa, 0x7d42},
	{0xbdab, 0x7e4d},
	{0xbdac, 0x7fd2},
	{0xbdad, 0x81ed},
	{0xbdae, 0x821f},
	{0xbdaf, 0x8490},
	{0xbdb0, 0x8846},
	{0xbdb1, 0x8972},
	{0xbdb2, 0x8b90},
	{0xbdb3, 0x8e74},
	{0xbdb4, 0x8f2f},
	{0xbdb5, 0x9031},
	{0xbdb6, 0x914b},
	{0xbdb7, 0x916c},
	{0xbdb8, 0x96c6},
	{0xbdb9, 0x919c},
	{0xbdba, 0x4ec0},
	{0xbdbb, 0x4f4f},
	{0xbdbc, 0x5145},
	{0xbdbd, 0x5341},
	{0xbdbe, 0x5f93},
	{0xbdbf, 0x620e},
	{0xbdc0, 0x67d4},
	{0xbdc1, 0x6c41},
	{0xbdc2, 0x6e0b},
	{0xbdc3, 0x7363},
	{0xbdc4, 0x7e26},
	{0xbdc5, 0x91cd},
	{0xbdc6, 0x9283},
	{0xbdc7, 0x53d4},
	{0xbdc8, 0x5919},
	{0xbdc9, 0x5bbf},
	{0xbdca, 0x6dd1},
	{0xbdcb, 0x795d},
	{0xbdcc, 0x7e2e},
	{0xbdcd, 0x7c9b},
	{0xbdce, 0x587e},
	{0xbdcf, 0x719f},
	{0xbdd0, 0x51fa},
	{0xbdd1, 0x8853},
	{0xbdd2, 0x8ff0},
	{0xbdd3, 0x4fca},
	{0xbdd4, 0x5cfb},
	{0xbdd5, 0x6625},
	{0xbdd6, 0x77ac},
	{0xbdd7, 0x7ae3},
	{0xbdd8, 0x821c},
	{0xbdd9, 0x99ff},
	{0xbdda, 0x51c6},
	{0xbddb, 0x5faa},
	{0xbddc, 0x65ec},
	{0xbddd, 0x696f},
	{0xbdde, 0x6b89},
	{0xbddf, 0x6df3},
	{0xbde0, 0x6e96},
	{0xbde1, 0x6f64},
	{0xbde2, 0x76fe},
	{0xbde3, 0x7d14},
	{0xbde4, 0x5de1},
	{0xbde5, 0x9075},
	{0xbde6, 0x9187},
	{0xbde7, 0x9806},
	{0xbde8, 0x51e6},
	{0xbde9, 0x521d},
	{0xbdea, 0x6240},
	{0xbdeb, 0x6691},
	{0xbdec, 0x66d9},
	{0xbded, 0x6e1a},
	{0xbdee, 0x5eb6},
	{0xbdef, 0x7dd2},
	{0xbdf0, 0x7f72},
	{0xbdf1, 0x66f8},
	{0xbdf2, 0x85af},
	{0xbdf3, 0x85f7},
	{0xbdf4, 0x8af8},
	{0xbdf5, 0x52a9},
	{0xbdf6, 0x53d9},
	{0xbdf7, 0x5973},
	{0xbdf8, 0x5e8f},
	{0xbdf9, 0x5f90},
	{0xbdfa, 0x6055},
	{0xbdfb, 0x92e4},
	{0xbdfc, 0x9664},
	{0xbdfd, 0x50b7},
	{0xbdfe, 0x511f},
	{0xbea1, 0x52dd},
	{0xbea2, 0x5320},
	{0xbea3, 0x5347},
	{0xbea4, 0x53ec},
	{0xbea5, 0x54e8},
	{0xbea6, 0x5546},
	{0xbea7, 0x5531},
	{0xbea8, 0x5617},
	{0xbea9, 0x5968},
	{0xbeaa, 0x59be},
	{0xbeab, 0x5a3c},
	{0xbeac, 0x5bb5},
	{0xbead, 0x5c06},
	{0xbeae, 0x5c0f},
	{0xbeaf, 0x5c11},
	{0xbeb0, 0x5c1a},
	{0xbeb1, 0x5e84},
	{0xbeb2, 0x5e8a},
	{0xbeb3, 0x5ee0},
	{0xbeb4, 0x5f70},
	{0xbeb5, 0x627f},
	{0xbeb6, 0x6284},
	{0xbeb7, 0x62db},
	{0xbeb8, 0x638c},
	{0xbeb9, 0x6377},
	{0xbeba, 0x6607},
	{0xbebb, 0x660c},
	{0xbebc, 0x662d},
	{0xbebd, 0x6676},
	{0xbebe, 0x677e},
	{0xbebf, 0x68a2},
	{0xbec0, 0x6a1f},
	{0xbec1, 0x6a35},
	{0xbec2, 0x6cbc},
	{0xbec3, 0x6d88},
	{0xbec4, 0x6e09},
	{0xbec5, 0x6e58},
	{0xbec6, 0x713c},
	{0xbec7, 0x7126},
	{0xbec8, 0x7167},
	{0xbec9, 0x75c7},
	{0xbeca, 0x7701},
	{0xbecb, 0x785d},
	{0xbecc, 0x7901},
	{0xbecd, 0x7965},
	{0xbece, 0x79f0},
	{0xbecf, 0x7ae0},
	{0xbed0, 0x7b11},
	{0xbed1, 0x7ca7},
	{0xbed2, 0x7d39},
	{0xbed3, 0x8096},
	{0xbed4, 0x83d6},
	{0xbed5, 0x848b},
	{0xbed6, 0x8549},
	{0xbed7, 0x885d},
	{0xbed8, 0x88f3},
	{0xbed9, 0x8a1f},
	{0xbeda, 0x8a3c},
	{0xbedb, 0x8a54},
	{0xbedc, 0x8a73},
	{0xbedd, 0x8c61},
	{0xbede, 0x8cde},
	{0xbedf, 0x91a4},
	{0xbee0, 0x9266},
	{0xbee1, 0x937e},
	{0xbee2, 0x9418},
	{0xbee3, 0x969c},
	{0xbee4, 0x9798},
	{0xbee5, 0x4e0a},
	{0xbee6, 0x4e08},
	{0xbee7, 0x4e1e},
	{0xbee8, 0x4e57},
	{0xbee9, 0x5197},
	{0xbeea, 0x5270},
	{0xbeeb, 0x57ce},
	{0xbeec, 0x5834},
	{0xbeed, 0x58cc},
	{0xbeee, 0x5b22},
	{0xbeef, 0x5e38},
	{0xbef0, 0x60c5},
	{0xbef1, 0x64fe},
	{0xbef2, 0x6761},
	{0xbef3, 0x6756},
	{0xbef4, 0x6d44},
	{0xbef5, 0x72b6},
	{0xbef6, 0x7573},
	{0xbef7, 0x7a63},
	{0xbef8, 0x84b8},
	{0xbef9, 0x8b72},
	{0xbefa, 0x91b8},
	{0xbefb, 0x9320},
	{0xbefc, 0x5631},
	{0xbefd, 0x57f4},
	{0xbefe, 0x98fe},
	{0xbfa1, 0x62ed},
	{0xbfa2, 0x690d},
	{0xbfa3, 0x6b96},
	{0xbfa4, 0x71ed},
	{0xbfa5, 0x7e54},
	{0xbfa6, 0x8077},
	{0xbfa7, 0x8272},
	{0xbfa8, 0x89e6},
	{0xbfa9, 0x98df},
	{0xbfaa, 0x8755},
	{0xbfab, 0x8fb1},
	{0xbfac, 0x5c3b},
	{0xbfad, 0x4f38},
	{0xbfae, 0x4fe1},
	{0xbfaf, 0x4fb5},
	{0xbfb0, 0x5507},
	{0xbfb1, 0x5a20},
	{0xbfb2, 0x5bdd},
	{0xbfb3, 0x5be9},
	{0xbfb4, 0x5fc3},
	{0xbfb5, 0x614e},
	{0xbfb6, 0x632f},
	{0xbfb7, 0x65b0},
	{0xbfb8, 0x664b},
	{0xbfb9, 0x68ee},
	{0xbfba, 0x699b},
	{0xbfbb, 0x6d78},
	{0xbfbc, 0x6df1},
	{0xbfbd, 0x7533},
	{0xbfbe, 0x75b9},
	{0xbfbf, 0x771f},
	{0xbfc0, 0x795e},
	{0xbfc1, 0x79e6},
	{0xbfc2, 0x7d33},
	{0xbfc3, 0x81e3},
	{0xbfc4, 0x82af},
	{0xbfc5, 0x85aa},
	{0xbfc6, 0x89aa},
	{0xbfc7, 0x8a3a},
	{0xbfc8, 0x8eab},
	{0xbfc9, 0x8f9b},
	{0xbfca, 0x9032},
	{0xbfcb, 0x91dd},
	{0xbfcc, 0x9707},
	{0xbfcd, 0x4eba},
	{0xbfce, 0x4ec1},
	{0xbfcf, 0x5203},
	{0xbfd0, 0x5875},
	{0xbfd1, 0x58ec},
	{0xbfd2, 0x5c0b},
	{0xbfd3, 0x751a},
	{0xbfd4, 0x5c3d},
	{0xbfd5, 0x814e},
	{0xbfd6, 0x8a0a},
	{0xbfd7, 0x8fc5},
	{0xbfd8, 0x9663},
	{0xbfd9, 0x976d},
	{0xbfda, 0x7b25},
	{0xbfdb, 0x8acf},
	{0xbfdc, 0x9808},
	{0xbfdd, 0x9162},
	{0xbfde, 0x56f3},
	{0xbfdf, 0x53a8},
	{0xbfe0, 0x9017},
	{0xbfe1, 0x5439},
	{0xbfe2, 0x5782},
	{0xbfe3, 0x5e25},
	{0xbfe4, 0x63a8},
	{0xbfe5, 0x6c34},
	{0xbfe6, 0x708a},
	{0xbfe7, 0x7761},
	{0xbfe8, 0x7c8b},
	{0xbfe9, 0x7fe0},
	{0xbfea, 0x8870},
	{0xbfeb, 0x9042},
	{0xbfec, 0x9154},
	{0xbfed, 0x9310},
	{0xbfee, 0x9318},
	{0xbfef, 0x968f},
	{0xbff0, 0x745e},
	{0xbff1, 0x9ac4},
	{0xbff2, 0x5d07},
	{0xbff3, 0x5d69},
	{0xbff4, 0x6570},
	{0xbff5, 0x67a2},
	{0xbff6, 0x8da8},
	{0xbff7, 0x96db},
	{0xbff8, 0x636e},
	{0xbff9, 0x6749},
	{0xbffa, 0x6919},
	{0xbffb, 0x83c5},
	{0xbffc, 0x9817},
	{0xbffd, 0x96c0},
	{0xbffe, 0x88fe},
	{0xc0a1, 0x6f84},
	{0xc0a2, 0x647a},
	{0xc0a3, 0x5bf8},
	{0xc0a4, 0x4e16},
	{0xc0a5, 0x702c},
	{0xc0a6, 0x755d},
	{0xc0a7, 0x662f},
	{0xc0a8, 0x51c4},
	{0xc0a9, 0x5236},
	{0xc0aa, 0x52e2},
	{0xc0ab, 0x59d3},
	{0xc0ac, 0x5f81},
	{0xc0ad, 0x6027},
	{0xc0ae, 0x6210},
	{0xc0af, 0x653f},
	{0xc0b0, 0x6574},
	{0xc0b1, 0x661f},
	{0xc0b2, 0x6674},
	{0xc0b3, 0x68f2},
	{0xc0b4, 0x6816},
	{0xc0b5, 0x6b63},
	{0xc0b6, 0x6e05},
	{0xc0b7, 0x7272},
	{0xc0b8, 0x751f},
	{0xc0b9, 0x76db},
	{0xc0ba, 0x7cbe},
	{0xc0bb, 0x8056},
	{0xc0bc, 0x58f0},
	{0xc0bd, 0x88fd},
	{0xc0be, 0x897f},
	{0xc0bf, 0x8aa0},
	{0xc0c0, 0x8a93},
	{0xc0c1, 0x8acb},
	{0xc0c2, 0x901d},
	{0xc0c3, 0x9192},
	{0xc0c4, 0x9752},
	{0xc0c5, 0x9759},
	{0xc0c6, 0x6589},
	{0xc0c7, 0x7a0e},
	{0xc0c8, 0x8106},
	{0xc0c9, 0x96bb},
	{0xc0ca, 0x5e2d},
	{0xc0cb, 0x60dc},
	{0xc0cc, 0x621a},
	{0xc0cd, 0x65a5},
	{0xc0ce, 0x6614},
	{0xc0cf, 0x6790},
	{0xc0d0, 0x77f3},
	{0xc0d1, 0x7a4d},
	{0xc0d2, 0x7c4d},
	{0xc0d3, 0x7e3e},
	{0xc0d4, 0x810a},
	{0xc0d5, 0x8cac},
	{0xc0d6, 0x8d64},
	{0xc0d7, 0x8de1},
	{0xc0d8, 0x8e5f},
	{0xc0d9, 0x78a9},
	{0xc0da, 0x5207},
	{0xc0db, 0x62d9},
	{0xc0dc, 0x63a5},
	{0xc0dd, 0x6442},
	{0xc0de, 0x6298},
	{0xc0df, 0x8a2d},
	{0xc0e0, 0x7a83},
	{0xc0e1, 0x7bc0},
	{0xc0e2, 0x8aac},
	{0xc0e3, 0x96ea},
	{0xc0e4, 0x7d76},
	{0xc0e5, 0x820c},
	{0xc0e6, 0x8749},
	{0xc0e7, 0x4ed9},
	{0xc0e8, 0x5148},
	{0xc0e9, 0x5343},
	{0xc0ea, 0x5360},
	{0xc0eb, 0x5ba3},
	{0xc0ec, 0x5c02},
	{0xc0ed, 0x5c16},
	{0xc0ee, 0x5ddd},
	{0xc0ef, 0x6226},
	{0xc0f0, 0x6247},
	{0xc0f1, 0x64b0},
	{0xc0f2, 0x6813},
	{0xc0f3, 0x6834},
	{0xc0f4, 0x6cc9},
	{0xc0f5, 0x6d45},
	{0xc0f6, 0x6d17},
	{0xc0f7, 0x67d3},
	{0xc0f8, 0x6f5c},
	{0xc0f9, 0x714e},
	{0xc0fa, 0x717d},
	{0xc0fb, 0x65cb},
	{0xc0fc, 0x7a7f},
	{0xc0fd, 0x7bad},
	{0xc0fe, 0x7dda},
	{0xc1a1, 0x7e4a},
	{0xc1a2, 0x7fa8},
	{0xc1a3, 0x817a},
	{0xc1a4, 0x821b},
	{0xc1a5, 0x8239},
	{0xc1a6, 0x85a6},
	{0xc1a7, 0x8a6e},
	{0xc1a8, 0x8cce},
	{0xc1a9, 0x8df5},
	{0xc1aa, 0x9078},
	{0xc1ab, 0x9077},
	{0xc1ac, 0x92ad},
	{0xc1ad, 0x9291},
	{0xc1ae, 0x9583},
	{0xc1af, 0x9bae},
	{0xc1b0, 0x524d},
	{0xc1b1, 0x5584},
	{0xc1b2, 0x6f38},
	{0xc1b3, 0x7136},
	{0xc1b4, 0x5168},
	{0xc1b5, 0x7985},
	{0xc1b6, 0x7e55},
	{0xc1b7, 0x81b3},
	{0xc1b8, 0x7cce},
	{0xc1b9, 0x564c},
	{0xc1ba, 0x5851},
	{0xc1bb, 0x5ca8},
	{0xc1bc, 0x63aa},
	{0xc1bd, 0x66fe},
	{0xc1be, 0x66fd},
	{0xc1bf, 0x695a},
	{0xc1c0, 0x72d9},
	{0xc1c1, 0x758f},
	{0xc1c2, 0x758e},
	{0xc1c3, 0x790e},
	{0xc1c4, 0x7956},
	{0xc1c5, 0x79df},
	{0xc1c6, 0x7c97},
	{0xc1c7, 0x7d20},
	{0xc1c8, 0x7d44},
	{0xc1c9, 0x8607},
	{0xc1ca, 0x8a34},
	{0xc1cb, 0x963b},
	{0xc1cc, 0x9061},
	{0xc1cd, 0x9f20},
	{0xc1ce, 0x50e7},
	{0xc1cf, 0x5275},
	{0xc1d0, 0x53cc},
	{0xc1d1, 0x53e2},
	{0xc1d2, 0x5009},
	{0xc1d3, 0x55aa},
	{0xc1d4, 0x58ee},
	{0xc1d5, 0x594f},
	{0xc1d6, 0x723d},
	{0xc1d7, 0x5b8b},
	{0xc1d8, 0x5c64},
	{0xc1d9, 0x531d},
	{0xc1da, 0x60e3},
	{0xc1db, 0x60f3},
	{0xc1dc, 0x635c},
	{0xc1dd, 0x6383},
	{0xc1de, 0x633f},
	{0xc1df, 0x63bb},
	{0xc1e0, 0x64cd},
	{0xc1e1, 0x65e9},
	{0xc1e2, 0x66f9},
	{0xc1e3, 0x5de3},
	{0xc1e4, 0x69cd},
	{0xc1e5, 0x69fd},
	{0xc1e6, 0x6f15},
	{0xc1e7, 0x71e5},
	{0xc1e8, 0x4e89},
	{0xc1e9, 0x75e9},
	{0xc1ea, 0x76f8},
	{0xc1eb, 0x7a93},
	{0xc1ec, 0x7cdf},
	{0xc1ed, 0x7dcf},
	{0xc1ee, 0x7d9c},
	{0xc1ef, 0x8061},
	{0xc1f0, 0x8349},
	{0xc1f1, 0x8358},
	{0xc1f2, 0x846c},
	{0xc1f3, 0x84bc},
	{0xc1f4, 0x85fb},
	{0xc1f5, 0x88c5},
	{0xc1f6, 0x8d70},
	{0xc1f7, 0x9001},
	{0xc1f8, 0x906d},
	{0xc1f9, 0x9397},
	{0xc1fa, 0x971c},
	{0xc1fb, 0x9a12},
	{0xc1fc, 0x50cf},
	{0xc1fd, 0x5897},
	{0xc1fe, 0x618e},
	{0xc2a1, 0x81d3},
	{0xc2a2, 0x8535},
	{0xc2a3, 0x8d08},
	{0xc2a4, 0x9020},
	{0xc2a5, 0x4fc3},
	{0xc2a6, 0x5074},
	{0xc2a7, 0x5247},
	{0xc2a8, 0x5373},
	{0xc2a9, 0x606f},
	{0xc2aa, 0x6349},
	{0xc2ab, 0x675f},
	{0xc2ac, 0x6e2c},
	{0xc2ad, 0x8db3},
	{0xc2ae, 0x901f},
	{0xc2af, 0x4fd7},
	{0xc2b0, 0x5c5e},
	{0xc2b1, 0x8cca},
	{0xc2b2, 0x65cf},
	{0xc2b3, 0x7d9a},
	{0xc2b4, 0x5352},
	{0xc2b5, 0x8896},
	{0xc2b6, 0x5176},
	{0xc2b7, 0x63c3},
	{0xc2b8, 0x5b58},
	{0xc2b9, 0x5b6b},
	{0xc2ba, 0x5c0a},
	{0xc2bb, 0x640d},
	{0xc2bc, 0x6751},
	{0xc2bd, 0x905c},
	{0xc2be, 0x4ed6},
	{0xc2bf, 0x591a},
	{0xc2c0, 0x592a},
	{0xc2c1, 0x6c70},
	{0xc2c2, 0x8a51},
	{0xc2c3, 0x553e},
	{0xc2c4, 0x5815},
	{0xc2c5, 0x59a5},
	{0xc2c6, 0x60f0},
	{0xc2c7, 0x6253},
	{0xc2c8, 0x67c1},
	{0xc2c9, 0x8235},
	{0xc2ca, 0x6955},
	{0xc2cb, 0x9640},
	{0xc2cc, 0x99c4},
	{0xc2cd, 0x9a28},
	{0xc2ce, 0x4f53},
	{0xc2cf, 0x5806},
	{0xc2d0, 0x5bfe},
	{0xc2d1, 0x8010},
	{0xc2d2, 0x5cb1},
	{0xc2d3, 0x5e2f},
	{0xc2d4, 0x5f85},
	{0xc2d5, 0x6020},
	{0xc2d6, 0x614b},
	{0xc2d7, 0x6234},
	{0xc2d8, 0x66ff},
	{0xc2d9, 0x6cf0},
	{0xc2da, 0x6ede},
	{0xc2db, 0x80ce},
	{0xc2dc, 0x817f},
	{0xc2dd, 0x82d4},
	{0xc2de, 0x888b},
	{0xc2df, 0x8cb8},
	{0xc2e0, 0x9000},
	{0xc2e1, 0x902e},
	{0xc2e2, 0x968a},
	{0xc2e3, 0x9edb},
	{0xc2e4, 0x9bdb},
	{0xc2e5, 0x4ee3},
	{0xc2e6, 0x53f0},
	{0xc2e7, 0x5927},
	{0xc2e8, 0x7b2c},
	{0xc2e9, 0x918d},
	{0xc2ea, 0x984c},
	{0xc2eb, 0x9df9},
	{0xc2ec, 0x6edd},
	{0xc2ed, 0x7027},
	{0xc2ee, 0x5353},
	{0xc2ef, 0x5544},
	{0xc2f0, 0x5b85},
	{0xc2f1, 0x6258},
	{0xc2f2, 0x629e},
	{0xc2f3, 0x62d3},
	{0xc2f4, 0x6ca2},
	{0xc2f5, 0x6fef},
	{0xc2f6, 0x7422},
	{0xc2f7, 0x8a17},
	{0xc2f8, 0x9438},
	{0xc2f9, 0x6fc1},
	{0xc2fa, 0x8afe},
	{0xc2fb, 0x8338},
	{0xc2fc, 0x51e7},
	{0xc2fd, 0x86f8},
	{0xc2fe, 0x53ea},
	{0xc3a1, 0x53e9},
	{0xc3a2, 0x4f46},
	{0xc3a3, 0x9054},
	{0xc3a4, 0x8fb0},
	{0xc3a5, 0x596a},
	{0xc3a6, 0x8131},
	{0xc3a7, 0x5dfd},
	{0xc3a8, 0x7aea},
	{0xc3a9, 0x8fbf},
	{0xc3aa, 0x68da},
	{0xc3ab, 0x8c37},
	{0xc3ac, 0x72f8},
	{0xc3ad, 0x9c48},
	{0xc3ae, 0x6a3d},
	{0xc3af, 0x8ab0},
	{0xc3b0, 0x4e39},
	{0xc3b1, 0x5358},
	{0xc3b2, 0x5606},
	{0xc3b3, 0x5766},
	{0xc3b4, 0x62c5},
	{0xc3b5, 0x63a2},
	{0xc3b6, 0x65e6},
	{0xc3b7, 0x6b4e},
	{0xc3b8, 0x6de1},
	{0xc3b9, 0x6e5b},
	{0xc3ba, 0x70ad},
	{0xc3bb, 0x77ed},
	{0xc3bc, 0x7aef},
	{0xc3bd, 0x7baa},
	{0xc3be, 0x7dbb},
	{0xc3bf, 0x803d},
	{0xc3c0, 0x80c6},
	{0xc3c1, 0x86cb},
	{0xc3c2, 0x8a95},
	{0xc3c3, 0x935b},
	{0xc3c4, 0x56e3},
	{0xc3c5, 0x58c7},
	{0xc3c6, 0x5f3e},
	{0xc3c7, 0x65ad},
	{0xc3c8, 0x6696},
	{0xc3c9, 0x6a80},
	{0xc3ca, 0x6bb5},
	{0xc3cb, 0x7537},
	{0xc3cc, 0x8ac7},
	{0xc3cd, 0x5024},
	{0xc3ce, 0x77e5},
	{0xc3cf, 0x5730},
	{0xc3d0, 0x5f1b},
	{0xc3d1, 0x6065},
	{0xc3d2, 0x667a},
	{0xc3d3, 0x6c60},
	{0xc3d4, 0x75f4},
	{0xc3d5, 0x7a1a},
	{0xc3d6, 0x7f6e},
	{0xc3d7, 0x81f4},
	{0xc3d8, 0x8718},
	{0xc3d9, 0x9045},
	{0xc3da, 0x99b3},
	{0xc3db, 0x7bc9},
	{0xc3dc, 0x755c},
	{0xc3dd, 0x7af9},
	{0xc3de, 0x7b51},
	{0xc3df, 0x84c4},
	{0xc3e0, 0x9010},
	{0xc3e1, 0x79e9},
	{0xc3e2, 0x7a92},
	{0xc3e3, 0x8336},
	{0xc3e4, 0x5ae1},
	{0xc3e5, 0x7740},
	{0xc3e6, 0x4e2d},
	{0xc3e7, 0x4ef2},
	{0xc3e8, 0x5b99},
	{0xc3e9, 0x5fe0},
	{0xc3ea, 0x62bd},
	{0xc3eb, 0x663c},
	{0xc3ec, 0x67f1},
	{0xc3ed, 0x6ce8},
	{0xc3ee, 0x866b},
	{0xc3ef, 0x8877},
	{0xc3f0, 0x8a3b},
	{0xc3f1, 0x914e},
	{0xc3f2, 0x92f3},
	{0xc3f3, 0x99d0},
	{0xc3f4, 0x6a17},
	{0xc3f5, 0x7026},
	{0xc3f6, 0x732a},
	{0xc3f7, 0x82e7},
	{0xc3f8, 0x8457},
	{0xc3f9, 0x8caf},
	{0xc3fa, 0x4e01},
	{0xc3fb, 0x5146},
	{0xc3fc, 0x51cb},
	{0xc3fd, 0x558b},
	{0xc3fe, 0x5bf5},
	{0xc4a1, 0x5e16},
	{0xc4a2, 0x5e33},
	{0xc4a3, 0x5e81},
	{0xc4a4, 0x5f14},
	{0xc4a5, 0x5f35},
	{0xc4a6, 0x5f6b},
	{0xc4a7, 0x5fb4},
	{0xc4a8, 0x61f2},
	{0xc4a9, 0x6311},
	{0xc4aa, 0x66a2},
	{0xc4ab, 0x671d},
	{0xc4ac, 0x6f6e},
	{0xc4ad, 0x7252},
	{0xc4ae, 0x753a},
	{0xc4af, 0x773a},
	{0xc4b0, 0x8074},
	{0xc4b1, 0x8139},
	{0xc4b2, 0x8178},
	{0xc4b3, 0x8776},
	{0xc4b4, 0x8abf},
	{0xc4b5, 0x8adc},
	{0xc4b6, 0x8d85},
	{0xc4b7, 0x8df3},
	{0xc4b8, 0x929a},
	{0xc4b9, 0x9577},
	{0xc4ba, 0x9802},
	{0xc4bb, 0x9ce5},
	{0xc4bc, 0x52c5},
	{0xc4bd, 0x6357},
	{0xc4be, 0x76f4},
	{0xc4bf, 0x6715},
	{0xc4c0, 0x6c88},
	{0xc4c1, 0x73cd},
	{0xc4c2, 0x8cc3},
	{0xc4c3, 0x93ae},
	{0xc4c4, 0x9673},
	{0xc4c5, 0x6d25},
	{0xc4c6, 0x589c},
	{0xc4c7, 0x690e},
	{0xc4c8, 0x69cc},
	{0xc4c9, 0x8ffd},
	{0xc4ca, 0x939a},
	{0xc4cb, 0x75db},
	{0xc4cc, 0x901a},
	{0xc4cd, 0x585a},
	{0xc4ce, 0x6802},
	{0xc4cf, 0x63b4},
	{0xc4d0, 0x69fb},
	{0xc4d1, 0x4f43},
	{0xc4d2, 0x6f2c},
	{0xc4d3, 0x67d8},
	{0xc4d4, 0x8fbb},
	{0xc4d5, 0x8526},
	{0xc4d6, 0x7db4},
	{0xc4d7, 0x9354},
	{0xc4d8, 0x693f},
	{0xc4d9, 0x6f70},
	{0xc4da, 0x576a},
	{0xc4db, 0x58f7},
	{0xc4dc, 0x5b2c},
	{0xc4dd, 0x7d2c},
	{0xc4de, 0x722a},
	{0xc4df, 0x540a},
	{0xc4e0, 0x91e3},
	{0xc4e1, 0x9db4},
	{0xc4e2, 0x4ead},
	{0xc4e3, 0x4f4e},
	{0xc4e4, 0x505c},
	{0xc4e5, 0x5075},
	{0xc4e6, 0x5243},
	{0xc4e7, 0x8c9e},
	{0xc4e8, 0x5448},
	{0xc4e9, 0x5824},
	{0xc4ea, 0x5b9a},
	{0xc4eb, 0x5e1d},
	{0xc4ec, 0x5e95},
	{0xc4ed, 0x5ead},
	{0xc4ee, 0x5ef7},
	{0xc4ef, 0x5f1f},
	{0xc4f0, 0x608c},
	{0xc4f1, 0x62b5},
	{0xc4f2, 0x633a},
	{0xc4f3, 0x63d0},
	{0xc4f4, 0x68af},
	{0xc4f5, 0x6c40},
	{0xc4f6, 0x7887},
	{0xc4f7, 0x798e},
	{0xc4f8, 0x7a0b},
	{0xc4f9, 0x7de0},
	{0xc4fa, 0x8247},
	{0xc4fb, 0x8a02},
	{0xc4fc, 0x8ae6},
	{0xc4fd, 0x8e44},
	{0xc4fe, 0x9013},
	{0xc5a1, 0x90b8},
	{0xc5a2, 0x912d},
	{0xc5a3, 0x91d8},
	{0xc5a4, 0x9f0e},
	{0xc5a5, 0x6ce5},
	{0xc5a6, 0x6458},
	{0xc5a7, 0x64e2},
	{0xc5a8, 0x6575},
	{0xc5a9, 0x6ef4},
	{0xc5aa, 0x7684},
	{0xc5ab, 0x7b1b},
	{0xc5ac, 0x9069},
	{0xc5ad, 0x93d1},
	{0xc5ae, 0x6eba},
	{0xc5af, 0x54f2},
	{0xc5b0, 0x5fb9},
	{0xc5b1, 0x64a4},
	{0xc5b2, 0x8f4d},
	{0xc5b3, 0x8fed},
	{0xc5b4, 0x9244},
	{0xc5b5, 0x5178},
	{0xc5b6, 0x586b},
	{0xc5b7, 0x5929},
	{0xc5b8, 0x5c55},
	{0xc5b9, 0x5e97},
	{0xc5ba, 0x6dfb},
	{0xc5bb, 0x7e8f},
	{0xc5bc, 0x751c},
	{0xc5bd, 0x8cbc},
	{0xc5be, 0x8ee2},
	{0xc5bf, 0x985b},
	{0xc5c0, 0x70b9},
	{0xc5c1, 0x4f1d},
	{0xc5c2, 0x6bbf},
	{0xc5c3, 0x6fb1},
	{0xc5c4, 0x7530},
	{0xc5c5, 0x96fb},
	{0xc5c6, 0x514e},
	{0xc5c7, 0x5410},
	{0xc5c8, 0x5835},
	{0xc5c9, 0x5857},
	{0xc5ca, 0x59ac},
	{0xc5cb, 0x5c60},
	{0xc5cc, 0x5f92},
	{0xc5cd, 0x6597},
	{0xc5ce, 0x675c},
	{0xc5cf, 0x6e21},
	{0xc5d0, 0x767b},
	{0xc5d1, 0x83df},
	{0xc5d2, 0x8ced},
	{0xc5d3, 0x9014},
	{0xc5d4, 0x90fd},
	{0xc5d5, 0x934d},
	{0xc5d6, 0x7825},
	{0xc5d7, 0x783a},
	{0xc5d8, 0x52aa},
	{0xc5d9, 0x5ea6},
	{0xc5da, 0x571f},
	{0xc5db, 0x5974},
	{0xc5dc, 0x6012},
	{0xc5dd, 0x5012},
	{0xc5de, 0x515a},
	{0xc5df, 0x51ac},
	{0xc5e0, 0x51cd},
	{0xc5e1, 0x5200},
	{0xc5e2, 0x5510},
	{0xc5e3, 0x5854},
	{0xc5e4, 0x5858},
	{0xc5e5, 0x5957},
	{0xc5e6, 0x5b95},
	{0xc5e7, 0x5cf6},
	{0xc5e8, 0x5d8b},
	{0xc5e9, 0x60bc},
	{0xc5ea, 0x6295},
	{0xc5eb, 0x642d},
	{0xc5ec, 0x6771},
	{0xc5ed, 0x6843},
	{0xc5ee, 0x68bc},
	{0xc5ef, 0x68df},
	{0xc5f0, 0x76d7},
	{0xc5f1, 0x6dd8},
	{0xc5f2, 0x6e6f},
	{0xc5f3, 0x6d9b},
	{0xc5f4, 0x706f},
	{0xc5f5, 0x71c8},
	{0xc5f6, 0x5f53},
	{0xc5f7, 0x75d8},
	{0xc5f8, 0x7977},
	{0xc5f9, 0x7b49},
	{0xc5fa, 0x7b54},
	{0xc5fb, 0x7b52},
	{0xc5fc, 0x7cd6},
	{0xc5fd, 0x7d71},
	{0xc5fe, 0x5230},
	{0xc6a1, 0x8463},
	{0xc6a2, 0x8569},
	{0xc6a3, 0x85e4},
	{0xc6a4, 0x8a0e},
	{0xc6a5, 0x8b04},
	{0xc6a6, 0x8c46},
	{0xc6a7, 0x8e0f},
	{0xc6a8, 0x9003},
	{0xc6a9, 0x900f},
	{0xc6aa, 0x9419},
	{0xc6ab, 0x9676},
	{0xc6ac, 0x982d},
	{0xc6ad, 0x9a30},
	{0xc6ae, 0x95d8},
	{0xc6af, 0x50cd},
	{0xc6b0, 0x52d5},
	{0xc6b1, 0x540c},
	{0xc6b2, 0x5802},
	{0xc6b3, 0x5c0e},
	{0xc6b4, 0x61a7},
	{0xc6b5, 0x649e},
	{0xc6b6, 0x6d1e},
	{0xc6b7, 0x77b3},
	{0xc6b8, 0x7ae5},
	{0xc6b9, 0x80f4},
	{0xc6ba, 0x8404},
	{0xc6bb, 0x9053},
	{0xc6bc, 0x9285},
	{0xc6bd, 0x5ce0},
	{0xc6be, 0x9d07},
	{0xc6bf, 0x533f},
	{0xc6c0, 0x5f97},
	{0xc6c1, 0x5fb3},
	{0xc6c2, 0x6d9c},
	{0xc6c3, 0x7279},
	{0xc6c4, 0x7763},
	{0xc6c5, 0x79bf},
	{0xc6c6, 0x7be4},
	{0xc6c7, 0x6bd2},
	{0xc6c8, 0x72ec},
	{0xc6c9, 0x8aad},
	{0xc6ca, 0x6803},
	{0xc6cb, 0x6a61},
	{0xc6cc, 0x51f8},
	{0xc6cd, 0x7a81},
	{0xc6ce, 0x6934},
	{0xc6cf, 0x5c4a},
	{0xc6d0, 0x9cf6},
	{0xc6d1, 0x82eb},
	{0xc6d2, 0x5bc5},
	{0xc6d3, 0x9149},
	{0xc6d4, 0x701e},
	{0xc6d5, 0x5678},
	{0xc6d6, 0x5c6f},
	{0xc6d7, 0x60c7},
	{0xc6d8, 0x6566},
	{0xc6d9, 0x6c8c},
	{0xc6da, 0x8c5a},
	{0xc6db, 0x9041},
	{0xc6dc, 0x9813},
	{0xc6dd, 0x5451},
	{0xc6de, 0x66c7},
	{0xc6df, 0x920d},
	{0xc6e0, 0x5948},
	{0xc6e1, 0x90a3},
	{0xc6e2, 0x5185},
	{0xc6e3, 0x4e4d},
	{0xc6e4, 0x51ea},
	{0xc6e5, 0x8599},
	{0xc6e6, 0x8b0e},
	{0xc6e7, 0x7058},
	{0xc6e8, 0x637a},
	{0xc6e9, 0x934b},
	{0xc6ea, 0x6962},
	{0xc6eb, 0x99b4},
	{0xc6ec, 0x7e04},
	{0xc6ed, 0x7577},
	{0xc6ee, 0x5357},
	{0xc6ef, 0x6960},
	{0xc6f0, 0x8edf},
	{0xc6f1, 0x96e3},
	{0xc6f2, 0x6c5d},
	{0xc6f3, 0x4e8c},
	{0xc6f4, 0x5c3c},
	{0xc6f5, 0x5f10},
	{0xc6f6, 0x8fe9},
	{0xc6f7, 0x5302},
	{0xc6f8, 0x8cd1},
	{0xc6f9, 0x8089},
	{0xc6fa, 0x8679},
	{0xc6fb, 0x5eff},
	{0xc6fc, 0x65e5},
	{0xc6fd, 0x4e73},
	{0xc6fe, 0x5165},
	{0xc7a1, 0x5982},
	{0xc7a2, 0x5c3f},
	{0xc7a3, 0x97ee},
	{0xc7a4, 0x4efb},
	{0xc7a5, 0x598a},
	{0xc7a6, 0x5fcd},
	{0xc7a7, 0x8a8d},
	{0xc7a8, 0x6fe1},
	{0xc7a9, 0x79b0},
	{0xc7aa, 0x7962},
	{0xc7ab, 0x5be7},
	{0xc7ac, 0x8471},
	{0xc7ad, 0x732b},
	{0xc7ae, 0x71b1},
	{0xc7af, 0x5e74},
	{0xc7b0, 0x5ff5},
	{0xc7b1, 0x637b},
	{0xc7b2, 0x649a},
	{0xc7b3, 0x71c3},
	{0xc7b4, 0x7c98},
	{0xc7b5, 0x4e43},
	{0xc7b6, 0x5efc},
	{0xc7b7, 0x4e4b},
	{0xc7b8, 0x57dc},
	{0xc7b9, 0x56a2},
	{0xc7ba, 0x60a9},
	{0xc7bb, 0x6fc3},
	{0xc7bc, 0x7d0d},
	{0xc7bd, 0x80fd},
	{0xc7be, 0x8133},
	{0xc7bf, 0x81bf},
	{0xc7c0, 0x8fb2},
	{0xc7c1, 0x8997},
	{0xc7c2, 0x86a4},
	{0xc7c3, 0x5df4},
	{0xc7c4, 0x628a},
	{0xc7c5, 0x64ad},
	{0xc7c6, 0x8987},
	{0xc7c7, 0x6777},
	{0xc7c8, 0x6ce2},
	{0xc7c9, 0x6d3e},
	{0xc7ca, 0x7436},
	{0xc7cb, 0x7834},
	{0xc7cc, 0x5a46},
	{0xc7cd, 0x7f75},
	{0xc7ce, 0x82ad},
	{0xc7cf, 0x99ac},
	{0xc7d0, 0x4ff3},
	{0xc7d1, 0x5ec3},
	{0xc7d2, 0x62dd},
	{0xc7d3, 0x6392},
	{0xc7d4, 0x6557},
	{0xc7d5, 0x676f},
	{0xc7d6, 0x76c3},
	{0xc7d7, 0x724c},
	{0xc7d8, 0x80cc},
	{0xc7d9, 0x80ba},
	{0xc7da, 0x8f29},
	{0xc7db, 0x914d},
	{0xc7dc, 0x500d},
	{0xc7dd, 0x57f9},
	{0xc7de, 0x5a92},
	{0xc7df, 0x6885},
	{0xc7e0, 0x6973},
	{0xc7e1, 0x7164},
	{0xc7e2, 0x72fd},
	{0xc7e3, 0x8cb7},
	{0xc7e4, 0x58f2},
	{0xc7e5, 0x8ce0},
	{0xc7e6, 0x966a},
	{0xc7e7, 0x9019},
	{0xc7e8, 0x877f},
	{0xc7e9, 0x79e4},
	{0xc7ea, 0x77e7},
	{0xc7eb, 0x8429},
	{0xc7ec, 0x4f2f},
	{0xc7ed, 0x5265},
	{0xc7ee, 0x535a},
	{0xc7ef, 0x62cd},
	{0xc7f0, 0x67cf},
	{0xc7f1, 0x6cca},
	{0xc7f2, 0x767d},
	{0xc7f3, 0x7b94},
	{0xc7f4, 0x7c95},
	{0xc7f5, 0x8236},
	{0xc7f6, 0x8584},
	{0xc7f7, 0x8feb},
	{0xc7f8, 0x66dd},
	{0xc7f9, 0x6f20},
	{0xc7fa, 0x7206},
	{0xc7fb, 0x7e1b},
	{0xc7fc, 0x83ab},
	{0xc7fd, 0x99c1},
	{0xc7fe, 0x9ea6},
	{0xc8a1, 0x51fd},
	{0xc8a2, 0x7bb1},
	{0xc8a3, 0x7872},
	{0xc8a4, 0x7bb8},
	{0xc8a5, 0x8087},
	{0xc8a6, 0x7b48},
	{0xc8a7, 0x6ae8},
	{0xc8a8, 0x5e61},
	{0xc8a9, 0x808c},
	{0xc8aa, 0x7551},
	{0xc8ab, 0x7560},
	{0xc8ac, 0x516b},
	{0xc8ad, 0x9262},
	{0xc8ae, 0x6e8c},
	{0xc8af, 0x767a},
	{0xc8b0, 0x9197},
	{0xc8b1, 0x9aea},
	{0xc8b2, 0x4f10},
	{0xc8b3, 0x7f70},
	{0xc8b4, 0x629c},
	{0xc8b5, 0x7b4f},
	{0xc8b6, 0x95a5},
	{0xc8b7, 0x9ce9},
	{0xc8b8, 0x567a},
	{0xc8b9, 0x5859},
	{0xc8ba, 0x86e4},
	{0xc8bb, 0x96bc},
	{0xc8bc, 0x4f34},
	{0xc8bd, 0x5224},
	{0xc8be, 0x534a},
	{0xc8bf, 0x53cd},
	{0xc8c0, 0x53db},
	{0xc8c1, 0x5e06},
	{0xc8c2, 0x642c},
	{0xc8c3, 0x6591},
	{0xc8c4, 0x677f},
	{0xc8c5, 0x6c3e},
	{0xc8c6, 0x6c4e},
	{0xc8c7, 0x7248},
	{0xc8c8, 0x72af},
	{0xc8c9, 0x73ed},
	{0xc8ca, 0x7554},
	{0xc8cb, 0x7e41},
	{0xc8cc, 0x822c},
	{0xc8cd, 0x85e9},
	{0xc8ce, 0x8ca9},
	{0xc8cf, 0x7bc4},
	{0xc8d0, 0x91c6},
	{0xc8d1, 0x7169},
	{0xc8d2, 0x9812},
	{0xc8d3, 0x98ef},
	{0xc8d4, 0x633d},
	{0xc8d5, 0x6669},
	{0xc8d6, 0x756a},
	{0xc8d7, 0x76e4},
	{0xc8d8, 0x78d0},
	{0xc8d9, 0x8543},
	{0xc8da, 0x86ee},
	{0xc8db, 0x532a},
	{0xc8dc, 0x5351},
	{0xc8dd, 0x5426},
	{0xc8de, 0x5983},
	{0xc8df, 0x5e87},
	{0xc8e0, 0x5f7c},
	{0xc8e1, 0x60b2},
	{0xc8e2, 0x6249},
	{0xc8e3, 0x6279},
	{0xc8e4, 0x62ab},
	{0xc8e5, 0x6590},
	{0xc8e6, 0x6bd4},
	{0xc8e7, 0x6ccc},
	{0xc8e8, 0x75b2},
	{0xc8e9, 0x76ae},
	{0xc8ea, 0x7891},
	{0xc8eb, 0x79d8},
	{0xc8ec, 0x7dcb},
	{0xc8ed, 0x7f77},
	{0xc8ee, 0x80a5},
	{0xc8ef, 0x88ab},
	{0xc8f0, 0x8ab9},
	{0xc8f1, 0x8cbb},
	{0xc8f2, 0x907f},
	{0xc8f3, 0x975e},
	{0xc8f4, 0x98db},
	{0xc8f5, 0x6a0b},
	{0xc8f6, 0x7c38},
	{0xc8f7, 0x5099},
	{0xc8f8, 0x5c3e},
	{0xc8f9, 0x5fae},
	{0xc8fa, 0x6787},
	{0xc8fb, 0x6bd8},
	{0xc8fc, 0x7435},
	{0xc8fd, 0x7709},
	{0xc8fe, 0x7f8e},
	{0xc9a1, 0x9f3b},
	{0xc9a2, 0x67ca},
	{0xc9a3, 0x7a17},
	{0xc9a4, 0x5339},
	{0xc9a5, 0x758b},
	{0xc9a6, 0x9aed},
	{0xc9a7, 0x5f66},
	{0xc9a8, 0x819d},
	{0xc9a9, 0x83f1},
	{0xc9aa, 0x8098},
	{0xc9ab, 0x5f3c},
	{0xc9ac, 0x5fc5},
	{0xc9ad, 0x7562},
	{0xc9ae, 0x7b46},
	{0xc9af, 0x903c},
	{0xc9b0, 0x6867},
	{0xc9b1, 0x59eb},
	{0xc9b2, 0x5a9b},
	{0xc9b3, 0x7d10},
	{0xc9b4, 0x767e},
	{0xc9b5, 0x8b2c},
	{0xc9b6, 0x4ff5},
	{0xc9b7, 0x5f6a},
	{0xc9b8, 0x6a19},
	{0xc9b9, 0x6c37},
	{0xc9ba, 0x6f02},
	{0xc9bb, 0x74e2},
	{0xc9bc, 0x7968},
	{0xc9bd, 0x8868},
	{0xc9be, 0x8a55},
	{0xc9bf, 0x8c79},
	{0xc9c0, 0x5edf},
	{0xc9c1, 0x63cf},
	{0xc9c2, 0x75c5},
	{0xc9c3, 0x79d2},
	{0xc9c4, 0x82d7},
	{0xc9c5, 0x9328},
	{0xc9c6, 0x92f2},
	{0xc9c7, 0x849c},
	{0xc9c8, 0x86ed},
	{0xc9c9, 0x9c2d},
	{0xc9ca, 0x54c1},
	{0xc9cb, 0x5f6c},
	{0xc9cc, 0x658c},
	{0xc9cd, 0x6d5c},
	{0xc9ce, 0x7015},
	{0xc9cf, 0x8ca7},
	{0xc9d0, 0x8cd3},
	{0xc9d1, 0x983b},
	{0xc9d2, 0x654f},
	{0xc9d3, 0x74f6},
	{0xc9d4, 0x4e0d},
	{0xc9d5, 0x4ed8},
	{0xc9d6, 0x57e0},
	{0xc9d7, 0x592b},
	{0xc9d8, 0x5a66},
	{0xc9d9, 0x5bcc},
	{0xc9da, 0x51a8},
	{0xc9db, 0x5e03},
	{0xc9dc, 0x5e9c},
	{0xc9dd, 0x6016},
	{0xc9de, 0x6276},
	{0xc9df, 0x6577},
	{0xc9e0, 0x65a7},
	{0xc9e1, 0x666e},
	{0xc9e2, 0x6d6e},
	{0xc9e3, 0x7236},
	{0xc9e4, 0x7b26},
	{0xc9e5, 0x8150},
	{0xc9e6, 0x819a},
	{0xc9e7, 0x8299},
	{0xc9e8, 0x8b5c},
	{0xc9e9, 0x8ca0},
	{0xc9ea, 0x8ce6},
	{0xc9eb, 0x8d74},
	{0xc9ec, 0x961c},
	{0xc9ed, 0x9644},
	{0xc9ee, 0x4fae},
	{0xc9ef, 0x64ab},
	{0xc9f0, 0x6b66},
	{0xc9f1, 0x821e},
	{0xc9f2, 0x8461},
	{0xc9f3, 0x856a},
	{0xc9f4, 0x90e8},
	{0xc9f5, 0x5c01},
	{0xc9f6, 0x6953},
	{0xc9f7, 0x98a8},
	{0xc9f8, 0x847a},
	{0xc9f9, 0x8557},
	{0xc9fa, 0x4f0f},
	{0xc9fb, 0x526f},
	{0xc9fc, 0x5fa9},
	{0xc9fd, 0x5e45},
	{0xc9fe, 0x670d},
	{0xcaa1, 0x798f},
	{0xcaa2, 0x8179},
	{0xcaa3, 0x8907},
	{0xcaa4, 0x8986},
	{0xcaa5, 0x6df5},
	{0xcaa6, 0x5f17},
	{0xcaa7, 0x6255},
	{0xcaa8, 0x6cb8},
	{0xcaa9, 0x4ecf},
	{0xcaaa, 0x7269},
	{0xcaab, 0x9b92},
	{0xcaac, 0x5206},
	{0xcaad, 0x543b},
	{0xcaae, 0x5674},
	{0xcaaf, 0x58b3},
	{0xcab0, 0x61a4},
	{0xcab1, 0x626e},
	{0xcab2, 0x711a},
	{0xcab3, 0x596e},
	{0xcab4, 0x7c89},
	{0xcab5, 0x7cde},
	{0xcab6, 0x7d1b},
	{0xcab7, 0x96f0},
	{0xcab8, 0x6587},
	{0xcab9, 0x805e},
	{0xcaba, 0x4e19},
	{0xcabb, 0x4f75},
	{0xcabc, 0x5175},
	{0xcabd, 0x5840},
	{0xcabe, 0x5e63},
	{0xcabf, 0x5e73},
	{0xcac0, 0x5f0a},
	{0xcac1, 0x67c4},
	{0xcac2, 0x4e26},
	{0xcac3, 0x853d},
	{0xcac4, 0x9589},
	{0xcac5, 0x965b},
	{0xcac6, 0x7c73},
	{0xcac7, 0x9801},
	{0xcac8, 0x50fb},
	{0xcac9, 0x58c1},
	{0xcaca, 0x7656},
	{0xcacb, 0x78a7},
	{0xcacc, 0x5225},
	{0xcacd, 0x77a5},
	{0xcace, 0x8511},
	{0xcacf, 0x7b86},
	{0xcad0, 0x504f},
	{0xcad1, 0x5909},
	{0xcad2, 0x7247},
	{0xcad3, 0x7bc7},
	{0xcad4, 0x7de8},
	{0xcad5, 0x8fba},
	{0xcad6, 0x8fd4},
	{0xcad7, 0x904d},
	{0xcad8, 0x4fbf},
	{0xcad9, 0x52c9},
	{0xcada, 0x5a29},
	{0xcadb, 0x5f01},
	{0xcadc, 0x97ad},
	{0xcadd, 0x4fdd},
	{0xcade, 0x8217},
	{0xcadf, 0x92ea},
	{0xcae0, 0x5703},
	{0xcae1, 0x6355},
	{0xcae2, 0x6b69},
	{0xcae3, 0x752b},
	{0xcae4, 0x88dc},
	{0xcae5, 0x8f14},
	{0xcae6, 0x7a42},
	{0xcae7, 0x52df},
	{0xcae8, 0x5893},
	{0xcae9, 0x6155},
	{0xcaea, 0x620a},
	{0xcaeb, 0x66ae},
	{0xcaec, 0x6bcd},
	{0xcaed, 0x7c3f},
	{0xcaee, 0x83e9},
	{0xcaef, 0x5023},
	{0xcaf0, 0x4ff8},
	{0xcaf1, 0x5305},
	{0xcaf2, 0x5446},
	{0xcaf3, 0x5831},
	{0xcaf4, 0x5949},
	{0xcaf5, 0x5b9d},
	{0xcaf6, 0x5cf0},
	{0xcaf7, 0x5cef},
	{0xcaf8, 0x5d29},
	{0xcaf9, 0x5e96},
	{0xcafa, 0x62b1},
	{0xcafb, 0x6367},
	{0xcafc, 0x653e},
	{0xcafd, 0x65b9},
	{0xcafe, 0x670b},
	{0xcba1, 0x6cd5},
	{0xcba2, 0x6ce1},
	{0xcba3, 0x70f9},
	{0xcba4, 0x7832},
	{0xcba5, 0x7e2b},
	{0xcba6, 0x80de},
	{0xcba7, 0x82b3},
	{0xcba8, 0x840c},
	{0xcba9, 0x84ec},
	{0xcbaa, 0x8702},
	{0xcbab, 0x8912},
	{0xcbac, 0x8a2a},
	{0xcbad, 0x8c4a},
	{0xcbae, 0x90a6},
	{0xcbaf, 0x92d2},
	{0xcbb0, 0x98fd},
	{0xcbb1, 0x9cf3},
	{0xcbb2, 0x9d6c},
	{0xcbb3, 0x4e4f},
	{0xcbb4, 0x4ea1},
	{0xcbb5, 0x508d},
	{0xcbb6, 0x5256},
	{0xcbb7, 0x574a},
	{0xcbb8, 0x59a8},
	{0xcbb9, 0x5e3d},
	{0xcbba, 0x5fd8},
	{0xcbbb, 0x5fd9},
	{0xcbbc, 0x623f},
	{0xcbbd, 0x66b4},
	{0xcbbe, 0x671b},
	{0xcbbf, 0x67d0},
	{0xcbc0, 0x68d2},
	{0xcbc1, 0x5192},
	{0xcbc2, 0x7d21},
	{0xcbc3, 0x80aa},
	{0xcbc4, 0x81a8},
	{0xcbc5, 0x8b00},
	{0xcbc6, 0x8c8c},
	{0xcbc7, 0x8cbf},
	{0xcbc8, 0x927e},
	{0xcbc9, 0x9632},
	{0xcbca, 0x5420},
	{0xcbcb, 0x982c},
	{0xcbcc, 0x5317},
	{0xcbcd, 0x50d5},
	{0xcbce, 0x535c},
	{0xcbcf, 0x58a8},
	{0xcbd0, 0x64b2},
	{0xcbd1, 0x6734},
	{0xcbd2, 0x7267},
	{0xcbd3, 0x7766},
	{0xcbd4, 0x7a46},
	{0xcbd5, 0x91e6},
	{0xcbd6, 0x52c3},
	{0xcbd7, 0x6ca1},
	{0xcbd8, 0x6b86},
	{0xcbd9, 0x5800},
	{0xcbda, 0x5e4c},
	{0xcbdb, 0x5954},
	{0xcbdc, 0x672c},
	{0xcbdd, 0x7ffb},
	{0xcbde, 0x51e1},
	{0xcbdf, 0x76c6},
	{0xcbe0, 0x6469},
	{0xcbe1, 0x78e8},
	{0xcbe2, 0x9b54},
	{0xcbe3, 0x9ebb},
	{0xcbe4, 0x57cb},
	{0xcbe5, 0x59b9},
	{0xcbe6, 0x6627},
	{0xcbe7, 0x679a},
	{0xcbe8, 0x6bce},
	{0xcbe9, 0x54e9},
	{0xcbea, 0x69d9},
	{0xcbeb, 0x5e55},
	{0xcbec, 0x819c},
	{0xcbed, 0x6795},
	{0xcbee, 0x9baa},
	{0xcbef, 0x67fe},
	{0xcbf0, 0x9c52},
	{0xcbf1, 0x685d},
	{0xcbf2, 0x4ea6},
	{0xcbf3, 0x4fe3},
	{0xcbf4, 0x53c8},
	{0xcbf5, 0x62b9},
	{0xcbf6, 0x672b},
	{0xcbf7, 0x6cab},
	{0xcbf8, 0x8fc4},
	{0xcbf9, 0x4fad},
	{0xcbfa, 0x7e6d},
	{0xcbfb, 0x9ebf},
	{0xcbfc, 0x4e07},
	{0xcbfd, 0x6162},
	{0xcbfe, 0x6e80},
	{0xcca1, 0x6f2b},
	{0xcca2, 0x8513},
	{0xcca3, 0x5473},
	{0xcca4, 0x672a},
	{0xcca5, 0x9b45},
	{0xcca6, 0x5df3},
	{0xcca7, 0x7b95},
	{0xcca8, 0x5cac},
	{0xcca9, 0x5bc6},
	{0xccaa, 0x871c},
	{0xccab, 0x6e4a},
	{0xccac, 0x84d1},
	{0xccad, 0x7a14},
	{0xccae, 0x8108},
	{0xccaf, 0x5999},
	{0xccb0, 0x7c8d},
	{0xccb1, 0x6c11},
	{0xccb2, 0x7720},
	{0xccb3, 0x52d9},
	{0xccb4, 0x5922},
	{0xccb5, 0x7121},
	{0xccb6, 0x725f},
	{0xccb7, 0x77db},
	{0xccb8, 0x9727},
	{0xccb9, 0x9d61},
	{0xccba, 0x690b},
	{0xccbb, 0x5a7f},
	{0xccbc, 0x5a18},
	{0xccbd, 0x51a5},
	{0xccbe, 0x540d},
	{0xccbf, 0x547d},
	{0xccc0, 0x660e},
	{0xccc1, 0x76df},
	{0xccc2, 0x8ff7},
	{0xccc3, 0x9298},
	{0xccc4, 0x9cf4},
	{0xccc5, 0x59ea},
	{0xccc6, 0x725d},
	{0xccc7, 0x6ec5},
	{0xccc8, 0x514d},
	{0xccc9, 0x68c9},
	{0xccca, 0x7dbf},
	{0xcccb, 0x7dec},
	{0xcccc, 0x9762},
	{0xcccd, 0x9eba},
	{0xccce, 0x6478},
	{0xcccf, 0x6a21},
	{0xccd0, 0x8302},
	{0xccd1, 0x5984},
	{0xccd2, 0x5b5f},
	{0xccd3, 0x6bdb},
	{0xccd4, 0x731b},
	{0xccd5, 0x76f2},
	{0xccd6, 0x7db2},
	{0xccd7, 0x8017},
	{0xccd8, 0x8499},
	{0xccd9, 0x5132},
	{0xccda, 0x6728},
	{0xccdb, 0x9ed9},
	{0xccdc, 0x76ee},
	{0xccdd, 0x6762},
	{0xccde, 0x52ff},
	{0xccdf, 0x9905},
	{0xcce0, 0x5c24},
	{0xcce1, 0x623b},
	{0xcce2, 0x7c7e},
	{0xcce3, 0x8cb0},
	{0xcce4, 0x554f},
	{0xcce5, 0x60b6},
	{0xcce6, 0x7d0b},
	{0xcce7, 0x9580},
	{0xcce8, 0x5301},
	{0xcce9, 0x4e5f},
	{0xccea, 0x51b6},
	{0xcceb, 0x591c},
	{0xccec, 0x723a},
	{0xcced, 0x8036},
	{0xccee, 0x91ce},
	{0xccef, 0x5f25},
	{0xccf0, 0x77e2},
	{0xccf1, 0x5384},
	{0xccf2, 0x5f79},
	{0xccf3, 0x7d04},
	{0xccf4, 0x85ac},
	{0xccf5, 0x8a33},
	{0xccf6, 0x8e8d},
	{0xccf7, 0x9756},
	{0xccf8, 0x67f3},
	{0xccf9, 0x85ae},
	{0xccfa, 0x9453},
	{0xccfb, 0x6109},
	{0xccfc, 0x6108},
	{0xccfd, 0x6cb9},
	{0xccfe, 0x7652},
	{0xcda1, 0x8aed},
	{0xcda2, 0x8f38},
	{0xcda3, 0x552f},
	{0xcda4, 0x4f51},
	{0xcda5, 0x512a},
	{0xcda6, 0x52c7},
	{0xcda7, 0x53cb},
	{0xcda8, 0x5ba5},
	{0xcda9, 0x5e7d},
	{0xcdaa, 0x60a0},
	{0xcdab, 0x6182},
	{0xcdac, 0x63d6},
	{0xcdad, 0x6709},
	{0xcdae, 0x67da},
	{0xcdaf, 0x6e67},
	{0xcdb0, 0x6d8c},
	{0xcdb1, 0x7336},
	{0xcdb2, 0x7337},
	{0xcdb3, 0x7531},
	{0xcdb4, 0x7950},
	{0xcdb5, 0x88d5},
	{0xcdb6, 0x8a98},
	{0xcdb7, 0x904a},
	{0xcdb8, 0x9091},
	{0xcdb9, 0x90f5},
	{0xcdba, 0x96c4},
	{0xcdbb, 0x878d},
	{0xcdbc, 0x5915},
	{0xcdbd, 0x4e88},
	{0xcdbe, 0x4f59},
	{0xcdbf, 0x4e0e},
	{0xcdc0, 0x8a89},
	{0xcdc1, 0x8f3f},
	{0xcdc2, 0x9810},
	{0xcdc3, 0x50ad},
	{0xcdc4, 0x5e7c},
	{0xcdc5, 0x5996},
	{0xcdc6, 0x5bb9},
	{0xcdc7, 0x5eb8},
	{0xcdc8, 0x63da},
	{0xcdc9, 0x63fa},
	{0xcdca, 0x64c1},
	{0xcdcb, 0x66dc},
	{0xcdcc, 0x694a},
	{0xcdcd, 0x69d8},
	{0xcdce, 0x6d0b},
	{0xcdcf, 0x6eb6},
	{0xcdd0, 0x7194},
	{0xcdd1, 0x7528},
	{0xcdd2, 0x7aaf},
	{0xcdd3, 0x7f8a},
	{0xcdd4, 0x8000},
	{0xcdd5, 0x8449},
	{0xcdd6, 0x84c9},
	{0xcdd7, 0x8981},
	{0xcdd8, 0x8b21},
	{0xcdd9, 0x8e0a},
	{0xcdda, 0x9065},
	{0xcddb, 0x967d},
	{0xcddc, 0x990a},
	{0xcddd, 0x617e},
	{0xcdde, 0x6291},
	{0xcddf, 0x6b32},
	{0xcde0, 0x6c83},
	{0xcde1, 0x6d74},
	{0xcde2, 0x7fcc},
	{0xcde3, 0x7ffc},
	{0xcde4, 0x6dc0},
	{0xcde5, 0x7f85},
	{0xcde6, 0x87ba},
	{0xcde7, 0x88f8},
	{0xcde8, 0x6765},
	{0xcde9, 0x83b1},
	{0xcdea, 0x983c},
	{0xcdeb, 0x96f7},
	{0xcdec, 0x6d1b},
	{0xcded, 0x7d61},
	{0xcdee, 0x843d},
	{0xcdef, 0x916a},
	{0xcdf0, 0x4e71},
	{0xcdf1, 0x5375},
	{0xcdf2, 0x5d50},
	{0xcdf3, 0x6b04},
	{0xcdf4, 0x6feb},
	{0xcdf5, 0x85cd},
	{0xcdf6, 0x862d},
	{0xcdf7, 0x89a7},
	{0xcdf8, 0x5229},
	{0xcdf9, 0x540f},
	{0xcdfa, 0x5c65},
	{0xcdfb, 0x674e},
	{0xcdfc, 0x68a8},
	{0xcdfd, 0x7406},
	{0xcdfe, 0x7483},
	{0xcea1, 0x75e2},
	{0xcea2, 0x88cf},
	{0xcea3, 0x88e1},
	{0xcea4, 0x91cc},
	{0xcea5, 0x96e2},
	{0xcea6, 0x9678},
	{0xcea7, 0x5f8b},
	{0xcea8, 0x7387},
	{0xcea9, 0x7acb},
	{0xceaa, 0x844e},
	{0xceab, 0x63a0},
	{0xceac, 0x7565},
	{0xcead, 0x5289},
	{0xceae, 0x6d41},
	{0xceaf, 0x6e9c},
	{0xceb0, 0x7409},
	{0xceb1, 0x7559},
	{0xceb2, 0x786b},
	{0xceb3, 0x7c92},
	{0xceb4, 0x9686},
	{0xceb5, 0x7adc},
	{0xceb6, 0x9f8d},
	{0xceb7, 0x4fb6},
	{0xceb8, 0x616e},
	{0xceb9, 0x65c5},
	{0xceba, 0x865c},
	{0xcebb, 0x4e86},
	{0xcebc, 0x4eae},
	{0xcebd, 0x50da},
	{0xcebe, 0x4e21},
	{0xcebf, 0x51cc},
	{0xcec0, 0x5bee},
	{0xcec1, 0x6599},
	{0xcec2, 0x6881},
	{0xcec3, 0x6dbc},
	{0xcec4, 0x731f},
	{0xcec5, 0x7642},
	{0xcec6, 0x77ad},
	{0xcec7, 0x7a1c},
	{0xcec8, 0x7ce7},
	{0xcec9, 0x826f},
	{0xceca, 0x8ad2},
	{0xcecb, 0x907c},
	{0xcecc, 0x91cf},
	{0xcecd, 0x9675},
	{0xcece, 0x9818},
	{0xcecf, 0x529b},
	{0xced0, 0x7dd1},
	{0xced1, 0x502b},
	{0xced2, 0x5398},
	{0xced3, 0x6797},
	{0xced4, 0x6dcb},
	{0xced5, 0x71d0},
	{0xced6, 0x7433},
	{0xced7, 0x81e8},
	{0xced8, 0x8f2a},
	{0xced9, 0x96a3},
	{0xceda, 0x9c57},
	{0xcedb, 0x9e9f},
	{0xcedc, 0x7460},
	{0xcedd, 0x5841},
	{0xcede, 0x6d99},
	{0xcedf, 0x7d2f},
	{0xcee0, 0x985e},
	{0xcee1, 0x4ee4},
	{0xcee2, 0x4f36},
	{0xcee3, 0x4f8b},
	{0xcee4, 0x51b7},
	{0xcee5, 0x52b1},
	{0xcee6, 0x5dba},
	{0xcee7, 0x601c},
	{0xcee8, 0x73b2},
	{0xcee9, 0x793c},
	{0xceea, 0x82d3},
	{0xceeb, 0x9234},
	{0xceec, 0x96b7},
	{0xceed, 0x96f6},
	{0xceee, 0x970a},
	{0xceef, 0x9e97},
	{0xcef0, 0x9f62},
	{0xcef1, 0x66a6},
	{0xcef2, 0x6b74},
	{0xcef3, 0x5217},
	{0xcef4, 0x52a3},
	{0xcef5, 0x70c8},
	{0xcef6, 0x88c2},
	{0xcef7, 0x5ec9},
	{0xcef8, 0x604b},
	{0xcef9, 0x6190},
	{0xcefa, 0x6f23},
	{0xcefb, 0x7149},
	{0xcefc, 0x7c3e},
	{0xcefd, 0x7df4},
	{0xcefe, 0x806f},
	{0xcfa1, 0x84ee},
	{0xcfa2, 0x9023},
	{0xcfa3, 0x932c},
	{0xcfa4, 0x5442},
	{0xcfa5, 0x9b6f},
	{0xcfa6, 0x6ad3},
	{0xcfa7, 0x7089},
	{0xcfa8, 0x8cc2},
	{0xcfa9, 0x8def},
	{0xcfaa, 0x9732},
	{0xcfab, 0x52b4},
	{0xcfac, 0x5a41},
	{0xcfad, 0x5eca},
	{0xcfae, 0x5f04},
	{0xcfaf, 0x6717},
	{0xcfb0, 0x697c},
	{0xcfb1, 0x6994},
	{0xcfb2, 0x6d6a},
	{0xcfb3, 0x6f0f},
	{0xcfb4, 0x7262},
	{0xcfb5, 0x72fc},
	{0xcfb6, 0x7bed},
	{0xcfb7, 0x8001},
	{0xcfb8, 0x807e},
	{0xcfb9, 0x874b},
	{0xcfba, 0x90ce},
	{0xcfbb, 0x516d},
	{0xcfbc, 0x9e93},
	{0xcfbd, 0x7984},
	{0xcfbe, 0x808b},
	{0xcfbf, 0x9332},
	{0xcfc0, 0x8ad6},
	{0xcfc1, 0x502d},
	{0xcfc2, 0x548c},
	{0xcfc3, 0x8a71},
	{0xcfc4, 0x6b6a},
	{0xcfc5, 0x8cc4},
	{0xcfc6, 0x8107},
	{0xcfc7, 0x60d1},
	{0xcfc8, 0x67a0},
	{0xcfc9, 0x9df2},
	{0xcfca, 0x4e99},
	{0xcfcb, 0x4e98},
	{0xcfcc, 0x9c10},
	{0xcfcd, 0x8a6b},
	{0xcfce, 0x85c1},
	{0xcfcf, 0x8568},
	{0xcfd0, 0x6900},
	{0xcfd1, 0x6e7e},
	{0xcfd2, 0x7897},
	{0xcfd3, 0x8155},
	{0xd0a1, 0x5f0c},
	{0xd0a2, 0x4e10},
	{0xd0a3, 0x4e15},
	{0xd0a4, 0x4e2a},
	{0xd0a5, 0x4e31},
	{0xd0a6, 0x4e36},
	{0xd0a7, 0x4e3c},
	{0xd0a8, 0x4e3f},
	{0xd0a9, 0x4e42},
	{0xd0aa, 0x4e56},
	{0xd0ab, 0x4e58},
	{0xd0ac, 0x4e82},
	{0xd0ad, 0x4e85},
	{0xd0ae, 0x8c6b},
	{0xd0af, 0x4e8a},
	{0xd0b0, 0x8212},
	{0xd0b1, 0x5f0d},
	{0xd0b2, 0x4e8e},
	{0xd0b3, 0x4e9e},
	{0xd0b4, 0x4e9f},
	{0xd0b5, 0x4ea0},
	{0xd0b6, 0x4ea2},
	{0xd0b7, 0x4eb0},
	{0xd0b8, 0x4eb3},
	{0xd0b9, 0x4eb6},
	{0xd0ba, 0x4ece},
	{0xd0bb, 0x4ecd},
	{0xd0bc, 0x4ec4},
	{0xd0bd, 0x4ec6},
	{0xd0be, 0x4ec2},
	{0xd0bf, 0x4ed7},
	{0xd0c0, 0x4ede},
	{0xd0c1, 0x4eed},
	{0xd0c2, 0x4edf},
	{0xd0c3, 0x4ef7},
	{0xd0c4, 0x4f09},
	{0xd0c5, 0x4f5a},
	{0xd0c6, 0x4f30},
	{0xd0c7, 0x4f5b},
	{0xd0c8, 0x4f5d},
	{0xd0c9, 0x4f57},
	{0xd0ca, 0x4f47},
	{0xd0cb, 0x4f76},
	{0xd0cc, 0x4f88},
	{0xd0cd, 0x4f8f},
	{0xd0ce, 0x4f98},
	{0xd0cf, 0x4f7b},
	{0xd0d0, 0x4f69},
	{0xd0d1, 0x4f70},
	{0xd0d2, 0x4f91},
	{0xd0d3, 0x4f6f},
	{0xd0d4, 0x4f86},
	{0xd0d5, 0x4f96},
	{0xd0d6, 0x5118},
	{0xd0d7, 0x4fd4},
	{0xd0d8, 0x4fdf},
	{0xd0d9, 0x4fce},
	{0xd0da, 0x4fd8},
	{0xd0db, 0x4fdb},
	{0xd0dc, 0x4fd1},
	{0xd0dd, 0x4fda},
	{0xd0de, 0x4fd0},
	{0xd0df, 0x4fe4},
	{0xd0e0, 0x4fe5},
	{0xd0e1, 0x501a},
	{0xd0e2, 0x5028},
	{0xd0e3, 0x5014},
	{0xd0e4, 0x502a},
	{0xd0e5, 0x5025},
	{0xd0e6, 0x5005},
	{0xd0e7, 0x4f1c},
	{0xd0e8, 0x4ff6},
	{0xd0e9, 0x5021},
	{0xd0ea, 0x5029},
	{0xd0eb, 0x502c},
	{0xd0ec, 0x4ffe},
	{0xd0ed, 0x4fef},
	{0xd0ee, 0x5011},
	{0xd0ef, 0x5006},
	{0xd0f0, 0x5043},
	{0xd0f1, 0x5047},
	{0xd0f2, 0x6703},
	{0xd0f3, 0x5055},
	{0xd0f4, 0x5050},
	{0xd0f5, 0x5048},
	{0xd0f6, 0x505a},
	{0xd0f7, 0x5056},
	{0xd0f8, 0x506c},
	{0xd0f9, 0x5078},
	{0xd0fa, 0x5080},
	{0xd0fb, 0x509a},
	{0xd0fc, 0x5085},
	{0xd0fd, 0x50b4},
	{0xd0fe, 0x50b2},
	{0xd1a1, 0x50c9},
	{0xd1a2, 0x50ca},
	{0xd1a3, 0x50b3},
	{0xd1a4, 0x50c2},
	{0xd1a5, 0x50d6},
	{0xd1a6, 0x50de},
	{0xd1a7, 0x50e5},
	{0xd1a8, 0x50ed},
	{0xd1a9, 0x50e3},
	{0xd1aa, 0x50ee},
	{0xd1ab, 0x50f9},
	{0xd1ac, 0x50f5},
	{0xd1ad, 0x5109},
	{0xd1ae, 0x5101},
	{0xd1af, 0x5102},
	{0xd1b0, 0x5116},
	{0xd1b1, 0x5115},
	{0xd1b2, 0x5114},
	{0xd1b3, 0x511a},
	{0xd1b4, 0x5121},
	{0xd1b5, 0x513a},
	{0xd1b6, 0x5137},
	{0xd1b7, 0x513c},
	{0xd1b8, 0x513b},
	{0xd1b9, 0x513f},
	{0xd1ba, 0x5140},
	{0xd1bb, 0x5152},
	{0xd1bc, 0x514c},
	{0xd1bd, 0x5154},
	{0xd1be, 0x5162},
	{0xd1bf, 0x7af8},
	{0xd1c0, 0x5169},
	{0xd1c1, 0x516a},
	{0xd1c2, 0x516e},
	{0xd1c3, 0x5180},
	{0xd1c4, 0x5182},
	{0xd1c5, 0x56d8},
	{0xd1c6, 0x518c},
	{0xd1c7, 0x5189},
	{0xd1c8, 0x518f},
	{0xd1c9, 0x5191},
	{0xd1ca, 0x5193},
	{0xd1cb, 0x5195},
	{0xd1cc, 0x5196},
	{0xd1cd, 0x51a4},
	{0xd1ce, 0x51a6},
	{0xd1cf, 0x51a2},
	{0xd1d0, 0x51a9},
	{0xd1d1, 0x51aa},
	{0xd1d2, 0x51ab},
	{0xd1d3, 0x51b3},
	{0xd1d4, 0x51b1},
	{0xd1d5, 0x51b2},
	{0xd1d6, 0x51b0},
	{0xd1d7, 0x51b5},
	{0xd1d8, 0x51bd},
	{0xd1d9, 0x51c5},
	{0xd1da, 0x51c9},
	{0xd1db, 0x51db},
	{0xd1dc, 0x51e0},
	{0xd1dd, 0x8655},
	{0xd1de, 0x51e9},
	{0xd1df, 0x51ed},
	{0xd1e0, 0x51f0},
	{0xd1e1, 0x51f5},
	{0xd1e2, 0x51fe},
	{0xd1e3, 0x5204},
	{0xd1e4, 0x520b},
	{0xd1e5, 0x5214},
	{0xd1e6, 0x520e},
	{0xd1e7, 0x5227},
	{0xd1e8, 0x522a},
	{0xd1e9, 0x522e},
	{0xd1ea, 0x5233},
	{0xd1eb, 0x5239},
	{0xd1ec, 0x524f},
	{0xd1ed, 0x5244},
	{0xd1ee, 0x524b},
	{0xd1ef, 0x524c},
	{0xd1f0, 0x525e},
	{0xd1f1, 0x5254},
	{0xd1f2, 0x526a},
	{0xd1f3, 0x5274},
	{0xd1f4, 0x5269},
	{0xd1f5, 0x5273},
	{0xd1f6, 0x527f},
	{0xd1f7, 0x527d},
	{0xd1f8, 0x528d},
	{0xd1f9, 0x5294},
	{0xd1fa, 0x5292},
	{0xd1fb, 0x5271},
	{0xd1fc, 0x5288},
	{0xd1fd, 0x5291},
	{0xd1fe, 0x8fa8},
	{0xd2a1, 0x8fa7},
	{0xd2a2, 0x52ac},
	{0xd2a3, 0x52ad},
	{0xd2a4, 0x52bc},
	{0xd2a5, 0x52b5},
	{0xd2a6, 0x52c1},
	{0xd2a7, 0x52cd},
	{0xd2a8, 0x52d7},
	{0xd2a9, 0x52de},
	{0xd2aa, 0x52e3},
	{0xd2ab, 0x52e6},
	{0xd2ac, 0x98ed},
	{0xd2ad, 0x52e0},
	{0xd2ae, 0x52f3},
	{0xd2af, 0x52f5},
	{0xd2b0, 0x52f8},
	{0xd2b1, 0x52f9},
	{0xd2b2, 0x5306},
	{0xd2b3, 0x5308},
	{0xd2b4, 0x7538},
	{0xd2b5, 0x530d},
	{0xd2b6, 0x5310},
	{0xd2b7, 0x530f},
	{0xd2b8, 0x5315},
	{0xd2b9, 0x531a},
	{0xd2ba, 0x5323},
	{0xd2bb, 0x532f},
	{0xd2bc, 0x5331},
	{0xd2bd, 0x5333},
	{0xd2be, 0x5338},
	{0xd2bf, 0x5340},
	{0xd2c0, 0x5346},
	{0xd2c1, 0x5345},
	{0xd2c2, 0x4e17},
	{0xd2c3, 0x5349},
	{0xd2c4, 0x534d},
	{0xd2c5, 0x51d6},
	{0xd2c6, 0x535e},
	{0xd2c7, 0x5369},
	{0xd2c8, 0x536e},
	{0xd2c9, 0x5918},
	{0xd2ca, 0x537b},
	{0xd2cb, 0x5377},
	{0xd2cc, 0x5382},
	{0xd2cd, 0x5396},
	{0xd2ce, 0x53a0},
	{0xd2cf, 0x53a6},
	{0xd2d0, 0x53a5},
	{0xd2d1, 0x53ae},
	{0xd2d2, 0x53b0},
	{0xd2d3, 0x53b6},
	{0xd2d4, 0x53c3},
	{0xd2d5, 0x7c12},
	{0xd2d6, 0x96d9},
	{0xd2d7, 0x53df},
	{0xd2d8, 0x66fc},
	{0xd2d9, 0x71ee},
	{0xd2da, 0x53ee},
	{0xd2db, 0x53e8},
	{0xd2dc, 0x53ed},
	{0xd2dd, 0x53fa},
	{0xd2de, 0x5401},
	{0xd2df, 0x543d},
	{0xd2e0, 0x5440},
	{0xd2e1, 0x542c},
	{0xd2e2, 0x542d},
	{0xd2e3, 0x543c},
	{0xd2e4, 0x542e},
	{0xd2e5, 0x5436},
	{0xd2e6, 0x5429},
	{0xd2e7, 0x541d},
	{0xd2e8, 0x544e},
	{0xd2e9, 0x548f},
	{0xd2ea, 0x5475},
	{0xd2eb, 0x548e},
	{0xd2ec, 0x545f},
	{0xd2ed, 0x5471},
	{0xd2ee, 0x5477},
	{0xd2ef, 0x5470},
	{0xd2f0, 0x5492},
	{0xd2f1, 0x547b},
	{0xd2f2, 0x5480},
	{0xd2f3, 0x5476},
	{0xd2f4, 0x5484},
	{0xd2f5, 0x5490},
	{0xd2f6, 0x5486},
	{0xd2f7, 0x54c7},
	{0xd2f8, 0x54a2},
	{0xd2f9, 0x54b8},
	{0xd2fa, 0x54a5},
	{0xd2fb, 0x54ac},
	{0xd2fc, 0x54c4},
	{0xd2fd, 0x54c8},
	{0xd2fe, 0x54a8},
	{0xd3a1, 0x54ab},
	{0xd3a2, 0x54c2},
	{0xd3a3, 0x54a4},
	{0xd3a4, 0x54be},
	{0xd3a5, 0x54bc},
	{0xd3a6, 0x54d8},
	{0xd3a7, 0x54e5},
	{0xd3a8, 0x54e6},
	{0xd3a9, 0x550f},
	{0xd3aa, 0x5514},
	{0xd3ab, 0x54fd},
	{0xd3ac, 0x54ee},
	{0xd3ad, 0x54ed},
	{0xd3ae, 0x54fa},
	{0xd3af, 0x54e2},
	{0xd3b0, 0x5539},
	{0xd3b1, 0x5540},
	{0xd3b2, 0x5563},
	{0xd3b3, 0x554c},
	{0xd3b4, 0x552e},
	{0xd3b5, 0x555c},
	{0xd3b6, 0x5545},
	{0xd3b7, 0x5556},
	{0xd3b8, 0x5557},
	{0xd3b9, 0x5538},
	{0xd3ba, 0x5533},
	{0xd3bb, 0x555d},
	{0xd3bc, 0x5599},
	{0xd3bd, 0x5580},
	{0xd3be, 0x54af},
	{0xd3bf, 0x558a},
	{0xd3c0, 0x559f},
	{0xd3c1, 0x557b},
	{0xd3c2, 0x557e},
	{0xd3c3, 0x5598},
	{0xd3c4, 0x559e},
	{0xd3c5, 0x55ae},
	{0xd3c6, 0x557c},
	{0xd3c7, 0x5583},
	{0xd3c8, 0x55a9},
	{0xd3c9, 0x5587},
	{0xd3ca, 0x55a8},
	{0xd3cb, 0x55da},
	{0xd3cc, 0x55c5},
	{0xd3cd, 0x55df},
	{0xd3ce, 0x55c4},
	{0xd3cf, 0x55dc},
	{0xd3d0, 0x55e4},
	{0xd3d1, 0x55d4},
	{0xd3d2, 0x5614},
	{0xd3d3, 0x55f7},
	{0xd3d4, 0x5616},
	{0xd3d5, 0x55fe},
	{0xd3d6, 0x55fd},
	{0xd3d7, 0x561b},
	{0xd3d8, 0x55f9},
	{0xd3d9, 0x564e},
	{0xd3da, 0x5650},
	{0xd3db, 0x71df},
	{0xd3dc, 0x5634},
	{0xd3dd, 0x5636},
	{0xd3de, 0x5632},
	{0xd3df, 0x5638},
	{0xd3e0, 0x566b},
	{0xd3e1, 0x5664},
	{0xd3e2, 0x562f},
	{0xd3e3, 0x566c},
	{0xd3e4, 0x566a},
	{0xd3e5, 0x5686},
	{0xd3e6, 0x5680},
	{0xd3e7, 0x568a},
	{0xd3e8, 0x56a0},
	{0xd3e9, 0x5694},
	{0xd3ea, 0x568f},
	{0xd3eb, 0x56a5},
	{0xd3ec, 0x56ae},
	{0xd3ed, 0x56b6},
	{0xd3ee, 0x56b4},
	{0xd3ef, 0x56c2},
	{0xd3f0, 0x56bc},
	{0xd3f1, 0x56c1},
	{0xd3f2, 0x56c3},
	{0xd3f3, 0x56c0},
	{0xd3f4, 0x56c8},
	{0xd3f5, 0x56ce},
	{0xd3f6, 0x56d1},
	{0xd3f7, 0x56d3},
	{0xd3f8, 0x56d7},
	{0xd3f9, 0x56ee},
	{0xd3fa, 0x56f9},
	{0xd3fb, 0x5700},
	{0xd3fc, 0x56ff},
	{0xd3fd, 0x5704},
	{0xd3fe, 0x5709},
	{0xd4a1, 0x5708},
	{0xd4a2, 0x570b},
	{0xd4a3, 0x570d},
	{0xd4a4, 0x5713},
	{0xd4a5, 0x5718},
	{0xd4a6, 0x5716},
	{0xd4a7, 0x55c7},
	{0xd4a8, 0x571c},
	{0xd4a9, 0x5726},
	{0xd4aa, 0x5737},
	{0xd4ab, 0x5738},
	{0xd4ac, 0x574e},
	{0xd4ad, 0x573b},
	{0xd4ae, 0x5740},
	{0xd4af, 0x574f},
	{0xd4b0, 0x5769},
	{0xd4b1, 0x57c0},
	{0xd4b2, 0x5788},
	{0xd4b3, 0x5761},
	{0xd4b4, 0x577f},
	{0xd4b5, 0x5789},
	{0xd4b6, 0x5793},
	{0xd4b7, 0x57a0},
	{0xd4b8, 0x57b3},
	{0xd4b9, 0x57a4},
	{0xd4ba, 0x57aa},
	{0xd4bb, 0x57b0},
	{0xd4bc, 0x57c3},
	{0xd4bd, 0x57c6},
	{0xd4be, 0x57d4},
	{0xd4bf, 0x57d2},
	{0xd4c0, 0x57d3},
	{0xd4c1, 0x580a},
	{0xd4c2, 0x57d6},
	{0xd4c3, 0x57e3},
	{0xd4c4, 0x580b},
	{0xd4c5, 0x5819},
	{0xd4c6, 0x581d},
	{0xd4c7, 0x5872},
	{0xd4c8, 0x5821},
	{0xd4c9, 0x5862},
	{0xd4ca, 0x584b},
	{0xd4cb, 0x5870},
	{0xd4cc, 0x6bc0},
	{0xd4cd, 0x5852},
	{0xd4ce, 0x583d},
	{0xd4cf, 0x5879},
	{0xd4d0, 0x5885},
	{0xd4d1, 0x58b9},
	{0xd4d2, 0x589f},
	{0xd4d3, 0x58ab},
	{0xd4d4, 0x58ba},
	{0xd4d5, 0x58de},
	{0xd4d6, 0x58bb},
	{0xd4d7, 0x58b8},
	{0xd4d8, 0x58ae},
	{0xd4d9, 0x58c5},
	{0xd4da, 0x58d3},
	{0xd4db, 0x58d1},
	{0xd4dc, 0x58d7},
	{0xd4dd, 0x58d9},
	{0xd4de, 0x58d8},
	{0xd4df, 0x58e5},
	{0xd4e0, 0x58dc},
	{0xd4e1, 0x58e4},
	{0xd4e2, 0x58df},
	{0xd4e3, 0x58ef},
	{0xd4e4, 0x58fa},
	{0xd4e5, 0x58f9},
	{0xd4e6, 0x58fb},
	{0xd4e7, 0x58fc},
	{0xd4e8, 0x58fd},
	{0xd4e9, 0x5902},
	{0xd4ea, 0x590a},
	{0xd4eb, 0x5910},
	{0xd4ec, 0x591b},
	{0xd4ed, 0x68a6},
	{0xd4ee, 0x5925},
	{0xd4ef, 0x592c},
	{0xd4f0, 0x592d},
	{0xd4f1, 0x5932},
	{0xd4f2, 0x5938},
	{0xd4f3, 0x593e},
	{0xd4f4, 0x7ad2},
	{0xd4f5, 0x5955},
	{0xd4f6, 0x5950},
	{0xd4f7, 0x594e},
	{0xd4f8, 0x595a},
	{0xd4f9, 0x5958},
	{0xd4fa, 0x5962},
	{0xd4fb, 0x5960},
	{0xd4fc, 0x5967},
	{0xd4fd, 0x596c},
	{0xd4fe, 0x5969},
	{0xd5a1, 0x5978},
	{0xd5a2, 0x5981},
	{0xd5a3, 0x599d},
	{0xd5a4, 0x4f5e},
	{0xd5a5, 0x4fab},
	{0xd5a6, 0x59a3},
	{0xd5a7, 0x59b2},
	{0xd5a8, 0x59c6},
	{0xd5a9, 0x59e8},
	{0xd5aa, 0x59dc},
	{0xd5ab, 0x598d},
	{0xd5ac, 0x59d9},
	{0xd5ad, 0x59da},
	{0xd5ae, 0x5a25},
	{0xd5af, 0x5a1f},
	{0xd5b0, 0x5a11},
	{0xd5b1, 0x5a1c},
	{0xd5b2, 0x5a09},
	{0xd5b3, 0x5a1a},
	{0xd5b4, 0x5a40},
	{0xd5b5, 0x5a6c},
	{0xd5b6, 0x5a49},
	{0xd5b7, 0x5a35},
	{0xd5b8, 0x5a36},
	{0xd5b9, 0x5a62},
	{0xd5ba, 0x5a6a},
	{0xd5bb, 0x5a9a},
	{0xd5bc, 0x5abc},
	{0xd5bd, 0x5abe},
	{0xd5be, 0x5acb},
	{0xd5bf, 0x5ac2},
	{0xd5c0, 0x5abd},
	{0xd5c1, 0x5ae3},
	{0xd5c2, 0x5ad7},
	{0xd5c3, 0x5ae6},
	{0xd5c4, 0x5ae9},
	{0xd5c5, 0x5ad6},
	{0xd5c6, 0x5afa},
	{0xd5c7, 0x5afb},
	{0xd5c8, 0x5b0c},
	{0xd5c9, 0x5b0b},
	{0xd5ca, 0x5b16},
	{0xd5cb, 0x5b32},
	{0xd5cc, 0x5ad0},
	{0xd5cd, 0x5b2a},
	{0xd5ce, 0x5b36},
	{0xd5cf, 0x5b3e},
	{0xd5d0, 0x5b43},
	{0xd5d1, 0x5b45},
	{0xd5d2, 0x5b40},
	{0xd5d3, 0x5b51},
	{0xd5d4, 0x5b55},
	{0xd5d5, 0x5b5a},
	{0xd5d6, 0x5b5b},
	{0xd5d7, 0x5b65},
	{0xd5d8, 0x5b69},
	{0xd5d9, 0x5b70},
	{0xd5da, 0x5b73},
	{0xd5db, 0x5b75},
	{0xd5dc, 0x5b78},
	{0xd5dd, 0x6588},
	{0xd5de, 0x5b7a},
	{0xd5df, 0x5b80},
	{0xd5e0, 0x5b83},
	{0xd5e1, 0x5ba6},
	{0xd5e2, 0x5bb8},
	{0xd5e3, 0x5bc3},
	{0xd5e4, 0x5bc7},
	{0xd5e5, 0x5bc9},
	{0xd5e6, 0x5bd4},
	{0xd5e7, 0x5bd0},
	{0xd5e8, 0x5be4},
	{0xd5e9, 0x5be6},
	{0xd5ea, 0x5be2},
	{0xd5eb, 0x5bde},
	{0xd5ec, 0x5be5},
	{0xd5ed, 0x5beb},
	{0xd5ee, 0x5bf0},
	{0xd5ef, 0x5bf6},
	{0xd5f0, 0x5bf3},
	{0xd5f1, 0x5c05},
	{0xd5f2, 0x5c07},
	{0xd5f3, 0x5c08},
	{0xd5f4, 0x5c0d},
	{0xd5f5, 0x5c13},
	{0xd5f6, 0x5c20},
	{0xd5f7, 0x5c22},
	{0xd5f8, 0x5c28},
	{0xd5f9, 0x5c38},
	{0xd5fa, 0x5c39},
	{0xd5fb, 0x5c41},
	{0xd5fc, 0x5c46},
	{0xd5fd, 0x5c4e},
	{0xd5fe, 0x5c53},
	{0xd6a1, 0x5c50},
	{0xd6a2, 0x5c4f},
	{0xd6a3, 0x5b71},
	{0xd6a4, 0x5c6c},
	{0xd6a5, 0x5c6e},
	{0xd6a6, 0x4e62},
	{0xd6a7, 0x5c76},
	{0xd6a8, 0x5c79},
	{0xd6a9, 0x5c8c},
	{0xd6aa, 0x5c91},
	{0xd6ab, 0x5c94},
	{0xd6ac, 0x599b},
	{0xd6ad, 0x5cab},
	{0xd6ae, 0x5cbb},
	{0xd6af, 0x5cb6},
	{0xd6b0, 0x5cbc},
	{0xd6b1, 0x5cb7},
	{0xd6b2, 0x5cc5},
	{0xd6b3, 0x5cbe},
	{0xd6b4, 0x5cc7},
	{0xd6b5, 0x5cd9},
	{0xd6b6, 0x5ce9},
	{0xd6b7, 0x5cfd},
	{0xd6b8, 0x5cfa},
	{0xd6b9, 0x5ced},
	{0xd6ba, 0x5d8c},
	{0xd6bb, 0x5cea},
	{0xd6bc, 0x5d0b},
	{0xd6bd, 0x5d15},
	{0xd6be, 0x5d17},
	{0xd6bf, 0x5d5c},
	{0xd6c0, 0x5d1f},
	{0xd6c1, 0x5d1b},
	{0xd6c2, 0x5d11},
	{0xd6c3, 0x5d14},
	{0xd6c4, 0x5d22},
	{0xd6c5, 0x5d1a},
	{0xd6c6, 0x5d19},
	{0xd6c7, 0x5d18},
	{0xd6c8, 0x5d4c},
	{0xd6c9, 0x5d52},
	{0xd6ca, 0x5d4e},
	{0xd6cb, 0x5d4b},
	{0xd6cc, 0x5d6c},
	{0xd6cd, 0x5d73},
	{0xd6ce, 0x5d76},
	{0xd6cf, 0x5d87},
	{0xd6d0, 0x5d84},
	{0xd6d1, 0x5d82},
	{0xd6d2, 0x5da2},
	{0xd6d3, 0x5d9d},
	{0xd6d4, 0x5dac},
	{0xd6d5, 0x5dae},
	{0xd6d6, 0x5dbd},
	{0xd6d7, 0x5d90},
	{0xd6d8, 0x5db7},
	{0xd6d9, 0x5dbc},
	{0xd6da, 0x5dc9},
	{0xd6db, 0x5dcd},
	{0xd6dc, 0x5dd3},
	{0xd6dd, 0x5dd2},
	{0xd6de, 0x5dd6},
	{0xd6df, 0x5ddb},
	{0xd6e0, 0x5deb},
	{0xd6e1, 0x5df2},
	{0xd6e2, 0x5df5},
	{0xd6e3, 0x5e0b},
	{0xd6e4, 0x5e1a},
	{0xd6e5, 0x5e19},
	{0xd6e6, 0x5e11},
	{0xd6e7, 0x5e1b},
	{0xd6e8, 0x5e36},
	{0xd6e9, 0x5e37},
	{0xd6ea, 0x5e44},
	{0xd6eb, 0x5e43},
	{0xd6ec, 0x5e40},
	{0xd6ed, 0x5e4e},
	{0xd6ee, 0x5e57},
	{0xd6ef, 0x5e54},
	{0xd6f0, 0x5e5f},
	{0xd6f1, 0x5e62},
	{0xd6f2, 0x5e64},
	{0xd6f3, 0x5e47},
	{0xd6f4, 0x5e75},
	{0xd6f5, 0x5e76},
	{0xd6f6, 0x5e7a},
	{0xd6f7, 0x9ebc},
	{0xd6f8, 0x5e7f},
	{0xd6f9, 0x5ea0},
	{0xd6fa, 0x5ec1},
	{0xd6fb, 0x5ec2},
	{0xd6fc, 0x5ec8},
	{0xd6fd, 0x5ed0},
	{0xd6fe, 0x5ecf},
	{0xd7a1, 0x5ed6},
	{0xd7a2, 0x5ee3},
	{0xd7a3, 0x5edd},
	{0xd7a4, 0x5eda},
	{0xd7a5, 0x5edb},
	{0xd7a6, 0x5ee2},
	{0xd7a7, 0x5ee1},
	{0xd7a8, 0x5ee8},
	{0xd7a9, 0x5ee9},
	{0xd7aa, 0x5eec},
	{0xd7ab, 0x5ef1},
	{0xd7ac, 0x5ef3},
	{0xd7ad, 0x5ef0},
	{0xd7ae, 0x5ef4},
	{0xd7af, 0x5ef8},
	{0xd7b0, 0x5efe},
	{0xd7b1, 0x5f03},
	{0xd7b2, 0x5f09},
	{0xd7b3, 0x5f5d},
	{0xd7b4, 0x5f5c},
	{0xd7b5, 0x5f0b},
	{0xd7b6, 0x5f11},
	{0xd7b7, 0x5f16},
	{0xd7b8, 0x5f29},
	{0xd7b9, 0x5f2d},
	{0xd7ba, 0x5f38},
	{0xd7bb, 0x5f41},
	{0xd7bc, 0x5f48},
	{0xd7bd, 0x5f4c},
	{0xd7be, 0x5f4e},
	{0xd7bf, 0x5f2f},
	{0xd7c0, 0x5f51},
	{0xd7c1, 0x5f56},
	{0xd7c2, 0x5f57},
	{0xd7c3, 0x5f59},
	{0xd7c4, 0x5f61},
	{0xd7c5, 0x5f6d},
	{0xd7c6, 0x5f73},
	{0xd7c7, 0x5f77},
	{0xd7c8, 0x5f83},
	{0xd7c9, 0x5f82},
	{0xd7ca, 0x5f7f},
	{0xd7cb, 0x5f8a},
	{0xd7cc, 0x5f88},
	{0xd7cd, 0x5f91},
	{0xd7ce, 0x5f87},
	{0xd7cf, 0x5f9e},
	{0xd7d0, 0x5f99},
	{0xd7d1, 0x5f98},
	{0xd7d2, 0x5fa0},
	{0xd7d3, 0x5fa8},
	{0xd7d4, 0x5fad},
	{0xd7d5, 0x5fbc},
	{0xd7d6, 0x5fd6},
	{0xd7d7, 0x5ffb},
	{0xd7d8, 0x5fe4},
	{0xd7d9, 0x5ff8},
	{0xd7da, 0x5ff1},
	{0xd7db, 0x5fdd},
	{0xd7dc, 0x60b3},
	{0xd7dd, 0x5fff},
	{0xd7de, 0x6021},
	{0xd7df, 0x6060},
	{0xd7e0, 0x6019},
	{0xd7e1, 0x6010},
	{0xd7e2, 0x6029},
	{0xd7e3, 0x600e},
	{0xd7e4, 0x6031},
	{0xd7e5, 0x601b},
	{0xd7e6, 0x6015},
	{0xd7e7, 0x602b},
	{0xd7e8, 0x6026},
	{0xd7e9, 0x600f},
	{0xd7ea, 0x603a},
	{0xd7eb, 0x605a},
	{0xd7ec, 0x6041},
	{0xd7ed, 0x606a},
	{0xd7ee, 0x6077},
	{0xd7ef, 0x605f},
	{0xd7f0, 0x604a},
	{0xd7f1, 0x6046},
	{0xd7f2, 0x604d},
	{0xd7f3, 0x6063},
	{0xd7f4, 0x6043},
	{0xd7f5, 0x6064},
	{0xd7f6, 0x6042},
	{0xd7f7, 0x606c},
	{0xd7f8, 0x606b},
	{0xd7f9, 0x6059},
	{0xd7fa, 0x6081},
	{0xd7fb, 0x608d},
	{0xd7fc, 0x60e7},
	{0xd7fd, 0x6083},
	{0xd7fe, 0x609a},
	{0xd8a1, 0x6084},
	{0xd8a2, 0x609b},
	{0xd8a3, 0x6096},
	{0xd8a4, 0x6097},
	{0xd8a5, 0x6092},
	{0xd8a6, 0x60a7},
	{0xd8a7, 0x608b},
	{0xd8a8, 0x60e1},
	{0xd8a9, 0x60b8},
	{0xd8aa, 0x60e0},
	{0xd8ab, 0x60d3},
	{0xd8ac, 0x60b4},
	{0xd8ad, 0x5ff0},
	{0xd8ae, 0x60bd},
	{0xd8af, 0x60c6},
	{0xd8b0, 0x60b5},
	{0xd8b1, 0x60d8},
	{0xd8b2, 0x614d},
	{0xd8b3, 0x6115},
	{0xd8b4, 0x6106},
	{0xd8b5, 0x60f6},
	{0xd8b6, 0x60f7},
	{0xd8b7, 0x6100},
	{0xd8b8, 0x60f4},
	{0xd8b9, 0x60fa},
	{0xd8ba, 0x6103},
	{0xd8bb, 0x6121},
	{0xd8bc, 0x60fb},
	{0xd8bd, 0x60f1},
	{0xd8be, 0x610d},
	{0xd8bf, 0x610e},
	{0xd8c0, 0x6147},
	{0xd8c1, 0x613e},
	{0xd8c2, 0x6128},
	{0xd8c3, 0x6127},
	{0xd8c4, 0x614a},
	{0xd8c5, 0x613f},
	{0xd8c6, 0x613c},
	{0xd8c7, 0x612c},
	{0xd8c8, 0x6134},
	{0xd8c9, 0x613d},
	{0xd8ca, 0x6142},
	{0xd8cb, 0x6144},
	{0xd8cc, 0x6173},
	{0xd8cd, 0x6177},
	{0xd8ce, 0x6158},
	{0xd8cf, 0x6159},
	{0xd8d0, 0x615a},
	{0xd8d1, 0x616b},
	{0xd8d2, 0x6174},
	{0xd8d3, 0x616f},
	{0xd8d4, 0x6165},
	{0xd8d5, 0x6171},
	{0xd8d6, 0x615f},
	{0xd8d7, 0x615d},
	{0xd8d8, 0x6153},
	{0xd8d9, 0x6175},
	{0xd8da, 0x6199},
	{0xd8db, 0x6196},
	{0xd8dc, 0x6187},
	{0xd8dd, 0x61ac},
	{0xd8de, 0x6194},
	{0xd8df, 0x619a},
	{0xd8e0, 0x618a},
	{0xd8e1, 0x6191},
	{0xd8e2, 0x61ab},
	{0xd8e3, 0x61ae},
	{0xd8e4, 0x61cc},
	{0xd8e5, 0x61ca},
	{0xd8e6, 0x61c9},
	{0xd8e7, 0x61f7},
	{0xd8e8, 0x61c8},
	{0xd8e9, 0x61c3},
	{0xd8ea, 0x61c6},
	{0xd8eb, 0x61ba},
	{0xd8ec, 0x61cb},
	{0xd8ed, 0x7f79},
	{0xd8ee, 0x61cd},
	{0xd8ef, 0x61e6},
	{0xd8f0, 0x61e3},
	{0xd8f1, 0x61f6},
	{0xd8f2, 0x61fa},
	{0xd8f3, 0x61f4},
	{0xd8f4, 0x61ff},
	{0xd8f5, 0x61fd},
	{0xd8f6, 0x61fc},
	{0xd8f7, 0x61fe},
	{0xd8f8, 0x6200},
	{0xd8f9, 0x6208},
	{0xd8fa, 0x6209},
	{0xd8fb, 0x620d},
	{0xd8fc, 0x620c},
	{0xd8fd, 0x6214},
	{0xd8fe, 0x621b},
	{0xd9a1, 0x621e},
	{0xd9a2, 0x6221},
	{0xd9a3, 0x622a},
	{0xd9a4, 0x622e},
	{0xd9a5, 0x6230},
	{0xd9a6, 0x6232},
	{0xd9a7, 0x6233},
	{0xd9a8, 0x6241},
	{0xd9a9, 0x624e},
	{0xd9aa, 0x625e},
	{0xd9ab, 0x6263},
	{0xd9ac, 0x625b},
	{0xd9ad, 0x6260},
	{0xd9ae, 0x6268},
	{0xd9af, 0x627c},
	{0xd9b0, 0x6282},
	{0xd9b1, 0x6289},
	{0xd9b2, 0x627e},
	{0xd9b3, 0x6292},
	{0xd9b4, 0x6293},
	{0xd9b5, 0x6296},
	{0xd9b6, 0x62d4},
	{0xd9b7, 0x6283},
	{0xd9b8, 0x6294},
	{0xd9b9, 0x62d7},
	{0xd9ba, 0x62d1},
	{0xd9bb, 0x62bb},
	{0xd9bc, 0x62cf},
	{0xd9bd, 0x62ff},
	{0xd9be, 0x62c6},
	{0xd9bf, 0x64d4},
	{0xd9c0, 0x62c8},
	{0xd9c1, 0x62dc},
	{0xd9c2, 0x62cc},
	{0xd9c3, 0x62ca},
	{0xd9c4, 0x62c2},
	{0xd9c5, 0x62c7},
	{0xd9c6, 0x629b},
	{0xd9c7, 0x62c9},
	{0xd9c8, 0x630c},
	{0xd9c9, 0x62ee},
	{0xd9ca, 0x62f1},
	{0xd9cb, 0x6327},
	{0xd9cc, 0x6302},
	{0xd9cd, 0x6308},
	{0xd9ce, 0x62ef},
	{0xd9cf, 0x62f5},
	{0xd9d0, 0x6350},
	{0xd9d1, 0x633e},
	{0xd9d2, 0x634d},
	{0xd9d3, 0x641c},
	{0xd9d4, 0x634f},
	{0xd9d5, 0x6396},
	{0xd9d6, 0x638e},
	{0xd9d7, 0x6380},
	{0xd9d8, 0x63ab},
	{0xd9d9, 0x6376},
	{0xd9da, 0x63a3},
	{0xd9db, 0x638f},
	{0xd9dc, 0x6389},
	{0xd9dd, 0x639f},
	{0xd9de, 0x63b5},
	{0xd9df, 0x636b},
	{0xd9e0, 0x6369},
	{0xd9e1, 0x63be},
	{0xd9e2, 0x63e9},
	{0xd9e3, 0x63c0},
	{0xd9e4, 0x63c6},
	{0xd9e5, 0x63e3},
	{0xd9e6, 0x63c9},
	{0xd9e7, 0x63d2},
	{0xd9e8, 0x63f6},
	{0xd9e9, 0x63c4},
	{0xd9ea, 0x6416},
	{0xd9eb, 0x6434},
	{0xd9ec, 0x6406},
	{0xd9ed, 0x6413},
	{0xd9ee, 0x6426},
	{0xd9ef, 0x6436},
	{0xd9f0, 0x651d},
	{0xd9f1, 0x6417},
	{0xd9f2, 0x6428},
	{0xd9f3, 0x640f},
	{0xd9f4, 0x6467},
	{0xd9f5, 0x646f},
	{0xd9f6, 0x6476},
	{0xd9f7, 0x644e},
	{0xd9f8, 0x652a},
	{0xd9f9, 0x6495},
	{0xd9fa, 0x6493},
	{0xd9fb, 0x64a5},
	{0xd9fc, 0x64a9},
	{0xd9fd, 0x6488},
	{0xd9fe, 0x64bc},
	{0xdaa1, 0x64da},
	{0xdaa2, 0x64d2},
	{0xdaa3, 0x64c5},
	{0xdaa4, 0x64c7},
	{0xdaa5, 0x64bb},
	{0xdaa6, 0x64d8},
	{0xdaa7, 0x64c2},
	{0xdaa8, 0x64f1},
	{0xdaa9, 0x64e7},
	{0xdaaa, 0x8209},
	{0xdaab, 0x64e0},
	{0xdaac, 0x64e1},
	{0xdaad, 0x62ac},
	{0xdaae, 0x64e3},
	{0xdaaf, 0x64ef},
	{0xdab0, 0x652c},
	{0xdab1, 0x64f6},
	{0xdab2, 0x64f4},
	{0xdab3, 0x64f2},
	{0xdab4, 0x64fa},
	{0xdab5, 0x6500},
	{0xdab6, 0x64fd},
	{0xdab7, 0x6518},
	{0xdab8, 0x651c},
	{0xdab9, 0x6505},
	{0xdaba, 0x6524},
	{0xdabb, 0x6523},
	{0xdabc, 0x652b},
	{0xdabd, 0x6534},
	{0xdabe, 0x6535},
	{0xdabf, 0x6537},
	{0xdac0, 0x6536},
	{0xdac1, 0x6538},
	{0xdac2, 0x754b},
	{0xdac3, 0x6548},
	{0xdac4, 0x6556},
	{0xdac5, 0x6555},
	{0xdac6, 0x654d},
	{0xdac7, 0x6558},
	{0xdac8, 0x655e},
	{0xdac9, 0x655d},
	{0xdaca, 0x6572},
	{0xdacb, 0x6578},
	{0xdacc, 0x6582},
	{0xdacd, 0x6583},
	{0xdace, 0x8b8a},
	{0xdacf, 0x659b},
	{0xdad0, 0x659f},
	{0xdad1, 0x65ab},
	{0xdad2, 0x65b7},
	{0xdad3, 0x65c3},
	{0xdad4, 0x65c6},
	{0xdad5, 0x65c1},
	{0xdad6, 0x65c4},
	{0xdad7, 0x65cc},
	{0xdad8, 0x65d2},
	{0xdad9, 0x65db},
	{0xdada, 0x65d9},
	{0xdadb, 0x65e0},
	{0xdadc, 0x65e1},
	{0xdadd, 0x65f1},
	{0xdade, 0x6772},
	{0xdadf, 0x660a},
	{0xdae0, 0x6603},
	{0xdae1, 0x65fb},
	{0xdae2, 0x6773},
	{0xdae3, 0x6635},
	{0xdae4, 0x6636},
	{0xdae5, 0x6634},
	{0xdae6, 0x661c},
	{0xdae7, 0x664f},
	{0xdae8, 0x6644},
	{0xdae9, 0x6649},
	{0xdaea, 0x6641},
	{0xdaeb, 0x665e},
	{0xdaec, 0x665d},
	{0xdaed, 0x6664},
	{0xdaee, 0x6667},
	{0xdaef, 0x6668},
	{0xdaf0, 0x665f},
	{0xdaf1, 0x6662},
	{0xdaf2, 0x6670},
	{0xdaf3, 0x6683},
	{0xdaf4, 0x6688},
	{0xdaf5, 0x668e},
	{0xdaf6, 0x6689},
	{0xdaf7, 0x6684},
	{0xdaf8, 0x6698},
	{0xdaf9, 0x669d},
	{0xdafa, 0x66c1},
	{0xdafb, 0x66b9},
	{0xdafc, 0x66c9},
	{0xdafd, 0x66be},
	{0xdafe, 0x66bc},
	{0xdba1, 0x66c4},
	{0xdba2, 0x66b8},
	{0xdba3, 0x66d6},
	{0xdba4, 0x66da},
	{0xdba5, 0x66e0},
	{0xdba6, 0x663f},
	{0xdba7, 0x66e6},
	{0xdba8, 0x66e9},
	{0xdba9, 0x66f0},
	{0xdbaa, 0x66f5},
	{0xdbab, 0x66f7},
	{0xdbac, 0x670f},
	{0xdbad, 0x6716},
	{0xdbae, 0x671e},
	{0xdbaf, 0x6726},
	{0xdbb0, 0x6727},
	{0xdbb1, 0x9738},
	{0xdbb2, 0x672e},
	{0xdbb3, 0x673f},
	{0xdbb4, 0x6736},
	{0xdbb5, 0x6741},
	{0xdbb6, 0x6738},
	{0xdbb7, 0x6737},
	{0xdbb8, 0x6746},
	{0xdbb9, 0x675e},
	{0xdbba, 0x6760},
	{0xdbbb, 0x6759},
	{0xdbbc, 0x6763},
	{0xdbbd, 0x6764},
	{0xdbbe, 0x6789},
	{0xdbbf, 0x6770},
	{0xdbc0, 0x67a9},
	{0xdbc1, 0x677c},
	{0xdbc2, 0x676a},
	{0xdbc3, 0x678c},
	{0xdbc4, 0x678b},
	{0xdbc5, 0x67a6},
	{0xdbc6, 0x67a1},
	{0xdbc7, 0x6785},
	{0xdbc8, 0x67b7},
	{0xdbc9, 0x67ef},
	{0xdbca, 0x67b4},
	{0xdbcb, 0x67ec},
	{0xdbcc, 0x67b3},
	{0xdbcd, 0x67e9},
	{0xdbce, 0x67b8},
	{0xdbcf, 0x67e4},
	{0xdbd0, 0x67de},
	{0xdbd1, 0x67dd},
	{0xdbd2, 0x67e2},
	{0xdbd3, 0x67ee},
	{0xdbd4, 0x67b9},
	{0xdbd5, 0x67ce},
	{0xdbd6, 0x67c6},
	{0xdbd7, 0x67e7},
	{0xdbd8, 0x6a9c},
	{0xdbd9, 0x681e},
	{0xdbda, 0x6846},
	{0xdbdb, 0x6829},
	{0xdbdc, 0x6840},
	{0xdbdd, 0x684d},
	{0xdbde, 0x6832},
	{0xdbdf, 0x684e},
	{0xdbe0, 0x68b3},
	{0xdbe1, 0x682b},
	{0xdbe2, 0x6859},
	{0xdbe3, 0x6863},
	{0xdbe4, 0x6877},
	{0xdbe5, 0x687f},
	{0xdbe6, 0x689f},
	{0xdbe7, 0x688f},
	{0xdbe8, 0x68ad},
	{0xdbe9, 0x6894},
	{0xdbea, 0x689d},
	{0xdbeb, 0x689b},
	{0xdbec, 0x6883},
	{0xdbed, 0x6aae},
	{0xdbee, 0x68b9},
	{0xdbef, 0x6874},
	{0xdbf0, 0x68b5},
	{0xdbf1, 0x68a0},
	{0xdbf2, 0x68ba},
	{0xdbf3, 0x690f},
	{0xdbf4, 0x688d},
	{0xdbf5, 0x687e},
	{0xdbf6, 0x6901},
	{0xdbf7, 0x68ca},
	{0xdbf8, 0x6908},
	{0xdbf9, 0x68d8},
	{0xdbfa, 0x6922},
	{0xdbfb, 0x6926},
	{0xdbfc, 0x68e1},
	{0xdbfd, 0x690c},
	{0xdbfe, 0x68cd},
	{0xdca1, 0x68d4},
	{0xdca2, 0x68e7},
	{0xdca3, 0x68d5},
	{0xdca4, 0x6936},
	{0xdca5, 0x6912},
	{0xdca6, 0x6904},
	{0xdca7, 0x68d7},
	{0xdca8, 0x68e3},
	{0xdca9, 0x6925},
	{0xdcaa, 0x68f9},
	{0xdcab, 0x68e0},
	{0xdcac, 0x68ef},
	{0xdcad, 0x6928},
	{0xdcae, 0x692a},
	{0xdcaf, 0x691a},
	{0xdcb0, 0x6923},
	{0xdcb1, 0x6921},
	{0xdcb2, 0x68c6},
	{0xdcb3, 0x6979},
	{0xdcb4, 0x6977},
	{0xdcb5, 0x695c},
	{0xdcb6, 0x6978},
	{0xdcb7, 0x696b},
	{0xdcb8, 0x6954},
	{0xdcb9, 0x697e},
	{0xdcba, 0x696e},
	{0xdcbb, 0x6939},
	{0xdcbc, 0x6974},
	{0xdcbd, 0x693d},
	{0xdcbe, 0x6959},
	{0xdcbf, 0x6930},
	{0xdcc0, 0x6961},
	{0xdcc1, 0x695e},
	{0xdcc2, 0x695d},
	{0xdcc3, 0x6981},
	{0xdcc4, 0x696a},
	{0xdcc5, 0x69b2},
	{0xdcc6, 0x69ae},
	{0xdcc7, 0x69d0},
	{0xdcc8, 0x69bf},
	{0xdcc9, 0x69c1},
	{0xdcca, 0x69d3},
	{0xdccb, 0x69be},
	{0xdccc, 0x69ce},
	{0xdccd, 0x5be8},
	{0xdcce, 0x69ca},
	{0xdccf, 0x69dd},
	{0xdcd0, 0x69bb},
	{0xdcd1, 0x69c3},
	{0xdcd2, 0x69a7},
	{0xdcd3, 0x6a2e},
	{0xdcd4, 0x6991},
	{0xdcd5, 0x69a0},
	{0xdcd6, 0x699c},
	{0xdcd7, 0x6995},
	{0xdcd8, 0x69b4},
	{0xdcd9, 0x69de},
	{0xdcda, 0x69e8},
	{0xdcdb, 0x6a02},
	{0xdcdc, 0x6a1b},
	{0xdcdd, 0x69ff},
	{0xdcde, 0x6b0a},
	{0xdcdf, 0x69f9},
	{0xdce0, 0x69f2},
	{0xdce1, 0x69e7},
	{0xdce2, 0x6a05},
	{0xdce3, 0x69b1},
	{0xdce4, 0x6a1e},
	{0xdce5, 0x69ed},
	{0xdce6, 0x6a14},
	{0xdce7, 0x69eb},
	{0xdce8, 0x6a0a},
	{0xdce9, 0x6a12},
	{0xdcea, 0x6ac1},
	{0xdceb, 0x6a23},
	{0xdcec, 0x6a13},
	{0xdced, 0x6a44},
	{0xdcee, 0x6a0c},
	{0xdcef, 0x6a72},
	{0xdcf0, 0x6a36},
	{0xdcf1, 0x6a78},
	{0xdcf2, 0x6a47},
	{0xdcf3, 0x6a62},
	{0xdcf4, 0x6a59},
	{0xdcf5, 0x6a66},
	{0xdcf6, 0x6a48},
	{0xdcf7, 0x6a38},
	{0xdcf8, 0x6a22},
	{0xdcf9, 0x6a90},
	{0xdcfa, 0x6a8d},
	{0xdcfb, 0x6aa0},
	{0xdcfc, 0x6a84},
	{0xdcfd, 0x6aa2},
	{0xdcfe, 0x6aa3},
	{0xdda1, 0x6a97},
	{0xdda2, 0x8617},
	{0xdda3, 0x6abb},
	{0xdda4, 0x6ac3},
	{0xdda5, 0x6ac2},
	{0xdda6, 0x6ab8},
	{0xdda7, 0x6ab3},
	{0xdda8, 0x6aac},
	{0xdda9, 0x6ade},
	{0xddaa, 0x6ad1},
	{0xddab, 0x6adf},
	{0xddac, 0x6aaa},
	{0xddad, 0x6ada},
	{0xddae, 0x6aea},
	{0xddaf, 0x6afb},
	{0xddb0, 0x6b05},
	{0xddb1, 0x8616},
	{0xddb2, 0x6afa},
	{0xddb3, 0x6b12},
	{0xddb4, 0x6b16},
	{0xddb5, 0x9b31},
	{0xddb6, 0x6b1f},
	{0xddb7, 0x6b38},
	{0xddb8, 0x6b37},
	{0xddb9, 0x76dc},
	{0xddba, 0x6b39},
	{0xddbb, 0x98ee},
	{0xddbc, 0x6b47},
	{0xddbd, 0x6b43},
	{0xddbe, 0x6b49},
	{0xddbf, 0x6b50},
	{0xddc0, 0x6b59},
	{0xddc1, 0x6b54},
	{0xddc2, 0x6b5b},
	{0xddc3, 0x6b5f},
	{0xddc4, 0x6b61},
	{0xddc5, 0x6b78},
	{0xddc6, 0x6b79},
	{0xddc7, 0x6b7f},
	{0xddc8, 0x6b80},
	{0xddc9, 0x6b84},
	{0xddca, 0x6b83},
	{0xddcb, 0x6b8d},
	{0xddcc, 0x6b98},
	{0xddcd, 0x6b95},
	{0xddce, 0x6b9e},
	{0xddcf, 0x6ba4},
	{0xddd0, 0x6baa},
	{0xddd1, 0x6bab},
	{0xddd2, 0x6baf},
	{0xddd3, 0x6bb2},
	{0xddd4, 0x6bb1},
	{0xddd5, 0x6bb3},
	{0xddd6, 0x6bb7},
	{0xddd7, 0x6bbc},
	{0xddd8, 0x6bc6},
	{0xddd9, 0x6bcb},
	{0xddda, 0x6bd3},
	{0xdddb, 0x6bdf},
	{0xdddc, 0x6bec},
	{0xdddd, 0x6beb},
	{0xddde, 0x6bf3},
	{0xdddf, 0x6bef},
	{0xdde0, 0x9ebe},
	{0xdde1, 0x6c08},
	{0xdde2, 0x6c13},
	{0xdde3, 0x6c14},
	{0xdde4, 0x6c1b},
	{0xdde5, 0x6c24},
	{0xdde6, 0x6c23},
	{0xdde7, 0x6c5e},
	{0xdde8, 0x6c55},
	{0xdde9, 0x6c62},
	{0xddea, 0x6c6a},
	{0xddeb, 0x6c82},
	{0xddec, 0x6c8d},
	{0xdded, 0x6c9a},
	{0xddee, 0x6c81},
	{0xddef, 0x6c9b},
	{0xddf0, 0x6c7e},
	{0xddf1, 0x6c68},
	{0xddf2, 0x6c73},
	{0xddf3, 0x6c92},
	{0xddf4, 0x6c90},
	{0xddf5, 0x6cc4},
	{0xddf6, 0x6cf1},
	{0xddf7, 0x6cd3},
	{0xddf8, 0x6cbd},
	{0xddf9, 0x6cd7},
	{0xddfa, 0x6cc5},
	{0xddfb, 0x6cdd},
	{0xddfc, 0x6cae},
	{0xddfd, 0x6cb1},
	{0xddfe, 0x6cbe},
	{0xdea1, 0x6cba},
	{0xdea2, 0x6cdb},
	{0xdea3, 0x6cef},
	{0xdea4, 0x6cd9},
	{0xdea5, 0x6cea},
	{0xdea6, 0x6d1f},
	{0xdea7, 0x884d},
	{0xdea8, 0x6d36},
	{0xdea9, 0x6d2b},
	{0xdeaa, 0x6d3d},
	{0xdeab, 0x6d38},
	{0xdeac, 0x6d19},
	{0xdead, 0x6d35},
	{0xdeae, 0x6d33},
	{0xdeaf, 0x6d12},
	{0xdeb0, 0x6d0c},
	{0xdeb1, 0x6d63},
	{0xdeb2, 0x6d93},
	{0xdeb3, 0x6d64},
	{0xdeb4, 0x6d5a},
	{0xdeb5, 0x6d79},
	{0xdeb6, 0x6d59},
	{0xdeb7, 0x6d8e},
	{0xdeb8, 0x6d95},
	{0xdeb9, 0x6fe4},
	{0xdeba, 0x6d85},
	{0xdebb, 0x6df9},
	{0xdebc, 0x6e15},
	{0xdebd, 0x6e0a},
	{0xdebe, 0x6db5},
	{0xdebf, 0x6dc7},
	{0xdec0, 0x6de6},
	{0xdec1, 0x6db8},
	{0xdec2, 0x6dc6},
	{0xdec3, 0x6dec},
	{0xdec4, 0x6dde},
	{0xdec5, 0x6dcc},
	{0xdec6, 0x6de8},
	{0xdec7, 0x6dd2},
	{0xdec8, 0x6dc5},
	{0xdec9, 0x6dfa},
	{0xdeca, 0x6dd9},
	{0xdecb, 0x6de4},
	{0xdecc, 0x6dd5},
	{0xdecd, 0x6dea},
	{0xdece, 0x6dee},
	{0xdecf, 0x6e2d},
	{0xded0, 0x6e6e},
	{0xded1, 0x6e2e},
	{0xded2, 0x6e19},
	{0xded3, 0x6e72},
	{0xded4, 0x6e5f},
	{0xded5, 0x6e3e},
	{0xded6, 0x6e23},
	{0xded7, 0x6e6b},
	{0xded8, 0x6e2b},
	{0xded9, 0x6e76},
	{0xdeda, 0x6e4d},
	{0xdedb, 0x6e1f},
	{0xdedc, 0x6e43},
	{0xdedd, 0x6e3a},
	{0xdede, 0x6e4e},
	{0xdedf, 0x6e24},
	{0xdee0, 0x6eff},
	{0xdee1, 0x6e1d},
	{0xdee2, 0x6e38},
	{0xdee3, 0x6e82},
	{0xdee4, 0x6eaa},
	{0xdee5, 0x6e98},
	{0xdee6, 0x6ec9},
	{0xdee7, 0x6eb7},
	{0xdee8, 0x6ed3},
	{0xdee9, 0x6ebd},
	{0xdeea, 0x6eaf},
	{0xdeeb, 0x6ec4},
	{0xdeec, 0x6eb2},
	{0xdeed, 0x6ed4},
	{0xdeee, 0x6ed5},
	{0xdeef, 0x6e8f},
	{0xdef0, 0x6ea5},
	{0xdef1, 0x6ec2},
	{0xdef2, 0x6e9f},
	{0xdef3, 0x6f41},
	{0xdef4, 0x6f11},
	{0xdef5, 0x704c},
	{0xdef6, 0x6eec},
	{0xdef7, 0x6ef8},
	{0xdef8, 0x6efe},
	{0xdef9, 0x6f3f},
	{0xdefa, 0x6ef2},
	{0xdefb, 0x6f31},
	{0xdefc, 0x6eef},
	{0xdefd, 0x6f32},
	{0xdefe, 0x6ecc},
	{0xdfa1, 0x6f3e},
	{0xdfa2, 0x6f13},
	{0xdfa3, 0x6ef7},
	{0xdfa4, 0x6f86},
	{0xdfa5, 0x6f7a},
	{0xdfa6, 0x6f78},
	{0xdfa7, 0x6f81},
	{0xdfa8, 0x6f80},
	{0xdfa9, 0x6f6f},
	{0xdfaa, 0x6f5b},
	{0xdfab, 0x6ff3},
	{0xdfac, 0x6f6d},
	{0xdfad, 0x6f82},
	{0xdfae, 0x6f7c},
	{0xdfaf, 0x6f58},
	{0xdfb0, 0x6f8e},
	{0xdfb1, 0x6f91},
	{0xdfb2, 0x6fc2},
	{0xdfb3, 0x6f66},
	{0xdfb4, 0x6fb3},
	{0xdfb5, 0x6fa3},
	{0xdfb6, 0x6fa1},
	{0xdfb7, 0x6fa4},
	{0xdfb8, 0x6fb9},
	{0xdfb9, 0x6fc6},
	{0xdfba, 0x6faa},
	{0xdfbb, 0x6fdf},
	{0xdfbc, 0x6fd5},
	{0xdfbd, 0x6fec},
	{0xdfbe, 0x6fd4},
	{0xdfbf, 0x6fd8},
	{0xdfc0, 0x6ff1},
	{0xdfc1, 0x6fee},
	{0xdfc2, 0x6fdb},
	{0xdfc3, 0x7009},
	{0xdfc4, 0x700b},
	{0xdfc5, 0x6ffa},
	{0xdfc6, 0x7011},
	{0xdfc7, 0x7001},
	{0xdfc8, 0x700f},
	{0xdfc9, 0x6ffe},
	{0xdfca, 0x701b},
	{0xdfcb, 0x701a},
	{0xdfcc, 0x6f74},
	{0xdfcd, 0x701d},
	{0xdfce, 0x7018},
	{0xdfcf, 0x701f},
	{0xdfd0, 0x7030},
	{0xdfd1, 0x703e},
	{0xdfd2, 0x7032},
	{0xdfd3, 0x7051},
	{0xdfd4, 0x7063},
	{0xdfd5, 0x7099},
	{0xdfd6, 0x7092},
	{0xdfd7, 0x70af},
	{0xdfd8, 0x70f1},
	{0xdfd9, 0x70ac},
	{0xdfda, 0x70b8},
	{0xdfdb, 0x70b3},
	{0xdfdc, 0x70ae},
	{0xdfdd, 0x70df},
	{0xdfde, 0x70cb},
	{0xdfdf, 0x70dd},
	{0xdfe0, 0x70d9},
	{0xdfe1, 0x7109},
	{0xdfe2, 0x70fd},
	{0xdfe3, 0x711c},
	{0xdfe4, 0x7119},
	{0xdfe5, 0x7165},
	{0xdfe6, 0x7155},
	{0xdfe7, 0x7188},
	{0xdfe8, 0x7166},
	{0xdfe9, 0x7162},
	{0xdfea, 0x714c},
	{0xdfeb, 0x7156},
	{0xdfec, 0x716c},
	{0xdfed, 0x718f},
	{0xdfee, 0x71fb},
	{0xdfef, 0x7184},
	{0xdff0, 0x7195},
	{0xdff1, 0x71a8},
	{0xdff2, 0x71ac},
	{0xdff3, 0x71d7},
	{0xdff4, 0x71b9},
	{0xdff5, 0x71be},
	{0xdff6, 0x71d2},
	{0xdff7, 0x71c9},
	{0xdff8, 0x71d4},
	{0xdff9, 0x71ce},
	{0xdffa, 0x71e0},
	{0xdffb, 0x71ec},
	{0xdffc, 0x71e7},
	{0xdffd, 0x71f5},
	{0xdffe, 0x71fc},
	{0xe0a1, 0x71f9},
	{0xe0a2, 0x71ff},
	{0xe0a3, 0x720d},
	{0xe0a4, 0x7210},
	{0xe0a5, 0x721b},
	{0xe0a6, 0x7228},
	{0xe0a7, 0x722d},
	{0xe0a8, 0x722c},
	{0xe0a9, 0x7230},
	{0xe0aa, 0x7232},
	{0xe0ab, 0x723b},
	{0xe0ac, 0x723c},
	{0xe0ad, 0x723f},
	{0xe0ae, 0x7240},
	{0xe0af, 0x7246},
	{0xe0b0, 0x724b},
	{0xe0b1, 0x7258},
	{0xe0b2, 0x7274},
	{0xe0b3, 0x727e},
	{0xe0b4, 0x7282},
	{0xe0b5, 0x7281},
	{0xe0b6, 0x7287},
	{0xe0b7, 0x7292},
	{0xe0b8, 0x7296},
	{0xe0b9, 0x72a2},
	{0xe0ba, 0x72a7},
	{0xe0bb, 0x72b9},
	{0xe0bc, 0x72b2},
	{0xe0bd, 0x72c3},
	{0xe0be, 0x72c6},
	{0xe0bf, 0x72c4},
	{0xe0c0, 0x72ce},
	{0xe0c1, 0x72d2},
	{0xe0c2, 0x72e2},
	{0xe0c3, 0x72e0},
	{0xe0c4, 0x72e1},
	{0xe0c5, 0x72f9},
	{0xe0c6, 0x72f7},
	{0xe0c7, 0x500f},
	{0xe0c8, 0x7317},
	{0xe0c9, 0x730a},
	{0xe0ca, 0x731c},
	{0xe0cb, 0x7316},
	{0xe0cc, 0x731d},
	{0xe0cd, 0x7334},
	{0xe0ce, 0x732f},
	{0xe0cf, 0x7329},
	{0xe0d0, 0x7325},
	{0xe0d1, 0x733e},
	{0xe0d2, 0x734e},
	{0xe0d3, 0x734f},
	{0xe0d4, 0x9ed8},
	{0xe0d5, 0x7357},
	{0xe0d6, 0x736a},
	{0xe0d7, 0x7368},
	{0xe0d8, 0x7370},
	{0xe0d9, 0x7378},
	{0xe0da, 0x7375},
	{0xe0db, 0x737b},
	{0xe0dc, 0x737a},
	{0xe0dd, 0x73c8},
	{0xe0de, 0x73b3},
	{0xe0df, 0x73ce},
	{0xe0e0, 0x73bb},
	{0xe0e1, 0x73c0},
	{0xe0e2, 0x73e5},
	{0xe0e3, 0x73ee},
	{0xe0e4, 0x73de},
	{0xe0e5, 0x74a2},
	{0xe0e6, 0x7405},
	{0xe0e7, 0x746f},
	{0xe0e8, 0x7425},
	{0xe0e9, 0x73f8},
	{0xe0ea, 0x7432},
	{0xe0eb, 0x743a},
	{0xe0ec, 0x7455},
	{0xe0ed, 0x743f},
	{0xe0ee, 0x745f},
	{0xe0ef, 0x7459},
	{0xe0f0, 0x7441},
	{0xe0f1, 0x745c},
	{0xe0f2, 0x7469},
	{0xe0f3, 0x7470},
	{0xe0f4, 0x7463},
	{0xe0f5, 0x746a},
	{0xe0f6, 0x7476},
	{0xe0f7, 0x747e},
	{0xe0f8, 0x748b},
	{0xe0f9, 0x749e},
	{0xe0fa, 0x74a7},
	{0xe0fb, 0x74ca},
	{0xe0fc, 0x74cf},
	{0xe0fd, 0x74d4},
	{0xe0fe, 0x73f1},
	{0xe1a1, 0x74e0},
	{0xe1a2, 0x74e3},
	{0xe1a3, 0x74e7},
	{0xe1a4, 0x74e9},
	{0xe1a5, 0x74ee},
	{0xe1a6, 0x74f2},
	{0xe1a7, 0x74f0},
	{0xe1a8, 0x74f1},
	{0xe1a9, 0x74f8},
	{0xe1aa, 0x74f7},
	{0xe1ab, 0x7504},
	{0xe1ac, 0x7503},
	{0xe1ad, 0x7505},
	{0xe1ae, 0x750c},
	{0xe1af, 0x750e},
	{0xe1b0, 0x750d},
	{0xe1b1, 0x7515},
	{0xe1b2, 0x7513},
	{0xe1b3, 0x751e},
	{0xe1b4, 0x7526},
	{0xe1b5, 0x752c},
	{0xe1b6, 0x753c},
	{0xe1b7, 0x7544},
	{0xe1b8, 0x754d},
	{0xe1b9, 0x754a},
	{0xe1ba, 0x7549},
	{0xe1bb, 0x755b},
	{0xe1bc, 0x7546},
	{0xe1bd, 0x755a},
	{0xe1be, 0x7569},
	{0xe1bf, 0x7564},
	{0xe1c0, 0x7567},
	{0xe1c1, 0x756b},
	{0xe1c2, 0x756d},
	{0xe1c3, 0x7578},
	{0xe1c4, 0x7576},
	{0xe1c5, 0x7586},
	{0xe1c6, 0x7587},
	{0xe1c7, 0x7574},
	{0xe1c8, 0x758a},
	{0xe1c9, 0x7589},
	{0xe1ca, 0x7582},
	{0xe1cb, 0x7594},
	{0xe1cc, 0x759a},
	{0xe1cd, 0x759d},
	{0xe1ce, 0x75a5},
	{0xe1cf, 0x75a3},
	{0xe1d0, 0x75c2},
	{0xe1d1, 0x75b3},
	{0xe1d2, 0x75c3},
	{0xe1d3, 0x75b5},
	{0xe1d4, 0x75bd},
	{0xe1d5, 0x75b8},
	{0xe1d6, 0x75bc},
	{0xe1d7, 0x75b1},
	{0xe1d8, 0x75cd},
	{0xe1d9, 0x75ca},
	{0xe1da, 0x75d2},
	{0xe1db, 0x75d9},
	{0xe1dc, 0x75e3},
	{0xe1dd, 0x75de},
	{0xe1de, 0x75fe},
	{0xe1df, 0x75ff},
	{0xe1e0, 0x75fc},
	{0xe1e1, 0x7601},
	{0xe1e2, 0x75f0},
	{0xe1e3, 0x75fa},
	{0xe1e4, 0x75f2},
	{0xe1e5, 0x75f3},
	{0xe1e6, 0x760b},
	{0xe1e7, 0x760d},
	{0xe1e8, 0x7609},
	{0xe1e9, 0x761f},
	{0xe1ea, 0x7627},
	{0xe1eb, 0x7620},
	{0xe1ec, 0x7621},
	{0xe1ed, 0x7622},
	{0xe1ee, 0x7624},
	{0xe1ef, 0x7634},
	{0xe1f0, 0x7630},
	{0xe1f1, 0x763b},
	{0xe1f2, 0x7647},
	{0xe1f3, 0x7648},
	{0xe1f4, 0x7646},
	{0xe1f5, 0x765c},
	{0xe1f6, 0x7658},
	{0xe1f7, 0x7661},
	{0xe1f8, 0x7662},
	{0xe1f9, 0x7668},
	{0xe1fa, 0x7669},
	{0xe1fb, 0x766a},
	{0xe1fc, 0x7667},
	{0xe1fd, 0x766c},
	{0xe1fe, 0x7670},
	{0xe2a1, 0x7672},
	{0xe2a2, 0x7676},
	{0xe2a3, 0x7678},
	{0xe2a4, 0x767c},
	{0xe2a5, 0x7680},
	{0xe2a6, 0x7683},
	{0xe2a7, 0x7688},
	{0xe2a8, 0x768b},
	{0xe2a9, 0x768e},
	{0xe2aa, 0x7696},
	{0xe2ab, 0x7693},
	{0xe2ac, 0x7699},
	{0xe2ad, 0x769a},
	{0xe2ae, 0x76b0},
	{0xe2af, 0x76b4},
	{0xe2b0, 0x76b8},
	{0xe2b1, 0x76b9},
	{0xe2b2, 0x76ba},
	{0xe2b3, 0x76c2},
	{0xe2b4, 0x76cd},
	{0xe2b5, 0x76d6},
	{0xe2b6, 0x76d2},
	{0xe2b7, 0x76de},
	{0xe2b8, 0x76e1},
	{0xe2b9, 0x76e5},
	{0xe2ba, 0x76e7},
	{0xe2bb, 0x76ea},
	{0xe2bc, 0x862f},
	{0xe2bd, 0x76fb},
	{0xe2be, 0x7708},
	{0xe2bf, 0x7707},
	{0xe2c0, 0x7704},
	{0xe2c1, 0x7729},
	{0xe2c2, 0x7724},
	{0xe2c3, 0x771e},
	{0xe2c4, 0x7725},
	{0xe2c5, 0x7726},
	{0xe2c6, 0x771b},
	{0xe2c7, 0x7737},
	{0xe2c8, 0x7738},
	{0xe2c9, 0x7747},
	{0xe2ca, 0x775a},
	{0xe2cb, 0x7768},
	{0xe2cc, 0x776b},
	{0xe2cd, 0x775b},
	{0xe2ce, 0x7765},
	{0xe2cf, 0x777f},
	{0xe2d0, 0x777e},
	{0xe2d1, 0x7779},
	{0xe2d2, 0x778e},
	{0xe2d3, 0x778b},
	{0xe2d4, 0x7791},
	{0xe2d5, 0x77a0},
	{0xe2d6, 0x779e},
	{0xe2d7, 0x77b0},
	{0xe2d8, 0x77b6},
	{0xe2d9, 0x77b9},
	{0xe2da, 0x77bf},
	{0xe2db, 0x77bc},
	{0xe2dc, 0x77bd},
	{0xe2dd, 0x77bb},
	{0xe2de, 0x77c7},
	{0xe2df, 0x77cd},
	{0xe2e0, 0x77d7},
	{0xe2e1, 0x77da},
	{0xe2e2, 0x77dc},
	{0xe2e3, 0x77e3},
	{0xe2e4, 0x77ee},
	{0xe2e5, 0x77fc},
	{0xe2e6, 0x780c},
	{0xe2e7, 0x7812},
	{0xe2e8, 0x7926},
	{0xe2e9, 0x7820},
	{0xe2ea, 0x792a},
	{0xe2eb, 0x7845},
	{0xe2ec, 0x788e},
	{0xe2ed, 0x7874},
	{0xe2ee, 0x7886},
	{0xe2ef, 0x787c},
	{0xe2f0, 0x789a},
	{0xe2f1, 0x788c},
	{0xe2f2, 0x78a3},
	{0xe2f3, 0x78b5},
	{0xe2f4, 0x78aa},
	{0xe2f5, 0x78af},
	{0xe2f6, 0x78d1},
	{0xe2f7, 0x78c6},
	{0xe2f8, 0x78cb},
	{0xe2f9, 0x78d4},
	{0xe2fa, 0x78be},
	{0xe2fb, 0x78bc},
	{0xe2fc, 0x78c5},
	{0xe2fd, 0x78ca},
	{0xe2fe, 0x78ec},
	{0xe3a1, 0x78e7},
	{0xe3a2, 0x78da},
	{0xe3a3, 0x78fd},
	{0xe3a4, 0x78f4},
	{0xe3a5, 0x7907},
	{0xe3a6, 0x7912},
	{0xe3a7, 0x7911},
	{0xe3a8, 0x7919},
	{0xe3a9, 0x792c},
	{0xe3aa, 0x792b},
	{0xe3ab, 0x7940},
	{0xe3ac, 0x7960},
	{0xe3ad, 0x7957},
	{0xe3ae, 0x795f},
	{0xe3af, 0x795a},
	{0xe3b0, 0x7955},
	{0xe3b1, 0x7953},
	{0xe3b2, 0x797a},
	{0xe3b3, 0x797f},
	{0xe3b4, 0x798a},
	{0xe3b5, 0x799d},
	{0xe3b6, 0x79a7},
	{0xe3b7, 0x9f4b},
	{0xe3b8, 0x79aa},
	{0xe3b9, 0x79ae},
	{0xe3ba, 0x79b3},
	{0xe3bb, 0x79b9},
	{0xe3bc, 0x79ba},
	{0xe3bd, 0x79c9},
	{0xe3be, 0x79d5},
	{0xe3bf, 0x79e7},
	{0xe3c0, 0x79ec},
	{0xe3c1, 0x79e1},
	{0xe3c2, 0x79e3},
	{0xe3c3, 0x7a08},
	{0xe3c4, 0x7a0d},
	{0xe3c5, 0x7a18},
	{0xe3c6, 0x7a19},
	{0xe3c7, 0x7a20},
	{0xe3c8, 0x7a1f},
	{0xe3c9, 0x7980},
	{0xe3ca, 0x7a31},
	{0xe3cb, 0x7a3b},
	{0xe3cc, 0x7a3e},
	{0xe3cd, 0x7a37},
	{0xe3ce, 0x7a43},
	{0xe3cf, 0x7a57},
	{0xe3d0, 0x7a49},
	{0xe3d1, 0x7a61},
	{0xe3d2, 0x7a62},
	{0xe3d3, 0x7a69},
	{0xe3d4, 0x9f9d},
	{0xe3d5, 0x7a70},
	{0xe3d6, 0x7a79},
	{0xe3d7, 0x7a7d},
	{0xe3d8, 0x7a88},
	{0xe3d9, 0x7a97},
	{0xe3da, 0x7a95},
	{0xe3db, 0x7a98},
	{0xe3dc, 0x7a96},
	{0xe3dd, 0x7aa9},
	{0xe3de, 0x7ac8},
	{0xe3df, 0x7ab0},
	{0xe3e0, 0x7ab6},
	{0xe3e1, 0x7ac5},
	{0xe3e2, 0x7ac4},
	{0xe3e3, 0x7abf},
	{0xe3e4, 0x9083},
	{0xe3e5, 0x7ac7},
	{0xe3e6, 0x7aca},
	{0xe3e7, 0x7acd},
	{0xe3e8, 0x7acf},
	{0xe3e9, 0x7ad5},
	{0xe3ea, 0x7ad3},
	{0xe3eb, 0x7ad9},
	{0xe3ec, 0x7ada},
	{0xe3ed, 0x7add},
	{0xe3ee, 0x7ae1},
	{0xe3ef, 0x7ae2},
	{0xe3f0, 0x7ae6},
	{0xe3f1, 0x7aed},
	{0xe3f2, 0x7af0},
	{0xe3f3, 0x7b02},
	{0xe3f4, 0x7b0f},
	{0xe3f5, 0x7b0a},
	{0xe3f6, 0x7b06},
	{0xe3f7, 0x7b33},
	{0xe3f8, 0x7b18},
	{0xe3f9, 0x7b19},
	{0xe3fa, 0x7b1e},
	{0xe3fb, 0x7b35},
	{0xe3fc, 0x7b28},
	{0xe3fd, 0x7b36},
	{0xe3fe, 0x7b50},
	{0xe4a1, 0x7b7a},
	{0xe4a2, 0x7b04},
	{0xe4a3, 0x7b4d},
	{0xe4a4, 0x7b0b},
	{0xe4a5, 0x7b4c},
	{0xe4a6, 0x7b45},
	{0xe4a7, 0x7b75},
	{0xe4a8, 0x7b65},
	{0xe4a9, 0x7b74},
	{0xe4aa, 0x7b67},
	{0xe4ab, 0x7b70},
	{0xe4ac, 0x7b71},
	{0xe4ad, 0x7b6c},
	{0xe4ae, 0x7b6e},
	{0xe4af, 0x7b9d},
	{0xe4b0, 0x7b98},
	{0xe4b1, 0x7b9f},
	{0xe4b2, 0x7b8d},
	{0xe4b3, 0x7b9c},
	{0xe4b4, 0x7b9a},
	{0xe4b5, 0x7b8b},
	{0xe4b6, 0x7b92},
	{0xe4b7, 0x7b8f},
	{0xe4b8, 0x7b5d},
	{0xe4b9, 0x7b99},
	{0xe4ba, 0x7bcb},
	{0xe4bb, 0x7bc1},
	{0xe4bc, 0x7bcc},
	{0xe4bd, 0x7bcf},
	{0xe4be, 0x7bb4},
	{0xe4bf, 0x7bc6},
	{0xe4c0, 0x7bdd},
	{0xe4c1, 0x7be9},
	{0xe4c2, 0x7c11},
	{0xe4c3, 0x7c14},
	{0xe4c4, 0x7be6},
	{0xe4c5, 0x7be5},
	{0xe4c6, 0x7c60},
	{0xe4c7, 0x7c00},
	{0xe4c8, 0x7c07},
	{0xe4c9, 0x7c13},
	{0xe4ca, 0x7bf3},
	{0xe4cb, 0x7bf7},
	{0xe4cc, 0x7c17},
	{0xe4cd, 0x7c0d},
	{0xe4ce, 0x7bf6},
	{0xe4cf, 0x7c23},
	{0xe4d0, 0x7c27},
	{0xe4d1, 0x7c2a},
	{0xe4d2, 0x7c1f},
	{0xe4d3, 0x7c37},
	{0xe4d4, 0x7c2b},
	{0xe4d5, 0x7c3d},
	{0xe4d6, 0x7c4c},
	{0xe4d7, 0x7c43},
	{0xe4d8, 0x7c54},
	{0xe4d9, 0x7c4f},
	{0xe4da, 0x7c40},
	{0xe4db, 0x7c50},
	{0xe4dc, 0x7c58},
	{0xe4dd, 0x7c5f},
	{0xe4de, 0x7c64},
	{0xe4df, 0x7c56},
	{0xe4e0, 0x7c65},
	{0xe4e1, 0x7c6c},
	{0xe4e2, 0x7c75},
	{0xe4e3, 0x7c83},
	{0xe4e4, 0x7c90},
	{0xe4e5, 0x7ca4},
	{0xe4e6, 0x7cad},
	{0xe4e7, 0x7ca2},
	{0xe4e8, 0x7cab},
	{0xe4e9, 0x7ca1},
	{0xe4ea, 0x7ca8},
	{0xe4eb, 0x7cb3},
	{0xe4ec, 0x7cb2},
	{0xe4ed, 0x7cb1},
	{0xe4ee, 0x7cae},
	{0xe4ef, 0x7cb9},
	{0xe4f0, 0x7cbd},
	{0xe4f1, 0x7cc0},
	{0xe4f2, 0x7cc5},
	{0xe4f3, 0x7cc2},
	{0xe4f4, 0x7cd8},
	{0xe4f5, 0x7cd2},
	{0xe4f6, 0x7cdc},
	{0xe4f7, 0x7ce2},
	{0xe4f8, 0x9b3b},
	{0xe4f9, 0x7cef},
	{0xe4fa, 0x7cf2},
	{0xe4fb, 0x7cf4},
	{0xe4fc, 0x7cf6},
	{0xe4fd, 0x7cfa},
	{0xe4fe, 0x7d06},
	{0xe5a1, 0x7d02},
	{0xe5a2, 0x7d1c},
	{0xe5a3, 0x7d15},
	{0xe5a4, 0x7d0a},
	{0xe5a5, 0x7d45},
	{0xe5a6, 0x7d4b},
	{0xe5a7, 0x7d2e},
	{0xe5a8, 0x7d32},
	{0xe5a9, 0x7d3f},
	{0xe5aa, 0x7d35},
	{0xe5ab, 0x7d46},
	{0xe5ac, 0x7d73},
	{0xe5ad, 0x7d56},
	{0xe5ae, 0x7d4e},
	{0xe5af, 0x7d72},
	{0xe5b0, 0x7d68},
	{0xe5b1, 0x7d6e},
	{0xe5b2, 0x7d4f},
	{0xe5b3, 0x7d63},
	{0xe5b4, 0x7d93},
	{0xe5b5, 0x7d89},
	{0xe5b6, 0x7d5b},
	{0xe5b7, 0x7d8f},
	{0xe5b8, 0x7d7d},
	{0xe5b9, 0x7d9b},
	{0xe5ba, 0x7dba},
	{0xe5bb, 0x7dae},
	{0xe5bc, 0x7da3},
	{0xe5bd, 0x7db5},
	{0xe5be, 0x7dc7},
	{0xe5bf, 0x7dbd},
	{0xe5c0, 0x7dab},
	{0xe5c1, 0x7e3d},
	{0xe5c2, 0x7da2},
	{0xe5c3, 0x7daf},
	{0xe5c4, 0x7ddc},
	{0xe5c5, 0x7db8},
	{0xe5c6, 0x7d9f},
	{0xe5c7, 0x7db0},
	{0xe5c8, 0x7dd8},
	{0xe5c9, 0x7ddd},
	{0xe5ca, 0x7de4},
	{0xe5cb, 0x7dde},
	{0xe5cc, 0x7dfb},
	{0xe5cd, 0x7df2},
	{0xe5ce, 0x7de1},
	{0xe5cf, 0x7e05},
	{0xe5d0, 0x7e0a},
	{0xe5d1, 0x7e23},
	{0xe5d2, 0x7e21},
	{0xe5d3, 0x7e12},
	{0xe5d4, 0x7e31},
	{0xe5d5, 0x7e1f},
	{0xe5d6, 0x7e09},
	{0xe5d7, 0x7e0b},
	{0xe5d8, 0x7e22},
	{0xe5d9, 0x7e46},
	{0xe5da, 0x7e66},
	{0xe5db, 0x7e3b},
	{0xe5dc, 0x7e35},
	{0xe5dd, 0x7e39},
	{0xe5de, 0x7e43},
	{0xe5df, 0x7e37},
	{0xe5e0, 0x7e32},
	{0xe5e1, 0x7e3a},
	{0xe5e2, 0x7e67},
	{0xe5e3, 0x7e5d},
	{0xe5e4, 0x7e56},
	{0xe5e5, 0x7e5e},
	{0xe5e6, 0x7e59},
	{0xe5e7, 0x7e5a},
	{0xe5e8, 0x7e79},
	{0xe5e9, 0x7e6a},
	{0xe5ea, 0x7e69},
	{0xe5eb, 0x7e7c},
	{0xe5ec, 0x7e7b},
	{0xe5ed, 0x7e83},
	{0xe5ee, 0x7dd5},
	{0xe5ef, 0x7e7d},
	{0xe5f0, 0x8fae},
	{0xe5f1, 0x7e7f},
	{0xe5f2, 0x7e88},
	{0xe5f3, 0x7e89},
	{0xe5f4, 0x7e8c},
	{0xe5f5, 0x7e92},
	{0xe5f6, 0x7e90},
	{0xe5f7, 0x7e93},
	{0xe5f8, 0x7e94},
	{0xe5f9, 0x7e96},
	{0xe5fa, 0x7e8e},
	{0xe5fb, 0x7e9b},
	{0xe5fc, 0x7e9c},
	{0xe5fd, 0x7f38},
	{0xe5fe, 0x7f3a},
	{0xe6a1, 0x7f45},
	{0xe6a2, 0x7f4c},
	{0xe6a3, 0x7f4d},
	{0xe6a4, 0x7f4e},
	{0xe6a5, 0x7f50},
	{0xe6a6, 0x7f51},
	{0xe6a7, 0x7f55},
	{0xe6a8, 0x7f54},
	{0xe6a9, 0x7f58},
	{0xe6aa, 0x7f5f},
	{0xe6ab, 0x7f60},
	{0xe6ac, 0x7f68},
	{0xe6ad, 0x7f69},
	{0xe6ae, 0x7f67},
	{0xe6af, 0x7f78},
	{0xe6b0, 0x7f82},
	{0xe6b1, 0x7f86},
	{0xe6b2, 0x7f83},
	{0xe6b3, 0x7f88},
	{0xe6b4, 0x7f87},
	{0xe6b5, 0x7f8c},
	{0xe6b6, 0x7f94},
	{0xe6b7, 0x7f9e},
	{0xe6b8, 0x7f9d},
	{0xe6b9, 0x7f9a},
	{0xe6ba, 0x7fa3},
	{0xe6bb, 0x7faf},
	{0xe6bc, 0x7fb2},
	{0xe6bd, 0x7fb9},
	{0xe6be, 0x7fae},
	{0xe6bf, 0x7fb6},
	{0xe6c0, 0x7fb8},
	{0xe6c1, 0x8b71},
	{0xe6c2, 0x7fc5},
	{0xe6c3, 0x7fc6},
	{0xe6c4, 0x7fca},
	{0xe6c5, 0x7fd5},
	{0xe6c6, 0x7fd4},
	{0xe6c7, 0x7fe1},
	{0xe6c8, 0x7fe6},
	{0xe6c9, 0x7fe9},
	{0xe6ca, 0x7ff3},
	{0xe6cb, 0x7ff9},
	{0xe6cc, 0x98dc},
	{0xe6cd, 0x8006},
	{0xe6ce, 0x8004},
	{0xe6cf, 0x800b},
	{0xe6d0, 0x8012},
	{0xe6d1, 0x8018},
	{0xe6d2, 0x8019},
	{0xe6d3, 0x801c},
	{0xe6d4, 0x8021},
	{0xe6d5, 0x8028},
	{0xe6d6, 0x803f},
	{0xe6d7, 0x803b},
	{0xe6d8, 0x804a},
	{0xe6d9, 0x8046},
	{0xe6da, 0x8052},
	{0xe6db, 0x8058},
	{0xe6dc, 0x805a},
	{0xe6dd, 0x805f},
	{0xe6de, 0x8062},
	{0xe6df, 0x8068},
	{0xe6e0, 0x8073},
	{0xe6e1, 0x8072},
	{0xe6e2, 0x8070},
	{0xe6e3, 0x8076},
	{0xe6e4, 0x8079},
	{0xe6e5, 0x807d},
	{0xe6e6, 0x807f},
	{0xe6e7, 0x8084},
	{0xe6e8, 0x8086},
	{0xe6e9, 0x8085},
	{0xe6ea, 0x809b},
	{0xe6eb, 0x8093},
	{0xe6ec, 0x809a},
	{0xe6ed, 0x80ad},
	{0xe6ee, 0x5190},
	{0xe6ef, 0x80ac},
	{0xe6f0, 0x80db},
	{0xe6f1, 0x80e5},
	{0xe6f2, 0x80d9},
	{0xe6f3, 0x80dd},
	{0xe6f4, 0x80c4},
	{0xe6f5, 0x80da},
	{0xe6f6, 0x80d6},
	{0xe6f7, 0x8109},
	{0xe6f8, 0x80ef},
	{0xe6f9, 0x80f1},
	{0xe6fa, 0x811b},
	{0xe6fb, 0x8129},
	{0xe6fc, 0x8123},
	{0xe6fd, 0x812f},
	{0xe6fe, 0x814b},
	{0xe7a1, 0x968b},
	{0xe7a2, 0x8146},
	{0xe7a3, 0x813e},
	{0xe7a4, 0x8153},
	{0xe7a5, 0x8151},
	{0xe7a6, 0x80fc},
	{0xe7a7, 0x8171},
	{0xe7a8, 0x816e},
	{0xe7a9, 0x8165},
	{0xe7aa, 0x8166},
	{0xe7ab, 0x8174},
	{0xe7ac, 0x8183},
	{0xe7ad, 0x8188},
	{0xe7ae, 0x818a},
	{0xe7af, 0x8180},
	{0xe7b0, 0x8182},
	{0xe7b1, 0x81a0},
	{0xe7b2, 0x8195},
	{0xe7b3, 0x81a4},
	{0xe7b4, 0x81a3},
	{0xe7b5, 0x815f},
	{0xe7b6, 0x8193},
	{0xe7b7, 0x81a9},
	{0xe7b8, 0x81b0},
	{0xe7b9, 0x81b5},
	{0xe7ba, 0x81be},
	{0xe7bb, 0x81b8},
	{0xe7bc, 0x81bd},
	{0xe7bd, 0x81c0},
	{0xe7be, 0x81c2},
	{0xe7bf, 0x81ba},
	{0xe7c0, 0x81c9},
	{0xe7c1, 0x81cd},
	{0xe7c2, 0x81d1},
	{0xe7c3, 0x81d9},
	{0xe7c4, 0x81d8},
	{0xe7c5, 0x81c8},
	{0xe7c6, 0x81da},
	{0xe7c7, 0x81df},
	{0xe7c8, 0x81e0},
	{0xe7c9, 0x81e7},
	{0xe7ca, 0x81fa},
	{0xe7cb, 0x81fb},
	{0xe7cc, 0x81fe},
	{0xe7cd, 0x8201},
	{0xe7ce, 0x8202},
	{0xe7cf, 0x8205},
	{0xe7d0, 0x8207},
	{0xe7d1, 0x820a},
	{0xe7d2, 0x820d},
	{0xe7d3, 0x8210},
	{0xe7d4, 0x8216},
	{0xe7d5, 0x8229},
	{0xe7d6, 0x822b},
	{0xe7d7, 0x8238},
	{0xe7d8, 0x8233},
	{0xe7d9, 0x8240},
	{0xe7da, 0x8259},
	{0xe7db, 0x8258},
	{0xe7dc, 0x825d},
	{0xe7dd, 0x825a},
	{0xe7de, 0x825f},
	{0xe7df, 0x8264},
	{0xe7e0, 0x8262},
	{0xe7e1, 0x8268},
	{0xe7e2, 0x826a},
	{0xe7e3, 0x826b},
	{0xe7e4, 0x822e},
	{0xe7e5, 0x8271},
	{0xe7e6, 0x8277},
	{0xe7e7, 0x8278},
	{0xe7e8, 0x827e},
	{0xe7e9, 0x828d},
	{0xe7ea, 0x8292},
	{0xe7eb, 0x82ab},
	{0xe7ec, 0x829f},
	{0xe7ed, 0x82bb},
	{0xe7ee, 0x82ac},
	{0xe7ef, 0x82e1},
	{0xe7f0, 0x82e3},
	{0xe7f1, 0x82df},
	{0xe7f2, 0x82d2},
	{0xe7f3, 0x82f4},
	{0xe7f4, 0x82f3},
	{0xe7f5, 0x82fa},
	{0xe7f6, 0x8393},
	{0xe7f7, 0x8303},
	{0xe7f8, 0x82fb},
	{0xe7f9, 0x82f9},
	{0xe7fa, 0x82de},
	{0xe7fb, 0x8306},
	{0xe7fc, 0x82dc},
	{0xe7fd, 0x8309},
	{0xe7fe, 0x82d9},
	{0xe8a1, 0x8335},
	{0xe8a2, 0x8334},
	{0xe8a3, 0x8316},
	{0xe8a4, 0x8332},
	{0xe8a5, 0x8331},
	{0xe8a6, 0x8340},
	{0xe8a7, 0x8339},
	{0xe8a8, 0x8350},
	{0xe8a9, 0x8345},
	{0xe8aa, 0x832f},
	{0xe8ab, 0x832b},
	{0xe8ac, 0x8317},
	{0xe8ad, 0x8318},
	{0xe8ae, 0x8385},
	{0xe8af, 0x839a},
	{0xe8b0, 0x83aa},
	{0xe8b1, 0x839f},
	{0xe8b2, 0x83a2},
	{0xe8b3, 0x8396},
	{0xe8b4, 0x8323},
	{0xe8b5, 0x838e},
	{0xe8b6, 0x8387},
	{0xe8b7, 0x838a},
	{0xe8b8, 0x837c},
	{0xe8b9, 0x83b5},
	{0xe8ba, 0x8373},
	{0xe8bb, 0x8375},
	{0xe8bc, 0x83a0},
	{0xe8bd, 0x8389},
	{0xe8be, 0x83a8},
	{0xe8bf, 0x83f4},
	{0xe8c0, 0x8413},
	{0xe8c1, 0x83eb},
	{0xe8c2, 0x83ce},
	{0xe8c3, 0x83fd},
	{0xe8c4, 0x8403},
	{0xe8c5, 0x83d8},
	{0xe8c6, 0x840b},
	{0xe8c7, 0x83c1},
	{0xe8c8, 0x83f7},
	{0xe8c9, 0x8407},
	{0xe8ca, 0x83e0},
	{0xe8cb, 0x83f2},
	{0xe8cc, 0x840d},
	{0xe8cd, 0x8422},
	{0xe8ce, 0x8420},
	{0xe8cf, 0x83bd},
	{0xe8d0, 0x8438},
	{0xe8d1, 0x8506},
	{0xe8d2, 0x83fb},
	{0xe8d3, 0x846d},
	{0xe8d4, 0x842a},
	{0xe8d5, 0x843c},
	{0xe8d6, 0x855a},
	{0xe8d7, 0x8484},
	{0xe8d8, 0x8477},
	{0xe8d9, 0x846b},
	{0xe8da, 0x84ad},
	{0xe8db, 0x846e},
	{0xe8dc, 0x8482},
	{0xe8dd, 0x8469},
	{0xe8de, 0x8446},
	{0xe8df, 0x842c},
	{0xe8e0, 0x846f},
	{0xe8e1, 0x8479},
	{0xe8e2, 0x8435},
	{0xe8e3, 0x84ca},
	{0xe8e4, 0x8462},
	{0xe8e5, 0x84b9},
	{0xe8e6, 0x84bf},
	{0xe8e7, 0x849f},
	{0xe8e8, 0x84d9},
	{0xe8e9, 0x84cd},
	{0xe8ea, 0x84bb},
	{0xe8eb, 0x84da},
	{0xe8ec, 0x84d0},
	{0xe8ed, 0x84c1},
	{0xe8ee, 0x84c6},
	{0xe8ef, 0x84d6},
	{0xe8f0, 0x84a1},
	{0xe8f1, 0x8521},
	{0xe8f2, 0x84ff},
	{0xe8f3, 0x84f4},
	{0xe8f4, 0x8517},
	{0xe8f5, 0x8518},
	{0xe8f6, 0x852c},
	{0xe8f7, 0x851f},
	{0xe8f8, 0x8515},
	{0xe8f9, 0x8514},
	{0xe8fa, 0x84fc},
	{0xe8fb, 0x8540},
	{0xe8fc, 0x8563},
	{0xe8fd, 0x8558},
	{0xe8fe, 0x8548},
	{0xe9a1, 0x8541},
	{0xe9a2, 0x8602},
	{0xe9a3, 0x854b},
	{0xe9a4, 0x8555},
	{0xe9a5, 0x8580},
	{0xe9a6, 0x85a4},
	{0xe9a7, 0x8588},
	{0xe9a8, 0x8591},
	{0xe9a9, 0x858a},
	{0xe9aa, 0x85a8},
	{0xe9ab, 0x856d},
	{0xe9ac, 0x8594},
	{0xe9ad, 0x859b},
	{0xe9ae, 0x85ea},
	{0xe9af, 0x8587},
	{0xe9b0, 0x859c},
	{0xe9b1, 0x8577},
	{0xe9b2, 0x857e},
	{0xe9b3, 0x8590},
	{0xe9b4, 0x85c9},
	{0xe9b5, 0x85ba},
	{0xe9b6, 0x85cf},
	{0xe9b7, 0x85b9},
	{0xe9b8, 0x85d0},
	{0xe9b9, 0x85d5},
	{0xe9ba, 0x85dd},
	{0xe9bb, 0x85e5},
	{0xe9bc, 0x85dc},
	{0xe9bd, 0x85f9},
	{0xe9be, 0x860a},
	{0xe9bf, 0x8613},
	{0xe9c0, 0x860b},
	{0xe9c1, 0x85fe},
	{0xe9c2, 0x85fa},
	{0xe9c3, 0x8606},
	{0xe9c4, 0x8622},
	{0xe9c5, 0x861a},
	{0xe9c6, 0x8630},
	{0xe9c7, 0x863f},
	{0xe9c8, 0x864d},
	{0xe9c9, 0x4e55},
	{0xe9ca, 0x8654},
	{0xe9cb, 0x865f},
	{0xe9cc, 0x8667},
	{0xe9cd, 0x8671},
	{0xe9ce, 0x8693},
	{0xe9cf, 0x86a3},
	{0xe9d0, 0x86a9},
	{0xe9d1, 0x86aa},
	{0xe9d2, 0x868b},
	{0xe9d3, 0x868c},
	{0xe9d4, 0x86b6},
	{0xe9d5, 0x86af},
	{0xe9d6, 0x86c4},
	{0xe9d7, 0x86c6},
	{0xe9d8, 0x86b0},
	{0xe9d9, 0x86c9},
	{0xe9da, 0x8823},
	{0xe9db, 0x86ab},
	{0xe9dc, 0x86d4},
	{0xe9dd, 0x86de},
	{0xe9de, 0x86e9},
	{0xe9df, 0x86ec},
	{0xe9e0, 0x86df},
	{0xe9e1, 0x86db},
	{0xe9e2, 0x86ef},
	{0xe9e3, 0x8712},
	{0xe9e4, 0x8706},
	{0xe9e5, 0x8708},
	{0xe9e6, 0x8700},
	{0xe9e7, 0x8703},
	{0xe9e8, 0x86fb},
	{0xe9e9, 0x8711},
	{0xe9ea, 0x8709},
	{0xe9eb, 0x870d},
	{0xe9ec, 0x86f9},
	{0xe9ed, 0x870a},
	{0xe9ee, 0x8734},
	{0xe9ef, 0x873f},
	{0xe9f0, 0x8737},
	{0xe9f1, 0x873b},
	{0xe9f2, 0x8725},
	{0xe9f3, 0x8729},
	{0xe9f4, 0x871a},
	{0xe9f5, 0x8760},
	{0xe9f6, 0x875f},
	{0xe9f7, 0x8778},
	{0xe9f8, 0x874c},
	{0xe9f9, 0x874e},
	{0xe9fa, 0x8774},
	{0xe9fb, 0x8757},
	{0xe9fc, 0x8768},
	{0xe9fd, 0x876e},
	{0xe9fe, 0x8759},
	{0xeaa1, 0x8753},
	{0xeaa2, 0x8763},
	{0xeaa3, 0x876a},
	{0xeaa4, 0x8805},
	{0xeaa5, 0x87a2},
	{0xeaa6, 0x879f},
	{0xeaa7, 0x8782},
	{0xeaa8, 0x87af},
	{0xeaa9, 0x87cb},
	{0xeaaa, 0x87bd},
	{0xeaab, 0x87c0},
	{0xeaac, 0x87d0},
	{0xeaad, 0x96d6},
	{0xeaae, 0x87ab},
	{0xeaaf, 0x87c4},
	{0xeab0, 0x87b3},
	{0xeab1, 0x87c7},
	{0xeab2, 0x87c6},
	{0xeab3, 0x87bb},
	{0xeab4, 0x87ef},
	{0xeab5, 0x87f2},
	{0xeab6, 0x87e0},
	{0xeab7, 0x880f},
	{0xeab8, 0x880d},
	{0xeab9, 0x87fe},
	{0xeaba, 0x87f6},
	{0xeabb, 0x87f7},
	{0xeabc, 0x880e},
	{0xeabd, 0x87d2},
	{0xeabe, 0x8811},
	{0xeabf, 0x8816},
	{0xeac0, 0x8815},
	{0xeac1, 0x8822},
	{0xeac2, 0x8821},
	{0xeac3, 0x8831},
	{0xeac4, 0x8836},
	{0xeac5, 0x8839},
	{0xeac6, 0x8827},
	{0xeac7, 0x883b},
	{0xeac8, 0x8844},
	{0xeac9, 0x8842},
	{0xeaca, 0x8852},
	{0xeacb, 0x8859},
	{0xeacc, 0x885e},
	{0xeacd, 0x8862},
	{0xeace, 0x886b},
	{0xeacf, 0x8881},
	{0xead0, 0x887e},
	{0xead1, 0x889e},
	{0xead2, 0x8875},
	{0xead3, 0x887d},
	{0xead4, 0x88b5},
	{0xead5, 0x8872},
	{0xead6, 0x8882},
	{0xead7, 0x8897},
	{0xead8, 0x8892},
	{0xead9, 0x88ae},
	{0xeada, 0x8899},
	{0xeadb, 0x88a2},
	{0xeadc, 0x888d},
	{0xeadd, 0x88a4},
	{0xeade, 0x88b0},
	{0xeadf, 0x88bf},
	{0xeae0, 0x88b1},
	{0xeae1, 0x88c3},
	{0xeae2, 0x88c4},
	{0xeae3, 0x88d4},
	{0xeae4, 0x88d8},
	{0xeae5, 0x88d9},
	{0xeae6, 0x88dd},
	{0xeae7, 0x88f9},
	{0xeae8, 0x8902},
	{0xeae9, 0x88fc},
	{0xeaea, 0x88f4},
	{0xeaeb, 0x88e8},
	{0xeaec, 0x88f2},
	{0xeaed, 0x8904},
	{0xeaee, 0x890c},
	{0xeaef, 0x890a},
	{0xeaf0, 0x8913},
	{0xeaf1, 0x8943},
	{0xeaf2, 0x891e},
	{0xeaf3, 0x8925},
	{0xeaf4, 0x892a},
	{0xeaf5, 0x892b},
	{0xeaf6, 0x8941},
	{0xeaf7, 0x8944},
	{0xeaf8, 0x893b},
	{0xeaf9, 0x8936},
	{0xeafa, 0x8938},
	{0xeafb, 0x894c},
	{0xeafc, 0x891d},
	{0xeafd, 0x8960},
	{0xeafe, 0x895e},
	{0xeba1, 0x8966},
	{0xeba2, 0x8964},
	{0xeba3, 0x896d},
	{0xeba4, 0x896a},
	{0xeba5, 0x896f},
	{0xeba6, 0x8974},
	{0xeba7, 0x8977},
	{0xeba8, 0x897e},
	{0xeba9, 0x8983},
	{0xebaa, 0x8988},
	{0xebab, 0x898a},
	{0xebac, 0x8993},
	{0xebad, 0x8998},
	{0xebae, 0x89a1},
	{0xebaf, 0x89a9},
	{0xebb0, 0x89a6},
	{0xebb1, 0x89ac},
	{0xebb2, 0x89af},
	{0xebb3, 0x89b2},
	{0xebb4, 0x89ba},
	{0xebb5, 0x89bd},
	{0xebb6, 0x89bf},
	{0xebb7, 0x89c0},
	{0xebb8, 0x89da},
	{0xebb9, 0x89dc},
	{0xebba, 0x89dd},
	{0xebbb, 0x89e7},
	{0xebbc, 0x89f4},
	{0xebbd, 0x89f8},
	{0xebbe, 0x8a03},
	{0xebbf, 0x8a16},
	{0xebc0, 0x8a10},
	{0xebc1, 0x8a0c},
	{0xebc2, 0x8a1b},
	{0xebc3, 0x8a1d},
	{0xebc4, 0x8a25},
	{0xebc5, 0x8a36},
	{0xebc6, 0x8a41},
	{0xebc7, 0x8a5b},
	{0xebc8, 0x8a52},
	{0xebc9, 0x8a46},
	{0xebca, 0x8a48},
	{0xebcb, 0x8a7c},
	{0xebcc, 0x8a6d},
	{0xebcd, 0x8a6c},
	{0xebce, 0x8a62},
	{0xebcf, 0x8a85},
	{0xebd0, 0x8a82},
	{0xebd1, 0x8a84},
	{0xebd2, 0x8aa8},
	{0xebd3, 0x8aa1},
	{0xebd4, 0x8a91},
	{0xebd5, 0x8aa5},
	{0xebd6, 0x8aa6},
	{0xebd7, 0x8a9a},
	{0xebd8, 0x8aa3},
	{0xebd9, 0x8ac4},
	{0xebda, 0x8acd},
	{0xebdb, 0x8ac2},
	{0xebdc, 0x8ada},
	{0xebdd, 0x8aeb},
	{0xebde, 0x8af3},
	{0xebdf, 0x8ae7},
	{0xebe0, 0x8ae4},
	{0xebe1, 0x8af1},
	{0xebe2, 0x8b14},
	{0xebe3, 0x8ae0},
	{0xebe4, 0x8ae2},
	{0xebe5, 0x8af7},
	{0xebe6, 0x8ade},
	{0xebe7, 0x8adb},
	{0xebe8, 0x8b0c},
	{0xebe9, 0x8b07},
	{0xebea, 0x8b1a},
	{0xebeb, 0x8ae1},
	{0xebec, 0x8b16},
	{0xebed, 0x8b10},
	{0xebee, 0x8b17},
	{0xebef, 0x8b20},
	{0xebf0, 0x8b33},
	{0xebf1, 0x97ab},
	{0xebf2, 0x8b26},
	{0xebf3, 0x8b2b},
	{0xebf4, 0x8b3e},
	{0xebf5, 0x8b28},
	{0xebf6, 0x8b41},
	{0xebf7, 0x8b4c},
	{0xebf8, 0x8b4f},
	{0xebf9, 0x8b4e},
	{0xebfa, 0x8b49},
	{0xebfb, 0x8b56},
	{0xebfc, 0x8b5b},
	{0xebfd, 0x8b5a},
	{0xebfe, 0x8b6b},
	{0xeca1, 0x8b5f},
	{0xeca2, 0x8b6c},
	{0xeca3, 0x8b6f},
	{0xeca4, 0x8b74},
	{0xeca5, 0x8b7d},
	{0xeca6, 0x8b80},
	{0xeca7, 0x8b8c},
	{0xeca8, 0x8b8e},
	{0xeca9, 0x8b92},
	{0xecaa, 0x8b93},
	{0xecab, 0x8b96},
	{0xecac, 0x8b99},
	{0xecad, 0x8b9a},
	{0xecae, 0x8c3a},
	{0xecaf, 0x8c41},
	{0xecb0, 0x8c3f},
	{0xecb1, 0x8c48},
	{0xecb2, 0x8c4c},
	{0xecb3, 0x8c4e},
	{0xecb4, 0x8c50},
	{0xecb5, 0x8c55},
	{0xecb6, 0x8c62},
	{0xecb7, 0x8c6c},
	{0xecb8, 0x8c78},
	{0xecb9, 0x8c7a},
	{0xecba, 0x8c82},
	{0xecbb, 0x8c89},
	{0xecbc, 0x8c85},
	{0xecbd, 0x8c8a},
	{0xecbe, 0x8c8d},
	{0xecbf, 0x8c8e},
	{0xecc0, 0x8c94},
	{0xecc1, 0x8c7c},
	{0xecc2, 0x8c98},
	{0xecc3, 0x621d},
	{0xecc4, 0x8cad},
	{0xecc5, 0x8caa},
	{0xecc6, 0x8cbd},
	{0xecc7, 0x8cb2},
	{0xecc8, 0x8cb3},
	{0xecc9, 0x8cae},
	{0xecca, 0x8cb6},
	{0xeccb, 0x8cc8},
	{0xeccc, 0x8cc1},
	{0xeccd, 0x8ce4},
	{0xecce, 0x8ce3},
	{0xeccf, 0x8cda},
	{0xecd0, 0x8cfd},
	{0xecd1, 0x8cfa},
	{0xecd2, 0x8cfb},
	{0xecd3, 0x8d04},
	{0xecd4, 0x8d05},
	{0xecd5, 0x8d0a},
	{0xecd6, 0x8d07},
	{0xecd7, 0x8d0f},
	{0xecd8, 0x8d0d},
	{0xecd9, 0x8d10},
	{0xecda, 0x9f4e},
	{0xecdb, 0x8d13},
	{0xecdc, 0x8ccd},
	{0xecdd, 0x8d14},
	{0xecde, 0x8d16},
	{0xecdf, 0x8d67},
	{0xece0, 0x8d6d},
	{0xece1, 0x8d71},
	{0xece2, 0x8d73},
	{0xece3, 0x8d81},
	{0xece4, 0x8d99},
	{0xece5, 0x8dc2},
	{0xece6, 0x8dbe},
	{0xece7, 0x8dba},
	{0xece8, 0x8dcf},
	{0xece9, 0x8dda},
	{0xecea, 0x8dd6},
	{0xeceb, 0x8dcc},
	{0xecec, 0x8ddb},
	{0xeced, 0x8dcb},
	{0xecee, 0x8dea},
	{0xecef, 0x8deb},
	{0xecf0, 0x8ddf},
	{0xecf1, 0x8de3},
	{0xecf2, 0x8dfc},
	{0xecf3, 0x8e08},
	{0xecf4, 0x8e09},
	{0xecf5, 0x8dff},
	{0xecf6, 0x8e1d},
	{0xecf7, 0x8e1e},
	{0xecf8, 0x8e10},
	{0xecf9, 0x8e1f},
	{0xecfa, 0x8e42},
	{0xecfb, 0x8e35},
	{0xecfc, 0x8e30},
	{0xecfd, 0x8e34},
	{0xecfe, 0x8e4a},
	{0xeda1, 0x8e47},
	{0xeda2, 0x8e49},
	{0xeda3, 0x8e4c},
	{0xeda4, 0x8e50},
	{0xeda5, 0x8e48},
	{0xeda6, 0x8e59},
	{0xeda7, 0x8e64},
	{0xeda8, 0x8e60},
	{0xeda9, 0x8e2a},
	{0xedaa, 0x8e63},
	{0xedab, 0x8e55},
	{0xedac, 0x8e76},
	{0xedad, 0x8e72},
	{0xedae, 0x8e7c},
	{0xedaf, 0x8e81},
	{0xedb0, 0x8e87},
	{0xedb1, 0x8e85},
	{0xedb2, 0x8e84},
	{0xedb3, 0x8e8b},
	{0xedb4, 0x8e8a},
	{0xedb5, 0x8e93},
	{0xedb6, 0x8e91},
	{0xedb7, 0x8e94},
	{0xedb8, 0x8e99},
	{0xedb9, 0x8eaa},
	{0xedba, 0x8ea1},
	{0xedbb, 0x8eac},
	{0xedbc, 0x8eb0},
	{0xedbd, 0x8ec6},
	{0xedbe, 0x8eb1},
	{0xedbf, 0x8ebe},
	{0xedc0, 0x8ec5},
	{0xedc1, 0x8ec8},
	{0xedc2, 0x8ecb},
	{0xedc3, 0x8edb},
	{0xedc4, 0x8ee3},
	{0xedc5, 0x8efc},
	{0xedc6, 0x8efb},
	{0xedc7, 0x8eeb},
	{0xedc8, 0x8efe},
	{0xedc9, 0x8f0a},
	{0xedca, 0x8f05},
	{0xedcb, 0x8f15},
	{0xedcc, 0x8f12},
	{0xedcd, 0x8f19},
	{0xedce, 0x8f13},
	{0xedcf, 0x8f1c},
	{0xedd0, 0x8f1f},
	{0xedd1, 0x8f1b},
	{0xedd2, 0x8f0c},
	{0xedd3, 0x8f26},
	{0xedd4, 0x8f33},
	{0xedd5, 0x8f3b},
	{0xedd6, 0x8f39},
	{0xedd7, 0x8f45},
	{0xedd8, 0x8f42},
	{0xedd9, 0x8f3e},
	{0xedda, 0x8f4c},
	{0xeddb, 0x8f49},
	{0xeddc, 0x8f46},
	{0xeddd, 0x8f4e},
	{0xedde, 0x8f57},
	{0xeddf, 0x8f5c},
	{0xede0, 0x8f62},
	{0xede1, 0x8f63},
	{0xede2, 0x8f64},
	{0xede3, 0x8f9c},
	{0xede4, 0x8f9f},
	{0xede5, 0x8fa3},
	{0xede6, 0x8fad},
	{0xede7, 0x8faf},
	{0xede8, 0x8fb7},
	{0xede9, 0x8fda},
	{0xedea, 0x8fe5},
	{0xedeb, 0x8fe2},
	{0xedec, 0x8fea},
	{0xeded, 0x8fef},
	{0xedee, 0x9087},
	{0xedef, 0x8ff4},
	{0xedf0, 0x9005},
	{0xedf1, 0x8ff9},
	{0xedf2, 0x8ffa},
	{0xedf3, 0x9011},
	{0xedf4, 0x9015},
	{0xedf5, 0x9021},
	{0xedf6, 0x900d},
	{0xedf7, 0x901e},
	{0xedf8, 0x9016},
	{0xedf9, 0x900b},
	{0xedfa, 0x9027},
	{0xedfb, 0x9036},
	{0xedfc, 0x9035},
	{0xedfd, 0x9039},
	{0xedfe, 0x8ff8},
	{0xeea1, 0x904f},
	{0xeea2, 0x9050},
	{0xeea3, 0x9051},
	{0xeea4, 0x9052},
	{0xeea5, 0x900e},
	{0xeea6, 0x9049},
	{0xeea7, 0x903e},
	{0xeea8, 0x9056},
	{0xeea9, 0x9058},
	{0xeeaa, 0x905e},
	{0xeeab, 0x9068},
	{0xeeac, 0x906f},
	{0xeead, 0x9076},
	{0xeeae, 0x96a8},
	{0xeeaf, 0x9072},
	{0xeeb0, 0x9082},
	{0xeeb1, 0x907d},
	{0xeeb2, 0x9081},
	{0xeeb3, 0x9080},
	{0xeeb4, 0x908a},
	{0xeeb5, 0x9089},
	{0xeeb6, 0x908f},
	{0xeeb7, 0x90a8},
	{0xeeb8, 0x90af},
	{0xeeb9, 0x90b1},
	{0xeeba, 0x90b5},
	{0xeebb, 0x90e2},
	{0xeebc, 0x90e4},
	{0xeebd, 0x6248},
	{0xeebe, 0x90db},
	{0xeebf, 0x9102},
	{0xeec0, 0x9112},
	{0xeec1, 0x9119},
	{0xeec2, 0x9132},
	{0xeec3, 0x9130},
	{0xeec4, 0x914a},
	{0xeec5, 0x9156},
	{0xeec6, 0x9158},
	{0xeec7, 0x9163},
	{0xeec8, 0x9165},
	{0xeec9, 0x9169},
	{0xeeca, 0x9173},
	{0xeecb, 0x9172},
	{0xeecc, 0x918b},
	{0xeecd, 0x9189},
	{0xeece, 0x9182},
	{0xeecf, 0x91a2},
	{0xeed0, 0x91ab},
	{0xeed1, 0x91af},
	{0xeed2, 0x91aa},
	{0xeed3, 0x91b5},
	{0xeed4, 0x91b4},
	{0xeed5, 0x91ba},
	{0xeed6, 0x91c0},
	{0xeed7, 0x91c1},
	{0xeed8, 0x91c9},
	{0xeed9, 0x91cb},
	{0xeeda, 0x91d0},
	{0xeedb, 0x91d6},
	{0xeedc, 0x91df},
	{0xeedd, 0x91e1},
	{0xeede, 0x91db},
	{0xeedf, 0x91fc},
	{0xeee0, 0x91f5},
	{0xeee1, 0x91f6},
	{0xeee2, 0x921e},
	{0xeee3, 0x91ff},
	{0xeee4, 0x9214},
	{0xeee5, 0x922c},
	{0xeee6, 0x9215},
	{0xeee7, 0x9211},
	{0xeee8, 0x925e},
	{0xeee9, 0x9257},
	{0xeeea, 0x9245},
	{0xeeeb, 0x9249},
	{0xeeec, 0x9264},
	{0xeeed, 0x9248},
	{0xeeee, 0x9295},
	{0xeeef, 0x923f},
	{0xeef0, 0x924b},
	{0xeef1, 0x9250},
	{0xeef2, 0x929c},
	{0xeef3, 0x9296},
	{0xeef4, 0x9293},
	{0xeef5, 0x929b},
	{0xeef6, 0x925a},
	{0xeef7, 0x92cf},
	{0xeef8, 0x92b9},
	{0xeef9, 0x92b7},
	{0xeefa, 0x92e9},
	{0xeefb, 0x930f},
	{0xeefc, 0x92fa},
	{0xeefd, 0x9344},
	{0xeefe, 0x932e},
	{0xefa1, 0x9319},
	{0xefa2, 0x9322},
	{0xefa3, 0x931a},
	{0xefa4, 0x9323},
	{0xefa5, 0x933a},
	{0xefa6, 0x9335},
	{0xefa7, 0x933b},
	{0xefa8, 0x935c},
	{0xefa9, 0x9360},
	{0xefaa, 0x937c},
	{0xefab, 0x936e},
	{0xefac, 0x9356},
	{0xefad, 0x93b0},
	{0xefae, 0x93ac},
	{0xefaf, 0x93ad},
	{0xefb0, 0x9394},
	{0xefb1, 0x93b9},
	{0xefb2, 0x93d6},
	{0xefb3, 0x93d7},
	{0xefb4, 0x93e8},
	{0xefb5, 0x93e5},
	{0xefb6, 0x93d8},
	{0xefb7, 0x93c3},
	{0xefb8, 0x93dd},
	{0xefb9, 0x93d0},
	{0xefba, 0x93c8},
	{0xefbb, 0x93e4},
	{0xefbc, 0x941a},
	{0xefbd, 0x9414},
	{0xefbe, 0x9413},
	{0xefbf, 0x9403},
	{0xefc0, 0x9407},
	{0xefc1, 0x9410},
	{0xefc2, 0x9436},
	{0xefc3, 0x942b},
	{0xefc4, 0x9435},
	{0xefc5, 0x9421},
	{0xefc6, 0x943a},
	{0xefc7, 0x9441},
	{0xefc8, 0x9452},
	{0xefc9, 0x9444},
	{0xefca, 0x945b},
	{0xefcb, 0x9460},
	{0xefcc, 0x9462},
	{0xefcd, 0x945e},
	{0xefce, 0x946a},
	{0xefcf, 0x9229},
	{0xefd0, 0x9470},
	{0xefd1, 0x9475},
	{0xefd2, 0x9477},
	{0xefd3, 0x947d},
	{0xefd4, 0x945a},
	{0xefd5, 0x947c},
	{0xefd6, 0x947e},
	{0xefd7, 0x9481},
	{0xefd8, 0x947f},
	{0xefd9, 0x9582},
	{0xefda, 0x9587},
	{0xefdb, 0x958a},
	{0xefdc, 0x9594},
	{0xefdd, 0x9596},
	{0xefde, 0x9598},
	{0xefdf, 0x9599},
	{0xefe0, 0x95a0},
	{0xefe1, 0x95a8},
	{0xefe2, 0x95a7},
	{0xefe3, 0x95ad},
	{0xefe4, 0x95bc},
	{0xefe5, 0x95bb},
	{0xefe6, 0x95b9},
	{0xefe7, 0x95be},
	{0xefe8, 0x95ca},
	{0xefe9, 0x6ff6},
	{0xefea, 0x95c3},
	{0xefeb, 0x95cd},
	{0xefec, 0x95cc},
	{0xefed, 0x95d5},
	{0xefee, 0x95d4},
	{0xefef, 0x95d6},
	{0xeff0, 0x95dc},
	{0xeff1, 0x95e1},
	{0xeff2, 0x95e5},
	{0xeff3, 0x95e2},
	{0xeff4, 0x9621},
	{0xeff5, 0x9628},
	{0xeff6, 0x962e},
	{0xeff7, 0x962f},
	{0xeff8, 0x9642},
	{0xeff9, 0x964c},
	{0xeffa, 0x964f},
	{0xeffb, 0x964b},
	{0xeffc, 0x9677},
	{0xeffd, 0x965c},
	{0xeffe, 0x965e},
	{0xf0a1, 0x965d},
	{0xf0a2, 0x965f},
	{0xf0a3, 0x9666},
	{0xf0a4, 0x9672},
	{0xf0a5, 0x966c},
	{0xf0a6, 0x968d},
	{0xf0a7, 0x9698},
	{0xf0a8, 0x9695},
	{0xf0a9, 0x9697},
	{0xf0aa, 0x96aa},
	{0xf0ab, 0x96a7},
	{0xf0ac, 0x96b1},
	{0xf0ad, 0x96b2},
	{0xf0ae, 0x96b0},
	{0xf0af, 0x96b4},
	{0xf0b0, 0x96b6},
	{0xf0b1, 0x96b8},
	{0xf0b2, 0x96b9},
	{0xf0b3, 0x96ce},
	{0xf0b4, 0x96cb},
	{0xf0b5, 0x96c9},
	{0xf0b6, 0x96cd},
	{0xf0b7, 0x894d},
	{0xf0b8, 0x96dc},
	{0xf0b9, 0x970d},
	{0xf0ba, 0x96d5},
	{0xf0bb, 0x96f9},
	{0xf0bc, 0x9704},
	{0xf0bd, 0x9706},
	{0xf0be, 0x9708},
	{0xf0bf, 0x9713},
	{0xf0c0, 0x970e},
	{0xf0c1, 0x9711},
	{0xf0c2, 0x970f},
	{0xf0c3, 0x9716},
	{0xf0c4, 0x9719},
	{0xf0c5, 0x9724},
	{0xf0c6, 0x972a},
	{0xf0c7, 0x9730},
	{0xf0c8, 0x9739},
	{0xf0c9, 0x973d},
	{0xf0ca, 0x973e},
	{0xf0cb, 0x9744},
	{0xf0cc, 0x9746},
	{0xf0cd, 0x9748},
	{0xf0ce, 0x9742},
	{0xf0cf, 0x9749},
	{0xf0d0, 0x975c},
	{0xf0d1, 0x9760},
	{0xf0d2, 0x9764},
	{0xf0d3, 0x9766},
	{0xf0d4, 0x9768},
	{0xf0d5, 0x52d2},
	{0xf0d6, 0x976b},
	{0xf0d7, 0x9771},
	{0xf0d8, 0x9779},
	{0xf0d9, 0x9785},
	{0xf0da, 0x977c},
	{0xf0db, 0x9781},
	{0xf0dc, 0x977a},
	{0xf0dd, 0x9786},
	{0xf0de, 0x978b},
	{0xf0df, 0x978f},
	{0xf0e0, 0x9790},
	{0xf0e1, 0x979c},
	{0xf0e2, 0x97a8},
	{0xf0e3, 0x97a6},
	{0xf0e4, 0x97a3},
	{0xf0e5, 0x97b3},
	{0xf0e6, 0x97b4},
	{0xf0e7, 0x97c3},
	{0xf0e8, 0x97c6},
	{0xf0e9, 0x97c8},
	{0xf0ea, 0x97cb},
	{0xf0eb, 0x97dc},
	{0xf0ec, 0x97ed},
	{0xf0ed, 0x9f4f},
	{0xf0ee, 0x97f2},
	{0xf0ef, 0x7adf},
	{0xf0f0, 0x97f6},
	{0xf0f1, 0x97f5},
	{0xf0f2, 0x980f},
	{0xf0f3, 0x980c},
	{0xf0f4, 0x9838},
	{0xf0f5, 0x9824},
	{0xf0f6, 0x9821},
	{0xf0f7, 0x9837},
	{0xf0f8, 0x983d},
	{0xf0f9, 0x9846},
	{0xf0fa, 0x984f},
	{0xf0fb, 0x984b},
	{0xf0fc, 0x986b},
	{0xf0fd, 0x986f},
	{0xf0fe, 0x9870},
	{0xf1a1, 0x9871},
	{0xf1a2, 0x9874},
	{0xf1a3, 0x9873},
	{0xf1a4, 0x98aa},
	{0xf1a5, 0x98af},
	{0xf1a6, 0x98b1},
	{0xf1a7, 0x98b6},
	{0xf1a8, 0x98c4},
	{0xf1a9, 0x98c3},
	{0xf1aa, 0x98c6},
	{0xf1ab, 0x98e9},
	{0xf1ac, 0x98eb},
	{0xf1ad, 0x9903},
	{0xf1ae, 0x9909},
	{0xf1af, 0x9912},
	{0xf1b0, 0x9914},
	{0xf1b1, 0x9918},
	{0xf1b2, 0x9921},
	{0xf1b3, 0x991d},
	{0xf1b4, 0x991e},
	{0xf1b5, 0x9924},
	{0xf1b6, 0x9920},
	{0xf1b7, 0x992c},
	{0xf1b8, 0x992e},
	{0xf1b9, 0x993d},
	{0xf1ba, 0x993e},
	{0xf1bb, 0x9942},
	{0xf1bc, 0x9949},
	{0xf1bd, 0x9945},
	{0xf1be, 0x9950},
	{0xf1bf, 0x994b},
	{0xf1c0, 0x9951},
	{0xf1c1, 0x9952},
	{0xf1c2, 0x994c},
	{0xf1c3, 0x9955},
	{0xf1c4, 0x9997},
	{0xf1c5, 0x9998},
	{0xf1c6, 0x99a5},
	{0xf1c7, 0x99ad},
	{0xf1c8, 0x99ae},
	{0xf1c9, 0x99bc},
	{0xf1ca, 0x99df},
	{0xf1cb, 0x99db},
	{0xf1cc, 0x99dd},
	{0xf1cd, 0x99d8},
	{0xf1ce, 0x99d1},
	{0xf1cf, 0x99ed},
	{0xf1d0, 0x99ee},
	{0xf1d1, 0x99f1},
	{0xf1d2, 0x99f2},
	{0xf1d3, 0x99fb},
	{0xf1d4, 0x99f8},
	{0xf1d5, 0x9a01},
	{0xf1d6, 0x9a0f},
	{0xf1d7, 0x9a05},
	{0xf1d8, 0x99e2},
	{0xf1d9, 0x9a19},
	{0xf1da, 0x9a2b},
	{0xf1db, 0x9a37},
	{0xf1dc, 0x9a45},
	{0xf1dd, 0x9a42},
	{0xf1de, 0x9a40},
	{0xf1df, 0x9a43},
	{0xf1e0, 0x9a3e},
	{0xf1e1, 0x9a55},
	{0xf1e2, 0x9a4d},
	{0xf1e3, 0x9a5b},
	{0xf1e4, 0x9a57},
	{0xf1e5, 0x9a5f},
	{0xf1e6, 0x9a62},
	{0xf1e7, 0x9a65},
	{0xf1e8, 0x9a64},
	{0xf1e9, 0x9a69},
	{0xf1ea, 0x9a6b},
	{0xf1eb, 0x9a6a},
	{0xf1ec, 0x9aad},
	{0xf1ed, 0x9ab0},
	{0xf1ee, 0x9abc},
	{0xf1ef, 0x9ac0},
	{0xf1f0, 0x9acf},
	{0xf1f1, 0x9ad1},
	{0xf1f2, 0x9ad3},
	{0xf1f3, 0x9ad4},
	{0xf1f4, 0x9ade},
	{0xf1f5, 0x9adf},
	{0xf1f6, 0x9ae2},
	{0xf1f7, 0x9ae3},
	{0xf1f8, 0x9ae6},
	{0xf1f9, 0x9aef},
	{0xf1fa, 0x9aeb},
	{0xf1fb, 0x9aee},
	{0xf1fc, 0x9af4},
	{0xf1fd, 0x9af1},
	{0xf1fe, 0x9af7},
	{0xf2a1, 0x9afb},
	{0xf2a2, 0x9b06},
	{0xf2a3, 0x9b18},
	{0xf2a4, 0x9b1a},
	{0xf2a5, 0x9b1f},
	{0xf2a6, 0x9b22},
	{0xf2a7, 0x9b23},
	{0xf2a8, 0x9b25},
	{0xf2a9, 0x9b27},
	{0xf2aa, 0x9b28},
	{0xf2ab, 0x9b29},
	{0xf2ac, 0x9b2a},
	{0xf2ad, 0x9b2e},
	{0xf2ae, 0x9b2f},
	{0xf2af, 0x9b32},
	{0xf2b0, 0x9b44},
	{0xf2b1, 0x9b43},
	{0xf2b2, 0x9b4f},
	{0xf2b3, 0x9b4d},
	{0xf2b4, 0x9b4e},
	{0xf2b5, 0x9b51},
	{0xf2b6, 0x9b58},
	{0xf2b7, 0x9b74},
	{0xf2b8, 0x9b93},
	{0xf2b9, 0x9b83},
	{0xf2ba, 0x9b91},
	{0xf2bb, 0x9b96},
	{0xf2bc, 0x9b97},
	{0xf2bd, 0x9b9f},
	{0xf2be, 0x9ba0},
	{0xf2bf, 0x9ba8},
	{0xf2c0, 0x9bb4},
	{0xf2c1, 0x9bc0},
	{0xf2c2, 0x9bca},
	{0xf2c3, 0x9bb9},
	{0xf2c4, 0x9bc6},
	{0xf2c5, 0x9bcf},
	{0xf2c6, 0x9bd1},
	{0xf2c7, 0x9bd2},
	{0xf2c8, 0x9be3},
	{0xf2c9, 0x9be2},
	{0xf2ca, 0x9be4},
	{0xf2cb, 0x9bd4},
	{0xf2cc, 0x9be1},
	{0xf2cd, 0x9c3a},
	{0xf2ce, 0x9bf2},
	{0xf2cf, 0x9bf1},
	{0xf2d0, 0x9bf0},
	{0xf2d1, 0x9c15},
	{0xf2d2, 0x9c14},
	{0xf2d3, 0x9c09},
	{0xf2d4, 0x9c13},
	{0xf2d5, 0x9c0c},
	{0xf2d6, 0x9c06},
	{0xf2d7, 0x9c08},
	{0xf2d8, 0x9c12},
	{0xf2d9, 0x9c0a},
	{0xf2da, 0x9c04},
	{0xf2db, 0x9c2e},
	{0xf2dc, 0x9c1b},
	{0xf2dd, 0x9c25},
	{0xf2de, 0x9c24},
	{0xf2df, 0x9c21},
	{0xf2e0, 0x9c30},
	{0xf2e1, 0x9c47},
	{0xf2e2, 0x9c32},
	{0xf2e3, 0x9c46},
	{0xf2e4, 0x9c3e},
	{0xf2e5, 0x9c5a},
	{0xf2e6, 0x9c60},
	{0xf2e7, 0x9c67},
	{0xf2e8, 0x9c76},
	{0xf2e9, 0x9c78},
	{0xf2ea, 0x9ce7},
	{0xf2eb, 0x9cec},
	{0xf2ec, 0x9cf0},
	{0xf2ed, 0x9d09},
	{0xf2ee, 0x9d08},
	{0xf2ef, 0x9ceb},
	{0xf2f0, 0x9d03},
	{0xf2f1, 0x9d06},
	{0xf2f2, 0x9d2a},
	{0xf2f3, 0x9d26},
	{0xf2f4, 0x9daf},
	{0xf2f5, 0x9d23},
	{0xf2f6, 0x9d1f},
	{0xf2f7, 0x9d44},
	{0xf2f8, 0x9d15},
	{0xf2f9, 0x9d12},
	{0xf2fa, 0x9d41},
	{0xf2fb, 0x9d3f},
	{0xf2fc, 0x9d3e},
	{0xf2fd, 0x9d46},
	{0xf2fe, 0x9d48},
	{0xf3a1, 0x9d5d},
	{0xf3a2, 0x9d5e},
	{0xf3a3, 0x9d64},
	{0xf3a4, 0x9d51},
	{0xf3a5, 0x9d50},
	{0xf3a6, 0x9d59},
	{0xf3a7, 0x9d72},
	{0xf3a8, 0x9d89},
	{0xf3a9, 0x9d87},
	{0xf3aa, 0x9dab},
	{0xf3ab, 0x9d6f},
	{0xf3ac, 0x9d7a},
	{0xf3ad, 0x9d9a},
	{0xf3ae, 0x9da4},
	{0xf3af, 0x9da9},
	{0xf3b0, 0x9db2},
	{0xf3b1, 0x9dc4},
	{0xf3b2, 0x9dc1},
	{0xf3b3, 0x9dbb},
	{0xf3b4, 0x9db8},
	{0xf3b5, 0x9dba},
	{0xf3b6, 0x9dc6},
	{0xf3b7, 0x9dcf},
	{0xf3b8, 0x9dc2},
	{0xf3b9, 0x9dd9},
	{0xf3ba, 0x9dd3},
	{0xf3bb, 0x9df8},
	{0xf3bc, 0x9de6},
	{0xf3bd, 0x9ded},
	{0xf3be, 0x9def},
	{0xf3bf, 0x9dfd},
	{0xf3c0, 0x9e1a},
	{0xf3c1, 0x9e1b},
	{0xf3c2, 0x9e1e},
	{0xf3c3, 0x9e75},
	{0xf3c4, 0x9e79},
	{0xf3c5, 0x9e7d},
	{0xf3c6, 0x9e81},
	{0xf3c7, 0x9e88},
	{0xf3c8, 0x9e8b},
	{0xf3c9, 0x9e8c},
	{0xf3ca, 0x9e92},
	{0xf3cb, 0x9e95},
	{0xf3cc, 0x9e91},
	{0xf3cd, 0x9e9d},
	{0xf3ce, 0x9ea5},
	{0xf3cf, 0x9ea9},
	{0xf3d0, 0x9eb8},
	{0xf3d1, 0x9eaa},
	{0xf3d2, 0x9ead},
	{0xf3d3, 0x9761},
	{0xf3d4, 0x9ecc},
	{0xf3d5, 0x9ece},
	{0xf3d6, 0x9ecf},
	{0xf3d7, 0x9ed0},
	{0xf3d8, 0x9ed4},
	{0xf3d9, 0x9edc},
	{0xf3da, 0x9ede},
	{0xf3db, 0x9edd},
	{0xf3dc, 0x9ee0},
	{0xf3dd, 0x9ee5},
	{0xf3de, 0x9ee8},
	{0xf3df, 0x9eef},
	{0xf3e0, 0x9ef4},
	{0xf3e1, 0x9ef6},
	{0xf3e2, 0x9ef7},
	{0xf3e3, 0x9ef9},
	{0xf3e4, 0x9efb},
	{0xf3e5, 0x9efc},
	{0xf3e6, 0x9efd},
	{0xf3e7, 0x9f07},
	{0xf3e8, 0x9f08},
	{0xf3e9, 0x76b7},
	{0xf3ea, 0x9f15},
	{0xf3eb, 0x9f21},
	{0xf3ec, 0x9f2c},
	{0xf3ed, 0x9f3e},
	{0xf3ee, 0x9f4a},
	{0xf3ef, 0x9f52},
	{0xf3f0, 0x9f54},
	{0xf3f1, 0x9f63},
	{0xf3f2, 0x9f5f},
	{0xf3f3, 0x9f60},
	{0xf3f4, 0x9f61},
	{0xf3f5, 0x9f66},
	{0xf3f6, 0x9f67},
	{0xf3f7, 0x9f6c},
	{0xf3f8, 0x9f6a},
	{0xf3f9, 0x9f77},
	{0xf3fa, 0x9f72},
	{0xf3fb, 0x9f76},
	{0xf3fc, 0x9f95},
	{0xf3fd, 0x9f9c},
	{0xf3fe, 0x9fa0},
	{0xf4a1, 0x582f},
	{0xf4a2, 0x69c7},
	{0xf4a3, 0x9059},
	{0xf4a4, 0x7464},
	{0xf4a5, 0x51dc},
	{0xf4a6, 0x7199}
};
//	There were 6877 values + a few added by hand

#ifdef CASIO_SH3
static CONST CODE_CONV ppwKsc2Utf[] = {
#else
static CODE_CONV ppwKsc2Utf[] = {
#endif //CASIO_SH3
	{0x0001, 0x0001},
	{0x0002, 0x0002},
	{0x0003, 0x0003},
	{0x0004, 0x0004},
	{0x0005, 0x0005},
	{0x0006, 0x0006},
	{0x0007, 0x0007},
	{0x0008, 0x0008},
	{0x0009, 0x0009},
	{0x000a, 0x000a},
	{0x000b, 0x000b},
	{0x000c, 0x000c},
	{0x000d, 0x000d},
	{0x000e, 0x000e},
	{0x000f, 0x000f},
	{0x0010, 0x0010},
	{0x0011, 0x0011},
	{0x0012, 0x0012},
	{0x0013, 0x0013},
	{0x0014, 0x0014},
	{0x0015, 0x0015},
	{0x0016, 0x0016},
	{0x0017, 0x0017},
	{0x0018, 0x0018},
	{0x0019, 0x0019},
	{0x001a, 0x001a},
	{0x001b, 0x001b},
	{0x001c, 0x001c},
	{0x001d, 0x001d},
	{0x001e, 0x001e},
	{0x001f, 0x001f},
	{0x0020, 0x0020},
	{0x0021, 0x0021},
	{0x0022, 0x0022},
	{0x0023, 0x0023},
	{0x0024, 0x0024},
	{0x0025, 0x0025},
	{0x0026, 0x0026},
	{0x0027, 0x0027},
	{0x0028, 0x0028},
	{0x0029, 0x0029},
	{0x002a, 0x002a},
	{0x002b, 0x002b},
	{0x002c, 0x002c},
	{0x002d, 0x002d},
	{0x002e, 0x002e},
	{0x002f, 0x002f},
	{0x0030, 0x0030},
	{0x0031, 0x0031},
	{0x0032, 0x0032},
	{0x0033, 0x0033},
	{0x0034, 0x0034},
	{0x0035, 0x0035},
	{0x0036, 0x0036},
	{0x0037, 0x0037},
	{0x0038, 0x0038},
	{0x0039, 0x0039},
	{0x003a, 0x003a},
	{0x003b, 0x003b},
	{0x003c, 0x003c},
	{0x003d, 0x003d},
	{0x003e, 0x003e},
	{0x003f, 0x003f},
	{0x0040, 0x0040},
	{0x0041, 0x0041},
	{0x0042, 0x0042},
	{0x0043, 0x0043},
	{0x0044, 0x0044},
	{0x0045, 0x0045},
	{0x0046, 0x0046},
	{0x0047, 0x0047},
	{0x0048, 0x0048},
	{0x0049, 0x0049},
	{0x004a, 0x004a},
	{0x004b, 0x004b},
	{0x004c, 0x004c},
	{0x004d, 0x004d},
	{0x004e, 0x004e},
	{0x004f, 0x004f},
	{0x0050, 0x0050},
	{0x0051, 0x0051},
	{0x0052, 0x0052},
	{0x0053, 0x0053},
	{0x0054, 0x0054},
	{0x0055, 0x0055},
	{0x0056, 0x0056},
	{0x0057, 0x0057},
	{0x0058, 0x0058},
	{0x0059, 0x0059},
	{0x005a, 0x005a},
	{0x005b, 0x005b},
	{0x005c, 0x005c},
	{0x005d, 0x005d},
	{0x005e, 0x005e},
	{0x005f, 0x005f},
	{0x0060, 0x0060},
	{0x0061, 0x0061},
	{0x0062, 0x0062},
	{0x0063, 0x0063},
	{0x0064, 0x0064},
	{0x0065, 0x0065},
	{0x0066, 0x0066},
	{0x0067, 0x0067},
	{0x0068, 0x0068},
	{0x0069, 0x0069},
	{0x006a, 0x006a},
	{0x006b, 0x006b},
	{0x006c, 0x006c},
	{0x006d, 0x006d},
	{0x006e, 0x006e},
	{0x006f, 0x006f},
	{0x0070, 0x0070},
	{0x0071, 0x0071},
	{0x0072, 0x0072},
	{0x0073, 0x0073},
	{0x0074, 0x0074},
	{0x0075, 0x0075},
	{0x0076, 0x0076},
	{0x0077, 0x0077},
	{0x0078, 0x0078},
	{0x0079, 0x0079},
	{0x007a, 0x007a},
	{0x007b, 0x007b},
	{0x007c, 0x007c},
	{0x007d, 0x007d},
	{0x007e, 0x007e},
	{0x007f, 0x007f},
	{0x8141, 0xac02},
	{0x8142, 0xac03},
	{0x8143, 0xac05},
	{0x8144, 0xac06},
	{0x8145, 0xac0b},
	{0x8146, 0xac0c},
	{0x8147, 0xac0d},
	{0x8148, 0xac0e},
	{0x8149, 0xac0f},
	{0x814a, 0xac18},
	{0x814b, 0xac1e},
	{0x814c, 0xac1f},
	{0x814d, 0xac21},
	{0x814e, 0xac22},
	{0x814f, 0xac23},
	{0x8150, 0xac25},
	{0x8151, 0xac26},
	{0x8152, 0xac27},
	{0x8153, 0xac28},
	{0x8154, 0xac29},
	{0x8155, 0xac2a},
	{0x8156, 0xac2b},
	{0x8157, 0xac2e},
	{0x8158, 0xac32},
	{0x8159, 0xac33},
	{0x815a, 0xac34},
	{0x8161, 0xac35},
	{0x8162, 0xac36},
	{0x8163, 0xac37},
	{0x8164, 0xac3a},
	{0x8165, 0xac3b},
	{0x8166, 0xac3d},
	{0x8167, 0xac3e},
	{0x8168, 0xac3f},
	{0x8169, 0xac41},
	{0x816a, 0xac42},
	{0x816b, 0xac43},
	{0x816c, 0xac44},
	{0x816d, 0xac45},
	{0x816e, 0xac46},
	{0x816f, 0xac47},
	{0x8170, 0xac48},
	{0x8171, 0xac49},
	{0x8172, 0xac4a},
	{0x8173, 0xac4c},
	{0x8174, 0xac4e},
	{0x8175, 0xac4f},
	{0x8176, 0xac50},
	{0x8177, 0xac51},
	{0x8178, 0xac52},
	{0x8179, 0xac53},
	{0x817a, 0xac55},
	{0x8181, 0xac56},
	{0x8182, 0xac57},
	{0x8183, 0xac59},
	{0x8184, 0xac5a},
	{0x8185, 0xac5b},
	{0x8186, 0xac5d},
	{0x8187, 0xac5e},
	{0x8188, 0xac5f},
	{0x8189, 0xac60},
	{0x818a, 0xac61},
	{0x818b, 0xac62},
	{0x818c, 0xac63},
	{0x818d, 0xac64},
	{0x818e, 0xac65},
	{0x818f, 0xac66},
	{0x8190, 0xac67},
	{0x8191, 0xac68},
	{0x8192, 0xac69},
	{0x8193, 0xac6a},
	{0x8194, 0xac6b},
	{0x8195, 0xac6c},
	{0x8196, 0xac6d},
	{0x8197, 0xac6e},
	{0x8198, 0xac6f},
	{0x8199, 0xac72},
	{0x819a, 0xac73},
	{0x819b, 0xac75},
	{0x819c, 0xac76},
	{0x819d, 0xac79},
	{0x819e, 0xac7b},
	{0x819f, 0xac7c},
	{0x81a0, 0xac7d},
	{0x81a1, 0xac7e},
	{0x81a2, 0xac7f},
	{0x81a3, 0xac82},
	{0x81a4, 0xac87},
	{0x81a5, 0xac88},
	{0x81a6, 0xac8d},
	{0x81a7, 0xac8e},
	{0x81a8, 0xac8f},
	{0x81a9, 0xac91},
	{0x81aa, 0xac92},
	{0x81ab, 0xac93},
	{0x81ac, 0xac95},
	{0x81ad, 0xac96},
	{0x81ae, 0xac97},
	{0x81af, 0xac98},
	{0x81b0, 0xac99},
	{0x81b1, 0xac9a},
	{0x81b2, 0xac9b},
	{0x81b3, 0xac9e},
	{0x81b4, 0xaca2},
	{0x81b5, 0xaca3},
	{0x81b6, 0xaca4},
	{0x81b7, 0xaca5},
	{0x81b8, 0xaca6},
	{0x81b9, 0xaca7},
	{0x81ba, 0xacab},
	{0x81bb, 0xacad},
	{0x81bc, 0xacae},
	{0x81bd, 0xacb1},
	{0x81be, 0xacb2},
	{0x81bf, 0xacb3},
	{0x81c0, 0xacb4},
	{0x81c1, 0xacb5},
	{0x81c2, 0xacb6},
	{0x81c3, 0xacb7},
	{0x81c4, 0xacba},
	{0x81c5, 0xacbe},
	{0x81c6, 0xacbf},
	{0x81c7, 0xacc0},
	{0x81c8, 0xacc2},
	{0x81c9, 0xacc3},
	{0x81ca, 0xacc5},
	{0x81cb, 0xacc6},
	{0x81cc, 0xacc7},
	{0x81cd, 0xacc9},
	{0x81ce, 0xacca},
	{0x81cf, 0xaccb},
	{0x81d0, 0xaccd},
	{0x81d1, 0xacce},
	{0x81d2, 0xaccf},
	{0x81d3, 0xacd0},
	{0x81d4, 0xacd1},
	{0x81d5, 0xacd2},
	{0x81d6, 0xacd3},
	{0x81d7, 0xacd4},
	{0x81d8, 0xacd6},
	{0x81d9, 0xacd8},
	{0x81da, 0xacd9},
	{0x81db, 0xacda},
	{0x81dc, 0xacdb},
	{0x81dd, 0xacdc},
	{0x81de, 0xacdd},
	{0x81df, 0xacde},
	{0x81e0, 0xacdf},
	{0x81e1, 0xace2},
	{0x81e2, 0xace3},
	{0x81e3, 0xace5},
	{0x81e4, 0xace6},
	{0x81e5, 0xace9},
	{0x81e6, 0xaceb},
	{0x81e7, 0xaced},
	{0x81e8, 0xacee},
	{0x81e9, 0xacf2},
	{0x81ea, 0xacf4},
	{0x81eb, 0xacf7},
	{0x81ec, 0xacf8},
	{0x81ed, 0xacf9},
	{0x81ee, 0xacfa},
	{0x81ef, 0xacfb},
	{0x81f0, 0xacfe},
	{0x81f1, 0xacff},
	{0x81f2, 0xad01},
	{0x81f3, 0xad02},
	{0x81f4, 0xad03},
	{0x81f5, 0xad05},
	{0x81f6, 0xad07},
	{0x81f7, 0xad08},
	{0x81f8, 0xad09},
	{0x81f9, 0xad0a},
	{0x81fa, 0xad0b},
	{0x81fb, 0xad0e},
	{0x81fc, 0xad10},
	{0x81fd, 0xad12},
	{0x81fe, 0xad13},
	{0x8241, 0xad14},
	{0x8242, 0xad15},
	{0x8243, 0xad16},
	{0x8244, 0xad17},
	{0x8245, 0xad19},
	{0x8246, 0xad1a},
	{0x8247, 0xad1b},
	{0x8248, 0xad1d},
	{0x8249, 0xad1e},
	{0x824a, 0xad1f},
	{0x824b, 0xad21},
	{0x824c, 0xad22},
	{0x824d, 0xad23},
	{0x824e, 0xad24},
	{0x824f, 0xad25},
	{0x8250, 0xad26},
	{0x8251, 0xad27},
	{0x8252, 0xad28},
	{0x8253, 0xad2a},
	{0x8254, 0xad2b},
	{0x8255, 0xad2e},
	{0x8256, 0xad2f},
	{0x8257, 0xad30},
	{0x8258, 0xad31},
	{0x8259, 0xad32},
	{0x825a, 0xad33},
	{0x8261, 0xad36},
	{0x8262, 0xad37},
	{0x8263, 0xad39},
	{0x8264, 0xad3a},
	{0x8265, 0xad3b},
	{0x8266, 0xad3d},
	{0x8267, 0xad3e},
	{0x8268, 0xad3f},
	{0x8269, 0xad40},
	{0x826a, 0xad41},
	{0x826b, 0xad42},
	{0x826c, 0xad43},
	{0x826d, 0xad46},
	{0x826e, 0xad48},
	{0x826f, 0xad4a},
	{0x8270, 0xad4b},
	{0x8271, 0xad4c},
	{0x8272, 0xad4d},
	{0x8273, 0xad4e},
	{0x8274, 0xad4f},
	{0x8275, 0xad51},
	{0x8276, 0xad52},
	{0x8277, 0xad53},
	{0x8278, 0xad55},
	{0x8279, 0xad56},
	{0x827a, 0xad57},
	{0x8281, 0xad59},
	{0x8282, 0xad5a},
	{0x8283, 0xad5b},
	{0x8284, 0xad5c},
	{0x8285, 0xad5d},
	{0x8286, 0xad5e},
	{0x8287, 0xad5f},
	{0x8288, 0xad60},
	{0x8289, 0xad62},
	{0x828a, 0xad64},
	{0x828b, 0xad65},
	{0x828c, 0xad66},
	{0x828d, 0xad67},
	{0x828e, 0xad68},
	{0x828f, 0xad69},
	{0x8290, 0xad6a},
	{0x8291, 0xad6b},
	{0x8292, 0xad6e},
	{0x8293, 0xad6f},
	{0x8294, 0xad71},
	{0x8295, 0xad72},
	{0x8296, 0xad77},
	{0x8297, 0xad78},
	{0x8298, 0xad79},
	{0x8299, 0xad7a},
	{0x829a, 0xad7e},
	{0x829b, 0xad80},
	{0x829c, 0xad83},
	{0x829d, 0xad84},
	{0x829e, 0xad85},
	{0x829f, 0xad86},
	{0x82a0, 0xad87},
	{0x82a1, 0xad8a},
	{0x82a2, 0xad8b},
	{0x82a3, 0xad8d},
	{0x82a4, 0xad8e},
	{0x82a5, 0xad8f},
	{0x82a6, 0xad91},
	{0x82a7, 0xad92},
	{0x82a8, 0xad93},
	{0x82a9, 0xad94},
	{0x82aa, 0xad95},
	{0x82ab, 0xad96},
	{0x82ac, 0xad97},
	{0x82ad, 0xad98},
	{0x82ae, 0xad99},
	{0x82af, 0xad9a},
	{0x82b0, 0xad9b},
	{0x82b1, 0xad9e},
	{0x82b2, 0xad9f},
	{0x82b3, 0xada0},
	{0x82b4, 0xada1},
	{0x82b5, 0xada2},
	{0x82b6, 0xada3},
	{0x82b7, 0xada5},
	{0x82b8, 0xada6},
	{0x82b9, 0xada7},
	{0x82ba, 0xada8},
	{0x82bb, 0xada9},
	{0x82bc, 0xadaa},
	{0x82bd, 0xadab},
	{0x82be, 0xadac},
	{0x82bf, 0xadad},
	{0x82c0, 0xadae},
	{0x82c1, 0xadaf},
	{0x82c2, 0xadb0},
	{0x82c3, 0xadb1},
	{0x82c4, 0xadb2},
	{0x82c5, 0xadb3},
	{0x82c6, 0xadb4},
	{0x82c7, 0xadb5},
	{0x82c8, 0xadb6},
	{0x82c9, 0xadb8},
	{0x82ca, 0xadb9},
	{0x82cb, 0xadba},
	{0x82cc, 0xadbb},
	{0x82cd, 0xadbc},
	{0x82ce, 0xadbd},
	{0x82cf, 0xadbe},
	{0x82d0, 0xadbf},
	{0x82d1, 0xadc2},
	{0x82d2, 0xadc3},
	{0x82d3, 0xadc5},
	{0x82d4, 0xadc6},
	{0x82d5, 0xadc7},
	{0x82d6, 0xadc9},
	{0x82d7, 0xadca},
	{0x82d8, 0xadcb},
	{0x82d9, 0xadcc},
	{0x82da, 0xadcd},
	{0x82db, 0xadce},
	{0x82dc, 0xadcf},
	{0x82dd, 0xadd2},
	{0x82de, 0xadd4},
	{0x82df, 0xadd5},
	{0x82e0, 0xadd6},
	{0x82e1, 0xadd7},
	{0x82e2, 0xadd8},
	{0x82e3, 0xadd9},
	{0x82e4, 0xadda},
	{0x82e5, 0xaddb},
	{0x82e6, 0xaddd},
	{0x82e7, 0xadde},
	{0x82e8, 0xaddf},
	{0x82e9, 0xade1},
	{0x82ea, 0xade2},
	{0x82eb, 0xade3},
	{0x82ec, 0xade5},
	{0x82ed, 0xade6},
	{0x82ee, 0xade7},
	{0x82ef, 0xade8},
	{0x82f0, 0xade9},
	{0x82f1, 0xadea},
	{0x82f2, 0xadeb},
	{0x82f3, 0xadec},
	{0x82f4, 0xaded},
	{0x82f5, 0xadee},
	{0x82f6, 0xadef},
	{0x82f7, 0xadf0},
	{0x82f8, 0xadf1},
	{0x82f9, 0xadf2},
	{0x82fa, 0xadf3},
	{0x82fb, 0xadf4},
	{0x82fc, 0xadf5},
	{0x82fd, 0xadf6},
	{0x82fe, 0xadf7},
	{0x8341, 0xadfa},
	{0x8342, 0xadfb},
	{0x8343, 0xadfd},
	{0x8344, 0xadfe},
	{0x8345, 0xae02},
	{0x8346, 0xae03},
	{0x8347, 0xae04},
	{0x8348, 0xae05},
	{0x8349, 0xae06},
	{0x834a, 0xae07},
	{0x834b, 0xae0a},
	{0x834c, 0xae0c},
	{0x834d, 0xae0e},
	{0x834e, 0xae0f},
	{0x834f, 0xae10},
	{0x8350, 0xae11},
	{0x8351, 0xae12},
	{0x8352, 0xae13},
	{0x8353, 0xae15},
	{0x8354, 0xae16},
	{0x8355, 0xae17},
	{0x8356, 0xae18},
	{0x8357, 0xae19},
	{0x8358, 0xae1a},
	{0x8359, 0xae1b},
	{0x835a, 0xae1c},
	{0x8361, 0xae1d},
	{0x8362, 0xae1e},
	{0x8363, 0xae1f},
	{0x8364, 0xae20},
	{0x8365, 0xae21},
	{0x8366, 0xae22},
	{0x8367, 0xae23},
	{0x8368, 0xae24},
	{0x8369, 0xae25},
	{0x836a, 0xae26},
	{0x836b, 0xae27},
	{0x836c, 0xae28},
	{0x836d, 0xae29},
	{0x836e, 0xae2a},
	{0x836f, 0xae2b},
	{0x8370, 0xae2c},
	{0x8371, 0xae2d},
	{0x8372, 0xae2e},
	{0x8373, 0xae2f},
	{0x8374, 0xae32},
	{0x8375, 0xae33},
	{0x8376, 0xae35},
	{0x8377, 0xae36},
	{0x8378, 0xae39},
	{0x8379, 0xae3b},
	{0x837a, 0xae3c},
	{0x8381, 0xae3d},
	{0x8382, 0xae3e},
	{0x8383, 0xae3f},
	{0x8384, 0xae42},
	{0x8385, 0xae44},
	{0x8386, 0xae47},
	{0x8387, 0xae48},
	{0x8388, 0xae49},
	{0x8389, 0xae4b},
	{0x838a, 0xae4f},
	{0x838b, 0xae51},
	{0x838c, 0xae52},
	{0x838d, 0xae53},
	{0x838e, 0xae55},
	{0x838f, 0xae57},
	{0x8390, 0xae58},
	{0x8391, 0xae59},
	{0x8392, 0xae5a},
	{0x8393, 0xae5b},
	{0x8394, 0xae5e},
	{0x8395, 0xae62},
	{0x8396, 0xae63},
	{0x8397, 0xae64},
	{0x8398, 0xae66},
	{0x8399, 0xae67},
	{0x839a, 0xae6a},
	{0x839b, 0xae6b},
	{0x839c, 0xae6d},
	{0x839d, 0xae6e},
	{0x839e, 0xae6f},
	{0x839f, 0xae71},
	{0x83a0, 0xae72},
	{0x83a1, 0xae73},
	{0x83a2, 0xae74},
	{0x83a3, 0xae75},
	{0x83a4, 0xae76},
	{0x83a5, 0xae77},
	{0x83a6, 0xae7a},
	{0x83a7, 0xae7e},
	{0x83a8, 0xae7f},
	{0x83a9, 0xae80},
	{0x83aa, 0xae81},
	{0x83ab, 0xae82},
	{0x83ac, 0xae83},
	{0x83ad, 0xae86},
	{0x83ae, 0xae87},
	{0x83af, 0xae88},
	{0x83b0, 0xae89},
	{0x83b1, 0xae8a},
	{0x83b2, 0xae8b},
	{0x83b3, 0xae8d},
	{0x83b4, 0xae8e},
	{0x83b5, 0xae8f},
	{0x83b6, 0xae90},
	{0x83b7, 0xae91},
	{0x83b8, 0xae92},
	{0x83b9, 0xae93},
	{0x83ba, 0xae94},
	{0x83bb, 0xae95},
	{0x83bc, 0xae96},
	{0x83bd, 0xae97},
	{0x83be, 0xae98},
	{0x83bf, 0xae99},
	{0x83c0, 0xae9a},
	{0x83c1, 0xae9b},
	{0x83c2, 0xae9c},
	{0x83c3, 0xae9d},
	{0x83c4, 0xae9e},
	{0x83c5, 0xae9f},
	{0x83c6, 0xaea0},
	{0x83c7, 0xaea1},
	{0x83c8, 0xaea2},
	{0x83c9, 0xaea3},
	{0x83ca, 0xaea4},
	{0x83cb, 0xaea5},
	{0x83cc, 0xaea6},
	{0x83cd, 0xaea7},
	{0x83ce, 0xaea8},
	{0x83cf, 0xaea9},
	{0x83d0, 0xaeaa},
	{0x83d1, 0xaeab},
	{0x83d2, 0xaeac},
	{0x83d3, 0xaead},
	{0x83d4, 0xaeae},
	{0x83d5, 0xaeaf},
	{0x83d6, 0xaeb0},
	{0x83d7, 0xaeb1},
	{0x83d8, 0xaeb2},
	{0x83d9, 0xaeb3},
	{0x83da, 0xaeb4},
	{0x83db, 0xaeb5},
	{0x83dc, 0xaeb6},
	{0x83dd, 0xaeb7},
	{0x83de, 0xaeb8},
	{0x83df, 0xaeb9},
	{0x83e0, 0xaeba},
	{0x83e1, 0xaebb},
	{0x83e2, 0xaebf},
	{0x83e3, 0xaec1},
	{0x83e4, 0xaec2},
	{0x83e5, 0xaec3},
	{0x83e6, 0xaec5},
	{0x83e7, 0xaec6},
	{0x83e8, 0xaec7},
	{0x83e9, 0xaec8},
	{0x83ea, 0xaec9},
	{0x83eb, 0xaeca},
	{0x83ec, 0xaecb},
	{0x83ed, 0xaece},
	{0x83ee, 0xaed2},
	{0x83ef, 0xaed3},
	{0x83f0, 0xaed4},
	{0x83f1, 0xaed5},
	{0x83f2, 0xaed6},
	{0x83f3, 0xaed7},
	{0x83f4, 0xaeda},
	{0x83f5, 0xaedb},
	{0x83f6, 0xaedd},
	{0x83f7, 0xaede},
	{0x83f8, 0xaedf},
	{0x83f9, 0xaee0},
	{0x83fa, 0xaee1},
	{0x83fb, 0xaee2},
	{0x83fc, 0xaee3},
	{0x83fd, 0xaee4},
	{0x83fe, 0xaee5},
	{0x8441, 0xaee6},
	{0x8442, 0xaee7},
	{0x8443, 0xaee9},
	{0x8444, 0xaeea},
	{0x8445, 0xaeec},
	{0x8446, 0xaeee},
	{0x8447, 0xaeef},
	{0x8448, 0xaef0},
	{0x8449, 0xaef1},
	{0x844a, 0xaef2},
	{0x844b, 0xaef3},
	{0x844c, 0xaef5},
	{0x844d, 0xaef6},
	{0x844e, 0xaef7},
	{0x844f, 0xaef9},
	{0x8450, 0xaefa},
	{0x8451, 0xaefb},
	{0x8452, 0xaefd},
	{0x8453, 0xaefe},
	{0x8454, 0xaeff},
	{0x8455, 0xaf00},
	{0x8456, 0xaf01},
	{0x8457, 0xaf02},
	{0x8458, 0xaf03},
	{0x8459, 0xaf04},
	{0x845a, 0xaf05},
	{0x8461, 0xaf06},
	{0x8462, 0xaf09},
	{0x8463, 0xaf0a},
	{0x8464, 0xaf0b},
	{0x8465, 0xaf0c},
	{0x8466, 0xaf0e},
	{0x8467, 0xaf0f},
	{0x8468, 0xaf11},
	{0x8469, 0xaf12},
	{0x846a, 0xaf13},
	{0x846b, 0xaf14},
	{0x846c, 0xaf15},
	{0x846d, 0xaf16},
	{0x846e, 0xaf17},
	{0x846f, 0xaf18},
	{0x8470, 0xaf19},
	{0x8471, 0xaf1a},
	{0x8472, 0xaf1b},
	{0x8473, 0xaf1c},
	{0x8474, 0xaf1d},
	{0x8475, 0xaf1e},
	{0x8476, 0xaf1f},
	{0x8477, 0xaf20},
	{0x8478, 0xaf21},
	{0x8479, 0xaf22},
	{0x847a, 0xaf23},
	{0x8481, 0xaf24},
	{0x8482, 0xaf25},
	{0x8483, 0xaf26},
	{0x8484, 0xaf27},
	{0x8485, 0xaf28},
	{0x8486, 0xaf29},
	{0x8487, 0xaf2a},
	{0x8488, 0xaf2b},
	{0x8489, 0xaf2e},
	{0x848a, 0xaf2f},
	{0x848b, 0xaf31},
	{0x848c, 0xaf33},
	{0x848d, 0xaf35},
	{0x848e, 0xaf36},
	{0x848f, 0xaf37},
	{0x8490, 0xaf38},
	{0x8491, 0xaf39},
	{0x8492, 0xaf3a},
	{0x8493, 0xaf3b},
	{0x8494, 0xaf3e},
	{0x8495, 0xaf40},
	{0x8496, 0xaf44},
	{0x8497, 0xaf45},
	{0x8498, 0xaf46},
	{0x8499, 0xaf47},
	{0x849a, 0xaf4a},
	{0x849b, 0xaf4b},
	{0x849c, 0xaf4c},
	{0x849d, 0xaf4d},
	{0x849e, 0xaf4e},
	{0x849f, 0xaf4f},
	{0x84a0, 0xaf51},
	{0x84a1, 0xaf52},
	{0x84a2, 0xaf53},
	{0x84a3, 0xaf54},
	{0x84a4, 0xaf55},
	{0x84a5, 0xaf56},
	{0x84a6, 0xaf57},
	{0x84a7, 0xaf58},
	{0x84a8, 0xaf59},
	{0x84a9, 0xaf5a},
	{0x84aa, 0xaf5b},
	{0x84ab, 0xaf5e},
	{0x84ac, 0xaf5f},
	{0x84ad, 0xaf60},
	{0x84ae, 0xaf61},
	{0x84af, 0xaf62},
	{0x84b0, 0xaf63},
	{0x84b1, 0xaf66},
	{0x84b2, 0xaf67},
	{0x84b3, 0xaf68},
	{0x84b4, 0xaf69},
	{0x84b5, 0xaf6a},
	{0x84b6, 0xaf6b},
	{0x84b7, 0xaf6c},
	{0x84b8, 0xaf6d},
	{0x84b9, 0xaf6e},
	{0x84ba, 0xaf6f},
	{0x84bb, 0xaf70},
	{0x84bc, 0xaf71},
	{0x84bd, 0xaf72},
	{0x84be, 0xaf73},
	{0x84bf, 0xaf74},
	{0x84c0, 0xaf75},
	{0x84c1, 0xaf76},
	{0x84c2, 0xaf77},
	{0x84c3, 0xaf78},
	{0x84c4, 0xaf7a},
	{0x84c5, 0xaf7b},
	{0x84c6, 0xaf7c},
	{0x84c7, 0xaf7d},
	{0x84c8, 0xaf7e},
	{0x84c9, 0xaf7f},
	{0x84ca, 0xaf81},
	{0x84cb, 0xaf82},
	{0x84cc, 0xaf83},
	{0x84cd, 0xaf85},
	{0x84ce, 0xaf86},
	{0x84cf, 0xaf87},
	{0x84d0, 0xaf89},
	{0x84d1, 0xaf8a},
	{0x84d2, 0xaf8b},
	{0x84d3, 0xaf8c},
	{0x84d4, 0xaf8d},
	{0x84d5, 0xaf8e},
	{0x84d6, 0xaf8f},
	{0x84d7, 0xaf92},
	{0x84d8, 0xaf93},
	{0x84d9, 0xaf94},
	{0x84da, 0xaf96},
	{0x84db, 0xaf97},
	{0x84dc, 0xaf98},
	{0x84dd, 0xaf99},
	{0x84de, 0xaf9a},
	{0x84df, 0xaf9b},
	{0x84e0, 0xaf9d},
	{0x84e1, 0xaf9e},
	{0x84e2, 0xaf9f},
	{0x84e3, 0xafa0},
	{0x84e4, 0xafa1},
	{0x84e5, 0xafa2},
	{0x84e6, 0xafa3},
	{0x84e7, 0xafa4},
	{0x84e8, 0xafa5},
	{0x84e9, 0xafa6},
	{0x84ea, 0xafa7},
	{0x84eb, 0xafa8},
	{0x84ec, 0xafa9},
	{0x84ed, 0xafaa},
	{0x84ee, 0xafab},
	{0x84ef, 0xafac},
	{0x84f0, 0xafad},
	{0x84f1, 0xafae},
	{0x84f2, 0xafaf},
	{0x84f3, 0xafb0},
	{0x84f4, 0xafb1},
	{0x84f5, 0xafb2},
	{0x84f6, 0xafb3},
	{0x84f7, 0xafb4},
	{0x84f8, 0xafb5},
	{0x84f9, 0xafb6},
	{0x84fa, 0xafb7},
	{0x84fb, 0xafba},
	{0x84fc, 0xafbb},
	{0x84fd, 0xafbd},
	{0x84fe, 0xafbe},
	{0x8541, 0xafbf},
	{0x8542, 0xafc1},
	{0x8543, 0xafc2},
	{0x8544, 0xafc3},
	{0x8545, 0xafc4},
	{0x8546, 0xafc5},
	{0x8547, 0xafc6},
	{0x8548, 0xafca},
	{0x8549, 0xafcc},
	{0x854a, 0xafcf},
	{0x854b, 0xafd0},
	{0x854c, 0xafd1},
	{0x854d, 0xafd2},
	{0x854e, 0xafd3},
	{0x854f, 0xafd5},
	{0x8550, 0xafd6},
	{0x8551, 0xafd7},
	{0x8552, 0xafd8},
	{0x8553, 0xafd9},
	{0x8554, 0xafda},
	{0x8555, 0xafdb},
	{0x8556, 0xafdd},
	{0x8557, 0xafde},
	{0x8558, 0xafdf},
	{0x8559, 0xafe0},
	{0x855a, 0xafe1},
	{0x8561, 0xafe2},
	{0x8562, 0xafe3},
	{0x8563, 0xafe4},
	{0x8564, 0xafe5},
	{0x8565, 0xafe6},
	{0x8566, 0xafe7},
	{0x8567, 0xafea},
	{0x8568, 0xafeb},
	{0x8569, 0xafec},
	{0x856a, 0xafed},
	{0x856b, 0xafee},
	{0x856c, 0xafef},
	{0x856d, 0xaff2},
	{0x856e, 0xaff3},
	{0x856f, 0xaff5},
	{0x8570, 0xaff6},
	{0x8571, 0xaff7},
	{0x8572, 0xaff9},
	{0x8573, 0xaffa},
	{0x8574, 0xaffb},
	{0x8575, 0xaffc},
	{0x8576, 0xaffd},
	{0x8577, 0xaffe},
	{0x8578, 0xafff},
	{0x8579, 0xb002},
	{0x857a, 0xb003},
	{0x8581, 0xb005},
	{0x8582, 0xb006},
	{0x8583, 0xb007},
	{0x8584, 0xb008},
	{0x8585, 0xb009},
	{0x8586, 0xb00a},
	{0x8587, 0xb00b},
	{0x8588, 0xb00d},
	{0x8589, 0xb00e},
	{0x858a, 0xb00f},
	{0x858b, 0xb011},
	{0x858c, 0xb012},
	{0x858d, 0xb013},
	{0x858e, 0xb015},
	{0x858f, 0xb016},
	{0x8590, 0xb017},
	{0x8591, 0xb018},
	{0x8592, 0xb019},
	{0x8593, 0xb01a},
	{0x8594, 0xb01b},
	{0x8595, 0xb01e},
	{0x8596, 0xb01f},
	{0x8597, 0xb020},
	{0x8598, 0xb021},
	{0x8599, 0xb022},
	{0x859a, 0xb023},
	{0x859b, 0xb024},
	{0x859c, 0xb025},
	{0x859d, 0xb026},
	{0x859e, 0xb027},
	{0x859f, 0xb029},
	{0x85a0, 0xb02a},
	{0x85a1, 0xb02b},
	{0x85a2, 0xb02c},
	{0x85a3, 0xb02d},
	{0x85a4, 0xb02e},
	{0x85a5, 0xb02f},
	{0x85a6, 0xb030},
	{0x85a7, 0xb031},
	{0x85a8, 0xb032},
	{0x85a9, 0xb033},
	{0x85aa, 0xb034},
	{0x85ab, 0xb035},
	{0x85ac, 0xb036},
	{0x85ad, 0xb037},
	{0x85ae, 0xb038},
	{0x85af, 0xb039},
	{0x85b0, 0xb03a},
	{0x85b1, 0xb03b},
	{0x85b2, 0xb03c},
	{0x85b3, 0xb03d},
	{0x85b4, 0xb03e},
	{0x85b5, 0xb03f},
	{0x85b6, 0xb040},
	{0x85b7, 0xb041},
	{0x85b8, 0xb042},
	{0x85b9, 0xb043},
	{0x85ba, 0xb046},
	{0x85bb, 0xb047},
	{0x85bc, 0xb049},
	{0x85bd, 0xb04b},
	{0x85be, 0xb04d},
	{0x85bf, 0xb04f},
	{0x85c0, 0xb050},
	{0x85c1, 0xb051},
	{0x85c2, 0xb052},
	{0x85c3, 0xb056},
	{0x85c4, 0xb058},
	{0x85c5, 0xb05a},
	{0x85c6, 0xb05b},
	{0x85c7, 0xb05c},
	{0x85c8, 0xb05e},
	{0x85c9, 0xb05f},
	{0x85ca, 0xb060},
	{0x85cb, 0xb061},
	{0x85cc, 0xb062},
	{0x85cd, 0xb063},
	{0x85ce, 0xb064},
	{0x85cf, 0xb065},
	{0x85d0, 0xb066},
	{0x85d1, 0xb067},
	{0x85d2, 0xb068},
	{0x85d3, 0xb069},
	{0x85d4, 0xb06a},
	{0x85d5, 0xb06b},
	{0x85d6, 0xb06c},
	{0x85d7, 0xb06d},
	{0x85d8, 0xb06e},
	{0x85d9, 0xb06f},
	{0x85da, 0xb070},
	{0x85db, 0xb071},
	{0x85dc, 0xb072},
	{0x85dd, 0xb073},
	{0x85de, 0xb074},
	{0x85df, 0xb075},
	{0x85e0, 0xb076},
	{0x85e1, 0xb077},
	{0x85e2, 0xb078},
	{0x85e3, 0xb079},
	{0x85e4, 0xb07a},
	{0x85e5, 0xb07b},
	{0x85e6, 0xb07e},
	{0x85e7, 0xb07f},
	{0x85e8, 0xb081},
	{0x85e9, 0xb082},
	{0x85ea, 0xb083},
	{0x85eb, 0xb085},
	{0x85ec, 0xb086},
	{0x85ed, 0xb087},
	{0x85ee, 0xb088},
	{0x85ef, 0xb089},
	{0x85f0, 0xb08a},
	{0x85f1, 0xb08b},
	{0x85f2, 0xb08e},
	{0x85f3, 0xb090},
	{0x85f4, 0xb092},
	{0x85f5, 0xb093},
	{0x85f6, 0xb094},
	{0x85f7, 0xb095},
	{0x85f8, 0xb096},
	{0x85f9, 0xb097},
	{0x85fa, 0xb09b},
	{0x85fb, 0xb09d},
	{0x85fc, 0xb09e},
	{0x85fd, 0xb0a3},
	{0x85fe, 0xb0a4},
	{0x8641, 0xb0a5},
	{0x8642, 0xb0a6},
	{0x8643, 0xb0a7},
	{0x8644, 0xb0aa},
	{0x8645, 0xb0b0},
	{0x8646, 0xb0b2},
	{0x8647, 0xb0b6},
	{0x8648, 0xb0b7},
	{0x8649, 0xb0b9},
	{0x864a, 0xb0ba},
	{0x864b, 0xb0bb},
	{0x864c, 0xb0bd},
	{0x864d, 0xb0be},
	{0x864e, 0xb0bf},
	{0x864f, 0xb0c0},
	{0x8650, 0xb0c1},
	{0x8651, 0xb0c2},
	{0x8652, 0xb0c3},
	{0x8653, 0xb0c6},
	{0x8654, 0xb0ca},
	{0x8655, 0xb0cb},
	{0x8656, 0xb0cc},
	{0x8657, 0xb0cd},
	{0x8658, 0xb0ce},
	{0x8659, 0xb0cf},
	{0x865a, 0xb0d2},
	{0x8661, 0xb0d3},
	{0x8662, 0xb0d5},
	{0x8663, 0xb0d6},
	{0x8664, 0xb0d7},
	{0x8665, 0xb0d9},
	{0x8666, 0xb0da},
	{0x8667, 0xb0db},
	{0x8668, 0xb0dc},
	{0x8669, 0xb0dd},
	{0x866a, 0xb0de},
	{0x866b, 0xb0df},
	{0x866c, 0xb0e1},
	{0x866d, 0xb0e2},
	{0x866e, 0xb0e3},
	{0x866f, 0xb0e4},
	{0x8670, 0xb0e6},
	{0x8671, 0xb0e7},
	{0x8672, 0xb0e8},
	{0x8673, 0xb0e9},
	{0x8674, 0xb0ea},
	{0x8675, 0xb0eb},
	{0x8676, 0xb0ec},
	{0x8677, 0xb0ed},
	{0x8678, 0xb0ee},
	{0x8679, 0xb0ef},
	{0x867a, 0xb0f0},
	{0x8681, 0xb0f1},
	{0x8682, 0xb0f2},
	{0x8683, 0xb0f3},
	{0x8684, 0xb0f4},
	{0x8685, 0xb0f5},
	{0x8686, 0xb0f6},
	{0x8687, 0xb0f7},
	{0x8688, 0xb0f8},
	{0x8689, 0xb0f9},
	{0x868a, 0xb0fa},
	{0x868b, 0xb0fb},
	{0x868c, 0xb0fc},
	{0x868d, 0xb0fd},
	{0x868e, 0xb0fe},
	{0x868f, 0xb0ff},
	{0x8690, 0xb100},
	{0x8691, 0xb101},
	{0x8692, 0xb102},
	{0x8693, 0xb103},
	{0x8694, 0xb104},
	{0x8695, 0xb105},
	{0x8696, 0xb106},
	{0x8697, 0xb107},
	{0x8698, 0xb10a},
	{0x8699, 0xb10d},
	{0x869a, 0xb10e},
	{0x869b, 0xb10f},
	{0x869c, 0xb111},
	{0x869d, 0xb114},
	{0x869e, 0xb115},
	{0x869f, 0xb116},
	{0x86a0, 0xb117},
	{0x86a1, 0xb11a},
	{0x86a2, 0xb11e},
	{0x86a3, 0xb11f},
	{0x86a4, 0xb120},
	{0x86a5, 0xb121},
	{0x86a6, 0xb122},
	{0x86a7, 0xb126},
	{0x86a8, 0xb127},
	{0x86a9, 0xb129},
	{0x86aa, 0xb12a},
	{0x86ab, 0xb12b},
	{0x86ac, 0xb12d},
	{0x86ad, 0xb12e},
	{0x86ae, 0xb12f},
	{0x86af, 0xb130},
	{0x86b0, 0xb131},
	{0x86b1, 0xb132},
	{0x86b2, 0xb133},
	{0x86b3, 0xb136},
	{0x86b4, 0xb13a},
	{0x86b5, 0xb13b},
	{0x86b6, 0xb13c},
	{0x86b7, 0xb13d},
	{0x86b8, 0xb13e},
	{0x86b9, 0xb13f},
	{0x86ba, 0xb142},
	{0x86bb, 0xb143},
	{0x86bc, 0xb145},
	{0x86bd, 0xb146},
	{0x86be, 0xb147},
	{0x86bf, 0xb149},
	{0x86c0, 0xb14a},
	{0x86c1, 0xb14b},
	{0x86c2, 0xb14c},
	{0x86c3, 0xb14d},
	{0x86c4, 0xb14e},
	{0x86c5, 0xb14f},
	{0x86c6, 0xb152},
	{0x86c7, 0xb153},
	{0x86c8, 0xb156},
	{0x86c9, 0xb157},
	{0x86ca, 0xb159},
	{0x86cb, 0xb15a},
	{0x86cc, 0xb15b},
	{0x86cd, 0xb15d},
	{0x86ce, 0xb15e},
	{0x86cf, 0xb15f},
	{0x86d0, 0xb161},
	{0x86d1, 0xb162},
	{0x86d2, 0xb163},
	{0x86d3, 0xb164},
	{0x86d4, 0xb165},
	{0x86d5, 0xb166},
	{0x86d6, 0xb167},
	{0x86d7, 0xb168},
	{0x86d8, 0xb169},
	{0x86d9, 0xb16a},
	{0x86da, 0xb16b},
	{0x86db, 0xb16c},
	{0x86dc, 0xb16d},
	{0x86dd, 0xb16e},
	{0x86de, 0xb16f},
	{0x86df, 0xb170},
	{0x86e0, 0xb171},
	{0x86e1, 0xb172},
	{0x86e2, 0xb173},
	{0x86e3, 0xb174},
	{0x86e4, 0xb175},
	{0x86e5, 0xb176},
	{0x86e6, 0xb177},
	{0x86e7, 0xb17a},
	{0x86e8, 0xb17b},
	{0x86e9, 0xb17d},
	{0x86ea, 0xb17e},
	{0x86eb, 0xb17f},
	{0x86ec, 0xb181},
	{0x86ed, 0xb183},
	{0x86ee, 0xb184},
	{0x86ef, 0xb185},
	{0x86f0, 0xb186},
	{0x86f1, 0xb187},
	{0x86f2, 0xb18a},
	{0x86f3, 0xb18c},
	{0x86f4, 0xb18e},
	{0x86f5, 0xb18f},
	{0x86f6, 0xb190},
	{0x86f7, 0xb191},
	{0x86f8, 0xb195},
	{0x86f9, 0xb196},
	{0x86fa, 0xb197},
	{0x86fb, 0xb199},
	{0x86fc, 0xb19a},
	{0x86fd, 0xb19b},
	{0x86fe, 0xb19d},
	{0x8741, 0xb19e},
	{0x8742, 0xb19f},
	{0x8743, 0xb1a0},
	{0x8744, 0xb1a1},
	{0x8745, 0xb1a2},
	{0x8746, 0xb1a3},
	{0x8747, 0xb1a4},
	{0x8748, 0xb1a5},
	{0x8749, 0xb1a6},
	{0x874a, 0xb1a7},
	{0x874b, 0xb1a9},
	{0x874c, 0xb1aa},
	{0x874d, 0xb1ab},
	{0x874e, 0xb1ac},
	{0x874f, 0xb1ad},
	{0x8750, 0xb1ae},
	{0x8751, 0xb1af},
	{0x8752, 0xb1b0},
	{0x8753, 0xb1b1},
	{0x8754, 0xb1b2},
	{0x8755, 0xb1b3},
	{0x8756, 0xb1b4},
	{0x8757, 0xb1b5},
	{0x8758, 0xb1b6},
	{0x8759, 0xb1b7},
	{0x875a, 0xb1b8},
	{0x8761, 0xb1b9},
	{0x8762, 0xb1ba},
	{0x8763, 0xb1bb},
	{0x8764, 0xb1bc},
	{0x8765, 0xb1bd},
	{0x8766, 0xb1be},
	{0x8767, 0xb1bf},
	{0x8768, 0xb1c0},
	{0x8769, 0xb1c1},
	{0x876a, 0xb1c2},
	{0x876b, 0xb1c3},
	{0x876c, 0xb1c4},
	{0x876d, 0xb1c5},
	{0x876e, 0xb1c6},
	{0x876f, 0xb1c7},
	{0x8770, 0xb1c8},
	{0x8771, 0xb1c9},
	{0x8772, 0xb1ca},
	{0x8773, 0xb1cb},
	{0x8774, 0xb1cd},
	{0x8775, 0xb1ce},
	{0x8776, 0xb1cf},
	{0x8777, 0xb1d1},
	{0x8778, 0xb1d2},
	{0x8779, 0xb1d3},
	{0x877a, 0xb1d5},
	{0x8781, 0xb1d6},
	{0x8782, 0xb1d7},
	{0x8783, 0xb1d8},
	{0x8784, 0xb1d9},
	{0x8785, 0xb1da},
	{0x8786, 0xb1db},
	{0x8787, 0xb1de},
	{0x8788, 0xb1e0},
	{0x8789, 0xb1e1},
	{0x878a, 0xb1e2},
	{0x878b, 0xb1e3},
	{0x878c, 0xb1e4},
	{0x878d, 0xb1e5},
	{0x878e, 0xb1e6},
	{0x878f, 0xb1e7},
	{0x8790, 0xb1ea},
	{0x8791, 0xb1eb},
	{0x8792, 0xb1ed},
	{0x8793, 0xb1ee},
	{0x8794, 0xb1ef},
	{0x8795, 0xb1f1},
	{0x8796, 0xb1f2},
	{0x8797, 0xb1f3},
	{0x8798, 0xb1f4},
	{0x8799, 0xb1f5},
	{0x879a, 0xb1f6},
	{0x879b, 0xb1f7},
	{0x879c, 0xb1f8},
	{0x879d, 0xb1fa},
	{0x879e, 0xb1fc},
	{0x879f, 0xb1fe},
	{0x87a0, 0xb1ff},
	{0x87a1, 0xb200},
	{0x87a2, 0xb201},
	{0x87a3, 0xb202},
	{0x87a4, 0xb203},
	{0x87a5, 0xb206},
	{0x87a6, 0xb207},
	{0x87a7, 0xb209},
	{0x87a8, 0xb20a},
	{0x87a9, 0xb20d},
	{0x87aa, 0xb20e},
	{0x87ab, 0xb20f},
	{0x87ac, 0xb210},
	{0x87ad, 0xb211},
	{0x87ae, 0xb212},
	{0x87af, 0xb213},
	{0x87b0, 0xb216},
	{0x87b1, 0xb218},
	{0x87b2, 0xb21a},
	{0x87b3, 0xb21b},
	{0x87b4, 0xb21c},
	{0x87b5, 0xb21d},
	{0x87b6, 0xb21e},
	{0x87b7, 0xb21f},
	{0x87b8, 0xb221},
	{0x87b9, 0xb222},
	{0x87ba, 0xb223},
	{0x87bb, 0xb224},
	{0x87bc, 0xb225},
	{0x87bd, 0xb226},
	{0x87be, 0xb227},
	{0x87bf, 0xb228},
	{0x87c0, 0xb229},
	{0x87c1, 0xb22a},
	{0x87c2, 0xb22b},
	{0x87c3, 0xb22c},
	{0x87c4, 0xb22d},
	{0x87c5, 0xb22e},
	{0x87c6, 0xb22f},
	{0x87c7, 0xb230},
	{0x87c8, 0xb231},
	{0x87c9, 0xb232},
	{0x87ca, 0xb233},
	{0x87cb, 0xb235},
	{0x87cc, 0xb236},
	{0x87cd, 0xb237},
	{0x87ce, 0xb238},
	{0x87cf, 0xb239},
	{0x87d0, 0xb23a},
	{0x87d1, 0xb23b},
	{0x87d2, 0xb23d},
	{0x87d3, 0xb23e},
	{0x87d4, 0xb23f},
	{0x87d5, 0xb240},
	{0x87d6, 0xb241},
	{0x87d7, 0xb242},
	{0x87d8, 0xb243},
	{0x87d9, 0xb244},
	{0x87da, 0xb245},
	{0x87db, 0xb246},
	{0x87dc, 0xb247},
	{0x87dd, 0xb248},
	{0x87de, 0xb249},
	{0x87df, 0xb24a},
	{0x87e0, 0xb24b},
	{0x87e1, 0xb24c},
	{0x87e2, 0xb24d},
	{0x87e3, 0xb24e},
	{0x87e4, 0xb24f},
	{0x87e5, 0xb250},
	{0x87e6, 0xb251},
	{0x87e7, 0xb252},
	{0x87e8, 0xb253},
	{0x87e9, 0xb254},
	{0x87ea, 0xb255},
	{0x87eb, 0xb256},
	{0x87ec, 0xb257},
	{0x87ed, 0xb259},
	{0x87ee, 0xb25a},
	{0x87ef, 0xb25b},
	{0x87f0, 0xb25d},
	{0x87f1, 0xb25e},
	{0x87f2, 0xb25f},
	{0x87f3, 0xb261},
	{0x87f4, 0xb262},
	{0x87f5, 0xb263},
	{0x87f6, 0xb264},
	{0x87f7, 0xb265},
	{0x87f8, 0xb266},
	{0x87f9, 0xb267},
	{0x87fa, 0xb26a},
	{0x87fb, 0xb26b},
	{0x87fc, 0xb26c},
	{0x87fd, 0xb26d},
	{0x87fe, 0xb26e},
	{0x8841, 0xb26f},
	{0x8842, 0xb270},
	{0x8843, 0xb271},
	{0x8844, 0xb272},
	{0x8845, 0xb273},
	{0x8846, 0xb276},
	{0x8847, 0xb277},
	{0x8848, 0xb278},
	{0x8849, 0xb279},
	{0x884a, 0xb27a},
	{0x884b, 0xb27b},
	{0x884c, 0xb27d},
	{0x884d, 0xb27e},
	{0x884e, 0xb27f},
	{0x884f, 0xb280},
	{0x8850, 0xb281},
	{0x8851, 0xb282},
	{0x8852, 0xb283},
	{0x8853, 0xb286},
	{0x8854, 0xb287},
	{0x8855, 0xb288},
	{0x8856, 0xb28a},
	{0x8857, 0xb28b},
	{0x8858, 0xb28c},
	{0x8859, 0xb28d},
	{0x885a, 0xb28e},
	{0x8861, 0xb28f},
	{0x8862, 0xb292},
	{0x8863, 0xb293},
	{0x8864, 0xb295},
	{0x8865, 0xb296},
	{0x8866, 0xb297},
	{0x8867, 0xb29b},
	{0x8868, 0xb29c},
	{0x8869, 0xb29d},
	{0x886a, 0xb29e},
	{0x886b, 0xb29f},
	{0x886c, 0xb2a2},
	{0x886d, 0xb2a4},
	{0x886e, 0xb2a7},
	{0x886f, 0xb2a8},
	{0x8870, 0xb2a9},
	{0x8871, 0xb2ab},
	{0x8872, 0xb2ad},
	{0x8873, 0xb2ae},
	{0x8874, 0xb2af},
	{0x8875, 0xb2b1},
	{0x8876, 0xb2b2},
	{0x8877, 0xb2b3},
	{0x8878, 0xb2b5},
	{0x8879, 0xb2b6},
	{0x887a, 0xb2b7},
	{0x8881, 0xb2b8},
	{0x8882, 0xb2b9},
	{0x8883, 0xb2ba},
	{0x8884, 0xb2bb},
	{0x8885, 0xb2bc},
	{0x8886, 0xb2bd},
	{0x8887, 0xb2be},
	{0x8888, 0xb2bf},
	{0x8889, 0xb2c0},
	{0x888a, 0xb2c1},
	{0x888b, 0xb2c2},
	{0x888c, 0xb2c3},
	{0x888d, 0xb2c4},
	{0x888e, 0xb2c5},
	{0x888f, 0xb2c6},
	{0x8890, 0xb2c7},
	{0x8891, 0xb2ca},
	{0x8892, 0xb2cb},
	{0x8893, 0xb2cd},
	{0x8894, 0xb2ce},
	{0x8895, 0xb2cf},
	{0x8896, 0xb2d1},
	{0x8897, 0xb2d3},
	{0x8898, 0xb2d4},
	{0x8899, 0xb2d5},
	{0x889a, 0xb2d6},
	{0x889b, 0xb2d7},
	{0x889c, 0xb2da},
	{0x889d, 0xb2dc},
	{0x889e, 0xb2de},
	{0x889f, 0xb2df},
	{0x88a0, 0xb2e0},
	{0x88a1, 0xb2e1},
	{0x88a2, 0xb2e3},
	{0x88a3, 0xb2e7},
	{0x88a4, 0xb2e9},
	{0x88a5, 0xb2ea},
	{0x88a6, 0xb2f0},
	{0x88a7, 0xb2f1},
	{0x88a8, 0xb2f2},
	{0x88a9, 0xb2f6},
	{0x88aa, 0xb2fc},
	{0x88ab, 0xb2fd},
	{0x88ac, 0xb2fe},
	{0x88ad, 0xb302},
	{0x88ae, 0xb303},
	{0x88af, 0xb305},
	{0x88b0, 0xb306},
	{0x88b1, 0xb307},
	{0x88b2, 0xb309},
	{0x88b3, 0xb30a},
	{0x88b4, 0xb30b},
	{0x88b5, 0xb30c},
	{0x88b6, 0xb30d},
	{0x88b7, 0xb30e},
	{0x88b8, 0xb30f},
	{0x88b9, 0xb312},
	{0x88ba, 0xb316},
	{0x88bb, 0xb317},
	{0x88bc, 0xb318},
	{0x88bd, 0xb319},
	{0x88be, 0xb31a},
	{0x88bf, 0xb31b},
	{0x88c0, 0xb31d},
	{0x88c1, 0xb31e},
	{0x88c2, 0xb31f},
	{0x88c3, 0xb320},
	{0x88c4, 0xb321},
	{0x88c5, 0xb322},
	{0x88c6, 0xb323},
	{0x88c7, 0xb324},
	{0x88c8, 0xb325},
	{0x88c9, 0xb326},
	{0x88ca, 0xb327},
	{0x88cb, 0xb328},
	{0x88cc, 0xb329},
	{0x88cd, 0xb32a},
	{0x88ce, 0xb32b},
	{0x88cf, 0xb32c},
	{0x88d0, 0xb32d},
	{0x88d1, 0xb32e},
	{0x88d2, 0xb32f},
	{0x88d3, 0xb330},
	{0x88d4, 0xb331},
	{0x88d5, 0xb332},
	{0x88d6, 0xb333},
	{0x88d7, 0xb334},
	{0x88d8, 0xb335},
	{0x88d9, 0xb336},
	{0x88da, 0xb337},
	{0x88db, 0xb338},
	{0x88dc, 0xb339},
	{0x88dd, 0xb33a},
	{0x88de, 0xb33b},
	{0x88df, 0xb33c},
	{0x88e0, 0xb33d},
	{0x88e1, 0xb33e},
	{0x88e2, 0xb33f},
	{0x88e3, 0xb340},
	{0x88e4, 0xb341},
	{0x88e5, 0xb342},
	{0x88e6, 0xb343},
	{0x88e7, 0xb344},
	{0x88e8, 0xb345},
	{0x88e9, 0xb346},
	{0x88ea, 0xb347},
	{0x88eb, 0xb348},
	{0x88ec, 0xb349},
	{0x88ed, 0xb34a},
	{0x88ee, 0xb34b},
	{0x88ef, 0xb34c},
	{0x88f0, 0xb34d},
	{0x88f1, 0xb34e},
	{0x88f2, 0xb34f},
	{0x88f3, 0xb350},
	{0x88f4, 0xb351},
	{0x88f5, 0xb352},
	{0x88f6, 0xb353},
	{0x88f7, 0xb357},
	{0x88f8, 0xb359},
	{0x88f9, 0xb35a},
	{0x88fa, 0xb35d},
	{0x88fb, 0xb360},
	{0x88fc, 0xb361},
	{0x88fd, 0xb362},
	{0x88fe, 0xb363},
	{0x8941, 0xb366},
	{0x8942, 0xb368},
	{0x8943, 0xb36a},
	{0x8944, 0xb36c},
	{0x8945, 0xb36d},
	{0x8946, 0xb36f},
	{0x8947, 0xb372},
	{0x8948, 0xb373},
	{0x8949, 0xb375},
	{0x894a, 0xb376},
	{0x894b, 0xb377},
	{0x894c, 0xb379},
	{0x894d, 0xb37a},
	{0x894e, 0xb37b},
	{0x894f, 0xb37c},
	{0x8950, 0xb37d},
	{0x8951, 0xb37e},
	{0x8952, 0xb37f},
	{0x8953, 0xb382},
	{0x8954, 0xb386},
	{0x8955, 0xb387},
	{0x8956, 0xb388},
	{0x8957, 0xb389},
	{0x8958, 0xb38a},
	{0x8959, 0xb38b},
	{0x895a, 0xb38d},
	{0x8961, 0xb38e},
	{0x8962, 0xb38f},
	{0x8963, 0xb391},
	{0x8964, 0xb392},
	{0x8965, 0xb393},
	{0x8966, 0xb395},
	{0x8967, 0xb396},
	{0x8968, 0xb397},
	{0x8969, 0xb398},
	{0x896a, 0xb399},
	{0x896b, 0xb39a},
	{0x896c, 0xb39b},
	{0x896d, 0xb39c},
	{0x896e, 0xb39d},
	{0x896f, 0xb39e},
	{0x8970, 0xb39f},
	{0x8971, 0xb3a2},
	{0x8972, 0xb3a3},
	{0x8973, 0xb3a4},
	{0x8974, 0xb3a5},
	{0x8975, 0xb3a6},
	{0x8976, 0xb3a7},
	{0x8977, 0xb3a9},
	{0x8978, 0xb3aa},
	{0x8979, 0xb3ab},
	{0x897a, 0xb3ad},
	{0x8981, 0xb3ae},
	{0x8982, 0xb3af},
	{0x8983, 0xb3b0},
	{0x8984, 0xb3b1},
	{0x8985, 0xb3b2},
	{0x8986, 0xb3b3},
	{0x8987, 0xb3b4},
	{0x8988, 0xb3b5},
	{0x8989, 0xb3b6},
	{0x898a, 0xb3b7},
	{0x898b, 0xb3b8},
	{0x898c, 0xb3b9},
	{0x898d, 0xb3ba},
	{0x898e, 0xb3bb},
	{0x898f, 0xb3bc},
	{0x8990, 0xb3bd},
	{0x8991, 0xb3be},
	{0x8992, 0xb3bf},
	{0x8993, 0xb3c0},
	{0x8994, 0xb3c1},
	{0x8995, 0xb3c2},
	{0x8996, 0xb3c3},
	{0x8997, 0xb3c6},
	{0x8998, 0xb3c7},
	{0x8999, 0xb3c9},
	{0x899a, 0xb3ca},
	{0x899b, 0xb3cd},
	{0x899c, 0xb3cf},
	{0x899d, 0xb3d1},
	{0x899e, 0xb3d2},
	{0x899f, 0xb3d3},
	{0x89a0, 0xb3d6},
	{0x89a1, 0xb3d8},
	{0x89a2, 0xb3da},
	{0x89a3, 0xb3dc},
	{0x89a4, 0xb3de},
	{0x89a5, 0xb3df},
	{0x89a6, 0xb3e1},
	{0x89a7, 0xb3e2},
	{0x89a8, 0xb3e3},
	{0x89a9, 0xb3e5},
	{0x89aa, 0xb3e6},
	{0x89ab, 0xb3e7},
	{0x89ac, 0xb3e9},
	{0x89ad, 0xb3ea},
	{0x89ae, 0xb3eb},
	{0x89af, 0xb3ec},
	{0x89b0, 0xb3ed},
	{0x89b1, 0xb3ee},
	{0x89b2, 0xb3ef},
	{0x89b3, 0xb3f0},
	{0x89b4, 0xb3f1},
	{0x89b5, 0xb3f2},
	{0x89b6, 0xb3f3},
	{0x89b7, 0xb3f4},
	{0x89b8, 0xb3f5},
	{0x89b9, 0xb3f6},
	{0x89ba, 0xb3f7},
	{0x89bb, 0xb3f8},
	{0x89bc, 0xb3f9},
	{0x89bd, 0xb3fa},
	{0x89be, 0xb3fb},
	{0x89bf, 0xb3fd},
	{0x89c0, 0xb3fe},
	{0x89c1, 0xb3ff},
	{0x89c2, 0xb400},
	{0x89c3, 0xb401},
	{0x89c4, 0xb402},
	{0x89c5, 0xb403},
	{0x89c6, 0xb404},
	{0x89c7, 0xb405},
	{0x89c8, 0xb406},
	{0x89c9, 0xb407},
	{0x89ca, 0xb408},
	{0x89cb, 0xb409},
	{0x89cc, 0xb40a},
	{0x89cd, 0xb40b},
	{0x89ce, 0xb40c},
	{0x89cf, 0xb40d},
	{0x89d0, 0xb40e},
	{0x89d1, 0xb40f},
	{0x89d2, 0xb411},
	{0x89d3, 0xb412},
	{0x89d4, 0xb413},
	{0x89d5, 0xb414},
	{0x89d6, 0xb415},
	{0x89d7, 0xb416},
	{0x89d8, 0xb417},
	{0x89d9, 0xb419},
	{0x89da, 0xb41a},
	{0x89db, 0xb41b},
	{0x89dc, 0xb41d},
	{0x89dd, 0xb41e},
	{0x89de, 0xb41f},
	{0x89df, 0xb421},
	{0x89e0, 0xb422},
	{0x89e1, 0xb423},
	{0x89e2, 0xb424},
	{0x89e3, 0xb425},
	{0x89e4, 0xb426},
	{0x89e5, 0xb427},
	{0x89e6, 0xb42a},
	{0x89e7, 0xb42c},
	{0x89e8, 0xb42d},
	{0x89e9, 0xb42e},
	{0x89ea, 0xb42f},
	{0x89eb, 0xb430},
	{0x89ec, 0xb431},
	{0x89ed, 0xb432},
	{0x89ee, 0xb433},
	{0x89ef, 0xb435},
	{0x89f0, 0xb436},
	{0x89f1, 0xb437},
	{0x89f2, 0xb438},
	{0x89f3, 0xb439},
	{0x89f4, 0xb43a},
	{0x89f5, 0xb43b},
	{0x89f6, 0xb43c},
	{0x89f7, 0xb43d},
	{0x89f8, 0xb43e},
	{0x89f9, 0xb43f},
	{0x89fa, 0xb440},
	{0x89fb, 0xb441},
	{0x89fc, 0xb442},
	{0x89fd, 0xb443},
	{0x89fe, 0xb444},
	{0x8a41, 0xb445},
	{0x8a42, 0xb446},
	{0x8a43, 0xb447},
	{0x8a44, 0xb448},
	{0x8a45, 0xb449},
	{0x8a46, 0xb44a},
	{0x8a47, 0xb44b},
	{0x8a48, 0xb44c},
	{0x8a49, 0xb44d},
	{0x8a4a, 0xb44e},
	{0x8a4b, 0xb44f},
	{0x8a4c, 0xb452},
	{0x8a4d, 0xb453},
	{0x8a4e, 0xb455},
	{0x8a4f, 0xb456},
	{0x8a50, 0xb457},
	{0x8a51, 0xb459},
	{0x8a52, 0xb45a},
	{0x8a53, 0xb45b},
	{0x8a54, 0xb45c},
	{0x8a55, 0xb45d},
	{0x8a56, 0xb45e},
	{0x8a57, 0xb45f},
	{0x8a58, 0xb462},
	{0x8a59, 0xb464},
	{0x8a5a, 0xb466},
	{0x8a61, 0xb467},
	{0x8a62, 0xb468},
	{0x8a63, 0xb469},
	{0x8a64, 0xb46a},
	{0x8a65, 0xb46b},
	{0x8a66, 0xb46d},
	{0x8a67, 0xb46e},
	{0x8a68, 0xb46f},
	{0x8a69, 0xb470},
	{0x8a6a, 0xb471},
	{0x8a6b, 0xb472},
	{0x8a6c, 0xb473},
	{0x8a6d, 0xb474},
	{0x8a6e, 0xb475},
	{0x8a6f, 0xb476},
	{0x8a70, 0xb477},
	{0x8a71, 0xb478},
	{0x8a72, 0xb479},
	{0x8a73, 0xb47a},
	{0x8a74, 0xb47b},
	{0x8a75, 0xb47c},
	{0x8a76, 0xb47d},
	{0x8a77, 0xb47e},
	{0x8a78, 0xb47f},
	{0x8a79, 0xb481},
	{0x8a7a, 0xb482},
	{0x8a81, 0xb483},
	{0x8a82, 0xb484},
	{0x8a83, 0xb485},
	{0x8a84, 0xb486},
	{0x8a85, 0xb487},
	{0x8a86, 0xb489},
	{0x8a87, 0xb48a},
	{0x8a88, 0xb48b},
	{0x8a89, 0xb48c},
	{0x8a8a, 0xb48d},
	{0x8a8b, 0xb48e},
	{0x8a8c, 0xb48f},
	{0x8a8d, 0xb490},
	{0x8a8e, 0xb491},
	{0x8a8f, 0xb492},
	{0x8a90, 0xb493},
	{0x8a91, 0xb494},
	{0x8a92, 0xb495},
	{0x8a93, 0xb496},
	{0x8a94, 0xb497},
	{0x8a95, 0xb498},
	{0x8a96, 0xb499},
	{0x8a97, 0xb49a},
	{0x8a98, 0xb49b},
	{0x8a99, 0xb49c},
	{0x8a9a, 0xb49e},
	{0x8a9b, 0xb49f},
	{0x8a9c, 0xb4a0},
	{0x8a9d, 0xb4a1},
	{0x8a9e, 0xb4a2},
	{0x8a9f, 0xb4a3},
	{0x8aa0, 0xb4a5},
	{0x8aa1, 0xb4a6},
	{0x8aa2, 0xb4a7},
	{0x8aa3, 0xb4a9},
	{0x8aa4, 0xb4aa},
	{0x8aa5, 0xb4ab},
	{0x8aa6, 0xb4ad},
	{0x8aa7, 0xb4ae},
	{0x8aa8, 0xb4af},
	{0x8aa9, 0xb4b0},
	{0x8aaa, 0xb4b1},
	{0x8aab, 0xb4b2},
	{0x8aac, 0xb4b3},
	{0x8aad, 0xb4b4},
	{0x8aae, 0xb4b6},
	{0x8aaf, 0xb4b8},
	{0x8ab0, 0xb4ba},
	{0x8ab1, 0xb4bb},
	{0x8ab2, 0xb4bc},
	{0x8ab3, 0xb4bd},
	{0x8ab4, 0xb4be},
	{0x8ab5, 0xb4bf},
	{0x8ab6, 0xb4c1},
	{0x8ab7, 0xb4c2},
	{0x8ab8, 0xb4c3},
	{0x8ab9, 0xb4c5},
	{0x8aba, 0xb4c6},
	{0x8abb, 0xb4c7},
	{0x8abc, 0xb4c9},
	{0x8abd, 0xb4ca},
	{0x8abe, 0xb4cb},
	{0x8abf, 0xb4cc},
	{0x8ac0, 0xb4cd},
	{0x8ac1, 0xb4ce},
	{0x8ac2, 0xb4cf},
	{0x8ac3, 0xb4d1},
	{0x8ac4, 0xb4d2},
	{0x8ac5, 0xb4d3},
	{0x8ac6, 0xb4d4},
	{0x8ac7, 0xb4d6},
	{0x8ac8, 0xb4d7},
	{0x8ac9, 0xb4d8},
	{0x8aca, 0xb4d9},
	{0x8acb, 0xb4da},
	{0x8acc, 0xb4db},
	{0x8acd, 0xb4de},
	{0x8ace, 0xb4df},
	{0x8acf, 0xb4e1},
	{0x8ad0, 0xb4e2},
	{0x8ad1, 0xb4e5},
	{0x8ad2, 0xb4e7},
	{0x8ad3, 0xb4e8},
	{0x8ad4, 0xb4e9},
	{0x8ad5, 0xb4ea},
	{0x8ad6, 0xb4eb},
	{0x8ad7, 0xb4ee},
	{0x8ad8, 0xb4f0},
	{0x8ad9, 0xb4f2},
	{0x8ada, 0xb4f3},
	{0x8adb, 0xb4f4},
	{0x8adc, 0xb4f5},
	{0x8add, 0xb4f6},
	{0x8ade, 0xb4f7},
	{0x8adf, 0xb4f9},
	{0x8ae0, 0xb4fa},
	{0x8ae1, 0xb4fb},
	{0x8ae2, 0xb4fc},
	{0x8ae3, 0xb4fd},
	{0x8ae4, 0xb4fe},
	{0x8ae5, 0xb4ff},
	{0x8ae6, 0xb500},
	{0x8ae7, 0xb501},
	{0x8ae8, 0xb502},
	{0x8ae9, 0xb503},
	{0x8aea, 0xb504},
	{0x8aeb, 0xb505},
	{0x8aec, 0xb506},
	{0x8aed, 0xb507},
	{0x8aee, 0xb508},
	{0x8aef, 0xb509},
	{0x8af0, 0xb50a},
	{0x8af1, 0xb50b},
	{0x8af2, 0xb50c},
	{0x8af3, 0xb50d},
	{0x8af4, 0xb50e},
	{0x8af5, 0xb50f},
	{0x8af6, 0xb510},
	{0x8af7, 0xb511},
	{0x8af8, 0xb512},
	{0x8af9, 0xb513},
	{0x8afa, 0xb516},
	{0x8afb, 0xb517},
	{0x8afc, 0xb519},
	{0x8afd, 0xb51a},
	{0x8afe, 0xb51d},
	{0x8b41, 0xb51e},
	{0x8b42, 0xb51f},
	{0x8b43, 0xb520},
	{0x8b44, 0xb521},
	{0x8b45, 0xb522},
	{0x8b46, 0xb523},
	{0x8b47, 0xb526},
	{0x8b48, 0xb52b},
	{0x8b49, 0xb52c},
	{0x8b4a, 0xb52d},
	{0x8b4b, 0xb52e},
	{0x8b4c, 0xb52f},
	{0x8b4d, 0xb532},
	{0x8b4e, 0xb533},
	{0x8b4f, 0xb535},
	{0x8b50, 0xb536},
	{0x8b51, 0xb537},
	{0x8b52, 0xb539},
	{0x8b53, 0xb53a},
	{0x8b54, 0xb53b},
	{0x8b55, 0xb53c},
	{0x8b56, 0xb53d},
	{0x8b57, 0xb53e},
	{0x8b58, 0xb53f},
	{0x8b59, 0xb542},
	{0x8b5a, 0xb546},
	{0x8b61, 0xb547},
	{0x8b62, 0xb548},
	{0x8b63, 0xb549},
	{0x8b64, 0xb54a},
	{0x8b65, 0xb54e},
	{0x8b66, 0xb54f},
	{0x8b67, 0xb551},
	{0x8b68, 0xb552},
	{0x8b69, 0xb553},
	{0x8b6a, 0xb555},
	{0x8b6b, 0xb556},
	{0x8b6c, 0xb557},
	{0x8b6d, 0xb558},
	{0x8b6e, 0xb559},
	{0x8b6f, 0xb55a},
	{0x8b70, 0xb55b},
	{0x8b71, 0xb55e},
	{0x8b72, 0xb562},
	{0x8b73, 0xb563},
	{0x8b74, 0xb564},
	{0x8b75, 0xb565},
	{0x8b76, 0xb566},
	{0x8b77, 0xb567},
	{0x8b78, 0xb568},
	{0x8b79, 0xb569},
	{0x8b7a, 0xb56a},
	{0x8b81, 0xb56b},
	{0x8b82, 0xb56c},
	{0x8b83, 0xb56d},
	{0x8b84, 0xb56e},
	{0x8b85, 0xb56f},
	{0x8b86, 0xb570},
	{0x8b87, 0xb571},
	{0x8b88, 0xb572},
	{0x8b89, 0xb573},
	{0x8b8a, 0xb574},
	{0x8b8b, 0xb575},
	{0x8b8c, 0xb576},
	{0x8b8d, 0xb577},
	{0x8b8e, 0xb578},
	{0x8b8f, 0xb579},
	{0x8b90, 0xb57a},
	{0x8b91, 0xb57b},
	{0x8b92, 0xb57c},
	{0x8b93, 0xb57d},
	{0x8b94, 0xb57e},
	{0x8b95, 0xb57f},
	{0x8b96, 0xb580},
	{0x8b97, 0xb581},
	{0x8b98, 0xb582},
	{0x8b99, 0xb583},
	{0x8b9a, 0xb584},
	{0x8b9b, 0xb585},
	{0x8b9c, 0xb586},
	{0x8b9d, 0xb587},
	{0x8b9e, 0xb588},
	{0x8b9f, 0xb589},
	{0x8ba0, 0xb58a},
	{0x8ba1, 0xb58b},
	{0x8ba2, 0xb58c},
	{0x8ba3, 0xb58d},
	{0x8ba4, 0xb58e},
	{0x8ba5, 0xb58f},
	{0x8ba6, 0xb590},
	{0x8ba7, 0xb591},
	{0x8ba8, 0xb592},
	{0x8ba9, 0xb593},
	{0x8baa, 0xb594},
	{0x8bab, 0xb595},
	{0x8bac, 0xb596},
	{0x8bad, 0xb597},
	{0x8bae, 0xb598},
	{0x8baf, 0xb599},
	{0x8bb0, 0xb59a},
	{0x8bb1, 0xb59b},
	{0x8bb2, 0xb59c},
	{0x8bb3, 0xb59d},
	{0x8bb4, 0xb59e},
	{0x8bb5, 0xb59f},
	{0x8bb6, 0xb5a2},
	{0x8bb7, 0xb5a3},
	{0x8bb8, 0xb5a5},
	{0x8bb9, 0xb5a6},
	{0x8bba, 0xb5a7},
	{0x8bbb, 0xb5a9},
	{0x8bbc, 0xb5ac},
	{0x8bbd, 0xb5ad},
	{0x8bbe, 0xb5ae},
	{0x8bbf, 0xb5af},
	{0x8bc0, 0xb5b2},
	{0x8bc1, 0xb5b6},
	{0x8bc2, 0xb5b7},
	{0x8bc3, 0xb5b8},
	{0x8bc4, 0xb5b9},
	{0x8bc5, 0xb5ba},
	{0x8bc6, 0xb5be},
	{0x8bc7, 0xb5bf},
	{0x8bc8, 0xb5c1},
	{0x8bc9, 0xb5c2},
	{0x8bca, 0xb5c3},
	{0x8bcb, 0xb5c5},
	{0x8bcc, 0xb5c6},
	{0x8bcd, 0xb5c7},
	{0x8bce, 0xb5c8},
	{0x8bcf, 0xb5c9},
	{0x8bd0, 0xb5ca},
	{0x8bd1, 0xb5cb},
	{0x8bd2, 0xb5ce},
	{0x8bd3, 0xb5d2},
	{0x8bd4, 0xb5d3},
	{0x8bd5, 0xb5d4},
	{0x8bd6, 0xb5d5},
	{0x8bd7, 0xb5d6},
	{0x8bd8, 0xb5d7},
	{0x8bd9, 0xb5d9},
	{0x8bda, 0xb5da},
	{0x8bdb, 0xb5db},
	{0x8bdc, 0xb5dc},
	{0x8bdd, 0xb5dd},
	{0x8bde, 0xb5de},
	{0x8bdf, 0xb5df},
	{0x8be0, 0xb5e0},
	{0x8be1, 0xb5e1},
	{0x8be2, 0xb5e2},
	{0x8be3, 0xb5e3},
	{0x8be4, 0xb5e4},
	{0x8be5, 0xb5e5},
	{0x8be6, 0xb5e6},
	{0x8be7, 0xb5e7},
	{0x8be8, 0xb5e8},
	{0x8be9, 0xb5e9},
	{0x8bea, 0xb5ea},
	{0x8beb, 0xb5eb},
	{0x8bec, 0xb5ed},
	{0x8bed, 0xb5ee},
	{0x8bee, 0xb5ef},
	{0x8bef, 0xb5f0},
	{0x8bf0, 0xb5f1},
	{0x8bf1, 0xb5f2},
	{0x8bf2, 0xb5f3},
	{0x8bf3, 0xb5f4},
	{0x8bf4, 0xb5f5},
	{0x8bf5, 0xb5f6},
	{0x8bf6, 0xb5f7},
	{0x8bf7, 0xb5f8},
	{0x8bf8, 0xb5f9},
	{0x8bf9, 0xb5fa},
	{0x8bfa, 0xb5fb},
	{0x8bfb, 0xb5fc},
	{0x8bfc, 0xb5fd},
	{0x8bfd, 0xb5fe},
	{0x8bfe, 0xb5ff},
	{0x8c41, 0xb600},
	{0x8c42, 0xb601},
	{0x8c43, 0xb602},
	{0x8c44, 0xb603},
	{0x8c45, 0xb604},
	{0x8c46, 0xb605},
	{0x8c47, 0xb606},
	{0x8c48, 0xb607},
	{0x8c49, 0xb608},
	{0x8c4a, 0xb609},
	{0x8c4b, 0xb60a},
	{0x8c4c, 0xb60b},
	{0x8c4d, 0xb60c},
	{0x8c4e, 0xb60d},
	{0x8c4f, 0xb60e},
	{0x8c50, 0xb60f},
	{0x8c51, 0xb612},
	{0x8c52, 0xb613},
	{0x8c53, 0xb615},
	{0x8c54, 0xb616},
	{0x8c55, 0xb617},
	{0x8c56, 0xb619},
	{0x8c57, 0xb61a},
	{0x8c58, 0xb61b},
	{0x8c59, 0xb61c},
	{0x8c5a, 0xb61d},
	{0x8c61, 0xb61e},
	{0x8c62, 0xb61f},
	{0x8c63, 0xb620},
	{0x8c64, 0xb621},
	{0x8c65, 0xb622},
	{0x8c66, 0xb623},
	{0x8c67, 0xb624},
	{0x8c68, 0xb626},
	{0x8c69, 0xb627},
	{0x8c6a, 0xb628},
	{0x8c6b, 0xb629},
	{0x8c6c, 0xb62a},
	{0x8c6d, 0xb62b},
	{0x8c6e, 0xb62d},
	{0x8c6f, 0xb62e},
	{0x8c70, 0xb62f},
	{0x8c71, 0xb630},
	{0x8c72, 0xb631},
	{0x8c73, 0xb632},
	{0x8c74, 0xb633},
	{0x8c75, 0xb635},
	{0x8c76, 0xb636},
	{0x8c77, 0xb637},
	{0x8c78, 0xb638},
	{0x8c79, 0xb639},
	{0x8c7a, 0xb63a},
	{0x8c81, 0xb63b},
	{0x8c82, 0xb63c},
	{0x8c83, 0xb63d},
	{0x8c84, 0xb63e},
	{0x8c85, 0xb63f},
	{0x8c86, 0xb640},
	{0x8c87, 0xb641},
	{0x8c88, 0xb642},
	{0x8c89, 0xb643},
	{0x8c8a, 0xb644},
	{0x8c8b, 0xb645},
	{0x8c8c, 0xb646},
	{0x8c8d, 0xb647},
	{0x8c8e, 0xb649},
	{0x8c8f, 0xb64a},
	{0x8c90, 0xb64b},
	{0x8c91, 0xb64c},
	{0x8c92, 0xb64d},
	{0x8c93, 0xb64e},
	{0x8c94, 0xb64f},
	{0x8c95, 0xb650},
	{0x8c96, 0xb651},
	{0x8c97, 0xb652},
	{0x8c98, 0xb653},
	{0x8c99, 0xb654},
	{0x8c9a, 0xb655},
	{0x8c9b, 0xb656},
	{0x8c9c, 0xb657},
	{0x8c9d, 0xb658},
	{0x8c9e, 0xb659},
	{0x8c9f, 0xb65a},
	{0x8ca0, 0xb65b},
	{0x8ca1, 0xb65c},
	{0x8ca2, 0xb65d},
	{0x8ca3, 0xb65e},
	{0x8ca4, 0xb65f},
	{0x8ca5, 0xb660},
	{0x8ca6, 0xb661},
	{0x8ca7, 0xb662},
	{0x8ca8, 0xb663},
	{0x8ca9, 0xb665},
	{0x8caa, 0xb666},
	{0x8cab, 0xb667},
	{0x8cac, 0xb669},
	{0x8cad, 0xb66a},
	{0x8cae, 0xb66b},
	{0x8caf, 0xb66c},
	{0x8cb0, 0xb66d},
	{0x8cb1, 0xb66e},
	{0x8cb2, 0xb66f},
	{0x8cb3, 0xb670},
	{0x8cb4, 0xb671},
	{0x8cb5, 0xb672},
	{0x8cb6, 0xb673},
	{0x8cb7, 0xb674},
	{0x8cb8, 0xb675},
	{0x8cb9, 0xb676},
	{0x8cba, 0xb677},
	{0x8cbb, 0xb678},
	{0x8cbc, 0xb679},
	{0x8cbd, 0xb67a},
	{0x8cbe, 0xb67b},
	{0x8cbf, 0xb67c},
	{0x8cc0, 0xb67d},
	{0x8cc1, 0xb67e},
	{0x8cc2, 0xb67f},
	{0x8cc3, 0xb680},
	{0x8cc4, 0xb681},
	{0x8cc5, 0xb682},
	{0x8cc6, 0xb683},
	{0x8cc7, 0xb684},
	{0x8cc8, 0xb685},
	{0x8cc9, 0xb686},
	{0x8cca, 0xb687},
	{0x8ccb, 0xb688},
	{0x8ccc, 0xb689},
	{0x8ccd, 0xb68a},
	{0x8cce, 0xb68b},
	{0x8ccf, 0xb68c},
	{0x8cd0, 0xb68d},
	{0x8cd1, 0xb68e},
	{0x8cd2, 0xb68f},
	{0x8cd3, 0xb690},
	{0x8cd4, 0xb691},
	{0x8cd5, 0xb692},
	{0x8cd6, 0xb693},
	{0x8cd7, 0xb694},
	{0x8cd8, 0xb695},
	{0x8cd9, 0xb696},
	{0x8cda, 0xb697},
	{0x8cdb, 0xb698},
	{0x8cdc, 0xb699},
	{0x8cdd, 0xb69a},
	{0x8cde, 0xb69b},
	{0x8cdf, 0xb69e},
	{0x8ce0, 0xb69f},
	{0x8ce1, 0xb6a1},
	{0x8ce2, 0xb6a2},
	{0x8ce3, 0xb6a3},
	{0x8ce4, 0xb6a5},
	{0x8ce5, 0xb6a6},
	{0x8ce6, 0xb6a7},
	{0x8ce7, 0xb6a8},
	{0x8ce8, 0xb6a9},
	{0x8ce9, 0xb6aa},
	{0x8cea, 0xb6ad},
	{0x8ceb, 0xb6ae},
	{0x8cec, 0xb6af},
	{0x8ced, 0xb6b0},
	{0x8cee, 0xb6b2},
	{0x8cef, 0xb6b3},
	{0x8cf0, 0xb6b4},
	{0x8cf1, 0xb6b5},
	{0x8cf2, 0xb6b6},
	{0x8cf3, 0xb6b7},
	{0x8cf4, 0xb6b8},
	{0x8cf5, 0xb6b9},
	{0x8cf6, 0xb6ba},
	{0x8cf7, 0xb6bb},
	{0x8cf8, 0xb6bc},
	{0x8cf9, 0xb6bd},
	{0x8cfa, 0xb6be},
	{0x8cfb, 0xb6bf},
	{0x8cfc, 0xb6c0},
	{0x8cfd, 0xb6c1},
	{0x8cfe, 0xb6c2},
	{0x8d41, 0xb6c3},
	{0x8d42, 0xb6c4},
	{0x8d43, 0xb6c5},
	{0x8d44, 0xb6c6},
	{0x8d45, 0xb6c7},
	{0x8d46, 0xb6c8},
	{0x8d47, 0xb6c9},
	{0x8d48, 0xb6ca},
	{0x8d49, 0xb6cb},
	{0x8d4a, 0xb6cc},
	{0x8d4b, 0xb6cd},
	{0x8d4c, 0xb6ce},
	{0x8d4d, 0xb6cf},
	{0x8d4e, 0xb6d0},
	{0x8d4f, 0xb6d1},
	{0x8d50, 0xb6d2},
	{0x8d51, 0xb6d3},
	{0x8d52, 0xb6d5},
	{0x8d53, 0xb6d6},
	{0x8d54, 0xb6d7},
	{0x8d55, 0xb6d8},
	{0x8d56, 0xb6d9},
	{0x8d57, 0xb6da},
	{0x8d58, 0xb6db},
	{0x8d59, 0xb6dc},
	{0x8d5a, 0xb6dd},
	{0x8d61, 0xb6de},
	{0x8d62, 0xb6df},
	{0x8d63, 0xb6e0},
	{0x8d64, 0xb6e1},
	{0x8d65, 0xb6e2},
	{0x8d66, 0xb6e3},
	{0x8d67, 0xb6e4},
	{0x8d68, 0xb6e5},
	{0x8d69, 0xb6e6},
	{0x8d6a, 0xb6e7},
	{0x8d6b, 0xb6e8},
	{0x8d6c, 0xb6e9},
	{0x8d6d, 0xb6ea},
	{0x8d6e, 0xb6eb},
	{0x8d6f, 0xb6ec},
	{0x8d70, 0xb6ed},
	{0x8d71, 0xb6ee},
	{0x8d72, 0xb6ef},
	{0x8d73, 0xb6f1},
	{0x8d74, 0xb6f2},
	{0x8d75, 0xb6f3},
	{0x8d76, 0xb6f5},
	{0x8d77, 0xb6f6},
	{0x8d78, 0xb6f7},
	{0x8d79, 0xb6f9},
	{0x8d7a, 0xb6fa},
	{0x8d81, 0xb6fb},
	{0x8d82, 0xb6fc},
	{0x8d83, 0xb6fd},
	{0x8d84, 0xb6fe},
	{0x8d85, 0xb6ff},
	{0x8d86, 0xb702},
	{0x8d87, 0xb703},
	{0x8d88, 0xb704},
	{0x8d89, 0xb706},
	{0x8d8a, 0xb707},
	{0x8d8b, 0xb708},
	{0x8d8c, 0xb709},
	{0x8d8d, 0xb70a},
	{0x8d8e, 0xb70b},
	{0x8d8f, 0xb70c},
	{0x8d90, 0xb70d},
	{0x8d91, 0xb70e},
	{0x8d92, 0xb70f},
	{0x8d93, 0xb710},
	{0x8d94, 0xb711},
	{0x8d95, 0xb712},
	{0x8d96, 0xb713},
	{0x8d97, 0xb714},
	{0x8d98, 0xb715},
	{0x8d99, 0xb716},
	{0x8d9a, 0xb717},
	{0x8d9b, 0xb718},
	{0x8d9c, 0xb719},
	{0x8d9d, 0xb71a},
	{0x8d9e, 0xb71b},
	{0x8d9f, 0xb71c},
	{0x8da0, 0xb71d},
	{0x8da1, 0xb71e},
	{0x8da2, 0xb71f},
	{0x8da3, 0xb720},
	{0x8da4, 0xb721},
	{0x8da5, 0xb722},
	{0x8da6, 0xb723},
	{0x8da7, 0xb724},
	{0x8da8, 0xb725},
	{0x8da9, 0xb726},
	{0x8daa, 0xb727},
	{0x8dab, 0xb72a},
	{0x8dac, 0xb72b},
	{0x8dad, 0xb72d},
	{0x8dae, 0xb72e},
	{0x8daf, 0xb731},
	{0x8db0, 0xb732},
	{0x8db1, 0xb733},
	{0x8db2, 0xb734},
	{0x8db3, 0xb735},
	{0x8db4, 0xb736},
	{0x8db5, 0xb737},
	{0x8db6, 0xb73a},
	{0x8db7, 0xb73c},
	{0x8db8, 0xb73d},
	{0x8db9, 0xb73e},
	{0x8dba, 0xb73f},
	{0x8dbb, 0xb740},
	{0x8dbc, 0xb741},
	{0x8dbd, 0xb742},
	{0x8dbe, 0xb743},
	{0x8dbf, 0xb745},
	{0x8dc0, 0xb746},
	{0x8dc1, 0xb747},
	{0x8dc2, 0xb749},
	{0x8dc3, 0xb74a},
	{0x8dc4, 0xb74b},
	{0x8dc5, 0xb74d},
	{0x8dc6, 0xb74e},
	{0x8dc7, 0xb74f},
	{0x8dc8, 0xb750},
	{0x8dc9, 0xb751},
	{0x8dca, 0xb752},
	{0x8dcb, 0xb753},
	{0x8dcc, 0xb756},
	{0x8dcd, 0xb757},
	{0x8dce, 0xb758},
	{0x8dcf, 0xb759},
	{0x8dd0, 0xb75a},
	{0x8dd1, 0xb75b},
	{0x8dd2, 0xb75c},
	{0x8dd3, 0xb75d},
	{0x8dd4, 0xb75e},
	{0x8dd5, 0xb75f},
	{0x8dd6, 0xb761},
	{0x8dd7, 0xb762},
	{0x8dd8, 0xb763},
	{0x8dd9, 0xb765},
	{0x8dda, 0xb766},
	{0x8ddb, 0xb767},
	{0x8ddc, 0xb769},
	{0x8ddd, 0xb76a},
	{0x8dde, 0xb76b},
	{0x8ddf, 0xb76c},
	{0x8de0, 0xb76d},
	{0x8de1, 0xb76e},
	{0x8de2, 0xb76f},
	{0x8de3, 0xb772},
	{0x8de4, 0xb774},
	{0x8de5, 0xb776},
	{0x8de6, 0xb777},
	{0x8de7, 0xb778},
	{0x8de8, 0xb779},
	{0x8de9, 0xb77a},
	{0x8dea, 0xb77b},
	{0x8deb, 0xb77e},
	{0x8dec, 0xb77f},
	{0x8ded, 0xb781},
	{0x8dee, 0xb782},
	{0x8def, 0xb783},
	{0x8df0, 0xb785},
	{0x8df1, 0xb786},
	{0x8df2, 0xb787},
	{0x8df3, 0xb788},
	{0x8df4, 0xb789},
	{0x8df5, 0xb78a},
	{0x8df6, 0xb78b},
	{0x8df7, 0xb78e},
	{0x8df8, 0xb793},
	{0x8df9, 0xb794},
	{0x8dfa, 0xb795},
	{0x8dfb, 0xb79a},
	{0x8dfc, 0xb79b},
	{0x8dfd, 0xb79d},
	{0x8dfe, 0xb79e},
	{0x8e41, 0xb79f},
	{0x8e42, 0xb7a1},
	{0x8e43, 0xb7a2},
	{0x8e44, 0xb7a3},
	{0x8e45, 0xb7a4},
	{0x8e46, 0xb7a5},
	{0x8e47, 0xb7a6},
	{0x8e48, 0xb7a7},
	{0x8e49, 0xb7aa},
	{0x8e4a, 0xb7ae},
	{0x8e4b, 0xb7af},
	{0x8e4c, 0xb7b0},
	{0x8e4d, 0xb7b1},
	{0x8e4e, 0xb7b2},
	{0x8e4f, 0xb7b3},
	{0x8e50, 0xb7b6},
	{0x8e51, 0xb7b7},
	{0x8e52, 0xb7b9},
	{0x8e53, 0xb7ba},
	{0x8e54, 0xb7bb},
	{0x8e55, 0xb7bc},
	{0x8e56, 0xb7bd},
	{0x8e57, 0xb7be},
	{0x8e58, 0xb7bf},
	{0x8e59, 0xb7c0},
	{0x8e5a, 0xb7c1},
	{0x8e61, 0xb7c2},
	{0x8e62, 0xb7c3},
	{0x8e63, 0xb7c4},
	{0x8e64, 0xb7c5},
	{0x8e65, 0xb7c6},
	{0x8e66, 0xb7c8},
	{0x8e67, 0xb7ca},
	{0x8e68, 0xb7cb},
	{0x8e69, 0xb7cc},
	{0x8e6a, 0xb7cd},
	{0x8e6b, 0xb7ce},
	{0x8e6c, 0xb7cf},
	{0x8e6d, 0xb7d0},
	{0x8e6e, 0xb7d1},
	{0x8e6f, 0xb7d2},
	{0x8e70, 0xb7d3},
	{0x8e71, 0xb7d4},
	{0x8e72, 0xb7d5},
	{0x8e73, 0xb7d6},
	{0x8e74, 0xb7d7},
	{0x8e75, 0xb7d8},
	{0x8e76, 0xb7d9},
	{0x8e77, 0xb7da},
	{0x8e78, 0xb7db},
	{0x8e79, 0xb7dc},
	{0x8e7a, 0xb7dd},
	{0x8e81, 0xb7de},
	{0x8e82, 0xb7df},
	{0x8e83, 0xb7e0},
	{0x8e84, 0xb7e1},
	{0x8e85, 0xb7e2},
	{0x8e86, 0xb7e3},
	{0x8e87, 0xb7e4},
	{0x8e88, 0xb7e5},
	{0x8e89, 0xb7e6},
	{0x8e8a, 0xb7e7},
	{0x8e8b, 0xb7e8},
	{0x8e8c, 0xb7e9},
	{0x8e8d, 0xb7ea},
	{0x8e8e, 0xb7eb},
	{0x8e8f, 0xb7ee},
	{0x8e90, 0xb7ef},
	{0x8e91, 0xb7f1},
	{0x8e92, 0xb7f2},
	{0x8e93, 0xb7f3},
	{0x8e94, 0xb7f5},
	{0x8e95, 0xb7f6},
	{0x8e96, 0xb7f7},
	{0x8e97, 0xb7f8},
	{0x8e98, 0xb7f9},
	{0x8e99, 0xb7fa},
	{0x8e9a, 0xb7fb},
	{0x8e9b, 0xb7fe},
	{0x8e9c, 0xb802},
	{0x8e9d, 0xb803},
	{0x8e9e, 0xb804},
	{0x8e9f, 0xb805},
	{0x8ea0, 0xb806},
	{0x8ea1, 0xb80a},
	{0x8ea2, 0xb80b},
	{0x8ea3, 0xb80d},
	{0x8ea4, 0xb80e},
	{0x8ea5, 0xb80f},
	{0x8ea6, 0xb811},
	{0x8ea7, 0xb812},
	{0x8ea8, 0xb813},
	{0x8ea9, 0xb814},
	{0x8eaa, 0xb815},
	{0x8eab, 0xb816},
	{0x8eac, 0xb817},
	{0x8ead, 0xb81a},
	{0x8eae, 0xb81c},
	{0x8eaf, 0xb81e},
	{0x8eb0, 0xb81f},
	{0x8eb1, 0xb820},
	{0x8eb2, 0xb821},
	{0x8eb3, 0xb822},
	{0x8eb4, 0xb823},
	{0x8eb5, 0xb826},
	{0x8eb6, 0xb827},
	{0x8eb7, 0xb829},
	{0x8eb8, 0xb82a},
	{0x8eb9, 0xb82b},
	{0x8eba, 0xb82d},
	{0x8ebb, 0xb82e},
	{0x8ebc, 0xb82f},
	{0x8ebd, 0xb830},
	{0x8ebe, 0xb831},
	{0x8ebf, 0xb832},
	{0x8ec0, 0xb833},
	{0x8ec1, 0xb836},
	{0x8ec2, 0xb83a},
	{0x8ec3, 0xb83b},
	{0x8ec4, 0xb83c},
	{0x8ec5, 0xb83d},
	{0x8ec6, 0xb83e},
	{0x8ec7, 0xb83f},
	{0x8ec8, 0xb841},
	{0x8ec9, 0xb842},
	{0x8eca, 0xb843},
	{0x8ecb, 0xb845},
	{0x8ecc, 0xb846},
	{0x8ecd, 0xb847},
	{0x8ece, 0xb848},
	{0x8ecf, 0xb849},
	{0x8ed0, 0xb84a},
	{0x8ed1, 0xb84b},
	{0x8ed2, 0xb84c},
	{0x8ed3, 0xb84d},
	{0x8ed4, 0xb84e},
	{0x8ed5, 0xb84f},
	{0x8ed6, 0xb850},
	{0x8ed7, 0xb852},
	{0x8ed8, 0xb854},
	{0x8ed9, 0xb855},
	{0x8eda, 0xb856},
	{0x8edb, 0xb857},
	{0x8edc, 0xb858},
	{0x8edd, 0xb859},
	{0x8ede, 0xb85a},
	{0x8edf, 0xb85b},
	{0x8ee0, 0xb85e},
	{0x8ee1, 0xb85f},
	{0x8ee2, 0xb861},
	{0x8ee3, 0xb862},
	{0x8ee4, 0xb863},
	{0x8ee5, 0xb865},
	{0x8ee6, 0xb866},
	{0x8ee7, 0xb867},
	{0x8ee8, 0xb868},
	{0x8ee9, 0xb869},
	{0x8eea, 0xb86a},
	{0x8eeb, 0xb86b},
	{0x8eec, 0xb86e},
	{0x8eed, 0xb870},
	{0x8eee, 0xb872},
	{0x8eef, 0xb873},
	{0x8ef0, 0xb874},
	{0x8ef1, 0xb875},
	{0x8ef2, 0xb876},
	{0x8ef3, 0xb877},
	{0x8ef4, 0xb879},
	{0x8ef5, 0xb87a},
	{0x8ef6, 0xb87b},
	{0x8ef7, 0xb87d},
	{0x8ef8, 0xb87e},
	{0x8ef9, 0xb87f},
	{0x8efa, 0xb880},
	{0x8efb, 0xb881},
	{0x8efc, 0xb882},
	{0x8efd, 0xb883},
	{0x8efe, 0xb884},
	{0x8f41, 0xb885},
	{0x8f42, 0xb886},
	{0x8f43, 0xb887},
	{0x8f44, 0xb888},
	{0x8f45, 0xb889},
	{0x8f46, 0xb88a},
	{0x8f47, 0xb88b},
	{0x8f48, 0xb88c},
	{0x8f49, 0xb88e},
	{0x8f4a, 0xb88f},
	{0x8f4b, 0xb890},
	{0x8f4c, 0xb891},
	{0x8f4d, 0xb892},
	{0x8f4e, 0xb893},
	{0x8f4f, 0xb894},
	{0x8f50, 0xb895},
	{0x8f51, 0xb896},
	{0x8f52, 0xb897},
	{0x8f53, 0xb898},
	{0x8f54, 0xb899},
	{0x8f55, 0xb89a},
	{0x8f56, 0xb89b},
	{0x8f57, 0xb89c},
	{0x8f58, 0xb89d},
	{0x8f59, 0xb89e},
	{0x8f5a, 0xb89f},
	{0x8f61, 0xb8a0},
	{0x8f62, 0xb8a1},
	{0x8f63, 0xb8a2},
	{0x8f64, 0xb8a3},
	{0x8f65, 0xb8a4},
	{0x8f66, 0xb8a5},
	{0x8f67, 0xb8a6},
	{0x8f68, 0xb8a7},
	{0x8f69, 0xb8a9},
	{0x8f6a, 0xb8aa},
	{0x8f6b, 0xb8ab},
	{0x8f6c, 0xb8ac},
	{0x8f6d, 0xb8ad},
	{0x8f6e, 0xb8ae},
	{0x8f6f, 0xb8af},
	{0x8f70, 0xb8b1},
	{0x8f71, 0xb8b2},
	{0x8f72, 0xb8b3},
	{0x8f73, 0xb8b5},
	{0x8f74, 0xb8b6},
	{0x8f75, 0xb8b7},
	{0x8f76, 0xb8b9},
	{0x8f77, 0xb8ba},
	{0x8f78, 0xb8bb},
	{0x8f79, 0xb8bc},
	{0x8f7a, 0xb8bd},
	{0x8f81, 0xb8be},
	{0x8f82, 0xb8bf},
	{0x8f83, 0xb8c2},
	{0x8f84, 0xb8c4},
	{0x8f85, 0xb8c6},
	{0x8f86, 0xb8c7},
	{0x8f87, 0xb8c8},
	{0x8f88, 0xb8c9},
	{0x8f89, 0xb8ca},
	{0x8f8a, 0xb8cb},
	{0x8f8b, 0xb8cd},
	{0x8f8c, 0xb8ce},
	{0x8f8d, 0xb8cf},
	{0x8f8e, 0xb8d1},
	{0x8f8f, 0xb8d2},
	{0x8f90, 0xb8d3},
	{0x8f91, 0xb8d5},
	{0x8f92, 0xb8d6},
	{0x8f93, 0xb8d7},
	{0x8f94, 0xb8d8},
	{0x8f95, 0xb8d9},
	{0x8f96, 0xb8da},
	{0x8f97, 0xb8db},
	{0x8f98, 0xb8dc},
	{0x8f99, 0xb8de},
	{0x8f9a, 0xb8e0},
	{0x8f9b, 0xb8e2},
	{0x8f9c, 0xb8e3},
	{0x8f9d, 0xb8e4},
	{0x8f9e, 0xb8e5},
	{0x8f9f, 0xb8e6},
	{0x8fa0, 0xb8e7},
	{0x8fa1, 0xb8ea},
	{0x8fa2, 0xb8eb},
	{0x8fa3, 0xb8ed},
	{0x8fa4, 0xb8ee},
	{0x8fa5, 0xb8ef},
	{0x8fa6, 0xb8f1},
	{0x8fa7, 0xb8f2},
	{0x8fa8, 0xb8f3},
	{0x8fa9, 0xb8f4},
	{0x8faa, 0xb8f5},
	{0x8fab, 0xb8f6},
	{0x8fac, 0xb8f7},
	{0x8fad, 0xb8fa},
	{0x8fae, 0xb8fc},
	{0x8faf, 0xb8fe},
	{0x8fb0, 0xb8ff},
	{0x8fb1, 0xb900},
	{0x8fb2, 0xb901},
	{0x8fb3, 0xb902},
	{0x8fb4, 0xb903},
	{0x8fb5, 0xb905},
	{0x8fb6, 0xb906},
	{0x8fb7, 0xb907},
	{0x8fb8, 0xb908},
	{0x8fb9, 0xb909},
	{0x8fba, 0xb90a},
	{0x8fbb, 0xb90b},
	{0x8fbc, 0xb90c},
	{0x8fbd, 0xb90d},
	{0x8fbe, 0xb90e},
	{0x8fbf, 0xb90f},
	{0x8fc0, 0xb910},
	{0x8fc1, 0xb911},
	{0x8fc2, 0xb912},
	{0x8fc3, 0xb913},
	{0x8fc4, 0xb914},
	{0x8fc5, 0xb915},
	{0x8fc6, 0xb916},
	{0x8fc7, 0xb917},
	{0x8fc8, 0xb919},
	{0x8fc9, 0xb91a},
	{0x8fca, 0xb91b},
	{0x8fcb, 0xb91c},
	{0x8fcc, 0xb91d},
	{0x8fcd, 0xb91e},
	{0x8fce, 0xb91f},
	{0x8fcf, 0xb921},
	{0x8fd0, 0xb922},
	{0x8fd1, 0xb923},
	{0x8fd2, 0xb924},
	{0x8fd3, 0xb925},
	{0x8fd4, 0xb926},
	{0x8fd5, 0xb927},
	{0x8fd6, 0xb928},
	{0x8fd7, 0xb929},
	{0x8fd8, 0xb92a},
	{0x8fd9, 0xb92b},
	{0x8fda, 0xb92c},
	{0x8fdb, 0xb92d},
	{0x8fdc, 0xb92e},
	{0x8fdd, 0xb92f},
	{0x8fde, 0xb930},
	{0x8fdf, 0xb931},
	{0x8fe0, 0xb932},
	{0x8fe1, 0xb933},
	{0x8fe2, 0xb934},
	{0x8fe3, 0xb935},
	{0x8fe4, 0xb936},
	{0x8fe5, 0xb937},
	{0x8fe6, 0xb938},
	{0x8fe7, 0xb939},
	{0x8fe8, 0xb93a},
	{0x8fe9, 0xb93b},
	{0x8fea, 0xb93e},
	{0x8feb, 0xb93f},
	{0x8fec, 0xb941},
	{0x8fed, 0xb942},
	{0x8fee, 0xb943},
	{0x8fef, 0xb945},
	{0x8ff0, 0xb946},
	{0x8ff1, 0xb947},
	{0x8ff2, 0xb948},
	{0x8ff3, 0xb949},
	{0x8ff4, 0xb94a},
	{0x8ff5, 0xb94b},
	{0x8ff6, 0xb94d},
	{0x8ff7, 0xb94e},
	{0x8ff8, 0xb950},
	{0x8ff9, 0xb952},
	{0x8ffa, 0xb953},
	{0x8ffb, 0xb954},
	{0x8ffc, 0xb955},
	{0x8ffd, 0xb956},
	{0x8ffe, 0xb957},
	{0x9041, 0xb95a},
	{0x9042, 0xb95b},
	{0x9043, 0xb95d},
	{0x9044, 0xb95e},
	{0x9045, 0xb95f},
	{0x9046, 0xb961},
	{0x9047, 0xb962},
	{0x9048, 0xb963},
	{0x9049, 0xb964},
	{0x904a, 0xb965},
	{0x904b, 0xb966},
	{0x904c, 0xb967},
	{0x904d, 0xb96a},
	{0x904e, 0xb96c},
	{0x904f, 0xb96e},
	{0x9050, 0xb96f},
	{0x9051, 0xb970},
	{0x9052, 0xb971},
	{0x9053, 0xb972},
	{0x9054, 0xb973},
	{0x9055, 0xb976},
	{0x9056, 0xb977},
	{0x9057, 0xb979},
	{0x9058, 0xb97a},
	{0x9059, 0xb97b},
	{0x905a, 0xb97d},
	{0x9061, 0xb97e},
	{0x9062, 0xb97f},
	{0x9063, 0xb980},
	{0x9064, 0xb981},
	{0x9065, 0xb982},
	{0x9066, 0xb983},
	{0x9067, 0xb986},
	{0x9068, 0xb988},
	{0x9069, 0xb98b},
	{0x906a, 0xb98c},
	{0x906b, 0xb98f},
	{0x906c, 0xb990},
	{0x906d, 0xb991},
	{0x906e, 0xb992},
	{0x906f, 0xb993},
	{0x9070, 0xb994},
	{0x9071, 0xb995},
	{0x9072, 0xb996},
	{0x9073, 0xb997},
	{0x9074, 0xb998},
	{0x9075, 0xb999},
	{0x9076, 0xb99a},
	{0x9077, 0xb99b},
	{0x9078, 0xb99c},
	{0x9079, 0xb99d},
	{0x907a, 0xb99e},
	{0x9081, 0xb99f},
	{0x9082, 0xb9a0},
	{0x9083, 0xb9a1},
	{0x9084, 0xb9a2},
	{0x9085, 0xb9a3},
	{0x9086, 0xb9a4},
	{0x9087, 0xb9a5},
	{0x9088, 0xb9a6},
	{0x9089, 0xb9a7},
	{0x908a, 0xb9a8},
	{0x908b, 0xb9a9},
	{0x908c, 0xb9aa},
	{0x908d, 0xb9ab},
	{0x908e, 0xb9ae},
	{0x908f, 0xb9af},
	{0x9090, 0xb9b1},
	{0x9091, 0xb9b2},
	{0x9092, 0xb9b3},
	{0x9093, 0xb9b5},
	{0x9094, 0xb9b6},
	{0x9095, 0xb9b7},
	{0x9096, 0xb9b8},
	{0x9097, 0xb9b9},
	{0x9098, 0xb9ba},
	{0x9099, 0xb9bb},
	{0x909a, 0xb9be},
	{0x909b, 0xb9c0},
	{0x909c, 0xb9c2},
	{0x909d, 0xb9c3},
	{0x909e, 0xb9c4},
	{0x909f, 0xb9c5},
	{0x90a0, 0xb9c6},
	{0x90a1, 0xb9c7},
	{0x90a2, 0xb9ca},
	{0x90a3, 0xb9cb},
	{0x90a4, 0xb9cd},
	{0x90a5, 0xb9d3},
	{0x90a6, 0xb9d4},
	{0x90a7, 0xb9d5},
	{0x90a8, 0xb9d6},
	{0x90a9, 0xb9d7},
	{0x90aa, 0xb9da},
	{0x90ab, 0xb9dc},
	{0x90ac, 0xb9df},
	{0x90ad, 0xb9e0},
	{0x90ae, 0xb9e2},
	{0x90af, 0xb9e6},
	{0x90b0, 0xb9e7},
	{0x90b1, 0xb9e9},
	{0x90b2, 0xb9ea},
	{0x90b3, 0xb9eb},
	{0x90b4, 0xb9ed},
	{0x90b5, 0xb9ee},
	{0x90b6, 0xb9ef},
	{0x90b7, 0xb9f0},
	{0x90b8, 0xb9f1},
	{0x90b9, 0xb9f2},
	{0x90ba, 0xb9f3},
	{0x90bb, 0xb9f6},
	{0x90bc, 0xb9fb},
	{0x90bd, 0xb9fc},
	{0x90be, 0xb9fd},
	{0x90bf, 0xb9fe},
	{0x90c0, 0xb9ff},
	{0x90c1, 0xba02},
	{0x90c2, 0xba03},
	{0x90c3, 0xba04},
	{0x90c4, 0xba05},
	{0x90c5, 0xba06},
	{0x90c6, 0xba07},
	{0x90c7, 0xba09},
	{0x90c8, 0xba0a},
	{0x90c9, 0xba0b},
	{0x90ca, 0xba0c},
	{0x90cb, 0xba0d},
	{0x90cc, 0xba0e},
	{0x90cd, 0xba0f},
	{0x90ce, 0xba10},
	{0x90cf, 0xba11},
	{0x90d0, 0xba12},
	{0x90d1, 0xba13},
	{0x90d2, 0xba14},
	{0x90d3, 0xba16},
	{0x90d4, 0xba17},
	{0x90d5, 0xba18},
	{0x90d6, 0xba19},
	{0x90d7, 0xba1a},
	{0x90d8, 0xba1b},
	{0x90d9, 0xba1c},
	{0x90da, 0xba1d},
	{0x90db, 0xba1e},
	{0x90dc, 0xba1f},
	{0x90dd, 0xba20},
	{0x90de, 0xba21},
	{0x90df, 0xba22},
	{0x90e0, 0xba23},
	{0x90e1, 0xba24},
	{0x90e2, 0xba25},
	{0x90e3, 0xba26},
	{0x90e4, 0xba27},
	{0x90e5, 0xba28},
	{0x90e6, 0xba29},
	{0x90e7, 0xba2a},
	{0x90e8, 0xba2b},
	{0x90e9, 0xba2c},
	{0x90ea, 0xba2d},
	{0x90eb, 0xba2e},
	{0x90ec, 0xba2f},
	{0x90ed, 0xba30},
	{0x90ee, 0xba31},
	{0x90ef, 0xba32},
	{0x90f0, 0xba33},
	{0x90f1, 0xba34},
	{0x90f2, 0xba35},
	{0x90f3, 0xba36},
	{0x90f4, 0xba37},
	{0x90f5, 0xba3a},
	{0x90f6, 0xba3b},
	{0x90f7, 0xba3d},
	{0x90f8, 0xba3e},
	{0x90f9, 0xba3f},
	{0x90fa, 0xba41},
	{0x90fb, 0xba43},
	{0x90fc, 0xba44},
	{0x90fd, 0xba45},
	{0x90fe, 0xba46},
	{0x9141, 0xba47},
	{0x9142, 0xba4a},
	{0x9143, 0xba4c},
	{0x9144, 0xba4f},
	{0x9145, 0xba50},
	{0x9146, 0xba51},
	{0x9147, 0xba52},
	{0x9148, 0xba56},
	{0x9149, 0xba57},
	{0x914a, 0xba59},
	{0x914b, 0xba5a},
	{0x914c, 0xba5b},
	{0x914d, 0xba5d},
	{0x914e, 0xba5e},
	{0x914f, 0xba5f},
	{0x9150, 0xba60},
	{0x9151, 0xba61},
	{0x9152, 0xba62},
	{0x9153, 0xba63},
	{0x9154, 0xba66},
	{0x9155, 0xba6a},
	{0x9156, 0xba6b},
	{0x9157, 0xba6c},
	{0x9158, 0xba6d},
	{0x9159, 0xba6e},
	{0x915a, 0xba6f},
	{0x9161, 0xba72},
	{0x9162, 0xba73},
	{0x9163, 0xba75},
	{0x9164, 0xba76},
	{0x9165, 0xba77},
	{0x9166, 0xba79},
	{0x9167, 0xba7a},
	{0x9168, 0xba7b},
	{0x9169, 0xba7c},
	{0x916a, 0xba7d},
	{0x916b, 0xba7e},
	{0x916c, 0xba7f},
	{0x916d, 0xba80},
	{0x916e, 0xba81},
	{0x916f, 0xba82},
	{0x9170, 0xba86},
	{0x9171, 0xba88},
	{0x9172, 0xba89},
	{0x9173, 0xba8a},
	{0x9174, 0xba8b},
	{0x9175, 0xba8d},
	{0x9176, 0xba8e},
	{0x9177, 0xba8f},
	{0x9178, 0xba90},
	{0x9179, 0xba91},
	{0x917a, 0xba92},
	{0x9181, 0xba93},
	{0x9182, 0xba94},
	{0x9183, 0xba95},
	{0x9184, 0xba96},
	{0x9185, 0xba97},
	{0x9186, 0xba98},
	{0x9187, 0xba99},
	{0x9188, 0xba9a},
	{0x9189, 0xba9b},
	{0x918a, 0xba9c},
	{0x918b, 0xba9d},
	{0x918c, 0xba9e},
	{0x918d, 0xba9f},
	{0x918e, 0xbaa0},
	{0x918f, 0xbaa1},
	{0x9190, 0xbaa2},
	{0x9191, 0xbaa3},
	{0x9192, 0xbaa4},
	{0x9193, 0xbaa5},
	{0x9194, 0xbaa6},
	{0x9195, 0xbaa7},
	{0x9196, 0xbaaa},
	{0x9197, 0xbaad},
	{0x9198, 0xbaae},
	{0x9199, 0xbaaf},
	{0x919a, 0xbab1},
	{0x919b, 0xbab3},
	{0x919c, 0xbab4},
	{0x919d, 0xbab5},
	{0x919e, 0xbab6},
	{0x919f, 0xbab7},
	{0x91a0, 0xbaba},
	{0x91a1, 0xbabc},
	{0x91a2, 0xbabe},
	{0x91a3, 0xbabf},
	{0x91a4, 0xbac0},
	{0x91a5, 0xbac1},
	{0x91a6, 0xbac2},
	{0x91a7, 0xbac3},
	{0x91a8, 0xbac5},
	{0x91a9, 0xbac6},
	{0x91aa, 0xbac7},
	{0x91ab, 0xbac9},
	{0x91ac, 0xbaca},
	{0x91ad, 0xbacb},
	{0x91ae, 0xbacc},
	{0x91af, 0xbacd},
	{0x91b0, 0xbace},
	{0x91b1, 0xbacf},
	{0x91b2, 0xbad0},
	{0x91b3, 0xbad1},
	{0x91b4, 0xbad2},
	{0x91b5, 0xbad3},
	{0x91b6, 0xbad4},
	{0x91b7, 0xbad5},
	{0x91b8, 0xbad6},
	{0x91b9, 0xbad7},
	{0x91ba, 0xbada},
	{0x91bb, 0xbadb},
	{0x91bc, 0xbadc},
	{0x91bd, 0xbadd},
	{0x91be, 0xbade},
	{0x91bf, 0xbadf},
	{0x91c0, 0xbae0},
	{0x91c1, 0xbae1},
	{0x91c2, 0xbae2},
	{0x91c3, 0xbae3},
	{0x91c4, 0xbae4},
	{0x91c5, 0xbae5},
	{0x91c6, 0xbae6},
	{0x91c7, 0xbae7},
	{0x91c8, 0xbae8},
	{0x91c9, 0xbae9},
	{0x91ca, 0xbaea},
	{0x91cb, 0xbaeb},
	{0x91cc, 0xbaec},
	{0x91cd, 0xbaed},
	{0x91ce, 0xbaee},
	{0x91cf, 0xbaef},
	{0x91d0, 0xbaf0},
	{0x91d1, 0xbaf1},
	{0x91d2, 0xbaf2},
	{0x91d3, 0xbaf3},
	{0x91d4, 0xbaf4},
	{0x91d5, 0xbaf5},
	{0x91d6, 0xbaf6},
	{0x91d7, 0xbaf7},
	{0x91d8, 0xbaf8},
	{0x91d9, 0xbaf9},
	{0x91da, 0xbafa},
	{0x91db, 0xbafb},
	{0x91dc, 0xbafd},
	{0x91dd, 0xbafe},
	{0x91de, 0xbaff},
	{0x91df, 0xbb01},
	{0x91e0, 0xbb02},
	{0x91e1, 0xbb03},
	{0x91e2, 0xbb05},
	{0x91e3, 0xbb06},
	{0x91e4, 0xbb07},
	{0x91e5, 0xbb08},
	{0x91e6, 0xbb09},
	{0x91e7, 0xbb0a},
	{0x91e8, 0xbb0b},
	{0x91e9, 0xbb0c},
	{0x91ea, 0xbb0e},
	{0x91eb, 0xbb10},
	{0x91ec, 0xbb12},
	{0x91ed, 0xbb13},
	{0x91ee, 0xbb14},
	{0x91ef, 0xbb15},
	{0x91f0, 0xbb16},
	{0x91f1, 0xbb17},
	{0x91f2, 0xbb19},
	{0x91f3, 0xbb1a},
	{0x91f4, 0xbb1b},
	{0x91f5, 0xbb1d},
	{0x91f6, 0xbb1e},
	{0x91f7, 0xbb1f},
	{0x91f8, 0xbb21},
	{0x91f9, 0xbb22},
	{0x91fa, 0xbb23},
	{0x91fb, 0xbb24},
	{0x91fc, 0xbb25},
	{0x91fd, 0xbb26},
	{0x91fe, 0xbb27},
	{0x9241, 0xbb28},
	{0x9242, 0xbb2a},
	{0x9243, 0xbb2c},
	{0x9244, 0xbb2d},
	{0x9245, 0xbb2e},
	{0x9246, 0xbb2f},
	{0x9247, 0xbb30},
	{0x9248, 0xbb31},
	{0x9249, 0xbb32},
	{0x924a, 0xbb33},
	{0x924b, 0xbb37},
	{0x924c, 0xbb39},
	{0x924d, 0xbb3a},
	{0x924e, 0xbb3f},
	{0x924f, 0xbb40},
	{0x9250, 0xbb41},
	{0x9251, 0xbb42},
	{0x9252, 0xbb43},
	{0x9253, 0xbb46},
	{0x9254, 0xbb48},
	{0x9255, 0xbb4a},
	{0x9256, 0xbb4b},
	{0x9257, 0xbb4c},
	{0x9258, 0xbb4e},
	{0x9259, 0xbb51},
	{0x925a, 0xbb52},
	{0x9261, 0xbb53},
	{0x9262, 0xbb55},
	{0x9263, 0xbb56},
	{0x9264, 0xbb57},
	{0x9265, 0xbb59},
	{0x9266, 0xbb5a},
	{0x9267, 0xbb5b},
	{0x9268, 0xbb5c},
	{0x9269, 0xbb5d},
	{0x926a, 0xbb5e},
	{0x926b, 0xbb5f},
	{0x926c, 0xbb60},
	{0x926d, 0xbb62},
	{0x926e, 0xbb64},
	{0x926f, 0xbb65},
	{0x9270, 0xbb66},
	{0x9271, 0xbb67},
	{0x9272, 0xbb68},
	{0x9273, 0xbb69},
	{0x9274, 0xbb6a},
	{0x9275, 0xbb6b},
	{0x9276, 0xbb6d},
	{0x9277, 0xbb6e},
	{0x9278, 0xbb6f},
	{0x9279, 0xbb70},
	{0x927a, 0xbb71},
	{0x9281, 0xbb72},
	{0x9282, 0xbb73},
	{0x9283, 0xbb74},
	{0x9284, 0xbb75},
	{0x9285, 0xbb76},
	{0x9286, 0xbb77},
	{0x9287, 0xbb78},
	{0x9288, 0xbb79},
	{0x9289, 0xbb7a},
	{0x928a, 0xbb7b},
	{0x928b, 0xbb7c},
	{0x928c, 0xbb7d},
	{0x928d, 0xbb7e},
	{0x928e, 0xbb7f},
	{0x928f, 0xbb80},
	{0x9290, 0xbb81},
	{0x9291, 0xbb82},
	{0x9292, 0xbb83},
	{0x9293, 0xbb84},
	{0x9294, 0xbb85},
	{0x9295, 0xbb86},
	{0x9296, 0xbb87},
	{0x9297, 0xbb89},
	{0x9298, 0xbb8a},
	{0x9299, 0xbb8b},
	{0x929a, 0xbb8d},
	{0x929b, 0xbb8e},
	{0x929c, 0xbb8f},
	{0x929d, 0xbb91},
	{0x929e, 0xbb92},
	{0x929f, 0xbb93},
	{0x92a0, 0xbb94},
	{0x92a1, 0xbb95},
	{0x92a2, 0xbb96},
	{0x92a3, 0xbb97},
	{0x92a4, 0xbb98},
	{0x92a5, 0xbb99},
	{0x92a6, 0xbb9a},
	{0x92a7, 0xbb9b},
	{0x92a8, 0xbb9c},
	{0x92a9, 0xbb9d},
	{0x92aa, 0xbb9e},
	{0x92ab, 0xbb9f},
	{0x92ac, 0xbba0},
	{0x92ad, 0xbba1},
	{0x92ae, 0xbba2},
	{0x92af, 0xbba3},
	{0x92b0, 0xbba5},
	{0x92b1, 0xbba6},
	{0x92b2, 0xbba7},
	{0x92b3, 0xbba9},
	{0x92b4, 0xbbaa},
	{0x92b5, 0xbbab},
	{0x92b6, 0xbbad},
	{0x92b7, 0xbbae},
	{0x92b8, 0xbbaf},
	{0x92b9, 0xbbb0},
	{0x92ba, 0xbbb1},
	{0x92bb, 0xbbb2},
	{0x92bc, 0xbbb3},
	{0x92bd, 0xbbb5},
	{0x92be, 0xbbb6},
	{0x92bf, 0xbbb8},
	{0x92c0, 0xbbb9},
	{0x92c1, 0xbbba},
	{0x92c2, 0xbbbb},
	{0x92c3, 0xbbbc},
	{0x92c4, 0xbbbd},
	{0x92c5, 0xbbbe},
	{0x92c6, 0xbbbf},
	{0x92c7, 0xbbc1},
	{0x92c8, 0xbbc2},
	{0x92c9, 0xbbc3},
	{0x92ca, 0xbbc5},
	{0x92cb, 0xbbc6},
	{0x92cc, 0xbbc7},
	{0x92cd, 0xbbc9},
	{0x92ce, 0xbbca},
	{0x92cf, 0xbbcb},
	{0x92d0, 0xbbcc},
	{0x92d1, 0xbbcd},
	{0x92d2, 0xbbce},
	{0x92d3, 0xbbcf},
	{0x92d4, 0xbbd1},
	{0x92d5, 0xbbd2},
	{0x92d6, 0xbbd4},
	{0x92d7, 0xbbd5},
	{0x92d8, 0xbbd6},
	{0x92d9, 0xbbd7},
	{0x92da, 0xbbd8},
	{0x92db, 0xbbd9},
	{0x92dc, 0xbbda},
	{0x92dd, 0xbbdb},
	{0x92de, 0xbbdc},
	{0x92df, 0xbbdd},
	{0x92e0, 0xbbde},
	{0x92e1, 0xbbdf},
	{0x92e2, 0xbbe0},
	{0x92e3, 0xbbe1},
	{0x92e4, 0xbbe2},
	{0x92e5, 0xbbe3},
	{0x92e6, 0xbbe4},
	{0x92e7, 0xbbe5},
	{0x92e8, 0xbbe6},
	{0x92e9, 0xbbe7},
	{0x92ea, 0xbbe8},
	{0x92eb, 0xbbe9},
	{0x92ec, 0xbbea},
	{0x92ed, 0xbbeb},
	{0x92ee, 0xbbec},
	{0x92ef, 0xbbed},
	{0x92f0, 0xbbee},
	{0x92f1, 0xbbef},
	{0x92f2, 0xbbf0},
	{0x92f3, 0xbbf1},
	{0x92f4, 0xbbf2},
	{0x92f5, 0xbbf3},
	{0x92f6, 0xbbf4},
	{0x92f7, 0xbbf5},
	{0x92f8, 0xbbf6},
	{0x92f9, 0xbbf7},
	{0x92fa, 0xbbfa},
	{0x92fb, 0xbbfb},
	{0x92fc, 0xbbfd},
	{0x92fd, 0xbbfe},
	{0x92fe, 0xbc01},
	{0x9341, 0xbc03},
	{0x9342, 0xbc04},
	{0x9343, 0xbc05},
	{0x9344, 0xbc06},
	{0x9345, 0xbc07},
	{0x9346, 0xbc0a},
	{0x9347, 0xbc0e},
	{0x9348, 0xbc10},
	{0x9349, 0xbc12},
	{0x934a, 0xbc13},
	{0x934b, 0xbc19},
	{0x934c, 0xbc1a},
	{0x934d, 0xbc20},
	{0x934e, 0xbc21},
	{0x934f, 0xbc22},
	{0x9350, 0xbc23},
	{0x9351, 0xbc26},
	{0x9352, 0xbc28},
	{0x9353, 0xbc2a},
	{0x9354, 0xbc2b},
	{0x9355, 0xbc2c},
	{0x9356, 0xbc2e},
	{0x9357, 0xbc2f},
	{0x9358, 0xbc32},
	{0x9359, 0xbc33},
	{0x935a, 0xbc35},
	{0x9361, 0xbc36},
	{0x9362, 0xbc37},
	{0x9363, 0xbc39},
	{0x9364, 0xbc3a},
	{0x9365, 0xbc3b},
	{0x9366, 0xbc3c},
	{0x9367, 0xbc3d},
	{0x9368, 0xbc3e},
	{0x9369, 0xbc3f},
	{0x936a, 0xbc42},
	{0x936b, 0xbc46},
	{0x936c, 0xbc47},
	{0x936d, 0xbc48},
	{0x936e, 0xbc4a},
	{0x936f, 0xbc4b},
	{0x9370, 0xbc4e},
	{0x9371, 0xbc4f},
	{0x9372, 0xbc51},
	{0x9373, 0xbc52},
	{0x9374, 0xbc53},
	{0x9375, 0xbc54},
	{0x9376, 0xbc55},
	{0x9377, 0xbc56},
	{0x9378, 0xbc57},
	{0x9379, 0xbc58},
	{0x937a, 0xbc59},
	{0x9381, 0xbc5a},
	{0x9382, 0xbc5b},
	{0x9383, 0xbc5c},
	{0x9384, 0xbc5e},
	{0x9385, 0xbc5f},
	{0x9386, 0xbc60},
	{0x9387, 0xbc61},
	{0x9388, 0xbc62},
	{0x9389, 0xbc63},
	{0x938a, 0xbc64},
	{0x938b, 0xbc65},
	{0x938c, 0xbc66},
	{0x938d, 0xbc67},
	{0x938e, 0xbc68},
	{0x938f, 0xbc69},
	{0x9390, 0xbc6a},
	{0x9391, 0xbc6b},
	{0x9392, 0xbc6c},
	{0x9393, 0xbc6d},
	{0x9394, 0xbc6e},
	{0x9395, 0xbc6f},
	{0x9396, 0xbc70},
	{0x9397, 0xbc71},
	{0x9398, 0xbc72},
	{0x9399, 0xbc73},
	{0x939a, 0xbc74},
	{0x939b, 0xbc75},
	{0x939c, 0xbc76},
	{0x939d, 0xbc77},
	{0x939e, 0xbc78},
	{0x939f, 0xbc79},
	{0x93a0, 0xbc7a},
	{0x93a1, 0xbc7b},
	{0x93a2, 0xbc7c},
	{0x93a3, 0xbc7d},
	{0x93a4, 0xbc7e},
	{0x93a5, 0xbc7f},
	{0x93a6, 0xbc80},
	{0x93a7, 0xbc81},
	{0x93a8, 0xbc82},
	{0x93a9, 0xbc83},
	{0x93aa, 0xbc86},
	{0x93ab, 0xbc87},
	{0x93ac, 0xbc89},
	{0x93ad, 0xbc8a},
	{0x93ae, 0xbc8d},
	{0x93af, 0xbc8f},
	{0x93b0, 0xbc90},
	{0x93b1, 0xbc91},
	{0x93b2, 0xbc92},
	{0x93b3, 0xbc93},
	{0x93b4, 0xbc96},
	{0x93b5, 0xbc98},
	{0x93b6, 0xbc9b},
	{0x93b7, 0xbc9c},
	{0x93b8, 0xbc9d},
	{0x93b9, 0xbc9e},
	{0x93ba, 0xbc9f},
	{0x93bb, 0xbca2},
	{0x93bc, 0xbca3},
	{0x93bd, 0xbca5},
	{0x93be, 0xbca6},
	{0x93bf, 0xbca9},
	{0x93c0, 0xbcaa},
	{0x93c1, 0xbcab},
	{0x93c2, 0xbcac},
	{0x93c3, 0xbcad},
	{0x93c4, 0xbcae},
	{0x93c5, 0xbcaf},
	{0x93c6, 0xbcb2},
	{0x93c7, 0xbcb6},
	{0x93c8, 0xbcb7},
	{0x93c9, 0xbcb8},
	{0x93ca, 0xbcb9},
	{0x93cb, 0xbcba},
	{0x93cc, 0xbcbb},
	{0x93cd, 0xbcbe},
	{0x93ce, 0xbcbf},
	{0x93cf, 0xbcc1},
	{0x93d0, 0xbcc2},
	{0x93d1, 0xbcc3},
	{0x93d2, 0xbcc5},
	{0x93d3, 0xbcc6},
	{0x93d4, 0xbcc7},
	{0x93d5, 0xbcc8},
	{0x93d6, 0xbcc9},
	{0x93d7, 0xbcca},
	{0x93d8, 0xbccb},
	{0x93d9, 0xbccc},
	{0x93da, 0xbcce},
	{0x93db, 0xbcd2},
	{0x93dc, 0xbcd3},
	{0x93dd, 0xbcd4},
	{0x93de, 0xbcd6},
	{0x93df, 0xbcd7},
	{0x93e0, 0xbcd9},
	{0x93e1, 0xbcda},
	{0x93e2, 0xbcdb},
	{0x93e3, 0xbcdd},
	{0x93e4, 0xbcde},
	{0x93e5, 0xbcdf},
	{0x93e6, 0xbce0},
	{0x93e7, 0xbce1},
	{0x93e8, 0xbce2},
	{0x93e9, 0xbce3},
	{0x93ea, 0xbce4},
	{0x93eb, 0xbce5},
	{0x93ec, 0xbce6},
	{0x93ed, 0xbce7},
	{0x93ee, 0xbce8},
	{0x93ef, 0xbce9},
	{0x93f0, 0xbcea},
	{0x93f1, 0xbceb},
	{0x93f2, 0xbcec},
	{0x93f3, 0xbced},
	{0x93f4, 0xbcee},
	{0x93f5, 0xbcef},
	{0x93f6, 0xbcf0},
	{0x93f7, 0xbcf1},
	{0x93f8, 0xbcf2},
	{0x93f9, 0xbcf3},
	{0x93fa, 0xbcf7},
	{0x93fb, 0xbcf9},
	{0x93fc, 0xbcfa},
	{0x93fd, 0xbcfb},
	{0x93fe, 0xbcfd},
	{0x9441, 0xbcfe},
	{0x9442, 0xbcff},
	{0x9443, 0xbd00},
	{0x9444, 0xbd01},
	{0x9445, 0xbd02},
	{0x9446, 0xbd03},
	{0x9447, 0xbd06},
	{0x9448, 0xbd08},
	{0x9449, 0xbd0a},
	{0x944a, 0xbd0b},
	{0x944b, 0xbd0c},
	{0x944c, 0xbd0d},
	{0x944d, 0xbd0e},
	{0x944e, 0xbd0f},
	{0x944f, 0xbd11},
	{0x9450, 0xbd12},
	{0x9451, 0xbd13},
	{0x9452, 0xbd15},
	{0x9453, 0xbd16},
	{0x9454, 0xbd17},
	{0x9455, 0xbd18},
	{0x9456, 0xbd19},
	{0x9457, 0xbd1a},
	{0x9458, 0xbd1b},
	{0x9459, 0xbd1c},
	{0x945a, 0xbd1d},
	{0x9461, 0xbd1e},
	{0x9462, 0xbd1f},
	{0x9463, 0xbd20},
	{0x9464, 0xbd21},
	{0x9465, 0xbd22},
	{0x9466, 0xbd23},
	{0x9467, 0xbd25},
	{0x9468, 0xbd26},
	{0x9469, 0xbd27},
	{0x946a, 0xbd28},
	{0x946b, 0xbd29},
	{0x946c, 0xbd2a},
	{0x946d, 0xbd2b},
	{0x946e, 0xbd2d},
	{0x946f, 0xbd2e},
	{0x9470, 0xbd2f},
	{0x9471, 0xbd30},
	{0x9472, 0xbd31},
	{0x9473, 0xbd32},
	{0x9474, 0xbd33},
	{0x9475, 0xbd34},
	{0x9476, 0xbd35},
	{0x9477, 0xbd36},
	{0x9478, 0xbd37},
	{0x9479, 0xbd38},
	{0x947a, 0xbd39},
	{0x9481, 0xbd3a},
	{0x9482, 0xbd3b},
	{0x9483, 0xbd3c},
	{0x9484, 0xbd3d},
	{0x9485, 0xbd3e},
	{0x9486, 0xbd3f},
	{0x9487, 0xbd41},
	{0x9488, 0xbd42},
	{0x9489, 0xbd43},
	{0x948a, 0xbd44},
	{0x948b, 0xbd45},
	{0x948c, 0xbd46},
	{0x948d, 0xbd47},
	{0x948e, 0xbd4a},
	{0x948f, 0xbd4b},
	{0x9490, 0xbd4d},
	{0x9491, 0xbd4e},
	{0x9492, 0xbd4f},
	{0x9493, 0xbd51},
	{0x9494, 0xbd52},
	{0x9495, 0xbd53},
	{0x9496, 0xbd54},
	{0x9497, 0xbd55},
	{0x9498, 0xbd56},
	{0x9499, 0xbd57},
	{0x949a, 0xbd5a},
	{0x949b, 0xbd5b},
	{0x949c, 0xbd5c},
	{0x949d, 0xbd5d},
	{0x949e, 0xbd5e},
	{0x949f, 0xbd5f},
	{0x94a0, 0xbd60},
	{0x94a1, 0xbd61},
	{0x94a2, 0xbd62},
	{0x94a3, 0xbd63},
	{0x94a4, 0xbd65},
	{0x94a5, 0xbd66},
	{0x94a6, 0xbd67},
	{0x94a7, 0xbd69},
	{0x94a8, 0xbd6a},
	{0x94a9, 0xbd6b},
	{0x94aa, 0xbd6c},
	{0x94ab, 0xbd6d},
	{0x94ac, 0xbd6e},
	{0x94ad, 0xbd6f},
	{0x94ae, 0xbd70},
	{0x94af, 0xbd71},
	{0x94b0, 0xbd72},
	{0x94b1, 0xbd73},
	{0x94b2, 0xbd74},
	{0x94b3, 0xbd75},
	{0x94b4, 0xbd76},
	{0x94b5, 0xbd77},
	{0x94b6, 0xbd78},
	{0x94b7, 0xbd79},
	{0x94b8, 0xbd7a},
	{0x94b9, 0xbd7b},
	{0x94ba, 0xbd7c},
	{0x94bb, 0xbd7d},
	{0x94bc, 0xbd7e},
	{0x94bd, 0xbd7f},
	{0x94be, 0xbd82},
	{0x94bf, 0xbd83},
	{0x94c0, 0xbd85},
	{0x94c1, 0xbd86},
	{0x94c2, 0xbd8b},
	{0x94c3, 0xbd8c},
	{0x94c4, 0xbd8d},
	{0x94c5, 0xbd8e},
	{0x94c6, 0xbd8f},
	{0x94c7, 0xbd92},
	{0x94c8, 0xbd94},
	{0x94c9, 0xbd96},
	{0x94ca, 0xbd97},
	{0x94cb, 0xbd98},
	{0x94cc, 0xbd9b},
	{0x94cd, 0xbd9d},
	{0x94ce, 0xbd9e},
	{0x94cf, 0xbd9f},
	{0x94d0, 0xbda0},
	{0x94d1, 0xbda1},
	{0x94d2, 0xbda2},
	{0x94d3, 0xbda3},
	{0x94d4, 0xbda5},
	{0x94d5, 0xbda6},
	{0x94d6, 0xbda7},
	{0x94d7, 0xbda8},
	{0x94d8, 0xbda9},
	{0x94d9, 0xbdaa},
	{0x94da, 0xbdab},
	{0x94db, 0xbdac},
	{0x94dc, 0xbdad},
	{0x94dd, 0xbdae},
	{0x94de, 0xbdaf},
	{0x94df, 0xbdb1},
	{0x94e0, 0xbdb2},
	{0x94e1, 0xbdb3},
	{0x94e2, 0xbdb4},
	{0x94e3, 0xbdb5},
	{0x94e4, 0xbdb6},
	{0x94e5, 0xbdb7},
	{0x94e6, 0xbdb9},
	{0x94e7, 0xbdba},
	{0x94e8, 0xbdbb},
	{0x94e9, 0xbdbc},
	{0x94ea, 0xbdbd},
	{0x94eb, 0xbdbe},
	{0x94ec, 0xbdbf},
	{0x94ed, 0xbdc0},
	{0x94ee, 0xbdc1},
	{0x94ef, 0xbdc2},
	{0x94f0, 0xbdc3},
	{0x94f1, 0xbdc4},
	{0x94f2, 0xbdc5},
	{0x94f3, 0xbdc6},
	{0x94f4, 0xbdc7},
	{0x94f5, 0xbdc8},
	{0x94f6, 0xbdc9},
	{0x94f7, 0xbdca},
	{0x94f8, 0xbdcb},
	{0x94f9, 0xbdcc},
	{0x94fa, 0xbdcd},
	{0x94fb, 0xbdce},
	{0x94fc, 0xbdcf},
	{0x94fd, 0xbdd0},
	{0x94fe, 0xbdd1},
	{0x9541, 0xbdd2},
	{0x9542, 0xbdd3},
	{0x9543, 0xbdd6},
	{0x9544, 0xbdd7},
	{0x9545, 0xbdd9},
	{0x9546, 0xbdda},
	{0x9547, 0xbddb},
	{0x9548, 0xbddd},
	{0x9549, 0xbdde},
	{0x954a, 0xbddf},
	{0x954b, 0xbde0},
	{0x954c, 0xbde1},
	{0x954d, 0xbde2},
	{0x954e, 0xbde3},
	{0x954f, 0xbde4},
	{0x9550, 0xbde5},
	{0x9551, 0xbde6},
	{0x9552, 0xbde7},
	{0x9553, 0xbde8},
	{0x9554, 0xbdea},
	{0x9555, 0xbdeb},
	{0x9556, 0xbdec},
	{0x9557, 0xbded},
	{0x9558, 0xbdee},
	{0x9559, 0xbdef},
	{0x955a, 0xbdf1},
	{0x9561, 0xbdf2},
	{0x9562, 0xbdf3},
	{0x9563, 0xbdf5},
	{0x9564, 0xbdf6},
	{0x9565, 0xbdf7},
	{0x9566, 0xbdf9},
	{0x9567, 0xbdfa},
	{0x9568, 0xbdfb},
	{0x9569, 0xbdfc},
	{0x956a, 0xbdfd},
	{0x956b, 0xbdfe},
	{0x956c, 0xbdff},
	{0x956d, 0xbe01},
	{0x956e, 0xbe02},
	{0x956f, 0xbe04},
	{0x9570, 0xbe06},
	{0x9571, 0xbe07},
	{0x9572, 0xbe08},
	{0x9573, 0xbe09},
	{0x9574, 0xbe0a},
	{0x9575, 0xbe0b},
	{0x9576, 0xbe0e},
	{0x9577, 0xbe0f},
	{0x9578, 0xbe11},
	{0x9579, 0xbe12},
	{0x957a, 0xbe13},
	{0x9581, 0xbe15},
	{0x9582, 0xbe16},
	{0x9583, 0xbe17},
	{0x9584, 0xbe18},
	{0x9585, 0xbe19},
	{0x9586, 0xbe1a},
	{0x9587, 0xbe1b},
	{0x9588, 0xbe1e},
	{0x9589, 0xbe20},
	{0x958a, 0xbe21},
	{0x958b, 0xbe22},
	{0x958c, 0xbe23},
	{0x958d, 0xbe24},
	{0x958e, 0xbe25},
	{0x958f, 0xbe26},
	{0x9590, 0xbe27},
	{0x9591, 0xbe28},
	{0x9592, 0xbe29},
	{0x9593, 0xbe2a},
	{0x9594, 0xbe2b},
	{0x9595, 0xbe2c},
	{0x9596, 0xbe2d},
	{0x9597, 0xbe2e},
	{0x9598, 0xbe2f},
	{0x9599, 0xbe30},
	{0x959a, 0xbe31},
	{0x959b, 0xbe32},
	{0x959c, 0xbe33},
	{0x959d, 0xbe34},
	{0x959e, 0xbe35},
	{0x959f, 0xbe36},
	{0x95a0, 0xbe37},
	{0x95a1, 0xbe38},
	{0x95a2, 0xbe39},
	{0x95a3, 0xbe3a},
	{0x95a4, 0xbe3b},
	{0x95a5, 0xbe3c},
	{0x95a6, 0xbe3d},
	{0x95a7, 0xbe3e},
	{0x95a8, 0xbe3f},
	{0x95a9, 0xbe40},
	{0x95aa, 0xbe41},
	{0x95ab, 0xbe42},
	{0x95ac, 0xbe43},
	{0x95ad, 0xbe46},
	{0x95ae, 0xbe47},
	{0x95af, 0xbe49},
	{0x95b0, 0xbe4a},
	{0x95b1, 0xbe4b},
	{0x95b2, 0xbe4d},
	{0x95b3, 0xbe4f},
	{0x95b4, 0xbe50},
	{0x95b5, 0xbe51},
	{0x95b6, 0xbe52},
	{0x95b7, 0xbe53},
	{0x95b8, 0xbe56},
	{0x95b9, 0xbe58},
	{0x95ba, 0xbe5c},
	{0x95bb, 0xbe5d},
	{0x95bc, 0xbe5e},
	{0x95bd, 0xbe5f},
	{0x95be, 0xbe62},
	{0x95bf, 0xbe63},
	{0x95c0, 0xbe65},
	{0x95c1, 0xbe66},
	{0x95c2, 0xbe67},
	{0x95c3, 0xbe69},
	{0x95c4, 0xbe6b},
	{0x95c5, 0xbe6c},
	{0x95c6, 0xbe6d},
	{0x95c7, 0xbe6e},
	{0x95c8, 0xbe6f},
	{0x95c9, 0xbe72},
	{0x95ca, 0xbe76},
	{0x95cb, 0xbe77},
	{0x95cc, 0xbe78},
	{0x95cd, 0xbe79},
	{0x95ce, 0xbe7a},
	{0x95cf, 0xbe7e},
	{0x95d0, 0xbe7f},
	{0x95d1, 0xbe81},
	{0x95d2, 0xbe82},
	{0x95d3, 0xbe83},
	{0x95d4, 0xbe85},
	{0x95d5, 0xbe86},
	{0x95d6, 0xbe87},
	{0x95d7, 0xbe88},
	{0x95d8, 0xbe89},
	{0x95d9, 0xbe8a},
	{0x95da, 0xbe8b},
	{0x95db, 0xbe8e},
	{0x95dc, 0xbe92},
	{0x95dd, 0xbe93},
	{0x95de, 0xbe94},
	{0x95df, 0xbe95},
	{0x95e0, 0xbe96},
	{0x95e1, 0xbe97},
	{0x95e2, 0xbe9a},
	{0x95e3, 0xbe9b},
	{0x95e4, 0xbe9c},
	{0x95e5, 0xbe9d},
	{0x95e6, 0xbe9e},
	{0x95e7, 0xbe9f},
	{0x95e8, 0xbea0},
	{0x95e9, 0xbea1},
	{0x95ea, 0xbea2},
	{0x95eb, 0xbea3},
	{0x95ec, 0xbea4},
	{0x95ed, 0xbea5},
	{0x95ee, 0xbea6},
	{0x95ef, 0xbea7},
	{0x95f0, 0xbea9},
	{0x95f1, 0xbeaa},
	{0x95f2, 0xbeab},
	{0x95f3, 0xbeac},
	{0x95f4, 0xbead},
	{0x95f5, 0xbeae},
	{0x95f6, 0xbeaf},
	{0x95f7, 0xbeb0},
	{0x95f8, 0xbeb1},
	{0x95f9, 0xbeb2},
	{0x95fa, 0xbeb3},
	{0x95fb, 0xbeb4},
	{0x95fc, 0xbeb5},
	{0x95fd, 0xbeb6},
	{0x95fe, 0xbeb7},
	{0x9641, 0xbeb8},
	{0x9642, 0xbeb9},
	{0x9643, 0xbeba},
	{0x9644, 0xbebb},
	{0x9645, 0xbebc},
	{0x9646, 0xbebd},
	{0x9647, 0xbebe},
	{0x9648, 0xbebf},
	{0x9649, 0xbec0},
	{0x964a, 0xbec1},
	{0x964b, 0xbec2},
	{0x964c, 0xbec3},
	{0x964d, 0xbec4},
	{0x964e, 0xbec5},
	{0x964f, 0xbec6},
	{0x9650, 0xbec7},
	{0x9651, 0xbec8},
	{0x9652, 0xbec9},
	{0x9653, 0xbeca},
	{0x9654, 0xbecb},
	{0x9655, 0xbecc},
	{0x9656, 0xbecd},
	{0x9657, 0xbece},
	{0x9658, 0xbecf},
	{0x9659, 0xbed2},
	{0x965a, 0xbed3},
	{0x9661, 0xbed5},
	{0x9662, 0xbed6},
	{0x9663, 0xbed9},
	{0x9664, 0xbeda},
	{0x9665, 0xbedb},
	{0x9666, 0xbedc},
	{0x9667, 0xbedd},
	{0x9668, 0xbede},
	{0x9669, 0xbedf},
	{0x966a, 0xbee1},
	{0x966b, 0xbee2},
	{0x966c, 0xbee6},
	{0x966d, 0xbee7},
	{0x966e, 0xbee8},
	{0x966f, 0xbee9},
	{0x9670, 0xbeea},
	{0x9671, 0xbeeb},
	{0x9672, 0xbeed},
	{0x9673, 0xbeee},
	{0x9674, 0xbeef},
	{0x9675, 0xbef0},
	{0x9676, 0xbef1},
	{0x9677, 0xbef2},
	{0x9678, 0xbef3},
	{0x9679, 0xbef4},
	{0x967a, 0xbef5},
	{0x9681, 0xbef6},
	{0x9682, 0xbef7},
	{0x9683, 0xbef8},
	{0x9684, 0xbef9},
	{0x9685, 0xbefa},
	{0x9686, 0xbefb},
	{0x9687, 0xbefc},
	{0x9688, 0xbefd},
	{0x9689, 0xbefe},
	{0x968a, 0xbeff},
	{0x968b, 0xbf00},
	{0x968c, 0xbf02},
	{0x968d, 0xbf03},
	{0x968e, 0xbf04},
	{0x968f, 0xbf05},
	{0x9690, 0xbf06},
	{0x9691, 0xbf07},
	{0x9692, 0xbf0a},
	{0x9693, 0xbf0b},
	{0x9694, 0xbf0c},
	{0x9695, 0xbf0d},
	{0x9696, 0xbf0e},
	{0x9697, 0xbf0f},
	{0x9698, 0xbf10},
	{0x9699, 0xbf11},
	{0x969a, 0xbf12},
	{0x969b, 0xbf13},
	{0x969c, 0xbf14},
	{0x969d, 0xbf15},
	{0x969e, 0xbf16},
	{0x969f, 0xbf17},
	{0x96a0, 0xbf1a},
	{0x96a1, 0xbf1e},
	{0x96a2, 0xbf1f},
	{0x96a3, 0xbf20},
	{0x96a4, 0xbf21},
	{0x96a5, 0xbf22},
	{0x96a6, 0xbf23},
	{0x96a7, 0xbf24},
	{0x96a8, 0xbf25},
	{0x96a9, 0xbf26},
	{0x96aa, 0xbf27},
	{0x96ab, 0xbf28},
	{0x96ac, 0xbf29},
	{0x96ad, 0xbf2a},
	{0x96ae, 0xbf2b},
	{0x96af, 0xbf2c},
	{0x96b0, 0xbf2d},
	{0x96b1, 0xbf2e},
	{0x96b2, 0xbf2f},
	{0x96b3, 0xbf30},
	{0x96b4, 0xbf31},
	{0x96b5, 0xbf32},
	{0x96b6, 0xbf33},
	{0x96b7, 0xbf34},
	{0x96b8, 0xbf35},
	{0x96b9, 0xbf36},
	{0x96ba, 0xbf37},
	{0x96bb, 0xbf38},
	{0x96bc, 0xbf39},
	{0x96bd, 0xbf3a},
	{0x96be, 0xbf3b},
	{0x96bf, 0xbf3c},
	{0x96c0, 0xbf3d},
	{0x96c1, 0xbf3e},
	{0x96c2, 0xbf3f},
	{0x96c3, 0xbf42},
	{0x96c4, 0xbf43},
	{0x96c5, 0xbf45},
	{0x96c6, 0xbf46},
	{0x96c7, 0xbf47},
	{0x96c8, 0xbf49},
	{0x96c9, 0xbf4a},
	{0x96ca, 0xbf4b},
	{0x96cb, 0xbf4c},
	{0x96cc, 0xbf4d},
	{0x96cd, 0xbf4e},
	{0x96ce, 0xbf4f},
	{0x96cf, 0xbf52},
	{0x96d0, 0xbf53},
	{0x96d1, 0xbf54},
	{0x96d2, 0xbf56},
	{0x96d3, 0xbf57},
	{0x96d4, 0xbf58},
	{0x96d5, 0xbf59},
	{0x96d6, 0xbf5a},
	{0x96d7, 0xbf5b},
	{0x96d8, 0xbf5c},
	{0x96d9, 0xbf5d},
	{0x96da, 0xbf5e},
	{0x96db, 0xbf5f},
	{0x96dc, 0xbf60},
	{0x96dd, 0xbf61},
	{0x96de, 0xbf62},
	{0x96df, 0xbf63},
	{0x96e0, 0xbf64},
	{0x96e1, 0xbf65},
	{0x96e2, 0xbf66},
	{0x96e3, 0xbf67},
	{0x96e4, 0xbf68},
	{0x96e5, 0xbf69},
	{0x96e6, 0xbf6a},
	{0x96e7, 0xbf6b},
	{0x96e8, 0xbf6c},
	{0x96e9, 0xbf6d},
	{0x96ea, 0xbf6e},
	{0x96eb, 0xbf6f},
	{0x96ec, 0xbf70},
	{0x96ed, 0xbf71},
	{0x96ee, 0xbf72},
	{0x96ef, 0xbf73},
	{0x96f0, 0xbf74},
	{0x96f1, 0xbf75},
	{0x96f2, 0xbf76},
	{0x96f3, 0xbf77},
	{0x96f4, 0xbf78},
	{0x96f5, 0xbf79},
	{0x96f6, 0xbf7a},
	{0x96f7, 0xbf7b},
	{0x96f8, 0xbf7c},
	{0x96f9, 0xbf7d},
	{0x96fa, 0xbf7e},
	{0x96fb, 0xbf7f},
	{0x96fc, 0xbf80},
	{0x96fd, 0xbf81},
	{0x96fe, 0xbf82},
	{0x9741, 0xbf83},
	{0x9742, 0xbf84},
	{0x9743, 0xbf85},
	{0x9744, 0xbf86},
	{0x9745, 0xbf87},
	{0x9746, 0xbf88},
	{0x9747, 0xbf89},
	{0x9748, 0xbf8a},
	{0x9749, 0xbf8b},
	{0x974a, 0xbf8c},
	{0x974b, 0xbf8d},
	{0x974c, 0xbf8e},
	{0x974d, 0xbf8f},
	{0x974e, 0xbf90},
	{0x974f, 0xbf91},
	{0x9750, 0xbf92},
	{0x9751, 0xbf93},
	{0x9752, 0xbf95},
	{0x9753, 0xbf96},
	{0x9754, 0xbf97},
	{0x9755, 0xbf98},
	{0x9756, 0xbf99},
	{0x9757, 0xbf9a},
	{0x9758, 0xbf9b},
	{0x9759, 0xbf9c},
	{0x975a, 0xbf9d},
	{0x9761, 0xbf9e},
	{0x9762, 0xbf9f},
	{0x9763, 0xbfa0},
	{0x9764, 0xbfa1},
	{0x9765, 0xbfa2},
	{0x9766, 0xbfa3},
	{0x9767, 0xbfa4},
	{0x9768, 0xbfa5},
	{0x9769, 0xbfa6},
	{0x976a, 0xbfa7},
	{0x976b, 0xbfa8},
	{0x976c, 0xbfa9},
	{0x976d, 0xbfaa},
	{0x976e, 0xbfab},
	{0x976f, 0xbfac},
	{0x9770, 0xbfad},
	{0x9771, 0xbfae},
	{0x9772, 0xbfaf},
	{0x9773, 0xbfb1},
	{0x9774, 0xbfb2},
	{0x9775, 0xbfb3},
	{0x9776, 0xbfb4},
	{0x9777, 0xbfb5},
	{0x9778, 0xbfb6},
	{0x9779, 0xbfb7},
	{0x977a, 0xbfb8},
	{0x9781, 0xbfb9},
	{0x9782, 0xbfba},
	{0x9783, 0xbfbb},
	{0x9784, 0xbfbc},
	{0x9785, 0xbfbd},
	{0x9786, 0xbfbe},
	{0x9787, 0xbfbf},
	{0x9788, 0xbfc0},
	{0x9789, 0xbfc1},
	{0x978a, 0xbfc2},
	{0x978b, 0xbfc3},
	{0x978c, 0xbfc4},
	{0x978d, 0xbfc6},
	{0x978e, 0xbfc7},
	{0x978f, 0xbfc8},
	{0x9790, 0xbfc9},
	{0x9791, 0xbfca},
	{0x9792, 0xbfcb},
	{0x9793, 0xbfce},
	{0x9794, 0xbfcf},
	{0x9795, 0xbfd1},
	{0x9796, 0xbfd2},
	{0x9797, 0xbfd3},
	{0x9798, 0xbfd5},
	{0x9799, 0xbfd6},
	{0x979a, 0xbfd7},
	{0x979b, 0xbfd8},
	{0x979c, 0xbfd9},
	{0x979d, 0xbfda},
	{0x979e, 0xbfdb},
	{0x979f, 0xbfdd},
	{0x97a0, 0xbfde},
	{0x97a1, 0xbfe0},
	{0x97a2, 0xbfe2},
	{0x97a3, 0xbfe3},
	{0x97a4, 0xbfe4},
	{0x97a5, 0xbfe5},
	{0x97a6, 0xbfe6},
	{0x97a7, 0xbfe7},
	{0x97a8, 0xbfe8},
	{0x97a9, 0xbfe9},
	{0x97aa, 0xbfea},
	{0x97ab, 0xbfeb},
	{0x97ac, 0xbfec},
	{0x97ad, 0xbfed},
	{0x97ae, 0xbfee},
	{0x97af, 0xbfef},
	{0x97b0, 0xbff0},
	{0x97b1, 0xbff1},
	{0x97b2, 0xbff2},
	{0x97b3, 0xbff3},
	{0x97b4, 0xbff4},
	{0x97b5, 0xbff5},
	{0x97b6, 0xbff6},
	{0x97b7, 0xbff7},
	{0x97b8, 0xbff8},
	{0x97b9, 0xbff9},
	{0x97ba, 0xbffa},
	{0x97bb, 0xbffb},
	{0x97bc, 0xbffc},
	{0x97bd, 0xbffd},
	{0x97be, 0xbffe},
	{0x97bf, 0xbfff},
	{0x97c0, 0xc000},
	{0x97c1, 0xc001},
	{0x97c2, 0xc002},
	{0x97c3, 0xc003},
	{0x97c4, 0xc004},
	{0x97c5, 0xc005},
	{0x97c6, 0xc006},
	{0x97c7, 0xc007},
	{0x97c8, 0xc008},
	{0x97c9, 0xc009},
	{0x97ca, 0xc00a},
	{0x97cb, 0xc00b},
	{0x97cc, 0xc00c},
	{0x97cd, 0xc00d},
	{0x97ce, 0xc00e},
	{0x97cf, 0xc00f},
	{0x97d0, 0xc010},
	{0x97d1, 0xc011},
	{0x97d2, 0xc012},
	{0x97d3, 0xc013},
	{0x97d4, 0xc014},
	{0x97d5, 0xc015},
	{0x97d6, 0xc016},
	{0x97d7, 0xc017},
	{0x97d8, 0xc018},
	{0x97d9, 0xc019},
	{0x97da, 0xc01a},
	{0x97db, 0xc01b},
	{0x97dc, 0xc01c},
	{0x97dd, 0xc01d},
	{0x97de, 0xc01e},
	{0x97df, 0xc01f},
	{0x97e0, 0xc020},
	{0x97e1, 0xc021},
	{0x97e2, 0xc022},
	{0x97e3, 0xc023},
	{0x97e4, 0xc024},
	{0x97e5, 0xc025},
	{0x97e6, 0xc026},
	{0x97e7, 0xc027},
	{0x97e8, 0xc028},
	{0x97e9, 0xc029},
	{0x97ea, 0xc02a},
	{0x97eb, 0xc02b},
	{0x97ec, 0xc02c},
	{0x97ed, 0xc02d},
	{0x97ee, 0xc02e},
	{0x97ef, 0xc02f},
	{0x97f0, 0xc030},
	{0x97f1, 0xc031},
	{0x97f2, 0xc032},
	{0x97f3, 0xc033},
	{0x97f4, 0xc034},
	{0x97f5, 0xc035},
	{0x97f6, 0xc036},
	{0x97f7, 0xc037},
	{0x97f8, 0xc038},
	{0x97f9, 0xc039},
	{0x97fa, 0xc03a},
	{0x97fb, 0xc03b},
	{0x97fc, 0xc03d},
	{0x97fd, 0xc03e},
	{0x97fe, 0xc03f},
	{0x9841, 0xc040},
	{0x9842, 0xc041},
	{0x9843, 0xc042},
	{0x9844, 0xc043},
	{0x9845, 0xc044},
	{0x9846, 0xc045},
	{0x9847, 0xc046},
	{0x9848, 0xc047},
	{0x9849, 0xc048},
	{0x984a, 0xc049},
	{0x984b, 0xc04a},
	{0x984c, 0xc04b},
	{0x984d, 0xc04c},
	{0x984e, 0xc04d},
	{0x984f, 0xc04e},
	{0x9850, 0xc04f},
	{0x9851, 0xc050},
	{0x9852, 0xc052},
	{0x9853, 0xc053},
	{0x9854, 0xc054},
	{0x9855, 0xc055},
	{0x9856, 0xc056},
	{0x9857, 0xc057},
	{0x9858, 0xc059},
	{0x9859, 0xc05a},
	{0x985a, 0xc05b},
	{0x9861, 0xc05d},
	{0x9862, 0xc05e},
	{0x9863, 0xc05f},
	{0x9864, 0xc061},
	{0x9865, 0xc062},
	{0x9866, 0xc063},
	{0x9867, 0xc064},
	{0x9868, 0xc065},
	{0x9869, 0xc066},
	{0x986a, 0xc067},
	{0x986b, 0xc06a},
	{0x986c, 0xc06b},
	{0x986d, 0xc06c},
	{0x986e, 0xc06d},
	{0x986f, 0xc06e},
	{0x9870, 0xc06f},
	{0x9871, 0xc070},
	{0x9872, 0xc071},
	{0x9873, 0xc072},
	{0x9874, 0xc073},
	{0x9875, 0xc074},
	{0x9876, 0xc075},
	{0x9877, 0xc076},
	{0x9878, 0xc077},
	{0x9879, 0xc078},
	{0x987a, 0xc079},
	{0x9881, 0xc07a},
	{0x9882, 0xc07b},
	{0x9883, 0xc07c},
	{0x9884, 0xc07d},
	{0x9885, 0xc07e},
	{0x9886, 0xc07f},
	{0x9887, 0xc080},
	{0x9888, 0xc081},
	{0x9889, 0xc082},
	{0x988a, 0xc083},
	{0x988b, 0xc084},
	{0x988c, 0xc085},
	{0x988d, 0xc086},
	{0x988e, 0xc087},
	{0x988f, 0xc088},
	{0x9890, 0xc089},
	{0x9891, 0xc08a},
	{0x9892, 0xc08b},
	{0x9893, 0xc08c},
	{0x9894, 0xc08d},
	{0x9895, 0xc08e},
	{0x9896, 0xc08f},
	{0x9897, 0xc092},
	{0x9898, 0xc093},
	{0x9899, 0xc095},
	{0x989a, 0xc096},
	{0x989b, 0xc097},
	{0x989c, 0xc099},
	{0x989d, 0xc09a},
	{0x989e, 0xc09b},
	{0x989f, 0xc09c},
	{0x98a0, 0xc09d},
	{0x98a1, 0xc09e},
	{0x98a2, 0xc09f},
	{0x98a3, 0xc0a2},
	{0x98a4, 0xc0a4},
	{0x98a5, 0xc0a6},
	{0x98a6, 0xc0a7},
	{0x98a7, 0xc0a8},
	{0x98a8, 0xc0a9},
	{0x98a9, 0xc0aa},
	{0x98aa, 0xc0ab},
	{0x98ab, 0xc0ae},
	{0x98ac, 0xc0b1},
	{0x98ad, 0xc0b2},
	{0x98ae, 0xc0b7},
	{0x98af, 0xc0b8},
	{0x98b0, 0xc0b9},
	{0x98b1, 0xc0ba},
	{0x98b2, 0xc0bb},
	{0x98b3, 0xc0be},
	{0x98b4, 0xc0c2},
	{0x98b5, 0xc0c3},
	{0x98b6, 0xc0c4},
	{0x98b7, 0xc0c6},
	{0x98b8, 0xc0c7},
	{0x98b9, 0xc0ca},
	{0x98ba, 0xc0cb},
	{0x98bb, 0xc0cd},
	{0x98bc, 0xc0ce},
	{0x98bd, 0xc0cf},
	{0x98be, 0xc0d1},
	{0x98bf, 0xc0d2},
	{0x98c0, 0xc0d3},
	{0x98c1, 0xc0d4},
	{0x98c2, 0xc0d5},
	{0x98c3, 0xc0d6},
	{0x98c4, 0xc0d7},
	{0x98c5, 0xc0da},
	{0x98c6, 0xc0de},
	{0x98c7, 0xc0df},
	{0x98c8, 0xc0e0},
	{0x98c9, 0xc0e1},
	{0x98ca, 0xc0e2},
	{0x98cb, 0xc0e3},
	{0x98cc, 0xc0e6},
	{0x98cd, 0xc0e7},
	{0x98ce, 0xc0e9},
	{0x98cf, 0xc0ea},
	{0x98d0, 0xc0eb},
	{0x98d1, 0xc0ed},
	{0x98d2, 0xc0ee},
	{0x98d3, 0xc0ef},
	{0x98d4, 0xc0f0},
	{0x98d5, 0xc0f1},
	{0x98d6, 0xc0f2},
	{0x98d7, 0xc0f3},
	{0x98d8, 0xc0f6},
	{0x98d9, 0xc0f8},
	{0x98da, 0xc0fa},
	{0x98db, 0xc0fb},
	{0x98dc, 0xc0fc},
	{0x98dd, 0xc0fd},
	{0x98de, 0xc0fe},
	{0x98df, 0xc0ff},
	{0x98e0, 0xc101},
	{0x98e1, 0xc102},
	{0x98e2, 0xc103},
	{0x98e3, 0xc105},
	{0x98e4, 0xc106},
	{0x98e5, 0xc107},
	{0x98e6, 0xc109},
	{0x98e7, 0xc10a},
	{0x98e8, 0xc10b},
	{0x98e9, 0xc10c},
	{0x98ea, 0xc10d},
	{0x98eb, 0xc10e},
	{0x98ec, 0xc10f},
	{0x98ed, 0xc111},
	{0x98ee, 0xc112},
	{0x98ef, 0xc113},
	{0x98f0, 0xc114},
	{0x98f1, 0xc116},
	{0x98f2, 0xc117},
	{0x98f3, 0xc118},
	{0x98f4, 0xc119},
	{0x98f5, 0xc11a},
	{0x98f6, 0xc11b},
	{0x98f7, 0xc121},
	{0x98f8, 0xc122},
	{0x98f9, 0xc125},
	{0x98fa, 0xc128},
	{0x98fb, 0xc129},
	{0x98fc, 0xc12a},
	{0x98fd, 0xc12b},
	{0x98fe, 0xc12e},
	{0x9941, 0xc132},
	{0x9942, 0xc133},
	{0x9943, 0xc134},
	{0x9944, 0xc135},
	{0x9945, 0xc137},
	{0x9946, 0xc13a},
	{0x9947, 0xc13b},
	{0x9948, 0xc13d},
	{0x9949, 0xc13e},
	{0x994a, 0xc13f},
	{0x994b, 0xc141},
	{0x994c, 0xc142},
	{0x994d, 0xc143},
	{0x994e, 0xc144},
	{0x994f, 0xc145},
	{0x9950, 0xc146},
	{0x9951, 0xc147},
	{0x9952, 0xc14a},
	{0x9953, 0xc14e},
	{0x9954, 0xc14f},
	{0x9955, 0xc150},
	{0x9956, 0xc151},
	{0x9957, 0xc152},
	{0x9958, 0xc153},
	{0x9959, 0xc156},
	{0x995a, 0xc157},
	{0x9961, 0xc159},
	{0x9962, 0xc15a},
	{0x9963, 0xc15b},
	{0x9964, 0xc15d},
	{0x9965, 0xc15e},
	{0x9966, 0xc15f},
	{0x9967, 0xc160},
	{0x9968, 0xc161},
	{0x9969, 0xc162},
	{0x996a, 0xc163},
	{0x996b, 0xc166},
	{0x996c, 0xc16a},
	{0x996d, 0xc16b},
	{0x996e, 0xc16c},
	{0x996f, 0xc16d},
	{0x9970, 0xc16e},
	{0x9971, 0xc16f},
	{0x9972, 0xc171},
	{0x9973, 0xc172},
	{0x9974, 0xc173},
	{0x9975, 0xc175},
	{0x9976, 0xc176},
	{0x9977, 0xc177},
	{0x9978, 0xc179},
	{0x9979, 0xc17a},
	{0x997a, 0xc17b},
	{0x9981, 0xc17c},
	{0x9982, 0xc17d},
	{0x9983, 0xc17e},
	{0x9984, 0xc17f},
	{0x9985, 0xc180},
	{0x9986, 0xc181},
	{0x9987, 0xc182},
	{0x9988, 0xc183},
	{0x9989, 0xc184},
	{0x998a, 0xc186},
	{0x998b, 0xc187},
	{0x998c, 0xc188},
	{0x998d, 0xc189},
	{0x998e, 0xc18a},
	{0x998f, 0xc18b},
	{0x9990, 0xc18f},
	{0x9991, 0xc191},
	{0x9992, 0xc192},
	{0x9993, 0xc193},
	{0x9994, 0xc195},
	{0x9995, 0xc197},
	{0x9996, 0xc198},
	{0x9997, 0xc199},
	{0x9998, 0xc19a},
	{0x9999, 0xc19b},
	{0x999a, 0xc19e},
	{0x999b, 0xc1a0},
	{0x999c, 0xc1a2},
	{0x999d, 0xc1a3},
	{0x999e, 0xc1a4},
	{0x999f, 0xc1a6},
	{0x99a0, 0xc1a7},
	{0x99a1, 0xc1aa},
	{0x99a2, 0xc1ab},
	{0x99a3, 0xc1ad},
	{0x99a4, 0xc1ae},
	{0x99a5, 0xc1af},
	{0x99a6, 0xc1b1},
	{0x99a7, 0xc1b2},
	{0x99a8, 0xc1b3},
	{0x99a9, 0xc1b4},
	{0x99aa, 0xc1b5},
	{0x99ab, 0xc1b6},
	{0x99ac, 0xc1b7},
	{0x99ad, 0xc1b8},
	{0x99ae, 0xc1b9},
	{0x99af, 0xc1ba},
	{0x99b0, 0xc1bb},
	{0x99b1, 0xc1bc},
	{0x99b2, 0xc1be},
	{0x99b3, 0xc1bf},
	{0x99b4, 0xc1c0},
	{0x99b5, 0xc1c1},
	{0x99b6, 0xc1c2},
	{0x99b7, 0xc1c3},
	{0x99b8, 0xc1c5},
	{0x99b9, 0xc1c6},
	{0x99ba, 0xc1c7},
	{0x99bb, 0xc1c9},
	{0x99bc, 0xc1ca},
	{0x99bd, 0xc1cb},
	{0x99be, 0xc1cd},
	{0x99bf, 0xc1ce},
	{0x99c0, 0xc1cf},
	{0x99c1, 0xc1d0},
	{0x99c2, 0xc1d1},
	{0x99c3, 0xc1d2},
	{0x99c4, 0xc1d3},
	{0x99c5, 0xc1d5},
	{0x99c6, 0xc1d6},
	{0x99c7, 0xc1d9},
	{0x99c8, 0xc1da},
	{0x99c9, 0xc1db},
	{0x99ca, 0xc1dc},
	{0x99cb, 0xc1dd},
	{0x99cc, 0xc1de},
	{0x99cd, 0xc1df},
	{0x99ce, 0xc1e1},
	{0x99cf, 0xc1e2},
	{0x99d0, 0xc1e3},
	{0x99d1, 0xc1e5},
	{0x99d2, 0xc1e6},
	{0x99d3, 0xc1e7},
	{0x99d4, 0xc1e9},
	{0x99d5, 0xc1ea},
	{0x99d6, 0xc1eb},
	{0x99d7, 0xc1ec},
	{0x99d8, 0xc1ed},
	{0x99d9, 0xc1ee},
	{0x99da, 0xc1ef},
	{0x99db, 0xc1f2},
	{0x99dc, 0xc1f4},
	{0x99dd, 0xc1f5},
	{0x99de, 0xc1f6},
	{0x99df, 0xc1f7},
	{0x99e0, 0xc1f8},
	{0x99e1, 0xc1f9},
	{0x99e2, 0xc1fa},
	{0x99e3, 0xc1fb},
	{0x99e4, 0xc1fe},
	{0x99e5, 0xc1ff},
	{0x99e6, 0xc201},
	{0x99e7, 0xc202},
	{0x99e8, 0xc203},
	{0x99e9, 0xc205},
	{0x99ea, 0xc206},
	{0x99eb, 0xc207},
	{0x99ec, 0xc208},
	{0x99ed, 0xc209},
	{0x99ee, 0xc20a},
	{0x99ef, 0xc20b},
	{0x99f0, 0xc20e},
	{0x99f1, 0xc210},
	{0x99f2, 0xc212},
	{0x99f3, 0xc213},
	{0x99f4, 0xc214},
	{0x99f5, 0xc215},
	{0x99f6, 0xc216},
	{0x99f7, 0xc217},
	{0x99f8, 0xc21a},
	{0x99f9, 0xc21b},
	{0x99fa, 0xc21d},
	{0x99fb, 0xc21e},
	{0x99fc, 0xc221},
	{0x99fd, 0xc222},
	{0x99fe, 0xc223},
	{0x9a41, 0xc224},
	{0x9a42, 0xc225},
	{0x9a43, 0xc226},
	{0x9a44, 0xc227},
	{0x9a45, 0xc22a},
	{0x9a46, 0xc22c},
	{0x9a47, 0xc22e},
	{0x9a48, 0xc230},
	{0x9a49, 0xc233},
	{0x9a4a, 0xc235},
	{0x9a4b, 0xc236},
	{0x9a4c, 0xc237},
	{0x9a4d, 0xc238},
	{0x9a4e, 0xc239},
	{0x9a4f, 0xc23a},
	{0x9a50, 0xc23b},
	{0x9a51, 0xc23c},
	{0x9a52, 0xc23d},
	{0x9a53, 0xc23e},
	{0x9a54, 0xc23f},
	{0x9a55, 0xc240},
	{0x9a56, 0xc241},
	{0x9a57, 0xc242},
	{0x9a58, 0xc243},
	{0x9a59, 0xc244},
	{0x9a5a, 0xc245},
	{0x9a61, 0xc246},
	{0x9a62, 0xc247},
	{0x9a63, 0xc249},
	{0x9a64, 0xc24a},
	{0x9a65, 0xc24b},
	{0x9a66, 0xc24c},
	{0x9a67, 0xc24d},
	{0x9a68, 0xc24e},
	{0x9a69, 0xc24f},
	{0x9a6a, 0xc252},
	{0x9a6b, 0xc253},
	{0x9a6c, 0xc255},
	{0x9a6d, 0xc256},
	{0x9a6e, 0xc257},
	{0x9a6f, 0xc259},
	{0x9a70, 0xc25a},
	{0x9a71, 0xc25b},
	{0x9a72, 0xc25c},
	{0x9a73, 0xc25d},
	{0x9a74, 0xc25e},
	{0x9a75, 0xc25f},
	{0x9a76, 0xc261},
	{0x9a77, 0xc262},
	{0x9a78, 0xc263},
	{0x9a79, 0xc264},
	{0x9a7a, 0xc266},
	{0x9a81, 0xc267},
	{0x9a82, 0xc268},
	{0x9a83, 0xc269},
	{0x9a84, 0xc26a},
	{0x9a85, 0xc26b},
	{0x9a86, 0xc26e},
	{0x9a87, 0xc26f},
	{0x9a88, 0xc271},
	{0x9a89, 0xc272},
	{0x9a8a, 0xc273},
	{0x9a8b, 0xc275},
	{0x9a8c, 0xc276},
	{0x9a8d, 0xc277},
	{0x9a8e, 0xc278},
	{0x9a8f, 0xc279},
	{0x9a90, 0xc27a},
	{0x9a91, 0xc27b},
	{0x9a92, 0xc27e},
	{0x9a93, 0xc280},
	{0x9a94, 0xc282},
	{0x9a95, 0xc283},
	{0x9a96, 0xc284},
	{0x9a97, 0xc285},
	{0x9a98, 0xc286},
	{0x9a99, 0xc287},
	{0x9a9a, 0xc28a},
	{0x9a9b, 0xc28b},
	{0x9a9c, 0xc28c},
	{0x9a9d, 0xc28d},
	{0x9a9e, 0xc28e},
	{0x9a9f, 0xc28f},
	{0x9aa0, 0xc291},
	{0x9aa1, 0xc292},
	{0x9aa2, 0xc293},
	{0x9aa3, 0xc294},
	{0x9aa4, 0xc295},
	{0x9aa5, 0xc296},
	{0x9aa6, 0xc297},
	{0x9aa7, 0xc299},
	{0x9aa8, 0xc29a},
	{0x9aa9, 0xc29c},
	{0x9aaa, 0xc29e},
	{0x9aab, 0xc29f},
	{0x9aac, 0xc2a0},
	{0x9aad, 0xc2a1},
	{0x9aae, 0xc2a2},
	{0x9aaf, 0xc2a3},
	{0x9ab0, 0xc2a6},
	{0x9ab1, 0xc2a7},
	{0x9ab2, 0xc2a9},
	{0x9ab3, 0xc2aa},
	{0x9ab4, 0xc2ab},
	{0x9ab5, 0xc2ae},
	{0x9ab6, 0xc2af},
	{0x9ab7, 0xc2b0},
	{0x9ab8, 0xc2b1},
	{0x9ab9, 0xc2b2},
	{0x9aba, 0xc2b3},
	{0x9abb, 0xc2b6},
	{0x9abc, 0xc2b8},
	{0x9abd, 0xc2ba},
	{0x9abe, 0xc2bb},
	{0x9abf, 0xc2bc},
	{0x9ac0, 0xc2bd},
	{0x9ac1, 0xc2be},
	{0x9ac2, 0xc2bf},
	{0x9ac3, 0xc2c0},
	{0x9ac4, 0xc2c1},
	{0x9ac5, 0xc2c2},
	{0x9ac6, 0xc2c3},
	{0x9ac7, 0xc2c4},
	{0x9ac8, 0xc2c5},
	{0x9ac9, 0xc2c6},
	{0x9aca, 0xc2c7},
	{0x9acb, 0xc2c8},
	{0x9acc, 0xc2c9},
	{0x9acd, 0xc2ca},
	{0x9ace, 0xc2cb},
	{0x9acf, 0xc2cc},
	{0x9ad0, 0xc2cd},
	{0x9ad1, 0xc2ce},
	{0x9ad2, 0xc2cf},
	{0x9ad3, 0xc2d0},
	{0x9ad4, 0xc2d1},
	{0x9ad5, 0xc2d2},
	{0x9ad6, 0xc2d3},
	{0x9ad7, 0xc2d4},
	{0x9ad8, 0xc2d5},
	{0x9ad9, 0xc2d6},
	{0x9ada, 0xc2d7},
	{0x9adb, 0xc2d8},
	{0x9adc, 0xc2d9},
	{0x9add, 0xc2da},
	{0x9ade, 0xc2db},
	{0x9adf, 0xc2de},
	{0x9ae0, 0xc2df},
	{0x9ae1, 0xc2e1},
	{0x9ae2, 0xc2e2},
	{0x9ae3, 0xc2e5},
	{0x9ae4, 0xc2e6},
	{0x9ae5, 0xc2e7},
	{0x9ae6, 0xc2e8},
	{0x9ae7, 0xc2e9},
	{0x9ae8, 0xc2ea},
	{0x9ae9, 0xc2ee},
	{0x9aea, 0xc2f0},
	{0x9aeb, 0xc2f2},
	{0x9aec, 0xc2f3},
	{0x9aed, 0xc2f4},
	{0x9aee, 0xc2f5},
	{0x9aef, 0xc2f7},
	{0x9af0, 0xc2fa},
	{0x9af1, 0xc2fd},
	{0x9af2, 0xc2fe},
	{0x9af3, 0xc2ff},
	{0x9af4, 0xc301},
	{0x9af5, 0xc302},
	{0x9af6, 0xc303},
	{0x9af7, 0xc304},
	{0x9af8, 0xc305},
	{0x9af9, 0xc306},
	{0x9afa, 0xc307},
	{0x9afb, 0xc30a},
	{0x9afc, 0xc30b},
	{0x9afd, 0xc30e},
	{0x9afe, 0xc30f},
	{0x9b41, 0xc310},
	{0x9b42, 0xc311},
	{0x9b43, 0xc312},
	{0x9b44, 0xc316},
	{0x9b45, 0xc317},
	{0x9b46, 0xc319},
	{0x9b47, 0xc31a},
	{0x9b48, 0xc31b},
	{0x9b49, 0xc31d},
	{0x9b4a, 0xc31e},
	{0x9b4b, 0xc31f},
	{0x9b4c, 0xc320},
	{0x9b4d, 0xc321},
	{0x9b4e, 0xc322},
	{0x9b4f, 0xc323},
	{0x9b50, 0xc326},
	{0x9b51, 0xc327},
	{0x9b52, 0xc32a},
	{0x9b53, 0xc32b},
	{0x9b54, 0xc32c},
	{0x9b55, 0xc32d},
	{0x9b56, 0xc32e},
	{0x9b57, 0xc32f},
	{0x9b58, 0xc330},
	{0x9b59, 0xc331},
	{0x9b5a, 0xc332},
	{0x9b61, 0xc333},
	{0x9b62, 0xc334},
	{0x9b63, 0xc335},
	{0x9b64, 0xc336},
	{0x9b65, 0xc337},
	{0x9b66, 0xc338},
	{0x9b67, 0xc339},
	{0x9b68, 0xc33a},
	{0x9b69, 0xc33b},
	{0x9b6a, 0xc33c},
	{0x9b6b, 0xc33d},
	{0x9b6c, 0xc33e},
	{0x9b6d, 0xc33f},
	{0x9b6e, 0xc340},
	{0x9b6f, 0xc341},
	{0x9b70, 0xc342},
	{0x9b71, 0xc343},
	{0x9b72, 0xc344},
	{0x9b73, 0xc346},
	{0x9b74, 0xc347},
	{0x9b75, 0xc348},
	{0x9b76, 0xc349},
	{0x9b77, 0xc34a},
	{0x9b78, 0xc34b},
	{0x9b79, 0xc34c},
	{0x9b7a, 0xc34d},
	{0x9b81, 0xc34e},
	{0x9b82, 0xc34f},
	{0x9b83, 0xc350},
	{0x9b84, 0xc351},
	{0x9b85, 0xc352},
	{0x9b86, 0xc353},
	{0x9b87, 0xc354},
	{0x9b88, 0xc355},
	{0x9b89, 0xc356},
	{0x9b8a, 0xc357},
	{0x9b8b, 0xc358},
	{0x9b8c, 0xc359},
	{0x9b8d, 0xc35a},
	{0x9b8e, 0xc35b},
	{0x9b8f, 0xc35c},
	{0x9b90, 0xc35d},
	{0x9b91, 0xc35e},
	{0x9b92, 0xc35f},
	{0x9b93, 0xc360},
	{0x9b94, 0xc361},
	{0x9b95, 0xc362},
	{0x9b96, 0xc363},
	{0x9b97, 0xc364},
	{0x9b98, 0xc365},
	{0x9b99, 0xc366},
	{0x9b9a, 0xc367},
	{0x9b9b, 0xc36a},
	{0x9b9c, 0xc36b},
	{0x9b9d, 0xc36d},
	{0x9b9e, 0xc36e},
	{0x9b9f, 0xc36f},
	{0x9ba0, 0xc371},
	{0x9ba1, 0xc373},
	{0x9ba2, 0xc374},
	{0x9ba3, 0xc375},
	{0x9ba4, 0xc376},
	{0x9ba5, 0xc377},
	{0x9ba6, 0xc37a},
	{0x9ba7, 0xc37b},
	{0x9ba8, 0xc37e},
	{0x9ba9, 0xc37f},
	{0x9baa, 0xc380},
	{0x9bab, 0xc381},
	{0x9bac, 0xc382},
	{0x9bad, 0xc383},
	{0x9bae, 0xc385},
	{0x9baf, 0xc386},
	{0x9bb0, 0xc387},
	{0x9bb1, 0xc389},
	{0x9bb2, 0xc38a},
	{0x9bb3, 0xc38b},
	{0x9bb4, 0xc38d},
	{0x9bb5, 0xc38e},
	{0x9bb6, 0xc38f},
	{0x9bb7, 0xc390},
	{0x9bb8, 0xc391},
	{0x9bb9, 0xc392},
	{0x9bba, 0xc393},
	{0x9bbb, 0xc394},
	{0x9bbc, 0xc395},
	{0x9bbd, 0xc396},
	{0x9bbe, 0xc397},
	{0x9bbf, 0xc398},
	{0x9bc0, 0xc399},
	{0x9bc1, 0xc39a},
	{0x9bc2, 0xc39b},
	{0x9bc3, 0xc39c},
	{0x9bc4, 0xc39d},
	{0x9bc5, 0xc39e},
	{0x9bc6, 0xc39f},
	{0x9bc7, 0xc3a0},
	{0x9bc8, 0xc3a1},
	{0x9bc9, 0xc3a2},
	{0x9bca, 0xc3a3},
	{0x9bcb, 0xc3a4},
	{0x9bcc, 0xc3a5},
	{0x9bcd, 0xc3a6},
	{0x9bce, 0xc3a7},
	{0x9bcf, 0xc3a8},
	{0x9bd0, 0xc3a9},
	{0x9bd1, 0xc3aa},
	{0x9bd2, 0xc3ab},
	{0x9bd3, 0xc3ac},
	{0x9bd4, 0xc3ad},
	{0x9bd5, 0xc3ae},
	{0x9bd6, 0xc3af},
	{0x9bd7, 0xc3b0},
	{0x9bd8, 0xc3b1},
	{0x9bd9, 0xc3b2},
	{0x9bda, 0xc3b3},
	{0x9bdb, 0xc3b4},
	{0x9bdc, 0xc3b5},
	{0x9bdd, 0xc3b6},
	{0x9bde, 0xc3b7},
	{0x9bdf, 0xc3b8},
	{0x9be0, 0xc3b9},
	{0x9be1, 0xc3ba},
	{0x9be2, 0xc3bb},
	{0x9be3, 0xc3bc},
	{0x9be4, 0xc3bd},
	{0x9be5, 0xc3be},
	{0x9be6, 0xc3bf},
	{0x9be7, 0xc3c1},
	{0x9be8, 0xc3c2},
	{0x9be9, 0xc3c3},
	{0x9bea, 0xc3c4},
	{0x9beb, 0xc3c5},
	{0x9bec, 0xc3c6},
	{0x9bed, 0xc3c7},
	{0x9bee, 0xc3c8},
	{0x9bef, 0xc3c9},
	{0x9bf0, 0xc3ca},
	{0x9bf1, 0xc3cb},
	{0x9bf2, 0xc3cc},
	{0x9bf3, 0xc3cd},
	{0x9bf4, 0xc3ce},
	{0x9bf5, 0xc3cf},
	{0x9bf6, 0xc3d0},
	{0x9bf7, 0xc3d1},
	{0x9bf8, 0xc3d2},
	{0x9bf9, 0xc3d3},
	{0x9bfa, 0xc3d4},
	{0x9bfb, 0xc3d5},
	{0x9bfc, 0xc3d6},
	{0x9bfd, 0xc3d7},
	{0x9bfe, 0xc3da},
	{0x9c41, 0xc3db},
	{0x9c42, 0xc3dd},
	{0x9c43, 0xc3de},
	{0x9c44, 0xc3e1},
	{0x9c45, 0xc3e3},
	{0x9c46, 0xc3e4},
	{0x9c47, 0xc3e5},
	{0x9c48, 0xc3e6},
	{0x9c49, 0xc3e7},
	{0x9c4a, 0xc3ea},
	{0x9c4b, 0xc3eb},
	{0x9c4c, 0xc3ec},
	{0x9c4d, 0xc3ee},
	{0x9c4e, 0xc3ef},
	{0x9c4f, 0xc3f0},
	{0x9c50, 0xc3f1},
	{0x9c51, 0xc3f2},
	{0x9c52, 0xc3f3},
	{0x9c53, 0xc3f6},
	{0x9c54, 0xc3f7},
	{0x9c55, 0xc3f9},
	{0x9c56, 0xc3fa},
	{0x9c57, 0xc3fb},
	{0x9c58, 0xc3fc},
	{0x9c59, 0xc3fd},
	{0x9c5a, 0xc3fe},
	{0x9c61, 0xc3ff},
	{0x9c62, 0xc400},
	{0x9c63, 0xc401},
	{0x9c64, 0xc402},
	{0x9c65, 0xc403},
	{0x9c66, 0xc404},
	{0x9c67, 0xc405},
	{0x9c68, 0xc406},
	{0x9c69, 0xc407},
	{0x9c6a, 0xc409},
	{0x9c6b, 0xc40a},
	{0x9c6c, 0xc40b},
	{0x9c6d, 0xc40c},
	{0x9c6e, 0xc40d},
	{0x9c6f, 0xc40e},
	{0x9c70, 0xc40f},
	{0x9c71, 0xc411},
	{0x9c72, 0xc412},
	{0x9c73, 0xc413},
	{0x9c74, 0xc414},
	{0x9c75, 0xc415},
	{0x9c76, 0xc416},
	{0x9c77, 0xc417},
	{0x9c78, 0xc418},
	{0x9c79, 0xc419},
	{0x9c7a, 0xc41a},
	{0x9c81, 0xc41b},
	{0x9c82, 0xc41c},
	{0x9c83, 0xc41d},
	{0x9c84, 0xc41e},
	{0x9c85, 0xc41f},
	{0x9c86, 0xc420},
	{0x9c87, 0xc421},
	{0x9c88, 0xc422},
	{0x9c89, 0xc423},
	{0x9c8a, 0xc425},
	{0x9c8b, 0xc426},
	{0x9c8c, 0xc427},
	{0x9c8d, 0xc428},
	{0x9c8e, 0xc429},
	{0x9c8f, 0xc42a},
	{0x9c90, 0xc42b},
	{0x9c91, 0xc42d},
	{0x9c92, 0xc42e},
	{0x9c93, 0xc42f},
	{0x9c94, 0xc431},
	{0x9c95, 0xc432},
	{0x9c96, 0xc433},
	{0x9c97, 0xc435},
	{0x9c98, 0xc436},
	{0x9c99, 0xc437},
	{0x9c9a, 0xc438},
	{0x9c9b, 0xc439},
	{0x9c9c, 0xc43a},
	{0x9c9d, 0xc43b},
	{0x9c9e, 0xc43e},
	{0x9c9f, 0xc43f},
	{0x9ca0, 0xc440},
	{0x9ca1, 0xc441},
	{0x9ca2, 0xc442},
	{0x9ca3, 0xc443},
	{0x9ca4, 0xc444},
	{0x9ca5, 0xc445},
	{0x9ca6, 0xc446},
	{0x9ca7, 0xc447},
	{0x9ca8, 0xc449},
	{0x9ca9, 0xc44a},
	{0x9caa, 0xc44b},
	{0x9cab, 0xc44c},
	{0x9cac, 0xc44d},
	{0x9cad, 0xc44e},
	{0x9cae, 0xc44f},
	{0x9caf, 0xc450},
	{0x9cb0, 0xc451},
	{0x9cb1, 0xc452},
	{0x9cb2, 0xc453},
	{0x9cb3, 0xc454},
	{0x9cb4, 0xc455},
	{0x9cb5, 0xc456},
	{0x9cb6, 0xc457},
	{0x9cb7, 0xc458},
	{0x9cb8, 0xc459},
	{0x9cb9, 0xc45a},
	{0x9cba, 0xc45b},
	{0x9cbb, 0xc45c},
	{0x9cbc, 0xc45d},
	{0x9cbd, 0xc45e},
	{0x9cbe, 0xc45f},
	{0x9cbf, 0xc460},
	{0x9cc0, 0xc461},
	{0x9cc1, 0xc462},
	{0x9cc2, 0xc463},
	{0x9cc3, 0xc466},
	{0x9cc4, 0xc467},
	{0x9cc5, 0xc469},
	{0x9cc6, 0xc46a},
	{0x9cc7, 0xc46b},
	{0x9cc8, 0xc46d},
	{0x9cc9, 0xc46e},
	{0x9cca, 0xc46f},
	{0x9ccb, 0xc470},
	{0x9ccc, 0xc471},
	{0x9ccd, 0xc472},
	{0x9cce, 0xc473},
	{0x9ccf, 0xc476},
	{0x9cd0, 0xc477},
	{0x9cd1, 0xc478},
	{0x9cd2, 0xc47a},
	{0x9cd3, 0xc47b},
	{0x9cd4, 0xc47c},
	{0x9cd5, 0xc47d},
	{0x9cd6, 0xc47e},
	{0x9cd7, 0xc47f},
	{0x9cd8, 0xc481},
	{0x9cd9, 0xc482},
	{0x9cda, 0xc483},
	{0x9cdb, 0xc484},
	{0x9cdc, 0xc485},
	{0x9cdd, 0xc486},
	{0x9cde, 0xc487},
	{0x9cdf, 0xc488},
	{0x9ce0, 0xc489},
	{0x9ce1, 0xc48a},
	{0x9ce2, 0xc48b},
	{0x9ce3, 0xc48c},
	{0x9ce4, 0xc48d},
	{0x9ce5, 0xc48e},
	{0x9ce6, 0xc48f},
	{0x9ce7, 0xc490},
	{0x9ce8, 0xc491},
	{0x9ce9, 0xc492},
	{0x9cea, 0xc493},
	{0x9ceb, 0xc495},
	{0x9cec, 0xc496},
	{0x9ced, 0xc497},
	{0x9cee, 0xc498},
	{0x9cef, 0xc499},
	{0x9cf0, 0xc49a},
	{0x9cf1, 0xc49b},
	{0x9cf2, 0xc49d},
	{0x9cf3, 0xc49e},
	{0x9cf4, 0xc49f},
	{0x9cf5, 0xc4a0},
	{0x9cf6, 0xc4a1},
	{0x9cf7, 0xc4a2},
	{0x9cf8, 0xc4a3},
	{0x9cf9, 0xc4a4},
	{0x9cfa, 0xc4a5},
	{0x9cfb, 0xc4a6},
	{0x9cfc, 0xc4a7},
	{0x9cfd, 0xc4a8},
	{0x9cfe, 0xc4a9},
	{0x9d41, 0xc4aa},
	{0x9d42, 0xc4ab},
	{0x9d43, 0xc4ac},
	{0x9d44, 0xc4ad},
	{0x9d45, 0xc4ae},
	{0x9d46, 0xc4af},
	{0x9d47, 0xc4b0},
	{0x9d48, 0xc4b1},
	{0x9d49, 0xc4b2},
	{0x9d4a, 0xc4b3},
	{0x9d4b, 0xc4b4},
	{0x9d4c, 0xc4b5},
	{0x9d4d, 0xc4b6},
	{0x9d4e, 0xc4b7},
	{0x9d4f, 0xc4b9},
	{0x9d50, 0xc4ba},
	{0x9d51, 0xc4bb},
	{0x9d52, 0xc4bd},
	{0x9d53, 0xc4be},
	{0x9d54, 0xc4bf},
	{0x9d55, 0xc4c0},
	{0x9d56, 0xc4c1},
	{0x9d57, 0xc4c2},
	{0x9d58, 0xc4c3},
	{0x9d59, 0xc4c4},
	{0x9d5a, 0xc4c5},
	{0x9d61, 0xc4c6},
	{0x9d62, 0xc4c7},
	{0x9d63, 0xc4c8},
	{0x9d64, 0xc4c9},
	{0x9d65, 0xc4ca},
	{0x9d66, 0xc4cb},
	{0x9d67, 0xc4cc},
	{0x9d68, 0xc4cd},
	{0x9d69, 0xc4ce},
	{0x9d6a, 0xc4cf},
	{0x9d6b, 0xc4d0},
	{0x9d6c, 0xc4d1},
	{0x9d6d, 0xc4d2},
	{0x9d6e, 0xc4d3},
	{0x9d6f, 0xc4d4},
	{0x9d70, 0xc4d5},
	{0x9d71, 0xc4d6},
	{0x9d72, 0xc4d7},
	{0x9d73, 0xc4d8},
	{0x9d74, 0xc4d9},
	{0x9d75, 0xc4da},
	{0x9d76, 0xc4db},
	{0x9d77, 0xc4dc},
	{0x9d78, 0xc4dd},
	{0x9d79, 0xc4de},
	{0x9d7a, 0xc4df},
	{0x9d81, 0xc4e0},
	{0x9d82, 0xc4e1},
	{0x9d83, 0xc4e2},
	{0x9d84, 0xc4e3},
	{0x9d85, 0xc4e4},
	{0x9d86, 0xc4e5},
	{0x9d87, 0xc4e6},
	{0x9d88, 0xc4e7},
	{0x9d89, 0xc4e8},
	{0x9d8a, 0xc4ea},
	{0x9d8b, 0xc4eb},
	{0x9d8c, 0xc4ec},
	{0x9d8d, 0xc4ed},
	{0x9d8e, 0xc4ee},
	{0x9d8f, 0xc4ef},
	{0x9d90, 0xc4f2},
	{0x9d91, 0xc4f3},
	{0x9d92, 0xc4f5},
	{0x9d93, 0xc4f6},
	{0x9d94, 0xc4f7},
	{0x9d95, 0xc4f9},
	{0x9d96, 0xc4fb},
	{0x9d97, 0xc4fc},
	{0x9d98, 0xc4fd},
	{0x9d99, 0xc4fe},
	{0x9d9a, 0xc502},
	{0x9d9b, 0xc503},
	{0x9d9c, 0xc504},
	{0x9d9d, 0xc505},
	{0x9d9e, 0xc506},
	{0x9d9f, 0xc507},
	{0x9da0, 0xc508},
	{0x9da1, 0xc509},
	{0x9da2, 0xc50a},
	{0x9da3, 0xc50b},
	{0x9da4, 0xc50d},
	{0x9da5, 0xc50e},
	{0x9da6, 0xc50f},
	{0x9da7, 0xc511},
	{0x9da8, 0xc512},
	{0x9da9, 0xc513},
	{0x9daa, 0xc515},
	{0x9dab, 0xc516},
	{0x9dac, 0xc517},
	{0x9dad, 0xc518},
	{0x9dae, 0xc519},
	{0x9daf, 0xc51a},
	{0x9db0, 0xc51b},
	{0x9db1, 0xc51d},
	{0x9db2, 0xc51e},
	{0x9db3, 0xc51f},
	{0x9db4, 0xc520},
	{0x9db5, 0xc521},
	{0x9db6, 0xc522},
	{0x9db7, 0xc523},
	{0x9db8, 0xc524},
	{0x9db9, 0xc525},
	{0x9dba, 0xc526},
	{0x9dbb, 0xc527},
	{0x9dbc, 0xc52a},
	{0x9dbd, 0xc52b},
	{0x9dbe, 0xc52d},
	{0x9dbf, 0xc52e},
	{0x9dc0, 0xc52f},
	{0x9dc1, 0xc531},
	{0x9dc2, 0xc532},
	{0x9dc3, 0xc533},
	{0x9dc4, 0xc534},
	{0x9dc5, 0xc535},
	{0x9dc6, 0xc536},
	{0x9dc7, 0xc537},
	{0x9dc8, 0xc53a},
	{0x9dc9, 0xc53c},
	{0x9dca, 0xc53e},
	{0x9dcb, 0xc53f},
	{0x9dcc, 0xc540},
	{0x9dcd, 0xc541},
	{0x9dce, 0xc542},
	{0x9dcf, 0xc543},
	{0x9dd0, 0xc546},
	{0x9dd1, 0xc547},
	{0x9dd2, 0xc54b},
	{0x9dd3, 0xc54f},
	{0x9dd4, 0xc550},
	{0x9dd5, 0xc551},
	{0x9dd6, 0xc552},
	{0x9dd7, 0xc556},
	{0x9dd8, 0xc55a},
	{0x9dd9, 0xc55b},
	{0x9dda, 0xc55c},
	{0x9ddb, 0xc55f},
	{0x9ddc, 0xc562},
	{0x9ddd, 0xc563},
	{0x9dde, 0xc565},
	{0x9ddf, 0xc566},
	{0x9de0, 0xc567},
	{0x9de1, 0xc569},
	{0x9de2, 0xc56a},
	{0x9de3, 0xc56b},
	{0x9de4, 0xc56c},
	{0x9de5, 0xc56d},
	{0x9de6, 0xc56e},
	{0x9de7, 0xc56f},
	{0x9de8, 0xc572},
	{0x9de9, 0xc576},
	{0x9dea, 0xc577},
	{0x9deb, 0xc578},
	{0x9dec, 0xc579},
	{0x9ded, 0xc57a},
	{0x9dee, 0xc57b},
	{0x9def, 0xc57e},
	{0x9df0, 0xc57f},
	{0x9df1, 0xc581},
	{0x9df2, 0xc582},
	{0x9df3, 0xc583},
	{0x9df4, 0xc585},
	{0x9df5, 0xc586},
	{0x9df6, 0xc588},
	{0x9df7, 0xc589},
	{0x9df8, 0xc58a},
	{0x9df9, 0xc58b},
	{0x9dfa, 0xc58e},
	{0x9dfb, 0xc590},
	{0x9dfc, 0xc592},
	{0x9dfd, 0xc593},
	{0x9dfe, 0xc594},
	{0x9e41, 0xc596},
	{0x9e42, 0xc599},
	{0x9e43, 0xc59a},
	{0x9e44, 0xc59b},
	{0x9e45, 0xc59d},
	{0x9e46, 0xc59e},
	{0x9e47, 0xc59f},
	{0x9e48, 0xc5a1},
	{0x9e49, 0xc5a2},
	{0x9e4a, 0xc5a3},
	{0x9e4b, 0xc5a4},
	{0x9e4c, 0xc5a5},
	{0x9e4d, 0xc5a6},
	{0x9e4e, 0xc5a7},
	{0x9e4f, 0xc5a8},
	{0x9e50, 0xc5aa},
	{0x9e51, 0xc5ab},
	{0x9e52, 0xc5ac},
	{0x9e53, 0xc5ad},
	{0x9e54, 0xc5ae},
	{0x9e55, 0xc5af},
	{0x9e56, 0xc5b0},
	{0x9e57, 0xc5b1},
	{0x9e58, 0xc5b2},
	{0x9e59, 0xc5b3},
	{0x9e5a, 0xc5b6},
	{0x9e61, 0xc5b7},
	{0x9e62, 0xc5ba},
	{0x9e63, 0xc5bf},
	{0x9e64, 0xc5c0},
	{0x9e65, 0xc5c1},
	{0x9e66, 0xc5c2},
	{0x9e67, 0xc5c3},
	{0x9e68, 0xc5cb},
	{0x9e69, 0xc5cd},
	{0x9e6a, 0xc5cf},
	{0x9e6b, 0xc5d2},
	{0x9e6c, 0xc5d3},
	{0x9e6d, 0xc5d5},
	{0x9e6e, 0xc5d6},
	{0x9e6f, 0xc5d7},
	{0x9e70, 0xc5d9},
	{0x9e71, 0xc5da},
	{0x9e72, 0xc5db},
	{0x9e73, 0xc5dc},
	{0x9e74, 0xc5dd},
	{0x9e75, 0xc5de},
	{0x9e76, 0xc5df},
	{0x9e77, 0xc5e2},
	{0x9e78, 0xc5e4},
	{0x9e79, 0xc5e6},
	{0x9e7a, 0xc5e7},
	{0x9e81, 0xc5e8},
	{0x9e82, 0xc5e9},
	{0x9e83, 0xc5ea},
	{0x9e84, 0xc5eb},
	{0x9e85, 0xc5ef},
	{0x9e86, 0xc5f1},
	{0x9e87, 0xc5f2},
	{0x9e88, 0xc5f3},
	{0x9e89, 0xc5f5},
	{0x9e8a, 0xc5f8},
	{0x9e8b, 0xc5f9},
	{0x9e8c, 0xc5fa},
	{0x9e8d, 0xc5fb},
	{0x9e8e, 0xc602},
	{0x9e8f, 0xc603},
	{0x9e90, 0xc604},
	{0x9e91, 0xc609},
	{0x9e92, 0xc60a},
	{0x9e93, 0xc60b},
	{0x9e94, 0xc60d},
	{0x9e95, 0xc60e},
	{0x9e96, 0xc60f},
	{0x9e97, 0xc611},
	{0x9e98, 0xc612},
	{0x9e99, 0xc613},
	{0x9e9a, 0xc614},
	{0x9e9b, 0xc615},
	{0x9e9c, 0xc616},
	{0x9e9d, 0xc617},
	{0x9e9e, 0xc61a},
	{0x9e9f, 0xc61d},
	{0x9ea0, 0xc61e},
	{0x9ea1, 0xc61f},
	{0x9ea2, 0xc620},
	{0x9ea3, 0xc621},
	{0x9ea4, 0xc622},
	{0x9ea5, 0xc623},
	{0x9ea6, 0xc626},
	{0x9ea7, 0xc627},
	{0x9ea8, 0xc629},
	{0x9ea9, 0xc62a},
	{0x9eaa, 0xc62b},
	{0x9eab, 0xc62f},
	{0x9eac, 0xc631},
	{0x9ead, 0xc632},
	{0x9eae, 0xc636},
	{0x9eaf, 0xc638},
	{0x9eb0, 0xc63a},
	{0x9eb1, 0xc63c},
	{0x9eb2, 0xc63d},
	{0x9eb3, 0xc63e},
	{0x9eb4, 0xc63f},
	{0x9eb5, 0xc642},
	{0x9eb6, 0xc643},
	{0x9eb7, 0xc645},
	{0x9eb8, 0xc646},
	{0x9eb9, 0xc647},
	{0x9eba, 0xc649},
	{0x9ebb, 0xc64a},
	{0x9ebc, 0xc64b},
	{0x9ebd, 0xc64c},
	{0x9ebe, 0xc64d},
	{0x9ebf, 0xc64e},
	{0x9ec0, 0xc64f},
	{0x9ec1, 0xc652},
	{0x9ec2, 0xc656},
	{0x9ec3, 0xc657},
	{0x9ec4, 0xc658},
	{0x9ec5, 0xc659},
	{0x9ec6, 0xc65a},
	{0x9ec7, 0xc65b},
	{0x9ec8, 0xc65e},
	{0x9ec9, 0xc65f},
	{0x9eca, 0xc661},
	{0x9ecb, 0xc662},
	{0x9ecc, 0xc663},
	{0x9ecd, 0xc664},
	{0x9ece, 0xc665},
	{0x9ecf, 0xc666},
	{0x9ed0, 0xc667},
	{0x9ed1, 0xc668},
	{0x9ed2, 0xc669},
	{0x9ed3, 0xc66a},
	{0x9ed4, 0xc66b},
	{0x9ed5, 0xc66d},
	{0x9ed6, 0xc66e},
	{0x9ed7, 0xc670},
	{0x9ed8, 0xc672},
	{0x9ed9, 0xc673},
	{0x9eda, 0xc674},
	{0x9edb, 0xc675},
	{0x9edc, 0xc676},
	{0x9edd, 0xc677},
	{0x9ede, 0xc67a},
	{0x9edf, 0xc67b},
	{0x9ee0, 0xc67d},
	{0x9ee1, 0xc67e},
	{0x9ee2, 0xc67f},
	{0x9ee3, 0xc681},
	{0x9ee4, 0xc682},
	{0x9ee5, 0xc683},
	{0x9ee6, 0xc684},
	{0x9ee7, 0xc685},
	{0x9ee8, 0xc686},
	{0x9ee9, 0xc687},
	{0x9eea, 0xc68a},
	{0x9eeb, 0xc68c},
	{0x9eec, 0xc68e},
	{0x9eed, 0xc68f},
	{0x9eee, 0xc690},
	{0x9eef, 0xc691},
	{0x9ef0, 0xc692},
	{0x9ef1, 0xc693},
	{0x9ef2, 0xc696},
	{0x9ef3, 0xc697},
	{0x9ef4, 0xc699},
	{0x9ef5, 0xc69a},
	{0x9ef6, 0xc69b},
	{0x9ef7, 0xc69d},
	{0x9ef8, 0xc69e},
	{0x9ef9, 0xc69f},
	{0x9efa, 0xc6a0},
	{0x9efb, 0xc6a1},
	{0x9efc, 0xc6a2},
	{0x9efd, 0xc6a3},
	{0x9efe, 0xc6a6},
	{0x9f41, 0xc6a8},
	{0x9f42, 0xc6aa},
	{0x9f43, 0xc6ab},
	{0x9f44, 0xc6ac},
	{0x9f45, 0xc6ad},
	{0x9f46, 0xc6ae},
	{0x9f47, 0xc6af},
	{0x9f48, 0xc6b2},
	{0x9f49, 0xc6b3},
	{0x9f4a, 0xc6b5},
	{0x9f4b, 0xc6b6},
	{0x9f4c, 0xc6b7},
	{0x9f4d, 0xc6bb},
	{0x9f4e, 0xc6bc},
	{0x9f4f, 0xc6bd},
	{0x9f50, 0xc6be},
	{0x9f51, 0xc6bf},
	{0x9f52, 0xc6c2},
	{0x9f53, 0xc6c4},
	{0x9f54, 0xc6c6},
	{0x9f55, 0xc6c7},
	{0x9f56, 0xc6c8},
	{0x9f57, 0xc6c9},
	{0x9f58, 0xc6ca},
	{0x9f59, 0xc6cb},
	{0x9f5a, 0xc6ce},
	{0x9f61, 0xc6cf},
	{0x9f62, 0xc6d1},
	{0x9f63, 0xc6d2},
	{0x9f64, 0xc6d3},
	{0x9f65, 0xc6d5},
	{0x9f66, 0xc6d6},
	{0x9f67, 0xc6d7},
	{0x9f68, 0xc6d8},
	{0x9f69, 0xc6d9},
	{0x9f6a, 0xc6da},
	{0x9f6b, 0xc6db},
	{0x9f6c, 0xc6de},
	{0x9f6d, 0xc6df},
	{0x9f6e, 0xc6e2},
	{0x9f6f, 0xc6e3},
	{0x9f70, 0xc6e4},
	{0x9f71, 0xc6e5},
	{0x9f72, 0xc6e6},
	{0x9f73, 0xc6e7},
	{0x9f74, 0xc6ea},
	{0x9f75, 0xc6eb},
	{0x9f76, 0xc6ed},
	{0x9f77, 0xc6ee},
	{0x9f78, 0xc6ef},
	{0x9f79, 0xc6f1},
	{0x9f7a, 0xc6f2},
	{0x9f81, 0xc6f3},
	{0x9f82, 0xc6f4},
	{0x9f83, 0xc6f5},
	{0x9f84, 0xc6f6},
	{0x9f85, 0xc6f7},
	{0x9f86, 0xc6fa},
	{0x9f87, 0xc6fb},
	{0x9f88, 0xc6fc},
	{0x9f89, 0xc6fe},
	{0x9f8a, 0xc6ff},
	{0x9f8b, 0xc700},
	{0x9f8c, 0xc701},
	{0x9f8d, 0xc702},
	{0x9f8e, 0xc703},
	{0x9f8f, 0xc706},
	{0x9f90, 0xc707},
	{0x9f91, 0xc709},
	{0x9f92, 0xc70a},
	{0x9f93, 0xc70b},
	{0x9f94, 0xc70d},
	{0x9f95, 0xc70e},
	{0x9f96, 0xc70f},
	{0x9f97, 0xc710},
	{0x9f98, 0xc711},
	{0x9f99, 0xc712},
	{0x9f9a, 0xc713},
	{0x9f9b, 0xc716},
	{0x9f9c, 0xc718},
	{0x9f9d, 0xc71a},
	{0x9f9e, 0xc71b},
	{0x9f9f, 0xc71c},
	{0x9fa0, 0xc71d},
	{0x9fa1, 0xc71e},
	{0x9fa2, 0xc71f},
	{0x9fa3, 0xc722},
	{0x9fa4, 0xc723},
	{0x9fa5, 0xc725},
	{0x9fa6, 0xc726},
	{0x9fa7, 0xc727},
	{0x9fa8, 0xc729},
	{0x9fa9, 0xc72a},
	{0x9faa, 0xc72b},
	{0x9fab, 0xc72c},
	{0x9fac, 0xc72d},
	{0x9fad, 0xc72e},
	{0x9fae, 0xc72f},
	{0x9faf, 0xc732},
	{0x9fb0, 0xc734},
	{0x9fb1, 0xc736},
	{0x9fb2, 0xc738},
	{0x9fb3, 0xc739},
	{0x9fb4, 0xc73a},
	{0x9fb5, 0xc73b},
	{0x9fb6, 0xc73e},
	{0x9fb7, 0xc73f},
	{0x9fb8, 0xc741},
	{0x9fb9, 0xc742},
	{0x9fba, 0xc743},
	{0x9fbb, 0xc745},
	{0x9fbc, 0xc746},
	{0x9fbd, 0xc747},
	{0x9fbe, 0xc748},
	{0x9fbf, 0xc749},
	{0x9fc0, 0xc74b},
	{0x9fc1, 0xc74e},
	{0x9fc2, 0xc750},
	{0x9fc3, 0xc759},
	{0x9fc4, 0xc75a},
	{0x9fc5, 0xc75b},
	{0x9fc6, 0xc75d},
	{0x9fc7, 0xc75e},
	{0x9fc8, 0xc75f},
	{0x9fc9, 0xc761},
	{0x9fca, 0xc762},
	{0x9fcb, 0xc763},
	{0x9fcc, 0xc764},
	{0x9fcd, 0xc765},
	{0x9fce, 0xc766},
	{0x9fcf, 0xc767},
	{0x9fd0, 0xc769},
	{0x9fd1, 0xc76a},
	{0x9fd2, 0xc76c},
	{0x9fd3, 0xc76d},
	{0x9fd4, 0xc76e},
	{0x9fd5, 0xc76f},
	{0x9fd6, 0xc770},
	{0x9fd7, 0xc771},
	{0x9fd8, 0xc772},
	{0x9fd9, 0xc773},
	{0x9fda, 0xc776},
	{0x9fdb, 0xc777},
	{0x9fdc, 0xc779},
	{0x9fdd, 0xc77a},
	{0x9fde, 0xc77b},
	{0x9fdf, 0xc77f},
	{0x9fe0, 0xc780},
	{0x9fe1, 0xc781},
	{0x9fe2, 0xc782},
	{0x9fe3, 0xc786},
	{0x9fe4, 0xc78b},
	{0x9fe5, 0xc78c},
	{0x9fe6, 0xc78d},
	{0x9fe7, 0xc78f},
	{0x9fe8, 0xc792},
	{0x9fe9, 0xc793},
	{0x9fea, 0xc795},
	{0x9feb, 0xc799},
	{0x9fec, 0xc79b},
	{0x9fed, 0xc79c},
	{0x9fee, 0xc79d},
	{0x9fef, 0xc79e},
	{0x9ff0, 0xc79f},
	{0x9ff1, 0xc7a2},
	{0x9ff2, 0xc7a7},
	{0x9ff3, 0xc7a8},
	{0x9ff4, 0xc7a9},
	{0x9ff5, 0xc7aa},
	{0x9ff6, 0xc7ab},
	{0x9ff7, 0xc7ae},
	{0x9ff8, 0xc7af},
	{0x9ff9, 0xc7b1},
	{0x9ffa, 0xc7b2},
	{0x9ffb, 0xc7b3},
	{0x9ffc, 0xc7b5},
	{0x9ffd, 0xc7b6},
	{0x9ffe, 0xc7b7},
	{0xa041, 0xc7b8},
	{0xa042, 0xc7b9},
	{0xa043, 0xc7ba},
	{0xa044, 0xc7bb},
	{0xa045, 0xc7be},
	{0xa046, 0xc7c2},
	{0xa047, 0xc7c3},
	{0xa048, 0xc7c4},
	{0xa049, 0xc7c5},
	{0xa04a, 0xc7c6},
	{0xa04b, 0xc7c7},
	{0xa04c, 0xc7ca},
	{0xa04d, 0xc7cb},
	{0xa04e, 0xc7cd},
	{0xa04f, 0xc7cf},
	{0xa050, 0xc7d1},
	{0xa051, 0xc7d2},
	{0xa052, 0xc7d3},
	{0xa053, 0xc7d4},
	{0xa054, 0xc7d5},
	{0xa055, 0xc7d6},
	{0xa056, 0xc7d7},
	{0xa057, 0xc7d9},
	{0xa058, 0xc7da},
	{0xa059, 0xc7db},
	{0xa05a, 0xc7dc},
	{0xa061, 0xc7de},
	{0xa062, 0xc7df},
	{0xa063, 0xc7e0},
	{0xa064, 0xc7e1},
	{0xa065, 0xc7e2},
	{0xa066, 0xc7e3},
	{0xa067, 0xc7e5},
	{0xa068, 0xc7e6},
	{0xa069, 0xc7e7},
	{0xa06a, 0xc7e9},
	{0xa06b, 0xc7ea},
	{0xa06c, 0xc7eb},
	{0xa06d, 0xc7ed},
	{0xa06e, 0xc7ee},
	{0xa06f, 0xc7ef},
	{0xa070, 0xc7f0},
	{0xa071, 0xc7f1},
	{0xa072, 0xc7f2},
	{0xa073, 0xc7f3},
	{0xa074, 0xc7f4},
	{0xa075, 0xc7f5},
	{0xa076, 0xc7f6},
	{0xa077, 0xc7f7},
	{0xa078, 0xc7f8},
	{0xa079, 0xc7f9},
	{0xa07a, 0xc7fa},
	{0xa081, 0xc7fb},
	{0xa082, 0xc7fc},
	{0xa083, 0xc7fd},
	{0xa084, 0xc7fe},
	{0xa085, 0xc7ff},
	{0xa086, 0xc802},
	{0xa087, 0xc803},
	{0xa088, 0xc805},
	{0xa089, 0xc806},
	{0xa08a, 0xc807},
	{0xa08b, 0xc809},
	{0xa08c, 0xc80b},
	{0xa08d, 0xc80c},
	{0xa08e, 0xc80d},
	{0xa08f, 0xc80e},
	{0xa090, 0xc80f},
	{0xa091, 0xc812},
	{0xa092, 0xc814},
	{0xa093, 0xc817},
	{0xa094, 0xc818},
	{0xa095, 0xc819},
	{0xa096, 0xc81a},
	{0xa097, 0xc81b},
	{0xa098, 0xc81e},
	{0xa099, 0xc81f},
	{0xa09a, 0xc821},
	{0xa09b, 0xc822},
	{0xa09c, 0xc823},
	{0xa09d, 0xc825},
	{0xa09e, 0xc826},
	{0xa09f, 0xc827},
	{0xa0a0, 0xc828},
	{0xa0a1, 0xc829},
	{0xa0a2, 0xc82a},
	{0xa0a3, 0xc82b},
	{0xa0a4, 0xc82e},
	{0xa0a5, 0xc830},
	{0xa0a6, 0xc832},
	{0xa0a7, 0xc833},
	{0xa0a8, 0xc834},
	{0xa0a9, 0xc835},
	{0xa0aa, 0xc836},
	{0xa0ab, 0xc837},
	{0xa0ac, 0xc839},
	{0xa0ad, 0xc83a},
	{0xa0ae, 0xc83b},
	{0xa0af, 0xc83d},
	{0xa0b0, 0xc83e},
	{0xa0b1, 0xc83f},
	{0xa0b2, 0xc841},
	{0xa0b3, 0xc842},
	{0xa0b4, 0xc843},
	{0xa0b5, 0xc844},
	{0xa0b6, 0xc845},
	{0xa0b7, 0xc846},
	{0xa0b8, 0xc847},
	{0xa0b9, 0xc84a},
	{0xa0ba, 0xc84b},
	{0xa0bb, 0xc84e},
	{0xa0bc, 0xc84f},
	{0xa0bd, 0xc850},
	{0xa0be, 0xc851},
	{0xa0bf, 0xc852},
	{0xa0c0, 0xc853},
	{0xa0c1, 0xc855},
	{0xa0c2, 0xc856},
	{0xa0c3, 0xc857},
	{0xa0c4, 0xc858},
	{0xa0c5, 0xc859},
	{0xa0c6, 0xc85a},
	{0xa0c7, 0xc85b},
	{0xa0c8, 0xc85c},
	{0xa0c9, 0xc85d},
	{0xa0ca, 0xc85e},
	{0xa0cb, 0xc85f},
	{0xa0cc, 0xc860},
	{0xa0cd, 0xc861},
	{0xa0ce, 0xc862},
	{0xa0cf, 0xc863},
	{0xa0d0, 0xc864},
	{0xa0d1, 0xc865},
	{0xa0d2, 0xc866},
	{0xa0d3, 0xc867},
	{0xa0d4, 0xc868},
	{0xa0d5, 0xc869},
	{0xa0d6, 0xc86a},
	{0xa0d7, 0xc86b},
	{0xa0d8, 0xc86c},
	{0xa0d9, 0xc86d},
	{0xa0da, 0xc86e},
	{0xa0db, 0xc86f},
	{0xa0dc, 0xc872},
	{0xa0dd, 0xc873},
	{0xa0de, 0xc875},
	{0xa0df, 0xc876},
	{0xa0e0, 0xc877},
	{0xa0e1, 0xc879},
	{0xa0e2, 0xc87b},
	{0xa0e3, 0xc87c},
	{0xa0e4, 0xc87d},
	{0xa0e5, 0xc87e},
	{0xa0e6, 0xc87f},
	{0xa0e7, 0xc882},
	{0xa0e8, 0xc884},
	{0xa0e9, 0xc888},
	{0xa0ea, 0xc889},
	{0xa0eb, 0xc88a},
	{0xa0ec, 0xc88e},
	{0xa0ed, 0xc88f},
	{0xa0ee, 0xc890},
	{0xa0ef, 0xc891},
	{0xa0f0, 0xc892},
	{0xa0f1, 0xc893},
	{0xa0f2, 0xc895},
	{0xa0f3, 0xc896},
	{0xa0f4, 0xc897},
	{0xa0f5, 0xc898},
	{0xa0f6, 0xc899},
	{0xa0f7, 0xc89a},
	{0xa0f8, 0xc89b},
	{0xa0f9, 0xc89c},
	{0xa0fa, 0xc89e},
	{0xa0fb, 0xc8a0},
	{0xa0fc, 0xc8a2},
	{0xa0fd, 0xc8a3},
	{0xa0fe, 0xc8a4},
	{0xa141, 0xc8a5},
	{0xa142, 0xc8a6},
	{0xa143, 0xc8a7},
	{0xa144, 0xc8a9},
	{0xa145, 0xc8aa},
	{0xa146, 0xc8ab},
	{0xa147, 0xc8ac},
	{0xa148, 0xc8ad},
	{0xa149, 0xc8ae},
	{0xa14a, 0xc8af},
	{0xa14b, 0xc8b0},
	{0xa14c, 0xc8b1},
	{0xa14d, 0xc8b2},
	{0xa14e, 0xc8b3},
	{0xa14f, 0xc8b4},
	{0xa150, 0xc8b5},
	{0xa151, 0xc8b6},
	{0xa152, 0xc8b7},
	{0xa153, 0xc8b8},
	{0xa154, 0xc8b9},
	{0xa155, 0xc8ba},
	{0xa156, 0xc8bb},
	{0xa157, 0xc8be},
	{0xa158, 0xc8bf},
	{0xa159, 0xc8c0},
	{0xa15a, 0xc8c1},
	{0xa161, 0xc8c2},
	{0xa162, 0xc8c3},
	{0xa163, 0xc8c5},
	{0xa164, 0xc8c6},
	{0xa165, 0xc8c7},
	{0xa166, 0xc8c9},
	{0xa167, 0xc8ca},
	{0xa168, 0xc8cb},
	{0xa169, 0xc8cd},
	{0xa16a, 0xc8ce},
	{0xa16b, 0xc8cf},
	{0xa16c, 0xc8d0},
	{0xa16d, 0xc8d1},
	{0xa16e, 0xc8d2},
	{0xa16f, 0xc8d3},
	{0xa170, 0xc8d6},
	{0xa171, 0xc8d8},
	{0xa172, 0xc8da},
	{0xa173, 0xc8db},
	{0xa174, 0xc8dc},
	{0xa175, 0xc8dd},
	{0xa176, 0xc8de},
	{0xa177, 0xc8df},
	{0xa178, 0xc8e2},
	{0xa179, 0xc8e3},
	{0xa17a, 0xc8e5},
	{0xa181, 0xc8e6},
	{0xa182, 0xc8e7},
	{0xa183, 0xc8e8},
	{0xa184, 0xc8e9},
	{0xa185, 0xc8ea},
	{0xa186, 0xc8eb},
	{0xa187, 0xc8ec},
	{0xa188, 0xc8ed},
	{0xa189, 0xc8ee},
	{0xa18a, 0xc8ef},
	{0xa18b, 0xc8f0},
	{0xa18c, 0xc8f1},
	{0xa18d, 0xc8f2},
	{0xa18e, 0xc8f3},
	{0xa18f, 0xc8f4},
	{0xa190, 0xc8f6},
	{0xa191, 0xc8f7},
	{0xa192, 0xc8f8},
	{0xa193, 0xc8f9},
	{0xa194, 0xc8fa},
	{0xa195, 0xc8fb},
	{0xa196, 0xc8fe},
	{0xa197, 0xc8ff},
	{0xa198, 0xc901},
	{0xa199, 0xc902},
	{0xa19a, 0xc903},
	{0xa19b, 0xc907},
	{0xa19c, 0xc908},
	{0xa19d, 0xc909},
	{0xa19e, 0xc90a},
	{0xa19f, 0xc90b},
	{0xa1a0, 0xc90e},
	{0xa1a1, 0x3000},
	{0xa1a2, 0x3001},
	{0xa1a3, 0x3002},
	{0xa1a4, 0x00b7},
	{0xa1a5, 0x2025},
	{0xa1a6, 0x2026},
	{0xa1a7, 0x00a8},
	{0xa1a8, 0x3003},
	{0xa1a9, 0x00ad},
	{0xa1aa, 0x2015},
	{0xa1ab, 0x2225},
	{0xa1ac, 0xff3c},
	{0xa1ad, 0x223c},
	{0xa1ae, 0x2018},
	{0xa1af, 0x2019},
	{0xa1b0, 0x201c},
	{0xa1b1, 0x201d},
	{0xa1b2, 0x3014},
	{0xa1b3, 0x3015},
	{0xa1b4, 0x3008},
	{0xa1b5, 0x3009},
	{0xa1b6, 0x300a},
	{0xa1b7, 0x300b},
	{0xa1b8, 0x300c},
	{0xa1b9, 0x300d},
	{0xa1ba, 0x300e},
	{0xa1bb, 0x300f},
	{0xa1bc, 0x3010},
	{0xa1bd, 0x3011},
	{0xa1be, 0x00b1},
	{0xa1bf, 0x00d7},
	{0xa1c0, 0x00f7},
	{0xa1c1, 0x2260},
	{0xa1c2, 0x2264},
	{0xa1c3, 0x2265},
	{0xa1c4, 0x221e},
	{0xa1c5, 0x2234},
	{0xa1c6, 0x00b0},
	{0xa1c7, 0x2032},
	{0xa1c8, 0x2033},
	{0xa1c9, 0x2103},
	{0xa1ca, 0x212b},
	{0xa1cb, 0xffe0},
	{0xa1cc, 0xffe1},
	{0xa1cd, 0xffe5},
	{0xa1ce, 0x2642},
	{0xa1cf, 0x2640},
	{0xa1d0, 0x2220},
	{0xa1d1, 0x22a5},
	{0xa1d2, 0x2312},
	{0xa1d3, 0x2202},
	{0xa1d4, 0x2207},
	{0xa1d5, 0x2261},
	{0xa1d6, 0x2252},
	{0xa1d7, 0x00a7},
	{0xa1d8, 0x203b},
	{0xa1d9, 0x2606},
	{0xa1da, 0x2605},
	{0xa1db, 0x25cb},
	{0xa1dc, 0x25cf},
	{0xa1dd, 0x25ce},
	{0xa1de, 0x25c7},
	{0xa1df, 0x25c6},
	{0xa1e0, 0x25a1},
	{0xa1e1, 0x25a0},
	{0xa1e2, 0x25b3},
	{0xa1e3, 0x25b2},
	{0xa1e4, 0x25bd},
	{0xa1e5, 0x25bc},
	{0xa1e6, 0x2192},
	{0xa1e7, 0x2190},
	{0xa1e8, 0x2191},
	{0xa1e9, 0x2193},
	{0xa1ea, 0x2194},
	{0xa1eb, 0x3013},
	{0xa1ec, 0x226a},
	{0xa1ed, 0x226b},
	{0xa1ee, 0x221a},
	{0xa1ef, 0x223d},
	{0xa1f0, 0x221d},
	{0xa1f1, 0x2235},
	{0xa1f2, 0x222b},
	{0xa1f3, 0x222c},
	{0xa1f4, 0x2208},
	{0xa1f5, 0x220b},
	{0xa1f6, 0x2286},
	{0xa1f7, 0x2287},
	{0xa1f8, 0x2282},
	{0xa1f9, 0x2283},
	{0xa1fa, 0x222a},
	{0xa1fb, 0x2229},
	{0xa1fc, 0x2227},
	{0xa1fd, 0x2228},
	{0xa1fe, 0xffe2},
	{0xa241, 0xc910},
	{0xa242, 0xc912},
	{0xa243, 0xc913},
	{0xa244, 0xc914},
	{0xa245, 0xc915},
	{0xa246, 0xc916},
	{0xa247, 0xc917},
	{0xa248, 0xc919},
	{0xa249, 0xc91a},
	{0xa24a, 0xc91b},
	{0xa24b, 0xc91c},
	{0xa24c, 0xc91d},
	{0xa24d, 0xc91e},
	{0xa24e, 0xc91f},
	{0xa24f, 0xc920},
	{0xa250, 0xc921},
	{0xa251, 0xc922},
	{0xa252, 0xc923},
	{0xa253, 0xc924},
	{0xa254, 0xc925},
	{0xa255, 0xc926},
	{0xa256, 0xc927},
	{0xa257, 0xc928},
	{0xa258, 0xc929},
	{0xa259, 0xc92a},
	{0xa25a, 0xc92b},
	{0xa261, 0xc92d},
	{0xa262, 0xc92e},
	{0xa263, 0xc92f},
	{0xa264, 0xc930},
	{0xa265, 0xc931},
	{0xa266, 0xc932},
	{0xa267, 0xc933},
	{0xa268, 0xc935},
	{0xa269, 0xc936},
	{0xa26a, 0xc937},
	{0xa26b, 0xc938},
	{0xa26c, 0xc939},
	{0xa26d, 0xc93a},
	{0xa26e, 0xc93b},
	{0xa26f, 0xc93c},
	{0xa270, 0xc93d},
	{0xa271, 0xc93e},
	{0xa272, 0xc93f},
	{0xa273, 0xc940},
	{0xa274, 0xc941},
	{0xa275, 0xc942},
	{0xa276, 0xc943},
	{0xa277, 0xc944},
	{0xa278, 0xc945},
	{0xa279, 0xc946},
	{0xa27a, 0xc947},
	{0xa281, 0xc948},
	{0xa282, 0xc949},
	{0xa283, 0xc94a},
	{0xa284, 0xc94b},
	{0xa285, 0xc94c},
	{0xa286, 0xc94d},
	{0xa287, 0xc94e},
	{0xa288, 0xc94f},
	{0xa289, 0xc952},
	{0xa28a, 0xc953},
	{0xa28b, 0xc955},
	{0xa28c, 0xc956},
	{0xa28d, 0xc957},
	{0xa28e, 0xc959},
	{0xa28f, 0xc95a},
	{0xa290, 0xc95b},
	{0xa291, 0xc95c},
	{0xa292, 0xc95d},
	{0xa293, 0xc95e},
	{0xa294, 0xc95f},
	{0xa295, 0xc962},
	{0xa296, 0xc964},
	{0xa297, 0xc965},
	{0xa298, 0xc966},
	{0xa299, 0xc967},
	{0xa29a, 0xc968},
	{0xa29b, 0xc969},
	{0xa29c, 0xc96a},
	{0xa29d, 0xc96b},
	{0xa29e, 0xc96d},
	{0xa29f, 0xc96e},
	{0xa2a0, 0xc96f},
	{0xa2a1, 0x21d2},
	{0xa2a2, 0x21d4},
	{0xa2a3, 0x2200},
	{0xa2a4, 0x2203},
	{0xa2a5, 0x00b4},
	{0xa2a6, 0xff5e},
	{0xa2a7, 0x02c7},
	{0xa2a8, 0x02d8},
	{0xa2a9, 0x02dd},
	{0xa2aa, 0x02da},
	{0xa2ab, 0x02d9},
	{0xa2ac, 0x00b8},
	{0xa2ad, 0x02db},
	{0xa2ae, 0x00a1},
	{0xa2af, 0x00bf},
	{0xa2b0, 0x02d0},
	{0xa2b1, 0x222e},
	{0xa2b2, 0x2211},
	{0xa2b3, 0x220f},
	{0xa2b4, 0x00a4},
	{0xa2b5, 0x2109},
	{0xa2b6, 0x2030},
	{0xa2b7, 0x25c1},
	{0xa2b8, 0x25c0},
	{0xa2b9, 0x25b7},
	{0xa2ba, 0x25b6},
	{0xa2bb, 0x2664},
	{0xa2bc, 0x2660},
	{0xa2bd, 0x2661},
	{0xa2be, 0x2665},
	{0xa2bf, 0x2667},
	{0xa2c0, 0x2663},
	{0xa2c1, 0x2299},
	{0xa2c2, 0x25c8},
	{0xa2c3, 0x25a3},
	{0xa2c4, 0x25d0},
	{0xa2c5, 0x25d1},
	{0xa2c6, 0x2592},
	{0xa2c7, 0x25a4},
	{0xa2c8, 0x25a5},
	{0xa2c9, 0x25a8},
	{0xa2ca, 0x25a7},
	{0xa2cb, 0x25a6},
	{0xa2cc, 0x25a9},
	{0xa2cd, 0x2668},
	{0xa2ce, 0x260f},
	{0xa2cf, 0x260e},
	{0xa2d0, 0x261c},
	{0xa2d1, 0x261e},
	{0xa2d2, 0x00b6},
	{0xa2d3, 0x2020},
	{0xa2d4, 0x2021},
	{0xa2d5, 0x2195},
	{0xa2d6, 0x2197},
	{0xa2d7, 0x2199},
	{0xa2d8, 0x2196},
	{0xa2d9, 0x2198},
	{0xa2da, 0x266d},
	{0xa2db, 0x2669},
	{0xa2dc, 0x266a},
	{0xa2dd, 0x266c},
	{0xa2de, 0x327f},
	{0xa2df, 0x321c},
	{0xa2e0, 0x2116},
	{0xa2e1, 0x33c7},
	{0xa2e2, 0x2122},
	{0xa2e3, 0x33c2},
	{0xa2e4, 0x33d8},
	{0xa2e5, 0x2121},
	{0xa2e6, 0x20ac},
	{0xa2e7, 0x00ae},
	{0xa341, 0xc971},
	{0xa342, 0xc972},
	{0xa343, 0xc973},
	{0xa344, 0xc975},
	{0xa345, 0xc976},
	{0xa346, 0xc977},
	{0xa347, 0xc978},
	{0xa348, 0xc979},
	{0xa349, 0xc97a},
	{0xa34a, 0xc97b},
	{0xa34b, 0xc97d},
	{0xa34c, 0xc97e},
	{0xa34d, 0xc97f},
	{0xa34e, 0xc980},
	{0xa34f, 0xc981},
	{0xa350, 0xc982},
	{0xa351, 0xc983},
	{0xa352, 0xc984},
	{0xa353, 0xc985},
	{0xa354, 0xc986},
	{0xa355, 0xc987},
	{0xa356, 0xc98a},
	{0xa357, 0xc98b},
	{0xa358, 0xc98d},
	{0xa359, 0xc98e},
	{0xa35a, 0xc98f},
	{0xa361, 0xc991},
	{0xa362, 0xc992},
	{0xa363, 0xc993},
	{0xa364, 0xc994},
	{0xa365, 0xc995},
	{0xa366, 0xc996},
	{0xa367, 0xc997},
	{0xa368, 0xc99a},
	{0xa369, 0xc99c},
	{0xa36a, 0xc99e},
	{0xa36b, 0xc99f},
	{0xa36c, 0xc9a0},
	{0xa36d, 0xc9a1},
	{0xa36e, 0xc9a2},
	{0xa36f, 0xc9a3},
	{0xa370, 0xc9a4},
	{0xa371, 0xc9a5},
	{0xa372, 0xc9a6},
	{0xa373, 0xc9a7},
	{0xa374, 0xc9a8},
	{0xa375, 0xc9a9},
	{0xa376, 0xc9aa},
	{0xa377, 0xc9ab},
	{0xa378, 0xc9ac},
	{0xa379, 0xc9ad},
	{0xa37a, 0xc9ae},
	{0xa381, 0xc9af},
	{0xa382, 0xc9b0},
	{0xa383, 0xc9b1},
	{0xa384, 0xc9b2},
	{0xa385, 0xc9b3},
	{0xa386, 0xc9b4},
	{0xa387, 0xc9b5},
	{0xa388, 0xc9b6},
	{0xa389, 0xc9b7},
	{0xa38a, 0xc9b8},
	{0xa38b, 0xc9b9},
	{0xa38c, 0xc9ba},
	{0xa38d, 0xc9bb},
	{0xa38e, 0xc9bc},
	{0xa38f, 0xc9bd},
	{0xa390, 0xc9be},
	{0xa391, 0xc9bf},
	{0xa392, 0xc9c2},
	{0xa393, 0xc9c3},
	{0xa394, 0xc9c5},
	{0xa395, 0xc9c6},
	{0xa396, 0xc9c9},
	{0xa397, 0xc9cb},
	{0xa398, 0xc9cc},
	{0xa399, 0xc9cd},
	{0xa39a, 0xc9ce},
	{0xa39b, 0xc9cf},
	{0xa39c, 0xc9d2},
	{0xa39d, 0xc9d4},
	{0xa39e, 0xc9d7},
	{0xa39f, 0xc9d8},
	{0xa3a0, 0xc9db},
	{0xa3a1, 0xff01},
	{0xa3a2, 0xff02},
	{0xa3a3, 0xff03},
	{0xa3a4, 0xff04},
	{0xa3a5, 0xff05},
	{0xa3a6, 0xff06},
	{0xa3a7, 0xff07},
	{0xa3a8, 0xff08},
	{0xa3a9, 0xff09},
	{0xa3aa, 0xff0a},
	{0xa3ab, 0xff0b},
	{0xa3ac, 0xff0c},
	{0xa3ad, 0xff0d},
	{0xa3ae, 0xff0e},
	{0xa3af, 0xff0f},
	{0xa3b0, 0xff10},
	{0xa3b1, 0xff11},
	{0xa3b2, 0xff12},
	{0xa3b3, 0xff13},
	{0xa3b4, 0xff14},
	{0xa3b5, 0xff15},
	{0xa3b6, 0xff16},
	{0xa3b7, 0xff17},
	{0xa3b8, 0xff18},
	{0xa3b9, 0xff19},
	{0xa3ba, 0xff1a},
	{0xa3bb, 0xff1b},
	{0xa3bc, 0xff1c},
	{0xa3bd, 0xff1d},
	{0xa3be, 0xff1e},
	{0xa3bf, 0xff1f},
	{0xa3c0, 0xff20},
	{0xa3c1, 0xff21},
	{0xa3c2, 0xff22},
	{0xa3c3, 0xff23},
	{0xa3c4, 0xff24},
	{0xa3c5, 0xff25},
	{0xa3c6, 0xff26},
	{0xa3c7, 0xff27},
	{0xa3c8, 0xff28},
	{0xa3c9, 0xff29},
	{0xa3ca, 0xff2a},
	{0xa3cb, 0xff2b},
	{0xa3cc, 0xff2c},
	{0xa3cd, 0xff2d},
	{0xa3ce, 0xff2e},
	{0xa3cf, 0xff2f},
	{0xa3d0, 0xff30},
	{0xa3d1, 0xff31},
	{0xa3d2, 0xff32},
	{0xa3d3, 0xff33},
	{0xa3d4, 0xff34},
	{0xa3d5, 0xff35},
	{0xa3d6, 0xff36},
	{0xa3d7, 0xff37},
	{0xa3d8, 0xff38},
	{0xa3d9, 0xff39},
	{0xa3da, 0xff3a},
	{0xa3db, 0xff3b},
	{0xa3dc, 0xffe6},
	{0xa3dd, 0xff3d},
	{0xa3de, 0xff3e},
	{0xa3df, 0xff3f},
	{0xa3e0, 0xff40},
	{0xa3e1, 0xff41},
	{0xa3e2, 0xff42},
	{0xa3e3, 0xff43},
	{0xa3e4, 0xff44},
	{0xa3e5, 0xff45},
	{0xa3e6, 0xff46},
	{0xa3e7, 0xff47},
	{0xa3e8, 0xff48},
	{0xa3e9, 0xff49},
	{0xa3ea, 0xff4a},
	{0xa3eb, 0xff4b},
	{0xa3ec, 0xff4c},
	{0xa3ed, 0xff4d},
	{0xa3ee, 0xff4e},
	{0xa3ef, 0xff4f},
	{0xa3f0, 0xff50},
	{0xa3f1, 0xff51},
	{0xa3f2, 0xff52},
	{0xa3f3, 0xff53},
	{0xa3f4, 0xff54},
	{0xa3f5, 0xff55},
	{0xa3f6, 0xff56},
	{0xa3f7, 0xff57},
	{0xa3f8, 0xff58},
	{0xa3f9, 0xff59},
	{0xa3fa, 0xff5a},
	{0xa3fb, 0xff5b},
	{0xa3fc, 0xff5c},
	{0xa3fd, 0xff5d},
	{0xa3fe, 0xffe3},
	{0xa441, 0xc9de},
	{0xa442, 0xc9df},
	{0xa443, 0xc9e1},
	{0xa444, 0xc9e3},
	{0xa445, 0xc9e5},
	{0xa446, 0xc9e6},
	{0xa447, 0xc9e8},
	{0xa448, 0xc9e9},
	{0xa449, 0xc9ea},
	{0xa44a, 0xc9eb},
	{0xa44b, 0xc9ee},
	{0xa44c, 0xc9f2},
	{0xa44d, 0xc9f3},
	{0xa44e, 0xc9f4},
	{0xa44f, 0xc9f5},
	{0xa450, 0xc9f6},
	{0xa451, 0xc9f7},
	{0xa452, 0xc9fa},
	{0xa453, 0xc9fb},
	{0xa454, 0xc9fd},
	{0xa455, 0xc9fe},
	{0xa456, 0xc9ff},
	{0xa457, 0xca01},
	{0xa458, 0xca02},
	{0xa459, 0xca03},
	{0xa45a, 0xca04},
	{0xa461, 0xca05},
	{0xa462, 0xca06},
	{0xa463, 0xca07},
	{0xa464, 0xca0a},
	{0xa465, 0xca0e},
	{0xa466, 0xca0f},
	{0xa467, 0xca10},
	{0xa468, 0xca11},
	{0xa469, 0xca12},
	{0xa46a, 0xca13},
	{0xa46b, 0xca15},
	{0xa46c, 0xca16},
	{0xa46d, 0xca17},
	{0xa46e, 0xca19},
	{0xa46f, 0xca1a},
	{0xa470, 0xca1b},
	{0xa471, 0xca1c},
	{0xa472, 0xca1d},
	{0xa473, 0xca1e},
	{0xa474, 0xca1f},
	{0xa475, 0xca20},
	{0xa476, 0xca21},
	{0xa477, 0xca22},
	{0xa478, 0xca23},
	{0xa479, 0xca24},
	{0xa47a, 0xca25},
	{0xa481, 0xca26},
	{0xa482, 0xca27},
	{0xa483, 0xca28},
	{0xa484, 0xca2a},
	{0xa485, 0xca2b},
	{0xa486, 0xca2c},
	{0xa487, 0xca2d},
	{0xa488, 0xca2e},
	{0xa489, 0xca2f},
	{0xa48a, 0xca30},
	{0xa48b, 0xca31},
	{0xa48c, 0xca32},
	{0xa48d, 0xca33},
	{0xa48e, 0xca34},
	{0xa48f, 0xca35},
	{0xa490, 0xca36},
	{0xa491, 0xca37},
	{0xa492, 0xca38},
	{0xa493, 0xca39},
	{0xa494, 0xca3a},
	{0xa495, 0xca3b},
	{0xa496, 0xca3c},
	{0xa497, 0xca3d},
	{0xa498, 0xca3e},
	{0xa499, 0xca3f},
	{0xa49a, 0xca40},
	{0xa49b, 0xca41},
	{0xa49c, 0xca42},
	{0xa49d, 0xca43},
	{0xa49e, 0xca44},
	{0xa49f, 0xca45},
	{0xa4a0, 0xca46},
	{0xa4a1, 0x3131},
	{0xa4a2, 0x3132},
	{0xa4a3, 0x3133},
	{0xa4a4, 0x3134},
	{0xa4a5, 0x3135},
	{0xa4a6, 0x3136},
	{0xa4a7, 0x3137},
	{0xa4a8, 0x3138},
	{0xa4a9, 0x3139},
	{0xa4aa, 0x313a},
	{0xa4ab, 0x313b},
	{0xa4ac, 0x313c},
	{0xa4ad, 0x313d},
	{0xa4ae, 0x313e},
	{0xa4af, 0x313f},
	{0xa4b0, 0x3140},
	{0xa4b1, 0x3141},
	{0xa4b2, 0x3142},
	{0xa4b3, 0x3143},
	{0xa4b4, 0x3144},
	{0xa4b5, 0x3145},
	{0xa4b6, 0x3146},
	{0xa4b7, 0x3147},
	{0xa4b8, 0x3148},
	{0xa4b9, 0x3149},
	{0xa4ba, 0x314a},
	{0xa4bb, 0x314b},
	{0xa4bc, 0x314c},
	{0xa4bd, 0x314d},
	{0xa4be, 0x314e},
	{0xa4bf, 0x314f},
	{0xa4c0, 0x3150},
	{0xa4c1, 0x3151},
	{0xa4c2, 0x3152},
	{0xa4c3, 0x3153},
	{0xa4c4, 0x3154},
	{0xa4c5, 0x3155},
	{0xa4c6, 0x3156},
	{0xa4c7, 0x3157},
	{0xa4c8, 0x3158},
	{0xa4c9, 0x3159},
	{0xa4ca, 0x315a},
	{0xa4cb, 0x315b},
	{0xa4cc, 0x315c},
	{0xa4cd, 0x315d},
	{0xa4ce, 0x315e},
	{0xa4cf, 0x315f},
	{0xa4d0, 0x3160},
	{0xa4d1, 0x3161},
	{0xa4d2, 0x3162},
	{0xa4d3, 0x3163},
	{0xa4d4, 0x3164},
	{0xa4d5, 0x3165},
	{0xa4d6, 0x3166},
	{0xa4d7, 0x3167},
	{0xa4d8, 0x3168},
	{0xa4d9, 0x3169},
	{0xa4da, 0x316a},
	{0xa4db, 0x316b},
	{0xa4dc, 0x316c},
	{0xa4dd, 0x316d},
	{0xa4de, 0x316e},
	{0xa4df, 0x316f},
	{0xa4e0, 0x3170},
	{0xa4e1, 0x3171},
	{0xa4e2, 0x3172},
	{0xa4e3, 0x3173},
	{0xa4e4, 0x3174},
	{0xa4e5, 0x3175},
	{0xa4e6, 0x3176},
	{0xa4e7, 0x3177},
	{0xa4e8, 0x3178},
	{0xa4e9, 0x3179},
	{0xa4ea, 0x317a},
	{0xa4eb, 0x317b},
	{0xa4ec, 0x317c},
	{0xa4ed, 0x317d},
	{0xa4ee, 0x317e},
	{0xa4ef, 0x317f},
	{0xa4f0, 0x3180},
	{0xa4f1, 0x3181},
	{0xa4f2, 0x3182},
	{0xa4f3, 0x3183},
	{0xa4f4, 0x3184},
	{0xa4f5, 0x3185},
	{0xa4f6, 0x3186},
	{0xa4f7, 0x3187},
	{0xa4f8, 0x3188},
	{0xa4f9, 0x3189},
	{0xa4fa, 0x318a},
	{0xa4fb, 0x318b},
	{0xa4fc, 0x318c},
	{0xa4fd, 0x318d},
	{0xa4fe, 0x318e},
	{0xa541, 0xca47},
	{0xa542, 0xca48},
	{0xa543, 0xca49},
	{0xa544, 0xca4a},
	{0xa545, 0xca4b},
	{0xa546, 0xca4e},
	{0xa547, 0xca4f},
	{0xa548, 0xca51},
	{0xa549, 0xca52},
	{0xa54a, 0xca53},
	{0xa54b, 0xca55},
	{0xa54c, 0xca56},
	{0xa54d, 0xca57},
	{0xa54e, 0xca58},
	{0xa54f, 0xca59},
	{0xa550, 0xca5a},
	{0xa551, 0xca5b},
	{0xa552, 0xca5e},
	{0xa553, 0xca62},
	{0xa554, 0xca63},
	{0xa555, 0xca64},
	{0xa556, 0xca65},
	{0xa557, 0xca66},
	{0xa558, 0xca67},
	{0xa559, 0xca69},
	{0xa55a, 0xca6a},
	{0xa561, 0xca6b},
	{0xa562, 0xca6c},
	{0xa563, 0xca6d},
	{0xa564, 0xca6e},
	{0xa565, 0xca6f},
	{0xa566, 0xca70},
	{0xa567, 0xca71},
	{0xa568, 0xca72},
	{0xa569, 0xca73},
	{0xa56a, 0xca74},
	{0xa56b, 0xca75},
	{0xa56c, 0xca76},
	{0xa56d, 0xca77},
	{0xa56e, 0xca78},
	{0xa56f, 0xca79},
	{0xa570, 0xca7a},
	{0xa571, 0xca7b},
	{0xa572, 0xca7c},
	{0xa573, 0xca7e},
	{0xa574, 0xca7f},
	{0xa575, 0xca80},
	{0xa576, 0xca81},
	{0xa577, 0xca82},
	{0xa578, 0xca83},
	{0xa579, 0xca85},
	{0xa57a, 0xca86},
	{0xa581, 0xca87},
	{0xa582, 0xca88},
	{0xa583, 0xca89},
	{0xa584, 0xca8a},
	{0xa585, 0xca8b},
	{0xa586, 0xca8c},
	{0xa587, 0xca8d},
	{0xa588, 0xca8e},
	{0xa589, 0xca8f},
	{0xa58a, 0xca90},
	{0xa58b, 0xca91},
	{0xa58c, 0xca92},
	{0xa58d, 0xca93},
	{0xa58e, 0xca94},
	{0xa58f, 0xca95},
	{0xa590, 0xca96},
	{0xa591, 0xca97},
	{0xa592, 0xca99},
	{0xa593, 0xca9a},
	{0xa594, 0xca9b},
	{0xa595, 0xca9c},
	{0xa596, 0xca9d},
	{0xa597, 0xca9e},
	{0xa598, 0xca9f},
	{0xa599, 0xcaa0},
	{0xa59a, 0xcaa1},
	{0xa59b, 0xcaa2},
	{0xa59c, 0xcaa3},
	{0xa59d, 0xcaa4},
	{0xa59e, 0xcaa5},
	{0xa59f, 0xcaa6},
	{0xa5a0, 0xcaa7},
	{0xa5a1, 0x2170},
	{0xa5a2, 0x2171},
	{0xa5a3, 0x2172},
	{0xa5a4, 0x2173},
	{0xa5a5, 0x2174},
	{0xa5a6, 0x2175},
	{0xa5a7, 0x2176},
	{0xa5a8, 0x2177},
	{0xa5a9, 0x2178},
	{0xa5aa, 0x2179},
	{0xa5b0, 0x2160},
	{0xa5b1, 0x2161},
	{0xa5b2, 0x2162},
	{0xa5b3, 0x2163},
	{0xa5b4, 0x2164},
	{0xa5b5, 0x2165},
	{0xa5b6, 0x2166},
	{0xa5b7, 0x2167},
	{0xa5b8, 0x2168},
	{0xa5b9, 0x2169},
	{0xa5c1, 0x0391},
	{0xa5c2, 0x0392},
	{0xa5c3, 0x0393},
	{0xa5c4, 0x0394},
	{0xa5c5, 0x0395},
	{0xa5c6, 0x0396},
	{0xa5c7, 0x0397},
	{0xa5c8, 0x0398},
	{0xa5c9, 0x0399},
	{0xa5ca, 0x039a},
	{0xa5cb, 0x039b},
	{0xa5cc, 0x039c},
	{0xa5cd, 0x039d},
	{0xa5ce, 0x039e},
	{0xa5cf, 0x039f},
	{0xa5d0, 0x03a0},
	{0xa5d1, 0x03a1},
	{0xa5d2, 0x03a3},
	{0xa5d3, 0x03a4},
	{0xa5d4, 0x03a5},
	{0xa5d5, 0x03a6},
	{0xa5d6, 0x03a7},
	{0xa5d7, 0x03a8},
	{0xa5d8, 0x03a9},
	{0xa5e1, 0x03b1},
	{0xa5e2, 0x03b2},
	{0xa5e3, 0x03b3},
	{0xa5e4, 0x03b4},
	{0xa5e5, 0x03b5},
	{0xa5e6, 0x03b6},
	{0xa5e7, 0x03b7},
	{0xa5e8, 0x03b8},
	{0xa5e9, 0x03b9},
	{0xa5ea, 0x03ba},
	{0xa5eb, 0x03bb},
	{0xa5ec, 0x03bc},
	{0xa5ed, 0x03bd},
	{0xa5ee, 0x03be},
	{0xa5ef, 0x03bf},
	{0xa5f0, 0x03c0},
	{0xa5f1, 0x03c1},
	{0xa5f2, 0x03c3},
	{0xa5f3, 0x03c4},
	{0xa5f4, 0x03c5},
	{0xa5f5, 0x03c6},
	{0xa5f6, 0x03c7},
	{0xa5f7, 0x03c8},
	{0xa5f8, 0x03c9},
	{0xa641, 0xcaa8},
	{0xa642, 0xcaa9},
	{0xa643, 0xcaaa},
	{0xa644, 0xcaab},
	{0xa645, 0xcaac},
	{0xa646, 0xcaad},
	{0xa647, 0xcaae},
	{0xa648, 0xcaaf},
	{0xa649, 0xcab0},
	{0xa64a, 0xcab1},
	{0xa64b, 0xcab2},
	{0xa64c, 0xcab3},
	{0xa64d, 0xcab4},
	{0xa64e, 0xcab5},
	{0xa64f, 0xcab6},
	{0xa650, 0xcab7},
	{0xa651, 0xcab8},
	{0xa652, 0xcab9},
	{0xa653, 0xcaba},
	{0xa654, 0xcabb},
	{0xa655, 0xcabe},
	{0xa656, 0xcabf},
	{0xa657, 0xcac1},
	{0xa658, 0xcac2},
	{0xa659, 0xcac3},
	{0xa65a, 0xcac5},
	{0xa661, 0xcac6},
	{0xa662, 0xcac7},
	{0xa663, 0xcac8},
	{0xa664, 0xcac9},
	{0xa665, 0xcaca},
	{0xa666, 0xcacb},
	{0xa667, 0xcace},
	{0xa668, 0xcad0},
	{0xa669, 0xcad2},
	{0xa66a, 0xcad4},
	{0xa66b, 0xcad5},
	{0xa66c, 0xcad6},
	{0xa66d, 0xcad7},
	{0xa66e, 0xcada},
	{0xa66f, 0xcadb},
	{0xa670, 0xcadc},
	{0xa671, 0xcadd},
	{0xa672, 0xcade},
	{0xa673, 0xcadf},
	{0xa674, 0xcae1},
	{0xa675, 0xcae2},
	{0xa676, 0xcae3},
	{0xa677, 0xcae4},
	{0xa678, 0xcae5},
	{0xa679, 0xcae6},
	{0xa67a, 0xcae7},
	{0xa681, 0xcae8},
	{0xa682, 0xcae9},
	{0xa683, 0xcaea},
	{0xa684, 0xcaeb},
	{0xa685, 0xcaed},
	{0xa686, 0xcaee},
	{0xa687, 0xcaef},
	{0xa688, 0xcaf0},
	{0xa689, 0xcaf1},
	{0xa68a, 0xcaf2},
	{0xa68b, 0xcaf3},
	{0xa68c, 0xcaf5},
	{0xa68d, 0xcaf6},
	{0xa68e, 0xcaf7},
	{0xa68f, 0xcaf8},
	{0xa690, 0xcaf9},
	{0xa691, 0xcafa},
	{0xa692, 0xcafb},
	{0xa693, 0xcafc},
	{0xa694, 0xcafd},
	{0xa695, 0xcafe},
	{0xa696, 0xcaff},
	{0xa697, 0xcb00},
	{0xa698, 0xcb01},
	{0xa699, 0xcb02},
	{0xa69a, 0xcb03},
	{0xa69b, 0xcb04},
	{0xa69c, 0xcb05},
	{0xa69d, 0xcb06},
	{0xa69e, 0xcb07},
	{0xa69f, 0xcb09},
	{0xa6a0, 0xcb0a},
	{0xa6a1, 0x2500},
	{0xa6a2, 0x2502},
	{0xa6a3, 0x250c},
	{0xa6a4, 0x2510},
	{0xa6a5, 0x2518},
	{0xa6a6, 0x2514},
	{0xa6a7, 0x251c},
	{0xa6a8, 0x252c},
	{0xa6a9, 0x2524},
	{0xa6aa, 0x2534},
	{0xa6ab, 0x253c},
	{0xa6ac, 0x2501},
	{0xa6ad, 0x2503},
	{0xa6ae, 0x250f},
	{0xa6af, 0x2513},
	{0xa6b0, 0x251b},
	{0xa6b1, 0x2517},
	{0xa6b2, 0x2523},
	{0xa6b3, 0x2533},
	{0xa6b4, 0x252b},
	{0xa6b5, 0x253b},
	{0xa6b6, 0x254b},
	{0xa6b7, 0x2520},
	{0xa6b8, 0x252f},
	{0xa6b9, 0x2528},
	{0xa6ba, 0x2537},
	{0xa6bb, 0x253f},
	{0xa6bc, 0x251d},
	{0xa6bd, 0x2530},
	{0xa6be, 0x2525},
	{0xa6bf, 0x2538},
	{0xa6c0, 0x2542},
	{0xa6c1, 0x2512},
	{0xa6c2, 0x2511},
	{0xa6c3, 0x251a},
	{0xa6c4, 0x2519},
	{0xa6c5, 0x2516},
	{0xa6c6, 0x2515},
	{0xa6c7, 0x250e},
	{0xa6c8, 0x250d},
	{0xa6c9, 0x251e},
	{0xa6ca, 0x251f},
	{0xa6cb, 0x2521},
	{0xa6cc, 0x2522},
	{0xa6cd, 0x2526},
	{0xa6ce, 0x2527},
	{0xa6cf, 0x2529},
	{0xa6d0, 0x252a},
	{0xa6d1, 0x252d},
	{0xa6d2, 0x252e},
	{0xa6d3, 0x2531},
	{0xa6d4, 0x2532},
	{0xa6d5, 0x2535},
	{0xa6d6, 0x2536},
	{0xa6d7, 0x2539},
	{0xa6d8, 0x253a},
	{0xa6d9, 0x253d},
	{0xa6da, 0x253e},
	{0xa6db, 0x2540},
	{0xa6dc, 0x2541},
	{0xa6dd, 0x2543},
	{0xa6de, 0x2544},
	{0xa6df, 0x2545},
	{0xa6e0, 0x2546},
	{0xa6e1, 0x2547},
	{0xa6e2, 0x2548},
	{0xa6e3, 0x2549},
	{0xa6e4, 0x254a},
	{0xa741, 0xcb0b},
	{0xa742, 0xcb0c},
	{0xa743, 0xcb0d},
	{0xa744, 0xcb0e},
	{0xa745, 0xcb0f},
	{0xa746, 0xcb11},
	{0xa747, 0xcb12},
	{0xa748, 0xcb13},
	{0xa749, 0xcb15},
	{0xa74a, 0xcb16},
	{0xa74b, 0xcb17},
	{0xa74c, 0xcb19},
	{0xa74d, 0xcb1a},
	{0xa74e, 0xcb1b},
	{0xa74f, 0xcb1c},
	{0xa750, 0xcb1d},
	{0xa751, 0xcb1e},
	{0xa752, 0xcb1f},
	{0xa753, 0xcb22},
	{0xa754, 0xcb23},
	{0xa755, 0xcb24},
	{0xa756, 0xcb25},
	{0xa757, 0xcb26},
	{0xa758, 0xcb27},
	{0xa759, 0xcb28},
	{0xa75a, 0xcb29},
	{0xa761, 0xcb2a},
	{0xa762, 0xcb2b},
	{0xa763, 0xcb2c},
	{0xa764, 0xcb2d},
	{0xa765, 0xcb2e},
	{0xa766, 0xcb2f},
	{0xa767, 0xcb30},
	{0xa768, 0xcb31},
	{0xa769, 0xcb32},
	{0xa76a, 0xcb33},
	{0xa76b, 0xcb34},
	{0xa76c, 0xcb35},
	{0xa76d, 0xcb36},
	{0xa76e, 0xcb37},
	{0xa76f, 0xcb38},
	{0xa770, 0xcb39},
	{0xa771, 0xcb3a},
	{0xa772, 0xcb3b},
	{0xa773, 0xcb3c},
	{0xa774, 0xcb3d},
	{0xa775, 0xcb3e},
	{0xa776, 0xcb3f},
	{0xa777, 0xcb40},
	{0xa778, 0xcb42},
	{0xa779, 0xcb43},
	{0xa77a, 0xcb44},
	{0xa781, 0xcb45},
	{0xa782, 0xcb46},
	{0xa783, 0xcb47},
	{0xa784, 0xcb4a},
	{0xa785, 0xcb4b},
	{0xa786, 0xcb4d},
	{0xa787, 0xcb4e},
	{0xa788, 0xcb4f},
	{0xa789, 0xcb51},
	{0xa78a, 0xcb52},
	{0xa78b, 0xcb53},
	{0xa78c, 0xcb54},
	{0xa78d, 0xcb55},
	{0xa78e, 0xcb56},
	{0xa78f, 0xcb57},
	{0xa790, 0xcb5a},
	{0xa791, 0xcb5b},
	{0xa792, 0xcb5c},
	{0xa793, 0xcb5e},
	{0xa794, 0xcb5f},
	{0xa795, 0xcb60},
	{0xa796, 0xcb61},
	{0xa797, 0xcb62},
	{0xa798, 0xcb63},
	{0xa799, 0xcb65},
	{0xa79a, 0xcb66},
	{0xa79b, 0xcb67},
	{0xa79c, 0xcb68},
	{0xa79d, 0xcb69},
	{0xa79e, 0xcb6a},
	{0xa79f, 0xcb6b},
	{0xa7a0, 0xcb6c},
	{0xa7a1, 0x3395},
	{0xa7a2, 0x3396},
	{0xa7a3, 0x3397},
	{0xa7a4, 0x2113},
	{0xa7a5, 0x3398},
	{0xa7a6, 0x33c4},
	{0xa7a7, 0x33a3},
	{0xa7a8, 0x33a4},
	{0xa7a9, 0x33a5},
	{0xa7aa, 0x33a6},
	{0xa7ab, 0x3399},
	{0xa7ac, 0x339a},
	{0xa7ad, 0x339b},
	{0xa7ae, 0x339c},
	{0xa7af, 0x339d},
	{0xa7b0, 0x339e},
	{0xa7b1, 0x339f},
	{0xa7b2, 0x33a0},
	{0xa7b3, 0x33a1},
	{0xa7b4, 0x33a2},
	{0xa7b5, 0x33ca},
	{0xa7b6, 0x338d},
	{0xa7b7, 0x338e},
	{0xa7b8, 0x338f},
	{0xa7b9, 0x33cf},
	{0xa7ba, 0x3388},
	{0xa7bb, 0x3389},
	{0xa7bc, 0x33c8},
	{0xa7bd, 0x33a7},
	{0xa7be, 0x33a8},
	{0xa7bf, 0x33b0},
	{0xa7c0, 0x33b1},
	{0xa7c1, 0x33b2},
	{0xa7c2, 0x33b3},
	{0xa7c3, 0x33b4},
	{0xa7c4, 0x33b5},
	{0xa7c5, 0x33b6},
	{0xa7c6, 0x33b7},
	{0xa7c7, 0x33b8},
	{0xa7c8, 0x33b9},
	{0xa7c9, 0x3380},
	{0xa7ca, 0x3381},
	{0xa7cb, 0x3382},
	{0xa7cc, 0x3383},
	{0xa7cd, 0x3384},
	{0xa7ce, 0x33ba},
	{0xa7cf, 0x33bb},
	{0xa7d0, 0x33bc},
	{0xa7d1, 0x33bd},
	{0xa7d2, 0x33be},
	{0xa7d3, 0x33bf},
	{0xa7d4, 0x3390},
	{0xa7d5, 0x3391},
	{0xa7d6, 0x3392},
	{0xa7d7, 0x3393},
	{0xa7d8, 0x3394},
	{0xa7d9, 0x2126},
	{0xa7da, 0x33c0},
	{0xa7db, 0x33c1},
	{0xa7dc, 0x338a},
	{0xa7dd, 0x338b},
	{0xa7de, 0x338c},
	{0xa7df, 0x33d6},
	{0xa7e0, 0x33c5},
	{0xa7e1, 0x33ad},
	{0xa7e2, 0x33ae},
	{0xa7e3, 0x33af},
	{0xa7e4, 0x33db},
	{0xa7e5, 0x33a9},
	{0xa7e6, 0x33aa},
	{0xa7e7, 0x33ab},
	{0xa7e8, 0x33ac},
	{0xa7e9, 0x33dd},
	{0xa7ea, 0x33d0},
	{0xa7eb, 0x33d3},
	{0xa7ec, 0x33c3},
	{0xa7ed, 0x33c9},
	{0xa7ee, 0x33dc},
	{0xa7ef, 0x33c6},
	{0xa841, 0xcb6d},
	{0xa842, 0xcb6e},
	{0xa843, 0xcb6f},
	{0xa844, 0xcb70},
	{0xa845, 0xcb71},
	{0xa846, 0xcb72},
	{0xa847, 0xcb73},
	{0xa848, 0xcb74},
	{0xa849, 0xcb75},
	{0xa84a, 0xcb76},
	{0xa84b, 0xcb77},
	{0xa84c, 0xcb7a},
	{0xa84d, 0xcb7b},
	{0xa84e, 0xcb7c},
	{0xa84f, 0xcb7d},
	{0xa850, 0xcb7e},
	{0xa851, 0xcb7f},
	{0xa852, 0xcb80},
	{0xa853, 0xcb81},
	{0xa854, 0xcb82},
	{0xa855, 0xcb83},
	{0xa856, 0xcb84},
	{0xa857, 0xcb85},
	{0xa858, 0xcb86},
	{0xa859, 0xcb87},
	{0xa85a, 0xcb88},
	{0xa861, 0xcb89},
	{0xa862, 0xcb8a},
	{0xa863, 0xcb8b},
	{0xa864, 0xcb8c},
	{0xa865, 0xcb8d},
	{0xa866, 0xcb8e},
	{0xa867, 0xcb8f},
	{0xa868, 0xcb90},
	{0xa869, 0xcb91},
	{0xa86a, 0xcb92},
	{0xa86b, 0xcb93},
	{0xa86c, 0xcb94},
	{0xa86d, 0xcb95},
	{0xa86e, 0xcb96},
	{0xa86f, 0xcb97},
	{0xa870, 0xcb98},
	{0xa871, 0xcb99},
	{0xa872, 0xcb9a},
	{0xa873, 0xcb9b},
	{0xa874, 0xcb9d},
	{0xa875, 0xcb9e},
	{0xa876, 0xcb9f},
	{0xa877, 0xcba0},
	{0xa878, 0xcba1},
	{0xa879, 0xcba2},
	{0xa87a, 0xcba3},
	{0xa881, 0xcba4},
	{0xa882, 0xcba5},
	{0xa883, 0xcba6},
	{0xa884, 0xcba7},
	{0xa885, 0xcba8},
	{0xa886, 0xcba9},
	{0xa887, 0xcbaa},
	{0xa888, 0xcbab},
	{0xa889, 0xcbac},
	{0xa88a, 0xcbad},
	{0xa88b, 0xcbae},
	{0xa88c, 0xcbaf},
	{0xa88d, 0xcbb0},
	{0xa88e, 0xcbb1},
	{0xa88f, 0xcbb2},
	{0xa890, 0xcbb3},
	{0xa891, 0xcbb4},
	{0xa892, 0xcbb5},
	{0xa893, 0xcbb6},
	{0xa894, 0xcbb7},
	{0xa895, 0xcbb9},
	{0xa896, 0xcbba},
	{0xa897, 0xcbbb},
	{0xa898, 0xcbbc},
	{0xa899, 0xcbbd},
	{0xa89a, 0xcbbe},
	{0xa89b, 0xcbbf},
	{0xa89c, 0xcbc0},
	{0xa89d, 0xcbc1},
	{0xa89e, 0xcbc2},
	{0xa89f, 0xcbc3},
	{0xa8a0, 0xcbc4},
	{0xa8a1, 0x00c6},
	{0xa8a2, 0x00d0},
	{0xa8a3, 0x00aa},
	{0xa8a4, 0x0126},
	{0xa8a6, 0x0132},
	{0xa8a8, 0x013f},
	{0xa8a9, 0x0141},
	{0xa8aa, 0x00d8},
	{0xa8ab, 0x0152},
	{0xa8ac, 0x00ba},
	{0xa8ad, 0x00de},
	{0xa8ae, 0x0166},
	{0xa8af, 0x014a},
	{0xa8b1, 0x3260},
	{0xa8b2, 0x3261},
	{0xa8b3, 0x3262},
	{0xa8b4, 0x3263},
	{0xa8b5, 0x3264},
	{0xa8b6, 0x3265},
	{0xa8b7, 0x3266},
	{0xa8b8, 0x3267},
	{0xa8b9, 0x3268},
	{0xa8ba, 0x3269},
	{0xa8bb, 0x326a},
	{0xa8bc, 0x326b},
	{0xa8bd, 0x326c},
	{0xa8be, 0x326d},
	{0xa8bf, 0x326e},
	{0xa8c0, 0x326f},
	{0xa8c1, 0x3270},
	{0xa8c2, 0x3271},
	{0xa8c3, 0x3272},
	{0xa8c4, 0x3273},
	{0xa8c5, 0x3274},
	{0xa8c6, 0x3275},
	{0xa8c7, 0x3276},
	{0xa8c8, 0x3277},
	{0xa8c9, 0x3278},
	{0xa8ca, 0x3279},
	{0xa8cb, 0x327a},
	{0xa8cc, 0x327b},
	{0xa8cd, 0x24d0},
	{0xa8ce, 0x24d1},
	{0xa8cf, 0x24d2},
	{0xa8d0, 0x24d3},
	{0xa8d1, 0x24d4},
	{0xa8d2, 0x24d5},
	{0xa8d3, 0x24d6},
	{0xa8d4, 0x24d7},
	{0xa8d5, 0x24d8},
	{0xa8d6, 0x24d9},
	{0xa8d7, 0x24da},
	{0xa8d8, 0x24db},
	{0xa8d9, 0x24dc},
	{0xa8da, 0x24dd},
	{0xa8db, 0x24de},
	{0xa8dc, 0x24df},
	{0xa8dd, 0x24e0},
	{0xa8de, 0x24e1},
	{0xa8df, 0x24e2},
	{0xa8e0, 0x24e3},
	{0xa8e1, 0x24e4},
	{0xa8e2, 0x24e5},
	{0xa8e3, 0x24e6},
	{0xa8e4, 0x24e7},
	{0xa8e5, 0x24e8},
	{0xa8e6, 0x24e9},
	{0xa8e7, 0x2460},
	{0xa8e8, 0x2461},
	{0xa8e9, 0x2462},
	{0xa8ea, 0x2463},
	{0xa8eb, 0x2464},
	{0xa8ec, 0x2465},
	{0xa8ed, 0x2466},
	{0xa8ee, 0x2467},
	{0xa8ef, 0x2468},
	{0xa8f0, 0x2469},
	{0xa8f1, 0x246a},
	{0xa8f2, 0x246b},
	{0xa8f3, 0x246c},
	{0xa8f4, 0x246d},
	{0xa8f5, 0x246e},
	{0xa8f6, 0x00bd},
	{0xa8f7, 0x2153},
	{0xa8f8, 0x2154},
	{0xa8f9, 0x00bc},
	{0xa8fa, 0x00be},
	{0xa8fb, 0x215b},
	{0xa8fc, 0x215c},
	{0xa8fd, 0x215d},
	{0xa8fe, 0x215e},
	{0xa941, 0xcbc5},
	{0xa942, 0xcbc6},
	{0xa943, 0xcbc7},
	{0xa944, 0xcbc8},
	{0xa945, 0xcbc9},
	{0xa946, 0xcbca},
	{0xa947, 0xcbcb},
	{0xa948, 0xcbcc},
	{0xa949, 0xcbcd},
	{0xa94a, 0xcbce},
	{0xa94b, 0xcbcf},
	{0xa94c, 0xcbd0},
	{0xa94d, 0xcbd1},
	{0xa94e, 0xcbd2},
	{0xa94f, 0xcbd3},
	{0xa950, 0xcbd5},
	{0xa951, 0xcbd6},
	{0xa952, 0xcbd7},
	{0xa953, 0xcbd8},
	{0xa954, 0xcbd9},
	{0xa955, 0xcbda},
	{0xa956, 0xcbdb},
	{0xa957, 0xcbdc},
	{0xa958, 0xcbdd},
	{0xa959, 0xcbde},
	{0xa95a, 0xcbdf},
	{0xa961, 0xcbe0},
	{0xa962, 0xcbe1},
	{0xa963, 0xcbe2},
	{0xa964, 0xcbe3},
	{0xa965, 0xcbe5},
	{0xa966, 0xcbe6},
	{0xa967, 0xcbe8},
	{0xa968, 0xcbea},
	{0xa969, 0xcbeb},
	{0xa96a, 0xcbec},
	{0xa96b, 0xcbed},
	{0xa96c, 0xcbee},
	{0xa96d, 0xcbef},
	{0xa96e, 0xcbf0},
	{0xa96f, 0xcbf1},
	{0xa970, 0xcbf2},
	{0xa971, 0xcbf3},
	{0xa972, 0xcbf4},
	{0xa973, 0xcbf5},
	{0xa974, 0xcbf6},
	{0xa975, 0xcbf7},
	{0xa976, 0xcbf8},
	{0xa977, 0xcbf9},
	{0xa978, 0xcbfa},
	{0xa979, 0xcbfb},
	{0xa97a, 0xcbfc},
	{0xa981, 0xcbfd},
	{0xa982, 0xcbfe},
	{0xa983, 0xcbff},
	{0xa984, 0xcc00},
	{0xa985, 0xcc01},
	{0xa986, 0xcc02},
	{0xa987, 0xcc03},
	{0xa988, 0xcc04},
	{0xa989, 0xcc05},
	{0xa98a, 0xcc06},
	{0xa98b, 0xcc07},
	{0xa98c, 0xcc08},
	{0xa98d, 0xcc09},
	{0xa98e, 0xcc0a},
	{0xa98f, 0xcc0b},
	{0xa990, 0xcc0e},
	{0xa991, 0xcc0f},
	{0xa992, 0xcc11},
	{0xa993, 0xcc12},
	{0xa994, 0xcc13},
	{0xa995, 0xcc15},
	{0xa996, 0xcc16},
	{0xa997, 0xcc17},
	{0xa998, 0xcc18},
	{0xa999, 0xcc19},
	{0xa99a, 0xcc1a},
	{0xa99b, 0xcc1b},
	{0xa99c, 0xcc1e},
	{0xa99d, 0xcc1f},
	{0xa99e, 0xcc20},
	{0xa99f, 0xcc23},
	{0xa9a0, 0xcc24},
	{0xa9a1, 0x00e6},
	{0xa9a2, 0x0111},
	{0xa9a3, 0x00f0},
	{0xa9a4, 0x0127},
	{0xa9a5, 0x0131},
	{0xa9a6, 0x0133},
	{0xa9a7, 0x0138},
	{0xa9a8, 0x0140},
	{0xa9a9, 0x0142},
	{0xa9aa, 0x00f8},
	{0xa9ab, 0x0153},
	{0xa9ac, 0x00df},
	{0xa9ad, 0x00fe},
	{0xa9ae, 0x0167},
	{0xa9af, 0x014b},
	{0xa9b0, 0x0149},
	{0xa9b1, 0x3200},
	{0xa9b2, 0x3201},
	{0xa9b3, 0x3202},
	{0xa9b4, 0x3203},
	{0xa9b5, 0x3204},
	{0xa9b6, 0x3205},
	{0xa9b7, 0x3206},
	{0xa9b8, 0x3207},
	{0xa9b9, 0x3208},
	{0xa9ba, 0x3209},
	{0xa9bb, 0x320a},
	{0xa9bc, 0x320b},
	{0xa9bd, 0x320c},
	{0xa9be, 0x320d},
	{0xa9bf, 0x320e},
	{0xa9c0, 0x320f},
	{0xa9c1, 0x3210},
	{0xa9c2, 0x3211},
	{0xa9c3, 0x3212},
	{0xa9c4, 0x3213},
	{0xa9c5, 0x3214},
	{0xa9c6, 0x3215},
	{0xa9c7, 0x3216},
	{0xa9c8, 0x3217},
	{0xa9c9, 0x3218},
	{0xa9ca, 0x3219},
	{0xa9cb, 0x321a},
	{0xa9cc, 0x321b},
	{0xa9cd, 0x249c},
	{0xa9ce, 0x249d},
	{0xa9cf, 0x249e},
	{0xa9d0, 0x249f},
	{0xa9d1, 0x24a0},
	{0xa9d2, 0x24a1},
	{0xa9d3, 0x24a2},
	{0xa9d4, 0x24a3},
	{0xa9d5, 0x24a4},
	{0xa9d6, 0x24a5},
	{0xa9d7, 0x24a6},
	{0xa9d8, 0x24a7},
	{0xa9d9, 0x24a8},
	{0xa9da, 0x24a9},
	{0xa9db, 0x24aa},
	{0xa9dc, 0x24ab},
	{0xa9dd, 0x24ac},
	{0xa9de, 0x24ad},
	{0xa9df, 0x24ae},
	{0xa9e0, 0x24af},
	{0xa9e1, 0x24b0},
	{0xa9e2, 0x24b1},
	{0xa9e3, 0x24b2},
	{0xa9e4, 0x24b3},
	{0xa9e5, 0x24b4},
	{0xa9e6, 0x24b5},
	{0xa9e7, 0x2474},
	{0xa9e8, 0x2475},
	{0xa9e9, 0x2476},
	{0xa9ea, 0x2477},
	{0xa9eb, 0x2478},
	{0xa9ec, 0x2479},
	{0xa9ed, 0x247a},
	{0xa9ee, 0x247b},
	{0xa9ef, 0x247c},
	{0xa9f0, 0x247d},
	{0xa9f1, 0x247e},
	{0xa9f2, 0x247f},
	{0xa9f3, 0x2480},
	{0xa9f4, 0x2481},
	{0xa9f5, 0x2482},
	{0xa9f6, 0x00b9},
	{0xa9f7, 0x00b2},
	{0xa9f8, 0x00b3},
	{0xa9f9, 0x2074},
	{0xa9fa, 0x207f},
	{0xa9fb, 0x2081},
	{0xa9fc, 0x2082},
	{0xa9fd, 0x2083},
	{0xa9fe, 0x2084},
	{0xaa41, 0xcc25},
	{0xaa42, 0xcc26},
	{0xaa43, 0xcc2a},
	{0xaa44, 0xcc2b},
	{0xaa45, 0xcc2d},
	{0xaa46, 0xcc2f},
	{0xaa47, 0xcc31},
	{0xaa48, 0xcc32},
	{0xaa49, 0xcc33},
	{0xaa4a, 0xcc34},
	{0xaa4b, 0xcc35},
	{0xaa4c, 0xcc36},
	{0xaa4d, 0xcc37},
	{0xaa4e, 0xcc3a},
	{0xaa4f, 0xcc3f},
	{0xaa50, 0xcc40},
	{0xaa51, 0xcc41},
	{0xaa52, 0xcc42},
	{0xaa53, 0xcc43},
	{0xaa54, 0xcc46},
	{0xaa55, 0xcc47},
	{0xaa56, 0xcc49},
	{0xaa57, 0xcc4a},
	{0xaa58, 0xcc4b},
	{0xaa59, 0xcc4d},
	{0xaa5a, 0xcc4e},
	{0xaa61, 0xcc4f},
	{0xaa62, 0xcc50},
	{0xaa63, 0xcc51},
	{0xaa64, 0xcc52},
	{0xaa65, 0xcc53},
	{0xaa66, 0xcc56},
	{0xaa67, 0xcc5a},
	{0xaa68, 0xcc5b},
	{0xaa69, 0xcc5c},
	{0xaa6a, 0xcc5d},
	{0xaa6b, 0xcc5e},
	{0xaa6c, 0xcc5f},
	{0xaa6d, 0xcc61},
	{0xaa6e, 0xcc62},
	{0xaa6f, 0xcc63},
	{0xaa70, 0xcc65},
	{0xaa71, 0xcc67},
	{0xaa72, 0xcc69},
	{0xaa73, 0xcc6a},
	{0xaa74, 0xcc6b},
	{0xaa75, 0xcc6c},
	{0xaa76, 0xcc6d},
	{0xaa77, 0xcc6e},
	{0xaa78, 0xcc6f},
	{0xaa79, 0xcc71},
	{0xaa7a, 0xcc72},
	{0xaa81, 0xcc73},
	{0xaa82, 0xcc74},
	{0xaa83, 0xcc76},
	{0xaa84, 0xcc77},
	{0xaa85, 0xcc78},
	{0xaa86, 0xcc79},
	{0xaa87, 0xcc7a},
	{0xaa88, 0xcc7b},
	{0xaa89, 0xcc7c},
	{0xaa8a, 0xcc7d},
	{0xaa8b, 0xcc7e},
	{0xaa8c, 0xcc7f},
	{0xaa8d, 0xcc80},
	{0xaa8e, 0xcc81},
	{0xaa8f, 0xcc82},
	{0xaa90, 0xcc83},
	{0xaa91, 0xcc84},
	{0xaa92, 0xcc85},
	{0xaa93, 0xcc86},
	{0xaa94, 0xcc87},
	{0xaa95, 0xcc88},
	{0xaa96, 0xcc89},
	{0xaa97, 0xcc8a},
	{0xaa98, 0xcc8b},
	{0xaa99, 0xcc8c},
	{0xaa9a, 0xcc8d},
	{0xaa9b, 0xcc8e},
	{0xaa9c, 0xcc8f},
	{0xaa9d, 0xcc90},
	{0xaa9e, 0xcc91},
	{0xaa9f, 0xcc92},
	{0xaaa0, 0xcc93},
	{0xaaa1, 0x3041},
	{0xaaa2, 0x3042},
	{0xaaa3, 0x3043},
	{0xaaa4, 0x3044},
	{0xaaa5, 0x3045},
	{0xaaa6, 0x3046},
	{0xaaa7, 0x3047},
	{0xaaa8, 0x3048},
	{0xaaa9, 0x3049},
	{0xaaaa, 0x304a},
	{0xaaab, 0x304b},
	{0xaaac, 0x304c},
	{0xaaad, 0x304d},
	{0xaaae, 0x304e},
	{0xaaaf, 0x304f},
	{0xaab0, 0x3050},
	{0xaab1, 0x3051},
	{0xaab2, 0x3052},
	{0xaab3, 0x3053},
	{0xaab4, 0x3054},
	{0xaab5, 0x3055},
	{0xaab6, 0x3056},
	{0xaab7, 0x3057},
	{0xaab8, 0x3058},
	{0xaab9, 0x3059},
	{0xaaba, 0x305a},
	{0xaabb, 0x305b},
	{0xaabc, 0x305c},
	{0xaabd, 0x305d},
	{0xaabe, 0x305e},
	{0xaabf, 0x305f},
	{0xaac0, 0x3060},
	{0xaac1, 0x3061},
	{0xaac2, 0x3062},
	{0xaac3, 0x3063},
	{0xaac4, 0x3064},
	{0xaac5, 0x3065},
	{0xaac6, 0x3066},
	{0xaac7, 0x3067},
	{0xaac8, 0x3068},
	{0xaac9, 0x3069},
	{0xaaca, 0x306a},
	{0xaacb, 0x306b},
	{0xaacc, 0x306c},
	{0xaacd, 0x306d},
	{0xaace, 0x306e},
	{0xaacf, 0x306f},
	{0xaad0, 0x3070},
	{0xaad1, 0x3071},
	{0xaad2, 0x3072},
	{0xaad3, 0x3073},
	{0xaad4, 0x3074},
	{0xaad5, 0x3075},
	{0xaad6, 0x3076},
	{0xaad7, 0x3077},
	{0xaad8, 0x3078},
	{0xaad9, 0x3079},
	{0xaada, 0x307a},
	{0xaadb, 0x307b},
	{0xaadc, 0x307c},
	{0xaadd, 0x307d},
	{0xaade, 0x307e},
	{0xaadf, 0x307f},
	{0xaae0, 0x3080},
	{0xaae1, 0x3081},
	{0xaae2, 0x3082},
	{0xaae3, 0x3083},
	{0xaae4, 0x3084},
	{0xaae5, 0x3085},
	{0xaae6, 0x3086},
	{0xaae7, 0x3087},
	{0xaae8, 0x3088},
	{0xaae9, 0x3089},
	{0xaaea, 0x308a},
	{0xaaeb, 0x308b},
	{0xaaec, 0x308c},
	{0xaaed, 0x308d},
	{0xaaee, 0x308e},
	{0xaaef, 0x308f},
	{0xaaf0, 0x3090},
	{0xaaf1, 0x3091},
	{0xaaf2, 0x3092},
	{0xaaf3, 0x3093},
	{0xab41, 0xcc94},
	{0xab42, 0xcc95},
	{0xab43, 0xcc96},
	{0xab44, 0xcc97},
	{0xab45, 0xcc9a},
	{0xab46, 0xcc9b},
	{0xab47, 0xcc9d},
	{0xab48, 0xcc9e},
	{0xab49, 0xcc9f},
	{0xab4a, 0xcca1},
	{0xab4b, 0xcca2},
	{0xab4c, 0xcca3},
	{0xab4d, 0xcca4},
	{0xab4e, 0xcca5},
	{0xab4f, 0xcca6},
	{0xab50, 0xcca7},
	{0xab51, 0xccaa},
	{0xab52, 0xccae},
	{0xab53, 0xccaf},
	{0xab54, 0xccb0},
	{0xab55, 0xccb1},
	{0xab56, 0xccb2},
	{0xab57, 0xccb3},
	{0xab58, 0xccb6},
	{0xab59, 0xccb7},
	{0xab5a, 0xccb9},
	{0xab61, 0xccba},
	{0xab62, 0xccbb},
	{0xab63, 0xccbd},
	{0xab64, 0xccbe},
	{0xab65, 0xccbf},
	{0xab66, 0xccc0},
	{0xab67, 0xccc1},
	{0xab68, 0xccc2},
	{0xab69, 0xccc3},
	{0xab6a, 0xccc6},
	{0xab6b, 0xccc8},
	{0xab6c, 0xccca},
	{0xab6d, 0xcccb},
	{0xab6e, 0xcccc},
	{0xab6f, 0xcccd},
	{0xab70, 0xccce},
	{0xab71, 0xcccf},
	{0xab72, 0xccd1},
	{0xab73, 0xccd2},
	{0xab74, 0xccd3},
	{0xab75, 0xccd5},
	{0xab76, 0xccd6},
	{0xab77, 0xccd7},
	{0xab78, 0xccd8},
	{0xab79, 0xccd9},
	{0xab7a, 0xccda},
	{0xab81, 0xccdb},
	{0xab82, 0xccdc},
	{0xab83, 0xccdd},
	{0xab84, 0xccde},
	{0xab85, 0xccdf},
	{0xab86, 0xcce0},
	{0xab87, 0xcce1},
	{0xab88, 0xcce2},
	{0xab89, 0xcce3},
	{0xab8a, 0xcce5},
	{0xab8b, 0xcce6},
	{0xab8c, 0xcce7},
	{0xab8d, 0xcce8},
	{0xab8e, 0xcce9},
	{0xab8f, 0xccea},
	{0xab90, 0xcceb},
	{0xab91, 0xcced},
	{0xab92, 0xccee},
	{0xab93, 0xccef},
	{0xab94, 0xccf1},
	{0xab95, 0xccf2},
	{0xab96, 0xccf3},
	{0xab97, 0xccf4},
	{0xab98, 0xccf5},
	{0xab99, 0xccf6},
	{0xab9a, 0xccf7},
	{0xab9b, 0xccf8},
	{0xab9c, 0xccf9},
	{0xab9d, 0xccfa},
	{0xab9e, 0xccfb},
	{0xab9f, 0xccfc},
	{0xaba0, 0xccfd},
	{0xaba1, 0x30a1},
	{0xaba2, 0x30a2},
	{0xaba3, 0x30a3},
	{0xaba4, 0x30a4},
	{0xaba5, 0x30a5},
	{0xaba6, 0x30a6},
	{0xaba7, 0x30a7},
	{0xaba8, 0x30a8},
	{0xaba9, 0x30a9},
	{0xabaa, 0x30aa},
	{0xabab, 0x30ab},
	{0xabac, 0x30ac},
	{0xabad, 0x30ad},
	{0xabae, 0x30ae},
	{0xabaf, 0x30af},
	{0xabb0, 0x30b0},
	{0xabb1, 0x30b1},
	{0xabb2, 0x30b2},
	{0xabb3, 0x30b3},
	{0xabb4, 0x30b4},
	{0xabb5, 0x30b5},
	{0xabb6, 0x30b6},
	{0xabb7, 0x30b7},
	{0xabb8, 0x30b8},
	{0xabb9, 0x30b9},
	{0xabba, 0x30ba},
	{0xabbb, 0x30bb},
	{0xabbc, 0x30bc},
	{0xabbd, 0x30bd},
	{0xabbe, 0x30be},
	{0xabbf, 0x30bf},
	{0xabc0, 0x30c0},
	{0xabc1, 0x30c1},
	{0xabc2, 0x30c2},
	{0xabc3, 0x30c3},
	{0xabc4, 0x30c4},
	{0xabc5, 0x30c5},
	{0xabc6, 0x30c6},
	{0xabc7, 0x30c7},
	{0xabc8, 0x30c8},
	{0xabc9, 0x30c9},
	{0xabca, 0x30ca},
	{0xabcb, 0x30cb},
	{0xabcc, 0x30cc},
	{0xabcd, 0x30cd},
	{0xabce, 0x30ce},
	{0xabcf, 0x30cf},
	{0xabd0, 0x30d0},
	{0xabd1, 0x30d1},
	{0xabd2, 0x30d2},
	{0xabd3, 0x30d3},
	{0xabd4, 0x30d4},
	{0xabd5, 0x30d5},
	{0xabd6, 0x30d6},
	{0xabd7, 0x30d7},
	{0xabd8, 0x30d8},
	{0xabd9, 0x30d9},
	{0xabda, 0x30da},
	{0xabdb, 0x30db},
	{0xabdc, 0x30dc},
	{0xabdd, 0x30dd},
	{0xabde, 0x30de},
	{0xabdf, 0x30df},
	{0xabe0, 0x30e0},
	{0xabe1, 0x30e1},
	{0xabe2, 0x30e2},
	{0xabe3, 0x30e3},
	{0xabe4, 0x30e4},
	{0xabe5, 0x30e5},
	{0xabe6, 0x30e6},
	{0xabe7, 0x30e7},
	{0xabe8, 0x30e8},
	{0xabe9, 0x30e9},
	{0xabea, 0x30ea},
	{0xabeb, 0x30eb},
	{0xabec, 0x30ec},
	{0xabed, 0x30ed},
	{0xabee, 0x30ee},
	{0xabef, 0x30ef},
	{0xabf0, 0x30f0},
	{0xabf1, 0x30f1},
	{0xabf2, 0x30f2},
	{0xabf3, 0x30f3},
	{0xabf4, 0x30f4},
	{0xabf5, 0x30f5},
	{0xabf6, 0x30f6},
	{0xac41, 0xccfe},
	{0xac42, 0xccff},
	{0xac43, 0xcd00},
	{0xac44, 0xcd02},
	{0xac45, 0xcd03},
	{0xac46, 0xcd04},
	{0xac47, 0xcd05},
	{0xac48, 0xcd06},
	{0xac49, 0xcd07},
	{0xac4a, 0xcd0a},
	{0xac4b, 0xcd0b},
	{0xac4c, 0xcd0d},
	{0xac4d, 0xcd0e},
	{0xac4e, 0xcd0f},
	{0xac4f, 0xcd11},
	{0xac50, 0xcd12},
	{0xac51, 0xcd13},
	{0xac52, 0xcd14},
	{0xac53, 0xcd15},
	{0xac54, 0xcd16},
	{0xac55, 0xcd17},
	{0xac56, 0xcd1a},
	{0xac57, 0xcd1c},
	{0xac58, 0xcd1e},
	{0xac59, 0xcd1f},
	{0xac5a, 0xcd20},
	{0xac61, 0xcd21},
	{0xac62, 0xcd22},
	{0xac63, 0xcd23},
	{0xac64, 0xcd25},
	{0xac65, 0xcd26},
	{0xac66, 0xcd27},
	{0xac67, 0xcd29},
	{0xac68, 0xcd2a},
	{0xac69, 0xcd2b},
	{0xac6a, 0xcd2d},
	{0xac6b, 0xcd2e},
	{0xac6c, 0xcd2f},
	{0xac6d, 0xcd30},
	{0xac6e, 0xcd31},
	{0xac6f, 0xcd32},
	{0xac70, 0xcd33},
	{0xac71, 0xcd34},
	{0xac72, 0xcd35},
	{0xac73, 0xcd36},
	{0xac74, 0xcd37},
	{0xac75, 0xcd38},
	{0xac76, 0xcd3a},
	{0xac77, 0xcd3b},
	{0xac78, 0xcd3c},
	{0xac79, 0xcd3d},
	{0xac7a, 0xcd3e},
	{0xac81, 0xcd3f},
	{0xac82, 0xcd40},
	{0xac83, 0xcd41},
	{0xac84, 0xcd42},
	{0xac85, 0xcd43},
	{0xac86, 0xcd44},
	{0xac87, 0xcd45},
	{0xac88, 0xcd46},
	{0xac89, 0xcd47},
	{0xac8a, 0xcd48},
	{0xac8b, 0xcd49},
	{0xac8c, 0xcd4a},
	{0xac8d, 0xcd4b},
	{0xac8e, 0xcd4c},
	{0xac8f, 0xcd4d},
	{0xac90, 0xcd4e},
	{0xac91, 0xcd4f},
	{0xac92, 0xcd50},
	{0xac93, 0xcd51},
	{0xac94, 0xcd52},
	{0xac95, 0xcd53},
	{0xac96, 0xcd54},
	{0xac97, 0xcd55},
	{0xac98, 0xcd56},
	{0xac99, 0xcd57},
	{0xac9a, 0xcd58},
	{0xac9b, 0xcd59},
	{0xac9c, 0xcd5a},
	{0xac9d, 0xcd5b},
	{0xac9e, 0xcd5d},
	{0xac9f, 0xcd5e},
	{0xaca0, 0xcd5f},
	{0xaca1, 0x0410},
	{0xaca2, 0x0411},
	{0xaca3, 0x0412},
	{0xaca4, 0x0413},
	{0xaca5, 0x0414},
	{0xaca6, 0x0415},
	{0xaca7, 0x0401},
	{0xaca8, 0x0416},
	{0xaca9, 0x0417},
	{0xacaa, 0x0418},
	{0xacab, 0x0419},
	{0xacac, 0x041a},
	{0xacad, 0x041b},
	{0xacae, 0x041c},
	{0xacaf, 0x041d},
	{0xacb0, 0x041e},
	{0xacb1, 0x041f},
	{0xacb2, 0x0420},
	{0xacb3, 0x0421},
	{0xacb4, 0x0422},
	{0xacb5, 0x0423},
	{0xacb6, 0x0424},
	{0xacb7, 0x0425},
	{0xacb8, 0x0426},
	{0xacb9, 0x0427},
	{0xacba, 0x0428},
	{0xacbb, 0x0429},
	{0xacbc, 0x042a},
	{0xacbd, 0x042b},
	{0xacbe, 0x042c},
	{0xacbf, 0x042d},
	{0xacc0, 0x042e},
	{0xacc1, 0x042f},
	{0xacd1, 0x0430},
	{0xacd2, 0x0431},
	{0xacd3, 0x0432},
	{0xacd4, 0x0433},
	{0xacd5, 0x0434},
	{0xacd6, 0x0435},
	{0xacd7, 0x0451},
	{0xacd8, 0x0436},
	{0xacd9, 0x0437},
	{0xacda, 0x0438},
	{0xacdb, 0x0439},
	{0xacdc, 0x043a},
	{0xacdd, 0x043b},
	{0xacde, 0x043c},
	{0xacdf, 0x043d},
	{0xace0, 0x043e},
	{0xace1, 0x043f},
	{0xace2, 0x0440},
	{0xace3, 0x0441},
	{0xace4, 0x0442},
	{0xace5, 0x0443},
	{0xace6, 0x0444},
	{0xace7, 0x0445},
	{0xace8, 0x0446},
	{0xace9, 0x0447},
	{0xacea, 0x0448},
	{0xaceb, 0x0449},
	{0xacec, 0x044a},
	{0xaced, 0x044b},
	{0xacee, 0x044c},
	{0xacef, 0x044d},
	{0xacf0, 0x044e},
	{0xacf1, 0x044f},
	{0xad41, 0xcd61},
	{0xad42, 0xcd62},
	{0xad43, 0xcd63},
	{0xad44, 0xcd65},
	{0xad45, 0xcd66},
	{0xad46, 0xcd67},
	{0xad47, 0xcd68},
	{0xad48, 0xcd69},
	{0xad49, 0xcd6a},
	{0xad4a, 0xcd6b},
	{0xad4b, 0xcd6e},
	{0xad4c, 0xcd70},
	{0xad4d, 0xcd72},
	{0xad4e, 0xcd73},
	{0xad4f, 0xcd74},
	{0xad50, 0xcd75},
	{0xad51, 0xcd76},
	{0xad52, 0xcd77},
	{0xad53, 0xcd79},
	{0xad54, 0xcd7a},
	{0xad55, 0xcd7b},
	{0xad56, 0xcd7c},
	{0xad57, 0xcd7d},
	{0xad58, 0xcd7e},
	{0xad59, 0xcd7f},
	{0xad5a, 0xcd80},
	{0xad61, 0xcd81},
	{0xad62, 0xcd82},
	{0xad63, 0xcd83},
	{0xad64, 0xcd84},
	{0xad65, 0xcd85},
	{0xad66, 0xcd86},
	{0xad67, 0xcd87},
	{0xad68, 0xcd89},
	{0xad69, 0xcd8a},
	{0xad6a, 0xcd8b},
	{0xad6b, 0xcd8c},
	{0xad6c, 0xcd8d},
	{0xad6d, 0xcd8e},
	{0xad6e, 0xcd8f},
	{0xad6f, 0xcd90},
	{0xad70, 0xcd91},
	{0xad71, 0xcd92},
	{0xad72, 0xcd93},
	{0xad73, 0xcd96},
	{0xad74, 0xcd97},
	{0xad75, 0xcd99},
	{0xad76, 0xcd9a},
	{0xad77, 0xcd9b},
	{0xad78, 0xcd9d},
	{0xad79, 0xcd9e},
	{0xad7a, 0xcd9f},
	{0xad81, 0xcda0},
	{0xad82, 0xcda1},
	{0xad83, 0xcda2},
	{0xad84, 0xcda3},
	{0xad85, 0xcda6},
	{0xad86, 0xcda8},
	{0xad87, 0xcdaa},
	{0xad88, 0xcdab},
	{0xad89, 0xcdac},
	{0xad8a, 0xcdad},
	{0xad8b, 0xcdae},
	{0xad8c, 0xcdaf},
	{0xad8d, 0xcdb1},
	{0xad8e, 0xcdb2},
	{0xad8f, 0xcdb3},
	{0xad90, 0xcdb4},
	{0xad91, 0xcdb5},
	{0xad92, 0xcdb6},
	{0xad93, 0xcdb7},
	{0xad94, 0xcdb8},
	{0xad95, 0xcdb9},
	{0xad96, 0xcdba},
	{0xad97, 0xcdbb},
	{0xad98, 0xcdbc},
	{0xad99, 0xcdbd},
	{0xad9a, 0xcdbe},
	{0xad9b, 0xcdbf},
	{0xad9c, 0xcdc0},
	{0xad9d, 0xcdc1},
	{0xad9e, 0xcdc2},
	{0xad9f, 0xcdc3},
	{0xada0, 0xcdc5},
	{0xae41, 0xcdc6},
	{0xae42, 0xcdc7},
	{0xae43, 0xcdc8},
	{0xae44, 0xcdc9},
	{0xae45, 0xcdca},
	{0xae46, 0xcdcb},
	{0xae47, 0xcdcd},
	{0xae48, 0xcdce},
	{0xae49, 0xcdcf},
	{0xae4a, 0xcdd1},
	{0xae4b, 0xcdd2},
	{0xae4c, 0xcdd3},
	{0xae4d, 0xcdd4},
	{0xae4e, 0xcdd5},
	{0xae4f, 0xcdd6},
	{0xae50, 0xcdd7},
	{0xae51, 0xcdd8},
	{0xae52, 0xcdd9},
	{0xae53, 0xcdda},
	{0xae54, 0xcddb},
	{0xae55, 0xcddc},
	{0xae56, 0xcddd},
	{0xae57, 0xcdde},
	{0xae58, 0xcddf},
	{0xae59, 0xcde0},
	{0xae5a, 0xcde1},
	{0xae61, 0xcde2},
	{0xae62, 0xcde3},
	{0xae63, 0xcde4},
	{0xae64, 0xcde5},
	{0xae65, 0xcde6},
	{0xae66, 0xcde7},
	{0xae67, 0xcde9},
	{0xae68, 0xcdea},
	{0xae69, 0xcdeb},
	{0xae6a, 0xcded},
	{0xae6b, 0xcdee},
	{0xae6c, 0xcdef},
	{0xae6d, 0xcdf1},
	{0xae6e, 0xcdf2},
	{0xae6f, 0xcdf3},
	{0xae70, 0xcdf4},
	{0xae71, 0xcdf5},
	{0xae72, 0xcdf6},
	{0xae73, 0xcdf7},
	{0xae74, 0xcdfa},
	{0xae75, 0xcdfc},
	{0xae76, 0xcdfe},
	{0xae77, 0xcdff},
	{0xae78, 0xce00},
	{0xae79, 0xce01},
	{0xae7a, 0xce02},
	{0xae81, 0xce03},
	{0xae82, 0xce05},
	{0xae83, 0xce06},
	{0xae84, 0xce07},
	{0xae85, 0xce09},
	{0xae86, 0xce0a},
	{0xae87, 0xce0b},
	{0xae88, 0xce0d},
	{0xae89, 0xce0e},
	{0xae8a, 0xce0f},
	{0xae8b, 0xce10},
	{0xae8c, 0xce11},
	{0xae8d, 0xce12},
	{0xae8e, 0xce13},
	{0xae8f, 0xce15},
	{0xae90, 0xce16},
	{0xae91, 0xce17},
	{0xae92, 0xce18},
	{0xae93, 0xce1a},
	{0xae94, 0xce1b},
	{0xae95, 0xce1c},
	{0xae96, 0xce1d},
	{0xae97, 0xce1e},
	{0xae98, 0xce1f},
	{0xae99, 0xce22},
	{0xae9a, 0xce23},
	{0xae9b, 0xce25},
	{0xae9c, 0xce26},
	{0xae9d, 0xce27},
	{0xae9e, 0xce29},
	{0xae9f, 0xce2a},
	{0xaea0, 0xce2b},
	{0xaf41, 0xce2c},
	{0xaf42, 0xce2d},
	{0xaf43, 0xce2e},
	{0xaf44, 0xce2f},
	{0xaf45, 0xce32},
	{0xaf46, 0xce34},
	{0xaf47, 0xce36},
	{0xaf48, 0xce37},
	{0xaf49, 0xce38},
	{0xaf4a, 0xce39},
	{0xaf4b, 0xce3a},
	{0xaf4c, 0xce3b},
	{0xaf4d, 0xce3c},
	{0xaf4e, 0xce3d},
	{0xaf4f, 0xce3e},
	{0xaf50, 0xce3f},
	{0xaf51, 0xce40},
	{0xaf52, 0xce41},
	{0xaf53, 0xce42},
	{0xaf54, 0xce43},
	{0xaf55, 0xce44},
	{0xaf56, 0xce45},
	{0xaf57, 0xce46},
	{0xaf58, 0xce47},
	{0xaf59, 0xce48},
	{0xaf5a, 0xce49},
	{0xaf61, 0xce4a},
	{0xaf62, 0xce4b},
	{0xaf63, 0xce4c},
	{0xaf64, 0xce4d},
	{0xaf65, 0xce4e},
	{0xaf66, 0xce4f},
	{0xaf67, 0xce50},
	{0xaf68, 0xce51},
	{0xaf69, 0xce52},
	{0xaf6a, 0xce53},
	{0xaf6b, 0xce54},
	{0xaf6c, 0xce55},
	{0xaf6d, 0xce56},
	{0xaf6e, 0xce57},
	{0xaf6f, 0xce5a},
	{0xaf70, 0xce5b},
	{0xaf71, 0xce5d},
	{0xaf72, 0xce5e},
	{0xaf73, 0xce62},
	{0xaf74, 0xce63},
	{0xaf75, 0xce64},
	{0xaf76, 0xce65},
	{0xaf77, 0xce66},
	{0xaf78, 0xce67},
	{0xaf79, 0xce6a},
	{0xaf7a, 0xce6c},
	{0xaf81, 0xce6e},
	{0xaf82, 0xce6f},
	{0xaf83, 0xce70},
	{0xaf84, 0xce71},
	{0xaf85, 0xce72},
	{0xaf86, 0xce73},
	{0xaf87, 0xce76},
	{0xaf88, 0xce77},
	{0xaf89, 0xce79},
	{0xaf8a, 0xce7a},
	{0xaf8b, 0xce7b},
	{0xaf8c, 0xce7d},
	{0xaf8d, 0xce7e},
	{0xaf8e, 0xce7f},
	{0xaf8f, 0xce80},
	{0xaf90, 0xce81},
	{0xaf91, 0xce82},
	{0xaf92, 0xce83},
	{0xaf93, 0xce86},
	{0xaf94, 0xce88},
	{0xaf95, 0xce8a},
	{0xaf96, 0xce8b},
	{0xaf97, 0xce8c},
	{0xaf98, 0xce8d},
	{0xaf99, 0xce8e},
	{0xaf9a, 0xce8f},
	{0xaf9b, 0xce92},
	{0xaf9c, 0xce93},
	{0xaf9d, 0xce95},
	{0xaf9e, 0xce96},
	{0xaf9f, 0xce97},
	{0xafa0, 0xce99},
	{0xb041, 0xce9a},
	{0xb042, 0xce9b},
	{0xb043, 0xce9c},
	{0xb044, 0xce9d},
	{0xb045, 0xce9e},
	{0xb046, 0xce9f},
	{0xb047, 0xcea2},
	{0xb048, 0xcea6},
	{0xb049, 0xcea7},
	{0xb04a, 0xcea8},
	{0xb04b, 0xcea9},
	{0xb04c, 0xceaa},
	{0xb04d, 0xceab},
	{0xb04e, 0xceae},
	{0xb04f, 0xceaf},
	{0xb050, 0xceb0},
	{0xb051, 0xceb1},
	{0xb052, 0xceb2},
	{0xb053, 0xceb3},
	{0xb054, 0xceb4},
	{0xb055, 0xceb5},
	{0xb056, 0xceb6},
	{0xb057, 0xceb7},
	{0xb058, 0xceb8},
	{0xb059, 0xceb9},
	{0xb05a, 0xceba},
	{0xb061, 0xcebb},
	{0xb062, 0xcebc},
	{0xb063, 0xcebd},
	{0xb064, 0xcebe},
	{0xb065, 0xcebf},
	{0xb066, 0xcec0},
	{0xb067, 0xcec2},
	{0xb068, 0xcec3},
	{0xb069, 0xcec4},
	{0xb06a, 0xcec5},
	{0xb06b, 0xcec6},
	{0xb06c, 0xcec7},
	{0xb06d, 0xcec8},
	{0xb06e, 0xcec9},
	{0xb06f, 0xceca},
	{0xb070, 0xcecb},
	{0xb071, 0xcecc},
	{0xb072, 0xcecd},
	{0xb073, 0xcece},
	{0xb074, 0xcecf},
	{0xb075, 0xced0},
	{0xb076, 0xced1},
	{0xb077, 0xced2},
	{0xb078, 0xced3},
	{0xb079, 0xced4},
	{0xb07a, 0xced5},
	{0xb081, 0xced6},
	{0xb082, 0xced7},
	{0xb083, 0xced8},
	{0xb084, 0xced9},
	{0xb085, 0xceda},
	{0xb086, 0xcedb},
	{0xb087, 0xcedc},
	{0xb088, 0xcedd},
	{0xb089, 0xcede},
	{0xb08a, 0xcedf},
	{0xb08b, 0xcee0},
	{0xb08c, 0xcee1},
	{0xb08d, 0xcee2},
	{0xb08e, 0xcee3},
	{0xb08f, 0xcee6},
	{0xb090, 0xcee7},
	{0xb091, 0xcee9},
	{0xb092, 0xceea},
	{0xb093, 0xceed},
	{0xb094, 0xceee},
	{0xb095, 0xceef},
	{0xb096, 0xcef0},
	{0xb097, 0xcef1},
	{0xb098, 0xcef2},
	{0xb099, 0xcef3},
	{0xb09a, 0xcef6},
	{0xb09b, 0xcefa},
	{0xb09c, 0xcefb},
	{0xb09d, 0xcefc},
	{0xb09e, 0xcefd},
	{0xb09f, 0xcefe},
	{0xb0a0, 0xceff},
	{0xb0a1, 0xac00},
	{0xb0a2, 0xac01},
	{0xb0a3, 0xac04},
	{0xb0a4, 0xac07},
	{0xb0a5, 0xac08},
	{0xb0a6, 0xac09},
	{0xb0a7, 0xac0a},
	{0xb0a8, 0xac10},
	{0xb0a9, 0xac11},
	{0xb0aa, 0xac12},
	{0xb0ab, 0xac13},
	{0xb0ac, 0xac14},
	{0xb0ad, 0xac15},
	{0xb0ae, 0xac16},
	{0xb0af, 0xac17},
	{0xb0b0, 0xac19},
	{0xb0b1, 0xac1a},
	{0xb0b2, 0xac1b},
	{0xb0b3, 0xac1c},
	{0xb0b4, 0xac1d},
	{0xb0b5, 0xac20},
	{0xb0b6, 0xac24},
	{0xb0b7, 0xac2c},
	{0xb0b8, 0xac2d},
	{0xb0b9, 0xac2f},
	{0xb0ba, 0xac30},
	{0xb0bb, 0xac31},
	{0xb0bc, 0xac38},
	{0xb0bd, 0xac39},
	{0xb0be, 0xac3c},
	{0xb0bf, 0xac40},
	{0xb0c0, 0xac4b},
	{0xb0c1, 0xac4d},
	{0xb0c2, 0xac54},
	{0xb0c3, 0xac58},
	{0xb0c4, 0xac5c},
	{0xb0c5, 0xac70},
	{0xb0c6, 0xac71},
	{0xb0c7, 0xac74},
	{0xb0c8, 0xac77},
	{0xb0c9, 0xac78},
	{0xb0ca, 0xac7a},
	{0xb0cb, 0xac80},
	{0xb0cc, 0xac81},
	{0xb0cd, 0xac83},
	{0xb0ce, 0xac84},
	{0xb0cf, 0xac85},
	{0xb0d0, 0xac86},
	{0xb0d1, 0xac89},
	{0xb0d2, 0xac8a},
	{0xb0d3, 0xac8b},
	{0xb0d4, 0xac8c},
	{0xb0d5, 0xac90},
	{0xb0d6, 0xac94},
	{0xb0d7, 0xac9c},
	{0xb0d8, 0xac9d},
	{0xb0d9, 0xac9f},
	{0xb0da, 0xaca0},
	{0xb0db, 0xaca1},
	{0xb0dc, 0xaca8},
	{0xb0dd, 0xaca9},
	{0xb0de, 0xacaa},
	{0xb0df, 0xacac},
	{0xb0e0, 0xacaf},
	{0xb0e1, 0xacb0},
	{0xb0e2, 0xacb8},
	{0xb0e3, 0xacb9},
	{0xb0e4, 0xacbb},
	{0xb0e5, 0xacbc},
	{0xb0e6, 0xacbd},
	{0xb0e7, 0xacc1},
	{0xb0e8, 0xacc4},
	{0xb0e9, 0xacc8},
	{0xb0ea, 0xaccc},
	{0xb0eb, 0xacd5},
	{0xb0ec, 0xacd7},
	{0xb0ed, 0xace0},
	{0xb0ee, 0xace1},
	{0xb0ef, 0xace4},
	{0xb0f0, 0xace7},
	{0xb0f1, 0xace8},
	{0xb0f2, 0xacea},
	{0xb0f3, 0xacec},
	{0xb0f4, 0xacef},
	{0xb0f5, 0xacf0},
	{0xb0f6, 0xacf1},
	{0xb0f7, 0xacf3},
	{0xb0f8, 0xacf5},
	{0xb0f9, 0xacf6},
	{0xb0fa, 0xacfc},
	{0xb0fb, 0xacfd},
	{0xb0fc, 0xad00},
	{0xb0fd, 0xad04},
	{0xb0fe, 0xad06},
	{0xb141, 0xcf02},
	{0xb142, 0xcf03},
	{0xb143, 0xcf05},
	{0xb144, 0xcf06},
	{0xb145, 0xcf07},
	{0xb146, 0xcf09},
	{0xb147, 0xcf0a},
	{0xb148, 0xcf0b},
	{0xb149, 0xcf0c},
	{0xb14a, 0xcf0d},
	{0xb14b, 0xcf0e},
	{0xb14c, 0xcf0f},
	{0xb14d, 0xcf12},
	{0xb14e, 0xcf14},
	{0xb14f, 0xcf16},
	{0xb150, 0xcf17},
	{0xb151, 0xcf18},
	{0xb152, 0xcf19},
	{0xb153, 0xcf1a},
	{0xb154, 0xcf1b},
	{0xb155, 0xcf1d},
	{0xb156, 0xcf1e},
	{0xb157, 0xcf1f},
	{0xb158, 0xcf21},
	{0xb159, 0xcf22},
	{0xb15a, 0xcf23},
	{0xb161, 0xcf25},
	{0xb162, 0xcf26},
	{0xb163, 0xcf27},
	{0xb164, 0xcf28},
	{0xb165, 0xcf29},
	{0xb166, 0xcf2a},
	{0xb167, 0xcf2b},
	{0xb168, 0xcf2e},
	{0xb169, 0xcf32},
	{0xb16a, 0xcf33},
	{0xb16b, 0xcf34},
	{0xb16c, 0xcf35},
	{0xb16d, 0xcf36},
	{0xb16e, 0xcf37},
	{0xb16f, 0xcf39},
	{0xb170, 0xcf3a},
	{0xb171, 0xcf3b},
	{0xb172, 0xcf3c},
	{0xb173, 0xcf3d},
	{0xb174, 0xcf3e},
	{0xb175, 0xcf3f},
	{0xb176, 0xcf40},
	{0xb177, 0xcf41},
	{0xb178, 0xcf42},
	{0xb179, 0xcf43},
	{0xb17a, 0xcf44},
	{0xb181, 0xcf45},
	{0xb182, 0xcf46},
	{0xb183, 0xcf47},
	{0xb184, 0xcf48},
	{0xb185, 0xcf49},
	{0xb186, 0xcf4a},
	{0xb187, 0xcf4b},
	{0xb188, 0xcf4c},
	{0xb189, 0xcf4d},
	{0xb18a, 0xcf4e},
	{0xb18b, 0xcf4f},
	{0xb18c, 0xcf50},
	{0xb18d, 0xcf51},
	{0xb18e, 0xcf52},
	{0xb18f, 0xcf53},
	{0xb190, 0xcf56},
	{0xb191, 0xcf57},
	{0xb192, 0xcf59},
	{0xb193, 0xcf5a},
	{0xb194, 0xcf5b},
	{0xb195, 0xcf5d},
	{0xb196, 0xcf5e},
	{0xb197, 0xcf5f},
	{0xb198, 0xcf60},
	{0xb199, 0xcf61},
	{0xb19a, 0xcf62},
	{0xb19b, 0xcf63},
	{0xb19c, 0xcf66},
	{0xb19d, 0xcf68},
	{0xb19e, 0xcf6a},
	{0xb19f, 0xcf6b},
	{0xb1a0, 0xcf6c},
	{0xb1a1, 0xad0c},
	{0xb1a2, 0xad0d},
	{0xb1a3, 0xad0f},
	{0xb1a4, 0xad11},
	{0xb1a5, 0xad18},
	{0xb1a6, 0xad1c},
	{0xb1a7, 0xad20},
	{0xb1a8, 0xad29},
	{0xb1a9, 0xad2c},
	{0xb1aa, 0xad2d},
	{0xb1ab, 0xad34},
	{0xb1ac, 0xad35},
	{0xb1ad, 0xad38},
	{0xb1ae, 0xad3c},
	{0xb1af, 0xad44},
	{0xb1b0, 0xad45},
	{0xb1b1, 0xad47},
	{0xb1b2, 0xad49},
	{0xb1b3, 0xad50},
	{0xb1b4, 0xad54},
	{0xb1b5, 0xad58},
	{0xb1b6, 0xad61},
	{0xb1b7, 0xad63},
	{0xb1b8, 0xad6c},
	{0xb1b9, 0xad6d},
	{0xb1ba, 0xad70},
	{0xb1bb, 0xad73},
	{0xb1bc, 0xad74},
	{0xb1bd, 0xad75},
	{0xb1be, 0xad76},
	{0xb1bf, 0xad7b},
	{0xb1c0, 0xad7c},
	{0xb1c1, 0xad7d},
	{0xb1c2, 0xad7f},
	{0xb1c3, 0xad81},
	{0xb1c4, 0xad82},
	{0xb1c5, 0xad88},
	{0xb1c6, 0xad89},
	{0xb1c7, 0xad8c},
	{0xb1c8, 0xad90},
	{0xb1c9, 0xad9c},
	{0xb1ca, 0xad9d},
	{0xb1cb, 0xada4},
	{0xb1cc, 0xadb7},
	{0xb1cd, 0xadc0},
	{0xb1ce, 0xadc1},
	{0xb1cf, 0xadc4},
	{0xb1d0, 0xadc8},
	{0xb1d1, 0xadd0},
	{0xb1d2, 0xadd1},
	{0xb1d3, 0xadd3},
	{0xb1d4, 0xaddc},
	{0xb1d5, 0xade0},
	{0xb1d6, 0xade4},
	{0xb1d7, 0xadf8},
	{0xb1d8, 0xadf9},
	{0xb1d9, 0xadfc},
	{0xb1da, 0xadff},
	{0xb1db, 0xae00},
	{0xb1dc, 0xae01},
	{0xb1dd, 0xae08},
	{0xb1de, 0xae09},
	{0xb1df, 0xae0b},
	{0xb1e0, 0xae0d},
	{0xb1e1, 0xae14},
	{0xb1e2, 0xae30},
	{0xb1e3, 0xae31},
	{0xb1e4, 0xae34},
	{0xb1e5, 0xae37},
	{0xb1e6, 0xae38},
	{0xb1e7, 0xae3a},
	{0xb1e8, 0xae40},
	{0xb1e9, 0xae41},
	{0xb1ea, 0xae43},
	{0xb1eb, 0xae45},
	{0xb1ec, 0xae46},
	{0xb1ed, 0xae4a},
	{0xb1ee, 0xae4c},
	{0xb1ef, 0xae4d},
	{0xb1f0, 0xae4e},
	{0xb1f1, 0xae50},
	{0xb1f2, 0xae54},
	{0xb1f3, 0xae56},
	{0xb1f4, 0xae5c},
	{0xb1f5, 0xae5d},
	{0xb1f6, 0xae5f},
	{0xb1f7, 0xae60},
	{0xb1f8, 0xae61},
	{0xb1f9, 0xae65},
	{0xb1fa, 0xae68},
	{0xb1fb, 0xae69},
	{0xb1fc, 0xae6c},
	{0xb1fd, 0xae70},
	{0xb1fe, 0xae78},
	{0xb241, 0xcf6d},
	{0xb242, 0xcf6e},
	{0xb243, 0xcf6f},
	{0xb244, 0xcf72},
	{0xb245, 0xcf73},
	{0xb246, 0xcf75},
	{0xb247, 0xcf76},
	{0xb248, 0xcf77},
	{0xb249, 0xcf79},
	{0xb24a, 0xcf7a},
	{0xb24b, 0xcf7b},
	{0xb24c, 0xcf7c},
	{0xb24d, 0xcf7d},
	{0xb24e, 0xcf7e},
	{0xb24f, 0xcf7f},
	{0xb250, 0xcf81},
	{0xb251, 0xcf82},
	{0xb252, 0xcf83},
	{0xb253, 0xcf84},
	{0xb254, 0xcf86},
	{0xb255, 0xcf87},
	{0xb256, 0xcf88},
	{0xb257, 0xcf89},
	{0xb258, 0xcf8a},
	{0xb259, 0xcf8b},
	{0xb25a, 0xcf8d},
	{0xb261, 0xcf8e},
	{0xb262, 0xcf8f},
	{0xb263, 0xcf90},
	{0xb264, 0xcf91},
	{0xb265, 0xcf92},
	{0xb266, 0xcf93},
	{0xb267, 0xcf94},
	{0xb268, 0xcf95},
	{0xb269, 0xcf96},
	{0xb26a, 0xcf97},
	{0xb26b, 0xcf98},
	{0xb26c, 0xcf99},
	{0xb26d, 0xcf9a},
	{0xb26e, 0xcf9b},
	{0xb26f, 0xcf9c},
	{0xb270, 0xcf9d},
	{0xb271, 0xcf9e},
	{0xb272, 0xcf9f},
	{0xb273, 0xcfa0},
	{0xb274, 0xcfa2},
	{0xb275, 0xcfa3},
	{0xb276, 0xcfa4},
	{0xb277, 0xcfa5},
	{0xb278, 0xcfa6},
	{0xb279, 0xcfa7},
	{0xb27a, 0xcfa9},
	{0xb281, 0xcfaa},
	{0xb282, 0xcfab},
	{0xb283, 0xcfac},
	{0xb284, 0xcfad},
	{0xb285, 0xcfae},
	{0xb286, 0xcfaf},
	{0xb287, 0xcfb1},
	{0xb288, 0xcfb2},
	{0xb289, 0xcfb3},
	{0xb28a, 0xcfb4},
	{0xb28b, 0xcfb5},
	{0xb28c, 0xcfb6},
	{0xb28d, 0xcfb7},
	{0xb28e, 0xcfb8},
	{0xb28f, 0xcfb9},
	{0xb290, 0xcfba},
	{0xb291, 0xcfbb},
	{0xb292, 0xcfbc},
	{0xb293, 0xcfbd},
	{0xb294, 0xcfbe},
	{0xb295, 0xcfbf},
	{0xb296, 0xcfc0},
	{0xb297, 0xcfc1},
	{0xb298, 0xcfc2},
	{0xb299, 0xcfc3},
	{0xb29a, 0xcfc5},
	{0xb29b, 0xcfc6},
	{0xb29c, 0xcfc7},
	{0xb29d, 0xcfc8},
	{0xb29e, 0xcfc9},
	{0xb29f, 0xcfca},
	{0xb2a0, 0xcfcb},
	{0xb2a1, 0xae79},
	{0xb2a2, 0xae7b},
	{0xb2a3, 0xae7c},
	{0xb2a4, 0xae7d},
	{0xb2a5, 0xae84},
	{0xb2a6, 0xae85},
	{0xb2a7, 0xae8c},
	{0xb2a8, 0xaebc},
	{0xb2a9, 0xaebd},
	{0xb2aa, 0xaebe},
	{0xb2ab, 0xaec0},
	{0xb2ac, 0xaec4},
	{0xb2ad, 0xaecc},
	{0xb2ae, 0xaecd},
	{0xb2af, 0xaecf},
	{0xb2b0, 0xaed0},
	{0xb2b1, 0xaed1},
	{0xb2b2, 0xaed8},
	{0xb2b3, 0xaed9},
	{0xb2b4, 0xaedc},
	{0xb2b5, 0xaee8},
	{0xb2b6, 0xaeeb},
	{0xb2b7, 0xaeed},
	{0xb2b8, 0xaef4},
	{0xb2b9, 0xaef8},
	{0xb2ba, 0xaefc},
	{0xb2bb, 0xaf07},
	{0xb2bc, 0xaf08},
	{0xb2bd, 0xaf0d},
	{0xb2be, 0xaf10},
	{0xb2bf, 0xaf2c},
	{0xb2c0, 0xaf2d},
	{0xb2c1, 0xaf30},
	{0xb2c2, 0xaf32},
	{0xb2c3, 0xaf34},
	{0xb2c4, 0xaf3c},
	{0xb2c5, 0xaf3d},
	{0xb2c6, 0xaf3f},
	{0xb2c7, 0xaf41},
	{0xb2c8, 0xaf42},
	{0xb2c9, 0xaf43},
	{0xb2ca, 0xaf48},
	{0xb2cb, 0xaf49},
	{0xb2cc, 0xaf50},
	{0xb2cd, 0xaf5c},
	{0xb2ce, 0xaf5d},
	{0xb2cf, 0xaf64},
	{0xb2d0, 0xaf65},
	{0xb2d1, 0xaf79},
	{0xb2d2, 0xaf80},
	{0xb2d3, 0xaf84},
	{0xb2d4, 0xaf88},
	{0xb2d5, 0xaf90},
	{0xb2d6, 0xaf91},
	{0xb2d7, 0xaf95},
	{0xb2d8, 0xaf9c},
	{0xb2d9, 0xafb8},
	{0xb2da, 0xafb9},
	{0xb2db, 0xafbc},
	{0xb2dc, 0xafc0},
	{0xb2dd, 0xafc7},
	{0xb2de, 0xafc8},
	{0xb2df, 0xafc9},
	{0xb2e0, 0xafcb},
	{0xb2e1, 0xafcd},
	{0xb2e2, 0xafce},
	{0xb2e3, 0xafd4},
	{0xb2e4, 0xafdc},
	{0xb2e5, 0xafe8},
	{0xb2e6, 0xafe9},
	{0xb2e7, 0xaff0},
	{0xb2e8, 0xaff1},
	{0xb2e9, 0xaff4},
	{0xb2ea, 0xaff8},
	{0xb2eb, 0xb000},
	{0xb2ec, 0xb001},
	{0xb2ed, 0xb004},
	{0xb2ee, 0xb00c},
	{0xb2ef, 0xb010},
	{0xb2f0, 0xb014},
	{0xb2f1, 0xb01c},
	{0xb2f2, 0xb01d},
	{0xb2f3, 0xb028},
	{0xb2f4, 0xb044},
	{0xb2f5, 0xb045},
	{0xb2f6, 0xb048},
	{0xb2f7, 0xb04a},
	{0xb2f8, 0xb04c},
	{0xb2f9, 0xb04e},
	{0xb2fa, 0xb053},
	{0xb2fb, 0xb054},
	{0xb2fc, 0xb055},
	{0xb2fd, 0xb057},
	{0xb2fe, 0xb059},
	{0xb341, 0xcfcc},
	{0xb342, 0xcfcd},
	{0xb343, 0xcfce},
	{0xb344, 0xcfcf},
	{0xb345, 0xcfd0},
	{0xb346, 0xcfd1},
	{0xb347, 0xcfd2},
	{0xb348, 0xcfd3},
	{0xb349, 0xcfd4},
	{0xb34a, 0xcfd5},
	{0xb34b, 0xcfd6},
	{0xb34c, 0xcfd7},
	{0xb34d, 0xcfd8},
	{0xb34e, 0xcfd9},
	{0xb34f, 0xcfda},
	{0xb350, 0xcfdb},
	{0xb351, 0xcfdc},
	{0xb352, 0xcfdd},
	{0xb353, 0xcfde},
	{0xb354, 0xcfdf},
	{0xb355, 0xcfe2},
	{0xb356, 0xcfe3},
	{0xb357, 0xcfe5},
	{0xb358, 0xcfe6},
	{0xb359, 0xcfe7},
	{0xb35a, 0xcfe9},
	{0xb361, 0xcfea},
	{0xb362, 0xcfeb},
	{0xb363, 0xcfec},
	{0xb364, 0xcfed},
	{0xb365, 0xcfee},
	{0xb366, 0xcfef},
	{0xb367, 0xcff2},
	{0xb368, 0xcff4},
	{0xb369, 0xcff6},
	{0xb36a, 0xcff7},
	{0xb36b, 0xcff8},
	{0xb36c, 0xcff9},
	{0xb36d, 0xcffa},
	{0xb36e, 0xcffb},
	{0xb36f, 0xcffd},
	{0xb370, 0xcffe},
	{0xb371, 0xcfff},
	{0xb372, 0xd001},
	{0xb373, 0xd002},
	{0xb374, 0xd003},
	{0xb375, 0xd005},
	{0xb376, 0xd006},
	{0xb377, 0xd007},
	{0xb378, 0xd008},
	{0xb379, 0xd009},
	{0xb37a, 0xd00a},
	{0xb381, 0xd00b},
	{0xb382, 0xd00c},
	{0xb383, 0xd00d},
	{0xb384, 0xd00e},
	{0xb385, 0xd00f},
	{0xb386, 0xd010},
	{0xb387, 0xd012},
	{0xb388, 0xd013},
	{0xb389, 0xd014},
	{0xb38a, 0xd015},
	{0xb38b, 0xd016},
	{0xb38c, 0xd017},
	{0xb38d, 0xd019},
	{0xb38e, 0xd01a},
	{0xb38f, 0xd01b},
	{0xb390, 0xd01c},
	{0xb391, 0xd01d},
	{0xb392, 0xd01e},
	{0xb393, 0xd01f},
	{0xb394, 0xd020},
	{0xb395, 0xd021},
	{0xb396, 0xd022},
	{0xb397, 0xd023},
	{0xb398, 0xd024},
	{0xb399, 0xd025},
	{0xb39a, 0xd026},
	{0xb39b, 0xd027},
	{0xb39c, 0xd028},
	{0xb39d, 0xd029},
	{0xb39e, 0xd02a},
	{0xb39f, 0xd02b},
	{0xb3a0, 0xd02c},
	{0xb3a1, 0xb05d},
	{0xb3a2, 0xb07c},
	{0xb3a3, 0xb07d},
	{0xb3a4, 0xb080},
	{0xb3a5, 0xb084},
	{0xb3a6, 0xb08c},
	{0xb3a7, 0xb08d},
	{0xb3a8, 0xb08f},
	{0xb3a9, 0xb091},
	{0xb3aa, 0xb098},
	{0xb3ab, 0xb099},
	{0xb3ac, 0xb09a},
	{0xb3ad, 0xb09c},
	{0xb3ae, 0xb09f},
	{0xb3af, 0xb0a0},
	{0xb3b0, 0xb0a1},
	{0xb3b1, 0xb0a2},
	{0xb3b2, 0xb0a8},
	{0xb3b3, 0xb0a9},
	{0xb3b4, 0xb0ab},
	{0xb3b5, 0xb0ac},
	{0xb3b6, 0xb0ad},
	{0xb3b7, 0xb0ae},
	{0xb3b8, 0xb0af},
	{0xb3b9, 0xb0b1},
	{0xb3ba, 0xb0b3},
	{0xb3bb, 0xb0b4},
	{0xb3bc, 0xb0b5},
	{0xb3bd, 0xb0b8},
	{0xb3be, 0xb0bc},
	{0xb3bf, 0xb0c4},
	{0xb3c0, 0xb0c5},
	{0xb3c1, 0xb0c7},
	{0xb3c2, 0xb0c8},
	{0xb3c3, 0xb0c9},
	{0xb3c4, 0xb0d0},
	{0xb3c5, 0xb0d1},
	{0xb3c6, 0xb0d4},
	{0xb3c7, 0xb0d8},
	{0xb3c8, 0xb0e0},
	{0xb3c9, 0xb0e5},
	{0xb3ca, 0xb108},
	{0xb3cb, 0xb109},
	{0xb3cc, 0xb10b},
	{0xb3cd, 0xb10c},
	{0xb3ce, 0xb110},
	{0xb3cf, 0xb112},
	{0xb3d0, 0xb113},
	{0xb3d1, 0xb118},
	{0xb3d2, 0xb119},
	{0xb3d3, 0xb11b},
	{0xb3d4, 0xb11c},
	{0xb3d5, 0xb11d},
	{0xb3d6, 0xb123},
	{0xb3d7, 0xb124},
	{0xb3d8, 0xb125},
	{0xb3d9, 0xb128},
	{0xb3da, 0xb12c},
	{0xb3db, 0xb134},
	{0xb3dc, 0xb135},
	{0xb3dd, 0xb137},
	{0xb3de, 0xb138},
	{0xb3df, 0xb139},
	{0xb3e0, 0xb140},
	{0xb3e1, 0xb141},
	{0xb3e2, 0xb144},
	{0xb3e3, 0xb148},
	{0xb3e4, 0xb150},
	{0xb3e5, 0xb151},
	{0xb3e6, 0xb154},
	{0xb3e7, 0xb155},
	{0xb3e8, 0xb158},
	{0xb3e9, 0xb15c},
	{0xb3ea, 0xb160},
	{0xb3eb, 0xb178},
	{0xb3ec, 0xb179},
	{0xb3ed, 0xb17c},
	{0xb3ee, 0xb180},
	{0xb3ef, 0xb182},
	{0xb3f0, 0xb188},
	{0xb3f1, 0xb189},
	{0xb3f2, 0xb18b},
	{0xb3f3, 0xb18d},
	{0xb3f4, 0xb192},
	{0xb3f5, 0xb193},
	{0xb3f6, 0xb194},
	{0xb3f7, 0xb198},
	{0xb3f8, 0xb19c},
	{0xb3f9, 0xb1a8},
	{0xb3fa, 0xb1cc},
	{0xb3fb, 0xb1d0},
	{0xb3fc, 0xb1d4},
	{0xb3fd, 0xb1dc},
	{0xb3fe, 0xb1dd},
	{0xb441, 0xd02e},
	{0xb442, 0xd02f},
	{0xb443, 0xd030},
	{0xb444, 0xd031},
	{0xb445, 0xd032},
	{0xb446, 0xd033},
	{0xb447, 0xd036},
	{0xb448, 0xd037},
	{0xb449, 0xd039},
	{0xb44a, 0xd03a},
	{0xb44b, 0xd03b},
	{0xb44c, 0xd03d},
	{0xb44d, 0xd03e},
	{0xb44e, 0xd03f},
	{0xb44f, 0xd040},
	{0xb450, 0xd041},
	{0xb451, 0xd042},
	{0xb452, 0xd043},
	{0xb453, 0xd046},
	{0xb454, 0xd048},
	{0xb455, 0xd04a},
	{0xb456, 0xd04b},
	{0xb457, 0xd04c},
	{0xb458, 0xd04d},
	{0xb459, 0xd04e},
	{0xb45a, 0xd04f},
	{0xb461, 0xd051},
	{0xb462, 0xd052},
	{0xb463, 0xd053},
	{0xb464, 0xd055},
	{0xb465, 0xd056},
	{0xb466, 0xd057},
	{0xb467, 0xd059},
	{0xb468, 0xd05a},
	{0xb469, 0xd05b},
	{0xb46a, 0xd05c},
	{0xb46b, 0xd05d},
	{0xb46c, 0xd05e},
	{0xb46d, 0xd05f},
	{0xb46e, 0xd061},
	{0xb46f, 0xd062},
	{0xb470, 0xd063},
	{0xb471, 0xd064},
	{0xb472, 0xd065},
	{0xb473, 0xd066},
	{0xb474, 0xd067},
	{0xb475, 0xd068},
	{0xb476, 0xd069},
	{0xb477, 0xd06a},
	{0xb478, 0xd06b},
	{0xb479, 0xd06e},
	{0xb47a, 0xd06f},
	{0xb481, 0xd071},
	{0xb482, 0xd072},
	{0xb483, 0xd073},
	{0xb484, 0xd075},
	{0xb485, 0xd076},
	{0xb486, 0xd077},
	{0xb487, 0xd078},
	{0xb488, 0xd079},
	{0xb489, 0xd07a},
	{0xb48a, 0xd07b},
	{0xb48b, 0xd07e},
	{0xb48c, 0xd07f},
	{0xb48d, 0xd080},
	{0xb48e, 0xd082},
	{0xb48f, 0xd083},
	{0xb490, 0xd084},
	{0xb491, 0xd085},
	{0xb492, 0xd086},
	{0xb493, 0xd087},
	{0xb494, 0xd088},
	{0xb495, 0xd089},
	{0xb496, 0xd08a},
	{0xb497, 0xd08b},
	{0xb498, 0xd08c},
	{0xb499, 0xd08d},
	{0xb49a, 0xd08e},
	{0xb49b, 0xd08f},
	{0xb49c, 0xd090},
	{0xb49d, 0xd091},
	{0xb49e, 0xd092},
	{0xb49f, 0xd093},
	{0xb4a0, 0xd094},
	{0xb4a1, 0xb1df},
	{0xb4a2, 0xb1e8},
	{0xb4a3, 0xb1e9},
	{0xb4a4, 0xb1ec},
	{0xb4a5, 0xb1f0},
	{0xb4a6, 0xb1f9},
	{0xb4a7, 0xb1fb},
	{0xb4a8, 0xb1fd},
	{0xb4a9, 0xb204},
	{0xb4aa, 0xb205},
	{0xb4ab, 0xb208},
	{0xb4ac, 0xb20b},
	{0xb4ad, 0xb20c},
	{0xb4ae, 0xb214},
	{0xb4af, 0xb215},
	{0xb4b0, 0xb217},
	{0xb4b1, 0xb219},
	{0xb4b2, 0xb220},
	{0xb4b3, 0xb234},
	{0xb4b4, 0xb23c},
	{0xb4b5, 0xb258},
	{0xb4b6, 0xb25c},
	{0xb4b7, 0xb260},
	{0xb4b8, 0xb268},
	{0xb4b9, 0xb269},
	{0xb4ba, 0xb274},
	{0xb4bb, 0xb275},
	{0xb4bc, 0xb27c},
	{0xb4bd, 0xb284},
	{0xb4be, 0xb285},
	{0xb4bf, 0xb289},
	{0xb4c0, 0xb290},
	{0xb4c1, 0xb291},
	{0xb4c2, 0xb294},
	{0xb4c3, 0xb298},
	{0xb4c4, 0xb299},
	{0xb4c5, 0xb29a},
	{0xb4c6, 0xb2a0},
	{0xb4c7, 0xb2a1},
	{0xb4c8, 0xb2a3},
	{0xb4c9, 0xb2a5},
	{0xb4ca, 0xb2a6},
	{0xb4cb, 0xb2aa},
	{0xb4cc, 0xb2ac},
	{0xb4cd, 0xb2b0},
	{0xb4ce, 0xb2b4},
	{0xb4cf, 0xb2c8},
	{0xb4d0, 0xb2c9},
	{0xb4d1, 0xb2cc},
	{0xb4d2, 0xb2d0},
	{0xb4d3, 0xb2d2},
	{0xb4d4, 0xb2d8},
	{0xb4d5, 0xb2d9},
	{0xb4d6, 0xb2db},
	{0xb4d7, 0xb2dd},
	{0xb4d8, 0xb2e2},
	{0xb4d9, 0xb2e4},
	{0xb4da, 0xb2e5},
	{0xb4db, 0xb2e6},
	{0xb4dc, 0xb2e8},
	{0xb4dd, 0xb2eb},
	{0xb4de, 0xb2ec},
	{0xb4df, 0xb2ed},
	{0xb4e0, 0xb2ee},
	{0xb4e1, 0xb2ef},
	{0xb4e2, 0xb2f3},
	{0xb4e3, 0xb2f4},
	{0xb4e4, 0xb2f5},
	{0xb4e5, 0xb2f7},
	{0xb4e6, 0xb2f8},
	{0xb4e7, 0xb2f9},
	{0xb4e8, 0xb2fa},
	{0xb4e9, 0xb2fb},
	{0xb4ea, 0xb2ff},
	{0xb4eb, 0xb300},
	{0xb4ec, 0xb301},
	{0xb4ed, 0xb304},
	{0xb4ee, 0xb308},
	{0xb4ef, 0xb310},
	{0xb4f0, 0xb311},
	{0xb4f1, 0xb313},
	{0xb4f2, 0xb314},
	{0xb4f3, 0xb315},
	{0xb4f4, 0xb31c},
	{0xb4f5, 0xb354},
	{0xb4f6, 0xb355},
	{0xb4f7, 0xb356},
	{0xb4f8, 0xb358},
	{0xb4f9, 0xb35b},
	{0xb4fa, 0xb35c},
	{0xb4fb, 0xb35e},
	{0xb4fc, 0xb35f},
	{0xb4fd, 0xb364},
	{0xb4fe, 0xb365},
	{0xb541, 0xd095},
	{0xb542, 0xd096},
	{0xb543, 0xd097},
	{0xb544, 0xd098},
	{0xb545, 0xd099},
	{0xb546, 0xd09a},
	{0xb547, 0xd09b},
	{0xb548, 0xd09c},
	{0xb549, 0xd09d},
	{0xb54a, 0xd09e},
	{0xb54b, 0xd09f},
	{0xb54c, 0xd0a0},
	{0xb54d, 0xd0a1},
	{0xb54e, 0xd0a2},
	{0xb54f, 0xd0a3},
	{0xb550, 0xd0a6},
	{0xb551, 0xd0a7},
	{0xb552, 0xd0a9},
	{0xb553, 0xd0aa},
	{0xb554, 0xd0ab},
	{0xb555, 0xd0ad},
	{0xb556, 0xd0ae},
	{0xb557, 0xd0af},
	{0xb558, 0xd0b0},
	{0xb559, 0xd0b1},
	{0xb55a, 0xd0b2},
	{0xb561, 0xd0b3},
	{0xb562, 0xd0b6},
	{0xb563, 0xd0b8},
	{0xb564, 0xd0ba},
	{0xb565, 0xd0bb},
	{0xb566, 0xd0bc},
	{0xb567, 0xd0bd},
	{0xb568, 0xd0be},
	{0xb569, 0xd0bf},
	{0xb56a, 0xd0c2},
	{0xb56b, 0xd0c3},
	{0xb56c, 0xd0c5},
	{0xb56d, 0xd0c6},
	{0xb56e, 0xd0c7},
	{0xb56f, 0xd0ca},
	{0xb570, 0xd0cb},
	{0xb571, 0xd0cc},
	{0xb572, 0xd0cd},
	{0xb573, 0xd0ce},
	{0xb574, 0xd0cf},
	{0xb575, 0xd0d2},
	{0xb576, 0xd0d6},
	{0xb577, 0xd0d7},
	{0xb578, 0xd0d8},
	{0xb579, 0xd0d9},
	{0xb57a, 0xd0da},
	{0xb581, 0xd0db},
	{0xb582, 0xd0de},
	{0xb583, 0xd0df},
	{0xb584, 0xd0e1},
	{0xb585, 0xd0e2},
	{0xb586, 0xd0e3},
	{0xb587, 0xd0e5},
	{0xb588, 0xd0e6},
	{0xb589, 0xd0e7},
	{0xb58a, 0xd0e8},
	{0xb58b, 0xd0e9},
	{0xb58c, 0xd0ea},
	{0xb58d, 0xd0eb},
	{0xb58e, 0xd0ee},
	{0xb58f, 0xd0f2},
	{0xb590, 0xd0f3},
	{0xb591, 0xd0f4},
	{0xb592, 0xd0f5},
	{0xb593, 0xd0f6},
	{0xb594, 0xd0f7},
	{0xb595, 0xd0f9},
	{0xb596, 0xd0fa},
	{0xb597, 0xd0fb},
	{0xb598, 0xd0fc},
	{0xb599, 0xd0fd},
	{0xb59a, 0xd0fe},
	{0xb59b, 0xd0ff},
	{0xb59c, 0xd100},
	{0xb59d, 0xd101},
	{0xb59e, 0xd102},
	{0xb59f, 0xd103},
	{0xb5a0, 0xd104},
	{0xb5a1, 0xb367},
	{0xb5a2, 0xb369},
	{0xb5a3, 0xb36b},
	{0xb5a4, 0xb36e},
	{0xb5a5, 0xb370},
	{0xb5a6, 0xb371},
	{0xb5a7, 0xb374},
	{0xb5a8, 0xb378},
	{0xb5a9, 0xb380},
	{0xb5aa, 0xb381},
	{0xb5ab, 0xb383},
	{0xb5ac, 0xb384},
	{0xb5ad, 0xb385},
	{0xb5ae, 0xb38c},
	{0xb5af, 0xb390},
	{0xb5b0, 0xb394},
	{0xb5b1, 0xb3a0},
	{0xb5b2, 0xb3a1},
	{0xb5b3, 0xb3a8},
	{0xb5b4, 0xb3ac},
	{0xb5b5, 0xb3c4},
	{0xb5b6, 0xb3c5},
	{0xb5b7, 0xb3c8},
	{0xb5b8, 0xb3cb},
	{0xb5b9, 0xb3cc},
	{0xb5ba, 0xb3ce},
	{0xb5bb, 0xb3d0},
	{0xb5bc, 0xb3d4},
	{0xb5bd, 0xb3d5},
	{0xb5be, 0xb3d7},
	{0xb5bf, 0xb3d9},
	{0xb5c0, 0xb3db},
	{0xb5c1, 0xb3dd},
	{0xb5c2, 0xb3e0},
	{0xb5c3, 0xb3e4},
	{0xb5c4, 0xb3e8},
	{0xb5c5, 0xb3fc},
	{0xb5c6, 0xb410},
	{0xb5c7, 0xb418},
	{0xb5c8, 0xb41c},
	{0xb5c9, 0xb420},
	{0xb5ca, 0xb428},
	{0xb5cb, 0xb429},
	{0xb5cc, 0xb42b},
	{0xb5cd, 0xb434},
	{0xb5ce, 0xb450},
	{0xb5cf, 0xb451},
	{0xb5d0, 0xb454},
	{0xb5d1, 0xb458},
	{0xb5d2, 0xb460},
	{0xb5d3, 0xb461},
	{0xb5d4, 0xb463},
	{0xb5d5, 0xb465},
	{0xb5d6, 0xb46c},
	{0xb5d7, 0xb480},
	{0xb5d8, 0xb488},
	{0xb5d9, 0xb49d},
	{0xb5da, 0xb4a4},
	{0xb5db, 0xb4a8},
	{0xb5dc, 0xb4ac},
	{0xb5dd, 0xb4b5},
	{0xb5de, 0xb4b7},
	{0xb5df, 0xb4b9},
	{0xb5e0, 0xb4c0},
	{0xb5e1, 0xb4c4},
	{0xb5e2, 0xb4c8},
	{0xb5e3, 0xb4d0},
	{0xb5e4, 0xb4d5},
	{0xb5e5, 0xb4dc},
	{0xb5e6, 0xb4dd},
	{0xb5e7, 0xb4e0},
	{0xb5e8, 0xb4e3},
	{0xb5e9, 0xb4e4},
	{0xb5ea, 0xb4e6},
	{0xb5eb, 0xb4ec},
	{0xb5ec, 0xb4ed},
	{0xb5ed, 0xb4ef},
	{0xb5ee, 0xb4f1},
	{0xb5ef, 0xb4f8},
	{0xb5f0, 0xb514},
	{0xb5f1, 0xb515},
	{0xb5f2, 0xb518},
	{0xb5f3, 0xb51b},
	{0xb5f4, 0xb51c},
	{0xb5f5, 0xb524},
	{0xb5f6, 0xb525},
	{0xb5f7, 0xb527},
	{0xb5f8, 0xb528},
	{0xb5f9, 0xb529},
	{0xb5fa, 0xb52a},
	{0xb5fb, 0xb530},
	{0xb5fc, 0xb531},
	{0xb5fd, 0xb534},
	{0xb5fe, 0xb538},
	{0xb641, 0xd105},
	{0xb642, 0xd106},
	{0xb643, 0xd107},
	{0xb644, 0xd108},
	{0xb645, 0xd109},
	{0xb646, 0xd10a},
	{0xb647, 0xd10b},
	{0xb648, 0xd10c},
	{0xb649, 0xd10e},
	{0xb64a, 0xd10f},
	{0xb64b, 0xd110},
	{0xb64c, 0xd111},
	{0xb64d, 0xd112},
	{0xb64e, 0xd113},
	{0xb64f, 0xd114},
	{0xb650, 0xd115},
	{0xb651, 0xd116},
	{0xb652, 0xd117},
	{0xb653, 0xd118},
	{0xb654, 0xd119},
	{0xb655, 0xd11a},
	{0xb656, 0xd11b},
	{0xb657, 0xd11c},
	{0xb658, 0xd11d},
	{0xb659, 0xd11e},
	{0xb65a, 0xd11f},
	{0xb661, 0xd120},
	{0xb662, 0xd121},
	{0xb663, 0xd122},
	{0xb664, 0xd123},
	{0xb665, 0xd124},
	{0xb666, 0xd125},
	{0xb667, 0xd126},
	{0xb668, 0xd127},
	{0xb669, 0xd128},
	{0xb66a, 0xd129},
	{0xb66b, 0xd12a},
	{0xb66c, 0xd12b},
	{0xb66d, 0xd12c},
	{0xb66e, 0xd12d},
	{0xb66f, 0xd12e},
	{0xb670, 0xd12f},
	{0xb671, 0xd132},
	{0xb672, 0xd133},
	{0xb673, 0xd135},
	{0xb674, 0xd136},
	{0xb675, 0xd137},
	{0xb676, 0xd139},
	{0xb677, 0xd13b},
	{0xb678, 0xd13c},
	{0xb679, 0xd13d},
	{0xb67a, 0xd13e},
	{0xb681, 0xd13f},
	{0xb682, 0xd142},
	{0xb683, 0xd146},
	{0xb684, 0xd147},
	{0xb685, 0xd148},
	{0xb686, 0xd149},
	{0xb687, 0xd14a},
	{0xb688, 0xd14b},
	{0xb689, 0xd14e},
	{0xb68a, 0xd14f},
	{0xb68b, 0xd151},
	{0xb68c, 0xd152},
	{0xb68d, 0xd153},
	{0xb68e, 0xd155},
	{0xb68f, 0xd156},
	{0xb690, 0xd157},
	{0xb691, 0xd158},
	{0xb692, 0xd159},
	{0xb693, 0xd15a},
	{0xb694, 0xd15b},
	{0xb695, 0xd15e},
	{0xb696, 0xd160},
	{0xb697, 0xd162},
	{0xb698, 0xd163},
	{0xb699, 0xd164},
	{0xb69a, 0xd165},
	{0xb69b, 0xd166},
	{0xb69c, 0xd167},
	{0xb69d, 0xd169},
	{0xb69e, 0xd16a},
	{0xb69f, 0xd16b},
	{0xb6a0, 0xd16d},
	{0xb6a1, 0xb540},
	{0xb6a2, 0xb541},
	{0xb6a3, 0xb543},
	{0xb6a4, 0xb544},
	{0xb6a5, 0xb545},
	{0xb6a6, 0xb54b},
	{0xb6a7, 0xb54c},
	{0xb6a8, 0xb54d},
	{0xb6a9, 0xb550},
	{0xb6aa, 0xb554},
	{0xb6ab, 0xb55c},
	{0xb6ac, 0xb55d},
	{0xb6ad, 0xb55f},
	{0xb6ae, 0xb560},
	{0xb6af, 0xb561},
	{0xb6b0, 0xb5a0},
	{0xb6b1, 0xb5a1},
	{0xb6b2, 0xb5a4},
	{0xb6b3, 0xb5a8},
	{0xb6b4, 0xb5aa},
	{0xb6b5, 0xb5ab},
	{0xb6b6, 0xb5b0},
	{0xb6b7, 0xb5b1},
	{0xb6b8, 0xb5b3},
	{0xb6b9, 0xb5b4},
	{0xb6ba, 0xb5b5},
	{0xb6bb, 0xb5bb},
	{0xb6bc, 0xb5bc},
	{0xb6bd, 0xb5bd},
	{0xb6be, 0xb5c0},
	{0xb6bf, 0xb5c4},
	{0xb6c0, 0xb5cc},
	{0xb6c1, 0xb5cd},
	{0xb6c2, 0xb5cf},
	{0xb6c3, 0xb5d0},
	{0xb6c4, 0xb5d1},
	{0xb6c5, 0xb5d8},
	{0xb6c6, 0xb5ec},
	{0xb6c7, 0xb610},
	{0xb6c8, 0xb611},
	{0xb6c9, 0xb614},
	{0xb6ca, 0xb618},
	{0xb6cb, 0xb625},
	{0xb6cc, 0xb62c},
	{0xb6cd, 0xb634},
	{0xb6ce, 0xb648},
	{0xb6cf, 0xb664},
	{0xb6d0, 0xb668},
	{0xb6d1, 0xb69c},
	{0xb6d2, 0xb69d},
	{0xb6d3, 0xb6a0},
	{0xb6d4, 0xb6a4},
	{0xb6d5, 0xb6ab},
	{0xb6d6, 0xb6ac},
	{0xb6d7, 0xb6b1},
	{0xb6d8, 0xb6d4},
	{0xb6d9, 0xb6f0},
	{0xb6da, 0xb6f4},
	{0xb6db, 0xb6f8},
	{0xb6dc, 0xb700},
	{0xb6dd, 0xb701},
	{0xb6de, 0xb705},
	{0xb6df, 0xb728},
	{0xb6e0, 0xb729},
	{0xb6e1, 0xb72c},
	{0xb6e2, 0xb72f},
	{0xb6e3, 0xb730},
	{0xb6e4, 0xb738},
	{0xb6e5, 0xb739},
	{0xb6e6, 0xb73b},
	{0xb6e7, 0xb744},
	{0xb6e8, 0xb748},
	{0xb6e9, 0xb74c},
	{0xb6ea, 0xb754},
	{0xb6eb, 0xb755},
	{0xb6ec, 0xb760},
	{0xb6ed, 0xb764},
	{0xb6ee, 0xb768},
	{0xb6ef, 0xb770},
	{0xb6f0, 0xb771},
	{0xb6f1, 0xb773},
	{0xb6f2, 0xb775},
	{0xb6f3, 0xb77c},
	{0xb6f4, 0xb77d},
	{0xb6f5, 0xb780},
	{0xb6f6, 0xb784},
	{0xb6f7, 0xb78c},
	{0xb6f8, 0xb78d},
	{0xb6f9, 0xb78f},
	{0xb6fa, 0xb790},
	{0xb6fb, 0xb791},
	{0xb6fc, 0xb792},
	{0xb6fd, 0xb796},
	{0xb6fe, 0xb797},
	{0xb741, 0xd16e},
	{0xb742, 0xd16f},
	{0xb743, 0xd170},
	{0xb744, 0xd171},
	{0xb745, 0xd172},
	{0xb746, 0xd173},
	{0xb747, 0xd174},
	{0xb748, 0xd175},
	{0xb749, 0xd176},
	{0xb74a, 0xd177},
	{0xb74b, 0xd178},
	{0xb74c, 0xd179},
	{0xb74d, 0xd17a},
	{0xb74e, 0xd17b},
	{0xb74f, 0xd17d},
	{0xb750, 0xd17e},
	{0xb751, 0xd17f},
	{0xb752, 0xd180},
	{0xb753, 0xd181},
	{0xb754, 0xd182},
	{0xb755, 0xd183},
	{0xb756, 0xd185},
	{0xb757, 0xd186},
	{0xb758, 0xd187},
	{0xb759, 0xd189},
	{0xb75a, 0xd18a},
	{0xb761, 0xd18b},
	{0xb762, 0xd18c},
	{0xb763, 0xd18d},
	{0xb764, 0xd18e},
	{0xb765, 0xd18f},
	{0xb766, 0xd190},
	{0xb767, 0xd191},
	{0xb768, 0xd192},
	{0xb769, 0xd193},
	{0xb76a, 0xd194},
	{0xb76b, 0xd195},
	{0xb76c, 0xd196},
	{0xb76d, 0xd197},
	{0xb76e, 0xd198},
	{0xb76f, 0xd199},
	{0xb770, 0xd19a},
	{0xb771, 0xd19b},
	{0xb772, 0xd19c},
	{0xb773, 0xd19d},
	{0xb774, 0xd19e},
	{0xb775, 0xd19f},
	{0xb776, 0xd1a2},
	{0xb777, 0xd1a3},
	{0xb778, 0xd1a5},
	{0xb779, 0xd1a6},
	{0xb77a, 0xd1a7},
	{0xb781, 0xd1a9},
	{0xb782, 0xd1aa},
	{0xb783, 0xd1ab},
	{0xb784, 0xd1ac},
	{0xb785, 0xd1ad},
	{0xb786, 0xd1ae},
	{0xb787, 0xd1af},
	{0xb788, 0xd1b2},
	{0xb789, 0xd1b4},
	{0xb78a, 0xd1b6},
	{0xb78b, 0xd1b7},
	{0xb78c, 0xd1b8},
	{0xb78d, 0xd1b9},
	{0xb78e, 0xd1bb},
	{0xb78f, 0xd1bd},
	{0xb790, 0xd1be},
	{0xb791, 0xd1bf},
	{0xb792, 0xd1c1},
	{0xb793, 0xd1c2},
	{0xb794, 0xd1c3},
	{0xb795, 0xd1c4},
	{0xb796, 0xd1c5},
	{0xb797, 0xd1c6},
	{0xb798, 0xd1c7},
	{0xb799, 0xd1c8},
	{0xb79a, 0xd1c9},
	{0xb79b, 0xd1ca},
	{0xb79c, 0xd1cb},
	{0xb79d, 0xd1cc},
	{0xb79e, 0xd1cd},
	{0xb79f, 0xd1ce},
	{0xb7a0, 0xd1cf},
	{0xb7a1, 0xb798},
	{0xb7a2, 0xb799},
	{0xb7a3, 0xb79c},
	{0xb7a4, 0xb7a0},
	{0xb7a5, 0xb7a8},
	{0xb7a6, 0xb7a9},
	{0xb7a7, 0xb7ab},
	{0xb7a8, 0xb7ac},
	{0xb7a9, 0xb7ad},
	{0xb7aa, 0xb7b4},
	{0xb7ab, 0xb7b5},
	{0xb7ac, 0xb7b8},
	{0xb7ad, 0xb7c7},
	{0xb7ae, 0xb7c9},
	{0xb7af, 0xb7ec},
	{0xb7b0, 0xb7ed},
	{0xb7b1, 0xb7f0},
	{0xb7b2, 0xb7f4},
	{0xb7b3, 0xb7fc},
	{0xb7b4, 0xb7fd},
	{0xb7b5, 0xb7ff},
	{0xb7b6, 0xb800},
	{0xb7b7, 0xb801},
	{0xb7b8, 0xb807},
	{0xb7b9, 0xb808},
	{0xb7ba, 0xb809},
	{0xb7bb, 0xb80c},
	{0xb7bc, 0xb810},
	{0xb7bd, 0xb818},
	{0xb7be, 0xb819},
	{0xb7bf, 0xb81b},
	{0xb7c0, 0xb81d},
	{0xb7c1, 0xb824},
	{0xb7c2, 0xb825},
	{0xb7c3, 0xb828},
	{0xb7c4, 0xb82c},
	{0xb7c5, 0xb834},
	{0xb7c6, 0xb835},
	{0xb7c7, 0xb837},
	{0xb7c8, 0xb838},
	{0xb7c9, 0xb839},
	{0xb7ca, 0xb840},
	{0xb7cb, 0xb844},
	{0xb7cc, 0xb851},
	{0xb7cd, 0xb853},
	{0xb7ce, 0xb85c},
	{0xb7cf, 0xb85d},
	{0xb7d0, 0xb860},
	{0xb7d1, 0xb864},
	{0xb7d2, 0xb86c},
	{0xb7d3, 0xb86d},
	{0xb7d4, 0xb86f},
	{0xb7d5, 0xb871},
	{0xb7d6, 0xb878},
	{0xb7d7, 0xb87c},
	{0xb7d8, 0xb88d},
	{0xb7d9, 0xb8a8},
	{0xb7da, 0xb8b0},
	{0xb7db, 0xb8b4},
	{0xb7dc, 0xb8b8},
	{0xb7dd, 0xb8c0},
	{0xb7de, 0xb8c1},
	{0xb7df, 0xb8c3},
	{0xb7e0, 0xb8c5},
	{0xb7e1, 0xb8cc},
	{0xb7e2, 0xb8d0},
	{0xb7e3, 0xb8d4},
	{0xb7e4, 0xb8dd},
	{0xb7e5, 0xb8df},
	{0xb7e6, 0xb8e1},
	{0xb7e7, 0xb8e8},
	{0xb7e8, 0xb8e9},
	{0xb7e9, 0xb8ec},
	{0xb7ea, 0xb8f0},
	{0xb7eb, 0xb8f8},
	{0xb7ec, 0xb8f9},
	{0xb7ed, 0xb8fb},
	{0xb7ee, 0xb8fd},
	{0xb7ef, 0xb904},
	{0xb7f0, 0xb918},
	{0xb7f1, 0xb920},
	{0xb7f2, 0xb93c},
	{0xb7f3, 0xb93d},
	{0xb7f4, 0xb940},
	{0xb7f5, 0xb944},
	{0xb7f6, 0xb94c},
	{0xb7f7, 0xb94f},
	{0xb7f8, 0xb951},
	{0xb7f9, 0xb958},
	{0xb7fa, 0xb959},
	{0xb7fb, 0xb95c},
	{0xb7fc, 0xb960},
	{0xb7fd, 0xb968},
	{0xb7fe, 0xb969},
	{0xb841, 0xd1d0},
	{0xb842, 0xd1d1},
	{0xb843, 0xd1d2},
	{0xb844, 0xd1d3},
	{0xb845, 0xd1d4},
	{0xb846, 0xd1d5},
	{0xb847, 0xd1d6},
	{0xb848, 0xd1d7},
	{0xb849, 0xd1d9},
	{0xb84a, 0xd1da},
	{0xb84b, 0xd1db},
	{0xb84c, 0xd1dc},
	{0xb84d, 0xd1dd},
	{0xb84e, 0xd1de},
	{0xb84f, 0xd1df},
	{0xb850, 0xd1e0},
	{0xb851, 0xd1e1},
	{0xb852, 0xd1e2},
	{0xb853, 0xd1e3},
	{0xb854, 0xd1e4},
	{0xb855, 0xd1e5},
	{0xb856, 0xd1e6},
	{0xb857, 0xd1e7},
	{0xb858, 0xd1e8},
	{0xb859, 0xd1e9},
	{0xb85a, 0xd1ea},
	{0xb861, 0xd1eb},
	{0xb862, 0xd1ec},
	{0xb863, 0xd1ed},
	{0xb864, 0xd1ee},
	{0xb865, 0xd1ef},
	{0xb866, 0xd1f0},
	{0xb867, 0xd1f1},
	{0xb868, 0xd1f2},
	{0xb869, 0xd1f3},
	{0xb86a, 0xd1f5},
	{0xb86b, 0xd1f6},
	{0xb86c, 0xd1f7},
	{0xb86d, 0xd1f9},
	{0xb86e, 0xd1fa},
	{0xb86f, 0xd1fb},
	{0xb870, 0xd1fc},
	{0xb871, 0xd1fd},
	{0xb872, 0xd1fe},
	{0xb873, 0xd1ff},
	{0xb874, 0xd200},
	{0xb875, 0xd201},
	{0xb876, 0xd202},
	{0xb877, 0xd203},
	{0xb878, 0xd204},
	{0xb879, 0xd205},
	{0xb87a, 0xd206},
	{0xb881, 0xd208},
	{0xb882, 0xd20a},
	{0xb883, 0xd20b},
	{0xb884, 0xd20c},
	{0xb885, 0xd20d},
	{0xb886, 0xd20e},
	{0xb887, 0xd20f},
	{0xb888, 0xd211},
	{0xb889, 0xd212},
	{0xb88a, 0xd213},
	{0xb88b, 0xd214},
	{0xb88c, 0xd215},
	{0xb88d, 0xd216},
	{0xb88e, 0xd217},
	{0xb88f, 0xd218},
	{0xb890, 0xd219},
	{0xb891, 0xd21a},
	{0xb892, 0xd21b},
	{0xb893, 0xd21c},
	{0xb894, 0xd21d},
	{0xb895, 0xd21e},
	{0xb896, 0xd21f},
	{0xb897, 0xd220},
	{0xb898, 0xd221},
	{0xb899, 0xd222},
	{0xb89a, 0xd223},
	{0xb89b, 0xd224},
	{0xb89c, 0xd225},
	{0xb89d, 0xd226},
	{0xb89e, 0xd227},
	{0xb89f, 0xd228},
	{0xb8a0, 0xd229},
	{0xb8a1, 0xb96b},
	{0xb8a2, 0xb96d},
	{0xb8a3, 0xb974},
	{0xb8a4, 0xb975},
	{0xb8a5, 0xb978},
	{0xb8a6, 0xb97c},
	{0xb8a7, 0xb984},
	{0xb8a8, 0xb985},
	{0xb8a9, 0xb987},
	{0xb8aa, 0xb989},
	{0xb8ab, 0xb98a},
	{0xb8ac, 0xb98d},
	{0xb8ad, 0xb98e},
	{0xb8ae, 0xb9ac},
	{0xb8af, 0xb9ad},
	{0xb8b0, 0xb9b0},
	{0xb8b1, 0xb9b4},
	{0xb8b2, 0xb9bc},
	{0xb8b3, 0xb9bd},
	{0xb8b4, 0xb9bf},
	{0xb8b5, 0xb9c1},
	{0xb8b6, 0xb9c8},
	{0xb8b7, 0xb9c9},
	{0xb8b8, 0xb9cc},
	{0xb8b9, 0xb9ce},
	{0xb8ba, 0xb9cf},
	{0xb8bb, 0xb9d0},
	{0xb8bc, 0xb9d1},
	{0xb8bd, 0xb9d2},
	{0xb8be, 0xb9d8},
	{0xb8bf, 0xb9d9},
	{0xb8c0, 0xb9db},
	{0xb8c1, 0xb9dd},
	{0xb8c2, 0xb9de},
	{0xb8c3, 0xb9e1},
	{0xb8c4, 0xb9e3},
	{0xb8c5, 0xb9e4},
	{0xb8c6, 0xb9e5},
	{0xb8c7, 0xb9e8},
	{0xb8c8, 0xb9ec},
	{0xb8c9, 0xb9f4},
	{0xb8ca, 0xb9f5},
	{0xb8cb, 0xb9f7},
	{0xb8cc, 0xb9f8},
	{0xb8cd, 0xb9f9},
	{0xb8ce, 0xb9fa},
	{0xb8cf, 0xba00},
	{0xb8d0, 0xba01},
	{0xb8d1, 0xba08},
	{0xb8d2, 0xba15},
	{0xb8d3, 0xba38},
	{0xb8d4, 0xba39},
	{0xb8d5, 0xba3c},
	{0xb8d6, 0xba40},
	{0xb8d7, 0xba42},
	{0xb8d8, 0xba48},
	{0xb8d9, 0xba49},
	{0xb8da, 0xba4b},
	{0xb8db, 0xba4d},
	{0xb8dc, 0xba4e},
	{0xb8dd, 0xba53},
	{0xb8de, 0xba54},
	{0xb8df, 0xba55},
	{0xb8e0, 0xba58},
	{0xb8e1, 0xba5c},
	{0xb8e2, 0xba64},
	{0xb8e3, 0xba65},
	{0xb8e4, 0xba67},
	{0xb8e5, 0xba68},
	{0xb8e6, 0xba69},
	{0xb8e7, 0xba70},
	{0xb8e8, 0xba71},
	{0xb8e9, 0xba74},
	{0xb8ea, 0xba78},
	{0xb8eb, 0xba83},
	{0xb8ec, 0xba84},
	{0xb8ed, 0xba85},
	{0xb8ee, 0xba87},
	{0xb8ef, 0xba8c},
	{0xb8f0, 0xbaa8},
	{0xb8f1, 0xbaa9},
	{0xb8f2, 0xbaab},
	{0xb8f3, 0xbaac},
	{0xb8f4, 0xbab0},
	{0xb8f5, 0xbab2},
	{0xb8f6, 0xbab8},
	{0xb8f7, 0xbab9},
	{0xb8f8, 0xbabb},
	{0xb8f9, 0xbabd},
	{0xb8fa, 0xbac4},
	{0xb8fb, 0xbac8},
	{0xb8fc, 0xbad8},
	{0xb8fd, 0xbad9},
	{0xb8fe, 0xbafc},
	{0xb941, 0xd22a},
	{0xb942, 0xd22b},
	{0xb943, 0xd22e},
	{0xb944, 0xd22f},
	{0xb945, 0xd231},
	{0xb946, 0xd232},
	{0xb947, 0xd233},
	{0xb948, 0xd235},
	{0xb949, 0xd236},
	{0xb94a, 0xd237},
	{0xb94b, 0xd238},
	{0xb94c, 0xd239},
	{0xb94d, 0xd23a},
	{0xb94e, 0xd23b},
	{0xb94f, 0xd23e},
	{0xb950, 0xd240},
	{0xb951, 0xd242},
	{0xb952, 0xd243},
	{0xb953, 0xd244},
	{0xb954, 0xd245},
	{0xb955, 0xd246},
	{0xb956, 0xd247},
	{0xb957, 0xd249},
	{0xb958, 0xd24a},
	{0xb959, 0xd24b},
	{0xb95a, 0xd24c},
	{0xb961, 0xd24d},
	{0xb962, 0xd24e},
	{0xb963, 0xd24f},
	{0xb964, 0xd250},
	{0xb965, 0xd251},
	{0xb966, 0xd252},
	{0xb967, 0xd253},
	{0xb968, 0xd254},
	{0xb969, 0xd255},
	{0xb96a, 0xd256},
	{0xb96b, 0xd257},
	{0xb96c, 0xd258},
	{0xb96d, 0xd259},
	{0xb96e, 0xd25a},
	{0xb96f, 0xd25b},
	{0xb970, 0xd25d},
	{0xb971, 0xd25e},
	{0xb972, 0xd25f},
	{0xb973, 0xd260},
	{0xb974, 0xd261},
	{0xb975, 0xd262},
	{0xb976, 0xd263},
	{0xb977, 0xd265},
	{0xb978, 0xd266},
	{0xb979, 0xd267},
	{0xb97a, 0xd268},
	{0xb981, 0xd269},
	{0xb982, 0xd26a},
	{0xb983, 0xd26b},
	{0xb984, 0xd26c},
	{0xb985, 0xd26d},
	{0xb986, 0xd26e},
	{0xb987, 0xd26f},
	{0xb988, 0xd270},
	{0xb989, 0xd271},
	{0xb98a, 0xd272},
	{0xb98b, 0xd273},
	{0xb98c, 0xd274},
	{0xb98d, 0xd275},
	{0xb98e, 0xd276},
	{0xb98f, 0xd277},
	{0xb990, 0xd278},
	{0xb991, 0xd279},
	{0xb992, 0xd27a},
	{0xb993, 0xd27b},
	{0xb994, 0xd27c},
	{0xb995, 0xd27d},
	{0xb996, 0xd27e},
	{0xb997, 0xd27f},
	{0xb998, 0xd282},
	{0xb999, 0xd283},
	{0xb99a, 0xd285},
	{0xb99b, 0xd286},
	{0xb99c, 0xd287},
	{0xb99d, 0xd289},
	{0xb99e, 0xd28a},
	{0xb99f, 0xd28b},
	{0xb9a0, 0xd28c},
	{0xb9a1, 0xbb00},
	{0xb9a2, 0xbb04},
	{0xb9a3, 0xbb0d},
	{0xb9a4, 0xbb0f},
	{0xb9a5, 0xbb11},
	{0xb9a6, 0xbb18},
	{0xb9a7, 0xbb1c},
	{0xb9a8, 0xbb20},
	{0xb9a9, 0xbb29},
	{0xb9aa, 0xbb2b},
	{0xb9ab, 0xbb34},
	{0xb9ac, 0xbb35},
	{0xb9ad, 0xbb36},
	{0xb9ae, 0xbb38},
	{0xb9af, 0xbb3b},
	{0xb9b0, 0xbb3c},
	{0xb9b1, 0xbb3d},
	{0xb9b2, 0xbb3e},
	{0xb9b3, 0xbb44},
	{0xb9b4, 0xbb45},
	{0xb9b5, 0xbb47},
	{0xb9b6, 0xbb49},
	{0xb9b7, 0xbb4d},
	{0xb9b8, 0xbb4f},
	{0xb9b9, 0xbb50},
	{0xb9ba, 0xbb54},
	{0xb9bb, 0xbb58},
	{0xb9bc, 0xbb61},
	{0xb9bd, 0xbb63},
	{0xb9be, 0xbb6c},
	{0xb9bf, 0xbb88},
	{0xb9c0, 0xbb8c},
	{0xb9c1, 0xbb90},
	{0xb9c2, 0xbba4},
	{0xb9c3, 0xbba8},
	{0xb9c4, 0xbbac},
	{0xb9c5, 0xbbb4},
	{0xb9c6, 0xbbb7},
	{0xb9c7, 0xbbc0},
	{0xb9c8, 0xbbc4},
	{0xb9c9, 0xbbc8},
	{0xb9ca, 0xbbd0},
	{0xb9cb, 0xbbd3},
	{0xb9cc, 0xbbf8},
	{0xb9cd, 0xbbf9},
	{0xb9ce, 0xbbfc},
	{0xb9cf, 0xbbff},
	{0xb9d0, 0xbc00},
	{0xb9d1, 0xbc02},
	{0xb9d2, 0xbc08},
	{0xb9d3, 0xbc09},
	{0xb9d4, 0xbc0b},
	{0xb9d5, 0xbc0c},
	{0xb9d6, 0xbc0d},
	{0xb9d7, 0xbc0f},
	{0xb9d8, 0xbc11},
	{0xb9d9, 0xbc14},
	{0xb9da, 0xbc15},
	{0xb9db, 0xbc16},
	{0xb9dc, 0xbc17},
	{0xb9dd, 0xbc18},
	{0xb9de, 0xbc1b},
	{0xb9df, 0xbc1c},
	{0xb9e0, 0xbc1d},
	{0xb9e1, 0xbc1e},
	{0xb9e2, 0xbc1f},
	{0xb9e3, 0xbc24},
	{0xb9e4, 0xbc25},
	{0xb9e5, 0xbc27},
	{0xb9e6, 0xbc29},
	{0xb9e7, 0xbc2d},
	{0xb9e8, 0xbc30},
	{0xb9e9, 0xbc31},
	{0xb9ea, 0xbc34},
	{0xb9eb, 0xbc38},
	{0xb9ec, 0xbc40},
	{0xb9ed, 0xbc41},
	{0xb9ee, 0xbc43},
	{0xb9ef, 0xbc44},
	{0xb9f0, 0xbc45},
	{0xb9f1, 0xbc49},
	{0xb9f2, 0xbc4c},
	{0xb9f3, 0xbc4d},
	{0xb9f4, 0xbc50},
	{0xb9f5, 0xbc5d},
	{0xb9f6, 0xbc84},
	{0xb9f7, 0xbc85},
	{0xb9f8, 0xbc88},
	{0xb9f9, 0xbc8b},
	{0xb9fa, 0xbc8c},
	{0xb9fb, 0xbc8e},
	{0xb9fc, 0xbc94},
	{0xb9fd, 0xbc95},
	{0xb9fe, 0xbc97},
	{0xba41, 0xd28d},
	{0xba42, 0xd28e},
	{0xba43, 0xd28f},
	{0xba44, 0xd292},
	{0xba45, 0xd293},
	{0xba46, 0xd294},
	{0xba47, 0xd296},
	{0xba48, 0xd297},
	{0xba49, 0xd298},
	{0xba4a, 0xd299},
	{0xba4b, 0xd29a},
	{0xba4c, 0xd29b},
	{0xba4d, 0xd29d},
	{0xba4e, 0xd29e},
	{0xba4f, 0xd29f},
	{0xba50, 0xd2a1},
	{0xba51, 0xd2a2},
	{0xba52, 0xd2a3},
	{0xba53, 0xd2a5},
	{0xba54, 0xd2a6},
	{0xba55, 0xd2a7},
	{0xba56, 0xd2a8},
	{0xba57, 0xd2a9},
	{0xba58, 0xd2aa},
	{0xba59, 0xd2ab},
	{0xba5a, 0xd2ad},
	{0xba61, 0xd2ae},
	{0xba62, 0xd2af},
	{0xba63, 0xd2b0},
	{0xba64, 0xd2b2},
	{0xba65, 0xd2b3},
	{0xba66, 0xd2b4},
	{0xba67, 0xd2b5},
	{0xba68, 0xd2b6},
	{0xba69, 0xd2b7},
	{0xba6a, 0xd2ba},
	{0xba6b, 0xd2bb},
	{0xba6c, 0xd2bd},
	{0xba6d, 0xd2be},
	{0xba6e, 0xd2c1},
	{0xba6f, 0xd2c3},
	{0xba70, 0xd2c4},
	{0xba71, 0xd2c5},
	{0xba72, 0xd2c6},
	{0xba73, 0xd2c7},
	{0xba74, 0xd2ca},
	{0xba75, 0xd2cc},
	{0xba76, 0xd2cd},
	{0xba77, 0xd2ce},
	{0xba78, 0xd2cf},
	{0xba79, 0xd2d0},
	{0xba7a, 0xd2d1},
	{0xba81, 0xd2d2},
	{0xba82, 0xd2d3},
	{0xba83, 0xd2d5},
	{0xba84, 0xd2d6},
	{0xba85, 0xd2d7},
	{0xba86, 0xd2d9},
	{0xba87, 0xd2da},
	{0xba88, 0xd2db},
	{0xba89, 0xd2dd},
	{0xba8a, 0xd2de},
	{0xba8b, 0xd2df},
	{0xba8c, 0xd2e0},
	{0xba8d, 0xd2e1},
	{0xba8e, 0xd2e2},
	{0xba8f, 0xd2e3},
	{0xba90, 0xd2e6},
	{0xba91, 0xd2e7},
	{0xba92, 0xd2e8},
	{0xba93, 0xd2e9},
	{0xba94, 0xd2ea},
	{0xba95, 0xd2eb},
	{0xba96, 0xd2ec},
	{0xba97, 0xd2ed},
	{0xba98, 0xd2ee},
	{0xba99, 0xd2ef},
	{0xba9a, 0xd2f2},
	{0xba9b, 0xd2f3},
	{0xba9c, 0xd2f5},
	{0xba9d, 0xd2f6},
	{0xba9e, 0xd2f7},
	{0xba9f, 0xd2f9},
	{0xbaa0, 0xd2fa},
	{0xbaa1, 0xbc99},
	{0xbaa2, 0xbc9a},
	{0xbaa3, 0xbca0},
	{0xbaa4, 0xbca1},
	{0xbaa5, 0xbca4},
	{0xbaa6, 0xbca7},
	{0xbaa7, 0xbca8},
	{0xbaa8, 0xbcb0},
	{0xbaa9, 0xbcb1},
	{0xbaaa, 0xbcb3},
	{0xbaab, 0xbcb4},
	{0xbaac, 0xbcb5},
	{0xbaad, 0xbcbc},
	{0xbaae, 0xbcbd},
	{0xbaaf, 0xbcc0},
	{0xbab0, 0xbcc4},
	{0xbab1, 0xbccd},
	{0xbab2, 0xbccf},
	{0xbab3, 0xbcd0},
	{0xbab4, 0xbcd1},
	{0xbab5, 0xbcd5},
	{0xbab6, 0xbcd8},
	{0xbab7, 0xbcdc},
	{0xbab8, 0xbcf4},
	{0xbab9, 0xbcf5},
	{0xbaba, 0xbcf6},
	{0xbabb, 0xbcf8},
	{0xbabc, 0xbcfc},
	{0xbabd, 0xbd04},
	{0xbabe, 0xbd05},
	{0xbabf, 0xbd07},
	{0xbac0, 0xbd09},
	{0xbac1, 0xbd10},
	{0xbac2, 0xbd14},
	{0xbac3, 0xbd24},
	{0xbac4, 0xbd2c},
	{0xbac5, 0xbd40},
	{0xbac6, 0xbd48},
	{0xbac7, 0xbd49},
	{0xbac8, 0xbd4c},
	{0xbac9, 0xbd50},
	{0xbaca, 0xbd58},
	{0xbacb, 0xbd59},
	{0xbacc, 0xbd64},
	{0xbacd, 0xbd68},
	{0xbace, 0xbd80},
	{0xbacf, 0xbd81},
	{0xbad0, 0xbd84},
	{0xbad1, 0xbd87},
	{0xbad2, 0xbd88},
	{0xbad3, 0xbd89},
	{0xbad4, 0xbd8a},
	{0xbad5, 0xbd90},
	{0xbad6, 0xbd91},
	{0xbad7, 0xbd93},
	{0xbad8, 0xbd95},
	{0xbad9, 0xbd99},
	{0xbada, 0xbd9a},
	{0xbadb, 0xbd9c},
	{0xbadc, 0xbda4},
	{0xbadd, 0xbdb0},
	{0xbade, 0xbdb8},
	{0xbadf, 0xbdd4},
	{0xbae0, 0xbdd5},
	{0xbae1, 0xbdd8},
	{0xbae2, 0xbddc},
	{0xbae3, 0xbde9},
	{0xbae4, 0xbdf0},
	{0xbae5, 0xbdf4},
	{0xbae6, 0xbdf8},
	{0xbae7, 0xbe00},
	{0xbae8, 0xbe03},
	{0xbae9, 0xbe05},
	{0xbaea, 0xbe0c},
	{0xbaeb, 0xbe0d},
	{0xbaec, 0xbe10},
	{0xbaed, 0xbe14},
	{0xbaee, 0xbe1c},
	{0xbaef, 0xbe1d},
	{0xbaf0, 0xbe1f},
	{0xbaf1, 0xbe44},
	{0xbaf2, 0xbe45},
	{0xbaf3, 0xbe48},
	{0xbaf4, 0xbe4c},
	{0xbaf5, 0xbe4e},
	{0xbaf6, 0xbe54},
	{0xbaf7, 0xbe55},
	{0xbaf8, 0xbe57},
	{0xbaf9, 0xbe59},
	{0xbafa, 0xbe5a},
	{0xbafb, 0xbe5b},
	{0xbafc, 0xbe60},
	{0xbafd, 0xbe61},
	{0xbafe, 0xbe64},
	{0xbb41, 0xd2fb},
	{0xbb42, 0xd2fc},
	{0xbb43, 0xd2fd},
	{0xbb44, 0xd2fe},
	{0xbb45, 0xd2ff},
	{0xbb46, 0xd302},
	{0xbb47, 0xd304},
	{0xbb48, 0xd306},
	{0xbb49, 0xd307},
	{0xbb4a, 0xd308},
	{0xbb4b, 0xd309},
	{0xbb4c, 0xd30a},
	{0xbb4d, 0xd30b},
	{0xbb4e, 0xd30f},
	{0xbb4f, 0xd311},
	{0xbb50, 0xd312},
	{0xbb51, 0xd313},
	{0xbb52, 0xd315},
	{0xbb53, 0xd317},
	{0xbb54, 0xd318},
	{0xbb55, 0xd319},
	{0xbb56, 0xd31a},
	{0xbb57, 0xd31b},
	{0xbb58, 0xd31e},
	{0xbb59, 0xd322},
	{0xbb5a, 0xd323},
	{0xbb61, 0xd324},
	{0xbb62, 0xd326},
	{0xbb63, 0xd327},
	{0xbb64, 0xd32a},
	{0xbb65, 0xd32b},
	{0xbb66, 0xd32d},
	{0xbb67, 0xd32e},
	{0xbb68, 0xd32f},
	{0xbb69, 0xd331},
	{0xbb6a, 0xd332},
	{0xbb6b, 0xd333},
	{0xbb6c, 0xd334},
	{0xbb6d, 0xd335},
	{0xbb6e, 0xd336},
	{0xbb6f, 0xd337},
	{0xbb70, 0xd33a},
	{0xbb71, 0xd33e},
	{0xbb72, 0xd33f},
	{0xbb73, 0xd340},
	{0xbb74, 0xd341},
	{0xbb75, 0xd342},
	{0xbb76, 0xd343},
	{0xbb77, 0xd346},
	{0xbb78, 0xd347},
	{0xbb79, 0xd348},
	{0xbb7a, 0xd349},
	{0xbb81, 0xd34a},
	{0xbb82, 0xd34b},
	{0xbb83, 0xd34c},
	{0xbb84, 0xd34d},
	{0xbb85, 0xd34e},
	{0xbb86, 0xd34f},
	{0xbb87, 0xd350},
	{0xbb88, 0xd351},
	{0xbb89, 0xd352},
	{0xbb8a, 0xd353},
	{0xbb8b, 0xd354},
	{0xbb8c, 0xd355},
	{0xbb8d, 0xd356},
	{0xbb8e, 0xd357},
	{0xbb8f, 0xd358},
	{0xbb90, 0xd359},
	{0xbb91, 0xd35a},
	{0xbb92, 0xd35b},
	{0xbb93, 0xd35c},
	{0xbb94, 0xd35d},
	{0xbb95, 0xd35e},
	{0xbb96, 0xd35f},
	{0xbb97, 0xd360},
	{0xbb98, 0xd361},
	{0xbb99, 0xd362},
	{0xbb9a, 0xd363},
	{0xbb9b, 0xd364},
	{0xbb9c, 0xd365},
	{0xbb9d, 0xd366},
	{0xbb9e, 0xd367},
	{0xbb9f, 0xd368},
	{0xbba0, 0xd369},
	{0xbba1, 0xbe68},
	{0xbba2, 0xbe6a},
	{0xbba3, 0xbe70},
	{0xbba4, 0xbe71},
	{0xbba5, 0xbe73},
	{0xbba6, 0xbe74},
	{0xbba7, 0xbe75},
	{0xbba8, 0xbe7b},
	{0xbba9, 0xbe7c},
	{0xbbaa, 0xbe7d},
	{0xbbab, 0xbe80},
	{0xbbac, 0xbe84},
	{0xbbad, 0xbe8c},
	{0xbbae, 0xbe8d},
	{0xbbaf, 0xbe8f},
	{0xbbb0, 0xbe90},
	{0xbbb1, 0xbe91},
	{0xbbb2, 0xbe98},
	{0xbbb3, 0xbe99},
	{0xbbb4, 0xbea8},
	{0xbbb5, 0xbed0},
	{0xbbb6, 0xbed1},
	{0xbbb7, 0xbed4},
	{0xbbb8, 0xbed7},
	{0xbbb9, 0xbed8},
	{0xbbba, 0xbee0},
	{0xbbbb, 0xbee3},
	{0xbbbc, 0xbee4},
	{0xbbbd, 0xbee5},
	{0xbbbe, 0xbeec},
	{0xbbbf, 0xbf01},
	{0xbbc0, 0xbf08},
	{0xbbc1, 0xbf09},
	{0xbbc2, 0xbf18},
	{0xbbc3, 0xbf19},
	{0xbbc4, 0xbf1b},
	{0xbbc5, 0xbf1c},
	{0xbbc6, 0xbf1d},
	{0xbbc7, 0xbf40},
	{0xbbc8, 0xbf41},
	{0xbbc9, 0xbf44},
	{0xbbca, 0xbf48},
	{0xbbcb, 0xbf50},
	{0xbbcc, 0xbf51},
	{0xbbcd, 0xbf55},
	{0xbbce, 0xbf94},
	{0xbbcf, 0xbfb0},
	{0xbbd0, 0xbfc5},
	{0xbbd1, 0xbfcc},
	{0xbbd2, 0xbfcd},
	{0xbbd3, 0xbfd0},
	{0xbbd4, 0xbfd4},
	{0xbbd5, 0xbfdc},
	{0xbbd6, 0xbfdf},
	{0xbbd7, 0xbfe1},
	{0xbbd8, 0xc03c},
	{0xbbd9, 0xc051},
	{0xbbda, 0xc058},
	{0xbbdb, 0xc05c},
	{0xbbdc, 0xc060},
	{0xbbdd, 0xc068},
	{0xbbde, 0xc069},
	{0xbbdf, 0xc090},
	{0xbbe0, 0xc091},
	{0xbbe1, 0xc094},
	{0xbbe2, 0xc098},
	{0xbbe3, 0xc0a0},
	{0xbbe4, 0xc0a1},
	{0xbbe5, 0xc0a3},
	{0xbbe6, 0xc0a5},
	{0xbbe7, 0xc0ac},
	{0xbbe8, 0xc0ad},
	{0xbbe9, 0xc0af},
	{0xbbea, 0xc0b0},
	{0xbbeb, 0xc0b3},
	{0xbbec, 0xc0b4},
	{0xbbed, 0xc0b5},
	{0xbbee, 0xc0b6},
	{0xbbef, 0xc0bc},
	{0xbbf0, 0xc0bd},
	{0xbbf1, 0xc0bf},
	{0xbbf2, 0xc0c0},
	{0xbbf3, 0xc0c1},
	{0xbbf4, 0xc0c5},
	{0xbbf5, 0xc0c8},
	{0xbbf6, 0xc0c9},
	{0xbbf7, 0xc0cc},
	{0xbbf8, 0xc0d0},
	{0xbbf9, 0xc0d8},
	{0xbbfa, 0xc0d9},
	{0xbbfb, 0xc0db},
	{0xbbfc, 0xc0dc},
	{0xbbfd, 0xc0dd},
	{0xbbfe, 0xc0e4},
	{0xbc41, 0xd36a},
	{0xbc42, 0xd36b},
	{0xbc43, 0xd36c},
	{0xbc44, 0xd36d},
	{0xbc45, 0xd36e},
	{0xbc46, 0xd36f},
	{0xbc47, 0xd370},
	{0xbc48, 0xd371},
	{0xbc49, 0xd372},
	{0xbc4a, 0xd373},
	{0xbc4b, 0xd374},
	{0xbc4c, 0xd375},
	{0xbc4d, 0xd376},
	{0xbc4e, 0xd377},
	{0xbc4f, 0xd378},
	{0xbc50, 0xd379},
	{0xbc51, 0xd37a},
	{0xbc52, 0xd37b},
	{0xbc53, 0xd37e},
	{0xbc54, 0xd37f},
	{0xbc55, 0xd381},
	{0xbc56, 0xd382},
	{0xbc57, 0xd383},
	{0xbc58, 0xd385},
	{0xbc59, 0xd386},
	{0xbc5a, 0xd387},
	{0xbc61, 0xd388},
	{0xbc62, 0xd389},
	{0xbc63, 0xd38a},
	{0xbc64, 0xd38b},
	{0xbc65, 0xd38e},
	{0xbc66, 0xd392},
	{0xbc67, 0xd393},
	{0xbc68, 0xd394},
	{0xbc69, 0xd395},
	{0xbc6a, 0xd396},
	{0xbc6b, 0xd397},
	{0xbc6c, 0xd39a},
	{0xbc6d, 0xd39b},
	{0xbc6e, 0xd39d},
	{0xbc6f, 0xd39e},
	{0xbc70, 0xd39f},
	{0xbc71, 0xd3a1},
	{0xbc72, 0xd3a2},
	{0xbc73, 0xd3a3},
	{0xbc74, 0xd3a4},
	{0xbc75, 0xd3a5},
	{0xbc76, 0xd3a6},
	{0xbc77, 0xd3a7},
	{0xbc78, 0xd3aa},
	{0xbc79, 0xd3ac},
	{0xbc7a, 0xd3ae},
	{0xbc81, 0xd3af},
	{0xbc82, 0xd3b0},
	{0xbc83, 0xd3b1},
	{0xbc84, 0xd3b2},
	{0xbc85, 0xd3b3},
	{0xbc86, 0xd3b5},
	{0xbc87, 0xd3b6},
	{0xbc88, 0xd3b7},
	{0xbc89, 0xd3b9},
	{0xbc8a, 0xd3ba},
	{0xbc8b, 0xd3bb},
	{0xbc8c, 0xd3bd},
	{0xbc8d, 0xd3be},
	{0xbc8e, 0xd3bf},
	{0xbc8f, 0xd3c0},
	{0xbc90, 0xd3c1},
	{0xbc91, 0xd3c2},
	{0xbc92, 0xd3c3},
	{0xbc93, 0xd3c6},
	{0xbc94, 0xd3c7},
	{0xbc95, 0xd3ca},
	{0xbc96, 0xd3cb},
	{0xbc97, 0xd3cc},
	{0xbc98, 0xd3cd},
	{0xbc99, 0xd3ce},
	{0xbc9a, 0xd3cf},
	{0xbc9b, 0xd3d1},
	{0xbc9c, 0xd3d2},
	{0xbc9d, 0xd3d3},
	{0xbc9e, 0xd3d4},
	{0xbc9f, 0xd3d5},
	{0xbca0, 0xd3d6},
	{0xbca1, 0xc0e5},
	{0xbca2, 0xc0e8},
	{0xbca3, 0xc0ec},
	{0xbca4, 0xc0f4},
	{0xbca5, 0xc0f5},
	{0xbca6, 0xc0f7},
	{0xbca7, 0xc0f9},
	{0xbca8, 0xc100},
	{0xbca9, 0xc104},
	{0xbcaa, 0xc108},
	{0xbcab, 0xc110},
	{0xbcac, 0xc115},
	{0xbcad, 0xc11c},
	{0xbcae, 0xc11d},
	{0xbcaf, 0xc11e},
	{0xbcb0, 0xc11f},
	{0xbcb1, 0xc120},
	{0xbcb2, 0xc123},
	{0xbcb3, 0xc124},
	{0xbcb4, 0xc126},
	{0xbcb5, 0xc127},
	{0xbcb6, 0xc12c},
	{0xbcb7, 0xc12d},
	{0xbcb8, 0xc12f},
	{0xbcb9, 0xc130},
	{0xbcba, 0xc131},
	{0xbcbb, 0xc136},
	{0xbcbc, 0xc138},
	{0xbcbd, 0xc139},
	{0xbcbe, 0xc13c},
	{0xbcbf, 0xc140},
	{0xbcc0, 0xc148},
	{0xbcc1, 0xc149},
	{0xbcc2, 0xc14b},
	{0xbcc3, 0xc14c},
	{0xbcc4, 0xc14d},
	{0xbcc5, 0xc154},
	{0xbcc6, 0xc155},
	{0xbcc7, 0xc158},
	{0xbcc8, 0xc15c},
	{0xbcc9, 0xc164},
	{0xbcca, 0xc165},
	{0xbccb, 0xc167},
	{0xbccc, 0xc168},
	{0xbccd, 0xc169},
	{0xbcce, 0xc170},
	{0xbccf, 0xc174},
	{0xbcd0, 0xc178},
	{0xbcd1, 0xc185},
	{0xbcd2, 0xc18c},
	{0xbcd3, 0xc18d},
	{0xbcd4, 0xc18e},
	{0xbcd5, 0xc190},
	{0xbcd6, 0xc194},
	{0xbcd7, 0xc196},
	{0xbcd8, 0xc19c},
	{0xbcd9, 0xc19d},
	{0xbcda, 0xc19f},
	{0xbcdb, 0xc1a1},
	{0xbcdc, 0xc1a5},
	{0xbcdd, 0xc1a8},
	{0xbcde, 0xc1a9},
	{0xbcdf, 0xc1ac},
	{0xbce0, 0xc1b0},
	{0xbce1, 0xc1bd},
	{0xbce2, 0xc1c4},
	{0xbce3, 0xc1c8},
	{0xbce4, 0xc1cc},
	{0xbce5, 0xc1d4},
	{0xbce6, 0xc1d7},
	{0xbce7, 0xc1d8},
	{0xbce8, 0xc1e0},
	{0xbce9, 0xc1e4},
	{0xbcea, 0xc1e8},
	{0xbceb, 0xc1f0},
	{0xbcec, 0xc1f1},
	{0xbced, 0xc1f3},
	{0xbcee, 0xc1fc},
	{0xbcef, 0xc1fd},
	{0xbcf0, 0xc200},
	{0xbcf1, 0xc204},
	{0xbcf2, 0xc20c},
	{0xbcf3, 0xc20d},
	{0xbcf4, 0xc20f},
	{0xbcf5, 0xc211},
	{0xbcf6, 0xc218},
	{0xbcf7, 0xc219},
	{0xbcf8, 0xc21c},
	{0xbcf9, 0xc21f},
	{0xbcfa, 0xc220},
	{0xbcfb, 0xc228},
	{0xbcfc, 0xc229},
	{0xbcfd, 0xc22b},
	{0xbcfe, 0xc22d},
	{0xbd41, 0xd3d7},
	{0xbd42, 0xd3d9},
	{0xbd43, 0xd3da},
	{0xbd44, 0xd3db},
	{0xbd45, 0xd3dc},
	{0xbd46, 0xd3dd},
	{0xbd47, 0xd3de},
	{0xbd48, 0xd3df},
	{0xbd49, 0xd3e0},
	{0xbd4a, 0xd3e2},
	{0xbd4b, 0xd3e4},
	{0xbd4c, 0xd3e5},
	{0xbd4d, 0xd3e6},
	{0xbd4e, 0xd3e7},
	{0xbd4f, 0xd3e8},
	{0xbd50, 0xd3e9},
	{0xbd51, 0xd3ea},
	{0xbd52, 0xd3eb},
	{0xbd53, 0xd3ee},
	{0xbd54, 0xd3ef},
	{0xbd55, 0xd3f1},
	{0xbd56, 0xd3f2},
	{0xbd57, 0xd3f3},
	{0xbd58, 0xd3f5},
	{0xbd59, 0xd3f6},
	{0xbd5a, 0xd3f7},
	{0xbd61, 0xd3f8},
	{0xbd62, 0xd3f9},
	{0xbd63, 0xd3fa},
	{0xbd64, 0xd3fb},
	{0xbd65, 0xd3fe},
	{0xbd66, 0xd400},
	{0xbd67, 0xd402},
	{0xbd68, 0xd403},
	{0xbd69, 0xd404},
	{0xbd6a, 0xd405},
	{0xbd6b, 0xd406},
	{0xbd6c, 0xd407},
	{0xbd6d, 0xd409},
	{0xbd6e, 0xd40a},
	{0xbd6f, 0xd40b},
	{0xbd70, 0xd40c},
	{0xbd71, 0xd40d},
	{0xbd72, 0xd40e},
	{0xbd73, 0xd40f},
	{0xbd74, 0xd410},
	{0xbd75, 0xd411},
	{0xbd76, 0xd412},
	{0xbd77, 0xd413},
	{0xbd78, 0xd414},
	{0xbd79, 0xd415},
	{0xbd7a, 0xd416},
	{0xbd81, 0xd417},
	{0xbd82, 0xd418},
	{0xbd83, 0xd419},
	{0xbd84, 0xd41a},
	{0xbd85, 0xd41b},
	{0xbd86, 0xd41c},
	{0xbd87, 0xd41e},
	{0xbd88, 0xd41f},
	{0xbd89, 0xd420},
	{0xbd8a, 0xd421},
	{0xbd8b, 0xd422},
	{0xbd8c, 0xd423},
	{0xbd8d, 0xd424},
	{0xbd8e, 0xd425},
	{0xbd8f, 0xd426},
	{0xbd90, 0xd427},
	{0xbd91, 0xd428},
	{0xbd92, 0xd429},
	{0xbd93, 0xd42a},
	{0xbd94, 0xd42b},
	{0xbd95, 0xd42c},
	{0xbd96, 0xd42d},
	{0xbd97, 0xd42e},
	{0xbd98, 0xd42f},
	{0xbd99, 0xd430},
	{0xbd9a, 0xd431},
	{0xbd9b, 0xd432},
	{0xbd9c, 0xd433},
	{0xbd9d, 0xd434},
	{0xbd9e, 0xd435},
	{0xbd9f, 0xd436},
	{0xbda0, 0xd437},
	{0xbda1, 0xc22f},
	{0xbda2, 0xc231},
	{0xbda3, 0xc232},
	{0xbda4, 0xc234},
	{0xbda5, 0xc248},
	{0xbda6, 0xc250},
	{0xbda7, 0xc251},
	{0xbda8, 0xc254},
	{0xbda9, 0xc258},
	{0xbdaa, 0xc260},
	{0xbdab, 0xc265},
	{0xbdac, 0xc26c},
	{0xbdad, 0xc26d},
	{0xbdae, 0xc270},
	{0xbdaf, 0xc274},
	{0xbdb0, 0xc27c},
	{0xbdb1, 0xc27d},
	{0xbdb2, 0xc27f},
	{0xbdb3, 0xc281},
	{0xbdb4, 0xc288},
	{0xbdb5, 0xc289},
	{0xbdb6, 0xc290},
	{0xbdb7, 0xc298},
	{0xbdb8, 0xc29b},
	{0xbdb9, 0xc29d},
	{0xbdba, 0xc2a4},
	{0xbdbb, 0xc2a5},
	{0xbdbc, 0xc2a8},
	{0xbdbd, 0xc2ac},
	{0xbdbe, 0xc2ad},
	{0xbdbf, 0xc2b4},
	{0xbdc0, 0xc2b5},
	{0xbdc1, 0xc2b7},
	{0xbdc2, 0xc2b9},
	{0xbdc3, 0xc2dc},
	{0xbdc4, 0xc2dd},
	{0xbdc5, 0xc2e0},
	{0xbdc6, 0xc2e3},
	{0xbdc7, 0xc2e4},
	{0xbdc8, 0xc2eb},
	{0xbdc9, 0xc2ec},
	{0xbdca, 0xc2ed},
	{0xbdcb, 0xc2ef},
	{0xbdcc, 0xc2f1},
	{0xbdcd, 0xc2f6},
	{0xbdce, 0xc2f8},
	{0xbdcf, 0xc2f9},
	{0xbdd0, 0xc2fb},
	{0xbdd1, 0xc2fc},
	{0xbdd2, 0xc300},
	{0xbdd3, 0xc308},
	{0xbdd4, 0xc309},
	{0xbdd5, 0xc30c},
	{0xbdd6, 0xc30d},
	{0xbdd7, 0xc313},
	{0xbdd8, 0xc314},
	{0xbdd9, 0xc315},
	{0xbdda, 0xc318},
	{0xbddb, 0xc31c},
	{0xbddc, 0xc324},
	{0xbddd, 0xc325},
	{0xbdde, 0xc328},
	{0xbddf, 0xc329},
	{0xbde0, 0xc345},
	{0xbde1, 0xc368},
	{0xbde2, 0xc369},
	{0xbde3, 0xc36c},
	{0xbde4, 0xc370},
	{0xbde5, 0xc372},
	{0xbde6, 0xc378},
	{0xbde7, 0xc379},
	{0xbde8, 0xc37c},
	{0xbde9, 0xc37d},
	{0xbdea, 0xc384},
	{0xbdeb, 0xc388},
	{0xbdec, 0xc38c},
	{0xbded, 0xc3c0},
	{0xbdee, 0xc3d8},
	{0xbdef, 0xc3d9},
	{0xbdf0, 0xc3dc},
	{0xbdf1, 0xc3df},
	{0xbdf2, 0xc3e0},
	{0xbdf3, 0xc3e2},
	{0xbdf4, 0xc3e8},
	{0xbdf5, 0xc3e9},
	{0xbdf6, 0xc3ed},
	{0xbdf7, 0xc3f4},
	{0xbdf8, 0xc3f5},
	{0xbdf9, 0xc3f8},
	{0xbdfa, 0xc408},
	{0xbdfb, 0xc410},
	{0xbdfc, 0xc424},
	{0xbdfd, 0xc42c},
	{0xbdfe, 0xc430},
	{0xbe41, 0xd438},
	{0xbe42, 0xd439},
	{0xbe43, 0xd43a},
	{0xbe44, 0xd43b},
	{0xbe45, 0xd43c},
	{0xbe46, 0xd43d},
	{0xbe47, 0xd43e},
	{0xbe48, 0xd43f},
	{0xbe49, 0xd441},
	{0xbe4a, 0xd442},
	{0xbe4b, 0xd443},
	{0xbe4c, 0xd445},
	{0xbe4d, 0xd446},
	{0xbe4e, 0xd447},
	{0xbe4f, 0xd448},
	{0xbe50, 0xd449},
	{0xbe51, 0xd44a},
	{0xbe52, 0xd44b},
	{0xbe53, 0xd44c},
	{0xbe54, 0xd44d},
	{0xbe55, 0xd44e},
	{0xbe56, 0xd44f},
	{0xbe57, 0xd450},
	{0xbe58, 0xd451},
	{0xbe59, 0xd452},
	{0xbe5a, 0xd453},
	{0xbe61, 0xd454},
	{0xbe62, 0xd455},
	{0xbe63, 0xd456},
	{0xbe64, 0xd457},
	{0xbe65, 0xd458},
	{0xbe66, 0xd459},
	{0xbe67, 0xd45a},
	{0xbe68, 0xd45b},
	{0xbe69, 0xd45d},
	{0xbe6a, 0xd45e},
	{0xbe6b, 0xd45f},
	{0xbe6c, 0xd461},
	{0xbe6d, 0xd462},
	{0xbe6e, 0xd463},
	{0xbe6f, 0xd465},
	{0xbe70, 0xd466},
	{0xbe71, 0xd467},
	{0xbe72, 0xd468},
	{0xbe73, 0xd469},
	{0xbe74, 0xd46a},
	{0xbe75, 0xd46b},
	{0xbe76, 0xd46c},
	{0xbe77, 0xd46e},
	{0xbe78, 0xd470},
	{0xbe79, 0xd471},
	{0xbe7a, 0xd472},
	{0xbe81, 0xd473},
	{0xbe82, 0xd474},
	{0xbe83, 0xd475},
	{0xbe84, 0xd476},
	{0xbe85, 0xd477},
	{0xbe86, 0xd47a},
	{0xbe87, 0xd47b},
	{0xbe88, 0xd47d},
	{0xbe89, 0xd47e},
	{0xbe8a, 0xd481},
	{0xbe8b, 0xd483},
	{0xbe8c, 0xd484},
	{0xbe8d, 0xd485},
	{0xbe8e, 0xd486},
	{0xbe8f, 0xd487},
	{0xbe90, 0xd48a},
	{0xbe91, 0xd48c},
	{0xbe92, 0xd48e},
	{0xbe93, 0xd48f},
	{0xbe94, 0xd490},
	{0xbe95, 0xd491},
	{0xbe96, 0xd492},
	{0xbe97, 0xd493},
	{0xbe98, 0xd495},
	{0xbe99, 0xd496},
	{0xbe9a, 0xd497},
	{0xbe9b, 0xd498},
	{0xbe9c, 0xd499},
	{0xbe9d, 0xd49a},
	{0xbe9e, 0xd49b},
	{0xbe9f, 0xd49c},
	{0xbea0, 0xd49d},
	{0xbea1, 0xc434},
	{0xbea2, 0xc43c},
	{0xbea3, 0xc43d},
	{0xbea4, 0xc448},
	{0xbea5, 0xc464},
	{0xbea6, 0xc465},
	{0xbea7, 0xc468},
	{0xbea8, 0xc46c},
	{0xbea9, 0xc474},
	{0xbeaa, 0xc475},
	{0xbeab, 0xc479},
	{0xbeac, 0xc480},
	{0xbead, 0xc494},
	{0xbeae, 0xc49c},
	{0xbeaf, 0xc4b8},
	{0xbeb0, 0xc4bc},
	{0xbeb1, 0xc4e9},
	{0xbeb2, 0xc4f0},
	{0xbeb3, 0xc4f1},
	{0xbeb4, 0xc4f4},
	{0xbeb5, 0xc4f8},
	{0xbeb6, 0xc4fa},
	{0xbeb7, 0xc4ff},
	{0xbeb8, 0xc500},
	{0xbeb9, 0xc501},
	{0xbeba, 0xc50c},
	{0xbebb, 0xc510},
	{0xbebc, 0xc514},
	{0xbebd, 0xc51c},
	{0xbebe, 0xc528},
	{0xbebf, 0xc529},
	{0xbec0, 0xc52c},
	{0xbec1, 0xc530},
	{0xbec2, 0xc538},
	{0xbec3, 0xc539},
	{0xbec4, 0xc53b},
	{0xbec5, 0xc53d},
	{0xbec6, 0xc544},
	{0xbec7, 0xc545},
	{0xbec8, 0xc548},
	{0xbec9, 0xc549},
	{0xbeca, 0xc54a},
	{0xbecb, 0xc54c},
	{0xbecc, 0xc54d},
	{0xbecd, 0xc54e},
	{0xbece, 0xc553},
	{0xbecf, 0xc554},
	{0xbed0, 0xc555},
	{0xbed1, 0xc557},
	{0xbed2, 0xc558},
	{0xbed3, 0xc559},
	{0xbed4, 0xc55d},
	{0xbed5, 0xc55e},
	{0xbed6, 0xc560},
	{0xbed7, 0xc561},
	{0xbed8, 0xc564},
	{0xbed9, 0xc568},
	{0xbeda, 0xc570},
	{0xbedb, 0xc571},
	{0xbedc, 0xc573},
	{0xbedd, 0xc574},
	{0xbede, 0xc575},
	{0xbedf, 0xc57c},
	{0xbee0, 0xc57d},
	{0xbee1, 0xc580},
	{0xbee2, 0xc584},
	{0xbee3, 0xc587},
	{0xbee4, 0xc58c},
	{0xbee5, 0xc58d},
	{0xbee6, 0xc58f},
	{0xbee7, 0xc591},
	{0xbee8, 0xc595},
	{0xbee9, 0xc597},
	{0xbeea, 0xc598},
	{0xbeeb, 0xc59c},
	{0xbeec, 0xc5a0},
	{0xbeed, 0xc5a9},
	{0xbeee, 0xc5b4},
	{0xbeef, 0xc5b5},
	{0xbef0, 0xc5b8},
	{0xbef1, 0xc5b9},
	{0xbef2, 0xc5bb},
	{0xbef3, 0xc5bc},
	{0xbef4, 0xc5bd},
	{0xbef5, 0xc5be},
	{0xbef6, 0xc5c4},
	{0xbef7, 0xc5c5},
	{0xbef8, 0xc5c6},
	{0xbef9, 0xc5c7},
	{0xbefa, 0xc5c8},
	{0xbefb, 0xc5c9},
	{0xbefc, 0xc5ca},
	{0xbefd, 0xc5cc},
	{0xbefe, 0xc5ce},
	{0xbf41, 0xd49e},
	{0xbf42, 0xd49f},
	{0xbf43, 0xd4a0},
	{0xbf44, 0xd4a1},
	{0xbf45, 0xd4a2},
	{0xbf46, 0xd4a3},
	{0xbf47, 0xd4a4},
	{0xbf48, 0xd4a5},
	{0xbf49, 0xd4a6},
	{0xbf4a, 0xd4a7},
	{0xbf4b, 0xd4a8},
	{0xbf4c, 0xd4aa},
	{0xbf4d, 0xd4ab},
	{0xbf4e, 0xd4ac},
	{0xbf4f, 0xd4ad},
	{0xbf50, 0xd4ae},
	{0xbf51, 0xd4af},
	{0xbf52, 0xd4b0},
	{0xbf53, 0xd4b1},
	{0xbf54, 0xd4b2},
	{0xbf55, 0xd4b3},
	{0xbf56, 0xd4b4},
	{0xbf57, 0xd4b5},
	{0xbf58, 0xd4b6},
	{0xbf59, 0xd4b7},
	{0xbf5a, 0xd4b8},
	{0xbf61, 0xd4b9},
	{0xbf62, 0xd4ba},
	{0xbf63, 0xd4bb},
	{0xbf64, 0xd4bc},
	{0xbf65, 0xd4bd},
	{0xbf66, 0xd4be},
	{0xbf67, 0xd4bf},
	{0xbf68, 0xd4c0},
	{0xbf69, 0xd4c1},
	{0xbf6a, 0xd4c2},
	{0xbf6b, 0xd4c3},
	{0xbf6c, 0xd4c4},
	{0xbf6d, 0xd4c5},
	{0xbf6e, 0xd4c6},
	{0xbf6f, 0xd4c7},
	{0xbf70, 0xd4c8},
	{0xbf71, 0xd4c9},
	{0xbf72, 0xd4ca},
	{0xbf73, 0xd4cb},
	{0xbf74, 0xd4cd},
	{0xbf75, 0xd4ce},
	{0xbf76, 0xd4cf},
	{0xbf77, 0xd4d1},
	{0xbf78, 0xd4d2},
	{0xbf79, 0xd4d3},
	{0xbf7a, 0xd4d5},
	{0xbf81, 0xd4d6},
	{0xbf82, 0xd4d7},
	{0xbf83, 0xd4d8},
	{0xbf84, 0xd4d9},
	{0xbf85, 0xd4da},
	{0xbf86, 0xd4db},
	{0xbf87, 0xd4dd},
	{0xbf88, 0xd4de},
	{0xbf89, 0xd4e0},
	{0xbf8a, 0xd4e1},
	{0xbf8b, 0xd4e2},
	{0xbf8c, 0xd4e3},
	{0xbf8d, 0xd4e4},
	{0xbf8e, 0xd4e5},
	{0xbf8f, 0xd4e6},
	{0xbf90, 0xd4e7},
	{0xbf91, 0xd4e9},
	{0xbf92, 0xd4ea},
	{0xbf93, 0xd4eb},
	{0xbf94, 0xd4ed},
	{0xbf95, 0xd4ee},
	{0xbf96, 0xd4ef},
	{0xbf97, 0xd4f1},
	{0xbf98, 0xd4f2},
	{0xbf99, 0xd4f3},
	{0xbf9a, 0xd4f4},
	{0xbf9b, 0xd4f5},
	{0xbf9c, 0xd4f6},
	{0xbf9d, 0xd4f7},
	{0xbf9e, 0xd4f9},
	{0xbf9f, 0xd4fa},
	{0xbfa0, 0xd4fc},
	{0xbfa1, 0xc5d0},
	{0xbfa2, 0xc5d1},
	{0xbfa3, 0xc5d4},
	{0xbfa4, 0xc5d8},
	{0xbfa5, 0xc5e0},
	{0xbfa6, 0xc5e1},
	{0xbfa7, 0xc5e3},
	{0xbfa8, 0xc5e5},
	{0xbfa9, 0xc5ec},
	{0xbfaa, 0xc5ed},
	{0xbfab, 0xc5ee},
	{0xbfac, 0xc5f0},
	{0xbfad, 0xc5f4},
	{0xbfae, 0xc5f6},
	{0xbfaf, 0xc5f7},
	{0xbfb0, 0xc5fc},
	{0xbfb1, 0xc5fd},
	{0xbfb2, 0xc5fe},
	{0xbfb3, 0xc5ff},
	{0xbfb4, 0xc600},
	{0xbfb5, 0xc601},
	{0xbfb6, 0xc605},
	{0xbfb7, 0xc606},
	{0xbfb8, 0xc607},
	{0xbfb9, 0xc608},
	{0xbfba, 0xc60c},
	{0xbfbb, 0xc610},
	{0xbfbc, 0xc618},
	{0xbfbd, 0xc619},
	{0xbfbe, 0xc61b},
	{0xbfbf, 0xc61c},
	{0xbfc0, 0xc624},
	{0xbfc1, 0xc625},
	{0xbfc2, 0xc628},
	{0xbfc3, 0xc62c},
	{0xbfc4, 0xc62d},
	{0xbfc5, 0xc62e},
	{0xbfc6, 0xc630},
	{0xbfc7, 0xc633},
	{0xbfc8, 0xc634},
	{0xbfc9, 0xc635},
	{0xbfca, 0xc637},
	{0xbfcb, 0xc639},
	{0xbfcc, 0xc63b},
	{0xbfcd, 0xc640},
	{0xbfce, 0xc641},
	{0xbfcf, 0xc644},
	{0xbfd0, 0xc648},
	{0xbfd1, 0xc650},
	{0xbfd2, 0xc651},
	{0xbfd3, 0xc653},
	{0xbfd4, 0xc654},
	{0xbfd5, 0xc655},
	{0xbfd6, 0xc65c},
	{0xbfd7, 0xc65d},
	{0xbfd8, 0xc660},
	{0xbfd9, 0xc66c},
	{0xbfda, 0xc66f},
	{0xbfdb, 0xc671},
	{0xbfdc, 0xc678},
	{0xbfdd, 0xc679},
	{0xbfde, 0xc67c},
	{0xbfdf, 0xc680},
	{0xbfe0, 0xc688},
	{0xbfe1, 0xc689},
	{0xbfe2, 0xc68b},
	{0xbfe3, 0xc68d},
	{0xbfe4, 0xc694},
	{0xbfe5, 0xc695},
	{0xbfe6, 0xc698},
	{0xbfe7, 0xc69c},
	{0xbfe8, 0xc6a4},
	{0xbfe9, 0xc6a5},
	{0xbfea, 0xc6a7},
	{0xbfeb, 0xc6a9},
	{0xbfec, 0xc6b0},
	{0xbfed, 0xc6b1},
	{0xbfee, 0xc6b4},
	{0xbfef, 0xc6b8},
	{0xbff0, 0xc6b9},
	{0xbff1, 0xc6ba},
	{0xbff2, 0xc6c0},
	{0xbff3, 0xc6c1},
	{0xbff4, 0xc6c3},
	{0xbff5, 0xc6c5},
	{0xbff6, 0xc6cc},
	{0xbff7, 0xc6cd},
	{0xbff8, 0xc6d0},
	{0xbff9, 0xc6d4},
	{0xbffa, 0xc6dc},
	{0xbffb, 0xc6dd},
	{0xbffc, 0xc6e0},
	{0xbffd, 0xc6e1},
	{0xbffe, 0xc6e8},
	{0xc041, 0xd4fe},
	{0xc042, 0xd4ff},
	{0xc043, 0xd500},
	{0xc044, 0xd501},
	{0xc045, 0xd502},
	{0xc046, 0xd503},
	{0xc047, 0xd505},
	{0xc048, 0xd506},
	{0xc049, 0xd507},
	{0xc04a, 0xd509},
	{0xc04b, 0xd50a},
	{0xc04c, 0xd50b},
	{0xc04d, 0xd50d},
	{0xc04e, 0xd50e},
	{0xc04f, 0xd50f},
	{0xc050, 0xd510},
	{0xc051, 0xd511},
	{0xc052, 0xd512},
	{0xc053, 0xd513},
	{0xc054, 0xd516},
	{0xc055, 0xd518},
	{0xc056, 0xd519},
	{0xc057, 0xd51a},
	{0xc058, 0xd51b},
	{0xc059, 0xd51c},
	{0xc05a, 0xd51d},
	{0xc061, 0xd51e},
	{0xc062, 0xd51f},
	{0xc063, 0xd520},
	{0xc064, 0xd521},
	{0xc065, 0xd522},
	{0xc066, 0xd523},
	{0xc067, 0xd524},
	{0xc068, 0xd525},
	{0xc069, 0xd526},
	{0xc06a, 0xd527},
	{0xc06b, 0xd528},
	{0xc06c, 0xd529},
	{0xc06d, 0xd52a},
	{0xc06e, 0xd52b},
	{0xc06f, 0xd52c},
	{0xc070, 0xd52d},
	{0xc071, 0xd52e},
	{0xc072, 0xd52f},
	{0xc073, 0xd530},
	{0xc074, 0xd531},
	{0xc075, 0xd532},
	{0xc076, 0xd533},
	{0xc077, 0xd534},
	{0xc078, 0xd535},
	{0xc079, 0xd536},
	{0xc07a, 0xd537},
	{0xc081, 0xd538},
	{0xc082, 0xd539},
	{0xc083, 0xd53a},
	{0xc084, 0xd53b},
	{0xc085, 0xd53e},
	{0xc086, 0xd53f},
	{0xc087, 0xd541},
	{0xc088, 0xd542},
	{0xc089, 0xd543},
	{0xc08a, 0xd545},
	{0xc08b, 0xd546},
	{0xc08c, 0xd547},
	{0xc08d, 0xd548},
	{0xc08e, 0xd549},
	{0xc08f, 0xd54a},
	{0xc090, 0xd54b},
	{0xc091, 0xd54e},
	{0xc092, 0xd550},
	{0xc093, 0xd552},
	{0xc094, 0xd553},
	{0xc095, 0xd554},
	{0xc096, 0xd555},
	{0xc097, 0xd556},
	{0xc098, 0xd557},
	{0xc099, 0xd55a},
	{0xc09a, 0xd55b},
	{0xc09b, 0xd55d},
	{0xc09c, 0xd55e},
	{0xc09d, 0xd55f},
	{0xc09e, 0xd561},
	{0xc09f, 0xd562},
	{0xc0a0, 0xd563},
	{0xc0a1, 0xc6e9},
	{0xc0a2, 0xc6ec},
	{0xc0a3, 0xc6f0},
	{0xc0a4, 0xc6f8},
	{0xc0a5, 0xc6f9},
	{0xc0a6, 0xc6fd},
	{0xc0a7, 0xc704},
	{0xc0a8, 0xc705},
	{0xc0a9, 0xc708},
	{0xc0aa, 0xc70c},
	{0xc0ab, 0xc714},
	{0xc0ac, 0xc715},
	{0xc0ad, 0xc717},
	{0xc0ae, 0xc719},
	{0xc0af, 0xc720},
	{0xc0b0, 0xc721},
	{0xc0b1, 0xc724},
	{0xc0b2, 0xc728},
	{0xc0b3, 0xc730},
	{0xc0b4, 0xc731},
	{0xc0b5, 0xc733},
	{0xc0b6, 0xc735},
	{0xc0b7, 0xc737},
	{0xc0b8, 0xc73c},
	{0xc0b9, 0xc73d},
	{0xc0ba, 0xc740},
	{0xc0bb, 0xc744},
	{0xc0bc, 0xc74a},
	{0xc0bd, 0xc74c},
	{0xc0be, 0xc74d},
	{0xc0bf, 0xc74f},
	{0xc0c0, 0xc751},
	{0xc0c1, 0xc752},
	{0xc0c2, 0xc753},
	{0xc0c3, 0xc754},
	{0xc0c4, 0xc755},
	{0xc0c5, 0xc756},
	{0xc0c6, 0xc757},
	{0xc0c7, 0xc758},
	{0xc0c8, 0xc75c},
	{0xc0c9, 0xc760},
	{0xc0ca, 0xc768},
	{0xc0cb, 0xc76b},
	{0xc0cc, 0xc774},
	{0xc0cd, 0xc775},
	{0xc0ce, 0xc778},
	{0xc0cf, 0xc77c},
	{0xc0d0, 0xc77d},
	{0xc0d1, 0xc77e},
	{0xc0d2, 0xc783},
	{0xc0d3, 0xc784},
	{0xc0d4, 0xc785},
	{0xc0d5, 0xc787},
	{0xc0d6, 0xc788},
	{0xc0d7, 0xc789},
	{0xc0d8, 0xc78a},
	{0xc0d9, 0xc78e},
	{0xc0da, 0xc790},
	{0xc0db, 0xc791},
	{0xc0dc, 0xc794},
	{0xc0dd, 0xc796},
	{0xc0de, 0xc797},
	{0xc0df, 0xc798},
	{0xc0e0, 0xc79a},
	{0xc0e1, 0xc7a0},
	{0xc0e2, 0xc7a1},
	{0xc0e3, 0xc7a3},
	{0xc0e4, 0xc7a4},
	{0xc0e5, 0xc7a5},
	{0xc0e6, 0xc7a6},
	{0xc0e7, 0xc7ac},
	{0xc0e8, 0xc7ad},
	{0xc0e9, 0xc7b0},
	{0xc0ea, 0xc7b4},
	{0xc0eb, 0xc7bc},
	{0xc0ec, 0xc7bd},
	{0xc0ed, 0xc7bf},
	{0xc0ee, 0xc7c0},
	{0xc0ef, 0xc7c1},
	{0xc0f0, 0xc7c8},
	{0xc0f1, 0xc7c9},
	{0xc0f2, 0xc7cc},
	{0xc0f3, 0xc7ce},
	{0xc0f4, 0xc7d0},
	{0xc0f5, 0xc7d8},
	{0xc0f6, 0xc7dd},
	{0xc0f7, 0xc7e4},
	{0xc0f8, 0xc7e8},
	{0xc0f9, 0xc7ec},
	{0xc0fa, 0xc800},
	{0xc0fb, 0xc801},
	{0xc0fc, 0xc804},
	{0xc0fd, 0xc808},
	{0xc0fe, 0xc80a},
	{0xc141, 0xd564},
	{0xc142, 0xd566},
	{0xc143, 0xd567},
	{0xc144, 0xd56a},
	{0xc145, 0xd56c},
	{0xc146, 0xd56e},
	{0xc147, 0xd56f},
	{0xc148, 0xd570},
	{0xc149, 0xd571},
	{0xc14a, 0xd572},
	{0xc14b, 0xd573},
	{0xc14c, 0xd576},
	{0xc14d, 0xd577},
	{0xc14e, 0xd579},
	{0xc14f, 0xd57a},
	{0xc150, 0xd57b},
	{0xc151, 0xd57d},
	{0xc152, 0xd57e},
	{0xc153, 0xd57f},
	{0xc154, 0xd580},
	{0xc155, 0xd581},
	{0xc156, 0xd582},
	{0xc157, 0xd583},
	{0xc158, 0xd586},
	{0xc159, 0xd58a},
	{0xc15a, 0xd58b},
	{0xc161, 0xd58c},
	{0xc162, 0xd58d},
	{0xc163, 0xd58e},
	{0xc164, 0xd58f},
	{0xc165, 0xd591},
	{0xc166, 0xd592},
	{0xc167, 0xd593},
	{0xc168, 0xd594},
	{0xc169, 0xd595},
	{0xc16a, 0xd596},
	{0xc16b, 0xd597},
	{0xc16c, 0xd598},
	{0xc16d, 0xd599},
	{0xc16e, 0xd59a},
	{0xc16f, 0xd59b},
	{0xc170, 0xd59c},
	{0xc171, 0xd59d},
	{0xc172, 0xd59e},
	{0xc173, 0xd59f},
	{0xc174, 0xd5a0},
	{0xc175, 0xd5a1},
	{0xc176, 0xd5a2},
	{0xc177, 0xd5a3},
	{0xc178, 0xd5a4},
	{0xc179, 0xd5a6},
	{0xc17a, 0xd5a7},
	{0xc181, 0xd5a8},
	{0xc182, 0xd5a9},
	{0xc183, 0xd5aa},
	{0xc184, 0xd5ab},
	{0xc185, 0xd5ac},
	{0xc186, 0xd5ad},
	{0xc187, 0xd5ae},
	{0xc188, 0xd5af},
	{0xc189, 0xd5b0},
	{0xc18a, 0xd5b1},
	{0xc18b, 0xd5b2},
	{0xc18c, 0xd5b3},
	{0xc18d, 0xd5b4},
	{0xc18e, 0xd5b5},
	{0xc18f, 0xd5b6},
	{0xc190, 0xd5b7},
	{0xc191, 0xd5b8},
	{0xc192, 0xd5b9},
	{0xc193, 0xd5ba},
	{0xc194, 0xd5bb},
	{0xc195, 0xd5bc},
	{0xc196, 0xd5bd},
	{0xc197, 0xd5be},
	{0xc198, 0xd5bf},
	{0xc199, 0xd5c0},
	{0xc19a, 0xd5c1},
	{0xc19b, 0xd5c2},
	{0xc19c, 0xd5c3},
	{0xc19d, 0xd5c4},
	{0xc19e, 0xd5c5},
	{0xc19f, 0xd5c6},
	{0xc1a0, 0xd5c7},
	{0xc1a1, 0xc810},
	{0xc1a2, 0xc811},
	{0xc1a3, 0xc813},
	{0xc1a4, 0xc815},
	{0xc1a5, 0xc816},
	{0xc1a6, 0xc81c},
	{0xc1a7, 0xc81d},
	{0xc1a8, 0xc820},
	{0xc1a9, 0xc824},
	{0xc1aa, 0xc82c},
	{0xc1ab, 0xc82d},
	{0xc1ac, 0xc82f},
	{0xc1ad, 0xc831},
	{0xc1ae, 0xc838},
	{0xc1af, 0xc83c},
	{0xc1b0, 0xc840},
	{0xc1b1, 0xc848},
	{0xc1b2, 0xc849},
	{0xc1b3, 0xc84c},
	{0xc1b4, 0xc84d},
	{0xc1b5, 0xc854},
	{0xc1b6, 0xc870},
	{0xc1b7, 0xc871},
	{0xc1b8, 0xc874},
	{0xc1b9, 0xc878},
	{0xc1ba, 0xc87a},
	{0xc1bb, 0xc880},
	{0xc1bc, 0xc881},
	{0xc1bd, 0xc883},
	{0xc1be, 0xc885},
	{0xc1bf, 0xc886},
	{0xc1c0, 0xc887},
	{0xc1c1, 0xc88b},
	{0xc1c2, 0xc88c},
	{0xc1c3, 0xc88d},
	{0xc1c4, 0xc894},
	{0xc1c5, 0xc89d},
	{0xc1c6, 0xc89f},
	{0xc1c7, 0xc8a1},
	{0xc1c8, 0xc8a8},
	{0xc1c9, 0xc8bc},
	{0xc1ca, 0xc8bd},
	{0xc1cb, 0xc8c4},
	{0xc1cc, 0xc8c8},
	{0xc1cd, 0xc8cc},
	{0xc1ce, 0xc8d4},
	{0xc1cf, 0xc8d5},
	{0xc1d0, 0xc8d7},
	{0xc1d1, 0xc8d9},
	{0xc1d2, 0xc8e0},
	{0xc1d3, 0xc8e1},
	{0xc1d4, 0xc8e4},
	{0xc1d5, 0xc8f5},
	{0xc1d6, 0xc8fc},
	{0xc1d7, 0xc8fd},
	{0xc1d8, 0xc900},
	{0xc1d9, 0xc904},
	{0xc1da, 0xc905},
	{0xc1db, 0xc906},
	{0xc1dc, 0xc90c},
	{0xc1dd, 0xc90d},
	{0xc1de, 0xc90f},
	{0xc1df, 0xc911},
	{0xc1e0, 0xc918},
	{0xc1e1, 0xc92c},
	{0xc1e2, 0xc934},
	{0xc1e3, 0xc950},
	{0xc1e4, 0xc951},
	{0xc1e5, 0xc954},
	{0xc1e6, 0xc958},
	{0xc1e7, 0xc960},
	{0xc1e8, 0xc961},
	{0xc1e9, 0xc963},
	{0xc1ea, 0xc96c},
	{0xc1eb, 0xc970},
	{0xc1ec, 0xc974},
	{0xc1ed, 0xc97c},
	{0xc1ee, 0xc988},
	{0xc1ef, 0xc989},
	{0xc1f0, 0xc98c},
	{0xc1f1, 0xc990},
	{0xc1f2, 0xc998},
	{0xc1f3, 0xc999},
	{0xc1f4, 0xc99b},
	{0xc1f5, 0xc99d},
	{0xc1f6, 0xc9c0},
	{0xc1f7, 0xc9c1},
	{0xc1f8, 0xc9c4},
	{0xc1f9, 0xc9c7},
	{0xc1fa, 0xc9c8},
	{0xc1fb, 0xc9ca},
	{0xc1fc, 0xc9d0},
	{0xc1fd, 0xc9d1},
	{0xc1fe, 0xc9d3},
	{0xc241, 0xd5ca},
	{0xc242, 0xd5cb},
	{0xc243, 0xd5cd},
	{0xc244, 0xd5ce},
	{0xc245, 0xd5cf},
	{0xc246, 0xd5d1},
	{0xc247, 0xd5d3},
	{0xc248, 0xd5d4},
	{0xc249, 0xd5d5},
	{0xc24a, 0xd5d6},
	{0xc24b, 0xd5d7},
	{0xc24c, 0xd5da},
	{0xc24d, 0xd5dc},
	{0xc24e, 0xd5de},
	{0xc24f, 0xd5df},
	{0xc250, 0xd5e0},
	{0xc251, 0xd5e1},
	{0xc252, 0xd5e2},
	{0xc253, 0xd5e3},
	{0xc254, 0xd5e6},
	{0xc255, 0xd5e7},
	{0xc256, 0xd5e9},
	{0xc257, 0xd5ea},
	{0xc258, 0xd5eb},
	{0xc259, 0xd5ed},
	{0xc25a, 0xd5ee},
	{0xc261, 0xd5ef},
	{0xc262, 0xd5f0},
	{0xc263, 0xd5f1},
	{0xc264, 0xd5f2},
	{0xc265, 0xd5f3},
	{0xc266, 0xd5f6},
	{0xc267, 0xd5f8},
	{0xc268, 0xd5fa},
	{0xc269, 0xd5fb},
	{0xc26a, 0xd5fc},
	{0xc26b, 0xd5fd},
	{0xc26c, 0xd5fe},
	{0xc26d, 0xd5ff},
	{0xc26e, 0xd602},
	{0xc26f, 0xd603},
	{0xc270, 0xd605},
	{0xc271, 0xd606},
	{0xc272, 0xd607},
	{0xc273, 0xd609},
	{0xc274, 0xd60a},
	{0xc275, 0xd60b},
	{0xc276, 0xd60c},
	{0xc277, 0xd60d},
	{0xc278, 0xd60e},
	{0xc279, 0xd60f},
	{0xc27a, 0xd612},
	{0xc281, 0xd616},
	{0xc282, 0xd617},
	{0xc283, 0xd618},
	{0xc284, 0xd619},
	{0xc285, 0xd61a},
	{0xc286, 0xd61b},
	{0xc287, 0xd61d},
	{0xc288, 0xd61e},
	{0xc289, 0xd61f},
	{0xc28a, 0xd621},
	{0xc28b, 0xd622},
	{0xc28c, 0xd623},
	{0xc28d, 0xd625},
	{0xc28e, 0xd626},
	{0xc28f, 0xd627},
	{0xc290, 0xd628},
	{0xc291, 0xd629},
	{0xc292, 0xd62a},
	{0xc293, 0xd62b},
	{0xc294, 0xd62c},
	{0xc295, 0xd62e},
	{0xc296, 0xd62f},
	{0xc297, 0xd630},
	{0xc298, 0xd631},
	{0xc299, 0xd632},
	{0xc29a, 0xd633},
	{0xc29b, 0xd634},
	{0xc29c, 0xd635},
	{0xc29d, 0xd636},
	{0xc29e, 0xd637},
	{0xc29f, 0xd63a},
	{0xc2a0, 0xd63b},
	{0xc2a1, 0xc9d5},
	{0xc2a2, 0xc9d6},
	{0xc2a3, 0xc9d9},
	{0xc2a4, 0xc9da},
	{0xc2a5, 0xc9dc},
	{0xc2a6, 0xc9dd},
	{0xc2a7, 0xc9e0},
	{0xc2a8, 0xc9e2},
	{0xc2a9, 0xc9e4},
	{0xc2aa, 0xc9e7},
	{0xc2ab, 0xc9ec},
	{0xc2ac, 0xc9ed},
	{0xc2ad, 0xc9ef},
	{0xc2ae, 0xc9f0},
	{0xc2af, 0xc9f1},
	{0xc2b0, 0xc9f8},
	{0xc2b1, 0xc9f9},
	{0xc2b2, 0xc9fc},
	{0xc2b3, 0xca00},
	{0xc2b4, 0xca08},
	{0xc2b5, 0xca09},
	{0xc2b6, 0xca0b},
	{0xc2b7, 0xca0c},
	{0xc2b8, 0xca0d},
	{0xc2b9, 0xca14},
	{0xc2ba, 0xca18},
	{0xc2bb, 0xca29},
	{0xc2bc, 0xca4c},
	{0xc2bd, 0xca4d},
	{0xc2be, 0xca50},
	{0xc2bf, 0xca54},
	{0xc2c0, 0xca5c},
	{0xc2c1, 0xca5d},
	{0xc2c2, 0xca5f},
	{0xc2c3, 0xca60},
	{0xc2c4, 0xca61},
	{0xc2c5, 0xca68},
	{0xc2c6, 0xca7d},
	{0xc2c7, 0xca84},
	{0xc2c8, 0xca98},
	{0xc2c9, 0xcabc},
	{0xc2ca, 0xcabd},
	{0xc2cb, 0xcac0},
	{0xc2cc, 0xcac4},
	{0xc2cd, 0xcacc},
	{0xc2ce, 0xcacd},
	{0xc2cf, 0xcacf},
	{0xc2d0, 0xcad1},
	{0xc2d1, 0xcad3},
	{0xc2d2, 0xcad8},
	{0xc2d3, 0xcad9},
	{0xc2d4, 0xcae0},
	{0xc2d5, 0xcaec},
	{0xc2d6, 0xcaf4},
	{0xc2d7, 0xcb08},
	{0xc2d8, 0xcb10},
	{0xc2d9, 0xcb14},
	{0xc2da, 0xcb18},
	{0xc2db, 0xcb20},
	{0xc2dc, 0xcb21},
	{0xc2dd, 0xcb41},
	{0xc2de, 0xcb48},
	{0xc2df, 0xcb49},
	{0xc2e0, 0xcb4c},
	{0xc2e1, 0xcb50},
	{0xc2e2, 0xcb58},
	{0xc2e3, 0xcb59},
	{0xc2e4, 0xcb5d},
	{0xc2e5, 0xcb64},
	{0xc2e6, 0xcb78},
	{0xc2e7, 0xcb79},
	{0xc2e8, 0xcb9c},
	{0xc2e9, 0xcbb8},
	{0xc2ea, 0xcbd4},
	{0xc2eb, 0xcbe4},
	{0xc2ec, 0xcbe7},
	{0xc2ed, 0xcbe9},
	{0xc2ee, 0xcc0c},
	{0xc2ef, 0xcc0d},
	{0xc2f0, 0xcc10},
	{0xc2f1, 0xcc14},
	{0xc2f2, 0xcc1c},
	{0xc2f3, 0xcc1d},
	{0xc2f4, 0xcc21},
	{0xc2f5, 0xcc22},
	{0xc2f6, 0xcc27},
	{0xc2f7, 0xcc28},
	{0xc2f8, 0xcc29},
	{0xc2f9, 0xcc2c},
	{0xc2fa, 0xcc2e},
	{0xc2fb, 0xcc30},
	{0xc2fc, 0xcc38},
	{0xc2fd, 0xcc39},
	{0xc2fe, 0xcc3b},
	{0xc341, 0xd63d},
	{0xc342, 0xd63e},
	{0xc343, 0xd63f},
	{0xc344, 0xd641},
	{0xc345, 0xd642},
	{0xc346, 0xd643},
	{0xc347, 0xd644},
	{0xc348, 0xd646},
	{0xc349, 0xd647},
	{0xc34a, 0xd64a},
	{0xc34b, 0xd64c},
	{0xc34c, 0xd64e},
	{0xc34d, 0xd64f},
	{0xc34e, 0xd650},
	{0xc34f, 0xd652},
	{0xc350, 0xd653},
	{0xc351, 0xd656},
	{0xc352, 0xd657},
	{0xc353, 0xd659},
	{0xc354, 0xd65a},
	{0xc355, 0xd65b},
	{0xc356, 0xd65d},
	{0xc357, 0xd65e},
	{0xc358, 0xd65f},
	{0xc359, 0xd660},
	{0xc35a, 0xd661},
	{0xc361, 0xd662},
	{0xc362, 0xd663},
	{0xc363, 0xd664},
	{0xc364, 0xd665},
	{0xc365, 0xd666},
	{0xc366, 0xd668},
	{0xc367, 0xd66a},
	{0xc368, 0xd66b},
	{0xc369, 0xd66c},
	{0xc36a, 0xd66d},
	{0xc36b, 0xd66e},
	{0xc36c, 0xd66f},
	{0xc36d, 0xd672},
	{0xc36e, 0xd673},
	{0xc36f, 0xd675},
	{0xc370, 0xd676},
	{0xc371, 0xd677},
	{0xc372, 0xd678},
	{0xc373, 0xd679},
	{0xc374, 0xd67a},
	{0xc375, 0xd67b},
	{0xc376, 0xd67c},
	{0xc377, 0xd67d},
	{0xc378, 0xd67e},
	{0xc379, 0xd67f},
	{0xc37a, 0xd680},
	{0xc381, 0xd681},
	{0xc382, 0xd682},
	{0xc383, 0xd684},
	{0xc384, 0xd686},
	{0xc385, 0xd687},
	{0xc386, 0xd688},
	{0xc387, 0xd689},
	{0xc388, 0xd68a},
	{0xc389, 0xd68b},
	{0xc38a, 0xd68e},
	{0xc38b, 0xd68f},
	{0xc38c, 0xd691},
	{0xc38d, 0xd692},
	{0xc38e, 0xd693},
	{0xc38f, 0xd695},
	{0xc390, 0xd696},
	{0xc391, 0xd697},
	{0xc392, 0xd698},
	{0xc393, 0xd699},
	{0xc394, 0xd69a},
	{0xc395, 0xd69b},
	{0xc396, 0xd69c},
	{0xc397, 0xd69e},
	{0xc398, 0xd6a0},
	{0xc399, 0xd6a2},
	{0xc39a, 0xd6a3},
	{0xc39b, 0xd6a4},
	{0xc39c, 0xd6a5},
	{0xc39d, 0xd6a6},
	{0xc39e, 0xd6a7},
	{0xc39f, 0xd6a9},
	{0xc3a0, 0xd6aa},
	{0xc3a1, 0xcc3c},
	{0xc3a2, 0xcc3d},
	{0xc3a3, 0xcc3e},
	{0xc3a4, 0xcc44},
	{0xc3a5, 0xcc45},
	{0xc3a6, 0xcc48},
	{0xc3a7, 0xcc4c},
	{0xc3a8, 0xcc54},
	{0xc3a9, 0xcc55},
	{0xc3aa, 0xcc57},
	{0xc3ab, 0xcc58},
	{0xc3ac, 0xcc59},
	{0xc3ad, 0xcc60},
	{0xc3ae, 0xcc64},
	{0xc3af, 0xcc66},
	{0xc3b0, 0xcc68},
	{0xc3b1, 0xcc70},
	{0xc3b2, 0xcc75},
	{0xc3b3, 0xcc98},
	{0xc3b4, 0xcc99},
	{0xc3b5, 0xcc9c},
	{0xc3b6, 0xcca0},
	{0xc3b7, 0xcca8},
	{0xc3b8, 0xcca9},
	{0xc3b9, 0xccab},
	{0xc3ba, 0xccac},
	{0xc3bb, 0xccad},
	{0xc3bc, 0xccb4},
	{0xc3bd, 0xccb5},
	{0xc3be, 0xccb8},
	{0xc3bf, 0xccbc},
	{0xc3c0, 0xccc4},
	{0xc3c1, 0xccc5},
	{0xc3c2, 0xccc7},
	{0xc3c3, 0xccc9},
	{0xc3c4, 0xccd0},
	{0xc3c5, 0xccd4},
	{0xc3c6, 0xcce4},
	{0xc3c7, 0xccec},
	{0xc3c8, 0xccf0},
	{0xc3c9, 0xcd01},
	{0xc3ca, 0xcd08},
	{0xc3cb, 0xcd09},
	{0xc3cc, 0xcd0c},
	{0xc3cd, 0xcd10},
	{0xc3ce, 0xcd18},
	{0xc3cf, 0xcd19},
	{0xc3d0, 0xcd1b},
	{0xc3d1, 0xcd1d},
	{0xc3d2, 0xcd24},
	{0xc3d3, 0xcd28},
	{0xc3d4, 0xcd2c},
	{0xc3d5, 0xcd39},
	{0xc3d6, 0xcd5c},
	{0xc3d7, 0xcd60},
	{0xc3d8, 0xcd64},
	{0xc3d9, 0xcd6c},
	{0xc3da, 0xcd6d},
	{0xc3db, 0xcd6f},
	{0xc3dc, 0xcd71},
	{0xc3dd, 0xcd78},
	{0xc3de, 0xcd88},
	{0xc3df, 0xcd94},
	{0xc3e0, 0xcd95},
	{0xc3e1, 0xcd98},
	{0xc3e2, 0xcd9c},
	{0xc3e3, 0xcda4},
	{0xc3e4, 0xcda5},
	{0xc3e5, 0xcda7},
	{0xc3e6, 0xcda9},
	{0xc3e7, 0xcdb0},
	{0xc3e8, 0xcdc4},
	{0xc3e9, 0xcdcc},
	{0xc3ea, 0xcdd0},
	{0xc3eb, 0xcde8},
	{0xc3ec, 0xcdec},
	{0xc3ed, 0xcdf0},
	{0xc3ee, 0xcdf8},
	{0xc3ef, 0xcdf9},
	{0xc3f0, 0xcdfb},
	{0xc3f1, 0xcdfd},
	{0xc3f2, 0xce04},
	{0xc3f3, 0xce08},
	{0xc3f4, 0xce0c},
	{0xc3f5, 0xce14},
	{0xc3f6, 0xce19},
	{0xc3f7, 0xce20},
	{0xc3f8, 0xce21},
	{0xc3f9, 0xce24},
	{0xc3fa, 0xce28},
	{0xc3fb, 0xce30},
	{0xc3fc, 0xce31},
	{0xc3fd, 0xce33},
	{0xc3fe, 0xce35},
	{0xc441, 0xd6ab},
	{0xc442, 0xd6ad},
	{0xc443, 0xd6ae},
	{0xc444, 0xd6af},
	{0xc445, 0xd6b1},
	{0xc446, 0xd6b2},
	{0xc447, 0xd6b3},
	{0xc448, 0xd6b4},
	{0xc449, 0xd6b5},
	{0xc44a, 0xd6b6},
	{0xc44b, 0xd6b7},
	{0xc44c, 0xd6b8},
	{0xc44d, 0xd6ba},
	{0xc44e, 0xd6bc},
	{0xc44f, 0xd6bd},
	{0xc450, 0xd6be},
	{0xc451, 0xd6bf},
	{0xc452, 0xd6c0},
	{0xc453, 0xd6c1},
	{0xc454, 0xd6c2},
	{0xc455, 0xd6c3},
	{0xc456, 0xd6c6},
	{0xc457, 0xd6c7},
	{0xc458, 0xd6c9},
	{0xc459, 0xd6ca},
	{0xc45a, 0xd6cb},
	{0xc461, 0xd6cd},
	{0xc462, 0xd6ce},
	{0xc463, 0xd6cf},
	{0xc464, 0xd6d0},
	{0xc465, 0xd6d2},
	{0xc466, 0xd6d3},
	{0xc467, 0xd6d5},
	{0xc468, 0xd6d6},
	{0xc469, 0xd6d8},
	{0xc46a, 0xd6da},
	{0xc46b, 0xd6db},
	{0xc46c, 0xd6dc},
	{0xc46d, 0xd6dd},
	{0xc46e, 0xd6de},
	{0xc46f, 0xd6df},
	{0xc470, 0xd6e1},
	{0xc471, 0xd6e2},
	{0xc472, 0xd6e3},
	{0xc473, 0xd6e5},
	{0xc474, 0xd6e6},
	{0xc475, 0xd6e7},
	{0xc476, 0xd6e9},
	{0xc477, 0xd6ea},
	{0xc478, 0xd6eb},
	{0xc479, 0xd6ec},
	{0xc47a, 0xd6ed},
	{0xc481, 0xd6ee},
	{0xc482, 0xd6ef},
	{0xc483, 0xd6f1},
	{0xc484, 0xd6f2},
	{0xc485, 0xd6f3},
	{0xc486, 0xd6f4},
	{0xc487, 0xd6f6},
	{0xc488, 0xd6f7},
	{0xc489, 0xd6f8},
	{0xc48a, 0xd6f9},
	{0xc48b, 0xd6fa},
	{0xc48c, 0xd6fb},
	{0xc48d, 0xd6fe},
	{0xc48e, 0xd6ff},
	{0xc48f, 0xd701},
	{0xc490, 0xd702},
	{0xc491, 0xd703},
	{0xc492, 0xd705},
	{0xc493, 0xd706},
	{0xc494, 0xd707},
	{0xc495, 0xd708},
	{0xc496, 0xd709},
	{0xc497, 0xd70a},
	{0xc498, 0xd70b},
	{0xc499, 0xd70c},
	{0xc49a, 0xd70d},
	{0xc49b, 0xd70e},
	{0xc49c, 0xd70f},
	{0xc49d, 0xd710},
	{0xc49e, 0xd712},
	{0xc49f, 0xd713},
	{0xc4a0, 0xd714},
	{0xc4a1, 0xce58},
	{0xc4a2, 0xce59},
	{0xc4a3, 0xce5c},
	{0xc4a4, 0xce5f},
	{0xc4a5, 0xce60},
	{0xc4a6, 0xce61},
	{0xc4a7, 0xce68},
	{0xc4a8, 0xce69},
	{0xc4a9, 0xce6b},
	{0xc4aa, 0xce6d},
	{0xc4ab, 0xce74},
	{0xc4ac, 0xce75},
	{0xc4ad, 0xce78},
	{0xc4ae, 0xce7c},
	{0xc4af, 0xce84},
	{0xc4b0, 0xce85},
	{0xc4b1, 0xce87},
	{0xc4b2, 0xce89},
	{0xc4b3, 0xce90},
	{0xc4b4, 0xce91},
	{0xc4b5, 0xce94},
	{0xc4b6, 0xce98},
	{0xc4b7, 0xcea0},
	{0xc4b8, 0xcea1},
	{0xc4b9, 0xcea3},
	{0xc4ba, 0xcea4},
	{0xc4bb, 0xcea5},
	{0xc4bc, 0xceac},
	{0xc4bd, 0xcead},
	{0xc4be, 0xcec1},
	{0xc4bf, 0xcee4},
	{0xc4c0, 0xcee5},
	{0xc4c1, 0xcee8},
	{0xc4c2, 0xceeb},
	{0xc4c3, 0xceec},
	{0xc4c4, 0xcef4},
	{0xc4c5, 0xcef5},
	{0xc4c6, 0xcef7},
	{0xc4c7, 0xcef8},
	{0xc4c8, 0xcef9},
	{0xc4c9, 0xcf00},
	{0xc4ca, 0xcf01},
	{0xc4cb, 0xcf04},
	{0xc4cc, 0xcf08},
	{0xc4cd, 0xcf10},
	{0xc4ce, 0xcf11},
	{0xc4cf, 0xcf13},
	{0xc4d0, 0xcf15},
	{0xc4d1, 0xcf1c},
	{0xc4d2, 0xcf20},
	{0xc4d3, 0xcf24},
	{0xc4d4, 0xcf2c},
	{0xc4d5, 0xcf2d},
	{0xc4d6, 0xcf2f},
	{0xc4d7, 0xcf30},
	{0xc4d8, 0xcf31},
	{0xc4d9, 0xcf38},
	{0xc4da, 0xcf54},
	{0xc4db, 0xcf55},
	{0xc4dc, 0xcf58},
	{0xc4dd, 0xcf5c},
	{0xc4de, 0xcf64},
	{0xc4df, 0xcf65},
	{0xc4e0, 0xcf67},
	{0xc4e1, 0xcf69},
	{0xc4e2, 0xcf70},
	{0xc4e3, 0xcf71},
	{0xc4e4, 0xcf74},
	{0xc4e5, 0xcf78},
	{0xc4e6, 0xcf80},
	{0xc4e7, 0xcf85},
	{0xc4e8, 0xcf8c},
	{0xc4e9, 0xcfa1},
	{0xc4ea, 0xcfa8},
	{0xc4eb, 0xcfb0},
	{0xc4ec, 0xcfc4},
	{0xc4ed, 0xcfe0},
	{0xc4ee, 0xcfe1},
	{0xc4ef, 0xcfe4},
	{0xc4f0, 0xcfe8},
	{0xc4f1, 0xcff0},
	{0xc4f2, 0xcff1},
	{0xc4f3, 0xcff3},
	{0xc4f4, 0xcff5},
	{0xc4f5, 0xcffc},
	{0xc4f6, 0xd000},
	{0xc4f7, 0xd004},
	{0xc4f8, 0xd011},
	{0xc4f9, 0xd018},
	{0xc4fa, 0xd02d},
	{0xc4fb, 0xd034},
	{0xc4fc, 0xd035},
	{0xc4fd, 0xd038},
	{0xc4fe, 0xd03c},
	{0xc541, 0xd715},
	{0xc542, 0xd716},
	{0xc543, 0xd717},
	{0xc544, 0xd71a},
	{0xc545, 0xd71b},
	{0xc546, 0xd71d},
	{0xc547, 0xd71e},
	{0xc548, 0xd71f},
	{0xc549, 0xd721},
	{0xc54a, 0xd722},
	{0xc54b, 0xd723},
	{0xc54c, 0xd724},
	{0xc54d, 0xd725},
	{0xc54e, 0xd726},
	{0xc54f, 0xd727},
	{0xc550, 0xd72a},
	{0xc551, 0xd72c},
	{0xc552, 0xd72e},
	{0xc553, 0xd72f},
	{0xc554, 0xd730},
	{0xc555, 0xd731},
	{0xc556, 0xd732},
	{0xc557, 0xd733},
	{0xc558, 0xd736},
	{0xc559, 0xd737},
	{0xc55a, 0xd739},
	{0xc561, 0xd73a},
	{0xc562, 0xd73b},
	{0xc563, 0xd73d},
	{0xc564, 0xd73e},
	{0xc565, 0xd73f},
	{0xc566, 0xd740},
	{0xc567, 0xd741},
	{0xc568, 0xd742},
	{0xc569, 0xd743},
	{0xc56a, 0xd745},
	{0xc56b, 0xd746},
	{0xc56c, 0xd748},
	{0xc56d, 0xd74a},
	{0xc56e, 0xd74b},
	{0xc56f, 0xd74c},
	{0xc570, 0xd74d},
	{0xc571, 0xd74e},
	{0xc572, 0xd74f},
	{0xc573, 0xd752},
	{0xc574, 0xd753},
	{0xc575, 0xd755},
	{0xc576, 0xd75a},
	{0xc577, 0xd75b},
	{0xc578, 0xd75c},
	{0xc579, 0xd75d},
	{0xc57a, 0xd75e},
	{0xc581, 0xd75f},
	{0xc582, 0xd762},
	{0xc583, 0xd764},
	{0xc584, 0xd766},
	{0xc585, 0xd767},
	{0xc586, 0xd768},
	{0xc587, 0xd76a},
	{0xc588, 0xd76b},
	{0xc589, 0xd76d},
	{0xc58a, 0xd76e},
	{0xc58b, 0xd76f},
	{0xc58c, 0xd771},
	{0xc58d, 0xd772},
	{0xc58e, 0xd773},
	{0xc58f, 0xd775},
	{0xc590, 0xd776},
	{0xc591, 0xd777},
	{0xc592, 0xd778},
	{0xc593, 0xd779},
	{0xc594, 0xd77a},
	{0xc595, 0xd77b},
	{0xc596, 0xd77e},
	{0xc597, 0xd77f},
	{0xc598, 0xd780},
	{0xc599, 0xd782},
	{0xc59a, 0xd783},
	{0xc59b, 0xd784},
	{0xc59c, 0xd785},
	{0xc59d, 0xd786},
	{0xc59e, 0xd787},
	{0xc59f, 0xd78a},
	{0xc5a0, 0xd78b},
	{0xc5a1, 0xd044},
	{0xc5a2, 0xd045},
	{0xc5a3, 0xd047},
	{0xc5a4, 0xd049},
	{0xc5a5, 0xd050},
	{0xc5a6, 0xd054},
	{0xc5a7, 0xd058},
	{0xc5a8, 0xd060},
	{0xc5a9, 0xd06c},
	{0xc5aa, 0xd06d},
	{0xc5ab, 0xd070},
	{0xc5ac, 0xd074},
	{0xc5ad, 0xd07c},
	{0xc5ae, 0xd07d},
	{0xc5af, 0xd081},
	{0xc5b0, 0xd0a4},
	{0xc5b1, 0xd0a5},
	{0xc5b2, 0xd0a8},
	{0xc5b3, 0xd0ac},
	{0xc5b4, 0xd0b4},
	{0xc5b5, 0xd0b5},
	{0xc5b6, 0xd0b7},
	{0xc5b7, 0xd0b9},
	{0xc5b8, 0xd0c0},
	{0xc5b9, 0xd0c1},
	{0xc5ba, 0xd0c4},
	{0xc5bb, 0xd0c8},
	{0xc5bc, 0xd0c9},
	{0xc5bd, 0xd0d0},
	{0xc5be, 0xd0d1},
	{0xc5bf, 0xd0d3},
	{0xc5c0, 0xd0d4},
	{0xc5c1, 0xd0d5},
	{0xc5c2, 0xd0dc},
	{0xc5c3, 0xd0dd},
	{0xc5c4, 0xd0e0},
	{0xc5c5, 0xd0e4},
	{0xc5c6, 0xd0ec},
	{0xc5c7, 0xd0ed},
	{0xc5c8, 0xd0ef},
	{0xc5c9, 0xd0f0},
	{0xc5ca, 0xd0f1},
	{0xc5cb, 0xd0f8},
	{0xc5cc, 0xd10d},
	{0xc5cd, 0xd130},
	{0xc5ce, 0xd131},
	{0xc5cf, 0xd134},
	{0xc5d0, 0xd138},
	{0xc5d1, 0xd13a},
	{0xc5d2, 0xd140},
	{0xc5d3, 0xd141},
	{0xc5d4, 0xd143},
	{0xc5d5, 0xd144},
	{0xc5d6, 0xd145},
	{0xc5d7, 0xd14c},
	{0xc5d8, 0xd14d},
	{0xc5d9, 0xd150},
	{0xc5da, 0xd154},
	{0xc5db, 0xd15c},
	{0xc5dc, 0xd15d},
	{0xc5dd, 0xd15f},
	{0xc5de, 0xd161},
	{0xc5df, 0xd168},
	{0xc5e0, 0xd16c},
	{0xc5e1, 0xd17c},
	{0xc5e2, 0xd184},
	{0xc5e3, 0xd188},
	{0xc5e4, 0xd1a0},
	{0xc5e5, 0xd1a1},
	{0xc5e6, 0xd1a4},
	{0xc5e7, 0xd1a8},
	{0xc5e8, 0xd1b0},
	{0xc5e9, 0xd1b1},
	{0xc5ea, 0xd1b3},
	{0xc5eb, 0xd1b5},
	{0xc5ec, 0xd1ba},
	{0xc5ed, 0xd1bc},
	{0xc5ee, 0xd1c0},
	{0xc5ef, 0xd1d8},
	{0xc5f0, 0xd1f4},
	{0xc5f1, 0xd1f8},
	{0xc5f2, 0xd207},
	{0xc5f3, 0xd209},
	{0xc5f4, 0xd210},
	{0xc5f5, 0xd22c},
	{0xc5f6, 0xd22d},
	{0xc5f7, 0xd230},
	{0xc5f8, 0xd234},
	{0xc5f9, 0xd23c},
	{0xc5fa, 0xd23d},
	{0xc5fb, 0xd23f},
	{0xc5fc, 0xd241},
	{0xc5fd, 0xd248},
	{0xc5fe, 0xd25c},
	{0xc641, 0xd78d},
	{0xc642, 0xd78e},
	{0xc643, 0xd78f},
	{0xc644, 0xd791},
	{0xc645, 0xd792},
	{0xc646, 0xd793},
	{0xc647, 0xd794},
	{0xc648, 0xd795},
	{0xc649, 0xd796},
	{0xc64a, 0xd797},
	{0xc64b, 0xd79a},
	{0xc64c, 0xd79c},
	{0xc64d, 0xd79e},
	{0xc64e, 0xd79f},
	{0xc64f, 0xd7a0},
	{0xc650, 0xd7a1},
	{0xc651, 0xd7a2},
	{0xc652, 0xd7a3},
	{0xc6a1, 0xd264},
	{0xc6a2, 0xd280},
	{0xc6a3, 0xd281},
	{0xc6a4, 0xd284},
	{0xc6a5, 0xd288},
	{0xc6a6, 0xd290},
	{0xc6a7, 0xd291},
	{0xc6a8, 0xd295},
	{0xc6a9, 0xd29c},
	{0xc6aa, 0xd2a0},
	{0xc6ab, 0xd2a4},
	{0xc6ac, 0xd2ac},
	{0xc6ad, 0xd2b1},
	{0xc6ae, 0xd2b8},
	{0xc6af, 0xd2b9},
	{0xc6b0, 0xd2bc},
	{0xc6b1, 0xd2bf},
	{0xc6b2, 0xd2c0},
	{0xc6b3, 0xd2c2},
	{0xc6b4, 0xd2c8},
	{0xc6b5, 0xd2c9},
	{0xc6b6, 0xd2cb},
	{0xc6b7, 0xd2d4},
	{0xc6b8, 0xd2d8},
	{0xc6b9, 0xd2dc},
	{0xc6ba, 0xd2e4},
	{0xc6bb, 0xd2e5},
	{0xc6bc, 0xd2f0},
	{0xc6bd, 0xd2f1},
	{0xc6be, 0xd2f4},
	{0xc6bf, 0xd2f8},
	{0xc6c0, 0xd300},
	{0xc6c1, 0xd301},
	{0xc6c2, 0xd303},
	{0xc6c3, 0xd305},
	{0xc6c4, 0xd30c},
	{0xc6c5, 0xd30d},
	{0xc6c6, 0xd30e},
	{0xc6c7, 0xd310},
	{0xc6c8, 0xd314},
	{0xc6c9, 0xd316},
	{0xc6ca, 0xd31c},
	{0xc6cb, 0xd31d},
	{0xc6cc, 0xd31f},
	{0xc6cd, 0xd320},
	{0xc6ce, 0xd321},
	{0xc6cf, 0xd325},
	{0xc6d0, 0xd328},
	{0xc6d1, 0xd329},
	{0xc6d2, 0xd32c},
	{0xc6d3, 0xd330},
	{0xc6d4, 0xd338},
	{0xc6d5, 0xd339},
	{0xc6d6, 0xd33b},
	{0xc6d7, 0xd33c},
	{0xc6d8, 0xd33d},
	{0xc6d9, 0xd344},
	{0xc6da, 0xd345},
	{0xc6db, 0xd37c},
	{0xc6dc, 0xd37d},
	{0xc6dd, 0xd380},
	{0xc6de, 0xd384},
	{0xc6df, 0xd38c},
	{0xc6e0, 0xd38d},
	{0xc6e1, 0xd38f},
	{0xc6e2, 0xd390},
	{0xc6e3, 0xd391},
	{0xc6e4, 0xd398},
	{0xc6e5, 0xd399},
	{0xc6e6, 0xd39c},
	{0xc6e7, 0xd3a0},
	{0xc6e8, 0xd3a8},
	{0xc6e9, 0xd3a9},
	{0xc6ea, 0xd3ab},
	{0xc6eb, 0xd3ad},
	{0xc6ec, 0xd3b4},
	{0xc6ed, 0xd3b8},
	{0xc6ee, 0xd3bc},
	{0xc6ef, 0xd3c4},
	{0xc6f0, 0xd3c5},
	{0xc6f1, 0xd3c8},
	{0xc6f2, 0xd3c9},
	{0xc6f3, 0xd3d0},
	{0xc6f4, 0xd3d8},
	{0xc6f5, 0xd3e1},
	{0xc6f6, 0xd3e3},
	{0xc6f7, 0xd3ec},
	{0xc6f8, 0xd3ed},
	{0xc6f9, 0xd3f0},
	{0xc6fa, 0xd3f4},
	{0xc6fb, 0xd3fc},
	{0xc6fc, 0xd3fd},
	{0xc6fd, 0xd3ff},
	{0xc6fe, 0xd401},
	{0xc7a1, 0xd408},
	{0xc7a2, 0xd41d},
	{0xc7a3, 0xd440},
	{0xc7a4, 0xd444},
	{0xc7a5, 0xd45c},
	{0xc7a6, 0xd460},
	{0xc7a7, 0xd464},
	{0xc7a8, 0xd46d},
	{0xc7a9, 0xd46f},
	{0xc7aa, 0xd478},
	{0xc7ab, 0xd479},
	{0xc7ac, 0xd47c},
	{0xc7ad, 0xd47f},
	{0xc7ae, 0xd480},
	{0xc7af, 0xd482},
	{0xc7b0, 0xd488},
	{0xc7b1, 0xd489},
	{0xc7b2, 0xd48b},
	{0xc7b3, 0xd48d},
	{0xc7b4, 0xd494},
	{0xc7b5, 0xd4a9},
	{0xc7b6, 0xd4cc},
	{0xc7b7, 0xd4d0},
	{0xc7b8, 0xd4d4},
	{0xc7b9, 0xd4dc},
	{0xc7ba, 0xd4df},
	{0xc7bb, 0xd4e8},
	{0xc7bc, 0xd4ec},
	{0xc7bd, 0xd4f0},
	{0xc7be, 0xd4f8},
	{0xc7bf, 0xd4fb},
	{0xc7c0, 0xd4fd},
	{0xc7c1, 0xd504},
	{0xc7c2, 0xd508},
	{0xc7c3, 0xd50c},
	{0xc7c4, 0xd514},
	{0xc7c5, 0xd515},
	{0xc7c6, 0xd517},
	{0xc7c7, 0xd53c},
	{0xc7c8, 0xd53d},
	{0xc7c9, 0xd540},
	{0xc7ca, 0xd544},
	{0xc7cb, 0xd54c},
	{0xc7cc, 0xd54d},
	{0xc7cd, 0xd54f},
	{0xc7ce, 0xd551},
	{0xc7cf, 0xd558},
	{0xc7d0, 0xd559},
	{0xc7d1, 0xd55c},
	{0xc7d2, 0xd560},
	{0xc7d3, 0xd565},
	{0xc7d4, 0xd568},
	{0xc7d5, 0xd569},
	{0xc7d6, 0xd56b},
	{0xc7d7, 0xd56d},
	{0xc7d8, 0xd574},
	{0xc7d9, 0xd575},
	{0xc7da, 0xd578},
	{0xc7db, 0xd57c},
	{0xc7dc, 0xd584},
	{0xc7dd, 0xd585},
	{0xc7de, 0xd587},
	{0xc7df, 0xd588},
	{0xc7e0, 0xd589},
	{0xc7e1, 0xd590},
	{0xc7e2, 0xd5a5},
	{0xc7e3, 0xd5c8},
	{0xc7e4, 0xd5c9},
	{0xc7e5, 0xd5cc},
	{0xc7e6, 0xd5d0},
	{0xc7e7, 0xd5d2},
	{0xc7e8, 0xd5d8},
	{0xc7e9, 0xd5d9},
	{0xc7ea, 0xd5db},
	{0xc7eb, 0xd5dd},
	{0xc7ec, 0xd5e4},
	{0xc7ed, 0xd5e5},
	{0xc7ee, 0xd5e8},
	{0xc7ef, 0xd5ec},
	{0xc7f0, 0xd5f4},
	{0xc7f1, 0xd5f5},
	{0xc7f2, 0xd5f7},
	{0xc7f3, 0xd5f9},
	{0xc7f4, 0xd600},
	{0xc7f5, 0xd601},
	{0xc7f6, 0xd604},
	{0xc7f7, 0xd608},
	{0xc7f8, 0xd610},
	{0xc7f9, 0xd611},
	{0xc7fa, 0xd613},
	{0xc7fb, 0xd614},
	{0xc7fc, 0xd615},
	{0xc7fd, 0xd61c},
	{0xc7fe, 0xd620},
	{0xc8a1, 0xd624},
	{0xc8a2, 0xd62d},
	{0xc8a3, 0xd638},
	{0xc8a4, 0xd639},
	{0xc8a5, 0xd63c},
	{0xc8a6, 0xd640},
	{0xc8a7, 0xd645},
	{0xc8a8, 0xd648},
	{0xc8a9, 0xd649},
	{0xc8aa, 0xd64b},
	{0xc8ab, 0xd64d},
	{0xc8ac, 0xd651},
	{0xc8ad, 0xd654},
	{0xc8ae, 0xd655},
	{0xc8af, 0xd658},
	{0xc8b0, 0xd65c},
	{0xc8b1, 0xd667},
	{0xc8b2, 0xd669},
	{0xc8b3, 0xd670},
	{0xc8b4, 0xd671},
	{0xc8b5, 0xd674},
	{0xc8b6, 0xd683},
	{0xc8b7, 0xd685},
	{0xc8b8, 0xd68c},
	{0xc8b9, 0xd68d},
	{0xc8ba, 0xd690},
	{0xc8bb, 0xd694},
	{0xc8bc, 0xd69d},
	{0xc8bd, 0xd69f},
	{0xc8be, 0xd6a1},
	{0xc8bf, 0xd6a8},
	{0xc8c0, 0xd6ac},
	{0xc8c1, 0xd6b0},
	{0xc8c2, 0xd6b9},
	{0xc8c3, 0xd6bb},
	{0xc8c4, 0xd6c4},
	{0xc8c5, 0xd6c5},
	{0xc8c6, 0xd6c8},
	{0xc8c7, 0xd6cc},
	{0xc8c8, 0xd6d1},
	{0xc8c9, 0xd6d4},
	{0xc8ca, 0xd6d7},
	{0xc8cb, 0xd6d9},
	{0xc8cc, 0xd6e0},
	{0xc8cd, 0xd6e4},
	{0xc8ce, 0xd6e8},
	{0xc8cf, 0xd6f0},
	{0xc8d0, 0xd6f5},
	{0xc8d1, 0xd6fc},
	{0xc8d2, 0xd6fd},
	{0xc8d3, 0xd700},
	{0xc8d4, 0xd704},
	{0xc8d5, 0xd711},
	{0xc8d6, 0xd718},
	{0xc8d7, 0xd719},
	{0xc8d8, 0xd71c},
	{0xc8d9, 0xd720},
	{0xc8da, 0xd728},
	{0xc8db, 0xd729},
	{0xc8dc, 0xd72b},
	{0xc8dd, 0xd72d},
	{0xc8de, 0xd734},
	{0xc8df, 0xd735},
	{0xc8e0, 0xd738},
	{0xc8e1, 0xd73c},
	{0xc8e2, 0xd744},
	{0xc8e3, 0xd747},
	{0xc8e4, 0xd749},
	{0xc8e5, 0xd750},
	{0xc8e6, 0xd751},
	{0xc8e7, 0xd754},
	{0xc8e8, 0xd756},
	{0xc8e9, 0xd757},
	{0xc8ea, 0xd758},
	{0xc8eb, 0xd759},
	{0xc8ec, 0xd760},
	{0xc8ed, 0xd761},
	{0xc8ee, 0xd763},
	{0xc8ef, 0xd765},
	{0xc8f0, 0xd769},
	{0xc8f1, 0xd76c},
	{0xc8f2, 0xd770},
	{0xc8f3, 0xd774},
	{0xc8f4, 0xd77c},
	{0xc8f5, 0xd77d},
	{0xc8f6, 0xd781},
	{0xc8f7, 0xd788},
	{0xc8f8, 0xd789},
	{0xc8f9, 0xd78c},
	{0xc8fa, 0xd790},
	{0xc8fb, 0xd798},
	{0xc8fc, 0xd799},
	{0xc8fd, 0xd79b},
	{0xc8fe, 0xd79d},
	{0xcaa1, 0x4f3d},
	{0xcaa2, 0x4f73},
	{0xcaa3, 0x5047},
	{0xcaa4, 0x50f9},
	{0xcaa5, 0x52a0},
	{0xcaa6, 0x53ef},
	{0xcaa7, 0x5475},
	{0xcaa8, 0x54e5},
	{0xcaa9, 0x5609},
	{0xcaaa, 0x5ac1},
	{0xcaab, 0x5bb6},
	{0xcaac, 0x6687},
	{0xcaad, 0x67b6},
	{0xcaae, 0x67b7},
	{0xcaaf, 0x67ef},
	{0xcab0, 0x6b4c},
	{0xcab1, 0x73c2},
	{0xcab2, 0x75c2},
	{0xcab3, 0x7a3c},
	{0xcab4, 0x82db},
	{0xcab5, 0x8304},
	{0xcab6, 0x8857},
	{0xcab7, 0x8888},
	{0xcab8, 0x8a36},
	{0xcab9, 0x8cc8},
	{0xcaba, 0x8dcf},
	{0xcabb, 0x8efb},
	{0xcabc, 0x8fe6},
	{0xcabd, 0x99d5},
	{0xcabe, 0x523b},
	{0xcabf, 0x5374},
	{0xcac0, 0x5404},
	{0xcac1, 0x606a},
	{0xcac2, 0x6164},
	{0xcac3, 0x6bbc},
	{0xcac4, 0x73cf},
	{0xcac5, 0x811a},
	{0xcac6, 0x89ba},
	{0xcac7, 0x89d2},
	{0xcac8, 0x95a3},
	{0xcac9, 0x4f83},
	{0xcaca, 0x520a},
	{0xcacb, 0x58be},
	{0xcacc, 0x5978},
	{0xcacd, 0x59e6},
	{0xcace, 0x5e72},
	{0xcacf, 0x5e79},
	{0xcad0, 0x61c7},
	{0xcad1, 0x63c0},
	{0xcad2, 0x6746},
	{0xcad3, 0x67ec},
	{0xcad4, 0x687f},
	{0xcad5, 0x6f97},
	{0xcad6, 0x764e},
	{0xcad7, 0x770b},
	{0xcad8, 0x78f5},
	{0xcad9, 0x7a08},
	{0xcada, 0x7aff},
	{0xcadb, 0x7c21},
	{0xcadc, 0x809d},
	{0xcadd, 0x826e},
	{0xcade, 0x8271},
	{0xcadf, 0x8aeb},
	{0xcae0, 0x9593},
	{0xcae1, 0x4e6b},
	{0xcae2, 0x559d},
	{0xcae3, 0x66f7},
	{0xcae4, 0x6e34},
	{0xcae5, 0x78a3},
	{0xcae6, 0x7aed},
	{0xcae7, 0x845b},
	{0xcae8, 0x8910},
	{0xcae9, 0x874e},
	{0xcaea, 0x97a8},
	{0xcaeb, 0x52d8},
	{0xcaec, 0x574e},
	{0xcaed, 0x582a},
	{0xcaee, 0x5d4c},
	{0xcaef, 0x611f},
	{0xcaf0, 0x61be},
	{0xcaf1, 0x6221},
	{0xcaf2, 0x6562},
	{0xcaf3, 0x67d1},
	{0xcaf4, 0x6a44},
	{0xcaf5, 0x6e1b},
	{0xcaf6, 0x7518},
	{0xcaf7, 0x75b3},
	{0xcaf8, 0x76e3},
	{0xcaf9, 0x77b0},
	{0xcafa, 0x7d3a},
	{0xcafb, 0x90af},
	{0xcafc, 0x9451},
	{0xcafd, 0x9452},
	{0xcafe, 0x9f95},
	{0xcba1, 0x5323},
	{0xcba2, 0x5cac},
	{0xcba3, 0x7532},
	{0xcba4, 0x80db},
	{0xcba5, 0x9240},
	{0xcba6, 0x9598},
	{0xcba7, 0x525b},
	{0xcba8, 0x5808},
	{0xcba9, 0x59dc},
	{0xcbaa, 0x5ca1},
	{0xcbab, 0x5d17},
	{0xcbac, 0x5eb7},
	{0xcbad, 0x5f3a},
	{0xcbae, 0x5f4a},
	{0xcbaf, 0x6177},
	{0xcbb0, 0x6c5f},
	{0xcbb1, 0x757a},
	{0xcbb2, 0x7586},
	{0xcbb3, 0x7ce0},
	{0xcbb4, 0x7d73},
	{0xcbb5, 0x7db1},
	{0xcbb6, 0x7f8c},
	{0xcbb7, 0x8154},
	{0xcbb8, 0x8221},
	{0xcbb9, 0x8591},
	{0xcbba, 0x8941},
	{0xcbbb, 0x8b1b},
	{0xcbbc, 0x92fc},
	{0xcbbd, 0x964d},
	{0xcbbe, 0x9c47},
	{0xcbbf, 0x4ecb},
	{0xcbc0, 0x4ef7},
	{0xcbc1, 0x500b},
	{0xcbc2, 0x51f1},
	{0xcbc3, 0x584f},
	{0xcbc4, 0x6137},
	{0xcbc5, 0x613e},
	{0xcbc6, 0x6168},
	{0xcbc7, 0x6539},
	{0xcbc8, 0x69ea},
	{0xcbc9, 0x6f11},
	{0xcbca, 0x75a5},
	{0xcbcb, 0x7686},
	{0xcbcc, 0x76d6},
	{0xcbcd, 0x7b87},
	{0xcbce, 0x82a5},
	{0xcbcf, 0x84cb},
	{0xcbd0, 0xf900},
	{0xcbd1, 0x93a7},
	{0xcbd2, 0x958b},
	{0xcbd3, 0x5580},
	{0xcbd4, 0x5ba2},
	{0xcbd5, 0x5751},
	{0xcbd6, 0xf901},
	{0xcbd7, 0x7cb3},
	{0xcbd8, 0x7fb9},
	{0xcbd9, 0x91b5},
	{0xcbda, 0x5028},
	{0xcbdb, 0x53bb},
	{0xcbdc, 0x5c45},
	{0xcbdd, 0x5de8},
	{0xcbde, 0x62d2},
	{0xcbdf, 0x636e},
	{0xcbe0, 0x64da},
	{0xcbe1, 0x64e7},
	{0xcbe2, 0x6e20},
	{0xcbe3, 0x70ac},
	{0xcbe4, 0x795b},
	{0xcbe5, 0x8ddd},
	{0xcbe6, 0x8e1e},
	{0xcbe7, 0xf902},
	{0xcbe8, 0x907d},
	{0xcbe9, 0x9245},
	{0xcbea, 0x92f8},
	{0xcbeb, 0x4e7e},
	{0xcbec, 0x4ef6},
	{0xcbed, 0x5065},
	{0xcbee, 0x5dfe},
	{0xcbef, 0x5efa},
	{0xcbf0, 0x6106},
	{0xcbf1, 0x6957},
	{0xcbf2, 0x8171},
	{0xcbf3, 0x8654},
	{0xcbf4, 0x8e47},
	{0xcbf5, 0x9375},
	{0xcbf6, 0x9a2b},
	{0xcbf7, 0x4e5e},
	{0xcbf8, 0x5091},
	{0xcbf9, 0x6770},
	{0xcbfa, 0x6840},
	{0xcbfb, 0x5109},
	{0xcbfc, 0x528d},
	{0xcbfd, 0x5292},
	{0xcbfe, 0x6aa2},
	{0xcca1, 0x77bc},
	{0xcca2, 0x9210},
	{0xcca3, 0x9ed4},
	{0xcca4, 0x52ab},
	{0xcca5, 0x602f},
	{0xcca6, 0x8ff2},
	{0xcca7, 0x5048},
	{0xcca8, 0x61a9},
	{0xcca9, 0x63ed},
	{0xccaa, 0x64ca},
	{0xccab, 0x683c},
	{0xccac, 0x6a84},
	{0xccad, 0x6fc0},
	{0xccae, 0x8188},
	{0xccaf, 0x89a1},
	{0xccb0, 0x9694},
	{0xccb1, 0x5805},
	{0xccb2, 0x727d},
	{0xccb3, 0x72ac},
	{0xccb4, 0x7504},
	{0xccb5, 0x7d79},
	{0xccb6, 0x7e6d},
	{0xccb7, 0x80a9},
	{0xccb8, 0x898b},
	{0xccb9, 0x8b74},
	{0xccba, 0x9063},
	{0xccbb, 0x9d51},
	{0xccbc, 0x6289},
	{0xccbd, 0x6c7a},
	{0xccbe, 0x6f54},
	{0xccbf, 0x7d50},
	{0xccc0, 0x7f3a},
	{0xccc1, 0x8a23},
	{0xccc2, 0x517c},
	{0xccc3, 0x614a},
	{0xccc4, 0x7b9d},
	{0xccc5, 0x8b19},
	{0xccc6, 0x9257},
	{0xccc7, 0x938c},
	{0xccc8, 0x4eac},
	{0xccc9, 0x4fd3},
	{0xccca, 0x501e},
	{0xcccb, 0x50be},
	{0xcccc, 0x5106},
	{0xcccd, 0x52c1},
	{0xccce, 0x52cd},
	{0xcccf, 0x537f},
	{0xccd0, 0x5770},
	{0xccd1, 0x5883},
	{0xccd2, 0x5e9a},
	{0xccd3, 0x5f91},
	{0xccd4, 0x6176},
	{0xccd5, 0x61ac},
	{0xccd6, 0x64ce},
	{0xccd7, 0x656c},
	{0xccd8, 0x666f},
	{0xccd9, 0x66bb},
	{0xccda, 0x66f4},
	{0xccdb, 0x6897},
	{0xccdc, 0x6d87},
	{0xccdd, 0x7085},
	{0xccde, 0x70f1},
	{0xccdf, 0x749f},
	{0xcce0, 0x74a5},
	{0xcce1, 0x74ca},
	{0xcce2, 0x75d9},
	{0xcce3, 0x786c},
	{0xcce4, 0x78ec},
	{0xcce5, 0x7adf},
	{0xcce6, 0x7af6},
	{0xcce7, 0x7d45},
	{0xcce8, 0x7d93},
	{0xcce9, 0x8015},
	{0xccea, 0x803f},
	{0xcceb, 0x811b},
	{0xccec, 0x8396},
	{0xcced, 0x8b66},
	{0xccee, 0x8f15},
	{0xccef, 0x9015},
	{0xccf0, 0x93e1},
	{0xccf1, 0x9803},
	{0xccf2, 0x9838},
	{0xccf3, 0x9a5a},
	{0xccf4, 0x9be8},
	{0xccf5, 0x4fc2},
	{0xccf6, 0x5553},
	{0xccf7, 0x583a},
	{0xccf8, 0x5951},
	{0xccf9, 0x5b63},
	{0xccfa, 0x5c46},
	{0xccfb, 0x60b8},
	{0xccfc, 0x6212},
	{0xccfd, 0x6842},
	{0xccfe, 0x68b0},
	{0xcda1, 0x68e8},
	{0xcda2, 0x6eaa},
	{0xcda3, 0x754c},
	{0xcda4, 0x7678},
	{0xcda5, 0x78ce},
	{0xcda6, 0x7a3d},
	{0xcda7, 0x7cfb},
	{0xcda8, 0x7e6b},
	{0xcda9, 0x7e7c},
	{0xcdaa, 0x8a08},
	{0xcdab, 0x8aa1},
	{0xcdac, 0x8c3f},
	{0xcdad, 0x968e},
	{0xcdae, 0x9dc4},
	{0xcdaf, 0x53e4},
	{0xcdb0, 0x53e9},
	{0xcdb1, 0x544a},
	{0xcdb2, 0x5471},
	{0xcdb3, 0x56fa},
	{0xcdb4, 0x59d1},
	{0xcdb5, 0x5b64},
	{0xcdb6, 0x5c3b},
	{0xcdb7, 0x5eab},
	{0xcdb8, 0x62f7},
	{0xcdb9, 0x6537},
	{0xcdba, 0x6545},
	{0xcdbb, 0x6572},
	{0xcdbc, 0x66a0},
	{0xcdbd, 0x67af},
	{0xcdbe, 0x69c1},
	{0xcdbf, 0x6cbd},
	{0xcdc0, 0x75fc},
	{0xcdc1, 0x7690},
	{0xcdc2, 0x777e},
	{0xcdc3, 0x7a3f},
	{0xcdc4, 0x7f94},
	{0xcdc5, 0x8003},
	{0xcdc6, 0x80a1},
	{0xcdc7, 0x818f},
	{0xcdc8, 0x82e6},
	{0xcdc9, 0x82fd},
	{0xcdca, 0x83f0},
	{0xcdcb, 0x85c1},
	{0xcdcc, 0x8831},
	{0xcdcd, 0x88b4},
	{0xcdce, 0x8aa5},
	{0xcdcf, 0xf903},
	{0xcdd0, 0x8f9c},
	{0xcdd1, 0x932e},
	{0xcdd2, 0x96c7},
	{0xcdd3, 0x9867},
	{0xcdd4, 0x9ad8},
	{0xcdd5, 0x9f13},
	{0xcdd6, 0x54ed},
	{0xcdd7, 0x659b},
	{0xcdd8, 0x66f2},
	{0xcdd9, 0x688f},
	{0xcdda, 0x7a40},
	{0xcddb, 0x8c37},
	{0xcddc, 0x9d60},
	{0xcddd, 0x56f0},
	{0xcdde, 0x5764},
	{0xcddf, 0x5d11},
	{0xcde0, 0x6606},
	{0xcde1, 0x68b1},
	{0xcde2, 0x68cd},
	{0xcde3, 0x6efe},
	{0xcde4, 0x7428},
	{0xcde5, 0x889e},
	{0xcde6, 0x9be4},
	{0xcde7, 0x6c68},
	{0xcde8, 0xf904},
	{0xcde9, 0x9aa8},
	{0xcdea, 0x4f9b},
	{0xcdeb, 0x516c},
	{0xcdec, 0x5171},
	{0xcded, 0x529f},
	{0xcdee, 0x5b54},
	{0xcdef, 0x5de5},
	{0xcdf0, 0x6050},
	{0xcdf1, 0x606d},
	{0xcdf2, 0x62f1},
	{0xcdf3, 0x63a7},
	{0xcdf4, 0x653b},
	{0xcdf5, 0x73d9},
	{0xcdf6, 0x7a7a},
	{0xcdf7, 0x86a3},
	{0xcdf8, 0x8ca2},
	{0xcdf9, 0x978f},
	{0xcdfa, 0x4e32},
	{0xcdfb, 0x5be1},
	{0xcdfc, 0x6208},
	{0xcdfd, 0x679c},
	{0xcdfe, 0x74dc},
	{0xcea1, 0x79d1},
	{0xcea2, 0x83d3},
	{0xcea3, 0x8a87},
	{0xcea4, 0x8ab2},
	{0xcea5, 0x8de8},
	{0xcea6, 0x904e},
	{0xcea7, 0x934b},
	{0xcea8, 0x9846},
	{0xcea9, 0x5ed3},
	{0xceaa, 0x69e8},
	{0xceab, 0x85ff},
	{0xceac, 0x90ed},
	{0xcead, 0xf905},
	{0xceae, 0x51a0},
	{0xceaf, 0x5b98},
	{0xceb0, 0x5bec},
	{0xceb1, 0x6163},
	{0xceb2, 0x68fa},
	{0xceb3, 0x6b3e},
	{0xceb4, 0x704c},
	{0xceb5, 0x742f},
	{0xceb6, 0x74d8},
	{0xceb7, 0x7ba1},
	{0xceb8, 0x7f50},
	{0xceb9, 0x83c5},
	{0xceba, 0x89c0},
	{0xcebb, 0x8cab},
	{0xcebc, 0x95dc},
	{0xcebd, 0x9928},
	{0xcebe, 0x522e},
	{0xcebf, 0x605d},
	{0xcec0, 0x62ec},
	{0xcec1, 0x9002},
	{0xcec2, 0x4f8a},
	{0xcec3, 0x5149},
	{0xcec4, 0x5321},
	{0xcec5, 0x58d9},
	{0xcec6, 0x5ee3},
	{0xcec7, 0x66e0},
	{0xcec8, 0x6d38},
	{0xcec9, 0x709a},
	{0xceca, 0x72c2},
	{0xcecb, 0x73d6},
	{0xcecc, 0x7b50},
	{0xcecd, 0x80f1},
	{0xcece, 0x945b},
	{0xcecf, 0x5366},
	{0xced0, 0x639b},
	{0xced1, 0x7f6b},
	{0xced2, 0x4e56},
	{0xced3, 0x5080},
	{0xced4, 0x584a},
	{0xced5, 0x58de},
	{0xced6, 0x602a},
	{0xced7, 0x6127},
	{0xced8, 0x62d0},
	{0xced9, 0x69d0},
	{0xceda, 0x9b41},
	{0xcedb, 0x5b8f},
	{0xcedc, 0x7d18},
	{0xcedd, 0x80b1},
	{0xcede, 0x8f5f},
	{0xcedf, 0x4ea4},
	{0xcee0, 0x50d1},
	{0xcee1, 0x54ac},
	{0xcee2, 0x55ac},
	{0xcee3, 0x5b0c},
	{0xcee4, 0x5da0},
	{0xcee5, 0x5de7},
	{0xcee6, 0x652a},
	{0xcee7, 0x654e},
	{0xcee8, 0x6821},
	{0xcee9, 0x6a4b},
	{0xceea, 0x72e1},
	{0xceeb, 0x768e},
	{0xceec, 0x77ef},
	{0xceed, 0x7d5e},
	{0xceee, 0x7ff9},
	{0xceef, 0x81a0},
	{0xcef0, 0x854e},
	{0xcef1, 0x86df},
	{0xcef2, 0x8f03},
	{0xcef3, 0x8f4e},
	{0xcef4, 0x90ca},
	{0xcef5, 0x9903},
	{0xcef6, 0x9a55},
	{0xcef7, 0x9bab},
	{0xcef8, 0x4e18},
	{0xcef9, 0x4e45},
	{0xcefa, 0x4e5d},
	{0xcefb, 0x4ec7},
	{0xcefc, 0x4ff1},
	{0xcefd, 0x5177},
	{0xcefe, 0x52fe},
	{0xcfa1, 0x5340},
	{0xcfa2, 0x53e3},
	{0xcfa3, 0x53e5},
	{0xcfa4, 0x548e},
	{0xcfa5, 0x5614},
	{0xcfa6, 0x5775},
	{0xcfa7, 0x57a2},
	{0xcfa8, 0x5bc7},
	{0xcfa9, 0x5d87},
	{0xcfaa, 0x5ed0},
	{0xcfab, 0x61fc},
	{0xcfac, 0x62d8},
	{0xcfad, 0x6551},
	{0xcfae, 0x67b8},
	{0xcfaf, 0x67e9},
	{0xcfb0, 0x69cb},
	{0xcfb1, 0x6b50},
	{0xcfb2, 0x6bc6},
	{0xcfb3, 0x6bec},
	{0xcfb4, 0x6c42},
	{0xcfb5, 0x6e9d},
	{0xcfb6, 0x7078},
	{0xcfb7, 0x72d7},
	{0xcfb8, 0x7396},
	{0xcfb9, 0x7403},
	{0xcfba, 0x77bf},
	{0xcfbb, 0x77e9},
	{0xcfbc, 0x7a76},
	{0xcfbd, 0x7d7f},
	{0xcfbe, 0x8009},
	{0xcfbf, 0x81fc},
	{0xcfc0, 0x8205},
	{0xcfc1, 0x820a},
	{0xcfc2, 0x82df},
	{0xcfc3, 0x8862},
	{0xcfc4, 0x8b33},
	{0xcfc5, 0x8cfc},
	{0xcfc6, 0x8ec0},
	{0xcfc7, 0x9011},
	{0xcfc8, 0x90b1},
	{0xcfc9, 0x9264},
	{0xcfca, 0x92b6},
	{0xcfcb, 0x99d2},
	{0xcfcc, 0x9a45},
	{0xcfcd, 0x9ce9},
	{0xcfce, 0x9dd7},
	{0xcfcf, 0x9f9c},
	{0xcfd0, 0x570b},
	{0xcfd1, 0x5c40},
	{0xcfd2, 0x83ca},
	{0xcfd3, 0x97a0},
	{0xcfd4, 0x97ab},
	{0xcfd5, 0x9eb4},
	{0xcfd6, 0x541b},
	{0xcfd7, 0x7a98},
	{0xcfd8, 0x7fa4},
	{0xcfd9, 0x88d9},
	{0xcfda, 0x8ecd},
	{0xcfdb, 0x90e1},
	{0xcfdc, 0x5800},
	{0xcfdd, 0x5c48},
	{0xcfde, 0x6398},
	{0xcfdf, 0x7a9f},
	{0xcfe0, 0x5bae},
	{0xcfe1, 0x5f13},
	{0xcfe2, 0x7a79},
	{0xcfe3, 0x7aae},
	{0xcfe4, 0x828e},
	{0xcfe5, 0x8eac},
	{0xcfe6, 0x5026},
	{0xcfe7, 0x5238},
	{0xcfe8, 0x52f8},
	{0xcfe9, 0x5377},
	{0xcfea, 0x5708},
	{0xcfeb, 0x62f3},
	{0xcfec, 0x6372},
	{0xcfed, 0x6b0a},
	{0xcfee, 0x6dc3},
	{0xcfef, 0x7737},
	{0xcff0, 0x53a5},
	{0xcff1, 0x7357},
	{0xcff2, 0x8568},
	{0xcff3, 0x8e76},
	{0xcff4, 0x95d5},
	{0xcff5, 0x673a},
	{0xcff6, 0x6ac3},
	{0xcff7, 0x6f70},
	{0xcff8, 0x8a6d},
	{0xcff9, 0x8ecc},
	{0xcffa, 0x994b},
	{0xcffb, 0xf906},
	{0xcffc, 0x6677},
	{0xcffd, 0x6b78},
	{0xcffe, 0x8cb4},
	{0xd0a1, 0x9b3c},
	{0xd0a2, 0xf907},
	{0xd0a3, 0x53eb},
	{0xd0a4, 0x572d},
	{0xd0a5, 0x594e},
	{0xd0a6, 0x63c6},
	{0xd0a7, 0x69fb},
	{0xd0a8, 0x73ea},
	{0xd0a9, 0x7845},
	{0xd0aa, 0x7aba},
	{0xd0ab, 0x7ac5},
	{0xd0ac, 0x7cfe},
	{0xd0ad, 0x8475},
	{0xd0ae, 0x898f},
	{0xd0af, 0x8d73},
	{0xd0b0, 0x9035},
	{0xd0b1, 0x95a8},
	{0xd0b2, 0x52fb},
	{0xd0b3, 0x5747},
	{0xd0b4, 0x7547},
	{0xd0b5, 0x7b60},
	{0xd0b6, 0x83cc},
	{0xd0b7, 0x921e},
	{0xd0b8, 0xf908},
	{0xd0b9, 0x6a58},
	{0xd0ba, 0x514b},
	{0xd0bb, 0x524b},
	{0xd0bc, 0x5287},
	{0xd0bd, 0x621f},
	{0xd0be, 0x68d8},
	{0xd0bf, 0x6975},
	{0xd0c0, 0x9699},
	{0xd0c1, 0x50c5},
	{0xd0c2, 0x52a4},
	{0xd0c3, 0x52e4},
	{0xd0c4, 0x61c3},
	{0xd0c5, 0x65a4},
	{0xd0c6, 0x6839},
	{0xd0c7, 0x69ff},
	{0xd0c8, 0x747e},
	{0xd0c9, 0x7b4b},
	{0xd0ca, 0x82b9},
	{0xd0cb, 0x83eb},
	{0xd0cc, 0x89b2},
	{0xd0cd, 0x8b39},
	{0xd0ce, 0x8fd1},
	{0xd0cf, 0x9949},
	{0xd0d0, 0xf909},
	{0xd0d1, 0x4eca},
	{0xd0d2, 0x5997},
	{0xd0d3, 0x64d2},
	{0xd0d4, 0x6611},
	{0xd0d5, 0x6a8e},
	{0xd0d6, 0x7434},
	{0xd0d7, 0x7981},
	{0xd0d8, 0x79bd},
	{0xd0d9, 0x82a9},
	{0xd0da, 0x887e},
	{0xd0db, 0x887f},
	{0xd0dc, 0x895f},
	{0xd0dd, 0xf90a},
	{0xd0de, 0x9326},
	{0xd0df, 0x4f0b},
	{0xd0e0, 0x53ca},
	{0xd0e1, 0x6025},
	{0xd0e2, 0x6271},
	{0xd0e3, 0x6c72},
	{0xd0e4, 0x7d1a},
	{0xd0e5, 0x7d66},
	{0xd0e6, 0x4e98},
	{0xd0e7, 0x5162},
	{0xd0e8, 0x77dc},
	{0xd0e9, 0x80af},
	{0xd0ea, 0x4f01},
	{0xd0eb, 0x4f0e},
	{0xd0ec, 0x5176},
	{0xd0ed, 0x5180},
	{0xd0ee, 0x55dc},
	{0xd0ef, 0x5668},
	{0xd0f0, 0x573b},
	{0xd0f1, 0x57fa},
	{0xd0f2, 0x57fc},
	{0xd0f3, 0x5914},
	{0xd0f4, 0x5947},
	{0xd0f5, 0x5993},
	{0xd0f6, 0x5bc4},
	{0xd0f7, 0x5c90},
	{0xd0f8, 0x5d0e},
	{0xd0f9, 0x5df1},
	{0xd0fa, 0x5e7e},
	{0xd0fb, 0x5fcc},
	{0xd0fc, 0x6280},
	{0xd0fd, 0x65d7},
	{0xd0fe, 0x65e3},
	{0xd1a1, 0x671e},
	{0xd1a2, 0x671f},
	{0xd1a3, 0x675e},
	{0xd1a4, 0x68cb},
	{0xd1a5, 0x68c4},
	{0xd1a6, 0x6a5f},
	{0xd1a7, 0x6b3a},
	{0xd1a8, 0x6c23},
	{0xd1a9, 0x6c7d},
	{0xd1aa, 0x6c82},
	{0xd1ab, 0x6dc7},
	{0xd1ac, 0x7398},
	{0xd1ad, 0x7426},
	{0xd1ae, 0x742a},
	{0xd1af, 0x7482},
	{0xd1b0, 0x74a3},
	{0xd1b1, 0x7578},
	{0xd1b2, 0x757f},
	{0xd1b3, 0x7881},
	{0xd1b4, 0x78ef},
	{0xd1b5, 0x7941},
	{0xd1b6, 0x7947},
	{0xd1b7, 0x7948},
	{0xd1b8, 0x797a},
	{0xd1b9, 0x7b95},
	{0xd1ba, 0x7d00},
	{0xd1bb, 0x7dba},
	{0xd1bc, 0x7f88},
	{0xd1bd, 0x8006},
	{0xd1be, 0x802d},
	{0xd1bf, 0x808c},
	{0xd1c0, 0x8a18},
	{0xd1c1, 0x8b4f},
	{0xd1c2, 0x8c48},
	{0xd1c3, 0x8d77},
	{0xd1c4, 0x9321},
	{0xd1c5, 0x9324},
	{0xd1c6, 0x98e2},
	{0xd1c7, 0x9951},
	{0xd1c8, 0x9a0e},
	{0xd1c9, 0x9a0f},
	{0xd1ca, 0x9a65},
	{0xd1cb, 0x9e92},
	{0xd1cc, 0x7dca},
	{0xd1cd, 0x4f76},
	{0xd1ce, 0x5409},
	{0xd1cf, 0x62ee},
	{0xd1d0, 0x6854},
	{0xd1d1, 0x91d1},
	{0xd1d2, 0x55ab},
	{0xd1d3, 0x513a},
	{0xd1d4, 0xf90b},
	{0xd1d5, 0xf90c},
	{0xd1d6, 0x5a1c},
	{0xd1d7, 0x61e6},
	{0xd1d8, 0xf90d},
	{0xd1d9, 0x62cf},
	{0xd1da, 0x62ff},
	{0xd1db, 0xf90e},
	{0xd1dc, 0xf90f},
	{0xd1dd, 0xf910},
	{0xd1de, 0xf911},
	{0xd1df, 0xf912},
	{0xd1e0, 0xf913},
	{0xd1e1, 0x90a3},
	{0xd1e2, 0xf914},
	{0xd1e3, 0xf915},
	{0xd1e4, 0xf916},
	{0xd1e5, 0xf917},
	{0xd1e6, 0xf918},
	{0xd1e7, 0x8afe},
	{0xd1e8, 0xf919},
	{0xd1e9, 0xf91a},
	{0xd1ea, 0xf91b},
	{0xd1eb, 0xf91c},
	{0xd1ec, 0x6696},
	{0xd1ed, 0xf91d},
	{0xd1ee, 0x7156},
	{0xd1ef, 0xf91e},
	{0xd1f0, 0xf91f},
	{0xd1f1, 0x96e3},
	{0xd1f2, 0xf920},
	{0xd1f3, 0x634f},
	{0xd1f4, 0x637a},
	{0xd1f5, 0x5357},
	{0xd1f6, 0xf921},
	{0xd1f7, 0x678f},
	{0xd1f8, 0x6960},
	{0xd1f9, 0x6e73},
	{0xd1fa, 0xf922},
	{0xd1fb, 0x7537},
	{0xd1fc, 0xf923},
	{0xd1fd, 0xf924},
	{0xd1fe, 0xf925},
	{0xd2a1, 0x7d0d},
	{0xd2a2, 0xf926},
	{0xd2a3, 0xf927},
	{0xd2a4, 0x8872},
	{0xd2a5, 0x56ca},
	{0xd2a6, 0x5a18},
	{0xd2a7, 0xf928},
	{0xd2a8, 0xf929},
	{0xd2a9, 0xf92a},
	{0xd2aa, 0xf92b},
	{0xd2ab, 0xf92c},
	{0xd2ac, 0x4e43},
	{0xd2ad, 0xf92d},
	{0xd2ae, 0x5167},
	{0xd2af, 0x5948},
	{0xd2b0, 0x67f0},
	{0xd2b1, 0x8010},
	{0xd2b2, 0xf92e},
	{0xd2b3, 0x5973},
	{0xd2b4, 0x5e74},
	{0xd2b5, 0x649a},
	{0xd2b6, 0x79ca},
	{0xd2b7, 0x5ff5},
	{0xd2b8, 0x606c},
	{0xd2b9, 0x62c8},
	{0xd2ba, 0x637b},
	{0xd2bb, 0x5be7},
	{0xd2bc, 0x5bd7},
	{0xd2bd, 0x52aa},
	{0xd2be, 0xf92f},
	{0xd2bf, 0x5974},
	{0xd2c0, 0x5f29},
	{0xd2c1, 0x6012},
	{0xd2c2, 0xf930},
	{0xd2c3, 0xf931},
	{0xd2c4, 0xf932},
	{0xd2c5, 0x7459},
	{0xd2c6, 0xf933},
	{0xd2c7, 0xf934},
	{0xd2c8, 0xf935},
	{0xd2c9, 0xf936},
	{0xd2ca, 0xf937},
	{0xd2cb, 0xf938},
	{0xd2cc, 0x99d1},
	{0xd2cd, 0xf939},
	{0xd2ce, 0xf93a},
	{0xd2cf, 0xf93b},
	{0xd2d0, 0xf93c},
	{0xd2d1, 0xf93d},
	{0xd2d2, 0xf93e},
	{0xd2d3, 0xf93f},
	{0xd2d4, 0xf940},
	{0xd2d5, 0xf941},
	{0xd2d6, 0xf942},
	{0xd2d7, 0xf943},
	{0xd2d8, 0x6fc3},
	{0xd2d9, 0xf944},
	{0xd2da, 0xf945},
	{0xd2db, 0x81bf},
	{0xd2dc, 0x8fb2},
	{0xd2dd, 0x60f1},
	{0xd2de, 0xf946},
	{0xd2df, 0xf947},
	{0xd2e0, 0x8166},
	{0xd2e1, 0xf948},
	{0xd2e2, 0xf949},
	{0xd2e3, 0x5c3f},
	{0xd2e4, 0xf94a},
	{0xd2e5, 0xf94b},
	{0xd2e6, 0xf94c},
	{0xd2e7, 0xf94d},
	{0xd2e8, 0xf94e},
	{0xd2e9, 0xf94f},
	{0xd2ea, 0xf950},
	{0xd2eb, 0xf951},
	{0xd2ec, 0x5ae9},
	{0xd2ed, 0x8a25},
	{0xd2ee, 0x677b},
	{0xd2ef, 0x7d10},
	{0xd2f0, 0xf952},
	{0xd2f1, 0xf953},
	{0xd2f2, 0xf954},
	{0xd2f3, 0xf955},
	{0xd2f4, 0xf956},
	{0xd2f5, 0xf957},
	{0xd2f6, 0x80fd},
	{0xd2f7, 0xf958},
	{0xd2f8, 0xf959},
	{0xd2f9, 0x5c3c},
	{0xd2fa, 0x6ce5},
	{0xd2fb, 0x533f},
	{0xd2fc, 0x6eba},
	{0xd2fd, 0x591a},
	{0xd2fe, 0x8336},
	{0xd3a1, 0x4e39},
	{0xd3a2, 0x4eb6},
	{0xd3a3, 0x4f46},
	{0xd3a4, 0x55ae},
	{0xd3a5, 0x5718},
	{0xd3a6, 0x58c7},
	{0xd3a7, 0x5f56},
	{0xd3a8, 0x65b7},
	{0xd3a9, 0x65e6},
	{0xd3aa, 0x6a80},
	{0xd3ab, 0x6bb5},
	{0xd3ac, 0x6e4d},
	{0xd3ad, 0x77ed},
	{0xd3ae, 0x7aef},
	{0xd3af, 0x7c1e},
	{0xd3b0, 0x7dde},
	{0xd3b1, 0x86cb},
	{0xd3b2, 0x8892},
	{0xd3b3, 0x9132},
	{0xd3b4, 0x935b},
	{0xd3b5, 0x64bb},
	{0xd3b6, 0x6fbe},
	{0xd3b7, 0x737a},
	{0xd3b8, 0x75b8},
	{0xd3b9, 0x9054},
	{0xd3ba, 0x5556},
	{0xd3bb, 0x574d},
	{0xd3bc, 0x61ba},
	{0xd3bd, 0x64d4},
	{0xd3be, 0x66c7},
	{0xd3bf, 0x6de1},
	{0xd3c0, 0x6e5b},
	{0xd3c1, 0x6f6d},
	{0xd3c2, 0x6fb9},
	{0xd3c3, 0x75f0},
	{0xd3c4, 0x8043},
	{0xd3c5, 0x81bd},
	{0xd3c6, 0x8541},
	{0xd3c7, 0x8983},
	{0xd3c8, 0x8ac7},
	{0xd3c9, 0x8b5a},
	{0xd3ca, 0x931f},
	{0xd3cb, 0x6c93},
	{0xd3cc, 0x7553},
	{0xd3cd, 0x7b54},
	{0xd3ce, 0x8e0f},
	{0xd3cf, 0x905d},
	{0xd3d0, 0x5510},
	{0xd3d1, 0x5802},
	{0xd3d2, 0x5858},
	{0xd3d3, 0x5e62},
	{0xd3d4, 0x6207},
	{0xd3d5, 0x649e},
	{0xd3d6, 0x68e0},
	{0xd3d7, 0x7576},
	{0xd3d8, 0x7cd6},
	{0xd3d9, 0x87b3},
	{0xd3da, 0x9ee8},
	{0xd3db, 0x4ee3},
	{0xd3dc, 0x5788},
	{0xd3dd, 0x576e},
	{0xd3de, 0x5927},
	{0xd3df, 0x5c0d},
	{0xd3e0, 0x5cb1},
	{0xd3e1, 0x5e36},
	{0xd3e2, 0x5f85},
	{0xd3e3, 0x6234},
	{0xd3e4, 0x64e1},
	{0xd3e5, 0x73b3},
	{0xd3e6, 0x81fa},
	{0xd3e7, 0x888b},
	{0xd3e8, 0x8cb8},
	{0xd3e9, 0x968a},
	{0xd3ea, 0x9edb},
	{0xd3eb, 0x5b85},
	{0xd3ec, 0x5fb7},
	{0xd3ed, 0x60b3},
	{0xd3ee, 0x5012},
	{0xd3ef, 0x5200},
	{0xd3f0, 0x5230},
	{0xd3f1, 0x5716},
	{0xd3f2, 0x5835},
	{0xd3f3, 0x5857},
	{0xd3f4, 0x5c0e},
	{0xd3f5, 0x5c60},
	{0xd3f6, 0x5cf6},
	{0xd3f7, 0x5d8b},
	{0xd3f8, 0x5ea6},
	{0xd3f9, 0x5f92},
	{0xd3fa, 0x60bc},
	{0xd3fb, 0x6311},
	{0xd3fc, 0x6389},
	{0xd3fd, 0x6417},
	{0xd3fe, 0x6843},
	{0xd4a1, 0x68f9},
	{0xd4a2, 0x6ac2},
	{0xd4a3, 0x6dd8},
	{0xd4a4, 0x6e21},
	{0xd4a5, 0x6ed4},
	{0xd4a6, 0x6fe4},
	{0xd4a7, 0x71fe},
	{0xd4a8, 0x76dc},
	{0xd4a9, 0x7779},
	{0xd4aa, 0x79b1},
	{0xd4ab, 0x7a3b},
	{0xd4ac, 0x8404},
	{0xd4ad, 0x89a9},
	{0xd4ae, 0x8ced},
	{0xd4af, 0x8df3},
	{0xd4b0, 0x8e48},
	{0xd4b1, 0x9003},
	{0xd4b2, 0x9014},
	{0xd4b3, 0x9053},
	{0xd4b4, 0x90fd},
	{0xd4b5, 0x934d},
	{0xd4b6, 0x9676},
	{0xd4b7, 0x97dc},
	{0xd4b8, 0x6bd2},
	{0xd4b9, 0x7006},
	{0xd4ba, 0x7258},
	{0xd4bb, 0x72a2},
	{0xd4bc, 0x7368},
	{0xd4bd, 0x7763},
	{0xd4be, 0x79bf},
	{0xd4bf, 0x7be4},
	{0xd4c0, 0x7e9b},
	{0xd4c1, 0x8b80},
	{0xd4c2, 0x58a9},
	{0xd4c3, 0x60c7},
	{0xd4c4, 0x6566},
	{0xd4c5, 0x65fd},
	{0xd4c6, 0x66be},
	{0xd4c7, 0x6c8c},
	{0xd4c8, 0x711e},
	{0xd4c9, 0x71c9},
	{0xd4ca, 0x8c5a},
	{0xd4cb, 0x9813},
	{0xd4cc, 0x4e6d},
	{0xd4cd, 0x7a81},
	{0xd4ce, 0x4edd},
	{0xd4cf, 0x51ac},
	{0xd4d0, 0x51cd},
	{0xd4d1, 0x52d5},
	{0xd4d2, 0x540c},
	{0xd4d3, 0x61a7},
	{0xd4d4, 0x6771},
	{0xd4d5, 0x6850},
	{0xd4d6, 0x68df},
	{0xd4d7, 0x6d1e},
	{0xd4d8, 0x6f7c},
	{0xd4d9, 0x75bc},
	{0xd4da, 0x77b3},
	{0xd4db, 0x7ae5},
	{0xd4dc, 0x80f4},
	{0xd4dd, 0x8463},
	{0xd4de, 0x9285},
	{0xd4df, 0x515c},
	{0xd4e0, 0x6597},
	{0xd4e1, 0x675c},
	{0xd4e2, 0x6793},
	{0xd4e3, 0x75d8},
	{0xd4e4, 0x7ac7},
	{0xd4e5, 0x8373},
	{0xd4e6, 0xf95a},
	{0xd4e7, 0x8c46},
	{0xd4e8, 0x9017},
	{0xd4e9, 0x982d},
	{0xd4ea, 0x5c6f},
	{0xd4eb, 0x81c0},
	{0xd4ec, 0x829a},
	{0xd4ed, 0x9041},
	{0xd4ee, 0x906f},
	{0xd4ef, 0x920d},
	{0xd4f0, 0x5f97},
	{0xd4f1, 0x5d9d},
	{0xd4f2, 0x6a59},
	{0xd4f3, 0x71c8},
	{0xd4f4, 0x767b},
	{0xd4f5, 0x7b49},
	{0xd4f6, 0x85e4},
	{0xd4f7, 0x8b04},
	{0xd4f8, 0x9127},
	{0xd4f9, 0x9a30},
	{0xd4fa, 0x5587},
	{0xd4fb, 0x61f6},
	{0xd4fc, 0xf95b},
	{0xd4fd, 0x7669},
	{0xd4fe, 0x7f85},
	{0xd5a1, 0x863f},
	{0xd5a2, 0x87ba},
	{0xd5a3, 0x88f8},
	{0xd5a4, 0x908f},
	{0xd5a5, 0xf95c},
	{0xd5a6, 0x6d1b},
	{0xd5a7, 0x70d9},
	{0xd5a8, 0x73de},
	{0xd5a9, 0x7d61},
	{0xd5aa, 0x843d},
	{0xd5ab, 0xf95d},
	{0xd5ac, 0x916a},
	{0xd5ad, 0x99f1},
	{0xd5ae, 0xf95e},
	{0xd5af, 0x4e82},
	{0xd5b0, 0x5375},
	{0xd5b1, 0x6b04},
	{0xd5b2, 0x6b12},
	{0xd5b3, 0x703e},
	{0xd5b4, 0x721b},
	{0xd5b5, 0x862d},
	{0xd5b6, 0x9e1e},
	{0xd5b7, 0x524c},
	{0xd5b8, 0x8fa3},
	{0xd5b9, 0x5d50},
	{0xd5ba, 0x64e5},
	{0xd5bb, 0x652c},
	{0xd5bc, 0x6b16},
	{0xd5bd, 0x6feb},
	{0xd5be, 0x7c43},
	{0xd5bf, 0x7e9c},
	{0xd5c0, 0x85cd},
	{0xd5c1, 0x8964},
	{0xd5c2, 0x89bd},
	{0xd5c3, 0x62c9},
	{0xd5c4, 0x81d8},
	{0xd5c5, 0x881f},
	{0xd5c6, 0x5eca},
	{0xd5c7, 0x6717},
	{0xd5c8, 0x6d6a},
	{0xd5c9, 0x72fc},
	{0xd5ca, 0x7405},
	{0xd5cb, 0x746f},
	{0xd5cc, 0x8782},
	{0xd5cd, 0x90de},
	{0xd5ce, 0x4f86},
	{0xd5cf, 0x5d0d},
	{0xd5d0, 0x5fa0},
	{0xd5d1, 0x840a},
	{0xd5d2, 0x51b7},
	{0xd5d3, 0x63a0},
	{0xd5d4, 0x7565},
	{0xd5d5, 0x4eae},
	{0xd5d6, 0x5006},
	{0xd5d7, 0x5169},
	{0xd5d8, 0x51c9},
	{0xd5d9, 0x6881},
	{0xd5da, 0x6a11},
	{0xd5db, 0x7cae},
	{0xd5dc, 0x7cb1},
	{0xd5dd, 0x7ce7},
	{0xd5de, 0x826f},
	{0xd5df, 0x8ad2},
	{0xd5e0, 0x8f1b},
	{0xd5e1, 0x91cf},
	{0xd5e2, 0x4fb6},
	{0xd5e3, 0x5137},
	{0xd5e4, 0x52f5},
	{0xd5e5, 0x5442},
	{0xd5e6, 0x5eec},
	{0xd5e7, 0x616e},
	{0xd5e8, 0x623e},
	{0xd5e9, 0x65c5},
	{0xd5ea, 0x6ada},
	{0xd5eb, 0x6ffe},
	{0xd5ec, 0x792a},
	{0xd5ed, 0x85dc},
	{0xd5ee, 0x8823},
	{0xd5ef, 0x95ad},
	{0xd5f0, 0x9a62},
	{0xd5f1, 0x9a6a},
	{0xd5f2, 0x9e97},
	{0xd5f3, 0x9ece},
	{0xd5f4, 0x529b},
	{0xd5f5, 0x66c6},
	{0xd5f6, 0x6b77},
	{0xd5f7, 0x701d},
	{0xd5f8, 0x792b},
	{0xd5f9, 0x8f62},
	{0xd5fa, 0x9742},
	{0xd5fb, 0x6190},
	{0xd5fc, 0x6200},
	{0xd5fd, 0x6523},
	{0xd5fe, 0x6f23},
	{0xd6a1, 0x7149},
	{0xd6a2, 0x7489},
	{0xd6a3, 0x7df4},
	{0xd6a4, 0x806f},
	{0xd6a5, 0x84ee},
	{0xd6a6, 0x8f26},
	{0xd6a7, 0x9023},
	{0xd6a8, 0x934a},
	{0xd6a9, 0x51bd},
	{0xd6aa, 0x5217},
	{0xd6ab, 0x52a3},
	{0xd6ac, 0x6d0c},
	{0xd6ad, 0x70c8},
	{0xd6ae, 0x88c2},
	{0xd6af, 0x5ec9},
	{0xd6b0, 0x6582},
	{0xd6b1, 0x6bae},
	{0xd6b2, 0x6fc2},
	{0xd6b3, 0x7c3e},
	{0xd6b4, 0x7375},
	{0xd6b5, 0x4ee4},
	{0xd6b6, 0x4f36},
	{0xd6b7, 0x56f9},
	{0xd6b8, 0xf95f},
	{0xd6b9, 0x5cba},
	{0xd6ba, 0x5dba},
	{0xd6bb, 0x601c},
	{0xd6bc, 0x73b2},
	{0xd6bd, 0x7b2d},
	{0xd6be, 0x7f9a},
	{0xd6bf, 0x7fce},
	{0xd6c0, 0x8046},
	{0xd6c1, 0x901e},
	{0xd6c2, 0x9234},
	{0xd6c3, 0x96f6},
	{0xd6c4, 0x9748},
	{0xd6c5, 0x9818},
	{0xd6c6, 0x9f61},
	{0xd6c7, 0x4f8b},
	{0xd6c8, 0x6fa7},
	{0xd6c9, 0x79ae},
	{0xd6ca, 0x91b4},
	{0xd6cb, 0x96b7},
	{0xd6cc, 0x52de},
	{0xd6cd, 0xf960},
	{0xd6ce, 0x6488},
	{0xd6cf, 0x64c4},
	{0xd6d0, 0x6ad3},
	{0xd6d1, 0x6f5e},
	{0xd6d2, 0x7018},
	{0xd6d3, 0x7210},
	{0xd6d4, 0x76e7},
	{0xd6d5, 0x8001},
	{0xd6d6, 0x8606},
	{0xd6d7, 0x865c},
	{0xd6d8, 0x8def},
	{0xd6d9, 0x8f05},
	{0xd6da, 0x9732},
	{0xd6db, 0x9b6f},
	{0xd6dc, 0x9dfa},
	{0xd6dd, 0x9e75},
	{0xd6de, 0x788c},
	{0xd6df, 0x797f},
	{0xd6e0, 0x7da0},
	{0xd6e1, 0x83c9},
	{0xd6e2, 0x9304},
	{0xd6e3, 0x9e7f},
	{0xd6e4, 0x9e93},
	{0xd6e5, 0x8ad6},
	{0xd6e6, 0x58df},
	{0xd6e7, 0x5f04},
	{0xd6e8, 0x6727},
	{0xd6e9, 0x7027},
	{0xd6ea, 0x74cf},
	{0xd6eb, 0x7c60},
	{0xd6ec, 0x807e},
	{0xd6ed, 0x5121},
	{0xd6ee, 0x7028},
	{0xd6ef, 0x7262},
	{0xd6f0, 0x78ca},
	{0xd6f1, 0x8cc2},
	{0xd6f2, 0x8cda},
	{0xd6f3, 0x8cf4},
	{0xd6f4, 0x96f7},
	{0xd6f5, 0x4e86},
	{0xd6f6, 0x50da},
	{0xd6f7, 0x5bee},
	{0xd6f8, 0x5ed6},
	{0xd6f9, 0x6599},
	{0xd6fa, 0x71ce},
	{0xd6fb, 0x7642},
	{0xd6fc, 0x77ad},
	{0xd6fd, 0x804a},
	{0xd6fe, 0x84fc},
	{0xd7a1, 0x907c},
	{0xd7a2, 0x9b27},
	{0xd7a3, 0x9f8d},
	{0xd7a4, 0x58d8},
	{0xd7a5, 0x5a41},
	{0xd7a6, 0x5c62},
	{0xd7a7, 0x6a13},
	{0xd7a8, 0x6dda},
	{0xd7a9, 0x6f0f},
	{0xd7aa, 0x763b},
	{0xd7ab, 0x7d2f},
	{0xd7ac, 0x7e37},
	{0xd7ad, 0x851e},
	{0xd7ae, 0x8938},
	{0xd7af, 0x93e4},
	{0xd7b0, 0x964b},
	{0xd7b1, 0x5289},
	{0xd7b2, 0x65d2},
	{0xd7b3, 0x67f3},
	{0xd7b4, 0x69b4},
	{0xd7b5, 0x6d41},
	{0xd7b6, 0x6e9c},
	{0xd7b7, 0x700f},
	{0xd7b8, 0x7409},
	{0xd7b9, 0x7460},
	{0xd7ba, 0x7559},
	{0xd7bb, 0x7624},
	{0xd7bc, 0x786b},
	{0xd7bd, 0x8b2c},
	{0xd7be, 0x985e},
	{0xd7bf, 0x516d},
	{0xd7c0, 0x622e},
	{0xd7c1, 0x9678},
	{0xd7c2, 0x4f96},
	{0xd7c3, 0x502b},
	{0xd7c4, 0x5d19},
	{0xd7c5, 0x6dea},
	{0xd7c6, 0x7db8},
	{0xd7c7, 0x8f2a},
	{0xd7c8, 0x5f8b},
	{0xd7c9, 0x6144},
	{0xd7ca, 0x6817},
	{0xd7cb, 0xf961},
	{0xd7cc, 0x9686},
	{0xd7cd, 0x52d2},
	{0xd7ce, 0x808b},
	{0xd7cf, 0x51dc},
	{0xd7d0, 0x51cc},
	{0xd7d1, 0x695e},
	{0xd7d2, 0x7a1c},
	{0xd7d3, 0x7dbe},
	{0xd7d4, 0x83f1},
	{0xd7d5, 0x9675},
	{0xd7d6, 0x4fda},
	{0xd7d7, 0x5229},
	{0xd7d8, 0x5398},
	{0xd7d9, 0x540f},
	{0xd7da, 0x550e},
	{0xd7db, 0x5c65},
	{0xd7dc, 0x60a7},
	{0xd7dd, 0x674e},
	{0xd7de, 0x68a8},
	{0xd7df, 0x6d6c},
	{0xd7e0, 0x7281},
	{0xd7e1, 0x72f8},
	{0xd7e2, 0x7406},
	{0xd7e3, 0x7483},
	{0xd7e4, 0xf962},
	{0xd7e5, 0x75e2},
	{0xd7e6, 0x7c6c},
	{0xd7e7, 0x7f79},
	{0xd7e8, 0x7fb8},
	{0xd7e9, 0x8389},
	{0xd7ea, 0x88cf},
	{0xd7eb, 0x88e1},
	{0xd7ec, 0x91cc},
	{0xd7ed, 0x91d0},
	{0xd7ee, 0x96e2},
	{0xd7ef, 0x9bc9},
	{0xd7f0, 0x541d},
	{0xd7f1, 0x6f7e},
	{0xd7f2, 0x71d0},
	{0xd7f3, 0x7498},
	{0xd7f4, 0x85fa},
	{0xd7f5, 0x8eaa},
	{0xd7f6, 0x96a3},
	{0xd7f7, 0x9c57},
	{0xd7f8, 0x9e9f},
	{0xd7f9, 0x6797},
	{0xd7fa, 0x6dcb},
	{0xd7fb, 0x7433},
	{0xd7fc, 0x81e8},
	{0xd7fd, 0x9716},
	{0xd7fe, 0x782c},
	{0xd8a1, 0x7acb},
	{0xd8a2, 0x7b20},
	{0xd8a3, 0x7c92},
	{0xd8a4, 0x6469},
	{0xd8a5, 0x746a},
	{0xd8a6, 0x75f2},
	{0xd8a7, 0x78bc},
	{0xd8a8, 0x78e8},
	{0xd8a9, 0x99ac},
	{0xd8aa, 0x9b54},
	{0xd8ab, 0x9ebb},
	{0xd8ac, 0x5bde},
	{0xd8ad, 0x5e55},
	{0xd8ae, 0x6f20},
	{0xd8af, 0x819c},
	{0xd8b0, 0x83ab},
	{0xd8b1, 0x9088},
	{0xd8b2, 0x4e07},
	{0xd8b3, 0x534d},
	{0xd8b4, 0x5a29},
	{0xd8b5, 0x5dd2},
	{0xd8b6, 0x5f4e},
	{0xd8b7, 0x6162},
	{0xd8b8, 0x633d},
	{0xd8b9, 0x6669},
	{0xd8ba, 0x66fc},
	{0xd8bb, 0x6eff},
	{0xd8bc, 0x6f2b},
	{0xd8bd, 0x7063},
	{0xd8be, 0x779e},
	{0xd8bf, 0x842c},
	{0xd8c0, 0x8513},
	{0xd8c1, 0x883b},
	{0xd8c2, 0x8f13},
	{0xd8c3, 0x9945},
	{0xd8c4, 0x9c3b},
	{0xd8c5, 0x551c},
	{0xd8c6, 0x62b9},
	{0xd8c7, 0x672b},
	{0xd8c8, 0x6cab},
	{0xd8c9, 0x8309},
	{0xd8ca, 0x896a},
	{0xd8cb, 0x977a},
	{0xd8cc, 0x4ea1},
	{0xd8cd, 0x5984},
	{0xd8ce, 0x5fd8},
	{0xd8cf, 0x5fd9},
	{0xd8d0, 0x671b},
	{0xd8d1, 0x7db2},
	{0xd8d2, 0x7f54},
	{0xd8d3, 0x8292},
	{0xd8d4, 0x832b},
	{0xd8d5, 0x83bd},
	{0xd8d6, 0x8f1e},
	{0xd8d7, 0x9099},
	{0xd8d8, 0x57cb},
	{0xd8d9, 0x59b9},
	{0xd8da, 0x5a92},
	{0xd8db, 0x5bd0},
	{0xd8dc, 0x6627},
	{0xd8dd, 0x679a},
	{0xd8de, 0x6885},
	{0xd8df, 0x6bcf},
	{0xd8e0, 0x7164},
	{0xd8e1, 0x7f75},
	{0xd8e2, 0x8cb7},
	{0xd8e3, 0x8ce3},
	{0xd8e4, 0x9081},
	{0xd8e5, 0x9b45},
	{0xd8e6, 0x8108},
	{0xd8e7, 0x8c8a},
	{0xd8e8, 0x964c},
	{0xd8e9, 0x9a40},
	{0xd8ea, 0x9ea5},
	{0xd8eb, 0x5b5f},
	{0xd8ec, 0x6c13},
	{0xd8ed, 0x731b},
	{0xd8ee, 0x76f2},
	{0xd8ef, 0x76df},
	{0xd8f0, 0x840c},
	{0xd8f1, 0x51aa},
	{0xd8f2, 0x8993},
	{0xd8f3, 0x514d},
	{0xd8f4, 0x5195},
	{0xd8f5, 0x52c9},
	{0xd8f6, 0x68c9},
	{0xd8f7, 0x6c94},
	{0xd8f8, 0x7704},
	{0xd8f9, 0x7720},
	{0xd8fa, 0x7dbf},
	{0xd8fb, 0x7dec},
	{0xd8fc, 0x9762},
	{0xd8fd, 0x9eb5},
	{0xd8fe, 0x6ec5},
	{0xd9a1, 0x8511},
	{0xd9a2, 0x51a5},
	{0xd9a3, 0x540d},
	{0xd9a4, 0x547d},
	{0xd9a5, 0x660e},
	{0xd9a6, 0x669d},
	{0xd9a7, 0x6927},
	{0xd9a8, 0x6e9f},
	{0xd9a9, 0x76bf},
	{0xd9aa, 0x7791},
	{0xd9ab, 0x8317},
	{0xd9ac, 0x84c2},
	{0xd9ad, 0x879f},
	{0xd9ae, 0x9169},
	{0xd9af, 0x9298},
	{0xd9b0, 0x9cf4},
	{0xd9b1, 0x8882},
	{0xd9b2, 0x4fae},
	{0xd9b3, 0x5192},
	{0xd9b4, 0x52df},
	{0xd9b5, 0x59c6},
	{0xd9b6, 0x5e3d},
	{0xd9b7, 0x6155},
	{0xd9b8, 0x6478},
	{0xd9b9, 0x6479},
	{0xd9ba, 0x66ae},
	{0xd9bb, 0x67d0},
	{0xd9bc, 0x6a21},
	{0xd9bd, 0x6bcd},
	{0xd9be, 0x6bdb},
	{0xd9bf, 0x725f},
	{0xd9c0, 0x7261},
	{0xd9c1, 0x7441},
	{0xd9c2, 0x7738},
	{0xd9c3, 0x77db},
	{0xd9c4, 0x8017},
	{0xd9c5, 0x82bc},
	{0xd9c6, 0x8305},
	{0xd9c7, 0x8b00},
	{0xd9c8, 0x8b28},
	{0xd9c9, 0x8c8c},
	{0xd9ca, 0x6728},
	{0xd9cb, 0x6c90},
	{0xd9cc, 0x7267},
	{0xd9cd, 0x76ee},
	{0xd9ce, 0x7766},
	{0xd9cf, 0x7a46},
	{0xd9d0, 0x9da9},
	{0xd9d1, 0x6b7f},
	{0xd9d2, 0x6c92},
	{0xd9d3, 0x5922},
	{0xd9d4, 0x6726},
	{0xd9d5, 0x8499},
	{0xd9d6, 0x536f},
	{0xd9d7, 0x5893},
	{0xd9d8, 0x5999},
	{0xd9d9, 0x5edf},
	{0xd9da, 0x63cf},
	{0xd9db, 0x6634},
	{0xd9dc, 0x6773},
	{0xd9dd, 0x6e3a},
	{0xd9de, 0x732b},
	{0xd9df, 0x7ad7},
	{0xd9e0, 0x82d7},
	{0xd9e1, 0x9328},
	{0xd9e2, 0x52d9},
	{0xd9e3, 0x5deb},
	{0xd9e4, 0x61ae},
	{0xd9e5, 0x61cb},
	{0xd9e6, 0x620a},
	{0xd9e7, 0x62c7},
	{0xd9e8, 0x64ab},
	{0xd9e9, 0x65e0},
	{0xd9ea, 0x6959},
	{0xd9eb, 0x6b66},
	{0xd9ec, 0x6bcb},
	{0xd9ed, 0x7121},
	{0xd9ee, 0x73f7},
	{0xd9ef, 0x755d},
	{0xd9f0, 0x7e46},
	{0xd9f1, 0x821e},
	{0xd9f2, 0x8302},
	{0xd9f3, 0x856a},
	{0xd9f4, 0x8aa3},
	{0xd9f5, 0x8cbf},
	{0xd9f6, 0x9727},
	{0xd9f7, 0x9d61},
	{0xd9f8, 0x58a8},
	{0xd9f9, 0x9ed8},
	{0xd9fa, 0x5011},
	{0xd9fb, 0x520e},
	{0xd9fc, 0x543b},
	{0xd9fd, 0x554f},
	{0xd9fe, 0x6587},
	{0xdaa1, 0x6c76},
	{0xdaa2, 0x7d0a},
	{0xdaa3, 0x7d0b},
	{0xdaa4, 0x805e},
	{0xdaa5, 0x868a},
	{0xdaa6, 0x9580},
	{0xdaa7, 0x96ef},
	{0xdaa8, 0x52ff},
	{0xdaa9, 0x6c95},
	{0xdaaa, 0x7269},
	{0xdaab, 0x5473},
	{0xdaac, 0x5a9a},
	{0xdaad, 0x5c3e},
	{0xdaae, 0x5d4b},
	{0xdaaf, 0x5f4c},
	{0xdab0, 0x5fae},
	{0xdab1, 0x672a},
	{0xdab2, 0x68b6},
	{0xdab3, 0x6963},
	{0xdab4, 0x6e3c},
	{0xdab5, 0x6e44},
	{0xdab6, 0x7709},
	{0xdab7, 0x7c73},
	{0xdab8, 0x7f8e},
	{0xdab9, 0x8587},
	{0xdaba, 0x8b0e},
	{0xdabb, 0x8ff7},
	{0xdabc, 0x9761},
	{0xdabd, 0x9ef4},
	{0xdabe, 0x5cb7},
	{0xdabf, 0x60b6},
	{0xdac0, 0x610d},
	{0xdac1, 0x61ab},
	{0xdac2, 0x654f},
	{0xdac3, 0x65fb},
	{0xdac4, 0x65fc},
	{0xdac5, 0x6c11},
	{0xdac6, 0x6cef},
	{0xdac7, 0x739f},
	{0xdac8, 0x73c9},
	{0xdac9, 0x7de1},
	{0xdaca, 0x9594},
	{0xdacb, 0x5bc6},
	{0xdacc, 0x871c},
	{0xdacd, 0x8b10},
	{0xdace, 0x525d},
	{0xdacf, 0x535a},
	{0xdad0, 0x62cd},
	{0xdad1, 0x640f},
	{0xdad2, 0x64b2},
	{0xdad3, 0x6734},
	{0xdad4, 0x6a38},
	{0xdad5, 0x6cca},
	{0xdad6, 0x73c0},
	{0xdad7, 0x749e},
	{0xdad8, 0x7b94},
	{0xdad9, 0x7c95},
	{0xdada, 0x7e1b},
	{0xdadb, 0x818a},
	{0xdadc, 0x8236},
	{0xdadd, 0x8584},
	{0xdade, 0x8feb},
	{0xdadf, 0x96f9},
	{0xdae0, 0x99c1},
	{0xdae1, 0x4f34},
	{0xdae2, 0x534a},
	{0xdae3, 0x53cd},
	{0xdae4, 0x53db},
	{0xdae5, 0x62cc},
	{0xdae6, 0x642c},
	{0xdae7, 0x6500},
	{0xdae8, 0x6591},
	{0xdae9, 0x69c3},
	{0xdaea, 0x6cee},
	{0xdaeb, 0x6f58},
	{0xdaec, 0x73ed},
	{0xdaed, 0x7554},
	{0xdaee, 0x7622},
	{0xdaef, 0x76e4},
	{0xdaf0, 0x76fc},
	{0xdaf1, 0x78d0},
	{0xdaf2, 0x78fb},
	{0xdaf3, 0x792c},
	{0xdaf4, 0x7d46},
	{0xdaf5, 0x822c},
	{0xdaf6, 0x87e0},
	{0xdaf7, 0x8fd4},
	{0xdaf8, 0x9812},
	{0xdaf9, 0x98ef},
	{0xdafa, 0x52c3},
	{0xdafb, 0x62d4},
	{0xdafc, 0x64a5},
	{0xdafd, 0x6e24},
	{0xdafe, 0x6f51},
	{0xdba1, 0x767c},
	{0xdba2, 0x8dcb},
	{0xdba3, 0x91b1},
	{0xdba4, 0x9262},
	{0xdba5, 0x9aee},
	{0xdba6, 0x9b43},
	{0xdba7, 0x5023},
	{0xdba8, 0x508d},
	{0xdba9, 0x574a},
	{0xdbaa, 0x59a8},
	{0xdbab, 0x5c28},
	{0xdbac, 0x5e47},
	{0xdbad, 0x5f77},
	{0xdbae, 0x623f},
	{0xdbaf, 0x653e},
	{0xdbb0, 0x65b9},
	{0xdbb1, 0x65c1},
	{0xdbb2, 0x6609},
	{0xdbb3, 0x678b},
	{0xdbb4, 0x699c},
	{0xdbb5, 0x6ec2},
	{0xdbb6, 0x78c5},
	{0xdbb7, 0x7d21},
	{0xdbb8, 0x80aa},
	{0xdbb9, 0x8180},
	{0xdbba, 0x822b},
	{0xdbbb, 0x82b3},
	{0xdbbc, 0x84a1},
	{0xdbbd, 0x868c},
	{0xdbbe, 0x8a2a},
	{0xdbbf, 0x8b17},
	{0xdbc0, 0x90a6},
	{0xdbc1, 0x9632},
	{0xdbc2, 0x9f90},
	{0xdbc3, 0x500d},
	{0xdbc4, 0x4ff3},
	{0xdbc5, 0xf963},
	{0xdbc6, 0x57f9},
	{0xdbc7, 0x5f98},
	{0xdbc8, 0x62dc},
	{0xdbc9, 0x6392},
	{0xdbca, 0x676f},
	{0xdbcb, 0x6e43},
	{0xdbcc, 0x7119},
	{0xdbcd, 0x76c3},
	{0xdbce, 0x80cc},
	{0xdbcf, 0x80da},
	{0xdbd0, 0x88f4},
	{0xdbd1, 0x88f5},
	{0xdbd2, 0x8919},
	{0xdbd3, 0x8ce0},
	{0xdbd4, 0x8f29},
	{0xdbd5, 0x914d},
	{0xdbd6, 0x966a},
	{0xdbd7, 0x4f2f},
	{0xdbd8, 0x4f70},
	{0xdbd9, 0x5e1b},
	{0xdbda, 0x67cf},
	{0xdbdb, 0x6822},
	{0xdbdc, 0x767d},
	{0xdbdd, 0x767e},
	{0xdbde, 0x9b44},
	{0xdbdf, 0x5e61},
	{0xdbe0, 0x6a0a},
	{0xdbe1, 0x7169},
	{0xdbe2, 0x71d4},
	{0xdbe3, 0x756a},
	{0xdbe4, 0xf964},
	{0xdbe5, 0x7e41},
	{0xdbe6, 0x8543},
	{0xdbe7, 0x85e9},
	{0xdbe8, 0x98dc},
	{0xdbe9, 0x4f10},
	{0xdbea, 0x7b4f},
	{0xdbeb, 0x7f70},
	{0xdbec, 0x95a5},
	{0xdbed, 0x51e1},
	{0xdbee, 0x5e06},
	{0xdbef, 0x68b5},
	{0xdbf0, 0x6c3e},
	{0xdbf1, 0x6c4e},
	{0xdbf2, 0x6cdb},
	{0xdbf3, 0x72af},
	{0xdbf4, 0x7bc4},
	{0xdbf5, 0x8303},
	{0xdbf6, 0x6cd5},
	{0xdbf7, 0x743a},
	{0xdbf8, 0x50fb},
	{0xdbf9, 0x5288},
	{0xdbfa, 0x58c1},
	{0xdbfb, 0x64d8},
	{0xdbfc, 0x6a97},
	{0xdbfd, 0x74a7},
	{0xdbfe, 0x7656},
	{0xdca1, 0x78a7},
	{0xdca2, 0x8617},
	{0xdca3, 0x95e2},
	{0xdca4, 0x9739},
	{0xdca5, 0xf965},
	{0xdca6, 0x535e},
	{0xdca7, 0x5f01},
	{0xdca8, 0x8b8a},
	{0xdca9, 0x8fa8},
	{0xdcaa, 0x8faf},
	{0xdcab, 0x908a},
	{0xdcac, 0x5225},
	{0xdcad, 0x77a5},
	{0xdcae, 0x9c49},
	{0xdcaf, 0x9f08},
	{0xdcb0, 0x4e19},
	{0xdcb1, 0x5002},
	{0xdcb2, 0x5175},
	{0xdcb3, 0x5c5b},
	{0xdcb4, 0x5e77},
	{0xdcb5, 0x661e},
	{0xdcb6, 0x663a},
	{0xdcb7, 0x67c4},
	{0xdcb8, 0x68c5},
	{0xdcb9, 0x70b3},
	{0xdcba, 0x7501},
	{0xdcbb, 0x75c5},
	{0xdcbc, 0x79c9},
	{0xdcbd, 0x7add},
	{0xdcbe, 0x8f27},
	{0xdcbf, 0x9920},
	{0xdcc0, 0x9a08},
	{0xdcc1, 0x4fdd},
	{0xdcc2, 0x5821},
	{0xdcc3, 0x5831},
	{0xdcc4, 0x5bf6},
	{0xdcc5, 0x666e},
	{0xdcc6, 0x6b65},
	{0xdcc7, 0x6d11},
	{0xdcc8, 0x6e7a},
	{0xdcc9, 0x6f7d},
	{0xdcca, 0x73e4},
	{0xdccb, 0x752b},
	{0xdccc, 0x83e9},
	{0xdccd, 0x88dc},
	{0xdcce, 0x8913},
	{0xdccf, 0x8b5c},
	{0xdcd0, 0x8f14},
	{0xdcd1, 0x4f0f},
	{0xdcd2, 0x50d5},
	{0xdcd3, 0x5310},
	{0xdcd4, 0x535c},
	{0xdcd5, 0x5b93},
	{0xdcd6, 0x5fa9},
	{0xdcd7, 0x670d},
	{0xdcd8, 0x798f},
	{0xdcd9, 0x8179},
	{0xdcda, 0x832f},
	{0xdcdb, 0x8514},
	{0xdcdc, 0x8907},
	{0xdcdd, 0x8986},
	{0xdcde, 0x8f39},
	{0xdcdf, 0x8f3b},
	{0xdce0, 0x99a5},
	{0xdce1, 0x9c12},
	{0xdce2, 0x672c},
	{0xdce3, 0x4e76},
	{0xdce4, 0x4ff8},
	{0xdce5, 0x5949},
	{0xdce6, 0x5c01},
	{0xdce7, 0x5cef},
	{0xdce8, 0x5cf0},
	{0xdce9, 0x6367},
	{0xdcea, 0x68d2},
	{0xdceb, 0x70fd},
	{0xdcec, 0x71a2},
	{0xdced, 0x742b},
	{0xdcee, 0x7e2b},
	{0xdcef, 0x84ec},
	{0xdcf0, 0x8702},
	{0xdcf1, 0x9022},
	{0xdcf2, 0x92d2},
	{0xdcf3, 0x9cf3},
	{0xdcf4, 0x4e0d},
	{0xdcf5, 0x4ed8},
	{0xdcf6, 0x4fef},
	{0xdcf7, 0x5085},
	{0xdcf8, 0x5256},
	{0xdcf9, 0x526f},
	{0xdcfa, 0x5426},
	{0xdcfb, 0x5490},
	{0xdcfc, 0x57e0},
	{0xdcfd, 0x592b},
	{0xdcfe, 0x5a66},
	{0xdda1, 0x5b5a},
	{0xdda2, 0x5b75},
	{0xdda3, 0x5bcc},
	{0xdda4, 0x5e9c},
	{0xdda5, 0xf966},
	{0xdda6, 0x6276},
	{0xdda7, 0x6577},
	{0xdda8, 0x65a7},
	{0xdda9, 0x6d6e},
	{0xddaa, 0x6ea5},
	{0xddab, 0x7236},
	{0xddac, 0x7b26},
	{0xddad, 0x7c3f},
	{0xddae, 0x7f36},
	{0xddaf, 0x8150},
	{0xddb0, 0x8151},
	{0xddb1, 0x819a},
	{0xddb2, 0x8240},
	{0xddb3, 0x8299},
	{0xddb4, 0x83a9},
	{0xddb5, 0x8a03},
	{0xddb6, 0x8ca0},
	{0xddb7, 0x8ce6},
	{0xddb8, 0x8cfb},
	{0xddb9, 0x8d74},
	{0xddba, 0x8dba},
	{0xddbb, 0x90e8},
	{0xddbc, 0x91dc},
	{0xddbd, 0x961c},
	{0xddbe, 0x9644},
	{0xddbf, 0x99d9},
	{0xddc0, 0x9ce7},
	{0xddc1, 0x5317},
	{0xddc2, 0x5206},
	{0xddc3, 0x5429},
	{0xddc4, 0x5674},
	{0xddc5, 0x58b3},
	{0xddc6, 0x5954},
	{0xddc7, 0x596e},
	{0xddc8, 0x5fff},
	{0xddc9, 0x61a4},
	{0xddca, 0x626e},
	{0xddcb, 0x6610},
	{0xddcc, 0x6c7e},
	{0xddcd, 0x711a},
	{0xddce, 0x76c6},
	{0xddcf, 0x7c89},
	{0xddd0, 0x7cde},
	{0xddd1, 0x7d1b},
	{0xddd2, 0x82ac},
	{0xddd3, 0x8cc1},
	{0xddd4, 0x96f0},
	{0xddd5, 0xf967},
	{0xddd6, 0x4f5b},
	{0xddd7, 0x5f17},
	{0xddd8, 0x5f7f},
	{0xddd9, 0x62c2},
	{0xddda, 0x5d29},
	{0xdddb, 0x670b},
	{0xdddc, 0x68da},
	{0xdddd, 0x787c},
	{0xddde, 0x7e43},
	{0xdddf, 0x9d6c},
	{0xdde0, 0x4e15},
	{0xdde1, 0x5099},
	{0xdde2, 0x5315},
	{0xdde3, 0x532a},
	{0xdde4, 0x5351},
	{0xdde5, 0x5983},
	{0xdde6, 0x5a62},
	{0xdde7, 0x5e87},
	{0xdde8, 0x60b2},
	{0xdde9, 0x618a},
	{0xddea, 0x6249},
	{0xddeb, 0x6279},
	{0xddec, 0x6590},
	{0xdded, 0x6787},
	{0xddee, 0x69a7},
	{0xddef, 0x6bd4},
	{0xddf0, 0x6bd6},
	{0xddf1, 0x6bd7},
	{0xddf2, 0x6bd8},
	{0xddf3, 0x6cb8},
	{0xddf4, 0xf968},
	{0xddf5, 0x7435},
	{0xddf6, 0x75fa},
	{0xddf7, 0x7812},
	{0xddf8, 0x7891},
	{0xddf9, 0x79d5},
	{0xddfa, 0x79d8},
	{0xddfb, 0x7c83},
	{0xddfc, 0x7dcb},
	{0xddfd, 0x7fe1},
	{0xddfe, 0x80a5},
	{0xdea1, 0x813e},
	{0xdea2, 0x81c2},
	{0xdea3, 0x83f2},
	{0xdea4, 0x871a},
	{0xdea5, 0x88e8},
	{0xdea6, 0x8ab9},
	{0xdea7, 0x8b6c},
	{0xdea8, 0x8cbb},
	{0xdea9, 0x9119},
	{0xdeaa, 0x975e},
	{0xdeab, 0x98db},
	{0xdeac, 0x9f3b},
	{0xdead, 0x56ac},
	{0xdeae, 0x5b2a},
	{0xdeaf, 0x5f6c},
	{0xdeb0, 0x658c},
	{0xdeb1, 0x6ab3},
	{0xdeb2, 0x6baf},
	{0xdeb3, 0x6d5c},
	{0xdeb4, 0x6ff1},
	{0xdeb5, 0x7015},
	{0xdeb6, 0x725d},
	{0xdeb7, 0x73ad},
	{0xdeb8, 0x8ca7},
	{0xdeb9, 0x8cd3},
	{0xdeba, 0x983b},
	{0xdebb, 0x6191},
	{0xdebc, 0x6c37},
	{0xdebd, 0x8058},
	{0xdebe, 0x9a01},
	{0xdebf, 0x4e4d},
	{0xdec0, 0x4e8b},
	{0xdec1, 0x4e9b},
	{0xdec2, 0x4ed5},
	{0xdec3, 0x4f3a},
	{0xdec4, 0x4f3c},
	{0xdec5, 0x4f7f},
	{0xdec6, 0x4fdf},
	{0xdec7, 0x50ff},
	{0xdec8, 0x53f2},
	{0xdec9, 0x53f8},
	{0xdeca, 0x5506},
	{0xdecb, 0x55e3},
	{0xdecc, 0x56db},
	{0xdecd, 0x58eb},
	{0xdece, 0x5962},
	{0xdecf, 0x5a11},
	{0xded0, 0x5beb},
	{0xded1, 0x5bfa},
	{0xded2, 0x5c04},
	{0xded3, 0x5df3},
	{0xded4, 0x5e2b},
	{0xded5, 0x5f99},
	{0xded6, 0x601d},
	{0xded7, 0x6368},
	{0xded8, 0x659c},
	{0xded9, 0x65af},
	{0xdeda, 0x67f6},
	{0xdedb, 0x67fb},
	{0xdedc, 0x68ad},
	{0xdedd, 0x6b7b},
	{0xdede, 0x6c99},
	{0xdedf, 0x6cd7},
	{0xdee0, 0x6e23},
	{0xdee1, 0x7009},
	{0xdee2, 0x7345},
	{0xdee3, 0x7802},
	{0xdee4, 0x793e},
	{0xdee5, 0x7940},
	{0xdee6, 0x7960},
	{0xdee7, 0x79c1},
	{0xdee8, 0x7be9},
	{0xdee9, 0x7d17},
	{0xdeea, 0x7d72},
	{0xdeeb, 0x8086},
	{0xdeec, 0x820d},
	{0xdeed, 0x838e},
	{0xdeee, 0x84d1},
	{0xdeef, 0x86c7},
	{0xdef0, 0x88df},
	{0xdef1, 0x8a50},
	{0xdef2, 0x8a5e},
	{0xdef3, 0x8b1d},
	{0xdef4, 0x8cdc},
	{0xdef5, 0x8d66},
	{0xdef6, 0x8fad},
	{0xdef7, 0x90aa},
	{0xdef8, 0x98fc},
	{0xdef9, 0x99df},
	{0xdefa, 0x9e9d},
	{0xdefb, 0x524a},
	{0xdefc, 0xf969},
	{0xdefd, 0x6714},
	{0xdefe, 0xf96a},
	{0xdfa1, 0x5098},
	{0xdfa2, 0x522a},
	{0xdfa3, 0x5c71},
	{0xdfa4, 0x6563},
	{0xdfa5, 0x6c55},
	{0xdfa6, 0x73ca},
	{0xdfa7, 0x7523},
	{0xdfa8, 0x759d},
	{0xdfa9, 0x7b97},
	{0xdfaa, 0x849c},
	{0xdfab, 0x9178},
	{0xdfac, 0x9730},
	{0xdfad, 0x4e77},
	{0xdfae, 0x6492},
	{0xdfaf, 0x6bba},
	{0xdfb0, 0x715e},
	{0xdfb1, 0x85a9},
	{0xdfb2, 0x4e09},
	{0xdfb3, 0xf96b},
	{0xdfb4, 0x6749},
	{0xdfb5, 0x68ee},
	{0xdfb6, 0x6e17},
	{0xdfb7, 0x829f},
	{0xdfb8, 0x8518},
	{0xdfb9, 0x886b},
	{0xdfba, 0x63f7},
	{0xdfbb, 0x6f81},
	{0xdfbc, 0x9212},
	{0xdfbd, 0x98af},
	{0xdfbe, 0x4e0a},
	{0xdfbf, 0x50b7},
	{0xdfc0, 0x50cf},
	{0xdfc1, 0x511f},
	{0xdfc2, 0x5546},
	{0xdfc3, 0x55aa},
	{0xdfc4, 0x5617},
	{0xdfc5, 0x5b40},
	{0xdfc6, 0x5c19},
	{0xdfc7, 0x5ce0},
	{0xdfc8, 0x5e38},
	{0xdfc9, 0x5e8a},
	{0xdfca, 0x5ea0},
	{0xdfcb, 0x5ec2},
	{0xdfcc, 0x60f3},
	{0xdfcd, 0x6851},
	{0xdfce, 0x6a61},
	{0xdfcf, 0x6e58},
	{0xdfd0, 0x723d},
	{0xdfd1, 0x7240},
	{0xdfd2, 0x72c0},
	{0xdfd3, 0x76f8},
	{0xdfd4, 0x7965},
	{0xdfd5, 0x7bb1},
	{0xdfd6, 0x7fd4},
	{0xdfd7, 0x88f3},
	{0xdfd8, 0x89f4},
	{0xdfd9, 0x8a73},
	{0xdfda, 0x8c61},
	{0xdfdb, 0x8cde},
	{0xdfdc, 0x971c},
	{0xdfdd, 0x585e},
	{0xdfde, 0x74bd},
	{0xdfdf, 0x8cfd},
	{0xdfe0, 0x55c7},
	{0xdfe1, 0xf96c},
	{0xdfe2, 0x7a61},
	{0xdfe3, 0x7d22},
	{0xdfe4, 0x8272},
	{0xdfe5, 0x7272},
	{0xdfe6, 0x751f},
	{0xdfe7, 0x7525},
	{0xdfe8, 0xf96d},
	{0xdfe9, 0x7b19},
	{0xdfea, 0x5885},
	{0xdfeb, 0x58fb},
	{0xdfec, 0x5dbc},
	{0xdfed, 0x5e8f},
	{0xdfee, 0x5eb6},
	{0xdfef, 0x5f90},
	{0xdff0, 0x6055},
	{0xdff1, 0x6292},
	{0xdff2, 0x637f},
	{0xdff3, 0x654d},
	{0xdff4, 0x6691},
	{0xdff5, 0x66d9},
	{0xdff6, 0x66f8},
	{0xdff7, 0x6816},
	{0xdff8, 0x68f2},
	{0xdff9, 0x7280},
	{0xdffa, 0x745e},
	{0xdffb, 0x7b6e},
	{0xdffc, 0x7d6e},
	{0xdffd, 0x7dd6},
	{0xdffe, 0x7f72},
	{0xe0a1, 0x80e5},
	{0xe0a2, 0x8212},
	{0xe0a3, 0x85af},
	{0xe0a4, 0x897f},
	{0xe0a5, 0x8a93},
	{0xe0a6, 0x901d},
	{0xe0a7, 0x92e4},
	{0xe0a8, 0x9ecd},
	{0xe0a9, 0x9f20},
	{0xe0aa, 0x5915},
	{0xe0ab, 0x596d},
	{0xe0ac, 0x5e2d},
	{0xe0ad, 0x60dc},
	{0xe0ae, 0x6614},
	{0xe0af, 0x6673},
	{0xe0b0, 0x6790},
	{0xe0b1, 0x6c50},
	{0xe0b2, 0x6dc5},
	{0xe0b3, 0x6f5f},
	{0xe0b4, 0x77f3},
	{0xe0b5, 0x78a9},
	{0xe0b6, 0x84c6},
	{0xe0b7, 0x91cb},
	{0xe0b8, 0x932b},
	{0xe0b9, 0x4ed9},
	{0xe0ba, 0x50ca},
	{0xe0bb, 0x5148},
	{0xe0bc, 0x5584},
	{0xe0bd, 0x5b0b},
	{0xe0be, 0x5ba3},
	{0xe0bf, 0x6247},
	{0xe0c0, 0x657e},
	{0xe0c1, 0x65cb},
	{0xe0c2, 0x6e32},
	{0xe0c3, 0x717d},
	{0xe0c4, 0x7401},
	{0xe0c5, 0x7444},
	{0xe0c6, 0x7487},
	{0xe0c7, 0x74bf},
	{0xe0c8, 0x766c},
	{0xe0c9, 0x79aa},
	{0xe0ca, 0x7dda},
	{0xe0cb, 0x7e55},
	{0xe0cc, 0x7fa8},
	{0xe0cd, 0x817a},
	{0xe0ce, 0x81b3},
	{0xe0cf, 0x8239},
	{0xe0d0, 0x861a},
	{0xe0d1, 0x87ec},
	{0xe0d2, 0x8a75},
	{0xe0d3, 0x8de3},
	{0xe0d4, 0x9078},
	{0xe0d5, 0x9291},
	{0xe0d6, 0x9425},
	{0xe0d7, 0x994d},
	{0xe0d8, 0x9bae},
	{0xe0d9, 0x5368},
	{0xe0da, 0x5c51},
	{0xe0db, 0x6954},
	{0xe0dc, 0x6cc4},
	{0xe0dd, 0x6d29},
	{0xe0de, 0x6e2b},
	{0xe0df, 0x820c},
	{0xe0e0, 0x859b},
	{0xe0e1, 0x893b},
	{0xe0e2, 0x8a2d},
	{0xe0e3, 0x8aaa},
	{0xe0e4, 0x96ea},
	{0xe0e5, 0x9f67},
	{0xe0e6, 0x5261},
	{0xe0e7, 0x66b9},
	{0xe0e8, 0x6bb2},
	{0xe0e9, 0x7e96},
	{0xe0ea, 0x87fe},
	{0xe0eb, 0x8d0d},
	{0xe0ec, 0x9583},
	{0xe0ed, 0x965d},
	{0xe0ee, 0x651d},
	{0xe0ef, 0x6d89},
	{0xe0f0, 0x71ee},
	{0xe0f1, 0xf96e},
	{0xe0f2, 0x57ce},
	{0xe0f3, 0x59d3},
	{0xe0f4, 0x5bac},
	{0xe0f5, 0x6027},
	{0xe0f6, 0x60fa},
	{0xe0f7, 0x6210},
	{0xe0f8, 0x661f},
	{0xe0f9, 0x665f},
	{0xe0fa, 0x7329},
	{0xe0fb, 0x73f9},
	{0xe0fc, 0x76db},
	{0xe0fd, 0x7701},
	{0xe0fe, 0x7b6c},
	{0xe1a1, 0x8056},
	{0xe1a2, 0x8072},
	{0xe1a3, 0x8165},
	{0xe1a4, 0x8aa0},
	{0xe1a5, 0x9192},
	{0xe1a6, 0x4e16},
	{0xe1a7, 0x52e2},
	{0xe1a8, 0x6b72},
	{0xe1a9, 0x6d17},
	{0xe1aa, 0x7a05},
	{0xe1ab, 0x7b39},
	{0xe1ac, 0x7d30},
	{0xe1ad, 0xf96f},
	{0xe1ae, 0x8cb0},
	{0xe1af, 0x53ec},
	{0xe1b0, 0x562f},
	{0xe1b1, 0x5851},
	{0xe1b2, 0x5bb5},
	{0xe1b3, 0x5c0f},
	{0xe1b4, 0x5c11},
	{0xe1b5, 0x5de2},
	{0xe1b6, 0x6240},
	{0xe1b7, 0x6383},
	{0xe1b8, 0x6414},
	{0xe1b9, 0x662d},
	{0xe1ba, 0x68b3},
	{0xe1bb, 0x6cbc},
	{0xe1bc, 0x6d88},
	{0xe1bd, 0x6eaf},
	{0xe1be, 0x701f},
	{0xe1bf, 0x70a4},
	{0xe1c0, 0x71d2},
	{0xe1c1, 0x7526},
	{0xe1c2, 0x758f},
	{0xe1c3, 0x758e},
	{0xe1c4, 0x7619},
	{0xe1c5, 0x7b11},
	{0xe1c6, 0x7be0},
	{0xe1c7, 0x7c2b},
	{0xe1c8, 0x7d20},
	{0xe1c9, 0x7d39},
	{0xe1ca, 0x852c},
	{0xe1cb, 0x856d},
	{0xe1cc, 0x8607},
	{0xe1cd, 0x8a34},
	{0xe1ce, 0x900d},
	{0xe1cf, 0x9061},
	{0xe1d0, 0x90b5},
	{0xe1d1, 0x92b7},
	{0xe1d2, 0x97f6},
	{0xe1d3, 0x9a37},
	{0xe1d4, 0x4fd7},
	{0xe1d5, 0x5c6c},
	{0xe1d6, 0x675f},
	{0xe1d7, 0x6d91},
	{0xe1d8, 0x7c9f},
	{0xe1d9, 0x7e8c},
	{0xe1da, 0x8b16},
	{0xe1db, 0x8d16},
	{0xe1dc, 0x901f},
	{0xe1dd, 0x5b6b},
	{0xe1de, 0x5dfd},
	{0xe1df, 0x640d},
	{0xe1e0, 0x84c0},
	{0xe1e1, 0x905c},
	{0xe1e2, 0x98e1},
	{0xe1e3, 0x7387},
	{0xe1e4, 0x5b8b},
	{0xe1e5, 0x609a},
	{0xe1e6, 0x677e},
	{0xe1e7, 0x6dde},
	{0xe1e8, 0x8a1f},
	{0xe1e9, 0x8aa6},
	{0xe1ea, 0x9001},
	{0xe1eb, 0x980c},
	{0xe1ec, 0x5237},
	{0xe1ed, 0xf970},
	{0xe1ee, 0x7051},
	{0xe1ef, 0x788e},
	{0xe1f0, 0x9396},
	{0xe1f1, 0x8870},
	{0xe1f2, 0x91d7},
	{0xe1f3, 0x4fee},
	{0xe1f4, 0x53d7},
	{0xe1f5, 0x55fd},
	{0xe1f6, 0x56da},
	{0xe1f7, 0x5782},
	{0xe1f8, 0x58fd},
	{0xe1f9, 0x5ac2},
	{0xe1fa, 0x5b88},
	{0xe1fb, 0x5cab},
	{0xe1fc, 0x5cc0},
	{0xe1fd, 0x5e25},
	{0xe1fe, 0x6101},
	{0xe2a1, 0x620d},
	{0xe2a2, 0x624b},
	{0xe2a3, 0x6388},
	{0xe2a4, 0x641c},
	{0xe2a5, 0x6536},
	{0xe2a6, 0x6578},
	{0xe2a7, 0x6a39},
	{0xe2a8, 0x6b8a},
	{0xe2a9, 0x6c34},
	{0xe2aa, 0x6d19},
	{0xe2ab, 0x6f31},
	{0xe2ac, 0x71e7},
	{0xe2ad, 0x72e9},
	{0xe2ae, 0x7378},
	{0xe2af, 0x7407},
	{0xe2b0, 0x74b2},
	{0xe2b1, 0x7626},
	{0xe2b2, 0x7761},
	{0xe2b3, 0x79c0},
	{0xe2b4, 0x7a57},
	{0xe2b5, 0x7aea},
	{0xe2b6, 0x7cb9},
	{0xe2b7, 0x7d8f},
	{0xe2b8, 0x7dac},
	{0xe2b9, 0x7e61},
	{0xe2ba, 0x7f9e},
	{0xe2bb, 0x8129},
	{0xe2bc, 0x8331},
	{0xe2bd, 0x8490},
	{0xe2be, 0x84da},
	{0xe2bf, 0x85ea},
	{0xe2c0, 0x8896},
	{0xe2c1, 0x8ab0},
	{0xe2c2, 0x8b90},
	{0xe2c3, 0x8f38},
	{0xe2c4, 0x9042},
	{0xe2c5, 0x9083},
	{0xe2c6, 0x916c},
	{0xe2c7, 0x9296},
	{0xe2c8, 0x92b9},
	{0xe2c9, 0x968b},
	{0xe2ca, 0x96a7},
	{0xe2cb, 0x96a8},
	{0xe2cc, 0x96d6},
	{0xe2cd, 0x9700},
	{0xe2ce, 0x9808},
	{0xe2cf, 0x9996},
	{0xe2d0, 0x9ad3},
	{0xe2d1, 0x9b1a},
	{0xe2d2, 0x53d4},
	{0xe2d3, 0x587e},
	{0xe2d4, 0x5919},
	{0xe2d5, 0x5b70},
	{0xe2d6, 0x5bbf},
	{0xe2d7, 0x6dd1},
	{0xe2d8, 0x6f5a},
	{0xe2d9, 0x719f},
	{0xe2da, 0x7421},
	{0xe2db, 0x74b9},
	{0xe2dc, 0x8085},
	{0xe2dd, 0x83fd},
	{0xe2de, 0x5de1},
	{0xe2df, 0x5f87},
	{0xe2e0, 0x5faa},
	{0xe2e1, 0x6042},
	{0xe2e2, 0x65ec},
	{0xe2e3, 0x6812},
	{0xe2e4, 0x696f},
	{0xe2e5, 0x6a53},
	{0xe2e6, 0x6b89},
	{0xe2e7, 0x6d35},
	{0xe2e8, 0x6df3},
	{0xe2e9, 0x73e3},
	{0xe2ea, 0x76fe},
	{0xe2eb, 0x77ac},
	{0xe2ec, 0x7b4d},
	{0xe2ed, 0x7d14},
	{0xe2ee, 0x8123},
	{0xe2ef, 0x821c},
	{0xe2f0, 0x8340},
	{0xe2f1, 0x84f4},
	{0xe2f2, 0x8563},
	{0xe2f3, 0x8a62},
	{0xe2f4, 0x8ac4},
	{0xe2f5, 0x9187},
	{0xe2f6, 0x931e},
	{0xe2f7, 0x9806},
	{0xe2f8, 0x99b4},
	{0xe2f9, 0x620c},
	{0xe2fa, 0x8853},
	{0xe2fb, 0x8ff0},
	{0xe2fc, 0x9265},
	{0xe2fd, 0x5d07},
	{0xe2fe, 0x5d27},
	{0xe3a1, 0x5d69},
	{0xe3a2, 0x745f},
	{0xe3a3, 0x819d},
	{0xe3a4, 0x8768},
	{0xe3a5, 0x6fd5},
	{0xe3a6, 0x62fe},
	{0xe3a7, 0x7fd2},
	{0xe3a8, 0x8936},
	{0xe3a9, 0x8972},
	{0xe3aa, 0x4e1e},
	{0xe3ab, 0x4e58},
	{0xe3ac, 0x50e7},
	{0xe3ad, 0x52dd},
	{0xe3ae, 0x5347},
	{0xe3af, 0x627f},
	{0xe3b0, 0x6607},
	{0xe3b1, 0x7e69},
	{0xe3b2, 0x8805},
	{0xe3b3, 0x965e},
	{0xe3b4, 0x4f8d},
	{0xe3b5, 0x5319},
	{0xe3b6, 0x5636},
	{0xe3b7, 0x59cb},
	{0xe3b8, 0x5aa4},
	{0xe3b9, 0x5c38},
	{0xe3ba, 0x5c4e},
	{0xe3bb, 0x5c4d},
	{0xe3bc, 0x5e02},
	{0xe3bd, 0x5f11},
	{0xe3be, 0x6043},
	{0xe3bf, 0x65bd},
	{0xe3c0, 0x662f},
	{0xe3c1, 0x6642},
	{0xe3c2, 0x67be},
	{0xe3c3, 0x67f4},
	{0xe3c4, 0x731c},
	{0xe3c5, 0x77e2},
	{0xe3c6, 0x793a},
	{0xe3c7, 0x7fc5},
	{0xe3c8, 0x8494},
	{0xe3c9, 0x84cd},
	{0xe3ca, 0x8996},
	{0xe3cb, 0x8a66},
	{0xe3cc, 0x8a69},
	{0xe3cd, 0x8ae1},
	{0xe3ce, 0x8c55},
	{0xe3cf, 0x8c7a},
	{0xe3d0, 0x57f4},
	{0xe3d1, 0x5bd4},
	{0xe3d2, 0x5f0f},
	{0xe3d3, 0x606f},
	{0xe3d4, 0x62ed},
	{0xe3d5, 0x690d},
	{0xe3d6, 0x6b96},
	{0xe3d7, 0x6e5c},
	{0xe3d8, 0x7184},
	{0xe3d9, 0x7bd2},
	{0xe3da, 0x8755},
	{0xe3db, 0x8b58},
	{0xe3dc, 0x8efe},
	{0xe3dd, 0x98df},
	{0xe3de, 0x98fe},
	{0xe3df, 0x4f38},
	{0xe3e0, 0x4f81},
	{0xe3e1, 0x4fe1},
	{0xe3e2, 0x547b},
	{0xe3e3, 0x5a20},
	{0xe3e4, 0x5bb8},
	{0xe3e5, 0x613c},
	{0xe3e6, 0x65b0},
	{0xe3e7, 0x6668},
	{0xe3e8, 0x71fc},
	{0xe3e9, 0x7533},
	{0xe3ea, 0x795e},
	{0xe3eb, 0x7d33},
	{0xe3ec, 0x814e},
	{0xe3ed, 0x81e3},
	{0xe3ee, 0x8398},
	{0xe3ef, 0x85aa},
	{0xe3f0, 0x85ce},
	{0xe3f1, 0x8703},
	{0xe3f2, 0x8a0a},
	{0xe3f3, 0x8eab},
	{0xe3f4, 0x8f9b},
	{0xe3f5, 0xf971},
	{0xe3f6, 0x8fc5},
	{0xe3f7, 0x5931},
	{0xe3f8, 0x5ba4},
	{0xe3f9, 0x5be6},
	{0xe3fa, 0x6089},
	{0xe3fb, 0x5be9},
	{0xe3fc, 0x5c0b},
	{0xe3fd, 0x5fc3},
	{0xe3fe, 0x6c81},
	{0xe4a1, 0xf972},
	{0xe4a2, 0x6df1},
	{0xe4a3, 0x700b},
	{0xe4a4, 0x751a},
	{0xe4a5, 0x82af},
	{0xe4a6, 0x8af6},
	{0xe4a7, 0x4ec0},
	{0xe4a8, 0x5341},
	{0xe4a9, 0xf973},
	{0xe4aa, 0x96d9},
	{0xe4ab, 0x6c0f},
	{0xe4ac, 0x4e9e},
	{0xe4ad, 0x4fc4},
	{0xe4ae, 0x5152},
	{0xe4af, 0x555e},
	{0xe4b0, 0x5a25},
	{0xe4b1, 0x5ce8},
	{0xe4b2, 0x6211},
	{0xe4b3, 0x7259},
	{0xe4b4, 0x82bd},
	{0xe4b5, 0x83aa},
	{0xe4b6, 0x86fe},
	{0xe4b7, 0x8859},
	{0xe4b8, 0x8a1d},
	{0xe4b9, 0x963f},
	{0xe4ba, 0x96c5},
	{0xe4bb, 0x9913},
	{0xe4bc, 0x9d09},
	{0xe4bd, 0x9d5d},
	{0xe4be, 0x580a},
	{0xe4bf, 0x5cb3},
	{0xe4c0, 0x5dbd},
	{0xe4c1, 0x5e44},
	{0xe4c2, 0x60e1},
	{0xe4c3, 0x6115},
	{0xe4c4, 0x63e1},
	{0xe4c5, 0x6a02},
	{0xe4c6, 0x6e25},
	{0xe4c7, 0x9102},
	{0xe4c8, 0x9354},
	{0xe4c9, 0x984e},
	{0xe4ca, 0x9c10},
	{0xe4cb, 0x9f77},
	{0xe4cc, 0x5b89},
	{0xe4cd, 0x5cb8},
	{0xe4ce, 0x6309},
	{0xe4cf, 0x664f},
	{0xe4d0, 0x6848},
	{0xe4d1, 0x773c},
	{0xe4d2, 0x96c1},
	{0xe4d3, 0x978d},
	{0xe4d4, 0x9854},
	{0xe4d5, 0x9b9f},
	{0xe4d6, 0x65a1},
	{0xe4d7, 0x8b01},
	{0xe4d8, 0x8ecb},
	{0xe4d9, 0x95bc},
	{0xe4da, 0x5535},
	{0xe4db, 0x5ca9},
	{0xe4dc, 0x5dd6},
	{0xe4dd, 0x5eb5},
	{0xe4de, 0x6697},
	{0xe4df, 0x764c},
	{0xe4e0, 0x83f4},
	{0xe4e1, 0x95c7},
	{0xe4e2, 0x58d3},
	{0xe4e3, 0x62bc},
	{0xe4e4, 0x72ce},
	{0xe4e5, 0x9d28},
	{0xe4e6, 0x4ef0},
	{0xe4e7, 0x592e},
	{0xe4e8, 0x600f},
	{0xe4e9, 0x663b},
	{0xe4ea, 0x6b83},
	{0xe4eb, 0x79e7},
	{0xe4ec, 0x9d26},
	{0xe4ed, 0x5393},
	{0xe4ee, 0x54c0},
	{0xe4ef, 0x57c3},
	{0xe4f0, 0x5d16},
	{0xe4f1, 0x611b},
	{0xe4f2, 0x66d6},
	{0xe4f3, 0x6daf},
	{0xe4f4, 0x788d},
	{0xe4f5, 0x827e},
	{0xe4f6, 0x9698},
	{0xe4f7, 0x9744},
	{0xe4f8, 0x5384},
	{0xe4f9, 0x627c},
	{0xe4fa, 0x6396},
	{0xe4fb, 0x6db2},
	{0xe4fc, 0x7e0a},
	{0xe4fd, 0x814b},
	{0xe4fe, 0x984d},
	{0xe5a1, 0x6afb},
	{0xe5a2, 0x7f4c},
	{0xe5a3, 0x9daf},
	{0xe5a4, 0x9e1a},
	{0xe5a5, 0x4e5f},
	{0xe5a6, 0x503b},
	{0xe5a7, 0x51b6},
	{0xe5a8, 0x591c},
	{0xe5a9, 0x60f9},
	{0xe5aa, 0x63f6},
	{0xe5ab, 0x6930},
	{0xe5ac, 0x723a},
	{0xe5ad, 0x8036},
	{0xe5ae, 0xf974},
	{0xe5af, 0x91ce},
	{0xe5b0, 0x5f31},
	{0xe5b1, 0xf975},
	{0xe5b2, 0xf976},
	{0xe5b3, 0x7d04},
	{0xe5b4, 0x82e5},
	{0xe5b5, 0x846f},
	{0xe5b6, 0x84bb},
	{0xe5b7, 0x85e5},
	{0xe5b8, 0x8e8d},
	{0xe5b9, 0xf977},
	{0xe5ba, 0x4f6f},
	{0xe5bb, 0xf978},
	{0xe5bc, 0xf979},
	{0xe5bd, 0x58e4},
	{0xe5be, 0x5b43},
	{0xe5bf, 0x6059},
	{0xe5c0, 0x63da},
	{0xe5c1, 0x6518},
	{0xe5c2, 0x656d},
	{0xe5c3, 0x6698},
	{0xe5c4, 0xf97a},
	{0xe5c5, 0x694a},
	{0xe5c6, 0x6a23},
	{0xe5c7, 0x6d0b},
	{0xe5c8, 0x7001},
	{0xe5c9, 0x716c},
	{0xe5ca, 0x75d2},
	{0xe5cb, 0x760d},
	{0xe5cc, 0x79b3},
	{0xe5cd, 0x7a70},
	{0xe5ce, 0xf97b},
	{0xe5cf, 0x7f8a},
	{0xe5d0, 0xf97c},
	{0xe5d1, 0x8944},
	{0xe5d2, 0xf97d},
	{0xe5d3, 0x8b93},
	{0xe5d4, 0x91c0},
	{0xe5d5, 0x967d},
	{0xe5d6, 0xf97e},
	{0xe5d7, 0x990a},
	{0xe5d8, 0x5704},
	{0xe5d9, 0x5fa1},
	{0xe5da, 0x65bc},
	{0xe5db, 0x6f01},
	{0xe5dc, 0x7600},
	{0xe5dd, 0x79a6},
	{0xe5de, 0x8a9e},
	{0xe5df, 0x99ad},
	{0xe5e0, 0x9b5a},
	{0xe5e1, 0x9f6c},
	{0xe5e2, 0x5104},
	{0xe5e3, 0x61b6},
	{0xe5e4, 0x6291},
	{0xe5e5, 0x6a8d},
	{0xe5e6, 0x81c6},
	{0xe5e7, 0x5043},
	{0xe5e8, 0x5830},
	{0xe5e9, 0x5f66},
	{0xe5ea, 0x7109},
	{0xe5eb, 0x8a00},
	{0xe5ec, 0x8afa},
	{0xe5ed, 0x5b7c},
	{0xe5ee, 0x8616},
	{0xe5ef, 0x4ffa},
	{0xe5f0, 0x513c},
	{0xe5f1, 0x56b4},
	{0xe5f2, 0x5944},
	{0xe5f3, 0x63a9},
	{0xe5f4, 0x6df9},
	{0xe5f5, 0x5daa},
	{0xe5f6, 0x696d},
	{0xe5f7, 0x5186},
	{0xe5f8, 0x4e88},
	{0xe5f9, 0x4f59},
	{0xe5fa, 0xf97f},
	{0xe5fb, 0xf980},
	{0xe5fc, 0xf981},
	{0xe5fd, 0x5982},
	{0xe5fe, 0xf982},
	{0xe6a1, 0xf983},
	{0xe6a2, 0x6b5f},
	{0xe6a3, 0x6c5d},
	{0xe6a4, 0xf984},
	{0xe6a5, 0x74b5},
	{0xe6a6, 0x7916},
	{0xe6a7, 0xf985},
	{0xe6a8, 0x8207},
	{0xe6a9, 0x8245},
	{0xe6aa, 0x8339},
	{0xe6ab, 0x8f3f},
	{0xe6ac, 0x8f5d},
	{0xe6ad, 0xf986},
	{0xe6ae, 0x9918},
	{0xe6af, 0xf987},
	{0xe6b0, 0xf988},
	{0xe6b1, 0xf989},
	{0xe6b2, 0x4ea6},
	{0xe6b3, 0xf98a},
	{0xe6b4, 0x57df},
	{0xe6b5, 0x5f79},
	{0xe6b6, 0x6613},
	{0xe6b7, 0xf98b},
	{0xe6b8, 0xf98c},
	{0xe6b9, 0x75ab},
	{0xe6ba, 0x7e79},
	{0xe6bb, 0x8b6f},
	{0xe6bc, 0xf98d},
	{0xe6bd, 0x9006},
	{0xe6be, 0x9a5b},
	{0xe6bf, 0x56a5},
	{0xe6c0, 0x5827},
	{0xe6c1, 0x59f8},
	{0xe6c2, 0x5a1f},
	{0xe6c3, 0x5bb4},
	{0xe6c4, 0xf98e},
	{0xe6c5, 0x5ef6},
	{0xe6c6, 0xf98f},
	{0xe6c7, 0xf990},
	{0xe6c8, 0x6350},
	{0xe6c9, 0x633b},
	{0xe6ca, 0xf991},
	{0xe6cb, 0x693d},
	{0xe6cc, 0x6c87},
	{0xe6cd, 0x6cbf},
	{0xe6ce, 0x6d8e},
	{0xe6cf, 0x6d93},
	{0xe6d0, 0x6df5},
	{0xe6d1, 0x6f14},
	{0xe6d2, 0xf992},
	{0xe6d3, 0x70df},
	{0xe6d4, 0x7136},
	{0xe6d5, 0x7159},
	{0xe6d6, 0xf993},
	{0xe6d7, 0x71c3},
	{0xe6d8, 0x71d5},
	{0xe6d9, 0xf994},
	{0xe6da, 0x784f},
	{0xe6db, 0x786f},
	{0xe6dc, 0xf995},
	{0xe6dd, 0x7b75},
	{0xe6de, 0x7de3},
	{0xe6df, 0xf996},
	{0xe6e0, 0x7e2f},
	{0xe6e1, 0xf997},
	{0xe6e2, 0x884d},
	{0xe6e3, 0x8edf},
	{0xe6e4, 0xf998},
	{0xe6e5, 0xf999},
	{0xe6e6, 0xf99a},
	{0xe6e7, 0x925b},
	{0xe6e8, 0xf99b},
	{0xe6e9, 0x9cf6},
	{0xe6ea, 0xf99c},
	{0xe6eb, 0xf99d},
	{0xe6ec, 0xf99e},
	{0xe6ed, 0x6085},
	{0xe6ee, 0x6d85},
	{0xe6ef, 0xf99f},
	{0xe6f0, 0x71b1},
	{0xe6f1, 0xf9a0},
	{0xe6f2, 0xf9a1},
	{0xe6f3, 0x95b1},
	{0xe6f4, 0x53ad},
	{0xe6f5, 0xf9a2},
	{0xe6f6, 0xf9a3},
	{0xe6f7, 0xf9a4},
	{0xe6f8, 0x67d3},
	{0xe6f9, 0xf9a5},
	{0xe6fa, 0x708e},
	{0xe6fb, 0x7130},
	{0xe6fc, 0x7430},
	{0xe6fd, 0x8276},
	{0xe6fe, 0x82d2},
	{0xe7a1, 0xf9a6},
	{0xe7a2, 0x95bb},
	{0xe7a3, 0x9ae5},
	{0xe7a4, 0x9e7d},
	{0xe7a5, 0x66c4},
	{0xe7a6, 0xf9a7},
	{0xe7a7, 0x71c1},
	{0xe7a8, 0x8449},
	{0xe7a9, 0xf9a8},
	{0xe7aa, 0xf9a9},
	{0xe7ab, 0x584b},
	{0xe7ac, 0xf9aa},
	{0xe7ad, 0xf9ab},
	{0xe7ae, 0x5db8},
	{0xe7af, 0x5f71},
	{0xe7b0, 0xf9ac},
	{0xe7b1, 0x6620},
	{0xe7b2, 0x668e},
	{0xe7b3, 0x6979},
	{0xe7b4, 0x69ae},
	{0xe7b5, 0x6c38},
	{0xe7b6, 0x6cf3},
	{0xe7b7, 0x6e36},
	{0xe7b8, 0x6f41},
	{0xe7b9, 0x6fda},
	{0xe7ba, 0x701b},
	{0xe7bb, 0x702f},
	{0xe7bc, 0x7150},
	{0xe7bd, 0x71df},
	{0xe7be, 0x7370},
	{0xe7bf, 0xf9ad},
	{0xe7c0, 0x745b},
	{0xe7c1, 0xf9ae},
	{0xe7c2, 0x74d4},
	{0xe7c3, 0x76c8},
	{0xe7c4, 0x7a4e},
	{0xe7c5, 0x7e93},
	{0xe7c6, 0xf9af},
	{0xe7c7, 0xf9b0},
	{0xe7c8, 0x82f1},
	{0xe7c9, 0x8a60},
	{0xe7ca, 0x8fce},
	{0xe7cb, 0xf9b1},
	{0xe7cc, 0x9348},
	{0xe7cd, 0xf9b2},
	{0xe7ce, 0x9719},
	{0xe7cf, 0xf9b3},
	{0xe7d0, 0xf9b4},
	{0xe7d1, 0x4e42},
	{0xe7d2, 0x502a},
	{0xe7d3, 0xf9b5},
	{0xe7d4, 0x5208},
	{0xe7d5, 0x53e1},
	{0xe7d6, 0x66f3},
	{0xe7d7, 0x6c6d},
	{0xe7d8, 0x6fca},
	{0xe7d9, 0x730a},
	{0xe7da, 0x777f},
	{0xe7db, 0x7a62},
	{0xe7dc, 0x82ae},
	{0xe7dd, 0x85dd},
	{0xe7de, 0x8602},
	{0xe7df, 0xf9b6},
	{0xe7e0, 0x88d4},
	{0xe7e1, 0x8a63},
	{0xe7e2, 0x8b7d},
	{0xe7e3, 0x8c6b},
	{0xe7e4, 0xf9b7},
	{0xe7e5, 0x92b3},
	{0xe7e6, 0xf9b8},
	{0xe7e7, 0x9713},
	{0xe7e8, 0x9810},
	{0xe7e9, 0x4e94},
	{0xe7ea, 0x4f0d},
	{0xe7eb, 0x4fc9},
	{0xe7ec, 0x50b2},
	{0xe7ed, 0x5348},
	{0xe7ee, 0x543e},
	{0xe7ef, 0x5433},
	{0xe7f0, 0x55da},
	{0xe7f1, 0x5862},
	{0xe7f2, 0x58ba},
	{0xe7f3, 0x5967},
	{0xe7f4, 0x5a1b},
	{0xe7f5, 0x5be4},
	{0xe7f6, 0x609f},
	{0xe7f7, 0xf9b9},
	{0xe7f8, 0x61ca},
	{0xe7f9, 0x6556},
	{0xe7fa, 0x65ff},
	{0xe7fb, 0x6664},
	{0xe7fc, 0x68a7},
	{0xe7fd, 0x6c5a},
	{0xe7fe, 0x6fb3},
	{0xe8a1, 0x70cf},
	{0xe8a2, 0x71ac},
	{0xe8a3, 0x7352},
	{0xe8a4, 0x7b7d},
	{0xe8a5, 0x8708},
	{0xe8a6, 0x8aa4},
	{0xe8a7, 0x9c32},
	{0xe8a8, 0x9f07},
	{0xe8a9, 0x5c4b},
	{0xe8aa, 0x6c83},
	{0xe8ab, 0x7344},
	{0xe8ac, 0x7389},
	{0xe8ad, 0x923a},
	{0xe8ae, 0x6eab},
	{0xe8af, 0x7465},
	{0xe8b0, 0x761f},
	{0xe8b1, 0x7a69},
	{0xe8b2, 0x7e15},
	{0xe8b3, 0x860a},
	{0xe8b4, 0x5140},
	{0xe8b5, 0x58c5},
	{0xe8b6, 0x64c1},
	{0xe8b7, 0x74ee},
	{0xe8b8, 0x7515},
	{0xe8b9, 0x7670},
	{0xe8ba, 0x7fc1},
	{0xe8bb, 0x9095},
	{0xe8bc, 0x96cd},
	{0xe8bd, 0x9954},
	{0xe8be, 0x6e26},
	{0xe8bf, 0x74e6},
	{0xe8c0, 0x7aa9},
	{0xe8c1, 0x7aaa},
	{0xe8c2, 0x81e5},
	{0xe8c3, 0x86d9},
	{0xe8c4, 0x8778},
	{0xe8c5, 0x8a1b},
	{0xe8c6, 0x5a49},
	{0xe8c7, 0x5b8c},
	{0xe8c8, 0x5b9b},
	{0xe8c9, 0x68a1},
	{0xe8ca, 0x6900},
	{0xe8cb, 0x6d63},
	{0xe8cc, 0x73a9},
	{0xe8cd, 0x7413},
	{0xe8ce, 0x742c},
	{0xe8cf, 0x7897},
	{0xe8d0, 0x7de9},
	{0xe8d1, 0x7feb},
	{0xe8d2, 0x8118},
	{0xe8d3, 0x8155},
	{0xe8d4, 0x839e},
	{0xe8d5, 0x8c4c},
	{0xe8d6, 0x962e},
	{0xe8d7, 0x9811},
	{0xe8d8, 0x66f0},
	{0xe8d9, 0x5f80},
	{0xe8da, 0x65fa},
	{0xe8db, 0x6789},
	{0xe8dc, 0x6c6a},
	{0xe8dd, 0x738b},
	{0xe8de, 0x502d},
	{0xe8df, 0x5a03},
	{0xe8e0, 0x6b6a},
	{0xe8e1, 0x77ee},
	{0xe8e2, 0x5916},
	{0xe8e3, 0x5d6c},
	{0xe8e4, 0x5dcd},
	{0xe8e5, 0x7325},
	{0xe8e6, 0x754f},
	{0xe8e7, 0xf9ba},
	{0xe8e8, 0xf9bb},
	{0xe8e9, 0x50e5},
	{0xe8ea, 0x51f9},
	{0xe8eb, 0x582f},
	{0xe8ec, 0x592d},
	{0xe8ed, 0x5996},
	{0xe8ee, 0x59da},
	{0xe8ef, 0x5be5},
	{0xe8f0, 0xf9bc},
	{0xe8f1, 0xf9bd},
	{0xe8f2, 0x5da2},
	{0xe8f3, 0x62d7},
	{0xe8f4, 0x6416},
	{0xe8f5, 0x6493},
	{0xe8f6, 0x64fe},
	{0xe8f7, 0xf9be},
	{0xe8f8, 0x66dc},
	{0xe8f9, 0xf9bf},
	{0xe8fa, 0x6a48},
	{0xe8fb, 0xf9c0},
	{0xe8fc, 0x71ff},
	{0xe8fd, 0x7464},
	{0xe8fe, 0xf9c1},
	{0xe9a1, 0x7a88},
	{0xe9a2, 0x7aaf},
	{0xe9a3, 0x7e47},
	{0xe9a4, 0x7e5e},
	{0xe9a5, 0x8000},
	{0xe9a6, 0x8170},
	{0xe9a7, 0xf9c2},
	{0xe9a8, 0x87ef},
	{0xe9a9, 0x8981},
	{0xe9aa, 0x8b20},
	{0xe9ab, 0x9059},
	{0xe9ac, 0xf9c3},
	{0xe9ad, 0x9080},
	{0xe9ae, 0x9952},
	{0xe9af, 0x617e},
	{0xe9b0, 0x6b32},
	{0xe9b1, 0x6d74},
	{0xe9b2, 0x7e1f},
	{0xe9b3, 0x8925},
	{0xe9b4, 0x8fb1},
	{0xe9b5, 0x4fd1},
	{0xe9b6, 0x50ad},
	{0xe9b7, 0x5197},
	{0xe9b8, 0x52c7},
	{0xe9b9, 0x57c7},
	{0xe9ba, 0x5889},
	{0xe9bb, 0x5bb9},
	{0xe9bc, 0x5eb8},
	{0xe9bd, 0x6142},
	{0xe9be, 0x6995},
	{0xe9bf, 0x6d8c},
	{0xe9c0, 0x6e67},
	{0xe9c1, 0x6eb6},
	{0xe9c2, 0x7194},
	{0xe9c3, 0x7462},
	{0xe9c4, 0x7528},
	{0xe9c5, 0x752c},
	{0xe9c6, 0x8073},
	{0xe9c7, 0x8338},
	{0xe9c8, 0x84c9},
	{0xe9c9, 0x8e0a},
	{0xe9ca, 0x9394},
	{0xe9cb, 0x93de},
	{0xe9cc, 0xf9c4},
	{0xe9cd, 0x4e8e},
	{0xe9ce, 0x4f51},
	{0xe9cf, 0x5076},
	{0xe9d0, 0x512a},
	{0xe9d1, 0x53c8},
	{0xe9d2, 0x53cb},
	{0xe9d3, 0x53f3},
	{0xe9d4, 0x5b87},
	{0xe9d5, 0x5bd3},
	{0xe9d6, 0x5c24},
	{0xe9d7, 0x611a},
	{0xe9d8, 0x6182},
	{0xe9d9, 0x65f4},
	{0xe9da, 0x725b},
	{0xe9db, 0x7397},
	{0xe9dc, 0x7440},
	{0xe9dd, 0x76c2},
	{0xe9de, 0x7950},
	{0xe9df, 0x7991},
	{0xe9e0, 0x79b9},
	{0xe9e1, 0x7d06},
	{0xe9e2, 0x7fbd},
	{0xe9e3, 0x828b},
	{0xe9e4, 0x85d5},
	{0xe9e5, 0x865e},
	{0xe9e6, 0x8fc2},
	{0xe9e7, 0x9047},
	{0xe9e8, 0x90f5},
	{0xe9e9, 0x91ea},
	{0xe9ea, 0x9685},
	{0xe9eb, 0x96e8},
	{0xe9ec, 0x96e9},
	{0xe9ed, 0x52d6},
	{0xe9ee, 0x5f67},
	{0xe9ef, 0x65ed},
	{0xe9f0, 0x6631},
	{0xe9f1, 0x682f},
	{0xe9f2, 0x715c},
	{0xe9f3, 0x7a36},
	{0xe9f4, 0x90c1},
	{0xe9f5, 0x980a},
	{0xe9f6, 0x4e91},
	{0xe9f7, 0xf9c5},
	{0xe9f8, 0x6a52},
	{0xe9f9, 0x6b9e},
	{0xe9fa, 0x6f90},
	{0xe9fb, 0x7189},
	{0xe9fc, 0x8018},
	{0xe9fd, 0x82b8},
	{0xe9fe, 0x8553},
	{0xeaa1, 0x904b},
	{0xeaa2, 0x9695},
	{0xeaa3, 0x96f2},
	{0xeaa4, 0x97fb},
	{0xeaa5, 0x851a},
	{0xeaa6, 0x9b31},
	{0xeaa7, 0x4e90},
	{0xeaa8, 0x718a},
	{0xeaa9, 0x96c4},
	{0xeaaa, 0x5143},
	{0xeaab, 0x539f},
	{0xeaac, 0x54e1},
	{0xeaad, 0x5713},
	{0xeaae, 0x5712},
	{0xeaaf, 0x57a3},
	{0xeab0, 0x5a9b},
	{0xeab1, 0x5ac4},
	{0xeab2, 0x5bc3},
	{0xeab3, 0x6028},
	{0xeab4, 0x613f},
	{0xeab5, 0x63f4},
	{0xeab6, 0x6c85},
	{0xeab7, 0x6d39},
	{0xeab8, 0x6e72},
	{0xeab9, 0x6e90},
	{0xeaba, 0x7230},
	{0xeabb, 0x733f},
	{0xeabc, 0x7457},
	{0xeabd, 0x82d1},
	{0xeabe, 0x8881},
	{0xeabf, 0x8f45},
	{0xeac0, 0x9060},
	{0xeac1, 0xf9c6},
	{0xeac2, 0x9662},
	{0xeac3, 0x9858},
	{0xeac4, 0x9d1b},
	{0xeac5, 0x6708},
	{0xeac6, 0x8d8a},
	{0xeac7, 0x925e},
	{0xeac8, 0x4f4d},
	{0xeac9, 0x5049},
	{0xeaca, 0x50de},
	{0xeacb, 0x5371},
	{0xeacc, 0x570d},
	{0xeacd, 0x59d4},
	{0xeace, 0x5a01},
	{0xeacf, 0x5c09},
	{0xead0, 0x6170},
	{0xead1, 0x6690},
	{0xead2, 0x6e2d},
	{0xead3, 0x7232},
	{0xead4, 0x744b},
	{0xead5, 0x7def},
	{0xead6, 0x80c3},
	{0xead7, 0x840e},
	{0xead8, 0x8466},
	{0xead9, 0x853f},
	{0xeada, 0x875f},
	{0xeadb, 0x885b},
	{0xeadc, 0x8918},
	{0xeadd, 0x8b02},
	{0xeade, 0x9055},
	{0xeadf, 0x97cb},
	{0xeae0, 0x9b4f},
	{0xeae1, 0x4e73},
	{0xeae2, 0x4f91},
	{0xeae3, 0x5112},
	{0xeae4, 0x516a},
	{0xeae5, 0xf9c7},
	{0xeae6, 0x552f},
	{0xeae7, 0x55a9},
	{0xeae8, 0x5b7a},
	{0xeae9, 0x5ba5},
	{0xeaea, 0x5e7c},
	{0xeaeb, 0x5e7d},
	{0xeaec, 0x5ebe},
	{0xeaed, 0x60a0},
	{0xeaee, 0x60df},
	{0xeaef, 0x6108},
	{0xeaf0, 0x6109},
	{0xeaf1, 0x63c4},
	{0xeaf2, 0x6538},
	{0xeaf3, 0x6709},
	{0xeaf4, 0xf9c8},
	{0xeaf5, 0x67d4},
	{0xeaf6, 0x67da},
	{0xeaf7, 0xf9c9},
	{0xeaf8, 0x6961},
	{0xeaf9, 0x6962},
	{0xeafa, 0x6cb9},
	{0xeafb, 0x6d27},
	{0xeafc, 0xf9ca},
	{0xeafd, 0x6e38},
	{0xeafe, 0xf9cb},
	{0xeba1, 0x6fe1},
	{0xeba2, 0x7336},
	{0xeba3, 0x7337},
	{0xeba4, 0xf9cc},
	{0xeba5, 0x745c},
	{0xeba6, 0x7531},
	{0xeba7, 0xf9cd},
	{0xeba8, 0x7652},
	{0xeba9, 0xf9ce},
	{0xebaa, 0xf9cf},
	{0xebab, 0x7dad},
	{0xebac, 0x81fe},
	{0xebad, 0x8438},
	{0xebae, 0x88d5},
	{0xebaf, 0x8a98},
	{0xebb0, 0x8adb},
	{0xebb1, 0x8aed},
	{0xebb2, 0x8e30},
	{0xebb3, 0x8e42},
	{0xebb4, 0x904a},
	{0xebb5, 0x903e},
	{0xebb6, 0x907a},
	{0xebb7, 0x9149},
	{0xebb8, 0x91c9},
	{0xebb9, 0x936e},
	{0xebba, 0xf9d0},
	{0xebbb, 0xf9d1},
	{0xebbc, 0x5809},
	{0xebbd, 0xf9d2},
	{0xebbe, 0x6bd3},
	{0xebbf, 0x8089},
	{0xebc0, 0x80b2},
	{0xebc1, 0xf9d3},
	{0xebc2, 0xf9d4},
	{0xebc3, 0x5141},
	{0xebc4, 0x596b},
	{0xebc5, 0x5c39},
	{0xebc6, 0xf9d5},
	{0xebc7, 0xf9d6},
	{0xebc8, 0x6f64},
	{0xebc9, 0x73a7},
	{0xebca, 0x80e4},
	{0xebcb, 0x8d07},
	{0xebcc, 0xf9d7},
	{0xebcd, 0x9217},
	{0xebce, 0x958f},
	{0xebcf, 0xf9d8},
	{0xebd0, 0xf9d9},
	{0xebd1, 0xf9da},
	{0xebd2, 0xf9db},
	{0xebd3, 0x807f},
	{0xebd4, 0x620e},
	{0xebd5, 0x701c},
	{0xebd6, 0x7d68},
	{0xebd7, 0x878d},
	{0xebd8, 0xf9dc},
	{0xebd9, 0x57a0},
	{0xebda, 0x6069},
	{0xebdb, 0x6147},
	{0xebdc, 0x6bb7},
	{0xebdd, 0x8abe},
	{0xebde, 0x9280},
	{0xebdf, 0x96b1},
	{0xebe0, 0x4e59},
	{0xebe1, 0x541f},
	{0xebe2, 0x6deb},
	{0xebe3, 0x852d},
	{0xebe4, 0x9670},
	{0xebe5, 0x97f3},
	{0xebe6, 0x98ee},
	{0xebe7, 0x63d6},
	{0xebe8, 0x6ce3},
	{0xebe9, 0x9091},
	{0xebea, 0x51dd},
	{0xebeb, 0x61c9},
	{0xebec, 0x81ba},
	{0xebed, 0x9df9},
	{0xebee, 0x4f9d},
	{0xebef, 0x501a},
	{0xebf0, 0x5100},
	{0xebf1, 0x5b9c},
	{0xebf2, 0x610f},
	{0xebf3, 0x61ff},
	{0xebf4, 0x64ec},
	{0xebf5, 0x6905},
	{0xebf6, 0x6bc5},
	{0xebf7, 0x7591},
	{0xebf8, 0x77e3},
	{0xebf9, 0x7fa9},
	{0xebfa, 0x8264},
	{0xebfb, 0x858f},
	{0xebfc, 0x87fb},
	{0xebfd, 0x8863},
	{0xebfe, 0x8abc},
	{0xeca1, 0x8b70},
	{0xeca2, 0x91ab},
	{0xeca3, 0x4e8c},
	{0xeca4, 0x4ee5},
	{0xeca5, 0x4f0a},
	{0xeca6, 0xf9dd},
	{0xeca7, 0xf9de},
	{0xeca8, 0x5937},
	{0xeca9, 0x59e8},
	{0xecaa, 0xf9df},
	{0xecab, 0x5df2},
	{0xecac, 0x5f1b},
	{0xecad, 0x5f5b},
	{0xecae, 0x6021},
	{0xecaf, 0xf9e0},
	{0xecb0, 0xf9e1},
	{0xecb1, 0xf9e2},
	{0xecb2, 0xf9e3},
	{0xecb3, 0x723e},
	{0xecb4, 0x73e5},
	{0xecb5, 0xf9e4},
	{0xecb6, 0x7570},
	{0xecb7, 0x75cd},
	{0xecb8, 0xf9e5},
	{0xecb9, 0x79fb},
	{0xecba, 0xf9e6},
	{0xecbb, 0x800c},
	{0xecbc, 0x8033},
	{0xecbd, 0x8084},
	{0xecbe, 0x82e1},
	{0xecbf, 0x8351},
	{0xecc0, 0xf9e7},
	{0xecc1, 0xf9e8},
	{0xecc2, 0x8cbd},
	{0xecc3, 0x8cb3},
	{0xecc4, 0x9087},
	{0xecc5, 0xf9e9},
	{0xecc6, 0xf9ea},
	{0xecc7, 0x98f4},
	{0xecc8, 0x990c},
	{0xecc9, 0xf9eb},
	{0xecca, 0xf9ec},
	{0xeccb, 0x7037},
	{0xeccc, 0x76ca},
	{0xeccd, 0x7fca},
	{0xecce, 0x7fcc},
	{0xeccf, 0x7ffc},
	{0xecd0, 0x8b1a},
	{0xecd1, 0x4eba},
	{0xecd2, 0x4ec1},
	{0xecd3, 0x5203},
	{0xecd4, 0x5370},
	{0xecd5, 0xf9ed},
	{0xecd6, 0x54bd},
	{0xecd7, 0x56e0},
	{0xecd8, 0x59fb},
	{0xecd9, 0x5bc5},
	{0xecda, 0x5f15},
	{0xecdb, 0x5fcd},
	{0xecdc, 0x6e6e},
	{0xecdd, 0xf9ee},
	{0xecde, 0xf9ef},
	{0xecdf, 0x7d6a},
	{0xece0, 0x8335},
	{0xece1, 0xf9f0},
	{0xece2, 0x8693},
	{0xece3, 0x8a8d},
	{0xece4, 0xf9f1},
	{0xece5, 0x976d},
	{0xece6, 0x9777},
	{0xece7, 0xf9f2},
	{0xece8, 0xf9f3},
	{0xece9, 0x4e00},
	{0xecea, 0x4f5a},
	{0xeceb, 0x4f7e},
	{0xecec, 0x58f9},
	{0xeced, 0x65e5},
	{0xecee, 0x6ea2},
	{0xecef, 0x9038},
	{0xecf0, 0x93b0},
	{0xecf1, 0x99b9},
	{0xecf2, 0x4efb},
	{0xecf3, 0x58ec},
	{0xecf4, 0x598a},
	{0xecf5, 0x59d9},
	{0xecf6, 0x6041},
	{0xecf7, 0xf9f4},
	{0xecf8, 0xf9f5},
	{0xecf9, 0x7a14},
	{0xecfa, 0xf9f6},
	{0xecfb, 0x834f},
	{0xecfc, 0x8cc3},
	{0xecfd, 0x5165},
	{0xecfe, 0x5344},
	{0xeda1, 0xf9f7},
	{0xeda2, 0xf9f8},
	{0xeda3, 0xf9f9},
	{0xeda4, 0x4ecd},
	{0xeda5, 0x5269},
	{0xeda6, 0x5b55},
	{0xeda7, 0x82bf},
	{0xeda8, 0x4ed4},
	{0xeda9, 0x523a},
	{0xedaa, 0x54a8},
	{0xedab, 0x59c9},
	{0xedac, 0x59ff},
	{0xedad, 0x5b50},
	{0xedae, 0x5b57},
	{0xedaf, 0x5b5c},
	{0xedb0, 0x6063},
	{0xedb1, 0x6148},
	{0xedb2, 0x6ecb},
	{0xedb3, 0x7099},
	{0xedb4, 0x716e},
	{0xedb5, 0x7386},
	{0xedb6, 0x74f7},
	{0xedb7, 0x75b5},
	{0xedb8, 0x78c1},
	{0xedb9, 0x7d2b},
	{0xedba, 0x8005},
	{0xedbb, 0x81ea},
	{0xedbc, 0x8328},
	{0xedbd, 0x8517},
	{0xedbe, 0x85c9},
	{0xedbf, 0x8aee},
	{0xedc0, 0x8cc7},
	{0xedc1, 0x96cc},
	{0xedc2, 0x4f5c},
	{0xedc3, 0x52fa},
	{0xedc4, 0x56bc},
	{0xedc5, 0x65ab},
	{0xedc6, 0x6628},
	{0xedc7, 0x707c},
	{0xedc8, 0x70b8},
	{0xedc9, 0x7235},
	{0xedca, 0x7dbd},
	{0xedcb, 0x828d},
	{0xedcc, 0x914c},
	{0xedcd, 0x96c0},
	{0xedce, 0x9d72},
	{0xedcf, 0x5b71},
	{0xedd0, 0x68e7},
	{0xedd1, 0x6b98},
	{0xedd2, 0x6f7a},
	{0xedd3, 0x76de},
	{0xedd4, 0x5c91},
	{0xedd5, 0x66ab},
	{0xedd6, 0x6f5b},
	{0xedd7, 0x7bb4},
	{0xedd8, 0x7c2a},
	{0xedd9, 0x8836},
	{0xedda, 0x96dc},
	{0xeddb, 0x4e08},
	{0xeddc, 0x4ed7},
	{0xeddd, 0x5320},
	{0xedde, 0x5834},
	{0xeddf, 0x58bb},
	{0xede0, 0x58ef},
	{0xede1, 0x596c},
	{0xede2, 0x5c07},
	{0xede3, 0x5e33},
	{0xede4, 0x5e84},
	{0xede5, 0x5f35},
	{0xede6, 0x638c},
	{0xede7, 0x66b2},
	{0xede8, 0x6756},
	{0xede9, 0x6a1f},
	{0xedea, 0x6aa3},
	{0xedeb, 0x6b0c},
	{0xedec, 0x6f3f},
	{0xeded, 0x7246},
	{0xedee, 0xf9fa},
	{0xedef, 0x7350},
	{0xedf0, 0x748b},
	{0xedf1, 0x7ae0},
	{0xedf2, 0x7ca7},
	{0xedf3, 0x8178},
	{0xedf4, 0x81df},
	{0xedf5, 0x81e7},
	{0xedf6, 0x838a},
	{0xedf7, 0x846c},
	{0xedf8, 0x8523},
	{0xedf9, 0x8594},
	{0xedfa, 0x85cf},
	{0xedfb, 0x88dd},
	{0xedfc, 0x8d13},
	{0xedfd, 0x91ac},
	{0xedfe, 0x9577},
	{0xeea1, 0x969c},
	{0xeea2, 0x518d},
	{0xeea3, 0x54c9},
	{0xeea4, 0x5728},
	{0xeea5, 0x5bb0},
	{0xeea6, 0x624d},
	{0xeea7, 0x6750},
	{0xeea8, 0x683d},
	{0xeea9, 0x6893},
	{0xeeaa, 0x6e3d},
	{0xeeab, 0x6ed3},
	{0xeeac, 0x707d},
	{0xeead, 0x7e21},
	{0xeeae, 0x88c1},
	{0xeeaf, 0x8ca1},
	{0xeeb0, 0x8f09},
	{0xeeb1, 0x9f4b},
	{0xeeb2, 0x9f4e},
	{0xeeb3, 0x722d},
	{0xeeb4, 0x7b8f},
	{0xeeb5, 0x8acd},
	{0xeeb6, 0x931a},
	{0xeeb7, 0x4f47},
	{0xeeb8, 0x4f4e},
	{0xeeb9, 0x5132},
	{0xeeba, 0x5480},
	{0xeebb, 0x59d0},
	{0xeebc, 0x5e95},
	{0xeebd, 0x62b5},
	{0xeebe, 0x6775},
	{0xeebf, 0x696e},
	{0xeec0, 0x6a17},
	{0xeec1, 0x6cae},
	{0xeec2, 0x6e1a},
	{0xeec3, 0x72d9},
	{0xeec4, 0x732a},
	{0xeec5, 0x75bd},
	{0xeec6, 0x7bb8},
	{0xeec7, 0x7d35},
	{0xeec8, 0x82e7},
	{0xeec9, 0x83f9},
	{0xeeca, 0x8457},
	{0xeecb, 0x85f7},
	{0xeecc, 0x8a5b},
	{0xeecd, 0x8caf},
	{0xeece, 0x8e87},
	{0xeecf, 0x9019},
	{0xeed0, 0x90b8},
	{0xeed1, 0x96ce},
	{0xeed2, 0x9f5f},
	{0xeed3, 0x52e3},
	{0xeed4, 0x540a},
	{0xeed5, 0x5ae1},
	{0xeed6, 0x5bc2},
	{0xeed7, 0x6458},
	{0xeed8, 0x6575},
	{0xeed9, 0x6ef4},
	{0xeeda, 0x72c4},
	{0xeedb, 0xf9fb},
	{0xeedc, 0x7684},
	{0xeedd, 0x7a4d},
	{0xeede, 0x7b1b},
	{0xeedf, 0x7c4d},
	{0xeee0, 0x7e3e},
	{0xeee1, 0x7fdf},
	{0xeee2, 0x837b},
	{0xeee3, 0x8b2b},
	{0xeee4, 0x8cca},
	{0xeee5, 0x8d64},
	{0xeee6, 0x8de1},
	{0xeee7, 0x8e5f},
	{0xeee8, 0x8fea},
	{0xeee9, 0x8ff9},
	{0xeeea, 0x9069},
	{0xeeeb, 0x93d1},
	{0xeeec, 0x4f43},
	{0xeeed, 0x4f7a},
	{0xeeee, 0x50b3},
	{0xeeef, 0x5168},
	{0xeef0, 0x5178},
	{0xeef1, 0x524d},
	{0xeef2, 0x526a},
	{0xeef3, 0x5861},
	{0xeef4, 0x587c},
	{0xeef5, 0x5960},
	{0xeef6, 0x5c08},
	{0xeef7, 0x5c55},
	{0xeef8, 0x5edb},
	{0xeef9, 0x609b},
	{0xeefa, 0x6230},
	{0xeefb, 0x6813},
	{0xeefc, 0x6bbf},
	{0xeefd, 0x6c08},
	{0xeefe, 0x6fb1},
	{0xefa1, 0x714e},
	{0xefa2, 0x7420},
	{0xefa3, 0x7530},
	{0xefa4, 0x7538},
	{0xefa5, 0x7551},
	{0xefa6, 0x7672},
	{0xefa7, 0x7b4c},
	{0xefa8, 0x7b8b},
	{0xefa9, 0x7bad},
	{0xefaa, 0x7bc6},
	{0xefab, 0x7e8f},
	{0xefac, 0x8a6e},
	{0xefad, 0x8f3e},
	{0xefae, 0x8f49},
	{0xefaf, 0x923f},
	{0xefb0, 0x9293},
	{0xefb1, 0x9322},
	{0xefb2, 0x942b},
	{0xefb3, 0x96fb},
	{0xefb4, 0x985a},
	{0xefb5, 0x986b},
	{0xefb6, 0x991e},
	{0xefb7, 0x5207},
	{0xefb8, 0x622a},
	{0xefb9, 0x6298},
	{0xefba, 0x6d59},
	{0xefbb, 0x7664},
	{0xefbc, 0x7aca},
	{0xefbd, 0x7bc0},
	{0xefbe, 0x7d76},
	{0xefbf, 0x5360},
	{0xefc0, 0x5cbe},
	{0xefc1, 0x5e97},
	{0xefc2, 0x6f38},
	{0xefc3, 0x70b9},
	{0xefc4, 0x7c98},
	{0xefc5, 0x9711},
	{0xefc6, 0x9b8e},
	{0xefc7, 0x9ede},
	{0xefc8, 0x63a5},
	{0xefc9, 0x647a},
	{0xefca, 0x8776},
	{0xefcb, 0x4e01},
	{0xefcc, 0x4e95},
	{0xefcd, 0x4ead},
	{0xefce, 0x505c},
	{0xefcf, 0x5075},
	{0xefd0, 0x5448},
	{0xefd1, 0x59c3},
	{0xefd2, 0x5b9a},
	{0xefd3, 0x5e40},
	{0xefd4, 0x5ead},
	{0xefd5, 0x5ef7},
	{0xefd6, 0x5f81},
	{0xefd7, 0x60c5},
	{0xefd8, 0x633a},
	{0xefd9, 0x653f},
	{0xefda, 0x6574},
	{0xefdb, 0x65cc},
	{0xefdc, 0x6676},
	{0xefdd, 0x6678},
	{0xefde, 0x67fe},
	{0xefdf, 0x6968},
	{0xefe0, 0x6a89},
	{0xefe1, 0x6b63},
	{0xefe2, 0x6c40},
	{0xefe3, 0x6dc0},
	{0xefe4, 0x6de8},
	{0xefe5, 0x6e1f},
	{0xefe6, 0x6e5e},
	{0xefe7, 0x701e},
	{0xefe8, 0x70a1},
	{0xefe9, 0x738e},
	{0xefea, 0x73fd},
	{0xefeb, 0x753a},
	{0xefec, 0x775b},
	{0xefed, 0x7887},
	{0xefee, 0x798e},
	{0xefef, 0x7a0b},
	{0xeff0, 0x7a7d},
	{0xeff1, 0x7cbe},
	{0xeff2, 0x7d8e},
	{0xeff3, 0x8247},
	{0xeff4, 0x8a02},
	{0xeff5, 0x8aea},
	{0xeff6, 0x8c9e},
	{0xeff7, 0x912d},
	{0xeff8, 0x914a},
	{0xeff9, 0x91d8},
	{0xeffa, 0x9266},
	{0xeffb, 0x92cc},
	{0xeffc, 0x9320},
	{0xeffd, 0x9706},
	{0xeffe, 0x9756},
	{0xf0a1, 0x975c},
	{0xf0a2, 0x9802},
	{0xf0a3, 0x9f0e},
	{0xf0a4, 0x5236},
	{0xf0a5, 0x5291},
	{0xf0a6, 0x557c},
	{0xf0a7, 0x5824},
	{0xf0a8, 0x5e1d},
	{0xf0a9, 0x5f1f},
	{0xf0aa, 0x608c},
	{0xf0ab, 0x63d0},
	{0xf0ac, 0x68af},
	{0xf0ad, 0x6fdf},
	{0xf0ae, 0x796d},
	{0xf0af, 0x7b2c},
	{0xf0b0, 0x81cd},
	{0xf0b1, 0x85ba},
	{0xf0b2, 0x88fd},
	{0xf0b3, 0x8af8},
	{0xf0b4, 0x8e44},
	{0xf0b5, 0x918d},
	{0xf0b6, 0x9664},
	{0xf0b7, 0x969b},
	{0xf0b8, 0x973d},
	{0xf0b9, 0x984c},
	{0xf0ba, 0x9f4a},
	{0xf0bb, 0x4fce},
	{0xf0bc, 0x5146},
	{0xf0bd, 0x51cb},
	{0xf0be, 0x52a9},
	{0xf0bf, 0x5632},
	{0xf0c0, 0x5f14},
	{0xf0c1, 0x5f6b},
	{0xf0c2, 0x63aa},
	{0xf0c3, 0x64cd},
	{0xf0c4, 0x65e9},
	{0xf0c5, 0x6641},
	{0xf0c6, 0x66fa},
	{0xf0c7, 0x66f9},
	{0xf0c8, 0x671d},
	{0xf0c9, 0x689d},
	{0xf0ca, 0x68d7},
	{0xf0cb, 0x69fd},
	{0xf0cc, 0x6f15},
	{0xf0cd, 0x6f6e},
	{0xf0ce, 0x7167},
	{0xf0cf, 0x71e5},
	{0xf0d0, 0x722a},
	{0xf0d1, 0x74aa},
	{0xf0d2, 0x773a},
	{0xf0d3, 0x7956},
	{0xf0d4, 0x795a},
	{0xf0d5, 0x79df},
	{0xf0d6, 0x7a20},
	{0xf0d7, 0x7a95},
	{0xf0d8, 0x7c97},
	{0xf0d9, 0x7cdf},
	{0xf0da, 0x7d44},
	{0xf0db, 0x7e70},
	{0xf0dc, 0x8087},
	{0xf0dd, 0x85fb},
	{0xf0de, 0x86a4},
	{0xf0df, 0x8a54},
	{0xf0e0, 0x8abf},
	{0xf0e1, 0x8d99},
	{0xf0e2, 0x8e81},
	{0xf0e3, 0x9020},
	{0xf0e4, 0x906d},
	{0xf0e5, 0x91e3},
	{0xf0e6, 0x963b},
	{0xf0e7, 0x96d5},
	{0xf0e8, 0x9ce5},
	{0xf0e9, 0x65cf},
	{0xf0ea, 0x7c07},
	{0xf0eb, 0x8db3},
	{0xf0ec, 0x93c3},
	{0xf0ed, 0x5b58},
	{0xf0ee, 0x5c0a},
	{0xf0ef, 0x5352},
	{0xf0f0, 0x62d9},
	{0xf0f1, 0x731d},
	{0xf0f2, 0x5027},
	{0xf0f3, 0x5b97},
	{0xf0f4, 0x5f9e},
	{0xf0f5, 0x60b0},
	{0xf0f6, 0x616b},
	{0xf0f7, 0x68d5},
	{0xf0f8, 0x6dd9},
	{0xf0f9, 0x742e},
	{0xf0fa, 0x7a2e},
	{0xf0fb, 0x7d42},
	{0xf0fc, 0x7d9c},
	{0xf0fd, 0x7e31},
	{0xf0fe, 0x816b},
	{0xf1a1, 0x8e2a},
	{0xf1a2, 0x8e35},
	{0xf1a3, 0x937e},
	{0xf1a4, 0x9418},
	{0xf1a5, 0x4f50},
	{0xf1a6, 0x5750},
	{0xf1a7, 0x5de6},
	{0xf1a8, 0x5ea7},
	{0xf1a9, 0x632b},
	{0xf1aa, 0x7f6a},
	{0xf1ab, 0x4e3b},
	{0xf1ac, 0x4f4f},
	{0xf1ad, 0x4f8f},
	{0xf1ae, 0x505a},
	{0xf1af, 0x59dd},
	{0xf1b0, 0x80c4},
	{0xf1b1, 0x546a},
	{0xf1b2, 0x5468},
	{0xf1b3, 0x55fe},
	{0xf1b4, 0x594f},
	{0xf1b5, 0x5b99},
	{0xf1b6, 0x5dde},
	{0xf1b7, 0x5eda},
	{0xf1b8, 0x665d},
	{0xf1b9, 0x6731},
	{0xf1ba, 0x67f1},
	{0xf1bb, 0x682a},
	{0xf1bc, 0x6ce8},
	{0xf1bd, 0x6d32},
	{0xf1be, 0x6e4a},
	{0xf1bf, 0x6f8d},
	{0xf1c0, 0x70b7},
	{0xf1c1, 0x73e0},
	{0xf1c2, 0x7587},
	{0xf1c3, 0x7c4c},
	{0xf1c4, 0x7d02},
	{0xf1c5, 0x7d2c},
	{0xf1c6, 0x7da2},
	{0xf1c7, 0x821f},
	{0xf1c8, 0x86db},
	{0xf1c9, 0x8a3b},
	{0xf1ca, 0x8a85},
	{0xf1cb, 0x8d70},
	{0xf1cc, 0x8e8a},
	{0xf1cd, 0x8f33},
	{0xf1ce, 0x9031},
	{0xf1cf, 0x914e},
	{0xf1d0, 0x9152},
	{0xf1d1, 0x9444},
	{0xf1d2, 0x99d0},
	{0xf1d3, 0x7af9},
	{0xf1d4, 0x7ca5},
	{0xf1d5, 0x4fca},
	{0xf1d6, 0x5101},
	{0xf1d7, 0x51c6},
	{0xf1d8, 0x57c8},
	{0xf1d9, 0x5bef},
	{0xf1da, 0x5cfb},
	{0xf1db, 0x6659},
	{0xf1dc, 0x6a3d},
	{0xf1dd, 0x6d5a},
	{0xf1de, 0x6e96},
	{0xf1df, 0x6fec},
	{0xf1e0, 0x710c},
	{0xf1e1, 0x756f},
	{0xf1e2, 0x7ae3},
	{0xf1e3, 0x8822},
	{0xf1e4, 0x9021},
	{0xf1e5, 0x9075},
	{0xf1e6, 0x96cb},
	{0xf1e7, 0x99ff},
	{0xf1e8, 0x8301},
	{0xf1e9, 0x4e2d},
	{0xf1ea, 0x4ef2},
	{0xf1eb, 0x8846},
	{0xf1ec, 0x91cd},
	{0xf1ed, 0x537d},
	{0xf1ee, 0x6adb},
	{0xf1ef, 0x696b},
	{0xf1f0, 0x6c41},
	{0xf1f1, 0x847a},
	{0xf1f2, 0x589e},
	{0xf1f3, 0x618e},
	{0xf1f4, 0x66fe},
	{0xf1f5, 0x62ef},
	{0xf1f6, 0x70dd},
	{0xf1f7, 0x7511},
	{0xf1f8, 0x75c7},
	{0xf1f9, 0x7e52},
	{0xf1fa, 0x84b8},
	{0xf1fb, 0x8b49},
	{0xf1fc, 0x8d08},
	{0xf1fd, 0x4e4b},
	{0xf1fe, 0x53ea},
	{0xf2a1, 0x54ab},
	{0xf2a2, 0x5730},
	{0xf2a3, 0x5740},
	{0xf2a4, 0x5fd7},
	{0xf2a5, 0x6301},
	{0xf2a6, 0x6307},
	{0xf2a7, 0x646f},
	{0xf2a8, 0x652f},
	{0xf2a9, 0x65e8},
	{0xf2aa, 0x667a},
	{0xf2ab, 0x679d},
	{0xf2ac, 0x67b3},
	{0xf2ad, 0x6b62},
	{0xf2ae, 0x6c60},
	{0xf2af, 0x6c9a},
	{0xf2b0, 0x6f2c},
	{0xf2b1, 0x77e5},
	{0xf2b2, 0x7825},
	{0xf2b3, 0x7949},
	{0xf2b4, 0x7957},
	{0xf2b5, 0x7d19},
	{0xf2b6, 0x80a2},
	{0xf2b7, 0x8102},
	{0xf2b8, 0x81f3},
	{0xf2b9, 0x829d},
	{0xf2ba, 0x82b7},
	{0xf2bb, 0x8718},
	{0xf2bc, 0x8a8c},
	{0xf2bd, 0xf9fc},
	{0xf2be, 0x8d04},
	{0xf2bf, 0x8dbe},
	{0xf2c0, 0x9072},
	{0xf2c1, 0x76f4},
	{0xf2c2, 0x7a19},
	{0xf2c3, 0x7a37},
	{0xf2c4, 0x7e54},
	{0xf2c5, 0x8077},
	{0xf2c6, 0x5507},
	{0xf2c7, 0x55d4},
	{0xf2c8, 0x5875},
	{0xf2c9, 0x632f},
	{0xf2ca, 0x6422},
	{0xf2cb, 0x6649},
	{0xf2cc, 0x664b},
	{0xf2cd, 0x686d},
	{0xf2ce, 0x699b},
	{0xf2cf, 0x6b84},
	{0xf2d0, 0x6d25},
	{0xf2d1, 0x6eb1},
	{0xf2d2, 0x73cd},
	{0xf2d3, 0x7468},
	{0xf2d4, 0x74a1},
	{0xf2d5, 0x755b},
	{0xf2d6, 0x75b9},
	{0xf2d7, 0x76e1},
	{0xf2d8, 0x771e},
	{0xf2d9, 0x778b},
	{0xf2da, 0x79e6},
	{0xf2db, 0x7e09},
	{0xf2dc, 0x7e1d},
	{0xf2dd, 0x81fb},
	{0xf2de, 0x852f},
	{0xf2df, 0x8897},
	{0xf2e0, 0x8a3a},
	{0xf2e1, 0x8cd1},
	{0xf2e2, 0x8eeb},
	{0xf2e3, 0x8fb0},
	{0xf2e4, 0x9032},
	{0xf2e5, 0x93ad},
	{0xf2e6, 0x9663},
	{0xf2e7, 0x9673},
	{0xf2e8, 0x9707},
	{0xf2e9, 0x4f84},
	{0xf2ea, 0x53f1},
	{0xf2eb, 0x59ea},
	{0xf2ec, 0x5ac9},
	{0xf2ed, 0x5e19},
	{0xf2ee, 0x684e},
	{0xf2ef, 0x74c6},
	{0xf2f0, 0x75be},
	{0xf2f1, 0x79e9},
	{0xf2f2, 0x7a92},
	{0xf2f3, 0x81a3},
	{0xf2f4, 0x86ed},
	{0xf2f5, 0x8cea},
	{0xf2f6, 0x8dcc},
	{0xf2f7, 0x8fed},
	{0xf2f8, 0x659f},
	{0xf2f9, 0x6715},
	{0xf2fa, 0xf9fd},
	{0xf2fb, 0x57f7},
	{0xf2fc, 0x6f57},
	{0xf2fd, 0x7ddd},
	{0xf2fe, 0x8f2f},
	{0xf3a1, 0x93f6},
	{0xf3a2, 0x96c6},
	{0xf3a3, 0x5fb5},
	{0xf3a4, 0x61f2},
	{0xf3a5, 0x6f84},
	{0xf3a6, 0x4e14},
	{0xf3a7, 0x4f98},
	{0xf3a8, 0x501f},
	{0xf3a9, 0x53c9},
	{0xf3aa, 0x55df},
	{0xf3ab, 0x5d6f},
	{0xf3ac, 0x5dee},
	{0xf3ad, 0x6b21},
	{0xf3ae, 0x6b64},
	{0xf3af, 0x78cb},
	{0xf3b0, 0x7b9a},
	{0xf3b1, 0xf9fe},
	{0xf3b2, 0x8e49},
	{0xf3b3, 0x8eca},
	{0xf3b4, 0x906e},
	{0xf3b5, 0x6349},
	{0xf3b6, 0x643e},
	{0xf3b7, 0x7740},
	{0xf3b8, 0x7a84},
	{0xf3b9, 0x932f},
	{0xf3ba, 0x947f},
	{0xf3bb, 0x9f6a},
	{0xf3bc, 0x64b0},
	{0xf3bd, 0x6faf},
	{0xf3be, 0x71e6},
	{0xf3bf, 0x74a8},
	{0xf3c0, 0x74da},
	{0xf3c1, 0x7ac4},
	{0xf3c2, 0x7c12},
	{0xf3c3, 0x7e82},
	{0xf3c4, 0x7cb2},
	{0xf3c5, 0x7e98},
	{0xf3c6, 0x8b9a},
	{0xf3c7, 0x8d0a},
	{0xf3c8, 0x947d},
	{0xf3c9, 0x9910},
	{0xf3ca, 0x994c},
	{0xf3cb, 0x5239},
	{0xf3cc, 0x5bdf},
	{0xf3cd, 0x64e6},
	{0xf3ce, 0x672d},
	{0xf3cf, 0x7d2e},
	{0xf3d0, 0x50ed},
	{0xf3d1, 0x53c3},
	{0xf3d2, 0x5879},
	{0xf3d3, 0x6158},
	{0xf3d4, 0x6159},
	{0xf3d5, 0x61fa},
	{0xf3d6, 0x65ac},
	{0xf3d7, 0x7ad9},
	{0xf3d8, 0x8b92},
	{0xf3d9, 0x8b96},
	{0xf3da, 0x5009},
	{0xf3db, 0x5021},
	{0xf3dc, 0x5275},
	{0xf3dd, 0x5531},
	{0xf3de, 0x5a3c},
	{0xf3df, 0x5ee0},
	{0xf3e0, 0x5f70},
	{0xf3e1, 0x6134},
	{0xf3e2, 0x655e},
	{0xf3e3, 0x660c},
	{0xf3e4, 0x6636},
	{0xf3e5, 0x66a2},
	{0xf3e6, 0x69cd},
	{0xf3e7, 0x6ec4},
	{0xf3e8, 0x6f32},
	{0xf3e9, 0x7316},
	{0xf3ea, 0x7621},
	{0xf3eb, 0x7a93},
	{0xf3ec, 0x8139},
	{0xf3ed, 0x8259},
	{0xf3ee, 0x83d6},
	{0xf3ef, 0x84bc},
	{0xf3f0, 0x50b5},
	{0xf3f1, 0x57f0},
	{0xf3f2, 0x5bc0},
	{0xf3f3, 0x5be8},
	{0xf3f4, 0x5f69},
	{0xf3f5, 0x63a1},
	{0xf3f6, 0x7826},
	{0xf3f7, 0x7db5},
	{0xf3f8, 0x83dc},
	{0xf3f9, 0x8521},
	{0xf3fa, 0x91c7},
	{0xf3fb, 0x91f5},
	{0xf3fc, 0x518a},
	{0xf3fd, 0x67f5},
	{0xf3fe, 0x7b56},
	{0xf4a1, 0x8cac},
	{0xf4a2, 0x51c4},
	{0xf4a3, 0x59bb},
	{0xf4a4, 0x60bd},
	{0xf4a5, 0x8655},
	{0xf4a6, 0x501c},
	{0xf4a7, 0xf9ff},
	{0xf4a8, 0x5254},
	{0xf4a9, 0x5c3a},
	{0xf4aa, 0x617d},
	{0xf4ab, 0x621a},
	{0xf4ac, 0x62d3},
	{0xf4ad, 0x64f2},
	{0xf4ae, 0x65a5},
	{0xf4af, 0x6ecc},
	{0xf4b0, 0x7620},
	{0xf4b1, 0x810a},
	{0xf4b2, 0x8e60},
	{0xf4b3, 0x965f},
	{0xf4b4, 0x96bb},
	{0xf4b5, 0x4edf},
	{0xf4b6, 0x5343},
	{0xf4b7, 0x5598},
	{0xf4b8, 0x5929},
	{0xf4b9, 0x5ddd},
	{0xf4ba, 0x64c5},
	{0xf4bb, 0x6cc9},
	{0xf4bc, 0x6dfa},
	{0xf4bd, 0x7394},
	{0xf4be, 0x7a7f},
	{0xf4bf, 0x821b},
	{0xf4c0, 0x85a6},
	{0xf4c1, 0x8ce4},
	{0xf4c2, 0x8e10},
	{0xf4c3, 0x9077},
	{0xf4c4, 0x91e7},
	{0xf4c5, 0x95e1},
	{0xf4c6, 0x9621},
	{0xf4c7, 0x97c6},
	{0xf4c8, 0x51f8},
	{0xf4c9, 0x54f2},
	{0xf4ca, 0x5586},
	{0xf4cb, 0x5fb9},
	{0xf4cc, 0x64a4},
	{0xf4cd, 0x6f88},
	{0xf4ce, 0x7db4},
	{0xf4cf, 0x8f1f},
	{0xf4d0, 0x8f4d},
	{0xf4d1, 0x9435},
	{0xf4d2, 0x50c9},
	{0xf4d3, 0x5c16},
	{0xf4d4, 0x6cbe},
	{0xf4d5, 0x6dfb},
	{0xf4d6, 0x751b},
	{0xf4d7, 0x77bb},
	{0xf4d8, 0x7c3d},
	{0xf4d9, 0x7c64},
	{0xf4da, 0x8a79},
	{0xf4db, 0x8ac2},
	{0xf4dc, 0x581e},
	{0xf4dd, 0x59be},
	{0xf4de, 0x5e16},
	{0xf4df, 0x6377},
	{0xf4e0, 0x7252},
	{0xf4e1, 0x758a},
	{0xf4e2, 0x776b},
	{0xf4e3, 0x8adc},
	{0xf4e4, 0x8cbc},
	{0xf4e5, 0x8f12},
	{0xf4e6, 0x5ef3},
	{0xf4e7, 0x6674},
	{0xf4e8, 0x6df8},
	{0xf4e9, 0x807d},
	{0xf4ea, 0x83c1},
	{0xf4eb, 0x8acb},
	{0xf4ec, 0x9751},
	{0xf4ed, 0x9bd6},
	{0xf4ee, 0xfa00},
	{0xf4ef, 0x5243},
	{0xf4f0, 0x66ff},
	{0xf4f1, 0x6d95},
	{0xf4f2, 0x6eef},
	{0xf4f3, 0x7de0},
	{0xf4f4, 0x8ae6},
	{0xf4f5, 0x902e},
	{0xf4f6, 0x905e},
	{0xf4f7, 0x9ad4},
	{0xf4f8, 0x521d},
	{0xf4f9, 0x527f},
	{0xf4fa, 0x54e8},
	{0xf4fb, 0x6194},
	{0xf4fc, 0x6284},
	{0xf4fd, 0x62db},
	{0xf4fe, 0x68a2},
	{0xf5a1, 0x6912},
	{0xf5a2, 0x695a},
	{0xf5a3, 0x6a35},
	{0xf5a4, 0x7092},
	{0xf5a5, 0x7126},
	{0xf5a6, 0x785d},
	{0xf5a7, 0x7901},
	{0xf5a8, 0x790e},
	{0xf5a9, 0x79d2},
	{0xf5aa, 0x7a0d},
	{0xf5ab, 0x8096},
	{0xf5ac, 0x8278},
	{0xf5ad, 0x82d5},
	{0xf5ae, 0x8349},
	{0xf5af, 0x8549},
	{0xf5b0, 0x8c82},
	{0xf5b1, 0x8d85},
	{0xf5b2, 0x9162},
	{0xf5b3, 0x918b},
	{0xf5b4, 0x91ae},
	{0xf5b5, 0x4fc3},
	{0xf5b6, 0x56d1},
	{0xf5b7, 0x71ed},
	{0xf5b8, 0x77d7},
	{0xf5b9, 0x8700},
	{0xf5ba, 0x89f8},
	{0xf5bb, 0x5bf8},
	{0xf5bc, 0x5fd6},
	{0xf5bd, 0x6751},
	{0xf5be, 0x90a8},
	{0xf5bf, 0x53e2},
	{0xf5c0, 0x585a},
	{0xf5c1, 0x5bf5},
	{0xf5c2, 0x60a4},
	{0xf5c3, 0x6181},
	{0xf5c4, 0x6460},
	{0xf5c5, 0x7e3d},
	{0xf5c6, 0x8070},
	{0xf5c7, 0x8525},
	{0xf5c8, 0x9283},
	{0xf5c9, 0x64ae},
	{0xf5ca, 0x50ac},
	{0xf5cb, 0x5d14},
	{0xf5cc, 0x6700},
	{0xf5cd, 0x589c},
	{0xf5ce, 0x62bd},
	{0xf5cf, 0x63a8},
	{0xf5d0, 0x690e},
	{0xf5d1, 0x6978},
	{0xf5d2, 0x6a1e},
	{0xf5d3, 0x6e6b},
	{0xf5d4, 0x76ba},
	{0xf5d5, 0x79cb},
	{0xf5d6, 0x82bb},
	{0xf5d7, 0x8429},
	{0xf5d8, 0x8acf},
	{0xf5d9, 0x8da8},
	{0xf5da, 0x8ffd},
	{0xf5db, 0x9112},
	{0xf5dc, 0x914b},
	{0xf5dd, 0x919c},
	{0xf5de, 0x9310},
	{0xf5df, 0x9318},
	{0xf5e0, 0x939a},
	{0xf5e1, 0x96db},
	{0xf5e2, 0x9a36},
	{0xf5e3, 0x9c0d},
	{0xf5e4, 0x4e11},
	{0xf5e5, 0x755c},
	{0xf5e6, 0x795d},
	{0xf5e7, 0x7afa},
	{0xf5e8, 0x7b51},
	{0xf5e9, 0x7bc9},
	{0xf5ea, 0x7e2e},
	{0xf5eb, 0x84c4},
	{0xf5ec, 0x8e59},
	{0xf5ed, 0x8e74},
	{0xf5ee, 0x8ef8},
	{0xf5ef, 0x9010},
	{0xf5f0, 0x6625},
	{0xf5f1, 0x693f},
	{0xf5f2, 0x7443},
	{0xf5f3, 0x51fa},
	{0xf5f4, 0x672e},
	{0xf5f5, 0x9edc},
	{0xf5f6, 0x5145},
	{0xf5f7, 0x5fe0},
	{0xf5f8, 0x6c96},
	{0xf5f9, 0x87f2},
	{0xf5fa, 0x885d},
	{0xf5fb, 0x8877},
	{0xf5fc, 0x60b4},
	{0xf5fd, 0x81b5},
	{0xf5fe, 0x8403},
	{0xf6a1, 0x8d05},
	{0xf6a2, 0x53d6},
	{0xf6a3, 0x5439},
	{0xf6a4, 0x5634},
	{0xf6a5, 0x5a36},
	{0xf6a6, 0x5c31},
	{0xf6a7, 0x708a},
	{0xf6a8, 0x7fe0},
	{0xf6a9, 0x805a},
	{0xf6aa, 0x8106},
	{0xf6ab, 0x81ed},
	{0xf6ac, 0x8da3},
	{0xf6ad, 0x9189},
	{0xf6ae, 0x9a5f},
	{0xf6af, 0x9df2},
	{0xf6b0, 0x5074},
	{0xf6b1, 0x4ec4},
	{0xf6b2, 0x53a0},
	{0xf6b3, 0x60fb},
	{0xf6b4, 0x6e2c},
	{0xf6b5, 0x5c64},
	{0xf6b6, 0x4f88},
	{0xf6b7, 0x5024},
	{0xf6b8, 0x55e4},
	{0xf6b9, 0x5cd9},
	{0xf6ba, 0x5e5f},
	{0xf6bb, 0x6065},
	{0xf6bc, 0x6894},
	{0xf6bd, 0x6cbb},
	{0xf6be, 0x6dc4},
	{0xf6bf, 0x71be},
	{0xf6c0, 0x75d4},
	{0xf6c1, 0x75f4},
	{0xf6c2, 0x7661},
	{0xf6c3, 0x7a1a},
	{0xf6c4, 0x7a49},
	{0xf6c5, 0x7dc7},
	{0xf6c6, 0x7dfb},
	{0xf6c7, 0x7f6e},
	{0xf6c8, 0x81f4},
	{0xf6c9, 0x86a9},
	{0xf6ca, 0x8f1c},
	{0xf6cb, 0x96c9},
	{0xf6cc, 0x99b3},
	{0xf6cd, 0x9f52},
	{0xf6ce, 0x5247},
	{0xf6cf, 0x52c5},
	{0xf6d0, 0x98ed},
	{0xf6d1, 0x89aa},
	{0xf6d2, 0x4e03},
	{0xf6d3, 0x67d2},
	{0xf6d4, 0x6f06},
	{0xf6d5, 0x4fb5},
	{0xf6d6, 0x5be2},
	{0xf6d7, 0x6795},
	{0xf6d8, 0x6c88},
	{0xf6d9, 0x6d78},
	{0xf6da, 0x741b},
	{0xf6db, 0x7827},
	{0xf6dc, 0x91dd},
	{0xf6dd, 0x937c},
	{0xf6de, 0x87c4},
	{0xf6df, 0x79e4},
	{0xf6e0, 0x7a31},
	{0xf6e1, 0x5feb},
	{0xf6e2, 0x4ed6},
	{0xf6e3, 0x54a4},
	{0xf6e4, 0x553e},
	{0xf6e5, 0x58ae},
	{0xf6e6, 0x59a5},
	{0xf6e7, 0x60f0},
	{0xf6e8, 0x6253},
	{0xf6e9, 0x62d6},
	{0xf6ea, 0x6736},
	{0xf6eb, 0x6955},
	{0xf6ec, 0x8235},
	{0xf6ed, 0x9640},
	{0xf6ee, 0x99b1},
	{0xf6ef, 0x99dd},
	{0xf6f0, 0x502c},
	{0xf6f1, 0x5353},
	{0xf6f2, 0x5544},
	{0xf6f3, 0x577c},
	{0xf6f4, 0xfa01},
	{0xf6f5, 0x6258},
	{0xf6f6, 0xfa02},
	{0xf6f7, 0x64e2},
	{0xf6f8, 0x666b},
	{0xf6f9, 0x67dd},
	{0xf6fa, 0x6fc1},
	{0xf6fb, 0x6fef},
	{0xf6fc, 0x7422},
	{0xf6fd, 0x7438},
	{0xf6fe, 0x8a17},
	{0xf7a1, 0x9438},
	{0xf7a2, 0x5451},
	{0xf7a3, 0x5606},
	{0xf7a4, 0x5766},
	{0xf7a5, 0x5f48},
	{0xf7a6, 0x619a},
	{0xf7a7, 0x6b4e},
	{0xf7a8, 0x7058},
	{0xf7a9, 0x70ad},
	{0xf7aa, 0x7dbb},
	{0xf7ab, 0x8a95},
	{0xf7ac, 0x596a},
	{0xf7ad, 0x812b},
	{0xf7ae, 0x63a2},
	{0xf7af, 0x7708},
	{0xf7b0, 0x803d},
	{0xf7b1, 0x8caa},
	{0xf7b2, 0x5854},
	{0xf7b3, 0x642d},
	{0xf7b4, 0x69bb},
	{0xf7b5, 0x5b95},
	{0xf7b6, 0x5e11},
	{0xf7b7, 0x6e6f},
	{0xf7b8, 0xfa03},
	{0xf7b9, 0x8569},
	{0xf7ba, 0x514c},
	{0xf7bb, 0x53f0},
	{0xf7bc, 0x592a},
	{0xf7bd, 0x6020},
	{0xf7be, 0x614b},
	{0xf7bf, 0x6b86},
	{0xf7c0, 0x6c70},
	{0xf7c1, 0x6cf0},
	{0xf7c2, 0x7b1e},
	{0xf7c3, 0x80ce},
	{0xf7c4, 0x82d4},
	{0xf7c5, 0x8dc6},
	{0xf7c6, 0x90b0},
	{0xf7c7, 0x98b1},
	{0xf7c8, 0xfa04},
	{0xf7c9, 0x64c7},
	{0xf7ca, 0x6fa4},
	{0xf7cb, 0x6491},
	{0xf7cc, 0x6504},
	{0xf7cd, 0x514e},
	{0xf7ce, 0x5410},
	{0xf7cf, 0x571f},
	{0xf7d0, 0x8a0e},
	{0xf7d1, 0x615f},
	{0xf7d2, 0x6876},
	{0xf7d3, 0xfa05},
	{0xf7d4, 0x75db},
	{0xf7d5, 0x7b52},
	{0xf7d6, 0x7d71},
	{0xf7d7, 0x901a},
	{0xf7d8, 0x5806},
	{0xf7d9, 0x69cc},
	{0xf7da, 0x817f},
	{0xf7db, 0x892a},
	{0xf7dc, 0x9000},
	{0xf7dd, 0x9839},
	{0xf7de, 0x5078},
	{0xf7df, 0x5957},
	{0xf7e0, 0x59ac},
	{0xf7e1, 0x6295},
	{0xf7e2, 0x900f},
	{0xf7e3, 0x9b2a},
	{0xf7e4, 0x615d},
	{0xf7e5, 0x7279},
	{0xf7e6, 0x95d6},
	{0xf7e7, 0x5761},
	{0xf7e8, 0x5a46},
	{0xf7e9, 0x5df4},
	{0xf7ea, 0x628a},
	{0xf7eb, 0x64ad},
	{0xf7ec, 0x64fa},
	{0xf7ed, 0x6777},
	{0xf7ee, 0x6ce2},
	{0xf7ef, 0x6d3e},
	{0xf7f0, 0x722c},
	{0xf7f1, 0x7436},
	{0xf7f2, 0x7834},
	{0xf7f3, 0x7f77},
	{0xf7f4, 0x82ad},
	{0xf7f5, 0x8ddb},
	{0xf7f6, 0x9817},
	{0xf7f7, 0x5224},
	{0xf7f8, 0x5742},
	{0xf7f9, 0x677f},
	{0xf7fa, 0x7248},
	{0xf7fb, 0x74e3},
	{0xf7fc, 0x8ca9},
	{0xf7fd, 0x8fa6},
	{0xf7fe, 0x9211},
	{0xf8a1, 0x962a},
	{0xf8a2, 0x516b},
	{0xf8a3, 0x53ed},
	{0xf8a4, 0x634c},
	{0xf8a5, 0x4f69},
	{0xf8a6, 0x5504},
	{0xf8a7, 0x6096},
	{0xf8a8, 0x6557},
	{0xf8a9, 0x6c9b},
	{0xf8aa, 0x6d7f},
	{0xf8ab, 0x724c},
	{0xf8ac, 0x72fd},
	{0xf8ad, 0x7a17},
	{0xf8ae, 0x8987},
	{0xf8af, 0x8c9d},
	{0xf8b0, 0x5f6d},
	{0xf8b1, 0x6f8e},
	{0xf8b2, 0x70f9},
	{0xf8b3, 0x81a8},
	{0xf8b4, 0x610e},
	{0xf8b5, 0x4fbf},
	{0xf8b6, 0x504f},
	{0xf8b7, 0x6241},
	{0xf8b8, 0x7247},
	{0xf8b9, 0x7bc7},
	{0xf8ba, 0x7de8},
	{0xf8bb, 0x7fe9},
	{0xf8bc, 0x904d},
	{0xf8bd, 0x97ad},
	{0xf8be, 0x9a19},
	{0xf8bf, 0x8cb6},
	{0xf8c0, 0x576a},
	{0xf8c1, 0x5e73},
	{0xf8c2, 0x67b0},
	{0xf8c3, 0x840d},
	{0xf8c4, 0x8a55},
	{0xf8c5, 0x5420},
	{0xf8c6, 0x5b16},
	{0xf8c7, 0x5e63},
	{0xf8c8, 0x5ee2},
	{0xf8c9, 0x5f0a},
	{0xf8ca, 0x6583},
	{0xf8cb, 0x80ba},
	{0xf8cc, 0x853d},
	{0xf8cd, 0x9589},
	{0xf8ce, 0x965b},
	{0xf8cf, 0x4f48},
	{0xf8d0, 0x5305},
	{0xf8d1, 0x530d},
	{0xf8d2, 0x530f},
	{0xf8d3, 0x5486},
	{0xf8d4, 0x54fa},
	{0xf8d5, 0x5703},
	{0xf8d6, 0x5e03},
	{0xf8d7, 0x6016},
	{0xf8d8, 0x629b},
	{0xf8d9, 0x62b1},
	{0xf8da, 0x6355},
	{0xf8db, 0xfa06},
	{0xf8dc, 0x6ce1},
	{0xf8dd, 0x6d66},
	{0xf8de, 0x75b1},
	{0xf8df, 0x7832},
	{0xf8e0, 0x80de},
	{0xf8e1, 0x812f},
	{0xf8e2, 0x82de},
	{0xf8e3, 0x8461},
	{0xf8e4, 0x84b2},
	{0xf8e5, 0x888d},
	{0xf8e6, 0x8912},
	{0xf8e7, 0x900b},
	{0xf8e8, 0x92ea},
	{0xf8e9, 0x98fd},
	{0xf8ea, 0x9b91},
	{0xf8eb, 0x5e45},
	{0xf8ec, 0x66b4},
	{0xf8ed, 0x66dd},
	{0xf8ee, 0x7011},
	{0xf8ef, 0x7206},
	{0xf8f0, 0xfa07},
	{0xf8f1, 0x4ff5},
	{0xf8f2, 0x527d},
	{0xf8f3, 0x5f6a},
	{0xf8f4, 0x6153},
	{0xf8f5, 0x6753},
	{0xf8f6, 0x6a19},
	{0xf8f7, 0x6f02},
	{0xf8f8, 0x74e2},
	{0xf8f9, 0x7968},
	{0xf8fa, 0x8868},
	{0xf8fb, 0x8c79},
	{0xf8fc, 0x98c7},
	{0xf8fd, 0x98c4},
	{0xf8fe, 0x9a43},
	{0xf9a1, 0x54c1},
	{0xf9a2, 0x7a1f},
	{0xf9a3, 0x6953},
	{0xf9a4, 0x8af7},
	{0xf9a5, 0x8c4a},
	{0xf9a6, 0x98a8},
	{0xf9a7, 0x99ae},
	{0xf9a8, 0x5f7c},
	{0xf9a9, 0x62ab},
	{0xf9aa, 0x75b2},
	{0xf9ab, 0x76ae},
	{0xf9ac, 0x88ab},
	{0xf9ad, 0x907f},
	{0xf9ae, 0x9642},
	{0xf9af, 0x5339},
	{0xf9b0, 0x5f3c},
	{0xf9b1, 0x5fc5},
	{0xf9b2, 0x6ccc},
	{0xf9b3, 0x73cc},
	{0xf9b4, 0x7562},
	{0xf9b5, 0x758b},
	{0xf9b6, 0x7b46},
	{0xf9b7, 0x82fe},
	{0xf9b8, 0x999d},
	{0xf9b9, 0x4e4f},
	{0xf9ba, 0x903c},
	{0xf9bb, 0x4e0b},
	{0xf9bc, 0x4f55},
	{0xf9bd, 0x53a6},
	{0xf9be, 0x590f},
	{0xf9bf, 0x5ec8},
	{0xf9c0, 0x6630},
	{0xf9c1, 0x6cb3},
	{0xf9c2, 0x7455},
	{0xf9c3, 0x8377},
	{0xf9c4, 0x8766},
	{0xf9c5, 0x8cc0},
	{0xf9c6, 0x9050},
	{0xf9c7, 0x971e},
	{0xf9c8, 0x9c15},
	{0xf9c9, 0x58d1},
	{0xf9ca, 0x5b78},
	{0xf9cb, 0x8650},
	{0xf9cc, 0x8b14},
	{0xf9cd, 0x9db4},
	{0xf9ce, 0x5bd2},
	{0xf9cf, 0x6068},
	{0xf9d0, 0x608d},
	{0xf9d1, 0x65f1},
	{0xf9d2, 0x6c57},
	{0xf9d3, 0x6f22},
	{0xf9d4, 0x6fa3},
	{0xf9d5, 0x701a},
	{0xf9d6, 0x7f55},
	{0xf9d7, 0x7ff0},
	{0xf9d8, 0x9591},
	{0xf9d9, 0x9592},
	{0xf9da, 0x9650},
	{0xf9db, 0x97d3},
	{0xf9dc, 0x5272},
	{0xf9dd, 0x8f44},
	{0xf9de, 0x51fd},
	{0xf9df, 0x542b},
	{0xf9e0, 0x54b8},
	{0xf9e1, 0x5563},
	{0xf9e2, 0x558a},
	{0xf9e3, 0x6abb},
	{0xf9e4, 0x6db5},
	{0xf9e5, 0x7dd8},
	{0xf9e6, 0x8266},
	{0xf9e7, 0x929c},
	{0xf9e8, 0x9677},
	{0xf9e9, 0x9e79},
	{0xf9ea, 0x5408},
	{0xf9eb, 0x54c8},
	{0xf9ec, 0x76d2},
	{0xf9ed, 0x86e4},
	{0xf9ee, 0x95a4},
	{0xf9ef, 0x95d4},
	{0xf9f0, 0x965c},
	{0xf9f1, 0x4ea2},
	{0xf9f2, 0x4f09},
	{0xf9f3, 0x59ee},
	{0xf9f4, 0x5ae6},
	{0xf9f5, 0x5df7},
	{0xf9f6, 0x6052},
	{0xf9f7, 0x6297},
	{0xf9f8, 0x676d},
	{0xf9f9, 0x6841},
	{0xf9fa, 0x6c86},
	{0xf9fb, 0x6e2f},
	{0xf9fc, 0x7f38},
	{0xf9fd, 0x809b},
	{0xf9fe, 0x822a},
	{0xfaa1, 0xfa08},
	{0xfaa2, 0xfa09},
	{0xfaa3, 0x9805},
	{0xfaa4, 0x4ea5},
	{0xfaa5, 0x5055},
	{0xfaa6, 0x54b3},
	{0xfaa7, 0x5793},
	{0xfaa8, 0x595a},
	{0xfaa9, 0x5b69},
	{0xfaaa, 0x5bb3},
	{0xfaab, 0x61c8},
	{0xfaac, 0x6977},
	{0xfaad, 0x6d77},
	{0xfaae, 0x7023},
	{0xfaaf, 0x87f9},
	{0xfab0, 0x89e3},
	{0xfab1, 0x8a72},
	{0xfab2, 0x8ae7},
	{0xfab3, 0x9082},
	{0xfab4, 0x99ed},
	{0xfab5, 0x9ab8},
	{0xfab6, 0x52be},
	{0xfab7, 0x6838},
	{0xfab8, 0x5016},
	{0xfab9, 0x5e78},
	{0xfaba, 0x674f},
	{0xfabb, 0x8347},
	{0xfabc, 0x884c},
	{0xfabd, 0x4eab},
	{0xfabe, 0x5411},
	{0xfabf, 0x56ae},
	{0xfac0, 0x73e6},
	{0xfac1, 0x9115},
	{0xfac2, 0x97ff},
	{0xfac3, 0x9909},
	{0xfac4, 0x9957},
	{0xfac5, 0x9999},
	{0xfac6, 0x5653},
	{0xfac7, 0x589f},
	{0xfac8, 0x865b},
	{0xfac9, 0x8a31},
	{0xfaca, 0x61b2},
	{0xfacb, 0x6af6},
	{0xfacc, 0x737b},
	{0xfacd, 0x8ed2},
	{0xface, 0x6b47},
	{0xfacf, 0x96aa},
	{0xfad0, 0x9a57},
	{0xfad1, 0x5955},
	{0xfad2, 0x7200},
	{0xfad3, 0x8d6b},
	{0xfad4, 0x9769},
	{0xfad5, 0x4fd4},
	{0xfad6, 0x5cf4},
	{0xfad7, 0x5f26},
	{0xfad8, 0x61f8},
	{0xfad9, 0x665b},
	{0xfada, 0x6ceb},
	{0xfadb, 0x70ab},
	{0xfadc, 0x7384},
	{0xfadd, 0x73b9},
	{0xfade, 0x73fe},
	{0xfadf, 0x7729},
	{0xfae0, 0x774d},
	{0xfae1, 0x7d43},
	{0xfae2, 0x7d62},
	{0xfae3, 0x7e23},
	{0xfae4, 0x8237},
	{0xfae5, 0x8852},
	{0xfae6, 0xfa0a},
	{0xfae7, 0x8ce2},
	{0xfae8, 0x9249},
	{0xfae9, 0x986f},
	{0xfaea, 0x5b51},
	{0xfaeb, 0x7a74},
	{0xfaec, 0x8840},
	{0xfaed, 0x9801},
	{0xfaee, 0x5acc},
	{0xfaef, 0x4fe0},
	{0xfaf0, 0x5354},
	{0xfaf1, 0x593e},
	{0xfaf2, 0x5cfd},
	{0xfaf3, 0x633e},
	{0xfaf4, 0x6d79},
	{0xfaf5, 0x72f9},
	{0xfaf6, 0x8105},
	{0xfaf7, 0x8107},
	{0xfaf8, 0x83a2},
	{0xfaf9, 0x92cf},
	{0xfafa, 0x9830},
	{0xfafb, 0x4ea8},
	{0xfafc, 0x5144},
	{0xfafd, 0x5211},
	{0xfafe, 0x578b},
	{0xfba1, 0x5f62},
	{0xfba2, 0x6cc2},
	{0xfba3, 0x6ece},
	{0xfba4, 0x7005},
	{0xfba5, 0x7050},
	{0xfba6, 0x70af},
	{0xfba7, 0x7192},
	{0xfba8, 0x73e9},
	{0xfba9, 0x7469},
	{0xfbaa, 0x834a},
	{0xfbab, 0x87a2},
	{0xfbac, 0x8861},
	{0xfbad, 0x9008},
	{0xfbae, 0x90a2},
	{0xfbaf, 0x93a3},
	{0xfbb0, 0x99a8},
	{0xfbb1, 0x516e},
	{0xfbb2, 0x5f57},
	{0xfbb3, 0x60e0},
	{0xfbb4, 0x6167},
	{0xfbb5, 0x66b3},
	{0xfbb6, 0x8559},
	{0xfbb7, 0x8e4a},
	{0xfbb8, 0x91af},
	{0xfbb9, 0x978b},
	{0xfbba, 0x4e4e},
	{0xfbbb, 0x4e92},
	{0xfbbc, 0x547c},
	{0xfbbd, 0x58d5},
	{0xfbbe, 0x58fa},
	{0xfbbf, 0x597d},
	{0xfbc0, 0x5cb5},
	{0xfbc1, 0x5f27},
	{0xfbc2, 0x6236},
	{0xfbc3, 0x6248},
	{0xfbc4, 0x660a},
	{0xfbc5, 0x6667},
	{0xfbc6, 0x6beb},
	{0xfbc7, 0x6d69},
	{0xfbc8, 0x6dcf},
	{0xfbc9, 0x6e56},
	{0xfbca, 0x6ef8},
	{0xfbcb, 0x6f94},
	{0xfbcc, 0x6fe0},
	{0xfbcd, 0x6fe9},
	{0xfbce, 0x705d},
	{0xfbcf, 0x72d0},
	{0xfbd0, 0x7425},
	{0xfbd1, 0x745a},
	{0xfbd2, 0x74e0},
	{0xfbd3, 0x7693},
	{0xfbd4, 0x795c},
	{0xfbd5, 0x7cca},
	{0xfbd6, 0x7e1e},
	{0xfbd7, 0x80e1},
	{0xfbd8, 0x82a6},
	{0xfbd9, 0x846b},
	{0xfbda, 0x84bf},
	{0xfbdb, 0x864e},
	{0xfbdc, 0x865f},
	{0xfbdd, 0x8774},
	{0xfbde, 0x8b77},
	{0xfbdf, 0x8c6a},
	{0xfbe0, 0x93ac},
	{0xfbe1, 0x9800},
	{0xfbe2, 0x9865},
	{0xfbe3, 0x60d1},
	{0xfbe4, 0x6216},
	{0xfbe5, 0x9177},
	{0xfbe6, 0x5a5a},
	{0xfbe7, 0x660f},
	{0xfbe8, 0x6df7},
	{0xfbe9, 0x6e3e},
	{0xfbea, 0x743f},
	{0xfbeb, 0x9b42},
	{0xfbec, 0x5ffd},
	{0xfbed, 0x60da},
	{0xfbee, 0x7b0f},
	{0xfbef, 0x54c4},
	{0xfbf0, 0x5f18},
	{0xfbf1, 0x6c5e},
	{0xfbf2, 0x6cd3},
	{0xfbf3, 0x6d2a},
	{0xfbf4, 0x70d8},
	{0xfbf5, 0x7d05},
	{0xfbf6, 0x8679},
	{0xfbf7, 0x8a0c},
	{0xfbf8, 0x9d3b},
	{0xfbf9, 0x5316},
	{0xfbfa, 0x548c},
	{0xfbfb, 0x5b05},
	{0xfbfc, 0x6a3a},
	{0xfbfd, 0x706b},
	{0xfbfe, 0x7575},
	{0xfca1, 0x798d},
	{0xfca2, 0x79be},
	{0xfca3, 0x82b1},
	{0xfca4, 0x83ef},
	{0xfca5, 0x8a71},
	{0xfca6, 0x8b41},
	{0xfca7, 0x8ca8},
	{0xfca8, 0x9774},
	{0xfca9, 0xfa0b},
	{0xfcaa, 0x64f4},
	{0xfcab, 0x652b},
	{0xfcac, 0x78ba},
	{0xfcad, 0x78bb},
	{0xfcae, 0x7a6b},
	{0xfcaf, 0x4e38},
	{0xfcb0, 0x559a},
	{0xfcb1, 0x5950},
	{0xfcb2, 0x5ba6},
	{0xfcb3, 0x5e7b},
	{0xfcb4, 0x60a3},
	{0xfcb5, 0x63db},
	{0xfcb6, 0x6b61},
	{0xfcb7, 0x6665},
	{0xfcb8, 0x6853},
	{0xfcb9, 0x6e19},
	{0xfcba, 0x7165},
	{0xfcbb, 0x74b0},
	{0xfcbc, 0x7d08},
	{0xfcbd, 0x9084},
	{0xfcbe, 0x9a69},
	{0xfcbf, 0x9c25},
	{0xfcc0, 0x6d3b},
	{0xfcc1, 0x6ed1},
	{0xfcc2, 0x733e},
	{0xfcc3, 0x8c41},
	{0xfcc4, 0x95ca},
	{0xfcc5, 0x51f0},
	{0xfcc6, 0x5e4c},
	{0xfcc7, 0x5fa8},
	{0xfcc8, 0x604d},
	{0xfcc9, 0x60f6},
	{0xfcca, 0x6130},
	{0xfccb, 0x614c},
	{0xfccc, 0x6643},
	{0xfccd, 0x6644},
	{0xfcce, 0x69a5},
	{0xfccf, 0x6cc1},
	{0xfcd0, 0x6e5f},
	{0xfcd1, 0x6ec9},
	{0xfcd2, 0x6f62},
	{0xfcd3, 0x714c},
	{0xfcd4, 0x749c},
	{0xfcd5, 0x7687},
	{0xfcd6, 0x7bc1},
	{0xfcd7, 0x7c27},
	{0xfcd8, 0x8352},
	{0xfcd9, 0x8757},
	{0xfcda, 0x9051},
	{0xfcdb, 0x968d},
	{0xfcdc, 0x9ec3},
	{0xfcdd, 0x532f},
	{0xfcde, 0x56de},
	{0xfcdf, 0x5efb},
	{0xfce0, 0x5f8a},
	{0xfce1, 0x6062},
	{0xfce2, 0x6094},
	{0xfce3, 0x61f7},
	{0xfce4, 0x6666},
	{0xfce5, 0x6703},
	{0xfce6, 0x6a9c},
	{0xfce7, 0x6dee},
	{0xfce8, 0x6fae},
	{0xfce9, 0x7070},
	{0xfcea, 0x736a},
	{0xfceb, 0x7e6a},
	{0xfcec, 0x81be},
	{0xfced, 0x8334},
	{0xfcee, 0x86d4},
	{0xfcef, 0x8aa8},
	{0xfcf0, 0x8cc4},
	{0xfcf1, 0x5283},
	{0xfcf2, 0x7372},
	{0xfcf3, 0x5b96},
	{0xfcf4, 0x6a6b},
	{0xfcf5, 0x9404},
	{0xfcf6, 0x54ee},
	{0xfcf7, 0x5686},
	{0xfcf8, 0x5b5d},
	{0xfcf9, 0x6548},
	{0xfcfa, 0x6585},
	{0xfcfb, 0x66c9},
	{0xfcfc, 0x689f},
	{0xfcfd, 0x6d8d},
	{0xfcfe, 0x6dc6},
	{0xfda1, 0x723b},
	{0xfda2, 0x80b4},
	{0xfda3, 0x9175},
	{0xfda4, 0x9a4d},
	{0xfda5, 0x4faf},
	{0xfda6, 0x5019},
	{0xfda7, 0x539a},
	{0xfda8, 0x540e},
	{0xfda9, 0x543c},
	{0xfdaa, 0x5589},
	{0xfdab, 0x55c5},
	{0xfdac, 0x5e3f},
	{0xfdad, 0x5f8c},
	{0xfdae, 0x673d},
	{0xfdaf, 0x7166},
	{0xfdb0, 0x73dd},
	{0xfdb1, 0x9005},
	{0xfdb2, 0x52db},
	{0xfdb3, 0x52f3},
	{0xfdb4, 0x5864},
	{0xfdb5, 0x58ce},
	{0xfdb6, 0x7104},
	{0xfdb7, 0x718f},
	{0xfdb8, 0x71fb},
	{0xfdb9, 0x85b0},
	{0xfdba, 0x8a13},
	{0xfdbb, 0x6688},
	{0xfdbc, 0x85a8},
	{0xfdbd, 0x55a7},
	{0xfdbe, 0x6684},
	{0xfdbf, 0x714a},
	{0xfdc0, 0x8431},
	{0xfdc1, 0x5349},
	{0xfdc2, 0x5599},
	{0xfdc3, 0x6bc1},
	{0xfdc4, 0x5f59},
	{0xfdc5, 0x5fbd},
	{0xfdc6, 0x63ee},
	{0xfdc7, 0x6689},
	{0xfdc8, 0x7147},
	{0xfdc9, 0x8af1},
	{0xfdca, 0x8f1d},
	{0xfdcb, 0x9ebe},
	{0xfdcc, 0x4f11},
	{0xfdcd, 0x643a},
	{0xfdce, 0x70cb},
	{0xfdcf, 0x7566},
	{0xfdd0, 0x8667},
	{0xfdd1, 0x6064},
	{0xfdd2, 0x8b4e},
	{0xfdd3, 0x9df8},
	{0xfdd4, 0x5147},
	{0xfdd5, 0x51f6},
	{0xfdd6, 0x5308},
	{0xfdd7, 0x6d36},
	{0xfdd8, 0x80f8},
	{0xfdd9, 0x9ed1},
	{0xfdda, 0x6615},
	{0xfddb, 0x6b23},
	{0xfddc, 0x7098},
	{0xfddd, 0x75d5},
	{0xfdde, 0x5403},
	{0xfddf, 0x5c79},
	{0xfde0, 0x7d07},
	{0xfde1, 0x8a16},
	{0xfde2, 0x6b20},
	{0xfde3, 0x6b3d},
	{0xfde4, 0x6b46},
	{0xfde5, 0x5438},
	{0xfde6, 0x6070},
	{0xfde7, 0x6d3d},
	{0xfde8, 0x7fd5},
	{0xfde9, 0x8208},
	{0xfdea, 0x50d6},
	{0xfdeb, 0x51de},
	{0xfdec, 0x559c},
	{0xfded, 0x566b},
	{0xfdee, 0x56cd},
	{0xfdef, 0x59ec},
	{0xfdf0, 0x5b09},
	{0xfdf1, 0x5e0c},
	{0xfdf2, 0x6199},
	{0xfdf3, 0x6198},
	{0xfdf4, 0x6231},
	{0xfdf5, 0x665e},
	{0xfdf6, 0x66e6},
	{0xfdf7, 0x7199},
	{0xfdf8, 0x71b9},
	{0xfdf9, 0x71ba},
	{0xfdfa, 0x72a7},
	{0xfdfb, 0x79a7},
	{0xfdfc, 0x7a00},
	{0xfdfd, 0x7fb2},
	{0xfdfe, 0x8a70}
};
//	There were 17175 values

#ifdef CASIO_SH3
static CONST CODE_CONV ppwGbk2Utf[] = {
#else
static CODE_CONV ppwGbk2Utf[] = {
#endif //CASIO_SH3
	{0x0001, 0x0001},
	{0x0002, 0x0002},
	{0x0003, 0x0003},
	{0x0004, 0x0004},
	{0x0005, 0x0005},
	{0x0006, 0x0006},
	{0x0007, 0x0007},
	{0x0008, 0x0008},
	{0x0009, 0x0009},
	{0x000a, 0x000a},
	{0x000b, 0x000b},
	{0x000c, 0x000c},
	{0x000d, 0x000d},
	{0x000e, 0x000e},
	{0x000f, 0x000f},
	{0x0010, 0x0010},
	{0x0011, 0x0011},
	{0x0012, 0x0012},
	{0x0013, 0x0013},
	{0x0014, 0x0014},
	{0x0015, 0x0015},
	{0x0016, 0x0016},
	{0x0017, 0x0017},
	{0x0018, 0x0018},
	{0x0019, 0x0019},
	{0x001a, 0x001a},
	{0x001b, 0x001b},
	{0x001c, 0x001c},
	{0x001d, 0x001d},
	{0x001e, 0x001e},
	{0x001f, 0x001f},
	{0x0020, 0x0020},
	{0x0021, 0x0021},
	{0x0022, 0x0022},
	{0x0023, 0x0023},
	{0x0024, 0x0024},
	{0x0025, 0x0025},
	{0x0026, 0x0026},
	{0x0027, 0x0027},
	{0x0028, 0x0028},
	{0x0029, 0x0029},
	{0x002a, 0x002a},
	{0x002b, 0x002b},
	{0x002c, 0x002c},
	{0x002d, 0x002d},
	{0x002e, 0x002e},
	{0x002f, 0x002f},
	{0x0030, 0x0030},
	{0x0031, 0x0031},
	{0x0032, 0x0032},
	{0x0033, 0x0033},
	{0x0034, 0x0034},
	{0x0035, 0x0035},
	{0x0036, 0x0036},
	{0x0037, 0x0037},
	{0x0038, 0x0038},
	{0x0039, 0x0039},
	{0x003a, 0x003a},
	{0x003b, 0x003b},
	{0x003c, 0x003c},
	{0x003d, 0x003d},
	{0x003e, 0x003e},
	{0x003f, 0x003f},
	{0x0040, 0x0040},
	{0x0041, 0x0041},
	{0x0042, 0x0042},
	{0x0043, 0x0043},
	{0x0044, 0x0044},
	{0x0045, 0x0045},
	{0x0046, 0x0046},
	{0x0047, 0x0047},
	{0x0048, 0x0048},
	{0x0049, 0x0049},
	{0x004a, 0x004a},
	{0x004b, 0x004b},
	{0x004c, 0x004c},
	{0x004d, 0x004d},
	{0x004e, 0x004e},
	{0x004f, 0x004f},
	{0x0050, 0x0050},
	{0x0051, 0x0051},
	{0x0052, 0x0052},
	{0x0053, 0x0053},
	{0x0054, 0x0054},
	{0x0055, 0x0055},
	{0x0056, 0x0056},
	{0x0057, 0x0057},
	{0x0058, 0x0058},
	{0x0059, 0x0059},
	{0x005a, 0x005a},
	{0x005b, 0x005b},
	{0x005c, 0x005c},
	{0x005d, 0x005d},
	{0x005e, 0x005e},
	{0x005f, 0x005f},
	{0x0060, 0x0060},
	{0x0061, 0x0061},
	{0x0062, 0x0062},
	{0x0063, 0x0063},
	{0x0064, 0x0064},
	{0x0065, 0x0065},
	{0x0066, 0x0066},
	{0x0067, 0x0067},
	{0x0068, 0x0068},
	{0x0069, 0x0069},
	{0x006a, 0x006a},
	{0x006b, 0x006b},
	{0x006c, 0x006c},
	{0x006d, 0x006d},
	{0x006e, 0x006e},
	{0x006f, 0x006f},
	{0x0070, 0x0070},
	{0x0071, 0x0071},
	{0x0072, 0x0072},
	{0x0073, 0x0073},
	{0x0074, 0x0074},
	{0x0075, 0x0075},
	{0x0076, 0x0076},
	{0x0077, 0x0077},
	{0x0078, 0x0078},
	{0x0079, 0x0079},
	{0x007a, 0x007a},
	{0x007b, 0x007b},
	{0x007c, 0x007c},
	{0x007d, 0x007d},
	{0x007e, 0x007e},
	{0x007f, 0x007f},
	{0x0080, 0x20ac},
	{0x8140, 0x4e02},
	{0x8141, 0x4e04},
	{0x8142, 0x4e05},
	{0x8143, 0x4e06},
	{0x8144, 0x4e0f},
	{0x8145, 0x4e12},
	{0x8146, 0x4e17},
	{0x8147, 0x4e1f},
	{0x8148, 0x4e20},
	{0x8149, 0x4e21},
	{0x814a, 0x4e23},
	{0x814b, 0x4e26},
	{0x814c, 0x4e29},
	{0x814d, 0x4e2e},
	{0x814e, 0x4e2f},
	{0x814f, 0x4e31},
	{0x8150, 0x4e33},
	{0x8151, 0x4e35},
	{0x8152, 0x4e37},
	{0x8153, 0x4e3c},
	{0x8154, 0x4e40},
	{0x8155, 0x4e41},
	{0x8156, 0x4e42},
	{0x8157, 0x4e44},
	{0x8158, 0x4e46},
	{0x8159, 0x4e4a},
	{0x815a, 0x4e51},
	{0x815b, 0x4e55},
	{0x815c, 0x4e57},
	{0x815d, 0x4e5a},
	{0x815e, 0x4e5b},
	{0x815f, 0x4e62},
	{0x8160, 0x4e63},
	{0x8161, 0x4e64},
	{0x8162, 0x4e65},
	{0x8163, 0x4e67},
	{0x8164, 0x4e68},
	{0x8165, 0x4e6a},
	{0x8166, 0x4e6b},
	{0x8167, 0x4e6c},
	{0x8168, 0x4e6d},
	{0x8169, 0x4e6e},
	{0x816a, 0x4e6f},
	{0x816b, 0x4e72},
	{0x816c, 0x4e74},
	{0x816d, 0x4e75},
	{0x816e, 0x4e76},
	{0x816f, 0x4e77},
	{0x8170, 0x4e78},
	{0x8171, 0x4e79},
	{0x8172, 0x4e7a},
	{0x8173, 0x4e7b},
	{0x8174, 0x4e7c},
	{0x8175, 0x4e7d},
	{0x8176, 0x4e7f},
	{0x8177, 0x4e80},
	{0x8178, 0x4e81},
	{0x8179, 0x4e82},
	{0x817a, 0x4e83},
	{0x817b, 0x4e84},
	{0x817c, 0x4e85},
	{0x817d, 0x4e87},
	{0x817e, 0x4e8a},
	{0x8180, 0x4e90},
	{0x8181, 0x4e96},
	{0x8182, 0x4e97},
	{0x8183, 0x4e99},
	{0x8184, 0x4e9c},
	{0x8185, 0x4e9d},
	{0x8186, 0x4e9e},
	{0x8187, 0x4ea3},
	{0x8188, 0x4eaa},
	{0x8189, 0x4eaf},
	{0x818a, 0x4eb0},
	{0x818b, 0x4eb1},
	{0x818c, 0x4eb4},
	{0x818d, 0x4eb6},
	{0x818e, 0x4eb7},
	{0x818f, 0x4eb8},
	{0x8190, 0x4eb9},
	{0x8191, 0x4ebc},
	{0x8192, 0x4ebd},
	{0x8193, 0x4ebe},
	{0x8194, 0x4ec8},
	{0x8195, 0x4ecc},
	{0x8196, 0x4ecf},
	{0x8197, 0x4ed0},
	{0x8198, 0x4ed2},
	{0x8199, 0x4eda},
	{0x819a, 0x4edb},
	{0x819b, 0x4edc},
	{0x819c, 0x4ee0},
	{0x819d, 0x4ee2},
	{0x819e, 0x4ee6},
	{0x819f, 0x4ee7},
	{0x81a0, 0x4ee9},
	{0x81a1, 0x4eed},
	{0x81a2, 0x4eee},
	{0x81a3, 0x4eef},
	{0x81a4, 0x4ef1},
	{0x81a5, 0x4ef4},
	{0x81a6, 0x4ef8},
	{0x81a7, 0x4ef9},
	{0x81a8, 0x4efa},
	{0x81a9, 0x4efc},
	{0x81aa, 0x4efe},
	{0x81ab, 0x4f00},
	{0x81ac, 0x4f02},
	{0x81ad, 0x4f03},
	{0x81ae, 0x4f04},
	{0x81af, 0x4f05},
	{0x81b0, 0x4f06},
	{0x81b1, 0x4f07},
	{0x81b2, 0x4f08},
	{0x81b3, 0x4f0b},
	{0x81b4, 0x4f0c},
	{0x81b5, 0x4f12},
	{0x81b6, 0x4f13},
	{0x81b7, 0x4f14},
	{0x81b8, 0x4f15},
	{0x81b9, 0x4f16},
	{0x81ba, 0x4f1c},
	{0x81bb, 0x4f1d},
	{0x81bc, 0x4f21},
	{0x81bd, 0x4f23},
	{0x81be, 0x4f28},
	{0x81bf, 0x4f29},
	{0x81c0, 0x4f2c},
	{0x81c1, 0x4f2d},
	{0x81c2, 0x4f2e},
	{0x81c3, 0x4f31},
	{0x81c4, 0x4f33},
	{0x81c5, 0x4f35},
	{0x81c6, 0x4f37},
	{0x81c7, 0x4f39},
	{0x81c8, 0x4f3b},
	{0x81c9, 0x4f3e},
	{0x81ca, 0x4f3f},
	{0x81cb, 0x4f40},
	{0x81cc, 0x4f41},
	{0x81cd, 0x4f42},
	{0x81ce, 0x4f44},
	{0x81cf, 0x4f45},
	{0x81d0, 0x4f47},
	{0x81d1, 0x4f48},
	{0x81d2, 0x4f49},
	{0x81d3, 0x4f4a},
	{0x81d4, 0x4f4b},
	{0x81d5, 0x4f4c},
	{0x81d6, 0x4f52},
	{0x81d7, 0x4f54},
	{0x81d8, 0x4f56},
	{0x81d9, 0x4f61},
	{0x81da, 0x4f62},
	{0x81db, 0x4f66},
	{0x81dc, 0x4f68},
	{0x81dd, 0x4f6a},
	{0x81de, 0x4f6b},
	{0x81df, 0x4f6d},
	{0x81e0, 0x4f6e},
	{0x81e1, 0x4f71},
	{0x81e2, 0x4f72},
	{0x81e3, 0x4f75},
	{0x81e4, 0x4f77},
	{0x81e5, 0x4f78},
	{0x81e6, 0x4f79},
	{0x81e7, 0x4f7a},
	{0x81e8, 0x4f7d},
	{0x81e9, 0x4f80},
	{0x81ea, 0x4f81},
	{0x81eb, 0x4f82},
	{0x81ec, 0x4f85},
	{0x81ed, 0x4f86},
	{0x81ee, 0x4f87},
	{0x81ef, 0x4f8a},
	{0x81f0, 0x4f8c},
	{0x81f1, 0x4f8e},
	{0x81f2, 0x4f90},
	{0x81f3, 0x4f92},
	{0x81f4, 0x4f93},
	{0x81f5, 0x4f95},
	{0x81f6, 0x4f96},
	{0x81f7, 0x4f98},
	{0x81f8, 0x4f99},
	{0x81f9, 0x4f9a},
	{0x81fa, 0x4f9c},
	{0x81fb, 0x4f9e},
	{0x81fc, 0x4f9f},
	{0x81fd, 0x4fa1},
	{0x81fe, 0x4fa2},
	{0x8240, 0x4fa4},
	{0x8241, 0x4fab},
	{0x8242, 0x4fad},
	{0x8243, 0x4fb0},
	{0x8244, 0x4fb1},
	{0x8245, 0x4fb2},
	{0x8246, 0x4fb3},
	{0x8247, 0x4fb4},
	{0x8248, 0x4fb6},
	{0x8249, 0x4fb7},
	{0x824a, 0x4fb8},
	{0x824b, 0x4fb9},
	{0x824c, 0x4fba},
	{0x824d, 0x4fbb},
	{0x824e, 0x4fbc},
	{0x824f, 0x4fbd},
	{0x8250, 0x4fbe},
	{0x8251, 0x4fc0},
	{0x8252, 0x4fc1},
	{0x8253, 0x4fc2},
	{0x8254, 0x4fc6},
	{0x8255, 0x4fc7},
	{0x8256, 0x4fc8},
	{0x8257, 0x4fc9},
	{0x8258, 0x4fcb},
	{0x8259, 0x4fcc},
	{0x825a, 0x4fcd},
	{0x825b, 0x4fd2},
	{0x825c, 0x4fd3},
	{0x825d, 0x4fd4},
	{0x825e, 0x4fd5},
	{0x825f, 0x4fd6},
	{0x8260, 0x4fd9},
	{0x8261, 0x4fdb},
	{0x8262, 0x4fe0},
	{0x8263, 0x4fe2},
	{0x8264, 0x4fe4},
	{0x8265, 0x4fe5},
	{0x8266, 0x4fe7},
	{0x8267, 0x4feb},
	{0x8268, 0x4fec},
	{0x8269, 0x4ff0},
	{0x826a, 0x4ff2},
	{0x826b, 0x4ff4},
	{0x826c, 0x4ff5},
	{0x826d, 0x4ff6},
	{0x826e, 0x4ff7},
	{0x826f, 0x4ff9},
	{0x8270, 0x4ffb},
	{0x8271, 0x4ffc},
	{0x8272, 0x4ffd},
	{0x8273, 0x4fff},
	{0x8274, 0x5000},
	{0x8275, 0x5001},
	{0x8276, 0x5002},
	{0x8277, 0x5003},
	{0x8278, 0x5004},
	{0x8279, 0x5005},
	{0x827a, 0x5006},
	{0x827b, 0x5007},
	{0x827c, 0x5008},
	{0x827d, 0x5009},
	{0x827e, 0x500a},
	{0x8280, 0x500b},
	{0x8281, 0x500e},
	{0x8282, 0x5010},
	{0x8283, 0x5011},
	{0x8284, 0x5013},
	{0x8285, 0x5015},
	{0x8286, 0x5016},
	{0x8287, 0x5017},
	{0x8288, 0x501b},
	{0x8289, 0x501d},
	{0x828a, 0x501e},
	{0x828b, 0x5020},
	{0x828c, 0x5022},
	{0x828d, 0x5023},
	{0x828e, 0x5024},
	{0x828f, 0x5027},
	{0x8290, 0x502b},
	{0x8291, 0x502f},
	{0x8292, 0x5030},
	{0x8293, 0x5031},
	{0x8294, 0x5032},
	{0x8295, 0x5033},
	{0x8296, 0x5034},
	{0x8297, 0x5035},
	{0x8298, 0x5036},
	{0x8299, 0x5037},
	{0x829a, 0x5038},
	{0x829b, 0x5039},
	{0x829c, 0x503b},
	{0x829d, 0x503d},
	{0x829e, 0x503f},
	{0x829f, 0x5040},
	{0x82a0, 0x5041},
	{0x82a1, 0x5042},
	{0x82a2, 0x5044},
	{0x82a3, 0x5045},
	{0x82a4, 0x5046},
	{0x82a5, 0x5049},
	{0x82a6, 0x504a},
	{0x82a7, 0x504b},
	{0x82a8, 0x504d},
	{0x82a9, 0x5050},
	{0x82aa, 0x5051},
	{0x82ab, 0x5052},
	{0x82ac, 0x5053},
	{0x82ad, 0x5054},
	{0x82ae, 0x5056},
	{0x82af, 0x5057},
	{0x82b0, 0x5058},
	{0x82b1, 0x5059},
	{0x82b2, 0x505b},
	{0x82b3, 0x505d},
	{0x82b4, 0x505e},
	{0x82b5, 0x505f},
	{0x82b6, 0x5060},
	{0x82b7, 0x5061},
	{0x82b8, 0x5062},
	{0x82b9, 0x5063},
	{0x82ba, 0x5064},
	{0x82bb, 0x5066},
	{0x82bc, 0x5067},
	{0x82bd, 0x5068},
	{0x82be, 0x5069},
	{0x82bf, 0x506a},
	{0x82c0, 0x506b},
	{0x82c1, 0x506d},
	{0x82c2, 0x506e},
	{0x82c3, 0x506f},
	{0x82c4, 0x5070},
	{0x82c5, 0x5071},
	{0x82c6, 0x5072},
	{0x82c7, 0x5073},
	{0x82c8, 0x5074},
	{0x82c9, 0x5075},
	{0x82ca, 0x5078},
	{0x82cb, 0x5079},
	{0x82cc, 0x507a},
	{0x82cd, 0x507c},
	{0x82ce, 0x507d},
	{0x82cf, 0x5081},
	{0x82d0, 0x5082},
	{0x82d1, 0x5083},
	{0x82d2, 0x5084},
	{0x82d3, 0x5086},
	{0x82d4, 0x5087},
	{0x82d5, 0x5089},
	{0x82d6, 0x508a},
	{0x82d7, 0x508b},
	{0x82d8, 0x508c},
	{0x82d9, 0x508e},
	{0x82da, 0x508f},
	{0x82db, 0x5090},
	{0x82dc, 0x5091},
	{0x82dd, 0x5092},
	{0x82de, 0x5093},
	{0x82df, 0x5094},
	{0x82e0, 0x5095},
	{0x82e1, 0x5096},
	{0x82e2, 0x5097},
	{0x82e3, 0x5098},
	{0x82e4, 0x5099},
	{0x82e5, 0x509a},
	{0x82e6, 0x509b},
	{0x82e7, 0x509c},
	{0x82e8, 0x509d},
	{0x82e9, 0x509e},
	{0x82ea, 0x509f},
	{0x82eb, 0x50a0},
	{0x82ec, 0x50a1},
	{0x82ed, 0x50a2},
	{0x82ee, 0x50a4},
	{0x82ef, 0x50a6},
	{0x82f0, 0x50aa},
	{0x82f1, 0x50ab},
	{0x82f2, 0x50ad},
	{0x82f3, 0x50ae},
	{0x82f4, 0x50af},
	{0x82f5, 0x50b0},
	{0x82f6, 0x50b1},
	{0x82f7, 0x50b3},
	{0x82f8, 0x50b4},
	{0x82f9, 0x50b5},
	{0x82fa, 0x50b6},
	{0x82fb, 0x50b7},
	{0x82fc, 0x50b8},
	{0x82fd, 0x50b9},
	{0x82fe, 0x50bc},
	{0x8340, 0x50bd},
	{0x8341, 0x50be},
	{0x8342, 0x50bf},
	{0x8343, 0x50c0},
	{0x8344, 0x50c1},
	{0x8345, 0x50c2},
	{0x8346, 0x50c3},
	{0x8347, 0x50c4},
	{0x8348, 0x50c5},
	{0x8349, 0x50c6},
	{0x834a, 0x50c7},
	{0x834b, 0x50c8},
	{0x834c, 0x50c9},
	{0x834d, 0x50ca},
	{0x834e, 0x50cb},
	{0x834f, 0x50cc},
	{0x8350, 0x50cd},
	{0x8351, 0x50ce},
	{0x8352, 0x50d0},
	{0x8353, 0x50d1},
	{0x8354, 0x50d2},
	{0x8355, 0x50d3},
	{0x8356, 0x50d4},
	{0x8357, 0x50d5},
	{0x8358, 0x50d7},
	{0x8359, 0x50d8},
	{0x835a, 0x50d9},
	{0x835b, 0x50db},
	{0x835c, 0x50dc},
	{0x835d, 0x50dd},
	{0x835e, 0x50de},
	{0x835f, 0x50df},
	{0x8360, 0x50e0},
	{0x8361, 0x50e1},
	{0x8362, 0x50e2},
	{0x8363, 0x50e3},
	{0x8364, 0x50e4},
	{0x8365, 0x50e5},
	{0x8366, 0x50e8},
	{0x8367, 0x50e9},
	{0x8368, 0x50ea},
	{0x8369, 0x50eb},
	{0x836a, 0x50ef},
	{0x836b, 0x50f0},
	{0x836c, 0x50f1},
	{0x836d, 0x50f2},
	{0x836e, 0x50f4},
	{0x836f, 0x50f6},
	{0x8370, 0x50f7},
	{0x8371, 0x50f8},
	{0x8372, 0x50f9},
	{0x8373, 0x50fa},
	{0x8374, 0x50fc},
	{0x8375, 0x50fd},
	{0x8376, 0x50fe},
	{0x8377, 0x50ff},
	{0x8378, 0x5100},
	{0x8379, 0x5101},
	{0x837a, 0x5102},
	{0x837b, 0x5103},
	{0x837c, 0x5104},
	{0x837d, 0x5105},
	{0x837e, 0x5108},
	{0x8380, 0x5109},
	{0x8381, 0x510a},
	{0x8382, 0x510c},
	{0x8383, 0x510d},
	{0x8384, 0x510e},
	{0x8385, 0x510f},
	{0x8386, 0x5110},
	{0x8387, 0x5111},
	{0x8388, 0x5113},
	{0x8389, 0x5114},
	{0x838a, 0x5115},
	{0x838b, 0x5116},
	{0x838c, 0x5117},
	{0x838d, 0x5118},
	{0x838e, 0x5119},
	{0x838f, 0x511a},
	{0x8390, 0x511b},
	{0x8391, 0x511c},
	{0x8392, 0x511d},
	{0x8393, 0x511e},
	{0x8394, 0x511f},
	{0x8395, 0x5120},
	{0x8396, 0x5122},
	{0x8397, 0x5123},
	{0x8398, 0x5124},
	{0x8399, 0x5125},
	{0x839a, 0x5126},
	{0x839b, 0x5127},
	{0x839c, 0x5128},
	{0x839d, 0x5129},
	{0x839e, 0x512a},
	{0x839f, 0x512b},
	{0x83a0, 0x512c},
	{0x83a1, 0x512d},
	{0x83a2, 0x512e},
	{0x83a3, 0x512f},
	{0x83a4, 0x5130},
	{0x83a5, 0x5131},
	{0x83a6, 0x5132},
	{0x83a7, 0x5133},
	{0x83a8, 0x5134},
	{0x83a9, 0x5135},
	{0x83aa, 0x5136},
	{0x83ab, 0x5137},
	{0x83ac, 0x5138},
	{0x83ad, 0x5139},
	{0x83ae, 0x513a},
	{0x83af, 0x513b},
	{0x83b0, 0x513c},
	{0x83b1, 0x513d},
	{0x83b2, 0x513e},
	{0x83b3, 0x5142},
	{0x83b4, 0x5147},
	{0x83b5, 0x514a},
	{0x83b6, 0x514c},
	{0x83b7, 0x514e},
	{0x83b8, 0x514f},
	{0x83b9, 0x5150},
	{0x83ba, 0x5152},
	{0x83bb, 0x5153},
	{0x83bc, 0x5157},
	{0x83bd, 0x5158},
	{0x83be, 0x5159},
	{0x83bf, 0x515b},
	{0x83c0, 0x515d},
	{0x83c1, 0x515e},
	{0x83c2, 0x515f},
	{0x83c3, 0x5160},
	{0x83c4, 0x5161},
	{0x83c5, 0x5163},
	{0x83c6, 0x5164},
	{0x83c7, 0x5166},
	{0x83c8, 0x5167},
	{0x83c9, 0x5169},
	{0x83ca, 0x516a},
	{0x83cb, 0x516f},
	{0x83cc, 0x5172},
	{0x83cd, 0x517a},
	{0x83ce, 0x517e},
	{0x83cf, 0x517f},
	{0x83d0, 0x5183},
	{0x83d1, 0x5184},
	{0x83d2, 0x5186},
	{0x83d3, 0x5187},
	{0x83d4, 0x518a},
	{0x83d5, 0x518b},
	{0x83d6, 0x518e},
	{0x83d7, 0x518f},
	{0x83d8, 0x5190},
	{0x83d9, 0x5191},
	{0x83da, 0x5193},
	{0x83db, 0x5194},
	{0x83dc, 0x5198},
	{0x83dd, 0x519a},
	{0x83de, 0x519d},
	{0x83df, 0x519e},
	{0x83e0, 0x519f},
	{0x83e1, 0x51a1},
	{0x83e2, 0x51a3},
	{0x83e3, 0x51a6},
	{0x83e4, 0x51a7},
	{0x83e5, 0x51a8},
	{0x83e6, 0x51a9},
	{0x83e7, 0x51aa},
	{0x83e8, 0x51ad},
	{0x83e9, 0x51ae},
	{0x83ea, 0x51b4},
	{0x83eb, 0x51b8},
	{0x83ec, 0x51b9},
	{0x83ed, 0x51ba},
	{0x83ee, 0x51be},
	{0x83ef, 0x51bf},
	{0x83f0, 0x51c1},
	{0x83f1, 0x51c2},
	{0x83f2, 0x51c3},
	{0x83f3, 0x51c5},
	{0x83f4, 0x51c8},
	{0x83f5, 0x51ca},
	{0x83f6, 0x51cd},
	{0x83f7, 0x51ce},
	{0x83f8, 0x51d0},
	{0x83f9, 0x51d2},
	{0x83fa, 0x51d3},
	{0x83fb, 0x51d4},
	{0x83fc, 0x51d5},
	{0x83fd, 0x51d6},
	{0x83fe, 0x51d7},
	{0x8440, 0x51d8},
	{0x8441, 0x51d9},
	{0x8442, 0x51da},
	{0x8443, 0x51dc},
	{0x8444, 0x51de},
	{0x8445, 0x51df},
	{0x8446, 0x51e2},
	{0x8447, 0x51e3},
	{0x8448, 0x51e5},
	{0x8449, 0x51e6},
	{0x844a, 0x51e7},
	{0x844b, 0x51e8},
	{0x844c, 0x51e9},
	{0x844d, 0x51ea},
	{0x844e, 0x51ec},
	{0x844f, 0x51ee},
	{0x8450, 0x51f1},
	{0x8451, 0x51f2},
	{0x8452, 0x51f4},
	{0x8453, 0x51f7},
	{0x8454, 0x51fe},
	{0x8455, 0x5204},
	{0x8456, 0x5205},
	{0x8457, 0x5209},
	{0x8458, 0x520b},
	{0x8459, 0x520c},
	{0x845a, 0x520f},
	{0x845b, 0x5210},
	{0x845c, 0x5213},
	{0x845d, 0x5214},
	{0x845e, 0x5215},
	{0x845f, 0x521c},
	{0x8460, 0x521e},
	{0x8461, 0x521f},
	{0x8462, 0x5221},
	{0x8463, 0x5222},
	{0x8464, 0x5223},
	{0x8465, 0x5225},
	{0x8466, 0x5226},
	{0x8467, 0x5227},
	{0x8468, 0x522a},
	{0x8469, 0x522c},
	{0x846a, 0x522f},
	{0x846b, 0x5231},
	{0x846c, 0x5232},
	{0x846d, 0x5234},
	{0x846e, 0x5235},
	{0x846f, 0x523c},
	{0x8470, 0x523e},
	{0x8471, 0x5244},
	{0x8472, 0x5245},
	{0x8473, 0x5246},
	{0x8474, 0x5247},
	{0x8475, 0x5248},
	{0x8476, 0x5249},
	{0x8477, 0x524b},
	{0x8478, 0x524e},
	{0x8479, 0x524f},
	{0x847a, 0x5252},
	{0x847b, 0x5253},
	{0x847c, 0x5255},
	{0x847d, 0x5257},
	{0x847e, 0x5258},
	{0x8480, 0x5259},
	{0x8481, 0x525a},
	{0x8482, 0x525b},
	{0x8483, 0x525d},
	{0x8484, 0x525f},
	{0x8485, 0x5260},
	{0x8486, 0x5262},
	{0x8487, 0x5263},
	{0x8488, 0x5264},
	{0x8489, 0x5266},
	{0x848a, 0x5268},
	{0x848b, 0x526b},
	{0x848c, 0x526c},
	{0x848d, 0x526d},
	{0x848e, 0x526e},
	{0x848f, 0x5270},
	{0x8490, 0x5271},
	{0x8491, 0x5273},
	{0x8492, 0x5274},
	{0x8493, 0x5275},
	{0x8494, 0x5276},
	{0x8495, 0x5277},
	{0x8496, 0x5278},
	{0x8497, 0x5279},
	{0x8498, 0x527a},
	{0x8499, 0x527b},
	{0x849a, 0x527c},
	{0x849b, 0x527e},
	{0x849c, 0x5280},
	{0x849d, 0x5283},
	{0x849e, 0x5284},
	{0x849f, 0x5285},
	{0x84a0, 0x5286},
	{0x84a1, 0x5287},
	{0x84a2, 0x5289},
	{0x84a3, 0x528a},
	{0x84a4, 0x528b},
	{0x84a5, 0x528c},
	{0x84a6, 0x528d},
	{0x84a7, 0x528e},
	{0x84a8, 0x528f},
	{0x84a9, 0x5291},
	{0x84aa, 0x5292},
	{0x84ab, 0x5294},
	{0x84ac, 0x5295},
	{0x84ad, 0x5296},
	{0x84ae, 0x5297},
	{0x84af, 0x5298},
	{0x84b0, 0x5299},
	{0x84b1, 0x529a},
	{0x84b2, 0x529c},
	{0x84b3, 0x52a4},
	{0x84b4, 0x52a5},
	{0x84b5, 0x52a6},
	{0x84b6, 0x52a7},
	{0x84b7, 0x52ae},
	{0x84b8, 0x52af},
	{0x84b9, 0x52b0},
	{0x84ba, 0x52b4},
	{0x84bb, 0x52b5},
	{0x84bc, 0x52b6},
	{0x84bd, 0x52b7},
	{0x84be, 0x52b8},
	{0x84bf, 0x52b9},
	{0x84c0, 0x52ba},
	{0x84c1, 0x52bb},
	{0x84c2, 0x52bc},
	{0x84c3, 0x52bd},
	{0x84c4, 0x52c0},
	{0x84c5, 0x52c1},
	{0x84c6, 0x52c2},
	{0x84c7, 0x52c4},
	{0x84c8, 0x52c5},
	{0x84c9, 0x52c6},
	{0x84ca, 0x52c8},
	{0x84cb, 0x52ca},
	{0x84cc, 0x52cc},
	{0x84cd, 0x52cd},
	{0x84ce, 0x52ce},
	{0x84cf, 0x52cf},
	{0x84d0, 0x52d1},
	{0x84d1, 0x52d3},
	{0x84d2, 0x52d4},
	{0x84d3, 0x52d5},
	{0x84d4, 0x52d7},
	{0x84d5, 0x52d9},
	{0x84d6, 0x52da},
	{0x84d7, 0x52db},
	{0x84d8, 0x52dc},
	{0x84d9, 0x52dd},
	{0x84da, 0x52de},
	{0x84db, 0x52e0},
	{0x84dc, 0x52e1},
	{0x84dd, 0x52e2},
	{0x84de, 0x52e3},
	{0x84df, 0x52e5},
	{0x84e0, 0x52e6},
	{0x84e1, 0x52e7},
	{0x84e2, 0x52e8},
	{0x84e3, 0x52e9},
	{0x84e4, 0x52ea},
	{0x84e5, 0x52eb},
	{0x84e6, 0x52ec},
	{0x84e7, 0x52ed},
	{0x84e8, 0x52ee},
	{0x84e9, 0x52ef},
	{0x84ea, 0x52f1},
	{0x84eb, 0x52f2},
	{0x84ec, 0x52f3},
	{0x84ed, 0x52f4},
	{0x84ee, 0x52f5},
	{0x84ef, 0x52f6},
	{0x84f0, 0x52f7},
	{0x84f1, 0x52f8},
	{0x84f2, 0x52fb},
	{0x84f3, 0x52fc},
	{0x84f4, 0x52fd},
	{0x84f5, 0x5301},
	{0x84f6, 0x5302},
	{0x84f7, 0x5303},
	{0x84f8, 0x5304},
	{0x84f9, 0x5307},
	{0x84fa, 0x5309},
	{0x84fb, 0x530a},
	{0x84fc, 0x530b},
	{0x84fd, 0x530c},
	{0x84fe, 0x530e},
	{0x8540, 0x5311},
	{0x8541, 0x5312},
	{0x8542, 0x5313},
	{0x8543, 0x5314},
	{0x8544, 0x5318},
	{0x8545, 0x531b},
	{0x8546, 0x531c},
	{0x8547, 0x531e},
	{0x8548, 0x531f},
	{0x8549, 0x5322},
	{0x854a, 0x5324},
	{0x854b, 0x5325},
	{0x854c, 0x5327},
	{0x854d, 0x5328},
	{0x854e, 0x5329},
	{0x854f, 0x532b},
	{0x8550, 0x532c},
	{0x8551, 0x532d},
	{0x8552, 0x532f},
	{0x8553, 0x5330},
	{0x8554, 0x5331},
	{0x8555, 0x5332},
	{0x8556, 0x5333},
	{0x8557, 0x5334},
	{0x8558, 0x5335},
	{0x8559, 0x5336},
	{0x855a, 0x5337},
	{0x855b, 0x5338},
	{0x855c, 0x533c},
	{0x855d, 0x533d},
	{0x855e, 0x5340},
	{0x855f, 0x5342},
	{0x8560, 0x5344},
	{0x8561, 0x5346},
	{0x8562, 0x534b},
	{0x8563, 0x534c},
	{0x8564, 0x534d},
	{0x8565, 0x5350},
	{0x8566, 0x5354},
	{0x8567, 0x5358},
	{0x8568, 0x5359},
	{0x8569, 0x535b},
	{0x856a, 0x535d},
	{0x856b, 0x5365},
	{0x856c, 0x5368},
	{0x856d, 0x536a},
	{0x856e, 0x536c},
	{0x856f, 0x536d},
	{0x8570, 0x5372},
	{0x8571, 0x5376},
	{0x8572, 0x5379},
	{0x8573, 0x537b},
	{0x8574, 0x537c},
	{0x8575, 0x537d},
	{0x8576, 0x537e},
	{0x8577, 0x5380},
	{0x8578, 0x5381},
	{0x8579, 0x5383},
	{0x857a, 0x5387},
	{0x857b, 0x5388},
	{0x857c, 0x538a},
	{0x857d, 0x538e},
	{0x857e, 0x538f},
	{0x8580, 0x5390},
	{0x8581, 0x5391},
	{0x8582, 0x5392},
	{0x8583, 0x5393},
	{0x8584, 0x5394},
	{0x8585, 0x5396},
	{0x8586, 0x5397},
	{0x8587, 0x5399},
	{0x8588, 0x539b},
	{0x8589, 0x539c},
	{0x858a, 0x539e},
	{0x858b, 0x53a0},
	{0x858c, 0x53a1},
	{0x858d, 0x53a4},
	{0x858e, 0x53a7},
	{0x858f, 0x53aa},
	{0x8590, 0x53ab},
	{0x8591, 0x53ac},
	{0x8592, 0x53ad},
	{0x8593, 0x53af},
	{0x8594, 0x53b0},
	{0x8595, 0x53b1},
	{0x8596, 0x53b2},
	{0x8597, 0x53b3},
	{0x8598, 0x53b4},
	{0x8599, 0x53b5},
	{0x859a, 0x53b7},
	{0x859b, 0x53b8},
	{0x859c, 0x53b9},
	{0x859d, 0x53ba},
	{0x859e, 0x53bc},
	{0x859f, 0x53bd},
	{0x85a0, 0x53be},
	{0x85a1, 0x53c0},
	{0x85a2, 0x53c3},
	{0x85a3, 0x53c4},
	{0x85a4, 0x53c5},
	{0x85a5, 0x53c6},
	{0x85a6, 0x53c7},
	{0x85a7, 0x53ce},
	{0x85a8, 0x53cf},
	{0x85a9, 0x53d0},
	{0x85aa, 0x53d2},
	{0x85ab, 0x53d3},
	{0x85ac, 0x53d5},
	{0x85ad, 0x53da},
	{0x85ae, 0x53dc},
	{0x85af, 0x53dd},
	{0x85b0, 0x53de},
	{0x85b1, 0x53e1},
	{0x85b2, 0x53e2},
	{0x85b3, 0x53e7},
	{0x85b4, 0x53f4},
	{0x85b5, 0x53fa},
	{0x85b6, 0x53fe},
	{0x85b7, 0x53ff},
	{0x85b8, 0x5400},
	{0x85b9, 0x5402},
	{0x85ba, 0x5405},
	{0x85bb, 0x5407},
	{0x85bc, 0x540b},
	{0x85bd, 0x5414},
	{0x85be, 0x5418},
	{0x85bf, 0x5419},
	{0x85c0, 0x541a},
	{0x85c1, 0x541c},
	{0x85c2, 0x5422},
	{0x85c3, 0x5424},
	{0x85c4, 0x5425},
	{0x85c5, 0x542a},
	{0x85c6, 0x5430},
	{0x85c7, 0x5433},
	{0x85c8, 0x5436},
	{0x85c9, 0x5437},
	{0x85ca, 0x543a},
	{0x85cb, 0x543d},
	{0x85cc, 0x543f},
	{0x85cd, 0x5441},
	{0x85ce, 0x5442},
	{0x85cf, 0x5444},
	{0x85d0, 0x5445},
	{0x85d1, 0x5447},
	{0x85d2, 0x5449},
	{0x85d3, 0x544c},
	{0x85d4, 0x544d},
	{0x85d5, 0x544e},
	{0x85d6, 0x544f},
	{0x85d7, 0x5451},
	{0x85d8, 0x545a},
	{0x85d9, 0x545d},
	{0x85da, 0x545e},
	{0x85db, 0x545f},
	{0x85dc, 0x5460},
	{0x85dd, 0x5461},
	{0x85de, 0x5463},
	{0x85df, 0x5465},
	{0x85e0, 0x5467},
	{0x85e1, 0x5469},
	{0x85e2, 0x546a},
	{0x85e3, 0x546b},
	{0x85e4, 0x546c},
	{0x85e5, 0x546d},
	{0x85e6, 0x546e},
	{0x85e7, 0x546f},
	{0x85e8, 0x5470},
	{0x85e9, 0x5474},
	{0x85ea, 0x5479},
	{0x85eb, 0x547a},
	{0x85ec, 0x547e},
	{0x85ed, 0x547f},
	{0x85ee, 0x5481},
	{0x85ef, 0x5483},
	{0x85f0, 0x5485},
	{0x85f1, 0x5487},
	{0x85f2, 0x5488},
	{0x85f3, 0x5489},
	{0x85f4, 0x548a},
	{0x85f5, 0x548d},
	{0x85f6, 0x5491},
	{0x85f7, 0x5493},
	{0x85f8, 0x5497},
	{0x85f9, 0x5498},
	{0x85fa, 0x549c},
	{0x85fb, 0x549e},
	{0x85fc, 0x549f},
	{0x85fd, 0x54a0},
	{0x85fe, 0x54a1},
	{0x8640, 0x54a2},
	{0x8641, 0x54a5},
	{0x8642, 0x54ae},
	{0x8643, 0x54b0},
	{0x8644, 0x54b2},
	{0x8645, 0x54b5},
	{0x8646, 0x54b6},
	{0x8647, 0x54b7},
	{0x8648, 0x54b9},
	{0x8649, 0x54ba},
	{0x864a, 0x54bc},
	{0x864b, 0x54be},
	{0x864c, 0x54c3},
	{0x864d, 0x54c5},
	{0x864e, 0x54ca},
	{0x864f, 0x54cb},
	{0x8650, 0x54d6},
	{0x8651, 0x54d8},
	{0x8652, 0x54db},
	{0x8653, 0x54e0},
	{0x8654, 0x54e1},
	{0x8655, 0x54e2},
	{0x8656, 0x54e3},
	{0x8657, 0x54e4},
	{0x8658, 0x54eb},
	{0x8659, 0x54ec},
	{0x865a, 0x54ef},
	{0x865b, 0x54f0},
	{0x865c, 0x54f1},
	{0x865d, 0x54f4},
	{0x865e, 0x54f5},
	{0x865f, 0x54f6},
	{0x8660, 0x54f7},
	{0x8661, 0x54f8},
	{0x8662, 0x54f9},
	{0x8663, 0x54fb},
	{0x8664, 0x54fe},
	{0x8665, 0x5500},
	{0x8666, 0x5502},
	{0x8667, 0x5503},
	{0x8668, 0x5504},
	{0x8669, 0x5505},
	{0x866a, 0x5508},
	{0x866b, 0x550a},
	{0x866c, 0x550b},
	{0x866d, 0x550c},
	{0x866e, 0x550d},
	{0x866f, 0x550e},
	{0x8670, 0x5512},
	{0x8671, 0x5513},
	{0x8672, 0x5515},
	{0x8673, 0x5516},
	{0x8674, 0x5517},
	{0x8675, 0x5518},
	{0x8676, 0x5519},
	{0x8677, 0x551a},
	{0x8678, 0x551c},
	{0x8679, 0x551d},
	{0x867a, 0x551e},
	{0x867b, 0x551f},
	{0x867c, 0x5521},
	{0x867d, 0x5525},
	{0x867e, 0x5526},
	{0x8680, 0x5528},
	{0x8681, 0x5529},
	{0x8682, 0x552b},
	{0x8683, 0x552d},
	{0x8684, 0x5532},
	{0x8685, 0x5534},
	{0x8686, 0x5535},
	{0x8687, 0x5536},
	{0x8688, 0x5538},
	{0x8689, 0x5539},
	{0x868a, 0x553a},
	{0x868b, 0x553b},
	{0x868c, 0x553d},
	{0x868d, 0x5540},
	{0x868e, 0x5542},
	{0x868f, 0x5545},
	{0x8690, 0x5547},
	{0x8691, 0x5548},
	{0x8692, 0x554b},
	{0x8693, 0x554c},
	{0x8694, 0x554d},
	{0x8695, 0x554e},
	{0x8696, 0x554f},
	{0x8697, 0x5551},
	{0x8698, 0x5552},
	{0x8699, 0x5553},
	{0x869a, 0x5554},
	{0x869b, 0x5557},
	{0x869c, 0x5558},
	{0x869d, 0x5559},
	{0x869e, 0x555a},
	{0x869f, 0x555b},
	{0x86a0, 0x555d},
	{0x86a1, 0x555e},
	{0x86a2, 0x555f},
	{0x86a3, 0x5560},
	{0x86a4, 0x5562},
	{0x86a5, 0x5563},
	{0x86a6, 0x5568},
	{0x86a7, 0x5569},
	{0x86a8, 0x556b},
	{0x86a9, 0x556f},
	{0x86aa, 0x5570},
	{0x86ab, 0x5571},
	{0x86ac, 0x5572},
	{0x86ad, 0x5573},
	{0x86ae, 0x5574},
	{0x86af, 0x5579},
	{0x86b0, 0x557a},
	{0x86b1, 0x557d},
	{0x86b2, 0x557f},
	{0x86b3, 0x5585},
	{0x86b4, 0x5586},
	{0x86b5, 0x558c},
	{0x86b6, 0x558d},
	{0x86b7, 0x558e},
	{0x86b8, 0x5590},
	{0x86b9, 0x5592},
	{0x86ba, 0x5593},
	{0x86bb, 0x5595},
	{0x86bc, 0x5596},
	{0x86bd, 0x5597},
	{0x86be, 0x559a},
	{0x86bf, 0x559b},
	{0x86c0, 0x559e},
	{0x86c1, 0x55a0},
	{0x86c2, 0x55a1},
	{0x86c3, 0x55a2},
	{0x86c4, 0x55a3},
	{0x86c5, 0x55a4},
	{0x86c6, 0x55a5},
	{0x86c7, 0x55a6},
	{0x86c8, 0x55a8},
	{0x86c9, 0x55a9},
	{0x86ca, 0x55aa},
	{0x86cb, 0x55ab},
	{0x86cc, 0x55ac},
	{0x86cd, 0x55ad},
	{0x86ce, 0x55ae},
	{0x86cf, 0x55af},
	{0x86d0, 0x55b0},
	{0x86d1, 0x55b2},
	{0x86d2, 0x55b4},
	{0x86d3, 0x55b6},
	{0x86d4, 0x55b8},
	{0x86d5, 0x55ba},
	{0x86d6, 0x55bc},
	{0x86d7, 0x55bf},
	{0x86d8, 0x55c0},
	{0x86d9, 0x55c1},
	{0x86da, 0x55c2},
	{0x86db, 0x55c3},
	{0x86dc, 0x55c6},
	{0x86dd, 0x55c7},
	{0x86de, 0x55c8},
	{0x86df, 0x55ca},
	{0x86e0, 0x55cb},
	{0x86e1, 0x55ce},
	{0x86e2, 0x55cf},
	{0x86e3, 0x55d0},
	{0x86e4, 0x55d5},
	{0x86e5, 0x55d7},
	{0x86e6, 0x55d8},
	{0x86e7, 0x55d9},
	{0x86e8, 0x55da},
	{0x86e9, 0x55db},
	{0x86ea, 0x55de},
	{0x86eb, 0x55e0},
	{0x86ec, 0x55e2},
	{0x86ed, 0x55e7},
	{0x86ee, 0x55e9},
	{0x86ef, 0x55ed},
	{0x86f0, 0x55ee},
	{0x86f1, 0x55f0},
	{0x86f2, 0x55f1},
	{0x86f3, 0x55f4},
	{0x86f4, 0x55f6},
	{0x86f5, 0x55f8},
	{0x86f6, 0x55f9},
	{0x86f7, 0x55fa},
	{0x86f8, 0x55fb},
	{0x86f9, 0x55fc},
	{0x86fa, 0x55ff},
	{0x86fb, 0x5602},
	{0x86fc, 0x5603},
	{0x86fd, 0x5604},
	{0x86fe, 0x5605},
	{0x8740, 0x5606},
	{0x8741, 0x5607},
	{0x8742, 0x560a},
	{0x8743, 0x560b},
	{0x8744, 0x560d},
	{0x8745, 0x5610},
	{0x8746, 0x5611},
	{0x8747, 0x5612},
	{0x8748, 0x5613},
	{0x8749, 0x5614},
	{0x874a, 0x5615},
	{0x874b, 0x5616},
	{0x874c, 0x5617},
	{0x874d, 0x5619},
	{0x874e, 0x561a},
	{0x874f, 0x561c},
	{0x8750, 0x561d},
	{0x8751, 0x5620},
	{0x8752, 0x5621},
	{0x8753, 0x5622},
	{0x8754, 0x5625},
	{0x8755, 0x5626},
	{0x8756, 0x5628},
	{0x8757, 0x5629},
	{0x8758, 0x562a},
	{0x8759, 0x562b},
	{0x875a, 0x562e},
	{0x875b, 0x562f},
	{0x875c, 0x5630},
	{0x875d, 0x5633},
	{0x875e, 0x5635},
	{0x875f, 0x5637},
	{0x8760, 0x5638},
	{0x8761, 0x563a},
	{0x8762, 0x563c},
	{0x8763, 0x563d},
	{0x8764, 0x563e},
	{0x8765, 0x5640},
	{0x8766, 0x5641},
	{0x8767, 0x5642},
	{0x8768, 0x5643},
	{0x8769, 0x5644},
	{0x876a, 0x5645},
	{0x876b, 0x5646},
	{0x876c, 0x5647},
	{0x876d, 0x5648},
	{0x876e, 0x5649},
	{0x876f, 0x564a},
	{0x8770, 0x564b},
	{0x8771, 0x564f},
	{0x8772, 0x5650},
	{0x8773, 0x5651},
	{0x8774, 0x5652},
	{0x8775, 0x5653},
	{0x8776, 0x5655},
	{0x8777, 0x5656},
	{0x8778, 0x565a},
	{0x8779, 0x565b},
	{0x877a, 0x565d},
	{0x877b, 0x565e},
	{0x877c, 0x565f},
	{0x877d, 0x5660},
	{0x877e, 0x5661},
	{0x8780, 0x5663},
	{0x8781, 0x5665},
	{0x8782, 0x5666},
	{0x8783, 0x5667},
	{0x8784, 0x566d},
	{0x8785, 0x566e},
	{0x8786, 0x566f},
	{0x8787, 0x5670},
	{0x8788, 0x5672},
	{0x8789, 0x5673},
	{0x878a, 0x5674},
	{0x878b, 0x5675},
	{0x878c, 0x5677},
	{0x878d, 0x5678},
	{0x878e, 0x5679},
	{0x878f, 0x567a},
	{0x8790, 0x567d},
	{0x8791, 0x567e},
	{0x8792, 0x567f},
	{0x8793, 0x5680},
	{0x8794, 0x5681},
	{0x8795, 0x5682},
	{0x8796, 0x5683},
	{0x8797, 0x5684},
	{0x8798, 0x5687},
	{0x8799, 0x5688},
	{0x879a, 0x5689},
	{0x879b, 0x568a},
	{0x879c, 0x568b},
	{0x879d, 0x568c},
	{0x879e, 0x568d},
	{0x879f, 0x5690},
	{0x87a0, 0x5691},
	{0x87a1, 0x5692},
	{0x87a2, 0x5694},
	{0x87a3, 0x5695},
	{0x87a4, 0x5696},
	{0x87a5, 0x5697},
	{0x87a6, 0x5698},
	{0x87a7, 0x5699},
	{0x87a8, 0x569a},
	{0x87a9, 0x569b},
	{0x87aa, 0x569c},
	{0x87ab, 0x569d},
	{0x87ac, 0x569e},
	{0x87ad, 0x569f},
	{0x87ae, 0x56a0},
	{0x87af, 0x56a1},
	{0x87b0, 0x56a2},
	{0x87b1, 0x56a4},
	{0x87b2, 0x56a5},
	{0x87b3, 0x56a6},
	{0x87b4, 0x56a7},
	{0x87b5, 0x56a8},
	{0x87b6, 0x56a9},
	{0x87b7, 0x56aa},
	{0x87b8, 0x56ab},
	{0x87b9, 0x56ac},
	{0x87ba, 0x56ad},
	{0x87bb, 0x56ae},
	{0x87bc, 0x56b0},
	{0x87bd, 0x56b1},
	{0x87be, 0x56b2},
	{0x87bf, 0x56b3},
	{0x87c0, 0x56b4},
	{0x87c1, 0x56b5},
	{0x87c2, 0x56b6},
	{0x87c3, 0x56b8},
	{0x87c4, 0x56b9},
	{0x87c5, 0x56ba},
	{0x87c6, 0x56bb},
	{0x87c7, 0x56bd},
	{0x87c8, 0x56be},
	{0x87c9, 0x56bf},
	{0x87ca, 0x56c0},
	{0x87cb, 0x56c1},
	{0x87cc, 0x56c2},
	{0x87cd, 0x56c3},
	{0x87ce, 0x56c4},
	{0x87cf, 0x56c5},
	{0x87d0, 0x56c6},
	{0x87d1, 0x56c7},
	{0x87d2, 0x56c8},
	{0x87d3, 0x56c9},
	{0x87d4, 0x56cb},
	{0x87d5, 0x56cc},
	{0x87d6, 0x56cd},
	{0x87d7, 0x56ce},
	{0x87d8, 0x56cf},
	{0x87d9, 0x56d0},
	{0x87da, 0x56d1},
	{0x87db, 0x56d2},
	{0x87dc, 0x56d3},
	{0x87dd, 0x56d5},
	{0x87de, 0x56d6},
	{0x87df, 0x56d8},
	{0x87e0, 0x56d9},
	{0x87e1, 0x56dc},
	{0x87e2, 0x56e3},
	{0x87e3, 0x56e5},
	{0x87e4, 0x56e6},
	{0x87e5, 0x56e7},
	{0x87e6, 0x56e8},
	{0x87e7, 0x56e9},
	{0x87e8, 0x56ea},
	{0x87e9, 0x56ec},
	{0x87ea, 0x56ee},
	{0x87eb, 0x56ef},
	{0x87ec, 0x56f2},
	{0x87ed, 0x56f3},
	{0x87ee, 0x56f6},
	{0x87ef, 0x56f7},
	{0x87f0, 0x56f8},
	{0x87f1, 0x56fb},
	{0x87f2, 0x56fc},
	{0x87f3, 0x5700},
	{0x87f4, 0x5701},
	{0x87f5, 0x5702},
	{0x87f6, 0x5705},
	{0x87f7, 0x5707},
	{0x87f8, 0x570b},
	{0x87f9, 0x570c},
	{0x87fa, 0x570d},
	{0x87fb, 0x570e},
	{0x87fc, 0x570f},
	{0x87fd, 0x5710},
	{0x87fe, 0x5711},
	{0x8840, 0x5712},
	{0x8841, 0x5713},
	{0x8842, 0x5714},
	{0x8843, 0x5715},
	{0x8844, 0x5716},
	{0x8845, 0x5717},
	{0x8846, 0x5718},
	{0x8847, 0x5719},
	{0x8848, 0x571a},
	{0x8849, 0x571b},
	{0x884a, 0x571d},
	{0x884b, 0x571e},
	{0x884c, 0x5720},
	{0x884d, 0x5721},
	{0x884e, 0x5722},
	{0x884f, 0x5724},
	{0x8850, 0x5725},
	{0x8851, 0x5726},
	{0x8852, 0x5727},
	{0x8853, 0x572b},
	{0x8854, 0x5731},
	{0x8855, 0x5732},
	{0x8856, 0x5734},
	{0x8857, 0x5735},
	{0x8858, 0x5736},
	{0x8859, 0x5737},
	{0x885a, 0x5738},
	{0x885b, 0x573c},
	{0x885c, 0x573d},
	{0x885d, 0x573f},
	{0x885e, 0x5741},
	{0x885f, 0x5743},
	{0x8860, 0x5744},
	{0x8861, 0x5745},
	{0x8862, 0x5746},
	{0x8863, 0x5748},
	{0x8864, 0x5749},
	{0x8865, 0x574b},
	{0x8866, 0x5752},
	{0x8867, 0x5753},
	{0x8868, 0x5754},
	{0x8869, 0x5755},
	{0x886a, 0x5756},
	{0x886b, 0x5758},
	{0x886c, 0x5759},
	{0x886d, 0x5762},
	{0x886e, 0x5763},
	{0x886f, 0x5765},
	{0x8870, 0x5767},
	{0x8871, 0x576c},
	{0x8872, 0x576e},
	{0x8873, 0x5770},
	{0x8874, 0x5771},
	{0x8875, 0x5772},
	{0x8876, 0x5774},
	{0x8877, 0x5775},
	{0x8878, 0x5778},
	{0x8879, 0x5779},
	{0x887a, 0x577a},
	{0x887b, 0x577d},
	{0x887c, 0x577e},
	{0x887d, 0x577f},
	{0x887e, 0x5780},
	{0x8880, 0x5781},
	{0x8881, 0x5787},
	{0x8882, 0x5788},
	{0x8883, 0x5789},
	{0x8884, 0x578a},
	{0x8885, 0x578d},
	{0x8886, 0x578e},
	{0x8887, 0x578f},
	{0x8888, 0x5790},
	{0x8889, 0x5791},
	{0x888a, 0x5794},
	{0x888b, 0x5795},
	{0x888c, 0x5796},
	{0x888d, 0x5797},
	{0x888e, 0x5798},
	{0x888f, 0x5799},
	{0x8890, 0x579a},
	{0x8891, 0x579c},
	{0x8892, 0x579d},
	{0x8893, 0x579e},
	{0x8894, 0x579f},
	{0x8895, 0x57a5},
	{0x8896, 0x57a8},
	{0x8897, 0x57aa},
	{0x8898, 0x57ac},
	{0x8899, 0x57af},
	{0x889a, 0x57b0},
	{0x889b, 0x57b1},
	{0x889c, 0x57b3},
	{0x889d, 0x57b5},
	{0x889e, 0x57b6},
	{0x889f, 0x57b7},
	{0x88a0, 0x57b9},
	{0x88a1, 0x57ba},
	{0x88a2, 0x57bb},
	{0x88a3, 0x57bc},
	{0x88a4, 0x57bd},
	{0x88a5, 0x57be},
	{0x88a6, 0x57bf},
	{0x88a7, 0x57c0},
	{0x88a8, 0x57c1},
	{0x88a9, 0x57c4},
	{0x88aa, 0x57c5},
	{0x88ab, 0x57c6},
	{0x88ac, 0x57c7},
	{0x88ad, 0x57c8},
	{0x88ae, 0x57c9},
	{0x88af, 0x57ca},
	{0x88b0, 0x57cc},
	{0x88b1, 0x57cd},
	{0x88b2, 0x57d0},
	{0x88b3, 0x57d1},
	{0x88b4, 0x57d3},
	{0x88b5, 0x57d6},
	{0x88b6, 0x57d7},
	{0x88b7, 0x57db},
	{0x88b8, 0x57dc},
	{0x88b9, 0x57de},
	{0x88ba, 0x57e1},
	{0x88bb, 0x57e2},
	{0x88bc, 0x57e3},
	{0x88bd, 0x57e5},
	{0x88be, 0x57e6},
	{0x88bf, 0x57e7},
	{0x88c0, 0x57e8},
	{0x88c1, 0x57e9},
	{0x88c2, 0x57ea},
	{0x88c3, 0x57eb},
	{0x88c4, 0x57ec},
	{0x88c5, 0x57ee},
	{0x88c6, 0x57f0},
	{0x88c7, 0x57f1},
	{0x88c8, 0x57f2},
	{0x88c9, 0x57f3},
	{0x88ca, 0x57f5},
	{0x88cb, 0x57f6},
	{0x88cc, 0x57f7},
	{0x88cd, 0x57fb},
	{0x88ce, 0x57fc},
	{0x88cf, 0x57fe},
	{0x88d0, 0x57ff},
	{0x88d1, 0x5801},
	{0x88d2, 0x5803},
	{0x88d3, 0x5804},
	{0x88d4, 0x5805},
	{0x88d5, 0x5808},
	{0x88d6, 0x5809},
	{0x88d7, 0x580a},
	{0x88d8, 0x580c},
	{0x88d9, 0x580e},
	{0x88da, 0x580f},
	{0x88db, 0x5810},
	{0x88dc, 0x5812},
	{0x88dd, 0x5813},
	{0x88de, 0x5814},
	{0x88df, 0x5816},
	{0x88e0, 0x5817},
	{0x88e1, 0x5818},
	{0x88e2, 0x581a},
	{0x88e3, 0x581b},
	{0x88e4, 0x581c},
	{0x88e5, 0x581d},
	{0x88e6, 0x581f},
	{0x88e7, 0x5822},
	{0x88e8, 0x5823},
	{0x88e9, 0x5825},
	{0x88ea, 0x5826},
	{0x88eb, 0x5827},
	{0x88ec, 0x5828},
	{0x88ed, 0x5829},
	{0x88ee, 0x582b},
	{0x88ef, 0x582c},
	{0x88f0, 0x582d},
	{0x88f1, 0x582e},
	{0x88f2, 0x582f},
	{0x88f3, 0x5831},
	{0x88f4, 0x5832},
	{0x88f5, 0x5833},
	{0x88f6, 0x5834},
	{0x88f7, 0x5836},
	{0x88f8, 0x5837},
	{0x88f9, 0x5838},
	{0x88fa, 0x5839},
	{0x88fb, 0x583a},
	{0x88fc, 0x583b},
	{0x88fd, 0x583c},
	{0x88fe, 0x583d},
	{0x8940, 0x583e},
	{0x8941, 0x583f},
	{0x8942, 0x5840},
	{0x8943, 0x5841},
	{0x8944, 0x5842},
	{0x8945, 0x5843},
	{0x8946, 0x5845},
	{0x8947, 0x5846},
	{0x8948, 0x5847},
	{0x8949, 0x5848},
	{0x894a, 0x5849},
	{0x894b, 0x584a},
	{0x894c, 0x584b},
	{0x894d, 0x584e},
	{0x894e, 0x584f},
	{0x894f, 0x5850},
	{0x8950, 0x5852},
	{0x8951, 0x5853},
	{0x8952, 0x5855},
	{0x8953, 0x5856},
	{0x8954, 0x5857},
	{0x8955, 0x5859},
	{0x8956, 0x585a},
	{0x8957, 0x585b},
	{0x8958, 0x585c},
	{0x8959, 0x585d},
	{0x895a, 0x585f},
	{0x895b, 0x5860},
	{0x895c, 0x5861},
	{0x895d, 0x5862},
	{0x895e, 0x5863},
	{0x895f, 0x5864},
	{0x8960, 0x5866},
	{0x8961, 0x5867},
	{0x8962, 0x5868},
	{0x8963, 0x5869},
	{0x8964, 0x586a},
	{0x8965, 0x586d},
	{0x8966, 0x586e},
	{0x8967, 0x586f},
	{0x8968, 0x5870},
	{0x8969, 0x5871},
	{0x896a, 0x5872},
	{0x896b, 0x5873},
	{0x896c, 0x5874},
	{0x896d, 0x5875},
	{0x896e, 0x5876},
	{0x896f, 0x5877},
	{0x8970, 0x5878},
	{0x8971, 0x5879},
	{0x8972, 0x587a},
	{0x8973, 0x587b},
	{0x8974, 0x587c},
	{0x8975, 0x587d},
	{0x8976, 0x587f},
	{0x8977, 0x5882},
	{0x8978, 0x5884},
	{0x8979, 0x5886},
	{0x897a, 0x5887},
	{0x897b, 0x5888},
	{0x897c, 0x588a},
	{0x897d, 0x588b},
	{0x897e, 0x588c},
	{0x8980, 0x588d},
	{0x8981, 0x588e},
	{0x8982, 0x588f},
	{0x8983, 0x5890},
	{0x8984, 0x5891},
	{0x8985, 0x5894},
	{0x8986, 0x5895},
	{0x8987, 0x5896},
	{0x8988, 0x5897},
	{0x8989, 0x5898},
	{0x898a, 0x589b},
	{0x898b, 0x589c},
	{0x898c, 0x589d},
	{0x898d, 0x58a0},
	{0x898e, 0x58a1},
	{0x898f, 0x58a2},
	{0x8990, 0x58a3},
	{0x8991, 0x58a4},
	{0x8992, 0x58a5},
	{0x8993, 0x58a6},
	{0x8994, 0x58a7},
	{0x8995, 0x58aa},
	{0x8996, 0x58ab},
	{0x8997, 0x58ac},
	{0x8998, 0x58ad},
	{0x8999, 0x58ae},
	{0x899a, 0x58af},
	{0x899b, 0x58b0},
	{0x899c, 0x58b1},
	{0x899d, 0x58b2},
	{0x899e, 0x58b3},
	{0x899f, 0x58b4},
	{0x89a0, 0x58b5},
	{0x89a1, 0x58b6},
	{0x89a2, 0x58b7},
	{0x89a3, 0x58b8},
	{0x89a4, 0x58b9},
	{0x89a5, 0x58ba},
	{0x89a6, 0x58bb},
	{0x89a7, 0x58bd},
	{0x89a8, 0x58be},
	{0x89a9, 0x58bf},
	{0x89aa, 0x58c0},
	{0x89ab, 0x58c2},
	{0x89ac, 0x58c3},
	{0x89ad, 0x58c4},
	{0x89ae, 0x58c6},
	{0x89af, 0x58c7},
	{0x89b0, 0x58c8},
	{0x89b1, 0x58c9},
	{0x89b2, 0x58ca},
	{0x89b3, 0x58cb},
	{0x89b4, 0x58cc},
	{0x89b5, 0x58cd},
	{0x89b6, 0x58ce},
	{0x89b7, 0x58cf},
	{0x89b8, 0x58d0},
	{0x89b9, 0x58d2},
	{0x89ba, 0x58d3},
	{0x89bb, 0x58d4},
	{0x89bc, 0x58d6},
	{0x89bd, 0x58d7},
	{0x89be, 0x58d8},
	{0x89bf, 0x58d9},
	{0x89c0, 0x58da},
	{0x89c1, 0x58db},
	{0x89c2, 0x58dc},
	{0x89c3, 0x58dd},
	{0x89c4, 0x58de},
	{0x89c5, 0x58df},
	{0x89c6, 0x58e0},
	{0x89c7, 0x58e1},
	{0x89c8, 0x58e2},
	{0x89c9, 0x58e3},
	{0x89ca, 0x58e5},
	{0x89cb, 0x58e6},
	{0x89cc, 0x58e7},
	{0x89cd, 0x58e8},
	{0x89ce, 0x58e9},
	{0x89cf, 0x58ea},
	{0x89d0, 0x58ed},
	{0x89d1, 0x58ef},
	{0x89d2, 0x58f1},
	{0x89d3, 0x58f2},
	{0x89d4, 0x58f4},
	{0x89d5, 0x58f5},
	{0x89d6, 0x58f7},
	{0x89d7, 0x58f8},
	{0x89d8, 0x58fa},
	{0x89d9, 0x58fb},
	{0x89da, 0x58fc},
	{0x89db, 0x58fd},
	{0x89dc, 0x58fe},
	{0x89dd, 0x58ff},
	{0x89de, 0x5900},
	{0x89df, 0x5901},
	{0x89e0, 0x5903},
	{0x89e1, 0x5905},
	{0x89e2, 0x5906},
	{0x89e3, 0x5908},
	{0x89e4, 0x5909},
	{0x89e5, 0x590a},
	{0x89e6, 0x590b},
	{0x89e7, 0x590c},
	{0x89e8, 0x590e},
	{0x89e9, 0x5910},
	{0x89ea, 0x5911},
	{0x89eb, 0x5912},
	{0x89ec, 0x5913},
	{0x89ed, 0x5917},
	{0x89ee, 0x5918},
	{0x89ef, 0x591b},
	{0x89f0, 0x591d},
	{0x89f1, 0x591e},
	{0x89f2, 0x5920},
	{0x89f3, 0x5921},
	{0x89f4, 0x5922},
	{0x89f5, 0x5923},
	{0x89f6, 0x5926},
	{0x89f7, 0x5928},
	{0x89f8, 0x592c},
	{0x89f9, 0x5930},
	{0x89fa, 0x5932},
	{0x89fb, 0x5933},
	{0x89fc, 0x5935},
	{0x89fd, 0x5936},
	{0x89fe, 0x593b},
	{0x8a40, 0x593d},
	{0x8a41, 0x593e},
	{0x8a42, 0x593f},
	{0x8a43, 0x5940},
	{0x8a44, 0x5943},
	{0x8a45, 0x5945},
	{0x8a46, 0x5946},
	{0x8a47, 0x594a},
	{0x8a48, 0x594c},
	{0x8a49, 0x594d},
	{0x8a4a, 0x5950},
	{0x8a4b, 0x5952},
	{0x8a4c, 0x5953},
	{0x8a4d, 0x5959},
	{0x8a4e, 0x595b},
	{0x8a4f, 0x595c},
	{0x8a50, 0x595d},
	{0x8a51, 0x595e},
	{0x8a52, 0x595f},
	{0x8a53, 0x5961},
	{0x8a54, 0x5963},
	{0x8a55, 0x5964},
	{0x8a56, 0x5966},
	{0x8a57, 0x5967},
	{0x8a58, 0x5968},
	{0x8a59, 0x5969},
	{0x8a5a, 0x596a},
	{0x8a5b, 0x596b},
	{0x8a5c, 0x596c},
	{0x8a5d, 0x596d},
	{0x8a5e, 0x596e},
	{0x8a5f, 0x596f},
	{0x8a60, 0x5970},
	{0x8a61, 0x5971},
	{0x8a62, 0x5972},
	{0x8a63, 0x5975},
	{0x8a64, 0x5977},
	{0x8a65, 0x597a},
	{0x8a66, 0x597b},
	{0x8a67, 0x597c},
	{0x8a68, 0x597e},
	{0x8a69, 0x597f},
	{0x8a6a, 0x5980},
	{0x8a6b, 0x5985},
	{0x8a6c, 0x5989},
	{0x8a6d, 0x598b},
	{0x8a6e, 0x598c},
	{0x8a6f, 0x598e},
	{0x8a70, 0x598f},
	{0x8a71, 0x5990},
	{0x8a72, 0x5991},
	{0x8a73, 0x5994},
	{0x8a74, 0x5995},
	{0x8a75, 0x5998},
	{0x8a76, 0x599a},
	{0x8a77, 0x599b},
	{0x8a78, 0x599c},
	{0x8a79, 0x599d},
	{0x8a7a, 0x599f},
	{0x8a7b, 0x59a0},
	{0x8a7c, 0x59a1},
	{0x8a7d, 0x59a2},
	{0x8a7e, 0x59a6},
	{0x8a80, 0x59a7},
	{0x8a81, 0x59ac},
	{0x8a82, 0x59ad},
	{0x8a83, 0x59b0},
	{0x8a84, 0x59b1},
	{0x8a85, 0x59b3},
	{0x8a86, 0x59b4},
	{0x8a87, 0x59b5},
	{0x8a88, 0x59b6},
	{0x8a89, 0x59b7},
	{0x8a8a, 0x59b8},
	{0x8a8b, 0x59ba},
	{0x8a8c, 0x59bc},
	{0x8a8d, 0x59bd},
	{0x8a8e, 0x59bf},
	{0x8a8f, 0x59c0},
	{0x8a90, 0x59c1},
	{0x8a91, 0x59c2},
	{0x8a92, 0x59c3},
	{0x8a93, 0x59c4},
	{0x8a94, 0x59c5},
	{0x8a95, 0x59c7},
	{0x8a96, 0x59c8},
	{0x8a97, 0x59c9},
	{0x8a98, 0x59cc},
	{0x8a99, 0x59cd},
	{0x8a9a, 0x59ce},
	{0x8a9b, 0x59cf},
	{0x8a9c, 0x59d5},
	{0x8a9d, 0x59d6},
	{0x8a9e, 0x59d9},
	{0x8a9f, 0x59db},
	{0x8aa0, 0x59de},
	{0x8aa1, 0x59df},
	{0x8aa2, 0x59e0},
	{0x8aa3, 0x59e1},
	{0x8aa4, 0x59e2},
	{0x8aa5, 0x59e4},
	{0x8aa6, 0x59e6},
	{0x8aa7, 0x59e7},
	{0x8aa8, 0x59e9},
	{0x8aa9, 0x59ea},
	{0x8aaa, 0x59eb},
	{0x8aab, 0x59ed},
	{0x8aac, 0x59ee},
	{0x8aad, 0x59ef},
	{0x8aae, 0x59f0},
	{0x8aaf, 0x59f1},
	{0x8ab0, 0x59f2},
	{0x8ab1, 0x59f3},
	{0x8ab2, 0x59f4},
	{0x8ab3, 0x59f5},
	{0x8ab4, 0x59f6},
	{0x8ab5, 0x59f7},
	{0x8ab6, 0x59f8},
	{0x8ab7, 0x59fa},
	{0x8ab8, 0x59fc},
	{0x8ab9, 0x59fd},
	{0x8aba, 0x59fe},
	{0x8abb, 0x5a00},
	{0x8abc, 0x5a02},
	{0x8abd, 0x5a0a},
	{0x8abe, 0x5a0b},
	{0x8abf, 0x5a0d},
	{0x8ac0, 0x5a0e},
	{0x8ac1, 0x5a0f},
	{0x8ac2, 0x5a10},
	{0x8ac3, 0x5a12},
	{0x8ac4, 0x5a14},
	{0x8ac5, 0x5a15},
	{0x8ac6, 0x5a16},
	{0x8ac7, 0x5a17},
	{0x8ac8, 0x5a19},
	{0x8ac9, 0x5a1a},
	{0x8aca, 0x5a1b},
	{0x8acb, 0x5a1d},
	{0x8acc, 0x5a1e},
	{0x8acd, 0x5a21},
	{0x8ace, 0x5a22},
	{0x8acf, 0x5a24},
	{0x8ad0, 0x5a26},
	{0x8ad1, 0x5a27},
	{0x8ad2, 0x5a28},
	{0x8ad3, 0x5a2a},
	{0x8ad4, 0x5a2b},
	{0x8ad5, 0x5a2c},
	{0x8ad6, 0x5a2d},
	{0x8ad7, 0x5a2e},
	{0x8ad8, 0x5a2f},
	{0x8ad9, 0x5a30},
	{0x8ada, 0x5a33},
	{0x8adb, 0x5a35},
	{0x8adc, 0x5a37},
	{0x8add, 0x5a38},
	{0x8ade, 0x5a39},
	{0x8adf, 0x5a3a},
	{0x8ae0, 0x5a3b},
	{0x8ae1, 0x5a3d},
	{0x8ae2, 0x5a3e},
	{0x8ae3, 0x5a3f},
	{0x8ae4, 0x5a41},
	{0x8ae5, 0x5a42},
	{0x8ae6, 0x5a43},
	{0x8ae7, 0x5a44},
	{0x8ae8, 0x5a45},
	{0x8ae9, 0x5a47},
	{0x8aea, 0x5a48},
	{0x8aeb, 0x5a4b},
	{0x8aec, 0x5a4c},
	{0x8aed, 0x5a4d},
	{0x8aee, 0x5a4e},
	{0x8aef, 0x5a4f},
	{0x8af0, 0x5a50},
	{0x8af1, 0x5a51},
	{0x8af2, 0x5a52},
	{0x8af3, 0x5a53},
	{0x8af4, 0x5a54},
	{0x8af5, 0x5a56},
	{0x8af6, 0x5a57},
	{0x8af7, 0x5a58},
	{0x8af8, 0x5a59},
	{0x8af9, 0x5a5b},
	{0x8afa, 0x5a5c},
	{0x8afb, 0x5a5d},
	{0x8afc, 0x5a5e},
	{0x8afd, 0x5a5f},
	{0x8afe, 0x5a60},
	{0x8b40, 0x5a61},
	{0x8b41, 0x5a63},
	{0x8b42, 0x5a64},
	{0x8b43, 0x5a65},
	{0x8b44, 0x5a66},
	{0x8b45, 0x5a68},
	{0x8b46, 0x5a69},
	{0x8b47, 0x5a6b},
	{0x8b48, 0x5a6c},
	{0x8b49, 0x5a6d},
	{0x8b4a, 0x5a6e},
	{0x8b4b, 0x5a6f},
	{0x8b4c, 0x5a70},
	{0x8b4d, 0x5a71},
	{0x8b4e, 0x5a72},
	{0x8b4f, 0x5a73},
	{0x8b50, 0x5a78},
	{0x8b51, 0x5a79},
	{0x8b52, 0x5a7b},
	{0x8b53, 0x5a7c},
	{0x8b54, 0x5a7d},
	{0x8b55, 0x5a7e},
	{0x8b56, 0x5a80},
	{0x8b57, 0x5a81},
	{0x8b58, 0x5a82},
	{0x8b59, 0x5a83},
	{0x8b5a, 0x5a84},
	{0x8b5b, 0x5a85},
	{0x8b5c, 0x5a86},
	{0x8b5d, 0x5a87},
	{0x8b5e, 0x5a88},
	{0x8b5f, 0x5a89},
	{0x8b60, 0x5a8a},
	{0x8b61, 0x5a8b},
	{0x8b62, 0x5a8c},
	{0x8b63, 0x5a8d},
	{0x8b64, 0x5a8e},
	{0x8b65, 0x5a8f},
	{0x8b66, 0x5a90},
	{0x8b67, 0x5a91},
	{0x8b68, 0x5a93},
	{0x8b69, 0x5a94},
	{0x8b6a, 0x5a95},
	{0x8b6b, 0x5a96},
	{0x8b6c, 0x5a97},
	{0x8b6d, 0x5a98},
	{0x8b6e, 0x5a99},
	{0x8b6f, 0x5a9c},
	{0x8b70, 0x5a9d},
	{0x8b71, 0x5a9e},
	{0x8b72, 0x5a9f},
	{0x8b73, 0x5aa0},
	{0x8b74, 0x5aa1},
	{0x8b75, 0x5aa2},
	{0x8b76, 0x5aa3},
	{0x8b77, 0x5aa4},
	{0x8b78, 0x5aa5},
	{0x8b79, 0x5aa6},
	{0x8b7a, 0x5aa7},
	{0x8b7b, 0x5aa8},
	{0x8b7c, 0x5aa9},
	{0x8b7d, 0x5aab},
	{0x8b7e, 0x5aac},
	{0x8b80, 0x5aad},
	{0x8b81, 0x5aae},
	{0x8b82, 0x5aaf},
	{0x8b83, 0x5ab0},
	{0x8b84, 0x5ab1},
	{0x8b85, 0x5ab4},
	{0x8b86, 0x5ab6},
	{0x8b87, 0x5ab7},
	{0x8b88, 0x5ab9},
	{0x8b89, 0x5aba},
	{0x8b8a, 0x5abb},
	{0x8b8b, 0x5abc},
	{0x8b8c, 0x5abd},
	{0x8b8d, 0x5abf},
	{0x8b8e, 0x5ac0},
	{0x8b8f, 0x5ac3},
	{0x8b90, 0x5ac4},
	{0x8b91, 0x5ac5},
	{0x8b92, 0x5ac6},
	{0x8b93, 0x5ac7},
	{0x8b94, 0x5ac8},
	{0x8b95, 0x5aca},
	{0x8b96, 0x5acb},
	{0x8b97, 0x5acd},
	{0x8b98, 0x5ace},
	{0x8b99, 0x5acf},
	{0x8b9a, 0x5ad0},
	{0x8b9b, 0x5ad1},
	{0x8b9c, 0x5ad3},
	{0x8b9d, 0x5ad5},
	{0x8b9e, 0x5ad7},
	{0x8b9f, 0x5ad9},
	{0x8ba0, 0x5ada},
	{0x8ba1, 0x5adb},
	{0x8ba2, 0x5add},
	{0x8ba3, 0x5ade},
	{0x8ba4, 0x5adf},
	{0x8ba5, 0x5ae2},
	{0x8ba6, 0x5ae4},
	{0x8ba7, 0x5ae5},
	{0x8ba8, 0x5ae7},
	{0x8ba9, 0x5ae8},
	{0x8baa, 0x5aea},
	{0x8bab, 0x5aec},
	{0x8bac, 0x5aed},
	{0x8bad, 0x5aee},
	{0x8bae, 0x5aef},
	{0x8baf, 0x5af0},
	{0x8bb0, 0x5af2},
	{0x8bb1, 0x5af3},
	{0x8bb2, 0x5af4},
	{0x8bb3, 0x5af5},
	{0x8bb4, 0x5af6},
	{0x8bb5, 0x5af7},
	{0x8bb6, 0x5af8},
	{0x8bb7, 0x5af9},
	{0x8bb8, 0x5afa},
	{0x8bb9, 0x5afb},
	{0x8bba, 0x5afc},
	{0x8bbb, 0x5afd},
	{0x8bbc, 0x5afe},
	{0x8bbd, 0x5aff},
	{0x8bbe, 0x5b00},
	{0x8bbf, 0x5b01},
	{0x8bc0, 0x5b02},
	{0x8bc1, 0x5b03},
	{0x8bc2, 0x5b04},
	{0x8bc3, 0x5b05},
	{0x8bc4, 0x5b06},
	{0x8bc5, 0x5b07},
	{0x8bc6, 0x5b08},
	{0x8bc7, 0x5b0a},
	{0x8bc8, 0x5b0b},
	{0x8bc9, 0x5b0c},
	{0x8bca, 0x5b0d},
	{0x8bcb, 0x5b0e},
	{0x8bcc, 0x5b0f},
	{0x8bcd, 0x5b10},
	{0x8bce, 0x5b11},
	{0x8bcf, 0x5b12},
	{0x8bd0, 0x5b13},
	{0x8bd1, 0x5b14},
	{0x8bd2, 0x5b15},
	{0x8bd3, 0x5b18},
	{0x8bd4, 0x5b19},
	{0x8bd5, 0x5b1a},
	{0x8bd6, 0x5b1b},
	{0x8bd7, 0x5b1c},
	{0x8bd8, 0x5b1d},
	{0x8bd9, 0x5b1e},
	{0x8bda, 0x5b1f},
	{0x8bdb, 0x5b20},
	{0x8bdc, 0x5b21},
	{0x8bdd, 0x5b22},
	{0x8bde, 0x5b23},
	{0x8bdf, 0x5b24},
	{0x8be0, 0x5b25},
	{0x8be1, 0x5b26},
	{0x8be2, 0x5b27},
	{0x8be3, 0x5b28},
	{0x8be4, 0x5b29},
	{0x8be5, 0x5b2a},
	{0x8be6, 0x5b2b},
	{0x8be7, 0x5b2c},
	{0x8be8, 0x5b2d},
	{0x8be9, 0x5b2e},
	{0x8bea, 0x5b2f},
	{0x8beb, 0x5b30},
	{0x8bec, 0x5b31},
	{0x8bed, 0x5b33},
	{0x8bee, 0x5b35},
	{0x8bef, 0x5b36},
	{0x8bf0, 0x5b38},
	{0x8bf1, 0x5b39},
	{0x8bf2, 0x5b3a},
	{0x8bf3, 0x5b3b},
	{0x8bf4, 0x5b3c},
	{0x8bf5, 0x5b3d},
	{0x8bf6, 0x5b3e},
	{0x8bf7, 0x5b3f},
	{0x8bf8, 0x5b41},
	{0x8bf9, 0x5b42},
	{0x8bfa, 0x5b43},
	{0x8bfb, 0x5b44},
	{0x8bfc, 0x5b45},
	{0x8bfd, 0x5b46},
	{0x8bfe, 0x5b47},
	{0x8c40, 0x5b48},
	{0x8c41, 0x5b49},
	{0x8c42, 0x5b4a},
	{0x8c43, 0x5b4b},
	{0x8c44, 0x5b4c},
	{0x8c45, 0x5b4d},
	{0x8c46, 0x5b4e},
	{0x8c47, 0x5b4f},
	{0x8c48, 0x5b52},
	{0x8c49, 0x5b56},
	{0x8c4a, 0x5b5e},
	{0x8c4b, 0x5b60},
	{0x8c4c, 0x5b61},
	{0x8c4d, 0x5b67},
	{0x8c4e, 0x5b68},
	{0x8c4f, 0x5b6b},
	{0x8c50, 0x5b6d},
	{0x8c51, 0x5b6e},
	{0x8c52, 0x5b6f},
	{0x8c53, 0x5b72},
	{0x8c54, 0x5b74},
	{0x8c55, 0x5b76},
	{0x8c56, 0x5b77},
	{0x8c57, 0x5b78},
	{0x8c58, 0x5b79},
	{0x8c59, 0x5b7b},
	{0x8c5a, 0x5b7c},
	{0x8c5b, 0x5b7e},
	{0x8c5c, 0x5b7f},
	{0x8c5d, 0x5b82},
	{0x8c5e, 0x5b86},
	{0x8c5f, 0x5b8a},
	{0x8c60, 0x5b8d},
	{0x8c61, 0x5b8e},
	{0x8c62, 0x5b90},
	{0x8c63, 0x5b91},
	{0x8c64, 0x5b92},
	{0x8c65, 0x5b94},
	{0x8c66, 0x5b96},
	{0x8c67, 0x5b9f},
	{0x8c68, 0x5ba7},
	{0x8c69, 0x5ba8},
	{0x8c6a, 0x5ba9},
	{0x8c6b, 0x5bac},
	{0x8c6c, 0x5bad},
	{0x8c6d, 0x5bae},
	{0x8c6e, 0x5baf},
	{0x8c6f, 0x5bb1},
	{0x8c70, 0x5bb2},
	{0x8c71, 0x5bb7},
	{0x8c72, 0x5bba},
	{0x8c73, 0x5bbb},
	{0x8c74, 0x5bbc},
	{0x8c75, 0x5bc0},
	{0x8c76, 0x5bc1},
	{0x8c77, 0x5bc3},
	{0x8c78, 0x5bc8},
	{0x8c79, 0x5bc9},
	{0x8c7a, 0x5bca},
	{0x8c7b, 0x5bcb},
	{0x8c7c, 0x5bcd},
	{0x8c7d, 0x5bce},
	{0x8c7e, 0x5bcf},
	{0x8c80, 0x5bd1},
	{0x8c81, 0x5bd4},
	{0x8c82, 0x5bd5},
	{0x8c83, 0x5bd6},
	{0x8c84, 0x5bd7},
	{0x8c85, 0x5bd8},
	{0x8c86, 0x5bd9},
	{0x8c87, 0x5bda},
	{0x8c88, 0x5bdb},
	{0x8c89, 0x5bdc},
	{0x8c8a, 0x5be0},
	{0x8c8b, 0x5be2},
	{0x8c8c, 0x5be3},
	{0x8c8d, 0x5be6},
	{0x8c8e, 0x5be7},
	{0x8c8f, 0x5be9},
	{0x8c90, 0x5bea},
	{0x8c91, 0x5beb},
	{0x8c92, 0x5bec},
	{0x8c93, 0x5bed},
	{0x8c94, 0x5bef},
	{0x8c95, 0x5bf1},
	{0x8c96, 0x5bf2},
	{0x8c97, 0x5bf3},
	{0x8c98, 0x5bf4},
	{0x8c99, 0x5bf5},
	{0x8c9a, 0x5bf6},
	{0x8c9b, 0x5bf7},
	{0x8c9c, 0x5bfd},
	{0x8c9d, 0x5bfe},
	{0x8c9e, 0x5c00},
	{0x8c9f, 0x5c02},
	{0x8ca0, 0x5c03},
	{0x8ca1, 0x5c05},
	{0x8ca2, 0x5c07},
	{0x8ca3, 0x5c08},
	{0x8ca4, 0x5c0b},
	{0x8ca5, 0x5c0c},
	{0x8ca6, 0x5c0d},
	{0x8ca7, 0x5c0e},
	{0x8ca8, 0x5c10},
	{0x8ca9, 0x5c12},
	{0x8caa, 0x5c13},
	{0x8cab, 0x5c17},
	{0x8cac, 0x5c19},
	{0x8cad, 0x5c1b},
	{0x8cae, 0x5c1e},
	{0x8caf, 0x5c1f},
	{0x8cb0, 0x5c20},
	{0x8cb1, 0x5c21},
	{0x8cb2, 0x5c23},
	{0x8cb3, 0x5c26},
	{0x8cb4, 0x5c28},
	{0x8cb5, 0x5c29},
	{0x8cb6, 0x5c2a},
	{0x8cb7, 0x5c2b},
	{0x8cb8, 0x5c2d},
	{0x8cb9, 0x5c2e},
	{0x8cba, 0x5c2f},
	{0x8cbb, 0x5c30},
	{0x8cbc, 0x5c32},
	{0x8cbd, 0x5c33},
	{0x8cbe, 0x5c35},
	{0x8cbf, 0x5c36},
	{0x8cc0, 0x5c37},
	{0x8cc1, 0x5c43},
	{0x8cc2, 0x5c44},
	{0x8cc3, 0x5c46},
	{0x8cc4, 0x5c47},
	{0x8cc5, 0x5c4c},
	{0x8cc6, 0x5c4d},
	{0x8cc7, 0x5c52},
	{0x8cc8, 0x5c53},
	{0x8cc9, 0x5c54},
	{0x8cca, 0x5c56},
	{0x8ccb, 0x5c57},
	{0x8ccc, 0x5c58},
	{0x8ccd, 0x5c5a},
	{0x8cce, 0x5c5b},
	{0x8ccf, 0x5c5c},
	{0x8cd0, 0x5c5d},
	{0x8cd1, 0x5c5f},
	{0x8cd2, 0x5c62},
	{0x8cd3, 0x5c64},
	{0x8cd4, 0x5c67},
	{0x8cd5, 0x5c68},
	{0x8cd6, 0x5c69},
	{0x8cd7, 0x5c6a},
	{0x8cd8, 0x5c6b},
	{0x8cd9, 0x5c6c},
	{0x8cda, 0x5c6d},
	{0x8cdb, 0x5c70},
	{0x8cdc, 0x5c72},
	{0x8cdd, 0x5c73},
	{0x8cde, 0x5c74},
	{0x8cdf, 0x5c75},
	{0x8ce0, 0x5c76},
	{0x8ce1, 0x5c77},
	{0x8ce2, 0x5c78},
	{0x8ce3, 0x5c7b},
	{0x8ce4, 0x5c7c},
	{0x8ce5, 0x5c7d},
	{0x8ce6, 0x5c7e},
	{0x8ce7, 0x5c80},
	{0x8ce8, 0x5c83},
	{0x8ce9, 0x5c84},
	{0x8cea, 0x5c85},
	{0x8ceb, 0x5c86},
	{0x8cec, 0x5c87},
	{0x8ced, 0x5c89},
	{0x8cee, 0x5c8a},
	{0x8cef, 0x5c8b},
	{0x8cf0, 0x5c8e},
	{0x8cf1, 0x5c8f},
	{0x8cf2, 0x5c92},
	{0x8cf3, 0x5c93},
	{0x8cf4, 0x5c95},
	{0x8cf5, 0x5c9d},
	{0x8cf6, 0x5c9e},
	{0x8cf7, 0x5c9f},
	{0x8cf8, 0x5ca0},
	{0x8cf9, 0x5ca1},
	{0x8cfa, 0x5ca4},
	{0x8cfb, 0x5ca5},
	{0x8cfc, 0x5ca6},
	{0x8cfd, 0x5ca7},
	{0x8cfe, 0x5ca8},
	{0x8d40, 0x5caa},
	{0x8d41, 0x5cae},
	{0x8d42, 0x5caf},
	{0x8d43, 0x5cb0},
	{0x8d44, 0x5cb2},
	{0x8d45, 0x5cb4},
	{0x8d46, 0x5cb6},
	{0x8d47, 0x5cb9},
	{0x8d48, 0x5cba},
	{0x8d49, 0x5cbb},
	{0x8d4a, 0x5cbc},
	{0x8d4b, 0x5cbe},
	{0x8d4c, 0x5cc0},
	{0x8d4d, 0x5cc2},
	{0x8d4e, 0x5cc3},
	{0x8d4f, 0x5cc5},
	{0x8d50, 0x5cc6},
	{0x8d51, 0x5cc7},
	{0x8d52, 0x5cc8},
	{0x8d53, 0x5cc9},
	{0x8d54, 0x5cca},
	{0x8d55, 0x5ccc},
	{0x8d56, 0x5ccd},
	{0x8d57, 0x5cce},
	{0x8d58, 0x5ccf},
	{0x8d59, 0x5cd0},
	{0x8d5a, 0x5cd1},
	{0x8d5b, 0x5cd3},
	{0x8d5c, 0x5cd4},
	{0x8d5d, 0x5cd5},
	{0x8d5e, 0x5cd6},
	{0x8d5f, 0x5cd7},
	{0x8d60, 0x5cd8},
	{0x8d61, 0x5cda},
	{0x8d62, 0x5cdb},
	{0x8d63, 0x5cdc},
	{0x8d64, 0x5cdd},
	{0x8d65, 0x5cde},
	{0x8d66, 0x5cdf},
	{0x8d67, 0x5ce0},
	{0x8d68, 0x5ce2},
	{0x8d69, 0x5ce3},
	{0x8d6a, 0x5ce7},
	{0x8d6b, 0x5ce9},
	{0x8d6c, 0x5ceb},
	{0x8d6d, 0x5cec},
	{0x8d6e, 0x5cee},
	{0x8d6f, 0x5cef},
	{0x8d70, 0x5cf1},
	{0x8d71, 0x5cf2},
	{0x8d72, 0x5cf3},
	{0x8d73, 0x5cf4},
	{0x8d74, 0x5cf5},
	{0x8d75, 0x5cf6},
	{0x8d76, 0x5cf7},
	{0x8d77, 0x5cf8},
	{0x8d78, 0x5cf9},
	{0x8d79, 0x5cfa},
	{0x8d7a, 0x5cfc},
	{0x8d7b, 0x5cfd},
	{0x8d7c, 0x5cfe},
	{0x8d7d, 0x5cff},
	{0x8d7e, 0x5d00},
	{0x8d80, 0x5d01},
	{0x8d81, 0x5d04},
	{0x8d82, 0x5d05},
	{0x8d83, 0x5d08},
	{0x8d84, 0x5d09},
	{0x8d85, 0x5d0a},
	{0x8d86, 0x5d0b},
	{0x8d87, 0x5d0c},
	{0x8d88, 0x5d0d},
	{0x8d89, 0x5d0f},
	{0x8d8a, 0x5d10},
	{0x8d8b, 0x5d11},
	{0x8d8c, 0x5d12},
	{0x8d8d, 0x5d13},
	{0x8d8e, 0x5d15},
	{0x8d8f, 0x5d17},
	{0x8d90, 0x5d18},
	{0x8d91, 0x5d19},
	{0x8d92, 0x5d1a},
	{0x8d93, 0x5d1c},
	{0x8d94, 0x5d1d},
	{0x8d95, 0x5d1f},
	{0x8d96, 0x5d20},
	{0x8d97, 0x5d21},
	{0x8d98, 0x5d22},
	{0x8d99, 0x5d23},
	{0x8d9a, 0x5d25},
	{0x8d9b, 0x5d28},
	{0x8d9c, 0x5d2a},
	{0x8d9d, 0x5d2b},
	{0x8d9e, 0x5d2c},
	{0x8d9f, 0x5d2f},
	{0x8da0, 0x5d30},
	{0x8da1, 0x5d31},
	{0x8da2, 0x5d32},
	{0x8da3, 0x5d33},
	{0x8da4, 0x5d35},
	{0x8da5, 0x5d36},
	{0x8da6, 0x5d37},
	{0x8da7, 0x5d38},
	{0x8da8, 0x5d39},
	{0x8da9, 0x5d3a},
	{0x8daa, 0x5d3b},
	{0x8dab, 0x5d3c},
	{0x8dac, 0x5d3f},
	{0x8dad, 0x5d40},
	{0x8dae, 0x5d41},
	{0x8daf, 0x5d42},
	{0x8db0, 0x5d43},
	{0x8db1, 0x5d44},
	{0x8db2, 0x5d45},
	{0x8db3, 0x5d46},
	{0x8db4, 0x5d48},
	{0x8db5, 0x5d49},
	{0x8db6, 0x5d4d},
	{0x8db7, 0x5d4e},
	{0x8db8, 0x5d4f},
	{0x8db9, 0x5d50},
	{0x8dba, 0x5d51},
	{0x8dbb, 0x5d52},
	{0x8dbc, 0x5d53},
	{0x8dbd, 0x5d54},
	{0x8dbe, 0x5d55},
	{0x8dbf, 0x5d56},
	{0x8dc0, 0x5d57},
	{0x8dc1, 0x5d59},
	{0x8dc2, 0x5d5a},
	{0x8dc3, 0x5d5c},
	{0x8dc4, 0x5d5e},
	{0x8dc5, 0x5d5f},
	{0x8dc6, 0x5d60},
	{0x8dc7, 0x5d61},
	{0x8dc8, 0x5d62},
	{0x8dc9, 0x5d63},
	{0x8dca, 0x5d64},
	{0x8dcb, 0x5d65},
	{0x8dcc, 0x5d66},
	{0x8dcd, 0x5d67},
	{0x8dce, 0x5d68},
	{0x8dcf, 0x5d6a},
	{0x8dd0, 0x5d6d},
	{0x8dd1, 0x5d6e},
	{0x8dd2, 0x5d70},
	{0x8dd3, 0x5d71},
	{0x8dd4, 0x5d72},
	{0x8dd5, 0x5d73},
	{0x8dd6, 0x5d75},
	{0x8dd7, 0x5d76},
	{0x8dd8, 0x5d77},
	{0x8dd9, 0x5d78},
	{0x8dda, 0x5d79},
	{0x8ddb, 0x5d7a},
	{0x8ddc, 0x5d7b},
	{0x8ddd, 0x5d7c},
	{0x8dde, 0x5d7d},
	{0x8ddf, 0x5d7e},
	{0x8de0, 0x5d7f},
	{0x8de1, 0x5d80},
	{0x8de2, 0x5d81},
	{0x8de3, 0x5d83},
	{0x8de4, 0x5d84},
	{0x8de5, 0x5d85},
	{0x8de6, 0x5d86},
	{0x8de7, 0x5d87},
	{0x8de8, 0x5d88},
	{0x8de9, 0x5d89},
	{0x8dea, 0x5d8a},
	{0x8deb, 0x5d8b},
	{0x8dec, 0x5d8c},
	{0x8ded, 0x5d8d},
	{0x8dee, 0x5d8e},
	{0x8def, 0x5d8f},
	{0x8df0, 0x5d90},
	{0x8df1, 0x5d91},
	{0x8df2, 0x5d92},
	{0x8df3, 0x5d93},
	{0x8df4, 0x5d94},
	{0x8df5, 0x5d95},
	{0x8df6, 0x5d96},
	{0x8df7, 0x5d97},
	{0x8df8, 0x5d98},
	{0x8df9, 0x5d9a},
	{0x8dfa, 0x5d9b},
	{0x8dfb, 0x5d9c},
	{0x8dfc, 0x5d9e},
	{0x8dfd, 0x5d9f},
	{0x8dfe, 0x5da0},
	{0x8e40, 0x5da1},
	{0x8e41, 0x5da2},
	{0x8e42, 0x5da3},
	{0x8e43, 0x5da4},
	{0x8e44, 0x5da5},
	{0x8e45, 0x5da6},
	{0x8e46, 0x5da7},
	{0x8e47, 0x5da8},
	{0x8e48, 0x5da9},
	{0x8e49, 0x5daa},
	{0x8e4a, 0x5dab},
	{0x8e4b, 0x5dac},
	{0x8e4c, 0x5dad},
	{0x8e4d, 0x5dae},
	{0x8e4e, 0x5daf},
	{0x8e4f, 0x5db0},
	{0x8e50, 0x5db1},
	{0x8e51, 0x5db2},
	{0x8e52, 0x5db3},
	{0x8e53, 0x5db4},
	{0x8e54, 0x5db5},
	{0x8e55, 0x5db6},
	{0x8e56, 0x5db8},
	{0x8e57, 0x5db9},
	{0x8e58, 0x5dba},
	{0x8e59, 0x5dbb},
	{0x8e5a, 0x5dbc},
	{0x8e5b, 0x5dbd},
	{0x8e5c, 0x5dbe},
	{0x8e5d, 0x5dbf},
	{0x8e5e, 0x5dc0},
	{0x8e5f, 0x5dc1},
	{0x8e60, 0x5dc2},
	{0x8e61, 0x5dc3},
	{0x8e62, 0x5dc4},
	{0x8e63, 0x5dc6},
	{0x8e64, 0x5dc7},
	{0x8e65, 0x5dc8},
	{0x8e66, 0x5dc9},
	{0x8e67, 0x5dca},
	{0x8e68, 0x5dcb},
	{0x8e69, 0x5dcc},
	{0x8e6a, 0x5dce},
	{0x8e6b, 0x5dcf},
	{0x8e6c, 0x5dd0},
	{0x8e6d, 0x5dd1},
	{0x8e6e, 0x5dd2},
	{0x8e6f, 0x5dd3},
	{0x8e70, 0x5dd4},
	{0x8e71, 0x5dd5},
	{0x8e72, 0x5dd6},
	{0x8e73, 0x5dd7},
	{0x8e74, 0x5dd8},
	{0x8e75, 0x5dd9},
	{0x8e76, 0x5dda},
	{0x8e77, 0x5ddc},
	{0x8e78, 0x5ddf},
	{0x8e79, 0x5de0},
	{0x8e7a, 0x5de3},
	{0x8e7b, 0x5de4},
	{0x8e7c, 0x5dea},
	{0x8e7d, 0x5dec},
	{0x8e7e, 0x5ded},
	{0x8e80, 0x5df0},
	{0x8e81, 0x5df5},
	{0x8e82, 0x5df6},
	{0x8e83, 0x5df8},
	{0x8e84, 0x5df9},
	{0x8e85, 0x5dfa},
	{0x8e86, 0x5dfb},
	{0x8e87, 0x5dfc},
	{0x8e88, 0x5dff},
	{0x8e89, 0x5e00},
	{0x8e8a, 0x5e04},
	{0x8e8b, 0x5e07},
	{0x8e8c, 0x5e09},
	{0x8e8d, 0x5e0a},
	{0x8e8e, 0x5e0b},
	{0x8e8f, 0x5e0d},
	{0x8e90, 0x5e0e},
	{0x8e91, 0x5e12},
	{0x8e92, 0x5e13},
	{0x8e93, 0x5e17},
	{0x8e94, 0x5e1e},
	{0x8e95, 0x5e1f},
	{0x8e96, 0x5e20},
	{0x8e97, 0x5e21},
	{0x8e98, 0x5e22},
	{0x8e99, 0x5e23},
	{0x8e9a, 0x5e24},
	{0x8e9b, 0x5e25},
	{0x8e9c, 0x5e28},
	{0x8e9d, 0x5e29},
	{0x8e9e, 0x5e2a},
	{0x8e9f, 0x5e2b},
	{0x8ea0, 0x5e2c},
	{0x8ea1, 0x5e2f},
	{0x8ea2, 0x5e30},
	{0x8ea3, 0x5e32},
	{0x8ea4, 0x5e33},
	{0x8ea5, 0x5e34},
	{0x8ea6, 0x5e35},
	{0x8ea7, 0x5e36},
	{0x8ea8, 0x5e39},
	{0x8ea9, 0x5e3a},
	{0x8eaa, 0x5e3e},
	{0x8eab, 0x5e3f},
	{0x8eac, 0x5e40},
	{0x8ead, 0x5e41},
	{0x8eae, 0x5e43},
	{0x8eaf, 0x5e46},
	{0x8eb0, 0x5e47},
	{0x8eb1, 0x5e48},
	{0x8eb2, 0x5e49},
	{0x8eb3, 0x5e4a},
	{0x8eb4, 0x5e4b},
	{0x8eb5, 0x5e4d},
	{0x8eb6, 0x5e4e},
	{0x8eb7, 0x5e4f},
	{0x8eb8, 0x5e50},
	{0x8eb9, 0x5e51},
	{0x8eba, 0x5e52},
	{0x8ebb, 0x5e53},
	{0x8ebc, 0x5e56},
	{0x8ebd, 0x5e57},
	{0x8ebe, 0x5e58},
	{0x8ebf, 0x5e59},
	{0x8ec0, 0x5e5a},
	{0x8ec1, 0x5e5c},
	{0x8ec2, 0x5e5d},
	{0x8ec3, 0x5e5f},
	{0x8ec4, 0x5e60},
	{0x8ec5, 0x5e63},
	{0x8ec6, 0x5e64},
	{0x8ec7, 0x5e65},
	{0x8ec8, 0x5e66},
	{0x8ec9, 0x5e67},
	{0x8eca, 0x5e68},
	{0x8ecb, 0x5e69},
	{0x8ecc, 0x5e6a},
	{0x8ecd, 0x5e6b},
	{0x8ece, 0x5e6c},
	{0x8ecf, 0x5e6d},
	{0x8ed0, 0x5e6e},
	{0x8ed1, 0x5e6f},
	{0x8ed2, 0x5e70},
	{0x8ed3, 0x5e71},
	{0x8ed4, 0x5e75},
	{0x8ed5, 0x5e77},
	{0x8ed6, 0x5e79},
	{0x8ed7, 0x5e7e},
	{0x8ed8, 0x5e81},
	{0x8ed9, 0x5e82},
	{0x8eda, 0x5e83},
	{0x8edb, 0x5e85},
	{0x8edc, 0x5e88},
	{0x8edd, 0x5e89},
	{0x8ede, 0x5e8c},
	{0x8edf, 0x5e8d},
	{0x8ee0, 0x5e8e},
	{0x8ee1, 0x5e92},
	{0x8ee2, 0x5e98},
	{0x8ee3, 0x5e9b},
	{0x8ee4, 0x5e9d},
	{0x8ee5, 0x5ea1},
	{0x8ee6, 0x5ea2},
	{0x8ee7, 0x5ea3},
	{0x8ee8, 0x5ea4},
	{0x8ee9, 0x5ea8},
	{0x8eea, 0x5ea9},
	{0x8eeb, 0x5eaa},
	{0x8eec, 0x5eab},
	{0x8eed, 0x5eac},
	{0x8eee, 0x5eae},
	{0x8eef, 0x5eaf},
	{0x8ef0, 0x5eb0},
	{0x8ef1, 0x5eb1},
	{0x8ef2, 0x5eb2},
	{0x8ef3, 0x5eb4},
	{0x8ef4, 0x5eba},
	{0x8ef5, 0x5ebb},
	{0x8ef6, 0x5ebc},
	{0x8ef7, 0x5ebd},
	{0x8ef8, 0x5ebf},
	{0x8ef9, 0x5ec0},
	{0x8efa, 0x5ec1},
	{0x8efb, 0x5ec2},
	{0x8efc, 0x5ec3},
	{0x8efd, 0x5ec4},
	{0x8efe, 0x5ec5},
	{0x8f40, 0x5ec6},
	{0x8f41, 0x5ec7},
	{0x8f42, 0x5ec8},
	{0x8f43, 0x5ecb},
	{0x8f44, 0x5ecc},
	{0x8f45, 0x5ecd},
	{0x8f46, 0x5ece},
	{0x8f47, 0x5ecf},
	{0x8f48, 0x5ed0},
	{0x8f49, 0x5ed4},
	{0x8f4a, 0x5ed5},
	{0x8f4b, 0x5ed7},
	{0x8f4c, 0x5ed8},
	{0x8f4d, 0x5ed9},
	{0x8f4e, 0x5eda},
	{0x8f4f, 0x5edc},
	{0x8f50, 0x5edd},
	{0x8f51, 0x5ede},
	{0x8f52, 0x5edf},
	{0x8f53, 0x5ee0},
	{0x8f54, 0x5ee1},
	{0x8f55, 0x5ee2},
	{0x8f56, 0x5ee3},
	{0x8f57, 0x5ee4},
	{0x8f58, 0x5ee5},
	{0x8f59, 0x5ee6},
	{0x8f5a, 0x5ee7},
	{0x8f5b, 0x5ee9},
	{0x8f5c, 0x5eeb},
	{0x8f5d, 0x5eec},
	{0x8f5e, 0x5eed},
	{0x8f5f, 0x5eee},
	{0x8f60, 0x5eef},
	{0x8f61, 0x5ef0},
	{0x8f62, 0x5ef1},
	{0x8f63, 0x5ef2},
	{0x8f64, 0x5ef3},
	{0x8f65, 0x5ef5},
	{0x8f66, 0x5ef8},
	{0x8f67, 0x5ef9},
	{0x8f68, 0x5efb},
	{0x8f69, 0x5efc},
	{0x8f6a, 0x5efd},
	{0x8f6b, 0x5f05},
	{0x8f6c, 0x5f06},
	{0x8f6d, 0x5f07},
	{0x8f6e, 0x5f09},
	{0x8f6f, 0x5f0c},
	{0x8f70, 0x5f0d},
	{0x8f71, 0x5f0e},
	{0x8f72, 0x5f10},
	{0x8f73, 0x5f12},
	{0x8f74, 0x5f14},
	{0x8f75, 0x5f16},
	{0x8f76, 0x5f19},
	{0x8f77, 0x5f1a},
	{0x8f78, 0x5f1c},
	{0x8f79, 0x5f1d},
	{0x8f7a, 0x5f1e},
	{0x8f7b, 0x5f21},
	{0x8f7c, 0x5f22},
	{0x8f7d, 0x5f23},
	{0x8f7e, 0x5f24},
	{0x8f80, 0x5f28},
	{0x8f81, 0x5f2b},
	{0x8f82, 0x5f2c},
	{0x8f83, 0x5f2e},
	{0x8f84, 0x5f30},
	{0x8f85, 0x5f32},
	{0x8f86, 0x5f33},
	{0x8f87, 0x5f34},
	{0x8f88, 0x5f35},
	{0x8f89, 0x5f36},
	{0x8f8a, 0x5f37},
	{0x8f8b, 0x5f38},
	{0x8f8c, 0x5f3b},
	{0x8f8d, 0x5f3d},
	{0x8f8e, 0x5f3e},
	{0x8f8f, 0x5f3f},
	{0x8f90, 0x5f41},
	{0x8f91, 0x5f42},
	{0x8f92, 0x5f43},
	{0x8f93, 0x5f44},
	{0x8f94, 0x5f45},
	{0x8f95, 0x5f46},
	{0x8f96, 0x5f47},
	{0x8f97, 0x5f48},
	{0x8f98, 0x5f49},
	{0x8f99, 0x5f4a},
	{0x8f9a, 0x5f4b},
	{0x8f9b, 0x5f4c},
	{0x8f9c, 0x5f4d},
	{0x8f9d, 0x5f4e},
	{0x8f9e, 0x5f4f},
	{0x8f9f, 0x5f51},
	{0x8fa0, 0x5f54},
	{0x8fa1, 0x5f59},
	{0x8fa2, 0x5f5a},
	{0x8fa3, 0x5f5b},
	{0x8fa4, 0x5f5c},
	{0x8fa5, 0x5f5e},
	{0x8fa6, 0x5f5f},
	{0x8fa7, 0x5f60},
	{0x8fa8, 0x5f63},
	{0x8fa9, 0x5f65},
	{0x8faa, 0x5f67},
	{0x8fab, 0x5f68},
	{0x8fac, 0x5f6b},
	{0x8fad, 0x5f6e},
	{0x8fae, 0x5f6f},
	{0x8faf, 0x5f72},
	{0x8fb0, 0x5f74},
	{0x8fb1, 0x5f75},
	{0x8fb2, 0x5f76},
	{0x8fb3, 0x5f78},
	{0x8fb4, 0x5f7a},
	{0x8fb5, 0x5f7d},
	{0x8fb6, 0x5f7e},
	{0x8fb7, 0x5f7f},
	{0x8fb8, 0x5f83},
	{0x8fb9, 0x5f86},
	{0x8fba, 0x5f8d},
	{0x8fbb, 0x5f8e},
	{0x8fbc, 0x5f8f},
	{0x8fbd, 0x5f91},
	{0x8fbe, 0x5f93},
	{0x8fbf, 0x5f94},
	{0x8fc0, 0x5f96},
	{0x8fc1, 0x5f9a},
	{0x8fc2, 0x5f9b},
	{0x8fc3, 0x5f9d},
	{0x8fc4, 0x5f9e},
	{0x8fc5, 0x5f9f},
	{0x8fc6, 0x5fa0},
	{0x8fc7, 0x5fa2},
	{0x8fc8, 0x5fa3},
	{0x8fc9, 0x5fa4},
	{0x8fca, 0x5fa5},
	{0x8fcb, 0x5fa6},
	{0x8fcc, 0x5fa7},
	{0x8fcd, 0x5fa9},
	{0x8fce, 0x5fab},
	{0x8fcf, 0x5fac},
	{0x8fd0, 0x5faf},
	{0x8fd1, 0x5fb0},
	{0x8fd2, 0x5fb1},
	{0x8fd3, 0x5fb2},
	{0x8fd4, 0x5fb3},
	{0x8fd5, 0x5fb4},
	{0x8fd6, 0x5fb6},
	{0x8fd7, 0x5fb8},
	{0x8fd8, 0x5fb9},
	{0x8fd9, 0x5fba},
	{0x8fda, 0x5fbb},
	{0x8fdb, 0x5fbe},
	{0x8fdc, 0x5fbf},
	{0x8fdd, 0x5fc0},
	{0x8fde, 0x5fc1},
	{0x8fdf, 0x5fc2},
	{0x8fe0, 0x5fc7},
	{0x8fe1, 0x5fc8},
	{0x8fe2, 0x5fca},
	{0x8fe3, 0x5fcb},
	{0x8fe4, 0x5fce},
	{0x8fe5, 0x5fd3},
	{0x8fe6, 0x5fd4},
	{0x8fe7, 0x5fd5},
	{0x8fe8, 0x5fda},
	{0x8fe9, 0x5fdb},
	{0x8fea, 0x5fdc},
	{0x8feb, 0x5fde},
	{0x8fec, 0x5fdf},
	{0x8fed, 0x5fe2},
	{0x8fee, 0x5fe3},
	{0x8fef, 0x5fe5},
	{0x8ff0, 0x5fe6},
	{0x8ff1, 0x5fe8},
	{0x8ff2, 0x5fe9},
	{0x8ff3, 0x5fec},
	{0x8ff4, 0x5fef},
	{0x8ff5, 0x5ff0},
	{0x8ff6, 0x5ff2},
	{0x8ff7, 0x5ff3},
	{0x8ff8, 0x5ff4},
	{0x8ff9, 0x5ff6},
	{0x8ffa, 0x5ff7},
	{0x8ffb, 0x5ff9},
	{0x8ffc, 0x5ffa},
	{0x8ffd, 0x5ffc},
	{0x8ffe, 0x6007},
	{0x9040, 0x6008},
	{0x9041, 0x6009},
	{0x9042, 0x600b},
	{0x9043, 0x600c},
	{0x9044, 0x6010},
	{0x9045, 0x6011},
	{0x9046, 0x6013},
	{0x9047, 0x6017},
	{0x9048, 0x6018},
	{0x9049, 0x601a},
	{0x904a, 0x601e},
	{0x904b, 0x601f},
	{0x904c, 0x6022},
	{0x904d, 0x6023},
	{0x904e, 0x6024},
	{0x904f, 0x602c},
	{0x9050, 0x602d},
	{0x9051, 0x602e},
	{0x9052, 0x6030},
	{0x9053, 0x6031},
	{0x9054, 0x6032},
	{0x9055, 0x6033},
	{0x9056, 0x6034},
	{0x9057, 0x6036},
	{0x9058, 0x6037},
	{0x9059, 0x6038},
	{0x905a, 0x6039},
	{0x905b, 0x603a},
	{0x905c, 0x603d},
	{0x905d, 0x603e},
	{0x905e, 0x6040},
	{0x905f, 0x6044},
	{0x9060, 0x6045},
	{0x9061, 0x6046},
	{0x9062, 0x6047},
	{0x9063, 0x6048},
	{0x9064, 0x6049},
	{0x9065, 0x604a},
	{0x9066, 0x604c},
	{0x9067, 0x604e},
	{0x9068, 0x604f},
	{0x9069, 0x6051},
	{0x906a, 0x6053},
	{0x906b, 0x6054},
	{0x906c, 0x6056},
	{0x906d, 0x6057},
	{0x906e, 0x6058},
	{0x906f, 0x605b},
	{0x9070, 0x605c},
	{0x9071, 0x605e},
	{0x9072, 0x605f},
	{0x9073, 0x6060},
	{0x9074, 0x6061},
	{0x9075, 0x6065},
	{0x9076, 0x6066},
	{0x9077, 0x606e},
	{0x9078, 0x6071},
	{0x9079, 0x6072},
	{0x907a, 0x6074},
	{0x907b, 0x6075},
	{0x907c, 0x6077},
	{0x907d, 0x607e},
	{0x907e, 0x6080},
	{0x9080, 0x6081},
	{0x9081, 0x6082},
	{0x9082, 0x6085},
	{0x9083, 0x6086},
	{0x9084, 0x6087},
	{0x9085, 0x6088},
	{0x9086, 0x608a},
	{0x9087, 0x608b},
	{0x9088, 0x608e},
	{0x9089, 0x608f},
	{0x908a, 0x6090},
	{0x908b, 0x6091},
	{0x908c, 0x6093},
	{0x908d, 0x6095},
	{0x908e, 0x6097},
	{0x908f, 0x6098},
	{0x9090, 0x6099},
	{0x9091, 0x609c},
	{0x9092, 0x609e},
	{0x9093, 0x60a1},
	{0x9094, 0x60a2},
	{0x9095, 0x60a4},
	{0x9096, 0x60a5},
	{0x9097, 0x60a7},
	{0x9098, 0x60a9},
	{0x9099, 0x60aa},
	{0x909a, 0x60ae},
	{0x909b, 0x60b0},
	{0x909c, 0x60b3},
	{0x909d, 0x60b5},
	{0x909e, 0x60b6},
	{0x909f, 0x60b7},
	{0x90a0, 0x60b9},
	{0x90a1, 0x60ba},
	{0x90a2, 0x60bd},
	{0x90a3, 0x60be},
	{0x90a4, 0x60bf},
	{0x90a5, 0x60c0},
	{0x90a6, 0x60c1},
	{0x90a7, 0x60c2},
	{0x90a8, 0x60c3},
	{0x90a9, 0x60c4},
	{0x90aa, 0x60c7},
	{0x90ab, 0x60c8},
	{0x90ac, 0x60c9},
	{0x90ad, 0x60cc},
	{0x90ae, 0x60cd},
	{0x90af, 0x60ce},
	{0x90b0, 0x60cf},
	{0x90b1, 0x60d0},
	{0x90b2, 0x60d2},
	{0x90b3, 0x60d3},
	{0x90b4, 0x60d4},
	{0x90b5, 0x60d6},
	{0x90b6, 0x60d7},
	{0x90b7, 0x60d9},
	{0x90b8, 0x60db},
	{0x90b9, 0x60de},
	{0x90ba, 0x60e1},
	{0x90bb, 0x60e2},
	{0x90bc, 0x60e3},
	{0x90bd, 0x60e4},
	{0x90be, 0x60e5},
	{0x90bf, 0x60ea},
	{0x90c0, 0x60f1},
	{0x90c1, 0x60f2},
	{0x90c2, 0x60f5},
	{0x90c3, 0x60f7},
	{0x90c4, 0x60f8},
	{0x90c5, 0x60fb},
	{0x90c6, 0x60fc},
	{0x90c7, 0x60fd},
	{0x90c8, 0x60fe},
	{0x90c9, 0x60ff},
	{0x90ca, 0x6102},
	{0x90cb, 0x6103},
	{0x90cc, 0x6104},
	{0x90cd, 0x6105},
	{0x90ce, 0x6107},
	{0x90cf, 0x610a},
	{0x90d0, 0x610b},
	{0x90d1, 0x610c},
	{0x90d2, 0x6110},
	{0x90d3, 0x6111},
	{0x90d4, 0x6112},
	{0x90d5, 0x6113},
	{0x90d6, 0x6114},
	{0x90d7, 0x6116},
	{0x90d8, 0x6117},
	{0x90d9, 0x6118},
	{0x90da, 0x6119},
	{0x90db, 0x611b},
	{0x90dc, 0x611c},
	{0x90dd, 0x611d},
	{0x90de, 0x611e},
	{0x90df, 0x6121},
	{0x90e0, 0x6122},
	{0x90e1, 0x6125},
	{0x90e2, 0x6128},
	{0x90e3, 0x6129},
	{0x90e4, 0x612a},
	{0x90e5, 0x612c},
	{0x90e6, 0x612d},
	{0x90e7, 0x612e},
	{0x90e8, 0x612f},
	{0x90e9, 0x6130},
	{0x90ea, 0x6131},
	{0x90eb, 0x6132},
	{0x90ec, 0x6133},
	{0x90ed, 0x6134},
	{0x90ee, 0x6135},
	{0x90ef, 0x6136},
	{0x90f0, 0x6137},
	{0x90f1, 0x6138},
	{0x90f2, 0x6139},
	{0x90f3, 0x613a},
	{0x90f4, 0x613b},
	{0x90f5, 0x613c},
	{0x90f6, 0x613d},
	{0x90f7, 0x613e},
	{0x90f8, 0x6140},
	{0x90f9, 0x6141},
	{0x90fa, 0x6142},
	{0x90fb, 0x6143},
	{0x90fc, 0x6144},
	{0x90fd, 0x6145},
	{0x90fe, 0x6146},
	{0x9140, 0x6147},
	{0x9141, 0x6149},
	{0x9142, 0x614b},
	{0x9143, 0x614d},
	{0x9144, 0x614f},
	{0x9145, 0x6150},
	{0x9146, 0x6152},
	{0x9147, 0x6153},
	{0x9148, 0x6154},
	{0x9149, 0x6156},
	{0x914a, 0x6157},
	{0x914b, 0x6158},
	{0x914c, 0x6159},
	{0x914d, 0x615a},
	{0x914e, 0x615b},
	{0x914f, 0x615c},
	{0x9150, 0x615e},
	{0x9151, 0x615f},
	{0x9152, 0x6160},
	{0x9153, 0x6161},
	{0x9154, 0x6163},
	{0x9155, 0x6164},
	{0x9156, 0x6165},
	{0x9157, 0x6166},
	{0x9158, 0x6169},
	{0x9159, 0x616a},
	{0x915a, 0x616b},
	{0x915b, 0x616c},
	{0x915c, 0x616d},
	{0x915d, 0x616e},
	{0x915e, 0x616f},
	{0x915f, 0x6171},
	{0x9160, 0x6172},
	{0x9161, 0x6173},
	{0x9162, 0x6174},
	{0x9163, 0x6176},
	{0x9164, 0x6178},
	{0x9165, 0x6179},
	{0x9166, 0x617a},
	{0x9167, 0x617b},
	{0x9168, 0x617c},
	{0x9169, 0x617d},
	{0x916a, 0x617e},
	{0x916b, 0x617f},
	{0x916c, 0x6180},
	{0x916d, 0x6181},
	{0x916e, 0x6182},
	{0x916f, 0x6183},
	{0x9170, 0x6184},
	{0x9171, 0x6185},
	{0x9172, 0x6186},
	{0x9173, 0x6187},
	{0x9174, 0x6188},
	{0x9175, 0x6189},
	{0x9176, 0x618a},
	{0x9177, 0x618c},
	{0x9178, 0x618d},
	{0x9179, 0x618f},
	{0x917a, 0x6190},
	{0x917b, 0x6191},
	{0x917c, 0x6192},
	{0x917d, 0x6193},
	{0x917e, 0x6195},
	{0x9180, 0x6196},
	{0x9181, 0x6197},
	{0x9182, 0x6198},
	{0x9183, 0x6199},
	{0x9184, 0x619a},
	{0x9185, 0x619b},
	{0x9186, 0x619c},
	{0x9187, 0x619e},
	{0x9188, 0x619f},
	{0x9189, 0x61a0},
	{0x918a, 0x61a1},
	{0x918b, 0x61a2},
	{0x918c, 0x61a3},
	{0x918d, 0x61a4},
	{0x918e, 0x61a5},
	{0x918f, 0x61a6},
	{0x9190, 0x61aa},
	{0x9191, 0x61ab},
	{0x9192, 0x61ad},
	{0x9193, 0x61ae},
	{0x9194, 0x61af},
	{0x9195, 0x61b0},
	{0x9196, 0x61b1},
	{0x9197, 0x61b2},
	{0x9198, 0x61b3},
	{0x9199, 0x61b4},
	{0x919a, 0x61b5},
	{0x919b, 0x61b6},
	{0x919c, 0x61b8},
	{0x919d, 0x61b9},
	{0x919e, 0x61ba},
	{0x919f, 0x61bb},
	{0x91a0, 0x61bc},
	{0x91a1, 0x61bd},
	{0x91a2, 0x61bf},
	{0x91a3, 0x61c0},
	{0x91a4, 0x61c1},
	{0x91a5, 0x61c3},
	{0x91a6, 0x61c4},
	{0x91a7, 0x61c5},
	{0x91a8, 0x61c6},
	{0x91a9, 0x61c7},
	{0x91aa, 0x61c9},
	{0x91ab, 0x61cc},
	{0x91ac, 0x61cd},
	{0x91ad, 0x61ce},
	{0x91ae, 0x61cf},
	{0x91af, 0x61d0},
	{0x91b0, 0x61d3},
	{0x91b1, 0x61d5},
	{0x91b2, 0x61d6},
	{0x91b3, 0x61d7},
	{0x91b4, 0x61d8},
	{0x91b5, 0x61d9},
	{0x91b6, 0x61da},
	{0x91b7, 0x61db},
	{0x91b8, 0x61dc},
	{0x91b9, 0x61dd},
	{0x91ba, 0x61de},
	{0x91bb, 0x61df},
	{0x91bc, 0x61e0},
	{0x91bd, 0x61e1},
	{0x91be, 0x61e2},
	{0x91bf, 0x61e3},
	{0x91c0, 0x61e4},
	{0x91c1, 0x61e5},
	{0x91c2, 0x61e7},
	{0x91c3, 0x61e8},
	{0x91c4, 0x61e9},
	{0x91c5, 0x61ea},
	{0x91c6, 0x61eb},
	{0x91c7, 0x61ec},
	{0x91c8, 0x61ed},
	{0x91c9, 0x61ee},
	{0x91ca, 0x61ef},
	{0x91cb, 0x61f0},
	{0x91cc, 0x61f1},
	{0x91cd, 0x61f2},
	{0x91ce, 0x61f3},
	{0x91cf, 0x61f4},
	{0x91d0, 0x61f6},
	{0x91d1, 0x61f7},
	{0x91d2, 0x61f8},
	{0x91d3, 0x61f9},
	{0x91d4, 0x61fa},
	{0x91d5, 0x61fb},
	{0x91d6, 0x61fc},
	{0x91d7, 0x61fd},
	{0x91d8, 0x61fe},
	{0x91d9, 0x6200},
	{0x91da, 0x6201},
	{0x91db, 0x6202},
	{0x91dc, 0x6203},
	{0x91dd, 0x6204},
	{0x91de, 0x6205},
	{0x91df, 0x6207},
	{0x91e0, 0x6209},
	{0x91e1, 0x6213},
	{0x91e2, 0x6214},
	{0x91e3, 0x6219},
	{0x91e4, 0x621c},
	{0x91e5, 0x621d},
	{0x91e6, 0x621e},
	{0x91e7, 0x6220},
	{0x91e8, 0x6223},
	{0x91e9, 0x6226},
	{0x91ea, 0x6227},
	{0x91eb, 0x6228},
	{0x91ec, 0x6229},
	{0x91ed, 0x622b},
	{0x91ee, 0x622d},
	{0x91ef, 0x622f},
	{0x91f0, 0x6230},
	{0x91f1, 0x6231},
	{0x91f2, 0x6232},
	{0x91f3, 0x6235},
	{0x91f4, 0x6236},
	{0x91f5, 0x6238},
	{0x91f6, 0x6239},
	{0x91f7, 0x623a},
	{0x91f8, 0x623b},
	{0x91f9, 0x623c},
	{0x91fa, 0x6242},
	{0x91fb, 0x6244},
	{0x91fc, 0x6245},
	{0x91fd, 0x6246},
	{0x91fe, 0x624a},
	{0x9240, 0x624f},
	{0x9241, 0x6250},
	{0x9242, 0x6255},
	{0x9243, 0x6256},
	{0x9244, 0x6257},
	{0x9245, 0x6259},
	{0x9246, 0x625a},
	{0x9247, 0x625c},
	{0x9248, 0x625d},
	{0x9249, 0x625e},
	{0x924a, 0x625f},
	{0x924b, 0x6260},
	{0x924c, 0x6261},
	{0x924d, 0x6262},
	{0x924e, 0x6264},
	{0x924f, 0x6265},
	{0x9250, 0x6268},
	{0x9251, 0x6271},
	{0x9252, 0x6272},
	{0x9253, 0x6274},
	{0x9254, 0x6275},
	{0x9255, 0x6277},
	{0x9256, 0x6278},
	{0x9257, 0x627a},
	{0x9258, 0x627b},
	{0x9259, 0x627d},
	{0x925a, 0x6281},
	{0x925b, 0x6282},
	{0x925c, 0x6283},
	{0x925d, 0x6285},
	{0x925e, 0x6286},
	{0x925f, 0x6287},
	{0x9260, 0x6288},
	{0x9261, 0x628b},
	{0x9262, 0x628c},
	{0x9263, 0x628d},
	{0x9264, 0x628e},
	{0x9265, 0x628f},
	{0x9266, 0x6290},
	{0x9267, 0x6294},
	{0x9268, 0x6299},
	{0x9269, 0x629c},
	{0x926a, 0x629d},
	{0x926b, 0x629e},
	{0x926c, 0x62a3},
	{0x926d, 0x62a6},
	{0x926e, 0x62a7},
	{0x926f, 0x62a9},
	{0x9270, 0x62aa},
	{0x9271, 0x62ad},
	{0x9272, 0x62ae},
	{0x9273, 0x62af},
	{0x9274, 0x62b0},
	{0x9275, 0x62b2},
	{0x9276, 0x62b3},
	{0x9277, 0x62b4},
	{0x9278, 0x62b6},
	{0x9279, 0x62b7},
	{0x927a, 0x62b8},
	{0x927b, 0x62ba},
	{0x927c, 0x62be},
	{0x927d, 0x62c0},
	{0x927e, 0x62c1},
	{0x9280, 0x62c3},
	{0x9281, 0x62cb},
	{0x9282, 0x62cf},
	{0x9283, 0x62d1},
	{0x9284, 0x62d5},
	{0x9285, 0x62dd},
	{0x9286, 0x62de},
	{0x9287, 0x62e0},
	{0x9288, 0x62e1},
	{0x9289, 0x62e4},
	{0x928a, 0x62ea},
	{0x928b, 0x62eb},
	{0x928c, 0x62f0},
	{0x928d, 0x62f2},
	{0x928e, 0x62f5},
	{0x928f, 0x62f8},
	{0x9290, 0x62f9},
	{0x9291, 0x62fa},
	{0x9292, 0x62fb},
	{0x9293, 0x6300},
	{0x9294, 0x6303},
	{0x9295, 0x6304},
	{0x9296, 0x6305},
	{0x9297, 0x6306},
	{0x9298, 0x630a},
	{0x9299, 0x630b},
	{0x929a, 0x630c},
	{0x929b, 0x630d},
	{0x929c, 0x630f},
	{0x929d, 0x6310},
	{0x929e, 0x6312},
	{0x929f, 0x6313},
	{0x92a0, 0x6314},
	{0x92a1, 0x6315},
	{0x92a2, 0x6317},
	{0x92a3, 0x6318},
	{0x92a4, 0x6319},
	{0x92a5, 0x631c},
	{0x92a6, 0x6326},
	{0x92a7, 0x6327},
	{0x92a8, 0x6329},
	{0x92a9, 0x632c},
	{0x92aa, 0x632d},
	{0x92ab, 0x632e},
	{0x92ac, 0x6330},
	{0x92ad, 0x6331},
	{0x92ae, 0x6333},
	{0x92af, 0x6334},
	{0x92b0, 0x6335},
	{0x92b1, 0x6336},
	{0x92b2, 0x6337},
	{0x92b3, 0x6338},
	{0x92b4, 0x633b},
	{0x92b5, 0x633c},
	{0x92b6, 0x633e},
	{0x92b7, 0x633f},
	{0x92b8, 0x6340},
	{0x92b9, 0x6341},
	{0x92ba, 0x6344},
	{0x92bb, 0x6347},
	{0x92bc, 0x6348},
	{0x92bd, 0x634a},
	{0x92be, 0x6351},
	{0x92bf, 0x6352},
	{0x92c0, 0x6353},
	{0x92c1, 0x6354},
	{0x92c2, 0x6356},
	{0x92c3, 0x6357},
	{0x92c4, 0x6358},
	{0x92c5, 0x6359},
	{0x92c6, 0x635a},
	{0x92c7, 0x635b},
	{0x92c8, 0x635c},
	{0x92c9, 0x635d},
	{0x92ca, 0x6360},
	{0x92cb, 0x6364},
	{0x92cc, 0x6365},
	{0x92cd, 0x6366},
	{0x92ce, 0x6368},
	{0x92cf, 0x636a},
	{0x92d0, 0x636b},
	{0x92d1, 0x636c},
	{0x92d2, 0x636f},
	{0x92d3, 0x6370},
	{0x92d4, 0x6372},
	{0x92d5, 0x6373},
	{0x92d6, 0x6374},
	{0x92d7, 0x6375},
	{0x92d8, 0x6378},
	{0x92d9, 0x6379},
	{0x92da, 0x637c},
	{0x92db, 0x637d},
	{0x92dc, 0x637e},
	{0x92dd, 0x637f},
	{0x92de, 0x6381},
	{0x92df, 0x6383},
	{0x92e0, 0x6384},
	{0x92e1, 0x6385},
	{0x92e2, 0x6386},
	{0x92e3, 0x638b},
	{0x92e4, 0x638d},
	{0x92e5, 0x6391},
	{0x92e6, 0x6393},
	{0x92e7, 0x6394},
	{0x92e8, 0x6395},
	{0x92e9, 0x6397},
	{0x92ea, 0x6399},
	{0x92eb, 0x639a},
	{0x92ec, 0x639b},
	{0x92ed, 0x639c},
	{0x92ee, 0x639d},
	{0x92ef, 0x639e},
	{0x92f0, 0x639f},
	{0x92f1, 0x63a1},
	{0x92f2, 0x63a4},
	{0x92f3, 0x63a6},
	{0x92f4, 0x63ab},
	{0x92f5, 0x63af},
	{0x92f6, 0x63b1},
	{0x92f7, 0x63b2},
	{0x92f8, 0x63b5},
	{0x92f9, 0x63b6},
	{0x92fa, 0x63b9},
	{0x92fb, 0x63bb},
	{0x92fc, 0x63bd},
	{0x92fd, 0x63bf},
	{0x92fe, 0x63c0},
	{0x9340, 0x63c1},
	{0x9341, 0x63c2},
	{0x9342, 0x63c3},
	{0x9343, 0x63c5},
	{0x9344, 0x63c7},
	{0x9345, 0x63c8},
	{0x9346, 0x63ca},
	{0x9347, 0x63cb},
	{0x9348, 0x63cc},
	{0x9349, 0x63d1},
	{0x934a, 0x63d3},
	{0x934b, 0x63d4},
	{0x934c, 0x63d5},
	{0x934d, 0x63d7},
	{0x934e, 0x63d8},
	{0x934f, 0x63d9},
	{0x9350, 0x63da},
	{0x9351, 0x63db},
	{0x9352, 0x63dc},
	{0x9353, 0x63dd},
	{0x9354, 0x63df},
	{0x9355, 0x63e2},
	{0x9356, 0x63e4},
	{0x9357, 0x63e5},
	{0x9358, 0x63e6},
	{0x9359, 0x63e7},
	{0x935a, 0x63e8},
	{0x935b, 0x63eb},
	{0x935c, 0x63ec},
	{0x935d, 0x63ee},
	{0x935e, 0x63ef},
	{0x935f, 0x63f0},
	{0x9360, 0x63f1},
	{0x9361, 0x63f3},
	{0x9362, 0x63f5},
	{0x9363, 0x63f7},
	{0x9364, 0x63f9},
	{0x9365, 0x63fa},
	{0x9366, 0x63fb},
	{0x9367, 0x63fc},
	{0x9368, 0x63fe},
	{0x9369, 0x6403},
	{0x936a, 0x6404},
	{0x936b, 0x6406},
	{0x936c, 0x6407},
	{0x936d, 0x6408},
	{0x936e, 0x6409},
	{0x936f, 0x640a},
	{0x9370, 0x640d},
	{0x9371, 0x640e},
	{0x9372, 0x6411},
	{0x9373, 0x6412},
	{0x9374, 0x6415},
	{0x9375, 0x6416},
	{0x9376, 0x6417},
	{0x9377, 0x6418},
	{0x9378, 0x6419},
	{0x9379, 0x641a},
	{0x937a, 0x641d},
	{0x937b, 0x641f},
	{0x937c, 0x6422},
	{0x937d, 0x6423},
	{0x937e, 0x6424},
	{0x9380, 0x6425},
	{0x9381, 0x6427},
	{0x9382, 0x6428},
	{0x9383, 0x6429},
	{0x9384, 0x642b},
	{0x9385, 0x642e},
	{0x9386, 0x642f},
	{0x9387, 0x6430},
	{0x9388, 0x6431},
	{0x9389, 0x6432},
	{0x938a, 0x6433},
	{0x938b, 0x6435},
	{0x938c, 0x6436},
	{0x938d, 0x6437},
	{0x938e, 0x6438},
	{0x938f, 0x6439},
	{0x9390, 0x643b},
	{0x9391, 0x643c},
	{0x9392, 0x643e},
	{0x9393, 0x6440},
	{0x9394, 0x6442},
	{0x9395, 0x6443},
	{0x9396, 0x6449},
	{0x9397, 0x644b},
	{0x9398, 0x644c},
	{0x9399, 0x644d},
	{0x939a, 0x644e},
	{0x939b, 0x644f},
	{0x939c, 0x6450},
	{0x939d, 0x6451},
	{0x939e, 0x6453},
	{0x939f, 0x6455},
	{0x93a0, 0x6456},
	{0x93a1, 0x6457},
	{0x93a2, 0x6459},
	{0x93a3, 0x645a},
	{0x93a4, 0x645b},
	{0x93a5, 0x645c},
	{0x93a6, 0x645d},
	{0x93a7, 0x645f},
	{0x93a8, 0x6460},
	{0x93a9, 0x6461},
	{0x93aa, 0x6462},
	{0x93ab, 0x6463},
	{0x93ac, 0x6464},
	{0x93ad, 0x6465},
	{0x93ae, 0x6466},
	{0x93af, 0x6468},
	{0x93b0, 0x646a},
	{0x93b1, 0x646b},
	{0x93b2, 0x646c},
	{0x93b3, 0x646e},
	{0x93b4, 0x646f},
	{0x93b5, 0x6470},
	{0x93b6, 0x6471},
	{0x93b7, 0x6472},
	{0x93b8, 0x6473},
	{0x93b9, 0x6474},
	{0x93ba, 0x6475},
	{0x93bb, 0x6476},
	{0x93bc, 0x6477},
	{0x93bd, 0x647b},
	{0x93be, 0x647c},
	{0x93bf, 0x647d},
	{0x93c0, 0x647e},
	{0x93c1, 0x647f},
	{0x93c2, 0x6480},
	{0x93c3, 0x6481},
	{0x93c4, 0x6483},
	{0x93c5, 0x6486},
	{0x93c6, 0x6488},
	{0x93c7, 0x6489},
	{0x93c8, 0x648a},
	{0x93c9, 0x648b},
	{0x93ca, 0x648c},
	{0x93cb, 0x648d},
	{0x93cc, 0x648e},
	{0x93cd, 0x648f},
	{0x93ce, 0x6490},
	{0x93cf, 0x6493},
	{0x93d0, 0x6494},
	{0x93d1, 0x6497},
	{0x93d2, 0x6498},
	{0x93d3, 0x649a},
	{0x93d4, 0x649b},
	{0x93d5, 0x649c},
	{0x93d6, 0x649d},
	{0x93d7, 0x649f},
	{0x93d8, 0x64a0},
	{0x93d9, 0x64a1},
	{0x93da, 0x64a2},
	{0x93db, 0x64a3},
	{0x93dc, 0x64a5},
	{0x93dd, 0x64a6},
	{0x93de, 0x64a7},
	{0x93df, 0x64a8},
	{0x93e0, 0x64aa},
	{0x93e1, 0x64ab},
	{0x93e2, 0x64af},
	{0x93e3, 0x64b1},
	{0x93e4, 0x64b2},
	{0x93e5, 0x64b3},
	{0x93e6, 0x64b4},
	{0x93e7, 0x64b6},
	{0x93e8, 0x64b9},
	{0x93e9, 0x64bb},
	{0x93ea, 0x64bd},
	{0x93eb, 0x64be},
	{0x93ec, 0x64bf},
	{0x93ed, 0x64c1},
	{0x93ee, 0x64c3},
	{0x93ef, 0x64c4},
	{0x93f0, 0x64c6},
	{0x93f1, 0x64c7},
	{0x93f2, 0x64c8},
	{0x93f3, 0x64c9},
	{0x93f4, 0x64ca},
	{0x93f5, 0x64cb},
	{0x93f6, 0x64cc},
	{0x93f7, 0x64cf},
	{0x93f8, 0x64d1},
	{0x93f9, 0x64d3},
	{0x93fa, 0x64d4},
	{0x93fb, 0x64d5},
	{0x93fc, 0x64d6},
	{0x93fd, 0x64d9},
	{0x93fe, 0x64da},
	{0x9440, 0x64db},
	{0x9441, 0x64dc},
	{0x9442, 0x64dd},
	{0x9443, 0x64df},
	{0x9444, 0x64e0},
	{0x9445, 0x64e1},
	{0x9446, 0x64e3},
	{0x9447, 0x64e5},
	{0x9448, 0x64e7},
	{0x9449, 0x64e8},
	{0x944a, 0x64e9},
	{0x944b, 0x64ea},
	{0x944c, 0x64eb},
	{0x944d, 0x64ec},
	{0x944e, 0x64ed},
	{0x944f, 0x64ee},
	{0x9450, 0x64ef},
	{0x9451, 0x64f0},
	{0x9452, 0x64f1},
	{0x9453, 0x64f2},
	{0x9454, 0x64f3},
	{0x9455, 0x64f4},
	{0x9456, 0x64f5},
	{0x9457, 0x64f6},
	{0x9458, 0x64f7},
	{0x9459, 0x64f8},
	{0x945a, 0x64f9},
	{0x945b, 0x64fa},
	{0x945c, 0x64fb},
	{0x945d, 0x64fc},
	{0x945e, 0x64fd},
	{0x945f, 0x64fe},
	{0x9460, 0x64ff},
	{0x9461, 0x6501},
	{0x9462, 0x6502},
	{0x9463, 0x6503},
	{0x9464, 0x6504},
	{0x9465, 0x6505},
	{0x9466, 0x6506},
	{0x9467, 0x6507},
	{0x9468, 0x6508},
	{0x9469, 0x650a},
	{0x946a, 0x650b},
	{0x946b, 0x650c},
	{0x946c, 0x650d},
	{0x946d, 0x650e},
	{0x946e, 0x650f},
	{0x946f, 0x6510},
	{0x9470, 0x6511},
	{0x9471, 0x6513},
	{0x9472, 0x6514},
	{0x9473, 0x6515},
	{0x9474, 0x6516},
	{0x9475, 0x6517},
	{0x9476, 0x6519},
	{0x9477, 0x651a},
	{0x9478, 0x651b},
	{0x9479, 0x651c},
	{0x947a, 0x651d},
	{0x947b, 0x651e},
	{0x947c, 0x651f},
	{0x947d, 0x6520},
	{0x947e, 0x6521},
	{0x9480, 0x6522},
	{0x9481, 0x6523},
	{0x9482, 0x6524},
	{0x9483, 0x6526},
	{0x9484, 0x6527},
	{0x9485, 0x6528},
	{0x9486, 0x6529},
	{0x9487, 0x652a},
	{0x9488, 0x652c},
	{0x9489, 0x652d},
	{0x948a, 0x6530},
	{0x948b, 0x6531},
	{0x948c, 0x6532},
	{0x948d, 0x6533},
	{0x948e, 0x6537},
	{0x948f, 0x653a},
	{0x9490, 0x653c},
	{0x9491, 0x653d},
	{0x9492, 0x6540},
	{0x9493, 0x6541},
	{0x9494, 0x6542},
	{0x9495, 0x6543},
	{0x9496, 0x6544},
	{0x9497, 0x6546},
	{0x9498, 0x6547},
	{0x9499, 0x654a},
	{0x949a, 0x654b},
	{0x949b, 0x654d},
	{0x949c, 0x654e},
	{0x949d, 0x6550},
	{0x949e, 0x6552},
	{0x949f, 0x6553},
	{0x94a0, 0x6554},
	{0x94a1, 0x6557},
	{0x94a2, 0x6558},
	{0x94a3, 0x655a},
	{0x94a4, 0x655c},
	{0x94a5, 0x655f},
	{0x94a6, 0x6560},
	{0x94a7, 0x6561},
	{0x94a8, 0x6564},
	{0x94a9, 0x6565},
	{0x94aa, 0x6567},
	{0x94ab, 0x6568},
	{0x94ac, 0x6569},
	{0x94ad, 0x656a},
	{0x94ae, 0x656d},
	{0x94af, 0x656e},
	{0x94b0, 0x656f},
	{0x94b1, 0x6571},
	{0x94b2, 0x6573},
	{0x94b3, 0x6575},
	{0x94b4, 0x6576},
	{0x94b5, 0x6578},
	{0x94b6, 0x6579},
	{0x94b7, 0x657a},
	{0x94b8, 0x657b},
	{0x94b9, 0x657c},
	{0x94ba, 0x657d},
	{0x94bb, 0x657e},
	{0x94bc, 0x657f},
	{0x94bd, 0x6580},
	{0x94be, 0x6581},
	{0x94bf, 0x6582},
	{0x94c0, 0x6583},
	{0x94c1, 0x6584},
	{0x94c2, 0x6585},
	{0x94c3, 0x6586},
	{0x94c4, 0x6588},
	{0x94c5, 0x6589},
	{0x94c6, 0x658a},
	{0x94c7, 0x658d},
	{0x94c8, 0x658e},
	{0x94c9, 0x658f},
	{0x94ca, 0x6592},
	{0x94cb, 0x6594},
	{0x94cc, 0x6595},
	{0x94cd, 0x6596},
	{0x94ce, 0x6598},
	{0x94cf, 0x659a},
	{0x94d0, 0x659d},
	{0x94d1, 0x659e},
	{0x94d2, 0x65a0},
	{0x94d3, 0x65a2},
	{0x94d4, 0x65a3},
	{0x94d5, 0x65a6},
	{0x94d6, 0x65a8},
	{0x94d7, 0x65aa},
	{0x94d8, 0x65ac},
	{0x94d9, 0x65ae},
	{0x94da, 0x65b1},
	{0x94db, 0x65b2},
	{0x94dc, 0x65b3},
	{0x94dd, 0x65b4},
	{0x94de, 0x65b5},
	{0x94df, 0x65b6},
	{0x94e0, 0x65b7},
	{0x94e1, 0x65b8},
	{0x94e2, 0x65ba},
	{0x94e3, 0x65bb},
	{0x94e4, 0x65be},
	{0x94e5, 0x65bf},
	{0x94e6, 0x65c0},
	{0x94e7, 0x65c2},
	{0x94e8, 0x65c7},
	{0x94e9, 0x65c8},
	{0x94ea, 0x65c9},
	{0x94eb, 0x65ca},
	{0x94ec, 0x65cd},
	{0x94ed, 0x65d0},
	{0x94ee, 0x65d1},
	{0x94ef, 0x65d3},
	{0x94f0, 0x65d4},
	{0x94f1, 0x65d5},
	{0x94f2, 0x65d8},
	{0x94f3, 0x65d9},
	{0x94f4, 0x65da},
	{0x94f5, 0x65db},
	{0x94f6, 0x65dc},
	{0x94f7, 0x65dd},
	{0x94f8, 0x65de},
	{0x94f9, 0x65df},
	{0x94fa, 0x65e1},
	{0x94fb, 0x65e3},
	{0x94fc, 0x65e4},
	{0x94fd, 0x65ea},
	{0x94fe, 0x65eb},
	{0x9540, 0x65f2},
	{0x9541, 0x65f3},
	{0x9542, 0x65f4},
	{0x9543, 0x65f5},
	{0x9544, 0x65f8},
	{0x9545, 0x65f9},
	{0x9546, 0x65fb},
	{0x9547, 0x65fc},
	{0x9548, 0x65fd},
	{0x9549, 0x65fe},
	{0x954a, 0x65ff},
	{0x954b, 0x6601},
	{0x954c, 0x6604},
	{0x954d, 0x6605},
	{0x954e, 0x6607},
	{0x954f, 0x6608},
	{0x9550, 0x6609},
	{0x9551, 0x660b},
	{0x9552, 0x660d},
	{0x9553, 0x6610},
	{0x9554, 0x6611},
	{0x9555, 0x6612},
	{0x9556, 0x6616},
	{0x9557, 0x6617},
	{0x9558, 0x6618},
	{0x9559, 0x661a},
	{0x955a, 0x661b},
	{0x955b, 0x661c},
	{0x955c, 0x661e},
	{0x955d, 0x6621},
	{0x955e, 0x6622},
	{0x955f, 0x6623},
	{0x9560, 0x6624},
	{0x9561, 0x6626},
	{0x9562, 0x6629},
	{0x9563, 0x662a},
	{0x9564, 0x662b},
	{0x9565, 0x662c},
	{0x9566, 0x662e},
	{0x9567, 0x6630},
	{0x9568, 0x6632},
	{0x9569, 0x6633},
	{0x956a, 0x6637},
	{0x956b, 0x6638},
	{0x956c, 0x6639},
	{0x956d, 0x663a},
	{0x956e, 0x663b},
	{0x956f, 0x663d},
	{0x9570, 0x663f},
	{0x9571, 0x6640},
	{0x9572, 0x6642},
	{0x9573, 0x6644},
	{0x9574, 0x6645},
	{0x9575, 0x6646},
	{0x9576, 0x6647},
	{0x9577, 0x6648},
	{0x9578, 0x6649},
	{0x9579, 0x664a},
	{0x957a, 0x664d},
	{0x957b, 0x664e},
	{0x957c, 0x6650},
	{0x957d, 0x6651},
	{0x957e, 0x6658},
	{0x9580, 0x6659},
	{0x9581, 0x665b},
	{0x9582, 0x665c},
	{0x9583, 0x665d},
	{0x9584, 0x665e},
	{0x9585, 0x6660},
	{0x9586, 0x6662},
	{0x9587, 0x6663},
	{0x9588, 0x6665},
	{0x9589, 0x6667},
	{0x958a, 0x6669},
	{0x958b, 0x666a},
	{0x958c, 0x666b},
	{0x958d, 0x666c},
	{0x958e, 0x666d},
	{0x958f, 0x6671},
	{0x9590, 0x6672},
	{0x9591, 0x6673},
	{0x9592, 0x6675},
	{0x9593, 0x6678},
	{0x9594, 0x6679},
	{0x9595, 0x667b},
	{0x9596, 0x667c},
	{0x9597, 0x667d},
	{0x9598, 0x667f},
	{0x9599, 0x6680},
	{0x959a, 0x6681},
	{0x959b, 0x6683},
	{0x959c, 0x6685},
	{0x959d, 0x6686},
	{0x959e, 0x6688},
	{0x959f, 0x6689},
	{0x95a0, 0x668a},
	{0x95a1, 0x668b},
	{0x95a2, 0x668d},
	{0x95a3, 0x668e},
	{0x95a4, 0x668f},
	{0x95a5, 0x6690},
	{0x95a6, 0x6692},
	{0x95a7, 0x6693},
	{0x95a8, 0x6694},
	{0x95a9, 0x6695},
	{0x95aa, 0x6698},
	{0x95ab, 0x6699},
	{0x95ac, 0x669a},
	{0x95ad, 0x669b},
	{0x95ae, 0x669c},
	{0x95af, 0x669e},
	{0x95b0, 0x669f},
	{0x95b1, 0x66a0},
	{0x95b2, 0x66a1},
	{0x95b3, 0x66a2},
	{0x95b4, 0x66a3},
	{0x95b5, 0x66a4},
	{0x95b6, 0x66a5},
	{0x95b7, 0x66a6},
	{0x95b8, 0x66a9},
	{0x95b9, 0x66aa},
	{0x95ba, 0x66ab},
	{0x95bb, 0x66ac},
	{0x95bc, 0x66ad},
	{0x95bd, 0x66af},
	{0x95be, 0x66b0},
	{0x95bf, 0x66b1},
	{0x95c0, 0x66b2},
	{0x95c1, 0x66b3},
	{0x95c2, 0x66b5},
	{0x95c3, 0x66b6},
	{0x95c4, 0x66b7},
	{0x95c5, 0x66b8},
	{0x95c6, 0x66ba},
	{0x95c7, 0x66bb},
	{0x95c8, 0x66bc},
	{0x95c9, 0x66bd},
	{0x95ca, 0x66bf},
	{0x95cb, 0x66c0},
	{0x95cc, 0x66c1},
	{0x95cd, 0x66c2},
	{0x95ce, 0x66c3},
	{0x95cf, 0x66c4},
	{0x95d0, 0x66c5},
	{0x95d1, 0x66c6},
	{0x95d2, 0x66c7},
	{0x95d3, 0x66c8},
	{0x95d4, 0x66c9},
	{0x95d5, 0x66ca},
	{0x95d6, 0x66cb},
	{0x95d7, 0x66cc},
	{0x95d8, 0x66cd},
	{0x95d9, 0x66ce},
	{0x95da, 0x66cf},
	{0x95db, 0x66d0},
	{0x95dc, 0x66d1},
	{0x95dd, 0x66d2},
	{0x95de, 0x66d3},
	{0x95df, 0x66d4},
	{0x95e0, 0x66d5},
	{0x95e1, 0x66d6},
	{0x95e2, 0x66d7},
	{0x95e3, 0x66d8},
	{0x95e4, 0x66da},
	{0x95e5, 0x66de},
	{0x95e6, 0x66df},
	{0x95e7, 0x66e0},
	{0x95e8, 0x66e1},
	{0x95e9, 0x66e2},
	{0x95ea, 0x66e3},
	{0x95eb, 0x66e4},
	{0x95ec, 0x66e5},
	{0x95ed, 0x66e7},
	{0x95ee, 0x66e8},
	{0x95ef, 0x66ea},
	{0x95f0, 0x66eb},
	{0x95f1, 0x66ec},
	{0x95f2, 0x66ed},
	{0x95f3, 0x66ee},
	{0x95f4, 0x66ef},
	{0x95f5, 0x66f1},
	{0x95f6, 0x66f5},
	{0x95f7, 0x66f6},
	{0x95f8, 0x66f8},
	{0x95f9, 0x66fa},
	{0x95fa, 0x66fb},
	{0x95fb, 0x66fd},
	{0x95fc, 0x6701},
	{0x95fd, 0x6702},
	{0x95fe, 0x6703},
	{0x9640, 0x6704},
	{0x9641, 0x6705},
	{0x9642, 0x6706},
	{0x9643, 0x6707},
	{0x9644, 0x670c},
	{0x9645, 0x670e},
	{0x9646, 0x670f},
	{0x9647, 0x6711},
	{0x9648, 0x6712},
	{0x9649, 0x6713},
	{0x964a, 0x6716},
	{0x964b, 0x6718},
	{0x964c, 0x6719},
	{0x964d, 0x671a},
	{0x964e, 0x671c},
	{0x964f, 0x671e},
	{0x9650, 0x6720},
	{0x9651, 0x6721},
	{0x9652, 0x6722},
	{0x9653, 0x6723},
	{0x9654, 0x6724},
	{0x9655, 0x6725},
	{0x9656, 0x6727},
	{0x9657, 0x6729},
	{0x9658, 0x672e},
	{0x9659, 0x6730},
	{0x965a, 0x6732},
	{0x965b, 0x6733},
	{0x965c, 0x6736},
	{0x965d, 0x6737},
	{0x965e, 0x6738},
	{0x965f, 0x6739},
	{0x9660, 0x673b},
	{0x9661, 0x673c},
	{0x9662, 0x673e},
	{0x9663, 0x673f},
	{0x9664, 0x6741},
	{0x9665, 0x6744},
	{0x9666, 0x6745},
	{0x9667, 0x6747},
	{0x9668, 0x674a},
	{0x9669, 0x674b},
	{0x966a, 0x674d},
	{0x966b, 0x6752},
	{0x966c, 0x6754},
	{0x966d, 0x6755},
	{0x966e, 0x6757},
	{0x966f, 0x6758},
	{0x9670, 0x6759},
	{0x9671, 0x675a},
	{0x9672, 0x675b},
	{0x9673, 0x675d},
	{0x9674, 0x6762},
	{0x9675, 0x6763},
	{0x9676, 0x6764},
	{0x9677, 0x6766},
	{0x9678, 0x6767},
	{0x9679, 0x676b},
	{0x967a, 0x676c},
	{0x967b, 0x676e},
	{0x967c, 0x6771},
	{0x967d, 0x6774},
	{0x967e, 0x6776},
	{0x9680, 0x6778},
	{0x9681, 0x6779},
	{0x9682, 0x677a},
	{0x9683, 0x677b},
	{0x9684, 0x677d},
	{0x9685, 0x6780},
	{0x9686, 0x6782},
	{0x9687, 0x6783},
	{0x9688, 0x6785},
	{0x9689, 0x6786},
	{0x968a, 0x6788},
	{0x968b, 0x678a},
	{0x968c, 0x678c},
	{0x968d, 0x678d},
	{0x968e, 0x678e},
	{0x968f, 0x678f},
	{0x9690, 0x6791},
	{0x9691, 0x6792},
	{0x9692, 0x6793},
	{0x9693, 0x6794},
	{0x9694, 0x6796},
	{0x9695, 0x6799},
	{0x9696, 0x679b},
	{0x9697, 0x679f},
	{0x9698, 0x67a0},
	{0x9699, 0x67a1},
	{0x969a, 0x67a4},
	{0x969b, 0x67a6},
	{0x969c, 0x67a9},
	{0x969d, 0x67ac},
	{0x969e, 0x67ae},
	{0x969f, 0x67b1},
	{0x96a0, 0x67b2},
	{0x96a1, 0x67b4},
	{0x96a2, 0x67b9},
	{0x96a3, 0x67ba},
	{0x96a4, 0x67bb},
	{0x96a5, 0x67bc},
	{0x96a6, 0x67bd},
	{0x96a7, 0x67be},
	{0x96a8, 0x67bf},
	{0x96a9, 0x67c0},
	{0x96aa, 0x67c2},
	{0x96ab, 0x67c5},
	{0x96ac, 0x67c6},
	{0x96ad, 0x67c7},
	{0x96ae, 0x67c8},
	{0x96af, 0x67c9},
	{0x96b0, 0x67ca},
	{0x96b1, 0x67cb},
	{0x96b2, 0x67cc},
	{0x96b3, 0x67cd},
	{0x96b4, 0x67ce},
	{0x96b5, 0x67d5},
	{0x96b6, 0x67d6},
	{0x96b7, 0x67d7},
	{0x96b8, 0x67db},
	{0x96b9, 0x67df},
	{0x96ba, 0x67e1},
	{0x96bb, 0x67e3},
	{0x96bc, 0x67e4},
	{0x96bd, 0x67e6},
	{0x96be, 0x67e7},
	{0x96bf, 0x67e8},
	{0x96c0, 0x67ea},
	{0x96c1, 0x67eb},
	{0x96c2, 0x67ed},
	{0x96c3, 0x67ee},
	{0x96c4, 0x67f2},
	{0x96c5, 0x67f5},
	{0x96c6, 0x67f6},
	{0x96c7, 0x67f7},
	{0x96c8, 0x67f8},
	{0x96c9, 0x67f9},
	{0x96ca, 0x67fa},
	{0x96cb, 0x67fb},
	{0x96cc, 0x67fc},
	{0x96cd, 0x67fe},
	{0x96ce, 0x6801},
	{0x96cf, 0x6802},
	{0x96d0, 0x6803},
	{0x96d1, 0x6804},
	{0x96d2, 0x6806},
	{0x96d3, 0x680d},
	{0x96d4, 0x6810},
	{0x96d5, 0x6812},
	{0x96d6, 0x6814},
	{0x96d7, 0x6815},
	{0x96d8, 0x6818},
	{0x96d9, 0x6819},
	{0x96da, 0x681a},
	{0x96db, 0x681b},
	{0x96dc, 0x681c},
	{0x96dd, 0x681e},
	{0x96de, 0x681f},
	{0x96df, 0x6820},
	{0x96e0, 0x6822},
	{0x96e1, 0x6823},
	{0x96e2, 0x6824},
	{0x96e3, 0x6825},
	{0x96e4, 0x6826},
	{0x96e5, 0x6827},
	{0x96e6, 0x6828},
	{0x96e7, 0x682b},
	{0x96e8, 0x682c},
	{0x96e9, 0x682d},
	{0x96ea, 0x682e},
	{0x96eb, 0x682f},
	{0x96ec, 0x6830},
	{0x96ed, 0x6831},
	{0x96ee, 0x6834},
	{0x96ef, 0x6835},
	{0x96f0, 0x6836},
	{0x96f1, 0x683a},
	{0x96f2, 0x683b},
	{0x96f3, 0x683f},
	{0x96f4, 0x6847},
	{0x96f5, 0x684b},
	{0x96f6, 0x684d},
	{0x96f7, 0x684f},
	{0x96f8, 0x6852},
	{0x96f9, 0x6856},
	{0x96fa, 0x6857},
	{0x96fb, 0x6858},
	{0x96fc, 0x6859},
	{0x96fd, 0x685a},
	{0x96fe, 0x685b},
	{0x9740, 0x685c},
	{0x9741, 0x685d},
	{0x9742, 0x685e},
	{0x9743, 0x685f},
	{0x9744, 0x686a},
	{0x9745, 0x686c},
	{0x9746, 0x686d},
	{0x9747, 0x686e},
	{0x9748, 0x686f},
	{0x9749, 0x6870},
	{0x974a, 0x6871},
	{0x974b, 0x6872},
	{0x974c, 0x6873},
	{0x974d, 0x6875},
	{0x974e, 0x6878},
	{0x974f, 0x6879},
	{0x9750, 0x687a},
	{0x9751, 0x687b},
	{0x9752, 0x687c},
	{0x9753, 0x687d},
	{0x9754, 0x687e},
	{0x9755, 0x687f},
	{0x9756, 0x6880},
	{0x9757, 0x6882},
	{0x9758, 0x6884},
	{0x9759, 0x6887},
	{0x975a, 0x6888},
	{0x975b, 0x6889},
	{0x975c, 0x688a},
	{0x975d, 0x688b},
	{0x975e, 0x688c},
	{0x975f, 0x688d},
	{0x9760, 0x688e},
	{0x9761, 0x6890},
	{0x9762, 0x6891},
	{0x9763, 0x6892},
	{0x9764, 0x6894},
	{0x9765, 0x6895},
	{0x9766, 0x6896},
	{0x9767, 0x6898},
	{0x9768, 0x6899},
	{0x9769, 0x689a},
	{0x976a, 0x689b},
	{0x976b, 0x689c},
	{0x976c, 0x689d},
	{0x976d, 0x689e},
	{0x976e, 0x689f},
	{0x976f, 0x68a0},
	{0x9770, 0x68a1},
	{0x9771, 0x68a3},
	{0x9772, 0x68a4},
	{0x9773, 0x68a5},
	{0x9774, 0x68a9},
	{0x9775, 0x68aa},
	{0x9776, 0x68ab},
	{0x9777, 0x68ac},
	{0x9778, 0x68ae},
	{0x9779, 0x68b1},
	{0x977a, 0x68b2},
	{0x977b, 0x68b4},
	{0x977c, 0x68b6},
	{0x977d, 0x68b7},
	{0x977e, 0x68b8},
	{0x9780, 0x68b9},
	{0x9781, 0x68ba},
	{0x9782, 0x68bb},
	{0x9783, 0x68bc},
	{0x9784, 0x68bd},
	{0x9785, 0x68be},
	{0x9786, 0x68bf},
	{0x9787, 0x68c1},
	{0x9788, 0x68c3},
	{0x9789, 0x68c4},
	{0x978a, 0x68c5},
	{0x978b, 0x68c6},
	{0x978c, 0x68c7},
	{0x978d, 0x68c8},
	{0x978e, 0x68ca},
	{0x978f, 0x68cc},
	{0x9790, 0x68ce},
	{0x9791, 0x68cf},
	{0x9792, 0x68d0},
	{0x9793, 0x68d1},
	{0x9794, 0x68d3},
	{0x9795, 0x68d4},
	{0x9796, 0x68d6},
	{0x9797, 0x68d7},
	{0x9798, 0x68d9},
	{0x9799, 0x68db},
	{0x979a, 0x68dc},
	{0x979b, 0x68dd},
	{0x979c, 0x68de},
	{0x979d, 0x68df},
	{0x979e, 0x68e1},
	{0x979f, 0x68e2},
	{0x97a0, 0x68e4},
	{0x97a1, 0x68e5},
	{0x97a2, 0x68e6},
	{0x97a3, 0x68e7},
	{0x97a4, 0x68e8},
	{0x97a5, 0x68e9},
	{0x97a6, 0x68ea},
	{0x97a7, 0x68eb},
	{0x97a8, 0x68ec},
	{0x97a9, 0x68ed},
	{0x97aa, 0x68ef},
	{0x97ab, 0x68f2},
	{0x97ac, 0x68f3},
	{0x97ad, 0x68f4},
	{0x97ae, 0x68f6},
	{0x97af, 0x68f7},
	{0x97b0, 0x68f8},
	{0x97b1, 0x68fb},
	{0x97b2, 0x68fd},
	{0x97b3, 0x68fe},
	{0x97b4, 0x68ff},
	{0x97b5, 0x6900},
	{0x97b6, 0x6902},
	{0x97b7, 0x6903},
	{0x97b8, 0x6904},
	{0x97b9, 0x6906},
	{0x97ba, 0x6907},
	{0x97bb, 0x6908},
	{0x97bc, 0x6909},
	{0x97bd, 0x690a},
	{0x97be, 0x690c},
	{0x97bf, 0x690f},
	{0x97c0, 0x6911},
	{0x97c1, 0x6913},
	{0x97c2, 0x6914},
	{0x97c3, 0x6915},
	{0x97c4, 0x6916},
	{0x97c5, 0x6917},
	{0x97c6, 0x6918},
	{0x97c7, 0x6919},
	{0x97c8, 0x691a},
	{0x97c9, 0x691b},
	{0x97ca, 0x691c},
	{0x97cb, 0x691d},
	{0x97cc, 0x691e},
	{0x97cd, 0x6921},
	{0x97ce, 0x6922},
	{0x97cf, 0x6923},
	{0x97d0, 0x6925},
	{0x97d1, 0x6926},
	{0x97d2, 0x6927},
	{0x97d3, 0x6928},
	{0x97d4, 0x6929},
	{0x97d5, 0x692a},
	{0x97d6, 0x692b},
	{0x97d7, 0x692c},
	{0x97d8, 0x692e},
	{0x97d9, 0x692f},
	{0x97da, 0x6931},
	{0x97db, 0x6932},
	{0x97dc, 0x6933},
	{0x97dd, 0x6935},
	{0x97de, 0x6936},
	{0x97df, 0x6937},
	{0x97e0, 0x6938},
	{0x97e1, 0x693a},
	{0x97e2, 0x693b},
	{0x97e3, 0x693c},
	{0x97e4, 0x693e},
	{0x97e5, 0x6940},
	{0x97e6, 0x6941},
	{0x97e7, 0x6943},
	{0x97e8, 0x6944},
	{0x97e9, 0x6945},
	{0x97ea, 0x6946},
	{0x97eb, 0x6947},
	{0x97ec, 0x6948},
	{0x97ed, 0x6949},
	{0x97ee, 0x694a},
	{0x97ef, 0x694b},
	{0x97f0, 0x694c},
	{0x97f1, 0x694d},
	{0x97f2, 0x694e},
	{0x97f3, 0x694f},
	{0x97f4, 0x6950},
	{0x97f5, 0x6951},
	{0x97f6, 0x6952},
	{0x97f7, 0x6953},
	{0x97f8, 0x6955},
	{0x97f9, 0x6956},
	{0x97fa, 0x6958},
	{0x97fb, 0x6959},
	{0x97fc, 0x695b},
	{0x97fd, 0x695c},
	{0x97fe, 0x695f},
	{0x9840, 0x6961},
	{0x9841, 0x6962},
	{0x9842, 0x6964},
	{0x9843, 0x6965},
	{0x9844, 0x6967},
	{0x9845, 0x6968},
	{0x9846, 0x6969},
	{0x9847, 0x696a},
	{0x9848, 0x696c},
	{0x9849, 0x696d},
	{0x984a, 0x696f},
	{0x984b, 0x6970},
	{0x984c, 0x6972},
	{0x984d, 0x6973},
	{0x984e, 0x6974},
	{0x984f, 0x6975},
	{0x9850, 0x6976},
	{0x9851, 0x697a},
	{0x9852, 0x697b},
	{0x9853, 0x697d},
	{0x9854, 0x697e},
	{0x9855, 0x697f},
	{0x9856, 0x6981},
	{0x9857, 0x6983},
	{0x9858, 0x6985},
	{0x9859, 0x698a},
	{0x985a, 0x698b},
	{0x985b, 0x698c},
	{0x985c, 0x698e},
	{0x985d, 0x698f},
	{0x985e, 0x6990},
	{0x985f, 0x6991},
	{0x9860, 0x6992},
	{0x9861, 0x6993},
	{0x9862, 0x6996},
	{0x9863, 0x6997},
	{0x9864, 0x6999},
	{0x9865, 0x699a},
	{0x9866, 0x699d},
	{0x9867, 0x699e},
	{0x9868, 0x699f},
	{0x9869, 0x69a0},
	{0x986a, 0x69a1},
	{0x986b, 0x69a2},
	{0x986c, 0x69a3},
	{0x986d, 0x69a4},
	{0x986e, 0x69a5},
	{0x986f, 0x69a6},
	{0x9870, 0x69a9},
	{0x9871, 0x69aa},
	{0x9872, 0x69ac},
	{0x9873, 0x69ae},
	{0x9874, 0x69af},
	{0x9875, 0x69b0},
	{0x9876, 0x69b2},
	{0x9877, 0x69b3},
	{0x9878, 0x69b5},
	{0x9879, 0x69b6},
	{0x987a, 0x69b8},
	{0x987b, 0x69b9},
	{0x987c, 0x69ba},
	{0x987d, 0x69bc},
	{0x987e, 0x69bd},
	{0x9880, 0x69be},
	{0x9881, 0x69bf},
	{0x9882, 0x69c0},
	{0x9883, 0x69c2},
	{0x9884, 0x69c3},
	{0x9885, 0x69c4},
	{0x9886, 0x69c5},
	{0x9887, 0x69c6},
	{0x9888, 0x69c7},
	{0x9889, 0x69c8},
	{0x988a, 0x69c9},
	{0x988b, 0x69cb},
	{0x988c, 0x69cd},
	{0x988d, 0x69cf},
	{0x988e, 0x69d1},
	{0x988f, 0x69d2},
	{0x9890, 0x69d3},
	{0x9891, 0x69d5},
	{0x9892, 0x69d6},
	{0x9893, 0x69d7},
	{0x9894, 0x69d8},
	{0x9895, 0x69d9},
	{0x9896, 0x69da},
	{0x9897, 0x69dc},
	{0x9898, 0x69dd},
	{0x9899, 0x69de},
	{0x989a, 0x69e1},
	{0x989b, 0x69e2},
	{0x989c, 0x69e3},
	{0x989d, 0x69e4},
	{0x989e, 0x69e5},
	{0x989f, 0x69e6},
	{0x98a0, 0x69e7},
	{0x98a1, 0x69e8},
	{0x98a2, 0x69e9},
	{0x98a3, 0x69ea},
	{0x98a4, 0x69eb},
	{0x98a5, 0x69ec},
	{0x98a6, 0x69ee},
	{0x98a7, 0x69ef},
	{0x98a8, 0x69f0},
	{0x98a9, 0x69f1},
	{0x98aa, 0x69f3},
	{0x98ab, 0x69f4},
	{0x98ac, 0x69f5},
	{0x98ad, 0x69f6},
	{0x98ae, 0x69f7},
	{0x98af, 0x69f8},
	{0x98b0, 0x69f9},
	{0x98b1, 0x69fa},
	{0x98b2, 0x69fb},
	{0x98b3, 0x69fc},
	{0x98b4, 0x69fe},
	{0x98b5, 0x6a00},
	{0x98b6, 0x6a01},
	{0x98b7, 0x6a02},
	{0x98b8, 0x6a03},
	{0x98b9, 0x6a04},
	{0x98ba, 0x6a05},
	{0x98bb, 0x6a06},
	{0x98bc, 0x6a07},
	{0x98bd, 0x6a08},
	{0x98be, 0x6a09},
	{0x98bf, 0x6a0b},
	{0x98c0, 0x6a0c},
	{0x98c1, 0x6a0d},
	{0x98c2, 0x6a0e},
	{0x98c3, 0x6a0f},
	{0x98c4, 0x6a10},
	{0x98c5, 0x6a11},
	{0x98c6, 0x6a12},
	{0x98c7, 0x6a13},
	{0x98c8, 0x6a14},
	{0x98c9, 0x6a15},
	{0x98ca, 0x6a16},
	{0x98cb, 0x6a19},
	{0x98cc, 0x6a1a},
	{0x98cd, 0x6a1b},
	{0x98ce, 0x6a1c},
	{0x98cf, 0x6a1d},
	{0x98d0, 0x6a1e},
	{0x98d1, 0x6a20},
	{0x98d2, 0x6a22},
	{0x98d3, 0x6a23},
	{0x98d4, 0x6a24},
	{0x98d5, 0x6a25},
	{0x98d6, 0x6a26},
	{0x98d7, 0x6a27},
	{0x98d8, 0x6a29},
	{0x98d9, 0x6a2b},
	{0x98da, 0x6a2c},
	{0x98db, 0x6a2d},
	{0x98dc, 0x6a2e},
	{0x98dd, 0x6a30},
	{0x98de, 0x6a32},
	{0x98df, 0x6a33},
	{0x98e0, 0x6a34},
	{0x98e1, 0x6a36},
	{0x98e2, 0x6a37},
	{0x98e3, 0x6a38},
	{0x98e4, 0x6a39},
	{0x98e5, 0x6a3a},
	{0x98e6, 0x6a3b},
	{0x98e7, 0x6a3c},
	{0x98e8, 0x6a3f},
	{0x98e9, 0x6a40},
	{0x98ea, 0x6a41},
	{0x98eb, 0x6a42},
	{0x98ec, 0x6a43},
	{0x98ed, 0x6a45},
	{0x98ee, 0x6a46},
	{0x98ef, 0x6a48},
	{0x98f0, 0x6a49},
	{0x98f1, 0x6a4a},
	{0x98f2, 0x6a4b},
	{0x98f3, 0x6a4c},
	{0x98f4, 0x6a4d},
	{0x98f5, 0x6a4e},
	{0x98f6, 0x6a4f},
	{0x98f7, 0x6a51},
	{0x98f8, 0x6a52},
	{0x98f9, 0x6a53},
	{0x98fa, 0x6a54},
	{0x98fb, 0x6a55},
	{0x98fc, 0x6a56},
	{0x98fd, 0x6a57},
	{0x98fe, 0x6a5a},
	{0x9940, 0x6a5c},
	{0x9941, 0x6a5d},
	{0x9942, 0x6a5e},
	{0x9943, 0x6a5f},
	{0x9944, 0x6a60},
	{0x9945, 0x6a62},
	{0x9946, 0x6a63},
	{0x9947, 0x6a64},
	{0x9948, 0x6a66},
	{0x9949, 0x6a67},
	{0x994a, 0x6a68},
	{0x994b, 0x6a69},
	{0x994c, 0x6a6a},
	{0x994d, 0x6a6b},
	{0x994e, 0x6a6c},
	{0x994f, 0x6a6d},
	{0x9950, 0x6a6e},
	{0x9951, 0x6a6f},
	{0x9952, 0x6a70},
	{0x9953, 0x6a72},
	{0x9954, 0x6a73},
	{0x9955, 0x6a74},
	{0x9956, 0x6a75},
	{0x9957, 0x6a76},
	{0x9958, 0x6a77},
	{0x9959, 0x6a78},
	{0x995a, 0x6a7a},
	{0x995b, 0x6a7b},
	{0x995c, 0x6a7d},
	{0x995d, 0x6a7e},
	{0x995e, 0x6a7f},
	{0x995f, 0x6a81},
	{0x9960, 0x6a82},
	{0x9961, 0x6a83},
	{0x9962, 0x6a85},
	{0x9963, 0x6a86},
	{0x9964, 0x6a87},
	{0x9965, 0x6a88},
	{0x9966, 0x6a89},
	{0x9967, 0x6a8a},
	{0x9968, 0x6a8b},
	{0x9969, 0x6a8c},
	{0x996a, 0x6a8d},
	{0x996b, 0x6a8f},
	{0x996c, 0x6a92},
	{0x996d, 0x6a93},
	{0x996e, 0x6a94},
	{0x996f, 0x6a95},
	{0x9970, 0x6a96},
	{0x9971, 0x6a98},
	{0x9972, 0x6a99},
	{0x9973, 0x6a9a},
	{0x9974, 0x6a9b},
	{0x9975, 0x6a9c},
	{0x9976, 0x6a9d},
	{0x9977, 0x6a9e},
	{0x9978, 0x6a9f},
	{0x9979, 0x6aa1},
	{0x997a, 0x6aa2},
	{0x997b, 0x6aa3},
	{0x997c, 0x6aa4},
	{0x997d, 0x6aa5},
	{0x997e, 0x6aa6},
	{0x9980, 0x6aa7},
	{0x9981, 0x6aa8},
	{0x9982, 0x6aaa},
	{0x9983, 0x6aad},
	{0x9984, 0x6aae},
	{0x9985, 0x6aaf},
	{0x9986, 0x6ab0},
	{0x9987, 0x6ab1},
	{0x9988, 0x6ab2},
	{0x9989, 0x6ab3},
	{0x998a, 0x6ab4},
	{0x998b, 0x6ab5},
	{0x998c, 0x6ab6},
	{0x998d, 0x6ab7},
	{0x998e, 0x6ab8},
	{0x998f, 0x6ab9},
	{0x9990, 0x6aba},
	{0x9991, 0x6abb},
	{0x9992, 0x6abc},
	{0x9993, 0x6abd},
	{0x9994, 0x6abe},
	{0x9995, 0x6abf},
	{0x9996, 0x6ac0},
	{0x9997, 0x6ac1},
	{0x9998, 0x6ac2},
	{0x9999, 0x6ac3},
	{0x999a, 0x6ac4},
	{0x999b, 0x6ac5},
	{0x999c, 0x6ac6},
	{0x999d, 0x6ac7},
	{0x999e, 0x6ac8},
	{0x999f, 0x6ac9},
	{0x99a0, 0x6aca},
	{0x99a1, 0x6acb},
	{0x99a2, 0x6acc},
	{0x99a3, 0x6acd},
	{0x99a4, 0x6ace},
	{0x99a5, 0x6acf},
	{0x99a6, 0x6ad0},
	{0x99a7, 0x6ad1},
	{0x99a8, 0x6ad2},
	{0x99a9, 0x6ad3},
	{0x99aa, 0x6ad4},
	{0x99ab, 0x6ad5},
	{0x99ac, 0x6ad6},
	{0x99ad, 0x6ad7},
	{0x99ae, 0x6ad8},
	{0x99af, 0x6ad9},
	{0x99b0, 0x6ada},
	{0x99b1, 0x6adb},
	{0x99b2, 0x6adc},
	{0x99b3, 0x6add},
	{0x99b4, 0x6ade},
	{0x99b5, 0x6adf},
	{0x99b6, 0x6ae0},
	{0x99b7, 0x6ae1},
	{0x99b8, 0x6ae2},
	{0x99b9, 0x6ae3},
	{0x99ba, 0x6ae4},
	{0x99bb, 0x6ae5},
	{0x99bc, 0x6ae6},
	{0x99bd, 0x6ae7},
	{0x99be, 0x6ae8},
	{0x99bf, 0x6ae9},
	{0x99c0, 0x6aea},
	{0x99c1, 0x6aeb},
	{0x99c2, 0x6aec},
	{0x99c3, 0x6aed},
	{0x99c4, 0x6aee},
	{0x99c5, 0x6aef},
	{0x99c6, 0x6af0},
	{0x99c7, 0x6af1},
	{0x99c8, 0x6af2},
	{0x99c9, 0x6af3},
	{0x99ca, 0x6af4},
	{0x99cb, 0x6af5},
	{0x99cc, 0x6af6},
	{0x99cd, 0x6af7},
	{0x99ce, 0x6af8},
	{0x99cf, 0x6af9},
	{0x99d0, 0x6afa},
	{0x99d1, 0x6afb},
	{0x99d2, 0x6afc},
	{0x99d3, 0x6afd},
	{0x99d4, 0x6afe},
	{0x99d5, 0x6aff},
	{0x99d6, 0x6b00},
	{0x99d7, 0x6b01},
	{0x99d8, 0x6b02},
	{0x99d9, 0x6b03},
	{0x99da, 0x6b04},
	{0x99db, 0x6b05},
	{0x99dc, 0x6b06},
	{0x99dd, 0x6b07},
	{0x99de, 0x6b08},
	{0x99df, 0x6b09},
	{0x99e0, 0x6b0a},
	{0x99e1, 0x6b0b},
	{0x99e2, 0x6b0c},
	{0x99e3, 0x6b0d},
	{0x99e4, 0x6b0e},
	{0x99e5, 0x6b0f},
	{0x99e6, 0x6b10},
	{0x99e7, 0x6b11},
	{0x99e8, 0x6b12},
	{0x99e9, 0x6b13},
	{0x99ea, 0x6b14},
	{0x99eb, 0x6b15},
	{0x99ec, 0x6b16},
	{0x99ed, 0x6b17},
	{0x99ee, 0x6b18},
	{0x99ef, 0x6b19},
	{0x99f0, 0x6b1a},
	{0x99f1, 0x6b1b},
	{0x99f2, 0x6b1c},
	{0x99f3, 0x6b1d},
	{0x99f4, 0x6b1e},
	{0x99f5, 0x6b1f},
	{0x99f6, 0x6b25},
	{0x99f7, 0x6b26},
	{0x99f8, 0x6b28},
	{0x99f9, 0x6b29},
	{0x99fa, 0x6b2a},
	{0x99fb, 0x6b2b},
	{0x99fc, 0x6b2c},
	{0x99fd, 0x6b2d},
	{0x99fe, 0x6b2e},
	{0x9a40, 0x6b2f},
	{0x9a41, 0x6b30},
	{0x9a42, 0x6b31},
	{0x9a43, 0x6b33},
	{0x9a44, 0x6b34},
	{0x9a45, 0x6b35},
	{0x9a46, 0x6b36},
	{0x9a47, 0x6b38},
	{0x9a48, 0x6b3b},
	{0x9a49, 0x6b3c},
	{0x9a4a, 0x6b3d},
	{0x9a4b, 0x6b3f},
	{0x9a4c, 0x6b40},
	{0x9a4d, 0x6b41},
	{0x9a4e, 0x6b42},
	{0x9a4f, 0x6b44},
	{0x9a50, 0x6b45},
	{0x9a51, 0x6b48},
	{0x9a52, 0x6b4a},
	{0x9a53, 0x6b4b},
	{0x9a54, 0x6b4d},
	{0x9a55, 0x6b4e},
	{0x9a56, 0x6b4f},
	{0x9a57, 0x6b50},
	{0x9a58, 0x6b51},
	{0x9a59, 0x6b52},
	{0x9a5a, 0x6b53},
	{0x9a5b, 0x6b54},
	{0x9a5c, 0x6b55},
	{0x9a5d, 0x6b56},
	{0x9a5e, 0x6b57},
	{0x9a5f, 0x6b58},
	{0x9a60, 0x6b5a},
	{0x9a61, 0x6b5b},
	{0x9a62, 0x6b5c},
	{0x9a63, 0x6b5d},
	{0x9a64, 0x6b5e},
	{0x9a65, 0x6b5f},
	{0x9a66, 0x6b60},
	{0x9a67, 0x6b61},
	{0x9a68, 0x6b68},
	{0x9a69, 0x6b69},
	{0x9a6a, 0x6b6b},
	{0x9a6b, 0x6b6c},
	{0x9a6c, 0x6b6d},
	{0x9a6d, 0x6b6e},
	{0x9a6e, 0x6b6f},
	{0x9a6f, 0x6b70},
	{0x9a70, 0x6b71},
	{0x9a71, 0x6b72},
	{0x9a72, 0x6b73},
	{0x9a73, 0x6b74},
	{0x9a74, 0x6b75},
	{0x9a75, 0x6b76},
	{0x9a76, 0x6b77},
	{0x9a77, 0x6b78},
	{0x9a78, 0x6b7a},
	{0x9a79, 0x6b7d},
	{0x9a7a, 0x6b7e},
	{0x9a7b, 0x6b7f},
	{0x9a7c, 0x6b80},
	{0x9a7d, 0x6b85},
	{0x9a7e, 0x6b88},
	{0x9a80, 0x6b8c},
	{0x9a81, 0x6b8e},
	{0x9a82, 0x6b8f},
	{0x9a83, 0x6b90},
	{0x9a84, 0x6b91},
	{0x9a85, 0x6b94},
	{0x9a86, 0x6b95},
	{0x9a87, 0x6b97},
	{0x9a88, 0x6b98},
	{0x9a89, 0x6b99},
	{0x9a8a, 0x6b9c},
	{0x9a8b, 0x6b9d},
	{0x9a8c, 0x6b9e},
	{0x9a8d, 0x6b9f},
	{0x9a8e, 0x6ba0},
	{0x9a8f, 0x6ba2},
	{0x9a90, 0x6ba3},
	{0x9a91, 0x6ba4},
	{0x9a92, 0x6ba5},
	{0x9a93, 0x6ba6},
	{0x9a94, 0x6ba7},
	{0x9a95, 0x6ba8},
	{0x9a96, 0x6ba9},
	{0x9a97, 0x6bab},
	{0x9a98, 0x6bac},
	{0x9a99, 0x6bad},
	{0x9a9a, 0x6bae},
	{0x9a9b, 0x6baf},
	{0x9a9c, 0x6bb0},
	{0x9a9d, 0x6bb1},
	{0x9a9e, 0x6bb2},
	{0x9a9f, 0x6bb6},
	{0x9aa0, 0x6bb8},
	{0x9aa1, 0x6bb9},
	{0x9aa2, 0x6bba},
	{0x9aa3, 0x6bbb},
	{0x9aa4, 0x6bbc},
	{0x9aa5, 0x6bbd},
	{0x9aa6, 0x6bbe},
	{0x9aa7, 0x6bc0},
	{0x9aa8, 0x6bc3},
	{0x9aa9, 0x6bc4},
	{0x9aaa, 0x6bc6},
	{0x9aab, 0x6bc7},
	{0x9aac, 0x6bc8},
	{0x9aad, 0x6bc9},
	{0x9aae, 0x6bca},
	{0x9aaf, 0x6bcc},
	{0x9ab0, 0x6bce},
	{0x9ab1, 0x6bd0},
	{0x9ab2, 0x6bd1},
	{0x9ab3, 0x6bd8},
	{0x9ab4, 0x6bda},
	{0x9ab5, 0x6bdc},
	{0x9ab6, 0x6bdd},
	{0x9ab7, 0x6bde},
	{0x9ab8, 0x6bdf},
	{0x9ab9, 0x6be0},
	{0x9aba, 0x6be2},
	{0x9abb, 0x6be3},
	{0x9abc, 0x6be4},
	{0x9abd, 0x6be5},
	{0x9abe, 0x6be6},
	{0x9abf, 0x6be7},
	{0x9ac0, 0x6be8},
	{0x9ac1, 0x6be9},
	{0x9ac2, 0x6bec},
	{0x9ac3, 0x6bed},
	{0x9ac4, 0x6bee},
	{0x9ac5, 0x6bf0},
	{0x9ac6, 0x6bf1},
	{0x9ac7, 0x6bf2},
	{0x9ac8, 0x6bf4},
	{0x9ac9, 0x6bf6},
	{0x9aca, 0x6bf7},
	{0x9acb, 0x6bf8},
	{0x9acc, 0x6bfa},
	{0x9acd, 0x6bfb},
	{0x9ace, 0x6bfc},
	{0x9acf, 0x6bfe},
	{0x9ad0, 0x6bff},
	{0x9ad1, 0x6c00},
	{0x9ad2, 0x6c01},
	{0x9ad3, 0x6c02},
	{0x9ad4, 0x6c03},
	{0x9ad5, 0x6c04},
	{0x9ad6, 0x6c08},
	{0x9ad7, 0x6c09},
	{0x9ad8, 0x6c0a},
	{0x9ad9, 0x6c0b},
	{0x9ada, 0x6c0c},
	{0x9adb, 0x6c0e},
	{0x9adc, 0x6c12},
	{0x9add, 0x6c17},
	{0x9ade, 0x6c1c},
	{0x9adf, 0x6c1d},
	{0x9ae0, 0x6c1e},
	{0x9ae1, 0x6c20},
	{0x9ae2, 0x6c23},
	{0x9ae3, 0x6c25},
	{0x9ae4, 0x6c2b},
	{0x9ae5, 0x6c2c},
	{0x9ae6, 0x6c2d},
	{0x9ae7, 0x6c31},
	{0x9ae8, 0x6c33},
	{0x9ae9, 0x6c36},
	{0x9aea, 0x6c37},
	{0x9aeb, 0x6c39},
	{0x9aec, 0x6c3a},
	{0x9aed, 0x6c3b},
	{0x9aee, 0x6c3c},
	{0x9aef, 0x6c3e},
	{0x9af0, 0x6c3f},
	{0x9af1, 0x6c43},
	{0x9af2, 0x6c44},
	{0x9af3, 0x6c45},
	{0x9af4, 0x6c48},
	{0x9af5, 0x6c4b},
	{0x9af6, 0x6c4c},
	{0x9af7, 0x6c4d},
	{0x9af8, 0x6c4e},
	{0x9af9, 0x6c4f},
	{0x9afa, 0x6c51},
	{0x9afb, 0x6c52},
	{0x9afc, 0x6c53},
	{0x9afd, 0x6c56},
	{0x9afe, 0x6c58},
	{0x9b40, 0x6c59},
	{0x9b41, 0x6c5a},
	{0x9b42, 0x6c62},
	{0x9b43, 0x6c63},
	{0x9b44, 0x6c65},
	{0x9b45, 0x6c66},
	{0x9b46, 0x6c67},
	{0x9b47, 0x6c6b},
	{0x9b48, 0x6c6c},
	{0x9b49, 0x6c6d},
	{0x9b4a, 0x6c6e},
	{0x9b4b, 0x6c6f},
	{0x9b4c, 0x6c71},
	{0x9b4d, 0x6c73},
	{0x9b4e, 0x6c75},
	{0x9b4f, 0x6c77},
	{0x9b50, 0x6c78},
	{0x9b51, 0x6c7a},
	{0x9b52, 0x6c7b},
	{0x9b53, 0x6c7c},
	{0x9b54, 0x6c7f},
	{0x9b55, 0x6c80},
	{0x9b56, 0x6c84},
	{0x9b57, 0x6c87},
	{0x9b58, 0x6c8a},
	{0x9b59, 0x6c8b},
	{0x9b5a, 0x6c8d},
	{0x9b5b, 0x6c8e},
	{0x9b5c, 0x6c91},
	{0x9b5d, 0x6c92},
	{0x9b5e, 0x6c95},
	{0x9b5f, 0x6c96},
	{0x9b60, 0x6c97},
	{0x9b61, 0x6c98},
	{0x9b62, 0x6c9a},
	{0x9b63, 0x6c9c},
	{0x9b64, 0x6c9d},
	{0x9b65, 0x6c9e},
	{0x9b66, 0x6ca0},
	{0x9b67, 0x6ca2},
	{0x9b68, 0x6ca8},
	{0x9b69, 0x6cac},
	{0x9b6a, 0x6caf},
	{0x9b6b, 0x6cb0},
	{0x9b6c, 0x6cb4},
	{0x9b6d, 0x6cb5},
	{0x9b6e, 0x6cb6},
	{0x9b6f, 0x6cb7},
	{0x9b70, 0x6cba},
	{0x9b71, 0x6cc0},
	{0x9b72, 0x6cc1},
	{0x9b73, 0x6cc2},
	{0x9b74, 0x6cc3},
	{0x9b75, 0x6cc6},
	{0x9b76, 0x6cc7},
	{0x9b77, 0x6cc8},
	{0x9b78, 0x6ccb},
	{0x9b79, 0x6ccd},
	{0x9b7a, 0x6cce},
	{0x9b7b, 0x6ccf},
	{0x9b7c, 0x6cd1},
	{0x9b7d, 0x6cd2},
	{0x9b7e, 0x6cd8},
	{0x9b80, 0x6cd9},
	{0x9b81, 0x6cda},
	{0x9b82, 0x6cdc},
	{0x9b83, 0x6cdd},
	{0x9b84, 0x6cdf},
	{0x9b85, 0x6ce4},
	{0x9b86, 0x6ce6},
	{0x9b87, 0x6ce7},
	{0x9b88, 0x6ce9},
	{0x9b89, 0x6cec},
	{0x9b8a, 0x6ced},
	{0x9b8b, 0x6cf2},
	{0x9b8c, 0x6cf4},
	{0x9b8d, 0x6cf9},
	{0x9b8e, 0x6cff},
	{0x9b8f, 0x6d00},
	{0x9b90, 0x6d02},
	{0x9b91, 0x6d03},
	{0x9b92, 0x6d05},
	{0x9b93, 0x6d06},
	{0x9b94, 0x6d08},
	{0x9b95, 0x6d09},
	{0x9b96, 0x6d0a},
	{0x9b97, 0x6d0d},
	{0x9b98, 0x6d0f},
	{0x9b99, 0x6d10},
	{0x9b9a, 0x6d11},
	{0x9b9b, 0x6d13},
	{0x9b9c, 0x6d14},
	{0x9b9d, 0x6d15},
	{0x9b9e, 0x6d16},
	{0x9b9f, 0x6d18},
	{0x9ba0, 0x6d1c},
	{0x9ba1, 0x6d1d},
	{0x9ba2, 0x6d1f},
	{0x9ba3, 0x6d20},
	{0x9ba4, 0x6d21},
	{0x9ba5, 0x6d22},
	{0x9ba6, 0x6d23},
	{0x9ba7, 0x6d24},
	{0x9ba8, 0x6d26},
	{0x9ba9, 0x6d28},
	{0x9baa, 0x6d29},
	{0x9bab, 0x6d2c},
	{0x9bac, 0x6d2d},
	{0x9bad, 0x6d2f},
	{0x9bae, 0x6d30},
	{0x9baf, 0x6d34},
	{0x9bb0, 0x6d36},
	{0x9bb1, 0x6d37},
	{0x9bb2, 0x6d38},
	{0x9bb3, 0x6d3a},
	{0x9bb4, 0x6d3f},
	{0x9bb5, 0x6d40},
	{0x9bb6, 0x6d42},
	{0x9bb7, 0x6d44},
	{0x9bb8, 0x6d49},
	{0x9bb9, 0x6d4c},
	{0x9bba, 0x6d50},
	{0x9bbb, 0x6d55},
	{0x9bbc, 0x6d56},
	{0x9bbd, 0x6d57},
	{0x9bbe, 0x6d58},
	{0x9bbf, 0x6d5b},
	{0x9bc0, 0x6d5d},
	{0x9bc1, 0x6d5f},
	{0x9bc2, 0x6d61},
	{0x9bc3, 0x6d62},
	{0x9bc4, 0x6d64},
	{0x9bc5, 0x6d65},
	{0x9bc6, 0x6d67},
	{0x9bc7, 0x6d68},
	{0x9bc8, 0x6d6b},
	{0x9bc9, 0x6d6c},
	{0x9bca, 0x6d6d},
	{0x9bcb, 0x6d70},
	{0x9bcc, 0x6d71},
	{0x9bcd, 0x6d72},
	{0x9bce, 0x6d73},
	{0x9bcf, 0x6d75},
	{0x9bd0, 0x6d76},
	{0x9bd1, 0x6d79},
	{0x9bd2, 0x6d7a},
	{0x9bd3, 0x6d7b},
	{0x9bd4, 0x6d7d},
	{0x9bd5, 0x6d7e},
	{0x9bd6, 0x6d7f},
	{0x9bd7, 0x6d80},
	{0x9bd8, 0x6d81},
	{0x9bd9, 0x6d83},
	{0x9bda, 0x6d84},
	{0x9bdb, 0x6d86},
	{0x9bdc, 0x6d87},
	{0x9bdd, 0x6d8a},
	{0x9bde, 0x6d8b},
	{0x9bdf, 0x6d8d},
	{0x9be0, 0x6d8f},
	{0x9be1, 0x6d90},
	{0x9be2, 0x6d92},
	{0x9be3, 0x6d96},
	{0x9be4, 0x6d97},
	{0x9be5, 0x6d98},
	{0x9be6, 0x6d99},
	{0x9be7, 0x6d9a},
	{0x9be8, 0x6d9c},
	{0x9be9, 0x6da2},
	{0x9bea, 0x6da5},
	{0x9beb, 0x6dac},
	{0x9bec, 0x6dad},
	{0x9bed, 0x6db0},
	{0x9bee, 0x6db1},
	{0x9bef, 0x6db3},
	{0x9bf0, 0x6db4},
	{0x9bf1, 0x6db6},
	{0x9bf2, 0x6db7},
	{0x9bf3, 0x6db9},
	{0x9bf4, 0x6dba},
	{0x9bf5, 0x6dbb},
	{0x9bf6, 0x6dbc},
	{0x9bf7, 0x6dbd},
	{0x9bf8, 0x6dbe},
	{0x9bf9, 0x6dc1},
	{0x9bfa, 0x6dc2},
	{0x9bfb, 0x6dc3},
	{0x9bfc, 0x6dc8},
	{0x9bfd, 0x6dc9},
	{0x9bfe, 0x6dca},
	{0x9c40, 0x6dcd},
	{0x9c41, 0x6dce},
	{0x9c42, 0x6dcf},
	{0x9c43, 0x6dd0},
	{0x9c44, 0x6dd2},
	{0x9c45, 0x6dd3},
	{0x9c46, 0x6dd4},
	{0x9c47, 0x6dd5},
	{0x9c48, 0x6dd7},
	{0x9c49, 0x6dda},
	{0x9c4a, 0x6ddb},
	{0x9c4b, 0x6ddc},
	{0x9c4c, 0x6ddf},
	{0x9c4d, 0x6de2},
	{0x9c4e, 0x6de3},
	{0x9c4f, 0x6de5},
	{0x9c50, 0x6de7},
	{0x9c51, 0x6de8},
	{0x9c52, 0x6de9},
	{0x9c53, 0x6dea},
	{0x9c54, 0x6ded},
	{0x9c55, 0x6def},
	{0x9c56, 0x6df0},
	{0x9c57, 0x6df2},
	{0x9c58, 0x6df4},
	{0x9c59, 0x6df5},
	{0x9c5a, 0x6df6},
	{0x9c5b, 0x6df8},
	{0x9c5c, 0x6dfa},
	{0x9c5d, 0x6dfd},
	{0x9c5e, 0x6dfe},
	{0x9c5f, 0x6dff},
	{0x9c60, 0x6e00},
	{0x9c61, 0x6e01},
	{0x9c62, 0x6e02},
	{0x9c63, 0x6e03},
	{0x9c64, 0x6e04},
	{0x9c65, 0x6e06},
	{0x9c66, 0x6e07},
	{0x9c67, 0x6e08},
	{0x9c68, 0x6e09},
	{0x9c69, 0x6e0b},
	{0x9c6a, 0x6e0f},
	{0x9c6b, 0x6e12},
	{0x9c6c, 0x6e13},
	{0x9c6d, 0x6e15},
	{0x9c6e, 0x6e18},
	{0x9c6f, 0x6e19},
	{0x9c70, 0x6e1b},
	{0x9c71, 0x6e1c},
	{0x9c72, 0x6e1e},
	{0x9c73, 0x6e1f},
	{0x9c74, 0x6e22},
	{0x9c75, 0x6e26},
	{0x9c76, 0x6e27},
	{0x9c77, 0x6e28},
	{0x9c78, 0x6e2a},
	{0x9c79, 0x6e2c},
	{0x9c7a, 0x6e2e},
	{0x9c7b, 0x6e30},
	{0x9c7c, 0x6e31},
	{0x9c7d, 0x6e33},
	{0x9c7e, 0x6e35},
	{0x9c80, 0x6e36},
	{0x9c81, 0x6e37},
	{0x9c82, 0x6e39},
	{0x9c83, 0x6e3b},
	{0x9c84, 0x6e3c},
	{0x9c85, 0x6e3d},
	{0x9c86, 0x6e3e},
	{0x9c87, 0x6e3f},
	{0x9c88, 0x6e40},
	{0x9c89, 0x6e41},
	{0x9c8a, 0x6e42},
	{0x9c8b, 0x6e45},
	{0x9c8c, 0x6e46},
	{0x9c8d, 0x6e47},
	{0x9c8e, 0x6e48},
	{0x9c8f, 0x6e49},
	{0x9c90, 0x6e4a},
	{0x9c91, 0x6e4b},
	{0x9c92, 0x6e4c},
	{0x9c93, 0x6e4f},
	{0x9c94, 0x6e50},
	{0x9c95, 0x6e51},
	{0x9c96, 0x6e52},
	{0x9c97, 0x6e55},
	{0x9c98, 0x6e57},
	{0x9c99, 0x6e59},
	{0x9c9a, 0x6e5a},
	{0x9c9b, 0x6e5c},
	{0x9c9c, 0x6e5d},
	{0x9c9d, 0x6e5e},
	{0x9c9e, 0x6e60},
	{0x9c9f, 0x6e61},
	{0x9ca0, 0x6e62},
	{0x9ca1, 0x6e63},
	{0x9ca2, 0x6e64},
	{0x9ca3, 0x6e65},
	{0x9ca4, 0x6e66},
	{0x9ca5, 0x6e67},
	{0x9ca6, 0x6e68},
	{0x9ca7, 0x6e69},
	{0x9ca8, 0x6e6a},
	{0x9ca9, 0x6e6c},
	{0x9caa, 0x6e6d},
	{0x9cab, 0x6e6f},
	{0x9cac, 0x6e70},
	{0x9cad, 0x6e71},
	{0x9cae, 0x6e72},
	{0x9caf, 0x6e73},
	{0x9cb0, 0x6e74},
	{0x9cb1, 0x6e75},
	{0x9cb2, 0x6e76},
	{0x9cb3, 0x6e77},
	{0x9cb4, 0x6e78},
	{0x9cb5, 0x6e79},
	{0x9cb6, 0x6e7a},
	{0x9cb7, 0x6e7b},
	{0x9cb8, 0x6e7c},
	{0x9cb9, 0x6e7d},
	{0x9cba, 0x6e80},
	{0x9cbb, 0x6e81},
	{0x9cbc, 0x6e82},
	{0x9cbd, 0x6e84},
	{0x9cbe, 0x6e87},
	{0x9cbf, 0x6e88},
	{0x9cc0, 0x6e8a},
	{0x9cc1, 0x6e8b},
	{0x9cc2, 0x6e8c},
	{0x9cc3, 0x6e8d},
	{0x9cc4, 0x6e8e},
	{0x9cc5, 0x6e91},
	{0x9cc6, 0x6e92},
	{0x9cc7, 0x6e93},
	{0x9cc8, 0x6e94},
	{0x9cc9, 0x6e95},
	{0x9cca, 0x6e96},
	{0x9ccb, 0x6e97},
	{0x9ccc, 0x6e99},
	{0x9ccd, 0x6e9a},
	{0x9cce, 0x6e9b},
	{0x9ccf, 0x6e9d},
	{0x9cd0, 0x6e9e},
	{0x9cd1, 0x6ea0},
	{0x9cd2, 0x6ea1},
	{0x9cd3, 0x6ea3},
	{0x9cd4, 0x6ea4},
	{0x9cd5, 0x6ea6},
	{0x9cd6, 0x6ea8},
	{0x9cd7, 0x6ea9},
	{0x9cd8, 0x6eab},
	{0x9cd9, 0x6eac},
	{0x9cda, 0x6ead},
	{0x9cdb, 0x6eae},
	{0x9cdc, 0x6eb0},
	{0x9cdd, 0x6eb3},
	{0x9cde, 0x6eb5},
	{0x9cdf, 0x6eb8},
	{0x9ce0, 0x6eb9},
	{0x9ce1, 0x6ebc},
	{0x9ce2, 0x6ebe},
	{0x9ce3, 0x6ebf},
	{0x9ce4, 0x6ec0},
	{0x9ce5, 0x6ec3},
	{0x9ce6, 0x6ec4},
	{0x9ce7, 0x6ec5},
	{0x9ce8, 0x6ec6},
	{0x9ce9, 0x6ec8},
	{0x9cea, 0x6ec9},
	{0x9ceb, 0x6eca},
	{0x9cec, 0x6ecc},
	{0x9ced, 0x6ecd},
	{0x9cee, 0x6ece},
	{0x9cef, 0x6ed0},
	{0x9cf0, 0x6ed2},
	{0x9cf1, 0x6ed6},
	{0x9cf2, 0x6ed8},
	{0x9cf3, 0x6ed9},
	{0x9cf4, 0x6edb},
	{0x9cf5, 0x6edc},
	{0x9cf6, 0x6edd},
	{0x9cf7, 0x6ee3},
	{0x9cf8, 0x6ee7},
	{0x9cf9, 0x6eea},
	{0x9cfa, 0x6eeb},
	{0x9cfb, 0x6eec},
	{0x9cfc, 0x6eed},
	{0x9cfd, 0x6eee},
	{0x9cfe, 0x6eef},
	{0x9d40, 0x6ef0},
	{0x9d41, 0x6ef1},
	{0x9d42, 0x6ef2},
	{0x9d43, 0x6ef3},
	{0x9d44, 0x6ef5},
	{0x9d45, 0x6ef6},
	{0x9d46, 0x6ef7},
	{0x9d47, 0x6ef8},
	{0x9d48, 0x6efa},
	{0x9d49, 0x6efb},
	{0x9d4a, 0x6efc},
	{0x9d4b, 0x6efd},
	{0x9d4c, 0x6efe},
	{0x9d4d, 0x6eff},
	{0x9d4e, 0x6f00},
	{0x9d4f, 0x6f01},
	{0x9d50, 0x6f03},
	{0x9d51, 0x6f04},
	{0x9d52, 0x6f05},
	{0x9d53, 0x6f07},
	{0x9d54, 0x6f08},
	{0x9d55, 0x6f0a},
	{0x9d56, 0x6f0b},
	{0x9d57, 0x6f0c},
	{0x9d58, 0x6f0d},
	{0x9d59, 0x6f0e},
	{0x9d5a, 0x6f10},
	{0x9d5b, 0x6f11},
	{0x9d5c, 0x6f12},
	{0x9d5d, 0x6f16},
	{0x9d5e, 0x6f17},
	{0x9d5f, 0x6f18},
	{0x9d60, 0x6f19},
	{0x9d61, 0x6f1a},
	{0x9d62, 0x6f1b},
	{0x9d63, 0x6f1c},
	{0x9d64, 0x6f1d},
	{0x9d65, 0x6f1e},
	{0x9d66, 0x6f1f},
	{0x9d67, 0x6f21},
	{0x9d68, 0x6f22},
	{0x9d69, 0x6f23},
	{0x9d6a, 0x6f25},
	{0x9d6b, 0x6f26},
	{0x9d6c, 0x6f27},
	{0x9d6d, 0x6f28},
	{0x9d6e, 0x6f2c},
	{0x9d6f, 0x6f2e},
	{0x9d70, 0x6f30},
	{0x9d71, 0x6f32},
	{0x9d72, 0x6f34},
	{0x9d73, 0x6f35},
	{0x9d74, 0x6f37},
	{0x9d75, 0x6f38},
	{0x9d76, 0x6f39},
	{0x9d77, 0x6f3a},
	{0x9d78, 0x6f3b},
	{0x9d79, 0x6f3c},
	{0x9d7a, 0x6f3d},
	{0x9d7b, 0x6f3f},
	{0x9d7c, 0x6f40},
	{0x9d7d, 0x6f41},
	{0x9d7e, 0x6f42},
	{0x9d80, 0x6f43},
	{0x9d81, 0x6f44},
	{0x9d82, 0x6f45},
	{0x9d83, 0x6f48},
	{0x9d84, 0x6f49},
	{0x9d85, 0x6f4a},
	{0x9d86, 0x6f4c},
	{0x9d87, 0x6f4e},
	{0x9d88, 0x6f4f},
	{0x9d89, 0x6f50},
	{0x9d8a, 0x6f51},
	{0x9d8b, 0x6f52},
	{0x9d8c, 0x6f53},
	{0x9d8d, 0x6f54},
	{0x9d8e, 0x6f55},
	{0x9d8f, 0x6f56},
	{0x9d90, 0x6f57},
	{0x9d91, 0x6f59},
	{0x9d92, 0x6f5a},
	{0x9d93, 0x6f5b},
	{0x9d94, 0x6f5d},
	{0x9d95, 0x6f5f},
	{0x9d96, 0x6f60},
	{0x9d97, 0x6f61},
	{0x9d98, 0x6f63},
	{0x9d99, 0x6f64},
	{0x9d9a, 0x6f65},
	{0x9d9b, 0x6f67},
	{0x9d9c, 0x6f68},
	{0x9d9d, 0x6f69},
	{0x9d9e, 0x6f6a},
	{0x9d9f, 0x6f6b},
	{0x9da0, 0x6f6c},
	{0x9da1, 0x6f6f},
	{0x9da2, 0x6f70},
	{0x9da3, 0x6f71},
	{0x9da4, 0x6f73},
	{0x9da5, 0x6f75},
	{0x9da6, 0x6f76},
	{0x9da7, 0x6f77},
	{0x9da8, 0x6f79},
	{0x9da9, 0x6f7b},
	{0x9daa, 0x6f7d},
	{0x9dab, 0x6f7e},
	{0x9dac, 0x6f7f},
	{0x9dad, 0x6f80},
	{0x9dae, 0x6f81},
	{0x9daf, 0x6f82},
	{0x9db0, 0x6f83},
	{0x9db1, 0x6f85},
	{0x9db2, 0x6f86},
	{0x9db3, 0x6f87},
	{0x9db4, 0x6f8a},
	{0x9db5, 0x6f8b},
	{0x9db6, 0x6f8f},
	{0x9db7, 0x6f90},
	{0x9db8, 0x6f91},
	{0x9db9, 0x6f92},
	{0x9dba, 0x6f93},
	{0x9dbb, 0x6f94},
	{0x9dbc, 0x6f95},
	{0x9dbd, 0x6f96},
	{0x9dbe, 0x6f97},
	{0x9dbf, 0x6f98},
	{0x9dc0, 0x6f99},
	{0x9dc1, 0x6f9a},
	{0x9dc2, 0x6f9b},
	{0x9dc3, 0x6f9d},
	{0x9dc4, 0x6f9e},
	{0x9dc5, 0x6f9f},
	{0x9dc6, 0x6fa0},
	{0x9dc7, 0x6fa2},
	{0x9dc8, 0x6fa3},
	{0x9dc9, 0x6fa4},
	{0x9dca, 0x6fa5},
	{0x9dcb, 0x6fa6},
	{0x9dcc, 0x6fa8},
	{0x9dcd, 0x6fa9},
	{0x9dce, 0x6faa},
	{0x9dcf, 0x6fab},
	{0x9dd0, 0x6fac},
	{0x9dd1, 0x6fad},
	{0x9dd2, 0x6fae},
	{0x9dd3, 0x6faf},
	{0x9dd4, 0x6fb0},
	{0x9dd5, 0x6fb1},
	{0x9dd6, 0x6fb2},
	{0x9dd7, 0x6fb4},
	{0x9dd8, 0x6fb5},
	{0x9dd9, 0x6fb7},
	{0x9dda, 0x6fb8},
	{0x9ddb, 0x6fba},
	{0x9ddc, 0x6fbb},
	{0x9ddd, 0x6fbc},
	{0x9dde, 0x6fbd},
	{0x9ddf, 0x6fbe},
	{0x9de0, 0x6fbf},
	{0x9de1, 0x6fc1},
	{0x9de2, 0x6fc3},
	{0x9de3, 0x6fc4},
	{0x9de4, 0x6fc5},
	{0x9de5, 0x6fc6},
	{0x9de6, 0x6fc7},
	{0x9de7, 0x6fc8},
	{0x9de8, 0x6fca},
	{0x9de9, 0x6fcb},
	{0x9dea, 0x6fcc},
	{0x9deb, 0x6fcd},
	{0x9dec, 0x6fce},
	{0x9ded, 0x6fcf},
	{0x9dee, 0x6fd0},
	{0x9def, 0x6fd3},
	{0x9df0, 0x6fd4},
	{0x9df1, 0x6fd5},
	{0x9df2, 0x6fd6},
	{0x9df3, 0x6fd7},
	{0x9df4, 0x6fd8},
	{0x9df5, 0x6fd9},
	{0x9df6, 0x6fda},
	{0x9df7, 0x6fdb},
	{0x9df8, 0x6fdc},
	{0x9df9, 0x6fdd},
	{0x9dfa, 0x6fdf},
	{0x9dfb, 0x6fe2},
	{0x9dfc, 0x6fe3},
	{0x9dfd, 0x6fe4},
	{0x9dfe, 0x6fe5},
	{0x9e40, 0x6fe6},
	{0x9e41, 0x6fe7},
	{0x9e42, 0x6fe8},
	{0x9e43, 0x6fe9},
	{0x9e44, 0x6fea},
	{0x9e45, 0x6feb},
	{0x9e46, 0x6fec},
	{0x9e47, 0x6fed},
	{0x9e48, 0x6ff0},
	{0x9e49, 0x6ff1},
	{0x9e4a, 0x6ff2},
	{0x9e4b, 0x6ff3},
	{0x9e4c, 0x6ff4},
	{0x9e4d, 0x6ff5},
	{0x9e4e, 0x6ff6},
	{0x9e4f, 0x6ff7},
	{0x9e50, 0x6ff8},
	{0x9e51, 0x6ff9},
	{0x9e52, 0x6ffa},
	{0x9e53, 0x6ffb},
	{0x9e54, 0x6ffc},
	{0x9e55, 0x6ffd},
	{0x9e56, 0x6ffe},
	{0x9e57, 0x6fff},
	{0x9e58, 0x7000},
	{0x9e59, 0x7001},
	{0x9e5a, 0x7002},
	{0x9e5b, 0x7003},
	{0x9e5c, 0x7004},
	{0x9e5d, 0x7005},
	{0x9e5e, 0x7006},
	{0x9e5f, 0x7007},
	{0x9e60, 0x7008},
	{0x9e61, 0x7009},
	{0x9e62, 0x700a},
	{0x9e63, 0x700b},
	{0x9e64, 0x700c},
	{0x9e65, 0x700d},
	{0x9e66, 0x700e},
	{0x9e67, 0x700f},
	{0x9e68, 0x7010},
	{0x9e69, 0x7012},
	{0x9e6a, 0x7013},
	{0x9e6b, 0x7014},
	{0x9e6c, 0x7015},
	{0x9e6d, 0x7016},
	{0x9e6e, 0x7017},
	{0x9e6f, 0x7018},
	{0x9e70, 0x7019},
	{0x9e71, 0x701c},
	{0x9e72, 0x701d},
	{0x9e73, 0x701e},
	{0x9e74, 0x701f},
	{0x9e75, 0x7020},
	{0x9e76, 0x7021},
	{0x9e77, 0x7022},
	{0x9e78, 0x7024},
	{0x9e79, 0x7025},
	{0x9e7a, 0x7026},
	{0x9e7b, 0x7027},
	{0x9e7c, 0x7028},
	{0x9e7d, 0x7029},
	{0x9e7e, 0x702a},
	{0x9e80, 0x702b},
	{0x9e81, 0x702c},
	{0x9e82, 0x702d},
	{0x9e83, 0x702e},
	{0x9e84, 0x702f},
	{0x9e85, 0x7030},
	{0x9e86, 0x7031},
	{0x9e87, 0x7032},
	{0x9e88, 0x7033},
	{0x9e89, 0x7034},
	{0x9e8a, 0x7036},
	{0x9e8b, 0x7037},
	{0x9e8c, 0x7038},
	{0x9e8d, 0x703a},
	{0x9e8e, 0x703b},
	{0x9e8f, 0x703c},
	{0x9e90, 0x703d},
	{0x9e91, 0x703e},
	{0x9e92, 0x703f},
	{0x9e93, 0x7040},
	{0x9e94, 0x7041},
	{0x9e95, 0x7042},
	{0x9e96, 0x7043},
	{0x9e97, 0x7044},
	{0x9e98, 0x7045},
	{0x9e99, 0x7046},
	{0x9e9a, 0x7047},
	{0x9e9b, 0x7048},
	{0x9e9c, 0x7049},
	{0x9e9d, 0x704a},
	{0x9e9e, 0x704b},
	{0x9e9f, 0x704d},
	{0x9ea0, 0x704e},
	{0x9ea1, 0x7050},
	{0x9ea2, 0x7051},
	{0x9ea3, 0x7052},
	{0x9ea4, 0x7053},
	{0x9ea5, 0x7054},
	{0x9ea6, 0x7055},
	{0x9ea7, 0x7056},
	{0x9ea8, 0x7057},
	{0x9ea9, 0x7058},
	{0x9eaa, 0x7059},
	{0x9eab, 0x705a},
	{0x9eac, 0x705b},
	{0x9ead, 0x705c},
	{0x9eae, 0x705d},
	{0x9eaf, 0x705f},
	{0x9eb0, 0x7060},
	{0x9eb1, 0x7061},
	{0x9eb2, 0x7062},
	{0x9eb3, 0x7063},
	{0x9eb4, 0x7064},
	{0x9eb5, 0x7065},
	{0x9eb6, 0x7066},
	{0x9eb7, 0x7067},
	{0x9eb8, 0x7068},
	{0x9eb9, 0x7069},
	{0x9eba, 0x706a},
	{0x9ebb, 0x706e},
	{0x9ebc, 0x7071},
	{0x9ebd, 0x7072},
	{0x9ebe, 0x7073},
	{0x9ebf, 0x7074},
	{0x9ec0, 0x7077},
	{0x9ec1, 0x7079},
	{0x9ec2, 0x707a},
	{0x9ec3, 0x707b},
	{0x9ec4, 0x707d},
	{0x9ec5, 0x7081},
	{0x9ec6, 0x7082},
	{0x9ec7, 0x7083},
	{0x9ec8, 0x7084},
	{0x9ec9, 0x7086},
	{0x9eca, 0x7087},
	{0x9ecb, 0x7088},
	{0x9ecc, 0x708b},
	{0x9ecd, 0x708c},
	{0x9ece, 0x708d},
	{0x9ecf, 0x708f},
	{0x9ed0, 0x7090},
	{0x9ed1, 0x7091},
	{0x9ed2, 0x7093},
	{0x9ed3, 0x7097},
	{0x9ed4, 0x7098},
	{0x9ed5, 0x709a},
	{0x9ed6, 0x709b},
	{0x9ed7, 0x709e},
	{0x9ed8, 0x709f},
	{0x9ed9, 0x70a0},
	{0x9eda, 0x70a1},
	{0x9edb, 0x70a2},
	{0x9edc, 0x70a3},
	{0x9edd, 0x70a4},
	{0x9ede, 0x70a5},
	{0x9edf, 0x70a6},
	{0x9ee0, 0x70a7},
	{0x9ee1, 0x70a8},
	{0x9ee2, 0x70a9},
	{0x9ee3, 0x70aa},
	{0x9ee4, 0x70b0},
	{0x9ee5, 0x70b2},
	{0x9ee6, 0x70b4},
	{0x9ee7, 0x70b5},
	{0x9ee8, 0x70b6},
	{0x9ee9, 0x70ba},
	{0x9eea, 0x70be},
	{0x9eeb, 0x70bf},
	{0x9eec, 0x70c4},
	{0x9eed, 0x70c5},
	{0x9eee, 0x70c6},
	{0x9eef, 0x70c7},
	{0x9ef0, 0x70c9},
	{0x9ef1, 0x70cb},
	{0x9ef2, 0x70cc},
	{0x9ef3, 0x70cd},
	{0x9ef4, 0x70ce},
	{0x9ef5, 0x70cf},
	{0x9ef6, 0x70d0},
	{0x9ef7, 0x70d1},
	{0x9ef8, 0x70d2},
	{0x9ef9, 0x70d3},
	{0x9efa, 0x70d4},
	{0x9efb, 0x70d5},
	{0x9efc, 0x70d6},
	{0x9efd, 0x70d7},
	{0x9efe, 0x70da},
	{0x9f40, 0x70dc},
	{0x9f41, 0x70dd},
	{0x9f42, 0x70de},
	{0x9f43, 0x70e0},
	{0x9f44, 0x70e1},
	{0x9f45, 0x70e2},
	{0x9f46, 0x70e3},
	{0x9f47, 0x70e5},
	{0x9f48, 0x70ea},
	{0x9f49, 0x70ee},
	{0x9f4a, 0x70f0},
	{0x9f4b, 0x70f1},
	{0x9f4c, 0x70f2},
	{0x9f4d, 0x70f3},
	{0x9f4e, 0x70f4},
	{0x9f4f, 0x70f5},
	{0x9f50, 0x70f6},
	{0x9f51, 0x70f8},
	{0x9f52, 0x70fa},
	{0x9f53, 0x70fb},
	{0x9f54, 0x70fc},
	{0x9f55, 0x70fe},
	{0x9f56, 0x70ff},
	{0x9f57, 0x7100},
	{0x9f58, 0x7101},
	{0x9f59, 0x7102},
	{0x9f5a, 0x7103},
	{0x9f5b, 0x7104},
	{0x9f5c, 0x7105},
	{0x9f5d, 0x7106},
	{0x9f5e, 0x7107},
	{0x9f5f, 0x7108},
	{0x9f60, 0x710b},
	{0x9f61, 0x710c},
	{0x9f62, 0x710d},
	{0x9f63, 0x710e},
	{0x9f64, 0x710f},
	{0x9f65, 0x7111},
	{0x9f66, 0x7112},
	{0x9f67, 0x7114},
	{0x9f68, 0x7117},
	{0x9f69, 0x711b},
	{0x9f6a, 0x711c},
	{0x9f6b, 0x711d},
	{0x9f6c, 0x711e},
	{0x9f6d, 0x711f},
	{0x9f6e, 0x7120},
	{0x9f6f, 0x7121},
	{0x9f70, 0x7122},
	{0x9f71, 0x7123},
	{0x9f72, 0x7124},
	{0x9f73, 0x7125},
	{0x9f74, 0x7127},
	{0x9f75, 0x7128},
	{0x9f76, 0x7129},
	{0x9f77, 0x712a},
	{0x9f78, 0x712b},
	{0x9f79, 0x712c},
	{0x9f7a, 0x712d},
	{0x9f7b, 0x712e},
	{0x9f7c, 0x7132},
	{0x9f7d, 0x7133},
	{0x9f7e, 0x7134},
	{0x9f80, 0x7135},
	{0x9f81, 0x7137},
	{0x9f82, 0x7138},
	{0x9f83, 0x7139},
	{0x9f84, 0x713a},
	{0x9f85, 0x713b},
	{0x9f86, 0x713c},
	{0x9f87, 0x713d},
	{0x9f88, 0x713e},
	{0x9f89, 0x713f},
	{0x9f8a, 0x7140},
	{0x9f8b, 0x7141},
	{0x9f8c, 0x7142},
	{0x9f8d, 0x7143},
	{0x9f8e, 0x7144},
	{0x9f8f, 0x7146},
	{0x9f90, 0x7147},
	{0x9f91, 0x7148},
	{0x9f92, 0x7149},
	{0x9f93, 0x714b},
	{0x9f94, 0x714d},
	{0x9f95, 0x714f},
	{0x9f96, 0x7150},
	{0x9f97, 0x7151},
	{0x9f98, 0x7152},
	{0x9f99, 0x7153},
	{0x9f9a, 0x7154},
	{0x9f9b, 0x7155},
	{0x9f9c, 0x7156},
	{0x9f9d, 0x7157},
	{0x9f9e, 0x7158},
	{0x9f9f, 0x7159},
	{0x9fa0, 0x715a},
	{0x9fa1, 0x715b},
	{0x9fa2, 0x715d},
	{0x9fa3, 0x715f},
	{0x9fa4, 0x7160},
	{0x9fa5, 0x7161},
	{0x9fa6, 0x7162},
	{0x9fa7, 0x7163},
	{0x9fa8, 0x7165},
	{0x9fa9, 0x7169},
	{0x9faa, 0x716a},
	{0x9fab, 0x716b},
	{0x9fac, 0x716c},
	{0x9fad, 0x716d},
	{0x9fae, 0x716f},
	{0x9faf, 0x7170},
	{0x9fb0, 0x7171},
	{0x9fb1, 0x7174},
	{0x9fb2, 0x7175},
	{0x9fb3, 0x7176},
	{0x9fb4, 0x7177},
	{0x9fb5, 0x7179},
	{0x9fb6, 0x717b},
	{0x9fb7, 0x717c},
	{0x9fb8, 0x717e},
	{0x9fb9, 0x717f},
	{0x9fba, 0x7180},
	{0x9fbb, 0x7181},
	{0x9fbc, 0x7182},
	{0x9fbd, 0x7183},
	{0x9fbe, 0x7185},
	{0x9fbf, 0x7186},
	{0x9fc0, 0x7187},
	{0x9fc1, 0x7188},
	{0x9fc2, 0x7189},
	{0x9fc3, 0x718b},
	{0x9fc4, 0x718c},
	{0x9fc5, 0x718d},
	{0x9fc6, 0x718e},
	{0x9fc7, 0x7190},
	{0x9fc8, 0x7191},
	{0x9fc9, 0x7192},
	{0x9fca, 0x7193},
	{0x9fcb, 0x7195},
	{0x9fcc, 0x7196},
	{0x9fcd, 0x7197},
	{0x9fce, 0x719a},
	{0x9fcf, 0x719b},
	{0x9fd0, 0x719c},
	{0x9fd1, 0x719d},
	{0x9fd2, 0x719e},
	{0x9fd3, 0x71a1},
	{0x9fd4, 0x71a2},
	{0x9fd5, 0x71a3},
	{0x9fd6, 0x71a4},
	{0x9fd7, 0x71a5},
	{0x9fd8, 0x71a6},
	{0x9fd9, 0x71a7},
	{0x9fda, 0x71a9},
	{0x9fdb, 0x71aa},
	{0x9fdc, 0x71ab},
	{0x9fdd, 0x71ad},
	{0x9fde, 0x71ae},
	{0x9fdf, 0x71af},
	{0x9fe0, 0x71b0},
	{0x9fe1, 0x71b1},
	{0x9fe2, 0x71b2},
	{0x9fe3, 0x71b4},
	{0x9fe4, 0x71b6},
	{0x9fe5, 0x71b7},
	{0x9fe6, 0x71b8},
	{0x9fe7, 0x71ba},
	{0x9fe8, 0x71bb},
	{0x9fe9, 0x71bc},
	{0x9fea, 0x71bd},
	{0x9feb, 0x71be},
	{0x9fec, 0x71bf},
	{0x9fed, 0x71c0},
	{0x9fee, 0x71c1},
	{0x9fef, 0x71c2},
	{0x9ff0, 0x71c4},
	{0x9ff1, 0x71c5},
	{0x9ff2, 0x71c6},
	{0x9ff3, 0x71c7},
	{0x9ff4, 0x71c8},
	{0x9ff5, 0x71c9},
	{0x9ff6, 0x71ca},
	{0x9ff7, 0x71cb},
	{0x9ff8, 0x71cc},
	{0x9ff9, 0x71cd},
	{0x9ffa, 0x71cf},
	{0x9ffb, 0x71d0},
	{0x9ffc, 0x71d1},
	{0x9ffd, 0x71d2},
	{0x9ffe, 0x71d3},
	{0xa040, 0x71d6},
	{0xa041, 0x71d7},
	{0xa042, 0x71d8},
	{0xa043, 0x71d9},
	{0xa044, 0x71da},
	{0xa045, 0x71db},
	{0xa046, 0x71dc},
	{0xa047, 0x71dd},
	{0xa048, 0x71de},
	{0xa049, 0x71df},
	{0xa04a, 0x71e1},
	{0xa04b, 0x71e2},
	{0xa04c, 0x71e3},
	{0xa04d, 0x71e4},
	{0xa04e, 0x71e6},
	{0xa04f, 0x71e8},
	{0xa050, 0x71e9},
	{0xa051, 0x71ea},
	{0xa052, 0x71eb},
	{0xa053, 0x71ec},
	{0xa054, 0x71ed},
	{0xa055, 0x71ef},
	{0xa056, 0x71f0},
	{0xa057, 0x71f1},
	{0xa058, 0x71f2},
	{0xa059, 0x71f3},
	{0xa05a, 0x71f4},
	{0xa05b, 0x71f5},
	{0xa05c, 0x71f6},
	{0xa05d, 0x71f7},
	{0xa05e, 0x71f8},
	{0xa05f, 0x71fa},
	{0xa060, 0x71fb},
	{0xa061, 0x71fc},
	{0xa062, 0x71fd},
	{0xa063, 0x71fe},
	{0xa064, 0x71ff},
	{0xa065, 0x7200},
	{0xa066, 0x7201},
	{0xa067, 0x7202},
	{0xa068, 0x7203},
	{0xa069, 0x7204},
	{0xa06a, 0x7205},
	{0xa06b, 0x7207},
	{0xa06c, 0x7208},
	{0xa06d, 0x7209},
	{0xa06e, 0x720a},
	{0xa06f, 0x720b},
	{0xa070, 0x720c},
	{0xa071, 0x720d},
	{0xa072, 0x720e},
	{0xa073, 0x720f},
	{0xa074, 0x7210},
	{0xa075, 0x7211},
	{0xa076, 0x7212},
	{0xa077, 0x7213},
	{0xa078, 0x7214},
	{0xa079, 0x7215},
	{0xa07a, 0x7216},
	{0xa07b, 0x7217},
	{0xa07c, 0x7218},
	{0xa07d, 0x7219},
	{0xa07e, 0x721a},
	{0xa080, 0x721b},
	{0xa081, 0x721c},
	{0xa082, 0x721e},
	{0xa083, 0x721f},
	{0xa084, 0x7220},
	{0xa085, 0x7221},
	{0xa086, 0x7222},
	{0xa087, 0x7223},
	{0xa088, 0x7224},
	{0xa089, 0x7225},
	{0xa08a, 0x7226},
	{0xa08b, 0x7227},
	{0xa08c, 0x7229},
	{0xa08d, 0x722b},
	{0xa08e, 0x722d},
	{0xa08f, 0x722e},
	{0xa090, 0x722f},
	{0xa091, 0x7232},
	{0xa092, 0x7233},
	{0xa093, 0x7234},
	{0xa094, 0x723a},
	{0xa095, 0x723c},
	{0xa096, 0x723e},
	{0xa097, 0x7240},
	{0xa098, 0x7241},
	{0xa099, 0x7242},
	{0xa09a, 0x7243},
	{0xa09b, 0x7244},
	{0xa09c, 0x7245},
	{0xa09d, 0x7246},
	{0xa09e, 0x7249},
	{0xa09f, 0x724a},
	{0xa0a0, 0x724b},
	{0xa0a1, 0x724e},
	{0xa0a2, 0x724f},
	{0xa0a3, 0x7250},
	{0xa0a4, 0x7251},
	{0xa0a5, 0x7253},
	{0xa0a6, 0x7254},
	{0xa0a7, 0x7255},
	{0xa0a8, 0x7257},
	{0xa0a9, 0x7258},
	{0xa0aa, 0x725a},
	{0xa0ab, 0x725c},
	{0xa0ac, 0x725e},
	{0xa0ad, 0x7260},
	{0xa0ae, 0x7263},
	{0xa0af, 0x7264},
	{0xa0b0, 0x7265},
	{0xa0b1, 0x7268},
	{0xa0b2, 0x726a},
	{0xa0b3, 0x726b},
	{0xa0b4, 0x726c},
	{0xa0b5, 0x726d},
	{0xa0b6, 0x7270},
	{0xa0b7, 0x7271},
	{0xa0b8, 0x7273},
	{0xa0b9, 0x7274},
	{0xa0ba, 0x7276},
	{0xa0bb, 0x7277},
	{0xa0bc, 0x7278},
	{0xa0bd, 0x727b},
	{0xa0be, 0x727c},
	{0xa0bf, 0x727d},
	{0xa0c0, 0x7282},
	{0xa0c1, 0x7283},
	{0xa0c2, 0x7285},
	{0xa0c3, 0x7286},
	{0xa0c4, 0x7287},
	{0xa0c5, 0x7288},
	{0xa0c6, 0x7289},
	{0xa0c7, 0x728c},
	{0xa0c8, 0x728e},
	{0xa0c9, 0x7290},
	{0xa0ca, 0x7291},
	{0xa0cb, 0x7293},
	{0xa0cc, 0x7294},
	{0xa0cd, 0x7295},
	{0xa0ce, 0x7296},
	{0xa0cf, 0x7297},
	{0xa0d0, 0x7298},
	{0xa0d1, 0x7299},
	{0xa0d2, 0x729a},
	{0xa0d3, 0x729b},
	{0xa0d4, 0x729c},
	{0xa0d5, 0x729d},
	{0xa0d6, 0x729e},
	{0xa0d7, 0x72a0},
	{0xa0d8, 0x72a1},
	{0xa0d9, 0x72a2},
	{0xa0da, 0x72a3},
	{0xa0db, 0x72a4},
	{0xa0dc, 0x72a5},
	{0xa0dd, 0x72a6},
	{0xa0de, 0x72a7},
	{0xa0df, 0x72a8},
	{0xa0e0, 0x72a9},
	{0xa0e1, 0x72aa},
	{0xa0e2, 0x72ab},
	{0xa0e3, 0x72ae},
	{0xa0e4, 0x72b1},
	{0xa0e5, 0x72b2},
	{0xa0e6, 0x72b3},
	{0xa0e7, 0x72b5},
	{0xa0e8, 0x72ba},
	{0xa0e9, 0x72bb},
	{0xa0ea, 0x72bc},
	{0xa0eb, 0x72bd},
	{0xa0ec, 0x72be},
	{0xa0ed, 0x72bf},
	{0xa0ee, 0x72c0},
	{0xa0ef, 0x72c5},
	{0xa0f0, 0x72c6},
	{0xa0f1, 0x72c7},
	{0xa0f2, 0x72c9},
	{0xa0f3, 0x72ca},
	{0xa0f4, 0x72cb},
	{0xa0f5, 0x72cc},
	{0xa0f6, 0x72cf},
	{0xa0f7, 0x72d1},
	{0xa0f8, 0x72d3},
	{0xa0f9, 0x72d4},
	{0xa0fa, 0x72d5},
	{0xa0fb, 0x72d6},
	{0xa0fc, 0x72d8},
	{0xa0fd, 0x72da},
	{0xa0fe, 0x72db},
	{0xa1a1, 0x3000},
	{0xa1a2, 0x3001},
	{0xa1a3, 0x3002},
	{0xa1a4, 0x00b7},
	{0xa1a5, 0x02c9},
	{0xa1a6, 0x02c7},
	{0xa1a7, 0x00a8},
	{0xa1a8, 0x3003},
	{0xa1a9, 0x3005},
	{0xa1aa, 0x2014},
	{0xa1ab, 0xff5e},
	{0xa1ac, 0x2016},
	{0xa1ad, 0x2026},
	{0xa1ae, 0x2018},
	{0xa1af, 0x2019},
	{0xa1b0, 0x201c},
	{0xa1b1, 0x201d},
	{0xa1b2, 0x3014},
	{0xa1b3, 0x3015},
	{0xa1b4, 0x3008},
	{0xa1b5, 0x3009},
	{0xa1b6, 0x300a},
	{0xa1b7, 0x300b},
	{0xa1b8, 0x300c},
	{0xa1b9, 0x300d},
	{0xa1ba, 0x300e},
	{0xa1bb, 0x300f},
	{0xa1bc, 0x3016},
	{0xa1bd, 0x3017},
	{0xa1be, 0x3010},
	{0xa1bf, 0x3011},
	{0xa1c0, 0x00b1},
	{0xa1c1, 0x00d7},
	{0xa1c2, 0x00f7},
	{0xa1c3, 0x2236},
	{0xa1c4, 0x2227},
	{0xa1c5, 0x2228},
	{0xa1c6, 0x2211},
	{0xa1c7, 0x220f},
	{0xa1c8, 0x222a},
	{0xa1c9, 0x2229},
	{0xa1ca, 0x2208},
	{0xa1cb, 0x2237},
	{0xa1cc, 0x221a},
	{0xa1cd, 0x22a5},
	{0xa1ce, 0x2225},
	{0xa1cf, 0x2220},
	{0xa1d0, 0x2312},
	{0xa1d1, 0x2299},
	{0xa1d2, 0x222b},
	{0xa1d3, 0x222e},
	{0xa1d4, 0x2261},
	{0xa1d5, 0x224c},
	{0xa1d6, 0x2248},
	{0xa1d7, 0x223d},
	{0xa1d8, 0x221d},
	{0xa1d9, 0x2260},
	{0xa1da, 0x226e},
	{0xa1db, 0x226f},
	{0xa1dc, 0x2264},
	{0xa1dd, 0x2265},
	{0xa1de, 0x221e},
	{0xa1df, 0x2235},
	{0xa1e0, 0x2234},
	{0xa1e1, 0x2642},
	{0xa1e2, 0x2640},
	{0xa1e3, 0x00b0},
	{0xa1e4, 0x2032},
	{0xa1e5, 0x2033},
	{0xa1e6, 0x2103},
	{0xa1e7, 0xff04},
	{0xa1e8, 0x00a4},
	{0xa1e9, 0xffe0},
	{0xa1ea, 0xffe1},
	{0xa1eb, 0x2030},
	{0xa1ec, 0x00a7},
	{0xa1ed, 0x2116},
	{0xa1ee, 0x2606},
	{0xa1ef, 0x2605},
	{0xa1f0, 0x25cb},
	{0xa1f1, 0x25cf},
	{0xa1f2, 0x25ce},
	{0xa1f3, 0x25c7},
	{0xa1f4, 0x25c6},
	{0xa1f5, 0x25a1},
	{0xa1f6, 0x25a0},
	{0xa1f7, 0x25b3},
	{0xa1f8, 0x25b2},
	{0xa1f9, 0x203b},
	{0xa1fa, 0x2192},
	{0xa1fb, 0x2190},
	{0xa1fc, 0x2191},
	{0xa1fd, 0x2193},
	{0xa1fe, 0x3013},
	{0xa2a1, 0x2170},
	{0xa2a2, 0x2171},
	{0xa2a3, 0x2172},
	{0xa2a4, 0x2173},
	{0xa2a5, 0x2174},
	{0xa2a6, 0x2175},
	{0xa2a7, 0x2176},
	{0xa2a8, 0x2177},
	{0xa2a9, 0x2178},
	{0xa2aa, 0x2179},
	{0xa2b1, 0x2488},
	{0xa2b2, 0x2489},
	{0xa2b3, 0x248a},
	{0xa2b4, 0x248b},
	{0xa2b5, 0x248c},
	{0xa2b6, 0x248d},
	{0xa2b7, 0x248e},
	{0xa2b8, 0x248f},
	{0xa2b9, 0x2490},
	{0xa2ba, 0x2491},
	{0xa2bb, 0x2492},
	{0xa2bc, 0x2493},
	{0xa2bd, 0x2494},
	{0xa2be, 0x2495},
	{0xa2bf, 0x2496},
	{0xa2c0, 0x2497},
	{0xa2c1, 0x2498},
	{0xa2c2, 0x2499},
	{0xa2c3, 0x249a},
	{0xa2c4, 0x249b},
	{0xa2c5, 0x2474},
	{0xa2c6, 0x2475},
	{0xa2c7, 0x2476},
	{0xa2c8, 0x2477},
	{0xa2c9, 0x2478},
	{0xa2ca, 0x2479},
	{0xa2cb, 0x247a},
	{0xa2cc, 0x247b},
	{0xa2cd, 0x247c},
	{0xa2ce, 0x247d},
	{0xa2cf, 0x247e},
	{0xa2d0, 0x247f},
	{0xa2d1, 0x2480},
	{0xa2d2, 0x2481},
	{0xa2d3, 0x2482},
	{0xa2d4, 0x2483},
	{0xa2d5, 0x2484},
	{0xa2d6, 0x2485},
	{0xa2d7, 0x2486},
	{0xa2d8, 0x2487},
	{0xa2d9, 0x2460},
	{0xa2da, 0x2461},
	{0xa2db, 0x2462},
	{0xa2dc, 0x2463},
	{0xa2dd, 0x2464},
	{0xa2de, 0x2465},
	{0xa2df, 0x2466},
	{0xa2e0, 0x2467},
	{0xa2e1, 0x2468},
	{0xa2e2, 0x2469},
	{0xa2e5, 0x3220},
	{0xa2e6, 0x3221},
	{0xa2e7, 0x3222},
	{0xa2e8, 0x3223},
	{0xa2e9, 0x3224},
	{0xa2ea, 0x3225},
	{0xa2eb, 0x3226},
	{0xa2ec, 0x3227},
	{0xa2ed, 0x3228},
	{0xa2ee, 0x3229},
	{0xa2f1, 0x2160},
	{0xa2f2, 0x2161},
	{0xa2f3, 0x2162},
	{0xa2f4, 0x2163},
	{0xa2f5, 0x2164},
	{0xa2f6, 0x2165},
	{0xa2f7, 0x2166},
	{0xa2f8, 0x2167},
	{0xa2f9, 0x2168},
	{0xa2fa, 0x2169},
	{0xa2fb, 0x216a},
	{0xa2fc, 0x216b},
	{0xa3a1, 0xff01},
	{0xa3a2, 0xff02},
	{0xa3a3, 0xff03},
	{0xa3a4, 0xffe5},
	{0xa3a5, 0xff05},
	{0xa3a6, 0xff06},
	{0xa3a7, 0xff07},
	{0xa3a8, 0xff08},
	{0xa3a9, 0xff09},
	{0xa3aa, 0xff0a},
	{0xa3ab, 0xff0b},
	{0xa3ac, 0xff0c},
	{0xa3ad, 0xff0d},
	{0xa3ae, 0xff0e},
	{0xa3af, 0xff0f},
	{0xa3b0, 0xff10},
	{0xa3b1, 0xff11},
	{0xa3b2, 0xff12},
	{0xa3b3, 0xff13},
	{0xa3b4, 0xff14},
	{0xa3b5, 0xff15},
	{0xa3b6, 0xff16},
	{0xa3b7, 0xff17},
	{0xa3b8, 0xff18},
	{0xa3b9, 0xff19},
	{0xa3ba, 0xff1a},
	{0xa3bb, 0xff1b},
	{0xa3bc, 0xff1c},
	{0xa3bd, 0xff1d},
	{0xa3be, 0xff1e},
	{0xa3bf, 0xff1f},
	{0xa3c0, 0xff20},
	{0xa3c1, 0xff21},
	{0xa3c2, 0xff22},
	{0xa3c3, 0xff23},
	{0xa3c4, 0xff24},
	{0xa3c5, 0xff25},
	{0xa3c6, 0xff26},
	{0xa3c7, 0xff27},
	{0xa3c8, 0xff28},
	{0xa3c9, 0xff29},
	{0xa3ca, 0xff2a},
	{0xa3cb, 0xff2b},
	{0xa3cc, 0xff2c},
	{0xa3cd, 0xff2d},
	{0xa3ce, 0xff2e},
	{0xa3cf, 0xff2f},
	{0xa3d0, 0xff30},
	{0xa3d1, 0xff31},
	{0xa3d2, 0xff32},
	{0xa3d3, 0xff33},
	{0xa3d4, 0xff34},
	{0xa3d5, 0xff35},
	{0xa3d6, 0xff36},
	{0xa3d7, 0xff37},
	{0xa3d8, 0xff38},
	{0xa3d9, 0xff39},
	{0xa3da, 0xff3a},
	{0xa3db, 0xff3b},
	{0xa3dc, 0xff3c},
	{0xa3dd, 0xff3d},
	{0xa3de, 0xff3e},
	{0xa3df, 0xff3f},
	{0xa3e0, 0xff40},
	{0xa3e1, 0xff41},
	{0xa3e2, 0xff42},
	{0xa3e3, 0xff43},
	{0xa3e4, 0xff44},
	{0xa3e5, 0xff45},
	{0xa3e6, 0xff46},
	{0xa3e7, 0xff47},
	{0xa3e8, 0xff48},
	{0xa3e9, 0xff49},
	{0xa3ea, 0xff4a},
	{0xa3eb, 0xff4b},
	{0xa3ec, 0xff4c},
	{0xa3ed, 0xff4d},
	{0xa3ee, 0xff4e},
	{0xa3ef, 0xff4f},
	{0xa3f0, 0xff50},
	{0xa3f1, 0xff51},
	{0xa3f2, 0xff52},
	{0xa3f3, 0xff53},
	{0xa3f4, 0xff54},
	{0xa3f5, 0xff55},
	{0xa3f6, 0xff56},
	{0xa3f7, 0xff57},
	{0xa3f8, 0xff58},
	{0xa3f9, 0xff59},
	{0xa3fa, 0xff5a},
	{0xa3fb, 0xff5b},
	{0xa3fc, 0xff5c},
	{0xa3fd, 0xff5d},
	{0xa3fe, 0xffe3},
	{0xa4a1, 0x3041},
	{0xa4a2, 0x3042},
	{0xa4a3, 0x3043},
	{0xa4a4, 0x3044},
	{0xa4a5, 0x3045},
	{0xa4a6, 0x3046},
	{0xa4a7, 0x3047},
	{0xa4a8, 0x3048},
	{0xa4a9, 0x3049},
	{0xa4aa, 0x304a},
	{0xa4ab, 0x304b},
	{0xa4ac, 0x304c},
	{0xa4ad, 0x304d},
	{0xa4ae, 0x304e},
	{0xa4af, 0x304f},
	{0xa4b0, 0x3050},
	{0xa4b1, 0x3051},
	{0xa4b2, 0x3052},
	{0xa4b3, 0x3053},
	{0xa4b4, 0x3054},
	{0xa4b5, 0x3055},
	{0xa4b6, 0x3056},
	{0xa4b7, 0x3057},
	{0xa4b8, 0x3058},
	{0xa4b9, 0x3059},
	{0xa4ba, 0x305a},
	{0xa4bb, 0x305b},
	{0xa4bc, 0x305c},
	{0xa4bd, 0x305d},
	{0xa4be, 0x305e},
	{0xa4bf, 0x305f},
	{0xa4c0, 0x3060},
	{0xa4c1, 0x3061},
	{0xa4c2, 0x3062},
	{0xa4c3, 0x3063},
	{0xa4c4, 0x3064},
	{0xa4c5, 0x3065},
	{0xa4c6, 0x3066},
	{0xa4c7, 0x3067},
	{0xa4c8, 0x3068},
	{0xa4c9, 0x3069},
	{0xa4ca, 0x306a},
	{0xa4cb, 0x306b},
	{0xa4cc, 0x306c},
	{0xa4cd, 0x306d},
	{0xa4ce, 0x306e},
	{0xa4cf, 0x306f},
	{0xa4d0, 0x3070},
	{0xa4d1, 0x3071},
	{0xa4d2, 0x3072},
	{0xa4d3, 0x3073},
	{0xa4d4, 0x3074},
	{0xa4d5, 0x3075},
	{0xa4d6, 0x3076},
	{0xa4d7, 0x3077},
	{0xa4d8, 0x3078},
	{0xa4d9, 0x3079},
	{0xa4da, 0x307a},
	{0xa4db, 0x307b},
	{0xa4dc, 0x307c},
	{0xa4dd, 0x307d},
	{0xa4de, 0x307e},
	{0xa4df, 0x307f},
	{0xa4e0, 0x3080},
	{0xa4e1, 0x3081},
	{0xa4e2, 0x3082},
	{0xa4e3, 0x3083},
	{0xa4e4, 0x3084},
	{0xa4e5, 0x3085},
	{0xa4e6, 0x3086},
	{0xa4e7, 0x3087},
	{0xa4e8, 0x3088},
	{0xa4e9, 0x3089},
	{0xa4ea, 0x308a},
	{0xa4eb, 0x308b},
	{0xa4ec, 0x308c},
	{0xa4ed, 0x308d},
	{0xa4ee, 0x308e},
	{0xa4ef, 0x308f},
	{0xa4f0, 0x3090},
	{0xa4f1, 0x3091},
	{0xa4f2, 0x3092},
	{0xa4f3, 0x3093},
	{0xa5a1, 0x30a1},
	{0xa5a2, 0x30a2},
	{0xa5a3, 0x30a3},
	{0xa5a4, 0x30a4},
	{0xa5a5, 0x30a5},
	{0xa5a6, 0x30a6},
	{0xa5a7, 0x30a7},
	{0xa5a8, 0x30a8},
	{0xa5a9, 0x30a9},
	{0xa5aa, 0x30aa},
	{0xa5ab, 0x30ab},
	{0xa5ac, 0x30ac},
	{0xa5ad, 0x30ad},
	{0xa5ae, 0x30ae},
	{0xa5af, 0x30af},
	{0xa5b0, 0x30b0},
	{0xa5b1, 0x30b1},
	{0xa5b2, 0x30b2},
	{0xa5b3, 0x30b3},
	{0xa5b4, 0x30b4},
	{0xa5b5, 0x30b5},
	{0xa5b6, 0x30b6},
	{0xa5b7, 0x30b7},
	{0xa5b8, 0x30b8},
	{0xa5b9, 0x30b9},
	{0xa5ba, 0x30ba},
	{0xa5bb, 0x30bb},
	{0xa5bc, 0x30bc},
	{0xa5bd, 0x30bd},
	{0xa5be, 0x30be},
	{0xa5bf, 0x30bf},
	{0xa5c0, 0x30c0},
	{0xa5c1, 0x30c1},
	{0xa5c2, 0x30c2},
	{0xa5c3, 0x30c3},
	{0xa5c4, 0x30c4},
	{0xa5c5, 0x30c5},
	{0xa5c6, 0x30c6},
	{0xa5c7, 0x30c7},
	{0xa5c8, 0x30c8},
	{0xa5c9, 0x30c9},
	{0xa5ca, 0x30ca},
	{0xa5cb, 0x30cb},
	{0xa5cc, 0x30cc},
	{0xa5cd, 0x30cd},
	{0xa5ce, 0x30ce},
	{0xa5cf, 0x30cf},
	{0xa5d0, 0x30d0},
	{0xa5d1, 0x30d1},
	{0xa5d2, 0x30d2},
	{0xa5d3, 0x30d3},
	{0xa5d4, 0x30d4},
	{0xa5d5, 0x30d5},
	{0xa5d6, 0x30d6},
	{0xa5d7, 0x30d7},
	{0xa5d8, 0x30d8},
	{0xa5d9, 0x30d9},
	{0xa5da, 0x30da},
	{0xa5db, 0x30db},
	{0xa5dc, 0x30dc},
	{0xa5dd, 0x30dd},
	{0xa5de, 0x30de},
	{0xa5df, 0x30df},
	{0xa5e0, 0x30e0},
	{0xa5e1, 0x30e1},
	{0xa5e2, 0x30e2},
	{0xa5e3, 0x30e3},
	{0xa5e4, 0x30e4},
	{0xa5e5, 0x30e5},
	{0xa5e6, 0x30e6},
	{0xa5e7, 0x30e7},
	{0xa5e8, 0x30e8},
	{0xa5e9, 0x30e9},
	{0xa5ea, 0x30ea},
	{0xa5eb, 0x30eb},
	{0xa5ec, 0x30ec},
	{0xa5ed, 0x30ed},
	{0xa5ee, 0x30ee},
	{0xa5ef, 0x30ef},
	{0xa5f0, 0x30f0},
	{0xa5f1, 0x30f1},
	{0xa5f2, 0x30f2},
	{0xa5f3, 0x30f3},
	{0xa5f4, 0x30f4},
	{0xa5f5, 0x30f5},
	{0xa5f6, 0x30f6},
	{0xa6a1, 0x0391},
	{0xa6a2, 0x0392},
	{0xa6a3, 0x0393},
	{0xa6a4, 0x0394},
	{0xa6a5, 0x0395},
	{0xa6a6, 0x0396},
	{0xa6a7, 0x0397},
	{0xa6a8, 0x0398},
	{0xa6a9, 0x0399},
	{0xa6aa, 0x039a},
	{0xa6ab, 0x039b},
	{0xa6ac, 0x039c},
	{0xa6ad, 0x039d},
	{0xa6ae, 0x039e},
	{0xa6af, 0x039f},
	{0xa6b0, 0x03a0},
	{0xa6b1, 0x03a1},
	{0xa6b2, 0x03a3},
	{0xa6b3, 0x03a4},
	{0xa6b4, 0x03a5},
	{0xa6b5, 0x03a6},
	{0xa6b6, 0x03a7},
	{0xa6b7, 0x03a8},
	{0xa6b8, 0x03a9},
	{0xa6c1, 0x03b1},
	{0xa6c2, 0x03b2},
	{0xa6c3, 0x03b3},
	{0xa6c4, 0x03b4},
	{0xa6c5, 0x03b5},
	{0xa6c6, 0x03b6},
	{0xa6c7, 0x03b7},
	{0xa6c8, 0x03b8},
	{0xa6c9, 0x03b9},
	{0xa6ca, 0x03ba},
	{0xa6cb, 0x03bb},
	{0xa6cc, 0x03bc},
	{0xa6cd, 0x03bd},
	{0xa6ce, 0x03be},
	{0xa6cf, 0x03bf},
	{0xa6d0, 0x03c0},
	{0xa6d1, 0x03c1},
	{0xa6d2, 0x03c3},
	{0xa6d3, 0x03c4},
	{0xa6d4, 0x03c5},
	{0xa6d5, 0x03c6},
	{0xa6d6, 0x03c7},
	{0xa6d7, 0x03c8},
	{0xa6d8, 0x03c9},
	{0xa6e0, 0xfe35},
	{0xa6e1, 0xfe36},
	{0xa6e2, 0xfe39},
	{0xa6e3, 0xfe3a},
	{0xa6e4, 0xfe3f},
	{0xa6e5, 0xfe40},
	{0xa6e6, 0xfe3d},
	{0xa6e7, 0xfe3e},
	{0xa6e8, 0xfe41},
	{0xa6e9, 0xfe42},
	{0xa6ea, 0xfe43},
	{0xa6eb, 0xfe44},
	{0xa6ee, 0xfe3b},
	{0xa6ef, 0xfe3c},
	{0xa6f0, 0xfe37},
	{0xa6f1, 0xfe38},
	{0xa6f2, 0xfe31},
	{0xa6f4, 0xfe33},
	{0xa6f5, 0xfe34},
	{0xa7a1, 0x0410},
	{0xa7a2, 0x0411},
	{0xa7a3, 0x0412},
	{0xa7a4, 0x0413},
	{0xa7a5, 0x0414},
	{0xa7a6, 0x0415},
	{0xa7a7, 0x0401},
	{0xa7a8, 0x0416},
	{0xa7a9, 0x0417},
	{0xa7aa, 0x0418},
	{0xa7ab, 0x0419},
	{0xa7ac, 0x041a},
	{0xa7ad, 0x041b},
	{0xa7ae, 0x041c},
	{0xa7af, 0x041d},
	{0xa7b0, 0x041e},
	{0xa7b1, 0x041f},
	{0xa7b2, 0x0420},
	{0xa7b3, 0x0421},
	{0xa7b4, 0x0422},
	{0xa7b5, 0x0423},
	{0xa7b6, 0x0424},
	{0xa7b7, 0x0425},
	{0xa7b8, 0x0426},
	{0xa7b9, 0x0427},
	{0xa7ba, 0x0428},
	{0xa7bb, 0x0429},
	{0xa7bc, 0x042a},
	{0xa7bd, 0x042b},
	{0xa7be, 0x042c},
	{0xa7bf, 0x042d},
	{0xa7c0, 0x042e},
	{0xa7c1, 0x042f},
	{0xa7d1, 0x0430},
	{0xa7d2, 0x0431},
	{0xa7d3, 0x0432},
	{0xa7d4, 0x0433},
	{0xa7d5, 0x0434},
	{0xa7d6, 0x0435},
	{0xa7d7, 0x0451},
	{0xa7d8, 0x0436},
	{0xa7d9, 0x0437},
	{0xa7da, 0x0438},
	{0xa7db, 0x0439},
	{0xa7dc, 0x043a},
	{0xa7dd, 0x043b},
	{0xa7de, 0x043c},
	{0xa7df, 0x043d},
	{0xa7e0, 0x043e},
	{0xa7e1, 0x043f},
	{0xa7e2, 0x0440},
	{0xa7e3, 0x0441},
	{0xa7e4, 0x0442},
	{0xa7e5, 0x0443},
	{0xa7e6, 0x0444},
	{0xa7e7, 0x0445},
	{0xa7e8, 0x0446},
	{0xa7e9, 0x0447},
	{0xa7ea, 0x0448},
	{0xa7eb, 0x0449},
	{0xa7ec, 0x044a},
	{0xa7ed, 0x044b},
	{0xa7ee, 0x044c},
	{0xa7ef, 0x044d},
	{0xa7f0, 0x044e},
	{0xa7f1, 0x044f},
	{0xa840, 0x02ca},
	{0xa841, 0x02cb},
	{0xa842, 0x02d9},
	{0xa843, 0x2013},
	{0xa844, 0x2015},
	{0xa845, 0x2025},
	{0xa846, 0x2035},
	{0xa847, 0x2105},
	{0xa848, 0x2109},
	{0xa849, 0x2196},
	{0xa84a, 0x2197},
	{0xa84b, 0x2198},
	{0xa84c, 0x2199},
	{0xa84d, 0x2215},
	{0xa84e, 0x221f},
	{0xa84f, 0x2223},
	{0xa850, 0x2252},
	{0xa851, 0x2266},
	{0xa852, 0x2267},
	{0xa853, 0x22bf},
	{0xa854, 0x2550},
	{0xa855, 0x2551},
	{0xa856, 0x2552},
	{0xa857, 0x2553},
	{0xa858, 0x2554},
	{0xa859, 0x2555},
	{0xa85a, 0x2556},
	{0xa85b, 0x2557},
	{0xa85c, 0x2558},
	{0xa85d, 0x2559},
	{0xa85e, 0x255a},
	{0xa85f, 0x255b},
	{0xa860, 0x255c},
	{0xa861, 0x255d},
	{0xa862, 0x255e},
	{0xa863, 0x255f},
	{0xa864, 0x2560},
	{0xa865, 0x2561},
	{0xa866, 0x2562},
	{0xa867, 0x2563},
	{0xa868, 0x2564},
	{0xa869, 0x2565},
	{0xa86a, 0x2566},
	{0xa86b, 0x2567},
	{0xa86c, 0x2568},
	{0xa86d, 0x2569},
	{0xa86e, 0x256a},
	{0xa86f, 0x256b},
	{0xa870, 0x256c},
	{0xa871, 0x256d},
	{0xa872, 0x256e},
	{0xa873, 0x256f},
	{0xa874, 0x2570},
	{0xa875, 0x2571},
	{0xa876, 0x2572},
	{0xa877, 0x2573},
	{0xa878, 0x2581},
	{0xa879, 0x2582},
	{0xa87a, 0x2583},
	{0xa87b, 0x2584},
	{0xa87c, 0x2585},
	{0xa87d, 0x2586},
	{0xa87e, 0x2587},
	{0xa880, 0x2588},
	{0xa881, 0x2589},
	{0xa882, 0x258a},
	{0xa883, 0x258b},
	{0xa884, 0x258c},
	{0xa885, 0x258d},
	{0xa886, 0x258e},
	{0xa887, 0x258f},
	{0xa888, 0x2593},
	{0xa889, 0x2594},
	{0xa88a, 0x2595},
	{0xa88b, 0x25bc},
	{0xa88c, 0x25bd},
	{0xa88d, 0x25e2},
	{0xa88e, 0x25e3},
	{0xa88f, 0x25e4},
	{0xa890, 0x25e5},
	{0xa891, 0x2609},
	{0xa892, 0x2295},
	{0xa893, 0x3012},
	{0xa894, 0x301d},
	{0xa895, 0x301e},
	{0xa8a1, 0x0101},
	{0xa8a2, 0x00e1},
	{0xa8a3, 0x01ce},
	{0xa8a4, 0x00e0},
	{0xa8a5, 0x0113},
	{0xa8a6, 0x00e9},
	{0xa8a7, 0x011b},
	{0xa8a8, 0x00e8},
	{0xa8a9, 0x012b},
	{0xa8aa, 0x00ed},
	{0xa8ab, 0x01d0},
	{0xa8ac, 0x00ec},
	{0xa8ad, 0x014d},
	{0xa8ae, 0x00f3},
	{0xa8af, 0x01d2},
	{0xa8b0, 0x00f2},
	{0xa8b1, 0x016b},
	{0xa8b2, 0x00fa},
	{0xa8b3, 0x01d4},
	{0xa8b4, 0x00f9},
	{0xa8b5, 0x01d6},
	{0xa8b6, 0x01d8},
	{0xa8b7, 0x01da},
	{0xa8b8, 0x01dc},
	{0xa8b9, 0x00fc},
	{0xa8ba, 0x00ea},
	{0xa8bb, 0x0251},
	{0xa8bd, 0x0144},
	{0xa8be, 0x0148},
	{0xa8c0, 0x0261},
	{0xa8c5, 0x3105},
	{0xa8c6, 0x3106},
	{0xa8c7, 0x3107},
	{0xa8c8, 0x3108},
	{0xa8c9, 0x3109},
	{0xa8ca, 0x310a},
	{0xa8cb, 0x310b},
	{0xa8cc, 0x310c},
	{0xa8cd, 0x310d},
	{0xa8ce, 0x310e},
	{0xa8cf, 0x310f},
	{0xa8d0, 0x3110},
	{0xa8d1, 0x3111},
	{0xa8d2, 0x3112},
	{0xa8d3, 0x3113},
	{0xa8d4, 0x3114},
	{0xa8d5, 0x3115},
	{0xa8d6, 0x3116},
	{0xa8d7, 0x3117},
	{0xa8d8, 0x3118},
	{0xa8d9, 0x3119},
	{0xa8da, 0x311a},
	{0xa8db, 0x311b},
	{0xa8dc, 0x311c},
	{0xa8dd, 0x311d},
	{0xa8de, 0x311e},
	{0xa8df, 0x311f},
	{0xa8e0, 0x3120},
	{0xa8e1, 0x3121},
	{0xa8e2, 0x3122},
	{0xa8e3, 0x3123},
	{0xa8e4, 0x3124},
	{0xa8e5, 0x3125},
	{0xa8e6, 0x3126},
	{0xa8e7, 0x3127},
	{0xa8e8, 0x3128},
	{0xa8e9, 0x3129},
	{0xa940, 0x3021},
	{0xa941, 0x3022},
	{0xa942, 0x3023},
	{0xa943, 0x3024},
	{0xa944, 0x3025},
	{0xa945, 0x3026},
	{0xa946, 0x3027},
	{0xa947, 0x3028},
	{0xa948, 0x3029},
	{0xa949, 0x32a3},
	{0xa94a, 0x338e},
	{0xa94b, 0x338f},
	{0xa94c, 0x339c},
	{0xa94d, 0x339d},
	{0xa94e, 0x339e},
	{0xa94f, 0x33a1},
	{0xa950, 0x33c4},
	{0xa951, 0x33ce},
	{0xa952, 0x33d1},
	{0xa953, 0x33d2},
	{0xa954, 0x33d5},
	{0xa955, 0xfe30},
	{0xa956, 0xffe2},
	{0xa957, 0xffe4},
	{0xa959, 0x2121},
	{0xa95a, 0x3231},
	{0xa95c, 0x2010},
	{0xa960, 0x30fc},
	{0xa961, 0x309b},
	{0xa962, 0x309c},
	{0xa963, 0x30fd},
	{0xa964, 0x30fe},
	{0xa965, 0x3006},
	{0xa966, 0x309d},
	{0xa967, 0x309e},
	{0xa968, 0xfe49},
	{0xa969, 0xfe4a},
	{0xa96a, 0xfe4b},
	{0xa96b, 0xfe4c},
	{0xa96c, 0xfe4d},
	{0xa96d, 0xfe4e},
	{0xa96e, 0xfe4f},
	{0xa96f, 0xfe50},
	{0xa970, 0xfe51},
	{0xa971, 0xfe52},
	{0xa972, 0xfe54},
	{0xa973, 0xfe55},
	{0xa974, 0xfe56},
	{0xa975, 0xfe57},
	{0xa976, 0xfe59},
	{0xa977, 0xfe5a},
	{0xa978, 0xfe5b},
	{0xa979, 0xfe5c},
	{0xa97a, 0xfe5d},
	{0xa97b, 0xfe5e},
	{0xa97c, 0xfe5f},
	{0xa97d, 0xfe60},
	{0xa97e, 0xfe61},
	{0xa980, 0xfe62},
	{0xa981, 0xfe63},
	{0xa982, 0xfe64},
	{0xa983, 0xfe65},
	{0xa984, 0xfe66},
	{0xa985, 0xfe68},
	{0xa986, 0xfe69},
	{0xa987, 0xfe6a},
	{0xa988, 0xfe6b},
	{0xa996, 0x3007},
	{0xa9a4, 0x2500},
	{0xa9a5, 0x2501},
	{0xa9a6, 0x2502},
	{0xa9a7, 0x2503},
	{0xa9a8, 0x2504},
	{0xa9a9, 0x2505},
	{0xa9aa, 0x2506},
	{0xa9ab, 0x2507},
	{0xa9ac, 0x2508},
	{0xa9ad, 0x2509},
	{0xa9ae, 0x250a},
	{0xa9af, 0x250b},
	{0xa9b0, 0x250c},
	{0xa9b1, 0x250d},
	{0xa9b2, 0x250e},
	{0xa9b3, 0x250f},
	{0xa9b4, 0x2510},
	{0xa9b5, 0x2511},
	{0xa9b6, 0x2512},
	{0xa9b7, 0x2513},
	{0xa9b8, 0x2514},
	{0xa9b9, 0x2515},
	{0xa9ba, 0x2516},
	{0xa9bb, 0x2517},
	{0xa9bc, 0x2518},
	{0xa9bd, 0x2519},
	{0xa9be, 0x251a},
	{0xa9bf, 0x251b},
	{0xa9c0, 0x251c},
	{0xa9c1, 0x251d},
	{0xa9c2, 0x251e},
	{0xa9c3, 0x251f},
	{0xa9c4, 0x2520},
	{0xa9c5, 0x2521},
	{0xa9c6, 0x2522},
	{0xa9c7, 0x2523},
	{0xa9c8, 0x2524},
	{0xa9c9, 0x2525},
	{0xa9ca, 0x2526},
	{0xa9cb, 0x2527},
	{0xa9cc, 0x2528},
	{0xa9cd, 0x2529},
	{0xa9ce, 0x252a},
	{0xa9cf, 0x252b},
	{0xa9d0, 0x252c},
	{0xa9d1, 0x252d},
	{0xa9d2, 0x252e},
	{0xa9d3, 0x252f},
	{0xa9d4, 0x2530},
	{0xa9d5, 0x2531},
	{0xa9d6, 0x2532},
	{0xa9d7, 0x2533},
	{0xa9d8, 0x2534},
	{0xa9d9, 0x2535},
	{0xa9da, 0x2536},
	{0xa9db, 0x2537},
	{0xa9dc, 0x2538},
	{0xa9dd, 0x2539},
	{0xa9de, 0x253a},
	{0xa9df, 0x253b},
	{0xa9e0, 0x253c},
	{0xa9e1, 0x253d},
	{0xa9e2, 0x253e},
	{0xa9e3, 0x253f},
	{0xa9e4, 0x2540},
	{0xa9e5, 0x2541},
	{0xa9e6, 0x2542},
	{0xa9e7, 0x2543},
	{0xa9e8, 0x2544},
	{0xa9e9, 0x2545},
	{0xa9ea, 0x2546},
	{0xa9eb, 0x2547},
	{0xa9ec, 0x2548},
	{0xa9ed, 0x2549},
	{0xa9ee, 0x254a},
	{0xa9ef, 0x254b},
	{0xaa40, 0x72dc},
	{0xaa41, 0x72dd},
	{0xaa42, 0x72df},
	{0xaa43, 0x72e2},
	{0xaa44, 0x72e3},
	{0xaa45, 0x72e4},
	{0xaa46, 0x72e5},
	{0xaa47, 0x72e6},
	{0xaa48, 0x72e7},
	{0xaa49, 0x72ea},
	{0xaa4a, 0x72eb},
	{0xaa4b, 0x72f5},
	{0xaa4c, 0x72f6},
	{0xaa4d, 0x72f9},
	{0xaa4e, 0x72fd},
	{0xaa4f, 0x72fe},
	{0xaa50, 0x72ff},
	{0xaa51, 0x7300},
	{0xaa52, 0x7302},
	{0xaa53, 0x7304},
	{0xaa54, 0x7305},
	{0xaa55, 0x7306},
	{0xaa56, 0x7307},
	{0xaa57, 0x7308},
	{0xaa58, 0x7309},
	{0xaa59, 0x730b},
	{0xaa5a, 0x730c},
	{0xaa5b, 0x730d},
	{0xaa5c, 0x730f},
	{0xaa5d, 0x7310},
	{0xaa5e, 0x7311},
	{0xaa5f, 0x7312},
	{0xaa60, 0x7314},
	{0xaa61, 0x7318},
	{0xaa62, 0x7319},
	{0xaa63, 0x731a},
	{0xaa64, 0x731f},
	{0xaa65, 0x7320},
	{0xaa66, 0x7323},
	{0xaa67, 0x7324},
	{0xaa68, 0x7326},
	{0xaa69, 0x7327},
	{0xaa6a, 0x7328},
	{0xaa6b, 0x732d},
	{0xaa6c, 0x732f},
	{0xaa6d, 0x7330},
	{0xaa6e, 0x7332},
	{0xaa6f, 0x7333},
	{0xaa70, 0x7335},
	{0xaa71, 0x7336},
	{0xaa72, 0x733a},
	{0xaa73, 0x733b},
	{0xaa74, 0x733c},
	{0xaa75, 0x733d},
	{0xaa76, 0x7340},
	{0xaa77, 0x7341},
	{0xaa78, 0x7342},
	{0xaa79, 0x7343},
	{0xaa7a, 0x7344},
	{0xaa7b, 0x7345},
	{0xaa7c, 0x7346},
	{0xaa7d, 0x7347},
	{0xaa7e, 0x7348},
	{0xaa80, 0x7349},
	{0xaa81, 0x734a},
	{0xaa82, 0x734b},
	{0xaa83, 0x734c},
	{0xaa84, 0x734e},
	{0xaa85, 0x734f},
	{0xaa86, 0x7351},
	{0xaa87, 0x7353},
	{0xaa88, 0x7354},
	{0xaa89, 0x7355},
	{0xaa8a, 0x7356},
	{0xaa8b, 0x7358},
	{0xaa8c, 0x7359},
	{0xaa8d, 0x735a},
	{0xaa8e, 0x735b},
	{0xaa8f, 0x735c},
	{0xaa90, 0x735d},
	{0xaa91, 0x735e},
	{0xaa92, 0x735f},
	{0xaa93, 0x7361},
	{0xaa94, 0x7362},
	{0xaa95, 0x7363},
	{0xaa96, 0x7364},
	{0xaa97, 0x7365},
	{0xaa98, 0x7366},
	{0xaa99, 0x7367},
	{0xaa9a, 0x7368},
	{0xaa9b, 0x7369},
	{0xaa9c, 0x736a},
	{0xaa9d, 0x736b},
	{0xaa9e, 0x736e},
	{0xaa9f, 0x7370},
	{0xaaa0, 0x7371},
	{0xab40, 0x7372},
	{0xab41, 0x7373},
	{0xab42, 0x7374},
	{0xab43, 0x7375},
	{0xab44, 0x7376},
	{0xab45, 0x7377},
	{0xab46, 0x7378},
	{0xab47, 0x7379},
	{0xab48, 0x737a},
	{0xab49, 0x737b},
	{0xab4a, 0x737c},
	{0xab4b, 0x737d},
	{0xab4c, 0x737f},
	{0xab4d, 0x7380},
	{0xab4e, 0x7381},
	{0xab4f, 0x7382},
	{0xab50, 0x7383},
	{0xab51, 0x7385},
	{0xab52, 0x7386},
	{0xab53, 0x7388},
	{0xab54, 0x738a},
	{0xab55, 0x738c},
	{0xab56, 0x738d},
	{0xab57, 0x738f},
	{0xab58, 0x7390},
	{0xab59, 0x7392},
	{0xab5a, 0x7393},
	{0xab5b, 0x7394},
	{0xab5c, 0x7395},
	{0xab5d, 0x7397},
	{0xab5e, 0x7398},
	{0xab5f, 0x7399},
	{0xab60, 0x739a},
	{0xab61, 0x739c},
	{0xab62, 0x739d},
	{0xab63, 0x739e},
	{0xab64, 0x73a0},
	{0xab65, 0x73a1},
	{0xab66, 0x73a3},
	{0xab67, 0x73a4},
	{0xab68, 0x73a5},
	{0xab69, 0x73a6},
	{0xab6a, 0x73a7},
	{0xab6b, 0x73a8},
	{0xab6c, 0x73aa},
	{0xab6d, 0x73ac},
	{0xab6e, 0x73ad},
	{0xab6f, 0x73b1},
	{0xab70, 0x73b4},
	{0xab71, 0x73b5},
	{0xab72, 0x73b6},
	{0xab73, 0x73b8},
	{0xab74, 0x73b9},
	{0xab75, 0x73bc},
	{0xab76, 0x73bd},
	{0xab77, 0x73be},
	{0xab78, 0x73bf},
	{0xab79, 0x73c1},
	{0xab7a, 0x73c3},
	{0xab7b, 0x73c4},
	{0xab7c, 0x73c5},
	{0xab7d, 0x73c6},
	{0xab7e, 0x73c7},
	{0xab80, 0x73cb},
	{0xab81, 0x73cc},
	{0xab82, 0x73ce},
	{0xab83, 0x73d2},
	{0xab84, 0x73d3},
	{0xab85, 0x73d4},
	{0xab86, 0x73d5},
	{0xab87, 0x73d6},
	{0xab88, 0x73d7},
	{0xab89, 0x73d8},
	{0xab8a, 0x73da},
	{0xab8b, 0x73db},
	{0xab8c, 0x73dc},
	{0xab8d, 0x73dd},
	{0xab8e, 0x73df},
	{0xab8f, 0x73e1},
	{0xab90, 0x73e2},
	{0xab91, 0x73e3},
	{0xab92, 0x73e4},
	{0xab93, 0x73e6},
	{0xab94, 0x73e8},
	{0xab95, 0x73ea},
	{0xab96, 0x73eb},
	{0xab97, 0x73ec},
	{0xab98, 0x73ee},
	{0xab99, 0x73ef},
	{0xab9a, 0x73f0},
	{0xab9b, 0x73f1},
	{0xab9c, 0x73f3},
	{0xab9d, 0x73f4},
	{0xab9e, 0x73f5},
	{0xab9f, 0x73f6},
	{0xaba0, 0x73f7},
	{0xac40, 0x73f8},
	{0xac41, 0x73f9},
	{0xac42, 0x73fa},
	{0xac43, 0x73fb},
	{0xac44, 0x73fc},
	{0xac45, 0x73fd},
	{0xac46, 0x73fe},
	{0xac47, 0x73ff},
	{0xac48, 0x7400},
	{0xac49, 0x7401},
	{0xac4a, 0x7402},
	{0xac4b, 0x7404},
	{0xac4c, 0x7407},
	{0xac4d, 0x7408},
	{0xac4e, 0x740b},
	{0xac4f, 0x740c},
	{0xac50, 0x740d},
	{0xac51, 0x740e},
	{0xac52, 0x7411},
	{0xac53, 0x7412},
	{0xac54, 0x7413},
	{0xac55, 0x7414},
	{0xac56, 0x7415},
	{0xac57, 0x7416},
	{0xac58, 0x7417},
	{0xac59, 0x7418},
	{0xac5a, 0x7419},
	{0xac5b, 0x741c},
	{0xac5c, 0x741d},
	{0xac5d, 0x741e},
	{0xac5e, 0x741f},
	{0xac5f, 0x7420},
	{0xac60, 0x7421},
	{0xac61, 0x7423},
	{0xac62, 0x7424},
	{0xac63, 0x7427},
	{0xac64, 0x7429},
	{0xac65, 0x742b},
	{0xac66, 0x742d},
	{0xac67, 0x742f},
	{0xac68, 0x7431},
	{0xac69, 0x7432},
	{0xac6a, 0x7437},
	{0xac6b, 0x7438},
	{0xac6c, 0x7439},
	{0xac6d, 0x743a},
	{0xac6e, 0x743b},
	{0xac6f, 0x743d},
	{0xac70, 0x743e},
	{0xac71, 0x743f},
	{0xac72, 0x7440},
	{0xac73, 0x7442},
	{0xac74, 0x7443},
	{0xac75, 0x7444},
	{0xac76, 0x7445},
	{0xac77, 0x7446},
	{0xac78, 0x7447},
	{0xac79, 0x7448},
	{0xac7a, 0x7449},
	{0xac7b, 0x744a},
	{0xac7c, 0x744b},
	{0xac7d, 0x744c},
	{0xac7e, 0x744d},
	{0xac80, 0x744e},
	{0xac81, 0x744f},
	{0xac82, 0x7450},
	{0xac83, 0x7451},
	{0xac84, 0x7452},
	{0xac85, 0x7453},
	{0xac86, 0x7454},
	{0xac87, 0x7456},
	{0xac88, 0x7458},
	{0xac89, 0x745d},
	{0xac8a, 0x7460},
	{0xac8b, 0x7461},
	{0xac8c, 0x7462},
	{0xac8d, 0x7463},
	{0xac8e, 0x7464},
	{0xac8f, 0x7465},
	{0xac90, 0x7466},
	{0xac91, 0x7467},
	{0xac92, 0x7468},
	{0xac93, 0x7469},
	{0xac94, 0x746a},
	{0xac95, 0x746b},
	{0xac96, 0x746c},
	{0xac97, 0x746e},
	{0xac98, 0x746f},
	{0xac99, 0x7471},
	{0xac9a, 0x7472},
	{0xac9b, 0x7473},
	{0xac9c, 0x7474},
	{0xac9d, 0x7475},
	{0xac9e, 0x7478},
	{0xac9f, 0x7479},
	{0xaca0, 0x747a},
	{0xad40, 0x747b},
	{0xad41, 0x747c},
	{0xad42, 0x747d},
	{0xad43, 0x747f},
	{0xad44, 0x7482},
	{0xad45, 0x7484},
	{0xad46, 0x7485},
	{0xad47, 0x7486},
	{0xad48, 0x7488},
	{0xad49, 0x7489},
	{0xad4a, 0x748a},
	{0xad4b, 0x748c},
	{0xad4c, 0x748d},
	{0xad4d, 0x748f},
	{0xad4e, 0x7491},
	{0xad4f, 0x7492},
	{0xad50, 0x7493},
	{0xad51, 0x7494},
	{0xad52, 0x7495},
	{0xad53, 0x7496},
	{0xad54, 0x7497},
	{0xad55, 0x7498},
	{0xad56, 0x7499},
	{0xad57, 0x749a},
	{0xad58, 0x749b},
	{0xad59, 0x749d},
	{0xad5a, 0x749f},
	{0xad5b, 0x74a0},
	{0xad5c, 0x74a1},
	{0xad5d, 0x74a2},
	{0xad5e, 0x74a3},
	{0xad5f, 0x74a4},
	{0xad60, 0x74a5},
	{0xad61, 0x74a6},
	{0xad62, 0x74aa},
	{0xad63, 0x74ab},
	{0xad64, 0x74ac},
	{0xad65, 0x74ad},
	{0xad66, 0x74ae},
	{0xad67, 0x74af},
	{0xad68, 0x74b0},
	{0xad69, 0x74b1},
	{0xad6a, 0x74b2},
	{0xad6b, 0x74b3},
	{0xad6c, 0x74b4},
	{0xad6d, 0x74b5},
	{0xad6e, 0x74b6},
	{0xad6f, 0x74b7},
	{0xad70, 0x74b8},
	{0xad71, 0x74b9},
	{0xad72, 0x74bb},
	{0xad73, 0x74bc},
	{0xad74, 0x74bd},
	{0xad75, 0x74be},
	{0xad76, 0x74bf},
	{0xad77, 0x74c0},
	{0xad78, 0x74c1},
	{0xad79, 0x74c2},
	{0xad7a, 0x74c3},
	{0xad7b, 0x74c4},
	{0xad7c, 0x74c5},
	{0xad7d, 0x74c6},
	{0xad7e, 0x74c7},
	{0xad80, 0x74c8},
	{0xad81, 0x74c9},
	{0xad82, 0x74ca},
	{0xad83, 0x74cb},
	{0xad84, 0x74cc},
	{0xad85, 0x74cd},
	{0xad86, 0x74ce},
	{0xad87, 0x74cf},
	{0xad88, 0x74d0},
	{0xad89, 0x74d1},
	{0xad8a, 0x74d3},
	{0xad8b, 0x74d4},
	{0xad8c, 0x74d5},
	{0xad8d, 0x74d6},
	{0xad8e, 0x74d7},
	{0xad8f, 0x74d8},
	{0xad90, 0x74d9},
	{0xad91, 0x74da},
	{0xad92, 0x74db},
	{0xad93, 0x74dd},
	{0xad94, 0x74df},
	{0xad95, 0x74e1},
	{0xad96, 0x74e5},
	{0xad97, 0x74e7},
	{0xad98, 0x74e8},
	{0xad99, 0x74e9},
	{0xad9a, 0x74ea},
	{0xad9b, 0x74eb},
	{0xad9c, 0x74ec},
	{0xad9d, 0x74ed},
	{0xad9e, 0x74f0},
	{0xad9f, 0x74f1},
	{0xada0, 0x74f2},
	{0xae40, 0x74f3},
	{0xae41, 0x74f5},
	{0xae42, 0x74f8},
	{0xae43, 0x74f9},
	{0xae44, 0x74fa},
	{0xae45, 0x74fb},
	{0xae46, 0x74fc},
	{0xae47, 0x74fd},
	{0xae48, 0x74fe},
	{0xae49, 0x7500},
	{0xae4a, 0x7501},
	{0xae4b, 0x7502},
	{0xae4c, 0x7503},
	{0xae4d, 0x7505},
	{0xae4e, 0x7506},
	{0xae4f, 0x7507},
	{0xae50, 0x7508},
	{0xae51, 0x7509},
	{0xae52, 0x750a},
	{0xae53, 0x750b},
	{0xae54, 0x750c},
	{0xae55, 0x750e},
	{0xae56, 0x7510},
	{0xae57, 0x7512},
	{0xae58, 0x7514},
	{0xae59, 0x7515},
	{0xae5a, 0x7516},
	{0xae5b, 0x7517},
	{0xae5c, 0x751b},
	{0xae5d, 0x751d},
	{0xae5e, 0x751e},
	{0xae5f, 0x7520},
	{0xae60, 0x7521},
	{0xae61, 0x7522},
	{0xae62, 0x7523},
	{0xae63, 0x7524},
	{0xae64, 0x7526},
	{0xae65, 0x7527},
	{0xae66, 0x752a},
	{0xae67, 0x752e},
	{0xae68, 0x7534},
	{0xae69, 0x7536},
	{0xae6a, 0x7539},
	{0xae6b, 0x753c},
	{0xae6c, 0x753d},
	{0xae6d, 0x753f},
	{0xae6e, 0x7541},
	{0xae6f, 0x7542},
	{0xae70, 0x7543},
	{0xae71, 0x7544},
	{0xae72, 0x7546},
	{0xae73, 0x7547},
	{0xae74, 0x7549},
	{0xae75, 0x754a},
	{0xae76, 0x754d},
	{0xae77, 0x7550},
	{0xae78, 0x7551},
	{0xae79, 0x7552},
	{0xae7a, 0x7553},
	{0xae7b, 0x7555},
	{0xae7c, 0x7556},
	{0xae7d, 0x7557},
	{0xae7e, 0x7558},
	{0xae80, 0x755d},
	{0xae81, 0x755e},
	{0xae82, 0x755f},
	{0xae83, 0x7560},
	{0xae84, 0x7561},
	{0xae85, 0x7562},
	{0xae86, 0x7563},
	{0xae87, 0x7564},
	{0xae88, 0x7567},
	{0xae89, 0x7568},
	{0xae8a, 0x7569},
	{0xae8b, 0x756b},
	{0xae8c, 0x756c},
	{0xae8d, 0x756d},
	{0xae8e, 0x756e},
	{0xae8f, 0x756f},
	{0xae90, 0x7570},
	{0xae91, 0x7571},
	{0xae92, 0x7573},
	{0xae93, 0x7575},
	{0xae94, 0x7576},
	{0xae95, 0x7577},
	{0xae96, 0x757a},
	{0xae97, 0x757b},
	{0xae98, 0x757c},
	{0xae99, 0x757d},
	{0xae9a, 0x757e},
	{0xae9b, 0x7580},
	{0xae9c, 0x7581},
	{0xae9d, 0x7582},
	{0xae9e, 0x7584},
	{0xae9f, 0x7585},
	{0xaea0, 0x7587},
	{0xaf40, 0x7588},
	{0xaf41, 0x7589},
	{0xaf42, 0x758a},
	{0xaf43, 0x758c},
	{0xaf44, 0x758d},
	{0xaf45, 0x758e},
	{0xaf46, 0x7590},
	{0xaf47, 0x7593},
	{0xaf48, 0x7595},
	{0xaf49, 0x7598},
	{0xaf4a, 0x759b},
	{0xaf4b, 0x759c},
	{0xaf4c, 0x759e},
	{0xaf4d, 0x75a2},
	{0xaf4e, 0x75a6},
	{0xaf4f, 0x75a7},
	{0xaf50, 0x75a8},
	{0xaf51, 0x75a9},
	{0xaf52, 0x75aa},
	{0xaf53, 0x75ad},
	{0xaf54, 0x75b6},
	{0xaf55, 0x75b7},
	{0xaf56, 0x75ba},
	{0xaf57, 0x75bb},
	{0xaf58, 0x75bf},
	{0xaf59, 0x75c0},
	{0xaf5a, 0x75c1},
	{0xaf5b, 0x75c6},
	{0xaf5c, 0x75cb},
	{0xaf5d, 0x75cc},
	{0xaf5e, 0x75ce},
	{0xaf5f, 0x75cf},
	{0xaf60, 0x75d0},
	{0xaf61, 0x75d1},
	{0xaf62, 0x75d3},
	{0xaf63, 0x75d7},
	{0xaf64, 0x75d9},
	{0xaf65, 0x75da},
	{0xaf66, 0x75dc},
	{0xaf67, 0x75dd},
	{0xaf68, 0x75df},
	{0xaf69, 0x75e0},
	{0xaf6a, 0x75e1},
	{0xaf6b, 0x75e5},
	{0xaf6c, 0x75e9},
	{0xaf6d, 0x75ec},
	{0xaf6e, 0x75ed},
	{0xaf6f, 0x75ee},
	{0xaf70, 0x75ef},
	{0xaf71, 0x75f2},
	{0xaf72, 0x75f3},
	{0xaf73, 0x75f5},
	{0xaf74, 0x75f6},
	{0xaf75, 0x75f7},
	{0xaf76, 0x75f8},
	{0xaf77, 0x75fa},
	{0xaf78, 0x75fb},
	{0xaf79, 0x75fd},
	{0xaf7a, 0x75fe},
	{0xaf7b, 0x7602},
	{0xaf7c, 0x7604},
	{0xaf7d, 0x7606},
	{0xaf7e, 0x7607},
	{0xaf80, 0x7608},
	{0xaf81, 0x7609},
	{0xaf82, 0x760b},
	{0xaf83, 0x760d},
	{0xaf84, 0x760e},
	{0xaf85, 0x760f},
	{0xaf86, 0x7611},
	{0xaf87, 0x7612},
	{0xaf88, 0x7613},
	{0xaf89, 0x7614},
	{0xaf8a, 0x7616},
	{0xaf8b, 0x761a},
	{0xaf8c, 0x761c},
	{0xaf8d, 0x761d},
	{0xaf8e, 0x761e},
	{0xaf8f, 0x7621},
	{0xaf90, 0x7623},
	{0xaf91, 0x7627},
	{0xaf92, 0x7628},
	{0xaf93, 0x762c},
	{0xaf94, 0x762e},
	{0xaf95, 0x762f},
	{0xaf96, 0x7631},
	{0xaf97, 0x7632},
	{0xaf98, 0x7636},
	{0xaf99, 0x7637},
	{0xaf9a, 0x7639},
	{0xaf9b, 0x763a},
	{0xaf9c, 0x763b},
	{0xaf9d, 0x763d},
	{0xaf9e, 0x7641},
	{0xaf9f, 0x7642},
	{0xafa0, 0x7644},
	{0xb040, 0x7645},
	{0xb041, 0x7646},
	{0xb042, 0x7647},
	{0xb043, 0x7648},
	{0xb044, 0x7649},
	{0xb045, 0x764a},
	{0xb046, 0x764b},
	{0xb047, 0x764e},
	{0xb048, 0x764f},
	{0xb049, 0x7650},
	{0xb04a, 0x7651},
	{0xb04b, 0x7652},
	{0xb04c, 0x7653},
	{0xb04d, 0x7655},
	{0xb04e, 0x7657},
	{0xb04f, 0x7658},
	{0xb050, 0x7659},
	{0xb051, 0x765a},
	{0xb052, 0x765b},
	{0xb053, 0x765d},
	{0xb054, 0x765f},
	{0xb055, 0x7660},
	{0xb056, 0x7661},
	{0xb057, 0x7662},
	{0xb058, 0x7664},
	{0xb059, 0x7665},
	{0xb05a, 0x7666},
	{0xb05b, 0x7667},
	{0xb05c, 0x7668},
	{0xb05d, 0x7669},
	{0xb05e, 0x766a},
	{0xb05f, 0x766c},
	{0xb060, 0x766d},
	{0xb061, 0x766e},
	{0xb062, 0x7670},
	{0xb063, 0x7671},
	{0xb064, 0x7672},
	{0xb065, 0x7673},
	{0xb066, 0x7674},
	{0xb067, 0x7675},
	{0xb068, 0x7676},
	{0xb069, 0x7677},
	{0xb06a, 0x7679},
	{0xb06b, 0x767a},
	{0xb06c, 0x767c},
	{0xb06d, 0x767f},
	{0xb06e, 0x7680},
	{0xb06f, 0x7681},
	{0xb070, 0x7683},
	{0xb071, 0x7685},
	{0xb072, 0x7689},
	{0xb073, 0x768a},
	{0xb074, 0x768c},
	{0xb075, 0x768d},
	{0xb076, 0x768f},
	{0xb077, 0x7690},
	{0xb078, 0x7692},
	{0xb079, 0x7694},
	{0xb07a, 0x7695},
	{0xb07b, 0x7697},
	{0xb07c, 0x7698},
	{0xb07d, 0x769a},
	{0xb07e, 0x769b},
	{0xb080, 0x769c},
	{0xb081, 0x769d},
	{0xb082, 0x769e},
	{0xb083, 0x769f},
	{0xb084, 0x76a0},
	{0xb085, 0x76a1},
	{0xb086, 0x76a2},
	{0xb087, 0x76a3},
	{0xb088, 0x76a5},
	{0xb089, 0x76a6},
	{0xb08a, 0x76a7},
	{0xb08b, 0x76a8},
	{0xb08c, 0x76a9},
	{0xb08d, 0x76aa},
	{0xb08e, 0x76ab},
	{0xb08f, 0x76ac},
	{0xb090, 0x76ad},
	{0xb091, 0x76af},
	{0xb092, 0x76b0},
	{0xb093, 0x76b3},
	{0xb094, 0x76b5},
	{0xb095, 0x76b6},
	{0xb096, 0x76b7},
	{0xb097, 0x76b8},
	{0xb098, 0x76b9},
	{0xb099, 0x76ba},
	{0xb09a, 0x76bb},
	{0xb09b, 0x76bc},
	{0xb09c, 0x76bd},
	{0xb09d, 0x76be},
	{0xb09e, 0x76c0},
	{0xb09f, 0x76c1},
	{0xb0a0, 0x76c3},
	{0xb0a1, 0x554a},
	{0xb0a2, 0x963f},
	{0xb0a3, 0x57c3},
	{0xb0a4, 0x6328},
	{0xb0a5, 0x54ce},
	{0xb0a6, 0x5509},
	{0xb0a7, 0x54c0},
	{0xb0a8, 0x7691},
	{0xb0a9, 0x764c},
	{0xb0aa, 0x853c},
	{0xb0ab, 0x77ee},
	{0xb0ac, 0x827e},
	{0xb0ad, 0x788d},
	{0xb0ae, 0x7231},
	{0xb0af, 0x9698},
	{0xb0b0, 0x978d},
	{0xb0b1, 0x6c28},
	{0xb0b2, 0x5b89},
	{0xb0b3, 0x4ffa},
	{0xb0b4, 0x6309},
	{0xb0b5, 0x6697},
	{0xb0b6, 0x5cb8},
	{0xb0b7, 0x80fa},
	{0xb0b8, 0x6848},
	{0xb0b9, 0x80ae},
	{0xb0ba, 0x6602},
	{0xb0bb, 0x76ce},
	{0xb0bc, 0x51f9},
	{0xb0bd, 0x6556},
	{0xb0be, 0x71ac},
	{0xb0bf, 0x7ff1},
	{0xb0c0, 0x8884},
	{0xb0c1, 0x50b2},
	{0xb0c2, 0x5965},
	{0xb0c3, 0x61ca},
	{0xb0c4, 0x6fb3},
	{0xb0c5, 0x82ad},
	{0xb0c6, 0x634c},
	{0xb0c7, 0x6252},
	{0xb0c8, 0x53ed},
	{0xb0c9, 0x5427},
	{0xb0ca, 0x7b06},
	{0xb0cb, 0x516b},
	{0xb0cc, 0x75a4},
	{0xb0cd, 0x5df4},
	{0xb0ce, 0x62d4},
	{0xb0cf, 0x8dcb},
	{0xb0d0, 0x9776},
	{0xb0d1, 0x628a},
	{0xb0d2, 0x8019},
	{0xb0d3, 0x575d},
	{0xb0d4, 0x9738},
	{0xb0d5, 0x7f62},
	{0xb0d6, 0x7238},
	{0xb0d7, 0x767d},
	{0xb0d8, 0x67cf},
	{0xb0d9, 0x767e},
	{0xb0da, 0x6446},
	{0xb0db, 0x4f70},
	{0xb0dc, 0x8d25},
	{0xb0dd, 0x62dc},
	{0xb0de, 0x7a17},
	{0xb0df, 0x6591},
	{0xb0e0, 0x73ed},
	{0xb0e1, 0x642c},
	{0xb0e2, 0x6273},
	{0xb0e3, 0x822c},
	{0xb0e4, 0x9881},
	{0xb0e5, 0x677f},
	{0xb0e6, 0x7248},
	{0xb0e7, 0x626e},
	{0xb0e8, 0x62cc},
	{0xb0e9, 0x4f34},
	{0xb0ea, 0x74e3},
	{0xb0eb, 0x534a},
	{0xb0ec, 0x529e},
	{0xb0ed, 0x7eca},
	{0xb0ee, 0x90a6},
	{0xb0ef, 0x5e2e},
	{0xb0f0, 0x6886},
	{0xb0f1, 0x699c},
	{0xb0f2, 0x8180},
	{0xb0f3, 0x7ed1},
	{0xb0f4, 0x68d2},
	{0xb0f5, 0x78c5},
	{0xb0f6, 0x868c},
	{0xb0f7, 0x9551},
	{0xb0f8, 0x508d},
	{0xb0f9, 0x8c24},
	{0xb0fa, 0x82de},
	{0xb0fb, 0x80de},
	{0xb0fc, 0x5305},
	{0xb0fd, 0x8912},
	{0xb0fe, 0x5265},
	{0xb140, 0x76c4},
	{0xb141, 0x76c7},
	{0xb142, 0x76c9},
	{0xb143, 0x76cb},
	{0xb144, 0x76cc},
	{0xb145, 0x76d3},
	{0xb146, 0x76d5},
	{0xb147, 0x76d9},
	{0xb148, 0x76da},
	{0xb149, 0x76dc},
	{0xb14a, 0x76dd},
	{0xb14b, 0x76de},
	{0xb14c, 0x76e0},
	{0xb14d, 0x76e1},
	{0xb14e, 0x76e2},
	{0xb14f, 0x76e3},
	{0xb150, 0x76e4},
	{0xb151, 0x76e6},
	{0xb152, 0x76e7},
	{0xb153, 0x76e8},
	{0xb154, 0x76e9},
	{0xb155, 0x76ea},
	{0xb156, 0x76eb},
	{0xb157, 0x76ec},
	{0xb158, 0x76ed},
	{0xb159, 0x76f0},
	{0xb15a, 0x76f3},
	{0xb15b, 0x76f5},
	{0xb15c, 0x76f6},
	{0xb15d, 0x76f7},
	{0xb15e, 0x76fa},
	{0xb15f, 0x76fb},
	{0xb160, 0x76fd},
	{0xb161, 0x76ff},
	{0xb162, 0x7700},
	{0xb163, 0x7702},
	{0xb164, 0x7703},
	{0xb165, 0x7705},
	{0xb166, 0x7706},
	{0xb167, 0x770a},
	{0xb168, 0x770c},
	{0xb169, 0x770e},
	{0xb16a, 0x770f},
	{0xb16b, 0x7710},
	{0xb16c, 0x7711},
	{0xb16d, 0x7712},
	{0xb16e, 0x7713},
	{0xb16f, 0x7714},
	{0xb170, 0x7715},
	{0xb171, 0x7716},
	{0xb172, 0x7717},
	{0xb173, 0x7718},
	{0xb174, 0x771b},
	{0xb175, 0x771c},
	{0xb176, 0x771d},
	{0xb177, 0x771e},
	{0xb178, 0x7721},
	{0xb179, 0x7723},
	{0xb17a, 0x7724},
	{0xb17b, 0x7725},
	{0xb17c, 0x7727},
	{0xb17d, 0x772a},
	{0xb17e, 0x772b},
	{0xb180, 0x772c},
	{0xb181, 0x772e},
	{0xb182, 0x7730},
	{0xb183, 0x7731},
	{0xb184, 0x7732},
	{0xb185, 0x7733},
	{0xb186, 0x7734},
	{0xb187, 0x7739},
	{0xb188, 0x773b},
	{0xb189, 0x773d},
	{0xb18a, 0x773e},
	{0xb18b, 0x773f},
	{0xb18c, 0x7742},
	{0xb18d, 0x7744},
	{0xb18e, 0x7745},
	{0xb18f, 0x7746},
	{0xb190, 0x7748},
	{0xb191, 0x7749},
	{0xb192, 0x774a},
	{0xb193, 0x774b},
	{0xb194, 0x774c},
	{0xb195, 0x774d},
	{0xb196, 0x774e},
	{0xb197, 0x774f},
	{0xb198, 0x7752},
	{0xb199, 0x7753},
	{0xb19a, 0x7754},
	{0xb19b, 0x7755},
	{0xb19c, 0x7756},
	{0xb19d, 0x7757},
	{0xb19e, 0x7758},
	{0xb19f, 0x7759},
	{0xb1a0, 0x775c},
	{0xb1a1, 0x8584},
	{0xb1a2, 0x96f9},
	{0xb1a3, 0x4fdd},
	{0xb1a4, 0x5821},
	{0xb1a5, 0x9971},
	{0xb1a6, 0x5b9d},
	{0xb1a7, 0x62b1},
	{0xb1a8, 0x62a5},
	{0xb1a9, 0x66b4},
	{0xb1aa, 0x8c79},
	{0xb1ab, 0x9c8d},
	{0xb1ac, 0x7206},
	{0xb1ad, 0x676f},
	{0xb1ae, 0x7891},
	{0xb1af, 0x60b2},
	{0xb1b0, 0x5351},
	{0xb1b1, 0x5317},
	{0xb1b2, 0x8f88},
	{0xb1b3, 0x80cc},
	{0xb1b4, 0x8d1d},
	{0xb1b5, 0x94a1},
	{0xb1b6, 0x500d},
	{0xb1b7, 0x72c8},
	{0xb1b8, 0x5907},
	{0xb1b9, 0x60eb},
	{0xb1ba, 0x7119},
	{0xb1bb, 0x88ab},
	{0xb1bc, 0x5954},
	{0xb1bd, 0x82ef},
	{0xb1be, 0x672c},
	{0xb1bf, 0x7b28},
	{0xb1c0, 0x5d29},
	{0xb1c1, 0x7ef7},
	{0xb1c2, 0x752d},
	{0xb1c3, 0x6cf5},
	{0xb1c4, 0x8e66},
	{0xb1c5, 0x8ff8},
	{0xb1c6, 0x903c},
	{0xb1c7, 0x9f3b},
	{0xb1c8, 0x6bd4},
	{0xb1c9, 0x9119},
	{0xb1ca, 0x7b14},
	{0xb1cb, 0x5f7c},
	{0xb1cc, 0x78a7},
	{0xb1cd, 0x84d6},
	{0xb1ce, 0x853d},
	{0xb1cf, 0x6bd5},
	{0xb1d0, 0x6bd9},
	{0xb1d1, 0x6bd6},
	{0xb1d2, 0x5e01},
	{0xb1d3, 0x5e87},
	{0xb1d4, 0x75f9},
	{0xb1d5, 0x95ed},
	{0xb1d6, 0x655d},
	{0xb1d7, 0x5f0a},
	{0xb1d8, 0x5fc5},
	{0xb1d9, 0x8f9f},
	{0xb1da, 0x58c1},
	{0xb1db, 0x81c2},
	{0xb1dc, 0x907f},
	{0xb1dd, 0x965b},
	{0xb1de, 0x97ad},
	{0xb1df, 0x8fb9},
	{0xb1e0, 0x7f16},
	{0xb1e1, 0x8d2c},
	{0xb1e2, 0x6241},
	{0xb1e3, 0x4fbf},
	{0xb1e4, 0x53d8},
	{0xb1e5, 0x535e},
	{0xb1e6, 0x8fa8},
	{0xb1e7, 0x8fa9},
	{0xb1e8, 0x8fab},
	{0xb1e9, 0x904d},
	{0xb1ea, 0x6807},
	{0xb1eb, 0x5f6a},
	{0xb1ec, 0x8198},
	{0xb1ed, 0x8868},
	{0xb1ee, 0x9cd6},
	{0xb1ef, 0x618b},
	{0xb1f0, 0x522b},
	{0xb1f1, 0x762a},
	{0xb1f2, 0x5f6c},
	{0xb1f3, 0x658c},
	{0xb1f4, 0x6fd2},
	{0xb1f5, 0x6ee8},
	{0xb1f6, 0x5bbe},
	{0xb1f7, 0x6448},
	{0xb1f8, 0x5175},
	{0xb1f9, 0x51b0},
	{0xb1fa, 0x67c4},
	{0xb1fb, 0x4e19},
	{0xb1fc, 0x79c9},
	{0xb1fd, 0x997c},
	{0xb1fe, 0x70b3},
	{0xb240, 0x775d},
	{0xb241, 0x775e},
	{0xb242, 0x775f},
	{0xb243, 0x7760},
	{0xb244, 0x7764},
	{0xb245, 0x7767},
	{0xb246, 0x7769},
	{0xb247, 0x776a},
	{0xb248, 0x776d},
	{0xb249, 0x776e},
	{0xb24a, 0x776f},
	{0xb24b, 0x7770},
	{0xb24c, 0x7771},
	{0xb24d, 0x7772},
	{0xb24e, 0x7773},
	{0xb24f, 0x7774},
	{0xb250, 0x7775},
	{0xb251, 0x7776},
	{0xb252, 0x7777},
	{0xb253, 0x7778},
	{0xb254, 0x777a},
	{0xb255, 0x777b},
	{0xb256, 0x777c},
	{0xb257, 0x7781},
	{0xb258, 0x7782},
	{0xb259, 0x7783},
	{0xb25a, 0x7786},
	{0xb25b, 0x7787},
	{0xb25c, 0x7788},
	{0xb25d, 0x7789},
	{0xb25e, 0x778a},
	{0xb25f, 0x778b},
	{0xb260, 0x778f},
	{0xb261, 0x7790},
	{0xb262, 0x7793},
	{0xb263, 0x7794},
	{0xb264, 0x7795},
	{0xb265, 0x7796},
	{0xb266, 0x7797},
	{0xb267, 0x7798},
	{0xb268, 0x7799},
	{0xb269, 0x779a},
	{0xb26a, 0x779b},
	{0xb26b, 0x779c},
	{0xb26c, 0x779d},
	{0xb26d, 0x779e},
	{0xb26e, 0x77a1},
	{0xb26f, 0x77a3},
	{0xb270, 0x77a4},
	{0xb271, 0x77a6},
	{0xb272, 0x77a8},
	{0xb273, 0x77ab},
	{0xb274, 0x77ad},
	{0xb275, 0x77ae},
	{0xb276, 0x77af},
	{0xb277, 0x77b1},
	{0xb278, 0x77b2},
	{0xb279, 0x77b4},
	{0xb27a, 0x77b6},
	{0xb27b, 0x77b7},
	{0xb27c, 0x77b8},
	{0xb27d, 0x77b9},
	{0xb27e, 0x77ba},
	{0xb280, 0x77bc},
	{0xb281, 0x77be},
	{0xb282, 0x77c0},
	{0xb283, 0x77c1},
	{0xb284, 0x77c2},
	{0xb285, 0x77c3},
	{0xb286, 0x77c4},
	{0xb287, 0x77c5},
	{0xb288, 0x77c6},
	{0xb289, 0x77c7},
	{0xb28a, 0x77c8},
	{0xb28b, 0x77c9},
	{0xb28c, 0x77ca},
	{0xb28d, 0x77cb},
	{0xb28e, 0x77cc},
	{0xb28f, 0x77ce},
	{0xb290, 0x77cf},
	{0xb291, 0x77d0},
	{0xb292, 0x77d1},
	{0xb293, 0x77d2},
	{0xb294, 0x77d3},
	{0xb295, 0x77d4},
	{0xb296, 0x77d5},
	{0xb297, 0x77d6},
	{0xb298, 0x77d8},
	{0xb299, 0x77d9},
	{0xb29a, 0x77da},
	{0xb29b, 0x77dd},
	{0xb29c, 0x77de},
	{0xb29d, 0x77df},
	{0xb29e, 0x77e0},
	{0xb29f, 0x77e1},
	{0xb2a0, 0x77e4},
	{0xb2a1, 0x75c5},
	{0xb2a2, 0x5e76},
	{0xb2a3, 0x73bb},
	{0xb2a4, 0x83e0},
	{0xb2a5, 0x64ad},
	{0xb2a6, 0x62e8},
	{0xb2a7, 0x94b5},
	{0xb2a8, 0x6ce2},
	{0xb2a9, 0x535a},
	{0xb2aa, 0x52c3},
	{0xb2ab, 0x640f},
	{0xb2ac, 0x94c2},
	{0xb2ad, 0x7b94},
	{0xb2ae, 0x4f2f},
	{0xb2af, 0x5e1b},
	{0xb2b0, 0x8236},
	{0xb2b1, 0x8116},
	{0xb2b2, 0x818a},
	{0xb2b3, 0x6e24},
	{0xb2b4, 0x6cca},
	{0xb2b5, 0x9a73},
	{0xb2b6, 0x6355},
	{0xb2b7, 0x535c},
	{0xb2b8, 0x54fa},
	{0xb2b9, 0x8865},
	{0xb2ba, 0x57e0},
	{0xb2bb, 0x4e0d},
	{0xb2bc, 0x5e03},
	{0xb2bd, 0x6b65},
	{0xb2be, 0x7c3f},
	{0xb2bf, 0x90e8},
	{0xb2c0, 0x6016},
	{0xb2c1, 0x64e6},
	{0xb2c2, 0x731c},
	{0xb2c3, 0x88c1},
	{0xb2c4, 0x6750},
	{0xb2c5, 0x624d},
	{0xb2c6, 0x8d22},
	{0xb2c7, 0x776c},
	{0xb2c8, 0x8e29},
	{0xb2c9, 0x91c7},
	{0xb2ca, 0x5f69},
	{0xb2cb, 0x83dc},
	{0xb2cc, 0x8521},
	{0xb2cd, 0x9910},
	{0xb2ce, 0x53c2},
	{0xb2cf, 0x8695},
	{0xb2d0, 0x6b8b},
	{0xb2d1, 0x60ed},
	{0xb2d2, 0x60e8},
	{0xb2d3, 0x707f},
	{0xb2d4, 0x82cd},
	{0xb2d5, 0x8231},
	{0xb2d6, 0x4ed3},
	{0xb2d7, 0x6ca7},
	{0xb2d8, 0x85cf},
	{0xb2d9, 0x64cd},
	{0xb2da, 0x7cd9},
	{0xb2db, 0x69fd},
	{0xb2dc, 0x66f9},
	{0xb2dd, 0x8349},
	{0xb2de, 0x5395},
	{0xb2df, 0x7b56},
	{0xb2e0, 0x4fa7},
	{0xb2e1, 0x518c},
	{0xb2e2, 0x6d4b},
	{0xb2e3, 0x5c42},
	{0xb2e4, 0x8e6d},
	{0xb2e5, 0x63d2},
	{0xb2e6, 0x53c9},
	{0xb2e7, 0x832c},
	{0xb2e8, 0x8336},
	{0xb2e9, 0x67e5},
	{0xb2ea, 0x78b4},
	{0xb2eb, 0x643d},
	{0xb2ec, 0x5bdf},
	{0xb2ed, 0x5c94},
	{0xb2ee, 0x5dee},
	{0xb2ef, 0x8be7},
	{0xb2f0, 0x62c6},
	{0xb2f1, 0x67f4},
	{0xb2f2, 0x8c7a},
	{0xb2f3, 0x6400},
	{0xb2f4, 0x63ba},
	{0xb2f5, 0x8749},
	{0xb2f6, 0x998b},
	{0xb2f7, 0x8c17},
	{0xb2f8, 0x7f20},
	{0xb2f9, 0x94f2},
	{0xb2fa, 0x4ea7},
	{0xb2fb, 0x9610},
	{0xb2fc, 0x98a4},
	{0xb2fd, 0x660c},
	{0xb2fe, 0x7316},
	{0xb340, 0x77e6},
	{0xb341, 0x77e8},
	{0xb342, 0x77ea},
	{0xb343, 0x77ef},
	{0xb344, 0x77f0},
	{0xb345, 0x77f1},
	{0xb346, 0x77f2},
	{0xb347, 0x77f4},
	{0xb348, 0x77f5},
	{0xb349, 0x77f7},
	{0xb34a, 0x77f9},
	{0xb34b, 0x77fa},
	{0xb34c, 0x77fb},
	{0xb34d, 0x77fc},
	{0xb34e, 0x7803},
	{0xb34f, 0x7804},
	{0xb350, 0x7805},
	{0xb351, 0x7806},
	{0xb352, 0x7807},
	{0xb353, 0x7808},
	{0xb354, 0x780a},
	{0xb355, 0x780b},
	{0xb356, 0x780e},
	{0xb357, 0x780f},
	{0xb358, 0x7810},
	{0xb359, 0x7813},
	{0xb35a, 0x7815},
	{0xb35b, 0x7819},
	{0xb35c, 0x781b},
	{0xb35d, 0x781e},
	{0xb35e, 0x7820},
	{0xb35f, 0x7821},
	{0xb360, 0x7822},
	{0xb361, 0x7824},
	{0xb362, 0x7828},
	{0xb363, 0x782a},
	{0xb364, 0x782b},
	{0xb365, 0x782e},
	{0xb366, 0x782f},
	{0xb367, 0x7831},
	{0xb368, 0x7832},
	{0xb369, 0x7833},
	{0xb36a, 0x7835},
	{0xb36b, 0x7836},
	{0xb36c, 0x783d},
	{0xb36d, 0x783f},
	{0xb36e, 0x7841},
	{0xb36f, 0x7842},
	{0xb370, 0x7843},
	{0xb371, 0x7844},
	{0xb372, 0x7846},
	{0xb373, 0x7848},
	{0xb374, 0x7849},
	{0xb375, 0x784a},
	{0xb376, 0x784b},
	{0xb377, 0x784d},
	{0xb378, 0x784f},
	{0xb379, 0x7851},
	{0xb37a, 0x7853},
	{0xb37b, 0x7854},
	{0xb37c, 0x7858},
	{0xb37d, 0x7859},
	{0xb37e, 0x785a},
	{0xb380, 0x785b},
	{0xb381, 0x785c},
	{0xb382, 0x785e},
	{0xb383, 0x785f},
	{0xb384, 0x7860},
	{0xb385, 0x7861},
	{0xb386, 0x7862},
	{0xb387, 0x7863},
	{0xb388, 0x7864},
	{0xb389, 0x7865},
	{0xb38a, 0x7866},
	{0xb38b, 0x7867},
	{0xb38c, 0x7868},
	{0xb38d, 0x7869},
	{0xb38e, 0x786f},
	{0xb38f, 0x7870},
	{0xb390, 0x7871},
	{0xb391, 0x7872},
	{0xb392, 0x7873},
	{0xb393, 0x7874},
	{0xb394, 0x7875},
	{0xb395, 0x7876},
	{0xb396, 0x7878},
	{0xb397, 0x7879},
	{0xb398, 0x787a},
	{0xb399, 0x787b},
	{0xb39a, 0x787d},
	{0xb39b, 0x787e},
	{0xb39c, 0x787f},
	{0xb39d, 0x7880},
	{0xb39e, 0x7881},
	{0xb39f, 0x7882},
	{0xb3a0, 0x7883},
	{0xb3a1, 0x573a},
	{0xb3a2, 0x5c1d},
	{0xb3a3, 0x5e38},
	{0xb3a4, 0x957f},
	{0xb3a5, 0x507f},
	{0xb3a6, 0x80a0},
	{0xb3a7, 0x5382},
	{0xb3a8, 0x655e},
	{0xb3a9, 0x7545},
	{0xb3aa, 0x5531},
	{0xb3ab, 0x5021},
	{0xb3ac, 0x8d85},
	{0xb3ad, 0x6284},
	{0xb3ae, 0x949e},
	{0xb3af, 0x671d},
	{0xb3b0, 0x5632},
	{0xb3b1, 0x6f6e},
	{0xb3b2, 0x5de2},
	{0xb3b3, 0x5435},
	{0xb3b4, 0x7092},
	{0xb3b5, 0x8f66},
	{0xb3b6, 0x626f},
	{0xb3b7, 0x64a4},
	{0xb3b8, 0x63a3},
	{0xb3b9, 0x5f7b},
	{0xb3ba, 0x6f88},
	{0xb3bb, 0x90f4},
	{0xb3bc, 0x81e3},
	{0xb3bd, 0x8fb0},
	{0xb3be, 0x5c18},
	{0xb3bf, 0x6668},
	{0xb3c0, 0x5ff1},
	{0xb3c1, 0x6c89},
	{0xb3c2, 0x9648},
	{0xb3c3, 0x8d81},
	{0xb3c4, 0x886c},
	{0xb3c5, 0x6491},
	{0xb3c6, 0x79f0},
	{0xb3c7, 0x57ce},
	{0xb3c8, 0x6a59},
	{0xb3c9, 0x6210},
	{0xb3ca, 0x5448},
	{0xb3cb, 0x4e58},
	{0xb3cc, 0x7a0b},
	{0xb3cd, 0x60e9},
	{0xb3ce, 0x6f84},
	{0xb3cf, 0x8bda},
	{0xb3d0, 0x627f},
	{0xb3d1, 0x901e},
	{0xb3d2, 0x9a8b},
	{0xb3d3, 0x79e4},
	{0xb3d4, 0x5403},
	{0xb3d5, 0x75f4},
	{0xb3d6, 0x6301},
	{0xb3d7, 0x5319},
	{0xb3d8, 0x6c60},
	{0xb3d9, 0x8fdf},
	{0xb3da, 0x5f1b},
	{0xb3db, 0x9a70},
	{0xb3dc, 0x803b},
	{0xb3dd, 0x9f7f},
	{0xb3de, 0x4f88},
	{0xb3df, 0x5c3a},
	{0xb3e0, 0x8d64},
	{0xb3e1, 0x7fc5},
	{0xb3e2, 0x65a5},
	{0xb3e3, 0x70bd},
	{0xb3e4, 0x5145},
	{0xb3e5, 0x51b2},
	{0xb3e6, 0x866b},
	{0xb3e7, 0x5d07},
	{0xb3e8, 0x5ba0},
	{0xb3e9, 0x62bd},
	{0xb3ea, 0x916c},
	{0xb3eb, 0x7574},
	{0xb3ec, 0x8e0c},
	{0xb3ed, 0x7a20},
	{0xb3ee, 0x6101},
	{0xb3ef, 0x7b79},
	{0xb3f0, 0x4ec7},
	{0xb3f1, 0x7ef8},
	{0xb3f2, 0x7785},
	{0xb3f3, 0x4e11},
	{0xb3f4, 0x81ed},
	{0xb3f5, 0x521d},
	{0xb3f6, 0x51fa},
	{0xb3f7, 0x6a71},
	{0xb3f8, 0x53a8},
	{0xb3f9, 0x8e87},
	{0xb3fa, 0x9504},
	{0xb3fb, 0x96cf},
	{0xb3fc, 0x6ec1},
	{0xb3fd, 0x9664},
	{0xb3fe, 0x695a},
	{0xb440, 0x7884},
	{0xb441, 0x7885},
	{0xb442, 0x7886},
	{0xb443, 0x7888},
	{0xb444, 0x788a},
	{0xb445, 0x788b},
	{0xb446, 0x788f},
	{0xb447, 0x7890},
	{0xb448, 0x7892},
	{0xb449, 0x7894},
	{0xb44a, 0x7895},
	{0xb44b, 0x7896},
	{0xb44c, 0x7899},
	{0xb44d, 0x789d},
	{0xb44e, 0x789e},
	{0xb44f, 0x78a0},
	{0xb450, 0x78a2},
	{0xb451, 0x78a4},
	{0xb452, 0x78a6},
	{0xb453, 0x78a8},
	{0xb454, 0x78a9},
	{0xb455, 0x78aa},
	{0xb456, 0x78ab},
	{0xb457, 0x78ac},
	{0xb458, 0x78ad},
	{0xb459, 0x78ae},
	{0xb45a, 0x78af},
	{0xb45b, 0x78b5},
	{0xb45c, 0x78b6},
	{0xb45d, 0x78b7},
	{0xb45e, 0x78b8},
	{0xb45f, 0x78ba},
	{0xb460, 0x78bb},
	{0xb461, 0x78bc},
	{0xb462, 0x78bd},
	{0xb463, 0x78bf},
	{0xb464, 0x78c0},
	{0xb465, 0x78c2},
	{0xb466, 0x78c3},
	{0xb467, 0x78c4},
	{0xb468, 0x78c6},
	{0xb469, 0x78c7},
	{0xb46a, 0x78c8},
	{0xb46b, 0x78cc},
	{0xb46c, 0x78cd},
	{0xb46d, 0x78ce},
	{0xb46e, 0x78cf},
	{0xb46f, 0x78d1},
	{0xb470, 0x78d2},
	{0xb471, 0x78d3},
	{0xb472, 0x78d6},
	{0xb473, 0x78d7},
	{0xb474, 0x78d8},
	{0xb475, 0x78da},
	{0xb476, 0x78db},
	{0xb477, 0x78dc},
	{0xb478, 0x78dd},
	{0xb479, 0x78de},
	{0xb47a, 0x78df},
	{0xb47b, 0x78e0},
	{0xb47c, 0x78e1},
	{0xb47d, 0x78e2},
	{0xb47e, 0x78e3},
	{0xb480, 0x78e4},
	{0xb481, 0x78e5},
	{0xb482, 0x78e6},
	{0xb483, 0x78e7},
	{0xb484, 0x78e9},
	{0xb485, 0x78ea},
	{0xb486, 0x78eb},
	{0xb487, 0x78ed},
	{0xb488, 0x78ee},
	{0xb489, 0x78ef},
	{0xb48a, 0x78f0},
	{0xb48b, 0x78f1},
	{0xb48c, 0x78f3},
	{0xb48d, 0x78f5},
	{0xb48e, 0x78f6},
	{0xb48f, 0x78f8},
	{0xb490, 0x78f9},
	{0xb491, 0x78fb},
	{0xb492, 0x78fc},
	{0xb493, 0x78fd},
	{0xb494, 0x78fe},
	{0xb495, 0x78ff},
	{0xb496, 0x7900},
	{0xb497, 0x7902},
	{0xb498, 0x7903},
	{0xb499, 0x7904},
	{0xb49a, 0x7906},
	{0xb49b, 0x7907},
	{0xb49c, 0x7908},
	{0xb49d, 0x7909},
	{0xb49e, 0x790a},
	{0xb49f, 0x790b},
	{0xb4a0, 0x790c},
	{0xb4a1, 0x7840},
	{0xb4a2, 0x50a8},
	{0xb4a3, 0x77d7},
	{0xb4a4, 0x6410},
	{0xb4a5, 0x89e6},
	{0xb4a6, 0x5904},
	{0xb4a7, 0x63e3},
	{0xb4a8, 0x5ddd},
	{0xb4a9, 0x7a7f},
	{0xb4aa, 0x693d},
	{0xb4ab, 0x4f20},
	{0xb4ac, 0x8239},
	{0xb4ad, 0x5598},
	{0xb4ae, 0x4e32},
	{0xb4af, 0x75ae},
	{0xb4b0, 0x7a97},
	{0xb4b1, 0x5e62},
	{0xb4b2, 0x5e8a},
	{0xb4b3, 0x95ef},
	{0xb4b4, 0x521b},
	{0xb4b5, 0x5439},
	{0xb4b6, 0x708a},
	{0xb4b7, 0x6376},
	{0xb4b8, 0x9524},
	{0xb4b9, 0x5782},
	{0xb4ba, 0x6625},
	{0xb4bb, 0x693f},
	{0xb4bc, 0x9187},
	{0xb4bd, 0x5507},
	{0xb4be, 0x6df3},
	{0xb4bf, 0x7eaf},
	{0xb4c0, 0x8822},
	{0xb4c1, 0x6233},
	{0xb4c2, 0x7ef0},
	{0xb4c3, 0x75b5},
	{0xb4c4, 0x8328},
	{0xb4c5, 0x78c1},
	{0xb4c6, 0x96cc},
	{0xb4c7, 0x8f9e},
	{0xb4c8, 0x6148},
	{0xb4c9, 0x74f7},
	{0xb4ca, 0x8bcd},
	{0xb4cb, 0x6b64},
	{0xb4cc, 0x523a},
	{0xb4cd, 0x8d50},
	{0xb4ce, 0x6b21},
	{0xb4cf, 0x806a},
	{0xb4d0, 0x8471},
	{0xb4d1, 0x56f1},
	{0xb4d2, 0x5306},
	{0xb4d3, 0x4ece},
	{0xb4d4, 0x4e1b},
	{0xb4d5, 0x51d1},
	{0xb4d6, 0x7c97},
	{0xb4d7, 0x918b},
	{0xb4d8, 0x7c07},
	{0xb4d9, 0x4fc3},
	{0xb4da, 0x8e7f},
	{0xb4db, 0x7be1},
	{0xb4dc, 0x7a9c},
	{0xb4dd, 0x6467},
	{0xb4de, 0x5d14},
	{0xb4df, 0x50ac},
	{0xb4e0, 0x8106},
	{0xb4e1, 0x7601},
	{0xb4e2, 0x7cb9},
	{0xb4e3, 0x6dec},
	{0xb4e4, 0x7fe0},
	{0xb4e5, 0x6751},
	{0xb4e6, 0x5b58},
	{0xb4e7, 0x5bf8},
	{0xb4e8, 0x78cb},
	{0xb4e9, 0x64ae},
	{0xb4ea, 0x6413},
	{0xb4eb, 0x63aa},
	{0xb4ec, 0x632b},
	{0xb4ed, 0x9519},
	{0xb4ee, 0x642d},
	{0xb4ef, 0x8fbe},
	{0xb4f0, 0x7b54},
	{0xb4f1, 0x7629},
	{0xb4f2, 0x6253},
	{0xb4f3, 0x5927},
	{0xb4f4, 0x5446},
	{0xb4f5, 0x6b79},
	{0xb4f6, 0x50a3},
	{0xb4f7, 0x6234},
	{0xb4f8, 0x5e26},
	{0xb4f9, 0x6b86},
	{0xb4fa, 0x4ee3},
	{0xb4fb, 0x8d37},
	{0xb4fc, 0x888b},
	{0xb4fd, 0x5f85},
	{0xb4fe, 0x902e},
	{0xb540, 0x790d},
	{0xb541, 0x790e},
	{0xb542, 0x790f},
	{0xb543, 0x7910},
	{0xb544, 0x7911},
	{0xb545, 0x7912},
	{0xb546, 0x7914},
	{0xb547, 0x7915},
	{0xb548, 0x7916},
	{0xb549, 0x7917},
	{0xb54a, 0x7918},
	{0xb54b, 0x7919},
	{0xb54c, 0x791a},
	{0xb54d, 0x791b},
	{0xb54e, 0x791c},
	{0xb54f, 0x791d},
	{0xb550, 0x791f},
	{0xb551, 0x7920},
	{0xb552, 0x7921},
	{0xb553, 0x7922},
	{0xb554, 0x7923},
	{0xb555, 0x7925},
	{0xb556, 0x7926},
	{0xb557, 0x7927},
	{0xb558, 0x7928},
	{0xb559, 0x7929},
	{0xb55a, 0x792a},
	{0xb55b, 0x792b},
	{0xb55c, 0x792c},
	{0xb55d, 0x792d},
	{0xb55e, 0x792e},
	{0xb55f, 0x792f},
	{0xb560, 0x7930},
	{0xb561, 0x7931},
	{0xb562, 0x7932},
	{0xb563, 0x7933},
	{0xb564, 0x7935},
	{0xb565, 0x7936},
	{0xb566, 0x7937},
	{0xb567, 0x7938},
	{0xb568, 0x7939},
	{0xb569, 0x793d},
	{0xb56a, 0x793f},
	{0xb56b, 0x7942},
	{0xb56c, 0x7943},
	{0xb56d, 0x7944},
	{0xb56e, 0x7945},
	{0xb56f, 0x7947},
	{0xb570, 0x794a},
	{0xb571, 0x794b},
	{0xb572, 0x794c},
	{0xb573, 0x794d},
	{0xb574, 0x794e},
	{0xb575, 0x794f},
	{0xb576, 0x7950},
	{0xb577, 0x7951},
	{0xb578, 0x7952},
	{0xb579, 0x7954},
	{0xb57a, 0x7955},
	{0xb57b, 0x7958},
	{0xb57c, 0x7959},
	{0xb57d, 0x7961},
	{0xb57e, 0x7963},
	{0xb580, 0x7964},
	{0xb581, 0x7966},
	{0xb582, 0x7969},
	{0xb583, 0x796a},
	{0xb584, 0x796b},
	{0xb585, 0x796c},
	{0xb586, 0x796e},
	{0xb587, 0x7970},
	{0xb588, 0x7971},
	{0xb589, 0x7972},
	{0xb58a, 0x7973},
	{0xb58b, 0x7974},
	{0xb58c, 0x7975},
	{0xb58d, 0x7976},
	{0xb58e, 0x7979},
	{0xb58f, 0x797b},
	{0xb590, 0x797c},
	{0xb591, 0x797d},
	{0xb592, 0x797e},
	{0xb593, 0x797f},
	{0xb594, 0x7982},
	{0xb595, 0x7983},
	{0xb596, 0x7986},
	{0xb597, 0x7987},
	{0xb598, 0x7988},
	{0xb599, 0x7989},
	{0xb59a, 0x798b},
	{0xb59b, 0x798c},
	{0xb59c, 0x798d},
	{0xb59d, 0x798e},
	{0xb59e, 0x7990},
	{0xb59f, 0x7991},
	{0xb5a0, 0x7992},
	{0xb5a1, 0x6020},
	{0xb5a2, 0x803d},
	{0xb5a3, 0x62c5},
	{0xb5a4, 0x4e39},
	{0xb5a5, 0x5355},
	{0xb5a6, 0x90f8},
	{0xb5a7, 0x63b8},
	{0xb5a8, 0x80c6},
	{0xb5a9, 0x65e6},
	{0xb5aa, 0x6c2e},
	{0xb5ab, 0x4f46},
	{0xb5ac, 0x60ee},
	{0xb5ad, 0x6de1},
	{0xb5ae, 0x8bde},
	{0xb5af, 0x5f39},
	{0xb5b0, 0x86cb},
	{0xb5b1, 0x5f53},
	{0xb5b2, 0x6321},
	{0xb5b3, 0x515a},
	{0xb5b4, 0x8361},
	{0xb5b5, 0x6863},
	{0xb5b6, 0x5200},
	{0xb5b7, 0x6363},
	{0xb5b8, 0x8e48},
	{0xb5b9, 0x5012},
	{0xb5ba, 0x5c9b},
	{0xb5bb, 0x7977},
	{0xb5bc, 0x5bfc},
	{0xb5bd, 0x5230},
	{0xb5be, 0x7a3b},
	{0xb5bf, 0x60bc},
	{0xb5c0, 0x9053},
	{0xb5c1, 0x76d7},
	{0xb5c2, 0x5fb7},
	{0xb5c3, 0x5f97},
	{0xb5c4, 0x7684},
	{0xb5c5, 0x8e6c},
	{0xb5c6, 0x706f},
	{0xb5c7, 0x767b},
	{0xb5c8, 0x7b49},
	{0xb5c9, 0x77aa},
	{0xb5ca, 0x51f3},
	{0xb5cb, 0x9093},
	{0xb5cc, 0x5824},
	{0xb5cd, 0x4f4e},
	{0xb5ce, 0x6ef4},
	{0xb5cf, 0x8fea},
	{0xb5d0, 0x654c},
	{0xb5d1, 0x7b1b},
	{0xb5d2, 0x72c4},
	{0xb5d3, 0x6da4},
	{0xb5d4, 0x7fdf},
	{0xb5d5, 0x5ae1},
	{0xb5d6, 0x62b5},
	{0xb5d7, 0x5e95},
	{0xb5d8, 0x5730},
	{0xb5d9, 0x8482},
	{0xb5da, 0x7b2c},
	{0xb5db, 0x5e1d},
	{0xb5dc, 0x5f1f},
	{0xb5dd, 0x9012},
	{0xb5de, 0x7f14},
	{0xb5df, 0x98a0},
	{0xb5e0, 0x6382},
	{0xb5e1, 0x6ec7},
	{0xb5e2, 0x7898},
	{0xb5e3, 0x70b9},
	{0xb5e4, 0x5178},
	{0xb5e5, 0x975b},
	{0xb5e6, 0x57ab},
	{0xb5e7, 0x7535},
	{0xb5e8, 0x4f43},
	{0xb5e9, 0x7538},
	{0xb5ea, 0x5e97},
	{0xb5eb, 0x60e6},
	{0xb5ec, 0x5960},
	{0xb5ed, 0x6dc0},
	{0xb5ee, 0x6bbf},
	{0xb5ef, 0x7889},
	{0xb5f0, 0x53fc},
	{0xb5f1, 0x96d5},
	{0xb5f2, 0x51cb},
	{0xb5f3, 0x5201},
	{0xb5f4, 0x6389},
	{0xb5f5, 0x540a},
	{0xb5f6, 0x9493},
	{0xb5f7, 0x8c03},
	{0xb5f8, 0x8dcc},
	{0xb5f9, 0x7239},
	{0xb5fa, 0x789f},
	{0xb5fb, 0x8776},
	{0xb5fc, 0x8fed},
	{0xb5fd, 0x8c0d},
	{0xb5fe, 0x53e0},
	{0xb640, 0x7993},
	{0xb641, 0x7994},
	{0xb642, 0x7995},
	{0xb643, 0x7996},
	{0xb644, 0x7997},
	{0xb645, 0x7998},
	{0xb646, 0x7999},
	{0xb647, 0x799b},
	{0xb648, 0x799c},
	{0xb649, 0x799d},
	{0xb64a, 0x799e},
	{0xb64b, 0x799f},
	{0xb64c, 0x79a0},
	{0xb64d, 0x79a1},
	{0xb64e, 0x79a2},
	{0xb64f, 0x79a3},
	{0xb650, 0x79a4},
	{0xb651, 0x79a5},
	{0xb652, 0x79a6},
	{0xb653, 0x79a8},
	{0xb654, 0x79a9},
	{0xb655, 0x79aa},
	{0xb656, 0x79ab},
	{0xb657, 0x79ac},
	{0xb658, 0x79ad},
	{0xb659, 0x79ae},
	{0xb65a, 0x79af},
	{0xb65b, 0x79b0},
	{0xb65c, 0x79b1},
	{0xb65d, 0x79b2},
	{0xb65e, 0x79b4},
	{0xb65f, 0x79b5},
	{0xb660, 0x79b6},
	{0xb661, 0x79b7},
	{0xb662, 0x79b8},
	{0xb663, 0x79bc},
	{0xb664, 0x79bf},
	{0xb665, 0x79c2},
	{0xb666, 0x79c4},
	{0xb667, 0x79c5},
	{0xb668, 0x79c7},
	{0xb669, 0x79c8},
	{0xb66a, 0x79ca},
	{0xb66b, 0x79cc},
	{0xb66c, 0x79ce},
	{0xb66d, 0x79cf},
	{0xb66e, 0x79d0},
	{0xb66f, 0x79d3},
	{0xb670, 0x79d4},
	{0xb671, 0x79d6},
	{0xb672, 0x79d7},
	{0xb673, 0x79d9},
	{0xb674, 0x79da},
	{0xb675, 0x79db},
	{0xb676, 0x79dc},
	{0xb677, 0x79dd},
	{0xb678, 0x79de},
	{0xb679, 0x79e0},
	{0xb67a, 0x79e1},
	{0xb67b, 0x79e2},
	{0xb67c, 0x79e5},
	{0xb67d, 0x79e8},
	{0xb67e, 0x79ea},
	{0xb680, 0x79ec},
	{0xb681, 0x79ee},
	{0xb682, 0x79f1},
	{0xb683, 0x79f2},
	{0xb684, 0x79f3},
	{0xb685, 0x79f4},
	{0xb686, 0x79f5},
	{0xb687, 0x79f6},
	{0xb688, 0x79f7},
	{0xb689, 0x79f9},
	{0xb68a, 0x79fa},
	{0xb68b, 0x79fc},
	{0xb68c, 0x79fe},
	{0xb68d, 0x79ff},
	{0xb68e, 0x7a01},
	{0xb68f, 0x7a04},
	{0xb690, 0x7a05},
	{0xb691, 0x7a07},
	{0xb692, 0x7a08},
	{0xb693, 0x7a09},
	{0xb694, 0x7a0a},
	{0xb695, 0x7a0c},
	{0xb696, 0x7a0f},
	{0xb697, 0x7a10},
	{0xb698, 0x7a11},
	{0xb699, 0x7a12},
	{0xb69a, 0x7a13},
	{0xb69b, 0x7a15},
	{0xb69c, 0x7a16},
	{0xb69d, 0x7a18},
	{0xb69e, 0x7a19},
	{0xb69f, 0x7a1b},
	{0xb6a0, 0x7a1c},
	{0xb6a1, 0x4e01},
	{0xb6a2, 0x76ef},
	{0xb6a3, 0x53ee},
	{0xb6a4, 0x9489},
	{0xb6a5, 0x9876},
	{0xb6a6, 0x9f0e},
	{0xb6a7, 0x952d},
	{0xb6a8, 0x5b9a},
	{0xb6a9, 0x8ba2},
	{0xb6aa, 0x4e22},
	{0xb6ab, 0x4e1c},
	{0xb6ac, 0x51ac},
	{0xb6ad, 0x8463},
	{0xb6ae, 0x61c2},
	{0xb6af, 0x52a8},
	{0xb6b0, 0x680b},
	{0xb6b1, 0x4f97},
	{0xb6b2, 0x606b},
	{0xb6b3, 0x51bb},
	{0xb6b4, 0x6d1e},
	{0xb6b5, 0x515c},
	{0xb6b6, 0x6296},
	{0xb6b7, 0x6597},
	{0xb6b8, 0x9661},
	{0xb6b9, 0x8c46},
	{0xb6ba, 0x9017},
	{0xb6bb, 0x75d8},
	{0xb6bc, 0x90fd},
	{0xb6bd, 0x7763},
	{0xb6be, 0x6bd2},
	{0xb6bf, 0x728a},
	{0xb6c0, 0x72ec},
	{0xb6c1, 0x8bfb},
	{0xb6c2, 0x5835},
	{0xb6c3, 0x7779},
	{0xb6c4, 0x8d4c},
	{0xb6c5, 0x675c},
	{0xb6c6, 0x9540},
	{0xb6c7, 0x809a},
	{0xb6c8, 0x5ea6},
	{0xb6c9, 0x6e21},
	{0xb6ca, 0x5992},
	{0xb6cb, 0x7aef},
	{0xb6cc, 0x77ed},
	{0xb6cd, 0x953b},
	{0xb6ce, 0x6bb5},
	{0xb6cf, 0x65ad},
	{0xb6d0, 0x7f0e},
	{0xb6d1, 0x5806},
	{0xb6d2, 0x5151},
	{0xb6d3, 0x961f},
	{0xb6d4, 0x5bf9},
	{0xb6d5, 0x58a9},
	{0xb6d6, 0x5428},
	{0xb6d7, 0x8e72},
	{0xb6d8, 0x6566},
	{0xb6d9, 0x987f},
	{0xb6da, 0x56e4},
	{0xb6db, 0x949d},
	{0xb6dc, 0x76fe},
	{0xb6dd, 0x9041},
	{0xb6de, 0x6387},
	{0xb6df, 0x54c6},
	{0xb6e0, 0x591a},
	{0xb6e1, 0x593a},
	{0xb6e2, 0x579b},
	{0xb6e3, 0x8eb2},
	{0xb6e4, 0x6735},
	{0xb6e5, 0x8dfa},
	{0xb6e6, 0x8235},
	{0xb6e7, 0x5241},
	{0xb6e8, 0x60f0},
	{0xb6e9, 0x5815},
	{0xb6ea, 0x86fe},
	{0xb6eb, 0x5ce8},
	{0xb6ec, 0x9e45},
	{0xb6ed, 0x4fc4},
	{0xb6ee, 0x989d},
	{0xb6ef, 0x8bb9},
	{0xb6f0, 0x5a25},
	{0xb6f1, 0x6076},
	{0xb6f2, 0x5384},
	{0xb6f3, 0x627c},
	{0xb6f4, 0x904f},
	{0xb6f5, 0x9102},
	{0xb6f6, 0x997f},
	{0xb6f7, 0x6069},
	{0xb6f8, 0x800c},
	{0xb6f9, 0x513f},
	{0xb6fa, 0x8033},
	{0xb6fb, 0x5c14},
	{0xb6fc, 0x9975},
	{0xb6fd, 0x6d31},
	{0xb6fe, 0x4e8c},
	{0xb740, 0x7a1d},
	{0xb741, 0x7a1f},
	{0xb742, 0x7a21},
	{0xb743, 0x7a22},
	{0xb744, 0x7a24},
	{0xb745, 0x7a25},
	{0xb746, 0x7a26},
	{0xb747, 0x7a27},
	{0xb748, 0x7a28},
	{0xb749, 0x7a29},
	{0xb74a, 0x7a2a},
	{0xb74b, 0x7a2b},
	{0xb74c, 0x7a2c},
	{0xb74d, 0x7a2d},
	{0xb74e, 0x7a2e},
	{0xb74f, 0x7a2f},
	{0xb750, 0x7a30},
	{0xb751, 0x7a31},
	{0xb752, 0x7a32},
	{0xb753, 0x7a34},
	{0xb754, 0x7a35},
	{0xb755, 0x7a36},
	{0xb756, 0x7a38},
	{0xb757, 0x7a3a},
	{0xb758, 0x7a3e},
	{0xb759, 0x7a40},
	{0xb75a, 0x7a41},
	{0xb75b, 0x7a42},
	{0xb75c, 0x7a43},
	{0xb75d, 0x7a44},
	{0xb75e, 0x7a45},
	{0xb75f, 0x7a47},
	{0xb760, 0x7a48},
	{0xb761, 0x7a49},
	{0xb762, 0x7a4a},
	{0xb763, 0x7a4b},
	{0xb764, 0x7a4c},
	{0xb765, 0x7a4d},
	{0xb766, 0x7a4e},
	{0xb767, 0x7a4f},
	{0xb768, 0x7a50},
	{0xb769, 0x7a52},
	{0xb76a, 0x7a53},
	{0xb76b, 0x7a54},
	{0xb76c, 0x7a55},
	{0xb76d, 0x7a56},
	{0xb76e, 0x7a58},
	{0xb76f, 0x7a59},
	{0xb770, 0x7a5a},
	{0xb771, 0x7a5b},
	{0xb772, 0x7a5c},
	{0xb773, 0x7a5d},
	{0xb774, 0x7a5e},
	{0xb775, 0x7a5f},
	{0xb776, 0x7a60},
	{0xb777, 0x7a61},
	{0xb778, 0x7a62},
	{0xb779, 0x7a63},
	{0xb77a, 0x7a64},
	{0xb77b, 0x7a65},
	{0xb77c, 0x7a66},
	{0xb77d, 0x7a67},
	{0xb77e, 0x7a68},
	{0xb780, 0x7a69},
	{0xb781, 0x7a6a},
	{0xb782, 0x7a6b},
	{0xb783, 0x7a6c},
	{0xb784, 0x7a6d},
	{0xb785, 0x7a6e},
	{0xb786, 0x7a6f},
	{0xb787, 0x7a71},
	{0xb788, 0x7a72},
	{0xb789, 0x7a73},
	{0xb78a, 0x7a75},
	{0xb78b, 0x7a7b},
	{0xb78c, 0x7a7c},
	{0xb78d, 0x7a7d},
	{0xb78e, 0x7a7e},
	{0xb78f, 0x7a82},
	{0xb790, 0x7a85},
	{0xb791, 0x7a87},
	{0xb792, 0x7a89},
	{0xb793, 0x7a8a},
	{0xb794, 0x7a8b},
	{0xb795, 0x7a8c},
	{0xb796, 0x7a8e},
	{0xb797, 0x7a8f},
	{0xb798, 0x7a90},
	{0xb799, 0x7a93},
	{0xb79a, 0x7a94},
	{0xb79b, 0x7a99},
	{0xb79c, 0x7a9a},
	{0xb79d, 0x7a9b},
	{0xb79e, 0x7a9e},
	{0xb79f, 0x7aa1},
	{0xb7a0, 0x7aa2},
	{0xb7a1, 0x8d30},
	{0xb7a2, 0x53d1},
	{0xb7a3, 0x7f5a},
	{0xb7a4, 0x7b4f},
	{0xb7a5, 0x4f10},
	{0xb7a6, 0x4e4f},
	{0xb7a7, 0x9600},
	{0xb7a8, 0x6cd5},
	{0xb7a9, 0x73d0},
	{0xb7aa, 0x85e9},
	{0xb7ab, 0x5e06},
	{0xb7ac, 0x756a},
	{0xb7ad, 0x7ffb},
	{0xb7ae, 0x6a0a},
	{0xb7af, 0x77fe},
	{0xb7b0, 0x9492},
	{0xb7b1, 0x7e41},
	{0xb7b2, 0x51e1},
	{0xb7b3, 0x70e6},
	{0xb7b4, 0x53cd},
	{0xb7b5, 0x8fd4},
	{0xb7b6, 0x8303},
	{0xb7b7, 0x8d29},
	{0xb7b8, 0x72af},
	{0xb7b9, 0x996d},
	{0xb7ba, 0x6cdb},
	{0xb7bb, 0x574a},
	{0xb7bc, 0x82b3},
	{0xb7bd, 0x65b9},
	{0xb7be, 0x80aa},
	{0xb7bf, 0x623f},
	{0xb7c0, 0x9632},
	{0xb7c1, 0x59a8},
	{0xb7c2, 0x4eff},
	{0xb7c3, 0x8bbf},
	{0xb7c4, 0x7eba},
	{0xb7c5, 0x653e},
	{0xb7c6, 0x83f2},
	{0xb7c7, 0x975e},
	{0xb7c8, 0x5561},
	{0xb7c9, 0x98de},
	{0xb7ca, 0x80a5},
	{0xb7cb, 0x532a},
	{0xb7cc, 0x8bfd},
	{0xb7cd, 0x5420},
	{0xb7ce, 0x80ba},
	{0xb7cf, 0x5e9f},
	{0xb7d0, 0x6cb8},
	{0xb7d1, 0x8d39},
	{0xb7d2, 0x82ac},
	{0xb7d3, 0x915a},
	{0xb7d4, 0x5429},
	{0xb7d5, 0x6c1b},
	{0xb7d6, 0x5206},
	{0xb7d7, 0x7eb7},
	{0xb7d8, 0x575f},
	{0xb7d9, 0x711a},
	{0xb7da, 0x6c7e},
	{0xb7db, 0x7c89},
	{0xb7dc, 0x594b},
	{0xb7dd, 0x4efd},
	{0xb7de, 0x5fff},
	{0xb7df, 0x6124},
	{0xb7e0, 0x7caa},
	{0xb7e1, 0x4e30},
	{0xb7e2, 0x5c01},
	{0xb7e3, 0x67ab},
	{0xb7e4, 0x8702},
	{0xb7e5, 0x5cf0},
	{0xb7e6, 0x950b},
	{0xb7e7, 0x98ce},
	{0xb7e8, 0x75af},
	{0xb7e9, 0x70fd},
	{0xb7ea, 0x9022},
	{0xb7eb, 0x51af},
	{0xb7ec, 0x7f1d},
	{0xb7ed, 0x8bbd},
	{0xb7ee, 0x5949},
	{0xb7ef, 0x51e4},
	{0xb7f0, 0x4f5b},
	{0xb7f1, 0x5426},
	{0xb7f2, 0x592b},
	{0xb7f3, 0x6577},
	{0xb7f4, 0x80a4},
	{0xb7f5, 0x5b75},
	{0xb7f6, 0x6276},
	{0xb7f7, 0x62c2},
	{0xb7f8, 0x8f90},
	{0xb7f9, 0x5e45},
	{0xb7fa, 0x6c1f},
	{0xb7fb, 0x7b26},
	{0xb7fc, 0x4f0f},
	{0xb7fd, 0x4fd8},
	{0xb7fe, 0x670d},
	{0xb840, 0x7aa3},
	{0xb841, 0x7aa4},
	{0xb842, 0x7aa7},
	{0xb843, 0x7aa9},
	{0xb844, 0x7aaa},
	{0xb845, 0x7aab},
	{0xb846, 0x7aae},
	{0xb847, 0x7aaf},
	{0xb848, 0x7ab0},
	{0xb849, 0x7ab1},
	{0xb84a, 0x7ab2},
	{0xb84b, 0x7ab4},
	{0xb84c, 0x7ab5},
	{0xb84d, 0x7ab6},
	{0xb84e, 0x7ab7},
	{0xb84f, 0x7ab8},
	{0xb850, 0x7ab9},
	{0xb851, 0x7aba},
	{0xb852, 0x7abb},
	{0xb853, 0x7abc},
	{0xb854, 0x7abd},
	{0xb855, 0x7abe},
	{0xb856, 0x7ac0},
	{0xb857, 0x7ac1},
	{0xb858, 0x7ac2},
	{0xb859, 0x7ac3},
	{0xb85a, 0x7ac4},
	{0xb85b, 0x7ac5},
	{0xb85c, 0x7ac6},
	{0xb85d, 0x7ac7},
	{0xb85e, 0x7ac8},
	{0xb85f, 0x7ac9},
	{0xb860, 0x7aca},
	{0xb861, 0x7acc},
	{0xb862, 0x7acd},
	{0xb863, 0x7ace},
	{0xb864, 0x7acf},
	{0xb865, 0x7ad0},
	{0xb866, 0x7ad1},
	{0xb867, 0x7ad2},
	{0xb868, 0x7ad3},
	{0xb869, 0x7ad4},
	{0xb86a, 0x7ad5},
	{0xb86b, 0x7ad7},
	{0xb86c, 0x7ad8},
	{0xb86d, 0x7ada},
	{0xb86e, 0x7adb},
	{0xb86f, 0x7adc},
	{0xb870, 0x7add},
	{0xb871, 0x7ae1},
	{0xb872, 0x7ae2},
	{0xb873, 0x7ae4},
	{0xb874, 0x7ae7},
	{0xb875, 0x7ae8},
	{0xb876, 0x7ae9},
	{0xb877, 0x7aea},
	{0xb878, 0x7aeb},
	{0xb879, 0x7aec},
	{0xb87a, 0x7aee},
	{0xb87b, 0x7af0},
	{0xb87c, 0x7af1},
	{0xb87d, 0x7af2},
	{0xb87e, 0x7af3},
	{0xb880, 0x7af4},
	{0xb881, 0x7af5},
	{0xb882, 0x7af6},
	{0xb883, 0x7af7},
	{0xb884, 0x7af8},
	{0xb885, 0x7afb},
	{0xb886, 0x7afc},
	{0xb887, 0x7afe},
	{0xb888, 0x7b00},
	{0xb889, 0x7b01},
	{0xb88a, 0x7b02},
	{0xb88b, 0x7b05},
	{0xb88c, 0x7b07},
	{0xb88d, 0x7b09},
	{0xb88e, 0x7b0c},
	{0xb88f, 0x7b0d},
	{0xb890, 0x7b0e},
	{0xb891, 0x7b10},
	{0xb892, 0x7b12},
	{0xb893, 0x7b13},
	{0xb894, 0x7b16},
	{0xb895, 0x7b17},
	{0xb896, 0x7b18},
	{0xb897, 0x7b1a},
	{0xb898, 0x7b1c},
	{0xb899, 0x7b1d},
	{0xb89a, 0x7b1f},
	{0xb89b, 0x7b21},
	{0xb89c, 0x7b22},
	{0xb89d, 0x7b23},
	{0xb89e, 0x7b27},
	{0xb89f, 0x7b29},
	{0xb8a0, 0x7b2d},
	{0xb8a1, 0x6d6e},
	{0xb8a2, 0x6daa},
	{0xb8a3, 0x798f},
	{0xb8a4, 0x88b1},
	{0xb8a5, 0x5f17},
	{0xb8a6, 0x752b},
	{0xb8a7, 0x629a},
	{0xb8a8, 0x8f85},
	{0xb8a9, 0x4fef},
	{0xb8aa, 0x91dc},
	{0xb8ab, 0x65a7},
	{0xb8ac, 0x812f},
	{0xb8ad, 0x8151},
	{0xb8ae, 0x5e9c},
	{0xb8af, 0x8150},
	{0xb8b0, 0x8d74},
	{0xb8b1, 0x526f},
	{0xb8b2, 0x8986},
	{0xb8b3, 0x8d4b},
	{0xb8b4, 0x590d},
	{0xb8b5, 0x5085},
	{0xb8b6, 0x4ed8},
	{0xb8b7, 0x961c},
	{0xb8b8, 0x7236},
	{0xb8b9, 0x8179},
	{0xb8ba, 0x8d1f},
	{0xb8bb, 0x5bcc},
	{0xb8bc, 0x8ba3},
	{0xb8bd, 0x9644},
	{0xb8be, 0x5987},
	{0xb8bf, 0x7f1a},
	{0xb8c0, 0x5490},
	{0xb8c1, 0x5676},
	{0xb8c2, 0x560e},
	{0xb8c3, 0x8be5},
	{0xb8c4, 0x6539},
	{0xb8c5, 0x6982},
	{0xb8c6, 0x9499},
	{0xb8c7, 0x76d6},
	{0xb8c8, 0x6e89},
	{0xb8c9, 0x5e72},
	{0xb8ca, 0x7518},
	{0xb8cb, 0x6746},
	{0xb8cc, 0x67d1},
	{0xb8cd, 0x7aff},
	{0xb8ce, 0x809d},
	{0xb8cf, 0x8d76},
	{0xb8d0, 0x611f},
	{0xb8d1, 0x79c6},
	{0xb8d2, 0x6562},
	{0xb8d3, 0x8d63},
	{0xb8d4, 0x5188},
	{0xb8d5, 0x521a},
	{0xb8d6, 0x94a2},
	{0xb8d7, 0x7f38},
	{0xb8d8, 0x809b},
	{0xb8d9, 0x7eb2},
	{0xb8da, 0x5c97},
	{0xb8db, 0x6e2f},
	{0xb8dc, 0x6760},
	{0xb8dd, 0x7bd9},
	{0xb8de, 0x768b},
	{0xb8df, 0x9ad8},
	{0xb8e0, 0x818f},
	{0xb8e1, 0x7f94},
	{0xb8e2, 0x7cd5},
	{0xb8e3, 0x641e},
	{0xb8e4, 0x9550},
	{0xb8e5, 0x7a3f},
	{0xb8e6, 0x544a},
	{0xb8e7, 0x54e5},
	{0xb8e8, 0x6b4c},
	{0xb8e9, 0x6401},
	{0xb8ea, 0x6208},
	{0xb8eb, 0x9e3d},
	{0xb8ec, 0x80f3},
	{0xb8ed, 0x7599},
	{0xb8ee, 0x5272},
	{0xb8ef, 0x9769},
	{0xb8f0, 0x845b},
	{0xb8f1, 0x683c},
	{0xb8f2, 0x86e4},
	{0xb8f3, 0x9601},
	{0xb8f4, 0x9694},
	{0xb8f5, 0x94ec},
	{0xb8f6, 0x4e2a},
	{0xb8f7, 0x5404},
	{0xb8f8, 0x7ed9},
	{0xb8f9, 0x6839},
	{0xb8fa, 0x8ddf},
	{0xb8fb, 0x8015},
	{0xb8fc, 0x66f4},
	{0xb8fd, 0x5e9a},
	{0xb8fe, 0x7fb9},
	{0xb940, 0x7b2f},
	{0xb941, 0x7b30},
	{0xb942, 0x7b32},
	{0xb943, 0x7b34},
	{0xb944, 0x7b35},
	{0xb945, 0x7b36},
	{0xb946, 0x7b37},
	{0xb947, 0x7b39},
	{0xb948, 0x7b3b},
	{0xb949, 0x7b3d},
	{0xb94a, 0x7b3f},
	{0xb94b, 0x7b40},
	{0xb94c, 0x7b41},
	{0xb94d, 0x7b42},
	{0xb94e, 0x7b43},
	{0xb94f, 0x7b44},
	{0xb950, 0x7b46},
	{0xb951, 0x7b48},
	{0xb952, 0x7b4a},
	{0xb953, 0x7b4d},
	{0xb954, 0x7b4e},
	{0xb955, 0x7b53},
	{0xb956, 0x7b55},
	{0xb957, 0x7b57},
	{0xb958, 0x7b59},
	{0xb959, 0x7b5c},
	{0xb95a, 0x7b5e},
	{0xb95b, 0x7b5f},
	{0xb95c, 0x7b61},
	{0xb95d, 0x7b63},
	{0xb95e, 0x7b64},
	{0xb95f, 0x7b65},
	{0xb960, 0x7b66},
	{0xb961, 0x7b67},
	{0xb962, 0x7b68},
	{0xb963, 0x7b69},
	{0xb964, 0x7b6a},
	{0xb965, 0x7b6b},
	{0xb966, 0x7b6c},
	{0xb967, 0x7b6d},
	{0xb968, 0x7b6f},
	{0xb969, 0x7b70},
	{0xb96a, 0x7b73},
	{0xb96b, 0x7b74},
	{0xb96c, 0x7b76},
	{0xb96d, 0x7b78},
	{0xb96e, 0x7b7a},
	{0xb96f, 0x7b7c},
	{0xb970, 0x7b7d},
	{0xb971, 0x7b7f},
	{0xb972, 0x7b81},
	{0xb973, 0x7b82},
	{0xb974, 0x7b83},
	{0xb975, 0x7b84},
	{0xb976, 0x7b86},
	{0xb977, 0x7b87},
	{0xb978, 0x7b88},
	{0xb979, 0x7b89},
	{0xb97a, 0x7b8a},
	{0xb97b, 0x7b8b},
	{0xb97c, 0x7b8c},
	{0xb97d, 0x7b8e},
	{0xb97e, 0x7b8f},
	{0xb980, 0x7b91},
	{0xb981, 0x7b92},
	{0xb982, 0x7b93},
	{0xb983, 0x7b96},
	{0xb984, 0x7b98},
	{0xb985, 0x7b99},
	{0xb986, 0x7b9a},
	{0xb987, 0x7b9b},
	{0xb988, 0x7b9e},
	{0xb989, 0x7b9f},
	{0xb98a, 0x7ba0},
	{0xb98b, 0x7ba3},
	{0xb98c, 0x7ba4},
	{0xb98d, 0x7ba5},
	{0xb98e, 0x7bae},
	{0xb98f, 0x7baf},
	{0xb990, 0x7bb0},
	{0xb991, 0x7bb2},
	{0xb992, 0x7bb3},
	{0xb993, 0x7bb5},
	{0xb994, 0x7bb6},
	{0xb995, 0x7bb7},
	{0xb996, 0x7bb9},
	{0xb997, 0x7bba},
	{0xb998, 0x7bbb},
	{0xb999, 0x7bbc},
	{0xb99a, 0x7bbd},
	{0xb99b, 0x7bbe},
	{0xb99c, 0x7bbf},
	{0xb99d, 0x7bc0},
	{0xb99e, 0x7bc2},
	{0xb99f, 0x7bc3},
	{0xb9a0, 0x7bc4},
	{0xb9a1, 0x57c2},
	{0xb9a2, 0x803f},
	{0xb9a3, 0x6897},
	{0xb9a4, 0x5de5},
	{0xb9a5, 0x653b},
	{0xb9a6, 0x529f},
	{0xb9a7, 0x606d},
	{0xb9a8, 0x9f9a},
	{0xb9a9, 0x4f9b},
	{0xb9aa, 0x8eac},
	{0xb9ab, 0x516c},
	{0xb9ac, 0x5bab},
	{0xb9ad, 0x5f13},
	{0xb9ae, 0x5de9},
	{0xb9af, 0x6c5e},
	{0xb9b0, 0x62f1},
	{0xb9b1, 0x8d21},
	{0xb9b2, 0x5171},
	{0xb9b3, 0x94a9},
	{0xb9b4, 0x52fe},
	{0xb9b5, 0x6c9f},
	{0xb9b6, 0x82df},
	{0xb9b7, 0x72d7},
	{0xb9b8, 0x57a2},
	{0xb9b9, 0x6784},
	{0xb9ba, 0x8d2d},
	{0xb9bb, 0x591f},
	{0xb9bc, 0x8f9c},
	{0xb9bd, 0x83c7},
	{0xb9be, 0x5495},
	{0xb9bf, 0x7b8d},
	{0xb9c0, 0x4f30},
	{0xb9c1, 0x6cbd},
	{0xb9c2, 0x5b64},
	{0xb9c3, 0x59d1},
	{0xb9c4, 0x9f13},
	{0xb9c5, 0x53e4},
	{0xb9c6, 0x86ca},
	{0xb9c7, 0x9aa8},
	{0xb9c8, 0x8c37},
	{0xb9c9, 0x80a1},
	{0xb9ca, 0x6545},
	{0xb9cb, 0x987e},
	{0xb9cc, 0x56fa},
	{0xb9cd, 0x96c7},
	{0xb9ce, 0x522e},
	{0xb9cf, 0x74dc},
	{0xb9d0, 0x5250},
	{0xb9d1, 0x5be1},
	{0xb9d2, 0x6302},
	{0xb9d3, 0x8902},
	{0xb9d4, 0x4e56},
	{0xb9d5, 0x62d0},
	{0xb9d6, 0x602a},
	{0xb9d7, 0x68fa},
	{0xb9d8, 0x5173},
	{0xb9d9, 0x5b98},
	{0xb9da, 0x51a0},
	{0xb9db, 0x89c2},
	{0xb9dc, 0x7ba1},
	{0xb9dd, 0x9986},
	{0xb9de, 0x7f50},
	{0xb9df, 0x60ef},
	{0xb9e0, 0x704c},
	{0xb9e1, 0x8d2f},
	{0xb9e2, 0x5149},
	{0xb9e3, 0x5e7f},
	{0xb9e4, 0x901b},
	{0xb9e5, 0x7470},
	{0xb9e6, 0x89c4},
	{0xb9e7, 0x572d},
	{0xb9e8, 0x7845},
	{0xb9e9, 0x5f52},
	{0xb9ea, 0x9f9f},
	{0xb9eb, 0x95fa},
	{0xb9ec, 0x8f68},
	{0xb9ed, 0x9b3c},
	{0xb9ee, 0x8be1},
	{0xb9ef, 0x7678},
	{0xb9f0, 0x6842},
	{0xb9f1, 0x67dc},
	{0xb9f2, 0x8dea},
	{0xb9f3, 0x8d35},
	{0xb9f4, 0x523d},
	{0xb9f5, 0x8f8a},
	{0xb9f6, 0x6eda},
	{0xb9f7, 0x68cd},
	{0xb9f8, 0x9505},
	{0xb9f9, 0x90ed},
	{0xb9fa, 0x56fd},
	{0xb9fb, 0x679c},
	{0xb9fc, 0x88f9},
	{0xb9fd, 0x8fc7},
	{0xb9fe, 0x54c8},
	{0xba40, 0x7bc5},
	{0xba41, 0x7bc8},
	{0xba42, 0x7bc9},
	{0xba43, 0x7bca},
	{0xba44, 0x7bcb},
	{0xba45, 0x7bcd},
	{0xba46, 0x7bce},
	{0xba47, 0x7bcf},
	{0xba48, 0x7bd0},
	{0xba49, 0x7bd2},
	{0xba4a, 0x7bd4},
	{0xba4b, 0x7bd5},
	{0xba4c, 0x7bd6},
	{0xba4d, 0x7bd7},
	{0xba4e, 0x7bd8},
	{0xba4f, 0x7bdb},
	{0xba50, 0x7bdc},
	{0xba51, 0x7bde},
	{0xba52, 0x7bdf},
	{0xba53, 0x7be0},
	{0xba54, 0x7be2},
	{0xba55, 0x7be3},
	{0xba56, 0x7be4},
	{0xba57, 0x7be7},
	{0xba58, 0x7be8},
	{0xba59, 0x7be9},
	{0xba5a, 0x7beb},
	{0xba5b, 0x7bec},
	{0xba5c, 0x7bed},
	{0xba5d, 0x7bef},
	{0xba5e, 0x7bf0},
	{0xba5f, 0x7bf2},
	{0xba60, 0x7bf3},
	{0xba61, 0x7bf4},
	{0xba62, 0x7bf5},
	{0xba63, 0x7bf6},
	{0xba64, 0x7bf8},
	{0xba65, 0x7bf9},
	{0xba66, 0x7bfa},
	{0xba67, 0x7bfb},
	{0xba68, 0x7bfd},
	{0xba69, 0x7bff},
	{0xba6a, 0x7c00},
	{0xba6b, 0x7c01},
	{0xba6c, 0x7c02},
	{0xba6d, 0x7c03},
	{0xba6e, 0x7c04},
	{0xba6f, 0x7c05},
	{0xba70, 0x7c06},
	{0xba71, 0x7c08},
	{0xba72, 0x7c09},
	{0xba73, 0x7c0a},
	{0xba74, 0x7c0d},
	{0xba75, 0x7c0e},
	{0xba76, 0x7c10},
	{0xba77, 0x7c11},
	{0xba78, 0x7c12},
	{0xba79, 0x7c13},
	{0xba7a, 0x7c14},
	{0xba7b, 0x7c15},
	{0xba7c, 0x7c17},
	{0xba7d, 0x7c18},
	{0xba7e, 0x7c19},
	{0xba80, 0x7c1a},
	{0xba81, 0x7c1b},
	{0xba82, 0x7c1c},
	{0xba83, 0x7c1d},
	{0xba84, 0x7c1e},
	{0xba85, 0x7c20},
	{0xba86, 0x7c21},
	{0xba87, 0x7c22},
	{0xba88, 0x7c23},
	{0xba89, 0x7c24},
	{0xba8a, 0x7c25},
	{0xba8b, 0x7c28},
	{0xba8c, 0x7c29},
	{0xba8d, 0x7c2b},
	{0xba8e, 0x7c2c},
	{0xba8f, 0x7c2d},
	{0xba90, 0x7c2e},
	{0xba91, 0x7c2f},
	{0xba92, 0x7c30},
	{0xba93, 0x7c31},
	{0xba94, 0x7c32},
	{0xba95, 0x7c33},
	{0xba96, 0x7c34},
	{0xba97, 0x7c35},
	{0xba98, 0x7c36},
	{0xba99, 0x7c37},
	{0xba9a, 0x7c39},
	{0xba9b, 0x7c3a},
	{0xba9c, 0x7c3b},
	{0xba9d, 0x7c3c},
	{0xba9e, 0x7c3d},
	{0xba9f, 0x7c3e},
	{0xbaa0, 0x7c42},
	{0xbaa1, 0x9ab8},
	{0xbaa2, 0x5b69},
	{0xbaa3, 0x6d77},
	{0xbaa4, 0x6c26},
	{0xbaa5, 0x4ea5},
	{0xbaa6, 0x5bb3},
	{0xbaa7, 0x9a87},
	{0xbaa8, 0x9163},
	{0xbaa9, 0x61a8},
	{0xbaaa, 0x90af},
	{0xbaab, 0x97e9},
	{0xbaac, 0x542b},
	{0xbaad, 0x6db5},
	{0xbaae, 0x5bd2},
	{0xbaaf, 0x51fd},
	{0xbab0, 0x558a},
	{0xbab1, 0x7f55},
	{0xbab2, 0x7ff0},
	{0xbab3, 0x64bc},
	{0xbab4, 0x634d},
	{0xbab5, 0x65f1},
	{0xbab6, 0x61be},
	{0xbab7, 0x608d},
	{0xbab8, 0x710a},
	{0xbab9, 0x6c57},
	{0xbaba, 0x6c49},
	{0xbabb, 0x592f},
	{0xbabc, 0x676d},
	{0xbabd, 0x822a},
	{0xbabe, 0x58d5},
	{0xbabf, 0x568e},
	{0xbac0, 0x8c6a},
	{0xbac1, 0x6beb},
	{0xbac2, 0x90dd},
	{0xbac3, 0x597d},
	{0xbac4, 0x8017},
	{0xbac5, 0x53f7},
	{0xbac6, 0x6d69},
	{0xbac7, 0x5475},
	{0xbac8, 0x559d},
	{0xbac9, 0x8377},
	{0xbaca, 0x83cf},
	{0xbacb, 0x6838},
	{0xbacc, 0x79be},
	{0xbacd, 0x548c},
	{0xbace, 0x4f55},
	{0xbacf, 0x5408},
	{0xbad0, 0x76d2},
	{0xbad1, 0x8c89},
	{0xbad2, 0x9602},
	{0xbad3, 0x6cb3},
	{0xbad4, 0x6db8},
	{0xbad5, 0x8d6b},
	{0xbad6, 0x8910},
	{0xbad7, 0x9e64},
	{0xbad8, 0x8d3a},
	{0xbad9, 0x563f},
	{0xbada, 0x9ed1},
	{0xbadb, 0x75d5},
	{0xbadc, 0x5f88},
	{0xbadd, 0x72e0},
	{0xbade, 0x6068},
	{0xbadf, 0x54fc},
	{0xbae0, 0x4ea8},
	{0xbae1, 0x6a2a},
	{0xbae2, 0x8861},
	{0xbae3, 0x6052},
	{0xbae4, 0x8f70},
	{0xbae5, 0x54c4},
	{0xbae6, 0x70d8},
	{0xbae7, 0x8679},
	{0xbae8, 0x9e3f},
	{0xbae9, 0x6d2a},
	{0xbaea, 0x5b8f},
	{0xbaeb, 0x5f18},
	{0xbaec, 0x7ea2},
	{0xbaed, 0x5589},
	{0xbaee, 0x4faf},
	{0xbaef, 0x7334},
	{0xbaf0, 0x543c},
	{0xbaf1, 0x539a},
	{0xbaf2, 0x5019},
	{0xbaf3, 0x540e},
	{0xbaf4, 0x547c},
	{0xbaf5, 0x4e4e},
	{0xbaf6, 0x5ffd},
	{0xbaf7, 0x745a},
	{0xbaf8, 0x58f6},
	{0xbaf9, 0x846b},
	{0xbafa, 0x80e1},
	{0xbafb, 0x8774},
	{0xbafc, 0x72d0},
	{0xbafd, 0x7cca},
	{0xbafe, 0x6e56},
	{0xbb40, 0x7c43},
	{0xbb41, 0x7c44},
	{0xbb42, 0x7c45},
	{0xbb43, 0x7c46},
	{0xbb44, 0x7c47},
	{0xbb45, 0x7c48},
	{0xbb46, 0x7c49},
	{0xbb47, 0x7c4a},
	{0xbb48, 0x7c4b},
	{0xbb49, 0x7c4c},
	{0xbb4a, 0x7c4e},
	{0xbb4b, 0x7c4f},
	{0xbb4c, 0x7c50},
	{0xbb4d, 0x7c51},
	{0xbb4e, 0x7c52},
	{0xbb4f, 0x7c53},
	{0xbb50, 0x7c54},
	{0xbb51, 0x7c55},
	{0xbb52, 0x7c56},
	{0xbb53, 0x7c57},
	{0xbb54, 0x7c58},
	{0xbb55, 0x7c59},
	{0xbb56, 0x7c5a},
	{0xbb57, 0x7c5b},
	{0xbb58, 0x7c5c},
	{0xbb59, 0x7c5d},
	{0xbb5a, 0x7c5e},
	{0xbb5b, 0x7c5f},
	{0xbb5c, 0x7c60},
	{0xbb5d, 0x7c61},
	{0xbb5e, 0x7c62},
	{0xbb5f, 0x7c63},
	{0xbb60, 0x7c64},
	{0xbb61, 0x7c65},
	{0xbb62, 0x7c66},
	{0xbb63, 0x7c67},
	{0xbb64, 0x7c68},
	{0xbb65, 0x7c69},
	{0xbb66, 0x7c6a},
	{0xbb67, 0x7c6b},
	{0xbb68, 0x7c6c},
	{0xbb69, 0x7c6d},
	{0xbb6a, 0x7c6e},
	{0xbb6b, 0x7c6f},
	{0xbb6c, 0x7c70},
	{0xbb6d, 0x7c71},
	{0xbb6e, 0x7c72},
	{0xbb6f, 0x7c75},
	{0xbb70, 0x7c76},
	{0xbb71, 0x7c77},
	{0xbb72, 0x7c78},
	{0xbb73, 0x7c79},
	{0xbb74, 0x7c7a},
	{0xbb75, 0x7c7e},
	{0xbb76, 0x7c7f},
	{0xbb77, 0x7c80},
	{0xbb78, 0x7c81},
	{0xbb79, 0x7c82},
	{0xbb7a, 0x7c83},
	{0xbb7b, 0x7c84},
	{0xbb7c, 0x7c85},
	{0xbb7d, 0x7c86},
	{0xbb7e, 0x7c87},
	{0xbb80, 0x7c88},
	{0xbb81, 0x7c8a},
	{0xbb82, 0x7c8b},
	{0xbb83, 0x7c8c},
	{0xbb84, 0x7c8d},
	{0xbb85, 0x7c8e},
	{0xbb86, 0x7c8f},
	{0xbb87, 0x7c90},
	{0xbb88, 0x7c93},
	{0xbb89, 0x7c94},
	{0xbb8a, 0x7c96},
	{0xbb8b, 0x7c99},
	{0xbb8c, 0x7c9a},
	{0xbb8d, 0x7c9b},
	{0xbb8e, 0x7ca0},
	{0xbb8f, 0x7ca1},
	{0xbb90, 0x7ca3},
	{0xbb91, 0x7ca6},
	{0xbb92, 0x7ca7},
	{0xbb93, 0x7ca8},
	{0xbb94, 0x7ca9},
	{0xbb95, 0x7cab},
	{0xbb96, 0x7cac},
	{0xbb97, 0x7cad},
	{0xbb98, 0x7caf},
	{0xbb99, 0x7cb0},
	{0xbb9a, 0x7cb4},
	{0xbb9b, 0x7cb5},
	{0xbb9c, 0x7cb6},
	{0xbb9d, 0x7cb7},
	{0xbb9e, 0x7cb8},
	{0xbb9f, 0x7cba},
	{0xbba0, 0x7cbb},
	{0xbba1, 0x5f27},
	{0xbba2, 0x864e},
	{0xbba3, 0x552c},
	{0xbba4, 0x62a4},
	{0xbba5, 0x4e92},
	{0xbba6, 0x6caa},
	{0xbba7, 0x6237},
	{0xbba8, 0x82b1},
	{0xbba9, 0x54d7},
	{0xbbaa, 0x534e},
	{0xbbab, 0x733e},
	{0xbbac, 0x6ed1},
	{0xbbad, 0x753b},
	{0xbbae, 0x5212},
	{0xbbaf, 0x5316},
	{0xbbb0, 0x8bdd},
	{0xbbb1, 0x69d0},
	{0xbbb2, 0x5f8a},
	{0xbbb3, 0x6000},
	{0xbbb4, 0x6dee},
	{0xbbb5, 0x574f},
	{0xbbb6, 0x6b22},
	{0xbbb7, 0x73af},
	{0xbbb8, 0x6853},
	{0xbbb9, 0x8fd8},
	{0xbbba, 0x7f13},
	{0xbbbb, 0x6362},
	{0xbbbc, 0x60a3},
	{0xbbbd, 0x5524},
	{0xbbbe, 0x75ea},
	{0xbbbf, 0x8c62},
	{0xbbc0, 0x7115},
	{0xbbc1, 0x6da3},
	{0xbbc2, 0x5ba6},
	{0xbbc3, 0x5e7b},
	{0xbbc4, 0x8352},
	{0xbbc5, 0x614c},
	{0xbbc6, 0x9ec4},
	{0xbbc7, 0x78fa},
	{0xbbc8, 0x8757},
	{0xbbc9, 0x7c27},
	{0xbbca, 0x7687},
	{0xbbcb, 0x51f0},
	{0xbbcc, 0x60f6},
	{0xbbcd, 0x714c},
	{0xbbce, 0x6643},
	{0xbbcf, 0x5e4c},
	{0xbbd0, 0x604d},
	{0xbbd1, 0x8c0e},
	{0xbbd2, 0x7070},
	{0xbbd3, 0x6325},
	{0xbbd4, 0x8f89},
	{0xbbd5, 0x5fbd},
	{0xbbd6, 0x6062},
	{0xbbd7, 0x86d4},
	{0xbbd8, 0x56de},
	{0xbbd9, 0x6bc1},
	{0xbbda, 0x6094},
	{0xbbdb, 0x6167},
	{0xbbdc, 0x5349},
	{0xbbdd, 0x60e0},
	{0xbbde, 0x6666},
	{0xbbdf, 0x8d3f},
	{0xbbe0, 0x79fd},
	{0xbbe1, 0x4f1a},
	{0xbbe2, 0x70e9},
	{0xbbe3, 0x6c47},
	{0xbbe4, 0x8bb3},
	{0xbbe5, 0x8bf2},
	{0xbbe6, 0x7ed8},
	{0xbbe7, 0x8364},
	{0xbbe8, 0x660f},
	{0xbbe9, 0x5a5a},
	{0xbbea, 0x9b42},
	{0xbbeb, 0x6d51},
	{0xbbec, 0x6df7},
	{0xbbed, 0x8c41},
	{0xbbee, 0x6d3b},
	{0xbbef, 0x4f19},
	{0xbbf0, 0x706b},
	{0xbbf1, 0x83b7},
	{0xbbf2, 0x6216},
	{0xbbf3, 0x60d1},
	{0xbbf4, 0x970d},
	{0xbbf5, 0x8d27},
	{0xbbf6, 0x7978},
	{0xbbf7, 0x51fb},
	{0xbbf8, 0x573e},
	{0xbbf9, 0x57fa},
	{0xbbfa, 0x673a},
	{0xbbfb, 0x7578},
	{0xbbfc, 0x7a3d},
	{0xbbfd, 0x79ef},
	{0xbbfe, 0x7b95},
	{0xbc40, 0x7cbf},
	{0xbc41, 0x7cc0},
	{0xbc42, 0x7cc2},
	{0xbc43, 0x7cc3},
	{0xbc44, 0x7cc4},
	{0xbc45, 0x7cc6},
	{0xbc46, 0x7cc9},
	{0xbc47, 0x7ccb},
	{0xbc48, 0x7cce},
	{0xbc49, 0x7ccf},
	{0xbc4a, 0x7cd0},
	{0xbc4b, 0x7cd1},
	{0xbc4c, 0x7cd2},
	{0xbc4d, 0x7cd3},
	{0xbc4e, 0x7cd4},
	{0xbc4f, 0x7cd8},
	{0xbc50, 0x7cda},
	{0xbc51, 0x7cdb},
	{0xbc52, 0x7cdd},
	{0xbc53, 0x7cde},
	{0xbc54, 0x7ce1},
	{0xbc55, 0x7ce2},
	{0xbc56, 0x7ce3},
	{0xbc57, 0x7ce4},
	{0xbc58, 0x7ce5},
	{0xbc59, 0x7ce6},
	{0xbc5a, 0x7ce7},
	{0xbc5b, 0x7ce9},
	{0xbc5c, 0x7cea},
	{0xbc5d, 0x7ceb},
	{0xbc5e, 0x7cec},
	{0xbc5f, 0x7ced},
	{0xbc60, 0x7cee},
	{0xbc61, 0x7cf0},
	{0xbc62, 0x7cf1},
	{0xbc63, 0x7cf2},
	{0xbc64, 0x7cf3},
	{0xbc65, 0x7cf4},
	{0xbc66, 0x7cf5},
	{0xbc67, 0x7cf6},
	{0xbc68, 0x7cf7},
	{0xbc69, 0x7cf9},
	{0xbc6a, 0x7cfa},
	{0xbc6b, 0x7cfc},
	{0xbc6c, 0x7cfd},
	{0xbc6d, 0x7cfe},
	{0xbc6e, 0x7cff},
	{0xbc6f, 0x7d00},
	{0xbc70, 0x7d01},
	{0xbc71, 0x7d02},
	{0xbc72, 0x7d03},
	{0xbc73, 0x7d04},
	{0xbc74, 0x7d05},
	{0xbc75, 0x7d06},
	{0xbc76, 0x7d07},
	{0xbc77, 0x7d08},
	{0xbc78, 0x7d09},
	{0xbc79, 0x7d0b},
	{0xbc7a, 0x7d0c},
	{0xbc7b, 0x7d0d},
	{0xbc7c, 0x7d0e},
	{0xbc7d, 0x7d0f},
	{0xbc7e, 0x7d10},
	{0xbc80, 0x7d11},
	{0xbc81, 0x7d12},
	{0xbc82, 0x7d13},
	{0xbc83, 0x7d14},
	{0xbc84, 0x7d15},
	{0xbc85, 0x7d16},
	{0xbc86, 0x7d17},
	{0xbc87, 0x7d18},
	{0xbc88, 0x7d19},
	{0xbc89, 0x7d1a},
	{0xbc8a, 0x7d1b},
	{0xbc8b, 0x7d1c},
	{0xbc8c, 0x7d1d},
	{0xbc8d, 0x7d1e},
	{0xbc8e, 0x7d1f},
	{0xbc8f, 0x7d21},
	{0xbc90, 0x7d23},
	{0xbc91, 0x7d24},
	{0xbc92, 0x7d25},
	{0xbc93, 0x7d26},
	{0xbc94, 0x7d28},
	{0xbc95, 0x7d29},
	{0xbc96, 0x7d2a},
	{0xbc97, 0x7d2c},
	{0xbc98, 0x7d2d},
	{0xbc99, 0x7d2e},
	{0xbc9a, 0x7d30},
	{0xbc9b, 0x7d31},
	{0xbc9c, 0x7d32},
	{0xbc9d, 0x7d33},
	{0xbc9e, 0x7d34},
	{0xbc9f, 0x7d35},
	{0xbca0, 0x7d36},
	{0xbca1, 0x808c},
	{0xbca2, 0x9965},
	{0xbca3, 0x8ff9},
	{0xbca4, 0x6fc0},
	{0xbca5, 0x8ba5},
	{0xbca6, 0x9e21},
	{0xbca7, 0x59ec},
	{0xbca8, 0x7ee9},
	{0xbca9, 0x7f09},
	{0xbcaa, 0x5409},
	{0xbcab, 0x6781},
	{0xbcac, 0x68d8},
	{0xbcad, 0x8f91},
	{0xbcae, 0x7c4d},
	{0xbcaf, 0x96c6},
	{0xbcb0, 0x53ca},
	{0xbcb1, 0x6025},
	{0xbcb2, 0x75be},
	{0xbcb3, 0x6c72},
	{0xbcb4, 0x5373},
	{0xbcb5, 0x5ac9},
	{0xbcb6, 0x7ea7},
	{0xbcb7, 0x6324},
	{0xbcb8, 0x51e0},
	{0xbcb9, 0x810a},
	{0xbcba, 0x5df1},
	{0xbcbb, 0x84df},
	{0xbcbc, 0x6280},
	{0xbcbd, 0x5180},
	{0xbcbe, 0x5b63},
	{0xbcbf, 0x4f0e},
	{0xbcc0, 0x796d},
	{0xbcc1, 0x5242},
	{0xbcc2, 0x60b8},
	{0xbcc3, 0x6d4e},
	{0xbcc4, 0x5bc4},
	{0xbcc5, 0x5bc2},
	{0xbcc6, 0x8ba1},
	{0xbcc7, 0x8bb0},
	{0xbcc8, 0x65e2},
	{0xbcc9, 0x5fcc},
	{0xbcca, 0x9645},
	{0xbccb, 0x5993},
	{0xbccc, 0x7ee7},
	{0xbccd, 0x7eaa},
	{0xbcce, 0x5609},
	{0xbccf, 0x67b7},
	{0xbcd0, 0x5939},
	{0xbcd1, 0x4f73},
	{0xbcd2, 0x5bb6},
	{0xbcd3, 0x52a0},
	{0xbcd4, 0x835a},
	{0xbcd5, 0x988a},
	{0xbcd6, 0x8d3e},
	{0xbcd7, 0x7532},
	{0xbcd8, 0x94be},
	{0xbcd9, 0x5047},
	{0xbcda, 0x7a3c},
	{0xbcdb, 0x4ef7},
	{0xbcdc, 0x67b6},
	{0xbcdd, 0x9a7e},
	{0xbcde, 0x5ac1},
	{0xbcdf, 0x6b7c},
	{0xbce0, 0x76d1},
	{0xbce1, 0x575a},
	{0xbce2, 0x5c16},
	{0xbce3, 0x7b3a},
	{0xbce4, 0x95f4},
	{0xbce5, 0x714e},
	{0xbce6, 0x517c},
	{0xbce7, 0x80a9},
	{0xbce8, 0x8270},
	{0xbce9, 0x5978},
	{0xbcea, 0x7f04},
	{0xbceb, 0x8327},
	{0xbcec, 0x68c0},
	{0xbced, 0x67ec},
	{0xbcee, 0x78b1},
	{0xbcef, 0x7877},
	{0xbcf0, 0x62e3},
	{0xbcf1, 0x6361},
	{0xbcf2, 0x7b80},
	{0xbcf3, 0x4fed},
	{0xbcf4, 0x526a},
	{0xbcf5, 0x51cf},
	{0xbcf6, 0x8350},
	{0xbcf7, 0x69db},
	{0xbcf8, 0x9274},
	{0xbcf9, 0x8df5},
	{0xbcfa, 0x8d31},
	{0xbcfb, 0x89c1},
	{0xbcfc, 0x952e},
	{0xbcfd, 0x7bad},
	{0xbcfe, 0x4ef6},
	{0xbd40, 0x7d37},
	{0xbd41, 0x7d38},
	{0xbd42, 0x7d39},
	{0xbd43, 0x7d3a},
	{0xbd44, 0x7d3b},
	{0xbd45, 0x7d3c},
	{0xbd46, 0x7d3d},
	{0xbd47, 0x7d3e},
	{0xbd48, 0x7d3f},
	{0xbd49, 0x7d40},
	{0xbd4a, 0x7d41},
	{0xbd4b, 0x7d42},
	{0xbd4c, 0x7d43},
	{0xbd4d, 0x7d44},
	{0xbd4e, 0x7d45},
	{0xbd4f, 0x7d46},
	{0xbd50, 0x7d47},
	{0xbd51, 0x7d48},
	{0xbd52, 0x7d49},
	{0xbd53, 0x7d4a},
	{0xbd54, 0x7d4b},
	{0xbd55, 0x7d4c},
	{0xbd56, 0x7d4d},
	{0xbd57, 0x7d4e},
	{0xbd58, 0x7d4f},
	{0xbd59, 0x7d50},
	{0xbd5a, 0x7d51},
	{0xbd5b, 0x7d52},
	{0xbd5c, 0x7d53},
	{0xbd5d, 0x7d54},
	{0xbd5e, 0x7d55},
	{0xbd5f, 0x7d56},
	{0xbd60, 0x7d57},
	{0xbd61, 0x7d58},
	{0xbd62, 0x7d59},
	{0xbd63, 0x7d5a},
	{0xbd64, 0x7d5b},
	{0xbd65, 0x7d5c},
	{0xbd66, 0x7d5d},
	{0xbd67, 0x7d5e},
	{0xbd68, 0x7d5f},
	{0xbd69, 0x7d60},
	{0xbd6a, 0x7d61},
	{0xbd6b, 0x7d62},
	{0xbd6c, 0x7d63},
	{0xbd6d, 0x7d64},
	{0xbd6e, 0x7d65},
	{0xbd6f, 0x7d66},
	{0xbd70, 0x7d67},
	{0xbd71, 0x7d68},
	{0xbd72, 0x7d69},
	{0xbd73, 0x7d6a},
	{0xbd74, 0x7d6b},
	{0xbd75, 0x7d6c},
	{0xbd76, 0x7d6d},
	{0xbd77, 0x7d6f},
	{0xbd78, 0x7d70},
	{0xbd79, 0x7d71},
	{0xbd7a, 0x7d72},
	{0xbd7b, 0x7d73},
	{0xbd7c, 0x7d74},
	{0xbd7d, 0x7d75},
	{0xbd7e, 0x7d76},
	{0xbd80, 0x7d78},
	{0xbd81, 0x7d79},
	{0xbd82, 0x7d7a},
	{0xbd83, 0x7d7b},
	{0xbd84, 0x7d7c},
	{0xbd85, 0x7d7d},
	{0xbd86, 0x7d7e},
	{0xbd87, 0x7d7f},
	{0xbd88, 0x7d80},
	{0xbd89, 0x7d81},
	{0xbd8a, 0x7d82},
	{0xbd8b, 0x7d83},
	{0xbd8c, 0x7d84},
	{0xbd8d, 0x7d85},
	{0xbd8e, 0x7d86},
	{0xbd8f, 0x7d87},
	{0xbd90, 0x7d88},
	{0xbd91, 0x7d89},
	{0xbd92, 0x7d8a},
	{0xbd93, 0x7d8b},
	{0xbd94, 0x7d8c},
	{0xbd95, 0x7d8d},
	{0xbd96, 0x7d8e},
	{0xbd97, 0x7d8f},
	{0xbd98, 0x7d90},
	{0xbd99, 0x7d91},
	{0xbd9a, 0x7d92},
	{0xbd9b, 0x7d93},
	{0xbd9c, 0x7d94},
	{0xbd9d, 0x7d95},
	{0xbd9e, 0x7d96},
	{0xbd9f, 0x7d97},
	{0xbda0, 0x7d98},
	{0xbda1, 0x5065},
	{0xbda2, 0x8230},
	{0xbda3, 0x5251},
	{0xbda4, 0x996f},
	{0xbda5, 0x6e10},
	{0xbda6, 0x6e85},
	{0xbda7, 0x6da7},
	{0xbda8, 0x5efa},
	{0xbda9, 0x50f5},
	{0xbdaa, 0x59dc},
	{0xbdab, 0x5c06},
	{0xbdac, 0x6d46},
	{0xbdad, 0x6c5f},
	{0xbdae, 0x7586},
	{0xbdaf, 0x848b},
	{0xbdb0, 0x6868},
	{0xbdb1, 0x5956},
	{0xbdb2, 0x8bb2},
	{0xbdb3, 0x5320},
	{0xbdb4, 0x9171},
	{0xbdb5, 0x964d},
	{0xbdb6, 0x8549},
	{0xbdb7, 0x6912},
	{0xbdb8, 0x7901},
	{0xbdb9, 0x7126},
	{0xbdba, 0x80f6},
	{0xbdbb, 0x4ea4},
	{0xbdbc, 0x90ca},
	{0xbdbd, 0x6d47},
	{0xbdbe, 0x9a84},
	{0xbdbf, 0x5a07},
	{0xbdc0, 0x56bc},
	{0xbdc1, 0x6405},
	{0xbdc2, 0x94f0},
	{0xbdc3, 0x77eb},
	{0xbdc4, 0x4fa5},
	{0xbdc5, 0x811a},
	{0xbdc6, 0x72e1},
	{0xbdc7, 0x89d2},
	{0xbdc8, 0x997a},
	{0xbdc9, 0x7f34},
	{0xbdca, 0x7ede},
	{0xbdcb, 0x527f},
	{0xbdcc, 0x6559},
	{0xbdcd, 0x9175},
	{0xbdce, 0x8f7f},
	{0xbdcf, 0x8f83},
	{0xbdd0, 0x53eb},
	{0xbdd1, 0x7a96},
	{0xbdd2, 0x63ed},
	{0xbdd3, 0x63a5},
	{0xbdd4, 0x7686},
	{0xbdd5, 0x79f8},
	{0xbdd6, 0x8857},
	{0xbdd7, 0x9636},
	{0xbdd8, 0x622a},
	{0xbdd9, 0x52ab},
	{0xbdda, 0x8282},
	{0xbddb, 0x6854},
	{0xbddc, 0x6770},
	{0xbddd, 0x6377},
	{0xbdde, 0x776b},
	{0xbddf, 0x7aed},
	{0xbde0, 0x6d01},
	{0xbde1, 0x7ed3},
	{0xbde2, 0x89e3},
	{0xbde3, 0x59d0},
	{0xbde4, 0x6212},
	{0xbde5, 0x85c9},
	{0xbde6, 0x82a5},
	{0xbde7, 0x754c},
	{0xbde8, 0x501f},
	{0xbde9, 0x4ecb},
	{0xbdea, 0x75a5},
	{0xbdeb, 0x8beb},
	{0xbdec, 0x5c4a},
	{0xbded, 0x5dfe},
	{0xbdee, 0x7b4b},
	{0xbdef, 0x65a4},
	{0xbdf0, 0x91d1},
	{0xbdf1, 0x4eca},
	{0xbdf2, 0x6d25},
	{0xbdf3, 0x895f},
	{0xbdf4, 0x7d27},
	{0xbdf5, 0x9526},
	{0xbdf6, 0x4ec5},
	{0xbdf7, 0x8c28},
	{0xbdf8, 0x8fdb},
	{0xbdf9, 0x9773},
	{0xbdfa, 0x664b},
	{0xbdfb, 0x7981},
	{0xbdfc, 0x8fd1},
	{0xbdfd, 0x70ec},
	{0xbdfe, 0x6d78},
	{0xbe40, 0x7d99},
	{0xbe41, 0x7d9a},
	{0xbe42, 0x7d9b},
	{0xbe43, 0x7d9c},
	{0xbe44, 0x7d9d},
	{0xbe45, 0x7d9e},
	{0xbe46, 0x7d9f},
	{0xbe47, 0x7da0},
	{0xbe48, 0x7da1},
	{0xbe49, 0x7da2},
	{0xbe4a, 0x7da3},
	{0xbe4b, 0x7da4},
	{0xbe4c, 0x7da5},
	{0xbe4d, 0x7da7},
	{0xbe4e, 0x7da8},
	{0xbe4f, 0x7da9},
	{0xbe50, 0x7daa},
	{0xbe51, 0x7dab},
	{0xbe52, 0x7dac},
	{0xbe53, 0x7dad},
	{0xbe54, 0x7daf},
	{0xbe55, 0x7db0},
	{0xbe56, 0x7db1},
	{0xbe57, 0x7db2},
	{0xbe58, 0x7db3},
	{0xbe59, 0x7db4},
	{0xbe5a, 0x7db5},
	{0xbe5b, 0x7db6},
	{0xbe5c, 0x7db7},
	{0xbe5d, 0x7db8},
	{0xbe5e, 0x7db9},
	{0xbe5f, 0x7dba},
	{0xbe60, 0x7dbb},
	{0xbe61, 0x7dbc},
	{0xbe62, 0x7dbd},
	{0xbe63, 0x7dbe},
	{0xbe64, 0x7dbf},
	{0xbe65, 0x7dc0},
	{0xbe66, 0x7dc1},
	{0xbe67, 0x7dc2},
	{0xbe68, 0x7dc3},
	{0xbe69, 0x7dc4},
	{0xbe6a, 0x7dc5},
	{0xbe6b, 0x7dc6},
	{0xbe6c, 0x7dc7},
	{0xbe6d, 0x7dc8},
	{0xbe6e, 0x7dc9},
	{0xbe6f, 0x7dca},
	{0xbe70, 0x7dcb},
	{0xbe71, 0x7dcc},
	{0xbe72, 0x7dcd},
	{0xbe73, 0x7dce},
	{0xbe74, 0x7dcf},
	{0xbe75, 0x7dd0},
	{0xbe76, 0x7dd1},
	{0xbe77, 0x7dd2},
	{0xbe78, 0x7dd3},
	{0xbe79, 0x7dd4},
	{0xbe7a, 0x7dd5},
	{0xbe7b, 0x7dd6},
	{0xbe7c, 0x7dd7},
	{0xbe7d, 0x7dd8},
	{0xbe7e, 0x7dd9},
	{0xbe80, 0x7dda},
	{0xbe81, 0x7ddb},
	{0xbe82, 0x7ddc},
	{0xbe83, 0x7ddd},
	{0xbe84, 0x7dde},
	{0xbe85, 0x7ddf},
	{0xbe86, 0x7de0},
	{0xbe87, 0x7de1},
	{0xbe88, 0x7de2},
	{0xbe89, 0x7de3},
	{0xbe8a, 0x7de4},
	{0xbe8b, 0x7de5},
	{0xbe8c, 0x7de6},
	{0xbe8d, 0x7de7},
	{0xbe8e, 0x7de8},
	{0xbe8f, 0x7de9},
	{0xbe90, 0x7dea},
	{0xbe91, 0x7deb},
	{0xbe92, 0x7dec},
	{0xbe93, 0x7ded},
	{0xbe94, 0x7dee},
	{0xbe95, 0x7def},
	{0xbe96, 0x7df0},
	{0xbe97, 0x7df1},
	{0xbe98, 0x7df2},
	{0xbe99, 0x7df3},
	{0xbe9a, 0x7df4},
	{0xbe9b, 0x7df5},
	{0xbe9c, 0x7df6},
	{0xbe9d, 0x7df7},
	{0xbe9e, 0x7df8},
	{0xbe9f, 0x7df9},
	{0xbea0, 0x7dfa},
	{0xbea1, 0x5c3d},
	{0xbea2, 0x52b2},
	{0xbea3, 0x8346},
	{0xbea4, 0x5162},
	{0xbea5, 0x830e},
	{0xbea6, 0x775b},
	{0xbea7, 0x6676},
	{0xbea8, 0x9cb8},
	{0xbea9, 0x4eac},
	{0xbeaa, 0x60ca},
	{0xbeab, 0x7cbe},
	{0xbeac, 0x7cb3},
	{0xbead, 0x7ecf},
	{0xbeae, 0x4e95},
	{0xbeaf, 0x8b66},
	{0xbeb0, 0x666f},
	{0xbeb1, 0x9888},
	{0xbeb2, 0x9759},
	{0xbeb3, 0x5883},
	{0xbeb4, 0x656c},
	{0xbeb5, 0x955c},
	{0xbeb6, 0x5f84},
	{0xbeb7, 0x75c9},
	{0xbeb8, 0x9756},
	{0xbeb9, 0x7adf},
	{0xbeba, 0x7ade},
	{0xbebb, 0x51c0},
	{0xbebc, 0x70af},
	{0xbebd, 0x7a98},
	{0xbebe, 0x63ea},
	{0xbebf, 0x7a76},
	{0xbec0, 0x7ea0},
	{0xbec1, 0x7396},
	{0xbec2, 0x97ed},
	{0xbec3, 0x4e45},
	{0xbec4, 0x7078},
	{0xbec5, 0x4e5d},
	{0xbec6, 0x9152},
	{0xbec7, 0x53a9},
	{0xbec8, 0x6551},
	{0xbec9, 0x65e7},
	{0xbeca, 0x81fc},
	{0xbecb, 0x8205},
	{0xbecc, 0x548e},
	{0xbecd, 0x5c31},
	{0xbece, 0x759a},
	{0xbecf, 0x97a0},
	{0xbed0, 0x62d8},
	{0xbed1, 0x72d9},
	{0xbed2, 0x75bd},
	{0xbed3, 0x5c45},
	{0xbed4, 0x9a79},
	{0xbed5, 0x83ca},
	{0xbed6, 0x5c40},
	{0xbed7, 0x5480},
	{0xbed8, 0x77e9},
	{0xbed9, 0x4e3e},
	{0xbeda, 0x6cae},
	{0xbedb, 0x805a},
	{0xbedc, 0x62d2},
	{0xbedd, 0x636e},
	{0xbede, 0x5de8},
	{0xbedf, 0x5177},
	{0xbee0, 0x8ddd},
	{0xbee1, 0x8e1e},
	{0xbee2, 0x952f},
	{0xbee3, 0x4ff1},
	{0xbee4, 0x53e5},
	{0xbee5, 0x60e7},
	{0xbee6, 0x70ac},
	{0xbee7, 0x5267},
	{0xbee8, 0x6350},
	{0xbee9, 0x9e43},
	{0xbeea, 0x5a1f},
	{0xbeeb, 0x5026},
	{0xbeec, 0x7737},
	{0xbeed, 0x5377},
	{0xbeee, 0x7ee2},
	{0xbeef, 0x6485},
	{0xbef0, 0x652b},
	{0xbef1, 0x6289},
	{0xbef2, 0x6398},
	{0xbef3, 0x5014},
	{0xbef4, 0x7235},
	{0xbef5, 0x89c9},
	{0xbef6, 0x51b3},
	{0xbef7, 0x8bc0},
	{0xbef8, 0x7edd},
	{0xbef9, 0x5747},
	{0xbefa, 0x83cc},
	{0xbefb, 0x94a7},
	{0xbefc, 0x519b},
	{0xbefd, 0x541b},
	{0xbefe, 0x5cfb},
	{0xbf40, 0x7dfb},
	{0xbf41, 0x7dfc},
	{0xbf42, 0x7dfd},
	{0xbf43, 0x7dfe},
	{0xbf44, 0x7dff},
	{0xbf45, 0x7e00},
	{0xbf46, 0x7e01},
	{0xbf47, 0x7e02},
	{0xbf48, 0x7e03},
	{0xbf49, 0x7e04},
	{0xbf4a, 0x7e05},
	{0xbf4b, 0x7e06},
	{0xbf4c, 0x7e07},
	{0xbf4d, 0x7e08},
	{0xbf4e, 0x7e09},
	{0xbf4f, 0x7e0a},
	{0xbf50, 0x7e0b},
	{0xbf51, 0x7e0c},
	{0xbf52, 0x7e0d},
	{0xbf53, 0x7e0e},
	{0xbf54, 0x7e0f},
	{0xbf55, 0x7e10},
	{0xbf56, 0x7e11},
	{0xbf57, 0x7e12},
	{0xbf58, 0x7e13},
	{0xbf59, 0x7e14},
	{0xbf5a, 0x7e15},
	{0xbf5b, 0x7e16},
	{0xbf5c, 0x7e17},
	{0xbf5d, 0x7e18},
	{0xbf5e, 0x7e19},
	{0xbf5f, 0x7e1a},
	{0xbf60, 0x7e1b},
	{0xbf61, 0x7e1c},
	{0xbf62, 0x7e1d},
	{0xbf63, 0x7e1e},
	{0xbf64, 0x7e1f},
	{0xbf65, 0x7e20},
	{0xbf66, 0x7e21},
	{0xbf67, 0x7e22},
	{0xbf68, 0x7e23},
	{0xbf69, 0x7e24},
	{0xbf6a, 0x7e25},
	{0xbf6b, 0x7e26},
	{0xbf6c, 0x7e27},
	{0xbf6d, 0x7e28},
	{0xbf6e, 0x7e29},
	{0xbf6f, 0x7e2a},
	{0xbf70, 0x7e2b},
	{0xbf71, 0x7e2c},
	{0xbf72, 0x7e2d},
	{0xbf73, 0x7e2e},
	{0xbf74, 0x7e2f},
	{0xbf75, 0x7e30},
	{0xbf76, 0x7e31},
	{0xbf77, 0x7e32},
	{0xbf78, 0x7e33},
	{0xbf79, 0x7e34},
	{0xbf7a, 0x7e35},
	{0xbf7b, 0x7e36},
	{0xbf7c, 0x7e37},
	{0xbf7d, 0x7e38},
	{0xbf7e, 0x7e39},
	{0xbf80, 0x7e3a},
	{0xbf81, 0x7e3c},
	{0xbf82, 0x7e3d},
	{0xbf83, 0x7e3e},
	{0xbf84, 0x7e3f},
	{0xbf85, 0x7e40},
	{0xbf86, 0x7e42},
	{0xbf87, 0x7e43},
	{0xbf88, 0x7e44},
	{0xbf89, 0x7e45},
	{0xbf8a, 0x7e46},
	{0xbf8b, 0x7e48},
	{0xbf8c, 0x7e49},
	{0xbf8d, 0x7e4a},
	{0xbf8e, 0x7e4b},
	{0xbf8f, 0x7e4c},
	{0xbf90, 0x7e4d},
	{0xbf91, 0x7e4e},
	{0xbf92, 0x7e4f},
	{0xbf93, 0x7e50},
	{0xbf94, 0x7e51},
	{0xbf95, 0x7e52},
	{0xbf96, 0x7e53},
	{0xbf97, 0x7e54},
	{0xbf98, 0x7e55},
	{0xbf99, 0x7e56},
	{0xbf9a, 0x7e57},
	{0xbf9b, 0x7e58},
	{0xbf9c, 0x7e59},
	{0xbf9d, 0x7e5a},
	{0xbf9e, 0x7e5b},
	{0xbf9f, 0x7e5c},
	{0xbfa0, 0x7e5d},
	{0xbfa1, 0x4fca},
	{0xbfa2, 0x7ae3},
	{0xbfa3, 0x6d5a},
	{0xbfa4, 0x90e1},
	{0xbfa5, 0x9a8f},
	{0xbfa6, 0x5580},
	{0xbfa7, 0x5496},
	{0xbfa8, 0x5361},
	{0xbfa9, 0x54af},
	{0xbfaa, 0x5f00},
	{0xbfab, 0x63e9},
	{0xbfac, 0x6977},
	{0xbfad, 0x51ef},
	{0xbfae, 0x6168},
	{0xbfaf, 0x520a},
	{0xbfb0, 0x582a},
	{0xbfb1, 0x52d8},
	{0xbfb2, 0x574e},
	{0xbfb3, 0x780d},
	{0xbfb4, 0x770b},
	{0xbfb5, 0x5eb7},
	{0xbfb6, 0x6177},
	{0xbfb7, 0x7ce0},
	{0xbfb8, 0x625b},
	{0xbfb9, 0x6297},
	{0xbfba, 0x4ea2},
	{0xbfbb, 0x7095},
	{0xbfbc, 0x8003},
	{0xbfbd, 0x62f7},
	{0xbfbe, 0x70e4},
	{0xbfbf, 0x9760},
	{0xbfc0, 0x5777},
	{0xbfc1, 0x82db},
	{0xbfc2, 0x67ef},
	{0xbfc3, 0x68f5},
	{0xbfc4, 0x78d5},
	{0xbfc5, 0x9897},
	{0xbfc6, 0x79d1},
	{0xbfc7, 0x58f3},
	{0xbfc8, 0x54b3},
	{0xbfc9, 0x53ef},
	{0xbfca, 0x6e34},
	{0xbfcb, 0x514b},
	{0xbfcc, 0x523b},
	{0xbfcd, 0x5ba2},
	{0xbfce, 0x8bfe},
	{0xbfcf, 0x80af},
	{0xbfd0, 0x5543},
	{0xbfd1, 0x57a6},
	{0xbfd2, 0x6073},
	{0xbfd3, 0x5751},
	{0xbfd4, 0x542d},
	{0xbfd5, 0x7a7a},
	{0xbfd6, 0x6050},
	{0xbfd7, 0x5b54},
	{0xbfd8, 0x63a7},
	{0xbfd9, 0x62a0},
	{0xbfda, 0x53e3},
	{0xbfdb, 0x6263},
	{0xbfdc, 0x5bc7},
	{0xbfdd, 0x67af},
	{0xbfde, 0x54ed},
	{0xbfdf, 0x7a9f},
	{0xbfe0, 0x82e6},
	{0xbfe1, 0x9177},
	{0xbfe2, 0x5e93},
	{0xbfe3, 0x88e4},
	{0xbfe4, 0x5938},
	{0xbfe5, 0x57ae},
	{0xbfe6, 0x630e},
	{0xbfe7, 0x8de8},
	{0xbfe8, 0x80ef},
	{0xbfe9, 0x5757},
	{0xbfea, 0x7b77},
	{0xbfeb, 0x4fa9},
	{0xbfec, 0x5feb},
	{0xbfed, 0x5bbd},
	{0xbfee, 0x6b3e},
	{0xbfef, 0x5321},
	{0xbff0, 0x7b50},
	{0xbff1, 0x72c2},
	{0xbff2, 0x6846},
	{0xbff3, 0x77ff},
	{0xbff4, 0x7736},
	{0xbff5, 0x65f7},
	{0xbff6, 0x51b5},
	{0xbff7, 0x4e8f},
	{0xbff8, 0x76d4},
	{0xbff9, 0x5cbf},
	{0xbffa, 0x7aa5},
	{0xbffb, 0x8475},
	{0xbffc, 0x594e},
	{0xbffd, 0x9b41},
	{0xbffe, 0x5080},
	{0xc040, 0x7e5e},
	{0xc041, 0x7e5f},
	{0xc042, 0x7e60},
	{0xc043, 0x7e61},
	{0xc044, 0x7e62},
	{0xc045, 0x7e63},
	{0xc046, 0x7e64},
	{0xc047, 0x7e65},
	{0xc048, 0x7e66},
	{0xc049, 0x7e67},
	{0xc04a, 0x7e68},
	{0xc04b, 0x7e69},
	{0xc04c, 0x7e6a},
	{0xc04d, 0x7e6b},
	{0xc04e, 0x7e6c},
	{0xc04f, 0x7e6d},
	{0xc050, 0x7e6e},
	{0xc051, 0x7e6f},
	{0xc052, 0x7e70},
	{0xc053, 0x7e71},
	{0xc054, 0x7e72},
	{0xc055, 0x7e73},
	{0xc056, 0x7e74},
	{0xc057, 0x7e75},
	{0xc058, 0x7e76},
	{0xc059, 0x7e77},
	{0xc05a, 0x7e78},
	{0xc05b, 0x7e79},
	{0xc05c, 0x7e7a},
	{0xc05d, 0x7e7b},
	{0xc05e, 0x7e7c},
	{0xc05f, 0x7e7d},
	{0xc060, 0x7e7e},
	{0xc061, 0x7e7f},
	{0xc062, 0x7e80},
	{0xc063, 0x7e81},
	{0xc064, 0x7e83},
	{0xc065, 0x7e84},
	{0xc066, 0x7e85},
	{0xc067, 0x7e86},
	{0xc068, 0x7e87},
	{0xc069, 0x7e88},
	{0xc06a, 0x7e89},
	{0xc06b, 0x7e8a},
	{0xc06c, 0x7e8b},
	{0xc06d, 0x7e8c},
	{0xc06e, 0x7e8d},
	{0xc06f, 0x7e8e},
	{0xc070, 0x7e8f},
	{0xc071, 0x7e90},
	{0xc072, 0x7e91},
	{0xc073, 0x7e92},
	{0xc074, 0x7e93},
	{0xc075, 0x7e94},
	{0xc076, 0x7e95},
	{0xc077, 0x7e96},
	{0xc078, 0x7e97},
	{0xc079, 0x7e98},
	{0xc07a, 0x7e99},
	{0xc07b, 0x7e9a},
	{0xc07c, 0x7e9c},
	{0xc07d, 0x7e9d},
	{0xc07e, 0x7e9e},
	{0xc080, 0x7eae},
	{0xc081, 0x7eb4},
	{0xc082, 0x7ebb},
	{0xc083, 0x7ebc},
	{0xc084, 0x7ed6},
	{0xc085, 0x7ee4},
	{0xc086, 0x7eec},
	{0xc087, 0x7ef9},
	{0xc088, 0x7f0a},
	{0xc089, 0x7f10},
	{0xc08a, 0x7f1e},
	{0xc08b, 0x7f37},
	{0xc08c, 0x7f39},
	{0xc08d, 0x7f3b},
	{0xc08e, 0x7f3c},
	{0xc08f, 0x7f3d},
	{0xc090, 0x7f3e},
	{0xc091, 0x7f3f},
	{0xc092, 0x7f40},
	{0xc093, 0x7f41},
	{0xc094, 0x7f43},
	{0xc095, 0x7f46},
	{0xc096, 0x7f47},
	{0xc097, 0x7f48},
	{0xc098, 0x7f49},
	{0xc099, 0x7f4a},
	{0xc09a, 0x7f4b},
	{0xc09b, 0x7f4c},
	{0xc09c, 0x7f4d},
	{0xc09d, 0x7f4e},
	{0xc09e, 0x7f4f},
	{0xc09f, 0x7f52},
	{0xc0a0, 0x7f53},
	{0xc0a1, 0x9988},
	{0xc0a2, 0x6127},
	{0xc0a3, 0x6e83},
	{0xc0a4, 0x5764},
	{0xc0a5, 0x6606},
	{0xc0a6, 0x6346},
	{0xc0a7, 0x56f0},
	{0xc0a8, 0x62ec},
	{0xc0a9, 0x6269},
	{0xc0aa, 0x5ed3},
	{0xc0ab, 0x9614},
	{0xc0ac, 0x5783},
	{0xc0ad, 0x62c9},
	{0xc0ae, 0x5587},
	{0xc0af, 0x8721},
	{0xc0b0, 0x814a},
	{0xc0b1, 0x8fa3},
	{0xc0b2, 0x5566},
	{0xc0b3, 0x83b1},
	{0xc0b4, 0x6765},
	{0xc0b5, 0x8d56},
	{0xc0b6, 0x84dd},
	{0xc0b7, 0x5a6a},
	{0xc0b8, 0x680f},
	{0xc0b9, 0x62e6},
	{0xc0ba, 0x7bee},
	{0xc0bb, 0x9611},
	{0xc0bc, 0x5170},
	{0xc0bd, 0x6f9c},
	{0xc0be, 0x8c30},
	{0xc0bf, 0x63fd},
	{0xc0c0, 0x89c8},
	{0xc0c1, 0x61d2},
	{0xc0c2, 0x7f06},
	{0xc0c3, 0x70c2},
	{0xc0c4, 0x6ee5},
	{0xc0c5, 0x7405},
	{0xc0c6, 0x6994},
	{0xc0c7, 0x72fc},
	{0xc0c8, 0x5eca},
	{0xc0c9, 0x90ce},
	{0xc0ca, 0x6717},
	{0xc0cb, 0x6d6a},
	{0xc0cc, 0x635e},
	{0xc0cd, 0x52b3},
	{0xc0ce, 0x7262},
	{0xc0cf, 0x8001},
	{0xc0d0, 0x4f6c},
	{0xc0d1, 0x59e5},
	{0xc0d2, 0x916a},
	{0xc0d3, 0x70d9},
	{0xc0d4, 0x6d9d},
	{0xc0d5, 0x52d2},
	{0xc0d6, 0x4e50},
	{0xc0d7, 0x96f7},
	{0xc0d8, 0x956d},
	{0xc0d9, 0x857e},
	{0xc0da, 0x78ca},
	{0xc0db, 0x7d2f},
	{0xc0dc, 0x5121},
	{0xc0dd, 0x5792},
	{0xc0de, 0x64c2},
	{0xc0df, 0x808b},
	{0xc0e0, 0x7c7b},
	{0xc0e1, 0x6cea},
	{0xc0e2, 0x68f1},
	{0xc0e3, 0x695e},
	{0xc0e4, 0x51b7},
	{0xc0e5, 0x5398},
	{0xc0e6, 0x68a8},
	{0xc0e7, 0x7281},
	{0xc0e8, 0x9ece},
	{0xc0e9, 0x7bf1},
	{0xc0ea, 0x72f8},
	{0xc0eb, 0x79bb},
	{0xc0ec, 0x6f13},
	{0xc0ed, 0x7406},
	{0xc0ee, 0x674e},
	{0xc0ef, 0x91cc},
	{0xc0f0, 0x9ca4},
	{0xc0f1, 0x793c},
	{0xc0f2, 0x8389},
	{0xc0f3, 0x8354},
	{0xc0f4, 0x540f},
	{0xc0f5, 0x6817},
	{0xc0f6, 0x4e3d},
	{0xc0f7, 0x5389},
	{0xc0f8, 0x52b1},
	{0xc0f9, 0x783e},
	{0xc0fa, 0x5386},
	{0xc0fb, 0x5229},
	{0xc0fc, 0x5088},
	{0xc0fd, 0x4f8b},
	{0xc0fe, 0x4fd0},
	{0xc140, 0x7f56},
	{0xc141, 0x7f59},
	{0xc142, 0x7f5b},
	{0xc143, 0x7f5c},
	{0xc144, 0x7f5d},
	{0xc145, 0x7f5e},
	{0xc146, 0x7f60},
	{0xc147, 0x7f63},
	{0xc148, 0x7f64},
	{0xc149, 0x7f65},
	{0xc14a, 0x7f66},
	{0xc14b, 0x7f67},
	{0xc14c, 0x7f6b},
	{0xc14d, 0x7f6c},
	{0xc14e, 0x7f6d},
	{0xc14f, 0x7f6f},
	{0xc150, 0x7f70},
	{0xc151, 0x7f73},
	{0xc152, 0x7f75},
	{0xc153, 0x7f76},
	{0xc154, 0x7f77},
	{0xc155, 0x7f78},
	{0xc156, 0x7f7a},
	{0xc157, 0x7f7b},
	{0xc158, 0x7f7c},
	{0xc159, 0x7f7d},
	{0xc15a, 0x7f7f},
	{0xc15b, 0x7f80},
	{0xc15c, 0x7f82},
	{0xc15d, 0x7f83},
	{0xc15e, 0x7f84},
	{0xc15f, 0x7f85},
	{0xc160, 0x7f86},
	{0xc161, 0x7f87},
	{0xc162, 0x7f88},
	{0xc163, 0x7f89},
	{0xc164, 0x7f8b},
	{0xc165, 0x7f8d},
	{0xc166, 0x7f8f},
	{0xc167, 0x7f90},
	{0xc168, 0x7f91},
	{0xc169, 0x7f92},
	{0xc16a, 0x7f93},
	{0xc16b, 0x7f95},
	{0xc16c, 0x7f96},
	{0xc16d, 0x7f97},
	{0xc16e, 0x7f98},
	{0xc16f, 0x7f99},
	{0xc170, 0x7f9b},
	{0xc171, 0x7f9c},
	{0xc172, 0x7fa0},
	{0xc173, 0x7fa2},
	{0xc174, 0x7fa3},
	{0xc175, 0x7fa5},
	{0xc176, 0x7fa6},
	{0xc177, 0x7fa8},
	{0xc178, 0x7fa9},
	{0xc179, 0x7faa},
	{0xc17a, 0x7fab},
	{0xc17b, 0x7fac},
	{0xc17c, 0x7fad},
	{0xc17d, 0x7fae},
	{0xc17e, 0x7fb1},
	{0xc180, 0x7fb3},
	{0xc181, 0x7fb4},
	{0xc182, 0x7fb5},
	{0xc183, 0x7fb6},
	{0xc184, 0x7fb7},
	{0xc185, 0x7fba},
	{0xc186, 0x7fbb},
	{0xc187, 0x7fbe},
	{0xc188, 0x7fc0},
	{0xc189, 0x7fc2},
	{0xc18a, 0x7fc3},
	{0xc18b, 0x7fc4},
	{0xc18c, 0x7fc6},
	{0xc18d, 0x7fc7},
	{0xc18e, 0x7fc8},
	{0xc18f, 0x7fc9},
	{0xc190, 0x7fcb},
	{0xc191, 0x7fcd},
	{0xc192, 0x7fcf},
	{0xc193, 0x7fd0},
	{0xc194, 0x7fd1},
	{0xc195, 0x7fd2},
	{0xc196, 0x7fd3},
	{0xc197, 0x7fd6},
	{0xc198, 0x7fd7},
	{0xc199, 0x7fd9},
	{0xc19a, 0x7fda},
	{0xc19b, 0x7fdb},
	{0xc19c, 0x7fdc},
	{0xc19d, 0x7fdd},
	{0xc19e, 0x7fde},
	{0xc19f, 0x7fe2},
	{0xc1a0, 0x7fe3},
	{0xc1a1, 0x75e2},
	{0xc1a2, 0x7acb},
	{0xc1a3, 0x7c92},
	{0xc1a4, 0x6ca5},
	{0xc1a5, 0x96b6},
	{0xc1a6, 0x529b},
	{0xc1a7, 0x7483},
	{0xc1a8, 0x54e9},
	{0xc1a9, 0x4fe9},
	{0xc1aa, 0x8054},
	{0xc1ab, 0x83b2},
	{0xc1ac, 0x8fde},
	{0xc1ad, 0x9570},
	{0xc1ae, 0x5ec9},
	{0xc1af, 0x601c},
	{0xc1b0, 0x6d9f},
	{0xc1b1, 0x5e18},
	{0xc1b2, 0x655b},
	{0xc1b3, 0x8138},
	{0xc1b4, 0x94fe},
	{0xc1b5, 0x604b},
	{0xc1b6, 0x70bc},
	{0xc1b7, 0x7ec3},
	{0xc1b8, 0x7cae},
	{0xc1b9, 0x51c9},
	{0xc1ba, 0x6881},
	{0xc1bb, 0x7cb1},
	{0xc1bc, 0x826f},
	{0xc1bd, 0x4e24},
	{0xc1be, 0x8f86},
	{0xc1bf, 0x91cf},
	{0xc1c0, 0x667e},
	{0xc1c1, 0x4eae},
	{0xc1c2, 0x8c05},
	{0xc1c3, 0x64a9},
	{0xc1c4, 0x804a},
	{0xc1c5, 0x50da},
	{0xc1c6, 0x7597},
	{0xc1c7, 0x71ce},
	{0xc1c8, 0x5be5},
	{0xc1c9, 0x8fbd},
	{0xc1ca, 0x6f66},
	{0xc1cb, 0x4e86},
	{0xc1cc, 0x6482},
	{0xc1cd, 0x9563},
	{0xc1ce, 0x5ed6},
	{0xc1cf, 0x6599},
	{0xc1d0, 0x5217},
	{0xc1d1, 0x88c2},
	{0xc1d2, 0x70c8},
	{0xc1d3, 0x52a3},
	{0xc1d4, 0x730e},
	{0xc1d5, 0x7433},
	{0xc1d6, 0x6797},
	{0xc1d7, 0x78f7},
	{0xc1d8, 0x9716},
	{0xc1d9, 0x4e34},
	{0xc1da, 0x90bb},
	{0xc1db, 0x9cde},
	{0xc1dc, 0x6dcb},
	{0xc1dd, 0x51db},
	{0xc1de, 0x8d41},
	{0xc1df, 0x541d},
	{0xc1e0, 0x62ce},
	{0xc1e1, 0x73b2},
	{0xc1e2, 0x83f1},
	{0xc1e3, 0x96f6},
	{0xc1e4, 0x9f84},
	{0xc1e5, 0x94c3},
	{0xc1e6, 0x4f36},
	{0xc1e7, 0x7f9a},
	{0xc1e8, 0x51cc},
	{0xc1e9, 0x7075},
	{0xc1ea, 0x9675},
	{0xc1eb, 0x5cad},
	{0xc1ec, 0x9886},
	{0xc1ed, 0x53e6},
	{0xc1ee, 0x4ee4},
	{0xc1ef, 0x6e9c},
	{0xc1f0, 0x7409},
	{0xc1f1, 0x69b4},
	{0xc1f2, 0x786b},
	{0xc1f3, 0x998f},
	{0xc1f4, 0x7559},
	{0xc1f5, 0x5218},
	{0xc1f6, 0x7624},
	{0xc1f7, 0x6d41},
	{0xc1f8, 0x67f3},
	{0xc1f9, 0x516d},
	{0xc1fa, 0x9f99},
	{0xc1fb, 0x804b},
	{0xc1fc, 0x5499},
	{0xc1fd, 0x7b3c},
	{0xc1fe, 0x7abf},
	{0xc240, 0x7fe4},
	{0xc241, 0x7fe7},
	{0xc242, 0x7fe8},
	{0xc243, 0x7fea},
	{0xc244, 0x7feb},
	{0xc245, 0x7fec},
	{0xc246, 0x7fed},
	{0xc247, 0x7fef},
	{0xc248, 0x7ff2},
	{0xc249, 0x7ff4},
	{0xc24a, 0x7ff5},
	{0xc24b, 0x7ff6},
	{0xc24c, 0x7ff7},
	{0xc24d, 0x7ff8},
	{0xc24e, 0x7ff9},
	{0xc24f, 0x7ffa},
	{0xc250, 0x7ffd},
	{0xc251, 0x7ffe},
	{0xc252, 0x7fff},
	{0xc253, 0x8002},
	{0xc254, 0x8007},
	{0xc255, 0x8008},
	{0xc256, 0x8009},
	{0xc257, 0x800a},
	{0xc258, 0x800e},
	{0xc259, 0x800f},
	{0xc25a, 0x8011},
	{0xc25b, 0x8013},
	{0xc25c, 0x801a},
	{0xc25d, 0x801b},
	{0xc25e, 0x801d},
	{0xc25f, 0x801e},
	{0xc260, 0x801f},
	{0xc261, 0x8021},
	{0xc262, 0x8023},
	{0xc263, 0x8024},
	{0xc264, 0x802b},
	{0xc265, 0x802c},
	{0xc266, 0x802d},
	{0xc267, 0x802e},
	{0xc268, 0x802f},
	{0xc269, 0x8030},
	{0xc26a, 0x8032},
	{0xc26b, 0x8034},
	{0xc26c, 0x8039},
	{0xc26d, 0x803a},
	{0xc26e, 0x803c},
	{0xc26f, 0x803e},
	{0xc270, 0x8040},
	{0xc271, 0x8041},
	{0xc272, 0x8044},
	{0xc273, 0x8045},
	{0xc274, 0x8047},
	{0xc275, 0x8048},
	{0xc276, 0x8049},
	{0xc277, 0x804e},
	{0xc278, 0x804f},
	{0xc279, 0x8050},
	{0xc27a, 0x8051},
	{0xc27b, 0x8053},
	{0xc27c, 0x8055},
	{0xc27d, 0x8056},
	{0xc27e, 0x8057},
	{0xc280, 0x8059},
	{0xc281, 0x805b},
	{0xc282, 0x805c},
	{0xc283, 0x805d},
	{0xc284, 0x805e},
	{0xc285, 0x805f},
	{0xc286, 0x8060},
	{0xc287, 0x8061},
	{0xc288, 0x8062},
	{0xc289, 0x8063},
	{0xc28a, 0x8064},
	{0xc28b, 0x8065},
	{0xc28c, 0x8066},
	{0xc28d, 0x8067},
	{0xc28e, 0x8068},
	{0xc28f, 0x806b},
	{0xc290, 0x806c},
	{0xc291, 0x806d},
	{0xc292, 0x806e},
	{0xc293, 0x806f},
	{0xc294, 0x8070},
	{0xc295, 0x8072},
	{0xc296, 0x8073},
	{0xc297, 0x8074},
	{0xc298, 0x8075},
	{0xc299, 0x8076},
	{0xc29a, 0x8077},
	{0xc29b, 0x8078},
	{0xc29c, 0x8079},
	{0xc29d, 0x807a},
	{0xc29e, 0x807b},
	{0xc29f, 0x807c},
	{0xc2a0, 0x807d},
	{0xc2a1, 0x9686},
	{0xc2a2, 0x5784},
	{0xc2a3, 0x62e2},
	{0xc2a4, 0x9647},
	{0xc2a5, 0x697c},
	{0xc2a6, 0x5a04},
	{0xc2a7, 0x6402},
	{0xc2a8, 0x7bd3},
	{0xc2a9, 0x6f0f},
	{0xc2aa, 0x964b},
	{0xc2ab, 0x82a6},
	{0xc2ac, 0x5362},
	{0xc2ad, 0x9885},
	{0xc2ae, 0x5e90},
	{0xc2af, 0x7089},
	{0xc2b0, 0x63b3},
	{0xc2b1, 0x5364},
	{0xc2b2, 0x864f},
	{0xc2b3, 0x9c81},
	{0xc2b4, 0x9e93},
	{0xc2b5, 0x788c},
	{0xc2b6, 0x9732},
	{0xc2b7, 0x8def},
	{0xc2b8, 0x8d42},
	{0xc2b9, 0x9e7f},
	{0xc2ba, 0x6f5e},
	{0xc2bb, 0x7984},
	{0xc2bc, 0x5f55},
	{0xc2bd, 0x9646},
	{0xc2be, 0x622e},
	{0xc2bf, 0x9a74},
	{0xc2c0, 0x5415},
	{0xc2c1, 0x94dd},
	{0xc2c2, 0x4fa3},
	{0xc2c3, 0x65c5},
	{0xc2c4, 0x5c65},
	{0xc2c5, 0x5c61},
	{0xc2c6, 0x7f15},
	{0xc2c7, 0x8651},
	{0xc2c8, 0x6c2f},
	{0xc2c9, 0x5f8b},
	{0xc2ca, 0x7387},
	{0xc2cb, 0x6ee4},
	{0xc2cc, 0x7eff},
	{0xc2cd, 0x5ce6},
	{0xc2ce, 0x631b},
	{0xc2cf, 0x5b6a},
	{0xc2d0, 0x6ee6},
	{0xc2d1, 0x5375},
	{0xc2d2, 0x4e71},
	{0xc2d3, 0x63a0},
	{0xc2d4, 0x7565},
	{0xc2d5, 0x62a1},
	{0xc2d6, 0x8f6e},
	{0xc2d7, 0x4f26},
	{0xc2d8, 0x4ed1},
	{0xc2d9, 0x6ca6},
	{0xc2da, 0x7eb6},
	{0xc2db, 0x8bba},
	{0xc2dc, 0x841d},
	{0xc2dd, 0x87ba},
	{0xc2de, 0x7f57},
	{0xc2df, 0x903b},
	{0xc2e0, 0x9523},
	{0xc2e1, 0x7ba9},
	{0xc2e2, 0x9aa1},
	{0xc2e3, 0x88f8},
	{0xc2e4, 0x843d},
	{0xc2e5, 0x6d1b},
	{0xc2e6, 0x9a86},
	{0xc2e7, 0x7edc},
	{0xc2e8, 0x5988},
	{0xc2e9, 0x9ebb},
	{0xc2ea, 0x739b},
	{0xc2eb, 0x7801},
	{0xc2ec, 0x8682},
	{0xc2ed, 0x9a6c},
	{0xc2ee, 0x9a82},
	{0xc2ef, 0x561b},
	{0xc2f0, 0x5417},
	{0xc2f1, 0x57cb},
	{0xc2f2, 0x4e70},
	{0xc2f3, 0x9ea6},
	{0xc2f4, 0x5356},
	{0xc2f5, 0x8fc8},
	{0xc2f6, 0x8109},
	{0xc2f7, 0x7792},
	{0xc2f8, 0x9992},
	{0xc2f9, 0x86ee},
	{0xc2fa, 0x6ee1},
	{0xc2fb, 0x8513},
	{0xc2fc, 0x66fc},
	{0xc2fd, 0x6162},
	{0xc2fe, 0x6f2b},
	{0xc340, 0x807e},
	{0xc341, 0x8081},
	{0xc342, 0x8082},
	{0xc343, 0x8085},
	{0xc344, 0x8088},
	{0xc345, 0x808a},
	{0xc346, 0x808d},
	{0xc347, 0x808e},
	{0xc348, 0x808f},
	{0xc349, 0x8090},
	{0xc34a, 0x8091},
	{0xc34b, 0x8092},
	{0xc34c, 0x8094},
	{0xc34d, 0x8095},
	{0xc34e, 0x8097},
	{0xc34f, 0x8099},
	{0xc350, 0x809e},
	{0xc351, 0x80a3},
	{0xc352, 0x80a6},
	{0xc353, 0x80a7},
	{0xc354, 0x80a8},
	{0xc355, 0x80ac},
	{0xc356, 0x80b0},
	{0xc357, 0x80b3},
	{0xc358, 0x80b5},
	{0xc359, 0x80b6},
	{0xc35a, 0x80b8},
	{0xc35b, 0x80b9},
	{0xc35c, 0x80bb},
	{0xc35d, 0x80c5},
	{0xc35e, 0x80c7},
	{0xc35f, 0x80c8},
	{0xc360, 0x80c9},
	{0xc361, 0x80ca},
	{0xc362, 0x80cb},
	{0xc363, 0x80cf},
	{0xc364, 0x80d0},
	{0xc365, 0x80d1},
	{0xc366, 0x80d2},
	{0xc367, 0x80d3},
	{0xc368, 0x80d4},
	{0xc369, 0x80d5},
	{0xc36a, 0x80d8},
	{0xc36b, 0x80df},
	{0xc36c, 0x80e0},
	{0xc36d, 0x80e2},
	{0xc36e, 0x80e3},
	{0xc36f, 0x80e6},
	{0xc370, 0x80ee},
	{0xc371, 0x80f5},
	{0xc372, 0x80f7},
	{0xc373, 0x80f9},
	{0xc374, 0x80fb},
	{0xc375, 0x80fe},
	{0xc376, 0x80ff},
	{0xc377, 0x8100},
	{0xc378, 0x8101},
	{0xc379, 0x8103},
	{0xc37a, 0x8104},
	{0xc37b, 0x8105},
	{0xc37c, 0x8107},
	{0xc37d, 0x8108},
	{0xc37e, 0x810b},
	{0xc380, 0x810c},
	{0xc381, 0x8115},
	{0xc382, 0x8117},
	{0xc383, 0x8119},
	{0xc384, 0x811b},
	{0xc385, 0x811c},
	{0xc386, 0x811d},
	{0xc387, 0x811f},
	{0xc388, 0x8120},
	{0xc389, 0x8121},
	{0xc38a, 0x8122},
	{0xc38b, 0x8123},
	{0xc38c, 0x8124},
	{0xc38d, 0x8125},
	{0xc38e, 0x8126},
	{0xc38f, 0x8127},
	{0xc390, 0x8128},
	{0xc391, 0x8129},
	{0xc392, 0x812a},
	{0xc393, 0x812b},
	{0xc394, 0x812d},
	{0xc395, 0x812e},
	{0xc396, 0x8130},
	{0xc397, 0x8133},
	{0xc398, 0x8134},
	{0xc399, 0x8135},
	{0xc39a, 0x8137},
	{0xc39b, 0x8139},
	{0xc39c, 0x813a},
	{0xc39d, 0x813b},
	{0xc39e, 0x813c},
	{0xc39f, 0x813d},
	{0xc3a0, 0x813f},
	{0xc3a1, 0x8c29},
	{0xc3a2, 0x8292},
	{0xc3a3, 0x832b},
	{0xc3a4, 0x76f2},
	{0xc3a5, 0x6c13},
	{0xc3a6, 0x5fd9},
	{0xc3a7, 0x83bd},
	{0xc3a8, 0x732b},
	{0xc3a9, 0x8305},
	{0xc3aa, 0x951a},
	{0xc3ab, 0x6bdb},
	{0xc3ac, 0x77db},
	{0xc3ad, 0x94c6},
	{0xc3ae, 0x536f},
	{0xc3af, 0x8302},
	{0xc3b0, 0x5192},
	{0xc3b1, 0x5e3d},
	{0xc3b2, 0x8c8c},
	{0xc3b3, 0x8d38},
	{0xc3b4, 0x4e48},
	{0xc3b5, 0x73ab},
	{0xc3b6, 0x679a},
	{0xc3b7, 0x6885},
	{0xc3b8, 0x9176},
	{0xc3b9, 0x9709},
	{0xc3ba, 0x7164},
	{0xc3bb, 0x6ca1},
	{0xc3bc, 0x7709},
	{0xc3bd, 0x5a92},
	{0xc3be, 0x9541},
	{0xc3bf, 0x6bcf},
	{0xc3c0, 0x7f8e},
	{0xc3c1, 0x6627},
	{0xc3c2, 0x5bd0},
	{0xc3c3, 0x59b9},
	{0xc3c4, 0x5a9a},
	{0xc3c5, 0x95e8},
	{0xc3c6, 0x95f7},
	{0xc3c7, 0x4eec},
	{0xc3c8, 0x840c},
	{0xc3c9, 0x8499},
	{0xc3ca, 0x6aac},
	{0xc3cb, 0x76df},
	{0xc3cc, 0x9530},
	{0xc3cd, 0x731b},
	{0xc3ce, 0x68a6},
	{0xc3cf, 0x5b5f},
	{0xc3d0, 0x772f},
	{0xc3d1, 0x919a},
	{0xc3d2, 0x9761},
	{0xc3d3, 0x7cdc},
	{0xc3d4, 0x8ff7},
	{0xc3d5, 0x8c1c},
	{0xc3d6, 0x5f25},
	{0xc3d7, 0x7c73},
	{0xc3d8, 0x79d8},
	{0xc3d9, 0x89c5},
	{0xc3da, 0x6ccc},
	{0xc3db, 0x871c},
	{0xc3dc, 0x5bc6},
	{0xc3dd, 0x5e42},
	{0xc3de, 0x68c9},
	{0xc3df, 0x7720},
	{0xc3e0, 0x7ef5},
	{0xc3e1, 0x5195},
	{0xc3e2, 0x514d},
	{0xc3e3, 0x52c9},
	{0xc3e4, 0x5a29},
	{0xc3e5, 0x7f05},
	{0xc3e6, 0x9762},
	{0xc3e7, 0x82d7},
	{0xc3e8, 0x63cf},
	{0xc3e9, 0x7784},
	{0xc3ea, 0x85d0},
	{0xc3eb, 0x79d2},
	{0xc3ec, 0x6e3a},
	{0xc3ed, 0x5e99},
	{0xc3ee, 0x5999},
	{0xc3ef, 0x8511},
	{0xc3f0, 0x706d},
	{0xc3f1, 0x6c11},
	{0xc3f2, 0x62bf},
	{0xc3f3, 0x76bf},
	{0xc3f4, 0x654f},
	{0xc3f5, 0x60af},
	{0xc3f6, 0x95fd},
	{0xc3f7, 0x660e},
	{0xc3f8, 0x879f},
	{0xc3f9, 0x9e23},
	{0xc3fa, 0x94ed},
	{0xc3fb, 0x540d},
	{0xc3fc, 0x547d},
	{0xc3fd, 0x8c2c},
	{0xc3fe, 0x6478},
	{0xc440, 0x8140},
	{0xc441, 0x8141},
	{0xc442, 0x8142},
	{0xc443, 0x8143},
	{0xc444, 0x8144},
	{0xc445, 0x8145},
	{0xc446, 0x8147},
	{0xc447, 0x8149},
	{0xc448, 0x814d},
	{0xc449, 0x814e},
	{0xc44a, 0x814f},
	{0xc44b, 0x8152},
	{0xc44c, 0x8156},
	{0xc44d, 0x8157},
	{0xc44e, 0x8158},
	{0xc44f, 0x815b},
	{0xc450, 0x815c},
	{0xc451, 0x815d},
	{0xc452, 0x815e},
	{0xc453, 0x815f},
	{0xc454, 0x8161},
	{0xc455, 0x8162},
	{0xc456, 0x8163},
	{0xc457, 0x8164},
	{0xc458, 0x8166},
	{0xc459, 0x8168},
	{0xc45a, 0x816a},
	{0xc45b, 0x816b},
	{0xc45c, 0x816c},
	{0xc45d, 0x816f},
	{0xc45e, 0x8172},
	{0xc45f, 0x8173},
	{0xc460, 0x8175},
	{0xc461, 0x8176},
	{0xc462, 0x8177},
	{0xc463, 0x8178},
	{0xc464, 0x8181},
	{0xc465, 0x8183},
	{0xc466, 0x8184},
	{0xc467, 0x8185},
	{0xc468, 0x8186},
	{0xc469, 0x8187},
	{0xc46a, 0x8189},
	{0xc46b, 0x818b},
	{0xc46c, 0x818c},
	{0xc46d, 0x818d},
	{0xc46e, 0x818e},
	{0xc46f, 0x8190},
	{0xc470, 0x8192},
	{0xc471, 0x8193},
	{0xc472, 0x8194},
	{0xc473, 0x8195},
	{0xc474, 0x8196},
	{0xc475, 0x8197},
	{0xc476, 0x8199},
	{0xc477, 0x819a},
	{0xc478, 0x819e},
	{0xc479, 0x819f},
	{0xc47a, 0x81a0},
	{0xc47b, 0x81a1},
	{0xc47c, 0x81a2},
	{0xc47d, 0x81a4},
	{0xc47e, 0x81a5},
	{0xc480, 0x81a7},
	{0xc481, 0x81a9},
	{0xc482, 0x81ab},
	{0xc483, 0x81ac},
	{0xc484, 0x81ad},
	{0xc485, 0x81ae},
	{0xc486, 0x81af},
	{0xc487, 0x81b0},
	{0xc488, 0x81b1},
	{0xc489, 0x81b2},
	{0xc48a, 0x81b4},
	{0xc48b, 0x81b5},
	{0xc48c, 0x81b6},
	{0xc48d, 0x81b7},
	{0xc48e, 0x81b8},
	{0xc48f, 0x81b9},
	{0xc490, 0x81bc},
	{0xc491, 0x81bd},
	{0xc492, 0x81be},
	{0xc493, 0x81bf},
	{0xc494, 0x81c4},
	{0xc495, 0x81c5},
	{0xc496, 0x81c7},
	{0xc497, 0x81c8},
	{0xc498, 0x81c9},
	{0xc499, 0x81cb},
	{0xc49a, 0x81cd},
	{0xc49b, 0x81ce},
	{0xc49c, 0x81cf},
	{0xc49d, 0x81d0},
	{0xc49e, 0x81d1},
	{0xc49f, 0x81d2},
	{0xc4a0, 0x81d3},
	{0xc4a1, 0x6479},
	{0xc4a2, 0x8611},
	{0xc4a3, 0x6a21},
	{0xc4a4, 0x819c},
	{0xc4a5, 0x78e8},
	{0xc4a6, 0x6469},
	{0xc4a7, 0x9b54},
	{0xc4a8, 0x62b9},
	{0xc4a9, 0x672b},
	{0xc4aa, 0x83ab},
	{0xc4ab, 0x58a8},
	{0xc4ac, 0x9ed8},
	{0xc4ad, 0x6cab},
	{0xc4ae, 0x6f20},
	{0xc4af, 0x5bde},
	{0xc4b0, 0x964c},
	{0xc4b1, 0x8c0b},
	{0xc4b2, 0x725f},
	{0xc4b3, 0x67d0},
	{0xc4b4, 0x62c7},
	{0xc4b5, 0x7261},
	{0xc4b6, 0x4ea9},
	{0xc4b7, 0x59c6},
	{0xc4b8, 0x6bcd},
	{0xc4b9, 0x5893},
	{0xc4ba, 0x66ae},
	{0xc4bb, 0x5e55},
	{0xc4bc, 0x52df},
	{0xc4bd, 0x6155},
	{0xc4be, 0x6728},
	{0xc4bf, 0x76ee},
	{0xc4c0, 0x7766},
	{0xc4c1, 0x7267},
	{0xc4c2, 0x7a46},
	{0xc4c3, 0x62ff},
	{0xc4c4, 0x54ea},
	{0xc4c5, 0x5450},
	{0xc4c6, 0x94a0},
	{0xc4c7, 0x90a3},
	{0xc4c8, 0x5a1c},
	{0xc4c9, 0x7eb3},
	{0xc4ca, 0x6c16},
	{0xc4cb, 0x4e43},
	{0xc4cc, 0x5976},
	{0xc4cd, 0x8010},
	{0xc4ce, 0x5948},
	{0xc4cf, 0x5357},
	{0xc4d0, 0x7537},
	{0xc4d1, 0x96be},
	{0xc4d2, 0x56ca},
	{0xc4d3, 0x6320},
	{0xc4d4, 0x8111},
	{0xc4d5, 0x607c},
	{0xc4d6, 0x95f9},
	{0xc4d7, 0x6dd6},
	{0xc4d8, 0x5462},
	{0xc4d9, 0x9981},
	{0xc4da, 0x5185},
	{0xc4db, 0x5ae9},
	{0xc4dc, 0x80fd},
	{0xc4dd, 0x59ae},
	{0xc4de, 0x9713},
	{0xc4df, 0x502a},
	{0xc4e0, 0x6ce5},
	{0xc4e1, 0x5c3c},
	{0xc4e2, 0x62df},
	{0xc4e3, 0x4f60},
	{0xc4e4, 0x533f},
	{0xc4e5, 0x817b},
	{0xc4e6, 0x9006},
	{0xc4e7, 0x6eba},
	{0xc4e8, 0x852b},
	{0xc4e9, 0x62c8},
	{0xc4ea, 0x5e74},
	{0xc4eb, 0x78be},
	{0xc4ec, 0x64b5},
	{0xc4ed, 0x637b},
	{0xc4ee, 0x5ff5},
	{0xc4ef, 0x5a18},
	{0xc4f0, 0x917f},
	{0xc4f1, 0x9e1f},
	{0xc4f2, 0x5c3f},
	{0xc4f3, 0x634f},
	{0xc4f4, 0x8042},
	{0xc4f5, 0x5b7d},
	{0xc4f6, 0x556e},
	{0xc4f7, 0x954a},
	{0xc4f8, 0x954d},
	{0xc4f9, 0x6d85},
	{0xc4fa, 0x60a8},
	{0xc4fb, 0x67e0},
	{0xc4fc, 0x72de},
	{0xc4fd, 0x51dd},
	{0xc4fe, 0x5b81},
	{0xc540, 0x81d4},
	{0xc541, 0x81d5},
	{0xc542, 0x81d6},
	{0xc543, 0x81d7},
	{0xc544, 0x81d8},
	{0xc545, 0x81d9},
	{0xc546, 0x81da},
	{0xc547, 0x81db},
	{0xc548, 0x81dc},
	{0xc549, 0x81dd},
	{0xc54a, 0x81de},
	{0xc54b, 0x81df},
	{0xc54c, 0x81e0},
	{0xc54d, 0x81e1},
	{0xc54e, 0x81e2},
	{0xc54f, 0x81e4},
	{0xc550, 0x81e5},
	{0xc551, 0x81e6},
	{0xc552, 0x81e8},
	{0xc553, 0x81e9},
	{0xc554, 0x81eb},
	{0xc555, 0x81ee},
	{0xc556, 0x81ef},
	{0xc557, 0x81f0},
	{0xc558, 0x81f1},
	{0xc559, 0x81f2},
	{0xc55a, 0x81f5},
	{0xc55b, 0x81f6},
	{0xc55c, 0x81f7},
	{0xc55d, 0x81f8},
	{0xc55e, 0x81f9},
	{0xc55f, 0x81fa},
	{0xc560, 0x81fd},
	{0xc561, 0x81ff},
	{0xc562, 0x8203},
	{0xc563, 0x8207},
	{0xc564, 0x8208},
	{0xc565, 0x8209},
	{0xc566, 0x820a},
	{0xc567, 0x820b},
	{0xc568, 0x820e},
	{0xc569, 0x820f},
	{0xc56a, 0x8211},
	{0xc56b, 0x8213},
	{0xc56c, 0x8215},
	{0xc56d, 0x8216},
	{0xc56e, 0x8217},
	{0xc56f, 0x8218},
	{0xc570, 0x8219},
	{0xc571, 0x821a},
	{0xc572, 0x821d},
	{0xc573, 0x8220},
	{0xc574, 0x8224},
	{0xc575, 0x8225},
	{0xc576, 0x8226},
	{0xc577, 0x8227},
	{0xc578, 0x8229},
	{0xc579, 0x822e},
	{0xc57a, 0x8232},
	{0xc57b, 0x823a},
	{0xc57c, 0x823c},
	{0xc57d, 0x823d},
	{0xc57e, 0x823f},
	{0xc580, 0x8240},
	{0xc581, 0x8241},
	{0xc582, 0x8242},
	{0xc583, 0x8243},
	{0xc584, 0x8245},
	{0xc585, 0x8246},
	{0xc586, 0x8248},
	{0xc587, 0x824a},
	{0xc588, 0x824c},
	{0xc589, 0x824d},
	{0xc58a, 0x824e},
	{0xc58b, 0x8250},
	{0xc58c, 0x8251},
	{0xc58d, 0x8252},
	{0xc58e, 0x8253},
	{0xc58f, 0x8254},
	{0xc590, 0x8255},
	{0xc591, 0x8256},
	{0xc592, 0x8257},
	{0xc593, 0x8259},
	{0xc594, 0x825b},
	{0xc595, 0x825c},
	{0xc596, 0x825d},
	{0xc597, 0x825e},
	{0xc598, 0x8260},
	{0xc599, 0x8261},
	{0xc59a, 0x8262},
	{0xc59b, 0x8263},
	{0xc59c, 0x8264},
	{0xc59d, 0x8265},
	{0xc59e, 0x8266},
	{0xc59f, 0x8267},
	{0xc5a0, 0x8269},
	{0xc5a1, 0x62e7},
	{0xc5a2, 0x6cde},
	{0xc5a3, 0x725b},
	{0xc5a4, 0x626d},
	{0xc5a5, 0x94ae},
	{0xc5a6, 0x7ebd},
	{0xc5a7, 0x8113},
	{0xc5a8, 0x6d53},
	{0xc5a9, 0x519c},
	{0xc5aa, 0x5f04},
	{0xc5ab, 0x5974},
	{0xc5ac, 0x52aa},
	{0xc5ad, 0x6012},
	{0xc5ae, 0x5973},
	{0xc5af, 0x6696},
	{0xc5b0, 0x8650},
	{0xc5b1, 0x759f},
	{0xc5b2, 0x632a},
	{0xc5b3, 0x61e6},
	{0xc5b4, 0x7cef},
	{0xc5b5, 0x8bfa},
	{0xc5b6, 0x54e6},
	{0xc5b7, 0x6b27},
	{0xc5b8, 0x9e25},
	{0xc5b9, 0x6bb4},
	{0xc5ba, 0x85d5},
	{0xc5bb, 0x5455},
	{0xc5bc, 0x5076},
	{0xc5bd, 0x6ca4},
	{0xc5be, 0x556a},
	{0xc5bf, 0x8db4},
	{0xc5c0, 0x722c},
	{0xc5c1, 0x5e15},
	{0xc5c2, 0x6015},
	{0xc5c3, 0x7436},
	{0xc5c4, 0x62cd},
	{0xc5c5, 0x6392},
	{0xc5c6, 0x724c},
	{0xc5c7, 0x5f98},
	{0xc5c8, 0x6e43},
	{0xc5c9, 0x6d3e},
	{0xc5ca, 0x6500},
	{0xc5cb, 0x6f58},
	{0xc5cc, 0x76d8},
	{0xc5cd, 0x78d0},
	{0xc5ce, 0x76fc},
	{0xc5cf, 0x7554},
	{0xc5d0, 0x5224},
	{0xc5d1, 0x53db},
	{0xc5d2, 0x4e53},
	{0xc5d3, 0x5e9e},
	{0xc5d4, 0x65c1},
	{0xc5d5, 0x802a},
	{0xc5d6, 0x80d6},
	{0xc5d7, 0x629b},
	{0xc5d8, 0x5486},
	{0xc5d9, 0x5228},
	{0xc5da, 0x70ae},
	{0xc5db, 0x888d},
	{0xc5dc, 0x8dd1},
	{0xc5dd, 0x6ce1},
	{0xc5de, 0x5478},
	{0xc5df, 0x80da},
	{0xc5e0, 0x57f9},
	{0xc5e1, 0x88f4},
	{0xc5e2, 0x8d54},
	{0xc5e3, 0x966a},
	{0xc5e4, 0x914d},
	{0xc5e5, 0x4f69},
	{0xc5e6, 0x6c9b},
	{0xc5e7, 0x55b7},
	{0xc5e8, 0x76c6},
	{0xc5e9, 0x7830},
	{0xc5ea, 0x62a8},
	{0xc5eb, 0x70f9},
	{0xc5ec, 0x6f8e},
	{0xc5ed, 0x5f6d},
	{0xc5ee, 0x84ec},
	{0xc5ef, 0x68da},
	{0xc5f0, 0x787c},
	{0xc5f1, 0x7bf7},
	{0xc5f2, 0x81a8},
	{0xc5f3, 0x670b},
	{0xc5f4, 0x9e4f},
	{0xc5f5, 0x6367},
	{0xc5f6, 0x78b0},
	{0xc5f7, 0x576f},
	{0xc5f8, 0x7812},
	{0xc5f9, 0x9739},
	{0xc5fa, 0x6279},
	{0xc5fb, 0x62ab},
	{0xc5fc, 0x5288},
	{0xc5fd, 0x7435},
	{0xc5fe, 0x6bd7},
	{0xc640, 0x826a},
	{0xc641, 0x826b},
	{0xc642, 0x826c},
	{0xc643, 0x826d},
	{0xc644, 0x8271},
	{0xc645, 0x8275},
	{0xc646, 0x8276},
	{0xc647, 0x8277},
	{0xc648, 0x8278},
	{0xc649, 0x827b},
	{0xc64a, 0x827c},
	{0xc64b, 0x8280},
	{0xc64c, 0x8281},
	{0xc64d, 0x8283},
	{0xc64e, 0x8285},
	{0xc64f, 0x8286},
	{0xc650, 0x8287},
	{0xc651, 0x8289},
	{0xc652, 0x828c},
	{0xc653, 0x8290},
	{0xc654, 0x8293},
	{0xc655, 0x8294},
	{0xc656, 0x8295},
	{0xc657, 0x8296},
	{0xc658, 0x829a},
	{0xc659, 0x829b},
	{0xc65a, 0x829e},
	{0xc65b, 0x82a0},
	{0xc65c, 0x82a2},
	{0xc65d, 0x82a3},
	{0xc65e, 0x82a7},
	{0xc65f, 0x82b2},
	{0xc660, 0x82b5},
	{0xc661, 0x82b6},
	{0xc662, 0x82ba},
	{0xc663, 0x82bb},
	{0xc664, 0x82bc},
	{0xc665, 0x82bf},
	{0xc666, 0x82c0},
	{0xc667, 0x82c2},
	{0xc668, 0x82c3},
	{0xc669, 0x82c5},
	{0xc66a, 0x82c6},
	{0xc66b, 0x82c9},
	{0xc66c, 0x82d0},
	{0xc66d, 0x82d6},
	{0xc66e, 0x82d9},
	{0xc66f, 0x82da},
	{0xc670, 0x82dd},
	{0xc671, 0x82e2},
	{0xc672, 0x82e7},
	{0xc673, 0x82e8},
	{0xc674, 0x82e9},
	{0xc675, 0x82ea},
	{0xc676, 0x82ec},
	{0xc677, 0x82ed},
	{0xc678, 0x82ee},
	{0xc679, 0x82f0},
	{0xc67a, 0x82f2},
	{0xc67b, 0x82f3},
	{0xc67c, 0x82f5},
	{0xc67d, 0x82f6},
	{0xc67e, 0x82f8},
	{0xc680, 0x82fa},
	{0xc681, 0x82fc},
	{0xc682, 0x82fd},
	{0xc683, 0x82fe},
	{0xc684, 0x82ff},
	{0xc685, 0x8300},
	{0xc686, 0x830a},
	{0xc687, 0x830b},
	{0xc688, 0x830d},
	{0xc689, 0x8310},
	{0xc68a, 0x8312},
	{0xc68b, 0x8313},
	{0xc68c, 0x8316},
	{0xc68d, 0x8318},
	{0xc68e, 0x8319},
	{0xc68f, 0x831d},
	{0xc690, 0x831e},
	{0xc691, 0x831f},
	{0xc692, 0x8320},
	{0xc693, 0x8321},
	{0xc694, 0x8322},
	{0xc695, 0x8323},
	{0xc696, 0x8324},
	{0xc697, 0x8325},
	{0xc698, 0x8326},
	{0xc699, 0x8329},
	{0xc69a, 0x832a},
	{0xc69b, 0x832e},
	{0xc69c, 0x8330},
	{0xc69d, 0x8332},
	{0xc69e, 0x8337},
	{0xc69f, 0x833b},
	{0xc6a0, 0x833d},
	{0xc6a1, 0x5564},
	{0xc6a2, 0x813e},
	{0xc6a3, 0x75b2},
	{0xc6a4, 0x76ae},
	{0xc6a5, 0x5339},
	{0xc6a6, 0x75de},
	{0xc6a7, 0x50fb},
	{0xc6a8, 0x5c41},
	{0xc6a9, 0x8b6c},
	{0xc6aa, 0x7bc7},
	{0xc6ab, 0x504f},
	{0xc6ac, 0x7247},
	{0xc6ad, 0x9a97},
	{0xc6ae, 0x98d8},
	{0xc6af, 0x6f02},
	{0xc6b0, 0x74e2},
	{0xc6b1, 0x7968},
	{0xc6b2, 0x6487},
	{0xc6b3, 0x77a5},
	{0xc6b4, 0x62fc},
	{0xc6b5, 0x9891},
	{0xc6b6, 0x8d2b},
	{0xc6b7, 0x54c1},
	{0xc6b8, 0x8058},
	{0xc6b9, 0x4e52},
	{0xc6ba, 0x576a},
	{0xc6bb, 0x82f9},
	{0xc6bc, 0x840d},
	{0xc6bd, 0x5e73},
	{0xc6be, 0x51ed},
	{0xc6bf, 0x74f6},
	{0xc6c0, 0x8bc4},
	{0xc6c1, 0x5c4f},
	{0xc6c2, 0x5761},
	{0xc6c3, 0x6cfc},
	{0xc6c4, 0x9887},
	{0xc6c5, 0x5a46},
	{0xc6c6, 0x7834},
	{0xc6c7, 0x9b44},
	{0xc6c8, 0x8feb},
	{0xc6c9, 0x7c95},
	{0xc6ca, 0x5256},
	{0xc6cb, 0x6251},
	{0xc6cc, 0x94fa},
	{0xc6cd, 0x4ec6},
	{0xc6ce, 0x8386},
	{0xc6cf, 0x8461},
	{0xc6d0, 0x83e9},
	{0xc6d1, 0x84b2},
	{0xc6d2, 0x57d4},
	{0xc6d3, 0x6734},
	{0xc6d4, 0x5703},
	{0xc6d5, 0x666e},
	{0xc6d6, 0x6d66},
	{0xc6d7, 0x8c31},
	{0xc6d8, 0x66dd},
	{0xc6d9, 0x7011},
	{0xc6da, 0x671f},
	{0xc6db, 0x6b3a},
	{0xc6dc, 0x6816},
	{0xc6dd, 0x621a},
	{0xc6de, 0x59bb},
	{0xc6df, 0x4e03},
	{0xc6e0, 0x51c4},
	{0xc6e1, 0x6f06},
	{0xc6e2, 0x67d2},
	{0xc6e3, 0x6c8f},
	{0xc6e4, 0x5176},
	{0xc6e5, 0x68cb},
	{0xc6e6, 0x5947},
	{0xc6e7, 0x6b67},
	{0xc6e8, 0x7566},
	{0xc6e9, 0x5d0e},
	{0xc6ea, 0x8110},
	{0xc6eb, 0x9f50},
	{0xc6ec, 0x65d7},
	{0xc6ed, 0x7948},
	{0xc6ee, 0x7941},
	{0xc6ef, 0x9a91},
	{0xc6f0, 0x8d77},
	{0xc6f1, 0x5c82},
	{0xc6f2, 0x4e5e},
	{0xc6f3, 0x4f01},
	{0xc6f4, 0x542f},
	{0xc6f5, 0x5951},
	{0xc6f6, 0x780c},
	{0xc6f7, 0x5668},
	{0xc6f8, 0x6c14},
	{0xc6f9, 0x8fc4},
	{0xc6fa, 0x5f03},
	{0xc6fb, 0x6c7d},
	{0xc6fc, 0x6ce3},
	{0xc6fd, 0x8bab},
	{0xc6fe, 0x6390},
	{0xc740, 0x833e},
	{0xc741, 0x833f},
	{0xc742, 0x8341},
	{0xc743, 0x8342},
	{0xc744, 0x8344},
	{0xc745, 0x8345},
	{0xc746, 0x8348},
	{0xc747, 0x834a},
	{0xc748, 0x834b},
	{0xc749, 0x834c},
	{0xc74a, 0x834d},
	{0xc74b, 0x834e},
	{0xc74c, 0x8353},
	{0xc74d, 0x8355},
	{0xc74e, 0x8356},
	{0xc74f, 0x8357},
	{0xc750, 0x8358},
	{0xc751, 0x8359},
	{0xc752, 0x835d},
	{0xc753, 0x8362},
	{0xc754, 0x8370},
	{0xc755, 0x8371},
	{0xc756, 0x8372},
	{0xc757, 0x8373},
	{0xc758, 0x8374},
	{0xc759, 0x8375},
	{0xc75a, 0x8376},
	{0xc75b, 0x8379},
	{0xc75c, 0x837a},
	{0xc75d, 0x837e},
	{0xc75e, 0x837f},
	{0xc75f, 0x8380},
	{0xc760, 0x8381},
	{0xc761, 0x8382},
	{0xc762, 0x8383},
	{0xc763, 0x8384},
	{0xc764, 0x8387},
	{0xc765, 0x8388},
	{0xc766, 0x838a},
	{0xc767, 0x838b},
	{0xc768, 0x838c},
	{0xc769, 0x838d},
	{0xc76a, 0x838f},
	{0xc76b, 0x8390},
	{0xc76c, 0x8391},
	{0xc76d, 0x8394},
	{0xc76e, 0x8395},
	{0xc76f, 0x8396},
	{0xc770, 0x8397},
	{0xc771, 0x8399},
	{0xc772, 0x839a},
	{0xc773, 0x839d},
	{0xc774, 0x839f},
	{0xc775, 0x83a1},
	{0xc776, 0x83a2},
	{0xc777, 0x83a3},
	{0xc778, 0x83a4},
	{0xc779, 0x83a5},
	{0xc77a, 0x83a6},
	{0xc77b, 0x83a7},
	{0xc77c, 0x83ac},
	{0xc77d, 0x83ad},
	{0xc77e, 0x83ae},
	{0xc780, 0x83af},
	{0xc781, 0x83b5},
	{0xc782, 0x83bb},
	{0xc783, 0x83be},
	{0xc784, 0x83bf},
	{0xc785, 0x83c2},
	{0xc786, 0x83c3},
	{0xc787, 0x83c4},
	{0xc788, 0x83c6},
	{0xc789, 0x83c8},
	{0xc78a, 0x83c9},
	{0xc78b, 0x83cb},
	{0xc78c, 0x83cd},
	{0xc78d, 0x83ce},
	{0xc78e, 0x83d0},
	{0xc78f, 0x83d1},
	{0xc790, 0x83d2},
	{0xc791, 0x83d3},
	{0xc792, 0x83d5},
	{0xc793, 0x83d7},
	{0xc794, 0x83d9},
	{0xc795, 0x83da},
	{0xc796, 0x83db},
	{0xc797, 0x83de},
	{0xc798, 0x83e2},
	{0xc799, 0x83e3},
	{0xc79a, 0x83e4},
	{0xc79b, 0x83e6},
	{0xc79c, 0x83e7},
	{0xc79d, 0x83e8},
	{0xc79e, 0x83eb},
	{0xc79f, 0x83ec},
	{0xc7a0, 0x83ed},
	{0xc7a1, 0x6070},
	{0xc7a2, 0x6d3d},
	{0xc7a3, 0x7275},
	{0xc7a4, 0x6266},
	{0xc7a5, 0x948e},
	{0xc7a6, 0x94c5},
	{0xc7a7, 0x5343},
	{0xc7a8, 0x8fc1},
	{0xc7a9, 0x7b7e},
	{0xc7aa, 0x4edf},
	{0xc7ab, 0x8c26},
	{0xc7ac, 0x4e7e},
	{0xc7ad, 0x9ed4},
	{0xc7ae, 0x94b1},
	{0xc7af, 0x94b3},
	{0xc7b0, 0x524d},
	{0xc7b1, 0x6f5c},
	{0xc7b2, 0x9063},
	{0xc7b3, 0x6d45},
	{0xc7b4, 0x8c34},
	{0xc7b5, 0x5811},
	{0xc7b6, 0x5d4c},
	{0xc7b7, 0x6b20},
	{0xc7b8, 0x6b49},
	{0xc7b9, 0x67aa},
	{0xc7ba, 0x545b},
	{0xc7bb, 0x8154},
	{0xc7bc, 0x7f8c},
	{0xc7bd, 0x5899},
	{0xc7be, 0x8537},
	{0xc7bf, 0x5f3a},
	{0xc7c0, 0x62a2},
	{0xc7c1, 0x6a47},
	{0xc7c2, 0x9539},
	{0xc7c3, 0x6572},
	{0xc7c4, 0x6084},
	{0xc7c5, 0x6865},
	{0xc7c6, 0x77a7},
	{0xc7c7, 0x4e54},
	{0xc7c8, 0x4fa8},
	{0xc7c9, 0x5de7},
	{0xc7ca, 0x9798},
	{0xc7cb, 0x64ac},
	{0xc7cc, 0x7fd8},
	{0xc7cd, 0x5ced},
	{0xc7ce, 0x4fcf},
	{0xc7cf, 0x7a8d},
	{0xc7d0, 0x5207},
	{0xc7d1, 0x8304},
	{0xc7d2, 0x4e14},
	{0xc7d3, 0x602f},
	{0xc7d4, 0x7a83},
	{0xc7d5, 0x94a6},
	{0xc7d6, 0x4fb5},
	{0xc7d7, 0x4eb2},
	{0xc7d8, 0x79e6},
	{0xc7d9, 0x7434},
	{0xc7da, 0x52e4},
	{0xc7db, 0x82b9},
	{0xc7dc, 0x64d2},
	{0xc7dd, 0x79bd},
	{0xc7de, 0x5bdd},
	{0xc7df, 0x6c81},
	{0xc7e0, 0x9752},
	{0xc7e1, 0x8f7b},
	{0xc7e2, 0x6c22},
	{0xc7e3, 0x503e},
	{0xc7e4, 0x537f},
	{0xc7e5, 0x6e05},
	{0xc7e6, 0x64ce},
	{0xc7e7, 0x6674},
	{0xc7e8, 0x6c30},
	{0xc7e9, 0x60c5},
	{0xc7ea, 0x9877},
	{0xc7eb, 0x8bf7},
	{0xc7ec, 0x5e86},
	{0xc7ed, 0x743c},
	{0xc7ee, 0x7a77},
	{0xc7ef, 0x79cb},
	{0xc7f0, 0x4e18},
	{0xc7f1, 0x90b1},
	{0xc7f2, 0x7403},
	{0xc7f3, 0x6c42},
	{0xc7f4, 0x56da},
	{0xc7f5, 0x914b},
	{0xc7f6, 0x6cc5},
	{0xc7f7, 0x8d8b},
	{0xc7f8, 0x533a},
	{0xc7f9, 0x86c6},
	{0xc7fa, 0x66f2},
	{0xc7fb, 0x8eaf},
	{0xc7fc, 0x5c48},
	{0xc7fd, 0x9a71},
	{0xc7fe, 0x6e20},
	{0xc840, 0x83ee},
	{0xc841, 0x83ef},
	{0xc842, 0x83f3},
	{0xc843, 0x83f4},
	{0xc844, 0x83f5},
	{0xc845, 0x83f6},
	{0xc846, 0x83f7},
	{0xc847, 0x83fa},
	{0xc848, 0x83fb},
	{0xc849, 0x83fc},
	{0xc84a, 0x83fe},
	{0xc84b, 0x83ff},
	{0xc84c, 0x8400},
	{0xc84d, 0x8402},
	{0xc84e, 0x8405},
	{0xc84f, 0x8407},
	{0xc850, 0x8408},
	{0xc851, 0x8409},
	{0xc852, 0x840a},
	{0xc853, 0x8410},
	{0xc854, 0x8412},
	{0xc855, 0x8413},
	{0xc856, 0x8414},
	{0xc857, 0x8415},
	{0xc858, 0x8416},
	{0xc859, 0x8417},
	{0xc85a, 0x8419},
	{0xc85b, 0x841a},
	{0xc85c, 0x841b},
	{0xc85d, 0x841e},
	{0xc85e, 0x841f},
	{0xc85f, 0x8420},
	{0xc860, 0x8421},
	{0xc861, 0x8422},
	{0xc862, 0x8423},
	{0xc863, 0x8429},
	{0xc864, 0x842a},
	{0xc865, 0x842b},
	{0xc866, 0x842c},
	{0xc867, 0x842d},
	{0xc868, 0x842e},
	{0xc869, 0x842f},
	{0xc86a, 0x8430},
	{0xc86b, 0x8432},
	{0xc86c, 0x8433},
	{0xc86d, 0x8434},
	{0xc86e, 0x8435},
	{0xc86f, 0x8436},
	{0xc870, 0x8437},
	{0xc871, 0x8439},
	{0xc872, 0x843a},
	{0xc873, 0x843b},
	{0xc874, 0x843e},
	{0xc875, 0x843f},
	{0xc876, 0x8440},
	{0xc877, 0x8441},
	{0xc878, 0x8442},
	{0xc879, 0x8443},
	{0xc87a, 0x8444},
	{0xc87b, 0x8445},
	{0xc87c, 0x8447},
	{0xc87d, 0x8448},
	{0xc87e, 0x8449},
	{0xc880, 0x844a},
	{0xc881, 0x844b},
	{0xc882, 0x844c},
	{0xc883, 0x844d},
	{0xc884, 0x844e},
	{0xc885, 0x844f},
	{0xc886, 0x8450},
	{0xc887, 0x8452},
	{0xc888, 0x8453},
	{0xc889, 0x8454},
	{0xc88a, 0x8455},
	{0xc88b, 0x8456},
	{0xc88c, 0x8458},
	{0xc88d, 0x845d},
	{0xc88e, 0x845e},
	{0xc88f, 0x845f},
	{0xc890, 0x8460},
	{0xc891, 0x8462},
	{0xc892, 0x8464},
	{0xc893, 0x8465},
	{0xc894, 0x8466},
	{0xc895, 0x8467},
	{0xc896, 0x8468},
	{0xc897, 0x846a},
	{0xc898, 0x846e},
	{0xc899, 0x846f},
	{0xc89a, 0x8470},
	{0xc89b, 0x8472},
	{0xc89c, 0x8474},
	{0xc89d, 0x8477},
	{0xc89e, 0x8479},
	{0xc89f, 0x847b},
	{0xc8a0, 0x847c},
	{0xc8a1, 0x53d6},
	{0xc8a2, 0x5a36},
	{0xc8a3, 0x9f8b},
	{0xc8a4, 0x8da3},
	{0xc8a5, 0x53bb},
	{0xc8a6, 0x5708},
	{0xc8a7, 0x98a7},
	{0xc8a8, 0x6743},
	{0xc8a9, 0x919b},
	{0xc8aa, 0x6cc9},
	{0xc8ab, 0x5168},
	{0xc8ac, 0x75ca},
	{0xc8ad, 0x62f3},
	{0xc8ae, 0x72ac},
	{0xc8af, 0x5238},
	{0xc8b0, 0x529d},
	{0xc8b1, 0x7f3a},
	{0xc8b2, 0x7094},
	{0xc8b3, 0x7638},
	{0xc8b4, 0x5374},
	{0xc8b5, 0x9e4a},
	{0xc8b6, 0x69b7},
	{0xc8b7, 0x786e},
	{0xc8b8, 0x96c0},
	{0xc8b9, 0x88d9},
	{0xc8ba, 0x7fa4},
	{0xc8bb, 0x7136},
	{0xc8bc, 0x71c3},
	{0xc8bd, 0x5189},
	{0xc8be, 0x67d3},
	{0xc8bf, 0x74e4},
	{0xc8c0, 0x58e4},
	{0xc8c1, 0x6518},
	{0xc8c2, 0x56b7},
	{0xc8c3, 0x8ba9},
	{0xc8c4, 0x9976},
	{0xc8c5, 0x6270},
	{0xc8c6, 0x7ed5},
	{0xc8c7, 0x60f9},
	{0xc8c8, 0x70ed},
	{0xc8c9, 0x58ec},
	{0xc8ca, 0x4ec1},
	{0xc8cb, 0x4eba},
	{0xc8cc, 0x5fcd},
	{0xc8cd, 0x97e7},
	{0xc8ce, 0x4efb},
	{0xc8cf, 0x8ba4},
	{0xc8d0, 0x5203},
	{0xc8d1, 0x598a},
	{0xc8d2, 0x7eab},
	{0xc8d3, 0x6254},
	{0xc8d4, 0x4ecd},
	{0xc8d5, 0x65e5},
	{0xc8d6, 0x620e},
	{0xc8d7, 0x8338},
	{0xc8d8, 0x84c9},
	{0xc8d9, 0x8363},
	{0xc8da, 0x878d},
	{0xc8db, 0x7194},
	{0xc8dc, 0x6eb6},
	{0xc8dd, 0x5bb9},
	{0xc8de, 0x7ed2},
	{0xc8df, 0x5197},
	{0xc8e0, 0x63c9},
	{0xc8e1, 0x67d4},
	{0xc8e2, 0x8089},
	{0xc8e3, 0x8339},
	{0xc8e4, 0x8815},
	{0xc8e5, 0x5112},
	{0xc8e6, 0x5b7a},
	{0xc8e7, 0x5982},
	{0xc8e8, 0x8fb1},
	{0xc8e9, 0x4e73},
	{0xc8ea, 0x6c5d},
	{0xc8eb, 0x5165},
	{0xc8ec, 0x8925},
	{0xc8ed, 0x8f6f},
	{0xc8ee, 0x962e},
	{0xc8ef, 0x854a},
	{0xc8f0, 0x745e},
	{0xc8f1, 0x9510},
	{0xc8f2, 0x95f0},
	{0xc8f3, 0x6da6},
	{0xc8f4, 0x82e5},
	{0xc8f5, 0x5f31},
	{0xc8f6, 0x6492},
	{0xc8f7, 0x6d12},
	{0xc8f8, 0x8428},
	{0xc8f9, 0x816e},
	{0xc8fa, 0x9cc3},
	{0xc8fb, 0x585e},
	{0xc8fc, 0x8d5b},
	{0xc8fd, 0x4e09},
	{0xc8fe, 0x53c1},
	{0xc940, 0x847d},
	{0xc941, 0x847e},
	{0xc942, 0x847f},
	{0xc943, 0x8480},
	{0xc944, 0x8481},
	{0xc945, 0x8483},
	{0xc946, 0x8484},
	{0xc947, 0x8485},
	{0xc948, 0x8486},
	{0xc949, 0x848a},
	{0xc94a, 0x848d},
	{0xc94b, 0x848f},
	{0xc94c, 0x8490},
	{0xc94d, 0x8491},
	{0xc94e, 0x8492},
	{0xc94f, 0x8493},
	{0xc950, 0x8494},
	{0xc951, 0x8495},
	{0xc952, 0x8496},
	{0xc953, 0x8498},
	{0xc954, 0x849a},
	{0xc955, 0x849b},
	{0xc956, 0x849d},
	{0xc957, 0x849e},
	{0xc958, 0x849f},
	{0xc959, 0x84a0},
	{0xc95a, 0x84a2},
	{0xc95b, 0x84a3},
	{0xc95c, 0x84a4},
	{0xc95d, 0x84a5},
	{0xc95e, 0x84a6},
	{0xc95f, 0x84a7},
	{0xc960, 0x84a8},
	{0xc961, 0x84a9},
	{0xc962, 0x84aa},
	{0xc963, 0x84ab},
	{0xc964, 0x84ac},
	{0xc965, 0x84ad},
	{0xc966, 0x84ae},
	{0xc967, 0x84b0},
	{0xc968, 0x84b1},
	{0xc969, 0x84b3},
	{0xc96a, 0x84b5},
	{0xc96b, 0x84b6},
	{0xc96c, 0x84b7},
	{0xc96d, 0x84bb},
	{0xc96e, 0x84bc},
	{0xc96f, 0x84be},
	{0xc970, 0x84c0},
	{0xc971, 0x84c2},
	{0xc972, 0x84c3},
	{0xc973, 0x84c5},
	{0xc974, 0x84c6},
	{0xc975, 0x84c7},
	{0xc976, 0x84c8},
	{0xc977, 0x84cb},
	{0xc978, 0x84cc},
	{0xc979, 0x84ce},
	{0xc97a, 0x84cf},
	{0xc97b, 0x84d2},
	{0xc97c, 0x84d4},
	{0xc97d, 0x84d5},
	{0xc97e, 0x84d7},
	{0xc980, 0x84d8},
	{0xc981, 0x84d9},
	{0xc982, 0x84da},
	{0xc983, 0x84db},
	{0xc984, 0x84dc},
	{0xc985, 0x84de},
	{0xc986, 0x84e1},
	{0xc987, 0x84e2},
	{0xc988, 0x84e4},
	{0xc989, 0x84e7},
	{0xc98a, 0x84e8},
	{0xc98b, 0x84e9},
	{0xc98c, 0x84ea},
	{0xc98d, 0x84eb},
	{0xc98e, 0x84ed},
	{0xc98f, 0x84ee},
	{0xc990, 0x84ef},
	{0xc991, 0x84f1},
	{0xc992, 0x84f2},
	{0xc993, 0x84f3},
	{0xc994, 0x84f4},
	{0xc995, 0x84f5},
	{0xc996, 0x84f6},
	{0xc997, 0x84f7},
	{0xc998, 0x84f8},
	{0xc999, 0x84f9},
	{0xc99a, 0x84fa},
	{0xc99b, 0x84fb},
	{0xc99c, 0x84fd},
	{0xc99d, 0x84fe},
	{0xc99e, 0x8500},
	{0xc99f, 0x8501},
	{0xc9a0, 0x8502},
	{0xc9a1, 0x4f1e},
	{0xc9a2, 0x6563},
	{0xc9a3, 0x6851},
	{0xc9a4, 0x55d3},
	{0xc9a5, 0x4e27},
	{0xc9a6, 0x6414},
	{0xc9a7, 0x9a9a},
	{0xc9a8, 0x626b},
	{0xc9a9, 0x5ac2},
	{0xc9aa, 0x745f},
	{0xc9ab, 0x8272},
	{0xc9ac, 0x6da9},
	{0xc9ad, 0x68ee},
	{0xc9ae, 0x50e7},
	{0xc9af, 0x838e},
	{0xc9b0, 0x7802},
	{0xc9b1, 0x6740},
	{0xc9b2, 0x5239},
	{0xc9b3, 0x6c99},
	{0xc9b4, 0x7eb1},
	{0xc9b5, 0x50bb},
	{0xc9b6, 0x5565},
	{0xc9b7, 0x715e},
	{0xc9b8, 0x7b5b},
	{0xc9b9, 0x6652},
	{0xc9ba, 0x73ca},
	{0xc9bb, 0x82eb},
	{0xc9bc, 0x6749},
	{0xc9bd, 0x5c71},
	{0xc9be, 0x5220},
	{0xc9bf, 0x717d},
	{0xc9c0, 0x886b},
	{0xc9c1, 0x95ea},
	{0xc9c2, 0x9655},
	{0xc9c3, 0x64c5},
	{0xc9c4, 0x8d61},
	{0xc9c5, 0x81b3},
	{0xc9c6, 0x5584},
	{0xc9c7, 0x6c55},
	{0xc9c8, 0x6247},
	{0xc9c9, 0x7f2e},
	{0xc9ca, 0x5892},
	{0xc9cb, 0x4f24},
	{0xc9cc, 0x5546},
	{0xc9cd, 0x8d4f},
	{0xc9ce, 0x664c},
	{0xc9cf, 0x4e0a},
	{0xc9d0, 0x5c1a},
	{0xc9d1, 0x88f3},
	{0xc9d2, 0x68a2},
	{0xc9d3, 0x634e},
	{0xc9d4, 0x7a0d},
	{0xc9d5, 0x70e7},
	{0xc9d6, 0x828d},
	{0xc9d7, 0x52fa},
	{0xc9d8, 0x97f6},
	{0xc9d9, 0x5c11},
	{0xc9da, 0x54e8},
	{0xc9db, 0x90b5},
	{0xc9dc, 0x7ecd},
	{0xc9dd, 0x5962},
	{0xc9de, 0x8d4a},
	{0xc9df, 0x86c7},
	{0xc9e0, 0x820c},
	{0xc9e1, 0x820d},
	{0xc9e2, 0x8d66},
	{0xc9e3, 0x6444},
	{0xc9e4, 0x5c04},
	{0xc9e5, 0x6151},
	{0xc9e6, 0x6d89},
	{0xc9e7, 0x793e},
	{0xc9e8, 0x8bbe},
	{0xc9e9, 0x7837},
	{0xc9ea, 0x7533},
	{0xc9eb, 0x547b},
	{0xc9ec, 0x4f38},
	{0xc9ed, 0x8eab},
	{0xc9ee, 0x6df1},
	{0xc9ef, 0x5a20},
	{0xc9f0, 0x7ec5},
	{0xc9f1, 0x795e},
	{0xc9f2, 0x6c88},
	{0xc9f3, 0x5ba1},
	{0xc9f4, 0x5a76},
	{0xc9f5, 0x751a},
	{0xc9f6, 0x80be},
	{0xc9f7, 0x614e},
	{0xc9f8, 0x6e17},
	{0xc9f9, 0x58f0},
	{0xc9fa, 0x751f},
	{0xc9fb, 0x7525},
	{0xc9fc, 0x7272},
	{0xc9fd, 0x5347},
	{0xc9fe, 0x7ef3},
	{0xca40, 0x8503},
	{0xca41, 0x8504},
	{0xca42, 0x8505},
	{0xca43, 0x8506},
	{0xca44, 0x8507},
	{0xca45, 0x8508},
	{0xca46, 0x8509},
	{0xca47, 0x850a},
	{0xca48, 0x850b},
	{0xca49, 0x850d},
	{0xca4a, 0x850e},
	{0xca4b, 0x850f},
	{0xca4c, 0x8510},
	{0xca4d, 0x8512},
	{0xca4e, 0x8514},
	{0xca4f, 0x8515},
	{0xca50, 0x8516},
	{0xca51, 0x8518},
	{0xca52, 0x8519},
	{0xca53, 0x851b},
	{0xca54, 0x851c},
	{0xca55, 0x851d},
	{0xca56, 0x851e},
	{0xca57, 0x8520},
	{0xca58, 0x8522},
	{0xca59, 0x8523},
	{0xca5a, 0x8524},
	{0xca5b, 0x8525},
	{0xca5c, 0x8526},
	{0xca5d, 0x8527},
	{0xca5e, 0x8528},
	{0xca5f, 0x8529},
	{0xca60, 0x852a},
	{0xca61, 0x852d},
	{0xca62, 0x852e},
	{0xca63, 0x852f},
	{0xca64, 0x8530},
	{0xca65, 0x8531},
	{0xca66, 0x8532},
	{0xca67, 0x8533},
	{0xca68, 0x8534},
	{0xca69, 0x8535},
	{0xca6a, 0x8536},
	{0xca6b, 0x853e},
	{0xca6c, 0x853f},
	{0xca6d, 0x8540},
	{0xca6e, 0x8541},
	{0xca6f, 0x8542},
	{0xca70, 0x8544},
	{0xca71, 0x8545},
	{0xca72, 0x8546},
	{0xca73, 0x8547},
	{0xca74, 0x854b},
	{0xca75, 0x854c},
	{0xca76, 0x854d},
	{0xca77, 0x854e},
	{0xca78, 0x854f},
	{0xca79, 0x8550},
	{0xca7a, 0x8551},
	{0xca7b, 0x8552},
	{0xca7c, 0x8553},
	{0xca7d, 0x8554},
	{0xca7e, 0x8555},
	{0xca80, 0x8557},
	{0xca81, 0x8558},
	{0xca82, 0x855a},
	{0xca83, 0x855b},
	{0xca84, 0x855c},
	{0xca85, 0x855d},
	{0xca86, 0x855f},
	{0xca87, 0x8560},
	{0xca88, 0x8561},
	{0xca89, 0x8562},
	{0xca8a, 0x8563},
	{0xca8b, 0x8565},
	{0xca8c, 0x8566},
	{0xca8d, 0x8567},
	{0xca8e, 0x8569},
	{0xca8f, 0x856a},
	{0xca90, 0x856b},
	{0xca91, 0x856c},
	{0xca92, 0x856d},
	{0xca93, 0x856e},
	{0xca94, 0x856f},
	{0xca95, 0x8570},
	{0xca96, 0x8571},
	{0xca97, 0x8573},
	{0xca98, 0x8575},
	{0xca99, 0x8576},
	{0xca9a, 0x8577},
	{0xca9b, 0x8578},
	{0xca9c, 0x857c},
	{0xca9d, 0x857d},
	{0xca9e, 0x857f},
	{0xca9f, 0x8580},
	{0xcaa0, 0x8581},
	{0xcaa1, 0x7701},
	{0xcaa2, 0x76db},
	{0xcaa3, 0x5269},
	{0xcaa4, 0x80dc},
	{0xcaa5, 0x5723},
	{0xcaa6, 0x5e08},
	{0xcaa7, 0x5931},
	{0xcaa8, 0x72ee},
	{0xcaa9, 0x65bd},
	{0xcaaa, 0x6e7f},
	{0xcaab, 0x8bd7},
	{0xcaac, 0x5c38},
	{0xcaad, 0x8671},
	{0xcaae, 0x5341},
	{0xcaaf, 0x77f3},
	{0xcab0, 0x62fe},
	{0xcab1, 0x65f6},
	{0xcab2, 0x4ec0},
	{0xcab3, 0x98df},
	{0xcab4, 0x8680},
	{0xcab5, 0x5b9e},
	{0xcab6, 0x8bc6},
	{0xcab7, 0x53f2},
	{0xcab8, 0x77e2},
	{0xcab9, 0x4f7f},
	{0xcaba, 0x5c4e},
	{0xcabb, 0x9a76},
	{0xcabc, 0x59cb},
	{0xcabd, 0x5f0f},
	{0xcabe, 0x793a},
	{0xcabf, 0x58eb},
	{0xcac0, 0x4e16},
	{0xcac1, 0x67ff},
	{0xcac2, 0x4e8b},
	{0xcac3, 0x62ed},
	{0xcac4, 0x8a93},
	{0xcac5, 0x901d},
	{0xcac6, 0x52bf},
	{0xcac7, 0x662f},
	{0xcac8, 0x55dc},
	{0xcac9, 0x566c},
	{0xcaca, 0x9002},
	{0xcacb, 0x4ed5},
	{0xcacc, 0x4f8d},
	{0xcacd, 0x91ca},
	{0xcace, 0x9970},
	{0xcacf, 0x6c0f},
	{0xcad0, 0x5e02},
	{0xcad1, 0x6043},
	{0xcad2, 0x5ba4},
	{0xcad3, 0x89c6},
	{0xcad4, 0x8bd5},
	{0xcad5, 0x6536},
	{0xcad6, 0x624b},
	{0xcad7, 0x9996},
	{0xcad8, 0x5b88},
	{0xcad9, 0x5bff},
	{0xcada, 0x6388},
	{0xcadb, 0x552e},
	{0xcadc, 0x53d7},
	{0xcadd, 0x7626},
	{0xcade, 0x517d},
	{0xcadf, 0x852c},
	{0xcae0, 0x67a2},
	{0xcae1, 0x68b3},
	{0xcae2, 0x6b8a},
	{0xcae3, 0x6292},
	{0xcae4, 0x8f93},
	{0xcae5, 0x53d4},
	{0xcae6, 0x8212},
	{0xcae7, 0x6dd1},
	{0xcae8, 0x758f},
	{0xcae9, 0x4e66},
	{0xcaea, 0x8d4e},
	{0xcaeb, 0x5b70},
	{0xcaec, 0x719f},
	{0xcaed, 0x85af},
	{0xcaee, 0x6691},
	{0xcaef, 0x66d9},
	{0xcaf0, 0x7f72},
	{0xcaf1, 0x8700},
	{0xcaf2, 0x9ecd},
	{0xcaf3, 0x9f20},
	{0xcaf4, 0x5c5e},
	{0xcaf5, 0x672f},
	{0xcaf6, 0x8ff0},
	{0xcaf7, 0x6811},
	{0xcaf8, 0x675f},
	{0xcaf9, 0x620d},
	{0xcafa, 0x7ad6},
	{0xcafb, 0x5885},
	{0xcafc, 0x5eb6},
	{0xcafd, 0x6570},
	{0xcafe, 0x6f31},
	{0xcb40, 0x8582},
	{0xcb41, 0x8583},
	{0xcb42, 0x8586},
	{0xcb43, 0x8588},
	{0xcb44, 0x8589},
	{0xcb45, 0x858a},
	{0xcb46, 0x858b},
	{0xcb47, 0x858c},
	{0xcb48, 0x858d},
	{0xcb49, 0x858e},
	{0xcb4a, 0x8590},
	{0xcb4b, 0x8591},
	{0xcb4c, 0x8592},
	{0xcb4d, 0x8593},
	{0xcb4e, 0x8594},
	{0xcb4f, 0x8595},
	{0xcb50, 0x8596},
	{0xcb51, 0x8597},
	{0xcb52, 0x8598},
	{0xcb53, 0x8599},
	{0xcb54, 0x859a},
	{0xcb55, 0x859d},
	{0xcb56, 0x859e},
	{0xcb57, 0x859f},
	{0xcb58, 0x85a0},
	{0xcb59, 0x85a1},
	{0xcb5a, 0x85a2},
	{0xcb5b, 0x85a3},
	{0xcb5c, 0x85a5},
	{0xcb5d, 0x85a6},
	{0xcb5e, 0x85a7},
	{0xcb5f, 0x85a9},
	{0xcb60, 0x85ab},
	{0xcb61, 0x85ac},
	{0xcb62, 0x85ad},
	{0xcb63, 0x85b1},
	{0xcb64, 0x85b2},
	{0xcb65, 0x85b3},
	{0xcb66, 0x85b4},
	{0xcb67, 0x85b5},
	{0xcb68, 0x85b6},
	{0xcb69, 0x85b8},
	{0xcb6a, 0x85ba},
	{0xcb6b, 0x85bb},
	{0xcb6c, 0x85bc},
	{0xcb6d, 0x85bd},
	{0xcb6e, 0x85be},
	{0xcb6f, 0x85bf},
	{0xcb70, 0x85c0},
	{0xcb71, 0x85c2},
	{0xcb72, 0x85c3},
	{0xcb73, 0x85c4},
	{0xcb74, 0x85c5},
	{0xcb75, 0x85c6},
	{0xcb76, 0x85c7},
	{0xcb77, 0x85c8},
	{0xcb78, 0x85ca},
	{0xcb79, 0x85cb},
	{0xcb7a, 0x85cc},
	{0xcb7b, 0x85cd},
	{0xcb7c, 0x85ce},
	{0xcb7d, 0x85d1},
	{0xcb7e, 0x85d2},
	{0xcb80, 0x85d4},
	{0xcb81, 0x85d6},
	{0xcb82, 0x85d7},
	{0xcb83, 0x85d8},
	{0xcb84, 0x85d9},
	{0xcb85, 0x85da},
	{0xcb86, 0x85db},
	{0xcb87, 0x85dd},
	{0xcb88, 0x85de},
	{0xcb89, 0x85df},
	{0xcb8a, 0x85e0},
	{0xcb8b, 0x85e1},
	{0xcb8c, 0x85e2},
	{0xcb8d, 0x85e3},
	{0xcb8e, 0x85e5},
	{0xcb8f, 0x85e6},
	{0xcb90, 0x85e7},
	{0xcb91, 0x85e8},
	{0xcb92, 0x85ea},
	{0xcb93, 0x85eb},
	{0xcb94, 0x85ec},
	{0xcb95, 0x85ed},
	{0xcb96, 0x85ee},
	{0xcb97, 0x85ef},
	{0xcb98, 0x85f0},
	{0xcb99, 0x85f1},
	{0xcb9a, 0x85f2},
	{0xcb9b, 0x85f3},
	{0xcb9c, 0x85f4},
	{0xcb9d, 0x85f5},
	{0xcb9e, 0x85f6},
	{0xcb9f, 0x85f7},
	{0xcba0, 0x85f8},
	{0xcba1, 0x6055},
	{0xcba2, 0x5237},
	{0xcba3, 0x800d},
	{0xcba4, 0x6454},
	{0xcba5, 0x8870},
	{0xcba6, 0x7529},
	{0xcba7, 0x5e05},
	{0xcba8, 0x6813},
	{0xcba9, 0x62f4},
	{0xcbaa, 0x971c},
	{0xcbab, 0x53cc},
	{0xcbac, 0x723d},
	{0xcbad, 0x8c01},
	{0xcbae, 0x6c34},
	{0xcbaf, 0x7761},
	{0xcbb0, 0x7a0e},
	{0xcbb1, 0x542e},
	{0xcbb2, 0x77ac},
	{0xcbb3, 0x987a},
	{0xcbb4, 0x821c},
	{0xcbb5, 0x8bf4},
	{0xcbb6, 0x7855},
	{0xcbb7, 0x6714},
	{0xcbb8, 0x70c1},
	{0xcbb9, 0x65af},
	{0xcbba, 0x6495},
	{0xcbbb, 0x5636},
	{0xcbbc, 0x601d},
	{0xcbbd, 0x79c1},
	{0xcbbe, 0x53f8},
	{0xcbbf, 0x4e1d},
	{0xcbc0, 0x6b7b},
	{0xcbc1, 0x8086},
	{0xcbc2, 0x5bfa},
	{0xcbc3, 0x55e3},
	{0xcbc4, 0x56db},
	{0xcbc5, 0x4f3a},
	{0xcbc6, 0x4f3c},
	{0xcbc7, 0x9972},
	{0xcbc8, 0x5df3},
	{0xcbc9, 0x677e},
	{0xcbca, 0x8038},
	{0xcbcb, 0x6002},
	{0xcbcc, 0x9882},
	{0xcbcd, 0x9001},
	{0xcbce, 0x5b8b},
	{0xcbcf, 0x8bbc},
	{0xcbd0, 0x8bf5},
	{0xcbd1, 0x641c},
	{0xcbd2, 0x8258},
	{0xcbd3, 0x64de},
	{0xcbd4, 0x55fd},
	{0xcbd5, 0x82cf},
	{0xcbd6, 0x9165},
	{0xcbd7, 0x4fd7},
	{0xcbd8, 0x7d20},
	{0xcbd9, 0x901f},
	{0xcbda, 0x7c9f},
	{0xcbdb, 0x50f3},
	{0xcbdc, 0x5851},
	{0xcbdd, 0x6eaf},
	{0xcbde, 0x5bbf},
	{0xcbdf, 0x8bc9},
	{0xcbe0, 0x8083},
	{0xcbe1, 0x9178},
	{0xcbe2, 0x849c},
	{0xcbe3, 0x7b97},
	{0xcbe4, 0x867d},
	{0xcbe5, 0x968b},
	{0xcbe6, 0x968f},
	{0xcbe7, 0x7ee5},
	{0xcbe8, 0x9ad3},
	{0xcbe9, 0x788e},
	{0xcbea, 0x5c81},
	{0xcbeb, 0x7a57},
	{0xcbec, 0x9042},
	{0xcbed, 0x96a7},
	{0xcbee, 0x795f},
	{0xcbef, 0x5b59},
	{0xcbf0, 0x635f},
	{0xcbf1, 0x7b0b},
	{0xcbf2, 0x84d1},
	{0xcbf3, 0x68ad},
	{0xcbf4, 0x5506},
	{0xcbf5, 0x7f29},
	{0xcbf6, 0x7410},
	{0xcbf7, 0x7d22},
	{0xcbf8, 0x9501},
	{0xcbf9, 0x6240},
	{0xcbfa, 0x584c},
	{0xcbfb, 0x4ed6},
	{0xcbfc, 0x5b83},
	{0xcbfd, 0x5979},
	{0xcbfe, 0x5854},
	{0xcc40, 0x85f9},
	{0xcc41, 0x85fa},
	{0xcc42, 0x85fc},
	{0xcc43, 0x85fd},
	{0xcc44, 0x85fe},
	{0xcc45, 0x8600},
	{0xcc46, 0x8601},
	{0xcc47, 0x8602},
	{0xcc48, 0x8603},
	{0xcc49, 0x8604},
	{0xcc4a, 0x8606},
	{0xcc4b, 0x8607},
	{0xcc4c, 0x8608},
	{0xcc4d, 0x8609},
	{0xcc4e, 0x860a},
	{0xcc4f, 0x860b},
	{0xcc50, 0x860c},
	{0xcc51, 0x860d},
	{0xcc52, 0x860e},
	{0xcc53, 0x860f},
	{0xcc54, 0x8610},
	{0xcc55, 0x8612},
	{0xcc56, 0x8613},
	{0xcc57, 0x8614},
	{0xcc58, 0x8615},
	{0xcc59, 0x8617},
	{0xcc5a, 0x8618},
	{0xcc5b, 0x8619},
	{0xcc5c, 0x861a},
	{0xcc5d, 0x861b},
	{0xcc5e, 0x861c},
	{0xcc5f, 0x861d},
	{0xcc60, 0x861e},
	{0xcc61, 0x861f},
	{0xcc62, 0x8620},
	{0xcc63, 0x8621},
	{0xcc64, 0x8622},
	{0xcc65, 0x8623},
	{0xcc66, 0x8624},
	{0xcc67, 0x8625},
	{0xcc68, 0x8626},
	{0xcc69, 0x8628},
	{0xcc6a, 0x862a},
	{0xcc6b, 0x862b},
	{0xcc6c, 0x862c},
	{0xcc6d, 0x862d},
	{0xcc6e, 0x862e},
	{0xcc6f, 0x862f},
	{0xcc70, 0x8630},
	{0xcc71, 0x8631},
	{0xcc72, 0x8632},
	{0xcc73, 0x8633},
	{0xcc74, 0x8634},
	{0xcc75, 0x8635},
	{0xcc76, 0x8636},
	{0xcc77, 0x8637},
	{0xcc78, 0x8639},
	{0xcc79, 0x863a},
	{0xcc7a, 0x863b},
	{0xcc7b, 0x863d},
	{0xcc7c, 0x863e},
	{0xcc7d, 0x863f},
	{0xcc7e, 0x8640},
	{0xcc80, 0x8641},
	{0xcc81, 0x8642},
	{0xcc82, 0x8643},
	{0xcc83, 0x8644},
	{0xcc84, 0x8645},
	{0xcc85, 0x8646},
	{0xcc86, 0x8647},
	{0xcc87, 0x8648},
	{0xcc88, 0x8649},
	{0xcc89, 0x864a},
	{0xcc8a, 0x864b},
	{0xcc8b, 0x864c},
	{0xcc8c, 0x8652},
	{0xcc8d, 0x8653},
	{0xcc8e, 0x8655},
	{0xcc8f, 0x8656},
	{0xcc90, 0x8657},
	{0xcc91, 0x8658},
	{0xcc92, 0x8659},
	{0xcc93, 0x865b},
	{0xcc94, 0x865c},
	{0xcc95, 0x865d},
	{0xcc96, 0x865f},
	{0xcc97, 0x8660},
	{0xcc98, 0x8661},
	{0xcc99, 0x8663},
	{0xcc9a, 0x8664},
	{0xcc9b, 0x8665},
	{0xcc9c, 0x8666},
	{0xcc9d, 0x8667},
	{0xcc9e, 0x8668},
	{0xcc9f, 0x8669},
	{0xcca0, 0x866a},
	{0xcca1, 0x736d},
	{0xcca2, 0x631e},
	{0xcca3, 0x8e4b},
	{0xcca4, 0x8e0f},
	{0xcca5, 0x80ce},
	{0xcca6, 0x82d4},
	{0xcca7, 0x62ac},
	{0xcca8, 0x53f0},
	{0xcca9, 0x6cf0},
	{0xccaa, 0x915e},
	{0xccab, 0x592a},
	{0xccac, 0x6001},
	{0xccad, 0x6c70},
	{0xccae, 0x574d},
	{0xccaf, 0x644a},
	{0xccb0, 0x8d2a},
	{0xccb1, 0x762b},
	{0xccb2, 0x6ee9},
	{0xccb3, 0x575b},
	{0xccb4, 0x6a80},
	{0xccb5, 0x75f0},
	{0xccb6, 0x6f6d},
	{0xccb7, 0x8c2d},
	{0xccb8, 0x8c08},
	{0xccb9, 0x5766},
	{0xccba, 0x6bef},
	{0xccbb, 0x8892},
	{0xccbc, 0x78b3},
	{0xccbd, 0x63a2},
	{0xccbe, 0x53f9},
	{0xccbf, 0x70ad},
	{0xccc0, 0x6c64},
	{0xccc1, 0x5858},
	{0xccc2, 0x642a},
	{0xccc3, 0x5802},
	{0xccc4, 0x68e0},
	{0xccc5, 0x819b},
	{0xccc6, 0x5510},
	{0xccc7, 0x7cd6},
	{0xccc8, 0x5018},
	{0xccc9, 0x8eba},
	{0xccca, 0x6dcc},
	{0xcccb, 0x8d9f},
	{0xcccc, 0x70eb},
	{0xcccd, 0x638f},
	{0xccce, 0x6d9b},
	{0xcccf, 0x6ed4},
	{0xccd0, 0x7ee6},
	{0xccd1, 0x8404},
	{0xccd2, 0x6843},
	{0xccd3, 0x9003},
	{0xccd4, 0x6dd8},
	{0xccd5, 0x9676},
	{0xccd6, 0x8ba8},
	{0xccd7, 0x5957},
	{0xccd8, 0x7279},
	{0xccd9, 0x85e4},
	{0xccda, 0x817e},
	{0xccdb, 0x75bc},
	{0xccdc, 0x8a8a},
	{0xccdd, 0x68af},
	{0xccde, 0x5254},
	{0xccdf, 0x8e22},
	{0xcce0, 0x9511},
	{0xcce1, 0x63d0},
	{0xcce2, 0x9898},
	{0xcce3, 0x8e44},
	{0xcce4, 0x557c},
	{0xcce5, 0x4f53},
	{0xcce6, 0x66ff},
	{0xcce7, 0x568f},
	{0xcce8, 0x60d5},
	{0xcce9, 0x6d95},
	{0xccea, 0x5243},
	{0xcceb, 0x5c49},
	{0xccec, 0x5929},
	{0xcced, 0x6dfb},
	{0xccee, 0x586b},
	{0xccef, 0x7530},
	{0xccf0, 0x751c},
	{0xccf1, 0x606c},
	{0xccf2, 0x8214},
	{0xccf3, 0x8146},
	{0xccf4, 0x6311},
	{0xccf5, 0x6761},
	{0xccf6, 0x8fe2},
	{0xccf7, 0x773a},
	{0xccf8, 0x8df3},
	{0xccf9, 0x8d34},
	{0xccfa, 0x94c1},
	{0xccfb, 0x5e16},
	{0xccfc, 0x5385},
	{0xccfd, 0x542c},
	{0xccfe, 0x70c3},
	{0xcd40, 0x866d},
	{0xcd41, 0x866f},
	{0xcd42, 0x8670},
	{0xcd43, 0x8672},
	{0xcd44, 0x8673},
	{0xcd45, 0x8674},
	{0xcd46, 0x8675},
	{0xcd47, 0x8676},
	{0xcd48, 0x8677},
	{0xcd49, 0x8678},
	{0xcd4a, 0x8683},
	{0xcd4b, 0x8684},
	{0xcd4c, 0x8685},
	{0xcd4d, 0x8686},
	{0xcd4e, 0x8687},
	{0xcd4f, 0x8688},
	{0xcd50, 0x8689},
	{0xcd51, 0x868e},
	{0xcd52, 0x868f},
	{0xcd53, 0x8690},
	{0xcd54, 0x8691},
	{0xcd55, 0x8692},
	{0xcd56, 0x8694},
	{0xcd57, 0x8696},
	{0xcd58, 0x8697},
	{0xcd59, 0x8698},
	{0xcd5a, 0x8699},
	{0xcd5b, 0x869a},
	{0xcd5c, 0x869b},
	{0xcd5d, 0x869e},
	{0xcd5e, 0x869f},
	{0xcd5f, 0x86a0},
	{0xcd60, 0x86a1},
	{0xcd61, 0x86a2},
	{0xcd62, 0x86a5},
	{0xcd63, 0x86a6},
	{0xcd64, 0x86ab},
	{0xcd65, 0x86ad},
	{0xcd66, 0x86ae},
	{0xcd67, 0x86b2},
	{0xcd68, 0x86b3},
	{0xcd69, 0x86b7},
	{0xcd6a, 0x86b8},
	{0xcd6b, 0x86b9},
	{0xcd6c, 0x86bb},
	{0xcd6d, 0x86bc},
	{0xcd6e, 0x86bd},
	{0xcd6f, 0x86be},
	{0xcd70, 0x86bf},
	{0xcd71, 0x86c1},
	{0xcd72, 0x86c2},
	{0xcd73, 0x86c3},
	{0xcd74, 0x86c5},
	{0xcd75, 0x86c8},
	{0xcd76, 0x86cc},
	{0xcd77, 0x86cd},
	{0xcd78, 0x86d2},
	{0xcd79, 0x86d3},
	{0xcd7a, 0x86d5},
	{0xcd7b, 0x86d6},
	{0xcd7c, 0x86d7},
	{0xcd7d, 0x86da},
	{0xcd7e, 0x86dc},
	{0xcd80, 0x86dd},
	{0xcd81, 0x86e0},
	{0xcd82, 0x86e1},
	{0xcd83, 0x86e2},
	{0xcd84, 0x86e3},
	{0xcd85, 0x86e5},
	{0xcd86, 0x86e6},
	{0xcd87, 0x86e7},
	{0xcd88, 0x86e8},
	{0xcd89, 0x86ea},
	{0xcd8a, 0x86eb},
	{0xcd8b, 0x86ec},
	{0xcd8c, 0x86ef},
	{0xcd8d, 0x86f5},
	{0xcd8e, 0x86f6},
	{0xcd8f, 0x86f7},
	{0xcd90, 0x86fa},
	{0xcd91, 0x86fb},
	{0xcd92, 0x86fc},
	{0xcd93, 0x86fd},
	{0xcd94, 0x86ff},
	{0xcd95, 0x8701},
	{0xcd96, 0x8704},
	{0xcd97, 0x8705},
	{0xcd98, 0x8706},
	{0xcd99, 0x870b},
	{0xcd9a, 0x870c},
	{0xcd9b, 0x870e},
	{0xcd9c, 0x870f},
	{0xcd9d, 0x8710},
	{0xcd9e, 0x8711},
	{0xcd9f, 0x8714},
	{0xcda0, 0x8716},
	{0xcda1, 0x6c40},
	{0xcda2, 0x5ef7},
	{0xcda3, 0x505c},
	{0xcda4, 0x4ead},
	{0xcda5, 0x5ead},
	{0xcda6, 0x633a},
	{0xcda7, 0x8247},
	{0xcda8, 0x901a},
	{0xcda9, 0x6850},
	{0xcdaa, 0x916e},
	{0xcdab, 0x77b3},
	{0xcdac, 0x540c},
	{0xcdad, 0x94dc},
	{0xcdae, 0x5f64},
	{0xcdaf, 0x7ae5},
	{0xcdb0, 0x6876},
	{0xcdb1, 0x6345},
	{0xcdb2, 0x7b52},
	{0xcdb3, 0x7edf},
	{0xcdb4, 0x75db},
	{0xcdb5, 0x5077},
	{0xcdb6, 0x6295},
	{0xcdb7, 0x5934},
	{0xcdb8, 0x900f},
	{0xcdb9, 0x51f8},
	{0xcdba, 0x79c3},
	{0xcdbb, 0x7a81},
	{0xcdbc, 0x56fe},
	{0xcdbd, 0x5f92},
	{0xcdbe, 0x9014},
	{0xcdbf, 0x6d82},
	{0xcdc0, 0x5c60},
	{0xcdc1, 0x571f},
	{0xcdc2, 0x5410},
	{0xcdc3, 0x5154},
	{0xcdc4, 0x6e4d},
	{0xcdc5, 0x56e2},
	{0xcdc6, 0x63a8},
	{0xcdc7, 0x9893},
	{0xcdc8, 0x817f},
	{0xcdc9, 0x8715},
	{0xcdca, 0x892a},
	{0xcdcb, 0x9000},
	{0xcdcc, 0x541e},
	{0xcdcd, 0x5c6f},
	{0xcdce, 0x81c0},
	{0xcdcf, 0x62d6},
	{0xcdd0, 0x6258},
	{0xcdd1, 0x8131},
	{0xcdd2, 0x9e35},
	{0xcdd3, 0x9640},
	{0xcdd4, 0x9a6e},
	{0xcdd5, 0x9a7c},
	{0xcdd6, 0x692d},
	{0xcdd7, 0x59a5},
	{0xcdd8, 0x62d3},
	{0xcdd9, 0x553e},
	{0xcdda, 0x6316},
	{0xcddb, 0x54c7},
	{0xcddc, 0x86d9},
	{0xcddd, 0x6d3c},
	{0xcdde, 0x5a03},
	{0xcddf, 0x74e6},
	{0xcde0, 0x889c},
	{0xcde1, 0x6b6a},
	{0xcde2, 0x5916},
	{0xcde3, 0x8c4c},
	{0xcde4, 0x5f2f},
	{0xcde5, 0x6e7e},
	{0xcde6, 0x73a9},
	{0xcde7, 0x987d},
	{0xcde8, 0x4e38},
	{0xcde9, 0x70f7},
	{0xcdea, 0x5b8c},
	{0xcdeb, 0x7897},
	{0xcdec, 0x633d},
	{0xcded, 0x665a},
	{0xcdee, 0x7696},
	{0xcdef, 0x60cb},
	{0xcdf0, 0x5b9b},
	{0xcdf1, 0x5a49},
	{0xcdf2, 0x4e07},
	{0xcdf3, 0x8155},
	{0xcdf4, 0x6c6a},
	{0xcdf5, 0x738b},
	{0xcdf6, 0x4ea1},
	{0xcdf7, 0x6789},
	{0xcdf8, 0x7f51},
	{0xcdf9, 0x5f80},
	{0xcdfa, 0x65fa},
	{0xcdfb, 0x671b},
	{0xcdfc, 0x5fd8},
	{0xcdfd, 0x5984},
	{0xcdfe, 0x5a01},
	{0xce40, 0x8719},
	{0xce41, 0x871b},
	{0xce42, 0x871d},
	{0xce43, 0x871f},
	{0xce44, 0x8720},
	{0xce45, 0x8724},
	{0xce46, 0x8726},
	{0xce47, 0x8727},
	{0xce48, 0x8728},
	{0xce49, 0x872a},
	{0xce4a, 0x872b},
	{0xce4b, 0x872c},
	{0xce4c, 0x872d},
	{0xce4d, 0x872f},
	{0xce4e, 0x8730},
	{0xce4f, 0x8732},
	{0xce50, 0x8733},
	{0xce51, 0x8735},
	{0xce52, 0x8736},
	{0xce53, 0x8738},
	{0xce54, 0x8739},
	{0xce55, 0x873a},
	{0xce56, 0x873c},
	{0xce57, 0x873d},
	{0xce58, 0x8740},
	{0xce59, 0x8741},
	{0xce5a, 0x8742},
	{0xce5b, 0x8743},
	{0xce5c, 0x8744},
	{0xce5d, 0x8745},
	{0xce5e, 0x8746},
	{0xce5f, 0x874a},
	{0xce60, 0x874b},
	{0xce61, 0x874d},
	{0xce62, 0x874f},
	{0xce63, 0x8750},
	{0xce64, 0x8751},
	{0xce65, 0x8752},
	{0xce66, 0x8754},
	{0xce67, 0x8755},
	{0xce68, 0x8756},
	{0xce69, 0x8758},
	{0xce6a, 0x875a},
	{0xce6b, 0x875b},
	{0xce6c, 0x875c},
	{0xce6d, 0x875d},
	{0xce6e, 0x875e},
	{0xce6f, 0x875f},
	{0xce70, 0x8761},
	{0xce71, 0x8762},
	{0xce72, 0x8766},
	{0xce73, 0x8767},
	{0xce74, 0x8768},
	{0xce75, 0x8769},
	{0xce76, 0x876a},
	{0xce77, 0x876b},
	{0xce78, 0x876c},
	{0xce79, 0x876d},
	{0xce7a, 0x876f},
	{0xce7b, 0x8771},
	{0xce7c, 0x8772},
	{0xce7d, 0x8773},
	{0xce7e, 0x8775},
	{0xce80, 0x8777},
	{0xce81, 0x8778},
	{0xce82, 0x8779},
	{0xce83, 0x877a},
	{0xce84, 0x877f},
	{0xce85, 0x8780},
	{0xce86, 0x8781},
	{0xce87, 0x8784},
	{0xce88, 0x8786},
	{0xce89, 0x8787},
	{0xce8a, 0x8789},
	{0xce8b, 0x878a},
	{0xce8c, 0x878c},
	{0xce8d, 0x878e},
	{0xce8e, 0x878f},
	{0xce8f, 0x8790},
	{0xce90, 0x8791},
	{0xce91, 0x8792},
	{0xce92, 0x8794},
	{0xce93, 0x8795},
	{0xce94, 0x8796},
	{0xce95, 0x8798},
	{0xce96, 0x8799},
	{0xce97, 0x879a},
	{0xce98, 0x879b},
	{0xce99, 0x879c},
	{0xce9a, 0x879d},
	{0xce9b, 0x879e},
	{0xce9c, 0x87a0},
	{0xce9d, 0x87a1},
	{0xce9e, 0x87a2},
	{0xce9f, 0x87a3},
	{0xcea0, 0x87a4},
	{0xcea1, 0x5dcd},
	{0xcea2, 0x5fae},
	{0xcea3, 0x5371},
	{0xcea4, 0x97e6},
	{0xcea5, 0x8fdd},
	{0xcea6, 0x6845},
	{0xcea7, 0x56f4},
	{0xcea8, 0x552f},
	{0xcea9, 0x60df},
	{0xceaa, 0x4e3a},
	{0xceab, 0x6f4d},
	{0xceac, 0x7ef4},
	{0xcead, 0x82c7},
	{0xceae, 0x840e},
	{0xceaf, 0x59d4},
	{0xceb0, 0x4f1f},
	{0xceb1, 0x4f2a},
	{0xceb2, 0x5c3e},
	{0xceb3, 0x7eac},
	{0xceb4, 0x672a},
	{0xceb5, 0x851a},
	{0xceb6, 0x5473},
	{0xceb7, 0x754f},
	{0xceb8, 0x80c3},
	{0xceb9, 0x5582},
	{0xceba, 0x9b4f},
	{0xcebb, 0x4f4d},
	{0xcebc, 0x6e2d},
	{0xcebd, 0x8c13},
	{0xcebe, 0x5c09},
	{0xcebf, 0x6170},
	{0xcec0, 0x536b},
	{0xcec1, 0x761f},
	{0xcec2, 0x6e29},
	{0xcec3, 0x868a},
	{0xcec4, 0x6587},
	{0xcec5, 0x95fb},
	{0xcec6, 0x7eb9},
	{0xcec7, 0x543b},
	{0xcec8, 0x7a33},
	{0xcec9, 0x7d0a},
	{0xceca, 0x95ee},
	{0xcecb, 0x55e1},
	{0xcecc, 0x7fc1},
	{0xcecd, 0x74ee},
	{0xcece, 0x631d},
	{0xcecf, 0x8717},
	{0xced0, 0x6da1},
	{0xced1, 0x7a9d},
	{0xced2, 0x6211},
	{0xced3, 0x65a1},
	{0xced4, 0x5367},
	{0xced5, 0x63e1},
	{0xced6, 0x6c83},
	{0xced7, 0x5deb},
	{0xced8, 0x545c},
	{0xced9, 0x94a8},
	{0xceda, 0x4e4c},
	{0xcedb, 0x6c61},
	{0xcedc, 0x8bec},
	{0xcedd, 0x5c4b},
	{0xcede, 0x65e0},
	{0xcedf, 0x829c},
	{0xcee0, 0x68a7},
	{0xcee1, 0x543e},
	{0xcee2, 0x5434},
	{0xcee3, 0x6bcb},
	{0xcee4, 0x6b66},
	{0xcee5, 0x4e94},
	{0xcee6, 0x6342},
	{0xcee7, 0x5348},
	{0xcee8, 0x821e},
	{0xcee9, 0x4f0d},
	{0xceea, 0x4fae},
	{0xceeb, 0x575e},
	{0xceec, 0x620a},
	{0xceed, 0x96fe},
	{0xceee, 0x6664},
	{0xceef, 0x7269},
	{0xcef0, 0x52ff},
	{0xcef1, 0x52a1},
	{0xcef2, 0x609f},
	{0xcef3, 0x8bef},
	{0xcef4, 0x6614},
	{0xcef5, 0x7199},
	{0xcef6, 0x6790},
	{0xcef7, 0x897f},
	{0xcef8, 0x7852},
	{0xcef9, 0x77fd},
	{0xcefa, 0x6670},
	{0xcefb, 0x563b},
	{0xcefc, 0x5438},
	{0xcefd, 0x9521},
	{0xcefe, 0x727a},
	{0xcf40, 0x87a5},
	{0xcf41, 0x87a6},
	{0xcf42, 0x87a7},
	{0xcf43, 0x87a9},
	{0xcf44, 0x87aa},
	{0xcf45, 0x87ae},
	{0xcf46, 0x87b0},
	{0xcf47, 0x87b1},
	{0xcf48, 0x87b2},
	{0xcf49, 0x87b4},
	{0xcf4a, 0x87b6},
	{0xcf4b, 0x87b7},
	{0xcf4c, 0x87b8},
	{0xcf4d, 0x87b9},
	{0xcf4e, 0x87bb},
	{0xcf4f, 0x87bc},
	{0xcf50, 0x87be},
	{0xcf51, 0x87bf},
	{0xcf52, 0x87c1},
	{0xcf53, 0x87c2},
	{0xcf54, 0x87c3},
	{0xcf55, 0x87c4},
	{0xcf56, 0x87c5},
	{0xcf57, 0x87c7},
	{0xcf58, 0x87c8},
	{0xcf59, 0x87c9},
	{0xcf5a, 0x87cc},
	{0xcf5b, 0x87cd},
	{0xcf5c, 0x87ce},
	{0xcf5d, 0x87cf},
	{0xcf5e, 0x87d0},
	{0xcf5f, 0x87d4},
	{0xcf60, 0x87d5},
	{0xcf61, 0x87d6},
	{0xcf62, 0x87d7},
	{0xcf63, 0x87d8},
	{0xcf64, 0x87d9},
	{0xcf65, 0x87da},
	{0xcf66, 0x87dc},
	{0xcf67, 0x87dd},
	{0xcf68, 0x87de},
	{0xcf69, 0x87df},
	{0xcf6a, 0x87e1},
	{0xcf6b, 0x87e2},
	{0xcf6c, 0x87e3},
	{0xcf6d, 0x87e4},
	{0xcf6e, 0x87e6},
	{0xcf6f, 0x87e7},
	{0xcf70, 0x87e8},
	{0xcf71, 0x87e9},
	{0xcf72, 0x87eb},
	{0xcf73, 0x87ec},
	{0xcf74, 0x87ed},
	{0xcf75, 0x87ef},
	{0xcf76, 0x87f0},
	{0xcf77, 0x87f1},
	{0xcf78, 0x87f2},
	{0xcf79, 0x87f3},
	{0xcf7a, 0x87f4},
	{0xcf7b, 0x87f5},
	{0xcf7c, 0x87f6},
	{0xcf7d, 0x87f7},
	{0xcf7e, 0x87f8},
	{0xcf80, 0x87fa},
	{0xcf81, 0x87fb},
	{0xcf82, 0x87fc},
	{0xcf83, 0x87fd},
	{0xcf84, 0x87ff},
	{0xcf85, 0x8800},
	{0xcf86, 0x8801},
	{0xcf87, 0x8802},
	{0xcf88, 0x8804},
	{0xcf89, 0x8805},
	{0xcf8a, 0x8806},
	{0xcf8b, 0x8807},
	{0xcf8c, 0x8808},
	{0xcf8d, 0x8809},
	{0xcf8e, 0x880b},
	{0xcf8f, 0x880c},
	{0xcf90, 0x880d},
	{0xcf91, 0x880e},
	{0xcf92, 0x880f},
	{0xcf93, 0x8810},
	{0xcf94, 0x8811},
	{0xcf95, 0x8812},
	{0xcf96, 0x8814},
	{0xcf97, 0x8817},
	{0xcf98, 0x8818},
	{0xcf99, 0x8819},
	{0xcf9a, 0x881a},
	{0xcf9b, 0x881c},
	{0xcf9c, 0x881d},
	{0xcf9d, 0x881e},
	{0xcf9e, 0x881f},
	{0xcf9f, 0x8820},
	{0xcfa0, 0x8823},
	{0xcfa1, 0x7a00},
	{0xcfa2, 0x606f},
	{0xcfa3, 0x5e0c},
	{0xcfa4, 0x6089},
	{0xcfa5, 0x819d},
	{0xcfa6, 0x5915},
	{0xcfa7, 0x60dc},
	{0xcfa8, 0x7184},
	{0xcfa9, 0x70ef},
	{0xcfaa, 0x6eaa},
	{0xcfab, 0x6c50},
	{0xcfac, 0x7280},
	{0xcfad, 0x6a84},
	{0xcfae, 0x88ad},
	{0xcfaf, 0x5e2d},
	{0xcfb0, 0x4e60},
	{0xcfb1, 0x5ab3},
	{0xcfb2, 0x559c},
	{0xcfb3, 0x94e3},
	{0xcfb4, 0x6d17},
	{0xcfb5, 0x7cfb},
	{0xcfb6, 0x9699},
	{0xcfb7, 0x620f},
	{0xcfb8, 0x7ec6},
	{0xcfb9, 0x778e},
	{0xcfba, 0x867e},
	{0xcfbb, 0x5323},
	{0xcfbc, 0x971e},
	{0xcfbd, 0x8f96},
	{0xcfbe, 0x6687},
	{0xcfbf, 0x5ce1},
	{0xcfc0, 0x4fa0},
	{0xcfc1, 0x72ed},
	{0xcfc2, 0x4e0b},
	{0xcfc3, 0x53a6},
	{0xcfc4, 0x590f},
	{0xcfc5, 0x5413},
	{0xcfc6, 0x6380},
	{0xcfc7, 0x9528},
	{0xcfc8, 0x5148},
	{0xcfc9, 0x4ed9},
	{0xcfca, 0x9c9c},
	{0xcfcb, 0x7ea4},
	{0xcfcc, 0x54b8},
	{0xcfcd, 0x8d24},
	{0xcfce, 0x8854},
	{0xcfcf, 0x8237},
	{0xcfd0, 0x95f2},
	{0xcfd1, 0x6d8e},
	{0xcfd2, 0x5f26},
	{0xcfd3, 0x5acc},
	{0xcfd4, 0x663e},
	{0xcfd5, 0x9669},
	{0xcfd6, 0x73b0},
	{0xcfd7, 0x732e},
	{0xcfd8, 0x53bf},
	{0xcfd9, 0x817a},
	{0xcfda, 0x9985},
	{0xcfdb, 0x7fa1},
	{0xcfdc, 0x5baa},
	{0xcfdd, 0x9677},
	{0xcfde, 0x9650},
	{0xcfdf, 0x7ebf},
	{0xcfe0, 0x76f8},
	{0xcfe1, 0x53a2},
	{0xcfe2, 0x9576},
	{0xcfe3, 0x9999},
	{0xcfe4, 0x7bb1},
	{0xcfe5, 0x8944},
	{0xcfe6, 0x6e58},
	{0xcfe7, 0x4e61},
	{0xcfe8, 0x7fd4},
	{0xcfe9, 0x7965},
	{0xcfea, 0x8be6},
	{0xcfeb, 0x60f3},
	{0xcfec, 0x54cd},
	{0xcfed, 0x4eab},
	{0xcfee, 0x9879},
	{0xcfef, 0x5df7},
	{0xcff0, 0x6a61},
	{0xcff1, 0x50cf},
	{0xcff2, 0x5411},
	{0xcff3, 0x8c61},
	{0xcff4, 0x8427},
	{0xcff5, 0x785d},
	{0xcff6, 0x9704},
	{0xcff7, 0x524a},
	{0xcff8, 0x54ee},
	{0xcff9, 0x56a3},
	{0xcffa, 0x9500},
	{0xcffb, 0x6d88},
	{0xcffc, 0x5bb5},
	{0xcffd, 0x6dc6},
	{0xcffe, 0x6653},
	{0xd040, 0x8824},
	{0xd041, 0x8825},
	{0xd042, 0x8826},
	{0xd043, 0x8827},
	{0xd044, 0x8828},
	{0xd045, 0x8829},
	{0xd046, 0x882a},
	{0xd047, 0x882b},
	{0xd048, 0x882c},
	{0xd049, 0x882d},
	{0xd04a, 0x882e},
	{0xd04b, 0x882f},
	{0xd04c, 0x8830},
	{0xd04d, 0x8831},
	{0xd04e, 0x8833},
	{0xd04f, 0x8834},
	{0xd050, 0x8835},
	{0xd051, 0x8836},
	{0xd052, 0x8837},
	{0xd053, 0x8838},
	{0xd054, 0x883a},
	{0xd055, 0x883b},
	{0xd056, 0x883d},
	{0xd057, 0x883e},
	{0xd058, 0x883f},
	{0xd059, 0x8841},
	{0xd05a, 0x8842},
	{0xd05b, 0x8843},
	{0xd05c, 0x8846},
	{0xd05d, 0x8847},
	{0xd05e, 0x8848},
	{0xd05f, 0x8849},
	{0xd060, 0x884a},
	{0xd061, 0x884b},
	{0xd062, 0x884e},
	{0xd063, 0x884f},
	{0xd064, 0x8850},
	{0xd065, 0x8851},
	{0xd066, 0x8852},
	{0xd067, 0x8853},
	{0xd068, 0x8855},
	{0xd069, 0x8856},
	{0xd06a, 0x8858},
	{0xd06b, 0x885a},
	{0xd06c, 0x885b},
	{0xd06d, 0x885c},
	{0xd06e, 0x885d},
	{0xd06f, 0x885e},
	{0xd070, 0x885f},
	{0xd071, 0x8860},
	{0xd072, 0x8866},
	{0xd073, 0x8867},
	{0xd074, 0x886a},
	{0xd075, 0x886d},
	{0xd076, 0x886f},
	{0xd077, 0x8871},
	{0xd078, 0x8873},
	{0xd079, 0x8874},
	{0xd07a, 0x8875},
	{0xd07b, 0x8876},
	{0xd07c, 0x8878},
	{0xd07d, 0x8879},
	{0xd07e, 0x887a},
	{0xd080, 0x887b},
	{0xd081, 0x887c},
	{0xd082, 0x8880},
	{0xd083, 0x8883},
	{0xd084, 0x8886},
	{0xd085, 0x8887},
	{0xd086, 0x8889},
	{0xd087, 0x888a},
	{0xd088, 0x888c},
	{0xd089, 0x888e},
	{0xd08a, 0x888f},
	{0xd08b, 0x8890},
	{0xd08c, 0x8891},
	{0xd08d, 0x8893},
	{0xd08e, 0x8894},
	{0xd08f, 0x8895},
	{0xd090, 0x8897},
	{0xd091, 0x8898},
	{0xd092, 0x8899},
	{0xd093, 0x889a},
	{0xd094, 0x889b},
	{0xd095, 0x889d},
	{0xd096, 0x889e},
	{0xd097, 0x889f},
	{0xd098, 0x88a0},
	{0xd099, 0x88a1},
	{0xd09a, 0x88a3},
	{0xd09b, 0x88a5},
	{0xd09c, 0x88a6},
	{0xd09d, 0x88a7},
	{0xd09e, 0x88a8},
	{0xd09f, 0x88a9},
	{0xd0a0, 0x88aa},
	{0xd0a1, 0x5c0f},
	{0xd0a2, 0x5b5d},
	{0xd0a3, 0x6821},
	{0xd0a4, 0x8096},
	{0xd0a5, 0x5578},
	{0xd0a6, 0x7b11},
	{0xd0a7, 0x6548},
	{0xd0a8, 0x6954},
	{0xd0a9, 0x4e9b},
	{0xd0aa, 0x6b47},
	{0xd0ab, 0x874e},
	{0xd0ac, 0x978b},
	{0xd0ad, 0x534f},
	{0xd0ae, 0x631f},
	{0xd0af, 0x643a},
	{0xd0b0, 0x90aa},
	{0xd0b1, 0x659c},
	{0xd0b2, 0x80c1},
	{0xd0b3, 0x8c10},
	{0xd0b4, 0x5199},
	{0xd0b5, 0x68b0},
	{0xd0b6, 0x5378},
	{0xd0b7, 0x87f9},
	{0xd0b8, 0x61c8},
	{0xd0b9, 0x6cc4},
	{0xd0ba, 0x6cfb},
	{0xd0bb, 0x8c22},
	{0xd0bc, 0x5c51},
	{0xd0bd, 0x85aa},
	{0xd0be, 0x82af},
	{0xd0bf, 0x950c},
	{0xd0c0, 0x6b23},
	{0xd0c1, 0x8f9b},
	{0xd0c2, 0x65b0},
	{0xd0c3, 0x5ffb},
	{0xd0c4, 0x5fc3},
	{0xd0c5, 0x4fe1},
	{0xd0c6, 0x8845},
	{0xd0c7, 0x661f},
	{0xd0c8, 0x8165},
	{0xd0c9, 0x7329},
	{0xd0ca, 0x60fa},
	{0xd0cb, 0x5174},
	{0xd0cc, 0x5211},
	{0xd0cd, 0x578b},
	{0xd0ce, 0x5f62},
	{0xd0cf, 0x90a2},
	{0xd0d0, 0x884c},
	{0xd0d1, 0x9192},
	{0xd0d2, 0x5e78},
	{0xd0d3, 0x674f},
	{0xd0d4, 0x6027},
	{0xd0d5, 0x59d3},
	{0xd0d6, 0x5144},
	{0xd0d7, 0x51f6},
	{0xd0d8, 0x80f8},
	{0xd0d9, 0x5308},
	{0xd0da, 0x6c79},
	{0xd0db, 0x96c4},
	{0xd0dc, 0x718a},
	{0xd0dd, 0x4f11},
	{0xd0de, 0x4fee},
	{0xd0df, 0x7f9e},
	{0xd0e0, 0x673d},
	{0xd0e1, 0x55c5},
	{0xd0e2, 0x9508},
	{0xd0e3, 0x79c0},
	{0xd0e4, 0x8896},
	{0xd0e5, 0x7ee3},
	{0xd0e6, 0x589f},
	{0xd0e7, 0x620c},
	{0xd0e8, 0x9700},
	{0xd0e9, 0x865a},
	{0xd0ea, 0x5618},
	{0xd0eb, 0x987b},
	{0xd0ec, 0x5f90},
	{0xd0ed, 0x8bb8},
	{0xd0ee, 0x84c4},
	{0xd0ef, 0x9157},
	{0xd0f0, 0x53d9},
	{0xd0f1, 0x65ed},
	{0xd0f2, 0x5e8f},
	{0xd0f3, 0x755c},
	{0xd0f4, 0x6064},
	{0xd0f5, 0x7d6e},
	{0xd0f6, 0x5a7f},
	{0xd0f7, 0x7eea},
	{0xd0f8, 0x7eed},
	{0xd0f9, 0x8f69},
	{0xd0fa, 0x55a7},
	{0xd0fb, 0x5ba3},
	{0xd0fc, 0x60ac},
	{0xd0fd, 0x65cb},
	{0xd0fe, 0x7384},
	{0xd140, 0x88ac},
	{0xd141, 0x88ae},
	{0xd142, 0x88af},
	{0xd143, 0x88b0},
	{0xd144, 0x88b2},
	{0xd145, 0x88b3},
	{0xd146, 0x88b4},
	{0xd147, 0x88b5},
	{0xd148, 0x88b6},
	{0xd149, 0x88b8},
	{0xd14a, 0x88b9},
	{0xd14b, 0x88ba},
	{0xd14c, 0x88bb},
	{0xd14d, 0x88bd},
	{0xd14e, 0x88be},
	{0xd14f, 0x88bf},
	{0xd150, 0x88c0},
	{0xd151, 0x88c3},
	{0xd152, 0x88c4},
	{0xd153, 0x88c7},
	{0xd154, 0x88c8},
	{0xd155, 0x88ca},
	{0xd156, 0x88cb},
	{0xd157, 0x88cc},
	{0xd158, 0x88cd},
	{0xd159, 0x88cf},
	{0xd15a, 0x88d0},
	{0xd15b, 0x88d1},
	{0xd15c, 0x88d3},
	{0xd15d, 0x88d6},
	{0xd15e, 0x88d7},
	{0xd15f, 0x88da},
	{0xd160, 0x88db},
	{0xd161, 0x88dc},
	{0xd162, 0x88dd},
	{0xd163, 0x88de},
	{0xd164, 0x88e0},
	{0xd165, 0x88e1},
	{0xd166, 0x88e6},
	{0xd167, 0x88e7},
	{0xd168, 0x88e9},
	{0xd169, 0x88ea},
	{0xd16a, 0x88eb},
	{0xd16b, 0x88ec},
	{0xd16c, 0x88ed},
	{0xd16d, 0x88ee},
	{0xd16e, 0x88ef},
	{0xd16f, 0x88f2},
	{0xd170, 0x88f5},
	{0xd171, 0x88f6},
	{0xd172, 0x88f7},
	{0xd173, 0x88fa},
	{0xd174, 0x88fb},
	{0xd175, 0x88fd},
	{0xd176, 0x88ff},
	{0xd177, 0x8900},
	{0xd178, 0x8901},
	{0xd179, 0x8903},
	{0xd17a, 0x8904},
	{0xd17b, 0x8905},
	{0xd17c, 0x8906},
	{0xd17d, 0x8907},
	{0xd17e, 0x8908},
	{0xd180, 0x8909},
	{0xd181, 0x890b},
	{0xd182, 0x890c},
	{0xd183, 0x890d},
	{0xd184, 0x890e},
	{0xd185, 0x890f},
	{0xd186, 0x8911},
	{0xd187, 0x8914},
	{0xd188, 0x8915},
	{0xd189, 0x8916},
	{0xd18a, 0x8917},
	{0xd18b, 0x8918},
	{0xd18c, 0x891c},
	{0xd18d, 0x891d},
	{0xd18e, 0x891e},
	{0xd18f, 0x891f},
	{0xd190, 0x8920},
	{0xd191, 0x8922},
	{0xd192, 0x8923},
	{0xd193, 0x8924},
	{0xd194, 0x8926},
	{0xd195, 0x8927},
	{0xd196, 0x8928},
	{0xd197, 0x8929},
	{0xd198, 0x892c},
	{0xd199, 0x892d},
	{0xd19a, 0x892e},
	{0xd19b, 0x892f},
	{0xd19c, 0x8931},
	{0xd19d, 0x8932},
	{0xd19e, 0x8933},
	{0xd19f, 0x8935},
	{0xd1a0, 0x8937},
	{0xd1a1, 0x9009},
	{0xd1a2, 0x7663},
	{0xd1a3, 0x7729},
	{0xd1a4, 0x7eda},
	{0xd1a5, 0x9774},
	{0xd1a6, 0x859b},
	{0xd1a7, 0x5b66},
	{0xd1a8, 0x7a74},
	{0xd1a9, 0x96ea},
	{0xd1aa, 0x8840},
	{0xd1ab, 0x52cb},
	{0xd1ac, 0x718f},
	{0xd1ad, 0x5faa},
	{0xd1ae, 0x65ec},
	{0xd1af, 0x8be2},
	{0xd1b0, 0x5bfb},
	{0xd1b1, 0x9a6f},
	{0xd1b2, 0x5de1},
	{0xd1b3, 0x6b89},
	{0xd1b4, 0x6c5b},
	{0xd1b5, 0x8bad},
	{0xd1b6, 0x8baf},
	{0xd1b7, 0x900a},
	{0xd1b8, 0x8fc5},
	{0xd1b9, 0x538b},
	{0xd1ba, 0x62bc},
	{0xd1bb, 0x9e26},
	{0xd1bc, 0x9e2d},
	{0xd1bd, 0x5440},
	{0xd1be, 0x4e2b},
	{0xd1bf, 0x82bd},
	{0xd1c0, 0x7259},
	{0xd1c1, 0x869c},
	{0xd1c2, 0x5d16},
	{0xd1c3, 0x8859},
	{0xd1c4, 0x6daf},
	{0xd1c5, 0x96c5},
	{0xd1c6, 0x54d1},
	{0xd1c7, 0x4e9a},
	{0xd1c8, 0x8bb6},
	{0xd1c9, 0x7109},
	{0xd1ca, 0x54bd},
	{0xd1cb, 0x9609},
	{0xd1cc, 0x70df},
	{0xd1cd, 0x6df9},
	{0xd1ce, 0x76d0},
	{0xd1cf, 0x4e25},
	{0xd1d0, 0x7814},
	{0xd1d1, 0x8712},
	{0xd1d2, 0x5ca9},
	{0xd1d3, 0x5ef6},
	{0xd1d4, 0x8a00},
	{0xd1d5, 0x989c},
	{0xd1d6, 0x960e},
	{0xd1d7, 0x708e},
	{0xd1d8, 0x6cbf},
	{0xd1d9, 0x5944},
	{0xd1da, 0x63a9},
	{0xd1db, 0x773c},
	{0xd1dc, 0x884d},
	{0xd1dd, 0x6f14},
	{0xd1de, 0x8273},
	{0xd1df, 0x5830},
	{0xd1e0, 0x71d5},
	{0xd1e1, 0x538c},
	{0xd1e2, 0x781a},
	{0xd1e3, 0x96c1},
	{0xd1e4, 0x5501},
	{0xd1e5, 0x5f66},
	{0xd1e6, 0x7130},
	{0xd1e7, 0x5bb4},
	{0xd1e8, 0x8c1a},
	{0xd1e9, 0x9a8c},
	{0xd1ea, 0x6b83},
	{0xd1eb, 0x592e},
	{0xd1ec, 0x9e2f},
	{0xd1ed, 0x79e7},
	{0xd1ee, 0x6768},
	{0xd1ef, 0x626c},
	{0xd1f0, 0x4f6f},
	{0xd1f1, 0x75a1},
	{0xd1f2, 0x7f8a},
	{0xd1f3, 0x6d0b},
	{0xd1f4, 0x9633},
	{0xd1f5, 0x6c27},
	{0xd1f6, 0x4ef0},
	{0xd1f7, 0x75d2},
	{0xd1f8, 0x517b},
	{0xd1f9, 0x6837},
	{0xd1fa, 0x6f3e},
	{0xd1fb, 0x9080},
	{0xd1fc, 0x8170},
	{0xd1fd, 0x5996},
	{0xd1fe, 0x7476},
	{0xd240, 0x8938},
	{0xd241, 0x8939},
	{0xd242, 0x893a},
	{0xd243, 0x893b},
	{0xd244, 0x893c},
	{0xd245, 0x893d},
	{0xd246, 0x893e},
	{0xd247, 0x893f},
	{0xd248, 0x8940},
	{0xd249, 0x8942},
	{0xd24a, 0x8943},
	{0xd24b, 0x8945},
	{0xd24c, 0x8946},
	{0xd24d, 0x8947},
	{0xd24e, 0x8948},
	{0xd24f, 0x8949},
	{0xd250, 0x894a},
	{0xd251, 0x894b},
	{0xd252, 0x894c},
	{0xd253, 0x894d},
	{0xd254, 0x894e},
	{0xd255, 0x894f},
	{0xd256, 0x8950},
	{0xd257, 0x8951},
	{0xd258, 0x8952},
	{0xd259, 0x8953},
	{0xd25a, 0x8954},
	{0xd25b, 0x8955},
	{0xd25c, 0x8956},
	{0xd25d, 0x8957},
	{0xd25e, 0x8958},
	{0xd25f, 0x8959},
	{0xd260, 0x895a},
	{0xd261, 0x895b},
	{0xd262, 0x895c},
	{0xd263, 0x895d},
	{0xd264, 0x8960},
	{0xd265, 0x8961},
	{0xd266, 0x8962},
	{0xd267, 0x8963},
	{0xd268, 0x8964},
	{0xd269, 0x8965},
	{0xd26a, 0x8967},
	{0xd26b, 0x8968},
	{0xd26c, 0x8969},
	{0xd26d, 0x896a},
	{0xd26e, 0x896b},
	{0xd26f, 0x896c},
	{0xd270, 0x896d},
	{0xd271, 0x896e},
	{0xd272, 0x896f},
	{0xd273, 0x8970},
	{0xd274, 0x8971},
	{0xd275, 0x8972},
	{0xd276, 0x8973},
	{0xd277, 0x8974},
	{0xd278, 0x8975},
	{0xd279, 0x8976},
	{0xd27a, 0x8977},
	{0xd27b, 0x8978},
	{0xd27c, 0x8979},
	{0xd27d, 0x897a},
	{0xd27e, 0x897c},
	{0xd280, 0x897d},
	{0xd281, 0x897e},
	{0xd282, 0x8980},
	{0xd283, 0x8982},
	{0xd284, 0x8984},
	{0xd285, 0x8985},
	{0xd286, 0x8987},
	{0xd287, 0x8988},
	{0xd288, 0x8989},
	{0xd289, 0x898a},
	{0xd28a, 0x898b},
	{0xd28b, 0x898c},
	{0xd28c, 0x898d},
	{0xd28d, 0x898e},
	{0xd28e, 0x898f},
	{0xd28f, 0x8990},
	{0xd290, 0x8991},
	{0xd291, 0x8992},
	{0xd292, 0x8993},
	{0xd293, 0x8994},
	{0xd294, 0x8995},
	{0xd295, 0x8996},
	{0xd296, 0x8997},
	{0xd297, 0x8998},
	{0xd298, 0x8999},
	{0xd299, 0x899a},
	{0xd29a, 0x899b},
	{0xd29b, 0x899c},
	{0xd29c, 0x899d},
	{0xd29d, 0x899e},
	{0xd29e, 0x899f},
	{0xd29f, 0x89a0},
	{0xd2a0, 0x89a1},
	{0xd2a1, 0x6447},
	{0xd2a2, 0x5c27},
	{0xd2a3, 0x9065},
	{0xd2a4, 0x7a91},
	{0xd2a5, 0x8c23},
	{0xd2a6, 0x59da},
	{0xd2a7, 0x54ac},
	{0xd2a8, 0x8200},
	{0xd2a9, 0x836f},
	{0xd2aa, 0x8981},
	{0xd2ab, 0x8000},
	{0xd2ac, 0x6930},
	{0xd2ad, 0x564e},
	{0xd2ae, 0x8036},
	{0xd2af, 0x7237},
	{0xd2b0, 0x91ce},
	{0xd2b1, 0x51b6},
	{0xd2b2, 0x4e5f},
	{0xd2b3, 0x9875},
	{0xd2b4, 0x6396},
	{0xd2b5, 0x4e1a},
	{0xd2b6, 0x53f6},
	{0xd2b7, 0x66f3},
	{0xd2b8, 0x814b},
	{0xd2b9, 0x591c},
	{0xd2ba, 0x6db2},
	{0xd2bb, 0x4e00},
	{0xd2bc, 0x58f9},
	{0xd2bd, 0x533b},
	{0xd2be, 0x63d6},
	{0xd2bf, 0x94f1},
	{0xd2c0, 0x4f9d},
	{0xd2c1, 0x4f0a},
	{0xd2c2, 0x8863},
	{0xd2c3, 0x9890},
	{0xd2c4, 0x5937},
	{0xd2c5, 0x9057},
	{0xd2c6, 0x79fb},
	{0xd2c7, 0x4eea},
	{0xd2c8, 0x80f0},
	{0xd2c9, 0x7591},
	{0xd2ca, 0x6c82},
	{0xd2cb, 0x5b9c},
	{0xd2cc, 0x59e8},
	{0xd2cd, 0x5f5d},
	{0xd2ce, 0x6905},
	{0xd2cf, 0x8681},
	{0xd2d0, 0x501a},
	{0xd2d1, 0x5df2},
	{0xd2d2, 0x4e59},
	{0xd2d3, 0x77e3},
	{0xd2d4, 0x4ee5},
	{0xd2d5, 0x827a},
	{0xd2d6, 0x6291},
	{0xd2d7, 0x6613},
	{0xd2d8, 0x9091},
	{0xd2d9, 0x5c79},
	{0xd2da, 0x4ebf},
	{0xd2db, 0x5f79},
	{0xd2dc, 0x81c6},
	{0xd2dd, 0x9038},
	{0xd2de, 0x8084},
	{0xd2df, 0x75ab},
	{0xd2e0, 0x4ea6},
	{0xd2e1, 0x88d4},
	{0xd2e2, 0x610f},
	{0xd2e3, 0x6bc5},
	{0xd2e4, 0x5fc6},
	{0xd2e5, 0x4e49},
	{0xd2e6, 0x76ca},
	{0xd2e7, 0x6ea2},
	{0xd2e8, 0x8be3},
	{0xd2e9, 0x8bae},
	{0xd2ea, 0x8c0a},
	{0xd2eb, 0x8bd1},
	{0xd2ec, 0x5f02},
	{0xd2ed, 0x7ffc},
	{0xd2ee, 0x7fcc},
	{0xd2ef, 0x7ece},
	{0xd2f0, 0x8335},
	{0xd2f1, 0x836b},
	{0xd2f2, 0x56e0},
	{0xd2f3, 0x6bb7},
	{0xd2f4, 0x97f3},
	{0xd2f5, 0x9634},
	{0xd2f6, 0x59fb},
	{0xd2f7, 0x541f},
	{0xd2f8, 0x94f6},
	{0xd2f9, 0x6deb},
	{0xd2fa, 0x5bc5},
	{0xd2fb, 0x996e},
	{0xd2fc, 0x5c39},
	{0xd2fd, 0x5f15},
	{0xd2fe, 0x9690},
	{0xd340, 0x89a2},
	{0xd341, 0x89a3},
	{0xd342, 0x89a4},
	{0xd343, 0x89a5},
	{0xd344, 0x89a6},
	{0xd345, 0x89a7},
	{0xd346, 0x89a8},
	{0xd347, 0x89a9},
	{0xd348, 0x89aa},
	{0xd349, 0x89ab},
	{0xd34a, 0x89ac},
	{0xd34b, 0x89ad},
	{0xd34c, 0x89ae},
	{0xd34d, 0x89af},
	{0xd34e, 0x89b0},
	{0xd34f, 0x89b1},
	{0xd350, 0x89b2},
	{0xd351, 0x89b3},
	{0xd352, 0x89b4},
	{0xd353, 0x89b5},
	{0xd354, 0x89b6},
	{0xd355, 0x89b7},
	{0xd356, 0x89b8},
	{0xd357, 0x89b9},
	{0xd358, 0x89ba},
	{0xd359, 0x89bb},
	{0xd35a, 0x89bc},
	{0xd35b, 0x89bd},
	{0xd35c, 0x89be},
	{0xd35d, 0x89bf},
	{0xd35e, 0x89c0},
	{0xd35f, 0x89c3},
	{0xd360, 0x89cd},
	{0xd361, 0x89d3},
	{0xd362, 0x89d4},
	{0xd363, 0x89d5},
	{0xd364, 0x89d7},
	{0xd365, 0x89d8},
	{0xd366, 0x89d9},
	{0xd367, 0x89db},
	{0xd368, 0x89dd},
	{0xd369, 0x89df},
	{0xd36a, 0x89e0},
	{0xd36b, 0x89e1},
	{0xd36c, 0x89e2},
	{0xd36d, 0x89e4},
	{0xd36e, 0x89e7},
	{0xd36f, 0x89e8},
	{0xd370, 0x89e9},
	{0xd371, 0x89ea},
	{0xd372, 0x89ec},
	{0xd373, 0x89ed},
	{0xd374, 0x89ee},
	{0xd375, 0x89f0},
	{0xd376, 0x89f1},
	{0xd377, 0x89f2},
	{0xd378, 0x89f4},
	{0xd379, 0x89f5},
	{0xd37a, 0x89f6},
	{0xd37b, 0x89f7},
	{0xd37c, 0x89f8},
	{0xd37d, 0x89f9},
	{0xd37e, 0x89fa},
	{0xd380, 0x89fb},
	{0xd381, 0x89fc},
	{0xd382, 0x89fd},
	{0xd383, 0x89fe},
	{0xd384, 0x89ff},
	{0xd385, 0x8a01},
	{0xd386, 0x8a02},
	{0xd387, 0x8a03},
	{0xd388, 0x8a04},
	{0xd389, 0x8a05},
	{0xd38a, 0x8a06},
	{0xd38b, 0x8a08},
	{0xd38c, 0x8a09},
	{0xd38d, 0x8a0a},
	{0xd38e, 0x8a0b},
	{0xd38f, 0x8a0c},
	{0xd390, 0x8a0d},
	{0xd391, 0x8a0e},
	{0xd392, 0x8a0f},
	{0xd393, 0x8a10},
	{0xd394, 0x8a11},
	{0xd395, 0x8a12},
	{0xd396, 0x8a13},
	{0xd397, 0x8a14},
	{0xd398, 0x8a15},
	{0xd399, 0x8a16},
	{0xd39a, 0x8a17},
	{0xd39b, 0x8a18},
	{0xd39c, 0x8a19},
	{0xd39d, 0x8a1a},
	{0xd39e, 0x8a1b},
	{0xd39f, 0x8a1c},
	{0xd3a0, 0x8a1d},
	{0xd3a1, 0x5370},
	{0xd3a2, 0x82f1},
	{0xd3a3, 0x6a31},
	{0xd3a4, 0x5a74},
	{0xd3a5, 0x9e70},
	{0xd3a6, 0x5e94},
	{0xd3a7, 0x7f28},
	{0xd3a8, 0x83b9},
	{0xd3a9, 0x8424},
	{0xd3aa, 0x8425},
	{0xd3ab, 0x8367},
	{0xd3ac, 0x8747},
	{0xd3ad, 0x8fce},
	{0xd3ae, 0x8d62},
	{0xd3af, 0x76c8},
	{0xd3b0, 0x5f71},
	{0xd3b1, 0x9896},
	{0xd3b2, 0x786c},
	{0xd3b3, 0x6620},
	{0xd3b4, 0x54df},
	{0xd3b5, 0x62e5},
	{0xd3b6, 0x4f63},
	{0xd3b7, 0x81c3},
	{0xd3b8, 0x75c8},
	{0xd3b9, 0x5eb8},
	{0xd3ba, 0x96cd},
	{0xd3bb, 0x8e0a},
	{0xd3bc, 0x86f9},
	{0xd3bd, 0x548f},
	{0xd3be, 0x6cf3},
	{0xd3bf, 0x6d8c},
	{0xd3c0, 0x6c38},
	{0xd3c1, 0x607f},
	{0xd3c2, 0x52c7},
	{0xd3c3, 0x7528},
	{0xd3c4, 0x5e7d},
	{0xd3c5, 0x4f18},
	{0xd3c6, 0x60a0},
	{0xd3c7, 0x5fe7},
	{0xd3c8, 0x5c24},
	{0xd3c9, 0x7531},
	{0xd3ca, 0x90ae},
	{0xd3cb, 0x94c0},
	{0xd3cc, 0x72b9},
	{0xd3cd, 0x6cb9},
	{0xd3ce, 0x6e38},
	{0xd3cf, 0x9149},
	{0xd3d0, 0x6709},
	{0xd3d1, 0x53cb},
	{0xd3d2, 0x53f3},
	{0xd3d3, 0x4f51},
	{0xd3d4, 0x91c9},
	{0xd3d5, 0x8bf1},
	{0xd3d6, 0x53c8},
	{0xd3d7, 0x5e7c},
	{0xd3d8, 0x8fc2},
	{0xd3d9, 0x6de4},
	{0xd3da, 0x4e8e},
	{0xd3db, 0x76c2},
	{0xd3dc, 0x6986},
	{0xd3dd, 0x865e},
	{0xd3de, 0x611a},
	{0xd3df, 0x8206},
	{0xd3e0, 0x4f59},
	{0xd3e1, 0x4fde},
	{0xd3e2, 0x903e},
	{0xd3e3, 0x9c7c},
	{0xd3e4, 0x6109},
	{0xd3e5, 0x6e1d},
	{0xd3e6, 0x6e14},
	{0xd3e7, 0x9685},
	{0xd3e8, 0x4e88},
	{0xd3e9, 0x5a31},
	{0xd3ea, 0x96e8},
	{0xd3eb, 0x4e0e},
	{0xd3ec, 0x5c7f},
	{0xd3ed, 0x79b9},
	{0xd3ee, 0x5b87},
	{0xd3ef, 0x8bed},
	{0xd3f0, 0x7fbd},
	{0xd3f1, 0x7389},
	{0xd3f2, 0x57df},
	{0xd3f3, 0x828b},
	{0xd3f4, 0x90c1},
	{0xd3f5, 0x5401},
	{0xd3f6, 0x9047},
	{0xd3f7, 0x55bb},
	{0xd3f8, 0x5cea},
	{0xd3f9, 0x5fa1},
	{0xd3fa, 0x6108},
	{0xd3fb, 0x6b32},
	{0xd3fc, 0x72f1},
	{0xd3fd, 0x80b2},
	{0xd3fe, 0x8a89},
	{0xd440, 0x8a1e},
	{0xd441, 0x8a1f},
	{0xd442, 0x8a20},
	{0xd443, 0x8a21},
	{0xd444, 0x8a22},
	{0xd445, 0x8a23},
	{0xd446, 0x8a24},
	{0xd447, 0x8a25},
	{0xd448, 0x8a26},
	{0xd449, 0x8a27},
	{0xd44a, 0x8a28},
	{0xd44b, 0x8a29},
	{0xd44c, 0x8a2a},
	{0xd44d, 0x8a2b},
	{0xd44e, 0x8a2c},
	{0xd44f, 0x8a2d},
	{0xd450, 0x8a2e},
	{0xd451, 0x8a2f},
	{0xd452, 0x8a30},
	{0xd453, 0x8a31},
	{0xd454, 0x8a32},
	{0xd455, 0x8a33},
	{0xd456, 0x8a34},
	{0xd457, 0x8a35},
	{0xd458, 0x8a36},
	{0xd459, 0x8a37},
	{0xd45a, 0x8a38},
	{0xd45b, 0x8a39},
	{0xd45c, 0x8a3a},
	{0xd45d, 0x8a3b},
	{0xd45e, 0x8a3c},
	{0xd45f, 0x8a3d},
	{0xd460, 0x8a3f},
	{0xd461, 0x8a40},
	{0xd462, 0x8a41},
	{0xd463, 0x8a42},
	{0xd464, 0x8a43},
	{0xd465, 0x8a44},
	{0xd466, 0x8a45},
	{0xd467, 0x8a46},
	{0xd468, 0x8a47},
	{0xd469, 0x8a49},
	{0xd46a, 0x8a4a},
	{0xd46b, 0x8a4b},
	{0xd46c, 0x8a4c},
	{0xd46d, 0x8a4d},
	{0xd46e, 0x8a4e},
	{0xd46f, 0x8a4f},
	{0xd470, 0x8a50},
	{0xd471, 0x8a51},
	{0xd472, 0x8a52},
	{0xd473, 0x8a53},
	{0xd474, 0x8a54},
	{0xd475, 0x8a55},
	{0xd476, 0x8a56},
	{0xd477, 0x8a57},
	{0xd478, 0x8a58},
	{0xd479, 0x8a59},
	{0xd47a, 0x8a5a},
	{0xd47b, 0x8a5b},
	{0xd47c, 0x8a5c},
	{0xd47d, 0x8a5d},
	{0xd47e, 0x8a5e},
	{0xd480, 0x8a5f},
	{0xd481, 0x8a60},
	{0xd482, 0x8a61},
	{0xd483, 0x8a62},
	{0xd484, 0x8a63},
	{0xd485, 0x8a64},
	{0xd486, 0x8a65},
	{0xd487, 0x8a66},
	{0xd488, 0x8a67},
	{0xd489, 0x8a68},
	{0xd48a, 0x8a69},
	{0xd48b, 0x8a6a},
	{0xd48c, 0x8a6b},
	{0xd48d, 0x8a6c},
	{0xd48e, 0x8a6d},
	{0xd48f, 0x8a6e},
	{0xd490, 0x8a6f},
	{0xd491, 0x8a70},
	{0xd492, 0x8a71},
	{0xd493, 0x8a72},
	{0xd494, 0x8a73},
	{0xd495, 0x8a74},
	{0xd496, 0x8a75},
	{0xd497, 0x8a76},
	{0xd498, 0x8a77},
	{0xd499, 0x8a78},
	{0xd49a, 0x8a7a},
	{0xd49b, 0x8a7b},
	{0xd49c, 0x8a7c},
	{0xd49d, 0x8a7d},
	{0xd49e, 0x8a7e},
	{0xd49f, 0x8a7f},
	{0xd4a0, 0x8a80},
	{0xd4a1, 0x6d74},
	{0xd4a2, 0x5bd3},
	{0xd4a3, 0x88d5},
	{0xd4a4, 0x9884},
	{0xd4a5, 0x8c6b},
	{0xd4a6, 0x9a6d},
	{0xd4a7, 0x9e33},
	{0xd4a8, 0x6e0a},
	{0xd4a9, 0x51a4},
	{0xd4aa, 0x5143},
	{0xd4ab, 0x57a3},
	{0xd4ac, 0x8881},
	{0xd4ad, 0x539f},
	{0xd4ae, 0x63f4},
	{0xd4af, 0x8f95},
	{0xd4b0, 0x56ed},
	{0xd4b1, 0x5458},
	{0xd4b2, 0x5706},
	{0xd4b3, 0x733f},
	{0xd4b4, 0x6e90},
	{0xd4b5, 0x7f18},
	{0xd4b6, 0x8fdc},
	{0xd4b7, 0x82d1},
	{0xd4b8, 0x613f},
	{0xd4b9, 0x6028},
	{0xd4ba, 0x9662},
	{0xd4bb, 0x66f0},
	{0xd4bc, 0x7ea6},
	{0xd4bd, 0x8d8a},
	{0xd4be, 0x8dc3},
	{0xd4bf, 0x94a5},
	{0xd4c0, 0x5cb3},
	{0xd4c1, 0x7ca4},
	{0xd4c2, 0x6708},
	{0xd4c3, 0x60a6},
	{0xd4c4, 0x9605},
	{0xd4c5, 0x8018},
	{0xd4c6, 0x4e91},
	{0xd4c7, 0x90e7},
	{0xd4c8, 0x5300},
	{0xd4c9, 0x9668},
	{0xd4ca, 0x5141},
	{0xd4cb, 0x8fd0},
	{0xd4cc, 0x8574},
	{0xd4cd, 0x915d},
	{0xd4ce, 0x6655},
	{0xd4cf, 0x97f5},
	{0xd4d0, 0x5b55},
	{0xd4d1, 0x531d},
	{0xd4d2, 0x7838},
	{0xd4d3, 0x6742},
	{0xd4d4, 0x683d},
	{0xd4d5, 0x54c9},
	{0xd4d6, 0x707e},
	{0xd4d7, 0x5bb0},
	{0xd4d8, 0x8f7d},
	{0xd4d9, 0x518d},
	{0xd4da, 0x5728},
	{0xd4db, 0x54b1},
	{0xd4dc, 0x6512},
	{0xd4dd, 0x6682},
	{0xd4de, 0x8d5e},
	{0xd4df, 0x8d43},
	{0xd4e0, 0x810f},
	{0xd4e1, 0x846c},
	{0xd4e2, 0x906d},
	{0xd4e3, 0x7cdf},
	{0xd4e4, 0x51ff},
	{0xd4e5, 0x85fb},
	{0xd4e6, 0x67a3},
	{0xd4e7, 0x65e9},
	{0xd4e8, 0x6fa1},
	{0xd4e9, 0x86a4},
	{0xd4ea, 0x8e81},
	{0xd4eb, 0x566a},
	{0xd4ec, 0x9020},
	{0xd4ed, 0x7682},
	{0xd4ee, 0x7076},
	{0xd4ef, 0x71e5},
	{0xd4f0, 0x8d23},
	{0xd4f1, 0x62e9},
	{0xd4f2, 0x5219},
	{0xd4f3, 0x6cfd},
	{0xd4f4, 0x8d3c},
	{0xd4f5, 0x600e},
	{0xd4f6, 0x589e},
	{0xd4f7, 0x618e},
	{0xd4f8, 0x66fe},
	{0xd4f9, 0x8d60},
	{0xd4fa, 0x624e},
	{0xd4fb, 0x55b3},
	{0xd4fc, 0x6e23},
	{0xd4fd, 0x672d},
	{0xd4fe, 0x8f67},
	{0xd540, 0x8a81},
	{0xd541, 0x8a82},
	{0xd542, 0x8a83},
	{0xd543, 0x8a84},
	{0xd544, 0x8a85},
	{0xd545, 0x8a86},
	{0xd546, 0x8a87},
	{0xd547, 0x8a88},
	{0xd548, 0x8a8b},
	{0xd549, 0x8a8c},
	{0xd54a, 0x8a8d},
	{0xd54b, 0x8a8e},
	{0xd54c, 0x8a8f},
	{0xd54d, 0x8a90},
	{0xd54e, 0x8a91},
	{0xd54f, 0x8a92},
	{0xd550, 0x8a94},
	{0xd551, 0x8a95},
	{0xd552, 0x8a96},
	{0xd553, 0x8a97},
	{0xd554, 0x8a98},
	{0xd555, 0x8a99},
	{0xd556, 0x8a9a},
	{0xd557, 0x8a9b},
	{0xd558, 0x8a9c},
	{0xd559, 0x8a9d},
	{0xd55a, 0x8a9e},
	{0xd55b, 0x8a9f},
	{0xd55c, 0x8aa0},
	{0xd55d, 0x8aa1},
	{0xd55e, 0x8aa2},
	{0xd55f, 0x8aa3},
	{0xd560, 0x8aa4},
	{0xd561, 0x8aa5},
	{0xd562, 0x8aa6},
	{0xd563, 0x8aa7},
	{0xd564, 0x8aa8},
	{0xd565, 0x8aa9},
	{0xd566, 0x8aaa},
	{0xd567, 0x8aab},
	{0xd568, 0x8aac},
	{0xd569, 0x8aad},
	{0xd56a, 0x8aae},
	{0xd56b, 0x8aaf},
	{0xd56c, 0x8ab0},
	{0xd56d, 0x8ab1},
	{0xd56e, 0x8ab2},
	{0xd56f, 0x8ab3},
	{0xd570, 0x8ab4},
	{0xd571, 0x8ab5},
	{0xd572, 0x8ab6},
	{0xd573, 0x8ab7},
	{0xd574, 0x8ab8},
	{0xd575, 0x8ab9},
	{0xd576, 0x8aba},
	{0xd577, 0x8abb},
	{0xd578, 0x8abc},
	{0xd579, 0x8abd},
	{0xd57a, 0x8abe},
	{0xd57b, 0x8abf},
	{0xd57c, 0x8ac0},
	{0xd57d, 0x8ac1},
	{0xd57e, 0x8ac2},
	{0xd580, 0x8ac3},
	{0xd581, 0x8ac4},
	{0xd582, 0x8ac5},
	{0xd583, 0x8ac6},
	{0xd584, 0x8ac7},
	{0xd585, 0x8ac8},
	{0xd586, 0x8ac9},
	{0xd587, 0x8aca},
	{0xd588, 0x8acb},
	{0xd589, 0x8acc},
	{0xd58a, 0x8acd},
	{0xd58b, 0x8ace},
	{0xd58c, 0x8acf},
	{0xd58d, 0x8ad0},
	{0xd58e, 0x8ad1},
	{0xd58f, 0x8ad2},
	{0xd590, 0x8ad3},
	{0xd591, 0x8ad4},
	{0xd592, 0x8ad5},
	{0xd593, 0x8ad6},
	{0xd594, 0x8ad7},
	{0xd595, 0x8ad8},
	{0xd596, 0x8ad9},
	{0xd597, 0x8ada},
	{0xd598, 0x8adb},
	{0xd599, 0x8adc},
	{0xd59a, 0x8add},
	{0xd59b, 0x8ade},
	{0xd59c, 0x8adf},
	{0xd59d, 0x8ae0},
	{0xd59e, 0x8ae1},
	{0xd59f, 0x8ae2},
	{0xd5a0, 0x8ae3},
	{0xd5a1, 0x94e1},
	{0xd5a2, 0x95f8},
	{0xd5a3, 0x7728},
	{0xd5a4, 0x6805},
	{0xd5a5, 0x69a8},
	{0xd5a6, 0x548b},
	{0xd5a7, 0x4e4d},
	{0xd5a8, 0x70b8},
	{0xd5a9, 0x8bc8},
	{0xd5aa, 0x6458},
	{0xd5ab, 0x658b},
	{0xd5ac, 0x5b85},
	{0xd5ad, 0x7a84},
	{0xd5ae, 0x503a},
	{0xd5af, 0x5be8},
	{0xd5b0, 0x77bb},
	{0xd5b1, 0x6be1},
	{0xd5b2, 0x8a79},
	{0xd5b3, 0x7c98},
	{0xd5b4, 0x6cbe},
	{0xd5b5, 0x76cf},
	{0xd5b6, 0x65a9},
	{0xd5b7, 0x8f97},
	{0xd5b8, 0x5d2d},
	{0xd5b9, 0x5c55},
	{0xd5ba, 0x8638},
	{0xd5bb, 0x6808},
	{0xd5bc, 0x5360},
	{0xd5bd, 0x6218},
	{0xd5be, 0x7ad9},
	{0xd5bf, 0x6e5b},
	{0xd5c0, 0x7efd},
	{0xd5c1, 0x6a1f},
	{0xd5c2, 0x7ae0},
	{0xd5c3, 0x5f70},
	{0xd5c4, 0x6f33},
	{0xd5c5, 0x5f20},
	{0xd5c6, 0x638c},
	{0xd5c7, 0x6da8},
	{0xd5c8, 0x6756},
	{0xd5c9, 0x4e08},
	{0xd5ca, 0x5e10},
	{0xd5cb, 0x8d26},
	{0xd5cc, 0x4ed7},
	{0xd5cd, 0x80c0},
	{0xd5ce, 0x7634},
	{0xd5cf, 0x969c},
	{0xd5d0, 0x62db},
	{0xd5d1, 0x662d},
	{0xd5d2, 0x627e},
	{0xd5d3, 0x6cbc},
	{0xd5d4, 0x8d75},
	{0xd5d5, 0x7167},
	{0xd5d6, 0x7f69},
	{0xd5d7, 0x5146},
	{0xd5d8, 0x8087},
	{0xd5d9, 0x53ec},
	{0xd5da, 0x906e},
	{0xd5db, 0x6298},
	{0xd5dc, 0x54f2},
	{0xd5dd, 0x86f0},
	{0xd5de, 0x8f99},
	{0xd5df, 0x8005},
	{0xd5e0, 0x9517},
	{0xd5e1, 0x8517},
	{0xd5e2, 0x8fd9},
	{0xd5e3, 0x6d59},
	{0xd5e4, 0x73cd},
	{0xd5e5, 0x659f},
	{0xd5e6, 0x771f},
	{0xd5e7, 0x7504},
	{0xd5e8, 0x7827},
	{0xd5e9, 0x81fb},
	{0xd5ea, 0x8d1e},
	{0xd5eb, 0x9488},
	{0xd5ec, 0x4fa6},
	{0xd5ed, 0x6795},
	{0xd5ee, 0x75b9},
	{0xd5ef, 0x8bca},
	{0xd5f0, 0x9707},
	{0xd5f1, 0x632f},
	{0xd5f2, 0x9547},
	{0xd5f3, 0x9635},
	{0xd5f4, 0x84b8},
	{0xd5f5, 0x6323},
	{0xd5f6, 0x7741},
	{0xd5f7, 0x5f81},
	{0xd5f8, 0x72f0},
	{0xd5f9, 0x4e89},
	{0xd5fa, 0x6014},
	{0xd5fb, 0x6574},
	{0xd5fc, 0x62ef},
	{0xd5fd, 0x6b63},
	{0xd5fe, 0x653f},
	{0xd640, 0x8ae4},
	{0xd641, 0x8ae5},
	{0xd642, 0x8ae6},
	{0xd643, 0x8ae7},
	{0xd644, 0x8ae8},
	{0xd645, 0x8ae9},
	{0xd646, 0x8aea},
	{0xd647, 0x8aeb},
	{0xd648, 0x8aec},
	{0xd649, 0x8aed},
	{0xd64a, 0x8aee},
	{0xd64b, 0x8aef},
	{0xd64c, 0x8af0},
	{0xd64d, 0x8af1},
	{0xd64e, 0x8af2},
	{0xd64f, 0x8af3},
	{0xd650, 0x8af4},
	{0xd651, 0x8af5},
	{0xd652, 0x8af6},
	{0xd653, 0x8af7},
	{0xd654, 0x8af8},
	{0xd655, 0x8af9},
	{0xd656, 0x8afa},
	{0xd657, 0x8afb},
	{0xd658, 0x8afc},
	{0xd659, 0x8afd},
	{0xd65a, 0x8afe},
	{0xd65b, 0x8aff},
	{0xd65c, 0x8b00},
	{0xd65d, 0x8b01},
	{0xd65e, 0x8b02},
	{0xd65f, 0x8b03},
	{0xd660, 0x8b04},
	{0xd661, 0x8b05},
	{0xd662, 0x8b06},
	{0xd663, 0x8b08},
	{0xd664, 0x8b09},
	{0xd665, 0x8b0a},
	{0xd666, 0x8b0b},
	{0xd667, 0x8b0c},
	{0xd668, 0x8b0d},
	{0xd669, 0x8b0e},
	{0xd66a, 0x8b0f},
	{0xd66b, 0x8b10},
	{0xd66c, 0x8b11},
	{0xd66d, 0x8b12},
	{0xd66e, 0x8b13},
	{0xd66f, 0x8b14},
	{0xd670, 0x8b15},
	{0xd671, 0x8b16},
	{0xd672, 0x8b17},
	{0xd673, 0x8b18},
	{0xd674, 0x8b19},
	{0xd675, 0x8b1a},
	{0xd676, 0x8b1b},
	{0xd677, 0x8b1c},
	{0xd678, 0x8b1d},
	{0xd679, 0x8b1e},
	{0xd67a, 0x8b1f},
	{0xd67b, 0x8b20},
	{0xd67c, 0x8b21},
	{0xd67d, 0x8b22},
	{0xd67e, 0x8b23},
	{0xd680, 0x8b24},
	{0xd681, 0x8b25},
	{0xd682, 0x8b27},
	{0xd683, 0x8b28},
	{0xd684, 0x8b29},
	{0xd685, 0x8b2a},
	{0xd686, 0x8b2b},
	{0xd687, 0x8b2c},
	{0xd688, 0x8b2d},
	{0xd689, 0x8b2e},
	{0xd68a, 0x8b2f},
	{0xd68b, 0x8b30},
	{0xd68c, 0x8b31},
	{0xd68d, 0x8b32},
	{0xd68e, 0x8b33},
	{0xd68f, 0x8b34},
	{0xd690, 0x8b35},
	{0xd691, 0x8b36},
	{0xd692, 0x8b37},
	{0xd693, 0x8b38},
	{0xd694, 0x8b39},
	{0xd695, 0x8b3a},
	{0xd696, 0x8b3b},
	{0xd697, 0x8b3c},
	{0xd698, 0x8b3d},
	{0xd699, 0x8b3e},
	{0xd69a, 0x8b3f},
	{0xd69b, 0x8b40},
	{0xd69c, 0x8b41},
	{0xd69d, 0x8b42},
	{0xd69e, 0x8b43},
	{0xd69f, 0x8b44},
	{0xd6a0, 0x8b45},
	{0xd6a1, 0x5e27},
	{0xd6a2, 0x75c7},
	{0xd6a3, 0x90d1},
	{0xd6a4, 0x8bc1},
	{0xd6a5, 0x829d},
	{0xd6a6, 0x679d},
	{0xd6a7, 0x652f},
	{0xd6a8, 0x5431},
	{0xd6a9, 0x8718},
	{0xd6aa, 0x77e5},
	{0xd6ab, 0x80a2},
	{0xd6ac, 0x8102},
	{0xd6ad, 0x6c41},
	{0xd6ae, 0x4e4b},
	{0xd6af, 0x7ec7},
	{0xd6b0, 0x804c},
	{0xd6b1, 0x76f4},
	{0xd6b2, 0x690d},
	{0xd6b3, 0x6b96},
	{0xd6b4, 0x6267},
	{0xd6b5, 0x503c},
	{0xd6b6, 0x4f84},
	{0xd6b7, 0x5740},
	{0xd6b8, 0x6307},
	{0xd6b9, 0x6b62},
	{0xd6ba, 0x8dbe},
	{0xd6bb, 0x53ea},
	{0xd6bc, 0x65e8},
	{0xd6bd, 0x7eb8},
	{0xd6be, 0x5fd7},
	{0xd6bf, 0x631a},
	{0xd6c0, 0x63b7},
	{0xd6c1, 0x81f3},
	{0xd6c2, 0x81f4},
	{0xd6c3, 0x7f6e},
	{0xd6c4, 0x5e1c},
	{0xd6c5, 0x5cd9},
	{0xd6c6, 0x5236},
	{0xd6c7, 0x667a},
	{0xd6c8, 0x79e9},
	{0xd6c9, 0x7a1a},
	{0xd6ca, 0x8d28},
	{0xd6cb, 0x7099},
	{0xd6cc, 0x75d4},
	{0xd6cd, 0x6ede},
	{0xd6ce, 0x6cbb},
	{0xd6cf, 0x7a92},
	{0xd6d0, 0x4e2d},
	{0xd6d1, 0x76c5},
	{0xd6d2, 0x5fe0},
	{0xd6d3, 0x949f},
	{0xd6d4, 0x8877},
	{0xd6d5, 0x7ec8},
	{0xd6d6, 0x79cd},
	{0xd6d7, 0x80bf},
	{0xd6d8, 0x91cd},
	{0xd6d9, 0x4ef2},
	{0xd6da, 0x4f17},
	{0xd6db, 0x821f},
	{0xd6dc, 0x5468},
	{0xd6dd, 0x5dde},
	{0xd6de, 0x6d32},
	{0xd6df, 0x8bcc},
	{0xd6e0, 0x7ca5},
	{0xd6e1, 0x8f74},
	{0xd6e2, 0x8098},
	{0xd6e3, 0x5e1a},
	{0xd6e4, 0x5492},
	{0xd6e5, 0x76b1},
	{0xd6e6, 0x5b99},
	{0xd6e7, 0x663c},
	{0xd6e8, 0x9aa4},
	{0xd6e9, 0x73e0},
	{0xd6ea, 0x682a},
	{0xd6eb, 0x86db},
	{0xd6ec, 0x6731},
	{0xd6ed, 0x732a},
	{0xd6ee, 0x8bf8},
	{0xd6ef, 0x8bdb},
	{0xd6f0, 0x9010},
	{0xd6f1, 0x7af9},
	{0xd6f2, 0x70db},
	{0xd6f3, 0x716e},
	{0xd6f4, 0x62c4},
	{0xd6f5, 0x77a9},
	{0xd6f6, 0x5631},
	{0xd6f7, 0x4e3b},
	{0xd6f8, 0x8457},
	{0xd6f9, 0x67f1},
	{0xd6fa, 0x52a9},
	{0xd6fb, 0x86c0},
	{0xd6fc, 0x8d2e},
	{0xd6fd, 0x94f8},
	{0xd6fe, 0x7b51},
	{0xd740, 0x8b46},
	{0xd741, 0x8b47},
	{0xd742, 0x8b48},
	{0xd743, 0x8b49},
	{0xd744, 0x8b4a},
	{0xd745, 0x8b4b},
	{0xd746, 0x8b4c},
	{0xd747, 0x8b4d},
	{0xd748, 0x8b4e},
	{0xd749, 0x8b4f},
	{0xd74a, 0x8b50},
	{0xd74b, 0x8b51},
	{0xd74c, 0x8b52},
	{0xd74d, 0x8b53},
	{0xd74e, 0x8b54},
	{0xd74f, 0x8b55},
	{0xd750, 0x8b56},
	{0xd751, 0x8b57},
	{0xd752, 0x8b58},
	{0xd753, 0x8b59},
	{0xd754, 0x8b5a},
	{0xd755, 0x8b5b},
	{0xd756, 0x8b5c},
	{0xd757, 0x8b5d},
	{0xd758, 0x8b5e},
	{0xd759, 0x8b5f},
	{0xd75a, 0x8b60},
	{0xd75b, 0x8b61},
	{0xd75c, 0x8b62},
	{0xd75d, 0x8b63},
	{0xd75e, 0x8b64},
	{0xd75f, 0x8b65},
	{0xd760, 0x8b67},
	{0xd761, 0x8b68},
	{0xd762, 0x8b69},
	{0xd763, 0x8b6a},
	{0xd764, 0x8b6b},
	{0xd765, 0x8b6d},
	{0xd766, 0x8b6e},
	{0xd767, 0x8b6f},
	{0xd768, 0x8b70},
	{0xd769, 0x8b71},
	{0xd76a, 0x8b72},
	{0xd76b, 0x8b73},
	{0xd76c, 0x8b74},
	{0xd76d, 0x8b75},
	{0xd76e, 0x8b76},
	{0xd76f, 0x8b77},
	{0xd770, 0x8b78},
	{0xd771, 0x8b79},
	{0xd772, 0x8b7a},
	{0xd773, 0x8b7b},
	{0xd774, 0x8b7c},
	{0xd775, 0x8b7d},
	{0xd776, 0x8b7e},
	{0xd777, 0x8b7f},
	{0xd778, 0x8b80},
	{0xd779, 0x8b81},
	{0xd77a, 0x8b82},
	{0xd77b, 0x8b83},
	{0xd77c, 0x8b84},
	{0xd77d, 0x8b85},
	{0xd77e, 0x8b86},
	{0xd780, 0x8b87},
	{0xd781, 0x8b88},
	{0xd782, 0x8b89},
	{0xd783, 0x8b8a},
	{0xd784, 0x8b8b},
	{0xd785, 0x8b8c},
	{0xd786, 0x8b8d},
	{0xd787, 0x8b8e},
	{0xd788, 0x8b8f},
	{0xd789, 0x8b90},
	{0xd78a, 0x8b91},
	{0xd78b, 0x8b92},
	{0xd78c, 0x8b93},
	{0xd78d, 0x8b94},
	{0xd78e, 0x8b95},
	{0xd78f, 0x8b96},
	{0xd790, 0x8b97},
	{0xd791, 0x8b98},
	{0xd792, 0x8b99},
	{0xd793, 0x8b9a},
	{0xd794, 0x8b9b},
	{0xd795, 0x8b9c},
	{0xd796, 0x8b9d},
	{0xd797, 0x8b9e},
	{0xd798, 0x8b9f},
	{0xd799, 0x8bac},
	{0xd79a, 0x8bb1},
	{0xd79b, 0x8bbb},
	{0xd79c, 0x8bc7},
	{0xd79d, 0x8bd0},
	{0xd79e, 0x8bea},
	{0xd79f, 0x8c09},
	{0xd7a0, 0x8c1e},
	{0xd7a1, 0x4f4f},
	{0xd7a2, 0x6ce8},
	{0xd7a3, 0x795d},
	{0xd7a4, 0x9a7b},
	{0xd7a5, 0x6293},
	{0xd7a6, 0x722a},
	{0xd7a7, 0x62fd},
	{0xd7a8, 0x4e13},
	{0xd7a9, 0x7816},
	{0xd7aa, 0x8f6c},
	{0xd7ab, 0x64b0},
	{0xd7ac, 0x8d5a},
	{0xd7ad, 0x7bc6},
	{0xd7ae, 0x6869},
	{0xd7af, 0x5e84},
	{0xd7b0, 0x88c5},
	{0xd7b1, 0x5986},
	{0xd7b2, 0x649e},
	{0xd7b3, 0x58ee},
	{0xd7b4, 0x72b6},
	{0xd7b5, 0x690e},
	{0xd7b6, 0x9525},
	{0xd7b7, 0x8ffd},
	{0xd7b8, 0x8d58},
	{0xd7b9, 0x5760},
	{0xd7ba, 0x7f00},
	{0xd7bb, 0x8c06},
	{0xd7bc, 0x51c6},
	{0xd7bd, 0x6349},
	{0xd7be, 0x62d9},
	{0xd7bf, 0x5353},
	{0xd7c0, 0x684c},
	{0xd7c1, 0x7422},
	{0xd7c2, 0x8301},
	{0xd7c3, 0x914c},
	{0xd7c4, 0x5544},
	{0xd7c5, 0x7740},
	{0xd7c6, 0x707c},
	{0xd7c7, 0x6d4a},
	{0xd7c8, 0x5179},
	{0xd7c9, 0x54a8},
	{0xd7ca, 0x8d44},
	{0xd7cb, 0x59ff},
	{0xd7cc, 0x6ecb},
	{0xd7cd, 0x6dc4},
	{0xd7ce, 0x5b5c},
	{0xd7cf, 0x7d2b},
	{0xd7d0, 0x4ed4},
	{0xd7d1, 0x7c7d},
	{0xd7d2, 0x6ed3},
	{0xd7d3, 0x5b50},
	{0xd7d4, 0x81ea},
	{0xd7d5, 0x6e0d},
	{0xd7d6, 0x5b57},
	{0xd7d7, 0x9b03},
	{0xd7d8, 0x68d5},
	{0xd7d9, 0x8e2a},
	{0xd7da, 0x5b97},
	{0xd7db, 0x7efc},
	{0xd7dc, 0x603b},
	{0xd7dd, 0x7eb5},
	{0xd7de, 0x90b9},
	{0xd7df, 0x8d70},
	{0xd7e0, 0x594f},
	{0xd7e1, 0x63cd},
	{0xd7e2, 0x79df},
	{0xd7e3, 0x8db3},
	{0xd7e4, 0x5352},
	{0xd7e5, 0x65cf},
	{0xd7e6, 0x7956},
	{0xd7e7, 0x8bc5},
	{0xd7e8, 0x963b},
	{0xd7e9, 0x7ec4},
	{0xd7ea, 0x94bb},
	{0xd7eb, 0x7e82},
	{0xd7ec, 0x5634},
	{0xd7ed, 0x9189},
	{0xd7ee, 0x6700},
	{0xd7ef, 0x7f6a},
	{0xd7f0, 0x5c0a},
	{0xd7f1, 0x9075},
	{0xd7f2, 0x6628},
	{0xd7f3, 0x5de6},
	{0xd7f4, 0x4f50},
	{0xd7f5, 0x67de},
	{0xd7f6, 0x505a},
	{0xd7f7, 0x4f5c},
	{0xd7f8, 0x5750},
	{0xd7f9, 0x5ea7},
	{0xd840, 0x8c38},
	{0xd841, 0x8c39},
	{0xd842, 0x8c3a},
	{0xd843, 0x8c3b},
	{0xd844, 0x8c3c},
	{0xd845, 0x8c3d},
	{0xd846, 0x8c3e},
	{0xd847, 0x8c3f},
	{0xd848, 0x8c40},
	{0xd849, 0x8c42},
	{0xd84a, 0x8c43},
	{0xd84b, 0x8c44},
	{0xd84c, 0x8c45},
	{0xd84d, 0x8c48},
	{0xd84e, 0x8c4a},
	{0xd84f, 0x8c4b},
	{0xd850, 0x8c4d},
	{0xd851, 0x8c4e},
	{0xd852, 0x8c4f},
	{0xd853, 0x8c50},
	{0xd854, 0x8c51},
	{0xd855, 0x8c52},
	{0xd856, 0x8c53},
	{0xd857, 0x8c54},
	{0xd858, 0x8c56},
	{0xd859, 0x8c57},
	{0xd85a, 0x8c58},
	{0xd85b, 0x8c59},
	{0xd85c, 0x8c5b},
	{0xd85d, 0x8c5c},
	{0xd85e, 0x8c5d},
	{0xd85f, 0x8c5e},
	{0xd860, 0x8c5f},
	{0xd861, 0x8c60},
	{0xd862, 0x8c63},
	{0xd863, 0x8c64},
	{0xd864, 0x8c65},
	{0xd865, 0x8c66},
	{0xd866, 0x8c67},
	{0xd867, 0x8c68},
	{0xd868, 0x8c69},
	{0xd869, 0x8c6c},
	{0xd86a, 0x8c6d},
	{0xd86b, 0x8c6e},
	{0xd86c, 0x8c6f},
	{0xd86d, 0x8c70},
	{0xd86e, 0x8c71},
	{0xd86f, 0x8c72},
	{0xd870, 0x8c74},
	{0xd871, 0x8c75},
	{0xd872, 0x8c76},
	{0xd873, 0x8c77},
	{0xd874, 0x8c7b},
	{0xd875, 0x8c7c},
	{0xd876, 0x8c7d},
	{0xd877, 0x8c7e},
	{0xd878, 0x8c7f},
	{0xd879, 0x8c80},
	{0xd87a, 0x8c81},
	{0xd87b, 0x8c83},
	{0xd87c, 0x8c84},
	{0xd87d, 0x8c86},
	{0xd87e, 0x8c87},
	{0xd880, 0x8c88},
	{0xd881, 0x8c8b},
	{0xd882, 0x8c8d},
	{0xd883, 0x8c8e},
	{0xd884, 0x8c8f},
	{0xd885, 0x8c90},
	{0xd886, 0x8c91},
	{0xd887, 0x8c92},
	{0xd888, 0x8c93},
	{0xd889, 0x8c95},
	{0xd88a, 0x8c96},
	{0xd88b, 0x8c97},
	{0xd88c, 0x8c99},
	{0xd88d, 0x8c9a},
	{0xd88e, 0x8c9b},
	{0xd88f, 0x8c9c},
	{0xd890, 0x8c9d},
	{0xd891, 0x8c9e},
	{0xd892, 0x8c9f},
	{0xd893, 0x8ca0},
	{0xd894, 0x8ca1},
	{0xd895, 0x8ca2},
	{0xd896, 0x8ca3},
	{0xd897, 0x8ca4},
	{0xd898, 0x8ca5},
	{0xd899, 0x8ca6},
	{0xd89a, 0x8ca7},
	{0xd89b, 0x8ca8},
	{0xd89c, 0x8ca9},
	{0xd89d, 0x8caa},
	{0xd89e, 0x8cab},
	{0xd89f, 0x8cac},
	{0xd8a0, 0x8cad},
	{0xd8a1, 0x4e8d},
	{0xd8a2, 0x4e0c},
	{0xd8a3, 0x5140},
	{0xd8a4, 0x4e10},
	{0xd8a5, 0x5eff},
	{0xd8a6, 0x5345},
	{0xd8a7, 0x4e15},
	{0xd8a8, 0x4e98},
	{0xd8a9, 0x4e1e},
	{0xd8aa, 0x9b32},
	{0xd8ab, 0x5b6c},
	{0xd8ac, 0x5669},
	{0xd8ad, 0x4e28},
	{0xd8ae, 0x79ba},
	{0xd8af, 0x4e3f},
	{0xd8b0, 0x5315},
	{0xd8b1, 0x4e47},
	{0xd8b2, 0x592d},
	{0xd8b3, 0x723b},
	{0xd8b4, 0x536e},
	{0xd8b5, 0x6c10},
	{0xd8b6, 0x56df},
	{0xd8b7, 0x80e4},
	{0xd8b8, 0x9997},
	{0xd8b9, 0x6bd3},
	{0xd8ba, 0x777e},
	{0xd8bb, 0x9f17},
	{0xd8bc, 0x4e36},
	{0xd8bd, 0x4e9f},
	{0xd8be, 0x9f10},
	{0xd8bf, 0x4e5c},
	{0xd8c0, 0x4e69},
	{0xd8c1, 0x4e93},
	{0xd8c2, 0x8288},
	{0xd8c3, 0x5b5b},
	{0xd8c4, 0x556c},
	{0xd8c5, 0x560f},
	{0xd8c6, 0x4ec4},
	{0xd8c7, 0x538d},
	{0xd8c8, 0x539d},
	{0xd8c9, 0x53a3},
	{0xd8ca, 0x53a5},
	{0xd8cb, 0x53ae},
	{0xd8cc, 0x9765},
	{0xd8cd, 0x8d5d},
	{0xd8ce, 0x531a},
	{0xd8cf, 0x53f5},
	{0xd8d0, 0x5326},
	{0xd8d1, 0x532e},
	{0xd8d2, 0x533e},
	{0xd8d3, 0x8d5c},
	{0xd8d4, 0x5366},
	{0xd8d5, 0x5363},
	{0xd8d6, 0x5202},
	{0xd8d7, 0x5208},
	{0xd8d8, 0x520e},
	{0xd8d9, 0x522d},
	{0xd8da, 0x5233},
	{0xd8db, 0x523f},
	{0xd8dc, 0x5240},
	{0xd8dd, 0x524c},
	{0xd8de, 0x525e},
	{0xd8df, 0x5261},
	{0xd8e0, 0x525c},
	{0xd8e1, 0x84af},
	{0xd8e2, 0x527d},
	{0xd8e3, 0x5282},
	{0xd8e4, 0x5281},
	{0xd8e5, 0x5290},
	{0xd8e6, 0x5293},
	{0xd8e7, 0x5182},
	{0xd8e8, 0x7f54},
	{0xd8e9, 0x4ebb},
	{0xd8ea, 0x4ec3},
	{0xd8eb, 0x4ec9},
	{0xd8ec, 0x4ec2},
	{0xd8ed, 0x4ee8},
	{0xd8ee, 0x4ee1},
	{0xd8ef, 0x4eeb},
	{0xd8f0, 0x4ede},
	{0xd8f1, 0x4f1b},
	{0xd8f2, 0x4ef3},
	{0xd8f3, 0x4f22},
	{0xd8f4, 0x4f64},
	{0xd8f5, 0x4ef5},
	{0xd8f6, 0x4f25},
	{0xd8f7, 0x4f27},
	{0xd8f8, 0x4f09},
	{0xd8f9, 0x4f2b},
	{0xd8fa, 0x4f5e},
	{0xd8fb, 0x4f67},
	{0xd8fc, 0x6538},
	{0xd8fd, 0x4f5a},
	{0xd8fe, 0x4f5d},
	{0xd940, 0x8cae},
	{0xd941, 0x8caf},
	{0xd942, 0x8cb0},
	{0xd943, 0x8cb1},
	{0xd944, 0x8cb2},
	{0xd945, 0x8cb3},
	{0xd946, 0x8cb4},
	{0xd947, 0x8cb5},
	{0xd948, 0x8cb6},
	{0xd949, 0x8cb7},
	{0xd94a, 0x8cb8},
	{0xd94b, 0x8cb9},
	{0xd94c, 0x8cba},
	{0xd94d, 0x8cbb},
	{0xd94e, 0x8cbc},
	{0xd94f, 0x8cbd},
	{0xd950, 0x8cbe},
	{0xd951, 0x8cbf},
	{0xd952, 0x8cc0},
	{0xd953, 0x8cc1},
	{0xd954, 0x8cc2},
	{0xd955, 0x8cc3},
	{0xd956, 0x8cc4},
	{0xd957, 0x8cc5},
	{0xd958, 0x8cc6},
	{0xd959, 0x8cc7},
	{0xd95a, 0x8cc8},
	{0xd95b, 0x8cc9},
	{0xd95c, 0x8cca},
	{0xd95d, 0x8ccb},
	{0xd95e, 0x8ccc},
	{0xd95f, 0x8ccd},
	{0xd960, 0x8cce},
	{0xd961, 0x8ccf},
	{0xd962, 0x8cd0},
	{0xd963, 0x8cd1},
	{0xd964, 0x8cd2},
	{0xd965, 0x8cd3},
	{0xd966, 0x8cd4},
	{0xd967, 0x8cd5},
	{0xd968, 0x8cd6},
	{0xd969, 0x8cd7},
	{0xd96a, 0x8cd8},
	{0xd96b, 0x8cd9},
	{0xd96c, 0x8cda},
	{0xd96d, 0x8cdb},
	{0xd96e, 0x8cdc},
	{0xd96f, 0x8cdd},
	{0xd970, 0x8cde},
	{0xd971, 0x8cdf},
	{0xd972, 0x8ce0},
	{0xd973, 0x8ce1},
	{0xd974, 0x8ce2},
	{0xd975, 0x8ce3},
	{0xd976, 0x8ce4},
	{0xd977, 0x8ce5},
	{0xd978, 0x8ce6},
	{0xd979, 0x8ce7},
	{0xd97a, 0x8ce8},
	{0xd97b, 0x8ce9},
	{0xd97c, 0x8cea},
	{0xd97d, 0x8ceb},
	{0xd97e, 0x8cec},
	{0xd980, 0x8ced},
	{0xd981, 0x8cee},
	{0xd982, 0x8cef},
	{0xd983, 0x8cf0},
	{0xd984, 0x8cf1},
	{0xd985, 0x8cf2},
	{0xd986, 0x8cf3},
	{0xd987, 0x8cf4},
	{0xd988, 0x8cf5},
	{0xd989, 0x8cf6},
	{0xd98a, 0x8cf7},
	{0xd98b, 0x8cf8},
	{0xd98c, 0x8cf9},
	{0xd98d, 0x8cfa},
	{0xd98e, 0x8cfb},
	{0xd98f, 0x8cfc},
	{0xd990, 0x8cfd},
	{0xd991, 0x8cfe},
	{0xd992, 0x8cff},
	{0xd993, 0x8d00},
	{0xd994, 0x8d01},
	{0xd995, 0x8d02},
	{0xd996, 0x8d03},
	{0xd997, 0x8d04},
	{0xd998, 0x8d05},
	{0xd999, 0x8d06},
	{0xd99a, 0x8d07},
	{0xd99b, 0x8d08},
	{0xd99c, 0x8d09},
	{0xd99d, 0x8d0a},
	{0xd99e, 0x8d0b},
	{0xd99f, 0x8d0c},
	{0xd9a0, 0x8d0d},
	{0xd9a1, 0x4f5f},
	{0xd9a2, 0x4f57},
	{0xd9a3, 0x4f32},
	{0xd9a4, 0x4f3d},
	{0xd9a5, 0x4f76},
	{0xd9a6, 0x4f74},
	{0xd9a7, 0x4f91},
	{0xd9a8, 0x4f89},
	{0xd9a9, 0x4f83},
	{0xd9aa, 0x4f8f},
	{0xd9ab, 0x4f7e},
	{0xd9ac, 0x4f7b},
	{0xd9ad, 0x4faa},
	{0xd9ae, 0x4f7c},
	{0xd9af, 0x4fac},
	{0xd9b0, 0x4f94},
	{0xd9b1, 0x4fe6},
	{0xd9b2, 0x4fe8},
	{0xd9b3, 0x4fea},
	{0xd9b4, 0x4fc5},
	{0xd9b5, 0x4fda},
	{0xd9b6, 0x4fe3},
	{0xd9b7, 0x4fdc},
	{0xd9b8, 0x4fd1},
	{0xd9b9, 0x4fdf},
	{0xd9ba, 0x4ff8},
	{0xd9bb, 0x5029},
	{0xd9bc, 0x504c},
	{0xd9bd, 0x4ff3},
	{0xd9be, 0x502c},
	{0xd9bf, 0x500f},
	{0xd9c0, 0x502e},
	{0xd9c1, 0x502d},
	{0xd9c2, 0x4ffe},
	{0xd9c3, 0x501c},
	{0xd9c4, 0x500c},
	{0xd9c5, 0x5025},
	{0xd9c6, 0x5028},
	{0xd9c7, 0x507e},
	{0xd9c8, 0x5043},
	{0xd9c9, 0x5055},
	{0xd9ca, 0x5048},
	{0xd9cb, 0x504e},
	{0xd9cc, 0x506c},
	{0xd9cd, 0x507b},
	{0xd9ce, 0x50a5},
	{0xd9cf, 0x50a7},
	{0xd9d0, 0x50a9},
	{0xd9d1, 0x50ba},
	{0xd9d2, 0x50d6},
	{0xd9d3, 0x5106},
	{0xd9d4, 0x50ed},
	{0xd9d5, 0x50ec},
	{0xd9d6, 0x50e6},
	{0xd9d7, 0x50ee},
	{0xd9d8, 0x5107},
	{0xd9d9, 0x510b},
	{0xd9da, 0x4edd},
	{0xd9db, 0x6c3d},
	{0xd9dc, 0x4f58},
	{0xd9dd, 0x4f65},
	{0xd9de, 0x4fce},
	{0xd9df, 0x9fa0},
	{0xd9e0, 0x6c46},
	{0xd9e1, 0x7c74},
	{0xd9e2, 0x516e},
	{0xd9e3, 0x5dfd},
	{0xd9e4, 0x9ec9},
	{0xd9e5, 0x9998},
	{0xd9e6, 0x5181},
	{0xd9e7, 0x5914},
	{0xd9e8, 0x52f9},
	{0xd9e9, 0x530d},
	{0xd9ea, 0x8a07},
	{0xd9eb, 0x5310},
	{0xd9ec, 0x51eb},
	{0xd9ed, 0x5919},
	{0xd9ee, 0x5155},
	{0xd9ef, 0x4ea0},
	{0xd9f0, 0x5156},
	{0xd9f1, 0x4eb3},
	{0xd9f2, 0x886e},
	{0xd9f3, 0x88a4},
	{0xd9f4, 0x4eb5},
	{0xd9f5, 0x8114},
	{0xd9f6, 0x88d2},
	{0xd9f7, 0x7980},
	{0xd9f8, 0x5b34},
	{0xd9f9, 0x8803},
	{0xd9fa, 0x7fb8},
	{0xd9fb, 0x51ab},
	{0xd9fc, 0x51b1},
	{0xd9fd, 0x51bd},
	{0xd9fe, 0x51bc},
	{0xda40, 0x8d0e},
	{0xda41, 0x8d0f},
	{0xda42, 0x8d10},
	{0xda43, 0x8d11},
	{0xda44, 0x8d12},
	{0xda45, 0x8d13},
	{0xda46, 0x8d14},
	{0xda47, 0x8d15},
	{0xda48, 0x8d16},
	{0xda49, 0x8d17},
	{0xda4a, 0x8d18},
	{0xda4b, 0x8d19},
	{0xda4c, 0x8d1a},
	{0xda4d, 0x8d1b},
	{0xda4e, 0x8d1c},
	{0xda4f, 0x8d20},
	{0xda50, 0x8d51},
	{0xda51, 0x8d52},
	{0xda52, 0x8d57},
	{0xda53, 0x8d5f},
	{0xda54, 0x8d65},
	{0xda55, 0x8d68},
	{0xda56, 0x8d69},
	{0xda57, 0x8d6a},
	{0xda58, 0x8d6c},
	{0xda59, 0x8d6e},
	{0xda5a, 0x8d6f},
	{0xda5b, 0x8d71},
	{0xda5c, 0x8d72},
	{0xda5d, 0x8d78},
	{0xda5e, 0x8d79},
	{0xda5f, 0x8d7a},
	{0xda60, 0x8d7b},
	{0xda61, 0x8d7c},
	{0xda62, 0x8d7d},
	{0xda63, 0x8d7e},
	{0xda64, 0x8d7f},
	{0xda65, 0x8d80},
	{0xda66, 0x8d82},
	{0xda67, 0x8d83},
	{0xda68, 0x8d86},
	{0xda69, 0x8d87},
	{0xda6a, 0x8d88},
	{0xda6b, 0x8d89},
	{0xda6c, 0x8d8c},
	{0xda6d, 0x8d8d},
	{0xda6e, 0x8d8e},
	{0xda6f, 0x8d8f},
	{0xda70, 0x8d90},
	{0xda71, 0x8d92},
	{0xda72, 0x8d93},
	{0xda73, 0x8d95},
	{0xda74, 0x8d96},
	{0xda75, 0x8d97},
	{0xda76, 0x8d98},
	{0xda77, 0x8d99},
	{0xda78, 0x8d9a},
	{0xda79, 0x8d9b},
	{0xda7a, 0x8d9c},
	{0xda7b, 0x8d9d},
	{0xda7c, 0x8d9e},
	{0xda7d, 0x8da0},
	{0xda7e, 0x8da1},
	{0xda80, 0x8da2},
	{0xda81, 0x8da4},
	{0xda82, 0x8da5},
	{0xda83, 0x8da6},
	{0xda84, 0x8da7},
	{0xda85, 0x8da8},
	{0xda86, 0x8da9},
	{0xda87, 0x8daa},
	{0xda88, 0x8dab},
	{0xda89, 0x8dac},
	{0xda8a, 0x8dad},
	{0xda8b, 0x8dae},
	{0xda8c, 0x8daf},
	{0xda8d, 0x8db0},
	{0xda8e, 0x8db2},
	{0xda8f, 0x8db6},
	{0xda90, 0x8db7},
	{0xda91, 0x8db9},
	{0xda92, 0x8dbb},
	{0xda93, 0x8dbd},
	{0xda94, 0x8dc0},
	{0xda95, 0x8dc1},
	{0xda96, 0x8dc2},
	{0xda97, 0x8dc5},
	{0xda98, 0x8dc7},
	{0xda99, 0x8dc8},
	{0xda9a, 0x8dc9},
	{0xda9b, 0x8dca},
	{0xda9c, 0x8dcd},
	{0xda9d, 0x8dd0},
	{0xda9e, 0x8dd2},
	{0xda9f, 0x8dd3},
	{0xdaa0, 0x8dd4},
	{0xdaa1, 0x51c7},
	{0xdaa2, 0x5196},
	{0xdaa3, 0x51a2},
	{0xdaa4, 0x51a5},
	{0xdaa5, 0x8ba0},
	{0xdaa6, 0x8ba6},
	{0xdaa7, 0x8ba7},
	{0xdaa8, 0x8baa},
	{0xdaa9, 0x8bb4},
	{0xdaaa, 0x8bb5},
	{0xdaab, 0x8bb7},
	{0xdaac, 0x8bc2},
	{0xdaad, 0x8bc3},
	{0xdaae, 0x8bcb},
	{0xdaaf, 0x8bcf},
	{0xdab0, 0x8bce},
	{0xdab1, 0x8bd2},
	{0xdab2, 0x8bd3},
	{0xdab3, 0x8bd4},
	{0xdab4, 0x8bd6},
	{0xdab5, 0x8bd8},
	{0xdab6, 0x8bd9},
	{0xdab7, 0x8bdc},
	{0xdab8, 0x8bdf},
	{0xdab9, 0x8be0},
	{0xdaba, 0x8be4},
	{0xdabb, 0x8be8},
	{0xdabc, 0x8be9},
	{0xdabd, 0x8bee},
	{0xdabe, 0x8bf0},
	{0xdabf, 0x8bf3},
	{0xdac0, 0x8bf6},
	{0xdac1, 0x8bf9},
	{0xdac2, 0x8bfc},
	{0xdac3, 0x8bff},
	{0xdac4, 0x8c00},
	{0xdac5, 0x8c02},
	{0xdac6, 0x8c04},
	{0xdac7, 0x8c07},
	{0xdac8, 0x8c0c},
	{0xdac9, 0x8c0f},
	{0xdaca, 0x8c11},
	{0xdacb, 0x8c12},
	{0xdacc, 0x8c14},
	{0xdacd, 0x8c15},
	{0xdace, 0x8c16},
	{0xdacf, 0x8c19},
	{0xdad0, 0x8c1b},
	{0xdad1, 0x8c18},
	{0xdad2, 0x8c1d},
	{0xdad3, 0x8c1f},
	{0xdad4, 0x8c20},
	{0xdad5, 0x8c21},
	{0xdad6, 0x8c25},
	{0xdad7, 0x8c27},
	{0xdad8, 0x8c2a},
	{0xdad9, 0x8c2b},
	{0xdada, 0x8c2e},
	{0xdadb, 0x8c2f},
	{0xdadc, 0x8c32},
	{0xdadd, 0x8c33},
	{0xdade, 0x8c35},
	{0xdadf, 0x8c36},
	{0xdae0, 0x5369},
	{0xdae1, 0x537a},
	{0xdae2, 0x961d},
	{0xdae3, 0x9622},
	{0xdae4, 0x9621},
	{0xdae5, 0x9631},
	{0xdae6, 0x962a},
	{0xdae7, 0x963d},
	{0xdae8, 0x963c},
	{0xdae9, 0x9642},
	{0xdaea, 0x9649},
	{0xdaeb, 0x9654},
	{0xdaec, 0x965f},
	{0xdaed, 0x9667},
	{0xdaee, 0x966c},
	{0xdaef, 0x9672},
	{0xdaf0, 0x9674},
	{0xdaf1, 0x9688},
	{0xdaf2, 0x968d},
	{0xdaf3, 0x9697},
	{0xdaf4, 0x96b0},
	{0xdaf5, 0x9097},
	{0xdaf6, 0x909b},
	{0xdaf7, 0x909d},
	{0xdaf8, 0x9099},
	{0xdaf9, 0x90ac},
	{0xdafa, 0x90a1},
	{0xdafb, 0x90b4},
	{0xdafc, 0x90b3},
	{0xdafd, 0x90b6},
	{0xdafe, 0x90ba},
	{0xdb40, 0x8dd5},
	{0xdb41, 0x8dd8},
	{0xdb42, 0x8dd9},
	{0xdb43, 0x8ddc},
	{0xdb44, 0x8de0},
	{0xdb45, 0x8de1},
	{0xdb46, 0x8de2},
	{0xdb47, 0x8de5},
	{0xdb48, 0x8de6},
	{0xdb49, 0x8de7},
	{0xdb4a, 0x8de9},
	{0xdb4b, 0x8ded},
	{0xdb4c, 0x8dee},
	{0xdb4d, 0x8df0},
	{0xdb4e, 0x8df1},
	{0xdb4f, 0x8df2},
	{0xdb50, 0x8df4},
	{0xdb51, 0x8df6},
	{0xdb52, 0x8dfc},
	{0xdb53, 0x8dfe},
	{0xdb54, 0x8dff},
	{0xdb55, 0x8e00},
	{0xdb56, 0x8e01},
	{0xdb57, 0x8e02},
	{0xdb58, 0x8e03},
	{0xdb59, 0x8e04},
	{0xdb5a, 0x8e06},
	{0xdb5b, 0x8e07},
	{0xdb5c, 0x8e08},
	{0xdb5d, 0x8e0b},
	{0xdb5e, 0x8e0d},
	{0xdb5f, 0x8e0e},
	{0xdb60, 0x8e10},
	{0xdb61, 0x8e11},
	{0xdb62, 0x8e12},
	{0xdb63, 0x8e13},
	{0xdb64, 0x8e15},
	{0xdb65, 0x8e16},
	{0xdb66, 0x8e17},
	{0xdb67, 0x8e18},
	{0xdb68, 0x8e19},
	{0xdb69, 0x8e1a},
	{0xdb6a, 0x8e1b},
	{0xdb6b, 0x8e1c},
	{0xdb6c, 0x8e20},
	{0xdb6d, 0x8e21},
	{0xdb6e, 0x8e24},
	{0xdb6f, 0x8e25},
	{0xdb70, 0x8e26},
	{0xdb71, 0x8e27},
	{0xdb72, 0x8e28},
	{0xdb73, 0x8e2b},
	{0xdb74, 0x8e2d},
	{0xdb75, 0x8e30},
	{0xdb76, 0x8e32},
	{0xdb77, 0x8e33},
	{0xdb78, 0x8e34},
	{0xdb79, 0x8e36},
	{0xdb7a, 0x8e37},
	{0xdb7b, 0x8e38},
	{0xdb7c, 0x8e3b},
	{0xdb7d, 0x8e3c},
	{0xdb7e, 0x8e3e},
	{0xdb80, 0x8e3f},
	{0xdb81, 0x8e43},
	{0xdb82, 0x8e45},
	{0xdb83, 0x8e46},
	{0xdb84, 0x8e4c},
	{0xdb85, 0x8e4d},
	{0xdb86, 0x8e4e},
	{0xdb87, 0x8e4f},
	{0xdb88, 0x8e50},
	{0xdb89, 0x8e53},
	{0xdb8a, 0x8e54},
	{0xdb8b, 0x8e55},
	{0xdb8c, 0x8e56},
	{0xdb8d, 0x8e57},
	{0xdb8e, 0x8e58},
	{0xdb8f, 0x8e5a},
	{0xdb90, 0x8e5b},
	{0xdb91, 0x8e5c},
	{0xdb92, 0x8e5d},
	{0xdb93, 0x8e5e},
	{0xdb94, 0x8e5f},
	{0xdb95, 0x8e60},
	{0xdb96, 0x8e61},
	{0xdb97, 0x8e62},
	{0xdb98, 0x8e63},
	{0xdb99, 0x8e64},
	{0xdb9a, 0x8e65},
	{0xdb9b, 0x8e67},
	{0xdb9c, 0x8e68},
	{0xdb9d, 0x8e6a},
	{0xdb9e, 0x8e6b},
	{0xdb9f, 0x8e6e},
	{0xdba0, 0x8e71},
	{0xdba1, 0x90b8},
	{0xdba2, 0x90b0},
	{0xdba3, 0x90cf},
	{0xdba4, 0x90c5},
	{0xdba5, 0x90be},
	{0xdba6, 0x90d0},
	{0xdba7, 0x90c4},
	{0xdba8, 0x90c7},
	{0xdba9, 0x90d3},
	{0xdbaa, 0x90e6},
	{0xdbab, 0x90e2},
	{0xdbac, 0x90dc},
	{0xdbad, 0x90d7},
	{0xdbae, 0x90db},
	{0xdbaf, 0x90eb},
	{0xdbb0, 0x90ef},
	{0xdbb1, 0x90fe},
	{0xdbb2, 0x9104},
	{0xdbb3, 0x9122},
	{0xdbb4, 0x911e},
	{0xdbb5, 0x9123},
	{0xdbb6, 0x9131},
	{0xdbb7, 0x912f},
	{0xdbb8, 0x9139},
	{0xdbb9, 0x9143},
	{0xdbba, 0x9146},
	{0xdbbb, 0x520d},
	{0xdbbc, 0x5942},
	{0xdbbd, 0x52a2},
	{0xdbbe, 0x52ac},
	{0xdbbf, 0x52ad},
	{0xdbc0, 0x52be},
	{0xdbc1, 0x54ff},
	{0xdbc2, 0x52d0},
	{0xdbc3, 0x52d6},
	{0xdbc4, 0x52f0},
	{0xdbc5, 0x53df},
	{0xdbc6, 0x71ee},
	{0xdbc7, 0x77cd},
	{0xdbc8, 0x5ef4},
	{0xdbc9, 0x51f5},
	{0xdbca, 0x51fc},
	{0xdbcb, 0x9b2f},
	{0xdbcc, 0x53b6},
	{0xdbcd, 0x5f01},
	{0xdbce, 0x755a},
	{0xdbcf, 0x5def},
	{0xdbd0, 0x574c},
	{0xdbd1, 0x57a9},
	{0xdbd2, 0x57a1},
	{0xdbd3, 0x587e},
	{0xdbd4, 0x58bc},
	{0xdbd5, 0x58c5},
	{0xdbd6, 0x58d1},
	{0xdbd7, 0x5729},
	{0xdbd8, 0x572c},
	{0xdbd9, 0x572a},
	{0xdbda, 0x5733},
	{0xdbdb, 0x5739},
	{0xdbdc, 0x572e},
	{0xdbdd, 0x572f},
	{0xdbde, 0x575c},
	{0xdbdf, 0x573b},
	{0xdbe0, 0x5742},
	{0xdbe1, 0x5769},
	{0xdbe2, 0x5785},
	{0xdbe3, 0x576b},
	{0xdbe4, 0x5786},
	{0xdbe5, 0x577c},
	{0xdbe6, 0x577b},
	{0xdbe7, 0x5768},
	{0xdbe8, 0x576d},
	{0xdbe9, 0x5776},
	{0xdbea, 0x5773},
	{0xdbeb, 0x57ad},
	{0xdbec, 0x57a4},
	{0xdbed, 0x578c},
	{0xdbee, 0x57b2},
	{0xdbef, 0x57cf},
	{0xdbf0, 0x57a7},
	{0xdbf1, 0x57b4},
	{0xdbf2, 0x5793},
	{0xdbf3, 0x57a0},
	{0xdbf4, 0x57d5},
	{0xdbf5, 0x57d8},
	{0xdbf6, 0x57da},
	{0xdbf7, 0x57d9},
	{0xdbf8, 0x57d2},
	{0xdbf9, 0x57b8},
	{0xdbfa, 0x57f4},
	{0xdbfb, 0x57ef},
	{0xdbfc, 0x57f8},
	{0xdbfd, 0x57e4},
	{0xdbfe, 0x57dd},
	{0xdc40, 0x8e73},
	{0xdc41, 0x8e75},
	{0xdc42, 0x8e77},
	{0xdc43, 0x8e78},
	{0xdc44, 0x8e79},
	{0xdc45, 0x8e7a},
	{0xdc46, 0x8e7b},
	{0xdc47, 0x8e7d},
	{0xdc48, 0x8e7e},
	{0xdc49, 0x8e80},
	{0xdc4a, 0x8e82},
	{0xdc4b, 0x8e83},
	{0xdc4c, 0x8e84},
	{0xdc4d, 0x8e86},
	{0xdc4e, 0x8e88},
	{0xdc4f, 0x8e89},
	{0xdc50, 0x8e8a},
	{0xdc51, 0x8e8b},
	{0xdc52, 0x8e8c},
	{0xdc53, 0x8e8d},
	{0xdc54, 0x8e8e},
	{0xdc55, 0x8e91},
	{0xdc56, 0x8e92},
	{0xdc57, 0x8e93},
	{0xdc58, 0x8e95},
	{0xdc59, 0x8e96},
	{0xdc5a, 0x8e97},
	{0xdc5b, 0x8e98},
	{0xdc5c, 0x8e99},
	{0xdc5d, 0x8e9a},
	{0xdc5e, 0x8e9b},
	{0xdc5f, 0x8e9d},
	{0xdc60, 0x8e9f},
	{0xdc61, 0x8ea0},
	{0xdc62, 0x8ea1},
	{0xdc63, 0x8ea2},
	{0xdc64, 0x8ea3},
	{0xdc65, 0x8ea4},
	{0xdc66, 0x8ea5},
	{0xdc67, 0x8ea6},
	{0xdc68, 0x8ea7},
	{0xdc69, 0x8ea8},
	{0xdc6a, 0x8ea9},
	{0xdc6b, 0x8eaa},
	{0xdc6c, 0x8ead},
	{0xdc6d, 0x8eae},
	{0xdc6e, 0x8eb0},
	{0xdc6f, 0x8eb1},
	{0xdc70, 0x8eb3},
	{0xdc71, 0x8eb4},
	{0xdc72, 0x8eb5},
	{0xdc73, 0x8eb6},
	{0xdc74, 0x8eb7},
	{0xdc75, 0x8eb8},
	{0xdc76, 0x8eb9},
	{0xdc77, 0x8ebb},
	{0xdc78, 0x8ebc},
	{0xdc79, 0x8ebd},
	{0xdc7a, 0x8ebe},
	{0xdc7b, 0x8ebf},
	{0xdc7c, 0x8ec0},
	{0xdc7d, 0x8ec1},
	{0xdc7e, 0x8ec2},
	{0xdc80, 0x8ec3},
	{0xdc81, 0x8ec4},
	{0xdc82, 0x8ec5},
	{0xdc83, 0x8ec6},
	{0xdc84, 0x8ec7},
	{0xdc85, 0x8ec8},
	{0xdc86, 0x8ec9},
	{0xdc87, 0x8eca},
	{0xdc88, 0x8ecb},
	{0xdc89, 0x8ecc},
	{0xdc8a, 0x8ecd},
	{0xdc8b, 0x8ecf},
	{0xdc8c, 0x8ed0},
	{0xdc8d, 0x8ed1},
	{0xdc8e, 0x8ed2},
	{0xdc8f, 0x8ed3},
	{0xdc90, 0x8ed4},
	{0xdc91, 0x8ed5},
	{0xdc92, 0x8ed6},
	{0xdc93, 0x8ed7},
	{0xdc94, 0x8ed8},
	{0xdc95, 0x8ed9},
	{0xdc96, 0x8eda},
	{0xdc97, 0x8edb},
	{0xdc98, 0x8edc},
	{0xdc99, 0x8edd},
	{0xdc9a, 0x8ede},
	{0xdc9b, 0x8edf},
	{0xdc9c, 0x8ee0},
	{0xdc9d, 0x8ee1},
	{0xdc9e, 0x8ee2},
	{0xdc9f, 0x8ee3},
	{0xdca0, 0x8ee4},
	{0xdca1, 0x580b},
	{0xdca2, 0x580d},
	{0xdca3, 0x57fd},
	{0xdca4, 0x57ed},
	{0xdca5, 0x5800},
	{0xdca6, 0x581e},
	{0xdca7, 0x5819},
	{0xdca8, 0x5844},
	{0xdca9, 0x5820},
	{0xdcaa, 0x5865},
	{0xdcab, 0x586c},
	{0xdcac, 0x5881},
	{0xdcad, 0x5889},
	{0xdcae, 0x589a},
	{0xdcaf, 0x5880},
	{0xdcb0, 0x99a8},
	{0xdcb1, 0x9f19},
	{0xdcb2, 0x61ff},
	{0xdcb3, 0x8279},
	{0xdcb4, 0x827d},
	{0xdcb5, 0x827f},
	{0xdcb6, 0x828f},
	{0xdcb7, 0x828a},
	{0xdcb8, 0x82a8},
	{0xdcb9, 0x8284},
	{0xdcba, 0x828e},
	{0xdcbb, 0x8291},
	{0xdcbc, 0x8297},
	{0xdcbd, 0x8299},
	{0xdcbe, 0x82ab},
	{0xdcbf, 0x82b8},
	{0xdcc0, 0x82be},
	{0xdcc1, 0x82b0},
	{0xdcc2, 0x82c8},
	{0xdcc3, 0x82ca},
	{0xdcc4, 0x82e3},
	{0xdcc5, 0x8298},
	{0xdcc6, 0x82b7},
	{0xdcc7, 0x82ae},
	{0xdcc8, 0x82cb},
	{0xdcc9, 0x82cc},
	{0xdcca, 0x82c1},
	{0xdccb, 0x82a9},
	{0xdccc, 0x82b4},
	{0xdccd, 0x82a1},
	{0xdcce, 0x82aa},
	{0xdccf, 0x829f},
	{0xdcd0, 0x82c4},
	{0xdcd1, 0x82ce},
	{0xdcd2, 0x82a4},
	{0xdcd3, 0x82e1},
	{0xdcd4, 0x8309},
	{0xdcd5, 0x82f7},
	{0xdcd6, 0x82e4},
	{0xdcd7, 0x830f},
	{0xdcd8, 0x8307},
	{0xdcd9, 0x82dc},
	{0xdcda, 0x82f4},
	{0xdcdb, 0x82d2},
	{0xdcdc, 0x82d8},
	{0xdcdd, 0x830c},
	{0xdcde, 0x82fb},
	{0xdcdf, 0x82d3},
	{0xdce0, 0x8311},
	{0xdce1, 0x831a},
	{0xdce2, 0x8306},
	{0xdce3, 0x8314},
	{0xdce4, 0x8315},
	{0xdce5, 0x82e0},
	{0xdce6, 0x82d5},
	{0xdce7, 0x831c},
	{0xdce8, 0x8351},
	{0xdce9, 0x835b},
	{0xdcea, 0x835c},
	{0xdceb, 0x8308},
	{0xdcec, 0x8392},
	{0xdced, 0x833c},
	{0xdcee, 0x8334},
	{0xdcef, 0x8331},
	{0xdcf0, 0x839b},
	{0xdcf1, 0x835e},
	{0xdcf2, 0x832f},
	{0xdcf3, 0x834f},
	{0xdcf4, 0x8347},
	{0xdcf5, 0x8343},
	{0xdcf6, 0x835f},
	{0xdcf7, 0x8340},
	{0xdcf8, 0x8317},
	{0xdcf9, 0x8360},
	{0xdcfa, 0x832d},
	{0xdcfb, 0x833a},
	{0xdcfc, 0x8333},
	{0xdcfd, 0x8366},
	{0xdcfe, 0x8365},
	{0xdd40, 0x8ee5},
	{0xdd41, 0x8ee6},
	{0xdd42, 0x8ee7},
	{0xdd43, 0x8ee8},
	{0xdd44, 0x8ee9},
	{0xdd45, 0x8eea},
	{0xdd46, 0x8eeb},
	{0xdd47, 0x8eec},
	{0xdd48, 0x8eed},
	{0xdd49, 0x8eee},
	{0xdd4a, 0x8eef},
	{0xdd4b, 0x8ef0},
	{0xdd4c, 0x8ef1},
	{0xdd4d, 0x8ef2},
	{0xdd4e, 0x8ef3},
	{0xdd4f, 0x8ef4},
	{0xdd50, 0x8ef5},
	{0xdd51, 0x8ef6},
	{0xdd52, 0x8ef7},
	{0xdd53, 0x8ef8},
	{0xdd54, 0x8ef9},
	{0xdd55, 0x8efa},
	{0xdd56, 0x8efb},
	{0xdd57, 0x8efc},
	{0xdd58, 0x8efd},
	{0xdd59, 0x8efe},
	{0xdd5a, 0x8eff},
	{0xdd5b, 0x8f00},
	{0xdd5c, 0x8f01},
	{0xdd5d, 0x8f02},
	{0xdd5e, 0x8f03},
	{0xdd5f, 0x8f04},
	{0xdd60, 0x8f05},
	{0xdd61, 0x8f06},
	{0xdd62, 0x8f07},
	{0xdd63, 0x8f08},
	{0xdd64, 0x8f09},
	{0xdd65, 0x8f0a},
	{0xdd66, 0x8f0b},
	{0xdd67, 0x8f0c},
	{0xdd68, 0x8f0d},
	{0xdd69, 0x8f0e},
	{0xdd6a, 0x8f0f},
	{0xdd6b, 0x8f10},
	{0xdd6c, 0x8f11},
	{0xdd6d, 0x8f12},
	{0xdd6e, 0x8f13},
	{0xdd6f, 0x8f14},
	{0xdd70, 0x8f15},
	{0xdd71, 0x8f16},
	{0xdd72, 0x8f17},
	{0xdd73, 0x8f18},
	{0xdd74, 0x8f19},
	{0xdd75, 0x8f1a},
	{0xdd76, 0x8f1b},
	{0xdd77, 0x8f1c},
	{0xdd78, 0x8f1d},
	{0xdd79, 0x8f1e},
	{0xdd7a, 0x8f1f},
	{0xdd7b, 0x8f20},
	{0xdd7c, 0x8f21},
	{0xdd7d, 0x8f22},
	{0xdd7e, 0x8f23},
	{0xdd80, 0x8f24},
	{0xdd81, 0x8f25},
	{0xdd82, 0x8f26},
	{0xdd83, 0x8f27},
	{0xdd84, 0x8f28},
	{0xdd85, 0x8f29},
	{0xdd86, 0x8f2a},
	{0xdd87, 0x8f2b},
	{0xdd88, 0x8f2c},
	{0xdd89, 0x8f2d},
	{0xdd8a, 0x8f2e},
	{0xdd8b, 0x8f2f},
	{0xdd8c, 0x8f30},
	{0xdd8d, 0x8f31},
	{0xdd8e, 0x8f32},
	{0xdd8f, 0x8f33},
	{0xdd90, 0x8f34},
	{0xdd91, 0x8f35},
	{0xdd92, 0x8f36},
	{0xdd93, 0x8f37},
	{0xdd94, 0x8f38},
	{0xdd95, 0x8f39},
	{0xdd96, 0x8f3a},
	{0xdd97, 0x8f3b},
	{0xdd98, 0x8f3c},
	{0xdd99, 0x8f3d},
	{0xdd9a, 0x8f3e},
	{0xdd9b, 0x8f3f},
	{0xdd9c, 0x8f40},
	{0xdd9d, 0x8f41},
	{0xdd9e, 0x8f42},
	{0xdd9f, 0x8f43},
	{0xdda0, 0x8f44},
	{0xdda1, 0x8368},
	{0xdda2, 0x831b},
	{0xdda3, 0x8369},
	{0xdda4, 0x836c},
	{0xdda5, 0x836a},
	{0xdda6, 0x836d},
	{0xdda7, 0x836e},
	{0xdda8, 0x83b0},
	{0xdda9, 0x8378},
	{0xddaa, 0x83b3},
	{0xddab, 0x83b4},
	{0xddac, 0x83a0},
	{0xddad, 0x83aa},
	{0xddae, 0x8393},
	{0xddaf, 0x839c},
	{0xddb0, 0x8385},
	{0xddb1, 0x837c},
	{0xddb2, 0x83b6},
	{0xddb3, 0x83a9},
	{0xddb4, 0x837d},
	{0xddb5, 0x83b8},
	{0xddb6, 0x837b},
	{0xddb7, 0x8398},
	{0xddb8, 0x839e},
	{0xddb9, 0x83a8},
	{0xddba, 0x83ba},
	{0xddbb, 0x83bc},
	{0xddbc, 0x83c1},
	{0xddbd, 0x8401},
	{0xddbe, 0x83e5},
	{0xddbf, 0x83d8},
	{0xddc0, 0x5807},
	{0xddc1, 0x8418},
	{0xddc2, 0x840b},
	{0xddc3, 0x83dd},
	{0xddc4, 0x83fd},
	{0xddc5, 0x83d6},
	{0xddc6, 0x841c},
	{0xddc7, 0x8438},
	{0xddc8, 0x8411},
	{0xddc9, 0x8406},
	{0xddca, 0x83d4},
	{0xddcb, 0x83df},
	{0xddcc, 0x840f},
	{0xddcd, 0x8403},
	{0xddce, 0x83f8},
	{0xddcf, 0x83f9},
	{0xddd0, 0x83ea},
	{0xddd1, 0x83c5},
	{0xddd2, 0x83c0},
	{0xddd3, 0x8426},
	{0xddd4, 0x83f0},
	{0xddd5, 0x83e1},
	{0xddd6, 0x845c},
	{0xddd7, 0x8451},
	{0xddd8, 0x845a},
	{0xddd9, 0x8459},
	{0xddda, 0x8473},
	{0xdddb, 0x8487},
	{0xdddc, 0x8488},
	{0xdddd, 0x847a},
	{0xddde, 0x8489},
	{0xdddf, 0x8478},
	{0xdde0, 0x843c},
	{0xdde1, 0x8446},
	{0xdde2, 0x8469},
	{0xdde3, 0x8476},
	{0xdde4, 0x848c},
	{0xdde5, 0x848e},
	{0xdde6, 0x8431},
	{0xdde7, 0x846d},
	{0xdde8, 0x84c1},
	{0xdde9, 0x84cd},
	{0xddea, 0x84d0},
	{0xddeb, 0x84e6},
	{0xddec, 0x84bd},
	{0xdded, 0x84d3},
	{0xddee, 0x84ca},
	{0xddef, 0x84bf},
	{0xddf0, 0x84ba},
	{0xddf1, 0x84e0},
	{0xddf2, 0x84a1},
	{0xddf3, 0x84b9},
	{0xddf4, 0x84b4},
	{0xddf5, 0x8497},
	{0xddf6, 0x84e5},
	{0xddf7, 0x84e3},
	{0xddf8, 0x850c},
	{0xddf9, 0x750d},
	{0xddfa, 0x8538},
	{0xddfb, 0x84f0},
	{0xddfc, 0x8539},
	{0xddfd, 0x851f},
	{0xddfe, 0x853a},
	{0xde40, 0x8f45},
	{0xde41, 0x8f46},
	{0xde42, 0x8f47},
	{0xde43, 0x8f48},
	{0xde44, 0x8f49},
	{0xde45, 0x8f4a},
	{0xde46, 0x8f4b},
	{0xde47, 0x8f4c},
	{0xde48, 0x8f4d},
	{0xde49, 0x8f4e},
	{0xde4a, 0x8f4f},
	{0xde4b, 0x8f50},
	{0xde4c, 0x8f51},
	{0xde4d, 0x8f52},
	{0xde4e, 0x8f53},
	{0xde4f, 0x8f54},
	{0xde50, 0x8f55},
	{0xde51, 0x8f56},
	{0xde52, 0x8f57},
	{0xde53, 0x8f58},
	{0xde54, 0x8f59},
	{0xde55, 0x8f5a},
	{0xde56, 0x8f5b},
	{0xde57, 0x8f5c},
	{0xde58, 0x8f5d},
	{0xde59, 0x8f5e},
	{0xde5a, 0x8f5f},
	{0xde5b, 0x8f60},
	{0xde5c, 0x8f61},
	{0xde5d, 0x8f62},
	{0xde5e, 0x8f63},
	{0xde5f, 0x8f64},
	{0xde60, 0x8f65},
	{0xde61, 0x8f6a},
	{0xde62, 0x8f80},
	{0xde63, 0x8f8c},
	{0xde64, 0x8f92},
	{0xde65, 0x8f9d},
	{0xde66, 0x8fa0},
	{0xde67, 0x8fa1},
	{0xde68, 0x8fa2},
	{0xde69, 0x8fa4},
	{0xde6a, 0x8fa5},
	{0xde6b, 0x8fa6},
	{0xde6c, 0x8fa7},
	{0xde6d, 0x8faa},
	{0xde6e, 0x8fac},
	{0xde6f, 0x8fad},
	{0xde70, 0x8fae},
	{0xde71, 0x8faf},
	{0xde72, 0x8fb2},
	{0xde73, 0x8fb3},
	{0xde74, 0x8fb4},
	{0xde75, 0x8fb5},
	{0xde76, 0x8fb7},
	{0xde77, 0x8fb8},
	{0xde78, 0x8fba},
	{0xde79, 0x8fbb},
	{0xde7a, 0x8fbc},
	{0xde7b, 0x8fbf},
	{0xde7c, 0x8fc0},
	{0xde7d, 0x8fc3},
	{0xde7e, 0x8fc6},
	{0xde80, 0x8fc9},
	{0xde81, 0x8fca},
	{0xde82, 0x8fcb},
	{0xde83, 0x8fcc},
	{0xde84, 0x8fcd},
	{0xde85, 0x8fcf},
	{0xde86, 0x8fd2},
	{0xde87, 0x8fd6},
	{0xde88, 0x8fd7},
	{0xde89, 0x8fda},
	{0xde8a, 0x8fe0},
	{0xde8b, 0x8fe1},
	{0xde8c, 0x8fe3},
	{0xde8d, 0x8fe7},
	{0xde8e, 0x8fec},
	{0xde8f, 0x8fef},
	{0xde90, 0x8ff1},
	{0xde91, 0x8ff2},
	{0xde92, 0x8ff4},
	{0xde93, 0x8ff5},
	{0xde94, 0x8ff6},
	{0xde95, 0x8ffa},
	{0xde96, 0x8ffb},
	{0xde97, 0x8ffc},
	{0xde98, 0x8ffe},
	{0xde99, 0x8fff},
	{0xde9a, 0x9007},
	{0xde9b, 0x9008},
	{0xde9c, 0x900c},
	{0xde9d, 0x900e},
	{0xde9e, 0x9013},
	{0xde9f, 0x9015},
	{0xdea0, 0x9018},
	{0xdea1, 0x8556},
	{0xdea2, 0x853b},
	{0xdea3, 0x84ff},
	{0xdea4, 0x84fc},
	{0xdea5, 0x8559},
	{0xdea6, 0x8548},
	{0xdea7, 0x8568},
	{0xdea8, 0x8564},
	{0xdea9, 0x855e},
	{0xdeaa, 0x857a},
	{0xdeab, 0x77a2},
	{0xdeac, 0x8543},
	{0xdead, 0x8572},
	{0xdeae, 0x857b},
	{0xdeaf, 0x85a4},
	{0xdeb0, 0x85a8},
	{0xdeb1, 0x8587},
	{0xdeb2, 0x858f},
	{0xdeb3, 0x8579},
	{0xdeb4, 0x85ae},
	{0xdeb5, 0x859c},
	{0xdeb6, 0x8585},
	{0xdeb7, 0x85b9},
	{0xdeb8, 0x85b7},
	{0xdeb9, 0x85b0},
	{0xdeba, 0x85d3},
	{0xdebb, 0x85c1},
	{0xdebc, 0x85dc},
	{0xdebd, 0x85ff},
	{0xdebe, 0x8627},
	{0xdebf, 0x8605},
	{0xdec0, 0x8629},
	{0xdec1, 0x8616},
	{0xdec2, 0x863c},
	{0xdec3, 0x5efe},
	{0xdec4, 0x5f08},
	{0xdec5, 0x593c},
	{0xdec6, 0x5941},
	{0xdec7, 0x8037},
	{0xdec8, 0x5955},
	{0xdec9, 0x595a},
	{0xdeca, 0x5958},
	{0xdecb, 0x530f},
	{0xdecc, 0x5c22},
	{0xdecd, 0x5c25},
	{0xdece, 0x5c2c},
	{0xdecf, 0x5c34},
	{0xded0, 0x624c},
	{0xded1, 0x626a},
	{0xded2, 0x629f},
	{0xded3, 0x62bb},
	{0xded4, 0x62ca},
	{0xded5, 0x62da},
	{0xded6, 0x62d7},
	{0xded7, 0x62ee},
	{0xded8, 0x6322},
	{0xded9, 0x62f6},
	{0xdeda, 0x6339},
	{0xdedb, 0x634b},
	{0xdedc, 0x6343},
	{0xdedd, 0x63ad},
	{0xdede, 0x63f6},
	{0xdedf, 0x6371},
	{0xdee0, 0x637a},
	{0xdee1, 0x638e},
	{0xdee2, 0x63b4},
	{0xdee3, 0x636d},
	{0xdee4, 0x63ac},
	{0xdee5, 0x638a},
	{0xdee6, 0x6369},
	{0xdee7, 0x63ae},
	{0xdee8, 0x63bc},
	{0xdee9, 0x63f2},
	{0xdeea, 0x63f8},
	{0xdeeb, 0x63e0},
	{0xdeec, 0x63ff},
	{0xdeed, 0x63c4},
	{0xdeee, 0x63de},
	{0xdeef, 0x63ce},
	{0xdef0, 0x6452},
	{0xdef1, 0x63c6},
	{0xdef2, 0x63be},
	{0xdef3, 0x6445},
	{0xdef4, 0x6441},
	{0xdef5, 0x640b},
	{0xdef6, 0x641b},
	{0xdef7, 0x6420},
	{0xdef8, 0x640c},
	{0xdef9, 0x6426},
	{0xdefa, 0x6421},
	{0xdefb, 0x645e},
	{0xdefc, 0x6484},
	{0xdefd, 0x646d},
	{0xdefe, 0x6496},
	{0xdf40, 0x9019},
	{0xdf41, 0x901c},
	{0xdf42, 0x9023},
	{0xdf43, 0x9024},
	{0xdf44, 0x9025},
	{0xdf45, 0x9027},
	{0xdf46, 0x9028},
	{0xdf47, 0x9029},
	{0xdf48, 0x902a},
	{0xdf49, 0x902b},
	{0xdf4a, 0x902c},
	{0xdf4b, 0x9030},
	{0xdf4c, 0x9031},
	{0xdf4d, 0x9032},
	{0xdf4e, 0x9033},
	{0xdf4f, 0x9034},
	{0xdf50, 0x9037},
	{0xdf51, 0x9039},
	{0xdf52, 0x903a},
	{0xdf53, 0x903d},
	{0xdf54, 0x903f},
	{0xdf55, 0x9040},
	{0xdf56, 0x9043},
	{0xdf57, 0x9045},
	{0xdf58, 0x9046},
	{0xdf59, 0x9048},
	{0xdf5a, 0x9049},
	{0xdf5b, 0x904a},
	{0xdf5c, 0x904b},
	{0xdf5d, 0x904c},
	{0xdf5e, 0x904e},
	{0xdf5f, 0x9054},
	{0xdf60, 0x9055},
	{0xdf61, 0x9056},
	{0xdf62, 0x9059},
	{0xdf63, 0x905a},
	{0xdf64, 0x905c},
	{0xdf65, 0x905d},
	{0xdf66, 0x905e},
	{0xdf67, 0x905f},
	{0xdf68, 0x9060},
	{0xdf69, 0x9061},
	{0xdf6a, 0x9064},
	{0xdf6b, 0x9066},
	{0xdf6c, 0x9067},
	{0xdf6d, 0x9069},
	{0xdf6e, 0x906a},
	{0xdf6f, 0x906b},
	{0xdf70, 0x906c},
	{0xdf71, 0x906f},
	{0xdf72, 0x9070},
	{0xdf73, 0x9071},
	{0xdf74, 0x9072},
	{0xdf75, 0x9073},
	{0xdf76, 0x9076},
	{0xdf77, 0x9077},
	{0xdf78, 0x9078},
	{0xdf79, 0x9079},
	{0xdf7a, 0x907a},
	{0xdf7b, 0x907b},
	{0xdf7c, 0x907c},
	{0xdf7d, 0x907e},
	{0xdf7e, 0x9081},
	{0xdf80, 0x9084},
	{0xdf81, 0x9085},
	{0xdf82, 0x9086},
	{0xdf83, 0x9087},
	{0xdf84, 0x9089},
	{0xdf85, 0x908a},
	{0xdf86, 0x908c},
	{0xdf87, 0x908d},
	{0xdf88, 0x908e},
	{0xdf89, 0x908f},
	{0xdf8a, 0x9090},
	{0xdf8b, 0x9092},
	{0xdf8c, 0x9094},
	{0xdf8d, 0x9096},
	{0xdf8e, 0x9098},
	{0xdf8f, 0x909a},
	{0xdf90, 0x909c},
	{0xdf91, 0x909e},
	{0xdf92, 0x909f},
	{0xdf93, 0x90a0},
	{0xdf94, 0x90a4},
	{0xdf95, 0x90a5},
	{0xdf96, 0x90a7},
	{0xdf97, 0x90a8},
	{0xdf98, 0x90a9},
	{0xdf99, 0x90ab},
	{0xdf9a, 0x90ad},
	{0xdf9b, 0x90b2},
	{0xdf9c, 0x90b7},
	{0xdf9d, 0x90bc},
	{0xdf9e, 0x90bd},
	{0xdf9f, 0x90bf},
	{0xdfa0, 0x90c0},
	{0xdfa1, 0x647a},
	{0xdfa2, 0x64b7},
	{0xdfa3, 0x64b8},
	{0xdfa4, 0x6499},
	{0xdfa5, 0x64ba},
	{0xdfa6, 0x64c0},
	{0xdfa7, 0x64d0},
	{0xdfa8, 0x64d7},
	{0xdfa9, 0x64e4},
	{0xdfaa, 0x64e2},
	{0xdfab, 0x6509},
	{0xdfac, 0x6525},
	{0xdfad, 0x652e},
	{0xdfae, 0x5f0b},
	{0xdfaf, 0x5fd2},
	{0xdfb0, 0x7519},
	{0xdfb1, 0x5f11},
	{0xdfb2, 0x535f},
	{0xdfb3, 0x53f1},
	{0xdfb4, 0x53fd},
	{0xdfb5, 0x53e9},
	{0xdfb6, 0x53e8},
	{0xdfb7, 0x53fb},
	{0xdfb8, 0x5412},
	{0xdfb9, 0x5416},
	{0xdfba, 0x5406},
	{0xdfbb, 0x544b},
	{0xdfbc, 0x5452},
	{0xdfbd, 0x5453},
	{0xdfbe, 0x5454},
	{0xdfbf, 0x5456},
	{0xdfc0, 0x5443},
	{0xdfc1, 0x5421},
	{0xdfc2, 0x5457},
	{0xdfc3, 0x5459},
	{0xdfc4, 0x5423},
	{0xdfc5, 0x5432},
	{0xdfc6, 0x5482},
	{0xdfc7, 0x5494},
	{0xdfc8, 0x5477},
	{0xdfc9, 0x5471},
	{0xdfca, 0x5464},
	{0xdfcb, 0x549a},
	{0xdfcc, 0x549b},
	{0xdfcd, 0x5484},
	{0xdfce, 0x5476},
	{0xdfcf, 0x5466},
	{0xdfd0, 0x549d},
	{0xdfd1, 0x54d0},
	{0xdfd2, 0x54ad},
	{0xdfd3, 0x54c2},
	{0xdfd4, 0x54b4},
	{0xdfd5, 0x54d2},
	{0xdfd6, 0x54a7},
	{0xdfd7, 0x54a6},
	{0xdfd8, 0x54d3},
	{0xdfd9, 0x54d4},
	{0xdfda, 0x5472},
	{0xdfdb, 0x54a3},
	{0xdfdc, 0x54d5},
	{0xdfdd, 0x54bb},
	{0xdfde, 0x54bf},
	{0xdfdf, 0x54cc},
	{0xdfe0, 0x54d9},
	{0xdfe1, 0x54da},
	{0xdfe2, 0x54dc},
	{0xdfe3, 0x54a9},
	{0xdfe4, 0x54aa},
	{0xdfe5, 0x54a4},
	{0xdfe6, 0x54dd},
	{0xdfe7, 0x54cf},
	{0xdfe8, 0x54de},
	{0xdfe9, 0x551b},
	{0xdfea, 0x54e7},
	{0xdfeb, 0x5520},
	{0xdfec, 0x54fd},
	{0xdfed, 0x5514},
	{0xdfee, 0x54f3},
	{0xdfef, 0x5522},
	{0xdff0, 0x5523},
	{0xdff1, 0x550f},
	{0xdff2, 0x5511},
	{0xdff3, 0x5527},
	{0xdff4, 0x552a},
	{0xdff5, 0x5567},
	{0xdff6, 0x558f},
	{0xdff7, 0x55b5},
	{0xdff8, 0x5549},
	{0xdff9, 0x556d},
	{0xdffa, 0x5541},
	{0xdffb, 0x5555},
	{0xdffc, 0x553f},
	{0xdffd, 0x5550},
	{0xdffe, 0x553c},
	{0xe040, 0x90c2},
	{0xe041, 0x90c3},
	{0xe042, 0x90c6},
	{0xe043, 0x90c8},
	{0xe044, 0x90c9},
	{0xe045, 0x90cb},
	{0xe046, 0x90cc},
	{0xe047, 0x90cd},
	{0xe048, 0x90d2},
	{0xe049, 0x90d4},
	{0xe04a, 0x90d5},
	{0xe04b, 0x90d6},
	{0xe04c, 0x90d8},
	{0xe04d, 0x90d9},
	{0xe04e, 0x90da},
	{0xe04f, 0x90de},
	{0xe050, 0x90df},
	{0xe051, 0x90e0},
	{0xe052, 0x90e3},
	{0xe053, 0x90e4},
	{0xe054, 0x90e5},
	{0xe055, 0x90e9},
	{0xe056, 0x90ea},
	{0xe057, 0x90ec},
	{0xe058, 0x90ee},
	{0xe059, 0x90f0},
	{0xe05a, 0x90f1},
	{0xe05b, 0x90f2},
	{0xe05c, 0x90f3},
	{0xe05d, 0x90f5},
	{0xe05e, 0x90f6},
	{0xe05f, 0x90f7},
	{0xe060, 0x90f9},
	{0xe061, 0x90fa},
	{0xe062, 0x90fb},
	{0xe063, 0x90fc},
	{0xe064, 0x90ff},
	{0xe065, 0x9100},
	{0xe066, 0x9101},
	{0xe067, 0x9103},
	{0xe068, 0x9105},
	{0xe069, 0x9106},
	{0xe06a, 0x9107},
	{0xe06b, 0x9108},
	{0xe06c, 0x9109},
	{0xe06d, 0x910a},
	{0xe06e, 0x910b},
	{0xe06f, 0x910c},
	{0xe070, 0x910d},
	{0xe071, 0x910e},
	{0xe072, 0x910f},
	{0xe073, 0x9110},
	{0xe074, 0x9111},
	{0xe075, 0x9112},
	{0xe076, 0x9113},
	{0xe077, 0x9114},
	{0xe078, 0x9115},
	{0xe079, 0x9116},
	{0xe07a, 0x9117},
	{0xe07b, 0x9118},
	{0xe07c, 0x911a},
	{0xe07d, 0x911b},
	{0xe07e, 0x911c},
	{0xe080, 0x911d},
	{0xe081, 0x911f},
	{0xe082, 0x9120},
	{0xe083, 0x9121},
	{0xe084, 0x9124},
	{0xe085, 0x9125},
	{0xe086, 0x9126},
	{0xe087, 0x9127},
	{0xe088, 0x9128},
	{0xe089, 0x9129},
	{0xe08a, 0x912a},
	{0xe08b, 0x912b},
	{0xe08c, 0x912c},
	{0xe08d, 0x912d},
	{0xe08e, 0x912e},
	{0xe08f, 0x9130},
	{0xe090, 0x9132},
	{0xe091, 0x9133},
	{0xe092, 0x9134},
	{0xe093, 0x9135},
	{0xe094, 0x9136},
	{0xe095, 0x9137},
	{0xe096, 0x9138},
	{0xe097, 0x913a},
	{0xe098, 0x913b},
	{0xe099, 0x913c},
	{0xe09a, 0x913d},
	{0xe09b, 0x913e},
	{0xe09c, 0x913f},
	{0xe09d, 0x9140},
	{0xe09e, 0x9141},
	{0xe09f, 0x9142},
	{0xe0a0, 0x9144},
	{0xe0a1, 0x5537},
	{0xe0a2, 0x5556},
	{0xe0a3, 0x5575},
	{0xe0a4, 0x5576},
	{0xe0a5, 0x5577},
	{0xe0a6, 0x5533},
	{0xe0a7, 0x5530},
	{0xe0a8, 0x555c},
	{0xe0a9, 0x558b},
	{0xe0aa, 0x55d2},
	{0xe0ab, 0x5583},
	{0xe0ac, 0x55b1},
	{0xe0ad, 0x55b9},
	{0xe0ae, 0x5588},
	{0xe0af, 0x5581},
	{0xe0b0, 0x559f},
	{0xe0b1, 0x557e},
	{0xe0b2, 0x55d6},
	{0xe0b3, 0x5591},
	{0xe0b4, 0x557b},
	{0xe0b5, 0x55df},
	{0xe0b6, 0x55bd},
	{0xe0b7, 0x55be},
	{0xe0b8, 0x5594},
	{0xe0b9, 0x5599},
	{0xe0ba, 0x55ea},
	{0xe0bb, 0x55f7},
	{0xe0bc, 0x55c9},
	{0xe0bd, 0x561f},
	{0xe0be, 0x55d1},
	{0xe0bf, 0x55eb},
	{0xe0c0, 0x55ec},
	{0xe0c1, 0x55d4},
	{0xe0c2, 0x55e6},
	{0xe0c3, 0x55dd},
	{0xe0c4, 0x55c4},
	{0xe0c5, 0x55ef},
	{0xe0c6, 0x55e5},
	{0xe0c7, 0x55f2},
	{0xe0c8, 0x55f3},
	{0xe0c9, 0x55cc},
	{0xe0ca, 0x55cd},
	{0xe0cb, 0x55e8},
	{0xe0cc, 0x55f5},
	{0xe0cd, 0x55e4},
	{0xe0ce, 0x8f94},
	{0xe0cf, 0x561e},
	{0xe0d0, 0x5608},
	{0xe0d1, 0x560c},
	{0xe0d2, 0x5601},
	{0xe0d3, 0x5624},
	{0xe0d4, 0x5623},
	{0xe0d5, 0x55fe},
	{0xe0d6, 0x5600},
	{0xe0d7, 0x5627},
	{0xe0d8, 0x562d},
	{0xe0d9, 0x5658},
	{0xe0da, 0x5639},
	{0xe0db, 0x5657},
	{0xe0dc, 0x562c},
	{0xe0dd, 0x564d},
	{0xe0de, 0x5662},
	{0xe0df, 0x5659},
	{0xe0e0, 0x565c},
	{0xe0e1, 0x564c},
	{0xe0e2, 0x5654},
	{0xe0e3, 0x5686},
	{0xe0e4, 0x5664},
	{0xe0e5, 0x5671},
	{0xe0e6, 0x566b},
	{0xe0e7, 0x567b},
	{0xe0e8, 0x567c},
	{0xe0e9, 0x5685},
	{0xe0ea, 0x5693},
	{0xe0eb, 0x56af},
	{0xe0ec, 0x56d4},
	{0xe0ed, 0x56d7},
	{0xe0ee, 0x56dd},
	{0xe0ef, 0x56e1},
	{0xe0f0, 0x56f5},
	{0xe0f1, 0x56eb},
	{0xe0f2, 0x56f9},
	{0xe0f3, 0x56ff},
	{0xe0f4, 0x5704},
	{0xe0f5, 0x570a},
	{0xe0f6, 0x5709},
	{0xe0f7, 0x571c},
	{0xe0f8, 0x5e0f},
	{0xe0f9, 0x5e19},
	{0xe0fa, 0x5e14},
	{0xe0fb, 0x5e11},
	{0xe0fc, 0x5e31},
	{0xe0fd, 0x5e3b},
	{0xe0fe, 0x5e3c},
	{0xe140, 0x9145},
	{0xe141, 0x9147},
	{0xe142, 0x9148},
	{0xe143, 0x9151},
	{0xe144, 0x9153},
	{0xe145, 0x9154},
	{0xe146, 0x9155},
	{0xe147, 0x9156},
	{0xe148, 0x9158},
	{0xe149, 0x9159},
	{0xe14a, 0x915b},
	{0xe14b, 0x915c},
	{0xe14c, 0x915f},
	{0xe14d, 0x9160},
	{0xe14e, 0x9166},
	{0xe14f, 0x9167},
	{0xe150, 0x9168},
	{0xe151, 0x916b},
	{0xe152, 0x916d},
	{0xe153, 0x9173},
	{0xe154, 0x917a},
	{0xe155, 0x917b},
	{0xe156, 0x917c},
	{0xe157, 0x9180},
	{0xe158, 0x9181},
	{0xe159, 0x9182},
	{0xe15a, 0x9183},
	{0xe15b, 0x9184},
	{0xe15c, 0x9186},
	{0xe15d, 0x9188},
	{0xe15e, 0x918a},
	{0xe15f, 0x918e},
	{0xe160, 0x918f},
	{0xe161, 0x9193},
	{0xe162, 0x9194},
	{0xe163, 0x9195},
	{0xe164, 0x9196},
	{0xe165, 0x9197},
	{0xe166, 0x9198},
	{0xe167, 0x9199},
	{0xe168, 0x919c},
	{0xe169, 0x919d},
	{0xe16a, 0x919e},
	{0xe16b, 0x919f},
	{0xe16c, 0x91a0},
	{0xe16d, 0x91a1},
	{0xe16e, 0x91a4},
	{0xe16f, 0x91a5},
	{0xe170, 0x91a6},
	{0xe171, 0x91a7},
	{0xe172, 0x91a8},
	{0xe173, 0x91a9},
	{0xe174, 0x91ab},
	{0xe175, 0x91ac},
	{0xe176, 0x91b0},
	{0xe177, 0x91b1},
	{0xe178, 0x91b2},
	{0xe179, 0x91b3},
	{0xe17a, 0x91b6},
	{0xe17b, 0x91b7},
	{0xe17c, 0x91b8},
	{0xe17d, 0x91b9},
	{0xe17e, 0x91bb},
	{0xe180, 0x91bc},
	{0xe181, 0x91bd},
	{0xe182, 0x91be},
	{0xe183, 0x91bf},
	{0xe184, 0x91c0},
	{0xe185, 0x91c1},
	{0xe186, 0x91c2},
	{0xe187, 0x91c3},
	{0xe188, 0x91c4},
	{0xe189, 0x91c5},
	{0xe18a, 0x91c6},
	{0xe18b, 0x91c8},
	{0xe18c, 0x91cb},
	{0xe18d, 0x91d0},
	{0xe18e, 0x91d2},
	{0xe18f, 0x91d3},
	{0xe190, 0x91d4},
	{0xe191, 0x91d5},
	{0xe192, 0x91d6},
	{0xe193, 0x91d7},
	{0xe194, 0x91d8},
	{0xe195, 0x91d9},
	{0xe196, 0x91da},
	{0xe197, 0x91db},
	{0xe198, 0x91dd},
	{0xe199, 0x91de},
	{0xe19a, 0x91df},
	{0xe19b, 0x91e0},
	{0xe19c, 0x91e1},
	{0xe19d, 0x91e2},
	{0xe19e, 0x91e3},
	{0xe19f, 0x91e4},
	{0xe1a0, 0x91e5},
	{0xe1a1, 0x5e37},
	{0xe1a2, 0x5e44},
	{0xe1a3, 0x5e54},
	{0xe1a4, 0x5e5b},
	{0xe1a5, 0x5e5e},
	{0xe1a6, 0x5e61},
	{0xe1a7, 0x5c8c},
	{0xe1a8, 0x5c7a},
	{0xe1a9, 0x5c8d},
	{0xe1aa, 0x5c90},
	{0xe1ab, 0x5c96},
	{0xe1ac, 0x5c88},
	{0xe1ad, 0x5c98},
	{0xe1ae, 0x5c99},
	{0xe1af, 0x5c91},
	{0xe1b0, 0x5c9a},
	{0xe1b1, 0x5c9c},
	{0xe1b2, 0x5cb5},
	{0xe1b3, 0x5ca2},
	{0xe1b4, 0x5cbd},
	{0xe1b5, 0x5cac},
	{0xe1b6, 0x5cab},
	{0xe1b7, 0x5cb1},
	{0xe1b8, 0x5ca3},
	{0xe1b9, 0x5cc1},
	{0xe1ba, 0x5cb7},
	{0xe1bb, 0x5cc4},
	{0xe1bc, 0x5cd2},
	{0xe1bd, 0x5ce4},
	{0xe1be, 0x5ccb},
	{0xe1bf, 0x5ce5},
	{0xe1c0, 0x5d02},
	{0xe1c1, 0x5d03},
	{0xe1c2, 0x5d27},
	{0xe1c3, 0x5d26},
	{0xe1c4, 0x5d2e},
	{0xe1c5, 0x5d24},
	{0xe1c6, 0x5d1e},
	{0xe1c7, 0x5d06},
	{0xe1c8, 0x5d1b},
	{0xe1c9, 0x5d58},
	{0xe1ca, 0x5d3e},
	{0xe1cb, 0x5d34},
	{0xe1cc, 0x5d3d},
	{0xe1cd, 0x5d6c},
	{0xe1ce, 0x5d5b},
	{0xe1cf, 0x5d6f},
	{0xe1d0, 0x5d5d},
	{0xe1d1, 0x5d6b},
	{0xe1d2, 0x5d4b},
	{0xe1d3, 0x5d4a},
	{0xe1d4, 0x5d69},
	{0xe1d5, 0x5d74},
	{0xe1d6, 0x5d82},
	{0xe1d7, 0x5d99},
	{0xe1d8, 0x5d9d},
	{0xe1d9, 0x8c73},
	{0xe1da, 0x5db7},
	{0xe1db, 0x5dc5},
	{0xe1dc, 0x5f73},
	{0xe1dd, 0x5f77},
	{0xe1de, 0x5f82},
	{0xe1df, 0x5f87},
	{0xe1e0, 0x5f89},
	{0xe1e1, 0x5f8c},
	{0xe1e2, 0x5f95},
	{0xe1e3, 0x5f99},
	{0xe1e4, 0x5f9c},
	{0xe1e5, 0x5fa8},
	{0xe1e6, 0x5fad},
	{0xe1e7, 0x5fb5},
	{0xe1e8, 0x5fbc},
	{0xe1e9, 0x8862},
	{0xe1ea, 0x5f61},
	{0xe1eb, 0x72ad},
	{0xe1ec, 0x72b0},
	{0xe1ed, 0x72b4},
	{0xe1ee, 0x72b7},
	{0xe1ef, 0x72b8},
	{0xe1f0, 0x72c3},
	{0xe1f1, 0x72c1},
	{0xe1f2, 0x72ce},
	{0xe1f3, 0x72cd},
	{0xe1f4, 0x72d2},
	{0xe1f5, 0x72e8},
	{0xe1f6, 0x72ef},
	{0xe1f7, 0x72e9},
	{0xe1f8, 0x72f2},
	{0xe1f9, 0x72f4},
	{0xe1fa, 0x72f7},
	{0xe1fb, 0x7301},
	{0xe1fc, 0x72f3},
	{0xe1fd, 0x7303},
	{0xe1fe, 0x72fa},
	{0xe240, 0x91e6},
	{0xe241, 0x91e7},
	{0xe242, 0x91e8},
	{0xe243, 0x91e9},
	{0xe244, 0x91ea},
	{0xe245, 0x91eb},
	{0xe246, 0x91ec},
	{0xe247, 0x91ed},
	{0xe248, 0x91ee},
	{0xe249, 0x91ef},
	{0xe24a, 0x91f0},
	{0xe24b, 0x91f1},
	{0xe24c, 0x91f2},
	{0xe24d, 0x91f3},
	{0xe24e, 0x91f4},
	{0xe24f, 0x91f5},
	{0xe250, 0x91f6},
	{0xe251, 0x91f7},
	{0xe252, 0x91f8},
	{0xe253, 0x91f9},
	{0xe254, 0x91fa},
	{0xe255, 0x91fb},
	{0xe256, 0x91fc},
	{0xe257, 0x91fd},
	{0xe258, 0x91fe},
	{0xe259, 0x91ff},
	{0xe25a, 0x9200},
	{0xe25b, 0x9201},
	{0xe25c, 0x9202},
	{0xe25d, 0x9203},
	{0xe25e, 0x9204},
	{0xe25f, 0x9205},
	{0xe260, 0x9206},
	{0xe261, 0x9207},
	{0xe262, 0x9208},
	{0xe263, 0x9209},
	{0xe264, 0x920a},
	{0xe265, 0x920b},
	{0xe266, 0x920c},
	{0xe267, 0x920d},
	{0xe268, 0x920e},
	{0xe269, 0x920f},
	{0xe26a, 0x9210},
	{0xe26b, 0x9211},
	{0xe26c, 0x9212},
	{0xe26d, 0x9213},
	{0xe26e, 0x9214},
	{0xe26f, 0x9215},
	{0xe270, 0x9216},
	{0xe271, 0x9217},
	{0xe272, 0x9218},
	{0xe273, 0x9219},
	{0xe274, 0x921a},
	{0xe275, 0x921b},
	{0xe276, 0x921c},
	{0xe277, 0x921d},
	{0xe278, 0x921e},
	{0xe279, 0x921f},
	{0xe27a, 0x9220},
	{0xe27b, 0x9221},
	{0xe27c, 0x9222},
	{0xe27d, 0x9223},
	{0xe27e, 0x9224},
	{0xe280, 0x9225},
	{0xe281, 0x9226},
	{0xe282, 0x9227},
	{0xe283, 0x9228},
	{0xe284, 0x9229},
	{0xe285, 0x922a},
	{0xe286, 0x922b},
	{0xe287, 0x922c},
	{0xe288, 0x922d},
	{0xe289, 0x922e},
	{0xe28a, 0x922f},
	{0xe28b, 0x9230},
	{0xe28c, 0x9231},
	{0xe28d, 0x9232},
	{0xe28e, 0x9233},
	{0xe28f, 0x9234},
	{0xe290, 0x9235},
	{0xe291, 0x9236},
	{0xe292, 0x9237},
	{0xe293, 0x9238},
	{0xe294, 0x9239},
	{0xe295, 0x923a},
	{0xe296, 0x923b},
	{0xe297, 0x923c},
	{0xe298, 0x923d},
	{0xe299, 0x923e},
	{0xe29a, 0x923f},
	{0xe29b, 0x9240},
	{0xe29c, 0x9241},
	{0xe29d, 0x9242},
	{0xe29e, 0x9243},
	{0xe29f, 0x9244},
	{0xe2a0, 0x9245},
	{0xe2a1, 0x72fb},
	{0xe2a2, 0x7317},
	{0xe2a3, 0x7313},
	{0xe2a4, 0x7321},
	{0xe2a5, 0x730a},
	{0xe2a6, 0x731e},
	{0xe2a7, 0x731d},
	{0xe2a8, 0x7315},
	{0xe2a9, 0x7322},
	{0xe2aa, 0x7339},
	{0xe2ab, 0x7325},
	{0xe2ac, 0x732c},
	{0xe2ad, 0x7338},
	{0xe2ae, 0x7331},
	{0xe2af, 0x7350},
	{0xe2b0, 0x734d},
	{0xe2b1, 0x7357},
	{0xe2b2, 0x7360},
	{0xe2b3, 0x736c},
	{0xe2b4, 0x736f},
	{0xe2b5, 0x737e},
	{0xe2b6, 0x821b},
	{0xe2b7, 0x5925},
	{0xe2b8, 0x98e7},
	{0xe2b9, 0x5924},
	{0xe2ba, 0x5902},
	{0xe2bb, 0x9963},
	{0xe2bc, 0x9967},
	{0xe2bd, 0x9968},
	{0xe2be, 0x9969},
	{0xe2bf, 0x996a},
	{0xe2c0, 0x996b},
	{0xe2c1, 0x996c},
	{0xe2c2, 0x9974},
	{0xe2c3, 0x9977},
	{0xe2c4, 0x997d},
	{0xe2c5, 0x9980},
	{0xe2c6, 0x9984},
	{0xe2c7, 0x9987},
	{0xe2c8, 0x998a},
	{0xe2c9, 0x998d},
	{0xe2ca, 0x9990},
	{0xe2cb, 0x9991},
	{0xe2cc, 0x9993},
	{0xe2cd, 0x9994},
	{0xe2ce, 0x9995},
	{0xe2cf, 0x5e80},
	{0xe2d0, 0x5e91},
	{0xe2d1, 0x5e8b},
	{0xe2d2, 0x5e96},
	{0xe2d3, 0x5ea5},
	{0xe2d4, 0x5ea0},
	{0xe2d5, 0x5eb9},
	{0xe2d6, 0x5eb5},
	{0xe2d7, 0x5ebe},
	{0xe2d8, 0x5eb3},
	{0xe2d9, 0x8d53},
	{0xe2da, 0x5ed2},
	{0xe2db, 0x5ed1},
	{0xe2dc, 0x5edb},
	{0xe2dd, 0x5ee8},
	{0xe2de, 0x5eea},
	{0xe2df, 0x81ba},
	{0xe2e0, 0x5fc4},
	{0xe2e1, 0x5fc9},
	{0xe2e2, 0x5fd6},
	{0xe2e3, 0x5fcf},
	{0xe2e4, 0x6003},
	{0xe2e5, 0x5fee},
	{0xe2e6, 0x6004},
	{0xe2e7, 0x5fe1},
	{0xe2e8, 0x5fe4},
	{0xe2e9, 0x5ffe},
	{0xe2ea, 0x6005},
	{0xe2eb, 0x6006},
	{0xe2ec, 0x5fea},
	{0xe2ed, 0x5fed},
	{0xe2ee, 0x5ff8},
	{0xe2ef, 0x6019},
	{0xe2f0, 0x6035},
	{0xe2f1, 0x6026},
	{0xe2f2, 0x601b},
	{0xe2f3, 0x600f},
	{0xe2f4, 0x600d},
	{0xe2f5, 0x6029},
	{0xe2f6, 0x602b},
	{0xe2f7, 0x600a},
	{0xe2f8, 0x603f},
	{0xe2f9, 0x6021},
	{0xe2fa, 0x6078},
	{0xe2fb, 0x6079},
	{0xe2fc, 0x607b},
	{0xe2fd, 0x607a},
	{0xe2fe, 0x6042},
	{0xe340, 0x9246},
	{0xe341, 0x9247},
	{0xe342, 0x9248},
	{0xe343, 0x9249},
	{0xe344, 0x924a},
	{0xe345, 0x924b},
	{0xe346, 0x924c},
	{0xe347, 0x924d},
	{0xe348, 0x924e},
	{0xe349, 0x924f},
	{0xe34a, 0x9250},
	{0xe34b, 0x9251},
	{0xe34c, 0x9252},
	{0xe34d, 0x9253},
	{0xe34e, 0x9254},
	{0xe34f, 0x9255},
	{0xe350, 0x9256},
	{0xe351, 0x9257},
	{0xe352, 0x9258},
	{0xe353, 0x9259},
	{0xe354, 0x925a},
	{0xe355, 0x925b},
	{0xe356, 0x925c},
	{0xe357, 0x925d},
	{0xe358, 0x925e},
	{0xe359, 0x925f},
	{0xe35a, 0x9260},
	{0xe35b, 0x9261},
	{0xe35c, 0x9262},
	{0xe35d, 0x9263},
	{0xe35e, 0x9264},
	{0xe35f, 0x9265},
	{0xe360, 0x9266},
	{0xe361, 0x9267},
	{0xe362, 0x9268},
	{0xe363, 0x9269},
	{0xe364, 0x926a},
	{0xe365, 0x926b},
	{0xe366, 0x926c},
	{0xe367, 0x926d},
	{0xe368, 0x926e},
	{0xe369, 0x926f},
	{0xe36a, 0x9270},
	{0xe36b, 0x9271},
	{0xe36c, 0x9272},
	{0xe36d, 0x9273},
	{0xe36e, 0x9275},
	{0xe36f, 0x9276},
	{0xe370, 0x9277},
	{0xe371, 0x9278},
	{0xe372, 0x9279},
	{0xe373, 0x927a},
	{0xe374, 0x927b},
	{0xe375, 0x927c},
	{0xe376, 0x927d},
	{0xe377, 0x927e},
	{0xe378, 0x927f},
	{0xe379, 0x9280},
	{0xe37a, 0x9281},
	{0xe37b, 0x9282},
	{0xe37c, 0x9283},
	{0xe37d, 0x9284},
	{0xe37e, 0x9285},
	{0xe380, 0x9286},
	{0xe381, 0x9287},
	{0xe382, 0x9288},
	{0xe383, 0x9289},
	{0xe384, 0x928a},
	{0xe385, 0x928b},
	{0xe386, 0x928c},
	{0xe387, 0x928d},
	{0xe388, 0x928f},
	{0xe389, 0x9290},
	{0xe38a, 0x9291},
	{0xe38b, 0x9292},
	{0xe38c, 0x9293},
	{0xe38d, 0x9294},
	{0xe38e, 0x9295},
	{0xe38f, 0x9296},
	{0xe390, 0x9297},
	{0xe391, 0x9298},
	{0xe392, 0x9299},
	{0xe393, 0x929a},
	{0xe394, 0x929b},
	{0xe395, 0x929c},
	{0xe396, 0x929d},
	{0xe397, 0x929e},
	{0xe398, 0x929f},
	{0xe399, 0x92a0},
	{0xe39a, 0x92a1},
	{0xe39b, 0x92a2},
	{0xe39c, 0x92a3},
	{0xe39d, 0x92a4},
	{0xe39e, 0x92a5},
	{0xe39f, 0x92a6},
	{0xe3a0, 0x92a7},
	{0xe3a1, 0x606a},
	{0xe3a2, 0x607d},
	{0xe3a3, 0x6096},
	{0xe3a4, 0x609a},
	{0xe3a5, 0x60ad},
	{0xe3a6, 0x609d},
	{0xe3a7, 0x6083},
	{0xe3a8, 0x6092},
	{0xe3a9, 0x608c},
	{0xe3aa, 0x609b},
	{0xe3ab, 0x60ec},
	{0xe3ac, 0x60bb},
	{0xe3ad, 0x60b1},
	{0xe3ae, 0x60dd},
	{0xe3af, 0x60d8},
	{0xe3b0, 0x60c6},
	{0xe3b1, 0x60da},
	{0xe3b2, 0x60b4},
	{0xe3b3, 0x6120},
	{0xe3b4, 0x6126},
	{0xe3b5, 0x6115},
	{0xe3b6, 0x6123},
	{0xe3b7, 0x60f4},
	{0xe3b8, 0x6100},
	{0xe3b9, 0x610e},
	{0xe3ba, 0x612b},
	{0xe3bb, 0x614a},
	{0xe3bc, 0x6175},
	{0xe3bd, 0x61ac},
	{0xe3be, 0x6194},
	{0xe3bf, 0x61a7},
	{0xe3c0, 0x61b7},
	{0xe3c1, 0x61d4},
	{0xe3c2, 0x61f5},
	{0xe3c3, 0x5fdd},
	{0xe3c4, 0x96b3},
	{0xe3c5, 0x95e9},
	{0xe3c6, 0x95eb},
	{0xe3c7, 0x95f1},
	{0xe3c8, 0x95f3},
	{0xe3c9, 0x95f5},
	{0xe3ca, 0x95f6},
	{0xe3cb, 0x95fc},
	{0xe3cc, 0x95fe},
	{0xe3cd, 0x9603},
	{0xe3ce, 0x9604},
	{0xe3cf, 0x9606},
	{0xe3d0, 0x9608},
	{0xe3d1, 0x960a},
	{0xe3d2, 0x960b},
	{0xe3d3, 0x960c},
	{0xe3d4, 0x960d},
	{0xe3d5, 0x960f},
	{0xe3d6, 0x9612},
	{0xe3d7, 0x9615},
	{0xe3d8, 0x9616},
	{0xe3d9, 0x9617},
	{0xe3da, 0x9619},
	{0xe3db, 0x961a},
	{0xe3dc, 0x4e2c},
	{0xe3dd, 0x723f},
	{0xe3de, 0x6215},
	{0xe3df, 0x6c35},
	{0xe3e0, 0x6c54},
	{0xe3e1, 0x6c5c},
	{0xe3e2, 0x6c4a},
	{0xe3e3, 0x6ca3},
	{0xe3e4, 0x6c85},
	{0xe3e5, 0x6c90},
	{0xe3e6, 0x6c94},
	{0xe3e7, 0x6c8c},
	{0xe3e8, 0x6c68},
	{0xe3e9, 0x6c69},
	{0xe3ea, 0x6c74},
	{0xe3eb, 0x6c76},
	{0xe3ec, 0x6c86},
	{0xe3ed, 0x6ca9},
	{0xe3ee, 0x6cd0},
	{0xe3ef, 0x6cd4},
	{0xe3f0, 0x6cad},
	{0xe3f1, 0x6cf7},
	{0xe3f2, 0x6cf8},
	{0xe3f3, 0x6cf1},
	{0xe3f4, 0x6cd7},
	{0xe3f5, 0x6cb2},
	{0xe3f6, 0x6ce0},
	{0xe3f7, 0x6cd6},
	{0xe3f8, 0x6cfa},
	{0xe3f9, 0x6ceb},
	{0xe3fa, 0x6cee},
	{0xe3fb, 0x6cb1},
	{0xe3fc, 0x6cd3},
	{0xe3fd, 0x6cef},
	{0xe3fe, 0x6cfe},
	{0xe440, 0x92a8},
	{0xe441, 0x92a9},
	{0xe442, 0x92aa},
	{0xe443, 0x92ab},
	{0xe444, 0x92ac},
	{0xe445, 0x92ad},
	{0xe446, 0x92af},
	{0xe447, 0x92b0},
	{0xe448, 0x92b1},
	{0xe449, 0x92b2},
	{0xe44a, 0x92b3},
	{0xe44b, 0x92b4},
	{0xe44c, 0x92b5},
	{0xe44d, 0x92b6},
	{0xe44e, 0x92b7},
	{0xe44f, 0x92b8},
	{0xe450, 0x92b9},
	{0xe451, 0x92ba},
	{0xe452, 0x92bb},
	{0xe453, 0x92bc},
	{0xe454, 0x92bd},
	{0xe455, 0x92be},
	{0xe456, 0x92bf},
	{0xe457, 0x92c0},
	{0xe458, 0x92c1},
	{0xe459, 0x92c2},
	{0xe45a, 0x92c3},
	{0xe45b, 0x92c4},
	{0xe45c, 0x92c5},
	{0xe45d, 0x92c6},
	{0xe45e, 0x92c7},
	{0xe45f, 0x92c9},
	{0xe460, 0x92ca},
	{0xe461, 0x92cb},
	{0xe462, 0x92cc},
	{0xe463, 0x92cd},
	{0xe464, 0x92ce},
	{0xe465, 0x92cf},
	{0xe466, 0x92d0},
	{0xe467, 0x92d1},
	{0xe468, 0x92d2},
	{0xe469, 0x92d3},
	{0xe46a, 0x92d4},
	{0xe46b, 0x92d5},
	{0xe46c, 0x92d6},
	{0xe46d, 0x92d7},
	{0xe46e, 0x92d8},
	{0xe46f, 0x92d9},
	{0xe470, 0x92da},
	{0xe471, 0x92db},
	{0xe472, 0x92dc},
	{0xe473, 0x92dd},
	{0xe474, 0x92de},
	{0xe475, 0x92df},
	{0xe476, 0x92e0},
	{0xe477, 0x92e1},
	{0xe478, 0x92e2},
	{0xe479, 0x92e3},
	{0xe47a, 0x92e4},
	{0xe47b, 0x92e5},
	{0xe47c, 0x92e6},
	{0xe47d, 0x92e7},
	{0xe47e, 0x92e8},
	{0xe480, 0x92e9},
	{0xe481, 0x92ea},
	{0xe482, 0x92eb},
	{0xe483, 0x92ec},
	{0xe484, 0x92ed},
	{0xe485, 0x92ee},
	{0xe486, 0x92ef},
	{0xe487, 0x92f0},
	{0xe488, 0x92f1},
	{0xe489, 0x92f2},
	{0xe48a, 0x92f3},
	{0xe48b, 0x92f4},
	{0xe48c, 0x92f5},
	{0xe48d, 0x92f6},
	{0xe48e, 0x92f7},
	{0xe48f, 0x92f8},
	{0xe490, 0x92f9},
	{0xe491, 0x92fa},
	{0xe492, 0x92fb},
	{0xe493, 0x92fc},
	{0xe494, 0x92fd},
	{0xe495, 0x92fe},
	{0xe496, 0x92ff},
	{0xe497, 0x9300},
	{0xe498, 0x9301},
	{0xe499, 0x9302},
	{0xe49a, 0x9303},
	{0xe49b, 0x9304},
	{0xe49c, 0x9305},
	{0xe49d, 0x9306},
	{0xe49e, 0x9307},
	{0xe49f, 0x9308},
	{0xe4a0, 0x9309},
	{0xe4a1, 0x6d39},
	{0xe4a2, 0x6d27},
	{0xe4a3, 0x6d0c},
	{0xe4a4, 0x6d43},
	{0xe4a5, 0x6d48},
	{0xe4a6, 0x6d07},
	{0xe4a7, 0x6d04},
	{0xe4a8, 0x6d19},
	{0xe4a9, 0x6d0e},
	{0xe4aa, 0x6d2b},
	{0xe4ab, 0x6d4d},
	{0xe4ac, 0x6d2e},
	{0xe4ad, 0x6d35},
	{0xe4ae, 0x6d1a},
	{0xe4af, 0x6d4f},
	{0xe4b0, 0x6d52},
	{0xe4b1, 0x6d54},
	{0xe4b2, 0x6d33},
	{0xe4b3, 0x6d91},
	{0xe4b4, 0x6d6f},
	{0xe4b5, 0x6d9e},
	{0xe4b6, 0x6da0},
	{0xe4b7, 0x6d5e},
	{0xe4b8, 0x6d93},
	{0xe4b9, 0x6d94},
	{0xe4ba, 0x6d5c},
	{0xe4bb, 0x6d60},
	{0xe4bc, 0x6d7c},
	{0xe4bd, 0x6d63},
	{0xe4be, 0x6e1a},
	{0xe4bf, 0x6dc7},
	{0xe4c0, 0x6dc5},
	{0xe4c1, 0x6dde},
	{0xe4c2, 0x6e0e},
	{0xe4c3, 0x6dbf},
	{0xe4c4, 0x6de0},
	{0xe4c5, 0x6e11},
	{0xe4c6, 0x6de6},
	{0xe4c7, 0x6ddd},
	{0xe4c8, 0x6dd9},
	{0xe4c9, 0x6e16},
	{0xe4ca, 0x6dab},
	{0xe4cb, 0x6e0c},
	{0xe4cc, 0x6dae},
	{0xe4cd, 0x6e2b},
	{0xe4ce, 0x6e6e},
	{0xe4cf, 0x6e4e},
	{0xe4d0, 0x6e6b},
	{0xe4d1, 0x6eb2},
	{0xe4d2, 0x6e5f},
	{0xe4d3, 0x6e86},
	{0xe4d4, 0x6e53},
	{0xe4d5, 0x6e54},
	{0xe4d6, 0x6e32},
	{0xe4d7, 0x6e25},
	{0xe4d8, 0x6e44},
	{0xe4d9, 0x6edf},
	{0xe4da, 0x6eb1},
	{0xe4db, 0x6e98},
	{0xe4dc, 0x6ee0},
	{0xe4dd, 0x6f2d},
	{0xe4de, 0x6ee2},
	{0xe4df, 0x6ea5},
	{0xe4e0, 0x6ea7},
	{0xe4e1, 0x6ebd},
	{0xe4e2, 0x6ebb},
	{0xe4e3, 0x6eb7},
	{0xe4e4, 0x6ed7},
	{0xe4e5, 0x6eb4},
	{0xe4e6, 0x6ecf},
	{0xe4e7, 0x6e8f},
	{0xe4e8, 0x6ec2},
	{0xe4e9, 0x6e9f},
	{0xe4ea, 0x6f62},
	{0xe4eb, 0x6f46},
	{0xe4ec, 0x6f47},
	{0xe4ed, 0x6f24},
	{0xe4ee, 0x6f15},
	{0xe4ef, 0x6ef9},
	{0xe4f0, 0x6f2f},
	{0xe4f1, 0x6f36},
	{0xe4f2, 0x6f4b},
	{0xe4f3, 0x6f74},
	{0xe4f4, 0x6f2a},
	{0xe4f5, 0x6f09},
	{0xe4f6, 0x6f29},
	{0xe4f7, 0x6f89},
	{0xe4f8, 0x6f8d},
	{0xe4f9, 0x6f8c},
	{0xe4fa, 0x6f78},
	{0xe4fb, 0x6f72},
	{0xe4fc, 0x6f7c},
	{0xe4fd, 0x6f7a},
	{0xe4fe, 0x6fd1},
	{0xe540, 0x930a},
	{0xe541, 0x930b},
	{0xe542, 0x930c},
	{0xe543, 0x930d},
	{0xe544, 0x930e},
	{0xe545, 0x930f},
	{0xe546, 0x9310},
	{0xe547, 0x9311},
	{0xe548, 0x9312},
	{0xe549, 0x9313},
	{0xe54a, 0x9314},
	{0xe54b, 0x9315},
	{0xe54c, 0x9316},
	{0xe54d, 0x9317},
	{0xe54e, 0x9318},
	{0xe54f, 0x9319},
	{0xe550, 0x931a},
	{0xe551, 0x931b},
	{0xe552, 0x931c},
	{0xe553, 0x931d},
	{0xe554, 0x931e},
	{0xe555, 0x931f},
	{0xe556, 0x9320},
	{0xe557, 0x9321},
	{0xe558, 0x9322},
	{0xe559, 0x9323},
	{0xe55a, 0x9324},
	{0xe55b, 0x9325},
	{0xe55c, 0x9326},
	{0xe55d, 0x9327},
	{0xe55e, 0x9328},
	{0xe55f, 0x9329},
	{0xe560, 0x932a},
	{0xe561, 0x932b},
	{0xe562, 0x932c},
	{0xe563, 0x932d},
	{0xe564, 0x932e},
	{0xe565, 0x932f},
	{0xe566, 0x9330},
	{0xe567, 0x9331},
	{0xe568, 0x9332},
	{0xe569, 0x9333},
	{0xe56a, 0x9334},
	{0xe56b, 0x9335},
	{0xe56c, 0x9336},
	{0xe56d, 0x9337},
	{0xe56e, 0x9338},
	{0xe56f, 0x9339},
	{0xe570, 0x933a},
	{0xe571, 0x933b},
	{0xe572, 0x933c},
	{0xe573, 0x933d},
	{0xe574, 0x933f},
	{0xe575, 0x9340},
	{0xe576, 0x9341},
	{0xe577, 0x9342},
	{0xe578, 0x9343},
	{0xe579, 0x9344},
	{0xe57a, 0x9345},
	{0xe57b, 0x9346},
	{0xe57c, 0x9347},
	{0xe57d, 0x9348},
	{0xe57e, 0x9349},
	{0xe580, 0x934a},
	{0xe581, 0x934b},
	{0xe582, 0x934c},
	{0xe583, 0x934d},
	{0xe584, 0x934e},
	{0xe585, 0x934f},
	{0xe586, 0x9350},
	{0xe587, 0x9351},
	{0xe588, 0x9352},
	{0xe589, 0x9353},
	{0xe58a, 0x9354},
	{0xe58b, 0x9355},
	{0xe58c, 0x9356},
	{0xe58d, 0x9357},
	{0xe58e, 0x9358},
	{0xe58f, 0x9359},
	{0xe590, 0x935a},
	{0xe591, 0x935b},
	{0xe592, 0x935c},
	{0xe593, 0x935d},
	{0xe594, 0x935e},
	{0xe595, 0x935f},
	{0xe596, 0x9360},
	{0xe597, 0x9361},
	{0xe598, 0x9362},
	{0xe599, 0x9363},
	{0xe59a, 0x9364},
	{0xe59b, 0x9365},
	{0xe59c, 0x9366},
	{0xe59d, 0x9367},
	{0xe59e, 0x9368},
	{0xe59f, 0x9369},
	{0xe5a0, 0x936b},
	{0xe5a1, 0x6fc9},
	{0xe5a2, 0x6fa7},
	{0xe5a3, 0x6fb9},
	{0xe5a4, 0x6fb6},
	{0xe5a5, 0x6fc2},
	{0xe5a6, 0x6fe1},
	{0xe5a7, 0x6fee},
	{0xe5a8, 0x6fde},
	{0xe5a9, 0x6fe0},
	{0xe5aa, 0x6fef},
	{0xe5ab, 0x701a},
	{0xe5ac, 0x7023},
	{0xe5ad, 0x701b},
	{0xe5ae, 0x7039},
	{0xe5af, 0x7035},
	{0xe5b0, 0x704f},
	{0xe5b1, 0x705e},
	{0xe5b2, 0x5b80},
	{0xe5b3, 0x5b84},
	{0xe5b4, 0x5b95},
	{0xe5b5, 0x5b93},
	{0xe5b6, 0x5ba5},
	{0xe5b7, 0x5bb8},
	{0xe5b8, 0x752f},
	{0xe5b9, 0x9a9e},
	{0xe5ba, 0x6434},
	{0xe5bb, 0x5be4},
	{0xe5bc, 0x5bee},
	{0xe5bd, 0x8930},
	{0xe5be, 0x5bf0},
	{0xe5bf, 0x8e47},
	{0xe5c0, 0x8b07},
	{0xe5c1, 0x8fb6},
	{0xe5c2, 0x8fd3},
	{0xe5c3, 0x8fd5},
	{0xe5c4, 0x8fe5},
	{0xe5c5, 0x8fee},
	{0xe5c6, 0x8fe4},
	{0xe5c7, 0x8fe9},
	{0xe5c8, 0x8fe6},
	{0xe5c9, 0x8ff3},
	{0xe5ca, 0x8fe8},
	{0xe5cb, 0x9005},
	{0xe5cc, 0x9004},
	{0xe5cd, 0x900b},
	{0xe5ce, 0x9026},
	{0xe5cf, 0x9011},
	{0xe5d0, 0x900d},
	{0xe5d1, 0x9016},
	{0xe5d2, 0x9021},
	{0xe5d3, 0x9035},
	{0xe5d4, 0x9036},
	{0xe5d5, 0x902d},
	{0xe5d6, 0x902f},
	{0xe5d7, 0x9044},
	{0xe5d8, 0x9051},
	{0xe5d9, 0x9052},
	{0xe5da, 0x9050},
	{0xe5db, 0x9068},
	{0xe5dc, 0x9058},
	{0xe5dd, 0x9062},
	{0xe5de, 0x905b},
	{0xe5df, 0x66b9},
	{0xe5e0, 0x9074},
	{0xe5e1, 0x907d},
	{0xe5e2, 0x9082},
	{0xe5e3, 0x9088},
	{0xe5e4, 0x9083},
	{0xe5e5, 0x908b},
	{0xe5e6, 0x5f50},
	{0xe5e7, 0x5f57},
	{0xe5e8, 0x5f56},
	{0xe5e9, 0x5f58},
	{0xe5ea, 0x5c3b},
	{0xe5eb, 0x54ab},
	{0xe5ec, 0x5c50},
	{0xe5ed, 0x5c59},
	{0xe5ee, 0x5b71},
	{0xe5ef, 0x5c63},
	{0xe5f0, 0x5c66},
	{0xe5f1, 0x7fbc},
	{0xe5f2, 0x5f2a},
	{0xe5f3, 0x5f29},
	{0xe5f4, 0x5f2d},
	{0xe5f5, 0x8274},
	{0xe5f6, 0x5f3c},
	{0xe5f7, 0x9b3b},
	{0xe5f8, 0x5c6e},
	{0xe5f9, 0x5981},
	{0xe5fa, 0x5983},
	{0xe5fb, 0x598d},
	{0xe5fc, 0x59a9},
	{0xe5fd, 0x59aa},
	{0xe5fe, 0x59a3},
	{0xe640, 0x936c},
	{0xe641, 0x936d},
	{0xe642, 0x936e},
	{0xe643, 0x936f},
	{0xe644, 0x9370},
	{0xe645, 0x9371},
	{0xe646, 0x9372},
	{0xe647, 0x9373},
	{0xe648, 0x9374},
	{0xe649, 0x9375},
	{0xe64a, 0x9376},
	{0xe64b, 0x9377},
	{0xe64c, 0x9378},
	{0xe64d, 0x9379},
	{0xe64e, 0x937a},
	{0xe64f, 0x937b},
	{0xe650, 0x937c},
	{0xe651, 0x937d},
	{0xe652, 0x937e},
	{0xe653, 0x937f},
	{0xe654, 0x9380},
	{0xe655, 0x9381},
	{0xe656, 0x9382},
	{0xe657, 0x9383},
	{0xe658, 0x9384},
	{0xe659, 0x9385},
	{0xe65a, 0x9386},
	{0xe65b, 0x9387},
	{0xe65c, 0x9388},
	{0xe65d, 0x9389},
	{0xe65e, 0x938a},
	{0xe65f, 0x938b},
	{0xe660, 0x938c},
	{0xe661, 0x938d},
	{0xe662, 0x938e},
	{0xe663, 0x9390},
	{0xe664, 0x9391},
	{0xe665, 0x9392},
	{0xe666, 0x9393},
	{0xe667, 0x9394},
	{0xe668, 0x9395},
	{0xe669, 0x9396},
	{0xe66a, 0x9397},
	{0xe66b, 0x9398},
	{0xe66c, 0x9399},
	{0xe66d, 0x939a},
	{0xe66e, 0x939b},
	{0xe66f, 0x939c},
	{0xe670, 0x939d},
	{0xe671, 0x939e},
	{0xe672, 0x939f},
	{0xe673, 0x93a0},
	{0xe674, 0x93a1},
	{0xe675, 0x93a2},
	{0xe676, 0x93a3},
	{0xe677, 0x93a4},
	{0xe678, 0x93a5},
	{0xe679, 0x93a6},
	{0xe67a, 0x93a7},
	{0xe67b, 0x93a8},
	{0xe67c, 0x93a9},
	{0xe67d, 0x93aa},
	{0xe67e, 0x93ab},
	{0xe680, 0x93ac},
	{0xe681, 0x93ad},
	{0xe682, 0x93ae},
	{0xe683, 0x93af},
	{0xe684, 0x93b0},
	{0xe685, 0x93b1},
	{0xe686, 0x93b2},
	{0xe687, 0x93b3},
	{0xe688, 0x93b4},
	{0xe689, 0x93b5},
	{0xe68a, 0x93b6},
	{0xe68b, 0x93b7},
	{0xe68c, 0x93b8},
	{0xe68d, 0x93b9},
	{0xe68e, 0x93ba},
	{0xe68f, 0x93bb},
	{0xe690, 0x93bc},
	{0xe691, 0x93bd},
	{0xe692, 0x93be},
	{0xe693, 0x93bf},
	{0xe694, 0x93c0},
	{0xe695, 0x93c1},
	{0xe696, 0x93c2},
	{0xe697, 0x93c3},
	{0xe698, 0x93c4},
	{0xe699, 0x93c5},
	{0xe69a, 0x93c6},
	{0xe69b, 0x93c7},
	{0xe69c, 0x93c8},
	{0xe69d, 0x93c9},
	{0xe69e, 0x93cb},
	{0xe69f, 0x93cc},
	{0xe6a0, 0x93cd},
	{0xe6a1, 0x5997},
	{0xe6a2, 0x59ca},
	{0xe6a3, 0x59ab},
	{0xe6a4, 0x599e},
	{0xe6a5, 0x59a4},
	{0xe6a6, 0x59d2},
	{0xe6a7, 0x59b2},
	{0xe6a8, 0x59af},
	{0xe6a9, 0x59d7},
	{0xe6aa, 0x59be},
	{0xe6ab, 0x5a05},
	{0xe6ac, 0x5a06},
	{0xe6ad, 0x59dd},
	{0xe6ae, 0x5a08},
	{0xe6af, 0x59e3},
	{0xe6b0, 0x59d8},
	{0xe6b1, 0x59f9},
	{0xe6b2, 0x5a0c},
	{0xe6b3, 0x5a09},
	{0xe6b4, 0x5a32},
	{0xe6b5, 0x5a34},
	{0xe6b6, 0x5a11},
	{0xe6b7, 0x5a23},
	{0xe6b8, 0x5a13},
	{0xe6b9, 0x5a40},
	{0xe6ba, 0x5a67},
	{0xe6bb, 0x5a4a},
	{0xe6bc, 0x5a55},
	{0xe6bd, 0x5a3c},
	{0xe6be, 0x5a62},
	{0xe6bf, 0x5a75},
	{0xe6c0, 0x80ec},
	{0xe6c1, 0x5aaa},
	{0xe6c2, 0x5a9b},
	{0xe6c3, 0x5a77},
	{0xe6c4, 0x5a7a},
	{0xe6c5, 0x5abe},
	{0xe6c6, 0x5aeb},
	{0xe6c7, 0x5ab2},
	{0xe6c8, 0x5ad2},
	{0xe6c9, 0x5ad4},
	{0xe6ca, 0x5ab8},
	{0xe6cb, 0x5ae0},
	{0xe6cc, 0x5ae3},
	{0xe6cd, 0x5af1},
	{0xe6ce, 0x5ad6},
	{0xe6cf, 0x5ae6},
	{0xe6d0, 0x5ad8},
	{0xe6d1, 0x5adc},
	{0xe6d2, 0x5b09},
	{0xe6d3, 0x5b17},
	{0xe6d4, 0x5b16},
	{0xe6d5, 0x5b32},
	{0xe6d6, 0x5b37},
	{0xe6d7, 0x5b40},
	{0xe6d8, 0x5c15},
	{0xe6d9, 0x5c1c},
	{0xe6da, 0x5b5a},
	{0xe6db, 0x5b65},
	{0xe6dc, 0x5b73},
	{0xe6dd, 0x5b51},
	{0xe6de, 0x5b53},
	{0xe6df, 0x5b62},
	{0xe6e0, 0x9a75},
	{0xe6e1, 0x9a77},
	{0xe6e2, 0x9a78},
	{0xe6e3, 0x9a7a},
	{0xe6e4, 0x9a7f},
	{0xe6e5, 0x9a7d},
	{0xe6e6, 0x9a80},
	{0xe6e7, 0x9a81},
	{0xe6e8, 0x9a85},
	{0xe6e9, 0x9a88},
	{0xe6ea, 0x9a8a},
	{0xe6eb, 0x9a90},
	{0xe6ec, 0x9a92},
	{0xe6ed, 0x9a93},
	{0xe6ee, 0x9a96},
	{0xe6ef, 0x9a98},
	{0xe6f0, 0x9a9b},
	{0xe6f1, 0x9a9c},
	{0xe6f2, 0x9a9d},
	{0xe6f3, 0x9a9f},
	{0xe6f4, 0x9aa0},
	{0xe6f5, 0x9aa2},
	{0xe6f6, 0x9aa3},
	{0xe6f7, 0x9aa5},
	{0xe6f8, 0x9aa7},
	{0xe6f9, 0x7e9f},
	{0xe6fa, 0x7ea1},
	{0xe6fb, 0x7ea3},
	{0xe6fc, 0x7ea5},
	{0xe6fd, 0x7ea8},
	{0xe6fe, 0x7ea9},
	{0xe740, 0x93ce},
	{0xe741, 0x93cf},
	{0xe742, 0x93d0},
	{0xe743, 0x93d1},
	{0xe744, 0x93d2},
	{0xe745, 0x93d3},
	{0xe746, 0x93d4},
	{0xe747, 0x93d5},
	{0xe748, 0x93d7},
	{0xe749, 0x93d8},
	{0xe74a, 0x93d9},
	{0xe74b, 0x93da},
	{0xe74c, 0x93db},
	{0xe74d, 0x93dc},
	{0xe74e, 0x93dd},
	{0xe74f, 0x93de},
	{0xe750, 0x93df},
	{0xe751, 0x93e0},
	{0xe752, 0x93e1},
	{0xe753, 0x93e2},
	{0xe754, 0x93e3},
	{0xe755, 0x93e4},
	{0xe756, 0x93e5},
	{0xe757, 0x93e6},
	{0xe758, 0x93e7},
	{0xe759, 0x93e8},
	{0xe75a, 0x93e9},
	{0xe75b, 0x93ea},
	{0xe75c, 0x93eb},
	{0xe75d, 0x93ec},
	{0xe75e, 0x93ed},
	{0xe75f, 0x93ee},
	{0xe760, 0x93ef},
	{0xe761, 0x93f0},
	{0xe762, 0x93f1},
	{0xe763, 0x93f2},
	{0xe764, 0x93f3},
	{0xe765, 0x93f4},
	{0xe766, 0x93f5},
	{0xe767, 0x93f6},
	{0xe768, 0x93f7},
	{0xe769, 0x93f8},
	{0xe76a, 0x93f9},
	{0xe76b, 0x93fa},
	{0xe76c, 0x93fb},
	{0xe76d, 0x93fc},
	{0xe76e, 0x93fd},
	{0xe76f, 0x93fe},
	{0xe770, 0x93ff},
	{0xe771, 0x9400},
	{0xe772, 0x9401},
	{0xe773, 0x9402},
	{0xe774, 0x9403},
	{0xe775, 0x9404},
	{0xe776, 0x9405},
	{0xe777, 0x9406},
	{0xe778, 0x9407},
	{0xe779, 0x9408},
	{0xe77a, 0x9409},
	{0xe77b, 0x940a},
	{0xe77c, 0x940b},
	{0xe77d, 0x940c},
	{0xe77e, 0x940d},
	{0xe780, 0x940e},
	{0xe781, 0x940f},
	{0xe782, 0x9410},
	{0xe783, 0x9411},
	{0xe784, 0x9412},
	{0xe785, 0x9413},
	{0xe786, 0x9414},
	{0xe787, 0x9415},
	{0xe788, 0x9416},
	{0xe789, 0x9417},
	{0xe78a, 0x9418},
	{0xe78b, 0x9419},
	{0xe78c, 0x941a},
	{0xe78d, 0x941b},
	{0xe78e, 0x941c},
	{0xe78f, 0x941d},
	{0xe790, 0x941e},
	{0xe791, 0x941f},
	{0xe792, 0x9420},
	{0xe793, 0x9421},
	{0xe794, 0x9422},
	{0xe795, 0x9423},
	{0xe796, 0x9424},
	{0xe797, 0x9425},
	{0xe798, 0x9426},
	{0xe799, 0x9427},
	{0xe79a, 0x9428},
	{0xe79b, 0x9429},
	{0xe79c, 0x942a},
	{0xe79d, 0x942b},
	{0xe79e, 0x942c},
	{0xe79f, 0x942d},
	{0xe7a0, 0x942e},
	{0xe7a1, 0x7ead},
	{0xe7a2, 0x7eb0},
	{0xe7a3, 0x7ebe},
	{0xe7a4, 0x7ec0},
	{0xe7a5, 0x7ec1},
	{0xe7a6, 0x7ec2},
	{0xe7a7, 0x7ec9},
	{0xe7a8, 0x7ecb},
	{0xe7a9, 0x7ecc},
	{0xe7aa, 0x7ed0},
	{0xe7ab, 0x7ed4},
	{0xe7ac, 0x7ed7},
	{0xe7ad, 0x7edb},
	{0xe7ae, 0x7ee0},
	{0xe7af, 0x7ee1},
	{0xe7b0, 0x7ee8},
	{0xe7b1, 0x7eeb},
	{0xe7b2, 0x7eee},
	{0xe7b3, 0x7eef},
	{0xe7b4, 0x7ef1},
	{0xe7b5, 0x7ef2},
	{0xe7b6, 0x7f0d},
	{0xe7b7, 0x7ef6},
	{0xe7b8, 0x7efa},
	{0xe7b9, 0x7efb},
	{0xe7ba, 0x7efe},
	{0xe7bb, 0x7f01},
	{0xe7bc, 0x7f02},
	{0xe7bd, 0x7f03},
	{0xe7be, 0x7f07},
	{0xe7bf, 0x7f08},
	{0xe7c0, 0x7f0b},
	{0xe7c1, 0x7f0c},
	{0xe7c2, 0x7f0f},
	{0xe7c3, 0x7f11},
	{0xe7c4, 0x7f12},
	{0xe7c5, 0x7f17},
	{0xe7c6, 0x7f19},
	{0xe7c7, 0x7f1c},
	{0xe7c8, 0x7f1b},
	{0xe7c9, 0x7f1f},
	{0xe7ca, 0x7f21},
	{0xe7cb, 0x7f22},
	{0xe7cc, 0x7f23},
	{0xe7cd, 0x7f24},
	{0xe7ce, 0x7f25},
	{0xe7cf, 0x7f26},
	{0xe7d0, 0x7f27},
	{0xe7d1, 0x7f2a},
	{0xe7d2, 0x7f2b},
	{0xe7d3, 0x7f2c},
	{0xe7d4, 0x7f2d},
	{0xe7d5, 0x7f2f},
	{0xe7d6, 0x7f30},
	{0xe7d7, 0x7f31},
	{0xe7d8, 0x7f32},
	{0xe7d9, 0x7f33},
	{0xe7da, 0x7f35},
	{0xe7db, 0x5e7a},
	{0xe7dc, 0x757f},
	{0xe7dd, 0x5ddb},
	{0xe7de, 0x753e},
	{0xe7df, 0x9095},
	{0xe7e0, 0x738e},
	{0xe7e1, 0x7391},
	{0xe7e2, 0x73ae},
	{0xe7e3, 0x73a2},
	{0xe7e4, 0x739f},
	{0xe7e5, 0x73cf},
	{0xe7e6, 0x73c2},
	{0xe7e7, 0x73d1},
	{0xe7e8, 0x73b7},
	{0xe7e9, 0x73b3},
	{0xe7ea, 0x73c0},
	{0xe7eb, 0x73c9},
	{0xe7ec, 0x73c8},
	{0xe7ed, 0x73e5},
	{0xe7ee, 0x73d9},
	{0xe7ef, 0x987c},
	{0xe7f0, 0x740a},
	{0xe7f1, 0x73e9},
	{0xe7f2, 0x73e7},
	{0xe7f3, 0x73de},
	{0xe7f4, 0x73ba},
	{0xe7f5, 0x73f2},
	{0xe7f6, 0x740f},
	{0xe7f7, 0x742a},
	{0xe7f8, 0x745b},
	{0xe7f9, 0x7426},
	{0xe7fa, 0x7425},
	{0xe7fb, 0x7428},
	{0xe7fc, 0x7430},
	{0xe7fd, 0x742e},
	{0xe7fe, 0x742c},
	{0xe840, 0x942f},
	{0xe841, 0x9430},
	{0xe842, 0x9431},
	{0xe843, 0x9432},
	{0xe844, 0x9433},
	{0xe845, 0x9434},
	{0xe846, 0x9435},
	{0xe847, 0x9436},
	{0xe848, 0x9437},
	{0xe849, 0x9438},
	{0xe84a, 0x9439},
	{0xe84b, 0x943a},
	{0xe84c, 0x943b},
	{0xe84d, 0x943c},
	{0xe84e, 0x943d},
	{0xe84f, 0x943f},
	{0xe850, 0x9440},
	{0xe851, 0x9441},
	{0xe852, 0x9442},
	{0xe853, 0x9443},
	{0xe854, 0x9444},
	{0xe855, 0x9445},
	{0xe856, 0x9446},
	{0xe857, 0x9447},
	{0xe858, 0x9448},
	{0xe859, 0x9449},
	{0xe85a, 0x944a},
	{0xe85b, 0x944b},
	{0xe85c, 0x944c},
	{0xe85d, 0x944d},
	{0xe85e, 0x944e},
	{0xe85f, 0x944f},
	{0xe860, 0x9450},
	{0xe861, 0x9451},
	{0xe862, 0x9452},
	{0xe863, 0x9453},
	{0xe864, 0x9454},
	{0xe865, 0x9455},
	{0xe866, 0x9456},
	{0xe867, 0x9457},
	{0xe868, 0x9458},
	{0xe869, 0x9459},
	{0xe86a, 0x945a},
	{0xe86b, 0x945b},
	{0xe86c, 0x945c},
	{0xe86d, 0x945d},
	{0xe86e, 0x945e},
	{0xe86f, 0x945f},
	{0xe870, 0x9460},
	{0xe871, 0x9461},
	{0xe872, 0x9462},
	{0xe873, 0x9463},
	{0xe874, 0x9464},
	{0xe875, 0x9465},
	{0xe876, 0x9466},
	{0xe877, 0x9467},
	{0xe878, 0x9468},
	{0xe879, 0x9469},
	{0xe87a, 0x946a},
	{0xe87b, 0x946c},
	{0xe87c, 0x946d},
	{0xe87d, 0x946e},
	{0xe87e, 0x946f},
	{0xe880, 0x9470},
	{0xe881, 0x9471},
	{0xe882, 0x9472},
	{0xe883, 0x9473},
	{0xe884, 0x9474},
	{0xe885, 0x9475},
	{0xe886, 0x9476},
	{0xe887, 0x9477},
	{0xe888, 0x9478},
	{0xe889, 0x9479},
	{0xe88a, 0x947a},
	{0xe88b, 0x947b},
	{0xe88c, 0x947c},
	{0xe88d, 0x947d},
	{0xe88e, 0x947e},
	{0xe88f, 0x947f},
	{0xe890, 0x9480},
	{0xe891, 0x9481},
	{0xe892, 0x9482},
	{0xe893, 0x9483},
	{0xe894, 0x9484},
	{0xe895, 0x9491},
	{0xe896, 0x9496},
	{0xe897, 0x9498},
	{0xe898, 0x94c7},
	{0xe899, 0x94cf},
	{0xe89a, 0x94d3},
	{0xe89b, 0x94d4},
	{0xe89c, 0x94da},
	{0xe89d, 0x94e6},
	{0xe89e, 0x94fb},
	{0xe89f, 0x951c},
	{0xe8a0, 0x9520},
	{0xe8a1, 0x741b},
	{0xe8a2, 0x741a},
	{0xe8a3, 0x7441},
	{0xe8a4, 0x745c},
	{0xe8a5, 0x7457},
	{0xe8a6, 0x7455},
	{0xe8a7, 0x7459},
	{0xe8a8, 0x7477},
	{0xe8a9, 0x746d},
	{0xe8aa, 0x747e},
	{0xe8ab, 0x749c},
	{0xe8ac, 0x748e},
	{0xe8ad, 0x7480},
	{0xe8ae, 0x7481},
	{0xe8af, 0x7487},
	{0xe8b0, 0x748b},
	{0xe8b1, 0x749e},
	{0xe8b2, 0x74a8},
	{0xe8b3, 0x74a9},
	{0xe8b4, 0x7490},
	{0xe8b5, 0x74a7},
	{0xe8b6, 0x74d2},
	{0xe8b7, 0x74ba},
	{0xe8b8, 0x97ea},
	{0xe8b9, 0x97eb},
	{0xe8ba, 0x97ec},
	{0xe8bb, 0x674c},
	{0xe8bc, 0x6753},
	{0xe8bd, 0x675e},
	{0xe8be, 0x6748},
	{0xe8bf, 0x6769},
	{0xe8c0, 0x67a5},
	{0xe8c1, 0x6787},
	{0xe8c2, 0x676a},
	{0xe8c3, 0x6773},
	{0xe8c4, 0x6798},
	{0xe8c5, 0x67a7},
	{0xe8c6, 0x6775},
	{0xe8c7, 0x67a8},
	{0xe8c8, 0x679e},
	{0xe8c9, 0x67ad},
	{0xe8ca, 0x678b},
	{0xe8cb, 0x6777},
	{0xe8cc, 0x677c},
	{0xe8cd, 0x67f0},
	{0xe8ce, 0x6809},
	{0xe8cf, 0x67d8},
	{0xe8d0, 0x680a},
	{0xe8d1, 0x67e9},
	{0xe8d2, 0x67b0},
	{0xe8d3, 0x680c},
	{0xe8d4, 0x67d9},
	{0xe8d5, 0x67b5},
	{0xe8d6, 0x67da},
	{0xe8d7, 0x67b3},
	{0xe8d8, 0x67dd},
	{0xe8d9, 0x6800},
	{0xe8da, 0x67c3},
	{0xe8db, 0x67b8},
	{0xe8dc, 0x67e2},
	{0xe8dd, 0x680e},
	{0xe8de, 0x67c1},
	{0xe8df, 0x67fd},
	{0xe8e0, 0x6832},
	{0xe8e1, 0x6833},
	{0xe8e2, 0x6860},
	{0xe8e3, 0x6861},
	{0xe8e4, 0x684e},
	{0xe8e5, 0x6862},
	{0xe8e6, 0x6844},
	{0xe8e7, 0x6864},
	{0xe8e8, 0x6883},
	{0xe8e9, 0x681d},
	{0xe8ea, 0x6855},
	{0xe8eb, 0x6866},
	{0xe8ec, 0x6841},
	{0xe8ed, 0x6867},
	{0xe8ee, 0x6840},
	{0xe8ef, 0x683e},
	{0xe8f0, 0x684a},
	{0xe8f1, 0x6849},
	{0xe8f2, 0x6829},
	{0xe8f3, 0x68b5},
	{0xe8f4, 0x688f},
	{0xe8f5, 0x6874},
	{0xe8f6, 0x6877},
	{0xe8f7, 0x6893},
	{0xe8f8, 0x686b},
	{0xe8f9, 0x68c2},
	{0xe8fa, 0x696e},
	{0xe8fb, 0x68fc},
	{0xe8fc, 0x691f},
	{0xe8fd, 0x6920},
	{0xe8fe, 0x68f9},
	{0xe940, 0x9527},
	{0xe941, 0x9533},
	{0xe942, 0x953d},
	{0xe943, 0x9543},
	{0xe944, 0x9548},
	{0xe945, 0x954b},
	{0xe946, 0x9555},
	{0xe947, 0x955a},
	{0xe948, 0x9560},
	{0xe949, 0x956e},
	{0xe94a, 0x9574},
	{0xe94b, 0x9575},
	{0xe94c, 0x9577},
	{0xe94d, 0x9578},
	{0xe94e, 0x9579},
	{0xe94f, 0x957a},
	{0xe950, 0x957b},
	{0xe951, 0x957c},
	{0xe952, 0x957d},
	{0xe953, 0x957e},
	{0xe954, 0x9580},
	{0xe955, 0x9581},
	{0xe956, 0x9582},
	{0xe957, 0x9583},
	{0xe958, 0x9584},
	{0xe959, 0x9585},
	{0xe95a, 0x9586},
	{0xe95b, 0x9587},
	{0xe95c, 0x9588},
	{0xe95d, 0x9589},
	{0xe95e, 0x958a},
	{0xe95f, 0x958b},
	{0xe960, 0x958c},
	{0xe961, 0x958d},
	{0xe962, 0x958e},
	{0xe963, 0x958f},
	{0xe964, 0x9590},
	{0xe965, 0x9591},
	{0xe966, 0x9592},
	{0xe967, 0x9593},
	{0xe968, 0x9594},
	{0xe969, 0x9595},
	{0xe96a, 0x9596},
	{0xe96b, 0x9597},
	{0xe96c, 0x9598},
	{0xe96d, 0x9599},
	{0xe96e, 0x959a},
	{0xe96f, 0x959b},
	{0xe970, 0x959c},
	{0xe971, 0x959d},
	{0xe972, 0x959e},
	{0xe973, 0x959f},
	{0xe974, 0x95a0},
	{0xe975, 0x95a1},
	{0xe976, 0x95a2},
	{0xe977, 0x95a3},
	{0xe978, 0x95a4},
	{0xe979, 0x95a5},
	{0xe97a, 0x95a6},
	{0xe97b, 0x95a7},
	{0xe97c, 0x95a8},
	{0xe97d, 0x95a9},
	{0xe97e, 0x95aa},
	{0xe980, 0x95ab},
	{0xe981, 0x95ac},
	{0xe982, 0x95ad},
	{0xe983, 0x95ae},
	{0xe984, 0x95af},
	{0xe985, 0x95b0},
	{0xe986, 0x95b1},
	{0xe987, 0x95b2},
	{0xe988, 0x95b3},
	{0xe989, 0x95b4},
	{0xe98a, 0x95b5},
	{0xe98b, 0x95b6},
	{0xe98c, 0x95b7},
	{0xe98d, 0x95b8},
	{0xe98e, 0x95b9},
	{0xe98f, 0x95ba},
	{0xe990, 0x95bb},
	{0xe991, 0x95bc},
	{0xe992, 0x95bd},
	{0xe993, 0x95be},
	{0xe994, 0x95bf},
	{0xe995, 0x95c0},
	{0xe996, 0x95c1},
	{0xe997, 0x95c2},
	{0xe998, 0x95c3},
	{0xe999, 0x95c4},
	{0xe99a, 0x95c5},
	{0xe99b, 0x95c6},
	{0xe99c, 0x95c7},
	{0xe99d, 0x95c8},
	{0xe99e, 0x95c9},
	{0xe99f, 0x95ca},
	{0xe9a0, 0x95cb},
	{0xe9a1, 0x6924},
	{0xe9a2, 0x68f0},
	{0xe9a3, 0x690b},
	{0xe9a4, 0x6901},
	{0xe9a5, 0x6957},
	{0xe9a6, 0x68e3},
	{0xe9a7, 0x6910},
	{0xe9a8, 0x6971},
	{0xe9a9, 0x6939},
	{0xe9aa, 0x6960},
	{0xe9ab, 0x6942},
	{0xe9ac, 0x695d},
	{0xe9ad, 0x6984},
	{0xe9ae, 0x696b},
	{0xe9af, 0x6980},
	{0xe9b0, 0x6998},
	{0xe9b1, 0x6978},
	{0xe9b2, 0x6934},
	{0xe9b3, 0x69cc},
	{0xe9b4, 0x6987},
	{0xe9b5, 0x6988},
	{0xe9b6, 0x69ce},
	{0xe9b7, 0x6989},
	{0xe9b8, 0x6966},
	{0xe9b9, 0x6963},
	{0xe9ba, 0x6979},
	{0xe9bb, 0x699b},
	{0xe9bc, 0x69a7},
	{0xe9bd, 0x69bb},
	{0xe9be, 0x69ab},
	{0xe9bf, 0x69ad},
	{0xe9c0, 0x69d4},
	{0xe9c1, 0x69b1},
	{0xe9c2, 0x69c1},
	{0xe9c3, 0x69ca},
	{0xe9c4, 0x69df},
	{0xe9c5, 0x6995},
	{0xe9c6, 0x69e0},
	{0xe9c7, 0x698d},
	{0xe9c8, 0x69ff},
	{0xe9c9, 0x6a2f},
	{0xe9ca, 0x69ed},
	{0xe9cb, 0x6a17},
	{0xe9cc, 0x6a18},
	{0xe9cd, 0x6a65},
	{0xe9ce, 0x69f2},
	{0xe9cf, 0x6a44},
	{0xe9d0, 0x6a3e},
	{0xe9d1, 0x6aa0},
	{0xe9d2, 0x6a50},
	{0xe9d3, 0x6a5b},
	{0xe9d4, 0x6a35},
	{0xe9d5, 0x6a8e},
	{0xe9d6, 0x6a79},
	{0xe9d7, 0x6a3d},
	{0xe9d8, 0x6a28},
	{0xe9d9, 0x6a58},
	{0xe9da, 0x6a7c},
	{0xe9db, 0x6a91},
	{0xe9dc, 0x6a90},
	{0xe9dd, 0x6aa9},
	{0xe9de, 0x6a97},
	{0xe9df, 0x6aab},
	{0xe9e0, 0x7337},
	{0xe9e1, 0x7352},
	{0xe9e2, 0x6b81},
	{0xe9e3, 0x6b82},
	{0xe9e4, 0x6b87},
	{0xe9e5, 0x6b84},
	{0xe9e6, 0x6b92},
	{0xe9e7, 0x6b93},
	{0xe9e8, 0x6b8d},
	{0xe9e9, 0x6b9a},
	{0xe9ea, 0x6b9b},
	{0xe9eb, 0x6ba1},
	{0xe9ec, 0x6baa},
	{0xe9ed, 0x8f6b},
	{0xe9ee, 0x8f6d},
	{0xe9ef, 0x8f71},
	{0xe9f0, 0x8f72},
	{0xe9f1, 0x8f73},
	{0xe9f2, 0x8f75},
	{0xe9f3, 0x8f76},
	{0xe9f4, 0x8f78},
	{0xe9f5, 0x8f77},
	{0xe9f6, 0x8f79},
	{0xe9f7, 0x8f7a},
	{0xe9f8, 0x8f7c},
	{0xe9f9, 0x8f7e},
	{0xe9fa, 0x8f81},
	{0xe9fb, 0x8f82},
	{0xe9fc, 0x8f84},
	{0xe9fd, 0x8f87},
	{0xe9fe, 0x8f8b},
	{0xea40, 0x95cc},
	{0xea41, 0x95cd},
	{0xea42, 0x95ce},
	{0xea43, 0x95cf},
	{0xea44, 0x95d0},
	{0xea45, 0x95d1},
	{0xea46, 0x95d2},
	{0xea47, 0x95d3},
	{0xea48, 0x95d4},
	{0xea49, 0x95d5},
	{0xea4a, 0x95d6},
	{0xea4b, 0x95d7},
	{0xea4c, 0x95d8},
	{0xea4d, 0x95d9},
	{0xea4e, 0x95da},
	{0xea4f, 0x95db},
	{0xea50, 0x95dc},
	{0xea51, 0x95dd},
	{0xea52, 0x95de},
	{0xea53, 0x95df},
	{0xea54, 0x95e0},
	{0xea55, 0x95e1},
	{0xea56, 0x95e2},
	{0xea57, 0x95e3},
	{0xea58, 0x95e4},
	{0xea59, 0x95e5},
	{0xea5a, 0x95e6},
	{0xea5b, 0x95e7},
	{0xea5c, 0x95ec},
	{0xea5d, 0x95ff},
	{0xea5e, 0x9607},
	{0xea5f, 0x9613},
	{0xea60, 0x9618},
	{0xea61, 0x961b},
	{0xea62, 0x961e},
	{0xea63, 0x9620},
	{0xea64, 0x9623},
	{0xea65, 0x9624},
	{0xea66, 0x9625},
	{0xea67, 0x9626},
	{0xea68, 0x9627},
	{0xea69, 0x9628},
	{0xea6a, 0x9629},
	{0xea6b, 0x962b},
	{0xea6c, 0x962c},
	{0xea6d, 0x962d},
	{0xea6e, 0x962f},
	{0xea6f, 0x9630},
	{0xea70, 0x9637},
	{0xea71, 0x9638},
	{0xea72, 0x9639},
	{0xea73, 0x963a},
	{0xea74, 0x963e},
	{0xea75, 0x9641},
	{0xea76, 0x9643},
	{0xea77, 0x964a},
	{0xea78, 0x964e},
	{0xea79, 0x964f},
	{0xea7a, 0x9651},
	{0xea7b, 0x9652},
	{0xea7c, 0x9653},
	{0xea7d, 0x9656},
	{0xea7e, 0x9657},
	{0xea80, 0x9658},
	{0xea81, 0x9659},
	{0xea82, 0x965a},
	{0xea83, 0x965c},
	{0xea84, 0x965d},
	{0xea85, 0x965e},
	{0xea86, 0x9660},
	{0xea87, 0x9663},
	{0xea88, 0x9665},
	{0xea89, 0x9666},
	{0xea8a, 0x966b},
	{0xea8b, 0x966d},
	{0xea8c, 0x966e},
	{0xea8d, 0x966f},
	{0xea8e, 0x9670},
	{0xea8f, 0x9671},
	{0xea90, 0x9673},
	{0xea91, 0x9678},
	{0xea92, 0x9679},
	{0xea93, 0x967a},
	{0xea94, 0x967b},
	{0xea95, 0x967c},
	{0xea96, 0x967d},
	{0xea97, 0x967e},
	{0xea98, 0x967f},
	{0xea99, 0x9680},
	{0xea9a, 0x9681},
	{0xea9b, 0x9682},
	{0xea9c, 0x9683},
	{0xea9d, 0x9684},
	{0xea9e, 0x9687},
	{0xea9f, 0x9689},
	{0xeaa0, 0x968a},
	{0xeaa1, 0x8f8d},
	{0xeaa2, 0x8f8e},
	{0xeaa3, 0x8f8f},
	{0xeaa4, 0x8f98},
	{0xeaa5, 0x8f9a},
	{0xeaa6, 0x8ece},
	{0xeaa7, 0x620b},
	{0xeaa8, 0x6217},
	{0xeaa9, 0x621b},
	{0xeaaa, 0x621f},
	{0xeaab, 0x6222},
	{0xeaac, 0x6221},
	{0xeaad, 0x6225},
	{0xeaae, 0x6224},
	{0xeaaf, 0x622c},
	{0xeab0, 0x81e7},
	{0xeab1, 0x74ef},
	{0xeab2, 0x74f4},
	{0xeab3, 0x74ff},
	{0xeab4, 0x750f},
	{0xeab5, 0x7511},
	{0xeab6, 0x7513},
	{0xeab7, 0x6534},
	{0xeab8, 0x65ee},
	{0xeab9, 0x65ef},
	{0xeaba, 0x65f0},
	{0xeabb, 0x660a},
	{0xeabc, 0x6619},
	{0xeabd, 0x6772},
	{0xeabe, 0x6603},
	{0xeabf, 0x6615},
	{0xeac0, 0x6600},
	{0xeac1, 0x7085},
	{0xeac2, 0x66f7},
	{0xeac3, 0x661d},
	{0xeac4, 0x6634},
	{0xeac5, 0x6631},
	{0xeac6, 0x6636},
	{0xeac7, 0x6635},
	{0xeac8, 0x8006},
	{0xeac9, 0x665f},
	{0xeaca, 0x6654},
	{0xeacb, 0x6641},
	{0xeacc, 0x664f},
	{0xeacd, 0x6656},
	{0xeace, 0x6661},
	{0xeacf, 0x6657},
	{0xead0, 0x6677},
	{0xead1, 0x6684},
	{0xead2, 0x668c},
	{0xead3, 0x66a7},
	{0xead4, 0x669d},
	{0xead5, 0x66be},
	{0xead6, 0x66db},
	{0xead7, 0x66dc},
	{0xead8, 0x66e6},
	{0xead9, 0x66e9},
	{0xeada, 0x8d32},
	{0xeadb, 0x8d33},
	{0xeadc, 0x8d36},
	{0xeadd, 0x8d3b},
	{0xeade, 0x8d3d},
	{0xeadf, 0x8d40},
	{0xeae0, 0x8d45},
	{0xeae1, 0x8d46},
	{0xeae2, 0x8d48},
	{0xeae3, 0x8d49},
	{0xeae4, 0x8d47},
	{0xeae5, 0x8d4d},
	{0xeae6, 0x8d55},
	{0xeae7, 0x8d59},
	{0xeae8, 0x89c7},
	{0xeae9, 0x89ca},
	{0xeaea, 0x89cb},
	{0xeaeb, 0x89cc},
	{0xeaec, 0x89ce},
	{0xeaed, 0x89cf},
	{0xeaee, 0x89d0},
	{0xeaef, 0x89d1},
	{0xeaf0, 0x726e},
	{0xeaf1, 0x729f},
	{0xeaf2, 0x725d},
	{0xeaf3, 0x7266},
	{0xeaf4, 0x726f},
	{0xeaf5, 0x727e},
	{0xeaf6, 0x727f},
	{0xeaf7, 0x7284},
	{0xeaf8, 0x728b},
	{0xeaf9, 0x728d},
	{0xeafa, 0x728f},
	{0xeafb, 0x7292},
	{0xeafc, 0x6308},
	{0xeafd, 0x6332},
	{0xeafe, 0x63b0},
	{0xeb40, 0x968c},
	{0xeb41, 0x968e},
	{0xeb42, 0x9691},
	{0xeb43, 0x9692},
	{0xeb44, 0x9693},
	{0xeb45, 0x9695},
	{0xeb46, 0x9696},
	{0xeb47, 0x969a},
	{0xeb48, 0x969b},
	{0xeb49, 0x969d},
	{0xeb4a, 0x969e},
	{0xeb4b, 0x969f},
	{0xeb4c, 0x96a0},
	{0xeb4d, 0x96a1},
	{0xeb4e, 0x96a2},
	{0xeb4f, 0x96a3},
	{0xeb50, 0x96a4},
	{0xeb51, 0x96a5},
	{0xeb52, 0x96a6},
	{0xeb53, 0x96a8},
	{0xeb54, 0x96a9},
	{0xeb55, 0x96aa},
	{0xeb56, 0x96ab},
	{0xeb57, 0x96ac},
	{0xeb58, 0x96ad},
	{0xeb59, 0x96ae},
	{0xeb5a, 0x96af},
	{0xeb5b, 0x96b1},
	{0xeb5c, 0x96b2},
	{0xeb5d, 0x96b4},
	{0xeb5e, 0x96b5},
	{0xeb5f, 0x96b7},
	{0xeb60, 0x96b8},
	{0xeb61, 0x96ba},
	{0xeb62, 0x96bb},
	{0xeb63, 0x96bf},
	{0xeb64, 0x96c2},
	{0xeb65, 0x96c3},
	{0xeb66, 0x96c8},
	{0xeb67, 0x96ca},
	{0xeb68, 0x96cb},
	{0xeb69, 0x96d0},
	{0xeb6a, 0x96d1},
	{0xeb6b, 0x96d3},
	{0xeb6c, 0x96d4},
	{0xeb6d, 0x96d6},
	{0xeb6e, 0x96d7},
	{0xeb6f, 0x96d8},
	{0xeb70, 0x96d9},
	{0xeb71, 0x96da},
	{0xeb72, 0x96db},
	{0xeb73, 0x96dc},
	{0xeb74, 0x96dd},
	{0xeb75, 0x96de},
	{0xeb76, 0x96df},
	{0xeb77, 0x96e1},
	{0xeb78, 0x96e2},
	{0xeb79, 0x96e3},
	{0xeb7a, 0x96e4},
	{0xeb7b, 0x96e5},
	{0xeb7c, 0x96e6},
	{0xeb7d, 0x96e7},
	{0xeb7e, 0x96eb},
	{0xeb80, 0x96ec},
	{0xeb81, 0x96ed},
	{0xeb82, 0x96ee},
	{0xeb83, 0x96f0},
	{0xeb84, 0x96f1},
	{0xeb85, 0x96f2},
	{0xeb86, 0x96f4},
	{0xeb87, 0x96f5},
	{0xeb88, 0x96f8},
	{0xeb89, 0x96fa},
	{0xeb8a, 0x96fb},
	{0xeb8b, 0x96fc},
	{0xeb8c, 0x96fd},
	{0xeb8d, 0x96ff},
	{0xeb8e, 0x9702},
	{0xeb8f, 0x9703},
	{0xeb90, 0x9705},
	{0xeb91, 0x970a},
	{0xeb92, 0x970b},
	{0xeb93, 0x970c},
	{0xeb94, 0x9710},
	{0xeb95, 0x9711},
	{0xeb96, 0x9712},
	{0xeb97, 0x9714},
	{0xeb98, 0x9715},
	{0xeb99, 0x9717},
	{0xeb9a, 0x9718},
	{0xeb9b, 0x9719},
	{0xeb9c, 0x971a},
	{0xeb9d, 0x971b},
	{0xeb9e, 0x971d},
	{0xeb9f, 0x971f},
	{0xeba0, 0x9720},
	{0xeba1, 0x643f},
	{0xeba2, 0x64d8},
	{0xeba3, 0x8004},
	{0xeba4, 0x6bea},
	{0xeba5, 0x6bf3},
	{0xeba6, 0x6bfd},
	{0xeba7, 0x6bf5},
	{0xeba8, 0x6bf9},
	{0xeba9, 0x6c05},
	{0xebaa, 0x6c07},
	{0xebab, 0x6c06},
	{0xebac, 0x6c0d},
	{0xebad, 0x6c15},
	{0xebae, 0x6c18},
	{0xebaf, 0x6c19},
	{0xebb0, 0x6c1a},
	{0xebb1, 0x6c21},
	{0xebb2, 0x6c29},
	{0xebb3, 0x6c24},
	{0xebb4, 0x6c2a},
	{0xebb5, 0x6c32},
	{0xebb6, 0x6535},
	{0xebb7, 0x6555},
	{0xebb8, 0x656b},
	{0xebb9, 0x724d},
	{0xebba, 0x7252},
	{0xebbb, 0x7256},
	{0xebbc, 0x7230},
	{0xebbd, 0x8662},
	{0xebbe, 0x5216},
	{0xebbf, 0x809f},
	{0xebc0, 0x809c},
	{0xebc1, 0x8093},
	{0xebc2, 0x80bc},
	{0xebc3, 0x670a},
	{0xebc4, 0x80bd},
	{0xebc5, 0x80b1},
	{0xebc6, 0x80ab},
	{0xebc7, 0x80ad},
	{0xebc8, 0x80b4},
	{0xebc9, 0x80b7},
	{0xebca, 0x80e7},
	{0xebcb, 0x80e8},
	{0xebcc, 0x80e9},
	{0xebcd, 0x80ea},
	{0xebce, 0x80db},
	{0xebcf, 0x80c2},
	{0xebd0, 0x80c4},
	{0xebd1, 0x80d9},
	{0xebd2, 0x80cd},
	{0xebd3, 0x80d7},
	{0xebd4, 0x6710},
	{0xebd5, 0x80dd},
	{0xebd6, 0x80eb},
	{0xebd7, 0x80f1},
	{0xebd8, 0x80f4},
	{0xebd9, 0x80ed},
	{0xebda, 0x810d},
	{0xebdb, 0x810e},
	{0xebdc, 0x80f2},
	{0xebdd, 0x80fc},
	{0xebde, 0x6715},
	{0xebdf, 0x8112},
	{0xebe0, 0x8c5a},
	{0xebe1, 0x8136},
	{0xebe2, 0x811e},
	{0xebe3, 0x812c},
	{0xebe4, 0x8118},
	{0xebe5, 0x8132},
	{0xebe6, 0x8148},
	{0xebe7, 0x814c},
	{0xebe8, 0x8153},
	{0xebe9, 0x8174},
	{0xebea, 0x8159},
	{0xebeb, 0x815a},
	{0xebec, 0x8171},
	{0xebed, 0x8160},
	{0xebee, 0x8169},
	{0xebef, 0x817c},
	{0xebf0, 0x817d},
	{0xebf1, 0x816d},
	{0xebf2, 0x8167},
	{0xebf3, 0x584d},
	{0xebf4, 0x5ab5},
	{0xebf5, 0x8188},
	{0xebf6, 0x8182},
	{0xebf7, 0x8191},
	{0xebf8, 0x6ed5},
	{0xebf9, 0x81a3},
	{0xebfa, 0x81aa},
	{0xebfb, 0x81cc},
	{0xebfc, 0x6726},
	{0xebfd, 0x81ca},
	{0xebfe, 0x81bb},
	{0xec40, 0x9721},
	{0xec41, 0x9722},
	{0xec42, 0x9723},
	{0xec43, 0x9724},
	{0xec44, 0x9725},
	{0xec45, 0x9726},
	{0xec46, 0x9727},
	{0xec47, 0x9728},
	{0xec48, 0x9729},
	{0xec49, 0x972b},
	{0xec4a, 0x972c},
	{0xec4b, 0x972e},
	{0xec4c, 0x972f},
	{0xec4d, 0x9731},
	{0xec4e, 0x9733},
	{0xec4f, 0x9734},
	{0xec50, 0x9735},
	{0xec51, 0x9736},
	{0xec52, 0x9737},
	{0xec53, 0x973a},
	{0xec54, 0x973b},
	{0xec55, 0x973c},
	{0xec56, 0x973d},
	{0xec57, 0x973f},
	{0xec58, 0x9740},
	{0xec59, 0x9741},
	{0xec5a, 0x9742},
	{0xec5b, 0x9743},
	{0xec5c, 0x9744},
	{0xec5d, 0x9745},
	{0xec5e, 0x9746},
	{0xec5f, 0x9747},
	{0xec60, 0x9748},
	{0xec61, 0x9749},
	{0xec62, 0x974a},
	{0xec63, 0x974b},
	{0xec64, 0x974c},
	{0xec65, 0x974d},
	{0xec66, 0x974e},
	{0xec67, 0x974f},
	{0xec68, 0x9750},
	{0xec69, 0x9751},
	{0xec6a, 0x9754},
	{0xec6b, 0x9755},
	{0xec6c, 0x9757},
	{0xec6d, 0x9758},
	{0xec6e, 0x975a},
	{0xec6f, 0x975c},
	{0xec70, 0x975d},
	{0xec71, 0x975f},
	{0xec72, 0x9763},
	{0xec73, 0x9764},
	{0xec74, 0x9766},
	{0xec75, 0x9767},
	{0xec76, 0x9768},
	{0xec77, 0x976a},
	{0xec78, 0x976b},
	{0xec79, 0x976c},
	{0xec7a, 0x976d},
	{0xec7b, 0x976e},
	{0xec7c, 0x976f},
	{0xec7d, 0x9770},
	{0xec7e, 0x9771},
	{0xec80, 0x9772},
	{0xec81, 0x9775},
	{0xec82, 0x9777},
	{0xec83, 0x9778},
	{0xec84, 0x9779},
	{0xec85, 0x977a},
	{0xec86, 0x977b},
	{0xec87, 0x977d},
	{0xec88, 0x977e},
	{0xec89, 0x977f},
	{0xec8a, 0x9780},
	{0xec8b, 0x9781},
	{0xec8c, 0x9782},
	{0xec8d, 0x9783},
	{0xec8e, 0x9784},
	{0xec8f, 0x9786},
	{0xec90, 0x9787},
	{0xec91, 0x9788},
	{0xec92, 0x9789},
	{0xec93, 0x978a},
	{0xec94, 0x978c},
	{0xec95, 0x978e},
	{0xec96, 0x978f},
	{0xec97, 0x9790},
	{0xec98, 0x9793},
	{0xec99, 0x9795},
	{0xec9a, 0x9796},
	{0xec9b, 0x9797},
	{0xec9c, 0x9799},
	{0xec9d, 0x979a},
	{0xec9e, 0x979b},
	{0xec9f, 0x979c},
	{0xeca0, 0x979d},
	{0xeca1, 0x81c1},
	{0xeca2, 0x81a6},
	{0xeca3, 0x6b24},
	{0xeca4, 0x6b37},
	{0xeca5, 0x6b39},
	{0xeca6, 0x6b43},
	{0xeca7, 0x6b46},
	{0xeca8, 0x6b59},
	{0xeca9, 0x98d1},
	{0xecaa, 0x98d2},
	{0xecab, 0x98d3},
	{0xecac, 0x98d5},
	{0xecad, 0x98d9},
	{0xecae, 0x98da},
	{0xecaf, 0x6bb3},
	{0xecb0, 0x5f40},
	{0xecb1, 0x6bc2},
	{0xecb2, 0x89f3},
	{0xecb3, 0x6590},
	{0xecb4, 0x9f51},
	{0xecb5, 0x6593},
	{0xecb6, 0x65bc},
	{0xecb7, 0x65c6},
	{0xecb8, 0x65c4},
	{0xecb9, 0x65c3},
	{0xecba, 0x65cc},
	{0xecbb, 0x65ce},
	{0xecbc, 0x65d2},
	{0xecbd, 0x65d6},
	{0xecbe, 0x7080},
	{0xecbf, 0x709c},
	{0xecc0, 0x7096},
	{0xecc1, 0x709d},
	{0xecc2, 0x70bb},
	{0xecc3, 0x70c0},
	{0xecc4, 0x70b7},
	{0xecc5, 0x70ab},
	{0xecc6, 0x70b1},
	{0xecc7, 0x70e8},
	{0xecc8, 0x70ca},
	{0xecc9, 0x7110},
	{0xecca, 0x7113},
	{0xeccb, 0x7116},
	{0xeccc, 0x712f},
	{0xeccd, 0x7131},
	{0xecce, 0x7173},
	{0xeccf, 0x715c},
	{0xecd0, 0x7168},
	{0xecd1, 0x7145},
	{0xecd2, 0x7172},
	{0xecd3, 0x714a},
	{0xecd4, 0x7178},
	{0xecd5, 0x717a},
	{0xecd6, 0x7198},
	{0xecd7, 0x71b3},
	{0xecd8, 0x71b5},
	{0xecd9, 0x71a8},
	{0xecda, 0x71a0},
	{0xecdb, 0x71e0},
	{0xecdc, 0x71d4},
	{0xecdd, 0x71e7},
	{0xecde, 0x71f9},
	{0xecdf, 0x721d},
	{0xece0, 0x7228},
	{0xece1, 0x706c},
	{0xece2, 0x7118},
	{0xece3, 0x7166},
	{0xece4, 0x71b9},
	{0xece5, 0x623e},
	{0xece6, 0x623d},
	{0xece7, 0x6243},
	{0xece8, 0x6248},
	{0xece9, 0x6249},
	{0xecea, 0x793b},
	{0xeceb, 0x7940},
	{0xecec, 0x7946},
	{0xeced, 0x7949},
	{0xecee, 0x795b},
	{0xecef, 0x795c},
	{0xecf0, 0x7953},
	{0xecf1, 0x795a},
	{0xecf2, 0x7962},
	{0xecf3, 0x7957},
	{0xecf4, 0x7960},
	{0xecf5, 0x796f},
	{0xecf6, 0x7967},
	{0xecf7, 0x797a},
	{0xecf8, 0x7985},
	{0xecf9, 0x798a},
	{0xecfa, 0x799a},
	{0xecfb, 0x79a7},
	{0xecfc, 0x79b3},
	{0xecfd, 0x5fd1},
	{0xecfe, 0x5fd0},
	{0xed40, 0x979e},
	{0xed41, 0x979f},
	{0xed42, 0x97a1},
	{0xed43, 0x97a2},
	{0xed44, 0x97a4},
	{0xed45, 0x97a5},
	{0xed46, 0x97a6},
	{0xed47, 0x97a7},
	{0xed48, 0x97a8},
	{0xed49, 0x97a9},
	{0xed4a, 0x97aa},
	{0xed4b, 0x97ac},
	{0xed4c, 0x97ae},
	{0xed4d, 0x97b0},
	{0xed4e, 0x97b1},
	{0xed4f, 0x97b3},
	{0xed50, 0x97b5},
	{0xed51, 0x97b6},
	{0xed52, 0x97b7},
	{0xed53, 0x97b8},
	{0xed54, 0x97b9},
	{0xed55, 0x97ba},
	{0xed56, 0x97bb},
	{0xed57, 0x97bc},
	{0xed58, 0x97bd},
	{0xed59, 0x97be},
	{0xed5a, 0x97bf},
	{0xed5b, 0x97c0},
	{0xed5c, 0x97c1},
	{0xed5d, 0x97c2},
	{0xed5e, 0x97c3},
	{0xed5f, 0x97c4},
	{0xed60, 0x97c5},
	{0xed61, 0x97c6},
	{0xed62, 0x97c7},
	{0xed63, 0x97c8},
	{0xed64, 0x97c9},
	{0xed65, 0x97ca},
	{0xed66, 0x97cb},
	{0xed67, 0x97cc},
	{0xed68, 0x97cd},
	{0xed69, 0x97ce},
	{0xed6a, 0x97cf},
	{0xed6b, 0x97d0},
	{0xed6c, 0x97d1},
	{0xed6d, 0x97d2},
	{0xed6e, 0x97d3},
	{0xed6f, 0x97d4},
	{0xed70, 0x97d5},
	{0xed71, 0x97d6},
	{0xed72, 0x97d7},
	{0xed73, 0x97d8},
	{0xed74, 0x97d9},
	{0xed75, 0x97da},
	{0xed76, 0x97db},
	{0xed77, 0x97dc},
	{0xed78, 0x97dd},
	{0xed79, 0x97de},
	{0xed7a, 0x97df},
	{0xed7b, 0x97e0},
	{0xed7c, 0x97e1},
	{0xed7d, 0x97e2},
	{0xed7e, 0x97e3},
	{0xed80, 0x97e4},
	{0xed81, 0x97e5},
	{0xed82, 0x97e8},
	{0xed83, 0x97ee},
	{0xed84, 0x97ef},
	{0xed85, 0x97f0},
	{0xed86, 0x97f1},
	{0xed87, 0x97f2},
	{0xed88, 0x97f4},
	{0xed89, 0x97f7},
	{0xed8a, 0x97f8},
	{0xed8b, 0x97f9},
	{0xed8c, 0x97fa},
	{0xed8d, 0x97fb},
	{0xed8e, 0x97fc},
	{0xed8f, 0x97fd},
	{0xed90, 0x97fe},
	{0xed91, 0x97ff},
	{0xed92, 0x9800},
	{0xed93, 0x9801},
	{0xed94, 0x9802},
	{0xed95, 0x9803},
	{0xed96, 0x9804},
	{0xed97, 0x9805},
	{0xed98, 0x9806},
	{0xed99, 0x9807},
	{0xed9a, 0x9808},
	{0xed9b, 0x9809},
	{0xed9c, 0x980a},
	{0xed9d, 0x980b},
	{0xed9e, 0x980c},
	{0xed9f, 0x980d},
	{0xeda0, 0x980e},
	{0xeda1, 0x603c},
	{0xeda2, 0x605d},
	{0xeda3, 0x605a},
	{0xeda4, 0x6067},
	{0xeda5, 0x6041},
	{0xeda6, 0x6059},
	{0xeda7, 0x6063},
	{0xeda8, 0x60ab},
	{0xeda9, 0x6106},
	{0xedaa, 0x610d},
	{0xedab, 0x615d},
	{0xedac, 0x61a9},
	{0xedad, 0x619d},
	{0xedae, 0x61cb},
	{0xedaf, 0x61d1},
	{0xedb0, 0x6206},
	{0xedb1, 0x8080},
	{0xedb2, 0x807f},
	{0xedb3, 0x6c93},
	{0xedb4, 0x6cf6},
	{0xedb5, 0x6dfc},
	{0xedb6, 0x77f6},
	{0xedb7, 0x77f8},
	{0xedb8, 0x7800},
	{0xedb9, 0x7809},
	{0xedba, 0x7817},
	{0xedbb, 0x7818},
	{0xedbc, 0x7811},
	{0xedbd, 0x65ab},
	{0xedbe, 0x782d},
	{0xedbf, 0x781c},
	{0xedc0, 0x781d},
	{0xedc1, 0x7839},
	{0xedc2, 0x783a},
	{0xedc3, 0x783b},
	{0xedc4, 0x781f},
	{0xedc5, 0x783c},
	{0xedc6, 0x7825},
	{0xedc7, 0x782c},
	{0xedc8, 0x7823},
	{0xedc9, 0x7829},
	{0xedca, 0x784e},
	{0xedcb, 0x786d},
	{0xedcc, 0x7856},
	{0xedcd, 0x7857},
	{0xedce, 0x7826},
	{0xedcf, 0x7850},
	{0xedd0, 0x7847},
	{0xedd1, 0x784c},
	{0xedd2, 0x786a},
	{0xedd3, 0x789b},
	{0xedd4, 0x7893},
	{0xedd5, 0x789a},
	{0xedd6, 0x7887},
	{0xedd7, 0x789c},
	{0xedd8, 0x78a1},
	{0xedd9, 0x78a3},
	{0xedda, 0x78b2},
	{0xeddb, 0x78b9},
	{0xeddc, 0x78a5},
	{0xeddd, 0x78d4},
	{0xedde, 0x78d9},
	{0xeddf, 0x78c9},
	{0xede0, 0x78ec},
	{0xede1, 0x78f2},
	{0xede2, 0x7905},
	{0xede3, 0x78f4},
	{0xede4, 0x7913},
	{0xede5, 0x7924},
	{0xede6, 0x791e},
	{0xede7, 0x7934},
	{0xede8, 0x9f9b},
	{0xede9, 0x9ef9},
	{0xedea, 0x9efb},
	{0xedeb, 0x9efc},
	{0xedec, 0x76f1},
	{0xeded, 0x7704},
	{0xedee, 0x770d},
	{0xedef, 0x76f9},
	{0xedf0, 0x7707},
	{0xedf1, 0x7708},
	{0xedf2, 0x771a},
	{0xedf3, 0x7722},
	{0xedf4, 0x7719},
	{0xedf5, 0x772d},
	{0xedf6, 0x7726},
	{0xedf7, 0x7735},
	{0xedf8, 0x7738},
	{0xedf9, 0x7750},
	{0xedfa, 0x7751},
	{0xedfb, 0x7747},
	{0xedfc, 0x7743},
	{0xedfd, 0x775a},
	{0xedfe, 0x7768},
	{0xee40, 0x980f},
	{0xee41, 0x9810},
	{0xee42, 0x9811},
	{0xee43, 0x9812},
	{0xee44, 0x9813},
	{0xee45, 0x9814},
	{0xee46, 0x9815},
	{0xee47, 0x9816},
	{0xee48, 0x9817},
	{0xee49, 0x9818},
	{0xee4a, 0x9819},
	{0xee4b, 0x981a},
	{0xee4c, 0x981b},
	{0xee4d, 0x981c},
	{0xee4e, 0x981d},
	{0xee4f, 0x981e},
	{0xee50, 0x981f},
	{0xee51, 0x9820},
	{0xee52, 0x9821},
	{0xee53, 0x9822},
	{0xee54, 0x9823},
	{0xee55, 0x9824},
	{0xee56, 0x9825},
	{0xee57, 0x9826},
	{0xee58, 0x9827},
	{0xee59, 0x9828},
	{0xee5a, 0x9829},
	{0xee5b, 0x982a},
	{0xee5c, 0x982b},
	{0xee5d, 0x982c},
	{0xee5e, 0x982d},
	{0xee5f, 0x982e},
	{0xee60, 0x982f},
	{0xee61, 0x9830},
	{0xee62, 0x9831},
	{0xee63, 0x9832},
	{0xee64, 0x9833},
	{0xee65, 0x9834},
	{0xee66, 0x9835},
	{0xee67, 0x9836},
	{0xee68, 0x9837},
	{0xee69, 0x9838},
	{0xee6a, 0x9839},
	{0xee6b, 0x983a},
	{0xee6c, 0x983b},
	{0xee6d, 0x983c},
	{0xee6e, 0x983d},
	{0xee6f, 0x983e},
	{0xee70, 0x983f},
	{0xee71, 0x9840},
	{0xee72, 0x9841},
	{0xee73, 0x9842},
	{0xee74, 0x9843},
	{0xee75, 0x9844},
	{0xee76, 0x9845},
	{0xee77, 0x9846},
	{0xee78, 0x9847},
	{0xee79, 0x9848},
	{0xee7a, 0x9849},
	{0xee7b, 0x984a},
	{0xee7c, 0x984b},
	{0xee7d, 0x984c},
	{0xee7e, 0x984d},
	{0xee80, 0x984e},
	{0xee81, 0x984f},
	{0xee82, 0x9850},
	{0xee83, 0x9851},
	{0xee84, 0x9852},
	{0xee85, 0x9853},
	{0xee86, 0x9854},
	{0xee87, 0x9855},
	{0xee88, 0x9856},
	{0xee89, 0x9857},
	{0xee8a, 0x9858},
	{0xee8b, 0x9859},
	{0xee8c, 0x985a},
	{0xee8d, 0x985b},
	{0xee8e, 0x985c},
	{0xee8f, 0x985d},
	{0xee90, 0x985e},
	{0xee91, 0x985f},
	{0xee92, 0x9860},
	{0xee93, 0x9861},
	{0xee94, 0x9862},
	{0xee95, 0x9863},
	{0xee96, 0x9864},
	{0xee97, 0x9865},
	{0xee98, 0x9866},
	{0xee99, 0x9867},
	{0xee9a, 0x9868},
	{0xee9b, 0x9869},
	{0xee9c, 0x986a},
	{0xee9d, 0x986b},
	{0xee9e, 0x986c},
	{0xee9f, 0x986d},
	{0xeea0, 0x986e},
	{0xeea1, 0x7762},
	{0xeea2, 0x7765},
	{0xeea3, 0x777f},
	{0xeea4, 0x778d},
	{0xeea5, 0x777d},
	{0xeea6, 0x7780},
	{0xeea7, 0x778c},
	{0xeea8, 0x7791},
	{0xeea9, 0x779f},
	{0xeeaa, 0x77a0},
	{0xeeab, 0x77b0},
	{0xeeac, 0x77b5},
	{0xeead, 0x77bd},
	{0xeeae, 0x753a},
	{0xeeaf, 0x7540},
	{0xeeb0, 0x754e},
	{0xeeb1, 0x754b},
	{0xeeb2, 0x7548},
	{0xeeb3, 0x755b},
	{0xeeb4, 0x7572},
	{0xeeb5, 0x7579},
	{0xeeb6, 0x7583},
	{0xeeb7, 0x7f58},
	{0xeeb8, 0x7f61},
	{0xeeb9, 0x7f5f},
	{0xeeba, 0x8a48},
	{0xeebb, 0x7f68},
	{0xeebc, 0x7f74},
	{0xeebd, 0x7f71},
	{0xeebe, 0x7f79},
	{0xeebf, 0x7f81},
	{0xeec0, 0x7f7e},
	{0xeec1, 0x76cd},
	{0xeec2, 0x76e5},
	{0xeec3, 0x8832},
	{0xeec4, 0x9485},
	{0xeec5, 0x9486},
	{0xeec6, 0x9487},
	{0xeec7, 0x948b},
	{0xeec8, 0x948a},
	{0xeec9, 0x948c},
	{0xeeca, 0x948d},
	{0xeecb, 0x948f},
	{0xeecc, 0x9490},
	{0xeecd, 0x9494},
	{0xeece, 0x9497},
	{0xeecf, 0x9495},
	{0xeed0, 0x949a},
	{0xeed1, 0x949b},
	{0xeed2, 0x949c},
	{0xeed3, 0x94a3},
	{0xeed4, 0x94a4},
	{0xeed5, 0x94ab},
	{0xeed6, 0x94aa},
	{0xeed7, 0x94ad},
	{0xeed8, 0x94ac},
	{0xeed9, 0x94af},
	{0xeeda, 0x94b0},
	{0xeedb, 0x94b2},
	{0xeedc, 0x94b4},
	{0xeedd, 0x94b6},
	{0xeede, 0x94b7},
	{0xeedf, 0x94b8},
	{0xeee0, 0x94b9},
	{0xeee1, 0x94ba},
	{0xeee2, 0x94bc},
	{0xeee3, 0x94bd},
	{0xeee4, 0x94bf},
	{0xeee5, 0x94c4},
	{0xeee6, 0x94c8},
	{0xeee7, 0x94c9},
	{0xeee8, 0x94ca},
	{0xeee9, 0x94cb},
	{0xeeea, 0x94cc},
	{0xeeeb, 0x94cd},
	{0xeeec, 0x94ce},
	{0xeeed, 0x94d0},
	{0xeeee, 0x94d1},
	{0xeeef, 0x94d2},
	{0xeef0, 0x94d5},
	{0xeef1, 0x94d6},
	{0xeef2, 0x94d7},
	{0xeef3, 0x94d9},
	{0xeef4, 0x94d8},
	{0xeef5, 0x94db},
	{0xeef6, 0x94de},
	{0xeef7, 0x94df},
	{0xeef8, 0x94e0},
	{0xeef9, 0x94e2},
	{0xeefa, 0x94e4},
	{0xeefb, 0x94e5},
	{0xeefc, 0x94e7},
	{0xeefd, 0x94e8},
	{0xeefe, 0x94ea},
	{0xef40, 0x986f},
	{0xef41, 0x9870},
	{0xef42, 0x9871},
	{0xef43, 0x9872},
	{0xef44, 0x9873},
	{0xef45, 0x9874},
	{0xef46, 0x988b},
	{0xef47, 0x988e},
	{0xef48, 0x9892},
	{0xef49, 0x9895},
	{0xef4a, 0x9899},
	{0xef4b, 0x98a3},
	{0xef4c, 0x98a8},
	{0xef4d, 0x98a9},
	{0xef4e, 0x98aa},
	{0xef4f, 0x98ab},
	{0xef50, 0x98ac},
	{0xef51, 0x98ad},
	{0xef52, 0x98ae},
	{0xef53, 0x98af},
	{0xef54, 0x98b0},
	{0xef55, 0x98b1},
	{0xef56, 0x98b2},
	{0xef57, 0x98b3},
	{0xef58, 0x98b4},
	{0xef59, 0x98b5},
	{0xef5a, 0x98b6},
	{0xef5b, 0x98b7},
	{0xef5c, 0x98b8},
	{0xef5d, 0x98b9},
	{0xef5e, 0x98ba},
	{0xef5f, 0x98bb},
	{0xef60, 0x98bc},
	{0xef61, 0x98bd},
	{0xef62, 0x98be},
	{0xef63, 0x98bf},
	{0xef64, 0x98c0},
	{0xef65, 0x98c1},
	{0xef66, 0x98c2},
	{0xef67, 0x98c3},
	{0xef68, 0x98c4},
	{0xef69, 0x98c5},
	{0xef6a, 0x98c6},
	{0xef6b, 0x98c7},
	{0xef6c, 0x98c8},
	{0xef6d, 0x98c9},
	{0xef6e, 0x98ca},
	{0xef6f, 0x98cb},
	{0xef70, 0x98cc},
	{0xef71, 0x98cd},
	{0xef72, 0x98cf},
	{0xef73, 0x98d0},
	{0xef74, 0x98d4},
	{0xef75, 0x98d6},
	{0xef76, 0x98d7},
	{0xef77, 0x98db},
	{0xef78, 0x98dc},
	{0xef79, 0x98dd},
	{0xef7a, 0x98e0},
	{0xef7b, 0x98e1},
	{0xef7c, 0x98e2},
	{0xef7d, 0x98e3},
	{0xef7e, 0x98e4},
	{0xef80, 0x98e5},
	{0xef81, 0x98e6},
	{0xef82, 0x98e9},
	{0xef83, 0x98ea},
	{0xef84, 0x98eb},
	{0xef85, 0x98ec},
	{0xef86, 0x98ed},
	{0xef87, 0x98ee},
	{0xef88, 0x98ef},
	{0xef89, 0x98f0},
	{0xef8a, 0x98f1},
	{0xef8b, 0x98f2},
	{0xef8c, 0x98f3},
	{0xef8d, 0x98f4},
	{0xef8e, 0x98f5},
	{0xef8f, 0x98f6},
	{0xef90, 0x98f7},
	{0xef91, 0x98f8},
	{0xef92, 0x98f9},
	{0xef93, 0x98fa},
	{0xef94, 0x98fb},
	{0xef95, 0x98fc},
	{0xef96, 0x98fd},
	{0xef97, 0x98fe},
	{0xef98, 0x98ff},
	{0xef99, 0x9900},
	{0xef9a, 0x9901},
	{0xef9b, 0x9902},
	{0xef9c, 0x9903},
	{0xef9d, 0x9904},
	{0xef9e, 0x9905},
	{0xef9f, 0x9906},
	{0xefa0, 0x9907},
	{0xefa1, 0x94e9},
	{0xefa2, 0x94eb},
	{0xefa3, 0x94ee},
	{0xefa4, 0x94ef},
	{0xefa5, 0x94f3},
	{0xefa6, 0x94f4},
	{0xefa7, 0x94f5},
	{0xefa8, 0x94f7},
	{0xefa9, 0x94f9},
	{0xefaa, 0x94fc},
	{0xefab, 0x94fd},
	{0xefac, 0x94ff},
	{0xefad, 0x9503},
	{0xefae, 0x9502},
	{0xefaf, 0x9506},
	{0xefb0, 0x9507},
	{0xefb1, 0x9509},
	{0xefb2, 0x950a},
	{0xefb3, 0x950d},
	{0xefb4, 0x950e},
	{0xefb5, 0x950f},
	{0xefb6, 0x9512},
	{0xefb7, 0x9513},
	{0xefb8, 0x9514},
	{0xefb9, 0x9515},
	{0xefba, 0x9516},
	{0xefbb, 0x9518},
	{0xefbc, 0x951b},
	{0xefbd, 0x951d},
	{0xefbe, 0x951e},
	{0xefbf, 0x951f},
	{0xefc0, 0x9522},
	{0xefc1, 0x952a},
	{0xefc2, 0x952b},
	{0xefc3, 0x9529},
	{0xefc4, 0x952c},
	{0xefc5, 0x9531},
	{0xefc6, 0x9532},
	{0xefc7, 0x9534},
	{0xefc8, 0x9536},
	{0xefc9, 0x9537},
	{0xefca, 0x9538},
	{0xefcb, 0x953c},
	{0xefcc, 0x953e},
	{0xefcd, 0x953f},
	{0xefce, 0x9542},
	{0xefcf, 0x9535},
	{0xefd0, 0x9544},
	{0xefd1, 0x9545},
	{0xefd2, 0x9546},
	{0xefd3, 0x9549},
	{0xefd4, 0x954c},
	{0xefd5, 0x954e},
	{0xefd6, 0x954f},
	{0xefd7, 0x9552},
	{0xefd8, 0x9553},
	{0xefd9, 0x9554},
	{0xefda, 0x9556},
	{0xefdb, 0x9557},
	{0xefdc, 0x9558},
	{0xefdd, 0x9559},
	{0xefde, 0x955b},
	{0xefdf, 0x955e},
	{0xefe0, 0x955f},
	{0xefe1, 0x955d},
	{0xefe2, 0x9561},
	{0xefe3, 0x9562},
	{0xefe4, 0x9564},
	{0xefe5, 0x9565},
	{0xefe6, 0x9566},
	{0xefe7, 0x9567},
	{0xefe8, 0x9568},
	{0xefe9, 0x9569},
	{0xefea, 0x956a},
	{0xefeb, 0x956b},
	{0xefec, 0x956c},
	{0xefed, 0x956f},
	{0xefee, 0x9571},
	{0xefef, 0x9572},
	{0xeff0, 0x9573},
	{0xeff1, 0x953a},
	{0xeff2, 0x77e7},
	{0xeff3, 0x77ec},
	{0xeff4, 0x96c9},
	{0xeff5, 0x79d5},
	{0xeff6, 0x79ed},
	{0xeff7, 0x79e3},
	{0xeff8, 0x79eb},
	{0xeff9, 0x7a06},
	{0xeffa, 0x5d47},
	{0xeffb, 0x7a03},
	{0xeffc, 0x7a02},
	{0xeffd, 0x7a1e},
	{0xeffe, 0x7a14},
	{0xf040, 0x9908},
	{0xf041, 0x9909},
	{0xf042, 0x990a},
	{0xf043, 0x990b},
	{0xf044, 0x990c},
	{0xf045, 0x990e},
	{0xf046, 0x990f},
	{0xf047, 0x9911},
	{0xf048, 0x9912},
	{0xf049, 0x9913},
	{0xf04a, 0x9914},
	{0xf04b, 0x9915},
	{0xf04c, 0x9916},
	{0xf04d, 0x9917},
	{0xf04e, 0x9918},
	{0xf04f, 0x9919},
	{0xf050, 0x991a},
	{0xf051, 0x991b},
	{0xf052, 0x991c},
	{0xf053, 0x991d},
	{0xf054, 0x991e},
	{0xf055, 0x991f},
	{0xf056, 0x9920},
	{0xf057, 0x9921},
	{0xf058, 0x9922},
	{0xf059, 0x9923},
	{0xf05a, 0x9924},
	{0xf05b, 0x9925},
	{0xf05c, 0x9926},
	{0xf05d, 0x9927},
	{0xf05e, 0x9928},
	{0xf05f, 0x9929},
	{0xf060, 0x992a},
	{0xf061, 0x992b},
	{0xf062, 0x992c},
	{0xf063, 0x992d},
	{0xf064, 0x992f},
	{0xf065, 0x9930},
	{0xf066, 0x9931},
	{0xf067, 0x9932},
	{0xf068, 0x9933},
	{0xf069, 0x9934},
	{0xf06a, 0x9935},
	{0xf06b, 0x9936},
	{0xf06c, 0x9937},
	{0xf06d, 0x9938},
	{0xf06e, 0x9939},
	{0xf06f, 0x993a},
	{0xf070, 0x993b},
	{0xf071, 0x993c},
	{0xf072, 0x993d},
	{0xf073, 0x993e},
	{0xf074, 0x993f},
	{0xf075, 0x9940},
	{0xf076, 0x9941},
	{0xf077, 0x9942},
	{0xf078, 0x9943},
	{0xf079, 0x9944},
	{0xf07a, 0x9945},
	{0xf07b, 0x9946},
	{0xf07c, 0x9947},
	{0xf07d, 0x9948},
	{0xf07e, 0x9949},
	{0xf080, 0x994a},
	{0xf081, 0x994b},
	{0xf082, 0x994c},
	{0xf083, 0x994d},
	{0xf084, 0x994e},
	{0xf085, 0x994f},
	{0xf086, 0x9950},
	{0xf087, 0x9951},
	{0xf088, 0x9952},
	{0xf089, 0x9953},
	{0xf08a, 0x9956},
	{0xf08b, 0x9957},
	{0xf08c, 0x9958},
	{0xf08d, 0x9959},
	{0xf08e, 0x995a},
	{0xf08f, 0x995b},
	{0xf090, 0x995c},
	{0xf091, 0x995d},
	{0xf092, 0x995e},
	{0xf093, 0x995f},
	{0xf094, 0x9960},
	{0xf095, 0x9961},
	{0xf096, 0x9962},
	{0xf097, 0x9964},
	{0xf098, 0x9966},
	{0xf099, 0x9973},
	{0xf09a, 0x9978},
	{0xf09b, 0x9979},
	{0xf09c, 0x997b},
	{0xf09d, 0x997e},
	{0xf09e, 0x9982},
	{0xf09f, 0x9983},
	{0xf0a0, 0x9989},
	{0xf0a1, 0x7a39},
	{0xf0a2, 0x7a37},
	{0xf0a3, 0x7a51},
	{0xf0a4, 0x9ecf},
	{0xf0a5, 0x99a5},
	{0xf0a6, 0x7a70},
	{0xf0a7, 0x7688},
	{0xf0a8, 0x768e},
	{0xf0a9, 0x7693},
	{0xf0aa, 0x7699},
	{0xf0ab, 0x76a4},
	{0xf0ac, 0x74de},
	{0xf0ad, 0x74e0},
	{0xf0ae, 0x752c},
	{0xf0af, 0x9e20},
	{0xf0b0, 0x9e22},
	{0xf0b1, 0x9e28},
	{0xf0b2, 0x9e29},
	{0xf0b3, 0x9e2a},
	{0xf0b4, 0x9e2b},
	{0xf0b5, 0x9e2c},
	{0xf0b6, 0x9e32},
	{0xf0b7, 0x9e31},
	{0xf0b8, 0x9e36},
	{0xf0b9, 0x9e38},
	{0xf0ba, 0x9e37},
	{0xf0bb, 0x9e39},
	{0xf0bc, 0x9e3a},
	{0xf0bd, 0x9e3e},
	{0xf0be, 0x9e41},
	{0xf0bf, 0x9e42},
	{0xf0c0, 0x9e44},
	{0xf0c1, 0x9e46},
	{0xf0c2, 0x9e47},
	{0xf0c3, 0x9e48},
	{0xf0c4, 0x9e49},
	{0xf0c5, 0x9e4b},
	{0xf0c6, 0x9e4c},
	{0xf0c7, 0x9e4e},
	{0xf0c8, 0x9e51},
	{0xf0c9, 0x9e55},
	{0xf0ca, 0x9e57},
	{0xf0cb, 0x9e5a},
	{0xf0cc, 0x9e5b},
	{0xf0cd, 0x9e5c},
	{0xf0ce, 0x9e5e},
	{0xf0cf, 0x9e63},
	{0xf0d0, 0x9e66},
	{0xf0d1, 0x9e67},
	{0xf0d2, 0x9e68},
	{0xf0d3, 0x9e69},
	{0xf0d4, 0x9e6a},
	{0xf0d5, 0x9e6b},
	{0xf0d6, 0x9e6c},
	{0xf0d7, 0x9e71},
	{0xf0d8, 0x9e6d},
	{0xf0d9, 0x9e73},
	{0xf0da, 0x7592},
	{0xf0db, 0x7594},
	{0xf0dc, 0x7596},
	{0xf0dd, 0x75a0},
	{0xf0de, 0x759d},
	{0xf0df, 0x75ac},
	{0xf0e0, 0x75a3},
	{0xf0e1, 0x75b3},
	{0xf0e2, 0x75b4},
	{0xf0e3, 0x75b8},
	{0xf0e4, 0x75c4},
	{0xf0e5, 0x75b1},
	{0xf0e6, 0x75b0},
	{0xf0e7, 0x75c3},
	{0xf0e8, 0x75c2},
	{0xf0e9, 0x75d6},
	{0xf0ea, 0x75cd},
	{0xf0eb, 0x75e3},
	{0xf0ec, 0x75e8},
	{0xf0ed, 0x75e6},
	{0xf0ee, 0x75e4},
	{0xf0ef, 0x75eb},
	{0xf0f0, 0x75e7},
	{0xf0f1, 0x7603},
	{0xf0f2, 0x75f1},
	{0xf0f3, 0x75fc},
	{0xf0f4, 0x75ff},
	{0xf0f5, 0x7610},
	{0xf0f6, 0x7600},
	{0xf0f7, 0x7605},
	{0xf0f8, 0x760c},
	{0xf0f9, 0x7617},
	{0xf0fa, 0x760a},
	{0xf0fb, 0x7625},
	{0xf0fc, 0x7618},
	{0xf0fd, 0x7615},
	{0xf0fe, 0x7619},
	{0xf140, 0x998c},
	{0xf141, 0x998e},
	{0xf142, 0x999a},
	{0xf143, 0x999b},
	{0xf144, 0x999c},
	{0xf145, 0x999d},
	{0xf146, 0x999e},
	{0xf147, 0x999f},
	{0xf148, 0x99a0},
	{0xf149, 0x99a1},
	{0xf14a, 0x99a2},
	{0xf14b, 0x99a3},
	{0xf14c, 0x99a4},
	{0xf14d, 0x99a6},
	{0xf14e, 0x99a7},
	{0xf14f, 0x99a9},
	{0xf150, 0x99aa},
	{0xf151, 0x99ab},
	{0xf152, 0x99ac},
	{0xf153, 0x99ad},
	{0xf154, 0x99ae},
	{0xf155, 0x99af},
	{0xf156, 0x99b0},
	{0xf157, 0x99b1},
	{0xf158, 0x99b2},
	{0xf159, 0x99b3},
	{0xf15a, 0x99b4},
	{0xf15b, 0x99b5},
	{0xf15c, 0x99b6},
	{0xf15d, 0x99b7},
	{0xf15e, 0x99b8},
	{0xf15f, 0x99b9},
	{0xf160, 0x99ba},
	{0xf161, 0x99bb},
	{0xf162, 0x99bc},
	{0xf163, 0x99bd},
	{0xf164, 0x99be},
	{0xf165, 0x99bf},
	{0xf166, 0x99c0},
	{0xf167, 0x99c1},
	{0xf168, 0x99c2},
	{0xf169, 0x99c3},
	{0xf16a, 0x99c4},
	{0xf16b, 0x99c5},
	{0xf16c, 0x99c6},
	{0xf16d, 0x99c7},
	{0xf16e, 0x99c8},
	{0xf16f, 0x99c9},
	{0xf170, 0x99ca},
	{0xf171, 0x99cb},
	{0xf172, 0x99cc},
	{0xf173, 0x99cd},
	{0xf174, 0x99ce},
	{0xf175, 0x99cf},
	{0xf176, 0x99d0},
	{0xf177, 0x99d1},
	{0xf178, 0x99d2},
	{0xf179, 0x99d3},
	{0xf17a, 0x99d4},
	{0xf17b, 0x99d5},
	{0xf17c, 0x99d6},
	{0xf17d, 0x99d7},
	{0xf17e, 0x99d8},
	{0xf180, 0x99d9},
	{0xf181, 0x99da},
	{0xf182, 0x99db},
	{0xf183, 0x99dc},
	{0xf184, 0x99dd},
	{0xf185, 0x99de},
	{0xf186, 0x99df},
	{0xf187, 0x99e0},
	{0xf188, 0x99e1},
	{0xf189, 0x99e2},
	{0xf18a, 0x99e3},
	{0xf18b, 0x99e4},
	{0xf18c, 0x99e5},
	{0xf18d, 0x99e6},
	{0xf18e, 0x99e7},
	{0xf18f, 0x99e8},
	{0xf190, 0x99e9},
	{0xf191, 0x99ea},
	{0xf192, 0x99eb},
	{0xf193, 0x99ec},
	{0xf194, 0x99ed},
	{0xf195, 0x99ee},
	{0xf196, 0x99ef},
	{0xf197, 0x99f0},
	{0xf198, 0x99f1},
	{0xf199, 0x99f2},
	{0xf19a, 0x99f3},
	{0xf19b, 0x99f4},
	{0xf19c, 0x99f5},
	{0xf19d, 0x99f6},
	{0xf19e, 0x99f7},
	{0xf19f, 0x99f8},
	{0xf1a0, 0x99f9},
	{0xf1a1, 0x761b},
	{0xf1a2, 0x763c},
	{0xf1a3, 0x7622},
	{0xf1a4, 0x7620},
	{0xf1a5, 0x7640},
	{0xf1a6, 0x762d},
	{0xf1a7, 0x7630},
	{0xf1a8, 0x763f},
	{0xf1a9, 0x7635},
	{0xf1aa, 0x7643},
	{0xf1ab, 0x763e},
	{0xf1ac, 0x7633},
	{0xf1ad, 0x764d},
	{0xf1ae, 0x765e},
	{0xf1af, 0x7654},
	{0xf1b0, 0x765c},
	{0xf1b1, 0x7656},
	{0xf1b2, 0x766b},
	{0xf1b3, 0x766f},
	{0xf1b4, 0x7fca},
	{0xf1b5, 0x7ae6},
	{0xf1b6, 0x7a78},
	{0xf1b7, 0x7a79},
	{0xf1b8, 0x7a80},
	{0xf1b9, 0x7a86},
	{0xf1ba, 0x7a88},
	{0xf1bb, 0x7a95},
	{0xf1bc, 0x7aa6},
	{0xf1bd, 0x7aa0},
	{0xf1be, 0x7aac},
	{0xf1bf, 0x7aa8},
	{0xf1c0, 0x7aad},
	{0xf1c1, 0x7ab3},
	{0xf1c2, 0x8864},
	{0xf1c3, 0x8869},
	{0xf1c4, 0x8872},
	{0xf1c5, 0x887d},
	{0xf1c6, 0x887f},
	{0xf1c7, 0x8882},
	{0xf1c8, 0x88a2},
	{0xf1c9, 0x88c6},
	{0xf1ca, 0x88b7},
	{0xf1cb, 0x88bc},
	{0xf1cc, 0x88c9},
	{0xf1cd, 0x88e2},
	{0xf1ce, 0x88ce},
	{0xf1cf, 0x88e3},
	{0xf1d0, 0x88e5},
	{0xf1d1, 0x88f1},
	{0xf1d2, 0x891a},
	{0xf1d3, 0x88fc},
	{0xf1d4, 0x88e8},
	{0xf1d5, 0x88fe},
	{0xf1d6, 0x88f0},
	{0xf1d7, 0x8921},
	{0xf1d8, 0x8919},
	{0xf1d9, 0x8913},
	{0xf1da, 0x891b},
	{0xf1db, 0x890a},
	{0xf1dc, 0x8934},
	{0xf1dd, 0x892b},
	{0xf1de, 0x8936},
	{0xf1df, 0x8941},
	{0xf1e0, 0x8966},
	{0xf1e1, 0x897b},
	{0xf1e2, 0x758b},
	{0xf1e3, 0x80e5},
	{0xf1e4, 0x76b2},
	{0xf1e5, 0x76b4},
	{0xf1e6, 0x77dc},
	{0xf1e7, 0x8012},
	{0xf1e8, 0x8014},
	{0xf1e9, 0x8016},
	{0xf1ea, 0x801c},
	{0xf1eb, 0x8020},
	{0xf1ec, 0x8022},
	{0xf1ed, 0x8025},
	{0xf1ee, 0x8026},
	{0xf1ef, 0x8027},
	{0xf1f0, 0x8029},
	{0xf1f1, 0x8028},
	{0xf1f2, 0x8031},
	{0xf1f3, 0x800b},
	{0xf1f4, 0x8035},
	{0xf1f5, 0x8043},
	{0xf1f6, 0x8046},
	{0xf1f7, 0x804d},
	{0xf1f8, 0x8052},
	{0xf1f9, 0x8069},
	{0xf1fa, 0x8071},
	{0xf1fb, 0x8983},
	{0xf1fc, 0x9878},
	{0xf1fd, 0x9880},
	{0xf1fe, 0x9883},
	{0xf240, 0x99fa},
	{0xf241, 0x99fb},
	{0xf242, 0x99fc},
	{0xf243, 0x99fd},
	{0xf244, 0x99fe},
	{0xf245, 0x99ff},
	{0xf246, 0x9a00},
	{0xf247, 0x9a01},
	{0xf248, 0x9a02},
	{0xf249, 0x9a03},
	{0xf24a, 0x9a04},
	{0xf24b, 0x9a05},
	{0xf24c, 0x9a06},
	{0xf24d, 0x9a07},
	{0xf24e, 0x9a08},
	{0xf24f, 0x9a09},
	{0xf250, 0x9a0a},
	{0xf251, 0x9a0b},
	{0xf252, 0x9a0c},
	{0xf253, 0x9a0d},
	{0xf254, 0x9a0e},
	{0xf255, 0x9a0f},
	{0xf256, 0x9a10},
	{0xf257, 0x9a11},
	{0xf258, 0x9a12},
	{0xf259, 0x9a13},
	{0xf25a, 0x9a14},
	{0xf25b, 0x9a15},
	{0xf25c, 0x9a16},
	{0xf25d, 0x9a17},
	{0xf25e, 0x9a18},
	{0xf25f, 0x9a19},
	{0xf260, 0x9a1a},
	{0xf261, 0x9a1b},
	{0xf262, 0x9a1c},
	{0xf263, 0x9a1d},
	{0xf264, 0x9a1e},
	{0xf265, 0x9a1f},
	{0xf266, 0x9a20},
	{0xf267, 0x9a21},
	{0xf268, 0x9a22},
	{0xf269, 0x9a23},
	{0xf26a, 0x9a24},
	{0xf26b, 0x9a25},
	{0xf26c, 0x9a26},
	{0xf26d, 0x9a27},
	{0xf26e, 0x9a28},
	{0xf26f, 0x9a29},
	{0xf270, 0x9a2a},
	{0xf271, 0x9a2b},
	{0xf272, 0x9a2c},
	{0xf273, 0x9a2d},
	{0xf274, 0x9a2e},
	{0xf275, 0x9a2f},
	{0xf276, 0x9a30},
	{0xf277, 0x9a31},
	{0xf278, 0x9a32},
	{0xf279, 0x9a33},
	{0xf27a, 0x9a34},
	{0xf27b, 0x9a35},
	{0xf27c, 0x9a36},
	{0xf27d, 0x9a37},
	{0xf27e, 0x9a38},
	{0xf280, 0x9a39},
	{0xf281, 0x9a3a},
	{0xf282, 0x9a3b},
	{0xf283, 0x9a3c},
	{0xf284, 0x9a3d},
	{0xf285, 0x9a3e},
	{0xf286, 0x9a3f},
	{0xf287, 0x9a40},
	{0xf288, 0x9a41},
	{0xf289, 0x9a42},
	{0xf28a, 0x9a43},
	{0xf28b, 0x9a44},
	{0xf28c, 0x9a45},
	{0xf28d, 0x9a46},
	{0xf28e, 0x9a47},
	{0xf28f, 0x9a48},
	{0xf290, 0x9a49},
	{0xf291, 0x9a4a},
	{0xf292, 0x9a4b},
	{0xf293, 0x9a4c},
	{0xf294, 0x9a4d},
	{0xf295, 0x9a4e},
	{0xf296, 0x9a4f},
	{0xf297, 0x9a50},
	{0xf298, 0x9a51},
	{0xf299, 0x9a52},
	{0xf29a, 0x9a53},
	{0xf29b, 0x9a54},
	{0xf29c, 0x9a55},
	{0xf29d, 0x9a56},
	{0xf29e, 0x9a57},
	{0xf29f, 0x9a58},
	{0xf2a0, 0x9a59},
	{0xf2a1, 0x9889},
	{0xf2a2, 0x988c},
	{0xf2a3, 0x988d},
	{0xf2a4, 0x988f},
	{0xf2a5, 0x9894},
	{0xf2a6, 0x989a},
	{0xf2a7, 0x989b},
	{0xf2a8, 0x989e},
	{0xf2a9, 0x989f},
	{0xf2aa, 0x98a1},
	{0xf2ab, 0x98a2},
	{0xf2ac, 0x98a5},
	{0xf2ad, 0x98a6},
	{0xf2ae, 0x864d},
	{0xf2af, 0x8654},
	{0xf2b0, 0x866c},
	{0xf2b1, 0x866e},
	{0xf2b2, 0x867f},
	{0xf2b3, 0x867a},
	{0xf2b4, 0x867c},
	{0xf2b5, 0x867b},
	{0xf2b6, 0x86a8},
	{0xf2b7, 0x868d},
	{0xf2b8, 0x868b},
	{0xf2b9, 0x86ac},
	{0xf2ba, 0x869d},
	{0xf2bb, 0x86a7},
	{0xf2bc, 0x86a3},
	{0xf2bd, 0x86aa},
	{0xf2be, 0x8693},
	{0xf2bf, 0x86a9},
	{0xf2c0, 0x86b6},
	{0xf2c1, 0x86c4},
	{0xf2c2, 0x86b5},
	{0xf2c3, 0x86ce},
	{0xf2c4, 0x86b0},
	{0xf2c5, 0x86ba},
	{0xf2c6, 0x86b1},
	{0xf2c7, 0x86af},
	{0xf2c8, 0x86c9},
	{0xf2c9, 0x86cf},
	{0xf2ca, 0x86b4},
	{0xf2cb, 0x86e9},
	{0xf2cc, 0x86f1},
	{0xf2cd, 0x86f2},
	{0xf2ce, 0x86ed},
	{0xf2cf, 0x86f3},
	{0xf2d0, 0x86d0},
	{0xf2d1, 0x8713},
	{0xf2d2, 0x86de},
	{0xf2d3, 0x86f4},
	{0xf2d4, 0x86df},
	{0xf2d5, 0x86d8},
	{0xf2d6, 0x86d1},
	{0xf2d7, 0x8703},
	{0xf2d8, 0x8707},
	{0xf2d9, 0x86f8},
	{0xf2da, 0x8708},
	{0xf2db, 0x870a},
	{0xf2dc, 0x870d},
	{0xf2dd, 0x8709},
	{0xf2de, 0x8723},
	{0xf2df, 0x873b},
	{0xf2e0, 0x871e},
	{0xf2e1, 0x8725},
	{0xf2e2, 0x872e},
	{0xf2e3, 0x871a},
	{0xf2e4, 0x873e},
	{0xf2e5, 0x8748},
	{0xf2e6, 0x8734},
	{0xf2e7, 0x8731},
	{0xf2e8, 0x8729},
	{0xf2e9, 0x8737},
	{0xf2ea, 0x873f},
	{0xf2eb, 0x8782},
	{0xf2ec, 0x8722},
	{0xf2ed, 0x877d},
	{0xf2ee, 0x877e},
	{0xf2ef, 0x877b},
	{0xf2f0, 0x8760},
	{0xf2f1, 0x8770},
	{0xf2f2, 0x874c},
	{0xf2f3, 0x876e},
	{0xf2f4, 0x878b},
	{0xf2f5, 0x8753},
	{0xf2f6, 0x8763},
	{0xf2f7, 0x877c},
	{0xf2f8, 0x8764},
	{0xf2f9, 0x8759},
	{0xf2fa, 0x8765},
	{0xf2fb, 0x8793},
	{0xf2fc, 0x87af},
	{0xf2fd, 0x87a8},
	{0xf2fe, 0x87d2},
	{0xf340, 0x9a5a},
	{0xf341, 0x9a5b},
	{0xf342, 0x9a5c},
	{0xf343, 0x9a5d},
	{0xf344, 0x9a5e},
	{0xf345, 0x9a5f},
	{0xf346, 0x9a60},
	{0xf347, 0x9a61},
	{0xf348, 0x9a62},
	{0xf349, 0x9a63},
	{0xf34a, 0x9a64},
	{0xf34b, 0x9a65},
	{0xf34c, 0x9a66},
	{0xf34d, 0x9a67},
	{0xf34e, 0x9a68},
	{0xf34f, 0x9a69},
	{0xf350, 0x9a6a},
	{0xf351, 0x9a6b},
	{0xf352, 0x9a72},
	{0xf353, 0x9a83},
	{0xf354, 0x9a89},
	{0xf355, 0x9a8d},
	{0xf356, 0x9a8e},
	{0xf357, 0x9a94},
	{0xf358, 0x9a95},
	{0xf359, 0x9a99},
	{0xf35a, 0x9aa6},
	{0xf35b, 0x9aa9},
	{0xf35c, 0x9aaa},
	{0xf35d, 0x9aab},
	{0xf35e, 0x9aac},
	{0xf35f, 0x9aad},
	{0xf360, 0x9aae},
	{0xf361, 0x9aaf},
	{0xf362, 0x9ab2},
	{0xf363, 0x9ab3},
	{0xf364, 0x9ab4},
	{0xf365, 0x9ab5},
	{0xf366, 0x9ab9},
	{0xf367, 0x9abb},
	{0xf368, 0x9abd},
	{0xf369, 0x9abe},
	{0xf36a, 0x9abf},
	{0xf36b, 0x9ac3},
	{0xf36c, 0x9ac4},
	{0xf36d, 0x9ac6},
	{0xf36e, 0x9ac7},
	{0xf36f, 0x9ac8},
	{0xf370, 0x9ac9},
	{0xf371, 0x9aca},
	{0xf372, 0x9acd},
	{0xf373, 0x9ace},
	{0xf374, 0x9acf},
	{0xf375, 0x9ad0},
	{0xf376, 0x9ad2},
	{0xf377, 0x9ad4},
	{0xf378, 0x9ad5},
	{0xf379, 0x9ad6},
	{0xf37a, 0x9ad7},
	{0xf37b, 0x9ad9},
	{0xf37c, 0x9ada},
	{0xf37d, 0x9adb},
	{0xf37e, 0x9adc},
	{0xf380, 0x9add},
	{0xf381, 0x9ade},
	{0xf382, 0x9ae0},
	{0xf383, 0x9ae2},
	{0xf384, 0x9ae3},
	{0xf385, 0x9ae4},
	{0xf386, 0x9ae5},
	{0xf387, 0x9ae7},
	{0xf388, 0x9ae8},
	{0xf389, 0x9ae9},
	{0xf38a, 0x9aea},
	{0xf38b, 0x9aec},
	{0xf38c, 0x9aee},
	{0xf38d, 0x9af0},
	{0xf38e, 0x9af1},
	{0xf38f, 0x9af2},
	{0xf390, 0x9af3},
	{0xf391, 0x9af4},
	{0xf392, 0x9af5},
	{0xf393, 0x9af6},
	{0xf394, 0x9af7},
	{0xf395, 0x9af8},
	{0xf396, 0x9afa},
	{0xf397, 0x9afc},
	{0xf398, 0x9afd},
	{0xf399, 0x9afe},
	{0xf39a, 0x9aff},
	{0xf39b, 0x9b00},
	{0xf39c, 0x9b01},
	{0xf39d, 0x9b02},
	{0xf39e, 0x9b04},
	{0xf39f, 0x9b05},
	{0xf3a0, 0x9b06},
	{0xf3a1, 0x87c6},
	{0xf3a2, 0x8788},
	{0xf3a3, 0x8785},
	{0xf3a4, 0x87ad},
	{0xf3a5, 0x8797},
	{0xf3a6, 0x8783},
	{0xf3a7, 0x87ab},
	{0xf3a8, 0x87e5},
	{0xf3a9, 0x87ac},
	{0xf3aa, 0x87b5},
	{0xf3ab, 0x87b3},
	{0xf3ac, 0x87cb},
	{0xf3ad, 0x87d3},
	{0xf3ae, 0x87bd},
	{0xf3af, 0x87d1},
	{0xf3b0, 0x87c0},
	{0xf3b1, 0x87ca},
	{0xf3b2, 0x87db},
	{0xf3b3, 0x87ea},
	{0xf3b4, 0x87e0},
	{0xf3b5, 0x87ee},
	{0xf3b6, 0x8816},
	{0xf3b7, 0x8813},
	{0xf3b8, 0x87fe},
	{0xf3b9, 0x880a},
	{0xf3ba, 0x881b},
	{0xf3bb, 0x8821},
	{0xf3bc, 0x8839},
	{0xf3bd, 0x883c},
	{0xf3be, 0x7f36},
	{0xf3bf, 0x7f42},
	{0xf3c0, 0x7f44},
	{0xf3c1, 0x7f45},
	{0xf3c2, 0x8210},
	{0xf3c3, 0x7afa},
	{0xf3c4, 0x7afd},
	{0xf3c5, 0x7b08},
	{0xf3c6, 0x7b03},
	{0xf3c7, 0x7b04},
	{0xf3c8, 0x7b15},
	{0xf3c9, 0x7b0a},
	{0xf3ca, 0x7b2b},
	{0xf3cb, 0x7b0f},
	{0xf3cc, 0x7b47},
	{0xf3cd, 0x7b38},
	{0xf3ce, 0x7b2a},
	{0xf3cf, 0x7b19},
	{0xf3d0, 0x7b2e},
	{0xf3d1, 0x7b31},
	{0xf3d2, 0x7b20},
	{0xf3d3, 0x7b25},
	{0xf3d4, 0x7b24},
	{0xf3d5, 0x7b33},
	{0xf3d6, 0x7b3e},
	{0xf3d7, 0x7b1e},
	{0xf3d8, 0x7b58},
	{0xf3d9, 0x7b5a},
	{0xf3da, 0x7b45},
	{0xf3db, 0x7b75},
	{0xf3dc, 0x7b4c},
	{0xf3dd, 0x7b5d},
	{0xf3de, 0x7b60},
	{0xf3df, 0x7b6e},
	{0xf3e0, 0x7b7b},
	{0xf3e1, 0x7b62},
	{0xf3e2, 0x7b72},
	{0xf3e3, 0x7b71},
	{0xf3e4, 0x7b90},
	{0xf3e5, 0x7ba6},
	{0xf3e6, 0x7ba7},
	{0xf3e7, 0x7bb8},
	{0xf3e8, 0x7bac},
	{0xf3e9, 0x7b9d},
	{0xf3ea, 0x7ba8},
	{0xf3eb, 0x7b85},
	{0xf3ec, 0x7baa},
	{0xf3ed, 0x7b9c},
	{0xf3ee, 0x7ba2},
	{0xf3ef, 0x7bab},
	{0xf3f0, 0x7bb4},
	{0xf3f1, 0x7bd1},
	{0xf3f2, 0x7bc1},
	{0xf3f3, 0x7bcc},
	{0xf3f4, 0x7bdd},
	{0xf3f5, 0x7bda},
	{0xf3f6, 0x7be5},
	{0xf3f7, 0x7be6},
	{0xf3f8, 0x7bea},
	{0xf3f9, 0x7c0c},
	{0xf3fa, 0x7bfe},
	{0xf3fb, 0x7bfc},
	{0xf3fc, 0x7c0f},
	{0xf3fd, 0x7c16},
	{0xf3fe, 0x7c0b},
	{0xf440, 0x9b07},
	{0xf441, 0x9b09},
	{0xf442, 0x9b0a},
	{0xf443, 0x9b0b},
	{0xf444, 0x9b0c},
	{0xf445, 0x9b0d},
	{0xf446, 0x9b0e},
	{0xf447, 0x9b10},
	{0xf448, 0x9b11},
	{0xf449, 0x9b12},
	{0xf44a, 0x9b14},
	{0xf44b, 0x9b15},
	{0xf44c, 0x9b16},
	{0xf44d, 0x9b17},
	{0xf44e, 0x9b18},
	{0xf44f, 0x9b19},
	{0xf450, 0x9b1a},
	{0xf451, 0x9b1b},
	{0xf452, 0x9b1c},
	{0xf453, 0x9b1d},
	{0xf454, 0x9b1e},
	{0xf455, 0x9b20},
	{0xf456, 0x9b21},
	{0xf457, 0x9b22},
	{0xf458, 0x9b24},
	{0xf459, 0x9b25},
	{0xf45a, 0x9b26},
	{0xf45b, 0x9b27},
	{0xf45c, 0x9b28},
	{0xf45d, 0x9b29},
	{0xf45e, 0x9b2a},
	{0xf45f, 0x9b2b},
	{0xf460, 0x9b2c},
	{0xf461, 0x9b2d},
	{0xf462, 0x9b2e},
	{0xf463, 0x9b30},
	{0xf464, 0x9b31},
	{0xf465, 0x9b33},
	{0xf466, 0x9b34},
	{0xf467, 0x9b35},
	{0xf468, 0x9b36},
	{0xf469, 0x9b37},
	{0xf46a, 0x9b38},
	{0xf46b, 0x9b39},
	{0xf46c, 0x9b3a},
	{0xf46d, 0x9b3d},
	{0xf46e, 0x9b3e},
	{0xf46f, 0x9b3f},
	{0xf470, 0x9b40},
	{0xf471, 0x9b46},
	{0xf472, 0x9b4a},
	{0xf473, 0x9b4b},
	{0xf474, 0x9b4c},
	{0xf475, 0x9b4e},
	{0xf476, 0x9b50},
	{0xf477, 0x9b52},
	{0xf478, 0x9b53},
	{0xf479, 0x9b55},
	{0xf47a, 0x9b56},
	{0xf47b, 0x9b57},
	{0xf47c, 0x9b58},
	{0xf47d, 0x9b59},
	{0xf47e, 0x9b5a},
	{0xf480, 0x9b5b},
	{0xf481, 0x9b5c},
	{0xf482, 0x9b5d},
	{0xf483, 0x9b5e},
	{0xf484, 0x9b5f},
	{0xf485, 0x9b60},
	{0xf486, 0x9b61},
	{0xf487, 0x9b62},
	{0xf488, 0x9b63},
	{0xf489, 0x9b64},
	{0xf48a, 0x9b65},
	{0xf48b, 0x9b66},
	{0xf48c, 0x9b67},
	{0xf48d, 0x9b68},
	{0xf48e, 0x9b69},
	{0xf48f, 0x9b6a},
	{0xf490, 0x9b6b},
	{0xf491, 0x9b6c},
	{0xf492, 0x9b6d},
	{0xf493, 0x9b6e},
	{0xf494, 0x9b6f},
	{0xf495, 0x9b70},
	{0xf496, 0x9b71},
	{0xf497, 0x9b72},
	{0xf498, 0x9b73},
	{0xf499, 0x9b74},
	{0xf49a, 0x9b75},
	{0xf49b, 0x9b76},
	{0xf49c, 0x9b77},
	{0xf49d, 0x9b78},
	{0xf49e, 0x9b79},
	{0xf49f, 0x9b7a},
	{0xf4a0, 0x9b7b},
	{0xf4a1, 0x7c1f},
	{0xf4a2, 0x7c2a},
	{0xf4a3, 0x7c26},
	{0xf4a4, 0x7c38},
	{0xf4a5, 0x7c41},
	{0xf4a6, 0x7c40},
	{0xf4a7, 0x81fe},
	{0xf4a8, 0x8201},
	{0xf4a9, 0x8202},
	{0xf4aa, 0x8204},
	{0xf4ab, 0x81ec},
	{0xf4ac, 0x8844},
	{0xf4ad, 0x8221},
	{0xf4ae, 0x8222},
	{0xf4af, 0x8223},
	{0xf4b0, 0x822d},
	{0xf4b1, 0x822f},
	{0xf4b2, 0x8228},
	{0xf4b3, 0x822b},
	{0xf4b4, 0x8238},
	{0xf4b5, 0x823b},
	{0xf4b6, 0x8233},
	{0xf4b7, 0x8234},
	{0xf4b8, 0x823e},
	{0xf4b9, 0x8244},
	{0xf4ba, 0x8249},
	{0xf4bb, 0x824b},
	{0xf4bc, 0x824f},
	{0xf4bd, 0x825a},
	{0xf4be, 0x825f},
	{0xf4bf, 0x8268},
	{0xf4c0, 0x887e},
	{0xf4c1, 0x8885},
	{0xf4c2, 0x8888},
	{0xf4c3, 0x88d8},
	{0xf4c4, 0x88df},
	{0xf4c5, 0x895e},
	{0xf4c6, 0x7f9d},
	{0xf4c7, 0x7f9f},
	{0xf4c8, 0x7fa7},
	{0xf4c9, 0x7faf},
	{0xf4ca, 0x7fb0},
	{0xf4cb, 0x7fb2},
	{0xf4cc, 0x7c7c},
	{0xf4cd, 0x6549},
	{0xf4ce, 0x7c91},
	{0xf4cf, 0x7c9d},
	{0xf4d0, 0x7c9c},
	{0xf4d1, 0x7c9e},
	{0xf4d2, 0x7ca2},
	{0xf4d3, 0x7cb2},
	{0xf4d4, 0x7cbc},
	{0xf4d5, 0x7cbd},
	{0xf4d6, 0x7cc1},
	{0xf4d7, 0x7cc7},
	{0xf4d8, 0x7ccc},
	{0xf4d9, 0x7ccd},
	{0xf4da, 0x7cc8},
	{0xf4db, 0x7cc5},
	{0xf4dc, 0x7cd7},
	{0xf4dd, 0x7ce8},
	{0xf4de, 0x826e},
	{0xf4df, 0x66a8},
	{0xf4e0, 0x7fbf},
	{0xf4e1, 0x7fce},
	{0xf4e2, 0x7fd5},
	{0xf4e3, 0x7fe5},
	{0xf4e4, 0x7fe1},
	{0xf4e5, 0x7fe6},
	{0xf4e6, 0x7fe9},
	{0xf4e7, 0x7fee},
	{0xf4e8, 0x7ff3},
	{0xf4e9, 0x7cf8},
	{0xf4ea, 0x7d77},
	{0xf4eb, 0x7da6},
	{0xf4ec, 0x7dae},
	{0xf4ed, 0x7e47},
	{0xf4ee, 0x7e9b},
	{0xf4ef, 0x9eb8},
	{0xf4f0, 0x9eb4},
	{0xf4f1, 0x8d73},
	{0xf4f2, 0x8d84},
	{0xf4f3, 0x8d94},
	{0xf4f4, 0x8d91},
	{0xf4f5, 0x8db1},
	{0xf4f6, 0x8d67},
	{0xf4f7, 0x8d6d},
	{0xf4f8, 0x8c47},
	{0xf4f9, 0x8c49},
	{0xf4fa, 0x914a},
	{0xf4fb, 0x9150},
	{0xf4fc, 0x914e},
	{0xf4fd, 0x914f},
	{0xf4fe, 0x9164},
	{0xf540, 0x9b7c},
	{0xf541, 0x9b7d},
	{0xf542, 0x9b7e},
	{0xf543, 0x9b7f},
	{0xf544, 0x9b80},
	{0xf545, 0x9b81},
	{0xf546, 0x9b82},
	{0xf547, 0x9b83},
	{0xf548, 0x9b84},
	{0xf549, 0x9b85},
	{0xf54a, 0x9b86},
	{0xf54b, 0x9b87},
	{0xf5