//#include	<stdio.h> //moved to port.h for each platform mlt
//#include	<string.h>
#include "port.h"
#include "dustytypes.h"

#ifndef ERROR
#define	ERROR	0x0ff
#endif

#define	swap(a, b)	(a ^= b, b ^= a, a ^= b)

/*
 * Phonetic symbol table
 *
 * AADDDSpecial codes (because of the speed)
 * uAv Special codes for conversion to a long vowel
 * ", , , "   Fill 0xff.
 *
 *sSpecial codest
 *AAAAAAAAAAAA
 *  f0  f1  f2  f3  f4  f5  f6  f7  f8  f9  fa  fb  fc
 *
 * ", , , , " are nasal voiced consonants.
 */
static const BYTE hatu_kigou1[86] = {
	/*                                     */
	0x0f0, 0x0fa, 0x0f1, 0x0f8, 0x0f2, 0x0f9, 0x0f3, 0x0fb,
	/*                                     */
	0x0f4, 0x0fc, 0x008, 0x078, 0x009, 0x079, 0x00a, 0x07a,
	/*                                     */
	0x00b, 0x07b, 0x00c, 0x07c, 0x010, 0x080, 0x019, 0x089,
	/*                                     */
	0x012, 0x082, 0x013, 0x083, 0x014, 0x084, 0x020, 0x090,
	/*                                     */
	0x029, 0x089, 0x0c8, 0x032, 0x082, 0x023, 0x093, 0x024,
	/*                                     */
	0x094, 0x038, 0x039, 0x03a, 0x03b, 0x03c, 0x040, 0x098,
	/*                                     */
	0x0a0, 0x041, 0x099, 0x0a1, 0x042, 0x09a, 0x0a2, 0x043,
	/*                                     */
	0x09b, 0x0a3, 0x044, 0x09c, 0x0a4, 0x050, 0x051, 0x052,
	/*                                     */
	0x053, 0x054, 0x0f5, 0x058, 0x0f6, 0x05a, 0x0f7, 0x05c,
	/*                                     */
	0x060, 0x061, 0x062, 0x063, 0x064, ERROR, 0x068, ERROR,
	/*                           */
	ERROR, 0x004, 0x0d0, 0x0aa, ERROR, ERROR
};

/* Characters that convert the following "" to a long vowel */
static const BYTE char_code2[30] = {
	/*                                     */
	0x023, 0x024, 0x02d, 0x02e, 0x037, 0x038, 0x041, 0x042,
	/*                                     */
	0x04b, 0x052, 0x053, 0x054, 0x05f, 0x06a, 0x074, 0x027,
	/*                                     */
	0x028, 0x031, 0x032, 0x03b, 0x03c, 0x046, 0x047, 0x04d,
	/*                      */
	0x058, 0x059, 0x05a, 0x061, 0x06c,
	0
};

/* Characters that convert the following "" to a long vowel */
static const BYTE char_code3[18] = {
	/*                                     */
	0x029, 0x02a, 0x033, 0x034, 0x03d, 0x03e, 0x048, 0x049,
	/*                                      */
	0x04e, 0x05b, 0x05c, 0x05d, 0x062, 0x067, 0x068, 0x06d, 0x026,
	0
};

/* Characters that cannot be expressed with one 2-byte character */
static const BYTE hatu_kigou2[8][16] = {
	/* "" that precedes "Ӄ"*/
	{ 0x030, 0x048, 0x0a8, 0x0b0, 0x0b8, 0 },

	/* "" that precedes "ĂӂŃ"*/
	{ 0x011, 0x021, 0x031, 0x049, 0x069, 0x081, 0x091, 0x0a9,
	  0x0b1, 0x0b9, 0 },

	/* "" that precedes "Ƃ"*/
	{ 0x022, 0x092, 0 },

	/* "" that precedes "ӂ"*/
	{ 0x01b, 0x02b, 0x033, 0x04b, 0x06b, 0x08b, 0x08b, 0x0ab,
	  0x0b3, 0x0bb, 0 },

	/* "" that precedes "ӂ"*/
	{ 0x034, 0x04c, 0x06c, 0x0ac, 0x0b4, 0x0bc, 0 },

	/* "" that precedes "ɂЂӂ݂肬łт҃"*/
	{ 0x00d, 0x018, 0x028, 0x03d, 0x045, 0x04d, 0x055, 0x065,
	  0x07d, 0x088, 0x088, 0x095, 0x09d, 0x0a5, 0x0ad, 0 },

	/* "" that precedes "ɂЂӂ݂肬łт҃"*/
	{ 0x00e, 0x01a, 0x02a, 0x03e, 0x046, 0x04e, 0x056, 0x066,
	  0x07e, 0x08a, 0x08a, 0x096, 0x09e, 0x0a6, 0x0ae, 0 },

	/* "" that precedes "ɂЂӂ݂肬łт҃"*/
	{ 0x00f, 0x01c, 0x02c, 0x03f, 0x047, 0x04f, 0x057, 0x067,
	  0x07f, 0x08c, 0x08c, 0x097, 0x09f, 0x0a7, 0x0af, 0 }
};

static const BYTE char_code1[8][16] = {
	/* "" that precedes "Ӄ"*/
	{ 0x044, 0x055, 0x074, 0x02f, 0x030, 0 },

	/* "" that precedes "ĂӂŃ"*/
	{ 0x039, 0x046, 0x044, 0x055, 0x026, 0x03a, 0x047, 0x074,
	  0x02f, 0x030, 0 },

	/* "" that precedes "Ƃ"*/
	{ 0x048, 0x049, 0 },

	/* "" that precedes "ӂ"*/
	{ 0x037, 0x041, 0x044, 0x055, 0x026, 0x038, 0x042, 0x074,
	  0x02f, 0x030, 0 },

	/* "" that precedes "ӂ"*/
	{ 0x044, 0x055, 0x026, 0x074, 0x02f, 0x030, 0 },

	/* "" that precedes "ɂЂӂ݂肬łт҃"*/
	{ 0x02d, 0x037, 0x041, 0x04b, 0x052, 0x055, 0x05f, 0x06a,
	  0x02e, 0x038, 0x042, 0x047, 0x053, 0x054, 0x074, 0 },

	/* "" that precedes "ɂЂӂ݂肬łт҃"*/
	{ 0x02d, 0x037, 0x041, 0x04b, 0x052, 0x055, 0x05f, 0x06a,
	  0x02e, 0x038, 0x042, 0x047, 0x053, 0x054, 0x074, 0 },

	/* "" that precedes "ɂЂӂ݂肬łт҃"*/
	{ 0x02d, 0x037, 0x041, 0x04b, 0x052, 0x055, 0x05f, 0x06a,
	  0x02e, 0x038, 0x042, 0x047, 0x053, 0x054, 0x074, 0 }
};

/*
 *  A program that generates a phonetic symbol from the kana string.
 *  kana: Pointer to the kana string
 *  hatu: Pointer to the phonetic symbol
 *               (Area is reserved by the calling side.)
 *  The last of the kana string is 0x00.
 *  the function mkhatu returns the length of the phonetic symbol.
 *
 */
int mkhatu(BYTE *kana, BYTE *hatu)
{
    BYTE k1, *p, *q;
	register BYTE *kanaptr, *hatuptr;

 	hatuptr = hatu;
	kanaptr = &kana[strlen(kana) - 1];
	for( ; kanaptr > kana; kanaptr -= 2) 
	{

		/* Symbol */
		if (*(kanaptr - 1) == 0x021) 
		{
			*hatuptr++ =
				*kanaptr == 0x03c? 0x0c0:	/* [: C0 */
				*kanaptr == 0x047? 0x0e0:	/* ': E0 */
				*kanaptr == 0x03f? 0x0e1:	/* ^: E1 */
				ERROR;
			continue;
		}

		/* Check the out-of-range code. */
		if( (*(kanaptr - 1) != 0x024 && *(kanaptr - 1) != 0x025) ||
			*kanaptr - 0x021 > sizeof(hatu_kigou1) ||
			(k1 = hatu_kigou1[*kanaptr - 0x021]) == ERROR) 
		{
			*hatuptr++ = ERROR;
			continue;
		}

		/* Store it if it is not an exception. */
		if (k1 < 0x0f0) 
			*hatuptr++ = k1;

		/*
		 * For ", , ...," don't forget to use the table of char_code1 and hatu_kigou2
		 *   to convert and 
		 *  to reduce kanaptr by 2.
		 */
		else if (k1 < 0x0f8) 
		{
			k1 -= 0xf0;
			if (kanaptr >= kana + 2 &&
				(p = (BYTE *)FNX_STRCHR(&char_code1[k1][0], *(kanaptr - 2))) != NULL) 
			{
				*hatuptr++ = hatu_kigou2[k1][p - &char_code1[k1][0]];
				kanaptr -= 2;
			}
			else
				*hatuptr++ = ERROR;
		}
		/*
		 * Convert "" that is to be converted to a long vowel.
		 *  Otherwise, set the "" code.
		 */
		else if (k1 == 0x0f8) 
		{
			*hatuptr++ = kanaptr - 1 != kana &&
				(strchr(char_code2, *(kanaptr - 2)) && *(kanaptr - 3) != 0x021)?
				0x0c0: 0x001;
		}
		/*
		 * Convert "" that is to be converted to a long vowel.
		 * Otherwise, set the "" code.
		 */
		else if (k1 == 0x0f9) 
		{
			*hatuptr++ = kanaptr - 1 != kana &&
				strchr(char_code3, *(kanaptr - 2))? 0x0c0: 0x002;
		}
		/* "" to "[" */
		else if (k1 == 0x0fa) 
		{
			*hatuptr++ = kanaptr - 1 != kana &&
				(*(kanaptr - 2) == 0x022) ? 0x0c0 : 0x000;
		}
		/* "" to "[" */
		else if (k1 == 0x0fb) 
		{
			*hatuptr++ = kanaptr - 1 != kana &&
				(*(kanaptr - 2) == 0x028) ? 0x0c0 : 0x003;
		}
		/* "" to "[" */
		else if (k1 == 0x0fc) 
		{
			*hatuptr++ = kanaptr - 1 != kana &&
				(*(kanaptr - 2) == 0x02a) ? 0x0c0 : 0x004;
		}
	}

	/* Because it is converted from the end, reverse it. */
	for (p = hatu, q = hatuptr - 1; p < q; p++, q--)
		swap(*p, *q);

	/* When the beginning of the word is a nasal voiced consonant, change it to oral voiced consonant. */
	if (*hatu > 0x77 && *hatu < 0x80) 
		*hatu -= 8;  
	return 
		hatuptr - hatu;
}


