/*C_HEADER_FILE****************************************************************
FILE			:	FnxKrLtsRules.c
DESC			:	Letter-to-sound rules for Kr
TABS			:	4
OWNER			:	Fonix
DATE CREATED	:	

(C) Copyright 2005 All rights reserved.
This is an unpublished work, and is confidential and proprietary: 
technology and information of fonix corporation.  No part of this
code may be reproduced, used or disclosed without written consent of 
fonix corporation in each and every instance.

	  $Date:  $
	  $Revision:  $

*END_HEADER*******************************************************************/
#include "FnxLtsRulesEngine.h"

const char sKrRuleIndex[]  = " abcdefghijklmnoprstuwy";
const char sKrLetters[]    = "abcdefghijklmnoprstuwy";
const char sKrNumbers[]    = "1234567890";
const char sKrVowels[]     = "aeiouwy";
const char sKrVowels_f[]   = "ie";
const char sKrConsonants[] = "bcdfghjklmnprstbdg";
const char sKrConsonants_v[]= "lmnr";
const char sKrNasals[]     = "mnng";
const char *psKrOutputList[]= {
	" i", "i:", "E", "u", "U", "Ui", "oU", "ao", "A", "@", 
	"m", "m-m", "n", "n-n", "N", "pc", "p_q", "ph", "ph_h", "bc", 
	"b_q", "bh", "tc", "t_q", "th", "th_h", "dc", "d_q", "dh", "kc", 
	"k_q", "kh", "kh_h", "gc", "g_q", "gh", "s", "ss", "S", "h", 
	"j", "w", "l", "l-l", "tf", "dZ", "tS", "v;"};

const int nKrOutputList    = 48;

const int piKrRuleIndex[]	= {
	0, 28, 38, 104, 126, 185, 203, 204, 276, 298, 
	312, 376, 416, 456, 465, 482, 496, 528, 537, 613, 
	661, 677, 678};

const PhoneticRule pKrPhoneticRules[] = {
	// Rule: punctuation
	{"", 	"0", 	"", 	"(j ao N | gc gh oU N | (gh | gc | kc kh) oU N)"},
	{"", 	"1", 	"", 	"(i l | h A n A | i tf)"},
	{"", 	"2", 	"", 	"(i | tc th u l | tc th u tf | [dc] dh u (l | tf))"},
	{"", 	"3", 	"", 	"(s A m | s E tc [th])"},
	{"", 	"4", 	"", 	"(s A | n E tc [th])"},
	{"", 	"5", 	"", 	"(oU | tc th A s ao tc [th] | [dc] dh A s ao tc [th])"},
	{"", 	"6", 	"", 	"(j u kc [kh] | (j | [dc] (dZ | dh)) u (kc [kh] | N | gc [gh] | j ao s ao tc [th]))"},
	{"", 	"7", 	"", 	"(tc tS i l | tc tS i tf | i l gc gh oU pc [ph])"},
	{"", 	"8", 	"", 	"(pc ph A l | pc ph A tf | j ao dc dh ao l | j ao dc dh ao tf)"},
	{"", 	"9", 	"", 	"(kc kh u | [gc] gh u | gc [gh] u | A [h] oU pc [ph])"},
	{"", 	".", 	"", 	"."},
	{"", 	"?", 	"", 	"?"},
	{"", 	"!", 	"", 	"!"},
	{"", 	",", 	"", 	","},
	{"", 	";", 	"", 	";"},
	{"", 	":", 	"", 	":"},
	{"", 	" ", 	"", 	" "},
	{"", 	"--", 	"", 	"-"},
	{"", 	"-", 	"", 	"-"},
	{"", 	"_", 	"", 	"_"},
	{"", 	"'", 	"", 	"'"},
	{"", 	"*", 	"", 	"*"},
	{"", 	"...", 	"", 	"..."},
	{"", 	"[", 	"", 	"["},
	{"", 	"]", 	"", 	"]"},
	{"", 	"", 	"", 	""},
	{"", 	"=", 	"", 	"="},
	{"", 	"%", 	"", 	"pc ph ao"},
	// Rule: a
	{" ", 	"a", 	" ", 	"A"},
	{" ", 	"ae", 	" ", 	"E"},
	{"", 	"a--a", 	"-^", 	"A - A"},
	{"", 	"a--a", 	"^", 	"A -"},
	{"", 	"a--a", 	"", 	"A"},
	{"", 	"ae--e", 	" ", 	"E"},
	{"", 	"ae--e", 	"-", 	"E"},
	{"", 	"ae--e", 	"^", 	"E -"},
	{"", 	"ae", 	"", 	"(@ | E)"},
	{"", 	"a", 	"", 	"A"},
	// Rule: b
	{" ", 	"b", 	" ", 	"pc ph i U pc ph"},
	{" ", 	"bb", 	" ", 	"ss A N pc ph i u pc [ph]"},
	{"", 	"bb", 	"#", 	"p_q ph"},
	{"", 	"bb--", 	"i", 	"(- p_q ph | m n)"},
	{"", 	"bb--", 	"y", 	"(- p_q ph | m n)"},
	{"", 	"bb--", 	"#", 	"- p_q ph"},
	{"", 	"bb-m", 	"#", 	"m-m"},
	{"", 	"bb", 	"-n", 	"m"},
	{"", 	"bs", 	"-m", 	"m"},
	{"", 	"bs", 	"-n", 	"m"},
	{"", 	"b", 	"-m", 	"m"},
	{"", 	"b", 	"-n", 	"m"},
	{" ba", 	"b", 	" m", 	"m"},
	{"", 	"b", 	" n", 	"m"},
	{"", 	"bb", 	"", 	"pc [ph]"},
	{"ch ", 	"b", 	"un", 	"p_q ph"},
	{"t ", 	"b", 	"un", 	"p_q ph"},
	{"a-chim-", 	"b", 	"ab ", 	"p_q ph"},
	{"bal-", 	"b", 	"a-dag ", 	"p_q ph"},
	{"deung-", 	"b", 	"ul ", 	"p_q ph"},
	{"o-neul-", 	"b", 	"am ", 	"p_q ph"},
	{"o-neul ", 	"b", 	"am ", 	"p_q ph"},
	{"sin-", 	"b", 	"a-lam ", 	"p_q ph"},
	{"sin-", 	"b", 	"a-ram ", 	"p_q ph"},
	{"#m ", 	"b", 	"#", 	"(bc bh | pc ph)"},
	{"#-", 	"b", 	"#", 	"(bc bh | pc ph)"},
	{" ", 	"b", 	"#", 	"([pc] ph | bc bh)"},
	{"", 	"b", 	"u", 	"p_q ph"},
	{"ng-", 	"b", 	"#", 	"(bc bh | pc ph)"},
	{".-", 	"b", 	"#", 	"(bc bh | pc ph)"},
	{"#h-", 	"b", 	"#", 	"tc th_h"},
	{"^-", 	"b", 	"#", 	"p_q ph"},
	{"b ", 	"b", 	"", 	"p_q ph"},
	{"p ", 	"b", 	"", 	"p_q ph"},
	{"lb ", 	"b", 	"", 	"p_q ph"},
	{"lp ", 	"b", 	"", 	"p_q ph"},
	{"bs ", 	"b", 	"", 	"p_q ph"},
	{"d ", 	"b", 	"", 	"p_q ph"},
	{"s ", 	"b", 	"", 	"p_q ph"},
	{"ss ", 	"b", 	"", 	"p_q ph"},
	{"jh ", 	"b", 	"", 	"p_q ph"},
	{"ch ", 	"b", 	"", 	"p_q ph"},
	{"t ", 	"b", 	"", 	"p_q ph"},
	{"gs ", 	"b", 	"", 	"p_q ph"},
	{"g ", 	"b", 	"", 	"p_q ph"},
	{"kk ", 	"b", 	"", 	"p_q ph"},
	{"k ", 	"b", 	"", 	"p_q ph"},
	{"lg ", 	"b", 	"", 	"p_q ph"},
	{"", 	"b", 	"#", 	"(bc [bh] | pc ph)"},
	{"", 	"b--", 	"i", 	"(- bc bh | m n)"},
	{"", 	"b--", 	"y", 	"(- bc bh | m n)"},
	{"", 	"b--", 	"#", 	"(- bc [bh] | pc ph | [bc] p_q)"},
	{"", 	"b-h", 	"#", 	"- pc ph_h"},
	{"#", 	"b-m", 	"#", 	"m-m"},
	{"#", 	"b-n", 	"#", 	"(m - n | mm | nn)"},
	{"#", 	"b", 	"-r", 	"m"},
	{"#", 	"bs-m", 	"#", 	"m-m"},
	{"#", 	"bs", 	" m", 	"m"},
	{"#", 	"b", 	" m", 	"m"},
	{"#", 	"bs", 	"j", 	"bc bh"},
	{"#", 	"bs", 	"-n", 	"m"},
	{"#", 	"bs-", 	"^", 	"bc bh -"},
	{"#", 	"bs--", 	"#", 	"pc ph - s"},
	{"#", 	"b", 	" ", 	"(pc [ph] | bc [bh])"},
	{"#", 	"b", 	"", 	"(pc [ph] | bc)"},
	{"", 	"b", 	"", 	""},
	// Rule: c
	{" ", 	"ch", 	" ", 	"tc tS i U tc tS"},
	{"", 	"ch", 	"-m", 	"n"},
	{"", 	"ch-n", 	"#", 	"n-n"},
	{"lh-", 	"ch", 	"", 	"tc tS"},
	{"nh-", 	"ch", 	"", 	"tc tS"},
	{"ng-", 	"ch", 	"#", 	"tc tS"},
	{"chi--eu", 	"ch--", 	"i ", 	"- S"},
	{"chi--eu", 	"ch--", 	"eul ", 	"- s"},
	{"chi--eu", 	"ch--", 	"e ", 	"- s"},
	{"", 	"ch--", 	"a", 	"- dc dh"},
	{"", 	"ch--", 	"eo", 	"- dc dh"},
	{"", 	"ch--", 	"o", 	"- dc dh"},
	{"", 	"ch--", 	"u", 	"- dc dh"},
	{"", 	"ch--", 	"wi", 	"- dc dh"},
	{".-", 	"ch", 	"#", 	"tc tS"},
	{"^-", 	"ch", 	"#", 	"t_q tS"},
	{"", 	"ch--", 	"i", 	"(- tc tS | nn)"},
	{"", 	"ch--", 	"y", 	"(- tc tS | nn)"},
	{"", 	"ch--", 	"#", 	"- tc tS"},
	{"", 	"ch", 	" ", 	"tc [th]"},
	{"", 	"ch", 	"-^", 	"(tc [th] | dc)"},
	{"", 	"ch", 	"", 	"tc tS"},
	// Rule: d	
	{" ", 	"d", 	" ", 	"tc th i gc gh U tc [th]"},
	{" ", 	"dd", 	" ", 	"ss A N tc th i gc gh U tc [th]"},
	{"", 	"dd--", 	"i", 	"(- t_q th | nn)"},
	{"", 	"dd--", 	"y", 	"(- t_q th | nn)"},
	{"", 	"dd--", 	"#", 	"- t_q th"},
	{"", 	"dd", 	"-m", 	"n"},
	{"", 	"dd-n", 	"#", 	"n-n"},
	{"", 	"dd", 	"#", 	"t_q th"},
	{"", 	"dd", 	"", 	"tc [th]"},
	{"do ", 	"d", 	"oe", 	"([tc] th | dc dh)"},
	{"^ ", 	"d", 	"#", 	"([tc] th | dc dh)"},
	{"# ", 	"d", 	"#", 	"([dc] dh | tc th)"},
	{" ", 	"d", 	"#", 	"([tc] th | dc dh)"},
	{"", 	"d-h", 	"", 	"- tc tS"},
	{"di--geu", 	"d--", 	"i ", 	"- S"},
	{"di--geu", 	"d--", 	"eul ", 	"- s"},
	{"di--geu", 	"d--", 	"e ", 	"- s"},
	{"neun", 	"d", 	"# ", 	"tc th"},
	{"lm-", 	"d", 	"# ", 	"t_q th"},
	{"l-", 	"d", 	"#", 	"t_q th"},
	{"m-", 	"d", 	"# ", 	"t_q th"},
	{"n-", 	"d", 	"# ", 	"t_q th"},
	{"nj-", 	"d", 	"# ", 	"t_q th"},
	{"lb-", 	"d", 	"", 	"t_q th"},
	{"lt-", 	"d", 	"", 	"t_q th"},
	{"cho-seung-", 	"d", 	"al", 	"t_q th"},
	{"geu-meum-", 	"d", 	"al", 	"t_q th"},
	{"mul-", 	"d", 	"ong--i", 	"t_q th"},
	{"mur-", 	"d", 	"ong--i", 	"t_q th"},
	{"nun-", 	"d", 	"ong-ja", 	"t_q th"},
	{"ng-", 	"d", 	"#", 	"dc dh"},
	{".-", 	"d", 	"#", 	"dc dh"},
	{"#h-", 	"d", 	"#", 	"tc th_h"},
	{"^-", 	"d", 	"#", 	"t_q th"},
	{"b ", 	"d", 	"", 	"t_q th"},
	{"p ", 	"d", 	"", 	"t_q th"},
	{"lb ", 	"d", 	"", 	"t_q th"},
	{"lp ", 	"d", 	"", 	"t_q th"},
	{"bs ", 	"d", 	"", 	"t_q th"},
	{"d ", 	"d", 	"", 	"t_q th"},
	{"s ", 	"d", 	"", 	"t_q th"},
	{"ss ", 	"d", 	"", 	"t_q th"},
	{"jh ", 	"d", 	"", 	"t_q th"},
	{"ch ", 	"d", 	"", 	"t_q th"},
	{"t ", 	"d", 	"", 	"t_q th"},
	{"gs ", 	"d", 	"", 	"t_q th"},
	{"g ", 	"d", 	"", 	"t_q th"},
	{"kk ", 	"d", 	"", 	"t_q th"},
	{"k ", 	"d", 	"", 	"t_q th"},
	{"lg ", 	"d", 	"", 	"t_q th"},
	{"", 	"d", 	"#", 	"dc [dh]"},
	{"", 	"d--", 	"i", 	"(- dc dh | nn)"},
	{"", 	"d--", 	"y", 	"(- dc dh | nn)"},
	{"", 	"d--", 	"#", 	"- dc [dh]"},
	{"", 	"d-h", 	"#", 	"- tc th_h"},
	{"", 	"d", 	"-m", 	"n"},
	{"", 	"d-n", 	"#", 	"n-n"},
	{"#", 	"d", 	"", 	"(tc [th] | dc [dh])"},
	{"", 	"d", 	"", 	""},
	// Rule: e
	{" ", 	"e", 	" ", 	"E"},
	{" ", 	"eo", 	" ", 	"ao"},
	{" ", 	"eu", 	" ", 	"U"},
	{"", 	"ee", 	" ", 	"i"},
	{"", 	"e--e", 	"-", 	"E"},
	{"", 	"e--e", 	" ", 	"E"},
	{"", 	"e--e", 	"^", 	"E -"},
	{"", 	"eo--eo", 	" ", 	"(ao | A)"},
	{"", 	"eo--eo", 	"-", 	"(ao | A)"},
	{"", 	"eo--eo", 	"^", 	"(ao - | A -)"},
	{"", 	"eo", 	"", 	"(ao | A)"},
	{"s", 	"eu", 	".", 	"U"},
	{"s", 	"eu", 	"-.", 	"U"},
	{"s", 	"eu", 	"^", 	"[U]"},
	{"s", 	"eu", 	"-^", 	"[U]"},
	{"", 	"eu", 	"--i", 	"(U | w)"},
	{"", 	"eu", 	"", 	"U"},
	{"", 	"e", 	"", 	"E"},
	// Rule: f
	{"", 	"f", 	"", 	"(pc ph | bc bh)"},
	// Rule: g									//
	{" ", 	"g", 	" ", 	"gc gh i [j] ao kc kh"},
	{" ", 	"gg", 	" ", 	"ss A N gc gh i [j] ao kc kh"},
	{"", 	"gg", 	"#", 	"k_q kh"},
	{"", 	"gg--", 	"i", 	"(- k_q kh | N n)"},
	{"", 	"gg--", 	"y", 	"(- k_q kh | N n)"},
	{"", 	"gg--", 	"#", 	"- k_q kh"},
	{"", 	"gg", 	"-n", 	"N"},
	{"", 	"gg", 	"-m", 	"N"},
	{"", 	"gg", 	"", 	"kc [kh]"},
	{" ", 	"g", 	"#", 	"([kc] kh | gc gh)"},
	{"", 	"gg", 	"-m", 	"N"},
	{"", 	"gg", 	"-n", 	"N"},
	{"", 	"gs", 	"-m", 	"N"},
	{"", 	"gs", 	"-n", 	"N"},
	{"", 	"g", 	"-m", 	"N"},
	{"", 	"g", 	" m", 	"N"},
	{"", 	"g", 	" n", 	"N"},
	{"#", 	"gs-", 	"^", 	"gc gh -"},
	{"hang-gong-", 	"g", 	"won", 	"- k_q_kh"},
	{"an-", 	"g", 	"i-da ", 	"gc gh"},
	{"gam-", 	"g", 	"i-da ", 	"gc gh"},
	{"gulm-", 	"g", 	"i-da ", 	"gc gh"},
	{"olm-", 	"g", 	"i-da ", 	"gc gh"},
	{"lm-", 	"g", 	"# ", 	"k_q kh"},
	{"m-", 	"g", 	"# ", 	"k_q kh"},
	{"n-", 	"g", 	"# ", 	"k_q kh"},
	{"nj-", 	"g", 	"# ", 	"k_q kh"},
	{"lb-", 	"g", 	"", 	"k_q kh"},
	{"lt-", 	"g", 	"", 	"k_q kh"},
	{"ba-lam-", 	"g", 	"yeol", 	"k_q kh"},
	{"ba-ram-", 	"g", 	"yeol", 	"k_q kh"},
	{"mun-", 	"g", 	"o-li", 	"k_q kh"},
	{"mun-", 	"g", 	"o-ri", 	"k_q kh"},
	{"chang-", 	"g", 	"a", 	"k_q kh"},
	{"gang-", 	"g", 	"a ", 	"k_q kh"},
	{"gil-", 	"g", 	"a ", 	"k_q kh"},
	{"yeo", 	"g", 	"won", 	"k_q kh"},
	{"hang-", 	"g", 	"won", 	"k_q kh"},
	{"ng-", 	"g", 	"#", 	"gc gh"},
	{".-", 	"g", 	"#", 	"gc gh"},
	{"#h-", 	"g", 	"#", 	"kc kh_h"},
	{"^-", 	"g", 	"#", 	"k_q (kh | gh)"},
	{"ba-lam-", 	"g", 	"yeol", 	"k_q kh"},
	{"ba-ram-", 	"g", 	"yeol", 	"k_q kh"},
	{"mun-", 	"g", 	"o-li", 	"k_q kh"},
	{"mun-", 	"g", 	"o-ri", 	"k_q kh"},
	{"gang-", 	"g", 	"a ", 	"k_q kh"},
	{"gil-", 	"g", 	"a ", 	"k_q kh"},
	{"b ", 	"g", 	"", 	"k_q kh"},
	{"p ", 	"g", 	"", 	"k_q kh"},
	{"lb ", 	"g", 	"", 	"k_q kh"},
	{"lp ", 	"g", 	"", 	"k_q kh"},
	{"bs ", 	"g", 	"", 	"k_q kh"},
	{"d ", 	"g", 	"", 	"k_q kh"},
	{"s ", 	"g", 	"", 	"k_q kh"},
	{"ss ", 	"g", 	"", 	"k_q kh"},
	{"jh ", 	"g", 	"", 	"k_q kh"},
	{"ch ", 	"g", 	"", 	"k_q kh"},
	{"t ", 	"g", 	"", 	"k_q kh"},
	{"gs ", 	"g", 	"", 	"k_q kh"},
	{"g ", 	"g", 	"", 	"k_q kh"},
	{"kk ", 	"g", 	"", 	"k_q kh"},
	{"k ", 	"g", 	"", 	"k_q kh"},
	{"lg ", 	"g", 	"", 	"k_q kh"},
	{"", 	"g", 	"#", 	"gc [gh]"},
	{"", 	"g--", 	"i", 	"(- gc gh | N n)"},
	{"", 	"g--", 	"y", 	"(- gc gh | N n)"},
	{"", 	"g--", 	"#", 	"- gc [gh]"},
	{"", 	"g-h", 	"#", 	"- kc kh_h"},
	{"#", 	"g", 	"-.", 	"N"},
	{"#", 	"g", 	"", 	"(kc [kh] | gc [gh])"},
	{"", 	"g", 	"", 	""},
	// Rule: h
	{" ", 	"h", 	" ", 	"h i U h"},
	{" ", 	"hyu", 	"", 	"(h [j] u | S u)"},
	{"", 	"h", 	"wa", 	"h"},
	{"", 	"h", 	"-m", 	"n"},
	{"", 	"h", 	"-n", 	"n"},
	{"hi--eu", 	"h--", 	"i ", 	"- "},
	{"hi--eu", 	"h--", 	"eul ", 	"-s"},
	{"hi--eu", 	"h--", 	"e ", 	"-s"},
	{"#", 	"h", 	"--", 	""},
	{"#", 	"h", 	"--#", 	"-h"},
	{".", 	"h", 	"--#", 	""},
	{"#", 	"h", 	"-.", 	""},
	{".", 	"h", 	"-.", 	""},
	{"#-", 	"h", 	"#", 	"-h"},
	{".-", 	"h", 	"#", 	"-h"},
	{"#-", 	"h", 	".", 	""},
	{".-", 	"h", 	".", 	""},
	{"", 	"h", 	"ata", 	""},
	{"", 	"h", 	"#", 	"[h]"},
	{"", 	"h-ss", 	"#", 	"s - ss"},
	{"", 	"h-s", 	"#", 	" - ss"},
	{"", 	"h", 	"", 	""},
	// Rule: i
	{" ", 	"i", 	" ", 	"i"},
	{"#--", 	"i", 	"l ", 	"(i | k_q [kh] i)"},
	{"", 	"i", 	"--u", 	"[i]"},
	{"", 	"i--i", 	"^", 	"(i - i | i -)"},
	{"", 	"i--i", 	"", 	"(i - i | i)"},
	{"s", 	"i", 	"-s", 	"i"},
	{"s", 	"i", 	"^-^", 	"[i]"},
	{"s", 	"i", 	"^--y", 	"[i]"},
	{"s", 	"i", 	"-^y", 	"[i]"},
	{"s", 	"i", 	"-.", 	"i"},
	{"s", 	"i", 	"-^", 	"[i]"},
	{"s", 	"i", 	".", 	"i"},
	{"s", 	"i", 	"^", 	"[i]"},
	{"", 	"i", 	"", 	"i"},
	// Rule: j
	{" ", 	"jj", 	" ", 	"ss A N tc tS i U tc tS"},
	{" ", 	"j", 	" ", 	"tc tS i U tc tS"},
	{" ", 	"jjy", 	"eo", 	"t_q tS"},
	{"", 	"jj", 	"", 	"t_q tS"},
	{" ", 	"j", 	"#", 	"(dc dZ | [tc] tS)"},
	{"", 	"j", 	"-m", 	"n"},
	{"", 	"j", 	"-n", 	"n"},
	{"", 	"j--", 	"a", 	"-dc dh"},
	{"", 	"j--", 	"eo", 	"-dc dh"},
	{"", 	"j--", 	"o", 	"-dc dh"},
	{"", 	"j--", 	"u", 	"-dc dh"},
	{"", 	"j--", 	"wi", 	"-dc dh"},
	{"ji--eu", 	"j--", 	"i ", 	"- S"},
	{"ji--eu", 	"j--", 	"eul ", 	"-s"},
	{"ji--eu", 	"j--", 	"e ", 	"-s"},
	{"ga-", 	"jy", 	"eo", 	"dc dZ"},
	{"sod-", 	"j", 	"#", 	"t_q tS"},
	{"sot-", 	"j", 	"#", 	"t_q tS"},
	{"yeob-", 	"j", 	"#", 	"t_q tS"},
	{"yeop-", 	"j", 	"#", 	"t_q tS"},
	{"lp-", 	"j", 	"#", 	"t_q tS"},
	{"bs-", 	"j", 	"#", 	"t_q tS"},
	{"lm-", 	"j", 	"# ", 	"t_q tS"},
	{"m-", 	"j", 	"# ", 	"t_q tS"},
	{"n-", 	"j", 	"# ", 	"t_q tS"},
	{"nj-", 	"j", 	"# ", 	"t_q tS"},
	{"lt-", 	"j", 	"", 	"t_q tS"},
	{"lb-", 	"j", 	"", 	"t_q tS"},
	{"lt-", 	"j", 	"", 	"t_q tS"},
	{"gang-", 	"j", 	"ul-gi", 	"t_q tS"},
	{"gang-", 	"j", 	"ul-ki ", 	"t_q tS"},
	{"jam-", 	"j", 	"a-li", 	"t_q tS"},
	{"jam-", 	"j", 	"a-ri", 	"t_q tS"},
	{"sul-", 	"j", 	"an", 	"t_q tS"},
	{"son-", 	"j", 	"ae-ju", 	"t_q tS"},
	{"ng-", 	"j", 	"#", 	"dc dZ"},
	{".-", 	"j", 	"#", 	"dc dZ"},
	{"#h-", 	"j", 	"", 	"tc tS"},
	{"^-", 	"j", 	"#", 	"t_q tS"},
	{"b ", 	"j", 	"", 	"t_q tS"},
	{"p ", 	"j", 	"", 	"t_q tS"},
	{"lb ", 	"j", 	"", 	"t_q tS"},
	{"lp ", 	"j", 	"", 	"t_q tS"},
	{"bs ", 	"j", 	"", 	"t_q tS"},
	{"d ", 	"j", 	"", 	"t_q tS"},
	{"s ", 	"j", 	"", 	"t_q tS"},
	{"ss ", 	"j", 	"", 	"t_q tS"},
	{"jh ", 	"j", 	"", 	"t_q tS"},
	{"ch ", 	"j", 	"", 	"t_q tS"},
	{"t ", 	"j", 	"", 	"t_q tS"},
	{"gs ", 	"j", 	"", 	"t_q tS"},
	{"g ", 	"j", 	"", 	"t_q tS"},
	{"kk ", 	"j", 	"", 	"t_q tS"},
	{"k ", 	"j", 	"", 	"t_q tS"},
	{"lg ", 	"j", 	"", 	"t_q tS"},
	{"", 	"j", 	"#", 	"dc dZ"},
	{"#", 	"j--", 	"i", 	"(- dc dZ | nn)"},
	{"#", 	"j--", 	"y", 	"(- dc dZ | nn)"},
	{"#", 	"j--", 	"#", 	"(- dc dZ | tc tS)"},
	{"#", 	"j-h", 	"", 	"- tc tS"},
	{"#", 	"j", 	"-m", 	"n"},
	{"#", 	"j-n", 	"#", 	"n-n"},
	{"#", 	"j", 	"", 	"(tc [th] | dc dZ)"},
	{"", 	"j", 	"", 	""},
	// Rule: k
	{" ", 	"k", 	" ", 	"gc gh i [j] ao kc kh"},
	{" ", 	"kk", 	" ", 	"ss A N gc gh i [j] ao kc kh"},
	{"", 	"kk", 	"#", 	"k_q kh"},
	{"", 	"kk--", 	"i", 	"(- k_q kh | N n)"},
	{"", 	"kk--", 	"y", 	"(- k_q kh | N n)"},
	{"", 	"kk--", 	"#", 	"- k_q kh"},
	{"", 	"kk", 	"-n", 	"N"},
	{"", 	"kk", 	"-m", 	"N"},
	{"", 	"ks", 	"-m", 	"N"},
	{"", 	"ks", 	"-n", 	"N"},
	{"", 	"k", 	"-m", 	"N"},
	{"", 	"k", 	"-n", 	"N"},
	{"", 	"kk", 	"", 	"kc [kh]"},
	{" ", 	"k", 	"#", 	"[kc] kh_h"},
	{" ", 	"k", 	"^", 	"kc kh_h E"},
	{"ki--eu", 	"k--", 	"i ", 	"- gc gh"},
	{"ki--eu", 	"k--", 	"eul ", 	"- gc gh"},
	{"ki--eu", 	"k--", 	"e ", 	"- gc gh"},
	{"lb-", 	"k", 	"", 	"k_q kh"},
	{"lt-", 	"k", 	"", 	"k_q kh"},
	{"yeo", 	"k", 	"won", 	"kc kh_h"},
	{"hang-", 	"k", 	"won", 	"kc kh_h"},
	{"ba-lam-", 	"k", 	"yeol", 	"k_q kh"},
	{"ba-ram-", 	"k", 	"yeol", 	"k_q kh"},
	{"mun-", 	"k", 	"o-li", 	"k_q kh"},
	{"mun-", 	"k", 	"o-ri", 	"k_q kh"},
	{"chang-", 	"k", 	"a ", 	"k_q kh"},
	{"gang-", 	"k", 	"a ", 	"k_q kh"},
	{"gil-", 	"k", 	"a ", 	"k_q kh"},
	{"#", 	"k--", 	"i", 	"(- kc kh_h | N n)"},
	{"#", 	"k--", 	"y", 	"(- kc kh_h | N n)"},
	{"#", 	"k--", 	"#", 	"- kc kh_h"},
	{"#", 	"k-h", 	"#", 	"- kc kh_h"},
	{"#", 	"k", 	"-.", 	"N"},
	{"#", 	"ks", 	"-n", 	"N"},
	{"#", 	"ks", 	"-m", 	"N"},
	{"#", 	"k", 	"", 	"(kc [kh] | kc kh_h)"},
	{"#-", 	"k", 	"#", 	"kc kh_h"},
	{"-", 	"k", 	"", 	"kc kh_h"},
	{"", 	"k", 	"", 	""},
	// Rule: l
	{" ", 	"l", 	" ", 	"tf i u l"},
	{" ", 	"l", 	"#", 	""},
	{" da", 	"lg", 	" ", 	"(kc [kh] | gc)"},
	{"", 	"lg", 	"-g", 	"(kc [kh] | gc)"},
	{"", 	"lg-", 	"#", 	"l - gc gh"},
	{"", 	"l", 	"#", 	"-tf"},
	{"", 	"l--", 	"#", 	"-tf"},
	{"", 	"lb-", 	"j", 	"bc bh -"},
	{"", 	"lb", 	"-m", 	"m"},
	{"", 	"lb", 	"-n", 	"m"},
	{"", 	"lp", 	"-m", 	"m"},
	{"", 	"lp", 	"-n", 	"m"},
	{"", 	"lp", 	"-n", 	"m"},
	{"", 	"lg", 	" m", 	"ng"},
	{"ba", 	"lb-", 	"^", 	"bc bh -"},
	{"neo", 	"lb-", 	"j", 	"bc bh -"},
	{"neo", 	"lb-", 	"d", 	"bc bh -"},
	{"#", 	"l s", 	"", 	"l ss"},
	{"gu", 	"lg", 	"-da ", 	"(kc [kh] | gc)"},
	{"gu", 	"lg", 	"-ta ", 	"(kc [kh] | gc)"},
	{"heu", 	"lg", 	"", 	"(kc [kh] | gc)"},
	{"i", 	"l--eu", 	"l", 	"(-tf ao | l [k_q] ao)"},
	{"i", 	"l", 	"--eo ", 	"(-tf | l [k_q])"},
	{"sangiseu", 	"lg", 	" ", 	"(kc [kh] | gc)"},
	{"yeo", 	"l--", 	"#", 	"(- tf | l [t_q])"},
	{"b-", 	"l", 	"", 	"n"},
	{"g-", 	"l", 	"", 	"n"},
	{"m-", 	"l", 	"", 	"n"},
	{"ng-", 	"l", 	"", 	"n"},
	{"#", 	"l--", 	"#", 	"(-tf | l)"},
	{"#", 	"l-h", 	"#", 	"([l]-h | - tf)"},
	{"#", 	"l h", 	"#", 	"tf h"},
	{"#", 	"l-n", 	"", 	"(l-l | l n)"},
	{"#", 	"l-r", 	"", 	"l-l"},
	{"#", 	"l-l", 	"", 	"l-l"},
	{"#", 	"l", 	"-^", 	"l"},
	{"#", 	"lb", 	" ", 	"(l | l bc bh)"},
	{"#", 	"lh--", 	"#", 	"(-tf | [l])"},
	{"", 	"l", 	" ", 	"([l] | tf)"},
	{"", 	"l", 	"", 	"[l]"},
	// Rule: m
	{" ", 	"m", 	" ", 	"m i U m"},
	{"bi ", 	"m", 	"u--eos", 	"bc bh"},
	{"hal ", 	"m", 	"ul", 	"(m | bc bh)"},
	{" ", 	"m", 	"#", 	"(m | bc bh)"},
	{"da", 	"m--", 	"yo", 	"m-n"},
	{"#", 	"m", 	"--i", 	"(m |m n)"},
	{"#", 	"m", 	"--y", 	"(m |m n)"},
	{"", 	"m-m", 	"", 	"m-m"},
	{"", 	"m", 	"", 	"m"},
	// Rule: n
	{" ", 	"n", 	" ", 	"n i U n"},
	{"lh-", 	"n", 	"", 	"[n]"},
	{"lt-", 	"n", 	"", 	"l"},
	{" ", 	"n", 	"#", 	"(n | dc dh)"},
	{"", 	"nh", 	"-", 	"n"},
	{"ng-", 	"n", 	"#", 	"[n]"},
	{"", 	"n--", 	"#", 	"- n"},
	{"#", 	"n", 	"--i", 	"(n |nn)"},
	{"#", 	"n", 	"--y", 	"(n |nn)"},
	{"", 	"n--", 	"#", 	"- n"},
	{"", 	"nh-n", 	"", 	"n-n"},
	{"", 	"n-n", 	"", 	"n-n"},
	{"", 	"n-r", 	"#", 	"(l-l | tf)"},
	{"", 	"ng", 	"-h", 	"(N | [n] gc [gh])"},
	{"", 	"ng", 	"", 	"N"},
	{"", 	"n-m", 	"", 	"(n - m | nn | mm)"},
	{"", 	"n", 	"", 	"n"},
	// Rule: o
	{" ", 	"o", 	" ", 	"oU"},
	{" ", 	"oe", 	" ", 	"w E"},
	{"gy", 	"o", 	"--e", 	"[oU]"},
	{" ", 	"oe", 	"", 	"[w] E"},
	{"^", 	"oe", 	"", 	"[w] E"},
	{"-", 	"oe", 	"", 	"[w] E"},
	{"", 	"oe--e", 	" ", 	"[w] E"},
	{"", 	"oe--e", 	"-", 	"[w] E"},
	{"", 	"oe", 	"", 	"[w] E"},
	{" j", 	"oo", 	"n ", 	"[u]"},
	{" :", 	"oo", 	": ", 	"u"},
	{"", 	"o--o", 	"^", 	"oU -"},
	{"", 	"ou", 	"", 	"(ao | A)"},
	{"", 	"o", 	"", 	"oU"},
	// Rule: p									//
	{" ", 	"p", 	" ", 	"pc ph i u pc [ph]"},
	{" ", 	"pp", 	" ", 	"ss A N pc ph i u pc [ph]"},
	{"", 	"pp", 	"#", 	"p_q ph"},
	{"", 	"pp--", 	"i", 	"(- p_q ph | m n)"},
	{"", 	"pp--", 	"y", 	"(- p_q ph | m n)"},
	{"", 	"pp--", 	"#", 	"- p_q ph"},
	{"", 	"pp-m", 	"#", 	"m-m"},
	{"", 	"pp", 	"-n", 	"m"},
	{"", 	"pp", 	"", 	"pc [ph]"},
	{" ", 	"p", 	"#", 	"[pc] ph_h"},
	{"", 	"p", 	"-m", 	"m"},
	{"", 	"p", 	"-n", 	"m"},
	{"neu", 	"p", 	"ap", 	"-bc bh"},
	{"pi--eu", 	"p--", 	"i ", 	"-bc bh"},
	{"pi--eu", 	"p--", 	"eul ", 	"-bc bh"},
	{"pi--eu", 	"p--", 	"e ", 	"-bc bh"},
	{"hyudae", 	"p", 	"on ", 	"(pc ph_h | p_q ph)"},
	{"seu", 	"p", 	"ein", 	"(pc ph_h | p_q ph)"},
	{"eu", 	"p", 	"-n", 	"(m | pc [ph])"},
	{"a-chim-", 	"p", 	"ab ", 	"p_q ph"},
	{"bal-", 	"p", 	"a-tag ", 	"p_q ph"},
	{"deung-", 	"p", 	"ul ", 	"p_q ph"},
	{"sin-", 	"p", 	"a-lam ", 	"p_q ph"},
	{"sin-", 	"p", 	"a-ram ", 	"p_q ph"},
	{"", 	"p", 	"#", 	"pc ph_h"},
	{"#", 	"p--", 	"i", 	"(- pc ph_h | m n)"},
	{"#", 	"p--", 	"y", 	"(- pc ph_h | m n)"},
	{"#", 	"p-h", 	"#", 	"- pc ph_h"},
	{"#", 	"p--", 	"#", 	"- pc ph_h"},
	{"#", 	"p-m", 	"#", 	"m-m"},
	{"#", 	"p", 	"-n", 	"m"},
	{"#", 	"p", 	"", 	"(pc [ph] | pc ph_h)"},
	// Rule: r
	{" ", 	"r", 	" ", 	"tf i U l"},
	{" ", 	"r", 	"", 	"(tf | [l])"},
	{"", 	"rl", 	"-m'", 	"N"},
	{"", 	"rl", 	"-n", 	"N"},
	{"l-", 	"r", 	"", 	"l"},
	{"^-", 	"r", 	"", 	"[n]"},
	{"", 	"r", 	"#", 	"tf"},
	{"", 	"r", 	" ", 	"l"},
	{"", 	"r", 	"", 	""},
	// Rule: s
	{" ", 	"s", 	" ", 	"s i oU s"},
	{" ", 	"ss", 	" ", 	"ss A N s i oU s"},
	{" ", 	"s", 	"u ", 	"ss"},
	{"", 	"s", 	"i", 	"S"},
	{"", 	"s", 	"y", 	"S"},
	{"", 	"s", 	"wo", 	"S"},
	{" ", 	"s", 	"i", 	"S"},
	{"", 	"s", 	"eo-bi-seu", 	"ss"},
	{" ", 	"s", 	"#", 	"s"},
	{"seo-bi-", 	"s", 	"", 	"ss"},
	{"", 	"ss", 	"-m", 	"n"},
	{"", 	"ss", 	"-n", 	"n"},
	{"", 	"s", 	"-m", 	"n"},
	{"", 	"s", 	"-n", 	"n"},
	{"", 	"s", 	" n", 	"n"},
	{"", 	"ss-s", 	"#", 	"s - ss"},
	{"", 	"s-ss", 	"#", 	"s - ss"},
	{"", 	"s", 	"um-ni-da", 	"ss"},
	{"#", 	"s--", 	"eo", 	"- dc dh"},
	{"", 	"s--", 	"u", 	"- dc dh"},
	{"b ", 	"s", 	"", 	"ss"},
	{"p ", 	"s", 	"", 	"ss"},
	{"lb ", 	"s", 	"", 	"ss"},
	{"lp ", 	"s", 	"", 	"ss"},
	{"bs ", 	"s", 	"", 	"ss"},
	{"d ", 	"s", 	"", 	"ss"},
	{"s ", 	"s", 	"", 	"ss"},
	{"ss ", 	"s", 	"", 	"ss"},
	{"jh ", 	"s", 	"", 	"ss"},
	{"ch ", 	"s", 	"", 	"ss"},
	{"t ", 	"s", 	"", 	"ss"},
	{"gs ", 	"s", 	"", 	"ss"},
	{"g ", 	"s", 	"", 	"ss"},
	{"kk ", 	"s", 	"", 	"ss"},
	{"k ", 	"s", 	"", 	"ss"},
	{"lg ", 	"s", 	"", 	"ss"},
	{"m-", 	"s", 	"# ", 	"ss"},
	{"n-", 	"s", 	"# ", 	"ss"},
	{"nj-", 	"s", 	"# ", 	"ss"},
	{"lb-", 	"s", 	"", 	"ss"},
	{"lt-", 	"s", 	"", 	"ss"},
	{"chang-", 	"s", 	"dal", 	"ss"},
	{"gul-", 	"s", 	"og ", 	"ss"},
	{"san-", 	"s", 	"ae ", 	"ss"},
	{"mog", 	"s--", 	"i", 	"-ss"},
	{"#", 	"ss--", 	"i", 	"(- ss | nn)"},
	{"#", 	"ss--", 	"y", 	"(- ss | nn)"},
	{"#", 	"ss--", 	"#", 	"s - ss"},
	{"#", 	"s-s", 	"#", 	"- s"},
	{"", 	"ss", 	"#", 	"ss"},
	{"", 	"ss", 	"-m", 	"n"},
	{"", 	"ss", 	"-n", 	"n"},
	{"", 	"ss", 	"", 	"dc [dh]"},
	{"", 	"s", 	"i", 	"S"},
	{"", 	"s--", 	"i", 	"-S"},
	{"", 	"s--", 	"#", 	"-s"},
	{"", 	"s", 	"y", 	"S"},
	{"", 	"s", 	"wo", 	"S"},
	{"mo", 	"s", 	" ", 	"dc dh"},
	{"ng-", 	"s", 	"#", 	"s"},
	{".-", 	"s", 	"#", 	"s"},
	{" sib-", 	"s", 	"am ", 	"(ss | t_q ss)"},
	{"", 	"s", 	"wi", 	"S"},
	{"", 	"s", 	"#", 	"s"},
	{"#", 	"s--", 	"i", 	"(- s | nn)"},
	{"#", 	"s--", 	"y", 	"(- s | nn)"},
	{"#", 	"s--", 	"#", 	"- dc dh"},
	{"^", 	"s--", 	"#", 	"- [s]"},
	{"", 	"sh", 	"#", 	"S"},
	{"", 	"s", 	"^", 	"s"},
	{"^", 	"s", 	"", 	""},
	{"", 	"s", 	"-b", 	"(tc [th] | pc [ph])"},
	{"", 	"s-h", 	"#", 	"- tc th_h"},
	{"", 	"s", 	"-m", 	"n"},
	{"", 	"s-n", 	"#", 	"n-n"},
	{"", 	"s", 	"", 	"tc [th]"},
	// Rule: t
	{" ", 	"t", 	" ", 	"tc th i gc gh U tc [th]"},
	{" ", 	"tt", 	" ", 	"ss A N tc th i gc gh U tc [th]"},
	{"", 	"t-h", 	"", 	"- tc tS"},
	{"", 	"t-g", 	"", 	"dc dh - k_q kc"},
	{"", 	"tt--", 	"i", 	"(- t_q th | nn)"},
	{"", 	"tt--", 	"y", 	"(- t_q th | nn)"},
	{"", 	"tt--", 	"#", 	"- t_q [th]"},
	{"", 	"tt", 	"-m", 	"n"},
	{"", 	"tt-n", 	"#", 	"n-n"},
	{"", 	"tt--", 	"#", 	"-t_q [th]"},
	{"", 	"tt", 	"#", 	"t_q [th]"},
	{"", 	"tt", 	"", 	"tc [th]"},
	{"", 	"t", 	"-m", 	"n"},
	{"", 	"t", 	"-n", 	"n"},
	{" ", 	"t", 	"#", 	"[tc] th_h"},
	{"ti--eu", 	"t--", 	"i ", 	"- S"},
	{"ti--eu", 	"t--", 	"eul ", 	"- s"},
	{"ti--eu", 	"t--", 	"e ", 	"- s"},
	{"", 	"t--", 	"a", 	"- dc dh"},
	{"", 	"t--", 	"eo", 	"- dc dh"},
	{"", 	"t--", 	"o", 	"- dc dh"},
	{"", 	"t--", 	"u", 	"- dc dh"},
	{"", 	"t--", 	"wi", 	"- dc dh"},
	{"#", 	"t--", 	"i", 	"(- tc tS | n)"},
	{"#", 	"t--", 	"y", 	"(- tc th_h | n)"},
	{"#", 	"t--", 	"#", 	"- tc th_h"},
	{"lb-", 	"t", 	"", 	"t_q th"},
	{"lt-", 	"t", 	"", 	"t_q th"},
	{"cho-seung-", 	"t", 	"al", 	"t_q th"},
	{"geu-meum-", 	"t", 	"al", 	"t_q th"},
	{"mul-", 	"t", 	"ong--i", 	"t_q th"},
	{"mur-", 	"t", 	"ong--i", 	"t_q th"},
	{"nun-", 	"t", 	"ong-ja", 	"t_q th"},
	{"seon-", 	"t", 	"aeg", 	"(tc th_h | t_q th)"},
	{"yeol-", 	"t", 	"ul", 	"(tc th_h | t_q th)"},
	{" i-", 	"t", 	"al", 	"(tc th_h | t_q th)"},
	{"seu-", 	"t", 	"a ", 	"(tc th_h | t_q th)"},
	{"", 	"t", 	"#", 	"tc th_h"},
	{"", 	"tv", 	"", 	"tc th i v [w] i"},
	{"#", 	"t--", 	"i", 	"(- tc tS | n)"},
	{"#", 	"t--", 	"y", 	"(- tc th_h | n)"},
	{"#", 	"t--", 	"#", 	"- tc th_h"},
	{"#", 	"t", 	"-m", 	"[n]"},
	{"#", 	"t-n", 	"#", 	"n-n"},
	{"#", 	"t-h", 	"#", 	"- tc th_h"},
	{"#", 	"t", 	"#", 	"dc [dh]"},
	{"#", 	"t", 	"", 	"tc [th]"},
	{"", 	"t", 	"", 	""},
	// Rule: u
	{" ", 	"ui", 	" ", 	"Ui"},
	{" ", 	"ui", 	"", 	"(Ui | w i)"},
	{"", 	"ui--ui", 	"", 	"(Ui i)"},
	{"", 	"ui", 	" ", 	"(E | i)"},
	{"", 	"ui", 	" ", 	"(E | i)"},
	{"^", 	"ui", 	"", 	"( i | [u] i)"},
	{"^--", 	"ui", 	"", 	"( i | [u] i)"},
	{"", 	"ui", 	" ", 	"(E | i)"},
	{"", 	"ui", 	"", 	"(Ui | w i | u i)"},
	{"a", 	"u", 	"", 	"(u | oU)"},
	{"ho-ch", 	"u", 	"l", 	"U"},
	{"", 	"u--u", 	"^", 	"u -"},
	{"", 	"u--u", 	"-", 	"u"},
	{"s", 	"u", 	"--w", 	"[u]"},
	{"s", 	"u--yo", 	"", 	"(u - [j] oU | [i] j oU)"},
	{"", 	"u", 	"", 	"u"},
	// Rule: v
	{"", 	"v", 	"", 	"v"},
	// Rule: w
	{" ", 	"wae", 	"", 	"w E"},
	{" ", 	"wa", 	"", 	"w A"},
	{" ", 	"weo", 	"", 	"w (ao | A)"},
	{" ", 	"we", 	"", 	"w E"},
	{" ", 	"wi", 	"", 	"w i"},
	{" ", 	"wo", 	"", 	"w oU"},
	{"", 	"wae", 	"", 	"[w] E"},
	{"", 	"wa", 	"", 	"[w] A"},
	{"", 	"weo", 	"", 	"[w] (ao | A)"},
	{"", 	"we", 	"", 	"[w] E"},
	{"", 	"wi", 	"", 	"[w] i"},
	{"", 	"wo", 	"", 	"[w] oU"},
	{"", 	"w", 	"", 	"w"},
	// Rule: y
	{" ", 	"yae", 	" ", 	"j (E | A) "},
	{"", 	"yae", 	"", 	"([j] @ | [j] E)"},
	{" ", 	"ya", 	"", 	"j A"},
	{" da-ch", 	"yeo", 	" ", 	"ao"},
	{" ", 	"yeo", 	"", 	"j ao"},
	{" ", 	"ye", 	" ", 	"E"},
	{"l", 	"ye", 	" ", 	"E"},
	{" g", 	"ye", 	"-si-", 	"E"},
	{" g", 	"ye", 	"-jib", 	"E"},
	{"ji-h", 	"ye", 	"-jib", 	"E"},
	{"yeon-g", 	"ye", 	" ", 	"E"},
	{" h", 	"ye", 	"-taeg", 	"E"},
	{"ji-h", 	"ye", 	" ", 	"E"},
	{" m", 	"ye", 	"-byeo", 	"E"},
	{"si-g", 	"ye", 	" ", 	"E"},
	{"gae-p", 	"ye", 	" ", 	"E"},
	{" ", 	"ye", 	"", 	"j E"},
	{" ", 	"yi", 	"", 	"(Ui | w i)"},
	{" ", 	"yo", 	"", 	"j oU"},
	{" ", 	"yu", 	"--#", 	"j u"},
	{" ", 	"yu", 	"", 	"j (u | U)"},
	{"", 	"ya", 	"", 	"(j | [l]) A"},
	{"", 	"yeo--eo", 	"^", 	"[j] ao -"},
	{"", 	"yeo--eo", 	"", 	"[j] ao"},
	{"", 	"yeo", 	"", 	"[j] ao"},
	{"", 	"ye", 	"", 	"[j] E"},
	{"ch", 	"yi", 	"", 	"(E | i)"},
	{"j", 	"y", 	"i", 	"oU"},
	{"^", 	"yi", 	"", 	"i"},
	{"", 	"yi", 	" ", 	"(i | E)"},
	{"", 	"yi", 	"", 	"(Ui | w i)"},
	{"", 	"yo", 	" ", 	"[j] (oU | E)"},
	{"", 	"yo", 	"", 	"[j] (oU |ao)"},
	{"o--", 	"yu", 	"--e", 	"j [u]"},
	{"", 	"yu", 	"--#", 	"[j] u"},
	{"", 	"yu", 	"", 	"[j] (u | U)"},
	{"", 	"y", 	"", 	"j"} 
};

int Initialize(void *pVoid)
{
	Graph2PhonPtr pLtsRules		= (Graph2PhonPtr)pVoid;

	pLtsRules->pRuleIndex		= sKrRuleIndex;
	pLtsRules->sLetters			= sKrLetters;
	pLtsRules->sNumbers			= sKrNumbers;
	pLtsRules->sVowels			= sKrVowels;
	pLtsRules->sVowels_f		= sKrVowels_f;
	pLtsRules->sConsonants		= sKrConsonants;
	pLtsRules->sConsonants_v	= sKrConsonants_v;
	pLtsRules->sNasals			= sKrNasals;
	pLtsRules->psOutputList		= psKrOutputList;
	pLtsRules->nOutputList		= nKrOutputList;
	pLtsRules->piRuleIndex		= piKrRuleIndex;
	pLtsRules->pPhoneticRules	= pKrPhoneticRules;

	return 0;
}

int Terminate(void *pVoid)
{
	Graph2PhonPtr pLtsRules = (Graph2PhonPtr)pVoid;

	memset(pLtsRules, 0, sizeof(GRAPH2PHON));

	return 0;
}
