// PH Rom file
//
// Copyright Information:
// 
//                           Copyright (c)
//    Copyright  2002 Fonix Corporation. All rights reserved.
//    Copyright  2000-2001 Force Computers, a Solectron Company. All rights reserved.
//     Digital Equipment Corporation 1996, 1997, 1998. All rights reserved.
// 
//    Restricted Rights: Use, duplication, or disclosure by the U.S.
//    Government is subject to restrictions as set forth in subparagraph
//    (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
//    52.227-14 Alt. III, as applicable.
// 
// 
//    This software is proprietary to and embodies the confidential
//    technology of Fonix Corporation and other parties.
//    Possession, use, or copying of this software and media is authorized
//    only pursuant to a valid written license from Fonix or an
//    authorized sublicensor.
// 
// Based on Dennis Klatt's PHRom File Format  Copyright (c) 1988 by Dennis Klatt
//
// Compile Type: Compiled from (0/0)
// Program: PHEdit(5.x)
//

#define US_SUE_PH_PHONEME_COUNT 71
#define US_SUE_PH_PHONEME_NAMES " _  IY IH EY EH AE AA AY AW AH AO OW OY UH UW RR YU AX IX IR ER AR OR UR W  YX R  L  HX RX LX M  N  NX EL DZ EN F  V  TH DH S  Z  SH ZH P  B  T  D  K  G  DX TX Q  CH JH DF TZ CZ LY RE X1 X2 X3 X4 X5 X6 X7 X8 X9 Z1 "

// Inherent Duration (milliseconds)
const short us_inhdr_sue[] = {
 305, 	// _ 
 170, 	// IY
 130, 	// IH
 200, 	// EY
 120, 	// EH
 230, 	// AE
 240, 	// AA
 235, 	// AY
 260, 	// AW
 160, 	// AH
 240, 	// AO
 220, 	// OW
 220, 	// OY
 170, 	// UH
 195, 	// UW
 180, 	// RR
 230, 	// YU
 160, 	// AX
 160, 	// IX
 230, 	// IR
 250, 	// ER
 250, 	// AR
 250, 	// OR
 230, 	// UR
 60, 	// W 
 75, 	// YX
 75, 	// R 
 70, 	// L 
 80, 	// HX
 120, 	// RX
 100, 	// LX
 80, 	// M 
 80, 	// N 
 120, 	// NX
 160, 	// EL
 60, 	// DZ
 150, 	// EN
 100, 	// F 
 100, 	// V 
 75, 	// TH
 100, 	// DH
 125, 	// S 
 120, 	// Z 
 125, 	// SH
 120, 	// ZH
 95, 	// P 
 80, 	// B 
 85, 	// T 
 80, 	// D 
 99, 	// K 
 70, 	// G 
 50, 	// DX
 70, 	// TX
 100, 	// Q 
 160, 	// CH
 100, 	// JH
 50, 	// DF
 100, 	// TZ
 120, 	// CZ
 120, 	// LY
 160, 	// RE
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
 0, 	// X6
 0, 	// X7
 0, 	// X8
 0, 	// X9
 0 }; 	//Z1

// Minimum Duration (milliseconds)
const short us_mindur_sue[] = {
 7, 	// _ 
 80, 	// IY
 60, 	// IH
 110, 	// EY
 60, 	// EH
 50, 	// AE
 90, 	// AA
 105, 	// AY
 110, 	// AW
 70, 	// AH
 140, 	// AO
 90, 	// OW
 110, 	// OY
 60, 	// UH
 70, 	// UW
 90, 	// RR
 100, 	// YU
 60, 	// AX
 60, 	// IX
 120, 	// IR
 120, 	// ER
 120, 	// AR
 120, 	// OR
 120, 	// UR
 15, 	// W 
 30, 	// YX
 30, 	// R 
 40, 	// L 
 60, 	// HX
 70, 	// RX
 70, 	// LX
 60, 	// M 
 50, 	// N 
 80, 	// NX
 110, 	// EL
 35, 	// DZ
 100, 	// EN
 60, 	// F 
 70, 	// V 
 50, 	// TH
 50, 	// DH
 65, 	// S 
 70, 	// Z 
 60, 	// SH
 70, 	// ZH
 70, 	// P 
 50, 	// B 
 50, 	// T 
 40, 	// D 
 55, 	// K 
 30, 	// G 
 25, 	// DX
 50, 	// TX
 70, 	// Q 
 100, 	// CH
 75, 	// JH
 25, 	// DF
 60, 	// TZ
 60, 	// CZ
 80, 	// LY
 120, 	// RE
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
 0, 	// X6
 0, 	// X7
 0, 	// X8
 0, 	// X9
 0 };	//Z1

// Burst Duration (milliseconds)
const short us_burdr_sue[] = {
 0, 	//_ 
 0, 	//IY
 0, 	//IH
 0, 	//EY
 0, 	//EH
 0, 	//AE
 0, 	//AA
 0, 	//AY
 0, 	//AW
 0, 	//AH
 0, 	//AO
 0, 	//OW
 0, 	//OY
 0, 	//UH
 0, 	//UW
 0, 	//RR
 0, 	//YU
 0, 	//AX
 0, 	//IX
 0, 	//IR
 0, 	//ER
 0, 	//AR
 0, 	//OR
 0, 	//UR
 0, 	//W 
 0, 	//YX
 0, 	//R 
 0, 	//L 
 0, 	//HX
 0, 	//RX
 0, 	//LX
 0, 	//M 
 0, 	//N 
 0, 	//NX
 0, 	//EL
 13, 	//DZ
 0, 	//EN
 0, 	//F 
 0, 	//V 
 0, 	//TH
 0, 	//DH
 0, 	//S 
 0, 	//Z 
 0, 	//SH
 0, 	//ZH
 7, 	//P 
 7, 	//B 
 7, 	//T 
 13, 	//D 
 13, 	//K 
 13, 	//G 
 0, 	//DX
 0, 	//TX
 0, 	//Q 
 71, 	//CH
 45, 	//JH
 0, 	//DF
 0, 	//TZ
 0, 	//CZ
 0, 	//LY
 0, 	//RE
 0, 	//X1
 0, 	//X2
 0, 	//X3
 0, 	//X4
 0, 	//X5
 0, 	//X6
 0, 	//X7
 0, 	//X8
 0, 	//X9
 0 };	//Z1

// Beginning Type (1=Front, 2=Back, 3=Rounded, 4=Null, 5=Beginning Rounded, 6=Opened)
const short us_begtyp_sue[] = {
 4, 	// _ 
 1, 	// IY
 1, 	// IH
 1, 	// EY
 1, 	// EH
 1, 	// AE
 2, 	// AA
 2, 	// AY
 2, 	// AW
 2, 	// AH
 3, 	// AO
 3, 	// OW
 3, 	// OY
 3, 	// UH
 3, 	// UW
 3, 	// RR
 1, 	// YU
 2, 	// AX
 1, 	// IX
 1, 	// IR
 1, 	// ER
 2, 	// AR
 3, 	// OR
 3, 	// UR
 5, 	// W 
 1, 	// YX
 5, 	// R 
 5, 	// L 
 4, 	// HX
 3, 	// RX
 5, 	// LX
 4, 	// M 
 4, 	// N 
 4, 	// NX
 5, 	// EL
 4, 	// DZ
 4, 	// EN
 4, 	// F 
 4, 	// V 
 4, 	// TH
 4, 	// DH
 4, 	// S 
 4, 	// Z 
 4, 	// SH
 4, 	// ZH
 4, 	// P 
 4, 	// B 
 4, 	// T 
 4, 	// D 
 4, 	// K 
 4, 	// G 
 4, 	// DX
 4, 	// TX
 4, 	// Q 
 4, 	// CH
 4, 	// JH
 4, 	// DF
 1, 	// TZ
 4, 	// CZ
 4, 	// LY
 1, 	// RE
 1, 	// X1
 1, 	// X2
 1, 	// X3
 1, 	// X4
 1, 	// X5
 1, 	// X6
 1, 	// X7
 1, 	// X8
 1, 	// X9
 1 };	// Z1

// Ending Type (1=Front, 2=Back, 3=Rounded, 4=Null, 5=Beginning Rounded, 6=Opened)
const short us_endtyp_sue[] = {
 4, 	// _ 
 1, 	// IY
 1, 	// IH
 1, 	// EY
 1, 	// EH
 1, 	// AE
 2, 	// AA
 1, 	// AY
 3, 	// AW
 2, 	// AH
 3, 	// AO
 3, 	// OW
 1, 	// OY
 3, 	// UH
 5, 	// UW
 3, 	// RR
 3, 	// YU
 2, 	// AX
 1, 	// IX
 3, 	// IR
 3, 	// ER
 3, 	// AR
 3, 	// OR
 3, 	// UR
 5, 	// W 
 1, 	// YX
 5, 	// R 
 5, 	// L 
 4, 	// HX
 3, 	// RX
 5, 	// LX
 4, 	// M 
 4, 	// N 
 4, 	// NX
 5, 	// EL
 4, 	// DZ
 4, 	// EN
 4, 	// F 
 4, 	// V 
 4, 	// TH
 4, 	// DH
 4, 	// S 
 4, 	// Z 
 4, 	// SH
 4, 	// ZH
 4, 	// P 
 4, 	// B 
 4, 	// T 
 4, 	// D 
 4, 	// K 
 4, 	// G 
 4, 	// DX
 4, 	// TX
 4, 	// Q 
 4, 	// CH
 4, 	// JH
 4, 	// DF
 1, 	// TZ
 4, 	// CZ
 4, 	// LY
 1, 	// RE
 1, 	// X1
 1, 	// X2
 1, 	// X3
 1, 	// X4
 1, 	// X5
 1, 	// X6
 1, 	// X7
 1, 	// X8
 1, 	// X9
 1 };	// Z1

// Place of articulation
// FLABIAL		0x0001
// FDENTAL		0x0002
// FPALATL		0x0004
// FALVEL		0x0008
// FVELAR		0x0010
// FGLOTAL		0x0020
// F2BACKI		0x0040
// F2BACKF		0x0080
// FLABIALDENTAL	0x0100
// FPOSTALVEOLAR	0x0200
// FUVULAR		0x0400
// FPHARYNGEAL	0x0800
// FVELARF		0x1000
// FVELARB		0x2000
// FVELARR		0x4000
const short us_place_sue[] = {
 0x0000, 	// _ 
 0x0080, 	// IY
 0x0000, 	// IH
 0x0080, 	// EY
 0x0000, 	// EH
 0x0000, 	// AE
 0x0000, 	// AA
 0x0000, 	// AY
 0x0000, 	// AW
 0x0000, 	// AH
 0x0000, 	// AO
 0x0000, 	// OW
 0x0000, 	// OY
 0x0000, 	// UH
 0x0000, 	// UW
 0x0000, 	// RR
 0x0040, 	// YU
 0x0000, 	// AX
 0x0000, 	// IX
 0x0000, 	// IR
 0x0000, 	// ER
 0x0000, 	// AR
 0x0000, 	// OR
 0x0000, 	// UR
 0x0000, 	// W 
 0x00c0, 	// YX
 0x0000, 	// R 
 0x0000, 	// L 
 0x0000, 	// HX
 0x0000, 	// RX
 0x0000, 	// LX
 0x0001, 	// M 
 0x0008, 	// N 
 0x0010, 	// NX
 0x0000, 	// EL
 0x0002, 	// DZ
 0x0008, 	// EN
 0x0001, 	// F 
 0x0001, 	// V 
 0x0002, 	// TH
 0x0002, 	// DH
 0x0008, 	// S 
 0x0008, 	// Z 
 0x0004, 	// SH
 0x0004, 	// ZH
 0x0001, 	// P 
 0x0001, 	// B 
 0x0008, 	// T 
 0x0008, 	// D 
 0x0010, 	// K 
 0x0010, 	// G 
 0x0000, 	// DX
 0x0028, 	// TX
 0x0020, 	// Q 
 0x0004, 	// CH
 0x0004, 	// JH
 0x0000, 	// DF
 0x0004, 	// TZ
 0x0020, 	// CZ
 0x0000, 	// LY
 0x0000, 	// RE
 0x0000, 	// X1
 0x0000, 	// X2
 0x0000, 	// X3
 0x0000, 	// X4
 0x0000, 	// X5
 0x0000, 	// X6
 0x0000, 	// X7
 0x0000, 	// X8
 0x0000, 	// X9
 0x0000 };	// Z1

// Feature bits
// FSYLL		0x00000001
// FVOICD		0x00000002
// FVOWEL		0x00000004
// FSON1		0x00000008
// FSONOR		0x00000010
// FOBST		0x00000020
// FPLOSV		0x00000040
// FNASAL		0x00000080
// FCONSON		0x00000100
// FSONCON		0x00000200
// FSON2		0x00000400
// FBURST		0x00000800
// FSTMARK		0x00001000
// FSTOP		0x00002000
// FFLAP		0x00004000
// FLATERAL		0x00008000
// FRETROFLEX	0x00010000
// FNFI1		0x00020000
// FNFI2		0x00040000
// FNFI3		0x00080000
const int us_featb_sue[] = {
 0x00000222, 	// _ 
 0x0000001f, 	// IY
 0x0000001f, 	// IH
 0x0000001f, 	// EY
 0x0000001f, 	// EH
 0x0000001f, 	// AE
 0x0000001f, 	// AA
 0x0000001f, 	// AY
 0x0000001f, 	// AW
 0x0000001f, 	// AH
 0x0000001f, 	// AO
 0x0000001f, 	// OW
 0x0000001f, 	// OY
 0x0000001f, 	// UH
 0x0000001f, 	// UW
 0x0000001f, 	// RR
 0x0000041f, 	// YU
 0x0000001f, 	// AX
 0x0000001f, 	// IX
 0x0000001f, 	// IR
 0x0000001f, 	// ER
 0x0000001f, 	// AR
 0x0000001f, 	// OR
 0x0000001f, 	// UR
 0x0000073a, 	// W 
 0x0000071a, 	// YX
 0x0000071a, 	// R 
 0x0000071a, 	// L 
 0x00000110, 	// HX
 0x0000031a, 	// RX
 0x0000031a, 	// LX
 0x0000259a, 	// M 
 0x0000259a, 	// N 
 0x0000259a, 	// NX
 0x0000001b, 	// EL
 0x00002962, 	// DZ
 0x0000249b, 	// EN
 0x00000120, 	// F 
 0x00000122, 	// V 
 0x00000120, 	// TH
 0x00000122, 	// DH
 0x00000120, 	// S 
 0x00000122, 	// Z 
 0x00000120, 	// SH
 0x00000122, 	// ZH
 0x00002960, 	// P 
 0x00002962, 	// B 
 0x00002960, 	// T 
 0x00002962, 	// D 
 0x00002960, 	// K 
 0x00002962, 	// G 
 0x00002122, 	// DX
 0x00002962, 	// TX
 0x00000000, 	// Q 
 0x00002920, 	// CH
 0x00002922, 	// JH
 0x00002122, 	// DF
 0x00000120, 	// TZ
 0x00000120, 	// CZ
 0x0000071a, 	// LY
 0x0000060f, 	// RE
 0x00000000, 	// X1
 0x00000000, 	// X2
 0x00000000, 	// X3
 0x00000000, 	// X4
 0x00000000, 	// X5
 0x00000000, 	// X6
 0x00000000, 	// X7
 0x00000000, 	// X8
 0x00000000, 	// X9
 0x00000000, 	// Z1
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
 0, 
0 };

// Male - F1,F2,F3,B1,B2,B3,AV data for each phoneme
//     Negative numbers are offsets into maldip table (multi-part formants)
//     Positive numbers are actual values
const short us_maltar_sue[] = {
// ==== F1 ====
 500, 	// _ 
 -2, 	// IY
 -8, 	// IH
 -12, 	// EY
 -18, 	// EH
 -24, 	// AE
 646, 	// AA
 -30, 	// AY
 -38, 	// AW
 -44, 	// AH
 -50, 	// AO
 -56, 	// OW
 -62, 	// OY
 -70, 	// UH
 -76, 	// UW
 -80, 	// RR
 -86, 	// YU
 -92, 	// AX
 -98, 	// IX
 -104, 	// IR
 -110, 	// ER
 -116, 	// AR
 -122, 	// OR
 -128, 	// UR
 295, 	// W 
 280, 	// YX
 350, 	// R 
 366, 	// L 
 -1, 	// HX
 470, 	// RX
 425, 	// LX
 300, 	// M 
 320, 	// N 
 280, 	// NX
 350, 	// EL
 300, 	// DZ
 280, 	// EN
 340, 	// F 
 325, 	// V 
 460, 	// TH
 290, 	// DH
 320, 	// S 
 325, 	// Z 
 300, 	// SH
 280, 	// ZH
 350, 	// P 
 220, 	// B 
 350, 	// T 
 300, 	// D 
 280, 	// K 
 250, 	// G 
 350, 	// DX
 280, 	// TX
 -1, 	// Q 
 350, 	// CH
 280, 	// JH
 320, 	// DF
 -1, 	// TZ
 300, 	// CZ
 400, 	// LY
 -1, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== F2 ====
 1500, 	// _ 
 -134, 	// IY
 -140, 	// IH
 -144, 	// EY
 -150, 	// EH
 -156, 	// AE
 1117, 	// AA
 -162, 	// AY
 -168, 	// AW
 -174, 	// AH
 -180, 	// AO
 -186, 	// OW
 -192, 	// OY
 -200, 	// UH
 -206, 	// UW
 -210, 	// RR
 -216, 	// YU
 -222, 	// AX
 -228, 	// IX
 -234, 	// IR
 -240, 	// ER
 -246, 	// AR
 -252, 	// OR
 -258, 	// UR
 810, 	// W 
 2070, 	// YX
 1050, 	// R 
 875, 	// L 
 -1, 	// HX
 1270, 	// RX
 800, 	// LX
 1170, 	// M 
 1650, 	// N 
 2100, 	// NX
 800, 	// EL
 1400, 	// DZ
 1544, 	// EN
 1100, 	// F 
 1100, 	// V 
 1500, 	// TH
 1500, 	// DH
 1520, 	// S 
 1520, 	// Z 
 1600, 	// SH
 1900, 	// ZH
 1051, 	// P 
 691, 	// B 
 1650, 	// T 
 1650, 	// D 
 1790, 	// K 
 1800, 	// G 
 1413, 	// DX
 1600, 	// TX
 -1, 	// Q 
 1750, 	// CH
 1730, 	// JH
 -1, 	// DF
 -1, 	// TZ
 1400, 	// CZ
 900, 	// LY
 -1, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== F3 ====
 2900, 	// _ 
 -264, 	// IY
 -270, 	// IH
 -274, 	// EY
 -280, 	// EH
 -286, 	// AE
 2361, 	// AA
 -292, 	// AY
 -300, 	// AW
 -306, 	// AH
 -312, 	// AO
 -318, 	// OW
 -324, 	// OY
 -332, 	// UH
 -338, 	// UW
 -342, 	// RR
 -348, 	// YU
 -354, 	// AX
 -360, 	// IX
 -366, 	// IR
 -372, 	// ER
 -378, 	// AR
 -384, 	// OR
 -390, 	// UR
 2177, 	// W 
 2570, 	// YX
 1400, 	// R 
 2441, 	// L 
 -1, 	// HX
 1540, 	// RX
 2800, 	// LX
 2000, 	// M 
 2600, 	// N 
 2600, 	// NX
 2850, 	// EL
 2600, 	// DZ
 2400, 	// EN
 2080, 	// F 
 2144, 	// V 
 2420, 	// TH
 2560, 	// DH
 2550, 	// S 
 2500, 	// Z 
 2550, 	// SH
 2550, 	// ZH
 2150, 	// P 
 2177, 	// B 
 2600, 	// T 
 2600, 	// D 
 2200, 	// K 
 2500, 	// G 
 2305, 	// DX
 2600, 	// TX
 -1, 	// Q 
 2700, 	// CH
 2700, 	// JH
 -1, 	// DF
 -1, 	// TZ
 2400, 	// CZ
 2800, 	// LY
 -1, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== B1 ====
 -1, 	// _ 
 60, 	// IY
 60, 	// IH
 70, 	// EY
 60, 	// EH
 -396, 	// AE
 120, 	// AA
 130, 	// AY
 -402, 	// AW
 90, 	// AH
 110, 	// AO
 90, 	// OW
 200, 	// OY
 80, 	// UH
 90, 	// UW
 90, 	// RR
 70, 	// YU
 90, 	// AX
 60, 	// IX
 80, 	// IR
 80, 	// ER
 140, 	// AR
 100, 	// OR
 90, 	// UR
 90, 	// W 
 50, 	// YX
 70, 	// R 
 70, 	// L 
 300, 	// HX
 80, 	// RX
 140, 	// LX
 130, 	// M 
 90, 	// N 
 130, 	// NX
 90, 	// EL
 90, 	// DZ
 90, 	// EN
 200, 	// F 
 100, 	// V 
 200, 	// TH
 100, 	// DH
 200, 	// S 
 100, 	// Z 
 200, 	// SH
 100, 	// ZH
 200, 	// P 
 90, 	// B 
 200, 	// T 
 90, 	// D 
 200, 	// K 
 90, 	// G 
 90, 	// DX
 110, 	// TX
 -1, 	// Q 
 200, 	// CH
 70, 	// JH
 90, 	// DF
 -1, 	// TZ
 90, 	// CZ
 -1, 	// LY
 -1, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== B2 ====
 -1, 	// _ 
 100, 	// IY
 100, 	// IH
 100, 	// EY
 150, 	// EH
 -408, 	// AE
 150, 	// AA
 100, 	// AY
 75, 	// AW
 70, 	// AH
 90, 	// AO
 70, 	// OW
 -414, 	// OY
 83, 	// UH
 90, 	// UW
 110, 	// RR
 -420, 	// YU
 80, 	// AX
 100, 	// IX
 120, 	// IR
 110, 	// ER
 90, 	// AR
 80, 	// OR
 90, 	// UR
 110, 	// W 
 200, 	// YX
 120, 	// R 
 160, 	// L 
 200, 	// HX
 120, 	// RX
 222, 	// LX
 120, 	// M 
 120, 	// N 
 160, 	// NX
 90, 	// EL
 110, 	// DZ
 120, 	// EN
 120, 	// F 
 120, 	// V 
 90, 	// TH
 120, 	// DH
 180, 	// S 
 140, 	// Z 
 240, 	// SH
 160, 	// ZH
 180, 	// P 
 80, 	// B 
 150, 	// T 
 100, 	// D 
 160, 	// K 
 120, 	// G 
 100, 	// DX
 100, 	// TX
 -1, 	// Q 
 280, 	// CH
 170, 	// JH
 100, 	// DF
 -1, 	// TZ
 120, 	// CZ
 -1, 	// LY
 -1, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== B3 ====
 -1, 	// _ 
 160, 	// IY
 190, 	// IH
 200, 	// EY
 220, 	// EH
 290, 	// AE
 250, 	// AA
 230, 	// AY
 150, 	// AW
 180, 	// AH
 120, 	// AO
 180, 	// OW
 170, 	// OY
 160, 	// UH
 140, 	// UW
 250, 	// RR
 -426, 	// YU
 180, 	// AX
 200, 	// IX
 200, 	// IR
 200, 	// ER
 150, 	// AR
 140, 	// OR
 180, 	// UR
 150, 	// W 
 300, 	// YX
 150, 	// R 
 180, 	// L 
 220, 	// HX
 150, 	// RX
 233, 	// LX
 250, 	// M 
 160, 	// N 
 320, 	// NX
 200, 	// EL
 200, 	// DZ
 160, 	// EN
 150, 	// F 
 120, 	// V 
 150, 	// TH
 170, 	// DH
 300, 	// S 
 300, 	// Z 
 300, 	// SH
 300, 	// ZH
 180, 	// P 
 130, 	// B 
 250, 	// T 
 240, 	// D 
 280, 	// K 
 180, 	// G 
 150, 	// DX
 170, 	// TX
 -1, 	// Q 
 250, 	// CH
 250, 	// JH
 170, 	// DF
 -1, 	// TZ
 150, 	// CZ
 -1, 	// LY
 -1, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== AV ====
 0, 	// _ 
 64, 	// IY
 65, 	// IH
 65, 	// EY
 63, 	// EH
 63, 	// AE
 64, 	// AA
 66, 	// AY
 64, 	// AW
 64, 	// AH
 64, 	// AO
 65, 	// OW
 64, 	// OY
 65, 	// UH
 65, 	// UW
 65, 	// RR
 65, 	// YU
 62, 	// AX
 63, 	// IX
 65, 	// IR
 65, 	// ER
 64, 	// AR
 65, 	// OR
 65, 	// UR
 60, 	// W 
 64, 	// YX
 64, 	// R 
 63, 	// L 
 0, 	// HX
 64, 	// RX
 63, 	// LX
 58, 	// M 
 60, 	// N 
 60, 	// NX
 63, 	// EL
 50, 	// DZ
 60, 	// EN
 0, 	// F 
 53, 	// V 
 0, 	// TH
 53, 	// DH
 0, 	// S 
 53, 	// Z 
 0, 	// SH
 53, 	// ZH
 0, 	// P 
 0, 	// B 
 0, 	// T 
 0, 	// D 
 0, 	// K 
 0, 	// G 
 50, 	// DX
 0, 	// TX
 54, 	// Q 
 0, 	// CH
 0, 	// JH
 53, 	// DF
 0, 	// TZ
 0, 	// CZ
 64, 	// LY
 0, 	// RE
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
 0, 	// X6
 0, 	// X7
 0, 	// X8
 0, 	// X9
 0 };	// Z1

// Female - F1,F2,F3,B1,B2,B3,AV data for each phoneme
//     Negative numbers are offsets into femdip table (multi-part formants)
//     Positive numbers are actual values
const short us_femtar_sue[] = {
// ==== F1 ====
 -1, 	// _ 
 -2, 	// IY
 -6, 	// IH
 -10, 	// EY
 570, 	// EH
 -16, 	// AE
 -22, 	// AA
 -28, 	// AY
 -34, 	// AW
 -40, 	// AH
 -46, 	// AO
 -52, 	// OW
 -58, 	// OY
 -66, 	// UH
 -72, 	// UW
 -78, 	// RR
 -84, 	// YU
 -90, 	// AX
 -96, 	// IX
 -102, 	// IR
 -108, 	// ER
 -114, 	// AR
 -120, 	// OR
 -126, 	// UR
 350, 	// W 
 320, 	// YX
 350, 	// R 
 325, 	// L 
 -132, 	// HX
 490, 	// RX
 480, 	// LX
 300, 	// M 
 350, 	// N 
 180, 	// NX
 480, 	// EL
 220, 	// DZ
 450, 	// EN
 360, 	// F 
 300, 	// V 
 340, 	// TH
 320, 	// DH
 340, 	// S 
 300, 	// Z 
 320, 	// SH
 300, 	// ZH
 370, 	// P 
 220, 	// B 
 370, 	// T 
 220, 	// D 
 180, 	// K 
 180, 	// G 
 370, 	// DX
 220, 	// TX
 -1, 	// Q 
 370, 	// CH
 280, 	// JH
 320, 	// DF
 410, 	// TZ
 370, 	// CZ
 -136, 	// LY
 -142, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== F2 ====
 -1, 	// _ 
 -150, 	// IY
 -154, 	// IH
 -158, 	// EY
 2217, 	// EH
 -164, 	// AE
 -170, 	// AA
 -176, 	// AY
 -184, 	// AW
 -190, 	// AH
 -196, 	// AO
 -202, 	// OW
 -208, 	// OY
 -216, 	// UH
 -222, 	// UW
 -228, 	// RR
 -234, 	// YU
 -240, 	// AX
 -246, 	// IX
 -252, 	// IR
 -258, 	// ER
 -264, 	// AR
 -270, 	// OR
 -276, 	// UR
 800, 	// W 
 2490, 	// YX
 1033, 	// R 
 1200, 	// L 
 -1, 	// HX
 1600, 	// RX
 930, 	// LX
 1340, 	// M 
 1400, 	// N 
 2056, 	// NX
 990, 	// EL
 1860, 	// DZ
 1530, 	// EN
 1150, 	// F 
 1150, 	// V 
 1530, 	// TH
 1500, 	// DH
 1800, 	// S 
 1640, 	// Z 
 1980, 	// SH
 1980, 	// ZH
 1150, 	// P 
 1150, 	// B 
 1860, 	// T 
 2040, 	// D 
 2190, 	// K 
 2190, 	// G 
 1560, 	// DX
 1860, 	// TX
 -1, 	// Q 
 2100, 	// CH
 2100, 	// JH
 1560, 	// DF
 1650, 	// TZ
 1600, 	// CZ
 -282, 	// LY
 -288, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== F3 ====
 -1, 	// _ 
 -296, 	// IY
 -300, 	// IH
 -304, 	// EY
 3002, 	// EH
 -310, 	// AE
 -316, 	// AA
 -322, 	// AY
 -330, 	// AW
 -336, 	// AH
 -342, 	// AO
 -348, 	// OW
 -354, 	// OY
 -362, 	// UH
 -368, 	// UW
 -374, 	// RR
 -380, 	// YU
 -386, 	// AX
 -392, 	// IX
 -398, 	// IR
 -404, 	// ER
 -410, 	// AR
 -416, 	// OR
 -422, 	// UR
 2630, 	// W 
 3400, 	// YX
 1700, 	// R 
 2900, 	// L 
 -1, 	// HX
 1950, 	// RX
 3320, 	// LX
 2590, 	// M 
 2250, 	// N 
 3100, 	// NX
 3320, 	// EL
 3020, 	// DZ
 2920, 	// EN
 2460, 	// F 
 2460, 	// V 
 2940, 	// TH
 2940, 	// DH
 3122, 	// S 
 3000, 	// Z 
 2930, 	// SH
 2940, 	// ZH
 2470, 	// P 
 2470, 	// B 
 3020, 	// T 
 2900, 	// D 
 2710, 	// K 
 2710, 	// G 
 3000, 	// DX
 3000, 	// TX
 -1, 	// Q 
 3150, 	// CH
 3150, 	// JH
 3000, 	// DF
 2700, 	// TZ
 2400, 	// CZ
 -428, 	// LY
 -434, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== B1 ====
 -1, 	// _ 
 80, 	// IY
 75, 	// IH
 90, 	// EY
 60, 	// EH
 -442, 	// AE
 90, 	// AA
 -448, 	// AY
 -454, 	// AW
 100, 	// AH
 160, 	// AO
 110, 	// OW
 100, 	// OY
 90, 	// UH
 90, 	// UW
 90, 	// RR
 80, 	// YU
 140, 	// AX
 80, 	// IX
 80, 	// IR
 120, 	// ER
 130, 	// AR
 90, 	// OR
 80, 	// UR
 80, 	// W 
 170, 	// YX
 90, 	// R 
 90, 	// L 
 500, 	// HX
 90, 	// RX
 90, 	// LX
 120, 	// M 
 120, 	// N 
 120, 	// NX
 90, 	// EL
 120, 	// DZ
 110, 	// EN
 200, 	// F 
 140, 	// V 
 200, 	// TH
 120, 	// DH
 200, 	// S 
 140, 	// Z 
 200, 	// SH
 120, 	// ZH
 200, 	// P 
 100, 	// B 
 200, 	// T 
 110, 	// D 
 200, 	// K 
 100, 	// G 
 100, 	// DX
 90, 	// TX
 100, 	// Q 
 200, 	// CH
 120, 	// JH
 100, 	// DF
 90, 	// TZ
 90, 	// CZ
 -1, 	// LY
 -1, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== B2 ====
 -1, 	// _ 
 140, 	// IY
 140, 	// IH
 200, 	// EY
 120, 	// EH
 120, 	// AE
 150, 	// AA
 240, 	// AY
 -460, 	// AW
 170, 	// AH
 330, 	// AO
 110, 	// OW
 -464, 	// OY
 100, 	// UH
 100, 	// UW
 250, 	// RR
 -470, 	// YU
 140, 	// AX
 180, 	// IX
 220, 	// IR
 190, 	// ER
 200, 	// AR
 170, 	// OR
 130, 	// UR
 80, 	// W 
 180, 	// YX
 150, 	// R 
 110, 	// L 
 -1, 	// HX
 200, 	// RX
 110, 	// LX
 340, 	// M 
 160, 	// N 
 600, 	// NX
 120, 	// EL
 90, 	// DZ
 200, 	// EN
 140, 	// F 
 120, 	// V 
 220, 	// TH
 210, 	// DH
 200, 	// S 
 170, 	// Z 
 240, 	// SH
 160, 	// ZH
 180, 	// P 
 110, 	// B 
 150, 	// T 
 140, 	// D 
 160, 	// K 
 100, 	// G 
 100, 	// DX
 100, 	// TX
 -1, 	// Q 
 230, 	// CH
 170, 	// JH
 100, 	// DF
 120, 	// TZ
 120, 	// CZ
 -1, 	// LY
 -1, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== B3 ====
 -1, 	// _ 
 270, 	// IY
 220, 	// IH
 180, 	// EY
 140, 	// EH
 300, 	// AE
 160, 	// AA
 180, 	// AY
 -476, 	// AW
 110, 	// AH
 240, 	// AO
 180, 	// OW
 180, 	// OY
 170, 	// UH
 180, 	// UW
 120, 	// RR
 -480, 	// YU
 200, 	// AX
 240, 	// IX
 200, 	// IR
 210, 	// ER
 160, 	// AR
 130, 	// OR
 140, 	// UR
 110, 	// W 
 200, 	// YX
 130, 	// R 
 120, 	// L 
 -1, 	// HX
 150, 	// RX
 130, 	// LX
 250, 	// M 
 250, 	// N 
 550, 	// NX
 200, 	// EL
 120, 	// DZ
 160, 	// EN
 150, 	// F 
 120, 	// V 
 300, 	// TH
 270, 	// DH
 200, 	// S 
 200, 	// Z 
 300, 	// SH
 300, 	// ZH
 180, 	// P 
 150, 	// B 
 250, 	// T 
 170, 	// D 
 280, 	// K 
 150, 	// G 
 130, 	// DX
 130, 	// TX
 -1, 	// Q 
 350, 	// CH
 350, 	// JH
 130, 	// DF
 150, 	// TZ
 150, 	// CZ
 -1, 	// LY
 -1, 	// RE
 -1, 	// X1
 -1, 	// X2
 -1, 	// X3
 -1, 	// X4
 -1, 	// X5
 -1, 	// X6
 -1, 	// X7
 -1, 	// X8
 -1, 	// X9
 -1, 	// Z1
// ==== AV ====
 0, 	// _ 
 65, 	// IY
 65, 	// IH
 65, 	// EY
 65, 	// EH
 65, 	// AE
 64, 	// AA
 64, 	// AY
 64, 	// AW
 64, 	// AH
 64, 	// AO
 65, 	// OW
 65, 	// OY
 65, 	// UH
 65, 	// UW
 64, 	// RR
 65, 	// YU
 62, 	// AX
 63, 	// IX
 65, 	// IR
 65, 	// ER
 64, 	// AR
 64, 	// OR
 65, 	// UR
 64, 	// W 
 64, 	// YX
 64, 	// R 
 64, 	// L 
 0, 	// HX
 64, 	// RX
 64, 	// LX
 60, 	// M 
 60, 	// N 
 60, 	// NX
 63, 	// EL
 50, 	// DZ
 60, 	// EN
 0, 	// F 
 53, 	// V 
 0, 	// TH
 53, 	// DH
 0, 	// S 
 53, 	// Z 
 0, 	// SH
 53, 	// ZH
 0, 	// P 
 0, 	// B 
 0, 	// T 
 0, 	// D 
 0, 	// K 
 0, 	// G 
 34, 	// DX
 0, 	// TX
 50, 	// Q 
 0, 	// CH
 0, 	// JH
 53, 	// DF
 0, 	// TZ
 0, 	// CZ
 63, 	// LY
 0, 	// RE
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
 0, 	// X6
 0, 	// X7
 0, 	// X8
 0, 	// X9
 0 };	// Z1

// Male - F1,F1T,F2,F2T,F3,F3T,B1,B1T,B2,B2T,B3,B3T,AV,AVT data for Multi-part formants
const short us_maldip_sue[] = {
// ====== Formants Frequencies and duration ======
 0, 	// _ 
 0, 	// _ 
 386, 	// IY F1
 10, 	// IY F1 duration
 325, 	// IY F1
 120, 	// IY F1 duration
 305, 	// IY F1
 -1, 	// IY F1 duration
 460, 	// IH F1
 60, 	// IH F1 duration
 550, 	// IH F1
 -1, 	// IH F1 duration
 520, 	// EY F1
 10, 	// EY F1 duration
 480, 	// EY F1
 160, 	// EY F1 duration
 460, 	// EY F1
 -1, 	// EY F1 duration
 550, 	// EH F1
 60, 	// EH F1 duration
 590, 	// EH F1
 110, 	// EH F1 duration
 590, 	// EH F1
 -1, 	// EH F1 duration
 680, 	// AE F1
 130, 	// AE F1 duration
 730, 	// AE F1
 210, 	// AE F1 duration
 730, 	// AE F1
 -1, 	// AE F1 duration
 730, 	// AY F1
 70, 	// AY F1 duration
 770, 	// AY F1
 130, 	// AY F1 duration
 530, 	// AY F1
 210, 	// AY F1 duration
 530, 	// AY F1
 -1, 	// AY F1 duration
 710, 	// AW F1
 110, 	// AW F1 duration
 550, 	// AW F1
 230, 	// AW F1 duration
 550, 	// AW F1
 -1, 	// AW F1 duration
 620, 	// AH F1
 40, 	// AH F1 duration
 620, 	// AH F1
 100, 	// AH F1 duration
 620, 	// AH F1
 -1, 	// AH F1 duration
 640, 	// AO F1
 120, 	// AO F1 duration
 700, 	// AO F1
 220, 	// AO F1 duration
 700, 	// AO F1
 -1, 	// AO F1 duration
 540, 	// OW F1
 40, 	// OW F1 duration
 468, 	// OW F1
 150, 	// OW F1 duration
 460, 	// OW F1
 -1, 	// OW F1 duration
 540, 	// OY F1
 10, 	// OY F1 duration
 580, 	// OY F1
 90, 	// OY F1 duration
 470, 	// OY F1
 220, 	// OY F1 duration
 470, 	// OY F1
 -1, 	// OY F1 duration
 480, 	// UH F1
 70, 	// UH F1 duration
 530, 	// UH F1
 130, 	// UH F1 duration
 530, 	// UH F1
 -1, 	// UH F1 duration
 370, 	// UW F1
 40, 	// UW F1 duration
 340, 	// UW F1
 -1, 	// UW F1 duration
 490, 	// RR F1
 30, 	// RR F1 duration
 460, 	// RR F1
 170, 	// RR F1 duration
 460, 	// RR F1
 -1, 	// RR F1 duration
 270, 	// YU F1
 45, 	// YU F1 duration
 360, 	// YU F1
 150, 	// YU F1 duration
 360, 	// YU F1
 -1, 	// YU F1 duration
 550, 	// AX F1
 30, 	// AX F1 duration
 550, 	// AX F1
 90, 	// AX F1 duration
 550, 	// AX F1
 -1, 	// AX F1 duration
 460, 	// IX F1
 30, 	// IX F1 duration
 460, 	// IX F1
 90, 	// IX F1 duration
 460, 	// IX F1
 -1, 	// IX F1 duration
 350, 	// IR F1
 100, 	// IR F1 duration
 420, 	// IR F1
 170, 	// IR F1 duration
 420, 	// IR F1
 -1, 	// IR F1 duration
 490, 	// ER F1
 40, 	// ER F1 duration
 490, 	// ER F1
 230, 	// ER F1 duration
 490, 	// ER F1
 -1, 	// ER F1 duration
 660, 	// AR F1
 100, 	// AR F1 duration
 570, 	// AR F1
 180, 	// AR F1 duration
 570, 	// AR F1
 -1, 	// AR F1 duration
 510, 	// OR F1
 90, 	// OR F1 duration
 490, 	// OR F1
 180, 	// OR F1 duration
 490, 	// OR F1
 -1, 	// OR F1 duration
 420, 	// UR F1
 80, 	// UR F1 duration
 440, 	// UR F1
 170, 	// UR F1 duration
 440, 	// UR F1
 -1, 	// UR F1 duration
 1770, 	// IY F2
 10, 	// IY F2 duration
 1953, 	// IY F2
 120, 	// IY F2 duration
 1973, 	// IY F2
 -1, 	// IY F2 duration
 1650, 	// IH F2
 60, 	// IH F2 duration
 1580, 	// IH F2
 -1, 	// IH F2 duration
 1720, 	// EY F2
 10, 	// EY F2 duration
 2000, 	// EY F2
 160, 	// EY F2 duration
 2000, 	// EY F2
 -1, 	// EY F2 duration
 1580, 	// EH F2
 80, 	// EH F2 duration
 1460, 	// EH F2
 140, 	// EH F2 duration
 1420, 	// EH F2
 -1, 	// EH F2 duration
 1600, 	// AE F2
 40, 	// AE F2 duration
 1600, 	// AE F2
 120, 	// AE F2 duration
 1440, 	// AE F2
 -1, 	// AE F2 duration
 1200, 	// AY F2
 90, 	// AY F2 duration
 1850, 	// AY F2
 210, 	// AY F2 duration
 1850, 	// AY F2
 -1, 	// AY F2 duration
 1200, 	// AW F2
 110, 	// AW F2 duration
 820, 	// AW F2
 225, 	// AW F2 duration
 820, 	// AW F2
 -1, 	// AW F2 duration
 1170, 	// AH F2
 40, 	// AH F2 duration
 1170, 	// AH F2
 100, 	// AH F2 duration
 1170, 	// AH F2
 -1, 	// AH F2 duration
 929, 	// AO F2
 120, 	// AO F2 duration
 1100, 	// AO F2
 220, 	// AO F2 duration
 1125, 	// AO F2
 -1, 	// AO F2 duration
 1020, 	// OW F2
 40, 	// OW F2 duration
 790, 	// OW F2
 150, 	// OW F2 duration
 790, 	// OW F2
 -1, 	// OW F2 duration
 900, 	// OY F2
 50, 	// OY F2 duration
 920, 	// OY F2
 90, 	// OY F2 duration
 1860, 	// OY F2
 220, 	// OY F2 duration
 1860, 	// OY F2
 -1, 	// OY F2 duration
 1100, 	// UH F2
 70, 	// UH F2 duration
 1070, 	// UH F2
 130, 	// UH F2 duration
 1070, 	// UH F2
 -1, 	// UH F2 duration
 1060, 	// UW F2
 40, 	// UW F2 duration
 840, 	// UW F2
 -1, 	// UW F2 duration
 1220, 	// RR F2
 30, 	// RR F2 duration
 1220, 	// RR F2
 170, 	// RR F2 duration
 1220, 	// RR F2
 -1, 	// RR F2 duration
 2000, 	// YU F2
 45, 	// YU F2 duration
 1050, 	// YU F2
 150, 	// YU F2 duration
 1000, 	// YU F2
 -1, 	// YU F2 duration
 1260, 	// AX F2
 30, 	// AX F2 duration
 1260, 	// AX F2
 90, 	// AX F2 duration
 1260, 	// AX F2
 -1, 	// AX F2 duration
 1680, 	// IX F2
 30, 	// IX F2 duration
 1680, 	// IX F2
 90, 	// IX F2 duration
 1680, 	// IX F2
 -1, 	// IX F2 duration
 1850, 	// IR F2
 100, 	// IR F2 duration
 1540, 	// IR F2
 170, 	// IR F2 duration
 1510, 	// IR F2
 -1, 	// IR F2 duration
 1650, 	// ER F2
 110, 	// ER F2 duration
 1500, 	// ER F2
 190, 	// ER F2 duration
 1500, 	// ER F2
 -1, 	// ER F2 duration
 1210, 	// AR F2
 100, 	// AR F2 duration
 1280, 	// AR F2
 180, 	// AR F2 duration
 1280, 	// AR F2
 -1, 	// AR F2 duration
 870, 	// OR F2
 100, 	// OR F2 duration
 1200, 	// OR F2
 190, 	// OR F2 duration
 1200, 	// OR F2
 -1, 	// OR F2 duration
 860, 	// UR F2
 80, 	// UR F2 duration
 1170, 	// UR F2
 170, 	// UR F2 duration
 1200, 	// UR F2
 -1, 	// UR F2 duration
 2541, 	// IY F3
 10, 	// IY F3 duration
 2624, 	// IY F3
 120, 	// IY F3 duration
 2624, 	// IY F3
 -1, 	// IY F3 duration
 2520, 	// IH F3
 60, 	// IH F3 duration
 2520, 	// IH F3
 -1, 	// IH F3 duration
 2420, 	// EY F3
 10, 	// EY F3 duration
 2522, 	// EY F3
 160, 	// EY F3 duration
 2522, 	// EY F3
 -1, 	// EY F3 duration
 2338, 	// EH F3
 90, 	// EH F3 duration
 2338, 	// EH F3
 140, 	// EH F3 duration
 2338, 	// EH F3
 -1, 	// EH F3 duration
 2430, 	// AE F3
 130, 	// AE F3 duration
 2470, 	// AE F3
 210, 	// AE F3 duration
 2470, 	// AE F3
 -1, 	// AE F3 duration
 2680, 	// AY F3
 120, 	// AY F3 duration
 2350, 	// AY F3
 170, 	// AY F3 duration
 2450, 	// AY F3
 210, 	// AY F3 duration
 2450, 	// AY F3
 -1, 	// AY F3 duration
 2650, 	// AW F3
 120, 	// AW F3 duration
 2550, 	// AW F3
 230, 	// AW F3 duration
 2550, 	// AW F3
 -1, 	// AW F3 duration
 2600, 	// AH F3
 40, 	// AH F3 duration
 2600, 	// AH F3
 100, 	// AH F3 duration
 2600, 	// AH F3
 -1, 	// AH F3 duration
 2640, 	// AO F3
 40, 	// AO F3 duration
 2640, 	// AO F3
 100, 	// AO F3 duration
 2640, 	// AO F3
 -1, 	// AO F3 duration
 2316, 	// OW F3
 30, 	// OW F3 duration
 2145, 	// OW F3
 150, 	// OW F3 duration
 2145, 	// OW F3
 -1, 	// OW F3 duration
 2500, 	// OY F3
 140, 	// OY F3 duration
 2250, 	// OY F3
 200, 	// OY F3 duration
 2400, 	// OY F3
 250, 	// OY F3 duration
 2400, 	// OY F3
 -1, 	// OY F3 duration
 2420, 	// UH F3
 70, 	// UH F3 duration
 2500, 	// UH F3
 130, 	// UH F3 duration
 2500, 	// UH F3
 -1, 	// UH F3 duration
 2300, 	// UW F3
 40, 	// UW F3 duration
 2300, 	// UW F3
 -1, 	// UW F3 duration
 1540, 	// RR F3
 30, 	// RR F3 duration
 1540, 	// RR F3
 170, 	// RR F3 duration
 1540, 	// RR F3
 -1, 	// RR F3 duration
 2600, 	// YU F3
 45, 	// YU F3 duration
 2250, 	// YU F3
 95, 	// YU F3 duration
 2200, 	// YU F3
 -1, 	// YU F3 duration
 2600, 	// AX F3
 30, 	// AX F3 duration
 2600, 	// AX F3
 90, 	// AX F3 duration
 2600, 	// AX F3
 -1, 	// AX F3 duration
 2520, 	// IX F3
 30, 	// IX F3 duration
 2520, 	// IX F3
 90, 	// IX F3 duration
 2520, 	// IX F3
 -1, 	// IX F3 duration
 2800, 	// IR F3
 70, 	// IR F3 duration
 1830, 	// IR F3
 160, 	// IR F3 duration
 1800, 	// IR F3
 -1, 	// IR F3 duration
 2200, 	// ER F3
 100, 	// ER F3 duration
 1790, 	// ER F3
 190, 	// ER F3 duration
 1750, 	// ER F3
 -1, 	// ER F3 duration
 2450, 	// AR F3
 90, 	// AR F3 duration
 1720, 	// AR F3
 180, 	// AR F3 duration
 1680, 	// AR F3
 -1, 	// AR F3 duration
 2300, 	// OR F3
 90, 	// OR F3 duration
 1530, 	// OR F3
 180, 	// OR F3 duration
 1500, 	// OR F3
 -1, 	// OR F3 duration
 2100, 	// UR F3
 80, 	// UR F3 duration
 1600, 	// UR F3
 180, 	// UR F3 duration
 1560, 	// UR F3
 -1, 	// UR F3 duration
// ====== Bandwidths and duration ======
 130, 	// AE B1
 130, 	// AE B1 duration
 120, 	// AE B1
 210, 	// AE B1 duration
 120, 	// AE B1
 -1, 	// AE B1 duration
 120, 	// AW B1
 130, 	// AW B1 duration
 100, 	// AW B1
 240, 	// AW B1 duration
 100, 	// AW B1
 -1, 	// AW B1 duration
 90, 	// AE B2
 130, 	// AE B2 duration
 90, 	// AE B2
 210, 	// AE B2 duration
 90, 	// AE B2
 -1, 	// AE B2 duration
 110, 	// OY B2
 100, 	// OY B2 duration
 100, 	// OY B2
 210, 	// OY B2 duration
 220, 	// OY B2
 -1, 	// OY B2 duration
 150, 	// YU B2
 45, 	// YU B2 duration
 70, 	// YU B2
 150, 	// YU B2 duration
 70, 	// YU B2
 -1, 	// YU B2 duration
 250, 	// YU B3
 45, 	// YU B3 duration
 130, 	// YU B3
 100, 	// YU B3 duration
 130, 	// YU B3
 -1, 	// YU B3 duration
// ====== Amplitude of Voicing ======
 0};

// Female diphthongs
const short us_femdip_sue[] = {
// ====== Formants Frequencies and duration ======
 0, 	// _ 
 0, 	// _ 
 375, 	// IY F1
 10, 	// IY F1 duration
 375, 	// IY F1
 -1, 	// IY F1 duration
 450, 	// IH F1
 60, 	// IH F1 duration
 450, 	// IH F1
 -1, 	// IH F1 duration
 610, 	// EY F1
 50, 	// EY F1 duration
 510, 	// EY F1
 150, 	// EY F1 duration
 390, 	// EY F1
 -1, 	// EY F1 duration
 780, 	// AE F1
 50, 	// AE F1 duration
 860, 	// AE F1
 190, 	// AE F1 duration
 860, 	// AE F1
 -1, 	// AE F1 duration
 810, 	// AA F1
 40, 	// AA F1 duration
 810, 	// AA F1
 200, 	// AA F1 duration
 810, 	// AA F1
 -1, 	// AA F1 duration
 800, 	// AY F1
 100, 	// AY F1 duration
 800, 	// AY F1
 220, 	// AY F1 duration
 709, 	// AY F1
 -1, 	// AY F1 duration
 800, 	// AW F1
 20, 	// AW F1 duration
 900, 	// AW F1
 70, 	// AW F1 duration
 600, 	// AW F1
 -1, 	// AW F1 duration
 700, 	// AH F1
 40, 	// AH F1 duration
 700, 	// AH F1
 120, 	// AH F1 duration
 700, 	// AH F1
 -1, 	// AH F1 duration
 730, 	// AO F1
 120, 	// AO F1 duration
 770, 	// AO F1
 220, 	// AO F1 duration
 770, 	// AO F1
 -1, 	// AO F1 duration
 610, 	// OW F1
 40, 	// OW F1 duration
 480, 	// OW F1
 170, 	// OW F1 duration
 470, 	// OW F1
 -1, 	// OW F1 duration
 590, 	// OY F1
 50, 	// OY F1 duration
 740, 	// OY F1
 145, 	// OY F1 duration
 540, 	// OY F1
 220, 	// OY F1 duration
 520, 	// OY F1
 -1, 	// OY F1 duration
 600, 	// UH F1
 50, 	// UH F1 duration
 700, 	// UH F1
 130, 	// UH F1 duration
 700, 	// UH F1
 -1, 	// UH F1 duration
 285, 	// UW F1
 40, 	// UW F1 duration
 285, 	// UW F1
 180, 	// UW F1 duration
 285, 	// UW F1
 -1, 	// UW F1 duration
 600, 	// RR F1
 30, 	// RR F1 duration
 550, 	// RR F1
 170, 	// RR F1 duration
 550, 	// RR F1
 -1, 	// RR F1 duration
 350, 	// YU F1
 70, 	// YU F1 duration
 410, 	// YU F1
 155, 	// YU F1 duration
 410, 	// YU F1
 -1, 	// YU F1 duration
 720, 	// AX F1
 30, 	// AX F1 duration
 750, 	// AX F1
 90, 	// AX F1 duration
 750, 	// AX F1
 -1, 	// AX F1 duration
 530, 	// IX F1
 30, 	// IX F1 duration
 530, 	// IX F1
 90, 	// IX F1 duration
 530, 	// IX F1
 -1, 	// IX F1 duration
 360, 	// IR F1
 100, 	// IR F1 duration
 540, 	// IR F1
 170, 	// IR F1 duration
 540, 	// IR F1
 -1, 	// IR F1 duration
 700, 	// ER F1
 40, 	// ER F1 duration
 630, 	// ER F1
 230, 	// ER F1 duration
 630, 	// ER F1
 -1, 	// ER F1 duration
 960, 	// AR F1
 100, 	// AR F1 duration
 700, 	// AR F1
 180, 	// AR F1 duration
 700, 	// AR F1
 -1, 	// AR F1 duration
 640, 	// OR F1
 90, 	// OR F1 duration
 600, 	// OR F1
 180, 	// OR F1 duration
 600, 	// OR F1
 -1, 	// OR F1 duration
 420, 	// UR F1
 80, 	// UR F1 duration
 520, 	// UR F1
 170, 	// UR F1 duration
 520, 	// UR F1
 -1, 	// UR F1 duration
 350, 	// HX F1
 10, 	// HX F1 duration
 340, 	// HX F1
 -1, 	// HX F1 duration
 800, 	// LY F1
 20, 	// LY F1 duration
 400, 	// LY F1
 70, 	// LY F1 duration
 400, 	// LY F1
 -1, 	// LY F1 duration
 360, 	// RE F1
 35, 	// RE F1 duration
 360, 	// RE F1
 68, 	// RE F1 duration
 570, 	// RE F1
 128, 	// RE F1 duration
 570, 	// RE F1
 -1, 	// RE F1 duration
 2699, 	// IY F2
 10, 	// IY F2 duration
 2750, 	// IY F2
 -1, 	// IY F2 duration
 2258, 	// IH F2
 60, 	// IH F2 duration
 2258, 	// IH F2
 -1, 	// IH F2 duration
 2156, 	// EY F2
 50, 	// EY F2 duration
 2421, 	// EY F2
 150, 	// EY F2 duration
 2900, 	// EY F2
 -1, 	// EY F2 duration
 2000, 	// AE F2
 110, 	// AE F2 duration
 1900, 	// AE F2
 190, 	// AE F2 duration
 1900, 	// AE F2
 -1, 	// AE F2 duration
 1350, 	// AA F2
 40, 	// AA F2 duration
 1350, 	// AA F2
 200, 	// AA F2 duration
 1350, 	// AA F2
 -1, 	// AA F2 duration
 1800, 	// AY F2
 40, 	// AY F2 duration
 1300, 	// AY F2
 110, 	// AY F2 duration
 2300, 	// AY F2
 200, 	// AY F2 duration
 2380, 	// AY F2
 -1, 	// AY F2 duration
 1500, 	// AW F2
 70, 	// AW F2 duration
 1060, 	// AW F2
 200, 	// AW F2 duration
 1040, 	// AW F2
 -1, 	// AW F2 duration
 1383, 	// AH F2
 40, 	// AH F2 duration
 1383, 	// AH F2
 120, 	// AH F2 duration
 1383, 	// AH F2
 -1, 	// AH F2 duration
 1160, 	// AO F2
 120, 	// AO F2 duration
 1260, 	// AO F2
 220, 	// AO F2 duration
 1260, 	// AO F2
 -1, 	// AO F2 duration
 1120, 	// OW F2
 40, 	// OW F2 duration
 780, 	// OW F2
 170, 	// OW F2 duration
 780, 	// OW F2
 -1, 	// OW F2 duration
 1090, 	// OY F2
 40, 	// OY F2 duration
 1090, 	// OY F2
 110, 	// OY F2 duration
 2220, 	// OY F2
 220, 	// OY F2 duration
 2270, 	// OY F2
 -1, 	// OY F2 duration
 1350, 	// UH F2
 50, 	// UH F2 duration
 1350, 	// UH F2
 130, 	// UH F2 duration
 1350, 	// UH F2
 -1, 	// UH F2 duration
 1312, 	// UW F2
 40, 	// UW F2 duration
 1312, 	// UW F2
 180, 	// UW F2 duration
 1312, 	// UW F2
 -1, 	// UW F2 duration
 1580, 	// RR F2
 30, 	// RR F2 duration
 1600, 	// RR F2
 170, 	// RR F2 duration
 1600, 	// RR F2
 -1, 	// RR F2 duration
 2550, 	// YU F2
 80, 	// YU F2 duration
 1520, 	// YU F2
 155, 	// YU F2 duration
 1400, 	// YU F2
 -1, 	// YU F2 duration
 1780, 	// AX F2
 30, 	// AX F2 duration
 1780, 	// AX F2
 90, 	// AX F2 duration
 1780, 	// AX F2
 -1, 	// AX F2 duration
 2470, 	// IX F2
 30, 	// IX F2 duration
 2440, 	// IX F2
 90, 	// IX F2 duration
 2440, 	// IX F2
 -1, 	// IX F2 duration
 2700, 	// IR F2
 100, 	// IR F2 duration
 1800, 	// IR F2
 170, 	// IR F2 duration
 1740, 	// IR F2
 -1, 	// IR F2 duration
 2450, 	// ER F2
 110, 	// ER F2 duration
 1720, 	// ER F2
 190, 	// ER F2 duration
 1700, 	// ER F2
 -1, 	// ER F2 duration
 1470, 	// AR F2
 100, 	// AR F2 duration
 1650, 	// AR F2
 180, 	// AR F2 duration
 1650, 	// AR F2
 -1, 	// AR F2 duration
 1250, 	// OR F2
 100, 	// OR F2 duration
 1600, 	// OR F2
 190, 	// OR F2 duration
 1600, 	// OR F2
 -1, 	// OR F2 duration
 1350, 	// UR F2
 80, 	// UR F2 duration
 1550, 	// UR F2
 170, 	// UR F2 duration
 1550, 	// UR F2
 -1, 	// UR F2 duration
 2000, 	// LY F2
 10, 	// LY F2 duration
 1200, 	// LY F2
 70, 	// LY F2 duration
 1200, 	// LY F2
 -1, 	// LY F2 duration
 1180, 	// RE F2
 35, 	// RE F2 duration
 1631, 	// RE F2
 68, 	// RE F2 duration
 2299, 	// RE F2
 128, 	// RE F2 duration
 2482, 	// RE F2
 -1, 	// RE F2 duration
 3156, 	// IY F3
 10, 	// IY F3 duration
 3168, 	// IY F3
 -1, 	// IY F3 duration
 3153, 	// IH F3
 60, 	// IH F3 duration
 3153, 	// IH F3
 -1, 	// IH F3 duration
 3000, 	// EY F3
 50, 	// EY F3 duration
 3112, 	// EY F3
 150, 	// EY F3 duration
 3300, 	// EY F3
 -1, 	// EY F3 duration
 2950, 	// AE F3
 110, 	// AE F3 duration
 3000, 	// AE F3
 190, 	// AE F3 duration
 3000, 	// AE F3
 -1, 	// AE F3 duration
 2950, 	// AA F3
 40, 	// AA F3 duration
 2950, 	// AA F3
 200, 	// AA F3 duration
 2950, 	// AA F3
 -1, 	// AA F3 duration
 2831, 	// AY F3
 120, 	// AY F3 duration
 2900, 	// AY F3
 160, 	// AY F3 duration
 3200, 	// AY F3
 200, 	// AY F3 duration
 3200, 	// AY F3
 -1, 	// AY F3 duration
 2696, 	// AW F3
 10, 	// AW F3 duration
 2817, 	// AW F3
 80, 	// AW F3 duration
 2886, 	// AW F3
 -1, 	// AW F3 duration
 2950, 	// AH F3
 40, 	// AH F3 duration
 2950, 	// AH F3
 100, 	// AH F3 duration
 2950, 	// AH F3
 -1, 	// AH F3 duration
 2920, 	// AO F3
 40, 	// AO F3 duration
 2920, 	// AO F3
 200, 	// AO F3 duration
 2920, 	// AO F3
 -1, 	// AO F3 duration
 2830, 	// OW F3
 40, 	// OW F3 duration
 2780, 	// OW F3
 170, 	// OW F3 duration
 2780, 	// OW F3
 -1, 	// OW F3 duration
 3030, 	// OY F3
 140, 	// OY F3 duration
 2800, 	// OY F3
 200, 	// OY F3 duration
 2970, 	// OY F3
 270, 	// OY F3 duration
 2970, 	// OY F3
 -1, 	// OY F3 duration
 3050, 	// UH F3
 50, 	// UH F3 duration
 3050, 	// UH F3
 130, 	// UH F3 duration
 3050, 	// UH F3
 -1, 	// UH F3 duration
 2800, 	// UW F3
 40, 	// UW F3 duration
 2700, 	// UW F3
 180, 	// UW F3 duration
 2700, 	// UW F3
 -1, 	// UW F3 duration
 2160, 	// RR F3
 30, 	// RR F3 duration
 2080, 	// RR F3
 170, 	// RR F3 duration
 2080, 	// RR F3
 -1, 	// RR F3 duration
 3100, 	// YU F3
 75, 	// YU F3 duration
 2800, 	// YU F3
 130, 	// YU F3 duration
 2800, 	// YU F3
 -1, 	// YU F3 duration
 3060, 	// AX F3
 30, 	// AX F3 duration
 3060, 	// AX F3
 90, 	// AX F3 duration
 3060, 	// AX F3
 -1, 	// AX F3 duration
 3200, 	// IX F3
 30, 	// IX F3 duration
 3200, 	// IX F3
 90, 	// IX F3 duration
 3200, 	// IX F3
 -1, 	// IX F3 duration
 3200, 	// IR F3
 70, 	// IR F3 duration
 2310, 	// IR F3
 170, 	// IR F3 duration
 2310, 	// IR F3
 -1, 	// IR F3 duration
 3020, 	// ER F3
 100, 	// ER F3 duration
 2250, 	// ER F3
 190, 	// ER F3 duration
 2250, 	// ER F3
 -1, 	// ER F3 duration
 2900, 	// AR F3
 90, 	// AR F3 duration
 2200, 	// AR F3
 180, 	// AR F3 duration
 2200, 	// AR F3
 -1, 	// AR F3 duration
 2720, 	// OR F3
 90, 	// OR F3 duration
 2150, 	// OR F3
 190, 	// OR F3 duration
 2150, 	// OR F3
 -1, 	// OR F3 duration
 2660, 	// UR F3
 70, 	// UR F3 duration
 2100, 	// UR F3
 180, 	// UR F3 duration
 2100, 	// UR F3
 -1, 	// UR F3 duration
 2700, 	// LY F3
 10, 	// LY F3 duration
 2900, 	// LY F3
 70, 	// LY F3 duration
 2900, 	// LY F3
 -1, 	// LY F3 duration
 2102, 	// RE F3
 35, 	// RE F3 duration
 2278, 	// RE F3
 68, 	// RE F3 duration
 3011, 	// RE F3
 128, 	// RE F3 duration
 3133, 	// RE F3
 -1, 	// RE F3 duration
// ====== Bandwidths and duration ======
 140, 	// AE B1
 50, 	// AE B1 duration
 170, 	// AE B1
 140, 	// AE B1 duration
 170, 	// AE B1
 -1, 	// AE B1 duration
 180, 	// AY B1
 120, 	// AY B1 duration
 150, 	// AY B1
 220, 	// AY B1 duration
 150, 	// AY B1
 -1, 	// AY B1 duration
 130, 	// AW B1
 30, 	// AW B1 duration
 150, 	// AW B1
 130, 	// AW B1 duration
 100, 	// AW B1
 -1, 	// AW B1 duration
 150, 	// AW B2
 10, 	// AW B2 duration
 120, 	// AW B2
 -1, 	// AW B2 duration
 100, 	// OY B2
 100, 	// OY B2 duration
 180, 	// OY B2
 220, 	// OY B2 duration
 180, 	// OY B2
 -1, 	// OY B2 duration
 150, 	// YU B2
 80, 	// YU B2 duration
 100, 	// YU B2
 150, 	// YU B2 duration
 100, 	// YU B2
 -1, 	// YU B2 duration
 160, 	// AW B3
 10, 	// AW B3 duration
 170, 	// AW B3
 -1, 	// AW B3 duration
 290, 	// YU B3
 70, 	// YU B3 duration
 150, 	// YU B3
 130, 	// YU B3 duration
 130, 	// YU B3
 -1, 	// YU B3 duration
// ====== Amplitude of Voicing ======
 0};

// Offsets into Amplitude data
const short us_ptram_sue[] = {
 0, 	// _ 
 0, 	// IY
 0, 	// IH
 0, 	// EY
 0, 	// EH
 0, 	// AE
 0, 	// AA
 0, 	// AY
 0, 	// AW
 0, 	// AH
 0, 	// AO
 0, 	// OW
 0, 	// OY
 0, 	// UH
 0, 	// UW
 0, 	// RR
 0, 	// YU
 0, 	// AX
 0, 	// IX
 0, 	// IR
 0, 	// ER
 0, 	// AR
 0, 	// OR
 0, 	// UR
 0, 	// W 
 0, 	// YX
 0, 	// R 
 0, 	// L 
 0, 	// HX
 0, 	// RX
 0, 	// LX
 0, 	// M 
 0, 	// N 
 0, 	// NX
 0, 	// EL
 1, 	// DZ
 0, 	// EN
 31, 	// F 
 61, 	// V 
 91, 	// TH
 121, 	// DH
 151, 	// S 
 181, 	// Z 
 211, 	// SH
 241, 	// ZH
 271, 	// P 
 301, 	// B 
 331, 	// T 
 361, 	// D 
 391, 	// K 
 421, 	// G 
 0, 	// DX
 451, 	// TX
 0, 	// Q 
 481, 	// CH
 511, 	// JH
 0, 	// DF
 541, 	// TZ
 571, 	// CZ
 0, 	// LY
 0, 	// RE
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
 0, 	// X6
 0, 	// X7
 0, 	// X8
 0, 	// X9
 0 };	// Z1

// Offsets into Locus data
const short us_plocu_sue[] = {
// ==== Front ====
 0, 	// _ 
 0, 	// IY
 0, 	// IH
 0, 	// EY
 0, 	// EH
 0, 	// AE
 0, 	// AA
 0, 	// AY
 0, 	// AW
 0, 	// AH
 0, 	// AO
 0, 	// OW
 0, 	// OY
 0, 	// UH
 0, 	// UW
 0, 	// RR
 0, 	// YU
 0, 	// AX
 0, 	// IX
 0, 	// IR
 0, 	// ER
 0, 	// AR
 0, 	// OR
 0, 	// UR
 0, 	// W 
 0, 	// YX
 0, 	// R 
 0, 	// L 
 0, 	// HX
 0, 	// RX
 0, 	// LX
 1, 	// M 
 10, 	// N 
 19, 	// NX
 0, 	// EL
 28, 	// DZ
 37, 	// EN
 46, 	// F 
 55, 	// V 
 64, 	// TH
 73, 	// DH
 82, 	// S 
 91, 	// Z 
 100, 	// SH
 109, 	// ZH
 118, 	// P 
 127, 	// B 
 136, 	// T 
 145, 	// D 
 154, 	// K 
 163, 	// G 
 172, 	// DX
 181, 	// TX
 0, 	// Q 
 190, 	// CH
 199, 	// JH
 208, 	// DF
 217, 	// TZ
 226, 	// CZ
 0, 	// LY
 0, 	// RE
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
 0, 	// X6
 0, 	// X7
 0, 	// X8
 0, 	// X9
 0, 	// Z1
// ==== Back ====
 0, 	// _ 
 0, 	// IY
 0, 	// IH
 0, 	// EY
 0, 	// EH
 0, 	// AE
 0, 	// AA
 0, 	// AY
 0, 	// AW
 0, 	// AH
 0, 	// AO
 0, 	// OW
 0, 	// OY
 0, 	// UH
 0, 	// UW
 0, 	// RR
 0, 	// YU
 0, 	// AX
 0, 	// IX
 0, 	// IR
 0, 	// ER
 0, 	// AR
 0, 	// OR
 0, 	// UR
 0, 	// W 
 0, 	// YX
 0, 	// R 
 0, 	// L 
 0, 	// HX
 0, 	// RX
 0, 	// LX
 235, 	// M 
 244, 	// N 
 253, 	// NX
 0, 	// EL
 262, 	// DZ
 271, 	// EN
 280, 	// F 
 289, 	// V 
 298, 	// TH
 307, 	// DH
 316, 	// S 
 325, 	// Z 
 334, 	// SH
 343, 	// ZH
 352, 	// P 
 361, 	// B 
 370, 	// T 
 379, 	// D 
 388, 	// K 
 397, 	// G 
 406, 	// DX
 415, 	// TX
 0, 	// Q 
 424, 	// CH
 433, 	// JH
 442, 	// DF
 451, 	// TZ
 460, 	// CZ
 0, 	// LY
 0, 	// RE
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
 0, 	// X6
 0, 	// X7
 0, 	// X8
 0, 	// X9
 0, 	// Z1
// ==== Round ====
 0, 	// _ 
 0, 	// IY
 0, 	// IH
 0, 	// EY
 0, 	// EH
 0, 	// AE
 0, 	// AA
 0, 	// AY
 0, 	// AW
 0, 	// AH
 0, 	// AO
 0, 	// OW
 0, 	// OY
 0, 	// UH
 0, 	// UW
 0, 	// RR
 0, 	// YU
 0, 	// AX
 0, 	// IX
 0, 	// IR
 0, 	// ER
 0, 	// AR
 0, 	// OR
 0, 	// UR
 0, 	// W 
 0, 	// YX
 0, 	// R 
 0, 	// L 
 0, 	// HX
 0, 	// RX
 0, 	// LX
 469, 	// M 
 478, 	// N 
 487, 	// NX
 0, 	// EL
 496, 	// DZ
 505, 	// EN
 514, 	// F 
 523, 	// V 
 532, 	// TH
 541, 	// DH
 550, 	// S 
 559, 	// Z 
 568, 	// SH
 577, 	// ZH
 586, 	// P 
 595, 	// B 
 604, 	// T 
 613, 	// D 
 622, 	// K 
 631, 	// G 
 640, 	// DX
 649, 	// TX
 0, 	// Q 
 658, 	// CH
 667, 	// JH
 676, 	// DF
 685, 	// TZ
 694, 	// CZ
 0, 	// LY
 0, 	// RE
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
 0, 	// X6
 0, 	// X7
 0, 	// X8
 0, 	// X9
 0, 	// Z1
// ==== Low ====
 0, 	// _ 
 0, 	// IY
 0, 	// IH
 0, 	// EY
 0, 	// EH
 0, 	// AE
 0, 	// AA
 0, 	// AY
 0, 	// AW
 0, 	// AH
 0, 	// AO
 0, 	// OW
 0, 	// OY
 0, 	// UH
 0, 	// UW
 0, 	// RR
 0, 	// YU
 0, 	// AX
 0, 	// IX
 0, 	// IR
 0, 	// ER
 0, 	// AR
 0, 	// OR
 0, 	// UR
 0, 	// W 
 0, 	// YX
 0, 	// R 
 0, 	// L 
 0, 	// HX
 0, 	// RX
 0, 	// LX
 703, 	// M 
 712, 	// N 
 721, 	// NX
 0, 	// EL
 730, 	// DZ
 739, 	// EN
 748, 	// F 
 757, 	// V 
 766, 	// TH
 775, 	// DH
 784, 	// S 
 793, 	// Z 
 802, 	// SH
 811, 	// ZH
 820, 	// P 
 829, 	// B 
 838, 	// T 
 847, 	// D 
 856, 	// K 
 865, 	// G 
 0, 	// DX
 874, 	// TX
 0, 	// Q 
 883, 	// CH
 892, 	// JH
 0, 	// DF
 0, 	// TZ
 901, 	// CZ
 0, 	// LY
 0, 	// RE
 0, 	// X1
 0, 	// X2
 0, 	// X3
 0, 	// X4
 0, 	// X5
 0, 	// X6
 0, 	// X7
 0, 	// X8
 0, 	// X9
 0 };	// Z1

// Male Locus data
const short us_maleloc_sue[] = {
 0, 
// Front
 280, 	// M  F1 locus
 30, 	// M  percent
 30, 	// M  transition duration
 1200, 	// M  F2 locus
 10, 	// M  percent
 25, 	// M  transition duration
 2000, 	// M  F3 locus
 30, 	// M  percent
 40, 	// M  transition duration
 450, 	// N  F1 locus
 20, 	// N  percent
 35, 	// N  transition duration
 1350, 	// N  F2 locus
 75, 	// N  percent
 35, 	// N  transition duration
 2600, 	// N  F3 locus
 40, 	// N  percent
 45, 	// N  transition duration
 280, 	// NX F1 locus
 25, 	// NX percent
 40, 	// NX transition duration
 2100, 	// NX F2 locus
 15, 	// NX percent
 60, 	// NX transition duration
 3000, 	// NX F3 locus
 105, 	// NX percent
 60, 	// NX transition duration
 340, 	// DZ F1 locus
 10, 	// DZ percent
 45, 	// DZ transition duration
 1350, 	// DZ F2 locus
 20, 	// DZ percent
 50, 	// DZ transition duration
 2700, 	// DZ F3 locus
 0, 	// DZ percent
 50, 	// DZ transition duration
 280, 	// EN F1 locus
 20, 	// EN percent
 35, 	// EN transition duration
 1550, 	// EN F2 locus
 75, 	// EN percent
 35, 	// EN transition duration
 2400, 	// EN F3 locus
 40, 	// EN percent
 45, 	// EN transition duration
 300, 	// F  F1 locus
 63, 	// F  percent
 30, 	// F  transition duration
 1, 	// F  F2 locus
 92, 	// F  percent
 35, 	// F  transition duration
 2080, 	// F  F3 locus
 35, 	// F  percent
 30, 	// F  transition duration
 300, 	// V  F1 locus
 50, 	// V  percent
 30, 	// V  transition duration
 1, 	// V  F2 locus
 92, 	// V  percent
 35, 	// V  transition duration
 2080, 	// V  F3 locus
 35, 	// V  percent
 40, 	// V  transition duration
 340, 	// TH F1 locus
 10, 	// TH percent
 45, 	// TH transition duration
 1500, 	// TH F2 locus
 20, 	// TH percent
 35, 	// TH transition duration
 2420, 	// TH F3 locus
 0, 	// TH percent
 50, 	// TH transition duration
 400, 	// DH F1 locus
 10, 	// DH percent
 45, 	// DH transition duration
 1500, 	// DH F2 locus
 20, 	// DH percent
 35, 	// DH transition duration
 2700, 	// DH F3 locus
 0, 	// DH percent
 50, 	// DH transition duration
 310, 	// S  F1 locus
 40, 	// S  percent
 40, 	// S  transition duration
 1440, 	// S  F2 locus
 40, 	// S  percent
 50, 	// S  transition duration
 2550, 	// S  F3 locus
 0, 	// S  percent
 70, 	// S  transition duration
 310, 	// Z  F1 locus
 40, 	// Z  percent
 40, 	// Z  transition duration
 1440, 	// Z  F2 locus
 35, 	// Z  percent
 50, 	// Z  transition duration
 2550, 	// Z  F3 locus
 0, 	// Z  percent
 70, 	// Z  transition duration
 285, 	// SH F1 locus
 32, 	// SH percent
 55, 	// SH transition duration
 1630, 	// SH F2 locus
 30, 	// SH percent
 70, 	// SH transition duration
 2640, 	// SH F3 locus
 51, 	// SH percent
 70, 	// SH transition duration
 285, 	// ZH F1 locus
 32, 	// ZH percent
 55, 	// ZH transition duration
 1830, 	// ZH F2 locus
 30, 	// ZH percent
 70, 	// ZH transition duration
 2640, 	// ZH F3 locus
 51, 	// ZH percent
 70, 	// ZH transition duration
 350, 	// P  F1 locus
 55, 	// P  percent
 20, 	// P  transition duration
 950, 	// P  F2 locus
 56, 	// P  percent
 50, 	// P  transition duration
 2200, 	// P  F3 locus
 25, 	// P  percent
 50, 	// P  transition duration
 330, 	// B  F1 locus
 55, 	// B  percent
 20, 	// B  transition duration
 900, 	// B  F2 locus
 56, 	// B  percent
 30, 	// B  transition duration
 2200, 	// B  F3 locus
 25, 	// B  percent
 45, 	// B  transition duration
 320, 	// T  F1 locus
 43, 	// T  percent
 35, 	// T  transition duration
 1800, 	// T  F2 locus
 66, 	// T  percent
 35, 	// T  transition duration
 2650, 	// T  F3 locus
 30, 	// T  percent
 45, 	// T  transition duration
 250, 	// D  F1 locus
 43, 	// D  percent
 35, 	// D  transition duration
 1800, 	// D  F2 locus
 66, 	// D  percent
 35, 	// D  transition duration
 2650, 	// D  F3 locus
 30, 	// D  percent
 45, 	// D  transition duration
 280, 	// K  F1 locus
 33, 	// K  percent
 45, 	// K  transition duration
 1980, 	// K  F2 locus
 20, 	// K  percent
 55, 	// K  transition duration
 3000, 	// K  F3 locus
 117, 	// K  percent
 50, 	// K  transition duration
 250, 	// G  F1 locus
 33, 	// G  percent
 45, 	// G  transition duration
 2100, 	// G  F2 locus
 20, 	// G  percent
 50, 	// G  transition duration
 2100, 	// G  F3 locus
 50, 	// G  percent
 45, 	// G  transition duration
 350, 	// DX F1 locus
 50, 	// DX percent
 30, 	// DX transition duration
 1800, 	// DX F2 locus
 50, 	// DX percent
 30, 	// DX transition duration
 2400, 	// DX F3 locus
 50, 	// DX percent
 30, 	// DX transition duration
 320, 	// TX F1 locus
 43, 	// TX percent
 35, 	// TX transition duration
 1800, 	// TX F2 locus
 66, 	// TX percent
 35, 	// TX transition duration
 2650, 	// TX F3 locus
 30, 	// TX percent
 45, 	// TX transition duration
 320, 	// CH F1 locus
 54, 	// CH percent
 55, 	// CH transition duration
 1750, 	// CH F2 locus
 25, 	// CH percent
 70, 	// CH transition duration
 2750, 	// CH F3 locus
 19, 	// CH percent
 70, 	// CH transition duration
 240, 	// JH F1 locus
 32, 	// JH percent
 55, 	// JH transition duration
 1750, 	// JH F2 locus
 25, 	// JH percent
 70, 	// JH transition duration
 2750, 	// JH F3 locus
 19, 	// JH percent
 70, 	// JH transition duration
 320, 	// DF F1 locus
 50, 	// DF percent
 30, 	// DF transition duration
 1800, 	// DF F2 locus
 50, 	// DF percent
 30, 	// DF transition duration
 2500, 	// DF F3 locus
 50, 	// DF percent
 30, 	// DF transition duration
 501, 	// TZ F1 locus
 50, 	// TZ percent
 70, 	// TZ transition duration
 1500, 	// TZ F2 locus
 20, 	// TZ percent
 150, 	// TZ transition duration
 2600, 	// TZ F3 locus
 50, 	// TZ percent
 50, 	// TZ transition duration
 300, 	// CZ F1 locus
 70, 	// CZ percent
 20, 	// CZ transition duration
 1610, 	// CZ F2 locus
 70, 	// CZ percent
 30, 	// CZ transition duration
 2160, 	// CZ F3 locus
 50, 	// CZ percent
 60, 	// CZ transition duration
// Back
 450, 	// M  F1 locus
 20, 	// M  percent
 30, 	// M  transition duration
 1, 	// M  F2 locus
 88, 	// M  percent
 40, 	// M  transition duration
 2000, 	// M  F3 locus
 80, 	// M  percent
 25, 	// M  transition duration
 450, 	// N  F1 locus
 20, 	// N  percent
 30, 	// N  transition duration
 1420, 	// N  F2 locus
 25, 	// N  percent
 75, 	// N  transition duration
 2600, 	// N  F3 locus
 0, 	// N  percent
 60, 	// N  transition duration
 280, 	// NX F1 locus
 25, 	// NX percent
 40, 	// NX transition duration
 1800, 	// NX F2 locus
 20, 	// NX percent
 70, 	// NX transition duration
 2150, 	// NX F3 locus
 20, 	// NX percent
 70, 	// NX transition duration
 350, 	// DZ F1 locus
 10, 	// DZ percent
 50, 	// DZ transition duration
 1300, 	// DZ F2 locus
 12, 	// DZ percent
 55, 	// DZ transition duration
 2720, 	// DZ F3 locus
 11, 	// DZ percent
 55, 	// DZ transition duration
 280, 	// EN F1 locus
 20, 	// EN percent
 30, 	// EN transition duration
 1420, 	// EN F2 locus
 25, 	// EN percent
 75, 	// EN transition duration
 2400, 	// EN F3 locus
 30, 	// EN percent
 60, 	// EN transition duration
 320, 	// F  F1 locus
 60, 	// F  percent
 30, 	// F  transition duration
 1, 	// F  F2 locus
 91, 	// F  percent
 35, 	// F  transition duration
 2100, 	// F  F3 locus
 65, 	// F  percent
 40, 	// F  transition duration
 300, 	// V  F1 locus
 50, 	// V  percent
 30, 	// V  transition duration
 1, 	// V  F2 locus
 91, 	// V  percent
 40, 	// V  transition duration
 2100, 	// V  F3 locus
 65, 	// V  percent
 40, 	// V  transition duration
 350, 	// TH F1 locus
 10, 	// TH percent
 50, 	// TH transition duration
 1300, 	// TH F2 locus
 12, 	// TH percent
 55, 	// TH transition duration
 2500, 	// TH F3 locus
 11, 	// TH percent
 55, 	// TH transition duration
 350, 	// DH F1 locus
 10, 	// DH percent
 50, 	// DH transition duration
 1400, 	// DH F2 locus
 12, 	// DH percent
 55, 	// DH transition duration
 2720, 	// DH F3 locus
 11, 	// DH percent
 55, 	// DH transition duration
 310, 	// S  F1 locus
 40, 	// S  percent
 40, 	// S  transition duration
 1440, 	// S  F2 locus
 40, 	// S  percent
 50, 	// S  transition duration
 2530, 	// S  F3 locus
 0, 	// S  percent
 70, 	// S  transition duration
 310, 	// Z  F1 locus
 40, 	// Z  percent
 40, 	// Z  transition duration
 1440, 	// Z  F2 locus
 35, 	// Z  percent
 60, 	// Z  transition duration
 2630, 	// Z  F3 locus
 0, 	// Z  percent
 70, 	// Z  transition duration
 285, 	// SH F1 locus
 32, 	// SH percent
 55, 	// SH transition duration
 1600, 	// SH F2 locus
 27, 	// SH percent
 70, 	// SH transition duration
 2270, 	// SH F3 locus
 0, 	// SH percent
 85, 	// SH transition duration
 285, 	// ZH F1 locus
 32, 	// ZH percent
 55, 	// ZH transition duration
 1800, 	// ZH F2 locus
 27, 	// ZH percent
 70, 	// ZH transition duration
 2270, 	// ZH F3 locus
 0, 	// ZH percent
 85, 	// ZH transition duration
 350, 	// P  F1 locus
 45, 	// P  percent
 25, 	// P  transition duration
 920, 	// P  F2 locus
 46, 	// P  percent
 50, 	// P  transition duration
 1900, 	// P  F3 locus
 40, 	// P  percent
 50, 	// P  transition duration
 330, 	// B  F1 locus
 45, 	// B  percent
 25, 	// B  transition duration
 920, 	// B  F2 locus
 46, 	// B  percent
 30, 	// B  transition duration
 2250, 	// B  F3 locus
 40, 	// B  percent
 50, 	// B  transition duration
 320, 	// T  F1 locus
 43, 	// T  percent
 50, 	// T  transition duration
 1700, 	// T  F2 locus
 40, 	// T  percent
 75, 	// T  transition duration
 2600, 	// T  F3 locus
 10, 	// T  percent
 50, 	// T  transition duration
 250, 	// D  F1 locus
 43, 	// D  percent
 50, 	// D  transition duration
 1700, 	// D  F2 locus
 40, 	// D  percent
 75, 	// D  transition duration
 2600, 	// D  F3 locus
 0, 	// D  percent
 50, 	// D  transition duration
 280, 	// K  F1 locus
 33, 	// K  percent
 50, 	// K  transition duration
 1800, 	// K  F2 locus
 16, 	// K  percent
 50, 	// K  transition duration
 2000, 	// K  F3 locus
 20, 	// K  percent
 90, 	// K  transition duration
 250, 	// G  F1 locus
 33, 	// G  percent
 50, 	// G  transition duration
 1800, 	// G  F2 locus
 16, 	// G  percent
 60, 	// G  transition duration
 2100, 	// G  F3 locus
 0, 	// G  percent
 90, 	// G  transition duration
 350, 	// DX F1 locus
 50, 	// DX percent
 40, 	// DX transition duration
 1800, 	// DX F2 locus
 30, 	// DX percent
 30, 	// DX transition duration
 2200, 	// DX F3 locus
 40, 	// DX percent
 30, 	// DX transition duration
 320, 	// TX F1 locus
 43, 	// TX percent
 50, 	// TX transition duration
 1700, 	// TX F2 locus
 40, 	// TX percent
 75, 	// TX transition duration
 2600, 	// TX F3 locus
 0, 	// TX percent
 50, 	// TX transition duration
 320, 	// CH F1 locus
 54, 	// CH percent
 55, 	// CH transition duration
 1680, 	// CH F2 locus
 10, 	// CH percent
 40, 	// CH transition duration
 2450, 	// CH F3 locus
 10, 	// CH percent
 70, 	// CH transition duration
 245, 	// JH F1 locus
 32, 	// JH percent
 55, 	// JH transition duration
 1680, 	// JH F2 locus
 5, 	// JH percent
 120, 	// JH transition duration
 2450, 	// JH F3 locus
 10, 	// JH percent
 70, 	// JH transition duration
 300, 	// DF F1 locus
 50, 	// DF percent
 30, 	// DF transition duration
 1800, 	// DF F2 locus
 50, 	// DF percent
 40, 	// DF transition duration
 1800, 	// DF F3 locus
 50, 	// DF percent
 30, 	// DF transition duration
 290, 	// TZ F1 locus
 70, 	// TZ percent
 35, 	// TZ transition duration
 1500, 	// TZ F2 locus
 20, 	// TZ percent
 80, 	// TZ transition duration
 2600, 	// TZ F3 locus
 50, 	// TZ percent
 30, 	// TZ transition duration
 300, 	// CZ F1 locus
 70, 	// CZ percent
 30, 	// CZ transition duration
 1711, 	// CZ F2 locus
 70, 	// CZ percent
 30, 	// CZ transition duration
 2150, 	// CZ F3 locus
 50, 	// CZ percent
 60, 	// CZ transition duration
// Round
 450, 	// M  F1 locus
 20, 	// M  percent
 30, 	// M  transition duration
 970, 	// M  F2 locus
 10, 	// M  percent
 40, 	// M  transition duration
 1550, 	// M  F3 locus
 80, 	// M  percent
 25, 	// M  transition duration
 450, 	// N  F1 locus
 20, 	// N  percent
 30, 	// N  transition duration
 1300, 	// N  F2 locus
 70, 	// N  percent
 35, 	// N  transition duration
 2420, 	// N  F3 locus
 0, 	// N  percent
 95, 	// N  transition duration
 280, 	// NX F1 locus
 25, 	// NX percent
 40, 	// NX transition duration
 1700, 	// NX F2 locus
 42, 	// NX percent
 70, 	// NX transition duration
 1920, 	// NX F3 locus
 25, 	// NX percent
 70, 	// NX transition duration
 350, 	// DZ F1 locus
 10, 	// DZ percent
 50, 	// DZ transition duration
 1300, 	// DZ F2 locus
 12, 	// DZ percent
 55, 	// DZ transition duration
 2720, 	// DZ F3 locus
 11, 	// DZ percent
 55, 	// DZ transition duration
 280, 	// EN F1 locus
 20, 	// EN percent
 30, 	// EN transition duration
 1550, 	// EN F2 locus
 25, 	// EN percent
 95, 	// EN transition duration
 2420, 	// EN F3 locus
 30, 	// EN percent
 95, 	// EN transition duration
 320, 	// F  F1 locus
 60, 	// F  percent
 30, 	// F  transition duration
 1, 	// F  F2 locus
 91, 	// F  percent
 35, 	// F  transition duration
 2100, 	// F  F3 locus
 65, 	// F  percent
 40, 	// F  transition duration
 325, 	// V  F1 locus
 50, 	// V  percent
 30, 	// V  transition duration
 1, 	// V  F2 locus
 91, 	// V  percent
 40, 	// V  transition duration
 2100, 	// V  F3 locus
 65, 	// V  percent
 40, 	// V  transition duration
 350, 	// TH F1 locus
 10, 	// TH percent
 50, 	// TH transition duration
 1300, 	// TH F2 locus
 12, 	// TH percent
 55, 	// TH transition duration
 2500, 	// TH F3 locus
 11, 	// TH percent
 55, 	// TH transition duration
 400, 	// DH F1 locus
 10, 	// DH percent
 50, 	// DH transition duration
 1300, 	// DH F2 locus
 12, 	// DH percent
 55, 	// DH transition duration
 2720, 	// DH F3 locus
 11, 	// DH percent
 55, 	// DH transition duration
 310, 	// S  F1 locus
 40, 	// S  percent
 40, 	// S  transition duration
 1320, 	// S  F2 locus
 15, 	// S  percent
 60, 	// S  transition duration
 2460, 	// S  F3 locus
 0, 	// S  percent
 65, 	// S  transition duration
 310, 	// Z  F1 locus
 40, 	// Z  percent
 40, 	// Z  transition duration
 1520, 	// Z  F2 locus
 15, 	// Z  percent
 60, 	// Z  transition duration
 2460, 	// Z  F3 locus
 0, 	// Z  percent
 65, 	// Z  transition duration
 340, 	// SH F1 locus
 32, 	// SH percent
 55, 	// SH transition duration
 1630, 	// SH F2 locus
 27, 	// SH percent
 90, 	// SH transition duration
 2100, 	// SH F3 locus
 20, 	// SH percent
 110, 	// SH transition duration
 340, 	// ZH F1 locus
 32, 	// ZH percent
 55, 	// ZH transition duration
 1830, 	// ZH F2 locus
 27, 	// ZH percent
 90, 	// ZH transition duration
 2100, 	// ZH F3 locus
 20, 	// ZH percent
 110, 	// ZH transition duration
 320, 	// P  F1 locus
 45, 	// P  percent
 25, 	// P  transition duration
 920, 	// P  F2 locus
 46, 	// P  percent
 50, 	// P  transition duration
 1900, 	// P  F3 locus
 40, 	// P  percent
 50, 	// P  transition duration
 330, 	// B  F1 locus
 45, 	// B  percent
 25, 	// B  transition duration
 720, 	// B  F2 locus
 36, 	// B  percent
 50, 	// B  transition duration
 1800, 	// B  F3 locus
 40, 	// B  percent
 40, 	// B  transition duration
 320, 	// T  F1 locus
 43, 	// T  percent
 40, 	// T  transition duration
 1700, 	// T  F2 locus
 40, 	// T  percent
 95, 	// T  transition duration
 2300, 	// T  F3 locus
 0, 	// T  percent
 95, 	// T  transition duration
 250, 	// D  F1 locus
 43, 	// D  percent
 40, 	// D  transition duration
 1700, 	// D  F2 locus
 40, 	// D  percent
 95, 	// D  transition duration
 2601, 	// D  F3 locus
 30, 	// D  percent
 85, 	// D  transition duration
 280, 	// K  F1 locus
 33, 	// K  percent
 40, 	// K  transition duration
 1400, 	// K  F2 locus
 60, 	// K  percent
 75, 	// K  transition duration
 2050, 	// K  F3 locus
 15, 	// K  percent
 80, 	// K  transition duration
 250, 	// G  F1 locus
 45, 	// G  percent
 40, 	// G  transition duration
 1600, 	// G  F2 locus
 42, 	// G  percent
 65, 	// G  transition duration
 1920, 	// G  F3 locus
 15, 	// G  percent
 80, 	// G  transition duration
 350, 	// DX F1 locus
 50, 	// DX percent
 40, 	// DX transition duration
 1800, 	// DX F2 locus
 30, 	// DX percent
 30, 	// DX transition duration
 2200, 	// DX F3 locus
 40, 	// DX percent
 30, 	// DX transition duration
 320, 	// TX F1 locus
 43, 	// TX percent
 40, 	// TX transition duration
 1700, 	// TX F2 locus
 40, 	// TX percent
 95, 	// TX transition duration
 2300, 	// TX F3 locus
 0, 	// TX percent
 95, 	// TX transition duration
 320, 	// CH F1 locus
 54, 	// CH percent
 55, 	// CH transition duration
 1580, 	// CH F2 locus
 20, 	// CH percent
 40, 	// CH transition duration
 2350, 	// CH F3 locus
 10, 	// CH percent
 100, 	// CH transition duration
 245, 	// JH F1 locus
 32, 	// JH percent
 55, 	// JH transition duration
 1680, 	// JH F2 locus
 10, 	// JH percent
 90, 	// JH transition duration
 1970, 	// JH F3 locus
 10, 	// JH percent
 100, 	// JH transition duration
 300, 	// DF F1 locus
 50, 	// DF percent
 30, 	// DF transition duration
 1800, 	// DF F2 locus
 50, 	// DF percent
 40, 	// DF transition duration
 1800, 	// DF F3 locus
 50, 	// DF percent
 30, 	// DF transition duration
 501, 	// TZ F1 locus
 50, 	// TZ percent
 40, 	// TZ transition duration
 1600, 	// TZ F2 locus
 20, 	// TZ percent
 90, 	// TZ transition duration
 2600, 	// TZ F3 locus
 50, 	// TZ percent
 40, 	// TZ transition duration
 300, 	// CZ F1 locus
 70, 	// CZ percent
 30, 	// CZ transition duration
 1610, 	// CZ F2 locus
 70, 	// CZ percent
 36, 	// CZ transition duration
 2160, 	// CZ F3 locus
 50, 	// CZ percent
 60, 	// CZ transition duration
// Low
 0, 	// M  F1 locus
 0, 	// M  percent
 0, 	// M  transition duration
 0, 	// M  F2 locus
 0, 	// M  percent
 0, 	// M  transition duration
 0, 	// M  F3 locus
 0, 	// M  percent
 0, 	// M  transition duration
 0, 	// N  F1 locus
 0, 	// N  percent
 0, 	// N  transition duration
 0, 	// N  F2 locus
 0, 	// N  percent
 0, 	// N  transition duration
 0, 	// N  F3 locus
 0, 	// N  percent
 0, 	// N  transition duration
 0, 	// NX F1 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// NX F2 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// NX F3 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// DZ F1 locus
 0, 	// DZ percent
 0, 	// DZ transition duration
 0, 	// DZ F2 locus
 0, 	// DZ percent
 0, 	// DZ transition duration
 0, 	// DZ F3 locus
 0, 	// DZ percent
 0, 	// DZ transition duration
 0, 	// EN F1 locus
 0, 	// EN percent
 0, 	// EN transition duration
 0, 	// EN F2 locus
 0, 	// EN percent
 0, 	// EN transition duration
 0, 	// EN F3 locus
 0, 	// EN percent
 0, 	// EN transition duration
 0, 	// F  F1 locus
 0, 	// F  percent
 0, 	// F  transition duration
 0, 	// F  F2 locus
 0, 	// F  percent
 0, 	// F  transition duration
 0, 	// F  F3 locus
 0, 	// F  percent
 0, 	// F  transition duration
 0, 	// V  F1 locus
 0, 	// V  percent
 0, 	// V  transition duration
 0, 	// V  F2 locus
 0, 	// V  percent
 0, 	// V  transition duration
 0, 	// V  F3 locus
 0, 	// V  percent
 0, 	// V  transition duration
 0, 	// TH F1 locus
 0, 	// TH percent
 0, 	// TH transition duration
 0, 	// TH F2 locus
 0, 	// TH percent
 0, 	// TH transition duration
 0, 	// TH F3 locus
 0, 	// TH percent
 0, 	// TH transition duration
 0, 	// DH F1 locus
 0, 	// DH percent
 0, 	// DH transition duration
 0, 	// DH F2 locus
 0, 	// DH percent
 0, 	// DH transition duration
 0, 	// DH F3 locus
 0, 	// DH percent
 0, 	// DH transition duration
 0, 	// S  F1 locus
 0, 	// S  percent
 0, 	// S  transition duration
 0, 	// S  F2 locus
 0, 	// S  percent
 0, 	// S  transition duration
 0, 	// S  F3 locus
 0, 	// S  percent
 0, 	// S  transition duration
 0, 	// Z  F1 locus
 0, 	// Z  percent
 0, 	// Z  transition duration
 0, 	// Z  F2 locus
 0, 	// Z  percent
 0, 	// Z  transition duration
 0, 	// Z  F3 locus
 0, 	// Z  percent
 0, 	// Z  transition duration
 0, 	// SH F1 locus
 0, 	// SH percent
 0, 	// SH transition duration
 0, 	// SH F2 locus
 0, 	// SH percent
 0, 	// SH transition duration
 0, 	// SH F3 locus
 0, 	// SH percent
 0, 	// SH transition duration
 0, 	// ZH F1 locus
 0, 	// ZH percent
 0, 	// ZH transition duration
 0, 	// ZH F2 locus
 0, 	// ZH percent
 0, 	// ZH transition duration
 0, 	// ZH F3 locus
 0, 	// ZH percent
 0, 	// ZH transition duration
 0, 	// P  F1 locus
 0, 	// P  percent
 0, 	// P  transition duration
 0, 	// P  F2 locus
 0, 	// P  percent
 0, 	// P  transition duration
 0, 	// P  F3 locus
 0, 	// P  percent
 0, 	// P  transition duration
 0, 	// B  F1 locus
 0, 	// B  percent
 0, 	// B  transition duration
 0, 	// B  F2 locus
 0, 	// B  percent
 0, 	// B  transition duration
 0, 	// B  F3 locus
 0, 	// B  percent
 0, 	// B  transition duration
 0, 	// T  F1 locus
 0, 	// T  percent
 0, 	// T  transition duration
 0, 	// T  F2 locus
 0, 	// T  percent
 0, 	// T  transition duration
 0, 	// T  F3 locus
 0, 	// T  percent
 0, 	// T  transition duration
 0, 	// D  F1 locus
 0, 	// D  percent
 0, 	// D  transition duration
 0, 	// D  F2 locus
 0, 	// D  percent
 0, 	// D  transition duration
 0, 	// D  F3 locus
 0, 	// D  percent
 0, 	// D  transition duration
 0, 	// K  F1 locus
 0, 	// K  percent
 0, 	// K  transition duration
 0, 	// K  F2 locus
 0, 	// K  percent
 0, 	// K  transition duration
 0, 	// K  F3 locus
 0, 	// K  percent
 0, 	// K  transition duration
 0, 	// G  F1 locus
 0, 	// G  percent
 0, 	// G  transition duration
 0, 	// G  F2 locus
 0, 	// G  percent
 0, 	// G  transition duration
 0, 	// G  F3 locus
 0, 	// G  percent
 0, 	// G  transition duration
 0, 	// TX F1 locus
 0, 	// TX percent
 0, 	// TX transition duration
 0, 	// TX F2 locus
 0, 	// TX percent
 0, 	// TX transition duration
 0, 	// TX F3 locus
 0, 	// TX percent
 0, 	// TX transition duration
 0, 	// CH F1 locus
 0, 	// CH percent
 0, 	// CH transition duration
 0, 	// CH F2 locus
 0, 	// CH percent
 0, 	// CH transition duration
 0, 	// CH F3 locus
 0, 	// CH percent
 0, 	// CH transition duration
 0, 	// JH F1 locus
 0, 	// JH percent
 0, 	// JH transition duration
 0, 	// JH F2 locus
 0, 	// JH percent
 0, 	// JH transition duration
 0, 	// JH F3 locus
 0, 	// JH percent
 0, 	// JH transition duration
 -1, 	// CZ F1 locus
 -1, 	// CZ percent
 -1, 	// CZ transition duration
 -1, 	// CZ F2 locus
 -1, 	// CZ percent
 -1, 	// CZ transition duration
 -1, 	// CZ F3 locus
 -1, 	// CZ percent
 -1, 	// CZ transition duration
 0};

// Female Locus
const short us_femloc_sue[] = {
 0, 
// Front
 300, 	// M  F1 locus
 30, 	// M  percent
 30, 	// M  transition duration
 1380, 	// M  F2 locus
 10, 	// M  percent
 35, 	// M  transition duration
 2400, 	// M  F3 locus
 30, 	// M  percent
 20, 	// M  transition duration
 300, 	// N  F1 locus
 24, 	// N  percent
 35, 	// N  transition duration
 1400, 	// N  F2 locus
 75, 	// N  percent
 35, 	// N  transition duration
 2500, 	// N  F3 locus
 35, 	// N  percent
 45, 	// N  transition duration
 180, 	// NX F1 locus
 20, 	// NX percent
 40, 	// NX transition duration
 2760, 	// NX F2 locus
 10, 	// NX percent
 70, 	// NX transition duration
 1900, 	// NX F3 locus
 114, 	// NX percent
 60, 	// NX transition duration
 340, 	// DZ F1 locus
 30, 	// DZ percent
 45, 	// DZ transition duration
 1300, 	// DZ F2 locus
 35, 	// DZ percent
 60, 	// DZ transition duration
 3180, 	// DZ F3 locus
 35, 	// DZ percent
 60, 	// DZ transition duration
 450, 	// EN F1 locus
 24, 	// EN percent
 35, 	// EN transition duration
 2300, 	// EN F2 locus
 75, 	// EN percent
 35, 	// EN transition duration
 3200, 	// EN F3 locus
 35, 	// EN percent
 45, 	// EN transition duration
 350, 	// F  F1 locus
 65, 	// F  percent
 30, 	// F  transition duration
 1, 	// F  F2 locus
 87, 	// F  percent
 40, 	// F  transition duration
 2600, 	// F  F3 locus
 35, 	// F  percent
 30, 	// F  transition duration
 330, 	// V  F1 locus
 65, 	// V  percent
 30, 	// V  transition duration
 1, 	// V  F2 locus
 85, 	// V  percent
 40, 	// V  transition duration
 2600, 	// V  F3 locus
 35, 	// V  percent
 40, 	// V  transition duration
 360, 	// TH F1 locus
 30, 	// TH percent
 45, 	// TH transition duration
 1300, 	// TH F2 locus
 40, 	// TH percent
 70, 	// TH transition duration
 3180, 	// TH F3 locus
 35, 	// TH percent
 70, 	// TH transition duration
 340, 	// DH F1 locus
 30, 	// DH percent
 45, 	// DH transition duration
 1300, 	// DH F2 locus
 35, 	// DH percent
 60, 	// DH transition duration
 3180, 	// DH F3 locus
 35, 	// DH percent
 60, 	// DH transition duration
 380, 	// S  F1 locus
 40, 	// S  percent
 40, 	// S  transition duration
 1700, 	// S  F2 locus
 30, 	// S  percent
 50, 	// S  transition duration
 3100, 	// S  F3 locus
 0, 	// S  percent
 70, 	// S  transition duration
 320, 	// Z  F1 locus
 40, 	// Z  percent
 40, 	// Z  transition duration
 2000, 	// Z  F2 locus
 30, 	// Z  percent
 50, 	// Z  transition duration
 2980, 	// Z  F3 locus
 0, 	// Z  percent
 70, 	// Z  transition duration
 360, 	// SH F1 locus
 32, 	// SH percent
 55, 	// SH transition duration
 2000, 	// SH F2 locus
 30, 	// SH percent
 70, 	// SH transition duration
 2940, 	// SH F3 locus
 51, 	// SH percent
 70, 	// SH transition duration
 320, 	// ZH F1 locus
 26, 	// ZH percent
 55, 	// ZH transition duration
 2000, 	// ZH F2 locus
 30, 	// ZH percent
 70, 	// ZH transition duration
 2940, 	// ZH F3 locus
 51, 	// ZH percent
 70, 	// ZH transition duration
 440, 	// P  F1 locus
 55, 	// P  percent
 20, 	// P  transition duration
 1570, 	// P  F2 locus
 47, 	// P  percent
 25, 	// P  transition duration
 1660, 	// P  F3 locus
 73, 	// P  percent
 35, 	// P  transition duration
 290, 	// B  F1 locus
 30, 	// B  percent
 30, 	// B  transition duration
 1800, 	// B  F2 locus
 17, 	// B  percent
 25, 	// B  transition duration
 2690, 	// B  F3 locus
 30, 	// B  percent
 35, 	// B  transition duration
 180, 	// T  F1 locus
 56, 	// T  percent
 50, 	// T  transition duration
 2400, 	// T  F2 locus
 25, 	// T  percent
 35, 	// T  transition duration
 3000, 	// T  F3 locus
 10, 	// T  percent
 45, 	// T  transition duration
 270, 	// D  F1 locus
 33, 	// D  percent
 35, 	// D  transition duration
 2150, 	// D  F2 locus
 60, 	// D  percent
 35, 	// D  transition duration
 3150, 	// D  F3 locus
 30, 	// D  percent
 45, 	// D  transition duration
 180, 	// K  F1 locus
 33, 	// K  percent
 40, 	// K  transition duration
 2200, 	// K  F2 locus
 18, 	// K  percent
 40, 	// K  transition duration
 2400, 	// K  F3 locus
 10, 	// K  percent
 50, 	// K  transition duration
 300, 	// G  F1 locus
 33, 	// G  percent
 45, 	// G  transition duration
 2550, 	// G  F2 locus
 13, 	// G  percent
 70, 	// G  transition duration
 2700, 	// G  F3 locus
 10, 	// G  percent
 50, 	// G  transition duration
 300, 	// DX F1 locus
 50, 	// DX percent
 30, 	// DX transition duration
 1800, 	// DX F2 locus
 50, 	// DX percent
 40, 	// DX transition duration
 2200, 	// DX F3 locus
 40, 	// DX percent
 30, 	// DX transition duration
 470, 	// TX F1 locus
 33, 	// TX percent
 35, 	// TX transition duration
 2150, 	// TX F2 locus
 60, 	// TX percent
 35, 	// TX transition duration
 3150, 	// TX F3 locus
 30, 	// TX percent
 45, 	// TX transition duration
 400, 	// CH F1 locus
 34, 	// CH percent
 55, 	// CH transition duration
 2100, 	// CH F2 locus
 25, 	// CH percent
 70, 	// CH transition duration
 3300, 	// CH F3 locus
 19, 	// CH percent
 70, 	// CH transition duration
 370, 	// JH F1 locus
 32, 	// JH percent
 55, 	// JH transition duration
 2000, 	// JH F2 locus
 25, 	// JH percent
 70, 	// JH transition duration
 3300, 	// JH F3 locus
 19, 	// JH percent
 70, 	// JH transition duration
 350, 	// DF F1 locus
 50, 	// DF percent
 50, 	// DF transition duration
 1800, 	// DF F2 locus
 50, 	// DF percent
 40, 	// DF transition duration
 1800, 	// DF F3 locus
 40, 	// DF percent
 30, 	// DF transition duration
 501, 	// TZ F1 locus
 50, 	// TZ percent
 70, 	// TZ transition duration
 1600, 	// TZ F2 locus
 20, 	// TZ percent
 150, 	// TZ transition duration
 2160, 	// TZ F3 locus
 50, 	// TZ percent
 60, 	// TZ transition duration
 330, 	// CZ F1 locus
 70, 	// CZ percent
 20, 	// CZ transition duration
 1710, 	// CZ F2 locus
 70, 	// CZ percent
 30, 	// CZ transition duration
 2260, 	// CZ F3 locus
 50, 	// CZ percent
 60, 	// CZ transition duration
// Back
 300, 	// M  F1 locus
 20, 	// M  percent
 30, 	// M  transition duration
 1, 	// M  F2 locus
 88, 	// M  percent
 40, 	// M  transition duration
 1750, 	// M  F3 locus
 80, 	// M  percent
 25, 	// M  transition duration
 300, 	// N  F1 locus
 22, 	// N  percent
 30, 	// N  transition duration
 1400, 	// N  F2 locus
 65, 	// N  percent
 75, 	// N  transition duration
 2200, 	// N  F3 locus
 30, 	// N  percent
 60, 	// N  transition duration
 180, 	// NX F1 locus
 20, 	// NX percent
 40, 	// NX transition duration
 1970, 	// NX F2 locus
 20, 	// NX percent
 70, 	// NX transition duration
 2620, 	// NX F3 locus
 20, 	// NX percent
 70, 	// NX transition duration
 400, 	// DZ F1 locus
 30, 	// DZ percent
 50, 	// DZ transition duration
 1800, 	// DZ F2 locus
 42, 	// DZ percent
 70, 	// DZ transition duration
 3060, 	// DZ F3 locus
 11, 	// DZ percent
 70, 	// DZ transition duration
 450, 	// EN F1 locus
 22, 	// EN percent
 30, 	// EN transition duration
 2200, 	// EN F2 locus
 65, 	// EN percent
 75, 	// EN transition duration
 3140, 	// EN F3 locus
 30, 	// EN percent
 60, 	// EN transition duration
 350, 	// F  F1 locus
 75, 	// F  percent
 30, 	// F  transition duration
 1, 	// F  F2 locus
 85, 	// F  percent
 30, 	// F  transition duration
 2000, 	// F  F3 locus
 65, 	// F  percent
 40, 	// F  transition duration
 330, 	// V  F1 locus
 75, 	// V  percent
 30, 	// V  transition duration
 1, 	// V  F2 locus
 84, 	// V  percent
 30, 	// V  transition duration
 2000, 	// V  F3 locus
 65, 	// V  percent
 40, 	// V  transition duration
 440, 	// TH F1 locus
 30, 	// TH percent
 50, 	// TH transition duration
 1800, 	// TH F2 locus
 42, 	// TH percent
 70, 	// TH transition duration
 3060, 	// TH F3 locus
 11, 	// TH percent
 70, 	// TH transition duration
 400, 	// DH F1 locus
 30, 	// DH percent
 50, 	// DH transition duration
 1800, 	// DH F2 locus
 42, 	// DH percent
 70, 	// DH transition duration
 3060, 	// DH F3 locus
 11, 	// DH percent
 70, 	// DH transition duration
 390, 	// S  F1 locus
 40, 	// S  percent
 40, 	// S  transition duration
 1800, 	// S  F2 locus
 40, 	// S  percent
 50, 	// S  transition duration
 3070, 	// S  F3 locus
 0, 	// S  percent
 70, 	// S  transition duration
 320, 	// Z  F1 locus
 35, 	// Z  percent
 40, 	// Z  transition duration
 1800, 	// Z  F2 locus
 40, 	// Z  percent
 50, 	// Z  transition duration
 3070, 	// Z  F3 locus
 0, 	// Z  percent
 70, 	// Z  transition duration
 360, 	// SH F1 locus
 32, 	// SH percent
 55, 	// SH transition duration
 1850, 	// SH F2 locus
 7, 	// SH percent
 70, 	// SH transition duration
 2700, 	// SH F3 locus
 0, 	// SH percent
 85, 	// SH transition duration
 320, 	// ZH F1 locus
 26, 	// ZH percent
 55, 	// ZH transition duration
 1850, 	// ZH F2 locus
 7, 	// ZH percent
 70, 	// ZH transition duration
 2700, 	// ZH F3 locus
 0, 	// ZH percent
 85, 	// ZH transition duration
 440, 	// P  F1 locus
 45, 	// P  percent
 25, 	// P  transition duration
 1240, 	// P  F2 locus
 8, 	// P  percent
 30, 	// P  transition duration
 1900, 	// P  F3 locus
 65, 	// P  percent
 40, 	// P  transition duration
 150, 	// B  F1 locus
 50, 	// B  percent
 35, 	// B  transition duration
 890, 	// B  F2 locus
 80, 	// B  percent
 30, 	// B  transition duration
 1570, 	// B  F3 locus
 88, 	// B  percent
 40, 	// B  transition duration
 180, 	// T  F1 locus
 56, 	// T  percent
 70, 	// T  transition duration
 2050, 	// T  F2 locus
 0, 	// T  percent
 80, 	// T  transition duration
 2850, 	// T  F3 locus
 0, 	// T  percent
 70, 	// T  transition duration
 370, 	// D  F1 locus
 33, 	// D  percent
 45, 	// D  transition duration
 2050, 	// D  F2 locus
 0, 	// D  percent
 80, 	// D  transition duration
 2990, 	// D  F3 locus
 0, 	// D  percent
 50, 	// D  transition duration
 180, 	// K  F1 locus
 33, 	// K  percent
 45, 	// K  transition duration
 1800, 	// K  F2 locus
 10, 	// K  percent
 70, 	// K  transition duration
 2100, 	// K  F3 locus
 15, 	// K  percent
 70, 	// K  transition duration
 340, 	// G  F1 locus
 43, 	// G  percent
 50, 	// G  transition duration
 1900, 	// G  F2 locus
 10, 	// G  percent
 80, 	// G  transition duration
 2370, 	// G  F3 locus
 10, 	// G  percent
 80, 	// G  transition duration
 350, 	// DX F1 locus
 50, 	// DX percent
 30, 	// DX transition duration
 1800, 	// DX F2 locus
 50, 	// DX percent
 50, 	// DX transition duration
 2200, 	// DX F3 locus
 40, 	// DX percent
 30, 	// DX transition duration
 470, 	// TX F1 locus
 33, 	// TX percent
 45, 	// TX transition duration
 2050, 	// TX F2 locus
 0, 	// TX percent
 80, 	// TX transition duration
 2990, 	// TX F3 locus
 0, 	// TX percent
 50, 	// TX transition duration
 420, 	// CH F1 locus
 40, 	// CH percent
 55, 	// CH transition duration
 1900, 	// CH F2 locus
 10, 	// CH percent
 70, 	// CH transition duration
 3200, 	// CH F3 locus
 10, 	// CH percent
 70, 	// CH transition duration
 380, 	// JH F1 locus
 40, 	// JH percent
 55, 	// JH transition duration
 1900, 	// JH F2 locus
 10, 	// JH percent
 70, 	// JH transition duration
 3200, 	// JH F3 locus
 10, 	// JH percent
 70, 	// JH transition duration
 350, 	// DF F1 locus
 50, 	// DF percent
 50, 	// DF transition duration
 1800, 	// DF F2 locus
 50, 	// DF percent
 40, 	// DF transition duration
 1800, 	// DF F3 locus
 40, 	// DF percent
 30, 	// DF transition duration
 330, 	// TZ F1 locus
 70, 	// TZ percent
 35, 	// TZ transition duration
 1610, 	// TZ F2 locus
 20, 	// TZ percent
 80, 	// TZ transition duration
 2160, 	// TZ F3 locus
 50, 	// TZ percent
 60, 	// TZ transition duration
 330, 	// CZ F1 locus
 70, 	// CZ percent
 30, 	// CZ transition duration
 1710, 	// CZ F2 locus
 70, 	// CZ percent
 30, 	// CZ transition duration
 2260, 	// CZ F3 locus
 50, 	// CZ percent
 60, 	// CZ transition duration
// Round
 300, 	// M  F1 locus
 20, 	// M  percent
 30, 	// M  transition duration
 1, 	// M  F2 locus
 88, 	// M  percent
 40, 	// M  transition duration
 1750, 	// M  F3 locus
 80, 	// M  percent
 30, 	// M  transition duration
 300, 	// N  F1 locus
 24, 	// N  percent
 30, 	// N  transition duration
 2160, 	// N  F2 locus
 65, 	// N  percent
 80, 	// N  transition duration
 2000, 	// N  F3 locus
 30, 	// N  percent
 80, 	// N  transition duration
 180, 	// NX F1 locus
 20, 	// NX percent
 40, 	// NX transition duration
 1650, 	// NX F2 locus
 42, 	// NX percent
 70, 	// NX transition duration
 2500, 	// NX F3 locus
 25, 	// NX percent
 70, 	// NX transition duration
 400, 	// DZ F1 locus
 30, 	// DZ percent
 50, 	// DZ transition duration
 1800, 	// DZ F2 locus
 42, 	// DZ percent
 70, 	// DZ transition duration
 3060, 	// DZ F3 locus
 11, 	// DZ percent
 70, 	// DZ transition duration
 450, 	// EN F1 locus
 24, 	// EN percent
 30, 	// EN transition duration
 2160, 	// EN F2 locus
 65, 	// EN percent
 80, 	// EN transition duration
 2590, 	// EN F3 locus
 30, 	// EN percent
 80, 	// EN transition duration
 350, 	// F  F1 locus
 75, 	// F  percent
 30, 	// F  transition duration
 1, 	// F  F2 locus
 85, 	// F  percent
 30, 	// F  transition duration
 2000, 	// F  F3 locus
 65, 	// F  percent
 40, 	// F  transition duration
 330, 	// V  F1 locus
 75, 	// V  percent
 30, 	// V  transition duration
 1, 	// V  F2 locus
 84, 	// V  percent
 30, 	// V  transition duration
 2000, 	// V  F3 locus
 65, 	// V  percent
 40, 	// V  transition duration
 440, 	// TH F1 locus
 30, 	// TH percent
 50, 	// TH transition duration
 1800, 	// TH F2 locus
 42, 	// TH percent
 70, 	// TH transition duration
 3060, 	// TH F3 locus
 11, 	// TH percent
 70, 	// TH transition duration
 400, 	// DH F1 locus
 30, 	// DH percent
 50, 	// DH transition duration
 1800, 	// DH F2 locus
 42, 	// DH percent
 70, 	// DH transition duration
 3060, 	// DH F3 locus
 11, 	// DH percent
 70, 	// DH transition duration
 390, 	// S  F1 locus
 40, 	// S  percent
 40, 	// S  transition duration
 1900, 	// S  F2 locus
 15, 	// S  percent
 60, 	// S  transition duration
 2880, 	// S  F3 locus
 0, 	// S  percent
 65, 	// S  transition duration
 320, 	// Z  F1 locus
 40, 	// Z  percent
 40, 	// Z  transition duration
 1900, 	// Z  F2 locus
 15, 	// Z  percent
 60, 	// Z  transition duration
 2880, 	// Z  F3 locus
 0, 	// Z  percent
 65, 	// Z  transition duration
 400, 	// SH F1 locus
 32, 	// SH percent
 55, 	// SH transition duration
 1840, 	// SH F2 locus
 7, 	// SH percent
 90, 	// SH transition duration
 2700, 	// SH F3 locus
 20, 	// SH percent
 110, 	// SH transition duration
 320, 	// ZH F1 locus
 30, 	// ZH percent
 55, 	// ZH transition duration
 1840, 	// ZH F2 locus
 7, 	// ZH percent
 90, 	// ZH transition duration
 2700, 	// ZH F3 locus
 20, 	// ZH percent
 110, 	// ZH transition duration
 440, 	// P  F1 locus
 45, 	// P  percent
 25, 	// P  transition duration
 1130, 	// P  F2 locus
 50, 	// P  percent
 30, 	// P  transition duration
 2530, 	// P  F3 locus
 48, 	// P  percent
 40, 	// P  transition duration
 190, 	// B  F1 locus
 50, 	// B  percent
 35, 	// B  transition duration
 890, 	// B  F2 locus
 80, 	// B  percent
 30, 	// B  transition duration
 1570, 	// B  F3 locus
 88, 	// B  percent
 40, 	// B  transition duration
 180, 	// T  F1 locus
 56, 	// T  percent
 65, 	// T  transition duration
 2600, 	// T  F2 locus
 40, 	// T  percent
 100, 	// T  transition duration
 2850, 	// T  F3 locus
 0, 	// T  percent
 90, 	// T  transition duration
 370, 	// D  F1 locus
 33, 	// D  percent
 40, 	// D  transition duration
 1900, 	// D  F2 locus
 0, 	// D  percent
 80, 	// D  transition duration
 2900, 	// D  F3 locus
 20, 	// D  percent
 80, 	// D  transition duration
 180, 	// K  F1 locus
 46, 	// K  percent
 35, 	// K  transition duration
 1710, 	// K  F2 locus
 71, 	// K  percent
 65, 	// K  transition duration
 2300, 	// K  F3 locus
 0, 	// K  percent
 80, 	// K  transition duration
 370, 	// G  F1 locus
 45, 	// G  percent
 40, 	// G  transition duration
 1710, 	// G  F2 locus
 71, 	// G  percent
 65, 	// G  transition duration
 2300, 	// G  F3 locus
 15, 	// G  percent
 80, 	// G  transition duration
 350, 	// DX F1 locus
 50, 	// DX percent
 30, 	// DX transition duration
 1600, 	// DX F2 locus
 50, 	// DX percent
 30, 	// DX transition duration
 2200, 	// DX F3 locus
 40, 	// DX percent
 30, 	// DX transition duration
 470, 	// TX F1 locus
 33, 	// TX percent
 40, 	// TX transition duration
 1900, 	// TX F2 locus
 0, 	// TX percent
 70, 	// TX transition duration
 2900, 	// TX F3 locus
 20, 	// TX percent
 70, 	// TX transition duration
 420, 	// CH F1 locus
 34, 	// CH percent
 55, 	// CH transition duration
 2050, 	// CH F2 locus
 10, 	// CH percent
 90, 	// CH transition duration
 3100, 	// CH F3 locus
 10, 	// CH percent
 100, 	// CH transition duration
 380, 	// JH F1 locus
 32, 	// JH percent
 55, 	// JH transition duration
 2050, 	// JH F2 locus
 10, 	// JH percent
 90, 	// JH transition duration
 3100, 	// JH F3 locus
 10, 	// JH percent
 100, 	// JH transition duration
 350, 	// DF F1 locus
 50, 	// DF percent
 50, 	// DF transition duration
 1600, 	// DF F2 locus
 50, 	// DF percent
 40, 	// DF transition duration
 1800, 	// DF F3 locus
 40, 	// DF percent
 30, 	// DF transition duration
 501, 	// TZ F1 locus
 50, 	// TZ percent
 40, 	// TZ transition duration
 1600, 	// TZ F2 locus
 20, 	// TZ percent
 90, 	// TZ transition duration
 2260, 	// TZ F3 locus
 50, 	// TZ percent
 60, 	// TZ transition duration
 330, 	// CZ F1 locus
 70, 	// CZ percent
 30, 	// CZ transition duration
 1710, 	// CZ F2 locus
 70, 	// CZ percent
 30, 	// CZ transition duration
 2260, 	// CZ F3 locus
 50, 	// CZ percent
 60, 	// CZ transition duration
// Low
 0, 	// M  F1 locus
 0, 	// M  percent
 0, 	// M  transition duration
 0, 	// M  F2 locus
 0, 	// M  percent
 0, 	// M  transition duration
 0, 	// M  F3 locus
 0, 	// M  percent
 0, 	// M  transition duration
 0, 	// N  F1 locus
 0, 	// N  percent
 0, 	// N  transition duration
 0, 	// N  F2 locus
 0, 	// N  percent
 0, 	// N  transition duration
 0, 	// N  F3 locus
 0, 	// N  percent
 0, 	// N  transition duration
 0, 	// NX F1 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// NX F2 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// NX F3 locus
 0, 	// NX percent
 0, 	// NX transition duration
 0, 	// DZ F1 locus
 0, 	// DZ percent
 0, 	// DZ transition duration
 0, 	// DZ F2 locus
 0, 	// DZ percent
 0, 	// DZ transition duration
 0, 	// DZ F3 locus
 0, 	// DZ percent
 0, 	// DZ transition duration
 0, 	// EN F1 locus
 0, 	// EN percent
 0, 	// EN transition duration
 0, 	// EN F2 locus
 0, 	// EN percent
 0, 	// EN transition duration
 0, 	// EN F3 locus
 0, 	// EN percent
 0, 	// EN transition duration
 0, 	// F  F1 locus
 0, 	// F  percent
 0, 	// F  transition duration
 0, 	// F  F2 locus
 0, 	// F  percent
 0, 	// F  transition duration
 0, 	// F  F3 locus
 0, 	// F  percent
 0, 	// F  transition duration
 0, 	// V  F1 locus
 0, 	// V  percent
 0, 	// V  transition duration
 0, 	// V  F2 locus
 0, 	// V  percent
 0, 	// V  transition duration
 0, 	// V  F3 locus
 0, 	// V  percent
 0, 	// V  transition duration
 0, 	// TH F1 locus
 0, 	// TH percent
 0, 	// TH transition duration
 0, 	// TH F2 locus
 0, 	// TH percent
 0, 	// TH transition duration
 0, 	// TH F3 locus
 0, 	// TH percent
 0, 	// TH transition duration
 0, 	// DH F1 locus
 0, 	// DH percent
 0, 	// DH transition duration
 0, 	// DH F2 locus
 0, 	// DH percent
 0, 	// DH transition duration
 0, 	// DH F3 locus
 0, 	// DH percent
 0, 	// DH transition duration
 0, 	// S  F1 locus
 0, 	// S  percent
 0, 	// S  transition duration
 0, 	// S  F2 locus
 0, 	// S  percent
 0, 	// S  transition duration
 0, 	// S  F3 locus
 0, 	// S  percent
 0, 	// S  transition duration
 0, 	// Z  F1 locus
 0, 	// Z  percent
 0, 	// Z  transition duration
 0, 	// Z  F2 locus
 0, 	// Z  percent
 0, 	// Z  transition duration
 0, 	// Z  F3 locus
 0, 	// Z  percent
 0, 	// Z  transition duration
 0, 	// SH F1 locus
 0, 	// SH percent
 0, 	// SH transition duration
 0, 	// SH F2 locus
 0, 	// SH percent
 0, 	// SH transition duration
 0, 	// SH F3 locus
 0, 	// SH percent
 0, 	// SH transition duration
 0, 	// ZH F1 locus
 0, 	// ZH percent
 0, 	// ZH transition duration
 0, 	// ZH F2 locus
 0, 	// ZH percent
 0, 	// ZH transition duration
 0, 	// ZH F3 locus
 0, 	// ZH percent
 0, 	// ZH transition duration
 0, 	// P  F1 locus
 0, 	// P  percent
 0, 	// P  transition duration
 0, 	// P  F2 locus
 0, 	// P  percent
 0, 	// P  transition duration
 0, 	// P  F3 locus
 0, 	// P  percent
 0, 	// P  transition duration
 0, 	// B  F1 locus
 0, 	// B  percent
 0, 	// B  transition duration
 0, 	// B  F2 locus
 0, 	// B  percent
 0, 	// B  transition duration
 0, 	// B  F3 locus
 0, 	// B  percent
 0, 	// B  transition duration
 0, 	// T  F1 locus
 0, 	// T  percent
 0, 	// T  transition duration
 0, 	// T  F2 locus
 0, 	// T  percent
 0, 	// T  transition duration
 0, 	// T  F3 locus
 0, 	// T  percent
 0, 	// T  transition duration
 0, 	// D  F1 locus
 0, 	// D  percent
 0, 	// D  transition duration
 0, 	// D  F2 locus
 0, 	// D  percent
 0, 	// D  transition duration
 0, 	// D  F3 locus
 0, 	// D  percent
 0, 	// D  transition duration
 0, 	// K  F1 locus
 0, 	// K  percent
 0, 	// K  transition duration
 0, 	// K  F2 locus
 0, 	// K  percent
 0, 	// K  transition duration
 0, 	// K  F3 locus
 0, 	// K  percent
 0, 	// K  transition duration
 0, 	// G  F1 locus
 0, 	// G  percent
 0, 	// G  transition duration
 0, 	// G  F2 locus
 0, 	// G  percent
 0, 	// G  transition duration
 0, 	// G  F3 locus
 0, 	// G  percent
 0, 	// G  transition duration
 0, 	// TX F1 locus
 0, 	// TX percent
 0, 	// TX transition duration
 0, 	// TX F2 locus
 0, 	// TX percent
 0, 	// TX transition duration
 0, 	// TX F3 locus
 0, 	// TX percent
 0, 	// TX transition duration
 0, 	// CH F1 locus
 0, 	// CH percent
 0, 	// CH transition duration
 0, 	// CH F2 locus
 0, 	// CH percent
 0, 	// CH transition duration
 0, 	// CH F3 locus
 0, 	// CH percent
 0, 	// CH transition duration
 0, 	// JH F1 locus
 0, 	// JH percent
 0, 	// JH transition duration
 0, 	// JH F2 locus
 0, 	// JH percent
 0, 	// JH transition duration
 0, 	// JH F3 locus
 0, 	// JH percent
 0, 	// JH transition duration
 -1, 	// CZ F1 locus
 -1, 	// CZ percent
 -1, 	// CZ transition duration
 1710, 	// CZ F2 locus
 70, 	// CZ percent
 30, 	// CZ transition duration
 -1, 	// CZ F3 locus
 -1, 	// CZ percent
 -1, 	// CZ transition duration
 0};

const struct rom_data_s us_rom_data_sue = {
us_inhdr_sue,
us_mindur_sue,
us_burdr_sue,
us_begtyp_sue,
us_endtyp_sue,
us_place_sue,
us_featb_sue,
us_maltar_sue,
us_femtar_sue,
us_maldip_sue,
us_femdip_sue,
us_ptram_sue,
us_plocu_sue,
us_maleloc_sue,
us_femloc_sue
};


