/**********************************************************************/
/*                                                                    */
/*  Copyright Digital Equipment Corporation, 1994,                    */
/*  All rights reserved.                                              */
/*                                                                    */
/*  This software is proprietary to and embodies the confidential     */
/*  technology of Digital Equipment Corporation. Possession, use,     */
/*  or copying of this software and media is authorized only pursuant */
/*  to a valid written license from Digital or an authorized          */
/*  sublicensor.                                                      */
/*                                                                    */
/*  Restricted Rights: Use, duplication, or disclosure by the         */
/*  U.S. Government is subject to restrictions as set forth in        */
/*  subparagraph (c) (1) (ii) of DFARS 252.227-7013, or in            */
/*  FAR 52.227-19, or in FAR 52.227-14 Alt. III as applicable.        */
/*                                                                    */
/*  The name of Digital Equipment Corporation may not be used to      */
/*  endorse or promote products derived from this software without    */
/*  specific prior written permission. All other rights reserved.     */
/*                                                                    */
/*  This software is provided "as is" and without any express or      */
/*  implied warranties, including, without limitation, implied        */
/*  warranties of non-infringement, merchantibility or fitness        */
/*  for a particular purpose. Digital assumes no responsibility AT    */
/*  ALL for the use or reliability of this software.                  */
/*                                                                    */
/**********************************************************************/
/**********************************************************************/
/*  The following symbols are output in the structure of type         */
/*  PHONEME_T when performing speech to memory.                       */
/*                                                                    */
/*  American English phoneme codes.                                   */
/**********************************************************************/

#define SIL              0
#define IY               1
#define IH               2
#define EY               3
#define EH               4
#define AE               5
#define AA               6
#define AY               7
#define AW               8
#define AH               9
#define AO              10
#define OW              11
#define OY              12
#define UH              13
#define UW              14
#define RR              15
#define YU              16
#define AX              17
#define IX              18
#define IR              19
#define ER              20
#define AR              21
#define OR              22
#define UR              23
#define W               24
#define Y               25
#define R               26
#define LL              27
#define HX              28
#define RX              29
#define LX              30
#define M               31
#define N               32
#define NX              33
#define EL              34
#define D_DENTALIZED    35
#define EN              36
#define F               37
#define V               38
#define TH              39
#define DH              40
#define S               41
#define Z               42
#define SH              43
#define ZH              44
#define P               45
#define B               46
#define T               47
#define D               48
#define K               49
#define G               50
#define DX              51
#define TX              52
#define Q               53    /*  Glottal stop                        */
#define CH              54
#define JH              55

/**********************************************************************/
/*  End of phoneme definitions. Additional symbols generated by the   */
/*  Text-To-Speech system.                                            */
/**********************************************************************/

#define  BLOCK_RULES    56    /*  Block allophone substitutes.        */
#define  S2             57    /*  Secondary stress                    */
#define  S1             58    /*  Primary stress                      */
#define  SEMPH          59    /*  Emphatic stress                     */
#define  HAT_RISE       60    /*  Explicit hat rise                   */
#define  HAT_FALL       61    /*  Explicit hat fall                   */
#define  HAT_RF         62    /*  Explicit hat rise-fall              */
#define  SBOUND         63    /*  Syllable boundary                   */
#define  MBOUND         64    /*  Morpheme boundary                   */
#define  HYPHEN         65    /*  For noun compounds                  */
#define  WBOUND         66    /*  Word boundary                       */
#define  PPSTART        67    /*  Prep phrase start                   */
#define  VPSTART        68    /*  Verb phrase start                   */
#define  RELSTART       69    /*  Intro. to sentence or clause        */
#define  COMMA          70    /*  End of clause                       */
#define  PERIOD         71    /*  End of sentence                     */
#define  QUEST          72    /*  End of question                     */
#define  EXCLAIM        73    /*  End of exclamatory sentence!        */
#define  NEW_PARAGRAPH  74    /*  Explicit new paragraph              */
