/*C_HEADER_FILE****************************************************************
FILE			:	CreateKoreanDict.c
DESC			:	
TABS			:	4
OWNER			:	
DATE CREATED:	10 Jan 2006

(C) Copyright 2005 All rights reserved.
This is an unpublished work, and is confidential and proprietary: 
technology and information of fonix corporation.  No part of this
code may be reproduced, used or disclosed without written consent of 
fonix corporation in each and every instance.

  $Date:  $
  $Revision:  $

*END_HEADER*******************************************************************/
#include "BuildJpDic.h"
#include "CodePageConv.h"

/*FUNCTION_HEADER**********************
 * NAME:	;WriteHanjaTable
 * DESC: 	Write Hanja symbols and Romaji pronunciations
 * IN:		
 * OUT:		
 * RETURN:	
 * NOTES:	
 *END_HEADER***************************/
void WriteHanjaTable(char *sOutFile, KANJIDIC **ppKanji, unsigned int nKanji)
{
	unsigned int
		i;
	wchar_t
		wc,
		wsText[128];
	FILE 
		*fp;
	KOREAN_READING 
		*pReading;

	if( sOutFile == NULL || ppKanji == NULL )		// Idiot check
		return;

	if( (fp = fopen(sOutFile, "wb")) == NULL )		// Open output file
		return;

	wc = 0xfeff;
	fwrite(&wc, sizeof(wchar_t), 1, fp);			// Write Unicode header


	for( i=0; i<nKanji; i++ )
	{
		wc = Convert(ppKanji[i]->wcKanji, eEuc, eUtf16);
		wsText[0] = wc;
		wsText[1] = 0x00;
		fwprintf(fp, L"[%d] %c U+0x%x EUC+0x%x\n", i, wc, wc, ppKanji[i]->wcKanji);
		for( pReading=ppKanji[i]->pKorean; pReading; pReading=pReading->pNext )
		{
			fwprintf(fp, L"\t%-6S\n", pReading->sReading);
		}
	}

	fclose(fp);
}
