// NonstreamSample.c  : Fonix Simple API example
//
// This simple example has only enough code to see the required API's.  
// Return codes have not been checked to make this code easier to read.
//

#include <stdio.h>
#include "FonixTtsDtSimple.h"

#define SAMPLE_RATE 11025
#define BYTES_PER_SAMPLE 2

unsigned int CPU_CLK_RATE = 60000000;			// set to the clock rate of the CPU, used by the speaker code

#define BUFFERED_AUDIO_LEN 71*1024
short BufferedAudio[BUFFERED_AUDIO_LEN];		// used by the TTS engine to buffer all audio data
												// may need to be longer depending on the maximum 
												// length of the audio data to be generated

int main( int argc, char* argv[] )
{
	char ReceivedString[256];
	int actualSamples;
	int samplesEachplay;
	int Language = US_English;
	int Voice = Paul;

	ReceivedString[0] = 0;
	AudioOutCreate();		// changes the pins used by the speaker code to outputs and sets them LOW
							// this should eliminate the pops that occur when the speaker is opened or closed

	while(1)
	{
		printf( "\n0: US English (default)" );		// select from languages included in the build
//		printf( "\n1: French" );
//		printf( "\n2: German" );
//		printf( "\n3: Castilian Spanish" );
//		printf( "\n5: UK English" );
		printf( "\n6: Latin American Spanish" );
//		printf( "\n7: Italian");
		printf( "\nSelect a language by number:" );
		gets( ReceivedString );
		Language = (int)(ReceivedString[0] - 0x30);

		printf( "\n0: Paul (default)" );			// select a voice
		printf( "\n1: Harry" );
		printf( "\n2: Frank" );
		printf( "\n3: Dennis" );
		printf( "\n4: Kit" );
		printf( "\n5: Betty" );
		printf( "\n6: Ursula" );
		printf( "\n7: Rita" );
		printf( "\n8: Wendy" );
		printf( "\nSelect a voice by number:" );
		gets( ReceivedString );
		Voice = (int)(ReceivedString[0] - 0x30);

		printf( "\nEnter a text string:" );			// get the text to speak
		gets( ReceivedString );

		FnxTTSDtSimpleOpen( NULL, NULL);	// open TTS engine & set to return audio data at the end of synthesis (no callback)
		FnxTTSDtSimpleSetLanguage( Language, NULL );
		FnxTTSDtSimpleChangeVoice( Voice, WAVE_FORMAT_1M16 );

		// Create the audio data
		printf( "\nTTS engine buffering audio" );
		actualSamples = FnxTTSDtSimpleStart( ReceivedString, BufferedAudio, BUFFERED_AUDIO_LEN, WAVE_FORMAT_1M16);

		// Play the audio data
		AudioOutInit( &samplesEachplay, SAMPLE_RATE, 2, 2, 0 );
		if( actualSamples >= 0 )
			AudioOutPlay( BufferedAudio, actualSamples );	// play all the audio created
		else 
			AudioOutPlay( BufferedAudio, BUFFERED_AUDIO_LEN );	// there wasn't enough space in the buffer for all the audio, play what audio was returned
		AudioOutQuit();						// blocks until all data is played and closes the audio channel
		FnxTTSDtSimpleClose();				// closes the TTS engine 
	}
	return 0;
}
