#include <string.h>
#include "FonixTtsDtSimple.h"

#ifdef MICRODECTALK
#include "epsonapi.h"
#else
#include "simpleapi.h"
#endif

#ifdef OS_SYMBIAN
#include "GlobalDT.h"
#include "kernel.h"
#include <stdio.h>
#endif

#ifndef OS_SYMBIAN
#ifdef AD_VDSP
section("INTERNAL_DATA") volatile FTTSDTUDATA_T gDECtalkUserData;
#else
volatile FTTSDTUDATA_T gDECtalkUserData;
#endif  
extern	ReInit;
#ifdef NO_INITALIZED_GLOBALS
volatile FTTSDTUDATA_T *gpDECtalkUserData;  
#else
volatile FTTSDTUDATA_T *gpDECtalkUserData = &gDECtalkUserData;  
#endif
#endif //OS_SYMBIAN

int ghaltSpeech;

#if defined(__cplusplus)
extern "C" {
#endif
/*******************************************************************************
int FnxTTSDtSimpleCallback(short *output_buf,long error)
intilizes the TTS
Accepts a pointer to a array of 'short' and a 'long' error / status flag
     (size is 71 for 11Khz samplerate or 51 for 8Khz)
Returns a pointer to a buffer of shorts to receive the next data generated by 
the engine.  Returning a NULL for the buffer aborts the current synthesis 
operation
*******************************************************************************/
#ifdef AD_VDSP
section("INTERNAL_PROGRAM") short *FnxTTSDtSimpleCallback(short *output_buf,long error)
#else
short *FnxTTSDtSimpleCallback(short *output_buf,long error)
#endif
{
  int reqLength = 0;
#ifdef OS_SYMBIAN
  GlobalDTPtr vgp = GetGlobalDTPtr();
  FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
#endif

  switch (error)
  {
  	case 0:
	  // Calculate the erquired buffer length to contain the next buffer
		if (gpDECtalkUserData->gDECtalkFlags > 2)
		  return(NULL);

#ifdef MICRODECTALK
		if( !gpDECtalkUserData->gDECtalkOverflow )
			memcpy( (char *)(gpDECtalkUserData->gDECtalkBufPtr + gpDECtalkUserData->gDECtalkBufPos), output_buf, gpDECtalkUserData->gDECtalkPktSize[gpDECtalkUserData->gDECtalkFlags] * sizeof(short) );
#endif
		// Increment the buffer position pointer
		gpDECtalkUserData->gDECtalkBufPos += 
			gpDECtalkUserData->gDECtalkPktSize[gpDECtalkUserData->gDECtalkFlags];
			
#if 0
	   // Dump the buffer to the screen for debug 
		int i;
		unsigned long j;
		for (i=0;i<71;i++)
		{
			j=output_buf[i];
			if (i && i%8==0)
			{
				printf("\n");
			}
			printf("0x%04X ",j&0xFFFF);
		}
		printf("\n");
#endif
	
		// See if the buffer has enough room for the next buffer
		reqLength = gpDECtalkUserData->gDECtalkBufPos + gpDECtalkUserData->gDECtalkPktSize[gpDECtalkUserData->gDECtalkFlags];
		if (reqLength > gpDECtalkUserData->gDECtalkBufSize)
		  {
			 // If not, Indicate it and use the dummy buffer
			 gpDECtalkUserData->gDECtalkOverflow = 1;
			 return((short *)gpDECtalkUserData->gDECtalkDmyBuffer);
		  }
	
		return((short *)(gpDECtalkUserData->gDECtalkBufPtr + gpDECtalkUserData->gDECtalkBufPos));
		break;
	case 3:
		gpDECtalkUserData->gDECtalkLastIndex[0] = (short)*(output_buf);
		gpDECtalkUserData->gDECtalkLastIndex[1] = (short)*(output_buf+1);
		return((short *)(gpDECtalkUserData->gDECtalkBufPtr + gpDECtalkUserData->gDECtalkBufPos));
		break;
	default:
		return (NULL);
		break;
  }
	
}


/*******************************************************************************
int FnxTTSDtSimpleOpen(void * user_dict )
intilizes the TTS
Accepts a user dictionary as input
Returns the completion/error status flag
*******************************************************************************/
#ifndef OS_SYMBIAN
int FnxTTSDtSimpleOpen(short *(*callback)(short *,long),void *user_dict )
#else
int FnxTTSDtSimpleOpen(short *(*callback)(short *,long),void *user_dict )
#endif
{
  int retval = -1;
#ifdef OS_SYMBIAN
  GlobalDTPtr vgp = GetGlobalDTPtr();
  FTTSDTUDATA_T* gpDECtalkUserData = calloc(1, sizeof(FTTSDTUDATA_T));
  vgp->gpDECtalkUserData = gpDECtalkUserData;
#endif

#ifdef NO_INITALIZED_GLOBALS
  gpDECtalkUserData = &gDECtalkUserData;
	ReInit = 0;
#endif
//  if(( !gpDECtalkUserData->gDECtalkInit ) || (gpDECtalkUserData->gDECtalkUserDict != user_dict))
//	 {
		gpDECtalkUserData->gDECtalkPktSize[0] = gpDECtalkUserData->gDECtalkPktSize[1] = 71;
		gpDECtalkUserData->gDECtalkPktSize[2] = 51;
		gpDECtalkUserData->gDECtalkBufPos = 0;
		gpDECtalkUserData->gDECtalkBufPtr = NULL;
		gpDECtalkUserData->gDECtalkUserDict = user_dict;
		gpDECtalkUserData->gDECtalkLastIndex[0] = 0;
		gpDECtalkUserData->gDECtalkLastIndex[1] = 0;
		ghaltSpeech = 0;

		if (callback == NULL)
		{
#ifndef OS_SYMBIAN
			retval = TextToSpeechInit(FnxTTSDtSimpleCallback,user_dict);
#else
			retval = TextToSpeechInit(FnxTTSDtSimpleCallback,user_dict);
#endif
			gpDECtalkUserData->gDECtalkUserCallback = 0;
		}
		else
		{
#ifndef OS_SYMBIAN
			retval = TextToSpeechInit(callback,user_dict);
#else
			retval = TextToSpeechInit(callback,user_dict);
#endif
			gpDECtalkUserData->gDECtalkUserCallback = 1;
		}

		gpDECtalkUserData->gDECtalkVoiceID = 0;
		if( !retval )
			gpDECtalkUserData->gDECtalkInit = 1;
//	 }
  return(retval);
}

/*******************************************************************************
void FnxTTSDtSimpleClose()
closes the TTS core
*******************************************************************************/
void FnxTTSDtSimpleClose()
{
#ifdef OS_SYMBIAN
	TextToSpeechUnloadUserDictionary();
	CleanupMemory();
	DeleteDTTlsValue();
#endif
	return;
}

/*******************************************************************************
void FnxTTSDtSimpleStart(char *String,short *buffer,int buflength,int flags )
creates raw audio output and stores it in the supplied buffer for the input string
Accepts an input string, buffer, length, and format flag as input
Returns the number of samples or a negative value for error status
If the synthesized wave is larger than the buffer, only that portion
which will fit in the buffer is returned and the buffer length required is
returned as a negative number of samples.

*******************************************************************************/
int FnxTTSDtSimpleStart(char *String, short *buffer,int buflength,int flags )
{
	int retval = 0;
#ifdef OS_SYMBIAN
	GlobalDTPtr vgp = GetGlobalDTPtr();
	FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
#endif
	if (flags < 1 || flags > 2)
		return(1);

#ifdef MICRODECTALK
	if( !gpDECtalkUserData->gDECtalkUserCallback )
	{
		if (buflength < gpDECtalkUserData->gDECtalkPktSize[flags])
			return(1);
		if( !buffer )
			return(1);
	}
#else
	if (buflength < gpDECtalkUserData->gDECtalkPktSize[flags])
		return(1);
#endif
	gpDECtalkUserData->gDECtalkBufSize = buflength;
	gpDECtalkUserData->gDECtalkBufPos = 0;
	gpDECtalkUserData->gDECtalkBufPtr = buffer;
	gpDECtalkUserData->gDECtalkFlags = flags;
	gpDECtalkUserData->gDECtalkOverflow = 0;

	if( ghaltSpeech )
	{
		FnxTTSDtSimpleChangeVoice( gpDECtalkUserData->gDECtalkVoiceID, gpDECtalkUserData->gDECtalkFlags );
		ghaltSpeech = 0;
	}


#ifdef MICRODECTALK
	retval = TextToSpeechStart( String );
#else
	retval = TextToSpeechStart( String , (short *)gpDECtalkUserData->gDECtalkBufPtr, gpDECtalkUserData->gDECtalkFlags);
#endif
	if (retval != 0)
		return(retval);
	return ((gpDECtalkUserData->gDECtalkOverflow == 1) ? (0 - gpDECtalkUserData->gDECtalkBufPos) : gpDECtalkUserData->gDECtalkBufPos);
}

/*******************************************************************************
void FnxTTSDtSimpleChangeVoice(FnxDECtalkVoiceId NewVoice, int flags)
creates audio output and plays for the input string
*******************************************************************************/
void FnxTTSDtSimpleChangeVoice( FnxDECtalkVoiceId NewVoice ,int flags )
{
	char Name[18];
	int ret_val = 0;
	short NameBuf[213];
#ifdef OS_SYMBIAN
	GlobalDTPtr vgp = GetGlobalDTPtr();
	FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
#endif

	gpDECtalkUserData->gDECtalkFlags = flags;

	switch(NewVoice)
	{
		case Harry:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nh");		/*harry*/
#else
			strcpy(Name, "[:name harry]");		/*harry*/
#endif
			break;
		}
		case Frank:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nf");		/*frank*/
#else
			strcpy(Name, "[:name frank]");		/*frank*/
#endif
			break;
		}
		case Dennis:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nd");		/*dennis*/
#else
			strcpy(Name, "[:name dennis]");		/*dennis*/
#endif
			break;
		}
		case Kit:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nk");		/*kit*/
#else
			strcpy(Name, "[:name kit]");		/*kit*/
#endif
			break;
		}
		case Betty:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nb");		/*betty*/
#else
			strcpy(Name, "[:name betty]");		/*betty*/
#endif
			break;
		}
		case Ursula:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nu");		/*ursula*/
#else
			strcpy(Name, "[:name ursula]");		/*ursula*/
#endif
			break;
		}
		case Rita:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nr");		/*rita*/
#else
			strcpy(Name, "[:name rita]");		/*rita*/
#endif
			break;
		}
		case Wendy:
		{
#ifdef MICRODECTALK
			strcpy(Name, "nw");		/*wendy*/
#else
			strcpy(Name, "[:name wendy]");		/*wendy*/
#endif
			break;
		}
		case Paul:
		default:
		{
#ifdef MICRODECTALK
			strcpy(Name, "np");
#else
			strcpy(Name, "[:name paul]");
#endif
			break;
		}
	}
#ifdef MICRODECTALK
	TextToSpeechChangeVoice( Name );
#else
	ret_val = FnxTTSDtSimpleStart(Name, NameBuf, 213, flags);
#endif
	gpDECtalkUserData->gDECtalkVoiceID = NewVoice;
}

/*******************************************************************************
void FnxTTSHaltSpeech()
Stops current TTS string
Returns the completion/error status flag
*******************************************************************************/
int FnxTTSDtSimpleHaltSpeech()
{
	int retval = 0;
#ifdef OS_SYMBIAN
	GlobalDTPtr vgp = GetGlobalDTPtr();
	FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
#endif

	retval = TextToSpeechReset( );
	ghaltSpeech = 1;
	return(retval);
}

/*******************************************************************************
void FnxTTSResetSpeech()
Resets the TTS Engine to the Default Parameters
Returns the completion/error status flag
*******************************************************************************/
int FnxTTSDtSimpleResetSpeech()
{
	int retval = 0;
	retval = TextToSpeechReset( );
	return(retval);
}

/*******************************************************************************
int FnxTTSDtSimpleSetLanguage( int LanguageID, void *user_dict )
intilizes the TTS
Accepts a user dictionary as input
Returns the completion/error status flag - if fails language is not changed
*******************************************************************************/
int FnxTTSDtSimpleSetLanguage( int LanguageID, void *user_dict )
{
	int retval = -1;

#ifdef MULTIPLE_LANGUAGES_LOADED
#ifdef OS_SYMBIAN
	GlobalDTPtr vgp = GetGlobalDTPtr();
	FTTSDTUDATA_T* gpDECtalkUserData = vgp->gpDECtalkUserData;
#endif

	if( LanguageID < US_English || ( LanguageID > Castilian_Spanish && LanguageID < UK_English ) || LanguageID > Latin_American_Spanish )
		return(-2);
	if( !TextToSpeechChangeLanguage( LanguageID, user_dict ) )
	{
		gpDECtalkUserData->gDECtalkUserDict = user_dict;
//		FnxTTSDtSimpleHaltSpeech();
		retval = 0;
	}
	else
		retval = -3;
//	FnxTTSDtSimpleChangeVoice( gpDECtalkUserData->gDECtalkVoiceID, WAVE_FORMAT_1M16 );
#endif
	return(retval);
}

#ifdef OS_SYMBIAN
/*******************************************************************************
int FnxTTSDtSimpleSetDictionary( char *pPath )
sets the path to the dictionary
Must be called before FnxTTSDtSimpleOpen
Returns 0 for success, -1 if unable to set the path 
*******************************************************************************/
int FnxTTSDtSimpleSetDictionary(char *pPath)
{
	int retval = 0;
	GlobalDTPtr gp = GetGlobalDTPtr();
	char* dpath = NULL;
	
	if(pPath)
	{
		dpath = FNX_CALLOC(MAX_PATH, sizeof(char));
		if(dpath)
		{
			FNX_STRCPY(dpath, pPath);
			gp->pDictPath = dpath;
			return 0;
		}
		else
			return -1;
	}
	else
		return -1;
}
#endif

#if defined(__cplusplus)
}
#endif
