//#include "FnxPlatform.h"
//#include "FnxStdlib.h"
//#include "FnxAllocate.h"
#include "FonixSerialProtocolCasio.h"
#include "SerialProtocolCasio.h"
#include "TTS_SCT.h"

_CommStructT gComm;
CommTPtr gCommPtr;

int CurWordLength;		//numChar;
char *pCurChar;
char **pCurWord;

char *TempInString;	//can we use pCurChar?
char **TempWords;
char TempnumWords;
char TempmaxLength;

int FnxSerialProtocolTargetOpenChannel( int Channel, int CPUspeed, int BaudRate, void *AbortAudioOutCallBack )
{
	int ReloadVal=0;

	gCommPtr = NULL;
	TempWords = NULL;

	if( !CPUspeed )
		goto ERROR;
	if( !BaudRate )
		goto ERROR;
	if( !AbortAudioOutCallBack )
		goto ERROR;

//don't use heap
//	gCommPtr = (CommTPtr)FNX_MALLOC( SIZE_COMMSTRUCTT );
	gCommPtr = &gComm;
	if( !gCommPtr )
		goto ERROR;

	// initialize parameters used by serial interface to keep track of state, etc
	gCommPtr->Channel = Channel;
	gCommPtr->CommandState = IDLE_TTS_STRING_EMPTY;
	gCommPtr->TtsString = NULL;
	gCommPtr->TtsStringLength = 0;
	gCommPtr->TtsVoice = 0;
	gCommPtr->HaltTts = FALSE;

	gCommPtr->RecogWords = NULL;
	gCommPtr->numRecogWords = 0;
	gCommPtr->maxLengthRecogWord = 0;

	gCommPtr->AsrReplayInputStatus = 0;
	gCommPtr->HaltAudioOutCallBack = AbortAudioOutCallBack;

	gCommPtr->TtsLanguage = 0;

	TempWords = NULL;
	TempnumWords = 0;
	TempmaxLength = 0;

	//Call platform specific open function - actually sets up the platform's serial interface
	ReloadVal = FnxSerialProtocolTargetPlatOpenChannel( Channel, CPUspeed, BaudRate );
	if( ReloadVal < 0 )
		goto ERROR;
	return( ReloadVal );

ERROR:
//don't use heap
//	FNX_FREE( gCommPtr );
	gCommPtr = NULL;
	return 1;
}

int FnxSerialProtocolTargetCloseChannel( )
{
	FnxSerialProtocolTargetPlatCloseChannel( gCommPtr->Channel );
	FreeRecogWords( (char**)&gCommPtr->RecogWords, &gCommPtr->numRecogWords, &gCommPtr->maxLengthRecogWord );
	//don't use heap
//	FNX_FREE( gCommPtr->TtsString );
//	FNX_FREE( gCommPtr );
	gCommPtr = NULL;
	return 0;
}

void FnxSerialProtocolTargetSendReady( int ResetStatus )
{
	TransmitOneByte( gCommPtr->Channel, TARGET_READY | (0x0F & ResetStatus ) );	// don't let reset status override the command
}

int  FnxSerialProtocolTargetSendAsrResult( char * pRecognizedWord )
{
#ifdef COMM_INCLUDE_ASR
	char *pCommand, *pDst, *pSrc;
	int CommandLength, WordLength, i, checksum = 0;

	WordLength = FNX_STRLEN(pRecognizedWord);
	CommandLength = WordLength + 3;
	pDst = pCommand = (char *)FNX_MALLOC( CommandLength );
	if( pCommand )
	{
		*pDst = 0x80;
		pDst++;
		*pDst = (char)CommandLength;
		pDst++;
		pSrc = pRecognizedWord;
		for( i = 0; i < WordLength; i++ )
		{
			*pDst = *pSrc;
			checksum += (int)*pSrc;
			pDst++;
			pSrc++;
		}
		*pDst = (char)( checksum & 0x0FF );

		TransmitString( gCommPtr->Channel, (unsigned char *)pCommand, CommandLength );

		FNX_FREE( pCommand );
	}
	else
		return -1;

	return 0;
#else
	return -1;
#endif
}

int  FnxSerialProtocolTargetSendAudioInStatus( int AudioInStatus )
{
	TransmitOneByte( gCommPtr->Channel, AUDIO_IN_STATUS | (0x0F & AudioInStatus ) );	// don't let audio in status override the command
	return 0;
}

int  FnxSerialProtocolTargetSendAudioOutStatus( int AudioOutStatus )
{
	TransmitOneByte( gCommPtr->Channel, AUDIO_OUT_STATUS | (0x0F & AudioOutStatus ) );	// don't let audio in status override the command
	return 0;
}


int FnxSerialProtocolTargetGetState( void )
{
	return gCommPtr->CommandState;
}

void FnxSerialProtocolTargetSetState( int CommandState )
{
	gCommPtr->CommandState = CommandState;
}


int FnxSerialProtocolTargetGetTtsString( char *TtsString, int MaxLength )
{
	if( gCommPtr->TtsStringLength > MaxLength )
		strncpy( TtsString, gCommPtr->TtsString, MaxLength );
	else
		strcpy( TtsString, gCommPtr->TtsString );

	return gCommPtr->TtsStringLength;
}


int FnxSerialProtocolTargetGetTtsVoice( void )
{
	return gCommPtr->TtsVoice;
}

int FnxSerialProtocolTargetGetTtsLanguage( void )
{
	return gCommPtr->TtsLanguage;
}

int FnxSerialProtocolTargetGetAudioAbortState( void )
{
	return gCommPtr->HaltTts;
}


char **FnxSerialProtocolTargetGetAsrWords( int * NumRecogWords, int * MaxRecogWordLength )
{
#ifdef COMM_INCLUDE_ASR
	char **Dst, **TempDst, **Src;
	char **Words;
	int j, numWords = gCommPtr->numRecogWords;

	Dst = TempDst = (char**)FNX_MALLOC( numWords * sizeof(char*) );
	if( Dst )
	{
		Src = gCommPtr->RecogWords;
		for( j=0; j < numWords; j++ )
		{
			*TempDst = (char*)FNX_MALLOC( strlen( *Src ) + 1 );
			strcpy(*TempDst, *Src );
			TempDst++;
			Src++;
		}
		*NumRecogWords = numWords;
		*MaxRecogWordLength = gCommPtr->maxLengthRecogWord;
	}
	return Dst;
#else
	return NULL;
#endif
}


void FnxSerialProtocolTargetFreeAsrWords( char ** pRecogWords, int *NumRecogWords, int *MaxRecogWordLength )
{
#ifdef COMM_INCLUDE_ASR
	FreeRecogWords( pRecogWords, NumRecogWords, MaxRecogWordLength );
#endif
}

int FnxSerialProtocolTargetGetReplayInputStatus( void )
{
#ifdef COMM_INCLUDE_ASR
	return gCommPtr->AsrReplayInputStatus;
#else
	return -1;
#endif
}

char **CreateRecogWords( int numWords, int maxLength )
{
#ifdef COMM_INCLUDE_ASR
	char **Temp, **Prev;
	char **Words;
	int j;

	Temp = Words = (char**)FNX_MALLOC( numWords * sizeof(char*) );
	if( Words )
	{
//		for( j=0; j < numWords; j++ )
//		{
//			*Temp = (char*)FNX_MALLOC( maxLength );
//			Temp++;
//		}
		*Temp = (char*)FNX_MALLOC( maxLength * numWords );
		Prev = Temp;
		Temp++;
		for( j=1; j < numWords; j++ )
		{
			*Temp = *Prev + maxLength;
			Prev = Temp;
			Temp ++;
		}
	}
	return Words;
#else
	return NULL;
#endif
}

void FreeRecogWords( char **Words, int *numWords, int *maxLength )
{
#ifdef COMM_INCLUDE_ASR
	char **Temp;
	int j;
	int numTemp = *numWords;

	if( *Words )
	{
		Temp = Words;
//		for( j=0; j<numTemp; j++ )
//		{
//			FNX_FREE( *Temp );
//			Temp++;
//		}
		FNX_FREE( *Words );
		FNX_FREE( Words );
		*Words = NULL;
		*numWords = 0;
		*maxLength = 0;
	}
#endif
}

void CopyRecogWords( )
{
#ifdef COMM_INCLUDE_ASR
	char **pWord;
	char *pString;
	int j;

	//free previous recog words
	if( gCommPtr->RecogWords )
	{
		FreeRecogWords( (char**)&gCommPtr->RecogWords, &gCommPtr->numRecogWords, &gCommPtr->maxLengthRecogWord );
	}
	//move the pointers from temp point to the structure
	gCommPtr->numRecogWords = (int)TempnumWords;
	TempnumWords = 0x0;
	gCommPtr->maxLengthRecogWord = (int)TempmaxLength;
	TempmaxLength = 0x0;
	gCommPtr->RecogWords = TempWords;
	TempWords = NULL;
#endif
}
