#include "FonixSerialProtocolCasio.h"
#include "SerialProtocolCasio.h"
#include	"common.h"
//#include	"SHIO.h"
#include "UARTio.h"
#include "UARTdrv.h"
#include "TTS_SCT.h"

SRL_STAT	uart;

extern void initRxIsr( void );

void TransmitOneByte( int Channel, unsigned char Data )
{
	UARTSrl_TxByte( Data );
}

void TransmitString( int Channel, unsigned char *pData, int StringLen )
{
	int i;
	unsigned char *temp = pData;

	for( i = 0; i < StringLen; i++ )
		UARTSrl_TxDirect( *temp++ );

}


int FnxSerialProtocolTargetPlatOpenChannel( int Channel, int CPUspeed, int BaudRate )
{
	int retVal;

	initRxIsr();

	uart.port = Channel;	// set channel/port - not used by Casio
	switch( BaudRate )		//set baud rate
	{
		case 300:
			uart.speed =IMB_SRL_300BPS ;
			break;
		case 600:
			uart.speed = IMB_SRL_600BPS;
			break;
		case 1200:
			uart.speed = IMB_SRL_1200BPS;
			break;
		case 2400:
			uart.speed = IMB_SRL_2400BPS;
			break;
		case 4800:
			uart.speed = IMB_SRL_4800BPS;
			break;
		case 9600:
			uart.speed = IMB_SRL_9600BPS;
			break;
		case 19200:
			uart.speed = IMB_SRL_19200BPS;
			break;
		case 38400:
			uart.speed = IMB_SRL_38400BPS;
			break;
		case 57600:
			uart.speed = IMB_SRL_57600BPS;
			break;
		case 115200:
			uart.speed = IMB_SRL_115200BPS;
			break;
	}

	uart.parit = IMB_SRL_NONE;				// set parity type
	uart.datab = IMB_SRL_8DATA;				// set number of bits transmited in on byte 
	uart.stopb = IMB_SRL_1STOP;				// set the number of stop bits
	uart.fctrl = IMB_SRL_NOFLOW;			// FlowControl(no suport)
	
	SERIAL_INITIALIZE( );					// intialize hardware
	retVal = (int)UARTSrl_Open(&uart);		// open serial port
	if( retVal )
		retVal = -1;

	return(retVal);
}

int FnxSerialProtocolTargetPlatCloseChannel(int Channel )
{
	int retVal;

	retVal = UARTSrl_Close(IMW_SRL_NORMAL);
	if( retVal )
		retVal = -1;

	return(retVal);
}
