#include "FonixSerialProtocolCasio.h"
#include "SerialProtocolCasio.h"
#include "TTS_SCT.h"
#ifdef INCLUDE_CUSTOM_COMMANDS
#include "CustomCommands.h"
#endif

extern CommTPtr gCommPtr;
extern int CurWordLength;		//numChar;
extern char *pCurChar;
extern char **pCurWord;

extern char *TempInString;	//can we use pCurChar?
extern char **TempWords;
extern char TempnumWords;
extern char TempmaxLength;

#define MAX_STRING_LENGTH 512
static int Command;
static int ByteCount;
static int CheckSum;
static int BytesToReceive;
static int StartStopFlag;
char TtsString[MAX_STRING_LENGTH];

void initRxIsr( void )
{
	ByteCount = 0;
	CheckSum = 0;
	BytesToReceive = 0;
	StartStopFlag = 0;
}

//************************************************************
//		Receive Serial Interface ISR	61  SCI #1 RxD Buffer Full
//************************************************************
//void RX_ISR(  )
//void FnxSerialProtocolReceiveByte_ISR( )
void FnxSerialProtocolTargetReceiveByte( unsigned char byte )
{
	unsigned char RXbyte = byte;
	unsigned char OutByte;
	int i;

	ByteCount ++;
	if (ByteCount == 1)		// determine which command is sent
	{
		Command = RXbyte >> 4;
	}
	switch (Command)
	{
		case 1:	//Text Transfer command
		{
			//BytesToReceive = 0 when ByteCount <= 2 will fall through
			if( (ByteCount < BytesToReceive) && ( ByteCount > 3 ) )	// received data
			{
				if( TempInString != NULL )
				{
					CheckSum += RXbyte;
					if((ByteCount - 4 ) < MAX_STRING_LENGTH )	// if there is space in the buffer (leave a space to NULL terminate the string)
					{
						*TempInString = RXbyte;	// put RXbyte into receive buffer
						TempInString++;
					}
				}
			}
			else if( ByteCount == 3 )	//received the length of ASCI string that will be sent
			{
				BytesToReceive = BytesToReceive | RXbyte;
				gCommPtr->TtsStringLength = BytesToReceive - 4;
				// don't use a heap
//				free( gCommPtr->TtsString );
//				gCommPtr->TtsString = TempInString = (char *)malloc( gCommPtr->TtsStringLength + 1 );
				gCommPtr->TtsString = TempInString = TtsString;
			}
			else if( ByteCount == 2 )	//received the length of ASCI string that will be sent
			{
				BytesToReceive = RXbyte << 8;
			}
			else if( ByteCount == 1 )
			{
				break;
			}
			else	//CheckSum comparison
			{
				if( ( TempInString != NULL ) && ( (unsigned char)CheckSum == RXbyte ) )	//transfer suceeded
				{
					OutByte = 0x11;
					if (gCommPtr->TtsStringLength >0)	//if received a string, set flag to start Caller ID TTS
					{
						*TempInString = '\0';	//NULL terminate the string
						gCommPtr->CommandState = IDLE_TTS_STRING_FULL;
					}
					else
					{
						*TempInString = '\0';
						gCommPtr->CommandState = IDLE_TTS_STRING_EMPTY;
					}
				}
				else	//transfer failed
				{
					OutByte = 0x10;
				}
				
				TransmitOneByte(gCommPtr->Channel, OutByte);
				INITIALIZE_FOR_NEW_COMMAND;
			}
			break;
		}
		case 2:	// TTS Start & Stop commands
		{
			StartStopFlag = RXbyte & 0x01;
			if( !StartStopFlag )	//Start
			{
				if( gCommPtr->CommandState == IDLE_TTS_STRING_FULL )	//Begin TTS command
				{
					gCommPtr->CommandState = BEGIN_TTS;
					gCommPtr->HaltTts = FALSE;
				}
			}
			else	//Stop
			{
				gCommPtr->HaltTts = TRUE;
				if( gCommPtr->HaltAudioOutCallBack )
					gCommPtr->HaltAudioOutCallBack();	//stop the audio output
				if( gCommPtr->TtsString[0] != '\0' )
				{
					gCommPtr->CommandState = IDLE_TTS_STRING_FULL;
				}
				else
					gCommPtr->CommandState = IDLE_TTS_STRING_EMPTY;
			}
			INITIALIZE_FOR_NEW_COMMAND;
			break;
		}
		case 3:	// Target Status commands
		{
			OutByte = 0x30 | gCommPtr->CommandState;
			TransmitOneByte(gCommPtr->Channel, OutByte);
			INITIALIZE_FOR_NEW_COMMAND;
			break;
		}
		case 6:	// TTS Voice Control
		{
			gCommPtr->CommandState = CHANGE_TTS_VOICE;
			gCommPtr->TtsVoice = RXbyte & 0x0F;
			INITIALIZE_FOR_NEW_COMMAND;
			break;
		}
#ifdef COMM_INCLUDE_ASR
		//don't support ASR parts of protocol
		case 9:	// ASR Control
		{
			if (ByteCount < BytesToReceive)
			{
				if ( CurWordLength >= TempmaxLength )
				{
					*pCurChar = 0;	//Null terminate all strings
					pCurWord++;
					pCurChar = *pCurWord;
					CurWordLength = 0;
				}
				*pCurChar++ = RXbyte;	//put rx_data into receive buffer
				CurWordLength++;
				CheckSum += RXbyte;
			}
			else if (ByteCount == 2)
			{
				TempnumWords = RXbyte;
				CheckSum += RXbyte;
			}
			else if (ByteCount == 3)
			{
				TempmaxLength = RXbyte;
				BytesToReceive = TempmaxLength * TempnumWords + 4; //4 bytes from command
				TempWords = CreateRecogWords( (int)TempnumWords, (int)(TempmaxLength+1));
				pCurWord = TempWords;
				pCurChar = *pCurWord;
				CurWordLength = 0;
				CheckSum += RXbyte;
			}
			else if( ByteCount == 1 )
			{
				CheckSum = RXbyte;
				break;
			}
			else				//received checksum(last byte of command)
			{
				if ( (unsigned char)CheckSum == RXbyte ) 
				{
					OutByte = 0x90;
					*pCurChar = 0;	//Null terminate all strings
					CopyRecogWords( );	//transfer data from temporary location to permenant location
					gCommPtr->CommandState = BEGIN_ASR;
				}
				else
				{
					OutByte = 0x91;
				}
				TransmitOneByte( gCommPtr->Channel, OutByte );
				INITIALIZE_FOR_NEW_COMMAND;
			}
			break;
		}
		case 10:
		{
			gCommPtr->AsrReplayInputStatus = (int)(0x01 & RXbyte);
			INITIALIZE_FOR_NEW_COMMAND;
			break;
		}
#endif
		case 11:
		{
			gCommPtr->TtsLanguage = (int)(0x0F & RXbyte);
			gCommPtr->CommandState = CHANGE_TTS_LANG;
			INITIALIZE_FOR_NEW_COMMAND;
			break;
		}
#ifdef INCLUDE_CUSTOM_COMMANDS
		case 15:	// Customer Request command
		{
			OutByte = RXbyte;
#ifdef CUSTOM_COMMAND_ZERO
			if( RXbyte == 0xF0 )
			{
				OutByte = CustomCommandZero();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_ONE
			if( RXbyte == 0xF1 )
			{
				OutByte = CustomCommandOne();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_TWO
			if( RXbyte == 0xF2 )
			{
				OutByte = CustomCommandTwo();
			}
			else
#endif
#ifdef CUSTOM_COMMAND_THREE
			if( RXbyte == 0xF3 )
			{
				OutByte = CustomCommandThree();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_FOUR
			if( RXbyte == 0xF4 )
			{
				OutByte = CustomCommandFour();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_FIVE
			if( RXbyte == 0xF5 )
			{
				OutByte = CustomCommandFive();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_SIX
			if( RXbyte == 0xF6 )
			{
				OutByte = CustomCommandSix();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_SEVEN
			if( RXbyte == 0xF7 )
			{
				OutByte = CustomCommandSeven();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_EIGHT
			if( RXbyte == 0xF8 )
			{
				OutByte = CustomCommandEight();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_NINE
			if( RXbyte == 0xF9 )
			{
				OutByte = CustomCommandNine();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_TEN
			if( RXbyte == 0xFA )
			{
				OutByte = CustomCommandTen();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_ELEVEN
			if( RXbyte == 0xFB )
			{
				OutByte = CustomCommandEleven();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_TWELVE
			if( RXbyte == 0xFC )
			{
				OutByte = CustomCommandTwelve();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_THIRTEEN
			if( RXbyte == 0xFD )
			{
				OutByte = CustomCommandThirteen();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_FOURTEEN
			if( RXbyte == 0xFE )
			{
				OutByte = CustomCommandFourteen();
			}
			else 
#endif
#ifdef CUSTOM_COMMAND_FIFTEEN
			if( RXbyte == 0xFF )
			{
				OutByte = CustomCommandFifteen();
			}
			else
#endif
				OutByte = 0xAA;

			TransmitOneByte(gCommPtr->Channel, OutByte);
			INITIALIZE_FOR_NEW_COMMAND;
			break;
		}
#endif
		default:			//a unimplemented command received or an error occured 
		{
			INITIALIZE_FOR_NEW_COMMAND;
			break;
		}
	}
}

