/*C_HEADER_FILE****************************************************************
FILE			:	Unicode2Pinyin.c
DESC			:	This program opens a text file with Chinese characters of poly sounds
TABS			:	4
OWNER			:	Fonix
DATE CREATED	:	7/11/2005 by Chuck Liu	

(C) Copyright 2005 All rights reserved.
This is an unpublished work, and is confidential and proprietary: 
technology and information of fonix corporation.  No part of this
code may be reproduced, used or disclosed without written consent of 
fonix corporation in each and every instance.

  $Date:  $
  $Revision:  $

*END_HEADER*******************************************************************/
#define BOOL int
#define BYTE unsigned char
#define WORD unsigned int
#define FALSE 0
#define TRUE 1
#define NULL 0

#include <stdlib.h>
#include <wchar.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

struct wordNode{
		wchar_t wordContent[15]; /* Currently allows for 15 characters in a word */
        struct wordNode *nextWordPtr;
} *wordNodePtr, *currentWordNodePtr;

struct soundNode{
        BYTE pinyinWithTone[10];
        struct wordNode *wordListPtr;
        struct soundNode *nextSoundPtr;
} *soundNodePtr, *currentSoundNodePtr;

struct charNode{
/*        int charCodePoint; Any need for this? */
		wchar_t theChar;
        struct soundNode *charToSoundPtr;
};

int    numberOfChars = -1, numberOfSounds = -1, numberOfWords = -1;
struct charNode polyPhoneTable[200]; /*Currently covering 180 characters */

/****************************************************************************/

// 406 pronunciations x 5 tones  + 1? = 2031
static char * PinyinTableWithTones[] =
{
"?", //  should be ("NONE") in the table of the C source file.
"a1", "a2", "a3", "a4", "a5", "ai1", "ai2", "ai3", "ai4", "ai5",
"an1", "an2", "an3", "an4", "an5", "ang1", "ang2", "ang3", "ang4", "ang5",
"ao1", "ao2", "ao3", "ao4", "ao5", "ba1", "ba2", "ba3", "ba4", "ba5",
"bai1", "bai2", "bai3", "bai4", "bai5", "ban1", "ban2", "ban3", "ban4", "ban5",
"bang1", "bang2", "bang3", "bang4", "bang5", "bao1", "bao2", "bao3", "bao4", "bao5",
"bei1", "bei2", "bei3", "bei4", "bei5", "ben1", "ben2", "ben3", "ben4", "ben5",
"beng1", "beng2", "beng3", "beng4", "beng5", "bi1", "bi2", "bi3", "bi4", "bi5",
"bian1", "bian2", "bian3", "bian4", "bian5", "biao1", "biao2", "biao3", "biao4", "biao5",
"bie1", "bie2", "bie3", "bie4", "bie5", "bin1", "bin2", "bin3", "bin4", "bin5",
"bing1", "bing2", "bing3", "bing4", "bing5", "bo1", "bo2", "bo3", "bo4", "bo5",
"bu1", "bu2", "bu3", "bu4", "bu5", "ca1", "ca2", "ca3", "ca4", "ca5",
"cai1", "cai2", "cai3", "cai4", "cai5", "can1", "can2", "can3", "can4", "can5",
"cang1", "cang2", "cang3", "cang4", "cang5", "cao1", "cao2", "cao3", "cao4", "cao5",
"ce1", "ce2", "ce3", "ce4", "ce5", "cen1", "cen2", "cen3", "cen4", "cen5",
"ceng1", "ceng2", "ceng3", "ceng4", "ceng5", "cha1", "cha2", "cha3", "cha4", "cha5",
"chai1", "chai2", "chai3", "chai4", "chai5", "chan1", "chan2", "chan3", "chan4", "chan5",
"chang1", "chang2", "chang3", "chang4", "chang5", "chao1", "chao2", "chao3", "chao4", "chao5",
"che1", "che2", "che3", "che4", "che5", "chen1", "chen2", "chen3", "chen4", "chen5",
"cheng1", "cheng2", "cheng3", "cheng4", "cheng5", "chi1", "chi2", "chi3", "chi4", "chi5",
"chong1", "chong2", "chong3", "chong4", "chong5", "chou1", "chou2", "chou3", "chou4", "chou5",
"chu1", "chu2", "chu3", "chu4", "chu5", "chuai1", "chuai2", "chuai3", "chuai4", "chuai5",
"chuan1", "chuan2", "chuan3", "chuan4", "chuan5", "chuang1", "chuang2", "chuang3", "chuang4", "chuang5",
"chui1", "chui2", "chui3", "chui4", "chui5", "chun1", "chun2", "chun3", "chun4", "chun5",
"chuo1", "chuo2", "chuo3", "chuo4", "chuo5", "ci1", "ci2", "ci3", "ci4", "ci5",
"cong1", "cong2", "cong3", "cong4", "cong5", "cou1", "cou2", "cou3", "cou4", "cou5",
"cu1", "cu2", "cu3", "cu4", "cu5", "cuan1", "cuan2", "cuan3", "cuan4", "cuan5",
"cui1", "cui2", "cui3", "cui4", "cui5", "cun1", "cun2", "cun3", "cun4", "cun5",
"cuo1", "cuo2", "cuo3", "cuo4", "cuo5", "da1", "da2", "da3", "da4", "da5",
"dai1", "dai2", "dai3", "dai4", "dai5", "dan1", "dan2", "dan3", "dan4", "dan5",
"dang1", "dang2", "dang3", "dang4", "dang5", "dao1", "dao2", "dao3", "dao4", "dao5",
"de1", "de2", "de3", "de4", "de5", "deng1", "deng2", "deng3", "deng4", "deng5",
"di1", "di2", "di3", "di4", "di5", "dia1", "dia2", "dia3", "dia4", "dia5",
"dian1", "dian2", "dian3", "dian4", "dian5", "diao1", "diao2", "diao3", "diao4", "diao5",
"die1", "die2", "die3", "die4", "die5", "ding1", "ding2", "ding3", "ding4", "ding5",
"diu1", "diu2", "diu3", "diu4", "diu5", "dong1", "dong2", "dong3", "dong4", "dong5",
"dou1", "dou2", "dou3", "dou4", "dou5", "du1", "du2", "du3", "du4", "du5",
"duan1", "duan2", "duan3", "duan4", "duan5", "dui1", "dui2", "dui3", "dui4", "dui5",
"dun1", "dun2", "dun3", "dun4", "dun5", "duo1", "duo2", "duo3", "duo4", "duo5",
"e1", "e2", "e3", "e4", "e5", "ei1", "ei2", "ei3", "ei4", "ei5",
"en1", "en2", "en3", "en4", "en5", "er1", "er2", "er3", "er4", "er5",
"fa1", "fa2", "fa3", "fa4", "fa5", "fan1", "fan2", "fan3", "fan4", "fan5",
"fang1", "fang2", "fang3", "fang4", "fang5", "fei1", "fei2", "fei3", "fei4", "fei5",
"fen1", "fen2", "fen3", "fen4", "fen5", "feng1", "feng2", "feng3", "feng4", "feng5",
"fo1", "fo2", "fo3", "fo4", "fo5", "fou1", "fou2", "fou3", "fou4", "fou5",
"fu1", "fu2", "fu3", "fu4", "fu5", "ga1", "ga2", "ga3", "ga4", "ga5",
"gai1", "gai2", "gai3", "gai4", "gai5", "gan1", "gan2", "gan3", "gan4", "gan5",
"gang1", "gang2", "gang3", "gang4", "gang5", "gao1", "gao2", "gao3", "gao4", "gao5",
"ge1", "ge2", "ge3", "ge4", "ge5", "gei1", "gei2", "gei3", "gei4", "gei5",
"gen1", "gen2", "gen3", "gen4", "gen5", "geng1", "geng2", "geng3", "geng4", "geng5",
"gong1", "gong2", "gong3", "gong4", "gong5", "gou1", "gou2", "gou3", "gou4", "gou5",
"gu1", "gu2", "gu3", "gu4", "gu5", "gua1", "gua2", "gua3", "gua4", "gua5",
"guai1", "guai2", "guai3", "guai4", "guai5", "guan1", "guan2", "guan3", "guan4", "guan5",
"guang1", "guang2", "guang3", "guang4", "guang5", "gui1", "gui2", "gui3", "gui4", "gui5",
"gun1", "gun2", "gun3", "gun4", "gun5", "guo1", "guo2", "guo3", "guo4", "guo5",
"ha1", "ha2", "ha3", "ha4", "ha5", "hai1", "hai2", "hai3", "hai4", "hai5",
"han1", "han2", "han3", "han4", "han5", "hang1", "hang2", "hang3", "hang4", "hang5",
"hao1", "hao2", "hao3", "hao4", "hao5", "he1", "he2", "he3", "he4", "he5",
"hei1", "hei2", "hei3", "hei4", "hei5", "hen1", "hen2", "hen3", "hen4", "hen5",
"heng1", "heng2", "heng3", "heng4", "heng5", "hong1", "hong2", "hong3", "hong4", "hong5",
"hou1", "hou2", "hou3", "hou4", "hou5", "hu1", "hu2", "hu3", "hu4", "hu5",
"hua1", "hua2", "hua3", "hua4", "hua5", "huai1", "huai2", "huai3", "huai4", "huai5",
"huan1", "huan2", "huan3", "huan4", "huan5", "huang1", "huang2", "huang3", "huang4", "huang5",
"hui1", "hui2", "hui3", "hui4", "hui5", "hun1", "hun2", "hun3", "hun4", "hun5",
"huo1", "huo2", "huo3", "huo4", "huo5", "ji1", "ji2", "ji3", "ji4", "ji5",
"jia1", "jia2", "jia3", "jia4", "jia5", "jian1", "jian2", "jian3", "jian4", "jian5",
"jiang1", "jiang2", "jiang3", "jiang4", "jiang5", "jiao1", "jiao2", "jiao3", "jiao4", "jiao5",
"jie1", "jie2", "jie3", "jie4", "jie5", "jin1", "jin2", "jin3", "jin4", "jin5",
"jing1", "jing2", "jing3", "jing4", "jing5", "jiong1", "jiong2", "jiong3", "jiong4", "jiong5",
"jiu1", "jiu2", "jiu3", "jiu4", "jiu5", "ju1", "ju2", "ju3", "ju4", "ju5",
"juan1", "juan2", "juan3", "juan4", "juan5", "jue1", "jue2", "jue3", "jue4", "jue5",
"jun2", "jun1", "jun3", "jun4", "jun5", "ka1", "ka2", "ka3", "ka4", "ka5",
"kai1", "kai2", "kai3", "kai4", "kai5", "kan1", "kan2", "kan3", "kan4", "kan5",
"kang1", "kang2", "kang3", "kang4", "kang5", "kao1", "kao2", "kao3", "kao4", "kao5",
"ke1", "ke2", "ke3", "ke4", "ke5", "ken1", "ken2", "ken3", "ken4", "ken5",
"keng1", "keng2", "keng3", "keng4", "keng5", "kong1", "kong2", "kong3", "kong4", "kong5",
"kou1", "kou2", "kou3", "kou4", "kou5", "ku1", "ku2", "ku3", "ku4", "ku5",
"kua1", "kua2", "kua3", "kua4", "kua5", "kuai1", "kuai2", "kuai3", "kuai4", "kuai5",
"kuan1", "kuan2", "kuan3", "kuan4", "kuan5", "kuang1", "kuang2", "kuang3", "kuang4", "kuang5",
"kui1", "kui2", "kui3", "kui4", "kui5", "kun1", "kun2", "kun3", "kun4", "kun5",
"kuo1", "kuo2", "kuo3", "kuo4", "kuo5", "la1", "la2", "la3", "la4", "la5",
"lai1", "lai2", "lai3", "lai4", "lai5", "lan1", "lan2", "lan3", "lan4", "lan5",
"lang1", "lang2", "lang3", "lang4", "lang5", "lao1", "lao2", "lao3", "lao4", "lao5",
"le1", "le2", "le3", "le4", "le5", "lei1", "lei2", "lei3", "lei4", "lei5",
"leng1", "leng2", "leng3", "leng4", "leng5", "li1", "li2", "li3", "li4", "li5",
"lia1", "lia2", "lia3", "lia4", "lia5", "lian1", "lian2", "lian3", "lian4", "lian5",
"liang1", "liang2", "liang3", "liang4", "liang5", "liao1", "liao2", "liao3", "liao4", "liao5",
"lie1", "lie2", "lie3", "lie4", "lie5", "lin1", "lin2", "lin3", "lin4", "lin5",
"ling1", "ling2", "ling3", "ling4", "ling5", "liu1", "liu2", "liu3", "liu4", "liu5",
"long1", "long2", "long3", "long4", "long5", "lou1", "lou2", "lou3", "lou4", "lou5",
"lu1", "lu2", "lu3", "lu4", "lu5", "luan1", "luan2", "luan3", "luan4", "luan5",
"lue1", "lue2", "lue3", "lue4", "lue5", "lun1", "lun2", "lun3", "lun4", "lun5",
"luo1", "luo2", "luo3", "luo4", "luo5", "lv1", "lv2", "lv3", "lv4", "lv5",
"m1", "m2", "m3", "m4", "m5", "ma1", "ma2", "ma3", "ma4", "ma5",
"mai1", "mai2", "mai3", "mai4", "mai5", "man1", "man2", "man3", "man4", "man5",
"mang1", "mang2", "mang3", "mang4", "mang5", "mao1", "mao2", "mao3", "mao4", "mao5",
"me1", "me2", "me3", "me4", "me5", "mei1", "mei2", "mei3", "mei4", "mei5",
"men1", "men2", "men3", "men4", "men5", "meng1", "meng2", "meng3", "meng4", "meng5",
"mi1", "mi2", "mi3", "mi4", "mi5", "mian1", "mian2", "mian3", "mian4", "mian5",
"miao1", "miao2", "miao3", "miao4", "miao5", "mie1", "mie2", "mie3", "mie4", "mie5",
"min1", "min2", "min3", "min4", "min5", "ming1", "ming2", "ming3", "ming4", "ming5",
"miu1", "miu2", "miu3", "miu4", "miu5", "mo1", "mo2", "mo3", "mo4", "mo5",
"mou1", "mou2", "mou3", "mou4", "mou5", "mu1", "mu2", "mu3", "mu4", "mu5",
"n1", "n2", "n3", "n4", "n5", "na1", "na2", "na3", "na4", "na5",
"nai1", "nai2", "nai3", "nai4", "nai5", "nan1", "nan2", "nan3", "nan4", "nan5",
"nang1", "nang2", "nang3", "nang4", "nang5", "nao1", "nao2", "nao3", "nao4", "nao5",
"ne1", "ne2", "ne3", "ne4", "ne5", "nei1", "nei2", "nei3", "nei4", "nei5",
"nen1", "nen2", "nen3", "nen4", "nen5", "neng1", "neng2", "neng3", "neng4", "neng5",
"ng1", "ng2", "ng3", "ng4", "ng5", "ni1", "ni2", "ni3", "ni4", "ni5",
"nian1", "nian2", "nian3", "nian4", "nian5", "niang1", "niang2", "niang3", "niang4", "niang5",
"niao1", "niao2", "niao3", "niao4", "niao5", "nie1", "nie2", "nie3", "nie4", "nie5",
"nin1", "nin2", "nin3", "nin4", "nin5", "ning1", "ning2", "ning3", "ning4", "ning5",
"niu1", "niu2", "niu3", "niu4", "niu5", "nong1", "nong2", "nong3", "nong4", "nong5",
"nou1", "nou2", "nou3", "nou4", "nou5", "nu1", "nu2", "nu3", "nu4", "nu5",
"nuan1", "nuan2", "nuan3", "nuan4", "nuan5", "nue1", "nue2", "nue3", "nue4", "nue5",
"nuo1", "nuo2", "nuo3", "nuo4", "nuo5", "nv1", "nv2", "nv3", "nv4", "nv5",
"o1", "o2", "o3", "o4", "o5", "ou1", "ou2", "ou3", "ou4", "ou5",
"pa1", "pa2", "pa3", "pa4", "pa5", "pai1", "pai2", "pai3", "pai4", "pai5",
"pan1", "pan2", "pan3", "pan4", "pan5", "pang1", "pang2", "pang3", "pang4", "pang5",
"pao1", "pao2", "pao3", "pao4", "pao5", "pei1", "pei2", "pei3", "pei4", "pei5",
"pen1", "pen2", "pen3", "pen4", "pen5", "peng1", "peng2", "peng3", "peng4", "peng5",
"pi1", "pi2", "pi3", "pi4", "pi5", "pian1", "pian2", "pian3", "pian4", "pian5",
"piao1", "piao2", "piao3", "piao4", "piao5", "pie1", "pie2", "pie3", "pie4", "pie5",
"pin1", "pin2", "pin3", "pin4", "pin5", "ping1", "ping2", "ping3", "ping4", "ping5",
"po1", "po2", "po3", "po4", "po5", "pou1", "pou2", "pou3", "pou4", "pou5",
"pu1", "pu2", "pu3", "pu4", "pu5", "qi1", "qi2", "qi3", "qi4", "qi5",
"qia1", "qia2", "qia3", "qia4", "qia5", "qian1", "qian2", "qian3", "qian4", "qian5",
"qiang1", "qiang2", "qiang3", "qiang4", "qiang5", "qiao1", "qiao2", "qiao3", "qiao4", "qiao5",
"qie1", "qie2", "qie3", "qie4", "qie5", "qin1", "qin2", "qin3", "qin4", "qin5",
"qing1", "qing2", "qing3", "qing4", "qing5", "qiong1", "qiong2", "qiong3", "qiong4", "qiong5",
"qiu1", "qiu2", "qiu3", "qiu4", "qiu5", "qu1", "qu2", "qu3", "qu4", "qu5",
"quan1", "quan2", "quan3", "quan4", "quan5", "que1", "que2", "que3", "que4", "que5",
"qun1", "qun2", "qun3", "qun4", "qun5", "ran1", "ran2", "ran3", "ran4", "ran5",
"rang1", "rang2", "rang3", "rang4", "rang5", "rao1", "rao2", "rao3", "rao4", "rao5",
"re1", "re2", "re3", "re4", "re5", "ren1", "ren2", "ren3", "ren4", "ren5",
"reng1", "reng2", "reng3", "reng4", "reng5", "ri1", "ri2", "ri3", "ri4", "ri5",
"rong1", "rong2", "rong3", "rong4", "rong5", "rou1", "rou2", "rou3", "rou4", "rou5",
"ru1", "ru2", "ru3", "ru4", "ru5", "ruan1", "ruan2", "ruan3", "ruan4", "ruan5",
"rui1", "rui2", "rui3", "rui4", "rui5", "run1", "run2", "run3", "run4", "run5",
"ruo1", "ruo2", "ruo3", "ruo4", "ruo5", "sa1", "sa2", "sa3", "sa4", "sa5",
"sai1", "sai2", "sai3", "sai4", "sai5", "san1", "san2", "san3", "san4", "san5",
"sang1", "sang2", "sang3", "sang4", "sang5", "sao1", "sao2", "sao3", "sao4", "sao5",
"se1", "se2", "se3", "se4", "se5", "sen1", "sen2", "sen3", "sen4", "sen5",
"seng1", "seng2", "seng3", "seng4", "seng5", "sha1", "sha2", "sha3", "sha4", "sha5",
"shai1", "shai2", "shai3", "shai4", "shai5", "shan1", "shan2", "shan3", "shan4", "shan5",
"shang1", "shang2", "shang3", "shang4", "shang5", "shao1", "shao2", "shao3", "shao4", "shao5",
"she1", "she2", "she3", "she4", "she5", "shei1", "shei2", "shei3", "shei4", "shei5",
"shen1", "shen2", "shen3", "shen4", "shen5", "sheng1", "sheng2", "sheng3", "sheng4", "sheng5",
"shi1", "shi2", "shi3", "shi4", "shi5", "shou1", "shou2", "shou3", "shou4", "shou5",
"shu1", "shu2", "shu3", "shu4", "shu5", "shua1", "shua2", "shua3", "shua4", "shua5",
"shuai1", "shuai2", "shuai3", "shuai4", "shuai5", "shuan1", "shuan2", "shuan3", "shuan4", "shuan5",
"shuang1", "shuang2", "shuang3", "shuang4", "shuang5", "shui1", "shui2", "shui3", "shui4", "shui5",
"shun1", "shun2", "shun3", "shun4", "shun5", "shuo1", "shuo2", "shuo3", "shuo4", "shuo5",
"si1", "si2", "si3", "si4", "si5", "song1", "song2", "song3", "song4", "song5",
"sou1", "sou2", "sou3", "sou4", "sou5", "su1", "su2", "su3", "su4", "su5",
"suan1", "suan2", "suan3", "suan4", "suan5", "sui1", "sui2", "sui3", "sui4", "sui5",
"sun1", "sun2", "sun3", "sun4", "sun5", "suo1", "suo2", "suo3", "suo4", "suo5",
"ta1", "ta2", "ta3", "ta4", "ta5", "tai1", "tai2", "tai3", "tai4", "tai5",
"tan1", "tan2", "tan3", "tan4", "tan5", "tang1", "tang2", "tang3", "tang4", "tang5",
"tao1", "tao2", "tao3", "tao4", "tao5", "te1", "te2", "te3", "te4", "te5",
"tei1", "tei2", "tei3", "tei4", "tei5", "teng1", "teng2", "teng3", "teng4", "teng5",
"ti1", "ti2", "ti3", "ti4", "ti5", "tian1", "tian2", "tian3", "tian4", "tian5",
"tiao1", "tiao2", "tiao3", "tiao4", "tiao5", "tie1", "tie2", "tie3", "tie4", "tie5",
"ting1", "ting2", "ting3", "ting4", "ting5", "tong1", "tong2", "tong3", "tong4", "tong5",
"tou1", "tou2", "tou3", "tou4", "tou5", "tu1", "tu2", "tu3", "tu4", "tu5",
"tuan1", "tuan2", "tuan3", "tuan4", "tuan5", "tui1", "tui2", "tui3", "tui4", "tui5",
"tun1", "tun2", "tun3", "tun4", "tun5", "tuo1", "tuo2", "tuo3", "tuo4", "tuo5",
"wa1", "wa2", "wa3", "wa4", "wa5", "wai1", "wai2", "wai3", "wai4", "wai5",
"wan1", "wan2", "wan3", "wan4", "wan5", "wang1", "wang2", "wang3", "wang4", "wang5",
"wei1", "wei2", "wei3", "wei4", "wei5", "wen1", "wen2", "wen3", "wen4", "wen5",
"weng1", "weng2", "weng3", "weng4", "weng5", "wo1", "wo2", "wo3", "wo4", "wo5",
"wu1", "wu2", "wu3", "wu4", "wu5", "xi1", "xi2", "xi3", "xi4", "xi5",
"xia1", "xia2", "xia3", "xia4", "xia5", "xian1", "xian2", "xian3", "xian4", "xian5",
"xiang1", "xiang2", "xiang3", "xiang4", "xiang5", "xiao1", "xiao2", "xiao3", "xiao4", "xiao5",
"xie1", "xie2", "xie3", "xie4", "xie5", "xin1", "xin2", "xin3", "xin4", "xin5",
"xing1", "xing2", "xing3", "xing4", "xing5", "xiong1", "xiong2", "xiong3", "xiong4", "xiong5",
"xiu1", "xiu2", "xiu3", "xiu4", "xiu5", "xu1", "xu2", "xu3", "xu4", "xu5",
"xuan1", "xuan2", "xuan3", "xuan4", "xuan5", "xue1", "xue2", "xue3", "xue4", "xue5",
"xun1", "xun2", "xun3", "xun4", "xun5", "ya1", "ya2", "ya3", "ya4", "ya5",
"yan1", "yan2", "yan3", "yan4", "yan5", "yang1", "yang2", "yang3", "yang4", "yang5",
"yao1", "yao2", "yao3", "yao4", "yao5", "ye1", "ye2", "ye3", "ye4", "ye5",
"yi1", "yi2", "yi3", "yi4", "yi5", "yin1", "yin2", "yin3", "yin4", "yin5",
"ying1", "ying2", "ying3", "ying4", "ying5", "yo1", "yo2", "yo3", "yo4", "yo5",
"yong1", "yong2", "yong3", "yong4", "yong5", "you1", "you2", "you3", "you4", "you5",
"yu1", "yu2", "yu3", "yu4", "yu5", "yuan1", "yuan2", "yuan3", "yuan4", "yuan5",
"yue1", "yue2", "yue3", "yue4", "yue5", "yun1", "yun2", "yun3", "yun4", "yun5",
"za1", "za2", "za3", "za4", "za5", "zai1", "zai2", "zai3", "zai4", "zai5",
"zan1", "zan2", "zan3", "zan4", "zan5", "zang1", "zang2", "zang3", "zang4", "zang5",
"zao1", "zao2", "zao3", "zao4", "zao5", "ze1", "ze2", "ze3", "ze4", "ze5",
"zei1", "zei2", "zei3", "zei4", "zei5", "zen1", "zen2", "zen3", "zen4", "zen5",
"zeng1", "zeng2", "zeng3", "zeng4", "zeng5", "zha1", "zha2", "zha3", "zha4", "zha5",
"zhai1", "zhai2", "zhai3", "zhai4", "zhai5", "zhan1", "zhan2", "zhan3", "zhan4", "zhan5",
"zhang1", "zhang2", "zhang3", "zhang4", "zhang5", "zhao1", "zhao2", "zhao3", "zhao4", "zhao5",
"zhe1", "zhe2", "zhe3", "zhe4", "zhe5", "zhen1", "zhen2", "zhen3", "zhen4", "zhen5",
"zheng1", "zheng2", "zheng3", "zheng4", "zheng5", "zhi1", "zhi2", "zhi3", "zhi4", "zhi5",
"zhong1", "zhong2", "zhong3", "zhong4", "zhong5", "zhou1", "zhou2", "zhou3", "zhou4", "zhou5",
"zhu1", "zhu2", "zhu3", "zhu4", "zhu5", "zhua1", "zhua2", "zhua3", "zhua4", "zhua5",
"zhuai1", "zhuai2", "zhuai3", "zhuai4", "zhuai5", "zhuan1", "zhuan2", "zhuan3", "zhuan4", "zhuan5",
"zhuang1", "zhuang2", "zhuang3", "zhuang4", "zhuang5", "zhui1", "zhui2", "zhui3", "zhui4", "zhui5",
"zhun1", "zhun2", "zhun3", "zhun4", "zhun5", "zhuo1", "zhuo2", "zhuo3", "zhuo4", "zhuo5",
"zi1", "zi2", "zi3", "zi4", "zi5", "zong1", "zong2", "zong3", "zong4", "zong5",
"zou1", "zou2", "zou3", "zou4", "zou5", "zu1", "zu2", "zu3", "zu4", "zu5",
"zuan1", "zuan2", "zuan3", "zuan4", "zuan5", "zui1", "zui2", "zui3", "zui4", "zui5",
"zun1", "zun2", "zun3", "zun4", "zun5", "zuo1", "zuo2", "zuo3", "zuo4", "zuo5"
};


static int CJKUnicodeOffsetToPinyinTable[]= {
1801, 336, 728, 1246, 0, 0, 0, 1674, 1914, 1396, 1444, 1714, 636, 104, 4333, 978,
454, 198, 0, 1966, 1273, 1201, 1474, 1474, 1291, 93, 1799, 242, 346, 1521, 182, 341,
0, 853, 341, 1828, 853, 1782, 94, 3901, 533, 681, 474, 1776, 1262, 4441, 638, 661,
426, 519, 214, 158, 867, 1987, 1953, 0, 1672, 286, 4182, 1953, 673, 839, 688, 1218,
442, 1802, 1804, 1033, 1703, 683, 1804, 1922, 3430, 1804, 0, 1936, 1701, 1899, 596, 402,
3324, 1807, 1226, 1176, 1267, 1474, 511, 182, 182, 1803, 1808, 0, 1099, 683, 1248, 1798,
1707, 1721, 1292, 0, 0, 0, 1481, 0, 1473, 636, 0, 641, 0, 1472, 0, 0,
933, 899, 0, 1363, 1706, 0, 1243, 1426, 1027, 0, 0, 0, 0, 0, 456, 899,
526, 0, 899, 867, 1804, 697, 3325, 0, 1832, 1931, 1474, 1474, 399, 204, 1832, 781,
781, 1847, 599, 1247, 1703, 673, 0, 0, 484, 484, 1779, 1731, 1779, 0, 1779, 637,
1632, 1677, 724, 0, 656, 549, 1804, 158, 581, 1018, 0, 1723, 671, 1622, 854, 0,
671, 1799, 1276, 97, 0, 1734, 288, 0, 378, 962, 1337, 1337, 0, 0, 0, 1804,
1472, 1337, 824, 336, 1879, 668, 1241, 197, 26, 1913, 666, 664, 0, 1342, 242, 432,
0, 907, 0, 121, 4493, 1474, 1561, 1914, 444, 1716, 1761, 0, 587, 1627, 1339, 1256,
0, 471, 0, 284, 874, 1803, 0, 0, 1386, 1444, 1802, 1019, 965, 1339, 643, 0,
1788, 666, 1944, 1203, 1697, 1703, 649, 644, 0, 0, 0, 3839, 0, 424, 0, 413,
1941, 1248, 1189, 0, 329, 374, 0, 0, 1738, 724, 1801, 637, 0, 1703, 639, 442,
402, 1751, 669, 1186, 177, 441, 0, 1944, 1826, 633, 624, 1833, 2007, 1847, 1398, 1683,
2712, 0, 1777, 0, 1441, 161, 907, 121, 0, 0, 1683, 1954, 188, 1717, 0, 97,
501, 0, 1077, 1734, 39, 0, 872, 0, 1461, 0, 1524, 61, 1524, 1272, 1201, 1804,
0, 1803, 0, 324, 0, 0, 289, 1954, 104, 1296, 0, 0, 238, 1684, 311, 1954,
2028, 1829, 1786, 1603, 1909, 567, 67, 1657, 1452, 1832, 1804, 432, 2029, 496, 1109, 1627,
1078, 1716, 1297, 1821, 1663, 1256, 0, 708, 0, 1189, 622, 569, 818, 0, 567, 1787,
33, 0, 0, 641, 399, 94, 637, 578, 632, 528, 1302, 1611, 658, 239, 1804, 1473,
1742, 1461, 1656, 718, 1937, 451, 802, 1802, 188, 763, 521, 839, 0, 1474, 0, 1951,
1759, 1829, 11, 0, 1012, 397, 907, 349, 149, 0, 1774, 2991, 1946, 1801, 1362, 0,
1712, 644, 0, 918, 0, 1792, 1926, 134, 1267, 769, 152, 1109, 1117, 669, 1703, 592,
0, 0, 1929, 2029, 0, 1276, 918, 687, 0, 1623, 1462, 1656, 0, 0, 0, 74,
1648, 1833, 1709, 254, 382, 1292, 0, 524, 0, 1704, 704, 1938, 0, 852, 2008, 1269,
839, 1823, 0, 674, 1259, 0, 1187, 1537, 442, 1706, 838, 443, 1226, 48, 1832, 1524,
1712, 1739, 0, 1833, 314, 171, 197, 0, 1783, 843, 839, 0, 1521, 648, 1751, 443,
0, 689, 0, 1167, 649, 79, 1604, 419, 429, 0, 13, 54, 0, 0, 68, 0,
161, 0, 94, 0, 0, 264, 843, 1673, 0, 121, 0, 474, 516, 54, 1608, 1481,
1481, 965, 2798, 1572, 697, 222, 1744, 1197, 1578, 594, 1803, 1246, 1604, 0, 671, 664,
1546, 164, 662, 413, 1937, 748, 694, 1996, 689, 1259, 1077, 907, 1986, 1696, 913, 1526,
872, 629, 0, 1994, 59, 1703, 689, 1034, 113, 648, 1904, 1796, 1937, 0, 1281, 0,
1811, 181, 0, 1783, 0, 1944, 228, 3143, 639, 1683, 1833, 93, 1384, 1602, 1681, 1206,
1784, 426, 0, 1699, 0, 1732, 173, 1468, 0, 0, 2029, 146, 1622, 54, 1454, 617,
1793, 1909, 198, 1781, 1827, 649, 0, 0, 236, 444, 66, 1939, 1998, 978, 636, 1803,
1734, 0, 111, 361, 134, 1926, 1158, 1631, 1631, 0, 1862, 918, 0, 1683, 424, 162,
783, 0, 1938, 1539, 0, 444, 0, 1352, 839, 0, 0, 499, 929, 44, 321, 0,
0, 662, 1706, 0, 1259, 697, 121, 0, 1398, 54, 1729, 1352, 1792, 1564, 1556, 0,
0, 0, 641, 283, 0, 1578, 0, 86, 203, 1142, 0, 0, 261, 1821, 1871, 1998,
1197, 1528, 24, 2712, 1833, 1904, 2007, 1441, 218, 0, 189, 1428, 0, 1911, 1281, 1784,
0, 1734, 918, 0, 1214, 668, 849, 894, 939, 1256, 1716, 1609, 0, 349, 1969, 1724,
0, 1267, 0, 1647, 2023, 1241, 1706, 817, 0, 0, 857, 1246, 306, 157, 1683, 0,
406, 624, 0, 1619, 157, 1792, 684, 1421, 424, 1719, 1834, 0, 656, 649, 1974, 867,
97, 504, 0, 1539, 0, 651, 993, 0, 669, 644, 0, 1204, 0, 1949, 9, 1474,
1802, 704, 1117, 157, 1804, 291, 673, 1761, 769, 648, 204, 286, 658, 1428, 0, 0,
86, 14, 1362, 1567, 197, 152, 806, 1078, 669, 0, 967, 0, 1107, 0, 0, 162,
864, 828, 918, 0, 49, 1834, 76, 0, 0, 1524, 1826, 0, 0, 179, 839, 0,
1682, 882, 203, 157, 1322, 1481, 0, 839, 915, 1863, 1142, 1578, 1783, 828, 1044, 397,
1704, 1848, 0, 1837, 1746, 191, 1919, 1746, 1716, 521, 0, 734, 369, 978, 1639, 0,
397, 369, 397, 0, 1639, 1524, 1783, 1783, 0, 1472, 293, 1256, 351, 421, 947, 1461,
0, 33, 671, 837, 0, 1364, 0, 1059, 1302, 853, 1832, 26, 491, 879, 1706, 0,
807, 494, 0, 516, 4241, 91, 1247, 689, 323, 1991, 0, 1788, 646, 1479, 0, 0,
639, 158, 676, 0, 1318, 1059, 286, 948, 461, 1318, 134, 0, 134, 1859, 0, 678,
949, 1949, 949, 496, 1756, 978, 974, 1353, 1807, 1733, 709, 702, 1117, 0, 972, 0,
3016, 0, 1943, 0, 1836, 997, 754, 866, 444, 1733, 974, 91, 346, 0, 0, 427,
91, 599, 191, 697, 599, 779, 1798, 833, 0, 442, 0, 349, 1718, 864, 1732, 0,
674, 0, 0, 0, 1246, 504, 1983, 1526, 674, 852, 1284, 326, 872, 349, 666, 648,
1806, 249, 0, 0, 121, 0, 1983, 261, 1521, 0, 0, 868, 868, 1107, 1706, 357,
3138, 407, 0, 407, 429, 0, 204, 666, 0, 1019, 1938, 442, 0, 1227, 0, 713,
617, 713, 0, 309, 1227, 718, 1746, 0, 1636, 21, 201, 636, 294, 552, 552, 1872,
296, 326, 296, 1339, 2031, 0, 2921, 3771, 1804, 636, 716, 716, 268, 202, 1688, 0,
288, 1742, 3104, 1672, 697, 0, 1844, 864, 877, 1877, 461, 2719, 442, 201, 1299, 0,
1436, 993, 0, 0, 1174, 82, 662, 662, 1182, 839, 1436, 82, 159, 673, 506, 0,
299, 217, 781, 756, 0, 399, 1939, 1486, 1304, 149, 2739, 734, 0, 529, 0, 529,
713, 379, 639, 1604, 673, 887, 912, 1877, 0, 274, 4226, 734, 799, 1257, 149, 219,
508, 649, 274, 0, 1601, 419, 1236, 159, 0, 219, 1994, 461, 1671, 96, 636, 376,
1282, 1783, 1987, 649, 639, 2596, 0, 689, 631, 1469, 648, 377, 361, 1701, 508, 444,
1469, 649, 471, 277, 713, 2719, 0, 158, 1966, 0, 837, 442, 1436, 1211, 0, 658,
506, 1266, 697, 604, 1896, 0, 0, 689, 3701, 877, 529, 658, 529, 649, 0, 291,
631, 639, 649, 1804, 649, 0, 157, 648, 1007, 837, 0, 839, 0, 1304, 39, 491,
641, 1704, 934, 864, 669, 0, 1732, 0, 349, 1954, 1128, 662, 1297, 1449, 1804, 0,
0, 839, 3169, 817, 817, 694, 0, 0, 0, 1729, 0, 776, 662, 0, 567, 1474,
734, 3169, 561, 97, 0, 189, 0, 1823, 0, 978, 0, 1771, 0, 1282, 0, 0,
968, 189, 3324, 714, 978, 349, 1759, 1759, 716, 1704, 1804, 1771, 0, 1469, 817, 1019,
894, 0, 1474, 639, 1277, 654, 658, 1304, 0, 1804, 0, 406, 0, 0, 0, 286,
1732, 934, 1771, 1771, 919, 839, 0, 1322, 1304, 46, 1447, 1847, 681, 0, 496, 1704,
1847, 1688, 69, 0, 0, 46, 241, 0, 1746, 1196, 686, 1582, 0, 1242, 11, 1182,
442, 491, 276, 0, 0, 68, 3104, 53, 0, 187, 411, 0, 1802, 1851, 0, 724,
654, 776, 596, 1712, 0, 0, 528, 0, 0, 0, 418, 0, 0, 528, 784, 624,
286, 784, 847, 847, 1543, 0, 0, 1297, 1709, 1203, 3796, 1801, 731, 1783, 71, 1079,
3796, 1472, 0, 1256, 1084, 1389, 2007, 1466, 1703, 624, 39, 0, 1709, 1674, 3102, 1732,
0, 51, 2007, 1987, 1732, 286, 934, 1037, 286, 0, 97, 0, 103, 0, 74, 103,
1909, 1253, 892, 1828, 893, 0, 509, 1699, 1734, 662, 0, 1684, 17, 0, 1936, 948,
1809, 1681, 1449, 637, 1309, 898, 0, 3194, 1734, 1759, 668, 1309, 1704, 639, 0, 1281,
0, 0, 163, 0, 384, 1621, 839, 0, 0, 839, 1778, 1776, 1784, 1454, 1938, 1898,
0, 0, 1274, 1777, 1939, 134, 942, 1602, 837, 1454, 594, 0, 2016, 274, 417, 1837,
134, 0, 1721, 1783, 839, 697, 3929, 321, 202, 684, 0, 22, 528, 1784, 1521, 0,
163, 0, 839, 1782, 1783, 0, 1521, 0, 0, 1292, 0, 1299, 0, 0, 356, 1719,
0, 1396, 116, 116, 0, 0, 9, 284, 1829, 146, 637, 1828, 1501, 408, 1476, 0,
0, 2901, 0, 0, 1481, 0, 1298, 1479, 74, 1759, 643, 1174, 0, 0, 0, 1533,
332, 1374, 242, 753, 503, 689, 874, 0, 1581, 754, 4438, 659, 1919, 26, 336, 733,
1567, 189, 1473, 1829, 0, 1233, 1799, 3064, 1521, 1574, 1364, 824, 326, 636, 0, 0,
0, 1756, 0, 186, 474, 0, 1791, 1993, 567, 637, 329, 269, 1627, 997, 594, 839,
4138, 1724, 1899, 4214, 1798, 918, 1776, 3430, 1158, 1766, 1801, 702, 198, 869, 1651, 1807,
419, 1203, 1279, 1279, 664, 104, 438, 2530, 371, 421, 382, 552, 1621, 3057, 1513, 1248,
587, 1936, 1808, 1702, 1702, 168, 1029, 1769, 1706, 221, 0, 1688, 593, 586, 1702, 0,
4276, 702, 918, 384, 0, 869, 281, 1248, 182, 1702, 469, 441, 659, 0, 188, 1466,
1029, 1651, 925, 1804, 281, 1158, 839, 55, 1837, 1696, 0, 1261, 1701, 0, 0, 1717,
1191, 1688, 2031, 925, 872, 1317, 1826, 313, 1946, 0, 1949, 1619, 1709, 0, 0, 1227,
1993, 506, 1991, 1684, 593, 566, 1047, 1711, 1186, 0, 1726, 1461, 596, 999, 277, 1296,
688, 1717, 1851, 0, 376, 0, 1182, 67, 442, 0, 0, 1853, 3067, 546, 684, 1823,
445, 276, 1949, 0, 708, 501, 446, 2028, 104, 882, 346, 1107, 0, 1521, 0, 0,
636, 398, 384, 491, 1899, 1709, 1802, 863, 1991, 986, 971, 1938, 1793, 1706, 1949, 708,
1772, 1862, 1729, 732, 621, 763, 1474, 1582, 1717, 11, 1763, 1751, 1696, 1781, 818, 1801,
6, 1223, 1463, 1627, 3086, 1746, 376, 1661, 541, 1856, 0, 314, 1169, 1723, 6, 482,
776, 1778, 276, 1726, 69, 1843, 1082, 3102, 557, 769, 378, 0, 1247, 1117, 1011, 4316,
564, 1837, 884, 354, 942, 471, 1152, 186, 1449, 840, 3528, 2007, 0, 756, 1729, 0,
0, 97, 1922, 1896, 852, 0, 986, 864, 1391, 0, 103, 554, 581, 488, 0, 641,
0, 1784, 503, 503, 55, 552, 1556, 227, 1804, 6, 642, 1638, 1782, 0, 839, 1706,
1577, 2029, 1463, 171, 1025, 1874, 1778, 351, 0, 0, 1279, 929, 1009, 494, 353, 0,
819, 853, 1558, 1874, 614, 833, 1426, 636, 2008, 0, 428, 1807, 598, 1249, 1479, 1682,
1486, 164, 397, 839, 1724, 13, 664, 1816, 1084, 1832, 0, 802, 1429, 0, 1659, 596,
1777, 1946, 0, 738, 1987, 1987, 1441, 0, 581, 867, 2505, 1726, 1261, 1981, 1703, 1689,
264, 332, 596, 1248, 0, 1582, 289, 289, 0, 0, 0, 0, 234, 567, 1778, 1248,
0, 416, 853, 1717, 1202, 1427, 3300, 1877, 0, 509, 1161, 1923, 1414, 1969, 1099, 536,
912, 1782, 311, 0, 0, 100, 339, 811, 1729, 0, 0, 189, 1602, 11, 681, 288,
706, 1822, 1684, 1037, 1439, 0, 1922, 798, 661, 592, 553, 332, 1946, 152, 1666, 1333,
0, 1806, 1862, 1791, 1696, 978, 0, 0, 213, 624, 614, 0, 1708, 3066, 636, 784,
0, 1682, 1429, 1758, 617, 377, 1782, 1761, 854, 1834, 3901, 186, 1267, 1784, 286, 0,
1472, 837, 4316, 1896, 0, 981, 1812, 3691, 0, 782, 1709, 1834, 637, 890, 759, 1409,
599, 1602, 1792, 569, 1429, 1754, 1261, 1414, 1821, 1539, 494, 1732, 9, 1556, 3430, 146,
549, 734, 1564, 1403, 176, 1364, 1531, 0, 0, 1178, 1701, 1258, 1474, 472, 1991, 661,
0, 1691, 1664, 1524, 186, 562, 1560, 641, 546, 1558, 1277, 1099, 566, 0, 0, 1025,
474, 1027, 318, 8, 0, 1626, 69, 22, 0, 847, 1546, 1924, 1009, 1534, 1533, 1573,
312, 1246, 659, 0, 656, 713, 1574, 0, 127, 641, 0, 0, 1214, 890, 446, 643,
656, 596, 624, 536, 1158, 1716, 1877, 162, 1756, 0, 0, 930, 929, 599, 830, 356,
0, 1576, 1798, 61, 1811, 1708, 659, 974, 0, 3102, 933, 0, 2026, 1196, 819, 1729,
636, 1953, 167, 784, 2018, 1726, 1521, 562, 925, 857, 1267, 1706, 0, 158, 289, 571,
1774, 384, 2023, 406, 0, 621, 1863, 217, 254, 289, 1834, 0, 141, 659, 1796, 1706,
1249, 0, 867, 1756, 306, 0, 0, 1241, 696, 1277, 1772, 188, 891, 1521, 1783, 0,
276, 0, 1151, 1987, 669, 1117, 1843, 0, 1249, 384, 1874, 1801, 1474, 659, 1839, 8,
1821, 697, 769, 1702, 3691, 0, 447, 2031, 371, 291, 1736, 1391, 1201, 1203, 11, 264,
1107, 312, 809, 1564, 631, 1362, 561, 1714, 0, 0, 1204, 0, 639, 669, 562, 1604,
162, 0, 0, 106, 1604, 891, 0, 96, 1826, 1793, 1807, 0, 955, 617, 0, 837,
877, 1732, 1041, 1726, 1007, 1784, 839, 892, 882, 0, 289, 179, 1222, 1203, 1724, 634,
0, 0, 378, 759, 1782, 157, 1811, 1323, 0, 1709, 0, 0, 657, 234, 611, 684,
1969, 1099, 1726, 1852, 0, 158, 209, 0, 1804, 912, 1041, 1852, 1536, 1708, 1894, 0,
0, 1953, 0, 1099, 1041, 0, 0, 1682, 622, 0, 1292, 1524, 0, 648, 622, 1739,
1806, 1036, 1642, 1642, 374, 724, 0, 678, 0, 0, 241, 597, 622, 1837, 382, 537,
789, 241, 1682, 1637, 1682, 907, 0, 1311, 0, 872, 504, 0, 0, 537, 1637, 1829,
537, 1807, 629, 1243, 1833, 552, 1837, 907, 3801, 1833, 1281, 537, 1642, 1682, 0, 1301,
756, 0, 1837, 1837, 1779, 0, 1637, 0, 1642, 0, 624, 1804, 612, 0, 897, 1638,
1779, 0, 1621, 1469, 0, 0, 1364, 1776, 1859, 1682, 471, 0, 1701, 526, 1203, 1802,
2814, 0, 0, 1929, 1924, 0, 0, 1714, 1436, 779, 2662, 1247, 0, 0, 636, 0,
1938, 1938, 38, 0, 0, 1278, 0, 702, 0, 1652, 2911, 424, 59, 1571, 718, 609,
2029, 741, 69, 0, 0, 0, 0, 769, 0, 0, 646, 1572, 839, 29, 1704, 422,
1979, 1231, 1173, 0, 786, 0, 1573, 0, 1657, 456, 1227, 324, 0, 1077, 1186, 1201,
676, 1786, 442, 24, 879, 1291, 1019, 731, 0, 0, 0, 313, 174, 872, 0, 444,
596, 0, 222, 796, 883, 883, 892, 24, 284, 49, 0, 1742, 349, 639, 0, 957,
0, 0, 828, 451, 1806, 594, 0, 1919, 442, 521, 1792, 378, 378, 528, 147, 1787,
1807, 402, 499, 1837, 332, 1732, 738, 1443, 0, 384, 94, 324, 0, 1779, 763, 280,
1444, 0, 713, 557, 1048, 13, 1741, 0, 1839, 41, 1186, 0, 1804, 1809, 0, 1759,
222, 137, 488, 6, 0, 0, 1309, 1823, 704, 0, 0, 932, 814, 0, 182, 1782,
137, 0, 864, 864, 1243, 182, 601, 104, 1472, 1771, 536, 0, 1798, 1084, 339, 1834,
104, 1779, 1302, 1549, 1202, 1281, 0, 689, 0, 1931, 0, 0, 346, 284, 1574, 13,
113, 1481, 63, 1719, 1937, 378, 1804, 1937, 1804, 1187, 636, 1983, 1247, 1409, 0, 0,
756, 734, 1577, 786, 1079, 646, 366, 668, 461, 1834, 384, 1197, 504, 1639, 834, 0,
1777, 1259, 0, 0, 1574, 379, 0, 0, 0, 1806, 0, 69, 849, 536, 332, 0,
594, 48, 0, 1832, 311, 1012, 661, 1367, 384, 489, 716, 0, 1832, 617, 384, 1792,
1784, 49, 637, 957, 2662, 358, 1657, 13, 427, 1944, 664, 1926, 0, 461, 0, 648,
1227, 828, 0, 616, 832, 364, 0, 0, 639, 637, 769, 1812, 1561, 182, 1823, 713,
0, 1539, 1472, 974, 1563, 1693, 0, 1637, 1577, 1309, 1943, 839, 0, 1177, 3891, 0,
0, 1607, 1704, 182, 1771, 474, 0, 0, 491, 1782, 0, 1607, 1837, 1849, 0, 879,
548, 813, 162, 0, 64, 177, 894, 0, 0, 1259, 957, 1009, 1966, 1503, 1482, 888,
187, 939, 76, 674, 0, 1484, 332, 1911, 719, 1821, 324, 178, 0, 0, 359, 1263,
1277, 311, 1441, 1019, 261, 0, 0, 1891, 456, 1262, 852, 0, 1979, 1266, 1891, 1756,
1439, 1439, 0, 1243, 0, 348, 407, 0, 1009, 371, 0, 2021, 314, 0, 379, 379,
0, 309, 0, 422, 0, 0, 280, 0, 1954, 646, 24, 1262, 636, 1266, 738, 1804,
0, 69, 324, 0, 0, 1821, 697, 1572, 808, 689, 609, 0, 1323, 0, 1771, 648,
0, 569, 454, 1776, 1479, 562, 1367, 669, 828, 779, 892, 1782, 1572, 1682, 609, 883,
883, 0, 839, 847, 1323, 571, 0, 1782, 828, 29, 0, 1474, 1337, 0, 1974, 1974,
1466, 1801, 934, 732, 1954, 0, 597, 597, 788, 1801, 597, 1759, 788, 1479, 943, 266,
0, 0, 1938, 501, 2704, 0, 426, 54, 0, 74, 1546, 0, 872, 444, 274, 1714,
1749, 0, 1357, 0, 782, 1706, 1669, 1839, 1839, 1539, 376, 376, 1799, 0, 0, 499,
499, 0, 969, 0, 1807, 633, 0, 2779, 0, 1606, 1569, 441, 769, 1791, 1786, 556,
0, 1471, 58, 0, 1632, 0, 0, 1802, 761, 641, 377, 0, 778, 0, 641, 0,
391, 847, 614, 0, 1783, 1184, 0, 3747, 1034, 429, 526, 424, 0, 0, 782, 2004,
614, 1249, 0, 1899, 2556, 1804, 653, 1584, 1973, 0, 1706, 0, 416, 0, 0, 0,
324, 24, 1451, 0, 0, 24, 0, 24, 653, 847, 377, 1846, 653, 1474, 424, 0,
54, 897, 173, 1148, 1127, 0, 1033, 1256, 646, 1561, 0, 1132, 149, 3063, 1716, 409,
639, 1519, 1362, 416, 1679, 587, 1971, 444, 926, 0, 1339, 0, 0, 1782, 1709, 1687,
1941, 0, 359, 639, 0, 0, 1791, 669, 1847, 984, 0, 1148, 0, 1971, 1111, 0,
1029, 1736, 422, 68, 1832, 1658, 426, 1672, 412, 1703, 1834, 526, 359, 0, 1076, 1947,
0, 1916, 277, 1078, 1673, 1633, 1762, 0, 0, 959, 1009, 1246, 69, 1461, 1274, 0,
567, 1758, 0, 1931, 0, 39, 1018, 442, 872, 1993, 1993, 1473, 1318, 1436, 16, 937,
663, 501, 1524, 1744, 1683, 0, 689, 1436, 1221, 1339, 1792, 1627, 651, 1481, 637, 0,
1443, 632, 0, 656, 499, 1018, 646, 0, 1802, 1082, 1937, 636, 636, 1719, 582, 0,
0, 761, 11, 997, 864, 1189, 1709, 1829, 1782, 149, 1716, 1806, 188, 528, 1302, 1991,
1526, 1681, 0, 1662, 887, 1779, 1327, 656, 897, 1226, 1719, 0, 838, 0, 0, 942,
0, 1556, 0, 1683, 0, 234, 234, 1622, 1087, 1742, 1037, 1832, 1029, 0, 1547, 691,
1461, 0, 0, 314, 0, 382, 0, 0, 0, 978, 0, 0, 1703, 6, 1782, 1832,
0, 1832, 1661, 839, 1717, 686, 1298, 1979, 1246, 1717, 0, 0, 161, 0, 1777, 0,
381, 887, 977, 242, 1187, 0, 1232, 113, 872, 1673, 78, 0, 1481, 1248, 0, 0,
1698, 1698, 1572, 416, 0, 662, 1606, 1077, 694, 0, 626, 671, 1257, 324, 1744, 599,
1671, 0, 69, 1806, 1946, 234, 444, 674, 0, 14, 807, 0, 1807, 1779, 0, 0,
323, 0, 0, 604, 1811, 157, 1463, 1622, 294, 0, 1704, 1039, 1384, 643, 0, 1759,
0, 0, 0, 1357, 958, 0, 0, 0, 0, 0, 1257, 226, 982, 0, 663, 361,
1706, 0, 957, 617, 977, 11, 0, 1761, 0, 0, 959, 1839, 1926, 1291, 1474, 1734,
0, 0, 949, 0, 1521, 1206, 1684, 1661, 0, 597, 23, 0, 48, 0, 1631, 526,
202, 1792, 1204, 1707, 1837, 1814, 1352, 1363, 186, 877, 958, 1172, 23, 926, 499, 784,
1277, 644, 1408, 0, 1837, 0, 1352, 997, 1812, 637, 1539, 1093, 1717, 1581, 0, 812,
1048, 0, 9, 0, 1222, 1804, 1212, 1834, 827, 1762, 939, 1801, 1911, 721, 1821, 1079,
837, 312, 526, 1781, 0, 1966, 162, 0, 551, 1064, 819, 1007, 1921, 599, 599, 0,
0, 1262, 927, 1219, 501, 1703, 1267, 379, 1439, 617, 1717, 1717, 0, 857, 0, 604,
526, 306, 1937, 1756, 0, 602, 0, 784, 1327, 1706, 0, 157, 656, 0, 0, 1171,
1783, 0, 0, 659, 978, 0, 69, 1439, 0, 1262, 847, 612, 0, 1093, 348, 0,
126, 9, 1087, 1107, 926, 1612, 197, 669, 237, 0, 1222, 0, 1756, 1033, 1784, 1567,
1811, 0, 1093, 0, 1812, 0, 67, 1007, 1463, 0, 0, 0, 877, 1832, 808, 1784,
1501, 0, 0, 1087, 0, 1716, 0, 1501, 1802, 0, 0, 839, 897, 1782, 1952, 0,
1995, 662, 0, 697, 748, 1849, 1991, 1994, 267, 1551, 442, 54, 1991, 1729, 0, 969,
0, 0, 46, 639, 501, 1127, 1767, 0, 0, 547, 897, 1551, 1046, 0, 1996, 0,
1482, 157, 1779, 1991, 0, 441, 0, 837, 1767, 0, 1362, 1032, 1099, 1099, 0, 897,
977, 3607, 1353, 1561, 528, 1902, 0, 1833, 1478, 11, 0, 1529, 1672, 1359, 1793, 587,
0, 0, 947, 974, 0, 294, 587, 1996, 516, 1949, 339, 1673, 1802, 48, 1472, 1472,
193, 1463, 734, 1761, 1474, 1829, 614, 1802, 1613, 0, 1719, 491, 182, 702, 491, 0,
1858, 0, 0, 549, 1784, 1726, 3141, 0, 177, 1352, 0, 0, 0, 771, 86, 1539,
113, 662, 639, 1836, 639, 1807, 974, 754, 0, 1309, 1926, 648, 444, 1107, 94, 0,
959, 1278, 552, 1834, 1472, 0, 669, 1107, 1939, 1833, 0, 771, 0, 1278, 1009, 147,
689, 508, 1278, 599, 1704, 857, 1472, 1107, 1904, 1463, 1683, 1733, 771, 0, 857, 704,
612, 1804, 1802, 48, 0, 193, 48, 0, 269, 369, 1524, 1772, 298, 0, 369, 1479,
0, 426, 1966, 441, 1454, 734, 3151, 3151, 1966, 1684, 2021, 1772, 1484, 369, 298, 1728,
864, 3948, 398, 398, 398, 448, 646, 1481, 177, 1444, 1444, 0, 447, 162, 0, 1718,
1718, 0, 1827, 0, 1827, 859, 0, 1792, 943, 1676, 1676, 0, 449, 1792, 0, 0,
193, 684, 456, 503, 456, 0, 0, 456, 1471, 1808, 188, 726, 1077, 3169, 4183, 1094,
687, 1204, 142, 1709, 66, 686, 664, 1607, 1296, 1604, 664, 1701, 328, 1471, 1473, 1227,
636, 1734, 0, 1709, 1077, 1908, 1706, 0, 1683, 381, 0, 93, 1604, 419, 1483, 0,
1637, 919, 919, 1708, 142, 919, 689, 1734, 689, 696, 857, 0, 1483, 1709, 128, 1652,
0, 1436, 0, 1716, 839, 0, 296, 0, 0, 1804, 1248, 1339, 1704, 0, 1436, 1833,
0, 1549, 1248, 0, 0, 38, 1793, 0, 1777, 1704, 662, 384, 637, 1256, 0, 1672,
1247, 137, 137, 1247, 149, 664, 1296, 463, 1719, 24, 807, 298, 26, 2027, 2029, 1788,
689, 461, 733, 498, 1769, 1231, 839, 1612, 686, 1782, 432, 1754, 643, 873, 1657, 1186,
23, 284, 0, 1844, 0, 599, 1166, 992, 14, 0, 873, 313, 1227, 346, 1909, 781,
1827, 948, 0, 1767, 1804, 1221, 567, 734, 914, 382, 444, 1772, 332, 0, 393, 397,
451, 0, 349, 1802, 1018, 1472, 11, 1681, 582, 1939, 974, 838, 0, 0, 528, 1828,
1444, 1712, 0, 1792, 659, 1931, 897, 656, 382, 382, 1834, 0, 101, 1269, 1311, 426,
426, 1047, 0, 0, 1719, 0, 298, 1736, 182, 1637, 488, 704, 0, 1712, 0, 1833,
814, 719, 817, 802, 0, 0, 746, 192, 0, 0, 0, 602, 686, 802, 1247, 992,
0, 786, 2007, 0, 261, 1777, 1777, 463, 907, 907, 872, 697, 0, 1931, 536, 1807,
346, 0, 1931, 1681, 1727, 69, 1781, 1526, 662, 61, 2007, 0, 346, 1908, 504, 1807,
1991, 1879, 617, 1832, 1668, 1787, 426, 1292, 373, 1602, 1803, 0, 1474, 1858, 1793, 384,
1954, 1909, 919, 1783, 0, 1719, 0, 636, 0, 1622, 1469, 957, 1259, 0, 1832, 0,
807, 662, 1782, 0, 0, 1996, 147, 1549, 1352, 731, 1276, 1832, 733, 888, 1637, 0,
0, 0, 121, 294, 0, 662, 0, 877, 1704, 1526, 0, 1991, 1682, 0, 0, 272,
0, 1823, 1099, 236, 637, 0, 1384, 1528, 0, 1264, 857, 0, 158, 332, 136, 338,
1636, 888, 1914, 0, 1908, 22, 127, 1296, 1261, 2016, 2018, 298, 298, 1707, 0, 0,
882, 0, 142, 96, 1276, 656, 0, 817, 0, 867, 857, 0, 1277, 309, 379, 2021,
659, 697, 1792, 0, 0, 0, 0, 1804, 1767, 1047, 1799, 0, 1803, 384, 1718, 637,
1734, 733, 1706, 0, 24, 2019, 0, 1802, 1352, 0, 873, 0, 1833, 1844, 0, 0,
1852, 0, 1706, 882, 0, 321, 1352, 1706, 0, 157, 0, 781, 1782, 1681, 1047, 1302,
0, 257, 897, 321, 321, 1099, 1782, 0, 1783, 0, 0, 211, 0, 211, 1946, 616,
671, 1772, 167, 167, 0, 491, 2028, 1268, 689, 493, 0, 1701, 0, 0, 2649, 1292,
1292, 638, 1803, 1524, 26, 1936, 0, 1724, 0, 668, 0, 1724, 0, 1774, 666, 442,
1851, 69, 1474, 104, 336, 1494, 406, 0, 1471, 0, 1164, 1938, 1706, 0, 177, 1682,
1914, 1578, 0, 0, 1189, 1164, 1616, 442, 847, 1939, 1948, 97, 1939, 314, 0, 1804,
1804, 1227, 1254, 694, 1362, 1494, 284, 1934, 1509, 1269, 0, 1471, 1312, 1707, 41, 284,
526, 197, 0, 1914, 646, 1671, 284, 1682, 162, 0, 0, 1877, 537, 949, 358, 594,
1934, 1756, 974, 1682, 1699, 442, 0, 41, 1227, 0, 491, 1172, 618, 1581, 974, 644,
0, 0, 0, 1461, 939, 1019, 0, 537, 1877, 1019, 0, 1914, 673, 158, 442, 1939,
596, 406, 217, 69, 69, 0, 974, 1266, 156, 422, 967, 41, 197, 989, 202, 662,
1718, 0, 2956, 1227, 1082, 646, 94, 2031, 1744, 456, 1791, 614, 1829, 1826, 638, 523,
1203, 1621, 134, 523, 1971, 0, 1284, 69, 1277, 1652, 217, 528, 1778, 34, 0, 1759,
892, 1703, 0, 759, 4314, 313, 1182, 324, 0, 984, 486, 239, 443, 0, 1177, 419,
1722, 0, 1939, 1612, 1939, 1751, 2859, 2029, 1729, 0, 528, 759, 942, 1622, 1827, 0,
93, 181, 802, 51, 636, 11, 1484, 721, 1821, 1658, 0, 0, 1283, 1834, 1833, 0,
0, 134, 1721, 419, 684, 567, 526, 879, 1429, 847, 812, 1531, 1781, 0, 1283, 684,
684, 668, 22, 794, 887, 1809, 859, 284, 894, 1804, 202, 157, 1637, 1521, 1736, 984,
163, 1703, 419, 523, 0, 769, 69, 1414, 1734, 868, 868, 0, 892, 0, 1813, 1718,
1621, 1821, 837, 1621, 1808, 1772, 1782, 1622, 312, 1234, 649, 622, 1033, 0, 493, 1084,
711, 74, 1804, 1249, 3619, 423, 0, 1783, 1804, 1971, 69, 1804, 1801, 399, 1396, 1474,
399, 1474, 1474, 491, 329, 1808, 491, 442, 587, 0, 1647, 187, 0, 29, 0, 314,
1911, 0, 1581, 443, 313, 972, 1717, 597, 166, 1128, 674, 0, 0, 973, 1301, 1671,
1446, 1384, 0, 674, 0, 1911, 654, 1262, 1197, 2789, 3762, 0, 69, 0, 289, 0,
499, 471, 0, 69, 751, 0, 84, 0, 2789, 536, 1262, 587, 972, 536, 1671, 697,
639, 1804, 526, 2791, 894, 894, 1644, 624, 1939, 624, 0, 1802, 1802, 1802, 0, 1841,
1841, 1436, 1742, 0, 1627, 1784, 1784, 1834, 0, 113, 76, 326, 86, 1197, 0, 1211,
1911, 1813, 0, 189, 1987, 0, 637, 1177, 1941, 1804, 0, 174, 68, 313, 873, 432,
1678, 1931, 252, 1469, 674, 2784, 1706, 1774, 578, 1787, 607, 919, 594, 0, 0, 0,
1757, 674, 1637, 242, 0, 802, 242, 2802, 1167, 1708, 0, 639, 162, 0, 242, 1946,
802, 1834, 0, 0, 0, 1473, 644, 74, 617, 444, 1772, 1683, 1177, 1792, 1681, 1706,
0, 0, 1602, 302, 1931, 1931, 84, 302, 0, 174, 0, 624, 658, 621, 957, 883,
1721, 49, 0, 1736, 1736, 69, 1804, 0, 0, 296, 0, 0, 639, 1338, 0, 159,
1573, 1589, 1589, 0, 1249, 1569, 268, 1939, 1679, 942, 0, 0, 1811, 1608, 992, 0,
1941, 191, 0, 637, 1703, 1249, 0, 1826, 1672, 0, 1526, 769, 0, 74, 1939, 1474,
264, 177, 0, 1652, 1257, 1084, 0, 1746, 1113, 0, 1716, 1736, 721, 596, 714, 424,
607, 1569, 1528, 1703, 1159, 164, 219, 0, 0, 48, 166, 992, 1186, 2029, 1888, 1789,
499, 39, 1129, 1047, 1931, 1164, 104, 1616, 0, 599, 251, 277, 847, 1521, 196, 0,
284, 1802, 1636, 0, 441, 637, 1196, 1744, 1839, 1077, 514, 442, 1709, 69, 1829, 1274,
0, 241, 93, 618, 1844, 204, 0, 1484, 0, 1571, 1823, 1998, 369, 0, 0, 1804,
188, 1064, 1772, 1474, 1706, 818, 582, 776, 0, 1938, 1732, 849, 1611, 618, 0, 0,
748, 0, 582, 1706, 1729, 1484, 0, 0, 1751, 1789, 624, 622, 0, 642, 1802, 1746,
514, 869, 621, 1994, 1759, 188, 1723, 1149, 579, 391, 734, 349, 1607, 491, 1302, 1706,
1254, 0, 1196, 738, 0, 624, 2884, 1751, 1629, 1781, 713, 134, 1048, 1849, 0, 1823,
1823, 691, 0, 788, 1268, 1844, 1834, 1637, 664, 1706, 1922, 867, 1604, 554, 759, 0,
1604, 0, 1804, 0, 623, 1706, 54, 937, 0, 0, 1528, 1301, 182, 781, 0, 1704,
1826, 0, 852, 614, 241, 0, 1844, 839, 1102, 1048, 384, 1309, 1762, 1256, 1704, 993,
242, 418, 51, 302, 264, 164, 3464, 839, 639, 518, 519, 1744, 299, 1246, 746, 1608,
909, 1706, 0, 786, 1079, 1282, 196, 371, 538, 1906, 671, 1673, 1836, 666, 639, 867,
0, 634, 0, 1302, 289, 1604, 0, 0, 1678, 234, 596, 626, 1706, 1578, 0, 1682,
624, 2884, 1373, 1998, 1717, 0, 324, 689, 118, 182, 302, 54, 1274, 117, 289, 519,
379, 1048, 1849, 1723, 1979, 332, 617, 228, 1287, 1333, 1741, 134, 73, 993, 1996, 1602,
1268, 197, 0, 1761, 1684, 472, 1256, 0, 1834, 1832, 69, 1837, 0, 993, 69, 1804,
978, 0, 1274, 1441, 1806, 384, 177, 0, 472, 0, 1832, 9, 1274, 1784, 0, 458,
1849, 244, 0, 834, 424, 0, 784, 784, 1309, 491, 0, 1539, 1539, 0, 1792, 1528,
618, 0, 503, 0, 219, 0, 1732, 713, 0, 0, 0, 1774, 1464, 97, 714, 1839,
1709, 629, 1823, 0, 839, 1406, 1581, 1806, 237, 1759, 1259, 1569, 616, 1849, 1464, 998,
0, 1454, 1871, 1211, 1019, 1019, 537, 0, 118, 117, 117, 261, 0, 1589, 1911, 1629,
0, 1503, 939, 519, 1309, 1874, 684, 624, 713, 0, 1159, 1528, 668, 1809, 919, 1441,
1684, 1642, 937, 1256, 1454, 1821, 1284, 721, 0, 1937, 887, 0, 1246, 1246, 1834, 0,
857, 241, 1826, 191, 0, 0, 0, 1249, 0, 1197, 54, 81, 227, 656, 1891, 0,
847, 1227, 784, 624, 1267, 0, 1809, 0, 1708, 1708, 289, 1572, 0, 369, 0, 839,
0, 134, 1726, 0, 424, 0, 0, 191, 551, 1249, 1717, 993, 673, 857, 1703, 118,
697, 254, 1719, 1573, 1467, 69, 1804, 204, 1716, 1047, 289, 0, 673, 0, 554, 658,
0, 694, 348, 1277, 0, 689, 128, 738, 1734, 4314, 24, 949, 1804, 868, 0, 0,
607, 964, 808, 0, 868, 1781, 794, 0, 1939, 0, 0, 0, 0, 0, 967, 369,
639, 0, 0, 964, 197, 1939, 1144, 1144, 1781, 1788, 47, 1939, 0, 778, 1826, 0,
877, 989, 182, 0, 159, 968, 808, 607, 1762, 1324, 159, 639, 689, 611, 1454, 1804,
849, 1038, 0, 1578, 697, 0, 1974, 1974, 471, 1844, 1704, 646, 1756, 1484, 1352, 1709,
182, 1698, 664, 0, 646, 1261, 634, 1261, 1909, 349, 1246, 642, 0, 471, 642, 638,
1937, 716, 637, 782, 454, 308, 1909, 1261, 0, 648, 662, 1834, 648, 1807, 894, 596,
1909, 1709, 1709, 231, 284, 0, 599, 599, 599, 0, 1474, 839, 0, 599, 839, 412,
1558, 73, 324, 676, 0, 1802, 1803, 3939, 599, 416, 1783, 1478, 1478, 112, 4396, 0,
824, 1241, 26, 2778, 1341, 442, 0, 0, 1656, 1914, 1093, 722, 1831, 0, 554, 0,
146, 1656, 1249, 754, 1704, 1656, 1256, 1937, 1339, 794, 962, 1408, 1787, 1113, 39, 173,
1328, 1706, 1257, 36, 642, 0, 442, 24, 0, 1201, 1938, 662, 384, 2031, 1918, 182,
639, 1848, 777, 74, 166, 0, 1688, 597, 1844, 697, 2528, 0, 1928, 0, 1848, 1672,
0, 1804, 1481, 1956, 1237, 1632, 353, 724, 4422, 0, 443, 1181, 27, 23, 1902, 1642,
751, 906, 1263, 0, 599, 49, 0, 0, 1196, 1317, 101, 1201, 1567, 1793, 1928, 1896,
1786, 49, 0, 1078, 1799, 313, 189, 0, 1851, 3508, 0, 176, 1776, 196, 1274, 993,
0, 0, 442, 1898, 1953, 2786, 151, 1018, 1081, 796, 443, 1181, 39, 1166, 872, 1027,
513, 1257, 689, 1659, 27, 1656, 1656, 23, 686, 1986, 1174, 1916, 34, 34, 0, 1078,
689, 794, 883, 648, 0, 1821, 807, 3608, 96, 1877, 0, 577, 794, 1474, 662, 1933,
1338, 493, 493, 1302, 1496, 267, 1851, 728, 1802, 1732, 134, 621, 1221, 1964, 1472, 1027,
1099, 187, 509, 1939, 0, 0, 0, 1938, 1274, 14, 0, 1929, 472, 659, 764, 349,
1362, 4111, 0, 1896, 918, 332, 1661, 0, 0, 688, 1939, 897, 1779, 1956, 1564, 1732,
1047, 293, 658, 1934, 638, 621, 1717, 1833, 2507, 1656, 1142, 274, 97, 488, 0, 1929,
0, 1556, 1556, 671, 957, 0, 687, 0, 648, 1804, 1623, 1436, 1382, 1673, 1732, 146,
426, 658, 1703, 704, 684, 1628, 788, 189, 1637, 1986, 1237, 911, 26, 554, 1446, 1096,
691, 1454, 0, 0, 1987, 103, 1672, 104, 2024, 1804, 838, 0, 1531, 0, 816, 1553,
0, 648, 614, 298, 0, 1674, 0, 1198, 1453, 864, 0, 962, 0, 33, 689, 297,
1698, 7, 694, 0, 0, 176, 222, 662, 1638, 56, 1029, 1083, 1382, 2027, 0, 662,
1716, 1913, 321, 1408, 906, 1284, 722, 376, 1479, 329, 1238, 0, 1913, 629, 638, 1581,
1251, 1247, 1167, 0, 1256, 0, 1799, 1779, 697, 1934, 0, 509, 1078, 634, 1439, 339,
904, 113, 1574, 174, 91, 661, 0, 749, 1646, 1783, 274, 2001, 686, 1609, 1257, 739,
31, 1162, 661, 893, 511, 999, 0, 1939, 288, 968, 156, 1406, 519, 1199, 1839, 0,
648, 0, 1827, 648, 1832, 1782, 782, 1038, 586, 1357, 66, 1681, 1391, 2004, 1761, 982,
1602, 1096, 146, 189, 0, 1929, 1801, 1514, 617, 74, 1787, 614, 1783, 1863, 13, 1756,
1779, 1699, 732, 208, 639, 314, 0, 799, 182, 711, 681, 681, 0, 661, 621, 488,
193, 1519, 1452, 1731, 1837, 649, 1797, 146, 1896, 54, 1792, 0, 64, 808, 0, 1279,
156, 471, 888, 0, 0, 658, 499, 1279, 0, 1309, 196, 206, 1908, 1553, 1551, 97,
204, 0, 44, 271, 1406, 731, 1792, 298, 1936, 0, 796, 646, 1531, 0, 468, 1761,
1519, 1403, 669, 989, 384, 222, 1144, 1436, 1659, 0, 1577, 1172, 36, 276, 839, 1581,
756, 0, 506, 602, 1256, 1689, 1263, 1607, 0, 384, 1732, 0, 0, 147, 1899, 1079,
1703, 394, 1454, 493, 1454, 1481, 33, 1792, 89, 0, 1571, 1389, 0, 1556, 681, 0,
216, 511, 94, 427, 1491, 0, 0, 0, 1901, 1083, 0, 186, 519, 894, 914, 888,
1998, 1706, 0, 1896, 0, 1579, 604, 261, 1076, 1007, 0, 526, 1814, 1937, 22, 1939,
1099, 939, 159, 751, 201, 1454, 1642, 1916, 1006, 1007, 1922, 156, 0, 79, 0, 1792,
0, 0, 859, 636, 1811, 696, 0, 3716, 816, 371, 1719, 1367, 1684, 0, 0, 1717,
181, 181, 3886, 1047, 0, 1521, 554, 617, 276, 2023, 1083, 0, 182, 621, 1974, 658,
638, 0, 1574, 288, 174, 96, 173, 0, 0, 856, 0, 443, 1269, 96, 271, 0,
1969, 1658, 1241, 1279, 371, 1083, 0, 1732, 893, 658, 256, 1564, 554, 1269, 1956, 648,
458, 1821, 827, 1143, 893, 1439, 0, 1877, 0, 234, 636, 293, 0, 126, 1282, 1282,
614, 0, 1277, 768, 286, 1732, 706, 1203, 99, 24, 689, 1799, 0, 967, 1534, 0,
638, 1567, 1987, 298, 1743, 808, 106, 688, 1799, 1363, 0, 1799, 1078, 599, 0, 89,
3608, 471, 1939, 662, 794, 0, 649, 1732, 799, 0, 33, 1534, 893, 904, 1328, 1937,
1171, 1788, 0, 109, 1481, 1863, 1083, 1763, 0, 631, 0, 804, 613, 1812, 892, 883,
1256, 0, 1863, 1256, 807, 1716, 1811, 957, 1323, 156, 0, 256, 1732, 1454, 912, 0,
972, 186, 1863, 897, 1571, 2014, 839, 321, 0, 293, 658, 697, 808, 839, 1043, 1936,
1936, 0, 1246, 1772, 1241, 1241, 1476, 728, 1826, 453, 0, 491, 0, 36, 414, 1934,
0, 321, 0, 993, 0, 504, 472, 0, 1729, 973, 1476, 0, 312, 1759, 659, 993,
0, 684, 0, 1657, 1833, 189, 22, 34, 1759, 3159, 0, 848, 1099, 69, 163, 0,
0, 0, 458, 3899, 731, 1784, 371, 636, 1633, 0, 376, 658, 674, 1787, 0, 993,
3984, 0, 1266, 7, 1933, 312, 1929, 441, 3984, 857, 1296, 1749, 1708, 0, 1439, 658,
1987, 1804, 848, 69, 1567, 1729, 0, 1687, 1767, 1247, 0, 1901, 86, 0, 1901, 0,
418, 36, 36, 807, 1832, 807, 1683, 2853, 0, 859, 0, 597, 1732, 643, 1833, 1926,
659, 1699, 1633, 0, 666, 189, 0, 443, 1261, 1908, 1297, 1987, 1908, 364, 1987, 1521,
1736, 0, 1987, 1277, 0, 0, 204, 364, 1952, 411, 0, 557, 1832, 1471, 0, 1827,
0, 1177, 1247, 1906, 947, 918, 1189, 0, 0, 0, 0, 1762, 671, 671, 1078, 2007,
1919, 0, 877, 1446, 0, 0, 1803, 1247, 0, 406, 1211, 406, 0, 769, 1549, 1832,
1702, 639, 639, 639, 0, 1349, 289, 684, 1938, 1873, 0, 0, 1772, 1759, 446, 797,
459, 554, 1567, 314, 1832, 158, 1472, 779, 1787, 0, 1679, 992, 992, 1651, 0, 1703,
1847, 0, 17, 1879, 38, 662, 786, 1466, 599, 413, 564, 529, 161, 1761, 997, 626,
421, 1278, 596, 1804, 1706, 1736, 0, 0, 0, 1572, 0, 0, 1787, 1863, 93, 1741,
1814, 1764, 1234, 0, 872, 226, 564, 959, 2027, 0, 74, 1759, 0, 1916, 244, 1474,
1473, 1834, 419, 332, 948, 1079, 163, 0, 0, 8, 93, 17, 1949, 882, 1718, 587,
0, 167, 1472, 3118, 618, 1763, 0, 761, 0, 669, 1939, 669, 1443, 0, 0, 1784,
0, 1724, 1434, 1728, 1799, 4349, 621, 552, 0, 704, 1673, 1719, 786, 1949, 1706, 1469,
0, 101, 1922, 0, 1704, 554, 624, 564, 177, 1673, 1608, 1987, 2019, 0, 1243, 673,
1706, 1438, 1078, 1706, 1282, 0, 671, 528, 1928, 1804, 1939, 13, 1673, 0, 854, 0,
1679, 1728, 1864, 416, 1761, 0, 1802, 1712, 4349, 621, 443, 993, 782, 1796, 1814, 0,
1683, 1483, 0, 0, 1037, 648, 1133, 14, 1787, 226, 0, 0, 0, 997, 0, 713,
564, 1693, 164, 0, 0, 0, 839, 9, 639, 529, 963, 1864, 0, 0, 1019, 1009,
241, 1079, 1911, 624, 49, 554, 0, 1966, 857, 1716, 1573, 673, 1218, 867, 1651, 0,
1804, 639, 0, 0, 1799, 0, 839, 1572, 1627, 1728, 419, 1572, 1919, 0, 0, 1724,
0, 0, 658, 0, 0, 0, 9, 0, 1481, 1483, 967, 1771, 1794, 1244, 839, 0,
779, 332, 0, 1784, 634, 0, 1706, 0, 882, 1043, 0, 897, 1434, 1578, 1783, 0,
1841, 643, 3796, 1799, 2989, 1799, 596, 567, 1481, 127, 0, 0, 939, 142, 2642, 1604,
2019, 1861, 0, 624, 1808, 1274, 0, 0, 1844, 1828, 1368, 1197, 0, 2942, 0, 1189,
1297, 0, 1149, 1613, 1519, 1929, 812, 813, 691, 0, 0, 1679, 0, 2667, 1246, 1246,
1811, 1996, 1679, 1627, 0, 0, 967, 882, 1019, 0, 1684, 1009, 58, 1897, 1484, 1484,
0, 1951, 0, 26, 1234, 378, 378, 296, 839, 528, 636, 681, 68, 1753, 1621, 239,
1426, 1337, 1852, 1302, 0, 1832, 2958, 1701, 146, 1436, 0, 407, 1704, 1993, 838, 1744,
112, 266, 0, 1447, 0, 379, 1914, 942, 0, 1804, 503, 0, 359, 1939, 1248, 1484,
464, 1612, 1019, 1436, 1674, 802, 0, 0, 1787, 928, 983, 0, 1837, 557, 0, 51,
662, 346, 468, 1793, 1716, 203, 226, 1162, 1481, 604, 1736, 1113, 1954, 1478, 1526, 38,
0, 637, 0, 669, 499, 636, 947, 1202, 0, 1678, 0, 411, 422, 1804, 442, 1037,
1706, 599, 1776, 353, 1737, 1928, 0, 867, 1374, 384, 957, 0, 538, 1936, 241, 1847,
1851, 1466, 1481, 1873, 0, 839, 599, 648, 182, 491, 1261, 426, 0, 1726, 1926, 756,
1227, 0, 1708, 1938, 513, 1726, 644, 641, 496, 442, 1009, 1804, 0, 0, 1474, 0,
1201, 1657, 379, 872, 93, 1077, 796, 0, 39, 409, 1941, 284, 237, 1786, 444, 33,
1013, 456, 1246, 1318, 1357, 0, 0, 0, 1924, 1712, 1827, 1461, 529, 1659, 2029, 1037,
1107, 0, 313, 1939, 2008, 147, 289, 501, 0, 684, 21, 442, 648, 96, 379, 731,
1034, 1954, 69, 878, 152, 1899, 1524, 1954, 1187, 0, 513, 1896, 1769, 181, 1934, 1474,
1936, 0, 1018, 839, 1352, 1899, 0, 76, 1909, 1939, 882, 349, 892, 0, 839, 807,
0, 1484, 1772, 1496, 1249, 0, 1246, 839, 1802, 0, 1929, 0, 1539, 506, 716, 56,
1339, 4229, 33, 0, 0, 1991, 197, 0, 239, 1758, 1951, 649, 0, 397, 398, 1828,
402, 493, 728, 818, 1906, 839, 0, 1789, 567, 481, 1936, 1474, 472, 1856, 897, 442,
662, 582, 529, 1582, 524, 1682, 3279, 0, 14, 11, 694, 1802, 1986, 756, 1939, 1287,
1627, 1401, 0, 612, 662, 684, 0, 0, 0, 456, 0, 0, 1811, 1513, 0, 1909,
1776, 1327, 1926, 294, 1246, 1267, 604, 529, 653, 1971, 0, 1556, 0, 1926, 51, 1621,
0, 674, 1235, 0, 442, 1372, 1628, 697, 1706, 812, 0, 426, 1246, 1688, 702, 458,
1539, 852, 1292, 1623, 0, 957, 41, 884, 0, 1971, 314, 691, 1637, 1874, 0, 504,
69, 1604, 552, 1993, 1936, 0, 54, 488, 648, 0, 0, 1029, 641, 1612, 0, 1726,
918, 612, 1446, 177, 422, 0, 969, 1702, 837, 837, 354, 1278, 1813, 1556, 687, 1601,
1734, 788, 1986, 1481, 1782, 409, 1683, 0, 0, 91, 1714, 0, 1582, 1939, 0, 0,
648, 0, 872, 837, 1249, 93, 1652, 241, 1281, 977, 1247, 1247, 113, 534, 157, 0,
418, 1167, 44, 1237, 626, 1996, 182, 1873, 637, 0, 1197, 0, 1834, 504, 627, 349,
1577, 461, 0, 314, 1706, 0, 1931, 1909, 1248, 1836, 1783, 1834, 694, 0, 1416, 1338,
222, 832, 1246, 1986, 442, 731, 802, 2001, 2001, 1919, 516, 421, 422, 1461, 0, 0,
1673, 538, 0, 0, 661, 1803, 199, 688, 687, 0, 264, 852, 1261, 1937, 1976, 1776,
686, 51, 656, 1987, 1994, 86, 0, 339, 0, 161, 962, 601, 648, 0, 0, 357,
1259, 299, 537, 323, 912, 1936, 1304, 999, 443, 0, 94, 0, 0, 1658, 0, 361,
1796, 0, 1683, 1681, 364, 643, 1996, 1717, 1802, 1926, 0, 1784, 1783, 212, 646, 226,
1833, 567, 1896, 0, 1207, 442, 0, 0, 1756, 1384, 1787, 1799, 1782, 0, 627, 781,
0, 782, 1521, 426, 1731, 1658, 637, 649, 1019, 949, 203, 758, 596, 849, 832, 1622,
1037, 1832, 1827, 957, 0, 1764, 1764, 0, 1926, 1207, 332, 637, 661, 1799, 203, 1513,
1832, 249, 0, 957, 1604, 637, 662, 713, 1291, 1812, 1357, 582, 887, 824, 1302, 0,
1223, 1474, 454, 1572, 808, 1686, 1832, 179, 917, 688, 1462, 0, 0, 1734, 643, 0,
1908, 442, 0, 974, 812, 1352, 503, 649, 688, 1561, 466, 1926, 43, 0, 1837, 0,
997, 1539, 0, 1792, 662, 618, 459, 418, 1899, 1257, 928, 1553, 1837, 1734, 1352, 1472,
1936, 261, 1686, 1622, 877, 1352, 1577, 1309, 0, 1521, 0, 1564, 731, 1706, 503, 1246,
468, 468, 1551, 1172, 1581, 0, 1772, 321, 0, 637, 1519, 499, 222, 1261, 147, 1259,
607, 957, 0, 464, 466, 0, 0, 0, 1789, 1926, 0, 649, 2019, 298, 526, 86,
1951, 0, 1707, 0, 847, 624, 1821, 1259, 538, 0, 454, 1642, 604, 1249, 1416, 0,
0, 1828, 597, 653, 599, 0, 529, 1099, 1804, 466, 721, 526, 526, 127, 939, 668,
312, 1971, 3324, 0, 177, 241, 837, 1751, 1282, 1503, 407, 1626, 519, 639, 0, 828,
0, 852, 974, 887, 167, 1539, 567, 201, 1577, 76, 0, 681, 0, 1896, 1481, 1911,
937, 3507, 1093, 1789, 0, 1197, 1954, 1426, 1706, 1302, 582, 646, 0, 0, 633, 1262,
0, 1811, 399, 0, 1937, 1267, 2016, 242, 1234, 1484, 604, 784, 1276, 2021, 1844, 1439,
1706, 1772, 0, 0, 458, 0, 1703, 1266, 1327, 869, 0, 1267, 0, 1379, 407, 1439,
1657, 818, 1847, 1514, 371, 181, 1577, 0, 687, 182, 1539, 697, 0, 1572, 624, 636,
1142, 1724, 1658, 0, 1373, 1951, 1627, 1891, 422, 1812, 1318, 582, 0, 501, 0, 819,
466, 202, 1708, 0, 0, 0, 471, 0, 671, 893, 0, 0, 1837, 0, 1409, 651,
1572, 868, 0, 1808, 1707, 1549, 0, 2019, 0, 181, 0, 0, 2019, 1804, 1276, 0,
1782, 827, 426, 623, 294, 639, 1549, 99, 0, 0, 203, 1956, 529, 637, 663, 643,
1282, 1902, 648, 1262, 298, 1803, 78, 0, 1451, 868, 839, 147, 967, 1807, 1582, 1567,
0, 0, 0, 86, 634, 639, 1256, 1078, 1107, 1803, 468, 649, 0, 1144, 1283, 0,
0, 974, 1919, 529, 0, 636, 782, 1231, 309, 0, 0, 977, 1826, 1939, 0, 1256,
828, 828, 0, 893, 0, 0, 0, 0, 0, 1156, 917, 1939, 466, 357, 1837, 839,
419, 1954, 0, 0, 0, 202, 0, 1951, 892, 0, 839, 1951, 179, 0, 384, 1536,
607, 1099, 0, 882, 0, 0, 1719, 0, 688, 1726, 872, 1811, 646, 0, 0, 0,
1721, 0, 97, 157, 807, 688, 0, 0, 1706, 244, 1302, 1297, 122, 0, 0, 912,
839, 257, 897, 293, 0, 0, 808, 807, 1952, 827, 838, 29, 0, 1834, 872, 516,
1259, 239, 611, 1736, 1832, 1834, 0, 1156, 1756, 0, 0, 0, 714, 1801, 0, 1706,
0, 566, 1834, 784, 852, 773, 1519, 1706, 381, 1246, 1246, 2031, 209, 1276, 773, 718,
0, 718, 213, 1429, 0, 1806, 1736, 1731, 1832, 1259, 1726, 1802, 471, 1701, 1574, 0,
1156, 596, 0, 611, 1756, 1191, 1708, 0, 0, 1706, 0, 551, 204, 0, 1718, 1832,
234, 611, 1938, 1934, 238, 104, 1703, 1247, 0, 104, 1666, 0, 0, 1939, 0, 188,
0, 0, 1549, 1549, 839, 0, 1833, 839, 526, 283, 0, 1523, 646, 0, 1688, 1009,
1791, 1009, 252, 1786, 1608, 0, 284, 1441, 1759, 1774, 1481, 117, 1282, 1213, 1254, 1292,
0, 674, 1848, 849, 1804, 438, 1937, 1781, 117, 626, 286, 637, 0, 0, 1848, 1686,
199, 89, 1604, 669, 1441, 1807, 1093, 254, 624, 0, 1804, 286, 0, 651, 849, 89,
357, 1256, 646, 1481, 1156, 364, 1954, 1806, 0, 0, 1426, 1269, 732, 1727, 0, 324,
623, 623, 503, 1309, 636, 1804, 1156, 623, 364, 1801, 1726, 1702, 519, 1018, 958, 958,
8, 663, 357, 1834, 68, 69, 69, 1202, 1202, 69, 157, 947, 0, 0, 1202, 947,
641, 1906, 1391, 1019, 1659, 0, 398, 1352, 1718, 0, 1017, 562, 1292, 0, 0, 1573,
1187, 0, 379, 264, 0, 1396, 0, 949, 1547, 1481, 0, 1659, 567, 649, 1564, 1396,
917, 1007, 947, 1627, 1353, 163, 1243, 895, 1906, 1409, 1906, 967, 895, 1297, 0, 1474,
313, 992, 0, 967, 1249, 1216, 1033, 1249, 296, 1716, 211, 421, 0, 1029, 0, 442,
1461, 346, 1281, 1249, 1806, 1706, 549, 1788, 11, 1779, 734, 1281, 1779, 0, 289, 919,
1282, 0, 1846, 1846, 1508, 1508, 1933, 91, 1823, 294, 0, 824, 0, 1653, 409, 528,
1621, 1936, 1292, 26, 0, 0, 256, 624, 326, 554, 149, 1987, 214, 1672, 409, 1569,
1706, 0, 942, 0, 1249, 1439, 0, 554, 0, 1701, 1701, 1774, 1524, 1363, 493, 651,
187, 1701, 1638, 0, 1576, 1936, 1938, 1256, 974, 503, 1676, 673, 0, 1374, 0, 587,
1569, 1303, 637, 74, 74, 0, 1689, 0, 411, 1746, 697, 598, 0, 1249, 422, 0,
1759, 1279, 1802, 1699, 1847, 1837, 559, 1783, 177, 177, 323, 1827, 374, 599, 634, 1246,
1019, 0, 957, 1564, 978, 1704, 191, 0, 68, 1426, 1938, 1189, 1174, 1993, 0, 496,
0, 3457, 1877, 426, 1159, 839, 907, 121, 426, 1682, 599, 1009, 959, 1484, 688, 0,
1659, 1657, 379, 567, 839, 0, 187, 1231, 419, 1827, 1607, 1939, 1918, 501, 1906, 1782,
1521, 779, 678, 686, 1734, 1292, 1804, 641, 0, 1302, 2597, 0, 974, 56, 0, 1952,
824, 1826, 501, 587, 456, 403, 948, 1524, 0, 1196, 238, 409, 1939, 1539, 1109, 0,
872, 3684, 96, 1249, 0, 1077, 0, 1844, 1954, 1466, 829, 1764, 1769, 441, 1174, 993,
1569, 1786, 638, 1823, 0, 64, 1742, 882, 892, 289, 914, 1734, 1231, 1877, 671, 0,
1946, 662, 0, 621, 622, 0, 0, 1806, 528, 594, 649, 1787, 864, 1524, 639, 397,
557, 442, 1388, 0, 0, 0, 1702, 1708, 728, 1951, 654, 914, 0, 14, 349, 1802,
1012, 0, 1801, 0, 0, 666, 0, 1683, 1727, 1734, 587, 1759, 1539, 776, 1582, 662,
689, 398, 1946, 1364, 1227, 1772, 1746, 1939, 521, 612, 997, 632, 1661, 1254, 1169, 1701,
1296, 877, 1804, 641, 674, 1258, 651, 656, 1926, 1471, 1987, 134, 0, 769, 639, 877,
158, 627, 598, 1117, 1772, 669, 0, 0, 1683, 1924, 704, 552, 41, 0, 1987, 1827,
1706, 97, 354, 614, 587, 1804, 1243, 1813, 808, 564, 814, 0, 838, 486, 442, 1702,
849, 0, 0, 0, 1834, 1627, 817, 548, 669, 641, 191, 1823, 958, 1547, 176, 1189,
1719, 0, 1637, 789, 1229, 1099, 459, 671, 1726, 1454, 1083, 1636, 1823, 1729, 1717, 0,
382, 1539, 702, 691, 137, 1604, 839, 1509, 1524, 829, 0, 1581, 732, 819, 802, 847,
1682, 1696, 1847, 614, 312, 0, 1379, 649, 4413, 1414, 442, 519, 1744, 0, 1499, 1777,
0, 0, 1799, 746, 1699, 552, 0, 346, 567, 0, 686, 1454, 852, 626, 1564, 1986,
324, 0, 302, 693, 1991, 1706, 1727, 1247, 503, 538, 1781, 867, 1578, 1946, 0, 564,
161, 1481, 1246, 411, 1937, 894, 1049, 686, 1582, 242, 829, 1924, 1227, 417, 1526, 1608,
1204, 289, 1834, 1079, 1831, 894, 459, 0, 674, 872, 907, 1807, 264, 1297, 607, 1834,
1084, 1461, 596, 227, 596, 1836, 802, 3129, 1281, 1781, 1258, 1606, 983, 1938, 0, 0,
56, 0, 0, 1384, 0, 1281, 0, 733, 639, 1454, 1836, 1414, 894, 1994, 357, 0,
649, 978, 0, 1706, 1832, 1836, 1463, 1464, 0, 614, 1953, 648, 1133, 1832, 0, 1622,
1297, 359, 426, 1896, 97, 1699, 1696, 314, 1681, 1686, 0, 1734, 134, 1684, 567, 463,
1783, 587, 1764, 973, 733, 947, 1811, 0, 1827, 586, 983, 1468, 958, 1856, 627, 1034,
528, 189, 0, 1169, 957, 849, 1249, 1249, 0, 1607, 249, 1682, 116, 1641, 978, 0,
0, 1758, 639, 1192, 646, 649, 597, 0, 1721, 0, 1809, 1909, 1472, 661, 1926, 617,
1574, 1832, 66, 993, 1471, 1636, 1466, 1823, 687, 1944, 0, 1291, 0, 0, 1781, 1576,
0, 634, 1837, 1037, 39, 0, 1302, 1976, 854, 837, 48, 0, 0, 0, 1671, 1471,
938, 1812, 239, 784, 0, 649, 1759, 887, 1682, 454, 0, 0, 1231, 669, 1784, 1577,
1837, 0, 1837, 847, 1793, 0, 1983, 1469, 734, 1569, 1563, 1661, 3376, 496, 1406, 997,
1899, 1472, 1804, 909, 427, 1243, 1681, 839, 0, 0, 1246, 1686, 0, 0, 1471, 1539,
1802, 1926, 1531, 1847, 1754, 1806, 1352, 629, 0, 1559, 1079, 1561, 1471, 1364, 1683, 1174,
204, 202, 1176, 1693, 121, 989, 472, 321, 564, 619, 1709, 1991, 312, 1939, 1742, 443,
662, 602, 471, 1993, 1581, 1597, 1546, 69, 659, 624, 533, 0, 564, 882, 1939, 1784,
1454, 938, 1812, 0, 919, 809, 897, 0, 86, 1571, 0, 1753, 599, 69, 76, 1939,
0, 754, 1464, 0, 311, 974, 22, 893, 598, 596, 0, 158, 407, 1821, 533, 938,
1284, 1832, 3711, 637, 0, 167, 1246, 1708, 639, 894, 887, 0, 0, 537, 241, 889,
0, 454, 1262, 837, 1783, 127, 659, 0, 227, 1641, 1159, 0, 1798, 0, 974, 1577,
1009, 1441, 554, 847, 808, 526, 837, 456, 0, 1762, 1801, 939, 1994, 943, 721, 914,
1196, 1484, 4413, 1911, 0, 1759, 614, 633, 649, 1781, 1503, 857, 261, 0, 1789, 651,
242, 1813, 0, 1753, 0, 519, 1812, 1726, 0, 0, 0, 849, 0, 1682, 1204, 1834,
659, 1231, 294, 624, 662, 1703, 1162, 637, 1171, 1682, 1539, 1257, 1257, 1709, 894, 1709,
1774, 1652, 617, 993, 1379, 0, 818, 1891, 0, 1804, 1939, 1671, 289, 1572, 167, 1772,
784, 0, 1449, 1637, 1951, 1388, 571, 69, 1436, 0, 157, 1483, 1627, 1243, 867, 1682,
1414, 1414, 182, 0, 182, 604, 656, 819, 174, 458, 0, 673, 1521, 1484, 1197, 0,
1847, 876, 589, 444, 564, 602, 1717, 649, 1436, 0, 0, 0, 807, 0, 1832, 0,
978, 1873, 291, 614, 1877, 1734, 1834, 838, 1474, 1729, 872, 1674, 1991, 1821, 769, 119,
848, 324, 1799, 24, 612, 0, 157, 0, 288, 289, 1804, 0, 1204, 689, 1564, 669,
636, 1987, 847, 1117, 1696, 0, 422, 1414, 637, 1546, 624, 203, 1564, 1526, 338, 1414,
0, 804, 86, 0, 973, 1471, 0, 0, 1109, 0, 1812, 967, 669, 1247, 69, 639,
562, 1362, 264, 554, 1581, 0, 1808, 369, 237, 599, 0, 809, 704, 8, 1242, 1987,
1682, 86, 503, 1861, 1812, 0, 794, 938, 0, 0, 649, 784, 914, 0, 919, 839,
1826, 1788, 0, 0, 662, 1812, 357, 523, 0, 1734, 1172, 1463, 76, 157, 989, 877,
0, 1244, 0, 0, 503, 86, 634, 1719, 892, 1276, 554, 1812, 1352, 839, 674, 1726,
1812, 1548, 369, 1734, 607, 0, 1951, 882, 804, 369, 407, 597, 804, 0, 0, 1812,
972, 639, 849, 649, 1813, 424, 0, 1804, 646, 1844, 157, 284, 1322, 648, 807, 407,
1504, 1836, 1987, 426, 1454, 828, 809, 0, 1297, 1821, 1257, 0, 519, 0, 0, 564,
1812, 1388, 1864, 0, 1784, 837, 973, 289, 1571, 0, 658, 157, 0, 564, 29, 1952,
808, 809, 1042, 1671, 897, 1302, 1718, 1784, 459, 1784, 1834, 633, 633, 989, 0, 306,
621, 1726, 0, 0, 587, 872, 1874, 0, 683, 0, 1734, 0, 1987, 1856, 1856, 119,
1787, 1249, 491, 423, 1113, 678, 1687, 0, 0, 892, 221, 0, 0, 0, 1782, 0,
0, 1019, 168, 859, 1306, 724, 374, 0, 1736, 1939, 521, 0, 1683, 1264, 0, 277,
643, 1931, 0, 0, 1919, 0, 0, 1734, 0, 874, 0, 1764, 689, 1574, 3682, 678,
1182, 1567, 0, 93, 1786, 1626, 0, 1954, 4397, 323, 4182, 1472, 849, 189, 779, 0,
596, 1519, 809, 1621, 0, 1759, 557, 1302, 864, 0, 1787, 1751, 0, 1718, 1807, 1701,
0, 1792, 1474, 529, 1627, 0, 1856, 734, 586, 819, 1254, 1952, 1763, 1931, 1243, 1781,
622, 521, 1902, 0, 728, 0, 407, 1446, 1799, 624, 0, 1579, 669, 1334, 0, 1706,
442, 678, 0, 1243, 1621, 0, 1623, 1672, 548, 1196, 813, 1783, 1759, 426, 0, 1352,
597, 0, 1826, 0, 1771, 0, 697, 0, 0, 1781, 554, 1974, 1296, 314, 1922, 0,
1704, 0, 0, 552, 1784, 614, 964, 687, 299, 54, 422, 869, 786, 0, 1652, 1706,
264, 1702, 586, 168, 0, 1839, 656, 0, 429, 0, 0, 0, 0, 0, 1736, 1986,
1784, 1784, 1804, 0, 0, 0, 1317, 0, 0, 0, 1466, 0, 1446, 0, 0, 0,
0, 177, 472, 782, 1944, 364, 1714, 621, 0, 849, 1761, 1741, 617, 1291, 646, 0,
1811, 0, 1683, 1641, 1606, 1706, 1133, 0, 444, 1781, 678, 0, 1834, 957, 1429, 1684,
1897, 1739, 1287, 1357, 957, 614, 1759, 1919, 1681, 407, 1292, 0, 1787, 0, 1953, 0,
1223, 0, 46, 597, 0, 0, 0, 0, 71, 0, 1649, 1577, 0, 1436, 0, 0,
618, 1732, 1709, 0, 1706, 1849, 731, 569, 1706, 1848, 1747, 0, 0, 0, 0, 1771,
998, 0, 1812, 0, 1352, 494, 0, 1264, 876, 1706, 69, 76, 241, 894, 646, 3977,
1804, 887, 427, 0, 1804, 1596, 0, 1999, 1849, 599, 1802, 0, 22, 0, 0, 554,
1834, 1334, 678, 939, 0, 1441, 0, 0, 646, 1706, 1708, 0, 1804, 1726, 189, 617,
288, 1799, 1257, 1317, 1784, 1716, 1267, 2021, 306, 374, 1461, 656, 0, 0, 857, 1834,
867, 0, 1446, 0, 407, 1784, 1772, 809, 624, 1579, 1804, 673, 964, 0, 0, 1812,
1834, 1804, 1767, 0, 284, 1874, 119, 1549, 1804, 0, 0, 0, 623, 1952, 1734, 0,
1684, 1804, 1732, 0, 624, 1564, 1117, 0, 1756, 1718, 0, 1771, 669, 197, 299, 1794,
569, 809, 982, 1352, 0, 1009, 49, 1384, 0, 0, 22, 0, 618, 1519, 0, 0,
892, 0, 0, 1784, 1706, 0, 0, 1799, 0, 1323, 1844, 809, 0, 659, 192, 519,
0, 0, 972, 1578, 0, 0, 808, 872, 259, 1834, 4418, 0, 1162, 1931, 0, 0,
1837, 9, 1682, 0, 0, 697, 444, 1797, 29, 331, 1797, 1792, 2008, 1503, 398, 1172,
217, 731, 1866, 0, 1261, 0, 1262, 1209, 38, 1174, 1447, 646, 1167, 357, 0, 1832,
1897, 0, 332, 43, 0, 216, 1828, 0, 357, 1777, 181, 1112, 0, 1224, 682, 1012,
1561, 1018, 817, 1339, 941, 0, 947, 1019, 0, 1704, 1782, 0, 1993, 0, 649, 503,
1754, 0, 1466, 1018, 313, 1256, 1302, 1302, 1994, 1589, 1706, 942, 741, 1256, 1703, 504,
1706, 837, 837, 0, 636, 461, 1937, 56, 1302, 1377, 357, 689, 641, 646, 426, 1206,
731, 993, 729, 202, 0, 54, 914, 664, 927, 0, 1684, 837, 0, 1627, 468, 1262,
1706, 804, 357, 864, 29, 1211, 97, 1706, 196, 1683, 782, 0, 1303, 1303, 27, 409,
1292, 0, 152, 0, 551, 471, 1974, 523, 928, 1827, 724, 0, 0, 1777, 0, 611,
1974, 1848, 777, 1113, 312, 1339, 1941, 0, 54, 1201, 689, 1302, 1466, 1182, 1712, 0,
597, 874, 419, 0, 1078, 0, 1829, 498, 1769, 686, 289, 97, 504, 1718, 1107, 612,
578, 658, 567, 1919, 637, 1774, 1439, 0, 1352, 1479, 1627, 818, 357, 1712, 1471, 769,
1931, 1834, 1551, 1832, 69, 0, 1707, 694, 837, 1712, 1807, 1541, 812, 54, 1939, 1782,
1426, 839, 554, 1718, 671, 0, 0, 1726, 33, 0, 1077, 76, 802, 0, 864, 646,
0, 786, 1784, 538, 0, 972, 161, 1801, 1939, 1931, 0, 968, 111, 254, 1451, 864,
0, 912, 597, 1996, 0, 1683, 426, 1696, 1837, 1741, 1951, 946, 1684, 211, 1719, 1641,
1779, 1047, 1734, 641, 592, 71, 1827, 1827, 957, 147, 1792, 1551, 97, 0, 602, 1837,
1531, 928, 1837, 281, 1834, 1471, 0, 0, 0, 1926, 1263, 0, 939, 674, 653, 1009,
1911, 157, 22, 0, 0, 0, 0, 697, 69, 69, 617, 1241, 0, 1759, 1974, 1726,
857, 1709, 1726, 1479, 0, 659, 472, 694, 357, 624, 769, 1718, 1734, 1563, 1718, 1771,
1107, 0, 634, 1362, 967, 864, 1826, 523, 1479, 0, 1563, 1719, 972, 1322, 611, 1047,
912, 1718, 1247, 697, 1762, 984, 1762, 3419, 892, 1834, 1539, 1677, 0, 448, 336, 0,
0, 636, 587, 314, 211, 456, 683, 1832, 1248, 1833, 1787, 928, 0, 1703, 0, 992,
664, 1777, 421, 0, 44, 1844, 697, 1848, 697, 1672, 0, 957, 286, 1222, 1683, 612,
1719, 1261, 872, 284, 1799, 456, 1227, 324, 49, 1762, 1708, 96, 238, 0, 641, 1916,
1234, 0, 731, 1317, 0, 1461, 1567, 2008, 641, 992, 1436, 878, 69, 1926, 1926, 697,
404, 882, 666, 659, 649, 0, 521, 1716, 1946, 493, 1781, 1754, 1787, 1758, 914, 0,
1951, 0, 0, 1772, 438, 398, 1723, 1792, 1254, 582, 526, 191, 0, 36, 1189, 0,
291, 1744, 627, 0, 382, 182, 314, 1703, 1702, 182, 704, 0, 54, 1623, 1719, 203,
552, 1762, 0, 1292, 1764, 812, 838, 1754, 442, 877, 1777, 1706, 872, 839, 666, 848,
1558, 0, 0, 1673, 0, 0, 1908, 0, 0, 0, 686, 176, 0, 1687, 0, 0,
323, 204, 1987, 1187, 181, 598, 1247, 0, 786, 161, 1247, 63, 1673, 894, 242, 518,
1783, 326, 54, 867, 1277, 1202, 1162, 0, 1987, 0, 404, 0, 1287, 0, 0, 627,
1833, 949, 957, 226, 1761, 0, 1741, 284, 0, 0, 646, 1683, 0, 614, 1732, 211,
1257, 1969, 1787, 0, 1302, 1712, 0, 1839, 0, 1048, 597, 1811, 1832, 0, 1374, 1414,
877, 0, 1352, 1558, 1792, 1849, 0, 666, 669, 1812, 928, 0, 0, 1577, 839, 812,
526, 1929, 1261, 271, 0, 1918, 1792, 9, 0, 1637, 0, 0, 1966, 241, 668, 1801,
263, 241, 1247, 840, 0, 167, 1292, 1762, 22, 848, 962, 1911, 0, 0, 1811, 0,
894, 0, 306, 0, 142, 1772, 0, 294, 867, 0, 697, 0, 617, 0, 1242, 673,
407, 666, 877, 636, 0, 1283, 9, 69, 119, 1297, 1873, 291, 0, 1849, 0, 769,
612, 1414, 1549, 0, 0, 1833, 669, 442, 86, 197, 1689, 264, 0, 1708, 1991, 1762,
1368, 634, 454, 827, 0, 839, 1939, 0, 840, 0, 1287, 1901, 526, 0, 0, 882,
0, 0, 1864, 0, 1811, 972, 1721, 1732, 519, 298, 1864, 612, 506, 97, 332, 1182,
599, 1937, 1212, 39, 1322, 839, 1663, 1472, 651, 1256, 0, 0, 413, 0, 1694, 1156,
421, 947, 1652, 0, 872, 1802, 1227, 237, 33, 0, 0, 186, 0, 294, 968, 104,
222, 1227, 71, 1949, 1926, 837, 237, 1812, 1249, 0, 0, 314, 1156, 967, 1966, 64,
869, 1894, 1703, 1204, 286, 1694, 1811, 1783, 456, 284, 1464, 1607, 1607, 551, 162, 1466,
0, 1461, 158, 158, 0, 1466, 1536, 0, 1824, 1493, 894, 443, 1823, 62, 429, 1107,
1607, 1827, 643, 1461, 0, 324, 0, 1037, 324, 1226, 1623, 604, 336, 1929, 1856, 967,
69, 0, 0, 0, 877, 164, 1018, 1847, 409, 442, 486, 1607, 664, 664, 1303, 1684,
0, 1607, 0, 1607, 1174, 0, 0, 0, 0, 877, 59, 1928, 1759, 1018, 0, 134,
1607, 0, 69, 277, 1939, 904, 1247, 904, 0, 1801, 406, 604, 1832, 1832, 0, 704,
1804, 0, 1832, 332, 197, 604, 2791, 1979, 636, 1673, 651, 0, 0, 1643, 827, 636,
146, 0, 332, 1643, 869, 0, 651, 197, 0, 332, 332, 1203, 1099, 289, 1481, 1481,
1939, 1802, 217, 0, 336, 68, 661, 857, 491, 471, 684, 0, 0, 1439, 0, 1139,
839, 1787, 179, 1827, 26, 664, 0, 1247, 0, 0, 69, 1804, 839, 1999, 216, 426,
1954, 1184, 1202, 456, 381, 236, 1799, 0, 288, 1928, 402, 1938, 1597, 686, 637, 419,
686, 1436, 641, 1762, 1899, 94, 0, 1931, 1821, 674, 1302, 192, 1626, 1802, 661, 1683,
622, 378, 1788, 0, 1939, 577, 1778, 959, 354, 674, 1726, 1629, 0, 942, 1203, 1726,
1541, 1241, 839, 1939, 272, 0, 1704, 1426, 817, 1479, 614, 1717, 0, 61, 0, 518,
1572, 419, 927, 927, 186, 639, 1608, 11, 1939, 69, 69, 626, 504, 366, 381, 1683,
1831, 264, 1778, 1952, 0, 289, 1464, 0, 1939, 1834, 592, 426, 799, 1787, 0, 1637,
1833, 536, 0, 614, 759, 643, 1806, 1804, 889, 1409, 697, 189, 1706, 516, 1804, 1686,
637, 216, 36, 624, 877, 154, 1479, 1139, 321, 277, 83, 1571, 0, 76, 1464, 254,
913, 1804, 1999, 196, 1914, 1904, 0, 0, 1307, 0, 889, 889, 1009, 1277, 1808, 1813,
617, 0, 857, 882, 0, 0, 817, 1717, 419, 289, 0, 0, 7, 36, 649, 0,
529, 0, 1834, 1681, 1804, 0, 1203, 828, 839, 1483, 286, 0, 324, 0, 804, 83,
639, 186, 1788, 1763, 661, 1931, 0, 839, 634, 804, 639, 321, 1763, 1813, 1808, 1297,
1821, 1571, 321, 0, 0, 897, 96, 0, 528, 27, 401, 306, 2901, 32, 33, 1272,
1874, 1874, 1874, 949, 2805, 0, 661, 617, 526, 238, 872, 466, 0, 0, 658, 1198,
466, 7, 382, 564, 0, 69, 1673, 0, 0, 1706, 7, 1166, 564, 619, 564, 0,
0, 0, 0, 0, 1232, 0, 658, 0, 0, 0, 839, 1213, 0, 659, 1202, 458,
1184, 1949, 702, 0, 266, 1309, 0, 503, 702, 702, 1949, 1896, 0, 1908, 357, 993,
0, 0, 1832, 51, 1916, 1941, 1192, 0, 1812, 567, 1804, 0, 1673, 567, 19, 1908,
1782, 3146, 567, 1832, 781, 0, 454, 299, 1172, 0, 1292, 3969, 299, 894, 1908, 967,
0, 3169, 0, 3146, 1172, 519, 11, 892, 0, 1946, 294, 0, 1782, 839, 1019, 336,
458, 1756, 942, 942, 1937, 1249, 0, 1762, 4221, 373, 1277, 1709, 1174, 0, 374, 0,
0, 1468, 0, 628, 979, 1171, 0, 983, 286, 957, 949, 3219, 1019, 751, 1474, 0,
1934, 1828, 1461, 1759, 0, 1928, 0, 0, 0, 1802, 1468, 959, 0, 1954, 1926, 1926,
977, 0, 1836, 1939, 1079, 1994, 1994, 168, 1898, 1764, 0, 0, 882, 1546, 0, 972,
0, 1802, 398, 997, 1514, 186, 779, 694, 1012, 1929, 1614, 1787, 1783, 1009, 1944, 0,
4454, 1931, 0, 1556, 1449, 554, 613, 314, 0, 0, 694, 382, 1673, 1719, 1706, 789,
804, 648, 1438, 0, 534, 1674, 834, 0, 0, 864, 1777, 671, 1931, 0, 804, 1549,
694, 1509, 1546, 356, 0, 69, 1019, 626, 1079, 894, 466, 662, 113, 1948, 1831, 626,
0, 0, 0, 0, 0, 0, 0, 0, 957, 358, 0, 0, 1609, 782, 466, 1374,
949, 1759, 401, 374, 982, 198, 0, 972, 1691, 754, 0, 176, 731, 1533, 1711, 1837,
0, 997, 937, 1774, 0, 1914, 0, 326, 751, 1009, 1514, 241, 886, 186, 937, 1213,
181, 526, 968, 614, 1514, 1216, 0, 1267, 1242, 1953, 309, 1463, 1514, 858, 0, 0,
719, 1799, 1769, 1627, 1702, 867, 529, 649, 0, 9, 624, 1906, 648, 503, 0, 1297,
0, 0, 126, 0, 1771, 0, 0, 967, 0, 1222, 977, 0, 779, 697, 1761, 978,
634, 0, 0, 882, 519, 938, 0, 204, 1578, 719, 1953, 947, 666, 0, 1834, 0,
1877, 0, 1473, 1803, 0, 1936, 0, 1463, 1813, 688, 0, 658, 272, 363, 8, 658,
1891, 1841, 29, 1472, 339, 0, 636, 1993, 456, 1704, 1656, 756, 461, 1706, 407, 779,
294, 928, 1426, 286, 0, 839, 441, 0, 0, 1756, 0, 0, 1249, 718, 664, 1221,
384, 1779, 1201, 1922, 1782, 1549, 1966, 171, 374, 0, 1784, 0, 426, 403, 0, 1898,
2006, 1834, 731, 1561, 0, 313, 1904, 1926, 384, 419, 1018, 1954, 797, 71, 1128, 1229,
1196, 872, 1182, 801, 1234, 96, 0, 1461, 1852, 9, 839, 882, 1627, 0, 839, 779,
203, 741, 0, 1951, 0, 526, 0, 1047, 637, 894, 624, 0, 914, 738, 1742, 1782,
349, 0, 1706, 0, 0, 1519, 1712, 1266, 0, 0, 0, 0, 741, 1726, 759, 0,
812, 0, 1832, 0, 1712, 943, 0, 0, 171, 1604, 1699, 877, 1814, 942, 1309, 1784,
1426, 788, 503, 0, 601, 893, 178, 648, 0, 1526, 0, 1261, 1197, 0, 222, 746,
1931, 1247, 0, 1281, 867, 702, 96, 339, 0, 326, 0, 0, 894, 9, 1549, 1309,
0, 51, 0, 366, 1703, 1247, 907, 1673, 323, 461, 54, 1249, 178, 0, 1782, 332,
336, 1950, 1696, 662, 1811, 73, 0, 69, 1684, 1519, 1926, 364, 1712, 294, 0, 1048,
1199, 648, 314, 1574, 147, 1926, 0, 0, 426, 1761, 1309, 1309, 928, 0, 1083, 0,
0, 237, 0, 1524, 1577, 44, 602, 0, 783, 1403, 828, 271, 1607, 642, 1706, 847,
1172, 1684, 0, 0, 1922, 731, 797, 0, 0, 533, 1966, 649, 0, 22, 1196, 894,
893, 719, 218, 178, 0, 828, 0, 1249, 3507, 1249, 261, 0, 1284, 234, 0, 636,
0, 0, 1297, 1891, 309, 649, 0, 867, 0, 1572, 617, 1172, 1852, 1266, 311, 839,
0, 656, 1708, 1913, 1267, 371, 648, 24, 0, 567, 0, 0, 827, 0, 203, 0,
1309, 294, 1804, 651, 1201, 0, 1832, 86, 0, 9, 0, 646, 1834, 1368, 967, 0,
0, 97, 0, 989, 108, 1717, 779, 828, 828, 1939, 839, 839, 407, 1309, 1182, 1811,
0, 882, 882, 1009, 97, 1501, 0, 0, 2014, 1782, 1474, 1247, 838, 1342, 1454, 1794,
1524, 1247, 1561, 929, 664, 1791, 1716, 1938, 1247, 1938, 61, 369, 1944, 0, 1801, 1472,
1829, 1937, 1916, 442, 444, 974, 2008, 1936, 1544, 0, 2029, 1296, 599, 1954, 1462, 1549,
237, 152, 972, 918, 1833, 1722, 0, 1611, 1214, 1951, 528, 1712, 0, 639, 0, 1926,
469, 0, 669, 1464, 451, 0, 0, 298, 634, 1581, 1247, 0, 519, 2019, 0, 894,
93, 3169, 298, 0, 894, 157, 0, 0, 702, 0, 1709, 1806, 0, 634, 1926, 442,
1837, 1702, 1837, 1441, 1602, 1801, 957, 1521, 314, 0, 1987, 1926, 1812, 639, 0, 0,
1521, 929, 1761, 0, 1761, 0, 1834, 1708, 636, 1524, 157, 289, 624, 1547, 838, 0,
972, 298, 839, 1322, 1844, 0, 1864, 829, 1357, 1833, 1832, 837, 0, 1277, 567, 1636,
1754, 1521, 0, 1636, 0, 147, 458, 0, 1716, 93, 1082, 1291, 1291, 4443, 423, 947,
0, 731, 983, 0, 671, 68, 1936, 0, 974, 0, 0, 0, 1077, 839, 1827, 2006,
1201, 97, 0, 1009, 184, 0, 1277, 1786, 0, 1939, 312, 1482, 689, 1993, 1567, 636,
2681, 0, 0, 0, 0, 0, 1991, 1939, 661, 0, 359, 1802, 0, 624, 1117, 0,
1706, 0, 812, 441, 704, 1509, 918, 0, 458, 671, 1602, 182, 1637, 1446, 1509, 0,
907, 894, 504, 1706, 1338, 1984, 44, 34, 636, 1936, 1939, 788, 832, 0, 731, 93,
197, 0, 1834, 1536, 0, 0, 1801, 0, 71, 0, 0, 66, 1144, 661, 1943, 1996,
1756, 2681, 299, 1688, 0, 0, 1834, 639, 0, 1928, 0, 299, 644, 636, 468, 468,
503, 0, 1549, 1352, 639, 721, 1019, 118, 972, 1939, 639, 118, 1536, 636, 1813, 1688,
526, 1414, 0, 0, 617, 0, 638, 1549, 1267, 0, 656, 1986, 1627, 0, 0, 1549,
1117, 1414, 624, 1323, 1144, 0, 0, 639, 1647, 1688, 0, 634, 779, 918, 76, 0,
1322, 1986, 0, 0, 1767, 1661, 681, 1287, 1706, 1287, 3246, 1834, 0, 673, 1794, 211,
1981, 1636, 0, 1274, 1903, 1793, 71, 47, 1793, 93, 1661, 1987, 857, 1269, 329, 1701,
526, 1792, 1939, 216, 1794, 1613, 659, 216, 678, 1729, 0, 0, 259, 1696, 289, 756,
731, 0, 634, 1536, 0, 781, 354, 0, 1809, 1696, 1661, 1779, 1832, 689, 1287, 1792,
1792, 1613, 859, 1833, 1607, 329, 689, 857, 1706, 0, 781, 216, 0, 0, 773, 882,
181, 264, 0, 526, 259, 1269, 0, 354, 1874, 0, 1274, 839, 0, 1472, 0, 1256,
0, 587, 733, 947, 0, 421, 1484, 1449, 1298, 1909, 1954, 0, 882, 94, 674, 674,
1911, 33, 1524, 704, 587, 1627, 1528, 0, 0, 0, 1484, 674, 0, 662, 1229, 361,
837, 0, 0, 0, 0, 0, 674, 459, 674, 1952, 1952, 824, 0, 1832, 187, 456,
942, 491, 1672, 358, 636, 561, 26, 0, 637, 1848, 1919, 1553, 0, 0, 1837, 599,
461, 1729, 1277, 69, 68, 648, 0, 0, 1436, 1466, 642, 312, 0, 1054, 186, 0,
839, 0, 992, 46, 1612, 1524, 442, 0, 59, 0, 277, 1993, 314, 872, 1877, 1127,
442, 498, 407, 641, 733, 409, 1473, 0, 1233, 1474, 646, 1287, 3382, 0, 71, 0,
526, 0, 0, 0, 1794, 1718, 68, 1287, 794, 308, 658, 666, 1302, 1553, 1362, 402,
776, 4454, 1628, 0, 277, 0, 134, 0, 754, 0, 69, 1431, 0, 1931, 134, 0,
1847, 1637, 1162, 837, 812, 688, 518, 648, 0, 1628, 0, 0, 182, 1544, 1474, 1954,
2027, 1728, 1446, 1622, 134, 1782, 469, 769, 456, 197, 776, 464, 0, 1702, 1256, 0,
648, 0, 802, 0, 51, 69, 69, 474, 187, 0, 1831, 646, 299, 501, 187, 1931,
1284, 1429, 1948, 894, 97, 636, 867, 1544, 704, 442, 1896, 501, 746, 1257, 0, 678,
222, 518, 1839, 0, 264, 0, 1877, 1274, 1659, 912, 286, 1726, 1384, 649, 0, 71,
0, 1721, 1718, 0, 1926, 1743, 0, 1802, 1954, 1844, 0, 0, 0, 0, 1726, 0,
662, 617, 0, 0, 409, 212, 1969, 1206, 0, 1954, 587, 1274, 592, 0, 1741, 1257,
0, 784, 1472, 888, 1847, 567, 0, 0, 196, 466, 418, 1384, 1931, 496, 1099, 1259,
1728, 259, 491, 1177, 358, 839, 69, 1309, 202, 1431, 187, 1954, 0, 882, 807, 0,
104, 837, 624, 69, 312, 0, 1781, 1197, 118, 1969, 0, 1213, 351, 1833, 989, 1966,
1877, 1708, 529, 1802, 0, 158, 754, 254, 0, 1874, 636, 528, 1539, 888, 274, 894,
1083, 1556, 259, 326, 1556, 824, 364, 852, 0, 97, 0, 0, 294, 857, 286, 324,
443, 648, 993, 784, 0, 1267, 306, 617, 1553, 817, 1861, 1726, 894, 1474, 0, 0,
1167, 0, 0, 458, 0, 0, 0, 1782, 98, 291, 0, 1896, 496, 1256, 847, 104,
1949, 804, 0, 807, 0, 1832, 1844, 562, 1926, 1567, 1604, 0, 197, 637, 0, 1247,
1597, 0, 0, 406, 1484, 0, 1256, 634, 1597, 894, 892, 646, 1659, 1812, 0, 804,
3382, 0, 0, 807, 1256, 1844, 1941, 1297, 0, 71, 364, 1864, 837, 0, 912, 1812,
1844, 0, 1834, 973, 312, 407, 0, 0, 1461, 1148, 567, 829, 1716, 1993, 1338, 269,
1914, 1256, 683, 68, 408, 1704, 0, 0, 1357, 423, 69, 264, 1808, 947, 0, 0,
599, 26, 839, 0, 689, 1234, 1009, 251, 3582, 0, 0, 1539, 1614, 839, 1706, 1539,
0, 1627, 1991, 134, 1844, 1946, 867, 1971, 33, 0, 424, 397, 1296, 567, 852, 1719,
0, 852, 119, 671, 838, 1844, 0, 0, 0, 264, 34, 1911, 867, 1999, 671, 538,
601, 1461, 1398, 0, 0, 1357, 0, 592, 1758, 1999, 597, 649, 1861, 237, 837, 0,
444, 1946, 54, 0, 1753, 466, 1577, 1293, 641, 126, 0, 0, 972, 1461, 424, 1871,
721, 654, 1007, 0, 0, 0, 0, 852, 654, 0, 69, 0, 1483, 0, 808, 1144,
1642, 1099, 839, 0, 312, 1099, 1614, 809, 974, 0, 681, 4209, 0, 336, 681, 0,
639, 146, 1949, 1772, 1841, 587, 1831, 567, 1672, 1339, 1688, 1687, 1292, 1029, 1303, 353,
1113, 436, 639, 1481, 227, 1201, 1929, 1426, 587, 1938, 637, 421, 1847, 1337, 288, 666,
1539, 413, 1558, 0, 0, 0, 0, 668, 441, 1939, 0, 1993, 196, 0, 1896, 3328,
1709, 442, 1734, 1461, 0, 1954, 1299, 0, 1954, 1449, 459, 1786, 442, 1657, 1608, 284,
204, 1471, 1941, 1717, 2008, 678, 39, 1297, 0, 0, 2019, 587, 671, 1339, 557, 1734,
3162, 1951, 197, 509, 33, 697, 779, 0, 239, 0, 0, 1581, 1732, 759, 658, 1301,
0, 914, 1764, 61, 0, 0, 2978, 1627, 1352, 1919, 1806, 828, 0, 1304, 1759, 451,
332, 1628, 1521, 654, 0, 624, 697, 1937, 648, 694, 186, 978, 1929, 918, 0, 1292,
1481, 43, 0, 1726, 612, 1276, 488, 0, 1602, 1754, 0, 0, 1709, 442, 1622, 1547,
0, 788, 441, 671, 599, 0, 1782, 0, 0, 639, 1759, 1338, 1996, 867, 222, 839,
919, 852, 197, 1303, 0, 0, 1247, 1983, 0, 1673, 1259, 1719, 1479, 1682, 1284, 1582,
1673, 461, 1678, 63, 1979, 113, 0, 264, 907, 878, 1248, 1909, 69, 166, 872, 977,
1249, 1246, 1607, 0, 533, 2001, 1709, 1991, 0, 853, 668, 416, 1372, 0, 1834, 1998,
407, 919, 1759, 0, 1444, 639, 1759, 1721, 646, 734, 1719, 1368, 977, 636, 364, 1944,
314, 992, 0, 1837, 332, 48, 1521, 1291, 71, 613, 486, 0, 978, 0, 444, 1683,
1632, 496, 983, 1732, 849, 0, 74, 1849, 0, 1602, 506, 1939, 0, 0, 0, 0,
0, 1837, 1998, 1759, 1467, 1681, 0, 0, 1812, 669, 1804, 1979, 1079, 41, 503, 1172,
1949, 646, 149, 1304, 1401, 1849, 1712, 261, 0, 0, 1581, 444, 1847, 1928, 468, 1364,
597, 1859, 1597, 1719, 1539, 1277, 1999, 1581, 0, 114, 69, 2927, 0, 837, 1556, 1783,
1528, 1999, 827, 1969, 1259, 939, 1937, 918, 1019, 1213, 849, 972, 1762, 1998, 639, 1436,
1549, 407, 919, 63, 1801, 1266, 984, 1792, 1263, 627, 1716, 1709, 1996, 1754, 0, 0,
1549, 1266, 1891, 271, 1936, 1439, 1398, 867, 687, 406, 857, 0, 2021, 649, 1329, 158,
1373, 1754, 624, 604, 0, 0, 1263, 1847, 280, 1467, 624, 1709, 0, 648, 651, 612,
1266, 0, 664, 658, 69, 157, 1804, 1047, 1549, 1804, 1429, 1756, 639, 86, 1258, 807,
103, 1771, 2013, 639, 0, 0, 1009, 829, 1732, 2013, 779, 1826, 1759, 827, 1716, 157,
658, 892, 157, 1811, 112, 1721, 1716, 1706, 2013, 912, 1388, 299, 808, 0, 0, 974,
681, 1831, 587, 1949, 1259, 567, 1841, 637, 1672, 779, 639, 1339, 1683, 1847, 587, 227,
1201, 1426, 461, 1029, 1339, 1999, 907, 421, 1938, 1687, 413, 1954, 1929, 1113, 1481, 1719,
459, 1734, 442, 849, 2008, 1461, 1709, 1936, 1941, 1949, 39, 442, 204, 1449, 1804, 671,
284, 43, 1352, 3162, 759, 1329, 332, 557, 624, 2978, 1764, 654, 914, 697, 658, 1628,
488, 1726, 694, 1754, 1709, 1547, 1581, 639, 1602, 639, 1759, 872, 0, 1759, 1248, 416,
166, 1444, 533, 1467, 1682, 977, 1479, 63, 197, 0, 878, 1303, 1996, 1909, 1673, 919,
1979, 1991, 734, 1721, 646, 978, 808, 1602, 983, 636, 1849, 624, 1521, 222, 364, 74,
1719, 496, 1979, 613, 314, 918, 71, 992, 1837, 669, 444, 1364, 1928, 2927, 261, 468,
157, 837, 1804, 646, 86, 1213, 939, 827, 1811, 1556, 984, 1266, 1732, 857, 1439, 1891,
651, 1258, 1266, 612, 658, 2013, 438, 0, 461, 438, 1306, 0, 0, 96, 1227, 1724,
0, 0, 1811, 1811, 1284, 1714, 519, 2021, 1572, 1913, 1249, 1694, 1811, 827, 1572, 892,
519, 1678, 0, 0, 1678, 553, 0, 912, 442, 0, 402, 501, 1953, 686, 947, 503,
992, 461, 29, 509, 0, 694, 442, 1464, 1783, 1919, 2019, 513, 234, 1834, 1939, 0,
402, 808, 1483, 1521, 1202, 929, 878, 29, 402, 837, 166, 1684, 69, 639, 1891, 1627,
0, 636, 694, 974, 0, 912, 1202, 636, 636, 897, 1787, 973, 1261, 277, 958, 0,
0, 1828, 422, 0, 466, 1789, 503, 0, 0, 0, 872, 1706, 1954, 311, 1751, 1263,
1802, 1719, 1352, 1312, 1312, 1263, 612, 1556, 1719, 1804, 0, 0, 1257, 1832, 486, 662,
1576, 1837, 1706, 407, 0, 422, 1436, 648, 827, 486, 1756, 1788, 159, 1833, 494, 1804,
191, 1691, 421, 587, 189, 189, 264, 444, 0, 1193, 1804, 799, 1804, 1201, 872, 857,
1939, 686, 1707, 0, 1722, 1706, 0, 416, 1267, 624, 621, 1726, 1429, 0, 651, 312,
264, 418, 299, 1429, 0, 1954, 648, 0, 189, 1206, 1996, 1672, 621, 594, 567, 569,
554, 22, 1211, 1804, 847, 1833, 0, 867, 1191, 1267, 22, 406, 1804, 624, 1761, 299,
1794, 818, 0, 728, 949, 1923, 1247, 498, 0, 728, 0, 332, 397, 1488, 1368, 397,
1034, 361, 828, 0, 1993, 486, 169, 564, 1847, 29, 0, 1802, 1524, 0, 641, 689,
631, 202, 819, 0, 637, 1576, 1158, 887, 1124, 653, 1178, 0, 887, 636, 819, 0,
1826, 1009, 607, 398, 1078, 336, 1797, 276, 1528, 1277, 0, 188, 0, 286, 587, 488,
0, 0, 1099, 286, 0, 0, 872, 1931, 1828, 0, 857, 882, 1937, 1107, 0, 397,
637, 1616, 536, 0, 847, 0, 1469, 0, 1224, 0, 689, 0, 313, 537, 1687, 1759,
0, 241, 339, 0, 1622, 0, 0, 782, 847, 784, 241, 0, 1691, 0, 0, 847,
241, 22, 1466, 1528, 1621, 784, 1099, 1937, 286, 1107, 0, 0, 0, 1621, 882, 1834,
1099, 0, 1524, 1539, 1804, 1539, 1524, 1919, 1919, 1359, 1804, 829, 636, 0, 0, 1792,
471, 0, 614, 616, 0, 1339, 1729, 0, 1948, 1836, 359, 461, 1352, 456, 0, 1699,
162, 503, 1936, 1277, 441, 417, 0, 0, 1179, 646, 412, 1981, 1827, 1029, 16, 738,
0, 491, 1834, 0, 1792, 1247, 0, 1258, 1706, 0, 419, 0, 673, 1569, 1464, 1943,
1914, 1732, 1464, 1684, 1949, 332, 288, 419, 27, 1234, 1297, 0, 2554, 506, 1566, 1993,
756, 1936, 0, 0, 1994, 441, 1179, 1926, 1717, 2029, 1186, 643, 1469, 1936, 46, 0,
1296, 597, 0, 188, 1809, 1756, 1786, 882, 349, 708, 892, 674, 1128, 1781, 43, 764,
1802, 521, 548, 472, 349, 186, 656, 1746, 1746, 397, 14, 582, 1207, 1067, 1994, 0,
1931, 1613, 1936, 0, 0, 1732, 264, 1732, 934, 934, 638, 0, 0, 769, 1389, 4369,
1247, 1048, 973, 1117, 897, 1674, 97, 1688, 1673, 1292, 658, 674, 0, 581, 273, 897,
0, 1623, 957, 227, 1464, 1732, 305, 2016, 0, 1751, 0, 1656, 1181, 182, 0, 443,
354, 1656, 1094, 1048, 0, 0, 912, 0, 848, 1914, 264, 0, 0, 1507, 1202, 0,
0, 0, 0, 694, 1979, 0, 1608, 1058, 672, 0, 799, 1799, 1781, 1338, 1464, 234,
443, 443, 686, 417, 1261, 1674, 349, 0, 537, 1996, 339, 1699, 957, 0, 1969, 1939,
249, 912, 1158, 0, 11, 1741, 1048, 1484, 0, 1038, 0, 1943, 1357, 384, 1391, 1637,
1791, 649, 1683, 658, 1832, 0, 364, 69, 162, 444, 1719, 1079, 1608, 1664, 1597, 1648,
2543, 1258, 918, 1686, 0, 0, 1539, 1979, 472, 1804, 97, 857, 636, 1202, 0, 466,
0, 89, 0, 162, 0, 537, 0, 207, 76, 653, 441, 1577, 1007, 1706, 1966, 919,
656, 0, 887, 1939, 1768, 0, 869, 1627, 1197, 1079, 209, 857, 264, 0, 1792, 0,
407, 1937, 656, 1439, 596, 264, 1379, 1721, 1547, 424, 1811, 1436, 1956, 288, 769, 1117,
1652, 847, 69, 1821, 697, 204, 1804, 693, 799, 848, 1406, 0, 503, 1247, 0, 89,
1771, 1049, 634, 1869, 0, 76, 0, 771, 799, 1781, 892, 599, 1855, 913, 1297, 1869,
897, 1077, 1855, 177, 0, 1699, 777, 1866, 867, 524, 1994, 0, 1099, 199, 639, 466,
0, 0, 1099, 1939, 1939, 0, 0, 332, 1936, 1751, 1567, 1926, 684, 0, 1832, 146,
1793, 1832, 191, 0, 1709, 684, 1832, 1833, 4241, 688, 684, 1739, 1452, 1454, 1454, 0,
1474, 1571, 1481, 0, 1608, 1574, 1244, 1244, 518, 0, 0, 213, 1514, 1712, 1703, 1946,
296, 212, 1436, 1803, 0, 1161, 1569, 0, 38, 212, 557, 413, 36, 68, 599, 1941,
649, 121, 872, 1952, 1877, 379, 97, 1717, 473, 212, 1712, 892, 1287, 1177, 1706, 761,
442, 0, 427, 0, 1446, 1832, 0, 1623, 0, 1683, 0, 968, 0, 0, 617, 1478,
664, 74, 1009, 332, 0, 44, 146, 1804, 1531, 121, 127, 887, 284, 1768, 1794, 191,
0, 291, 1262, 893, 1803, 0, 649, 0, 967, 1247, 893, 892, 157, 1501, 484, 852,
646, 646, 1414, 1784, 442, 1226, 1784, 1784, 128, 128, 1804, 0, 338, 656, 9, 1033,
1612, 0, 662, 1197, 1672, 1804, 0, 0, 973, 0, 1256, 1834, 0, 1447, 1746, 359,
1714, 1248, 942, 1993, 624, 0, 0, 1721, 1202, 442, 1652, 1553, 1702, 1936, 1246, 1436,
1687, 1259, 1337, 442, 751, 664, 892, 1954, 636, 1277, 1247, 1837, 421, 26, 1374, 1736,
639, 601, 0, 411, 1704, 697, 498, 1938, 1847, 1277, 1793, 202, 947, 1777, 419, 1342,
557, 241, 633, 27, 74, 877, 0, 1683, 839, 1203, 384, 1719, 162, 121, 1107, 1536,
0, 1839, 1318, 872, 1567, 1612, 312, 982, 1283, 839, 0, 731, 1019, 0, 46, 498,
992, 1803, 1803, 689, 1218, 1384, 758, 1107, 1078, 0, 93, 1436, 1292, 1793, 0, 58,
587, 1811, 1898, 346, 686, 332, 1097, 456, 0, 1227, 957, 442, 0, 501, 69, 0,
442, 1987, 949, 409, 1272, 947, 947, 27, 237, 1009, 0, 0, 187, 498, 671, 882,
0, 1093, 0, 1767, 1812, 1287, 472, 997, 839, 1352, 1809, 484, 1259, 0, 153, 0,
1751, 0, 864, 1702, 376, 526, 134, 648, 237, 594, 521, 942, 147, 656, 0, 442,
0, 1951, 1991, 651, 622, 1806, 147, 402, 1352, 1362, 191, 943, 1627, 0, 0, 1954,
1772, 612, 441, 1302, 451, 277, 671, 1744, 213, 128, 671, 397, 14, 1267, 331, 1338,
649, 1802, 616, 94, 839, 0, 818, 0, 1971, 277, 642, 1327, 69, 0, 1267, 624,
639, 294, 0, 1352, 626, 1742, 914, 1812, 1257, 669, 1551, 1809, 935, 587, 1949, 1794,
0, 0, 0, 354, 441, 1338, 1807, 3067, 67, 0, 1848, 312, 1637, 1546, 1546, 182,
0, 1702, 0, 1706, 0, 839, 1242, 202, 1009, 839, 1971, 2029, 377, 1292, 1556, 1556,
177, 0, 688, 957, 967, 1744, 671, 171, 1461, 702, 1782, 1622, 1827, 274, 518, 552,
1828, 0, 642, 1679, 1539, 1113, 1446, 1719, 814, 442, 382, 1009, 0, 0, 1037, 1019,
718, 802, 847, 1474, 1696, 1639, 1716, 634, 1827, 1812, 1811, 0, 227, 943, 0, 239,
1673, 671, 314, 1297, 346, 646, 2001, 501, 799, 894, 687, 1684, 3204, 0, 786, 567,
0, 1991, 0, 538, 442, 909, 161, 197, 1526, 222, 0, 962, 114, 27, 837, 1639,
96, 554, 49, 1312, 693, 1706, 0, 313, 661, 1242, 294, 668, 1918, 0, 488, 3102,
501, 872, 416, 666, 11, 1678, 44, 1948, 1781, 2006, 646, 868, 1573, 1481, 1607, 299,
0, 1247, 0, 264, 1582, 0, 69, 162, 0, 416, 802, 1246, 967, 1227, 1683, 289,
1429, 612, 1848, 1802, 0, 0, 0, 0, 1034, 0, 1659, 681, 1616, 912, 0, 0,
967, 0, 1184, 339, 1812, 1812, 1812, 1726, 1389, 1291, 731, 1721, 1674, 1833, 0, 444,
849, 1761, 1761, 1037, 134, 1696, 228, 1726, 1832, 71, 949, 11, 384, 3414, 0, 794,
794, 0, 1673, 2027, 2029, 2006, 48, 1357, 0, 1799, 0, 1297, 646, 442, 919, 0,
1192, 426, 587, 587, 592, 0, 1636, 1954, 0, 1721, 1464, 472, 1251, 674, 972, 617,
116, 1242, 454, 348, 1949, 649, 1683, 97, 1684, 1161, 0, 597, 1869, 641, 364, 1794,
704, 241, 0, 1681, 1257, 782, 1622, 626, 1708, 1471, 1249, 0, 0, 1791, 1836, 0,
0, 0, 314, 0, 516, 0, 493, 158, 713, 784, 0, 653, 887, 1683, 1169, 1259,
1531, 1806, 0, 227, 1474, 0, 0, 814, 1362, 3467, 839, 1306, 1544, 1837, 839, 688,
1706, 44, 202, 0, 1637, 0, 0, 323, 1256, 2006, 227, 149, 1836, 197, 1834, 768,
1172, 1242, 1242, 0, 1519, 0, 422, 0, 1931, 646, 637, 1384, 121, 391, 0, 561,
1551, 1926, 997, 0, 1759, 877, 1707, 501, 0, 1352, 1693, 454, 274, 1471, 1577, 913,
1364, 1556, 1761, 54, 466, 0, 69, 1708, 0, 2029, 1612, 1539, 0, 807, 0, 639,
837, 116, 0, 1834, 0, 1812, 1009, 329, 1612, 948, 1626, 1952, 1197, 0, 847, 241,
1708, 1227, 1156, 668, 1642, 0, 1682, 1646, 0, 1834, 1804, 1804, 858, 69, 893, 1760,
1238, 0, 827, 0, 0, 0, 872, 639, 76, 533, 553, 1481, 1539, 251, 1454, 1441,
0, 989, 702, 1674, 103, 314, 132, 1924, 1462, 1764, 1684, 0, 22, 973, 887, 254,
1941, 114, 0, 653, 974, 241, 1093, 624, 678, 1807, 649, 1081, 1481, 1809, 537, 177,
599, 1426, 0, 0, 927, 122, 0, 1262, 351, 848, 869, 754, 8, 69, 837, 1683,
637, 1257, 0, 407, 967, 1158, 158, 323, 1774, 656, 1373, 1373, 0, 1832, 1267, 0,
0, 646, 935, 1847, 46, 1827, 1297, 894, 1327, 624, 384, 1602, 0, 697, 2019, 0,
1362, 422, 784, 1514, 1372, 1778, 1756, 444, 697, 294, 1702, 348, 1521, 1726, 1709, 0,
0, 1446, 1247, 0, 1849, 1551, 872, 1834, 1712, 1694, 637, 589, 1524, 0, 828, 0,
1849, 1834, 1707, 564, 2547, 561, 9, 1681, 624, 624, 639, 237, 1721, 1674, 989, 1804,
832, 651, 0, 0, 1262, 847, 731, 1837, 277, 1604, 1576, 1766, 69, 1906, 1551, 1716,
407, 338, 1734, 503, 1734, 0, 649, 728, 586, 1389, 1736, 1771, 1794, 0, 1533, 1483,
1771, 369, 0, 1683, 1107, 197, 932, 1362, 1211, 1567, 639, 0, 0, 1926, 1078, 1803,
1812, 468, 241, 1726, 1247, 402, 648, 1833, 781, 664, 73, 312, 0, 807, 669, 2622,
983, 1287, 661, 1718, 0, 1158, 0, 1539, 919, 1804, 1759, 0, 837, 1804, 798, 828,
659, 312, 1939, 29, 1597, 1794, 1009, 0, 76, 406, 1533, 1572, 1646, 1287, 0, 1684,
877, 622, 1481, 0, 0, 0, 839, 1483, 1951, 8, 869, 1873, 0, 1276, 804, 634,
1659, 1704, 1373, 0, 1247, 582, 892, 1536, 0, 942, 1849, 1222, 1833, 0, 0, 0,
1761, 1007, 0, 1536, 0, 0, 1099, 69, 1322, 1804, 1718, 1834, 686, 0, 848, 1808,
1262, 1811, 882, 603, 1683, 1844, 872, 1297, 0, 407, 957, 0, 781, 807, 639, 294,
939, 829, 828, 603, 426, 1936, 1684, 0, 1909, 607, 839, 639, 972, 0, 609, 912,
636, 0, 0, 646, 0, 0, 827, 1302, 1726, 0, 0, 962, 81, 596, 598, 893,
1139, 919, 1521, 1726, 1257, 2704, 596, 0, 0, 442, 1756, 1756, 893, 0, 1832, 564,
0, 689, 537, 49, 1782, 1909, 0, 781, 76, 1709, 1484, 192, 1292, 326, 638, 1292,
336, 1471, 0, 689, 1922, 1452, 0, 456, 0, 587, 623, 967, 474, 1546, 1711, 154,
1472, 1803, 928, 1721, 0, 384, 1161, 188, 0, 0, 1687, 1374, 44, 1202, 1844, 0,
702, 1936, 0, 1808, 1938, 117, 1837, 697, 622, 1277, 1246, 0, 1777, 562, 1019, 0,
0, 422, 557, 491, 1873, 443, 0, 664, 442, 186, 353, 46, 1718, 0, 0, 1291,
1827, 1899, 0, 187, 1829, 734, 551, 689, 189, 444, 1317, 1851, 498, 1202, 1231, 1717,
1954, 326, 82, 93, 501, 1906, 1296, 1452, 1618, 872, 503, 289, 506, 1812, 839, 181,
1296, 1012, 0, 239, 622, 0, 942, 444, 1787, 1661, 864, 1951, 1801, 1717, 794, 656,
0, 0, 94, 662, 472, 0, 1802, 0, 1009, 1287, 662, 528, 493, 1939, 937, 818,
1922, 642, 1047, 1521, 1247, 1281, 911, 1292, 1726, 1823, 642, 1649, 0, 0, 382, 0,
1483, 1762, 426, 1464, 1929, 443, 1718, 1922, 1702, 442, 840, 812, 69, 202, 1836, 0,
0, 289, 1782, 1622, 0, 1649, 0, 1696, 1936, 1526, 416, 686, 974, 0, 1247, 0,
1311, 799, 968, 1261, 1521, 1706, 907, 839, 332, 1612, 1582, 0, 552, 554, 1834, 44,
417, 1202, 1683, 1981, 1804, 1836, 0, 1302, 646, 0, 1077, 1281, 1684, 0, 538, 1671,
346, 384, 38, 1986, 0, 0, 986, 1812, 536, 157, 0, 1824, 731, 637, 1731, 1622,
959, 1756, 977, 1832, 661, 1472, 1761, 617, 1783, 71, 1357, 1681, 444, 1837, 957, 1684,
442, 1362, 1799, 1827, 1292, 947, 1711, 1811, 1471, 1944, 1576, 1951, 1996, 1602, 444, 1837,
782, 967, 0, 357, 597, 1291, 332, 839, 1696, 1849, 1833, 1038, 887, 226, 1352, 1812,
0, 1648, 812, 1177, 1521, 1706, 0, 1706, 1837, 1691, 0, 1531, 0, 1352, 0, 637,
1701, 1754, 554, 1277, 1524, 0, 602, 1577, 1803, 359, 1034, 569, 597, 624, 928, 997,
0, 0, 1812, 1597, 1832, 0, 0, 0, 938, 0, 1441, 1474, 127, 186, 314, 22,
894, 0, 332, 1577, 177, 1211, 1297, 51, 1832, 649, 912, 887, 668, 1941, 1808, 651,
1494, 0, 656, 939, 1922, 1924, 930, 930, 536, 1292, 947, 1706, 241, 0, 938, 1726,
162, 1911, 943, 1724, 1009, 0, 0, 1291, 1589, 1937, 0, 1197, 658, 1297, 1218, 857,
1172, 528, 1708, 638, 1966, 617, 417, 817, 697, 0, 624, 1807, 157, 656, 1440, 1047,
0, 0, 192, 1772, 1521, 0, 181, 291, 0, 1734, 1439, 1803, 673, 0, 157, 1249,
236, 1721, 1454, 913, 0, 1812, 154, 0, 1882, 611, 847, 1952, 1902, 1731, 943, 1734,
1247, 1352, 0, 968, 562, 1362, 634, 1987, 0, 1222, 566, 989, 407, 828, 0, 799,
974, 838, 228, 839, 1292, 1099, 892, 359, 1726, 1951, 882, 1939, 882, 426, 1796, 1202,
1042, 503, 691, 1811, 0, 1706, 117, 1297, 1302, 359, 0, 937, 1297, 662, 1952, 1851,
4269, 616, 1149, 1186, 1149, 1739, 1944, 934, 398, 0, 989, 1709, 4242, 1783, 719, 0,
0, 0, 1764, 1484, 1717, 1629, 1119, 661, 0, 1777, 597, 1684, 0, 191, 1684, 0,
1981, 582, 1297, 1801, 1801, 103, 0, 1832, 78, 149, 1804, 1436, 179, 441, 533, 421,
1491, 662, 1029, 0, 288, 1079, 191, 1941, 0, 1938, 0, 0, 1936, 1339, 1276, 666,
702, 1837, 958, 1274, 23, 1093, 621, 0, 641, 1657, 0, 284, 49, 1182, 1794, 0,
0, 1449, 1573, 2008, 0, 1767, 1754, 1928, 1804, 1164, 96, 311, 1664, 0, 533, 1939,
1939, 1317, 1174, 0, 949, 0, 0, 751, 1764, 0, 1296, 54, 1834, 1707, 398, 97,
1018, 442, 1802, 0, 759, 1339, 654, 1251, 267, 1009, 662, 0, 471, 1362, 1951, 526,
1806, 112, 864, 1444, 557, 1971, 291, 0, 786, 739, 1093, 1484, 641, 789, 182, 838,
691, 0, 1237, 0, 1804, 1834, 1928, 877, 1292, 1312, 639, 1799, 103, 1971, 1509, 1426,
0, 838, 850, 848, 759, 648, 0, 156, 69, 0, 0, 1836, 872, 0, 161, 1946,
376, 78, 853, 162, 1187, 1187, 416, 693, 913, 538, 1783, 356, 1706, 1939, 686, 0,
0, 538, 509, 739, 1246, 314, 1474, 444, 0, 1249, 73, 332, 786, 0, 1754, 0,
569, 1839, 46, 48, 442, 1832, 1644, 1784, 621, 54, 201, 918, 0, 157, 1848, 1561,
0, 276, 607, 1352, 0, 1364, 1034, 678, 0, 1172, 1654, 188, 1403, 1093, 1812, 664,
1256, 607, 759, 850, 807, 837, 1923, 1471, 918, 0, 0, 1734, 1716, 1684, 78, 0,
0, 1263, 1461, 46, 1721, 0, 442, 648, 0, 649, 0, 637, 286, 1852, 0, 97,
1723, 1772, 82, 1327, 0, 807, 23, 1877, 529, 1269, 1549, 1117, 156, 848, 69, 666,
291, 1483, 1909, 67, 807, 0, 1362, 0, 0, 1483, 1664, 1474, 33, 1732, 97, 179,
0, 882, 1707, 1716, 807, 1923, 284, 688, 0, 1471, 648, 1174, 1804, 0, 1779, 1706,
0, 1794, 402, 1572, 0, 1794, 444, 29, 567, 0, 636, 649, 0, 0, 1784, 526,
0, 0, 0, 974, 974, 989, 1474, 1524, 156, 912, 697, 974, 1614, 847, 1794, 1939,
0, 1707, 1438, 1681, 1709, 0, 1832, 808, 0, 358, 1276, 0, 639, 997, 974, 499,
1299, 0, 669, 516, 0, 0, 912, 1299, 0, 1683, 3197, 1299, 912, 808, 1463, 312,
516, 649, 516, 0, 526, 974, 1474, 156, 808, 3197, 639, 1707, 312, 1608, 1832, 499,
669, 1299, 3158, 1292, 666, 251, 697, 0, 0, 637, 501, 289, 2018, 313, 1441, 1734,
1302, 472, 1474, 3163, 528, 491, 204, 663, 629, 1292, 0, 1539, 1077, 1246, 0, 1939,
1896, 69, 1742, 597, 1441, 0, 1939, 1767, 204, 0, 1802, 894, 697, 0, 1784, 1706,
1782, 0, 339, 444, 1292, 0, 0, 586, 639, 0, 1774, 0, 589, 0, 1583, 1756,
662, 1802, 1339, 1774, 0, 1439, 1249, 1656, 639, 0, 0, 382, 0, 1779, 1791, 1529,
0, 0, 1736, 697, 0, 1054, 0, 1827, 0, 1746, 413, 0, 166, 1454, 0, 0,
1983, 1758, 0, 1804, 1539, 0, 566, 0, 0, 1759, 1928, 1954, 1934, 0, 1993, 1993,
1906, 503, 0, 0, 332, 872, 313, 0, 839, 0, 1174, 0, 459, 1804, 689, 1793,
1899, 1657, 1802, 0, 1919, 1227, 69, 1749, 1296, 27, 0, 2008, 0, 0, 237, 1922,
1823, 1758, 1772, 1804, 0, 0, 1474, 147, 1729, 1471, 0, 149, 499, 528, 1302, 0,
662, 604, 451, 1722, 623, 1461, 197, 349, 972, 1906, 999, 384, 621, 0, 1746, 509,
0, 63, 1613, 1802, 828, 1951, 776, 761, 0, 1834, 1597, 639, 1939, 1339, 0, 813,
0, 777, 381, 1474, 0, 286, 54, 0, 1829, 741, 1269, 0, 0, 0, 4333, 0,
182, 664, 0, 1701, 1704, 469, 1529, 103, 624, 0, 4016, 1929, 1516, 357, 0, 0,
3957, 0, 734, 0, 0, 0, 1549, 0, 1717, 418, 802, 1564, 1804, 1027, 1807, 4112,
69, 0, 158, 867, 1981, 639, 636, 1572, 1979, 1683, 0, 1283, 347, 1934, 0, 2001,
0, 1987, 854, 649, 204, 562, 909, 1463, 78, 549, 339, 1832, 332, 1756, 1208, 1474,
1761, 1474, 629, 0, 384, 0, 314, 1732, 442, 0, 1622, 649, 0, 1834, 1991, 1641,
1708, 624, 1806, 11, 1717, 1037, 177, 428, 1951, 0, 1784, 617, 1761, 0, 1144, 636,
1012, 1799, 1684, 0, 1597, 1946, 1439, 648, 1234, 0, 618, 634, 471, 1812, 972, 1531,
974, 1708, 1261, 176, 1769, 1602, 1539, 44, 187, 1256, 1474, 653, 1837, 1734, 569, 0,
1792, 1792, 599, 1832, 1211, 244, 1283, 837, 1007, 0, 1441, 1922, 1004, 0, 1877, 2008,
847, 887, 0, 1156, 0, 1707, 1987, 22, 0, 668, 1922, 1802, 596, 1263, 939, 167,
554, 602, 157, 0, 0, 1414, 1708, 1451, 369, 1934, 1047, 649, 382, 0, 697, 636,
2023, 658, 96, 624, 1969, 1007, 1889, 277, 3972, 1267, 1572, 1604, 1243, 1467, 0, 1874,
1571, 0, 0, 1716, 0, 659, 673, 847, 1122, 0, 8, 1906, 1204, 623, 0, 1804,
1804, 1439, 1324, 0, 1258, 0, 0, 599, 1946, 562, 9, 1811, 0, 1834, 648, 624,
357, 1922, 1764, 1864, 828, 1463, 1684, 0, 839, 0, 74, 1922, 1784, 0, 197, 0,
197, 0, 157, 1324, 1808, 807, 179, 0, 1922, 611, 1864, 1804, 293, 0, 1784, 357,
1782, 639, 339, 444, 1339, 636, 662, 589, 1583, 1324, 1439, 1249, 0, 1774, 1804, 1774,
639, 0, 653, 624, 1156, 689, 1779, 1054, 1758, 382, 909, 1746, 1529, 428, 1454, 413,
697, 1934, 503, 566, 1227, 2008, 3972, 1749, 1899, 1539, 1928, 313, 1946, 237, 1296, 1919,
69, 1804, 1802, 776, 828, 1474, 509, 1471, 662, 621, 182, 1951, 1461, 604, 286, 499,
1302, 528, 1772, 1804, 1934, 451, 1722, 149, 629, 1758, 0, 664, 1701, 4333, 1269, 1704,
469, 1829, 624, 777, 4016, 1529, 381, 1283, 1951, 2001, 1144, 357, 1987, 418, 734, 1683,
1832, 3957, 1463, 4112, 158, 854, 1981, 1549, 1572, 1463, 1804, 1012, 177, 332, 618, 649,
1732, 1769, 1799, 1684, 384, 1834, 1761, 157, 1991, 11, 1784, 314, 972, 1208, 1756, 1007,
293, 1539, 1734, 1792, 44, 1474, 1256, 974, 668, 939, 1922, 648, 1004, 1572, 1889, 1267,
807, 1243, 697, 1784, 1258, 1906, 179, 503, 0, 587, 1711, 637, 587, 551, 586, 1246,
0, 3131, 857, 719, 0, 882, 354, 651, 1248, 188, 838, 306, 1671, 69, 1484, 1716,
426, 0, 0, 0, 1784, 1473, 1484, 621, 0, 0, 1652, 356, 1784, 26, 0, 1796,
0, 1724, 614, 0, 738, 549, 689, 0, 1706, 86, 562, 1834, 1951, 641, 422, 1706,
599, 1686, 612, 86, 0, 1996, 422, 1804, 1939, 49, 152, 459, 1202, 1029, 0, 0,
1029, 1829, 326, 0, 1524, 1751, 612, 0, 0, 567, 1009, 0, 949, 837, 1077, 68,
1833, 641, 1641, 946, 1202, 1706, 0, 888, 1009, 201, 1572, 611, 697, 54, 1926, 0,
444, 112, 494, 1589, 1802, 557, 0, 1222, 634, 409, 1571, 519, 1877, 1939, 399, 1954,
1474, 0, 1991, 399, 529, 1208, 73, 933, 284, 1469, 779, 419, 1616, 1802, 187, 949,
569, 69, 894, 869, 624, 451, 0, 1991, 643, 1759, 1882, 0, 451, 1866, 649, 1474,
0, 1929, 1451, 86, 0, 1292, 0, 214, 0, 1946, 804, 1864, 239, 176, 1443, 1608,
1187, 486, 1717, 934, 649, 1549, 444, 288, 242, 0, 1939, 636, 1914, 358, 669, 0,
226, 627, 0, 1856, 804, 429, 0, 636, 1469, 1804, 1969, 444, 499, 1394, 1877, 0,
1804, 0, 178, 614, 1939, 1979, 1182, 1846, 1894, 289, 1864, 1784, 0, 1439, 0, 1812,
669, 459, 0, 1866, 69, 357, 1482, 1784, 0, 1764, 0, 459, 0, 54, 1926, 444,
0, 494, 112, 1877, 1717, 34, 1914, 634, 1939, 409, 1571, 1222, 73, 499, 1954, 519,
399, 649, 69, 1474, 1616, 529, 779, 284, 949, 419, 569, 1802, 1882, 1939, 643, 624,
1991, 869, 894, 1866, 1991, 451, 669, 1292, 1929, 804, 1451, 444, 358, 636, 1482, 1443,
239, 69, 1946, 486, 1187, 288, 804, 429, 1979, 444, 1969, 1394, 1877, 1784, 1864, 1846,
1894, 1439, 1812, 459, 189, 0, 1454, 1038, 1627, 1709, 181, 569, 181, 1923, 1712, 1577,
2003, 2003, 839, 681, 444, 1919, 458, 1248, 1439, 1287, 0, 1449, 0, 697, 0, 0,
1993, 179, 0, 0, 1274, 166, 0, 0, 0, 201, 1844, 1296, 637, 1296, 202, 506,
1833, 1991, 1612, 378, 864, 458, 1556, 0, 0, 1919, 0, 669, 686, 0, 0, 1579,
169, 263, 0, 1299, 0, 1291, 0, 1602, 1296, 0, 617, 1267, 1266, 659, 1874, 1604,
0, 1863, 1863, 2007, 1161, 49, 1832, 1248, 373, 697, 441, 0, 648, 0, 1938, 1561,
1844, 29, 1247, 1844, 1264, 1659, 1567, 1804, 1083, 0, 0, 27, 331, 756, 1657, 641,
238, 1183, 0, 1954, 0, 323, 1937, 441, 1172, 689, 1436, 98, 1077, 689, 839, 481,
1802, 639, 379, 1718, 656, 0, 1951, 1302, 764, 1963, 529, 1287, 783, 0, 189, 894,
1207, 1939, 642, 1614, 113, 649, 0, 1266, 69, 1716, 379, 636, 687, 639, 1826, 1637,
204, 674, 1099, 1726, 104, 1767, 1311, 1018, 1481, 852, 1823, 0, 197, 1729, 438, 1564,
649, 1247, 1696, 1682, 231, 662, 637, 1083, 686, 2006, 907, 894, 872, 607, 689, 187,
1673, 1302, 1601, 97, 2007, 1274, 1803, 254, 0, 113, 1996, 94, 1939, 0, 323, 1937,
1832, 377, 0, 213, 1823, 1943, 1602, 0, 178, 209, 649, 0, 294, 688, 442, 2007,
332, 1207, 1357, 0, 1602, 148, 0, 648, 298, 271, 1706, 1564, 1264, 1083, 321, 1602,
637, 1099, 1172, 879, 1864, 69, 191, 894, 0, 254, 1576, 284, 1539, 1708, 783, 639,
1937, 1264, 312, 1172, 1996, 847, 64, 127, 0, 82, 1647, 0, 306, 144, 0, 407,
202, 0, 371, 96, 254, 254, 697, 697, 867, 0, 1266, 1266, 1243, 856, 371, 256,
519, 1874, 1564, 69, 69, 1952, 689, 202, 1269, 373, 197, 636, 1703, 1844, 1083, 869,
864, 1937, 839, 1939, 157, 202, 364, 1684, 882, 869, 1716, 0, 2011, 807, 1734, 1323,
1389, 1099, 0, 689, 639, 256, 2011, 0, 782, 697, 869, 1461, 491, 286, 0, 1296,
1603, 378, 378, 491, 0, 0, 0, 0, 0, 0, 1578, 0, 0, 1784, 958, 0,
1296, 0, 819, 378, 0, 1784, 1603, 0, 1814, 48, 2671, 4279, 528, 702, 1684, 1844,
0, 284, 1761, 409, 1339, 0, 0, 1481, 1652, 0, 1569, 384, 1029, 1247, 947, 1368,
1339, 1277, 1847, 171, 596, 496, 779, 313, 872, 284, 0, 1928, 409, 0, 1788, 1196,
0, 501, 501, 0, 1954, 1353, 384, 27, 1947, 1938, 1792, 731, 1804, 1281, 1474, 1227,
397, 493, 687, 659, 0, 894, 713, 1302, 1946, 4359, 1939, 1451, 854, 1834, 1446, 0,
1674, 1312, 1922, 1673, 443, 1281, 1946, 1077, 872, 1922, 1909, 854, 1991, 621, 1678, 234,
538, 0, 0, 1197, 1259, 533, 1083, 1227, 0, 54, 907, 0, 852, 1368, 1357, 637,
0, 0, 212, 249, 226, 569, 1827, 586, 1481, 444, 0, 442, 0, 0, 1908, 1832,
1686, 0, 503, 1926, 1712, 1837, 894, 656, 167, 4468, 0, 849, 1768, 1922, 659, 1909,
102, 857, 422, 406, 867, 473, 1414, 718, 614, 1802, 637, 369, 397, 1832, 649, 586,
827, 1189, 839, 839, 895, 0, 2671, 4279, 528, 1761, 284, 1339, 4468, 384, 907, 1368,
586, 501, 731, 895, 1947, 1938, 1804, 596, 1928, 839, 1792, 1281, 1474, 4359, 1939, 659,
1946, 1302, 894, 659, 1922, 443, 854, 1083, 54, 621, 533, 1678, 0, 234, 1991, 249,
442, 637, 0, 1481, 1189, 1837, 1712, 1908, 894, 1922, 867, 1736, 501, 0, 237, 2569,
2019, 0, 0, 799, 237, 0, 39, 39, 74, 74, 0, 74, 0, 237, 74, 74,
177, 1363, 1117, 1117, 1928, 0, 234, 1801, 0, 2571, 71, 1472, 1364, 857, 277, 157,
0, 1256, 1831, 0, 1249, 1774, 1803, 3039, 934, 1246, 0, 524, 0, 1981, 1812, 0,
1849, 669, 557, 1779, 408, 1703, 277, 1791, 3047, 4424, 1941, 669, 1838, 1682, 847, 187,
174, 1077, 1612, 1939, 1803, 678, 641, 0, 284, 398, 312, 1234, 0, 332, 1877, 1582,
1484, 0, 1299, 674, 622, 349, 1829, 972, 64, 639, 1033, 1802, 662, 1976, 864, 1774,
1649, 1529, 1474, 1582, 1177, 594, 1079, 0, 1723, 1763, 1774, 101, 1827, 1726, 1292, 1634,
1952, 1292, 314, 314, 1637, 674, 1604, 354, 0, 4424, 1626, 524, 1704, 1474, 183, 1539,
1874, 1311, 427, 847, 1426, 0, 838, 503, 0, 56, 0, 0, 0, 614, 2784, 894,
0, 1946, 669, 0, 231, 782, 1681, 1604, 1804, 277, 0, 912, 66, 1144, 1832, 294,
0, 374, 1549, 0, 212, 187, 0, 1834, 0, 1926, 1827, 1849, 0, 74, 3039, 384,
1712, 617, 1292, 299, 277, 1682, 1037, 1802, 499, 1792, 0, 879, 1774, 1564, 314, 0,
1838, 1539, 1565, 1258, 0, 1792, 0, 1911, 22, 1474, 0, 1539, 0, 1871, 1921, 374,
314, 0, 187, 272, 867, 2021, 1329, 1256, 1763, 1834, 1802, 1704, 857, 689, 1474, 69,
1791, 934, 1734, 1549, 3047, 1906, 1597, 398, 983, 1994, 2571, 796, 0, 1837, 0, 912,
838, 1804, 0, 309, 639, 1821, 0, 552, 1832, 942, 0, 1287, 0, 779, 441, 721,
86, 411, 1742, 3529, 0, 1463, 41, 1837, 266, 0, 1732, 0, 1701, 0, 1827, 552,
1567, 1291, 69, 1201, 93, 1449, 54, 0, 313, 2001, 1799, 867, 0, 526, 1951, 1471,
0, 1834, 0, 567, 1274, 1939, 0, 1772, 594, 0, 656, 1707, 0, 0, 812, 642,
769, 1934, 0, 1849, 1782, 182, 354, 1706, 918, 443, 1702, 442, 469, 563, 812, 642,
488, 704, 1813, 97, 1709, 54, 839, 1847, 104, 1792, 1246, 1202, 1281, 536, 0, 1572,
2001, 1227, 802, 1077, 176, 1827, 0, 1721, 286, 687, 1804, 1808, 1801, 2851, 1783, 957,
1384, 54, 384, 1481, 694, 1833, 1849, 592, 782, 1721, 0, 1531, 1577, 997, 1706, 1363,
204, 669, 2001, 0, 1701, 1721, 1847, 564, 1821, 68, 949, 167, 441, 858, 1807, 1642,
599, 1266, 1781, 1911, 939, 0, 1758, 309, 69, 1772, 69, 142, 1682, 1934, 949, 1439,
867, 1232, 286, 967, 1799, 129, 769, 0, 969, 2001, 779, 1083, 0, 0, 1826, 636,
1784, 157, 272, 872, 519, 1706, 426, 272, 839, 1828, 336, 1292, 1987, 1189, 1949, 1802,
456, 0, 683, 1783, 2019, 947, 286, 1759, 354, 0, 421, 0, 0, 1849, 1569, 1606,
733, 1657, 2029, 551, 501, 1536, 1231, 197, 1859, 998, 819, 0, 197, 0, 1627, 1938,
1716, 654, 182, 1809, 1637, 659, 957, 759, 1541, 829, 1242, 0, 0, 1784, 1431, 1089,
1682, 894, 808, 1781, 1582, 1186, 1908, 227, 0, 2019, 1979, 254, 786, 1602, 0, 356,
597, 1758, 1743, 1573, 0, 0, 0, 1231, 0, 1531, 972, 1302, 198, 271, 1849, 1824,
19, 1899, 548, 1577, 654, 1213, 0, 1834, 837, 0, 817, 1801, 654, 102, 659, 1706,
1572, 1231, 1117, 1804, 838, 689, 0, 1804, 1089, 1362, 1771, 197, 1784, 872, 972, 0,
1089, 1739, 656, 1431, 0, 1784, 113, 113, 1474, 1829, 1474, 1474, 838, 4444, 1798, 3352,
837, 666, 0, 447, 1803, 858, 296, 1916, 336, 1231, 1292, 567, 443, 1926, 0, 26,
0, 443, 1033, 329, 1436, 0, 754, 214, 1993, 407, 1832, 1701, 554, 491, 112, 0,
0, 314, 0, 1709, 1804, 151, 1471, 1638, 1246, 1148, 1256, 0, 1349, 1204, 1777, 666,
29, 411, 177, 1742, 353, 1844, 1782, 441, 104, 1029, 1736, 0, 697, 374, 496, 1808,
1257, 38, 1389, 0, 166, 1113, 421, 1848, 0, 1277, 1201, 0, 587, 0, 702, 0,
0, 0, 0, 454, 1349, 633, 1569, 724, 0, 892, 384, 0, 188, 237, 1077, 0,
1474, 992, 506, 731, 872, 0, 1524, 503, 97, 1202, 1834, 0, 0, 104, 1827, 324,
643, 0, 0, 0, 1618, 689, 1257, 0, 1561, 1764, 1916, 1182, 567, 69, 1466, 202,
1472, 97, 1954, 189, 1851, 1233, 1626, 1257, 0, 0, 948, 1256, 0, 0, 1844, 0,
1786, 39, 96, 662, 496, 1484, 1931, 1018, 0, 0, 0, 0, 1019, 1573, 0, 1803,
1521, 779, 708, 0, 649, 0, 1742, 0, 658, 188, 398, 474, 94, 1472, 1012, 541,
1807, 0, 1946, 194, 0, 1627, 33, 829, 526, 0, 1756, 1338, 267, 1939, 1287, 0,
0, 1718, 0, 1302, 1201, 1618, 1951, 592, 997, 763, 329, 1716, 1717, 1751, 0, 0,
818, 637, 493, 1362, 973, 1801, 1806, 521, 11, 341, 1828, 1414, 729, 1257, 897, 0,
0, 329, 554, 1374, 1174, 741, 1292, 1726, 0, 1754, 0, 1601, 274, 0, 493, 0,
354, 918, 957, 812, 939, 1736, 1847, 54, 1704, 1539, 1834, 157, 1623, 97, 554, 642,
587, 704, 426, 837, 0, 1939, 0, 691, 1702, 1702, 0, 0, 1987, 919, 674, 1278,
1464, 552, 0, 1797, 202, 1894, 687, 1719, 382, 942, 3741, 0, 0, 1374, 182, 469,
838, 1589, 91, 1954, 0, 0, 878, 2019, 689, 163, 1673, 649, 2961, 0, 1582, 162,
907, 734, 872, 0, 894, 0, 1261, 1187, 693, 993, 0, 1197, 14, 51, 1719, 1776,
1976, 0, 1, 1261, 1564, 786, 358, 0, 222, 1991, 1931, 56, 0, 1996, 227, 1572,
339, 1247, 1257, 1979, 636, 1834, 668, 518, 947, 161, 323, 1706, 849, 1582, 504, 274,
0, 0, 894, 968, 894, 601, 78, 0, 802, 738, 411, 1703, 1034, 0, 1864, 0,
302, 1716, 0, 0, 671, 0, 962, 713, 1811, 187, 849, 536, 1718, 359, 1636, 1683,
1996, 444, 1357, 0, 384, 702, 1926, 1602, 1897, 587, 1787, 364, 1712, 0, 1926, 0,
617, 1683, 0, 1447, 146, 1274, 0, 586, 0, 1144, 1012, 1266, 1266, 592, 1631, 0,
612, 1799, 0, 0, 0, 649, 1521, 526, 0, 1761, 1923, 569, 1926, 0, 1941, 0,
1751, 0, 958, 1169, 6, 0, 0, 957, 146, 1561, 44, 1712, 847, 1558, 1249, 877,
0, 1799, 1124, 0, 1352, 1577, 1558, 1261, 472, 1519, 222, 97, 0, 276, 66, 1401,
0, 1991, 1701, 1812, 616, 1612, 877, 713, 1553, 1426, 1531, 0, 468, 1929, 1929, 812,
1804, 1837, 1578, 1099, 1706, 641, 0, 928, 0, 1529, 0, 0, 0, 0, 0, 1027,
893, 0, 1159, 2007, 1642, 0, 0, 1764, 849, 0, 24, 0, 1009, 828, 69, 1549,
877, 311, 118, 0, 1808, 894, 22, 741, 1261, 261, 1246, 0, 1576, 939, 1821, 158,
0, 674, 76, 1484, 889, 1754, 241, 882, 1864, 0, 0, 0, 596, 0, 721, 0,
64, 0, 0, 0, 0, 602, 637, 1242, 624, 1263, 1231, 867, 134, 1754, 1719, 1577,
529, 0, 0, 1047, 617, 1218, 1549, 407, 0, 1969, 1787, 1576, 1724, 697, 656, 2021,
859, 662, 817, 369, 1572, 1861, 636, 0, 1941, 309, 1704, 0, 0, 697, 0, 0,
1243, 1618, 0, 0, 0, 1436, 711, 649, 419, 1549, 893, 691, 624, 0, 847, 1986,
1266, 1256, 1987, 827, 0, 1618, 612, 1799, 377, 538, 291, 689, 1771, 1564, 54, 1804,
9, 1428, 0, 0, 1954, 582, 369, 639, 1099, 1561, 634, 1281, 86, 0, 0, 1107,
1756, 649, 649, 1258, 148, 1939, 0, 837, 0, 0, 2011, 779, 0, 1197, 799, 0,
1519, 0, 919, 76, 1182, 893, 0, 0, 882, 384, 892, 1736, 0, 807, 97, 646,
1844, 157, 1721, 649, 1707, 519, 122, 1099, 828, 256, 0, 0, 912, 4511, 897, 1872,
1099, 697, 1578, 1952, 0, 666, 447, 1803, 1926, 336, 1916, 1231, 858, 1638, 1256, 214,
1436, 0, 407, 329, 962, 1148, 1787, 151, 1742, 454, 104, 1569, 689, 374, 166, 1941,
1029, 54, 2961, 38, 1257, 1844, 1276, 702, 1701, 496, 724, 411, 633, 353, 1113, 29,
1834, 1257, 1931, 1257, 503, 96, 731, 1233, 104, 97, 1844, 4511, 1019, 1573, 643, 324,
1827, 1618, 97, 872, 1519, 1256, 948, 0, 1474, 1764, 1561, 69, 1077, 1202, 377, 1742,
729, 818, 398, 942, 0, 1828, 182, 642, 1797, 1047, 1939, 291, 1627, 918, 329, 1806,
713, 1897, 1951, 1718, 1623, 341, 1716, 602, 1302, 364, 541, 329, 474, 997, 1931, 1414,
658, 1801, 158, 194, 1576, 11, 1807, 1362, 1954, 817, 3741, 0, 802, 1589, 849, 741,
1726, 1558, 838, 1894, 202, 536, 469, 382, 1754, 274, 914, 426, 1736, 878, 711, 649,
1374, 1601, 812, 1278, 687, 1, 1261, 1923, 1144, 274, 947, 56, 1247, 302, 734, 786,
0, 1706, 504, 912, 222, 1976, 668, 1939, 1716, 693, 596, 1187, 1572, 339, 649, 689,
968, 1991, 1274, 0, 713, 1261, 1521, 384, 146, 1266, 1941, 364, 1531, 617, 612, 6,
359, 958, 889, 1991, 419, 957, 1009, 1929, 97, 472, 1099, 1578, 691, 1099, 1027, 877,
468, 44, 1804, 641, 86, 1352, 76, 1576, 939, 828, 64, 1821, 674, 311, 2007, 1764,
877, 1737, 697, 859, 1242, 893, 369, 807, 1243, 256, 1263, 309, 634, 827, 612, 1987,
847, 1804, 148, 76, 799, 157, 1721, 2662, 0, 0, 23, 332, 1296, 858, 0, 2662,
962, 0, 1496, 1438, 0, 0, 1782, 69, 554, 69, 1436, 711, 724, 411, 587, 1379,
947, 1717, 1717, 3146, 993, 0, 1508, 0, 1897, 1049, 0, 1196, 733, 0, 74, 69,
1834, 567, 516, 472, 567, 402, 0, 589, 526, 993, 0, 788, 814, 917, 1622, 0,
686, 1844, 1844, 0, 0, 869, 161, 1426, 0, 1781, 1299, 1782, 1781, 626, 1834, 1687,
1724, 0, 0, 1299, 0, 1687, 38, 14, 1682, 1806, 794, 1309, 807, 356, 0, 0,
1607, 1099, 1564, 713, 567, 1309, 218, 0, 354, 0, 781, 1577, 516, 1212, 719, 1706,
624, 158, 69, 291, 612, 1564, 0, 0, 962, 1496, 1438, 1782, 554, 69, 1689, 218,
1379, 1682, 1717, 587, 3146, 993, 724, 3464, 1897, 1049, 526, 1687, 1564, 993, 917, 0,
402, 472, 567, 788, 681, 1844, 814, 356, 1834, 1781, 161, 1709, 1687, 626, 1782, 1781,
158, 807, 1299, 624, 794, 1309, 567, 1607, 1564, 1309, 719, 612, 444, 438, 824, 369,
1739, 1256, 1701, 454, 1939, 0, 0, 353, 384, 0, 38, 0, 741, 1848, 1368, 1938,
1202, 673, 412, 1787, 1806, 1929, 661, 0, 0, 1296, 313, 2008, 2029, 324, 0, 1,
1657, 0, 51, 93, 444, 639, 894, 883, 177, 1742, 379, 889, 1009, 3154, 1481, 379,
1719, 397, 0, 1834, 451, 1438, 0, 1269, 1742, 0, 0, 69, 1712, 1438, 1466, 1939,
0, 353, 1839, 1929, 202, 1719, 197, 1099, 1848, 1718, 1187, 418, 2001, 1801, 0, 907,
1806, 686, 222, 177, 1202, 872, 1582, 1719, 894, 0, 1718, 1806, 1953, 1787, 1342, 1712,
192, 0, 1806, 1832, 311, 1832, 882, 1681, 1681, 1099, 369, 1547, 0, 617, 661, 1547,
1808, 1247, 1783, 621, 472, 1848, 1704, 1683, 9, 1709, 0, 639, 1914, 0, 22, 0,
1808, 158, 1792, 867, 1647, 0, 0, 1549, 1547, 24, 1718, 0, 972, 0, 636, 0,
1707, 1808, 1309, 621, 883, 0, 839, 839, 839, 1976, 0, 1936, 1553, 694, 3537, 1799,
1309, 1784, 12, 711, 1747, 1778, 637, 504, 1976, 1939, 499, 694, 237, 1821, 686, 202,
0, 1852, 914, 1832, 197, 326, 1546, 554, 634, 1501, 519, 202, 1852, 1821, 636, 1706,
197, 1987, 837, 3537, 0, 1852, 0, 0, 1833, 1832, 1768, 1714, 0, 0, 0, 1687,
421, 1176, 1847, 839, 0, 1786, 872, 827, 456, 47, 1704, 324, 0, 596, 1704, 1919,
1756, 639, 1019, 0, 1726, 1899, 1622, 1929, 1189, 957, 872, 1246, 0, 634, 1429, 416,
587, 1906, 1806, 1077, 0, 0, 867, 0, 349, 1811, 0, 0, 1501, 871, 1712, 587,
1806, 0, 934, 1848, 876, 967, 86, 1704, 1684, 794, 1807, 1707, 1804, 8, 289, 306,
1719, 0, 3394, 0, 0, 637, 0, 0, 29, 1201, 1681, 0, 0, 639, 932, 967,
0, 0, 839, 1548, 8, 0, 284, 882, 872, 9, 0, 839, 0, 0, 0, 0,
0, 1281, 1281, 674, 0, 0, 674, 0, 1284, 674, 674, 324, 674, 0, 416, 0,
729, 972, 979, 979, 1184, 1799, 1608, 0, 1799, 472, 336, 147, 646, 1339, 312, 0,
1704, 1339, 1277, 669, 1766, 0, 28, 1808, 1388, 1059, 1009, 2008, 277, 39, 1804, 1794,
1582, 54, 661, 587, 49, 1786, 93, 0, 472, 0, 662, 1732, 11, 11, 577, 493,
1444, 277, 1267, 1621, 937, 0, 0, 1612, 1269, 1764, 749, 0, 1564, 1444, 93, 0,
686, 800, 1732, 1357, 41, 2031, 1291, 1291, 567, 0, 1019, 686, 646, 71, 311, 646,
0, 0, 496, 1564, 54, 1732, 1172, 472, 0, 794, 0, 887, 0, 1267, 1766, 636,
0, 651, 159, 277, 599, 1718, 1256, 357, 1664, 646, 0, 1682, 1339, 442, 1009, 1304,
472, 0, 0, 552, 164, 227, 1357, 1849, 1454, 1683, 0, 34, 1581, 496, 1849, 22,
0, 1683, 0, 357, 1664, 357, 1682, 1339, 442, 552, 1683, 1849, 1581, 683, 683, 0,
1734, 1716, 636, 1806, 0, 1849, 1447, 0, 1197, 617, 1811, 1849, 0, 11, 1806, 1723,
599, 1799, 338, 1283, 782, 1724, 1514, 551, 1756, 0, 1756, 0, 1529, 783, 1247, 557,
1834, 1672, 36, 374, 0, 0, 1174, 1231, 873, 0, 673, 828, 472, 1266, 384, 382,
1683, 662, 0, 0, 1802, 0, 731, 67, 1206, 1227, 0, 443, 642, 1632, 0, 782,
642, 0, 1623, 0, 1813, 702, 0, 554, 673, 1647, 0, 1222, 804, 1647, 0, 0,
0, 339, 0, 1784, 554, 646, 731, 264, 678, 1276, 1802, 1391, 1602, 382, 384, 1782,
629, 718, 1822, 1966, 1782, 1718, 1739, 1803, 1839, 1403, 321, 321, 659, 756, 829, 859,
1213, 0, 936, 254, 1269, 564, 1267, 504, 0, 848, 624, 159, 1362, 0, 0, 1718,
1222, 892, 868, 1099, 1302, 1799, 338, 1283, 551, 1724, 1514, 1756, 1756, 1672, 504, 374,
1247, 36, 1529, 557, 1834, 892, 873, 1231, 673, 662, 642, 1623, 472, 1813, 0, 731,
1802, 1222, 0, 1647, 554, 0, 1813, 731, 1602, 1822, 384, 1966, 1782, 382, 1099, 936,
321, 1403, 564, 829, 159, 1362, 1222, 1302, 426, 76, 426, 0, 1711, 1908, 1182, 1389,
0, 1567, 864, 506, 0, 0, 689, 0, 1521, 0, 1787, 1792, 1531, 713, 1406, 406,
877, 1707, 857, 1211, 1211, 0, 76, 76, 76, 857, 0, 1414, 426, 0, 426, 0,
1908, 1182, 1389, 689, 1521, 1531, 1792, 877, 1211, 76, 76, 416, 406, 0, 416, 3972,
0, 116, 636, 339, 0, 1656, 0, 1551, 1723, 1652, 1339, 1834, 0, 189, 1808, 409,
0, 0, 4308, 0, 1802, 0, 69, 0, 0, 857, 237, 0, 1524, 48, 1474, 379,
9, 1339, 1608, 658, 567, 93, 0, 1627, 237, 1723, 1788, 0, 398, 1784, 825, 1706,
116, 96, 1058, 384, 101, 704, 354, 1539, 1832, 0, 1792, 627, 538, 411, 649, 234,
93, 1719, 0, 0, 289, 418, 0, 1684, 518, 384, 1133, 627, 597, 617, 1619, 1837,
1906, 592, 9, 1742, 0, 1684, 503, 146, 1529, 0, 97, 466, 1709, 784, 879, 1531,
0, 1799, 1686, 1007, 0, 937, 0, 1834, 1751, 668, 1398, 784, 1969, 1439, 1708, 0,
1799, 636, 1327, 1577, 1821, 1581, 1549, 1723, 1906, 421, 0, 967, 1784, 1007, 157, 1723,
0, 1864, 0, 1472, 339, 636, 1656, 1742, 1652, 1709, 1339, 1834, 189, 409, 4308, 649,
1474, 48, 1524, 379, 1802, 398, 1327, 1723, 567, 825, 658, 1706, 93, 96, 354, 384,
1832, 1058, 704, 538, 627, 1719, 518, 146, 784, 503, 1531, 157, 0, 1007, 97, 879,
1751, 668, 937, 1398, 1969, 1723, 1478, 782, 537, 1721, 0, 0, 1077, 69, 97, 0,
0, 416, 0, 11, 0, 444, 1256, 1849, 1736, 0, 0, 1744, 928, 1834, 427, 554,
312, 1657, 1656, 187, 1774, 1954, 0, 0, 0, 1349, 1389, 1848, 1687, 1937, 0, 0,
0, 97, 48, 697, 1657, 1804, 1296, 1936, 1296, 676, 0, 1916, 1836, 1196, 1949, 689,
1954, 1127, 686, 1201, 1868, 644, 872, 1928, 1567, 444, 0, 1473, 69, 1657, 0, 1524,
0, 0, 1207, 1582, 1939, 1352, 0, 349, 0, 1302, 1461, 0, 398, 549, 97, 0,
1806, 914, 1946, 0, 1734, 0, 687, 1528, 1276, 942, 812, 554, 1637, 1761, 1649, 704,
0, 183, 1741, 7, 894, 1976, 1946, 1454, 1207, 786, 1582, 802, 1996, 734, 1247, 1247,
1784, 416, 1406, 1784, 1799, 1793, 1704, 0, 0, 1209, 1257, 416, 617, 649, 631, 0,
1602, 0, 1712, 1996, 782, 1357, 0, 506, 157, 526, 1531, 1256, 182, 1939, 877, 0,
1597, 1706, 128, 0, 11, 1837, 2001, 1406, 1439, 1247, 1939, 0, 0, 1834, 912, 1911,
1009, 24, 116, 1214, 241, 1296, 69, 0, 1834, 1756, 602, 0, 1539, 1726, 867, 158,
371, 0, 1572, 142, 324, 656, 1618, 1784, 912, 1906, 671, 1804, 0, 0, 1221, 1949,
1784, 0, 917, 0, 1721, 639, 1501, 686, 1707, 611, 837, 76, 928, 1834, 1657, 1774,
187, 1296, 0, 97, 917, 1868, 1473, 1524, 444, 686, 2001, 1954, 1657, 1127, 644, 1804,
1567, 1726, 929, 1806, 656, 602, 914, 549, 1207, 0, 837, 183, 1784, 1741, 1276, 704,
1247, 1247, 734, 1976, 0, 1539, 116, 1209, 1939, 782, 1406, 1704, 24, 877, 1256, 1439,
1214, 912, 241, 158, 1949, 639, 1501, 1721, 3003, 0, 0, 1683, 0, 459, 0, 16,
1632, 642, 0, 973, 236, 0, 313, 756, 547, 547, 592, 764, 472, 0, 488, 1207,
69, 731, 1254, 1832, 1548, 887, 97, 1726, 0, 0, 236, 771, 89, 1007, 857, 887,
1726, 357, 4369, 1548, 1603, 89, 771, 0, 466, 0, 0, 0, 1266, 0, 1874, 1436,
786, 786, 312, 413, 1751, 1317, 947, 289, 0, 0, 401, 1612, 1201, 1991, 401, 1317,
0, 1182, 69, 947, 432, 0, 1352, 1296, 0, 1751, 794, 639, 1197, 1956, 1446, 0,
1604, 839, 0, 1996, 1604, 1197, 1526, 0, 1302, 0, 1514, 648, 378, 597, 799, 681,
1247, 847, 1928, 89, 0, 929, 1396, 937, 937, 1421, 1756, 0, 0, 0, 1117, 612,
794, 0, 89, 864, 1107, 354, 354, 1049, 586, 1709, 354, 553, 0, 354, 681, 164,
0, 1834, 839, 694, 443, 1737, 0, 1996, 0, 0, 1441, 1834, 528, 959, 639, 1247,
0, 782, 627, 27, 1234, 959, 1756, 1783, 1726, 853, 1834, 1647, 1246, 1678, 853, 1684,
0, 186, 1211, 0, 1007, 636, 1756, 0, 1783, 649, 1832, 296, 0, 0, 0, 491,
1659, 329, 0, 0, 382, 0, 1426, 557, 1652, 0, 0, 0, 39, 0, 0, 893,
1687, 597, 0, 0, 412, 422, 1029, 1827, 0, 0, 567, 1254, 1296, 551, 1187, 0,
1657, 29, 1292, 1227, 0, 69, 1991, 1684, 686, 0, 97, 0, 533, 1202, 1082, 0,
1567, 49, 444, 1898, 0, 503, 1472, 346, 0, 0, 662, 1481, 0, 0, 397, 11,
1682, 1919, 1951, 1809, 864, 914, 1627, 0, 1804, 0, 1683, 656, 0, 526, 1716, 472,
0, 0, 0, 0, 1751, 377, 702, 0, 978, 1446, 1898, 0, 0, 1832, 0, 1922,
533, 488, 0, 1704, 1292, 0, 1241, 614, 197, 838, 1426, 0, 0, 0, 0, 839,
0, 1706, 1823, 1461, 1991, 1247, 1281, 1723, 0, 227, 639, 326, 1274, 0, 1948, 0,
802, 416, 1077, 1804, 786, 872, 684, 161, 671, 0, 872, 2001, 837, 0, 0, 0,
1082, 598, 1832, 0, 0, 116, 614, 1602, 592, 0, 0, 0, 0, 639, 0, 71,
0, 1302, 1882, 0, 1681, 1832, 226, 1357, 332, 617, 849, 1783, 1291, 1291, 649, 0,
384, 0, 444, 1391, 1717, 1711, 0, 597, 0, 0, 0, 1686, 646, 564, 0, 1177,
0, 877, 0, 1472, 1471, 516, 0, 1597, 1563, 1792, 0, 1352, 1257, 1247, 1686, 1384,
1462, 847, 22, 824, 1832, 993, 639, 1612, 0, 646, 1406, 937, 1707, 1292, 79, 639,
639, 1952, 0, 0, 1966, 1821, 1911, 721, 1768, 81, 1834, 1296, 1724, 96, 658, 1772,
1539, 0, 2021, 1439, 1439, 406, 529, 867, 1772, 1269, 1708, 0, 0, 0, 612, 594,
769, 0, 1406, 1906, 0, 0, 1467, 838, 162, 0, 0, 0, 0, 639, 1759, 0,
0, 839, 0, 1844, 989, 1926, 1723, 384, 892, 519, 837, 0, 1832, 296, 0, 1827,
0, 893, 412, 29, 0, 29, 1227, 1082, 892, 0, 1898, 444, 97, 49, 594, 1202,
1567, 526, 662, 0, 1683, 397, 1627, 1882, 0, 769, 639, 656, 1716, 1898, 1723, 1772,
488, 837, 847, 646, 838, 1472, 1612, 533, 1426, 614, 0, 639, 0, 1281, 872, 0,
2001, 416, 786, 161, 504, 1077, 1082, 326, 671, 0, 1471, 1991, 1191, 332, 0, 162,
1602, 1686, 0, 1391, 384, 1291, 444, 617, 1302, 0, 71, 1406, 22, 1247, 1563, 516,
1792, 1177, 646, 824, 79, 1768, 81, 937, 993, 1821, 0, 1707, 529, 1439, 867, 2021,
0, 0, 838, 1906, 0, 1093, 1804, 442, 0, 681, 103, 1784, 442, 296, 0, 0,
1364, 456, 1471, 429, 997, 69, 1836, 1936, 0, 1257, 441, 421, 1687, 1782, 1471, 1834,
104, 0, 0, 697, 1201, 611, 1929, 48, 1784, 1776, 0, 0, 0, 0, 1156, 0,
641, 0, 872, 0, 402, 1657, 0, 839, 73, 1939, 0, 1836, 0, 1297, 1726, 186,
289, 0, 1793, 501, 0, 1834, 1786, 0, 1776, 1804, 1834, 1607, 1811, 366, 1701, 397,
506, 9, 0, 1784, 582, 0, 661, 864, 1951, 0, 0, 587, 0, 1362, 1012, 471,
1337, 656, 1751, 1946, 186, 472, 557, 0, 398, 0, 642, 639, 1637, 0, 0, 103,
1702, 691, 1834, 97, 1774, 0, 637, 1706, 702, 687, 1636, 671, 1602, 382, 382, 777,
503, 1703, 0, 0, 658, 0, 0, 94, 1481, 442, 11, 1986, 1197, 0, 1256, 51,
326, 894, 1309, 646, 687, 1639, 1776, 1836, 1247, 837, 1799, 1976, 0, 379, 0, 1466,
1247, 671, 1804, 0, 671, 1991, 802, 346, 1246, 228, 486, 686, 1296, 0, 0, 636,
1484, 0, 189, 982, 1357, 0, 1291, 1602, 597, 1602, 384, 661, 947, 442, 226, 1636,
1783, 567, 1837, 1206, 786, 957, 597, 1811, 1837, 1704, 687, 649, 121, 413, 0, 1811,
0, 1716, 1691, 1471, 569, 202, 1577, 1712, 1384, 877, 637, 597, 646, 0, 552, 237,
0, 1804, 1794, 1784, 636, 839, 1607, 754, 1601, 1601, 1079, 1637, 928, 1099, 658, 1926,
177, 637, 1966, 1924, 0, 1793, 1801, 1156, 189, 1939, 879, 1822, 887, 69, 1501, 1987,
0, 1702, 697, 1807, 1602, 1521, 656, 0, 602, 69, 0, 1539, 617, 407, 1267, 857,
1784, 0, 684, 1717, 1717, 1637, 933, 2021, 1834, 1811, 894, 371, 0, 1767, 1804, 1204,
1989, 912, 1706, 1802, 636, 1877, 1832, 1906, 0, 1787, 1204, 1107, 0, 1471, 1811, 967,
312, 1844, 1834, 828, 1244, 892, 0, 882, 1501, 1844, 1811, 519, 0, 837, 897, 1093,
681, 636, 1836, 997, 1471, 1156, 1776, 121, 48, 1929, 501, 346, 892, 1776, 1726, 1786,
872, 186, 1297, 1836, 1767, 1657, 1521, 1939, 397, 506, 1751, 582, 1946, 471, 897, 587,
0, 97, 837, 691, 503, 382, 1834, 1717, 1602, 1703, 1309, 982, 11, 786, 51, 1197,
0, 228, 486, 1836, 1539, 597, 567, 384, 597, 1291, 237, 957, 1704, 0, 1794, 1691,
0, 637, 1804, 646, 569, 1801, 1811, 1924, 879, 857, 656, 684, 1834, 894, 0, 1906,
1811, 631, 0, 519, 1501, 893, 0, 0, 648, 1717, 272, 648, 648, 1782, 272, 894,
1826, 251, 638, 1182, 0, 1182, 1954, 702, 1953, 646, 972, 972, 1833, 877, 177, 0,
867, 1077, 1247, 894, 684, 702, 0, 839, 0, 1782, 641, 972, 839, 1454, 1911, 867,
671, 1247, 0, 0, 251, 934, 934, 1248, 0, 441, 979, 0, 0, 1184, 1298, 1296,
1012, 0, 0, 0, 1296, 979, 837, 426, 441, 1296, 1296, 927, 955, 930, 621, 918,
2001, 0, 422, 617, 617, 0, 0, 1606, 1633, 586, 0, 0, 586, 1483, 837, 1082,
837, 571, 571, 1804, 1257, 288, 1709, 0, 1009, 1009, 1257, 284, 204, 1828, 323, 1801,
1712, 1783, 1296, 0, 1783, 1282, 1844, 837, 293, 357, 118, 1781, 0, 1783, 1573, 14,
1928, 0, 118, 1801, 957, 1910, 1783, 357, 0, 1938, 423, 442, 443, 993, 993, 1837,
254, 1299, 167, 0, 0, 0, 968, 22, 81, 1657, 69, 1837, 0, 1657, 338, 974,
1034, 0, 1991, 503, 0, 346, 422, 1582, 1836, 1202, 161, 466, 1249, 0, 1576, 1596,
1483, 1824, 422, 419, 1687, 27, 0, 1657, 1941, 1297, 1466, 1472, 1829, 1472, 1622, 1702,
54, 671, 627, 1299, 1783, 1636, 1521, 1706, 1719, 1783, 0, 67, 0, 1292, 551, 0,
1663, 591, 839, 384, 1896, 0, 1694, 1896, 1119, 1044, 1247, 1901, 639, 1991, 636, 636,
1247, 636, 188, 0, 179, 567, 1777, 1807, 1734, 46, 0, 1474, 1991, 186, 1783, 688,
1612, 872, 872, 201, 1302, 1734, 1807, 1099, 0, 1793, 234, 788, 1833, 0, 1803, 1077,
1877, 2001, 1298, 0, 1783, 1157, 384, 1699, 1804, 271, 2001, 321, 0, 0, 1779, 188,
179, 567, 1807, 688, 872, 46, 1612, 1991, 1807, 1833, 234, 1298, 1699, 882, 1177, 0,
1177, 1783, 882, 0, 491, 716, 0, 0, 277, 882, 491, 716, 526, 1291, 0, 526,
1844, 0, 567, 0, 1732, 0
};

/*FUNCTION_HEADER**********************
 * NAME:	;ConvertToAscii
 * DESC: 	
 * IN:		
 * OUT:		
 * RETURN:	
 * NOTES:	
 *END_HEADER***************************/
int ConvertToAscii(void *phTTS, wchar_t *sourceString, char *returnPinyinBuf, BOOL bUnicode)
{
	
	wchar_t *begStringPtr = sourceString, 
			*tempStringPtr = sourceString, 
			*endStringPtr;
	wchar_t *matchWordPtr;
	
	char	*pinyinBufPtr = returnPinyinBuf;
	char	cMb;
	int		lineLength = 0,
			iLen=0;
	int		result = 0;
	
	lineLength = wcslen(tempStringPtr);
	endStringPtr = begStringPtr + lineLength - 1;
	
	while (lineLength)
	{
		
		// If the characters that are in the Unicode CJK range
		if (*tempStringPtr >= 0x4E00 && *tempStringPtr <= 0x9FA5)
		{
			// Get the initial offset in the list.
			int offset;
			wchar_t Unicode = *tempStringPtr;
			
			offset = CJKUnicodeOffsetToPinyinTable[Unicode - 0x4E00];
			
			
			if (offset < 2500)
			{
				if( pinyinBufPtr )
				{
					strcpy(pinyinBufPtr, PinyinTableWithTones[offset]);
					pinyinBufPtr += strlen(PinyinTableWithTones[offset]);
				}

				iLen += strlen(PinyinTableWithTones[offset]);

			}
			
			else
				/* This is a poly phone character */
			{
				int i;
				int matchWordLength = 0;
				char tempPinyinWithTone[10], foundAMatch;
				
				/*	Re-adjust the offset (2500 was added to the original offset as a signal). */
				offset -= 2500;
				/* Get the default pinyin from the table first */
				strcpy(tempPinyinWithTone, PinyinTableWithTones[offset]);
				
				foundAMatch = 0;
				/* Check for every char in the poly phone table */
				for (i = 0; !foundAMatch && i < numberOfChars; i++)
				{
					if (Unicode != polyPhoneTable[i].theChar)
						continue;
					
					/* Found the character, now get ready to go through the sound list */
					soundNodePtr = polyPhoneTable[i].charToSoundPtr;
					do {
						
						currentSoundNodePtr = soundNodePtr;
						
						/* Now go through the word list of the sound to see if there's a match */
						wordNodePtr = currentSoundNodePtr->wordListPtr;
						do {
							
							currentWordNodePtr = wordNodePtr;
							
							matchWordPtr = wcschr(currentWordNodePtr->wordContent, Unicode);
							if (!matchWordPtr)
							{
								wordNodePtr = currentWordNodePtr->nextWordPtr;
								printf("Found a word that doesn't contain the character.\n");
								continue;
							}
							matchWordLength = wcslen(currentWordNodePtr->wordContent);
							matchWordPtr = tempStringPtr - (matchWordPtr - currentWordNodePtr->wordContent);
							if (!wcsncmp(matchWordPtr, currentWordNodePtr->wordContent, matchWordLength))
								/* found a match */
							{
								foundAMatch = 1;

								if( pinyinBufPtr )
								{
									strcpy(pinyinBufPtr, currentSoundNodePtr->pinyinWithTone);
									strupr(pinyinBufPtr);
									pinyinBufPtr += strlen(currentSoundNodePtr->pinyinWithTone);
								}
								iLen += strlen(currentSoundNodePtr->pinyinWithTone);
							}
							
							wordNodePtr = currentWordNodePtr->nextWordPtr;
							
						} while (wordNodePtr && !foundAMatch);
						
						soundNodePtr = currentSoundNodePtr->nextSoundPtr;
						
					} while (soundNodePtr && !foundAMatch);
				}
				if (!foundAMatch)
				{
					if( pinyinBufPtr )
					{
						*pinyinBufPtr++ = '*';
						strcpy(pinyinBufPtr, tempPinyinWithTone);
						pinyinBufPtr += strlen(tempPinyinWithTone);
						strcpy(pinyinBufPtr++, "*");
					}
					iLen += strlen(tempPinyinWithTone) + 2;
				}
			}
			
		}
		
		// If CJK Symbols and Punctuation
		else if (*tempStringPtr >= 0x3000 && *tempStringPtr <= 0x303F)
		{
			;
		}
		
		// if Wide Ascii
		else if (iswascii( *tempStringPtr))
		{
			if( pinyinBufPtr )
			{
				wctomb(&cMb, *tempStringPtr);
				if (cMb == 0x09)
					*pinyinBufPtr = ' ';
				else
					*pinyinBufPtr = cMb;

				pinyinBufPtr++;
			}
			else
			{
				iLen++;
			}
		}
		
		lineLength--;
		tempStringPtr++;
   	}

	return iLen;
}

#ifdef CJK2PINYIN_PROJECT
/*FUNCTION_HEADER**********************
 * NAME:	;main
 * DESC: 	
 * IN:		
 * OUT:		
 * RETURN:	
 * NOTES:	
 *END_HEADER***************************/
void main(int argc, char **argv)
{
	char	sfileName[_MAX_PATH] = "in.txt", 
			dfileName[_MAX_PATH] = "out.txt";
	FILE	*fIn;
	FILE	*fOut;
	wchar_t lineInBuffer[300];
	BYTE	lineOutBuffer[600];

	/* Get Source File */
	if( (fIn = fopen(sfileName, "rb")) == NULL )
	{
		printf("Source Text File %s not found.\n", sfileName);
		exit(-1);
	}

	/* Target */
 	if( (fOut = fopen(dfileName, "wt")) == NULL)
	{
		printf("File %s cannot be created.\n", dfileName);
		exit(-1);
	}
	else
		printf("File %s has been opened for creation.\n", dfileName);
               
	while( fgetws(lineInBuffer, 300, fIn) )
	{
		if( ConvertToAscii(NULL, lineInBuffer, NULL, TRUE) > 0 )				// Get the number of output characters
		{
			ConvertToAscii(NULL, lineInBuffer, lineOutBuffer, TRUE);			// Convert CJK to Pinyin
			printf("%s\n", lineOutBuffer);
			fwrite(lineOutBuffer, sizeof(char), strlen(lineOutBuffer), fOut);
		}
	}

	/* Get ready to close the files */
	fclose(fIn);
	fclose(fOut);
}
#endif

/****************************************************************************/
/****************************************************************************/

#ifdef BUILDPOLYPHONESTRUCT

/*FUNCTION_HEADER*******************
 * NAME:	  ;CheckUnicodeHeader
 * DESC:	  Read the first two or three bytes of a Unicode file to see what kind it is.
 * IN:     fp - File to check.
           pbLittleEndian - Address in which to return a flag indicating whether the unicode
             file is little-endian or not.
 * OUT:    *pbLittleEndian is modified (IF the file is unicode).
           The file is advanced beyond the 2- or 3-byte header, if there is one,
           or is rewound to the beginning, if there is not.
 * RETURN: TRUE if the file is unicode, FALSE otherwise.
 * NOTES:  File should be opened and positioned at the very beginning.
 *END_HEADER***************************/
BOOL CheckUnicodeHeader(FILE *fp, BOOL *pbLittleEndian)
{
   BOOL bUnicode=FALSE;
   unsigned char sBuf[4];

   /* Unicode files usually begin with "FF FE" (little-endian), or "FE FF" (big-endian).
      So check to see if we have one of those cases. */
   fread(sBuf, 2, 1, fp);
   if (sBuf[0]==0xFF && sBuf[1]==0xFE)
   {
	   bUnicode = TRUE;
	   *pbLittleEndian=TRUE;
   }
   else if (sBuf[0]==0xFE && sBuf[1]==0xFF)
   {
	   bUnicode = TRUE;
	   *pbLittleEndian=FALSE;
   }
   else
   {
      /* Compressed unicode files begin with a byte before the FFFE/FEFF bytes
         that inidcate what kind of compression is used.  We'll ignore most kinds,
         but two standard kinds we can handle:
           0x0E => This is a regular (uncompressed, UTF-16) unicode file.
           0x0F => This is a UTF-8 unicode file, i.e., it uses 1 byte per character, 
                   probably in ASCII, so just treat it as though it was not unicode.
         See http://www.unicode.org/unicode/reports/tr6/index.html#Signature
      */
      fread(&sBuf[2], 1, 1, fp);
      if (sBuf[1]==0xFF && sBuf[2]==0xFE)
         *pbLittleEndian=TRUE;
      else if (sBuf[1]==0xFE && sBuf[2]==0xFF)
         *pbLittleEndian=FALSE;
      else fseek(fp, 0, SEEK_SET);
      bUnicode=FALSE;
   }
   return bUnicode;
}  /* CheckUnicodeHeader */



/*FUNCTION_HEADER*******************
 * NAME:	;BuildPolyPhoneStruct
 * DESC:	Go through the poly phone file and build linked structures to cover all characters, 
			their individual sounds and the associated words of each sound.
           
 * RETURN:	0 on success, -1 on error.
 * NOTES:	The poly phone file MUST be encoded in the Unicode (Little Endian format - FF FE), 
			prepared with Nodepad with Tabs as delimiters.
 *END_HEADER***************************/
int BuildPolyPhoneStruct(wchar_t *sourceString)
{
   wchar_t *tempStringPtr = sourceString, *endTemp;
   char cMb, *soundPtr = (char *)sourceString;


   int result = 0;

   /* From the very beginning of the line */

   if (*tempStringPtr != '\t')
	/* Found a CHARARACTER definition line */
	{
		numberOfChars++;

		/* Initiate the number of sounds for this character */
		numberOfSounds = -1;
		
		/* get to the position of the character */
		while (*tempStringPtr == ' ')
			tempStringPtr++;

		while (*tempStringPtr != ' ')
			tempStringPtr++;
			endTemp = ++tempStringPtr;

		while (*endTemp != ' ')
			endTemp++;
		*endTemp = 0;
		
		/* Copy the char to the table */
		wcscpy(&polyPhoneTable[numberOfChars].theChar, tempStringPtr);
//		wprintf((wchar_t *)"\n\nFOUND Char %d \"%0X\"\n", numberOfChars + 1, polyPhoneTable[numberOfChars].theChar);

		/* make sure its sound link is first NULL termainated */
		polyPhoneTable[numberOfChars].charToSoundPtr = NULL;
	}

	else if (*(tempStringPtr + 1)!= '\t')
	/* Found a SOUND definition line */
	{
		numberOfSounds++;

		/* Initiate the number of words for this sound */
		numberOfWords = -1;

		/* get to the position of the sound (pinyin and tone) */
		endTemp = ++tempStringPtr;
		while (*endTemp != ' ')
			endTemp++;
		*endTemp = '\0';

		/* Work on the sound structure */
		soundNodePtr = (struct soundNode *)malloc(sizeof(struct soundNode));
		if (soundNodePtr == NULL)
			printf("ERROR WITH SOUND MALLOC.\n");
		
		if (numberOfSounds == 0)
			polyPhoneTable[numberOfChars].charToSoundPtr = soundNodePtr;
		else
			currentSoundNodePtr->nextSoundPtr = soundNodePtr; 

		/* Update current sound struct and current Ptr */
		currentSoundNodePtr = soundNodePtr;
		currentSoundNodePtr->nextSoundPtr = NULL;

		/* Convert from Unicode to ascii for the ultimate output */
		if (iswascii( *tempStringPtr))
		{
			while (*tempStringPtr != '\0')
			{
				wctomb(&cMb, *tempStringPtr);
				*soundPtr = cMb;
				tempStringPtr++;
				soundPtr++;
			}
			*soundPtr = '\0';
		}

		/* Copy the sound */
		strcpy(currentSoundNodePtr->pinyinWithTone, (char *)sourceString); 
//		wprintf((wchar_t *)"\nFound SOUND \"%s\"\n", currentSoundNodePtr->pinyinWithTone);
	}
	else
	/* Found a WORD definition line */
	 {
		numberOfWords++;

		/* get to the position of the word */
		endTemp = tempStringPtr += 2;

		while (*endTemp != 0x000D)
			endTemp++;
		*endTemp = 0;

		wordNodePtr = (struct wordNode *)malloc(sizeof(struct wordNode));
		if (wordNodePtr == NULL)
			printf("ERROR WITH WORD MALLOC, Sound %s Char %d \"%s\".\n", currentSoundNodePtr->pinyinWithTone, numberOfChars+1, polyPhoneTable[numberOfChars].theChar);
			

		if (numberOfWords == 0)
				currentSoundNodePtr->wordListPtr = wordNodePtr;
		else
				currentWordNodePtr->nextWordPtr = wordNodePtr;

		/* Update current word struct and current Ptr */
		currentWordNodePtr = wordNodePtr;
		currentWordNodePtr->nextWordPtr = NULL;

		/* Copy the word */
		wcscpy(currentWordNodePtr->wordContent, tempStringPtr);
//			wprintf((wchar_t *)"\nFound WORD \"%X\"\n", currentWordNodePtr->wordContent);
	}

	/* Return and get the next line */
	return result;
}



/*FUNCTION_HEADER*******************
 * NAME:	  ;ReadWordList
 * DESC:	  Read a file containing lines of the form "<ID#><tab><word or phrase>\n"
 * IN:     sWordList  - Filename of word list file containing lines with 
                          "<ID#><tab><word or phrase>\n" (Ignore any lines beginning with non-numeric characters).
           ppsWords   - Address in which to return a pointer to an array of 
                          strings with the words (or phrases).
           ppiWordIDs - Address in which to return a pointer to an array of 
                          ID#s associated with each element in (*ppsPhrases)[].
 * OUT:    *ppsPhrases and *ppiPhraseID are modified.
 * RETURN: Number of words or phrases read (or -1 on error).
 * NOTES:
 *END_HEADER***************************/
int FnxReadWordList(char *wsWordFile, char *wsWordConvertionFile)
{
	FILE *fpRead, *fpWrite;                     /* Word list file */
	wchar_t wsBuf[MAX_PHRASE_LENGTH*sizeof(wchar_t)] = {0}; /* Character array to read each line into */
	unsigned char sBuf[MAX_PHRASE_LENGTH] = {'\0'}; /* Character array to read each line into */
	unsigned char pinyinBuf[MAX_PHRASE_LENGTH] = {'\0'}; /* Character array to read each line into */
	int  iNumWords=0;        /* Number of words in pWordList and pIDList */
	SDWORD iNumber = 0;
	BOOL bUnicode;           /* Flag for whether the text file is unicode */
	BOOL bLittleEndian;      /* Flag for whether the unicode file is little-endian */
	BOOL bGrammar = FALSE;
	BOOL bSwap = FALSE;
	
	FILE* fIn;
	wchar_t lineMark[] = {0x0D, 0x0A, 0x00};
	
	
	/* Read in the poly phone table file and build the necessary structures for later scanning */
	fIn = fopen("PolyPhoneTable.txt", "rb");
	if (!fIn)
	{
		printf("Poly sound file \"poly.txt\" cannot be found.\n");
		exit(-1);
	}
	
    bUnicode = CheckUnicodeHeader(fIn, &bLittleEndian);
	
	bUnicode = TRUE;
	while (bUnicode ? (int)fgetws(wsBuf, MAX_PHRASE_LENGTH, fIn) : (int)fgets(sBuf, MAX_PHRASE_LENGTH, fIn))
	{
		if (bUnicode)
		{
#ifdef WORDS_LITTLEENDIAN
			if (!bLittleEndian)
#else
				if (bLittleEndian)
#endif
				{  /* Swap the bytes if different from the host */
					BlockByteSwap16(wsBuf, wcslen(wsBuf));
				}
				
				BuildPolyPhoneStruct(wsBuf);
				
		}
		wsBuf[0] = 0;
	}
	
	/* Close the poly phone file */
	fclose(fIn);
	
	
	
	/* Open and process the source text file, generating the needed pinyin symbols and their tones */
#ifndef WORDS_LITTLEENDIAN
	bSwap = TRUE;
#endif
	/* Open the word list file */
	fpRead = fopen(wsWordFile, "rb");
	if (fpRead==NULL)
	{
		//      Message(NULL,"Error: Could not open word list file '%S'\n", wsWordList);
		return -1;
	}
	
	fpWrite = fopen(wsWordConvertionFile, "w");
	
	bUnicode = CheckUnicodeHeader(fpRead, &bLittleEndian);
	
	bUnicode = TRUE;
	while (bUnicode ? (int)fgetws(wsBuf, MAX_PHRASE_LENGTH, fpRead) : (int)fgets(sBuf, MAX_PHRASE_LENGTH, fpRead))
	{
		if (bUnicode)
		{
#ifdef WORDS_LITTLEENDIAN
			if (!bLittleEndian)
#else
				if (bLittleEndian)
#endif
				{  /* Swap the bytes if different from the host */
					BlockByteSwap16(wsBuf, wcslen(wsBuf));
				}
				
				ConvertToAscii(wsBuf, pinyinBuf, bUnicode, bSwap);
		}
		else
		{
			//			int strLength;
			//			wchar_t * wTemp;
			// We need to check each line to see if it is Unicode or not.
			//			if (sBuf[0] < 0x80)
			//			{
			
			//				strLength = strlen(sBuf);
			//				memset(wsBuf, 0, MAX_PHRASE_LENGTH*sizeof(wchar_t));
			// We need to convert the sentence to wide for the convertion to romongi.
			//				mbstowcs( wsBuf,  sBuf, strLength );
			//				wTemp = wsBuf;
			//			}
			//			else
			//			{
			//				wTemp = (wchar_t *)sBuf;
			//				BlockByteSwap16(wTemp, wcslen(wTemp));
			//			}
			// sBuf will be over written.
			ConvertToAscii((wchar_t*)sBuf, pinyinBuf, FALSE, bSwap);
		}
		
		if (pinyinBuf[0]==0)
		{
			//		   printf("\n");
			fwrite("\n", sizeof(char), 1, fpWrite);
			continue; /* Skip blank lines */
		}
		
		//     printf("Pinyin String = %s\n", pinyinBuf);
		fwrite(pinyinBuf, sizeof(char), strlen(pinyinBuf), fpWrite);
		
		memset(pinyinBuf, 0, MAX_PHRASE_LENGTH);
		sBuf[0] = 0;
		wsBuf[0] = 0;
		
	}  /* while not at end of file */
	
	/* Close the word list file */
	fclose(fpWrite);
	fclose(fpRead);
	return 0;
}  /* ReadWordList */



/****************************************************************************/
main()
{

	FnxReadWordList("input.txt", "output.txt");

}

/****************************************************************************/
#endif	// BUILDPOLYPHONESTRUCT