/***********************************************
	ACC_22XX.C	updated at 22th January 1990
	ʳΥȷ롼
 ***********************************************/

#define		EXT		extern

#include	"onsei.h"
#include	"ile_acch.h"
#include	"ile_fddh.h"
#include	"ile_shdh.h"
#include	"ile_stch.h"
#include	"ile_stzh.h"
#include	"ile_func.h"
#include "pkind.h"
#include "ile_accd.h"

/*========== ACC22XX(i,j) ====================================
	ǽܤǤΥȷΤ
		ǤͿƶȡǤѲͻ롣
  ============================================================*/
void ACC22XX(i,j,a21,a22) integer_16 i,j; register WORD a21,a22; {

	/* ФƶΤΤ˽롣*/
	if(a21==10){ ACC221A(j-1); }

	switch(a22){
	case  1:	ACC2221(j); break;
	case  3:	ACC0001(j); break;
	case  4:	ACC0005(j); break;
	case  5:	ACC2225(j); break;
	case  6:	ACC2226(i,j); break;
	case  7:	ACC2225(j); break;
	case  8:	ACC0004(j); break;
	case 10:	ACC222A(i,j); break;
	case 11:	ACC222B(i,j); break;
	case 12:	ACC222C(i,j); break;
	case 14:	ACC222E(i,j); break;
	case 101:	ACC222Z(j); break;		/* 夬ʣ̾ξ */
	}

	switch(a21){
	case  1:	ACC000H(i); break;
	case  2:	ACC0002(i); break;
	case  3:	ACC2213(i); break;
	case  4:	ACC2214(i); break;
	case  6:	ACC2216(i,j); break;
	case  7:	ACC2217(i,j); break;
	case  8:	ACC0001(i); break;
	case  9:	ACC2219(i); break;

	/*case 10:	ACC221A(i); break;		ԡ¡ġ*/
	/*case 11:	ACC221B(i); break;		ԡ¡ġ*/

	}
}

/****************************************************************************/
/*																			*/
/*			鲼ϡʳΥȷ롼					*/
/*																			*/
/****************************************************************************/

/*========== ACC22CV(p,q) ==================================
	ǽʣư졦ʣƻΥȤꤹ

	ʿĲϹ⤯դơȤ
	âʿķưΤȤϡⲽ롣
  ==========================================================*/
void ACC22CV(p,q) integer_16 p; register integer_16 q; {
	register integer_16 qp;
	integer_16 r,bno;

	ACC000H(p);
	qp=phrase_ptr[q];
	if(phrase_kind[q]==pkind_adj_stem){ goto ACC22CV_200; }
	/* ʿķưϹ⤯դⲽ*/
	if(chk_heiban(q)){ ACC0002(q); }
ACC22CV_200:
	/* ư졦ƻϹ⤯դƼʬ롣*/
	if(accent0[qp]==1){ accent0[qp]=2; }

	/*
	 *	 ʣѸ̾첽ȤʿĲ뤳Ȥ¿
	 * ޤư첽Ȥⲽ뤳Ȥ¿
	 *	 椨ˡѸθüֹΤҤȤĤĴ٤ơ
	 * Ѹ̾줫ɤĴ٤롣
	 *	ˡưϤϡġ̾
	 *			ưϤ᤿ġư
	 *			ưϤơġư
	 */
	if(r=next_phrase(q)){
		--r;
		/*
		 * rϼʸľǤؤ
		 * ưФפΤȤϡ֤סr=q+1
		 * ưϤפΤȤϡֻϤסr=q
		 */
		for(bno=0;bno<stc_nbno[r];++bno){
			if(bno=stc_bno[r][bno]){ goto ACC22CV_590; }
		}
	}
ACC22CV_590:
	/*
	 * ưϤ᤬סưϤϡפΡֻϤפθüֹϣǤ롣
	 * ưϤסưϤ᤿פΡֻϤפθüֹϣǤ롣
	 * üֹ椬ΤȤθȤߤʤΤȤѸȤߤʤ
	 */
	if(bno_tbl[bno]==pkind_noun){
		/* θʤСʿĲ롣*/
		ACC0005(q);
	}
}

/****************************************************************************/
/*																			*/
/*		ȷΡǤͿƶ				*/
/*																			*/
/****************************************************************************/

/*========== ACC2213(p) ====================================================
	ǽܤǤⲽθκǽ郎첻ʤ餽򲼤롣
			ˡַкѡפΡ֤פΡ֤פ롣
  ==========================================================================*/
void ACC2213(p) integer_16 p; {
	register integer_16 pp,pl;
	pp=phrase_ptr[p]; pl=phrase_len[p];
	ACC0002(p);
	/*
	 * ǽ郎첻ΤȤȳˤ鷺餹
	 * 첻Ƚλϼ̤Ǥ롣
	 *	ʾǤǡǽ郎ʥˤǡ
	 *	ҤȤ郎¥ĹʳǤ뤳ȡ
	 */
	if(pl>1 && omega[pp+pl-1]==0x01 && omega[pp+pl-2]<0xC0){
		accent0[pp+pl-1]=1; accent0[pp+pl-2]=0x82;
	}
}

/*========== ACC2214(p) ===============================
	ǽܤǤʿĤǤʤⲽ
		θκǽ郎첻ʥˤʤ餽򲼤롣
  =====================================================*/
void ACC2214(p) integer_16 p; {
	register integer_16 pp,pl;
	/*if((pl>1 && accent0[pp+pl-1]==2)||(pl==1 && accent0[pp]==1)){*/
	if(chk_heiban(p)==0){
		pp=phrase_ptr[p]; pl=phrase_len[p];
		ACC0002(p);
		/*
		 * ǽ郎첻ʥˤΤȤȳˤ鷺餹
		 * 첻Ƚλϼ̤Ǥ롣
		 *	ʾǤǡǽ郎ʥˤǡ
		 *	ҤȤ郎¥ĹʳǤ뤳ȡ
		 */
		if(pl>1 && omega[pp+pl-1]==0x01 && omega[pp+pl-2]<0xC0){
			accent0[pp+pl-1]=1; accent0[pp+pl-2]=0x82;
		}
	}
}

/*========== ACC2216(p) ========================================================
	ǽܤǤΤȤȤ˰ư롣
		âƬⷿϡưʤʤ褤
		ޤ촴θ夫飲ܤ¥ʤ顢ưʤʤäѤ

		(ex.) ĤĤɤɤ

		(1)	ư֤סư֤ס˰ưʤ
		(2)	񤤡֤ơ					˰ư
		(3)	ưɡ֤					˰ưʤ

		(1)ˤĤƤϡե饰Σӥåܤθ롣

		updated 87/9/7
  ==============================================================================*/
void ACC2216(p,q) integer_16 p,q; {
	register integer_16 pp,pl;
	integer_16 pls;
	pp=phrase_ptr[p]; pl=phrase_len[p];
	/*
	 * ֡///סư///סǤ狼ɤϡ
	 *ǤǷ롣
	 */
	/*
	 *	Ƭˤʤꤦʤˤϰưʤ
	 *	Ƭˤʤꤨʤ˰ư롣
	 */
	pls=stc_out_len[q-1];			/* ľǤĹ */

	/*
	 * ΡˣݣܤĹʾǸ夫飲ܤ¥ʤưʤ
	 * ʺˣबΤȤϰưʤ
	 *		ˤäѤäѤ
	 *			ưư
	 */
	/*if(pl>=3 && (omega[pp+pl-2] & 0xF8)==0xC8){ return; }*/
	/*if(stc_accent_raw[p][6]==1){ return; }*/
	if(stc_accent_raw[q-1][6]==1){ return; }

	/* ե饰Σӥåܤʤưʤ*/
	if(stc_f2[q-1] & BITFLG2_AUX){ return; }
	/* ĹƬˤʤꤦΤϰưʤ*/
	if(pls==1 && (stc_ctl[q-1] & BITCTL_FIRST)){ return; }
	/* Ǥʤаưʤ*/
	if(accent0[pp+pl-1]!=0x82){ return; }

	/* Ƭˤʤꤦ롢Ĺʾϰư롣*/
	/* ƬˤʤꤨʤĹʾϰư롣*/
	if(pp+pl>1){
		accent0[pp+pl-2]=0x82; accent0[pp+pl-1]=1;
	}
}

/*========== ACC2217(p,q) ============================================
	ǽܤǤΤȤȤ˰ư롣
		ʿĤΤȤⲽ롣
		âƬⷿϡưʤʤ褤
		ޤ촴θ夫飲ܤ¥ʤ顢ưʤʤäѤ

		(ex.) ĤĤäɤɤä
  ====================================================================*/
void ACC2217(p,q) integer_16 p,q; {
	register integer_16 pp,pl;
	integer_16 pls;
	pp=phrase_ptr[p]; pl=phrase_len[p];
	/*
	 *	֡////ס֡///סǤ狼ɤϡ
	 *	ǤǷ롣
	 */
	pls=stc_out_len[q-1];
	/* ʿķⲽ롣*/
	if((pls>1 && accent0[pp+pl-1]==2)||(pls==1 && accent0[pp]==1)){
		ACC0002(p); return;
	}
	/*
	 * ΡˣݣܤĹʾǸ夫飲ܤ¥ʤưʤ
	 * ʺˣबΤȤϰưʤ
	 *		ˤäѤäѤä
	 */
	/*if(pl>=3 && (omega[pp+pl-2] & 0xF8)==0xC8){ return; }*/
	if(stc_accent_raw[q-1][6]==1){ return; }

	/* ե饰Σӥåܤʤưʤ*/
	if(stc_f2[q-1] & BITFLG2_AUX){ return; }
	/* ĹƬˤʤꤦΤϰưʤ*/
	if(pls==1 && (stc_ctl[q-1] & BITCTL_FIRST)){ return; }
	/* Ǥʤаưʤ*/
	if(accent0[pp+pl-1]!=0x82){ return; }

	/* Ƭˤʤꤦ롢Ĺʾϰư롣*/
	/* ƬˤʤꤨʤĹʾϰư롣*/
	if(pp+pl>1){
		accent0[pp+pl-2]=0x82; accent0[pp+pl-1]=1;
	}
}

/*========== ACC2219(p) ======================================
	ǽܤǤʾǡܤ㤤Ȥơ
		ʿĲ롣
  ============================================================*/
void ACC2219(p) integer_16 p; {
	register integer_16 pp,pl;
	pp=phrase_ptr[p]; pl=phrase_len[p];
	if(pl>1 && accent0[pp+pl-1]==1){
		;
	}else{
		ACC000H(p);
	}
}

/*========== ACC221A(p) ==============================================
	ǽܤǤǡġθüֹ椬üֹɽǤߤơ
		ӥåܤΤȤǤʿĲ롣
  ====================================================================*/
void ACC221A(p) integer_16 p; {
	register integer_16 pp,pl;
	integer_16 n;

	/*㳰ܤǤΣबΤȤܤʿĲ롣*/
	if(stc_accent_raw[p][6]==3){ ACC000H(p); return; }

	pp=phrase_ptr[p]; pl=phrase_len[p];
	if(accent0[pp+pl-1]!=0x82){ return; }

	for(n=stc_nbno[p];n--;){
		if(FddHDR[Fdd_Header.Fdd_BnoTblOfs+stc_bno[p][n]-1] & BITBNO_2){
			ACC000H(p); return;
		}
	}
}

/*========== ACC221B(p) ==============================================
	ǽ
  ====================================================================*/
void ACC221B(p) integer_16 p; {
}

/****************************************************************************/
/*																			*/
/*		ȷΡʬȤѲλ				*/
/*																			*/
/****************************************************************************/

/*========== ACC2221(q) =====================================================
	ǽܤǤϣη򤹤

	裱Ϲ⤯ʤꡢ裲Ȥ롣
	裲ȤʤȤϡ
	ʿķΤȤϡ裲ȡᣱ
	ʳϡ裲ȡ裱ȡȤ롣(89/1/10)
  ==============================================================================*/
void ACC2221(q) integer_16 q; {
	register integer_16 qp;
	BYTE acc2;

	acc2=stc_accent_raw[q][4];	/* 裲 */

	/* 裲Ȥʤ顢⤯Ĥ裲Ȥ롣*/
	if(acc2!=0xFF){
		/* 裲ȤСѤ롣*/
		if(acc2==0){ ACC000H(q); }else{ ACC0003(q,acc2); }
	}

	/* 裲Ȥ̤ΤȤ*/
	if(stc_accent_raw[q][0]==0){
		/* ʿķʤСܤ롣*/
		ACC0001(q);
	}else{
		/* ʿķʳʤС⤯դ裱Ȥ롣*/
		qp=phrase_ptr[q];
		if(accent0[qp]==1){ accent0[qp]=2; }
	}
}

/*========== ACC2222(q) ====================
	ǽܤǤϣη򤹤롣
	¨⤯դơȤ롣
	ߡ̤ѡ
void ACC2222(q) register integer_16 q; {
	register integer_16 qp;
	qp=phrase_ptr[q];
	if(accent0[qp]==1){ accent0[qp]=2; }
}
  ==========================================*/

/*========== ACC2223(q) ====================
	ǽܤǤϣη򤹤

	¨⤯դơǽ
  ==========================================*/
void ACC2223(q) integer_16 q; {
	register integer_16 qp,ql;
	qp=phrase_ptr[q]; ql=phrase_len[q];
	ACC0003(q,ql-1);		/* ⲽ */
	accent0[qp]=2;
}

/*========== ACC2224(p) ====================
	ǽܤǤϣη򤹤

	¨⤯դơΤʿĲ
 ACC2224(p) integer_16 p; { ACC0005(q); }
 ==========================================*/

/*========== ACC2225(p) ====================
	ǽܤǤϣη򤹤

	¨⤯դơΤⲽ
 ==========================================*/
void ACC2225(p) integer_16 p; {
	register integer_16 pp,pl;
	pp=phrase_ptr[p]; pl=phrase_len[p];
	ACC0005(p);
	accent0[pp+pl-1]=0x82;
}

/*========== ACC2226(p,q) ============================================
	ǽܤǤϡܤǤ˰¸ơη򤹤

	¨ܤʿķʤй⤯դȤ롣
	ǤʤСΤ㤯դ
  ====================================================================*/
void ACC2226(p,q) integer_16 p; register integer_16 q; {
	register integer_16 qp;
	/*integer_16 pp,pl;*/
	/*pp=phrase_ptr[p]; pl=phrase_len[p];*/
	/*if((pl>1 && accent0[pp+pl-1]==2)||(pl==1 && accent0[pp]==1)){*/
	if(chk_heiban(p)){
		if(accent0[qp=phrase_ptr[q]]==1){ accent0[qp]=2; }
	}else{
		ACC0004(q);
	}
}

/*========== ACC2227(p,q) ==================================================
	ǽܤǤϡܤǤ˰¸ơη򤹤

		¨ܤʿķΤȤ⤯Ĥľ롣
		ʤС㤯Ĥ
  ==========================================================================*/
void ACC2227(p,q) register integer_16 p,q; {
	/*register integer_16 pp,pl; pp=phrase_ptr[p]; pl=phrase_len[p];*/
	/*if((pl>1 && accent0[pp+pl-1]==2)||(pl==1 && accent0[pp]==1)){*/
	if(chk_heiban(p)){
		ACC0001(q);		/* ܤƬ */
	}else{
		ACC0004(q);		/* ܤΤ㤤*/
	}
}

/*========== ACC2228(p) ====================
	ǽܤǤϣη򤹤
	¨㤯դ
  ACC2228(p) integer_16 p; { ACC0004(p); }
  ==========================================*/

/*========== ACC222A(p,q) ============================================
	ǽܤǤϡܤǤ˰¸ơη򤹤

	¨ܤʿġⷿʤС⤯դơȤ
	ǤʤС㤯դ
  ====================================================================*/
void ACC222A(p,q) integer_16 p; register integer_16 q; {
	register integer_16 qp;

	if(chk_heiban(p)||chk_odaka(p)){
		qp=phrase_ptr[q];
		if(accent0[qp]==1){ accent0[qp]=2; }
	}else{
		ACC0004(q);
	}
}

/*========== ACC222B(p,q) ================================================
	ǽܤǤϡܤǤ˰¸ơ·η򤹤

	¨ܤʿĤʤСܤǤϹ⤯ĤΤʿĲ롣
	ʤСܤǤϹ⤯ĤƼȤ롣
  ========================================================================*/
void ACC222B(p,q) integer_16 p; register integer_16 q; {
	register integer_16 qp;

	if(chk_heiban(p)){
		/* ʿĤʤ⤯ĤΤʿĲ*/
		ACC0005(q);
	}else{
		/* ⤯ĤƼʬ롣*/
		qp=phrase_ptr[q];
		if(accent0[qp]==1){ accent0[qp]=2; }
	}
}

/*========== ACC222C(p,q) ============================================
	ǽܤǤϡܤǤ˰¸ơ÷η򤹤

	¨θ줬̾ǤʿġʤС⤯դΤʿĲ
	ʤС㤯դ
  ====================================================================*/
void ACC222C(p,q) register integer_16 p,q; {
	/* ܤǤΤҤȤǤ̾줫ɤüֹĴ٤롣*/
	/* ҤȤǡʤݣܤǤϣܤǤϤʤΤդ롣*/
	/* ӥåܤʤθȤߤʤ*/

	/*㳰ܤǤΣबΤȤ㤯դ*/
	if(stc_accent_raw[q-1][6]==2){ goto ACC222C_200; }

	if((get_case(q-1) & BITBNO_Taigen) && (chk_heiban(p)||chk_odaka(p))){
		/* θ줬θǤʿĤޤΤȤΤʿĲ롣*/
		ACC000H(p); ACC0005(q); return;
	}
ACC222C_200:
	/* ʤС㤯Ĥ*/
	ACC0004(q);
}

/*========== ACC222D(q) ====================
	ǽܤǤϣķη򤹤
	¨⤯դơ裲ܤޤǹ⤤
	ߡ̤ѡ
void ACC222D(q) register integer_16 q; {
	register integer_16 qp;
	qp=phrase_ptr[q];
	ACC0003(q,2); accent0[qp]=2;
}
  ==========================================*/

/*========== ACC222E(p,q) ============================================
	ǽܤǤϡܤǤ˰¸ơŷη򤹤

	¨θ줬̾ǤʿĤΤȤ⤯դơȤ
		ʳ㤯դ
  ====================================================================*/
void ACC222E(p,q) integer_16 p; register integer_16 q; {
	register integer_16 qp;

	/* ܤǤΤҤȤǤ̾줫ɤüֹĴ٤롣*/
	/* ҤȤǡʤݣܤǤϣܤǤϤʤΤդ롣*/
	/* ӥåܤʤθȤߤʤ*/
	if((get_case(q-1) & BITBNO_Taigen) && chk_heiban(p)){
		/* θ줬θǤʿĤΤȤ⤯ĤƼʬ롣*/
		qp=phrase_ptr[q];
		if(accent0[qp]==1){ accent0[qp]=2; }
	}else{
		/* ʤС㤯Ĥ*/
		ACC0004(q);
	}
}

/*========== ACC222Z(q) ===================================================
	ǽܤǤϡη򤹤

	¨⤯դơȤ

	⡧ܸϡסܡ֥ƥפǤϡʤ
		ܸסܡֲϥƥפλֲϥƥפη絬§
		ˤʤ롣ֲϥƥפη絬§ϡֲϡס֥ƥפ
		絬§Ȥϰۤʤꡢ¿ʬʿĲ⤯դƼʬ
		פ롣
  ==========================================================================*/
void ACC222Z(q) register integer_16 q; {
	register integer_16 qp;
	qp=phrase_ptr[q];
	if(accent0[qp]==1){ accent0[qp]=2; }
}

/****************************************************************************/
/*																			*/
/*			ȷΡǤؤαƶ				*/
/*																			*/
/****************************************************************************/

/*========== ACC22PO(p,q) =============================================
	ǽ֤פĤȤΥȤꤹ

	ξ֤פϤҤʤ롣

	ܷƻ졧³ǤϹ⤯դʿĲ롣
	ư졡³ǤϹ⤯դʿĲ롣
	̾졡Ƭ̾ΤȤѲʤ
				ƬʳΤȤ
				裲ȤСѤ롣
				ʤС³ǤϹ⤯դʿĲ
  =====================================================================*/
void ACC22PO(p,q) integer_16 p,q; {
	integer_16 acc; register integer_16 qp,bno;

	ACC0004(p);
	qp=phrase_ptr[q];
	bno=stc_bno[q][0];
	bno=bno_tbl[bno-1];
	if(bno==pkind_verb_stem||bno==pkind_verb_sa){ goto ACC22PO_verb; }
	if(bno==pkind_adj_stem){ goto ACC22PO_adj; }

	/* Ƭʤʤˤ⤷ʤ*/
	if(stc_accent_raw[q][0]==1){ return; }
	/* 裲Ȥʤй⤯ĤʿĲ롣*/
	if((acc=stc_accent_raw[q][4])==0xFF){
		ACC0005(q);
	}else{
		if(acc==0){ ACC000H(q); }else{ ACC0003(q,acc); }
	}
	if(accent0[qp]==1){ accent0[qp]=2; }
	return;
ACC22PO_verb:;
ACC22PO_adj:;
	ACC0005(q);
}

/*========== ACC2232(p,q) ======================================================
	ǽܤǤϡܤǤ˱ƶơη򤹤

	  ¨ܤʿĲ
	ܤϡ裲Ȥ裲ȤǡʤƬⲽ롣
  ==============================================================================*/
void ACC2232(p,q) integer_16 p,q; {
	BYTE acc4;
	register integer_16 qp,ql;
	ACC000H(p);
	if((acc4=stc_accent_raw[q][4])!=0xFF){
		ACC0003(q,acc4);
		qp=phrase_ptr[q]; ql=phrase_len[q];
		if(ql>1 && accent0[qp]==1){
			accent0[qp]=2;
		}
	}else{
		ACC0001(q);
	}
}

/*========== ACC2233(p,q) ============================================
	ǽܤǤϡܤǤ˱ƶơη򤹤

	  ¨ܤʿĤˤʤꡢܤϹ⤯դơȤ
  ====================================================================*/
void ACC2233(p,q) integer_16 p,q; {
	register integer_16 qp;
	qp=phrase_ptr[q];
	ACC000H(p);
	if(accent0[qp]==1){ accent0[qp]=2; }
}

/*========== ACC2234(p,q) ============================================
	ǽܤǤϡܤǤ˱ƶơη򤹤

	  ¨ܤʾολϷ礷ʤ
	ܤολϡܤƬλϡܤ㤯դ
	ܤƬʳλϡܤϹ⤯դ

	ˡ裱פϷ礷֣פ㤯դ裲פ硣
		ֿޣפϷ礷֣פϹ⤯դֿޣפ硣
		ɽפϷ礷֣פϹ⤯դɽפ硣
		ܤǤϡȤꤢΣ擄餤Ǥ

			νACC2800()ǹԤ
  ====================================================================*/

/*========== ACC2236(p,q) ============================================
	ǽܤǤϡܤǤ˱ƶơη򤹤

	  ¨ܤܤȼΥȤ롣
		˳
  ====================================================================*/

/*========== ACC2237(p,q) ============================================
	ǽܤǤϡܤǤ˱ƶơη򤹤

	  ¨ܤȼΥȤꡢܤ㤯Ĥ
		ˤɤ
ACC2237(p,q) integer_16 p,q; { ACC0004(q); }
  ====================================================================*/

/*========== ACC2239(p,q) ============================================
	ǽܤǤϡܤǤ˱ƶơη򤹤

	  ¨ܤκǽ郎⤤Ȥϡܤ裱ܤ⤯ʤ롣

		ˤΡʳʽ
  ====================================================================*/
void ACC2239(p,q) integer_16 p,q; {
	register integer_16 qp;
	if(accent0[phrase_ptr[p]+phrase_len[p]-1]!=1){
		qp=phrase_ptr[q];
		if(accent0[qp]==1){ accent0[qp]=2; }
	}
}

/***************************** END OF ACC_22XX.C *****************************/
