/***********************************************
	ACC_3000.C	updated at 30th October 1989
	¥Ĺ˴ؤŪ§
 ***********************************************/

#define		EXT		extern

#include	"onsei.h"
#include	"ile_acch.h"
#include	"ile_shdh.h"
#include	"ile_stch.h"
#include	"ile_func.h"


/*========== ACC3000() =========================================
	ǽȤ줬¥ĹľˤȤ
		Ȥ˰ư롣
  ==============================================================*/
void ACC3000() {
	register integer_16 i,j;
	integer_16 cx;
	BYTE ch;
	for(i=0;i<stc_ptr;++i){
		if((cx=phrase_len[i])>2){
			for(j=phrase_ptr[i]+1,cx-=2;cx--;++j){
				ch=omega[j];
				if(ch>=0xC0 && ch<=0xD7){
					if(accent0[j]!=1 && accent0[j+1]==1){
						accent0[j-1]=0x82; accent0[j]=1;
					}
				}
			}
		}
	}
}

/*========== ACC4000() ======================================================
	ǽ¥ζ̡

	ѴǤϡ¥̤ƤʤΤǡ
	¥ʬहɬפ롣
	ile_dtbl.hǤϡ0xD7¥0xCFƤ
	񡦳ιܤˤĤƤϡǸΥ⡼餬¥ΤȤΤߡ
	Υ⡼˰¸롣
	ǸʳΥ⡼ϡΥ⡼˰¸Ȥϸ¤ʤΤդ롣
	θ˥ݡϡأȤ롣

	88.11.22
	㳰Ϥʤ褦ʤΤǡ٤ƥå롣
  ===========================================================================*/
void ACC4000() 
{ 
	check_X(omega,cpron_ptr);
}


/*========== ACC4100(addr) ===================================
	ǽϡΥ⡼˰¸ơĤʬव롣

		Σɡʣɤϡأ
		Уԡͣԡ£Ԥϡأ
		ΣԡԣԡģӣԤϡأ
		ǣԡѣԡˣԤϡأ
		ԡȣԤϡأ
  ============================================================*/
void ACC4100(addr) register BYTE *addr; {
	BYTE next_mora;
	next_mora=(*(addr+1));

	switch(next_mora){
	case 0x39: case 0x89:
		*addr=0xD2;	return;					/* X3 before (NI),(JI) */
	}

	switch(next_mora & 0xF8){
	case 0xA0: case 0x50: case 0x98:
		*addr=0xD0; break;					/* X1 before PA,MA,BA */
	case 0x38: case 0x20: case 0x90: case 0x10:
		*addr=0xD1; break;					/* X2 before NA,TA,DA,SA */
	case 0x08: case 0x70: case 0x78:
		*addr=0xD3; break;					/* X4 before GA,QA,KA */
	case 0x00: case 0x40:
		*addr=0xD4; break;					/* X5 before A,HA */
	default:
		*addr=0xD1; break;					/* X2 before default */
	}
}

/*========== ACC4200(addr) ===================================
	ǽ¥ϡΥ⡼˰¸ơĤʬव롣

		ӣԤϡ
		ӣȣԤϡ
		ȣԤϡ
		ʳϡ
  ============================================================*/
void ACC4200(addr) register BYTE *addr; {
	switch(*(addr+1) & 0xF8){
	case 0x10:	*addr=0xC9; break;			/* $1 before SA */
	case 0x18:	*addr=0xCA; break;			/* $2 before SHA */
	case 0x40:	*addr=0xCB; break;			/* $3 before HA */
	default:	*addr=0xC8; break;			/* $ before default */
	}
}

/*========== check_X(p,l) =========================
	ǽ¥ʸˤäʬह롣

	88.11.22
	㳰Ϥʤ褦ʤΤǡ٤ƥå롣
  =================================================*/
void check_X(p,l) BYTE *p; integer_16 l; {
	register integer_16 len; register BYTE *ptr;
	/*  */
	for(len=l,ptr=p;len--;++ptr){
		/*if(*ptr==0xD7){*/
		if((*ptr & 0xF0)==0xD0){
			if(len==0){
				*ptr=0xD1;
			}else{
				ACC4100(ptr);
			}
		}
	}
	/* ¥ */
	for(len=l,ptr=p;len--;++ptr){
		/*if(*ptr==0xCF){*/
		if((*ptr & 0xF8)==0xC8){
			if(len==0){
				*ptr=0xC8;
			}else{
				ACC4200(ptr);
			}
		}
	}
}

/***************************** END OF ACC_3000.C *****************************/
