/*
 *	DSP_ROMA.C
 *	Copyright(C) MCMLXXXVII-MCMXCI
 */
#include	"dustytypes.h"

static const BYTE dispchar_table[][3]={
	'A',  0,  0,	'I',  0,  0,	'U',  0,  0,	'E',  0,  0,	/* 00..03 */
	'O',  0,  0,	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* 04..07 */
	'K','A',  0,	'K','I',  0,	'K','U',  0,	'K','E',  0,	/* 08..0B */
	'K','O',  0,	'K','Y','A',	'K','Y','U',	'K','Y','O',	/* 0C..0F */
	'S','A',  0,	'S','I',  0,	'S','U',  0,	'S','E',  0,	/* 10..13 */
	'S','O',  0,	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* 14..17 */
	'S','H','A',	'S','H','I',	'S','H','U',	'S','H','E',	/* 18..1B */
	'S','H','O',	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* 1C..1F */
	'T','A',  0,	'T','I',  0,	'T','U',  0,	'T','E',  0,	/* 20..23 */
	'T','O',  0,	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* 24..27 */
	'C','H','A',	'C','H','I',	'C','H','U',	'C','H','E',	/* 28..2B */
	'C','H','O',	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* 2C..2F */
	'T','S','A',	'T','S','I',	'T','S','U',	'T','S','E',	/* 30..33 */
	'T','S','O',	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* 34..37 */
	'N','A',  0,	'N','I',  0,	'N','U',  0,	'N','E',  0,	/* 38..3B */
	'N','O',  0,	'N','Y','A',	'N','Y','U',	'N','Y','O',	/* 3C..3F */
	'H','A',  0,	'H','I',  0,	'H','U',  0,	'H','E',  0,	/* 40..43 */
	'H','O',  0,	'H','Y','A',	'H','Y','U',	'H','Y','O',	/* 44..47 */
	'F','A',  0,	'F','I',  0,	'?','?',  0,	'F','E',  0,	/* 48..4B */
	'F','O',  0,	'F','Y','A',	'F','Y','U',	'F','Y','O',	/* 4C..4F */
	'M','A',  0,	'M','I',  0,	'M','U',  0,	'M','E',  0,	/* 50..53 */
	'M','O',  0,	'M','Y','A',	'M','Y','U',	'M','Y','O',	/* 54..57 */
	'Y','A',  0,	'?','?',  0,	'Y','U',  0,	'?','?',  0,	/* 58..5B */
	'Y','O',  0,	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* 5C..5F */
	'R','A',  0,	'R','I',  0,	'R','U',  0,	'R','E',  0,	/* 60..63 */
	'R','O',  0,	'R','Y','A',	'R','Y','U',	'R','Y','O',	/* 64..67 */
	'W','A',  0,	'W','I',  0,	'?','?',  0,	'W','E',  0,	/* 68..6B */
	'W','O',  0,	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* 6C..6F */
	'G','A',  0,	'G','I',  0,	'G','U',  0,	'G','E',  0,	/* 70..73 */
	'G','O',  0,	'G','Y','A',	'G','Y','U',	'G','Y','O',	/* 74..77 */
	'Q','A',  0,	'Q','I',  0,	'Q','U',  0,	'Q','E',  0,	/* 78..7B */
	'Q','O',  0,	'Q','Y','A',	'Q','Y','U',	'Q','Y','O',	/* 7C..7F */
	'Z','A',  0,	'Z','I',  0,	'Z','U',  0,	'Z','E',  0,	/* 80..83 */
	'Z','O',  0,	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* 84..87 */
	'J','A',  0,	'J','I',  0,	'J','U',  0,	'J','E',  0,	/* 88..8B */
	'J','O',  0,	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* 8C..8F */
	'D','A',  0,	'D','I',  0,	'D','U',  0,	'D','E',  0,	/* 90..93 */
	'D','O',  0,	'D','Y','A',	'D','Y','U',	'D','Y','O',	/* 94..97 */
	'B','A',  0,	'B','I',  0,	'B','U',  0,	'B','E',  0,	/* 98..9B */
	'B','O',  0,	'B','Y','A',	'B','Y','U',	'B','Y','O',	/* 9C..9F */
	'P','A',  0,	'P','I',  0,	'P','U',  0,	'P','E',  0,	/* A0..A3 */
	'P','O',  0,	'P','Y','A',	'P','Y','U',	'P','Y','O',	/* A4..A7 */
	'V','A',  0,	'V','I',  0,	'V','U',  0,	'V','E',  0,	/* A8..AB */
	'V','O',  0,	'V','Y','A',	'V','Y','U',	'V','Y','O',	/* AC..AF */
	'K','W','A',	'K','W','I',	'?','?',  0,	'K','W','E',	/* B0..B3 */
	'K','W','O',	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* B4..B7 */
	'G','W','A',	'G','W','I',	'?','?',  0,	'G','W','E',	/* B8..BB */
	'G','W','O',	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* BC..BF */
	'-',  0,  0,	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* C0..C3 */
	'?','?',  0,	'?','?',  0,	'?','?',  0,	'?','?',  0,	/* C4..C7 */
	/* CFϿѴ̤ʬ¥ */
	'$',  0,  0,	'$','1',  0,	'$','2',  0,	'$','3',  0,	/* C8..CB */
	'?','?',  0,	'?','?',  0,	'?','?',  0,	'$',  0,  0,	/* CC..CF */
	/* D7ϿѴ̤ʬ */
	'X','1',  0,	'X','2',  0,	'X','3',  0,	'X','4',  0,	/* D0..D3 */
	'X','5',  0,	'?','?',  0,	'?','?',  0,	'X',  0,  0,	/* D4..D7 */
	0																/* STOPPER */
};



/*FUNCTION_HEADER**********************
 * NAME:	;dispchar_to_code
 * DESC: 	Find the index into the dispchar_table that matches
			a 3 character sequence.
 * IN:		a - the 3 character sequence
 * OUT:		ch - the table index
 * RETURN:	1 on success, 0 on failure
 * NOTES:	
 *END_HEADER***************************/
int dispchar_to_code(a,ch) register BYTE *a; BYTE *ch; 
{
	const BYTE* addr;
	BYTE code;

	/* ϿϤǤϡ¥Ϥ줾졢ءǤ롣*/
	if(a[1]==0x00 && a[2]==0x00)
	{
		if(a[0]=='$'){ *ch=0xCF; return 1; }
		if(a[0]=='X'){ *ch=0xD7; return 1; }
	}
	addr=(&dispchar_table[0][0]);

	code=0;
	for( ; *addr; addr+=3,code++)
	{
		if(a[0]==(*addr) && a[1]==(*(addr+1)) && a[2]==(*(addr+2)))
		{
			*ch=code; 
			return 1;
		}
	}
	return 0;
}

/***************************** END OF DSP_ROMA.C *****************************/
