/*********************************************
	ILE_BUFC.C	updated at 24th April 1990
	Ƽ掠֥롼
 *********************************************/

#define		EXT		extern

#include	"onsei.h"
#include	"ile_acch.h"
#include	"ile_fddh.h"
#include	"ile_nydh.h"
#include	"ile_shdh.h"
#include	"ile_stch.h"
#include	"ile_func.h"


/*========== get_case(p) ====================================
	ǽܤǤθüֹ椫ʷѥơ֥
	͡ʷѥơ֥͡ʣӥåȡˡ
  ===========================================================*/
WORD get_case(p) register integer_16 p; {
	register integer_16 i;
	WORD bno;

	for(i=0;i<stc_nbno[p];++i){
		if(bno=stc_bno[p][i]){ goto get_case_200; }
	}
get_case_200:;
	return FddHDR[Fdd_Header.Fdd_BnoTblOfs+bno-1];
}


/*========== chk_heiban(p) =====================
	ǽܤǤʿķɤĴ٤롣
	͡ʿķʤ飱ǤʤУ
  ==============================================*/
BOOL chk_heiban(p) integer_16 p; {
	register integer_16 pp,pl;

	pp=phrase_ptr[p]; pl=phrase_len[p];
	if((pl>1 && accent0[pp+pl-1]==2)||(pl==1 && accent0[pp]==1)){
		return 1;
	}else{
		return 0;
	}
}


/*========== chk_odaka(p) ======================
	ǽܤǤⷿɤĴ٤롣
	ⷿ͡ʤ飱ǤʤУ
  ==============================================*/
BOOL chk_odaka(p) register integer_16 p; {
	register integer_16 pl;

	pl=phrase_len[p];
	if(pl>1 && accent0[phrase_ptr[p]+pl-1]==0x82){
		return 1;
	}else{
		return 0;
	}
}


/*========== chk_separator(i) =====================
	ǽܤʸüʸɤĴ٤롣
	͡üʸʤʸɡǤʤУ
  =================================================*/
WORD chk_separator(i) register integer_16 i; {
	BYTE ch;
	register integer_16 ptr;

	ptr=stc_in_ptr[i];
	/* Ĺʸʾʤ顢üʸȤϸʤ*/
	if(stc_out_len[i]!=1){ return 0; }
	ch=inert_kind[ptr];
	/* ΥԥꥪɲΤüʸȸʣͤġ*/
	if(ch==CHRKIND_DDP){ return(0x2125); }
	ch &= 0xF0;
	if(ch==CHRKIND_Other1||ch==CHRKIND_Other2){
		return((inert[ptr*2]<<8) | inert[ptr*2+1]);
	}
	return 0;
}


/*========== next_phrase(i) =================
	ǽܤζμζֹ롣
	͡ζ礬жֹ桢ʤУ
  ===========================================*/
integer_16 next_phrase(i) register integer_16 i; {
	register integer_16 j;

	for(j=i+1;j<stc_ptr;++j){
		if(phrase_len[j]>0){ return j; }
	}
	return 0;
}


/*========== net_phrase_in_len(i) =================
	ǽܤζʸʸ롣
	͡ʸο
  =================================================*/
integer_16 net_phrase_in_len(i) integer_16 i; {
	integer_16 j;
	register integer_16 len;

	len=((j=next_phrase(i))? stc_in_ptr[j]:n_inert) - stc_in_ptr[i];
	return len;
}


/*========== knj_number(i) =================
	ǽܤζδʸ롣
	͡
  ==========================================*/
integer_16 knj_number(i) integer_16 i; {
	integer_16 j,knj;
	register integer_16 ptr,len;

	len=((j=next_phrase(i))? stc_in_ptr[j]:n_inert)-(ptr=stc_in_ptr[i]);
	for(knj=0;len--;ptr++){
		if(inert_kind[ptr]==CHRKIND_Kanji){ ++knj; }
	}
	return knj;
}


/*========== chk_value(AL,SI,CX) ====================================================
	ʸPTR = chk_value(AL,SI,CX);
		ΤȤSI[PTR-1] = ALǤ롣
	ǽ礭CXΥХSI[]ALޤޤ뤫ɤĴ٤롣
	͡ʤ°ʤ
		ʤСALäǤΰ֤򣱥ꥸǼ
  ===================================================================================*/
integer_16 chk_value(AL,SI,CX) register BYTE *SI; BYTE AL; register integer_16 CX; {
	for(;CX--;){ if(SI[CX]==AL){ return (CX+1); } }
	return 0;
}


/*========== chk_limits(LL,UL,SI,CX) ===================================================
	ʸPTR = chk_limits(LL,UL,SI,CX);
		ΤȤLL  SI[PTR-1]  ULǤ롣
	ǽ礭CXΥХSI[]LLULϰϤǤޤޤ뤫ɤĴ٤롣
	͡ʤ°ʤʤСLLULϰϤǤ֤򣱥ꥸǼ
  ======================================================================================*/
integer_16 chk_limits(LL,UL,SI,CX) register BYTE *SI; BYTE LL,UL; register integer_16 CX; {
	for(;CX--;){
		if(SI[CX]>=LL && SI[CX]<=UL){ return (CX+1); }
	}
	return 0;
}


/*========== is_zengo_kanji(i) =================================================
	ǽܤʸʸΤɤ餫ޤξɤĴ٤롣
	͡ᣰ嶦˴ǤϤʤ
		ᣱΤɤ餫Ǥ롣
  ==============================================================================*/
BOOL is_zengo_kanji(ptr) integer_16 ptr; 
{
	register BYTE *si;
	register integer_16 ptr2;
	
	if((ptr2=ptr-1)!=(-1))
	{
		si=inert+ptr2*2;
		/*ax=(*si<<8)|*(si+1); if(ax>0x3000){ return 1; }*/
		if(*si>=0x30){ return 1; }
	}
	if((ptr2=ptr+1)!=n_inert)
	{
		si=inert+ptr2*2;
		/*ax=(*si<<8)|*(si+1); if(ax>0x3000){ return 1; }*/
		if(*si>=0x30){ return 1; }
	}
	return 0;
}


/*========== before_ch_ptr(i) ================================
	ǽܤʸʸΰ֤롣
	͡ʸʸ֡ʤСݣ
		ʸ֤ϥꥸǤ뤫顢ͤȤꤦ롣
	integer_16 before_ch_ptr(i) register integer_16 i; {
		--i;
		return i;
	}
  ============================================================*/

/*========== next_ch_ptr(i) ======================
	ǽܤʸμʸΰ֤롣
	͡ʸʸ֡ʤСݣ
	integer_16 next_ch_ptr(i) register integer_16 i; {
		++i;
		if(i==n_inert){ return -1; }
		return i;
	}
  ================================================*/

/*========== first_char_ptr(i) =========================
	ǽܤζƬʸΰ֤롣
	͡Ƭʸΰ֡
	integer_16 first_char_ptr(i) integer_16 i; {
		return stc_in_ptr[i];
	}
  ======================================================*/

/*========== first_or_not(i) =====================
	ǽܤʸƬʸɤĴ٤롣
	͡Ƭʸʤ飱ǤʤУ
	BOOL first_or_not(i) integer_16 i; {
		return (i==0);
	}
  ================================================*/

/*========== last_or_not(i) ======================
	ǽܤʸǽʸɤĴ٤롣
	͡ǽʸʤ飱ǤʤУ
	BOOL last_or_not(i) integer_16 i; {
		return (i==n_inert-1);
	}
  ================================================*/

/***************************** END OF ILE_BUFC.C *****************************/
