/************************************************
	ILE_IDIC.C	updated at 5th September 1989
	
 ************************************************/

#define		EXT		extern

#include	"onsei.h"
#include	"ile_fddh.h"
#include	"ile_idic.h"
#include	"ile_jknh.h"
#include	"ile_kkhh.h"
#include	"ile_mruh.h"
#include	"ile_nydh.h"
#include	"ile_shdh.h"
#include	"ile_stch.h"
#include	"ile_stzh.h"
#include	"ile_func.h"


/*========== IDIC1000() ===========================================
	ǽ˸ܸ줬ǽ뤫ɤĴ٤롣
  =================================================================*/
BOOL IDIC1000() {
	/*
	 *	ǤξĴ١Ƚꤹ롣
	 *	ǽʸĶƤ硢ǽʤ
	 *	񸡺ɽɤߤʤȤϿƤ硢ǽʤ
	 *	嵭ʳξ硢ǽꡣ
	 */
	if(celen>MAX_IDIC){ return 0; }
	if(JknfAttrAri(BITDUT_ID_NONE)){ return 0; }
	return 1;

	/*
	 *	측ؼǡǤʤ̵
	 *	if(StzfAttrAri(Stz_CE,stz_mru,BITMRU_ABORT)
	 *	&&(JknfAttrAri(BITDUT_ID_ABORT)==0)){ return 0; }
	 */
}


/*========== IDIC2000() ======================================
	ǽǳϰ֤Ϥޤ롢Ĺθ줬롢
 		Υ꡼Υɥ쥹롣
 		顼äϡ顼ɤꤷ롣
  ============================================================*/
BOOL IDIC2000() {
	register BYTE *si,*di;
	IDIC_INDICES *mjsptr;
	BYTE *endptr,*source,*njsptr;
	integer_16 len,cebyte;
	WORD offset;

	cebyte=celen*2;

	/* 񸡺ɽˤкѤ롣*/
	if(JknfAttrAri(BITDUT_ID_EXIST)){
		njsptr=JknfIdicToridasu;
		goto IDIC2000_200;
	}

	source=(&inert[ceptr*2]);

	mjsptr = (IDIC_INDICES *)(&FddHDR[Fdd_Header.Fdd_IdicIndOfs]
			+ sizeof(IDIC_INDICES)*(celen-1));
	/* offset = mjsptr->idic_len_ptr; */
	offset = (mjsptr->idic_len_ptr1 <<8) + mjsptr->idic_len_ptr2;
	njsptr = FddHDR + Fdd_Header.Fdd_IdicOfs + offset;
	/* offset = (mjsptr+1)->idic_len_ptr; */
	offset = ((mjsptr+1)->idic_len_ptr1 <<8) + (mjsptr+1)->idic_len_ptr2;
	endptr = FddHDR + Fdd_Header.Fdd_IdicOfs + offset;

	for(;;){
		if(njsptr>=endptr){ JknfAttrAdd(BITDUT_ID_NONE); return 0; }
	
		/* ɽӤ롣*/
		si=source; di=njsptr;
		for(len=cebyte; len; len--,si++,di++){
			if(*si!=(*di)){ break; }
		}

		/* ٤ưפɤ*/		
		if(len==0){ break; }
			
		/* 礭 ̵äȤϿ롣*/
		if(*si<*di){ JknfAttrAdd(BITDUT_ID_NONE); return 0; }

		/* 񸽺ɽޤʤмɽޤǿʤࡣ*/
		njsptr += cebyte+SIZE_IDIC;
	}

	/* ǤΥեåȤ¸롣*/
	njsptr+=cebyte;
	JknfAttrAdd(BITDUT_ID_EXIST);	/* ˤ뤳ȤϿ*/
	JknfIdicShimau(njsptr);			/* 񸡺ɽoffset򤷤ޤ*/
	
IDIC2000_200:
	idic_addr=njsptr;
	/* ؽ֤ʤи߸Ѥ롣*/
	if(kkhstat!=mru){
		if(((IDIC_DATA *)njsptr)->idic_mru & BITMRU_ABORT){
			/* Ĥä줬ǡ
			 * Ժؼʤмθܤ
			 */
			JknfAttrAdd(BITDUT_ID_ABORT);
			if(StzfAttrNashi(Stz_CE,stz_mru,BITMRU_ABORT)){
				return IDIC3000();
			}
		}else{
			/* Ĥä줬ǤϤʤơ
			 * ؼʤмθܤ
			 */
			if(StzfAttrAri(Stz_CE,stz_mru,BITMRU_ABORT)){
				return IDIC3000();
			}
		}
	}

	/* Ǥ³ȯꤹ롣*/
	IDIC4000();
	return 1;
}


/*========== IDIC3000() ===============================
	ǽθμƱյΰ֤롣
  =====================================================*/
BOOL IDIC3000() {
	integer_16 len;
	IDIC_INDICES *mjsptr;
	BYTE *endptr,*source;
	register BYTE *si,*njsptr;
	WORD offset;

	source = ceptr*2+inert;
	njsptr = idic_addr+SIZE_IDIC;

	mjsptr = (IDIC_INDICES *)(&FddHDR[Fdd_Header.Fdd_IdicIndOfs]
			+ sizeof(IDIC_INDICES)*celen);
	/* offset = mjsptr->idic_len_ptr; */
	offset = (mjsptr->idic_len_ptr1 <<8) + mjsptr->idic_len_ptr2;
	endptr = FddHDR + Fdd_Header.Fdd_IdicOfs + offset;

	for(;;){
		if(njsptr>=endptr){ return 0; }

		/* ɽӤ롣*/
		si=source;
		for(len=celen*2; len--;){
			if(*si++!=(*njsptr++)){ return 0; }
		}
	
		/* ؽ֤ʤи߸Ѥ롣*/
		if(kkhstat==mru){ break; }
		/*
		 *	λϼ񸡺ɽ˵Ͽ
		 *	κѤؼƤкѤ롣
		 */
		if(((IDIC_DATA *)njsptr)->idic_mru & BITMRU_ABORT){
			JknfAttrAdd(BITDUT_ID_ABORT);
			if(StzfAttrAri(Stz_CE,stz_mru,BITMRU_ABORT)){ break; }
		}else{
			if(StzfAttrNashi(Stz_CE,stz_mru,BITMRU_ABORT)){ break; }
		}
		njsptr += SIZE_IDIC;
	}

	idic_addr=njsptr;
	IDIC4000();
	return 1;
}


/*========== IDIC4000()===============
	ǽ߸³ꤹ롣
  ====================================*/
void IDIC4000() {
	register IDIC_DATA *njsptr;

	StzfElmKind(&Stz_CE,DICKIND_I);			/* ñ̤Ȥ롣*/
	njsptr=(IDIC_DATA *)idic_addr;			/* ֤ܰФ*/
	Stz_CE.stz_f2=njsptr->idic_f2;			/* ե饰ꤹ롣*/
	Stz_CE.stz_ctl=njsptr->idic_ctl;		/* ꤹ롣*/
	Stz_CE.stz_ngrcd=1;						/* ʸˡɿ򣱤Ȥ롣*/
	StzfBnoAdd(&Stz_CE,njsptr->idic_bno);	/* üֹꤹ롣*/
	Stz_CE.stz_pno[0]=njsptr->idic_pno;		/* ٥ȥֹꤹ롣*/
	/* ؽꤹե饰ۤ*/
	Stz_CE.stz_mru=(njsptr->idic_mru & ~BITMRU_ABORT)
				  |(Stz_CE.stz_mru & BITMRU_ABORT);

	/*
	 * ߸줬Ը³ʤС³ֻؼ˴ä롣
	 * ꤷե饰ԸȤδ³̵ͭĴ٤뤿Ѥ롣
	 * ԸȤδ֤³طǧ줿ǡե饰ΰ̣ϸ³Ȥ
	 * ³ǽ򼨤̣夨롣
	 */
	if(njsptr->idic_ctl & BITCTL_PKANGO){ Stz_CE.stz_stz |= BITSTZ_KANGO; }
}


/*========== IDIC5000(di) =================================================
	ǽܸȯɽϥǡꥢΣʸܤǼ롣
  =========================================================================*/
integer_16 IDIC5000(di) integer_16 di; {
	register BYTE *si;
	register integer_16 cx;
	IDIC_DATA *njsptr;
	integer_16 a_len,p_len;
	BYTE *accptr,al,ah,*ti;
	WORD offset;

	/* 񸽺֤ܰФ*/
	njsptr=(IDIC_DATA *)idic_addr;
	/* accent & pronunciation֤Ф*/
	/* offset = njsptr->idic_acc_ofs; */
	offset = (njsptr->idic_acc_ofs1 <<8) + njsptr->idic_acc_ofs2;
	accptr = (&FddHDR[Fdd_Header.Fdd_IdicPronOfs]) + offset;

	p_len=(*accptr++);
	a_len=p_len>>4;				/* length of accent information */
	p_len &= 0x0F;				/* length of pronunciation information */

	for(cx=a_len;cx--;){
		al=(*accptr++);
		ah=al/16; al=al%16;
		if(ah<10){ stc_accent_raw[stc_ptr][ah]=al; }
	}

	ACC0010();

	/* ȯФ*/
	if(p_len==0){
		cpron_len=0; si= &inert[ceptr*2]; ti=inert_kana;
		for(cx=celen*2;cx--;){
			*ti++=(*si++);
		}
		*ti=0x00;
		cx=mkhatu(inert_kana,inert_pron);
		for(si=inert_pron;cx--;++si){
			di=OMEGA1000(*si,di); ++cpron_len;
		}
	}else{
		for(cx=cpron_len=p_len;cx--;){
			al=(*accptr++); di=OMEGA1000(al,di);
		}
	}
	return di;
}

/***************************** END OF ILE_IDIC.C *****************************/
