#if !defined(O_TALKONLY)
/************************************************
	ILE_MRUC.C	updated at 18th December 1990
	ؽϢ
 ************************************************/

#define		EXT		extern

#include	"onsei.h"
#include	"ile_edic.h"
#include	"ile_errh.h"
#include	"ile_fddh.h"
#include	"ile_idic.h"
#include	"ile_jknh.h"
#include	"ile_kkhh.h"
#include	"ile_mruh.h"
#include	"ile_nydh.h"
#include	"ile_stch.h"
#include	"ile_stzh.h"
#include	"ile_func.h"
#include "ile_rnsc.h"

/*========== MRU_CSENT() =================================================
	ǽʸޤǤѴ̤ؽ롣
			ʸʸ᤬Ѵǽʤ顢ʸμޤǤؽ롣
  ===================================================GksfChbGakushuusuru==*/
void MRU_CSENT() {
	/* Ѵǽ֤ǤʤСʸˤʤޤǥå᤹*/
	/***if(kkhstat!=funou)then STACK_POP_FS(); fi***/
	/* åǤؽ롣*/
	MRU_ALL();
}


/*========== MRU_ALL() =================================================
	ǽߤѴ̤ؽ롣
			Ѵǽʸ᤬ϡʸμޤǤؽ롣
	ա㤤νդ롣
  ======================================================================*/
void MRU_ALL() {
	register integer_16 p;
	/*
	 * ȷγؽԤ
	 * γؽʸ֤Ȥϲδط̵Τդ롣
	 */
	for(p=stc_ptr;p--;){
		if(stc_mru[p] & (BITMRU_ACON|BITMRU_ACOFF)){
			ceptr=stc_in_ptr[p];
			celen=stc_in_len[p];
			switch(stc_kind[p]){
			case DICKIND_I:
				IDIC_ACC_STUDY(p);
				break;
			case DICKIND_E:
				EDIC_ACC_STUDY(p);
			}
		}
	}

	/* 䡦Ĺû¹ԤƤʤȤϳؽɬפʤ*/
	if(MRU_OR_NOT==0){ return; }

	/***if(kkhstat==funou){***/	/* Ѵǽ֤ʤ */
		/***STACK_POP_WS();***/		/* ʸˤʤޤǥå᤹*/
		/* watching sentenceƬʸʤФλstc_ptr=0Ǥ롣*/
		/*if(ws_no==1){ return; }*/
	/***}***/
	kkhstat=mru;					/* ؽ֤Ȥ */

	for(ceptr=n_inert;ceptr--;){
		for(celen=n_inert-ceptr;celen;--celen){
			/* ѤȤмλѤ롣*/
			if(celen<=MAX_IDIC && JknfAttrAri(BITDUT_ID_USE)){
				IDIC_ABORT();
			}
			if(celen<=MAX_EDIC && JknfAttrAri(BITDUT_ED_USE)){
				EDIC_ABORT();
			}
		}
	}

	for(p=stc_ptr;p--;){			/* 줾ǤˤĤ */
		ceptr=stc_in_ptr[p]; celen=stc_in_len[p];
		/* ޤʤСɽΥե饰äƳؽ롣*/
		switch(stc_kind[p]){
		case DICKIND_I:
			JknfAttrToru(BITDUT_ID_USE);
			IDIC_MRU(p);
			break;
		case DICKIND_E:
			JknfAttrToru(BITDUT_ED_USE);
			EDIC_MRU(p);
		}
	}
}


/*========== MRU_REMEMBER() ========================
	ǽߤѴ̤ǻѤƤϿ롣
  ==================================================*/
void MRU_REMEMBER() {
	register integer_16 p;
	register integer_16 len;
	integer_16 ptr;

	for(p=stc_ptr;p--;){
		ptr=stc_in_ptr[p];
		len=stc_in_len[p];
		switch(stc_kind[p]){
		case DICKIND_I:
			JknfAttrAdd3(BITDUT_ID_USE,ptr,len);
			break;
		case DICKIND_E:
			JknfAttrAdd3(BITDUT_ED_USE,ptr,len);
		}
	}
}


/*========== IDIC_MRU(p) ==================
	ǽǤ³ؽ롣
	ϡֹ
  ====================NjsfStzGakushuusuru==*/
void IDIC_MRU(p) integer_16 p; {
	register BYTE *si,*di;
	BYTE tmp;
	integer_16 len;

	/* 񥪥եåȤФ*/
	di=FddHDR+stc_ed_ofs[p];
	/* ե饰ä*/
	((IDIC_DATA *)di)->idic_mru &= ~BITMRU_ABORT;
	/*
	 * ǤƱɽκǽǤõ
	 * ǤĤʤʤм񤬲Ƥ롣
	 */
	if(IDIC2000()==0){ jp_ERROR(Err_Fatal_Idic); }
	/* ƱɽκǽǤΰ֤Ф*/
	si=idic_addr;
	/* ƱɽκǽǤǤۤʤȤϡʬؤ롣*/
	if(di!=si){
		for(len=SIZE_IDIC; len--; ++si,++di){
			tmp=(*si); *si=(*di); *di=tmp;
		}
	}
}


/*========== IDIC_ABORT() ==============================================
	ǽǤɽƱɽġǤλѤ롣
  ====================================================NjsfYomHoukisuru==*/
void IDIC_ABORT() {
	/* Ĥʤм񤬲Ƥ롣*/
	if(IDIC2000()==0){ jp_ERROR(Err_Fatal_Idic); }
	do{
		((IDIC_DATA *)idic_addr)->idic_mru |= BITMRU_ABORT;
	}while(IDIC3000());
}


/*========== IDIC_ACC_STUDY(p) ===================
	ǽΥȷ̵ͭγؽ
	ϡֹ
  ================================================*/
void IDIC_ACC_STUDY(p) integer_16 p; {
	idic_addr=FddHDR+stc_ed_ofs[p];
	if(stc_mru[p] & BITMRU_ACOFF){
		((IDIC_DATA *)idic_addr)->idic_mru |= BITMRU_ACOFF;
		((IDIC_DATA *)idic_addr)->idic_mru &= ~BITMRU_ACON;
	}else{
		((IDIC_DATA *)idic_addr)->idic_mru |= BITMRU_ACON;
		((IDIC_DATA *)idic_addr)->idic_mru &= ~BITMRU_ACOFF;
	}
}


/*========== EDIC_MRU_INIT() ===========
	ǽؽ֤롣
  ======================================*/
void EDIC_MRU_INIT() {
	EdicMruDone_LBN[0]= EdicMruDone_OFS[0]= 0;
}


/*========== EDIC_MRU_NEED(Page,bp,f2) =====================
	ϡPage	ܸΤ볰ڡֹ
 		bp	ܸΥɥ쥹
 		f2	ƱƬθΥɥ쥹
	ϡ0		ؽɬפʤ
 		  1		ؽɬפꡣ
	ǽ߸ؽ٤ɤĴ٤롣
  ==========================================================*/
BOOL EDIC_MRU_NEED(Page,bp,f2) WORD Page; LPBYTE bp,f2; {
	register integer_16 si;
	register WORD ax;
	WORD bx;

	si=0; ax=Page; bx=(WORD)(f2-edic_page_addr);
	/* ޤǳؽξȤ٤Ƴؽ뤫롣*/
	while(1){
		/* ٤Ĵ٤齪ꡣ*/
		if((EdicMruDone_LBN[si]==0)&&(EdicMruDone_OFS[si]==0)){ break; }
		/* ڡֹȥڡ⥪եåȤפ顢ؽʤ*/
		if((EdicMruDone_LBN[si]==ax)&&(EdicMruDone_OFS[si]==bx)){ return 0; }
		si++;
	}
	/* ؽξǼ롣*/
	EdicMruDone_LBN[si]=ax; EdicMruDone_OFS[si++]=bx;
	/* ơ֥Υȥåѡ롣*/
	EdicMruDone_LBN[si]=0; EdicMruDone_OFS[si]=0;
	return 1;
}


/*========== EDIC_MRU(p) =====================================================
	ǽܸ³ؽ롣ܸξƱƬ
 		ܤ˽񤭤ɤ
	ϡֹ
  ============================================================================*/
void EDIC_MRU(p) register integer_16 p; {
	LPBYTE bp,f1,f2;
	integer_16 mru=0;

	/* ɤ߹ߡedic_page_addrˤΥɥ쥹롣*/
	RnsfReadEdic(stc_ed_pag[p],&edic_page_addr);
	/* ե饰Υɥ쥹׻롣*/
	bp=stc_ed_ofs[p]+edic_page_addr;

	/* Ʊ쥰롼פΥե饰ƬΥե饰õ*/
	EdicfSentouSagasu(bp,&f1,&f2);

	/*
	 *	Ǥ˳ؽѤƱ쥰롼פʤСؽʤ
	 *	⤷ؤ˳ؽȡؤǡ
	 *	ؤ edic_ofs Ѥե饰򥯥ꥢƤޤ
	 *	ؤäμȤˤʤΤǡ
	 *ڡֹƬΥե饰ΰ֤פؽʤȤˤ롣
	 *	嵭θݤϸ䤬ĤΤȤʤ
	 */
	if(EDIC_MRU_NEED(stc_ed_pag[p],bp,f2)==0){ return; }

	if(*(bp+1) & BITMRU_ABORT){		/* ե饰դƤ*/
		*(bp+1) &= ~BITMRU_ABORT;		/* ե饰ä*/
		mru=1;
	}

	/* ܸ줬ƱƬǤʤСؤɬפ롣*/
	if(f2!=bp){
		EdicfToridasu(bp);		/* ܤƤФĹ롣*/
		EdicfShift(bp-1,bp+ed_ndata-1,bp-f2); /* ФȤĤ롣*/
		EdicfIreru(f2);			/* ܤƤƱƬ롣*/
		mru=1;
	}

	if(mru){
		RnsfWriteEdic(stc_ed_pag[p]);		/* ؽ̤񤭽Ф*/
	}
}


/*========== EDIC_ABORT() =========================================
	ǽ߸ɤߤƱɤߤġλѤ롣
  =================================================================*/
void EDIC_ABORT() {
	LPBYTE bp;
	/* ơɤߤĤʤм񤬲Ƥ롣*/
	if(EDIC2000()==0){ jp_ERROR(Err_Fatal_Edic); }
	bp=edic_ofs+edic_page_addr;
	if((*(bp+1) & BITMRU_ABORT)==0){		/* ե饰դƤʤ*/
		*(bp+1)|=BITMRU_ABORT;				/* ե饰դ롣*/
		RnsfWriteEdic(edic_page_no);		/* ؽ̤񤭽Ф*/
	}
}


/*========== EDIC_ACC_STUDY(p) ===================
	ǽΥȷ̵ͭγؽ
	ϡֹ
  ================================================*/
void EDIC_ACC_STUDY(p) integer_16 p; {
	LPBYTE bp;
	/* ɤ߹ߡedic_page_addrˤΥڡƬɥ쥹롣*/
	RnsfReadEdic(stc_ed_pag[p],&edic_page_addr);
	bp=stc_ed_ofs[p]+edic_page_addr;
	if(stc_mru[p] & BITMRU_ACOFF){
		*(bp+1)|= BITMRU_ACOFF;
		*(bp+1)&= ~BITMRU_ACON;
	}else{
		*(bp+1)|= BITMRU_ACON;
		*(bp+1)&= ~BITMRU_ACOFF;
	}
	RnsfWriteEdic(stc_ed_pag[p]);		/* ؽ̤񤭽Ф*/
}


/*========== EdicfToridasu(bp) ======================================
	ϡbp			ФΥɥ쥹
	ϡed_data		Ф
 		ed_ndata		ФĹ
	ǽܤƤФʥե饰ȯɽޤǡˡ
 		Ĺ
  ==================================================================*/
void EdicfToridasu(bp) LPBYTE bp; {
	register integer_16 a_len,p_len;
	integer_16 bx;
	BYTE al;

	bx=0;						/* 쥳ĹΥꥻå */
	al=ed_data[bx++]=(*bp++);	/* ե饰Ф */

	/* ؽܤ*/
	if(sign(al)==0){ jp_ERROR(Err_Fatal_Edic); }

	/* ؽʸˡɤФ */
	do{ ed_data[bx++]=(*bp++); }while(sign(*bp));

	ed_data[bx++]=p_len=(*bp++);
	a_len=p_len>>4;				/* length of accent information */
	p_len &= 0x0F;				/* length of pronunciation information */

	/* accent information */
	for(;a_len--;){ ed_data[bx++]=(*bp++); }

	/* pronunciation information */
	for(;p_len--;){ ed_data[bx++]=(*bp++); }

	ed_ndata=bx;	/* ФĹ */
}


/*========== EdicfIreru(bp) ========================
	ϡbp			륢ɥ쥹
 		ed_data[]		
 		ed_ndata		Ĺ
	ǽܤƤꤵ줿롣
  =================================================*/
void EdicfIreru(bp) LPBYTE bp; {
	register BYTE *si;
	register integer_16 cx;
	for(cx=ed_ndata,si=ed_data;cx--;){
		*bp++=(*si++);
	}
}


/*========== EdicfShift(si,di,cx) =============
	ǽؽؤȻΥǡư
  ============================================*/
void EdicfShift(si,di,cx) LPBYTE si,di; register integer_16 cx; {
	for(;cx--;){
		*di--=(*si--);
	}
}


/*========== EdicfAkeru(cx,bp) =============================================
	ϡbp			륢ɥ쥹
 		  cx			Хȿ
	ǽꤵ줿꤫ꤵ줿ХȿˤĤ롣
  =========================================================================*/
void EdicfAkeru(cx,bp) register integer_16 cx; LPBYTE bp; {
	register integer_16 ax;
	LPBYTE si,di;

	ax=Fdd_BlkSize*Fdd_Header.Fdd_EdicPageSize;
	si=edic_page_addr+(ax-cx); di=edic_page_addr+ax;
	cx=ax-((integer_16)(bp-edic_page_addr)+cx);
	for(;cx;--cx){
		*(--di)=(*(--si));
	}
}


/*========== EdicfTsumeru(cx,bp) ===========================================
	ϡbp			Ĥ륢ɥ쥹
 		  cx			ĤХȿ
	ǽꤵ줿꤫ꤵ줿ХȿƤĤ롣
  =========================================================================*/
void EdicfTsumeru(cx,bp) register integer_16 cx; LPBYTE bp; {
	LPBYTE si;

	si=bp+cx;
	cx=Fdd_BlkSize*Fdd_Header.Fdd_EdicPageSize-(WORD)(bp-edic_page_addr)-cx;
	for(;cx;--cx){
		*bp++=(*si++);
	}
}


/*========== EdicfSentouSagasu(bp,&f1,&f2) ===========================================
	ϡes:[di+bp]	ܸΥե饰Υɥ쥹
	ϡf1			ǽƱΥե饰Υɥ쥹
		f2			ǽƱΥե饰Υɥ쥹
	ǽܸޤƱ쥰롼פƬθΥɥ쥹롣
  ==============================================================================*/
void EdicfSentouSagasu(bp,f1,f2) LPBYTE bp,*f1,*f2; {
	LPBYTE save,bx;

	bx=edic_page_addr;				/* ڡƬĴ٤ƹԤ*/
	while(1){
		if(bx>=bp){ break; }	/* ܸθΥե饰ʤ齪ꡣ*/
		save=bx;					/* ե饰Υڡ⥪եåȤФƤ*/
		bx+=(*(bx+1)+2);
	}
	*f1=save;				/* ФƤե饰Υڡ⥪եå */
	bx=save+2;				/* ФΥڡ⥪եå */
	while(sign(*bx)==0){ ++bx; }	/* ФȤФ*/
	*f2=bx;
}

/***************************** END OF ILE_MRUC.C *****************************/
#endif
