/**********************************************
	ILE_NUMC.C	updated at 1st October 1990
	Ѵν
 **********************************************/

#define		EXT		extern

#include	"onsei.h"
#include	"ile_acch.h"
#include	"ile_edic.h"
#include	"ile_envh.h"
#include	"ile_errh.h"
#include	"ile_idic.h"
#include	"ile_kkhh.h"
#include	"ile_nydh.h"
#include	"ile_shdh.h"
#include	"ile_stch.h"
#include	"ile_stzh.h"
#include	"ile_func.h"
#include "pkind.h"

/*
 *	(1)MAN, EXPΰ̣
 *		οβȻؿɽ魯
 *		̤٤ˡϡMAN=1ϡMAN=0Ȥ롣
 *		ɴˤĤƤ⡢ԹǡMAN=0Ȥ롣
 *		Žϡ11..19ؿ򣱤Ȥư
 *		ֿסֲסִפβϤ줾졢212223ɽ魯
 *		ޤ桢ϡ򤽤줾6566Ȥؿ0Ȥ롣
 *
 *	(2)¥ľβ˰¸뤿ᡢ0xD70xCFʤ륳ɤǽ
 *	Ȥη塢0xD0..0xD40xC8..0xCBʬह롣
 */

static const BYTE DPRON_TBL1[]={
	/* JIS    MAN EXP ACC.	   PRON. */	
	0x21,0x3B,  0, 0, 0x01, 0x02,0x83,0x64,		/*  */
	0x30,0x6C,  1, 0, 0x02, 0x02,0x01,0x29,		/*  */
	0x46,0x73,  2, 0, 0x01, 0x01,0x39,			/*  */
	0x3B,0x30,  3, 0, 0x00, 0x02,0x10,0xD7,		/*  */
	0x3B,0x4D,  4, 0, 0x01, 0x02,0x5C,0xD7,		/*  */
	0x38,0x5E,  5, 0, 0x01, 0x01,0x74,			/*  */
	0x4F,0x3B,  6, 0, 0x02, 0x02,0x64,0x0A,		/* ϻ */
	0x3C,0X37,  7, 0, 0x01, 0x02,0x38,0x38,		/*  */
	0x48,0x2C,  8, 0, 0x02, 0x02,0x40,0x29,		/* Ȭ */
	0x36,0x65,  9, 0, 0x01, 0x02,0x0E,0xC0,		/*  */
	0x3F,0x74, 21, 0, 0x01, 0x02,0x12,0xC0,		/*  */
	0x32,0x3F, 22, 0, 0x01, 0x02,0x38,0xD7,		/*  */
	0x34,0x76, 23, 0, 0x01, 0x02,0x01,0x0A,		/*  */

	0x3D,0x3D,  0, 1, 0x01, 0x02,0x8A,0xC0,		/*  */
	0x3D,0x26,  0, 1, 0x01, 0x02,0x8A,0xC0,		/*  */
	0x49,0x34,  0, 2, 0x02, 0x02,0x45,0x0A,		/* ɴ */
	0x40,0x69,  0, 3, 0x01, 0x02,0x13,0xD7,		/*  */

	0x4B,0x7C,  0, 4, 0x01, 0x02,0x50,0xD7,		/*  */
	0x68,0x5F,  0, 4, 0x01, 0x02,0x50,0xD7,		/*  */
	0x32,0x2F,  0, 8, 0x01, 0x02,0x04,0x0A,		/*  */
	0x43,0x7B,  0,12, 0x01, 0x02,0x2C,0xC0,		/*  */
	0x35,0x7E,  0,16, 0x01, 0x02,0x0B,0xC0,		/*  */
	
	0x21,0x5C, 65, 0, 0x00, 0x03,0xA2,0x60,0x12,		/*  */
	0x21,0x5D, 65, 0, 0x00, 0x04,0x50,0x01,0x38,0x12,	/*  */
	0x21,0x5E, 65, 0, 0x04, 0x07,0xA2,0x60,0x12,0x50,0x01,0x38,0x12,	/*  */
	0x21,0x25, 66, 0, 0x01, 0x02,0x23,0xD7,				/*  */

	0xFF										/* STOPPER */
};

static const BYTE DPRON_TBL2[]={
	/*   JIS		    MAN EXP ACC.		  PRON. */
	0x30,0x6C,0x3D,0x26,  2, 1, 0x03, 0x04,0x01,0x29,0x8A,0xC0,	/* 콦 */
	0x46,0x73,0x3D,0x3D,  2, 1, 0x01, 0x03,0x39,     0x8A,0xC0,	/*  */
	0x46,0x73,0x3D,0x26,  2, 1, 0x01, 0x03,0x39,     0x8A,0xC0,	/*  */
	0x3B,0x30,0x3D,0x3D,  3, 1, 0x01, 0x04,0x10,0xD7,0x8A,0xC0,	/*  */
	0x3B,0x30,0x3D,0x26,  3, 1, 0x01, 0x04,0x10,0xD7,0x8A,0xC0,	/*  */
	0x3B,0x4D,0x3D,0x3D,  4, 1, 0x01, 0x04,0x5C,0xD7,0x8A,0xC0,	/* ͽ */
	0x3B,0x4D,0x3D,0x26,  4, 1, 0x01, 0x04,0x5C,0xD7,0x8A,0xC0,	/* ͽ */
	0x38,0x5E,0x3D,0x3D,  5, 1, 0x02, 0x03,0x74,     0x8A,0xC0,	/* ޽ */
	0x38,0x5E,0x3D,0x26,  5, 1, 0x02, 0x03,0x74,     0x8A,0xC0,	/* ޽ */
	0x4F,0x3B,0x3D,0x3D,  6, 1, 0x03, 0x04,0x64,0x0A,0x8A,0xC0,	/* ϻ */
	0x4F,0x3B,0x3D,0x26,  6, 1, 0x03, 0x04,0x64,0x0A,0x8A,0xC0,	/* ϻ */
	0x3C,0x37,0x3D,0x3D,  7, 1, 0x02, 0x04,0x38,0x38,0x8A,0xC0,	/*  */
	0x3C,0x37,0x3D,0x26,  7, 1, 0x02, 0x04,0x38,0x38,0x8A,0xC0,	/*  */
	0x48,0x2C,0x3D,0x3D,  8, 1, 0x03, 0x04,0x40,0x29,0x8A,0xC0,	/* Ȭ */
	0x48,0x2C,0x3D,0x26,  8, 1, 0x03, 0x04,0x40,0x29,0x8A,0xC0,	/* Ȭ */
	0x36,0x65,0x3D,0x3D,  9, 1, 0x01, 0x04,0x0E,0xC0,0x8A,0xC0,	/* 彽 */
	0x36,0x65,0x3D,0x26,  9, 1, 0x01, 0x04,0x0E,0xC0,0x8A,0xC0,	/* 彦 */
	0x3F,0x74,0x3D,0x3D, 21, 1, 0x01, 0x04,0x12,0xC0,0x8A,0xC0,	/*  */
	0x32,0x3F,0x3D,0x3D, 22, 1, 0x01, 0x04,0x38,0xD7,0x8A,0xC0,	/*  */
	0x34,0x76,0x3D,0x3D, 23, 1, 0x01, 0x04,0x01,0x0A,0x8A,0xC0,	/*  */

	0x30,0x6C,0x49,0x34,  2, 2, 0x04, 0x04,0x01,0xC8,0xA5,0x0A,	/* ɴ */
	0x46,0x73,0x49,0x34,  2, 2, 0x03, 0x03,0x39,     0x45,0x0A,	/* ɴ */
	0x3B,0x30,0x49,0x34,  3, 2, 0x01, 0x04,0x10,0xD7,0x9D,0x0A,	/* ɴ */
	0x3B,0x4D,0x49,0x34,  4, 2, 0x01, 0x04,0x5C,0xD7,0x45,0x0A,	/* ɴ */
	0x38,0x5E,0x49,0x34,  5, 2, 0x03, 0x03,0x74,     0x45,0x0A,	/* ɴ */
	0x4F,0x3B,0x49,0x34,  6, 2, 0x04, 0x04,0x64,0xC8,0xA5,0x0A,	/* ϻɴ */
	0x3C,0x37,0x49,0x34,  7, 2, 0x02, 0x04,0x38,0x38,0x45,0x0A,	/* ɴ */
	0x48,0x2C,0x49,0x34,  8, 2, 0x04, 0x04,0x40,0xC8,0xA5,0x0A,	/* Ȭɴ */
	0x36,0x65,0x49,0x34,  9, 2, 0x01, 0x04,0x0E,0xC0,0x45,0x0A,	/* ɴ */
	0x3F,0x74,0x49,0x34, 21, 2, 0x01, 0x04,0x12,0xC0,0x45,0x0A,	/* ɴ */
	0x32,0x3F,0x49,0x34, 22, 2, 0x01, 0x04,0x38,0xD7,0x9D,0x0A,	/* ɴ */
	0x34,0x76,0x49,0x34, 23, 2, 0x01, 0x04,0x01,0x0A,0x45,0x0A,	/* ɴ */

	0x30,0x6C,0x40,0x69,  1, 3, 0x03, 0x04,0x01,0xC8,0x13,0xD7,	/*  */
	0x46,0x73,0x40,0x69,  2, 3, 0x02, 0x03,0x39,     0x13,0xD7,	/*  */
	0x3B,0x30,0x40,0x69,  3, 3, 0x03, 0x04,0x10,0xD7,0x83,0xD7,	/*  */
	0x3B,0x4D,0x40,0x69,  4, 3, 0x03, 0x04,0x5C,0xD7,0x13,0xD7,	/*  */
	0x38,0x5E,0x40,0x69,  5, 3, 0x02, 0x03,0x74,     0x13,0xD7,	/*  */
	0x4F,0x3B,0x40,0x69,  6, 3, 0x03, 0x04,0x64,0x0A,0x13,0xD7,	/* ϻ */
	0x3C,0x37,0x40,0x69,  7, 3, 0x03, 0x04,0x38,0x38,0x13,0xD7,	/*  */
	0x48,0x2C,0x40,0x69,  8, 3, 0x03, 0x04,0x40,0xC8,0x13,0xD7,	/* Ȭ */
	0x36,0x65,0x40,0x69,  9, 3, 0x03, 0x04,0x0E,0xC0,0x13,0xD7,	/*  */
	0x3F,0x74,0x40,0x69, 21, 3, 0x01, 0x04,0x12,0xC0,0x13,0xD7,	/*  */
	0x32,0x3F,0x40,0x69, 22, 3, 0x03, 0x04,0x38,0xD7,0x83,0xD7,	/*  */
	0x34,0x76,0x40,0x69, 23, 3, 0x01, 0x04,0x01,0x0A,0x13,0xD7,	/*  */

	0x4A,0X23,0X3F,0X74, 64, 0, 0x03, 0x04,0x42,0x0A,0x12,0xC0,	/* ʣ */

	0x3D,0x3D,0x30,0x6C, 11, 1, 0x04, 0x04,0x8A,0xC0,0x01,0x29,	/*  */
	0x3D,0x26,0x30,0x6C, 11, 1, 0x04, 0x04,0x8A,0xC0,0x01,0x29,	/*  */
	0x3D,0x3D,0x46,0x73, 12, 1, 0x03, 0x03,0x8A,0xC0,0x39,		/*  */
	0x3D,0x26,0x46,0x73, 12, 1, 0x03, 0x03,0x8A,0xC0,0x39,		/*  */
	0x3D,0x3D,0x3B,0x30, 13, 1, 0x01, 0x04,0x8A,0xC0,0x10,0xD7,	/*  */
	0x3D,0x26,0x3B,0x30, 13, 1, 0x01, 0x04,0x8A,0xC0,0x10,0xD7,	/*  */
	0x3D,0x3D,0x3B,0x4D, 14, 1, 0x03, 0x04,0x8A,0xC0,0x5C,0xD7,	/*  */
	0x3D,0x26,0x3B,0x4D, 14, 1, 0x03, 0x04,0x8A,0xC0,0x5C,0xD7,	/*  */
	0x3D,0x3D,0x38,0x5E, 15, 1, 0x01, 0x03,0x8A,0xC0,0x74,		/*  */
	0x3D,0x26,0x38,0x5E, 15, 1, 0x01, 0x03,0x8A,0xC0,0x74,		/*  */
	0x3D,0x3D,0x4F,0x3B, 16, 1, 0x04, 0x04,0x8A,0xC0,0x64,0x0A,	/* ϻ */
	0x3D,0x26,0x4F,0x3B, 16, 1, 0x04, 0x04,0x8A,0xC0,0x64,0x0A,	/* ϻ */
	0x3D,0x3D,0x3C,0x37, 17, 1, 0x03, 0x04,0x8A,0xC0,0x38,0x38,	/*  */
	0x3D,0x26,0x3C,0x37, 17, 1, 0x03, 0x04,0x8A,0xC0,0x38,0x38,	/*  */
	0x3D,0x3D,0x48,0x2C, 18, 1, 0x04, 0x04,0x8A,0xC0,0x40,0x29,	/* Ȭ */
	0x3D,0x26,0x48,0x2C, 18, 1, 0x04, 0x04,0x8A,0xC0,0x40,0x29,	/* Ȭ */
	0x3D,0x3D,0x36,0x65, 19, 1, 0x03, 0x04,0x8A,0xC0,0x0E,0xC0,	/*  */
	0x3D,0x26,0x36,0x65, 19, 1, 0x03, 0x04,0x8A,0xC0,0x0E,0xC0,	/*  */

	0xFF														/* STOPPER */
};

static	STZ_STRUCT Stz_PE_SAV;	/* ³ط ¸ΰ */
static	STZ_STRUCT Stz_CE_SAV;	/* ³ط ¸ΰ */

/*========== NUMB1000() ==================================================
	ǽceptrʸcelenʸ󤬿ѴǤ뤫ɤĴ٤롣
	͡ǽͭ꡿ǽ̵
  ========================================================================*/
BOOL NUMB1000() {
	BYTE al;
	register integer_16 ptr;

	/* 측ΤȤϡʤ*/
	/*****if(Stz_CE.stz_mru & BITMRU_ABORT)then return 0; fi*****/

	/* ʳʸޤǤ顢ǽ̵*/
	if((al=OTHER2000())==0){ return 0; }
	if(al!=CHRKIND_Digit){ return 0; }

	/*
	 *	ʸʤ顢ʤ--- 
	 *		ʿ
	 *		̾κǸ夬ǽäƤ礬Τǡ
	 *		ΥåϤʤ褤
	 *	âΤȤ㳰Ū˽롣ΤȤ϶ڤ국Ǥ롣
	 *	if((ptr=ceptr-1)!=(-1)){
	 *		if((inert_kind[ptr] & 0xF0)==CHRKIND_Digit
	 *		&& (inert_kind[ptr]!=CHRKIND_DDP)){ return 0; }
	 *	}
	 *
	 *
	 * ʸǤʤС롣
	 *	if((ptr=ceptr+celen)==n_inert){ return 1; }
	 *	if((inert_kind[ptr] & 0xF0)!=CHRKIND_Digit){ return 1; }
	 *
	 *
	 *	ʸΤȤ------ 
	 *		ɴ顢ʤн롣	ʣߡ
	 *		ʤн롣					ʣġ
	 *		ʳϽʤ
	 *	θˡֿסֲסִפǤϤޤ䡢Ȭ͡פΤ褦ʸ줬
	 *	뤫⤷ʤΤǤνϤ롣
	 *	if(inert_kind[ptr]==CHRKIND_KDigit2){ return 1; }
	 *	if(inert_kind[ptr]==CHRKIND_KDigit4){ return 1; }
	 *	if(inert_kind[ptr]==CHRKIND_DDP){ return 1; }
	 *	return 0;
	 */
	return 1;
}


/*========== NUMB5000(sw) ==================================================
	ǽǳϰ֤Ϥޤȯϥǡꥢ˳Ǽ롣
		åڤʸ⤳Υ롼ǹԤ롣
	ա¥ľβ˰¸뤿ᡢ0xD70xCFʤ륳ɤǽ
		Ȥη塢0xD0..0xD40xC8..0xCBʬह롣
	ϡᣰɤʤ
		ᣱɤ߻ꡣ
		ᣲɤ߻ꡣ
  ===========================================================================*/
BOOL NUMB5000(sw) integer_16 sw; {
	const BYTE* tbl;
        BYTE* si;
	integer_16 dman,dexp,frac_len,int_len;
	integer_16 di,bx,cx,dptr,dlen,dptr2,dlen2,dif,dlast_precede;

	if(kkhstat==err){ return 0; }

	int_len=NUM0010();
	frac_len=NUM0020();
	DIGIT_CONV(sw);
	digit_mode=0;		/* reset digit convert mode (to integer) */
	dptr=0;
NUMB5000_100:;
	di=cpron_ptr;
	if((dlen=n_kansuji-dptr)==0){ goto NUMB5000_SUCCESS; }
	if(dlen>2){ dlen=2; }
	dptr2=dptr;	dlen2=dlen;
NUMB5000_200:;
	if(dlen2==1){ tbl=DPRON_TBL1; }else{ tbl=DPRON_TBL2; }
	while(1){
		if(*tbl==0xFF){ goto NUMB5000_NF; }	/* not found */
		si=(&kansuji[dptr2*2]); cx=dlen2*2; dif=0;
		for(;cx--;){
			if(*si-*tbl){ dif++; }
			++si; ++tbl;
		}
		if(dif==0){ goto NUMB5000_F; }			/* found */
		tbl+=3; cx=(*tbl); tbl+=cx+1;
	}
NUMB5000_NF:;										/* NOT FOUND !*/
	if((dlen2=(--dlen))==0){ return 0; }		/* convert disable */
	goto NUMB5000_200;								/* search length 1 */

NUMB5000_F:;										/* FOUND !*/
	stc_ed_ofs[stc_ptr]=pkind_digiti0;
	Stz_CE.stz_dman=(*tbl); ++tbl;
	Stz_CE.stz_dexp=(*tbl);
	stc_ed_ofs[stc_ptr]+=(*tbl); ++tbl;
	if(stc_ed_ofs[stc_ptr]>pkind_digiti3){ stc_ed_ofs[stc_ptr]=pkind_digiti3; }
		/*
		 *	stc_ed_ofs[] =	0..9	 : pkind_digiti0
		 *					10..90	 : pkind_digiti0+1
		 *					100..900 : pkind_digiti0+2
		 *					>=1000	 : pkind_digiti0+3
		 */
	stc_accent_raw[stc_ptr][0]=(*tbl++);			/* basic accent type */
	stc_accent_raw[stc_ptr][1]=0;
	stc_accent_raw[stc_ptr][2]=0;
	/* ʳϡ֤Ρפ㤯դ*/
	if(Stz_CE.stz_dman!=3 || Stz_CE.stz_dexp!=0){
		stc_accent_raw[stc_ptr][6]=2;
	}
	dlast_precede=di-1;
													/* move pronunciation data */
	cx=cpron_len=(*tbl++);							/* mora length */

	/* ڤ */
	/* if(cx==0){ dptr+=dlen; goto NUMB5000_100; } */

	for(;cx--;){ di=OMEGA1000(*tbl++,di); }

	if(Stz_CE.stz_dman || Stz_CE.stz_dexp<4 || dptr==0){
		goto NUMB5000_500;
	}

	/* â⡼ɤʤ顢Τޤ޽Ϥ롣--89.12.12-- */
	if(onsei_addr->onsei_kouseisystem){ goto NUMB5000_500; }

	/***********************************************/
	/*  ξ硢ľοȷ礹 */
	/***********************************************/

	/* ľΰ졢Ȭ졢Ȭ¥롣*/
	if(Stz_CE.stz_dexp!=12 && Stz_CE.stz_dexp!=16){ goto NUMB5000_320; }
	dman=stc_dman[stc_ptr-1];
	dexp=stc_dexp[stc_ptr-1];
	/* 졢Ȭܿ졢ȬʤС*/
	if(dman==11||dman==18){ goto NUMB5000_310; }		/* 11,18 */
	if(dman>10){ goto NUMB5000_320; }					/* 12..17,19 */
	if(dexp==1){ goto NUMB5000_310; }					/* 10,20..90 */
	if(dexp!=0){ goto NUMB5000_320; }					/* >=100 */
	if(dman==1||dman==8){ goto NUMB5000_310; }			/* 1,8 */
	goto NUMB5000_320;										/* else */
NUMB5000_310:
	omega[dlast_precede]=0xCF;
NUMB5000_320:
	/**
	 **	..ΤȤϡstz_dexp򣱤ˤƤ
	 **	..̰Ǥ뤬̰Ǥ褤
	 **	if(Stz_PE.stz_dman<=9 && Stz_PE.stz_dexp==0
	 **	&& stc_out_len[stc_ptr-1]>2){
	 **		stc_dman[stc_ptr-1]=2;
	 **		stc_dexp[stc_ptr-1]=1;
	 **		stc_ed_ofs[stc_ptr-1]=pkind_digiti0+1;
	 **	}
	 **/

	/* οʿĲƬ⡢㤯դ */
	if(Stz_CE.stz_dexp==4){
		stc_accent_raw[stc_ptr-1][0]=stc_out_len[stc_ptr-1]+1;
	}else{
		/*   ϡƬⲽ */
		stc_accent_raw[stc_ptr-1][0] =
			( (stc_dman[stc_ptr-1]>=21 && stc_dman[stc_ptr-1]<=23)
				? 0x01 : stc_out_len[stc_ptr-1] );
	}
	stc_ed_ofs[stc_ptr-1]+=Stz_CE.stz_dexp;
	if(stc_ed_ofs[stc_ptr-1]>pkind_digiti3){
		stc_ed_ofs[stc_ptr-1]=pkind_digiti3;
	}
	stc_dexp[stc_ptr-1]+=Stz_CE.stz_dexp;
	stc_out_len[stc_ptr-1]+=2;

	dptr+=dlen;				/* ϥǡ */
	cpron_ptr=di;			/* ϥǡ֥ꥢΰ֤¸ */
	/*
	 * ּɴפѴˤơּɴפѴǡsent_in_ptr[]ϡ
	 * ˤʤäƤ롣פѴȤˡפĹäƤϤʤ
	 *		sent_in_ptr[bx]+=dlen; --- 
	 */
	sent_in_ptr[bx]=ceptr+celen;
	sent_out_ptr[sent_ptr]=di;
	memcpy(&Stz_PE,&Stz_CE,sizeof(STZ_STRUCT));
							/* ñ³Ϣñʤ */
	goto NUMB5000_100;

NUMB5000_500:
	/*
	 *	ľν޽ϻȬʿĲ롣
	 *	ΤȤⲽ ---- 
	 *
	 *	if(Stz_CE.stz_dexp==0 && Stz_CE.stz_dman<=9){
	 *		if(stc_dexp[stc_ptr-1]==1){
	 *			switch(stc_dman[stc_ptr-1]){
	 *			case 0: case 5: case 6: case 8:
	 *				stc_accent_raw[stc_ptr-1][0]=0;
	 *				stc_accent_raw[stc_ptr][0]=cpron_len;
	 *			}
	 *		}
	 *	}
	 */
	/*
	 *	ޤϡɤ߷󡢸ޤĹ롣
	 *	âΤȤϡΤȤĹʤ
	 *	ޤɤߤΣĹʤ
	 */
	if((digit_mode==1 && frac_len>1)||(digit_type==1 && int_len>1)){
		stc_ed_ofs[stc_ptr]=pkind_digitf;
		switch(Stz_CE.stz_dman*100+Stz_CE.stz_dexp){
		case 200:
		case 500:
			++cpron_len; di=OMEGA1000(0xC0,di);
		}
	}

	/*
	 *	ʤ龮⡼ɤڤؤ롣
	 *	ľο̤ΤȤϡƬⲽ롣--- ???
	 *	ľΰ졢Ȭ¥롣
	 *	ľ󡢸ޤĹ롣
	 */
	if(Stz_CE.stz_dman==DMANKIND_DP){
		digit_mode=1;
		/* ľ˿ */
		if(dptr!=0){
			/*if(stc_dexp[stc_ptr-1]==0){ stc_accent_raw[stc_ptr-1][0]=1; }*/

			/* 졢ȬܿʤС¥롣*/
			/* ϡƱˤ롣*/
			if(stc_dman[stc_ptr-1]<11 || 19<stc_dman[stc_ptr-1]){
				if(stc_dexp[stc_ptr-1]==1){ goto NUMB5000_540; }
			}

			switch(stc_dman[stc_ptr-1]*100+stc_dexp[stc_ptr-1]){
			case 100: case 800: case 1101: case 1801:
				NUMB5000_540:
				/* ⡼ɤǤʤȤ¥롣--89.12.12-- */
				if(onsei_addr->onsei_kouseisystem==0){
					omega[dlast_precede]=0xCF;
				}
				break;
			/* 󡢸ޤʤ */
			case 200: case 500: case 1201: case 1501:
				/*
				 * ֣פοΣϾľʤΤĹ뤬
				 *  ľǤ⤢롣ŤĹʤ٤ˡ
				 *  ĹǽäƤ뤫ɤĴ٤롣-- 88.6.13 --
				 */
				if(0xC0!=omega[di-3]){
					omega[di]=omega[di-1]; omega[di-1]=omega[di-2];
					omega[di-2]=0xC0;
					++di;
					stc_out_len[stc_ptr-1]=stc_out_len[stc_ptr-1]+1;
				}
			}
		}
	}

	cpron_ptr=di;			/* ϥǡ֥ꥢΰ֤¸ */
	bx=sent_ptr;		 	/* ϥǡ֥ꥢʸֹ */
	/* ƬοΤʸǽˤʤ */
	if(dptr){
		Stz_CE.stz_ctl &= ~BITCTL_FIRST;
	}else{
		Stz_CE.stz_ctl |= BITCTL_FIRST;
	}
	if(dptr==0){			/* dptr==0 ΤȤʸǽˤʤꤦ */
							/* Ƭȼʤǽˤʤꤨʤ */
		if(StzfAttrAri(Stz_CE,stz_ctl,BITCTL_FIRST)
		&& StzfAttrAri(Stz_CE,stz_stz,BITSTZ_PREF)==0){
			/* ϲǽʸĶƤʤ */
			if(bx>=MAX_SENT){ jp_ERROR(Err_NaibuOVF); }
			/* ƬǤʤʸʤ */
			if(ceptr!=0){ bx++; sent_ptr=bx; }
		}
	}
	/* ʸκǸʸΰ֤򣱥ꥸꤹ */
	sent_out_ptr[bx]=di;
	sent_in_ptr [bx]=ceptr+celen;	/*dptr+dlen;*/

	STACK_PUSH();
	/*
	 *	PUSHκݤˤϡceptrcelen ϿƬΤĹɽ路Ƥꡢ
	 *	줾 PUSH ǤȤбƤʤΤդ뤳 !!
	 */ 
	dptr+=dlen;				/* ϥǡ */
	memcpy(&Stz_PE,&Stz_CE,sizeof(STZ_STRUCT));
							/* ñ³Ϣñʤ */
	goto NUMB5000_100;

NUMB5000_SUCCESS:
	FOLLOW_INIT(&Stz_CE);
	ceptr+=celen;
	return 1;
}


/*========== NUMB5XXX(sw) ==================================================
	ǽǤΤȤǤ򥻡֤ԤѴľ
	ϡᣰɤʤ
		ᣱɤ߻ꡣ
		ᣲɤ߻ꡣ
  ===========================================================================*/
void NUMB5XXX(sw) integer_16 sw; {
	/* Ǥʤ餽Ѵľ*/
	if(stc_kind[stc_ptr-1]==DICKIND_D){
		/*
		 *	ӡľǤ³¸Ƥ
		 *
		 *	ξϿȯľȤѤäƤ뤳Ȥ롣
		 *	¨ľ衦ޡɽפΤȤϡ
		 *	³ѤäƤΤǤ롣
		 *	NUMB5000()μ¹ԸϤδ³󤬾äƤޤäƤ롣
		 *	äơ³¸ɬפ롣
		 *	ʤ顢δ³FOLLOW()ǤϤʤ
		 *	NUMB5000()Ǥ褦˽񤭴ϤʤϤǤ롣
		 *
		 *	ľǤ³ϤǻȤäƤ롣
		 */
		memcpy(&Stz_PE_SAV,&Stz_PE,sizeof(STZ_STRUCT));
		memcpy(&Stz_CE_SAV,&Stz_CE,sizeof(STZ_STRUCT));
		edic_page_no_sav=edic_page_no;
		edic_ofs_sav=edic_ofs;
		idic_addr_sav=idic_addr;
		ceptr_sav=ceptr; celen_sav=celen;

		/* popơѴľcpron_ptrѤ뤳Ȥ롣*/
		STACK_POP();

		StzfElmKind(&Stz_CE,DICKIND_D);		/* ñ̤Ȥ롣*/
		OTHER_GRCD();						/* ʸˡꤹ롣*/

		/*
		 * PEƬξ硢CEʸڤܤˤʤʤ롣
		 * âCTL򤳤魯ȥȽǺΤSTZ˽ࡣ
		 *		ξNUMB5000(sw)Ѥ롣
		 */
		if(ceptr!=0){
			if(StzfAttrAri(Stz_PE,stz_ctl,BITCTL_PREF)){
				Stz_CE.stz_stz |= BITSTZ_PREF;
			}
		}
		NUMB5000(sw);

		/* ʤޤϿľǡˤ³᤹*/
		edic_page_no=edic_page_no_sav;
		edic_ofs=edic_ofs_sav;
		idic_addr=idic_addr_sav;
		ceptr=ceptr_sav; celen=celen_sav;
		memcpy(&Stz_PE,&Stz_PE_SAV,sizeof(STZ_STRUCT));
		memcpy(&Stz_CE,&Stz_CE_SAV,sizeof(STZ_STRUCT));
		stc_stz[stc_ptr-1]=Stz_PE.stz_stz;
	}
}


/*========== NUM0010() ===============
	ǽη롣
  ====================================*/
integer_16 NUM0010() {
	BYTE *si;
	integer_16 len,cx;

	si=(&inert[ceptr*2]);
	len=0;
	for(cx=celen;cx--;){
		/* λϾǤϤʤʳȤ롣*/
		/* ֣פ򣱷ˤǤ롣*/
		/* ⡼ɤǤ⡢֥ˡޥפǤϤʤ֥˥ޥפɤߤ*/
		/*if(*si==0x21 && *(si+1)==0x25){ goto NUM0010_200; }*/
		if(*si!=0x23 || *(si+1)<0x30 || *(si+1)>0x39){ goto NUM0010_200; }
		++len; si+=2;
	}
NUM0010_200:;
	return len;
}


/*========== NUM0020() ===============
	ǽξη롣
  ====================================*/
integer_16 NUM0020() {
	BYTE *si;
	integer_16 len,cx;

	si=(&inert[(ceptr+celen-1)*2]);
	len=0;
	for(cx=celen;cx--;){
		if(*si==0x21 && *(si+1)==0x25){ goto NUM0020_200; }
		++len; si-=2;
	}
NUM0020_200:;
	if(cx==-1){ len=0; }
		/* forʸcx--ȤƤΤǡ{ȴcx-1ˤʤäƤ롣*/
	return len;
}


/*========== DIGIT7000() =====================
	ǽܽߤαƶͻ롣
  ============================================*/
void DIGIT7000() {
	BYTE acc3,acc4,acc5;
	register integer_16 sp_d,sp_n;
	integer_16 dptr,dlen,nptr,nlen,dlast,dman,dexp,ln,di,l;
	integer_16 complex;	/* ʣʤ飱Ȥ롣*/

	/* integer_16	sent_in_ptr[MAX_SENT];				 ʸ */
	/* integer_16	sent_out_ptr[MAX_SENT];				 ʸ */
	/* BYTE			stc_accent_raw[MAX_STACK][10];		 raw accent data */
	/* BYTE			inert[MAX_INERT*2];					 inert data */
	/* BYTE			omega[MAX_OMEGA];					 pronunciation data */

	sp_d=stc_ptr-2;		/* stack pointer for digit */
	sp_n=stc_ptr-1;		/* stack pointer for numerator */

	stc_dman[sp_n] = DMANKIND_NUM;			/**/

	/* ⡼ɤǤϡ⤷ʤ--89.12.12-- */
	/* âstc_dman[sp_n]ϡåȤ뤳ȡ*/
	if(onsei_addr->onsei_kouseisystem){ return; }

	dptr=stc_out_ptr[sp_d]; dlen=stc_out_len[sp_d];
	nptr=stc_out_ptr[sp_n]; nlen=stc_out_len[sp_n];
	/*DKIND=stc_dman[sp_d]*100+stc_dexp[sp_d];*/
	acc3=stc_accent_raw[sp_n][2];
	acc4=stc_accent_raw[sp_n][3];
	acc5=stc_accent_raw[sp_n][4];
	dlast=dptr+dlen-1;
	dman=stc_dman[sp_d];
	dexp=stc_dexp[sp_d];

	/* ʾΤȤϤʤˤ⤷ʤ*/
	if(dexp>=3){ return; }

	/* ..ɴ..ΤȤν */
	/* dexp==1 && dman>=11 && dman<=19 ΤȤϽ롣*/
	/* ..κǽ¥ϣΤȤ롣*/
	if((dexp==1 && (dman<10||dman==21||dman==22||dman==23))
	|| (dexp==2 && (acc3==5||acc3==6))){
		/* κǽ¥ */
		if(acc3>=1 && acc3<=6){ omega[dlast]=0xCF; }
		/* ƬѲʣУԲ*/
		if(acc5>=2 && acc5<=7){ DIGIT7020(&omega[nptr]); }
		return;
	}
	/* ¥ʤ..ϲ⤷ʤ*/
	if(dexp==2){ return; }


	/***********************************************************************
		ʲΥǥ󥰤ǡif(stc_out_len[sp_d]==2){פʤɤ
	ˤʤäƤͳϡܿˡʤɡ
	ñȤΣ..ʳˡñȤΣ..뤫Ǥ롣
		âacc4==1ΤȤѲϣ..ˤŬѤʤ
	************************************************************************/

	/*
	 * ʳʣȤߤʤ
	 * ֣Ȣפϡ֤ҤȤϤס֣Ȣס֣Ȣפϡ֡Ϥס
	 *			ɤ褦ʡ
	 * â֣ס֣֡פϡ֡衦ס
	 */
	complex=((stc_ptr>2)&&(stc_kind[stc_ptr-3]==DICKIND_D))||(dman>10);

	/* ....ΤȤν */
	switch(dman){
	case 1:
	case 11:
		/* ɤߤѲ */
		/*if(1==acc4 && 1==dman){*/
		if(1==acc4 || 2==acc4){
			if(!complex){
				/* ֤ע֤Ҥȡ */
				omega[dlast-1]=0x41; omega[dlast]=0x24;
			}
		}else{
			/* κǽ¥ʡ𣷡ˡ֤ҤȡפˤŬѤʤ*/
			switch(acc3){
			case 2: case 4: case 5: case 6:
				omega[dlast]=0xCF;
			}
			/* ΣܤΣУԲ */
			switch(acc5){
			case 2: case 3: case 5: case 6:
				DIGIT7020(&omega[nptr]);
			}
		}
		break;
	case 2:
	case 12:
		/* ɤߤѲ */
		/* ʤɤǡĹŬϰϳǤ롣*/
		/*if(acc4==1 && omega[dlast]!=0xC0){*/
		/*if(1==acc4 && 2==dman){*/
		if(1==acc4 || 2==acc4){
			if(!complex){
				/* ֤ˡע֤դ */
				stc_out_len[sp_d]++; stc_out_ptr[sp_n]++;
				di=cpron_ptr;
				ln=stc_out_len[sp_n];
				for(l=0;l<ln;++l){ omega[di-l]=omega[di-l-1]; }
				omega[dlast]=0x42; omega[dlast+1]=0x20;
				sent_out_ptr[sent_ptr]++;
				cpron_ptr++;
			}
		}
		break;
	case 3:
	case 13:
		/* ɤߤѲ */
		/*if(1==acc4 && 3==dman){*/
		if(1==acc4){
			if(!complex){
				/* ֤ע֤ߡ */
				stc_out_len[sp_d]--; stc_out_ptr[sp_n]--;
				ln=stc_out_len[sp_n]; di=cpron_ptr;
				omega[dlast-1]=0x51;
				for(;ln;--ln){ omega[di-ln-1]=omega[di-ln]; }
				sent_out_ptr[sent_ptr]--;
				cpron_ptr--;
				stc_accent_raw[sp_d][0]=1;
			}
		}else{
			/* ΣܤѲ */
			switch(acc5){
			case 1:								/*  */
				DIGIT7010(&omega[nptr]); break;
			case 4: case 5: case 6: case 7:		/* й */
				DIGIT7030(&omega[nptr]); break;
			case 2: case 3:						/* ѹ */
				DIGIT7020(&omega[nptr]);
			}
		}
		break;
	case 4:
	case 14:
		/* ɤߤѲ */
		/*if(7==acc3 || 11==acc3 || (1==acc4 && 4==dman)){*/
		if(7==acc3 || 11==acc3 || 1==acc4){
			if(1==acc4 && complex){ break; }
			/**if(!complex){*/
				/* ֤ע֤ */
				stc_out_len[sp_d]--; stc_out_ptr[sp_n]--;
				ln=stc_out_len[sp_n]; di=cpron_ptr;
				for(;ln;--ln){ omega[di-ln-1]=omega[di-ln]; }
				sent_out_ptr[sent_ptr]--;
				cpron_ptr--;
				/* ܥȤϡ⣱⣱ƬˤǤ롣*/
				stc_accent_raw[sp_d][0]=1;
			/*}*/
		}else{
			/* ΣܤѲ */
			switch(acc5){
			case 2: case 3:
				DIGIT7020(&omega[nptr]); break;		/* P */
			case 7:
				DIGIT7030(&omega[nptr]);			/* B */
			}
		}
		break;
	case 6:
	case 16:
		/* κǽ¥ʡ𣷡*/
		switch(acc3){
		case 3: case 5: case 6:
			omega[dlast]=0xCF;
		}
		/* ΣܤΣУԲ */
		switch(acc5){
		case 2: case 3: case 4: case 5: case 6: case 7:
			DIGIT7020(&omega[nptr]);
		}
		break;
	case 7:
	case 17:
		/* ɤߤѲ */
		switch(acc3){
		case 8: case 10: case 11:
			/**if(!complex){*/
				/* ֤ʤʡע֤ */
				ln=stc_out_len[sp_n]; di=cpron_ptr;
				omega[dlast-1]=0x19; omega[dlast]=0x29;
				/* ܥȤϡϣˡϣˤǤ롣*/
				stc_accent_raw[sp_d][0]=(7==dman ? 2:4);
			/**}*/
		}
		break;
	case 8:
	case 18:
		/* κǽ¥ʡ𣷡*/
		switch(acc3){
		case 4: case 6:
			omega[dlast]=0xCF;
		}
		/* ΣܤΣУԲ */
		switch(acc5){
		case 3: case 6:
			DIGIT7020(&omega[nptr]);
		}
		break;
	case 9:
	case 19:
		/* ɤߤѲ */
		switch(acc3){
		case 9: case 10: case 11:
			/**if(!complex){*/
				/* ֤塼ע֤ */
				stc_out_len[sp_d]--; stc_out_ptr[sp_n]--;
				ln=stc_out_len[sp_n]; di=cpron_ptr;
				omega[dlast-1]=0x0A;
				for(;ln;--ln){ omega[di-ln-1]=omega[di-ln]; }
				sent_out_ptr[sent_ptr]--;
				cpron_ptr--;
				/* ܥȤϡ⣱⣱ƬˤǤ롣*/
				stc_accent_raw[sp_d][0]=1;
			/**}*/
		}
		break;
	}
}


/*========== DIGIT7010(ch) ===================================
	ǽch롣
  ============================================================*/
void DIGIT7010(ch) register BYTE *ch; {
	switch(*ch & 0xF8){
	case 0x08:	*ch=(*ch & 0x07) | 0x78; break;		/* KA --> QA */
	case 0x10:	*ch=(*ch & 0x07) | 0x80; break;		/* SA --> ZA */
	case 0x18:	*ch=(*ch & 0x07) | 0x88; break;		/* SHA --> JA */
	case 0x28:	*ch=(*ch & 0x07) | 0x88; break;		/* CHA --> JA */
	case 0x20:	*ch=(*ch & 0x07) | 0x90; break;		/* TA --> DA */
	case 0x40:	*ch=(*ch & 0x07) | 0x98; break;		/* HA --> BA */
	case 0x68:	*ch=(*ch & 0x07) | 0x98; break;		/* WA --> BA */
	}
}


/*========== DIGIT7020(ch) ===================================
	ǽchP롣
  ============================================================*/
void DIGIT7020(ch) register BYTE *ch; {
	switch(*ch & 0xF8){
	case 0x40: case 0x68:
		*ch=(*ch & 0x07) | 0xA0;	/* HA,WA --> PA */
	}
}


/*========== DIGIT7030(ch) ===================================
	ǽchB롣
  ============================================================*/
void DIGIT7030(ch) register BYTE *ch; {
	switch(*ch & 0xF8){
	case 0x40: case 0x68:
		*ch=(*ch & 0x07) | 0x98;	/* HA,WA --> BA */
	}
}


/***************************** END OF ILE_NUMC.C *****************************/
