/********************************************
	ILE_RNSC.C	updated at 29th June 1991
	
 ********************************************/

#define		EXT		extern

#include	"onsei.h"
#include	"ile_errh.h"
#include	"ile_fddh.h"
#include	"ile_rnsc.h"

#define	incptr(ptr)	((ptr==last)? PageTable : ptr+1)

/* ڡơ֥륨ȥ꡼(ڡѥХåեϡPTE ˤäƴ롣)*/
typedef struct 
{
	LPBYTE PBA;		/* ڡХåեɥ쥹 */
	WORD PI;		/* ڡ(Valid bit, Modfy bit, Page No) */
} PTE;

/* PIγƤФΥޥ */
#define	V	0x8000	/* Valid bit(ȥ꡼̤Ѥʤ 1) */
#define	M	0x4000	/* Modfy bit(񤭤׵᤬ 1) */
#define	PN	0x3fff	/* Page No(ڡֹ 1 - 16,384) */

/* Ѱդ PTE ο */
#define	MaxPTE	25

static PTE PageTable[MaxPTE] = {{0,0}};
static PTE* head = NULL;
static PTE* tail = NULL;
static PTE* last = NULL;

static PTE *GetBuffer(void);
static PTE *SearchBuffer(WORD page);

/*========== RNS_INIT() ======================================
	ǽڡХåեݤ󥰥Хåե롣
  ===========================================RnsfShokikasuru==*/
void RNS_INIT(void) 
{
	WORD count;
	PTE* bp;
	LPBYTE addr;
	int allocFailed = 0;
	head=bp=PageTable;
	
	for (count=MaxPTE; count--; ) 
	{
		if(RtkfAlloc(&addr,Fdd_Header.Fdd_EdicPageSize)==0) 
		{
			allocFailed = 1;
			break;
		}
		bp->PI = V;
		bp->PBA = addr;
		++bp;
	}
	
	/* ڡݤǤʤХ顼*/
	if(allocFailed)
	{
		PTE* bpp;
		for (bpp=PageTable; bpp->PBA; ++bpp) 
		{
			RtkfDealloc(&(bpp->PBA));
		}
		jp_ERROR(Err_Fatal_Alloc);
	}
	tail=last=(--bp);
}

void RNS_DEALLOC()
{
	int count;
	PTE* bpp;
	for (bpp=PageTable, count = 0; bpp->PBA && count < MaxPTE; ++bpp, ++count) 
	{
		RtkfDealloc(&(bpp->PBA));
	}
}

/*========== RnsfReadEdic(Page,addr) ======================
	ǽڡ󥰤Ѥƻꤵ줿ڡؤɤ߹ࡣ
	ϡPage	ڡֹ
	ϡ*addr	ڡХåեɥ쥹
  =========================================================*/
void RnsfReadEdic(WORD Page,LPBYTE* addr)
{
	PTE *bp;
	
	if((bp=SearchBuffer(Page))==NULL) 
	{
		bp=GetBuffer();
		RtkfRead(Page,Fdd_Header.Fdd_EdicPageSize,bp->PBA);
		bp->PI=Page;
	}
	*addr = bp->PBA;
}

/*========== RnsfWriteEdic(Page) ============================
	ǽꤵ줿ڡPTEModfy bitonˤ롣
	ϡPage	ڡֹ
  ===========================================================*/
void RnsfWriteEdic(WORD Page)
{
	PTE *bp;
	
	/* Хåե˽񤭤ڡ̵Х顼*/
	if((bp=SearchBuffer(Page))==NULL) 
	{
		jp_ERROR(Err_Fatal_Alloc); 
	}
	bp->PI |= M;
}

/*========== RnsfFlushBuffer() ====================
	ǽModfy bitonΥڡ1ڡ񤭽Ф
	ϡᣰ񤭽Ф٤ڡʤä
		ᣱｪλ
  =================================================*/
BOOL RnsfFlushBuffer(void)
{
	PTE *pp;
	WORD pi;
	
	for(pp=head; ;pp=incptr(pp)) 
	{
		pi=pp->PI;
		if(((pi & V)==0) && (pi & M)) 
		{
			RtkfWrite(pi & PN,Fdd_Header.Fdd_EdicPageSize,pp->PBA);
			pp->PI &= ~M;
			return 1;
		}
		if(pp==tail)
		{ 
			goto RnsfFlushBuffer_end; 
		}
	}
	
RnsfFlushBuffer_end:
	return 0;
}

/*========== SearchBuffer(page) ========================================
	ǽХåեɬפʥڡ뤫 PageTable γPTE Ĵ٤롣
	ϡpage	ڡֹ
	ϡᣰڡʤ
		⣰PTEؤΥݥ󥿡ʣǤʤ褦ˤ뤳ȡ
  ======================================================================*/
static PTE *SearchBuffer(WORD page)
{
	register PTE *pp;
	register WORD pi;
	
	for(pp=head; ;pp=incptr(pp)) 
	{
		pi=pp->PI;
		if((pi & V)==0) 
		{
			pi &= PN;
			if(pi==page) 
			{
				return pp;
			}
		}
		if(pp==tail)
		{ 
			goto SearchBuffer_end; 
		}
	}
	
SearchBuffer_end:
	return NULL;
}

/*========== GetBuffer() ============================
	ǽڡ󥰤ΤΥХåեΰݤ롣
	ϡPTEؤΥݥ
  ===================================================*/
static PTE *GetBuffer(void)
{
	register PTE *pp;
	register WORD pi;
	
	pp=incptr(tail);
	pi=pp->PI;
	if((pi & V)==0) 
	{
		if(pi & M) 
		{
			RtkfWrite(pi & PN,Fdd_Header.Fdd_EdicPageSize,pp->PBA);
			pp->PI &= ~M;
		}
		head=incptr(head);
	}
	tail=incptr(tail);
	return pp;
}

/***************************** END OF ILE_RNSC.C *****************************/
