/************************************************
	ILE_STCC.C	updated at 14th November 1989
	åϢ
 ************************************************/

#define		EXT		extern

#if defined(DEBUG_STC)
#include	<stdio.h>
#endif

#include	"onsei.h"
#include	"ile_bunh.h"
#include	"ile_dbgh.h"
#include	"ile_edic.h"
#include	"ile_errh.h"
#include	"ile_fddh.h"
#include	"ile_idic.h"
#include	"ile_nydh.h"
#include	"ile_shdh.h"
#include	"ile_stch.h"
#include	"ile_stzh.h"
#include	"ile_tdic.h"
#include	"ile_func.h"

BYTE		stc_accent_raw[MAX_STACK][10] = {{0}};	/* ǡ */

/*========== STACK_INIT() ===============
	ǽå롣
  ======================StcfShokikasuru==*/
void STACK_INIT() {
	register integer_16 cx;
	stc_ptr=0;
	/* initialize next accent data region */
	for(cx=10;cx--;){ stc_accent_raw[stc_ptr][cx]=0x00; }
	/*stc_accent_raw[stc_ptr][4]=0xFF;	裲 */
}


/*========== STACK_PUSH() ===============
	ǽå˾Ѥࡣ
  =======================StcfStackTsumu==*/
void STACK_PUSH() {
	register integer_16 cx,sp;

#if defined(DEBUG_STC)
	if(debug[1]||debug[2]){ DEBUG_PN("<STC_PUSH>"); }
#endif

	if(stc_ptr==MAX_STACK){ jp_ERROR(Err_NaibuOVF); }

	RtkfChudanShiraberu();				/* ׵᤬Ѵߤ*/
	sp=stc_ptr;							/* Ѳǽʥåϰ֤ */
	stc_out_len[sp]=cpron_len;			/* ϥǡʸ */
	stc_out_ptr[sp]=(sp==0 ? 0 : stc_out_ptr[sp-1]+stc_out_len[sp-1]);
	stc_in_ptr[sp]=ceptr;				/* ϥǡ */
	stc_in_len[sp]=celen;				/* ϥǡʸ */
	stc_f2[sp] =Stz_CE.stz_f2;		/* ե饰ñμ̥ե饰*/
	stc_ctl[sp]=Stz_CE.stz_ctl;		/*  */
	stc_mru[sp]=Stz_CE.stz_mru;		/* ؽ */
	stc_stz[sp]=Stz_CE.stz_stz;		/* ³ */
	stc_dman[sp]=Stz_CE.stz_dman;	/*  */
	stc_dexp[sp]=Stz_CE.stz_dexp;	/*  */

	cx=stc_nbno[sp]=Stz_CE.stz_nbno;	/* üֹ */
	if(cx){	/* üֹ椬ʤ üֹ¸ (cxϣꥸ) */
		do{ stc_bno[sp][cx-1]=Stz_CE.stz_bno[cx-1]; }while(--cx);
	}
	cx=stc_ngrcd[sp]=Stz_CE.stz_ngrcd;	/* ʸˡɿ */
	if(cx){	/* ʸˡɤʤ¸ (cxϣꥸ) */
		do{ stc_grcd[sp][cx-1]=Stz_CE.stz_grcd[cx-1]; }while(--cx);
	}

	switch(stc_kind[sp]=Stz_CE.stz_kind){
	case DICKIND_5Y:					/* ư켫ưȯϢѷ */
		stc_in_len[sp]=0;
	case DICKIND_E:						/* Ω켭 */
		stc_ed_pag[sp]=edic_page_no;
		stc_ed_ofs[sp]=edic_ofs;
		break;
	case DICKIND_T:						/* ñ */
		stc_ed_pag[sp]=edic_page_no;
		stc_ed_ofs[sp]=tdic_ofs;
		stc_dexp[sp]=tdic_len;
		break;
	case DICKIND_I:						/* °켭 */
		stc_ed_pag[sp]=0;
		stc_ed_ofs[sp]=(WORD)(idic_addr-FddHDR);
		break;
	/* case DICKIND_D: --- stc_ed_ofs is digit kind. (int. or frac.) */
	}

	stc_ptr++;
	/* initialize next accent data region */
	for(cx=10;cx--;){ stc_accent_raw[stc_ptr][cx]=0x00; }
	/*stc_accent_raw[stc_ptr][4]=0xFF;	裲 */

#if defined(DEBUG_STC)
	if(debug[1]){ DEBUG_STC_ALL(); }
	if(debug[2]){ DEBUG_STC_CE(stc_ptr); }
#endif
}


/*========== STACK_POP() ====================
	ǽå򤪤
  ===========================StcfStackOrosu==*/
void STACK_POP() {
	register integer_16 sp,cx;

#if defined(DEBUG_STC)
	if(debug[3]){ DEBUG_PN("<STACK_POP>"); DEBUG_STC_CE(stc_ptr); }
#endif

	RtkfChudanShiraberu();			/* ׵᤬Ѵߤ*/

	if(stc_kind[stc_ptr-1]==DICKIND_5Y){				/* ϢѸ */
		/* ³˴Ϣñ᤹*/
		--stc_ptr;
		sp=stc_ptr-1;
		Stz_CE.stz_kind=stc_kind[sp];

		if(cx=Stz_CE.stz_nbno=stc_nbno[sp]){
			do{ Stz_CE.stz_bno[cx-1]=stc_bno[sp][cx-1]; }while(--cx);
		}
		if(cx=Stz_CE.stz_ngrcd=stc_ngrcd[sp]){
			do{ Stz_CE.stz_grcd[cx-1]=stc_grcd[sp][cx-1]; }while(--cx);
		}

		Stz_CE.stz_ctl=stc_ctl[sp];				/*  */
		Stz_CE.stz_f2=stc_f2[sp];				/* ե饰 */
		Stz_CE.stz_stz=stc_stz[sp];				/* ³ */
		Stz_CE.stz_mru=stc_mru[sp];				/* ؽ */
		Stz_CE.stz_dman=stc_dman[sp];			/*  */
		Stz_CE.stz_dexp=stc_dexp[sp];			/*  */
	}else{
		/* ³˴Ϣñ᤹*/
		StzfElmBackward();
	}

STACK_POP_100:
	stc_ptr--;
	sp=stc_ptr;
	ceptr=stc_in_ptr[sp];			/* current element pointer */
	celen=stc_in_len[sp];			/* current element length */
	cpron_ptr=stc_out_ptr[sp];		/* current pronunciation pointer */
									/* ܸϢ᤹ */
	switch(stc_kind[sp]){
	case DICKIND_I:					/* °켭 */
		idic_addr=FddHDR+stc_ed_ofs[sp]; break;
	case DICKIND_D:					/*  */
		if(sp==0){ break; }	/* no more stack exist */
		/*
		 * Ըʤ顢Ը줬Ǥʤʤޤǣ𤹤롣
		 *	ֻפΡפ𤷤顢ֻפɬ𤹤롣
		 *	֣|פΡְפ𤷤顢֣פϣ𤷤ƤϤʤʤ
		 *	ʤƬˤʤꤦޤǣ𤹤롣
		 */
		if(stc_ctl[sp] & BITCTL_FIRST){ break; }
		if(stc_kind[sp-1]==DICKIND_D){
			Stz_CE.stz_ctl=stc_ctl[sp-1];
			goto STACK_POP_100;
		}
		break;
	case DICKIND_E:					/* Ω켭 */
		edic_page_no=stc_ed_pag[sp];	/* ڡֹ */
		edic_ofs=stc_ed_ofs[sp];		/* ڡ⥪եå */
		break;
	case DICKIND_T:					/* ñ */
		edic_page_no=stc_ed_pag[sp];	/* ڡֹ */
		tdic_ofs=stc_ed_ofs[sp];		/* ڡ⥪եå */
		tdic_len=stc_dexp[sp];			/* 쥳ɥȡ륵 */
		break;
	}

	OMEGA6000();						/* Ϸ̤᤹ */
	if(stc_ptr){						/* Ը줬ĤäƤԸϢ᤹*/
		sp=stc_ptr-1;
		StzfElmKind(&Stz_PE,stc_kind[sp]);
		if(cx=Stz_PE.stz_nbno=stc_nbno[sp]){
			do{ Stz_PE.stz_bno[cx-1]=stc_bno[sp][cx-1]; }while(--cx);
		}
		if(cx=Stz_PE.stz_ngrcd=stc_ngrcd[sp]){
			do{ Stz_PE.stz_grcd[cx-1]=stc_grcd[sp][cx-1]; }while(--cx);
		}
		Stz_PE.stz_f2=stc_f2[sp];			/* ե饰 */
		Stz_PE.stz_ctl=stc_ctl[sp];			/*  */
		Stz_PE.stz_mru=stc_mru[sp];			/* ؽ */
		Stz_PE.stz_stz=stc_stz[sp];			/* ³ */
		Stz_PE.stz_dman=stc_dman[sp];		/*  */
		Stz_PE.stz_dexp=stc_dexp[sp];		/*  */
	}

	/* initialize next accent data region */
	for(cx=10;cx--;){ stc_accent_raw[stc_ptr][cx]=0x00; }
	/*stc_accent_raw[stc_ptr][4]=0xFF;	裲 */
}


/*========== STACK_POP_FS() =========================================
	ǽåѼʸľޤǤξ򤪤
		¹Ը塢ceptr(current element pointer)
		fsptr(following sentence pointer)ʤ롣
  ================================================StcfBunOnajiOrosu==*/
void STACK_POP_FS() {
	while(ceptr>fsptr){ STACK_POP(); }
}


/*========== STACK_POP_WS() =====================================
	ǽåѼʸޤǤξ򤪤
		¹Ը塢ceptr(current element pointer)
		wsptr(watching sentence pointer)ʤ롣
  ============================================StcfBunTemaeOrosu==*/
void STACK_POP_WS() {
	while(ceptr>wsptr){ STACK_POP(); }
}


#if defined(DEBUG_STC)
/* debug routine for STACK */
void DEBUG_STC_ALL() {
	register integer_16 p;
	for(p=1;p<=stc_ptr;p++){ DEBUG_STC_CE(p); }
}

void DEBUG_STC_CE(ptr) integer_16 ptr; {
	register integer_16 p,i; integer_16 n,sip,sil;
	p=ptr-1; sip=stc_in_ptr[p]; sil=stc_in_len[p];
	printf(" (%d) iP=%d",ptr,sip+1); printf(":%d",sil);
	/*printf(",oP=%d",stc_out_ptr[p]+1); printf(":%d",stc_out_len[p]);*/
	putchar(','); DEBUG_K1(&inert[sip*2],sil);
	switch(stc_kind[p]){
	case DICKIND_E:  printf(","); break;
	case DICKIND_I:  printf(","); break;
	case DICKIND_D:  printf(","); break;
	case DICKIND_5Y: printf(",Ϣ"); break;
	case DICKIND_K:  printf(",Ҳ̾"); break;
	case DICKIND_T:  printf(",ñ"); break;
	}
	printf(",F2="); DEBUG_H1(stc_f2[p]);
	printf(",CTL="); DEBUG_H1(stc_ctl[p]);
	printf(",MRU="); DEBUG_H1(stc_mru[p]);
	printf(",STZ="); DEBUG_H1(stc_stz[p]);
	printf(",BNO=");
	for(n=stc_nbno[p],i=0;n--;i++){
		printf("%d",stc_bno[p][i]); if(n>0){ putchar(','); }
	}
	putchar('\n');
}			
#endif

/***************************** END OF ILE_STCC.C *****************************/
