/*********************************************
	ILE_SUHC.C	updated at 17th April 1990
	ѿ vs Ѵ
 *********************************************/

#define		EXT		extern

#include	"onsei.h"
#include	"ile_envh.h"
#include	"ile_nydh.h"
#include	"ile_shdh.h"
#include	"ile_func.h"

static const BYTE SuhwKan[10][2];
static const BYTE SuhwKan2[3][2];
static const BYTE SuhwKurai[19][2];


/*========== DIGIT_CONV(sw) ==================================================
	ǽѿ桦κäѴ롣
		ɤ߰Ȥ롣
		󡥻
		ɤߥ⡼ɤΤȤϡơɤ߰Ȥ롣(digit_type =1)
	ϡᣰɤʤ
		ᣱɤ߻ꡣ
		ᣲɤ߻ꡣ
  ============================================================================*/
void DIGIT_CONV(sw) integer_16 sw; {
	register integer_16 ptr,ikind;
	integer_16 cdptr,cdlen,maxlen;
	BYTE al,*kptr;

	digit_type=0;	/* normal type (integer,fraction) */
	digit_mode=0;	/* convert mode (integer) */
	n_kansuji=0;

	if(sw==1){ goto DIGIT_CONV_200; }
	if(sw==2){ digit_type=1; goto DIGIT_CONV_200; }

	if(onsei_addr->onsei_kouseisystem){
		/* ⡼ɤʤ顢ɬɤߤȤ롣--89.11.29-- */
		digit_type=1; goto DIGIT_CONV_200;
	}

	/* ˾䥳ޤޤޤƤȤϡɤ߷ˤϤʤꤨʤ*/
	/* ɤ߷ˤʤΤϡѿȴʰ󻰡ġˤΤߴޤߤ롣*/
	for(ptr=ceptr;ptr<ceptr+celen;++ptr){
		if((inert_kind[ptr]!=CHRKIND_KDigit1)
		&& (inert_kind[ptr]!=CHRKIND_ADigit)){
			/* ѿʳޤȤϡɤ߷ȤϤʤ*/
			goto DIGIT_CONV_200;
		}
	}

	/* 夬ororݤʤСɤ߷Ȥ롣*/
	/* 235-3674, (235)3674, etc.*/
	if((ptr=ceptr-1)!=(-1)){
		ikind=inert[ptr*2]*256+inert[ptr*2+1];
		if(ikind==0x214A || ikind==0x214B || ikind==0x215D){
			digit_type=1;
		}
	}
	if((ptr=ceptr+celen)!=n_inert){
		ikind=inert[ptr*2]*256+inert[ptr*2+1];
		if(ikind==0x214A || ikind==0x214B || ikind==0x215D){
			digit_type=1;
		}
	}

	/* 󤬥ǻϤޤäƤ顢ɤ߷Ȥ롣*/
	/* 03, 0990, etc.*/
	ikind=inert[ceptr*2]*256+inert[ceptr*2+1];
	if(ikind==0x213b || ikind==0x2330){	/*  or  */
		digit_type=1;
	}

DIGIT_CONV_200:;
	ptr=ceptr;

	while(1){
		if(ptr>=ceptr+celen){ return; }

		ikind=inert_kind[ptr];
		if(ikind==CHRKIND_ADigit || ikind==CHRKIND_KDigit1){
			cdptr=ptr; cdlen=1;
			kptr=(&inert_kind[cdptr+cdlen]);
			while(*kptr==CHRKIND_ADigit || *kptr==CHRKIND_KDigit1
			   || *kptr==CHRKIND_DSep){
				++cdlen; ++kptr;
			}
			maxlen=ceptr+celen-cdptr;
			if(cdlen>maxlen){ cdlen=maxlen; }
			DIGIT_CONV1(cdptr,cdlen);
			ptr+=cdlen;
		}else{
			/* if decimal point is found, convert mode changed */
			if(inert_kind[ptr]==CHRKIND_DDP){ digit_mode=1; }
			kansuji[n_kansuji*2]  =inert[ptr*2];
			kansuji[n_kansuji*2+1]=inert[ptr*2+1];
			++n_kansuji; ++ptr;
		}
	}
}


/*========== DIGIT_CONV1(cdptr,cdlen) ==============================
	ϡcdptr					ѴʸΥեå
 			cdlen					Ѵʸ
			digit_mode				=0 : integer type
									=1 : fraction type
			digit_type				=0 : normal mode
									=1 : ɤ type
	ϡkansuji[]				Ѵ
 			n_kansuji				Ѵ̤ʸ
	ǽ߸ɸοѴ롣ʺ20
			20ʾλɤ߷Ȥ롣㡧󻰻͸
	աʸˤϿΥѥ졼ʥˤޤޤ롣
  ==================================================================*/
void DIGIT_CONV1(cdptr,cdlen) integer_16 cdptr,cdlen; {
	/*
	 *	len		: length concludes comma
	 *	net_len	: length without comma
	 */
	register BYTE *si; BYTE ah,al;
	register integer_16 len; integer_16 net_len,dx;

	/* ɤ߷ޤϾ */
	if(digit_mode==1||digit_type==1){ goto DIGIT_CONV1_500; }

	/* ڤӣʾϡɤ߷Ȥ롣*/
	net_len=0;
	for(dx=0;dx<cdlen;++dx){
		if(inert_kind[cdptr+dx]==CHRKIND_ADigit
		|| inert_kind[cdptr+dx]==CHRKIND_KDigit1){
			++net_len;
		}
	}
	if(net_len>20 || net_len==1){ goto DIGIT_CONV1_500; }

	/*  */
	len=cdlen;						/* ѴʸФ */
	si=cdptr*2+inert;				/* ѴʸΥɥ쥹Ф */

	dx=0;
	do{
		ah=(*si++); al=(*si++);

		/* ʤСѿѴ롣*/
		DIGIT_CONV2(&ah,&al);
		/* ʳ̵뤹 */
		if(ah!=0x23 || al<0x30 || al>0x39){ goto DIGIT_CONV1_290; }

		/* Ѵʸξ */
		if(al==0x30){
			/* ̤ʤɤΤȤ̤Ĥ */
			if((net_len & 3)==1){ if(dx){ goto DIGIT_CONV1_240; } }
			/* ѴʸʳλѴʤ */
			if(n_kansuji ||(net_len!=1)){ goto DIGIT_CONV1_270; }
		}
		dx++;
		/* Ѵʸǰ̤ɴǤʤʤ */
		if( (al!=0x31) || ((net_len & 2)==0) ){
			/* ɽƿ */
			kansuji[n_kansuji*2  ]=SuhwKan[al-0x30][0];
			kansuji[n_kansuji*2+1]=SuhwKan[al-0x30][1];
			n_kansuji++;				/* Ѵ̤Ǽ */
		}
		DIGIT_CONV1_240:
		if(net_len!=1){	/* ΰ̤Ǥʤʤ */
			/* Ѵơ֥Υɥ쥹򥻥å */
			kansuji[n_kansuji*2  ]=SuhwKurai[net_len-2][0];
			kansuji[n_kansuji*2+1]=SuhwKurai[net_len-2][1];
			n_kansuji++; /* Ѵ̤Ǽ */
		}
		DIGIT_CONV1_270:
		if(((net_len & 02)==0) && (net_len & 1)){ dx=0; }
		--net_len;
		DIGIT_CONV1_290:;
	}while(--len);
	return;

/* ɤ߷ */
DIGIT_CONV1_500:;
	len=cdlen;						/* ѴʸФ */
	si=cdptr*2+inert;				/* ѴʸΥɥ쥹Ф */
	do{
		ah=(*si++); al=(*si++);

		/* ʤСѿѴ롣*/
		DIGIT_CONV2(&ah,&al);
		/* ʳ̵뤹 */
		if(ah==0x23 && al>=0x30 && al<=0x39){
			kansuji[n_kansuji*2  ]=SuhwKan[al-0x30][0];
			kansuji[n_kansuji*2+1]=SuhwKan[al-0x30][1];
			n_kansuji++;
		}
	}while(--len);
	return;
}


/*========== DIGIT_CONV2(ah,al) ====================================
	ϡah,al					ѿ
	ϡah,al					ѿ
	ǽʤСѿѴ롣
  ==================================================================*/
void DIGIT_CONV2(ah,al) BYTE *ah,*al; {
	integer_16 cx;
	const BYTE* si;
	/* 󻰻͸ϻȬ */
	for(si= &SuhwKan[0][0],cx=0; cx<10; ++cx,si+=2){
		if(*ah==(*si) && *al==(*(si+1))){
			*ah=0x23; *al=0x30+cx; return;
		}
	}
	/*  */
	for(si= &SuhwKan2[0][0],cx=0; cx<3; ++cx,si+=2){
		if(*ah==(*si) && *al==(*(si+1))){
			*ah=0x23; *al=0x31+cx; return;
		}
	}
}

/*  ʡ󻰻͸ϻȬ*/
static const BYTE SuhwKan[10][2]={
	0x21,0x3b,0x30,0x6c,0x46,0x73,0x3b,0x30,0x3b,0x4d,
	0x38,0x5e,0x4f,0x3b,0x3c,0x37,0x48,0x2c,0x36,0x65
};

/*  ʰ*/
static const BYTE SuhwKan2[3][2]={
	0x30,0x6d,0x46,0x75,0x3b,0x32
};

/*  ʽɴɴ鲯ɴɴɴ*/ 
static const BYTE SuhwKurai[19][2]={
	0x3d,0x3d,0x49,0x34,0x40,0x69,0x4b,0x7c,
	0x3d,0x3d,0x49,0x34,0x40,0x69,0x32,0x2f,
	0x3d,0x3d,0x49,0x34,0x40,0x69,0x43,0x7b,
	0x3d,0x3d,0x49,0x34,0x40,0x69,0x35,0x7E,
	0x3d,0x3d,0x49,0x34,0x40,0x69
};


/***************************** END OF ILE_SUHC.C *****************************/
