/*
 ***********************************************************************
 *
 *                           Coryright (c)
 *     Digital Equipment Corporation 1995. All rights reserved.
 *
 *    Restricted Rights: Use, duplication, or disclosure by the U.S.
 *    Government is subject to restrictions as set forth in subparagraph
 *    (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
 *    52.227-14 Alt. III, as applicable.
 *
 *    This software is proprietary to and embodies the confidential
 *    technology of Digital Equipment Corporation and other parties.
 *    Possession, use, or copying of this software and media is authorized
 *    only pursuant to a valid written license from Digital or an
 *    authorized sublicensor.
 *
 ***********************************************************************
 *    File Name:	lshomo.c
 *    Author:
 *    Creation Date:
 *
 *    Functionality:
 *
 ***********************************************************************
 *    Revision History:
 *
 * Rev  Who     Date            Description
 * ---------------------------------------------------------------------
 * 001  GL      4/29/96         move the pronunce (primary and secondary)
 *								flag checking before formclass checking.
 *                              also fix the bug of "to lead"
 * 002	GL		11/04/96		force to use the primary for the first word.
 */
 
#ifdef HOMOGRAPHS

#include	"lsdef.h"
#include	"lsconst.h"
#include	"homo.h"

/*#define HDEBUG 1*/
#define	DEP			(*entry_primary)
#define	DES			(*entry_secondary)
#define	DICT_HEAD	((struct dic_entry far * far *)KS.fdic)
#define	HTAB			homo_table[i]

extern unsigned long fc_struct[];
extern int fc_index;
extern int base;

extern const unsigned char main_dict[];

/*
 *  homo() disambiguates between two dictionary homographs ...
 */


struct dic_entry far *homo(int index)
{
	struct dic_entry far *entry_temporary;
	struct dic_entry far *entry_primary;
	struct dic_entry far *entry_secondary;
	int	i,try_other;
	int dict_base;
	int dict_offset;
	int dict_index;

	dict_base=(int)(main_dict+8);
	dict_offset=(*(int *)(main_dict))*4;
/*
 *  homograph is either right before this or right after ...
 */

	dict_index=((int *)(main_dict))[index+2-1];
	entry_primary=(struct dic_entry *)(dict_base+dict_index+dict_offset);

//	entry_primary = DICT_HEAD[index-1];

	dict_index=((int *)(main_dict))[index+2];
	entry_secondary=(struct dic_entry *)(dict_base+dict_index+dict_offset);
	
//	entry_secondary = DICT_HEAD[index];


	try_other = true;

	if(DES.fc & FC_HOMOGRAPH)
		{
		for(i=0;DES.text[i];i++)
			{
			if(DEP.text[i] != DES.text[i])
				{
#ifdef HDEBUG
				printf("at2 %d %d \n",entry_primary,entry_secondary);

				printf("landed incor \n");
#endif
				break;
				}
			}
		if(DEP.text[i] == '\0' && DES.text[i] == '\0')
			{
 #ifdef HDEBUG

			printf("landed cor \n");
#endif

			try_other = false;
			}
		}
	if(try_other)
		{
		index++;
	dict_index=((int *)(main_dict))[index+2-1];
	entry_primary=(struct dic_entry *)(dict_base+dict_index+dict_offset);

//	entry_primary = DICT_HEAD[index-1];

	dict_index=((int *)(main_dict))[index+2];
	entry_secondary=(struct dic_entry *)(dict_base+dict_index+dict_offset);
	
//	entry_secondary = DICT_HEAD[index];
		if(DES.fc & FC_HOMOGRAPH)
			{

			for(i=0;DES.text[i];i++)
				{
				if(DEP.text[i] != DES.text[i])
					{
#ifdef HDEBUG

					printf("plus and minus failed???");
#endif
					break;

					}
				}
			if(DEP.text[i] == '\0' && DES.text[i] == '\0')
				{
				/*match on + code so primnary=index+1 */
#ifdef HDEBUG

				printf("gtcha. reversing.");
#endif
				if(DES.fc & FC_CHARACTER)
					{

					entry_primary = entry_secondary;


					dict_index=((int *)(main_dict))[index+2];
					entry_secondary=(struct dic_entry *)(dict_base+dict_index+dict_offset);
	
					//	entry_secondary = DICT_HEAD[index];
					
#ifdef HDEBUG

		printf("rever again");
#endif
		}	

				/*base=index;*/
				try_other = false;
				}
			}
			
		}
	if(try_other)
		{
		return(entry_primary);
		}

/*
 *  set the primary and secondary field correctly ...
 */

/*	if(DES.fc & FC_CHARACTER)
		{
		entry_primary = entry_secondary;
		entry_secondary = DICT_HEAD[index];
#ifdef HDEBUG

		printf("rever again");
#endif
		} */


/*
 *  change 4/29/96, GL 
 *  both primary and alternate only apply to next word only.
 */

	if(KS.pronflag & PRON_DIC_PRIMARY)
	{
		KS.pronflag &= (~PRON_DIC_PRIMARY);
		return(entry_primary);
	}
	if(KS.pronflag & PRON_DIC_ALTERNATE)
	{
		KS.pronflag &= (~PRON_DIC_ALTERNATE);
		return(entry_secondary);
	}
	/*
	   force the first word to pick up the verb. this may not be 10% right but is better
	   then dangling there
	   GL 11/04/1996, force to use the primary for the first word. This could still
	   break some other words.  We need to find out the formclass of next word someday
	 */
	if(fc_index == 1)
	{
	   return(entry_primary);
#if 0
	   if (DEP.fc & FC_VERB) return(entry_primary);
	   if (DES.fc & FC_VERB) return(entry_secondary);
#endif
	}

/*
 *  Now run through the list and try to pick one ...
 */

	for(i=0;i<MAX_HOMO_RULE;i++)
		{

/*
 *  First, if there is no suffix for this rule or the suffix matches a
 *  stripped suffix ...
 */
		if(HTAB.h_suffix == (signed int)0 || ((HTAB.h_suffix & fc_struct[fc_index]) == HTAB.h_suffix))
			{
			if(HTAB.h_context == 0 || (HTAB.h_context & fc_struct[fc_index-1]))
				{
#ifdef HDEBUG

				printf(" got context at %d \n",i);
#endif
				if(HTAB.h_select)

					{

/*					if( (HTAB.h_select & DEP.fc) == 0)
						{
						break;
						}*/
					
					/* add 4/30/96.  GL  to fix "to lead" problem */	
					if(HTAB.h_select & DEP.fc)
						{
						break;
						}
						
					if(HTAB.h_select & DES.fc)
						{


#ifdef HDEBUG
						printf("changing primary to secondary1. rule i %d\n",i);
				printf(" %d %d \n",entry_primary,entry_secondary);
#endif

						entry_temporary = entry_primary;
						entry_primary = entry_secondary;
						entry_secondary = entry_temporary;

						break;

						}
					}
				if(HTAB.h_elim)
					{
					if(HTAB.h_elim & DES.fc)
						break;
					if(HTAB.h_elim & DEP.fc)
						{


#ifdef HDEBUG
						printf("changing primary to secondary2. rule %d\n",i);
#endif



						entry_temporary = entry_primary;
						entry_primary = entry_secondary;
						entry_secondary = entry_temporary;
						break;
						}
					}
				}
			}
		}

	if((i < MAX_HOMO_RULE) && HTAB.h_suffix)
		{
		fc_struct[fc_index] = DEP.fc;
		}


	return(entry_primary);

}

#endif
#ifdef DIVIDED_LTS_RULES
const unsigned char lsbtab2[] = {
	0x15,0x01,0x16,0x01,0x1A,0x01,0x1E,0x05,
	0x00,0x05,0x1E,0x00,0x1A,0x11,0x7A,0x73,
	0x00,0x15,0x0C,0x20,0x12,0x01,0x02,0x01,
	0x03,0x01,0x04,0x01,0x06,0x01,0x07,0x01,
	0x0B,0x01,0x10,0x01,0x14,0x01,0x1A,0x01,
	0x1E,0x05,0x00,0x05,0x1E,0x00,0x1A,0x11,
	0x7A,0x73,0x00,0x20,0x20,0x14,0x01,0x02,
	0x01,0x04,0x01,0x06,0x01,0x0B,0x01,0x0C,
	0x01,0x0D,0x01,0x0E,0x01,0x10,0x01,0x12,
	0x01,0x14,0x21,0x02,0x00,0x02,0x00,0x21,
	0x04,0x00,0x04,0x00,0x01,0x1E,0x05,0x00,
	0x1E,0x00,0x1A,0x11,0x7A,0x73,0x00,0x01,
	0x1E,0x1D,0x00,0x1E,0x00,0x2A,0x00,0x01,
	0x22,0x13,0x00,0x1E,0x00,0x2A,0x00,0x01,
	0x22,0x05,0x00,0x00,0x29,0x04,0x00,0x01,
	0x22,0x05,0x00,0x05,0x1E,0x00,0x2A,0x12,
	0x7A,0x00,0x0B,0x20,0x04,0x01,0x13,0x01,
	0x1A,0x21,0x02,0x00,0x02,0x00,0x01,0x22,
	0x05,0x00,0x1E,0x00,0x2A,0x00,0x02,0x08,
	0x13,0x01,0x22,0x05,0x00,0x1E,0x00,0x2A,
	0x00,0x0F,0x0F,0x1F,0x01,0x63,0x05,0x21,
	0x04,0x00,0x04,0x00,0x21,0x02,0x00,0x02,
	0x00,0x01,0x22,0x13,0x00,0x00,0x29,0x00,
	0x01,0x22,0x00,0x29,0x00,0x0F,0x21,0x02,
	0x00,0x02,0x00,0x1F,0x00,0x64,0x05,0x21,
	0x04,0x00,0x04,0x00,0x22,0x01,0x1E,0x1E,
	0x00,0x2A,0x00,0x01,0x22,0x00,0x74,0x00,
	0x1D,0x00,0x1E,0x00,0x30,0x00,0x01,0x22,
	0x0C,0x1D,0x00,0x1E,0x00,0x22,0x00,0x05,
	0x21,0x04,0x00,0x04,0x00,0x01,0x22,0x0C,
	0x1D,0x00,0x1E,0x00,0x1B,0x00,0x1D,0x00,
	0x1E,0x00,0x1F,0x00,0x01,0x22,0x12,0x1D,
	0x00,0x1E,0x00,0x1A,0x00,0x01,0x22,0x16,
	0x1D,0x00,0x1E,0x00,0x26,0x11,0x00,0x05,
	0x21,0x04,0x00,0x04,0x00,0x01,0x22,0x16,
	0x1D,0x00,0x1E,0x00,0x26,0x00,0x0E,0x00,
	0x1E,0x00,0x20,0x00,0x0F,0x21,0x02,0x00,
	0x02,0x00,0x1F,0x01,0x01,0x05,0x21,0x04,
	0x00,0x04,0x00,0x22,0x0E,0x00,0x1E,0x00,
	0x24,0x00,0x00,0x11,0x00,0x01,0x22,0x00,
	0x06,0x00,0x00,0x11,0x00,0x01,0x22,0x00,
	0x06,0x00,0x00,0x85,0x11,0x00,0x01,0x0E,
	0x00,0x86,0x11,0x00,0x00,0x11,0x00,0x01,
	0x22,0x00,0x06,0x00,0x00,0x06,0x00,0x12,
	0x1F,0x00,0x01,0x05,0x21,0x02,0x00,0x02,
	0x00,0x1F,0x01,0x63,0x05,0x21,0x04,0x00,
	0x04,0x00,0x03,0x0C,0x0D,0x1E,0x00,0x0A,
	0x00,0x07,0x1C,0x1F,0x00,0x01,0x01,0x13,
	0x1E,0x0F,0x20,0x0D,0x02,0x13,0x08,0x01,
	0x04,0x01,0x0C,0x01,0x0E,0x01,0x12,0x01,
	0x14,0x00,0x05,0x00,0x09,0x1F,0x00,0x64,
	0x05,0x21,0x04,0x00,0x04,0x00,0x08,0x0C,
	0x20,0x04,0x01,0x06,0x01,0x10,0x1E,0x00,
	0x8A,0x11,0x00,0x07,0x0C,0x21,0x04,0x00,
	0x04,0x00,0x1E,0x00,0x0A,0x00,0x01,0x1C,
	0x0B,0x12,0x20,0x08,0x05,0x21,0x04,0x00,
	0x04,0x00,0x01,0x22,0x00,0x05,0x00,0x03,
	0x1C,0x05,0x1E,0x00,0x03,0x00,0x05,0x21,
	0x04,0x10,0x04,0x00,0x08,0x13,0x14,0x20,
	0x04,0x01,0x05,0x01,0x19,0x00,0x05,0x00,
	0x0A,0x20,0x08,0x02,0x10,0x13,0x02,0x04,
	0x07,0x01,0x18,0x00,0x03,0x00,0x02,0x17,
	0x22,0x0F,0x20,0x08,0x01,0x06,0x01,0x0E,
	0x01,0x04,0x01,0x16,0x21,0x02,0x00,0x02,
	0x00,0x00,0x0A,0x00,0x0B,0x17,0x20,0x08,
	0x05,0x21,0x02,0x00,0x00,0x00,0x01,0x22,
	0x05,0x21,0x84,0x00,0x04,0x00,0x00,0x06,
	0x00,0x11,0x12,0x20,0x0E,0x09,0x1F,0x01,
	0x63,0x05,0x21,0x04,0x40,0x04,0x00,0x01,
	0x22,0x01,0x1E,0x00,0x86,0x11,0x00,0x05,
	0x21,0x04,0x00,0x04,0x00,0x01,0x1E,0x00,
	0x03,0x00,0x08,0x21,0x04,0x00,0x04,0x00,
	0x0C,0x05,0x1E,0x00,0x03,0x00,0x01,0x22,
	0x08,0x20,0x06,0x02,0x13,0x19,0x02,0x14,
	0x08,0x00,0x05,0x00,0x02,0x0C,0x16,0x00,
	0x03,0x00,0x03,0x0E,0x07,0x05,0x00,0x85,
	0x12,0x00,0x10,0x21,0x00,0x01,0x00,0x01,
	0x21,0x04,0x00,0x04,0x00,0x21,0x02,0x00,
	0x02,0x00,0x1E,0x00,0x85,0x11,0x00,0x0A,
	0x21,0x04,0x00,0x04,0x00,0x21,0x04,0x02,
	0x04,0x02,0x00,0x86,0x11,0x00,0x07,0x21,
	0x04,0x00,0x04,0x00,0x01,0x1E,0x00,0x83,
	0x11,0x00,0x0F,0x1F,0x00,0x02,0x05,0x21,
	0x04,0x00,0x04,0x00,0x21,0x02,0x00,0x02,
	0x00,0x1E,0x00,0x83,0x11,0x00,0x01,0x16,
	0x06,0x12,0x21,0x02,0x00,0x02,0x00,0x00,
	0x85,0x11,0x00,0x0A,0x1F,0x01,0x63,0x05,
	0x21,0x04,0x40,0x04,0x00,0x1E,0x00,0x85,
	0x11,0x00,0x00,0x2E,0x00,0x00,0x36,0x00,
	0x06,0x20,0x04,0x01,0x05,0x01,0x09,0x00,
	0x31,0x00,0x00,0x36,0x00,0x06,0x20,0x04,
	0x01,0x05,0x01,0x09,0x00,0x31,0x00,0x00,
	0x29,0x00,0x06,0x20,0x04,0x01,0x05,0x01,
	0x09,0x00,0x31,0x00,0x00,0x36,0x00,0x0D,
	0x05,0x21,0x04,0x00,0x04,0x00,0x21,0x04,
	0x00,0x04,0x00,0x0F,0x22,0x00,0x29,0x00,
	0x01,0x22,0x02,0x01,0x05,0x00,0x29,0x00,
	0x08,0x20,0x06,0x01,0x09,0x01,0x05,0x01,
	0x19,0x00,0x31,0x00,0x00,0x30,0x00,0x00,
	0x03,0x00,0x00,0x84,0x11,0x00,0x01,0x12,
	0x00,0x01,0x00,0x01,0x22,0x00,0x04,0x00,
	0x00,0x03,0x00,0x00,0x01,0x00,0x0A,0x1F,
	0x01,0x63,0x05,0x21,0x04,0x00,0x04,0x00,
	0x22,0x01,0x1E,0x00,0x00,0x05,0x21,0x01,
	0x00,0x01,0x00,0x01,0x1E,0x00,0x84,0x11,
	0x00,0x02,0x18,0x05,0x00,0x81,0x11,0x00,
	0x02,0x1A,0x22,0x08,0x20,0x06,0x01,0x12,
	0x01,0x0E,0x01,0x02,0x00,0x81,0x11,0x00,
	0x12,0x12,0x21,0x02,0x00,0x02,0x00,0x20,
	0x0A,0x05,0x21,0x02,0x00,0x02,0x00,0x01,
	0x22,0x01,0x1E,0x00,0x01,0x00,0x06,0x1C,
	0x21,0x0A,0x00,0x02,0x00,0x00,0x84,0x11,
	0x00,0x11,0x20,0x0F,0x0B,0x12,0x21,0x02,
	0x00,0x02,0x00,0x21,0x04,0x00,0x04,0x00,
	0x02,0x12,0x12,0x00,0x84,0x12,0x00,0x0A,
	0x21,0x04,0x00,0x04,0x00,0x21,0x04,0x02,
	0x04,0x02,0x00,0x11,0x00,0x06,0x12,0x21,
	0x04,0x00,0x04,0x00,0x00,0x81,0x12,0x00,
	0x0B,0x21,0x04,0x00,0x04,0x00,0x21,0x02,
	0x00,0x02,0x00,0x1E,0x00,0x84,0x12,0x00,
	0x00,0x25,0x00,0x00,0x32,0x00,0x00,0x32,
	0x00,0x00,0x37,0x00,0x06,0x20,0x04,0x01,
	0x05,0x01,0x09,0x00,0x32,0x00,0x00,0x32,
	0x00,0x00,0x2C,0x00,0x06,0x20,0x04,0x01,
	0x05,0x01,0x09,0x00,0x32,0x00,0x00,0x37,
	0x00,0x06,0x20,0x04,0x01,0x05,0x01,0x09,
	0x00,0x32,0x00,0x00,0x32,0x00,0x01,0x22,
	0x0E,0x05,0x20,0x0B,0x02,0x0C,0x04,0x01,
	0x01,0x01,0x05,0x01,0x14,0x01,0x19,0x00,
	0x32,0x00,0x01,0x22,0x13,0x09,0x20,0x10,
	0x01,0x04,0x01,0x06,0x01,0x07,0x01,0x0C,
	0x01,0x0D,0x01,0x12,0x01,0x16,0x01,0x1A,
	0x00,0x32,0x00,0x01,0x22,0x02,0x19,0x0E,
	0x00,0x32,0x00,0x14,0x1F,0x00,0x01,0x01,
	0x07,0x21,0x02,0x00,0x02,0x00,0x1F,0x01,
	0x63,0x05,0x21,0x04,0x00,0x04,0x00,0x22,
	0x02,0x19,0x1E,0x00,0x37,0x00,0x08,0x20,
	0x06,0x01,0x09,0x01,0x19,0x01,0x05,0x00,
	0x32,0x00,0x00,0x0E,0x32,0x00,0x00,0x18,
	0x32,0x00,0x06,0x20,0x04,0x01,0x01,0x01,
	0x09,0x00,0x32,0x00,0x01,0x05,0x00,0x32,
	0x00,0x01,0x22,0x00,0x10,0x32,0x00,0x17,
	0x20,0x15,0x03,0x09,0x14,0x19,0x03,0x0F,
	0x15,0x13,0x04,0x0D,0x05,0x0E,0x14,0x03,
	0x1E,0x05,0x04,0x01,0x12,0x01,0x0C,0x00,
	0x18,0x32,0x00,0x01,0x1E,0x00,0x32,0x00,
	0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,
	0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,
	0x00,0x01,0x22,0x00,0x00,0x03,0x18,0x05,
	0x22,0x00,0x1C,0x00,0x00,0x01,0x00,0x00,
	0x19,0x00,0x05,0x21,0x02,0x00,0x02,0x00,
	0x05,0x21,0x02,0x00,0x02,0x00,0x00,0x01,
	0x00,0x00,0x01,0x00,0x00,0x07,0x00,0x12,
	0x12,0x21,0x02,0x00,0x02,0x00,0x20,0x0A,
	0x05,0x21,0x02,0x00,0x02,0x00,0x01,0x22,
	0x01,0x1E,0x00,0x82,0x12,0x00,0x01,0x22,
	0x11,0x20,0x0F,0x0B,0x12,0x21,0x02,0x00,
	0x02,0x00,0x21,0x04,0x00,0x04,0x00,0x02,
	0x12,0x12,0x00,0x01,0x00,0x0A,0x21,0x04,
	0x00,0x04,0x00,0x21,0x02,0x00,0x02,0x00,
	0x02,0x12,0x22,0x00,0x11,0x00,0x09,0x1F,
	0x00,0x64,0x05,0x21,0x04,0x00,0x04,0x00,
	0x0A,0x12,0x1F,0x00,0x64,0x05,0x21,0x04,
	0x00,0x04,0x00,0x00,0x07,0x00,0x03,0x0C,
	0x03,0x1E,0x01,0x0D,0x00,0x87,0x12,0x00,
	0x08,0x20,0x04,0x01,0x0E,0x01,0x0C,0x04,
	0x1E,0x00,0x07,0x00,0x07,0x07,0x21,0x00,
	0x01,0x00,0x01,0x1E,0x00,0x07,0x00,0x02,
	0x07,0x08,0x00,0x01,0x00,0x0C,0x20,0x09,
	0x02,0x0B,0x13,0x01,0x13,0x01,0x0D,0x01,
	0x14,0x1E,0x01,0x1E,0x00,0x07,0x00,0x0A,
	0x1F,0x00,0x64,0x05,0x21,0x04,0x00,0x04,
	0x00,0x22,0x01,0x1E,0x00,0x01,0x00,0x01,
	0x1E,0x00,0x07,0x00,0x10,0x21,0x04,0x00,
	0x04,0x00,0x21,0x20,0x00,0x20,0x00,0x21,
	0x02,0x00,0x02,0x00,0x1E,0x00,0x07,0x00,
	0x0A,0x1F,0x01,0x63,0x05,0x21,0x04,0x00,
	0x04,0x00,0x22,0x09,0x20,0x05,0x02,0x14,
	0x08,0x01,0x0E,0x05,0x1E,0x00,0x82,0x12,
	0x00,0x0A,0x1F,0x01,0x63,0x05,0x21,0x04,
	0x00,0x04,0x00,0x1E,0x00,0x82,0x12,0x00,
	0x0A,0x21,0x04,0x00,0x04,0x00,0x21,0x04,
	0x02,0x04,0x02,0x00,0x82,0x12,0x00,0x07,
	0x21,0x04,0x00,0x04,0x00,0x09,0x1E,0x00,
	0x87,0x12,0x00,0x0B,0x21,0x04,0x00,0x04,
	0x00,0x21,0x02,0x00,0x02,0x00,0x1E,0x00,
	0x82,0x12,0x00,0x00,0x19,0x00,0x0A,0x21,
	0x02,0x00,0x02,0x00,0x21,0x02,0x00,0x02,
	0x00,0x00,0x37,0x00,0x00,0x19,0x00,0x00,
	0x2C,0x00,0x00,0x19,0x00,0x00,0x37,0x00,
	0x00,0x31,0x00,0x00,0x1B,0x00,0x00,0x22,
	0x00,0x05,0x21,0x04,0x10,0x04,0x00,0x02,
	0x05,0x1E,0x00,0x1B,0x00,0x00,0x1F,0x11,
	0x00,0x07,0x20,0x05,0x02,0x08,0x14,0x01,
	0x13,0x01,0x1E,0x00,0x1F,0x00,0x00,0x20,
	0x00,0x0F,0x00,0x00,0x0B,0x00,0x01,0x22,
	0x00,0x0A,0x00,0x06,0x0E,0x21,0x04,0x00,
	0x04,0x00,0x00,0x0B,0x00,0x00,0x0B,0x00,
	0x01,0x22,0x00,0x0B,0x00,0x00,0x0B,0x00,
	0x00,0x09,0x18,0x00,0x01,0x1E,0x08,0x0E,
	0x1F,0x00,0x01,0x01,0x03,0x05,0x1E,0x00,
	0x0B,0x00,0x07,0x20,0x04,0x01,0x04,0x01,
	0x17,0x22,0x04,0x0E,0x1D,0x14,0x22,0x00,
	0x0D,0x00,0x01,0x17,0x07,0x0C,0x20,0x04,
	0x01,0x06,0x01,0x16,0x00,0x06,0x00,0x07,
	0x20,0x05,0x02,0x0C,0x16,0x01,0x18,0x00,
	0x0B,0x00,0x0A,0x20,0x08,0x01,0x0E,0x01,
	0x10,0x01,0x12,0x01,0x14,0x03,0x0C,0x0C,
	0x1E,0x00,0x0B,0x00,0x06,0x0C,0x21,0x04,
	0x10,0x04,0x00,0x00,0x8B,0x11,0x00,0x12,
	0x12,0x21,0x02,0x00,0x02,0x00,0x20,0x0A,
	0x05,0x21,0x02,0x00,0x02,0x00,0x01,0x22,
	0x01,0x1E,0x00,0x0B,0x00,0x01,0x22,0x01,
	0x12,0x00,0x8A,0x11,0x00,0x11,0x20,0x0F,
	0x0B,0x12,0x21,0x02,0x00,0x02,0x00,0x21,
	0x04,0x00,0x04,0x00,0x02,0x12,0x12,0x00,
	0x8A,0x11,0x00,0x0D,0x12,0x20,0x0A,0x05,
	0x21,0x04,0x00,0x04,0x00,0x01,0x22,0x01,
	0x1E,0x00,0x0B,0x00,0x0B,0x20,0x09,0x02,
	0x08,0x07,0x01,0x0D,0x01,0x08,0x01,0x10,
	0x03,0x13,0x14,0x1E,0x00,0x0A,0x00,0x03,
	0x0E,0x07,0x1E,0x00,0x09,0x00,0x0C,0x20,
	0x0A,0x01,0x0C,0x01,0x02,0x01,0x04,0x01,
	0x08,0x01,0x07,0x02,0x16,0x05,0x00,0x09,
	0x00,0x07,0x20,0x04,0x01,0x03,0x01,0x13,
	0x1E,0x03,0x0D,0x05,0x1E,0x00,0x09,0x00,
	0x07,0x20,0x04,0x01,0x04,0x01,0x0E,0x1E,
	0x03,0x0E,0x05,0x1E,0x00,0x0E,0x00,0x07,
	0x20,0x05,0x01,0x0D,0x02,0x12,0x10,0x03,
	0x16,0x05,0x1E,0x00,0x0E,0x00,0x08,0x20,
	0x06,0x02,0x0C,0x22,0x02,0x08,0x17,0x08,
	0x20,0x05,0x01,0x0D,0x02,0x13,0x05,0x1E,
	0x00,0x0E,0x00,0x06,0x20,0x04,0x01,0x14,
	0x01,0x17,0x03,0x0D,0x02,0x1E,0x00,0x0E,
	0x00,0x0A,0x20,0x07,0x02,0x17,0x14,0x01,
	0x04,0x01,0x14,0x1E,0x01,0x1E,0x00,0x0B,
	0x00,0x07,0x20,0x05,0x02,0x12,0x14,0x01,
	0x02,0x03,0x14,0x08,0x1E,0x00,0x06,0x00,
	0x02,0x04,0x07,0x00,0x06,0x00,0x05,0x13,
	0x14,0x0C,0x05,0x1E,0x00,0x0B,0x00,0x03,
	0x1B,0x05,0x1E,0x00,0x0B,0x00,0x08,0x21,
	0x04,0x00,0x04,0x00,0x0C,0x05,0x1E,0x00,
	0x0B,0x00,0x0A,0x1F,0x01,0x63,0x05,0x21,
	0x04,0x00,0x04,0x00,0x22,0x01,0x1E,0x00,
	0x0B,0x00,0x01,0x1E,0x00,0x86,0x11,0x00,
	0x10,0x21,0x00,0x01,0x00,0x01,0x21,0x04,
	0x00,0x04,0x00,0x21,0x02,0x00,0x02,0x00,
	0x1E,0x00,0x86,0x11,0x00,0x0A,0x21,0x04,
	0x00,0x04,0x00,0x21,0x04,0x02,0x04,0x02,
	0x00,0x8B,0x11,0x00,0x10,0x21,0x04,0x00,
	0x04,0x00,0x21,0x02,0x00,0x02,0x00,0x21,
	0x04,0x00,0x04,0x00,0x1E,0x00,0x8B,0x11,
	0x00,0x0F,0x1F,0x00,0x02,0x05,0x21,0x04,
	0x00,0x04,0x00,0x21,0x02,0x00,0x02,0x00,
	0x1E,0x00,0x86,0x11,0x00,0x0A,0x1F,0x01,
	0x63,0x05,0x21,0x04,0x00,0x04,0x00,0x1E,
	0x00,0x86,0x11,0x00,0x00,0x00,0x01,0x22,
	0x08,0x20,0x06,0x01,0x13,0x01,0x0E,0x01,
	0x14,0x00,0x2D,0x00,0x00,0x31,0x00,0x00,
	0x31,0x00,0x00,0x31,0x00,0x0B,0x21,0x01,
	0x00,0x01,0x00,0x21,0x02,0x00,0x02,0x00,
	0x22,0x00,0x31,0x00,0x11,0x20,0x0F,0x04,
	0x05,0x14,0x14,0x05,0x03,0x05,0x15,0x12,
	0x02,0x05,0x14,0x02,0x0F,0x12,0x00,0x18,
	0x31,0x00,0x00,0x1A,0x00,0x00,0x29,0x00,
	0x00,0x29,0x00,0x00,0x29,0x00,0x00,0x29,
	0x00,0x00,0x29,0x00,0x00,0x2A,0x00,0x03,
	0x15,0x02,0x22,0x06,0x20,0x04,0x01,0x19,
	0x01,0x09,0x00,0x2A,0x00,0x05,0x21,0x00,
	0x80,0x00,0x80,0x03,0x05,0x12,0x16,0x00,
	0x2A,0x00,0x03,0x05,0x12,0x10,0x02,0x05,
	0x12,0x00,0x2A,0x00,0x01,0x17,0x07,0x20,
	0x04,0x01,0x19,0x01,0x05,0x1E,0x00,0x2A,
	0x00,0x05,0x21,0x00,0x80,0x00,0x80,0x01,
	0x0D,0x00,0x2A,0x00,0x0E,0x21,0x02,0x00,
	0x02,0x00,0x20,0x07,0x02,0x08,0x22,0x01,
	0x06,0x01,0x10,0x02,0x05,0x1E,0x00,0x2A,
	0x00,0x10,0x01,0x05,0x20,0x0C,0x01,0x06,
	0x01,0x0D,0x01,0x10,0x01,0x14,0x01,0x0E,
	0x01,0x22,0x00,0x2A,0x00,0x02,0x05,0x05,
	0x02,0x05,0x1E,0x00,0x2A,0x00,0x07,0x09,
	0x20,0x04,0x01,0x0F,0x01,0x15,0x00,0x2A,
	0x00,0x0D,0x15,0x01,0x1F,0x00,0x01,0x01,
	0x0C,0x20,0x04,0x01,0x03,0x01,0x10,0x00,
	0x2A,0x00,0x0A,0x01,0x20,0x07,0x03,0x12,
	0x08,0x10,0x02,0x08,0x10,0x02,0x05,0x1E,
	0x00,0x2A,0x00,0x06,0x05,0x21,0x00,0x01,
	0x00,0x01,0x02,0x05,0x1E,0x00,0x2A,0x00,
	0x0D,0x0F,0x20,0x0A,0x01,0x10,0x01,0x0E,
	0x01,0x08,0x01,0x0C,0x01,0x12,0x02,0x05,
	0x1E,0x00,0x2A,0x00,0x09,0x15,0x20,0x06,
	0x01,0x03,0x01,0x0D,0x01,0x06,0x05,0x21,
	0x02,0x00,0x02,0x00,0x00,0x29,0x00,0x00,
	0x2F,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,
	0x00,0x0E,0x00,0x00,0x03,0x00,0x02,0x02,
	0x22,0x09,0x12,0x20,0x06,0x01,0x09,0x01,
	0x19,0x01,0x05,0x00,0x10,0x00,0x08,0x12,
	0x20,0x04,0x01,0x05,0x01,0x19,0x1E,0x00,
	0x11,0x00,0x01,0x22,0x06,0x12,0x21,0x04,
	0x00,0x04,0x00,0x00,0x10,0x00,0x01,0x22,
	0x11,0x20,0x0A,0x01,0x07,0x01,0x02,0x01,
	0x12,0x01,0x13,0x01,0x14,0x21,0x02,0x00,
	0x02,0x00,0x00,0x02,0x00,0x02,0x02,0x1E,
	0x06,0x13,0x21,0x02,0x00,0x02,0x00,0x00,
	0x11,0x00,0x0D,0x12,0x20,0x0A,0x05,0x21,
	0x04,0x00,0x04,0x00,0x01,0x22,0x01,0x1E,
	0x00,0x90,0x11,0x00,0x11,0x20,0x0F,0x0B,
	0x12,0x21,0x02,0x00,0x02,0x00,0x21,0x04,
	0x00,0x04,0x00,0x02,0x12,0x12,0x00,0x0D,
	0x00,0x09,0x20,0x06,0x01,0x10,0x01,0x06,
	0x01,0x02,0x22,0x08,0x20,0x06,0x02,0x0C,
	0x0C,0x02,0x13,0x08,0x00,0x89,0x11,0x00,
	0x03,0x13,0x03,0x0C,0x00,0x0E,0x00,0x05,
	0x21,0x04,0x00,0x04,0x00,0x03,0x14,0x08,
	0x22,0x00,0x89,0x11,0x00,0x05,0x21,0x04,
	0x00,0x04,0x00,0x13,0x20,0x06,0x01,0x0D,
	0x01,0x0E,0x01,0x0C,0x21,0x04,0x00,0x04,
	0x00,0x21,0x02,0x00,0x02,0x00,0x1E,0x00,
	0x89,0x11,0x00,0x07,0x20,0x05,0x01,0x18,
	0x02,0x04,0x07,0x00,0x0E,0x00,0x07,0x21,
	0x04,0x00,0x04,0x00,0x0C,0x05,0x00,0x89,
	0x11,0x00,0x0A,0x21,0x04,0x00,0x04,0x00,
	0x21,0x04,0x00,0x04,0x00,0x00,0x8E,0x11,
	0x00,0x10,0x21,0x04,0x00,0x04,0x00,0x21,
	0x02,0x00,0x02,0x00,0x21,0x04,0x00,0x04,
	0x00,0x22,0x00,0x89,0x11,0x00,0x0A,0x21,
	0x04,0x00,0x04,0x00,0x21,0x04,0x02,0x04,
	0x02,0x00,0x10,0x00,0x0C,0x20,0x0A,0x01,
	0x03,0x01,0x06,0x01,0x0D,0x01,0x02,0x01,
	0x10,0x0E,0x21,0x04,0x00,0x04,0x00,0x1F,
	0x01,0x01,0x05,0x21,0x02,0x00,0x02,0x00,
	0x00,0x10,0x00,0x05,0x21,0x04,0x40,0x04,
	0x00,0x0B,0x0C,0x21,0x02,0x00,0x02,0x00,
	0x21,0x00,0x80,0x00,0x80,0x00,0x0E,0x00,
	0x0F,0x1F,0x00,0x02,0x05,0x21,0x04,0x00,
	0x04,0x00,0x21,0x02,0x00,0x02,0x00,0x1E,
	0x00,0x89,0x11,0x00,0x0A,0x1F,0x01,0x63,
	0x05,0x21,0x04,0x00,0x04,0x00,0x1E,0x00,
	0x0E,0x00,0x01,0x1E,0x00,0x89,0x11,0x00,
	0x00,0x26,0x00,0x00,0x25,0x00,0x05,0x21,
	0x14,0x00,0x04,0x00,0x00,0x26,0x00,0x00,
	0x18,0x00,0x00,0x2A,0x00,0x01,0x22,0x00,
	0x29,0x31,0x00,0x00,0x19,0x00,0x00,0x01,
	0x00,0x01,0x22,0x00,0x19,0x00,0x01,0x22,
	0x00,0x02,0x00,0x00,0x01,0x00,0x01,0x22,
	0x00,0x19,0x00,0x00,0x19,0x00,0x01,0x1E,
	0x00,0x07,0x00,0x0A,0x1F,0x01,0x63,0x05,
	0x21,0x04,0x00,0x04,0x00,0x22,0x01,0x1E,
	0x00,0x07,0x00,0x0F,0x20,0x0C,0x02,0x13,
	0x10,0x02,0x08,0x14,0x01,0x08,0x01,0x18,
	0x01,0x1A,0x22,0x1E,0x00,0x01,0x7A,0x00,
	0x0F,0x21,0x04,0x00,0x04,0x00,0x21,0x04,
	0x00,0x04,0x00,0x21,0x00,0x80,0x00,0x80,
	0x01,0x1E,0x00,0x01,0x00,0x01,0x1E,0x00,
	0x07,0x00,0x09,0x1F,0x01,0x63,0x05,0x21,
	0x04,0x00,0x04,0x00,0x02,0x05,0x1E,0x00,
	0x07,0x00,0x0F,0x1F,0x01,0x63,0x05,0x21,
	0x04,0x00,0x04,0x00,0x21,0x02,0x00,0x02,
	0x00,0x1E,0x00,0x02,0x00,0x0A,0x21,0x04,
	0x00,0x04,0x00,0x21,0x04,0x02,0x04,0x02,
	0x00,0x82,0x12,0x00,0x0A,0x1F,0x01,0x63,
	0x05,0x21,0x04,0x00,0x04,0x00,0x1E,0x00,
	0x82,0x12,0x00,0x00,0x2A,0x00,0x00,0x00
};

#endif