/*
 *  DECtalk PC extended ansi ascii character set ...
 */



#define	C_BLK		0xa0		/* Blank */
#define	C_IEX		0xa1		/* Inverted exclamation mark */
#define	C_CENT	0xa2		/* Cent */
#define	C_POUN	0xa3		/* Pound */
#define	C_ICUR	0xa4		/* International currency */
#define	C_YEN		0xa5		/* Yen */
#define	C_PIPE	0xa6		/* Pipe */
#define	C_SECT	0xa7		/* Section sign */
#define	C_DIAE	0xa8		/* Diaeresis */
#define	C_COPY	0xa9		/* Copyright */
#define	C_FORD	0xaa		/* Feminine number ordinalizer */
#define	C_DAPL	0xab		/* Left pointing guiellmets */
#define	C_NOT		0xac		/* Logical not */
#define	C_HYPH	0xad		/* Hyphen */
#define	C_REG		0xae		/* Registered sign */
#define	C_MACR	0xaf		/* Macron symbol */

#define	C_RING	0xb0		/* Ring (Degree) */
#define	C_PLMI	0xb1		/* Plus/minus */
#define	C_S2		0xb2		/* Superscipt 2 */
#define	C_S3		0xb3		/* Superscipt 3 */
#define	C_ACA		0xb3		/* Accent accute */
#define	C_MICR	0xb5		/* Micro */
#define	C_PARA	0xb6		/* Paragraph sign */
#define	C_CDOT	0xb7		/* Centered dot */
#define	C_CYDL	0xb8		/* Cedilla */
#define	C_S1		0xb9		/* Superscript 1 */
#define	C_S0		0xba		/* Superscript 0 */
#define	C_DAPR	0xbb		/* Left pointing guiellmets */
#define	C_F14		0xbc		/* Fraction one fourth */
#define	C_F12		0xbd		/* Fraction one half */
#define	C_F34		0xbe		/* Fraction three-fourths */
#define	C_IQU		0xbf		/* Inverted question mark */

#define	C_GR_A	0xc0		/* Grave accent on capital A */
#define	C_AC_A	0xc1		/* Acute accent on capital A */
#define	C_CF_A	0xc2		/* Circumflex accent on capital A */
#define	C_TL_A	0xc3		/* Tilde accent on capital A */
#define	C_UM_A	0xc4		/* Umlaut or diaresis accent on capital A */
#define	C_RI_A	0xc5		/* Ring accent on capital A */
#define	C_AE		0xc6		/* Dipthong A-E ligature */
#define	C_CD_C	0xc7		/* Cedilla accent on capital C */
#define	C_GR_E	0xc8		/* Grave accent on capital E */
#define	C_AC_E	0xc9		/* Acute accent on capital E */
#define	C_CF_E	0xca		/* Circumflex accent on capital E */
#define	C_UM_E	0xcb		/* Umlaut or diaresis accent on capital E */
#define	C_GR_I	0xcc		/* Grave accent on capital I */
#define	C_AC_I	0xcd		/* Acute accent on capital I */
#define	C_CF_I	0xce		/* Circumflex accent on capital I */
#define	C_UM_I	0xcf		/* Umlaut or diaresis accent on capital I */

#define	C_ETH		0xd0		/* Upper case ETH */
#define	C_TL_N	0xd1		/* Tilde accent on capital N */
#define	C_GR_O	0xd2		/* Grave accent on capital O */
#define	C_AC_O	0xd3		/* Acute accent on capital O */
#define	C_CF_O	0xd4		/* Circumflex accent on capital O */
#define	C_TL_O	0xd5		/* Tilde accent on capital O */
#define	C_UM_O	0xd6		/* Umlaut or diaresis accent on capital O */
#define	C_MULT	0xd7		/* Multiply */
#define	C_SL_O	0xd8		/* Upper case O oblique */
#define	C_GR_U	0xd9		/* Grave accent on capital U */
#define	C_AC_U	0xda		/* Acute accent on capital U */
#define	C_CF_U	0xdb		/* Circumflex accent on capital U */
#define	C_UM_U	0xdc		/* Umlaut or diaresis accent on capital U */
#define	C_AC_Y	0xdd		/* Accute accent on capital Y */
#define	C_THORN	0xde		/* Uppercase thorn */
#define	C_esZ		0xdf		/* Lowercase es zet ligature */

#define	C_GR_a	0xe0		/* Grave accent on lowercase a */
#define	C_AC_a	0xe1		/* Acute accent on lowercase a */
#define	C_CF_a	0xe2		/* Circumflex accent on lowercase a */
#define	C_TL_a	0xe3		/* Tilde accent on lowercase a */
#define	C_UM_a	0xe4		/* Umlaut or diaresis accent on lowercase a */
#define	C_RI_a	0xe5		/* Ring accent on lowercase a */
#define	C_ae		0xe6		/* Lowercase a-e ligature */
#define	C_CD_c	0xe7		/* Cedilla accent on lowercase c */
#define	C_GR_e	0xe8		/* Grave accent on lowercase e */
#define	C_AC_e	0xe9		/* Acute accent on lowercase e */
#define	C_CF_e	0xea		/* Circumflex accent on lowercase e */
#define	C_UM_e	0xeb		/* Umlaut or diaresis accent on lowercase e */
#define	C_GR_i	0xec		/* Grave accent on lowercase i */
#define	C_AC_i	0xed		/* Acute accent on lowercase i */
#define	C_CF_i	0xee		/* Circumflex accent on lowercase i */
#define	C_UM_i	0xef		/* Umlaut or diaresis accent on lowercase i */

#define	C_eth		0xf0		/* Lower case eth */
#define	C_TL_n	0xf1		/* Tilde accent on lowercase n */
#define	C_GR_o	0xf2		/* Grave accent on lowercase o */
#define	C_AC_o	0xf3		/* Acute accent on lowercase o */
#define	C_CF_o	0xf4		/* Circumflex accent on lowercase o */
#define	C_TL_o	0xf5		/* Tilde accent on lowercase o */
#define	C_UM_o	0xf6		/* Umlaut or diaresis accent on lowercase o */
#define	C_DIV		0xf7		/* Divide by */
#define	C_SL_o	0xf8		/* Slash accent on lowercase o */
#define	C_GR_u	0xf9		/* Grave accent on lowercase u */
#define	C_AC_u	0xfa		/* Acute accent on lowercase u */
#define	C_CF_u	0xfb		/* Circumflex accent on lowercase u */
#define	C_UM_u	0xfc		/* Umlaut or diaresis accent on lowercase u */
#define	C_AC_y	0xfd		/* Accute accent on lowercase y */
#define	C_thorn	0xfe		/* Lower case thorn */
#define	C_UM_y	0xff 		/* Umlaut or diaresis accent on lowercase y */



#define	C_MORD	0272	/* Masculine number ordinalizer */
#define	C_OE		0327	/* Capital O-E ligature */
#define	C_ss		0337	/* German sharp s (There is no uppercase version!) */
